
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  208 ( 1703),  selected  208 , name 2czv_A
# Molecule2: number of CA atoms  275 ( 2207),  selected  275 , name T0440.pdb
# PARAMETERS: 2czv_A.T0440.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     2_A      -       -           -
LGA    G     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    G     5_A      -       -           -
LGA    G     6_A      -       -           -
LGA    V     7_A      -       -           -
LGA    K     8_A      M       1          3.055
LGA    F     9_A      K       2          1.787
LGA    I    10_A      R       3          1.816
LGA    E    11_A      D       4          1.547
LGA    M    12_A      G       5          1.190
LGA    D    13_A      H       6          1.330
LGA    I    14_A      T       7          1.693
LGA    R    15_A      H       8          0.919
LGA    D    16_A      T       9          2.838
LGA    -       -      E      10           -
LGA    -       -      F      11           -
LGA    -       -      C      12           -
LGA    -       -      P      13           -
LGA    -       -      H      14           -
LGA    -       -      G      15           -
LGA    -       -      T      16           -
LGA    -       -      H      17           -
LGA    -       -      D      18           -
LGA    -       -      D      19           -
LGA    K    17_A      V      20          1.074
LGA    -       -      E      21           -
LGA    E    18_A      E      22          2.847
LGA    A    19_A      M      23          2.259
LGA    Y    20_A      V      24          2.541
LGA    E    21_A      L      25          2.585
LGA    L    22_A      K      26          1.020
LGA    A    23_A      A      27          1.135
LGA    K    24_A      I      28          2.843
LGA    E    25_A      E      29          2.710
LGA    W    26_A      L      30          2.402
LGA    -       -      D      31           -
LGA    F    27_A      F      32          0.784
LGA    D    28_A      D      33          1.424
LGA    E    29_A      E      34          2.180
LGA    V    30_A      Y      35          1.339
LGA    V    31_A      S      36          1.099
LGA    V    32_A      I      37          1.003
LGA    S    33_A      V      38          1.317
LGA    I    34_A      E      39          1.358
LGA    K    35_A      H      40          0.869
LGA    F    36_A      A      41          1.828
LGA    N    37_A      P      42          4.111
LGA    E    38_A      L      43          0.990
LGA    E    39_A      S      44          5.079
LGA    -       -      S      45           -
LGA    -       -      E      46           -
LGA    -       -      F      47           -
LGA    -       -      M      48           -
LGA    -       -      K      49           -
LGA    -       -      N      50           -
LGA    -       -      T      51           -
LGA    -       -      A      52           -
LGA    -       -      G      53           -
LGA    -       -      D      54           -
LGA    -       -      K      55           -
LGA    -       -      E      56           -
LGA    -       -      A      57           -
LGA    -       -      V      58           -
LGA    -       -      T      59           -
LGA    -       -      T      60           -
LGA    -       -      A      61           -
LGA    -       -      S      62           -
LGA    -       -      M      63           -
LGA    -       -      A      64           -
LGA    V    40_A      M      65          5.515
LGA    D    41_A      -       -           -
LGA    K    42_A      S      66           #
LGA    -       -      D      67           -
LGA    -       -      L      68           -
LGA    E    43_A      P      69          1.561
LGA    K    44_A      Y      70          3.313
LGA    L    45_A      Y      71          4.154
LGA    R    46_A      F      72          2.594
LGA    E    47_A      K      73          1.561
LGA    A    48_A      K      74          3.657
LGA    R    49_A      M      75          3.649
LGA    K    50_A      N      76          1.135
LGA    E    51_A      H      77          2.428
LGA    Y    52_A      I      78          2.968
LGA    G    53_A      K      79          2.416
LGA    -       -      K      80           -
LGA    -       -      K      81           -
LGA    -       -      Y      82           -
LGA    -       -      A      83           -
LGA    -       -      S      84           -
LGA    -       -      D      85           -
LGA    -       -      L      86           -
LGA    -       -      L      87           -
LGA    -       -      I      88           -
LGA    K    54_A      H      89          1.911
LGA    V    55_A      I      90          0.797
LGA    A    56_A      G      91          1.242
LGA    I    57_A      F      92          0.940
LGA    L    58_A      E      93          1.049
LGA    L    59_A      V      94          2.061
LGA    S    60_A      D      95          3.566
LGA    N    61_A      Y      96           #
LGA    P    62_A      L      97          3.152
LGA    K    63_A      I      98          4.369
LGA    -       -      G      99           -
LGA    -       -      Y     100           -
LGA    P    64_A      E     101          3.015
LGA    S    65_A      D     102          3.365
LGA    L    66_A      F     103          3.500
LGA    V    67_A      T     104          2.861
LGA    R    68_A      R     105          2.042
LGA    D    69_A      D     106          2.224
LGA    T    70_A      F     107          3.457
LGA    V    71_A      L     108          3.675
LGA    Q    72_A      N     109          2.436
LGA    K    73_A      E     110          2.466
LGA    -       -      Y     111           -
LGA    F    74_A      G     112          1.080
LGA    K    75_A      P     113          4.532
LGA    S    76_A      Q     114          5.017
LGA    Y    77_A      T     115          2.042
LGA    -       -      D     116           -
LGA    L    78_A      D     117          2.382
LGA    I    79_A      G     118          2.764
LGA    Y    80_A      V     119          1.174
LGA    V    81_A      L     120          1.699
LGA    E    82_A      S     121          1.985
LGA    S    83_A      L     122          1.067
LGA    N    84_A      H     123          5.027
LGA    -       -      F     124           -
LGA    -       -      L     125           -
LGA    -       -      E     126           -
LGA    -       -      G     127           -
LGA    -       -      Q     128           -
LGA    -       -      G     129           -
LGA    -       -      G     130           -
LGA    -       -      F     131           -
LGA    -       -      R     132           -
LGA    -       -      S     133           -
LGA    -       -      I     134           -
LGA    -       -      D     135           -
LGA    -       -      F     136           -
LGA    -       -      S     137           -
LGA    -       -      A     138           -
LGA    -       -      E     139           -
LGA    -       -      D     140           -
LGA    -       -      Y     141           -
LGA    -       -      N     142           -
LGA    -       -      E     143           -
LGA    -       -      G     144           -
LGA    -       -      I     145           -
LGA    -       -      V     146           -
LGA    -       -      Q     147           -
LGA    -       -      F     148           -
LGA    -       -      Y     149           -
LGA    -       -      G     150           -
LGA    -       -      G     151           -
LGA    -       -      F     152           -
LGA    -       -      E     153           -
LGA    -       -      Q     154           -
LGA    -       -      A     155           -
LGA    -       -      Q     156           -
LGA    -       -      L     157           -
LGA    -       -      A     158           -
LGA    D    85_A      Y     159          3.769
LGA    L    86_A      L     160          3.519
LGA    R    87_A      E     161           #
LGA    V    88_A      G     162          4.123
LGA    I    89_A      V     163          2.436
LGA    R    90_A      K     164          2.722
LGA    Y    91_A      Q     165          3.486
LGA    S    92_A      S     166          2.843
LGA    I    93_A      I     167          1.847
LGA    E    94_A      E     168          2.772
LGA    -       -      A     169           -
LGA    K    95_A      D     170          3.055
LGA    G    96_A      L     171          6.580
LGA    -       -      G     172           -
LGA    -       -      L     173           -
LGA    -       -      F     174           -
LGA    V    97_A      K     175          3.145
LGA    D    98_A      P     176          2.739
LGA    -       -      R     177           -
LGA    A    99_A      R     178          1.115
LGA    I   100_A      M     179          1.124
LGA    I   101_A      G     180          1.265
LGA    S   102_A      H     181          0.647
LGA    P   103_A      I     182          1.843
LGA    W   104_A      S     183          0.844
LGA    V   105_A      L     184          1.347
LGA    N   106_A      C     185          2.827
LGA    -       -      Q     186           -
LGA    -       -      K     187           -
LGA    -       -      F     188           -
LGA    R   107_A      Q     189           #
LGA    K   108_A      Q     190           -
LGA    -       -      F     191           -
LGA    -       -      F     192           -
LGA    -       -      G     193           -
LGA    -       -      E     194           -
LGA    -       -      D     195           -
LGA    -       -      T     196           -
LGA    -       -      S     197           -
LGA    -       -      D     198           -
LGA    -       -      F     199           -
LGA    -       -      S     200           -
LGA    -       -      E     201           -
LGA    -       -      E     202           -
LGA    D   109_A      V     203           #
LGA    P   110_A      M     204           #
LGA    G   111_A      E     205           -
LGA    I   112_A      K     206           #
LGA    D   113_A      F     207          1.353
LGA    H   114_A      R     208          1.830
LGA    V   115_A      V     209          2.039
LGA    L   116_A      I     210          1.885
LGA    A   117_A      L     211          1.288
LGA    K   118_A      A     212          2.258
LGA    L   119_A      L     213          1.898
LGA    M   120_A      V     214          1.658
LGA    V   121_A      K     215          2.086
LGA    K   122_A      K     216          2.581
LGA    K   123_A      R     217          2.385
LGA    N   124_A      D     218          2.629
LGA    V   125_A      Y     219          2.002
LGA    A   126_A      E     220          1.421
LGA    L   127_A      L     221          0.606
LGA    G   128_A      D     222          0.482
LGA    F   129_A      F     223          1.331
LGA    S   130_A      N     224          1.294
LGA    L   131_A      T     225          1.325
LGA    R   132_A      A     226          1.577
LGA    P   133_A      G     227          2.038
LGA    L   134_A      L     228          1.345
LGA    L   135_A      F     229          0.875
LGA    Y   136_A      K     230          2.325
LGA    S   137_A      P     231          2.415
LGA    N   138_A      L     232          3.868
LGA    P   139_A      -       -           -
LGA    Y   140_A      -       -           -
LGA    E   141_A      C     233          2.592
LGA    R   142_A      G     234          1.390
LGA    A   143_A      -       -           -
LGA    N   144_A      -       -           -
LGA    L   145_A      E     235          2.859
LGA    L   146_A      T     236          4.944
LGA    R   147_A      Y     237           -
LGA    F   148_A      P     238          4.745
LGA    M   149_A      P     239          1.321
LGA    M   150_A      K     240          1.190
LGA    K   151_A      K     241          2.287
LGA    A   152_A      I     242          2.085
LGA    W   153_A      V     243          0.198
LGA    K   154_A      T     244          1.917
LGA    L   155_A      L     245          2.418
LGA    V   156_A      A     246          1.256
LGA    E   157_A      S     247          0.595
LGA    K   158_A      E     248          1.670
LGA    Y   159_A      L     249          1.489
LGA    K   160_A      Q     250          1.211
LGA    V   161_A      I     251          1.168
LGA    R   162_A      P     252          1.657
LGA    R   163_A      F     253          1.054
LGA    F   164_A      V     254          1.311
LGA    L   165_A      Y     255          1.564
LGA    T   166_A      G     256          1.868
LGA    S   167_A      S     257          1.066
LGA    S   168_A      D     258          1.120
LGA    A   169_A      S     259          0.741
LGA    Q   170_A      H     260          0.628
LGA    E   171_A      G     261          0.996
LGA    K   172_A      V     262          0.777
LGA    W   173_A      Q     263          0.775
LGA    D   174_A      D     264          0.756
LGA    V   175_A      I     265          1.226
LGA    R   176_A      G     266          1.902
LGA    Y   177_A      R     267           #
LGA    P   178_A      -       -           -
LGA    R   179_A      -       -           -
LGA    D   180_A      G     268           #
LGA    L   181_A      Y     269          0.729
LGA    I   182_A      S     270          2.977
LGA    S   183_A      T     271          2.745
LGA    L   184_A      Y     272          3.152
LGA    G   185_A      C     273          3.769
LGA    V   186_A      Q     274          1.444
LGA    V   187_A      K     275          4.030
LGA    I   188_A      -       -           -
LGA    G   189_A      -       -           -
LGA    M   190_A      -       -           -
LGA    E   191_A      -       -           -
LGA    I   192_A      -       -           -
LGA    P   193_A      -       -           -
LGA    Q   194_A      -       -           -
LGA    A   195_A      -       -           -
LGA    K   196_A      -       -           -
LGA    A   197_A      -       -           -
LGA    S   198_A      -       -           -
LGA    I   199_A      -       -           -
LGA    S   200_A      -       -           -
LGA    M   201_A      -       -           -
LGA    Y   202_A      -       -           -
LGA    P   203_A      -       -           -
LGA    E   204_A      -       -           -
LGA    I   205_A      -       -           -
LGA    I   206_A      -       -           -
LGA    L   207_A      -       -           -
LGA    K   208_A      -       -           -
LGA    R   209_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  208  275    5.0    161    2.44    13.66     38.108     6.342

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.462151 * X  +   0.084949 * Y  +   0.882723 * Z  + -25.271969
  Y_new =  -0.798809 * X  +  -0.392410 * Y  +   0.455982 * Z  +  60.587681
  Z_new =   0.385124 * X  +  -0.915859 * Y  +  -0.113495 * Z  +  58.130569 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.694089    1.447503  [ DEG:   -97.0642     82.9358 ]
  Theta =  -0.395343   -2.746250  [ DEG:   -22.6515   -157.3485 ]
  Phi   =  -1.046298    2.095295  [ DEG:   -59.9484    120.0516 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2czv_A                                        
REMARK     2: T0440.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2czv_A.T0440.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  208  275   5.0  161   2.44   13.66  38.108
REMARK  ---------------------------------------------------------- 
MOLECULE 2czv_A
HEADER    HYDROLASE                               19-JUL-05   2CZV              
TITLE     CRYSTAL STRUCTURE OF ARCHEAL RNASE P PROTEIN PH1481P IN               
TITLE    2 COMPLEX WITH PH1877P                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBONUCLEASE P PROTEIN COMPONENT 3;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: RNASE P COMPONENT 3;                                        
COMPND   5 EC: 3.1.26.5;                                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: RIBONUCLEASE P PROTEIN COMPONENT 2;                        
COMPND   9 CHAIN: C, D;                                                         
COMPND  10 SYNONYM: RNASE P COMPONENT 2;                                        
COMPND  11 EC: 3.1.26.5;                                                        
COMPND  12 ENGINEERED: YES;                                                     
COMPND  13 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: PH1877;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 CONDONPLUS (DE3) RIL;                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-22B;                                  
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE  12 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE  13 GENE: PH1481;                                                        
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21 CODONPLUS (DE3) RIL;                  
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PET-22B                                   
KEYWDS    RIBONUCLEASE, RNA BINDING PROTEIN, RNA RECOGNITION MOTIF,             
KEYWDS   2 PROTEIN-PROTEIN COMPLEX                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.KAWANO,Y.KAKUTA,T.NAKASHIMA,I.TANAKA,M.KIMURA                       
REVDAT   1   27-JUN-06 2CZV    0                                                
JRNL        AUTH   S.KAWANO,T.NAKASHIMA,Y.KAKUTA,I.TANAKA,M.KIMURA              
JRNL        TITL   CRYSTAL STRUCTURE OF PROTEIN PH1481P IN COMPLEX              
JRNL        TITL 2 WITH PROTEIN PH1877P OF ARCHAEAL RNASE P FROM                
JRNL        TITL 3 PYROCOCCUS HORIKOSHII OT3: IMPLICATION OF DIMER              
JRNL        TITL 4 FORMATION OF THE HOLOENZYME                                  
JRNL        REF    J.MOL.BIOL.                   V. 357   583 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2CZV A    1   212  UNP    O59543   RNP3_PYRHO       1    212             
DBREF  2CZV B    1   212  UNP    O59543   RNP3_PYRHO       1    212             
DBREF  2CZV C    1   120  UNP    O59150   RNP2_PYRHO       1    120             
DBREF  2CZV D    1   120  UNP    O59150   RNP2_PYRHO       1    120             
SEQRES   1 A  212  MET VAL GLY GLY GLY GLY VAL LYS PHE ILE GLU MET ASP          
SEQRES   2 A  212  ILE ARG ASP LYS GLU ALA TYR GLU LEU ALA LYS GLU TRP          
SEQRES   3 A  212  PHE ASP GLU VAL VAL VAL SER ILE LYS PHE ASN GLU GLU          
SEQRES   4 A  212  VAL ASP LYS GLU LYS LEU ARG GLU ALA ARG LYS GLU TYR          
SEQRES   5 A  212  GLY LYS VAL ALA ILE LEU LEU SER ASN PRO LYS PRO SER          
SEQRES   6 A  212  LEU VAL ARG ASP THR VAL GLN LYS PHE LYS SER TYR LEU          
SEQRES   7 A  212  ILE TYR VAL GLU SER ASN ASP LEU ARG VAL ILE ARG TYR          
SEQRES   8 A  212  SER ILE GLU LYS GLY VAL ASP ALA ILE ILE SER PRO TRP          
SEQRES   9 A  212  VAL ASN ARG LYS ASP PRO GLY ILE ASP HIS VAL LEU ALA          
SEQRES  10 A  212  LYS LEU MET VAL LYS LYS ASN VAL ALA LEU GLY PHE SER          
SEQRES  11 A  212  LEU ARG PRO LEU LEU TYR SER ASN PRO TYR GLU ARG ALA          
SEQRES  12 A  212  ASN LEU LEU ARG PHE MET MET LYS ALA TRP LYS LEU VAL          
SEQRES  13 A  212  GLU LYS TYR LYS VAL ARG ARG PHE LEU THR SER SER ALA          
SEQRES  14 A  212  GLN GLU LYS TRP ASP VAL ARG TYR PRO ARG ASP LEU ILE          
SEQRES  15 A  212  SER LEU GLY VAL VAL ILE GLY MET GLU ILE PRO GLN ALA          
SEQRES  16 A  212  LYS ALA SER ILE SER MET TYR PRO GLU ILE ILE LEU LYS          
SEQRES  17 A  212  ARG LEU LYS TYR                                              
SEQRES   1 B  212  MET VAL GLY GLY GLY GLY VAL LYS PHE ILE GLU MET ASP          
SEQRES   2 B  212  ILE ARG ASP LYS GLU ALA TYR GLU LEU ALA LYS GLU TRP          
SEQRES   3 B  212  PHE ASP GLU VAL VAL VAL SER ILE LYS PHE ASN GLU GLU          
SEQRES   4 B  212  VAL ASP LYS GLU LYS LEU ARG GLU ALA ARG LYS GLU TYR          
SEQRES   5 B  212  GLY LYS VAL ALA ILE LEU LEU SER ASN PRO LYS PRO SER          
SEQRES   6 B  212  LEU VAL ARG ASP THR VAL GLN LYS PHE LYS SER TYR LEU          
SEQRES   7 B  212  ILE TYR VAL GLU SER ASN ASP LEU ARG VAL ILE ARG TYR          
SEQRES   8 B  212  SER ILE GLU LYS GLY VAL ASP ALA ILE ILE SER PRO TRP          
SEQRES   9 B  212  VAL ASN ARG LYS ASP PRO GLY ILE ASP HIS VAL LEU ALA          
SEQRES  10 B  212  LYS LEU MET VAL LYS LYS ASN VAL ALA LEU GLY PHE SER          
SEQRES  11 B  212  LEU ARG PRO LEU LEU TYR SER ASN PRO TYR GLU ARG ALA          
SEQRES  12 B  212  ASN LEU LEU ARG PHE MET MET LYS ALA TRP LYS LEU VAL          
SEQRES  13 B  212  GLU LYS TYR LYS VAL ARG ARG PHE LEU THR SER SER ALA          
SEQRES  14 B  212  GLN GLU LYS TRP ASP VAL ARG TYR PRO ARG ASP LEU ILE          
SEQRES  15 B  212  SER LEU GLY VAL VAL ILE GLY MET GLU ILE PRO GLN ALA          
SEQRES  16 B  212  LYS ALA SER ILE SER MET TYR PRO GLU ILE ILE LEU LYS          
SEQRES  17 B  212  ARG LEU LYS TYR                                              
SEQRES   1 C  120  MET MET ARG LYS LEU LYS THR LEU PRO PRO THR LEU ARG          
SEQRES   2 C  120  ASP LYS ASN ARG TYR ILE ALA PHE GLU ILE ILE SER ASP          
SEQRES   3 C  120  GLY ASP PHE THR LYS ASP GLU VAL LYS GLU LEU ILE TRP          
SEQRES   4 C  120  LYS SER SER LEU GLU VAL LEU GLY GLU THR GLY THR ALA          
SEQRES   5 C  120  ILE VAL LYS PRO TRP LEU ILE LYS PHE ASP PRO ASN THR          
SEQRES   6 C  120  LYS THR GLY ILE VAL ARG SER ASP ARG GLU TYR VAL GLU          
SEQRES   7 C  120  TYR LEU ARG PHE ALA LEU MET LEU VAL SER GLU PHE ASN          
SEQRES   8 C  120  GLY LYS ARG LEU ILE ILE ARG THR LEU GLY VAL SER GLY          
SEQRES   9 C  120  THR ILE LYS ARG LEU LYS ARG LYS PHE LEU ALA LYS TYR          
SEQRES  10 C  120  GLY TRP LYS                                                  
SEQRES   1 D  120  MET MET ARG LYS LEU LYS THR LEU PRO PRO THR LEU ARG          
SEQRES   2 D  120  ASP LYS ASN ARG TYR ILE ALA PHE GLU ILE ILE SER ASP          
SEQRES   3 D  120  GLY ASP PHE THR LYS ASP GLU VAL LYS GLU LEU ILE TRP          
SEQRES   4 D  120  LYS SER SER LEU GLU VAL LEU GLY GLU THR GLY THR ALA          
SEQRES   5 D  120  ILE VAL LYS PRO TRP LEU ILE LYS PHE ASP PRO ASN THR          
SEQRES   6 D  120  LYS THR GLY ILE VAL ARG SER ASP ARG GLU TYR VAL GLU          
SEQRES   7 D  120  TYR LEU ARG PHE ALA LEU MET LEU VAL SER GLU PHE ASN          
SEQRES   8 D  120  GLY LYS ARG LEU ILE ILE ARG THR LEU GLY VAL SER GLY          
SEQRES   9 D  120  THR ILE LYS ARG LEU LYS ARG LYS PHE LEU ALA LYS TYR          
SEQRES  10 D  120  GLY TRP LYS                                                  
HET    BOG   1001      20                                                       
HET    BOG   1002      20                                                       
HET    ACY   2001       4                                                       
HET    ACY   2002       4                                                       
HET    ACY   2003       4                                                       
HET    ACY   2004       4                                                       
HET    ACY   2005       4                                                       
HET    ACY   2006       4                                                       
HET    ACY   2007       4                                                       
HET    ACY   2008       4                                                       
HET    ACY   2009       4                                                       
HET    ACY   2010       4                                                       
HET    ACY   2011       4                                                       
HET    ACY   2012       4                                                       
HET    ACY   2013       4                                                       
HET    ACY   2014       4                                                       
HET    ACY   2015       4                                                       
HET    ACY   2016       4                                                       
HETNAM     BOG B-OCTYLGLUCOSIDE                                                 
HETNAM     ACY ACETIC ACID                                                      
FORMUL   5  BOG    2(C14 H28 O6)                                                
FORMUL   7  ACY    16(C2 H4 O2)                                                 
FORMUL  23  HOH   *320(H2 O)                                                    
CRYST1   63.332   76.118  151.276  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   VAL A   2     -37.164  55.403  31.285  1.00 72.98           N  
ATOM      2  CA  VAL A   2     -38.435  56.140  31.032  1.00 72.84           C  
ATOM      3  C   VAL A   2     -39.624  55.183  31.122  1.00 72.16           C  
ATOM      4  O   VAL A   2     -40.783  55.599  31.058  1.00 71.70           O  
ATOM      5  CB  VAL A   2     -38.415  56.804  29.633  1.00 73.75           C  
ATOM      6  CG1 VAL A   2     -39.637  57.693  29.452  1.00 74.21           C  
ATOM      7  CG2 VAL A   2     -37.144  57.618  29.465  1.00 74.38           C  
ATOM      8  N   GLY A   3     -39.328  53.895  31.277  1.00 71.50           N  
ATOM      9  CA  GLY A   3     -40.384  52.903  31.373  1.00 70.19           C  
ATOM     10  C   GLY A   3     -39.955  51.578  31.979  1.00 69.29           C  
ATOM     11  O   GLY A   3     -40.187  50.522  31.387  1.00 68.62           O  
ATOM     12  N   GLY A   4     -39.329  51.625  33.156  1.00 68.46           N  
ATOM     13  CA  GLY A   4     -38.902  50.399  33.806  1.00 66.75           C  
ATOM     14  C   GLY A   4     -37.666  50.488  34.685  1.00 65.46           C  
ATOM     15  O   GLY A   4     -37.685  50.047  35.839  1.00 66.00           O  
ATOM     16  N   GLY A   5     -36.589  51.050  34.142  1.00 63.85           N  
ATOM     17  CA  GLY A   5     -35.348  51.173  34.893  1.00 61.00           C  
ATOM     18  C   GLY A   5     -35.475  51.883  36.227  1.00 59.22           C  
ATOM     19  O   GLY A   5     -35.045  51.365  37.258  1.00 58.29           O  
ATOM     20  N   GLY A   6     -36.061  53.076  36.208  1.00 57.66           N  
ATOM     21  CA  GLY A   6     -36.230  53.834  37.432  1.00 55.65           C  
ATOM     22  C   GLY A   6     -37.492  53.468  38.189  1.00 54.71           C  
ATOM     23  O   GLY A   6     -37.948  52.324  38.149  1.00 54.25           O  
ATOM     24  N   VAL A   7     -38.056  54.451  38.884  1.00 53.66           N  
ATOM     25  CA  VAL A   7     -39.273  54.260  39.667  1.00 51.28           C  
ATOM     26  C   VAL A   7     -40.517  54.445  38.801  1.00 49.13           C  
ATOM     27  O   VAL A   7     -40.554  55.320  37.932  1.00 49.15           O  
ATOM     28  CB  VAL A   7     -39.342  55.276  40.828  1.00 52.35           C  
ATOM     29  CG1 VAL A   7     -40.556  54.995  41.705  1.00 52.82           C  
ATOM     30  CG2 VAL A   7     -38.062  55.219  41.640  1.00 53.01           C  
ATOM     31  N   LYS A   8     -41.534  53.622  39.037  1.00 46.05           N  
ATOM     32  CA  LYS A   8     -42.775  53.727  38.280  1.00 44.10           C  
ATOM     33  C   LYS A   8     -43.500  55.027  38.624  1.00 41.59           C  
ATOM     34  O   LYS A   8     -43.966  55.213  39.747  1.00 40.57           O  
ATOM     35  CB  LYS A   8     -43.688  52.532  38.571  1.00 45.52           C  
ATOM     36  CG  LYS A   8     -43.630  51.432  37.518  1.00 47.92           C  
ATOM     37  CD  LYS A   8     -42.213  50.914  37.322  1.00 50.49           C  
ATOM     38  CE  LYS A   8     -42.144  49.907  36.181  1.00 52.11           C  
ATOM     39  NZ  LYS A   8     -40.747  49.457  35.916  1.00 52.44           N  
ATOM     40  N   PHE A   9     -43.576  55.928  37.650  1.00 38.24           N  
ATOM     41  CA  PHE A   9     -44.247  57.207  37.839  1.00 35.96           C  
ATOM     42  C   PHE A   9     -45.659  57.142  37.290  1.00 34.04           C  
ATOM     43  O   PHE A   9     -45.890  56.609  36.208  1.00 33.67           O  
ATOM     44  CB  PHE A   9     -43.464  58.320  37.138  1.00 37.68           C  
ATOM     45  CG  PHE A   9     -42.155  58.639  37.794  1.00 36.94           C  
ATOM     46  CD1 PHE A   9     -40.988  58.722  37.046  1.00 38.87           C  
ATOM     47  CD2 PHE A   9     -42.090  58.868  39.165  1.00 37.22           C  
ATOM     48  CE1 PHE A   9     -39.770  59.028  37.654  1.00 39.27           C  
ATOM     49  CE2 PHE A   9     -40.881  59.175  39.780  1.00 38.84           C  
ATOM     50  CZ  PHE A   9     -39.721  59.256  39.024  1.00 39.17           C  
ATOM     51  N   ILE A  10     -46.607  57.684  38.042  1.00 32.48           N  
ATOM     52  CA  ILE A  10     -47.994  57.669  37.618  1.00 31.44           C  
ATOM     53  C   ILE A  10     -48.587  59.069  37.583  1.00 31.80           C  
ATOM     54  O   ILE A  10     -48.348  59.871  38.483  1.00 32.20           O  
ATOM     55  CB  ILE A  10     -48.853  56.808  38.562  1.00 29.62           C  
ATOM     56  CG1 ILE A  10     -48.317  55.374  38.599  1.00 33.12           C  
ATOM     57  CG2 ILE A  10     -50.294  56.828  38.104  1.00 29.12           C  
ATOM     58  CD1 ILE A  10     -49.067  54.460  39.555  1.00 32.03           C  
ATOM     59  N   GLU A  11     -49.355  59.349  36.533  1.00 31.50           N  
ATOM     60  CA  GLU A  11     -50.027  60.635  36.372  1.00 31.01           C  
ATOM     61  C   GLU A  11     -51.496  60.371  36.679  1.00 31.08           C  
ATOM     62  O   GLU A  11     -52.225  59.826  35.850  1.00 32.55           O  
ATOM     63  CB  GLU A  11     -49.867  61.151  34.939  1.00 30.74           C  
ATOM     64  CG  GLU A  11     -49.180  62.510  34.821  1.00 28.90           C  
ATOM     65  CD  GLU A  11     -50.022  63.649  35.360  1.00 27.40           C  
ATOM     66  OE1 GLU A  11     -49.602  64.818  35.224  1.00 24.97           O  
ATOM     67  OE2 GLU A  11     -51.104  63.379  35.923  1.00 25.65           O  
ATOM     68  N   MET A  12     -51.925  60.756  37.875  1.00 29.71           N  
ATOM     69  CA  MET A  12     -53.295  60.530  38.321  1.00 31.09           C  
ATOM     70  C   MET A  12     -54.355  61.438  37.709  1.00 31.66           C  
ATOM     71  O   MET A  12     -55.551  61.181  37.860  1.00 32.10           O  
ATOM     72  CB  MET A  12     -53.373  60.671  39.846  1.00 30.91           C  
ATOM     73  CG  MET A  12     -52.529  59.687  40.634  1.00 31.51           C  
ATOM     74  SD  MET A  12     -53.123  57.988  40.532  1.00 34.33           S  
ATOM     75  CE  MET A  12     -54.528  58.070  41.600  1.00 36.24           C  
ATOM     76  N   ASP A  13     -53.947  62.486  37.004  1.00 31.10           N  
ATOM     77  CA  ASP A  13     -54.951  63.397  36.481  1.00 31.39           C  
ATOM     78  C   ASP A  13     -54.711  64.046  35.121  1.00 32.01           C  
ATOM     79  O   ASP A  13     -54.342  65.215  35.041  1.00 31.33           O  
ATOM     80  CB  ASP A  13     -55.206  64.479  37.539  1.00 32.81           C  
ATOM     81  CG  ASP A  13     -56.395  65.348  37.219  1.00 32.36           C  
ATOM     82  OD1 ASP A  13     -57.205  64.967  36.351  1.00 34.24           O  
ATOM     83  OD2 ASP A  13     -56.528  66.415  37.850  1.00 32.28           O  
ATOM     84  N   ILE A  14     -54.931  63.280  34.054  1.00 31.94           N  
ATOM     85  CA  ILE A  14     -54.796  63.787  32.693  1.00 29.90           C  
ATOM     86  C   ILE A  14     -56.228  63.903  32.180  1.00 30.16           C  
ATOM     87  O   ILE A  14     -57.015  62.968  32.324  1.00 29.63           O  
ATOM     88  CB  ILE A  14     -54.011  62.821  31.800  1.00 29.29           C  
ATOM     89  CG1 ILE A  14     -52.578  62.679  32.324  1.00 29.53           C  
ATOM     90  CG2 ILE A  14     -54.022  63.324  30.362  1.00 28.84           C  
ATOM     91  CD1 ILE A  14     -51.778  63.969  32.327  1.00 29.19           C  
ATOM     92  N   ARG A  15     -56.565  65.043  31.586  1.00 28.92           N  
ATOM     93  CA  ARG A  15     -57.926  65.276  31.106  1.00 30.54           C  
ATOM     94  C   ARG A  15     -58.039  65.563  29.616  1.00 30.25           C  
ATOM     95  O   ARG A  15     -58.950  66.273  29.189  1.00 31.62           O  
ATOM     96  CB  ARG A  15     -58.533  66.446  31.873  1.00 29.63           C  
ATOM     97  CG  ARG A  15     -58.220  66.394  33.351  1.00 30.48           C  
ATOM     98  CD  ARG A  15     -58.790  67.579  34.082  1.00 27.25           C  
ATOM     99  NE  ARG A  15     -58.583  67.451  35.517  1.00 27.55           N  
ATOM    100  CZ  ARG A  15     -59.062  68.302  36.412  1.00 25.95           C  
ATOM    101  NH1 ARG A  15     -59.779  69.345  36.014  1.00 27.01           N  
ATOM    102  NH2 ARG A  15     -58.833  68.103  37.703  1.00 27.57           N  
ATOM    103  N   ASP A  16     -57.121  65.024  28.828  1.00 29.37           N  
ATOM    104  CA  ASP A  16     -57.156  65.252  27.392  1.00 29.26           C  
ATOM    105  C   ASP A  16     -56.522  64.098  26.633  1.00 29.49           C  
ATOM    106  O   ASP A  16     -55.574  63.479  27.108  1.00 27.30           O  
ATOM    107  CB  ASP A  16     -56.427  66.549  27.044  1.00 30.36           C  
ATOM    108  CG  ASP A  16     -56.461  66.850  25.563  1.00 30.17           C  
ATOM    109  OD1 ASP A  16     -57.548  67.199  25.055  1.00 32.29           O  
ATOM    110  OD2 ASP A  16     -55.407  66.727  24.908  1.00 31.26           O  
ATOM    111  N   LYS A  17     -57.044  63.822  25.442  1.00 30.76           N  
ATOM    112  CA  LYS A  17     -56.522  62.729  24.637  1.00 31.86           C  
ATOM    113  C   LYS A  17     -55.048  62.910  24.306  1.00 30.94           C  
ATOM    114  O   LYS A  17     -54.228  62.042  24.611  1.00 32.34           O  
ATOM    115  CB  LYS A  17     -57.324  62.580  23.343  1.00 33.61           C  
ATOM    116  CG  LYS A  17     -56.846  61.420  22.488  1.00 35.89           C  
ATOM    117  CD  LYS A  17     -57.669  61.255  21.227  1.00 38.71           C  
ATOM    118  CE  LYS A  17     -57.139  60.093  20.410  1.00 39.80           C  
ATOM    119  NZ  LYS A  17     -57.084  58.843  21.226  1.00 41.42           N  
ATOM    120  N   GLU A  18     -54.708  64.027  23.673  1.00 31.05           N  
ATOM    121  CA  GLU A  18     -53.319  64.279  23.313  1.00 32.18           C  
ATOM    122  C   GLU A  18     -52.428  64.364  24.546  1.00 31.09           C  
ATOM    123  O   GLU A  18     -51.292  63.897  24.529  1.00 30.85           O  
ATOM    124  CB  GLU A  18     -53.203  65.563  22.497  1.00 34.93           C  
ATOM    125  CG  GLU A  18     -53.907  65.493  21.154  1.00 40.87           C  
ATOM    126  CD  GLU A  18     -53.485  66.608  20.226  1.00 43.42           C  
ATOM    127  OE1 GLU A  18     -53.629  67.788  20.607  1.00 46.71           O  
ATOM    128  OE2 GLU A  18     -53.005  66.303  19.113  1.00 47.99           O  
ATOM    129  N   ALA A  19     -52.945  64.965  25.613  1.00 31.39           N  
ATOM    130  CA  ALA A  19     -52.183  65.073  26.849  1.00 31.12           C  
ATOM    131  C   ALA A  19     -51.791  63.655  27.247  1.00 30.49           C  
ATOM    132  O   ALA A  19     -50.632  63.378  27.551  1.00 29.70           O  
ATOM    133  CB  ALA A  19     -53.036  65.712  27.939  1.00 30.70           C  
ATOM    134  N   TYR A  20     -52.775  62.760  27.222  1.00 31.68           N  
ATOM    135  CA  TYR A  20     -52.576  61.351  27.560  1.00 31.86           C  
ATOM    136  C   TYR A  20     -51.443  60.726  26.751  1.00 32.37           C  
ATOM    137  O   TYR A  20     -50.536  60.095  27.304  1.00 31.78           O  
ATOM    138  CB  TYR A  20     -53.870  60.577  27.301  1.00 34.00           C  
ATOM    139  CG  TYR A  20     -53.698  59.078  27.302  1.00 37.27           C  
ATOM    140  CD1 TYR A  20     -53.707  58.353  28.492  1.00 39.01           C  
ATOM    141  CD2 TYR A  20     -53.503  58.382  26.107  1.00 38.72           C  
ATOM    142  CE1 TYR A  20     -53.525  56.972  28.495  1.00 40.78           C  
ATOM    143  CE2 TYR A  20     -53.317  57.004  26.097  1.00 41.87           C  
ATOM    144  CZ  TYR A  20     -53.329  56.304  27.293  1.00 41.74           C  
ATOM    145  OH  TYR A  20     -53.137  54.942  27.283  1.00 42.36           O  
ATOM    146  N   GLU A  21     -51.510  60.901  25.433  1.00 32.50           N  
ATOM    147  CA  GLU A  21     -50.510  60.357  24.524  1.00 31.57           C  
ATOM    148  C   GLU A  21     -49.120  60.840  24.918  1.00 31.02           C  
ATOM    149  O   GLU A  21     -48.150  60.076  24.880  1.00 30.18           O  
ATOM    150  CB  GLU A  21     -50.826  60.782  23.086  1.00 35.61           C  
ATOM    151  CG  GLU A  21     -52.258  60.472  22.650  1.00 40.29           C  
ATOM    152  CD  GLU A  21     -52.481  59.003  22.323  1.00 45.29           C  
ATOM    153  OE1 GLU A  21     -51.778  58.144  22.899  1.00 47.29           O  
ATOM    154  OE2 GLU A  21     -53.374  58.706  21.496  1.00 47.38           O  
ATOM    155  N   LEU A  22     -49.021  62.111  25.296  1.00 29.26           N  
ATOM    156  CA  LEU A  22     -47.736  62.666  25.699  1.00 26.43           C  
ATOM    157  C   LEU A  22     -47.354  62.120  27.068  1.00 25.68           C  
ATOM    158  O   LEU A  22     -46.228  61.676  27.276  1.00 25.78           O  
ATOM    159  CB  LEU A  22     -47.796  64.195  25.754  1.00 27.89           C  
ATOM    160  CG  LEU A  22     -46.524  64.861  26.286  1.00 27.20           C  
ATOM    161  CD1 LEU A  22     -45.327  64.399  25.461  1.00 29.33           C  
ATOM    162  CD2 LEU A  22     -46.665  66.372  26.233  1.00 25.47           C  
ATOM    163  N   ALA A  23     -48.305  62.143  27.996  1.00 25.51           N  
ATOM    164  CA  ALA A  23     -48.054  61.652  29.343  1.00 26.95           C  
ATOM    165  C   ALA A  23     -47.627  60.180  29.321  1.00 28.84           C  
ATOM    166  O   ALA A  23     -46.773  59.769  30.105  1.00 28.47           O  
ATOM    167  CB  ALA A  23     -49.299  61.835  30.206  1.00 25.71           C  
ATOM    168  N   LYS A  24     -48.207  59.393  28.413  1.00 29.71           N  
ATOM    169  CA  LYS A  24     -47.865  57.972  28.308  1.00 31.09           C  
ATOM    170  C   LYS A  24     -46.428  57.739  27.881  1.00 32.58           C  
ATOM    171  O   LYS A  24     -45.915  56.627  27.996  1.00 35.70           O  
ATOM    172  CB  LYS A  24     -48.797  57.265  27.330  1.00 32.21           C  
ATOM    173  CG  LYS A  24     -50.159  56.964  27.902  1.00 32.47           C  
ATOM    174  CD  LYS A  24     -50.069  55.954  29.037  1.00 35.03           C  
ATOM    175  CE  LYS A  24     -49.562  54.602  28.538  1.00 37.47           C  
ATOM    176  NZ  LYS A  24     -49.358  53.634  29.651  1.00 38.62           N  
ATOM    177  N   GLU A  25     -45.782  58.788  27.385  1.00 33.03           N  
ATOM    178  CA  GLU A  25     -44.397  58.695  26.951  1.00 32.59           C  
ATOM    179  C   GLU A  25     -43.444  59.024  28.091  1.00 32.72           C  
ATOM    180  O   GLU A  25     -42.268  58.673  28.045  1.00 32.78           O  
ATOM    181  CB  GLU A  25     -44.127  59.667  25.805  1.00 35.18           C  
ATOM    182  CG  GLU A  25     -44.851  59.356  24.513  1.00 38.37           C  
ATOM    183  CD  GLU A  25     -44.453  60.312  23.408  1.00 41.76           C  
ATOM    184  OE1 GLU A  25     -43.242  60.387  23.102  1.00 42.77           O  
ATOM    185  OE2 GLU A  25     -45.343  60.990  22.849  1.00 45.08           O  
ATOM    186  N   TRP A  26     -43.952  59.709  29.110  1.00 32.41           N  
ATOM    187  CA  TRP A  26     -43.115  60.091  30.241  1.00 32.11           C  
ATOM    188  C   TRP A  26     -43.463  59.395  31.550  1.00 31.27           C  
ATOM    189  O   TRP A  26     -42.617  59.271  32.430  1.00 34.99           O  
ATOM    190  CB  TRP A  26     -43.168  61.604  30.455  1.00 29.35           C  
ATOM    191  CG  TRP A  26     -42.575  62.421  29.346  1.00 30.24           C  
ATOM    192  CD1 TRP A  26     -41.567  62.055  28.494  1.00 29.09           C  
ATOM    193  CD2 TRP A  26     -42.876  63.787  29.045  1.00 29.69           C  
ATOM    194  NE1 TRP A  26     -41.218  63.114  27.688  1.00 29.71           N  
ATOM    195  CE2 TRP A  26     -42.007  64.189  28.006  1.00 30.81           C  
ATOM    196  CE3 TRP A  26     -43.794  64.715  29.558  1.00 28.87           C  
ATOM    197  CZ2 TRP A  26     -42.029  65.479  27.469  1.00 29.97           C  
ATOM    198  CZ3 TRP A  26     -43.816  65.999  29.023  1.00 29.98           C  
ATOM    199  CH2 TRP A  26     -42.939  66.368  27.990  1.00 29.56           C  
ATOM    200  N   PHE A  27     -44.707  58.958  31.689  1.00 30.20           N  
ATOM    201  CA  PHE A  27     -45.126  58.277  32.902  1.00 30.44           C  
ATOM    202  C   PHE A  27     -45.499  56.831  32.596  1.00 33.73           C  
ATOM    203  O   PHE A  27     -46.183  56.550  31.610  1.00 32.63           O  
ATOM    204  CB  PHE A  27     -46.315  59.000  33.538  1.00 28.78           C  
ATOM    205  CG  PHE A  27     -45.994  60.389  34.027  1.00 25.29           C  
ATOM    206  CD1 PHE A  27     -45.746  61.419  33.128  1.00 23.33           C  
ATOM    207  CD2 PHE A  27     -45.947  60.664  35.391  1.00 25.11           C  
ATOM    208  CE1 PHE A  27     -45.456  62.711  33.576  1.00 22.37           C  
ATOM    209  CE2 PHE A  27     -45.657  61.954  35.852  1.00 21.93           C  
ATOM    210  CZ  PHE A  27     -45.412  62.978  34.939  1.00 22.34           C  
ATOM    211  N   ASP A  28     -45.042  55.918  33.447  1.00 35.16           N  
ATOM    212  CA  ASP A  28     -45.312  54.497  33.275  1.00 36.00           C  
ATOM    213  C   ASP A  28     -46.801  54.202  33.221  1.00 35.57           C  
ATOM    214  O   ASP A  28     -47.244  53.340  32.462  1.00 35.81           O  
ATOM    215  CB  ASP A  28     -44.660  53.713  34.412  1.00 38.88           C  
ATOM    216  CG  ASP A  28     -43.149  53.807  34.384  1.00 41.53           C  
ATOM    217  OD1 ASP A  28     -42.532  53.150  33.521  1.00 42.05           O  
ATOM    218  OD2 ASP A  28     -42.575  54.548  35.213  1.00 46.10           O  
ATOM    219  N   GLU A  29     -47.576  54.921  34.024  1.00 35.22           N  
ATOM    220  CA  GLU A  29     -49.017  54.727  34.060  1.00 34.21           C  
ATOM    221  C   GLU A  29     -49.720  56.082  34.085  1.00 33.82           C  
ATOM    222  O   GLU A  29     -49.267  57.013  34.754  1.00 32.54           O  
ATOM    223  CB  GLU A  29     -49.410  53.923  35.303  1.00 38.03           C  
ATOM    224  CG  GLU A  29     -48.662  52.597  35.486  1.00 41.62           C  
ATOM    225  CD  GLU A  29     -49.168  51.490  34.576  1.00 46.14           C  
ATOM    226  OE1 GLU A  29     -50.395  51.250  34.558  1.00 48.60           O  
ATOM    227  OE2 GLU A  29     -48.340  50.850  33.886  1.00 47.50           O  
ATOM    228  N   VAL A  30     -50.828  56.185  33.360  1.00 32.40           N  
ATOM    229  CA  VAL A  30     -51.597  57.425  33.300  1.00 31.90           C  
ATOM    230  C   VAL A  30     -53.081  57.200  33.579  1.00 33.59           C  
ATOM    231  O   VAL A  30     -53.690  56.282  33.025  1.00 33.66           O  
ATOM    232  CB  VAL A  30     -51.467  58.090  31.910  1.00 29.19           C  
ATOM    233  CG1 VAL A  30     -52.342  59.329  31.839  1.00 28.41           C  
ATOM    234  CG2 VAL A  30     -50.026  58.443  31.643  1.00 26.74           C  
ATOM    235  N   VAL A  31     -53.657  58.040  34.439  1.00 34.36           N  
ATOM    236  CA  VAL A  31     -55.078  57.958  34.774  1.00 35.03           C  
ATOM    237  C   VAL A  31     -55.812  59.144  34.154  1.00 35.89           C  
ATOM    238  O   VAL A  31     -55.567  60.297  34.521  1.00 37.64           O  
ATOM    239  CB  VAL A  31     -55.323  57.995  36.305  1.00 34.82           C  
ATOM    240  CG1 VAL A  31     -56.818  57.999  36.588  1.00 35.97           C  
ATOM    241  CG2 VAL A  31     -54.672  56.802  36.974  1.00 36.18           C  
ATOM    242  N   VAL A  32     -56.712  58.865  33.220  1.00 35.04           N  
ATOM    243  CA  VAL A  32     -57.468  59.920  32.560  1.00 35.13           C  
ATOM    244  C   VAL A  32     -58.787  60.196  33.282  1.00 36.06           C  
ATOM    245  O   VAL A  32     -59.580  59.285  33.523  1.00 35.91           O  
ATOM    246  CB  VAL A  32     -57.756  59.553  31.089  1.00 35.06           C  
ATOM    247  CG1 VAL A  32     -58.551  60.661  30.423  1.00 33.85           C  
ATOM    248  CG2 VAL A  32     -56.446  59.314  30.350  1.00 32.54           C  
ATOM    249  N   SER A  33     -59.011  61.463  33.621  1.00 35.64           N  
ATOM    250  CA  SER A  33     -60.214  61.883  34.329  1.00 37.44           C  
ATOM    251  C   SER A  33     -61.312  62.344  33.378  1.00 39.28           C  
ATOM    252  O   SER A  33     -61.055  63.117  32.456  1.00 39.57           O  
ATOM    253  CB  SER A  33     -59.877  63.028  35.294  1.00 36.87           C  
ATOM    254  OG  SER A  33     -58.803  62.680  36.152  1.00 34.63           O  
ATOM    255  N   ILE A  34     -62.535  61.872  33.604  1.00 40.60           N  
ATOM    256  CA  ILE A  34     -63.665  62.267  32.768  1.00 42.89           C  
ATOM    257  C   ILE A  34     -64.523  63.230  33.579  1.00 44.36           C  
ATOM    258  O   ILE A  34     -65.135  62.843  34.574  1.00 45.13           O  
ATOM    259  CB  ILE A  34     -64.513  61.050  32.350  1.00 43.50           C  
ATOM    260  CG1 ILE A  34     -63.607  59.951  31.786  1.00 42.91           C  
ATOM    261  CG2 ILE A  34     -65.531  61.467  31.298  1.00 43.01           C  
ATOM    262  CD1 ILE A  34     -62.815  60.365  30.567  1.00 43.89           C  
ATOM    263  N   LYS A  35     -64.559  64.483  33.139  1.00 46.74           N  
ATOM    264  CA  LYS A  35     -65.294  65.548  33.818  1.00 49.54           C  
ATOM    265  C   LYS A  35     -66.813  65.533  33.642  1.00 52.08           C  
ATOM    266  O   LYS A  35     -67.327  65.638  32.527  1.00 52.01           O  
ATOM    267  CB  LYS A  35     -64.745  66.902  33.357  1.00 49.31           C  
ATOM    268  CG  LYS A  35     -65.328  68.111  34.062  1.00 50.55           C  
ATOM    269  CD  LYS A  35     -64.947  69.386  33.327  1.00 50.69           C  
ATOM    270  CE  LYS A  35     -65.435  70.614  34.060  1.00 52.22           C  
ATOM    271  NZ  LYS A  35     -64.757  70.744  35.374  1.00 55.13           N  
ATOM    272  N   PHE A  36     -67.523  65.419  34.761  1.00 54.88           N  
ATOM    273  CA  PHE A  36     -68.983  65.412  34.774  1.00 57.93           C  
ATOM    274  C   PHE A  36     -69.481  66.459  35.762  1.00 60.72           C  
ATOM    275  O   PHE A  36     -69.059  66.474  36.919  1.00 61.35           O  
ATOM    276  CB  PHE A  36     -69.506  64.037  35.189  1.00 57.10           C  
ATOM    277  CG  PHE A  36     -69.280  62.967  34.166  1.00 56.20           C  
ATOM    278  CD1 PHE A  36     -68.617  61.792  34.505  1.00 55.88           C  
ATOM    279  CD2 PHE A  36     -69.738  63.127  32.863  1.00 56.20           C  
ATOM    280  CE1 PHE A  36     -68.413  60.791  33.562  1.00 55.79           C  
ATOM    281  CE2 PHE A  36     -69.541  62.132  31.911  1.00 56.05           C  
ATOM    282  CZ  PHE A  36     -68.877  60.960  32.263  1.00 55.50           C  
ATOM    283  N   ASN A  37     -70.374  67.334  35.307  1.00 63.57           N  
ATOM    284  CA  ASN A  37     -70.918  68.384  36.164  1.00 66.73           C  
ATOM    285  C   ASN A  37     -72.447  68.411  36.213  1.00 68.77           C  
ATOM    286  O   ASN A  37     -73.048  69.383  36.672  1.00 68.59           O  
ATOM    287  CB  ASN A  37     -70.376  69.747  35.723  1.00 67.35           C  
ATOM    288  CG  ASN A  37     -70.308  69.888  34.217  1.00 67.99           C  
ATOM    289  OD1 ASN A  37     -69.622  69.121  33.541  1.00 67.47           O  
ATOM    290  ND2 ASN A  37     -71.018  70.874  33.683  1.00 68.87           N  
ATOM    291  N   GLU A  38     -73.067  67.333  35.737  1.00 71.42           N  
ATOM    292  CA  GLU A  38     -74.522  67.193  35.739  1.00 73.18           C  
ATOM    293  C   GLU A  38     -74.873  65.761  36.147  1.00 73.97           C  
ATOM    294  O   GLU A  38     -75.441  65.531  37.214  1.00 73.97           O  
ATOM    295  CB  GLU A  38     -75.105  67.509  34.352  1.00 73.90           C  
ATOM    296  CG  GLU A  38     -74.487  66.735  33.187  1.00 74.46           C  
ATOM    297  CD  GLU A  38     -73.123  67.266  32.778  1.00 74.29           C  
ATOM    298  OE1 GLU A  38     -73.043  68.447  32.379  1.00 74.70           O  
ATOM    299  OE2 GLU A  38     -72.135  66.502  32.852  1.00 74.24           O  
ATOM    300  N   GLU A  39     -74.527  64.807  35.289  1.00 75.00           N  
ATOM    301  CA  GLU A  39     -74.766  63.390  35.547  1.00 75.93           C  
ATOM    302  C   GLU A  39     -73.541  62.613  35.100  1.00 76.14           C  
ATOM    303  O   GLU A  39     -72.691  63.137  34.379  1.00 75.89           O  
ATOM    304  CB  GLU A  39     -75.983  62.876  34.772  1.00 76.80           C  
ATOM    305  CG  GLU A  39     -77.320  63.431  35.224  1.00 77.75           C  
ATOM    306  CD  GLU A  39     -78.490  62.677  34.614  1.00 77.68           C  
ATOM    307  OE1 GLU A  39     -78.553  62.572  33.369  1.00 77.07           O  
ATOM    308  OE2 GLU A  39     -79.347  62.190  35.382  1.00 77.88           O  
ATOM    309  N   VAL A  40     -73.452  61.359  35.524  1.00 76.73           N  
ATOM    310  CA  VAL A  40     -72.324  60.522  35.153  1.00 77.60           C  
ATOM    311  C   VAL A  40     -72.685  59.680  33.935  1.00 78.39           C  
ATOM    312  O   VAL A  40     -73.200  58.572  34.072  1.00 78.35           O  
ATOM    313  CB  VAL A  40     -71.922  59.586  36.313  1.00 77.68           C  
ATOM    314  CG1 VAL A  40     -70.683  58.793  35.937  1.00 77.86           C  
ATOM    315  CG2 VAL A  40     -71.670  60.399  37.574  1.00 77.28           C  
ATOM    316  N   ASP A  41     -72.420  60.217  32.746  1.00 79.34           N  
ATOM    317  CA  ASP A  41     -72.713  59.517  31.497  1.00 79.91           C  
ATOM    318  C   ASP A  41     -72.086  58.126  31.537  1.00 80.41           C  
ATOM    319  O   ASP A  41     -70.920  57.945  31.189  1.00 80.68           O  
ATOM    320  CB  ASP A  41     -72.160  60.308  30.306  1.00 80.07           C  
ATOM    321  CG  ASP A  41     -72.584  59.728  28.967  1.00 80.44           C  
ATOM    322  OD1 ASP A  41     -72.278  58.546  28.704  1.00 80.21           O  
ATOM    323  OD2 ASP A  41     -73.221  60.455  28.176  1.00 80.03           O  
ATOM    324  N   LYS A  42     -72.879  57.148  31.962  1.00 81.10           N  
ATOM    325  CA  LYS A  42     -72.430  55.766  32.085  1.00 81.73           C  
ATOM    326  C   LYS A  42     -71.885  55.202  30.772  1.00 82.32           C  
ATOM    327  O   LYS A  42     -71.240  54.153  30.761  1.00 82.30           O  
ATOM    328  CB  LYS A  42     -73.589  54.900  32.588  1.00 81.40           C  
ATOM    329  CG  LYS A  42     -73.178  53.561  33.172  1.00 80.93           C  
ATOM    330  CD  LYS A  42     -74.390  52.810  33.698  1.00 80.69           C  
ATOM    331  CE  LYS A  42     -73.986  51.522  34.391  1.00 80.33           C  
ATOM    332  NZ  LYS A  42     -73.144  51.787  35.589  1.00 79.99           N  
ATOM    333  N   GLU A  43     -72.141  55.905  29.673  1.00 83.12           N  
ATOM    334  CA  GLU A  43     -71.678  55.470  28.357  1.00 84.09           C  
ATOM    335  C   GLU A  43     -70.246  55.904  28.075  1.00 84.03           C  
ATOM    336  O   GLU A  43     -69.330  55.079  28.057  1.00 83.95           O  
ATOM    337  CB  GLU A  43     -72.601  56.018  27.265  1.00 85.28           C  
ATOM    338  CG  GLU A  43     -73.995  55.427  27.292  1.00 86.82           C  
ATOM    339  CD  GLU A  43     -73.977  53.921  27.127  1.00 87.96           C  
ATOM    340  OE1 GLU A  43     -73.474  53.450  26.086  1.00 88.76           O  
ATOM    341  OE2 GLU A  43     -74.460  53.213  28.038  1.00 88.09           O  
ATOM    342  N   LYS A  44     -70.059  57.200  27.844  1.00 83.96           N  
ATOM    343  CA  LYS A  44     -68.738  57.746  27.563  1.00 83.39           C  
ATOM    344  C   LYS A  44     -67.760  57.291  28.636  1.00 82.82           C  
ATOM    345  O   LYS A  44     -66.599  56.996  28.352  1.00 82.89           O  
ATOM    346  CB  LYS A  44     -68.793  59.275  27.530  1.00 83.65           C  
ATOM    347  CG  LYS A  44     -67.437  59.935  27.340  1.00 84.54           C  
ATOM    348  CD  LYS A  44     -67.552  61.451  27.323  1.00 85.13           C  
ATOM    349  CE  LYS A  44     -66.179  62.106  27.263  1.00 85.38           C  
ATOM    350  NZ  LYS A  44     -65.395  61.669  26.075  1.00 85.10           N  
ATOM    351  N   LEU A  45     -68.244  57.230  29.871  1.00 81.98           N  
ATOM    352  CA  LEU A  45     -67.429  56.810  31.003  1.00 81.75           C  
ATOM    353  C   LEU A  45     -66.938  55.378  30.829  1.00 81.91           C  
ATOM    354  O   LEU A  45     -65.805  55.050  31.181  1.00 82.28           O  
ATOM    355  CB  LEU A  45     -68.242  56.915  32.293  1.00 81.22           C  
ATOM    356  CG  LEU A  45     -67.573  56.393  33.565  1.00 80.88           C  
ATOM    357  CD1 LEU A  45     -66.324  57.205  33.863  1.00 81.23           C  
ATOM    358  CD2 LEU A  45     -68.553  56.473  34.720  1.00 80.31           C  
ATOM    359  N   ARG A  46     -67.802  54.529  30.283  1.00 82.10           N  
ATOM    360  CA  ARG A  46     -67.471  53.128  30.068  1.00 81.62           C  
ATOM    361  C   ARG A  46     -66.600  52.927  28.827  1.00 80.92           C  
ATOM    362  O   ARG A  46     -65.718  52.068  28.813  1.00 80.75           O  
ATOM    363  CB  ARG A  46     -68.762  52.309  29.965  1.00 82.18           C  
ATOM    364  CG  ARG A  46     -68.567  50.844  29.621  1.00 82.83           C  
ATOM    365  CD  ARG A  46     -69.027  50.573  28.201  1.00 83.41           C  
ATOM    366  NE  ARG A  46     -70.432  50.925  28.022  1.00 82.87           N  
ATOM    367  CZ  ARG A  46     -71.057  50.938  26.849  1.00 82.87           C  
ATOM    368  NH1 ARG A  46     -70.403  50.622  25.739  1.00 82.30           N  
ATOM    369  NH2 ARG A  46     -72.338  51.269  26.786  1.00 82.91           N  
ATOM    370  N   GLU A  47     -66.842  53.724  27.790  1.00 80.25           N  
ATOM    371  CA  GLU A  47     -66.055  53.624  26.565  1.00 79.76           C  
ATOM    372  C   GLU A  47     -64.678  54.242  26.765  1.00 79.52           C  
ATOM    373  O   GLU A  47     -63.670  53.707  26.296  1.00 79.21           O  
ATOM    374  CB  GLU A  47     -66.761  54.329  25.406  1.00 80.18           C  
ATOM    375  CG  GLU A  47     -65.871  54.510  24.186  1.00 81.16           C  
ATOM    376  CD  GLU A  47     -66.617  55.058  22.989  1.00 81.78           C  
ATOM    377  OE1 GLU A  47     -67.469  54.330  22.437  1.00 82.32           O  
ATOM    378  OE2 GLU A  47     -66.350  56.215  22.601  1.00 82.00           O  
ATOM    379  N   ALA A  48     -64.643  55.377  27.457  1.00 78.84           N  
ATOM    380  CA  ALA A  48     -63.389  56.066  27.728  1.00 77.83           C  
ATOM    381  C   ALA A  48     -62.483  55.130  28.510  1.00 77.02           C  
ATOM    382  O   ALA A  48     -61.265  55.134  28.336  1.00 76.42           O  
ATOM    383  CB  ALA A  48     -63.649  57.334  28.532  1.00 77.97           C  
ATOM    384  N   ARG A  49     -63.094  54.318  29.366  1.00 76.56           N  
ATOM    385  CA  ARG A  49     -62.354  53.371  30.185  1.00 75.92           C  
ATOM    386  C   ARG A  49     -61.688  52.289  29.340  1.00 74.79           C  
ATOM    387  O   ARG A  49     -60.714  51.672  29.768  1.00 74.65           O  
ATOM    388  CB  ARG A  49     -63.286  52.726  31.212  1.00 76.34           C  
ATOM    389  CG  ARG A  49     -62.565  51.875  32.241  1.00 77.50           C  
ATOM    390  CD  ARG A  49     -63.512  51.403  33.328  1.00 78.66           C  
ATOM    391  NE  ARG A  49     -62.795  50.750  34.418  1.00 80.05           N  
ATOM    392  CZ  ARG A  49     -63.374  50.284  35.521  1.00 81.17           C  
ATOM    393  NH1 ARG A  49     -64.685  50.398  35.682  1.00 80.84           N  
ATOM    394  NH2 ARG A  49     -62.640  49.707  36.464  1.00 81.59           N  
ATOM    395  N   LYS A  50     -62.214  52.064  28.140  1.00 73.60           N  
ATOM    396  CA  LYS A  50     -61.654  51.049  27.257  1.00 72.26           C  
ATOM    397  C   LYS A  50     -60.676  51.626  26.242  1.00 70.28           C  
ATOM    398  O   LYS A  50     -59.963  50.880  25.572  1.00 70.68           O  
ATOM    399  CB  LYS A  50     -62.775  50.298  26.530  1.00 73.67           C  
ATOM    400  CG  LYS A  50     -63.657  49.461  27.452  1.00 74.59           C  
ATOM    401  CD  LYS A  50     -64.615  48.576  26.666  1.00 75.37           C  
ATOM    402  CE  LYS A  50     -63.869  47.546  25.822  1.00 75.79           C  
ATOM    403  NZ  LYS A  50     -63.027  46.634  26.649  1.00 75.70           N  
ATOM    404  N   GLU A  51     -60.639  52.950  26.130  1.00 68.12           N  
ATOM    405  CA  GLU A  51     -59.728  53.603  25.192  1.00 65.13           C  
ATOM    406  C   GLU A  51     -58.430  54.033  25.865  1.00 62.11           C  
ATOM    407  O   GLU A  51     -57.385  54.115  25.220  1.00 61.87           O  
ATOM    408  CB  GLU A  51     -60.391  54.829  24.558  1.00 65.93           C  
ATOM    409  CG  GLU A  51     -59.455  55.620  23.652  1.00 67.15           C  
ATOM    410  CD  GLU A  51     -60.138  56.787  22.971  1.00 67.58           C  
ATOM    411  OE1 GLU A  51     -60.683  57.659  23.679  1.00 67.83           O  
ATOM    412  OE2 GLU A  51     -60.128  56.832  21.723  1.00 68.26           O  
ATOM    413  N   TYR A  52     -58.501  54.307  27.164  1.00 58.62           N  
ATOM    414  CA  TYR A  52     -57.329  54.738  27.916  1.00 54.78           C  
ATOM    415  C   TYR A  52     -56.868  53.666  28.893  1.00 54.03           C  
ATOM    416  O   TYR A  52     -55.672  53.503  29.132  1.00 53.79           O  
ATOM    417  CB  TYR A  52     -57.647  56.017  28.690  1.00 51.00           C  
ATOM    418  CG  TYR A  52     -58.099  57.168  27.819  1.00 47.60           C  
ATOM    419  CD1 TYR A  52     -59.326  57.791  28.042  1.00 46.45           C  
ATOM    420  CD2 TYR A  52     -57.294  57.645  26.786  1.00 46.05           C  
ATOM    421  CE1 TYR A  52     -59.743  58.864  27.258  1.00 45.89           C  
ATOM    422  CE2 TYR A  52     -57.701  58.718  25.992  1.00 44.77           C  
ATOM    423  CZ  TYR A  52     -58.925  59.324  26.235  1.00 45.23           C  
ATOM    424  OH  TYR A  52     -59.331  60.392  25.469  1.00 43.92           O  
ATOM    425  N   GLY A  53     -57.824  52.931  29.448  1.00 53.39           N  
ATOM    426  CA  GLY A  53     -57.495  51.898  30.412  1.00 52.72           C  
ATOM    427  C   GLY A  53     -57.896  52.385  31.789  1.00 51.86           C  
ATOM    428  O   GLY A  53     -59.050  52.240  32.191  1.00 52.29           O  
ATOM    429  N   LYS A  54     -56.949  52.971  32.513  1.00 51.04           N  
ATOM    430  CA  LYS A  54     -57.238  53.493  33.842  1.00 50.49           C  
ATOM    431  C   LYS A  54     -57.950  54.834  33.689  1.00 49.34           C  
ATOM    432  O   LYS A  54     -57.391  55.782  33.136  1.00 48.70           O  
ATOM    433  CB  LYS A  54     -55.946  53.672  34.634  1.00 51.50           C  
ATOM    434  CG  LYS A  54     -55.189  52.382  34.875  1.00 53.25           C  
ATOM    435  CD  LYS A  54     -53.914  52.632  35.660  1.00 54.20           C  
ATOM    436  CE  LYS A  54     -53.152  51.340  35.898  1.00 55.40           C  
ATOM    437  NZ  LYS A  54     -51.889  51.568  36.657  1.00 57.91           N  
ATOM    438  N   VAL A  55     -59.187  54.903  34.168  1.00 47.38           N  
ATOM    439  CA  VAL A  55     -59.982  56.121  34.078  1.00 47.77           C  
ATOM    440  C   VAL A  55     -60.612  56.451  35.425  1.00 47.64           C  
ATOM    441  O   VAL A  55     -60.747  55.582  36.284  1.00 48.89           O  
ATOM    442  CB  VAL A  55     -61.098  55.968  33.023  1.00 47.09           C  
ATOM    443  CG1 VAL A  55     -61.937  57.227  32.958  1.00 47.22           C  
ATOM    444  CG2 VAL A  55     -60.484  55.681  31.666  1.00 47.83           C  
ATOM    445  N   ALA A  56     -60.993  57.711  35.608  1.00 47.12           N  
ATOM    446  CA  ALA A  56     -61.611  58.150  36.851  1.00 46.15           C  
ATOM    447  C   ALA A  56     -62.675  59.206  36.585  1.00 46.38           C  
ATOM    448  O   ALA A  56     -62.558  59.996  35.648  1.00 46.43           O  
ATOM    449  CB  ALA A  56     -60.547  58.702  37.796  1.00 46.66           C  
ATOM    450  N   ILE A  57     -63.716  59.214  37.410  1.00 46.48           N  
ATOM    451  CA  ILE A  57     -64.790  60.186  37.258  1.00 48.24           C  
ATOM    452  C   ILE A  57     -64.440  61.474  37.995  1.00 49.20           C  
ATOM    453  O   ILE A  57     -64.204  61.466  39.204  1.00 49.42           O  
ATOM    454  CB  ILE A  57     -66.125  59.658  37.827  1.00 48.26           C  
ATOM    455  CG1 ILE A  57     -66.504  58.340  37.146  1.00 50.11           C  
ATOM    456  CG2 ILE A  57     -67.226  60.692  37.611  1.00 49.07           C  
ATOM    457  CD1 ILE A  57     -67.771  57.707  37.696  1.00 50.20           C  
ATOM    458  N   LEU A  58     -64.408  62.579  37.261  1.00 49.44           N  
ATOM    459  CA  LEU A  58     -64.093  63.874  37.843  1.00 49.98           C  
ATOM    460  C   LEU A  58     -65.338  64.747  37.942  1.00 50.69           C  
ATOM    461  O   LEU A  58     -65.912  65.149  36.929  1.00 51.62           O  
ATOM    462  CB  LEU A  58     -63.027  64.585  37.003  1.00 48.37           C  
ATOM    463  CG  LEU A  58     -62.886  66.096  37.206  1.00 47.68           C  
ATOM    464  CD1 LEU A  58     -62.556  66.404  38.659  1.00 46.37           C  
ATOM    465  CD2 LEU A  58     -61.808  66.627  36.278  1.00 47.17           C  
ATOM    466  N   LEU A  59     -65.748  65.040  39.171  1.00 50.96           N  
ATOM    467  CA  LEU A  59     -66.917  65.874  39.401  1.00 51.76           C  
ATOM    468  C   LEU A  59     -66.484  67.285  39.779  1.00 53.03           C  
ATOM    469  O   LEU A  59     -65.794  67.479  40.777  1.00 53.26           O  
ATOM    470  CB  LEU A  59     -67.768  65.271  40.517  1.00 51.04           C  
ATOM    471  CG  LEU A  59     -68.412  63.915  40.229  1.00 51.73           C  
ATOM    472  CD1 LEU A  59     -69.158  63.429  41.463  1.00 52.59           C  
ATOM    473  CD2 LEU A  59     -69.357  64.039  39.044  1.00 49.98           C  
ATOM    474  N   SER A  60     -66.885  68.268  38.977  1.00 54.48           N  
ATOM    475  CA  SER A  60     -66.533  69.660  39.240  1.00 56.87           C  
ATOM    476  C   SER A  60     -67.733  70.437  39.770  1.00 58.52           C  
ATOM    477  O   SER A  60     -68.777  70.504  39.119  1.00 59.36           O  
ATOM    478  CB  SER A  60     -66.007  70.318  37.965  1.00 57.15           C  
ATOM    479  OG  SER A  60     -66.942  70.203  36.910  1.00 58.95           O  
ATOM    480  N   ASN A  61     -67.570  71.035  40.948  1.00 60.48           N  
ATOM    481  CA  ASN A  61     -68.643  71.784  41.594  1.00 61.89           C  
ATOM    482  C   ASN A  61     -69.924  70.959  41.565  1.00 62.71           C  
ATOM    483  O   ASN A  61     -70.966  71.420  41.101  1.00 63.02           O  
ATOM    484  CB  ASN A  61     -68.865  73.130  40.899  1.00 62.90           C  
ATOM    485  CG  ASN A  61     -67.806  74.156  41.263  1.00 63.69           C  
ATOM    486  OD1 ASN A  61     -67.833  75.289  40.781  1.00 63.81           O  
ATOM    487  ND2 ASN A  61     -66.869  73.764  42.121  1.00 64.33           N  
ATOM    488  N   PRO A  62     -69.851  69.714  42.064  1.00 63.15           N  
ATOM    489  CA  PRO A  62     -70.982  68.785  42.110  1.00 63.81           C  
ATOM    490  C   PRO A  62     -71.970  69.153  43.204  1.00 64.56           C  
ATOM    491  O   PRO A  62     -71.640  69.891  44.133  1.00 64.66           O  
ATOM    492  CB  PRO A  62     -70.319  67.436  42.406  1.00 63.44           C  
ATOM    493  CG  PRO A  62     -68.854  67.662  42.119  1.00 63.27           C  
ATOM    494  CD  PRO A  62     -68.637  69.058  42.570  1.00 63.28           C  
ATOM    495  N   LYS A  63     -73.185  68.627  43.084  1.00 64.94           N  
ATOM    496  CA  LYS A  63     -74.219  68.861  44.078  1.00 64.77           C  
ATOM    497  C   LYS A  63     -74.046  67.698  45.047  1.00 64.59           C  
ATOM    498  O   LYS A  63     -73.744  66.581  44.629  1.00 64.91           O  
ATOM    499  CB  LYS A  63     -75.606  68.789  43.434  1.00 65.52           C  
ATOM    500  CG  LYS A  63     -75.646  69.193  41.965  1.00 66.37           C  
ATOM    501  CD  LYS A  63     -77.042  68.991  41.382  1.00 66.86           C  
ATOM    502  CE  LYS A  63     -77.043  69.092  39.861  1.00 66.62           C  
ATOM    503  NZ  LYS A  63     -76.270  67.989  39.222  1.00 65.94           N  
ATOM    504  N   PRO A  64     -74.219  67.939  46.354  1.00 64.58           N  
ATOM    505  CA  PRO A  64     -74.060  66.845  47.316  1.00 64.77           C  
ATOM    506  C   PRO A  64     -74.797  65.583  46.864  1.00 65.12           C  
ATOM    507  O   PRO A  64     -74.349  64.463  47.114  1.00 65.02           O  
ATOM    508  CB  PRO A  64     -74.640  67.434  48.597  1.00 64.47           C  
ATOM    509  CG  PRO A  64     -74.264  68.882  48.481  1.00 64.44           C  
ATOM    510  CD  PRO A  64     -74.593  69.192  47.035  1.00 64.76           C  
ATOM    511  N   SER A  65     -75.925  65.780  46.188  1.00 65.40           N  
ATOM    512  CA  SER A  65     -76.738  64.674  45.693  1.00 65.71           C  
ATOM    513  C   SER A  65     -76.020  63.885  44.599  1.00 65.87           C  
ATOM    514  O   SER A  65     -76.030  62.653  44.602  1.00 66.56           O  
ATOM    515  CB  SER A  65     -78.069  65.207  45.154  1.00 64.61           C  
ATOM    516  OG  SER A  65     -77.861  66.170  44.135  1.00 63.59           O  
ATOM    517  N   LEU A  66     -75.399  64.602  43.668  1.00 65.84           N  
ATOM    518  CA  LEU A  66     -74.678  63.976  42.565  1.00 65.88           C  
ATOM    519  C   LEU A  66     -73.526  63.120  43.090  1.00 65.86           C  
ATOM    520  O   LEU A  66     -73.203  62.078  42.517  1.00 65.17           O  
ATOM    521  CB  LEU A  66     -74.142  65.055  41.614  1.00 65.23           C  
ATOM    522  CG  LEU A  66     -73.651  64.645  40.221  1.00 65.13           C  
ATOM    523  CD1 LEU A  66     -72.416  63.772  40.326  1.00 64.69           C  
ATOM    524  CD2 LEU A  66     -74.764  63.916  39.488  1.00 65.09           C  
ATOM    525  N   VAL A  67     -72.913  63.561  44.183  1.00 66.75           N  
ATOM    526  CA  VAL A  67     -71.799  62.829  44.774  1.00 67.90           C  
ATOM    527  C   VAL A  67     -72.266  61.503  45.363  1.00 68.84           C  
ATOM    528  O   VAL A  67     -71.669  60.456  45.109  1.00 69.02           O  
ATOM    529  CB  VAL A  67     -71.113  63.655  45.882  1.00 67.51           C  
ATOM    530  CG1 VAL A  67     -69.974  62.857  46.501  1.00 66.88           C  
ATOM    531  CG2 VAL A  67     -70.589  64.959  45.302  1.00 67.55           C  
ATOM    532  N   ARG A  68     -73.335  61.556  46.151  1.00 70.49           N  
ATOM    533  CA  ARG A  68     -73.891  60.361  46.778  1.00 71.38           C  
ATOM    534  C   ARG A  68     -74.213  59.299  45.729  1.00 70.89           C  
ATOM    535  O   ARG A  68     -73.866  58.127  45.883  1.00 70.28           O  
ATOM    536  CB  ARG A  68     -75.163  60.723  47.550  1.00 72.79           C  
ATOM    537  CG  ARG A  68     -75.863  59.538  48.199  1.00 74.95           C  
ATOM    538  CD  ARG A  68     -77.165  59.963  48.863  1.00 76.80           C  
ATOM    539  NE  ARG A  68     -76.950  60.934  49.933  1.00 78.74           N  
ATOM    540  CZ  ARG A  68     -77.923  61.474  50.662  1.00 80.04           C  
ATOM    541  NH1 ARG A  68     -79.188  61.138  50.437  1.00 80.25           N  
ATOM    542  NH2 ARG A  68     -77.634  62.348  51.619  1.00 80.11           N  
ATOM    543  N   ASP A  69     -74.874  59.724  44.660  1.00 70.57           N  
ATOM    544  CA  ASP A  69     -75.260  58.825  43.582  1.00 70.73           C  
ATOM    545  C   ASP A  69     -74.060  58.142  42.925  1.00 70.28           C  
ATOM    546  O   ASP A  69     -74.107  56.952  42.613  1.00 69.86           O  
ATOM    547  CB  ASP A  69     -76.054  59.600  42.526  1.00 71.31           C  
ATOM    548  CG  ASP A  69     -76.552  58.714  41.402  1.00 72.43           C  
ATOM    549  OD1 ASP A  69     -77.309  57.761  41.685  1.00 72.78           O  
ATOM    550  OD2 ASP A  69     -76.189  58.970  40.234  1.00 72.60           O  
ATOM    551  N   THR A  70     -72.985  58.901  42.728  1.00 70.06           N  
ATOM    552  CA  THR A  70     -71.781  58.383  42.088  1.00 69.45           C  
ATOM    553  C   THR A  70     -70.977  57.419  42.954  1.00 69.59           C  
ATOM    554  O   THR A  70     -70.526  56.380  42.478  1.00 68.83           O  
ATOM    555  CB  THR A  70     -70.845  59.533  41.656  1.00 69.00           C  
ATOM    556  OG1 THR A  70     -71.586  60.506  40.907  1.00 68.34           O  
ATOM    557  CG2 THR A  70     -69.719  58.995  40.788  1.00 68.93           C  
ATOM    558  N   VAL A  71     -70.792  57.765  44.223  1.00 70.63           N  
ATOM    559  CA  VAL A  71     -70.021  56.920  45.130  1.00 72.10           C  
ATOM    560  C   VAL A  71     -70.604  55.517  45.264  1.00 72.87           C  
ATOM    561  O   VAL A  71     -69.927  54.594  45.719  1.00 72.88           O  
ATOM    562  CB  VAL A  71     -69.921  57.552  46.538  1.00 72.08           C  
ATOM    563  CG1 VAL A  71     -69.207  58.887  46.453  1.00 72.35           C  
ATOM    564  CG2 VAL A  71     -71.304  57.731  47.132  1.00 72.87           C  
ATOM    565  N   GLN A  72     -71.860  55.359  44.863  1.00 73.75           N  
ATOM    566  CA  GLN A  72     -72.525  54.065  44.944  1.00 75.00           C  
ATOM    567  C   GLN A  72     -72.515  53.351  43.598  1.00 74.86           C  
ATOM    568  O   GLN A  72     -71.847  52.331  43.428  1.00 75.20           O  
ATOM    569  CB  GLN A  72     -73.973  54.242  45.403  1.00 75.49           C  
ATOM    570  CG  GLN A  72     -74.121  54.868  46.774  1.00 77.33           C  
ATOM    571  CD  GLN A  72     -75.566  55.157  47.123  1.00 77.97           C  
ATOM    572  OE1 GLN A  72     -76.240  55.929  46.438  1.00 78.05           O  
ATOM    573  NE2 GLN A  72     -76.053  54.538  48.194  1.00 78.34           N  
ATOM    574  N   LYS A  73     -73.260  53.902  42.648  1.00 74.56           N  
ATOM    575  CA  LYS A  73     -73.371  53.324  41.315  1.00 74.18           C  
ATOM    576  C   LYS A  73     -72.046  53.020  40.621  1.00 73.25           C  
ATOM    577  O   LYS A  73     -72.004  52.201  39.703  1.00 73.50           O  
ATOM    578  CB  LYS A  73     -74.221  54.236  40.424  1.00 74.52           C  
ATOM    579  CG  LYS A  73     -75.689  54.281  40.817  1.00 75.42           C  
ATOM    580  CD  LYS A  73     -76.481  55.211  39.914  1.00 75.62           C  
ATOM    581  CE  LYS A  73     -77.976  55.076  40.162  1.00 76.33           C  
ATOM    582  NZ  LYS A  73     -78.337  55.304  41.589  1.00 76.68           N  
ATOM    583  N   PHE A  74     -70.965  53.666  41.048  1.00 72.07           N  
ATOM    584  CA  PHE A  74     -69.668  53.430  40.422  1.00 70.68           C  
ATOM    585  C   PHE A  74     -68.572  53.129  41.434  1.00 70.04           C  
ATOM    586  O   PHE A  74     -67.540  53.797  41.452  1.00 70.16           O  
ATOM    587  CB  PHE A  74     -69.254  54.641  39.581  1.00 69.95           C  
ATOM    588  CG  PHE A  74     -70.338  55.159  38.684  1.00 69.49           C  
ATOM    589  CD1 PHE A  74     -71.352  55.965  39.192  1.00 69.55           C  
ATOM    590  CD2 PHE A  74     -70.354  54.835  37.332  1.00 69.68           C  
ATOM    591  CE1 PHE A  74     -72.365  56.441  38.366  1.00 70.04           C  
ATOM    592  CE2 PHE A  74     -71.364  55.306  36.499  1.00 69.89           C  
ATOM    593  CZ  PHE A  74     -72.371  56.110  37.016  1.00 69.88           C  
ATOM    594  N   LYS A  75     -68.790  52.120  42.269  1.00 69.20           N  
ATOM    595  CA  LYS A  75     -67.805  51.750  43.280  1.00 68.74           C  
ATOM    596  C   LYS A  75     -66.565  51.103  42.658  1.00 67.72           C  
ATOM    597  O   LYS A  75     -65.619  50.753  43.363  1.00 68.08           O  
ATOM    598  CB  LYS A  75     -68.433  50.798  44.304  1.00 69.56           C  
ATOM    599  CG  LYS A  75     -67.506  50.397  45.447  1.00 71.06           C  
ATOM    600  CD  LYS A  75     -67.002  51.612  46.222  1.00 72.24           C  
ATOM    601  CE  LYS A  75     -68.136  52.353  46.920  1.00 72.42           C  
ATOM    602  NZ  LYS A  75     -68.792  51.519  47.968  1.00 72.01           N  
ATOM    603  N   SER A  76     -66.571  50.952  41.336  1.00 66.06           N  
ATOM    604  CA  SER A  76     -65.441  50.349  40.634  1.00 64.18           C  
ATOM    605  C   SER A  76     -64.560  51.402  39.966  1.00 63.00           C  
ATOM    606  O   SER A  76     -63.472  51.094  39.475  1.00 62.49           O  
ATOM    607  CB  SER A  76     -65.941  49.355  39.582  1.00 64.45           C  
ATOM    608  OG  SER A  76     -66.591  48.253  40.189  1.00 63.86           O  
ATOM    609  N   TYR A  77     -65.038  52.643  39.948  1.00 61.35           N  
ATOM    610  CA  TYR A  77     -64.296  53.749  39.348  1.00 60.11           C  
ATOM    611  C   TYR A  77     -63.689  54.666  40.406  1.00 57.61           C  
ATOM    612  O   TYR A  77     -64.176  54.739  41.533  1.00 56.94           O  
ATOM    613  CB  TYR A  77     -65.214  54.600  38.464  1.00 61.89           C  
ATOM    614  CG  TYR A  77     -65.641  53.965  37.164  1.00 64.88           C  
ATOM    615  CD1 TYR A  77     -66.462  52.838  37.147  1.00 66.38           C  
ATOM    616  CD2 TYR A  77     -65.244  54.510  35.943  1.00 65.91           C  
ATOM    617  CE1 TYR A  77     -66.881  52.272  35.943  1.00 67.40           C  
ATOM    618  CE2 TYR A  77     -65.653  53.952  34.735  1.00 67.07           C  
ATOM    619  CZ  TYR A  77     -66.473  52.836  34.743  1.00 67.80           C  
ATOM    620  OH  TYR A  77     -66.886  52.287  33.550  1.00 69.51           O  
ATOM    621  N   LEU A  78     -62.620  55.364  40.034  1.00 54.91           N  
ATOM    622  CA  LEU A  78     -61.989  56.312  40.942  1.00 51.04           C  
ATOM    623  C   LEU A  78     -62.819  57.583  40.814  1.00 48.93           C  
ATOM    624  O   LEU A  78     -63.121  58.021  39.705  1.00 48.14           O  
ATOM    625  CB  LEU A  78     -60.545  56.594  40.523  1.00 51.07           C  
ATOM    626  CG  LEU A  78     -59.493  55.503  40.728  1.00 50.29           C  
ATOM    627  CD1 LEU A  78     -58.183  55.946  40.108  1.00 50.00           C  
ATOM    628  CD2 LEU A  78     -59.310  55.233  42.213  1.00 51.76           C  
ATOM    629  N   ILE A  79     -63.202  58.166  41.943  1.00 46.94           N  
ATOM    630  CA  ILE A  79     -63.999  59.384  41.913  1.00 45.67           C  
ATOM    631  C   ILE A  79     -63.202  60.574  42.447  1.00 44.18           C  
ATOM    632  O   ILE A  79     -62.721  60.559  43.582  1.00 43.90           O  
ATOM    633  CB  ILE A  79     -65.301  59.212  42.734  1.00 45.95           C  
ATOM    634  CG1 ILE A  79     -66.134  60.493  42.678  1.00 45.32           C  
ATOM    635  CG2 ILE A  79     -64.965  58.846  44.169  1.00 46.88           C  
ATOM    636  CD1 ILE A  79     -66.685  60.811  41.308  1.00 44.74           C  
ATOM    637  N   TYR A  80     -63.056  61.596  41.608  1.00 41.50           N  
ATOM    638  CA  TYR A  80     -62.328  62.807  41.969  1.00 39.34           C  
ATOM    639  C   TYR A  80     -63.328  63.941  42.139  1.00 39.92           C  
ATOM    640  O   TYR A  80     -64.348  63.989  41.445  1.00 39.40           O  
ATOM    641  CB  TYR A  80     -61.334  63.186  40.866  1.00 35.71           C  
ATOM    642  CG  TYR A  80     -60.167  62.238  40.667  1.00 29.73           C  
ATOM    643  CD1 TYR A  80     -59.349  62.352  39.542  1.00 28.31           C  
ATOM    644  CD2 TYR A  80     -59.869  61.244  41.598  1.00 27.12           C  
ATOM    645  CE1 TYR A  80     -58.263  61.504  39.346  1.00 25.07           C  
ATOM    646  CE2 TYR A  80     -58.781  60.387  41.413  1.00 24.93           C  
ATOM    647  CZ  TYR A  80     -57.980  60.526  40.281  1.00 25.35           C  
ATOM    648  OH  TYR A  80     -56.882  59.708  40.096  1.00 24.10           O  
ATOM    649  N   VAL A  81     -63.030  64.862  43.049  1.00 40.19           N  
ATOM    650  CA  VAL A  81     -63.922  65.988  43.287  1.00 41.55           C  
ATOM    651  C   VAL A  81     -63.210  67.335  43.175  1.00 42.99           C  
ATOM    652  O   VAL A  81     -62.162  67.555  43.777  1.00 43.67           O  
ATOM    653  CB  VAL A  81     -64.580  65.888  44.681  1.00 41.51           C  
ATOM    654  CG1 VAL A  81     -65.566  67.030  44.873  1.00 41.33           C  
ATOM    655  CG2 VAL A  81     -65.287  64.549  44.826  1.00 41.74           C  
ATOM    656  N   GLU A  82     -63.799  68.231  42.392  1.00 44.29           N  
ATOM    657  CA  GLU A  82     -63.259  69.567  42.193  1.00 45.85           C  
ATOM    658  C   GLU A  82     -64.253  70.595  42.698  1.00 45.78           C  
ATOM    659  O   GLU A  82     -65.229  70.903  42.018  1.00 46.06           O  
ATOM    660  CB  GLU A  82     -62.997  69.826  40.712  1.00 47.77           C  
ATOM    661  CG  GLU A  82     -61.571  69.581  40.273  1.00 50.80           C  
ATOM    662  CD  GLU A  82     -61.315  70.077  38.866  1.00 50.93           C  
ATOM    663  OE1 GLU A  82     -60.139  70.103  38.455  1.00 53.82           O  
ATOM    664  OE2 GLU A  82     -62.290  70.440  38.171  1.00 51.18           O  
ATOM    665  N   SER A  83     -64.008  71.131  43.886  1.00 45.84           N  
ATOM    666  CA  SER A  83     -64.911  72.122  44.444  1.00 46.62           C  
ATOM    667  C   SER A  83     -64.198  73.157  45.298  1.00 46.39           C  
ATOM    668  O   SER A  83     -63.220  72.857  45.978  1.00 45.47           O  
ATOM    669  CB  SER A  83     -65.994  71.432  45.278  1.00 46.91           C  
ATOM    670  OG  SER A  83     -66.968  72.366  45.711  1.00 48.43           O  
ATOM    671  N   ASN A  84     -64.700  74.385  45.241  1.00 47.77           N  
ATOM    672  CA  ASN A  84     -64.155  75.484  46.019  1.00 50.02           C  
ATOM    673  C   ASN A  84     -65.198  75.784  47.087  1.00 51.80           C  
ATOM    674  O   ASN A  84     -65.223  76.865  47.681  1.00 52.89           O  
ATOM    675  CB  ASN A  84     -63.925  76.707  45.123  1.00 50.08           C  
ATOM    676  CG  ASN A  84     -65.205  77.226  44.501  1.00 51.13           C  
ATOM    677  OD1 ASN A  84     -66.019  76.457  43.994  1.00 53.25           O  
ATOM    678  ND2 ASN A  84     -65.384  78.542  44.528  1.00 51.21           N  
ATOM    679  N   ASP A  85     -66.060  74.798  47.314  1.00 53.09           N  
ATOM    680  CA  ASP A  85     -67.133  74.883  48.296  1.00 53.94           C  
ATOM    681  C   ASP A  85     -66.810  73.924  49.443  1.00 53.68           C  
ATOM    682  O   ASP A  85     -66.826  72.707  49.266  1.00 53.21           O  
ATOM    683  CB  ASP A  85     -68.458  74.488  47.636  1.00 55.58           C  
ATOM    684  CG  ASP A  85     -69.656  74.728  48.534  1.00 57.70           C  
ATOM    685  OD1 ASP A  85     -69.680  74.182  49.657  1.00 58.54           O  
ATOM    686  OD2 ASP A  85     -70.577  75.461  48.112  1.00 56.97           O  
ATOM    687  N   LEU A  86     -66.511  74.479  50.613  1.00 53.57           N  
ATOM    688  CA  LEU A  86     -66.170  73.674  51.782  1.00 53.43           C  
ATOM    689  C   LEU A  86     -67.272  72.692  52.146  1.00 53.45           C  
ATOM    690  O   LEU A  86     -67.002  71.601  52.644  1.00 52.26           O  
ATOM    691  CB  LEU A  86     -65.885  74.585  52.977  1.00 53.74           C  
ATOM    692  CG  LEU A  86     -64.649  75.475  52.842  1.00 53.47           C  
ATOM    693  CD1 LEU A  86     -64.578  76.442  54.012  1.00 54.57           C  
ATOM    694  CD2 LEU A  86     -63.404  74.603  52.782  1.00 53.41           C  
ATOM    695  N   ARG A  87     -68.514  73.088  51.900  1.00 53.84           N  
ATOM    696  CA  ARG A  87     -69.658  72.242  52.202  1.00 55.17           C  
ATOM    697  C   ARG A  87     -69.635  71.030  51.275  1.00 55.20           C  
ATOM    698  O   ARG A  87     -69.839  69.896  51.713  1.00 55.86           O  
ATOM    699  CB  ARG A  87     -70.945  73.048  52.023  1.00 56.40           C  
ATOM    700  CG  ARG A  87     -72.217  72.369  52.492  1.00 58.71           C  
ATOM    701  CD  ARG A  87     -73.345  73.386  52.531  1.00 60.54           C  
ATOM    702  NE  ARG A  87     -73.314  74.250  51.352  1.00 62.25           N  
ATOM    703  CZ  ARG A  87     -74.112  75.297  51.166  1.00 63.24           C  
ATOM    704  NH1 ARG A  87     -75.015  75.619  52.081  1.00 63.79           N  
ATOM    705  NH2 ARG A  87     -74.001  76.026  50.063  1.00 63.91           N  
ATOM    706  N   VAL A  88     -69.372  71.272  49.994  1.00 54.41           N  
ATOM    707  CA  VAL A  88     -69.298  70.192  49.017  1.00 53.19           C  
ATOM    708  C   VAL A  88     -68.020  69.395  49.253  1.00 52.36           C  
ATOM    709  O   VAL A  88     -67.988  68.183  49.042  1.00 51.96           O  
ATOM    710  CB  VAL A  88     -69.292  70.738  47.571  1.00 53.53           C  
ATOM    711  CG1 VAL A  88     -69.109  69.598  46.580  1.00 53.40           C  
ATOM    712  CG2 VAL A  88     -70.593  71.482  47.294  1.00 53.55           C  
ATOM    713  N   ILE A  89     -66.968  70.084  49.692  1.00 51.97           N  
ATOM    714  CA  ILE A  89     -65.688  69.441  49.974  1.00 51.97           C  
ATOM    715  C   ILE A  89     -65.853  68.530  51.180  1.00 52.22           C  
ATOM    716  O   ILE A  89     -65.367  67.400  51.189  1.00 50.99           O  
ATOM    717  CB  ILE A  89     -64.578  70.482  50.294  1.00 51.93           C  
ATOM    718  CG1 ILE A  89     -64.273  71.332  49.057  1.00 51.60           C  
ATOM    719  CG2 ILE A  89     -63.313  69.771  50.759  1.00 51.53           C  
ATOM    720  CD1 ILE A  89     -63.755  70.540  47.875  1.00 52.44           C  
ATOM    721  N   ARG A  90     -66.540  69.039  52.198  1.00 53.88           N  
ATOM    722  CA  ARG A  90     -66.789  68.283  53.423  1.00 56.17           C  
ATOM    723  C   ARG A  90     -67.520  66.986  53.092  1.00 56.51           C  
ATOM    724  O   ARG A  90     -67.038  65.888  53.383  1.00 55.42           O  
ATOM    725  CB  ARG A  90     -67.653  69.105  54.387  1.00 56.70           C  
ATOM    726  CG  ARG A  90     -67.941  68.412  55.715  1.00 57.76           C  
ATOM    727  CD  ARG A  90     -66.725  68.460  56.622  1.00 59.61           C  
ATOM    728  NE  ARG A  90     -66.873  67.628  57.811  1.00 60.26           N  
ATOM    729  CZ  ARG A  90     -66.005  67.612  58.818  1.00 61.48           C  
ATOM    730  NH1 ARG A  90     -64.930  68.388  58.783  1.00 61.37           N  
ATOM    731  NH2 ARG A  90     -66.202  66.810  59.856  1.00 62.31           N  
ATOM    732  N   TYR A  91     -68.687  67.131  52.476  1.00 57.71           N  
ATOM    733  CA  TYR A  91     -69.515  65.992  52.106  1.00 59.00           C  
ATOM    734  C   TYR A  91     -68.742  64.969  51.279  1.00 57.89           C  
ATOM    735  O   TYR A  91     -68.764  63.777  51.582  1.00 57.84           O  
ATOM    736  CB  TYR A  91     -70.745  66.474  51.329  1.00 62.00           C  
ATOM    737  CG  TYR A  91     -71.813  65.419  51.165  1.00 64.93           C  
ATOM    738  CD1 TYR A  91     -72.356  64.776  52.276  1.00 66.25           C  
ATOM    739  CD2 TYR A  91     -72.280  65.062  49.902  1.00 66.23           C  
ATOM    740  CE1 TYR A  91     -73.337  63.801  52.134  1.00 68.37           C  
ATOM    741  CE2 TYR A  91     -73.263  64.088  49.747  1.00 67.83           C  
ATOM    742  CZ  TYR A  91     -73.786  63.461  50.866  1.00 68.87           C  
ATOM    743  OH  TYR A  91     -74.758  62.497  50.723  1.00 70.45           O  
ATOM    744  N   SER A  92     -68.057  65.435  50.240  1.00 56.61           N  
ATOM    745  CA  SER A  92     -67.288  64.541  49.384  1.00 55.26           C  
ATOM    746  C   SER A  92     -66.322  63.691  50.196  1.00 54.20           C  
ATOM    747  O   SER A  92     -66.131  62.513  49.900  1.00 54.03           O  
ATOM    748  CB  SER A  92     -66.509  65.339  48.337  1.00 55.58           C  
ATOM    749  OG  SER A  92     -67.385  65.996  47.437  1.00 57.01           O  
ATOM    750  N   ILE A  93     -65.715  64.289  51.219  1.00 53.37           N  
ATOM    751  CA  ILE A  93     -64.765  63.574  52.066  1.00 52.44           C  
ATOM    752  C   ILE A  93     -65.479  62.504  52.880  1.00 52.64           C  
ATOM    753  O   ILE A  93     -64.990  61.383  53.024  1.00 50.20           O  
ATOM    754  CB  ILE A  93     -64.059  64.522  53.065  1.00 53.08           C  
ATOM    755  CG1 ILE A  93     -63.318  65.636  52.318  1.00 52.72           C  
ATOM    756  CG2 ILE A  93     -63.077  63.726  53.920  1.00 51.48           C  
ATOM    757  CD1 ILE A  93     -62.071  65.175  51.603  1.00 53.81           C  
ATOM    758  N   GLU A  94     -66.639  62.869  53.416  1.00 53.39           N  
ATOM    759  CA  GLU A  94     -67.434  61.958  54.233  1.00 54.72           C  
ATOM    760  C   GLU A  94     -67.945  60.765  53.428  1.00 55.11           C  
ATOM    761  O   GLU A  94     -68.055  59.657  53.955  1.00 56.16           O  
ATOM    762  CB  GLU A  94     -68.616  62.713  54.855  1.00 54.59           C  
ATOM    763  CG  GLU A  94     -68.203  63.911  55.699  1.00 55.03           C  
ATOM    764  CD  GLU A  94     -69.383  64.655  56.293  1.00 55.37           C  
ATOM    765  OE1 GLU A  94     -70.253  65.120  55.524  1.00 54.48           O  
ATOM    766  OE2 GLU A  94     -69.439  64.779  57.534  1.00 55.94           O  
ATOM    767  N   LYS A  95     -68.246  60.993  52.152  1.00 54.94           N  
ATOM    768  CA  LYS A  95     -68.756  59.938  51.278  1.00 54.93           C  
ATOM    769  C   LYS A  95     -67.701  58.966  50.756  1.00 53.80           C  
ATOM    770  O   LYS A  95     -68.009  58.075  49.965  1.00 54.65           O  
ATOM    771  CB  LYS A  95     -69.518  60.554  50.103  1.00 55.44           C  
ATOM    772  CG  LYS A  95     -70.956  60.914  50.435  1.00 57.62           C  
ATOM    773  CD  LYS A  95     -71.760  59.660  50.752  1.00 58.14           C  
ATOM    774  CE  LYS A  95     -73.177  60.001  51.165  1.00 58.33           C  
ATOM    775  NZ  LYS A  95     -73.192  60.814  52.410  1.00 58.06           N  
ATOM    776  N   GLY A  96     -66.459  59.143  51.197  1.00 52.48           N  
ATOM    777  CA  GLY A  96     -65.386  58.255  50.784  1.00 49.70           C  
ATOM    778  C   GLY A  96     -64.864  58.358  49.360  1.00 48.66           C  
ATOM    779  O   GLY A  96     -64.348  57.370  48.834  1.00 47.95           O  
ATOM    780  N   VAL A  97     -64.987  59.523  48.726  1.00 47.03           N  
ATOM    781  CA  VAL A  97     -64.476  59.681  47.362  1.00 44.80           C  
ATOM    782  C   VAL A  97     -62.973  59.418  47.384  1.00 42.75           C  
ATOM    783  O   VAL A  97     -62.353  59.445  48.445  1.00 42.60           O  
ATOM    784  CB  VAL A  97     -64.735  61.100  46.802  1.00 45.05           C  
ATOM    785  CG1 VAL A  97     -66.228  61.360  46.717  1.00 44.99           C  
ATOM    786  CG2 VAL A  97     -64.058  62.145  47.676  1.00 44.82           C  
ATOM    787  N   ASP A  98     -62.385  59.167  46.220  1.00 40.64           N  
ATOM    788  CA  ASP A  98     -60.955  58.874  46.150  1.00 38.89           C  
ATOM    789  C   ASP A  98     -60.009  60.066  46.330  1.00 37.48           C  
ATOM    790  O   ASP A  98     -58.897  59.908  46.831  1.00 35.69           O  
ATOM    791  CB  ASP A  98     -60.631  58.166  44.833  1.00 39.52           C  
ATOM    792  CG  ASP A  98     -61.355  56.840  44.694  1.00 38.80           C  
ATOM    793  OD1 ASP A  98     -62.558  56.850  44.369  1.00 38.99           O  
ATOM    794  OD2 ASP A  98     -60.719  55.791  44.924  1.00 38.22           O  
ATOM    795  N   ALA A  99     -60.434  61.254  45.922  1.00 36.20           N  
ATOM    796  CA  ALA A  99     -59.564  62.409  46.075  1.00 35.73           C  
ATOM    797  C   ALA A  99     -60.236  63.746  45.838  1.00 35.19           C  
ATOM    798  O   ALA A  99     -61.238  63.851  45.122  1.00 34.41           O  
ATOM    799  CB  ALA A  99     -58.353  62.272  45.156  1.00 34.67           C  
ATOM    800  N   ILE A 100     -59.663  64.764  46.470  1.00 34.30           N  
ATOM    801  CA  ILE A 100     -60.119  66.138  46.351  1.00 34.13           C  
ATOM    802  C   ILE A 100     -58.994  66.808  45.555  1.00 33.70           C  
ATOM    803  O   ILE A 100     -57.830  66.737  45.945  1.00 33.42           O  
ATOM    804  CB  ILE A 100     -60.235  66.799  47.737  1.00 34.22           C  
ATOM    805  CG1 ILE A 100     -61.138  65.951  48.641  1.00 36.14           C  
ATOM    806  CG2 ILE A 100     -60.777  68.211  47.601  1.00 34.56           C  
ATOM    807  CD1 ILE A 100     -62.577  65.815  48.158  1.00 35.56           C  
ATOM    808  N   ILE A 101     -59.337  67.442  44.438  1.00 33.12           N  
ATOM    809  CA  ILE A 101     -58.325  68.072  43.600  1.00 31.23           C  
ATOM    810  C   ILE A 101     -58.230  69.584  43.752  1.00 29.69           C  
ATOM    811  O   ILE A 101     -59.173  70.314  43.439  1.00 30.70           O  
ATOM    812  CB  ILE A 101     -58.564  67.760  42.103  1.00 31.72           C  
ATOM    813  CG1 ILE A 101     -58.698  66.250  41.891  1.00 30.60           C  
ATOM    814  CG2 ILE A 101     -57.403  68.299  41.267  1.00 30.18           C  
ATOM    815  CD1 ILE A 101     -57.468  65.463  42.249  1.00 29.16           C  
ATOM    816  N   SER A 102     -57.075  70.040  44.228  1.00 29.09           N  
ATOM    817  CA  SER A 102     -56.800  71.464  44.407  1.00 26.15           C  
ATOM    818  C   SER A 102     -57.995  72.266  44.909  1.00 26.66           C  
ATOM    819  O   SER A 102     -58.519  73.130  44.201  1.00 25.26           O  
ATOM    820  CB  SER A 102     -56.308  72.058  43.081  1.00 27.43           C  
ATOM    821  OG  SER A 102     -55.269  71.267  42.526  1.00 23.90           O  
ATOM    822  N   PRO A 103     -58.444  71.996  46.146  1.00 25.41           N  
ATOM    823  CA  PRO A 103     -59.587  72.727  46.700  1.00 26.33           C  
ATOM    824  C   PRO A 103     -59.355  74.237  46.809  1.00 26.56           C  
ATOM    825  O   PRO A 103     -60.306  75.010  46.898  1.00 27.01           O  
ATOM    826  CB  PRO A 103     -59.796  72.057  48.063  1.00 25.82           C  
ATOM    827  CG  PRO A 103     -58.436  71.555  48.422  1.00 24.05           C  
ATOM    828  CD  PRO A 103     -57.935  71.005  47.107  1.00 25.75           C  
ATOM    829  N   TRP A 104     -58.088  74.652  46.782  1.00 26.78           N  
ATOM    830  CA  TRP A 104     -57.736  76.070  46.881  1.00 25.37           C  
ATOM    831  C   TRP A 104     -58.070  76.897  45.640  1.00 26.59           C  
ATOM    832  O   TRP A 104     -58.109  78.125  45.706  1.00 27.10           O  
ATOM    833  CB  TRP A 104     -56.243  76.222  47.213  1.00 22.81           C  
ATOM    834  CG  TRP A 104     -55.352  75.415  46.323  1.00 19.80           C  
ATOM    835  CD1 TRP A 104     -54.979  75.710  45.041  1.00 19.34           C  
ATOM    836  CD2 TRP A 104     -54.789  74.139  46.622  1.00 21.69           C  
ATOM    837  NE1 TRP A 104     -54.220  74.690  44.523  1.00 19.54           N  
ATOM    838  CE2 TRP A 104     -54.088  73.710  45.472  1.00 20.26           C  
ATOM    839  CE3 TRP A 104     -54.810  73.307  47.751  1.00 21.51           C  
ATOM    840  CZ2 TRP A 104     -53.416  72.488  45.418  1.00 20.16           C  
ATOM    841  CZ3 TRP A 104     -54.140  72.088  47.694  1.00 22.78           C  
ATOM    842  CH2 TRP A 104     -53.453  71.693  46.534  1.00 20.58           C  
ATOM    843  N   VAL A 105     -58.310  76.247  44.508  1.00 27.74           N  
ATOM    844  CA  VAL A 105     -58.638  77.001  43.300  1.00 31.08           C  
ATOM    845  C   VAL A 105     -59.961  77.733  43.495  1.00 33.66           C  
ATOM    846  O   VAL A 105     -60.956  77.143  43.906  1.00 35.39           O  
ATOM    847  CB  VAL A 105     -58.744  76.088  42.063  1.00 30.75           C  
ATOM    848  CG1 VAL A 105     -59.165  76.904  40.853  1.00 30.32           C  
ATOM    849  CG2 VAL A 105     -57.404  75.421  41.796  1.00 29.86           C  
ATOM    850  N   ASN A 106     -59.957  79.029  43.205  1.00 36.31           N  
ATOM    851  CA  ASN A 106     -61.144  79.862  43.355  1.00 39.60           C  
ATOM    852  C   ASN A 106     -61.573  80.006  44.814  1.00 40.71           C  
ATOM    853  O   ASN A 106     -62.764  80.020  45.131  1.00 42.75           O  
ATOM    854  CB  ASN A 106     -62.288  79.313  42.504  1.00 40.30           C  
ATOM    855  CG  ASN A 106     -62.025  79.469  41.019  1.00 43.11           C  
ATOM    856  OD1 ASN A 106     -61.813  80.580  40.530  1.00 44.45           O  
ATOM    857  ND2 ASN A 106     -62.032  78.357  40.291  1.00 42.95           N  
ATOM    858  N   ARG A 107     -60.581  80.100  45.693  1.00 39.52           N  
ATOM    859  CA  ARG A 107     -60.796  80.288  47.122  1.00 38.93           C  
ATOM    860  C   ARG A 107     -59.713  81.247  47.601  1.00 38.47           C  
ATOM    861  O   ARG A 107     -58.835  81.632  46.829  1.00 38.53           O  
ATOM    862  CB  ARG A 107     -60.679  78.964  47.883  1.00 37.85           C  
ATOM    863  CG  ARG A 107     -61.877  78.039  47.741  1.00 38.79           C  
ATOM    864  CD  ARG A 107     -61.793  76.883  48.725  1.00 38.35           C  
ATOM    865  NE  ARG A 107     -61.884  77.333  50.113  1.00 38.14           N  
ATOM    866  CZ  ARG A 107     -62.996  77.784  50.686  1.00 40.38           C  
ATOM    867  NH1 ARG A 107     -64.129  77.850  50.000  1.00 40.31           N  
ATOM    868  NH2 ARG A 107     -62.979  78.179  51.954  1.00 42.19           N  
ATOM    869  N   LYS A 108     -59.781  81.639  48.867  1.00 37.06           N  
ATOM    870  CA  LYS A 108     -58.788  82.545  49.421  1.00 35.88           C  
ATOM    871  C   LYS A 108     -58.120  81.895  50.621  1.00 35.31           C  
ATOM    872  O   LYS A 108     -57.656  82.573  51.534  1.00 34.21           O  
ATOM    873  CB  LYS A 108     -59.438  83.867  49.822  1.00 37.81           C  
ATOM    874  CG  LYS A 108     -60.030  84.621  48.647  1.00 40.29           C  
ATOM    875  CD  LYS A 108     -60.620  85.956  49.072  1.00 43.05           C  
ATOM    876  CE  LYS A 108     -61.250  86.681  47.888  1.00 43.95           C  
ATOM    877  NZ  LYS A 108     -61.854  87.983  48.282  1.00 46.68           N  
ATOM    878  N   ASP A 109     -58.080  80.565  50.599  1.00 32.37           N  
ATOM    879  CA  ASP A 109     -57.462  79.774  51.653  1.00 31.33           C  
ATOM    880  C   ASP A 109     -57.091  78.428  51.049  1.00 29.07           C  
ATOM    881  O   ASP A 109     -57.486  78.124  49.928  1.00 29.46           O  
ATOM    882  CB  ASP A 109     -58.434  79.596  52.823  1.00 32.82           C  
ATOM    883  CG  ASP A 109     -59.759  78.994  52.398  1.00 33.38           C  
ATOM    884  OD1 ASP A 109     -60.808  79.557  52.778  1.00 36.11           O  
ATOM    885  OD2 ASP A 109     -59.756  77.959  51.696  1.00 32.76           O  
ATOM    886  N   PRO A 110     -56.320  77.608  51.773  1.00 30.42           N  
ATOM    887  CA  PRO A 110     -55.908  76.294  51.273  1.00 30.22           C  
ATOM    888  C   PRO A 110     -57.077  75.392  50.888  1.00 31.91           C  
ATOM    889  O   PRO A 110     -56.879  74.340  50.275  1.00 29.06           O  
ATOM    890  CB  PRO A 110     -55.114  75.713  52.438  1.00 30.88           C  
ATOM    891  CG  PRO A 110     -54.559  76.926  53.113  1.00 30.14           C  
ATOM    892  CD  PRO A 110     -55.733  77.864  53.100  1.00 30.66           C  
ATOM    893  N   GLY A 111     -58.287  75.807  51.255  1.00 34.05           N  
ATOM    894  CA  GLY A 111     -59.467  75.015  50.961  1.00 37.46           C  
ATOM    895  C   GLY A 111     -59.450  73.751  51.796  1.00 39.06           C  
ATOM    896  O   GLY A 111     -60.128  72.772  51.484  1.00 41.57           O  
ATOM    897  N   ILE A 112     -58.671  73.779  52.872  1.00 40.19           N  
ATOM    898  CA  ILE A 112     -58.541  72.632  53.759  1.00 40.89           C  
ATOM    899  C   ILE A 112     -57.829  73.009  55.057  1.00 41.97           C  
ATOM    900  O   ILE A 112     -56.757  73.617  55.035  1.00 41.95           O  
ATOM    901  CB  ILE A 112     -57.749  71.508  53.065  1.00 41.35           C  
ATOM    902  CG1 ILE A 112     -57.552  70.330  54.014  1.00 41.73           C  
ATOM    903  CG2 ILE A 112     -56.406  72.041  52.591  1.00 42.05           C  
ATOM    904  CD1 ILE A 112     -56.795  69.173  53.392  1.00 42.41           C  
ATOM    905  N   ASP A 113     -58.431  72.656  56.188  1.00 41.92           N  
ATOM    906  CA  ASP A 113     -57.831  72.947  57.486  1.00 42.65           C  
ATOM    907  C   ASP A 113     -57.411  71.640  58.148  1.00 42.78           C  
ATOM    908  O   ASP A 113     -57.460  70.580  57.522  1.00 42.84           O  
ATOM    909  CB  ASP A 113     -58.813  73.706  58.385  1.00 42.90           C  
ATOM    910  CG  ASP A 113     -60.116  72.964  58.579  1.00 43.27           C  
ATOM    911  OD1 ASP A 113     -60.058  71.742  58.816  1.00 41.60           O  
ATOM    912  OD2 ASP A 113     -61.190  73.603  58.501  1.00 43.09           O  
ATOM    913  N   HIS A 114     -57.010  71.712  59.414  1.00 42.44           N  
ATOM    914  CA  HIS A 114     -56.558  70.525  60.133  1.00 42.56           C  
ATOM    915  C   HIS A 114     -57.653  69.503  60.445  1.00 43.26           C  
ATOM    916  O   HIS A 114     -57.368  68.313  60.577  1.00 42.79           O  
ATOM    917  CB  HIS A 114     -55.836  70.932  61.422  1.00 43.66           C  
ATOM    918  CG  HIS A 114     -56.695  71.681  62.393  1.00 43.82           C  
ATOM    919  ND1 HIS A 114     -57.425  72.793  62.037  1.00 45.25           N  
ATOM    920  CD2 HIS A 114     -56.912  71.495  63.717  1.00 45.24           C  
ATOM    921  CE1 HIS A 114     -58.055  73.262  63.100  1.00 46.89           C  
ATOM    922  NE2 HIS A 114     -57.760  72.493  64.132  1.00 46.12           N  
ATOM    923  N   VAL A 115     -58.900  69.948  60.555  1.00 42.77           N  
ATOM    924  CA  VAL A 115     -59.976  69.012  60.845  1.00 44.49           C  
ATOM    925  C   VAL A 115     -60.340  68.203  59.600  1.00 44.38           C  
ATOM    926  O   VAL A 115     -60.556  66.994  59.686  1.00 43.76           O  
ATOM    927  CB  VAL A 115     -61.237  69.731  61.415  1.00 44.66           C  
ATOM    928  CG1 VAL A 115     -60.836  70.606  62.587  1.00 45.16           C  
ATOM    929  CG2 VAL A 115     -61.933  70.546  60.346  1.00 45.15           C  
ATOM    930  N   LEU A 116     -60.394  68.862  58.443  1.00 43.70           N  
ATOM    931  CA  LEU A 116     -60.711  68.172  57.194  1.00 43.03           C  
ATOM    932  C   LEU A 116     -59.536  67.280  56.835  1.00 43.04           C  
ATOM    933  O   LEU A 116     -59.703  66.230  56.224  1.00 43.50           O  
ATOM    934  CB  LEU A 116     -60.955  69.172  56.063  1.00 41.71           C  
ATOM    935  CG  LEU A 116     -62.172  70.090  56.185  1.00 41.29           C  
ATOM    936  CD1 LEU A 116     -62.186  71.060  55.023  1.00 39.86           C  
ATOM    937  CD2 LEU A 116     -63.452  69.265  56.204  1.00 41.59           C  
ATOM    938  N   ALA A 117     -58.342  67.712  57.223  1.00 43.45           N  
ATOM    939  CA  ALA A 117     -57.129  66.957  56.958  1.00 43.95           C  
ATOM    940  C   ALA A 117     -57.185  65.606  57.663  1.00 45.61           C  
ATOM    941  O   ALA A 117     -56.729  64.598  57.125  1.00 46.03           O  
ATOM    942  CB  ALA A 117     -55.916  67.743  57.430  1.00 44.73           C  
ATOM    943  N   LYS A 118     -57.741  65.584  58.870  1.00 46.87           N  
ATOM    944  CA  LYS A 118     -57.842  64.333  59.613  1.00 47.16           C  
ATOM    945  C   LYS A 118     -59.034  63.532  59.097  1.00 46.26           C  
ATOM    946  O   LYS A 118     -58.989  62.305  59.048  1.00 46.32           O  
ATOM    947  CB  LYS A 118     -57.993  64.598  61.116  1.00 48.38           C  
ATOM    948  CG  LYS A 118     -59.349  65.135  61.540  1.00 49.66           C  
ATOM    949  CD  LYS A 118     -59.479  65.104  63.055  1.00 51.93           C  
ATOM    950  CE  LYS A 118     -60.882  65.467  63.505  1.00 53.28           C  
ATOM    951  NZ  LYS A 118     -61.037  65.340  64.983  1.00 54.24           N  
ATOM    952  N   LEU A 119     -60.095  64.232  58.707  1.00 46.32           N  
ATOM    953  CA  LEU A 119     -61.290  63.584  58.173  1.00 46.67           C  
ATOM    954  C   LEU A 119     -60.930  62.843  56.884  1.00 47.61           C  
ATOM    955  O   LEU A 119     -61.442  61.755  56.621  1.00 46.54           O  
ATOM    956  CB  LEU A 119     -62.377  64.623  57.877  1.00 47.09           C  
ATOM    957  CG  LEU A 119     -63.685  64.093  57.277  1.00 46.58           C  
ATOM    958  CD1 LEU A 119     -64.378  63.176  58.277  1.00 47.95           C  
ATOM    959  CD2 LEU A 119     -64.593  65.254  56.912  1.00 47.03           C  
ATOM    960  N   MET A 120     -60.056  63.444  56.080  1.00 47.57           N  
ATOM    961  CA  MET A 120     -59.616  62.825  54.835  1.00 47.87           C  
ATOM    962  C   MET A 120     -58.889  61.532  55.166  1.00 48.22           C  
ATOM    963  O   MET A 120     -59.125  60.499  54.542  1.00 47.37           O  
ATOM    964  CB  MET A 120     -58.653  63.740  54.075  1.00 46.02           C  
ATOM    965  CG  MET A 120     -59.279  64.962  53.444  1.00 45.91           C  
ATOM    966  SD  MET A 120     -58.017  65.894  52.549  1.00 46.05           S  
ATOM    967  CE  MET A 120     -57.913  64.956  51.018  1.00 43.07           C  
ATOM    968  N   VAL A 121     -57.996  61.602  56.149  1.00 48.98           N  
ATOM    969  CA  VAL A 121     -57.225  60.438  56.570  1.00 51.27           C  
ATOM    970  C   VAL A 121     -58.141  59.336  57.089  1.00 51.79           C  
ATOM    971  O   VAL A 121     -57.854  58.154  56.924  1.00 51.99           O  
ATOM    972  CB  VAL A 121     -56.238  60.794  57.699  1.00 52.07           C  
ATOM    973  CG1 VAL A 121     -55.400  59.578  58.059  1.00 53.20           C  
ATOM    974  CG2 VAL A 121     -55.352  61.940  57.273  1.00 53.93           C  
ATOM    975  N   LYS A 122     -59.245  59.733  57.714  1.00 52.70           N  
ATOM    976  CA  LYS A 122     -60.193  58.775  58.273  1.00 53.35           C  
ATOM    977  C   LYS A 122     -61.067  58.125  57.204  1.00 53.03           C  
ATOM    978  O   LYS A 122     -61.491  56.980  57.357  1.00 53.36           O  
ATOM    979  CB  LYS A 122     -61.072  59.467  59.319  1.00 54.19           C  
ATOM    980  CG  LYS A 122     -61.870  58.514  60.197  1.00 55.70           C  
ATOM    981  CD  LYS A 122     -62.654  59.275  61.258  1.00 57.46           C  
ATOM    982  CE  LYS A 122     -63.397  58.332  62.193  1.00 57.36           C  
ATOM    983  NZ  LYS A 122     -64.178  59.075  63.224  1.00 57.35           N  
ATOM    984  N   LYS A 123     -61.337  58.856  56.127  1.00 52.41           N  
ATOM    985  CA  LYS A 123     -62.159  58.339  55.036  1.00 51.54           C  
ATOM    986  C   LYS A 123     -61.265  57.858  53.897  1.00 51.08           C  
ATOM    987  O   LYS A 123     -61.755  57.449  52.843  1.00 51.49           O  
ATOM    988  CB  LYS A 123     -63.104  59.428  54.512  1.00 52.25           C  
ATOM    989  CG  LYS A 123     -63.968  60.096  55.573  1.00 53.46           C  
ATOM    990  CD  LYS A 123     -64.937  59.125  56.229  1.00 55.02           C  
ATOM    991  CE  LYS A 123     -65.829  59.845  57.233  1.00 56.54           C  
ATOM    992  NZ  LYS A 123     -66.757  58.919  57.939  1.00 57.94           N  
ATOM    993  N   ASN A 124     -59.954  57.918  54.115  1.00 50.11           N  
ATOM    994  CA  ASN A 124     -58.972  57.497  53.118  1.00 49.36           C  
ATOM    995  C   ASN A 124     -58.939  58.365  51.855  1.00 48.32           C  
ATOM    996  O   ASN A 124     -58.410  57.942  50.827  1.00 48.85           O  
ATOM    997  CB  ASN A 124     -59.216  56.036  52.723  1.00 49.52           C  
ATOM    998  CG  ASN A 124     -58.773  55.062  53.793  1.00 50.52           C  
ATOM    999  OD1 ASN A 124     -57.603  55.034  54.172  1.00 50.27           O  
ATOM   1000  ND2 ASN A 124     -59.705  54.252  54.285  1.00 50.05           N  
ATOM   1001  N   VAL A 125     -59.497  59.572  51.933  1.00 46.18           N  
ATOM   1002  CA  VAL A 125     -59.528  60.489  50.792  1.00 44.48           C  
ATOM   1003  C   VAL A 125     -58.173  61.167  50.594  1.00 44.22           C  
ATOM   1004  O   VAL A 125     -57.556  61.627  51.557  1.00 44.11           O  
ATOM   1005  CB  VAL A 125     -60.596  61.584  50.988  1.00 45.00           C  
ATOM   1006  CG1 VAL A 125     -60.751  62.395  49.711  1.00 45.30           C  
ATOM   1007  CG2 VAL A 125     -61.921  60.954  51.390  1.00 45.38           C  
ATOM   1008  N   ALA A 126     -57.714  61.240  49.345  1.00 41.94           N  
ATOM   1009  CA  ALA A 126     -56.421  61.854  49.047  1.00 38.57           C  
ATOM   1010  C   ALA A 126     -56.531  63.303  48.572  1.00 36.34           C  
ATOM   1011  O   ALA A 126     -57.611  63.771  48.202  1.00 35.15           O  
ATOM   1012  CB  ALA A 126     -55.683  61.022  48.011  1.00 36.40           C  
ATOM   1013  N   LEU A 127     -55.401  64.010  48.591  1.00 34.60           N  
ATOM   1014  CA  LEU A 127     -55.366  65.408  48.161  1.00 31.47           C  
ATOM   1015  C   LEU A 127     -54.489  65.582  46.928  1.00 27.50           C  
ATOM   1016  O   LEU A 127     -53.309  65.247  46.945  1.00 25.78           O  
ATOM   1017  CB  LEU A 127     -54.841  66.305  49.284  1.00 31.66           C  
ATOM   1018  CG  LEU A 127     -54.909  67.798  48.958  1.00 33.75           C  
ATOM   1019  CD1 LEU A 127     -56.353  68.188  48.651  1.00 34.69           C  
ATOM   1020  CD2 LEU A 127     -54.377  68.611  50.123  1.00 34.32           C  
ATOM   1021  N   GLY A 128     -55.073  66.112  45.860  1.00 26.74           N  
ATOM   1022  CA  GLY A 128     -54.318  66.314  44.634  1.00 26.21           C  
ATOM   1023  C   GLY A 128     -53.808  67.737  44.467  1.00 23.52           C  
ATOM   1024  O   GLY A 128     -54.562  68.695  44.648  1.00 25.52           O  
ATOM   1025  N   PHE A 129     -52.524  67.870  44.140  1.00 23.52           N  
ATOM   1026  CA  PHE A 129     -51.893  69.177  43.928  1.00 23.18           C  
ATOM   1027  C   PHE A 129     -51.679  69.367  42.422  1.00 20.90           C  
ATOM   1028  O   PHE A 129     -50.787  68.759  41.841  1.00 21.26           O  
ATOM   1029  CB  PHE A 129     -50.530  69.248  44.631  1.00 21.53           C  
ATOM   1030  CG  PHE A 129     -50.610  69.284  46.135  1.00 24.51           C  
ATOM   1031  CD1 PHE A 129     -51.011  68.164  46.860  1.00 26.73           C  
ATOM   1032  CD2 PHE A 129     -50.258  70.435  46.831  1.00 24.61           C  
ATOM   1033  CE1 PHE A 129     -51.056  68.195  48.260  1.00 27.70           C  
ATOM   1034  CE2 PHE A 129     -50.301  70.476  48.227  1.00 26.01           C  
ATOM   1035  CZ  PHE A 129     -50.699  69.357  48.941  1.00 27.58           C  
ATOM   1036  N   SER A 130     -52.481  70.227  41.806  1.00 21.79           N  
ATOM   1037  CA  SER A 130     -52.391  70.463  40.367  1.00 20.70           C  
ATOM   1038  C   SER A 130     -51.416  71.565  39.945  1.00 20.01           C  
ATOM   1039  O   SER A 130     -51.341  72.619  40.567  1.00 16.52           O  
ATOM   1040  CB  SER A 130     -53.775  70.808  39.811  1.00 22.60           C  
ATOM   1041  OG  SER A 130     -54.746  69.854  40.202  1.00 25.04           O  
ATOM   1042  N   LEU A 131     -50.684  71.315  38.867  1.00 19.06           N  
ATOM   1043  CA  LEU A 131     -49.751  72.302  38.342  1.00 19.25           C  
ATOM   1044  C   LEU A 131     -50.492  73.320  37.478  1.00 18.39           C  
ATOM   1045  O   LEU A 131     -50.167  74.508  37.487  1.00 18.48           O  
ATOM   1046  CB  LEU A 131     -48.678  71.633  37.466  1.00 14.57           C  
ATOM   1047  CG  LEU A 131     -47.793  72.608  36.669  1.00 15.99           C  
ATOM   1048  CD1 LEU A 131     -46.907  73.400  37.639  1.00 14.31           C  
ATOM   1049  CD2 LEU A 131     -46.923  71.858  35.657  1.00 14.36           C  
ATOM   1050  N   ARG A 132     -51.493  72.851  36.735  1.00 19.30           N  
ATOM   1051  CA  ARG A 132     -52.213  73.713  35.802  1.00 19.79           C  
ATOM   1052  C   ARG A 132     -52.656  75.088  36.281  1.00 18.17           C  
ATOM   1053  O   ARG A 132     -52.418  76.079  35.595  1.00 18.13           O  
ATOM   1054  CB  ARG A 132     -53.411  72.988  35.184  1.00 19.64           C  
ATOM   1055  CG  ARG A 132     -53.897  73.711  33.931  1.00 23.96           C  
ATOM   1056  CD  ARG A 132     -54.972  72.960  33.174  1.00 24.71           C  
ATOM   1057  NE  ARG A 132     -55.228  73.588  31.880  1.00 25.65           N  
ATOM   1058  CZ  ARG A 132     -55.847  74.754  31.716  1.00 26.83           C  
ATOM   1059  NH1 ARG A 132     -56.286  75.437  32.762  1.00 26.67           N  
ATOM   1060  NH2 ARG A 132     -56.032  75.237  30.498  1.00 28.93           N  
ATOM   1061  N   PRO A 133     -53.332  75.171  37.440  1.00 18.38           N  
ATOM   1062  CA  PRO A 133     -53.760  76.494  37.914  1.00 18.85           C  
ATOM   1063  C   PRO A 133     -52.585  77.480  37.945  1.00 18.01           C  
ATOM   1064  O   PRO A 133     -52.734  78.654  37.611  1.00 16.75           O  
ATOM   1065  CB  PRO A 133     -54.307  76.193  39.306  1.00 17.90           C  
ATOM   1066  CG  PRO A 133     -54.895  74.833  39.127  1.00 17.45           C  
ATOM   1067  CD  PRO A 133     -53.828  74.108  38.336  1.00 16.40           C  
ATOM   1068  N   LEU A 134     -51.414  76.983  38.330  1.00 16.86           N  
ATOM   1069  CA  LEU A 134     -50.211  77.812  38.404  1.00 19.91           C  
ATOM   1070  C   LEU A 134     -49.753  78.299  37.040  1.00 19.38           C  
ATOM   1071  O   LEU A 134     -49.356  79.447  36.884  1.00 18.66           O  
ATOM   1072  CB  LEU A 134     -49.059  77.037  39.043  1.00 20.24           C  
ATOM   1073  CG  LEU A 134     -49.007  76.936  40.564  1.00 20.46           C  
ATOM   1074  CD1 LEU A 134     -47.867  75.999  40.966  1.00 20.28           C  
ATOM   1075  CD2 LEU A 134     -48.804  78.322  41.165  1.00 17.16           C  
ATOM   1076  N   LEU A 135     -49.799  77.419  36.049  1.00 20.36           N  
ATOM   1077  CA  LEU A 135     -49.359  77.784  34.713  1.00 23.86           C  
ATOM   1078  C   LEU A 135     -50.005  79.032  34.141  1.00 24.19           C  
ATOM   1079  O   LEU A 135     -49.303  79.971  33.756  1.00 24.79           O  
ATOM   1080  CB  LEU A 135     -49.580  76.621  33.735  1.00 23.86           C  
ATOM   1081  CG  LEU A 135     -48.577  75.473  33.841  1.00 24.40           C  
ATOM   1082  CD1 LEU A 135     -48.904  74.366  32.829  1.00 21.02           C  
ATOM   1083  CD2 LEU A 135     -47.185  76.036  33.580  1.00 25.84           C  
ATOM   1084  N   TYR A 136     -51.336  79.044  34.103  1.00 25.26           N  
ATOM   1085  CA  TYR A 136     -52.088  80.147  33.510  1.00 27.29           C  
ATOM   1086  C   TYR A 136     -52.387  81.360  34.389  1.00 26.42           C  
ATOM   1087  O   TYR A 136     -53.027  82.311  33.930  1.00 27.37           O  
ATOM   1088  CB  TYR A 136     -53.421  79.630  32.940  1.00 30.91           C  
ATOM   1089  CG  TYR A 136     -53.321  78.507  31.918  1.00 36.07           C  
ATOM   1090  CD1 TYR A 136     -54.293  78.367  30.922  1.00 38.01           C  
ATOM   1091  CD2 TYR A 136     -52.284  77.570  31.959  1.00 35.61           C  
ATOM   1092  CE1 TYR A 136     -54.230  77.328  29.993  1.00 38.32           C  
ATOM   1093  CE2 TYR A 136     -52.216  76.521  31.036  1.00 36.76           C  
ATOM   1094  CZ  TYR A 136     -53.194  76.408  30.054  1.00 38.76           C  
ATOM   1095  OH  TYR A 136     -53.140  75.388  29.126  1.00 38.92           O  
ATOM   1096  N   SER A 137     -51.929  81.342  35.635  1.00 23.98           N  
ATOM   1097  CA  SER A 137     -52.185  82.450  36.550  1.00 20.75           C  
ATOM   1098  C   SER A 137     -51.240  83.631  36.382  1.00 18.52           C  
ATOM   1099  O   SER A 137     -50.084  83.459  35.991  1.00 17.80           O  
ATOM   1100  CB  SER A 137     -52.090  81.956  37.994  1.00 20.54           C  
ATOM   1101  OG  SER A 137     -53.093  81.007  38.271  1.00 21.60           O  
ATOM   1102  N   ASN A 138     -51.728  84.835  36.676  1.00 18.49           N  
ATOM   1103  CA  ASN A 138     -50.873  86.010  36.595  1.00 15.53           C  
ATOM   1104  C   ASN A 138     -50.005  85.991  37.867  1.00 14.96           C  
ATOM   1105  O   ASN A 138     -50.235  85.170  38.752  1.00 12.65           O  
ATOM   1106  CB  ASN A 138     -51.707  87.300  36.484  1.00 17.96           C  
ATOM   1107  CG  ASN A 138     -52.631  87.519  37.659  1.00 20.32           C  
ATOM   1108  OD1 ASN A 138     -52.286  87.235  38.804  1.00 20.39           O  
ATOM   1109  ND2 ASN A 138     -53.808  88.062  37.382  1.00 21.54           N  
ATOM   1110  N   PRO A 139     -49.000  86.880  37.972  1.00 15.05           N  
ATOM   1111  CA  PRO A 139     -48.107  86.935  39.140  1.00 16.27           C  
ATOM   1112  C   PRO A 139     -48.782  86.920  40.510  1.00 16.57           C  
ATOM   1113  O   PRO A 139     -48.397  86.152  41.391  1.00 14.85           O  
ATOM   1114  CB  PRO A 139     -47.322  88.220  38.907  1.00 16.48           C  
ATOM   1115  CG  PRO A 139     -47.228  88.269  37.408  1.00 14.94           C  
ATOM   1116  CD  PRO A 139     -48.636  87.932  37.001  1.00 16.34           C  
ATOM   1117  N   TYR A 140     -49.771  87.790  40.686  1.00 17.44           N  
ATOM   1118  CA  TYR A 140     -50.506  87.887  41.939  1.00 18.41           C  
ATOM   1119  C   TYR A 140     -51.203  86.564  42.255  1.00 17.46           C  
ATOM   1120  O   TYR A 140     -51.125  86.054  43.373  1.00 14.37           O  
ATOM   1121  CB  TYR A 140     -51.538  89.014  41.833  1.00 23.10           C  
ATOM   1122  CG  TYR A 140     -52.450  89.130  43.027  1.00 26.43           C  
ATOM   1123  CD1 TYR A 140     -51.981  89.620  44.248  1.00 28.65           C  
ATOM   1124  CD2 TYR A 140     -53.789  88.753  42.937  1.00 27.74           C  
ATOM   1125  CE1 TYR A 140     -52.826  89.734  45.348  1.00 30.87           C  
ATOM   1126  CE2 TYR A 140     -54.639  88.861  44.032  1.00 31.63           C  
ATOM   1127  CZ  TYR A 140     -54.153  89.352  45.231  1.00 31.36           C  
ATOM   1128  OH  TYR A 140     -55.001  89.463  46.311  1.00 38.26           O  
ATOM   1129  N   GLU A 141     -51.882  86.009  41.259  1.00 17.94           N  
ATOM   1130  CA  GLU A 141     -52.591  84.740  41.427  1.00 18.52           C  
ATOM   1131  C   GLU A 141     -51.634  83.589  41.761  1.00 16.97           C  
ATOM   1132  O   GLU A 141     -51.922  82.774  42.639  1.00 16.75           O  
ATOM   1133  CB  GLU A 141     -53.380  84.405  40.152  1.00 22.16           C  
ATOM   1134  CG  GLU A 141     -54.424  85.453  39.771  1.00 25.74           C  
ATOM   1135  CD  GLU A 141     -55.182  85.109  38.492  1.00 29.57           C  
ATOM   1136  OE1 GLU A 141     -54.534  84.770  37.476  1.00 26.45           O  
ATOM   1137  OE2 GLU A 141     -56.430  85.189  38.500  1.00 31.91           O  
ATOM   1138  N   ARG A 142     -50.500  83.522  41.065  1.00 14.64           N  
ATOM   1139  CA  ARG A 142     -49.522  82.458  41.307  1.00 15.85           C  
ATOM   1140  C   ARG A 142     -48.938  82.522  42.712  1.00 14.36           C  
ATOM   1141  O   ARG A 142     -48.717  81.486  43.333  1.00 13.43           O  
ATOM   1142  CB  ARG A 142     -48.390  82.504  40.271  1.00 18.46           C  
ATOM   1143  CG  ARG A 142     -48.909  82.410  38.851  1.00 21.75           C  
ATOM   1144  CD  ARG A 142     -48.078  81.519  37.950  1.00 25.94           C  
ATOM   1145  NE  ARG A 142     -46.747  82.025  37.676  1.00 25.37           N  
ATOM   1146  CZ  ARG A 142     -46.084  81.798  36.544  1.00 21.99           C  
ATOM   1147  NH1 ARG A 142     -46.631  81.077  35.575  1.00 23.09           N  
ATOM   1148  NH2 ARG A 142     -44.870  82.293  36.381  1.00 17.52           N  
ATOM   1149  N   ALA A 143     -48.693  83.731  43.212  1.00 11.81           N  
ATOM   1150  CA  ALA A 143     -48.157  83.887  44.562  1.00 13.19           C  
ATOM   1151  C   ALA A 143     -49.169  83.337  45.575  1.00 15.05           C  
ATOM   1152  O   ALA A 143     -48.805  82.598  46.493  1.00 14.58           O  
ATOM   1153  CB  ALA A 143     -47.863  85.368  44.853  1.00 10.51           C  
ATOM   1154  N   ASN A 144     -50.441  83.693  45.401  1.00 15.74           N  
ATOM   1155  CA  ASN A 144     -51.487  83.223  46.310  1.00 17.82           C  
ATOM   1156  C   ASN A 144     -51.636  81.704  46.250  1.00 16.16           C  
ATOM   1157  O   ASN A 144     -51.753  81.041  47.282  1.00 14.92           O  
ATOM   1158  CB  ASN A 144     -52.832  83.892  45.992  1.00 21.24           C  
ATOM   1159  CG  ASN A 144     -52.829  85.380  46.298  1.00 27.13           C  
ATOM   1160  OD1 ASN A 144     -52.258  85.818  47.297  1.00 24.76           O  
ATOM   1161  ND2 ASN A 144     -53.482  86.165  45.444  1.00 29.07           N  
ATOM   1162  N   LEU A 145     -51.618  81.153  45.043  1.00 15.22           N  
ATOM   1163  CA  LEU A 145     -51.738  79.711  44.880  1.00 14.36           C  
ATOM   1164  C   LEU A 145     -50.596  78.986  45.570  1.00 14.25           C  
ATOM   1165  O   LEU A 145     -50.817  77.986  46.244  1.00 14.05           O  
ATOM   1166  CB  LEU A 145     -51.770  79.341  43.395  1.00 15.60           C  
ATOM   1167  CG  LEU A 145     -53.078  79.695  42.680  1.00 14.19           C  
ATOM   1168  CD1 LEU A 145     -52.883  79.644  41.164  1.00 15.47           C  
ATOM   1169  CD2 LEU A 145     -54.168  78.717  43.121  1.00 17.34           C  
ATOM   1170  N   LEU A 146     -49.372  79.483  45.392  1.00 12.73           N  
ATOM   1171  CA  LEU A 146     -48.213  78.867  46.020  1.00 14.87           C  
ATOM   1172  C   LEU A 146     -48.310  78.914  47.539  1.00 15.59           C  
ATOM   1173  O   LEU A 146     -47.924  77.962  48.212  1.00 17.66           O  
ATOM   1174  CB  LEU A 146     -46.920  79.554  45.569  1.00 14.12           C  
ATOM   1175  CG  LEU A 146     -46.448  79.221  44.150  1.00 13.99           C  
ATOM   1176  CD1 LEU A 146     -45.296  80.134  43.770  1.00 16.99           C  
ATOM   1177  CD2 LEU A 146     -46.019  77.770  44.086  1.00 17.28           C  
ATOM   1178  N   ARG A 147     -48.825  80.013  48.080  1.00 16.95           N  
ATOM   1179  CA  ARG A 147     -48.945  80.132  49.530  1.00 18.94           C  
ATOM   1180  C   ARG A 147     -49.951  79.111  50.064  1.00 18.57           C  
ATOM   1181  O   ARG A 147     -49.700  78.442  51.062  1.00 18.84           O  
ATOM   1182  CB  ARG A 147     -49.379  81.545  49.931  1.00 21.54           C  
ATOM   1183  CG  ARG A 147     -49.547  81.710  51.440  1.00 26.92           C  
ATOM   1184  CD  ARG A 147     -50.064  83.086  51.807  1.00 31.94           C  
ATOM   1185  NE  ARG A 147     -51.121  83.509  50.897  1.00 38.36           N  
ATOM   1186  CZ  ARG A 147     -52.015  84.451  51.169  1.00 40.77           C  
ATOM   1187  NH1 ARG A 147     -51.992  85.078  52.340  1.00 42.30           N  
ATOM   1188  NH2 ARG A 147     -52.925  84.776  50.259  1.00 42.47           N  
ATOM   1189  N   PHE A 148     -51.090  79.002  49.393  1.00 18.05           N  
ATOM   1190  CA  PHE A 148     -52.127  78.054  49.785  1.00 20.43           C  
ATOM   1191  C   PHE A 148     -51.633  76.617  49.681  1.00 20.28           C  
ATOM   1192  O   PHE A 148     -51.879  75.804  50.572  1.00 20.55           O  
ATOM   1193  CB  PHE A 148     -53.352  78.249  48.901  1.00 20.65           C  
ATOM   1194  CG  PHE A 148     -54.013  79.572  49.084  1.00 22.76           C  
ATOM   1195  CD1 PHE A 148     -54.723  80.156  48.047  1.00 24.59           C  
ATOM   1196  CD2 PHE A 148     -53.933  80.237  50.307  1.00 25.97           C  
ATOM   1197  CE1 PHE A 148     -55.345  81.387  48.222  1.00 26.86           C  
ATOM   1198  CE2 PHE A 148     -54.553  81.463  50.491  1.00 27.13           C  
ATOM   1199  CZ  PHE A 148     -55.259  82.040  49.447  1.00 25.53           C  
ATOM   1200  N   MET A 149     -50.937  76.305  48.589  1.00 19.64           N  
ATOM   1201  CA  MET A 149     -50.395  74.965  48.389  1.00 18.13           C  
ATOM   1202  C   MET A 149     -49.329  74.633  49.440  1.00 20.89           C  
ATOM   1203  O   MET A 149     -49.233  73.489  49.898  1.00 19.34           O  
ATOM   1204  CB  MET A 149     -49.803  74.835  46.976  1.00 18.43           C  
ATOM   1205  CG  MET A 149     -50.857  74.845  45.871  1.00 18.17           C  
ATOM   1206  SD  MET A 149     -50.159  74.974  44.214  1.00 21.04           S  
ATOM   1207  CE  MET A 149     -49.622  73.307  43.923  1.00 16.46           C  
ATOM   1208  N   MET A 150     -48.525  75.627  49.818  1.00 20.32           N  
ATOM   1209  CA  MET A 150     -47.490  75.407  50.831  1.00 20.79           C  
ATOM   1210  C   MET A 150     -48.137  75.005  52.158  1.00 20.38           C  
ATOM   1211  O   MET A 150     -47.655  74.109  52.852  1.00 20.43           O  
ATOM   1212  CB  MET A 150     -46.649  76.672  51.031  1.00 18.24           C  
ATOM   1213  CG  MET A 150     -45.757  77.023  49.850  1.00 20.45           C  
ATOM   1214  SD  MET A 150     -44.941  78.623  50.049  1.00 22.92           S  
ATOM   1215  CE  MET A 150     -43.682  78.538  48.745  1.00 21.01           C  
ATOM   1216  N   LYS A 151     -49.233  75.674  52.499  1.00 23.91           N  
ATOM   1217  CA  LYS A 151     -49.955  75.385  53.731  1.00 27.44           C  
ATOM   1218  C   LYS A 151     -50.590  73.999  53.610  1.00 28.33           C  
ATOM   1219  O   LYS A 151     -50.471  73.166  54.516  1.00 27.09           O  
ATOM   1220  CB  LYS A 151     -51.036  76.447  53.969  1.00 28.61           C  
ATOM   1221  CG  LYS A 151     -51.882  76.219  55.221  1.00 33.78           C  
ATOM   1222  CD  LYS A 151     -51.071  76.377  56.504  1.00 34.25           C  
ATOM   1223  CE  LYS A 151     -50.787  77.840  56.810  1.00 34.46           C  
ATOM   1224  NZ  LYS A 151     -50.011  77.999  58.077  1.00 35.71           N  
ATOM   1225  N   ALA A 152     -51.257  73.760  52.481  1.00 27.16           N  
ATOM   1226  CA  ALA A 152     -51.896  72.471  52.224  1.00 26.01           C  
ATOM   1227  C   ALA A 152     -50.898  71.343  52.437  1.00 26.95           C  
ATOM   1228  O   ALA A 152     -51.223  70.316  53.041  1.00 28.84           O  
ATOM   1229  CB  ALA A 152     -52.437  72.425  50.796  1.00 23.85           C  
ATOM   1230  N   TRP A 153     -49.679  71.531  51.939  1.00 26.86           N  
ATOM   1231  CA  TRP A 153     -48.640  70.522  52.088  1.00 28.56           C  
ATOM   1232  C   TRP A 153     -48.295  70.267  53.553  1.00 31.09           C  
ATOM   1233  O   TRP A 153     -48.070  69.123  53.953  1.00 31.07           O  
ATOM   1234  CB  TRP A 153     -47.373  70.936  51.341  1.00 28.13           C  
ATOM   1235  CG  TRP A 153     -46.169  70.170  51.786  1.00 28.34           C  
ATOM   1236  CD1 TRP A 153     -45.064  70.674  52.403  1.00 27.58           C  
ATOM   1237  CD2 TRP A 153     -45.977  68.750  51.711  1.00 28.38           C  
ATOM   1238  NE1 TRP A 153     -44.197  69.657  52.724  1.00 29.04           N  
ATOM   1239  CE2 TRP A 153     -44.732  68.466  52.311  1.00 27.86           C  
ATOM   1240  CE3 TRP A 153     -46.740  67.690  51.197  1.00 28.84           C  
ATOM   1241  CZ2 TRP A 153     -44.227  67.163  52.414  1.00 29.37           C  
ATOM   1242  CZ3 TRP A 153     -46.237  66.393  51.299  1.00 29.12           C  
ATOM   1243  CH2 TRP A 153     -44.993  66.144  51.904  1.00 29.92           C  
ATOM   1244  N   LYS A 154     -48.235  71.332  54.346  1.00 32.80           N  
ATOM   1245  CA  LYS A 154     -47.918  71.193  55.761  1.00 33.78           C  
ATOM   1246  C   LYS A 154     -48.958  70.334  56.466  1.00 32.67           C  
ATOM   1247  O   LYS A 154     -48.605  69.424  57.212  1.00 33.70           O  
ATOM   1248  CB  LYS A 154     -47.827  72.568  56.429  1.00 35.55           C  
ATOM   1249  CG  LYS A 154     -46.590  73.349  56.027  1.00 39.53           C  
ATOM   1250  CD  LYS A 154     -45.335  72.529  56.296  1.00 42.64           C  
ATOM   1251  CE  LYS A 154     -44.077  73.241  55.831  1.00 44.77           C  
ATOM   1252  NZ  LYS A 154     -42.863  72.407  56.057  1.00 45.84           N  
ATOM   1253  N   LEU A 155     -50.233  70.623  56.218  1.00 31.90           N  
ATOM   1254  CA  LEU A 155     -51.334  69.873  56.819  1.00 33.43           C  
ATOM   1255  C   LEU A 155     -51.293  68.406  56.388  1.00 35.01           C  
ATOM   1256  O   LEU A 155     -51.461  67.495  57.204  1.00 36.56           O  
ATOM   1257  CB  LEU A 155     -52.674  70.487  56.406  1.00 32.82           C  
ATOM   1258  CG  LEU A 155     -52.958  71.915  56.875  1.00 31.63           C  
ATOM   1259  CD1 LEU A 155     -54.227  72.437  56.218  1.00 30.50           C  
ATOM   1260  CD2 LEU A 155     -53.090  71.928  58.390  1.00 34.16           C  
ATOM   1261  N   VAL A 156     -51.070  68.191  55.095  1.00 33.89           N  
ATOM   1262  CA  VAL A 156     -50.999  66.858  54.514  1.00 33.36           C  
ATOM   1263  C   VAL A 156     -49.823  66.043  55.044  1.00 34.57           C  
ATOM   1264  O   VAL A 156     -49.976  64.866  55.365  1.00 33.33           O  
ATOM   1265  CB  VAL A 156     -50.911  66.946  52.970  1.00 32.51           C  
ATOM   1266  CG1 VAL A 156     -50.382  65.652  52.393  1.00 33.46           C  
ATOM   1267  CG2 VAL A 156     -52.289  67.242  52.400  1.00 31.28           C  
ATOM   1268  N   GLU A 157     -48.653  66.665  55.135  1.00 35.86           N  
ATOM   1269  CA  GLU A 157     -47.464  65.979  55.632  1.00 37.95           C  
ATOM   1270  C   GLU A 157     -47.573  65.621  57.113  1.00 40.04           C  
ATOM   1271  O   GLU A 157     -47.136  64.551  57.536  1.00 39.90           O  
ATOM   1272  CB  GLU A 157     -46.222  66.845  55.411  1.00 36.33           C  
ATOM   1273  CG  GLU A 157     -44.987  66.358  56.152  1.00 35.35           C  
ATOM   1274  CD  GLU A 157     -43.812  67.295  55.995  1.00 35.70           C  
ATOM   1275  OE1 GLU A 157     -43.996  68.513  56.199  1.00 39.03           O  
ATOM   1276  OE2 GLU A 157     -42.705  66.820  55.674  1.00 36.44           O  
ATOM   1277  N   LYS A 158     -48.155  66.524  57.897  1.00 42.77           N  
ATOM   1278  CA  LYS A 158     -48.312  66.307  59.330  1.00 45.00           C  
ATOM   1279  C   LYS A 158     -49.291  65.182  59.637  1.00 46.00           C  
ATOM   1280  O   LYS A 158     -48.954  64.223  60.329  1.00 46.54           O  
ATOM   1281  CB  LYS A 158     -48.792  67.592  60.008  1.00 45.11           C  
ATOM   1282  CG  LYS A 158     -49.054  67.448  61.504  1.00 46.95           C  
ATOM   1283  CD  LYS A 158     -47.826  66.950  62.264  1.00 49.08           C  
ATOM   1284  CE  LYS A 158     -46.688  67.963  62.250  1.00 50.70           C  
ATOM   1285  NZ  LYS A 158     -46.133  68.185  60.883  1.00 53.41           N  
ATOM   1286  N   TYR A 159     -50.503  65.310  59.115  1.00 46.87           N  
ATOM   1287  CA  TYR A 159     -51.545  64.323  59.338  1.00 47.50           C  
ATOM   1288  C   TYR A 159     -51.447  63.131  58.392  1.00 47.13           C  
ATOM   1289  O   TYR A 159     -52.387  62.349  58.254  1.00 47.42           O  
ATOM   1290  CB  TYR A 159     -52.905  65.008  59.219  1.00 48.68           C  
ATOM   1291  CG  TYR A 159     -53.125  66.058  60.290  1.00 51.20           C  
ATOM   1292  CD1 TYR A 159     -54.022  67.106  60.095  1.00 51.98           C  
ATOM   1293  CD2 TYR A 159     -52.450  65.988  61.511  1.00 52.48           C  
ATOM   1294  CE1 TYR A 159     -54.246  68.059  61.091  1.00 53.15           C  
ATOM   1295  CE2 TYR A 159     -52.667  66.933  62.513  1.00 53.25           C  
ATOM   1296  CZ  TYR A 159     -53.567  67.964  62.297  1.00 53.56           C  
ATOM   1297  OH  TYR A 159     -53.797  68.887  63.292  1.00 53.46           O  
ATOM   1298  N   LYS A 160     -50.292  62.997  57.751  1.00 47.07           N  
ATOM   1299  CA  LYS A 160     -50.037  61.901  56.823  1.00 47.65           C  
ATOM   1300  C   LYS A 160     -51.172  61.630  55.841  1.00 46.35           C  
ATOM   1301  O   LYS A 160     -51.537  60.475  55.613  1.00 47.33           O  
ATOM   1302  CB  LYS A 160     -49.723  60.622  57.604  1.00 49.37           C  
ATOM   1303  CG  LYS A 160     -48.492  60.718  58.492  1.00 51.66           C  
ATOM   1304  CD  LYS A 160     -48.262  59.421  59.260  1.00 54.01           C  
ATOM   1305  CE  LYS A 160     -47.087  59.540  60.223  1.00 54.76           C  
ATOM   1306  NZ  LYS A 160     -45.822  59.882  59.519  1.00 56.31           N  
ATOM   1307  N   VAL A 161     -51.733  62.686  55.261  1.00 44.30           N  
ATOM   1308  CA  VAL A 161     -52.810  62.535  54.288  1.00 42.21           C  
ATOM   1309  C   VAL A 161     -52.192  62.093  52.968  1.00 41.05           C  
ATOM   1310  O   VAL A 161     -51.154  62.613  52.561  1.00 43.22           O  
ATOM   1311  CB  VAL A 161     -53.556  63.866  54.055  1.00 42.03           C  
ATOM   1312  CG1 VAL A 161     -54.601  63.698  52.961  1.00 40.94           C  
ATOM   1313  CG2 VAL A 161     -54.211  64.328  55.345  1.00 42.23           C  
ATOM   1314  N   ARG A 162     -52.809  61.119  52.309  1.00 39.07           N  
ATOM   1315  CA  ARG A 162     -52.288  60.655  51.031  1.00 37.41           C  
ATOM   1316  C   ARG A 162     -52.367  61.821  50.053  1.00 32.78           C  
ATOM   1317  O   ARG A 162     -53.379  62.520  49.995  1.00 32.28           O  
ATOM   1318  CB  ARG A 162     -53.100  59.460  50.525  1.00 39.62           C  
ATOM   1319  CG  ARG A 162     -52.544  58.117  50.992  1.00 42.40           C  
ATOM   1320  CD  ARG A 162     -53.629  57.164  51.477  1.00 46.23           C  
ATOM   1321  NE  ARG A 162     -54.737  57.054  50.536  1.00 49.78           N  
ATOM   1322  CZ  ARG A 162     -55.688  56.127  50.606  1.00 51.28           C  
ATOM   1323  NH1 ARG A 162     -55.664  55.223  51.574  1.00 51.41           N  
ATOM   1324  NH2 ARG A 162     -56.664  56.106  49.706  1.00 52.27           N  
ATOM   1325  N   ARG A 163     -51.292  62.038  49.303  1.00 30.94           N  
ATOM   1326  CA  ARG A 163     -51.247  63.142  48.351  1.00 29.18           C  
ATOM   1327  C   ARG A 163     -50.481  62.784  47.085  1.00 26.61           C  
ATOM   1328  O   ARG A 163     -49.718  61.826  47.059  1.00 25.81           O  
ATOM   1329  CB  ARG A 163     -50.587  64.366  48.997  1.00 28.76           C  
ATOM   1330  CG  ARG A 163     -49.052  64.384  48.933  1.00 28.97           C  
ATOM   1331  CD  ARG A 163     -48.388  63.277  49.749  1.00 30.33           C  
ATOM   1332  NE  ARG A 163     -48.854  63.267  51.135  1.00 32.28           N  
ATOM   1333  CZ  ARG A 163     -48.104  62.934  52.181  1.00 32.13           C  
ATOM   1334  NH1 ARG A 163     -46.837  62.581  52.012  1.00 31.21           N  
ATOM   1335  NH2 ARG A 163     -48.623  62.953  53.401  1.00 32.04           N  
ATOM   1336  N   PHE A 164     -50.687  63.574  46.036  1.00 26.15           N  
ATOM   1337  CA  PHE A 164     -49.994  63.353  44.774  1.00 24.70           C  
ATOM   1338  C   PHE A 164     -49.954  64.635  43.950  1.00 23.80           C  
ATOM   1339  O   PHE A 164     -50.851  65.473  44.047  1.00 22.65           O  
ATOM   1340  CB  PHE A 164     -50.685  62.235  43.973  1.00 25.39           C  
ATOM   1341  CG  PHE A 164     -52.089  62.567  43.536  1.00 26.17           C  
ATOM   1342  CD1 PHE A 164     -52.317  63.366  42.417  1.00 26.80           C  
ATOM   1343  CD2 PHE A 164     -53.186  62.093  44.254  1.00 26.57           C  
ATOM   1344  CE1 PHE A 164     -53.615  63.689  42.019  1.00 26.75           C  
ATOM   1345  CE2 PHE A 164     -54.487  62.409  43.866  1.00 26.19           C  
ATOM   1346  CZ  PHE A 164     -54.702  63.210  42.746  1.00 26.81           C  
ATOM   1347  N   LEU A 165     -48.891  64.791  43.168  1.00 23.18           N  
ATOM   1348  CA  LEU A 165     -48.732  65.951  42.296  1.00 23.48           C  
ATOM   1349  C   LEU A 165     -49.245  65.519  40.931  1.00 23.59           C  
ATOM   1350  O   LEU A 165     -49.056  64.368  40.543  1.00 23.74           O  
ATOM   1351  CB  LEU A 165     -47.255  66.323  42.146  1.00 22.45           C  
ATOM   1352  CG  LEU A 165     -46.478  66.805  43.370  1.00 21.88           C  
ATOM   1353  CD1 LEU A 165     -44.990  66.782  43.077  1.00 21.49           C  
ATOM   1354  CD2 LEU A 165     -46.938  68.200  43.738  1.00 21.26           C  
ATOM   1355  N   THR A 166     -49.888  66.430  40.207  1.00 22.33           N  
ATOM   1356  CA  THR A 166     -50.375  66.116  38.869  1.00 21.53           C  
ATOM   1357  C   THR A 166     -50.420  67.371  38.015  1.00 21.77           C  
ATOM   1358  O   THR A 166     -50.463  68.488  38.537  1.00 23.18           O  
ATOM   1359  CB  THR A 166     -51.791  65.493  38.893  1.00 20.87           C  
ATOM   1360  OG1 THR A 166     -52.267  65.345  37.548  1.00 22.63           O  
ATOM   1361  CG2 THR A 166     -52.758  66.378  39.665  1.00 21.02           C  
ATOM   1362  N   SER A 167     -50.406  67.184  36.701  1.00 21.44           N  
ATOM   1363  CA  SER A 167     -50.462  68.305  35.778  1.00 21.15           C  
ATOM   1364  C   SER A 167     -51.911  68.715  35.562  1.00 22.40           C  
ATOM   1365  O   SER A 167     -52.194  69.859  35.192  1.00 24.03           O  
ATOM   1366  CB  SER A 167     -49.855  67.915  34.428  1.00 21.96           C  
ATOM   1367  OG  SER A 167     -50.689  66.987  33.741  1.00 20.33           O  
ATOM   1368  N   SER A 168     -52.831  67.781  35.806  1.00 22.24           N  
ATOM   1369  CA  SER A 168     -54.248  68.035  35.574  1.00 22.09           C  
ATOM   1370  C   SER A 168     -54.349  68.643  34.171  1.00 22.34           C  
ATOM   1371  O   SER A 168     -55.149  69.542  33.915  1.00 23.10           O  
ATOM   1372  CB  SER A 168     -54.809  69.001  36.617  1.00 23.13           C  
ATOM   1373  OG  SER A 168     -54.884  68.382  37.892  1.00 21.40           O  
ATOM   1374  N   ALA A 169     -53.511  68.131  33.274  1.00 21.45           N  
ATOM   1375  CA  ALA A 169     -53.435  68.593  31.896  1.00 21.23           C  
ATOM   1376  C   ALA A 169     -54.760  68.514  31.151  1.00 23.83           C  
ATOM   1377  O   ALA A 169     -55.474  67.516  31.228  1.00 25.41           O  
ATOM   1378  CB  ALA A 169     -52.366  67.803  31.149  1.00 17.75           C  
ATOM   1379  N   GLN A 170     -55.075  69.585  30.432  1.00 24.85           N  
ATOM   1380  CA  GLN A 170     -56.303  69.677  29.650  1.00 25.84           C  
ATOM   1381  C   GLN A 170     -55.885  69.835  28.201  1.00 25.96           C  
ATOM   1382  O   GLN A 170     -56.714  69.927  27.297  1.00 28.30           O  
ATOM   1383  CB  GLN A 170     -57.110  70.904  30.074  1.00 24.98           C  
ATOM   1384  CG  GLN A 170     -57.471  70.915  31.538  1.00 28.65           C  
ATOM   1385  CD  GLN A 170     -58.348  72.087  31.921  1.00 28.90           C  
ATOM   1386  OE1 GLN A 170     -58.652  72.285  33.095  1.00 32.05           O  
ATOM   1387  NE2 GLN A 170     -58.765  72.870  30.932  1.00 28.81           N  
ATOM   1388  N   GLU A 171     -54.576  69.852  27.998  1.00 26.10           N  
ATOM   1389  CA  GLU A 171     -53.997  70.031  26.685  1.00 27.26           C  
ATOM   1390  C   GLU A 171     -52.588  69.463  26.705  1.00 25.96           C  
ATOM   1391  O   GLU A 171     -51.942  69.401  27.753  1.00 25.47           O  
ATOM   1392  CB  GLU A 171     -53.956  71.528  26.364  1.00 30.79           C  
ATOM   1393  CG  GLU A 171     -53.423  71.896  24.996  1.00 34.86           C  
ATOM   1394  CD  GLU A 171     -53.352  73.406  24.793  1.00 36.75           C  
ATOM   1395  OE1 GLU A 171     -53.367  73.851  23.626  1.00 39.10           O  
ATOM   1396  OE2 GLU A 171     -53.271  74.149  25.798  1.00 34.26           O  
ATOM   1397  N   LYS A 172     -52.120  69.049  25.538  1.00 25.19           N  
ATOM   1398  CA  LYS A 172     -50.783  68.496  25.383  1.00 23.95           C  
ATOM   1399  C   LYS A 172     -49.731  69.363  26.081  1.00 22.35           C  
ATOM   1400  O   LYS A 172     -48.857  68.866  26.795  1.00 20.47           O  
ATOM   1401  CB  LYS A 172     -50.454  68.419  23.892  1.00 27.01           C  
ATOM   1402  CG  LYS A 172     -49.016  68.075  23.577  1.00 30.50           C  
ATOM   1403  CD  LYS A 172     -48.581  68.739  22.276  1.00 33.17           C  
ATOM   1404  CE  LYS A 172     -49.521  68.416  21.128  1.00 33.10           C  
ATOM   1405  NZ  LYS A 172     -49.079  69.060  19.858  1.00 34.41           N  
ATOM   1406  N   TRP A 173     -49.839  70.669  25.870  1.00 20.44           N  
ATOM   1407  CA  TRP A 173     -48.898  71.628  26.427  1.00 20.46           C  
ATOM   1408  C   TRP A 173     -48.878  71.757  27.949  1.00 17.49           C  
ATOM   1409  O   TRP A 173     -47.971  72.385  28.493  1.00 19.65           O  
ATOM   1410  CB  TRP A 173     -49.147  73.000  25.783  1.00 18.68           C  
ATOM   1411  CG  TRP A 173     -49.111  72.928  24.296  1.00 18.85           C  
ATOM   1412  CD1 TRP A 173     -50.176  72.988  23.445  1.00 22.08           C  
ATOM   1413  CD2 TRP A 173     -47.960  72.687  23.484  1.00 18.08           C  
ATOM   1414  NE1 TRP A 173     -49.759  72.793  22.150  1.00 20.44           N  
ATOM   1415  CE2 TRP A 173     -48.402  72.605  22.145  1.00 21.19           C  
ATOM   1416  CE3 TRP A 173     -46.597  72.528  23.756  1.00 19.83           C  
ATOM   1417  CZ2 TRP A 173     -47.529  72.368  21.079  1.00 20.97           C  
ATOM   1418  CZ3 TRP A 173     -45.727  72.292  22.694  1.00 21.52           C  
ATOM   1419  CH2 TRP A 173     -46.199  72.215  21.374  1.00 21.33           C  
ATOM   1420  N   ASP A 174     -49.856  71.164  28.632  1.00 20.61           N  
ATOM   1421  CA  ASP A 174     -49.916  71.245  30.098  1.00 19.75           C  
ATOM   1422  C   ASP A 174     -49.111  70.159  30.793  1.00 18.93           C  
ATOM   1423  O   ASP A 174     -48.820  70.263  31.980  1.00 19.16           O  
ATOM   1424  CB  ASP A 174     -51.356  71.143  30.607  1.00 18.77           C  
ATOM   1425  CG  ASP A 174     -52.249  72.246  30.085  1.00 22.14           C  
ATOM   1426  OD1 ASP A 174     -51.725  73.296  29.657  1.00 20.70           O  
ATOM   1427  OD2 ASP A 174     -53.484  72.060  30.122  1.00 18.61           O  
ATOM   1428  N   VAL A 175     -48.758  69.113  30.057  1.00 19.04           N  
ATOM   1429  CA  VAL A 175     -48.010  67.995  30.622  1.00 18.26           C  
ATOM   1430  C   VAL A 175     -46.551  68.329  30.919  1.00 19.17           C  
ATOM   1431  O   VAL A 175     -45.925  69.099  30.201  1.00 18.25           O  
ATOM   1432  CB  VAL A 175     -48.056  66.792  29.665  1.00 17.71           C  
ATOM   1433  CG1 VAL A 175     -47.319  65.611  30.271  1.00 17.94           C  
ATOM   1434  CG2 VAL A 175     -49.508  66.430  29.363  1.00 18.24           C  
ATOM   1435  N   ARG A 176     -46.017  67.745  31.988  1.00 17.40           N  
ATOM   1436  CA  ARG A 176     -44.621  67.959  32.360  1.00 17.12           C  
ATOM   1437  C   ARG A 176     -43.936  66.634  32.695  1.00 18.70           C  
ATOM   1438  O   ARG A 176     -44.574  65.703  33.187  1.00 18.50           O  
ATOM   1439  CB  ARG A 176     -44.524  68.917  33.555  1.00 18.96           C  
ATOM   1440  CG  ARG A 176     -44.911  70.361  33.221  1.00 14.23           C  
ATOM   1441  CD  ARG A 176     -43.862  71.013  32.332  1.00 16.84           C  
ATOM   1442  NE  ARG A 176     -44.187  72.402  32.010  1.00 14.79           N  
ATOM   1443  CZ  ARG A 176     -45.104  72.773  31.119  1.00 17.23           C  
ATOM   1444  NH1 ARG A 176     -45.797  71.856  30.448  1.00 14.29           N  
ATOM   1445  NH2 ARG A 176     -45.333  74.064  30.906  1.00 16.33           N  
ATOM   1446  N   TYR A 177     -42.638  66.562  32.415  1.00 20.89           N  
ATOM   1447  CA  TYR A 177     -41.833  65.369  32.682  1.00 23.82           C  
ATOM   1448  C   TYR A 177     -41.819  65.121  34.196  1.00 24.45           C  
ATOM   1449  O   TYR A 177     -41.865  66.069  34.982  1.00 23.36           O  
ATOM   1450  CB  TYR A 177     -40.405  65.594  32.172  1.00 26.26           C  
ATOM   1451  CG  TYR A 177     -39.556  64.345  32.116  1.00 30.33           C  
ATOM   1452  CD1 TYR A 177     -39.626  63.477  31.024  1.00 31.15           C  
ATOM   1453  CD2 TYR A 177     -38.711  64.006  33.175  1.00 32.66           C  
ATOM   1454  CE1 TYR A 177     -38.876  62.297  30.990  1.00 34.58           C  
ATOM   1455  CE2 TYR A 177     -37.962  62.831  33.154  1.00 35.57           C  
ATOM   1456  CZ  TYR A 177     -38.047  61.980  32.060  1.00 35.96           C  
ATOM   1457  OH  TYR A 177     -37.309  60.815  32.045  1.00 40.29           O  
ATOM   1458  N   PRO A 178     -41.744  63.846  34.622  1.00 24.85           N  
ATOM   1459  CA  PRO A 178     -41.728  63.477  36.045  1.00 25.02           C  
ATOM   1460  C   PRO A 178     -40.783  64.270  36.943  1.00 22.87           C  
ATOM   1461  O   PRO A 178     -41.207  64.856  37.939  1.00 23.59           O  
ATOM   1462  CB  PRO A 178     -41.362  61.995  36.011  1.00 27.39           C  
ATOM   1463  CG  PRO A 178     -42.017  61.530  34.758  1.00 28.42           C  
ATOM   1464  CD  PRO A 178     -41.689  62.638  33.776  1.00 25.70           C  
ATOM   1465  N   ARG A 179     -39.504  64.286  36.592  1.00 21.60           N  
ATOM   1466  CA  ARG A 179     -38.518  64.982  37.399  1.00 21.76           C  
ATOM   1467  C   ARG A 179     -38.748  66.493  37.496  1.00 20.49           C  
ATOM   1468  O   ARG A 179     -38.324  67.125  38.464  1.00 20.78           O  
ATOM   1469  CB  ARG A 179     -37.109  64.690  36.879  1.00 22.02           C  
ATOM   1470  CG  ARG A 179     -36.007  65.150  37.831  1.00 24.49           C  
ATOM   1471  CD  ARG A 179     -36.169  64.501  39.202  1.00 23.55           C  
ATOM   1472  NE  ARG A 179     -35.225  65.005  40.204  1.00 23.49           N  
ATOM   1473  CZ  ARG A 179     -35.300  66.204  40.780  1.00 24.09           C  
ATOM   1474  NH1 ARG A 179     -36.276  67.044  40.455  1.00 19.47           N  
ATOM   1475  NH2 ARG A 179     -34.413  66.554  41.704  1.00 22.97           N  
ATOM   1476  N   ASP A 180     -39.409  67.070  36.499  1.00 19.49           N  
ATOM   1477  CA  ASP A 180     -39.700  68.502  36.512  1.00 19.30           C  
ATOM   1478  C   ASP A 180     -40.921  68.754  37.394  1.00 18.87           C  
ATOM   1479  O   ASP A 180     -40.922  69.670  38.215  1.00 19.36           O  
ATOM   1480  CB  ASP A 180     -39.962  69.017  35.092  1.00 15.28           C  
ATOM   1481  CG  ASP A 180     -38.707  69.029  34.241  1.00 18.40           C  
ATOM   1482  OD1 ASP A 180     -37.698  69.610  34.693  1.00 17.22           O  
ATOM   1483  OD2 ASP A 180     -38.723  68.465  33.123  1.00 17.89           O  
ATOM   1484  N   LEU A 181     -41.947  67.924  37.225  1.00 17.13           N  
ATOM   1485  CA  LEU A 181     -43.176  68.032  38.008  1.00 17.67           C  
ATOM   1486  C   LEU A 181     -42.828  67.947  39.489  1.00 16.98           C  
ATOM   1487  O   LEU A 181     -43.487  68.547  40.339  1.00 19.32           O  
ATOM   1488  CB  LEU A 181     -44.137  66.899  37.636  1.00 20.76           C  
ATOM   1489  CG  LEU A 181     -45.467  66.841  38.391  1.00 22.21           C  
ATOM   1490  CD1 LEU A 181     -46.237  68.146  38.180  1.00 21.57           C  
ATOM   1491  CD2 LEU A 181     -46.286  65.642  37.906  1.00 20.49           C  
ATOM   1492  N   ILE A 182     -41.776  67.195  39.782  1.00 18.54           N  
ATOM   1493  CA  ILE A 182     -41.299  67.010  41.147  1.00 18.85           C  
ATOM   1494  C   ILE A 182     -40.860  68.341  41.791  1.00 18.58           C  
ATOM   1495  O   ILE A 182     -41.037  68.539  42.995  1.00 17.62           O  
ATOM   1496  CB  ILE A 182     -40.122  65.992  41.140  1.00 20.99           C  
ATOM   1497  CG1 ILE A 182     -40.693  64.573  41.015  1.00 21.76           C  
ATOM   1498  CG2 ILE A 182     -39.238  66.166  42.366  1.00 22.39           C  
ATOM   1499  CD1 ILE A 182     -39.661  63.516  40.671  1.00 23.43           C  
ATOM   1500  N   SER A 183     -40.305  69.251  40.991  1.00 16.97           N  
ATOM   1501  CA  SER A 183     -39.842  70.541  41.522  1.00 16.63           C  
ATOM   1502  C   SER A 183     -40.983  71.346  42.125  1.00 16.73           C  
ATOM   1503  O   SER A 183     -40.759  72.185  43.007  1.00 16.64           O  
ATOM   1504  CB  SER A 183     -39.137  71.371  40.439  1.00 18.39           C  
ATOM   1505  OG  SER A 183     -40.053  71.870  39.478  1.00 17.40           O  
ATOM   1506  N   LEU A 184     -42.204  71.106  41.647  1.00 15.70           N  
ATOM   1507  CA  LEU A 184     -43.369  71.799  42.187  1.00 15.47           C  
ATOM   1508  C   LEU A 184     -43.519  71.390  43.648  1.00 16.37           C  
ATOM   1509  O   LEU A 184     -43.761  72.227  44.515  1.00 15.71           O  
ATOM   1510  CB  LEU A 184     -44.640  71.424  41.420  1.00 15.32           C  
ATOM   1511  CG  LEU A 184     -45.977  71.792  42.063  1.00 14.35           C  
ATOM   1512  CD1 LEU A 184     -46.077  73.293  42.271  1.00 17.23           C  
ATOM   1513  CD2 LEU A 184     -47.115  71.303  41.172  1.00 19.70           C  
ATOM   1514  N   GLY A 185     -43.380  70.095  43.912  1.00 16.53           N  
ATOM   1515  CA  GLY A 185     -43.490  69.612  45.277  1.00 16.72           C  
ATOM   1516  C   GLY A 185     -42.364  70.156  46.144  1.00 16.58           C  
ATOM   1517  O   GLY A 185     -42.584  70.554  47.287  1.00 17.69           O  
ATOM   1518  N   VAL A 186     -41.152  70.182  45.609  1.00 16.51           N  
ATOM   1519  CA  VAL A 186     -40.031  70.699  46.381  1.00 18.87           C  
ATOM   1520  C   VAL A 186     -40.306  72.157  46.733  1.00 18.54           C  
ATOM   1521  O   VAL A 186     -40.308  72.529  47.902  1.00 18.73           O  
ATOM   1522  CB  VAL A 186     -38.700  70.626  45.603  1.00 18.62           C  
ATOM   1523  CG1 VAL A 186     -37.603  71.318  46.405  1.00 21.23           C  
ATOM   1524  CG2 VAL A 186     -38.314  69.169  45.351  1.00 18.90           C  
ATOM   1525  N   VAL A 187     -40.581  72.972  45.720  1.00 17.92           N  
ATOM   1526  CA  VAL A 187     -40.831  74.388  45.955  1.00 17.74           C  
ATOM   1527  C   VAL A 187     -41.919  74.686  46.979  1.00 17.76           C  
ATOM   1528  O   VAL A 187     -41.832  75.692  47.689  1.00 18.05           O  
ATOM   1529  CB  VAL A 187     -41.135  75.130  44.629  1.00 18.00           C  
ATOM   1530  CG1 VAL A 187     -41.550  76.562  44.910  1.00 20.68           C  
ATOM   1531  CG2 VAL A 187     -39.892  75.117  43.747  1.00 16.20           C  
ATOM   1532  N   ILE A 188     -42.941  73.836  47.084  1.00 17.32           N  
ATOM   1533  CA  ILE A 188     -43.977  74.115  48.072  1.00 17.57           C  
ATOM   1534  C   ILE A 188     -43.654  73.528  49.448  1.00 18.37           C  
ATOM   1535  O   ILE A 188     -44.442  73.677  50.376  1.00 18.77           O  
ATOM   1536  CB  ILE A 188     -45.398  73.629  47.634  1.00 18.07           C  
ATOM   1537  CG1 ILE A 188     -45.414  72.114  47.432  1.00 17.49           C  
ATOM   1538  CG2 ILE A 188     -45.830  74.349  46.354  1.00 19.24           C  
ATOM   1539  CD1 ILE A 188     -46.817  71.546  47.254  1.00 15.98           C  
ATOM   1540  N   GLY A 189     -42.501  72.871  49.584  1.00 20.05           N  
ATOM   1541  CA  GLY A 189     -42.128  72.326  50.883  1.00 21.81           C  
ATOM   1542  C   GLY A 189     -41.622  70.890  50.956  1.00 24.50           C  
ATOM   1543  O   GLY A 189     -40.945  70.517  51.919  1.00 23.43           O  
ATOM   1544  N   MET A 190     -41.930  70.084  49.949  1.00 23.47           N  
ATOM   1545  CA  MET A 190     -41.506  68.682  49.941  1.00 24.93           C  
ATOM   1546  C   MET A 190     -40.022  68.470  49.738  1.00 25.61           C  
ATOM   1547  O   MET A 190     -39.368  69.233  49.025  1.00 25.45           O  
ATOM   1548  CB  MET A 190     -42.223  67.908  48.835  1.00 24.46           C  
ATOM   1549  CG  MET A 190     -43.701  67.698  49.030  1.00 26.80           C  
ATOM   1550  SD  MET A 190     -44.365  66.796  47.609  1.00 26.77           S  
ATOM   1551  CE  MET A 190     -45.960  67.522  47.475  1.00 23.93           C  
ATOM   1552  N   GLU A 191     -39.490  67.427  50.373  1.00 25.75           N  
ATOM   1553  CA  GLU A 191     -38.093  67.067  50.182  1.00 26.24           C  
ATOM   1554  C   GLU A 191     -38.162  66.269  48.885  1.00 25.18           C  
ATOM   1555  O   GLU A 191     -39.194  65.675  48.582  1.00 25.92           O  
ATOM   1556  CB  GLU A 191     -37.592  66.165  51.317  1.00 30.38           C  
ATOM   1557  CG  GLU A 191     -37.501  66.855  52.670  1.00 35.26           C  
ATOM   1558  CD  GLU A 191     -36.445  67.944  52.696  1.00 39.02           C  
ATOM   1559  OE1 GLU A 191     -36.388  68.696  53.691  1.00 43.64           O  
ATOM   1560  OE2 GLU A 191     -35.669  68.045  51.722  1.00 41.00           O  
ATOM   1561  N   ILE A 192     -37.084  66.254  48.116  1.00 24.23           N  
ATOM   1562  CA  ILE A 192     -37.085  65.524  46.854  1.00 28.34           C  
ATOM   1563  C   ILE A 192     -37.678  64.117  46.984  1.00 29.91           C  
ATOM   1564  O   ILE A 192     -38.536  63.726  46.187  1.00 30.19           O  
ATOM   1565  CB  ILE A 192     -35.659  65.464  46.260  1.00 26.34           C  
ATOM   1566  CG1 ILE A 192     -35.243  66.874  45.824  1.00 26.61           C  
ATOM   1567  CG2 ILE A 192     -35.606  64.485  45.090  1.00 26.93           C  
ATOM   1568  CD1 ILE A 192     -33.900  66.961  45.148  1.00 29.81           C  
ATOM   1569  N   PRO A 193     -37.247  63.345  47.999  1.00 31.70           N  
ATOM   1570  CA  PRO A 193     -37.776  61.987  48.181  1.00 31.98           C  
ATOM   1571  C   PRO A 193     -39.293  61.936  48.362  1.00 31.21           C  
ATOM   1572  O   PRO A 193     -39.942  60.989  47.916  1.00 32.35           O  
ATOM   1573  CB  PRO A 193     -37.017  61.489  49.411  1.00 33.08           C  
ATOM   1574  CG  PRO A 193     -35.685  62.160  49.254  1.00 33.03           C  
ATOM   1575  CD  PRO A 193     -36.098  63.575  48.894  1.00 32.15           C  
ATOM   1576  N   GLN A 194     -39.855  62.953  49.011  1.00 30.86           N  
ATOM   1577  CA  GLN A 194     -41.299  63.015  49.236  1.00 29.07           C  
ATOM   1578  C   GLN A 194     -42.029  63.415  47.948  1.00 29.04           C  
ATOM   1579  O   GLN A 194     -43.114  62.909  47.647  1.00 27.04           O  
ATOM   1580  CB  GLN A 194     -41.631  64.027  50.338  1.00 29.01           C  
ATOM   1581  CG  GLN A 194     -40.916  63.789  51.661  1.00 29.63           C  
ATOM   1582  CD  GLN A 194     -41.205  64.887  52.676  1.00 29.02           C  
ATOM   1583  OE1 GLN A 194     -42.043  64.730  53.565  1.00 30.79           O  
ATOM   1584  NE2 GLN A 194     -40.519  66.008  52.532  1.00 26.55           N  
ATOM   1585  N   ALA A 195     -41.442  64.340  47.198  1.00 28.38           N  
ATOM   1586  CA  ALA A 195     -42.046  64.770  45.943  1.00 29.28           C  
ATOM   1587  C   ALA A 195     -42.164  63.554  45.018  1.00 29.17           C  
ATOM   1588  O   ALA A 195     -43.214  63.314  44.422  1.00 29.29           O  
ATOM   1589  CB  ALA A 195     -41.190  65.856  45.293  1.00 27.13           C  
ATOM   1590  N   LYS A 196     -41.088  62.784  44.908  1.00 30.51           N  
ATOM   1591  CA  LYS A 196     -41.100  61.593  44.059  1.00 33.34           C  
ATOM   1592  C   LYS A 196     -42.197  60.634  44.499  1.00 33.10           C  
ATOM   1593  O   LYS A 196     -42.912  60.067  43.671  1.00 33.45           O  
ATOM   1594  CB  LYS A 196     -39.743  60.879  44.103  1.00 33.73           C  
ATOM   1595  CG  LYS A 196     -38.617  61.650  43.430  1.00 36.68           C  
ATOM   1596  CD  LYS A 196     -37.327  60.845  43.375  1.00 38.36           C  
ATOM   1597  CE  LYS A 196     -36.208  61.661  42.742  1.00 38.96           C  
ATOM   1598  NZ  LYS A 196     -34.907  60.936  42.691  1.00 40.70           N  
ATOM   1599  N   ALA A 197     -42.335  60.467  45.808  1.00 32.56           N  
ATOM   1600  CA  ALA A 197     -43.343  59.580  46.366  1.00 31.22           C  
ATOM   1601  C   ALA A 197     -44.758  60.015  45.994  1.00 31.28           C  
ATOM   1602  O   ALA A 197     -45.658  59.179  45.867  1.00 29.76           O  
ATOM   1603  CB  ALA A 197     -43.194  59.520  47.890  1.00 31.41           C  
ATOM   1604  N   SER A 198     -44.957  61.319  45.816  1.00 28.99           N  
ATOM   1605  CA  SER A 198     -46.277  61.835  45.478  1.00 29.27           C  
ATOM   1606  C   SER A 198     -46.703  61.492  44.055  1.00 28.02           C  
ATOM   1607  O   SER A 198     -47.867  61.659  43.699  1.00 27.86           O  
ATOM   1608  CB  SER A 198     -46.334  63.354  45.690  1.00 29.16           C  
ATOM   1609  OG  SER A 198     -45.444  64.028  44.820  1.00 34.00           O  
ATOM   1610  N   ILE A 199     -45.766  61.021  43.238  1.00 28.20           N  
ATOM   1611  CA  ILE A 199     -46.099  60.641  41.866  1.00 29.45           C  
ATOM   1612  C   ILE A 199     -45.686  59.198  41.573  1.00 31.31           C  
ATOM   1613  O   ILE A 199     -45.319  58.857  40.446  1.00 29.56           O  
ATOM   1614  CB  ILE A 199     -45.428  61.572  40.816  1.00 28.51           C  
ATOM   1615  CG1 ILE A 199     -43.908  61.505  40.946  1.00 26.91           C  
ATOM   1616  CG2 ILE A 199     -45.935  63.002  40.983  1.00 25.62           C  
ATOM   1617  CD1 ILE A 199     -43.173  62.101  39.762  1.00 25.67           C  
ATOM   1618  N   SER A 200     -45.744  58.354  42.599  1.00 33.76           N  
ATOM   1619  CA  SER A 200     -45.393  56.944  42.451  1.00 36.69           C  
ATOM   1620  C   SER A 200     -46.021  56.116  43.564  1.00 38.16           C  
ATOM   1621  O   SER A 200     -47.029  55.447  43.351  1.00 39.61           O  
ATOM   1622  CB  SER A 200     -43.874  56.767  42.469  1.00 35.45           C  
ATOM   1623  OG  SER A 200     -43.326  57.215  43.694  1.00 37.03           O  
ATOM   1624  N   MET A 201     -45.428  56.179  44.752  1.00 40.62           N  
ATOM   1625  CA  MET A 201     -45.915  55.434  45.908  1.00 41.46           C  
ATOM   1626  C   MET A 201     -47.366  55.754  46.258  1.00 41.14           C  
ATOM   1627  O   MET A 201     -48.211  54.860  46.309  1.00 39.72           O  
ATOM   1628  CB  MET A 201     -45.025  55.714  47.121  1.00 44.51           C  
ATOM   1629  CG  MET A 201     -45.444  54.982  48.385  1.00 48.38           C  
ATOM   1630  SD  MET A 201     -44.502  55.504  49.836  1.00 53.62           S  
ATOM   1631  CE  MET A 201     -42.967  54.606  49.581  1.00 51.16           C  
ATOM   1632  N   TYR A 202     -47.664  57.025  46.504  1.00 39.17           N  
ATOM   1633  CA  TYR A 202     -49.025  57.388  46.857  1.00 40.04           C  
ATOM   1634  C   TYR A 202     -50.053  57.051  45.782  1.00 40.09           C  
ATOM   1635  O   TYR A 202     -51.140  56.569  46.095  1.00 39.42           O  
ATOM   1636  CB  TYR A 202     -49.101  58.862  47.262  1.00 40.51           C  
ATOM   1637  CG  TYR A 202     -48.570  59.073  48.662  1.00 41.82           C  
ATOM   1638  CD1 TYR A 202     -47.203  59.206  48.900  1.00 42.67           C  
ATOM   1639  CD2 TYR A 202     -49.430  59.040  49.760  1.00 42.72           C  
ATOM   1640  CE1 TYR A 202     -46.704  59.293  50.201  1.00 44.60           C  
ATOM   1641  CE2 TYR A 202     -48.944  59.124  51.060  1.00 42.72           C  
ATOM   1642  CZ  TYR A 202     -47.584  59.247  51.274  1.00 44.43           C  
ATOM   1643  OH  TYR A 202     -47.102  59.297  52.561  1.00 46.39           O  
ATOM   1644  N   PRO A 203     -49.739  57.313  44.505  1.00 39.72           N  
ATOM   1645  CA  PRO A 203     -50.729  56.971  43.481  1.00 39.94           C  
ATOM   1646  C   PRO A 203     -51.084  55.480  43.579  1.00 41.09           C  
ATOM   1647  O   PRO A 203     -52.243  55.096  43.409  1.00 40.05           O  
ATOM   1648  CB  PRO A 203     -50.009  57.323  42.187  1.00 39.44           C  
ATOM   1649  CG  PRO A 203     -49.243  58.551  42.589  1.00 39.81           C  
ATOM   1650  CD  PRO A 203     -48.663  58.145  43.937  1.00 39.99           C  
ATOM   1651  N   GLU A 204     -50.076  54.657  43.868  1.00 40.89           N  
ATOM   1652  CA  GLU A 204     -50.258  53.212  44.016  1.00 44.19           C  
ATOM   1653  C   GLU A 204     -51.380  52.937  45.013  1.00 44.90           C  
ATOM   1654  O   GLU A 204     -52.364  52.274  44.696  1.00 44.53           O  
ATOM   1655  CB  GLU A 204     -48.984  52.561  44.554  1.00 44.18           C  
ATOM   1656  CG  GLU A 204     -47.736  52.725  43.707  1.00 48.91           C  
ATOM   1657  CD  GLU A 204     -47.589  51.645  42.658  1.00 51.28           C  
ATOM   1658  OE1 GLU A 204     -47.834  50.466  42.990  1.00 53.63           O  
ATOM   1659  OE2 GLU A 204     -47.211  51.969  41.511  1.00 53.09           O  
ATOM   1660  N   ILE A 205     -51.206  53.448  46.229  1.00 45.93           N  
ATOM   1661  CA  ILE A 205     -52.174  53.274  47.300  1.00 46.82           C  
ATOM   1662  C   ILE A 205     -53.577  53.651  46.843  1.00 47.82           C  
ATOM   1663  O   ILE A 205     -54.543  52.937  47.120  1.00 47.94           O  
ATOM   1664  CB  ILE A 205     -51.816  54.151  48.524  1.00 47.37           C  
ATOM   1665  CG1 ILE A 205     -50.369  53.891  48.952  1.00 47.57           C  
ATOM   1666  CG2 ILE A 205     -52.784  53.870  49.667  1.00 48.32           C  
ATOM   1667  CD1 ILE A 205     -50.077  52.451  49.307  1.00 47.51           C  
ATOM   1668  N   ILE A 206     -53.687  54.778  46.151  1.00 48.33           N  
ATOM   1669  CA  ILE A 206     -54.978  55.243  45.665  1.00 50.30           C  
ATOM   1670  C   ILE A 206     -55.579  54.217  44.710  1.00 51.69           C  
ATOM   1671  O   ILE A 206     -56.780  53.955  44.746  1.00 51.54           O  
ATOM   1672  CB  ILE A 206     -54.850  56.595  44.928  1.00 49.09           C  
ATOM   1673  CG1 ILE A 206     -54.131  57.614  45.816  1.00 49.81           C  
ATOM   1674  CG2 ILE A 206     -56.230  57.118  44.559  1.00 48.59           C  
ATOM   1675  CD1 ILE A 206     -54.855  57.914  47.106  1.00 50.41           C  
ATOM   1676  N   LEU A 207     -54.731  53.637  43.863  1.00 53.12           N  
ATOM   1677  CA  LEU A 207     -55.160  52.639  42.887  1.00 55.23           C  
ATOM   1678  C   LEU A 207     -55.219  51.236  43.496  1.00 57.34           C  
ATOM   1679  O   LEU A 207     -55.688  50.295  42.854  1.00 57.78           O  
ATOM   1680  CB  LEU A 207     -54.201  52.632  41.692  1.00 54.37           C  
ATOM   1681  CG  LEU A 207     -53.967  53.946  40.937  1.00 53.34           C  
ATOM   1682  CD1 LEU A 207     -52.917  53.732  39.866  1.00 52.43           C  
ATOM   1683  CD2 LEU A 207     -55.264  54.434  40.320  1.00 53.27           C  
ATOM   1684  N   LYS A 208     -54.736  51.103  44.729  1.00 59.02           N  
ATOM   1685  CA  LYS A 208     -54.720  49.821  45.434  1.00 60.78           C  
ATOM   1686  C   LYS A 208     -56.102  49.173  45.451  1.00 61.13           C  
ATOM   1687  O   LYS A 208     -56.228  47.954  45.343  1.00 61.08           O  
ATOM   1688  CB  LYS A 208     -54.225  50.024  46.872  1.00 62.28           C  
ATOM   1689  CG  LYS A 208     -54.071  48.746  47.698  1.00 63.98           C  
ATOM   1690  CD  LYS A 208     -52.685  48.105  47.565  1.00 65.40           C  
ATOM   1691  CE  LYS A 208     -52.448  47.456  46.203  1.00 66.47           C  
ATOM   1692  NZ  LYS A 208     -52.269  48.437  45.100  1.00 66.82           N  
ATOM   1693  N   ARG A 209     -57.136  49.995  45.590  1.00 62.07           N  
ATOM   1694  CA  ARG A 209     -58.507  49.506  45.615  1.00 62.80           C  
ATOM   1695  C   ARG A 209     -58.908  48.980  44.238  1.00 63.37           C  
ATOM   1696  O   ARG A 209     -58.017  48.853  43.370  1.00 63.75           O  
ATOM   1697  CB  ARG A 209     -59.460  50.628  46.031  1.00 63.32           C  
ATOM   1698  CG  ARG A 209     -59.416  51.832  45.109  1.00 64.30           C  
ATOM   1699  CD  ARG A 209     -60.542  52.804  45.400  1.00 65.59           C  
ATOM   1700  NE  ARG A 209     -61.843  52.151  45.333  1.00 67.13           N  
ATOM   1701  CZ  ARG A 209     -63.001  52.798  45.271  1.00 68.37           C  
ATOM   1702  NH1 ARG A 209     -63.024  54.123  45.263  1.00 69.06           N  
ATOM   1703  NH2 ARG A 209     -64.140  52.118  45.221  1.00 69.29           N  
TER    1704      ARG A 209                                                      
END
MOLECULE T0440.pdb
ATOM      1  N   MET     1     -40.847  56.255  40.680  1.00 38.33           N  
ATOM      2  CA  MET     1     -42.194  56.148  40.050  1.00 38.30           C  
ATOM      3  C   MET     1     -42.716  57.542  39.716  1.00 37.02           C  
ATOM      4  O   MET     1     -42.489  58.495  40.460  1.00 38.04           O  
ATOM      5  CB  MET     1     -43.162  55.432  40.998  1.00 38.58           C  
ATOM      6  N   LYS     2     -43.418  57.657  38.596  1.00 34.84           N  
ATOM      7  CA  LYS     2     -43.956  58.939  38.166  1.00 32.15           C  
ATOM      8  C   LYS     2     -45.432  58.763  37.827  1.00 29.78           C  
ATOM      9  O   LYS     2     -45.783  58.072  36.873  1.00 28.95           O  
ATOM     10  CB  LYS     2     -43.171  59.436  36.954  1.00 32.26           C  
ATOM     11  CG  LYS     2     -43.327  60.909  36.662  1.00 33.32           C  
ATOM     12  CD  LYS     2     -42.210  61.393  35.744  1.00 34.91           C  
ATOM     13  CE  LYS     2     -42.404  62.847  35.345  1.00 35.48           C  
ATOM     14  NZ  LYS     2     -41.315  63.305  34.439  1.00 34.78           N  
ATOM     15  N   ARG     3     -46.294  59.397  38.614  1.00 27.55           N  
ATOM     16  CA  ARG     3     -47.737  59.274  38.428  1.00 24.76           C  
ATOM     17  C   ARG     3     -48.481  60.606  38.323  1.00 23.58           C  
ATOM     18  O   ARG     3     -48.152  61.564  39.027  1.00 23.54           O  
ATOM     19  CB  ARG     3     -48.315  58.470  39.603  1.00 24.53           C  
ATOM     20  CG  ARG     3     -49.825  58.431  39.671  1.00 23.18           C  
ATOM     21  CD  ARG     3     -50.303  57.757  40.952  1.00 23.52           C  
ATOM     22  NE  ARG     3     -51.759  57.639  40.967  1.00 22.78           N  
ATOM     23  CZ  ARG     3     -52.478  57.305  42.034  1.00 24.08           C  
ATOM     24  NH1 ARG     3     -51.877  57.051  43.190  1.00 23.17           N  
ATOM     25  NH2 ARG     3     -53.799  57.235  41.944  1.00 23.37           N  
ATOM     26  N   ASP     4     -49.489  60.651  37.453  1.00 21.36           N  
ATOM     27  CA  ASP     4     -50.349  61.833  37.297  1.00 21.21           C  
ATOM     28  C   ASP     4     -51.779  61.354  37.579  1.00 20.57           C  
ATOM     29  O   ASP     4     -52.336  60.529  36.850  1.00 20.68           O  
ATOM     30  CB  ASP     4     -50.238  62.414  35.878  1.00 20.11           C  
ATOM     31  CG  ASP     4     -51.030  63.720  35.700  1.00 20.54           C  
ATOM     32  OD1 ASP     4     -50.882  64.365  34.638  1.00 19.64           O  
ATOM     33  OD2 ASP     4     -51.802  64.107  36.606  1.00 18.64           O  
ATOM     34  N   GLY     5     -52.367  61.850  38.657  1.00 20.40           N  
ATOM     35  CA  GLY     5     -53.705  61.409  39.010  1.00 20.01           C  
ATOM     36  C   GLY     5     -54.821  62.363  38.638  1.00 20.02           C  
ATOM     37  O   GLY     5     -55.908  62.305  39.214  1.00 20.91           O  
ATOM     38  N   HIS     6     -54.584  63.237  37.669  1.00 19.73           N  
ATOM     39  CA  HIS     6     -55.624  64.189  37.311  1.00 18.82           C  
ATOM     40  C   HIS     6     -55.457  64.720  35.893  1.00 19.13           C  
ATOM     41  O   HIS     6     -54.725  65.681  35.662  1.00 18.07           O  
ATOM     42  CB  HIS     6     -55.608  65.333  38.338  1.00 19.32           C  
ATOM     43  CG  HIS     6     -56.847  66.167  38.353  1.00 18.49           C  
ATOM     44  ND1 HIS     6     -57.222  66.916  39.448  1.00 18.33           N  
ATOM     45  CD2 HIS     6     -57.786  66.395  37.403  1.00 16.33           C  
ATOM     46  CE1 HIS     6     -58.337  67.569  39.173  1.00 18.17           C  
ATOM     47  NE2 HIS     6     -58.699  67.268  37.939  1.00 17.88           N  
ATOM     48  N   THR     7     -56.126  64.079  34.935  1.00 18.69           N  
ATOM     49  CA  THR     7     -56.060  64.524  33.544  1.00 19.68           C  
ATOM     50  C   THR     7     -57.433  64.486  32.878  1.00 19.99           C  
ATOM     51  O   THR     7     -58.336  63.776  33.321  1.00 19.96           O  
ATOM     52  CB  THR     7     -55.105  63.661  32.712  1.00 19.49           C  
ATOM     53  OG1 THR     7     -55.690  62.369  32.511  1.00 19.21           O  
ATOM     54  CG2 THR     7     -53.754  63.517  33.427  1.00 17.78           C  
ATOM     55  N   HIS     8     -57.578  65.246  31.801  1.00 20.50           N  
ATOM     56  CA  HIS     8     -58.843  65.320  31.089  1.00 21.17           C  
ATOM     57  C   HIS     8     -58.718  64.908  29.625  1.00 21.62           C  
ATOM     58  O   HIS     8     -57.622  64.609  29.152  1.00 20.75           O  
ATOM     59  CB  HIS     8     -59.424  66.723  31.246  1.00 20.98           C  
ATOM     60  CG  HIS     8     -59.872  67.012  32.644  1.00 22.64           C  
ATOM     61  ND1 HIS     8     -61.104  66.621  33.126  1.00 21.49           N  
ATOM     62  CD2 HIS     8     -59.225  67.585  33.687  1.00 23.08           C  
ATOM     63  CE1 HIS     8     -61.199  66.946  34.404  1.00 20.90           C  
ATOM     64  NE2 HIS     8     -60.072  67.532  34.768  1.00 22.21           N  
ATOM     65  N   THR     9     -59.844  64.889  28.914  1.00 22.45           N  
ATOM     66  CA  THR     9     -59.865  64.419  27.533  1.00 23.50           C  
ATOM     67  C   THR     9     -60.677  65.284  26.581  1.00 24.81           C  
ATOM     68  O   THR     9     -61.152  66.362  26.940  1.00 25.56           O  
ATOM     69  CB  THR     9     -60.464  63.000  27.457  1.00 23.68           C  
ATOM     70  OG1 THR     9     -61.875  63.067  27.717  1.00 23.01           O  
ATOM     71  CG2 THR     9     -59.815  62.089  28.491  1.00 22.69           C  
ATOM     72  N   GLU    10     -60.854  64.776  25.363  1.00 25.86           N  
ATOM     73  CA  GLU    10     -61.629  65.464  24.341  1.00 26.95           C  
ATOM     74  C   GLU    10     -63.112  65.482  24.720  1.00 27.63           C  
ATOM     75  O   GLU    10     -63.914  66.177  24.093  1.00 27.20           O  
ATOM     76  CB  GLU    10     -61.447  64.784  22.975  1.00 26.58           C  
ATOM     77  CG  GLU    10     -61.990  63.350  22.881  1.00 28.00           C  
ATOM     78  CD  GLU    10     -60.990  62.282  23.326  1.00 27.24           C  
ATOM     79  OE1 GLU    10     -59.975  62.623  23.972  1.00 27.48           O  
ATOM     80  OE2 GLU    10     -61.231  61.091  23.030  1.00 28.62           O  
ATOM     81  N   PHE    11     -63.469  64.710  25.743  1.00 28.15           N  
ATOM     82  CA  PHE    11     -64.850  64.645  26.213  1.00 29.40           C  
ATOM     83  C   PHE    11     -65.169  65.811  27.149  1.00 30.59           C  
ATOM     84  O   PHE    11     -66.269  65.897  27.691  1.00 31.46           O  
ATOM     85  CB  PHE    11     -65.101  63.312  26.925  1.00 29.24           C  
ATOM     86  CG  PHE    11     -65.374  62.170  25.988  1.00 30.30           C  
ATOM     87  CD1 PHE    11     -66.669  61.909  25.548  1.00 31.04           C  
ATOM     88  CD2 PHE    11     -64.338  61.359  25.537  1.00 30.49           C  
ATOM     89  CE1 PHE    11     -66.927  60.860  24.675  1.00 31.64           C  
ATOM     90  CE2 PHE    11     -64.584  60.303  24.662  1.00 30.53           C  
ATOM     91  CZ  PHE    11     -65.881  60.053  24.231  1.00 31.61           C  
ATOM     92  N   CYS    12     -64.198  66.702  27.336  1.00 30.83           N  
ATOM     93  CA  CYS    12     -64.377  67.876  28.183  1.00 30.91           C  
ATOM     94  C   CYS    12     -64.749  69.059  27.296  1.00 30.93           C  
ATOM     95  O   CYS    12     -63.955  69.504  26.473  1.00 30.92           O  
ATOM     96  CB  CYS    12     -63.093  68.186  28.952  1.00 30.77           C  
ATOM     97  SG  CYS    12     -63.216  69.677  29.963  1.00 30.86           S  
ATOM     98  N   PRO    13     -65.964  69.596  27.467  1.00 31.17           N  
ATOM     99  CA  PRO    13     -66.439  70.729  26.666  1.00 31.95           C  
ATOM    100  C   PRO    13     -65.546  71.967  26.680  1.00 32.57           C  
ATOM    101  O   PRO    13     -65.465  72.678  25.685  1.00 33.04           O  
ATOM    102  CB  PRO    13     -67.825  71.005  27.248  1.00 32.07           C  
ATOM    103  CG  PRO    13     -68.247  69.662  27.785  1.00 31.94           C  
ATOM    104  CD  PRO    13     -66.982  69.188  28.446  1.00 30.62           C  
ATOM    105  N   HIS    14     -64.881  72.231  27.800  1.00 33.02           N  
ATOM    106  CA  HIS    14     -64.017  73.403  27.884  1.00 33.81           C  
ATOM    107  C   HIS    14     -62.537  73.078  27.732  1.00 34.20           C  
ATOM    108  O   HIS    14     -61.681  73.927  27.991  1.00 33.50           O  
ATOM    109  CB  HIS    14     -64.229  74.140  29.202  1.00 34.42           C  
ATOM    110  CG  HIS    14     -64.125  73.263  30.407  1.00 35.96           C  
ATOM    111  ND1 HIS    14     -65.183  72.510  30.871  1.00 37.33           N  
ATOM    112  CD2 HIS    14     -63.080  72.991  31.226  1.00 35.75           C  
ATOM    113  CE1 HIS    14     -64.794  71.812  31.923  1.00 38.40           C  
ATOM    114  NE2 HIS    14     -63.523  72.085  32.158  1.00 36.30           N  
ATOM    115  N   GLY    15     -62.232  71.846  27.335  1.00 33.93           N  
ATOM    116  CA  GLY    15     -60.844  71.474  27.143  1.00 34.73           C  
ATOM    117  C   GLY    15     -60.325  71.976  25.808  1.00 35.34           C  
ATOM    118  O   GLY    15     -61.019  72.691  25.084  1.00 35.68           O  
ATOM    119  N   THR    16     -59.106  71.586  25.473  1.00 34.96           N  
ATOM    120  CA  THR    16     -58.490  71.992  24.222  1.00 35.46           C  
ATOM    121  C   THR    16     -58.976  71.086  23.093  1.00 35.25           C  
ATOM    122  O   THR    16     -58.700  71.327  21.915  1.00 34.96           O  
ATOM    123  CB  THR    16     -56.962  71.876  24.321  1.00 35.94           C  
ATOM    124  OG1 THR    16     -56.356  72.537  23.204  1.00 40.50           O  
ATOM    125  CG2 THR    16     -56.556  70.415  24.321  1.00 33.61           C  
ATOM    126  N   HIS    17     -59.697  70.038  23.474  1.00 34.98           N  
ATOM    127  CA  HIS    17     -60.223  69.050  22.539  1.00 34.90           C  
ATOM    128  C   HIS    17     -59.154  68.156  21.921  1.00 34.06           C  
ATOM    129  O   HIS    17     -59.437  67.406  20.985  1.00 34.16           O  
ATOM    130  CB  HIS    17     -61.059  69.710  21.438  1.00 35.49           C  
ATOM    131  CG  HIS    17     -62.307  70.357  21.948  1.00 37.82           C  
ATOM    132  ND1 HIS    17     -62.357  71.684  22.316  1.00 39.69           N  
ATOM    133  CD2 HIS    17     -63.526  69.842  22.235  1.00 40.96           C  
ATOM    134  CE1 HIS    17     -63.552  71.958  22.810  1.00 41.61           C  
ATOM    135  NE2 HIS    17     -64.281  70.857  22.772  1.00 40.83           N  
ATOM    136  N   ASP    18     -57.927  68.229  22.438  1.00 32.37           N  
ATOM    137  CA  ASP    18     -56.877  67.346  21.942  1.00 31.29           C  
ATOM    138  C   ASP    18     -57.343  65.923  22.234  1.00 30.50           C  
ATOM    139  O   ASP    18     -58.133  65.692  23.152  1.00 30.14           O  
ATOM    140  CB  ASP    18     -55.544  67.555  22.670  1.00 31.24           C  
ATOM    141  CG  ASP    18     -54.868  68.866  22.318  1.00 31.81           C  
ATOM    142  OD1 ASP    18     -55.285  69.525  21.344  1.00 31.72           O  
ATOM    143  OD2 ASP    18     -53.904  69.231  23.029  1.00 29.97           O  
ATOM    144  N   ASP    19     -56.835  64.969  21.468  1.00 29.97           N  
ATOM    145  CA  ASP    19     -57.203  63.582  21.671  1.00 29.68           C  
ATOM    146  C   ASP    19     -56.405  63.016  22.842  1.00 28.58           C  
ATOM    147  O   ASP    19     -55.196  63.227  22.944  1.00 28.17           O  
ATOM    148  CB  ASP    19     -56.918  62.777  20.403  1.00 30.51           C  
ATOM    149  CG  ASP    19     -57.471  61.368  20.470  1.00 31.88           C  
ATOM    150  OD1 ASP    19     -57.104  60.618  21.399  1.00 30.93           O  
ATOM    151  OD2 ASP    19     -58.277  61.013  19.588  1.00 39.55           O  
ATOM    152  N   VAL    20     -57.092  62.296  23.722  1.00 27.29           N  
ATOM    153  CA  VAL    20     -56.456  61.686  24.882  1.00 26.40           C  
ATOM    154  C   VAL    20     -55.247  60.844  24.486  1.00 26.04           C  
ATOM    155  O   VAL    20     -54.262  60.773  25.223  1.00 24.98           O  
ATOM    156  CB  VAL    20     -57.454  60.785  25.657  1.00 26.45           C  
ATOM    157  CG1 VAL    20     -58.030  59.715  24.733  1.00 26.42           C  
ATOM    158  CG2 VAL    20     -56.761  60.141  26.849  1.00 26.16           C  
ATOM    159  N   GLU    21     -55.316  60.205  23.324  1.00 25.64           N  
ATOM    160  CA  GLU    21     -54.213  59.360  22.888  1.00 26.27           C  
ATOM    161  C   GLU    21     -52.922  60.148  22.729  1.00 25.89           C  
ATOM    162  O   GLU    21     -51.849  59.673  23.086  1.00 24.75           O  
ATOM    163  CB  GLU    21     -54.553  58.655  21.571  1.00 26.32           C  
ATOM    164  CG  GLU    21     -53.485  57.663  21.136  1.00 28.87           C  
ATOM    165  CD  GLU    21     -54.016  56.591  20.203  1.00 32.83           C  
ATOM    166  OE1 GLU    21     -55.243  56.551  19.969  1.00 33.36           O  
ATOM    167  OE2 GLU    21     -53.204  55.781  19.710  1.00 36.08           O  
ATOM    168  N   GLU    22     -53.033  61.359  22.199  1.00 26.58           N  
ATOM    169  CA  GLU    22     -51.871  62.211  21.998  1.00 27.45           C  
ATOM    170  C   GLU    22     -51.333  62.659  23.354  1.00 26.54           C  
ATOM    171  O   GLU    22     -50.129  62.878  23.521  1.00 25.22           O  
ATOM    172  CB  GLU    22     -52.260  63.417  21.152  1.00 28.65           C  
ATOM    173  CG  GLU    22     -51.088  64.183  20.588  1.00 34.75           C  
ATOM    174  CD  GLU    22     -51.514  65.112  19.479  1.00 42.94           C  
ATOM    175  OE1 GLU    22     -52.169  64.632  18.528  1.00 48.49           O  
ATOM    176  OE2 GLU    22     -51.202  66.318  19.552  1.00 45.91           O  
ATOM    177  N   MET    23     -52.235  62.792  24.320  1.00 24.70           N  
ATOM    178  CA  MET    23     -51.851  63.176  25.668  1.00 24.81           C  
ATOM    179  C   MET    23     -51.116  62.018  26.332  1.00 24.29           C  
ATOM    180  O   MET    23     -50.134  62.224  27.044  1.00 24.59           O  
ATOM    181  CB  MET    23     -53.086  63.548  26.481  1.00 23.35           C  
ATOM    182  CG  MET    23     -53.733  64.824  25.998  1.00 27.56           C  
ATOM    183  SD  MET    23     -55.430  65.214  26.846  1.00 36.37          SE  
ATOM    184  CE  MET    23     -56.223  66.255  25.437  1.00 39.44           C  
ATOM    185  N   VAL    24     -51.592  60.800  26.090  1.00 24.57           N  
ATOM    186  CA  VAL    24     -50.955  59.615  26.658  1.00 24.14           C  
ATOM    187  C   VAL    24     -49.558  59.408  26.071  1.00 24.13           C  
ATOM    188  O   VAL    24     -48.620  59.057  26.792  1.00 23.58           O  
ATOM    189  CB  VAL    24     -51.808  58.347  26.414  1.00 24.20           C  
ATOM    190  CG1 VAL    24     -50.972  57.091  26.639  1.00 23.69           C  
ATOM    191  CG2 VAL    24     -53.002  58.348  27.357  1.00 24.29           C  
ATOM    192  N   LEU    25     -49.417  59.620  24.765  1.00 23.82           N  
ATOM    193  CA  LEU    25     -48.119  59.462  24.117  1.00 23.95           C  
ATOM    194  C   LEU    25     -47.120  60.454  24.708  1.00 24.01           C  
ATOM    195  O   LEU    25     -45.952  60.122  24.938  1.00 24.46           O  
ATOM    196  CB  LEU    25     -48.251  59.674  22.606  1.00 24.75           C  
ATOM    197  CG  LEU    25     -48.919  58.531  21.833  1.00 24.68           C  
ATOM    198  CD1 LEU    25     -49.305  58.994  20.434  1.00 25.81           C  
ATOM    199  CD2 LEU    25     -47.971  57.339  21.771  1.00 27.20           C  
ATOM    200  N   LYS    26     -47.584  61.672  24.967  1.00 24.19           N  
ATOM    201  CA  LYS    26     -46.726  62.691  25.561  1.00 24.43           C  
ATOM    202  C   LYS    26     -46.343  62.284  26.982  1.00 24.04           C  
ATOM    203  O   LYS    26     -45.199  62.469  27.401  1.00 25.04           O  
ATOM    204  CB  LYS    26     -47.435  64.042  25.587  1.00 24.34           C  
ATOM    205  CG  LYS    26     -46.636  65.142  26.277  1.00 28.30           C  
ATOM    206  CD  LYS    26     -45.344  65.452  25.537  1.00 33.54           C  
ATOM    207  CE  LYS    26     -44.615  66.629  26.177  1.00 38.71           C  
ATOM    208  NZ  LYS    26     -43.472  67.109  25.340  1.00 42.35           N  
ATOM    209  N   ALA    27     -47.298  61.735  27.728  1.00 23.91           N  
ATOM    210  CA  ALA    27     -47.005  61.303  29.089  1.00 24.24           C  
ATOM    211  C   ALA    27     -45.944  60.205  29.074  1.00 24.98           C  
ATOM    212  O   ALA    27     -45.070  60.164  29.937  1.00 24.85           O  
ATOM    213  CB  ALA    27     -48.266  60.805  29.779  1.00 23.73           C  
ATOM    214  N   ILE    28     -46.030  59.305  28.100  1.00 26.29           N  
ATOM    215  CA  ILE    28     -45.051  58.230  27.996  1.00 27.14           C  
ATOM    216  C   ILE    28     -43.690  58.839  27.668  1.00 28.52           C  
ATOM    217  O   ILE    28     -42.675  58.450  28.233  1.00 28.52           O  
ATOM    218  CB  ILE    28     -45.462  57.214  26.910  1.00 27.18           C  
ATOM    219  CG1 ILE    28     -46.731  56.483  27.359  1.00 25.08           C  
ATOM    220  CG2 ILE    28     -44.330  56.228  26.650  1.00 26.49           C  
ATOM    221  CD1 ILE    28     -47.313  55.551  26.318  1.00 22.09           C  
ATOM    222  N   GLU    29     -43.683  59.811  26.765  1.00 30.20           N  
ATOM    223  CA  GLU    29     -42.453  60.496  26.384  1.00 32.05           C  
ATOM    224  C   GLU    29     -41.795  61.097  27.628  1.00 32.33           C  
ATOM    225  O   GLU    29     -40.566  61.104  27.752  1.00 32.72           O  
ATOM    226  CB  GLU    29     -42.769  61.613  25.387  1.00 32.36           C  
ATOM    227  CG  GLU    29     -41.554  62.245  24.719  1.00 37.12           C  
ATOM    228  CD  GLU    29     -41.911  63.524  23.975  1.00 43.15           C  
ATOM    229  OE1 GLU    29     -43.004  63.580  23.368  1.00 43.94           O  
ATOM    230  OE2 GLU    29     -41.097  64.473  23.990  1.00 46.77           O  
ATOM    231  N   LEU    30     -42.615  61.602  28.549  1.00 32.15           N  
ATOM    232  CA  LEU    30     -42.102  62.218  29.773  1.00 31.77           C  
ATOM    233  C   LEU    30     -41.890  61.245  30.934  1.00 31.74           C  
ATOM    234  O   LEU    30     -41.790  61.659  32.093  1.00 31.25           O  
ATOM    235  CB  LEU    30     -43.018  63.368  30.213  1.00 32.07           C  
ATOM    236  CG  LEU    30     -43.190  64.475  29.163  1.00 32.41           C  
ATOM    237  CD1 LEU    30     -43.983  65.641  29.736  1.00 32.33           C  
ATOM    238  CD2 LEU    30     -41.813  64.945  28.700  1.00 35.89           C  
ATOM    239  N   ASP    31     -41.835  59.955  30.614  1.00 31.32           N  
ATOM    240  CA  ASP    31     -41.575  58.901  31.596  1.00 31.90           C  
ATOM    241  C   ASP    31     -42.587  58.632  32.712  1.00 30.97           C  
ATOM    242  O   ASP    31     -42.227  58.105  33.764  1.00 30.42           O  
ATOM    243  CB  ASP    31     -40.196  59.110  32.231  1.00 33.31           C  
ATOM    244  CG  ASP    31     -39.075  59.100  31.208  1.00 36.63           C  
ATOM    245  OD1 ASP    31     -38.964  58.122  30.440  1.00 38.03           O  
ATOM    246  OD2 ASP    31     -38.298  60.073  31.172  1.00 40.43           O  
ATOM    247  N   PHE    32     -43.846  58.988  32.502  1.00 30.11           N  
ATOM    248  CA  PHE    32     -44.858  58.694  33.509  1.00 30.00           C  
ATOM    249  C   PHE    32     -45.162  57.201  33.416  1.00 30.02           C  
ATOM    250  O   PHE    32     -45.183  56.647  32.322  1.00 29.57           O  
ATOM    251  CB  PHE    32     -46.133  59.497  33.236  1.00 29.43           C  
ATOM    252  CG  PHE    32     -46.096  60.901  33.767  1.00 28.82           C  
ATOM    253  CD1 PHE    32     -46.449  61.171  35.087  1.00 28.23           C  
ATOM    254  CD2 PHE    32     -45.683  61.951  32.953  1.00 27.29           C  
ATOM    255  CE1 PHE    32     -46.388  62.467  35.588  1.00 28.98           C  
ATOM    256  CE2 PHE    32     -45.619  63.243  33.443  1.00 29.04           C  
ATOM    257  CZ  PHE    32     -45.972  63.503  34.766  1.00 28.17           C  
ATOM    258  N   ASP    33     -45.380  56.542  34.547  1.00 30.14           N  
ATOM    259  CA  ASP    33     -45.698  55.122  34.495  1.00 31.22           C  
ATOM    260  C   ASP    33     -47.094  54.812  35.023  1.00 30.44           C  
ATOM    261  O   ASP    33     -47.541  53.670  34.982  1.00 29.71           O  
ATOM    262  CB  ASP    33     -44.646  54.306  35.244  1.00 32.46           C  
ATOM    263  CG  ASP    33     -44.305  54.895  36.580  1.00 36.15           C  
ATOM    264  OD1 ASP    33     -45.179  54.873  37.475  1.00 41.79           O  
ATOM    265  OD2 ASP    33     -43.160  55.380  36.732  1.00 40.62           O  
ATOM    266  N   GLU    34     -47.780  55.838  35.515  1.00 29.18           N  
ATOM    267  CA  GLU    34     -49.142  55.682  36.016  1.00 28.10           C  
ATOM    268  C   GLU    34     -49.890  56.947  35.613  1.00 27.02           C  
ATOM    269  O   GLU    34     -49.395  58.059  35.800  1.00 25.67           O  
ATOM    270  CB  GLU    34     -49.149  55.493  37.523  1.00 28.15           C  
ATOM    271  CG  GLU    34     -50.391  54.776  38.012  1.00 30.61           C  
ATOM    272  CD  GLU    34     -50.260  54.285  39.434  1.00 32.72           C  
ATOM    273  OE1 GLU    34     -49.191  54.490  40.036  1.00 33.86           O  
ATOM    274  OE2 GLU    34     -51.228  53.692  39.948  1.00 37.58           O  
ATOM    275  N   TYR    35     -51.083  56.773  35.059  1.00 25.86           N  
ATOM    276  CA  TYR    35     -51.839  57.898  34.529  1.00 25.06           C  
ATOM    277  C   TYR    35     -53.343  57.719  34.725  1.00 24.72           C  
ATOM    278  O   TYR    35     -53.910  56.700  34.324  1.00 25.22           O  
ATOM    279  CB  TYR    35     -51.496  58.000  33.039  1.00 24.41           C  
ATOM    280  CG  TYR    35     -52.047  59.170  32.261  1.00 23.98           C  
ATOM    281  CD1 TYR    35     -51.261  60.287  32.002  1.00 22.99           C  
ATOM    282  CD2 TYR    35     -53.325  59.124  31.710  1.00 22.11           C  
ATOM    283  CE1 TYR    35     -51.725  61.326  31.198  1.00 22.88           C  
ATOM    284  CE2 TYR    35     -53.801  60.151  30.911  1.00 22.76           C  
ATOM    285  CZ  TYR    35     -52.994  61.251  30.654  1.00 23.60           C  
ATOM    286  OH  TYR    35     -53.441  62.244  29.812  1.00 22.37           O  
ATOM    287  N   SER    36     -53.989  58.711  35.333  1.00 23.42           N  
ATOM    288  CA  SER    36     -55.429  58.636  35.564  1.00 22.40           C  
ATOM    289  C   SER    36     -56.245  59.625  34.736  1.00 21.69           C  
ATOM    290  O   SER    36     -55.979  60.832  34.715  1.00 20.94           O  
ATOM    291  CB  SER    36     -55.763  58.846  37.048  1.00 21.81           C  
ATOM    292  OG  SER    36     -55.387  57.738  37.844  1.00 22.25           O  
ATOM    293  N   ILE    37     -57.254  59.079  34.068  1.00 21.44           N  
ATOM    294  CA  ILE    37     -58.184  59.846  33.259  1.00 21.23           C  
ATOM    295  C   ILE    37     -59.431  60.036  34.126  1.00 21.25           C  
ATOM    296  O   ILE    37     -60.207  59.100  34.346  1.00 20.39           O  
ATOM    297  CB  ILE    37     -58.557  59.077  31.981  1.00 21.46           C  
ATOM    298  CG1 ILE    37     -57.304  58.859  31.131  1.00 22.05           C  
ATOM    299  CG2 ILE    37     -59.631  59.831  31.213  1.00 22.76           C  
ATOM    300  CD1 ILE    37     -57.478  57.845  30.022  1.00 25.06           C  
ATOM    301  N   VAL    38     -59.598  61.246  34.642  1.00 20.50           N  
ATOM    302  CA  VAL    38     -60.724  61.551  35.497  1.00 20.76           C  
ATOM    303  C   VAL    38     -61.510  62.706  34.897  1.00 20.95           C  
ATOM    304  O   VAL    38     -61.434  63.849  35.352  1.00 19.92           O  
ATOM    305  CB  VAL    38     -60.237  61.901  36.911  1.00 20.11           C  
ATOM    306  CG1 VAL    38     -59.772  60.633  37.619  1.00 20.73           C  
ATOM    307  CG2 VAL    38     -59.072  62.887  36.831  1.00 20.10           C  
ATOM    308  N   GLU    39     -62.260  62.395  33.850  1.00 20.59           N  
ATOM    309  CA  GLU    39     -63.044  63.404  33.175  1.00 20.51           C  
ATOM    310  C   GLU    39     -64.187  63.905  34.058  1.00 20.57           C  
ATOM    311  O   GLU    39     -64.632  63.210  34.973  1.00 19.13           O  
ATOM    312  CB  GLU    39     -63.597  62.838  31.871  1.00 21.06           C  
ATOM    313  CG  GLU    39     -64.226  63.893  31.016  1.00 21.17           C  
ATOM    314  CD  GLU    39     -63.267  65.035  30.775  1.00 22.65           C  
ATOM    315  OE1 GLU    39     -62.367  64.888  29.919  1.00 20.92           O  
ATOM    316  OE2 GLU    39     -63.402  66.064  31.465  1.00 21.33           O  
ATOM    317  N   HIS    40     -64.653  65.116  33.785  1.00 20.21           N  
ATOM    318  CA  HIS    40     -65.754  65.690  34.541  1.00 21.66           C  
ATOM    319  C   HIS    40     -67.039  64.883  34.416  1.00 22.37           C  
ATOM    320  O   HIS    40     -67.516  64.614  33.313  1.00 21.99           O  
ATOM    321  CB  HIS    40     -66.028  67.112  34.068  1.00 22.33           C  
ATOM    322  CG  HIS    40     -64.959  68.082  34.445  1.00 23.00           C  
ATOM    323  ND1 HIS    40     -64.799  68.546  35.733  1.00 26.99           N  
ATOM    324  CD2 HIS    40     -63.986  68.668  33.709  1.00 24.61           C  
ATOM    325  CE1 HIS    40     -63.775  69.379  35.775  1.00 26.38           C  
ATOM    326  NE2 HIS    40     -63.265  69.470  34.561  1.00 24.77           N  
ATOM    327  N   ALA    41     -67.608  64.515  35.558  1.00 22.98           N  
ATOM    328  CA  ALA    41     -68.857  63.768  35.564  1.00 22.94           C  
ATOM    329  C   ALA    41     -70.006  64.711  35.218  1.00 23.59           C  
ATOM    330  O   ALA    41     -69.978  65.887  35.571  1.00 22.65           O  
ATOM    331  CB  ALA    41     -69.084  63.138  36.935  1.00 22.94           C  
ATOM    332  N   PRO    42     -71.026  64.207  34.507  1.00 23.42           N  
ATOM    333  CA  PRO    42     -72.173  65.037  34.134  1.00 24.19           C  
ATOM    334  C   PRO    42     -72.829  65.664  35.371  1.00 24.64           C  
ATOM    335  O   PRO    42     -72.934  65.028  36.416  1.00 23.90           O  
ATOM    336  CB  PRO    42     -73.096  64.046  33.428  1.00 23.68           C  
ATOM    337  CG  PRO    42     -72.125  63.076  32.804  1.00 23.11           C  
ATOM    338  CD  PRO    42     -71.152  62.854  33.940  1.00 23.81           C  
ATOM    339  N   LEU    43     -73.243  66.921  35.257  1.00 25.51           N  
ATOM    340  CA  LEU    43     -73.883  67.598  36.377  1.00 26.96           C  
ATOM    341  C   LEU    43     -75.335  67.163  36.491  1.00 28.22           C  
ATOM    342  O   LEU    43     -75.897  66.591  35.556  1.00 28.90           O  
ATOM    343  CB  LEU    43     -73.838  69.113  36.186  1.00 26.57           C  
ATOM    344  CG  LEU    43     -72.466  69.777  36.113  1.00 26.06           C  
ATOM    345  CD1 LEU    43     -72.648  71.269  35.843  1.00 25.79           C  
ATOM    346  CD2 LEU    43     -71.699  69.546  37.410  1.00 26.95           C  
ATOM    347  N   SER    44     -75.936  67.427  37.645  1.00 28.80           N  
ATOM    348  CA  SER    44     -77.341  67.107  37.861  1.00 29.00           C  
ATOM    349  C   SER    44     -78.213  68.085  37.072  1.00 29.41           C  
ATOM    350  O   SER    44     -77.995  69.295  37.120  1.00 28.95           O  
ATOM    351  CB  SER    44     -77.674  67.211  39.348  1.00 28.87           C  
ATOM    352  OG  SER    44     -79.018  67.608  39.532  1.00 30.11           O  
ATOM    353  N   SER    45     -79.187  67.560  36.332  1.00 30.08           N  
ATOM    354  CA  SER    45     -80.086  68.409  35.549  1.00 31.04           C  
ATOM    355  C   SER    45     -80.826  69.371  36.479  1.00 30.91           C  
ATOM    356  O   SER    45     -81.083  70.522  36.124  1.00 31.11           O  
ATOM    357  CB  SER    45     -81.089  67.550  34.778  1.00 31.24           C  
ATOM    358  OG  SER    45     -81.755  66.659  35.653  1.00 35.03           O  
ATOM    359  N   GLU    46     -81.162  68.886  37.671  1.00 31.63           N  
ATOM    360  CA  GLU    46     -81.838  69.695  38.678  1.00 32.62           C  
ATOM    361  C   GLU    46     -80.904  70.839  39.071  1.00 30.98           C  
ATOM    362  O   GLU    46     -81.297  72.008  39.097  1.00 31.11           O  
ATOM    363  CB  GLU    46     -82.143  68.841  39.913  1.00 33.51           C  
ATOM    364  CG  GLU    46     -83.618  68.555  40.167  1.00 41.52           C  
ATOM    365  CD  GLU    46     -84.363  69.755  40.732  1.00 48.84           C  
ATOM    366  OE1 GLU    46     -83.919  70.292  41.770  1.00 52.08           O  
ATOM    367  OE2 GLU    46     -85.394  70.157  40.147  1.00 50.59           O  
ATOM    368  N   PHE    47     -79.658  70.487  39.369  1.00 29.51           N  
ATOM    369  CA  PHE    47     -78.662  71.470  39.763  1.00 28.79           C  
ATOM    370  C   PHE    47     -78.540  72.592  38.727  1.00 28.91           C  
ATOM    371  O   PHE    47     -78.476  73.775  39.073  1.00 27.76           O  
ATOM    372  CB  PHE    47     -77.296  70.792  39.939  1.00 27.25           C  
ATOM    373  CG  PHE    47     -76.185  71.752  40.257  1.00 26.28           C  
ATOM    374  CD1 PHE    47     -75.995  72.219  41.551  1.00 25.56           C  
ATOM    375  CD2 PHE    47     -75.359  72.231  39.245  1.00 25.28           C  
ATOM    376  CE1 PHE    47     -75.000  73.153  41.832  1.00 24.35           C  
ATOM    377  CE2 PHE    47     -74.366  73.164  39.516  1.00 24.10           C  
ATOM    378  CZ  PHE    47     -74.188  73.626  40.809  1.00 21.39           C  
ATOM    379  N   MET    48     -78.516  72.208  37.455  1.00 29.37           N  
ATOM    380  CA  MET    48     -78.361  73.172  36.374  1.00 31.03           C  
ATOM    381  C   MET    48     -79.506  74.171  36.240  1.00 31.09           C  
ATOM    382  O   MET    48     -79.353  75.197  35.584  1.00 32.03           O  
ATOM    383  CB  MET    48     -78.127  72.440  35.043  1.00 31.56           C  
ATOM    384  CG  MET    48     -76.836  71.624  35.021  1.00 34.65           C  
ATOM    385  SD  MET    48     -76.383  70.826  33.299  1.00 49.11          SE  
ATOM    386  CE  MET    48     -76.963  69.026  33.653  1.00 41.25           C  
ATOM    387  N   LYS    49     -80.647  73.887  36.861  1.00 30.63           N  
ATOM    388  CA  LYS    49     -81.781  74.810  36.797  1.00 30.68           C  
ATOM    389  C   LYS    49     -81.645  75.884  37.869  1.00 30.06           C  
ATOM    390  O   LYS    49     -82.354  76.889  37.846  1.00 30.35           O  
ATOM    391  CB  LYS    49     -83.101  74.086  37.065  1.00 29.93           C  
ATOM    392  CG  LYS    49     -83.410  72.890  36.187  1.00 31.43           C  
ATOM    393  CD  LYS    49     -84.695  72.236  36.711  1.00 33.55           C  
ATOM    394  CE  LYS    49     -85.078  70.981  35.948  1.00 36.76           C  
ATOM    395  NZ  LYS    49     -86.311  70.381  36.538  1.00 34.76           N  
ATOM    396  N   ASN    50     -80.747  75.655  38.821  1.00 29.50           N  
ATOM    397  CA  ASN    50     -80.582  76.567  39.945  1.00 28.40           C  
ATOM    398  C   ASN    50     -79.263  77.329  39.983  1.00 27.09           C  
ATOM    399  O   ASN    50     -78.736  77.628  41.058  1.00 26.43           O  
ATOM    400  CB  ASN    50     -80.773  75.779  41.243  1.00 28.51           C  
ATOM    401  CG  ASN    50     -82.183  75.231  41.385  1.00 30.55           C  
ATOM    402  OD1 ASN    50     -83.115  75.973  41.691  1.00 30.92           O  
ATOM    403  ND2 ASN    50     -82.348  73.931  41.150  1.00 30.82           N  
ATOM    404  N   THR    51     -78.738  77.657  38.811  1.00 26.46           N  
ATOM    405  CA  THR    51     -77.482  78.388  38.744  1.00 25.47           C  
ATOM    406  C   THR    51     -77.699  79.787  38.200  1.00 24.84           C  
ATOM    407  O   THR    51     -78.731  80.082  37.588  1.00 25.03           O  
ATOM    408  CB  THR    51     -76.450  77.692  37.834  1.00 25.83           C  
ATOM    409  OG1 THR    51     -76.857  77.815  36.469  1.00 27.09           O  
ATOM    410  CG2 THR    51     -76.318  76.218  38.198  1.00 24.93           C  
ATOM    411  N   ALA    52     -76.718  80.646  38.450  1.00 23.07           N  
ATOM    412  CA  ALA    52     -76.724  82.015  37.969  1.00 22.30           C  
ATOM    413  C   ALA    52     -75.328  82.241  37.406  1.00 22.50           C  
ATOM    414  O   ALA    52     -74.559  81.291  37.265  1.00 21.51           O  
ATOM    415  CB  ALA    52     -77.007  82.984  39.109  1.00 22.70           C  
ATOM    416  N   GLY    53     -74.994  83.482  37.077  1.00 22.05           N  
ATOM    417  CA  GLY    53     -73.672  83.745  36.533  1.00 22.44           C  
ATOM    418  C   GLY    53     -73.540  83.293  35.088  1.00 23.27           C  
ATOM    419  O   GLY    53     -74.504  82.822  34.480  1.00 22.19           O  
ATOM    420  N   ASP    54     -72.341  83.419  34.536  1.00 23.60           N  
ATOM    421  CA  ASP    54     -72.114  83.044  33.150  1.00 24.77           C  
ATOM    422  C   ASP    54     -72.572  81.624  32.869  1.00 24.63           C  
ATOM    423  O   ASP    54     -72.065  80.671  33.459  1.00 24.33           O  
ATOM    424  CB  ASP    54     -70.639  83.193  32.787  1.00 25.29           C  
ATOM    425  CG  ASP    54     -70.425  83.283  31.293  1.00 27.08           C  
ATOM    426  OD1 ASP    54     -70.896  82.375  30.574  1.00 28.27           O  
ATOM    427  OD2 ASP    54     -69.798  84.263  30.838  1.00 29.36           O  
ATOM    428  N   LYS    55     -73.537  81.493  31.961  1.00 24.74           N  
ATOM    429  CA  LYS    55     -74.081  80.191  31.600  1.00 24.76           C  
ATOM    430  C   LYS    55     -73.015  79.247  31.055  1.00 24.59           C  
ATOM    431  O   LYS    55     -73.108  78.034  31.229  1.00 23.72           O  
ATOM    432  CB  LYS    55     -75.206  80.352  30.576  1.00 25.36           C  
ATOM    433  CG  LYS    55     -76.428  81.071  31.130  1.00 25.68           C  
ATOM    434  CD  LYS    55     -77.468  81.307  30.054  1.00 27.84           C  
ATOM    435  CE  LYS    55     -78.701  81.981  30.639  1.00 27.11           C  
ATOM    436  NZ  LYS    55     -79.689  82.329  29.588  1.00 27.21           N  
ATOM    437  N   GLU    56     -72.009  79.800  30.391  1.00 24.17           N  
ATOM    438  CA  GLU    56     -70.941  78.977  29.837  1.00 26.31           C  
ATOM    439  C   GLU    56     -70.286  78.133  30.930  1.00 25.51           C  
ATOM    440  O   GLU    56     -69.854  77.007  30.680  1.00 24.60           O  
ATOM    441  CB  GLU    56     -69.897  79.861  29.150  1.00 26.80           C  
ATOM    442  CG  GLU    56     -68.662  79.122  28.675  1.00 33.08           C  
ATOM    443  CD  GLU    56     -67.790  79.974  27.768  1.00 41.19           C  
ATOM    444  OE1 GLU    56     -67.491  81.129  28.136  1.00 45.50           O  
ATOM    445  OE2 GLU    56     -67.398  79.488  26.687  1.00 45.86           O  
ATOM    446  N   ALA    57     -70.230  78.675  32.144  1.00 24.72           N  
ATOM    447  CA  ALA    57     -69.634  77.952  33.263  1.00 25.38           C  
ATOM    448  C   ALA    57     -70.377  76.648  33.540  1.00 25.69           C  
ATOM    449  O   ALA    57     -69.804  75.700  34.077  1.00 25.84           O  
ATOM    450  CB  ALA    57     -69.636  78.827  34.513  1.00 24.59           C  
ATOM    451  N   VAL    58     -71.656  76.610  33.167  1.00 25.09           N  
ATOM    452  CA  VAL    58     -72.499  75.441  33.398  1.00 25.05           C  
ATOM    453  C   VAL    58     -72.640  74.548  32.163  1.00 26.08           C  
ATOM    454  O   VAL    58     -72.432  73.337  32.236  1.00 26.41           O  
ATOM    455  CB  VAL    58     -73.914  75.874  33.870  1.00 24.70           C  
ATOM    456  CG1 VAL    58     -74.771  74.644  34.186  1.00 23.49           C  
ATOM    457  CG2 VAL    58     -73.803  76.764  35.092  1.00 24.79           C  
ATOM    458  N   THR    59     -73.010  75.148  31.034  1.00 26.31           N  
ATOM    459  CA  THR    59     -73.187  74.397  29.796  1.00 26.70           C  
ATOM    460  C   THR    59     -71.885  73.716  29.387  1.00 27.39           C  
ATOM    461  O   THR    59     -71.882  72.632  28.808  1.00 27.63           O  
ATOM    462  CB  THR    59     -73.626  75.322  28.632  1.00 26.21           C  
ATOM    463  OG1 THR    59     -72.580  76.255  28.346  1.00 27.61           O  
ATOM    464  CG2 THR    59     -74.884  76.096  28.997  1.00 25.55           C  
ATOM    465  N   THR    60     -70.779  74.371  29.709  1.00 28.11           N  
ATOM    466  CA  THR    60     -69.448  73.899  29.356  1.00 29.36           C  
ATOM    467  C   THR    60     -68.777  73.035  30.441  1.00 29.49           C  
ATOM    468  O   THR    60     -67.743  72.405  30.194  1.00 29.27           O  
ATOM    469  CB  THR    60     -68.575  75.141  28.993  1.00 28.93           C  
ATOM    470  OG1 THR    60     -68.695  75.412  27.590  1.00 32.24           O  
ATOM    471  CG2 THR    60     -67.136  74.946  29.351  1.00 30.93           C  
ATOM    472  N   ALA    61     -69.394  72.979  31.620  1.00 30.12           N  
ATOM    473  CA  ALA    61     -68.854  72.233  32.757  1.00 30.71           C  
ATOM    474  C   ALA    61     -68.428  70.796  32.466  1.00 30.79           C  
ATOM    475  O   ALA    61     -67.312  70.405  32.801  1.00 30.40           O  
ATOM    476  CB  ALA    61     -69.849  72.255  33.919  1.00 30.41           C  
ATOM    477  N   SER    62     -69.304  70.003  31.860  1.00 31.36           N  
ATOM    478  CA  SER    62     -68.957  68.615  31.578  1.00 32.61           C  
ATOM    479  C   SER    62     -69.802  67.992  30.482  1.00 33.33           C  
ATOM    480  O   SER    62     -70.727  68.612  29.965  1.00 32.97           O  
ATOM    481  CB  SER    62     -69.104  67.772  32.839  1.00 32.97           C  
ATOM    482  OG  SER    62     -70.472  67.638  33.174  1.00 33.68           O  
ATOM    483  N   MET    63     -69.474  66.751  30.144  1.00 33.89           N  
ATOM    484  CA  MET    63     -70.190  66.015  29.114  1.00 35.36           C  
ATOM    485  C   MET    63     -71.597  65.644  29.567  1.00 35.11           C  
ATOM    486  O   MET    63     -71.941  65.778  30.740  1.00 34.74           O  
ATOM    487  CB  MET    63     -69.423  64.743  28.758  1.00 36.25           C  
ATOM    488  CG  MET    63     -69.002  63.943  29.972  1.00 41.57           C  
ATOM    489  SD  MET    63     -68.382  62.160  29.547  1.00 51.78          SE  
ATOM    490  CE  MET    63     -70.088  61.293  29.652  1.00 52.81           C  
ATOM    491  N   ALA    64     -72.402  65.166  28.624  1.00 35.19           N  
ATOM    492  CA  ALA    64     -73.770  64.758  28.907  1.00 35.41           C  
ATOM    493  C   ALA    64     -73.811  63.290  29.314  1.00 35.39           C  
ATOM    494  O   ALA    64     -72.904  62.524  28.995  1.00 35.33           O  
ATOM    495  CB  ALA    64     -74.642  64.979  27.675  1.00 35.64           C  
ATOM    496  N   MET    65     -74.868  62.905  30.022  1.00 35.19           N  
ATOM    497  CA  MET    65     -75.041  61.524  30.459  1.00 35.39           C  
ATOM    498  C   MET    65     -74.962  60.565  29.273  1.00 34.45           C  
ATOM    499  O   MET    65     -74.406  59.471  29.379  1.00 33.78           O  
ATOM    500  CB  MET    65     -76.391  61.363  31.165  1.00 36.60           C  
ATOM    501  CG  MET    65     -76.442  61.947  32.571  1.00 41.25           C  
ATOM    502  SD  MET    65     -75.443  60.901  33.872  1.00 53.07          SE  
ATOM    503  CE  MET    65     -76.774  59.536  34.237  1.00 52.72           C  
ATOM    504  N   SER    66     -75.518  60.981  28.140  1.00 34.02           N  
ATOM    505  CA  SER    66     -75.504  60.146  26.948  1.00 33.69           C  
ATOM    506  C   SER    66     -74.090  59.877  26.423  1.00 33.50           C  
ATOM    507  O   SER    66     -73.862  58.881  25.739  1.00 33.75           O  
ATOM    508  CB  SER    66     -76.359  60.783  25.848  1.00 34.11           C  
ATOM    509  OG  SER    66     -75.912  62.090  25.539  1.00 33.34           O  
ATOM    510  N   ASP    67     -73.135  60.748  26.743  1.00 33.09           N  
ATOM    511  CA  ASP    67     -71.764  60.548  26.273  1.00 32.70           C  
ATOM    512  C   ASP    67     -70.999  59.491  27.070  1.00 31.58           C  
ATOM    513  O   ASP    67     -69.948  59.021  26.634  1.00 31.42           O  
ATOM    514  CB  ASP    67     -70.968  61.860  26.323  1.00 33.87           C  
ATOM    515  CG  ASP    67     -71.489  62.904  25.347  1.00 36.35           C  
ATOM    516  OD1 ASP    67     -71.701  62.571  24.161  1.00 39.46           O  
ATOM    517  OD2 ASP    67     -71.670  64.067  25.769  1.00 41.08           O  
ATOM    518  N   LEU    68     -71.521  59.129  28.238  1.00 30.34           N  
ATOM    519  CA  LEU    68     -70.865  58.159  29.110  1.00 29.88           C  
ATOM    520  C   LEU    68     -70.428  56.858  28.440  1.00 29.09           C  
ATOM    521  O   LEU    68     -69.273  56.461  28.560  1.00 28.49           O  
ATOM    522  CB  LEU    68     -71.758  57.853  30.319  1.00 30.79           C  
ATOM    523  CG  LEU    68     -71.837  58.982  31.351  1.00 31.35           C  
ATOM    524  CD1 LEU    68     -72.912  58.687  32.389  1.00 32.69           C  
ATOM    525  CD2 LEU    68     -70.475  59.153  32.018  1.00 32.70           C  
ATOM    526  N   PRO    69     -71.346  56.169  27.742  1.00 28.50           N  
ATOM    527  CA  PRO    69     -70.975  54.913  27.080  1.00 28.02           C  
ATOM    528  C   PRO    69     -69.770  55.077  26.161  1.00 27.51           C  
ATOM    529  O   PRO    69     -68.877  54.233  26.140  1.00 26.50           O  
ATOM    530  CB  PRO    69     -72.244  54.543  26.319  1.00 28.06           C  
ATOM    531  CG  PRO    69     -73.326  55.075  27.220  1.00 28.33           C  
ATOM    532  CD  PRO    69     -72.779  56.451  27.547  1.00 28.58           C  
ATOM    533  N   TYR    70     -69.745  56.183  25.427  1.00 27.64           N  
ATOM    534  CA  TYR    70     -68.661  56.490  24.499  1.00 28.69           C  
ATOM    535  C   TYR    70     -67.365  56.836  25.235  1.00 27.60           C  
ATOM    536  O   TYR    70     -66.276  56.456  24.798  1.00 27.78           O  
ATOM    537  CB  TYR    70     -69.087  57.645  23.597  1.00 30.11           C  
ATOM    538  CG  TYR    70     -70.329  57.315  22.797  1.00 35.37           C  
ATOM    539  CD1 TYR    70     -70.244  56.582  21.613  1.00 39.91           C  
ATOM    540  CD2 TYR    70     -71.595  57.685  23.255  1.00 39.86           C  
ATOM    541  CE1 TYR    70     -71.390  56.223  20.904  1.00 44.06           C  
ATOM    542  CE2 TYR    70     -72.745  57.331  22.557  1.00 43.29           C  
ATOM    543  CZ  TYR    70     -72.637  56.601  21.384  1.00 45.69           C  
ATOM    544  OH  TYR    70     -73.778  56.246  20.695  1.00 48.83           O  
ATOM    545  N   TYR    71     -67.488  57.550  26.351  1.00 26.10           N  
ATOM    546  CA  TYR    71     -66.322  57.913  27.154  1.00 24.77           C  
ATOM    547  C   TYR    71     -65.597  56.661  27.625  1.00 23.68           C  
ATOM    548  O   TYR    71     -64.400  56.506  27.394  1.00 23.14           O  
ATOM    549  CB  TYR    71     -66.742  58.743  28.372  1.00 24.53           C  
ATOM    550  CG  TYR    71     -65.659  58.912  29.426  1.00 25.13           C  
ATOM    551  CD1 TYR    71     -64.492  59.632  29.153  1.00 24.00           C  
ATOM    552  CD2 TYR    71     -65.821  58.381  30.710  1.00 25.47           C  
ATOM    553  CE1 TYR    71     -63.519  59.826  30.132  1.00 23.82           C  
ATOM    554  CE2 TYR    71     -64.855  58.567  31.696  1.00 24.29           C  
ATOM    555  CZ  TYR    71     -63.707  59.294  31.403  1.00 23.10           C  
ATOM    556  OH  TYR    71     -62.766  59.515  32.383  1.00 18.56           O  
ATOM    557  N   PHE    72     -66.323  55.767  28.286  1.00 23.15           N  
ATOM    558  CA  PHE    72     -65.717  54.539  28.780  1.00 23.21           C  
ATOM    559  C   PHE    72     -65.137  53.701  27.649  1.00 23.50           C  
ATOM    560  O   PHE    72     -64.045  53.156  27.771  1.00 25.00           O  
ATOM    561  CB  PHE    72     -66.731  53.714  29.580  1.00 22.76           C  
ATOM    562  CG  PHE    72     -66.942  54.216  30.977  1.00 22.66           C  
ATOM    563  CD1 PHE    72     -65.883  54.281  31.870  1.00 22.22           C  
ATOM    564  CD2 PHE    72     -68.195  54.634  31.396  1.00 21.08           C  
ATOM    565  CE1 PHE    72     -66.070  54.749  33.167  1.00 22.23           C  
ATOM    566  CE2 PHE    72     -68.394  55.105  32.692  1.00 21.09           C  
ATOM    567  CZ  PHE    72     -67.332  55.163  33.576  1.00 23.10           C  
ATOM    568  N   LYS    73     -65.862  53.599  26.542  1.00 24.15           N  
ATOM    569  CA  LYS    73     -65.361  52.818  25.422  1.00 24.59           C  
ATOM    570  C   LYS    73     -63.995  53.333  24.966  1.00 23.91           C  
ATOM    571  O   LYS    73     -63.037  52.564  24.865  1.00 24.00           O  
ATOM    572  CB  LYS    73     -66.347  52.869  24.256  1.00 24.50           C  
ATOM    573  CG  LYS    73     -65.898  52.077  23.040  1.00 27.22           C  
ATOM    574  CD  LYS    73     -66.849  52.265  21.867  1.00 31.62           C  
ATOM    575  CE  LYS    73     -66.326  51.539  20.630  1.00 32.63           C  
ATOM    576  NZ  LYS    73     -67.092  51.872  19.401  1.00 34.21           N  
ATOM    577  N   LYS    74     -63.911  54.635  24.699  1.00 24.19           N  
ATOM    578  CA  LYS    74     -62.668  55.250  24.237  1.00 23.56           C  
ATOM    579  C   LYS    74     -61.527  55.071  25.237  1.00 23.57           C  
ATOM    580  O   LYS    74     -60.443  54.622  24.871  1.00 22.65           O  
ATOM    581  CB  LYS    74     -62.887  56.741  23.969  1.00 24.16           C  
ATOM    582  CG  LYS    74     -61.633  57.516  23.542  1.00 26.10           C  
ATOM    583  CD  LYS    74     -61.150  57.084  22.162  1.00 30.84           C  
ATOM    584  CE  LYS    74     -60.351  58.181  21.466  1.00 33.83           C  
ATOM    585  NZ  LYS    74     -59.071  58.489  22.134  1.00 37.25           N  
ATOM    586  N   MET    75     -61.772  55.426  26.498  1.00 23.98           N  
ATOM    587  CA  MET    75     -60.750  55.300  27.535  1.00 24.28           C  
ATOM    588  C   MET    75     -60.314  53.855  27.769  1.00 23.97           C  
ATOM    589  O   MET    75     -59.131  53.597  27.983  1.00 24.43           O  
ATOM    590  CB  MET    75     -61.234  55.917  28.849  1.00 24.43           C  
ATOM    591  CG  MET    75     -61.595  57.393  28.739  1.00 26.89           C  
ATOM    592  SD  MET    75     -60.416  58.378  27.532  1.00 36.38          SE  
ATOM    593  CE  MET    75     -61.758  59.466  26.651  1.00 26.61           C  
ATOM    594  N   ASN    76     -61.251  52.910  27.748  1.00 24.33           N  
ATOM    595  CA  ASN    76     -60.872  51.511  27.937  1.00 24.45           C  
ATOM    596  C   ASN    76     -60.013  51.055  26.762  1.00 23.97           C  
ATOM    597  O   ASN    76     -59.149  50.197  26.909  1.00 24.19           O  
ATOM    598  CB  ASN    76     -62.109  50.617  28.075  1.00 24.78           C  
ATOM    599  CG  ASN    76     -62.586  50.507  29.514  1.00 26.25           C  
ATOM    600  OD1 ASN    76     -61.860  50.020  30.382  1.00 26.35           O  
ATOM    601  ND2 ASN    76     -63.807  50.964  29.773  1.00 23.88           N  
ATOM    602  N   HIS    77     -60.238  51.649  25.597  1.00 23.53           N  
ATOM    603  CA  HIS    77     -59.442  51.319  24.419  1.00 23.17           C  
ATOM    604  C   HIS    77     -58.002  51.821  24.592  1.00 23.55           C  
ATOM    605  O   HIS    77     -57.038  51.103  24.324  1.00 22.15           O  
ATOM    606  CB  HIS    77     -60.068  51.956  23.179  1.00 23.37           C  
ATOM    607  CG  HIS    77     -59.217  51.861  21.952  1.00 24.16           C  
ATOM    608  ND1 HIS    77     -58.602  52.958  21.387  1.00 27.50           N  
ATOM    609  CD2 HIS    77     -58.873  50.799  21.189  1.00 22.57           C  
ATOM    610  CE1 HIS    77     -57.914  52.574  20.326  1.00 26.13           C  
ATOM    611  NE2 HIS    77     -58.061  51.269  20.185  1.00 26.54           N  
ATOM    612  N   ILE    78     -57.867  53.059  25.053  1.00 23.85           N  
ATOM    613  CA  ILE    78     -56.552  53.654  25.265  1.00 24.32           C  
ATOM    614  C   ILE    78     -55.810  52.937  26.397  1.00 23.95           C  
ATOM    615  O   ILE    78     -54.599  52.746  26.333  1.00 24.06           O  
ATOM    616  CB  ILE    78     -56.690  55.163  25.587  1.00 24.70           C  
ATOM    617  CG1 ILE    78     -57.465  55.857  24.468  1.00 24.61           C  
ATOM    618  CG2 ILE    78     -55.320  55.814  25.705  1.00 23.44           C  
ATOM    619  CD1 ILE    78     -56.757  55.816  23.131  1.00 28.45           C  
ATOM    620  N   LYS    79     -56.542  52.527  27.426  1.00 24.57           N  
ATOM    621  CA  LYS    79     -55.948  51.819  28.558  1.00 24.11           C  
ATOM    622  C   LYS    79     -55.213  50.558  28.103  1.00 24.57           C  
ATOM    623  O   LYS    79     -54.043  50.348  28.445  1.00 24.32           O  
ATOM    624  CB  LYS    79     -57.034  51.423  29.555  1.00 23.88           C  
ATOM    625  CG  LYS    79     -56.532  50.664  30.788  1.00 26.21           C  
ATOM    626  CD  LYS    79     -57.714  50.225  31.650  1.00 30.53           C  
ATOM    627  CE  LYS    79     -57.365  50.138  33.128  1.00 34.09           C  
ATOM    628  NZ  LYS    79     -56.219  49.235  33.416  1.00 38.79           N  
ATOM    629  N   LYS    80     -55.908  49.722  27.336  1.00 24.07           N  
ATOM    630  CA  LYS    80     -55.333  48.473  26.842  1.00 24.89           C  
ATOM    631  C   LYS    80     -54.238  48.703  25.803  1.00 24.53           C  
ATOM    632  O   LYS    80     -53.194  48.040  25.816  1.00 23.22           O  
ATOM    633  CB  LYS    80     -56.437  47.594  26.240  1.00 25.09           C  
ATOM    634  CG  LYS    80     -57.448  47.094  27.265  1.00 28.28           C  
ATOM    635  CD  LYS    80     -58.597  46.360  26.594  1.00 35.20           C  
ATOM    636  CE  LYS    80     -59.668  45.968  27.600  1.00 37.85           C  
ATOM    637  NZ  LYS    80     -60.976  45.724  26.924  1.00 41.69           N  
ATOM    638  N   LYS    81     -54.479  49.643  24.898  1.00 24.75           N  
ATOM    639  CA  LYS    81     -53.513  49.925  23.847  1.00 25.41           C  
ATOM    640  C   LYS    81     -52.137  50.280  24.398  1.00 26.43           C  
ATOM    641  O   LYS    81     -51.121  49.874  23.840  1.00 26.90           O  
ATOM    642  CB  LYS    81     -54.018  51.060  22.950  1.00 24.90           C  
ATOM    643  CG  LYS    81     -53.095  51.386  21.786  1.00 23.32           C  
ATOM    644  CD  LYS    81     -53.738  52.376  20.825  1.00 21.39           C  
ATOM    645  CE  LYS    81     -52.863  52.604  19.592  1.00 22.94           C  
ATOM    646  NZ  LYS    81     -53.572  53.446  18.588  1.00 21.93           N  
ATOM    647  N   TYR    82     -52.102  51.021  25.502  1.00 27.24           N  
ATOM    648  CA  TYR    82     -50.826  51.448  26.080  1.00 27.54           C  
ATOM    649  C   TYR    82     -50.454  50.809  27.409  1.00 28.50           C  
ATOM    650  O   TYR    82     -49.506  51.244  28.054  1.00 28.23           O  
ATOM    651  CB  TYR    82     -50.816  52.971  26.233  1.00 26.91           C  
ATOM    652  CG  TYR    82     -50.853  53.690  24.908  1.00 24.95           C  
ATOM    653  CD1 TYR    82     -49.731  53.719  24.081  1.00 22.23           C  
ATOM    654  CD2 TYR    82     -52.031  54.276  24.444  1.00 23.40           C  
ATOM    655  CE1 TYR    82     -49.785  54.300  22.825  1.00 22.80           C  
ATOM    656  CE2 TYR    82     -52.092  54.863  23.188  1.00 23.63           C  
ATOM    657  CZ  TYR    82     -50.967  54.867  22.385  1.00 23.00           C  
ATOM    658  OH  TYR    82     -51.035  55.417  21.130  1.00 23.43           O  
ATOM    659  N   ALA    83     -51.187  49.774  27.813  1.00 30.29           N  
ATOM    660  CA  ALA    83     -50.918  49.099  29.082  1.00 32.50           C  
ATOM    661  C   ALA    83     -49.448  48.715  29.209  1.00 34.26           C  
ATOM    662  O   ALA    83     -48.900  48.664  30.308  1.00 35.07           O  
ATOM    663  CB  ALA    83     -51.796  47.855  29.212  1.00 32.89           C  
ATOM    664  N   SER    84     -48.817  48.452  28.071  1.00 35.36           N  
ATOM    665  CA  SER    84     -47.416  48.058  28.027  1.00 36.02           C  
ATOM    666  C   SER    84     -46.467  49.172  28.468  1.00 35.72           C  
ATOM    667  O   SER    84     -45.426  48.900  29.061  1.00 36.03           O  
ATOM    668  CB  SER    84     -47.063  47.598  26.611  1.00 36.15           C  
ATOM    669  OG  SER    84     -45.713  47.192  26.531  1.00 40.00           O  
ATOM    670  N   ASP    85     -46.830  50.421  28.186  1.00 35.44           N  
ATOM    671  CA  ASP    85     -45.986  51.562  28.551  1.00 35.00           C  
ATOM    672  C   ASP    85     -46.506  52.359  29.753  1.00 34.06           C  
ATOM    673  O   ASP    85     -45.741  53.051  30.424  1.00 33.30           O  
ATOM    674  CB  ASP    85     -45.867  52.533  27.372  1.00 35.98           C  
ATOM    675  CG  ASP    85     -45.444  51.852  26.088  1.00 38.71           C  
ATOM    676  OD1 ASP    85     -44.252  51.503  25.952  1.00 41.72           O  
ATOM    677  OD2 ASP    85     -46.315  51.669  25.210  1.00 39.56           O  
ATOM    678  N   LEU    86     -47.807  52.270  30.013  1.00 32.94           N  
ATOM    679  CA  LEU    86     -48.422  53.042  31.091  1.00 32.23           C  
ATOM    680  C   LEU    86     -49.584  52.338  31.769  1.00 31.05           C  
ATOM    681  O   LEU    86     -50.409  51.711  31.105  1.00 31.21           O  
ATOM    682  CB  LEU    86     -48.970  54.368  30.531  1.00 32.92           C  
ATOM    683  CG  LEU    86     -48.378  55.731  30.887  1.00 35.13           C  
ATOM    684  CD1 LEU    86     -49.266  56.796  30.269  1.00 37.83           C  
ATOM    685  CD2 LEU    86     -48.307  55.942  32.384  1.00 37.95           C  
ATOM    686  N   LEU    87     -49.656  52.460  33.091  1.00 29.33           N  
ATOM    687  CA  LEU    87     -50.786  51.916  33.826  1.00 28.10           C  
ATOM    688  C   LEU    87     -51.818  53.048  33.836  1.00 27.27           C  
ATOM    689  O   LEU    87     -51.617  54.088  34.461  1.00 25.68           O  
ATOM    690  CB  LEU    87     -50.398  51.547  35.258  1.00 28.67           C  
ATOM    691  CG  LEU    87     -51.582  51.122  36.131  1.00 28.88           C  
ATOM    692  CD1 LEU    87     -52.338  49.985  35.457  1.00 31.34           C  
ATOM    693  CD2 LEU    87     -51.100  50.707  37.504  1.00 29.64           C  
ATOM    694  N   ILE    88     -52.905  52.854  33.105  1.00 25.70           N  
ATOM    695  CA  ILE    88     -53.937  53.875  33.027  1.00 25.45           C  
ATOM    696  C   ILE    88     -55.158  53.544  33.867  1.00 25.10           C  
ATOM    697  O   ILE    88     -55.681  52.436  33.810  1.00 25.09           O  
ATOM    698  CB  ILE    88     -54.371  54.095  31.566  1.00 25.43           C  
ATOM    699  CG1 ILE    88     -53.168  54.580  30.749  1.00 24.84           C  
ATOM    700  CG2 ILE    88     -55.525  55.084  31.499  1.00 24.39           C  
ATOM    701  CD1 ILE    88     -53.429  54.689  29.267  1.00 24.55           C  
ATOM    702  N   HIS    89     -55.595  54.513  34.661  1.00 24.28           N  
ATOM    703  CA  HIS    89     -56.783  54.350  35.487  1.00 23.74           C  
ATOM    704  C   HIS    89     -57.884  55.175  34.837  1.00 23.39           C  
ATOM    705  O   HIS    89     -57.611  56.207  34.224  1.00 24.14           O  
ATOM    706  CB  HIS    89     -56.533  54.859  36.909  1.00 23.95           C  
ATOM    707  CG  HIS    89     -55.435  54.141  37.626  1.00 25.98           C  
ATOM    708  ND1 HIS    89     -55.497  52.798  37.928  1.00 27.54           N  
ATOM    709  CD2 HIS    89     -54.242  54.577  38.097  1.00 26.27           C  
ATOM    710  CE1 HIS    89     -54.390  52.437  38.553  1.00 28.46           C  
ATOM    711  NE2 HIS    89     -53.611  53.498  38.668  1.00 27.02           N  
ATOM    712  N   ILE    90     -59.123  54.724  34.967  1.00 23.20           N  
ATOM    713  CA  ILE    90     -60.250  55.434  34.382  1.00 22.56           C  
ATOM    714  C   ILE    90     -61.267  55.797  35.461  1.00 21.66           C  
ATOM    715  O   ILE    90     -61.693  54.943  36.231  1.00 20.42           O  
ATOM    716  CB  ILE    90     -60.934  54.573  33.305  1.00 23.09           C  
ATOM    717  CG1 ILE    90     -59.912  54.202  32.224  1.00 24.28           C  
ATOM    718  CG2 ILE    90     -62.135  55.313  32.722  1.00 22.81           C  
ATOM    719  CD1 ILE    90     -60.479  53.380  31.082  1.00 25.45           C  
ATOM    720  N   GLY    91     -61.649  57.070  35.517  1.00 21.72           N  
ATOM    721  CA  GLY    91     -62.617  57.506  36.510  1.00 20.36           C  
ATOM    722  C   GLY    91     -63.188  58.873  36.200  1.00 20.72           C  
ATOM    723  O   GLY    91     -63.226  59.292  35.040  1.00 20.98           O  
ATOM    724  N   PHE    92     -63.628  59.576  37.236  1.00 19.43           N  
ATOM    725  CA  PHE    92     -64.209  60.895  37.051  1.00 19.08           C  
ATOM    726  C   PHE    92     -63.730  61.900  38.073  1.00 18.60           C  
ATOM    727  O   PHE    92     -63.367  61.546  39.197  1.00 17.59           O  
ATOM    728  CB  PHE    92     -65.737  60.856  37.218  1.00 19.92           C  
ATOM    729  CG  PHE    92     -66.448  59.990  36.224  1.00 21.98           C  
ATOM    730  CD1 PHE    92     -66.620  60.416  34.912  1.00 22.24           C  
ATOM    731  CD2 PHE    92     -66.963  58.751  36.608  1.00 22.28           C  
ATOM    732  CE1 PHE    92     -67.296  59.626  33.986  1.00 25.23           C  
ATOM    733  CE2 PHE    92     -67.644  57.947  35.693  1.00 25.18           C  
ATOM    734  CZ  PHE    92     -67.812  58.387  34.378  1.00 24.52           C  
ATOM    735  N   GLU    93     -63.732  63.165  37.668  1.00 18.44           N  
ATOM    736  CA  GLU    93     -63.485  64.226  38.623  1.00 18.28           C  
ATOM    737  C   GLU    93     -64.940  64.507  38.991  1.00 18.74           C  
ATOM    738  O   GLU    93     -65.684  65.097  38.210  1.00 19.05           O  
ATOM    739  CB  GLU    93     -62.880  65.467  37.987  1.00 16.89           C  
ATOM    740  CG  GLU    93     -62.943  66.647  38.943  1.00 16.88           C  
ATOM    741  CD  GLU    93     -62.039  67.793  38.545  1.00 18.00           C  
ATOM    742  OE1 GLU    93     -61.800  67.964  37.341  1.00 11.18           O  
ATOM    743  OE2 GLU    93     -61.592  68.529  39.435  1.00 19.53           O  
ATOM    744  N   VAL    94     -65.356  64.021  40.148  1.00 19.40           N  
ATOM    745  CA  VAL    94     -66.735  64.187  40.571  1.00 19.18           C  
ATOM    746  C   VAL    94     -66.989  65.490  41.298  1.00 19.64           C  
ATOM    747  O   VAL    94     -66.314  65.812  42.269  1.00 19.27           O  
ATOM    748  CB  VAL    94     -67.170  63.015  41.469  1.00 19.77           C  
ATOM    749  CG1 VAL    94     -68.631  63.191  41.878  1.00 18.38           C  
ATOM    750  CG2 VAL    94     -66.961  61.692  40.737  1.00 17.67           C  
ATOM    751  N   ASP    95     -67.974  66.238  40.811  1.00 20.47           N  
ATOM    752  CA  ASP    95     -68.356  67.506  41.420  1.00 21.20           C  
ATOM    753  C   ASP    95     -69.125  67.267  42.709  1.00 21.48           C  
ATOM    754  O   ASP    95     -70.112  66.519  42.716  1.00 21.61           O  
ATOM    755  CB  ASP    95     -69.273  68.297  40.485  1.00 21.65           C  
ATOM    756  CG  ASP    95     -68.528  69.288  39.627  1.00 23.09           C  
ATOM    757  OD1 ASP    95     -68.192  70.382  40.135  1.00 24.34           O  
ATOM    758  OD2 ASP    95     -68.290  68.974  38.441  1.00 25.11           O  
ATOM    759  N   TYR    96     -68.670  67.870  43.801  1.00 21.06           N  
ATOM    760  CA  TYR    96     -69.435  67.773  45.032  1.00 21.65           C  
ATOM    761  C   TYR    96     -70.474  68.889  44.904  1.00 22.40           C  
ATOM    762  O   TYR    96     -70.139  70.072  44.894  1.00 21.91           O  
ATOM    763  CB  TYR    96     -68.573  67.996  46.278  1.00 21.56           C  
ATOM    764  CG  TYR    96     -69.407  67.938  47.539  1.00 21.43           C  
ATOM    765  CD1 TYR    96     -70.055  66.756  47.917  1.00 22.17           C  
ATOM    766  CD2 TYR    96     -69.624  69.079  48.307  1.00 22.97           C  
ATOM    767  CE1 TYR    96     -70.904  66.721  49.019  1.00 21.76           C  
ATOM    768  CE2 TYR    96     -70.471  69.052  49.412  1.00 22.37           C  
ATOM    769  CZ  TYR    96     -71.106  67.873  49.756  1.00 23.00           C  
ATOM    770  OH  TYR    96     -71.958  67.860  50.828  1.00 24.53           O  
ATOM    771  N   LEU    97     -71.731  68.508  44.740  1.00 23.22           N  
ATOM    772  CA  LEU    97     -72.791  69.489  44.593  1.00 23.65           C  
ATOM    773  C   LEU    97     -73.547  69.630  45.904  1.00 23.48           C  
ATOM    774  O   LEU    97     -74.306  68.747  46.300  1.00 22.43           O  
ATOM    775  CB  LEU    97     -73.726  69.065  43.457  1.00 24.10           C  
ATOM    776  CG  LEU    97     -73.059  68.889  42.084  1.00 24.78           C  
ATOM    777  CD1 LEU    97     -74.049  68.273  41.097  1.00 26.29           C  
ATOM    778  CD2 LEU    97     -72.555  70.232  41.565  1.00 22.40           C  
ATOM    779  N   ILE    98     -73.309  70.746  46.580  1.00 23.89           N  
ATOM    780  CA  ILE    98     -73.942  71.029  47.861  1.00 25.04           C  
ATOM    781  C   ILE    98     -75.467  70.973  47.768  1.00 25.55           C  
ATOM    782  O   ILE    98     -76.082  71.722  47.010  1.00 24.78           O  
ATOM    783  CB  ILE    98     -73.510  72.418  48.383  1.00 25.32           C  
ATOM    784  CG1 ILE    98     -72.010  72.409  48.689  1.00 24.00           C  
ATOM    785  CG2 ILE    98     -74.303  72.785  49.637  1.00 28.55           C  
ATOM    786  CD1 ILE    98     -71.417  73.788  48.898  1.00 25.56           C  
ATOM    787  N   GLY    99     -76.064  70.062  48.533  1.00 25.76           N  
ATOM    788  CA  GLY    99     -77.507  69.920  48.536  1.00 26.48           C  
ATOM    789  C   GLY    99     -78.005  68.878  47.556  1.00 27.11           C  
ATOM    790  O   GLY    99     -79.205  68.622  47.475  1.00 28.11           O  
ATOM    791  N   TYR   100     -77.090  68.268  46.810  1.00 27.06           N  
ATOM    792  CA  TYR   100     -77.471  67.260  45.830  1.00 26.88           C  
ATOM    793  C   TYR   100     -76.737  65.938  46.021  1.00 26.77           C  
ATOM    794  O   TYR   100     -76.454  65.241  45.045  1.00 26.45           O  
ATOM    795  CB  TYR   100     -77.216  67.790  44.416  1.00 26.83           C  
ATOM    796  CG  TYR   100     -78.134  68.920  44.026  1.00 27.96           C  
ATOM    797  CD1 TYR   100     -79.290  68.681  43.280  1.00 28.42           C  
ATOM    798  CD2 TYR   100     -77.876  70.224  44.442  1.00 27.95           C  
ATOM    799  CE1 TYR   100     -80.165  69.710  42.963  1.00 29.27           C  
ATOM    800  CE2 TYR   100     -78.745  71.260  44.132  1.00 29.69           C  
ATOM    801  CZ  TYR   100     -79.888  70.995  43.394  1.00 30.10           C  
ATOM    802  OH  TYR   100     -80.762  72.014  43.104  1.00 32.14           O  
ATOM    803  N   GLU   101     -76.440  65.586  47.270  1.00 26.77           N  
ATOM    804  CA  GLU   101     -75.725  64.342  47.548  1.00 27.51           C  
ATOM    805  C   GLU   101     -76.450  63.107  47.017  1.00 27.09           C  
ATOM    806  O   GLU   101     -75.805  62.157  46.583  1.00 26.39           O  
ATOM    807  CB  GLU   101     -75.472  64.182  49.050  1.00 27.72           C  
ATOM    808  CG  GLU   101     -74.741  65.353  49.690  1.00 32.19           C  
ATOM    809  CD  GLU   101     -74.251  65.042  51.090  1.00 38.46           C  
ATOM    810  OE1 GLU   101     -74.892  64.222  51.786  1.00 39.16           O  
ATOM    811  OE2 GLU   101     -73.228  65.629  51.503  1.00 39.59           O  
ATOM    812  N   ASP   102     -77.782  63.107  47.053  1.00 27.04           N  
ATOM    813  CA  ASP   102     -78.530  61.958  46.550  1.00 28.24           C  
ATOM    814  C   ASP   102     -78.176  61.698  45.089  1.00 27.01           C  
ATOM    815  O   ASP   102     -77.870  60.568  44.711  1.00 27.01           O  
ATOM    816  CB  ASP   102     -80.041  62.180  46.682  1.00 29.05           C  
ATOM    817  CG  ASP   102     -80.509  62.180  48.129  1.00 33.51           C  
ATOM    818  OD1 ASP   102     -79.665  61.969  49.028  1.00 37.22           O  
ATOM    819  OD2 ASP   102     -81.720  62.388  48.369  1.00 36.39           O  
ATOM    820  N   PHE   103     -78.221  62.744  44.267  1.00 26.57           N  
ATOM    821  CA  PHE   103     -77.888  62.611  42.851  1.00 25.89           C  
ATOM    822  C   PHE   103     -76.499  62.006  42.681  1.00 25.29           C  
ATOM    823  O   PHE   103     -76.314  61.024  41.961  1.00 24.73           O  
ATOM    824  CB  PHE   103     -77.906  63.976  42.160  1.00 26.89           C  
ATOM    825  CG  PHE   103     -77.163  63.994  40.852  1.00 28.43           C  
ATOM    826  CD1 PHE   103     -77.753  63.501  39.690  1.00 28.63           C  
ATOM    827  CD2 PHE   103     -75.846  64.445  40.797  1.00 29.61           C  
ATOM    828  CE1 PHE   103     -77.044  63.456  38.496  1.00 29.02           C  
ATOM    829  CE2 PHE   103     -75.123  64.405  39.604  1.00 29.18           C  
ATOM    830  CZ  PHE   103     -75.722  63.907  38.453  1.00 28.80           C  
ATOM    831  N   THR   104     -75.525  62.618  43.344  1.00 24.52           N  
ATOM    832  CA  THR   104     -74.138  62.184  43.257  1.00 24.46           C  
ATOM    833  C   THR   104     -73.958  60.740  43.710  1.00 24.86           C  
ATOM    834  O   THR   104     -73.264  59.957  43.064  1.00 23.72           O  
ATOM    835  CB  THR   104     -73.238  63.114  44.093  1.00 24.49           C  
ATOM    836  OG1 THR   104     -73.424  64.465  43.652  1.00 23.86           O  
ATOM    837  CG2 THR   104     -71.777  62.732  43.935  1.00 23.34           C  
ATOM    838  N   ARG   105     -74.591  60.392  44.822  1.00 25.45           N  
ATOM    839  CA  ARG   105     -74.510  59.039  45.350  1.00 26.91           C  
ATOM    840  C   ARG   105     -75.113  58.049  44.350  1.00 26.97           C  
ATOM    841  O   ARG   105     -74.550  56.979  44.125  1.00 27.03           O  
ATOM    842  CB  ARG   105     -75.231  58.966  46.702  1.00 26.66           C  
ATOM    843  CG  ARG   105     -75.184  57.612  47.393  1.00 29.82           C  
ATOM    844  CD  ARG   105     -75.518  57.769  48.873  1.00 32.79           C  
ATOM    845  NE  ARG   105     -76.771  58.494  49.051  1.00 36.37           N  
ATOM    846  CZ  ARG   105     -76.919  59.584  49.797  1.00 37.55           C  
ATOM    847  NH1 ARG   105     -75.890  60.100  50.460  1.00 33.56           N  
ATOM    848  NH2 ARG   105     -78.104  60.172  49.865  1.00 39.34           N  
ATOM    849  N   ASP   106     -76.241  58.406  43.737  1.00 27.32           N  
ATOM    850  CA  ASP   106     -76.860  57.520  42.755  1.00 27.70           C  
ATOM    851  C   ASP   106     -75.931  57.368  41.554  1.00 27.04           C  
ATOM    852  O   ASP   106     -75.707  56.259  41.068  1.00 27.73           O  
ATOM    853  CB  ASP   106     -78.220  58.059  42.281  1.00 28.25           C  
ATOM    854  CG  ASP   106     -79.300  57.961  43.349  1.00 32.62           C  
ATOM    855  OD1 ASP   106     -79.130  57.181  44.313  1.00 34.87           O  
ATOM    856  OD2 ASP   106     -80.332  58.659  43.217  1.00 36.81           O  
ATOM    857  N   PHE   107     -75.391  58.486  41.071  1.00 26.33           N  
ATOM    858  CA  PHE   107     -74.482  58.438  39.930  1.00 24.84           C  
ATOM    859  C   PHE   107     -73.305  57.514  40.227  1.00 24.17           C  
ATOM    860  O   PHE   107     -72.957  56.654  39.415  1.00 22.95           O  
ATOM    861  CB  PHE   107     -73.938  59.832  39.601  1.00 25.02           C  
ATOM    862  CG  PHE   107     -72.896  59.828  38.511  1.00 25.29           C  
ATOM    863  CD1 PHE   107     -73.268  59.764  37.173  1.00 25.79           C  
ATOM    864  CD2 PHE   107     -71.541  59.846  38.829  1.00 28.08           C  
ATOM    865  CE1 PHE   107     -72.308  59.716  36.168  1.00 23.75           C  
ATOM    866  CE2 PHE   107     -70.569  59.799  37.833  1.00 25.26           C  
ATOM    867  CZ  PHE   107     -70.955  59.733  36.498  1.00 23.76           C  
ATOM    868  N   LEU   108     -72.688  57.708  41.391  1.00 23.49           N  
ATOM    869  CA  LEU   108     -71.542  56.899  41.785  1.00 23.47           C  
ATOM    870  C   LEU   108     -71.907  55.427  41.950  1.00 23.81           C  
ATOM    871  O   LEU   108     -71.148  54.555  41.537  1.00 24.04           O  
ATOM    872  CB  LEU   108     -70.926  57.444  43.081  1.00 22.50           C  
ATOM    873  CG  LEU   108     -70.191  58.784  42.927  1.00 22.45           C  
ATOM    874  CD1 LEU   108     -69.762  59.313  44.286  1.00 21.18           C  
ATOM    875  CD2 LEU   108     -68.985  58.598  42.026  1.00 23.95           C  
ATOM    876  N   ASN   109     -73.060  55.141  42.550  1.00 23.97           N  
ATOM    877  CA  ASN   109     -73.450  53.744  42.713  1.00 25.23           C  
ATOM    878  C   ASN   109     -73.646  53.066  41.361  1.00 25.47           C  
ATOM    879  O   ASN   109     -73.353  51.882  41.214  1.00 24.83           O  
ATOM    880  CB  ASN   109     -74.732  53.607  43.544  1.00 25.25           C  
ATOM    881  CG  ASN   109     -74.489  53.807  45.031  1.00 25.96           C  
ATOM    882  OD1 ASN   109     -73.395  53.554  45.535  1.00 28.04           O  
ATOM    883  ND2 ASN   109     -75.519  54.238  45.745  1.00 24.71           N  
ATOM    884  N   GLU   110     -74.122  53.812  40.369  1.00 26.34           N  
ATOM    885  CA  GLU   110     -74.336  53.224  39.048  1.00 27.97           C  
ATOM    886  C   GLU   110     -73.062  53.051  38.218  1.00 27.88           C  
ATOM    887  O   GLU   110     -72.802  51.969  37.695  1.00 28.50           O  
ATOM    888  CB  GLU   110     -75.335  54.055  38.236  1.00 28.81           C  
ATOM    889  CG  GLU   110     -75.764  53.367  36.943  1.00 32.90           C  
ATOM    890  CD  GLU   110     -76.752  54.185  36.136  1.00 39.42           C  
ATOM    891  OE1 GLU   110     -77.441  55.040  36.733  1.00 40.89           O  
ATOM    892  OE2 GLU   110     -76.851  53.961  34.907  1.00 41.96           O  
ATOM    893  N   TYR   111     -72.271  54.114  38.098  1.00 27.53           N  
ATOM    894  CA  TYR   111     -71.059  54.071  37.287  1.00 26.90           C  
ATOM    895  C   TYR   111     -69.766  53.773  38.045  1.00 26.84           C  
ATOM    896  O   TYR   111     -68.739  53.478  37.437  1.00 27.10           O  
ATOM    897  CB  TYR   111     -70.926  55.384  36.519  1.00 27.47           C  
ATOM    898  CG  TYR   111     -72.097  55.645  35.603  1.00 27.55           C  
ATOM    899  CD1 TYR   111     -72.202  55.002  34.372  1.00 26.98           C  
ATOM    900  CD2 TYR   111     -73.123  56.502  35.988  1.00 29.42           C  
ATOM    901  CE1 TYR   111     -73.304  55.207  33.543  1.00 28.45           C  
ATOM    902  CE2 TYR   111     -74.228  56.713  35.170  1.00 28.62           C  
ATOM    903  CZ  TYR   111     -74.309  56.064  33.949  1.00 29.31           C  
ATOM    904  OH  TYR   111     -75.385  56.292  33.123  1.00 31.45           O  
ATOM    905  N   GLY   112     -69.815  53.837  39.367  1.00 26.26           N  
ATOM    906  CA  GLY   112     -68.630  53.551  40.147  1.00 26.43           C  
ATOM    907  C   GLY   112     -67.948  52.245  39.774  1.00 26.24           C  
ATOM    908  O   GLY   112     -66.725  52.199  39.699  1.00 26.15           O  
ATOM    909  N   PRO   113     -68.710  51.164  39.528  1.00 26.34           N  
ATOM    910  CA  PRO   113     -68.123  49.868  39.170  1.00 26.29           C  
ATOM    911  C   PRO   113     -67.258  49.870  37.910  1.00 26.24           C  
ATOM    912  O   PRO   113     -66.411  48.996  37.733  1.00 26.46           O  
ATOM    913  CB  PRO   113     -69.350  48.963  39.032  1.00 26.37           C  
ATOM    914  CG  PRO   113     -70.328  49.571  39.993  1.00 25.96           C  
ATOM    915  CD  PRO   113     -70.171  51.044  39.685  1.00 26.23           C  
ATOM    916  N   GLN   114     -67.464  50.843  37.032  1.00 26.46           N  
ATOM    917  CA  GLN   114     -66.677  50.906  35.803  1.00 26.98           C  
ATOM    918  C   GLN   114     -65.443  51.785  35.949  1.00 26.98           C  
ATOM    919  O   GLN   114     -64.702  51.979  34.988  1.00 26.81           O  
ATOM    920  CB  GLN   114     -67.519  51.457  34.658  1.00 26.93           C  
ATOM    921  CG  GLN   114     -68.703  50.607  34.276  1.00 26.74           C  
ATOM    922  CD  GLN   114     -69.487  51.237  33.147  1.00 28.43           C  
ATOM    923  OE1 GLN   114     -68.997  51.347  32.022  1.00 28.45           O  
ATOM    924  NE2 GLN   114     -70.701  51.679  33.445  1.00 28.19           N  
ATOM    925  N   THR   115     -65.226  52.316  37.147  1.00 27.37           N  
ATOM    926  CA  THR   115     -64.099  53.208  37.389  1.00 26.71           C  
ATOM    927  C   THR   115     -63.005  52.555  38.215  1.00 27.27           C  
ATOM    928  O   THR   115     -63.245  51.581  38.929  1.00 26.34           O  
ATOM    929  CB  THR   115     -64.561  54.486  38.097  1.00 26.98           C  
ATOM    930  OG1 THR   115     -64.949  54.180  39.441  1.00 24.18           O  
ATOM    931  CG2 THR   115     -65.738  55.088  37.357  1.00 25.44           C  
ATOM    932  N   ASP   116     -61.811  53.134  38.148  1.00 27.69           N  
ATOM    933  CA  ASP   116     -60.644  52.592  38.829  1.00 28.15           C  
ATOM    934  C   ASP   116     -59.892  53.624  39.694  1.00 27.11           C  
ATOM    935  O   ASP   116     -58.948  53.280  40.405  1.00 26.06           O  
ATOM    936  CB  ASP   116     -59.716  51.993  37.767  1.00 30.01           C  
ATOM    937  CG  ASP   116     -58.569  51.231  38.360  1.00 35.69           C  
ATOM    938  OD1 ASP   116     -58.758  50.638  39.441  1.00 42.39           O  
ATOM    939  OD2 ASP   116     -57.484  51.211  37.738  1.00 41.43           O  
ATOM    940  N   ASP   117     -60.303  54.888  39.619  1.00 25.47           N  
ATOM    941  CA  ASP   117     -59.694  55.966  40.408  1.00 23.45           C  
ATOM    942  C   ASP   117     -60.688  57.118  40.362  1.00 22.39           C  
ATOM    943  O   ASP   117     -61.698  57.031  39.668  1.00 21.77           O  
ATOM    944  CB  ASP   117     -58.342  56.370  39.800  1.00 22.99           C  
ATOM    945  CG  ASP   117     -57.547  57.335  40.677  1.00 24.26           C  
ATOM    946  OD1 ASP   117     -57.827  57.461  41.887  1.00 22.53           O  
ATOM    947  OD2 ASP   117     -56.611  57.960  40.145  1.00 24.59           O  
ATOM    948  N   GLY   118     -60.428  58.180  41.114  1.00 21.63           N  
ATOM    949  CA  GLY   118     -61.354  59.295  41.116  1.00 19.51           C  
ATOM    950  C   GLY   118     -60.914  60.468  41.962  1.00 18.99           C  
ATOM    951  O   GLY   118     -60.043  60.349  42.820  1.00 18.05           O  
ATOM    952  N   VAL   119     -61.532  61.614  41.705  1.00 18.80           N  
ATOM    953  CA  VAL   119     -61.256  62.832  42.447  1.00 17.41           C  
ATOM    954  C   VAL   119     -62.601  63.478  42.743  1.00 17.43           C  
ATOM    955  O   VAL   119     -63.487  63.490  41.882  1.00 18.20           O  
ATOM    956  CB  VAL   119     -60.403  63.825  41.616  1.00 17.81           C  
ATOM    957  CG1 VAL   119     -60.163  65.101  42.413  1.00 16.69           C  
ATOM    958  CG2 VAL   119     -59.069  63.182  41.230  1.00 16.97           C  
ATOM    959  N   LEU   120     -62.760  63.986  43.962  1.00 16.82           N  
ATOM    960  CA  LEU   120     -63.986  64.671  44.360  1.00 17.38           C  
ATOM    961  C   LEU   120     -63.597  66.142  44.481  1.00 17.17           C  
ATOM    962  O   LEU   120     -62.737  66.486  45.289  1.00 17.15           O  
ATOM    963  CB  LEU   120     -64.468  64.159  45.712  1.00 16.71           C  
ATOM    964  CG  LEU   120     -65.969  64.064  46.011  1.00 20.78           C  
ATOM    965  CD1 LEU   120     -66.183  64.233  47.521  1.00 20.41           C  
ATOM    966  CD2 LEU   120     -66.756  65.100  45.242  1.00 21.06           C  
ATOM    967  N   SER   121     -64.232  67.001  43.691  1.00 17.10           N  
ATOM    968  CA  SER   121     -63.886  68.420  43.688  1.00 16.92           C  
ATOM    969  C   SER   121     -65.043  69.385  43.917  1.00 16.32           C  
ATOM    970  O   SER   121     -66.179  69.141  43.501  1.00 15.79           O  
ATOM    971  CB  SER   121     -63.209  68.790  42.357  1.00 16.83           C  
ATOM    972  OG  SER   121     -62.043  68.020  42.120  1.00 18.99           O  
ATOM    973  N   LEU   122     -64.735  70.508  44.552  1.00 16.44           N  
ATOM    974  CA  LEU   122     -65.731  71.539  44.801  1.00 16.97           C  
ATOM    975  C   LEU   122     -65.498  72.634  43.742  1.00 16.96           C  
ATOM    976  O   LEU   122     -64.427  73.246  43.715  1.00 15.90           O  
ATOM    977  CB  LEU   122     -65.541  72.110  46.205  1.00 17.13           C  
ATOM    978  CG  LEU   122     -66.750  72.665  46.966  1.00 20.25           C  
ATOM    979  CD1 LEU   122     -66.325  73.910  47.739  1.00 16.95           C  
ATOM    980  CD2 LEU   122     -67.888  72.980  46.014  1.00 21.09           C  
ATOM    981  N   HIS   123     -66.495  72.868  42.884  1.00 16.64           N  
ATOM    982  CA  HIS   123     -66.402  73.881  41.817  1.00 16.90           C  
ATOM    983  C   HIS   123     -67.499  74.943  41.891  1.00 17.39           C  
ATOM    984  O   HIS   123     -67.366  76.018  41.299  1.00 17.02           O  
ATOM    985  CB  HIS   123     -66.479  73.232  40.430  1.00 16.08           C  
ATOM    986  CG  HIS   123     -65.332  72.328  40.114  1.00 16.50           C  
ATOM    987  ND1 HIS   123     -65.507  71.021  39.708  1.00 15.45           N  
ATOM    988  CD2 HIS   123     -63.994  72.538  40.135  1.00 15.14           C  
ATOM    989  CE1 HIS   123     -64.328  70.466  39.495  1.00 15.55           C  
ATOM    990  NE2 HIS   123     -63.393  71.366  39.748  1.00 16.05           N  
ATOM    991  N   PHE   124     -68.590  74.629  42.586  1.00 17.90           N  
ATOM    992  CA  PHE   124     -69.695  75.567  42.721  1.00 18.73           C  
ATOM    993  C   PHE   124     -70.096  75.824  44.175  1.00 18.98           C  
ATOM    994  O   PHE   124     -70.113  74.911  45.004  1.00 18.87           O  
ATOM    995  CB  PHE   124     -70.939  75.075  41.966  1.00 19.58           C  
ATOM    996  CG  PHE   124     -70.731  74.875  40.488  1.00 20.54           C  
ATOM    997  CD1 PHE   124     -70.274  73.654  40.000  1.00 18.44           C  
ATOM    998  CD2 PHE   124     -71.019  75.897  39.586  1.00 16.86           C  
ATOM    999  CE1 PHE   124     -70.105  73.450  38.638  1.00 20.85           C  
ATOM   1000  CE2 PHE   124     -70.852  75.707  38.217  1.00 18.55           C  
ATOM   1001  CZ  PHE   124     -70.394  74.478  37.741  1.00 19.89           C  
ATOM   1002  N   LEU   125     -70.421  77.078  44.465  1.00 19.01           N  
ATOM   1003  CA  LEU   125     -70.875  77.487  45.789  1.00 20.31           C  
ATOM   1004  C   LEU   125     -72.182  78.254  45.622  1.00 20.08           C  
ATOM   1005  O   LEU   125     -72.467  78.755  44.538  1.00 20.30           O  
ATOM   1006  CB  LEU   125     -69.856  78.419  46.443  1.00 20.06           C  
ATOM   1007  CG  LEU   125     -68.715  77.830  47.266  1.00 22.86           C  
ATOM   1008  CD1 LEU   125     -67.877  78.978  47.812  1.00 19.08           C  
ATOM   1009  CD2 LEU   125     -69.276  76.978  48.412  1.00 20.92           C  
ATOM   1010  N   GLU   126     -72.980  78.345  46.679  1.00 20.58           N  
ATOM   1011  CA  GLU   126     -74.199  79.145  46.590  1.00 21.38           C  
ATOM   1012  C   GLU   126     -73.722  80.587  46.486  1.00 20.33           C  
ATOM   1013  O   GLU   126     -72.813  80.997  47.207  1.00 19.93           O  
ATOM   1014  CB  GLU   126     -75.070  78.984  47.839  1.00 22.40           C  
ATOM   1015  CG  GLU   126     -75.661  77.589  47.996  1.00 28.31           C  
ATOM   1016  CD  GLU   126     -76.436  77.431  49.287  1.00 36.74           C  
ATOM   1017  OE1 GLU   126     -76.150  76.469  50.037  1.00 39.48           O  
ATOM   1018  OE2 GLU   126     -77.326  78.266  49.552  1.00 37.17           O  
ATOM   1019  N   GLY   127     -74.320  81.344  45.575  1.00 19.41           N  
ATOM   1020  CA  GLY   127     -73.934  82.728  45.393  1.00 19.12           C  
ATOM   1021  C   GLY   127     -75.086  83.604  44.946  1.00 20.12           C  
ATOM   1022  O   GLY   127     -76.260  83.251  45.113  1.00 18.44           O  
ATOM   1023  N   GLN   128     -74.740  84.750  44.369  1.00 19.52           N  
ATOM   1024  CA  GLN   128     -75.724  85.714  43.908  1.00 20.70           C  
ATOM   1025  C   GLN   128     -76.590  85.165  42.785  1.00 20.50           C  
ATOM   1026  O   GLN   128     -76.101  84.890  41.689  1.00 21.20           O  
ATOM   1027  CB  GLN   128     -75.025  86.991  43.437  1.00 20.60           C  
ATOM   1028  CG  GLN   128     -75.961  88.171  43.192  1.00 22.83           C  
ATOM   1029  CD  GLN   128     -76.644  88.644  44.464  1.00 25.86           C  
ATOM   1030  OE1 GLN   128     -76.033  88.668  45.533  1.00 26.02           O  
ATOM   1031  NE2 GLN   128     -77.911  89.041  44.351  1.00 26.03           N  
ATOM   1032  N   GLY   129     -77.879  85.000  43.075  1.00 20.52           N  
ATOM   1033  CA  GLY   129     -78.812  84.504  42.081  1.00 19.84           C  
ATOM   1034  C   GLY   129     -78.925  82.992  42.003  1.00 20.71           C  
ATOM   1035  O   GLY   129     -79.748  82.475  41.251  1.00 20.50           O  
ATOM   1036  N   GLY   130     -78.114  82.277  42.786  1.00 20.70           N  
ATOM   1037  CA  GLY   130     -78.134  80.820  42.764  1.00 19.96           C  
ATOM   1038  C   GLY   130     -76.716  80.268  42.804  1.00 20.99           C  
ATOM   1039  O   GLY   130     -75.788  80.989  43.173  1.00 20.79           O  
ATOM   1040  N   PHE   131     -76.526  79.006  42.426  1.00 20.77           N  
ATOM   1041  CA  PHE   131     -75.182  78.426  42.443  1.00 21.15           C  
ATOM   1042  C   PHE   131     -74.246  79.156  41.486  1.00 20.05           C  
ATOM   1043  O   PHE   131     -74.615  79.474  40.354  1.00 19.99           O  
ATOM   1044  CB  PHE   131     -75.228  76.937  42.093  1.00 21.84           C  
ATOM   1045  CG  PHE   131     -75.770  76.078  43.197  1.00 27.48           C  
ATOM   1046  CD1 PHE   131     -75.052  75.905  44.375  1.00 30.02           C  
ATOM   1047  CD2 PHE   131     -77.017  75.475  43.074  1.00 31.97           C  
ATOM   1048  CE1 PHE   131     -75.569  75.146  45.419  1.00 34.60           C  
ATOM   1049  CE2 PHE   131     -77.543  74.713  44.113  1.00 34.22           C  
ATOM   1050  CZ  PHE   131     -76.818  74.550  45.287  1.00 34.10           C  
ATOM   1051  N   ARG   132     -73.030  79.416  41.947  1.00 17.63           N  
ATOM   1052  CA  ARG   132     -72.048  80.132  41.144  1.00 16.94           C  
ATOM   1053  C   ARG   132     -70.723  79.383  41.030  1.00 17.28           C  
ATOM   1054  O   ARG   132     -70.370  78.579  41.895  1.00 17.29           O  
ATOM   1055  CB  ARG   132     -71.811  81.516  41.744  1.00 16.23           C  
ATOM   1056  CG  ARG   132     -72.984  82.462  41.561  1.00 16.78           C  
ATOM   1057  CD  ARG   132     -73.015  83.000  40.134  1.00 19.35           C  
ATOM   1058  NE  ARG   132     -73.623  84.319  40.123  1.00 27.72           N  
ATOM   1059  CZ  ARG   132     -73.098  85.386  39.540  1.00 25.75           C  
ATOM   1060  NH1 ARG   132     -71.940  85.307  38.895  1.00 23.41           N  
ATOM   1061  NH2 ARG   132     -73.731  86.544  39.626  1.00 32.88           N  
ATOM   1062  N   SER   133     -69.986  79.664  39.963  1.00 16.91           N  
ATOM   1063  CA  SER   133     -68.718  79.004  39.731  1.00 18.41           C  
ATOM   1064  C   SER   133     -67.578  79.643  40.499  1.00 18.91           C  
ATOM   1065  O   SER   133     -67.457  80.866  40.583  1.00 20.07           O  
ATOM   1066  CB  SER   133     -68.373  79.009  38.244  1.00 17.95           C  
ATOM   1067  OG  SER   133     -67.112  78.396  38.018  1.00 18.54           O  
ATOM   1068  N   ILE   134     -66.726  78.786  41.036  1.00 18.90           N  
ATOM   1069  CA  ILE   134     -65.564  79.223  41.782  1.00 18.73           C  
ATOM   1070  C   ILE   134     -64.404  79.500  40.822  1.00 18.92           C  
ATOM   1071  O   ILE   134     -63.588  80.387  41.065  1.00 18.94           O  
ATOM   1072  CB  ILE   134     -65.110  78.118  42.764  1.00 19.30           C  
ATOM   1073  CG1 ILE   134     -66.157  77.942  43.865  1.00 18.83           C  
ATOM   1074  CG2 ILE   134     -63.727  78.451  43.348  1.00 19.78           C  
ATOM   1075  CD1 ILE   134     -65.957  76.680  44.698  1.00 20.43           C  
ATOM   1076  N   ASP   135     -64.357  78.764  39.714  1.00 19.40           N  
ATOM   1077  CA  ASP   135     -63.217  78.875  38.798  1.00 21.59           C  
ATOM   1078  C   ASP   135     -63.420  79.327  37.345  1.00 21.50           C  
ATOM   1079  O   ASP   135     -62.493  79.233  36.539  1.00 22.74           O  
ATOM   1080  CB  ASP   135     -62.479  77.529  38.790  1.00 22.00           C  
ATOM   1081  CG  ASP   135     -63.357  76.397  38.300  1.00 23.63           C  
ATOM   1082  OD1 ASP   135     -64.564  76.638  38.101  1.00 27.42           O  
ATOM   1083  OD2 ASP   135     -62.860  75.269  38.108  1.00 27.62           O  
ATOM   1084  N   PHE   136     -64.599  79.827  36.995  1.00 21.77           N  
ATOM   1085  CA  PHE   136     -64.815  80.255  35.617  1.00 21.47           C  
ATOM   1086  C   PHE   136     -63.986  81.484  35.231  1.00 21.69           C  
ATOM   1087  O   PHE   136     -63.264  81.459  34.239  1.00 21.25           O  
ATOM   1088  CB  PHE   136     -66.291  80.540  35.363  1.00 21.88           C  
ATOM   1089  CG  PHE   136     -66.595  80.831  33.927  1.00 23.93           C  
ATOM   1090  CD1 PHE   136     -66.558  79.812  32.976  1.00 24.41           C  
ATOM   1091  CD2 PHE   136     -66.858  82.132  33.509  1.00 24.01           C  
ATOM   1092  CE1 PHE   136     -66.777  80.085  31.626  1.00 24.93           C  
ATOM   1093  CE2 PHE   136     -67.079  82.419  32.159  1.00 24.65           C  
ATOM   1094  CZ  PHE   136     -67.038  81.394  31.217  1.00 24.69           C  
ATOM   1095  N   SER   137     -64.089  82.563  36.005  1.00 21.35           N  
ATOM   1096  CA  SER   137     -63.318  83.769  35.711  1.00 21.49           C  
ATOM   1097  C   SER   137     -63.298  84.710  36.907  1.00 21.91           C  
ATOM   1098  O   SER   137     -64.187  84.670  37.763  1.00 21.53           O  
ATOM   1099  CB  SER   137     -63.909  84.509  34.513  1.00 22.01           C  
ATOM   1100  OG  SER   137     -65.004  85.315  34.920  1.00 21.84           O  
ATOM   1101  N   ALA   138     -62.288  85.573  36.942  1.00 21.94           N  
ATOM   1102  CA  ALA   138     -62.129  86.529  38.029  1.00 22.39           C  
ATOM   1103  C   ALA   138     -63.368  87.407  38.223  1.00 22.62           C  
ATOM   1104  O   ALA   138     -63.858  87.550  39.347  1.00 22.57           O  
ATOM   1105  CB  ALA   138     -60.901  87.398  37.776  1.00 22.17           C  
ATOM   1106  N   GLU   139     -63.875  87.985  37.135  1.00 22.05           N  
ATOM   1107  CA  GLU   139     -65.049  88.855  37.209  1.00 22.71           C  
ATOM   1108  C   GLU   139     -66.286  88.089  37.681  1.00 21.48           C  
ATOM   1109  O   GLU   139     -67.070  88.590  38.495  1.00 21.62           O  
ATOM   1110  CB  GLU   139     -65.347  89.493  35.844  1.00 23.51           C  
ATOM   1111  CG  GLU   139     -64.249  90.403  35.288  1.00 27.62           C  
ATOM   1112  CD  GLU   139     -62.999  89.643  34.849  1.00 34.14           C  
ATOM   1113  OE1 GLU   139     -63.109  88.459  34.461  1.00 34.06           O  
ATOM   1114  OE2 GLU   139     -61.901  90.241  34.873  1.00 38.90           O  
ATOM   1115  N   ASP   140     -66.463  86.877  37.171  1.00 19.44           N  
ATOM   1116  CA  ASP   140     -67.606  86.075  37.564  1.00 19.61           C  
ATOM   1117  C   ASP   140     -67.496  85.685  39.035  1.00 18.98           C  
ATOM   1118  O   ASP   140     -68.484  85.732  39.777  1.00 18.38           O  
ATOM   1119  CB  ASP   140     -67.700  84.817  36.705  1.00 19.47           C  
ATOM   1120  CG  ASP   140     -68.956  84.020  36.987  1.00 22.31           C  
ATOM   1121  OD1 ASP   140     -70.058  84.501  36.631  1.00 23.22           O  
ATOM   1122  OD2 ASP   140     -68.842  82.920  37.567  1.00 24.47           O  
ATOM   1123  N   TYR   141     -66.287  85.310  39.446  1.00 19.04           N  
ATOM   1124  CA  TYR   141     -66.027  84.917  40.827  1.00 19.28           C  
ATOM   1125  C   TYR   141     -66.271  86.096  41.764  1.00 20.13           C  
ATOM   1126  O   TYR   141     -66.780  85.932  42.872  1.00 19.94           O  
ATOM   1127  CB  TYR   141     -64.581  84.424  40.985  1.00 17.39           C  
ATOM   1128  CG  TYR   141     -64.264  83.885  42.366  1.00 18.18           C  
ATOM   1129  CD1 TYR   141     -64.999  82.829  42.903  1.00 18.10           C  
ATOM   1130  CD2 TYR   141     -63.225  84.421  43.132  1.00 18.30           C  
ATOM   1131  CE1 TYR   141     -64.713  82.316  44.163  1.00 16.81           C  
ATOM   1132  CE2 TYR   141     -62.928  83.915  44.398  1.00 17.68           C  
ATOM   1133  CZ  TYR   141     -63.682  82.859  44.905  1.00 18.93           C  
ATOM   1134  OH  TYR   141     -63.418  82.346  46.158  1.00 18.17           O  
ATOM   1135  N   ASN   142     -65.903  87.287  41.310  1.00 20.72           N  
ATOM   1136  CA  ASN   142     -66.090  88.485  42.110  1.00 21.44           C  
ATOM   1137  C   ASN   142     -67.568  88.819  42.301  1.00 21.82           C  
ATOM   1138  O   ASN   142     -68.015  89.067  43.420  1.00 22.22           O  
ATOM   1139  CB  ASN   142     -65.374  89.668  41.456  1.00 21.19           C  
ATOM   1140  CG  ASN   142     -65.526  90.947  42.251  1.00 23.08           C  
ATOM   1141  OD1 ASN   142     -65.420  90.942  43.478  1.00 24.83           O  
ATOM   1142  ND2 ASN   142     -65.766  92.058  41.556  1.00 23.17           N  
ATOM   1143  N   GLU   143     -68.323  88.822  41.206  1.00 22.81           N  
ATOM   1144  CA  GLU   143     -69.742  89.168  41.259  1.00 23.61           C  
ATOM   1145  C   GLU   143     -70.623  88.094  41.886  1.00 22.47           C  
ATOM   1146  O   GLU   143     -71.559  88.398  42.628  1.00 22.85           O  
ATOM   1147  CB  GLU   143     -70.265  89.470  39.846  1.00 24.72           C  
ATOM   1148  CG  GLU   143     -69.517  90.572  39.110  1.00 31.28           C  
ATOM   1149  CD  GLU   143     -69.991  90.747  37.672  1.00 40.82           C  
ATOM   1150  OE1 GLU   143     -69.338  91.499  36.913  1.00 43.61           O  
ATOM   1151  OE2 GLU   143     -71.018  90.136  37.302  1.00 43.20           O  
ATOM   1152  N   GLY   144     -70.332  86.836  41.577  1.00 20.21           N  
ATOM   1153  CA  GLY   144     -71.150  85.754  42.085  1.00 19.65           C  
ATOM   1154  C   GLY   144     -70.841  85.256  43.482  1.00 19.22           C  
ATOM   1155  O   GLY   144     -71.752  84.865  44.208  1.00 18.45           O  
ATOM   1156  N   ILE   145     -69.565  85.290  43.865  1.00 18.31           N  
ATOM   1157  CA  ILE   145     -69.146  84.757  45.160  1.00 19.09           C  
ATOM   1158  C   ILE   145     -68.471  85.697  46.157  1.00 19.50           C  
ATOM   1159  O   ILE   145     -68.898  85.780  47.310  1.00 19.96           O  
ATOM   1160  CB  ILE   145     -68.237  83.528  44.945  1.00 18.54           C  
ATOM   1161  CG1 ILE   145     -69.085  82.384  44.378  1.00 17.50           C  
ATOM   1162  CG2 ILE   145     -67.551  83.117  46.256  1.00 18.38           C  
ATOM   1163  CD1 ILE   145     -68.290  81.192  43.868  1.00 19.02           C  
ATOM   1164  N   VAL   146     -67.429  86.404  45.734  1.00 19.08           N  
ATOM   1165  CA  VAL   146     -66.729  87.295  46.653  1.00 19.07           C  
ATOM   1166  C   VAL   146     -67.653  88.370  47.226  1.00 19.90           C  
ATOM   1167  O   VAL   146     -67.723  88.553  48.447  1.00 19.26           O  
ATOM   1168  CB  VAL   146     -65.509  87.967  45.975  1.00 20.07           C  
ATOM   1169  CG1 VAL   146     -64.782  88.870  46.974  1.00 17.37           C  
ATOM   1170  CG2 VAL   146     -64.561  86.899  45.436  1.00 16.59           C  
ATOM   1171  N   GLN   147     -68.370  89.073  46.354  1.00 19.68           N  
ATOM   1172  CA  GLN   147     -69.282  90.115  46.810  1.00 20.66           C  
ATOM   1173  C   GLN   147     -70.440  89.527  47.615  1.00 20.02           C  
ATOM   1174  O   GLN   147     -70.922  90.153  48.554  1.00 21.16           O  
ATOM   1175  CB  GLN   147     -69.835  90.916  45.625  1.00 21.57           C  
ATOM   1176  CG  GLN   147     -68.771  91.658  44.821  1.00 24.93           C  
ATOM   1177  CD  GLN   147     -69.354  92.657  43.831  1.00 31.16           C  
ATOM   1178  OE1 GLN   147     -70.368  92.394  43.184  1.00 34.27           O  
ATOM   1179  NE2 GLN   147     -68.702  93.806  43.701  1.00 34.07           N  
ATOM   1180  N   PHE   148     -70.875  88.321  47.250  1.00 19.21           N  
ATOM   1181  CA  PHE   148     -71.978  87.663  47.939  1.00 18.13           C  
ATOM   1182  C   PHE   148     -71.620  87.335  49.383  1.00 18.35           C  
ATOM   1183  O   PHE   148     -72.430  87.537  50.292  1.00 18.47           O  
ATOM   1184  CB  PHE   148     -72.373  86.376  47.200  1.00 18.59           C  
ATOM   1185  CG  PHE   148     -73.532  85.628  47.832  1.00 19.31           C  
ATOM   1186  CD1 PHE   148     -73.305  84.568  48.707  1.00 19.13           C  
ATOM   1187  CD2 PHE   148     -74.848  85.978  47.535  1.00 18.92           C  
ATOM   1188  CE1 PHE   148     -74.375  83.862  49.277  1.00 20.95           C  
ATOM   1189  CE2 PHE   148     -75.927  85.280  48.101  1.00 20.33           C  
ATOM   1190  CZ  PHE   148     -75.689  84.220  48.972  1.00 20.37           C  
ATOM   1191  N   TYR   149     -70.406  86.839  49.600  1.00 17.17           N  
ATOM   1192  CA  TYR   149     -69.978  86.471  50.941  1.00 17.94           C  
ATOM   1193  C   TYR   149     -69.372  87.598  51.768  1.00 18.05           C  
ATOM   1194  O   TYR   149     -69.147  87.432  52.965  1.00 17.84           O  
ATOM   1195  CB  TYR   149     -69.030  85.271  50.879  1.00 17.62           C  
ATOM   1196  CG  TYR   149     -69.756  83.987  50.551  1.00 18.10           C  
ATOM   1197  CD1 TYR   149     -70.607  83.385  51.484  1.00 19.32           C  
ATOM   1198  CD2 TYR   149     -69.637  83.402  49.295  1.00 18.31           C  
ATOM   1199  CE1 TYR   149     -71.324  82.232  51.164  1.00 18.76           C  
ATOM   1200  CE2 TYR   149     -70.349  82.249  48.962  1.00 18.28           C  
ATOM   1201  CZ  TYR   149     -71.190  81.672  49.900  1.00 17.17           C  
ATOM   1202  OH  TYR   149     -71.909  80.551  49.566  1.00 15.74           O  
ATOM   1203  N   GLY   150     -69.115  88.741  51.135  1.00 18.73           N  
ATOM   1204  CA  GLY   150     -68.583  89.881  51.864  1.00 19.52           C  
ATOM   1205  C   GLY   150     -67.123  90.237  51.655  1.00 19.53           C  
ATOM   1206  O   GLY   150     -66.662  91.245  52.180  1.00 19.89           O  
ATOM   1207  N   GLY   151     -66.391  89.423  50.901  1.00 20.05           N  
ATOM   1208  CA  GLY   151     -64.981  89.698  50.671  1.00 19.66           C  
ATOM   1209  C   GLY   151     -64.195  88.441  50.336  1.00 19.37           C  
ATOM   1210  O   GLY   151     -64.723  87.325  50.411  1.00 18.69           O  
ATOM   1211  N   PHE   152     -62.928  88.618  49.968  1.00 18.84           N  
ATOM   1212  CA  PHE   152     -62.100  87.482  49.584  1.00 19.69           C  
ATOM   1213  C   PHE   152     -61.952  86.449  50.697  1.00 19.50           C  
ATOM   1214  O   PHE   152     -62.082  85.251  50.448  1.00 19.96           O  
ATOM   1215  CB  PHE   152     -60.708  87.935  49.124  1.00 19.67           C  
ATOM   1216  CG  PHE   152     -59.965  86.881  48.351  1.00 20.26           C  
ATOM   1217  CD1 PHE   152     -60.273  86.634  47.013  1.00 19.81           C  
ATOM   1218  CD2 PHE   152     -59.002  86.097  48.971  1.00 17.65           C  
ATOM   1219  CE1 PHE   152     -59.633  85.617  46.309  1.00 20.35           C  
ATOM   1220  CE2 PHE   152     -58.359  85.078  48.274  1.00 22.32           C  
ATOM   1221  CZ  PHE   152     -58.678  84.839  46.938  1.00 17.77           C  
ATOM   1222  N   GLU   153     -61.675  86.907  51.917  1.00 19.30           N  
ATOM   1223  CA  GLU   153     -61.518  85.979  53.035  1.00 20.49           C  
ATOM   1224  C   GLU   153     -62.838  85.266  53.334  1.00 20.11           C  
ATOM   1225  O   GLU   153     -62.850  84.063  53.595  1.00 19.98           O  
ATOM   1226  CB  GLU   153     -61.035  86.693  54.300  1.00 21.59           C  
ATOM   1227  CG  GLU   153     -60.520  85.712  55.349  1.00 25.88           C  
ATOM   1228  CD  GLU   153     -60.308  86.329  56.721  1.00 31.96           C  
ATOM   1229  OE1 GLU   153     -59.934  87.518  56.792  1.00 34.23           O  
ATOM   1230  OE2 GLU   153     -60.497  85.612  57.731  1.00 34.56           O  
ATOM   1231  N   GLN   154     -63.940  86.011  53.315  1.00 19.01           N  
ATOM   1232  CA  GLN   154     -65.247  85.407  53.552  1.00 18.72           C  
ATOM   1233  C   GLN   154     -65.499  84.333  52.489  1.00 18.18           C  
ATOM   1234  O   GLN   154     -66.071  83.280  52.781  1.00 18.80           O  
ATOM   1235  CB  GLN   154     -66.354  86.462  53.506  1.00 18.07           C  
ATOM   1236  CG  GLN   154     -66.373  87.400  54.705  1.00 20.43           C  
ATOM   1237  CD  GLN   154     -65.609  88.689  54.469  1.00 22.77           C  
ATOM   1238  OE1 GLN   154     -64.586  88.710  53.778  1.00 22.99           O  
ATOM   1239  NE2 GLN   154     -66.098  89.777  55.058  1.00 23.95           N  
ATOM   1240  N   ALA   155     -65.057  84.598  51.263  1.00 16.90           N  
ATOM   1241  CA  ALA   155     -65.215  83.641  50.181  1.00 16.43           C  
ATOM   1242  C   ALA   155     -64.372  82.402  50.483  1.00 16.30           C  
ATOM   1243  O   ALA   155     -64.830  81.269  50.292  1.00 16.24           O  
ATOM   1244  CB  ALA   155     -64.790  84.263  48.860  1.00 16.24           C  
ATOM   1245  N   GLN   156     -63.143  82.623  50.951  1.00 16.21           N  
ATOM   1246  CA  GLN   156     -62.245  81.522  51.303  1.00 16.17           C  
ATOM   1247  C   GLN   156     -62.902  80.586  52.321  1.00 16.02           C  
ATOM   1248  O   GLN   156     -62.895  79.360  52.160  1.00 15.85           O  
ATOM   1249  CB  GLN   156     -60.939  82.051  51.920  1.00 16.32           C  
ATOM   1250  CG  GLN   156     -59.953  82.670  50.944  1.00 18.97           C  
ATOM   1251  CD  GLN   156     -58.735  83.250  51.651  1.00 22.46           C  
ATOM   1252  OE1 GLN   156     -57.603  83.089  51.194  1.00 24.94           O  
ATOM   1253  NE2 GLN   156     -58.966  83.931  52.770  1.00 17.51           N  
ATOM   1254  N   LEU   157     -63.445  81.176  53.381  1.00 15.59           N  
ATOM   1255  CA  LEU   157     -64.067  80.399  54.446  1.00 16.31           C  
ATOM   1256  C   LEU   157     -65.314  79.635  53.999  1.00 16.15           C  
ATOM   1257  O   LEU   157     -65.542  78.514  54.446  1.00 16.00           O  
ATOM   1258  CB  LEU   157     -64.377  81.311  55.641  1.00 16.37           C  
ATOM   1259  CG  LEU   157     -63.099  81.813  56.337  1.00 17.12           C  
ATOM   1260  CD1 LEU   157     -63.437  82.911  57.321  1.00 20.55           C  
ATOM   1261  CD2 LEU   157     -62.405  80.649  57.039  1.00 15.97           C  
ATOM   1262  N   ALA   158     -66.116  80.228  53.121  1.00 16.11           N  
ATOM   1263  CA  ALA   158     -67.310  79.542  52.623  1.00 17.00           C  
ATOM   1264  C   ALA   158     -66.871  78.386  51.721  1.00 17.36           C  
ATOM   1265  O   ALA   158     -67.490  77.325  51.701  1.00 17.75           O  
ATOM   1266  CB  ALA   158     -68.195  80.504  51.844  1.00 17.22           C  
ATOM   1267  N   TYR   159     -65.786  78.608  50.985  1.00 17.24           N  
ATOM   1268  CA  TYR   159     -65.234  77.599  50.091  1.00 17.56           C  
ATOM   1269  C   TYR   159     -64.732  76.409  50.899  1.00 18.03           C  
ATOM   1270  O   TYR   159     -65.058  75.261  50.587  1.00 18.39           O  
ATOM   1271  CB  TYR   159     -64.085  78.192  49.272  1.00 17.48           C  
ATOM   1272  CG  TYR   159     -63.208  77.158  48.610  1.00 17.79           C  
ATOM   1273  CD1 TYR   159     -63.638  76.466  47.471  1.00 18.24           C  
ATOM   1274  CD2 TYR   159     -61.961  76.834  49.150  1.00 16.46           C  
ATOM   1275  CE1 TYR   159     -62.848  75.477  46.896  1.00 16.00           C  
ATOM   1276  CE2 TYR   159     -61.168  75.853  48.582  1.00 15.74           C  
ATOM   1277  CZ  TYR   159     -61.616  75.175  47.458  1.00 14.74           C  
ATOM   1278  OH  TYR   159     -60.837  74.183  46.920  1.00 15.50           O  
ATOM   1279  N   LEU   160     -63.948  76.683  51.940  1.00 18.00           N  
ATOM   1280  CA  LEU   160     -63.412  75.615  52.785  1.00 18.59           C  
ATOM   1281  C   LEU   160     -64.520  74.859  53.516  1.00 18.99           C  
ATOM   1282  O   LEU   160     -64.397  73.658  53.760  1.00 19.08           O  
ATOM   1283  CB  LEU   160     -62.398  76.177  53.786  1.00 18.19           C  
ATOM   1284  CG  LEU   160     -61.137  76.755  53.134  1.00 17.60           C  
ATOM   1285  CD1 LEU   160     -60.248  77.389  54.184  1.00 18.17           C  
ATOM   1286  CD2 LEU   160     -60.392  75.657  52.394  1.00 17.78           C  
ATOM   1287  N   GLU   161     -65.590  75.560  53.881  1.00 19.53           N  
ATOM   1288  CA  GLU   161     -66.723  74.905  54.531  1.00 20.42           C  
ATOM   1289  C   GLU   161     -67.271  73.866  53.555  1.00 19.41           C  
ATOM   1290  O   GLU   161     -67.601  72.750  53.949  1.00 19.11           O  
ATOM   1291  CB  GLU   161     -67.810  75.923  54.884  1.00 21.45           C  
ATOM   1292  CG  GLU   161     -69.101  75.309  55.426  1.00 27.56           C  
ATOM   1293  CD  GLU   161     -68.851  74.276  56.517  1.00 33.72           C  
ATOM   1294  OE1 GLU   161     -68.078  74.572  57.456  1.00 38.36           O  
ATOM   1295  OE2 GLU   161     -69.429  73.167  56.434  1.00 34.52           O  
ATOM   1296  N   GLY   162     -67.327  74.236  52.274  1.00 19.71           N  
ATOM   1297  CA  GLY   162     -67.800  73.326  51.238  1.00 17.25           C  
ATOM   1298  C   GLY   162     -66.864  72.131  51.086  1.00 17.96           C  
ATOM   1299  O   GLY   162     -67.309  70.993  50.901  1.00 16.23           O  
ATOM   1300  N   VAL   163     -65.561  72.386  51.171  1.00 17.00           N  
ATOM   1301  CA  VAL   163     -64.575  71.317  51.060  1.00 17.82           C  
ATOM   1302  C   VAL   163     -64.769  70.360  52.231  1.00 18.34           C  
ATOM   1303  O   VAL   163     -64.735  69.143  52.059  1.00 18.60           O  
ATOM   1304  CB  VAL   163     -63.128  71.873  51.079  1.00 16.97           C  
ATOM   1305  CG1 VAL   163     -62.116  70.723  51.122  1.00 16.89           C  
ATOM   1306  CG2 VAL   163     -62.892  72.731  49.840  1.00 16.33           C  
ATOM   1307  N   LYS   164     -64.987  70.925  53.417  1.00 18.65           N  
ATOM   1308  CA  LYS   164     -65.201  70.136  54.629  1.00 19.29           C  
ATOM   1309  C   LYS   164     -66.422  69.233  54.438  1.00 19.38           C  
ATOM   1310  O   LYS   164     -66.380  68.045  54.764  1.00 19.61           O  
ATOM   1311  CB  LYS   164     -65.397  71.072  55.828  1.00 19.42           C  
ATOM   1312  CG  LYS   164     -65.532  70.369  57.190  1.00 21.89           C  
ATOM   1313  CD  LYS   164     -65.479  71.396  58.322  1.00 25.85           C  
ATOM   1314  CE  LYS   164     -65.712  70.770  59.689  1.00 30.77           C  
ATOM   1315  NZ  LYS   164     -67.125  70.331  59.871  1.00 31.88           N  
ATOM   1316  N   GLN   165     -67.504  69.795  53.902  1.00 19.51           N  
ATOM   1317  CA  GLN   165     -68.712  69.013  53.649  1.00 20.69           C  
ATOM   1318  C   GLN   165     -68.458  67.873  52.664  1.00 19.56           C  
ATOM   1319  O   GLN   165     -68.972  66.772  52.848  1.00 19.71           O  
ATOM   1320  CB  GLN   165     -69.831  69.897  53.096  1.00 21.02           C  
ATOM   1321  CG  GLN   165     -70.444  70.845  54.104  1.00 25.52           C  
ATOM   1322  CD  GLN   165     -71.551  71.674  53.489  1.00 30.06           C  
ATOM   1323  OE1 GLN   165     -71.363  72.299  52.445  1.00 32.66           O  
ATOM   1324  NE2 GLN   165     -72.711  71.681  54.126  1.00 32.11           N  
ATOM   1325  N   SER   166     -67.680  68.135  51.613  1.00 20.01           N  
ATOM   1326  CA  SER   166     -67.390  67.094  50.630  1.00 19.44           C  
ATOM   1327  C   SER   166     -66.643  65.932  51.282  1.00 19.33           C  
ATOM   1328  O   SER   166     -66.837  64.780  50.913  1.00 20.17           O  
ATOM   1329  CB  SER   166     -66.563  67.656  49.462  1.00 19.39           C  
ATOM   1330  OG  SER   166     -65.203  67.840  49.823  1.00 18.49           O  
ATOM   1331  N   ILE   167     -65.791  66.231  52.254  1.00 19.89           N  
ATOM   1332  CA  ILE   167     -65.040  65.180  52.936  1.00 19.79           C  
ATOM   1333  C   ILE   167     -65.943  64.367  53.861  1.00 20.72           C  
ATOM   1334  O   ILE   167     -65.842  63.143  53.920  1.00 19.98           O  
ATOM   1335  CB  ILE   167     -63.877  65.770  53.773  1.00 20.19           C  
ATOM   1336  CG1 ILE   167     -62.844  66.417  52.849  1.00 18.55           C  
ATOM   1337  CG2 ILE   167     -63.219  64.681  54.615  1.00 18.61           C  
ATOM   1338  CD1 ILE   167     -61.818  67.246  53.588  1.00 19.57           C  
ATOM   1339  N   GLU   168     -66.819  65.055  54.584  1.00 21.44           N  
ATOM   1340  CA  GLU   168     -67.732  64.397  55.517  1.00 22.82           C  
ATOM   1341  C   GLU   168     -68.841  63.624  54.798  1.00 23.36           C  
ATOM   1342  O   GLU   168     -69.426  62.700  55.358  1.00 22.90           O  
ATOM   1343  CB  GLU   168     -68.381  65.437  56.441  1.00 23.31           C  
ATOM   1344  CG  GLU   168     -67.395  66.295  57.215  1.00 26.17           C  
ATOM   1345  CD  GLU   168     -68.066  67.431  57.974  1.00 29.71           C  
ATOM   1346  OE1 GLU   168     -68.995  68.059  57.420  1.00 30.59           O  
ATOM   1347  OE2 GLU   168     -67.653  67.706  59.120  1.00 30.85           O  
ATOM   1348  N   ALA   169     -69.121  64.012  53.557  1.00 23.51           N  
ATOM   1349  CA  ALA   169     -70.202  63.411  52.780  1.00 24.98           C  
ATOM   1350  C   ALA   169     -70.169  61.892  52.606  1.00 26.02           C  
ATOM   1351  O   ALA   169     -69.117  61.296  52.347  1.00 25.90           O  
ATOM   1352  CB  ALA   169     -70.288  64.075  51.415  1.00 24.33           C  
ATOM   1353  N   ASP   170     -71.348  61.287  52.752  1.00 27.07           N  
ATOM   1354  CA  ASP   170     -71.533  59.855  52.549  1.00 28.75           C  
ATOM   1355  C   ASP   170     -72.059  59.724  51.128  1.00 28.18           C  
ATOM   1356  O   ASP   170     -73.236  59.964  50.873  1.00 28.71           O  
ATOM   1357  CB  ASP   170     -72.570  59.274  53.517  1.00 29.87           C  
ATOM   1358  CG  ASP   170     -73.244  58.022  52.963  1.00 34.17           C  
ATOM   1359  OD1 ASP   170     -72.519  57.107  52.509  1.00 40.00           O  
ATOM   1360  OD2 ASP   170     -74.496  57.955  52.976  1.00 35.02           O  
ATOM   1361  N   LEU   171     -71.181  59.377  50.198  1.00 27.38           N  
ATOM   1362  CA  LEU   171     -71.582  59.247  48.804  1.00 26.16           C  
ATOM   1363  C   LEU   171     -71.478  57.811  48.326  1.00 25.38           C  
ATOM   1364  O   LEU   171     -71.308  57.548  47.136  1.00 25.18           O  
ATOM   1365  CB  LEU   171     -70.730  60.176  47.929  1.00 26.12           C  
ATOM   1366  CG  LEU   171     -70.880  61.668  48.265  1.00 25.19           C  
ATOM   1367  CD1 LEU   171     -69.902  62.511  47.450  1.00 24.37           C  
ATOM   1368  CD2 LEU   171     -72.315  62.100  47.997  1.00 23.54           C  
ATOM   1369  N   GLY   172     -71.570  56.882  49.270  1.00 24.58           N  
ATOM   1370  CA  GLY   172     -71.525  55.479  48.912  1.00 24.17           C  
ATOM   1371  C   GLY   172     -70.132  54.886  48.852  1.00 23.58           C  
ATOM   1372  O   GLY   172     -69.137  55.561  49.135  1.00 23.52           O  
ATOM   1373  N   LEU   173     -70.067  53.614  48.471  1.00 22.35           N  
ATOM   1374  CA  LEU   173     -68.810  52.883  48.393  1.00 22.61           C  
ATOM   1375  C   LEU   173     -67.851  53.399  47.338  1.00 22.24           C  
ATOM   1376  O   LEU   173     -66.632  53.283  47.484  1.00 22.11           O  
ATOM   1377  CB  LEU   173     -69.088  51.404  48.113  1.00 23.06           C  
ATOM   1378  CG  LEU   173     -67.868  50.517  47.878  1.00 24.01           C  
ATOM   1379  CD1 LEU   173     -66.994  50.481  49.123  1.00 26.30           C  
ATOM   1380  CD2 LEU   173     -68.333  49.110  47.509  1.00 27.66           C  
ATOM   1381  N   PHE   174     -68.403  53.970  46.276  1.00 21.22           N  
ATOM   1382  CA  PHE   174     -67.589  54.454  45.172  1.00 21.30           C  
ATOM   1383  C   PHE   174     -67.182  55.926  45.238  1.00 20.95           C  
ATOM   1384  O   PHE   174     -66.700  56.490  44.255  1.00 20.64           O  
ATOM   1385  CB  PHE   174     -68.304  54.145  43.861  1.00 21.26           C  
ATOM   1386  CG  PHE   174     -68.526  52.675  43.644  1.00 23.57           C  
ATOM   1387  CD1 PHE   174     -67.493  51.857  43.191  1.00 23.77           C  
ATOM   1388  CD2 PHE   174     -69.757  52.094  43.946  1.00 24.63           C  
ATOM   1389  CE1 PHE   174     -67.685  50.473  43.041  1.00 26.27           C  
ATOM   1390  CE2 PHE   174     -69.959  50.721  43.802  1.00 23.85           C  
ATOM   1391  CZ  PHE   174     -68.920  49.908  43.348  1.00 25.02           C  
ATOM   1392  N   LYS   175     -67.366  56.546  46.398  1.00 20.44           N  
ATOM   1393  CA  LYS   175     -66.974  57.942  46.568  1.00 19.38           C  
ATOM   1394  C   LYS   175     -65.464  58.066  46.402  1.00 18.98           C  
ATOM   1395  O   LYS   175     -64.705  57.267  46.950  1.00 18.56           O  
ATOM   1396  CB  LYS   175     -67.354  58.435  47.966  1.00 20.15           C  
ATOM   1397  CG  LYS   175     -66.828  59.818  48.326  1.00 21.42           C  
ATOM   1398  CD  LYS   175     -67.352  60.215  49.691  1.00 25.65           C  
ATOM   1399  CE  LYS   175     -67.123  61.684  50.010  1.00 29.93           C  
ATOM   1400  NZ  LYS   175     -65.895  61.904  50.805  1.00 32.90           N  
ATOM   1401  N   PRO   176     -65.013  59.050  45.613  1.00 18.15           N  
ATOM   1402  CA  PRO   176     -63.574  59.227  45.428  1.00 17.21           C  
ATOM   1403  C   PRO   176     -62.926  59.437  46.793  1.00 17.67           C  
ATOM   1404  O   PRO   176     -63.570  59.923  47.726  1.00 17.11           O  
ATOM   1405  CB  PRO   176     -63.491  60.484  44.557  1.00 17.99           C  
ATOM   1406  CG  PRO   176     -64.733  60.389  43.723  1.00 17.80           C  
ATOM   1407  CD  PRO   176     -65.776  59.970  44.749  1.00 17.41           C  
ATOM   1408  N   ARG   177     -61.669  59.041  46.926  1.00 18.17           N  
ATOM   1409  CA  ARG   177     -60.964  59.231  48.187  1.00 19.75           C  
ATOM   1410  C   ARG   177     -59.842  60.263  48.049  1.00 19.79           C  
ATOM   1411  O   ARG   177     -59.068  60.481  48.978  1.00 19.29           O  
ATOM   1412  CB  ARG   177     -60.421  57.897  48.697  1.00 20.05           C  
ATOM   1413  CG  ARG   177     -61.528  57.004  49.233  1.00 22.64           C  
ATOM   1414  CD  ARG   177     -61.026  55.650  49.671  1.00 25.55           C  
ATOM   1415  NE  ARG   177     -62.137  54.795  50.085  1.00 28.98           N  
ATOM   1416  CZ  ARG   177     -62.019  53.502  50.365  1.00 28.31           C  
ATOM   1417  NH1 ARG   177     -60.834  52.914  50.278  1.00 27.16           N  
ATOM   1418  NH2 ARG   177     -63.083  52.797  50.721  1.00 28.53           N  
ATOM   1419  N   ARG   178     -59.753  60.892  46.881  1.00 19.58           N  
ATOM   1420  CA  ARG   178     -58.752  61.933  46.672  1.00 18.99           C  
ATOM   1421  C   ARG   178     -59.481  63.262  46.453  1.00 19.27           C  
ATOM   1422  O   ARG   178     -60.262  63.401  45.507  1.00 19.22           O  
ATOM   1423  CB  ARG   178     -57.854  61.598  45.474  1.00 18.29           C  
ATOM   1424  CG  ARG   178     -56.732  62.622  45.252  1.00 18.23           C  
ATOM   1425  CD  ARG   178     -55.537  62.053  44.469  1.00 16.89           C  
ATOM   1426  NE  ARG   178     -55.838  61.780  43.068  1.00 15.32           N  
ATOM   1427  CZ  ARG   178     -56.185  60.586  42.587  1.00 18.34           C  
ATOM   1428  NH1 ARG   178     -56.273  59.536  43.398  1.00 15.71           N  
ATOM   1429  NH2 ARG   178     -56.435  60.441  41.293  1.00 14.71           N  
ATOM   1430  N   MET   179     -59.250  64.218  47.350  1.00 19.23           N  
ATOM   1431  CA  MET   179     -59.907  65.529  47.271  1.00 19.68           C  
ATOM   1432  C   MET   179     -59.193  66.470  46.295  1.00 18.94           C  
ATOM   1433  O   MET   179     -58.004  66.757  46.449  1.00 17.91           O  
ATOM   1434  CB  MET   179     -59.973  66.171  48.666  1.00 20.18           C  
ATOM   1435  CG  MET   179     -60.581  65.272  49.749  1.00 22.77           C  
ATOM   1436  SD  MET   179     -62.447  64.761  49.429  1.00 33.41          SE  
ATOM   1437  CE  MET   179     -62.144  63.004  48.670  1.00 26.03           C  
ATOM   1438  N   GLY   180     -59.937  66.960  45.305  1.00 18.94           N  
ATOM   1439  CA  GLY   180     -59.355  67.833  44.294  1.00 17.90           C  
ATOM   1440  C   GLY   180     -58.971  69.246  44.710  1.00 18.13           C  
ATOM   1441  O   GLY   180     -59.691  69.892  45.470  1.00 17.18           O  
ATOM   1442  N   HIS   181     -57.825  69.710  44.205  1.00 18.74           N  
ATOM   1443  CA  HIS   181     -57.314  71.071  44.431  1.00 18.48           C  
ATOM   1444  C   HIS   181     -58.019  71.819  45.561  1.00 18.47           C  
ATOM   1445  O   HIS   181     -58.823  72.711  45.297  1.00 18.87           O  
ATOM   1446  CB  HIS   181     -57.461  71.873  43.131  1.00 19.21           C  
ATOM   1447  CG  HIS   181     -58.790  71.687  42.456  1.00 18.53           C  
ATOM   1448  ND1 HIS   181     -59.988  71.900  43.101  1.00 13.33           N  
ATOM   1449  CD2 HIS   181     -59.105  71.299  41.195  1.00 16.66           C  
ATOM   1450  CE1 HIS   181     -60.987  71.655  42.269  1.00 14.91           C  
ATOM   1451  NE2 HIS   181     -60.477  71.289  41.107  1.00 15.75           N  
ATOM   1452  N   ILE   182     -57.683  71.507  46.813  1.00 18.53           N  
ATOM   1453  CA  ILE   182     -58.377  72.115  47.948  1.00 19.78           C  
ATOM   1454  C   ILE   182     -58.154  73.586  48.284  1.00 19.78           C  
ATOM   1455  O   ILE   182     -58.519  74.030  49.369  1.00 21.85           O  
ATOM   1456  CB  ILE   182     -58.186  71.287  49.246  1.00 19.21           C  
ATOM   1457  CG1 ILE   182     -56.715  71.241  49.643  1.00 21.47           C  
ATOM   1458  CG2 ILE   182     -58.738  69.874  49.047  1.00 19.76           C  
ATOM   1459  CD1 ILE   182     -56.489  70.649  51.025  1.00 23.75           C  
ATOM   1460  N   SER   183     -57.576  74.348  47.365  1.00 19.67           N  
ATOM   1461  CA  SER   183     -57.404  75.774  47.598  1.00 19.02           C  
ATOM   1462  C   SER   183     -57.770  76.504  46.310  1.00 18.60           C  
ATOM   1463  O   SER   183     -57.144  77.502  45.939  1.00 18.29           O  
ATOM   1464  CB  SER   183     -55.968  76.095  48.006  1.00 19.03           C  
ATOM   1465  OG  SER   183     -55.065  75.781  46.965  1.00 20.37           O  
ATOM   1466  N   LEU   184     -58.798  75.988  45.644  1.00 18.07           N  
ATOM   1467  CA  LEU   184     -59.288  76.539  44.386  1.00 18.50           C  
ATOM   1468  C   LEU   184     -59.767  77.977  44.544  1.00 18.76           C  
ATOM   1469  O   LEU   184     -59.871  78.716  43.565  1.00 18.18           O  
ATOM   1470  CB  LEU   184     -60.423  75.675  43.837  1.00 18.89           C  
ATOM   1471  CG  LEU   184     -60.846  76.015  42.404  1.00 17.29           C  
ATOM   1472  CD1 LEU   184     -59.714  75.667  41.433  1.00 18.05           C  
ATOM   1473  CD2 LEU   184     -62.101  75.235  42.055  1.00 18.24           C  
ATOM   1474  N   CYS   185     -60.052  78.361  45.784  1.00 19.10           N  
ATOM   1475  CA  CYS   185     -60.483  79.719  46.100  1.00 19.71           C  
ATOM   1476  C   CYS   185     -59.365  80.736  45.819  1.00 19.68           C  
ATOM   1477  O   CYS   185     -59.591  81.944  45.876  1.00 20.43           O  
ATOM   1478  CB  CYS   185     -60.903  79.811  47.578  1.00 18.68           C  
ATOM   1479  SG  CYS   185     -59.631  79.310  48.794  1.00 22.42           S  
ATOM   1480  N   GLN   186     -58.166  80.249  45.506  1.00 19.05           N  
ATOM   1481  CA  GLN   186     -57.034  81.143  45.229  1.00 19.81           C  
ATOM   1482  C   GLN   186     -56.770  81.317  43.733  1.00 19.72           C  
ATOM   1483  O   GLN   186     -55.860  82.053  43.342  1.00 20.26           O  
ATOM   1484  CB  GLN   186     -55.751  80.606  45.882  1.00 19.43           C  
ATOM   1485  CG  GLN   186     -55.845  80.347  47.383  1.00 20.80           C  
ATOM   1486  CD  GLN   186     -56.214  81.586  48.174  1.00 23.84           C  
ATOM   1487  OE1 GLN   186     -55.560  82.627  48.067  1.00 25.99           O  
ATOM   1488  NE2 GLN   186     -57.262  81.480  48.980  1.00 22.53           N  
ATOM   1489  N   LYS   187     -57.561  80.652  42.896  1.00 19.16           N  
ATOM   1490  CA  LYS   187     -57.328  80.705  41.457  1.00 20.23           C  
ATOM   1491  C   LYS   187     -57.254  82.106  40.866  1.00 20.82           C  
ATOM   1492  O   LYS   187     -56.534  82.325  39.899  1.00 22.29           O  
ATOM   1493  CB  LYS   187     -58.374  79.881  40.699  1.00 20.30           C  
ATOM   1494  CG  LYS   187     -58.177  79.933  39.189  1.00 20.07           C  
ATOM   1495  CD  LYS   187     -59.134  79.025  38.455  1.00 21.45           C  
ATOM   1496  CE  LYS   187     -58.899  79.096  36.955  1.00 22.68           C  
ATOM   1497  NZ  LYS   187     -59.815  78.171  36.241  1.00 24.78           N  
ATOM   1498  N   PHE   188     -57.993  83.051  41.438  1.00 20.69           N  
ATOM   1499  CA  PHE   188     -57.981  84.423  40.943  1.00 20.86           C  
ATOM   1500  C   PHE   188     -57.431  85.399  41.983  1.00 20.75           C  
ATOM   1501  O   PHE   188     -57.790  86.579  41.997  1.00 20.48           O  
ATOM   1502  CB  PHE   188     -59.390  84.832  40.514  1.00 20.62           C  
ATOM   1503  CG  PHE   188     -59.970  83.945  39.455  1.00 21.60           C  
ATOM   1504  CD1 PHE   188     -59.338  83.807  38.216  1.00 22.38           C  
ATOM   1505  CD2 PHE   188     -61.127  83.210  39.707  1.00 21.94           C  
ATOM   1506  CE1 PHE   188     -59.849  82.943  37.241  1.00 22.97           C  
ATOM   1507  CE2 PHE   188     -61.650  82.344  38.744  1.00 19.81           C  
ATOM   1508  CZ  PHE   188     -61.010  82.209  37.507  1.00 20.16           C  
ATOM   1509  N   GLN   189     -56.553  84.885  42.840  1.00 21.08           N  
ATOM   1510  CA  GLN   189     -55.894  85.637  43.909  1.00 22.72           C  
ATOM   1511  C   GLN   189     -55.538  87.087  43.614  1.00 22.93           C  
ATOM   1512  O   GLN   189     -56.008  88.011  44.268  1.00 23.54           O  
ATOM   1513  CB  GLN   189     -54.572  84.965  44.279  1.00 22.39           C  
ATOM   1514  CG  GLN   189     -54.665  83.748  45.117  1.00 27.19           C  
ATOM   1515  CD  GLN   189     -53.300  83.291  45.553  1.00 21.36           C  
ATOM   1516  OE1 GLN   189     -52.360  83.225  44.748  1.00 27.55           O  
ATOM   1517  NE2 GLN   189     -53.171  82.984  46.827  1.00 28.48           N  
ATOM   1518  N   GLN   190     -54.618  87.241  42.669  1.00 24.26           N  
ATOM   1519  CA  GLN   190     -54.065  88.533  42.299  1.00 25.47           C  
ATOM   1520  C   GLN   190     -55.079  89.549  41.794  1.00 25.27           C  
ATOM   1521  O   GLN   190     -54.824  90.748  41.841  1.00 26.84           O  
ATOM   1522  CB  GLN   190     -52.943  88.332  41.269  1.00 25.43           C  
ATOM   1523  CG  GLN   190     -51.976  87.186  41.602  1.00 28.24           C  
ATOM   1524  CD  GLN   190     -51.143  87.423  42.864  1.00 34.11           C  
ATOM   1525  OE1 GLN   190     -51.251  88.463  43.518  1.00 34.26           O  
ATOM   1526  NE2 GLN   190     -50.303  86.450  43.204  1.00 32.51           N  
ATOM   1527  N   PHE   191     -56.227  89.085  41.311  1.00 25.07           N  
ATOM   1528  CA  PHE   191     -57.261  90.002  40.835  1.00 25.08           C  
ATOM   1529  C   PHE   191     -57.856  90.733  42.030  1.00 24.50           C  
ATOM   1530  O   PHE   191     -58.406  91.825  41.896  1.00 23.83           O  
ATOM   1531  CB  PHE   191     -58.362  89.246  40.087  1.00 25.26           C  
ATOM   1532  CG  PHE   191     -59.482  90.128  39.588  1.00 26.59           C  
ATOM   1533  CD1 PHE   191     -60.634  90.315  40.350  1.00 27.92           C  
ATOM   1534  CD2 PHE   191     -59.393  90.754  38.348  1.00 29.80           C  
ATOM   1535  CE1 PHE   191     -61.683  91.112  39.883  1.00 28.51           C  
ATOM   1536  CE2 PHE   191     -60.437  91.555  37.871  1.00 29.56           C  
ATOM   1537  CZ  PHE   191     -61.583  91.732  38.640  1.00 29.43           C  
ATOM   1538  N   PHE   192     -57.706  90.130  43.204  1.00 23.21           N  
ATOM   1539  CA  PHE   192     -58.216  90.713  44.431  1.00 23.54           C  
ATOM   1540  C   PHE   192     -57.082  91.263  45.288  1.00 24.04           C  
ATOM   1541  O   PHE   192     -57.297  91.664  46.430  1.00 24.06           O  
ATOM   1542  CB  PHE   192     -58.993  89.654  45.208  1.00 22.63           C  
ATOM   1543  CG  PHE   192     -60.186  89.135  44.470  1.00 21.28           C  
ATOM   1544  CD1 PHE   192     -61.390  89.831  44.502  1.00 19.49           C  
ATOM   1545  CD2 PHE   192     -60.092  87.985  43.688  1.00 19.66           C  
ATOM   1546  CE1 PHE   192     -62.485  89.398  43.768  1.00 18.49           C  
ATOM   1547  CE2 PHE   192     -61.183  87.541  42.947  1.00 19.26           C  
ATOM   1548  CZ  PHE   192     -62.384  88.253  42.988  1.00 20.11           C  
ATOM   1549  N   GLY   193     -55.874  91.284  44.728  1.00 24.59           N  
ATOM   1550  CA  GLY   193     -54.721  91.777  45.466  1.00 24.95           C  
ATOM   1551  C   GLY   193     -54.394  90.857  46.627  1.00 25.53           C  
ATOM   1552  O   GLY   193     -53.921  91.294  47.679  1.00 26.00           O  
ATOM   1553  N   GLU   194     -54.651  89.571  46.423  1.00 25.41           N  
ATOM   1554  CA  GLU   194     -54.406  88.555  47.438  1.00 25.11           C  
ATOM   1555  C   GLU   194     -53.384  87.536  46.955  1.00 24.97           C  
ATOM   1556  O   GLU   194     -53.160  87.389  45.754  1.00 25.19           O  
ATOM   1557  CB  GLU   194     -55.709  87.813  47.761  1.00 25.06           C  
ATOM   1558  CG  GLU   194     -56.783  88.656  48.411  1.00 26.33           C  
ATOM   1559  CD  GLU   194     -56.487  88.935  49.862  1.00 30.27           C  
ATOM   1560  OE1 GLU   194     -55.560  88.297  50.406  1.00 32.44           O  
ATOM   1561  OE2 GLU   194     -57.185  89.782  50.465  1.00 32.13           O  
ATOM   1562  N   ASP   195     -52.771  86.842  47.909  1.00 25.01           N  
ATOM   1563  CA  ASP   195     -51.814  85.777  47.637  1.00 24.96           C  
ATOM   1564  C   ASP   195     -51.793  84.850  48.856  1.00 25.02           C  
ATOM   1565  O   ASP   195     -52.448  85.126  49.857  1.00 25.06           O  
ATOM   1566  CB  ASP   195     -50.414  86.331  47.313  1.00 24.26           C  
ATOM   1567  CG  ASP   195     -49.850  87.220  48.404  1.00 25.57           C  
ATOM   1568  OD1 ASP   195     -49.888  86.819  49.586  1.00 23.91           O  
ATOM   1569  OD2 ASP   195     -49.336  88.311  48.066  1.00 21.69           O  
ATOM   1570  N   THR   196     -51.060  83.748  48.774  1.00 26.11           N  
ATOM   1571  CA  THR   196     -51.037  82.800  49.882  1.00 26.84           C  
ATOM   1572  C   THR   196     -50.089  83.155  51.023  1.00 27.33           C  
ATOM   1573  O   THR   196     -49.923  82.376  51.964  1.00 27.48           O  
ATOM   1574  CB  THR   196     -50.706  81.377  49.388  1.00 27.38           C  
ATOM   1575  OG1 THR   196     -49.396  81.357  48.803  1.00 28.27           O  
ATOM   1576  CG2 THR   196     -51.732  80.926  48.354  1.00 28.05           C  
ATOM   1577  N   SER   197     -49.479  84.333  50.964  1.00 26.37           N  
ATOM   1578  CA  SER   197     -48.552  84.723  52.016  1.00 26.63           C  
ATOM   1579  C   SER   197     -49.248  85.196  53.289  1.00 27.08           C  
ATOM   1580  O   SER   197     -48.611  85.331  54.331  1.00 27.09           O  
ATOM   1581  CB  SER   197     -47.631  85.839  51.530  1.00 26.13           C  
ATOM   1582  OG  SER   197     -48.305  87.084  51.550  1.00 22.74           O  
ATOM   1583  N   ASP   198     -50.549  85.456  53.227  1.00 28.08           N  
ATOM   1584  CA  ASP   198     -51.222  85.961  54.418  1.00 29.15           C  
ATOM   1585  C   ASP   198     -52.573  85.339  54.771  1.00 28.37           C  
ATOM   1586  O   ASP   198     -53.530  86.052  55.082  1.00 28.41           O  
ATOM   1587  CB  ASP   198     -51.374  87.485  54.321  1.00 30.12           C  
ATOM   1588  CG  ASP   198     -52.460  87.892  53.353  1.00 32.03           C  
ATOM   1589  OD1 ASP   198     -52.635  87.178  52.340  1.00 34.63           O  
ATOM   1590  OD2 ASP   198     -53.145  88.916  53.602  1.00 34.28           O  
ATOM   1591  N   PHE   199     -52.654  84.014  54.761  1.00 27.28           N  
ATOM   1592  CA  PHE   199     -53.901  83.373  55.159  1.00 27.07           C  
ATOM   1593  C   PHE   199     -54.188  83.788  56.599  1.00 25.85           C  
ATOM   1594  O   PHE   199     -53.313  83.698  57.455  1.00 26.34           O  
ATOM   1595  CB  PHE   199     -53.791  81.845  55.085  1.00 27.44           C  
ATOM   1596  CG  PHE   199     -53.843  81.289  53.680  1.00 29.45           C  
ATOM   1597  CD1 PHE   199     -54.282  82.071  52.611  1.00 31.29           C  
ATOM   1598  CD2 PHE   199     -53.481  79.967  53.432  1.00 32.61           C  
ATOM   1599  CE1 PHE   199     -54.360  81.546  51.322  1.00 31.73           C  
ATOM   1600  CE2 PHE   199     -53.556  79.433  52.144  1.00 31.77           C  
ATOM   1601  CZ  PHE   199     -53.996  80.224  51.090  1.00 30.09           C  
ATOM   1602  N   SER   200     -55.403  84.260  56.858  1.00 24.88           N  
ATOM   1603  CA  SER   200     -55.771  84.676  58.203  1.00 24.87           C  
ATOM   1604  C   SER   200     -55.787  83.474  59.144  1.00 25.00           C  
ATOM   1605  O   SER   200     -55.800  82.317  58.703  1.00 22.67           O  
ATOM   1606  CB  SER   200     -57.152  85.324  58.197  1.00 25.38           C  
ATOM   1607  OG  SER   200     -58.140  84.349  57.929  1.00 27.25           O  
ATOM   1608  N   GLU   201     -55.789  83.761  60.443  1.00 24.64           N  
ATOM   1609  CA  GLU   201     -55.803  82.726  61.467  1.00 25.20           C  
ATOM   1610  C   GLU   201     -57.045  81.844  61.385  1.00 24.96           C  
ATOM   1611  O   GLU   201     -56.976  80.647  61.659  1.00 24.63           O  
ATOM   1612  CB  GLU   201     -55.706  83.354  62.857  1.00 26.41           C  
ATOM   1613  CG  GLU   201     -55.891  82.371  64.002  1.00 30.28           C  
ATOM   1614  CD  GLU   201     -54.908  81.211  63.955  1.00 34.89           C  
ATOM   1615  OE1 GLU   201     -53.839  81.352  63.312  1.00 36.08           O  
ATOM   1616  OE2 GLU   201     -55.201  80.162  64.576  1.00 37.09           O  
ATOM   1617  N   GLU   202     -58.179  82.424  61.014  1.00 25.02           N  
ATOM   1618  CA  GLU   202     -59.399  81.638  60.882  1.00 26.00           C  
ATOM   1619  C   GLU   202     -59.262  80.679  59.702  1.00 25.23           C  
ATOM   1620  O   GLU   202     -59.575  79.490  59.812  1.00 24.58           O  
ATOM   1621  CB  GLU   202     -60.616  82.540  60.670  1.00 26.76           C  
ATOM   1622  CG  GLU   202     -61.947  81.802  60.845  1.00 31.62           C  
ATOM   1623  CD  GLU   202     -63.147  82.733  60.858  1.00 36.65           C  
ATOM   1624  OE1 GLU   202     -62.959  83.941  61.118  1.00 39.84           O  
ATOM   1625  OE2 GLU   202     -64.281  82.254  60.626  1.00 38.66           O  
ATOM   1626  N   VAL   203     -58.782  81.193  58.574  1.00 24.54           N  
ATOM   1627  CA  VAL   203     -58.607  80.352  57.398  1.00 23.71           C  
ATOM   1628  C   VAL   203     -57.673  79.191  57.733  1.00 24.39           C  
ATOM   1629  O   VAL   203     -57.952  78.035  57.388  1.00 24.34           O  
ATOM   1630  CB  VAL   203     -58.042  81.164  56.205  1.00 23.57           C  
ATOM   1631  CG1 VAL   203     -57.487  80.228  55.142  1.00 20.74           C  
ATOM   1632  CG2 VAL   203     -59.144  82.031  55.609  1.00 21.42           C  
ATOM   1633  N   MET   204     -56.578  79.493  58.426  1.00 24.59           N  
ATOM   1634  CA  MET   204     -55.618  78.461  58.801  1.00 25.56           C  
ATOM   1635  C   MET   204     -56.222  77.397  59.712  1.00 25.50           C  
ATOM   1636  O   MET   204     -55.895  76.215  59.584  1.00 24.69           O  
ATOM   1637  CB  MET   204     -54.389  79.071  59.481  1.00 26.14           C  
ATOM   1638  CG  MET   204     -53.432  79.765  58.520  1.00 31.03           C  
ATOM   1639  SD  MET   204     -52.892  78.626  57.030  1.00 46.56          SE  
ATOM   1640  CE  MET   204     -52.341  77.066  58.046  1.00 38.18           C  
ATOM   1641  N   GLU   205     -57.085  77.808  60.637  1.00 25.27           N  
ATOM   1642  CA  GLU   205     -57.720  76.849  61.537  1.00 26.30           C  
ATOM   1643  C   GLU   205     -58.642  75.926  60.740  1.00 25.70           C  
ATOM   1644  O   GLU   205     -58.709  74.725  61.010  1.00 26.31           O  
ATOM   1645  CB  GLU   205     -58.505  77.570  62.636  1.00 26.47           C  
ATOM   1646  CG  GLU   205     -59.182  76.647  63.657  1.00 31.65           C  
ATOM   1647  CD  GLU   205     -58.244  75.588  64.249  1.00 34.99           C  
ATOM   1648  OE1 GLU   205     -57.066  75.900  64.546  1.00 37.55           O  
ATOM   1649  OE2 GLU   205     -58.694  74.435  64.435  1.00 38.25           O  
ATOM   1650  N   LYS   206     -59.344  76.477  59.749  1.00 25.61           N  
ATOM   1651  CA  LYS   206     -60.217  75.650  58.922  1.00 24.54           C  
ATOM   1652  C   LYS   206     -59.410  74.626  58.142  1.00 23.59           C  
ATOM   1653  O   LYS   206     -59.844  73.482  57.969  1.00 23.04           O  
ATOM   1654  CB  LYS   206     -61.039  76.492  57.955  1.00 25.22           C  
ATOM   1655  CG  LYS   206     -62.285  77.073  58.587  1.00 30.34           C  
ATOM   1656  CD  LYS   206     -63.413  77.131  57.570  1.00 35.46           C  
ATOM   1657  CE  LYS   206     -64.660  77.757  58.177  1.00 38.00           C  
ATOM   1658  NZ  LYS   206     -65.638  78.179  57.127  1.00 34.21           N  
ATOM   1659  N   PHE   207     -58.230  75.030  57.681  1.00 22.94           N  
ATOM   1660  CA  PHE   207     -57.375  74.106  56.958  1.00 22.03           C  
ATOM   1661  C   PHE   207     -56.934  72.977  57.894  1.00 21.97           C  
ATOM   1662  O   PHE   207     -56.915  71.811  57.497  1.00 20.82           O  
ATOM   1663  CB  PHE   207     -56.152  74.831  56.384  1.00 21.63           C  
ATOM   1664  CG  PHE   207     -56.340  75.320  54.966  1.00 20.13           C  
ATOM   1665  CD1 PHE   207     -56.613  74.420  53.937  1.00 20.43           C  
ATOM   1666  CD2 PHE   207     -56.232  76.676  54.658  1.00 19.45           C  
ATOM   1667  CE1 PHE   207     -56.776  74.855  52.620  1.00 19.46           C  
ATOM   1668  CE2 PHE   207     -56.392  77.122  53.352  1.00 16.49           C  
ATOM   1669  CZ  PHE   207     -56.665  76.208  52.328  1.00 17.44           C  
ATOM   1670  N   ARG   208     -56.587  73.321  59.134  1.00 22.11           N  
ATOM   1671  CA  ARG   208     -56.159  72.311  60.103  1.00 22.54           C  
ATOM   1672  C   ARG   208     -57.316  71.345  60.383  1.00 22.47           C  
ATOM   1673  O   ARG   208     -57.131  70.131  60.401  1.00 22.71           O  
ATOM   1674  CB  ARG   208     -55.674  72.968  61.409  1.00 23.04           C  
ATOM   1675  CG  ARG   208     -54.310  73.659  61.297  1.00 24.18           C  
ATOM   1676  CD  ARG   208     -53.725  74.029  62.666  1.00 28.61           C  
ATOM   1677  NE  ARG   208     -54.493  75.077  63.332  1.00 31.20           N  
ATOM   1678  CZ  ARG   208     -54.291  76.383  63.166  1.00 30.93           C  
ATOM   1679  NH1 ARG   208     -53.333  76.813  62.356  1.00 30.08           N  
ATOM   1680  NH2 ARG   208     -55.055  77.260  63.803  1.00 28.32           N  
ATOM   1681  N   VAL   209     -58.514  71.883  60.580  1.00 22.19           N  
ATOM   1682  CA  VAL   209     -59.670  71.027  60.816  1.00 22.59           C  
ATOM   1683  C   VAL   209     -59.876  70.101  59.617  1.00 22.02           C  
ATOM   1684  O   VAL   209     -60.098  68.898  59.785  1.00 21.17           O  
ATOM   1685  CB  VAL   209     -60.953  71.861  61.049  1.00 22.76           C  
ATOM   1686  CG1 VAL   209     -62.184  70.961  61.022  1.00 24.17           C  
ATOM   1687  CG2 VAL   209     -60.863  72.571  62.394  1.00 25.28           C  
ATOM   1688  N   ILE   210     -59.786  70.665  58.412  1.00 21.54           N  
ATOM   1689  CA  ILE   210     -59.962  69.902  57.178  1.00 21.59           C  
ATOM   1690  C   ILE   210     -58.930  68.784  57.042  1.00 22.30           C  
ATOM   1691  O   ILE   210     -59.279  67.643  56.730  1.00 23.40           O  
ATOM   1692  CB  ILE   210     -59.882  70.830  55.925  1.00 21.91           C  
ATOM   1693  CG1 ILE   210     -61.206  71.583  55.746  1.00 21.14           C  
ATOM   1694  CG2 ILE   210     -59.546  70.019  54.677  1.00 20.66           C  
ATOM   1695  CD1 ILE   210     -61.217  72.553  54.579  1.00 20.72           C  
ATOM   1696  N   LEU   211     -57.662  69.103  57.289  1.00 22.07           N  
ATOM   1697  CA  LEU   211     -56.598  68.111  57.170  1.00 22.12           C  
ATOM   1698  C   LEU   211     -56.729  66.970  58.182  1.00 22.65           C  
ATOM   1699  O   LEU   211     -56.560  65.798  57.830  1.00 21.72           O  
ATOM   1700  CB  LEU   211     -55.226  68.775  57.323  1.00 21.80           C  
ATOM   1701  CG  LEU   211     -54.850  69.749  56.202  1.00 22.41           C  
ATOM   1702  CD1 LEU   211     -53.482  70.357  56.476  1.00 22.27           C  
ATOM   1703  CD2 LEU   211     -54.855  69.008  54.862  1.00 22.27           C  
ATOM   1704  N   ALA   212     -57.022  67.311  59.434  1.00 22.42           N  
ATOM   1705  CA  ALA   212     -57.164  66.303  60.484  1.00 23.15           C  
ATOM   1706  C   ALA   212     -58.235  65.314  60.049  1.00 23.63           C  
ATOM   1707  O   ALA   212     -58.110  64.102  60.230  1.00 23.26           O  
ATOM   1708  CB  ALA   212     -57.562  66.965  61.805  1.00 24.04           C  
ATOM   1709  N   LEU   213     -59.280  65.852  59.441  1.00 23.54           N  
ATOM   1710  CA  LEU   213     -60.398  65.052  58.981  1.00 24.72           C  
ATOM   1711  C   LEU   213     -60.005  64.155  57.801  1.00 24.04           C  
ATOM   1712  O   LEU   213     -60.413  62.995  57.725  1.00 23.91           O  
ATOM   1713  CB  LEU   213     -61.540  65.981  58.595  1.00 25.51           C  
ATOM   1714  CG  LEU   213     -62.887  65.307  58.407  1.00 29.51           C  
ATOM   1715  CD1 LEU   213     -63.248  64.490  59.652  1.00 30.61           C  
ATOM   1716  CD2 LEU   213     -63.921  66.384  58.149  1.00 31.56           C  
ATOM   1717  N   VAL   214     -59.211  64.692  56.882  1.00 23.07           N  
ATOM   1718  CA  VAL   214     -58.750  63.909  55.742  1.00 22.18           C  
ATOM   1719  C   VAL   214     -57.977  62.700  56.262  1.00 22.72           C  
ATOM   1720  O   VAL   214     -58.147  61.587  55.768  1.00 22.24           O  
ATOM   1721  CB  VAL   214     -57.816  64.732  54.815  1.00 21.89           C  
ATOM   1722  CG1 VAL   214     -57.112  63.816  53.823  1.00 20.52           C  
ATOM   1723  CG2 VAL   214     -58.624  65.782  54.073  1.00 20.66           C  
ATOM   1724  N   LYS   215     -57.130  62.923  57.262  1.00 22.65           N  
ATOM   1725  CA  LYS   215     -56.347  61.838  57.844  1.00 24.25           C  
ATOM   1726  C   LYS   215     -57.269  60.794  58.476  1.00 24.02           C  
ATOM   1727  O   LYS   215     -57.173  59.603  58.182  1.00 24.20           O  
ATOM   1728  CB  LYS   215     -55.381  62.389  58.901  1.00 24.40           C  
ATOM   1729  CG  LYS   215     -54.498  61.330  59.546  1.00 28.12           C  
ATOM   1730  CD  LYS   215     -53.697  60.565  58.503  1.00 32.25           C  
ATOM   1731  CE  LYS   215     -52.795  59.528  59.158  1.00 35.80           C  
ATOM   1732  NZ  LYS   215     -52.008  58.753  58.157  1.00 39.25           N  
ATOM   1733  N   LYS   216     -58.165  61.249  59.340  1.00 23.72           N  
ATOM   1734  CA  LYS   216     -59.104  60.352  60.003  1.00 24.77           C  
ATOM   1735  C   LYS   216     -59.871  59.489  58.997  1.00 24.01           C  
ATOM   1736  O   LYS   216     -60.115  58.303  59.237  1.00 24.05           O  
ATOM   1737  CB  LYS   216     -60.093  61.157  60.841  1.00 24.80           C  
ATOM   1738  CG  LYS   216     -60.989  60.294  61.707  1.00 29.99           C  
ATOM   1739  CD  LYS   216     -62.012  61.134  62.444  1.00 34.90           C  
ATOM   1740  CE  LYS   216     -62.511  60.413  63.684  1.00 39.09           C  
ATOM   1741  NZ  LYS   216     -62.910  59.007  63.380  1.00 41.91           N  
ATOM   1742  N   ARG   217     -60.239  60.097  57.873  1.00 24.19           N  
ATOM   1743  CA  ARG   217     -60.979  59.415  56.808  1.00 24.05           C  
ATOM   1744  C   ARG   217     -60.057  58.544  55.958  1.00 23.85           C  
ATOM   1745  O   ARG   217     -60.520  57.754  55.134  1.00 23.49           O  
ATOM   1746  CB  ARG   217     -61.646  60.450  55.897  1.00 24.91           C  
ATOM   1747  CG  ARG   217     -62.977  60.982  56.385  1.00 26.40           C  
ATOM   1748  CD  ARG   217     -64.061  59.969  56.112  1.00 30.25           C  
ATOM   1749  NE  ARG   217     -65.284  60.623  55.686  1.00 34.04           N  
ATOM   1750  CZ  ARG   217     -66.351  59.987  55.220  1.00 33.25           C  
ATOM   1751  NH1 ARG   217     -66.351  58.660  55.125  1.00 32.68           N  
ATOM   1752  NH2 ARG   217     -67.407  60.684  54.826  1.00 32.08           N  
ATOM   1753  N   ASP   218     -58.754  58.719  56.144  1.00 23.80           N  
ATOM   1754  CA  ASP   218     -57.749  57.985  55.393  1.00 24.33           C  
ATOM   1755  C   ASP   218     -57.829  58.334  53.910  1.00 24.08           C  
ATOM   1756  O   ASP   218     -57.623  57.480  53.043  1.00 24.54           O  
ATOM   1757  CB  ASP   218     -57.920  56.476  55.596  1.00 25.74           C  
ATOM   1758  CG  ASP   218     -56.690  55.692  55.183  1.00 29.11           C  
ATOM   1759  OD1 ASP   218     -55.566  56.129  55.519  1.00 31.99           O  
ATOM   1760  OD2 ASP   218     -56.843  54.637  54.532  1.00 31.70           O  
ATOM   1761  N   TYR   219     -58.144  59.596  53.631  1.00 22.44           N  
ATOM   1762  CA  TYR   219     -58.227  60.082  52.258  1.00 21.69           C  
ATOM   1763  C   TYR   219     -56.849  60.592  51.833  1.00 22.19           C  
ATOM   1764  O   TYR   219     -55.892  60.536  52.604  1.00 21.77           O  
ATOM   1765  CB  TYR   219     -59.240  61.228  52.148  1.00 21.00           C  
ATOM   1766  CG  TYR   219     -60.712  60.845  52.247  1.00 21.11           C  
ATOM   1767  CD1 TYR   219     -61.130  59.512  52.168  1.00 22.20           C  
ATOM   1768  CD2 TYR   219     -61.694  61.835  52.355  1.00 19.86           C  
ATOM   1769  CE1 TYR   219     -62.497  59.180  52.188  1.00 21.59           C  
ATOM   1770  CE2 TYR   219     -63.053  61.517  52.373  1.00 21.74           C  
ATOM   1771  CZ  TYR   219     -63.450  60.190  52.289  1.00 22.59           C  
ATOM   1772  OH  TYR   219     -64.795  59.881  52.301  1.00 18.59           O  
ATOM   1773  N   GLU   220     -56.752  61.087  50.605  1.00 21.76           N  
ATOM   1774  CA  GLU   220     -55.498  61.642  50.107  1.00 21.61           C  
ATOM   1775  C   GLU   220     -55.814  62.941  49.376  1.00 21.14           C  
ATOM   1776  O   GLU   220     -56.982  63.256  49.139  1.00 20.78           O  
ATOM   1777  CB  GLU   220     -54.787  60.645  49.180  1.00 21.38           C  
ATOM   1778  CG  GLU   220     -55.634  60.124  48.033  1.00 23.49           C  
ATOM   1779  CD  GLU   220     -54.891  59.131  47.145  1.00 27.62           C  
ATOM   1780  OE1 GLU   220     -53.851  58.590  47.585  1.00 27.40           O  
ATOM   1781  OE2 GLU   220     -55.361  58.882  46.011  1.00 27.48           O  
ATOM   1782  N   LEU   221     -54.783  63.693  49.020  1.00 20.38           N  
ATOM   1783  CA  LEU   221     -55.006  64.959  48.351  1.00 21.10           C  
ATOM   1784  C   LEU   221     -54.409  65.068  46.964  1.00 20.43           C  
ATOM   1785  O   LEU   221     -53.356  64.506  46.659  1.00 20.14           O  
ATOM   1786  CB  LEU   221     -54.490  66.109  49.219  1.00 21.13           C  
ATOM   1787  CG  LEU   221     -55.172  66.222  50.578  1.00 22.29           C  
ATOM   1788  CD1 LEU   221     -54.452  67.248  51.426  1.00 23.28           C  
ATOM   1789  CD2 LEU   221     -56.639  66.596  50.389  1.00 20.96           C  
ATOM   1790  N   ASP   222     -55.126  65.806  46.128  1.00 20.24           N  
ATOM   1791  CA  ASP   222     -54.733  66.099  44.752  1.00 20.81           C  
ATOM   1792  C   ASP   222     -53.737  67.269  44.808  1.00 21.62           C  
ATOM   1793  O   ASP   222     -54.117  68.371  45.195  1.00 22.22           O  
ATOM   1794  CB  ASP   222     -56.013  66.468  43.980  1.00 21.19           C  
ATOM   1795  CG  ASP   222     -55.763  67.061  42.597  1.00 21.64           C  
ATOM   1796  OD1 ASP   222     -54.950  66.512  41.826  1.00 21.76           O  
ATOM   1797  OD2 ASP   222     -56.445  68.062  42.260  1.00 22.49           O  
ATOM   1798  N   PHE   223     -52.459  67.003  44.527  1.00 21.45           N  
ATOM   1799  CA  PHE   223     -51.443  68.065  44.505  1.00 21.27           C  
ATOM   1800  C   PHE   223     -51.492  68.591  43.084  1.00 21.24           C  
ATOM   1801  O   PHE   223     -50.809  68.096  42.183  1.00 20.61           O  
ATOM   1802  CB  PHE   223     -50.047  67.521  44.828  1.00 22.39           C  
ATOM   1803  CG  PHE   223     -48.992  68.592  44.954  1.00 23.87           C  
ATOM   1804  CD1 PHE   223     -48.524  69.265  43.826  1.00 26.70           C  
ATOM   1805  CD2 PHE   223     -48.478  68.938  46.203  1.00 26.98           C  
ATOM   1806  CE1 PHE   223     -47.557  70.271  43.938  1.00 29.01           C  
ATOM   1807  CE2 PHE   223     -47.514  69.940  46.330  1.00 27.73           C  
ATOM   1808  CZ  PHE   223     -47.051  70.610  45.198  1.00 28.14           C  
ATOM   1809  N   ASN   224     -52.345  69.591  42.903  1.00 20.33           N  
ATOM   1810  CA  ASN   224     -52.643  70.164  41.600  1.00 19.73           C  
ATOM   1811  C   ASN   224     -51.756  71.349  41.201  1.00 19.92           C  
ATOM   1812  O   ASN   224     -51.751  72.387  41.862  1.00 18.07           O  
ATOM   1813  CB  ASN   224     -54.122  70.558  41.615  1.00 19.45           C  
ATOM   1814  CG  ASN   224     -54.700  70.741  40.236  1.00 20.81           C  
ATOM   1815  OD1 ASN   224     -54.194  71.533  39.437  1.00 19.97           O  
ATOM   1816  ND2 ASN   224     -55.789  70.026  39.955  1.00 19.33           N  
ATOM   1817  N   THR   225     -51.036  71.194  40.091  1.00 20.34           N  
ATOM   1818  CA  THR   225     -50.114  72.224  39.614  1.00 21.62           C  
ATOM   1819  C   THR   225     -50.727  73.183  38.603  1.00 22.74           C  
ATOM   1820  O   THR   225     -50.055  74.095  38.126  1.00 23.86           O  
ATOM   1821  CB  THR   225     -48.868  71.602  38.958  1.00 21.51           C  
ATOM   1822  OG1 THR   225     -49.272  70.792  37.845  1.00 22.41           O  
ATOM   1823  CG2 THR   225     -48.093  70.747  39.967  1.00 19.13           C  
ATOM   1824  N   ALA   226     -51.997  72.973  38.270  1.00 23.30           N  
ATOM   1825  CA  ALA   226     -52.680  73.824  37.304  1.00 24.84           C  
ATOM   1826  C   ALA   226     -52.547  75.299  37.681  1.00 25.93           C  
ATOM   1827  O   ALA   226     -52.394  76.153  36.814  1.00 26.60           O  
ATOM   1828  CB  ALA   226     -54.158  73.438  37.210  1.00 24.21           C  
ATOM   1829  N   GLY   227     -52.593  75.579  38.979  1.00 27.07           N  
ATOM   1830  CA  GLY   227     -52.508  76.949  39.456  1.00 29.50           C  
ATOM   1831  C   GLY   227     -51.253  77.704  39.057  1.00 31.07           C  
ATOM   1832  O   GLY   227     -51.273  78.931  38.939  1.00 30.97           O  
ATOM   1833  N   LEU   228     -50.159  76.973  38.857  1.00 32.38           N  
ATOM   1834  CA  LEU   228     -48.888  77.576  38.472  1.00 33.13           C  
ATOM   1835  C   LEU   228     -48.959  78.155  37.069  1.00 34.89           C  
ATOM   1836  O   LEU   228     -48.125  78.980  36.683  1.00 34.29           O  
ATOM   1837  CB  LEU   228     -47.765  76.533  38.525  1.00 33.24           C  
ATOM   1838  CG  LEU   228     -47.462  75.877  39.874  1.00 31.46           C  
ATOM   1839  CD1 LEU   228     -46.370  74.819  39.716  1.00 31.49           C  
ATOM   1840  CD2 LEU   228     -47.039  76.945  40.868  1.00 29.58           C  
ATOM   1841  N   PHE   229     -49.961  77.722  36.310  1.00 35.05           N  
ATOM   1842  CA  PHE   229     -50.108  78.177  34.938  1.00 35.75           C  
ATOM   1843  C   PHE   229     -51.379  78.974  34.643  1.00 36.57           C  
ATOM   1844  O   PHE   229     -51.739  79.168  33.477  1.00 36.56           O  
ATOM   1845  CB  PHE   229     -49.978  76.976  33.995  1.00 36.05           C  
ATOM   1846  CG  PHE   229     -48.693  76.218  34.177  1.00 34.58           C  
ATOM   1847  CD1 PHE   229     -48.548  75.311  35.220  1.00 33.70           C  
ATOM   1848  CD2 PHE   229     -47.601  76.461  33.348  1.00 35.69           C  
ATOM   1849  CE1 PHE   229     -47.335  74.657  35.437  1.00 31.17           C  
ATOM   1850  CE2 PHE   229     -46.383  75.812  33.557  1.00 34.46           C  
ATOM   1851  CZ  PHE   229     -46.251  74.911  34.604  1.00 33.45           C  
ATOM   1852  N   LYS   230     -52.062  79.426  35.697  1.00 36.86           N  
ATOM   1853  CA  LYS   230     -53.251  80.262  35.519  1.00 38.00           C  
ATOM   1854  C   LYS   230     -52.792  81.711  35.718  1.00 38.25           C  
ATOM   1855  O   LYS   230     -52.086  82.019  36.678  1.00 38.66           O  
ATOM   1856  CB  LYS   230     -54.351  79.944  36.541  1.00 37.58           C  
ATOM   1857  CG  LYS   230     -54.292  78.573  37.206  1.00 39.96           C  
ATOM   1858  CD  LYS   230     -54.785  77.409  36.339  1.00 41.77           C  
ATOM   1859  CE  LYS   230     -55.577  77.814  35.100  1.00 43.38           C  
ATOM   1860  NZ  LYS   230     -56.162  76.592  34.451  1.00 44.09           N  
ATOM   1861  N   PRO   231     -53.193  82.618  34.814  1.00 38.70           N  
ATOM   1862  CA  PRO   231     -52.840  84.043  34.857  1.00 38.71           C  
ATOM   1863  C   PRO   231     -52.992  84.784  36.199  1.00 38.29           C  
ATOM   1864  O   PRO   231     -52.076  85.488  36.624  1.00 38.99           O  
ATOM   1865  CB  PRO   231     -53.721  84.651  33.756  1.00 38.52           C  
ATOM   1866  CG  PRO   231     -54.865  83.660  33.624  1.00 39.34           C  
ATOM   1867  CD  PRO   231     -54.134  82.354  33.713  1.00 38.90           C  
ATOM   1868  N   LEU   232     -54.132  84.633  36.868  1.00 36.93           N  
ATOM   1869  CA  LEU   232     -54.357  85.337  38.134  1.00 36.03           C  
ATOM   1870  C   LEU   232     -54.118  84.517  39.406  1.00 35.17           C  
ATOM   1871  O   LEU   232     -54.422  84.966  40.515  1.00 34.40           O  
ATOM   1872  CB  LEU   232     -55.767  85.941  38.144  1.00 36.11           C  
ATOM   1873  CG  LEU   232     -55.953  86.949  36.998  1.00 36.52           C  
ATOM   1874  CD1 LEU   232     -57.423  87.151  36.656  1.00 37.03           C  
ATOM   1875  CD2 LEU   232     -55.290  88.269  37.381  1.00 38.18           C  
ATOM   1876  N   CYS   233     -53.553  83.324  39.245  1.00 34.69           N  
ATOM   1877  CA  CYS   233     -53.263  82.463  40.388  1.00 33.90           C  
ATOM   1878  C   CYS   233     -51.761  82.486  40.686  1.00 33.78           C  
ATOM   1879  O   CYS   233     -51.279  83.351  41.420  1.00 33.56           O  
ATOM   1880  CB  CYS   233     -53.722  81.028  40.112  1.00 33.35           C  
ATOM   1881  SG  CYS   233     -53.537  79.908  41.523  1.00 33.12           S  
ATOM   1882  N   GLY   234     -51.025  81.537  40.111  1.00 33.14           N  
ATOM   1883  CA  GLY   234     -49.585  81.487  40.314  1.00 33.21           C  
ATOM   1884  C   GLY   234     -49.115  80.603  41.456  1.00 32.97           C  
ATOM   1885  O   GLY   234     -47.952  80.678  41.861  1.00 33.41           O  
ATOM   1886  N   GLU   235     -50.010  79.759  41.967  1.00 31.99           N  
ATOM   1887  CA  GLU   235     -49.691  78.862  43.074  1.00 30.38           C  
ATOM   1888  C   GLU   235     -50.223  77.439  42.855  1.00 28.02           C  
ATOM   1889  O   GLU   235     -51.163  77.225  42.088  1.00 27.61           O  
ATOM   1890  CB  GLU   235     -50.297  79.417  44.366  1.00 31.32           C  
ATOM   1891  CG  GLU   235     -49.298  80.005  45.331  1.00 36.82           C  
ATOM   1892  CD  GLU   235     -48.409  78.953  45.957  1.00 41.96           C  
ATOM   1893  OE1 GLU   235     -48.134  79.072  47.168  1.00 45.93           O  
ATOM   1894  OE2 GLU   235     -47.979  78.017  45.244  1.00 41.07           O  
ATOM   1895  N   THR   236     -49.623  76.468  43.537  1.00 24.90           N  
ATOM   1896  CA  THR   236     -50.097  75.087  43.450  1.00 23.28           C  
ATOM   1897  C   THR   236     -51.272  74.947  44.417  1.00 21.76           C  
ATOM   1898  O   THR   236     -51.372  75.705  45.380  1.00 20.06           O  
ATOM   1899  CB  THR   236     -49.024  74.075  43.889  1.00 22.14           C  
ATOM   1900  OG1 THR   236     -48.562  74.420  45.197  1.00 23.56           O  
ATOM   1901  CG2 THR   236     -47.851  74.064  42.926  1.00 23.26           C  
ATOM   1902  N   TYR   237     -52.158  73.988  44.159  1.00 20.89           N  
ATOM   1903  CA  TYR   237     -53.300  73.735  45.045  1.00 21.30           C  
ATOM   1904  C   TYR   237     -52.998  72.433  45.789  1.00 21.37           C  
ATOM   1905  O   TYR   237     -53.048  71.353  45.193  1.00 21.23           O  
ATOM   1906  CB  TYR   237     -54.598  73.554  44.250  1.00 20.79           C  
ATOM   1907  CG  TYR   237     -54.925  74.633  43.236  1.00 21.45           C  
ATOM   1908  CD1 TYR   237     -55.301  75.918  43.636  1.00 21.66           C  
ATOM   1909  CD2 TYR   237     -54.928  74.345  41.871  1.00 22.71           C  
ATOM   1910  CE1 TYR   237     -55.686  76.880  42.699  1.00 20.80           C  
ATOM   1911  CE2 TYR   237     -55.312  75.292  40.932  1.00 21.34           C  
ATOM   1912  CZ  TYR   237     -55.690  76.554  41.348  1.00 23.92           C  
ATOM   1913  OH  TYR   237     -56.114  77.473  40.411  1.00 27.19           O  
ATOM   1914  N   PRO   238     -52.711  72.511  47.097  1.00 21.21           N  
ATOM   1915  CA  PRO   238     -52.622  73.714  47.932  1.00 20.83           C  
ATOM   1916  C   PRO   238     -51.195  74.258  47.987  1.00 21.01           C  
ATOM   1917  O   PRO   238     -50.282  73.665  47.403  1.00 21.61           O  
ATOM   1918  CB  PRO   238     -53.065  73.198  49.286  1.00 21.21           C  
ATOM   1919  CG  PRO   238     -52.379  71.863  49.327  1.00 20.59           C  
ATOM   1920  CD  PRO   238     -52.624  71.296  47.934  1.00 20.68           C  
ATOM   1921  N   PRO   239     -50.982  75.390  48.686  1.00 21.19           N  
ATOM   1922  CA  PRO   239     -49.636  75.969  48.791  1.00 21.35           C  
ATOM   1923  C   PRO   239     -48.742  75.223  49.782  1.00 21.54           C  
ATOM   1924  O   PRO   239     -49.223  74.429  50.589  1.00 21.57           O  
ATOM   1925  CB  PRO   239     -49.903  77.402  49.235  1.00 21.14           C  
ATOM   1926  CG  PRO   239     -51.128  77.259  50.090  1.00 22.82           C  
ATOM   1927  CD  PRO   239     -51.987  76.291  49.288  1.00 21.16           C  
ATOM   1928  N   LYS   240     -47.445  75.502  49.723  1.00 21.81           N  
ATOM   1929  CA  LYS   240     -46.462  74.859  50.589  1.00 23.37           C  
ATOM   1930  C   LYS   240     -46.889  74.692  52.049  1.00 22.59           C  
ATOM   1931  O   LYS   240     -46.802  73.604  52.614  1.00 23.13           O  
ATOM   1932  CB  LYS   240     -45.149  75.641  50.538  1.00 23.21           C  
ATOM   1933  CG  LYS   240     -44.099  75.158  51.517  1.00 29.19           C  
ATOM   1934  CD  LYS   240     -43.098  74.220  50.872  1.00 32.75           C  
ATOM   1935  CE  LYS   240     -41.951  73.958  51.829  1.00 35.90           C  
ATOM   1936  NZ  LYS   240     -40.759  73.399  51.135  1.00 39.70           N  
ATOM   1937  N   LYS   241     -47.335  75.774  52.666  1.00 22.64           N  
ATOM   1938  CA  LYS   241     -47.718  75.713  54.070  1.00 23.09           C  
ATOM   1939  C   LYS   241     -48.713  74.588  54.360  1.00 22.57           C  
ATOM   1940  O   LYS   241     -48.602  73.898  55.377  1.00 21.90           O  
ATOM   1941  CB  LYS   241     -48.301  77.055  54.502  1.00 23.62           C  
ATOM   1942  CG  LYS   241     -48.459  77.198  55.994  1.00 26.80           C  
ATOM   1943  CD  LYS   241     -48.967  78.588  56.316  1.00 31.99           C  
ATOM   1944  CE  LYS   241     -49.041  78.821  57.812  1.00 34.70           C  
ATOM   1945  NZ  LYS   241     -49.444  80.225  58.114  1.00 36.82           N  
ATOM   1946  N   ILE   242     -49.682  74.398  53.470  1.00 21.37           N  
ATOM   1947  CA  ILE   242     -50.675  73.354  53.665  1.00 21.17           C  
ATOM   1948  C   ILE   242     -50.044  71.989  53.399  1.00 20.81           C  
ATOM   1949  O   ILE   242     -50.301  71.027  54.121  1.00 20.07           O  
ATOM   1950  CB  ILE   242     -51.892  73.557  52.736  1.00 21.38           C  
ATOM   1951  CG1 ILE   242     -52.490  74.959  52.950  1.00 22.86           C  
ATOM   1952  CG2 ILE   242     -52.929  72.462  52.980  1.00 19.60           C  
ATOM   1953  CD1 ILE   242     -53.006  75.233  54.357  1.00 25.44           C  
ATOM   1954  N   VAL   243     -49.209  71.914  52.363  1.00 20.91           N  
ATOM   1955  CA  VAL   243     -48.528  70.669  52.018  1.00 21.24           C  
ATOM   1956  C   VAL   243     -47.721  70.177  53.214  1.00 22.36           C  
ATOM   1957  O   VAL   243     -47.729  68.990  53.535  1.00 23.15           O  
ATOM   1958  CB  VAL   243     -47.566  70.854  50.817  1.00 20.93           C  
ATOM   1959  CG1 VAL   243     -46.732  69.591  50.615  1.00 19.61           C  
ATOM   1960  CG2 VAL   243     -48.358  71.162  49.551  1.00 19.49           C  
ATOM   1961  N   THR   244     -47.022  71.095  53.871  1.00 23.46           N  
ATOM   1962  CA  THR   244     -46.206  70.741  55.026  1.00 24.14           C  
ATOM   1963  C   THR   244     -47.068  70.220  56.171  1.00 24.59           C  
ATOM   1964  O   THR   244     -46.720  69.227  56.810  1.00 25.30           O  
ATOM   1965  CB  THR   244     -45.377  71.949  55.503  1.00 24.38           C  
ATOM   1966  OG1 THR   244     -44.460  72.324  54.467  1.00 24.49           O  
ATOM   1967  CG2 THR   244     -44.594  71.604  56.760  1.00 25.17           C  
ATOM   1968  N   LEU   245     -48.190  70.880  56.439  1.00 24.98           N  
ATOM   1969  CA  LEU   245     -49.077  70.416  57.495  1.00 24.98           C  
ATOM   1970  C   LEU   245     -49.613  69.020  57.158  1.00 25.34           C  
ATOM   1971  O   LEU   245     -49.613  68.128  58.009  1.00 24.68           O  
ATOM   1972  CB  LEU   245     -50.241  71.389  57.692  1.00 24.93           C  
ATOM   1973  CG  LEU   245     -49.874  72.760  58.271  1.00 27.25           C  
ATOM   1974  CD1 LEU   245     -51.112  73.635  58.352  1.00 27.15           C  
ATOM   1975  CD2 LEU   245     -49.230  72.603  59.650  1.00 27.56           C  
ATOM   1976  N   ALA   246     -50.049  68.831  55.915  1.00 24.91           N  
ATOM   1977  CA  ALA   246     -50.581  67.541  55.482  1.00 25.18           C  
ATOM   1978  C   ALA   246     -49.535  66.434  55.610  1.00 25.82           C  
ATOM   1979  O   ALA   246     -49.812  65.378  56.187  1.00 25.76           O  
ATOM   1980  CB  ALA   246     -51.084  67.627  54.041  1.00 24.64           C  
ATOM   1981  N   SER   247     -48.340  66.666  55.073  1.00 26.75           N  
ATOM   1982  CA  SER   247     -47.279  65.665  55.161  1.00 28.94           C  
ATOM   1983  C   SER   247     -47.005  65.267  56.613  1.00 30.31           C  
ATOM   1984  O   SER   247     -46.826  64.085  56.911  1.00 30.68           O  
ATOM   1985  CB  SER   247     -45.990  66.182  54.522  1.00 28.90           C  
ATOM   1986  OG  SER   247     -46.169  66.398  53.134  1.00 32.15           O  
ATOM   1987  N   GLU   248     -46.966  66.250  57.509  1.00 32.00           N  
ATOM   1988  CA  GLU   248     -46.727  65.976  58.921  1.00 33.31           C  
ATOM   1989  C   GLU   248     -47.822  65.067  59.479  1.00 33.39           C  
ATOM   1990  O   GLU   248     -47.643  64.443  60.524  1.00 33.68           O  
ATOM   1991  CB  GLU   248     -46.683  67.274  59.732  1.00 33.76           C  
ATOM   1992  CG  GLU   248     -45.611  68.257  59.292  1.00 37.96           C  
ATOM   1993  CD  GLU   248     -45.498  69.456  60.222  1.00 43.25           C  
ATOM   1994  OE1 GLU   248     -46.547  69.998  60.636  1.00 43.98           O  
ATOM   1995  OE2 GLU   248     -44.357  69.862  60.531  1.00 46.59           O  
ATOM   1996  N   LEU   249     -48.954  65.003  58.779  1.00 32.87           N  
ATOM   1997  CA  LEU   249     -50.073  64.152  59.194  1.00 32.64           C  
ATOM   1998  C   LEU   249     -50.085  62.850  58.402  1.00 31.52           C  
ATOM   1999  O   LEU   249     -51.015  62.056  58.513  1.00 32.25           O  
ATOM   2000  CB  LEU   249     -51.406  64.884  58.994  1.00 32.73           C  
ATOM   2001  CG  LEU   249     -51.716  66.002  59.994  1.00 33.49           C  
ATOM   2002  CD1 LEU   249     -52.961  66.762  59.575  1.00 32.24           C  
ATOM   2003  CD2 LEU   249     -51.903  65.398  61.373  1.00 36.58           C  
ATOM   2004  N   GLN   250     -49.035  62.636  57.613  1.00 30.77           N  
ATOM   2005  CA  GLN   250     -48.914  61.451  56.768  1.00 30.27           C  
ATOM   2006  C   GLN   250     -50.052  61.305  55.771  1.00 28.32           C  
ATOM   2007  O   GLN   250     -50.450  60.194  55.446  1.00 27.01           O  
ATOM   2008  CB  GLN   250     -48.831  60.170  57.600  1.00 31.79           C  
ATOM   2009  CG  GLN   250     -47.483  59.925  58.243  1.00 35.48           C  
ATOM   2010  CD  GLN   250     -47.180  60.934  59.314  1.00 40.70           C  
ATOM   2011  OE1 GLN   250     -47.956  61.107  60.253  1.00 43.32           O  
ATOM   2012  NE2 GLN   250     -46.049  61.617  59.183  1.00 44.72           N  
ATOM   2013  N   ILE   251     -50.590  62.429  55.311  1.00 26.54           N  
ATOM   2014  CA  ILE   251     -51.649  62.404  54.312  1.00 24.52           C  
ATOM   2015  C   ILE   251     -50.946  62.321  52.959  1.00 24.45           C  
ATOM   2016  O   ILE   251     -50.077  63.141  52.649  1.00 23.94           O  
ATOM   2017  CB  ILE   251     -52.504  63.687  54.351  1.00 24.89           C  
ATOM   2018  CG1 ILE   251     -53.280  63.773  55.667  1.00 23.70           C  
ATOM   2019  CG2 ILE   251     -53.432  63.719  53.151  1.00 23.90           C  
ATOM   2020  CD1 ILE   251     -54.008  65.099  55.862  1.00 21.71           C  
ATOM   2021  N   PRO   252     -51.293  61.311  52.150  1.00 23.96           N  
ATOM   2022  CA  PRO   252     -50.705  61.102  50.826  1.00 23.94           C  
ATOM   2023  C   PRO   252     -51.110  62.148  49.793  1.00 23.67           C  
ATOM   2024  O   PRO   252     -52.256  62.596  49.760  1.00 22.98           O  
ATOM   2025  CB  PRO   252     -51.203  59.701  50.446  1.00 24.03           C  
ATOM   2026  CG  PRO   252     -51.389  59.023  51.795  1.00 24.79           C  
ATOM   2027  CD  PRO   252     -52.068  60.129  52.563  1.00 24.64           C  
ATOM   2028  N   PHE   253     -50.149  62.532  48.961  1.00 23.10           N  
ATOM   2029  CA  PHE   253     -50.368  63.477  47.875  1.00 23.78           C  
ATOM   2030  C   PHE   253     -50.149  62.736  46.562  1.00 23.38           C  
ATOM   2031  O   PHE   253     -49.270  61.885  46.460  1.00 24.15           O  
ATOM   2032  CB  PHE   253     -49.368  64.643  47.945  1.00 23.07           C  
ATOM   2033  CG  PHE   253     -49.813  65.782  48.823  1.00 24.70           C  
ATOM   2034  CD1 PHE   253     -50.835  66.629  48.410  1.00 24.79           C  
ATOM   2035  CD2 PHE   253     -49.205  66.013  50.056  1.00 25.18           C  
ATOM   2036  CE1 PHE   253     -51.251  67.689  49.205  1.00 25.71           C  
ATOM   2037  CE2 PHE   253     -49.611  67.068  50.861  1.00 25.52           C  
ATOM   2038  CZ  PHE   253     -50.638  67.911  50.434  1.00 25.15           C  
ATOM   2039  N   VAL   254     -50.972  63.041  45.568  1.00 22.52           N  
ATOM   2040  CA  VAL   254     -50.794  62.455  44.250  1.00 20.26           C  
ATOM   2041  C   VAL   254     -50.714  63.621  43.277  1.00 20.00           C  
ATOM   2042  O   VAL   254     -51.623  64.448  43.215  1.00 17.97           O  
ATOM   2043  CB  VAL   254     -51.969  61.560  43.828  1.00 20.64           C  
ATOM   2044  CG1 VAL   254     -51.701  60.992  42.440  1.00 18.55           C  
ATOM   2045  CG2 VAL   254     -52.163  60.441  44.843  1.00 18.39           C  
ATOM   2046  N   TYR   255     -49.610  63.696  42.543  1.00 19.99           N  
ATOM   2047  CA  TYR   255     -49.417  64.753  41.560  1.00 19.74           C  
ATOM   2048  C   TYR   255     -50.584  64.800  40.586  1.00 19.60           C  
ATOM   2049  O   TYR   255     -51.027  63.767  40.082  1.00 20.40           O  
ATOM   2050  CB  TYR   255     -48.129  64.510  40.778  1.00 19.55           C  
ATOM   2051  CG  TYR   255     -48.013  65.328  39.509  1.00 18.66           C  
ATOM   2052  CD1 TYR   255     -47.679  66.685  39.557  1.00 17.53           C  
ATOM   2053  CD2 TYR   255     -48.221  64.738  38.257  1.00 17.16           C  
ATOM   2054  CE1 TYR   255     -47.546  67.436  38.392  1.00 18.34           C  
ATOM   2055  CE2 TYR   255     -48.093  65.479  37.081  1.00 17.14           C  
ATOM   2056  CZ  TYR   255     -47.753  66.828  37.159  1.00 18.27           C  
ATOM   2057  OH  TYR   255     -47.616  67.564  36.005  1.00 17.46           O  
ATOM   2058  N   GLY   256     -51.067  66.009  40.320  1.00 19.45           N  
ATOM   2059  CA  GLY   256     -52.167  66.194  39.392  1.00 19.66           C  
ATOM   2060  C   GLY   256     -51.877  67.383  38.496  1.00 20.10           C  
ATOM   2061  O   GLY   256     -51.783  68.519  38.975  1.00 19.77           O  
ATOM   2062  N   SER   257     -51.713  67.119  37.202  1.00 19.73           N  
ATOM   2063  CA  SER   257     -51.418  68.169  36.231  1.00 19.01           C  
ATOM   2064  C   SER   257     -52.697  68.865  35.784  1.00 19.17           C  
ATOM   2065  O   SER   257     -52.660  69.967  35.237  1.00 17.90           O  
ATOM   2066  CB  SER   257     -50.750  67.568  34.997  1.00 20.14           C  
ATOM   2067  OG  SER   257     -51.685  66.802  34.246  1.00 20.07           O  
ATOM   2068  N   ASP   258     -53.828  68.203  35.995  1.00 18.83           N  
ATOM   2069  CA  ASP   258     -55.115  68.744  35.575  1.00 19.26           C  
ATOM   2070  C   ASP   258     -55.043  69.113  34.086  1.00 19.75           C  
ATOM   2071  O   ASP   258     -55.607  70.121  33.657  1.00 20.46           O  
ATOM   2072  CB  ASP   258     -55.462  69.987  36.395  1.00 18.57           C  
ATOM   2073  CG  ASP   258     -56.952  70.093  36.684  1.00 19.86           C  
ATOM   2074  OD1 ASP   258     -57.752  69.596  35.869  1.00 15.61           O  
ATOM   2075  OD2 ASP   258     -57.321  70.681  37.719  1.00 19.11           O  
ATOM   2076  N   SER   259     -54.347  68.289  33.306  1.00 19.68           N  
ATOM   2077  CA  SER   259     -54.173  68.539  31.877  1.00 20.19           C  
ATOM   2078  C   SER   259     -55.465  68.476  31.068  1.00 20.86           C  
ATOM   2079  O   SER   259     -56.267  67.548  31.223  1.00 19.62           O  
ATOM   2080  CB  SER   259     -53.161  67.546  31.278  1.00 20.27           C  
ATOM   2081  OG  SER   259     -51.857  67.723  31.822  1.00 19.79           O  
ATOM   2082  N   HIS   260     -55.659  69.473  30.208  1.00 20.15           N  
ATOM   2083  CA  HIS   260     -56.824  69.534  29.330  1.00 22.39           C  
ATOM   2084  C   HIS   260     -56.339  69.537  27.890  1.00 23.08           C  
ATOM   2085  O   HIS   260     -57.102  69.806  26.960  1.00 24.11           O  
ATOM   2086  CB  HIS   260     -57.654  70.790  29.601  1.00 22.54           C  
ATOM   2087  CG  HIS   260     -58.335  70.775  30.930  1.00 25.42           C  
ATOM   2088  ND1 HIS   260     -57.642  70.834  32.120  1.00 30.26           N  
ATOM   2089  CD2 HIS   260     -59.642  70.666  31.263  1.00 28.04           C  
ATOM   2090  CE1 HIS   260     -58.491  70.762  33.128  1.00 28.91           C  
ATOM   2091  NE2 HIS   260     -59.712  70.658  32.636  1.00 29.14           N  
ATOM   2092  N   GLY   261     -55.057  69.227  27.727  1.00 23.33           N  
ATOM   2093  CA  GLY   261     -54.442  69.181  26.414  1.00 23.68           C  
ATOM   2094  C   GLY   261     -53.025  68.648  26.499  1.00 23.70           C  
ATOM   2095  O   GLY   261     -52.463  68.526  27.589  1.00 21.77           O  
ATOM   2096  N   VAL   262     -52.447  68.334  25.343  1.00 24.48           N  
ATOM   2097  CA  VAL   262     -51.093  67.793  25.266  1.00 24.70           C  
ATOM   2098  C   VAL   262     -50.031  68.695  25.906  1.00 25.45           C  
ATOM   2099  O   VAL   262     -49.134  68.217  26.603  1.00 25.31           O  
ATOM   2100  CB  VAL   262     -50.701  67.524  23.792  1.00 24.78           C  
ATOM   2101  CG1 VAL   262     -49.259  67.036  23.711  1.00 25.19           C  
ATOM   2102  CG2 VAL   262     -51.647  66.494  23.181  1.00 23.41           C  
ATOM   2103  N   GLN   263     -50.146  69.998  25.685  1.00 25.87           N  
ATOM   2104  CA  GLN   263     -49.169  70.932  26.220  1.00 27.74           C  
ATOM   2105  C   GLN   263     -49.167  71.046  27.735  1.00 27.17           C  
ATOM   2106  O   GLN   263     -48.200  71.540  28.309  1.00 27.20           O  
ATOM   2107  CB  GLN   263     -49.348  72.313  25.581  1.00 28.67           C  
ATOM   2108  CG  GLN   263     -48.984  72.324  24.106  1.00 34.74           C  
ATOM   2109  CD  GLN   263     -47.640  71.660  23.859  1.00 41.06           C  
ATOM   2110  OE1 GLN   263     -46.628  72.068  24.427  1.00 44.93           O  
ATOM   2111  NE2 GLN   263     -47.626  70.628  23.018  1.00 42.26           N  
ATOM   2112  N   ASP   264     -50.231  70.583  28.386  1.00 25.98           N  
ATOM   2113  CA  ASP   264     -50.301  70.646  29.844  1.00 25.46           C  
ATOM   2114  C   ASP   264     -49.585  69.469  30.504  1.00 24.54           C  
ATOM   2115  O   ASP   264     -49.186  69.546  31.666  1.00 23.91           O  
ATOM   2116  CB  ASP   264     -51.755  70.625  30.338  1.00 25.82           C  
ATOM   2117  CG  ASP   264     -52.563  71.819  29.874  1.00 28.55           C  
ATOM   2118  OD1 ASP   264     -51.978  72.893  29.609  1.00 30.52           O  
ATOM   2119  OD2 ASP   264     -53.805  71.676  29.797  1.00 28.80           O  
ATOM   2120  N   ILE   265     -49.456  68.368  29.769  1.00 24.00           N  
ATOM   2121  CA  ILE   265     -48.842  67.154  30.297  1.00 23.14           C  
ATOM   2122  C   ILE   265     -47.499  67.387  30.984  1.00 23.08           C  
ATOM   2123  O   ILE   265     -46.593  67.989  30.410  1.00 22.29           O  
ATOM   2124  CB  ILE   265     -48.657  66.099  29.177  1.00 23.36           C  
ATOM   2125  CG1 ILE   265     -50.015  65.744  28.553  1.00 23.31           C  
ATOM   2126  CG2 ILE   265     -47.999  64.847  29.735  1.00 22.67           C  
ATOM   2127  CD1 ILE   265     -50.988  65.075  29.504  1.00 21.69           C  
ATOM   2128  N   GLY   266     -47.390  66.910  32.222  1.00 21.85           N  
ATOM   2129  CA  GLY   266     -46.157  67.027  32.985  1.00 21.38           C  
ATOM   2130  C   GLY   266     -45.840  68.374  33.624  1.00 22.21           C  
ATOM   2131  O   GLY   266     -44.839  68.495  34.327  1.00 20.92           O  
ATOM   2132  N   ARG   267     -46.686  69.378  33.406  1.00 21.55           N  
ATOM   2133  CA  ARG   267     -46.425  70.713  33.942  1.00 22.08           C  
ATOM   2134  C   ARG   267     -46.265  70.789  35.456  1.00 22.31           C  
ATOM   2135  O   ARG   267     -47.046  70.208  36.217  1.00 23.20           O  
ATOM   2136  CB  ARG   267     -47.518  71.697  33.488  1.00 22.31           C  
ATOM   2137  CG  ARG   267     -48.931  71.398  34.006  1.00 21.85           C  
ATOM   2138  CD  ARG   267     -49.937  72.415  33.463  1.00 24.93           C  
ATOM   2139  NE  ARG   267     -51.317  72.118  33.858  1.00 21.71           N  
ATOM   2140  CZ  ARG   267     -52.370  72.845  33.491  1.00 23.47           C  
ATOM   2141  NH1 ARG   267     -52.204  73.910  32.720  1.00 22.66           N  
ATOM   2142  NH2 ARG   267     -53.592  72.515  33.894  1.00 22.10           N  
ATOM   2143  N   GLY   268     -45.234  71.509  35.885  1.00 22.20           N  
ATOM   2144  CA  GLY   268     -44.982  71.685  37.305  1.00 21.96           C  
ATOM   2145  C   GLY   268     -44.619  70.431  38.085  1.00 22.68           C  
ATOM   2146  O   GLY   268     -44.670  70.428  39.318  1.00 21.51           O  
ATOM   2147  N   TYR   269     -44.236  69.361  37.392  1.00 22.88           N  
ATOM   2148  CA  TYR   269     -43.891  68.137  38.109  1.00 23.59           C  
ATOM   2149  C   TYR   269     -42.690  68.319  39.039  1.00 24.32           C  
ATOM   2150  O   TYR   269     -42.693  67.802  40.160  1.00 24.55           O  
ATOM   2151  CB  TYR   269     -43.634  66.982  37.144  1.00 22.98           C  
ATOM   2152  CG  TYR   269     -43.500  65.667  37.869  1.00 25.04           C  
ATOM   2153  CD1 TYR   269     -42.244  65.124  38.156  1.00 26.89           C  
ATOM   2154  CD2 TYR   269     -44.633  64.982  38.311  1.00 25.25           C  
ATOM   2155  CE1 TYR   269     -42.125  63.933  38.871  1.00 27.44           C  
ATOM   2156  CE2 TYR   269     -44.524  63.800  39.024  1.00 25.00           C  
ATOM   2157  CZ  TYR   269     -43.272  63.280  39.301  1.00 27.02           C  
ATOM   2158  OH  TYR   269     -43.179  62.115  40.024  1.00 26.82           O  
ATOM   2159  N   SER   270     -41.668  69.046  38.584  1.00 25.14           N  
ATOM   2160  CA  SER   270     -40.486  69.297  39.422  1.00 26.58           C  
ATOM   2161  C   SER   270     -40.906  70.025  40.694  1.00 25.38           C  
ATOM   2162  O   SER   270     -40.441  69.709  41.789  1.00 25.49           O  
ATOM   2163  CB  SER   270     -39.452  70.153  38.678  1.00 27.36           C  
ATOM   2164  OG  SER   270     -38.415  70.574  39.565  1.00 33.05           O  
ATOM   2165  N   THR   271     -41.789  71.007  40.537  1.00 25.72           N  
ATOM   2166  CA  THR   271     -42.287  71.781  41.667  1.00 25.54           C  
ATOM   2167  C   THR   271     -42.950  70.841  42.663  1.00 25.92           C  
ATOM   2168  O   THR   271     -42.724  70.939  43.868  1.00 24.85           O  
ATOM   2169  CB  THR   271     -43.298  72.848  41.200  1.00 25.60           C  
ATOM   2170  OG1 THR   271     -42.628  73.798  40.361  1.00 28.28           O  
ATOM   2171  CG2 THR   271     -43.913  73.575  42.391  1.00 24.22           C  
ATOM   2172  N   TYR   272     -43.769  69.931  42.147  1.00 26.64           N  
ATOM   2173  CA  TYR   272     -44.447  68.946  42.985  1.00 27.38           C  
ATOM   2174  C   TYR   272     -43.410  68.194  43.817  1.00 27.95           C  
ATOM   2175  O   TYR   272     -43.494  68.157  45.046  1.00 28.30           O  
ATOM   2176  CB  TYR   272     -45.231  67.964  42.102  1.00 26.88           C  
ATOM   2177  CG  TYR   272     -45.495  66.615  42.739  1.00 28.67           C  
ATOM   2178  CD1 TYR   272     -46.392  66.480  43.799  1.00 29.74           C  
ATOM   2179  CD2 TYR   272     -44.836  65.473  42.285  1.00 29.38           C  
ATOM   2180  CE1 TYR   272     -46.626  65.239  44.390  1.00 30.77           C  
ATOM   2181  CE2 TYR   272     -45.059  64.227  42.867  1.00 28.61           C  
ATOM   2182  CZ  TYR   272     -45.956  64.118  43.917  1.00 30.62           C  
ATOM   2183  OH  TYR   272     -46.187  62.891  44.497  1.00 30.50           O  
ATOM   2184  N   CYS   273     -42.427  67.605  43.143  1.00 28.84           N  
ATOM   2185  CA  CYS   273     -41.380  66.849  43.820  1.00 30.44           C  
ATOM   2186  C   CYS   273     -40.656  67.651  44.902  1.00 30.82           C  
ATOM   2187  O   CYS   273     -40.502  67.180  46.032  1.00 30.32           O  
ATOM   2188  CB  CYS   273     -40.357  66.337  42.803  1.00 30.75           C  
ATOM   2189  SG  CYS   273     -41.057  65.230  41.563  1.00 36.62           S  
ATOM   2190  N   GLN   274     -40.208  68.855  44.553  1.00 30.67           N  
ATOM   2191  CA  GLN   274     -39.482  69.698  45.498  1.00 31.61           C  
ATOM   2192  C   GLN   274     -40.352  70.170  46.655  1.00 31.94           C  
ATOM   2193  O   GLN   274     -39.910  70.209  47.804  1.00 31.24           O  
ATOM   2194  CB  GLN   274     -38.881  70.910  44.769  1.00 31.80           C  
ATOM   2195  CG  GLN   274     -37.881  70.533  43.680  1.00 33.44           C  
ATOM   2196  CD  GLN   274     -36.760  69.663  44.214  1.00 37.81           C  
ATOM   2197  OE1 GLN   274     -36.189  68.844  43.493  1.00 41.63           O  
ATOM   2198  NE2 GLN   274     -36.434  69.842  45.486  1.00 38.86           N  
ATOM   2199  N   LYS   275     -41.600  70.514  46.352  1.00 32.77           N  
ATOM   2200  CA  LYS   275     -42.515  71.011  47.370  1.00 34.31           C  
ATOM   2201  C   LYS   275     -42.776  69.970  48.459  1.00 35.07           C  
ATOM   2202  O   LYS   275     -43.050  70.326  49.603  1.00 35.05           O  
ATOM   2203  CB  LYS   275     -43.837  71.440  46.726  1.00 34.59           C  
ATOM   2204  CG  LYS   275     -44.623  72.453  47.542  1.00 34.84           C  
ATOM   2205  CD  LYS   275     -44.659  73.786  46.815  1.00 38.81           C  
ATOM   2206  CE  LYS   275     -46.079  74.300  46.683  1.00 40.51           C  
ATOM   2207  NZ  LYS   275     -46.141  75.544  45.858  1.00 41.77           N  
END
