
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  229 ( 1726),  selected  229 , name 3cdk_A
# Molecule2: number of CA atoms  165 ( 1302),  selected  165 , name T0438_2_186.pdb
# PARAMETERS: 3cdk_A.T0438_2_186.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      Q       2           -
LGA    -       -      W       3           -
LGA    -       -      Q       4           -
LGA    -       -      E       5           -
LGA    G     4_A      L       6          1.125
LGA    K     5_A      Y       7          4.078
LGA    -       -      R       8           -
LGA    -       -      Q       9           -
LGA    V     6_A      R      10          3.133
LGA    L     7_A      V      11          1.199
LGA    S     8_A      C      12          3.139
LGA    S     9_A      S      13          1.570
LGA    S    10_A      A      14          1.225
LGA    K    11_A      D      15          1.668
LGA    E    12_A      E      16          1.361
LGA    A    13_A      A      17          1.165
LGA    A    14_A      V      18          1.295
LGA    K    15_A      V      19          1.328
LGA    L    16_A      D      20          2.311
LGA    -       -      S      21           -
LGA    I    17_A      L      22          1.013
LGA    H    18_A      K      23          2.162
LGA    D    19_A      P      24          2.428
LGA    G    20_A      G      25          1.741
LGA    D    21_A      T      26          0.896
LGA    T    22_A      K      27          0.351
LGA    L    23_A      V      28          0.522
LGA    I    24_A      V      29          0.976
LGA    A    25_A      F      30          0.912
LGA    G    26_A      G      31          0.372
LGA    G    27_A      X      32          0.988
LGA    F    28_A      A      33          2.202
LGA    G    29_A      -       -           -
LGA    L    30_A      -       -           -
LGA    C    31_A      A      34          0.745
LGA    G    32_A      A      35          0.877
LGA    I    33_A      A      36          1.016
LGA    P    34_A      P      37          1.074
LGA    E    35_A      V      38          1.468
LGA    Q    36_A      R      39          1.160
LGA    L    37_A      F      40          1.474
LGA    I    38_A      S      41          1.529
LGA    L    39_A      Q      42          1.117
LGA    S    40_A      A      43          1.158
LGA    I    41_A      M      44          1.614
LGA    R    42_A      Y      45          1.556
LGA    D    43_A      R      46          1.131
LGA    Q    44_A      Q      47          1.079
LGA    G    45_A      R      48          0.694
LGA    -       -      E      49           -
LGA    -       -      K      50           -
LGA    V    46_A      L      51          1.599
LGA    K    47_A      E      52          3.437
LGA    D    48_A      N      53          2.526
LGA    L    49_A      I      54          1.656
LGA    T    50_A      T      55          1.418
LGA    V    51_A      V      56          1.069
LGA    V    52_A      F      57          1.430
LGA    S    53_A      X      58          1.296
LGA    N    54_A      M      59          2.119
LGA    N    55_A      L      60          3.492
LGA    C    56_A      Y      61          5.312
LGA    G    57_A      F      62          4.854
LGA    V    58_A      -       -           -
LGA    D    59_A      -       -           -
LGA    D    60_A      -       -           -
LGA    W    61_A      G      63          2.797
LGA    G    62_A      D      64          1.166
LGA    L    63_A      -       -           -
LGA    G    64_A      A      65          3.950
LGA    L    65_A      P      66          1.230
LGA    L    66_A      X      67          1.199
LGA    L    67_A      L      68          1.657
LGA    A    68_A      A      69          0.786
LGA    -       -      P      70           -
LGA    N    69_A      E      71          3.170
LGA    K    70_A      M      72          1.982
LGA    -       -      R      73           -
LGA    -       -      S      74           -
LGA    Q    71_A      X      75          3.111
LGA    I    72_A      V      76          2.552
LGA    K    73_A      X      77          3.354
LGA    K    74_A      P      78          4.300
LGA    M    75_A      T      79          1.119
LGA    I    76_A      L      80          2.068
LGA    A    77_A      -       -           -
LGA    S    78_A      -       -           -
LGA    Y    79_A      -       -           -
LGA    V    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    I    85_A      -       -           -
LGA    F    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    R    88_A      -       -           -
LGA    Q    89_A      -       -           -
LGA    F    90_A      -       -           -
LGA    L    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    E    94_A      -       -           -
LGA    L    95_A      -       -           -
LGA    E    96_A      -       -           -
LGA    V    97_A      -       -           -
LGA    E    98_A      -       -           -
LGA    L    99_A      -       -           -
LGA    V   100_A      C     101           #
LGA    P   101_A      X     102          5.029
LGA    Q   102_A      F     103          3.135
LGA    G   103_A      X     104          2.684
LGA    T   104_A      E     105          2.226
LGA    L   105_A      V     106          1.709
LGA    A   106_A      P     107          2.441
LGA    E   107_A      E     108          2.746
LGA    R   108_A      L     109          1.972
LGA    I   109_A      F     110          2.400
LGA    R   110_A      -       -           -
LGA    A   111_A      R     111          1.238
LGA    G   112_A      -       -           -
LGA    G   113_A      -       -           -
LGA    A   114_A      -       -           -
LGA    G   115_A      -       -           -
LGA    I   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    G   118_A      -       -           -
LGA    F   119_A      -       -           -
LGA    Y   120_A      -       -           -
LGA    T   121_A      -       -           -
LGA    A   122_A      -       -           -
LGA    T   123_A      -       -           -
LGA    G   124_A      -       -           -
LGA    V   125_A      -       -           -
LGA    G   126_A      -       -           -
LGA    T   127_A      -       -           -
LGA    S   128_A      -       -           -
LGA    I   129_A      -       -           -
LGA    A   130_A      -       -           -
LGA    E   131_A      -       -           -
LGA    G   132_A      -       -           -
LGA    K   133_A      -       -           -
LGA    E   134_A      -       -           -
LGA    H   135_A      -       -           -
LGA    K   136_A      -       -           -
LGA    T   137_A      -       -           -
LGA    F   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    G   140_A      -       -           -
LGA    R   141_A      -       -           -
LGA    T   142_A      -       -           -
LGA    Y   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    L   145_A      -       -           -
LGA    E   146_A      Q     112           #
LGA    R   147_A      G     113          4.888
LGA    G   148_A      F     114          4.363
LGA    I   149_A      F     115          3.007
LGA    T   150_A      P     116          2.742
LGA    G   151_A      L     117          1.496
LGA    D   152_A      D     118          1.770
LGA    V   153_A      V     119          1.281
LGA    A   154_A      A     120          1.062
LGA    I   155_A      V     121          0.342
LGA    V   156_A      V     122          0.490
LGA    K   157_A      Q     123          0.706
LGA    A   158_A      V     124          0.766
LGA    W   159_A      S     125          2.070
LGA    K   160_A      T     126          2.289
LGA    A   161_A      P     127          3.259
LGA    D   162_A      N     128           #
LGA    T   163_A      E     129           -
LGA    -       -      E     130           -
LGA    M   164_A      G     131          5.278
LGA    G   165_A      -       -           -
LGA    N   166_A      Y     132          3.212
LGA    L   167_A      C     133          2.126
LGA    I   168_A      S     134          0.830
LGA    F   169_A      F     135          2.736
LGA    R   170_A      G     136          2.420
LGA    K   171_A      V     137          3.683
LGA    T   172_A      -       -           -
LGA    A   173_A      S     138          3.191
LGA    R   174_A      C     139          3.173
LGA    N   175_A      D     140          2.958
LGA    F   176_A      Y     141          2.847
LGA    N   177_A      T     142          2.624
LGA    P   178_A      K     143          1.406
LGA    I   179_A      A     144          1.590
LGA    A   180_A      A     145          1.777
LGA    A   181_A      A     146          0.962
LGA    M   182_A      E     147          1.083
LGA    A   183_A      C     148          1.851
LGA    G   184_A      A     149          1.320
LGA    K   185_A      P     150          1.826
LGA    I   186_A      V     151          0.651
LGA    T   187_A      V     152          0.391
LGA    I   188_A      V     153          0.963
LGA    A   189_A      A     154          0.879
LGA    E   190_A      E     155          0.758
LGA    A   191_A      V     156          1.373
LGA    E   192_A      N     157          1.243
LGA    E   193_A      K     158          3.119
LGA    I   194_A      Q     159           -
LGA    V   195_A      M     160           -
LGA    E   196_A      P     161           -
LGA    A   197_A      -       -           -
LGA    G   198_A      -       -           -
LGA    E   199_A      -       -           -
LGA    L   200_A      F     162           #
LGA    D   201_A      I     163           -
LGA    P   202_A      -       -           -
LGA    D   203_A      -       -           -
LGA    H   204_A      G     164          4.912
LGA    I   205_A      G     165           -
LGA    -       -      E     166           -
LGA    H   206_A      N     167          2.684
LGA    T   207_A      L     168          3.152
LGA    P   208_A      I     169          3.455
LGA    G   209_A      X     170          2.310
LGA    I   210_A      I     171           #
LGA    Y   211_A      S     172           #
LGA    V   212_A      K     173          2.479
LGA    Q   213_A      L     174          2.840
LGA    H   214_A      T     175          2.394
LGA    -       -      X     176           -
LGA    V   215_A      I     177          1.773
LGA    V   216_A      I     178          1.796
LGA    L   217_A      E     179          0.902
LGA    G   218_A      V     180          2.050
LGA    A   219_A      D     181          2.638
LGA    S   220_A      E     182          2.861
LGA    Q   221_A      P     183          2.997
LGA    E   222_A      -       -           -
LGA    K   223_A      I     184          3.124
LGA    R   224_A      A     185          2.855
LGA    I   225_A      E     186          2.580
LGA    E   226_A      -       -           -
LGA    K   227_A      -       -           -
LGA    R   228_A      -       -           -
LGA    T   229_A      -       -           -
LGA    V   230_A      -       -           -
LGA    Q   231_A      -       -           -
LGA    Q   232_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  229  165    5.0    138    2.33    15.22     55.681     5.676

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.926147 * X  +   0.200773 * Y  +   0.319284 * Z  +   4.124275
  Y_new =   0.082322 * X  +   0.933737 * Y  +  -0.348365 * Z  +  -2.180804
  Z_new =  -0.368070 * X  +  -0.296353 * Y  +  -0.881306 * Z  + -12.248349 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.817205    0.324387  [ DEG:  -161.4140     18.5860 ]
  Theta =   0.376932    2.764661  [ DEG:    21.5966    158.4034 ]
  Phi   =   3.052939   -0.088653  [ DEG:   174.9205     -5.0795 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cdk_A                                        
REMARK     2: T0438_2_186.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cdk_A.T0438_2_186.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  229  165   5.0  138   2.33   15.22  55.681
REMARK  ---------------------------------------------------------- 
MOLECULE 3cdk_A
HEADER    TRANSFERASE                             27-FEB-08   3CDK              
TITLE     CRYSTAL STRUCTURE OF THE CO-EXPRESSED SUCCINYL-COA                    
TITLE    2 TRANSFERASE A AND B COMPLEX FROM BACILLUS SUBTILIS                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SUCCINYL-COA:3-KETOACID-COENZYME A TRANSFERASE             
COMPND   3 SUBUNIT A;                                                           
COMPND   4 CHAIN: A, C;                                                         
COMPND   5 SYNONYM: SUCCINYL COA:3-OXOACID COA-TRANSFERASE, OXCT A;             
COMPND   6 EC: 2.8.3.5;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: SUCCINYL-COA:3-KETOACID-COENZYME A TRANSFERASE             
COMPND  10 SUBUNIT B;                                                           
COMPND  11 CHAIN: B, D;                                                         
COMPND  12 SYNONYM: SUCCINYL COA:3-OXOACID COA-TRANSFERASE, OXCT B;             
COMPND  13 EC: 2.8.3.5;                                                         
COMPND  14 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: SCOA, YXJD, BSU38990, N15K;                                    
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG17;                                  
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 STRAIN: 168;                                                         
SOURCE  14 GENE: SCOB, YXJE, BSU38980, N15L;                                    
SOURCE  15 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PMCSG21                                   
KEYWDS    CO-EXPRESSED COMPLEX, HETERO-TETRAMER, STRUCTURAL GENOMICS,           
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR              
KEYWDS   3 STRUCTURAL GENOMICS, MCSG, TRANSFERASE                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,M.ZHOU,L.STOLS,W.ESCHENFELDT,M.DONNELLY,A.JOACHIMIAK,           
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   18-MAR-08 3CDK    0                                                
JRNL        AUTH   Y.KIM,M.ZHOU,L.STOLS,W.ESCHENFELDT,M.DONNELLY,               
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF THE CO-EXPRESSED SUCCINYL-COA           
JRNL        TITL 2 TRANSFERASE A AND B COMPLEX FROM BACILLUS SUBTILIS.          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.59 ANGSTROMS.                                          
DBREF  3CDK A    3   240  UNP    P42315   SCOA_BACSU       1    238             
DBREF  3CDK B    1   216  UNP    P42316   SCOB_BACSU       1    216             
DBREF  3CDK C    3   240  UNP    P42315   SCOA_BACSU       1    238             
DBREF  3CDK D    1   216  UNP    P42316   SCOB_BACSU       1    216             
SEQRES   1 A  241  SER ASN ALA MET GLY LYS VAL LEU SER SER SER LYS GLU          
SEQRES   2 A  241  ALA ALA LYS LEU ILE HIS ASP GLY ASP THR LEU ILE ALA          
SEQRES   3 A  241  GLY GLY PHE GLY LEU CYS GLY ILE PRO GLU GLN LEU ILE          
SEQRES   4 A  241  LEU SER ILE ARG ASP GLN GLY VAL LYS ASP LEU THR VAL          
SEQRES   5 A  241  VAL SER ASN ASN CYS GLY VAL ASP ASP TRP GLY LEU GLY          
SEQRES   6 A  241  LEU LEU LEU ALA ASN LYS GLN ILE LYS LYS MET ILE ALA          
SEQRES   7 A  241  SER TYR VAL GLY GLU ASN LYS ILE PHE GLU ARG GLN PHE          
SEQRES   8 A  241  LEU SER GLY GLU LEU GLU VAL GLU LEU VAL PRO GLN GLY          
SEQRES   9 A  241  THR LEU ALA GLU ARG ILE ARG ALA GLY GLY ALA GLY ILE          
SEQRES  10 A  241  PRO GLY PHE TYR THR ALA THR GLY VAL GLY THR SER ILE          
SEQRES  11 A  241  ALA GLU GLY LYS GLU HIS LYS THR PHE GLY GLY ARG THR          
SEQRES  12 A  241  TYR VAL LEU GLU ARG GLY ILE THR GLY ASP VAL ALA ILE          
SEQRES  13 A  241  VAL LYS ALA TRP LYS ALA ASP THR MET GLY ASN LEU ILE          
SEQRES  14 A  241  PHE ARG LYS THR ALA ARG ASN PHE ASN PRO ILE ALA ALA          
SEQRES  15 A  241  MET ALA GLY LYS ILE THR ILE ALA GLU ALA GLU GLU ILE          
SEQRES  16 A  241  VAL GLU ALA GLY GLU LEU ASP PRO ASP HIS ILE HIS THR          
SEQRES  17 A  241  PRO GLY ILE TYR VAL GLN HIS VAL VAL LEU GLY ALA SER          
SEQRES  18 A  241  GLN GLU LYS ARG ILE GLU LYS ARG THR VAL GLN GLN ALA          
SEQRES  19 A  241  SER GLY LYS GLY GLU ALA LYS                                  
SEQRES   1 B  219  SER ASN ALA MET LYS GLU ALA ARG LYS ARG MET VAL LYS          
SEQRES   2 B  219  ARG ALA VAL GLN GLU ILE LYS ASP GLY MET ASN VAL ASN          
SEQRES   3 B  219  LEU GLY ILE GLY MET PRO THR LEU VAL ALA ASN GLU ILE          
SEQRES   4 B  219  PRO ASP GLY VAL HIS VAL MET LEU GLN SER GLU ASN GLY          
SEQRES   5 B  219  LEU LEU GLY ILE GLY PRO TYR PRO LEU GLU GLY THR GLU          
SEQRES   6 B  219  ASP ALA ASP LEU ILE ASN ALA GLY LYS GLU THR ILE THR          
SEQRES   7 B  219  GLU VAL THR GLY ALA SER TYR PHE ASP SER ALA GLU SER          
SEQRES   8 B  219  PHE ALA MET ILE ARG GLY GLY HIS ILE ASP LEU ALA ILE          
SEQRES   9 B  219  LEU GLY GLY MET GLU VAL SER GLU GLN GLY ASP LEU ALA          
SEQRES  10 B  219  ASN TRP MET ILE PRO GLY LYS MET VAL LYS GLY MET GLY          
SEQRES  11 B  219  GLY ALA MET ASP LEU VAL ASN GLY ALA LYS ARG ILE VAL          
SEQRES  12 B  219  VAL ILE MET GLU HIS VAL ASN LYS HIS GLY GLU SER LYS          
SEQRES  13 B  219  VAL LYS LYS THR CYS SER LEU PRO LEU THR GLY GLN LYS          
SEQRES  14 B  219  VAL VAL HIS ARG LEU ILE THR ASP LEU ALA VAL PHE ASP          
SEQRES  15 B  219  PHE VAL ASN GLY ARG MET THR LEU THR GLU LEU GLN ASP          
SEQRES  16 B  219  GLY VAL THR ILE GLU GLU VAL TYR GLU LYS THR GLU ALA          
SEQRES  17 B  219  ASP PHE ALA VAL SER GLN SER VAL LEU ASN SER                  
SEQRES   1 C  241  SER ASN ALA MET GLY LYS VAL LEU SER SER SER LYS GLU          
SEQRES   2 C  241  ALA ALA LYS LEU ILE HIS ASP GLY ASP THR LEU ILE ALA          
SEQRES   3 C  241  GLY GLY PHE GLY LEU CYS GLY ILE PRO GLU GLN LEU ILE          
SEQRES   4 C  241  LEU SER ILE ARG ASP GLN GLY VAL LYS ASP LEU THR VAL          
SEQRES   5 C  241  VAL SER ASN ASN CYS GLY VAL ASP ASP TRP GLY LEU GLY          
SEQRES   6 C  241  LEU LEU LEU ALA ASN LYS GLN ILE LYS LYS MET ILE ALA          
SEQRES   7 C  241  SER TYR VAL GLY GLU ASN LYS ILE PHE GLU ARG GLN PHE          
SEQRES   8 C  241  LEU SER GLY GLU LEU GLU VAL GLU LEU VAL PRO GLN GLY          
SEQRES   9 C  241  THR LEU ALA GLU ARG ILE ARG ALA GLY GLY ALA GLY ILE          
SEQRES  10 C  241  PRO GLY PHE TYR THR ALA THR GLY VAL GLY THR SER ILE          
SEQRES  11 C  241  ALA GLU GLY LYS GLU HIS LYS THR PHE GLY GLY ARG THR          
SEQRES  12 C  241  TYR VAL LEU GLU ARG GLY ILE THR GLY ASP VAL ALA ILE          
SEQRES  13 C  241  VAL LYS ALA TRP LYS ALA ASP THR MET GLY ASN LEU ILE          
SEQRES  14 C  241  PHE ARG LYS THR ALA ARG ASN PHE ASN PRO ILE ALA ALA          
SEQRES  15 C  241  MET ALA GLY LYS ILE THR ILE ALA GLU ALA GLU GLU ILE          
SEQRES  16 C  241  VAL GLU ALA GLY GLU LEU ASP PRO ASP HIS ILE HIS THR          
SEQRES  17 C  241  PRO GLY ILE TYR VAL GLN HIS VAL VAL LEU GLY ALA SER          
SEQRES  18 C  241  GLN GLU LYS ARG ILE GLU LYS ARG THR VAL GLN GLN ALA          
SEQRES  19 C  241  SER GLY LYS GLY GLU ALA LYS                                  
SEQRES   1 D  219  SER ASN ALA MET LYS GLU ALA ARG LYS ARG MET VAL LYS          
SEQRES   2 D  219  ARG ALA VAL GLN GLU ILE LYS ASP GLY MET ASN VAL ASN          
SEQRES   3 D  219  LEU GLY ILE GLY MET PRO THR LEU VAL ALA ASN GLU ILE          
SEQRES   4 D  219  PRO ASP GLY VAL HIS VAL MET LEU GLN SER GLU ASN GLY          
SEQRES   5 D  219  LEU LEU GLY ILE GLY PRO TYR PRO LEU GLU GLY THR GLU          
SEQRES   6 D  219  ASP ALA ASP LEU ILE ASN ALA GLY LYS GLU THR ILE THR          
SEQRES   7 D  219  GLU VAL THR GLY ALA SER TYR PHE ASP SER ALA GLU SER          
SEQRES   8 D  219  PHE ALA MET ILE ARG GLY GLY HIS ILE ASP LEU ALA ILE          
SEQRES   9 D  219  LEU GLY GLY MET GLU VAL SER GLU GLN GLY ASP LEU ALA          
SEQRES  10 D  219  ASN TRP MET ILE PRO GLY LYS MET VAL LYS GLY MET GLY          
SEQRES  11 D  219  GLY ALA MET ASP LEU VAL ASN GLY ALA LYS ARG ILE VAL          
SEQRES  12 D  219  VAL ILE MET GLU HIS VAL ASN LYS HIS GLY GLU SER LYS          
SEQRES  13 D  219  VAL LYS LYS THR CYS SER LEU PRO LEU THR GLY GLN LYS          
SEQRES  14 D  219  VAL VAL HIS ARG LEU ILE THR ASP LEU ALA VAL PHE ASP          
SEQRES  15 D  219  PHE VAL ASN GLY ARG MET THR LEU THR GLU LEU GLN ASP          
SEQRES  16 D  219  GLY VAL THR ILE GLU GLU VAL TYR GLU LYS THR GLU ALA          
SEQRES  17 D  219  ASP PHE ALA VAL SER GLN SER VAL LEU ASN SER                  
FORMUL   5  HOH   *115(H2 O)                                                    
CRYST1   69.337   70.404   97.996  90.00 106.31  90.00 P 1 2 1       4          
ATOM      1  N   GLY A   4      17.885  39.136  11.875  1.00 65.05           N  
ATOM      2  CA  GLY A   4      18.771  38.007  12.345  1.00 63.43           C  
ATOM      3  C   GLY A   4      19.038  36.966  11.266  1.00 60.87           C  
ATOM      4  O   GLY A   4      19.437  37.294  10.145  1.00 61.15           O  
ATOM      5  N   LYS A   5      18.812  35.708  11.595  1.00 57.24           N  
ATOM      6  CA  LYS A   5      18.951  34.667  10.607  1.00 54.73           C  
ATOM      7  C   LYS A   5      17.579  34.444   9.929  1.00 55.06           C  
ATOM      8  O   LYS A   5      17.473  33.668   8.958  1.00 53.15           O  
ATOM      9  CB  LYS A   5      19.486  33.373  11.248  1.00 52.99           C  
ATOM     10  CG  LYS A   5      20.844  33.498  11.975  1.00 52.03           C  
ATOM     11  CD  LYS A   5      21.962  32.709  11.323  1.00 48.92           C  
ATOM     12  CE  LYS A   5      22.224  31.416  12.095  1.00 49.62           C  
ATOM     13  NZ  LYS A   5      23.489  31.424  12.907  1.00 48.33           N  
ATOM     14  N   VAL A   6      16.558  35.161  10.424  1.00 56.95           N  
ATOM     15  CA  VAL A   6      15.139  34.910  10.074  1.00 58.61           C  
ATOM     16  C   VAL A   6      14.680  35.434   8.709  1.00 60.25           C  
ATOM     17  O   VAL A   6      14.881  36.596   8.376  1.00 61.10           O  
ATOM     18  CB  VAL A   6      14.166  35.465  11.139  1.00 59.06           C  
ATOM     19  CG1 VAL A   6      12.716  35.147  10.767  1.00 57.50           C  
ATOM     20  CG2 VAL A   6      14.494  34.891  12.488  1.00 58.57           C  
ATOM     21  N   LEU A   7      14.058  34.548   7.939  1.00 60.83           N  
ATOM     22  CA  LEU A   7      13.431  34.888   6.659  1.00 62.70           C  
ATOM     23  C   LEU A   7      11.906  34.969   6.773  1.00 64.67           C  
ATOM     24  O   LEU A   7      11.267  34.169   7.474  1.00 64.27           O  
ATOM     25  CB  LEU A   7      13.835  33.892   5.560  1.00 61.37           C  
ATOM     26  CG  LEU A   7      15.206  34.121   4.910  1.00 61.18           C  
ATOM     27  CD1 LEU A   7      16.354  34.062   5.915  1.00 61.41           C  
ATOM     28  CD2 LEU A   7      15.445  33.125   3.803  1.00 58.51           C  
ATOM     29  N   SER A   8      11.344  35.949   6.072  1.00 68.06           N  
ATOM     30  CA  SER A   8       9.924  36.222   6.120  1.00 70.78           C  
ATOM     31  C   SER A   8       9.034  35.076   5.676  1.00 69.76           C  
ATOM     32  O   SER A   8       7.949  34.917   6.220  1.00 69.89           O  
ATOM     33  CB  SER A   8       9.612  37.462   5.310  1.00 72.44           C  
ATOM     34  OG  SER A   8       9.742  38.591   6.139  1.00 75.54           O  
ATOM     35  N   SER A   9       9.467  34.296   4.691  1.00 68.70           N  
ATOM     36  CA  SER A   9       8.631  33.188   4.215  1.00 68.37           C  
ATOM     37  C   SER A   9       9.396  32.025   3.634  1.00 66.01           C  
ATOM     38  O   SER A   9      10.519  32.176   3.159  1.00 65.61           O  
ATOM     39  CB  SER A   9       7.627  33.666   3.158  1.00 69.90           C  
ATOM     40  OG  SER A   9       8.271  33.872   1.906  1.00 72.34           O  
ATOM     41  N   SER A  10       8.743  30.868   3.652  1.00 64.39           N  
ATOM     42  CA  SER A  10       9.259  29.659   3.026  1.00 62.94           C  
ATOM     43  C   SER A  10       9.525  29.848   1.532  1.00 63.23           C  
ATOM     44  O   SER A  10      10.435  29.199   0.994  1.00 62.66           O  
ATOM     45  CB  SER A  10       8.291  28.488   3.226  1.00 62.41           C  
ATOM     46  OG  SER A  10       8.255  28.084   4.577  1.00 62.35           O  
ATOM     47  N   LYS A  11       8.748  30.723   0.874  1.00 64.32           N  
ATOM     48  CA  LYS A  11       8.923  30.997  -0.549  1.00 65.69           C  
ATOM     49  C   LYS A  11      10.338  31.441  -0.803  1.00 64.85           C  
ATOM     50  O   LYS A  11      11.054  30.823  -1.596  1.00 64.18           O  
ATOM     51  CB  LYS A  11       7.994  32.115  -1.026  1.00 67.91           C  
ATOM     52  CG  LYS A  11       6.853  31.684  -1.909  1.00 71.57           C  
ATOM     53  CD  LYS A  11       5.878  32.851  -2.084  1.00 77.96           C  
ATOM     54  CE  LYS A  11       4.426  32.401  -1.886  1.00 80.90           C  
ATOM     55  NZ  LYS A  11       3.497  33.575  -1.671  1.00 84.84           N  
ATOM     56  N   GLU A  12      10.716  32.526  -0.128  1.00 64.34           N  
ATOM     57  CA  GLU A  12      12.049  33.101  -0.224  1.00 64.05           C  
ATOM     58  C   GLU A  12      13.047  31.996  -0.013  1.00 60.32           C  
ATOM     59  O   GLU A  12      13.854  31.699  -0.893  1.00 59.82           O  
ATOM     60  CB  GLU A  12      12.272  34.146   0.867  1.00 65.50           C  
ATOM     61  CG  GLU A  12      12.222  35.599   0.448  1.00 69.31           C  
ATOM     62  CD  GLU A  12      12.532  36.523   1.637  1.00 73.24           C  
ATOM     63  OE1 GLU A  12      13.184  36.058   2.603  1.00 73.02           O  
ATOM     64  OE2 GLU A  12      12.120  37.711   1.622  1.00 76.49           O  
ATOM     65  N   ALA A  13      12.957  31.385   1.165  1.00 56.36           N  
ATOM     66  CA  ALA A  13      13.823  30.296   1.575  1.00 52.25           C  
ATOM     67  C   ALA A  13      13.995  29.205   0.494  1.00 50.24           C  
ATOM     68  O   ALA A  13      15.093  28.672   0.304  1.00 48.27           O  
ATOM     69  CB  ALA A  13      13.292  29.709   2.847  1.00 51.56           C  
ATOM     70  N   ALA A  14      12.921  28.905  -0.229  1.00 49.09           N  
ATOM     71  CA  ALA A  14      12.966  27.854  -1.223  1.00 48.59           C  
ATOM     72  C   ALA A  14      13.827  28.193  -2.434  1.00 49.00           C  
ATOM     73  O   ALA A  14      14.321  27.294  -3.108  1.00 48.49           O  
ATOM     74  CB  ALA A  14      11.572  27.471  -1.644  1.00 49.39           C  
ATOM     75  N   LYS A  15      14.028  29.486  -2.680  1.00 50.52           N  
ATOM     76  CA  LYS A  15      14.863  29.978  -3.793  1.00 51.85           C  
ATOM     77  C   LYS A  15      16.339  29.580  -3.646  1.00 50.78           C  
ATOM     78  O   LYS A  15      17.095  29.563  -4.623  1.00 51.43           O  
ATOM     79  CB  LYS A  15      14.735  31.498  -3.943  1.00 53.51           C  
ATOM     80  CG  LYS A  15      13.298  32.015  -4.135  1.00 55.77           C  
ATOM     81  CD  LYS A  15      13.282  33.518  -4.380  1.00 61.07           C  
ATOM     82  CE  LYS A  15      12.053  34.177  -3.742  1.00 64.38           C  
ATOM     83  NZ  LYS A  15      11.653  35.446  -4.397  1.00 64.21           N  
ATOM     84  N   LEU A  16      16.717  29.231  -2.420  1.00 48.31           N  
ATOM     85  CA  LEU A  16      18.047  28.769  -2.091  1.00 46.22           C  
ATOM     86  C   LEU A  16      18.291  27.317  -2.469  1.00 44.54           C  
ATOM     87  O   LEU A  16      19.406  26.808  -2.247  1.00 44.16           O  
ATOM     88  CB  LEU A  16      18.321  28.957  -0.588  1.00 45.79           C  
ATOM     89  CG  LEU A  16      18.205  30.397  -0.047  1.00 46.46           C  
ATOM     90  CD1 LEU A  16      18.247  30.373   1.474  1.00 46.01           C  
ATOM     91  CD2 LEU A  16      19.290  31.332  -0.626  1.00 45.48           C  
ATOM     92  N   ILE A  17      17.282  26.638  -3.011  1.00 43.07           N  
ATOM     93  CA  ILE A  17      17.498  25.292  -3.556  1.00 42.49           C  
ATOM     94  C   ILE A  17      17.503  25.425  -5.074  1.00 43.82           C  
ATOM     95  O   ILE A  17      16.608  26.067  -5.615  1.00 44.49           O  
ATOM     96  CB  ILE A  17      16.390  24.216  -3.119  1.00 41.88           C  
ATOM     97  CG1 ILE A  17      15.702  24.544  -1.782  1.00 40.02           C  
ATOM     98  CG2 ILE A  17      16.953  22.818  -3.086  1.00 41.67           C  
ATOM     99  CD1 ILE A  17      16.567  24.634  -0.592  1.00 35.23           C  
ATOM    100  N   HIS A  18      18.488  24.823  -5.758  1.00 44.50           N  
ATOM    101  CA  HIS A  18      18.604  24.911  -7.246  1.00 45.63           C  
ATOM    102  C   HIS A  18      18.565  23.559  -7.953  1.00 44.66           C  
ATOM    103  O   HIS A  18      18.851  22.516  -7.341  1.00 43.11           O  
ATOM    104  CB  HIS A  18      19.891  25.625  -7.680  1.00 46.77           C  
ATOM    105  CG  HIS A  18      19.851  27.114  -7.543  1.00 50.46           C  
ATOM    106  ND1 HIS A  18      20.255  27.960  -8.557  1.00 54.06           N  
ATOM    107  CD2 HIS A  18      19.477  27.911  -6.510  1.00 52.11           C  
ATOM    108  CE1 HIS A  18      20.119  29.215  -8.160  1.00 56.20           C  
ATOM    109  NE2 HIS A  18      19.658  29.212  -6.919  1.00 56.03           N  
ATOM    110  N   ASP A  19      18.234  23.599  -9.247  1.00 45.52           N  
ATOM    111  CA  ASP A  19      18.237  22.416 -10.114  1.00 46.19           C  
ATOM    112  C   ASP A  19      19.520  21.591  -9.913  1.00 45.02           C  
ATOM    113  O   ASP A  19      20.627  22.085 -10.135  1.00 45.10           O  
ATOM    114  CB  ASP A  19      18.088  22.813 -11.587  1.00 48.21           C  
ATOM    115  CG  ASP A  19      16.666  23.275 -11.966  1.00 50.70           C  
ATOM    116  OD1 ASP A  19      15.756  23.363 -11.108  1.00 53.71           O  
ATOM    117  OD2 ASP A  19      16.453  23.541 -13.165  1.00 53.16           O  
ATOM    118  N   GLY A  20      19.367  20.346  -9.462  1.00 42.94           N  
ATOM    119  CA  GLY A  20      20.505  19.450  -9.312  1.00 41.09           C  
ATOM    120  C   GLY A  20      21.123  19.361  -7.925  1.00 40.25           C  
ATOM    121  O   GLY A  20      22.089  18.637  -7.727  1.00 39.44           O  
ATOM    122  N   ASP A  21      20.566  20.062  -6.945  1.00 39.83           N  
ATOM    123  CA  ASP A  21      21.206  20.092  -5.652  1.00 39.25           C  
ATOM    124  C   ASP A  21      21.010  18.785  -4.909  1.00 38.17           C  
ATOM    125  O   ASP A  21      20.133  17.966  -5.244  1.00 38.42           O  
ATOM    126  CB  ASP A  21      20.704  21.242  -4.786  1.00 40.08           C  
ATOM    127  CG  ASP A  21      21.175  22.613  -5.273  1.00 43.54           C  
ATOM    128  OD1 ASP A  21      21.750  22.746  -6.374  1.00 50.07           O  
ATOM    129  OD2 ASP A  21      20.928  23.593  -4.558  1.00 46.34           O  
ATOM    130  N   THR A  22      21.860  18.600  -3.902  1.00 36.25           N  
ATOM    131  CA  THR A  22      21.704  17.557  -2.934  1.00 34.09           C  
ATOM    132  C   THR A  22      20.932  18.200  -1.787  1.00 33.22           C  
ATOM    133  O   THR A  22      21.381  19.194  -1.204  1.00 34.16           O  
ATOM    134  CB  THR A  22      23.098  16.998  -2.508  1.00 33.89           C  
ATOM    135  OG1 THR A  22      23.775  16.516  -3.673  1.00 33.76           O  
ATOM    136  CG2 THR A  22      22.939  15.821  -1.540  1.00 32.11           C  
ATOM    137  N   LEU A  23      19.744  17.683  -1.528  1.00 32.08           N  
ATOM    138  CA  LEU A  23      18.897  18.152  -0.441  1.00 31.85           C  
ATOM    139  C   LEU A  23      18.969  17.091   0.626  1.00 30.44           C  
ATOM    140  O   LEU A  23      18.818  15.887   0.335  1.00 29.73           O  
ATOM    141  CB  LEU A  23      17.439  18.222  -0.861  1.00 32.02           C  
ATOM    142  CG  LEU A  23      16.581  19.477  -0.631  1.00 35.84           C  
ATOM    143  CD1 LEU A  23      15.105  19.260  -1.028  1.00 35.03           C  
ATOM    144  CD2 LEU A  23      16.678  20.166   0.749  1.00 35.26           C  
ATOM    145  N   ILE A  24      19.180  17.535   1.856  1.00 29.35           N  
ATOM    146  CA  ILE A  24      19.193  16.648   2.997  1.00 28.36           C  
ATOM    147  C   ILE A  24      18.103  17.123   3.917  1.00 28.38           C  
ATOM    148  O   ILE A  24      18.004  18.309   4.243  1.00 29.92           O  
ATOM    149  CB  ILE A  24      20.537  16.667   3.724  1.00 28.19           C  
ATOM    150  CG1 ILE A  24      21.652  16.308   2.769  1.00 27.43           C  
ATOM    151  CG2 ILE A  24      20.552  15.615   4.833  1.00 28.32           C  
ATOM    152  CD1 ILE A  24      22.953  16.687   3.296  1.00 30.78           C  
ATOM    153  N   ALA A  25      17.265  16.200   4.336  1.00 27.77           N  
ATOM    154  CA  ALA A  25      16.004  16.577   4.939  1.00 27.01           C  
ATOM    155  C   ALA A  25      15.838  15.768   6.180  1.00 25.89           C  
ATOM    156  O   ALA A  25      15.982  14.523   6.150  1.00 23.85           O  
ATOM    157  CB  ALA A  25      14.842  16.296   3.963  1.00 26.63           C  
ATOM    158  N   GLY A  26      15.508  16.481   7.257  1.00 26.02           N  
ATOM    159  CA  GLY A  26      15.229  15.861   8.541  1.00 26.09           C  
ATOM    160  C   GLY A  26      13.947  15.083   8.481  1.00 27.43           C  
ATOM    161  O   GLY A  26      13.282  15.036   7.458  1.00 27.67           O  
ATOM    162  N   GLY A  27      13.599  14.454   9.597  1.00 28.67           N  
ATOM    163  CA  GLY A  27      12.334  13.758   9.718  1.00 27.45           C  
ATOM    164  C   GLY A  27      12.498  12.263   9.636  1.00 27.21           C  
ATOM    165  O   GLY A  27      13.353  11.724   8.910  1.00 25.55           O  
ATOM    166  N   PHE A  28      11.651  11.615  10.418  1.00 27.51           N  
ATOM    167  CA  PHE A  28      11.472  10.191  10.418  1.00 28.27           C  
ATOM    168  C   PHE A  28       9.948   9.909  10.236  1.00 29.20           C  
ATOM    169  O   PHE A  28       9.120  10.269  11.073  1.00 28.99           O  
ATOM    170  CB  PHE A  28      12.046   9.619  11.723  1.00 27.70           C  
ATOM    171  CG  PHE A  28      11.897   8.106  11.870  1.00 28.52           C  
ATOM    172  CD1 PHE A  28      10.741   7.544  12.443  1.00 29.14           C  
ATOM    173  CD2 PHE A  28      12.925   7.241  11.472  1.00 27.60           C  
ATOM    174  CE1 PHE A  28      10.608   6.150  12.598  1.00 28.10           C  
ATOM    175  CE2 PHE A  28      12.791   5.832  11.616  1.00 25.64           C  
ATOM    176  CZ  PHE A  28      11.623   5.308  12.168  1.00 28.21           C  
ATOM    177  N   GLY A  29       9.587   9.267   9.129  1.00 29.84           N  
ATOM    178  CA  GLY A  29       8.174   9.106   8.774  1.00 31.09           C  
ATOM    179  C   GLY A  29       7.587  10.472   8.457  1.00 32.51           C  
ATOM    180  O   GLY A  29       8.148  11.221   7.629  1.00 32.53           O  
ATOM    181  N   LEU A  30       6.474  10.805   9.119  1.00 33.33           N  
ATOM    182  CA  LEU A  30       5.903  12.150   9.045  1.00 34.28           C  
ATOM    183  C   LEU A  30       6.270  12.990  10.275  1.00 34.61           C  
ATOM    184  O   LEU A  30       5.737  14.055  10.507  1.00 35.71           O  
ATOM    185  CB  LEU A  30       4.379  12.084   8.831  1.00 34.59           C  
ATOM    186  CG  LEU A  30       3.940  11.387   7.527  1.00 34.47           C  
ATOM    187  CD1 LEU A  30       2.460  11.496   7.280  1.00 33.23           C  
ATOM    188  CD2 LEU A  30       4.738  11.856   6.279  1.00 34.81           C  
ATOM    189  N   CYS A  31       7.209  12.511  11.060  1.00 33.98           N  
ATOM    190  CA  CYS A  31       7.489  13.094  12.345  1.00 33.28           C  
ATOM    191  C   CYS A  31       8.762  13.895  12.252  1.00 32.06           C  
ATOM    192  O   CYS A  31       9.812  13.349  11.887  1.00 30.50           O  
ATOM    193  CB  CYS A  31       7.680  11.954  13.327  1.00 33.74           C  
ATOM    194  SG  CYS A  31       7.999  12.408  14.995  1.00 36.24           S  
ATOM    195  N   GLY A  32       8.679  15.183  12.576  1.00 31.58           N  
ATOM    196  CA  GLY A  32       9.875  16.013  12.666  1.00 31.04           C  
ATOM    197  C   GLY A  32      10.332  16.346  11.270  1.00 31.11           C  
ATOM    198  O   GLY A  32      11.546  16.432  10.968  1.00 30.77           O  
ATOM    199  N   ILE A  33       9.351  16.508  10.401  1.00 31.28           N  
ATOM    200  CA  ILE A  33       9.634  16.804   9.016  1.00 31.51           C  
ATOM    201  C   ILE A  33       9.389  18.270   8.700  1.00 32.64           C  
ATOM    202  O   ILE A  33       8.473  18.872   9.225  1.00 34.17           O  
ATOM    203  CB  ILE A  33       8.798  15.918   8.092  1.00 31.68           C  
ATOM    204  CG1 ILE A  33       7.284  16.157   8.329  1.00 30.62           C  
ATOM    205  CG2 ILE A  33       9.201  14.469   8.265  1.00 28.64           C  
ATOM    206  CD1 ILE A  33       6.440  16.051   7.069  1.00 29.22           C  
ATOM    207  N   PRO A  34      10.215  18.862   7.829  1.00 33.35           N  
ATOM    208  CA  PRO A  34       9.907  20.250   7.384  1.00 35.22           C  
ATOM    209  C   PRO A  34       8.764  20.346   6.316  1.00 37.49           C  
ATOM    210  O   PRO A  34       9.015  20.668   5.151  1.00 37.84           O  
ATOM    211  CB  PRO A  34      11.250  20.749   6.813  1.00 34.86           C  
ATOM    212  CG  PRO A  34      12.074  19.495   6.523  1.00 32.34           C  
ATOM    213  CD  PRO A  34      11.442  18.312   7.219  1.00 31.38           C  
ATOM    214  N   GLU A  35       7.525  20.072   6.718  1.00 39.53           N  
ATOM    215  CA  GLU A  35       6.362  20.139   5.803  1.00 41.62           C  
ATOM    216  C   GLU A  35       6.258  21.431   4.995  1.00 42.44           C  
ATOM    217  O   GLU A  35       5.939  21.395   3.812  1.00 42.81           O  
ATOM    218  CB  GLU A  35       5.052  19.912   6.561  1.00 41.85           C  
ATOM    219  CG  GLU A  35       4.951  20.680   7.876  1.00 44.63           C  
ATOM    220  CD  GLU A  35       3.557  20.636   8.467  1.00 48.44           C  
ATOM    221  OE1 GLU A  35       3.351  19.959   9.503  1.00 49.32           O  
ATOM    222  OE2 GLU A  35       2.657  21.273   7.888  1.00 49.88           O  
ATOM    223  N   GLN A  36       6.521  22.566   5.631  1.00 43.49           N  
ATOM    224  CA  GLN A  36       6.353  23.865   4.960  1.00 44.95           C  
ATOM    225  C   GLN A  36       7.442  24.108   3.929  1.00 43.77           C  
ATOM    226  O   GLN A  36       7.131  24.471   2.797  1.00 44.46           O  
ATOM    227  CB  GLN A  36       6.223  25.037   5.951  1.00 45.53           C  
ATOM    228  CG  GLN A  36       4.910  25.039   6.725  1.00 48.53           C  
ATOM    229  CD  GLN A  36       3.675  25.121   5.813  1.00 54.58           C  
ATOM    230  OE1 GLN A  36       2.955  24.135   5.638  1.00 54.91           O  
ATOM    231  NE2 GLN A  36       3.426  26.297   5.230  1.00 56.51           N  
ATOM    232  N   LEU A  37       8.700  23.864   4.291  1.00 41.79           N  
ATOM    233  CA  LEU A  37       9.772  24.026   3.321  1.00 40.82           C  
ATOM    234  C   LEU A  37       9.543  23.163   2.081  1.00 40.60           C  
ATOM    235  O   LEU A  37       9.783  23.614   0.951  1.00 40.65           O  
ATOM    236  CB  LEU A  37      11.140  23.721   3.911  1.00 39.55           C  
ATOM    237  CG  LEU A  37      12.088  24.778   4.519  1.00 40.61           C  
ATOM    238  CD1 LEU A  37      11.839  26.254   4.103  1.00 38.09           C  
ATOM    239  CD2 LEU A  37      12.184  24.639   6.042  1.00 39.46           C  
ATOM    240  N   ILE A  38       9.081  21.934   2.304  1.00 39.97           N  
ATOM    241  CA  ILE A  38       8.835  21.000   1.230  1.00 40.08           C  
ATOM    242  C   ILE A  38       7.749  21.498   0.294  1.00 41.99           C  
ATOM    243  O   ILE A  38       7.858  21.349  -0.930  1.00 42.23           O  
ATOM    244  CB  ILE A  38       8.483  19.583   1.766  1.00 39.47           C  
ATOM    245  CG1 ILE A  38       9.755  18.904   2.291  1.00 37.46           C  
ATOM    246  CG2 ILE A  38       7.806  18.724   0.657  1.00 37.03           C  
ATOM    247  CD1 ILE A  38       9.496  17.596   3.075  1.00 37.01           C  
ATOM    248  N   LEU A  39       6.706  22.084   0.865  1.00 43.85           N  
ATOM    249  CA  LEU A  39       5.617  22.604   0.065  1.00 46.72           C  
ATOM    250  C   LEU A  39       6.141  23.711  -0.808  1.00 48.05           C  
ATOM    251  O   LEU A  39       5.842  23.771  -2.012  1.00 49.01           O  
ATOM    252  CB  LEU A  39       4.484  23.130   0.939  1.00 47.42           C  
ATOM    253  CG  LEU A  39       3.592  22.046   1.556  1.00 48.35           C  
ATOM    254  CD1 LEU A  39       2.606  22.655   2.542  1.00 48.16           C  
ATOM    255  CD2 LEU A  39       2.837  21.306   0.482  1.00 49.13           C  
ATOM    256  N   SER A  40       6.939  24.586  -0.206  1.00 48.65           N  
ATOM    257  CA  SER A  40       7.467  25.732  -0.932  1.00 50.20           C  
ATOM    258  C   SER A  40       8.354  25.264  -2.068  1.00 49.30           C  
ATOM    259  O   SER A  40       8.326  25.845  -3.168  1.00 50.06           O  
ATOM    260  CB  SER A  40       8.183  26.714  -0.004  1.00 50.22           C  
ATOM    261  OG  SER A  40       7.222  27.568   0.599  1.00 52.06           O  
ATOM    262  N   ILE A  41       9.090  24.186  -1.803  1.00 47.33           N  
ATOM    263  CA  ILE A  41       9.964  23.575  -2.791  1.00 46.38           C  
ATOM    264  C   ILE A  41       9.125  23.022  -3.926  1.00 47.87           C  
ATOM    265  O   ILE A  41       9.382  23.363  -5.082  1.00 49.26           O  
ATOM    266  CB  ILE A  41      10.917  22.553  -2.167  1.00 45.09           C  
ATOM    267  CG1 ILE A  41      12.129  23.272  -1.574  1.00 42.39           C  
ATOM    268  CG2 ILE A  41      11.389  21.516  -3.193  1.00 45.44           C  
ATOM    269  CD1 ILE A  41      12.876  22.460  -0.593  1.00 34.38           C  
ATOM    270  N   ARG A  42       8.112  22.218  -3.616  0.50 48.64           N  
ATOM    272  CA  ARG A  42       7.228  21.725  -4.669  0.50 50.29           C  
ATOM    274  C   ARG A  42       6.754  22.866  -5.586  0.50 52.54           C  
ATOM    276  O   ARG A  42       6.912  22.770  -6.800  0.50 53.40           O  
ATOM    278  CB  ARG A  42       6.060  20.900  -4.108  0.50 49.74           C  
ATOM    280  CG  ARG A  42       5.125  20.375  -5.174  0.50 49.29           C  
ATOM    282  CD  ARG A  42       3.985  19.588  -4.575  0.50 48.88           C  
ATOM    284  NE  ARG A  42       4.150  18.141  -4.737  0.50 45.46           N  
ATOM    286  CZ  ARG A  42       3.283  17.350  -5.365  0.50 42.81           C  
ATOM    288  NH1 ARG A  42       2.185  17.856  -5.893  0.50 43.90           N  
ATOM    290  NH2 ARG A  42       3.512  16.054  -5.464  0.50 40.30           N  
ATOM    292  N   ASP A  43       6.230  23.950  -5.016  1.00 54.06           N  
ATOM    293  CA  ASP A  43       5.783  25.110  -5.804  1.00 57.31           C  
ATOM    294  C   ASP A  43       6.853  25.762  -6.676  1.00 58.08           C  
ATOM    295  O   ASP A  43       6.560  26.160  -7.793  1.00 58.86           O  
ATOM    296  CB  ASP A  43       5.156  26.160  -4.896  1.00 58.58           C  
ATOM    297  CG  ASP A  43       3.965  25.622  -4.125  1.00 61.63           C  
ATOM    298  OD1 ASP A  43       3.575  24.452  -4.336  1.00 63.52           O  
ATOM    299  OD2 ASP A  43       3.416  26.369  -3.292  1.00 65.86           O  
ATOM    300  N   GLN A  44       8.090  25.854  -6.176  1.00 57.89           N  
ATOM    301  CA  GLN A  44       9.191  26.441  -6.961  1.00 58.00           C  
ATOM    302  C   GLN A  44       9.495  25.627  -8.218  1.00 57.68           C  
ATOM    303  O   GLN A  44       9.975  26.181  -9.210  1.00 58.36           O  
ATOM    304  CB  GLN A  44      10.471  26.651  -6.136  1.00 57.23           C  
ATOM    305  CG  GLN A  44      10.251  27.129  -4.699  1.00 59.84           C  
ATOM    306  CD  GLN A  44       9.527  28.514  -4.533  1.00 66.00           C  
ATOM    307  OE1 GLN A  44      10.132  29.581  -4.759  1.00 68.65           O  
ATOM    308  NE2 GLN A  44       8.255  28.484  -4.069  1.00 64.28           N  
ATOM    309  N   GLY A  45       9.209  24.320  -8.177  1.00 56.24           N  
ATOM    310  CA  GLY A  45       9.355  23.446  -9.352  1.00 54.82           C  
ATOM    311  C   GLY A  45      10.771  22.941  -9.608  1.00 53.40           C  
ATOM    312  O   GLY A  45      11.029  22.249 -10.584  1.00 53.87           O  
ATOM    313  N   VAL A  46      11.694  23.289  -8.730  1.00 51.27           N  
ATOM    314  CA  VAL A  46      13.084  22.912  -8.869  1.00 49.85           C  
ATOM    315  C   VAL A  46      13.233  21.414  -9.236  1.00 49.27           C  
ATOM    316  O   VAL A  46      12.427  20.598  -8.805  1.00 49.17           O  
ATOM    317  CB  VAL A  46      13.796  23.238  -7.529  1.00 49.41           C  
ATOM    318  CG1 VAL A  46      13.787  22.035  -6.598  1.00 46.51           C  
ATOM    319  CG2 VAL A  46      15.196  23.729  -7.785  1.00 49.04           C  
ATOM    320  N   LYS A  47      14.239  21.035 -10.021  1.00 49.05           N  
ATOM    321  CA  LYS A  47      14.304  19.627 -10.468  1.00 48.52           C  
ATOM    322  C   LYS A  47      15.667  18.935 -10.387  1.00 46.95           C  
ATOM    323  O   LYS A  47      16.647  19.522  -9.927  1.00 47.28           O  
ATOM    324  CB  LYS A  47      13.699  19.469 -11.863  1.00 50.04           C  
ATOM    325  CG  LYS A  47      14.044  20.585 -12.800  1.00 53.09           C  
ATOM    326  CD  LYS A  47      13.967  20.170 -14.260  1.00 57.03           C  
ATOM    327  CE  LYS A  47      14.934  21.050 -15.089  1.00 60.72           C  
ATOM    328  NZ  LYS A  47      14.803  20.958 -16.599  1.00 62.24           N  
ATOM    329  N   ASP A  48      15.703  17.679 -10.827  1.00 45.23           N  
ATOM    330  CA  ASP A  48      16.845  16.767 -10.659  1.00 43.62           C  
ATOM    331  C   ASP A  48      17.511  16.788  -9.282  1.00 41.14           C  
ATOM    332  O   ASP A  48      18.733  16.735  -9.143  1.00 40.87           O  
ATOM    333  CB  ASP A  48      17.883  16.965 -11.755  1.00 45.10           C  
ATOM    334  CG  ASP A  48      17.262  17.002 -13.146  1.00 49.13           C  
ATOM    335  OD1 ASP A  48      16.366  16.169 -13.425  1.00 52.71           O  
ATOM    336  OD2 ASP A  48      17.685  17.855 -13.972  1.00 51.95           O  
ATOM    337  N   LEU A  49      16.701  16.833  -8.251  1.00 38.74           N  
ATOM    338  CA  LEU A  49      17.239  16.730  -6.933  1.00 36.69           C  
ATOM    339  C   LEU A  49      17.705  15.307  -6.611  1.00 35.96           C  
ATOM    340  O   LEU A  49      17.081  14.328  -7.043  1.00 35.83           O  
ATOM    341  CB  LEU A  49      16.182  17.140  -5.946  1.00 36.01           C  
ATOM    342  CG  LEU A  49      15.724  18.548  -6.188  1.00 35.24           C  
ATOM    343  CD1 LEU A  49      14.705  18.822  -5.139  1.00 35.80           C  
ATOM    344  CD2 LEU A  49      16.889  19.510  -6.090  1.00 37.57           C  
ATOM    345  N   THR A  50      18.834  15.217  -5.900  1.00 34.23           N  
ATOM    346  CA  THR A  50      19.233  14.013  -5.223  1.00 33.21           C  
ATOM    347  C   THR A  50      18.765  14.328  -3.804  1.00 32.31           C  
ATOM    348  O   THR A  50      19.195  15.321  -3.233  1.00 32.35           O  
ATOM    349  CB  THR A  50      20.773  13.856  -5.235  1.00 33.72           C  
ATOM    350  OG1 THR A  50      21.222  13.542  -6.554  1.00 37.31           O  
ATOM    351  CG2 THR A  50      21.256  12.767  -4.264  1.00 31.23           C  
ATOM    352  N   VAL A  51      17.849  13.549  -3.241  1.00 30.63           N  
ATOM    353  CA  VAL A  51      17.438  13.869  -1.880  1.00 29.64           C  
ATOM    354  C   VAL A  51      17.827  12.724  -0.962  1.00 28.28           C  
ATOM    355  O   VAL A  51      17.641  11.530  -1.297  1.00 27.65           O  
ATOM    356  CB  VAL A  51      15.916  14.354  -1.739  1.00 30.57           C  
ATOM    357  CG1 VAL A  51      15.287  14.583  -3.116  1.00 31.92           C  
ATOM    358  CG2 VAL A  51      15.023  13.430  -0.875  1.00 28.01           C  
ATOM    359  N   VAL A  52      18.409  13.139   0.157  1.00 26.12           N  
ATOM    360  CA  VAL A  52      18.868  12.292   1.213  1.00 24.62           C  
ATOM    361  C   VAL A  52      17.953  12.525   2.392  1.00 24.91           C  
ATOM    362  O   VAL A  52      17.935  13.606   2.988  1.00 25.11           O  
ATOM    363  CB  VAL A  52      20.257  12.747   1.670  1.00 24.20           C  
ATOM    364  CG1 VAL A  52      20.805  11.812   2.743  1.00 20.18           C  
ATOM    365  CG2 VAL A  52      21.194  12.894   0.485  1.00 23.91           C  
ATOM    366  N   SER A  53      17.193  11.518   2.746  1.00 24.70           N  
ATOM    367  CA  SER A  53      16.397  11.629   3.932  1.00 25.07           C  
ATOM    368  C   SER A  53      16.094  10.207   4.346  1.00 25.45           C  
ATOM    369  O   SER A  53      16.140   9.287   3.530  1.00 24.96           O  
ATOM    370  CB  SER A  53      15.111  12.404   3.626  1.00 25.23           C  
ATOM    371  OG  SER A  53      14.368  12.700   4.784  1.00 23.85           O  
ATOM    372  N   ASN A  54      15.786  10.026   5.619  1.00 25.97           N  
ATOM    373  CA  ASN A  54      15.513   8.690   6.093  1.00 26.49           C  
ATOM    374  C   ASN A  54      14.442   7.921   5.309  1.00 27.78           C  
ATOM    375  O   ASN A  54      14.674   6.775   4.898  1.00 27.90           O  
ATOM    376  CB  ASN A  54      15.171   8.639   7.559  1.00 25.30           C  
ATOM    377  CG  ASN A  54      15.109   7.241   8.009  1.00 24.56           C  
ATOM    378  OD1 ASN A  54      16.034   6.477   7.732  1.00 20.03           O  
ATOM    379  ND2 ASN A  54      13.991   6.844   8.593  1.00 22.17           N  
ATOM    380  N   ASN A  55      13.273   8.549   5.148  1.00 28.71           N  
ATOM    381  CA  ASN A  55      12.198   8.021   4.302  1.00 28.99           C  
ATOM    382  C   ASN A  55      11.806   9.075   3.249  1.00 29.32           C  
ATOM    383  O   ASN A  55      12.362  10.187   3.192  1.00 28.19           O  
ATOM    384  CB  ASN A  55      10.962   7.670   5.150  1.00 29.43           C  
ATOM    385  CG  ASN A  55      11.310   7.101   6.524  1.00 29.59           C  
ATOM    386  OD1 ASN A  55      11.536   7.850   7.467  1.00 31.16           O  
ATOM    387  ND2 ASN A  55      11.275   5.778   6.657  1.00 29.48           N  
ATOM    388  N   CYS A  56      10.809   8.737   2.444  1.00 30.25           N  
ATOM    389  CA  CYS A  56      10.248   9.649   1.449  1.00 30.38           C  
ATOM    390  C   CYS A  56       8.822  10.065   1.821  1.00 30.63           C  
ATOM    391  O   CYS A  56       7.909  10.006   0.970  1.00 31.41           O  
ATOM    392  CB  CYS A  56      10.257   8.972   0.091  1.00 30.25           C  
ATOM    393  SG  CYS A  56       9.967  10.108  -1.288  1.00 34.41           S  
ATOM    394  N   GLY A  57       8.628  10.479   3.081  1.00 29.52           N  
ATOM    395  CA  GLY A  57       7.313  10.890   3.581  1.00 30.17           C  
ATOM    396  C   GLY A  57       6.233   9.874   3.271  1.00 31.60           C  
ATOM    397  O   GLY A  57       6.451   8.667   3.400  1.00 30.54           O  
ATOM    398  N   VAL A  58       5.070  10.361   2.865  1.00 33.38           N  
ATOM    399  CA  VAL A  58       4.046   9.516   2.255  1.00 36.59           C  
ATOM    400  C   VAL A  58       3.809  10.040   0.834  1.00 38.44           C  
ATOM    401  O   VAL A  58       4.348  11.070   0.462  1.00 39.07           O  
ATOM    402  CB  VAL A  58       2.712   9.467   3.070  1.00 37.29           C  
ATOM    403  CG1 VAL A  58       2.848   8.546   4.259  1.00 35.51           C  
ATOM    404  CG2 VAL A  58       2.252  10.865   3.477  1.00 36.19           C  
ATOM    405  N   ASP A  59       3.016   9.365   0.023  1.00 41.08           N  
ATOM    406  CA  ASP A  59       2.853   9.843  -1.374  1.00 44.30           C  
ATOM    407  C   ASP A  59       2.073  11.136  -1.451  1.00 45.20           C  
ATOM    408  O   ASP A  59       2.045  11.791  -2.479  1.00 45.95           O  
ATOM    409  CB  ASP A  59       2.181   8.795  -2.234  1.00 45.12           C  
ATOM    410  CG  ASP A  59       1.096   8.070  -1.504  1.00 49.50           C  
ATOM    411  OD1 ASP A  59       0.532   8.636  -0.523  1.00 50.27           O  
ATOM    412  OD2 ASP A  59       0.814   6.921  -1.917  1.00 56.44           O  
ATOM    413  N   ASP A  60       1.512  11.487  -0.304  1.00 46.12           N  
ATOM    414  CA  ASP A  60       0.595  12.573  -0.055  1.00 47.28           C  
ATOM    415  C   ASP A  60       1.312  13.745   0.642  1.00 45.39           C  
ATOM    416  O   ASP A  60       0.953  14.881   0.476  1.00 45.48           O  
ATOM    417  CB  ASP A  60      -0.402  11.999   0.947  1.00 48.80           C  
ATOM    418  CG  ASP A  60      -1.790  12.191   0.536  1.00 54.64           C  
ATOM    419  OD1 ASP A  60      -2.031  13.193  -0.153  1.00 61.00           O  
ATOM    420  OD2 ASP A  60      -2.652  11.351   0.897  1.00 60.05           O  
ATOM    421  N   TRP A  61       2.313  13.460   1.463  1.00 42.72           N  
ATOM    422  CA  TRP A  61       2.806  14.466   2.391  1.00 40.58           C  
ATOM    423  C   TRP A  61       4.284  14.282   2.574  1.00 38.19           C  
ATOM    424  O   TRP A  61       4.813  13.188   2.334  1.00 37.68           O  
ATOM    425  CB  TRP A  61       2.062  14.377   3.737  1.00 40.98           C  
ATOM    426  CG  TRP A  61       2.073  15.638   4.597  1.00 41.38           C  
ATOM    427  CD1 TRP A  61       2.320  15.696   5.943  1.00 41.26           C  
ATOM    428  CD2 TRP A  61       1.815  16.996   4.179  1.00 40.07           C  
ATOM    429  NE1 TRP A  61       2.237  17.000   6.389  1.00 42.14           N  
ATOM    430  CE2 TRP A  61       1.929  17.818   5.331  1.00 42.04           C  
ATOM    431  CE3 TRP A  61       1.482  17.590   2.961  1.00 40.82           C  
ATOM    432  CZ2 TRP A  61       1.740  19.217   5.294  1.00 40.59           C  
ATOM    433  CZ3 TRP A  61       1.296  18.978   2.923  1.00 43.21           C  
ATOM    434  CH2 TRP A  61       1.432  19.772   4.091  1.00 42.05           C  
ATOM    435  N   GLY A  62       4.954  15.362   2.959  1.00 36.79           N  
ATOM    436  CA  GLY A  62       6.411  15.370   3.054  1.00 35.30           C  
ATOM    437  C   GLY A  62       7.070  15.120   1.704  1.00 34.61           C  
ATOM    438  O   GLY A  62       6.576  15.547   0.652  1.00 35.36           O  
ATOM    439  N   LEU A  63       8.164  14.385   1.728  1.00 32.94           N  
ATOM    440  CA  LEU A  63       9.039  14.281   0.573  1.00 32.21           C  
ATOM    441  C   LEU A  63       8.332  13.673  -0.636  1.00 33.08           C  
ATOM    442  O   LEU A  63       8.762  13.843  -1.788  1.00 32.65           O  
ATOM    443  CB  LEU A  63      10.261  13.480   0.955  1.00 30.41           C  
ATOM    444  CG  LEU A  63      11.625  14.160   1.108  1.00 30.43           C  
ATOM    445  CD1 LEU A  63      11.614  15.662   1.094  1.00 28.49           C  
ATOM    446  CD2 LEU A  63      12.428  13.606   2.295  1.00 26.28           C  
ATOM    447  N   GLY A  64       7.231  12.984  -0.354  1.00 34.08           N  
ATOM    448  CA  GLY A  64       6.451  12.278  -1.378  1.00 35.97           C  
ATOM    449  C   GLY A  64       5.866  13.268  -2.335  1.00 37.46           C  
ATOM    450  O   GLY A  64       5.585  12.942  -3.469  1.00 37.79           O  
ATOM    451  N   LEU A  65       5.733  14.507  -1.883  1.00 39.08           N  
ATOM    452  CA  LEU A  65       5.268  15.576  -2.741  1.00 40.79           C  
ATOM    453  C   LEU A  65       6.299  15.914  -3.807  1.00 40.42           C  
ATOM    454  O   LEU A  65       5.965  16.270  -4.911  1.00 41.97           O  
ATOM    455  CB  LEU A  65       4.900  16.811  -1.922  1.00 41.28           C  
ATOM    456  CG  LEU A  65       3.647  16.684  -1.055  1.00 43.74           C  
ATOM    457  CD1 LEU A  65       3.435  17.938  -0.207  1.00 44.08           C  
ATOM    458  CD2 LEU A  65       2.404  16.355  -1.887  1.00 45.04           C  
ATOM    459  N   LEU A  66       7.559  15.808  -3.480  1.00 39.16           N  
ATOM    460  CA  LEU A  66       8.577  16.078  -4.469  1.00 39.33           C  
ATOM    461  C   LEU A  66       8.602  14.972  -5.525  1.00 40.84           C  
ATOM    462  O   LEU A  66       8.723  15.217  -6.733  1.00 41.13           O  
ATOM    463  CB  LEU A  66       9.926  16.193  -3.759  1.00 37.29           C  
ATOM    464  CG  LEU A  66      10.308  17.604  -3.315  1.00 35.37           C  
ATOM    465  CD1 LEU A  66       9.122  18.480  -2.917  1.00 35.92           C  
ATOM    466  CD2 LEU A  66      11.325  17.572  -2.237  1.00 31.39           C  
ATOM    467  N   LEU A  67       8.484  13.745  -5.033  1.00 42.34           N  
ATOM    468  CA  LEU A  67       8.496  12.554  -5.846  1.00 43.99           C  
ATOM    469  C   LEU A  67       7.368  12.659  -6.847  1.00 46.63           C  
ATOM    470  O   LEU A  67       7.583  12.491  -8.054  1.00 48.91           O  
ATOM    471  CB  LEU A  67       8.330  11.344  -4.935  1.00 43.29           C  
ATOM    472  CG  LEU A  67       8.185   9.949  -5.513  1.00 44.59           C  
ATOM    473  CD1 LEU A  67       9.467   9.509  -6.173  1.00 46.60           C  
ATOM    474  CD2 LEU A  67       7.862   8.997  -4.392  1.00 47.02           C  
ATOM    475  N   ALA A  68       6.178  13.005  -6.368  1.00 48.18           N  
ATOM    476  CA  ALA A  68       5.002  12.976  -7.228  1.00 50.05           C  
ATOM    477  C   ALA A  68       4.912  14.162  -8.195  1.00 51.22           C  
ATOM    478  O   ALA A  68       4.123  14.128  -9.142  1.00 53.32           O  
ATOM    479  CB  ALA A  68       3.715  12.819  -6.392  1.00 49.97           C  
ATOM    480  N   ASN A  69       5.708  15.201  -7.968  1.00 50.64           N  
ATOM    481  CA  ASN A  69       5.828  16.304  -8.940  1.00 51.22           C  
ATOM    482  C   ASN A  69       7.006  16.091  -9.932  1.00 50.58           C  
ATOM    483  O   ASN A  69       7.317  16.955 -10.744  1.00 50.67           O  
ATOM    484  CB  ASN A  69       5.944  17.658  -8.210  1.00 50.94           C  
ATOM    485  CG  ASN A  69       5.708  18.859  -9.137  1.00 52.89           C  
ATOM    486  OD1 ASN A  69       4.998  18.756 -10.133  1.00 55.12           O  
ATOM    487  ND2 ASN A  69       6.292  20.006  -8.794  1.00 51.76           N  
ATOM    488  N   LYS A  70       7.674  14.940  -9.807  1.00 49.60           N  
ATOM    489  CA  LYS A  70       8.802  14.535 -10.672  1.00 48.33           C  
ATOM    490  C   LYS A  70      10.116  15.305 -10.476  1.00 46.16           C  
ATOM    491  O   LYS A  70      10.892  15.459 -11.408  1.00 45.67           O  
ATOM    492  CB  LYS A  70       8.348  14.514 -12.139  1.00 49.81           C  
ATOM    493  CG  LYS A  70       7.358  13.395 -12.414  1.00 52.49           C  
ATOM    494  CD  LYS A  70       6.517  13.739 -13.607  1.00 60.66           C  
ATOM    495  CE  LYS A  70       6.030  12.474 -14.337  1.00 64.14           C  
ATOM    496  NZ  LYS A  70       5.141  12.858 -15.485  1.00 64.99           N  
ATOM    497  N   GLN A  71      10.378  15.714  -9.233  1.00 44.18           N  
ATOM    498  CA  GLN A  71      11.462  16.652  -8.893  1.00 42.70           C  
ATOM    499  C   GLN A  71      12.757  15.970  -8.469  1.00 40.00           C  
ATOM    500  O   GLN A  71      13.789  16.590  -8.352  1.00 38.93           O  
ATOM    501  CB  GLN A  71      10.974  17.691  -7.848  1.00 42.59           C  
ATOM    502  CG  GLN A  71       9.986  18.716  -8.437  1.00 44.24           C  
ATOM    503  CD  GLN A  71       9.437  19.787  -7.439  1.00 48.80           C  
ATOM    504  OE1 GLN A  71       8.216  20.034  -7.401  1.00 51.83           O  
ATOM    505  NE2 GLN A  71      10.331  20.447  -6.667  1.00 47.51           N  
ATOM    506  N   ILE A  72      12.700  14.668  -8.280  1.00 39.33           N  
ATOM    507  CA  ILE A  72      13.835  13.926  -7.735  1.00 37.40           C  
ATOM    508  C   ILE A  72      14.461  12.985  -8.756  1.00 38.04           C  
ATOM    509  O   ILE A  72      13.793  12.107  -9.294  1.00 37.35           O  
ATOM    510  CB  ILE A  72      13.426  13.046  -6.548  1.00 36.74           C  
ATOM    511  CG1 ILE A  72      12.570  13.819  -5.529  1.00 35.07           C  
ATOM    512  CG2 ILE A  72      14.687  12.417  -5.915  1.00 34.92           C  
ATOM    513  CD1 ILE A  72      11.957  12.893  -4.441  1.00 32.54           C  
ATOM    514  N   LYS A  73      15.754  13.182  -8.994  1.00 38.80           N  
ATOM    515  CA  LYS A  73      16.545  12.315  -9.835  1.00 39.66           C  
ATOM    516  C   LYS A  73      16.932  11.052  -9.051  1.00 38.45           C  
ATOM    517  O   LYS A  73      16.900   9.936  -9.575  1.00 39.02           O  
ATOM    518  CB  LYS A  73      17.789  13.070 -10.297  1.00 40.33           C  
ATOM    519  CG  LYS A  73      18.794  12.222 -11.080  1.00 44.52           C  
ATOM    520  CD  LYS A  73      19.325  12.951 -12.342  1.00 49.54           C  
ATOM    521  CE  LYS A  73      20.783  13.425 -12.232  1.00 51.29           C  
ATOM    522  NZ  LYS A  73      21.138  14.308 -13.438  1.00 55.91           N  
ATOM    523  N   LYS A  74      17.280  11.242  -7.791  1.00 36.12           N  
ATOM    524  CA  LYS A  74      17.812  10.179  -7.012  1.00 35.11           C  
ATOM    525  C   LYS A  74      17.435  10.328  -5.529  1.00 33.94           C  
ATOM    526  O   LYS A  74      17.470  11.438  -4.998  1.00 33.68           O  
ATOM    527  CB  LYS A  74      19.324  10.160  -7.189  1.00 35.28           C  
ATOM    528  CG  LYS A  74      20.002   9.010  -6.505  1.00 35.61           C  
ATOM    529  CD  LYS A  74      21.461   9.276  -6.384  1.00 39.22           C  
ATOM    530  CE  LYS A  74      22.190   7.983  -6.069  1.00 42.63           C  
ATOM    531  NZ  LYS A  74      23.409   8.313  -5.304  1.00 44.81           N  
ATOM    532  N   MET A  75      17.056   9.211  -4.898  1.00 32.65           N  
ATOM    533  CA  MET A  75      16.744   9.132  -3.473  1.00 32.04           C  
ATOM    534  C   MET A  75      17.796   8.313  -2.723  1.00 31.13           C  
ATOM    535  O   MET A  75      18.144   7.186  -3.131  1.00 31.24           O  
ATOM    536  CB  MET A  75      15.383   8.466  -3.228  1.00 32.52           C  
ATOM    537  CG  MET A  75      14.229   9.427  -2.955  1.00 34.42           C  
ATOM    538  SD  MET A  75      14.251  10.237  -1.318  1.00 36.18           S  
ATOM    539  CE  MET A  75      13.754   8.821  -0.361  1.00 43.67           C  
ATOM    540  N   ILE A  76      18.275   8.869  -1.617  1.00 28.70           N  
ATOM    541  CA  ILE A  76      19.084   8.115  -0.711  1.00 27.31           C  
ATOM    542  C   ILE A  76      18.333   8.044   0.625  1.00 26.80           C  
ATOM    543  O   ILE A  76      18.098   9.064   1.287  1.00 25.46           O  
ATOM    544  CB  ILE A  76      20.510   8.733  -0.571  1.00 27.66           C  
ATOM    545  CG1 ILE A  76      21.195   8.722  -1.924  1.00 28.32           C  
ATOM    546  CG2 ILE A  76      21.376   7.974   0.440  1.00 25.04           C  
ATOM    547  CD1 ILE A  76      22.243   9.765  -2.075  1.00 28.07           C  
ATOM    548  N   ALA A  77      17.994   6.817   1.015  1.00 26.54           N  
ATOM    549  CA  ALA A  77      17.087   6.557   2.143  1.00 26.78           C  
ATOM    550  C   ALA A  77      17.291   5.147   2.692  1.00 26.74           C  
ATOM    551  O   ALA A  77      17.929   4.305   2.058  1.00 26.84           O  
ATOM    552  CB  ALA A  77      15.616   6.735   1.687  1.00 26.73           C  
ATOM    553  N   SER A  78      16.724   4.886   3.863  1.00 27.97           N  
ATOM    554  CA  SER A  78      16.821   3.570   4.487  1.00 29.04           C  
ATOM    555  C   SER A  78      15.566   2.748   4.226  1.00 31.18           C  
ATOM    556  O   SER A  78      15.598   1.512   4.250  1.00 30.62           O  
ATOM    557  CB  SER A  78      17.069   3.695   5.986  1.00 27.68           C  
ATOM    558  OG  SER A  78      15.845   3.815   6.680  1.00 30.06           O  
ATOM    559  N   TYR A  79      14.461   3.441   3.984  1.00 33.91           N  
ATOM    560  CA  TYR A  79      13.165   2.782   3.876  1.00 37.58           C  
ATOM    561  C   TYR A  79      12.174   3.622   3.081  1.00 39.75           C  
ATOM    562  O   TYR A  79      12.055   4.832   3.305  1.00 39.43           O  
ATOM    563  CB  TYR A  79      12.598   2.500   5.253  1.00 37.81           C  
ATOM    564  CG  TYR A  79      11.330   1.699   5.218  1.00 40.08           C  
ATOM    565  CD1 TYR A  79      11.348   0.352   4.875  1.00 42.91           C  
ATOM    566  CD2 TYR A  79      10.107   2.286   5.530  1.00 41.43           C  
ATOM    567  CE1 TYR A  79      10.177  -0.391   4.839  1.00 44.33           C  
ATOM    568  CE2 TYR A  79       8.934   1.559   5.491  1.00 42.63           C  
ATOM    569  CZ  TYR A  79       8.975   0.220   5.148  1.00 45.19           C  
ATOM    570  OH  TYR A  79       7.807  -0.511   5.116  1.00 48.23           O  
ATOM    571  N   VAL A  80      11.464   2.972   2.157  1.00 43.61           N  
ATOM    572  CA  VAL A  80      10.607   3.683   1.211  1.00 47.24           C  
ATOM    573  C   VAL A  80       9.148   3.727   1.651  1.00 49.77           C  
ATOM    574  O   VAL A  80       8.526   4.798   1.653  1.00 51.03           O  
ATOM    575  CB  VAL A  80      10.673   3.026  -0.175  1.00 48.19           C  
ATOM    576  CG1 VAL A  80       9.266   2.646  -0.670  1.00 49.69           C  
ATOM    577  CG2 VAL A  80      11.391   3.936  -1.146  1.00 47.58           C  
ATOM    578  N   GLY A  81       8.593   2.570   2.002  1.00 52.04           N  
ATOM    579  CA  GLY A  81       7.208   2.517   2.455  1.00 56.26           C  
ATOM    580  C   GLY A  81       6.217   2.180   1.350  1.00 59.75           C  
ATOM    581  O   GLY A  81       6.465   1.301   0.508  1.00 60.37           O  
ATOM    582  N   GLU A  82       5.091   2.887   1.343  1.00 62.68           N  
ATOM    583  CA  GLU A  82       3.955   2.501   0.502  1.00 65.94           C  
ATOM    584  C   GLU A  82       3.687   3.490  -0.629  1.00 66.06           C  
ATOM    585  O   GLU A  82       2.545   3.857  -0.884  1.00 68.10           O  
ATOM    586  CB  GLU A  82       2.696   2.323   1.365  1.00 67.28           C  
ATOM    587  CG  GLU A  82       2.845   2.862   2.800  1.00 69.24           C  
ATOM    588  CD  GLU A  82       3.215   1.762   3.798  1.00 71.74           C  
ATOM    589  OE1 GLU A  82       4.429   1.572   4.065  1.00 71.53           O  
ATOM    590  OE2 GLU A  82       2.293   1.085   4.311  1.00 73.38           O  
ATOM    591  N   ASN A  83       4.738   3.907  -1.317  1.00 64.73           N  
ATOM    592  CA  ASN A  83       4.589   4.858  -2.402  1.00 64.68           C  
ATOM    593  C   ASN A  83       4.402   4.205  -3.779  1.00 66.56           C  
ATOM    594  O   ASN A  83       5.352   3.713  -4.394  1.00 66.40           O  
ATOM    595  CB  ASN A  83       5.771   5.826  -2.413  1.00 63.00           C  
ATOM    596  CG  ASN A  83       5.422   7.166  -3.017  1.00 60.90           C  
ATOM    597  OD1 ASN A  83       5.120   7.269  -4.208  1.00 58.70           O  
ATOM    598  ND2 ASN A  83       5.473   8.204  -2.195  1.00 55.88           N  
ATOM    599  N   LYS A  84       3.170   4.211  -4.265  1.00 69.55           N  
ATOM    600  CA  LYS A  84       2.894   3.685  -5.596  1.00 72.41           C  
ATOM    601  C   LYS A  84       3.343   4.662  -6.691  1.00 72.79           C  
ATOM    602  O   LYS A  84       3.431   4.295  -7.872  1.00 74.06           O  
ATOM    603  CB  LYS A  84       1.407   3.344  -5.752  1.00 74.05           C  
ATOM    604  CG  LYS A  84       1.139   2.146  -6.665  1.00 76.13           C  
ATOM    605  CD  LYS A  84      -0.300   2.129  -7.181  1.00 79.30           C  
ATOM    606  CE  LYS A  84      -0.479   3.109  -8.339  1.00 81.33           C  
ATOM    607  NZ  LYS A  84      -1.107   2.472  -9.539  1.00 82.67           N  
ATOM    608  N   ILE A  85       3.626   5.902  -6.302  1.00 71.71           N  
ATOM    609  CA  ILE A  85       4.383   6.801  -7.164  1.00 70.79           C  
ATOM    610  C   ILE A  85       5.858   6.389  -7.142  1.00 69.78           C  
ATOM    611  O   ILE A  85       6.567   6.520  -8.144  1.00 70.04           O  
ATOM    612  CB  ILE A  85       4.215   8.289  -6.742  1.00 70.74           C  
ATOM    613  CG1 ILE A  85       2.749   8.727  -6.832  1.00 71.87           C  
ATOM    614  CG2 ILE A  85       5.068   9.205  -7.601  1.00 70.09           C  
ATOM    615  CD1 ILE A  85       2.062   8.861  -5.486  1.00 73.35           C  
ATOM    616  N   PHE A  86       6.315   5.880  -6.000  1.00 68.36           N  
ATOM    617  CA  PHE A  86       7.712   5.519  -5.851  1.00 67.36           C  
ATOM    618  C   PHE A  86       8.113   4.374  -6.777  1.00 69.01           C  
ATOM    619  O   PHE A  86       9.123   4.453  -7.488  1.00 69.01           O  
ATOM    620  CB  PHE A  86       8.011   5.125  -4.411  1.00 66.07           C  
ATOM    621  CG  PHE A  86       9.459   5.193  -4.072  1.00 64.50           C  
ATOM    622  CD1 PHE A  86      10.308   4.145  -4.388  1.00 63.59           C  
ATOM    623  CD2 PHE A  86       9.991   6.325  -3.467  1.00 63.61           C  
ATOM    624  CE1 PHE A  86      11.662   4.218  -4.089  1.00 63.09           C  
ATOM    625  CE2 PHE A  86      11.342   6.406  -3.169  1.00 61.00           C  
ATOM    626  CZ  PHE A  86      12.178   5.349  -3.480  1.00 60.64           C  
ATOM    627  N   GLU A  87       7.312   3.308  -6.765  1.00 71.26           N  
ATOM    628  CA  GLU A  87       7.724   2.052  -7.377  1.00 73.21           C  
ATOM    629  C   GLU A  87       7.919   2.157  -8.884  1.00 74.20           C  
ATOM    630  O   GLU A  87       8.757   1.455  -9.456  1.00 74.20           O  
ATOM    631  CB  GLU A  87       6.711   0.951  -7.052  1.00 74.50           C  
ATOM    632  CG  GLU A  87       7.226  -0.072  -6.046  1.00 77.42           C  
ATOM    633  CD  GLU A  87       8.429  -0.845  -6.577  1.00 81.85           C  
ATOM    634  OE1 GLU A  87       8.316  -1.403  -7.696  1.00 83.59           O  
ATOM    635  OE2 GLU A  87       9.479  -0.887  -5.883  1.00 81.19           O  
ATOM    636  N   ARG A  88       7.153   3.040  -9.521  1.00 75.41           N  
ATOM    637  CA  ARG A  88       7.086   3.060 -10.981  1.00 77.34           C  
ATOM    638  C   ARG A  88       8.075   4.041 -11.615  1.00 76.55           C  
ATOM    639  O   ARG A  88       8.402   3.927 -12.799  1.00 77.38           O  
ATOM    640  CB  ARG A  88       5.655   3.355 -11.456  1.00 78.83           C  
ATOM    641  CG  ARG A  88       5.153   4.749 -11.086  1.00 80.85           C  
ATOM    642  CD  ARG A  88       4.518   5.425 -12.289  1.00 84.36           C  
ATOM    643  NE  ARG A  88       5.484   6.150 -13.121  1.00 84.94           N  
ATOM    644  CZ  ARG A  88       5.608   7.476 -13.133  1.00 85.40           C  
ATOM    645  NH1 ARG A  88       4.836   8.231 -12.351  1.00 85.58           N  
ATOM    646  NH2 ARG A  88       6.507   8.053 -13.921  1.00 84.95           N  
ATOM    647  N   GLN A  89       8.540   5.008 -10.833  1.00 74.46           N  
ATOM    648  CA  GLN A  89       9.605   5.890 -11.294  1.00 73.00           C  
ATOM    649  C   GLN A  89      10.933   5.135 -11.283  1.00 71.91           C  
ATOM    650  O   GLN A  89      11.725   5.224 -12.230  1.00 72.32           O  
ATOM    651  CB  GLN A  89       9.679   7.148 -10.424  1.00 72.11           C  
ATOM    652  CG  GLN A  89       8.486   8.080 -10.605  1.00 72.48           C  
ATOM    653  CD  GLN A  89       8.670   9.438  -9.936  1.00 71.44           C  
ATOM    654  OE1 GLN A  89       9.776   9.976  -9.874  1.00 70.82           O  
ATOM    655  NE2 GLN A  89       7.574  10.001  -9.440  1.00 69.86           N  
ATOM    656  N   PHE A  90      11.156   4.387 -10.206  1.00 70.21           N  
ATOM    657  CA  PHE A  90      12.312   3.500 -10.083  1.00 69.30           C  
ATOM    658  C   PHE A  90      12.378   2.520 -11.268  1.00 70.15           C  
ATOM    659  O   PHE A  90      13.310   2.551 -12.080  1.00 70.38           O  
ATOM    660  CB  PHE A  90      12.232   2.756  -8.734  1.00 68.27           C  
ATOM    661  CG  PHE A  90      13.295   1.716  -8.547  1.00 68.07           C  
ATOM    662  CD1 PHE A  90      14.648   2.053  -8.630  1.00 67.93           C  
ATOM    663  CD2 PHE A  90      12.947   0.396  -8.279  1.00 69.04           C  
ATOM    664  CE1 PHE A  90      15.635   1.091  -8.450  1.00 68.03           C  
ATOM    665  CE2 PHE A  90      13.923  -0.585  -8.106  1.00 68.65           C  
ATOM    666  CZ  PHE A  90      15.272  -0.235  -8.189  1.00 68.31           C  
ATOM    667  N   LEU A  91      11.357   1.683 -11.374  1.00 71.17           N  
ATOM    668  CA  LEU A  91      11.238   0.705 -12.444  1.00 72.96           C  
ATOM    669  C   LEU A  91      11.371   1.289 -13.865  1.00 74.25           C  
ATOM    670  O   LEU A  91      11.610   0.551 -14.832  1.00 75.25           O  
ATOM    671  CB  LEU A  91       9.913  -0.054 -12.286  1.00 73.36           C  
ATOM    672  CG  LEU A  91       9.852  -1.306 -11.389  1.00 73.13           C  
ATOM    673  CD1 LEU A  91      10.615  -2.466 -12.007  1.00 74.15           C  
ATOM    674  CD2 LEU A  91      10.352  -1.074  -9.969  1.00 73.41           C  
ATOM    675  N   SER A  92      11.235   2.610 -13.987  1.00 74.21           N  
ATOM    676  CA  SER A  92      11.348   3.301 -15.274  1.00 74.64           C  
ATOM    677  C   SER A  92      12.772   3.656 -15.655  1.00 73.89           C  
ATOM    678  O   SER A  92      13.032   3.991 -16.822  1.00 75.03           O  
ATOM    679  CB  SER A  92      10.536   4.580 -15.255  1.00 74.77           C  
ATOM    680  OG  SER A  92       9.168   4.274 -15.181  1.00 76.48           O  
ATOM    681  N   GLY A  93      13.681   3.595 -14.673  1.00 71.57           N  
ATOM    682  CA  GLY A  93      15.072   4.038 -14.838  1.00 68.82           C  
ATOM    683  C   GLY A  93      15.210   5.513 -14.496  1.00 67.06           C  
ATOM    684  O   GLY A  93      16.317   5.991 -14.197  1.00 67.13           O  
ATOM    685  N   GLU A  94      14.079   6.227 -14.515  1.00 65.35           N  
ATOM    686  CA  GLU A  94      14.049   7.671 -14.261  1.00 62.97           C  
ATOM    687  C   GLU A  94      14.235   8.065 -12.779  1.00 59.01           C  
ATOM    688  O   GLU A  94      14.441   9.255 -12.466  1.00 58.53           O  
ATOM    689  CB  GLU A  94      12.765   8.278 -14.831  1.00 64.46           C  
ATOM    690  CG  GLU A  94      11.530   7.945 -14.008  1.00 65.98           C  
ATOM    691  CD  GLU A  94      10.240   8.469 -14.619  1.00 68.49           C  
ATOM    692  OE1 GLU A  94       9.366   7.632 -14.916  1.00 70.29           O  
ATOM    693  OE2 GLU A  94      10.089   9.706 -14.791  1.00 69.79           O  
ATOM    694  N   LEU A  95      14.148   7.085 -11.868  1.00 54.57           N  
ATOM    695  CA  LEU A  95      14.524   7.323 -10.450  1.00 48.85           C  
ATOM    696  C   LEU A  95      15.568   6.354  -9.937  1.00 46.50           C  
ATOM    697  O   LEU A  95      15.312   5.163  -9.794  1.00 46.81           O  
ATOM    698  CB  LEU A  95      13.323   7.322  -9.501  1.00 47.37           C  
ATOM    699  CG  LEU A  95      13.673   7.740  -8.069  1.00 44.03           C  
ATOM    700  CD1 LEU A  95      13.824   9.259  -7.934  1.00 40.97           C  
ATOM    701  CD2 LEU A  95      12.671   7.205  -7.050  1.00 39.76           C  
ATOM    702  N   GLU A  96      16.756   6.863  -9.662  0.50 44.86           N  
ATOM    704  CA  GLU A  96      17.773   6.034  -9.055  0.50 43.34           C  
ATOM    706  C   GLU A  96      17.663   6.057  -7.511  0.50 41.22           C  
ATOM    708  O   GLU A  96      17.526   7.118  -6.893  0.50 40.34           O  
ATOM    710  CB  GLU A  96      19.179   6.400  -9.571  0.50 44.06           C  
ATOM    712  CG  GLU A  96      19.382   7.860  -9.988  0.50 45.61           C  
ATOM    714  CD  GLU A  96      19.523   8.079 -11.501  0.50 48.50           C  
ATOM    716  OE1 GLU A  96      18.873   7.363 -12.304  0.50 50.19           O  
ATOM    718  OE2 GLU A  96      20.284   8.994 -11.887  0.50 48.25           O  
ATOM    720  N   VAL A  97      17.699   4.870  -6.911  1.00 39.61           N  
ATOM    721  CA  VAL A  97      17.518   4.707  -5.485  1.00 37.11           C  
ATOM    722  C   VAL A  97      18.778   4.126  -4.875  1.00 36.16           C  
ATOM    723  O   VAL A  97      19.336   3.216  -5.442  1.00 36.67           O  
ATOM    724  CB  VAL A  97      16.336   3.783  -5.205  1.00 36.97           C  
ATOM    725  CG1 VAL A  97      16.192   3.518  -3.715  1.00 35.72           C  
ATOM    726  CG2 VAL A  97      15.066   4.394  -5.753  1.00 36.55           C  
ATOM    727  N   GLU A  98      19.241   4.678  -3.750  1.00 34.96           N  
ATOM    728  CA  GLU A  98      20.310   4.079  -2.945  1.00 34.48           C  
ATOM    729  C   GLU A  98      19.727   3.780  -1.574  1.00 33.66           C  
ATOM    730  O   GLU A  98      19.608   4.685  -0.708  1.00 33.90           O  
ATOM    731  CB  GLU A  98      21.514   5.024  -2.801  1.00 33.87           C  
ATOM    732  CG  GLU A  98      22.868   4.329  -2.497  1.00 36.34           C  
ATOM    733  CD  GLU A  98      24.045   5.287  -2.005  1.00 39.77           C  
ATOM    734  OE1 GLU A  98      24.166   6.484  -2.412  1.00 42.17           O  
ATOM    735  OE2 GLU A  98      24.898   4.812  -1.212  1.00 43.52           O  
ATOM    736  N   LEU A  99      19.321   2.532  -1.362  1.00 32.97           N  
ATOM    737  CA  LEU A  99      18.890   2.123  -0.026  1.00 31.77           C  
ATOM    738  C   LEU A  99      20.127   1.880   0.839  1.00 30.52           C  
ATOM    739  O   LEU A  99      20.987   1.124   0.458  1.00 30.02           O  
ATOM    740  CB  LEU A  99      18.027   0.875  -0.093  1.00 32.83           C  
ATOM    741  CG  LEU A  99      16.502   0.994  -0.311  1.00 34.68           C  
ATOM    742  CD1 LEU A  99      15.932   2.376   0.057  1.00 31.88           C  
ATOM    743  CD2 LEU A  99      16.068   0.595  -1.691  1.00 34.34           C  
ATOM    744  N   VAL A 100      20.194   2.540   1.996  1.00 29.08           N  
ATOM    745  CA  VAL A 100      21.376   2.622   2.837  1.00 27.75           C  
ATOM    746  C   VAL A 100      20.922   2.270   4.241  1.00 27.49           C  
ATOM    747  O   VAL A 100      19.862   2.729   4.661  1.00 27.48           O  
ATOM    748  CB  VAL A 100      21.892   4.073   2.876  1.00 27.92           C  
ATOM    749  CG1 VAL A 100      22.899   4.274   4.053  1.00 27.83           C  
ATOM    750  CG2 VAL A 100      22.470   4.475   1.527  1.00 26.33           C  
ATOM    751  N   PRO A 101      21.688   1.435   4.973  1.00 26.76           N  
ATOM    752  CA  PRO A 101      21.228   1.055   6.302  1.00 25.90           C  
ATOM    753  C   PRO A 101      21.109   2.297   7.147  1.00 25.74           C  
ATOM    754  O   PRO A 101      22.019   3.151   7.133  1.00 26.37           O  
ATOM    755  CB  PRO A 101      22.357   0.166   6.813  1.00 26.30           C  
ATOM    756  CG  PRO A 101      22.957  -0.437   5.543  1.00 26.32           C  
ATOM    757  CD  PRO A 101      22.950   0.759   4.618  1.00 27.32           C  
ATOM    758  N   GLN A 102      19.986   2.408   7.847  1.00 25.16           N  
ATOM    759  CA  GLN A 102      19.629   3.570   8.642  1.00 24.30           C  
ATOM    760  C   GLN A 102      20.767   4.090   9.524  1.00 23.12           C  
ATOM    761  O   GLN A 102      21.096   5.287   9.503  1.00 21.83           O  
ATOM    762  CB  GLN A 102      18.393   3.257   9.461  1.00 24.42           C  
ATOM    763  CG  GLN A 102      17.758   4.454  10.093  1.00 27.08           C  
ATOM    764  CD  GLN A 102      16.488   4.108  10.833  1.00 29.09           C  
ATOM    765  OE1 GLN A 102      15.746   3.248  10.373  1.00 35.30           O  
ATOM    766  NE2 GLN A 102      16.207   4.785  11.966  1.00 25.89           N  
ATOM    767  N   GLY A 103      21.388   3.189  10.273  1.00 22.14           N  
ATOM    768  CA  GLY A 103      22.490   3.603  11.133  1.00 21.93           C  
ATOM    769  C   GLY A 103      23.664   4.138  10.344  1.00 22.89           C  
ATOM    770  O   GLY A 103      24.321   5.107  10.753  1.00 22.04           O  
ATOM    771  N   THR A 104      23.911   3.512   9.186  1.00 23.24           N  
ATOM    772  CA  THR A 104      24.922   3.993   8.269  1.00 23.32           C  
ATOM    773  C   THR A 104      24.524   5.339   7.661  1.00 23.99           C  
ATOM    774  O   THR A 104      25.369   6.220   7.509  1.00 23.91           O  
ATOM    775  CB  THR A 104      25.229   2.926   7.200  1.00 23.37           C  
ATOM    776  OG1 THR A 104      25.865   1.802   7.832  1.00 24.72           O  
ATOM    777  CG2 THR A 104      26.144   3.467   6.120  1.00 21.49           C  
ATOM    778  N   LEU A 105      23.247   5.514   7.323  1.00 24.73           N  
ATOM    779  CA  LEU A 105      22.808   6.814   6.805  1.00 25.54           C  
ATOM    780  C   LEU A 105      22.988   7.938   7.813  1.00 24.98           C  
ATOM    781  O   LEU A 105      23.575   8.962   7.471  1.00 25.66           O  
ATOM    782  CB  LEU A 105      21.354   6.767   6.322  1.00 26.11           C  
ATOM    783  CG  LEU A 105      20.718   8.005   5.686  1.00 24.85           C  
ATOM    784  CD1 LEU A 105      21.365   8.505   4.407  1.00 19.53           C  
ATOM    785  CD2 LEU A 105      19.272   7.657   5.454  1.00 26.40           C  
ATOM    786  N   ALA A 106      22.507   7.753   9.039  1.00 24.45           N  
ATOM    787  CA  ALA A 106      22.803   8.724  10.114  1.00 24.54           C  
ATOM    788  C   ALA A 106      24.309   9.029  10.233  1.00 24.11           C  
ATOM    789  O   ALA A 106      24.728  10.176  10.168  1.00 25.03           O  
ATOM    790  CB  ALA A 106      22.229   8.277  11.455  1.00 23.71           C  
ATOM    791  N   GLU A 107      25.135   8.008  10.371  1.00 23.85           N  
ATOM    792  CA  GLU A 107      26.550   8.276  10.623  1.00 23.95           C  
ATOM    793  C   GLU A 107      27.230   8.894   9.401  1.00 23.51           C  
ATOM    794  O   GLU A 107      28.279   9.558   9.538  1.00 24.36           O  
ATOM    795  CB  GLU A 107      27.322   7.042  11.126  1.00 23.37           C  
ATOM    796  CG  GLU A 107      28.652   7.373  11.790  1.00 25.70           C  
ATOM    797  CD  GLU A 107      28.541   8.144  13.148  1.00 32.53           C  
ATOM    798  OE1 GLU A 107      27.520   8.044  13.900  1.00 30.53           O  
ATOM    799  OE2 GLU A 107      29.523   8.863  13.481  1.00 35.30           O  
ATOM    800  N   ARG A 108      26.641   8.707   8.224  1.00 22.40           N  
ATOM    801  CA  ARG A 108      27.247   9.275   7.040  1.00 22.42           C  
ATOM    802  C   ARG A 108      26.991  10.753   6.967  1.00 23.07           C  
ATOM    803  O   ARG A 108      27.882  11.520   6.581  1.00 23.75           O  
ATOM    804  CB  ARG A 108      26.820   8.567   5.759  1.00 22.33           C  
ATOM    805  CG  ARG A 108      27.610   7.296   5.514  1.00 20.99           C  
ATOM    806  CD  ARG A 108      27.058   6.572   4.286  1.00 20.83           C  
ATOM    807  NE  ARG A 108      27.322   7.348   3.103  1.00 21.09           N  
ATOM    808  CZ  ARG A 108      26.885   7.062   1.880  1.00 22.52           C  
ATOM    809  NH1 ARG A 108      26.121   5.986   1.682  1.00 20.24           N  
ATOM    810  NH2 ARG A 108      27.244   7.864   0.852  1.00 19.33           N  
ATOM    811  N   ILE A 109      25.788  11.157   7.357  1.00 23.55           N  
ATOM    812  CA  ILE A 109      25.438  12.569   7.319  1.00 23.69           C  
ATOM    813  C   ILE A 109      26.200  13.255   8.388  1.00 23.33           C  
ATOM    814  O   ILE A 109      26.785  14.313   8.151  1.00 24.59           O  
ATOM    815  CB  ILE A 109      23.936  12.813   7.476  1.00 24.41           C  
ATOM    816  CG1 ILE A 109      23.188  12.158   6.327  1.00 22.20           C  
ATOM    817  CG2 ILE A 109      23.642  14.291   7.466  1.00 24.76           C  
ATOM    818  CD1 ILE A 109      21.875  11.737   6.750  1.00 24.28           C  
ATOM    819  N   ARG A 110      26.243  12.641   9.566  1.00 23.43           N  
ATOM    820  CA  ARG A 110      27.097  13.201  10.630  1.00 23.24           C  
ATOM    821  C   ARG A 110      28.530  13.365  10.105  1.00 23.17           C  
ATOM    822  O   ARG A 110      29.143  14.430  10.243  1.00 23.37           O  
ATOM    823  CB  ARG A 110      27.099  12.326  11.879  1.00 22.96           C  
ATOM    824  CG  ARG A 110      27.857  12.979  13.015  1.00 22.43           C  
ATOM    825  CD  ARG A 110      27.879  12.159  14.259  1.00 22.25           C  
ATOM    826  NE  ARG A 110      28.822  12.752  15.212  1.00 30.25           N  
ATOM    827  CZ  ARG A 110      30.151  12.571  15.188  1.00 32.82           C  
ATOM    828  NH1 ARG A 110      30.725  11.773  14.280  1.00 29.67           N  
ATOM    829  NH2 ARG A 110      30.919  13.180  16.088  1.00 33.00           N  
ATOM    830  N   ALA A 111      29.048  12.299   9.497  1.00 22.08           N  
ATOM    831  CA  ALA A 111      30.429  12.270   9.081  1.00 22.16           C  
ATOM    832  C   ALA A 111      30.753  13.505   8.196  1.00 22.94           C  
ATOM    833  O   ALA A 111      31.722  14.218   8.446  1.00 23.52           O  
ATOM    834  CB  ALA A 111      30.729  10.950   8.371  1.00 20.38           C  
ATOM    835  N   GLY A 112      29.923  13.734   7.183  1.00 23.35           N  
ATOM    836  CA  GLY A 112      30.130  14.761   6.203  1.00 24.61           C  
ATOM    837  C   GLY A 112      30.120  16.122   6.869  1.00 26.57           C  
ATOM    838  O   GLY A 112      31.002  16.971   6.605  1.00 27.45           O  
ATOM    839  N   GLY A 113      29.123  16.321   7.723  1.00 25.47           N  
ATOM    840  CA  GLY A 113      29.096  17.471   8.582  1.00 26.95           C  
ATOM    841  C   GLY A 113      30.278  17.604   9.519  1.00 27.66           C  
ATOM    842  O   GLY A 113      30.668  18.725   9.870  1.00 28.76           O  
ATOM    843  N   ALA A 114      30.872  16.485   9.909  1.00 27.41           N  
ATOM    844  CA  ALA A 114      31.923  16.525  10.913  1.00 28.22           C  
ATOM    845  C   ALA A 114      33.328  16.531  10.316  1.00 29.32           C  
ATOM    846  O   ALA A 114      34.329  16.488  11.047  1.00 29.91           O  
ATOM    847  CB  ALA A 114      31.750  15.364  11.897  1.00 27.91           C  
ATOM    848  N   GLY A 115      33.404  16.582   8.991  1.00 30.46           N  
ATOM    849  CA  GLY A 115      34.679  16.560   8.295  1.00 31.28           C  
ATOM    850  C   GLY A 115      35.245  15.159   8.121  1.00 31.98           C  
ATOM    851  O   GLY A 115      36.352  15.033   7.622  1.00 33.82           O  
ATOM    852  N   ILE A 116      34.527  14.108   8.526  1.00 30.74           N  
ATOM    853  CA  ILE A 116      35.037  12.728   8.347  1.00 30.28           C  
ATOM    854  C   ILE A 116      34.702  12.224   6.922  1.00 31.21           C  
ATOM    855  O   ILE A 116      33.491  11.970   6.606  1.00 31.22           O  
ATOM    856  CB  ILE A 116      34.423  11.673   9.341  1.00 29.44           C  
ATOM    857  CG1 ILE A 116      34.312  12.128  10.814  1.00 29.12           C  
ATOM    858  CG2 ILE A 116      35.121  10.389   9.227  1.00 28.90           C  
ATOM    859  CD1 ILE A 116      35.341  13.054  11.224  1.00 33.15           C  
ATOM    860  N   PRO A 117      35.729  12.056   6.056  1.00 31.44           N  
ATOM    861  CA  PRO A 117      35.417  11.561   4.713  1.00 30.92           C  
ATOM    862  C   PRO A 117      34.930  10.114   4.677  1.00 30.45           C  
ATOM    863  O   PRO A 117      34.200   9.732   3.730  1.00 30.19           O  
ATOM    864  CB  PRO A 117      36.731  11.692   3.958  1.00 32.53           C  
ATOM    865  CG  PRO A 117      37.813  11.736   5.036  1.00 33.17           C  
ATOM    866  CD  PRO A 117      37.168  12.330   6.247  1.00 32.14           C  
ATOM    867  N   GLY A 118      35.306   9.316   5.690  1.00 29.46           N  
ATOM    868  CA  GLY A 118      34.967   7.902   5.703  1.00 27.46           C  
ATOM    869  C   GLY A 118      35.139   7.311   7.086  1.00 26.59           C  
ATOM    870  O   GLY A 118      35.900   7.827   7.861  1.00 26.51           O  
ATOM    871  N   PHE A 119      34.447   6.212   7.383  1.00 25.11           N  
ATOM    872  CA  PHE A 119      34.613   5.500   8.644  1.00 24.68           C  
ATOM    873  C   PHE A 119      34.143   4.071   8.417  1.00 24.61           C  
ATOM    874  O   PHE A 119      33.391   3.799   7.484  1.00 24.81           O  
ATOM    875  CB  PHE A 119      33.763   6.131   9.773  1.00 23.85           C  
ATOM    876  CG  PHE A 119      32.290   6.052   9.507  1.00 22.76           C  
ATOM    877  CD1 PHE A 119      31.681   6.947   8.619  1.00 23.80           C  
ATOM    878  CD2 PHE A 119      31.534   5.021  10.036  1.00 23.61           C  
ATOM    879  CE1 PHE A 119      30.309   6.840   8.318  1.00 24.83           C  
ATOM    880  CE2 PHE A 119      30.164   4.879   9.729  1.00 23.76           C  
ATOM    881  CZ  PHE A 119      29.542   5.785   8.879  1.00 22.48           C  
ATOM    882  N   TYR A 120      34.523   3.174   9.311  1.00 24.17           N  
ATOM    883  CA  TYR A 120      34.289   1.762   9.117  1.00 23.73           C  
ATOM    884  C   TYR A 120      33.174   1.326   9.978  1.00 23.89           C  
ATOM    885  O   TYR A 120      33.030   1.839  11.098  1.00 26.10           O  
ATOM    886  CB  TYR A 120      35.529   0.988   9.509  1.00 23.64           C  
ATOM    887  CG  TYR A 120      36.438   0.864   8.369  1.00 24.04           C  
ATOM    888  CD1 TYR A 120      36.174  -0.054   7.363  1.00 26.30           C  
ATOM    889  CD2 TYR A 120      37.540   1.699   8.238  1.00 24.76           C  
ATOM    890  CE1 TYR A 120      37.013  -0.156   6.261  1.00 27.77           C  
ATOM    891  CE2 TYR A 120      38.393   1.595   7.155  1.00 24.07           C  
ATOM    892  CZ  TYR A 120      38.118   0.658   6.179  1.00 25.53           C  
ATOM    893  OH  TYR A 120      38.929   0.523   5.100  1.00 28.71           O  
ATOM    894  N   THR A 121      32.390   0.382   9.495  1.00 22.75           N  
ATOM    895  CA  THR A 121      31.334  -0.175  10.300  1.00 22.34           C  
ATOM    896  C   THR A 121      31.135  -1.646   9.888  1.00 23.05           C  
ATOM    897  O   THR A 121      31.496  -2.036   8.765  1.00 23.43           O  
ATOM    898  CB  THR A 121      30.034   0.665  10.142  1.00 21.81           C  
ATOM    899  OG1 THR A 121      28.955   0.066  10.879  1.00 21.82           O  
ATOM    900  CG2 THR A 121      29.624   0.732   8.693  1.00 22.15           C  
ATOM    901  N   ALA A 122      30.568  -2.433  10.798  1.00 23.35           N  
ATOM    902  CA  ALA A 122      30.210  -3.837  10.569  1.00 24.21           C  
ATOM    903  C   ALA A 122      28.847  -3.968   9.876  1.00 24.72           C  
ATOM    904  O   ALA A 122      28.537  -5.002   9.293  1.00 25.75           O  
ATOM    905  CB  ALA A 122      30.168  -4.564  11.896  1.00 23.82           C  
ATOM    906  N   THR A 123      28.016  -2.937   9.984  1.00 24.03           N  
ATOM    907  CA  THR A 123      26.703  -2.960   9.395  1.00 24.07           C  
ATOM    908  C   THR A 123      26.763  -3.213   7.907  1.00 24.83           C  
ATOM    909  O   THR A 123      27.429  -2.488   7.178  1.00 26.50           O  
ATOM    910  CB  THR A 123      26.021  -1.650   9.638  1.00 23.54           C  
ATOM    911  OG1 THR A 123      25.952  -1.443  11.052  1.00 24.34           O  
ATOM    912  CG2 THR A 123      24.633  -1.663   9.035  1.00 22.21           C  
ATOM    913  N   GLY A 124      26.065  -4.232   7.434  1.00 25.81           N  
ATOM    914  CA  GLY A 124      26.095  -4.540   6.004  1.00 26.77           C  
ATOM    915  C   GLY A 124      27.164  -5.501   5.482  1.00 27.31           C  
ATOM    916  O   GLY A 124      27.067  -5.960   4.354  1.00 28.71           O  
ATOM    917  N   VAL A 125      28.186  -5.801   6.269  1.00 27.18           N  
ATOM    918  CA  VAL A 125      29.177  -6.790   5.872  1.00 27.80           C  
ATOM    919  C   VAL A 125      28.484  -8.095   5.409  1.00 29.09           C  
ATOM    920  O   VAL A 125      27.454  -8.480   5.968  1.00 27.26           O  
ATOM    921  CB  VAL A 125      30.284  -7.014   7.002  1.00 28.43           C  
ATOM    922  CG1 VAL A 125      31.203  -8.241   6.691  1.00 26.15           C  
ATOM    923  CG2 VAL A 125      31.126  -5.707   7.217  1.00 24.17           C  
ATOM    924  N   GLY A 126      29.052  -8.731   4.365  1.00 30.77           N  
ATOM    925  CA  GLY A 126      28.488  -9.956   3.726  1.00 31.94           C  
ATOM    926  C   GLY A 126      27.098  -9.806   3.084  1.00 32.30           C  
ATOM    927  O   GLY A 126      26.381 -10.781   2.875  1.00 33.83           O  
ATOM    928  N   THR A 127      26.754  -8.575   2.746  1.00 30.92           N  
ATOM    929  CA  THR A 127      25.463  -8.153   2.261  1.00 30.61           C  
ATOM    930  C   THR A 127      25.746  -7.344   0.969  1.00 31.48           C  
ATOM    931  O   THR A 127      26.884  -6.901   0.772  1.00 32.58           O  
ATOM    932  CB  THR A 127      24.924  -7.210   3.377  1.00 30.11           C  
ATOM    933  OG1 THR A 127      23.966  -7.879   4.215  1.00 28.36           O  
ATOM    934  CG2 THR A 127      24.401  -5.948   2.858  1.00 27.64           C  
ATOM    935  N   SER A 128      24.733  -7.153   0.118  0.50 31.42           N  
ATOM    937  CA  SER A 128      24.844  -6.329  -1.102  0.50 30.82           C  
ATOM    939  C   SER A 128      25.282  -4.883  -0.829  0.50 30.19           C  
ATOM    941  O   SER A 128      25.719  -4.160  -1.737  0.50 30.46           O  
ATOM    943  CB  SER A 128      23.525  -6.334  -1.876  0.50 30.98           C  
ATOM    945  OG  SER A 128      22.483  -5.713  -1.138  0.50 29.29           O  
ATOM    947  N   ILE A 129      25.164  -4.473   0.425  1.00 29.04           N  
ATOM    948  CA  ILE A 129      25.485  -3.139   0.854  1.00 27.71           C  
ATOM    949  C   ILE A 129      26.984  -2.970   0.847  1.00 27.13           C  
ATOM    950  O   ILE A 129      27.474  -1.871   0.623  1.00 28.25           O  
ATOM    951  CB  ILE A 129      24.804  -2.852   2.268  1.00 26.60           C  
ATOM    952  CG1 ILE A 129      23.571  -2.024   2.060  1.00 27.69           C  
ATOM    953  CG2 ILE A 129      25.667  -2.100   3.215  1.00 26.27           C  
ATOM    954  CD1 ILE A 129      22.506  -2.840   1.460  1.00 34.15           C  
ATOM    955  N   ALA A 130      27.692  -4.075   1.045  1.00 27.40           N  
ATOM    956  CA  ALA A 130      29.161  -4.138   1.069  1.00 27.27           C  
ATOM    957  C   ALA A 130      29.795  -3.947  -0.314  1.00 27.74           C  
ATOM    958  O   ALA A 130      31.011  -3.719  -0.421  1.00 28.02           O  
ATOM    959  CB  ALA A 130      29.604  -5.493   1.642  1.00 27.10           C  
ATOM    960  N   GLU A 131      29.003  -4.089  -1.368  1.00 28.21           N  
ATOM    961  CA  GLU A 131      29.570  -4.123  -2.711  1.00 29.97           C  
ATOM    962  C   GLU A 131      30.291  -2.814  -3.027  1.00 29.65           C  
ATOM    963  O   GLU A 131      29.777  -1.734  -2.727  1.00 28.77           O  
ATOM    964  CB  GLU A 131      28.513  -4.455  -3.757  1.00 29.82           C  
ATOM    965  CG  GLU A 131      27.930  -5.823  -3.581  1.00 32.89           C  
ATOM    966  CD  GLU A 131      28.823  -6.942  -4.113  1.00 40.10           C  
ATOM    967  OE1 GLU A 131      29.496  -6.784  -5.171  1.00 42.47           O  
ATOM    968  OE2 GLU A 131      28.821  -8.019  -3.485  1.00 41.99           O  
ATOM    969  N   GLY A 132      31.495  -2.938  -3.605  1.00 30.73           N  
ATOM    970  CA  GLY A 132      32.383  -1.812  -3.965  1.00 30.43           C  
ATOM    971  C   GLY A 132      32.894  -0.962  -2.802  1.00 29.63           C  
ATOM    972  O   GLY A 132      33.451   0.126  -3.014  1.00 30.43           O  
ATOM    973  N   LYS A 133      32.678  -1.394  -1.572  1.00 27.99           N  
ATOM    974  CA  LYS A 133      33.241  -0.640  -0.449  1.00 27.71           C  
ATOM    975  C   LYS A 133      34.549  -1.296   0.039  1.00 27.81           C  
ATOM    976  O   LYS A 133      34.763  -2.490  -0.143  1.00 28.21           O  
ATOM    977  CB  LYS A 133      32.199  -0.442   0.683  1.00 25.95           C  
ATOM    978  CG  LYS A 133      30.881   0.001   0.099  1.00 26.50           C  
ATOM    979  CD  LYS A 133      29.901   0.610   1.099  1.00 27.56           C  
ATOM    980  CE  LYS A 133      28.802   1.372   0.349  1.00 22.51           C  
ATOM    981  NZ  LYS A 133      27.535   1.335   1.127  1.00 24.27           N  
ATOM    982  N   GLU A 134      35.429  -0.509   0.624  1.00 27.70           N  
ATOM    983  CA  GLU A 134      36.645  -1.063   1.237  1.00 28.30           C  
ATOM    984  C   GLU A 134      36.309  -1.963   2.402  1.00 27.90           C  
ATOM    985  O   GLU A 134      35.463  -1.617   3.225  1.00 26.53           O  
ATOM    986  CB  GLU A 134      37.581   0.046   1.702  1.00 27.91           C  
ATOM    987  CG  GLU A 134      38.164   0.805   0.550  1.00 28.23           C  
ATOM    988  CD  GLU A 134      37.349   2.005   0.108  1.00 27.27           C  
ATOM    989  OE1 GLU A 134      36.126   2.118   0.398  1.00 27.64           O  
ATOM    990  OE2 GLU A 134      37.966   2.862  -0.542  1.00 28.68           O  
ATOM    991  N   HIS A 135      36.950  -3.129   2.428  1.00 29.34           N  
ATOM    992  CA  HIS A 135      36.807  -4.055   3.536  1.00 31.02           C  
ATOM    993  C   HIS A 135      38.131  -4.030   4.313  1.00 31.38           C  
ATOM    994  O   HIS A 135      39.197  -4.079   3.723  1.00 31.67           O  
ATOM    995  CB  HIS A 135      36.482  -5.472   3.049  1.00 31.59           C  
ATOM    996  CG  HIS A 135      35.073  -5.665   2.545  1.00 32.92           C  
ATOM    997  ND1 HIS A 135      34.536  -4.934   1.502  1.00 34.03           N  
ATOM    998  CD2 HIS A 135      34.114  -6.563   2.898  1.00 31.30           C  
ATOM    999  CE1 HIS A 135      33.306  -5.359   1.254  1.00 31.66           C  
ATOM   1000  NE2 HIS A 135      33.026  -6.345   2.087  1.00 28.86           N  
ATOM   1001  N   LYS A 136      38.060  -3.919   5.638  1.00 31.40           N  
ATOM   1002  CA  LYS A 136      39.272  -3.945   6.474  1.00 32.03           C  
ATOM   1003  C   LYS A 136      39.009  -4.725   7.766  1.00 32.17           C  
ATOM   1004  O   LYS A 136      37.899  -4.642   8.308  1.00 32.35           O  
ATOM   1005  CB  LYS A 136      39.721  -2.509   6.790  1.00 31.20           C  
ATOM   1006  CG  LYS A 136      41.107  -2.409   7.362  1.00 31.01           C  
ATOM   1007  CD  LYS A 136      41.634  -0.979   7.353  1.00 31.34           C  
ATOM   1008  CE  LYS A 136      42.797  -0.827   8.330  1.00 33.07           C  
ATOM   1009  NZ  LYS A 136      43.965  -1.722   7.997  1.00 35.92           N  
ATOM   1010  N   THR A 137      40.030  -5.432   8.258  1.00 33.45           N  
ATOM   1011  CA  THR A 137      39.975  -6.250   9.483  1.00 33.92           C  
ATOM   1012  C   THR A 137      40.442  -5.467  10.699  1.00 33.38           C  
ATOM   1013  O   THR A 137      41.511  -4.874  10.686  1.00 33.52           O  
ATOM   1014  CB  THR A 137      40.908  -7.484   9.374  1.00 35.36           C  
ATOM   1015  OG1 THR A 137      40.710  -8.144   8.120  1.00 35.18           O  
ATOM   1016  CG2 THR A 137      40.677  -8.480  10.520  1.00 35.78           C  
ATOM   1017  N   PHE A 138      39.624  -5.458  11.747  1.00 33.38           N  
ATOM   1018  CA  PHE A 138      39.976  -4.848  13.032  1.00 33.14           C  
ATOM   1019  C   PHE A 138      39.677  -5.845  14.135  1.00 34.02           C  
ATOM   1020  O   PHE A 138      38.603  -6.415  14.181  1.00 33.96           O  
ATOM   1021  CB  PHE A 138      39.189  -3.569  13.284  1.00 32.33           C  
ATOM   1022  CG  PHE A 138      39.500  -2.428  12.318  1.00 31.77           C  
ATOM   1023  CD1 PHE A 138      40.460  -1.477  12.630  1.00 30.52           C  
ATOM   1024  CD2 PHE A 138      38.763  -2.270  11.134  1.00 32.70           C  
ATOM   1025  CE1 PHE A 138      40.723  -0.395  11.774  1.00 31.96           C  
ATOM   1026  CE2 PHE A 138      39.009  -1.188  10.247  1.00 32.68           C  
ATOM   1027  CZ  PHE A 138      40.003  -0.249  10.567  1.00 32.10           C  
ATOM   1028  N   GLY A 139      40.650  -6.094  14.998  1.00 35.29           N  
ATOM   1029  CA  GLY A 139      40.519  -7.157  15.987  1.00 36.51           C  
ATOM   1030  C   GLY A 139      39.862  -8.408  15.434  1.00 37.07           C  
ATOM   1031  O   GLY A 139      38.848  -8.842  15.945  1.00 36.73           O  
ATOM   1032  N   GLY A 140      40.417  -8.965  14.361  1.00 38.16           N  
ATOM   1033  CA  GLY A 140      39.902 -10.224  13.785  1.00 38.68           C  
ATOM   1034  C   GLY A 140      38.516 -10.234  13.141  1.00 38.58           C  
ATOM   1035  O   GLY A 140      38.030 -11.290  12.787  1.00 39.09           O  
ATOM   1036  N   ARG A 141      37.887  -9.070  12.960  1.00 37.17           N  
ATOM   1037  CA  ARG A 141      36.577  -9.008  12.323  1.00 35.80           C  
ATOM   1038  C   ARG A 141      36.508  -7.978  11.164  1.00 33.39           C  
ATOM   1039  O   ARG A 141      37.199  -6.963  11.178  1.00 31.78           O  
ATOM   1040  CB  ARG A 141      35.507  -8.781  13.413  1.00 35.89           C  
ATOM   1041  CG  ARG A 141      34.326  -7.868  13.051  1.00 37.73           C  
ATOM   1042  CD  ARG A 141      33.474  -7.552  14.336  1.00 41.70           C  
ATOM   1043  NE  ARG A 141      32.004  -7.608  14.192  1.00 46.76           N  
ATOM   1044  CZ  ARG A 141      31.146  -6.712  14.712  1.00 50.74           C  
ATOM   1045  NH1 ARG A 141      31.595  -5.639  15.364  1.00 50.49           N  
ATOM   1046  NH2 ARG A 141      29.818  -6.866  14.559  1.00 51.78           N  
ATOM   1047  N   THR A 142      35.668  -8.274  10.167  1.00 30.99           N  
ATOM   1048  CA  THR A 142      35.502  -7.458   8.969  1.00 28.75           C  
ATOM   1049  C   THR A 142      34.566  -6.217   9.105  1.00 27.50           C  
ATOM   1050  O   THR A 142      33.437  -6.320   9.593  1.00 25.99           O  
ATOM   1051  CB  THR A 142      35.058  -8.338   7.764  1.00 28.72           C  
ATOM   1052  OG1 THR A 142      36.047  -9.349   7.517  1.00 31.45           O  
ATOM   1053  CG2 THR A 142      34.920  -7.527   6.532  1.00 26.22           C  
ATOM   1054  N   TYR A 143      35.055  -5.066   8.636  1.00 25.69           N  
ATOM   1055  CA  TYR A 143      34.261  -3.883   8.527  1.00 24.98           C  
ATOM   1056  C   TYR A 143      34.373  -3.352   7.119  1.00 24.85           C  
ATOM   1057  O   TYR A 143      35.380  -3.611   6.410  1.00 25.38           O  
ATOM   1058  CB  TYR A 143      34.684  -2.803   9.532  1.00 24.71           C  
ATOM   1059  CG  TYR A 143      34.684  -3.323  10.948  1.00 27.63           C  
ATOM   1060  CD1 TYR A 143      35.758  -4.074  11.433  1.00 26.72           C  
ATOM   1061  CD2 TYR A 143      33.605  -3.084  11.804  1.00 29.83           C  
ATOM   1062  CE1 TYR A 143      35.758  -4.552  12.692  1.00 28.12           C  
ATOM   1063  CE2 TYR A 143      33.605  -3.564  13.099  1.00 27.02           C  
ATOM   1064  CZ  TYR A 143      34.691  -4.304  13.525  1.00 28.74           C  
ATOM   1065  OH  TYR A 143      34.735  -4.807  14.811  1.00 30.28           O  
ATOM   1066  N   VAL A 144      33.354  -2.569   6.757  1.00 22.84           N  
ATOM   1067  CA  VAL A 144      33.243  -1.938   5.462  1.00 22.84           C  
ATOM   1068  C   VAL A 144      33.376  -0.412   5.607  1.00 22.25           C  
ATOM   1069  O   VAL A 144      32.890   0.161   6.611  1.00 21.69           O  
ATOM   1070  CB  VAL A 144      31.886  -2.399   4.800  1.00 22.65           C  
ATOM   1071  CG1 VAL A 144      30.652  -1.647   5.329  1.00 19.47           C  
ATOM   1072  CG2 VAL A 144      31.943  -2.251   3.362  1.00 26.47           C  
ATOM   1073  N   LEU A 145      34.027   0.250   4.650  1.00 22.86           N  
ATOM   1074  CA  LEU A 145      34.133   1.764   4.671  1.00 22.56           C  
ATOM   1075  C   LEU A 145      32.915   2.490   4.105  1.00 22.37           C  
ATOM   1076  O   LEU A 145      32.442   2.182   2.995  1.00 23.15           O  
ATOM   1077  CB  LEU A 145      35.381   2.275   3.956  1.00 23.19           C  
ATOM   1078  CG  LEU A 145      35.701   3.797   4.060  1.00 23.91           C  
ATOM   1079  CD1 LEU A 145      36.215   4.185   5.408  1.00 24.46           C  
ATOM   1080  CD2 LEU A 145      36.748   4.229   3.091  1.00 23.42           C  
ATOM   1081  N   GLU A 146      32.399   3.438   4.868  1.00 21.61           N  
ATOM   1082  CA  GLU A 146      31.256   4.265   4.442  1.00 21.52           C  
ATOM   1083  C   GLU A 146      31.678   5.731   4.381  1.00 22.15           C  
ATOM   1084  O   GLU A 146      32.456   6.193   5.220  1.00 22.92           O  
ATOM   1085  CB  GLU A 146      30.049   4.062   5.357  1.00 20.19           C  
ATOM   1086  CG  GLU A 146      29.354   2.654   5.186  1.00 23.04           C  
ATOM   1087  CD  GLU A 146      28.654   2.393   3.801  1.00 25.23           C  
ATOM   1088  OE1 GLU A 146      28.613   3.275   2.911  1.00 25.83           O  
ATOM   1089  OE2 GLU A 146      28.164   1.261   3.586  1.00 25.94           O  
ATOM   1090  N   ARG A 147      31.208   6.447   3.377  1.00 22.99           N  
ATOM   1091  CA  ARG A 147      31.751   7.764   3.032  1.00 24.75           C  
ATOM   1092  C   ARG A 147      30.842   8.878   3.512  1.00 25.28           C  
ATOM   1093  O   ARG A 147      29.617   8.802   3.308  1.00 26.02           O  
ATOM   1094  CB  ARG A 147      31.967   7.877   1.520  1.00 24.30           C  
ATOM   1095  CG  ARG A 147      33.298   7.286   1.104  1.00 27.32           C  
ATOM   1096  CD  ARG A 147      33.496   7.122  -0.424  1.00 30.26           C  
ATOM   1097  NE  ARG A 147      34.884   6.784  -0.776  1.00 30.49           N  
ATOM   1098  CZ  ARG A 147      35.452   5.593  -0.536  1.00 31.42           C  
ATOM   1099  NH1 ARG A 147      34.770   4.625   0.064  1.00 32.18           N  
ATOM   1100  NH2 ARG A 147      36.714   5.353  -0.874  1.00 31.96           N  
ATOM   1101  N   GLY A 148      31.420   9.904   4.151  1.00 25.71           N  
ATOM   1102  CA  GLY A 148      30.637  11.098   4.593  1.00 25.85           C  
ATOM   1103  C   GLY A 148      29.757  11.634   3.462  1.00 26.14           C  
ATOM   1104  O   GLY A 148      30.196  11.688   2.304  1.00 25.45           O  
ATOM   1105  N   ILE A 149      28.501  11.953   3.775  1.00 26.17           N  
ATOM   1106  CA  ILE A 149      27.610  12.642   2.819  1.00 26.65           C  
ATOM   1107  C   ILE A 149      27.466  14.120   3.154  1.00 27.94           C  
ATOM   1108  O   ILE A 149      27.282  14.505   4.308  1.00 28.69           O  
ATOM   1109  CB  ILE A 149      26.181  12.085   2.815  1.00 26.25           C  
ATOM   1110  CG1 ILE A 149      26.144  10.631   2.341  1.00 25.03           C  
ATOM   1111  CG2 ILE A 149      25.244  12.999   1.947  1.00 26.35           C  
ATOM   1112  CD1 ILE A 149      24.833   9.935   2.645  1.00 20.99           C  
ATOM   1113  N   THR A 150      27.454  14.934   2.119  1.00 29.51           N  
ATOM   1114  CA  THR A 150      27.396  16.379   2.245  1.00 30.39           C  
ATOM   1115  C   THR A 150      26.364  16.883   1.256  1.00 30.98           C  
ATOM   1116  O   THR A 150      26.148  16.273   0.188  1.00 30.60           O  
ATOM   1117  CB  THR A 150      28.775  16.897   1.949  1.00 30.84           C  
ATOM   1118  OG1 THR A 150      29.325  17.374   3.178  1.00 34.89           O  
ATOM   1119  CG2 THR A 150      28.803  17.944   0.917  1.00 31.95           C  
ATOM   1120  N   GLY A 151      25.693  17.965   1.625  1.00 30.94           N  
ATOM   1121  CA  GLY A 151      24.640  18.494   0.804  1.00 32.56           C  
ATOM   1122  C   GLY A 151      24.820  19.964   0.482  1.00 33.93           C  
ATOM   1123  O   GLY A 151      25.424  20.722   1.249  1.00 33.96           O  
ATOM   1124  N   ASP A 152      24.255  20.358  -0.650  1.00 35.43           N  
ATOM   1125  CA  ASP A 152      24.116  21.758  -1.038  1.00 36.90           C  
ATOM   1126  C   ASP A 152      23.134  22.487  -0.133  1.00 36.45           C  
ATOM   1127  O   ASP A 152      23.388  23.592   0.310  1.00 36.94           O  
ATOM   1128  CB  ASP A 152      23.667  21.822  -2.491  1.00 37.74           C  
ATOM   1129  CG  ASP A 152      24.653  21.122  -3.424  1.00 41.29           C  
ATOM   1130  OD1 ASP A 152      25.809  21.607  -3.533  1.00 45.09           O  
ATOM   1131  OD2 ASP A 152      24.291  20.083  -4.041  1.00 43.10           O  
ATOM   1132  N   VAL A 153      22.002  21.862   0.152  1.00 36.05           N  
ATOM   1133  CA  VAL A 153      21.051  22.436   1.093  1.00 35.45           C  
ATOM   1134  C   VAL A 153      20.583  21.361   2.071  1.00 34.00           C  
ATOM   1135  O   VAL A 153      20.295  20.234   1.665  1.00 33.64           O  
ATOM   1136  CB  VAL A 153      19.804  22.962   0.380  1.00 36.01           C  
ATOM   1137  CG1 VAL A 153      18.825  23.512   1.387  1.00 36.05           C  
ATOM   1138  CG2 VAL A 153      20.165  23.995  -0.662  1.00 37.54           C  
ATOM   1139  N   ALA A 154      20.483  21.728   3.343  1.00 33.05           N  
ATOM   1140  CA  ALA A 154      19.779  20.932   4.333  1.00 32.09           C  
ATOM   1141  C   ALA A 154      18.476  21.608   4.789  1.00 32.75           C  
ATOM   1142  O   ALA A 154      18.415  22.826   5.026  1.00 33.52           O  
ATOM   1143  CB  ALA A 154      20.664  20.664   5.521  1.00 31.42           C  
ATOM   1144  N   ILE A 155      17.434  20.807   4.941  1.00 31.85           N  
ATOM   1145  CA  ILE A 155      16.150  21.352   5.301  1.00 31.72           C  
ATOM   1146  C   ILE A 155      15.733  20.640   6.576  1.00 30.90           C  
ATOM   1147  O   ILE A 155      15.716  19.408   6.622  1.00 30.71           O  
ATOM   1148  CB  ILE A 155      15.207  21.295   4.030  1.00 32.10           C  
ATOM   1149  CG1 ILE A 155      14.751  22.680   3.691  1.00 34.81           C  
ATOM   1150  CG2 ILE A 155      14.100  20.246   4.021  1.00 30.87           C  
ATOM   1151  CD1 ILE A 155      15.841  23.452   3.047  1.00 37.91           C  
ATOM   1152  N   VAL A 156      15.505  21.390   7.649  1.00 30.95           N  
ATOM   1153  CA  VAL A 156      15.296  20.741   8.952  1.00 31.10           C  
ATOM   1154  C   VAL A 156      14.202  21.358   9.794  1.00 32.44           C  
ATOM   1155  O   VAL A 156      13.900  22.524   9.663  1.00 33.45           O  
ATOM   1156  CB  VAL A 156      16.590  20.590   9.780  1.00 30.39           C  
ATOM   1157  CG1 VAL A 156      17.721  20.137   8.906  1.00 28.40           C  
ATOM   1158  CG2 VAL A 156      16.945  21.850  10.467  1.00 29.72           C  
ATOM   1159  N   LYS A 157      13.593  20.541  10.639  1.00 33.01           N  
ATOM   1160  CA  LYS A 157      12.417  20.948  11.383  1.00 34.03           C  
ATOM   1161  C   LYS A 157      12.745  21.048  12.883  1.00 34.42           C  
ATOM   1162  O   LYS A 157      13.239  20.080  13.443  1.00 32.81           O  
ATOM   1163  CB  LYS A 157      11.307  19.916  11.155  1.00 33.56           C  
ATOM   1164  CG  LYS A 157      10.083  20.115  12.022  1.00 34.77           C  
ATOM   1165  CD  LYS A 157       9.370  21.405  11.680  1.00 36.10           C  
ATOM   1166  CE  LYS A 157       8.307  21.794  12.712  1.00 38.42           C  
ATOM   1167  NZ  LYS A 157       7.599  20.622  13.314  1.00 37.98           N  
ATOM   1168  N   ALA A 158      12.452  22.193  13.527  1.00 35.90           N  
ATOM   1169  CA  ALA A 158      12.615  22.310  15.002  1.00 36.80           C  
ATOM   1170  C   ALA A 158      11.364  22.670  15.815  1.00 38.60           C  
ATOM   1171  O   ALA A 158      10.423  23.321  15.318  1.00 39.03           O  
ATOM   1172  CB  ALA A 158      13.750  23.243  15.359  1.00 36.42           C  
ATOM   1173  N   TRP A 159      11.360  22.255  17.079  1.00 39.64           N  
ATOM   1174  CA  TRP A 159      10.351  22.754  18.022  1.00 41.36           C  
ATOM   1175  C   TRP A 159      10.506  24.272  18.207  1.00 43.27           C  
ATOM   1176  O   TRP A 159       9.554  25.042  18.017  1.00 44.73           O  
ATOM   1177  CB  TRP A 159      10.438  22.017  19.362  1.00 40.83           C  
ATOM   1178  CG  TRP A 159       9.352  22.420  20.267  1.00 43.51           C  
ATOM   1179  CD1 TRP A 159       8.063  22.704  19.911  1.00 44.06           C  
ATOM   1180  CD2 TRP A 159       9.427  22.597  21.687  1.00 45.12           C  
ATOM   1181  NE1 TRP A 159       7.338  23.064  21.022  1.00 47.38           N  
ATOM   1182  CE2 TRP A 159       8.148  22.999  22.126  1.00 47.71           C  
ATOM   1183  CE3 TRP A 159      10.448  22.455  22.632  1.00 45.91           C  
ATOM   1184  CZ2 TRP A 159       7.862  23.258  23.471  1.00 49.91           C  
ATOM   1185  CZ3 TRP A 159      10.172  22.717  23.964  1.00 46.42           C  
ATOM   1186  CH2 TRP A 159       8.884  23.115  24.374  1.00 49.91           C  
ATOM   1187  N   LYS A 160      11.708  24.706  18.580  1.00 44.34           N  
ATOM   1188  CA  LYS A 160      12.001  26.131  18.668  1.00 45.95           C  
ATOM   1189  C   LYS A 160      13.330  26.488  18.007  1.00 44.90           C  
ATOM   1190  O   LYS A 160      14.250  25.665  17.915  1.00 43.29           O  
ATOM   1191  CB  LYS A 160      11.988  26.616  20.120  1.00 47.48           C  
ATOM   1192  CG  LYS A 160      10.837  26.088  20.984  1.00 50.82           C  
ATOM   1193  CD  LYS A 160      10.478  27.080  22.099  1.00 56.36           C  
ATOM   1194  CE  LYS A 160       9.649  26.413  23.193  1.00 60.11           C  
ATOM   1195  NZ  LYS A 160       8.894  27.393  24.078  1.00 64.22           N  
ATOM   1196  N   ALA A 161      13.402  27.723  17.537  1.00 45.47           N  
ATOM   1197  CA  ALA A 161      14.632  28.293  17.053  1.00 46.62           C  
ATOM   1198  C   ALA A 161      14.726  29.665  17.675  1.00 49.02           C  
ATOM   1199  O   ALA A 161      13.691  30.293  17.933  1.00 50.12           O  
ATOM   1200  CB  ALA A 161      14.606  28.416  15.545  1.00 45.13           C  
ATOM   1201  N   ASP A 162      15.944  30.138  17.927  1.00 50.67           N  
ATOM   1202  CA  ASP A 162      16.114  31.577  18.172  1.00 53.70           C  
ATOM   1203  C   ASP A 162      16.661  32.281  16.913  1.00 54.41           C  
ATOM   1204  O   ASP A 162      17.098  31.619  15.957  1.00 53.15           O  
ATOM   1205  CB  ASP A 162      16.923  31.882  19.452  1.00 54.36           C  
ATOM   1206  CG  ASP A 162      18.417  31.531  19.331  1.00 54.96           C  
ATOM   1207  OD1 ASP A 162      18.868  31.080  18.246  1.00 52.42           O  
ATOM   1208  OD2 ASP A 162      19.146  31.731  20.345  1.00 57.08           O  
ATOM   1209  N   THR A 163      16.633  33.615  16.913  1.00 56.67           N  
ATOM   1210  CA  THR A 163      17.068  34.381  15.744  1.00 58.30           C  
ATOM   1211  C   THR A 163      18.537  34.183  15.359  1.00 57.38           C  
ATOM   1212  O   THR A 163      18.950  34.630  14.301  1.00 57.78           O  
ATOM   1213  CB  THR A 163      16.828  35.880  15.922  1.00 60.25           C  
ATOM   1214  OG1 THR A 163      17.670  36.374  16.972  1.00 61.16           O  
ATOM   1215  CG2 THR A 163      15.364  36.156  16.228  1.00 61.33           C  
ATOM   1216  N   MET A 164      19.324  33.533  16.214  1.00 56.18           N  
ATOM   1217  CA  MET A 164      20.690  33.140  15.851  1.00 55.13           C  
ATOM   1218  C   MET A 164      20.802  31.697  15.387  1.00 51.46           C  
ATOM   1219  O   MET A 164      21.906  31.182  15.223  1.00 50.67           O  
ATOM   1220  CB  MET A 164      21.653  33.372  17.002  1.00 56.25           C  
ATOM   1221  CG  MET A 164      21.986  34.839  17.221  1.00 61.08           C  
ATOM   1222  SD  MET A 164      23.115  35.045  18.619  1.00 66.23           S  
ATOM   1223  CE  MET A 164      23.772  33.378  18.683  1.00 57.83           C  
ATOM   1224  N   GLY A 165      19.664  31.054  15.172  1.00 48.93           N  
ATOM   1225  CA  GLY A 165      19.656  29.753  14.528  1.00 46.28           C  
ATOM   1226  C   GLY A 165      19.827  28.561  15.454  1.00 44.30           C  
ATOM   1227  O   GLY A 165      19.920  27.423  14.969  1.00 43.21           O  
ATOM   1228  N   ASN A 166      19.867  28.812  16.766  1.00 43.43           N  
ATOM   1229  CA  ASN A 166      19.896  27.744  17.747  1.00 42.77           C  
ATOM   1230  C   ASN A 166      18.585  26.995  17.759  1.00 42.03           C  
ATOM   1231  O   ASN A 166      17.524  27.617  17.764  1.00 43.35           O  
ATOM   1232  CB  ASN A 166      20.157  28.279  19.145  1.00 44.16           C  
ATOM   1233  CG  ASN A 166      21.553  28.873  19.308  1.00 44.70           C  
ATOM   1234  OD1 ASN A 166      22.552  28.215  19.062  1.00 43.77           O  
ATOM   1235  ND2 ASN A 166      21.612  30.117  19.759  1.00 45.23           N  
ATOM   1236  N   LEU A 167      18.662  25.664  17.778  1.00 39.54           N  
ATOM   1237  CA  LEU A 167      17.489  24.798  17.660  1.00 38.16           C  
ATOM   1238  C   LEU A 167      17.311  23.934  18.892  1.00 38.53           C  
ATOM   1239  O   LEU A 167      18.287  23.469  19.467  1.00 38.64           O  
ATOM   1240  CB  LEU A 167      17.617  23.879  16.433  1.00 36.60           C  
ATOM   1241  CG  LEU A 167      17.998  24.528  15.091  1.00 35.43           C  
ATOM   1242  CD1 LEU A 167      17.928  23.529  13.948  1.00 31.52           C  
ATOM   1243  CD2 LEU A 167      17.108  25.745  14.766  1.00 35.83           C  
ATOM   1244  N   ILE A 168      16.069  23.749  19.318  1.00 39.74           N  
ATOM   1245  CA  ILE A 168      15.722  22.666  20.239  1.00 40.60           C  
ATOM   1246  C   ILE A 168      14.650  21.810  19.573  1.00 39.31           C  
ATOM   1247  O   ILE A 168      13.794  22.326  18.849  1.00 39.36           O  
ATOM   1248  CB  ILE A 168      15.254  23.164  21.612  1.00 41.45           C  
ATOM   1249  CG1 ILE A 168      14.771  21.999  22.482  1.00 42.48           C  
ATOM   1250  CG2 ILE A 168      14.074  24.132  21.463  1.00 46.13           C  
ATOM   1251  CD1 ILE A 168      14.148  22.461  23.882  1.00 47.01           C  
ATOM   1252  N   PHE A 169      14.715  20.502  19.808  1.00 38.24           N  
ATOM   1253  CA  PHE A 169      13.753  19.559  19.252  1.00 37.67           C  
ATOM   1254  C   PHE A 169      12.897  18.929  20.329  1.00 38.73           C  
ATOM   1255  O   PHE A 169      13.087  19.188  21.519  1.00 40.40           O  
ATOM   1256  CB  PHE A 169      14.473  18.468  18.447  1.00 36.28           C  
ATOM   1257  CG  PHE A 169      15.375  19.012  17.387  1.00 34.77           C  
ATOM   1258  CD1 PHE A 169      16.710  19.268  17.666  1.00 34.48           C  
ATOM   1259  CD2 PHE A 169      14.886  19.306  16.127  1.00 32.95           C  
ATOM   1260  CE1 PHE A 169      17.549  19.786  16.699  1.00 33.75           C  
ATOM   1261  CE2 PHE A 169      15.717  19.820  15.152  1.00 34.61           C  
ATOM   1262  CZ  PHE A 169      17.060  20.057  15.436  1.00 35.43           C  
ATOM   1263  N   ARG A 170      11.955  18.094  19.908  1.00 39.37           N  
ATOM   1264  CA  ARG A 170      10.892  17.656  20.786  1.00 40.80           C  
ATOM   1265  C   ARG A 170      10.632  16.172  20.579  1.00 39.71           C  
ATOM   1266  O   ARG A 170      10.316  15.743  19.474  1.00 39.34           O  
ATOM   1267  CB  ARG A 170       9.623  18.469  20.510  1.00 42.06           C  
ATOM   1268  CG  ARG A 170       8.790  18.734  21.733  1.00 45.90           C  
ATOM   1269  CD  ARG A 170       7.440  19.360  21.404  1.00 48.78           C  
ATOM   1270  NE  ARG A 170       6.369  18.382  21.541  1.00 51.57           N  
ATOM   1271  CZ  ARG A 170       5.891  17.978  22.710  1.00 54.03           C  
ATOM   1272  NH1 ARG A 170       6.388  18.482  23.828  1.00 56.88           N  
ATOM   1273  NH2 ARG A 170       4.923  17.079  22.766  1.00 56.34           N  
ATOM   1274  N   LYS A 171      10.772  15.394  21.648  1.00 39.61           N  
ATOM   1275  CA  LYS A 171      10.543  13.954  21.598  1.00 38.91           C  
ATOM   1276  C   LYS A 171      11.267  13.318  20.425  1.00 36.96           C  
ATOM   1277  O   LYS A 171      12.450  13.583  20.205  1.00 36.63           O  
ATOM   1278  CB  LYS A 171       9.043  13.639  21.526  1.00 40.57           C  
ATOM   1279  CG  LYS A 171       8.210  14.471  22.452  1.00 40.70           C  
ATOM   1280  CD  LYS A 171       7.115  13.630  23.094  1.00 47.52           C  
ATOM   1281  CE  LYS A 171       6.465  14.358  24.311  1.00 47.18           C  
ATOM   1282  NZ  LYS A 171       7.464  14.499  25.462  1.00 50.48           N  
ATOM   1283  N   THR A 172      10.564  12.475  19.672  1.00 35.44           N  
ATOM   1284  CA  THR A 172      11.210  11.720  18.601  1.00 33.41           C  
ATOM   1285  C   THR A 172      11.193  12.483  17.280  1.00 32.56           C  
ATOM   1286  O   THR A 172      11.700  11.994  16.275  1.00 30.89           O  
ATOM   1287  CB  THR A 172      10.563  10.343  18.410  1.00 32.35           C  
ATOM   1288  OG1 THR A 172       9.151  10.501  18.303  1.00 33.02           O  
ATOM   1289  CG2 THR A 172      10.872   9.459  19.583  1.00 32.32           C  
ATOM   1290  N   ALA A 173      10.617  13.684  17.299  1.00 32.94           N  
ATOM   1291  CA  ALA A 173      10.756  14.626  16.176  1.00 33.08           C  
ATOM   1292  C   ALA A 173      12.176  15.085  15.909  1.00 31.64           C  
ATOM   1293  O   ALA A 173      12.424  15.711  14.905  1.00 32.74           O  
ATOM   1294  CB  ALA A 173       9.836  15.811  16.297  1.00 34.15           C  
ATOM   1295  N   ARG A 174      13.103  14.718  16.777  1.00 31.01           N  
ATOM   1296  CA  ARG A 174      14.549  15.048  16.651  1.00 29.11           C  
ATOM   1297  C   ARG A 174      15.262  14.271  15.540  1.00 28.39           C  
ATOM   1298  O   ARG A 174      15.762  14.877  14.588  1.00 27.89           O  
ATOM   1299  CB  ARG A 174      15.193  14.745  17.960  1.00 28.07           C  
ATOM   1300  CG  ARG A 174      16.640  15.042  18.102  1.00 26.93           C  
ATOM   1301  CD  ARG A 174      16.649  15.520  19.512  1.00 26.45           C  
ATOM   1302  NE  ARG A 174      17.816  15.213  20.264  1.00 26.85           N  
ATOM   1303  CZ  ARG A 174      17.881  15.323  21.582  1.00 27.75           C  
ATOM   1304  NH1 ARG A 174      16.821  15.685  22.299  1.00 29.32           N  
ATOM   1305  NH2 ARG A 174      19.012  15.033  22.187  1.00 26.03           N  
ATOM   1306  N   ASN A 175      15.288  12.938  15.671  1.00 27.06           N  
ATOM   1307  CA  ASN A 175      15.788  12.036  14.655  1.00 26.27           C  
ATOM   1308  C   ASN A 175      16.956  12.527  13.864  1.00 26.13           C  
ATOM   1309  O   ASN A 175      18.036  12.663  14.448  1.00 27.02           O  
ATOM   1310  CB  ASN A 175      14.689  11.407  13.765  1.00 27.12           C  
ATOM   1311  CG  ASN A 175      13.776  12.435  13.095  1.00 30.13           C  
ATOM   1312  OD1 ASN A 175      14.069  12.906  11.969  1.00 29.37           O  
ATOM   1313  ND2 ASN A 175      12.665  12.799  13.786  1.00 25.95           N  
ATOM   1314  N   PHE A 176      16.773  12.793  12.565  1.00 25.46           N  
ATOM   1315  CA  PHE A 176      17.878  13.170  11.652  1.00 24.70           C  
ATOM   1316  C   PHE A 176      18.099  14.680  11.585  1.00 26.39           C  
ATOM   1317  O   PHE A 176      19.099  15.134  10.990  1.00 26.82           O  
ATOM   1318  CB  PHE A 176      17.649  12.654  10.218  1.00 23.38           C  
ATOM   1319  CG  PHE A 176      17.960  11.187  10.033  1.00 22.44           C  
ATOM   1320  CD1 PHE A 176      17.215  10.202  10.691  1.00 21.23           C  
ATOM   1321  CD2 PHE A 176      18.997  10.782   9.199  1.00 19.48           C  
ATOM   1322  CE1 PHE A 176      17.523   8.846  10.542  1.00 20.36           C  
ATOM   1323  CE2 PHE A 176      19.296   9.451   9.051  1.00 19.17           C  
ATOM   1324  CZ  PHE A 176      18.553   8.476   9.743  1.00 19.64           C  
ATOM   1325  N   ASN A 177      17.182  15.460  12.164  1.00 27.48           N  
ATOM   1326  CA  ASN A 177      17.209  16.912  11.978  1.00 29.88           C  
ATOM   1327  C   ASN A 177      18.567  17.551  12.398  1.00 30.85           C  
ATOM   1328  O   ASN A 177      19.154  18.324  11.638  1.00 30.26           O  
ATOM   1329  CB  ASN A 177      15.999  17.584  12.659  1.00 30.65           C  
ATOM   1330  CG  ASN A 177      14.702  17.445  11.847  1.00 32.34           C  
ATOM   1331  OD1 ASN A 177      14.632  17.901  10.709  1.00 36.07           O  
ATOM   1332  ND2 ASN A 177      13.664  16.854  12.448  1.00 30.28           N  
ATOM   1333  N   PRO A 178      19.083  17.198  13.592  1.00 31.73           N  
ATOM   1334  CA  PRO A 178      20.334  17.811  14.043  1.00 32.65           C  
ATOM   1335  C   PRO A 178      21.514  17.416  13.187  1.00 32.64           C  
ATOM   1336  O   PRO A 178      22.409  18.219  12.933  1.00 33.10           O  
ATOM   1337  CB  PRO A 178      20.541  17.240  15.468  1.00 32.09           C  
ATOM   1338  CG  PRO A 178      19.300  16.609  15.841  1.00 32.71           C  
ATOM   1339  CD  PRO A 178      18.558  16.247  14.584  1.00 31.85           C  
ATOM   1340  N   ILE A 179      21.534  16.172  12.758  1.00 32.85           N  
ATOM   1341  CA  ILE A 179      22.694  15.717  12.028  1.00 32.88           C  
ATOM   1342  C   ILE A 179      22.656  16.262  10.614  1.00 33.55           C  
ATOM   1343  O   ILE A 179      23.712  16.597  10.056  1.00 34.06           O  
ATOM   1344  CB  ILE A 179      22.881  14.182  12.147  1.00 32.63           C  
ATOM   1345  CG1 ILE A 179      21.616  13.421  11.824  1.00 30.80           C  
ATOM   1346  CG2 ILE A 179      23.266  13.822  13.615  1.00 33.45           C  
ATOM   1347  CD1 ILE A 179      21.918  11.966  11.504  1.00 30.66           C  
ATOM   1348  N   ALA A 180      21.438  16.414  10.071  1.00 33.26           N  
ATOM   1349  CA  ALA A 180      21.268  17.031   8.773  1.00 33.94           C  
ATOM   1350  C   ALA A 180      21.656  18.523   8.818  1.00 35.21           C  
ATOM   1351  O   ALA A 180      22.317  19.038   7.891  1.00 36.04           O  
ATOM   1352  CB  ALA A 180      19.840  16.861   8.268  1.00 33.88           C  
ATOM   1353  N   ALA A 181      21.236  19.228   9.865  1.00 35.50           N  
ATOM   1354  CA  ALA A 181      21.615  20.626  10.028  1.00 36.81           C  
ATOM   1355  C   ALA A 181      23.125  20.838   9.779  1.00 37.39           C  
ATOM   1356  O   ALA A 181      23.506  21.798   9.094  1.00 38.47           O  
ATOM   1357  CB  ALA A 181      21.217  21.119  11.388  1.00 36.68           C  
ATOM   1358  N   MET A 182      23.946  19.904  10.264  1.00 36.47           N  
ATOM   1359  CA  MET A 182      25.413  19.935  10.125  1.00 36.91           C  
ATOM   1360  C   MET A 182      25.966  19.738   8.712  1.00 36.27           C  
ATOM   1361  O   MET A 182      26.954  20.349   8.335  1.00 37.13           O  
ATOM   1362  CB  MET A 182      26.060  18.801  10.957  1.00 36.88           C  
ATOM   1363  CG  MET A 182      25.906  18.826  12.467  1.00 36.16           C  
ATOM   1364  SD  MET A 182      26.282  17.125  13.025  1.00 37.68           S  
ATOM   1365  CE  MET A 182      25.211  16.911  14.484  1.00 39.93           C  
ATOM   1366  N   ALA A 183      25.393  18.799   7.980  1.00 35.53           N  
ATOM   1367  CA  ALA A 183      25.895  18.398   6.668  1.00 34.98           C  
ATOM   1368  C   ALA A 183      25.495  19.310   5.526  1.00 35.68           C  
ATOM   1369  O   ALA A 183      25.826  19.032   4.391  1.00 36.67           O  
ATOM   1370  CB  ALA A 183      25.431  16.969   6.352  1.00 33.92           C  
ATOM   1371  N   GLY A 184      24.735  20.363   5.795  1.00 36.62           N  
ATOM   1372  CA  GLY A 184      24.246  21.211   4.711  1.00 37.44           C  
ATOM   1373  C   GLY A 184      25.100  22.450   4.516  1.00 38.15           C  
ATOM   1374  O   GLY A 184      25.314  23.217   5.451  1.00 38.17           O  
ATOM   1375  N   LYS A 185      25.575  22.639   3.287  1.00 39.13           N  
ATOM   1376  CA  LYS A 185      26.198  23.891   2.871  1.00 41.25           C  
ATOM   1377  C   LYS A 185      25.320  25.089   3.243  1.00 41.82           C  
ATOM   1378  O   LYS A 185      25.824  26.064   3.778  1.00 42.16           O  
ATOM   1379  CB  LYS A 185      26.472  23.857   1.366  1.00 42.32           C  
ATOM   1380  CG  LYS A 185      27.263  25.026   0.825  1.00 45.73           C  
ATOM   1381  CD  LYS A 185      28.560  24.552   0.198  1.00 53.09           C  
ATOM   1382  CE  LYS A 185      28.752  25.122  -1.240  1.00 57.02           C  
ATOM   1383  NZ  LYS A 185      28.961  26.623  -1.315  1.00 58.95           N  
ATOM   1384  N   ILE A 186      24.010  25.003   2.969  1.00 42.27           N  
ATOM   1385  CA  ILE A 186      23.017  25.998   3.434  1.00 43.23           C  
ATOM   1386  C   ILE A 186      21.928  25.298   4.219  1.00 42.13           C  
ATOM   1387  O   ILE A 186      21.239  24.425   3.697  1.00 41.65           O  
ATOM   1388  CB  ILE A 186      22.347  26.775   2.263  1.00 44.80           C  
ATOM   1389  CG1 ILE A 186      23.381  27.499   1.394  1.00 46.30           C  
ATOM   1390  CG2 ILE A 186      21.380  27.811   2.783  1.00 45.99           C  
ATOM   1391  CD1 ILE A 186      23.003  27.491  -0.061  1.00 48.61           C  
ATOM   1392  N   THR A 187      21.769  25.679   5.478  1.00 41.98           N  
ATOM   1393  CA  THR A 187      20.874  24.962   6.368  1.00 40.69           C  
ATOM   1394  C   THR A 187      19.738  25.892   6.720  1.00 42.26           C  
ATOM   1395  O   THR A 187      19.959  26.993   7.256  1.00 43.16           O  
ATOM   1396  CB  THR A 187      21.578  24.556   7.662  1.00 40.80           C  
ATOM   1397  OG1 THR A 187      22.650  23.639   7.385  1.00 37.04           O  
ATOM   1398  CG2 THR A 187      20.569  23.964   8.695  1.00 39.34           C  
ATOM   1399  N   ILE A 188      18.529  25.435   6.402  1.00 42.15           N  
ATOM   1400  CA  ILE A 188      17.300  26.166   6.667  1.00 42.42           C  
ATOM   1401  C   ILE A 188      16.473  25.427   7.713  1.00 42.13           C  
ATOM   1402  O   ILE A 188      16.061  24.262   7.515  1.00 40.38           O  
ATOM   1403  CB  ILE A 188      16.441  26.270   5.411  1.00 42.60           C  
ATOM   1404  CG1 ILE A 188      17.317  26.686   4.226  1.00 42.85           C  
ATOM   1405  CG2 ILE A 188      15.260  27.197   5.674  1.00 42.26           C  
ATOM   1406  CD1 ILE A 188      16.611  26.775   2.900  1.00 41.48           C  
ATOM   1407  N   ALA A 189      16.205  26.124   8.816  1.00 42.61           N  
ATOM   1408  CA  ALA A 189      15.463  25.516   9.901  1.00 42.40           C  
ATOM   1409  C   ALA A 189      14.055  26.026   9.890  1.00 42.91           C  
ATOM   1410  O   ALA A 189      13.834  27.233   9.985  1.00 44.79           O  
ATOM   1411  CB  ALA A 189      16.109  25.837  11.208  1.00 42.93           C  
ATOM   1412  N   GLU A 190      13.106  25.112   9.771  1.00 41.79           N  
ATOM   1413  CA  GLU A 190      11.696  25.429   9.913  1.00 41.91           C  
ATOM   1414  C   GLU A 190      11.274  25.172  11.364  1.00 41.69           C  
ATOM   1415  O   GLU A 190      11.491  24.071  11.886  1.00 40.73           O  
ATOM   1416  CB  GLU A 190      10.926  24.576   8.924  1.00 41.34           C  
ATOM   1417  CG  GLU A 190       9.498  24.253   9.241  1.00 42.98           C  
ATOM   1418  CD  GLU A 190       8.774  23.680   8.018  1.00 46.26           C  
ATOM   1419  OE1 GLU A 190       9.435  23.563   6.944  1.00 46.65           O  
ATOM   1420  OE2 GLU A 190       7.556  23.363   8.117  1.00 45.55           O  
ATOM   1421  N   ALA A 191      10.698  26.192  12.005  1.00 42.85           N  
ATOM   1422  CA  ALA A 191      10.343  26.142  13.426  1.00 44.35           C  
ATOM   1423  C   ALA A 191       8.893  26.488  13.783  1.00 46.44           C  
ATOM   1424  O   ALA A 191       8.217  27.271  13.086  1.00 47.74           O  
ATOM   1425  CB  ALA A 191      11.300  26.997  14.234  1.00 44.43           C  
ATOM   1426  N   GLU A 192       8.412  25.910  14.882  1.00 47.21           N  
ATOM   1427  CA  GLU A 192       7.046  26.154  15.332  1.00 48.34           C  
ATOM   1428  C   GLU A 192       6.980  27.422  16.177  1.00 50.76           C  
ATOM   1429  O   GLU A 192       5.915  28.025  16.323  1.00 51.16           O  
ATOM   1430  CB  GLU A 192       6.525  24.982  16.161  1.00 47.17           C  
ATOM   1431  CG  GLU A 192       6.764  23.623  15.568  1.00 45.71           C  
ATOM   1432  CD  GLU A 192       6.068  22.510  16.335  1.00 44.80           C  
ATOM   1433  OE1 GLU A 192       5.395  22.783  17.352  1.00 45.72           O  
ATOM   1434  OE2 GLU A 192       6.204  21.353  15.914  1.00 42.61           O  
ATOM   1435  N   GLU A 193       8.116  27.767  16.778  1.00 51.77           N  
ATOM   1436  CA  GLU A 193       8.271  28.976  17.568  1.00 53.80           C  
ATOM   1437  C   GLU A 193       9.611  29.556  17.210  1.00 52.83           C  
ATOM   1438  O   GLU A 193      10.576  28.824  17.121  1.00 51.75           O  
ATOM   1439  CB  GLU A 193       8.191  28.690  19.075  1.00 54.50           C  
ATOM   1440  CG  GLU A 193       6.945  29.292  19.767  1.00 60.62           C  
ATOM   1441  CD  GLU A 193       7.228  29.870  21.183  1.00 67.35           C  
ATOM   1442  OE1 GLU A 193       7.847  29.153  22.016  1.00 68.88           O  
ATOM   1443  OE2 GLU A 193       6.815  31.030  21.475  1.00 68.06           O  
ATOM   1444  N   ILE A 194       9.658  30.856  16.955  1.00 54.37           N  
ATOM   1445  CA  ILE A 194      10.917  31.558  16.804  1.00 55.45           C  
ATOM   1446  C   ILE A 194      11.029  32.498  18.004  1.00 58.07           C  
ATOM   1447  O   ILE A 194      10.254  33.446  18.117  1.00 58.85           O  
ATOM   1448  CB  ILE A 194      10.970  32.399  15.521  1.00 55.15           C  
ATOM   1449  CG1 ILE A 194      10.769  31.532  14.276  1.00 54.62           C  
ATOM   1450  CG2 ILE A 194      12.296  33.120  15.423  1.00 55.04           C  
ATOM   1451  CD1 ILE A 194      10.465  32.320  13.021  1.00 50.36           C  
ATOM   1452  N   VAL A 195      11.974  32.234  18.909  1.00 59.16           N  
ATOM   1453  CA  VAL A 195      12.150  33.123  20.064  1.00 60.98           C  
ATOM   1454  C   VAL A 195      13.332  34.058  19.845  1.00 62.45           C  
ATOM   1455  O   VAL A 195      14.096  33.889  18.885  1.00 62.03           O  
ATOM   1456  CB  VAL A 195      12.315  32.359  21.402  1.00 60.51           C  
ATOM   1457  CG1 VAL A 195      11.141  31.413  21.657  1.00 59.43           C  
ATOM   1458  CG2 VAL A 195      13.614  31.619  21.418  1.00 60.44           C  
ATOM   1459  N   GLU A 196      13.470  35.036  20.732  1.00 65.04           N  
ATOM   1460  CA  GLU A 196      14.593  35.954  20.709  1.00 67.52           C  
ATOM   1461  C   GLU A 196      15.803  35.244  21.310  1.00 66.02           C  
ATOM   1462  O   GLU A 196      15.655  34.390  22.197  1.00 65.25           O  
ATOM   1463  CB  GLU A 196      14.283  37.225  21.520  1.00 69.99           C  
ATOM   1464  CG  GLU A 196      13.307  38.231  20.900  1.00 74.25           C  
ATOM   1465  CD  GLU A 196      13.062  39.423  21.835  1.00 82.44           C  
ATOM   1466  OE1 GLU A 196      13.805  39.512  22.851  1.00 85.70           O  
ATOM   1467  OE2 GLU A 196      12.143  40.268  21.583  1.00 84.52           O  
ATOM   1468  N   ALA A 197      16.993  35.595  20.823  1.00 65.44           N  
ATOM   1469  CA  ALA A 197      18.240  34.993  21.298  1.00 65.12           C  
ATOM   1470  C   ALA A 197      18.432  35.253  22.791  1.00 66.24           C  
ATOM   1471  O   ALA A 197      18.526  36.404  23.221  1.00 67.16           O  
ATOM   1472  CB  ALA A 197      19.449  35.501  20.482  1.00 64.60           C  
ATOM   1473  N   GLY A 198      18.462  34.165  23.568  1.00 66.10           N  
ATOM   1474  CA  GLY A 198      18.507  34.245  25.025  1.00 67.26           C  
ATOM   1475  C   GLY A 198      17.367  33.538  25.749  1.00 67.66           C  
ATOM   1476  O   GLY A 198      17.452  33.296  26.958  1.00 68.15           O  
ATOM   1477  N   GLU A 199      16.287  33.215  25.040  1.00 67.28           N  
ATOM   1478  CA  GLU A 199      15.232  32.423  25.666  1.00 67.23           C  
ATOM   1479  C   GLU A 199      15.590  30.935  25.722  1.00 64.43           C  
ATOM   1480  O   GLU A 199      15.031  30.178  26.517  1.00 65.21           O  
ATOM   1481  CB  GLU A 199      13.857  32.671  25.030  1.00 68.36           C  
ATOM   1482  CG  GLU A 199      13.145  33.963  25.522  1.00 74.10           C  
ATOM   1483  CD  GLU A 199      12.771  33.957  27.033  1.00 79.39           C  
ATOM   1484  OE1 GLU A 199      13.568  33.477  27.874  1.00 81.15           O  
ATOM   1485  OE2 GLU A 199      11.667  34.445  27.382  1.00 81.50           O  
ATOM   1486  N   LEU A 200      16.548  30.512  24.914  1.00 60.44           N  
ATOM   1487  CA  LEU A 200      16.956  29.133  25.002  1.00 57.07           C  
ATOM   1488  C   LEU A 200      18.165  28.947  25.920  1.00 56.23           C  
ATOM   1489  O   LEU A 200      19.267  29.473  25.674  1.00 56.06           O  
ATOM   1490  CB  LEU A 200      17.190  28.539  23.608  1.00 55.63           C  
ATOM   1491  CG  LEU A 200      16.053  28.771  22.606  1.00 54.70           C  
ATOM   1492  CD1 LEU A 200      16.444  28.301  21.207  1.00 53.09           C  
ATOM   1493  CD2 LEU A 200      14.771  28.097  23.091  1.00 54.42           C  
ATOM   1494  N   ASP A 201      17.944  28.198  26.992  1.00 54.69           N  
ATOM   1495  CA  ASP A 201      19.005  27.889  27.872  1.00 53.52           C  
ATOM   1496  C   ASP A 201      20.084  27.234  27.004  1.00 51.81           C  
ATOM   1497  O   ASP A 201      19.788  26.340  26.183  1.00 49.94           O  
ATOM   1498  CB  ASP A 201      18.505  26.968  28.954  1.00 54.00           C  
ATOM   1499  CG  ASP A 201      19.542  26.730  30.049  1.00 57.36           C  
ATOM   1500  OD1 ASP A 201      20.568  26.037  29.785  1.00 56.13           O  
ATOM   1501  OD2 ASP A 201      19.318  27.236  31.177  1.00 57.47           O  
ATOM   1502  N   PRO A 202      21.342  27.699  27.145  1.00 51.22           N  
ATOM   1503  CA  PRO A 202      22.449  27.176  26.326  1.00 48.63           C  
ATOM   1504  C   PRO A 202      22.684  25.709  26.577  1.00 46.53           C  
ATOM   1505  O   PRO A 202      23.202  25.005  25.695  1.00 45.22           O  
ATOM   1506  CB  PRO A 202      23.645  27.992  26.802  1.00 49.40           C  
ATOM   1507  CG  PRO A 202      23.041  29.205  27.405  1.00 51.09           C  
ATOM   1508  CD  PRO A 202      21.792  28.758  28.057  1.00 51.40           C  
ATOM   1509  N   ASP A 203      22.296  25.240  27.765  1.00 46.57           N  
ATOM   1510  CA  ASP A 203      22.363  23.797  28.083  1.00 45.69           C  
ATOM   1511  C   ASP A 203      21.173  22.979  27.605  1.00 44.54           C  
ATOM   1512  O   ASP A 203      21.140  21.768  27.806  1.00 43.26           O  
ATOM   1513  CB  ASP A 203      22.578  23.566  29.578  1.00 46.20           C  
ATOM   1514  CG  ASP A 203      24.046  23.624  29.965  1.00 47.10           C  
ATOM   1515  OD1 ASP A 203      24.864  22.954  29.304  1.00 46.50           O  
ATOM   1516  OD2 ASP A 203      24.390  24.350  30.924  1.00 49.59           O  
ATOM   1517  N   HIS A 204      20.185  23.646  27.009  1.00 44.98           N  
ATOM   1518  CA  HIS A 204      19.045  22.966  26.453  1.00 44.83           C  
ATOM   1519  C   HIS A 204      19.298  22.775  24.980  1.00 42.95           C  
ATOM   1520  O   HIS A 204      19.028  21.717  24.468  1.00 42.83           O  
ATOM   1521  CB  HIS A 204      17.747  23.739  26.650  1.00 46.37           C  
ATOM   1522  CG  HIS A 204      17.320  23.878  28.072  1.00 51.65           C  
ATOM   1523  ND1 HIS A 204      17.773  23.052  29.074  1.00 55.53           N  
ATOM   1524  CD2 HIS A 204      16.451  24.739  28.661  1.00 58.29           C  
ATOM   1525  CE1 HIS A 204      17.231  23.413  30.225  1.00 57.65           C  
ATOM   1526  NE2 HIS A 204      16.421  24.432  30.000  1.00 59.33           N  
ATOM   1527  N   ILE A 205      19.817  23.804  24.316  1.00 42.15           N  
ATOM   1528  CA  ILE A 205      20.061  23.798  22.872  1.00 41.24           C  
ATOM   1529  C   ILE A 205      20.573  22.486  22.277  1.00 39.29           C  
ATOM   1530  O   ILE A 205      21.590  21.954  22.696  1.00 39.23           O  
ATOM   1531  CB  ILE A 205      21.027  24.938  22.472  1.00 41.94           C  
ATOM   1532  CG1 ILE A 205      20.411  26.284  22.889  1.00 43.77           C  
ATOM   1533  CG2 ILE A 205      21.390  24.838  20.961  1.00 39.01           C  
ATOM   1534  CD1 ILE A 205      20.994  27.483  22.237  1.00 45.25           C  
ATOM   1535  N   HIS A 206      19.874  21.963  21.292  1.00 37.67           N  
ATOM   1536  CA  HIS A 206      20.334  20.721  20.682  1.00 36.46           C  
ATOM   1537  C   HIS A 206      21.232  20.878  19.473  1.00 35.50           C  
ATOM   1538  O   HIS A 206      22.137  20.061  19.265  1.00 34.49           O  
ATOM   1539  CB  HIS A 206      19.162  19.833  20.298  1.00 36.34           C  
ATOM   1540  CG  HIS A 206      18.410  19.314  21.474  1.00 36.60           C  
ATOM   1541  ND1 HIS A 206      17.040  19.431  21.589  1.00 35.14           N  
ATOM   1542  CD2 HIS A 206      18.841  18.694  22.595  1.00 34.16           C  
ATOM   1543  CE1 HIS A 206      16.655  18.890  22.731  1.00 36.89           C  
ATOM   1544  NE2 HIS A 206      17.729  18.428  23.356  1.00 38.22           N  
ATOM   1545  N   THR A 207      20.940  21.864  18.630  1.00 35.54           N  
ATOM   1546  CA  THR A 207      21.871  22.183  17.560  1.00 36.32           C  
ATOM   1547  C   THR A 207      22.279  23.640  17.644  1.00 36.80           C  
ATOM   1548  O   THR A 207      21.457  24.535  17.442  1.00 37.02           O  
ATOM   1549  CB  THR A 207      21.430  21.720  16.097  1.00 35.80           C  
ATOM   1550  OG1 THR A 207      21.077  22.835  15.275  1.00 38.50           O  
ATOM   1551  CG2 THR A 207      20.287  20.762  16.123  1.00 36.20           C  
ATOM   1552  N   PRO A 208      23.547  23.866  17.998  1.00 37.08           N  
ATOM   1553  CA  PRO A 208      24.088  25.209  18.032  1.00 37.75           C  
ATOM   1554  C   PRO A 208      23.853  25.961  16.713  1.00 38.12           C  
ATOM   1555  O   PRO A 208      23.918  25.382  15.603  1.00 35.79           O  
ATOM   1556  CB  PRO A 208      25.599  25.008  18.304  1.00 37.13           C  
ATOM   1557  CG  PRO A 208      25.850  23.545  18.353  1.00 37.00           C  
ATOM   1558  CD  PRO A 208      24.527  22.841  18.428  1.00 37.08           C  
ATOM   1559  N   GLY A 209      23.577  27.253  16.890  1.00 39.73           N  
ATOM   1560  CA  GLY A 209      23.348  28.221  15.825  1.00 40.63           C  
ATOM   1561  C   GLY A 209      24.325  28.178  14.676  1.00 40.07           C  
ATOM   1562  O   GLY A 209      23.914  28.408  13.555  1.00 40.15           O  
ATOM   1563  N   ILE A 210      25.600  27.888  14.935  1.00 39.59           N  
ATOM   1564  CA  ILE A 210      26.596  27.825  13.850  1.00 39.46           C  
ATOM   1565  C   ILE A 210      26.188  26.950  12.644  1.00 38.77           C  
ATOM   1566  O   ILE A 210      26.602  27.227  11.524  1.00 39.30           O  
ATOM   1567  CB  ILE A 210      28.018  27.401  14.342  1.00 39.94           C  
ATOM   1568  CG1 ILE A 210      29.047  27.553  13.197  1.00 40.87           C  
ATOM   1569  CG2 ILE A 210      28.011  25.952  14.925  1.00 37.56           C  
ATOM   1570  CD1 ILE A 210      30.519  27.658  13.609  1.00 41.03           C  
ATOM   1571  N   TYR A 211      25.392  25.902  12.871  1.00 36.99           N  
ATOM   1572  CA  TYR A 211      25.003  24.967  11.808  1.00 35.87           C  
ATOM   1573  C   TYR A 211      23.854  25.439  10.915  1.00 36.22           C  
ATOM   1574  O   TYR A 211      23.561  24.825   9.881  1.00 35.88           O  
ATOM   1575  CB  TYR A 211      24.596  23.630  12.427  1.00 35.10           C  
ATOM   1576  CG  TYR A 211      25.739  22.877  13.042  1.00 35.07           C  
ATOM   1577  CD1 TYR A 211      26.930  22.655  12.327  1.00 36.59           C  
ATOM   1578  CD2 TYR A 211      25.652  22.405  14.329  1.00 34.25           C  
ATOM   1579  CE1 TYR A 211      28.003  21.977  12.890  1.00 36.15           C  
ATOM   1580  CE2 TYR A 211      26.706  21.739  14.904  1.00 35.51           C  
ATOM   1581  CZ  TYR A 211      27.872  21.506  14.181  1.00 36.73           C  
ATOM   1582  OH  TYR A 211      28.890  20.787  14.770  1.00 36.09           O  
ATOM   1583  N   VAL A 212      23.201  26.513  11.326  1.00 36.93           N  
ATOM   1584  CA  VAL A 212      21.959  26.923  10.725  1.00 37.89           C  
ATOM   1585  C   VAL A 212      22.183  28.288  10.126  1.00 39.76           C  
ATOM   1586  O   VAL A 212      22.640  29.199  10.818  1.00 39.96           O  
ATOM   1587  CB  VAL A 212      20.882  26.985  11.810  1.00 37.73           C  
ATOM   1588  CG1 VAL A 212      19.654  27.701  11.322  1.00 37.44           C  
ATOM   1589  CG2 VAL A 212      20.562  25.578  12.299  1.00 36.14           C  
ATOM   1590  N   GLN A 213      21.907  28.438   8.832  1.00 40.94           N  
ATOM   1591  CA  GLN A 213      22.170  29.749   8.222  1.00 42.30           C  
ATOM   1592  C   GLN A 213      20.949  30.607   7.967  1.00 43.55           C  
ATOM   1593  O   GLN A 213      21.066  31.833   7.952  1.00 45.70           O  
ATOM   1594  CB  GLN A 213      23.206  29.771   7.061  1.00 42.43           C  
ATOM   1595  CG  GLN A 213      23.588  28.487   6.338  1.00 41.16           C  
ATOM   1596  CD  GLN A 213      24.205  27.421   7.207  1.00 40.09           C  
ATOM   1597  OE1 GLN A 213      24.119  26.225   6.885  1.00 40.89           O  
ATOM   1598  NE2 GLN A 213      24.843  27.826   8.296  1.00 38.43           N  
ATOM   1599  N   HIS A 214      19.786  29.964   7.845  1.00 42.81           N  
ATOM   1600  CA  HIS A 214      18.492  30.633   7.802  1.00 42.36           C  
ATOM   1601  C   HIS A 214      17.456  29.903   8.662  1.00 41.89           C  
ATOM   1602  O   HIS A 214      17.645  28.728   9.017  1.00 41.31           O  
ATOM   1603  CB  HIS A 214      18.016  30.701   6.376  1.00 41.95           C  
ATOM   1604  CG  HIS A 214      19.021  31.289   5.442  1.00 44.97           C  
ATOM   1605  ND1 HIS A 214      19.198  32.653   5.295  1.00 47.98           N  
ATOM   1606  CD2 HIS A 214      19.909  30.700   4.602  1.00 46.05           C  
ATOM   1607  CE1 HIS A 214      20.138  32.878   4.393  1.00 49.09           C  
ATOM   1608  NE2 HIS A 214      20.587  31.710   3.956  1.00 48.97           N  
ATOM   1609  N   VAL A 215      16.344  30.590   8.952  1.00 43.09           N  
ATOM   1610  CA  VAL A 215      15.279  30.137   9.866  1.00 43.56           C  
ATOM   1611  C   VAL A 215      13.904  30.617   9.415  1.00 45.38           C  
ATOM   1612  O   VAL A 215      13.735  31.800   9.095  1.00 46.57           O  
ATOM   1613  CB  VAL A 215      15.468  30.731  11.270  1.00 43.46           C  
ATOM   1614  CG1 VAL A 215      14.286  30.386  12.147  1.00 44.39           C  
ATOM   1615  CG2 VAL A 215      16.735  30.240  11.900  1.00 41.31           C  
ATOM   1616  N   VAL A 216      12.905  29.749   9.431  1.00 45.97           N  
ATOM   1617  CA  VAL A 216      11.536  30.186   9.118  1.00 47.92           C  
ATOM   1618  C   VAL A 216      10.517  29.711  10.113  1.00 48.05           C  
ATOM   1619  O   VAL A 216      10.741  28.779  10.827  1.00 48.02           O  
ATOM   1620  CB  VAL A 216      11.061  29.752   7.701  1.00 47.78           C  
ATOM   1621  CG1 VAL A 216      11.832  30.469   6.629  1.00 49.50           C  
ATOM   1622  CG2 VAL A 216      11.200  28.289   7.522  1.00 46.46           C  
ATOM   1623  N   LEU A 217       9.403  30.397  10.161  1.00 50.33           N  
ATOM   1624  CA  LEU A 217       8.310  29.972  10.978  1.00 50.67           C  
ATOM   1625  C   LEU A 217       7.470  28.986  10.218  1.00 47.97           C  
ATOM   1626  O   LEU A 217       7.134  29.203   9.037  1.00 48.97           O  
ATOM   1627  CB  LEU A 217       7.442  31.148  11.377  1.00 53.21           C  
ATOM   1628  CG  LEU A 217       6.360  30.869  12.403  1.00 55.01           C  
ATOM   1629  CD1 LEU A 217       6.945  30.423  13.706  1.00 52.96           C  
ATOM   1630  CD2 LEU A 217       5.545  32.115  12.586  1.00 56.10           C  
ATOM   1631  N   GLY A 218       7.130  27.884  10.908  1.00 36.22           N  
ATOM   1632  CA  GLY A 218       6.253  26.822  10.367  1.00 32.84           C  
ATOM   1633  C   GLY A 218       5.038  26.506  11.269  1.00 32.53           C  
ATOM   1634  O   GLY A 218       4.672  27.281  12.203  1.00 34.89           O  
ATOM   1635  N   ALA A 219       4.409  25.365  11.030  1.00 32.38           N  
ATOM   1636  CA  ALA A 219       3.043  25.152  11.535  1.00 33.23           C  
ATOM   1637  C   ALA A 219       3.112  24.203  12.748  1.00 33.34           C  
ATOM   1638  O   ALA A 219       3.974  23.332  12.827  1.00 32.49           O  
ATOM   1639  CB  ALA A 219       2.166  24.554  10.425  1.00 33.46           C  
ATOM   1640  N   SER A 220       2.207  24.400  13.702  1.00 35.16           N  
ATOM   1641  CA  SER A 220       2.220  23.557  14.911  1.00 36.29           C  
ATOM   1642  C   SER A 220       0.837  22.851  15.026  1.00 37.65           C  
ATOM   1643  O   SER A 220       0.699  21.878  15.817  1.00 38.57           O  
ATOM   1644  CB  SER A 220       2.402  24.460  16.139  1.00 36.70           C  
ATOM   1645  OG  SER A 220       1.265  25.358  16.198  1.00 41.18           O  
ATOM   1646  N   GLN A 221      -0.173  23.353  14.285  1.00 38.89           N  
ATOM   1647  CA  GLN A 221      -1.545  23.004  14.584  1.00 41.05           C  
ATOM   1648  C   GLN A 221      -1.978  21.710  13.868  1.00 40.47           C  
ATOM   1649  O   GLN A 221      -3.013  21.094  14.208  1.00 41.71           O  
ATOM   1650  CB  GLN A 221      -2.512  24.167  14.197  1.00 42.60           C  
ATOM   1651  CG  GLN A 221      -2.195  25.515  14.911  1.00 45.93           C  
ATOM   1652  CD  GLN A 221      -3.080  26.622  14.406  1.00 49.91           C  
ATOM   1653  OE1 GLN A 221      -3.482  26.610  13.216  1.00 57.31           O  
ATOM   1654  NE2 GLN A 221      -3.485  27.570  15.302  1.00 52.42           N  
ATOM   1655  N   GLU A 222      -1.232  21.306  12.858  1.00 38.04           N  
ATOM   1656  CA  GLU A 222      -1.866  20.435  11.882  1.00 37.45           C  
ATOM   1657  C   GLU A 222      -1.068  19.164  11.695  1.00 37.14           C  
ATOM   1658  O   GLU A 222      -1.269  18.451  10.690  1.00 37.02           O  
ATOM   1659  CB  GLU A 222      -1.987  21.167  10.528  1.00 37.35           C  
ATOM   1660  CG  GLU A 222      -0.581  21.228   9.737  1.00 35.24           C  
ATOM   1661  CD  GLU A 222      -0.737  21.991   8.387  1.00 37.78           C  
ATOM   1662  OE1 GLU A 222      -1.904  22.152   7.856  1.00 40.52           O  
ATOM   1663  OE2 GLU A 222       0.323  22.440   7.861  1.00 36.70           O  
ATOM   1664  N   LYS A 223      -0.161  18.881  12.634  1.00 46.09           N  
ATOM   1665  CA  LYS A 223       0.764  17.762  12.481  1.00 49.23           C  
ATOM   1666  C   LYS A 223       0.007  16.499  12.096  1.00 49.74           C  
ATOM   1667  O   LYS A 223      -0.888  16.054  12.810  1.00 50.85           O  
ATOM   1668  CB  LYS A 223       1.534  17.532  13.784  1.00 50.60           C  
ATOM   1669  CG  LYS A 223       2.448  18.657  14.157  1.00 50.69           C  
ATOM   1670  CD  LYS A 223       3.687  18.078  14.788  1.00 51.66           C  
ATOM   1671  CE  LYS A 223       4.739  19.133  14.984  1.00 50.50           C  
ATOM   1672  NZ  LYS A 223       4.924  19.378  16.436  1.00 54.82           N  
ATOM   1673  N   ARG A 224       0.363  15.941  10.946  1.00 48.06           N  
ATOM   1674  CA  ARG A 224      -0.190  14.675  10.495  1.00 46.71           C  
ATOM   1675  C   ARG A 224       0.426  13.513  11.272  1.00 45.34           C  
ATOM   1676  O   ARG A 224       1.646  13.348  11.320  1.00 44.71           O  
ATOM   1677  CB  ARG A 224       0.049  14.493   8.990  1.00 46.47           C  
ATOM   1678  CG  ARG A 224      -0.932  13.535   8.310  1.00 46.95           C  
ATOM   1679  CD  ARG A 224      -0.436  13.172   6.911  1.00 47.80           C  
ATOM   1680  NE  ARG A 224      -0.991  11.894   6.456  1.00 47.08           N  
ATOM   1681  CZ  ARG A 224      -1.305  11.595   5.193  1.00 42.86           C  
ATOM   1682  NH1 ARG A 224      -1.140  12.483   4.223  1.00 40.51           N  
ATOM   1683  NH2 ARG A 224      -1.786  10.394   4.908  1.00 39.38           N  
ATOM   1684  N   ILE A 225      -0.436  12.715  11.886  1.00 46.13           N  
ATOM   1685  CA  ILE A 225      -0.056  11.424  12.436  1.00 46.18           C  
ATOM   1686  C   ILE A 225      -0.334  10.330  11.413  1.00 46.31           C  
ATOM   1687  O   ILE A 225      -1.479  10.079  11.040  1.00 48.14           O  
ATOM   1688  CB  ILE A 225      -0.814  11.136  13.745  1.00 46.63           C  
ATOM   1689  CG1 ILE A 225      -0.292  12.045  14.859  1.00 47.13           C  
ATOM   1690  CG2 ILE A 225      -0.685   9.696  14.133  1.00 45.02           C  
ATOM   1691  CD1 ILE A 225      -1.363  12.534  15.812  1.00 46.93           C  
ATOM   1692  N   GLU A 226       0.727   9.690  10.956  1.00 44.93           N  
ATOM   1693  CA  GLU A 226       0.630   8.652   9.968  1.00 45.23           C  
ATOM   1694  C   GLU A 226      -0.289   7.518  10.437  1.00 47.15           C  
ATOM   1695  O   GLU A 226      -1.301   7.269   9.814  1.00 48.08           O  
ATOM   1696  CB  GLU A 226       2.039   8.164   9.604  1.00 42.81           C  
ATOM   1697  CG  GLU A 226       2.063   7.038   8.636  1.00 40.92           C  
ATOM   1698  CD  GLU A 226       3.423   6.850   7.997  1.00 41.10           C  
ATOM   1699  OE1 GLU A 226       4.330   7.689   8.193  1.00 39.37           O  
ATOM   1700  OE2 GLU A 226       3.589   5.850   7.270  1.00 44.91           O  
ATOM   1701  N   LYS A 227       0.067   6.833  11.516  1.00 49.38           N  
ATOM   1702  CA  LYS A 227      -0.825   5.842  12.134  1.00 52.37           C  
ATOM   1703  C   LYS A 227      -1.063   6.292  13.571  1.00 54.21           C  
ATOM   1704  O   LYS A 227      -0.128   6.590  14.313  1.00 54.52           O  
ATOM   1705  CB  LYS A 227      -0.238   4.428  12.122  1.00 51.92           C  
ATOM   1706  CG  LYS A 227       0.848   4.186  11.083  1.00 51.70           C  
ATOM   1707  CD  LYS A 227       0.980   2.679  10.745  1.00 51.71           C  
ATOM   1708  CE  LYS A 227       2.207   2.442   9.811  1.00 51.43           C  
ATOM   1709  NZ  LYS A 227       1.860   1.342   8.830  1.00 53.98           N  
ATOM   1710  N   ARG A 228      -2.314   6.350  13.952  1.00 57.25           N  
ATOM   1711  CA  ARG A 228      -2.702   6.968  15.185  1.00 60.76           C  
ATOM   1712  C   ARG A 228      -3.180   5.823  16.063  1.00 62.55           C  
ATOM   1713  O   ARG A 228      -4.342   5.473  16.078  1.00 63.41           O  
ATOM   1714  CB  ARG A 228      -3.801   7.999  14.868  1.00 61.85           C  
ATOM   1715  CG  ARG A 228      -4.469   8.724  16.028  1.00 64.25           C  
ATOM   1716  CD  ARG A 228      -5.535   9.706  15.519  1.00 66.50           C  
ATOM   1717  NE  ARG A 228      -4.949  10.743  14.662  1.00 66.62           N  
ATOM   1718  CZ  ARG A 228      -4.645  11.973  15.066  1.00 67.44           C  
ATOM   1719  NH1 ARG A 228      -4.885  12.348  16.329  1.00 68.56           N  
ATOM   1720  NH2 ARG A 228      -4.098  12.836  14.206  1.00 66.47           N  
ATOM   1721  N   THR A 229      -2.256   5.202  16.769  1.00 63.70           N  
ATOM   1722  CA  THR A 229      -2.583   4.002  17.526  1.00 65.41           C  
ATOM   1723  C   THR A 229      -2.890   4.396  18.964  1.00 68.70           C  
ATOM   1724  O   THR A 229      -2.110   5.082  19.606  1.00 68.57           O  
ATOM   1725  CB  THR A 229      -1.441   2.997  17.469  1.00 63.94           C  
ATOM   1726  OG1 THR A 229      -0.187   3.697  17.606  1.00 62.59           O  
ATOM   1727  CG2 THR A 229      -1.467   2.277  16.156  1.00 62.20           C  
ATOM   1728  N   VAL A 230      -4.046   3.987  19.461  1.00 73.55           N  
ATOM   1729  CA  VAL A 230      -4.470   4.419  20.777  1.00 78.00           C  
ATOM   1730  C   VAL A 230      -5.102   3.273  21.561  1.00 81.95           C  
ATOM   1731  O   VAL A 230      -5.359   2.197  21.029  1.00 81.44           O  
ATOM   1732  CB  VAL A 230      -5.422   5.659  20.703  1.00 78.65           C  
ATOM   1733  CG1 VAL A 230      -4.714   6.881  20.096  1.00 75.36           C  
ATOM   1734  CG2 VAL A 230      -6.700   5.334  19.932  1.00 79.86           C  
ATOM   1735  N   GLN A 231      -5.289   3.498  22.847  1.00 87.13           N  
ATOM   1736  CA  GLN A 231      -6.135   2.637  23.663  1.00 93.59           C  
ATOM   1737  C   GLN A 231      -7.123   3.541  24.385  1.00 98.11           C  
ATOM   1738  O   GLN A 231      -6.922   4.754  24.444  1.00 98.26           O  
ATOM   1739  CB  GLN A 231      -5.310   1.829  24.668  1.00 92.81           C  
ATOM   1740  CG  GLN A 231      -4.536   2.658  25.697  1.00 93.49           C  
ATOM   1741  CD  GLN A 231      -3.680   1.788  26.618  1.00 95.25           C  
ATOM   1742  OE1 GLN A 231      -4.200   0.684  27.133  1.00 96.88           O  
ATOM   1743  NE2 GLN A 231      -2.363   2.279  26.832  1.00 94.78           N  
ATOM   1744  N   GLN A 232      -8.191   2.966  24.925  1.00104.59           N  
ATOM   1745  CA  GLN A 232      -9.042   3.722  25.842  1.00110.35           C  
ATOM   1746  C   GLN A 232      -9.646   2.846  26.913  1.00112.70           C  
ATOM   1747  O   GLN A 232      -9.569   1.631  26.811  1.00114.17           O  
ATOM   1748  CB  GLN A 232     -10.119   4.484  25.072  1.00111.75           C  
ATOM   1749  CG  GLN A 232     -11.259   3.661  24.546  1.00117.91           C  
ATOM   1750  CD  GLN A 232     -12.480   4.555  24.270  1.00126.67           C  
ATOM   1751  OE1 GLN A 232     -13.561   4.396  24.897  1.00130.55           O  
ATOM   1752  NE2 GLN A 232     -12.305   5.531  23.360  1.00127.28           N  
TER    1753      GLN A 232                                                      
END
MOLECULE T0438_2_186.pdb
ATOM      1  N   GLN     2      22.301  40.864  20.451  1.00 45.66          
ATOM      2  CA  GLN     2      20.920  40.443  20.090  1.00 45.49          
ATOM      3  C   GLN     2      21.031  39.501  18.881  1.00 45.02          
ATOM      4  O   GLN     2      21.727  39.738  17.859  1.00 44.52          
ATOM      5  CB  GLN     2      20.001  41.664  19.812  1.00 45.68          
ATOM      6  CG  GLN     2      20.247  42.944  20.771  1.00 48.87          
ATOM      7  CD  GLN     2      21.138  44.133  20.172  1.00 50.18          
ATOM      8  OE1 GLN     2      21.022  44.439  18.977  1.00 51.19          
ATOM      9  NE2 GLN     2      21.973  44.802  21.024  1.00 46.81          
ATOM     10  N   TRP     3      20.369  38.376  19.023  1.00 44.69          
ATOM     11  CA  TRP     3      20.378  37.380  17.946  1.00 44.23          
ATOM     12  C   TRP     3      19.071  37.457  17.150  1.00 44.35          
ATOM     13  O   TRP     3      19.030  37.083  15.975  1.00 44.41          
ATOM     14  CB  TRP     3      20.611  35.966  18.508  1.00 42.96          
ATOM     15  CG  TRP     3      19.780  35.702  19.684  1.00 40.96          
ATOM     16  CD1 TRP     3      20.138  35.839  20.974  1.00 39.33          
ATOM     17  CD2 TRP     3      18.406  35.292  19.676  1.00 43.16          
ATOM     18  NE1 TRP     3      19.085  35.522  21.796  1.00 39.72          
ATOM     19  CE2 TRP     3      18.004  35.166  21.034  1.00 40.34          
ATOM     20  CE3 TRP     3      17.461  34.979  18.646  1.00 44.38          
ATOM     21  CZ2 TRP     3      16.695  34.773  21.418  1.00 38.75          
ATOM     22  CZ3 TRP     3      16.145  34.560  19.037  1.00 42.51          
ATOM     23  CH2 TRP     3      15.785  34.475  20.423  1.00 39.71          
ATOM     24  N   GLN     4      18.007  37.933  17.818  1.00 43.59          
ATOM     25  CA  GLN     4      16.729  38.267  17.159  1.00 42.20          
ATOM     26  C   GLN     4      16.911  39.288  16.033  1.00 40.57          
ATOM     27  O   GLN     4      16.105  39.369  15.127  1.00 40.61          
ATOM     28  CB  GLN     4      15.650  38.703  18.176  1.00 41.88          
ATOM     29  CG  GLN     4      16.136  39.685  19.247  1.00 42.96          
ATOM     30  CD  GLN     4      16.105  39.113  20.670  1.00 41.76          
ATOM     31  OE1 GLN     4      16.802  38.164  20.968  1.00 40.40          
ATOM     32  NE2 GLN     4      15.315  39.734  21.554  1.00 42.64          
ATOM     33  N   GLU     5      17.981  40.051  16.056  1.00 39.51          
ATOM     34  CA  GLU     5      18.176  40.924  14.951  1.00 39.47          
ATOM     35  C   GLU     5      18.675  40.092  13.761  1.00 37.95          
ATOM     36  O   GLU     5      18.368  40.367  12.611  1.00 36.65          
ATOM     37  CB  GLU     5      19.087  42.065  15.341  1.00 40.78          
ATOM     38  CG  GLU     5      19.214  43.177  14.290  1.00 48.67          
ATOM     39  CD  GLU     5      17.900  43.902  13.832  1.00 58.49          
ATOM     40  OE1 GLU     5      16.712  43.385  13.955  1.00 62.56          
ATOM     41  OE2 GLU     5      18.077  45.040  13.290  1.00 61.65          
ATOM     42  N   LEU     6      19.385  39.008  14.055  1.00 37.32          
ATOM     43  CA  LEU     6      19.644  37.958  13.054  1.00 35.46          
ATOM     44  C   LEU     6      18.402  37.140  12.689  1.00 34.95          
ATOM     45  O   LEU     6      18.210  36.788  11.527  1.00 34.26          
ATOM     46  CB  LEU     6      20.673  36.969  13.565  1.00 34.98          
ATOM     47  CG  LEU     6      21.750  36.771  12.565  1.00 31.82          
ATOM     48  CD1 LEU     6      22.286  38.168  12.572  1.00 27.40          
ATOM     49  CD2 LEU     6      22.674  35.746  13.153  1.00 30.24          
ATOM     50  N   TYR     7      17.585  36.824  13.686  1.00 34.57          
ATOM     51  CA  TYR     7      16.383  36.095  13.435  1.00 35.06          
ATOM     52  C   TYR     7      15.707  36.885  12.365  1.00 35.55          
ATOM     53  O   TYR     7      15.350  36.315  11.331  1.00 37.74          
ATOM     54  CB  TYR     7      15.505  36.072  14.657  1.00 36.13          
ATOM     55  CG  TYR     7      14.278  35.179  14.558  1.00 37.33          
ATOM     56  CD1 TYR     7      14.341  33.886  15.033  1.00 38.27          
ATOM     57  CD2 TYR     7      13.063  35.630  14.030  1.00 35.78          
ATOM     58  CE1 TYR     7      13.280  33.080  14.995  1.00 37.74          
ATOM     59  CE2 TYR     7      11.974  34.823  13.995  1.00 35.57          
ATOM     60  CZ  TYR     7      12.095  33.528  14.486  1.00 38.65          
ATOM     61  OH  TYR     7      11.067  32.566  14.469  1.00 42.57          
ATOM     62  N   ARG     8      15.578  38.199  12.570  1.00 34.26          
ATOM     63  CA  ARG     8      14.849  39.002  11.639  1.00 33.10          
ATOM     64  C   ARG     8      15.563  38.954  10.305  1.00 31.22          
ATOM     65  O   ARG     8      14.916  38.742   9.332  1.00 30.95          
ATOM     66  CB  ARG     8      14.490  40.421  12.194  1.00 34.39          
ATOM     67  CG  ARG     8      13.122  40.469  12.931  1.00 38.53          
ATOM     68  CD  ARG     8      11.938  39.837  12.015  1.00 46.29          
ATOM     69  NE  ARG     8      10.943  38.935  12.696  1.00 46.06          
ATOM     70  CZ  ARG     8       9.769  38.435  12.158  1.00 42.31          
ATOM     71  NH1 ARG     8       9.426  38.718  10.884  1.00 38.18          
ATOM     72  NH2 ARG     8       8.952  37.646  12.915  1.00 37.18          
ATOM     73  N   GLN     9      16.876  39.075  10.243  1.00 29.86          
ATOM     74  CA  GLN     9      17.528  39.242   8.935  1.00 29.54          
ATOM     75  C   GLN     9      17.539  37.961   8.008  1.00 29.51          
ATOM     76  O   GLN     9      17.934  38.043   6.805  1.00 29.97          
ATOM     77  CB  GLN     9      18.940  39.867   9.110  1.00 29.11          
ATOM     78  CG  GLN     9      19.927  39.779   7.874  1.00 31.47          
ATOM     79  CD  GLN     9      21.436  39.404   8.260  1.00 34.75          
ATOM     80  OE1 GLN     9      22.120  40.202   8.961  1.00 41.31          
ATOM     81  NE2 GLN     9      21.936  38.195   7.809  1.00 34.17          
ATOM     82  N   ARG    10      17.103  36.791   8.536  1.00 27.99          
ATOM     83  CA  ARG    10      17.257  35.479   7.837  1.00 25.47          
ATOM     84  C   ARG    10      15.915  34.801   7.610  1.00 23.91          
ATOM     85  O   ARG    10      15.835  33.715   7.021  1.00 21.35          
ATOM     86  CB  ARG    10      18.087  34.539   8.711  1.00 25.21          
ATOM     87  CG  ARG    10      19.643  34.464   8.447  1.00 24.12          
ATOM     88  CD  ARG    10      20.453  34.545   9.747  1.00 20.79          
ATOM     89  NE  ARG    10      21.708  33.838   9.752  1.00 20.44          
ATOM     90  CZ  ARG    10      22.836  34.319   9.288  1.00 26.06          
ATOM     91  NH1 ARG    10      22.938  35.531   8.710  1.00 31.79          
ATOM     92  NH2 ARG    10      23.893  33.561   9.367  1.00 26.81          
ATOM     93  N   VAL    11      14.856  35.411   8.147  1.00 23.51          
ATOM     94  CA  VAL    11      13.468  34.939   7.856  1.00 24.18          
ATOM     95  C   VAL    11      12.950  35.245   6.394  1.00 24.54          
ATOM     96  O   VAL    11      13.170  36.348   5.886  1.00 25.11          
ATOM     97  CB  VAL    11      12.442  35.295   8.996  1.00 23.08          
ATOM     98  CG1 VAL    11      12.697  36.579   9.455  1.00 22.94          
ATOM     99  CG2 VAL    11      11.053  35.250   8.541  1.00 21.30          
ATOM    100  N   CYS    12      12.364  34.229   5.725  1.00 23.75          
ATOM    101  CA  CYS    12      11.746  34.327   4.406  1.00 23.05          
ATOM    102  C   CYS    12      10.544  33.390   4.344  1.00 22.52          
ATOM    103  O   CYS    12      10.106  32.858   5.350  1.00 22.55          
ATOM    104  CB  CYS    12      12.742  34.040   3.276  1.00 22.22          
ATOM    105  SG  CYS    12      13.790  32.594   3.587  1.00 26.12          
ATOM    106  N   SER    13       9.984  33.237   3.157  1.00 22.63          
ATOM    107  CA  SER    13       8.885  32.332   2.923  1.00 21.87          
ATOM    108  C   SER    13       9.543  31.066   2.564  1.00 20.56          
ATOM    109  O   SER    13      10.679  31.034   2.134  1.00 19.95          
ATOM    110  CB  SER    13       8.045  32.773   1.689  1.00 22.74          
ATOM    111  OG  SER    13       8.782  32.631   0.471  1.00 22.51          
ATOM    112  N   ALA    14       8.778  30.012   2.647  1.00 19.68          
ATOM    113  CA  ALA    14       9.261  28.772   2.182  1.00 18.20          
ATOM    114  C   ALA    14       9.767  28.969   0.743  1.00 17.81          
ATOM    115  O   ALA    14      10.901  28.543   0.407  1.00 17.26          
ATOM    116  CB  ALA    14       8.174  27.770   2.255  1.00 17.48          
ATOM    117  N   ASP    15       8.965  29.650  -0.075  1.00 17.40          
ATOM    118  CA  ASP    15       9.211  29.686  -1.539  1.00 17.58          
ATOM    119  C   ASP    15      10.487  30.433  -1.836  1.00 17.51          
ATOM    120  O   ASP    15      11.311  30.009  -2.674  1.00 17.85          
ATOM    121  CB  ASP    15       8.085  30.371  -2.306  1.00 17.43          
ATOM    122  CG  ASP    15       6.708  29.566  -2.297  1.00 22.38          
ATOM    123  OD1 ASP    15       6.459  28.807  -3.287  1.00 24.07          
ATOM    124  OD2 ASP    15       5.803  29.661  -1.385  1.00 24.81          
ATOM    125  N   GLU    16      10.707  31.526  -1.100  1.00 17.22          
ATOM    126  CA  GLU    16      11.910  32.289  -1.307  1.00 15.21          
ATOM    127  C   GLU    16      13.102  31.449  -0.897  1.00 13.71          
ATOM    128  O   GLU    16      14.168  31.458  -1.579  1.00 12.05          
ATOM    129  CB  GLU    16      11.879  33.572  -0.545  1.00 16.27          
ATOM    130  CG  GLU    16      10.687  34.467  -0.728  1.00 18.47          
ATOM    131  CD  GLU    16      10.627  35.488   0.412  1.00 26.97          
ATOM    132  OE1 GLU    16      10.572  35.074   1.619  1.00 27.31          
ATOM    133  OE2 GLU    16      10.677  36.723   0.119  1.00 25.64          
ATOM    134  N   ALA    17      12.934  30.701   0.189  1.00 12.99          
ATOM    135  CA  ALA    17      14.004  29.727   0.575  1.00 13.65          
ATOM    136  C   ALA    17      14.275  28.533  -0.412  1.00 13.45          
ATOM    137  O   ALA    17      15.406  28.291  -0.777  1.00 12.07          
ATOM    138  CB  ALA    17      13.840  29.269   1.950  1.00 12.61          
ATOM    139  N   VAL    18      13.248  27.833  -0.865  1.00 14.16          
ATOM    140  CA  VAL    18      13.421  26.938  -2.017  1.00 16.22          
ATOM    141  C   VAL    18      14.161  27.625  -3.160  1.00 16.91          
ATOM    142  O   VAL    18      15.203  27.158  -3.659  1.00 16.37          
ATOM    143  CB  VAL    18      12.060  26.490  -2.624  1.00 15.97          
ATOM    144  CG1 VAL    18      12.246  25.850  -3.927  1.00 15.99          
ATOM    145  CG2 VAL    18      11.378  25.552  -1.751  1.00 17.31          
ATOM    146  N   VAL    19      13.630  28.729  -3.615  1.00 18.11          
ATOM    147  CA  VAL    19      14.321  29.245  -4.759  1.00 21.42          
ATOM    148  C   VAL    19      15.773  29.606  -4.525  1.00 23.57          
ATOM    149  O   VAL    19      16.554  29.291  -5.385  1.00 24.74          
ATOM    150  CB  VAL    19      13.635  30.342  -5.447  1.00 21.17          
ATOM    151  CG1 VAL    19      14.518  30.812  -6.572  1.00 20.43          
ATOM    152  CG2 VAL    19      12.330  29.809  -5.973  1.00 20.70          
ATOM    153  N   ASP    20      16.134  30.245  -3.402  1.00 25.89          
ATOM    154  CA  ASP    20      17.526  30.727  -3.203  1.00 28.38          
ATOM    155  C   ASP    20      18.424  29.612  -2.765  1.00 28.06          
ATOM    156  O   ASP    20      19.595  29.604  -3.031  1.00 28.27          
ATOM    157  CB  ASP    20      17.637  31.923  -2.223  1.00 29.34          
ATOM    158  CG  ASP    20      16.938  33.232  -2.806  1.00 39.37          
ATOM    159  OD1 ASP    20      17.516  33.774  -3.826  1.00 46.87          
ATOM    160  OD2 ASP    20      15.794  33.745  -2.406  1.00 40.49          
ATOM    161  N   SER    21      17.878  28.628  -2.101  1.00 27.91          
ATOM    162  CA  SER    21      18.755  27.626  -1.596  1.00 26.75          
ATOM    163  C   SER    21      18.865  26.472  -2.577  1.00 26.31          
ATOM    164  O   SER    21      19.719  25.654  -2.375  1.00 27.08          
ATOM    165  CB  SER    21      18.218  27.089  -0.292  1.00 27.05          
ATOM    166  OG  SER    21      17.116  26.217  -0.582  1.00 25.99          
ATOM    167  N   LEU    22      18.044  26.376  -3.621  1.00 24.68          
ATOM    168  CA  LEU    22      18.091  25.146  -4.364  1.00 23.84          
ATOM    169  C   LEU    22      18.634  25.283  -5.715  1.00 24.93          
ATOM    170  O   LEU    22      17.903  25.130  -6.731  1.00 26.26          
ATOM    171  CB  LEU    22      16.730  24.506  -4.461  1.00 23.97          
ATOM    172  CG  LEU    22      16.233  23.925  -3.138  1.00 22.50          
ATOM    173  CD1 LEU    22      15.176  22.905  -3.324  1.00 18.72          
ATOM    174  CD2 LEU    22      17.411  23.302  -2.398  1.00 22.66          
ATOM    175  N   LYS    23      19.929  25.542  -5.766  1.00 25.02          
ATOM    176  CA  LYS    23      20.602  25.712  -7.053  1.00 24.74          
ATOM    177  C   LYS    23      20.478  24.399  -7.888  1.00 24.03          
ATOM    178  O   LYS    23      20.452  23.302  -7.324  1.00 21.81          
ATOM    179  CB  LYS    23      22.076  26.201  -6.833  1.00 26.07          
ATOM    180  CG  LYS    23      22.142  27.600  -6.255  1.00 26.45          
ATOM    181  CD  LYS    23      20.911  28.383  -6.874  1.00 35.77          
ATOM    182  CE  LYS    23      20.688  29.922  -6.412  1.00 38.56          
ATOM    183  NZ  LYS    23      22.012  30.720  -6.220  1.00 42.87          
ATOM    184  N   PRO    24      20.377  24.511  -9.222  1.00 24.19          
ATOM    185  CA  PRO    24      20.483  23.338 -10.101  1.00 23.91          
ATOM    186  C   PRO    24      21.574  22.320  -9.658  1.00 24.25          
ATOM    187  O   PRO    24      22.636  22.659  -9.149  1.00 22.93          
ATOM    188  CB  PRO    24      20.836  23.955 -11.450  1.00 22.57          
ATOM    189  CG  PRO    24      20.402  25.315 -11.423  1.00 22.41          
ATOM    190  CD  PRO    24      20.124  25.737 -10.011  1.00 24.33          
ATOM    191  N   GLY    25      21.275  21.047  -9.843  1.00 24.91          
ATOM    192  CA  GLY    25      22.148  20.025  -9.339  1.00 22.99          
ATOM    193  C   GLY    25      22.373  19.939  -7.830  1.00 21.94          
ATOM    194  O   GLY    25      23.206  19.174  -7.452  1.00 22.50          
ATOM    195  N   THR    26      21.700  20.674  -6.943  1.00 20.84          
ATOM    196  CA  THR    26      21.987  20.496  -5.476  1.00 20.59          
ATOM    197  C   THR    26      21.419  19.186  -4.937  1.00 19.89          
ATOM    198  O   THR    26      20.437  18.732  -5.457  1.00 21.69          
ATOM    199  CB  THR    26      21.463  21.673  -4.642  1.00 19.97          
ATOM    200  OG1 THR    26      20.344  22.178  -5.331  1.00 22.62          
ATOM    201  CG2 THR    26      22.423  22.922  -4.718  1.00 23.49          
ATOM    202  N   LYS    27      22.040  18.572  -3.930  1.00 18.30          
ATOM    203  CA  LYS    27      21.432  17.516  -3.152  1.00 16.74          
ATOM    204  C   LYS    27      20.976  17.989  -1.786  1.00 16.46          
ATOM    205  O   LYS    27      21.687  18.729  -1.131  1.00 16.95          
ATOM    206  CB  LYS    27      22.493  16.509  -2.873  1.00 17.33          
ATOM    207  CG  LYS    27      23.179  16.134  -4.116  1.00 17.67          
ATOM    208  CD  LYS    27      24.649  15.882  -3.889  1.00 18.17          
ATOM    209  CE  LYS    27      25.100  14.632  -4.679  1.00 20.52          
ATOM    210  NZ  LYS    27      24.686  14.634  -6.118  1.00 22.18          
ATOM    211  N   VAL    28      19.841  17.508  -1.290  1.00 15.30          
ATOM    212  CA  VAL    28      19.279  18.066  -0.095  1.00 13.17          
ATOM    213  C   VAL    28      18.931  16.923   0.743  1.00 13.67          
ATOM    214  O   VAL    28      18.713  15.848   0.183  1.00 14.25          
ATOM    215  CB  VAL    28      18.033  18.943  -0.454  1.00 13.52          
ATOM    216  CG1 VAL    28      17.997  19.224  -1.929  1.00  9.64          
ATOM    217  CG2 VAL    28      16.757  18.404  -0.006  1.00 12.80          
ATOM    218  N   VAL    29      18.846  17.111   2.062  1.00 13.68          
ATOM    219  CA  VAL    29      18.433  16.035   2.988  1.00 13.42          
ATOM    220  C   VAL    29      17.292  16.589   3.831  1.00 14.82          
ATOM    221  O   VAL    29      17.375  17.720   4.317  1.00 14.92          
ATOM    222  CB  VAL    29      19.678  15.573   3.949  1.00 14.04          
ATOM    223  CG1 VAL    29      19.218  14.745   5.141  1.00 13.89          
ATOM    224  CG2 VAL    29      20.792  14.776   3.215  1.00  9.61          
ATOM    225  N   PHE    30      16.211  15.841   4.048  1.00 16.24          
ATOM    226  CA  PHE    30      15.112  16.383   4.929  1.00 15.93          
ATOM    227  C   PHE    30      15.142  15.725   6.246  1.00 17.61          
ATOM    228  O   PHE    30      15.413  14.539   6.318  1.00 18.72          
ATOM    229  CB  PHE    30      13.751  16.049   4.393  1.00 15.13          
ATOM    230  CG  PHE    30      13.355  16.807   3.122  1.00 16.71          
ATOM    231  CD1 PHE    30      12.130  16.473   2.454  1.00 13.37          
ATOM    232  CD2 PHE    30      14.143  17.855   2.618  1.00 14.25          
ATOM    233  CE1 PHE    30      11.714  17.102   1.339  1.00  7.85          
ATOM    234  CE2 PHE    30      13.709  18.537   1.509  1.00 14.62          
ATOM    235  CZ  PHE    30      12.489  18.150   0.845  1.00 15.33          
ATOM    236  N   GLY    31      14.862  16.447   7.324  1.00 20.63          
ATOM    237  CA  GLY    31      14.907  15.849   8.729  1.00 23.62          
ATOM    238  C   GLY    31      13.764  14.870   8.742  1.00 25.45          
ATOM    239  O   GLY    31      12.886  14.924   7.814  1.00 25.70          
ATOM    240  N   HSD    32      13.717  13.921   9.681  1.00 27.22          
ATOM    241  CA  HSD    32      12.664  12.907   9.339  1.00 27.58          
ATOM    242  C   HSD    32      11.594  12.665  10.317  1.00 24.69          
ATOM    243  O   HSD    32      11.641  13.260  11.315  1.00 23.64          
ATOM    244  CB  HSD    32      13.203  11.593   8.699  1.00 29.84          
ATOM    245  CG  HSD    32      13.512  10.536   9.708  1.00 30.57          
ATOM    246  ND1 HSD    32      14.035  10.857  10.955  1.00 33.64          
ATOM    247  CD2 HSD    32      13.316   9.191   9.688  1.00 23.42          
ATOM    248  CE1 HSD    32      14.171   9.722  11.644  1.00 34.23          
ATOM    249  NE2 HSD    32      13.731   8.711  10.906  1.00 24.90          
ATOM    250  N   ALA    33      10.600  11.851   9.922  1.00 23.60          
ATOM    251  CA  ALA    33       9.577  11.246  10.798  1.00 22.77          
ATOM    252  C   ALA    33       8.559  12.357  10.980  1.00 22.68          
ATOM    253  O   ALA    33       7.988  12.811   9.974  1.00 24.97          
ATOM    254  CB  ALA    33      10.154  10.728  12.138  1.00 22.02          
ATOM    255  N   ALA    34       8.327  12.826  12.213  1.00 21.17          
ATOM    256  CA  ALA    34       7.248  13.789  12.461  1.00 18.34          
ATOM    257  C   ALA    34       7.829  15.166  12.415  1.00 17.88          
ATOM    258  O   ALA    34       7.059  16.105  12.626  1.00 19.36          
ATOM    259  CB  ALA    34       6.557  13.552  13.782  1.00 17.06          
ATOM    260  N   ALA    35       9.123  15.287  12.054  1.00 15.79          
ATOM    261  CA  ALA    35       9.798  16.548  11.976  1.00 15.94          
ATOM    262  C   ALA    35      10.119  16.850  10.567  1.00 17.19          
ATOM    263  O   ALA    35      10.953  17.725  10.322  1.00 18.60          
ATOM    264  CB  ALA    35      11.079  16.542  12.757  1.00 15.24          
ATOM    265  N   ALA    36       9.494  16.108   9.656  1.00 18.19          
ATOM    266  CA  ALA    36       9.643  16.199   8.200  1.00 18.59          
ATOM    267  C   ALA    36       9.093  17.570   7.723  1.00 19.68          
ATOM    268  O   ALA    36       8.035  17.993   8.199  1.00 20.43          
ATOM    269  CB  ALA    36       8.852  15.070   7.575  1.00 18.13          
ATOM    270  N   PRO    37       9.807  18.291   6.856  1.00 19.40          
ATOM    271  CA  PRO    37       9.494  19.653   6.592  1.00 19.11          
ATOM    272  C   PRO    37       8.652  19.746   5.328  1.00 19.82          
ATOM    273  O   PRO    37       9.069  20.090   4.211  1.00 19.21          
ATOM    274  CB  PRO    37      10.877  20.291   6.449  1.00 19.33          
ATOM    275  CG  PRO    37      11.789  19.190   6.242  1.00 19.25          
ATOM    276  CD  PRO    37      11.030  17.897   6.136  1.00 19.94          
ATOM    277  N   VAL    38       7.402  19.462   5.573  1.00 21.02          
ATOM    278  CA  VAL    38       6.420  19.357   4.562  1.00 21.32          
ATOM    279  C   VAL    38       6.151  20.724   3.945  1.00 21.37          
ATOM    280  O   VAL    38       5.880  20.781   2.742  1.00 22.79          
ATOM    281  CB  VAL    38       5.198  18.633   5.149  1.00 20.45          
ATOM    282  CG1 VAL    38       5.005  19.063   6.573  1.00 21.69          
ATOM    283  CG2 VAL    38       3.953  18.894   4.314  1.00 23.80          
ATOM    284  N   ARG    39       6.251  21.828   4.695  1.00 21.58          
ATOM    285  CA  ARG    39       6.057  23.200   4.058  1.00 21.31          
ATOM    286  C   ARG    39       6.993  23.492   2.937  1.00 20.54          
ATOM    287  O   ARG    39       6.626  24.009   1.881  1.00 20.63          
ATOM    288  CB  ARG    39       6.234  24.299   5.063  1.00 20.92          
ATOM    289  CG  ARG    39       4.886  24.753   5.544  1.00 23.30          
ATOM    290  CD  ARG    39       4.194  23.790   6.423  1.00 22.38          
ATOM    291  NE  ARG    39       5.084  23.064   7.343  1.00 21.17          
ATOM    292  CZ  ARG    39       4.580  22.148   8.167  1.00 22.55          
ATOM    293  NH1 ARG    39       5.357  21.445   8.985  1.00 21.29          
ATOM    294  NH2 ARG    39       3.258  21.917   8.140  1.00 18.42          
ATOM    295  N   PHE    40       8.233  23.154   3.218  1.00 20.34          
ATOM    296  CA  PHE    40       9.247  23.150   2.258  1.00 19.91          
ATOM    297  C   PHE    40       8.970  22.162   1.149  1.00 21.28          
ATOM    298  O   PHE    40       9.204  22.510  -0.020  1.00 24.41          
ATOM    299  CB  PHE    40      10.528  22.765   2.901  1.00 18.96          
ATOM    300  CG  PHE    40      11.745  23.205   2.122  1.00 17.88          
ATOM    301  CD1 PHE    40      12.305  22.402   1.152  1.00 16.72          
ATOM    302  CD2 PHE    40      12.311  24.425   2.343  1.00 15.73          
ATOM    303  CE1 PHE    40      13.440  22.782   0.458  1.00 13.55          
ATOM    304  CE2 PHE    40      13.397  24.793   1.635  1.00 18.00          
ATOM    305  CZ  PHE    40      13.987  23.926   0.683  1.00 14.48          
ATOM    306  N   SER    41       8.474  20.950   1.419  1.00 21.03          
ATOM    307  CA  SER    41       8.101  20.048   0.285  1.00 20.01          
ATOM    308  C   SER    41       7.008  20.685  -0.618  1.00 20.61          
ATOM    309  O   SER    41       7.081  20.734  -1.879  1.00 18.08          
ATOM    310  CB  SER    41       7.692  18.671   0.799  1.00 19.44          
ATOM    311  OG  SER    41       7.220  17.809  -0.243  1.00 19.22          
ATOM    312  N   GLN    42       6.026  21.262   0.089  1.00 23.29          
ATOM    313  CA  GLN    42       4.854  22.015  -0.501  1.00 23.53          
ATOM    314  C   GLN    42       5.526  23.094  -1.367  1.00 21.04          
ATOM    315  O   GLN    42       5.265  23.134  -2.564  1.00 21.64          
ATOM    316  CB  GLN    42       3.896  22.569   0.635  1.00 24.61          
ATOM    317  CG  GLN    42       2.364  22.442   0.482  1.00 30.98          
ATOM    318  CD  GLN    42       1.797  21.221   1.339  1.00 42.73          
ATOM    319  OE1 GLN    42       1.886  21.261   2.617  1.00 44.13          
ATOM    320  NE2 GLN    42       1.217  20.140   0.639  1.00 39.64          
ATOM    321  N   ALA    43       6.451  23.901  -0.817  1.00 18.30          
ATOM    322  CA  ALA    43       7.058  24.957  -1.689  1.00 17.00          
ATOM    323  C   ALA    43       7.867  24.463  -2.881  1.00 15.00          
ATOM    324  O   ALA    43       7.953  25.133  -3.863  1.00 11.84          
ATOM    325  CB  ALA    43       7.842  26.061  -0.891  1.00 17.47          
ATOM    326  N   MET    44       8.465  23.290  -2.765  1.00 14.50          
ATOM    327  CA  MET    44       9.171  22.718  -3.905  1.00 15.39          
ATOM    328  C   MET    44       8.180  22.315  -4.982  1.00 12.22          
ATOM    329  O   MET    44       8.453  22.459  -6.155  1.00 10.78          
ATOM    330  CB  MET    44      10.004  21.489  -3.456  1.00 16.06          
ATOM    331  CG  MET    44      11.325  21.827  -2.668  1.00 18.15          
ATOM    332  SD  MET    44      12.072  20.295  -2.106  1.00 20.97          
ATOM    333  CE  MET    44      13.066  19.768  -3.438  1.00 18.66          
ATOM    334  N   TYR    45       7.032  21.785  -4.580  1.00 10.67          
ATOM    335  CA  TYR    45       5.946  21.600  -5.542  1.00 10.06          
ATOM    336  C   TYR    45       5.572  22.889  -6.326  1.00  9.87          
ATOM    337  O   TYR    45       5.709  22.956  -7.562  1.00  8.45          
ATOM    338  CB  TYR    45       4.676  21.096  -4.889  1.00  9.54          
ATOM    339  CG  TYR    45       3.695  20.666  -5.899  1.00 10.38          
ATOM    340  CD1 TYR    45       3.758  19.374  -6.440  1.00 12.83          
ATOM    341  CD2 TYR    45       2.722  21.530  -6.378  1.00 13.04          
ATOM    342  CE1 TYR    45       2.851  18.920  -7.393  1.00  9.77          
ATOM    343  CE2 TYR    45       1.831  21.105  -7.362  1.00 12.73          
ATOM    344  CZ  TYR    45       1.896  19.781  -7.881  1.00 10.42          
ATOM    345  OH  TYR    45       1.007  19.310  -8.869  1.00  9.11          
ATOM    346  N   ARG    46       5.079  23.900  -5.622  1.00  9.05          
ATOM    347  CA  ARG    46       4.776  25.139  -6.317  1.00  9.66          
ATOM    348  C   ARG    46       5.910  25.661  -7.187  1.00 10.23          
ATOM    349  O   ARG    46       5.632  26.166  -8.245  1.00 12.26          
ATOM    350  CB  ARG    46       4.439  26.213  -5.329  1.00  9.96          
ATOM    351  CG  ARG    46       3.314  25.881  -4.450  1.00 13.07          
ATOM    352  CD  ARG    46       2.823  27.089  -3.757  1.00 15.66          
ATOM    353  NE  ARG    46       3.804  27.393  -2.785  1.00 13.78          
ATOM    354  CZ  ARG    46       3.789  26.881  -1.575  1.00 16.09          
ATOM    355  NH1 ARG    46       2.775  26.038  -1.199  1.00 13.23          
ATOM    356  NH2 ARG    46       4.827  27.215  -0.748  1.00 17.30          
ATOM    357  N   GLN    47       7.170  25.585  -6.745  1.00 10.28          
ATOM    358  CA  GLN    47       8.277  26.169  -7.466  1.00 10.77          
ATOM    359  C   GLN    47       8.893  25.199  -8.428  1.00 12.81          
ATOM    360  O   GLN    47       9.983  25.484  -8.888  1.00 13.62          
ATOM    361  CB  GLN    47       9.364  26.734  -6.537  1.00  9.13          
ATOM    362  CG  GLN    47       8.858  27.863  -5.590  1.00  8.69          
ATOM    363  CD  GLN    47       8.302  29.097  -6.313  1.00 12.55          
ATOM    364  OE1 GLN    47       9.001  29.654  -7.183  1.00 12.81          
ATOM    365  NE2 GLN    47       7.028  29.512  -5.999  1.00 10.02          
ATOM    366  N   ARG    48       8.234  24.070  -8.757  1.00 14.75          
ATOM    367  CA  ARG    48       8.882  23.003  -9.600  1.00 16.22          
ATOM    368  C   ARG    48       9.508  23.394 -10.941  1.00 18.74          
ATOM    369  O   ARG    48      10.503  22.813 -11.415  1.00 19.44          
ATOM    370  CB  ARG    48       7.955  21.872  -9.857  1.00 15.11          
ATOM    371  CG  ARG    48       6.812  22.197 -10.649  1.00 12.28          
ATOM    372  CD  ARG    48       5.739  21.130 -10.387  1.00 14.04          
ATOM    373  NE  ARG    48       4.596  21.083 -11.320  1.00 12.26          
ATOM    374  CZ  ARG    48       3.366  21.456 -11.022  1.00  7.88          
ATOM    375  NH1 ARG    48       2.382  21.322 -11.895  1.00 10.20          
ATOM    376  NH2 ARG    48       3.112  21.923  -9.830  1.00  8.03          
ATOM    377  N   GLU    49       8.945  24.443 -11.513  1.00 22.00          
ATOM    378  CA  GLU    49       9.142  24.778 -12.905  1.00 23.10          
ATOM    379  C   GLU    49      10.486  25.462 -12.887  1.00 21.97          
ATOM    380  O   GLU    49      11.117  25.564 -13.918  1.00 21.76          
ATOM    381  CB  GLU    49       7.956  25.675 -13.329  1.00 24.94          
ATOM    382  CG  GLU    49       6.632  25.427 -12.445  1.00 32.27          
ATOM    383  CD  GLU    49       5.382  24.838 -13.254  1.00 39.48          
ATOM    384  OE1 GLU    49       5.398  24.978 -14.542  1.00 42.88          
ATOM    385  OE2 GLU    49       4.371  24.278 -12.655  1.00 33.87          
ATOM    386  N   LYS    50      10.952  25.876 -11.706  1.00 20.75          
ATOM    387  CA  LYS    50      12.289  26.415 -11.602  1.00 21.27          
ATOM    388  C   LYS    50      13.357  25.454 -11.107  1.00 22.29          
ATOM    389  O   LYS    50      14.536  25.730 -11.349  1.00 22.17          
ATOM    390  CB  LYS    50      12.382  27.563 -10.644  1.00 20.60          
ATOM    391  CG  LYS    50      11.353  28.501 -10.782  1.00 23.73          
ATOM    392  CD  LYS    50      11.580  29.674  -9.798  1.00 32.88          
ATOM    393  CE  LYS    50      10.446  30.721  -9.868  1.00 34.86          
ATOM    394  NZ  LYS    50      10.027  30.892 -11.304  1.00 40.84          
ATOM    395  N   LEU    51      13.021  24.400 -10.357  1.00 22.84          
ATOM    396  CA  LEU    51      14.108  23.538  -9.925  1.00 24.35          
ATOM    397  C   LEU    51      14.666  22.590 -11.051  1.00 25.58          
ATOM    398  O   LEU    51      13.897  22.020 -11.885  1.00 24.86          
ATOM    399  CB  LEU    51      13.723  22.722  -8.703  1.00 25.21          
ATOM    400  CG  LEU    51      13.068  23.246  -7.435  1.00 24.94          
ATOM    401  CD1 LEU    51      13.734  24.504  -6.999  1.00 24.38          
ATOM    402  CD2 LEU    51      11.688  23.477  -7.833  1.00 24.87          
ATOM    403  N   GLU    52      15.991  22.427 -11.048  1.00 26.21          
ATOM    404  CA  GLU    52      16.666  21.582 -12.020  1.00 28.11          
ATOM    405  C   GLU    52      17.112  20.258 -11.418  1.00 27.85          
ATOM    406  O   GLU    52      16.266  19.421 -11.280  1.00 29.19          
ATOM    407  CB  GLU    52      17.830  22.289 -12.648  1.00 29.97          
ATOM    408  CG  GLU    52      17.450  23.278 -13.716  1.00 34.15          
ATOM    409  CD  GLU    52      17.371  22.581 -15.043  1.00 40.84          
ATOM    410  OE1 GLU    52      18.468  22.252 -15.589  1.00 41.08          
ATOM    411  OE2 GLU    52      16.210  22.347 -15.526  1.00 45.33          
ATOM    412  N   ASN    53      18.362  19.994 -11.063  1.00 26.32          
ATOM    413  CA  ASN    53      18.627  18.552 -10.795  1.00 26.13          
ATOM    414  C   ASN    53      18.692  18.238  -9.325  1.00 24.38          
ATOM    415  O   ASN    53      19.769  17.937  -8.795  1.00 24.90          
ATOM    416  CB  ASN    53      19.880  17.980 -11.476  1.00 27.32          
ATOM    417  CG  ASN    53      19.804  18.070 -12.970  1.00 33.09          
ATOM    418  OD1 ASN    53      18.812  17.618 -13.532  1.00 44.00          
ATOM    419  ND2 ASN    53      20.818  18.709 -13.638  1.00 35.87          
ATOM    420  N   ILE    54      17.566  18.308  -8.645  1.00 20.73          
ATOM    421  CA  ILE    54      17.685  18.294  -7.249  1.00 18.62          
ATOM    422  C   ILE    54      17.515  16.861  -6.767  1.00 18.10          
ATOM    423  O   ILE    54      16.558  16.202  -7.136  1.00 18.14          
ATOM    424  CB  ILE    54      16.653  19.228  -6.667  1.00 18.97          
ATOM    425  CG1 ILE    54      16.495  20.461  -7.562  1.00 18.42          
ATOM    426  CG2 ILE    54      16.981  19.512  -5.250  1.00 13.40          
ATOM    427  CD  ILE    54      17.589  21.414  -7.367  1.00 24.43          
ATOM    428  N   THR    55      18.431  16.379  -5.946  1.00 16.66          
ATOM    429  CA  THR    55      18.296  15.069  -5.355  1.00 17.48          
ATOM    430  C   THR    55      17.849  15.226  -3.939  1.00 17.26          
ATOM    431  O   THR    55      18.475  15.999  -3.210  1.00 17.34          
ATOM    432  CB  THR    55      19.670  14.425  -5.257  1.00 18.10          
ATOM    433  OG1 THR    55      20.177  14.302  -6.554  1.00 19.09          
ATOM    434  CG2 THR    55      19.567  12.992  -4.872  1.00 18.79          
ATOM    435  N   VAL    56      16.828  14.485  -3.492  1.00 16.58          
ATOM    436  CA  VAL    56      16.601  14.516  -2.035  1.00 17.07          
ATOM    437  C   VAL    56      16.821  13.213  -1.320  1.00 16.61          
ATOM    438  O   VAL    56      16.496  12.147  -1.837  1.00 14.95          
ATOM    439  CB  VAL    56      15.356  15.352  -1.560  1.00 16.13          
ATOM    440  CG1 VAL    56      14.273  15.165  -2.494  1.00 18.18          
ATOM    441  CG2 VAL    56      14.912  14.926  -0.175  1.00 15.60          
ATOM    442  N   PHE    57      17.468  13.294  -0.166  1.00 17.83          
ATOM    443  CA  PHE    57      17.566  12.104   0.653  1.00 20.29          
ATOM    444  C   PHE    57      16.736  12.226   1.919  1.00 20.07          
ATOM    445  O   PHE    57      16.657  13.302   2.565  1.00 21.59          
ATOM    446  CB  PHE    57      19.024  11.623   0.950  1.00 20.84          
ATOM    447  CG  PHE    57      19.062  10.550   2.007  1.00 22.77          
ATOM    448  CD1 PHE    57      19.228  10.887   3.360  1.00 24.36          
ATOM    449  CD2 PHE    57      18.769   9.213   1.664  1.00 27.03          
ATOM    450  CE1 PHE    57      19.180   9.884   4.395  1.00 26.23          
ATOM    451  CE2 PHE    57      18.697   8.214   2.674  1.00 28.83          
ATOM    452  CZ  PHE    57      18.906   8.564   4.072  1.00 23.10          
ATOM    453  N   HSD    58      16.086  11.132   2.231  1.00 20.79          
ATOM    454  CA  HSD    58      15.356  10.977   3.520  1.00 23.07          
ATOM    455  C   HSD    58      14.856   9.522   3.756  1.00 23.95          
ATOM    456  O   HSD    58      15.233   8.589   3.005  1.00 24.70          
ATOM    457  CB  HSD    58      14.229  12.033   3.710  1.00 22.43          
ATOM    458  CG  HSD    58      13.028  11.795   2.855  1.00 20.20          
ATOM    459  ND1 HSD    58      12.702  12.604   1.782  1.00 22.17          
ATOM    460  CD2 HSD    58      12.082  10.828   2.897  1.00 16.24          
ATOM    461  CE1 HSD    58      11.581  12.160   1.212  1.00 19.90          
ATOM    462  NE2 HSD    58      11.188  11.082   1.869  1.00 18.72          
ATOM    463  N   MET    59      14.047   9.349   4.804  1.00 24.79          
ATOM    464  CA  MET    59      13.649   8.032   5.330  1.00 25.10          
ATOM    465  C   MET    59      12.198   8.141   5.652  1.00 25.33          
ATOM    466  O   MET    59      11.461   8.248   4.747  1.00 27.43          
ATOM    467  CB  MET    59      14.502   7.639   6.529  1.00 23.90          
ATOM    468  CG  MET    59      15.867   7.184   6.090  1.00 24.27          
ATOM    469  SD  MET    59      16.994   6.955   7.482  1.00 27.42          
ATOM    470  CE  MET    59      17.542   5.314   6.896  1.00 24.67          
ATOM    471  N   LEU    60      11.756   8.168   6.909  1.00 26.46          
ATOM    472  CA  LEU    60      10.329   8.393   7.228  1.00 26.02          
ATOM    473  C   LEU    60       9.941   9.783   6.977  1.00 26.45          
ATOM    474  O   LEU    60      10.475  10.677   7.572  1.00 26.47          
ATOM    475  CB  LEU    60      10.035   8.147   8.709  1.00 25.84          
ATOM    476  CG  LEU    60      10.033   6.701   9.129  1.00 25.58          
ATOM    477  CD1 LEU    60       8.709   6.212   8.924  1.00 27.61          
ATOM    478  CD2 LEU    60      10.939   5.998   8.198  1.00 21.75          
ATOM    479  N   TYR    61       8.926   9.965   6.177  1.00 28.90          
ATOM    480  CA  TYR    61       8.262  11.269   6.102  1.00 30.96          
ATOM    481  C   TYR    61       6.851  11.029   6.539  1.00 30.13          
ATOM    482  O   TYR    61       6.155  10.179   5.967  1.00 28.73          
ATOM    483  CB  TYR    61       8.169  11.718   4.619  1.00 34.27          
ATOM    484  CG  TYR    61       7.359  10.683   3.650  1.00 41.40          
ATOM    485  CD1 TYR    61       7.983   9.487   3.067  1.00 44.61          
ATOM    486  CD2 TYR    61       5.936  10.900   3.304  1.00 46.34          
ATOM    487  CE1 TYR    61       7.195   8.579   2.125  1.00 40.74          
ATOM    488  CE2 TYR    61       5.166   9.985   2.389  1.00 39.60          
ATOM    489  CZ  TYR    61       5.817   8.870   1.840  1.00 38.96          
ATOM    490  OH  TYR    61       5.082   8.073   1.024  1.00 39.91          
ATOM    491  N   PHE    62       6.378  11.814   7.486  1.00 30.46          
ATOM    492  CA  PHE    62       4.942  11.940   7.685  1.00 30.51          
ATOM    493  C   PHE    62       4.272  13.216   7.040  1.00 30.96          
ATOM    494  O   PHE    62       4.502  14.243   7.611  1.00 30.96          
ATOM    495  CB  PHE    62       4.804  11.972   9.177  1.00 30.79          
ATOM    496  CG  PHE    62       5.309  10.724   9.877  1.00 30.41          
ATOM    497  CD1 PHE    62       5.704  10.780  11.212  1.00 32.62          
ATOM    498  CD2 PHE    62       5.307   9.497   9.257  1.00 30.78          
ATOM    499  CE1 PHE    62       6.144   9.622  11.925  1.00 31.31          
ATOM    500  CE2 PHE    62       5.753   8.336   9.940  1.00 32.05          
ATOM    501  CZ  PHE    62       6.160   8.405  11.287  1.00 31.82          
ATOM    502  N   GLY    63       3.548  13.163   5.852  1.00 32.78          
ATOM    503  CA  GLY    63       2.657  14.280   5.178  1.00 32.09          
ATOM    504  C   GLY    63       3.081  14.990   3.844  1.00 34.69          
ATOM    505  O   GLY    63       2.308  15.607   2.985  1.00 34.41          
ATOM    506  N   ASP    64       4.410  15.044   3.799  1.00 36.39          
ATOM    507  CA  ASP    64       5.309  15.294   2.680  1.00 35.00          
ATOM    508  C   ASP    64       4.753  14.780   1.366  1.00 34.29          
ATOM    509  O   ASP    64       5.276  13.798   0.809  1.00 33.58          
ATOM    510  CB  ASP    64       6.508  14.343   3.001  1.00 34.52          
ATOM    511  CG  ASP    64       7.652  15.050   3.379  1.00 32.44          
ATOM    512  OD1 ASP    64       8.674  14.406   3.786  1.00 30.73          
ATOM    513  OD2 ASP    64       7.541  16.298   3.252  1.00 27.43          
ATOM    514  N   ALA    65       3.708  15.324   0.838  1.00 33.07          
ATOM    515  CA  ALA    65       3.454  14.680  -0.458  1.00 33.64          
ATOM    516  C   ALA    65       4.514  15.087  -1.506  1.00 31.92          
ATOM    517  O   ALA    65       5.497  14.427  -1.735  1.00 29.97          
ATOM    518  CB  ALA    65       1.846  14.790  -1.003  1.00 34.74          
ATOM    519  N   PRO    66       4.329  16.237  -2.074  1.00 32.05          
ATOM    520  CA  PRO    66       5.006  16.623  -3.330  1.00 33.03          
ATOM    521  C   PRO    66       6.521  16.253  -3.524  1.00 34.34          
ATOM    522  O   PRO    66       7.373  17.077  -3.280  1.00 33.74          
ATOM    523  CB  PRO    66       4.874  18.121  -3.234  1.00 33.84          
ATOM    524  CG  PRO    66       4.389  18.356  -1.562  1.00 32.17          
ATOM    525  CD  PRO    66       3.498  17.308  -1.500  1.00 30.81          
ATOM    526  N   HSD    67       6.913  15.040  -3.887  1.00 36.42          
ATOM    527  CA  HSD    67       8.299  14.912  -4.441  1.00 37.64          
ATOM    528  C   HSD    67       8.279  13.755  -5.342  1.00 38.84          
ATOM    529  O   HSD    67       9.163  13.665  -6.315  1.00 39.60          
ATOM    530  CB  HSD    67       9.355  14.334  -3.514  1.00 38.67          
ATOM    531  CG  HSD    67       9.399  14.916  -2.154  1.00 37.94          
ATOM    532  ND1 HSD    67       9.396  16.275  -1.927  1.00 35.73          
ATOM    533  CD2 HSD    67       9.531  14.304  -0.952  1.00 31.96          
ATOM    534  CE1 HSD    67       9.456  16.471  -0.625  1.00 38.35          
ATOM    535  NE2 HSD    67       9.510  15.292  -0.015  1.00 37.11          
ATOM    536  N   LEU    68       7.440  12.772  -4.891  1.00 37.72          
ATOM    537  CA  LEU    68       7.176  11.562  -5.710  1.00 36.10          
ATOM    538  C   LEU    68       5.935  11.880  -6.488  1.00 33.90          
ATOM    539  O   LEU    68       5.398  10.980  -7.148  1.00 35.37          
ATOM    540  CB  LEU    68       7.110  10.187  -4.948  1.00 36.82          
ATOM    541  CG  LEU    68       7.523   8.769  -5.573  1.00 38.55          
ATOM    542  CD1 LEU    68       8.359   8.708  -6.967  1.00 37.96          
ATOM    543  CD2 LEU    68       8.153   7.758  -4.525  1.00 36.10          
ATOM    544  N   ALA    69       5.502  13.148  -6.458  1.00 29.05          
ATOM    545  CA  ALA    69       4.440  13.513  -7.345  1.00 25.67          
ATOM    546  C   ALA    69       5.172  13.310  -8.628  1.00 22.99          
ATOM    547  O   ALA    69       6.304  13.731  -8.726  1.00 22.81          
ATOM    548  CB  ALA    69       4.091  14.939  -7.172  1.00 26.27          
ATOM    549  N   PRO    70       4.599  12.552  -9.552  1.00 20.49          
ATOM    550  CA  PRO    70       5.181  12.342 -10.869  1.00 18.83          
ATOM    551  C   PRO    70       5.671  13.601 -11.568  1.00 17.75          
ATOM    552  O   PRO    70       6.665  13.526 -12.299  1.00 18.08          
ATOM    553  CB  PRO    70       4.035  11.697 -11.681  1.00 18.88          
ATOM    554  CG  PRO    70       3.120  11.140 -10.759  1.00 17.25          
ATOM    555  CD  PRO    70       3.385  11.747  -9.370  1.00 20.05          
ATOM    556  N   GLU    71       5.012  14.750 -11.363  1.00 16.84          
ATOM    557  CA  GLU    71       5.385  16.022 -12.066  1.00 14.77          
ATOM    558  C   GLU    71       6.697  16.599 -11.560  1.00 15.46          
ATOM    559  O   GLU    71       7.327  17.440 -12.197  1.00 16.72          
ATOM    560  CB  GLU    71       4.228  17.005 -12.122  1.00 12.78          
ATOM    561  CG  GLU    71       3.378  17.141 -10.891  1.00 14.57          
ATOM    562  CD  GLU    71       2.325  16.045 -10.606  1.00 20.09          
ATOM    563  OE1 GLU    71       1.184  16.257 -10.876  1.00 26.94          
ATOM    564  OE2 GLU    71       2.537  14.991 -10.001  1.00 21.86          
ATOM    565  N   MET    72       7.163  16.102 -10.418  1.00 15.91          
ATOM    566  CA  MET    72       8.532  16.369  -9.972  1.00 16.11          
ATOM    567  C   MET    72       9.590  15.773 -10.867  1.00 16.82          
ATOM    568  O   MET    72      10.752  16.175 -10.777  1.00 16.32          
ATOM    569  CB  MET    72       8.749  15.812  -8.612  1.00 15.79          
ATOM    570  CG  MET    72       7.785  16.416  -7.627  1.00 16.25          
ATOM    571  SD  MET    72       7.583  18.155  -7.899  1.00 17.49          
ATOM    572  CE  MET    72       8.963  19.024  -7.147  1.00  5.62          
ATOM    573  N   ARG    73       9.191  14.814 -11.710  1.00 17.47          
ATOM    574  CA  ARG    73      10.127  14.188 -12.649  1.00 18.49          
ATOM    575  C   ARG    73      10.949  15.230 -13.405  1.00 18.37          
ATOM    576  O   ARG    73      10.418  16.093 -14.086  1.00 19.34          
ATOM    577  CB  ARG    73       9.455  13.193 -13.617  1.00 18.25          
ATOM    578  CG  ARG    73      10.374  12.748 -14.717  1.00 19.07          
ATOM    579  CD  ARG    73       9.821  11.628 -15.541  1.00 22.48          
ATOM    580  NE  ARG    73      10.362  10.331 -15.125  1.00 23.61          
ATOM    581  CZ  ARG    73       9.732   9.507 -14.315  1.00 23.62          
ATOM    582  NH1 ARG    73       8.553   9.876 -13.826  1.00 25.50          
ATOM    583  NH2 ARG    73      10.271   8.337 -13.967  1.00 21.07          
ATOM    584  N   SER    74      12.260  15.086 -13.270  1.00 17.82          
ATOM    585  CA  SER    74      13.283  15.968 -13.810  1.00 16.37          
ATOM    586  C   SER    74      13.431  17.168 -12.940  1.00 18.12          
ATOM    587  O   SER    74      14.343  17.950 -13.187  1.00 20.81          
ATOM    588  CB  SER    74      13.020  16.452 -15.194  1.00 14.43          
ATOM    589  OG  SER    74      12.489  17.717 -15.159  1.00 10.73          
ATOM    590  N   HSD    75      12.584  17.360 -11.923  1.00 17.54          
ATOM    591  CA  HSD    75      12.885  18.456 -10.991  1.00 16.10          
ATOM    592  C   HSD    75      13.540  18.025  -9.744  1.00 15.04          
ATOM    593  O   HSD    75      14.547  18.556  -9.389  1.00 14.88          
ATOM    594  CB  HSD    75      11.660  19.337 -10.746  1.00 16.21          
ATOM    595  CG  HSD    75      11.008  19.797 -12.023  1.00 13.53          
ATOM    596  ND1 HSD    75      11.544  20.796 -12.805  1.00  9.81          
ATOM    597  CD2 HSD    75       9.887  19.367 -12.653  1.00  8.80          
ATOM    598  CE1 HSD    75      10.760  20.970 -13.852  1.00 13.78          
ATOM    599  NE2 HSD    75       9.741  20.130 -13.771  1.00  9.55          
ATOM    600  N   VAL    76      12.961  17.056  -9.063  1.00 15.89          
ATOM    601  CA  VAL    76      13.644  16.465  -7.915  1.00 16.03          
ATOM    602  C   VAL    76      13.323  15.022  -7.738  1.00 17.34          
ATOM    603  O   VAL    76      12.152  14.646  -7.685  1.00 18.48          
ATOM    604  CB  VAL    76      13.393  17.180  -6.596  1.00 14.83          
ATOM    605  CG1 VAL    76      12.180  17.969  -6.643  1.00 10.14          
ATOM    606  CG2 VAL    76      13.333  16.156  -5.480  1.00 13.99          
ATOM    607  N   HSD    77      14.385  14.233  -7.630  1.00 18.66          
ATOM    608  CA  HSD    77      14.274  12.805  -7.416  1.00 20.88          
ATOM    609  C   HSD    77      14.731  12.416  -6.057  1.00 22.14          
ATOM    610  O   HSD    77      15.667  13.046  -5.558  1.00 23.59          
ATOM    611  CB  HSD    77      15.129  12.065  -8.411  1.00 20.82          
ATOM    612  CG  HSD    77      14.694  12.282  -9.823  1.00 24.04          
ATOM    613  ND1 HSD    77      13.466  12.848 -10.144  1.00 25.21          
ATOM    614  CD2 HSD    77      15.315  12.017 -10.996  1.00 20.39          
ATOM    615  CE1 HSD    77      13.363  12.935 -11.454  1.00 23.22          
ATOM    616  NE2 HSD    77      14.457  12.413 -11.990  1.00 23.36          
ATOM    617  N   PRO    78      14.124  11.376  -5.456  1.00 23.06          
ATOM    618  CA  PRO    78      14.643  10.810  -4.176  1.00 23.97          
ATOM    619  C   PRO    78      15.836   9.841  -4.370  1.00 24.35          
ATOM    620  O   PRO    78      15.902   9.146  -5.395  1.00 23.72          
ATOM    621  CB  PRO    78      13.440  10.059  -3.644  1.00 23.70          
ATOM    622  CG  PRO    78      12.746   9.561  -4.959  1.00 22.21          
ATOM    623  CD  PRO    78      12.941  10.634  -5.946  1.00 22.27          
ATOM    624  N   THR    79      16.758   9.811  -3.411  1.00 25.96          
ATOM    625  CA  THR    79      17.809   8.792  -3.430  1.00 28.67          
ATOM    626  C   THR    79      17.750   8.104  -2.128  1.00 30.83          
ATOM    627  O   THR    79      17.203   8.640  -1.108  1.00 31.90          
ATOM    628  CB  THR    79      19.254   9.311  -3.573  1.00 28.44          
ATOM    629  OG1 THR    79      19.285  10.696  -3.253  1.00 28.13          
ATOM    630  CG2 THR    79      19.861   9.199  -5.025  1.00 28.02          
ATOM    631  N   LEU    80      18.303   6.888  -2.203  1.00 32.55          
ATOM    632  CA  LEU    80      18.741   6.101  -1.031  1.00 33.52          
ATOM    633  C   LEU    80      20.077   5.382  -1.384  1.00 33.06          
ATOM    634  O   LEU    80      20.637   5.591  -2.481  1.00 31.87          
ATOM    635  CB  LEU    80      17.644   5.157  -0.541  1.00 31.95          
ATOM    636  CG  LEU    80      17.328   3.966  -1.467  1.00 34.36          
ATOM    637  CD1 LEU    80      16.992   4.359  -2.983  1.00 32.23          
ATOM    638  CD2 LEU    80      18.317   2.698  -1.325  1.00 32.55          
ATOM    639  N   CYS   101      21.530  -0.841   6.743  1.00 45.50          
ATOM    640  CA  CYS   101      20.526  -1.334   7.693  1.00 45.54          
ATOM    641  C   CYS   101      20.963  -1.287   9.222  1.00 45.98          
ATOM    642  O   CYS   101      20.126  -1.461  10.192  1.00 47.36          
ATOM    643  CB  CYS   101      20.300  -2.738   7.347  1.00 45.34          
ATOM    644  SG  CYS   101      21.876  -3.463   7.806  1.00 47.60          
ATOM    645  N   HSD   102      22.265  -1.101   9.476  1.00 45.20          
ATOM    646  CA  HSD   102      22.644  -0.627  10.825  1.00 43.68          
ATOM    647  C   HSD   102      22.277   0.859  10.841  1.00 42.64          
ATOM    648  O   HSD   102      23.146   1.706  10.540  1.00 44.05          
ATOM    649  CB  HSD   102      24.133  -0.753  11.145  1.00 42.86          
ATOM    650  CG  HSD   102      24.684  -2.138  11.011  1.00 44.86          
ATOM    651  ND1 HSD   102      26.028  -2.378  10.768  1.00 47.33          
ATOM    652  CD2 HSD   102      24.089  -3.353  11.077  1.00 43.51          
ATOM    653  CE1 HSD   102      26.240  -3.681  10.695  1.00 46.54          
ATOM    654  NE2 HSD   102      25.078  -4.292  10.871  1.00 47.46          
ATOM    655  N   PHE   103      21.022   1.195  11.177  1.00 39.64          
ATOM    656  CA  PHE   103      20.691   2.585  11.422  1.00 36.08          
ATOM    657  C   PHE   103      21.808   3.521  11.969  1.00 34.98          
ATOM    658  O   PHE   103      21.927   4.629  11.453  1.00 34.66          
ATOM    659  CB  PHE   103      19.429   2.705  12.250  1.00 35.62          
ATOM    660  CG  PHE   103      18.673   3.983  12.020  1.00 34.35          
ATOM    661  CD1 PHE   103      17.616   4.315  12.819  1.00 34.67          
ATOM    662  CD2 PHE   103      19.014   4.860  10.982  1.00 33.50          
ATOM    663  CE1 PHE   103      16.877   5.498  12.565  1.00 36.44          
ATOM    664  CE2 PHE   103      18.290   6.055  10.746  1.00 33.77          
ATOM    665  CZ  PHE   103      17.243   6.376  11.508  1.00 33.22          
ATOM    666  N   HSD   104      22.598   3.136  12.980  1.00 33.95          
ATOM    667  CA  HSD   104      23.627   4.090  13.515  1.00 34.71          
ATOM    668  C   HSD   104      24.690   4.666  12.501  1.00 34.55          
ATOM    669  O   HSD   104      25.382   5.694  12.833  1.00 35.19          
ATOM    670  CB  HSD   104      24.334   3.600  14.802  1.00 34.12          
ATOM    671  CG  HSD   104      25.381   2.568  14.550  1.00 33.67          
ATOM    672  ND1 HSD   104      26.720   2.775  14.840  1.00 36.93          
ATOM    673  CD2 HSD   104      25.294   1.328  14.012  1.00 31.58          
ATOM    674  CE1 HSD   104      27.410   1.702  14.489  1.00 35.47          
ATOM    675  NE2 HSD   104      26.569   0.811  13.984  1.00 32.99          
ATOM    676  N   GLU   105      24.778   4.073  11.288  1.00 32.40          
ATOM    677  CA  GLU   105      25.748   4.484  10.276  1.00 30.25          
ATOM    678  C   GLU   105      25.276   5.484   9.245  1.00 27.86          
ATOM    679  O   GLU   105      26.103   5.998   8.467  1.00 27.71          
ATOM    680  CB  GLU   105      26.257   3.259   9.589  1.00 31.31          
ATOM    681  CG  GLU   105      26.505   2.202  10.636  1.00 34.56          
ATOM    682  CD  GLU   105      26.814   0.843  10.054  1.00 38.25          
ATOM    683  OE1 GLU   105      25.880   0.161   9.535  1.00 38.04          
ATOM    684  OE2 GLU   105      28.003   0.450  10.166  1.00 41.24          
ATOM    685  N   VAL   106      23.987   5.781   9.245  1.00 24.63          
ATOM    686  CA  VAL   106      23.439   6.831   8.393  1.00 24.31          
ATOM    687  C   VAL   106      24.181   8.165   8.602  1.00 23.93          
ATOM    688  O   VAL   106      24.841   8.717   7.690  1.00 26.52          
ATOM    689  CB  VAL   106      21.876   7.000   8.544  1.00 25.36          
ATOM    690  CG1 VAL   106      21.197   7.664   7.288  1.00 21.28          
ATOM    691  CG2 VAL   106      21.192   5.615   8.881  1.00 25.50          
ATOM    692  N   PRO   107      24.187   8.669   9.797  1.00 21.38          
ATOM    693  CA  PRO   107      24.981   9.825  10.038  1.00 19.87          
ATOM    694  C   PRO   107      26.338   9.827   9.351  1.00 18.46          
ATOM    695  O   PRO   107      26.623  10.763   8.703  1.00 16.39          
ATOM    696  CB  PRO   107      25.101   9.776  11.506  1.00 20.31          
ATOM    697  CG  PRO   107      23.732   9.356  11.883  1.00 20.20          
ATOM    698  CD  PRO   107      23.516   8.190  11.010  1.00 21.38          
ATOM    699  N   GLU   108      27.140   8.782   9.447  1.00 18.93          
ATOM    700  CA  GLU   108      28.395   8.687   8.631  1.00 20.48          
ATOM    701  C   GLU   108      28.280   8.933   7.080  1.00 20.01          
ATOM    702  O   GLU   108      29.235   9.273   6.408  1.00 19.49          
ATOM    703  CB  GLU   108      29.048   7.318   8.837  1.00 20.61          
ATOM    704  CG  GLU   108      30.506   7.376   9.264  1.00 25.10          
ATOM    705  CD  GLU   108      30.726   7.994  10.646  1.00 24.03          
ATOM    706  OE1 GLU   108      29.693   8.094  11.353  1.00 23.17          
ATOM    707  OE2 GLU   108      31.916   8.366  10.990  1.00 19.42          
ATOM    708  N   LEU   109      27.114   8.743   6.495  1.00 19.15          
ATOM    709  CA  LEU   109      27.001   9.063   5.095  1.00 18.15          
ATOM    710  C   LEU   109      27.305  10.541   4.832  1.00 18.39          
ATOM    711  O   LEU   109      27.993  10.910   3.869  1.00 19.79          
ATOM    712  CB  LEU   109      25.575   8.727   4.611  1.00 18.32          
ATOM    713  CG  LEU   109      25.292   7.449   3.761  1.00 13.74          
ATOM    714  CD1 LEU   109      26.274   6.224   3.964  1.00  5.50          
ATOM    715  CD2 LEU   109      23.938   7.173   4.170  1.00  7.55          
ATOM    716  N   PHE   110      26.784  11.400   5.687  1.00 17.00          
ATOM    717  CA  PHE   110      27.187  12.800   5.691  1.00 15.01          
ATOM    718  C   PHE   110      28.634  13.069   6.220  1.00 15.12          
ATOM    719  O   PHE   110      29.400  13.758   5.587  1.00 15.21          
ATOM    720  CB  PHE   110      26.145  13.590   6.434  1.00 14.03          
ATOM    721  CG  PHE   110      24.733  13.051   6.249  1.00 13.77          
ATOM    722  CD1 PHE   110      24.223  12.756   4.947  1.00 14.11          
ATOM    723  CD2 PHE   110      23.899  12.861   7.335  1.00 10.22          
ATOM    724  CE1 PHE   110      22.902  12.262   4.796  1.00 10.69          
ATOM    725  CE2 PHE   110      22.521  12.369   7.165  1.00  9.50          
ATOM    726  CZ  PHE   110      22.066  12.063   5.918  1.00 10.95          
ATOM    727  N   ARG   111      29.003  12.505   7.358  1.00 15.13          
ATOM    728  CA  ARG   111      30.144  12.914   8.062  1.00 15.28          
ATOM    729  C   ARG   111      31.270  12.319   7.334  1.00 16.62          
ATOM    730  O   ARG   111      32.272  12.077   7.904  1.00 19.94          
ATOM    731  CB  ARG   111      30.109  12.307   9.432  1.00 14.02          
ATOM    732  CG  ARG   111      29.653  13.267  10.394  1.00 18.60          
ATOM    733  CD  ARG   111      29.820  12.941  11.940  1.00 26.87          
ATOM    734  NE  ARG   111      28.561  13.406  12.583  1.00 37.30          
ATOM    735  CZ  ARG   111      28.135  13.260  13.881  1.00 40.61          
ATOM    736  NH1 ARG   111      28.971  12.738  14.802  1.00 43.89          
ATOM    737  NH2 ARG   111      26.869  13.661  14.248  1.00 33.22          
ATOM    738  N   GLN   112      31.130  11.989   6.076  1.00 17.88          
ATOM    739  CA  GLN   112      32.186  11.184   5.373  1.00 17.82          
ATOM    740  C   GLN   112      31.983  11.420   3.856  1.00 17.31          
ATOM    741  O   GLN   112      32.747  10.991   3.023  1.00 15.36          
ATOM    742  CB  GLN   112      31.937   9.741   5.757  1.00 17.77          
ATOM    743  CG  GLN   112      32.937   8.770   5.474  1.00 24.26          
ATOM    744  CD  GLN   112      33.366   8.058   6.771  1.00 35.06          
ATOM    745  OE1 GLN   112      33.030   6.873   7.039  1.00 37.92          
ATOM    746  NE2 GLN   112      34.084   8.803   7.608  1.00 39.62          
ATOM    747  N   GLY   113      30.903  12.130   3.528  1.00 16.69          
ATOM    748  CA  GLY   113      30.715  12.469   2.210  1.00 18.47          
ATOM    749  C   GLY   113      30.203  11.358   1.289  1.00 19.78          
ATOM    750  O   GLY   113      30.034  11.600   0.090  1.00 18.83          
ATOM    751  N   PHE   114      29.914  10.156   1.789  1.00 20.80          
ATOM    752  CA  PHE   114      29.070   9.234   0.972  1.00 21.04          
ATOM    753  C   PHE   114      27.861   9.905   0.309  1.00 20.89          
ATOM    754  O   PHE   114      27.619   9.654  -0.876  1.00 21.49          
ATOM    755  CB  PHE   114      28.643   8.031   1.736  1.00 20.73          
ATOM    756  CG  PHE   114      29.793   7.199   2.204  1.00 23.48          
ATOM    757  CD1 PHE   114      30.047   7.030   3.557  1.00 26.99          
ATOM    758  CD2 PHE   114      30.618   6.571   1.309  1.00 22.39          
ATOM    759  CE1 PHE   114      31.102   6.225   3.995  1.00 26.36          
ATOM    760  CE2 PHE   114      31.693   5.791   1.762  1.00 23.48          
ATOM    761  CZ  PHE   114      31.921   5.604   3.094  1.00 24.22          
ATOM    762  N   PHE   115      27.146  10.786   1.030  1.00 20.88          
ATOM    763  CA  PHE   115      26.104  11.678   0.402  1.00 20.11          
ATOM    764  C   PHE   115      26.458  13.165   0.639  1.00 19.79          
ATOM    765  O   PHE   115      26.158  13.701   1.704  1.00 18.54          
ATOM    766  CB  PHE   115      24.694  11.339   0.893  1.00 18.75          
ATOM    767  CG  PHE   115      23.614  12.121   0.220  1.00 17.79          
ATOM    768  CD1 PHE   115      22.906  13.095   0.935  1.00 11.55          
ATOM    769  CD2 PHE   115      23.258  11.855  -1.170  1.00 18.01          
ATOM    770  CE1 PHE   115      21.853  13.769   0.326  1.00 11.48          
ATOM    771  CE2 PHE   115      22.231  12.584  -1.838  1.00  9.11          
ATOM    772  CZ  PHE   115      21.551  13.539  -1.122  1.00 13.81          
ATOM    773  N   PRO   116      27.156  13.783  -0.344  1.00 20.18          
ATOM    774  CA  PRO   116      27.699  15.137  -0.181  1.00 20.41          
ATOM    775  C   PRO   116      26.586  16.146  -0.091  1.00 21.00          
ATOM    776  O   PRO   116      26.413  16.892  -1.001  1.00 22.72          
ATOM    777  CB  PRO   116      28.496  15.363  -1.481  1.00 19.12          
ATOM    778  CG  PRO   116      28.037  14.366  -2.418  1.00 18.64          
ATOM    779  CD  PRO   116      27.529  13.218  -1.669  1.00 19.31          
ATOM    780  N   LEU   117      25.833  16.143   0.993  1.00 21.68          
ATOM    781  CA  LEU   117      24.728  17.062   1.226  1.00 21.87          
ATOM    782  C   LEU   117      25.171  18.521   1.129  1.00 22.02          
ATOM    783  O   LEU   117      26.191  18.949   1.700  1.00 23.52          
ATOM    784  CB  LEU   117      24.089  16.710   2.580  1.00 21.33          
ATOM    785  CG  LEU   117      24.050  17.713   3.700  1.00 24.40          
ATOM    786  CD1 LEU   117      22.634  17.784   4.141  1.00 31.96          
ATOM    787  CD2 LEU   117      24.925  17.377   4.866  1.00 24.53          
ATOM    788  N   ASP   118      24.397  19.278   0.394  1.00 21.56          
ATOM    789  CA  ASP   118      24.654  20.659   0.241  1.00 22.59          
ATOM    790  C   ASP   118      23.768  21.520   1.197  1.00 21.72          
ATOM    791  O   ASP   118      24.257  22.550   1.778  1.00 22.08          
ATOM    792  CB  ASP   118      24.347  21.022  -1.238  1.00 24.09          
ATOM    793  CG  ASP   118      25.443  20.582  -2.208  1.00 29.34          
ATOM    794  OD1 ASP   118      26.680  20.684  -1.828  1.00 34.93          
ATOM    795  OD2 ASP   118      25.141  20.121  -3.366  1.00 31.49          
ATOM    796  N   VAL   119      22.470  21.152   1.275  1.00 19.14          
ATOM    797  CA  VAL   119      21.493  21.824   2.128  1.00 17.20          
ATOM    798  C   VAL   119      20.771  20.805   3.006  1.00 15.41          
ATOM    799  O   VAL   119      20.330  19.796   2.516  1.00 16.54          
ATOM    800  CB  VAL   119      20.432  22.694   1.298  1.00 17.99          
ATOM    801  CG1 VAL   119      20.314  22.252  -0.080  1.00 17.88          
ATOM    802  CG2 VAL   119      19.001  22.730   1.946  1.00 13.59          
ATOM    803  N   ALA   120      20.630  21.096   4.281  1.00 12.24          
ATOM    804  CA  ALA   120      19.855  20.289   5.176  1.00 10.62          
ATOM    805  C   ALA   120      18.527  21.002   5.483  1.00  9.86          
ATOM    806  O   ALA   120      18.526  22.100   5.999  1.00  8.76          
ATOM    807  CB  ALA   120      20.692  20.034   6.491  1.00  9.97          
ATOM    808  N   VAL   121      17.391  20.406   5.169  1.00 10.09          
ATOM    809  CA  VAL   121      16.119  21.058   5.473  1.00 11.02          
ATOM    810  C   VAL   121      15.448  20.408   6.667  1.00 12.46          
ATOM    811  O   VAL   121      15.012  19.311   6.521  1.00 14.42          
ATOM    812  CB  VAL   121      15.150  21.024   4.309  1.00 10.38          
ATOM    813  CG1 VAL   121      13.767  21.571   4.701  1.00  9.85          
ATOM    814  CG2 VAL   121      15.694  21.876   3.311  1.00  9.47          
ATOM    815  N   VAL   122      15.356  21.080   7.820  1.00 12.59          
ATOM    816  CA  VAL   122      14.867  20.526   9.051  1.00 12.88          
ATOM    817  C   VAL   122      13.730  21.322   9.628  1.00 14.40          
ATOM    818  O   VAL   122      13.502  22.504   9.312  1.00 14.88          
ATOM    819  CB  VAL   122      15.952  20.504  10.159  1.00 12.79          
ATOM    820  CG1 VAL   122      17.200  19.769   9.719  1.00 11.51          
ATOM    821  CG2 VAL   122      16.309  21.893  10.610  1.00 15.12          
ATOM    822  N   GLN   123      13.030  20.701  10.568  1.00 15.62          
ATOM    823  CA  GLN   123      11.940  21.434  11.196  1.00 15.39          
ATOM    824  C   GLN   123      12.242  21.681  12.667  1.00 15.45          
ATOM    825  O   GLN   123      11.961  20.837  13.393  1.00 18.31          
ATOM    826  CB  GLN   123      10.635  20.625  11.029  1.00 13.80          
ATOM    827  CG  GLN   123       9.477  21.212  11.740  1.00 13.25          
ATOM    828  CD  GLN   123       8.169  20.546  11.364  1.00 16.16          
ATOM    829  OE1 GLN   123       8.115  19.359  11.065  1.00 17.38          
ATOM    830  NE2 GLN   123       7.102  21.301  11.423  1.00 16.59          
ATOM    831  N   VAL   124      12.771  22.783  13.145  1.00 15.40          
ATOM    832  CA  VAL   124      12.923  22.898  14.619  1.00 15.56          
ATOM    833  C   VAL   124      11.836  23.644  15.304  1.00 16.06          
ATOM    834  O   VAL   124      10.858  24.071  14.659  1.00 16.47          
ATOM    835  CB  VAL   124      14.146  23.663  14.939  1.00 15.79          
ATOM    836  CG1 VAL   124      15.330  22.842  14.450  1.00 17.89          
ATOM    837  CG2 VAL   124      14.108  25.044  14.165  1.00 16.01          
ATOM    838  N   SER   125      12.075  23.893  16.594  1.00 16.31          
ATOM    839  CA  SER   125      11.141  24.591  17.487  1.00 16.64          
ATOM    840  C   SER   125      11.526  26.068  17.720  1.00 18.84          
ATOM    841  O   SER   125      12.624  26.536  17.326  1.00 17.98          
ATOM    842  CB  SER   125      11.262  23.984  18.839  1.00 16.62          
ATOM    843  OG  SER   125      12.189  24.785  19.591  1.00 12.33          
ATOM    844  N   THR   126      10.657  26.814  18.426  1.00 20.67          
ATOM    845  CA  THR   126      11.023  28.199  18.726  1.00 21.55          
ATOM    846  C   THR   126      12.234  28.251  19.672  1.00 23.18          
ATOM    847  O   THR   126      12.262  27.529  20.676  1.00 23.07          
ATOM    848  CB  THR   126       9.869  28.974  19.298  1.00 20.93          
ATOM    849  OG1 THR   126       9.083  28.150  20.168  1.00 20.40          
ATOM    850  CG2 THR   126       8.902  29.330  18.190  1.00 24.14          
ATOM    851  N   PRO   127      13.209  29.117  19.354  1.00 24.24          
ATOM    852  CA  PRO   127      14.437  29.287  20.151  1.00 24.55          
ATOM    853  C   PRO   127      14.124  29.909  21.448  1.00 25.49          
ATOM    854  O   PRO   127      13.047  30.447  21.648  1.00 24.73          
ATOM    855  CB  PRO   127      15.256  30.320  19.388  1.00 24.89          
ATOM    856  CG  PRO   127      14.265  31.103  18.573  1.00 25.24          
ATOM    857  CD  PRO   127      13.128  30.088  18.246  1.00 24.52          
ATOM    858  N   ASN   128      15.091  29.820  22.337  1.00 27.55          
ATOM    859  CA  ASN   128      14.846  30.026  23.750  1.00 28.19          
ATOM    860  C   ASN   128      15.588  31.326  24.003  1.00 28.67          
ATOM    861  O   ASN   128      16.014  31.973  23.060  1.00 27.46          
ATOM    862  CB  ASN   128      15.434  28.869  24.555  1.00 27.90          
ATOM    863  CG  ASN   128      16.940  28.934  24.603  1.00 28.56          
ATOM    864  OD1 ASN   128      17.514  29.994  24.416  1.00 28.71          
ATOM    865  ND2 ASN   128      17.584  27.826  24.869  1.00 26.96          
ATOM    866  N   GLU   129      15.779  31.677  25.273  1.00 30.18          
ATOM    867  CA  GLU   129      16.221  33.036  25.626  1.00 30.26          
ATOM    868  C   GLU   129      17.646  33.356  25.096  1.00 30.65          
ATOM    869  O   GLU   129      18.036  34.542  24.994  1.00 30.34          
ATOM    870  CB  GLU   129      16.147  33.194  27.130  1.00 29.31          
ATOM    871  CG  GLU   129      16.185  34.609  27.604  1.00 30.83          
ATOM    872  CD  GLU   129      16.353  34.669  29.113  1.00 35.69          
ATOM    873  OE1 GLU   129      16.477  35.820  29.667  1.00 36.25          
ATOM    874  OE2 GLU   129      16.378  33.560  29.745  1.00 31.69          
ATOM    875  N   GLU   130      18.414  32.290  24.782  1.00 30.58          
ATOM    876  CA  GLU   130      19.783  32.393  24.235  1.00 29.90          
ATOM    877  C   GLU   130      19.867  32.157  22.734  1.00 28.66          
ATOM    878  O   GLU   130      20.944  31.956  22.226  1.00 29.16          
ATOM    879  CB  GLU   130      20.740  31.439  24.942  1.00 29.97          
ATOM    880  CG  GLU   130      20.840  31.736  26.427  1.00 35.17          
ATOM    881  CD  GLU   130      19.855  30.894  27.249  1.00 45.59          
ATOM    882  OE1 GLU   130      20.365  30.058  28.058  1.00 47.60          
ATOM    883  OE2 GLU   130      18.579  31.022  27.071  1.00 48.61          
ATOM    884  N   GLY   131      18.746  32.131  22.028  1.00 26.74          
ATOM    885  CA  GLY   131      18.798  31.931  20.627  1.00 25.05          
ATOM    886  C   GLY   131      19.022  30.504  20.208  1.00 24.50          
ATOM    887  O   GLY   131      19.489  30.225  19.092  1.00 25.31          
ATOM    888  N   TYR   132      18.675  29.575  21.073  1.00 24.19          
ATOM    889  CA  TYR   132      18.951  28.162  20.788  1.00 23.06          
ATOM    890  C   TYR   132      17.619  27.506  20.439  1.00 21.93          
ATOM    891  O   TYR   132      16.687  27.574  21.196  1.00 21.69          
ATOM    892  CB  TYR   132      19.646  27.495  21.999  1.00 22.21          
ATOM    893  CG  TYR   132      21.180  27.520  21.991  1.00 23.03          
ATOM    894  CD1 TYR   132      21.955  28.208  22.987  1.00 24.43          
ATOM    895  CD2 TYR   132      21.870  26.813  21.035  1.00 23.82          
ATOM    896  CE1 TYR   132      23.378  28.202  22.931  1.00 19.96          
ATOM    897  CE2 TYR   132      23.233  26.807  20.990  1.00 22.16          
ATOM    898  CZ  TYR   132      23.984  27.500  21.894  1.00 22.00          
ATOM    899  OH  TYR   132      25.360  27.397  21.663  1.00 26.15          
ATOM    900  N   CYS   133      17.525  26.921  19.272  1.00 21.73          
ATOM    901  CA  CYS   133      16.395  26.048  18.987  1.00 22.78          
ATOM    902  C   CYS   133      16.719  24.568  19.154  1.00 23.84          
ATOM    903  O   CYS   133      17.919  24.131  19.162  1.00 23.34          
ATOM    904  CB  CYS   133      16.021  26.174  17.531  1.00 23.06          
ATOM    905  SG  CYS   133      15.583  27.815  16.949  1.00 18.90          
ATOM    906  N   SER   134      15.633  23.799  19.168  1.00 23.44          
ATOM    907  CA  SER   134      15.692  22.363  19.467  1.00 24.05          
ATOM    908  C   SER   134      15.224  21.636  18.303  1.00 22.22          
ATOM    909  O   SER   134      14.246  22.082  17.669  1.00 22.62          
ATOM    910  CB  SER   134      14.695  21.931  20.615  1.00 25.98          
ATOM    911  OG  SER   134      14.539  20.487  20.661  1.00 31.24          
ATOM    912  N   PHE   135      15.813  20.461  18.099  1.00 20.16          
ATOM    913  CA  PHE   135      15.357  19.609  17.036  1.00 18.92          
ATOM    914  C   PHE   135      14.006  19.013  17.358  1.00 19.00          
ATOM    915  O   PHE   135      13.405  18.409  16.488  1.00 19.70          
ATOM    916  CB  PHE   135      16.409  18.580  16.672  1.00 17.97          
ATOM    917  CG  PHE   135      17.510  19.170  15.847  1.00 18.79          
ATOM    918  CD1 PHE   135      18.763  19.422  16.393  1.00 19.67          
ATOM    919  CD2 PHE   135      17.278  19.566  14.543  1.00 15.91          
ATOM    920  CE1 PHE   135      19.736  20.064  15.634  1.00 16.32          
ATOM    921  CE2 PHE   135      18.248  20.167  13.801  1.00 13.09          
ATOM    922  CZ  PHE   135      19.466  20.430  14.345  1.00 15.02          
ATOM    923  N   GLY   136      13.531  19.183  18.592  1.00 18.14          
ATOM    924  CA  GLY   136      12.240  18.625  19.026  1.00 18.20          
ATOM    925  C   GLY   136      12.198  17.108  19.020  1.00 18.91          
ATOM    926  O   GLY   136      13.002  16.412  19.708  1.00 19.82          
ATOM    927  N   VAL   137      11.278  16.588  18.211  1.00 18.95          
ATOM    928  CA  VAL   137      10.967  15.128  18.133  1.00 18.28          
ATOM    929  C   VAL   137      11.880  14.255  17.194  1.00 18.95          
ATOM    930  O   VAL   137      11.637  13.068  16.950  1.00 18.11          
ATOM    931  CB  VAL   137       9.449  14.883  17.900  1.00 17.64          
ATOM    932  CG1 VAL   137       8.590  15.861  18.745  1.00 12.71          
ATOM    933  CG2 VAL   137       9.109  15.027  16.446  1.00 18.29          
ATOM    934  N   SER   138      12.956  14.861  16.707  1.00 20.84          
ATOM    935  CA  SER   138      13.888  14.173  15.766  1.00 22.85          
ATOM    936  C   SER   138      15.374  14.575  15.896  1.00 23.16          
ATOM    937  O   SER   138      15.773  15.680  15.516  1.00 23.06          
ATOM    938  CB  SER   138      13.438  14.456  14.351  1.00 21.83          
ATOM    939  OG  SER   138      12.890  13.287  13.869  1.00 26.22          
ATOM    940  N   CYS   139      16.188  13.727  16.481  1.00 23.29          
ATOM    941  CA  CYS   139      17.574  14.098  16.526  1.00 24.70          
ATOM    942  C   CYS   139      18.236  13.271  15.411  1.00 26.43          
ATOM    943  O   CYS   139      18.812  13.816  14.441  1.00 26.23          
ATOM    944  CB  CYS   139      18.085  13.700  17.864  1.00 24.45          
ATOM    945  SG  CYS   139      19.615  14.510  18.126  1.00 25.47          
ATOM    946  N   ASP   140      18.026  11.941  15.555  1.00 26.42          
ATOM    947  CA  ASP   140      18.506  10.870  14.707  1.00 26.20          
ATOM    948  C   ASP   140      19.564  11.222  13.710  1.00 23.76          
ATOM    949  O   ASP   140      20.729  11.330  14.113  1.00 24.78          
ATOM    950  CB  ASP   140      17.336  10.194  14.057  1.00 28.14          
ATOM    951  CG  ASP   140      16.414  11.161  13.488  1.00 32.82          
ATOM    952  OD1 ASP   140      16.765  11.780  12.435  1.00 39.32          
ATOM    953  OD2 ASP   140      15.322  11.394  14.061  1.00 39.64          
ATOM    954  N   TYR   141      19.211  11.388  12.436  1.00 21.00          
ATOM    955  CA  TYR   141      20.283  11.667  11.411  1.00 19.84          
ATOM    956  C   TYR   141      20.189  13.104  11.015  1.00 19.27          
ATOM    957  O   TYR   141      21.051  13.644  10.273  1.00 18.41          
ATOM    958  CB  TYR   141      20.164  10.847  10.148  1.00 16.80          
ATOM    959  CG  TYR   141      18.904  11.130   9.367  1.00 16.14          
ATOM    960  CD1 TYR   141      18.818  12.162   8.478  1.00 16.72          
ATOM    961  CD2 TYR   141      17.824  10.297   9.429  1.00 16.49          
ATOM    962  CE1 TYR   141      17.677  12.362   7.738  1.00 10.84          
ATOM    963  CE2 TYR   141      16.681  10.515   8.653  1.00 10.95          
ATOM    964  CZ  TYR   141      16.636  11.530   7.839  1.00  9.36          
ATOM    965  OH  TYR   141      15.508  11.704   7.102  1.00 11.32          
ATOM    966  N   THR   142      19.080  13.668  11.475  1.00 17.87          
ATOM    967  CA  THR   142      18.778  14.980  11.145  1.00 17.85          
ATOM    968  C   THR   142      19.725  15.996  11.819  1.00 18.00          
ATOM    969  O   THR   142      19.997  17.028  11.253  1.00 19.61          
ATOM    970  CB  THR   142      17.254  15.309  11.291  1.00 17.60          
ATOM    971  OG1 THR   142      17.156  16.571  11.939  1.00 19.55          
ATOM    972  CG2 THR   142      16.472  14.397  12.260  1.00 17.10          
ATOM    973  N   LYS   143      20.283  15.767  12.978  1.00 17.42          
ATOM    974  CA  LYS   143      21.132  16.809  13.465  1.00 17.24          
ATOM    975  C   LYS   143      22.517  16.705  12.840  1.00 19.48          
ATOM    976  O   LYS   143      23.206  17.758  12.593  1.00 20.96          
ATOM    977  CB  LYS   143      21.246  16.696  14.945  1.00 18.19          
ATOM    978  CG  LYS   143      22.396  17.366  15.585  1.00 16.62          
ATOM    979  CD  LYS   143      22.112  17.500  17.025  1.00 17.82          
ATOM    980  CE  LYS   143      22.835  18.679  17.624  1.00 18.92          
ATOM    981  NZ  LYS   143      24.242  18.354  17.910  1.00 22.90          
ATOM    982  N   ALA   144      22.971  15.471  12.592  1.00 19.01          
ATOM    983  CA  ALA   144      24.229  15.316  11.921  1.00 18.19          
ATOM    984  C   ALA   144      24.198  15.976  10.551  1.00 18.75          
ATOM    985  O   ALA   144      25.170  16.556  10.065  1.00 20.71          
ATOM    986  CB  ALA   144      24.488  13.935  11.770  1.00 19.18          
ATOM    987  N   ALA   145      23.092  15.850   9.871  1.00 19.25          
ATOM    988  CA  ALA   145      22.936  16.461   8.549  1.00 18.85          
ATOM    989  C   ALA   145      23.077  17.966   8.699  1.00 18.61          
ATOM    990  O   ALA   145      23.931  18.553   7.996  1.00 17.90          
ATOM    991  CB  ALA   145      21.562  16.099   7.967  1.00 18.76          
ATOM    992  N   ALA   146      22.277  18.571   9.619  1.00 17.80          
ATOM    993  CA  ALA   146      22.363  20.043   9.869  1.00 18.04          
ATOM    994  C   ALA   146      23.815  20.449  10.094  1.00 18.51          
ATOM    995  O   ALA   146      24.307  21.417   9.470  1.00 19.27          
ATOM    996  CB  ALA   146      21.499  20.531  10.945  1.00 15.61          
ATOM    997  N   GLU   147      24.533  19.661  10.874  1.00 19.41          
ATOM    998  CA  GLU   147      25.971  19.938  11.053  1.00 21.68          
ATOM    999  C   GLU   147      26.876  19.824   9.829  1.00 20.89          
ATOM   1000  O   GLU   147      27.945  20.313   9.888  1.00 19.85          
ATOM   1001  CB  GLU   147      26.592  19.040  12.132  1.00 23.11          
ATOM   1002  CG  GLU   147      26.536  19.530  13.535  1.00 24.22          
ATOM   1003  CD  GLU   147      26.466  18.358  14.479  1.00 29.86          
ATOM   1004  OE1 GLU   147      25.673  18.527  15.426  1.00 35.07          
ATOM   1005  OE2 GLU   147      27.161  17.287  14.308  1.00 30.64          
ATOM   1006  N   CYS   148      26.483  19.123   8.785  1.00 22.37          
ATOM   1007  CA  CYS   148      27.398  18.832   7.656  1.00 24.38          
ATOM   1008  C   CYS   148      27.021  19.582   6.350  1.00 24.22          
ATOM   1009  O   CYS   148      27.660  19.406   5.319  1.00 25.63          
ATOM   1010  CB  CYS   148      27.470  17.303   7.426  1.00 23.85          
ATOM   1011  SG  CYS   148      28.622  16.453   8.559  1.00 31.79          
ATOM   1012  N   ALA   149      25.935  20.351   6.404  1.00 23.94          
ATOM   1013  CA  ALA   149      25.414  21.093   5.314  1.00 23.23          
ATOM   1014  C   ALA   149      25.914  22.531   5.509  1.00 24.24          
ATOM   1015  O   ALA   149      25.696  23.099   6.579  1.00 24.08          
ATOM   1016  CB  ALA   149      23.941  21.062   5.384  1.00 22.60          
ATOM   1017  N   PRO   150      26.578  23.128   4.483  1.00 25.66          
ATOM   1018  CA  PRO   150      26.808  24.603   4.437  1.00 24.43          
ATOM   1019  C   PRO   150      25.561  25.480   4.339  1.00 23.53          
ATOM   1020  O   PRO   150      25.708  26.683   4.463  1.00 25.61          
ATOM   1021  CB  PRO   150      27.668  24.818   3.170  1.00 22.89          
ATOM   1022  CG  PRO   150      27.554  23.590   2.334  1.00 23.95          
ATOM   1023  CD  PRO   150      27.174  22.475   3.274  1.00 26.29          
ATOM   1024  N   VAL   151      24.372  24.946   4.071  1.00 21.29          
ATOM   1025  CA  VAL   151      23.180  25.795   4.031  1.00 17.99          
ATOM   1026  C   VAL   151      22.162  24.971   4.742  1.00 18.46          
ATOM   1027  O   VAL   151      21.912  23.781   4.361  1.00 19.48          
ATOM   1028  CB  VAL   151      22.657  25.924   2.605  1.00 17.33          
ATOM   1029  CG1 VAL   151      21.255  26.558   2.549  1.00 14.93          
ATOM   1030  CG2 VAL   151      23.588  26.649   1.769  1.00 13.48          
ATOM   1031  N   VAL   152      21.534  25.569   5.736  1.00 16.17          
ATOM   1032  CA  VAL   152      20.536  24.866   6.539  1.00 13.98          
ATOM   1033  C   VAL   152      19.181  25.606   6.532  1.00 14.89          
ATOM   1034  O   VAL   152      19.049  26.764   6.996  1.00 14.57          
ATOM   1035  CB  VAL   152      21.050  24.798   7.996  1.00 12.99          
ATOM   1036  CG1 VAL   152      20.085  24.048   8.889  1.00 12.19          
ATOM   1037  CG2 VAL   152      22.326  24.184   7.987  1.00  9.30          
ATOM   1038  N   VAL   153      18.147  24.953   6.041  1.00 15.48          
ATOM   1039  CA  VAL   153      16.867  25.635   5.989  1.00 17.02          
ATOM   1040  C   VAL   153      15.963  25.140   7.136  1.00 18.29          
ATOM   1041  O   VAL   153      15.552  24.005   7.120  1.00 19.12          
ATOM   1042  CB  VAL   153      16.236  25.348   4.673  1.00 16.72          
ATOM   1043  CG1 VAL   153      14.927  26.090   4.559  1.00 18.64          
ATOM   1044  CG2 VAL   153      17.185  25.738   3.527  1.00 18.16          
ATOM   1045  N   ALA   154      15.638  25.950   8.129  1.00 18.91          
ATOM   1046  CA  ALA   154      14.904  25.394   9.234  1.00 19.52          
ATOM   1047  C   ALA   154      13.489  25.974   9.257  1.00 20.86          
ATOM   1048  O   ALA   154      13.367  27.202   9.222  1.00 22.16          
ATOM   1049  CB  ALA   154      15.557  25.748  10.464  1.00 19.46          
ATOM   1050  N   GLU   155      12.440  25.149   9.350  1.00 19.73          
ATOM   1051  CA  GLU   155      11.142  25.696   9.470  1.00 21.58          
ATOM   1052  C   GLU   155      11.021  25.869  10.919  1.00 19.47          
ATOM   1053  O   GLU   155      11.120  24.947  11.678  1.00 19.01          
ATOM   1054  CB  GLU   155      10.079  24.694   9.039  1.00 22.03          
ATOM   1055  CG  GLU   155       9.993  24.343   7.556  1.00 26.27          
ATOM   1056  CD  GLU   155       8.939  23.210   7.208  1.00 30.22          
ATOM   1057  OE1 GLU   155       8.976  22.709   6.010  1.00 42.45          
ATOM   1058  OE2 GLU   155       8.034  22.804   8.047  1.00 37.34          
ATOM   1059  N   VAL   156      10.796  27.078  11.352  1.00 21.02          
ATOM   1060  CA  VAL   156      10.622  27.332  12.800  1.00 21.50          
ATOM   1061  C   VAL   156       9.167  27.129  13.312  1.00 21.92          
ATOM   1062  O   VAL   156       8.252  27.892  13.008  1.00 21.03          
ATOM   1063  CB  VAL   156      11.225  28.674  13.196  1.00 21.55          
ATOM   1064  CG1 VAL   156      10.880  28.992  14.677  1.00 22.51          
ATOM   1065  CG2 VAL   156      12.727  28.613  12.926  1.00 16.93          
ATOM   1066  N   ASN   157       8.958  26.063  14.060  1.00 22.59          
ATOM   1067  CA  ASN   157       7.625  25.741  14.313  1.00 24.43          
ATOM   1068  C   ASN   157       7.226  26.050  15.753  1.00 26.39          
ATOM   1069  O   ASN   157       7.828  25.550  16.764  1.00 27.35          
ATOM   1070  CB  ASN   157       7.345  24.337  13.894  1.00 24.46          
ATOM   1071  CG  ASN   157       5.874  24.071  13.767  1.00 26.49          
ATOM   1072  OD1 ASN   157       5.034  24.852  14.287  1.00 28.44          
ATOM   1073  ND2 ASN   157       5.526  22.945  13.133  1.00 21.74          
ATOM   1074  N   LYS   158       6.239  26.960  15.825  1.00 27.58          
ATOM   1075  CA  LYS   158       5.632  27.380  17.105  1.00 28.93          
ATOM   1076  C   LYS   158       4.977  26.190  17.819  1.00 28.37          
ATOM   1077  O   LYS   158       4.887  26.195  19.027  1.00 27.48          
ATOM   1078  CB  LYS   158       4.718  28.631  16.978  1.00 28.34          
ATOM   1079  CG  LYS   158       5.611  29.909  17.015  1.00 30.85          
ATOM   1080  CD  LYS   158       4.948  31.311  17.260  1.00 30.90          
ATOM   1081  CE  LYS   158       5.969  32.508  17.006  1.00 31.70          
ATOM   1082  NZ  LYS   158       7.013  32.147  15.925  1.00 35.55          
ATOM   1083  N   GLN   159       4.606  25.151  17.055  1.00 28.17          
ATOM   1084  CA  GLN   159       4.067  23.923  17.606  1.00 27.02          
ATOM   1085  C   GLN   159       5.144  22.846  17.949  1.00 27.08          
ATOM   1086  O   GLN   159       4.848  21.918  18.739  1.00 27.82          
ATOM   1087  CB  GLN   159       3.078  23.313  16.614  1.00 27.34          
ATOM   1088  CG  GLN   159       1.703  22.996  17.150  1.00 27.80          
ATOM   1089  CD  GLN   159       0.772  24.031  16.653  1.00 33.22          
ATOM   1090  OE1 GLN   159      -0.370  23.755  16.203  1.00 33.35          
ATOM   1091  NE2 GLN   159       1.280  25.280  16.653  1.00 36.16          
ATOM   1092  N   MET   160       6.347  22.903  17.353  1.00 25.88          
ATOM   1093  CA  MET   160       7.386  21.845  17.611  1.00 25.34          
ATOM   1094  C   MET   160       7.778  21.930  19.071  1.00 24.46          
ATOM   1095  O   MET   160       8.170  23.003  19.496  1.00 26.22          
ATOM   1096  CB  MET   160       8.668  22.042  16.755  1.00 24.93          
ATOM   1097  CG  MET   160       9.740  20.980  17.040  1.00 24.68          
ATOM   1098  SD  MET   160       9.176  19.242  16.659  1.00 23.44          
ATOM   1099  CE  MET   160       9.043  19.227  14.917  1.00 19.19          
ATOM   1100  N   PRO   161       7.662  20.855  19.841  1.00 23.35          
ATOM   1101  CA  PRO   161       8.119  20.823  21.233  1.00 22.79          
ATOM   1102  C   PRO   161       9.625  21.005  21.437  1.00 22.30          
ATOM   1103  O   PRO   161      10.420  20.714  20.561  1.00 23.57          
ATOM   1104  CB  PRO   161       7.755  19.392  21.686  1.00 21.47          
ATOM   1105  CG  PRO   161       7.524  18.686  20.542  1.00 19.58          
ATOM   1106  CD  PRO   161       7.060  19.573  19.471  1.00 23.05          
ATOM   1107  N   PHE   162       9.990  21.426  22.622  1.00 21.22          
ATOM   1108  CA  PHE   162      11.339  21.685  22.930  1.00 21.01          
ATOM   1109  C   PHE   162      11.746  20.594  23.835  1.00 20.93          
ATOM   1110  O   PHE   162      11.219  20.503  24.944  1.00 21.80          
ATOM   1111  CB  PHE   162      11.466  23.011  23.703  1.00 20.75          
ATOM   1112  CG  PHE   162      12.899  23.533  23.791  1.00 19.93          
ATOM   1113  CD1 PHE   162      13.768  23.102  24.808  1.00 17.51          
ATOM   1114  CD2 PHE   162      13.381  24.433  22.859  1.00 17.17          
ATOM   1115  CE1 PHE   162      15.075  23.556  24.901  1.00 13.11          
ATOM   1116  CE2 PHE   162      14.696  24.890  22.959  1.00 15.14          
ATOM   1117  CZ  PHE   162      15.530  24.434  23.989  1.00 15.27          
ATOM   1118  N   ILE   163      12.751  19.848  23.393  1.00 20.22          
ATOM   1119  CA  ILE   163      13.323  18.717  24.091  1.00 19.54          
ATOM   1120  C   ILE   163      14.853  18.812  24.048  1.00 19.75          
ATOM   1121  O   ILE   163      15.481  19.251  23.033  1.00 21.15          
ATOM   1122  CB  ILE   163      12.900  17.476  23.333  1.00 20.43          
ATOM   1123  CG1 ILE   163      11.399  17.482  23.110  1.00 19.47          
ATOM   1124  CG2 ILE   163      13.442  16.181  23.976  1.00 20.22          
ATOM   1125  CD  ILE   163      11.029  16.242  22.508  1.00 21.66          
ATOM   1126  N   GLY   164      15.469  18.326  25.113  1.00 18.95          
ATOM   1127  CA  GLY   164      16.845  18.694  25.433  1.00 18.83          
ATOM   1128  C   GLY   164      17.693  17.518  25.152  1.00 19.30          
ATOM   1129  O   GLY   164      17.318  16.726  24.310  1.00 20.68          
ATOM   1130  N   GLY   165      18.788  17.359  25.885  1.00 19.83          
ATOM   1131  CA  GLY   165      19.840  16.463  25.462  1.00 21.72          
ATOM   1132  C   GLY   165      20.661  17.128  24.369  1.00 23.35          
ATOM   1133  O   GLY   165      20.704  18.358  24.256  1.00 24.93          
ATOM   1134  N   GLU   166      21.337  16.363  23.538  1.00 24.18          
ATOM   1135  CA  GLU   166      22.208  16.992  22.527  1.00 24.79          
ATOM   1136  C   GLU   166      21.375  17.280  21.318  1.00 24.31          
ATOM   1137  O   GLU   166      21.695  16.791  20.227  1.00 24.49          
ATOM   1138  CB  GLU   166      23.222  16.006  22.049  1.00 24.54          
ATOM   1139  CG  GLU   166      24.643  16.290  22.306  1.00 29.30          
ATOM   1140  CD  GLU   166      25.439  15.463  21.311  1.00 42.20          
ATOM   1141  OE1 GLU   166      25.175  15.546  20.046  1.00 41.81          
ATOM   1142  OE2 GLU   166      26.300  14.676  21.804  1.00 49.52          
ATOM   1143  N   ASN   167      20.326  18.080  21.509  1.00 23.27          
ATOM   1144  CA  ASN   167      19.279  18.257  20.542  1.00 21.97          
ATOM   1145  C   ASN   167      19.091  19.713  20.174  1.00 22.25          
ATOM   1146  O   ASN   167      17.977  20.139  19.849  1.00 25.00          
ATOM   1147  CB  ASN   167      17.979  17.780  21.169  1.00 21.48          
ATOM   1148  CG  ASN   167      17.001  17.363  20.138  1.00 21.78          
ATOM   1149  OD1 ASN   167      17.359  17.264  18.920  1.00 15.30          
ATOM   1150  ND2 ASN   167      15.754  17.147  20.568  1.00 19.59          
ATOM   1151  N   LEU   168      20.129  20.527  20.241  1.00 21.23          
ATOM   1152  CA  LEU   168      19.919  21.962  20.025  1.00 20.24          
ATOM   1153  C   LEU   168      20.632  22.419  18.782  1.00 19.92          
ATOM   1154  O   LEU   168      21.598  21.779  18.361  1.00 17.81          
ATOM   1155  CB  LEU   168      20.424  22.773  21.203  1.00 19.14          
ATOM   1156  CG  LEU   168      19.503  22.952  22.392  1.00 20.97          
ATOM   1157  CD1 LEU   168      18.606  21.740  22.630  1.00 16.95          
ATOM   1158  CD2 LEU   168      20.358  23.340  23.631  1.00 19.33          
ATOM   1159  N   ILE   169      20.183  23.553  18.242  1.00 20.20          
ATOM   1160  CA  ILE   169      20.900  24.196  17.166  1.00 21.27          
ATOM   1161  C   ILE   169      20.722  25.707  17.250  1.00 22.49          
ATOM   1162  O   ILE   169      19.613  26.255  17.411  1.00 23.19          
ATOM   1163  CB  ILE   169      20.421  23.586  15.830  1.00 21.73          
ATOM   1164  CG1 ILE   169      21.413  23.792  14.690  1.00 19.61          
ATOM   1165  CG2 ILE   169      18.925  24.009  15.476  1.00 23.60          
ATOM   1166  CD  ILE   169      21.421  25.127  14.212  1.00 22.53          
ATOM   1167  N   HSD   170      21.819  26.411  17.198  1.00 24.09          
ATOM   1168  CA  HSD   170      21.703  27.841  17.402  1.00 25.34          
ATOM   1169  C   HSD   170      21.152  28.538  16.170  1.00 25.98          
ATOM   1170  O   HSD   170      21.343  28.069  15.017  1.00 25.67          
ATOM   1171  CB  HSD   170      23.026  28.463  17.804  1.00 25.01          
ATOM   1172  CG  HSD   170      22.896  29.896  18.196  1.00 26.77          
ATOM   1173  ND1 HSD   170      22.530  30.292  19.466  1.00 28.68          
ATOM   1174  CD2 HSD   170      23.069  31.034  17.483  1.00 27.59          
ATOM   1175  CE1 HSD   170      22.492  31.611  19.518  1.00 26.52          
ATOM   1176  NE2 HSD   170      22.819  32.082  18.327  1.00 28.10          
ATOM   1177  N   ILE   171      20.485  29.674  16.440  1.00 25.94          
ATOM   1178  CA  ILE   171      19.861  30.502  15.397  1.00 25.57          
ATOM   1179  C   ILE   171      20.873  30.953  14.363  1.00 24.91          
ATOM   1180  O   ILE   171      20.562  31.022  13.200  1.00 24.88          
ATOM   1181  CB  ILE   171      18.923  31.654  16.007  1.00 25.97          
ATOM   1182  CG1 ILE   171      17.767  31.873  15.093  1.00 26.98          
ATOM   1183  CG2 ILE   171      19.541  33.035  16.219  1.00 27.16          
ATOM   1184  CD  ILE   171      16.891  30.707  15.149  1.00 32.18          
ATOM   1185  N   SER   172      22.105  31.202  14.791  1.00 24.61          
ATOM   1186  CA  SER   172      23.091  31.642  13.864  1.00 25.07          
ATOM   1187  C   SER   172      23.529  30.580  12.843  1.00 24.49          
ATOM   1188  O   SER   172      24.073  30.947  11.846  1.00 25.60          
ATOM   1189  CB  SER   172      24.212  32.523  14.520  1.00 26.28          
ATOM   1190  OG  SER   172      25.013  31.895  15.544  1.00 30.35          
ATOM   1191  N   LYS   173      23.195  29.297  13.012  1.00 23.99          
ATOM   1192  CA  LYS   173      23.615  28.229  12.029  1.00 23.35          
ATOM   1193  C   LYS   173      22.552  27.988  10.940  1.00 22.52          
ATOM   1194  O   LYS   173      22.690  27.140  10.007  1.00 23.10          
ATOM   1195  CB  LYS   173      24.044  26.900  12.756  1.00 22.36          
ATOM   1196  CG  LYS   173      25.030  27.120  13.971  1.00 22.97          
ATOM   1197  CD  LYS   173      26.385  27.955  13.580  1.00 20.95          
ATOM   1198  CE  LYS   173      27.133  28.515  14.803  1.00 25.64          
ATOM   1199  NZ  LYS   173      27.243  27.701  16.215  1.00 24.64          
ATOM   1200  N   LEU   174      21.485  28.752  11.073  1.00 21.22          
ATOM   1201  CA  LEU   174      20.372  28.700  10.153  1.00 20.49          
ATOM   1202  C   LEU   174      20.497  29.769   9.082  1.00 21.14          
ATOM   1203  O   LEU   174      20.691  30.910   9.380  1.00 21.36          
ATOM   1204  CB  LEU   174      19.072  28.899  10.942  1.00 20.44          
ATOM   1205  CG  LEU   174      18.450  27.694  11.686  1.00 16.86          
ATOM   1206  CD1 LEU   174      19.454  26.826  12.254  1.00 12.70          
ATOM   1207  CD2 LEU   174      17.457  28.134  12.773  1.00 17.70          
ATOM   1208  N   THR   175      20.439  29.370   7.828  1.00 22.22          
ATOM   1209  CA  THR   175      20.588  30.291   6.696  1.00 23.00          
ATOM   1210  C   THR   175      19.296  30.977   6.334  1.00 23.14          
ATOM   1211  O   THR   175      19.315  32.146   6.000  1.00 23.72          
ATOM   1212  CB  THR   175      20.965  29.494   5.460  1.00 22.65          
ATOM   1213  OG1 THR   175      22.027  28.627   5.802  1.00 25.26          
ATOM   1214  CG2 THR   175      21.563  30.342   4.418  1.00 21.90          
ATOM   1215  N   HSD   176      18.207  30.206   6.277  1.00 23.01          
ATOM   1216  CA  HSD   176      16.901  30.717   5.951  1.00 23.07          
ATOM   1217  C   HSD   176      15.949  30.152   7.005  1.00 22.90          
ATOM   1218  O   HSD   176      16.045  28.948   7.373  1.00 24.29          
ATOM   1219  CB  HSD   176      16.463  30.309   4.538  1.00 23.81          
ATOM   1220  CG  HSD   176      17.498  30.546   3.468  1.00 27.13          
ATOM   1221  ND1 HSD   176      18.397  29.570   3.062  1.00 29.55          
ATOM   1222  CD2 HSD   176      17.748  31.633   2.696  1.00 30.13          
ATOM   1223  CE1 HSD   176      19.177  30.059   2.116  1.00 30.17          
ATOM   1224  NE2 HSD   176      18.802  31.306   1.865  1.00 30.24          
ATOM   1225  N   ILE   177      15.072  31.011   7.539  1.00 20.90          
ATOM   1226  CA  ILE   177      14.152  30.558   8.564  1.00 18.66          
ATOM   1227  C   ILE   177      12.799  30.796   8.018  1.00 18.39          
ATOM   1228  O   ILE   177      12.513  31.881   7.551  1.00 18.22          
ATOM   1229  CB  ILE   177      14.319  31.412   9.857  1.00 19.00          
ATOM   1230  CG1 ILE   177      15.601  31.074  10.553  1.00 11.91          
ATOM   1231  CG2 ILE   177      13.120  31.248  10.874  1.00 18.55          
ATOM   1232  CD  ILE   177      15.889  32.145  11.418  1.00  9.72          
ATOM   1233  N   ILE   178      11.955  29.802   8.127  1.00 17.81          
ATOM   1234  CA  ILE   178      10.629  29.888   7.596  1.00 18.74          
ATOM   1235  C   ILE   178       9.738  29.767   8.810  1.00 21.69          
ATOM   1236  O   ILE   178       9.369  28.658   9.196  1.00 22.13          
ATOM   1237  CB  ILE   178      10.413  28.731   6.690  1.00 16.83          
ATOM   1238  CG1 ILE   178      11.358  28.877   5.529  1.00 17.27          
ATOM   1239  CG2 ILE   178       9.081  28.753   6.119  1.00 14.64          
ATOM   1240  CD  ILE   178      11.772  27.572   4.860  1.00 14.06          
ATOM   1241  N   GLU   179       9.410  30.894   9.457  1.00 24.72          
ATOM   1242  CA  GLU   179       8.565  30.779  10.664  1.00 26.88          
ATOM   1243  C   GLU   179       7.234  30.195  10.334  1.00 27.60          
ATOM   1244  O   GLU   179       6.545  30.728   9.514  1.00 29.85          
ATOM   1245  CB  GLU   179       8.336  32.048  11.494  1.00 25.33          
ATOM   1246  CG  GLU   179       8.683  33.362  10.939  1.00 28.80          
ATOM   1247  CD  GLU   179       9.133  34.214  12.103  1.00 35.59          
ATOM   1248  OE1 GLU   179       9.453  35.411  11.932  1.00 38.57          
ATOM   1249  OE2 GLU   179       9.144  33.661  13.224  1.00 34.98          
ATOM   1250  N   VAL   180       6.877  29.088  10.968  1.00 27.94          
ATOM   1251  CA  VAL   180       5.534  28.673  10.877  1.00 27.56          
ATOM   1252  C   VAL   180       4.913  28.191  12.117  1.00 27.81          
ATOM   1253  O   VAL   180       5.498  28.167  13.195  1.00 28.02          
ATOM   1254  CB  VAL   180       5.310  27.684   9.732  1.00 28.96          
ATOM   1255  CG1 VAL   180       5.174  28.527   8.383  1.00 30.60          
ATOM   1256  CG2 VAL   180       6.355  26.550   9.669  1.00 23.93          
ATOM   1257  N   ASP   181       3.656  27.896  11.911  1.00 28.30          
ATOM   1258  CA  ASP   181       2.774  27.396  12.894  1.00 29.52          
ATOM   1259  C   ASP   181       1.719  26.369  12.341  1.00 29.88          
ATOM   1260  O   ASP   181       0.933  26.655  11.380  1.00 31.11          
ATOM   1261  CB  ASP   181       2.120  28.540  13.605  1.00 29.39          
ATOM   1262  CG  ASP   181       1.391  28.053  14.781  1.00 32.09          
ATOM   1263  OD1 ASP   181       1.249  26.810  14.853  1.00 34.95          
ATOM   1264  OD2 ASP   181       0.933  28.775  15.675  1.00 35.01          
ATOM   1265  N   GLU   182       1.789  25.156  12.892  1.00 28.51          
ATOM   1266  CA  GLU   182       1.183  23.977  12.278  1.00 29.19          
ATOM   1267  C   GLU   182       1.492  22.736  13.147  1.00 27.43          
ATOM   1268  O   GLU   182       2.642  22.505  13.516  1.00 27.31          
ATOM   1269  CB  GLU   182       1.558  23.810  10.777  1.00 28.20          
ATOM   1270  CG  GLU   182       0.527  24.373   9.773  1.00 33.60          
ATOM   1271  CD  GLU   182       0.011  23.352   8.639  1.00 41.70          
ATOM   1272  OE1 GLU   182       0.791  22.459   8.057  1.00 40.51          
ATOM   1273  OE2 GLU   182      -1.234  23.467   8.265  1.00 47.22          
ATOM   1274  N   PRO   183       0.451  21.953  13.468  1.00 26.93          
ATOM   1275  CA  PRO   183       0.538  20.853  14.453  1.00 26.06          
ATOM   1276  C   PRO   183       1.398  19.678  13.954  1.00 26.46          
ATOM   1277  O   PRO   183       1.364  19.291  12.785  1.00 27.59          
ATOM   1278  CB  PRO   183      -0.904  20.390  14.576  1.00 26.28          
ATOM   1279  CG  PRO   183      -1.541  20.716  13.225  1.00 25.49          
ATOM   1280  CD  PRO   183      -0.893  22.019  12.835  1.00 26.25          
ATOM   1281  N   ILE   184       2.185  19.095  14.837  1.00 25.25          
ATOM   1282  CA  ILE   184       3.166  18.158  14.439  1.00 21.69          
ATOM   1283  C   ILE   184       2.447  16.897  14.044  1.00 21.73          
ATOM   1284  O   ILE   184       1.793  16.339  14.840  1.00 21.82          
ATOM   1285  CB  ILE   184       4.037  18.037  15.644  1.00 20.69          
ATOM   1286  CG1 ILE   184       4.833  19.343  15.748  1.00 17.79          
ATOM   1287  CG2 ILE   184       4.862  16.748  15.620  1.00 21.71          
ATOM   1288  CD  ILE   184       6.123  19.386  14.936  1.00  8.23          
ATOM   1289  N   ALA   185       2.534  16.464  12.797  1.00 22.39          
ATOM   1290  CA  ALA   185       1.879  15.219  12.385  1.00 23.14          
ATOM   1291  C   ALA   185       1.835  14.233  13.486  1.00 23.75          
ATOM   1292  O   ALA   185       2.816  14.061  14.220  1.00 21.62          
ATOM   1293  CB  ALA   185       2.632  14.564  11.264  1.00 23.84          
ATOM   1294  N   GLU   186       0.713  13.544  13.570  1.00 25.90          
ATOM   1295  CA  GLU   186       0.520  12.574  14.673  1.00 29.21          
ATOM   1296  C   GLU   186       0.348  11.172  14.153  1.00 28.23          
ATOM   1297  O   GLU   186      -0.203  11.027  13.115  1.00 28.76          
ATOM   1298  CB  GLU   186      -0.662  12.992  15.595  1.00 29.75          
ATOM   1299  CG  GLU   186      -1.960  13.486  14.933  1.00 31.19          
ATOM   1300  CD  GLU   186      -2.910  14.152  15.940  1.00 32.80          
ATOM   1301  OE1 GLU   186      -3.557  15.151  15.525  1.00 39.05          
ATOM   1302  OE2 GLU   186      -3.015  13.716  17.158  1.00 36.29          
END
