
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  237 ( 1798),  selected  237 , name 2f8m_A
# Molecule2: number of CA atoms  165 ( 1302),  selected  165 , name T0438_2_186.pdb
# PARAMETERS: 2f8m_A.T0438_2_186.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -3_A      Q       2           -
LGA    H    -2_A      W       3           -
LGA    H    -1_A      Q       4           -
LGA    H     0_A      E       5           -
LGA    M     1_A      L       6           -
LGA    D     2_A      Y       7           -
LGA    S     3_A      R       8           -
LGA    L     4_A      Q       9           -
LGA    K     5_A      R      10           -
LGA    K     6_A      V      11           -
LGA    I     7_A      C      12           #
LGA    V     8_A      S      13          3.303
LGA    A     9_A      A      14          2.172
LGA    Y    10_A      D      15          2.229
LGA    K    11_A      E      16          2.954
LGA    A    12_A      A      17          1.823
LGA    V    13_A      V      18          1.034
LGA    D    14_A      V      19          2.562
LGA    E    15_A      D      20          2.945
LGA    Y    16_A      S      21          2.245
LGA    V    17_A      L      22          2.031
LGA    Q    18_A      K      23          1.720
LGA    S    19_A      P      24          1.471
LGA    N    20_A      G      25          1.402
LGA    M    21_A      T      26          0.850
LGA    T    22_A      K      27          0.981
LGA    I    23_A      V      28          1.300
LGA    G    24_A      V      29          1.713
LGA    L    25_A      F      30          1.821
LGA    G    26_A      G      31          2.941
LGA    -       -      X      32           -
LGA    -       -      A      33           -
LGA    -       -      A      34           -
LGA    T    27_A      A      35          3.203
LGA    G    28_A      A      36          3.601
LGA    S    29_A      -       -           -
LGA    T    30_A      -       -           -
LGA    V    31_A      P      37          2.003
LGA    F    32_A      V      38          1.256
LGA    Y    33_A      R      39          2.119
LGA    V    34_A      F      40          1.038
LGA    L    35_A      S      41          0.939
LGA    E    36_A      Q      42          1.905
LGA    R    37_A      A      43          1.957
LGA    I    38_A      M      44          1.465
LGA    D    39_A      Y      45          2.988
LGA    N    40_A      R      46          3.184
LGA    L    41_A      Q      47          2.623
LGA    L    42_A      R      48          2.774
LGA    K    43_A      -       -           -
LGA    S    44_A      -       -           -
LGA    G    45_A      E      49          3.172
LGA    K    46_A      K      50          1.116
LGA    L    47_A      L      51          1.271
LGA    K    48_A      E      52          0.297
LGA    D    49_A      N      53          0.658
LGA    V    50_A      I      54          0.786
LGA    V    51_A      T      55          0.750
LGA    C    52_A      V      56          0.949
LGA    I    53_A      F      57          1.415
LGA    P    54_A      X      58          1.745
LGA    T    55_A      -       -           -
LGA    S    56_A      M      59          3.695
LGA    I    57_A      L      60          1.275
LGA    D    58_A      Y      61          1.566
LGA    T    59_A      F      62           #
LGA    E    60_A      G      63           -
LGA    L    61_A      D      64           #
LGA    K    62_A      A      65          3.706
LGA    A    63_A      P      66          5.395
LGA    R    64_A      X      67          4.949
LGA    K    65_A      L      68          3.081
LGA    L    66_A      A      69          2.257
LGA    G    67_A      P      70          4.361
LGA    -       -      E      71           -
LGA    -       -      M      72           -
LGA    -       -      R      73           -
LGA    -       -      S      74           -
LGA    -       -      X      75           -
LGA    I    68_A      V      76          3.598
LGA    P    69_A      X      77          0.504
LGA    L    70_A      P      78          1.432
LGA    T    71_A      T      79          1.985
LGA    T    72_A      L      80          3.542
LGA    -       -      C     101           -
LGA    -       -      X     102           -
LGA    -       -      F     103           -
LGA    -       -      X     104           -
LGA    -       -      E     105           -
LGA    -       -      V     106           -
LGA    L    73_A      P     107           #
LGA    -       -      E     108           -
LGA    -       -      L     109           -
LGA    -       -      F     110           -
LGA    -       -      R     111           -
LGA    -       -      Q     112           -
LGA    E    74_A      G     113          5.750
LGA    K    75_A      F     114          1.750
LGA    H    76_A      -       -           -
LGA    S    77_A      F     115          2.070
LGA    N    78_A      P     116          1.776
LGA    I    79_A      L     117          1.498
LGA    D    80_A      D     118          1.530
LGA    I    81_A      V     119          1.227
LGA    T    82_A      A     120          1.353
LGA    I    83_A      V     121          1.827
LGA    D    84_A      V     122          1.465
LGA    G    85_A      Q     123          1.356
LGA    T    86_A      V     124          0.992
LGA    D    87_A      S     125          2.533
LGA    E    88_A      T     126          3.071
LGA    I    89_A      P     127          1.886
LGA    D    90_A      N     128          3.253
LGA    L    91_A      E     129           #
LGA    N    92_A      E     130          4.707
LGA    L    93_A      G     131          4.148
LGA    N    94_A      Y     132          2.133
LGA    L    95_A      C     133          1.894
LGA    I    96_A      S     134          1.529
LGA    K    97_A      F     135          1.992
LGA    G    98_A      G     136          3.275
LGA    R    99_A      V     137          2.480
LGA    G   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    A   102_A      S     138          3.134
LGA    L   103_A      C     139          2.141
LGA    V   104_A      D     140          0.564
LGA    R   105_A      Y     141          1.846
LGA    E   106_A      T     142          1.124
LGA    K   107_A      K     143          1.061
LGA    L   108_A      A     144          2.369
LGA    V   109_A      A     145          1.956
LGA    A   110_A      A     146          1.585
LGA    S   111_A      E     147          1.941
LGA    S   112_A      C     148          2.436
LGA    S   113_A      A     149          1.125
LGA    S   114_A      P     150          1.350
LGA    L   115_A      V     151          1.667
LGA    L   116_A      V     152          1.504
LGA    I   117_A      V     153          2.102
LGA    I   118_A      A     154          1.401
LGA    I   119_A      E     155          1.825
LGA    G   120_A      V     156          1.992
LGA    D   121_A      N     157          4.918
LGA    E   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    K   124_A      K     158          3.167
LGA    L   125_A      Q     159           -
LGA    C   126_A      M     160           -
LGA    T   127_A      P     161           -
LGA    N   128_A      -       -           -
LGA    G   129_A      -       -           -
LGA    L   130_A      -       -           -
LGA    G   131_A      F     162          4.967
LGA    M   132_A      -       -           -
LGA    T   133_A      -       -           -
LGA    G   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    V   136_A      I     163          1.731
LGA    P   137_A      G     164           #
LGA    I   138_A      G     165           #
LGA    E   139_A      -       -           -
LGA    I   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    T   142_A      -       -           -
LGA    F   143_A      -       -           -
LGA    G   144_A      -       -           -
LGA    Y   145_A      -       -           -
LGA    E   146_A      -       -           -
LGA    K   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    I   149_A      -       -           -
LGA    E   150_A      -       -           -
LGA    N   151_A      -       -           -
LGA    L   152_A      -       -           -
LGA    L   153_A      -       -           -
LGA    K   154_A      -       -           -
LGA    I   155_A      -       -           -
LGA    Y   156_A      -       -           -
LGA    T   157_A      -       -           -
LGA    L   158_A      -       -           -
LGA    K   159_A      -       -           -
LGA    G   160_A      -       -           -
LGA    C   161_A      -       -           -
LGA    T   162_A      -       -           -
LGA    Y   163_A      -       -           -
LGA    K   164_A      -       -           -
LGA    I   165_A      -       -           -
LGA    R   166_A      -       -           -
LGA    K   167_A      -       -           -
LGA    R   168_A      -       -           -
LGA    N   169_A      -       -           -
LGA    G   170_A      -       -           -
LGA    E   171_A      -       -           -
LGA    I   172_A      -       -           -
LGA    F   173_A      -       -           -
LGA    I   174_A      -       -           -
LGA    T   175_A      -       -           -
LGA    D   176_A      -       -           -
LGA    N   177_A      -       -           -
LGA    K   178_A      -       -           -
LGA    N   179_A      -       -           -
LGA    Y   180_A      -       -           -
LGA    I   181_A      -       -           -
LGA    V   182_A      -       -           -
LGA    D   183_A      -       -           -
LGA    F   184_A      -       -           -
LGA    F   185_A      -       -           -
LGA    F   186_A      -       -           -
LGA    T   187_A      -       -           -
LGA    E   188_A      -       -           -
LGA    P   189_A      -       -           -
LGA    I   190_A      -       -           -
LGA    Q   191_A      -       -           -
LGA    D   192_A      -       -           -
LGA    L   193_A      -       -           -
LGA    L   194_A      -       -           -
LGA    E   195_A      -       -           -
LGA    T   196_A      -       -           -
LGA    C   197_A      E     166          3.506
LGA    T   198_A      -       -           -
LGA    R   199_A      -       -           -
LGA    I   200_A      -       -           -
LGA    K   201_A      -       -           -
LGA    M   202_A      -       -           -
LGA    T   203_A      -       -           -
LGA    T   204_A      -       -           -
LGA    G   205_A      -       -           -
LGA    V   206_A      -       -           -
LGA    V   207_A      -       -           -
LGA    D   208_A      -       -           -
LGA    H   209_A      -       -           -
LGA    G   210_A      -       -           -
LGA    I   211_A      N     167          1.489
LGA    F   212_A      L     168          2.079
LGA    V   213_A      I     169          3.693
LGA    N   214_A      -       -           -
LGA    M   215_A      X     170           #
LGA    T   216_A      I     171          5.119
LGA    -       -      S     172           -
LGA    N   217_A      K     173          2.071
LGA    V   218_A      L     174          2.219
LGA    A   219_A      T     175           #
LGA    -       -      X     176           -
LGA    L   220_A      I     177          1.973
LGA    -       -      I     178           -
LGA    I   221_A      E     179          2.894
LGA    S   222_A      V     180          5.422
LGA    K   223_A      D     181           -
LGA    H   224_A      E     182           -
LGA    D   225_A      P     183           -
LGA    G   226_A      I     184           -
LGA    T   227_A      A     185           -
LGA    V   228_A      E     186           -
LGA    L   229_A      -       -           -
LGA    T   230_A      -       -           -
LGA    L   231_A      -       -           -
LGA    N   232_A      -       -           -
LGA    K   233_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  237  165    5.0    114    2.53    10.53     45.267     4.337

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.804465 * X  +  -0.195413 * Y  +   0.560937 * Z  +  41.159481
  Y_new =  -0.075054 * X  +   0.970209 * Y  +   0.230352 * Z  + -84.734322
  Z_new =  -0.589240 * X  +   0.143209 * Y  +  -0.795165 * Z  +  54.330067 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.963403   -0.178190  [ DEG:   169.7905    -10.2095 ]
  Theta =   0.630117    2.511475  [ DEG:    36.1031    143.8969 ]
  Phi   =  -3.048565    0.093028  [ DEG:  -174.6699      5.3301 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f8m_A                                        
REMARK     2: T0438_2_186.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f8m_A.T0438_2_186.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  237  165   5.0  114   2.53   10.53  45.267
REMARK  ---------------------------------------------------------- 
MOLECULE 2f8m_A
HEADER    ISOMERASE                               02-DEC-05   2F8M              
TITLE     RIBOSE 5-PHOSPHATE ISOMERASE FROM PLASMODIUM FALCIPARUM               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBOSE 5-PHOSPHATE ISOMERASE;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 5.3.1.6;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PLASMODIUM FALCIPARUM (ISOLATE 3D7);            
SOURCE   3 GENE: PFE0730C;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)STAR;                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: BG1861                                    
KEYWDS    STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE,               
KEYWDS   2 STRUCTURAL GENOMICS OF PATHOGENIC PROTOZOA CONSORTIUM, SGPP          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.A.HOLMES,E.A.MERRITT,STRUCTURAL GENOMICS OF PATHOGENIC              
AUTHOR   2 PROTOZOA CONSORTIUM (SGPP)                                           
REVDAT   2   13-JUN-06 2F8M    1       JRNL                                     
REVDAT   1   27-DEC-05 2F8M    0                                                
JRNL        AUTH   M.A.HOLMES,F.S.BUCKNER,W.C.VAN VOORHIS,                      
JRNL        AUTH 2 C.L.VERLINDE,C.MEHLIN,E.BONI,G.DETITTA,J.LUFT,               
JRNL        AUTH 3 A.LAURICELLA,L.ANDERSON,O.KALYUZHNIY,F.ZUCKER,               
JRNL        AUTH 4 L.W.SCHOENFELD,T.N.EARNEST,W.G.HOL,E.A.MERRITT               
JRNL        TITL   STRUCTURE OF RIBOSE 5-PHOSPHATE ISOMERASE FROM               
JRNL        TITL 2 PLASMODIUM FALCIPARUM.                                       
JRNL        REF    ACTA CRYSTALLOGR., SECT.F     V.  62   427 2006              
JRNL        REFN                DK ESSN 1744-3091                               
REMARK   2 RESOLUTION. 2.09 ANGSTROMS.                                          
DBREF  2F8M A    1   236  UNP    Q8I3W2   Q8I3W2_PLAF7     1    236             
DBREF  2F8M B    1   236  UNP    Q8I3W2   Q8I3W2_PLAF7     1    236             
SEQRES   1 A  244  MET ALA HIS HIS HIS HIS HIS HIS MET ASP SER LEU LYS          
SEQRES   2 A  244  LYS ILE VAL ALA TYR LYS ALA VAL ASP GLU TYR VAL GLN          
SEQRES   3 A  244  SER ASN MET THR ILE GLY LEU GLY THR GLY SER THR VAL          
SEQRES   4 A  244  PHE TYR VAL LEU GLU ARG ILE ASP ASN LEU LEU LYS SER          
SEQRES   5 A  244  GLY LYS LEU LYS ASP VAL VAL CYS ILE PRO THR SER ILE          
SEQRES   6 A  244  ASP THR GLU LEU LYS ALA ARG LYS LEU GLY ILE PRO LEU          
SEQRES   7 A  244  THR THR LEU GLU LYS HIS SER ASN ILE ASP ILE THR ILE          
SEQRES   8 A  244  ASP GLY THR ASP GLU ILE ASP LEU ASN LEU ASN LEU ILE          
SEQRES   9 A  244  LYS GLY ARG GLY GLY ALA LEU VAL ARG GLU LYS LEU VAL          
SEQRES  10 A  244  ALA SER SER SER SER LEU LEU ILE ILE ILE GLY ASP GLU          
SEQRES  11 A  244  SER LYS LEU CYS THR ASN GLY LEU GLY MET THR GLY ALA          
SEQRES  12 A  244  VAL PRO ILE GLU ILE LEU THR PHE GLY TYR GLU LYS ILE          
SEQRES  13 A  244  ILE GLU ASN LEU LEU LYS ILE TYR THR LEU LYS GLY CYS          
SEQRES  14 A  244  THR TYR LYS ILE ARG LYS ARG ASN GLY GLU ILE PHE ILE          
SEQRES  15 A  244  THR ASP ASN LYS ASN TYR ILE VAL ASP PHE PHE PHE THR          
SEQRES  16 A  244  GLU PRO ILE GLN ASP LEU LEU GLU THR CYS THR ARG ILE          
SEQRES  17 A  244  LYS MET THR THR GLY VAL VAL ASP HIS GLY ILE PHE VAL          
SEQRES  18 A  244  ASN MET THR ASN VAL ALA LEU ILE SER LYS HIS ASP GLY          
SEQRES  19 A  244  THR VAL LEU THR LEU ASN LYS LYS TYR GLU                      
SEQRES   1 B  244  MET ALA HIS HIS HIS HIS HIS HIS MET ASP SER LEU LYS          
SEQRES   2 B  244  LYS ILE VAL ALA TYR LYS ALA VAL ASP GLU TYR VAL GLN          
SEQRES   3 B  244  SER ASN MET THR ILE GLY LEU GLY THR GLY SER THR VAL          
SEQRES   4 B  244  PHE TYR VAL LEU GLU ARG ILE ASP ASN LEU LEU LYS SER          
SEQRES   5 B  244  GLY LYS LEU LYS ASP VAL VAL CYS ILE PRO THR SER ILE          
SEQRES   6 B  244  ASP THR GLU LEU LYS ALA ARG LYS LEU GLY ILE PRO LEU          
SEQRES   7 B  244  THR THR LEU GLU LYS HIS SER ASN ILE ASP ILE THR ILE          
SEQRES   8 B  244  ASP GLY THR ASP GLU ILE ASP LEU ASN LEU ASN LEU ILE          
SEQRES   9 B  244  LYS GLY ARG GLY GLY ALA LEU VAL ARG GLU LYS LEU VAL          
SEQRES  10 B  244  ALA SER SER SER SER LEU LEU ILE ILE ILE GLY ASP GLU          
SEQRES  11 B  244  SER LYS LEU CYS THR ASN GLY LEU GLY MET THR GLY ALA          
SEQRES  12 B  244  VAL PRO ILE GLU ILE LEU THR PHE GLY TYR GLU LYS ILE          
SEQRES  13 B  244  ILE GLU ASN LEU LEU LYS ILE TYR THR LEU LYS GLY CYS          
SEQRES  14 B  244  THR TYR LYS ILE ARG LYS ARG ASN GLY GLU ILE PHE ILE          
SEQRES  15 B  244  THR ASP ASN LYS ASN TYR ILE VAL ASP PHE PHE PHE THR          
SEQRES  16 B  244  GLU PRO ILE GLN ASP LEU LEU GLU THR CYS THR ARG ILE          
SEQRES  17 B  244  LYS MET THR THR GLY VAL VAL ASP HIS GLY ILE PHE VAL          
SEQRES  18 B  244  ASN MET THR ASN VAL ALA LEU ILE SER LYS HIS ASP GLY          
SEQRES  19 B  244  THR VAL LEU THR LEU ASN LYS LYS TYR GLU                      
HET    PO4    700       5                                                       
HET    PO4    701       5                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   3  PO4    2(O4 P 3-)                                                   
FORMUL   5  HOH   *226(H2 O)                                                    
CRYST1   93.689  136.230   45.011  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   HIS A  -3      -5.825  29.358  15.220  1.00 41.46           N  
ATOM      2  CA  HIS A  -3      -6.330  29.693  13.844  1.00 41.20           C  
ATOM      3  C   HIS A  -3      -5.649  28.811  12.795  1.00 40.08           C  
ATOM      4  O   HIS A  -3      -4.531  29.086  12.394  1.00 37.60           O  
ATOM      5  N   HIS A  -2      -6.337  27.760  12.337  1.00 40.10           N  
ATOM      6  CA  HIS A  -2      -5.638  26.576  11.773  1.00 39.50           C  
ATOM      7  C   HIS A  -2      -5.159  26.831  10.356  1.00 36.33           C  
ATOM      8  O   HIS A  -2      -4.014  26.564  10.023  1.00 34.52           O  
ATOM      9  CB  HIS A  -2      -6.533  25.322  11.963  1.00 41.39           C  
ATOM     10  CG  HIS A  -2      -6.766  24.493  10.740  1.00 45.21           C  
ATOM     11  ND1 HIS A  -2      -5.756  24.111   9.884  1.00 51.55           N  
ATOM     12  CD2 HIS A  -2      -7.895  23.895  10.279  1.00 47.51           C  
ATOM     13  CE1 HIS A  -2      -6.261  23.358   8.918  1.00 49.64           C  
ATOM     14  NE2 HIS A  -2      -7.554  23.204   9.142  1.00 48.83           N  
ATOM     15  N   HIS A  -1      -6.022  27.433   9.559  1.00 35.11           N  
ATOM     16  CA  HIS A  -1      -5.654  27.878   8.213  1.00 33.23           C  
ATOM     17  C   HIS A  -1      -4.635  28.963   8.275  1.00 29.62           C  
ATOM     18  O   HIS A  -1      -3.854  29.131   7.357  1.00 30.63           O  
ATOM     19  CB  HIS A  -1      -6.885  28.424   7.507  1.00 34.10           C  
ATOM     20  CG  HIS A  -1      -7.928  27.393   7.291  1.00 36.58           C  
ATOM     21  ND1 HIS A  -1      -7.739  26.319   6.441  1.00 38.92           N  
ATOM     22  CD2 HIS A  -1      -9.145  27.229   7.855  1.00 38.46           C  
ATOM     23  CE1 HIS A  -1      -8.818  25.554   6.469  1.00 39.41           C  
ATOM     24  NE2 HIS A  -1      -9.680  26.079   7.325  1.00 39.69           N  
ATOM     25  N   HIS A   0      -4.695  29.749   9.339  1.00 25.94           N  
ATOM     26  CA  HIS A   0      -3.762  30.817   9.545  1.00 24.47           C  
ATOM     27  C   HIS A   0      -2.381  30.273   9.792  1.00 23.84           C  
ATOM     28  O   HIS A   0      -1.424  30.748   9.222  1.00 22.15           O  
ATOM     29  CB  HIS A   0      -4.202  31.642  10.742  1.00 23.92           C  
ATOM     30  CG  HIS A   0      -3.265  32.758  11.089  1.00 25.97           C  
ATOM     31  ND1 HIS A   0      -2.672  33.557  10.134  1.00 26.65           N  
ATOM     32  CD2 HIS A   0      -2.865  33.248  12.291  1.00 25.74           C  
ATOM     33  CE1 HIS A   0      -1.935  34.478  10.731  1.00 23.38           C  
ATOM     34  NE2 HIS A   0      -2.038  34.311  12.039  1.00 29.08           N  
ATOM     35  N   MET A   1      -2.305  29.301  10.696  1.00 24.74           N  
ATOM     36  CA  MET A   1      -1.039  28.643  11.052  1.00 25.52           C  
ATOM     37  C   MET A   1      -0.450  27.964   9.852  1.00 24.02           C  
ATOM     38  O   MET A   1       0.742  28.039   9.635  1.00 24.62           O  
ATOM     39  CB  MET A   1      -1.263  27.663  12.205  1.00 26.91           C  
ATOM     40  CG  MET A   1      -1.684  28.376  13.508  1.00 30.24           C  
ATOM     41  SD  MET A   1      -0.542  29.707  14.055  1.00 40.94           S  
ATOM     42  CE  MET A   1       1.026  28.916  13.705  1.00 44.67           C  
ATOM     43  N   ASP A   2      -1.304  27.349   9.047  1.00 25.38           N  
ATOM     44  CA  ASP A   2      -0.887  26.722   7.819  1.00 26.59           C  
ATOM     45  C   ASP A   2      -0.225  27.757   6.907  1.00 25.93           C  
ATOM     46  O   ASP A   2       0.904  27.553   6.464  1.00 23.70           O  
ATOM     47  CB  ASP A   2      -2.092  26.092   7.097  1.00 28.02           C  
ATOM     48  CG  ASP A   2      -2.588  24.784   7.737  1.00 31.48           C  
ATOM     49  OD1 ASP A   2      -1.851  24.177   8.552  1.00 30.73           O  
ATOM     50  OD2 ASP A   2      -3.743  24.368   7.395  1.00 32.81           O  
ATOM     51  N   SER A   3      -0.919  28.873   6.658  1.00 25.65           N  
ATOM     52  CA  SER A   3      -0.387  29.993   5.857  1.00 27.12           C  
ATOM     53  C   SER A   3       0.970  30.518   6.329  1.00 26.59           C  
ATOM     54  O   SER A   3       1.884  30.750   5.521  1.00 26.80           O  
ATOM     55  CB  SER A   3      -1.390  31.163   5.840  1.00 27.74           C  
ATOM     56  OG  SER A   3      -2.672  30.721   5.388  1.00 33.92           O  
ATOM     57  N   LEU A   4       1.087  30.713   7.627  1.00 25.09           N  
ATOM     58  CA  LEU A   4       2.344  31.091   8.248  1.00 25.92           C  
ATOM     59  C   LEU A   4       3.459  30.053   8.030  1.00 25.72           C  
ATOM     60  O   LEU A   4       4.625  30.413   7.760  1.00 25.99           O  
ATOM     61  CB  LEU A   4       2.128  31.242   9.733  1.00 25.89           C  
ATOM     62  CG  LEU A   4       1.902  32.577  10.439  1.00 29.16           C  
ATOM     63  CD1 LEU A   4       1.312  33.697   9.549  1.00 32.46           C  
ATOM     64  CD2 LEU A   4       1.046  32.285  11.683  1.00 27.08           C  
ATOM     65  N   LYS A   5       3.114  28.768   8.149  1.00 24.15           N  
ATOM     66  CA  LYS A   5       4.063  27.692   7.782  1.00 22.89           C  
ATOM     67  C   LYS A   5       4.452  27.765   6.328  1.00 22.88           C  
ATOM     68  O   LYS A   5       5.635  27.698   5.997  1.00 24.18           O  
ATOM     69  CB  LYS A   5       3.482  26.321   8.062  1.00 19.90           C  
ATOM     70  CG  LYS A   5       3.482  25.984   9.540  1.00 22.40           C  
ATOM     71  CD  LYS A   5       2.623  24.749   9.830  1.00 21.43           C  
ATOM     72  CE  LYS A   5       2.538  24.499  11.300  1.00 21.93           C  
ATOM     73  NZ  LYS A   5       1.622  23.390  11.639  1.00 19.18           N  
ATOM     74  N   LYS A   6       3.448  27.891   5.467  1.00 24.61           N  
ATOM     75  CA  LYS A   6       3.636  27.999   4.037  1.00 25.34           C  
ATOM     76  C   LYS A   6       4.607  29.109   3.673  1.00 25.73           C  
ATOM     77  O   LYS A   6       5.564  28.895   2.930  1.00 25.80           O  
ATOM     78  CB  LYS A   6       2.298  28.243   3.363  1.00 27.43           C  
ATOM     79  CG  LYS A   6       2.232  27.877   1.874  1.00 29.21           C  
ATOM     80  CD  LYS A   6       1.072  28.652   1.252  1.00 35.25           C  
ATOM     81  CE  LYS A   6       0.380  27.939   0.102  1.00 39.24           C  
ATOM     82  NZ  LYS A   6      -0.067  28.900  -0.965  1.00 42.04           N  
ATOM     83  N   ILE A   7       4.385  30.277   4.242  1.00 26.41           N  
ATOM     84  CA  ILE A   7       5.181  31.449   3.957  1.00 27.60           C  
ATOM     85  C   ILE A   7       6.679  31.254   4.174  1.00 26.42           C  
ATOM     86  O   ILE A   7       7.480  31.640   3.325  1.00 25.02           O  
ATOM     87  CB  ILE A   7       4.706  32.571   4.849  1.00 29.75           C  
ATOM     88  CG1 ILE A   7       3.743  33.476   4.084  1.00 34.26           C  
ATOM     89  CG2 ILE A   7       5.856  33.382   5.347  1.00 32.66           C  
ATOM     90  CD1 ILE A   7       3.127  34.578   4.997  1.00 37.20           C  
ATOM     91  N   VAL A   8       7.055  30.659   5.299  1.00 25.60           N  
ATOM     92  CA  VAL A   8       8.490  30.494   5.639  1.00 24.84           C  
ATOM     93  C   VAL A   8       9.105  29.425   4.786  1.00 22.36           C  
ATOM     94  O   VAL A   8      10.255  29.530   4.408  1.00 20.22           O  
ATOM     95  CB  VAL A   8       8.804  30.083   7.103  1.00 24.13           C  
ATOM     96  CG1 VAL A   8       8.995  31.307   7.996  1.00 28.30           C  
ATOM     97  CG2 VAL A   8       7.772  29.034   7.685  1.00 22.96           C  
ATOM     98  N   ALA A   9       8.297  28.416   4.501  1.00 20.31           N  
ATOM     99  CA  ALA A   9       8.711  27.309   3.690  1.00 20.27           C  
ATOM    100  C   ALA A   9       8.965  27.741   2.268  1.00 19.68           C  
ATOM    101  O   ALA A   9      10.005  27.450   1.706  1.00 19.17           O  
ATOM    102  CB  ALA A   9       7.655  26.248   3.710  1.00 18.85           C  
ATOM    103  N   TYR A  10       7.998  28.414   1.661  1.00 20.74           N  
ATOM    104  CA  TYR A  10       8.205  28.945   0.307  1.00 20.59           C  
ATOM    105  C   TYR A  10       9.422  29.863   0.282  1.00 20.67           C  
ATOM    106  O   TYR A  10      10.211  29.834  -0.640  1.00 20.19           O  
ATOM    107  CB  TYR A  10       6.942  29.656  -0.224  1.00 21.80           C  
ATOM    108  CG  TYR A  10       5.911  28.673  -0.756  1.00 21.39           C  
ATOM    109  CD1 TYR A  10       5.795  27.378  -0.217  1.00 24.36           C  
ATOM    110  CD2 TYR A  10       5.034  29.040  -1.744  1.00 22.84           C  
ATOM    111  CE1 TYR A  10       4.862  26.466  -0.712  1.00 22.43           C  
ATOM    112  CE2 TYR A  10       4.069  28.132  -2.243  1.00 28.01           C  
ATOM    113  CZ  TYR A  10       4.002  26.853  -1.738  1.00 24.93           C  
ATOM    114  OH  TYR A  10       3.093  25.989  -2.267  1.00 21.50           O  
ATOM    115  N   LYS A  11       9.591  30.682   1.300  1.00 21.31           N  
ATOM    116  CA  LYS A  11      10.720  31.585   1.303  1.00 24.13           C  
ATOM    117  C   LYS A  11      12.073  30.856   1.317  1.00 24.44           C  
ATOM    118  O   LYS A  11      12.999  31.241   0.606  1.00 25.04           O  
ATOM    119  CB  LYS A  11      10.633  32.514   2.495  1.00 24.34           C  
ATOM    120  CG  LYS A  11      11.640  33.626   2.397  1.00 30.29           C  
ATOM    121  CD  LYS A  11      11.733  34.408   3.691  1.00 33.44           C  
ATOM    122  CE  LYS A  11      12.718  35.554   3.567  1.00 36.57           C  
ATOM    123  NZ  LYS A  11      12.648  36.408   4.781  1.00 40.66           N  
ATOM    124  N   ALA A  12      12.188  29.792   2.110  1.00 23.78           N  
ATOM    125  CA  ALA A  12      13.448  29.085   2.187  1.00 23.35           C  
ATOM    126  C   ALA A  12      13.760  28.521   0.815  1.00 23.64           C  
ATOM    127  O   ALA A  12      14.886  28.587   0.371  1.00 24.64           O  
ATOM    128  CB  ALA A  12      13.401  27.969   3.266  1.00 23.12           C  
ATOM    129  N   VAL A  13      12.756  27.990   0.125  1.00 22.54           N  
ATOM    130  CA  VAL A  13      13.009  27.377  -1.176  1.00 24.00           C  
ATOM    131  C   VAL A  13      13.366  28.489  -2.183  1.00 25.07           C  
ATOM    132  O   VAL A  13      14.412  28.450  -2.816  1.00 23.55           O  
ATOM    133  CB  VAL A  13      11.793  26.477  -1.618  1.00 22.79           C  
ATOM    134  CG1 VAL A  13      12.015  25.867  -2.975  1.00 20.87           C  
ATOM    135  CG2 VAL A  13      11.550  25.386  -0.542  1.00 22.19           C  
ATOM    136  N   ASP A  14      12.497  29.490  -2.297  1.00 25.85           N  
ATOM    137  CA  ASP A  14      12.677  30.546  -3.287  1.00 26.58           C  
ATOM    138  C   ASP A  14      14.012  31.303  -3.153  1.00 27.74           C  
ATOM    139  O   ASP A  14      14.677  31.633  -4.143  1.00 27.48           O  
ATOM    140  CB  ASP A  14      11.520  31.533  -3.178  1.00 26.85           C  
ATOM    141  CG  ASP A  14      10.202  30.907  -3.519  1.00 25.43           C  
ATOM    142  OD1 ASP A  14      10.212  29.945  -4.290  1.00 24.49           O  
ATOM    143  OD2 ASP A  14       9.158  31.386  -3.016  1.00 33.10           O  
ATOM    144  N   GLU A  15      14.430  31.542  -1.927  1.00 29.08           N  
ATOM    145  CA  GLU A  15      15.591  32.368  -1.707  1.00 30.26           C  
ATOM    146  C   GLU A  15      16.902  31.618  -1.545  1.00 28.91           C  
ATOM    147  O   GLU A  15      17.949  32.185  -1.787  1.00 29.72           O  
ATOM    148  CB  GLU A  15      15.325  33.252  -0.487  1.00 31.62           C  
ATOM    149  CG  GLU A  15      14.123  34.169  -0.755  1.00 36.96           C  
ATOM    150  CD  GLU A  15      14.011  35.278   0.251  1.00 46.27           C  
ATOM    151  OE1 GLU A  15      15.035  35.556   0.931  1.00 53.16           O  
ATOM    152  OE2 GLU A  15      12.904  35.866   0.371  1.00 49.18           O  
ATOM    153  N   TYR A  16      16.873  30.350  -1.188  1.00 27.00           N  
ATOM    154  CA  TYR A  16      18.127  29.665  -0.896  1.00 26.93           C  
ATOM    155  C   TYR A  16      18.370  28.439  -1.791  1.00 26.43           C  
ATOM    156  O   TYR A  16      19.508  28.072  -2.015  1.00 27.39           O  
ATOM    157  CB  TYR A  16      18.201  29.247   0.591  1.00 26.92           C  
ATOM    158  CG  TYR A  16      18.177  30.400   1.571  1.00 27.10           C  
ATOM    159  CD1 TYR A  16      16.969  30.953   1.999  1.00 25.30           C  
ATOM    160  CD2 TYR A  16      19.349  30.932   2.067  1.00 25.90           C  
ATOM    161  CE1 TYR A  16      16.933  32.000   2.858  1.00 25.31           C  
ATOM    162  CE2 TYR A  16      19.323  32.006   2.994  1.00 26.98           C  
ATOM    163  CZ  TYR A  16      18.122  32.517   3.384  1.00 27.68           C  
ATOM    164  OH  TYR A  16      18.102  33.588   4.260  1.00 29.54           O  
ATOM    165  N   VAL A  17      17.327  27.787  -2.276  1.00 24.64           N  
ATOM    166  CA  VAL A  17      17.530  26.553  -3.012  1.00 24.91           C  
ATOM    167  C   VAL A  17      17.751  26.874  -4.476  1.00 26.23           C  
ATOM    168  O   VAL A  17      16.959  27.641  -5.088  1.00 25.54           O  
ATOM    169  CB  VAL A  17      16.328  25.609  -2.868  1.00 24.31           C  
ATOM    170  CG1 VAL A  17      16.501  24.375  -3.757  1.00 24.54           C  
ATOM    171  CG2 VAL A  17      16.153  25.216  -1.431  1.00 24.69           C  
ATOM    172  N   GLN A  18      18.796  26.264  -5.033  1.00 26.40           N  
ATOM    173  CA  GLN A  18      19.236  26.530  -6.403  1.00 27.89           C  
ATOM    174  C   GLN A  18      19.335  25.231  -7.195  1.00 28.20           C  
ATOM    175  O   GLN A  18      19.353  24.139  -6.621  1.00 27.63           O  
ATOM    176  CB  GLN A  18      20.580  27.266  -6.420  1.00 26.86           C  
ATOM    177  CG  GLN A  18      20.552  28.650  -5.772  1.00 30.23           C  
ATOM    178  CD  GLN A  18      21.958  29.194  -5.420  1.00 32.95           C  
ATOM    179  OE1 GLN A  18      22.988  28.747  -5.960  1.00 40.99           O  
ATOM    180  NE2 GLN A  18      22.000  30.148  -4.501  1.00 37.28           N  
ATOM    181  N   SER A  19      19.362  25.344  -8.525  1.00 29.31           N  
ATOM    182  CA  SER A  19      19.494  24.159  -9.385  1.00 29.74           C  
ATOM    183  C   SER A  19      20.843  23.499  -9.174  1.00 29.68           C  
ATOM    184  O   SER A  19      21.805  24.135  -8.780  1.00 28.42           O  
ATOM    185  CB  SER A  19      19.350  24.539 -10.863  1.00 30.69           C  
ATOM    186  OG  SER A  19      18.133  25.200 -11.113  1.00 27.64           O  
ATOM    187  N   ASN A  20      20.902  22.210  -9.449  1.00 31.23           N  
ATOM    188  CA  ASN A  20      22.130  21.426  -9.285  1.00 32.86           C  
ATOM    189  C   ASN A  20      22.629  21.394  -7.828  1.00 31.92           C  
ATOM    190  O   ASN A  20      23.836  21.318  -7.595  1.00 33.79           O  
ATOM    191  CB  ASN A  20      23.281  21.908 -10.209  1.00 33.87           C  
ATOM    192  CG  ASN A  20      22.811  22.380 -11.591  1.00 35.59           C  
ATOM    193  OD1 ASN A  20      22.673  23.569 -11.814  1.00 39.29           O  
ATOM    194  ND2 ASN A  20      22.604  21.453 -12.524  1.00 41.78           N  
ATOM    195  N   MET A  21      21.704  21.474  -6.868  1.00 29.44           N  
ATOM    196  CA  MET A  21      22.011  21.346  -5.469  1.00 26.66           C  
ATOM    197  C   MET A  21      21.525  20.018  -4.980  1.00 26.65           C  
ATOM    198  O   MET A  21      20.549  19.454  -5.500  1.00 23.35           O  
ATOM    199  CB  MET A  21      21.315  22.421  -4.653  1.00 27.38           C  
ATOM    200  CG  MET A  21      22.028  23.787  -4.621  1.00 27.11           C  
ATOM    201  SD  MET A  21      21.364  24.821  -3.314  1.00 26.54           S  
ATOM    202  CE  MET A  21      22.716  26.007  -3.116  1.00 25.58           C  
ATOM    203  N   THR A  22      22.215  19.512  -3.957  1.00 26.77           N  
ATOM    204  CA  THR A  22      21.657  18.470  -3.100  1.00 26.23           C  
ATOM    205  C   THR A  22      21.076  19.078  -1.834  1.00 22.61           C  
ATOM    206  O   THR A  22      21.705  19.864  -1.181  1.00 22.41           O  
ATOM    207  CB  THR A  22      22.708  17.476  -2.693  1.00 26.90           C  
ATOM    208  OG1 THR A  22      23.160  16.770  -3.860  1.00 34.33           O  
ATOM    209  CG2 THR A  22      22.107  16.492  -1.716  1.00 30.06           C  
ATOM    210  N   ILE A  23      19.879  18.661  -1.488  1.00 22.02           N  
ATOM    211  CA  ILE A  23      19.065  19.294  -0.465  1.00 20.46           C  
ATOM    212  C   ILE A  23      18.585  18.264   0.579  1.00 20.91           C  
ATOM    213  O   ILE A  23      18.024  17.224   0.249  1.00 20.50           O  
ATOM    214  CB  ILE A  23      17.815  20.002  -1.078  1.00 20.46           C  
ATOM    215  CG1 ILE A  23      18.220  21.037  -2.121  1.00 20.19           C  
ATOM    216  CG2 ILE A  23      16.963  20.658   0.014  1.00 18.90           C  
ATOM    217  CD1 ILE A  23      19.046  22.194  -1.576  1.00 21.18           C  
ATOM    218  N   GLY A  24      18.843  18.566   1.842  1.00 20.44           N  
ATOM    219  CA  GLY A  24      18.362  17.745   2.921  1.00 20.09           C  
ATOM    220  C   GLY A  24      17.006  18.258   3.325  1.00 19.66           C  
ATOM    221  O   GLY A  24      16.819  19.457   3.514  1.00 19.60           O  
ATOM    222  N   LEU A  25      16.064  17.334   3.480  1.00 19.42           N  
ATOM    223  CA  LEU A  25      14.671  17.682   3.731  1.00 20.25           C  
ATOM    224  C   LEU A  25      14.307  17.277   5.138  1.00 19.38           C  
ATOM    225  O   LEU A  25      14.460  16.148   5.521  1.00 18.31           O  
ATOM    226  CB  LEU A  25      13.788  16.951   2.710  1.00 20.11           C  
ATOM    227  CG  LEU A  25      13.994  17.354   1.244  1.00 20.12           C  
ATOM    228  CD1 LEU A  25      13.261  16.381   0.355  1.00 20.93           C  
ATOM    229  CD2 LEU A  25      13.519  18.731   0.967  1.00 22.40           C  
ATOM    230  N   GLY A  26      13.858  18.226   5.931  1.00 20.19           N  
ATOM    231  CA  GLY A  26      13.436  17.948   7.287  1.00 19.85           C  
ATOM    232  C   GLY A  26      12.132  17.186   7.373  1.00 19.87           C  
ATOM    233  O   GLY A  26      11.760  16.471   6.460  1.00 23.10           O  
ATOM    234  N   THR A  27      11.438  17.339   8.491  1.00 20.64           N  
ATOM    235  CA  THR A  27      10.294  16.521   8.812  1.00 21.14           C  
ATOM    236  C   THR A  27       9.205  17.422   9.424  1.00 22.01           C  
ATOM    237  O   THR A  27       9.492  18.416  10.128  1.00 23.29           O  
ATOM    238  CB  THR A  27      10.667  15.295   9.755  1.00 21.90           C  
ATOM    239  OG1 THR A  27      11.638  14.424   9.131  1.00 21.92           O  
ATOM    240  CG2 THR A  27       9.438  14.462  10.107  1.00 24.45           C  
ATOM    241  N   GLY A  28       7.947  17.112   9.121  1.00 21.23           N  
ATOM    242  CA  GLY A  28       6.819  17.747   9.812  1.00 20.70           C  
ATOM    243  C   GLY A  28       5.983  18.641   8.925  1.00 20.87           C  
ATOM    244  O   GLY A  28       6.129  18.675   7.706  1.00 22.11           O  
ATOM    245  N   SER A  29       5.099  19.377   9.566  1.00 20.43           N  
ATOM    246  CA  SER A  29       3.979  19.995   8.913  1.00 20.31           C  
ATOM    247  C   SER A  29       4.387  21.295   8.234  1.00 21.56           C  
ATOM    248  O   SER A  29       3.792  21.697   7.191  1.00 20.78           O  
ATOM    249  CB  SER A  29       2.865  20.240   9.944  1.00 20.28           C  
ATOM    250  OG  SER A  29       3.237  21.254  10.830  1.00 15.67           O  
ATOM    251  N   THR A  30       5.397  21.951   8.816  1.00 22.67           N  
ATOM    252  CA  THR A  30       6.037  23.100   8.164  1.00 23.17           C  
ATOM    253  C   THR A  30       6.797  22.701   6.868  1.00 23.21           C  
ATOM    254  O   THR A  30       6.644  23.337   5.780  1.00 21.65           O  
ATOM    255  CB  THR A  30       6.942  23.846   9.163  1.00 23.23           C  
ATOM    256  OG1 THR A  30       6.161  24.233  10.309  1.00 26.16           O  
ATOM    257  CG2 THR A  30       7.535  25.100   8.545  1.00 23.48           C  
ATOM    258  N   VAL A  31       7.564  21.616   6.977  1.00 22.50           N  
ATOM    259  CA  VAL A  31       8.381  21.158   5.878  1.00 23.51           C  
ATOM    260  C   VAL A  31       7.575  20.649   4.714  1.00 23.43           C  
ATOM    261  O   VAL A  31       8.080  20.611   3.583  1.00 23.89           O  
ATOM    262  CB  VAL A  31       9.383  20.033   6.296  1.00 22.97           C  
ATOM    263  CG1 VAL A  31      10.085  19.477   5.072  1.00 25.74           C  
ATOM    264  CG2 VAL A  31      10.398  20.566   7.280  1.00 23.70           C  
ATOM    265  N   PHE A  32       6.355  20.206   4.998  1.00 23.91           N  
ATOM    266  CA  PHE A  32       5.404  19.810   3.980  1.00 23.29           C  
ATOM    267  C   PHE A  32       5.414  20.771   2.773  1.00 22.67           C  
ATOM    268  O   PHE A  32       5.308  20.355   1.607  1.00 20.60           O  
ATOM    269  CB  PHE A  32       4.031  19.777   4.638  1.00 25.48           C  
ATOM    270  CG  PHE A  32       2.908  19.562   3.694  1.00 26.94           C  
ATOM    271  CD1 PHE A  32       2.553  18.283   3.312  1.00 27.36           C  
ATOM    272  CD2 PHE A  32       2.179  20.656   3.195  1.00 27.07           C  
ATOM    273  CE1 PHE A  32       1.516  18.092   2.406  1.00 31.92           C  
ATOM    274  CE2 PHE A  32       1.135  20.477   2.322  1.00 29.13           C  
ATOM    275  CZ  PHE A  32       0.791  19.200   1.916  1.00 29.74           C  
ATOM    276  N   TYR A  33       5.527  22.062   3.067  1.00 21.93           N  
ATOM    277  CA  TYR A  33       5.327  23.131   2.070  1.00 21.91           C  
ATOM    278  C   TYR A  33       6.598  23.385   1.313  1.00 20.68           C  
ATOM    279  O   TYR A  33       6.578  23.960   0.209  1.00 20.01           O  
ATOM    280  CB  TYR A  33       4.859  24.411   2.761  1.00 21.99           C  
ATOM    281  CG  TYR A  33       3.460  24.307   3.280  1.00 22.07           C  
ATOM    282  CD1 TYR A  33       2.395  24.278   2.411  1.00 25.34           C  
ATOM    283  CD2 TYR A  33       3.200  24.210   4.631  1.00 22.27           C  
ATOM    284  CE1 TYR A  33       1.110  24.182   2.857  1.00 26.47           C  
ATOM    285  CE2 TYR A  33       1.912  24.106   5.091  1.00 26.64           C  
ATOM    286  CZ  TYR A  33       0.864  24.104   4.193  1.00 25.45           C  
ATOM    287  OH  TYR A  33      -0.434  24.004   4.621  1.00 25.92           O  
ATOM    288  N   VAL A  34       7.707  22.988   1.943  1.00 21.17           N  
ATOM    289  CA  VAL A  34       9.002  22.848   1.295  1.00 21.97           C  
ATOM    290  C   VAL A  34       8.972  21.762   0.196  1.00 20.47           C  
ATOM    291  O   VAL A  34       9.469  21.959  -0.921  1.00 19.64           O  
ATOM    292  CB  VAL A  34      10.140  22.527   2.359  1.00 23.52           C  
ATOM    293  CG1 VAL A  34      11.430  22.081   1.671  1.00 25.97           C  
ATOM    294  CG2 VAL A  34      10.407  23.722   3.270  1.00 24.05           C  
ATOM    295  N   LEU A  35       8.395  20.606   0.506  1.00 19.95           N  
ATOM    296  CA  LEU A  35       8.230  19.562  -0.508  1.00 19.63           C  
ATOM    297  C   LEU A  35       7.336  20.058  -1.613  1.00 19.67           C  
ATOM    298  O   LEU A  35       7.601  19.853  -2.798  1.00 19.02           O  
ATOM    299  CB  LEU A  35       7.613  18.306   0.106  1.00 20.97           C  
ATOM    300  CG  LEU A  35       8.600  17.295   0.716  1.00 21.96           C  
ATOM    301  CD1 LEU A  35       9.485  17.971   1.788  1.00 23.64           C  
ATOM    302  CD2 LEU A  35       7.837  16.134   1.295  1.00 27.45           C  
ATOM    303  N   GLU A  36       6.251  20.721  -1.222  1.00 19.73           N  
ATOM    304  CA  GLU A  36       5.282  21.242  -2.189  1.00 20.18           C  
ATOM    305  C   GLU A  36       5.943  22.176  -3.165  1.00 20.11           C  
ATOM    306  O   GLU A  36       5.735  22.114  -4.367  1.00 22.41           O  
ATOM    307  CB  GLU A  36       4.194  21.987  -1.451  1.00 21.06           C  
ATOM    308  CG  GLU A  36       3.056  22.556  -2.307  1.00 22.59           C  
ATOM    309  CD  GLU A  36       1.972  23.157  -1.416  1.00 24.43           C  
ATOM    310  OE1 GLU A  36       1.163  22.377  -0.856  1.00 24.00           O  
ATOM    311  OE2 GLU A  36       1.995  24.397  -1.217  1.00 28.13           O  
ATOM    312  N   ARG A  37       6.742  23.069  -2.641  1.00 20.91           N  
ATOM    313  CA  ARG A  37       7.346  24.118  -3.434  1.00 20.56           C  
ATOM    314  C   ARG A  37       8.447  23.593  -4.333  1.00 19.14           C  
ATOM    315  O   ARG A  37       8.513  23.929  -5.508  1.00 18.37           O  
ATOM    316  CB  ARG A  37       7.897  25.193  -2.497  1.00 21.14           C  
ATOM    317  CG  ARG A  37       8.367  26.435  -3.179  1.00 24.09           C  
ATOM    318  CD  ARG A  37       7.306  26.950  -4.123  1.00 26.17           C  
ATOM    319  NE  ARG A  37       7.518  28.341  -4.467  1.00 27.01           N  
ATOM    320  CZ  ARG A  37       6.712  29.024  -5.291  1.00 34.26           C  
ATOM    321  NH1 ARG A  37       5.618  28.462  -5.844  1.00 31.41           N  
ATOM    322  NH2 ARG A  37       6.988  30.290  -5.556  1.00 33.92           N  
ATOM    323  N   ILE A  38       9.275  22.722  -3.804  1.00 19.22           N  
ATOM    324  CA  ILE A  38      10.348  22.168  -4.584  1.00 20.65           C  
ATOM    325  C   ILE A  38       9.803  21.386  -5.759  1.00 20.62           C  
ATOM    326  O   ILE A  38      10.246  21.601  -6.862  1.00 20.83           O  
ATOM    327  CB  ILE A  38      11.221  21.288  -3.710  1.00 21.04           C  
ATOM    328  CG1 ILE A  38      12.079  22.176  -2.785  1.00 25.35           C  
ATOM    329  CG2 ILE A  38      12.093  20.387  -4.558  1.00 24.78           C  
ATOM    330  CD1 ILE A  38      12.901  21.402  -1.785  1.00 23.20           C  
ATOM    331  N   ASP A  39       8.824  20.511  -5.524  1.00 22.16           N  
ATOM    332  CA  ASP A  39       8.091  19.809  -6.601  1.00 22.66           C  
ATOM    333  C   ASP A  39       7.449  20.788  -7.608  1.00 23.40           C  
ATOM    334  O   ASP A  39       7.625  20.686  -8.810  1.00 21.69           O  
ATOM    335  CB  ASP A  39       7.024  18.874  -6.001  1.00 22.91           C  
ATOM    336  CG  ASP A  39       6.126  18.243  -7.063  1.00 26.77           C  
ATOM    337  OD1 ASP A  39       6.674  17.606  -8.002  1.00 28.22           O  
ATOM    338  OD2 ASP A  39       4.884  18.405  -6.968  1.00 32.56           O  
ATOM    339  N   ASN A  40       6.718  21.772  -7.108  1.00 23.87           N  
ATOM    340  CA  ASN A  40       6.211  22.825  -7.967  1.00 23.64           C  
ATOM    341  C   ASN A  40       7.298  23.397  -8.927  1.00 24.21           C  
ATOM    342  O   ASN A  40       7.122  23.423 -10.139  1.00 23.08           O  
ATOM    343  CB  ASN A  40       5.581  23.924  -7.092  1.00 23.46           C  
ATOM    344  CG  ASN A  40       4.923  24.997  -7.901  1.00 22.68           C  
ATOM    345  OD1 ASN A  40       5.525  26.021  -8.174  1.00 23.33           O  
ATOM    346  ND2 ASN A  40       3.718  24.747  -8.336  1.00 20.87           N  
ATOM    347  N   LEU A  41       8.428  23.846  -8.376  1.00 25.53           N  
ATOM    348  CA  LEU A  41       9.437  24.539  -9.161  1.00 23.88           C  
ATOM    349  C   LEU A  41      10.159  23.601 -10.084  1.00 23.36           C  
ATOM    350  O   LEU A  41      10.663  24.017 -11.112  1.00 21.16           O  
ATOM    351  CB  LEU A  41      10.459  25.195  -8.263  1.00 25.05           C  
ATOM    352  CG  LEU A  41       9.934  26.235  -7.285  1.00 24.14           C  
ATOM    353  CD1 LEU A  41      11.097  26.728  -6.448  1.00 23.93           C  
ATOM    354  CD2 LEU A  41       9.317  27.377  -7.991  1.00 26.81           C  
ATOM    355  N   LEU A  42      10.233  22.337  -9.695  1.00 25.19           N  
ATOM    356  CA  LEU A  42      10.919  21.336 -10.476  1.00 25.92           C  
ATOM    357  C   LEU A  42      10.079  21.029 -11.704  1.00 26.51           C  
ATOM    358  O   LEU A  42      10.611  20.873 -12.804  1.00 27.37           O  
ATOM    359  CB  LEU A  42      11.164  20.045  -9.660  1.00 27.14           C  
ATOM    360  CG  LEU A  42      12.469  19.974  -8.876  1.00 26.62           C  
ATOM    361  CD1 LEU A  42      12.600  18.741  -7.930  1.00 24.76           C  
ATOM    362  CD2 LEU A  42      13.612  20.027  -9.893  1.00 30.16           C  
ATOM    363  N   LYS A  43       8.767  20.923 -11.503  1.00 25.29           N  
ATOM    364  CA  LYS A  43       7.836  20.624 -12.595  1.00 24.51           C  
ATOM    365  C   LYS A  43       7.752  21.793 -13.609  1.00 22.98           C  
ATOM    366  O   LYS A  43       7.637  21.553 -14.832  1.00 20.25           O  
ATOM    367  CB  LYS A  43       6.460  20.256 -12.046  1.00 23.96           C  
ATOM    368  CG  LYS A  43       6.389  18.867 -11.467  1.00 25.17           C  
ATOM    369  CD  LYS A  43       5.064  18.669 -10.771  1.00 26.25           C  
ATOM    370  CE  LYS A  43       4.682  17.146 -10.558  1.00 27.60           C  
ATOM    371  NZ  LYS A  43       5.602  16.315  -9.668  1.00 20.26           N  
ATOM    372  N   SER A  44       7.868  23.024 -13.104  1.00 22.26           N  
ATOM    373  CA  SER A  44       7.861  24.185 -13.939  1.00 23.36           C  
ATOM    374  C   SER A  44       9.179  24.447 -14.667  1.00 24.56           C  
ATOM    375  O   SER A  44       9.214  25.231 -15.621  1.00 25.59           O  
ATOM    376  CB  SER A  44       7.530  25.421 -13.114  1.00 24.58           C  
ATOM    377  OG  SER A  44       8.640  25.850 -12.343  1.00 26.87           O  
ATOM    378  N   GLY A  45      10.257  23.814 -14.216  1.00 23.33           N  
ATOM    379  CA  GLY A  45      11.562  24.024 -14.811  1.00 22.33           C  
ATOM    380  C   GLY A  45      12.249  25.208 -14.152  1.00 22.61           C  
ATOM    381  O   GLY A  45      13.374  25.532 -14.500  1.00 23.15           O  
ATOM    382  N   LYS A  46      11.600  25.880 -13.209  1.00 22.16           N  
ATOM    383  CA  LYS A  46      12.293  27.000 -12.552  1.00 23.69           C  
ATOM    384  C   LYS A  46      13.499  26.436 -11.809  1.00 24.98           C  
ATOM    385  O   LYS A  46      14.502  27.128 -11.658  1.00 27.36           O  
ATOM    386  CB  LYS A  46      11.398  27.831 -11.609  1.00 22.67           C  
ATOM    387  N   LEU A  47      13.380  25.187 -11.352  1.00 25.38           N  
ATOM    388  CA  LEU A  47      14.475  24.431 -10.752  1.00 24.86           C  
ATOM    389  C   LEU A  47      14.784  23.181 -11.566  1.00 25.25           C  
ATOM    390  O   LEU A  47      13.859  22.558 -12.100  1.00 25.80           O  
ATOM    391  CB  LEU A  47      14.097  24.005  -9.306  1.00 24.50           C  
ATOM    392  CG  LEU A  47      14.311  24.914  -8.089  1.00 24.96           C  
ATOM    393  CD1 LEU A  47      13.991  24.135  -6.805  1.00 27.44           C  
ATOM    394  CD2 LEU A  47      15.708  25.501  -8.003  1.00 26.18           C  
ATOM    395  N   LYS A  48      16.070  22.810 -11.645  1.00 24.80           N  
ATOM    396  CA  LYS A  48      16.498  21.557 -12.264  1.00 25.54           C  
ATOM    397  C   LYS A  48      17.664  20.905 -11.503  1.00 26.44           C  
ATOM    398  O   LYS A  48      18.363  21.561 -10.756  1.00 27.83           O  
ATOM    399  CB  LYS A  48      16.897  21.763 -13.741  1.00 25.33           C  
ATOM    400  N   ASP A  49      17.877  19.615 -11.734  1.00 27.46           N  
ATOM    401  CA  ASP A  49      19.029  18.905 -11.179  1.00 29.13           C  
ATOM    402  C   ASP A  49      19.126  19.082  -9.650  1.00 28.14           C  
ATOM    403  O   ASP A  49      20.184  19.366  -9.108  1.00 29.03           O  
ATOM    404  CB  ASP A  49      20.336  19.375 -11.825  1.00 30.13           C  
ATOM    405  CG  ASP A  49      20.377  19.194 -13.368  1.00 36.82           C  
ATOM    406  OD1 ASP A  49      20.211  18.055 -13.875  1.00 39.77           O  
ATOM    407  OD2 ASP A  49      20.640  20.220 -14.070  1.00 44.82           O  
ATOM    408  N   VAL A  50      17.993  18.912  -8.982  1.00 27.03           N  
ATOM    409  CA  VAL A  50      17.866  19.001  -7.542  1.00 25.84           C  
ATOM    410  C   VAL A  50      17.542  17.611  -7.035  1.00 25.61           C  
ATOM    411  O   VAL A  50      16.538  17.017  -7.422  1.00 25.39           O  
ATOM    412  CB  VAL A  50      16.758  19.981  -7.143  1.00 23.72           C  
ATOM    413  CG1 VAL A  50      16.525  19.906  -5.702  1.00 27.14           C  
ATOM    414  CG2 VAL A  50      17.150  21.414  -7.521  1.00 22.91           C  
ATOM    415  N   VAL A  51      18.406  17.076  -6.185  1.00 26.37           N  
ATOM    416  CA  VAL A  51      18.166  15.776  -5.566  1.00 27.62           C  
ATOM    417  C   VAL A  51      18.114  15.943  -4.051  1.00 27.05           C  
ATOM    418  O   VAL A  51      18.787  16.787  -3.503  1.00 28.22           O  
ATOM    419  CB  VAL A  51      19.243  14.754  -5.956  1.00 28.53           C  
ATOM    420  CG1 VAL A  51      20.597  15.153  -5.387  1.00 33.17           C  
ATOM    421  CG2 VAL A  51      18.879  13.380  -5.447  1.00 28.03           C  
ATOM    422  N   CYS A  52      17.295  15.149  -3.379  1.00 25.68           N  
ATOM    423  CA  CYS A  52      17.083  15.329  -1.950  1.00 24.47           C  
ATOM    424  C   CYS A  52      17.386  14.110  -1.084  1.00 23.35           C  
ATOM    425  O   CYS A  52      17.214  12.964  -1.491  1.00 22.24           O  
ATOM    426  CB  CYS A  52      15.632  15.764  -1.703  1.00 24.61           C  
ATOM    427  SG  CYS A  52      15.241  17.238  -2.673  1.00 25.93           S  
ATOM    428  N   ILE A  53      17.775  14.397   0.145  1.00 22.47           N  
ATOM    429  CA  ILE A  53      17.954  13.377   1.134  1.00 22.56           C  
ATOM    430  C   ILE A  53      16.955  13.588   2.299  1.00 22.23           C  
ATOM    431  O   ILE A  53      16.952  14.617   2.978  1.00 21.93           O  
ATOM    432  CB  ILE A  53      19.450  13.306   1.595  1.00 22.74           C  
ATOM    433  CG1 ILE A  53      20.323  12.894   0.418  1.00 25.18           C  
ATOM    434  CG2 ILE A  53      19.626  12.316   2.679  1.00 20.72           C  
ATOM    435  CD1 ILE A  53      21.751  13.285   0.611  1.00 31.79           C  
ATOM    436  N   PRO A  54      16.110  12.585   2.531  1.00 21.73           N  
ATOM    437  CA  PRO A  54      15.068  12.698   3.522  1.00 21.54           C  
ATOM    438  C   PRO A  54      15.563  12.359   4.946  1.00 20.81           C  
ATOM    439  O   PRO A  54      16.393  11.471   5.137  1.00 21.96           O  
ATOM    440  CB  PRO A  54      14.022  11.712   3.012  1.00 21.14           C  
ATOM    441  CG  PRO A  54      14.814  10.656   2.278  1.00 23.18           C  
ATOM    442  CD  PRO A  54      16.119  11.270   1.872  1.00 22.12           C  
ATOM    443  N   THR A  55      15.051  13.089   5.923  1.00 21.24           N  
ATOM    444  CA  THR A  55      15.367  12.917   7.344  1.00 22.30           C  
ATOM    445  C   THR A  55      14.452  11.959   8.088  1.00 23.09           C  
ATOM    446  O   THR A  55      14.644  11.724   9.284  1.00 25.15           O  
ATOM    447  CB  THR A  55      15.217  14.240   8.071  1.00 21.35           C  
ATOM    448  OG1 THR A  55      13.900  14.741   7.828  1.00 20.23           O  
ATOM    449  CG2 THR A  55      16.277  15.279   7.588  1.00 22.41           C  
ATOM    450  N   SER A  56      13.435  11.444   7.404  1.00 22.72           N  
ATOM    451  CA  SER A  56      12.575  10.405   7.951  1.00 23.05           C  
ATOM    452  C   SER A  56      11.990   9.588   6.823  1.00 24.46           C  
ATOM    453  O   SER A  56      12.078   9.959   5.635  1.00 24.46           O  
ATOM    454  CB  SER A  56      11.427  10.987   8.757  1.00 23.70           C  
ATOM    455  OG  SER A  56      10.676  11.887   7.974  1.00 21.52           O  
ATOM    456  N   ILE A  57      11.366   8.476   7.210  1.00 23.89           N  
ATOM    457  CA  ILE A  57      10.664   7.634   6.260  1.00 23.65           C  
ATOM    458  C   ILE A  57       9.382   8.330   5.792  1.00 23.68           C  
ATOM    459  O   ILE A  57       9.060   8.262   4.586  1.00 22.92           O  
ATOM    460  CB  ILE A  57      10.406   6.266   6.860  1.00 24.41           C  
ATOM    461  CG1 ILE A  57      11.688   5.418   6.657  1.00 27.26           C  
ATOM    462  CG2 ILE A  57       9.200   5.650   6.203  1.00 25.34           C  
ATOM    463  CD1 ILE A  57      11.964   4.407   7.703  1.00 29.92           C  
ATOM    464  N   ASP A  58       8.712   9.045   6.711  1.00 22.65           N  
ATOM    465  CA  ASP A  58       7.553   9.897   6.362  1.00 23.06           C  
ATOM    466  C   ASP A  58       7.902  10.885   5.238  1.00 23.21           C  
ATOM    467  O   ASP A  58       7.181  11.016   4.253  1.00 24.13           O  
ATOM    468  CB  ASP A  58       7.017  10.646   7.608  1.00 24.14           C  
ATOM    469  CG  ASP A  58       5.764  11.550   7.299  1.00 29.01           C  
ATOM    470  OD1 ASP A  58       4.674  10.971   7.009  1.00 37.71           O  
ATOM    471  OD2 ASP A  58       5.858  12.828   7.376  1.00 30.87           O  
ATOM    472  N   THR A  59       9.044  11.540   5.370  1.00 22.26           N  
ATOM    473  CA  THR A  59       9.449  12.532   4.426  1.00 22.79           C  
ATOM    474  C   THR A  59       9.831  11.872   3.108  1.00 22.89           C  
ATOM    475  O   THR A  59       9.535  12.403   2.034  1.00 20.20           O  
ATOM    476  CB  THR A  59      10.628  13.381   4.957  1.00 21.00           C  
ATOM    477  OG1 THR A  59      10.173  14.245   5.994  1.00 26.19           O  
ATOM    478  CG2 THR A  59      11.246  14.245   3.840  1.00 22.16           C  
ATOM    479  N   GLU A  60      10.499  10.720   3.188  1.00 24.02           N  
ATOM    480  CA  GLU A  60      10.851   9.988   1.966  1.00 25.15           C  
ATOM    481  C   GLU A  60       9.625   9.575   1.130  1.00 24.75           C  
ATOM    482  O   GLU A  60       9.650   9.756  -0.096  1.00 22.85           O  
ATOM    483  CB  GLU A  60      11.659   8.749   2.291  1.00 26.25           C  
ATOM    484  CG  GLU A  60      11.816   7.797   1.063  1.00 28.76           C  
ATOM    485  CD  GLU A  60      12.556   6.520   1.389  1.00 29.60           C  
ATOM    486  OE1 GLU A  60      12.458   6.053   2.557  1.00 37.11           O  
ATOM    487  OE2 GLU A  60      13.217   5.978   0.468  1.00 34.81           O  
ATOM    488  N   LEU A  61       8.593   9.020   1.791  1.00 24.71           N  
ATOM    489  CA  LEU A  61       7.334   8.605   1.154  1.00 26.57           C  
ATOM    490  C   LEU A  61       6.620   9.785   0.496  1.00 26.50           C  
ATOM    491  O   LEU A  61       6.240   9.705  -0.655  1.00 26.35           O  
ATOM    492  CB  LEU A  61       6.359   7.975   2.151  1.00 28.68           C  
ATOM    493  CG  LEU A  61       6.691   6.602   2.752  1.00 36.84           C  
ATOM    494  CD1 LEU A  61       5.828   6.298   4.000  1.00 40.72           C  
ATOM    495  CD2 LEU A  61       6.541   5.483   1.723  1.00 40.43           C  
ATOM    496  N   LYS A  62       6.457  10.879   1.237  1.00 25.34           N  
ATOM    497  CA  LYS A  62       5.833  12.092   0.716  1.00 23.98           C  
ATOM    498  C   LYS A  62       6.574  12.602  -0.503  1.00 24.28           C  
ATOM    499  O   LYS A  62       5.973  13.092  -1.446  1.00 24.56           O  
ATOM    500  CB  LYS A  62       5.774  13.178   1.820  1.00 23.57           C  
ATOM    501  CG  LYS A  62       4.699  12.936   2.832  1.00 22.14           C  
ATOM    502  CD  LYS A  62       4.625  13.956   3.942  1.00 23.19           C  
ATOM    503  CE  LYS A  62       3.676  13.414   5.015  1.00 24.57           C  
ATOM    504  NZ  LYS A  62       3.979  13.924   6.397  1.00 24.71           N  
ATOM    505  N   ALA A  63       7.891  12.506  -0.488  1.00 25.41           N  
ATOM    506  CA  ALA A  63       8.695  13.107  -1.558  1.00 25.61           C  
ATOM    507  C   ALA A  63       8.638  12.257  -2.786  1.00 24.88           C  
ATOM    508  O   ALA A  63       8.714  12.740  -3.917  1.00 23.07           O  
ATOM    509  CB  ALA A  63      10.135  13.281  -1.124  1.00 25.81           C  
ATOM    510  N   ARG A  64       8.516  10.976  -2.548  1.00 25.53           N  
ATOM    511  CA  ARG A  64       8.497  10.035  -3.624  1.00 27.47           C  
ATOM    512  C   ARG A  64       7.163  10.065  -4.396  1.00 28.46           C  
ATOM    513  O   ARG A  64       7.163   9.947  -5.630  1.00 28.49           O  
ATOM    514  CB  ARG A  64       8.756   8.649  -3.063  1.00 27.35           C  
ATOM    515  CG  ARG A  64       9.558   7.784  -3.985  1.00 31.89           C  
ATOM    516  CD  ARG A  64       9.909   6.454  -3.343  1.00 35.41           C  
ATOM    517  NE  ARG A  64      11.134   6.485  -2.566  1.00 34.96           N  
ATOM    518  CZ  ARG A  64      12.351   6.566  -3.094  1.00 38.03           C  
ATOM    519  NH1 ARG A  64      12.517   6.674  -4.402  1.00 39.30           N  
ATOM    520  NH2 ARG A  64      13.421   6.541  -2.312  1.00 38.74           N  
ATOM    521  N   LYS A  65       6.044  10.168  -3.657  1.00 28.83           N  
ATOM    522  CA  LYS A  65       4.722  10.439  -4.223  1.00 30.45           C  
ATOM    523  C   LYS A  65       4.726  11.700  -5.079  1.00 30.48           C  
ATOM    524  O   LYS A  65       4.248  11.685  -6.198  1.00 32.41           O  
ATOM    525  CB  LYS A  65       3.644  10.575  -3.127  1.00 30.72           C  
ATOM    526  N   LEU A  66       5.264  12.791  -4.568  1.00 31.16           N  
ATOM    527  CA  LEU A  66       5.367  14.018  -5.351  1.00 30.78           C  
ATOM    528  C   LEU A  66       6.217  13.859  -6.605  1.00 31.62           C  
ATOM    529  O   LEU A  66       5.979  14.539  -7.602  1.00 32.99           O  
ATOM    530  CB  LEU A  66       5.968  15.137  -4.506  1.00 32.03           C  
ATOM    531  CG  LEU A  66       5.046  15.709  -3.418  1.00 34.81           C  
ATOM    532  CD1 LEU A  66       5.790  16.727  -2.572  1.00 34.32           C  
ATOM    533  CD2 LEU A  66       3.761  16.327  -4.015  1.00 36.15           C  
ATOM    534  N   GLY A  67       7.204  12.969  -6.559  1.00 31.46           N  
ATOM    535  CA  GLY A  67       8.128  12.768  -7.683  1.00 30.77           C  
ATOM    536  C   GLY A  67       9.414  13.576  -7.582  1.00 30.64           C  
ATOM    537  O   GLY A  67      10.127  13.730  -8.566  1.00 31.53           O  
ATOM    538  N   ILE A  68       9.734  14.090  -6.395  1.00 28.95           N  
ATOM    539  CA  ILE A  68      11.022  14.743  -6.152  1.00 28.69           C  
ATOM    540  C   ILE A  68      12.207  13.738  -6.154  1.00 28.97           C  
ATOM    541  O   ILE A  68      12.216  12.755  -5.387  1.00 29.78           O  
ATOM    542  CB  ILE A  68      11.019  15.424  -4.803  1.00 28.96           C  
ATOM    543  CG1 ILE A  68       9.843  16.414  -4.685  1.00 29.12           C  
ATOM    544  CG2 ILE A  68      12.325  16.118  -4.614  1.00 32.38           C  
ATOM    545  CD1 ILE A  68       9.730  17.079  -3.313  1.00 31.70           C  
ATOM    546  N   PRO A  69      13.227  13.972  -6.993  1.00 28.78           N  
ATOM    547  CA  PRO A  69      14.337  12.979  -6.947  1.00 28.59           C  
ATOM    548  C   PRO A  69      15.032  12.874  -5.573  1.00 29.46           C  
ATOM    549  O   PRO A  69      15.244  13.886  -4.900  1.00 30.86           O  
ATOM    550  CB  PRO A  69      15.305  13.480  -8.038  1.00 27.83           C  
ATOM    551  CG  PRO A  69      14.459  14.362  -8.911  1.00 27.54           C  
ATOM    552  CD  PRO A  69      13.484  15.030  -7.987  1.00 27.34           C  
ATOM    553  N   LEU A  70      15.333  11.646  -5.163  1.00 29.40           N  
ATOM    554  CA  LEU A  70      15.925  11.370  -3.870  1.00 30.18           C  
ATOM    555  C   LEU A  70      17.197  10.632  -4.043  1.00 30.18           C  
ATOM    556  O   LEU A  70      17.328   9.818  -4.916  1.00 29.66           O  
ATOM    557  CB  LEU A  70      15.015  10.498  -3.007  1.00 31.01           C  
ATOM    558  CG  LEU A  70      13.664  11.062  -2.541  1.00 31.34           C  
ATOM    559  CD1 LEU A  70      12.909  10.004  -1.786  1.00 30.20           C  
ATOM    560  CD2 LEU A  70      13.849  12.269  -1.676  1.00 32.33           C  
ATOM    561  N   THR A  71      18.151  10.942  -3.203  1.00 31.85           N  
ATOM    562  CA  THR A  71      19.273  10.060  -2.994  1.00 33.70           C  
ATOM    563  C   THR A  71      19.388   9.768  -1.500  1.00 35.75           C  
ATOM    564  O   THR A  71      18.443   9.979  -0.718  1.00 36.15           O  
ATOM    565  CB  THR A  71      20.594  10.659  -3.551  1.00 33.61           C  
ATOM    566  OG1 THR A  71      21.632   9.663  -3.520  1.00 36.23           O  
ATOM    567  CG2 THR A  71      21.049  11.940  -2.768  1.00 28.92           C  
ATOM    568  N   THR A  72      20.597   9.365  -1.136  1.00 38.07           N  
ATOM    569  CA  THR A  72      20.913   8.671   0.076  1.00 39.46           C  
ATOM    570  C   THR A  72      22.220   9.218   0.575  1.00 39.62           C  
ATOM    571  O   THR A  72      23.015   9.737  -0.195  1.00 38.92           O  
ATOM    572  CB  THR A  72      21.073   7.175  -0.242  1.00 40.55           C  
ATOM    573  OG1 THR A  72      20.349   6.384   0.709  1.00 39.60           O  
ATOM    574  CG2 THR A  72      22.581   6.744  -0.299  1.00 42.39           C  
ATOM    575  N   LEU A  73      22.455   9.117   1.869  1.00 41.09           N  
ATOM    576  CA  LEU A  73      23.659   9.707   2.460  1.00 42.02           C  
ATOM    577  C   LEU A  73      24.914   8.784   2.329  1.00 44.40           C  
ATOM    578  O   LEU A  73      25.082   7.831   3.098  1.00 46.48           O  
ATOM    579  CB  LEU A  73      23.340  10.058   3.922  1.00 41.26           C  
ATOM    580  CG  LEU A  73      24.270  10.997   4.684  1.00 39.99           C  
ATOM    581  CD1 LEU A  73      24.485  12.320   3.958  1.00 39.68           C  
ATOM    582  CD2 LEU A  73      23.731  11.219   6.110  1.00 39.84           C  
ATOM    583  N   GLU A  74      25.778   9.057   1.352  1.00 45.44           N  
ATOM    584  CA  GLU A  74      26.975   8.241   1.118  1.00 47.71           C  
ATOM    585  C   GLU A  74      28.238   9.066   1.424  1.00 49.40           C  
ATOM    586  O   GLU A  74      28.125  10.231   1.819  1.00 49.72           O  
ATOM    587  CB  GLU A  74      26.975   7.680  -0.327  1.00 48.24           C  
ATOM    588  N   LYS A  75      29.432   8.469   1.276  1.00 51.55           N  
ATOM    589  CA  LYS A  75      30.708   9.167   1.585  1.00 53.61           C  
ATOM    590  C   LYS A  75      30.924  10.411   0.693  1.00 55.98           C  
ATOM    591  O   LYS A  75      31.513  11.434   1.103  1.00 56.64           O  
ATOM    592  CB  LYS A  75      31.905   8.207   1.449  1.00 52.79           C  
ATOM    593  N   HIS A  76      30.431  10.308  -0.539  1.00 57.64           N  
ATOM    594  CA  HIS A  76      30.557  11.373  -1.525  1.00 58.35           C  
ATOM    595  C   HIS A  76      29.543  12.483  -1.281  1.00 57.24           C  
ATOM    596  O   HIS A  76      29.824  13.651  -1.588  1.00 57.15           O  
ATOM    597  CB  HIS A  76      30.406  10.775  -2.928  1.00 59.61           C  
ATOM    598  CG  HIS A  76      31.366   9.656  -3.187  1.00 61.75           C  
ATOM    599  ND1 HIS A  76      32.733   9.836  -3.166  1.00 63.73           N  
ATOM    600  CD2 HIS A  76      31.163   8.336  -3.417  1.00 64.95           C  
ATOM    601  CE1 HIS A  76      33.331   8.680  -3.403  1.00 64.56           C  
ATOM    602  NE2 HIS A  76      32.401   7.753  -3.556  1.00 65.39           N  
ATOM    603  N   SER A  77      28.383  12.124  -0.717  1.00 55.01           N  
ATOM    604  CA  SER A  77      27.386  13.117  -0.352  1.00 52.81           C  
ATOM    605  C   SER A  77      28.051  14.335   0.299  1.00 50.88           C  
ATOM    606  O   SER A  77      28.865  14.197   1.209  1.00 51.51           O  
ATOM    607  CB  SER A  77      26.329  12.539   0.608  1.00 52.60           C  
ATOM    608  OG  SER A  77      25.532  11.516   0.012  1.00 51.47           O  
ATOM    609  N   ASN A  78      27.753  15.522  -0.217  1.00 47.69           N  
ATOM    610  CA  ASN A  78      27.727  16.720   0.624  1.00 44.73           C  
ATOM    611  C   ASN A  78      26.537  17.560   0.152  1.00 40.96           C  
ATOM    612  O   ASN A  78      26.371  17.918  -1.055  1.00 38.90           O  
ATOM    613  CB  ASN A  78      29.045  17.519   0.671  1.00 46.06           C  
ATOM    614  CG  ASN A  78      28.980  18.790   1.628  1.00 48.85           C  
ATOM    615  OD1 ASN A  78      29.475  19.868   1.274  1.00 51.61           O  
ATOM    616  ND2 ASN A  78      28.372  18.647   2.804  1.00 47.62           N  
ATOM    617  N   ILE A  79      25.706  17.817   1.163  1.00 35.45           N  
ATOM    618  CA  ILE A  79      24.458  18.525   1.047  1.00 29.87           C  
ATOM    619  C   ILE A  79      24.767  19.993   1.076  1.00 25.30           C  
ATOM    620  O   ILE A  79      25.500  20.454   1.895  1.00 24.46           O  
ATOM    621  CB  ILE A  79      23.529  18.100   2.208  1.00 29.12           C  
ATOM    622  CG1 ILE A  79      23.129  16.634   2.022  1.00 26.97           C  
ATOM    623  CG2 ILE A  79      22.319  18.989   2.275  1.00 30.18           C  
ATOM    624  CD1 ILE A  79      22.662  15.898   3.259  1.00 27.37           C  
ATOM    625  N   ASP A  80      24.197  20.724   0.155  1.00 23.75           N  
ATOM    626  CA  ASP A  80      24.384  22.156   0.079  1.00 23.75           C  
ATOM    627  C   ASP A  80      23.601  22.873   1.171  1.00 22.29           C  
ATOM    628  O   ASP A  80      24.109  23.782   1.852  1.00 20.48           O  
ATOM    629  CB  ASP A  80      23.941  22.610  -1.318  1.00 24.09           C  
ATOM    630  CG  ASP A  80      24.756  21.954  -2.413  1.00 25.89           C  
ATOM    631  OD1 ASP A  80      25.954  22.296  -2.472  1.00 31.49           O  
ATOM    632  OD2 ASP A  80      24.238  21.084  -3.191  1.00 21.79           O  
ATOM    633  N   ILE A  81      22.362  22.435   1.323  1.00 22.69           N  
ATOM    634  CA  ILE A  81      21.388  23.044   2.209  1.00 22.97           C  
ATOM    635  C   ILE A  81      20.463  21.985   2.788  1.00 21.68           C  
ATOM    636  O   ILE A  81      19.941  21.129   2.063  1.00 22.12           O  
ATOM    637  CB  ILE A  81      20.488  24.016   1.459  1.00 24.28           C  
ATOM    638  CG1 ILE A  81      21.269  25.257   1.021  1.00 26.86           C  
ATOM    639  CG2 ILE A  81      19.323  24.438   2.340  1.00 23.84           C  
ATOM    640  CD1 ILE A  81      20.530  26.075   0.077  1.00 26.84           C  
ATOM    641  N   THR A  82      20.266  22.030   4.091  1.00 20.38           N  
ATOM    642  CA  THR A  82      19.128  21.334   4.716  1.00 21.24           C  
ATOM    643  C   THR A  82      18.129  22.348   5.227  1.00 20.44           C  
ATOM    644  O   THR A  82      18.490  23.329   5.876  1.00 22.48           O  
ATOM    645  CB  THR A  82      19.533  20.354   5.878  1.00 21.53           C  
ATOM    646  OG1 THR A  82      20.265  19.225   5.347  1.00 25.36           O  
ATOM    647  CG2 THR A  82      18.348  19.831   6.603  1.00 20.05           C  
ATOM    648  N   ILE A  83      16.866  22.077   4.938  1.00 20.97           N  
ATOM    649  CA  ILE A  83      15.737  22.845   5.457  1.00 19.66           C  
ATOM    650  C   ILE A  83      14.909  21.939   6.352  1.00 18.09           C  
ATOM    651  O   ILE A  83      14.395  20.895   5.895  1.00 16.16           O  
ATOM    652  CB  ILE A  83      14.837  23.382   4.305  1.00 18.61           C  
ATOM    653  CG1 ILE A  83      15.708  24.052   3.228  1.00 21.30           C  
ATOM    654  CG2 ILE A  83      13.792  24.332   4.885  1.00 21.49           C  
ATOM    655  CD1 ILE A  83      14.970  24.539   1.967  1.00 19.91           C  
ATOM    656  N   ASP A  84      14.770  22.344   7.606  1.00 15.54           N  
ATOM    657  CA  ASP A  84      14.010  21.586   8.513  1.00 17.75           C  
ATOM    658  C   ASP A  84      13.200  22.543   9.438  1.00 16.70           C  
ATOM    659  O   ASP A  84      13.463  23.734   9.474  1.00 17.43           O  
ATOM    660  CB  ASP A  84      14.932  20.631   9.343  1.00 16.62           C  
ATOM    661  CG  ASP A  84      14.150  19.515  10.046  1.00 21.29           C  
ATOM    662  OD1 ASP A  84      12.897  19.409   9.893  1.00 23.95           O  
ATOM    663  OD2 ASP A  84      14.791  18.732  10.781  1.00 25.17           O  
ATOM    664  N   GLY A  85      12.260  21.983  10.198  1.00 16.41           N  
ATOM    665  CA  GLY A  85      11.547  22.731  11.242  1.00 16.51           C  
ATOM    666  C   GLY A  85      12.175  22.502  12.615  1.00 17.56           C  
ATOM    667  O   GLY A  85      13.229  21.874  12.754  1.00 19.11           O  
ATOM    668  N   THR A  86      11.534  23.012  13.650  1.00 20.28           N  
ATOM    669  CA  THR A  86      12.015  22.825  15.010  1.00 20.34           C  
ATOM    670  C   THR A  86      10.789  22.913  15.920  1.00 21.31           C  
ATOM    671  O   THR A  86       9.747  23.477  15.533  1.00 22.24           O  
ATOM    672  CB  THR A  86      13.119  23.880  15.335  1.00 21.61           C  
ATOM    673  OG1 THR A  86      13.658  23.717  16.662  1.00 21.26           O  
ATOM    674  CG2 THR A  86      12.551  25.286  15.211  1.00 19.10           C  
ATOM    675  N   ASP A  87      10.915  22.359  17.120  1.00 20.95           N  
ATOM    676  CA  ASP A  87       9.888  22.492  18.149  1.00 21.42           C  
ATOM    677  C   ASP A  87      10.150  23.760  19.000  1.00 21.71           C  
ATOM    678  O   ASP A  87       9.217  24.456  19.368  1.00 23.28           O  
ATOM    679  CB  ASP A  87       9.836  21.245  18.998  1.00 21.29           C  
ATOM    680  CG  ASP A  87       9.753  19.966  18.160  1.00 26.15           C  
ATOM    681  OD1 ASP A  87       9.028  19.959  17.159  1.00 31.95           O  
ATOM    682  OD2 ASP A  87      10.403  18.959  18.506  1.00 28.63           O  
ATOM    683  N   GLU A  88      11.405  24.067  19.292  1.00 21.14           N  
ATOM    684  CA  GLU A  88      11.753  25.411  19.788  1.00 22.17           C  
ATOM    685  C   GLU A  88      13.068  25.906  19.208  1.00 21.67           C  
ATOM    686  O   GLU A  88      13.927  25.113  18.794  1.00 20.47           O  
ATOM    687  CB  GLU A  88      11.885  25.483  21.309  1.00 21.66           C  
ATOM    688  CG  GLU A  88      10.997  24.558  22.155  1.00 24.31           C  
ATOM    689  CD  GLU A  88      11.378  24.636  23.659  1.00 26.90           C  
ATOM    690  OE1 GLU A  88      12.160  25.576  24.018  1.00 28.01           O  
ATOM    691  OE2 GLU A  88      10.895  23.778  24.464  1.00 30.77           O  
ATOM    692  N   ILE A  89      13.215  27.237  19.216  1.00 22.78           N  
ATOM    693  CA  ILE A  89      14.462  27.934  18.837  1.00 22.17           C  
ATOM    694  C   ILE A  89      14.613  29.207  19.675  1.00 23.15           C  
ATOM    695  O   ILE A  89      13.629  29.898  19.927  1.00 23.28           O  
ATOM    696  CB  ILE A  89      14.544  28.255  17.301  1.00 21.69           C  
ATOM    697  CG1 ILE A  89      15.831  28.918  16.972  1.00 20.70           C  
ATOM    698  CG2 ILE A  89      13.466  29.195  16.822  1.00 21.86           C  
ATOM    699  CD1 ILE A  89      16.023  29.101  15.508  1.00 22.22           C  
ATOM    700  N   ASP A  90      15.826  29.496  20.132  1.00 23.71           N  
ATOM    701  CA  ASP A  90      16.093  30.749  20.834  1.00 25.99           C  
ATOM    702  C   ASP A  90      16.836  31.717  19.936  1.00 26.24           C  
ATOM    703  O   ASP A  90      17.128  31.416  18.788  1.00 25.33           O  
ATOM    704  CB  ASP A  90      16.840  30.528  22.179  1.00 26.96           C  
ATOM    705  CG  ASP A  90      18.207  29.819  22.032  1.00 26.36           C  
ATOM    706  OD1 ASP A  90      18.789  29.731  20.943  1.00 31.57           O  
ATOM    707  OD2 ASP A  90      18.722  29.371  23.070  1.00 33.84           O  
ATOM    708  N   LEU A  91      17.100  32.903  20.462  1.00 28.42           N  
ATOM    709  CA  LEU A  91      17.811  33.946  19.702  1.00 29.37           C  
ATOM    710  C   LEU A  91      19.286  33.628  19.422  1.00 29.90           C  
ATOM    711  O   LEU A  91      19.873  34.219  18.523  1.00 30.00           O  
ATOM    712  CB  LEU A  91      17.664  35.309  20.399  1.00 28.93           C  
ATOM    713  CG  LEU A  91      16.236  35.863  20.248  1.00 28.67           C  
ATOM    714  CD1 LEU A  91      15.924  37.018  21.221  1.00 27.37           C  
ATOM    715  CD2 LEU A  91      16.001  36.277  18.804  1.00 30.27           C  
ATOM    716  N   ASN A  92      19.867  32.661  20.142  1.00 30.69           N  
ATOM    717  CA  ASN A  92      21.180  32.072  19.752  1.00 30.59           C  
ATOM    718  C   ASN A  92      21.101  31.018  18.661  1.00 28.92           C  
ATOM    719  O   ASN A  92      22.110  30.498  18.215  1.00 27.41           O  
ATOM    720  CB  ASN A  92      21.845  31.456  20.963  1.00 32.19           C  
ATOM    721  CG  ASN A  92      22.008  32.453  22.082  1.00 37.16           C  
ATOM    722  OD1 ASN A  92      22.935  33.279  22.059  1.00 39.00           O  
ATOM    723  ND2 ASN A  92      21.085  32.413  23.053  1.00 39.00           N  
ATOM    724  N   LEU A  93      19.881  30.685  18.270  1.00 28.59           N  
ATOM    725  CA  LEU A  93      19.584  29.752  17.186  1.00 28.69           C  
ATOM    726  C   LEU A  93      19.863  28.344  17.627  1.00 27.39           C  
ATOM    727  O   LEU A  93      20.168  27.481  16.839  1.00 28.88           O  
ATOM    728  CB  LEU A  93      20.337  30.094  15.884  1.00 29.52           C  
ATOM    729  CG  LEU A  93      20.054  31.485  15.264  1.00 31.57           C  
ATOM    730  CD1 LEU A  93      20.634  31.623  13.860  1.00 33.65           C  
ATOM    731  CD2 LEU A  93      18.570  31.796  15.192  1.00 34.90           C  
ATOM    732  N   ASN A  94      19.708  28.105  18.916  1.00 27.38           N  
ATOM    733  CA  ASN A  94      19.842  26.764  19.446  1.00 24.11           C  
ATOM    734  C   ASN A  94      18.456  26.222  19.405  1.00 22.81           C  
ATOM    735  O   ASN A  94      17.527  26.987  19.523  1.00 17.73           O  
ATOM    736  CB  ASN A  94      20.478  26.791  20.833  1.00 24.06           C  
ATOM    737  CG  ASN A  94      22.013  27.052  20.770  1.00 23.23           C  
ATOM    738  OD1 ASN A  94      22.724  26.599  19.853  1.00 22.89           O  
ATOM    739  ND2 ASN A  94      22.505  27.803  21.733  1.00 22.12           N  
ATOM    740  N   LEU A  95      18.331  24.917  19.144  1.00 21.47           N  
ATOM    741  CA  LEU A  95      17.034  24.270  18.865  1.00 20.34           C  
ATOM    742  C   LEU A  95      16.704  23.121  19.807  1.00 18.96           C  
ATOM    743  O   LEU A  95      17.586  22.388  20.239  1.00 14.69           O  
ATOM    744  CB  LEU A  95      16.996  23.660  17.459  1.00 19.55           C  
ATOM    745  CG  LEU A  95      17.697  24.404  16.322  1.00 17.81           C  
ATOM    746  CD1 LEU A  95      17.729  23.499  15.105  1.00 19.71           C  
ATOM    747  CD2 LEU A  95      16.980  25.643  15.985  1.00 20.66           C  
ATOM    748  N   ILE A  96      15.406  23.003  20.104  1.00 18.86           N  
ATOM    749  CA  ILE A  96      14.806  21.744  20.548  1.00 19.42           C  
ATOM    750  C   ILE A  96      13.966  21.133  19.444  1.00 19.55           C  
ATOM    751  O   ILE A  96      13.073  21.808  18.893  1.00 18.00           O  
ATOM    752  CB  ILE A  96      13.883  21.917  21.734  1.00 19.27           C  
ATOM    753  CG1 ILE A  96      14.627  22.497  22.925  1.00 22.13           C  
ATOM    754  CG2 ILE A  96      13.255  20.586  22.109  1.00 17.97           C  
ATOM    755  CD1 ILE A  96      15.648  21.627  23.558  1.00 26.30           C  
ATOM    756  N   LYS A  97      14.279  19.866  19.113  1.00 18.24           N  
ATOM    757  CA  LYS A  97      13.686  19.156  18.020  1.00 17.86           C  
ATOM    758  C   LYS A  97      13.285  17.743  18.428  1.00 21.20           C  
ATOM    759  O   LYS A  97      13.681  17.263  19.490  1.00 23.77           O  
ATOM    760  CB  LYS A  97      14.669  19.116  16.829  1.00 18.06           C  
ATOM    761  CG  LYS A  97      14.836  20.504  16.231  1.00 18.88           C  
ATOM    762  CD  LYS A  97      15.594  20.685  14.931  1.00 15.85           C  
ATOM    763  CE  LYS A  97      15.432  19.578  13.896  1.00 19.71           C  
ATOM    764  NZ  LYS A  97      14.163  19.594  13.155  1.00 18.46           N  
ATOM    765  N   GLY A  98      12.468  17.089  17.599  1.00 21.21           N  
ATOM    766  CA  GLY A  98      12.264  15.642  17.675  1.00 22.14           C  
ATOM    767  C   GLY A  98      10.899  15.166  18.114  1.00 21.46           C  
ATOM    768  O   GLY A  98      10.656  13.979  18.209  1.00 22.10           O  
ATOM    769  N   ARG A  99      10.005  16.093  18.383  1.00 23.01           N  
ATOM    770  CA  ARG A  99       8.650  15.751  18.762  1.00 24.49           C  
ATOM    771  C   ARG A  99       7.856  14.951  17.708  1.00 24.39           C  
ATOM    772  O   ARG A  99       6.879  14.321  18.066  1.00 23.24           O  
ATOM    773  CB  ARG A  99       7.907  17.015  19.153  1.00 25.27           C  
ATOM    774  CG  ARG A  99       8.418  17.502  20.506  1.00 27.05           C  
ATOM    775  CD  ARG A  99       7.761  18.767  20.961  1.00 25.67           C  
ATOM    776  NE  ARG A  99       8.623  19.466  21.886  1.00 23.99           N  
ATOM    777  CZ  ARG A  99       8.398  20.689  22.331  1.00 28.37           C  
ATOM    778  NH1 ARG A  99       7.323  21.353  21.912  1.00 32.68           N  
ATOM    779  NH2 ARG A  99       9.260  21.257  23.170  1.00 28.42           N  
ATOM    780  N   GLY A 100       8.279  14.981  16.447  1.00 24.68           N  
ATOM    781  CA  GLY A 100       7.668  14.152  15.413  1.00 24.83           C  
ATOM    782  C   GLY A 100       8.429  12.846  15.254  1.00 25.39           C  
ATOM    783  O   GLY A 100       8.109  12.029  14.375  1.00 24.53           O  
ATOM    784  N   GLY A 101       9.472  12.674  16.078  1.00 25.01           N  
ATOM    785  CA  GLY A 101      10.192  11.395  16.185  1.00 24.46           C  
ATOM    786  C   GLY A 101      11.411  11.224  15.302  1.00 23.81           C  
ATOM    787  O   GLY A 101      12.011  10.144  15.302  1.00 25.54           O  
ATOM    788  N   ALA A 102      11.826  12.280  14.595  1.00 24.14           N  
ATOM    789  CA  ALA A 102      12.889  12.164  13.578  1.00 24.06           C  
ATOM    790  C   ALA A 102      14.224  12.770  13.925  1.00 22.78           C  
ATOM    791  O   ALA A 102      15.066  12.889  13.052  1.00 25.86           O  
ATOM    792  CB  ALA A 102      12.415  12.793  12.282  1.00 24.96           C  
ATOM    793  N   LEU A 103      14.427  13.131  15.176  1.00 21.28           N  
ATOM    794  CA  LEU A 103      15.653  13.835  15.620  1.00 20.69           C  
ATOM    795  C   LEU A 103      16.994  13.232  15.206  1.00 18.99           C  
ATOM    796  O   LEU A 103      17.937  13.977  14.976  1.00 16.65           O  
ATOM    797  CB  LEU A 103      15.685  13.978  17.140  1.00 19.63           C  
ATOM    798  CG  LEU A 103      15.645  12.709  18.006  1.00 20.53           C  
ATOM    799  CD1 LEU A 103      16.359  13.010  19.267  1.00 20.90           C  
ATOM    800  CD2 LEU A 103      14.222  12.240  18.309  1.00 21.14           C  
ATOM    801  N   VAL A 104      17.139  11.911  15.194  1.00 20.11           N  
ATOM    802  CA  VAL A 104      18.500  11.363  14.981  1.00 19.97           C  
ATOM    803  C   VAL A 104      18.979  11.610  13.511  1.00 20.86           C  
ATOM    804  O   VAL A 104      20.101  12.062  13.263  1.00 22.95           O  
ATOM    805  CB  VAL A 104      18.660   9.824  15.391  1.00 21.36           C  
ATOM    806  CG1 VAL A 104      20.071   9.341  15.116  1.00 21.18           C  
ATOM    807  CG2 VAL A 104      18.405   9.590  16.839  1.00 21.58           C  
ATOM    808  N   ARG A 105      18.151  11.239  12.543  1.00 21.15           N  
ATOM    809  CA  ARG A 105      18.475  11.420  11.132  1.00 20.86           C  
ATOM    810  C   ARG A 105      18.419  12.922  10.773  1.00 21.04           C  
ATOM    811  O   ARG A 105      19.172  13.390   9.894  1.00 21.32           O  
ATOM    812  CB  ARG A 105      17.535  10.588  10.242  1.00 21.62           C  
ATOM    813  CG  ARG A 105      17.660   9.081  10.445  1.00 18.29           C  
ATOM    814  CD  ARG A 105      16.709   8.384   9.601  1.00 16.94           C  
ATOM    815  NE  ARG A 105      16.811   6.935   9.705  1.00 18.56           N  
ATOM    816  CZ  ARG A 105      16.255   6.069   8.866  1.00 19.50           C  
ATOM    817  NH1 ARG A 105      15.586   6.459   7.810  1.00 16.97           N  
ATOM    818  NH2 ARG A 105      16.437   4.783   9.060  1.00 24.88           N  
ATOM    819  N   GLU A 106      17.568  13.692  11.446  1.00 20.08           N  
ATOM    820  CA  GLU A 106      17.679  15.168  11.291  1.00 20.53           C  
ATOM    821  C   GLU A 106      19.045  15.720  11.686  1.00 20.97           C  
ATOM    822  O   GLU A 106      19.593  16.570  10.990  1.00 22.97           O  
ATOM    823  CB  GLU A 106      16.585  15.886  12.083  1.00 21.20           C  
ATOM    824  CG  GLU A 106      15.241  15.682  11.463  1.00 21.13           C  
ATOM    825  CD  GLU A 106      14.096  16.145  12.334  1.00 26.15           C  
ATOM    826  OE1 GLU A 106      14.257  16.460  13.547  1.00 25.79           O  
ATOM    827  OE2 GLU A 106      12.998  16.192  11.768  1.00 35.29           O  
ATOM    828  N   LYS A 107      19.625  15.270  12.804  1.00 22.30           N  
ATOM    829  CA  LYS A 107      20.945  15.796  13.210  1.00 20.09           C  
ATOM    830  C   LYS A 107      22.044  15.333  12.245  1.00 18.26           C  
ATOM    831  O   LYS A 107      22.946  16.103  11.867  1.00 16.47           O  
ATOM    832  CB  LYS A 107      21.297  15.399  14.641  1.00 20.80           C  
ATOM    833  CG  LYS A 107      22.375  16.268  15.289  1.00 20.19           C  
ATOM    834  CD  LYS A 107      22.619  15.851  16.737  1.00 22.06           C  
ATOM    835  CE  LYS A 107      21.608  16.470  17.774  1.00 23.34           C  
ATOM    836  NZ  LYS A 107      21.929  16.116  19.193  1.00 20.79           N  
ATOM    837  N   LEU A 108      21.965  14.089  11.823  1.00 17.36           N  
ATOM    838  CA  LEU A 108      22.989  13.555  10.934  1.00 17.02           C  
ATOM    839  C   LEU A 108      23.020  14.250   9.593  1.00 17.06           C  
ATOM    840  O   LEU A 108      24.057  14.649   9.114  1.00 16.10           O  
ATOM    841  CB  LEU A 108      22.758  12.059  10.719  1.00 19.83           C  
ATOM    842  CG  LEU A 108      23.865  11.310   9.941  1.00 20.97           C  
ATOM    843  CD1 LEU A 108      25.237  11.353  10.617  1.00 25.43           C  
ATOM    844  CD2 LEU A 108      23.449   9.869   9.753  1.00 18.71           C  
ATOM    845  N   VAL A 109      21.852  14.420   8.995  1.00 18.50           N  
ATOM    846  CA  VAL A 109      21.731  15.143   7.752  1.00 20.02           C  
ATOM    847  C   VAL A 109      22.093  16.609   7.933  1.00 20.05           C  
ATOM    848  O   VAL A 109      22.780  17.173   7.110  1.00 21.84           O  
ATOM    849  CB  VAL A 109      20.284  15.009   7.174  1.00 21.55           C  
ATOM    850  CG1 VAL A 109      20.118  15.850   5.975  1.00 22.86           C  
ATOM    851  CG2 VAL A 109      20.014  13.575   6.834  1.00 21.70           C  
ATOM    852  N   ALA A 110      21.664  17.233   9.007  1.00 21.12           N  
ATOM    853  CA  ALA A 110      21.973  18.664   9.192  1.00 23.12           C  
ATOM    854  C   ALA A 110      23.466  18.895   9.411  1.00 24.41           C  
ATOM    855  O   ALA A 110      24.051  19.855   8.904  1.00 26.83           O  
ATOM    856  CB  ALA A 110      21.186  19.231  10.335  1.00 22.08           C  
ATOM    857  N   SER A 111      24.100  18.019  10.159  1.00 26.09           N  
ATOM    858  CA  SER A 111      25.517  18.176  10.376  1.00 27.08           C  
ATOM    859  C   SER A 111      26.265  17.872   9.103  1.00 26.48           C  
ATOM    860  O   SER A 111      27.397  18.299   8.955  1.00 26.13           O  
ATOM    861  CB  SER A 111      25.988  17.287  11.520  1.00 28.22           C  
ATOM    862  OG  SER A 111      25.664  15.936  11.205  1.00 34.24           O  
ATOM    863  N   SER A 112      25.631  17.173   8.158  1.00 27.09           N  
ATOM    864  CA  SER A 112      26.292  16.797   6.903  1.00 27.05           C  
ATOM    865  C   SER A 112      26.129  17.853   5.782  1.00 25.83           C  
ATOM    866  O   SER A 112      26.573  17.639   4.646  1.00 24.27           O  
ATOM    867  CB  SER A 112      25.760  15.427   6.417  1.00 28.73           C  
ATOM    868  OG  SER A 112      25.939  14.408   7.424  1.00 29.97           O  
ATOM    869  N   SER A 113      25.500  18.977   6.111  1.00 25.77           N  
ATOM    870  CA  SER A 113      25.134  20.022   5.117  1.00 25.20           C  
ATOM    871  C   SER A 113      25.969  21.267   5.289  1.00 24.08           C  
ATOM    872  O   SER A 113      26.366  21.571   6.401  1.00 23.06           O  
ATOM    873  CB  SER A 113      23.667  20.426   5.273  1.00 23.98           C  
ATOM    874  OG  SER A 113      22.866  19.306   5.538  1.00 28.06           O  
ATOM    875  N   SER A 114      26.193  22.016   4.206  1.00 24.93           N  
ATOM    876  CA  SER A 114      26.933  23.266   4.297  1.00 26.32           C  
ATOM    877  C   SER A 114      26.097  24.322   5.005  1.00 28.34           C  
ATOM    878  O   SER A 114      26.625  25.236   5.627  1.00 29.77           O  
ATOM    879  CB  SER A 114      27.312  23.820   2.913  1.00 27.08           C  
ATOM    880  OG  SER A 114      27.963  22.864   2.109  1.00 31.35           O  
ATOM    881  N   LEU A 115      24.786  24.186   4.896  1.00 28.18           N  
ATOM    882  CA  LEU A 115      23.867  25.167   5.413  1.00 28.23           C  
ATOM    883  C   LEU A 115      22.625  24.499   6.027  1.00 25.69           C  
ATOM    884  O   LEU A 115      21.981  23.627   5.421  1.00 23.12           O  
ATOM    885  CB  LEU A 115      23.455  26.103   4.289  1.00 30.07           C  
ATOM    886  CG  LEU A 115      23.347  27.570   4.682  1.00 33.55           C  
ATOM    887  CD1 LEU A 115      24.650  28.286   4.321  1.00 37.32           C  
ATOM    888  CD2 LEU A 115      22.156  28.205   4.004  1.00 33.34           C  
ATOM    889  N   LEU A 116      22.332  24.878   7.256  1.00 23.63           N  
ATOM    890  CA  LEU A 116      21.092  24.492   7.885  1.00 23.10           C  
ATOM    891  C   LEU A 116      20.193  25.676   8.035  1.00 22.23           C  
ATOM    892  O   LEU A 116      20.493  26.611   8.760  1.00 22.85           O  
ATOM    893  CB  LEU A 116      21.323  23.917   9.282  1.00 24.27           C  
ATOM    894  CG  LEU A 116      20.099  23.301   9.969  1.00 21.92           C  
ATOM    895  CD1 LEU A 116      19.594  22.053   9.219  1.00 19.55           C  
ATOM    896  CD2 LEU A 116      20.450  22.998  11.416  1.00 19.57           C  
ATOM    897  N   ILE A 117      19.061  25.602   7.358  1.00 22.98           N  
ATOM    898  CA  ILE A 117      17.997  26.564   7.498  1.00 22.82           C  
ATOM    899  C   ILE A 117      16.869  25.949   8.283  1.00 22.17           C  
ATOM    900  O   ILE A 117      16.366  24.898   7.945  1.00 19.54           O  
ATOM    901  CB  ILE A 117      17.513  26.959   6.132  1.00 24.57           C  
ATOM    902  CG1 ILE A 117      18.727  27.448   5.319  1.00 22.62           C  
ATOM    903  CG2 ILE A 117      16.420  28.013   6.240  1.00 25.27           C  
ATOM    904  CD1 ILE A 117      18.371  27.674   3.917  1.00 22.36           C  
ATOM    905  N   ILE A 118      16.527  26.625   9.369  1.00 23.30           N  
ATOM    906  CA  ILE A 118      15.441  26.211  10.237  1.00 23.40           C  
ATOM    907  C   ILE A 118      14.339  27.191   9.993  1.00 22.29           C  
ATOM    908  O   ILE A 118      14.563  28.419   9.999  1.00 21.43           O  
ATOM    909  CB  ILE A 118      15.845  26.202  11.742  1.00 22.66           C  
ATOM    910  CG1 ILE A 118      16.914  25.131  11.951  1.00 22.22           C  
ATOM    911  CG2 ILE A 118      14.622  25.994  12.695  1.00 21.92           C  
ATOM    912  CD1 ILE A 118      16.415  23.765  11.730  1.00 19.91           C  
ATOM    913  N   ILE A 119      13.159  26.611   9.772  1.00 22.00           N  
ATOM    914  CA  ILE A 119      11.946  27.334   9.443  1.00 20.61           C  
ATOM    915  C   ILE A 119      10.850  27.067  10.502  1.00 21.43           C  
ATOM    916  O   ILE A 119      10.672  25.949  11.009  1.00 21.11           O  
ATOM    917  CB  ILE A 119      11.447  27.013   7.970  1.00 21.03           C  
ATOM    918  CG1 ILE A 119      11.124  25.537   7.758  1.00 21.40           C  
ATOM    919  CG2 ILE A 119      12.487  27.349   6.991  1.00 22.20           C  
ATOM    920  CD1 ILE A 119      10.511  25.198   6.368  1.00 16.53           C  
ATOM    921  N   GLY A 120      10.123  28.123  10.827  1.00 21.49           N  
ATOM    922  CA  GLY A 120       9.059  28.047  11.793  1.00 24.11           C  
ATOM    923  C   GLY A 120       8.124  29.252  11.820  1.00 24.09           C  
ATOM    924  O   GLY A 120       8.449  30.354  11.371  1.00 22.70           O  
ATOM    925  N   ASP A 121       6.962  29.022  12.396  1.00 27.06           N  
ATOM    926  CA  ASP A 121       6.040  30.104  12.687  1.00 29.96           C  
ATOM    927  C   ASP A 121       6.475  30.685  14.043  1.00 30.83           C  
ATOM    928  O   ASP A 121       7.288  30.064  14.756  1.00 29.97           O  
ATOM    929  CB  ASP A 121       4.592  29.604  12.669  1.00 30.84           C  
ATOM    930  CG  ASP A 121       4.256  28.767  13.866  1.00 33.35           C  
ATOM    931  OD1 ASP A 121       4.033  29.355  14.959  1.00 37.55           O  
ATOM    932  OD2 ASP A 121       4.230  27.529  13.720  1.00 37.30           O  
ATOM    933  N   GLU A 122       5.991  31.890  14.383  1.00 31.31           N  
ATOM    934  CA  GLU A 122       6.543  32.576  15.542  1.00 31.71           C  
ATOM    935  C   GLU A 122       6.308  31.866  16.892  1.00 30.92           C  
ATOM    936  O   GLU A 122       6.926  32.252  17.885  1.00 30.79           O  
ATOM    937  CB  GLU A 122       6.015  34.005  15.637  1.00 32.84           C  
ATOM    938  CG  GLU A 122       4.625  34.176  16.172  1.00 35.95           C  
ATOM    939  CD  GLU A 122       4.375  35.631  16.565  1.00 41.53           C  
ATOM    940  OE1 GLU A 122       4.765  36.548  15.807  1.00 39.42           O  
ATOM    941  OE2 GLU A 122       3.802  35.850  17.655  1.00 44.73           O  
ATOM    942  N   SER A 123       5.435  30.872  16.969  1.00 29.77           N  
ATOM    943  CA  SER A 123       5.321  30.146  18.229  1.00 29.43           C  
ATOM    944  C   SER A 123       6.551  29.259  18.546  1.00 29.63           C  
ATOM    945  O   SER A 123       6.742  28.828  19.696  1.00 28.33           O  
ATOM    946  CB  SER A 123       4.013  29.318  18.290  1.00 29.79           C  
ATOM    947  OG  SER A 123       3.879  28.420  17.223  1.00 31.89           O  
ATOM    948  N   LYS A 124       7.389  28.972  17.553  1.00 28.59           N  
ATOM    949  CA  LYS A 124       8.598  28.206  17.846  1.00 29.16           C  
ATOM    950  C   LYS A 124       9.701  29.045  18.543  1.00 30.00           C  
ATOM    951  O   LYS A 124      10.614  28.477  19.177  1.00 25.94           O  
ATOM    952  CB  LYS A 124       9.155  27.555  16.572  1.00 29.36           C  
ATOM    953  CG  LYS A 124       8.099  26.806  15.744  1.00 26.81           C  
ATOM    954  CD  LYS A 124       7.251  25.892  16.532  1.00 19.54           C  
ATOM    955  CE  LYS A 124       6.374  25.091  15.601  1.00 24.98           C  
ATOM    956  NZ  LYS A 124       7.168  24.316  14.548  1.00 23.67           N  
ATOM    957  N   LEU A 125       9.581  30.380  18.472  1.00 31.55           N  
ATOM    958  CA  LEU A 125      10.641  31.271  18.969  1.00 33.10           C  
ATOM    959  C   LEU A 125      10.493  31.509  20.457  1.00 35.55           C  
ATOM    960  O   LEU A 125       9.491  32.104  20.908  1.00 34.94           O  
ATOM    961  CB  LEU A 125      10.660  32.595  18.210  1.00 34.03           C  
ATOM    962  CG  LEU A 125      11.989  33.359  18.344  1.00 37.19           C  
ATOM    963  CD1 LEU A 125      13.132  32.685  17.629  1.00 37.93           C  
ATOM    964  CD2 LEU A 125      11.843  34.774  17.809  1.00 40.72           C  
ATOM    965  N   CYS A 126      11.497  31.009  21.204  1.00 36.92           N  
ATOM    966  CA  CYS A 126      11.525  30.997  22.687  1.00 38.28           C  
ATOM    967  C   CYS A 126      12.634  31.860  23.218  1.00 39.99           C  
ATOM    968  O   CYS A 126      13.790  31.422  23.224  1.00 41.61           O  
ATOM    969  CB  CYS A 126      11.774  29.579  23.213  1.00 37.40           C  
ATOM    970  SG  CYS A 126      10.495  28.387  22.745  1.00 36.47           S  
ATOM    971  N   THR A 127      12.294  33.059  23.700  1.00 40.72           N  
ATOM    972  CA  THR A 127      13.300  34.087  24.056  1.00 41.51           C  
ATOM    973  C   THR A 127      13.632  34.165  25.564  1.00 41.56           C  
ATOM    974  O   THR A 127      14.568  34.855  25.972  1.00 41.14           O  
ATOM    975  CB  THR A 127      12.844  35.476  23.549  1.00 42.27           C  
ATOM    976  OG1 THR A 127      11.627  35.856  24.208  1.00 42.76           O  
ATOM    977  CG2 THR A 127      12.643  35.444  22.004  1.00 42.66           C  
ATOM    978  N   ASN A 128      12.884  33.412  26.366  1.00 41.82           N  
ATOM    979  CA  ASN A 128      13.125  33.288  27.791  1.00 42.17           C  
ATOM    980  C   ASN A 128      13.571  31.882  28.234  1.00 40.22           C  
ATOM    981  O   ASN A 128      13.043  31.351  29.216  1.00 40.47           O  
ATOM    982  CB  ASN A 128      11.854  33.685  28.539  1.00 42.89           C  
ATOM    983  CG  ASN A 128      11.633  35.196  28.567  1.00 49.06           C  
ATOM    984  OD1 ASN A 128      12.279  35.964  27.826  1.00 55.12           O  
ATOM    985  ND2 ASN A 128      10.711  35.636  29.427  1.00 51.69           N  
ATOM    986  N   GLY A 129      14.536  31.285  27.523  1.00 38.82           N  
ATOM    987  CA  GLY A 129      15.082  29.975  27.893  1.00 37.68           C  
ATOM    988  C   GLY A 129      14.476  28.736  27.211  1.00 37.57           C  
ATOM    989  O   GLY A 129      13.248  28.572  27.158  1.00 38.88           O  
ATOM    990  N   LEU A 130      15.363  27.857  26.713  1.00 35.14           N  
ATOM    991  CA  LEU A 130      15.007  26.633  26.017  1.00 34.11           C  
ATOM    992  C   LEU A 130      14.570  25.544  26.954  1.00 33.67           C  
ATOM    993  O   LEU A 130      15.151  25.374  28.011  1.00 33.22           O  
ATOM    994  CB  LEU A 130      16.209  26.057  25.256  1.00 33.69           C  
ATOM    995  CG  LEU A 130      16.475  26.382  23.781  1.00 35.69           C  
ATOM    996  CD1 LEU A 130      17.663  25.539  23.310  1.00 34.66           C  
ATOM    997  CD2 LEU A 130      15.253  26.179  22.840  1.00 34.39           C  
ATOM    998  N   GLY A 131      13.577  24.778  26.530  1.00 33.84           N  
ATOM    999  CA  GLY A 131      13.244  23.498  27.144  1.00 34.92           C  
ATOM   1000  C   GLY A 131      11.936  23.493  27.910  1.00 36.04           C  
ATOM   1001  O   GLY A 131      11.538  22.472  28.485  1.00 37.04           O  
ATOM   1002  N   MET A 132      11.226  24.605  27.905  1.00 37.03           N  
ATOM   1003  CA  MET A 132      10.042  24.686  28.749  1.00 38.37           C  
ATOM   1004  C   MET A 132       8.690  24.483  28.056  1.00 37.07           C  
ATOM   1005  O   MET A 132       7.663  24.370  28.741  1.00 37.48           O  
ATOM   1006  CB  MET A 132      10.053  26.018  29.459  1.00 39.20           C  
ATOM   1007  CG  MET A 132      11.146  26.090  30.487  1.00 40.77           C  
ATOM   1008  SD  MET A 132      11.040  27.668  31.334  1.00 42.70           S  
ATOM   1009  CE  MET A 132      11.406  28.859  30.010  1.00 44.38           C  
ATOM   1010  N   THR A 133       8.641  24.466  26.730  1.00 35.76           N  
ATOM   1011  CA  THR A 133       7.327  24.365  26.078  1.00 34.18           C  
ATOM   1012  C   THR A 133       6.846  22.935  25.898  1.00 33.02           C  
ATOM   1013  O   THR A 133       5.732  22.720  25.441  1.00 34.37           O  
ATOM   1014  CB  THR A 133       7.319  24.974  24.672  1.00 34.24           C  
ATOM   1015  OG1 THR A 133       8.146  24.171  23.827  1.00 35.18           O  
ATOM   1016  CG2 THR A 133       7.803  26.415  24.698  1.00 32.85           C  
ATOM   1017  N   GLY A 134       7.680  21.947  26.198  1.00 30.61           N  
ATOM   1018  CA  GLY A 134       7.291  20.572  25.928  1.00 28.07           C  
ATOM   1019  C   GLY A 134       8.455  19.608  25.973  1.00 25.53           C  
ATOM   1020  O   GLY A 134       9.418  19.823  26.678  1.00 23.52           O  
ATOM   1021  N   ALA A 135       8.334  18.540  25.202  1.00 24.20           N  
ATOM   1022  CA  ALA A 135       9.220  17.411  25.323  1.00 24.32           C  
ATOM   1023  C   ALA A 135      10.585  17.788  24.806  1.00 23.41           C  
ATOM   1024  O   ALA A 135      10.707  18.523  23.809  1.00 23.13           O  
ATOM   1025  CB  ALA A 135       8.651  16.202  24.558  1.00 25.62           C  
ATOM   1026  N   VAL A 136      11.606  17.340  25.542  1.00 21.09           N  
ATOM   1027  CA  VAL A 136      12.984  17.328  25.067  1.00 20.71           C  
ATOM   1028  C   VAL A 136      13.280  15.863  24.810  1.00 19.26           C  
ATOM   1029  O   VAL A 136      13.378  15.102  25.767  1.00 18.24           O  
ATOM   1030  CB  VAL A 136      13.979  17.902  26.098  1.00 20.88           C  
ATOM   1031  CG1 VAL A 136      15.390  17.856  25.544  1.00 18.68           C  
ATOM   1032  CG2 VAL A 136      13.579  19.351  26.521  1.00 23.42           C  
ATOM   1033  N   PRO A 137      13.279  15.435  23.529  1.00 18.90           N  
ATOM   1034  CA  PRO A 137      13.369  13.984  23.274  1.00 18.47           C  
ATOM   1035  C   PRO A 137      14.776  13.416  23.301  1.00 17.46           C  
ATOM   1036  O   PRO A 137      15.710  14.099  22.930  1.00 17.53           O  
ATOM   1037  CB  PRO A 137      12.833  13.837  21.859  1.00 17.56           C  
ATOM   1038  CG  PRO A 137      12.401  15.186  21.413  1.00 19.25           C  
ATOM   1039  CD  PRO A 137      13.104  16.169  22.274  1.00 19.91           C  
ATOM   1040  N   ILE A 138      14.882  12.150  23.677  1.00 18.65           N  
ATOM   1041  CA  ILE A 138      16.146  11.437  23.695  1.00 19.20           C  
ATOM   1042  C   ILE A 138      15.840  10.035  23.176  1.00 19.15           C  
ATOM   1043  O   ILE A 138      14.929   9.359  23.668  1.00 17.70           O  
ATOM   1044  CB  ILE A 138      16.791  11.405  25.107  1.00 20.30           C  
ATOM   1045  CG1 ILE A 138      16.848  12.794  25.720  1.00 20.07           C  
ATOM   1046  CG2 ILE A 138      18.228  10.821  25.063  1.00 22.92           C  
ATOM   1047  CD1 ILE A 138      17.351  12.831  27.144  1.00 19.53           C  
ATOM   1048  N   GLU A 139      16.564   9.645  22.134  1.00 18.75           N  
ATOM   1049  CA  GLU A 139      16.398   8.357  21.491  1.00 17.52           C  
ATOM   1050  C   GLU A 139      17.307   7.355  22.181  1.00 17.43           C  
ATOM   1051  O   GLU A 139      18.495   7.592  22.346  1.00 15.74           O  
ATOM   1052  CB  GLU A 139      16.717   8.456  20.010  1.00 17.79           C  
ATOM   1053  CG  GLU A 139      16.355   7.211  19.240  1.00 18.48           C  
ATOM   1054  CD  GLU A 139      16.028   7.479  17.834  1.00 23.64           C  
ATOM   1055  OE1 GLU A 139      15.579   8.644  17.598  1.00 23.84           O  
ATOM   1056  OE2 GLU A 139      16.208   6.539  16.975  1.00 25.02           O  
ATOM   1057  N   ILE A 140      16.709   6.260  22.628  1.00 17.74           N  
ATOM   1058  CA  ILE A 140      17.392   5.254  23.466  1.00 17.86           C  
ATOM   1059  C   ILE A 140      17.036   3.922  22.957  1.00 18.56           C  
ATOM   1060  O   ILE A 140      15.998   3.772  22.306  1.00 18.46           O  
ATOM   1061  CB  ILE A 140      16.954   5.342  24.971  1.00 17.37           C  
ATOM   1062  CG1 ILE A 140      15.434   5.156  25.101  1.00 18.89           C  
ATOM   1063  CG2 ILE A 140      17.426   6.678  25.574  1.00 17.50           C  
ATOM   1064  CD1 ILE A 140      14.848   5.209  26.498  1.00 17.46           C  
ATOM   1065  N   LEU A 141      17.870   2.933  23.278  1.00 20.77           N  
ATOM   1066  CA  LEU A 141      17.600   1.575  22.898  1.00 22.51           C  
ATOM   1067  C   LEU A 141      16.357   1.031  23.581  1.00 21.84           C  
ATOM   1068  O   LEU A 141      16.061   1.339  24.717  1.00 20.51           O  
ATOM   1069  CB  LEU A 141      18.759   0.636  23.285  1.00 23.81           C  
ATOM   1070  CG  LEU A 141      20.178   0.951  22.862  1.00 28.15           C  
ATOM   1071  CD1 LEU A 141      21.055  -0.072  23.529  1.00 31.45           C  
ATOM   1072  CD2 LEU A 141      20.375   0.955  21.330  1.00 27.83           C  
ATOM   1073  N   THR A 142      15.692   0.130  22.883  1.00 23.40           N  
ATOM   1074  CA  THR A 142      14.594  -0.638  23.455  1.00 22.06           C  
ATOM   1075  C   THR A 142      15.114  -1.586  24.534  1.00 20.35           C  
ATOM   1076  O   THR A 142      14.504  -1.763  25.582  1.00 18.55           O  
ATOM   1077  CB  THR A 142      13.889  -1.454  22.342  1.00 23.16           C  
ATOM   1078  OG1 THR A 142      14.753  -2.518  21.888  1.00 25.25           O  
ATOM   1079  CG2 THR A 142      13.517  -0.544  21.151  1.00 18.46           C  
ATOM   1080  N   PHE A 143      16.266  -2.195  24.294  1.00 19.68           N  
ATOM   1081  CA  PHE A 143      16.790  -3.088  25.264  1.00 18.98           C  
ATOM   1082  C   PHE A 143      17.284  -2.306  26.458  1.00 19.54           C  
ATOM   1083  O   PHE A 143      18.167  -1.458  26.299  1.00 17.74           O  
ATOM   1084  CB  PHE A 143      17.939  -3.926  24.705  1.00 20.98           C  
ATOM   1085  CG  PHE A 143      18.556  -4.830  25.727  1.00 19.57           C  
ATOM   1086  CD1 PHE A 143      18.045  -6.109  25.933  1.00 22.65           C  
ATOM   1087  CD2 PHE A 143      19.618  -4.387  26.519  1.00 22.49           C  
ATOM   1088  CE1 PHE A 143      18.644  -6.925  26.871  1.00 22.53           C  
ATOM   1089  CE2 PHE A 143      20.187  -5.199  27.478  1.00 20.02           C  
ATOM   1090  CZ  PHE A 143      19.714  -6.454  27.648  1.00 21.27           C  
ATOM   1091  N   GLY A 144      16.692  -2.603  27.629  1.00 19.53           N  
ATOM   1092  CA  GLY A 144      17.015  -1.957  28.902  1.00 21.09           C  
ATOM   1093  C   GLY A 144      16.691  -0.479  29.071  1.00 21.20           C  
ATOM   1094  O   GLY A 144      17.348   0.205  29.843  1.00 21.59           O  
ATOM   1095  N   TYR A 145      15.656  -0.007  28.390  1.00 21.94           N  
ATOM   1096  CA  TYR A 145      15.345   1.426  28.305  1.00 21.98           C  
ATOM   1097  C   TYR A 145      15.039   2.085  29.639  1.00 21.52           C  
ATOM   1098  O   TYR A 145      15.372   3.255  29.838  1.00 21.79           O  
ATOM   1099  CB  TYR A 145      14.216   1.672  27.293  1.00 22.92           C  
ATOM   1100  CG  TYR A 145      12.845   1.275  27.749  1.00 25.77           C  
ATOM   1101  CD1 TYR A 145      12.414  -0.076  27.688  1.00 26.99           C  
ATOM   1102  CD2 TYR A 145      11.966   2.236  28.223  1.00 22.84           C  
ATOM   1103  CE1 TYR A 145      11.144  -0.455  28.125  1.00 28.45           C  
ATOM   1104  CE2 TYR A 145      10.694   1.886  28.646  1.00 28.66           C  
ATOM   1105  CZ  TYR A 145      10.276   0.534  28.598  1.00 30.06           C  
ATOM   1106  OH  TYR A 145       9.001   0.198  29.036  1.00 30.00           O  
ATOM   1107  N   GLU A 146      14.450   1.360  30.572  1.00 21.37           N  
ATOM   1108  CA  GLU A 146      14.173   1.942  31.877  1.00 22.25           C  
ATOM   1109  C   GLU A 146      15.418   2.157  32.673  1.00 19.72           C  
ATOM   1110  O   GLU A 146      15.490   3.079  33.446  1.00 17.67           O  
ATOM   1111  CB  GLU A 146      13.241   1.045  32.698  1.00 24.42           C  
ATOM   1112  CG  GLU A 146      11.934   0.666  31.967  1.00 32.82           C  
ATOM   1113  CD  GLU A 146      10.735   1.473  32.441  1.00 42.56           C  
ATOM   1114  OE1 GLU A 146      10.880   2.707  32.701  1.00 47.76           O  
ATOM   1115  OE2 GLU A 146       9.642   0.860  32.555  1.00 50.92           O  
ATOM   1116  N   LYS A 147      16.407   1.296  32.491  1.00 20.66           N  
ATOM   1117  CA  LYS A 147      17.676   1.456  33.160  1.00 20.01           C  
ATOM   1118  C   LYS A 147      18.394   2.684  32.560  1.00 20.18           C  
ATOM   1119  O   LYS A 147      18.936   3.519  33.262  1.00 19.97           O  
ATOM   1120  CB  LYS A 147      18.497   0.166  33.035  1.00 21.42           C  
ATOM   1121  CG  LYS A 147      19.934   0.274  33.500  1.00 23.60           C  
ATOM   1122  CD  LYS A 147      20.084   0.901  34.937  1.00 26.68           C  
ATOM   1123  CE  LYS A 147      19.787  -0.084  36.038  1.00 29.05           C  
ATOM   1124  NZ  LYS A 147      20.391   0.412  37.323  1.00 35.23           N  
ATOM   1125  N   ILE A 148      18.305   2.824  31.248  1.00 21.48           N  
ATOM   1126  CA  ILE A 148      18.899   3.966  30.552  1.00 20.11           C  
ATOM   1127  C   ILE A 148      18.265   5.235  31.072  1.00 19.67           C  
ATOM   1128  O   ILE A 148      18.965   6.184  31.370  1.00 20.73           O  
ATOM   1129  CB  ILE A 148      18.720   3.849  29.018  1.00 19.15           C  
ATOM   1130  CG1 ILE A 148      19.445   2.603  28.500  1.00 18.24           C  
ATOM   1131  CG2 ILE A 148      19.256   5.059  28.317  1.00 18.95           C  
ATOM   1132  CD1 ILE A 148      18.979   2.170  27.188  1.00 21.34           C  
ATOM   1133  N   ILE A 149      16.942   5.249  31.201  1.00 20.07           N  
ATOM   1134  CA  ILE A 149      16.272   6.440  31.751  1.00 19.92           C  
ATOM   1135  C   ILE A 149      16.748   6.797  33.175  1.00 19.37           C  
ATOM   1136  O   ILE A 149      17.029   7.981  33.460  1.00 15.95           O  
ATOM   1137  CB  ILE A 149      14.735   6.274  31.694  1.00 20.86           C  
ATOM   1138  CG1 ILE A 149      14.275   6.391  30.260  1.00 19.29           C  
ATOM   1139  CG2 ILE A 149      14.039   7.334  32.501  1.00 20.83           C  
ATOM   1140  CD1 ILE A 149      12.970   5.794  30.039  1.00 23.14           C  
ATOM   1141  N   GLU A 150      16.825   5.785  34.064  1.00 22.29           N  
ATOM   1142  CA  GLU A 150      17.377   5.976  35.439  1.00 22.63           C  
ATOM   1143  C   GLU A 150      18.791   6.564  35.405  1.00 22.35           C  
ATOM   1144  O   GLU A 150      19.163   7.428  36.229  1.00 22.91           O  
ATOM   1145  CB  GLU A 150      17.369   4.666  36.264  1.00 24.18           C  
ATOM   1146  N   ASN A 151      19.596   6.100  34.463  1.00 22.00           N  
ATOM   1147  CA  ASN A 151      20.928   6.651  34.318  1.00 22.13           C  
ATOM   1148  C   ASN A 151      20.878   8.084  33.833  1.00 20.99           C  
ATOM   1149  O   ASN A 151      21.652   8.905  34.301  1.00 22.69           O  
ATOM   1150  CB  ASN A 151      21.803   5.761  33.411  1.00 22.89           C  
ATOM   1151  CG  ASN A 151      22.175   4.417  34.089  1.00 25.46           C  
ATOM   1152  OD1 ASN A 151      22.060   4.284  35.307  1.00 24.29           O  
ATOM   1153  ND2 ASN A 151      22.601   3.434  33.302  1.00 15.50           N  
ATOM   1154  N   LEU A 152      19.990   8.412  32.898  1.00 19.97           N  
ATOM   1155  CA  LEU A 152      19.849   9.815  32.459  1.00 19.58           C  
ATOM   1156  C   LEU A 152      19.485  10.738  33.613  1.00 18.75           C  
ATOM   1157  O   LEU A 152      19.957  11.865  33.718  1.00 19.49           O  
ATOM   1158  CB  LEU A 152      18.805   9.935  31.336  1.00 19.96           C  
ATOM   1159  CG  LEU A 152      19.322   9.497  29.962  1.00 19.23           C  
ATOM   1160  CD1 LEU A 152      18.180   9.102  29.039  1.00 22.18           C  
ATOM   1161  CD2 LEU A 152      20.140  10.593  29.347  1.00 20.03           C  
ATOM   1162  N   LEU A 153      18.677  10.238  34.524  1.00 19.70           N  
ATOM   1163  CA  LEU A 153      18.208  11.075  35.616  1.00 21.50           C  
ATOM   1164  C   LEU A 153      19.281  11.418  36.641  1.00 23.02           C  
ATOM   1165  O   LEU A 153      19.066  12.269  37.496  1.00 23.86           O  
ATOM   1166  CB  LEU A 153      17.076  10.364  36.315  1.00 21.42           C  
ATOM   1167  CG  LEU A 153      15.781  10.470  35.580  1.00 22.86           C  
ATOM   1168  CD1 LEU A 153      14.834   9.454  36.224  1.00 27.59           C  
ATOM   1169  CD2 LEU A 153      15.245  11.908  35.643  1.00 29.79           C  
ATOM   1170  N   LYS A 154      20.427  10.739  36.573  1.00 23.82           N  
ATOM   1171  CA  LYS A 154      21.596  11.111  37.370  1.00 25.03           C  
ATOM   1172  C   LYS A 154      22.276  12.387  36.907  1.00 25.00           C  
ATOM   1173  O   LYS A 154      22.892  13.122  37.708  1.00 28.10           O  
ATOM   1174  CB  LYS A 154      22.600   9.979  37.325  1.00 26.74           C  
ATOM   1175  CG  LYS A 154      22.060   8.673  37.977  1.00 30.24           C  
ATOM   1176  CD  LYS A 154      23.200   7.601  37.851  1.00 36.57           C  
ATOM   1177  CE  LYS A 154      22.828   6.188  38.242  1.00 35.12           C  
ATOM   1178  NZ  LYS A 154      23.764   5.231  37.552  1.00 38.82           N  
ATOM   1179  N   ILE A 155      22.175  12.683  35.614  1.00 24.48           N  
ATOM   1180  CA  ILE A 155      22.807  13.871  35.065  1.00 21.57           C  
ATOM   1181  C   ILE A 155      22.271  15.053  35.855  1.00 21.90           C  
ATOM   1182  O   ILE A 155      21.053  15.256  35.968  1.00 16.25           O  
ATOM   1183  CB  ILE A 155      22.515  14.023  33.578  1.00 21.60           C  
ATOM   1184  CG1 ILE A 155      23.114  12.853  32.800  1.00 24.36           C  
ATOM   1185  CG2 ILE A 155      23.030  15.361  33.028  1.00 21.09           C  
ATOM   1186  CD1 ILE A 155      22.735  12.889  31.317  1.00 29.90           C  
ATOM   1187  N   TYR A 156      23.189  15.842  36.394  1.00 21.81           N  
ATOM   1188  CA  TYR A 156      22.778  16.793  37.418  1.00 22.38           C  
ATOM   1189  C   TYR A 156      21.723  17.764  36.863  1.00 22.80           C  
ATOM   1190  O   TYR A 156      20.819  18.178  37.558  1.00 23.54           O  
ATOM   1191  CB  TYR A 156      23.991  17.505  38.035  1.00 22.62           C  
ATOM   1192  CG  TYR A 156      24.689  18.477  37.135  1.00 18.08           C  
ATOM   1193  CD1 TYR A 156      25.567  18.050  36.201  1.00 19.20           C  
ATOM   1194  CD2 TYR A 156      24.442  19.823  37.245  1.00 20.61           C  
ATOM   1195  CE1 TYR A 156      26.205  18.958  35.339  1.00 27.10           C  
ATOM   1196  CE2 TYR A 156      25.083  20.754  36.423  1.00 22.09           C  
ATOM   1197  CZ  TYR A 156      25.982  20.325  35.493  1.00 22.20           C  
ATOM   1198  OH  TYR A 156      26.600  21.224  34.660  1.00 22.85           O  
ATOM   1199  N   THR A 157      21.812  18.098  35.594  1.00 23.05           N  
ATOM   1200  CA  THR A 157      20.893  19.065  35.031  1.00 21.16           C  
ATOM   1201  C   THR A 157      19.527  18.462  34.695  1.00 21.17           C  
ATOM   1202  O   THR A 157      18.618  19.201  34.375  1.00 21.24           O  
ATOM   1203  CB  THR A 157      21.487  19.634  33.768  1.00 21.20           C  
ATOM   1204  OG1 THR A 157      21.697  18.575  32.806  1.00 15.78           O  
ATOM   1205  CG2 THR A 157      22.813  20.324  34.078  1.00 23.34           C  
ATOM   1206  N   LEU A 158      19.398  17.137  34.749  1.00 22.40           N  
ATOM   1207  CA  LEU A 158      18.131  16.432  34.449  1.00 23.84           C  
ATOM   1208  C   LEU A 158      17.512  15.790  35.693  1.00 26.35           C  
ATOM   1209  O   LEU A 158      16.394  15.247  35.641  1.00 26.12           O  
ATOM   1210  CB  LEU A 158      18.325  15.324  33.435  1.00 23.15           C  
ATOM   1211  CG  LEU A 158      19.017  15.563  32.078  1.00 22.70           C  
ATOM   1212  CD1 LEU A 158      19.098  14.260  31.310  1.00 25.23           C  
ATOM   1213  CD2 LEU A 158      18.299  16.512  31.238  1.00 23.93           C  
ATOM   1214  N   LYS A 159      18.225  15.845  36.811  1.00 29.21           N  
ATOM   1215  CA  LYS A 159      17.776  15.143  38.012  1.00 32.53           C  
ATOM   1216  C   LYS A 159      16.377  15.606  38.463  1.00 33.10           C  
ATOM   1217  O   LYS A 159      15.612  14.814  39.002  1.00 33.13           O  
ATOM   1218  CB  LYS A 159      18.811  15.294  39.143  1.00 34.85           C  
ATOM   1219  CG  LYS A 159      18.772  16.647  39.872  1.00 38.53           C  
ATOM   1220  CD  LYS A 159      20.154  17.138  40.349  1.00 43.41           C  
ATOM   1221  CE  LYS A 159      21.146  16.010  40.766  1.00 45.75           C  
ATOM   1222  NZ  LYS A 159      22.533  16.539  41.246  1.00 45.11           N  
ATOM   1223  N   GLY A 160      16.041  16.872  38.206  1.00 33.68           N  
ATOM   1224  CA  GLY A 160      14.697  17.433  38.517  1.00 34.38           C  
ATOM   1225  C   GLY A 160      13.538  17.176  37.534  1.00 34.34           C  
ATOM   1226  O   GLY A 160      12.385  17.589  37.773  1.00 34.67           O  
ATOM   1227  N   CYS A 161      13.814  16.476  36.436  1.00 33.33           N  
ATOM   1228  CA  CYS A 161      12.840  16.396  35.334  1.00 31.89           C  
ATOM   1229  C   CYS A 161      11.734  15.397  35.598  1.00 31.20           C  
ATOM   1230  O   CYS A 161      11.882  14.475  36.405  1.00 31.52           O  
ATOM   1231  CB  CYS A 161      13.525  15.986  34.023  1.00 31.89           C  
ATOM   1232  SG  CYS A 161      14.694  17.185  33.314  1.00 29.44           S  
ATOM   1233  N   THR A 162      10.641  15.546  34.865  1.00 28.87           N  
ATOM   1234  CA  THR A 162       9.670  14.474  34.749  1.00 27.01           C  
ATOM   1235  C   THR A 162       9.978  13.839  33.410  1.00 26.07           C  
ATOM   1236  O   THR A 162      10.749  14.384  32.645  1.00 25.75           O  
ATOM   1237  CB  THR A 162       8.218  15.009  34.895  1.00 26.95           C  
ATOM   1238  OG1 THR A 162       7.989  16.139  34.056  1.00 26.32           O  
ATOM   1239  CG2 THR A 162       8.005  15.475  36.311  1.00 27.65           C  
ATOM   1240  N   TYR A 163       9.432  12.679  33.129  1.00 25.20           N  
ATOM   1241  CA  TYR A 163       9.596  12.135  31.822  1.00 26.79           C  
ATOM   1242  C   TYR A 163       8.550  11.095  31.514  1.00 25.76           C  
ATOM   1243  O   TYR A 163       8.007  10.464  32.410  1.00 27.73           O  
ATOM   1244  CB  TYR A 163      10.950  11.454  31.718  1.00 28.84           C  
ATOM   1245  CG  TYR A 163      10.981  10.261  32.608  1.00 27.88           C  
ATOM   1246  CD1 TYR A 163      10.496   9.044  32.181  1.00 30.36           C  
ATOM   1247  CD2 TYR A 163      11.428  10.382  33.905  1.00 29.87           C  
ATOM   1248  CE1 TYR A 163      10.485   7.941  33.048  1.00 32.67           C  
ATOM   1249  CE2 TYR A 163      11.433   9.324  34.753  1.00 31.92           C  
ATOM   1250  CZ  TYR A 163      10.961   8.110  34.326  1.00 32.12           C  
ATOM   1251  OH  TYR A 163      10.993   7.073  35.219  1.00 37.29           O  
ATOM   1252  N   LYS A 164       8.341  10.865  30.226  1.00 24.77           N  
ATOM   1253  CA  LYS A 164       7.430   9.866  29.758  1.00 25.53           C  
ATOM   1254  C   LYS A 164       8.028   9.220  28.563  1.00 24.32           C  
ATOM   1255  O   LYS A 164       8.418   9.930  27.648  1.00 21.55           O  
ATOM   1256  CB  LYS A 164       6.103  10.498  29.327  1.00 28.19           C  
ATOM   1257  CG  LYS A 164       5.540  11.511  30.284  1.00 31.59           C  
ATOM   1258  CD  LYS A 164       4.101  11.868  29.905  1.00 40.93           C  
ATOM   1259  CE  LYS A 164       3.043  10.863  30.427  1.00 43.08           C  
ATOM   1260  NZ  LYS A 164       1.700  11.533  30.696  1.00 42.21           N  
ATOM   1261  N   ILE A 165       8.064   7.884  28.534  1.00 25.23           N  
ATOM   1262  CA  ILE A 165       8.376   7.198  27.277  1.00 27.81           C  
ATOM   1263  C   ILE A 165       7.356   7.640  26.238  1.00 27.72           C  
ATOM   1264  O   ILE A 165       6.179   7.810  26.555  1.00 29.37           O  
ATOM   1265  CB  ILE A 165       8.342   5.674  27.337  1.00 28.14           C  
ATOM   1266  CG1 ILE A 165       9.303   5.080  26.312  1.00 29.43           C  
ATOM   1267  CG2 ILE A 165       6.949   5.135  26.993  1.00 30.42           C  
ATOM   1268  CD1 ILE A 165      10.748   5.259  26.655  1.00 30.58           C  
ATOM   1269  N   ARG A 166       7.785   7.843  24.998  1.00 27.93           N  
ATOM   1270  CA  ARG A 166       6.840   8.277  23.981  1.00 28.09           C  
ATOM   1271  C   ARG A 166       5.920   7.152  23.493  1.00 28.77           C  
ATOM   1272  O   ARG A 166       6.361   6.076  23.112  1.00 23.55           O  
ATOM   1273  CB  ARG A 166       7.534   8.857  22.763  1.00 27.72           C  
ATOM   1274  CG  ARG A 166       6.506   9.452  21.851  1.00 29.72           C  
ATOM   1275  CD  ARG A 166       7.098  10.241  20.770  1.00 30.05           C  
ATOM   1276  NE  ARG A 166       7.910  11.331  21.292  1.00 26.76           N  
ATOM   1277  CZ  ARG A 166       8.580  12.161  20.512  1.00 24.59           C  
ATOM   1278  NH1 ARG A 166       8.482  12.049  19.193  1.00 27.26           N  
ATOM   1279  NH2 ARG A 166       9.313  13.115  21.042  1.00 29.32           N  
ATOM   1280  N   LYS A 167       4.632   7.470  23.446  1.00 32.53           N  
ATOM   1281  CA  LYS A 167       3.591   6.522  23.031  1.00 34.37           C  
ATOM   1282  C   LYS A 167       2.781   7.072  21.859  1.00 37.65           C  
ATOM   1283  O   LYS A 167       2.548   8.280  21.770  1.00 37.62           O  
ATOM   1284  CB  LYS A 167       2.676   6.188  24.207  1.00 33.89           C  
ATOM   1285  CG  LYS A 167       3.367   5.323  25.246  1.00 33.59           C  
ATOM   1286  CD  LYS A 167       2.388   4.748  26.279  1.00 39.33           C  
ATOM   1287  CE  LYS A 167       3.026   3.624  27.152  1.00 38.38           C  
ATOM   1288  NZ  LYS A 167       2.010   2.591  27.642  1.00 42.79           N  
ATOM   1289  N   ARG A 168       2.403   6.174  20.945  1.00 40.40           N  
ATOM   1290  CA  ARG A 168       1.445   6.461  19.891  1.00 42.60           C  
ATOM   1291  C   ARG A 168       0.406   5.372  19.906  1.00 44.75           C  
ATOM   1292  O   ARG A 168       0.745   4.170  19.844  1.00 45.80           O  
ATOM   1293  CB  ARG A 168       2.114   6.518  18.530  1.00 42.57           C  
ATOM   1294  CG  ARG A 168       2.885   7.792  18.320  1.00 43.36           C  
ATOM   1295  CD  ARG A 168       2.076   9.031  18.731  1.00 43.01           C  
ATOM   1296  NE  ARG A 168       2.853  10.264  18.532  1.00 41.16           N  
ATOM   1297  CZ  ARG A 168       3.362  11.039  19.491  1.00 36.46           C  
ATOM   1298  NH1 ARG A 168       3.202  10.766  20.771  1.00 37.32           N  
ATOM   1299  NH2 ARG A 168       4.053  12.114  19.158  1.00 39.71           N  
ATOM   1300  N   ASN A 169      -0.857   5.794  20.037  1.00 46.74           N  
ATOM   1301  CA  ASN A 169      -1.986   4.870  20.113  1.00 47.34           C  
ATOM   1302  C   ASN A 169      -1.794   3.823  21.204  1.00 47.48           C  
ATOM   1303  O   ASN A 169      -2.071   2.642  20.987  1.00 48.31           O  
ATOM   1304  CB  ASN A 169      -2.187   4.190  18.757  1.00 47.91           C  
ATOM   1305  CG  ASN A 169      -2.241   5.197  17.593  1.00 51.13           C  
ATOM   1306  OD1 ASN A 169      -3.051   6.140  17.610  1.00 52.86           O  
ATOM   1307  ND2 ASN A 169      -1.385   4.994  16.579  1.00 51.19           N  
ATOM   1308  N   GLY A 170      -1.293   4.253  22.365  1.00 47.33           N  
ATOM   1309  CA  GLY A 170      -1.115   3.353  23.509  1.00 47.37           C  
ATOM   1310  C   GLY A 170      -0.064   2.275  23.290  1.00 46.86           C  
ATOM   1311  O   GLY A 170       0.018   1.295  24.036  1.00 48.15           O  
ATOM   1312  N   GLU A 171       0.734   2.447  22.243  1.00 45.87           N  
ATOM   1313  CA  GLU A 171       1.910   1.637  22.035  1.00 43.71           C  
ATOM   1314  C   GLU A 171       3.089   2.563  22.165  1.00 39.80           C  
ATOM   1315  O   GLU A 171       3.045   3.723  21.755  1.00 39.18           O  
ATOM   1316  CB  GLU A 171       1.897   0.964  20.649  1.00 45.50           C  
ATOM   1317  CG  GLU A 171       0.698   0.005  20.394  1.00 48.88           C  
ATOM   1318  CD  GLU A 171       0.537  -1.067  21.484  1.00 52.41           C  
ATOM   1319  OE1 GLU A 171       1.559  -1.608  21.958  1.00 53.37           O  
ATOM   1320  OE2 GLU A 171      -0.616  -1.363  21.868  1.00 54.69           O  
ATOM   1321  N   ILE A 172       4.147   2.041  22.752  1.00 36.48           N  
ATOM   1322  CA  ILE A 172       5.430   2.718  22.748  1.00 34.01           C  
ATOM   1323  C   ILE A 172       5.786   2.999  21.288  1.00 31.21           C  
ATOM   1324  O   ILE A 172       5.664   2.126  20.440  1.00 31.52           O  
ATOM   1325  CB  ILE A 172       6.489   1.870  23.464  1.00 33.61           C  
ATOM   1326  CG1 ILE A 172       6.053   1.646  24.923  1.00 33.74           C  
ATOM   1327  CG2 ILE A 172       7.847   2.548  23.417  1.00 33.05           C  
ATOM   1328  CD1 ILE A 172       6.967   0.718  25.738  1.00 33.59           C  
ATOM   1329  N   PHE A 173       6.145   4.246  21.002  1.00 28.41           N  
ATOM   1330  CA  PHE A 173       6.536   4.670  19.663  1.00 25.78           C  
ATOM   1331  C   PHE A 173       7.898   4.074  19.280  1.00 23.55           C  
ATOM   1332  O   PHE A 173       8.847   4.106  20.058  1.00 21.94           O  
ATOM   1333  CB  PHE A 173       6.549   6.207  19.598  1.00 24.46           C  
ATOM   1334  CG  PHE A 173       7.065   6.750  18.305  1.00 24.47           C  
ATOM   1335  CD1 PHE A 173       6.248   6.738  17.149  1.00 23.78           C  
ATOM   1336  CD2 PHE A 173       8.368   7.264  18.224  1.00 23.73           C  
ATOM   1337  CE1 PHE A 173       6.718   7.243  15.935  1.00 24.97           C  
ATOM   1338  CE2 PHE A 173       8.852   7.775  17.033  1.00 22.75           C  
ATOM   1339  CZ  PHE A 173       8.039   7.751  15.861  1.00 23.06           C  
ATOM   1340  N   ILE A 174       7.967   3.496  18.087  1.00 24.47           N  
ATOM   1341  CA  ILE A 174       9.219   3.019  17.516  1.00 25.73           C  
ATOM   1342  C   ILE A 174       9.757   3.942  16.406  1.00 24.61           C  
ATOM   1343  O   ILE A 174       9.023   4.317  15.486  1.00 23.10           O  
ATOM   1344  CB  ILE A 174       9.022   1.608  16.974  1.00 27.64           C  
ATOM   1345  CG1 ILE A 174       8.611   0.694  18.133  1.00 32.36           C  
ATOM   1346  CG2 ILE A 174      10.307   1.067  16.286  1.00 28.49           C  
ATOM   1347  CD1 ILE A 174       7.868  -0.603  17.688  1.00 34.80           C  
ATOM   1348  N   THR A 175      11.039   4.316  16.488  1.00 24.05           N  
ATOM   1349  CA  THR A 175      11.577   5.239  15.509  1.00 22.76           C  
ATOM   1350  C   THR A 175      11.880   4.521  14.196  1.00 22.34           C  
ATOM   1351  O   THR A 175      11.766   3.294  14.094  1.00 21.70           O  
ATOM   1352  CB  THR A 175      12.844   5.975  15.990  1.00 21.41           C  
ATOM   1353  OG1 THR A 175      13.931   5.057  16.052  1.00 22.08           O  
ATOM   1354  CG2 THR A 175      12.627   6.593  17.356  1.00 21.67           C  
ATOM   1355  N   ASP A 176      12.256   5.320  13.195  1.00 21.06           N  
ATOM   1356  CA  ASP A 176      12.799   4.821  11.958  1.00 19.57           C  
ATOM   1357  C   ASP A 176      14.017   3.923  12.177  1.00 19.24           C  
ATOM   1358  O   ASP A 176      14.253   2.991  11.421  1.00 19.93           O  
ATOM   1359  CB  ASP A 176      13.239   5.986  11.101  1.00 18.13           C  
ATOM   1360  CG  ASP A 176      12.082   6.698  10.422  1.00 21.51           C  
ATOM   1361  OD1 ASP A 176      10.917   6.274  10.537  1.00 18.80           O  
ATOM   1362  OD2 ASP A 176      12.357   7.698   9.732  1.00 27.80           O  
ATOM   1363  N   ASN A 177      14.811   4.269  13.184  1.00 20.57           N  
ATOM   1364  CA  ASN A 177      16.048   3.563  13.515  1.00 22.18           C  
ATOM   1365  C   ASN A 177      15.825   2.427  14.490  1.00 21.42           C  
ATOM   1366  O   ASN A 177      16.794   1.817  14.969  1.00 23.70           O  
ATOM   1367  CB  ASN A 177      17.011   4.553  14.127  1.00 20.97           C  
ATOM   1368  CG  ASN A 177      17.080   5.801  13.342  1.00 21.68           C  
ATOM   1369  OD1 ASN A 177      17.359   5.753  12.137  1.00 17.85           O  
ATOM   1370  ND2 ASN A 177      16.774   6.929  13.981  1.00 14.65           N  
ATOM   1371  N   LYS A 178      14.548   2.229  14.810  1.00 21.96           N  
ATOM   1372  CA  LYS A 178      14.029   1.088  15.589  1.00 22.31           C  
ATOM   1373  C   LYS A 178      14.341   1.246  17.061  1.00 21.51           C  
ATOM   1374  O   LYS A 178      14.476   0.268  17.789  1.00 21.60           O  
ATOM   1375  CB  LYS A 178      14.554  -0.255  15.045  1.00 22.81           C  
ATOM   1376  CG  LYS A 178      14.223  -0.518  13.576  1.00 22.01           C  
ATOM   1377  CD  LYS A 178      12.723  -0.610  13.395  1.00 27.09           C  
ATOM   1378  CE  LYS A 178      12.371  -0.797  11.922  1.00 31.28           C  
ATOM   1379  NZ  LYS A 178      10.918  -0.758  11.726  1.00 30.97           N  
ATOM   1380  N   ASN A 179      14.400   2.491  17.507  1.00 20.82           N  
ATOM   1381  CA  ASN A 179      14.611   2.781  18.909  1.00 21.14           C  
ATOM   1382  C   ASN A 179      13.320   3.306  19.528  1.00 21.46           C  
ATOM   1383  O   ASN A 179      12.274   3.375  18.880  1.00 19.58           O  
ATOM   1384  CB  ASN A 179      15.742   3.799  19.085  1.00 21.01           C  
ATOM   1385  CG  ASN A 179      17.054   3.287  18.529  1.00 23.28           C  
ATOM   1386  OD1 ASN A 179      17.486   2.216  18.908  1.00 21.52           O  
ATOM   1387  ND2 ASN A 179      17.671   4.036  17.599  1.00 19.40           N  
ATOM   1388  N   TYR A 180      13.428   3.613  20.803  1.00 21.72           N  
ATOM   1389  CA  TYR A 180      12.409   4.279  21.540  1.00 21.78           C  
ATOM   1390  C   TYR A 180      12.866   5.730  21.765  1.00 20.93           C  
ATOM   1391  O   TYR A 180      14.010   6.094  21.491  1.00 21.57           O  
ATOM   1392  CB  TYR A 180      12.173   3.602  22.891  1.00 22.64           C  
ATOM   1393  CG  TYR A 180      11.505   2.209  22.937  1.00 23.42           C  
ATOM   1394  CD1 TYR A 180      10.736   1.692  21.869  1.00 22.21           C  
ATOM   1395  CD2 TYR A 180      11.573   1.450  24.114  1.00 22.96           C  
ATOM   1396  CE1 TYR A 180      10.144   0.447  21.942  1.00 21.00           C  
ATOM   1397  CE2 TYR A 180      10.942   0.183  24.212  1.00 24.55           C  
ATOM   1398  CZ  TYR A 180      10.248  -0.312  23.126  1.00 22.86           C  
ATOM   1399  OH  TYR A 180       9.659  -1.552  23.266  1.00 27.10           O  
ATOM   1400  N   ILE A 181      11.940   6.568  22.237  1.00 21.76           N  
ATOM   1401  CA  ILE A 181      12.228   7.949  22.642  1.00 20.62           C  
ATOM   1402  C   ILE A 181      11.663   8.204  24.024  1.00 20.48           C  
ATOM   1403  O   ILE A 181      10.502   7.839  24.309  1.00 18.39           O  
ATOM   1404  CB  ILE A 181      11.611   8.978  21.675  1.00 21.27           C  
ATOM   1405  CG1 ILE A 181      12.379   9.019  20.356  1.00 21.27           C  
ATOM   1406  CG2 ILE A 181      11.649  10.376  22.261  1.00 22.61           C  
ATOM   1407  CD1 ILE A 181      11.663   9.795  19.303  1.00 19.97           C  
ATOM   1408  N   VAL A 182      12.486   8.786  24.894  1.00 20.74           N  
ATOM   1409  CA  VAL A 182      11.979   9.299  26.169  1.00 20.53           C  
ATOM   1410  C   VAL A 182      11.964  10.790  26.124  1.00 20.83           C  
ATOM   1411  O   VAL A 182      12.942  11.433  25.725  1.00 19.97           O  
ATOM   1412  CB  VAL A 182      12.772   8.792  27.396  1.00 20.84           C  
ATOM   1413  CG1 VAL A 182      14.241   9.249  27.384  1.00 21.03           C  
ATOM   1414  CG2 VAL A 182      12.101   9.233  28.706  1.00 24.01           C  
ATOM   1415  N   ASP A 183      10.824  11.338  26.564  1.00 22.12           N  
ATOM   1416  CA  ASP A 183      10.610  12.778  26.613  1.00 20.80           C  
ATOM   1417  C   ASP A 183      10.903  13.245  28.017  1.00 19.11           C  
ATOM   1418  O   ASP A 183      10.304  12.801  28.971  1.00 17.29           O  
ATOM   1419  CB  ASP A 183       9.169  13.128  26.128  1.00 20.25           C  
ATOM   1420  CG  ASP A 183       8.948  12.766  24.670  1.00 21.89           C  
ATOM   1421  OD1 ASP A 183       9.831  13.030  23.833  1.00 24.92           O  
ATOM   1422  OD2 ASP A 183       7.892  12.195  24.321  1.00 29.61           O  
ATOM   1423  N   PHE A 184      11.880  14.119  28.139  1.00 20.06           N  
ATOM   1424  CA  PHE A 184      12.147  14.795  29.383  1.00 21.83           C  
ATOM   1425  C   PHE A 184      11.486  16.153  29.374  1.00 22.52           C  
ATOM   1426  O   PHE A 184      11.478  16.848  28.357  1.00 21.59           O  
ATOM   1427  CB  PHE A 184      13.655  14.934  29.625  1.00 22.87           C  
ATOM   1428  CG  PHE A 184      14.256  13.721  30.266  1.00 23.48           C  
ATOM   1429  CD1 PHE A 184      14.195  12.483  29.645  1.00 24.72           C  
ATOM   1430  CD2 PHE A 184      14.850  13.802  31.503  1.00 25.71           C  
ATOM   1431  CE1 PHE A 184      14.748  11.359  30.250  1.00 23.75           C  
ATOM   1432  CE2 PHE A 184      15.402  12.697  32.099  1.00 26.70           C  
ATOM   1433  CZ  PHE A 184      15.343  11.470  31.480  1.00 23.88           C  
ATOM   1434  N   PHE A 185      10.939  16.497  30.538  1.00 23.39           N  
ATOM   1435  CA  PHE A 185      10.226  17.703  30.769  1.00 23.34           C  
ATOM   1436  C   PHE A 185      10.885  18.553  31.858  1.00 24.47           C  
ATOM   1437  O   PHE A 185      11.323  18.059  32.902  1.00 22.52           O  
ATOM   1438  CB  PHE A 185       8.787  17.349  31.146  1.00 24.64           C  
ATOM   1439  CG  PHE A 185       8.032  16.660  30.053  1.00 22.96           C  
ATOM   1440  CD1 PHE A 185       7.367  17.398  29.071  1.00 25.18           C  
ATOM   1441  CD2 PHE A 185       7.996  15.295  29.982  1.00 23.99           C  
ATOM   1442  CE1 PHE A 185       6.637  16.769  28.061  1.00 21.93           C  
ATOM   1443  CE2 PHE A 185       7.270  14.659  28.950  1.00 24.46           C  
ATOM   1444  CZ  PHE A 185       6.627  15.393  27.983  1.00 21.60           C  
ATOM   1445  N   PHE A 186      10.924  19.851  31.560  1.00 26.26           N  
ATOM   1446  CA  PHE A 186      11.610  20.885  32.314  1.00 28.46           C  
ATOM   1447  C   PHE A 186      10.610  21.984  32.727  1.00 30.62           C  
ATOM   1448  O   PHE A 186       9.850  22.499  31.886  1.00 31.63           O  
ATOM   1449  CB  PHE A 186      12.731  21.523  31.453  1.00 27.56           C  
ATOM   1450  CG  PHE A 186      13.846  20.594  31.139  1.00 25.62           C  
ATOM   1451  CD1 PHE A 186      13.760  19.720  30.066  1.00 29.08           C  
ATOM   1452  CD2 PHE A 186      14.965  20.538  31.949  1.00 26.49           C  
ATOM   1453  CE1 PHE A 186      14.756  18.838  29.812  1.00 23.99           C  
ATOM   1454  CE2 PHE A 186      15.971  19.652  31.687  1.00 22.89           C  
ATOM   1455  CZ  PHE A 186      15.859  18.802  30.620  1.00 25.21           C  
ATOM   1456  N   THR A 187      10.602  22.358  34.005  1.00 32.28           N  
ATOM   1457  CA  THR A 187       9.805  23.502  34.419  1.00 33.57           C  
ATOM   1458  C   THR A 187      10.609  24.811  34.350  1.00 33.58           C  
ATOM   1459  O   THR A 187      10.013  25.909  34.246  1.00 34.53           O  
ATOM   1460  CB  THR A 187       9.252  23.303  35.826  1.00 33.74           C  
ATOM   1461  OG1 THR A 187      10.333  23.192  36.754  1.00 35.52           O  
ATOM   1462  CG2 THR A 187       8.425  22.043  35.880  1.00 35.12           C  
ATOM   1463  N   GLU A 188      11.939  24.706  34.383  1.00 31.74           N  
ATOM   1464  CA  GLU A 188      12.809  25.865  34.212  1.00 30.50           C  
ATOM   1465  C   GLU A 188      13.743  25.585  33.047  1.00 30.68           C  
ATOM   1466  O   GLU A 188      13.930  24.414  32.686  1.00 30.29           O  
ATOM   1467  CB  GLU A 188      13.597  26.155  35.505  1.00 30.93           C  
ATOM   1468  N   PRO A 189      14.361  26.641  32.456  1.00 28.89           N  
ATOM   1469  CA  PRO A 189      15.143  26.367  31.233  1.00 27.86           C  
ATOM   1470  C   PRO A 189      16.272  25.399  31.492  1.00 26.72           C  
ATOM   1471  O   PRO A 189      16.723  25.237  32.618  1.00 26.11           O  
ATOM   1472  CB  PRO A 189      15.699  27.732  30.795  1.00 27.80           C  
ATOM   1473  CG  PRO A 189      15.291  28.733  31.829  1.00 29.49           C  
ATOM   1474  CD  PRO A 189      14.391  28.055  32.858  1.00 30.08           C  
ATOM   1475  N   ILE A 190      16.695  24.726  30.445  1.00 25.63           N  
ATOM   1476  CA  ILE A 190      17.714  23.704  30.595  1.00 25.55           C  
ATOM   1477  C   ILE A 190      19.026  24.361  30.982  1.00 24.56           C  
ATOM   1478  O   ILE A 190      19.477  25.277  30.329  1.00 21.45           O  
ATOM   1479  CB  ILE A 190      17.908  22.926  29.313  1.00 24.15           C  
ATOM   1480  CG1 ILE A 190      16.598  22.253  28.917  1.00 23.86           C  
ATOM   1481  CG2 ILE A 190      19.000  21.924  29.492  1.00 24.24           C  
ATOM   1482  CD1 ILE A 190      16.600  21.840  27.508  1.00 24.78           C  
ATOM   1483  N   GLN A 191      19.656  23.859  32.040  1.00 26.50           N  
ATOM   1484  CA  GLN A 191      20.904  24.463  32.498  1.00 26.65           C  
ATOM   1485  C   GLN A 191      22.141  23.839  31.824  1.00 25.72           C  
ATOM   1486  O   GLN A 191      22.153  22.658  31.412  1.00 25.04           O  
ATOM   1487  CB  GLN A 191      20.994  24.360  34.011  1.00 28.45           C  
ATOM   1488  CG  GLN A 191      19.844  25.070  34.786  1.00 33.43           C  
ATOM   1489  CD  GLN A 191      19.687  26.577  34.446  1.00 39.51           C  
ATOM   1490  OE1 GLN A 191      20.673  27.338  34.473  1.00 43.89           O  
ATOM   1491  NE2 GLN A 191      18.439  27.009  34.146  1.00 37.61           N  
ATOM   1492  N   ASP A 192      23.182  24.657  31.753  1.00 24.32           N  
ATOM   1493  CA  ASP A 192      24.469  24.302  31.176  1.00 23.82           C  
ATOM   1494  C   ASP A 192      24.237  23.497  29.906  1.00 23.87           C  
ATOM   1495  O   ASP A 192      24.630  22.329  29.821  1.00 21.57           O  
ATOM   1496  CB  ASP A 192      25.359  23.487  32.163  1.00 24.29           C  
ATOM   1497  CG  ASP A 192      25.575  24.171  33.524  1.00 22.73           C  
ATOM   1498  OD1 ASP A 192      25.656  25.404  33.596  1.00 25.35           O  
ATOM   1499  OD2 ASP A 192      25.638  23.466  34.550  1.00 28.50           O  
ATOM   1500  N   LEU A 193      23.634  24.149  28.919  1.00 24.45           N  
ATOM   1501  CA  LEU A 193      23.048  23.459  27.778  1.00 24.92           C  
ATOM   1502  C   LEU A 193      24.015  22.509  27.034  1.00 25.99           C  
ATOM   1503  O   LEU A 193      23.679  21.379  26.677  1.00 25.01           O  
ATOM   1504  CB  LEU A 193      22.505  24.516  26.817  1.00 25.17           C  
ATOM   1505  CG  LEU A 193      21.578  23.929  25.750  1.00 25.32           C  
ATOM   1506  CD1 LEU A 193      20.291  23.508  26.400  1.00 22.78           C  
ATOM   1507  CD2 LEU A 193      21.359  24.921  24.611  1.00 22.13           C  
ATOM   1508  N   LEU A 194      25.221  22.986  26.785  1.00 27.05           N  
ATOM   1509  CA  LEU A 194      26.196  22.209  26.035  1.00 28.66           C  
ATOM   1510  C   LEU A 194      26.751  21.021  26.846  1.00 26.41           C  
ATOM   1511  O   LEU A 194      26.996  19.929  26.298  1.00 24.21           O  
ATOM   1512  CB  LEU A 194      27.316  23.155  25.593  1.00 30.64           C  
ATOM   1513  CG  LEU A 194      28.369  22.671  24.601  1.00 32.47           C  
ATOM   1514  CD1 LEU A 194      27.762  22.297  23.288  1.00 36.38           C  
ATOM   1515  CD2 LEU A 194      29.391  23.796  24.400  1.00 31.74           C  
ATOM   1516  N   GLU A 195      26.899  21.225  28.164  1.00 23.65           N  
ATOM   1517  CA  GLU A 195      27.312  20.147  29.046  1.00 23.32           C  
ATOM   1518  C   GLU A 195      26.274  19.050  29.127  1.00 20.86           C  
ATOM   1519  O   GLU A 195      26.612  17.888  29.146  1.00 19.01           O  
ATOM   1520  CB  GLU A 195      27.626  20.666  30.452  1.00 24.34           C  
ATOM   1521  CG  GLU A 195      28.245  19.613  31.374  1.00 28.36           C  
ATOM   1522  CD  GLU A 195      29.606  18.986  30.883  1.00 33.49           C  
ATOM   1523  OE1 GLU A 195      30.327  19.640  30.083  1.00 37.09           O  
ATOM   1524  OE2 GLU A 195      29.936  17.828  31.297  1.00 30.69           O  
ATOM   1525  N   THR A 196      25.009  19.450  29.195  1.00 21.26           N  
ATOM   1526  CA  THR A 196      23.862  18.529  29.173  1.00 20.00           C  
ATOM   1527  C   THR A 196      23.880  17.652  27.920  1.00 18.01           C  
ATOM   1528  O   THR A 196      23.760  16.439  28.028  1.00 19.91           O  
ATOM   1529  CB  THR A 196      22.521  19.334  29.284  1.00 19.99           C  
ATOM   1530  OG1 THR A 196      22.482  20.034  30.542  1.00 20.38           O  
ATOM   1531  CG2 THR A 196      21.336  18.444  29.198  1.00 21.82           C  
ATOM   1532  N   CYS A 197      24.056  18.259  26.753  1.00 18.93           N  
ATOM   1533  CA  CYS A 197      24.081  17.534  25.441  1.00 20.48           C  
ATOM   1534  C   CYS A 197      25.164  16.474  25.466  1.00 18.41           C  
ATOM   1535  O   CYS A 197      24.964  15.332  25.155  1.00 19.34           O  
ATOM   1536  CB  CYS A 197      24.370  18.476  24.275  1.00 19.07           C  
ATOM   1537  SG  CYS A 197      23.134  19.694  23.924  1.00 30.10           S  
ATOM   1538  N   THR A 198      26.318  16.901  25.927  1.00 20.26           N  
ATOM   1539  CA  THR A 198      27.496  16.063  26.041  1.00 20.56           C  
ATOM   1540  C   THR A 198      27.237  14.924  26.995  1.00 19.58           C  
ATOM   1541  O   THR A 198      27.485  13.809  26.637  1.00 18.58           O  
ATOM   1542  CB  THR A 198      28.699  16.918  26.467  1.00 20.37           C  
ATOM   1543  OG1 THR A 198      29.007  17.822  25.384  1.00 24.92           O  
ATOM   1544  CG2 THR A 198      29.923  16.041  26.779  1.00 22.13           C  
ATOM   1545  N   ARG A 199      26.679  15.189  28.175  1.00 18.37           N  
ATOM   1546  CA  ARG A 199      26.413  14.086  29.142  1.00 17.69           C  
ATOM   1547  C   ARG A 199      25.292  13.118  28.705  1.00 16.11           C  
ATOM   1548  O   ARG A 199      25.301  11.906  29.025  1.00 17.66           O  
ATOM   1549  CB  ARG A 199      26.150  14.664  30.544  1.00 18.58           C  
ATOM   1550  CG  ARG A 199      27.362  15.236  31.221  1.00 22.04           C  
ATOM   1551  CD  ARG A 199      26.927  16.016  32.447  1.00 33.08           C  
ATOM   1552  NE  ARG A 199      28.004  16.823  33.052  1.00 39.67           N  
ATOM   1553  CZ  ARG A 199      28.586  16.588  34.230  1.00 40.01           C  
ATOM   1554  NH1 ARG A 199      28.223  15.545  34.981  1.00 40.48           N  
ATOM   1555  NH2 ARG A 199      29.538  17.417  34.653  1.00 37.88           N  
ATOM   1556  N   ILE A 200      24.328  13.636  27.960  1.00 16.10           N  
ATOM   1557  CA  ILE A 200      23.295  12.790  27.412  1.00 16.83           C  
ATOM   1558  C   ILE A 200      23.908  11.854  26.349  1.00 16.75           C  
ATOM   1559  O   ILE A 200      23.689  10.651  26.321  1.00 18.45           O  
ATOM   1560  CB  ILE A 200      22.167  13.623  26.753  1.00 15.97           C  
ATOM   1561  CG1 ILE A 200      21.343  14.357  27.792  1.00 18.96           C  
ATOM   1562  CG2 ILE A 200      21.279  12.692  25.941  1.00 15.02           C  
ATOM   1563  CD1 ILE A 200      20.380  15.374  27.247  1.00 18.28           C  
ATOM   1564  N   LYS A 201      24.676  12.453  25.461  1.00 17.53           N  
ATOM   1565  CA  LYS A 201      25.219  11.738  24.342  1.00 17.78           C  
ATOM   1566  C   LYS A 201      26.212  10.714  24.770  1.00 18.62           C  
ATOM   1567  O   LYS A 201      26.314   9.707  24.093  1.00 20.52           O  
ATOM   1568  CB  LYS A 201      25.910  12.683  23.360  1.00 17.49           C  
ATOM   1569  CG  LYS A 201      26.462  11.997  22.106  1.00 18.26           C  
ATOM   1570  CD  LYS A 201      25.339  11.426  21.203  1.00 19.34           C  
ATOM   1571  CE  LYS A 201      25.818  11.046  19.770  1.00 19.92           C  
ATOM   1572  NZ  LYS A 201      26.644   9.822  19.757  1.00 16.61           N  
ATOM   1573  N   MET A 202      26.960  10.997  25.836  1.00 18.91           N  
ATOM   1574  CA  MET A 202      27.945  10.058  26.411  1.00 19.50           C  
ATOM   1575  C   MET A 202      27.283   8.883  27.120  1.00 18.99           C  
ATOM   1576  O   MET A 202      27.945   7.874  27.409  1.00 20.28           O  
ATOM   1577  CB  MET A 202      28.872  10.793  27.396  1.00 19.67           C  
ATOM   1578  CG  MET A 202      29.880  11.723  26.724  1.00 20.32           C  
ATOM   1579  SD  MET A 202      30.931  10.857  25.488  1.00 25.76           S  
ATOM   1580  CE  MET A 202      31.870   9.784  26.612  1.00 26.31           C  
ATOM   1581  N   THR A 203      25.980   8.957  27.341  1.00 18.01           N  
ATOM   1582  CA  THR A 203      25.273   7.871  28.077  1.00 18.08           C  
ATOM   1583  C   THR A 203      25.148   6.553  27.285  1.00 17.75           C  
ATOM   1584  O   THR A 203      24.726   6.516  26.135  1.00 13.75           O  
ATOM   1585  CB  THR A 203      23.868   8.347  28.565  1.00 18.61           C  
ATOM   1586  OG1 THR A 203      24.019   9.448  29.480  1.00 19.61           O  
ATOM   1587  CG2 THR A 203      23.132   7.259  29.278  1.00 20.45           C  
ATOM   1588  N   THR A 204      25.504   5.444  27.933  1.00 18.83           N  
ATOM   1589  CA  THR A 204      25.302   4.141  27.325  1.00 17.85           C  
ATOM   1590  C   THR A 204      23.834   3.886  27.118  1.00 17.53           C  
ATOM   1591  O   THR A 204      23.026   3.973  28.028  1.00 19.03           O  
ATOM   1592  CB  THR A 204      25.927   3.005  28.199  1.00 18.80           C  
ATOM   1593  OG1 THR A 204      27.254   3.394  28.563  1.00 16.31           O  
ATOM   1594  CG2 THR A 204      25.964   1.732  27.436  1.00 15.71           C  
ATOM   1595  N   GLY A 205      23.473   3.537  25.909  1.00 18.04           N  
ATOM   1596  CA  GLY A 205      22.073   3.332  25.603  1.00 17.35           C  
ATOM   1597  C   GLY A 205      21.446   4.488  24.859  1.00 16.45           C  
ATOM   1598  O   GLY A 205      20.403   4.308  24.281  1.00 17.61           O  
ATOM   1599  N   VAL A 206      22.054   5.676  24.915  1.00 17.05           N  
ATOM   1600  CA  VAL A 206      21.545   6.864  24.205  1.00 16.83           C  
ATOM   1601  C   VAL A 206      22.070   6.818  22.765  1.00 19.18           C  
ATOM   1602  O   VAL A 206      23.254   6.600  22.534  1.00 18.90           O  
ATOM   1603  CB  VAL A 206      21.913   8.189  24.953  1.00 17.68           C  
ATOM   1604  CG1 VAL A 206      21.573   9.435  24.166  1.00 16.70           C  
ATOM   1605  CG2 VAL A 206      21.201   8.265  26.327  1.00 12.40           C  
ATOM   1606  N   VAL A 207      21.155   6.967  21.796  1.00 18.86           N  
ATOM   1607  CA  VAL A 207      21.534   7.097  20.414  1.00 18.16           C  
ATOM   1608  C   VAL A 207      21.851   8.589  20.130  1.00 19.82           C  
ATOM   1609  O   VAL A 207      22.976   8.935  19.755  1.00 18.77           O  
ATOM   1610  CB  VAL A 207      20.441   6.557  19.518  1.00 17.17           C  
ATOM   1611  CG1 VAL A 207      20.798   6.817  18.042  1.00 16.53           C  
ATOM   1612  CG2 VAL A 207      20.261   5.095  19.815  1.00 17.25           C  
ATOM   1613  N   ASP A 208      20.863   9.450  20.354  1.00 19.31           N  
ATOM   1614  CA  ASP A 208      21.066  10.905  20.324  1.00 20.10           C  
ATOM   1615  C   ASP A 208      19.883  11.575  21.009  1.00 18.86           C  
ATOM   1616  O   ASP A 208      18.949  10.896  21.507  1.00 17.72           O  
ATOM   1617  CB  ASP A 208      21.241  11.450  18.881  1.00 20.24           C  
ATOM   1618  CG  ASP A 208      22.341  12.590  18.780  1.00 24.31           C  
ATOM   1619  OD1 ASP A 208      22.241  13.622  19.524  1.00 21.92           O  
ATOM   1620  OD2 ASP A 208      23.285  12.465  17.938  1.00 20.96           O  
ATOM   1621  N   HIS A 209      19.949  12.898  21.079  1.00 18.00           N  
ATOM   1622  CA  HIS A 209      18.911  13.688  21.712  1.00 17.38           C  
ATOM   1623  C   HIS A 209      18.505  14.827  20.782  1.00 17.07           C  
ATOM   1624  O   HIS A 209      19.235  15.173  19.816  1.00 15.47           O  
ATOM   1625  CB  HIS A 209      19.419  14.271  23.023  1.00 18.39           C  
ATOM   1626  CG  HIS A 209      20.739  14.966  22.892  1.00 20.65           C  
ATOM   1627  ND1 HIS A 209      20.844  16.287  22.504  1.00 20.09           N  
ATOM   1628  CD2 HIS A 209      22.008  14.503  23.025  1.00 16.72           C  
ATOM   1629  CE1 HIS A 209      22.120  16.610  22.435  1.00 21.56           C  
ATOM   1630  NE2 HIS A 209      22.844  15.556  22.771  1.00 18.32           N  
ATOM   1631  N   GLY A 210      17.387  15.453  21.131  1.00 17.19           N  
ATOM   1632  CA  GLY A 210      16.785  16.505  20.337  1.00 17.10           C  
ATOM   1633  C   GLY A 210      17.299  17.930  20.508  1.00 18.16           C  
ATOM   1634  O   GLY A 210      16.708  18.852  19.963  1.00 17.44           O  
ATOM   1635  N   ILE A 211      18.415  18.120  21.208  1.00 19.59           N  
ATOM   1636  CA  ILE A 211      19.008  19.454  21.385  1.00 19.70           C  
ATOM   1637  C   ILE A 211      20.092  19.694  20.326  1.00 19.92           C  
ATOM   1638  O   ILE A 211      21.097  19.003  20.307  1.00 17.88           O  
ATOM   1639  CB  ILE A 211      19.627  19.594  22.754  1.00 19.79           C  
ATOM   1640  CG1 ILE A 211      18.639  19.156  23.833  1.00 21.26           C  
ATOM   1641  CG2 ILE A 211      20.082  21.010  23.005  1.00 17.77           C  
ATOM   1642  CD1 ILE A 211      19.251  19.170  25.206  1.00 21.31           C  
ATOM   1643  N   PHE A 212      19.859  20.660  19.429  1.00 19.54           N  
ATOM   1644  CA  PHE A 212      20.820  21.015  18.408  1.00 19.98           C  
ATOM   1645  C   PHE A 212      21.516  22.352  18.793  1.00 22.17           C  
ATOM   1646  O   PHE A 212      20.894  23.430  18.785  1.00 21.32           O  
ATOM   1647  CB  PHE A 212      20.171  21.136  17.026  1.00 19.43           C  
ATOM   1648  CG  PHE A 212      19.559  19.855  16.472  1.00 19.08           C  
ATOM   1649  CD1 PHE A 212      18.829  18.988  17.251  1.00 15.81           C  
ATOM   1650  CD2 PHE A 212      19.665  19.569  15.122  1.00 21.30           C  
ATOM   1651  CE1 PHE A 212      18.225  17.872  16.696  1.00 16.51           C  
ATOM   1652  CE2 PHE A 212      19.069  18.455  14.583  1.00 20.23           C  
ATOM   1653  CZ  PHE A 212      18.363  17.597  15.368  1.00 16.98           C  
ATOM   1654  N   VAL A 213      22.808  22.269  19.132  1.00 23.56           N  
ATOM   1655  CA  VAL A 213      23.575  23.424  19.593  1.00 25.24           C  
ATOM   1656  C   VAL A 213      24.645  23.806  18.553  1.00 26.65           C  
ATOM   1657  O   VAL A 213      25.307  22.933  17.979  1.00 30.84           O  
ATOM   1658  CB  VAL A 213      24.204  23.163  20.963  1.00 27.07           C  
ATOM   1659  CG1 VAL A 213      25.147  24.317  21.374  1.00 28.37           C  
ATOM   1660  CG2 VAL A 213      23.101  22.940  22.044  1.00 27.32           C  
ATOM   1661  N   ASN A 214      24.743  25.099  18.252  1.00 26.00           N  
ATOM   1662  CA  ASN A 214      25.684  25.631  17.252  1.00 25.75           C  
ATOM   1663  C   ASN A 214      25.639  24.936  15.894  1.00 25.94           C  
ATOM   1664  O   ASN A 214      26.634  24.850  15.226  1.00 26.90           O  
ATOM   1665  CB  ASN A 214      27.110  25.640  17.845  1.00 26.54           C  
ATOM   1666  CG  ASN A 214      27.200  26.500  19.118  1.00 29.14           C  
ATOM   1667  OD1 ASN A 214      26.625  27.591  19.173  1.00 33.38           O  
ATOM   1668  ND2 ASN A 214      27.908  26.015  20.139  1.00 31.35           N  
ATOM   1669  N   MET A 215      24.461  24.475  15.479  1.00 25.73           N  
ATOM   1670  CA  MET A 215      24.264  23.890  14.160  1.00 26.10           C  
ATOM   1671  C   MET A 215      23.433  24.785  13.177  1.00 25.44           C  
ATOM   1672  O   MET A 215      23.506  24.639  11.951  1.00 27.14           O  
ATOM   1673  CB  MET A 215      23.555  22.567  14.339  1.00 24.90           C  
ATOM   1674  CG  MET A 215      24.285  21.587  15.226  1.00 27.16           C  
ATOM   1675  SD  MET A 215      23.400  20.042  15.369  1.00 29.42           S  
ATOM   1676  CE  MET A 215      23.395  19.472  13.646  1.00 26.15           C  
ATOM   1677  N   THR A 216      22.616  25.682  13.699  1.00 25.16           N  
ATOM   1678  CA  THR A 216      21.759  26.501  12.829  1.00 23.75           C  
ATOM   1679  C   THR A 216      22.476  27.733  12.235  1.00 24.15           C  
ATOM   1680  O   THR A 216      22.968  28.582  12.963  1.00 23.78           O  
ATOM   1681  CB  THR A 216      20.519  26.948  13.602  1.00 23.49           C  
ATOM   1682  OG1 THR A 216      19.840  25.790  14.086  1.00 25.11           O  
ATOM   1683  CG2 THR A 216      19.541  27.749  12.716  1.00 20.77           C  
ATOM   1684  N   ASN A 217      22.486  27.815  10.906  1.00 23.94           N  
ATOM   1685  CA  ASN A 217      23.066  28.920  10.156  1.00 24.44           C  
ATOM   1686  C   ASN A 217      22.068  30.037   9.923  1.00 25.02           C  
ATOM   1687  O   ASN A 217      22.377  31.202  10.127  1.00 26.28           O  
ATOM   1688  CB  ASN A 217      23.542  28.458   8.786  1.00 24.17           C  
ATOM   1689  CG  ASN A 217      24.632  27.472   8.854  1.00 22.52           C  
ATOM   1690  OD1 ASN A 217      24.416  26.280   8.636  1.00 27.76           O  
ATOM   1691  ND2 ASN A 217      25.838  27.945   9.151  1.00 18.52           N  
ATOM   1692  N   VAL A 218      20.862  29.673   9.523  1.00 26.02           N  
ATOM   1693  CA  VAL A 218      19.785  30.640   9.250  1.00 26.72           C  
ATOM   1694  C   VAL A 218      18.469  30.196   9.880  1.00 25.02           C  
ATOM   1695  O   VAL A 218      18.154  29.014   9.822  1.00 24.38           O  
ATOM   1696  CB  VAL A 218      19.529  30.737   7.716  1.00 27.48           C  
ATOM   1697  CG1 VAL A 218      18.299  31.525   7.397  1.00 28.93           C  
ATOM   1698  CG2 VAL A 218      20.712  31.366   7.003  1.00 28.35           C  
ATOM   1699  N   ALA A 219      17.681  31.130  10.427  1.00 23.97           N  
ATOM   1700  CA  ALA A 219      16.273  30.836  10.772  1.00 22.74           C  
ATOM   1701  C   ALA A 219      15.331  31.853  10.161  1.00 23.75           C  
ATOM   1702  O   ALA A 219      15.590  33.077  10.187  1.00 23.28           O  
ATOM   1703  CB  ALA A 219      16.064  30.797  12.254  1.00 24.31           C  
ATOM   1704  N   LEU A 220      14.254  31.336   9.579  1.00 22.52           N  
ATOM   1705  CA  LEU A 220      13.153  32.163   9.129  1.00 23.50           C  
ATOM   1706  C   LEU A 220      11.956  31.861   9.987  1.00 22.45           C  
ATOM   1707  O   LEU A 220      11.468  30.717  10.048  1.00 21.05           O  
ATOM   1708  CB  LEU A 220      12.839  31.896   7.692  1.00 24.26           C  
ATOM   1709  CG  LEU A 220      14.035  31.561   6.824  1.00 21.27           C  
ATOM   1710  CD1 LEU A 220      13.567  31.104   5.506  1.00 20.38           C  
ATOM   1711  CD2 LEU A 220      14.903  32.787   6.692  1.00 23.73           C  
ATOM   1712  N   ILE A 221      11.527  32.902  10.690  1.00 21.92           N  
ATOM   1713  CA  ILE A 221      10.364  32.869  11.540  1.00 23.68           C  
ATOM   1714  C   ILE A 221       9.210  33.724  10.963  1.00 24.11           C  
ATOM   1715  O   ILE A 221       9.338  34.943  10.788  1.00 23.59           O  
ATOM   1716  CB  ILE A 221      10.712  33.375  12.946  1.00 24.10           C  
ATOM   1717  CG1 ILE A 221      11.993  32.725  13.445  1.00 24.01           C  
ATOM   1718  CG2 ILE A 221       9.555  33.090  13.940  1.00 27.97           C  
ATOM   1719  CD1 ILE A 221      11.933  31.239  13.449  1.00 24.27           C  
ATOM   1720  N   SER A 222       8.079  33.100  10.691  1.00 25.30           N  
ATOM   1721  CA  SER A 222       6.935  33.867  10.202  1.00 26.88           C  
ATOM   1722  C   SER A 222       6.040  34.365  11.360  1.00 27.19           C  
ATOM   1723  O   SER A 222       5.565  33.573  12.184  1.00 25.63           O  
ATOM   1724  CB  SER A 222       6.108  33.054   9.190  1.00 27.12           C  
ATOM   1725  OG  SER A 222       5.668  31.836   9.746  1.00 24.70           O  
ATOM   1726  N   LYS A 223       5.812  35.684  11.380  1.00 28.46           N  
ATOM   1727  CA  LYS A 223       5.060  36.328  12.454  1.00 29.52           C  
ATOM   1728  C   LYS A 223       3.625  36.525  11.995  1.00 30.80           C  
ATOM   1729  O   LYS A 223       3.318  36.438  10.806  1.00 29.89           O  
ATOM   1730  CB  LYS A 223       5.759  37.633  12.880  1.00 29.59           C  
ATOM   1731  N   HIS A 224       2.725  36.738  12.938  1.00 33.43           N  
ATOM   1732  CA  HIS A 224       1.298  36.810  12.641  1.00 35.58           C  
ATOM   1733  C   HIS A 224       0.946  37.970  11.701  1.00 39.10           C  
ATOM   1734  O   HIS A 224       0.148  37.828  10.745  1.00 39.31           O  
ATOM   1735  CB  HIS A 224       0.524  36.938  13.951  1.00 35.47           C  
ATOM   1736  CG  HIS A 224       0.578  35.705  14.773  1.00 34.55           C  
ATOM   1737  ND1 HIS A 224      -0.103  34.559  14.427  1.00 38.13           N  
ATOM   1738  CD2 HIS A 224       1.277  35.407  15.888  1.00 37.03           C  
ATOM   1739  CE1 HIS A 224       0.156  33.612  15.313  1.00 38.24           C  
ATOM   1740  NE2 HIS A 224       1.002  34.099  16.203  1.00 39.30           N  
ATOM   1741  N   ASP A 225       1.576  39.101  11.981  1.00 41.80           N  
ATOM   1742  CA  ASP A 225       1.408  40.334  11.224  1.00 44.37           C  
ATOM   1743  C   ASP A 225       1.880  40.337   9.761  1.00 44.75           C  
ATOM   1744  O   ASP A 225       1.937  41.411   9.151  1.00 46.97           O  
ATOM   1745  CB  ASP A 225       2.199  41.429  11.946  1.00 44.93           C  
ATOM   1746  CG  ASP A 225       3.715  41.276  11.772  1.00 48.08           C  
ATOM   1747  OD1 ASP A 225       4.155  40.424  10.943  1.00 46.56           O  
ATOM   1748  OD2 ASP A 225       4.457  42.025  12.473  1.00 51.41           O  
ATOM   1749  N   GLY A 226       2.263  39.192   9.207  1.00 44.27           N  
ATOM   1750  CA  GLY A 226       2.731  39.132   7.807  1.00 43.46           C  
ATOM   1751  C   GLY A 226       4.251  39.033   7.628  1.00 43.13           C  
ATOM   1752  O   GLY A 226       4.732  38.364   6.707  1.00 43.66           O  
ATOM   1753  N   THR A 227       5.004  39.684   8.512  1.00 41.32           N  
ATOM   1754  CA  THR A 227       6.465  39.667   8.482  1.00 40.88           C  
ATOM   1755  C   THR A 227       7.129  38.253   8.528  1.00 39.68           C  
ATOM   1756  O   THR A 227       6.572  37.291   9.050  1.00 37.87           O  
ATOM   1757  CB  THR A 227       7.005  40.568   9.646  1.00 40.89           C  
ATOM   1758  OG1 THR A 227       6.997  41.927   9.203  1.00 44.88           O  
ATOM   1759  CG2 THR A 227       8.443  40.211  10.096  1.00 42.65           C  
ATOM   1760  N   VAL A 228       8.319  38.146   7.942  1.00 38.88           N  
ATOM   1761  CA  VAL A 228       9.214  37.017   8.216  1.00 37.92           C  
ATOM   1762  C   VAL A 228      10.559  37.542   8.739  1.00 37.16           C  
ATOM   1763  O   VAL A 228      11.259  38.297   8.035  1.00 37.12           O  
ATOM   1764  CB  VAL A 228       9.441  36.146   6.982  1.00 38.20           C  
ATOM   1765  CG1 VAL A 228      10.472  35.034   7.285  1.00 38.63           C  
ATOM   1766  CG2 VAL A 228       8.113  35.560   6.489  1.00 39.20           C  
ATOM   1767  N   LEU A 229      10.891  37.168   9.979  1.00 36.41           N  
ATOM   1768  CA  LEU A 229      12.190  37.465  10.584  1.00 36.34           C  
ATOM   1769  C   LEU A 229      13.238  36.500  10.049  1.00 37.25           C  
ATOM   1770  O   LEU A 229      13.061  35.289  10.133  1.00 38.43           O  
ATOM   1771  CB  LEU A 229      12.125  37.380  12.127  1.00 34.56           C  
ATOM   1772  N   THR A 230      14.321  37.032   9.487  1.00 38.20           N  
ATOM   1773  CA  THR A 230      15.505  36.238   9.140  1.00 37.49           C  
ATOM   1774  C   THR A 230      16.589  36.362  10.210  1.00 37.20           C  
ATOM   1775  O   THR A 230      17.048  37.453  10.498  1.00 38.64           O  
ATOM   1776  CB  THR A 230      16.113  36.676   7.801  1.00 37.44           C  
ATOM   1777  OG1 THR A 230      15.113  36.671   6.766  1.00 37.63           O  
ATOM   1778  CG2 THR A 230      17.232  35.739   7.408  1.00 38.96           C  
ATOM   1779  N   LEU A 231      17.016  35.252  10.796  1.00 36.79           N  
ATOM   1780  CA  LEU A 231      18.122  35.273  11.753  1.00 36.44           C  
ATOM   1781  C   LEU A 231      19.335  34.508  11.228  1.00 36.01           C  
ATOM   1782  O   LEU A 231      19.192  33.406  10.728  1.00 34.52           O  
ATOM   1783  CB  LEU A 231      17.686  34.646  13.062  1.00 36.24           C  
ATOM   1784  CG  LEU A 231      16.298  34.947  13.626  1.00 37.62           C  
ATOM   1785  CD1 LEU A 231      15.941  33.938  14.701  1.00 33.49           C  
ATOM   1786  CD2 LEU A 231      16.245  36.364  14.168  1.00 39.07           C  
ATOM   1787  N   ASN A 232      20.526  35.085  11.352  1.00 38.25           N  
ATOM   1788  CA  ASN A 232      21.776  34.438  10.899  1.00 39.40           C  
ATOM   1789  C   ASN A 232      22.750  34.159  12.043  1.00 39.65           C  
ATOM   1790  O   ASN A 232      22.776  34.906  13.017  1.00 40.53           O  
ATOM   1791  CB  ASN A 232      22.499  35.289   9.836  1.00 39.90           C  
ATOM   1792  CG  ASN A 232      21.599  35.676   8.664  1.00 41.58           C  
ATOM   1793  OD1 ASN A 232      21.024  34.814   7.987  1.00 43.36           O  
ATOM   1794  ND2 ASN A 232      21.485  36.985   8.409  1.00 41.19           N  
ATOM   1795  N   LYS A 233      23.534  33.083  11.936  1.00 39.93           N  
ATOM   1796  CA  LYS A 233      24.637  32.853  12.846  1.00 41.38           C  
ATOM   1797  C   LYS A 233      25.422  34.177  12.883  1.00 42.70           C  
ATOM   1798  O   LYS A 233      26.652  34.213  13.048  1.00 44.63           O  
TER    1799      LYS A 233                                                      
END
MOLECULE T0438_2_186.pdb
ATOM      1  N   GLN     2      22.301  40.864  20.451  1.00 45.66          
ATOM      2  CA  GLN     2      20.920  40.443  20.090  1.00 45.49          
ATOM      3  C   GLN     2      21.031  39.501  18.881  1.00 45.02          
ATOM      4  O   GLN     2      21.727  39.738  17.859  1.00 44.52          
ATOM      5  CB  GLN     2      20.001  41.664  19.812  1.00 45.68          
ATOM      6  CG  GLN     2      20.247  42.944  20.771  1.00 48.87          
ATOM      7  CD  GLN     2      21.138  44.133  20.172  1.00 50.18          
ATOM      8  OE1 GLN     2      21.022  44.439  18.977  1.00 51.19          
ATOM      9  NE2 GLN     2      21.973  44.802  21.024  1.00 46.81          
ATOM     10  N   TRP     3      20.369  38.376  19.023  1.00 44.69          
ATOM     11  CA  TRP     3      20.378  37.380  17.946  1.00 44.23          
ATOM     12  C   TRP     3      19.071  37.457  17.150  1.00 44.35          
ATOM     13  O   TRP     3      19.030  37.083  15.975  1.00 44.41          
ATOM     14  CB  TRP     3      20.611  35.966  18.508  1.00 42.96          
ATOM     15  CG  TRP     3      19.780  35.702  19.684  1.00 40.96          
ATOM     16  CD1 TRP     3      20.138  35.839  20.974  1.00 39.33          
ATOM     17  CD2 TRP     3      18.406  35.292  19.676  1.00 43.16          
ATOM     18  NE1 TRP     3      19.085  35.522  21.796  1.00 39.72          
ATOM     19  CE2 TRP     3      18.004  35.166  21.034  1.00 40.34          
ATOM     20  CE3 TRP     3      17.461  34.979  18.646  1.00 44.38          
ATOM     21  CZ2 TRP     3      16.695  34.773  21.418  1.00 38.75          
ATOM     22  CZ3 TRP     3      16.145  34.560  19.037  1.00 42.51          
ATOM     23  CH2 TRP     3      15.785  34.475  20.423  1.00 39.71          
ATOM     24  N   GLN     4      18.007  37.933  17.818  1.00 43.59          
ATOM     25  CA  GLN     4      16.729  38.267  17.159  1.00 42.20          
ATOM     26  C   GLN     4      16.911  39.288  16.033  1.00 40.57          
ATOM     27  O   GLN     4      16.105  39.369  15.127  1.00 40.61          
ATOM     28  CB  GLN     4      15.650  38.703  18.176  1.00 41.88          
ATOM     29  CG  GLN     4      16.136  39.685  19.247  1.00 42.96          
ATOM     30  CD  GLN     4      16.105  39.113  20.670  1.00 41.76          
ATOM     31  OE1 GLN     4      16.802  38.164  20.968  1.00 40.40          
ATOM     32  NE2 GLN     4      15.315  39.734  21.554  1.00 42.64          
ATOM     33  N   GLU     5      17.981  40.051  16.056  1.00 39.51          
ATOM     34  CA  GLU     5      18.176  40.924  14.951  1.00 39.47          
ATOM     35  C   GLU     5      18.675  40.092  13.761  1.00 37.95          
ATOM     36  O   GLU     5      18.368  40.367  12.611  1.00 36.65          
ATOM     37  CB  GLU     5      19.087  42.065  15.341  1.00 40.78          
ATOM     38  CG  GLU     5      19.214  43.177  14.290  1.00 48.67          
ATOM     39  CD  GLU     5      17.900  43.902  13.832  1.00 58.49          
ATOM     40  OE1 GLU     5      16.712  43.385  13.955  1.00 62.56          
ATOM     41  OE2 GLU     5      18.077  45.040  13.290  1.00 61.65          
ATOM     42  N   LEU     6      19.385  39.008  14.055  1.00 37.32          
ATOM     43  CA  LEU     6      19.644  37.958  13.054  1.00 35.46          
ATOM     44  C   LEU     6      18.402  37.140  12.689  1.00 34.95          
ATOM     45  O   LEU     6      18.210  36.788  11.527  1.00 34.26          
ATOM     46  CB  LEU     6      20.673  36.969  13.565  1.00 34.98          
ATOM     47  CG  LEU     6      21.750  36.771  12.565  1.00 31.82          
ATOM     48  CD1 LEU     6      22.286  38.168  12.572  1.00 27.40          
ATOM     49  CD2 LEU     6      22.674  35.746  13.153  1.00 30.24          
ATOM     50  N   TYR     7      17.585  36.824  13.686  1.00 34.57          
ATOM     51  CA  TYR     7      16.383  36.095  13.435  1.00 35.06          
ATOM     52  C   TYR     7      15.707  36.885  12.365  1.00 35.55          
ATOM     53  O   TYR     7      15.350  36.315  11.331  1.00 37.74          
ATOM     54  CB  TYR     7      15.505  36.072  14.657  1.00 36.13          
ATOM     55  CG  TYR     7      14.278  35.179  14.558  1.00 37.33          
ATOM     56  CD1 TYR     7      14.341  33.886  15.033  1.00 38.27          
ATOM     57  CD2 TYR     7      13.063  35.630  14.030  1.00 35.78          
ATOM     58  CE1 TYR     7      13.280  33.080  14.995  1.00 37.74          
ATOM     59  CE2 TYR     7      11.974  34.823  13.995  1.00 35.57          
ATOM     60  CZ  TYR     7      12.095  33.528  14.486  1.00 38.65          
ATOM     61  OH  TYR     7      11.067  32.566  14.469  1.00 42.57          
ATOM     62  N   ARG     8      15.578  38.199  12.570  1.00 34.26          
ATOM     63  CA  ARG     8      14.849  39.002  11.639  1.00 33.10          
ATOM     64  C   ARG     8      15.563  38.954  10.305  1.00 31.22          
ATOM     65  O   ARG     8      14.916  38.742   9.332  1.00 30.95          
ATOM     66  CB  ARG     8      14.490  40.421  12.194  1.00 34.39          
ATOM     67  CG  ARG     8      13.122  40.469  12.931  1.00 38.53          
ATOM     68  CD  ARG     8      11.938  39.837  12.015  1.00 46.29          
ATOM     69  NE  ARG     8      10.943  38.935  12.696  1.00 46.06          
ATOM     70  CZ  ARG     8       9.769  38.435  12.158  1.00 42.31          
ATOM     71  NH1 ARG     8       9.426  38.718  10.884  1.00 38.18          
ATOM     72  NH2 ARG     8       8.952  37.646  12.915  1.00 37.18          
ATOM     73  N   GLN     9      16.876  39.075  10.243  1.00 29.86          
ATOM     74  CA  GLN     9      17.528  39.242   8.935  1.00 29.54          
ATOM     75  C   GLN     9      17.539  37.961   8.008  1.00 29.51          
ATOM     76  O   GLN     9      17.934  38.043   6.805  1.00 29.97          
ATOM     77  CB  GLN     9      18.940  39.867   9.110  1.00 29.11          
ATOM     78  CG  GLN     9      19.927  39.779   7.874  1.00 31.47          
ATOM     79  CD  GLN     9      21.436  39.404   8.260  1.00 34.75          
ATOM     80  OE1 GLN     9      22.120  40.202   8.961  1.00 41.31          
ATOM     81  NE2 GLN     9      21.936  38.195   7.809  1.00 34.17          
ATOM     82  N   ARG    10      17.103  36.791   8.536  1.00 27.99          
ATOM     83  CA  ARG    10      17.257  35.479   7.837  1.00 25.47          
ATOM     84  C   ARG    10      15.915  34.801   7.610  1.00 23.91          
ATOM     85  O   ARG    10      15.835  33.715   7.021  1.00 21.35          
ATOM     86  CB  ARG    10      18.087  34.539   8.711  1.00 25.21          
ATOM     87  CG  ARG    10      19.643  34.464   8.447  1.00 24.12          
ATOM     88  CD  ARG    10      20.453  34.545   9.747  1.00 20.79          
ATOM     89  NE  ARG    10      21.708  33.838   9.752  1.00 20.44          
ATOM     90  CZ  ARG    10      22.836  34.319   9.288  1.00 26.06          
ATOM     91  NH1 ARG    10      22.938  35.531   8.710  1.00 31.79          
ATOM     92  NH2 ARG    10      23.893  33.561   9.367  1.00 26.81          
ATOM     93  N   VAL    11      14.856  35.411   8.147  1.00 23.51          
ATOM     94  CA  VAL    11      13.468  34.939   7.856  1.00 24.18          
ATOM     95  C   VAL    11      12.950  35.245   6.394  1.00 24.54          
ATOM     96  O   VAL    11      13.170  36.348   5.886  1.00 25.11          
ATOM     97  CB  VAL    11      12.442  35.295   8.996  1.00 23.08          
ATOM     98  CG1 VAL    11      12.697  36.579   9.455  1.00 22.94          
ATOM     99  CG2 VAL    11      11.053  35.250   8.541  1.00 21.30          
ATOM    100  N   CYS    12      12.364  34.229   5.725  1.00 23.75          
ATOM    101  CA  CYS    12      11.746  34.327   4.406  1.00 23.05          
ATOM    102  C   CYS    12      10.544  33.390   4.344  1.00 22.52          
ATOM    103  O   CYS    12      10.106  32.858   5.350  1.00 22.55          
ATOM    104  CB  CYS    12      12.742  34.040   3.276  1.00 22.22          
ATOM    105  SG  CYS    12      13.790  32.594   3.587  1.00 26.12          
ATOM    106  N   SER    13       9.984  33.237   3.157  1.00 22.63          
ATOM    107  CA  SER    13       8.885  32.332   2.923  1.00 21.87          
ATOM    108  C   SER    13       9.543  31.066   2.564  1.00 20.56          
ATOM    109  O   SER    13      10.679  31.034   2.134  1.00 19.95          
ATOM    110  CB  SER    13       8.045  32.773   1.689  1.00 22.74          
ATOM    111  OG  SER    13       8.782  32.631   0.471  1.00 22.51          
ATOM    112  N   ALA    14       8.778  30.012   2.647  1.00 19.68          
ATOM    113  CA  ALA    14       9.261  28.772   2.182  1.00 18.20          
ATOM    114  C   ALA    14       9.767  28.969   0.743  1.00 17.81          
ATOM    115  O   ALA    14      10.901  28.543   0.407  1.00 17.26          
ATOM    116  CB  ALA    14       8.174  27.770   2.255  1.00 17.48          
ATOM    117  N   ASP    15       8.965  29.650  -0.075  1.00 17.40          
ATOM    118  CA  ASP    15       9.211  29.686  -1.539  1.00 17.58          
ATOM    119  C   ASP    15      10.487  30.433  -1.836  1.00 17.51          
ATOM    120  O   ASP    15      11.311  30.009  -2.674  1.00 17.85          
ATOM    121  CB  ASP    15       8.085  30.371  -2.306  1.00 17.43          
ATOM    122  CG  ASP    15       6.708  29.566  -2.297  1.00 22.38          
ATOM    123  OD1 ASP    15       6.459  28.807  -3.287  1.00 24.07          
ATOM    124  OD2 ASP    15       5.803  29.661  -1.385  1.00 24.81          
ATOM    125  N   GLU    16      10.707  31.526  -1.100  1.00 17.22          
ATOM    126  CA  GLU    16      11.910  32.289  -1.307  1.00 15.21          
ATOM    127  C   GLU    16      13.102  31.449  -0.897  1.00 13.71          
ATOM    128  O   GLU    16      14.168  31.458  -1.579  1.00 12.05          
ATOM    129  CB  GLU    16      11.879  33.572  -0.545  1.00 16.27          
ATOM    130  CG  GLU    16      10.687  34.467  -0.728  1.00 18.47          
ATOM    131  CD  GLU    16      10.627  35.488   0.412  1.00 26.97          
ATOM    132  OE1 GLU    16      10.572  35.074   1.619  1.00 27.31          
ATOM    133  OE2 GLU    16      10.677  36.723   0.119  1.00 25.64          
ATOM    134  N   ALA    17      12.934  30.701   0.189  1.00 12.99          
ATOM    135  CA  ALA    17      14.004  29.727   0.575  1.00 13.65          
ATOM    136  C   ALA    17      14.275  28.533  -0.412  1.00 13.45          
ATOM    137  O   ALA    17      15.406  28.291  -0.777  1.00 12.07          
ATOM    138  CB  ALA    17      13.840  29.269   1.950  1.00 12.61          
ATOM    139  N   VAL    18      13.248  27.833  -0.865  1.00 14.16          
ATOM    140  CA  VAL    18      13.421  26.938  -2.017  1.00 16.22          
ATOM    141  C   VAL    18      14.161  27.625  -3.160  1.00 16.91          
ATOM    142  O   VAL    18      15.203  27.158  -3.659  1.00 16.37          
ATOM    143  CB  VAL    18      12.060  26.490  -2.624  1.00 15.97          
ATOM    144  CG1 VAL    18      12.246  25.850  -3.927  1.00 15.99          
ATOM    145  CG2 VAL    18      11.378  25.552  -1.751  1.00 17.31          
ATOM    146  N   VAL    19      13.630  28.729  -3.615  1.00 18.11          
ATOM    147  CA  VAL    19      14.321  29.245  -4.759  1.00 21.42          
ATOM    148  C   VAL    19      15.773  29.606  -4.525  1.00 23.57          
ATOM    149  O   VAL    19      16.554  29.291  -5.385  1.00 24.74          
ATOM    150  CB  VAL    19      13.635  30.342  -5.447  1.00 21.17          
ATOM    151  CG1 VAL    19      14.518  30.812  -6.572  1.00 20.43          
ATOM    152  CG2 VAL    19      12.330  29.809  -5.973  1.00 20.70          
ATOM    153  N   ASP    20      16.134  30.245  -3.402  1.00 25.89          
ATOM    154  CA  ASP    20      17.526  30.727  -3.203  1.00 28.38          
ATOM    155  C   ASP    20      18.424  29.612  -2.765  1.00 28.06          
ATOM    156  O   ASP    20      19.595  29.604  -3.031  1.00 28.27          
ATOM    157  CB  ASP    20      17.637  31.923  -2.223  1.00 29.34          
ATOM    158  CG  ASP    20      16.938  33.232  -2.806  1.00 39.37          
ATOM    159  OD1 ASP    20      17.516  33.774  -3.826  1.00 46.87          
ATOM    160  OD2 ASP    20      15.794  33.745  -2.406  1.00 40.49          
ATOM    161  N   SER    21      17.878  28.628  -2.101  1.00 27.91          
ATOM    162  CA  SER    21      18.755  27.626  -1.596  1.00 26.75          
ATOM    163  C   SER    21      18.865  26.472  -2.577  1.00 26.31          
ATOM    164  O   SER    21      19.719  25.654  -2.375  1.00 27.08          
ATOM    165  CB  SER    21      18.218  27.089  -0.292  1.00 27.05          
ATOM    166  OG  SER    21      17.116  26.217  -0.582  1.00 25.99          
ATOM    167  N   LEU    22      18.044  26.376  -3.621  1.00 24.68          
ATOM    168  CA  LEU    22      18.091  25.146  -4.364  1.00 23.84          
ATOM    169  C   LEU    22      18.634  25.283  -5.715  1.00 24.93          
ATOM    170  O   LEU    22      17.903  25.130  -6.731  1.00 26.26          
ATOM    171  CB  LEU    22      16.730  24.506  -4.461  1.00 23.97          
ATOM    172  CG  LEU    22      16.233  23.925  -3.138  1.00 22.50          
ATOM    173  CD1 LEU    22      15.176  22.905  -3.324  1.00 18.72          
ATOM    174  CD2 LEU    22      17.411  23.302  -2.398  1.00 22.66          
ATOM    175  N   LYS    23      19.929  25.542  -5.766  1.00 25.02          
ATOM    176  CA  LYS    23      20.602  25.712  -7.053  1.00 24.74          
ATOM    177  C   LYS    23      20.478  24.399  -7.888  1.00 24.03          
ATOM    178  O   LYS    23      20.452  23.302  -7.324  1.00 21.81          
ATOM    179  CB  LYS    23      22.076  26.201  -6.833  1.00 26.07          
ATOM    180  CG  LYS    23      22.142  27.600  -6.255  1.00 26.45          
ATOM    181  CD  LYS    23      20.911  28.383  -6.874  1.00 35.77          
ATOM    182  CE  LYS    23      20.688  29.922  -6.412  1.00 38.56          
ATOM    183  NZ  LYS    23      22.012  30.720  -6.220  1.00 42.87          
ATOM    184  N   PRO    24      20.377  24.511  -9.222  1.00 24.19          
ATOM    185  CA  PRO    24      20.483  23.338 -10.101  1.00 23.91          
ATOM    186  C   PRO    24      21.574  22.320  -9.658  1.00 24.25          
ATOM    187  O   PRO    24      22.636  22.659  -9.149  1.00 22.93          
ATOM    188  CB  PRO    24      20.836  23.955 -11.450  1.00 22.57          
ATOM    189  CG  PRO    24      20.402  25.315 -11.423  1.00 22.41          
ATOM    190  CD  PRO    24      20.124  25.737 -10.011  1.00 24.33          
ATOM    191  N   GLY    25      21.275  21.047  -9.843  1.00 24.91          
ATOM    192  CA  GLY    25      22.148  20.025  -9.339  1.00 22.99          
ATOM    193  C   GLY    25      22.373  19.939  -7.830  1.00 21.94          
ATOM    194  O   GLY    25      23.206  19.174  -7.452  1.00 22.50          
ATOM    195  N   THR    26      21.700  20.674  -6.943  1.00 20.84          
ATOM    196  CA  THR    26      21.987  20.496  -5.476  1.00 20.59          
ATOM    197  C   THR    26      21.419  19.186  -4.937  1.00 19.89          
ATOM    198  O   THR    26      20.437  18.732  -5.457  1.00 21.69          
ATOM    199  CB  THR    26      21.463  21.673  -4.642  1.00 19.97          
ATOM    200  OG1 THR    26      20.344  22.178  -5.331  1.00 22.62          
ATOM    201  CG2 THR    26      22.423  22.922  -4.718  1.00 23.49          
ATOM    202  N   LYS    27      22.040  18.572  -3.930  1.00 18.30          
ATOM    203  CA  LYS    27      21.432  17.516  -3.152  1.00 16.74          
ATOM    204  C   LYS    27      20.976  17.989  -1.786  1.00 16.46          
ATOM    205  O   LYS    27      21.687  18.729  -1.131  1.00 16.95          
ATOM    206  CB  LYS    27      22.493  16.509  -2.873  1.00 17.33          
ATOM    207  CG  LYS    27      23.179  16.134  -4.116  1.00 17.67          
ATOM    208  CD  LYS    27      24.649  15.882  -3.889  1.00 18.17          
ATOM    209  CE  LYS    27      25.100  14.632  -4.679  1.00 20.52          
ATOM    210  NZ  LYS    27      24.686  14.634  -6.118  1.00 22.18          
ATOM    211  N   VAL    28      19.841  17.508  -1.290  1.00 15.30          
ATOM    212  CA  VAL    28      19.279  18.066  -0.095  1.00 13.17          
ATOM    213  C   VAL    28      18.931  16.923   0.743  1.00 13.67          
ATOM    214  O   VAL    28      18.713  15.848   0.183  1.00 14.25          
ATOM    215  CB  VAL    28      18.033  18.943  -0.454  1.00 13.52          
ATOM    216  CG1 VAL    28      17.997  19.224  -1.929  1.00  9.64          
ATOM    217  CG2 VAL    28      16.757  18.404  -0.006  1.00 12.80          
ATOM    218  N   VAL    29      18.846  17.111   2.062  1.00 13.68          
ATOM    219  CA  VAL    29      18.433  16.035   2.988  1.00 13.42          
ATOM    220  C   VAL    29      17.292  16.589   3.831  1.00 14.82          
ATOM    221  O   VAL    29      17.375  17.720   4.317  1.00 14.92          
ATOM    222  CB  VAL    29      19.678  15.573   3.949  1.00 14.04          
ATOM    223  CG1 VAL    29      19.218  14.745   5.141  1.00 13.89          
ATOM    224  CG2 VAL    29      20.792  14.776   3.215  1.00  9.61          
ATOM    225  N   PHE    30      16.211  15.841   4.048  1.00 16.24          
ATOM    226  CA  PHE    30      15.112  16.383   4.929  1.00 15.93          
ATOM    227  C   PHE    30      15.142  15.725   6.246  1.00 17.61          
ATOM    228  O   PHE    30      15.413  14.539   6.318  1.00 18.72          
ATOM    229  CB  PHE    30      13.751  16.049   4.393  1.00 15.13          
ATOM    230  CG  PHE    30      13.355  16.807   3.122  1.00 16.71          
ATOM    231  CD1 PHE    30      12.130  16.473   2.454  1.00 13.37          
ATOM    232  CD2 PHE    30      14.143  17.855   2.618  1.00 14.25          
ATOM    233  CE1 PHE    30      11.714  17.102   1.339  1.00  7.85          
ATOM    234  CE2 PHE    30      13.709  18.537   1.509  1.00 14.62          
ATOM    235  CZ  PHE    30      12.489  18.150   0.845  1.00 15.33          
ATOM    236  N   GLY    31      14.862  16.447   7.324  1.00 20.63          
ATOM    237  CA  GLY    31      14.907  15.849   8.729  1.00 23.62          
ATOM    238  C   GLY    31      13.764  14.870   8.742  1.00 25.45          
ATOM    239  O   GLY    31      12.886  14.924   7.814  1.00 25.70          
ATOM    240  N   HSD    32      13.717  13.921   9.681  1.00 27.22          
ATOM    241  CA  HSD    32      12.664  12.907   9.339  1.00 27.58          
ATOM    242  C   HSD    32      11.594  12.665  10.317  1.00 24.69          
ATOM    243  O   HSD    32      11.641  13.260  11.315  1.00 23.64          
ATOM    244  CB  HSD    32      13.203  11.593   8.699  1.00 29.84          
ATOM    245  CG  HSD    32      13.512  10.536   9.708  1.00 30.57          
ATOM    246  ND1 HSD    32      14.035  10.857  10.955  1.00 33.64          
ATOM    247  CD2 HSD    32      13.316   9.191   9.688  1.00 23.42          
ATOM    248  CE1 HSD    32      14.171   9.722  11.644  1.00 34.23          
ATOM    249  NE2 HSD    32      13.731   8.711  10.906  1.00 24.90          
ATOM    250  N   ALA    33      10.600  11.851   9.922  1.00 23.60          
ATOM    251  CA  ALA    33       9.577  11.246  10.798  1.00 22.77          
ATOM    252  C   ALA    33       8.559  12.357  10.980  1.00 22.68          
ATOM    253  O   ALA    33       7.988  12.811   9.974  1.00 24.97          
ATOM    254  CB  ALA    33      10.154  10.728  12.138  1.00 22.02          
ATOM    255  N   ALA    34       8.327  12.826  12.213  1.00 21.17          
ATOM    256  CA  ALA    34       7.248  13.789  12.461  1.00 18.34          
ATOM    257  C   ALA    34       7.829  15.166  12.415  1.00 17.88          
ATOM    258  O   ALA    34       7.059  16.105  12.626  1.00 19.36          
ATOM    259  CB  ALA    34       6.557  13.552  13.782  1.00 17.06          
ATOM    260  N   ALA    35       9.123  15.287  12.054  1.00 15.79          
ATOM    261  CA  ALA    35       9.798  16.548  11.976  1.00 15.94          
ATOM    262  C   ALA    35      10.119  16.850  10.567  1.00 17.19          
ATOM    263  O   ALA    35      10.953  17.725  10.322  1.00 18.60          
ATOM    264  CB  ALA    35      11.079  16.542  12.757  1.00 15.24          
ATOM    265  N   ALA    36       9.494  16.108   9.656  1.00 18.19          
ATOM    266  CA  ALA    36       9.643  16.199   8.200  1.00 18.59          
ATOM    267  C   ALA    36       9.093  17.570   7.723  1.00 19.68          
ATOM    268  O   ALA    36       8.035  17.993   8.199  1.00 20.43          
ATOM    269  CB  ALA    36       8.852  15.070   7.575  1.00 18.13          
ATOM    270  N   PRO    37       9.807  18.291   6.856  1.00 19.40          
ATOM    271  CA  PRO    37       9.494  19.653   6.592  1.00 19.11          
ATOM    272  C   PRO    37       8.652  19.746   5.328  1.00 19.82          
ATOM    273  O   PRO    37       9.069  20.090   4.211  1.00 19.21          
ATOM    274  CB  PRO    37      10.877  20.291   6.449  1.00 19.33          
ATOM    275  CG  PRO    37      11.789  19.190   6.242  1.00 19.25          
ATOM    276  CD  PRO    37      11.030  17.897   6.136  1.00 19.94          
ATOM    277  N   VAL    38       7.402  19.462   5.573  1.00 21.02          
ATOM    278  CA  VAL    38       6.420  19.357   4.562  1.00 21.32          
ATOM    279  C   VAL    38       6.151  20.724   3.945  1.00 21.37          
ATOM    280  O   VAL    38       5.880  20.781   2.742  1.00 22.79          
ATOM    281  CB  VAL    38       5.198  18.633   5.149  1.00 20.45          
ATOM    282  CG1 VAL    38       5.005  19.063   6.573  1.00 21.69          
ATOM    283  CG2 VAL    38       3.953  18.894   4.314  1.00 23.80          
ATOM    284  N   ARG    39       6.251  21.828   4.695  1.00 21.58          
ATOM    285  CA  ARG    39       6.057  23.200   4.058  1.00 21.31          
ATOM    286  C   ARG    39       6.993  23.492   2.937  1.00 20.54          
ATOM    287  O   ARG    39       6.626  24.009   1.881  1.00 20.63          
ATOM    288  CB  ARG    39       6.234  24.299   5.063  1.00 20.92          
ATOM    289  CG  ARG    39       4.886  24.753   5.544  1.00 23.30          
ATOM    290  CD  ARG    39       4.194  23.790   6.423  1.00 22.38          
ATOM    291  NE  ARG    39       5.084  23.064   7.343  1.00 21.17          
ATOM    292  CZ  ARG    39       4.580  22.148   8.167  1.00 22.55          
ATOM    293  NH1 ARG    39       5.357  21.445   8.985  1.00 21.29          
ATOM    294  NH2 ARG    39       3.258  21.917   8.140  1.00 18.42          
ATOM    295  N   PHE    40       8.233  23.154   3.218  1.00 20.34          
ATOM    296  CA  PHE    40       9.247  23.150   2.258  1.00 19.91          
ATOM    297  C   PHE    40       8.970  22.162   1.149  1.00 21.28          
ATOM    298  O   PHE    40       9.204  22.510  -0.020  1.00 24.41          
ATOM    299  CB  PHE    40      10.528  22.765   2.901  1.00 18.96          
ATOM    300  CG  PHE    40      11.745  23.205   2.122  1.00 17.88          
ATOM    301  CD1 PHE    40      12.305  22.402   1.152  1.00 16.72          
ATOM    302  CD2 PHE    40      12.311  24.425   2.343  1.00 15.73          
ATOM    303  CE1 PHE    40      13.440  22.782   0.458  1.00 13.55          
ATOM    304  CE2 PHE    40      13.397  24.793   1.635  1.00 18.00          
ATOM    305  CZ  PHE    40      13.987  23.926   0.683  1.00 14.48          
ATOM    306  N   SER    41       8.474  20.950   1.419  1.00 21.03          
ATOM    307  CA  SER    41       8.101  20.048   0.285  1.00 20.01          
ATOM    308  C   SER    41       7.008  20.685  -0.618  1.00 20.61          
ATOM    309  O   SER    41       7.081  20.734  -1.879  1.00 18.08          
ATOM    310  CB  SER    41       7.692  18.671   0.799  1.00 19.44          
ATOM    311  OG  SER    41       7.220  17.809  -0.243  1.00 19.22          
ATOM    312  N   GLN    42       6.026  21.262   0.089  1.00 23.29          
ATOM    313  CA  GLN    42       4.854  22.015  -0.501  1.00 23.53          
ATOM    314  C   GLN    42       5.526  23.094  -1.367  1.00 21.04          
ATOM    315  O   GLN    42       5.265  23.134  -2.564  1.00 21.64          
ATOM    316  CB  GLN    42       3.896  22.569   0.635  1.00 24.61          
ATOM    317  CG  GLN    42       2.364  22.442   0.482  1.00 30.98          
ATOM    318  CD  GLN    42       1.797  21.221   1.339  1.00 42.73          
ATOM    319  OE1 GLN    42       1.886  21.261   2.617  1.00 44.13          
ATOM    320  NE2 GLN    42       1.217  20.140   0.639  1.00 39.64          
ATOM    321  N   ALA    43       6.451  23.901  -0.817  1.00 18.30          
ATOM    322  CA  ALA    43       7.058  24.957  -1.689  1.00 17.00          
ATOM    323  C   ALA    43       7.867  24.463  -2.881  1.00 15.00          
ATOM    324  O   ALA    43       7.953  25.133  -3.863  1.00 11.84          
ATOM    325  CB  ALA    43       7.842  26.061  -0.891  1.00 17.47          
ATOM    326  N   MET    44       8.465  23.290  -2.765  1.00 14.50          
ATOM    327  CA  MET    44       9.171  22.718  -3.905  1.00 15.39          
ATOM    328  C   MET    44       8.180  22.315  -4.982  1.00 12.22          
ATOM    329  O   MET    44       8.453  22.459  -6.155  1.00 10.78          
ATOM    330  CB  MET    44      10.004  21.489  -3.456  1.00 16.06          
ATOM    331  CG  MET    44      11.325  21.827  -2.668  1.00 18.15          
ATOM    332  SD  MET    44      12.072  20.295  -2.106  1.00 20.97          
ATOM    333  CE  MET    44      13.066  19.768  -3.438  1.00 18.66          
ATOM    334  N   TYR    45       7.032  21.785  -4.580  1.00 10.67          
ATOM    335  CA  TYR    45       5.946  21.600  -5.542  1.00 10.06          
ATOM    336  C   TYR    45       5.572  22.889  -6.326  1.00  9.87          
ATOM    337  O   TYR    45       5.709  22.956  -7.562  1.00  8.45          
ATOM    338  CB  TYR    45       4.676  21.096  -4.889  1.00  9.54          
ATOM    339  CG  TYR    45       3.695  20.666  -5.899  1.00 10.38          
ATOM    340  CD1 TYR    45       3.758  19.374  -6.440  1.00 12.83          
ATOM    341  CD2 TYR    45       2.722  21.530  -6.378  1.00 13.04          
ATOM    342  CE1 TYR    45       2.851  18.920  -7.393  1.00  9.77          
ATOM    343  CE2 TYR    45       1.831  21.105  -7.362  1.00 12.73          
ATOM    344  CZ  TYR    45       1.896  19.781  -7.881  1.00 10.42          
ATOM    345  OH  TYR    45       1.007  19.310  -8.869  1.00  9.11          
ATOM    346  N   ARG    46       5.079  23.900  -5.622  1.00  9.05          
ATOM    347  CA  ARG    46       4.776  25.139  -6.317  1.00  9.66          
ATOM    348  C   ARG    46       5.910  25.661  -7.187  1.00 10.23          
ATOM    349  O   ARG    46       5.632  26.166  -8.245  1.00 12.26          
ATOM    350  CB  ARG    46       4.439  26.213  -5.329  1.00  9.96          
ATOM    351  CG  ARG    46       3.314  25.881  -4.450  1.00 13.07          
ATOM    352  CD  ARG    46       2.823  27.089  -3.757  1.00 15.66          
ATOM    353  NE  ARG    46       3.804  27.393  -2.785  1.00 13.78          
ATOM    354  CZ  ARG    46       3.789  26.881  -1.575  1.00 16.09          
ATOM    355  NH1 ARG    46       2.775  26.038  -1.199  1.00 13.23          
ATOM    356  NH2 ARG    46       4.827  27.215  -0.748  1.00 17.30          
ATOM    357  N   GLN    47       7.170  25.585  -6.745  1.00 10.28          
ATOM    358  CA  GLN    47       8.277  26.169  -7.466  1.00 10.77          
ATOM    359  C   GLN    47       8.893  25.199  -8.428  1.00 12.81          
ATOM    360  O   GLN    47       9.983  25.484  -8.888  1.00 13.62          
ATOM    361  CB  GLN    47       9.364  26.734  -6.537  1.00  9.13          
ATOM    362  CG  GLN    47       8.858  27.863  -5.590  1.00  8.69          
ATOM    363  CD  GLN    47       8.302  29.097  -6.313  1.00 12.55          
ATOM    364  OE1 GLN    47       9.001  29.654  -7.183  1.00 12.81          
ATOM    365  NE2 GLN    47       7.028  29.512  -5.999  1.00 10.02          
ATOM    366  N   ARG    48       8.234  24.070  -8.757  1.00 14.75          
ATOM    367  CA  ARG    48       8.882  23.003  -9.600  1.00 16.22          
ATOM    368  C   ARG    48       9.508  23.394 -10.941  1.00 18.74          
ATOM    369  O   ARG    48      10.503  22.813 -11.415  1.00 19.44          
ATOM    370  CB  ARG    48       7.955  21.872  -9.857  1.00 15.11          
ATOM    371  CG  ARG    48       6.812  22.197 -10.649  1.00 12.28          
ATOM    372  CD  ARG    48       5.739  21.130 -10.387  1.00 14.04          
ATOM    373  NE  ARG    48       4.596  21.083 -11.320  1.00 12.26          
ATOM    374  CZ  ARG    48       3.366  21.456 -11.022  1.00  7.88          
ATOM    375  NH1 ARG    48       2.382  21.322 -11.895  1.00 10.20          
ATOM    376  NH2 ARG    48       3.112  21.923  -9.830  1.00  8.03          
ATOM    377  N   GLU    49       8.945  24.443 -11.513  1.00 22.00          
ATOM    378  CA  GLU    49       9.142  24.778 -12.905  1.00 23.10          
ATOM    379  C   GLU    49      10.486  25.462 -12.887  1.00 21.97          
ATOM    380  O   GLU    49      11.117  25.564 -13.918  1.00 21.76          
ATOM    381  CB  GLU    49       7.956  25.675 -13.329  1.00 24.94          
ATOM    382  CG  GLU    49       6.632  25.427 -12.445  1.00 32.27          
ATOM    383  CD  GLU    49       5.382  24.838 -13.254  1.00 39.48          
ATOM    384  OE1 GLU    49       5.398  24.978 -14.542  1.00 42.88          
ATOM    385  OE2 GLU    49       4.371  24.278 -12.655  1.00 33.87          
ATOM    386  N   LYS    50      10.952  25.876 -11.706  1.00 20.75          
ATOM    387  CA  LYS    50      12.289  26.415 -11.602  1.00 21.27          
ATOM    388  C   LYS    50      13.357  25.454 -11.107  1.00 22.29          
ATOM    389  O   LYS    50      14.536  25.730 -11.349  1.00 22.17          
ATOM    390  CB  LYS    50      12.382  27.563 -10.644  1.00 20.60          
ATOM    391  CG  LYS    50      11.353  28.501 -10.782  1.00 23.73          
ATOM    392  CD  LYS    50      11.580  29.674  -9.798  1.00 32.88          
ATOM    393  CE  LYS    50      10.446  30.721  -9.868  1.00 34.86          
ATOM    394  NZ  LYS    50      10.027  30.892 -11.304  1.00 40.84          
ATOM    395  N   LEU    51      13.021  24.400 -10.357  1.00 22.84          
ATOM    396  CA  LEU    51      14.108  23.538  -9.925  1.00 24.35          
ATOM    397  C   LEU    51      14.666  22.590 -11.051  1.00 25.58          
ATOM    398  O   LEU    51      13.897  22.020 -11.885  1.00 24.86          
ATOM    399  CB  LEU    51      13.723  22.722  -8.703  1.00 25.21          
ATOM    400  CG  LEU    51      13.068  23.246  -7.435  1.00 24.94          
ATOM    401  CD1 LEU    51      13.734  24.504  -6.999  1.00 24.38          
ATOM    402  CD2 LEU    51      11.688  23.477  -7.833  1.00 24.87          
ATOM    403  N   GLU    52      15.991  22.427 -11.048  1.00 26.21          
ATOM    404  CA  GLU    52      16.666  21.582 -12.020  1.00 28.11          
ATOM    405  C   GLU    52      17.112  20.258 -11.418  1.00 27.85          
ATOM    406  O   GLU    52      16.266  19.421 -11.280  1.00 29.19          
ATOM    407  CB  GLU    52      17.830  22.289 -12.648  1.00 29.97          
ATOM    408  CG  GLU    52      17.450  23.278 -13.716  1.00 34.15          
ATOM    409  CD  GLU    52      17.371  22.581 -15.043  1.00 40.84          
ATOM    410  OE1 GLU    52      18.468  22.252 -15.589  1.00 41.08          
ATOM    411  OE2 GLU    52      16.210  22.347 -15.526  1.00 45.33          
ATOM    412  N   ASN    53      18.362  19.994 -11.063  1.00 26.32          
ATOM    413  CA  ASN    53      18.627  18.552 -10.795  1.00 26.13          
ATOM    414  C   ASN    53      18.692  18.238  -9.325  1.00 24.38          
ATOM    415  O   ASN    53      19.769  17.937  -8.795  1.00 24.90          
ATOM    416  CB  ASN    53      19.880  17.980 -11.476  1.00 27.32          
ATOM    417  CG  ASN    53      19.804  18.070 -12.970  1.00 33.09          
ATOM    418  OD1 ASN    53      18.812  17.618 -13.532  1.00 44.00          
ATOM    419  ND2 ASN    53      20.818  18.709 -13.638  1.00 35.87          
ATOM    420  N   ILE    54      17.566  18.308  -8.645  1.00 20.73          
ATOM    421  CA  ILE    54      17.685  18.294  -7.249  1.00 18.62          
ATOM    422  C   ILE    54      17.515  16.861  -6.767  1.00 18.10          
ATOM    423  O   ILE    54      16.558  16.202  -7.136  1.00 18.14          
ATOM    424  CB  ILE    54      16.653  19.228  -6.667  1.00 18.97          
ATOM    425  CG1 ILE    54      16.495  20.461  -7.562  1.00 18.42          
ATOM    426  CG2 ILE    54      16.981  19.512  -5.250  1.00 13.40          
ATOM    427  CD  ILE    54      17.589  21.414  -7.367  1.00 24.43          
ATOM    428  N   THR    55      18.431  16.379  -5.946  1.00 16.66          
ATOM    429  CA  THR    55      18.296  15.069  -5.355  1.00 17.48          
ATOM    430  C   THR    55      17.849  15.226  -3.939  1.00 17.26          
ATOM    431  O   THR    55      18.475  15.999  -3.210  1.00 17.34          
ATOM    432  CB  THR    55      19.670  14.425  -5.257  1.00 18.10          
ATOM    433  OG1 THR    55      20.177  14.302  -6.554  1.00 19.09          
ATOM    434  CG2 THR    55      19.567  12.992  -4.872  1.00 18.79          
ATOM    435  N   VAL    56      16.828  14.485  -3.492  1.00 16.58          
ATOM    436  CA  VAL    56      16.601  14.516  -2.035  1.00 17.07          
ATOM    437  C   VAL    56      16.821  13.213  -1.320  1.00 16.61          
ATOM    438  O   VAL    56      16.496  12.147  -1.837  1.00 14.95          
ATOM    439  CB  VAL    56      15.356  15.352  -1.560  1.00 16.13          
ATOM    440  CG1 VAL    56      14.273  15.165  -2.494  1.00 18.18          
ATOM    441  CG2 VAL    56      14.912  14.926  -0.175  1.00 15.60          
ATOM    442  N   PHE    57      17.468  13.294  -0.166  1.00 17.83          
ATOM    443  CA  PHE    57      17.566  12.104   0.653  1.00 20.29          
ATOM    444  C   PHE    57      16.736  12.226   1.919  1.00 20.07          
ATOM    445  O   PHE    57      16.657  13.302   2.565  1.00 21.59          
ATOM    446  CB  PHE    57      19.024  11.623   0.950  1.00 20.84          
ATOM    447  CG  PHE    57      19.062  10.550   2.007  1.00 22.77          
ATOM    448  CD1 PHE    57      19.228  10.887   3.360  1.00 24.36          
ATOM    449  CD2 PHE    57      18.769   9.213   1.664  1.00 27.03          
ATOM    450  CE1 PHE    57      19.180   9.884   4.395  1.00 26.23          
ATOM    451  CE2 PHE    57      18.697   8.214   2.674  1.00 28.83          
ATOM    452  CZ  PHE    57      18.906   8.564   4.072  1.00 23.10          
ATOM    453  N   HSD    58      16.086  11.132   2.231  1.00 20.79          
ATOM    454  CA  HSD    58      15.356  10.977   3.520  1.00 23.07          
ATOM    455  C   HSD    58      14.856   9.522   3.756  1.00 23.95          
ATOM    456  O   HSD    58      15.233   8.589   3.005  1.00 24.70          
ATOM    457  CB  HSD    58      14.229  12.033   3.710  1.00 22.43          
ATOM    458  CG  HSD    58      13.028  11.795   2.855  1.00 20.20          
ATOM    459  ND1 HSD    58      12.702  12.604   1.782  1.00 22.17          
ATOM    460  CD2 HSD    58      12.082  10.828   2.897  1.00 16.24          
ATOM    461  CE1 HSD    58      11.581  12.160   1.212  1.00 19.90          
ATOM    462  NE2 HSD    58      11.188  11.082   1.869  1.00 18.72          
ATOM    463  N   MET    59      14.047   9.349   4.804  1.00 24.79          
ATOM    464  CA  MET    59      13.649   8.032   5.330  1.00 25.10          
ATOM    465  C   MET    59      12.198   8.141   5.652  1.00 25.33          
ATOM    466  O   MET    59      11.461   8.248   4.747  1.00 27.43          
ATOM    467  CB  MET    59      14.502   7.639   6.529  1.00 23.90          
ATOM    468  CG  MET    59      15.867   7.184   6.090  1.00 24.27          
ATOM    469  SD  MET    59      16.994   6.955   7.482  1.00 27.42          
ATOM    470  CE  MET    59      17.542   5.314   6.896  1.00 24.67          
ATOM    471  N   LEU    60      11.756   8.168   6.909  1.00 26.46          
ATOM    472  CA  LEU    60      10.329   8.393   7.228  1.00 26.02          
ATOM    473  C   LEU    60       9.941   9.783   6.977  1.00 26.45          
ATOM    474  O   LEU    60      10.475  10.677   7.572  1.00 26.47          
ATOM    475  CB  LEU    60      10.035   8.147   8.709  1.00 25.84          
ATOM    476  CG  LEU    60      10.033   6.701   9.129  1.00 25.58          
ATOM    477  CD1 LEU    60       8.709   6.212   8.924  1.00 27.61          
ATOM    478  CD2 LEU    60      10.939   5.998   8.198  1.00 21.75          
ATOM    479  N   TYR    61       8.926   9.965   6.177  1.00 28.90          
ATOM    480  CA  TYR    61       8.262  11.269   6.102  1.00 30.96          
ATOM    481  C   TYR    61       6.851  11.029   6.539  1.00 30.13          
ATOM    482  O   TYR    61       6.155  10.179   5.967  1.00 28.73          
ATOM    483  CB  TYR    61       8.169  11.718   4.619  1.00 34.27          
ATOM    484  CG  TYR    61       7.359  10.683   3.650  1.00 41.40          
ATOM    485  CD1 TYR    61       7.983   9.487   3.067  1.00 44.61          
ATOM    486  CD2 TYR    61       5.936  10.900   3.304  1.00 46.34          
ATOM    487  CE1 TYR    61       7.195   8.579   2.125  1.00 40.74          
ATOM    488  CE2 TYR    61       5.166   9.985   2.389  1.00 39.60          
ATOM    489  CZ  TYR    61       5.817   8.870   1.840  1.00 38.96          
ATOM    490  OH  TYR    61       5.082   8.073   1.024  1.00 39.91          
ATOM    491  N   PHE    62       6.378  11.814   7.486  1.00 30.46          
ATOM    492  CA  PHE    62       4.942  11.940   7.685  1.00 30.51          
ATOM    493  C   PHE    62       4.272  13.216   7.040  1.00 30.96          
ATOM    494  O   PHE    62       4.502  14.243   7.611  1.00 30.96          
ATOM    495  CB  PHE    62       4.804  11.972   9.177  1.00 30.79          
ATOM    496  CG  PHE    62       5.309  10.724   9.877  1.00 30.41          
ATOM    497  CD1 PHE    62       5.704  10.780  11.212  1.00 32.62          
ATOM    498  CD2 PHE    62       5.307   9.497   9.257  1.00 30.78          
ATOM    499  CE1 PHE    62       6.144   9.622  11.925  1.00 31.31          
ATOM    500  CE2 PHE    62       5.753   8.336   9.940  1.00 32.05          
ATOM    501  CZ  PHE    62       6.160   8.405  11.287  1.00 31.82          
ATOM    502  N   GLY    63       3.548  13.163   5.852  1.00 32.78          
ATOM    503  CA  GLY    63       2.657  14.280   5.178  1.00 32.09          
ATOM    504  C   GLY    63       3.081  14.990   3.844  1.00 34.69          
ATOM    505  O   GLY    63       2.308  15.607   2.985  1.00 34.41          
ATOM    506  N   ASP    64       4.410  15.044   3.799  1.00 36.39          
ATOM    507  CA  ASP    64       5.309  15.294   2.680  1.00 35.00          
ATOM    508  C   ASP    64       4.753  14.780   1.366  1.00 34.29          
ATOM    509  O   ASP    64       5.276  13.798   0.809  1.00 33.58          
ATOM    510  CB  ASP    64       6.508  14.343   3.001  1.00 34.52          
ATOM    511  CG  ASP    64       7.652  15.050   3.379  1.00 32.44          
ATOM    512  OD1 ASP    64       8.674  14.406   3.786  1.00 30.73          
ATOM    513  OD2 ASP    64       7.541  16.298   3.252  1.00 27.43          
ATOM    514  N   ALA    65       3.708  15.324   0.838  1.00 33.07          
ATOM    515  CA  ALA    65       3.454  14.680  -0.458  1.00 33.64          
ATOM    516  C   ALA    65       4.514  15.087  -1.506  1.00 31.92          
ATOM    517  O   ALA    65       5.497  14.427  -1.735  1.00 29.97          
ATOM    518  CB  ALA    65       1.846  14.790  -1.003  1.00 34.74          
ATOM    519  N   PRO    66       4.329  16.237  -2.074  1.00 32.05          
ATOM    520  CA  PRO    66       5.006  16.623  -3.330  1.00 33.03          
ATOM    521  C   PRO    66       6.521  16.253  -3.524  1.00 34.34          
ATOM    522  O   PRO    66       7.373  17.077  -3.280  1.00 33.74          
ATOM    523  CB  PRO    66       4.874  18.121  -3.234  1.00 33.84          
ATOM    524  CG  PRO    66       4.389  18.356  -1.562  1.00 32.17          
ATOM    525  CD  PRO    66       3.498  17.308  -1.500  1.00 30.81          
ATOM    526  N   HSD    67       6.913  15.040  -3.887  1.00 36.42          
ATOM    527  CA  HSD    67       8.299  14.912  -4.441  1.00 37.64          
ATOM    528  C   HSD    67       8.279  13.755  -5.342  1.00 38.84          
ATOM    529  O   HSD    67       9.163  13.665  -6.315  1.00 39.60          
ATOM    530  CB  HSD    67       9.355  14.334  -3.514  1.00 38.67          
ATOM    531  CG  HSD    67       9.399  14.916  -2.154  1.00 37.94          
ATOM    532  ND1 HSD    67       9.396  16.275  -1.927  1.00 35.73          
ATOM    533  CD2 HSD    67       9.531  14.304  -0.952  1.00 31.96          
ATOM    534  CE1 HSD    67       9.456  16.471  -0.625  1.00 38.35          
ATOM    535  NE2 HSD    67       9.510  15.292  -0.015  1.00 37.11          
ATOM    536  N   LEU    68       7.440  12.772  -4.891  1.00 37.72          
ATOM    537  CA  LEU    68       7.176  11.562  -5.710  1.00 36.10          
ATOM    538  C   LEU    68       5.935  11.880  -6.488  1.00 33.90          
ATOM    539  O   LEU    68       5.398  10.980  -7.148  1.00 35.37          
ATOM    540  CB  LEU    68       7.110  10.187  -4.948  1.00 36.82          
ATOM    541  CG  LEU    68       7.523   8.769  -5.573  1.00 38.55          
ATOM    542  CD1 LEU    68       8.359   8.708  -6.967  1.00 37.96          
ATOM    543  CD2 LEU    68       8.153   7.758  -4.525  1.00 36.10          
ATOM    544  N   ALA    69       5.502  13.148  -6.458  1.00 29.05          
ATOM    545  CA  ALA    69       4.440  13.513  -7.345  1.00 25.67          
ATOM    546  C   ALA    69       5.172  13.310  -8.628  1.00 22.99          
ATOM    547  O   ALA    69       6.304  13.731  -8.726  1.00 22.81          
ATOM    548  CB  ALA    69       4.091  14.939  -7.172  1.00 26.27          
ATOM    549  N   PRO    70       4.599  12.552  -9.552  1.00 20.49          
ATOM    550  CA  PRO    70       5.181  12.342 -10.869  1.00 18.83          
ATOM    551  C   PRO    70       5.671  13.601 -11.568  1.00 17.75          
ATOM    552  O   PRO    70       6.665  13.526 -12.299  1.00 18.08          
ATOM    553  CB  PRO    70       4.035  11.697 -11.681  1.00 18.88          
ATOM    554  CG  PRO    70       3.120  11.140 -10.759  1.00 17.25          
ATOM    555  CD  PRO    70       3.385  11.747  -9.370  1.00 20.05          
ATOM    556  N   GLU    71       5.012  14.750 -11.363  1.00 16.84          
ATOM    557  CA  GLU    71       5.385  16.022 -12.066  1.00 14.77          
ATOM    558  C   GLU    71       6.697  16.599 -11.560  1.00 15.46          
ATOM    559  O   GLU    71       7.327  17.440 -12.197  1.00 16.72          
ATOM    560  CB  GLU    71       4.228  17.005 -12.122  1.00 12.78          
ATOM    561  CG  GLU    71       3.378  17.141 -10.891  1.00 14.57          
ATOM    562  CD  GLU    71       2.325  16.045 -10.606  1.00 20.09          
ATOM    563  OE1 GLU    71       1.184  16.257 -10.876  1.00 26.94          
ATOM    564  OE2 GLU    71       2.537  14.991 -10.001  1.00 21.86          
ATOM    565  N   MET    72       7.163  16.102 -10.418  1.00 15.91          
ATOM    566  CA  MET    72       8.532  16.369  -9.972  1.00 16.11          
ATOM    567  C   MET    72       9.590  15.773 -10.867  1.00 16.82          
ATOM    568  O   MET    72      10.752  16.175 -10.777  1.00 16.32          
ATOM    569  CB  MET    72       8.749  15.812  -8.612  1.00 15.79          
ATOM    570  CG  MET    72       7.785  16.416  -7.627  1.00 16.25          
ATOM    571  SD  MET    72       7.583  18.155  -7.899  1.00 17.49          
ATOM    572  CE  MET    72       8.963  19.024  -7.147  1.00  5.62          
ATOM    573  N   ARG    73       9.191  14.814 -11.710  1.00 17.47          
ATOM    574  CA  ARG    73      10.127  14.188 -12.649  1.00 18.49          
ATOM    575  C   ARG    73      10.949  15.230 -13.405  1.00 18.37          
ATOM    576  O   ARG    73      10.418  16.093 -14.086  1.00 19.34          
ATOM    577  CB  ARG    73       9.455  13.193 -13.617  1.00 18.25          
ATOM    578  CG  ARG    73      10.374  12.748 -14.717  1.00 19.07          
ATOM    579  CD  ARG    73       9.821  11.628 -15.541  1.00 22.48          
ATOM    580  NE  ARG    73      10.362  10.331 -15.125  1.00 23.61          
ATOM    581  CZ  ARG    73       9.732   9.507 -14.315  1.00 23.62          
ATOM    582  NH1 ARG    73       8.553   9.876 -13.826  1.00 25.50          
ATOM    583  NH2 ARG    73      10.271   8.337 -13.967  1.00 21.07          
ATOM    584  N   SER    74      12.260  15.086 -13.270  1.00 17.82          
ATOM    585  CA  SER    74      13.283  15.968 -13.810  1.00 16.37          
ATOM    586  C   SER    74      13.431  17.168 -12.940  1.00 18.12          
ATOM    587  O   SER    74      14.343  17.950 -13.187  1.00 20.81          
ATOM    588  CB  SER    74      13.020  16.452 -15.194  1.00 14.43          
ATOM    589  OG  SER    74      12.489  17.717 -15.159  1.00 10.73          
ATOM    590  N   HSD    75      12.584  17.360 -11.923  1.00 17.54          
ATOM    591  CA  HSD    75      12.885  18.456 -10.991  1.00 16.10          
ATOM    592  C   HSD    75      13.540  18.025  -9.744  1.00 15.04          
ATOM    593  O   HSD    75      14.547  18.556  -9.389  1.00 14.88          
ATOM    594  CB  HSD    75      11.660  19.337 -10.746  1.00 16.21          
ATOM    595  CG  HSD    75      11.008  19.797 -12.023  1.00 13.53          
ATOM    596  ND1 HSD    75      11.544  20.796 -12.805  1.00  9.81          
ATOM    597  CD2 HSD    75       9.887  19.367 -12.653  1.00  8.80          
ATOM    598  CE1 HSD    75      10.760  20.970 -13.852  1.00 13.78          
ATOM    599  NE2 HSD    75       9.741  20.130 -13.771  1.00  9.55          
ATOM    600  N   VAL    76      12.961  17.056  -9.063  1.00 15.89          
ATOM    601  CA  VAL    76      13.644  16.465  -7.915  1.00 16.03          
ATOM    602  C   VAL    76      13.323  15.022  -7.738  1.00 17.34          
ATOM    603  O   VAL    76      12.152  14.646  -7.685  1.00 18.48          
ATOM    604  CB  VAL    76      13.393  17.180  -6.596  1.00 14.83          
ATOM    605  CG1 VAL    76      12.180  17.969  -6.643  1.00 10.14          
ATOM    606  CG2 VAL    76      13.333  16.156  -5.480  1.00 13.99          
ATOM    607  N   HSD    77      14.385  14.233  -7.630  1.00 18.66          
ATOM    608  CA  HSD    77      14.274  12.805  -7.416  1.00 20.88          
ATOM    609  C   HSD    77      14.731  12.416  -6.057  1.00 22.14          
ATOM    610  O   HSD    77      15.667  13.046  -5.558  1.00 23.59          
ATOM    611  CB  HSD    77      15.129  12.065  -8.411  1.00 20.82          
ATOM    612  CG  HSD    77      14.694  12.282  -9.823  1.00 24.04          
ATOM    613  ND1 HSD    77      13.466  12.848 -10.144  1.00 25.21          
ATOM    614  CD2 HSD    77      15.315  12.017 -10.996  1.00 20.39          
ATOM    615  CE1 HSD    77      13.363  12.935 -11.454  1.00 23.22          
ATOM    616  NE2 HSD    77      14.457  12.413 -11.990  1.00 23.36          
ATOM    617  N   PRO    78      14.124  11.376  -5.456  1.00 23.06          
ATOM    618  CA  PRO    78      14.643  10.810  -4.176  1.00 23.97          
ATOM    619  C   PRO    78      15.836   9.841  -4.370  1.00 24.35          
ATOM    620  O   PRO    78      15.902   9.146  -5.395  1.00 23.72          
ATOM    621  CB  PRO    78      13.440  10.059  -3.644  1.00 23.70          
ATOM    622  CG  PRO    78      12.746   9.561  -4.959  1.00 22.21          
ATOM    623  CD  PRO    78      12.941  10.634  -5.946  1.00 22.27          
ATOM    624  N   THR    79      16.758   9.811  -3.411  1.00 25.96          
ATOM    625  CA  THR    79      17.809   8.792  -3.430  1.00 28.67          
ATOM    626  C   THR    79      17.750   8.104  -2.128  1.00 30.83          
ATOM    627  O   THR    79      17.203   8.640  -1.108  1.00 31.90          
ATOM    628  CB  THR    79      19.254   9.311  -3.573  1.00 28.44          
ATOM    629  OG1 THR    79      19.285  10.696  -3.253  1.00 28.13          
ATOM    630  CG2 THR    79      19.861   9.199  -5.025  1.00 28.02          
ATOM    631  N   LEU    80      18.303   6.888  -2.203  1.00 32.55          
ATOM    632  CA  LEU    80      18.741   6.101  -1.031  1.00 33.52          
ATOM    633  C   LEU    80      20.077   5.382  -1.384  1.00 33.06          
ATOM    634  O   LEU    80      20.637   5.591  -2.481  1.00 31.87          
ATOM    635  CB  LEU    80      17.644   5.157  -0.541  1.00 31.95          
ATOM    636  CG  LEU    80      17.328   3.966  -1.467  1.00 34.36          
ATOM    637  CD1 LEU    80      16.992   4.359  -2.983  1.00 32.23          
ATOM    638  CD2 LEU    80      18.317   2.698  -1.325  1.00 32.55          
ATOM    639  N   CYS   101      21.530  -0.841   6.743  1.00 45.50          
ATOM    640  CA  CYS   101      20.526  -1.334   7.693  1.00 45.54          
ATOM    641  C   CYS   101      20.963  -1.287   9.222  1.00 45.98          
ATOM    642  O   CYS   101      20.126  -1.461  10.192  1.00 47.36          
ATOM    643  CB  CYS   101      20.300  -2.738   7.347  1.00 45.34          
ATOM    644  SG  CYS   101      21.876  -3.463   7.806  1.00 47.60          
ATOM    645  N   HSD   102      22.265  -1.101   9.476  1.00 45.20          
ATOM    646  CA  HSD   102      22.644  -0.627  10.825  1.00 43.68          
ATOM    647  C   HSD   102      22.277   0.859  10.841  1.00 42.64          
ATOM    648  O   HSD   102      23.146   1.706  10.540  1.00 44.05          
ATOM    649  CB  HSD   102      24.133  -0.753  11.145  1.00 42.86          
ATOM    650  CG  HSD   102      24.684  -2.138  11.011  1.00 44.86          
ATOM    651  ND1 HSD   102      26.028  -2.378  10.768  1.00 47.33          
ATOM    652  CD2 HSD   102      24.089  -3.353  11.077  1.00 43.51          
ATOM    653  CE1 HSD   102      26.240  -3.681  10.695  1.00 46.54          
ATOM    654  NE2 HSD   102      25.078  -4.292  10.871  1.00 47.46          
ATOM    655  N   PHE   103      21.022   1.195  11.177  1.00 39.64          
ATOM    656  CA  PHE   103      20.691   2.585  11.422  1.00 36.08          
ATOM    657  C   PHE   103      21.808   3.521  11.969  1.00 34.98          
ATOM    658  O   PHE   103      21.927   4.629  11.453  1.00 34.66          
ATOM    659  CB  PHE   103      19.429   2.705  12.250  1.00 35.62          
ATOM    660  CG  PHE   103      18.673   3.983  12.020  1.00 34.35          
ATOM    661  CD1 PHE   103      17.616   4.315  12.819  1.00 34.67          
ATOM    662  CD2 PHE   103      19.014   4.860  10.982  1.00 33.50          
ATOM    663  CE1 PHE   103      16.877   5.498  12.565  1.00 36.44          
ATOM    664  CE2 PHE   103      18.290   6.055  10.746  1.00 33.77          
ATOM    665  CZ  PHE   103      17.243   6.376  11.508  1.00 33.22          
ATOM    666  N   HSD   104      22.598   3.136  12.980  1.00 33.95          
ATOM    667  CA  HSD   104      23.627   4.090  13.515  1.00 34.71          
ATOM    668  C   HSD   104      24.690   4.666  12.501  1.00 34.55          
ATOM    669  O   HSD   104      25.382   5.694  12.833  1.00 35.19          
ATOM    670  CB  HSD   104      24.334   3.600  14.802  1.00 34.12          
ATOM    671  CG  HSD   104      25.381   2.568  14.550  1.00 33.67          
ATOM    672  ND1 HSD   104      26.720   2.775  14.840  1.00 36.93          
ATOM    673  CD2 HSD   104      25.294   1.328  14.012  1.00 31.58          
ATOM    674  CE1 HSD   104      27.410   1.702  14.489  1.00 35.47          
ATOM    675  NE2 HSD   104      26.569   0.811  13.984  1.00 32.99          
ATOM    676  N   GLU   105      24.778   4.073  11.288  1.00 32.40          
ATOM    677  CA  GLU   105      25.748   4.484  10.276  1.00 30.25          
ATOM    678  C   GLU   105      25.276   5.484   9.245  1.00 27.86          
ATOM    679  O   GLU   105      26.103   5.998   8.467  1.00 27.71          
ATOM    680  CB  GLU   105      26.257   3.259   9.589  1.00 31.31          
ATOM    681  CG  GLU   105      26.505   2.202  10.636  1.00 34.56          
ATOM    682  CD  GLU   105      26.814   0.843  10.054  1.00 38.25          
ATOM    683  OE1 GLU   105      25.880   0.161   9.535  1.00 38.04          
ATOM    684  OE2 GLU   105      28.003   0.450  10.166  1.00 41.24          
ATOM    685  N   VAL   106      23.987   5.781   9.245  1.00 24.63          
ATOM    686  CA  VAL   106      23.439   6.831   8.393  1.00 24.31          
ATOM    687  C   VAL   106      24.181   8.165   8.602  1.00 23.93          
ATOM    688  O   VAL   106      24.841   8.717   7.690  1.00 26.52          
ATOM    689  CB  VAL   106      21.876   7.000   8.544  1.00 25.36          
ATOM    690  CG1 VAL   106      21.197   7.664   7.288  1.00 21.28          
ATOM    691  CG2 VAL   106      21.192   5.615   8.881  1.00 25.50          
ATOM    692  N   PRO   107      24.187   8.669   9.797  1.00 21.38          
ATOM    693  CA  PRO   107      24.981   9.825  10.038  1.00 19.87          
ATOM    694  C   PRO   107      26.338   9.827   9.351  1.00 18.46          
ATOM    695  O   PRO   107      26.623  10.763   8.703  1.00 16.39          
ATOM    696  CB  PRO   107      25.101   9.776  11.506  1.00 20.31          
ATOM    697  CG  PRO   107      23.732   9.356  11.883  1.00 20.20          
ATOM    698  CD  PRO   107      23.516   8.190  11.010  1.00 21.38          
ATOM    699  N   GLU   108      27.140   8.782   9.447  1.00 18.93          
ATOM    700  CA  GLU   108      28.395   8.687   8.631  1.00 20.48          
ATOM    701  C   GLU   108      28.280   8.933   7.080  1.00 20.01          
ATOM    702  O   GLU   108      29.235   9.273   6.408  1.00 19.49          
ATOM    703  CB  GLU   108      29.048   7.318   8.837  1.00 20.61          
ATOM    704  CG  GLU   108      30.506   7.376   9.264  1.00 25.10          
ATOM    705  CD  GLU   108      30.726   7.994  10.646  1.00 24.03          
ATOM    706  OE1 GLU   108      29.693   8.094  11.353  1.00 23.17          
ATOM    707  OE2 GLU   108      31.916   8.366  10.990  1.00 19.42          
ATOM    708  N   LEU   109      27.114   8.743   6.495  1.00 19.15          
ATOM    709  CA  LEU   109      27.001   9.063   5.095  1.00 18.15          
ATOM    710  C   LEU   109      27.305  10.541   4.832  1.00 18.39          
ATOM    711  O   LEU   109      27.993  10.910   3.869  1.00 19.79          
ATOM    712  CB  LEU   109      25.575   8.727   4.611  1.00 18.32          
ATOM    713  CG  LEU   109      25.292   7.449   3.761  1.00 13.74          
ATOM    714  CD1 LEU   109      26.274   6.224   3.964  1.00  5.50          
ATOM    715  CD2 LEU   109      23.938   7.173   4.170  1.00  7.55          
ATOM    716  N   PHE   110      26.784  11.400   5.687  1.00 17.00          
ATOM    717  CA  PHE   110      27.187  12.800   5.691  1.00 15.01          
ATOM    718  C   PHE   110      28.634  13.069   6.220  1.00 15.12          
ATOM    719  O   PHE   110      29.400  13.758   5.587  1.00 15.21          
ATOM    720  CB  PHE   110      26.145  13.590   6.434  1.00 14.03          
ATOM    721  CG  PHE   110      24.733  13.051   6.249  1.00 13.77          
ATOM    722  CD1 PHE   110      24.223  12.756   4.947  1.00 14.11          
ATOM    723  CD2 PHE   110      23.899  12.861   7.335  1.00 10.22          
ATOM    724  CE1 PHE   110      22.902  12.262   4.796  1.00 10.69          
ATOM    725  CE2 PHE   110      22.521  12.369   7.165  1.00  9.50          
ATOM    726  CZ  PHE   110      22.066  12.063   5.918  1.00 10.95          
ATOM    727  N   ARG   111      29.003  12.505   7.358  1.00 15.13          
ATOM    728  CA  ARG   111      30.144  12.914   8.062  1.00 15.28          
ATOM    729  C   ARG   111      31.270  12.319   7.334  1.00 16.62          
ATOM    730  O   ARG   111      32.272  12.077   7.904  1.00 19.94          
ATOM    731  CB  ARG   111      30.109  12.307   9.432  1.00 14.02          
ATOM    732  CG  ARG   111      29.653  13.267  10.394  1.00 18.60          
ATOM    733  CD  ARG   111      29.820  12.941  11.940  1.00 26.87          
ATOM    734  NE  ARG   111      28.561  13.406  12.583  1.00 37.30          
ATOM    735  CZ  ARG   111      28.135  13.260  13.881  1.00 40.61          
ATOM    736  NH1 ARG   111      28.971  12.738  14.802  1.00 43.89          
ATOM    737  NH2 ARG   111      26.869  13.661  14.248  1.00 33.22          
ATOM    738  N   GLN   112      31.130  11.989   6.076  1.00 17.88          
ATOM    739  CA  GLN   112      32.186  11.184   5.373  1.00 17.82          
ATOM    740  C   GLN   112      31.983  11.420   3.856  1.00 17.31          
ATOM    741  O   GLN   112      32.747  10.991   3.023  1.00 15.36          
ATOM    742  CB  GLN   112      31.937   9.741   5.757  1.00 17.77          
ATOM    743  CG  GLN   112      32.937   8.770   5.474  1.00 24.26          
ATOM    744  CD  GLN   112      33.366   8.058   6.771  1.00 35.06          
ATOM    745  OE1 GLN   112      33.030   6.873   7.039  1.00 37.92          
ATOM    746  NE2 GLN   112      34.084   8.803   7.608  1.00 39.62          
ATOM    747  N   GLY   113      30.903  12.130   3.528  1.00 16.69          
ATOM    748  CA  GLY   113      30.715  12.469   2.210  1.00 18.47          
ATOM    749  C   GLY   113      30.203  11.358   1.289  1.00 19.78          
ATOM    750  O   GLY   113      30.034  11.600   0.090  1.00 18.83          
ATOM    751  N   PHE   114      29.914  10.156   1.789  1.00 20.80          
ATOM    752  CA  PHE   114      29.070   9.234   0.972  1.00 21.04          
ATOM    753  C   PHE   114      27.861   9.905   0.309  1.00 20.89          
ATOM    754  O   PHE   114      27.619   9.654  -0.876  1.00 21.49          
ATOM    755  CB  PHE   114      28.643   8.031   1.736  1.00 20.73          
ATOM    756  CG  PHE   114      29.793   7.199   2.204  1.00 23.48          
ATOM    757  CD1 PHE   114      30.047   7.030   3.557  1.00 26.99          
ATOM    758  CD2 PHE   114      30.618   6.571   1.309  1.00 22.39          
ATOM    759  CE1 PHE   114      31.102   6.225   3.995  1.00 26.36          
ATOM    760  CE2 PHE   114      31.693   5.791   1.762  1.00 23.48          
ATOM    761  CZ  PHE   114      31.921   5.604   3.094  1.00 24.22          
ATOM    762  N   PHE   115      27.146  10.786   1.030  1.00 20.88          
ATOM    763  CA  PHE   115      26.104  11.678   0.402  1.00 20.11          
ATOM    764  C   PHE   115      26.458  13.165   0.639  1.00 19.79          
ATOM    765  O   PHE   115      26.158  13.701   1.704  1.00 18.54          
ATOM    766  CB  PHE   115      24.694  11.339   0.893  1.00 18.75          
ATOM    767  CG  PHE   115      23.614  12.121   0.220  1.00 17.79          
ATOM    768  CD1 PHE   115      22.906  13.095   0.935  1.00 11.55          
ATOM    769  CD2 PHE   115      23.258  11.855  -1.170  1.00 18.01          
ATOM    770  CE1 PHE   115      21.853  13.769   0.326  1.00 11.48          
ATOM    771  CE2 PHE   115      22.231  12.584  -1.838  1.00  9.11          
ATOM    772  CZ  PHE   115      21.551  13.539  -1.122  1.00 13.81          
ATOM    773  N   PRO   116      27.156  13.783  -0.344  1.00 20.18          
ATOM    774  CA  PRO   116      27.699  15.137  -0.181  1.00 20.41          
ATOM    775  C   PRO   116      26.586  16.146  -0.091  1.00 21.00          
ATOM    776  O   PRO   116      26.413  16.892  -1.001  1.00 22.72          
ATOM    777  CB  PRO   116      28.496  15.363  -1.481  1.00 19.12          
ATOM    778  CG  PRO   116      28.037  14.366  -2.418  1.00 18.64          
ATOM    779  CD  PRO   116      27.529  13.218  -1.669  1.00 19.31          
ATOM    780  N   LEU   117      25.833  16.143   0.993  1.00 21.68          
ATOM    781  CA  LEU   117      24.728  17.062   1.226  1.00 21.87          
ATOM    782  C   LEU   117      25.171  18.521   1.129  1.00 22.02          
ATOM    783  O   LEU   117      26.191  18.949   1.700  1.00 23.52          
ATOM    784  CB  LEU   117      24.089  16.710   2.580  1.00 21.33          
ATOM    785  CG  LEU   117      24.050  17.713   3.700  1.00 24.40          
ATOM    786  CD1 LEU   117      22.634  17.784   4.141  1.00 31.96          
ATOM    787  CD2 LEU   117      24.925  17.377   4.866  1.00 24.53          
ATOM    788  N   ASP   118      24.397  19.278   0.394  1.00 21.56          
ATOM    789  CA  ASP   118      24.654  20.659   0.241  1.00 22.59          
ATOM    790  C   ASP   118      23.768  21.520   1.197  1.00 21.72          
ATOM    791  O   ASP   118      24.257  22.550   1.778  1.00 22.08          
ATOM    792  CB  ASP   118      24.347  21.022  -1.238  1.00 24.09          
ATOM    793  CG  ASP   118      25.443  20.582  -2.208  1.00 29.34          
ATOM    794  OD1 ASP   118      26.680  20.684  -1.828  1.00 34.93          
ATOM    795  OD2 ASP   118      25.141  20.121  -3.366  1.00 31.49          
ATOM    796  N   VAL   119      22.470  21.152   1.275  1.00 19.14          
ATOM    797  CA  VAL   119      21.493  21.824   2.128  1.00 17.20          
ATOM    798  C   VAL   119      20.771  20.805   3.006  1.00 15.41          
ATOM    799  O   VAL   119      20.330  19.796   2.516  1.00 16.54          
ATOM    800  CB  VAL   119      20.432  22.694   1.298  1.00 17.99          
ATOM    801  CG1 VAL   119      20.314  22.252  -0.080  1.00 17.88          
ATOM    802  CG2 VAL   119      19.001  22.730   1.946  1.00 13.59          
ATOM    803  N   ALA   120      20.630  21.096   4.281  1.00 12.24          
ATOM    804  CA  ALA   120      19.855  20.289   5.176  1.00 10.62          
ATOM    805  C   ALA   120      18.527  21.002   5.483  1.00  9.86          
ATOM    806  O   ALA   120      18.526  22.100   5.999  1.00  8.76          
ATOM    807  CB  ALA   120      20.692  20.034   6.491  1.00  9.97          
ATOM    808  N   VAL   121      17.391  20.406   5.169  1.00 10.09          
ATOM    809  CA  VAL   121      16.119  21.058   5.473  1.00 11.02          
ATOM    810  C   VAL   121      15.448  20.408   6.667  1.00 12.46          
ATOM    811  O   VAL   121      15.012  19.311   6.521  1.00 14.42          
ATOM    812  CB  VAL   121      15.150  21.024   4.309  1.00 10.38          
ATOM    813  CG1 VAL   121      13.767  21.571   4.701  1.00  9.85          
ATOM    814  CG2 VAL   121      15.694  21.876   3.311  1.00  9.47          
ATOM    815  N   VAL   122      15.356  21.080   7.820  1.00 12.59          
ATOM    816  CA  VAL   122      14.867  20.526   9.051  1.00 12.88          
ATOM    817  C   VAL   122      13.730  21.322   9.628  1.00 14.40          
ATOM    818  O   VAL   122      13.502  22.504   9.312  1.00 14.88          
ATOM    819  CB  VAL   122      15.952  20.504  10.159  1.00 12.79          
ATOM    820  CG1 VAL   122      17.200  19.769   9.719  1.00 11.51          
ATOM    821  CG2 VAL   122      16.309  21.893  10.610  1.00 15.12          
ATOM    822  N   GLN   123      13.030  20.701  10.568  1.00 15.62          
ATOM    823  CA  GLN   123      11.940  21.434  11.196  1.00 15.39          
ATOM    824  C   GLN   123      12.242  21.681  12.667  1.00 15.45          
ATOM    825  O   GLN   123      11.961  20.837  13.393  1.00 18.31          
ATOM    826  CB  GLN   123      10.635  20.625  11.029  1.00 13.80          
ATOM    827  CG  GLN   123       9.477  21.212  11.740  1.00 13.25          
ATOM    828  CD  GLN   123       8.169  20.546  11.364  1.00 16.16          
ATOM    829  OE1 GLN   123       8.115  19.359  11.065  1.00 17.38          
ATOM    830  NE2 GLN   123       7.102  21.301  11.423  1.00 16.59          
ATOM    831  N   VAL   124      12.771  22.783  13.145  1.00 15.40          
ATOM    832  CA  VAL   124      12.923  22.898  14.619  1.00 15.56          
ATOM    833  C   VAL   124      11.836  23.644  15.304  1.00 16.06          
ATOM    834  O   VAL   124      10.858  24.071  14.659  1.00 16.47          
ATOM    835  CB  VAL   124      14.146  23.663  14.939  1.00 15.79          
ATOM    836  CG1 VAL   124      15.330  22.842  14.450  1.00 17.89          
ATOM    837  CG2 VAL   124      14.108  25.044  14.165  1.00 16.01          
ATOM    838  N   SER   125      12.075  23.893  16.594  1.00 16.31          
ATOM    839  CA  SER   125      11.141  24.591  17.487  1.00 16.64          
ATOM    840  C   SER   125      11.526  26.068  17.720  1.00 18.84          
ATOM    841  O   SER   125      12.624  26.536  17.326  1.00 17.98          
ATOM    842  CB  SER   125      11.262  23.984  18.839  1.00 16.62          
ATOM    843  OG  SER   125      12.189  24.785  19.591  1.00 12.33          
ATOM    844  N   THR   126      10.657  26.814  18.426  1.00 20.67          
ATOM    845  CA  THR   126      11.023  28.199  18.726  1.00 21.55          
ATOM    846  C   THR   126      12.234  28.251  19.672  1.00 23.18          
ATOM    847  O   THR   126      12.262  27.529  20.676  1.00 23.07          
ATOM    848  CB  THR   126       9.869  28.974  19.298  1.00 20.93          
ATOM    849  OG1 THR   126       9.083  28.150  20.168  1.00 20.40          
ATOM    850  CG2 THR   126       8.902  29.330  18.190  1.00 24.14          
ATOM    851  N   PRO   127      13.209  29.117  19.354  1.00 24.24          
ATOM    852  CA  PRO   127      14.437  29.287  20.151  1.00 24.55          
ATOM    853  C   PRO   127      14.124  29.909  21.448  1.00 25.49          
ATOM    854  O   PRO   127      13.047  30.447  21.648  1.00 24.73          
ATOM    855  CB  PRO   127      15.256  30.320  19.388  1.00 24.89          
ATOM    856  CG  PRO   127      14.265  31.103  18.573  1.00 25.24          
ATOM    857  CD  PRO   127      13.128  30.088  18.246  1.00 24.52          
ATOM    858  N   ASN   128      15.091  29.820  22.337  1.00 27.55          
ATOM    859  CA  ASN   128      14.846  30.026  23.750  1.00 28.19          
ATOM    860  C   ASN   128      15.588  31.326  24.003  1.00 28.67          
ATOM    861  O   ASN   128      16.014  31.973  23.060  1.00 27.46          
ATOM    862  CB  ASN   128      15.434  28.869  24.555  1.00 27.90          
ATOM    863  CG  ASN   128      16.940  28.934  24.603  1.00 28.56          
ATOM    864  OD1 ASN   128      17.514  29.994  24.416  1.00 28.71          
ATOM    865  ND2 ASN   128      17.584  27.826  24.869  1.00 26.96          
ATOM    866  N   GLU   129      15.779  31.677  25.273  1.00 30.18          
ATOM    867  CA  GLU   129      16.221  33.036  25.626  1.00 30.26          
ATOM    868  C   GLU   129      17.646  33.356  25.096  1.00 30.65          
ATOM    869  O   GLU   129      18.036  34.542  24.994  1.00 30.34          
ATOM    870  CB  GLU   129      16.147  33.194  27.130  1.00 29.31          
ATOM    871  CG  GLU   129      16.185  34.609  27.604  1.00 30.83          
ATOM    872  CD  GLU   129      16.353  34.669  29.113  1.00 35.69          
ATOM    873  OE1 GLU   129      16.477  35.820  29.667  1.00 36.25          
ATOM    874  OE2 GLU   129      16.378  33.560  29.745  1.00 31.69          
ATOM    875  N   GLU   130      18.414  32.290  24.782  1.00 30.58          
ATOM    876  CA  GLU   130      19.783  32.393  24.235  1.00 29.90          
ATOM    877  C   GLU   130      19.867  32.157  22.734  1.00 28.66          
ATOM    878  O   GLU   130      20.944  31.956  22.226  1.00 29.16          
ATOM    879  CB  GLU   130      20.740  31.439  24.942  1.00 29.97          
ATOM    880  CG  GLU   130      20.840  31.736  26.427  1.00 35.17          
ATOM    881  CD  GLU   130      19.855  30.894  27.249  1.00 45.59          
ATOM    882  OE1 GLU   130      20.365  30.058  28.058  1.00 47.60          
ATOM    883  OE2 GLU   130      18.579  31.022  27.071  1.00 48.61          
ATOM    884  N   GLY   131      18.746  32.131  22.028  1.00 26.74          
ATOM    885  CA  GLY   131      18.798  31.931  20.627  1.00 25.05          
ATOM    886  C   GLY   131      19.022  30.504  20.208  1.00 24.50          
ATOM    887  O   GLY   131      19.489  30.225  19.092  1.00 25.31          
ATOM    888  N   TYR   132      18.675  29.575  21.073  1.00 24.19          
ATOM    889  CA  TYR   132      18.951  28.162  20.788  1.00 23.06          
ATOM    890  C   TYR   132      17.619  27.506  20.439  1.00 21.93          
ATOM    891  O   TYR   132      16.687  27.574  21.196  1.00 21.69          
ATOM    892  CB  TYR   132      19.646  27.495  21.999  1.00 22.21          
ATOM    893  CG  TYR   132      21.180  27.520  21.991  1.00 23.03          
ATOM    894  CD1 TYR   132      21.955  28.208  22.987  1.00 24.43          
ATOM    895  CD2 TYR   132      21.870  26.813  21.035  1.00 23.82          
ATOM    896  CE1 TYR   132      23.378  28.202  22.931  1.00 19.96          
ATOM    897  CE2 TYR   132      23.233  26.807  20.990  1.00 22.16          
ATOM    898  CZ  TYR   132      23.984  27.500  21.894  1.00 22.00          
ATOM    899  OH  TYR   132      25.360  27.397  21.663  1.00 26.15          
ATOM    900  N   CYS   133      17.525  26.921  19.272  1.00 21.73          
ATOM    901  CA  CYS   133      16.395  26.048  18.987  1.00 22.78          
ATOM    902  C   CYS   133      16.719  24.568  19.154  1.00 23.84          
ATOM    903  O   CYS   133      17.919  24.131  19.162  1.00 23.34          
ATOM    904  CB  CYS   133      16.021  26.174  17.531  1.00 23.06          
ATOM    905  SG  CYS   133      15.583  27.815  16.949  1.00 18.90          
ATOM    906  N   SER   134      15.633  23.799  19.168  1.00 23.44          
ATOM    907  CA  SER   134      15.692  22.363  19.467  1.00 24.05          
ATOM    908  C   SER   134      15.224  21.636  18.303  1.00 22.22          
ATOM    909  O   SER   134      14.246  22.082  17.669  1.00 22.62          
ATOM    910  CB  SER   134      14.695  21.931  20.615  1.00 25.98          
ATOM    911  OG  SER   134      14.539  20.487  20.661  1.00 31.24          
ATOM    912  N   PHE   135      15.813  20.461  18.099  1.00 20.16          
ATOM    913  CA  PHE   135      15.357  19.609  17.036  1.00 18.92          
ATOM    914  C   PHE   135      14.006  19.013  17.358  1.00 19.00          
ATOM    915  O   PHE   135      13.405  18.409  16.488  1.00 19.70          
ATOM    916  CB  PHE   135      16.409  18.580  16.672  1.00 17.97          
ATOM    917  CG  PHE   135      17.510  19.170  15.847  1.00 18.79          
ATOM    918  CD1 PHE   135      18.763  19.422  16.393  1.00 19.67          
ATOM    919  CD2 PHE   135      17.278  19.566  14.543  1.00 15.91          
ATOM    920  CE1 PHE   135      19.736  20.064  15.634  1.00 16.32          
ATOM    921  CE2 PHE   135      18.248  20.167  13.801  1.00 13.09          
ATOM    922  CZ  PHE   135      19.466  20.430  14.345  1.00 15.02          
ATOM    923  N   GLY   136      13.531  19.183  18.592  1.00 18.14          
ATOM    924  CA  GLY   136      12.240  18.625  19.026  1.00 18.20          
ATOM    925  C   GLY   136      12.198  17.108  19.020  1.00 18.91          
ATOM    926  O   GLY   136      13.002  16.412  19.708  1.00 19.82          
ATOM    927  N   VAL   137      11.278  16.588  18.211  1.00 18.95          
ATOM    928  CA  VAL   137      10.967  15.128  18.133  1.00 18.28          
ATOM    929  C   VAL   137      11.880  14.255  17.194  1.00 18.95          
ATOM    930  O   VAL   137      11.637  13.068  16.950  1.00 18.11          
ATOM    931  CB  VAL   137       9.449  14.883  17.900  1.00 17.64          
ATOM    932  CG1 VAL   137       8.590  15.861  18.745  1.00 12.71          
ATOM    933  CG2 VAL   137       9.109  15.027  16.446  1.00 18.29          
ATOM    934  N   SER   138      12.956  14.861  16.707  1.00 20.84          
ATOM    935  CA  SER   138      13.888  14.173  15.766  1.00 22.85          
ATOM    936  C   SER   138      15.374  14.575  15.896  1.00 23.16          
ATOM    937  O   SER   138      15.773  15.680  15.516  1.00 23.06          
ATOM    938  CB  SER   138      13.438  14.456  14.351  1.00 21.83          
ATOM    939  OG  SER   138      12.890  13.287  13.869  1.00 26.22          
ATOM    940  N   CYS   139      16.188  13.727  16.481  1.00 23.29          
ATOM    941  CA  CYS   139      17.574  14.098  16.526  1.00 24.70          
ATOM    942  C   CYS   139      18.236  13.271  15.411  1.00 26.43          
ATOM    943  O   CYS   139      18.812  13.816  14.441  1.00 26.23          
ATOM    944  CB  CYS   139      18.085  13.700  17.864  1.00 24.45          
ATOM    945  SG  CYS   139      19.615  14.510  18.126  1.00 25.47          
ATOM    946  N   ASP   140      18.026  11.941  15.555  1.00 26.42          
ATOM    947  CA  ASP   140      18.506  10.870  14.707  1.00 26.20          
ATOM    948  C   ASP   140      19.564  11.222  13.710  1.00 23.76          
ATOM    949  O   ASP   140      20.729  11.330  14.113  1.00 24.78          
ATOM    950  CB  ASP   140      17.336  10.194  14.057  1.00 28.14          
ATOM    951  CG  ASP   140      16.414  11.161  13.488  1.00 32.82          
ATOM    952  OD1 ASP   140      16.765  11.780  12.435  1.00 39.32          
ATOM    953  OD2 ASP   140      15.322  11.394  14.061  1.00 39.64          
ATOM    954  N   TYR   141      19.211  11.388  12.436  1.00 21.00          
ATOM    955  CA  TYR   141      20.283  11.667  11.411  1.00 19.84          
ATOM    956  C   TYR   141      20.189  13.104  11.015  1.00 19.27          
ATOM    957  O   TYR   141      21.051  13.644  10.273  1.00 18.41          
ATOM    958  CB  TYR   141      20.164  10.847  10.148  1.00 16.80          
ATOM    959  CG  TYR   141      18.904  11.130   9.367  1.00 16.14          
ATOM    960  CD1 TYR   141      18.818  12.162   8.478  1.00 16.72          
ATOM    961  CD2 TYR   141      17.824  10.297   9.429  1.00 16.49          
ATOM    962  CE1 TYR   141      17.677  12.362   7.738  1.00 10.84          
ATOM    963  CE2 TYR   141      16.681  10.515   8.653  1.00 10.95          
ATOM    964  CZ  TYR   141      16.636  11.530   7.839  1.00  9.36          
ATOM    965  OH  TYR   141      15.508  11.704   7.102  1.00 11.32          
ATOM    966  N   THR   142      19.080  13.668  11.475  1.00 17.87          
ATOM    967  CA  THR   142      18.778  14.980  11.145  1.00 17.85          
ATOM    968  C   THR   142      19.725  15.996  11.819  1.00 18.00          
ATOM    969  O   THR   142      19.997  17.028  11.253  1.00 19.61          
ATOM    970  CB  THR   142      17.254  15.309  11.291  1.00 17.60          
ATOM    971  OG1 THR   142      17.156  16.571  11.939  1.00 19.55          
ATOM    972  CG2 THR   142      16.472  14.397  12.260  1.00 17.10          
ATOM    973  N   LYS   143      20.283  15.767  12.978  1.00 17.42          
ATOM    974  CA  LYS   143      21.132  16.809  13.465  1.00 17.24          
ATOM    975  C   LYS   143      22.517  16.705  12.840  1.00 19.48          
ATOM    976  O   LYS   143      23.206  17.758  12.593  1.00 20.96          
ATOM    977  CB  LYS   143      21.246  16.696  14.945  1.00 18.19          
ATOM    978  CG  LYS   143      22.396  17.366  15.585  1.00 16.62          
ATOM    979  CD  LYS   143      22.112  17.500  17.025  1.00 17.82          
ATOM    980  CE  LYS   143      22.835  18.679  17.624  1.00 18.92          
ATOM    981  NZ  LYS   143      24.242  18.354  17.910  1.00 22.90          
ATOM    982  N   ALA   144      22.971  15.471  12.592  1.00 19.01          
ATOM    983  CA  ALA   144      24.229  15.316  11.921  1.00 18.19          
ATOM    984  C   ALA   144      24.198  15.976  10.551  1.00 18.75          
ATOM    985  O   ALA   144      25.170  16.556  10.065  1.00 20.71          
ATOM    986  CB  ALA   144      24.488  13.935  11.770  1.00 19.18          
ATOM    987  N   ALA   145      23.092  15.850   9.871  1.00 19.25          
ATOM    988  CA  ALA   145      22.936  16.461   8.549  1.00 18.85          
ATOM    989  C   ALA   145      23.077  17.966   8.699  1.00 18.61          
ATOM    990  O   ALA   145      23.931  18.553   7.996  1.00 17.90          
ATOM    991  CB  ALA   145      21.562  16.099   7.967  1.00 18.76          
ATOM    992  N   ALA   146      22.277  18.571   9.619  1.00 17.80          
ATOM    993  CA  ALA   146      22.363  20.043   9.869  1.00 18.04          
ATOM    994  C   ALA   146      23.815  20.449  10.094  1.00 18.51          
ATOM    995  O   ALA   146      24.307  21.417   9.470  1.00 19.27          
ATOM    996  CB  ALA   146      21.499  20.531  10.945  1.00 15.61          
ATOM    997  N   GLU   147      24.533  19.661  10.874  1.00 19.41          
ATOM    998  CA  GLU   147      25.971  19.938  11.053  1.00 21.68          
ATOM    999  C   GLU   147      26.876  19.824   9.829  1.00 20.89          
ATOM   1000  O   GLU   147      27.945  20.313   9.888  1.00 19.85          
ATOM   1001  CB  GLU   147      26.592  19.040  12.132  1.00 23.11          
ATOM   1002  CG  GLU   147      26.536  19.530  13.535  1.00 24.22          
ATOM   1003  CD  GLU   147      26.466  18.358  14.479  1.00 29.86          
ATOM   1004  OE1 GLU   147      25.673  18.527  15.426  1.00 35.07          
ATOM   1005  OE2 GLU   147      27.161  17.287  14.308  1.00 30.64          
ATOM   1006  N   CYS   148      26.483  19.123   8.785  1.00 22.37          
ATOM   1007  CA  CYS   148      27.398  18.832   7.656  1.00 24.38          
ATOM   1008  C   CYS   148      27.021  19.582   6.350  1.00 24.22          
ATOM   1009  O   CYS   148      27.660  19.406   5.319  1.00 25.63          
ATOM   1010  CB  CYS   148      27.470  17.303   7.426  1.00 23.85          
ATOM   1011  SG  CYS   148      28.622  16.453   8.559  1.00 31.79          
ATOM   1012  N   ALA   149      25.935  20.351   6.404  1.00 23.94          
ATOM   1013  CA  ALA   149      25.414  21.093   5.314  1.00 23.23          
ATOM   1014  C   ALA   149      25.914  22.531   5.509  1.00 24.24          
ATOM   1015  O   ALA   149      25.696  23.099   6.579  1.00 24.08          
ATOM   1016  CB  ALA   149      23.941  21.062   5.384  1.00 22.60          
ATOM   1017  N   PRO   150      26.578  23.128   4.483  1.00 25.66          
ATOM   1018  CA  PRO   150      26.808  24.603   4.437  1.00 24.43          
ATOM   1019  C   PRO   150      25.561  25.480   4.339  1.00 23.53          
ATOM   1020  O   PRO   150      25.708  26.683   4.463  1.00 25.61          
ATOM   1021  CB  PRO   150      27.668  24.818   3.170  1.00 22.89          
ATOM   1022  CG  PRO   150      27.554  23.590   2.334  1.00 23.95          
ATOM   1023  CD  PRO   150      27.174  22.475   3.274  1.00 26.29          
ATOM   1024  N   VAL   151      24.372  24.946   4.071  1.00 21.29          
ATOM   1025  CA  VAL   151      23.180  25.795   4.031  1.00 17.99          
ATOM   1026  C   VAL   151      22.162  24.971   4.742  1.00 18.46          
ATOM   1027  O   VAL   151      21.912  23.781   4.361  1.00 19.48          
ATOM   1028  CB  VAL   151      22.657  25.924   2.605  1.00 17.33          
ATOM   1029  CG1 VAL   151      21.255  26.558   2.549  1.00 14.93          
ATOM   1030  CG2 VAL   151      23.588  26.649   1.769  1.00 13.48          
ATOM   1031  N   VAL   152      21.534  25.569   5.736  1.00 16.17          
ATOM   1032  CA  VAL   152      20.536  24.866   6.539  1.00 13.98          
ATOM   1033  C   VAL   152      19.181  25.606   6.532  1.00 14.89          
ATOM   1034  O   VAL   152      19.049  26.764   6.996  1.00 14.57          
ATOM   1035  CB  VAL   152      21.050  24.798   7.996  1.00 12.99          
ATOM   1036  CG1 VAL   152      20.085  24.048   8.889  1.00 12.19          
ATOM   1037  CG2 VAL   152      22.326  24.184   7.987  1.00  9.30          
ATOM   1038  N   VAL   153      18.147  24.953   6.041  1.00 15.48          
ATOM   1039  CA  VAL   153      16.867  25.635   5.989  1.00 17.02          
ATOM   1040  C   VAL   153      15.963  25.140   7.136  1.00 18.29          
ATOM   1041  O   VAL   153      15.552  24.005   7.120  1.00 19.12          
ATOM   1042  CB  VAL   153      16.236  25.348   4.673  1.00 16.72          
ATOM   1043  CG1 VAL   153      14.927  26.090   4.559  1.00 18.64          
ATOM   1044  CG2 VAL   153      17.185  25.738   3.527  1.00 18.16          
ATOM   1045  N   ALA   154      15.638  25.950   8.129  1.00 18.91          
ATOM   1046  CA  ALA   154      14.904  25.394   9.234  1.00 19.52          
ATOM   1047  C   ALA   154      13.489  25.974   9.257  1.00 20.86          
ATOM   1048  O   ALA   154      13.367  27.202   9.222  1.00 22.16          
ATOM   1049  CB  ALA   154      15.557  25.748  10.464  1.00 19.46          
ATOM   1050  N   GLU   155      12.440  25.149   9.350  1.00 19.73          
ATOM   1051  CA  GLU   155      11.142  25.696   9.470  1.00 21.58          
ATOM   1052  C   GLU   155      11.021  25.869  10.919  1.00 19.47          
ATOM   1053  O   GLU   155      11.120  24.947  11.678  1.00 19.01          
ATOM   1054  CB  GLU   155      10.079  24.694   9.039  1.00 22.03          
ATOM   1055  CG  GLU   155       9.993  24.343   7.556  1.00 26.27          
ATOM   1056  CD  GLU   155       8.939  23.210   7.208  1.00 30.22          
ATOM   1057  OE1 GLU   155       8.976  22.709   6.010  1.00 42.45          
ATOM   1058  OE2 GLU   155       8.034  22.804   8.047  1.00 37.34          
ATOM   1059  N   VAL   156      10.796  27.078  11.352  1.00 21.02          
ATOM   1060  CA  VAL   156      10.622  27.332  12.800  1.00 21.50          
ATOM   1061  C   VAL   156       9.167  27.129  13.312  1.00 21.92          
ATOM   1062  O   VAL   156       8.252  27.892  13.008  1.00 21.03          
ATOM   1063  CB  VAL   156      11.225  28.674  13.196  1.00 21.55          
ATOM   1064  CG1 VAL   156      10.880  28.992  14.677  1.00 22.51          
ATOM   1065  CG2 VAL   156      12.727  28.613  12.926  1.00 16.93          
ATOM   1066  N   ASN   157       8.958  26.063  14.060  1.00 22.59          
ATOM   1067  CA  ASN   157       7.625  25.741  14.313  1.00 24.43          
ATOM   1068  C   ASN   157       7.226  26.050  15.753  1.00 26.39          
ATOM   1069  O   ASN   157       7.828  25.550  16.764  1.00 27.35          
ATOM   1070  CB  ASN   157       7.345  24.337  13.894  1.00 24.46          
ATOM   1071  CG  ASN   157       5.874  24.071  13.767  1.00 26.49          
ATOM   1072  OD1 ASN   157       5.034  24.852  14.287  1.00 28.44          
ATOM   1073  ND2 ASN   157       5.526  22.945  13.133  1.00 21.74          
ATOM   1074  N   LYS   158       6.239  26.960  15.825  1.00 27.58          
ATOM   1075  CA  LYS   158       5.632  27.380  17.105  1.00 28.93          
ATOM   1076  C   LYS   158       4.977  26.190  17.819  1.00 28.37          
ATOM   1077  O   LYS   158       4.887  26.195  19.027  1.00 27.48          
ATOM   1078  CB  LYS   158       4.718  28.631  16.978  1.00 28.34          
ATOM   1079  CG  LYS   158       5.611  29.909  17.015  1.00 30.85          
ATOM   1080  CD  LYS   158       4.948  31.311  17.260  1.00 30.90          
ATOM   1081  CE  LYS   158       5.969  32.508  17.006  1.00 31.70          
ATOM   1082  NZ  LYS   158       7.013  32.147  15.925  1.00 35.55          
ATOM   1083  N   GLN   159       4.606  25.151  17.055  1.00 28.17          
ATOM   1084  CA  GLN   159       4.067  23.923  17.606  1.00 27.02          
ATOM   1085  C   GLN   159       5.144  22.846  17.949  1.00 27.08          
ATOM   1086  O   GLN   159       4.848  21.918  18.739  1.00 27.82          
ATOM   1087  CB  GLN   159       3.078  23.313  16.614  1.00 27.34          
ATOM   1088  CG  GLN   159       1.703  22.996  17.150  1.00 27.80          
ATOM   1089  CD  GLN   159       0.772  24.031  16.653  1.00 33.22          
ATOM   1090  OE1 GLN   159      -0.370  23.755  16.203  1.00 33.35          
ATOM   1091  NE2 GLN   159       1.280  25.280  16.653  1.00 36.16          
ATOM   1092  N   MET   160       6.347  22.903  17.353  1.00 25.88          
ATOM   1093  CA  MET   160       7.386  21.845  17.611  1.00 25.34          
ATOM   1094  C   MET   160       7.778  21.930  19.071  1.00 24.46          
ATOM   1095  O   MET   160       8.170  23.003  19.496  1.00 26.22          
ATOM   1096  CB  MET   160       8.668  22.042  16.755  1.00 24.93          
ATOM   1097  CG  MET   160       9.740  20.980  17.040  1.00 24.68          
ATOM   1098  SD  MET   160       9.176  19.242  16.659  1.00 23.44          
ATOM   1099  CE  MET   160       9.043  19.227  14.917  1.00 19.19          
ATOM   1100  N   PRO   161       7.662  20.855  19.841  1.00 23.35          
ATOM   1101  CA  PRO   161       8.119  20.823  21.233  1.00 22.79          
ATOM   1102  C   PRO   161       9.625  21.005  21.437  1.00 22.30          
ATOM   1103  O   PRO   161      10.420  20.714  20.561  1.00 23.57          
ATOM   1104  CB  PRO   161       7.755  19.392  21.686  1.00 21.47          
ATOM   1105  CG  PRO   161       7.524  18.686  20.542  1.00 19.58          
ATOM   1106  CD  PRO   161       7.060  19.573  19.471  1.00 23.05          
ATOM   1107  N   PHE   162       9.990  21.426  22.622  1.00 21.22          
ATOM   1108  CA  PHE   162      11.339  21.685  22.930  1.00 21.01          
ATOM   1109  C   PHE   162      11.746  20.594  23.835  1.00 20.93          
ATOM   1110  O   PHE   162      11.219  20.503  24.944  1.00 21.80          
ATOM   1111  CB  PHE   162      11.466  23.011  23.703  1.00 20.75          
ATOM   1112  CG  PHE   162      12.899  23.533  23.791  1.00 19.93          
ATOM   1113  CD1 PHE   162      13.768  23.102  24.808  1.00 17.51          
ATOM   1114  CD2 PHE   162      13.381  24.433  22.859  1.00 17.17          
ATOM   1115  CE1 PHE   162      15.075  23.556  24.901  1.00 13.11          
ATOM   1116  CE2 PHE   162      14.696  24.890  22.959  1.00 15.14          
ATOM   1117  CZ  PHE   162      15.530  24.434  23.989  1.00 15.27          
ATOM   1118  N   ILE   163      12.751  19.848  23.393  1.00 20.22          
ATOM   1119  CA  ILE   163      13.323  18.717  24.091  1.00 19.54          
ATOM   1120  C   ILE   163      14.853  18.812  24.048  1.00 19.75          
ATOM   1121  O   ILE   163      15.481  19.251  23.033  1.00 21.15          
ATOM   1122  CB  ILE   163      12.900  17.476  23.333  1.00 20.43          
ATOM   1123  CG1 ILE   163      11.399  17.482  23.110  1.00 19.47          
ATOM   1124  CG2 ILE   163      13.442  16.181  23.976  1.00 20.22          
ATOM   1125  CD  ILE   163      11.029  16.242  22.508  1.00 21.66          
ATOM   1126  N   GLY   164      15.469  18.326  25.113  1.00 18.95          
ATOM   1127  CA  GLY   164      16.845  18.694  25.433  1.00 18.83          
ATOM   1128  C   GLY   164      17.693  17.518  25.152  1.00 19.30          
ATOM   1129  O   GLY   164      17.318  16.726  24.310  1.00 20.68          
ATOM   1130  N   GLY   165      18.788  17.359  25.885  1.00 19.83          
ATOM   1131  CA  GLY   165      19.840  16.463  25.462  1.00 21.72          
ATOM   1132  C   GLY   165      20.661  17.128  24.369  1.00 23.35          
ATOM   1133  O   GLY   165      20.704  18.358  24.256  1.00 24.93          
ATOM   1134  N   GLU   166      21.337  16.363  23.538  1.00 24.18          
ATOM   1135  CA  GLU   166      22.208  16.992  22.527  1.00 24.79          
ATOM   1136  C   GLU   166      21.375  17.280  21.318  1.00 24.31          
ATOM   1137  O   GLU   166      21.695  16.791  20.227  1.00 24.49          
ATOM   1138  CB  GLU   166      23.222  16.006  22.049  1.00 24.54          
ATOM   1139  CG  GLU   166      24.643  16.290  22.306  1.00 29.30          
ATOM   1140  CD  GLU   166      25.439  15.463  21.311  1.00 42.20          
ATOM   1141  OE1 GLU   166      25.175  15.546  20.046  1.00 41.81          
ATOM   1142  OE2 GLU   166      26.300  14.676  21.804  1.00 49.52          
ATOM   1143  N   ASN   167      20.326  18.080  21.509  1.00 23.27          
ATOM   1144  CA  ASN   167      19.279  18.257  20.542  1.00 21.97          
ATOM   1145  C   ASN   167      19.091  19.713  20.174  1.00 22.25          
ATOM   1146  O   ASN   167      17.977  20.139  19.849  1.00 25.00          
ATOM   1147  CB  ASN   167      17.979  17.780  21.169  1.00 21.48          
ATOM   1148  CG  ASN   167      17.001  17.363  20.138  1.00 21.78          
ATOM   1149  OD1 ASN   167      17.359  17.264  18.920  1.00 15.30          
ATOM   1150  ND2 ASN   167      15.754  17.147  20.568  1.00 19.59          
ATOM   1151  N   LEU   168      20.129  20.527  20.241  1.00 21.23          
ATOM   1152  CA  LEU   168      19.919  21.962  20.025  1.00 20.24          
ATOM   1153  C   LEU   168      20.632  22.419  18.782  1.00 19.92          
ATOM   1154  O   LEU   168      21.598  21.779  18.361  1.00 17.81          
ATOM   1155  CB  LEU   168      20.424  22.773  21.203  1.00 19.14          
ATOM   1156  CG  LEU   168      19.503  22.952  22.392  1.00 20.97          
ATOM   1157  CD1 LEU   168      18.606  21.740  22.630  1.00 16.95          
ATOM   1158  CD2 LEU   168      20.358  23.340  23.631  1.00 19.33          
ATOM   1159  N   ILE   169      20.183  23.553  18.242  1.00 20.20          
ATOM   1160  CA  ILE   169      20.900  24.196  17.166  1.00 21.27          
ATOM   1161  C   ILE   169      20.722  25.707  17.250  1.00 22.49          
ATOM   1162  O   ILE   169      19.613  26.255  17.411  1.00 23.19          
ATOM   1163  CB  ILE   169      20.421  23.586  15.830  1.00 21.73          
ATOM   1164  CG1 ILE   169      21.413  23.792  14.690  1.00 19.61          
ATOM   1165  CG2 ILE   169      18.925  24.009  15.476  1.00 23.60          
ATOM   1166  CD  ILE   169      21.421  25.127  14.212  1.00 22.53          
ATOM   1167  N   HSD   170      21.819  26.411  17.198  1.00 24.09          
ATOM   1168  CA  HSD   170      21.703  27.841  17.402  1.00 25.34          
ATOM   1169  C   HSD   170      21.152  28.538  16.170  1.00 25.98          
ATOM   1170  O   HSD   170      21.343  28.069  15.017  1.00 25.67          
ATOM   1171  CB  HSD   170      23.026  28.463  17.804  1.00 25.01          
ATOM   1172  CG  HSD   170      22.896  29.896  18.196  1.00 26.77          
ATOM   1173  ND1 HSD   170      22.530  30.292  19.466  1.00 28.68          
ATOM   1174  CD2 HSD   170      23.069  31.034  17.483  1.00 27.59          
ATOM   1175  CE1 HSD   170      22.492  31.611  19.518  1.00 26.52          
ATOM   1176  NE2 HSD   170      22.819  32.082  18.327  1.00 28.10          
ATOM   1177  N   ILE   171      20.485  29.674  16.440  1.00 25.94          
ATOM   1178  CA  ILE   171      19.861  30.502  15.397  1.00 25.57          
ATOM   1179  C   ILE   171      20.873  30.953  14.363  1.00 24.91          
ATOM   1180  O   ILE   171      20.562  31.022  13.200  1.00 24.88          
ATOM   1181  CB  ILE   171      18.923  31.654  16.007  1.00 25.97          
ATOM   1182  CG1 ILE   171      17.767  31.873  15.093  1.00 26.98          
ATOM   1183  CG2 ILE   171      19.541  33.035  16.219  1.00 27.16          
ATOM   1184  CD  ILE   171      16.891  30.707  15.149  1.00 32.18          
ATOM   1185  N   SER   172      22.105  31.202  14.791  1.00 24.61          
ATOM   1186  CA  SER   172      23.091  31.642  13.864  1.00 25.07          
ATOM   1187  C   SER   172      23.529  30.580  12.843  1.00 24.49          
ATOM   1188  O   SER   172      24.073  30.947  11.846  1.00 25.60          
ATOM   1189  CB  SER   172      24.212  32.523  14.520  1.00 26.28          
ATOM   1190  OG  SER   172      25.013  31.895  15.544  1.00 30.35          
ATOM   1191  N   LYS   173      23.195  29.297  13.012  1.00 23.99          
ATOM   1192  CA  LYS   173      23.615  28.229  12.029  1.00 23.35          
ATOM   1193  C   LYS   173      22.552  27.988  10.940  1.00 22.52          
ATOM   1194  O   LYS   173      22.690  27.140  10.007  1.00 23.10          
ATOM   1195  CB  LYS   173      24.044  26.900  12.756  1.00 22.36          
ATOM   1196  CG  LYS   173      25.030  27.120  13.971  1.00 22.97          
ATOM   1197  CD  LYS   173      26.385  27.955  13.580  1.00 20.95          
ATOM   1198  CE  LYS   173      27.133  28.515  14.803  1.00 25.64          
ATOM   1199  NZ  LYS   173      27.243  27.701  16.215  1.00 24.64          
ATOM   1200  N   LEU   174      21.485  28.752  11.073  1.00 21.22          
ATOM   1201  CA  LEU   174      20.372  28.700  10.153  1.00 20.49          
ATOM   1202  C   LEU   174      20.497  29.769   9.082  1.00 21.14          
ATOM   1203  O   LEU   174      20.691  30.910   9.380  1.00 21.36          
ATOM   1204  CB  LEU   174      19.072  28.899  10.942  1.00 20.44          
ATOM   1205  CG  LEU   174      18.450  27.694  11.686  1.00 16.86          
ATOM   1206  CD1 LEU   174      19.454  26.826  12.254  1.00 12.70          
ATOM   1207  CD2 LEU   174      17.457  28.134  12.773  1.00 17.70          
ATOM   1208  N   THR   175      20.439  29.370   7.828  1.00 22.22          
ATOM   1209  CA  THR   175      20.588  30.291   6.696  1.00 23.00          
ATOM   1210  C   THR   175      19.296  30.977   6.334  1.00 23.14          
ATOM   1211  O   THR   175      19.315  32.146   6.000  1.00 23.72          
ATOM   1212  CB  THR   175      20.965  29.494   5.460  1.00 22.65          
ATOM   1213  OG1 THR   175      22.027  28.627   5.802  1.00 25.26          
ATOM   1214  CG2 THR   175      21.563  30.342   4.418  1.00 21.90          
ATOM   1215  N   HSD   176      18.207  30.206   6.277  1.00 23.01          
ATOM   1216  CA  HSD   176      16.901  30.717   5.951  1.00 23.07          
ATOM   1217  C   HSD   176      15.949  30.152   7.005  1.00 22.90          
ATOM   1218  O   HSD   176      16.045  28.948   7.373  1.00 24.29          
ATOM   1219  CB  HSD   176      16.463  30.309   4.538  1.00 23.81          
ATOM   1220  CG  HSD   176      17.498  30.546   3.468  1.00 27.13          
ATOM   1221  ND1 HSD   176      18.397  29.570   3.062  1.00 29.55          
ATOM   1222  CD2 HSD   176      17.748  31.633   2.696  1.00 30.13          
ATOM   1223  CE1 HSD   176      19.177  30.059   2.116  1.00 30.17          
ATOM   1224  NE2 HSD   176      18.802  31.306   1.865  1.00 30.24          
ATOM   1225  N   ILE   177      15.072  31.011   7.539  1.00 20.90          
ATOM   1226  CA  ILE   177      14.152  30.558   8.564  1.00 18.66          
ATOM   1227  C   ILE   177      12.799  30.796   8.018  1.00 18.39          
ATOM   1228  O   ILE   177      12.513  31.881   7.551  1.00 18.22          
ATOM   1229  CB  ILE   177      14.319  31.412   9.857  1.00 19.00          
ATOM   1230  CG1 ILE   177      15.601  31.074  10.553  1.00 11.91          
ATOM   1231  CG2 ILE   177      13.120  31.248  10.874  1.00 18.55          
ATOM   1232  CD  ILE   177      15.889  32.145  11.418  1.00  9.72          
ATOM   1233  N   ILE   178      11.955  29.802   8.127  1.00 17.81          
ATOM   1234  CA  ILE   178      10.629  29.888   7.596  1.00 18.74          
ATOM   1235  C   ILE   178       9.738  29.767   8.810  1.00 21.69          
ATOM   1236  O   ILE   178       9.369  28.658   9.196  1.00 22.13          
ATOM   1237  CB  ILE   178      10.413  28.731   6.690  1.00 16.83          
ATOM   1238  CG1 ILE   178      11.358  28.877   5.529  1.00 17.27          
ATOM   1239  CG2 ILE   178       9.081  28.753   6.119  1.00 14.64          
ATOM   1240  CD  ILE   178      11.772  27.572   4.860  1.00 14.06          
ATOM   1241  N   GLU   179       9.410  30.894   9.457  1.00 24.72          
ATOM   1242  CA  GLU   179       8.565  30.779  10.664  1.00 26.88          
ATOM   1243  C   GLU   179       7.234  30.195  10.334  1.00 27.60          
ATOM   1244  O   GLU   179       6.545  30.728   9.514  1.00 29.85          
ATOM   1245  CB  GLU   179       8.336  32.048  11.494  1.00 25.33          
ATOM   1246  CG  GLU   179       8.683  33.362  10.939  1.00 28.80          
ATOM   1247  CD  GLU   179       9.133  34.214  12.103  1.00 35.59          
ATOM   1248  OE1 GLU   179       9.453  35.411  11.932  1.00 38.57          
ATOM   1249  OE2 GLU   179       9.144  33.661  13.224  1.00 34.98          
ATOM   1250  N   VAL   180       6.877  29.088  10.968  1.00 27.94          
ATOM   1251  CA  VAL   180       5.534  28.673  10.877  1.00 27.56          
ATOM   1252  C   VAL   180       4.913  28.191  12.117  1.00 27.81          
ATOM   1253  O   VAL   180       5.498  28.167  13.195  1.00 28.02          
ATOM   1254  CB  VAL   180       5.310  27.684   9.732  1.00 28.96          
ATOM   1255  CG1 VAL   180       5.174  28.527   8.383  1.00 30.60          
ATOM   1256  CG2 VAL   180       6.355  26.550   9.669  1.00 23.93          
ATOM   1257  N   ASP   181       3.656  27.896  11.911  1.00 28.30          
ATOM   1258  CA  ASP   181       2.774  27.396  12.894  1.00 29.52          
ATOM   1259  C   ASP   181       1.719  26.369  12.341  1.00 29.88          
ATOM   1260  O   ASP   181       0.933  26.655  11.380  1.00 31.11          
ATOM   1261  CB  ASP   181       2.120  28.540  13.605  1.00 29.39          
ATOM   1262  CG  ASP   181       1.391  28.053  14.781  1.00 32.09          
ATOM   1263  OD1 ASP   181       1.249  26.810  14.853  1.00 34.95          
ATOM   1264  OD2 ASP   181       0.933  28.775  15.675  1.00 35.01          
ATOM   1265  N   GLU   182       1.789  25.156  12.892  1.00 28.51          
ATOM   1266  CA  GLU   182       1.183  23.977  12.278  1.00 29.19          
ATOM   1267  C   GLU   182       1.492  22.736  13.147  1.00 27.43          
ATOM   1268  O   GLU   182       2.642  22.505  13.516  1.00 27.31          
ATOM   1269  CB  GLU   182       1.558  23.810  10.777  1.00 28.20          
ATOM   1270  CG  GLU   182       0.527  24.373   9.773  1.00 33.60          
ATOM   1271  CD  GLU   182       0.011  23.352   8.639  1.00 41.70          
ATOM   1272  OE1 GLU   182       0.791  22.459   8.057  1.00 40.51          
ATOM   1273  OE2 GLU   182      -1.234  23.467   8.265  1.00 47.22          
ATOM   1274  N   PRO   183       0.451  21.953  13.468  1.00 26.93          
ATOM   1275  CA  PRO   183       0.538  20.853  14.453  1.00 26.06          
ATOM   1276  C   PRO   183       1.398  19.678  13.954  1.00 26.46          
ATOM   1277  O   PRO   183       1.364  19.291  12.785  1.00 27.59          
ATOM   1278  CB  PRO   183      -0.904  20.390  14.576  1.00 26.28          
ATOM   1279  CG  PRO   183      -1.541  20.716  13.225  1.00 25.49          
ATOM   1280  CD  PRO   183      -0.893  22.019  12.835  1.00 26.25          
ATOM   1281  N   ILE   184       2.185  19.095  14.837  1.00 25.25          
ATOM   1282  CA  ILE   184       3.166  18.158  14.439  1.00 21.69          
ATOM   1283  C   ILE   184       2.447  16.897  14.044  1.00 21.73          
ATOM   1284  O   ILE   184       1.793  16.339  14.840  1.00 21.82          
ATOM   1285  CB  ILE   184       4.037  18.037  15.644  1.00 20.69          
ATOM   1286  CG1 ILE   184       4.833  19.343  15.748  1.00 17.79          
ATOM   1287  CG2 ILE   184       4.862  16.748  15.620  1.00 21.71          
ATOM   1288  CD  ILE   184       6.123  19.386  14.936  1.00  8.23          
ATOM   1289  N   ALA   185       2.534  16.464  12.797  1.00 22.39          
ATOM   1290  CA  ALA   185       1.879  15.219  12.385  1.00 23.14          
ATOM   1291  C   ALA   185       1.835  14.233  13.486  1.00 23.75          
ATOM   1292  O   ALA   185       2.816  14.061  14.220  1.00 21.62          
ATOM   1293  CB  ALA   185       2.632  14.564  11.264  1.00 23.84          
ATOM   1294  N   GLU   186       0.713  13.544  13.570  1.00 25.90          
ATOM   1295  CA  GLU   186       0.520  12.574  14.673  1.00 29.21          
ATOM   1296  C   GLU   186       0.348  11.172  14.153  1.00 28.23          
ATOM   1297  O   GLU   186      -0.203  11.027  13.115  1.00 28.76          
ATOM   1298  CB  GLU   186      -0.662  12.992  15.595  1.00 29.75          
ATOM   1299  CG  GLU   186      -1.960  13.486  14.933  1.00 31.19          
ATOM   1300  CD  GLU   186      -2.910  14.152  15.940  1.00 32.80          
ATOM   1301  OE1 GLU   186      -3.557  15.151  15.525  1.00 39.05          
ATOM   1302  OE2 GLU   186      -3.015  13.716  17.158  1.00 36.29          
END
