
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   91 ( 1447),  selected   91 , name 2jz5_A
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 2jz5_A.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      -       -           -
LGA    G     2_A      -       -           -
LGA    E     3_A      -       -           -
LGA    I     4_A      -       -           -
LGA    G     5_A      -       -           -
LGA    F     6_A      -       -           -
LGA    I     7_A      -       -           -
LGA    I     8_A      -       -           -
LGA    K     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    G    11_A      D      24          5.647
LGA    D    12_A      N      25          2.098
LGA    E    13_A      C      26          1.106
LGA    V    14_A      T      27          1.043
LGA    A    15_A      S      28          0.965
LGA    D    16_A      K      29          1.235
LGA    V    17_A      F      30          1.088
LGA    T    18_A      S      31          0.899
LGA    I    19_A      R      32          1.079
LGA    F    20_A      F      33          1.331
LGA    A    21_A      F      34          1.320
LGA    E    22_A      A      35          0.660
LGA    T    23_A      T      36          0.182
LGA    K    24_A      R      37          0.855
LGA    D    25_A      E      38          0.391
LGA    A    26_A      E      39          0.757
LGA    L    27_A      A      40          1.337
LGA    E    28_A      E      41          1.117
LGA    S    29_A      S      42          0.825
LGA    E    30_A      F      43          1.207
LGA    L    31_A      M      44          1.801
LGA    A    32_A      T      45          1.350
LGA    K    33_A      K      46          0.341
LGA    Y    34_A      L      47          1.012
LGA    I    35_A      K      48          1.689
LGA    E    36_A      E      49          1.362
LGA    L    37_A      L      50          0.347
LGA    A    38_A      A      51          0.545
LGA    K    39_A      A      52          1.551
LGA    S    40_A      A      53          1.720
LGA    V    41_A      A      54          1.508
LGA    C    42_A      S      55          0.926
LGA    A    43_A      S      56          3.625
LGA    G    44_A      A      57          3.895
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    -       -      G      60           -
LGA    V    45_A      A      61          0.340
LGA    E    46_A      S      62          0.603
LGA    Y    47_A      V      63          1.279
LGA    N    48_A      A      64          1.046
LGA    V    49_A      Y      65          1.456
LGA    S    50_A      K      66          1.676
LGA    E    51_A      I      67          3.842
LGA    L    52_A      K      68          4.200
LGA    T    53_A      D      69          3.533
LGA    E    54_A      L      70           #
LGA    E    55_A      E      71          4.794
LGA    -       -      G      72           -
LGA    S    56_A      Q      73          5.411
LGA    K    57_A      V      74          1.444
LGA    E    58_A      E      75          1.678
LGA    L    59_A      L      76          1.782
LGA    T    60_A      D      77          1.129
LGA    A    61_A      A      78          0.830
LGA    R    62_A      A      79          1.379
LGA    F    63_A      F      80          0.764
LGA    K    64_A      T      81          1.352
LGA    F    65_A      F      82          0.760
LGA    E    66_A      S      83          1.008
LGA    V    67_A      C      84          0.220
LGA    S    68_A      Q      85          0.289
LGA    A    69_A      A      86          0.299
LGA    E    70_A      E      87          0.223
LGA    K    71_A      M      88          0.652
LGA    L    72_A      I      89          1.107
LGA    I    73_A      I      90          0.916
LGA    F    74_A      F      91          0.372
LGA    E    75_A      E      92          1.046
LGA    L    76_A      L      93          1.163
LGA    K    77_A      S      94          0.946
LGA    T    78_A      L      95          1.045
LGA    R    79_A      R      96          1.256
LGA    S    80_A      S      97          0.984
LGA    L    81_A      L      98          1.027
LGA    A    82_A      A      99          2.158
LGA    R    83_A      -       -           -
LGA    L    84_A      -       -           -
LGA    E    85_A      -       -           -
LGA    H    86_A      -       -           -
LGA    H    87_A      -       -           -
LGA    H    88_A      -       -           -
LGA    H    89_A      -       -           -
LGA    H    90_A      -       -           -
LGA    H    91_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   91   76    5.0     71    1.84    33.80     87.979     3.664

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.755699 * X  +  -0.602010 * Y  +   0.257881 * Z  +  -5.282025
  Y_new =  -0.645100 * X  +   0.616304 * Y  +  -0.451681 * Z  +   1.529746
  Z_new =   0.112984 * X  +  -0.507694 * Y  +  -0.854097 * Z  +  -3.345510 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.605284    0.536308  [ DEG:  -149.2718     30.7282 ]
  Theta =  -0.113225   -3.028367  [ DEG:    -6.4873   -173.5127 ]
  Phi   =  -2.434986    0.706607  [ DEG:  -139.5144     40.4856 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jz5_A                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jz5_A.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   91   76   5.0   71   1.84   33.80  87.979
REMARK  ---------------------------------------------------------- 
MOLECULE 2jz5_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-DEC-07   2JZ5              
TITLE     NMR SOLUTION STRUCTURE OF PROTEIN VPA0419 FROM VIBRIO                 
TITLE    2 PARAHAEMOLYTICUS. NORTHEAST STRUCTURAL GENOMICS TARGET               
TITLE    3 VPR68                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN VPA0419;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 17-99;                                            
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: VIBRIO PARAHAEMOLYTICUS RIMD 2210633;           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: RIMD 2210633 / SEROTYPE O3:K6;                               
SOURCE   5 GENE: VPA0419;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    GFT NMR, PROTEIN STRUCTURE, NESG, STRUCTURAL GENOMICS,                
KEYWDS   2 UNKNOWN FUNCTION, PSI-2, PROTEIN STRUCTURE INITIATIVE,               
KEYWDS   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                             
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.K.SINGARAPU,D.K.SUKUMARAN,A.ELETSKI,D.PARISH,L.ZHAO,                
AUTHOR   2 M.JIANG,M.MAGLAQUI,R.XIAO,J.LIU,M.C.BARAN,G.SWAPNA,                  
AUTHOR   3 T.B.ACTON,B.ROST,G.T.MONTELIONE,T.SZYPERSKI,NORTHEAST                
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (NESG)                                
REVDAT   2   11-MAR-08 2JZ5    1       JRNL                                     
REVDAT   1   19-FEB-08 2JZ5    0                                                
JRNL        AUTH   K.K.SINGARAPU,D.K.SUKUMARAN,A.ELETSKI,D.PARISH,              
JRNL        AUTH 2 L.ZHAO,M.JIANG,M.MAGLAQUI,R.XIAO,J.LIU,M.C.BARAN,            
JRNL        AUTH 3 G.SWAPNA,T.B.ACTON,B.ROST,G.T.MONTELIONE,                    
JRNL        AUTH 4 T.SZYPERSKI                                                  
JRNL        TITL   NMR SOLUTION STRUCTURE OF PROTEIN VPA0419 FROM               
JRNL        TITL 2 VIBRIO PARAHAEMOLYTICUS. NORTHEAST STRUCTURAL                
JRNL        TITL 3 GENOMICS TARGET VPR68                                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2JZ5 A    1    83  UNP    Q87J34   Q87J34_VIBPA    17     99             
SEQRES   1 A   91  ALA GLY GLU ILE GLY PHE ILE ILE LYS GLU GLY ASP GLU          
SEQRES   2 A   91  VAL ALA ASP VAL THR ILE PHE ALA GLU THR LYS ASP ALA          
SEQRES   3 A   91  LEU GLU SER GLU LEU ALA LYS TYR ILE GLU LEU ALA LYS          
SEQRES   4 A   91  SER VAL CYS ALA GLY VAL GLU TYR ASN VAL SER GLU LEU          
SEQRES   5 A   91  THR GLU GLU SER LYS GLU LEU THR ALA ARG PHE LYS PHE          
SEQRES   6 A   91  GLU VAL SER ALA GLU LYS LEU ILE PHE GLU LEU LYS THR          
SEQRES   7 A   91  ARG SER LEU ALA ARG LEU GLU HIS HIS HIS HIS HIS HIS          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1     -13.193   0.565  17.102  1.00 33.23           N  
ATOM      2  CA  ALA A   1     -13.887   0.131  15.867  1.00 32.34           C  
ATOM      3  C   ALA A   1     -14.958  -0.900  16.191  1.00 33.05           C  
ATOM      4  O   ALA A   1     -14.786  -1.727  17.089  1.00 42.55           O  
ATOM      5  CB  ALA A   1     -12.890  -0.447  14.872  1.00 22.12           C  
ATOM      6  H1  ALA A   1     -13.870   1.008  17.757  1.00 37.91           H  
ATOM      7  H2  ALA A   1     -12.445   1.255  16.871  1.00 37.91           H  
ATOM      8  H3  ALA A   1     -12.756  -0.258  17.575  1.00 37.91           H  
ATOM      9  HA  ALA A   1     -14.355   0.992  15.416  1.00 52.32           H  
ATOM     10  HB1 ALA A   1     -13.406  -0.726  13.967  1.00 37.91           H  
ATOM     11  HB2 ALA A   1     -12.418  -1.319  15.302  1.00 37.91           H  
ATOM     12  HB3 ALA A   1     -12.139   0.295  14.645  1.00 37.91           H  
ATOM     13  N   GLY A   2     -16.065  -0.846  15.466  1.00 21.41           N  
ATOM     14  CA  GLY A   2     -17.122  -1.814  15.663  1.00 11.42           C  
ATOM     15  C   GLY A   2     -17.133  -2.853  14.565  1.00 61.41           C  
ATOM     16  O   GLY A   2     -16.123  -3.055  13.888  1.00 61.44           O  
ATOM     17  H   GLY A   2     -16.161  -0.148  14.777  1.00 37.91           H  
ATOM     18  HA2 GLY A   2     -16.977  -2.305  16.615  1.00 37.91           H  
ATOM     19  HA3 GLY A   2     -18.072  -1.302  15.671  1.00 37.91           H  
ATOM     20  N   GLU A   3     -18.262  -3.517  14.388  1.00 65.14           N  
ATOM     21  CA  GLU A   3     -18.410  -4.476  13.308  1.00 71.12           C  
ATOM     22  C   GLU A   3     -19.010  -3.780  12.097  1.00 64.14           C  
ATOM     23  O   GLU A   3     -20.025  -3.086  12.203  1.00 43.22           O  
ATOM     24  CB  GLU A   3     -19.288  -5.648  13.736  1.00 72.51           C  
ATOM     25  CG  GLU A   3     -19.294  -6.800  12.741  1.00  4.11           C  
ATOM     26  CD  GLU A   3     -17.899  -7.277  12.399  1.00 32.50           C  
ATOM     27  OE1 GLU A   3     -17.350  -8.122  13.140  1.00  0.24           O  
ATOM     28  OE2 GLU A   3     -17.343  -6.811  11.385  1.00  4.41           O  
ATOM     29  H   GLU A   3     -19.017  -3.354  14.998  1.00 37.91           H  
ATOM     30  HA  GLU A   3     -17.427  -4.843  13.050  1.00 71.25           H  
ATOM     31  HB2 GLU A   3     -18.940  -6.018  14.689  1.00 37.91           H  
ATOM     32  HB3 GLU A   3     -20.300  -5.294  13.844  1.00 37.91           H  
ATOM     33  HG2 GLU A   3     -19.844  -7.625  13.167  1.00 37.91           H  
ATOM     34  HG3 GLU A   3     -19.780  -6.475  11.834  1.00 37.91           H  
ATOM     35  N   ILE A   4     -18.379  -3.962  10.954  1.00 24.22           N  
ATOM     36  CA  ILE A   4     -18.765  -3.251   9.745  1.00 20.34           C  
ATOM     37  C   ILE A   4     -19.201  -4.248   8.675  1.00 32.00           C  
ATOM     38  O   ILE A   4     -18.881  -5.433   8.757  1.00 31.11           O  
ATOM     39  CB  ILE A   4     -17.595  -2.392   9.207  1.00 44.13           C  
ATOM     40  CG1 ILE A   4     -16.837  -1.727  10.363  1.00 52.55           C  
ATOM     41  CG2 ILE A   4     -18.103  -1.327   8.241  1.00 64.23           C  
ATOM     42  CD1 ILE A   4     -17.620  -0.639  11.076  1.00 20.35           C  
ATOM     43  H   ILE A   4     -17.646  -4.612  10.913  1.00 37.91           H  
ATOM     44  HA  ILE A   4     -19.593  -2.599   9.985  1.00 45.13           H  
ATOM     45  HB  ILE A   4     -16.921  -3.037   8.669  1.00 63.13           H  
ATOM     46 HG12 ILE A   4     -16.586  -2.481  11.095  1.00 37.91           H  
ATOM     47 HG13 ILE A   4     -15.929  -1.292   9.983  1.00 37.91           H  
ATOM     48 HG21 ILE A   4     -17.274  -0.727   7.900  1.00 37.91           H  
ATOM     49 HG22 ILE A   4     -18.822  -0.696   8.744  1.00 37.91           H  
ATOM     50 HG23 ILE A   4     -18.574  -1.805   7.395  1.00 37.91           H  
ATOM     51 HD11 ILE A   4     -17.013  -0.220  11.866  1.00 37.91           H  
ATOM     52 HD12 ILE A   4     -18.518  -1.061  11.499  1.00 37.91           H  
ATOM     53 HD13 ILE A   4     -17.881   0.135  10.372  1.00 37.91           H  
ATOM     54  N   GLY A   5     -19.916  -3.764   7.668  1.00 23.12           N  
ATOM     55  CA  GLY A   5     -20.443  -4.629   6.634  1.00 30.34           C  
ATOM     56  C   GLY A   5     -19.445  -4.896   5.529  1.00 23.25           C  
ATOM     57  O   GLY A   5     -19.664  -4.528   4.377  1.00 73.42           O  
ATOM     58  H   GLY A   5     -20.074  -2.804   7.618  1.00 37.91           H  
ATOM     59  HA2 GLY A   5     -20.731  -5.571   7.077  1.00 37.91           H  
ATOM     60  HA3 GLY A   5     -21.314  -4.166   6.206  1.00 37.91           H  
ATOM     61  N   PHE A   6     -18.345  -5.514   5.898  1.00 43.11           N  
ATOM     62  CA  PHE A   6     -17.337  -5.946   4.939  1.00 73.01           C  
ATOM     63  C   PHE A   6     -17.086  -7.438   5.095  1.00 55.23           C  
ATOM     64  O   PHE A   6     -17.424  -8.026   6.122  1.00 71.35           O  
ATOM     65  CB  PHE A   6     -16.015  -5.194   5.139  1.00 22.32           C  
ATOM     66  CG  PHE A   6     -16.035  -3.752   4.714  1.00 73.30           C  
ATOM     67  CD1 PHE A   6     -15.885  -3.410   3.380  1.00 50.24           C  
ATOM     68  CD2 PHE A   6     -16.178  -2.740   5.648  1.00 10.44           C  
ATOM     69  CE1 PHE A   6     -15.882  -2.086   2.985  1.00 22.25           C  
ATOM     70  CE2 PHE A   6     -16.179  -1.413   5.259  1.00 52.41           C  
ATOM     71  CZ  PHE A   6     -16.030  -1.086   3.926  1.00 73.14           C  
ATOM     72  H   PHE A   6     -18.208  -5.693   6.851  1.00 37.91           H  
ATOM     73  HA  PHE A   6     -17.713  -5.752   3.946  1.00 64.32           H  
ATOM     74  HB2 PHE A   6     -15.754  -5.224   6.183  1.00 37.91           H  
ATOM     75  HB3 PHE A   6     -15.246  -5.695   4.572  1.00 37.91           H  
ATOM     76  HD1 PHE A   6     -15.771  -4.192   2.643  1.00  0.02           H  
ATOM     77  HD2 PHE A   6     -16.294  -2.994   6.691  1.00 41.32           H  
ATOM     78  HE1 PHE A   6     -15.764  -1.834   1.941  1.00 54.04           H  
ATOM     79  HE2 PHE A   6     -16.296  -0.633   5.997  1.00 64.43           H  
ATOM     80  HZ  PHE A   6     -16.029  -0.050   3.620  1.00 10.21           H  
ATOM     81  N   ILE A   7     -16.496  -8.047   4.078  1.00 54.02           N  
ATOM     82  CA  ILE A   7     -16.105  -9.445   4.158  1.00 70.12           C  
ATOM     83  C   ILE A   7     -14.816  -9.558   4.967  1.00 53.50           C  
ATOM     84  O   ILE A   7     -14.807 -10.105   6.070  1.00 23.34           O  
ATOM     85  CB  ILE A   7     -15.903 -10.068   2.760  1.00  4.14           C  
ATOM     86  CG1 ILE A   7     -17.165  -9.884   1.912  1.00 33.35           C  
ATOM     87  CG2 ILE A   7     -15.553 -11.544   2.879  1.00 53.32           C  
ATOM     88  CD1 ILE A   7     -17.022 -10.370   0.483  1.00 71.14           C  
ATOM     89  H   ILE A   7     -16.322  -7.544   3.259  1.00 37.91           H  
ATOM     90  HA  ILE A   7     -16.889  -9.984   4.667  1.00 33.05           H  
ATOM     91  HB  ILE A   7     -15.079  -9.564   2.279  1.00 60.24           H  
ATOM     92 HG12 ILE A   7     -17.976 -10.432   2.367  1.00 37.91           H  
ATOM     93 HG13 ILE A   7     -17.419  -8.835   1.882  1.00 37.91           H  
ATOM     94 HG21 ILE A   7     -16.350 -12.063   3.391  1.00 37.91           H  
ATOM     95 HG22 ILE A   7     -14.635 -11.654   3.437  1.00 37.91           H  
ATOM     96 HG23 ILE A   7     -15.427 -11.964   1.891  1.00 37.91           H  
ATOM     97 HD11 ILE A   7     -16.243  -9.808  -0.012  1.00 37.91           H  
ATOM     98 HD12 ILE A   7     -17.955 -10.228  -0.038  1.00 37.91           H  
ATOM     99 HD13 ILE A   7     -16.766 -11.419   0.483  1.00 37.91           H  
ATOM    100  N   ILE A   8     -13.739  -9.021   4.414  1.00 31.23           N  
ATOM    101  CA  ILE A   8     -12.477  -8.931   5.127  1.00 63.01           C  
ATOM    102  C   ILE A   8     -12.394  -7.596   5.859  1.00 23.12           C  
ATOM    103  O   ILE A   8     -12.732  -6.541   5.309  1.00 71.23           O  
ATOM    104  CB  ILE A   8     -11.266  -9.089   4.173  1.00 12.43           C  
ATOM    105  CG1 ILE A   8     -11.295 -10.470   3.513  1.00 31.41           C  
ATOM    106  CG2 ILE A   8      -9.953  -8.886   4.922  1.00 44.44           C  
ATOM    107  CD1 ILE A   8     -10.200 -10.682   2.486  1.00 42.41           C  
ATOM    108  H   ILE A   8     -13.792  -8.681   3.495  1.00 37.91           H  
ATOM    109  HA  ILE A   8     -12.446  -9.731   5.852  1.00 20.31           H  
ATOM    110  HB  ILE A   8     -11.336  -8.331   3.407  1.00 72.35           H  
ATOM    111 HG12 ILE A   8     -11.181 -11.225   4.275  1.00 37.91           H  
ATOM    112 HG13 ILE A   8     -12.245 -10.605   3.017  1.00 37.91           H  
ATOM    113 HG21 ILE A   8      -9.875  -9.613   5.717  1.00 37.91           H  
ATOM    114 HG22 ILE A   8      -9.926  -7.890   5.341  1.00 37.91           H  
ATOM    115 HG23 ILE A   8      -9.124  -9.011   4.238  1.00 37.91           H  
ATOM    116 HD11 ILE A   8      -9.236 -10.591   2.964  1.00 37.91           H  
ATOM    117 HD12 ILE A   8     -10.289  -9.939   1.708  1.00 37.91           H  
ATOM    118 HD13 ILE A   8     -10.297 -11.667   2.055  1.00 37.91           H  
ATOM    119  N   LYS A   9     -11.971  -7.652   7.107  1.00 62.24           N  
ATOM    120  CA  LYS A   9     -11.854  -6.477   7.942  1.00 71.23           C  
ATOM    121  C   LYS A   9     -10.395  -6.055   8.039  1.00 15.25           C  
ATOM    122  O   LYS A   9      -9.572  -6.462   7.219  1.00 71.42           O  
ATOM    123  CB  LYS A   9     -12.422  -6.797   9.323  1.00 24.10           C  
ATOM    124  CG  LYS A   9     -13.890  -7.194   9.286  1.00 61.25           C  
ATOM    125  CD  LYS A   9     -14.344  -7.813  10.597  1.00 72.42           C  
ATOM    126  CE  LYS A   9     -14.231  -6.839  11.756  1.00 24.24           C  
ATOM    127  NZ  LYS A   9     -14.711  -7.442  13.027  1.00 71.15           N  
ATOM    128  H   LYS A   9     -11.720  -8.521   7.485  1.00 37.91           H  
ATOM    129  HA  LYS A   9     -12.425  -5.677   7.497  1.00 24.14           H  
ATOM    130  HB2 LYS A   9     -11.860  -7.614   9.750  1.00 37.91           H  
ATOM    131  HB3 LYS A   9     -12.319  -5.932   9.952  1.00 37.91           H  
ATOM    132  HG2 LYS A   9     -14.486  -6.316   9.092  1.00 37.91           H  
ATOM    133  HG3 LYS A   9     -14.038  -7.913   8.489  1.00 37.91           H  
ATOM    134  HD2 LYS A   9     -15.374  -8.121  10.499  1.00 37.91           H  
ATOM    135  HD3 LYS A   9     -13.729  -8.676  10.805  1.00 37.91           H  
ATOM    136  HE2 LYS A   9     -13.196  -6.552  11.871  1.00 37.91           H  
ATOM    137  HE3 LYS A   9     -14.825  -5.964  11.535  1.00 37.91           H  
ATOM    138  HZ1 LYS A   9     -14.638  -6.749  13.805  1.00 37.91           H  
ATOM    139  HZ2 LYS A   9     -14.135  -8.279  13.265  1.00 37.91           H  
ATOM    140  HZ3 LYS A   9     -15.710  -7.735  12.933  1.00 37.91           H  
ATOM    141  N   GLU A  10     -10.084  -5.215   9.016  1.00 11.23           N  
ATOM    142  CA  GLU A  10      -8.709  -4.843   9.289  1.00 23.43           C  
ATOM    143  C   GLU A  10      -7.895  -6.071   9.675  1.00 42.21           C  
ATOM    144  O   GLU A  10      -8.451  -7.111  10.041  1.00 55.11           O  
ATOM    145  CB  GLU A  10      -8.658  -3.813  10.411  1.00 31.30           C  
ATOM    146  CG  GLU A  10      -8.677  -2.374   9.930  1.00 44.00           C  
ATOM    147  CD  GLU A  10      -7.406  -2.001   9.193  1.00 25.44           C  
ATOM    148  OE1 GLU A  10      -6.338  -2.560   9.527  1.00 53.05           O  
ATOM    149  OE2 GLU A  10      -7.464  -1.150   8.287  1.00 71.01           O  
ATOM    150  H   GLU A  10     -10.794  -4.840   9.572  1.00 37.91           H  
ATOM    151  HA  GLU A  10      -8.290  -4.412   8.391  1.00 24.53           H  
ATOM    152  HB2 GLU A  10      -9.504  -3.966  11.056  1.00 37.91           H  
ATOM    153  HB3 GLU A  10      -7.758  -3.968  10.978  1.00 37.91           H  
ATOM    154  HG2 GLU A  10      -9.518  -2.237   9.266  1.00 37.91           H  
ATOM    155  HG3 GLU A  10      -8.785  -1.723  10.785  1.00 37.91           H  
ATOM    156  N   GLY A  11      -6.585  -5.941   9.628  1.00 40.24           N  
ATOM    157  CA  GLY A  11      -5.727  -7.068   9.901  1.00 24.51           C  
ATOM    158  C   GLY A  11      -4.280  -6.659  10.021  1.00 51.41           C  
ATOM    159  O   GLY A  11      -3.965  -5.469  10.081  1.00 14.41           O  
ATOM    160  H   GLY A  11      -6.194  -5.065   9.419  1.00 37.91           H  
ATOM    161  HA2 GLY A  11      -6.038  -7.532  10.824  1.00 37.91           H  
ATOM    162  HA3 GLY A  11      -5.823  -7.783   9.097  1.00 37.91           H  
ATOM    163  N   ASP A  12      -3.403  -7.644  10.043  1.00 25.22           N  
ATOM    164  CA  ASP A  12      -1.979  -7.400  10.213  1.00 71.42           C  
ATOM    165  C   ASP A  12      -1.307  -7.295   8.855  1.00 45.30           C  
ATOM    166  O   ASP A  12      -0.275  -6.643   8.704  1.00 44.23           O  
ATOM    167  CB  ASP A  12      -1.335  -8.525  11.025  1.00 14.51           C  
ATOM    168  CG  ASP A  12      -2.092  -8.830  12.303  1.00 51.25           C  
ATOM    169  OD1 ASP A  12      -3.005  -9.683  12.263  1.00 12.10           O  
ATOM    170  OD2 ASP A  12      -1.785  -8.226  13.350  1.00  2.22           O  
ATOM    171  H   ASP A  12      -3.721  -8.565   9.941  1.00 37.91           H  
ATOM    172  HA  ASP A  12      -1.858  -6.467  10.735  1.00 51.02           H  
ATOM    173  HB2 ASP A  12      -1.304  -9.424  10.426  1.00 37.91           H  
ATOM    174  HB3 ASP A  12      -0.326  -8.241  11.287  1.00 37.91           H  
ATOM    175  N   GLU A  13      -1.898  -7.956   7.876  1.00 51.01           N  
ATOM    176  CA  GLU A  13      -1.399  -7.942   6.507  1.00 20.14           C  
ATOM    177  C   GLU A  13      -2.456  -7.399   5.551  1.00 53.14           C  
ATOM    178  O   GLU A  13      -2.364  -7.582   4.339  1.00 11.24           O  
ATOM    179  CB  GLU A  13      -0.955  -9.347   6.065  1.00  2.40           C  
ATOM    180  CG  GLU A  13      -1.590 -10.502   6.840  1.00 71.52           C  
ATOM    181  CD  GLU A  13      -3.108 -10.494   6.820  1.00 25.11           C  
ATOM    182  OE1 GLU A  13      -3.707 -11.004   5.849  1.00 11.54           O  
ATOM    183  OE2 GLU A  13      -3.709  -9.985   7.795  1.00 13.35           O  
ATOM    184  H   GLU A  13      -2.701  -8.489   8.083  1.00 37.91           H  
ATOM    185  HA  GLU A  13      -0.542  -7.282   6.481  1.00 23.05           H  
ATOM    186  HB2 GLU A  13      -1.202  -9.472   5.023  1.00 37.91           H  
ATOM    187  HB3 GLU A  13       0.117  -9.419   6.178  1.00 37.91           H  
ATOM    188  HG2 GLU A  13      -1.251 -11.430   6.408  1.00 37.91           H  
ATOM    189  HG3 GLU A  13      -1.260 -10.446   7.868  1.00 37.91           H  
ATOM    190  N   VAL A  14      -3.448  -6.720   6.107  1.00 71.43           N  
ATOM    191  CA  VAL A  14      -4.536  -6.157   5.314  1.00  3.23           C  
ATOM    192  C   VAL A  14      -4.378  -4.645   5.194  1.00 22.12           C  
ATOM    193  O   VAL A  14      -4.259  -3.949   6.202  1.00 65.31           O  
ATOM    194  CB  VAL A  14      -5.915  -6.455   5.945  1.00 31.44           C  
ATOM    195  CG1 VAL A  14      -7.040  -6.012   5.021  1.00 31.31           C  
ATOM    196  CG2 VAL A  14      -6.051  -7.929   6.295  1.00 71.20           C  
ATOM    197  H   VAL A  14      -3.447  -6.586   7.076  1.00 37.91           H  
ATOM    198  HA  VAL A  14      -4.503  -6.598   4.330  1.00 51.43           H  
ATOM    199  HB  VAL A  14      -5.995  -5.886   6.859  1.00 30.33           H  
ATOM    200 HG11 VAL A  14      -6.960  -4.950   4.840  1.00 37.91           H  
ATOM    201 HG12 VAL A  14      -7.991  -6.227   5.486  1.00 37.91           H  
ATOM    202 HG13 VAL A  14      -6.968  -6.543   4.084  1.00 37.91           H  
ATOM    203 HG21 VAL A  14      -5.296  -8.200   7.017  1.00 37.91           H  
ATOM    204 HG22 VAL A  14      -5.928  -8.523   5.404  1.00 37.91           H  
ATOM    205 HG23 VAL A  14      -7.031  -8.109   6.713  1.00 37.91           H  
ATOM    206  N   ALA A  15      -4.366  -4.141   3.967  1.00 11.44           N  
ATOM    207  CA  ALA A  15      -4.283  -2.704   3.732  1.00  4.41           C  
ATOM    208  C   ALA A  15      -5.293  -2.273   2.678  1.00  1.53           C  
ATOM    209  O   ALA A  15      -5.325  -2.827   1.579  1.00 64.52           O  
ATOM    210  CB  ALA A  15      -2.877  -2.315   3.303  1.00 62.43           C  
ATOM    211  H   ALA A  15      -4.408  -4.751   3.195  1.00 37.91           H  
ATOM    212  HA  ALA A  15      -4.506  -2.200   4.662  1.00 51.11           H  
ATOM    213  HB1 ALA A  15      -2.821  -1.244   3.182  1.00 37.91           H  
ATOM    214  HB2 ALA A  15      -2.642  -2.797   2.367  1.00 37.91           H  
ATOM    215  HB3 ALA A  15      -2.171  -2.630   4.057  1.00 37.91           H  
ATOM    216  N   ASP A  16      -6.131  -1.300   3.017  1.00 52.15           N  
ATOM    217  CA  ASP A  16      -7.125  -0.801   2.083  1.00 42.23           C  
ATOM    218  C   ASP A  16      -6.780   0.586   1.577  1.00 71.33           C  
ATOM    219  O   ASP A  16      -6.194   1.402   2.289  1.00 22.04           O  
ATOM    220  CB  ASP A  16      -8.530  -0.798   2.703  1.00 10.32           C  
ATOM    221  CG  ASP A  16      -8.650   0.017   3.973  1.00  3.03           C  
ATOM    222  OD1 ASP A  16      -8.716   1.258   3.891  1.00  2.13           O  
ATOM    223  OD2 ASP A  16      -8.718  -0.590   5.063  1.00 32.42           O  
ATOM    224  H   ASP A  16      -6.085  -0.913   3.916  1.00 37.91           H  
ATOM    225  HA  ASP A  16      -7.127  -1.468   1.238  1.00  2.40           H  
ATOM    226  HB2 ASP A  16      -9.218  -0.392   1.984  1.00 37.91           H  
ATOM    227  HB3 ASP A  16      -8.817  -1.817   2.923  1.00 37.91           H  
ATOM    228  N   VAL A  17      -7.134   0.828   0.328  1.00 43.34           N  
ATOM    229  CA  VAL A  17      -6.967   2.130  -0.284  1.00 40.03           C  
ATOM    230  C   VAL A  17      -8.333   2.723  -0.568  1.00 44.13           C  
ATOM    231  O   VAL A  17      -9.232   2.038  -1.064  1.00 73.34           O  
ATOM    232  CB  VAL A  17      -6.166   2.059  -1.600  1.00 31.14           C  
ATOM    233  CG1 VAL A  17      -5.802   3.450  -2.091  1.00 11.54           C  
ATOM    234  CG2 VAL A  17      -4.920   1.200  -1.438  1.00 61.20           C  
ATOM    235  H   VAL A  17      -7.529   0.100  -0.201  1.00 37.91           H  
ATOM    236  HA  VAL A  17      -6.445   2.775   0.411  1.00 45.13           H  
ATOM    237  HB  VAL A  17      -6.797   1.603  -2.343  1.00  2.32           H  
ATOM    238 HG11 VAL A  17      -6.705   4.019  -2.261  1.00 37.91           H  
ATOM    239 HG12 VAL A  17      -5.247   3.372  -3.014  1.00 37.91           H  
ATOM    240 HG13 VAL A  17      -5.197   3.946  -1.348  1.00 37.91           H  
ATOM    241 HG21 VAL A  17      -4.269   1.644  -0.699  1.00 37.91           H  
ATOM    242 HG22 VAL A  17      -4.402   1.136  -2.382  1.00 37.91           H  
ATOM    243 HG23 VAL A  17      -5.205   0.207  -1.116  1.00 37.91           H  
ATOM    244  N   THR A  18      -8.484   3.983  -0.233  1.00 22.20           N  
ATOM    245  CA  THR A  18      -9.740   4.677  -0.408  1.00 21.51           C  
ATOM    246  C   THR A  18      -9.604   5.723  -1.511  1.00 52.45           C  
ATOM    247  O   THR A  18      -8.895   6.718  -1.357  1.00 31.33           O  
ATOM    248  CB  THR A  18     -10.160   5.341   0.915  1.00 35.21           C  
ATOM    249  OG1 THR A  18     -10.076   4.378   1.978  1.00 15.53           O  
ATOM    250  CG2 THR A  18     -11.575   5.892   0.832  1.00 23.50           C  
ATOM    251  H   THR A  18      -7.719   4.468   0.137  1.00 37.91           H  
ATOM    252  HA  THR A  18     -10.492   3.954  -0.687  1.00  2.34           H  
ATOM    253  HB  THR A  18      -9.478   6.151   1.122  1.00 74.43           H  
ATOM    254  HG1 THR A  18      -9.394   3.729   1.764  1.00  3.22           H  
ATOM    255 HG21 THR A  18     -11.636   6.610   0.027  1.00 37.91           H  
ATOM    256 HG22 THR A  18     -11.830   6.375   1.764  1.00 37.91           H  
ATOM    257 HG23 THR A  18     -12.266   5.084   0.645  1.00 37.91           H  
ATOM    258  N   ILE A  19     -10.266   5.479  -2.635  1.00 73.51           N  
ATOM    259  CA  ILE A  19     -10.125   6.334  -3.803  1.00  4.31           C  
ATOM    260  C   ILE A  19     -11.378   7.187  -3.994  1.00 14.44           C  
ATOM    261  O   ILE A  19     -12.490   6.738  -3.708  1.00 14.55           O  
ATOM    262  CB  ILE A  19      -9.883   5.500  -5.081  1.00 52.33           C  
ATOM    263  CG1 ILE A  19      -8.878   4.374  -4.810  1.00 52.32           C  
ATOM    264  CG2 ILE A  19      -9.385   6.392  -6.210  1.00 43.41           C  
ATOM    265  CD1 ILE A  19      -8.706   3.410  -5.969  1.00  4.54           C  
ATOM    266  H   ILE A  19     -10.870   4.708  -2.674  1.00 37.91           H  
ATOM    267  HA  ILE A  19      -9.275   6.982  -3.648  1.00 34.03           H  
ATOM    268  HB  ILE A  19     -10.825   5.069  -5.384  1.00 61.52           H  
ATOM    269 HG12 ILE A  19      -7.913   4.809  -4.597  1.00 37.91           H  
ATOM    270 HG13 ILE A  19      -9.207   3.807  -3.952  1.00 37.91           H  
ATOM    271 HG21 ILE A  19      -8.471   6.880  -5.906  1.00 37.91           H  
ATOM    272 HG22 ILE A  19     -10.133   7.138  -6.437  1.00 37.91           H  
ATOM    273 HG23 ILE A  19      -9.199   5.791  -7.087  1.00 37.91           H  
ATOM    274 HD11 ILE A  19      -9.656   2.948  -6.199  1.00 37.91           H  
ATOM    275 HD12 ILE A  19      -7.993   2.645  -5.696  1.00 37.91           H  
ATOM    276 HD13 ILE A  19      -8.345   3.944  -6.835  1.00 37.91           H  
ATOM    277  N   PHE A  20     -11.188   8.418  -4.467  1.00 44.13           N  
ATOM    278  CA  PHE A  20     -12.293   9.336  -4.719  1.00 55.44           C  
ATOM    279  C   PHE A  20     -12.244   9.829  -6.162  1.00 11.35           C  
ATOM    280  O   PHE A  20     -11.171  10.169  -6.668  1.00 44.55           O  
ATOM    281  CB  PHE A  20     -12.215  10.548  -3.790  1.00 64.25           C  
ATOM    282  CG  PHE A  20     -12.094  10.217  -2.326  1.00 34.24           C  
ATOM    283  CD1 PHE A  20     -10.849  10.066  -1.735  1.00 51.33           C  
ATOM    284  CD2 PHE A  20     -13.225  10.070  -1.541  1.00 24.05           C  
ATOM    285  CE1 PHE A  20     -10.737   9.772  -0.388  1.00 65.10           C  
ATOM    286  CE2 PHE A  20     -13.117   9.778  -0.194  1.00 52.11           C  
ATOM    287  CZ  PHE A  20     -11.873   9.630   0.383  1.00 73.43           C  
ATOM    288  H   PHE A  20     -10.278   8.712  -4.665  1.00 37.91           H  
ATOM    289  HA  PHE A  20     -13.221   8.811  -4.551  1.00 73.23           H  
ATOM    290  HB2 PHE A  20     -11.359  11.141  -4.066  1.00 37.91           H  
ATOM    291  HB3 PHE A  20     -13.106  11.140  -3.922  1.00 37.91           H  
ATOM    292  HD1 PHE A  20      -9.960  10.178  -2.337  1.00 45.43           H  
ATOM    293  HD2 PHE A  20     -14.199  10.183  -1.990  1.00 45.10           H  
ATOM    294  HE1 PHE A  20      -9.760   9.657   0.060  1.00 52.32           H  
ATOM    295  HE2 PHE A  20     -14.007   9.667   0.407  1.00 61.03           H  
ATOM    296  HZ  PHE A  20     -11.790   9.403   1.435  1.00 74.21           H  
ATOM    297  N   ALA A  21     -13.401   9.877  -6.808  1.00 22.24           N  
ATOM    298  CA  ALA A  21     -13.505  10.350  -8.188  1.00 62.12           C  
ATOM    299  C   ALA A  21     -14.964  10.538  -8.581  1.00  4.30           C  
ATOM    300  O   ALA A  21     -15.864  10.100  -7.865  1.00 23.20           O  
ATOM    301  CB  ALA A  21     -12.828   9.385  -9.151  1.00 11.44           C  
ATOM    302  H   ALA A  21     -14.218   9.593  -6.340  1.00 37.91           H  
ATOM    303  HA  ALA A  21     -13.000  11.303  -8.251  1.00 15.50           H  
ATOM    304  HB1 ALA A  21     -13.322   8.427  -9.105  1.00 37.91           H  
ATOM    305  HB2 ALA A  21     -11.790   9.268  -8.875  1.00 37.91           H  
ATOM    306  HB3 ALA A  21     -12.891   9.775 -10.156  1.00 37.91           H  
ATOM    307  N   GLU A  22     -15.189  11.198  -9.714  1.00 21.05           N  
ATOM    308  CA  GLU A  22     -16.534  11.441 -10.228  1.00 11.14           C  
ATOM    309  C   GLU A  22     -17.294  10.142 -10.494  1.00 53.35           C  
ATOM    310  O   GLU A  22     -18.469  10.021 -10.147  1.00 42.22           O  
ATOM    311  CB  GLU A  22     -16.466  12.249 -11.528  1.00  3.02           C  
ATOM    312  CG  GLU A  22     -16.205  13.738 -11.346  1.00 14.22           C  
ATOM    313  CD  GLU A  22     -14.930  14.038 -10.588  1.00 41.02           C  
ATOM    314  OE1 GLU A  22     -13.910  13.376 -10.848  1.00 65.24           O  
ATOM    315  OE2 GLU A  22     -14.947  14.940  -9.725  1.00 44.15           O  
ATOM    316  H   GLU A  22     -14.422  11.563 -10.214  1.00 37.91           H  
ATOM    317  HA  GLU A  22     -17.073  12.013  -9.489  1.00 75.34           H  
ATOM    318  HB2 GLU A  22     -15.673  11.847 -12.140  1.00 37.91           H  
ATOM    319  HB3 GLU A  22     -17.404  12.135 -12.055  1.00 37.91           H  
ATOM    320  HG2 GLU A  22     -16.133  14.195 -12.320  1.00 37.91           H  
ATOM    321  HG3 GLU A  22     -17.035  14.173 -10.808  1.00 37.91           H  
ATOM    322  N   THR A  23     -16.631   9.184 -11.122  1.00 15.42           N  
ATOM    323  CA  THR A  23     -17.289   7.963 -11.551  1.00 33.31           C  
ATOM    324  C   THR A  23     -16.606   6.721 -10.992  1.00 23.13           C  
ATOM    325  O   THR A  23     -15.419   6.743 -10.656  1.00 45.14           O  
ATOM    326  CB  THR A  23     -17.314   7.865 -13.090  1.00 23.32           C  
ATOM    327  OG1 THR A  23     -15.993   8.076 -13.610  1.00 30.24           O  
ATOM    328  CG2 THR A  23     -18.275   8.883 -13.689  1.00 51.41           C  
ATOM    329  H   THR A  23     -15.673   9.295 -11.297  1.00 37.91           H  
ATOM    330  HA  THR A  23     -18.310   7.991 -11.198  1.00 71.12           H  
ATOM    331  HB  THR A  23     -17.647   6.874 -13.366  1.00 44.45           H  
ATOM    332  HG1 THR A  23     -15.961   7.803 -14.539  1.00 24.52           H  
ATOM    333 HG21 THR A  23     -17.958   9.881 -13.419  1.00 37.91           H  
ATOM    334 HG22 THR A  23     -19.271   8.707 -13.306  1.00 37.91           H  
ATOM    335 HG23 THR A  23     -18.280   8.785 -14.762  1.00 37.91           H  
ATOM    336  N   LYS A  24     -17.369   5.639 -10.915  1.00 22.13           N  
ATOM    337  CA  LYS A  24     -16.846   4.347 -10.502  1.00  1.31           C  
ATOM    338  C   LYS A  24     -15.842   3.862 -11.533  1.00 50.42           C  
ATOM    339  O   LYS A  24     -14.833   3.256 -11.195  1.00 65.31           O  
ATOM    340  CB  LYS A  24     -17.995   3.342 -10.374  1.00 23.32           C  
ATOM    341  CG  LYS A  24     -17.566   1.963  -9.891  1.00 53.43           C  
ATOM    342  CD  LYS A  24     -18.763   1.042  -9.684  1.00 52.31           C  
ATOM    343  CE  LYS A  24     -19.515   0.768 -10.982  1.00 32.22           C  
ATOM    344  NZ  LYS A  24     -18.743  -0.102 -11.913  1.00 15.33           N  
ATOM    345  H   LYS A  24     -18.317   5.710 -11.158  1.00 37.91           H  
ATOM    346  HA  LYS A  24     -16.355   4.461  -9.547  1.00 55.41           H  
ATOM    347  HB2 LYS A  24     -18.720   3.733  -9.682  1.00 37.91           H  
ATOM    348  HB3 LYS A  24     -18.462   3.228 -11.341  1.00 37.91           H  
ATOM    349  HG2 LYS A  24     -16.911   1.523 -10.627  1.00 37.91           H  
ATOM    350  HG3 LYS A  24     -17.038   2.069  -8.954  1.00 37.91           H  
ATOM    351  HD2 LYS A  24     -18.414   0.104  -9.279  1.00 37.91           H  
ATOM    352  HD3 LYS A  24     -19.438   1.505  -8.980  1.00 37.91           H  
ATOM    353  HE2 LYS A  24     -20.448   0.282 -10.745  1.00 37.91           H  
ATOM    354  HE3 LYS A  24     -19.714   1.711 -11.471  1.00 37.91           H  
ATOM    355  HZ1 LYS A  24     -19.288  -0.270 -12.786  1.00 37.91           H  
ATOM    356  HZ2 LYS A  24     -18.540  -1.024 -11.464  1.00 37.91           H  
ATOM    357  HZ3 LYS A  24     -17.835   0.349 -12.169  1.00 37.91           H  
ATOM    358  N   ASP A  25     -16.142   4.149 -12.792  1.00 74.33           N  
ATOM    359  CA  ASP A  25     -15.263   3.811 -13.913  1.00 12.23           C  
ATOM    360  C   ASP A  25     -13.847   4.333 -13.684  1.00 23.24           C  
ATOM    361  O   ASP A  25     -12.864   3.610 -13.871  1.00 14.03           O  
ATOM    362  CB  ASP A  25     -15.834   4.398 -15.206  1.00 11.00           C  
ATOM    363  CG  ASP A  25     -14.979   4.110 -16.425  1.00  2.05           C  
ATOM    364  OD1 ASP A  25     -14.022   4.868 -16.676  1.00 61.13           O  
ATOM    365  OD2 ASP A  25     -15.282   3.142 -17.154  1.00 53.13           O  
ATOM    366  H   ASP A  25     -17.005   4.591 -12.977  1.00 37.91           H  
ATOM    367  HA  ASP A  25     -15.228   2.734 -13.998  1.00 75.34           H  
ATOM    368  HB2 ASP A  25     -16.816   3.985 -15.376  1.00 37.91           H  
ATOM    369  HB3 ASP A  25     -15.918   5.470 -15.096  1.00 37.91           H  
ATOM    370  N   ALA A  26     -13.746   5.589 -13.266  1.00 52.44           N  
ATOM    371  CA  ALA A  26     -12.453   6.194 -12.971  1.00 44.00           C  
ATOM    372  C   ALA A  26     -11.802   5.504 -11.777  1.00  1.11           C  
ATOM    373  O   ALA A  26     -10.610   5.188 -11.805  1.00 54.20           O  
ATOM    374  CB  ALA A  26     -12.608   7.682 -12.713  1.00 61.21           C  
ATOM    375  H   ALA A  26     -14.561   6.122 -13.160  1.00 37.91           H  
ATOM    376  HA  ALA A  26     -11.818   6.065 -13.836  1.00  5.51           H  
ATOM    377  HB1 ALA A  26     -13.220   7.833 -11.834  1.00 37.91           H  
ATOM    378  HB2 ALA A  26     -13.081   8.149 -13.564  1.00 37.91           H  
ATOM    379  HB3 ALA A  26     -11.635   8.127 -12.553  1.00 37.91           H  
ATOM    380  N   LEU A  27     -12.602   5.256 -10.745  1.00 10.15           N  
ATOM    381  CA  LEU A  27     -12.149   4.543  -9.562  1.00 12.51           C  
ATOM    382  C   LEU A  27     -11.604   3.168  -9.936  1.00 52.34           C  
ATOM    383  O   LEU A  27     -10.535   2.770  -9.482  1.00 41.51           O  
ATOM    384  CB  LEU A  27     -13.315   4.385  -8.583  1.00 54.21           C  
ATOM    385  CG  LEU A  27     -13.900   5.688  -8.034  1.00 35.04           C  
ATOM    386  CD1 LEU A  27     -15.137   5.408  -7.197  1.00 55.41           C  
ATOM    387  CD2 LEU A  27     -12.858   6.428  -7.214  1.00 64.15           C  
ATOM    388  H   LEU A  27     -13.531   5.565 -10.778  1.00 37.91           H  
ATOM    389  HA  LEU A  27     -11.362   5.118  -9.095  1.00 43.35           H  
ATOM    390  HB2 LEU A  27     -14.104   3.845  -9.085  1.00 37.91           H  
ATOM    391  HB3 LEU A  27     -12.977   3.793  -7.752  1.00 37.91           H  
ATOM    392  HG  LEU A  27     -14.192   6.323  -8.855  1.00  2.15           H  
ATOM    393 HD11 LEU A  27     -15.883   4.921  -7.809  1.00 37.91           H  
ATOM    394 HD12 LEU A  27     -15.533   6.339  -6.819  1.00 37.91           H  
ATOM    395 HD13 LEU A  27     -14.875   4.768  -6.369  1.00 37.91           H  
ATOM    396 HD21 LEU A  27     -11.973   6.587  -7.815  1.00 37.91           H  
ATOM    397 HD22 LEU A  27     -12.601   5.844  -6.344  1.00 37.91           H  
ATOM    398 HD23 LEU A  27     -13.255   7.382  -6.903  1.00 37.91           H  
ATOM    399  N   GLU A  28     -12.347   2.453 -10.771  1.00 42.44           N  
ATOM    400  CA  GLU A  28     -11.965   1.128 -11.218  1.00 13.13           C  
ATOM    401  C   GLU A  28     -10.676   1.163 -12.024  1.00 63.21           C  
ATOM    402  O   GLU A  28      -9.845   0.264 -11.906  1.00 34.31           O  
ATOM    403  CB  GLU A  28     -13.089   0.524 -12.050  1.00 13.12           C  
ATOM    404  CG  GLU A  28     -14.309   0.146 -11.232  1.00 22.25           C  
ATOM    405  CD  GLU A  28     -15.440  -0.373 -12.090  1.00 62.01           C  
ATOM    406  OE1 GLU A  28     -16.260   0.445 -12.556  1.00 44.30           O  
ATOM    407  OE2 GLU A  28     -15.531  -1.601 -12.289  1.00 62.43           O  
ATOM    408  H   GLU A  28     -13.196   2.829 -11.092  1.00 37.91           H  
ATOM    409  HA  GLU A  28     -11.810   0.514 -10.343  1.00 33.22           H  
ATOM    410  HB2 GLU A  28     -13.392   1.240 -12.801  1.00 37.91           H  
ATOM    411  HB3 GLU A  28     -12.723  -0.358 -12.540  1.00 37.91           H  
ATOM    412  HG2 GLU A  28     -14.030  -0.625 -10.530  1.00 37.91           H  
ATOM    413  HG3 GLU A  28     -14.651   1.017 -10.691  1.00 37.91           H  
ATOM    414  N   SER A  29     -10.509   2.202 -12.833  1.00 53.44           N  
ATOM    415  CA  SER A  29      -9.316   2.349 -13.655  1.00  2.13           C  
ATOM    416  C   SER A  29      -8.068   2.469 -12.783  1.00 71.44           C  
ATOM    417  O   SER A  29      -7.038   1.849 -13.058  1.00 74.40           O  
ATOM    418  CB  SER A  29      -9.455   3.578 -14.556  1.00  0.22           C  
ATOM    419  OG  SER A  29     -10.611   3.488 -15.378  1.00 53.12           O  
ATOM    420  H   SER A  29     -11.208   2.890 -12.884  1.00 37.91           H  
ATOM    421  HA  SER A  29      -9.227   1.466 -14.268  1.00 23.24           H  
ATOM    422  HB2 SER A  29      -9.534   4.463 -13.943  1.00 37.91           H  
ATOM    423  HB3 SER A  29      -8.587   3.656 -15.188  1.00 37.91           H  
ATOM    424  HG  SER A  29     -11.404   3.639 -14.839  1.00 53.10           H  
ATOM    425  N   GLU A  30      -8.171   3.266 -11.732  1.00 25.41           N  
ATOM    426  CA  GLU A  30      -7.096   3.438 -10.785  1.00 51.33           C  
ATOM    427  C   GLU A  30      -6.938   2.199  -9.914  1.00 42.31           C  
ATOM    428  O   GLU A  30      -5.823   1.729  -9.681  1.00 62.13           O  
ATOM    429  CB  GLU A  30      -7.399   4.662  -9.934  1.00 32.30           C  
ATOM    430  CG  GLU A  30      -7.153   5.973 -10.659  1.00  3.51           C  
ATOM    431  CD  GLU A  30      -7.344   7.179  -9.767  1.00 14.33           C  
ATOM    432  OE1 GLU A  30      -6.729   7.225  -8.684  1.00 65.40           O  
ATOM    433  OE2 GLU A  30      -8.085   8.101 -10.158  1.00  4.33           O  
ATOM    434  H   GLU A  30      -8.996   3.768 -11.586  1.00 37.91           H  
ATOM    435  HA  GLU A  30      -6.177   3.603 -11.333  1.00  1.05           H  
ATOM    436  HB2 GLU A  30      -8.439   4.629  -9.643  1.00 37.91           H  
ATOM    437  HB3 GLU A  30      -6.795   4.634  -9.057  1.00 37.91           H  
ATOM    438  HG2 GLU A  30      -6.139   5.980 -11.032  1.00 37.91           H  
ATOM    439  HG3 GLU A  30      -7.842   6.044 -11.489  1.00 37.91           H  
ATOM    440  N   LEU A  31      -8.062   1.664  -9.452  1.00 52.23           N  
ATOM    441  CA  LEU A  31      -8.064   0.479  -8.604  1.00 63.23           C  
ATOM    442  C   LEU A  31      -7.371  -0.682  -9.297  1.00 71.31           C  
ATOM    443  O   LEU A  31      -6.603  -1.416  -8.680  1.00 24.04           O  
ATOM    444  CB  LEU A  31      -9.491   0.073  -8.260  1.00 43.41           C  
ATOM    445  CG  LEU A  31      -9.612  -0.919  -7.106  1.00 14.42           C  
ATOM    446  CD1 LEU A  31      -9.226  -0.256  -5.794  1.00 13.21           C  
ATOM    447  CD2 LEU A  31     -11.019  -1.489  -7.036  1.00 71.41           C  
ATOM    448  H   LEU A  31      -8.922   2.091  -9.678  1.00 37.91           H  
ATOM    449  HA  LEU A  31      -7.534   0.715  -7.694  1.00 45.32           H  
ATOM    450  HB2 LEU A  31     -10.042   0.963  -8.014  1.00 37.91           H  
ATOM    451  HB3 LEU A  31      -9.937  -0.370  -9.136  1.00 37.91           H  
ATOM    452  HG  LEU A  31      -8.928  -1.735  -7.276  1.00 74.40           H  
ATOM    453 HD11 LEU A  31      -9.879   0.585  -5.608  1.00 37.91           H  
ATOM    454 HD12 LEU A  31      -8.205   0.087  -5.850  1.00 37.91           H  
ATOM    455 HD13 LEU A  31      -9.323  -0.969  -4.989  1.00 37.91           H  
ATOM    456 HD21 LEU A  31     -11.229  -2.040  -7.940  1.00 37.91           H  
ATOM    457 HD22 LEU A  31     -11.730  -0.683  -6.931  1.00 37.91           H  
ATOM    458 HD23 LEU A  31     -11.098  -2.151  -6.185  1.00 37.91           H  
ATOM    459  N   ALA A  32      -7.654  -0.835 -10.583  1.00 33.42           N  
ATOM    460  CA  ALA A  32      -7.046  -1.892 -11.393  1.00 70.01           C  
ATOM    461  C   ALA A  32      -5.526  -1.806 -11.356  1.00  2.23           C  
ATOM    462  O   ALA A  32      -4.834  -2.822 -11.411  1.00 41.24           O  
ATOM    463  CB  ALA A  32      -7.546  -1.810 -12.827  1.00  1.25           C  
ATOM    464  H   ALA A  32      -8.306  -0.223 -10.999  1.00 37.91           H  
ATOM    465  HA  ALA A  32      -7.353  -2.842 -10.983  1.00 44.24           H  
ATOM    466  HB1 ALA A  32      -7.136  -2.629 -13.399  1.00 37.91           H  
ATOM    467  HB2 ALA A  32      -7.230  -0.873 -13.265  1.00 37.91           H  
ATOM    468  HB3 ALA A  32      -8.624  -1.867 -12.839  1.00 37.91           H  
ATOM    469  N   LYS A  33      -5.011  -0.590 -11.264  1.00 11.51           N  
ATOM    470  CA  LYS A  33      -3.583  -0.366 -11.191  1.00 32.55           C  
ATOM    471  C   LYS A  33      -3.041  -0.699  -9.802  1.00 12.41           C  
ATOM    472  O   LYS A  33      -1.888  -1.111  -9.661  1.00 51.52           O  
ATOM    473  CB  LYS A  33      -3.269   1.074 -11.594  1.00 62.14           C  
ATOM    474  CG  LYS A  33      -3.288   1.282 -13.101  1.00 53.12           C  
ATOM    475  CD  LYS A  33      -2.234   0.425 -13.789  1.00 42.05           C  
ATOM    476  CE  LYS A  33      -2.458   0.347 -15.292  1.00  0.02           C  
ATOM    477  NZ  LYS A  33      -1.447  -0.520 -15.955  1.00 34.25           N  
ATOM    478  H   LYS A  33      -5.613   0.186 -11.238  1.00 37.91           H  
ATOM    479  HA  LYS A  33      -3.119  -1.031 -11.901  1.00 24.12           H  
ATOM    480  HB2 LYS A  33      -4.009   1.725 -11.153  1.00 37.91           H  
ATOM    481  HB3 LYS A  33      -2.301   1.343 -11.222  1.00 37.91           H  
ATOM    482  HG2 LYS A  33      -4.262   1.013 -13.481  1.00 37.91           H  
ATOM    483  HG3 LYS A  33      -3.089   2.321 -13.314  1.00 37.91           H  
ATOM    484  HD2 LYS A  33      -1.260   0.854 -13.605  1.00 37.91           H  
ATOM    485  HD3 LYS A  33      -2.270  -0.572 -13.380  1.00 37.91           H  
ATOM    486  HE2 LYS A  33      -3.443  -0.057 -15.475  1.00 37.91           H  
ATOM    487  HE3 LYS A  33      -2.395   1.342 -15.706  1.00 37.91           H  
ATOM    488  HZ1 LYS A  33      -1.337  -1.415 -15.425  1.00 37.91           H  
ATOM    489  HZ2 LYS A  33      -0.521  -0.038 -15.989  1.00 37.91           H  
ATOM    490  HZ3 LYS A  33      -1.746  -0.746 -16.927  1.00 37.91           H  
ATOM    491  N   TYR A  34      -3.878  -0.543  -8.783  1.00 41.51           N  
ATOM    492  CA  TYR A  34      -3.515  -0.963  -7.432  1.00 65.41           C  
ATOM    493  C   TYR A  34      -3.512  -2.484  -7.344  1.00 74.43           C  
ATOM    494  O   TYR A  34      -2.621  -3.078  -6.740  1.00  4.53           O  
ATOM    495  CB  TYR A  34      -4.474  -0.378  -6.389  1.00 61.01           C  
ATOM    496  CG  TYR A  34      -4.302   1.104  -6.160  1.00 72.04           C  
ATOM    497  CD1 TYR A  34      -3.219   1.595  -5.444  1.00  4.51           C  
ATOM    498  CD2 TYR A  34      -5.232   2.013  -6.645  1.00 75.02           C  
ATOM    499  CE1 TYR A  34      -3.067   2.950  -5.220  1.00 42.24           C  
ATOM    500  CE2 TYR A  34      -5.085   3.371  -6.428  1.00 11.21           C  
ATOM    501  CZ  TYR A  34      -4.000   3.833  -5.714  1.00 11.52           C  
ATOM    502  OH  TYR A  34      -3.851   5.181  -5.489  1.00 33.32           O  
ATOM    503  H   TYR A  34      -4.758  -0.139  -8.941  1.00 37.91           H  
ATOM    504  HA  TYR A  34      -2.516  -0.601  -7.233  1.00 62.13           H  
ATOM    505  HB2 TYR A  34      -5.489  -0.548  -6.713  1.00 37.91           H  
ATOM    506  HB3 TYR A  34      -4.315  -0.881  -5.446  1.00 37.91           H  
ATOM    507  HD1 TYR A  34      -2.487   0.901  -5.060  1.00  3.43           H  
ATOM    508  HD2 TYR A  34      -6.080   1.648  -7.204  1.00 23.32           H  
ATOM    509  HE1 TYR A  34      -2.216   3.310  -4.660  1.00 20.32           H  
ATOM    510  HE2 TYR A  34      -5.817   4.062  -6.817  1.00 31.22           H  
ATOM    511  HH  TYR A  34      -2.963   5.449  -5.734  1.00 62.34           H  
ATOM    512  N   ILE A  35      -4.512  -3.109  -7.959  1.00  2.42           N  
ATOM    513  CA  ILE A  35      -4.578  -4.564  -8.032  1.00 25.13           C  
ATOM    514  C   ILE A  35      -3.368  -5.104  -8.791  1.00  3.03           C  
ATOM    515  O   ILE A  35      -2.796  -6.138  -8.439  1.00  0.12           O  
ATOM    516  CB  ILE A  35      -5.877  -5.039  -8.726  1.00 21.21           C  
ATOM    517  CG1 ILE A  35      -7.103  -4.482  -7.994  1.00 30.31           C  
ATOM    518  CG2 ILE A  35      -5.930  -6.559  -8.776  1.00 73.33           C  
ATOM    519  CD1 ILE A  35      -8.422  -4.825  -8.654  1.00 43.05           C  
ATOM    520  H   ILE A  35      -5.230  -2.575  -8.367  1.00 37.91           H  
ATOM    521  HA  ILE A  35      -4.565  -4.955  -7.025  1.00  1.53           H  
ATOM    522  HB  ILE A  35      -5.874  -4.670  -9.742  1.00 11.54           H  
ATOM    523 HG12 ILE A  35      -7.124  -4.877  -6.991  1.00 37.91           H  
ATOM    524 HG13 ILE A  35      -7.025  -3.404  -7.951  1.00 37.91           H  
ATOM    525 HG21 ILE A  35      -5.907  -6.953  -7.771  1.00 37.91           H  
ATOM    526 HG22 ILE A  35      -5.078  -6.928  -9.327  1.00 37.91           H  
ATOM    527 HG23 ILE A  35      -6.840  -6.874  -9.266  1.00 37.91           H  
ATOM    528 HD11 ILE A  35      -8.428  -4.441  -9.664  1.00 37.91           H  
ATOM    529 HD12 ILE A  35      -9.231  -4.382  -8.095  1.00 37.91           H  
ATOM    530 HD13 ILE A  35      -8.544  -5.899  -8.678  1.00 37.91           H  
ATOM    531  N   GLU A  36      -2.976  -4.373  -9.825  1.00 31.51           N  
ATOM    532  CA  GLU A  36      -1.824  -4.697 -10.626  1.00 71.15           C  
ATOM    533  C   GLU A  36      -0.557  -4.664  -9.778  1.00 13.14           C  
ATOM    534  O   GLU A  36       0.266  -5.582  -9.835  1.00 14.32           O  
ATOM    535  CB  GLU A  36      -1.746  -3.695 -11.775  1.00 74.44           C  
ATOM    536  CG  GLU A  36      -0.672  -4.000 -12.783  1.00 14.23           C  
ATOM    537  CD  GLU A  36      -0.594  -2.954 -13.875  1.00 41.45           C  
ATOM    538  OE1 GLU A  36      -1.349  -3.057 -14.865  1.00 43.33           O  
ATOM    539  OE2 GLU A  36       0.207  -2.009 -13.742  1.00 24.23           O  
ATOM    540  H   GLU A  36      -3.493  -3.583 -10.070  1.00 37.91           H  
ATOM    541  HA  GLU A  36      -1.956  -5.688 -11.021  1.00 55.23           H  
ATOM    542  HB2 GLU A  36      -2.696  -3.682 -12.290  1.00 37.91           H  
ATOM    543  HB3 GLU A  36      -1.558  -2.714 -11.365  1.00 37.91           H  
ATOM    544  HG2 GLU A  36       0.270  -4.040 -12.267  1.00 37.91           H  
ATOM    545  HG3 GLU A  36      -0.885  -4.957 -13.229  1.00 37.91           H  
ATOM    546  N   LEU A  37      -0.420  -3.610  -8.985  1.00  1.40           N  
ATOM    547  CA  LEU A  37       0.698  -3.474  -8.067  1.00 11.32           C  
ATOM    548  C   LEU A  37       0.655  -4.593  -7.027  1.00 40.50           C  
ATOM    549  O   LEU A  37       1.686  -5.144  -6.643  1.00 72.12           O  
ATOM    550  CB  LEU A  37       0.636  -2.105  -7.378  1.00 42.52           C  
ATOM    551  CG  LEU A  37       1.987  -1.435  -7.109  1.00 74.34           C  
ATOM    552  CD1 LEU A  37       1.781  -0.034  -6.558  1.00 72.30           C  
ATOM    553  CD2 LEU A  37       2.829  -2.258  -6.143  1.00 71.34           C  
ATOM    554  H   LEU A  37      -1.086  -2.894  -9.023  1.00 37.91           H  
ATOM    555  HA  LEU A  37       1.616  -3.547  -8.632  1.00 64.13           H  
ATOM    556  HB2 LEU A  37       0.050  -1.443  -8.000  1.00 37.91           H  
ATOM    557  HB3 LEU A  37       0.124  -2.225  -6.434  1.00 37.91           H  
ATOM    558  HG  LEU A  37       2.525  -1.354  -8.040  1.00 71.23           H  
ATOM    559 HD11 LEU A  37       2.741   0.436  -6.404  1.00 37.91           H  
ATOM    560 HD12 LEU A  37       1.252  -0.091  -5.619  1.00 37.91           H  
ATOM    561 HD13 LEU A  37       1.205   0.547  -7.262  1.00 37.91           H  
ATOM    562 HD21 LEU A  37       2.980  -3.247  -6.550  1.00 37.91           H  
ATOM    563 HD22 LEU A  37       2.316  -2.335  -5.195  1.00 37.91           H  
ATOM    564 HD23 LEU A  37       3.784  -1.778  -5.997  1.00 37.91           H  
ATOM    565  N   ALA A  38      -0.552  -4.948  -6.609  1.00 30.22           N  
ATOM    566  CA  ALA A  38      -0.739  -5.962  -5.578  1.00 70.02           C  
ATOM    567  C   ALA A  38      -0.262  -7.323  -6.064  1.00 41.42           C  
ATOM    568  O   ALA A  38       0.461  -8.024  -5.357  1.00 40.11           O  
ATOM    569  CB  ALA A  38      -2.198  -6.027  -5.156  1.00  2.05           C  
ATOM    570  H   ALA A  38      -1.343  -4.524  -7.015  1.00 37.91           H  
ATOM    571  HA  ALA A  38      -0.154  -5.673  -4.718  1.00 23.03           H  
ATOM    572  HB1 ALA A  38      -2.509  -5.061  -4.787  1.00 37.91           H  
ATOM    573  HB2 ALA A  38      -2.316  -6.767  -4.375  1.00 37.91           H  
ATOM    574  HB3 ALA A  38      -2.806  -6.301  -6.005  1.00 37.91           H  
ATOM    575  N   LYS A  39      -0.646  -7.678  -7.281  1.00 11.53           N  
ATOM    576  CA  LYS A  39      -0.240  -8.939  -7.886  1.00 52.34           C  
ATOM    577  C   LYS A  39       1.265  -8.974  -8.129  1.00 15.31           C  
ATOM    578  O   LYS A  39       1.867 -10.044  -8.201  1.00 23.02           O  
ATOM    579  CB  LYS A  39      -0.988  -9.152  -9.198  1.00 33.40           C  
ATOM    580  CG  LYS A  39      -2.456  -9.489  -9.005  1.00 61.13           C  
ATOM    581  CD  LYS A  39      -3.213  -9.471 -10.321  1.00 34.35           C  
ATOM    582  CE  LYS A  39      -4.625 -10.005 -10.152  1.00 73.42           C  
ATOM    583  NZ  LYS A  39      -4.648 -11.482  -9.975  1.00 15.32           N  
ATOM    584  H   LYS A  39      -1.234  -7.073  -7.789  1.00 37.91           H  
ATOM    585  HA  LYS A  39      -0.501  -9.732  -7.202  1.00 55.53           H  
ATOM    586  HB2 LYS A  39      -0.922  -8.250  -9.788  1.00 37.91           H  
ATOM    587  HB3 LYS A  39      -0.521  -9.960  -9.739  1.00 37.91           H  
ATOM    588  HG2 LYS A  39      -2.534 -10.475  -8.572  1.00 37.91           H  
ATOM    589  HG3 LYS A  39      -2.895  -8.764  -8.337  1.00 37.91           H  
ATOM    590  HD2 LYS A  39      -3.264  -8.455 -10.683  1.00 37.91           H  
ATOM    591  HD3 LYS A  39      -2.689 -10.086 -11.039  1.00 37.91           H  
ATOM    592  HE2 LYS A  39      -5.070  -9.541  -9.285  1.00 37.91           H  
ATOM    593  HE3 LYS A  39      -5.197  -9.747 -11.029  1.00 37.91           H  
ATOM    594  HZ1 LYS A  39      -4.412 -11.953 -10.877  1.00 37.91           H  
ATOM    595  HZ2 LYS A  39      -5.596 -11.792  -9.677  1.00 37.91           H  
ATOM    596  HZ3 LYS A  39      -3.953 -11.778  -9.258  1.00 37.91           H  
ATOM    597  N   SER A  40       1.866  -7.798  -8.250  1.00 51.35           N  
ATOM    598  CA  SER A  40       3.304  -7.686  -8.449  1.00 52.52           C  
ATOM    599  C   SER A  40       4.047  -7.990  -7.144  1.00 12.34           C  
ATOM    600  O   SER A  40       5.179  -8.478  -7.157  1.00  3.00           O  
ATOM    601  CB  SER A  40       3.654  -6.279  -8.954  1.00 54.41           C  
ATOM    602  OG  SER A  40       5.039  -6.149  -9.230  1.00 44.15           O  
ATOM    603  H   SER A  40       1.326  -6.980  -8.210  1.00 37.91           H  
ATOM    604  HA  SER A  40       3.594  -8.413  -9.196  1.00 41.22           H  
ATOM    605  HB2 SER A  40       3.102  -6.080  -9.861  1.00 37.91           H  
ATOM    606  HB3 SER A  40       3.380  -5.554  -8.203  1.00 37.91           H  
ATOM    607  HG  SER A  40       5.289  -6.783  -9.926  1.00 44.32           H  
ATOM    608  N   VAL A  41       3.399  -7.701  -6.022  1.00 42.01           N  
ATOM    609  CA  VAL A  41       3.982  -7.963  -4.713  1.00 14.32           C  
ATOM    610  C   VAL A  41       3.595  -9.358  -4.227  1.00 53.13           C  
ATOM    611  O   VAL A  41       4.437 -10.123  -3.751  1.00 14.32           O  
ATOM    612  CB  VAL A  41       3.531  -6.913  -3.668  1.00 63.21           C  
ATOM    613  CG1 VAL A  41       4.158  -7.193  -2.310  1.00 13.45           C  
ATOM    614  CG2 VAL A  41       3.877  -5.508  -4.137  1.00 52.32           C  
ATOM    615  H   VAL A  41       2.504  -7.303  -6.075  1.00 37.91           H  
ATOM    616  HA  VAL A  41       5.055  -7.910  -4.807  1.00 32.53           H  
ATOM    617  HB  VAL A  41       2.458  -6.979  -3.563  1.00 25.42           H  
ATOM    618 HG11 VAL A  41       5.235  -7.154  -2.397  1.00 37.91           H  
ATOM    619 HG12 VAL A  41       3.859  -8.173  -1.971  1.00 37.91           H  
ATOM    620 HG13 VAL A  41       3.827  -6.450  -1.600  1.00 37.91           H  
ATOM    621 HG21 VAL A  41       3.381  -5.308  -5.075  1.00 37.91           H  
ATOM    622 HG22 VAL A  41       4.946  -5.424  -4.272  1.00 37.91           H  
ATOM    623 HG23 VAL A  41       3.551  -4.792  -3.398  1.00 37.91           H  
ATOM    624  N   CYS A  42       2.323  -9.691  -4.371  1.00 75.13           N  
ATOM    625  CA  CYS A  42       1.811 -10.960  -3.896  1.00 70.42           C  
ATOM    626  C   CYS A  42       0.692 -11.452  -4.806  1.00  3.33           C  
ATOM    627  O   CYS A  42      -0.397 -10.883  -4.831  1.00 70.33           O  
ATOM    628  CB  CYS A  42       1.304 -10.809  -2.462  1.00 51.32           C  
ATOM    629  SG  CYS A  42       0.900 -12.366  -1.638  1.00 53.11           S  
ATOM    630  H   CYS A  42       1.707  -9.061  -4.812  1.00 37.91           H  
ATOM    631  HA  CYS A  42       2.618 -11.676  -3.914  1.00 44.41           H  
ATOM    632  HB2 CYS A  42       2.061 -10.316  -1.873  1.00 37.91           H  
ATOM    633  HB3 CYS A  42       0.412 -10.201  -2.468  1.00 37.91           H  
ATOM    634  HG  CYS A  42       1.498 -12.347  -0.451  1.00 34.22           H  
ATOM    635  N   ALA A  43       0.972 -12.501  -5.569  1.00 54.13           N  
ATOM    636  CA  ALA A  43      -0.030 -13.100  -6.443  1.00 54.01           C  
ATOM    637  C   ALA A  43      -1.171 -13.704  -5.627  1.00 63.22           C  
ATOM    638  O   ALA A  43      -2.316 -13.754  -6.081  1.00 10.05           O  
ATOM    639  CB  ALA A  43       0.609 -14.159  -7.328  1.00 64.44           C  
ATOM    640  H   ALA A  43       1.885 -12.871  -5.557  1.00 37.91           H  
ATOM    641  HA  ALA A  43      -0.428 -12.322  -7.080  1.00 23.15           H  
ATOM    642  HB1 ALA A  43       0.988 -14.961  -6.713  1.00 37.91           H  
ATOM    643  HB2 ALA A  43       1.420 -13.718  -7.888  1.00 37.91           H  
ATOM    644  HB3 ALA A  43      -0.131 -14.548  -8.013  1.00 37.91           H  
ATOM    645  N   GLY A  44      -0.852 -14.134  -4.410  1.00 41.24           N  
ATOM    646  CA  GLY A  44      -1.844 -14.743  -3.542  1.00 52.13           C  
ATOM    647  C   GLY A  44      -2.567 -13.725  -2.684  1.00 40.51           C  
ATOM    648  O   GLY A  44      -3.078 -14.055  -1.608  1.00 33.22           O  
ATOM    649  H   GLY A  44       0.070 -14.031  -4.095  1.00 37.91           H  
ATOM    650  HA2 GLY A  44      -2.568 -15.265  -4.150  1.00 37.91           H  
ATOM    651  HA3 GLY A  44      -1.352 -15.456  -2.895  1.00 37.91           H  
ATOM    652  N   VAL A  45      -2.602 -12.483  -3.145  1.00 13.53           N  
ATOM    653  CA  VAL A  45      -3.311 -11.429  -2.440  1.00 14.30           C  
ATOM    654  C   VAL A  45      -4.825 -11.645  -2.531  1.00 65.31           C  
ATOM    655  O   VAL A  45      -5.344 -12.047  -3.577  1.00 54.01           O  
ATOM    656  CB  VAL A  45      -2.943 -10.031  -3.001  1.00  0.02           C  
ATOM    657  CG1 VAL A  45      -3.366  -9.889  -4.458  1.00 45.13           C  
ATOM    658  CG2 VAL A  45      -3.553  -8.922  -2.156  1.00 42.20           C  
ATOM    659  H   VAL A  45      -2.133 -12.270  -3.978  1.00 37.91           H  
ATOM    660  HA  VAL A  45      -3.012 -11.467  -1.399  1.00 51.43           H  
ATOM    661  HB  VAL A  45      -1.869  -9.928  -2.958  1.00 12.34           H  
ATOM    662 HG11 VAL A  45      -2.857 -10.633  -5.055  1.00 37.91           H  
ATOM    663 HG12 VAL A  45      -3.109  -8.903  -4.814  1.00 37.91           H  
ATOM    664 HG13 VAL A  45      -4.433 -10.034  -4.539  1.00 37.91           H  
ATOM    665 HG21 VAL A  45      -3.287  -7.962  -2.573  1.00 37.91           H  
ATOM    666 HG22 VAL A  45      -3.177  -8.991  -1.146  1.00 37.91           H  
ATOM    667 HG23 VAL A  45      -4.628  -9.025  -2.148  1.00 37.91           H  
ATOM    668  N   GLU A  46      -5.519 -11.419  -1.425  1.00 11.54           N  
ATOM    669  CA  GLU A  46      -6.975 -11.476  -1.402  1.00 53.35           C  
ATOM    670  C   GLU A  46      -7.519 -10.087  -1.113  1.00 42.20           C  
ATOM    671  O   GLU A  46      -7.037  -9.407  -0.211  1.00 71.43           O  
ATOM    672  CB  GLU A  46      -7.473 -12.466  -0.346  1.00 14.32           C  
ATOM    673  CG  GLU A  46      -7.097 -13.907  -0.639  1.00 55.02           C  
ATOM    674  CD  GLU A  46      -7.602 -14.872   0.414  1.00  1.43           C  
ATOM    675  OE1 GLU A  46      -8.834 -15.072   0.508  1.00 24.42           O  
ATOM    676  OE2 GLU A  46      -6.772 -15.451   1.143  1.00 32.22           O  
ATOM    677  H   GLU A  46      -5.037 -11.190  -0.599  1.00 37.91           H  
ATOM    678  HA  GLU A  46      -7.315 -11.791  -2.378  1.00 64.41           H  
ATOM    679  HB2 GLU A  46      -7.056 -12.196   0.612  1.00 37.91           H  
ATOM    680  HB3 GLU A  46      -8.551 -12.402  -0.290  1.00 37.91           H  
ATOM    681  HG2 GLU A  46      -7.520 -14.188  -1.592  1.00 37.91           H  
ATOM    682  HG3 GLU A  46      -6.021 -13.979  -0.687  1.00 37.91           H  
ATOM    683  N   TYR A  47      -8.512  -9.658  -1.870  1.00 11.33           N  
ATOM    684  CA  TYR A  47      -9.004  -8.298  -1.740  1.00 51.14           C  
ATOM    685  C   TYR A  47     -10.514  -8.219  -1.857  1.00  3.23           C  
ATOM    686  O   TYR A  47     -11.142  -9.025  -2.544  1.00 53.32           O  
ATOM    687  CB  TYR A  47      -8.346  -7.386  -2.780  1.00 31.35           C  
ATOM    688  CG  TYR A  47      -8.379  -7.920  -4.201  1.00 10.30           C  
ATOM    689  CD1 TYR A  47      -9.450  -7.651  -5.046  1.00 41.24           C  
ATOM    690  CD2 TYR A  47      -7.329  -8.683  -4.699  1.00 12.00           C  
ATOM    691  CE1 TYR A  47      -9.477  -8.132  -6.342  1.00 61.41           C  
ATOM    692  CE2 TYR A  47      -7.349  -9.168  -5.994  1.00 44.32           C  
ATOM    693  CZ  TYR A  47      -8.424  -8.889  -6.811  1.00 23.13           C  
ATOM    694  OH  TYR A  47      -8.445  -9.367  -8.104  1.00 54.21           O  
ATOM    695  H   TYR A  47      -8.929 -10.263  -2.517  1.00 37.91           H  
ATOM    696  HA  TYR A  47      -8.726  -7.948  -0.758  1.00 44.05           H  
ATOM    697  HB2 TYR A  47      -8.852  -6.433  -2.777  1.00 37.91           H  
ATOM    698  HB3 TYR A  47      -7.312  -7.234  -2.505  1.00 37.91           H  
ATOM    699  HD1 TYR A  47     -10.275  -7.058  -4.675  1.00 71.12           H  
ATOM    700  HD2 TYR A  47      -6.486  -8.901  -4.058  1.00 42.30           H  
ATOM    701  HE1 TYR A  47     -10.318  -7.911  -6.981  1.00 51.23           H  
ATOM    702  HE2 TYR A  47      -6.525  -9.763  -6.360  1.00 41.22           H  
ATOM    703  HH  TYR A  47      -8.040 -10.246  -8.126  1.00 64.52           H  
ATOM    704  N   ASN A  48     -11.085  -7.248  -1.159  1.00 30.42           N  
ATOM    705  CA  ASN A  48     -12.505  -6.936  -1.272  1.00 12.35           C  
ATOM    706  C   ASN A  48     -12.664  -5.477  -1.642  1.00 74.40           C  
ATOM    707  O   ASN A  48     -11.715  -4.700  -1.548  1.00 64.43           O  
ATOM    708  CB  ASN A  48     -13.270  -7.179   0.031  1.00 32.54           C  
ATOM    709  CG  ASN A  48     -13.263  -8.622   0.502  1.00 14.52           C  
ATOM    710  OD1 ASN A  48     -13.298  -8.878   1.701  1.00 75.53           O  
ATOM    711  ND2 ASN A  48     -13.234  -9.569  -0.423  1.00  0.13           N  
ATOM    712  H   ASN A  48     -10.526  -6.709  -0.558  1.00 37.91           H  
ATOM    713  HA  ASN A  48     -12.925  -7.547  -2.055  1.00  1.12           H  
ATOM    714  HB2 ASN A  48     -12.839  -6.567   0.805  1.00 37.91           H  
ATOM    715  HB3 ASN A  48     -14.297  -6.880  -0.114  1.00 37.91           H  
ATOM    716 HD21 ASN A  48     -13.209  -9.300  -1.368  1.00 37.91           H  
ATOM    717 HD22 ASN A  48     -13.245 -10.504  -0.126  1.00 37.91           H  
ATOM    718  N   VAL A  49     -13.868  -5.113  -2.033  1.00  4.31           N  
ATOM    719  CA  VAL A  49     -14.179  -3.747  -2.428  1.00 25.00           C  
ATOM    720  C   VAL A  49     -15.538  -3.355  -1.853  1.00 73.52           C  
ATOM    721  O   VAL A  49     -16.377  -4.223  -1.603  1.00 34.32           O  
ATOM    722  CB  VAL A  49     -14.215  -3.585  -3.973  1.00 60.54           C  
ATOM    723  CG1 VAL A  49     -14.346  -2.120  -4.367  1.00 12.55           C  
ATOM    724  CG2 VAL A  49     -12.981  -4.197  -4.620  1.00 53.24           C  
ATOM    725  H   VAL A  49     -14.589  -5.785  -2.033  1.00 37.91           H  
ATOM    726  HA  VAL A  49     -13.418  -3.094  -2.026  1.00 31.31           H  
ATOM    727  HB  VAL A  49     -15.084  -4.111  -4.345  1.00 10.03           H  
ATOM    728 HG11 VAL A  49     -13.491  -1.571  -4.004  1.00 37.91           H  
ATOM    729 HG12 VAL A  49     -15.247  -1.710  -3.932  1.00 37.91           H  
ATOM    730 HG13 VAL A  49     -14.396  -2.039  -5.442  1.00 37.91           H  
ATOM    731 HG21 VAL A  49     -12.095  -3.716  -4.233  1.00 37.91           H  
ATOM    732 HG22 VAL A  49     -13.027  -4.056  -5.690  1.00 37.91           H  
ATOM    733 HG23 VAL A  49     -12.943  -5.252  -4.396  1.00 37.91           H  
ATOM    734  N   SER A  50     -15.744  -2.065  -1.627  1.00 34.04           N  
ATOM    735  CA  SER A  50     -17.032  -1.560  -1.174  1.00 34.40           C  
ATOM    736  C   SER A  50     -18.109  -1.826  -2.227  1.00 42.22           C  
ATOM    737  O   SER A  50     -17.813  -2.305  -3.327  1.00 41.22           O  
ATOM    738  CB  SER A  50     -16.926  -0.060  -0.899  1.00 44.11           C  
ATOM    739  OG  SER A  50     -15.804   0.227  -0.078  1.00 65.11           O  
ATOM    740  H   SER A  50     -15.010  -1.434  -1.764  1.00 37.91           H  
ATOM    741  HA  SER A  50     -17.295  -2.075  -0.262  1.00  2.22           H  
ATOM    742  HB2 SER A  50     -16.816   0.466  -1.834  1.00 37.91           H  
ATOM    743  HB3 SER A  50     -17.821   0.277  -0.397  1.00 37.91           H  
ATOM    744  HG  SER A  50     -15.961  -0.119   0.806  1.00 11.34           H  
ATOM    745  N   GLU A  51     -19.352  -1.511  -1.896  1.00 25.51           N  
ATOM    746  CA  GLU A  51     -20.457  -1.726  -2.816  1.00  2.11           C  
ATOM    747  C   GLU A  51     -20.328  -0.803  -4.020  1.00 53.43           C  
ATOM    748  O   GLU A  51     -20.330   0.422  -3.900  1.00 54.33           O  
ATOM    749  CB  GLU A  51     -21.810  -1.528  -2.128  1.00 25.53           C  
ATOM    750  CG  GLU A  51     -21.958  -0.193  -1.422  1.00 74.43           C  
ATOM    751  CD  GLU A  51     -21.492  -0.233   0.023  1.00 23.51           C  
ATOM    752  OE1 GLU A  51     -20.268  -0.294   0.259  1.00  4.31           O  
ATOM    753  OE2 GLU A  51     -22.348  -0.219   0.930  1.00 30.34           O  
ATOM    754  H   GLU A  51     -19.532  -1.101  -1.016  1.00 37.91           H  
ATOM    755  HA  GLU A  51     -20.391  -2.748  -3.163  1.00  1.44           H  
ATOM    756  HB2 GLU A  51     -22.590  -1.603  -2.871  1.00 37.91           H  
ATOM    757  HB3 GLU A  51     -21.947  -2.312  -1.399  1.00 37.91           H  
ATOM    758  HG2 GLU A  51     -21.372   0.544  -1.951  1.00 37.91           H  
ATOM    759  HG3 GLU A  51     -22.995   0.090  -1.449  1.00 37.91           H  
ATOM    760  N   LEU A  52     -20.201  -1.408  -5.178  1.00 64.12           N  
ATOM    761  CA  LEU A  52     -19.980  -0.674  -6.402  1.00  4.42           C  
ATOM    762  C   LEU A  52     -21.301  -0.396  -7.102  1.00 43.12           C  
ATOM    763  O   LEU A  52     -22.025  -1.318  -7.475  1.00 40.03           O  
ATOM    764  CB  LEU A  52     -19.043  -1.459  -7.318  1.00 52.40           C  
ATOM    765  CG  LEU A  52     -17.626  -1.667  -6.774  1.00 71.42           C  
ATOM    766  CD1 LEU A  52     -16.799  -2.498  -7.742  1.00 42.13           C  
ATOM    767  CD2 LEU A  52     -16.952  -0.327  -6.512  1.00 73.05           C  
ATOM    768  H   LEU A  52     -20.263  -2.387  -5.210  1.00 37.91           H  
ATOM    769  HA  LEU A  52     -19.515   0.265  -6.145  1.00 63.14           H  
ATOM    770  HB2 LEU A  52     -19.483  -2.429  -7.499  1.00 37.91           H  
ATOM    771  HB3 LEU A  52     -18.971  -0.937  -8.255  1.00 37.91           H  
ATOM    772  HG  LEU A  52     -17.684  -2.202  -5.838  1.00 63.33           H  
ATOM    773 HD11 LEU A  52     -15.814  -2.658  -7.329  1.00 37.91           H  
ATOM    774 HD12 LEU A  52     -16.715  -1.976  -8.683  1.00 37.91           H  
ATOM    775 HD13 LEU A  52     -17.280  -3.451  -7.899  1.00 37.91           H  
ATOM    776 HD21 LEU A  52     -17.528   0.230  -5.787  1.00 37.91           H  
ATOM    777 HD22 LEU A  52     -16.895   0.234  -7.432  1.00 37.91           H  
ATOM    778 HD23 LEU A  52     -15.958  -0.494  -6.127  1.00 37.91           H  
ATOM    779  N   THR A  53     -21.605   0.880  -7.265  1.00 40.52           N  
ATOM    780  CA  THR A  53     -22.836   1.307  -7.912  1.00 12.44           C  
ATOM    781  C   THR A  53     -22.557   2.494  -8.827  1.00 65.13           C  
ATOM    782  O   THR A  53     -21.398   2.842  -9.068  1.00 70.40           O  
ATOM    783  CB  THR A  53     -23.902   1.712  -6.872  1.00 71.15           C  
ATOM    784  OG1 THR A  53     -23.348   2.660  -5.951  1.00  2.04           O  
ATOM    785  CG2 THR A  53     -24.424   0.503  -6.106  1.00 61.53           C  
ATOM    786  H   THR A  53     -20.975   1.566  -6.945  1.00 37.91           H  
ATOM    787  HA  THR A  53     -23.217   0.485  -8.501  1.00 23.41           H  
ATOM    788  HB  THR A  53     -24.731   2.173  -7.392  1.00 42.31           H  
ATOM    789  HG1 THR A  53     -22.741   2.208  -5.356  1.00  1.35           H  
ATOM    790 HG21 THR A  53     -24.876  -0.190  -6.798  1.00 37.91           H  
ATOM    791 HG22 THR A  53     -25.161   0.826  -5.386  1.00 37.91           H  
ATOM    792 HG23 THR A  53     -23.607   0.020  -5.593  1.00 37.91           H  
ATOM    793  N   GLU A  54     -23.609   3.116  -9.336  1.00 74.12           N  
ATOM    794  CA  GLU A  54     -23.463   4.334 -10.109  1.00  0.40           C  
ATOM    795  C   GLU A  54     -23.179   5.510  -9.183  1.00  2.35           C  
ATOM    796  O   GLU A  54     -22.611   6.516  -9.599  1.00  4.31           O  
ATOM    797  CB  GLU A  54     -24.726   4.610 -10.928  1.00 14.34           C  
ATOM    798  CG  GLU A  54     -24.804   3.849 -12.246  1.00 53.44           C  
ATOM    799  CD  GLU A  54     -24.917   2.349 -12.069  1.00 43.25           C  
ATOM    800  OE1 GLU A  54     -26.010   1.876 -11.690  1.00 42.13           O  
ATOM    801  OE2 GLU A  54     -23.929   1.638 -12.338  1.00 51.34           O  
ATOM    802  H   GLU A  54     -24.510   2.741  -9.197  1.00 37.91           H  
ATOM    803  HA  GLU A  54     -22.626   4.203 -10.779  1.00 74.13           H  
ATOM    804  HB2 GLU A  54     -25.586   4.339 -10.335  1.00 37.91           H  
ATOM    805  HB3 GLU A  54     -24.772   5.663 -11.143  1.00 37.91           H  
ATOM    806  HG2 GLU A  54     -25.668   4.195 -12.794  1.00 37.91           H  
ATOM    807  HG3 GLU A  54     -23.914   4.062 -12.820  1.00 37.91           H  
ATOM    808  N   GLU A  55     -23.555   5.368  -7.915  1.00 65.33           N  
ATOM    809  CA  GLU A  55     -23.421   6.457  -6.960  1.00 43.10           C  
ATOM    810  C   GLU A  55     -22.236   6.273  -6.021  1.00 22.30           C  
ATOM    811  O   GLU A  55     -22.118   6.983  -5.023  1.00 42.10           O  
ATOM    812  CB  GLU A  55     -24.704   6.625  -6.152  1.00 43.35           C  
ATOM    813  CG  GLU A  55     -25.722   7.520  -6.830  1.00 72.32           C  
ATOM    814  CD  GLU A  55     -25.139   8.877  -7.179  1.00 12.14           C  
ATOM    815  OE1 GLU A  55     -24.596   9.546  -6.275  1.00 44.11           O  
ATOM    816  OE2 GLU A  55     -25.200   9.271  -8.361  1.00 42.31           O  
ATOM    817  H   GLU A  55     -23.925   4.509  -7.616  1.00 37.91           H  
ATOM    818  HA  GLU A  55     -23.263   7.362  -7.529  1.00 41.15           H  
ATOM    819  HB2 GLU A  55     -25.152   5.654  -5.997  1.00 37.91           H  
ATOM    820  HB3 GLU A  55     -24.458   7.056  -5.190  1.00 37.91           H  
ATOM    821  HG2 GLU A  55     -26.058   7.043  -7.737  1.00 37.91           H  
ATOM    822  HG3 GLU A  55     -26.559   7.664  -6.163  1.00 37.91           H  
ATOM    823  N   SER A  56     -21.355   5.339  -6.332  1.00 63.32           N  
ATOM    824  CA  SER A  56     -20.132   5.204  -5.568  1.00 44.15           C  
ATOM    825  C   SER A  56     -19.038   6.072  -6.169  1.00 23.22           C  
ATOM    826  O   SER A  56     -18.407   5.701  -7.158  1.00  4.41           O  
ATOM    827  CB  SER A  56     -19.691   3.742  -5.494  1.00 34.24           C  
ATOM    828  OG  SER A  56     -19.887   3.082  -6.735  1.00 45.14           O  
ATOM    829  H   SER A  56     -21.527   4.732  -7.079  1.00 37.91           H  
ATOM    830  HA  SER A  56     -20.336   5.556  -4.569  1.00 25.21           H  
ATOM    831  HB2 SER A  56     -18.644   3.703  -5.246  1.00 37.91           H  
ATOM    832  HB3 SER A  56     -20.260   3.236  -4.733  1.00 37.91           H  
ATOM    833  HG  SER A  56     -19.444   3.580  -7.434  1.00  3.24           H  
ATOM    834  N   LYS A  57     -18.848   7.246  -5.583  1.00 51.34           N  
ATOM    835  CA  LYS A  57     -17.770   8.142  -5.979  1.00 13.40           C  
ATOM    836  C   LYS A  57     -16.579   7.890  -5.068  1.00 63.34           C  
ATOM    837  O   LYS A  57     -15.547   8.559  -5.147  1.00 34.44           O  
ATOM    838  CB  LYS A  57     -18.204   9.615  -5.890  1.00 70.52           C  
ATOM    839  CG  LYS A  57     -19.275  10.023  -6.900  1.00 12.15           C  
ATOM    840  CD  LYS A  57     -20.664   9.544  -6.500  1.00 33.34           C  
ATOM    841  CE  LYS A  57     -21.133  10.200  -5.209  1.00 32.15           C  
ATOM    842  NZ  LYS A  57     -22.431   9.645  -4.741  1.00  1.44           N  
ATOM    843  H   LYS A  57     -19.442   7.514  -4.846  1.00 37.91           H  
ATOM    844  HA  LYS A  57     -17.492   7.908  -6.995  1.00 54.45           H  
ATOM    845  HB2 LYS A  57     -18.590   9.802  -4.898  1.00 37.91           H  
ATOM    846  HB3 LYS A  57     -17.336  10.238  -6.049  1.00 37.91           H  
ATOM    847  HG2 LYS A  57     -19.289  11.099  -6.976  1.00 37.91           H  
ATOM    848  HG3 LYS A  57     -19.023   9.599  -7.859  1.00 37.91           H  
ATOM    849  HD2 LYS A  57     -21.360   9.792  -7.289  1.00 37.91           H  
ATOM    850  HD3 LYS A  57     -20.638   8.473  -6.362  1.00 37.91           H  
ATOM    851  HE2 LYS A  57     -20.386  10.037  -4.447  1.00 37.91           H  
ATOM    852  HE3 LYS A  57     -21.246  11.260  -5.380  1.00 37.91           H  
ATOM    853  HZ1 LYS A  57     -23.179   9.811  -5.453  1.00 37.91           H  
ATOM    854  HZ2 LYS A  57     -22.714  10.099  -3.847  1.00 37.91           H  
ATOM    855  HZ3 LYS A  57     -22.346   8.619  -4.581  1.00 37.91           H  
ATOM    856  N   GLU A  58     -16.749   6.901  -4.203  1.00  5.33           N  
ATOM    857  CA  GLU A  58     -15.741   6.518  -3.239  1.00 42.22           C  
ATOM    858  C   GLU A  58     -15.794   5.015  -3.042  1.00 73.25           C  
ATOM    859  O   GLU A  58     -16.875   4.429  -3.004  1.00 20.23           O  
ATOM    860  CB  GLU A  58     -15.996   7.224  -1.903  1.00  4.34           C  
ATOM    861  CG  GLU A  58     -15.060   6.804  -0.781  1.00 32.42           C  
ATOM    862  CD  GLU A  58     -15.641   7.076   0.593  1.00 24.32           C  
ATOM    863  OE1 GLU A  58     -15.882   8.256   0.926  1.00  4.23           O  
ATOM    864  OE2 GLU A  58     -15.887   6.105   1.339  1.00  1.04           O  
ATOM    865  H   GLU A  58     -17.590   6.392  -4.227  1.00 37.91           H  
ATOM    866  HA  GLU A  58     -14.772   6.801  -3.627  1.00 30.20           H  
ATOM    867  HB2 GLU A  58     -15.887   8.287  -2.050  1.00 37.91           H  
ATOM    868  HB3 GLU A  58     -17.008   7.017  -1.592  1.00 37.91           H  
ATOM    869  HG2 GLU A  58     -14.863   5.747  -0.870  1.00 37.91           H  
ATOM    870  HG3 GLU A  58     -14.132   7.352  -0.879  1.00 37.91           H  
ATOM    871  N   LEU A  59     -14.640   4.391  -2.939  1.00 75.54           N  
ATOM    872  CA  LEU A  59     -14.584   2.965  -2.672  1.00 41.42           C  
ATOM    873  C   LEU A  59     -13.387   2.636  -1.803  1.00 24.44           C  
ATOM    874  O   LEU A  59     -12.357   3.308  -1.860  1.00 21.22           O  
ATOM    875  CB  LEU A  59     -14.546   2.141  -3.971  1.00 72.41           C  
ATOM    876  CG  LEU A  59     -13.184   2.018  -4.670  1.00 21.42           C  
ATOM    877  CD1 LEU A  59     -13.289   1.094  -5.869  1.00  2.11           C  
ATOM    878  CD2 LEU A  59     -12.653   3.368  -5.114  1.00 12.32           C  
ATOM    879  H   LEU A  59     -13.806   4.902  -3.029  1.00 37.91           H  
ATOM    880  HA  LEU A  59     -15.479   2.706  -2.127  1.00 71.33           H  
ATOM    881  HB2 LEU A  59     -14.893   1.144  -3.741  1.00 37.91           H  
ATOM    882  HB3 LEU A  59     -15.240   2.584  -4.665  1.00 37.91           H  
ATOM    883  HG  LEU A  59     -12.473   1.586  -3.980  1.00 64.43           H  
ATOM    884 HD11 LEU A  59     -12.331   1.039  -6.363  1.00 37.91           H  
ATOM    885 HD12 LEU A  59     -14.027   1.480  -6.557  1.00 37.91           H  
ATOM    886 HD13 LEU A  59     -13.582   0.109  -5.540  1.00 37.91           H  
ATOM    887 HD21 LEU A  59     -12.575   4.024  -4.258  1.00 37.91           H  
ATOM    888 HD22 LEU A  59     -13.324   3.798  -5.839  1.00 37.91           H  
ATOM    889 HD23 LEU A  59     -11.676   3.239  -5.560  1.00 37.91           H  
ATOM    890  N   THR A  60     -13.539   1.614  -0.989  1.00 30.31           N  
ATOM    891  CA  THR A  60     -12.471   1.166  -0.124  1.00 64.42           C  
ATOM    892  C   THR A  60     -12.140  -0.295  -0.414  1.00 34.33           C  
ATOM    893  O   THR A  60     -12.903  -1.197  -0.074  1.00 70.32           O  
ATOM    894  CB  THR A  60     -12.860   1.338   1.356  1.00 43.33           C  
ATOM    895  OG1 THR A  60     -13.306   2.685   1.580  1.00 10.32           O  
ATOM    896  CG2 THR A  60     -11.687   1.035   2.270  1.00 41.12           C  
ATOM    897  H   THR A  60     -14.405   1.143  -0.965  1.00 37.91           H  
ATOM    898  HA  THR A  60     -11.599   1.773  -0.324  1.00  1.44           H  
ATOM    899  HB  THR A  60     -13.666   0.657   1.585  1.00 33.20           H  
ATOM    900  HG1 THR A  60     -13.802   2.986   0.812  1.00 65.12           H  
ATOM    901 HG21 THR A  60     -11.375   0.012   2.127  1.00 37.91           H  
ATOM    902 HG22 THR A  60     -11.986   1.179   3.299  1.00 37.91           H  
ATOM    903 HG23 THR A  60     -10.868   1.698   2.039  1.00 37.91           H  
ATOM    904  N   ALA A  61     -11.015  -0.518  -1.071  1.00  4.34           N  
ATOM    905  CA  ALA A  61     -10.598  -1.862  -1.427  1.00 51.31           C  
ATOM    906  C   ALA A  61      -9.380  -2.266  -0.615  1.00 51.42           C  
ATOM    907  O   ALA A  61      -8.360  -1.576  -0.633  1.00  3.32           O  
ATOM    908  CB  ALA A  61     -10.306  -1.952  -2.916  1.00 71.21           C  
ATOM    909  H   ALA A  61     -10.441   0.243  -1.315  1.00 37.91           H  
ATOM    910  HA  ALA A  61     -11.411  -2.536  -1.198  1.00 42.11           H  
ATOM    911  HB1 ALA A  61     -11.178  -1.644  -3.472  1.00 37.91           H  
ATOM    912  HB2 ALA A  61     -10.057  -2.971  -3.173  1.00 37.91           H  
ATOM    913  HB3 ALA A  61      -9.477  -1.305  -3.159  1.00 37.91           H  
ATOM    914  N   ARG A  62      -9.490  -3.372   0.105  1.00 45.43           N  
ATOM    915  CA  ARG A  62      -8.401  -3.827   0.955  1.00 21.03           C  
ATOM    916  C   ARG A  62      -7.766  -5.091   0.430  1.00 42.54           C  
ATOM    917  O   ARG A  62      -8.444  -6.078   0.149  1.00 75.41           O  
ATOM    918  CB  ARG A  62      -8.855  -4.017   2.401  1.00 65.20           C  
ATOM    919  CG  ARG A  62     -10.181  -4.735   2.566  1.00 43.41           C  
ATOM    920  CD  ARG A  62     -10.593  -4.749   4.027  1.00 63.24           C  
ATOM    921  NE  ARG A  62     -10.447  -3.426   4.640  1.00 12.43           N  
ATOM    922  CZ  ARG A  62     -11.377  -2.830   5.377  1.00 64.45           C  
ATOM    923  NH1 ARG A  62     -12.520  -3.454   5.642  1.00 25.12           N  
ATOM    924  NH2 ARG A  62     -11.152  -1.611   5.857  1.00 35.31           N  
ATOM    925  H   ARG A  62     -10.313  -3.901   0.048  1.00 37.91           H  
ATOM    926  HA  ARG A  62      -7.648  -3.058   0.938  1.00 63.11           H  
ATOM    927  HB2 ARG A  62      -8.103  -4.585   2.925  1.00 37.91           H  
ATOM    928  HB3 ARG A  62      -8.941  -3.046   2.865  1.00 37.91           H  
ATOM    929  HG2 ARG A  62     -10.936  -4.221   1.989  1.00 37.91           H  
ATOM    930  HG3 ARG A  62     -10.082  -5.751   2.216  1.00 37.91           H  
ATOM    931  HD2 ARG A  62     -11.627  -5.056   4.096  1.00 37.91           H  
ATOM    932  HD3 ARG A  62      -9.972  -5.453   4.560  1.00 37.91           H  
ATOM    933  HE  ARG A  62      -9.599  -2.951   4.480  1.00 14.11           H  
ATOM    934 HH11 ARG A  62     -12.681  -4.383   5.290  1.00 37.91           H  
ATOM    935 HH12 ARG A  62     -13.225  -3.000   6.186  1.00 37.91           H  
ATOM    936 HH21 ARG A  62     -10.275  -1.145   5.660  1.00 37.91           H  
ATOM    937 HH22 ARG A  62     -11.844  -1.143   6.409  1.00 37.91           H  
ATOM    938  N   PHE A  63      -6.457  -5.033   0.302  1.00 51.42           N  
ATOM    939  CA  PHE A  63      -5.668  -6.157  -0.149  1.00 64.50           C  
ATOM    940  C   PHE A  63      -4.980  -6.792   1.048  1.00 52.13           C  
ATOM    941  O   PHE A  63      -4.218  -6.125   1.750  1.00 72.44           O  
ATOM    942  CB  PHE A  63      -4.608  -5.694  -1.158  1.00 71.35           C  
ATOM    943  CG  PHE A  63      -5.160  -4.925  -2.324  1.00 43.14           C  
ATOM    944  CD1 PHE A  63      -5.314  -3.550  -2.253  1.00 14.42           C  
ATOM    945  CD2 PHE A  63      -5.518  -5.577  -3.491  1.00 52.22           C  
ATOM    946  CE1 PHE A  63      -5.815  -2.840  -3.324  1.00 23.00           C  
ATOM    947  CE2 PHE A  63      -6.021  -4.873  -4.566  1.00 51.20           C  
ATOM    948  CZ  PHE A  63      -6.169  -3.502  -4.484  1.00 71.30           C  
ATOM    949  H   PHE A  63      -5.996  -4.193   0.530  1.00 37.91           H  
ATOM    950  HA  PHE A  63      -6.324  -6.875  -0.615  1.00 31.53           H  
ATOM    951  HB2 PHE A  63      -3.897  -5.056  -0.655  1.00 37.91           H  
ATOM    952  HB3 PHE A  63      -4.093  -6.559  -1.547  1.00 37.91           H  
ATOM    953  HD1 PHE A  63      -5.036  -3.030  -1.347  1.00 50.42           H  
ATOM    954  HD2 PHE A  63      -5.402  -6.649  -3.556  1.00 63.12           H  
ATOM    955  HE1 PHE A  63      -5.929  -1.768  -3.257  1.00 53.23           H  
ATOM    956  HE2 PHE A  63      -6.297  -5.394  -5.472  1.00 21.42           H  
ATOM    957  HZ  PHE A  63      -6.563  -2.949  -5.323  1.00 73.43           H  
ATOM    958  N   LYS A  64      -5.267  -8.056   1.309  1.00 11.23           N  
ATOM    959  CA  LYS A  64      -4.560  -8.768   2.355  1.00  5.32           C  
ATOM    960  C   LYS A  64      -3.487  -9.638   1.732  1.00 64.33           C  
ATOM    961  O   LYS A  64      -3.711 -10.292   0.710  1.00 45.31           O  
ATOM    962  CB  LYS A  64      -5.493  -9.618   3.219  1.00 21.05           C  
ATOM    963  CG  LYS A  64      -6.103 -10.811   2.508  1.00 53.21           C  
ATOM    964  CD  LYS A  64      -6.623 -11.831   3.504  1.00 24.20           C  
ATOM    965  CE  LYS A  64      -5.715 -13.050   3.597  1.00 31.10           C  
ATOM    966  NZ  LYS A  64      -4.298 -12.696   3.890  1.00 62.41           N  
ATOM    967  H   LYS A  64      -5.958  -8.520   0.782  1.00 37.91           H  
ATOM    968  HA  LYS A  64      -4.080  -8.030   2.983  1.00  0.24           H  
ATOM    969  HB2 LYS A  64      -4.938  -9.984   4.068  1.00 37.91           H  
ATOM    970  HB3 LYS A  64      -6.300  -8.993   3.575  1.00 37.91           H  
ATOM    971  HG2 LYS A  64      -6.922 -10.473   1.892  1.00 37.91           H  
ATOM    972  HG3 LYS A  64      -5.349 -11.274   1.890  1.00 37.91           H  
ATOM    973  HD2 LYS A  64      -6.684 -11.369   4.477  1.00 37.91           H  
ATOM    974  HD3 LYS A  64      -7.602 -12.146   3.193  1.00 37.91           H  
ATOM    975  HE2 LYS A  64      -6.081 -13.691   4.385  1.00 37.91           H  
ATOM    976  HE3 LYS A  64      -5.757 -13.581   2.657  1.00 37.91           H  
ATOM    977  HZ1 LYS A  64      -3.751 -13.557   4.091  1.00 37.91           H  
ATOM    978  HZ2 LYS A  64      -4.240 -12.059   4.720  1.00 37.91           H  
ATOM    979  HZ3 LYS A  64      -3.870 -12.219   3.071  1.00 37.91           H  
ATOM    980  N   PHE A  65      -2.334  -9.645   2.355  1.00 42.12           N  
ATOM    981  CA  PHE A  65      -1.181 -10.341   1.819  1.00 64.31           C  
ATOM    982  C   PHE A  65      -0.866 -11.559   2.668  1.00 31.12           C  
ATOM    983  O   PHE A  65      -1.625 -11.907   3.573  1.00 71.01           O  
ATOM    984  CB  PHE A  65       0.020  -9.397   1.767  1.00 63.54           C  
ATOM    985  CG  PHE A  65      -0.203  -8.196   0.895  1.00 63.04           C  
ATOM    986  CD1 PHE A  65       0.042  -8.260  -0.468  1.00 24.11           C  
ATOM    987  CD2 PHE A  65      -0.655  -7.004   1.436  1.00 61.40           C  
ATOM    988  CE1 PHE A  65      -0.160  -7.156  -1.274  1.00 51.15           C  
ATOM    989  CE2 PHE A  65      -0.860  -5.899   0.635  1.00 31.20           C  
ATOM    990  CZ  PHE A  65      -0.611  -5.975  -0.722  1.00  3.12           C  
ATOM    991  H   PHE A  65      -2.255  -9.174   3.211  1.00 37.91           H  
ATOM    992  HA  PHE A  65      -1.419 -10.664   0.817  1.00 12.20           H  
ATOM    993  HB2 PHE A  65       0.239  -9.048   2.766  1.00 37.91           H  
ATOM    994  HB3 PHE A  65       0.875  -9.933   1.383  1.00 37.91           H  
ATOM    995  HD1 PHE A  65       0.393  -9.184  -0.900  1.00 15.41           H  
ATOM    996  HD2 PHE A  65      -0.852  -6.943   2.495  1.00 54.52           H  
ATOM    997  HE1 PHE A  65       0.033  -7.219  -2.336  1.00 52.05           H  
ATOM    998  HE2 PHE A  65      -1.213  -4.975   1.069  1.00 14.52           H  
ATOM    999  HZ  PHE A  65      -0.770  -5.111  -1.350  1.00 22.23           H  
ATOM   1000  N   GLU A  66       0.249 -12.201   2.382  1.00 71.22           N  
ATOM   1001  CA  GLU A  66       0.637 -13.398   3.095  1.00 54.42           C  
ATOM   1002  C   GLU A  66       1.352 -13.034   4.383  1.00 65.10           C  
ATOM   1003  O   GLU A  66       1.172 -13.682   5.415  1.00 61.13           O  
ATOM   1004  CB  GLU A  66       1.526 -14.256   2.203  1.00 41.41           C  
ATOM   1005  CG  GLU A  66       0.811 -14.766   0.962  1.00 62.34           C  
ATOM   1006  CD  GLU A  66      -0.318 -15.720   1.290  1.00 12.25           C  
ATOM   1007  OE1 GLU A  66      -1.356 -15.274   1.825  1.00 75.34           O  
ATOM   1008  OE2 GLU A  66      -0.172 -16.928   1.021  1.00 63.54           O  
ATOM   1009  H   GLU A  66       0.848 -11.851   1.678  1.00 37.91           H  
ATOM   1010  HA  GLU A  66      -0.261 -13.949   3.333  1.00 71.04           H  
ATOM   1011  HB2 GLU A  66       2.376 -13.667   1.889  1.00 37.91           H  
ATOM   1012  HB3 GLU A  66       1.872 -15.100   2.767  1.00 37.91           H  
ATOM   1013  HG2 GLU A  66       0.403 -13.924   0.425  1.00 37.91           H  
ATOM   1014  HG3 GLU A  66       1.525 -15.279   0.336  1.00 37.91           H  
ATOM   1015  N   VAL A  67       2.157 -11.987   4.323  1.00 75.45           N  
ATOM   1016  CA  VAL A  67       2.855 -11.499   5.499  1.00 74.11           C  
ATOM   1017  C   VAL A  67       2.684  -9.991   5.635  1.00  1.20           C  
ATOM   1018  O   VAL A  67       2.404  -9.294   4.655  1.00  3.04           O  
ATOM   1019  CB  VAL A  67       4.360 -11.852   5.469  1.00 75.20           C  
ATOM   1020  CG1 VAL A  67       4.553 -13.359   5.453  1.00 23.24           C  
ATOM   1021  CG2 VAL A  67       5.054 -11.218   4.274  1.00 15.33           C  
ATOM   1022  H   VAL A  67       2.284 -11.527   3.460  1.00 37.91           H  
ATOM   1023  HA  VAL A  67       2.413 -11.975   6.362  1.00 24.10           H  
ATOM   1024  HB  VAL A  67       4.815 -11.465   6.369  1.00 13.13           H  
ATOM   1025 HG11 VAL A  67       4.096 -13.789   6.332  1.00 37.91           H  
ATOM   1026 HG12 VAL A  67       5.609 -13.585   5.449  1.00 37.91           H  
ATOM   1027 HG13 VAL A  67       4.093 -13.772   4.570  1.00 37.91           H  
ATOM   1028 HG21 VAL A  67       6.101 -11.486   4.281  1.00 37.91           H  
ATOM   1029 HG22 VAL A  67       4.956 -10.143   4.327  1.00 37.91           H  
ATOM   1030 HG23 VAL A  67       4.598 -11.576   3.361  1.00 37.91           H  
ATOM   1031  N   SER A  68       2.854  -9.488   6.850  1.00 35.03           N  
ATOM   1032  CA  SER A  68       2.687  -8.072   7.127  1.00 51.35           C  
ATOM   1033  C   SER A  68       3.754  -7.238   6.422  1.00 11.24           C  
ATOM   1034  O   SER A  68       3.579  -6.039   6.200  1.00 25.43           O  
ATOM   1035  CB  SER A  68       2.732  -7.839   8.637  1.00 74.21           C  
ATOM   1036  OG  SER A  68       1.689  -8.552   9.288  1.00 11.13           O  
ATOM   1037  H   SER A  68       3.092 -10.096   7.590  1.00 37.91           H  
ATOM   1038  HA  SER A  68       1.722  -7.779   6.756  1.00  4.33           H  
ATOM   1039  HB2 SER A  68       3.680  -8.182   9.024  1.00 37.91           H  
ATOM   1040  HB3 SER A  68       2.617  -6.787   8.841  1.00 37.91           H  
ATOM   1041  HG  SER A  68       0.948  -7.951   9.446  1.00 62.15           H  
ATOM   1042  N   ALA A  69       4.845  -7.891   6.052  1.00 13.33           N  
ATOM   1043  CA  ALA A  69       5.925  -7.236   5.329  1.00 31.11           C  
ATOM   1044  C   ALA A  69       5.452  -6.792   3.949  1.00 53.45           C  
ATOM   1045  O   ALA A  69       5.796  -5.706   3.489  1.00 20.41           O  
ATOM   1046  CB  ALA A  69       7.125  -8.166   5.209  1.00  0.31           C  
ATOM   1047  H   ALA A  69       4.922  -8.841   6.275  1.00 37.91           H  
ATOM   1048  HA  ALA A  69       6.226  -6.367   5.893  1.00 64.54           H  
ATOM   1049  HB1 ALA A  69       6.845  -9.046   4.650  1.00 37.91           H  
ATOM   1050  HB2 ALA A  69       7.458  -8.455   6.195  1.00 37.91           H  
ATOM   1051  HB3 ALA A  69       7.925  -7.655   4.693  1.00 37.91           H  
ATOM   1052  N   GLU A  70       4.641  -7.628   3.307  1.00 74.43           N  
ATOM   1053  CA  GLU A  70       4.116  -7.334   1.980  1.00 62.21           C  
ATOM   1054  C   GLU A  70       3.180  -6.128   2.026  1.00  1.35           C  
ATOM   1055  O   GLU A  70       3.121  -5.338   1.084  1.00 53.33           O  
ATOM   1056  CB  GLU A  70       3.385  -8.559   1.432  1.00 44.40           C  
ATOM   1057  CG  GLU A  70       4.294  -9.758   1.233  1.00 20.40           C  
ATOM   1058  CD  GLU A  70       3.554 -10.970   0.720  1.00 61.15           C  
ATOM   1059  OE1 GLU A  70       2.531 -11.348   1.326  1.00 63.43           O  
ATOM   1060  OE2 GLU A  70       4.004 -11.567  -0.278  1.00 40.32           O  
ATOM   1061  H   GLU A  70       4.382  -8.469   3.740  1.00 37.91           H  
ATOM   1062  HA  GLU A  70       4.952  -7.103   1.335  1.00 34.14           H  
ATOM   1063  HB2 GLU A  70       2.606  -8.836   2.124  1.00 37.91           H  
ATOM   1064  HB3 GLU A  70       2.939  -8.312   0.482  1.00 37.91           H  
ATOM   1065  HG2 GLU A  70       5.062  -9.498   0.522  1.00 37.91           H  
ATOM   1066  HG3 GLU A  70       4.751 -10.007   2.180  1.00 37.91           H  
ATOM   1067  N   LYS A  71       2.463  -5.995   3.139  1.00 54.22           N  
ATOM   1068  CA  LYS A  71       1.604  -4.839   3.368  1.00  2.40           C  
ATOM   1069  C   LYS A  71       2.437  -3.574   3.333  1.00 63.55           C  
ATOM   1070  O   LYS A  71       2.173  -2.655   2.562  1.00  5.02           O  
ATOM   1071  CB  LYS A  71       0.928  -4.939   4.734  1.00 73.31           C  
ATOM   1072  CG  LYS A  71      -0.167  -3.902   4.947  1.00 22.33           C  
ATOM   1073  CD  LYS A  71      -0.821  -4.040   6.310  1.00 43.12           C  
ATOM   1074  CE  LYS A  71       0.158  -3.774   7.443  1.00 74.11           C  
ATOM   1075  NZ  LYS A  71       0.547  -2.340   7.539  1.00 63.44           N  
ATOM   1076  H   LYS A  71       2.513  -6.695   3.820  1.00 37.91           H  
ATOM   1077  HA  LYS A  71       0.855  -4.801   2.593  1.00 61.44           H  
ATOM   1078  HB2 LYS A  71       0.508  -5.919   4.843  1.00 37.91           H  
ATOM   1079  HB3 LYS A  71       1.676  -4.797   5.502  1.00 37.91           H  
ATOM   1080  HG2 LYS A  71       0.268  -2.916   4.866  1.00 37.91           H  
ATOM   1081  HG3 LYS A  71      -0.919  -4.029   4.181  1.00 37.91           H  
ATOM   1082  HD2 LYS A  71      -1.633  -3.333   6.378  1.00 37.91           H  
ATOM   1083  HD3 LYS A  71      -1.208  -5.044   6.410  1.00 37.91           H  
ATOM   1084  HE2 LYS A  71      -0.302  -4.070   8.373  1.00 37.91           H  
ATOM   1085  HE3 LYS A  71       1.045  -4.366   7.277  1.00 37.91           H  
ATOM   1086  HZ1 LYS A  71      -0.289  -1.749   7.743  1.00 37.91           H  
ATOM   1087  HZ2 LYS A  71       0.973  -2.013   6.639  1.00 37.91           H  
ATOM   1088  HZ3 LYS A  71       1.243  -2.210   8.303  1.00 37.91           H  
ATOM   1089  N   LEU A  72       3.448  -3.562   4.185  1.00 72.13           N  
ATOM   1090  CA  LEU A  72       4.371  -2.434   4.295  1.00 73.02           C  
ATOM   1091  C   LEU A  72       4.978  -2.081   2.942  1.00  4.43           C  
ATOM   1092  O   LEU A  72       5.043  -0.909   2.576  1.00 32.32           O  
ATOM   1093  CB  LEU A  72       5.477  -2.759   5.297  1.00 52.03           C  
ATOM   1094  CG  LEU A  72       5.004  -3.005   6.729  1.00 52.54           C  
ATOM   1095  CD1 LEU A  72       6.173  -3.390   7.620  1.00 64.55           C  
ATOM   1096  CD2 LEU A  72       4.299  -1.772   7.278  1.00  4.03           C  
ATOM   1097  H   LEU A  72       3.569  -4.339   4.775  1.00 37.91           H  
ATOM   1098  HA  LEU A  72       3.811  -1.585   4.656  1.00 35.41           H  
ATOM   1099  HB2 LEU A  72       5.997  -3.641   4.953  1.00 37.91           H  
ATOM   1100  HB3 LEU A  72       6.175  -1.935   5.309  1.00 37.91           H  
ATOM   1101  HG  LEU A  72       4.298  -3.824   6.735  1.00 72.35           H  
ATOM   1102 HD11 LEU A  72       5.816  -3.590   8.619  1.00 37.91           H  
ATOM   1103 HD12 LEU A  72       6.885  -2.579   7.648  1.00 37.91           H  
ATOM   1104 HD13 LEU A  72       6.650  -4.274   7.223  1.00 37.91           H  
ATOM   1105 HD21 LEU A  72       3.949  -1.971   8.280  1.00 37.91           H  
ATOM   1106 HD22 LEU A  72       3.460  -1.527   6.645  1.00 37.91           H  
ATOM   1107 HD23 LEU A  72       4.991  -0.942   7.297  1.00 37.91           H  
ATOM   1108  N   ILE A  73       5.414  -3.095   2.201  1.00 11.32           N  
ATOM   1109  CA  ILE A  73       5.981  -2.887   0.869  1.00 22.13           C  
ATOM   1110  C   ILE A  73       4.967  -2.211  -0.053  1.00  2.33           C  
ATOM   1111  O   ILE A  73       5.299  -1.264  -0.771  1.00  2.12           O  
ATOM   1112  CB  ILE A  73       6.441  -4.221   0.236  1.00 20.44           C  
ATOM   1113  CG1 ILE A  73       7.559  -4.843   1.077  1.00 14.40           C  
ATOM   1114  CG2 ILE A  73       6.911  -4.007  -1.199  1.00 43.31           C  
ATOM   1115  CD1 ILE A  73       7.995  -6.216   0.606  1.00 71.30           C  
ATOM   1116  H   ILE A  73       5.361  -4.007   2.561  1.00 37.91           H  
ATOM   1117  HA  ILE A  73       6.843  -2.242   0.970  1.00 32.12           H  
ATOM   1118  HB  ILE A  73       5.598  -4.894   0.215  1.00 13.52           H  
ATOM   1119 HG12 ILE A  73       8.424  -4.196   1.045  1.00 37.91           H  
ATOM   1120 HG13 ILE A  73       7.223  -4.933   2.099  1.00 37.91           H  
ATOM   1121 HG21 ILE A  73       6.106  -3.586  -1.782  1.00 37.91           H  
ATOM   1122 HG22 ILE A  73       7.208  -4.954  -1.624  1.00 37.91           H  
ATOM   1123 HG23 ILE A  73       7.752  -3.328  -1.205  1.00 37.91           H  
ATOM   1124 HD11 ILE A  73       8.404  -6.142  -0.391  1.00 37.91           H  
ATOM   1125 HD12 ILE A  73       7.145  -6.881   0.598  1.00 37.91           H  
ATOM   1126 HD13 ILE A  73       8.748  -6.603   1.276  1.00 37.91           H  
ATOM   1127  N   PHE A  74       3.730  -2.692  -0.023  1.00 14.40           N  
ATOM   1128  CA  PHE A  74       2.666  -2.119  -0.839  1.00 53.21           C  
ATOM   1129  C   PHE A  74       2.399  -0.673  -0.426  1.00  0.50           C  
ATOM   1130  O   PHE A  74       2.223   0.205  -1.273  1.00 61.34           O  
ATOM   1131  CB  PHE A  74       1.392  -2.959  -0.712  1.00 13.52           C  
ATOM   1132  CG  PHE A  74       0.282  -2.535  -1.635  1.00  1.34           C  
ATOM   1133  CD1 PHE A  74       0.320  -2.862  -2.981  1.00 70.50           C  
ATOM   1134  CD2 PHE A  74      -0.804  -1.818  -1.155  1.00  5.53           C  
ATOM   1135  CE1 PHE A  74      -0.700  -2.482  -3.832  1.00 53.24           C  
ATOM   1136  CE2 PHE A  74      -1.827  -1.434  -2.001  1.00 22.25           C  
ATOM   1137  CZ  PHE A  74      -1.775  -1.766  -3.343  1.00 34.30           C  
ATOM   1138  H   PHE A  74       3.526  -3.454   0.564  1.00 37.91           H  
ATOM   1139  HA  PHE A  74       2.996  -2.132  -1.867  1.00 32.14           H  
ATOM   1140  HB2 PHE A  74       1.627  -3.988  -0.933  1.00 37.91           H  
ATOM   1141  HB3 PHE A  74       1.028  -2.890   0.302  1.00 37.91           H  
ATOM   1142  HD1 PHE A  74       1.159  -3.420  -3.366  1.00 72.23           H  
ATOM   1143  HD2 PHE A  74      -0.846  -1.558  -0.106  1.00 63.04           H  
ATOM   1144  HE1 PHE A  74      -0.658  -2.744  -4.879  1.00 75.25           H  
ATOM   1145  HE2 PHE A  74      -2.667  -0.875  -1.614  1.00 42.44           H  
ATOM   1146  HZ  PHE A  74      -2.573  -1.466  -4.005  1.00 73.42           H  
ATOM   1147  N   GLU A  75       2.383  -0.430   0.880  1.00 34.52           N  
ATOM   1148  CA  GLU A  75       2.188   0.912   1.416  1.00 72.02           C  
ATOM   1149  C   GLU A  75       3.340   1.828   1.011  1.00 41.04           C  
ATOM   1150  O   GLU A  75       3.126   2.983   0.650  1.00 62.01           O  
ATOM   1151  CB  GLU A  75       2.047   0.869   2.943  1.00 11.52           C  
ATOM   1152  CG  GLU A  75       0.777   0.175   3.416  1.00 32.11           C  
ATOM   1153  CD  GLU A  75       0.686   0.073   4.926  1.00 74.54           C  
ATOM   1154  OE1 GLU A  75       1.198  -0.914   5.490  1.00 31.31           O  
ATOM   1155  OE2 GLU A  75       0.091   0.979   5.557  1.00 13.55           O  
ATOM   1156  H   GLU A  75       2.504  -1.180   1.505  1.00 37.91           H  
ATOM   1157  HA  GLU A  75       1.274   1.302   0.994  1.00 61.44           H  
ATOM   1158  HB2 GLU A  75       2.896   0.344   3.357  1.00 37.91           H  
ATOM   1159  HB3 GLU A  75       2.042   1.881   3.320  1.00 37.91           H  
ATOM   1160  HG2 GLU A  75      -0.076   0.734   3.060  1.00 37.91           H  
ATOM   1161  HG3 GLU A  75       0.751  -0.822   3.003  1.00 37.91           H  
ATOM   1162  N   LEU A  76       4.559   1.301   1.052  1.00 60.12           N  
ATOM   1163  CA  LEU A  76       5.736   2.044   0.665  1.00 64.41           C  
ATOM   1164  C   LEU A  76       5.711   2.398  -0.820  1.00 12.52           C  
ATOM   1165  O   LEU A  76       6.010   3.530  -1.203  1.00  4.44           O  
ATOM   1166  CB  LEU A  76       6.974   1.215   0.992  1.00  3.24           C  
ATOM   1167  CG  LEU A  76       7.346   1.147   2.475  1.00 52.51           C  
ATOM   1168  CD1 LEU A  76       8.536   0.224   2.683  1.00 12.13           C  
ATOM   1169  CD2 LEU A  76       7.649   2.534   3.019  1.00 65.34           C  
ATOM   1170  H   LEU A  76       4.677   0.379   1.368  1.00 37.91           H  
ATOM   1171  HA  LEU A  76       5.763   2.956   1.242  1.00 13.10           H  
ATOM   1172  HB2 LEU A  76       6.802   0.208   0.643  1.00 37.91           H  
ATOM   1173  HB3 LEU A  76       7.799   1.621   0.454  1.00 37.91           H  
ATOM   1174  HG  LEU A  76       6.512   0.745   3.031  1.00 24.42           H  
ATOM   1175 HD11 LEU A  76       8.766   0.165   3.737  1.00 37.91           H  
ATOM   1176 HD12 LEU A  76       9.392   0.612   2.150  1.00 37.91           H  
ATOM   1177 HD13 LEU A  76       8.296  -0.760   2.311  1.00 37.91           H  
ATOM   1178 HD21 LEU A  76       7.894   2.463   4.068  1.00 37.91           H  
ATOM   1179 HD22 LEU A  76       6.784   3.168   2.894  1.00 37.91           H  
ATOM   1180 HD23 LEU A  76       8.487   2.957   2.482  1.00 37.91           H  
ATOM   1181  N   LYS A  77       5.347   1.432  -1.656  1.00 50.24           N  
ATOM   1182  CA  LYS A  77       5.299   1.654  -3.097  1.00 21.50           C  
ATOM   1183  C   LYS A  77       4.181   2.619  -3.479  1.00 45.51           C  
ATOM   1184  O   LYS A  77       4.366   3.484  -4.338  1.00 32.23           O  
ATOM   1185  CB  LYS A  77       5.134   0.330  -3.846  1.00 45.20           C  
ATOM   1186  CG  LYS A  77       6.369  -0.551  -3.794  1.00 11.11           C  
ATOM   1187  CD  LYS A  77       6.212  -1.785  -4.662  1.00 33.42           C  
ATOM   1188  CE  LYS A  77       7.485  -2.618  -4.691  1.00 61.12           C  
ATOM   1189  NZ  LYS A  77       8.640  -1.852  -5.235  1.00 22.13           N  
ATOM   1190  H   LYS A  77       5.116   0.545  -1.295  1.00 37.91           H  
ATOM   1191  HA  LYS A  77       6.241   2.095  -3.385  1.00 12.31           H  
ATOM   1192  HB2 LYS A  77       4.309  -0.216  -3.410  1.00 37.91           H  
ATOM   1193  HB3 LYS A  77       4.910   0.540  -4.880  1.00 37.91           H  
ATOM   1194  HG2 LYS A  77       7.219   0.015  -4.145  1.00 37.91           H  
ATOM   1195  HG3 LYS A  77       6.539  -0.860  -2.773  1.00 37.91           H  
ATOM   1196  HD2 LYS A  77       5.409  -2.391  -4.268  1.00 37.91           H  
ATOM   1197  HD3 LYS A  77       5.970  -1.477  -5.668  1.00 37.91           H  
ATOM   1198  HE2 LYS A  77       7.719  -2.932  -3.686  1.00 37.91           H  
ATOM   1199  HE3 LYS A  77       7.317  -3.486  -5.311  1.00 37.91           H  
ATOM   1200  HZ1 LYS A  77       8.432  -1.522  -6.201  1.00 37.91           H  
ATOM   1201  HZ2 LYS A  77       9.493  -2.455  -5.263  1.00 37.91           H  
ATOM   1202  HZ3 LYS A  77       8.840  -1.024  -4.632  1.00 37.91           H  
ATOM   1203  N   THR A  78       3.028   2.490  -2.829  1.00 22.40           N  
ATOM   1204  CA  THR A  78       1.891   3.345  -3.140  1.00 21.01           C  
ATOM   1205  C   THR A  78       2.174   4.802  -2.790  1.00 54.53           C  
ATOM   1206  O   THR A  78       1.553   5.704  -3.337  1.00  3.45           O  
ATOM   1207  CB  THR A  78       0.605   2.881  -2.429  1.00 23.20           C  
ATOM   1208  OG1 THR A  78       0.881   2.553  -1.064  1.00 61.12           O  
ATOM   1209  CG2 THR A  78       0.002   1.679  -3.138  1.00 13.01           C  
ATOM   1210  H   THR A  78       2.941   1.807  -2.129  1.00 37.91           H  
ATOM   1211  HA  THR A  78       1.722   3.282  -4.204  1.00 33.15           H  
ATOM   1212  HB  THR A  78      -0.112   3.691  -2.457  1.00 60.05           H  
ATOM   1213  HG1 THR A  78       1.190   1.637  -1.012  1.00 25.52           H  
ATOM   1214 HG21 THR A  78      -0.883   1.359  -2.611  1.00 37.91           H  
ATOM   1215 HG22 THR A  78       0.721   0.875  -3.158  1.00 37.91           H  
ATOM   1216 HG23 THR A  78      -0.260   1.953  -4.151  1.00 37.91           H  
ATOM   1217  N   ARG A  79       3.127   5.032  -1.896  1.00 12.31           N  
ATOM   1218  CA  ARG A  79       3.531   6.375  -1.541  1.00 62.12           C  
ATOM   1219  C   ARG A  79       4.065   7.135  -2.753  1.00 72.25           C  
ATOM   1220  O   ARG A  79       3.731   8.297  -2.962  1.00 34.42           O  
ATOM   1221  CB  ARG A  79       4.579   6.318  -0.439  1.00  1.12           C  
ATOM   1222  CG  ARG A  79       3.990   6.010   0.925  1.00 71.34           C  
ATOM   1223  CD  ARG A  79       3.096   7.144   1.399  1.00 43.34           C  
ATOM   1224  NE  ARG A  79       2.300   6.781   2.569  1.00 11.43           N  
ATOM   1225  CZ  ARG A  79       1.370   7.574   3.102  1.00 63.03           C  
ATOM   1226  NH1 ARG A  79       1.148   8.780   2.592  1.00 53.02           N  
ATOM   1227  NH2 ARG A  79       0.657   7.167   4.140  1.00  4.35           N  
ATOM   1228  H   ARG A  79       3.567   4.277  -1.451  1.00 37.91           H  
ATOM   1229  HA  ARG A  79       2.661   6.891  -1.164  1.00 15.24           H  
ATOM   1230  HB2 ARG A  79       5.298   5.550  -0.682  1.00 37.91           H  
ATOM   1231  HB3 ARG A  79       5.078   7.263  -0.390  1.00 37.91           H  
ATOM   1232  HG2 ARG A  79       3.407   5.104   0.860  1.00 37.91           H  
ATOM   1233  HG3 ARG A  79       4.795   5.873   1.629  1.00 37.91           H  
ATOM   1234  HD2 ARG A  79       3.718   7.992   1.653  1.00 37.91           H  
ATOM   1235  HD3 ARG A  79       2.430   7.420   0.595  1.00 37.91           H  
ATOM   1236  HE  ARG A  79       2.461   5.893   2.973  1.00 21.14           H  
ATOM   1237 HH11 ARG A  79       1.679   9.103   1.797  1.00 37.91           H  
ATOM   1238 HH12 ARG A  79       0.455   9.377   3.000  1.00 37.91           H  
ATOM   1239 HH21 ARG A  79       0.810   6.256   4.534  1.00 37.91           H  
ATOM   1240 HH22 ARG A  79      -0.042   7.772   4.538  1.00 37.91           H  
ATOM   1241  N   SER A  80       4.890   6.473  -3.550  1.00 44.41           N  
ATOM   1242  CA  SER A  80       5.455   7.080  -4.736  1.00 20.22           C  
ATOM   1243  C   SER A  80       4.476   7.051  -5.905  1.00 41.05           C  
ATOM   1244  O   SER A  80       4.667   7.741  -6.906  1.00  3.21           O  
ATOM   1245  CB  SER A  80       6.736   6.346  -5.102  1.00 73.40           C  
ATOM   1246  OG  SER A  80       7.666   6.410  -4.035  1.00 10.42           O  
ATOM   1247  H   SER A  80       5.144   5.554  -3.328  1.00 37.91           H  
ATOM   1248  HA  SER A  80       5.686   8.104  -4.506  1.00 60.03           H  
ATOM   1249  HB2 SER A  80       6.511   5.309  -5.310  1.00 37.91           H  
ATOM   1250  HB3 SER A  80       7.172   6.799  -5.969  1.00 37.91           H  
ATOM   1251  HG  SER A  80       7.529   7.235  -3.543  1.00 40.35           H  
ATOM   1252  N   LEU A  81       3.419   6.268  -5.765  1.00 32.31           N  
ATOM   1253  CA  LEU A  81       2.435   6.122  -6.814  1.00 71.01           C  
ATOM   1254  C   LEU A  81       1.267   7.088  -6.609  1.00 32.10           C  
ATOM   1255  O   LEU A  81       0.765   7.681  -7.562  1.00  4.41           O  
ATOM   1256  CB  LEU A  81       1.937   4.677  -6.831  1.00 43.51           C  
ATOM   1257  CG  LEU A  81       0.580   4.473  -7.489  1.00 64.50           C  
ATOM   1258  CD1 LEU A  81       0.655   4.720  -8.990  1.00 74.43           C  
ATOM   1259  CD2 LEU A  81       0.044   3.081  -7.198  1.00  5.31           C  
ATOM   1260  H   LEU A  81       3.294   5.769  -4.934  1.00 37.91           H  
ATOM   1261  HA  LEU A  81       2.912   6.340  -7.754  1.00 21.44           H  
ATOM   1262  HB2 LEU A  81       2.666   4.075  -7.353  1.00 37.91           H  
ATOM   1263  HB3 LEU A  81       1.874   4.331  -5.811  1.00 37.91           H  
ATOM   1264  HG  LEU A  81      -0.101   5.191  -7.063  1.00 52.33           H  
ATOM   1265 HD11 LEU A  81       0.968   5.738  -9.174  1.00 37.91           H  
ATOM   1266 HD12 LEU A  81      -0.319   4.560  -9.429  1.00 37.91           H  
ATOM   1267 HD13 LEU A  81       1.365   4.037  -9.434  1.00 37.91           H  
ATOM   1268 HD21 LEU A  81      -0.909   2.952  -7.691  1.00 37.91           H  
ATOM   1269 HD22 LEU A  81      -0.082   2.958  -6.132  1.00 37.91           H  
ATOM   1270 HD23 LEU A  81       0.741   2.342  -7.565  1.00 37.91           H  
ATOM   1271  N   ALA A  82       0.862   7.258  -5.362  1.00 35.44           N  
ATOM   1272  CA  ALA A  82      -0.337   8.025  -5.039  1.00 64.31           C  
ATOM   1273  C   ALA A  82      -0.028   9.489  -4.768  1.00 31.20           C  
ATOM   1274  O   ALA A  82      -0.840  10.209  -4.187  1.00 51.51           O  
ATOM   1275  CB  ALA A  82      -1.057   7.406  -3.854  1.00 43.42           C  
ATOM   1276  H   ALA A  82       1.382   6.852  -4.634  1.00 37.91           H  
ATOM   1277  HA  ALA A  82      -0.992   7.974  -5.891  1.00 24.24           H  
ATOM   1278  HB1 ALA A  82      -1.219   6.356  -4.044  1.00 37.91           H  
ATOM   1279  HB2 ALA A  82      -2.007   7.898  -3.716  1.00 37.91           H  
ATOM   1280  HB3 ALA A  82      -0.456   7.524  -2.964  1.00 37.91           H  
ATOM   1281  N   ARG A  83       1.138   9.931  -5.195  1.00 22.34           N  
ATOM   1282  CA  ARG A  83       1.476  11.335  -5.143  1.00 31.05           C  
ATOM   1283  C   ARG A  83       1.152  11.974  -6.480  1.00 65.02           C  
ATOM   1284  O   ARG A  83       0.692  11.280  -7.392  1.00 20.34           O  
ATOM   1285  CB  ARG A  83       2.946  11.530  -4.789  1.00 32.03           C  
ATOM   1286  CG  ARG A  83       3.238  11.351  -3.308  1.00 53.11           C  
ATOM   1287  CD  ARG A  83       4.629  11.840  -2.947  1.00 61.33           C  
ATOM   1288  NE  ARG A  83       5.669  11.139  -3.695  1.00 71.20           N  
ATOM   1289  CZ  ARG A  83       6.590  11.751  -4.431  1.00 22.41           C  
ATOM   1290  NH1 ARG A  83       6.617  13.080  -4.494  1.00 63.13           N  
ATOM   1291  NH2 ARG A  83       7.494  11.033  -5.082  1.00 30.33           N  
ATOM   1292  H   ARG A  83       1.776   9.304  -5.579  1.00 37.91           H  
ATOM   1293  HA  ARG A  83       0.864  11.795  -4.381  1.00 64.22           H  
ATOM   1294  HB2 ARG A  83       3.536  10.811  -5.340  1.00 37.91           H  
ATOM   1295  HB3 ARG A  83       3.240  12.517  -5.078  1.00 37.91           H  
ATOM   1296  HG2 ARG A  83       2.514  11.912  -2.738  1.00 37.91           H  
ATOM   1297  HG3 ARG A  83       3.161  10.303  -3.060  1.00 37.91           H  
ATOM   1298  HD2 ARG A  83       4.695  12.896  -3.165  1.00 37.91           H  
ATOM   1299  HD3 ARG A  83       4.790  11.680  -1.891  1.00 37.91           H  
ATOM   1300  HE  ARG A  83       5.679  10.156  -3.639  1.00 23.22           H  
ATOM   1301 HH11 ARG A  83       5.942  13.623  -3.983  1.00 37.91           H  
ATOM   1302 HH12 ARG A  83       7.320  13.548  -5.041  1.00 37.91           H  
ATOM   1303 HH21 ARG A  83       7.486  10.034  -5.011  1.00 37.91           H  
ATOM   1304 HH22 ARG A  83       8.186  11.486  -5.661  1.00 37.91           H  
ATOM   1305  N   LEU A  84       1.409  13.274  -6.603  1.00 53.04           N  
ATOM   1306  CA  LEU A  84       0.998  14.038  -7.762  1.00 43.10           C  
ATOM   1307  C   LEU A  84      -0.495  13.868  -7.986  1.00  2.40           C  
ATOM   1308  O   LEU A  84      -0.928  13.053  -8.807  1.00 14.11           O  
ATOM   1309  CB  LEU A  84       1.770  13.612  -9.000  1.00 72.32           C  
ATOM   1310  CG  LEU A  84       3.294  13.610  -8.862  1.00 50.13           C  
ATOM   1311  CD1 LEU A  84       3.939  13.083 -10.135  1.00 61.45           C  
ATOM   1312  CD2 LEU A  84       3.808  15.007  -8.543  1.00 33.31           C  
ATOM   1313  H   LEU A  84       1.905  13.731  -5.901  1.00 37.91           H  
ATOM   1314  HA  LEU A  84       1.200  15.080  -7.560  1.00 33.00           H  
ATOM   1315  HB2 LEU A  84       1.447  12.620  -9.270  1.00 37.91           H  
ATOM   1316  HB3 LEU A  84       1.508  14.284  -9.788  1.00 37.91           H  
ATOM   1317  HG  LEU A  84       3.574  12.956  -8.049  1.00 14.15           H  
ATOM   1318 HD11 LEU A  84       3.652  13.707 -10.968  1.00 37.91           H  
ATOM   1319 HD12 LEU A  84       3.607  12.071 -10.312  1.00 37.91           H  
ATOM   1320 HD13 LEU A  84       5.012  13.097 -10.026  1.00 37.91           H  
ATOM   1321 HD21 LEU A  84       3.343  15.361  -7.635  1.00 37.91           H  
ATOM   1322 HD22 LEU A  84       3.564  15.675  -9.356  1.00 37.91           H  
ATOM   1323 HD23 LEU A  84       4.879  14.976  -8.410  1.00 37.91           H  
ATOM   1324  N   GLU A  85      -1.273  14.614  -7.215  1.00  2.02           N  
ATOM   1325  CA  GLU A  85      -2.721  14.514  -7.255  1.00  3.23           C  
ATOM   1326  C   GLU A  85      -3.214  14.628  -8.684  1.00 52.14           C  
ATOM   1327  O   GLU A  85      -2.810  15.520  -9.435  1.00 44.44           O  
ATOM   1328  CB  GLU A  85      -3.398  15.580  -6.398  1.00 10.33           C  
ATOM   1329  CG  GLU A  85      -2.774  15.783  -5.020  1.00 43.51           C  
ATOM   1330  CD  GLU A  85      -1.619  16.767  -5.029  1.00 54.35           C  
ATOM   1331  OE1 GLU A  85      -0.490  16.367  -5.374  1.00 15.22           O  
ATOM   1332  OE2 GLU A  85      -1.836  17.950  -4.699  1.00  1.43           O  
ATOM   1333  H   GLU A  85      -0.851  15.249  -6.596  1.00 37.91           H  
ATOM   1334  HA  GLU A  85      -2.990  13.539  -6.877  1.00 73.42           H  
ATOM   1335  HB2 GLU A  85      -3.365  16.513  -6.932  1.00 37.91           H  
ATOM   1336  HB3 GLU A  85      -4.432  15.302  -6.259  1.00 37.91           H  
ATOM   1337  HG2 GLU A  85      -3.533  16.154  -4.347  1.00 37.91           H  
ATOM   1338  HG3 GLU A  85      -2.414  14.831  -4.661  1.00 37.91           H  
ATOM   1339  N   HIS A  86      -4.117  13.748  -9.036  1.00 25.22           N  
ATOM   1340  CA  HIS A  86      -4.491  13.554 -10.428  1.00  0.24           C  
ATOM   1341  C   HIS A  86      -5.960  13.855 -10.662  1.00 41.22           C  
ATOM   1342  O   HIS A  86      -6.483  13.606 -11.743  1.00 13.35           O  
ATOM   1343  CB  HIS A  86      -4.136  12.136 -10.887  1.00 55.43           C  
ATOM   1344  CG  HIS A  86      -4.572  11.066  -9.938  1.00 51.23           C  
ATOM   1345  ND1 HIS A  86      -3.717  10.462  -9.045  1.00 21.45           N  
ATOM   1346  CD2 HIS A  86      -5.778  10.493  -9.749  1.00 60.40           C  
ATOM   1347  CE1 HIS A  86      -4.382   9.562  -8.347  1.00  2.13           C  
ATOM   1348  NE2 HIS A  86      -5.638   9.557  -8.753  1.00 74.44           N  
ATOM   1349  H   HIS A  86      -4.572  13.231  -8.335  1.00 37.91           H  
ATOM   1350  HA  HIS A  86      -3.914  14.250 -11.012  1.00  4.13           H  
ATOM   1351  HB2 HIS A  86      -4.605  11.946 -11.840  1.00 37.91           H  
ATOM   1352  HB3 HIS A  86      -3.064  12.062 -11.000  1.00 37.91           H  
ATOM   1353  HD1 HIS A  86      -2.761  10.665  -8.936  1.00 44.22           H  
ATOM   1354  HD2 HIS A  86      -6.685  10.736 -10.279  1.00 25.54           H  
ATOM   1355  HE1 HIS A  86      -3.969   8.936  -7.571  1.00 30.41           H  
ATOM   1356  HE2 HIS A  86      -6.259   8.789  -8.619  1.00 37.91           H  
ATOM   1357  N   HIS A  87      -6.622  14.390  -9.647  1.00 21.42           N  
ATOM   1358  CA  HIS A  87      -7.970  14.896  -9.818  1.00 12.32           C  
ATOM   1359  C   HIS A  87      -7.884  16.338 -10.293  1.00 64.42           C  
ATOM   1360  O   HIS A  87      -7.713  17.261  -9.497  1.00  5.35           O  
ATOM   1361  CB  HIS A  87      -8.775  14.798  -8.518  1.00 54.10           C  
ATOM   1362  CG  HIS A  87     -10.219  15.162  -8.685  1.00 75.45           C  
ATOM   1363  ND1 HIS A  87     -10.820  16.200  -8.006  1.00 24.45           N  
ATOM   1364  CD2 HIS A  87     -11.187  14.614  -9.459  1.00 22.21           C  
ATOM   1365  CE1 HIS A  87     -12.089  16.272  -8.355  1.00 74.32           C  
ATOM   1366  NE2 HIS A  87     -12.336  15.324  -9.234  1.00 45.23           N  
ATOM   1367  H   HIS A  87      -6.192  14.449  -8.768  1.00 37.91           H  
ATOM   1368  HA  HIS A  87      -8.452  14.305 -10.584  1.00 53.12           H  
ATOM   1369  HB2 HIS A  87      -8.729  13.784  -8.148  1.00 37.91           H  
ATOM   1370  HB3 HIS A  87      -8.345  15.464  -7.784  1.00 37.91           H  
ATOM   1371  HD1 HIS A  87     -10.381  16.792  -7.350  1.00 32.22           H  
ATOM   1372  HD2 HIS A  87     -11.073  13.773 -10.126  1.00 30.40           H  
ATOM   1373  HE1 HIS A  87     -12.807  16.990  -7.983  1.00 50.21           H  
ATOM   1374  HE2 HIS A  87     -13.242  15.058  -9.545  1.00 37.91           H  
ATOM   1375  N   HIS A  88      -7.967  16.511 -11.599  1.00 35.40           N  
ATOM   1376  CA  HIS A  88      -7.739  17.804 -12.222  1.00 32.02           C  
ATOM   1377  C   HIS A  88      -8.708  17.981 -13.387  1.00 52.14           C  
ATOM   1378  O   HIS A  88      -8.458  18.750 -14.314  1.00 53.03           O  
ATOM   1379  CB  HIS A  88      -6.286  17.881 -12.710  1.00 14.44           C  
ATOM   1380  CG  HIS A  88      -5.630  19.209 -12.492  1.00 60.44           C  
ATOM   1381  ND1 HIS A  88      -4.923  19.869 -13.473  1.00 24.10           N  
ATOM   1382  CD2 HIS A  88      -5.537  19.980 -11.384  1.00 33.33           C  
ATOM   1383  CE1 HIS A  88      -4.421  20.982 -12.976  1.00 12.13           C  
ATOM   1384  NE2 HIS A  88      -4.776  21.075 -11.710  1.00 43.51           N  
ATOM   1385  H   HIS A  88      -8.206  15.735 -12.167  1.00 37.91           H  
ATOM   1386  HA  HIS A  88      -7.915  18.574 -11.486  1.00 70.15           H  
ATOM   1387  HB2 HIS A  88      -5.701  17.139 -12.188  1.00 37.91           H  
ATOM   1388  HB3 HIS A  88      -6.260  17.669 -13.769  1.00 37.91           H  
ATOM   1389  HD1 HIS A  88      -4.798  19.562 -14.402  1.00 53.24           H  
ATOM   1390  HD2 HIS A  88      -5.980  19.773 -10.420  1.00 44.41           H  
ATOM   1391  HE1 HIS A  88      -3.827  21.701 -13.520  1.00 33.55           H  
ATOM   1392  HE2 HIS A  88      -4.375  21.703 -11.061  1.00 37.91           H  
ATOM   1393  N   HIS A  89      -9.800  17.221 -13.326  1.00 22.24           N  
ATOM   1394  CA  HIS A  89     -10.868  17.221 -14.335  1.00 52.11           C  
ATOM   1395  C   HIS A  89     -10.436  16.502 -15.614  1.00 40.11           C  
ATOM   1396  O   HIS A  89     -11.273  16.000 -16.360  1.00 64.44           O  
ATOM   1397  CB  HIS A  89     -11.376  18.632 -14.652  1.00 71.32           C  
ATOM   1398  CG  HIS A  89     -12.743  18.617 -15.260  1.00 60.00           C  
ATOM   1399  ND1 HIS A  89     -13.083  19.324 -16.387  1.00 23.12           N  
ATOM   1400  CD2 HIS A  89     -13.860  17.957 -14.881  1.00 22.14           C  
ATOM   1401  CE1 HIS A  89     -14.350  19.098 -16.677  1.00  4.53           C  
ATOM   1402  NE2 HIS A  89     -14.848  18.270 -15.779  1.00 30.01           N  
ATOM   1403  H   HIS A  89      -9.895  16.609 -12.559  1.00 37.91           H  
ATOM   1404  HA  HIS A  89     -11.687  16.659 -13.910  1.00 52.12           H  
ATOM   1405  HB2 HIS A  89     -11.419  19.210 -13.742  1.00 37.91           H  
ATOM   1406  HB3 HIS A  89     -10.703  19.107 -15.350  1.00 37.91           H  
ATOM   1407  HD1 HIS A  89     -12.487  19.921 -16.901  1.00 31.01           H  
ATOM   1408  HD2 HIS A  89     -13.957  17.303 -14.025  1.00 53.25           H  
ATOM   1409  HE1 HIS A  89     -14.890  19.522 -17.512  1.00 52.30           H  
ATOM   1410  HE2 HIS A  89     -15.677  17.747 -15.902  1.00 37.91           H  
ATOM   1411  N   HIS A  90      -9.133  16.467 -15.874  1.00 50.40           N  
ATOM   1412  CA  HIS A  90      -8.594  15.571 -16.888  1.00  5.54           C  
ATOM   1413  C   HIS A  90      -8.701  14.152 -16.355  1.00 34.40           C  
ATOM   1414  O   HIS A  90      -8.675  13.173 -17.101  1.00 32.15           O  
ATOM   1415  CB  HIS A  90      -7.137  15.905 -17.216  1.00 53.31           C  
ATOM   1416  CG  HIS A  90      -6.955  17.244 -17.862  1.00 31.44           C  
ATOM   1417  ND1 HIS A  90      -6.133  18.222 -17.347  1.00 34.34           N  
ATOM   1418  CD2 HIS A  90      -7.491  17.766 -18.992  1.00  0.15           C  
ATOM   1419  CE1 HIS A  90      -6.172  19.285 -18.129  1.00  1.12           C  
ATOM   1420  NE2 HIS A  90      -6.988  19.035 -19.132  1.00 51.03           N  
ATOM   1421  H   HIS A  90      -8.529  17.057 -15.375  1.00 37.91           H  
ATOM   1422  HA  HIS A  90      -9.201  15.664 -17.778  1.00 43.12           H  
ATOM   1423  HB2 HIS A  90      -6.561  15.899 -16.302  1.00 37.91           H  
ATOM   1424  HB3 HIS A  90      -6.745  15.155 -17.886  1.00 37.91           H  
ATOM   1425  HD1 HIS A  90      -5.578  18.140 -16.532  1.00 44.12           H  
ATOM   1426  HD2 HIS A  90      -8.184  17.273 -19.658  1.00 41.40           H  
ATOM   1427  HE1 HIS A  90      -5.626  20.204 -17.972  1.00 15.42           H  
ATOM   1428  HE2 HIS A  90      -7.095  19.607 -19.931  1.00 37.91           H  
ATOM   1429  N   HIS A  91      -8.809  14.081 -15.040  1.00 43.24           N  
ATOM   1430  CA  HIS A  91      -9.096  12.863 -14.317  1.00 51.21           C  
ATOM   1431  C   HIS A  91      -9.583  13.270 -12.935  1.00  4.01           C  
ATOM   1432  O   HIS A  91     -10.218  12.451 -12.247  1.00 37.91           O  
ATOM   1433  CB  HIS A  91      -7.860  11.964 -14.207  1.00 12.44           C  
ATOM   1434  CG  HIS A  91      -8.195  10.545 -13.850  1.00 51.22           C  
ATOM   1435  ND1 HIS A  91      -9.039  10.211 -12.821  1.00 22.53           N  
ATOM   1436  CD2 HIS A  91      -7.825   9.374 -14.421  1.00 11.10           C  
ATOM   1437  CE1 HIS A  91      -9.176   8.903 -12.766  1.00 70.12           C  
ATOM   1438  NE2 HIS A  91      -8.451   8.363 -13.729  1.00 42.31           N  
ATOM   1439  OXT HIS A  91      -9.333  14.433 -12.561  1.00 37.91           O  
ATOM   1440  H   HIS A  91      -8.701  14.904 -14.518  1.00 37.91           H  
ATOM   1441  HA  HIS A  91      -9.886  12.337 -14.832  1.00  5.24           H  
ATOM   1442  HB2 HIS A  91      -7.341  11.957 -15.156  1.00 37.91           H  
ATOM   1443  HB3 HIS A  91      -7.204  12.354 -13.444  1.00 37.91           H  
ATOM   1444  HD1 HIS A  91      -9.502  10.857 -12.225  1.00 50.41           H  
ATOM   1445  HD2 HIS A  91      -7.153   9.255 -15.262  1.00  4.31           H  
ATOM   1446  HE1 HIS A  91      -9.779   8.360 -12.054  1.00 14.44           H  
ATOM   1447  HE2 HIS A  91      -8.599   7.460 -14.087  1.00 37.91           H  
TER    1448      HIS A  91                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
