
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  255 ( 1952),  selected  255 , name 2dtd_A
# Molecule2: number of CA atoms  199 ( 1473),  selected  199 , name T0433.pdb
# PARAMETERS: 2dtd_A.T0433.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    F     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    D     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    R     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    K     8_A      M       1          1.159
LGA    V     9_A      K       2          1.119
LGA    V    10_A      I       3          0.697
LGA    I    11_A      L       4          1.056
LGA    V    12_A      L       5          1.576
LGA    T    13_A      I       6          1.611
LGA    G    14_A      G       7          1.561
LGA    A    15_A      A       8          1.711
LGA    S    16_A      S       9          1.213
LGA    M    17_A      G      10          1.663
LGA    G    18_A      T      11          0.739
LGA    I    19_A      L      12          0.630
LGA    G    20_A      G      13          1.200
LGA    R    21_A      S      14          1.440
LGA    A    22_A      A      15          1.175
LGA    I    23_A      V      16          1.059
LGA    A    24_A      K      17          1.872
LGA    E    25_A      E      18          2.240
LGA    R    26_A      R      19          1.563
LGA    F    27_A      L      20          1.173
LGA    V    28_A      E      21          1.075
LGA    D    29_A      K      22          1.891
LGA    E    30_A      K      23          2.003
LGA    G    31_A      -       -           -
LGA    S    32_A      A      24          1.503
LGA    K    33_A      E      25          1.610
LGA    V    34_A      V      26          1.324
LGA    I    35_A      I      27          1.925
LGA    D    36_A      T      28          2.224
LGA    L    37_A      A      29          2.028
LGA    S    38_A      G      30          1.457
LGA    I    39_A      R      31          1.296
LGA    H    40_A      H      32          3.030
LGA    D    41_A      S      33          2.401
LGA    P    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    E    44_A      -       -           -
LGA    A    45_A      -       -           -
LGA    K    46_A      -       -           -
LGA    Y    47_A      -       -           -
LGA    D    48_A      G      34          4.781
LGA    H    49_A      D      35          2.444
LGA    I    50_A      V      36          1.580
LGA    E    51_A      T      37          1.858
LGA    C    52_A      V      38          1.213
LGA    D    53_A      D      39          1.145
LGA    V    54_A      I      40          0.650
LGA    T    55_A      T      41          0.560
LGA    N    56_A      N      42          0.805
LGA    P    57_A      I      43          0.590
LGA    D    58_A      D      44          0.410
LGA    Q    59_A      S      45          0.694
LGA    V    60_A      I      46          0.765
LGA    K    61_A      K      47          0.830
LGA    A    62_A      K      48          0.517
LGA    S    63_A      M      49          0.685
LGA    I    64_A      Y      50          1.069
LGA    D    65_A      E      51          1.221
LGA    H    66_A      Q      52          0.667
LGA    I    67_A      V      53          0.424
LGA    F    68_A      G      54          0.663
LGA    K    69_A      -       -           -
LGA    E    70_A      -       -           -
LGA    Y    71_A      -       -           -
LGA    G    72_A      -       -           -
LGA    S    73_A      K      55          2.529
LGA    I    74_A      V      56          0.695
LGA    S    75_A      D      57          0.536
LGA    V    76_A      A      58          0.439
LGA    L    77_A      I      59          0.725
LGA    V    78_A      V      60          0.904
LGA    N    79_A      S      61          1.690
LGA    N    80_A      A      62          1.902
LGA    A    81_A      T      63          0.828
LGA    G    82_A      G      64          2.061
LGA    I    83_A      S      65          2.035
LGA    E    84_A      A      66          3.585
LGA    S    85_A      T      67          3.192
LGA    Y    86_A      F      68          2.191
LGA    G    87_A      S      69          1.838
LGA    K    88_A      P      70          2.663
LGA    I    89_A      L      71          2.931
LGA    E    90_A      T      72          2.594
LGA    S    91_A      E      73          0.945
LGA    M    92_A      L      74          2.613
LGA    S    93_A      T      75          3.372
LGA    M    94_A      P      76          2.509
LGA    G    95_A      E      77          1.956
LGA    E    96_A      K      78          2.000
LGA    W    97_A      N      79          1.483
LGA    R    98_A      A      80          0.880
LGA    R    99_A      V      81          0.342
LGA    I   100_A      T      82          1.101
LGA    I   101_A      I      83          1.650
LGA    D   102_A      S      84          1.102
LGA    V   103_A      S      85          0.546
LGA    N   104_A      K      86          0.560
LGA    L   105_A      L      87          1.072
LGA    F   106_A      G      88          0.987
LGA    G   107_A      G      89          0.894
LGA    Y   108_A      Q      90          1.062
LGA    Y   109_A      I      91          1.712
LGA    Y   110_A      N      92          1.656
LGA    A   111_A      L      93          1.136
LGA    S   112_A      V      94          1.096
LGA    K   113_A      L      95          1.630
LGA    F   114_A      L      96          1.950
LGA    A   115_A      G      97          1.662
LGA    I   116_A      I      98          0.763
LGA    P   117_A      D      99          0.866
LGA    Y   118_A      S     100          2.035
LGA    M   119_A      L     101          0.722
LGA    I   120_A      N     102          4.069
LGA    R   121_A      -       -           -
LGA    S   122_A      -       -           -
LGA    R   123_A      D     103          3.609
LGA    D   124_A      K     104          1.313
LGA    P   125_A      G     105          0.269
LGA    S   126_A      S     106          0.904
LGA    I   127_A      F     107          0.983
LGA    V   128_A      T     108          0.927
LGA    N   129_A      L     109          1.120
LGA    I   130_A      T     110          1.134
LGA    S   131_A      T     111          0.941
LGA    S   132_A      G     112          1.061
LGA    V   133_A      I     113          1.968
LGA    Q   134_A      M     114          2.414
LGA    A   135_A      M     115          2.973
LGA    S   136_A      E     116          2.203
LGA    I   137_A      D     117          2.329
LGA    I   138_A      P     118          1.656
LGA    T   139_A      I     119          1.565
LGA    K   140_A      V     120          2.067
LGA    N   141_A      Q     121          2.183
LGA    A   142_A      G     122          1.206
LGA    S   143_A      A     123          1.283
LGA    A   144_A      S     124          0.826
LGA    Y   145_A      A     125          0.549
LGA    V   146_A      A     126          0.510
LGA    T   147_A      M     127          0.366
LGA    S   148_A      A     128          0.497
LGA    K   149_A      N     129          0.480
LGA    H   150_A      G     130          0.255
LGA    A   151_A      A     131          0.238
LGA    V   152_A      V     132          0.488
LGA    I   153_A      T     133          0.619
LGA    G   154_A      A     134          1.560
LGA    L   155_A      F     135          1.525
LGA    T   156_A      A     136          0.655
LGA    K   157_A      K     137          1.426
LGA    S   158_A      S     138          2.576
LGA    I   159_A      A     139          2.056
LGA    A   160_A      A     140          0.729
LGA    L   161_A      I     141          1.339
LGA    D   162_A      E     142          1.207
LGA    Y   163_A      M     143          0.723
LGA    A   164_A      P     144          5.688
LGA    P   165_A      R     145          6.269
LGA    L   166_A      G     146          1.037
LGA    L   167_A      I     147          0.497
LGA    R   168_A      R     148          0.619
LGA    C   169_A      I     149          0.588
LGA    N   170_A      N     150          0.818
LGA    A   171_A      T     151          0.844
LGA    V   172_A      V     152          0.997
LGA    C   173_A      S     153          1.268
LGA    P   174_A      P     154          1.121
LGA    A   175_A      N     155          1.187
LGA    T   176_A      V     156          2.027
LGA    I   177_A      L     157          1.330
LGA    D   178_A      E     158          2.174
LGA    T   179_A      E     159          3.368
LGA    P   180_A      S     160          3.922
LGA    L   181_A      W     161           -
LGA    V   182_A      -       -           -
LGA    R   183_A      D     162          3.381
LGA    K   184_A      K     163          2.600
LGA    A   185_A      L     164          2.280
LGA    A   186_A      E     165          3.136
LGA    E   187_A      -       -           -
LGA    L   188_A      -       -           -
LGA    E   189_A      P     166          3.565
LGA    V   190_A      F     167           -
LGA    G   191_A      -       -           -
LGA    S   192_A      -       -           -
LGA    D   193_A      -       -           -
LGA    P   194_A      -       -           -
LGA    M   195_A      -       -           -
LGA    R   196_A      -       -           -
LGA    I   197_A      -       -           -
LGA    E   198_A      -       -           -
LGA    K   199_A      -       -           -
LGA    K   200_A      -       -           -
LGA    I   201_A      F     168           #
LGA    S   202_A      -       -           -
LGA    E   203_A      E     169           #
LGA    W   204_A      G     170          3.799
LGA    G   205_A      F     171          5.160
LGA    H   206_A      L     172          4.774
LGA    E   207_A      -       -           -
LGA    H   208_A      -       -           -
LGA    P   209_A      -       -           -
LGA    M   210_A      -       -           -
LGA    Q   211_A      -       -           -
LGA    R   212_A      -       -           -
LGA    I   213_A      P     173          2.010
LGA    G   214_A      V     174          1.042
LGA    K   215_A      P     175          1.064
LGA    P   216_A      A     176          0.997
LGA    Q   217_A      A     177          1.202
LGA    E   218_A      K     178          0.955
LGA    V   219_A      V     179          0.941
LGA    A   220_A      A     180          0.950
LGA    S   221_A      R     181          0.798
LGA    A   222_A      A     182          0.900
LGA    V   223_A      F     183          0.593
LGA    A   224_A      E     184          0.702
LGA    F   225_A      K     185          1.260
LGA    L   226_A      S     186          1.348
LGA    A   227_A      V     187          0.973
LGA    S   228_A      F     188          0.867
LGA    R   229_A      G     189          3.719
LGA    E   230_A      -       -           -
LGA    A   231_A      -       -           -
LGA    S   232_A      A     190          1.694
LGA    F   233_A      -       -           -
LGA    I   234_A      Q     191          1.576
LGA    T   235_A      T     192          0.932
LGA    G   236_A      G     193          0.636
LGA    T   237_A      E     194          1.209
LGA    C   238_A      S     195          0.420
LGA    L   239_A      Y     196          1.146
LGA    Y   240_A      Q     197          1.014
LGA    V   241_A      V     198          0.793
LGA    D   242_A      Y     199          0.626
LGA    G   243_A      -       -           -
LGA    G   244_A      -       -           -
LGA    L   245_A      -       -           -
LGA    S   246_A      -       -           -
LGA    I   247_A      -       -           -
LGA    R   248_A      -       -           -
LGA    A   249_A      -       -           -
LGA    P   250_A      -       -           -
LGA    I   251_A      -       -           -
LGA    S   252_A      -       -           -
LGA    T   253_A      -       -           -
LGA    P   254_A      -       -           -
LGA    E   255_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  255  199    5.0    195    1.84    19.49     88.766    10.057

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.755948 * X  +  -0.510283 * Y  +  -0.410066 * Z  +  80.367157
  Y_new =   0.069063 * X  +  -0.685077 * Y  +   0.725189 * Z  +  50.048843
  Z_new =  -0.650979 * X  +   0.519885 * Y  +   0.553124 * Z  + 167.732101 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.754430   -2.387162  [ DEG:    43.2257   -136.7743 ]
  Theta =   0.708873    2.432719  [ DEG:    40.6154    139.3846 ]
  Phi   =   3.050486   -0.091107  [ DEG:   174.7800     -5.2200 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dtd_A                                        
REMARK     2: T0433.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dtd_A.T0433.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  255  199   5.0  195   1.84   19.49  88.766
REMARK  ---------------------------------------------------------- 
MOLECULE 2dtd_A
HEADER    OXIDOREDUCTASE                          12-JUL-06   2DTD              
TITLE     STRUCTURE OF THERMOPLASMA ACIDOPHILUM ALDOHEXOSE                      
TITLE    2 DEHYDROGENASE (ALDT) IN LIGAND-FREE FORM                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLUCOSE 1-DEHYDROGENASE RELATED PROTEIN;                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: ALDOHEXOSE DEHYDROGENASE;                                   
COMPND   5 EC: 1.1.1.118;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOPLASMA ACIDOPHILUM;                       
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: TA0754;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-RIL;                             
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28A                                    
KEYWDS    ROSSMANN FOLD                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.YASUTAKE,Y.NISHIYA,N.TAMURA,T.TAMURA                                
REVDAT   1   27-MAR-07 2DTD    0                                                
JRNL        AUTH   Y.YASUTAKE,Y.NISHIYA,N.TAMURA,T.TAMURA                       
JRNL        TITL   STRUCTURAL INSIGHTS INTO UNIQUE SUBSTRATE                    
JRNL        TITL 2 SELECTIVITY OF THERMOPLASMA                                  
JRNL        TITL 3 ACIDOPHILUMD-ALDOHEXOSE DEHYDROGENASE                        
JRNL        REF    J.MOL.BIOL.                   V. 367  1034 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 1089-8638                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2DTD A    2   255  UNP    Q9HK51   Q9HK51_THEAC     2    255             
DBREF  2DTD B    2   255  UNP    Q9HK51   Q9HK51_THEAC     2    255             
SEQRES   1 A  264  MET GLY PHE SER ASP LEU ARG ASP LYS VAL VAL ILE VAL          
SEQRES   2 A  264  THR GLY ALA SER MET GLY ILE GLY ARG ALA ILE ALA GLU          
SEQRES   3 A  264  ARG PHE VAL ASP GLU GLY SER LYS VAL ILE ASP LEU SER          
SEQRES   4 A  264  ILE HIS ASP PRO GLY GLU ALA LYS TYR ASP HIS ILE GLU          
SEQRES   5 A  264  CYS ASP VAL THR ASN PRO ASP GLN VAL LYS ALA SER ILE          
SEQRES   6 A  264  ASP HIS ILE PHE LYS GLU TYR GLY SER ILE SER VAL LEU          
SEQRES   7 A  264  VAL ASN ASN ALA GLY ILE GLU SER TYR GLY LYS ILE GLU          
SEQRES   8 A  264  SER MET SER MET GLY GLU TRP ARG ARG ILE ILE ASP VAL          
SEQRES   9 A  264  ASN LEU PHE GLY TYR TYR TYR ALA SER LYS PHE ALA ILE          
SEQRES  10 A  264  PRO TYR MET ILE ARG SER ARG ASP PRO SER ILE VAL ASN          
SEQRES  11 A  264  ILE SER SER VAL GLN ALA SER ILE ILE THR LYS ASN ALA          
SEQRES  12 A  264  SER ALA TYR VAL THR SER LYS HIS ALA VAL ILE GLY LEU          
SEQRES  13 A  264  THR LYS SER ILE ALA LEU ASP TYR ALA PRO LEU LEU ARG          
SEQRES  14 A  264  CYS ASN ALA VAL CYS PRO ALA THR ILE ASP THR PRO LEU          
SEQRES  15 A  264  VAL ARG LYS ALA ALA GLU LEU GLU VAL GLY SER ASP PRO          
SEQRES  16 A  264  MET ARG ILE GLU LYS LYS ILE SER GLU TRP GLY HIS GLU          
SEQRES  17 A  264  HIS PRO MET GLN ARG ILE GLY LYS PRO GLN GLU VAL ALA          
SEQRES  18 A  264  SER ALA VAL ALA PHE LEU ALA SER ARG GLU ALA SER PHE          
SEQRES  19 A  264  ILE THR GLY THR CYS LEU TYR VAL ASP GLY GLY LEU SER          
SEQRES  20 A  264  ILE ARG ALA PRO ILE SER THR PRO GLU LEU GLU HIS HIS          
SEQRES  21 A  264  HIS HIS HIS HIS                                              
SEQRES   1 B  264  MET GLY PHE SER ASP LEU ARG ASP LYS VAL VAL ILE VAL          
SEQRES   2 B  264  THR GLY ALA SER MET GLY ILE GLY ARG ALA ILE ALA GLU          
SEQRES   3 B  264  ARG PHE VAL ASP GLU GLY SER LYS VAL ILE ASP LEU SER          
SEQRES   4 B  264  ILE HIS ASP PRO GLY GLU ALA LYS TYR ASP HIS ILE GLU          
SEQRES   5 B  264  CYS ASP VAL THR ASN PRO ASP GLN VAL LYS ALA SER ILE          
SEQRES   6 B  264  ASP HIS ILE PHE LYS GLU TYR GLY SER ILE SER VAL LEU          
SEQRES   7 B  264  VAL ASN ASN ALA GLY ILE GLU SER TYR GLY LYS ILE GLU          
SEQRES   8 B  264  SER MET SER MET GLY GLU TRP ARG ARG ILE ILE ASP VAL          
SEQRES   9 B  264  ASN LEU PHE GLY TYR TYR TYR ALA SER LYS PHE ALA ILE          
SEQRES  10 B  264  PRO TYR MET ILE ARG SER ARG ASP PRO SER ILE VAL ASN          
SEQRES  11 B  264  ILE SER SER VAL GLN ALA SER ILE ILE THR LYS ASN ALA          
SEQRES  12 B  264  SER ALA TYR VAL THR SER LYS HIS ALA VAL ILE GLY LEU          
SEQRES  13 B  264  THR LYS SER ILE ALA LEU ASP TYR ALA PRO LEU LEU ARG          
SEQRES  14 B  264  CYS ASN ALA VAL CYS PRO ALA THR ILE ASP THR PRO LEU          
SEQRES  15 B  264  VAL ARG LYS ALA ALA GLU LEU GLU VAL GLY SER ASP PRO          
SEQRES  16 B  264  MET ARG ILE GLU LYS LYS ILE SER GLU TRP GLY HIS GLU          
SEQRES  17 B  264  HIS PRO MET GLN ARG ILE GLY LYS PRO GLN GLU VAL ALA          
SEQRES  18 B  264  SER ALA VAL ALA PHE LEU ALA SER ARG GLU ALA SER PHE          
SEQRES  19 B  264  ILE THR GLY THR CYS LEU TYR VAL ASP GLY GLY LEU SER          
SEQRES  20 B  264  ILE ARG ALA PRO ILE SER THR PRO GLU LEU GLU HIS HIS          
SEQRES  21 B  264  HIS HIS HIS HIS                                              
HET    SO4    261       5                                                       
HET    SO4    262       5                                                       
HET    SO4    263       5                                                       
HET    SO4    264       5                                                       
HET    SO4    265       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   3  SO4    5(O4 S 2-)                                                   
FORMUL   8  HOH   *246(H2 O)                                                    
CRYST1   81.830   81.830  138.509  90.00  90.00 120.00 P 32 2 1     12          
ATOM      1  N   GLY A   1      51.580  99.393 166.820  1.00 42.05           N  
ATOM      2  CA  GLY A   1      52.858  99.001 166.148  1.00 39.97           C  
ATOM      3  C   GLY A   1      53.924  98.519 167.121  1.00 39.85           C  
ATOM      4  O   GLY A   1      53.707  98.484 168.334  1.00 39.97           O  
ATOM      5  N   PHE A   2      55.078  98.129 166.597  1.00 36.99           N  
ATOM      6  CA  PHE A   2      56.165  97.665 167.445  1.00 35.21           C  
ATOM      7  C   PHE A   2      57.285  98.693 167.348  1.00 35.29           C  
ATOM      8  O   PHE A   2      58.098  98.688 166.413  1.00 33.16           O  
ATOM      9  CB  PHE A   2      56.631  96.274 167.006  1.00 33.73           C  
ATOM     10  CG  PHE A   2      55.495  95.298 166.804  1.00 33.25           C  
ATOM     11  CD1 PHE A   2      54.942  95.121 165.543  1.00 32.90           C  
ATOM     12  CD2 PHE A   2      54.945  94.598 167.878  1.00 33.34           C  
ATOM     13  CE1 PHE A   2      53.856  94.268 165.343  1.00 31.96           C  
ATOM     14  CE2 PHE A   2      53.846  93.732 167.687  1.00 33.49           C  
ATOM     15  CZ  PHE A   2      53.306  93.572 166.413  1.00 31.73           C  
ATOM     16  N   SER A   3      57.294  99.577 168.342  1.00 33.23           N  
ATOM     17  CA  SER A   3      58.245 100.675 168.457  1.00 33.10           C  
ATOM     18  C   SER A   3      59.714 100.314 168.369  1.00 30.78           C  
ATOM     19  O   SER A   3      60.525 101.116 167.898  1.00 30.12           O  
ATOM     20  CB  SER A   3      57.994 101.417 169.770  1.00 34.45           C  
ATOM     21  OG  SER A   3      56.656 101.877 169.812  1.00 39.22           O  
ATOM     22  N   ASP A   4      60.071  99.115 168.816  1.00 26.94           N  
ATOM     23  CA  ASP A   4      61.471  98.730 168.785  1.00 25.62           C  
ATOM     24  C   ASP A   4      62.009  98.553 167.359  1.00 21.87           C  
ATOM     25  O   ASP A   4      63.215  98.509 167.154  1.00 21.23           O  
ATOM     26  CB  ASP A   4      61.687  97.446 169.587  1.00 26.45           C  
ATOM     27  CG  ASP A   4      61.032  96.242 168.945  1.00 30.22           C  
ATOM     28  OD1 ASP A   4      59.797  96.089 169.072  1.00 33.23           O  
ATOM     29  OD2 ASP A   4      61.756  95.455 168.301  1.00 31.22           O  
ATOM     30  N   LEU A   5      61.116  98.469 166.378  1.00 21.22           N  
ATOM     31  CA  LEU A   5      61.525  98.291 164.978  1.00 22.09           C  
ATOM     32  C   LEU A   5      61.954  99.606 164.300  1.00 22.66           C  
ATOM     33  O   LEU A   5      62.629  99.594 163.260  1.00 21.98           O  
ATOM     34  CB  LEU A   5      60.381  97.657 164.177  1.00 20.51           C  
ATOM     35  CG  LEU A   5      59.985  96.233 164.585  1.00 20.38           C  
ATOM     36  CD1 LEU A   5      58.706  95.836 163.870  1.00 20.36           C  
ATOM     37  CD2 LEU A   5      61.127  95.259 164.260  1.00 17.95           C  
ATOM     38  N   ARG A   6      61.584 100.738 164.891  1.00 21.66           N  
ATOM     39  CA  ARG A   6      61.944 102.019 164.294  1.00 22.68           C  
ATOM     40  C   ARG A   6      63.454 102.195 164.143  1.00 21.17           C  
ATOM     41  O   ARG A   6      64.234 101.860 165.043  1.00 21.81           O  
ATOM     42  CB  ARG A   6      61.322 103.183 165.092  1.00 22.10           C  
ATOM     43  CG  ARG A   6      61.867 103.402 166.495  1.00 23.18           C  
ATOM     44  CD  ARG A   6      60.951 104.341 167.270  1.00 23.24           C  
ATOM     45  NE  ARG A   6      61.581 104.872 168.479  1.00 24.00           N  
ATOM     46  CZ  ARG A   6      61.799 104.178 169.592  1.00 24.97           C  
ATOM     47  NH1 ARG A   6      61.439 102.902 169.675  1.00 22.47           N  
ATOM     48  NH2 ARG A   6      62.376 104.767 170.630  1.00 23.50           N  
ATOM     49  N   ASP A   7      63.857 102.679 162.968  1.00 21.80           N  
ATOM     50  CA  ASP A   7      65.261 102.929 162.636  1.00 22.22           C  
ATOM     51  C   ASP A   7      66.142 101.702 162.430  1.00 22.92           C  
ATOM     52  O   ASP A   7      67.314 101.835 162.079  1.00 23.15           O  
ATOM     53  CB  ASP A   7      65.910 103.831 163.698  1.00 23.05           C  
ATOM     54  CG  ASP A   7      65.107 105.088 163.953  1.00 26.28           C  
ATOM     55  OD1 ASP A   7      64.786 105.805 162.983  1.00 27.16           O  
ATOM     56  OD2 ASP A   7      64.785 105.356 165.122  1.00 28.87           O  
ATOM     57  N   LYS A   8      65.604 100.508 162.649  1.00 22.43           N  
ATOM     58  CA  LYS A   8      66.410  99.317 162.459  1.00 21.31           C  
ATOM     59  C   LYS A   8      66.461  98.929 160.987  1.00 20.53           C  
ATOM     60  O   LYS A   8      65.525  99.191 160.224  1.00 18.61           O  
ATOM     61  CB  LYS A   8      65.874  98.174 163.326  1.00 25.85           C  
ATOM     62  CG  LYS A   8      66.166  98.415 164.807  1.00 29.22           C  
ATOM     63  CD  LYS A   8      65.619  97.336 165.710  1.00 33.74           C  
ATOM     64  CE  LYS A   8      66.012  97.631 167.160  1.00 35.00           C  
ATOM     65  NZ  LYS A   8      65.418  96.660 168.108  1.00 38.98           N  
ATOM     66  N   VAL A   9      67.581  98.332 160.590  1.00 18.36           N  
ATOM     67  CA  VAL A   9      67.774  97.926 159.210  1.00 17.13           C  
ATOM     68  C   VAL A   9      67.101  96.584 158.975  1.00 17.01           C  
ATOM     69  O   VAL A   9      67.394  95.597 159.647  1.00 15.89           O  
ATOM     70  CB  VAL A   9      69.276  97.845 158.871  1.00 17.95           C  
ATOM     71  CG1 VAL A   9      69.476  97.306 157.451  1.00 18.43           C  
ATOM     72  CG2 VAL A   9      69.897  99.236 159.016  1.00 16.78           C  
ATOM     73  N   VAL A  10      66.192  96.566 158.010  1.00 17.13           N  
ATOM     74  CA  VAL A  10      65.436  95.372 157.688  1.00 16.72           C  
ATOM     75  C   VAL A  10      65.569  95.004 156.213  1.00 18.40           C  
ATOM     76  O   VAL A  10      65.296  95.827 155.330  1.00 18.16           O  
ATOM     77  CB  VAL A  10      63.932  95.591 157.986  1.00 16.73           C  
ATOM     78  CG1 VAL A  10      63.146  94.333 157.671  1.00 14.95           C  
ATOM     79  CG2 VAL A  10      63.739  96.011 159.448  1.00 14.92           C  
ATOM     80  N   ILE A  11      65.990  93.773 155.955  1.00 16.12           N  
ATOM     81  CA  ILE A  11      66.114  93.287 154.589  1.00 17.77           C  
ATOM     82  C   ILE A  11      64.957  92.331 154.300  1.00 18.23           C  
ATOM     83  O   ILE A  11      64.680  91.428 155.101  1.00 18.76           O  
ATOM     84  CB  ILE A  11      67.433  92.514 154.384  1.00 18.07           C  
ATOM     85  CG1 ILE A  11      68.632  93.437 154.607  1.00 16.73           C  
ATOM     86  CG2 ILE A  11      67.483  91.933 152.981  1.00 18.95           C  
ATOM     87  CD1 ILE A  11      69.962  92.705 154.551  1.00 16.61           C  
ATOM     88  N   VAL A  12      64.285  92.530 153.168  1.00 18.68           N  
ATOM     89  CA  VAL A  12      63.180  91.665 152.757  1.00 19.76           C  
ATOM     90  C   VAL A  12      63.414  91.163 151.321  1.00 20.67           C  
ATOM     91  O   VAL A  12      63.544  91.970 150.391  1.00 19.04           O  
ATOM     92  CB  VAL A  12      61.824  92.419 152.809  1.00 20.57           C  
ATOM     93  CG1 VAL A  12      60.668  91.454 152.509  1.00 19.55           C  
ATOM     94  CG2 VAL A  12      61.638  93.060 154.176  1.00 20.87           C  
ATOM     95  N   THR A  13      63.485  89.843 151.128  1.00 19.98           N  
ATOM     96  CA  THR A  13      63.696  89.312 149.779  1.00 20.50           C  
ATOM     97  C   THR A  13      62.368  89.119 149.060  1.00 22.15           C  
ATOM     98  O   THR A  13      61.374  88.735 149.677  1.00 23.77           O  
ATOM     99  CB  THR A  13      64.450  87.959 149.782  1.00 19.57           C  
ATOM    100  OG1 THR A  13      63.614  86.934 150.338  1.00 17.95           O  
ATOM    101  CG2 THR A  13      65.737  88.061 150.587  1.00 19.52           C  
ATOM    102  N   GLY A  14      62.353  89.386 147.755  1.00 24.01           N  
ATOM    103  CA  GLY A  14      61.135  89.234 146.974  1.00 24.04           C  
ATOM    104  C   GLY A  14      60.032  90.169 147.439  1.00 25.44           C  
ATOM    105  O   GLY A  14      58.874  89.766 147.570  1.00 24.80           O  
ATOM    106  N   ALA A  15      60.389  91.430 147.669  1.00 25.14           N  
ATOM    107  CA  ALA A  15      59.437  92.423 148.149  1.00 26.77           C  
ATOM    108  C   ALA A  15      58.895  93.370 147.077  1.00 27.78           C  
ATOM    109  O   ALA A  15      58.394  94.445 147.400  1.00 27.81           O  
ATOM    110  CB  ALA A  15      60.071  93.231 149.283  1.00 24.38           C  
ATOM    111  N   SER A  16      58.973  92.972 145.811  1.00 30.38           N  
ATOM    112  CA  SER A  16      58.482  93.818 144.726  1.00 32.70           C  
ATOM    113  C   SER A  16      56.964  93.720 144.551  1.00 33.00           C  
ATOM    114  O   SER A  16      56.350  94.598 143.940  1.00 32.91           O  
ATOM    115  CB  SER A  16      59.181  93.463 143.404  1.00 34.38           C  
ATOM    116  OG  SER A  16      58.702  92.237 142.867  1.00 39.10           O  
ATOM    117  N   MET A  17      56.362  92.658 145.082  1.00 31.95           N  
ATOM    118  CA  MET A  17      54.909  92.473 144.981  1.00 31.76           C  
ATOM    119  C   MET A  17      54.369  91.522 146.054  1.00 28.64           C  
ATOM    120  O   MET A  17      55.129  90.958 146.828  1.00 27.13           O  
ATOM    121  CB  MET A  17      54.540  91.900 143.615  1.00 34.64           C  
ATOM    122  CG  MET A  17      54.901  90.434 143.473  1.00 39.90           C  
ATOM    123  SD  MET A  17      54.293  89.699 141.962  1.00 48.95           S  
ATOM    124  CE  MET A  17      55.719  89.981 140.853  1.00 46.72           C  
ATOM    125  N   GLY A  18      53.049  91.359 146.073  1.00 27.11           N  
ATOM    126  CA  GLY A  18      52.380  90.460 146.998  1.00 25.05           C  
ATOM    127  C   GLY A  18      52.717  90.560 148.473  1.00 25.12           C  
ATOM    128  O   GLY A  18      52.768  91.649 149.045  1.00 24.54           O  
ATOM    129  N   ILE A  19      52.931  89.402 149.094  1.00 24.10           N  
ATOM    130  CA  ILE A  19      53.250  89.334 150.509  1.00 21.52           C  
ATOM    131  C   ILE A  19      54.540  90.082 150.840  1.00 20.13           C  
ATOM    132  O   ILE A  19      54.604  90.783 151.847  1.00 19.04           O  
ATOM    133  CB  ILE A  19      53.359  87.856 150.974  1.00 21.31           C  
ATOM    134  CG1 ILE A  19      51.959  87.237 151.035  1.00 20.67           C  
ATOM    135  CG2 ILE A  19      54.036  87.770 152.353  1.00 17.13           C  
ATOM    136  CD1 ILE A  19      51.968  85.719 150.967  1.00 22.47           C  
ATOM    137  N   GLY A  20      55.553  89.920 149.989  1.00 21.03           N  
ATOM    138  CA  GLY A  20      56.836  90.575 150.195  1.00 20.90           C  
ATOM    139  C   GLY A  20      56.718  92.087 150.234  1.00 19.97           C  
ATOM    140  O   GLY A  20      57.310  92.748 151.078  1.00 18.80           O  
ATOM    141  N   ARG A  21      55.945  92.636 149.310  1.00 22.11           N  
ATOM    142  CA  ARG A  21      55.736  94.075 149.252  1.00 22.84           C  
ATOM    143  C   ARG A  21      54.969  94.538 150.498  1.00 21.35           C  
ATOM    144  O   ARG A  21      55.268  95.579 151.071  1.00 20.29           O  
ATOM    145  CB  ARG A  21      54.953  94.439 147.988  1.00 25.16           C  
ATOM    146  CG  ARG A  21      54.400  95.859 148.001  1.00 31.91           C  
ATOM    147  CD  ARG A  21      53.654  96.177 146.722  1.00 35.67           C  
ATOM    148  NE  ARG A  21      54.540  96.737 145.709  1.00 42.60           N  
ATOM    149  CZ  ARG A  21      55.122  97.930 145.800  1.00 43.42           C  
ATOM    150  NH1 ARG A  21      55.917  98.361 144.829  1.00 42.88           N  
ATOM    151  NH2 ARG A  21      54.906  98.694 146.863  1.00 45.88           N  
ATOM    152  N   ALA A  22      53.984  93.758 150.917  1.00 19.83           N  
ATOM    153  CA  ALA A  22      53.205  94.116 152.100  1.00 20.73           C  
ATOM    154  C   ALA A  22      54.101  94.096 153.337  1.00 19.51           C  
ATOM    155  O   ALA A  22      53.939  94.911 154.239  1.00 20.20           O  
ATOM    156  CB  ALA A  22      52.024  93.154 152.268  1.00 20.24           C  
ATOM    157  N   ILE A  23      55.056  93.170 153.374  1.00 19.64           N  
ATOM    158  CA  ILE A  23      55.977  93.078 154.509  1.00 18.74           C  
ATOM    159  C   ILE A  23      56.911  94.290 154.542  1.00 19.48           C  
ATOM    160  O   ILE A  23      57.142  94.882 155.590  1.00 17.59           O  
ATOM    161  CB  ILE A  23      56.817  91.787 154.433  1.00 18.89           C  
ATOM    162  CG1 ILE A  23      55.923  90.581 154.759  1.00 17.95           C  
ATOM    163  CG2 ILE A  23      58.026  91.877 155.383  1.00 17.46           C  
ATOM    164  CD1 ILE A  23      56.585  89.222 154.505  1.00 19.49           C  
ATOM    165  N   ALA A  24      57.449  94.660 153.384  1.00 21.82           N  
ATOM    166  CA  ALA A  24      58.343  95.821 153.300  1.00 21.96           C  
ATOM    167  C   ALA A  24      57.613  97.099 153.729  1.00 21.27           C  
ATOM    168  O   ALA A  24      58.143  97.898 154.514  1.00 21.95           O  
ATOM    169  CB  ALA A  24      58.874  95.978 151.866  1.00 20.37           C  
ATOM    170  N   GLU A  25      56.401  97.289 153.213  1.00 20.93           N  
ATOM    171  CA  GLU A  25      55.605  98.473 153.537  1.00 22.62           C  
ATOM    172  C   GLU A  25      55.251  98.543 155.027  1.00 24.51           C  
ATOM    173  O   GLU A  25      55.212  99.632 155.607  1.00 24.27           O  
ATOM    174  CB  GLU A  25      54.332  98.511 152.666  1.00 25.07           C  
ATOM    175  CG  GLU A  25      54.622  98.813 151.174  1.00 27.23           C  
ATOM    176  CD  GLU A  25      53.398  98.717 150.259  1.00 30.95           C  
ATOM    177  OE1 GLU A  25      53.498  99.146 149.088  1.00 32.39           O  
ATOM    178  OE2 GLU A  25      52.340  98.209 150.692  1.00 33.38           O  
ATOM    179  N   ARG A  26      54.995  97.392 155.652  1.00 22.18           N  
ATOM    180  CA  ARG A  26      54.676  97.392 157.079  1.00 21.75           C  
ATOM    181  C   ARG A  26      55.905  97.855 157.853  1.00 19.55           C  
ATOM    182  O   ARG A  26      55.800  98.678 158.760  1.00 19.30           O  
ATOM    183  CB  ARG A  26      54.260  95.991 157.558  1.00 21.75           C  
ATOM    184  CG  ARG A  26      54.158  95.857 159.079  1.00 23.14           C  
ATOM    185  CD  ARG A  26      53.148  96.847 159.677  1.00 24.22           C  
ATOM    186  NE  ARG A  26      53.071  96.774 161.139  1.00 26.09           N  
ATOM    187  CZ  ARG A  26      52.200  96.030 161.820  1.00 26.90           C  
ATOM    188  NH1 ARG A  26      51.313  95.274 161.186  1.00 24.81           N  
ATOM    189  NH2 ARG A  26      52.203  96.060 163.149  1.00 29.62           N  
ATOM    190  N   PHE A  27      57.077  97.333 157.508  1.00 19.09           N  
ATOM    191  CA  PHE A  27      58.278  97.767 158.216  1.00 20.82           C  
ATOM    192  C   PHE A  27      58.541  99.260 157.979  1.00 20.93           C  
ATOM    193  O   PHE A  27      58.996  99.964 158.879  1.00 20.85           O  
ATOM    194  CB  PHE A  27      59.501  96.941 157.805  1.00 18.91           C  
ATOM    195  CG  PHE A  27      59.579  95.595 158.481  1.00 20.56           C  
ATOM    196  CD1 PHE A  27      59.096  94.448 157.849  1.00 21.36           C  
ATOM    197  CD2 PHE A  27      60.142  95.474 159.748  1.00 18.34           C  
ATOM    198  CE1 PHE A  27      59.178  93.185 158.474  1.00 23.49           C  
ATOM    199  CE2 PHE A  27      60.229  94.230 160.380  1.00 22.41           C  
ATOM    200  CZ  PHE A  27      59.745  93.079 159.738  1.00 20.81           C  
ATOM    201  N   VAL A  28      58.267  99.742 156.771  1.00 22.14           N  
ATOM    202  CA  VAL A  28      58.467 101.162 156.496  1.00 23.88           C  
ATOM    203  C   VAL A  28      57.554 101.928 157.460  1.00 25.07           C  
ATOM    204  O   VAL A  28      57.986 102.878 158.115  1.00 25.17           O  
ATOM    205  CB  VAL A  28      58.105 101.527 155.028  1.00 25.02           C  
ATOM    206  CG1 VAL A  28      58.055 103.066 154.869  1.00 26.97           C  
ATOM    207  CG2 VAL A  28      59.147 100.936 154.061  1.00 22.81           C  
ATOM    208  N   ASP A  29      56.296 101.497 157.562  1.00 25.79           N  
ATOM    209  CA  ASP A  29      55.351 102.153 158.467  1.00 27.96           C  
ATOM    210  C   ASP A  29      55.791 102.077 159.927  1.00 27.25           C  
ATOM    211  O   ASP A  29      55.368 102.894 160.744  1.00 26.64           O  
ATOM    212  CB  ASP A  29      53.953 101.552 158.327  1.00 30.02           C  
ATOM    213  CG  ASP A  29      53.338 101.836 156.981  1.00 33.39           C  
ATOM    214  OD1 ASP A  29      53.716 102.857 156.370  1.00 35.74           O  
ATOM    215  OD2 ASP A  29      52.475 101.052 156.534  1.00 35.57           O  
ATOM    216  N   GLU A  30      56.637 101.101 160.257  1.00 24.50           N  
ATOM    217  CA  GLU A  30      57.130 100.970 161.620  1.00 24.41           C  
ATOM    218  C   GLU A  30      58.305 101.926 161.822  1.00 24.61           C  
ATOM    219  O   GLU A  30      58.816 102.062 162.931  1.00 24.19           O  
ATOM    220  CB  GLU A  30      57.594  99.530 161.902  1.00 26.27           C  
ATOM    221  CG  GLU A  30      56.483  98.457 161.940  1.00 28.25           C  
ATOM    222  CD  GLU A  30      55.521  98.627 163.113  1.00 32.09           C  
ATOM    223  OE1 GLU A  30      55.970  99.036 164.200  1.00 32.36           O  
ATOM    224  OE2 GLU A  30      54.317  98.339 162.955  1.00 34.19           O  
ATOM    225  N   GLY A  31      58.745 102.575 160.746  1.00 24.20           N  
ATOM    226  CA  GLY A  31      59.864 103.498 160.848  1.00 21.80           C  
ATOM    227  C   GLY A  31      61.207 102.829 160.602  1.00 22.39           C  
ATOM    228  O   GLY A  31      62.257 103.416 160.852  1.00 22.31           O  
ATOM    229  N   SER A  32      61.184 101.591 160.119  1.00 20.73           N  
ATOM    230  CA  SER A  32      62.418 100.866 159.835  1.00 20.28           C  
ATOM    231  C   SER A  32      63.038 101.341 158.512  1.00 20.28           C  
ATOM    232  O   SER A  32      62.358 101.952 157.684  1.00 20.56           O  
ATOM    233  CB  SER A  32      62.141  99.359 159.715  1.00 21.29           C  
ATOM    234  OG  SER A  32      61.583  98.808 160.899  1.00 22.55           O  
ATOM    235  N   LYS A  33      64.328 101.069 158.334  1.00 19.76           N  
ATOM    236  CA  LYS A  33      65.040 101.391 157.095  1.00 19.99           C  
ATOM    237  C   LYS A  33      64.999 100.064 156.329  1.00 18.60           C  
ATOM    238  O   LYS A  33      65.719  99.124 156.652  1.00 17.63           O  
ATOM    239  CB  LYS A  33      66.482 101.794 157.397  1.00 22.60           C  
ATOM    240  CG  LYS A  33      66.590 103.024 158.288  1.00 26.16           C  
ATOM    241  CD  LYS A  33      68.027 103.266 158.701  1.00 31.25           C  
ATOM    242  CE  LYS A  33      68.175 104.526 159.549  1.00 32.78           C  
ATOM    243  NZ  LYS A  33      69.567 104.593 160.059  1.00 35.79           N  
ATOM    244  N   VAL A  34      64.155 100.007 155.307  1.00 19.46           N  
ATOM    245  CA  VAL A  34      63.938  98.779 154.555  1.00 20.81           C  
ATOM    246  C   VAL A  34      64.615  98.650 153.201  1.00 21.68           C  
ATOM    247  O   VAL A  34      64.598  99.580 152.396  1.00 23.40           O  
ATOM    248  CB  VAL A  34      62.419  98.573 154.374  1.00 20.83           C  
ATOM    249  CG1 VAL A  34      62.126  97.251 153.677  1.00 21.00           C  
ATOM    250  CG2 VAL A  34      61.741  98.648 155.732  1.00 18.98           C  
ATOM    251  N   ILE A  35      65.210  97.483 152.963  1.00 21.73           N  
ATOM    252  CA  ILE A  35      65.862  97.192 151.692  1.00 21.30           C  
ATOM    253  C   ILE A  35      65.262  95.913 151.097  1.00 22.11           C  
ATOM    254  O   ILE A  35      65.241  94.856 151.735  1.00 21.33           O  
ATOM    255  CB  ILE A  35      67.400  96.994 151.836  1.00 23.32           C  
ATOM    256  CG1 ILE A  35      68.051  98.234 152.457  1.00 23.71           C  
ATOM    257  CG2 ILE A  35      68.024  96.770 150.461  1.00 23.13           C  
ATOM    258  CD1 ILE A  35      67.842  98.364 153.945  1.00 25.88           C  
ATOM    259  N   ASP A  36      64.763  96.028 149.874  1.00 22.35           N  
ATOM    260  CA  ASP A  36      64.181  94.906 149.142  1.00 22.60           C  
ATOM    261  C   ASP A  36      65.240  94.271 148.245  1.00 24.35           C  
ATOM    262  O   ASP A  36      65.901  94.972 147.476  1.00 26.97           O  
ATOM    263  CB  ASP A  36      63.034  95.409 148.265  1.00 26.24           C  
ATOM    264  CG  ASP A  36      62.649  94.421 147.169  1.00 29.42           C  
ATOM    265  OD1 ASP A  36      62.425  94.870 146.024  1.00 31.47           O  
ATOM    266  OD2 ASP A  36      62.563  93.206 147.441  1.00 29.30           O  
ATOM    267  N   LEU A  37      65.418  92.957 148.351  1.00 23.70           N  
ATOM    268  CA  LEU A  37      66.358  92.247 147.485  1.00 23.49           C  
ATOM    269  C   LEU A  37      65.512  91.361 146.571  1.00 24.49           C  
ATOM    270  O   LEU A  37      64.975  90.337 147.009  1.00 21.21           O  
ATOM    271  CB  LEU A  37      67.334  91.368 148.291  1.00 20.50           C  
ATOM    272  CG  LEU A  37      68.335  92.028 149.242  1.00 22.32           C  
ATOM    273  CD1 LEU A  37      69.201  90.945 149.921  1.00 21.61           C  
ATOM    274  CD2 LEU A  37      69.210  93.004 148.462  1.00 21.01           C  
ATOM    275  N   SER A  38      65.374  91.771 145.313  1.00 25.89           N  
ATOM    276  CA  SER A  38      64.609  91.004 144.335  1.00 28.52           C  
ATOM    277  C   SER A  38      65.098  91.299 142.916  1.00 30.94           C  
ATOM    278  O   SER A  38      65.856  92.243 142.693  1.00 31.07           O  
ATOM    279  CB  SER A  38      63.119  91.337 144.438  1.00 29.39           C  
ATOM    280  OG  SER A  38      62.852  92.633 143.953  1.00 29.28           O  
ATOM    281  N   ILE A  39      64.663  90.483 141.964  1.00 33.61           N  
ATOM    282  CA  ILE A  39      65.053  90.654 140.572  1.00 38.10           C  
ATOM    283  C   ILE A  39      64.198  91.700 139.867  1.00 40.42           C  
ATOM    284  O   ILE A  39      64.584  92.212 138.816  1.00 42.17           O  
ATOM    285  CB  ILE A  39      64.944  89.328 139.791  1.00 38.65           C  
ATOM    286  CG1 ILE A  39      63.537  88.746 139.955  1.00 40.61           C  
ATOM    287  CG2 ILE A  39      66.008  88.355 140.275  1.00 37.12           C  
ATOM    288  CD1 ILE A  39      63.287  87.471 139.171  1.00 43.25           C  
ATOM    289  N   HIS A  40      63.041  92.013 140.442  1.00 42.58           N  
ATOM    290  CA  HIS A  40      62.142  93.002 139.857  1.00 45.93           C  
ATOM    291  C   HIS A  40      62.175  94.313 140.624  1.00 47.34           C  
ATOM    292  O   HIS A  40      62.377  94.331 141.835  1.00 46.26           O  
ATOM    293  CB  HIS A  40      60.708  92.468 139.840  1.00 47.23           C  
ATOM    294  CG  HIS A  40      60.555  91.179 139.100  1.00 49.06           C  
ATOM    295  ND1 HIS A  40      60.050  90.039 139.687  1.00 49.50           N  
ATOM    296  CD2 HIS A  40      60.850  90.845 137.821  1.00 49.84           C  
ATOM    297  CE1 HIS A  40      60.039  89.058 138.802  1.00 51.13           C  
ATOM    298  NE2 HIS A  40      60.520  89.521 137.661  1.00 51.30           N  
ATOM    299  N   ASP A  41      61.970  95.413 139.911  1.00 50.41           N  
ATOM    300  CA  ASP A  41      61.958  96.727 140.538  1.00 54.11           C  
ATOM    301  C   ASP A  41      60.554  97.010 141.058  1.00 54.16           C  
ATOM    302  O   ASP A  41      59.580  96.934 140.310  1.00 54.24           O  
ATOM    303  CB  ASP A  41      62.364  97.800 139.527  1.00 57.34           C  
ATOM    304  CG  ASP A  41      63.741  97.552 138.944  1.00 60.88           C  
ATOM    305  OD1 ASP A  41      64.226  98.401 138.161  1.00 63.10           O  
ATOM    306  OD2 ASP A  41      64.338  96.501 139.269  1.00 63.49           O  
ATOM    307  N   PRO A  42      60.431  97.327 142.353  1.00 54.98           N  
ATOM    308  CA  PRO A  42      59.121  97.614 142.945  1.00 55.46           C  
ATOM    309  C   PRO A  42      58.566  98.973 142.529  1.00 56.12           C  
ATOM    310  O   PRO A  42      57.606  99.470 143.118  1.00 55.97           O  
ATOM    311  CB  PRO A  42      59.399  97.530 144.443  1.00 55.40           C  
ATOM    312  CG  PRO A  42      60.805  98.037 144.540  1.00 56.10           C  
ATOM    313  CD  PRO A  42      61.491  97.351 143.379  1.00 55.52           C  
ATOM    314  N   GLY A  43      59.173  99.564 141.503  1.00 56.14           N  
ATOM    315  CA  GLY A  43      58.721 100.860 141.033  1.00 56.52           C  
ATOM    316  C   GLY A  43      58.776 101.895 142.139  1.00 56.74           C  
ATOM    317  O   GLY A  43      59.637 101.824 143.017  1.00 57.07           O  
ATOM    318  N   GLU A  44      57.861 102.858 142.103  1.00 56.64           N  
ATOM    319  CA  GLU A  44      57.821 103.899 143.123  1.00 56.35           C  
ATOM    320  C   GLU A  44      57.440 103.293 144.473  1.00 54.40           C  
ATOM    321  O   GLU A  44      56.281 102.959 144.716  1.00 54.83           O  
ATOM    322  CB  GLU A  44      56.826 105.001 142.722  1.00 58.95           C  
ATOM    323  CG  GLU A  44      55.427 104.502 142.371  1.00 63.09           C  
ATOM    324  CD  GLU A  44      54.486 105.617 141.918  1.00 65.21           C  
ATOM    325  OE1 GLU A  44      53.301 105.318 141.643  1.00 66.26           O  
ATOM    326  OE2 GLU A  44      54.923 106.786 141.835  1.00 66.33           O  
ATOM    327  N   ALA A  45      58.429 103.139 145.345  1.00 52.14           N  
ATOM    328  CA  ALA A  45      58.202 102.567 146.669  1.00 49.75           C  
ATOM    329  C   ALA A  45      58.964 103.367 147.713  1.00 47.70           C  
ATOM    330  O   ALA A  45      59.929 104.062 147.390  1.00 47.17           O  
ATOM    331  CB  ALA A  45      58.654 101.110 146.689  1.00 48.55           C  
ATOM    332  N   LYS A  46      58.530 103.266 148.966  1.00 45.43           N  
ATOM    333  CA  LYS A  46      59.179 103.988 150.054  1.00 43.12           C  
ATOM    334  C   LYS A  46      60.406 103.255 150.569  1.00 40.54           C  
ATOM    335  O   LYS A  46      61.236 103.834 151.272  1.00 41.54           O  
ATOM    336  CB  LYS A  46      58.198 104.218 151.206  1.00 45.37           C  
ATOM    337  CG  LYS A  46      57.043 105.144 150.859  1.00 47.76           C  
ATOM    338  CD  LYS A  46      56.122 105.366 152.058  1.00 51.58           C  
ATOM    339  CE  LYS A  46      56.855 106.053 153.204  1.00 52.88           C  
ATOM    340  NZ  LYS A  46      55.943 106.326 154.352  1.00 55.08           N  
ATOM    341  N   TYR A  47      60.528 101.980 150.223  1.00 36.25           N  
ATOM    342  CA  TYR A  47      61.682 101.219 150.664  1.00 32.90           C  
ATOM    343  C   TYR A  47      62.768 101.190 149.592  1.00 31.44           C  
ATOM    344  O   TYR A  47      62.509 101.455 148.423  1.00 30.50           O  
ATOM    345  CB  TYR A  47      61.267  99.797 151.072  1.00 29.60           C  
ATOM    346  CG  TYR A  47      60.367  99.076 150.088  1.00 29.56           C  
ATOM    347  CD1 TYR A  47      60.891  98.201 149.140  1.00 27.08           C  
ATOM    348  CD2 TYR A  47      58.986  99.265 150.118  1.00 28.01           C  
ATOM    349  CE1 TYR A  47      60.056  97.528 148.244  1.00 28.72           C  
ATOM    350  CE2 TYR A  47      58.146  98.602 149.233  1.00 26.61           C  
ATOM    351  CZ  TYR A  47      58.681  97.738 148.302  1.00 28.85           C  
ATOM    352  OH  TYR A  47      57.836  97.093 147.427  1.00 30.65           O  
ATOM    353  N   ASP A  48      63.988 100.886 150.013  1.00 30.68           N  
ATOM    354  CA  ASP A  48      65.132 100.823 149.118  1.00 31.39           C  
ATOM    355  C   ASP A  48      65.114  99.487 148.371  1.00 31.64           C  
ATOM    356  O   ASP A  48      64.474  98.534 148.817  1.00 31.68           O  
ATOM    357  CB  ASP A  48      66.409 100.975 149.946  1.00 34.07           C  
ATOM    358  CG  ASP A  48      67.651 101.116 149.094  1.00 39.41           C  
ATOM    359  OD1 ASP A  48      67.516 101.354 147.873  1.00 40.72           O  
ATOM    360  OD2 ASP A  48      68.767 100.998 149.660  1.00 41.14           O  
ATOM    361  N   HIS A  49      65.796  99.419 147.231  1.00 30.05           N  
ATOM    362  CA  HIS A  49      65.834  98.187 146.447  1.00 29.59           C  
ATOM    363  C   HIS A  49      67.196  97.901 145.840  1.00 28.54           C  
ATOM    364  O   HIS A  49      67.896  98.809 145.396  1.00 28.61           O  
ATOM    365  CB  HIS A  49      64.777  98.228 145.330  1.00 30.10           C  
ATOM    366  CG  HIS A  49      64.944  97.155 144.292  1.00 33.73           C  
ATOM    367  ND1 HIS A  49      65.666  97.344 143.131  1.00 34.09           N  
ATOM    368  CD2 HIS A  49      64.513  95.869 144.260  1.00 32.39           C  
ATOM    369  CE1 HIS A  49      65.673  96.223 142.430  1.00 31.98           C  
ATOM    370  NE2 HIS A  49      64.982  95.312 143.093  1.00 31.91           N  
ATOM    371  N   ILE A  50      67.574  96.629 145.846  1.00 26.85           N  
ATOM    372  CA  ILE A  50      68.826  96.200 145.242  1.00 25.08           C  
ATOM    373  C   ILE A  50      68.518  95.002 144.350  1.00 26.92           C  
ATOM    374  O   ILE A  50      67.963  93.997 144.813  1.00 22.36           O  
ATOM    375  CB  ILE A  50      69.881  95.767 146.282  1.00 25.84           C  
ATOM    376  CG1 ILE A  50      70.323  96.965 147.129  1.00 26.21           C  
ATOM    377  CG2 ILE A  50      71.097  95.181 145.565  1.00 25.56           C  
ATOM    378  CD1 ILE A  50      71.410  96.619 148.140  1.00 28.45           C  
ATOM    379  N   GLU A  51      68.863  95.130 143.069  1.00 26.45           N  
ATOM    380  CA  GLU A  51      68.663  94.068 142.092  1.00 28.64           C  
ATOM    381  C   GLU A  51      69.431  92.855 142.589  1.00 26.83           C  
ATOM    382  O   GLU A  51      70.648  92.905 142.731  1.00 27.84           O  
ATOM    383  CB  GLU A  51      69.224  94.497 140.736  1.00 33.59           C  
ATOM    384  CG  GLU A  51      69.091  93.446 139.663  1.00 40.87           C  
ATOM    385  CD  GLU A  51      67.885  93.688 138.787  1.00 45.83           C  
ATOM    386  OE1 GLU A  51      66.755  93.754 139.327  1.00 49.43           O  
ATOM    387  OE2 GLU A  51      68.076  93.818 137.558  1.00 47.60           O  
ATOM    388  N   CYS A  52      68.735  91.755 142.838  1.00 24.90           N  
ATOM    389  CA  CYS A  52      69.419  90.585 143.369  1.00 23.66           C  
ATOM    390  C   CYS A  52      68.640  89.298 143.134  1.00 22.86           C  
ATOM    391  O   CYS A  52      67.448  89.228 143.430  1.00 22.38           O  
ATOM    392  CB  CYS A  52      69.651  90.801 144.873  1.00 22.53           C  
ATOM    393  SG  CYS A  52      70.543  89.504 145.737  1.00 23.55           S  
ATOM    394  N   ASP A  53      69.323  88.297 142.585  1.00 21.07           N  
ATOM    395  CA  ASP A  53      68.744  86.983 142.310  1.00 21.71           C  
ATOM    396  C   ASP A  53      69.181  86.118 143.492  1.00 21.58           C  
ATOM    397  O   ASP A  53      70.373  85.828 143.634  1.00 19.27           O  
ATOM    398  CB  ASP A  53      69.331  86.422 141.009  1.00 25.60           C  
ATOM    399  CG  ASP A  53      68.774  85.056 140.645  1.00 28.19           C  
ATOM    400  OD1 ASP A  53      68.336  84.310 141.546  1.00 30.41           O  
ATOM    401  OD2 ASP A  53      68.795  84.719 139.446  1.00 30.59           O  
ATOM    402  N   VAL A  54      68.229  85.714 144.339  1.00 19.67           N  
ATOM    403  CA  VAL A  54      68.554  84.912 145.525  1.00 19.18           C  
ATOM    404  C   VAL A  54      69.174  83.545 145.276  1.00 19.10           C  
ATOM    405  O   VAL A  54      69.669  82.927 146.211  1.00 19.81           O  
ATOM    406  CB  VAL A  54      67.314  84.730 146.473  1.00 19.72           C  
ATOM    407  CG1 VAL A  54      66.830  86.087 146.947  1.00 20.47           C  
ATOM    408  CG2 VAL A  54      66.190  83.980 145.766  1.00 19.65           C  
ATOM    409  N   THR A  55      69.151  83.053 144.036  1.00 18.96           N  
ATOM    410  CA  THR A  55      69.778  81.763 143.764  1.00 20.88           C  
ATOM    411  C   THR A  55      71.264  81.950 143.440  1.00 21.66           C  
ATOM    412  O   THR A  55      72.012  80.977 143.286  1.00 20.16           O  
ATOM    413  CB  THR A  55      69.098  81.017 142.604  1.00 21.65           C  
ATOM    414  OG1 THR A  55      69.146  81.819 141.416  1.00 22.01           O  
ATOM    415  CG2 THR A  55      67.645  80.713 142.968  1.00 22.97           C  
ATOM    416  N   ASN A  56      71.680  83.209 143.341  1.00 20.42           N  
ATOM    417  CA  ASN A  56      73.076  83.537 143.066  1.00 21.19           C  
ATOM    418  C   ASN A  56      73.692  83.919 144.408  1.00 19.69           C  
ATOM    419  O   ASN A  56      73.499  85.030 144.896  1.00 21.63           O  
ATOM    420  CB  ASN A  56      73.168  84.721 142.100  1.00 20.88           C  
ATOM    421  CG  ASN A  56      74.605  85.041 141.699  1.00 20.90           C  
ATOM    422  OD1 ASN A  56      75.552  84.673 142.387  1.00 19.88           O  
ATOM    423  ND2 ASN A  56      74.761  85.740 140.591  1.00 19.03           N  
ATOM    424  N   PRO A  57      74.443  83.000 145.024  1.00 20.11           N  
ATOM    425  CA  PRO A  57      75.062  83.285 146.322  1.00 19.36           C  
ATOM    426  C   PRO A  57      76.063  84.443 146.306  1.00 21.99           C  
ATOM    427  O   PRO A  57      76.215  85.148 147.302  1.00 19.20           O  
ATOM    428  CB  PRO A  57      75.703  81.946 146.691  1.00 18.49           C  
ATOM    429  CG  PRO A  57      76.058  81.357 145.342  1.00 16.55           C  
ATOM    430  CD  PRO A  57      74.823  81.658 144.533  1.00 19.29           C  
ATOM    431  N   ASP A  58      76.735  84.638 145.169  1.00 22.94           N  
ATOM    432  CA  ASP A  58      77.715  85.714 145.019  1.00 23.29           C  
ATOM    433  C   ASP A  58      77.027  87.074 144.991  1.00 23.30           C  
ATOM    434  O   ASP A  58      77.513  88.041 145.594  1.00 23.04           O  
ATOM    435  CB  ASP A  58      78.533  85.504 143.738  1.00 23.04           C  
ATOM    436  CG  ASP A  58      79.444  84.292 143.827  1.00 24.41           C  
ATOM    437  OD1 ASP A  58      79.781  83.707 142.772  1.00 28.56           O  
ATOM    438  OD2 ASP A  58      79.826  83.924 144.956  1.00 24.41           O  
ATOM    439  N   GLN A  59      75.901  87.154 144.289  1.00 21.88           N  
ATOM    440  CA  GLN A  59      75.157  88.401 144.229  1.00 21.98           C  
ATOM    441  C   GLN A  59      74.488  88.642 145.598  1.00 22.75           C  
ATOM    442  O   GLN A  59      74.396  89.777 146.063  1.00 22.86           O  
ATOM    443  CB  GLN A  59      74.105  88.341 143.122  1.00 21.43           C  
ATOM    444  CG  GLN A  59      73.461  89.683 142.789  1.00 22.73           C  
ATOM    445  CD  GLN A  59      72.667  89.639 141.491  1.00 25.89           C  
ATOM    446  OE1 GLN A  59      71.785  88.798 141.321  1.00 25.76           O  
ATOM    447  NE2 GLN A  59      72.978  90.545 140.569  1.00 24.71           N  
ATOM    448  N   VAL A  60      74.031  87.574 146.245  1.00 21.93           N  
ATOM    449  CA  VAL A  60      73.391  87.720 147.551  1.00 21.58           C  
ATOM    450  C   VAL A  60      74.404  88.270 148.546  1.00 21.11           C  
ATOM    451  O   VAL A  60      74.128  89.250 149.241  1.00 21.60           O  
ATOM    452  CB  VAL A  60      72.828  86.375 148.071  1.00 21.31           C  
ATOM    453  CG1 VAL A  60      72.392  86.509 149.535  1.00 21.23           C  
ATOM    454  CG2 VAL A  60      71.623  85.959 147.219  1.00 21.51           C  
ATOM    455  N   LYS A  61      75.571  87.638 148.615  1.00 21.36           N  
ATOM    456  CA  LYS A  61      76.625  88.083 149.516  1.00 23.59           C  
ATOM    457  C   LYS A  61      77.000  89.545 149.239  1.00 22.94           C  
ATOM    458  O   LYS A  61      77.046  90.363 150.149  1.00 22.82           O  
ATOM    459  CB  LYS A  61      77.868  87.207 149.354  1.00 23.83           C  
ATOM    460  CG  LYS A  61      79.046  87.642 150.222  1.00 26.96           C  
ATOM    461  CD  LYS A  61      80.268  86.760 149.979  1.00 27.70           C  
ATOM    462  CE  LYS A  61      81.424  87.135 150.911  1.00 31.88           C  
ATOM    463  NZ  LYS A  61      81.842  88.560 150.753  1.00 32.22           N  
ATOM    464  N   ALA A  62      77.258  89.868 147.977  1.00 23.31           N  
ATOM    465  CA  ALA A  62      77.634  91.228 147.600  1.00 24.05           C  
ATOM    466  C   ALA A  62      76.564  92.232 148.011  1.00 24.75           C  
ATOM    467  O   ALA A  62      76.877  93.307 148.528  1.00 25.09           O  
ATOM    468  CB  ALA A  62      77.890  91.313 146.073  1.00 23.19           C  
ATOM    469  N   SER A  63      75.300  91.883 147.785  1.00 23.55           N  
ATOM    470  CA  SER A  63      74.201  92.776 148.137  1.00 22.71           C  
ATOM    471  C   SER A  63      74.159  93.029 149.632  1.00 22.20           C  
ATOM    472  O   SER A  63      74.014  94.167 150.070  1.00 23.31           O  
ATOM    473  CB  SER A  63      72.855  92.187 147.702  1.00 23.76           C  
ATOM    474  OG  SER A  63      72.776  92.064 146.300  1.00 24.99           O  
ATOM    475  N   ILE A  64      74.277  91.960 150.411  1.00 22.61           N  
ATOM    476  CA  ILE A  64      74.248  92.064 151.863  1.00 22.24           C  
ATOM    477  C   ILE A  64      75.467  92.829 152.394  1.00 22.72           C  
ATOM    478  O   ILE A  64      75.334  93.650 153.306  1.00 22.34           O  
ATOM    479  CB  ILE A  64      74.167  90.659 152.504  1.00 22.77           C  
ATOM    480  CG1 ILE A  64      72.759  90.080 152.283  1.00 22.83           C  
ATOM    481  CG2 ILE A  64      74.498  90.732 153.997  1.00 21.64           C  
ATOM    482  CD1 ILE A  64      72.600  88.624 152.748  1.00 25.02           C  
ATOM    483  N   ASP A  65      76.645  92.558 151.837  1.00 22.29           N  
ATOM    484  CA  ASP A  65      77.849  93.275 152.262  1.00 24.44           C  
ATOM    485  C   ASP A  65      77.635  94.762 152.038  1.00 23.28           C  
ATOM    486  O   ASP A  65      77.944  95.570 152.898  1.00 24.92           O  
ATOM    487  CB  ASP A  65      79.082  92.865 151.457  1.00 25.12           C  
ATOM    488  CG  ASP A  65      79.524  91.449 151.724  1.00 26.13           C  
ATOM    489  OD1 ASP A  65      79.268  90.920 152.831  1.00 27.31           O  
ATOM    490  OD2 ASP A  65      80.159  90.869 150.816  1.00 27.50           O  
ATOM    491  N   HIS A  66      77.098  95.115 150.874  1.00 24.69           N  
ATOM    492  CA  HIS A  66      76.842  96.512 150.540  1.00 25.40           C  
ATOM    493  C   HIS A  66      75.866  97.177 151.510  1.00 25.80           C  
ATOM    494  O   HIS A  66      76.064  98.333 151.914  1.00 23.48           O  
ATOM    495  CB  HIS A  66      76.285  96.629 149.120  1.00 27.38           C  
ATOM    496  CG  HIS A  66      75.908  98.026 148.735  1.00 30.33           C  
ATOM    497  ND1 HIS A  66      76.844  98.998 148.452  1.00 33.34           N  
ATOM    498  CD2 HIS A  66      74.698  98.627 148.628  1.00 31.79           C  
ATOM    499  CE1 HIS A  66      76.227 100.138 148.190  1.00 33.56           C  
ATOM    500  NE2 HIS A  66      74.923  99.940 148.292  1.00 32.02           N  
ATOM    501  N   ILE A  67      74.795  96.465 151.860  1.00 23.88           N  
ATOM    502  CA  ILE A  67      73.809  97.017 152.783  1.00 22.29           C  
ATOM    503  C   ILE A  67      74.463  97.316 154.123  1.00 24.13           C  
ATOM    504  O   ILE A  67      74.264  98.389 154.689  1.00 24.78           O  
ATOM    505  CB  ILE A  67      72.620  96.039 153.005  1.00 22.25           C  
ATOM    506  CG1 ILE A  67      71.738  96.003 151.749  1.00 18.04           C  
ATOM    507  CG2 ILE A  67      71.799  96.469 154.233  1.00 17.97           C  
ATOM    508  CD1 ILE A  67      70.733  94.860 151.731  1.00 20.29           C  
ATOM    509  N   PHE A  68      75.263  96.382 154.624  1.00 25.62           N  
ATOM    510  CA  PHE A  68      75.901  96.596 155.911  1.00 28.50           C  
ATOM    511  C   PHE A  68      76.844  97.791 155.915  1.00 30.70           C  
ATOM    512  O   PHE A  68      76.902  98.527 156.897  1.00 29.42           O  
ATOM    513  CB  PHE A  68      76.658  95.350 156.366  1.00 27.10           C  
ATOM    514  CG  PHE A  68      77.290  95.494 157.728  1.00 27.98           C  
ATOM    515  CD1 PHE A  68      78.611  95.919 157.858  1.00 27.93           C  
ATOM    516  CD2 PHE A  68      76.553  95.231 158.881  1.00 25.56           C  
ATOM    517  CE1 PHE A  68      79.192  96.079 159.116  1.00 27.87           C  
ATOM    518  CE2 PHE A  68      77.121  95.388 160.143  1.00 28.19           C  
ATOM    519  CZ  PHE A  68      78.444  95.813 160.262  1.00 29.21           C  
ATOM    520  N   LYS A  69      77.577  97.988 154.821  1.00 32.51           N  
ATOM    521  CA  LYS A  69      78.517  99.104 154.745  1.00 34.92           C  
ATOM    522  C   LYS A  69      77.780 100.429 154.617  1.00 33.91           C  
ATOM    523  O   LYS A  69      78.194 101.433 155.190  1.00 34.58           O  
ATOM    524  CB  LYS A  69      79.466  98.941 153.553  1.00 37.15           C  
ATOM    525  CG  LYS A  69      79.886  97.509 153.268  1.00 41.76           C  
ATOM    526  CD  LYS A  69      80.374  96.763 154.508  1.00 44.72           C  
ATOM    527  CE  LYS A  69      80.541  95.265 154.214  1.00 43.43           C  
ATOM    528  NZ  LYS A  69      81.518  95.029 153.104  1.00 46.39           N  
ATOM    529  N   GLU A  70      76.680 100.424 153.872  1.00 33.20           N  
ATOM    530  CA  GLU A  70      75.891 101.629 153.658  1.00 32.46           C  
ATOM    531  C   GLU A  70      75.000 102.033 154.846  1.00 33.64           C  
ATOM    532  O   GLU A  70      74.838 103.228 155.126  1.00 31.35           O  
ATOM    533  CB  GLU A  70      75.015 101.451 152.416  1.00 34.22           C  
ATOM    534  CG  GLU A  70      74.139 102.650 152.091  1.00 38.91           C  
ATOM    535  CD  GLU A  70      73.160 102.370 150.966  1.00 41.73           C  
ATOM    536  OE1 GLU A  70      73.366 101.388 150.226  1.00 44.46           O  
ATOM    537  OE2 GLU A  70      72.186 103.139 150.810  1.00 45.28           O  
ATOM    538  N   TYR A  71      74.432 101.047 155.543  1.00 30.56           N  
ATOM    539  CA  TYR A  71      73.531 101.324 156.663  1.00 30.30           C  
ATOM    540  C   TYR A  71      74.114 101.165 158.064  1.00 28.81           C  
ATOM    541  O   TYR A  71      73.534 101.658 159.030  1.00 30.75           O  
ATOM    542  CB  TYR A  71      72.268 100.460 156.537  1.00 30.82           C  
ATOM    543  CG  TYR A  71      71.369 100.841 155.375  1.00 30.50           C  
ATOM    544  CD1 TYR A  71      70.377 101.806 155.526  1.00 31.99           C  
ATOM    545  CD2 TYR A  71      71.533 100.256 154.118  1.00 30.20           C  
ATOM    546  CE1 TYR A  71      69.568 102.181 154.455  1.00 32.91           C  
ATOM    547  CE2 TYR A  71      70.733 100.623 153.043  1.00 30.01           C  
ATOM    548  CZ  TYR A  71      69.751 101.585 153.216  1.00 32.70           C  
ATOM    549  OH  TYR A  71      68.943 101.944 152.159  1.00 33.73           O  
ATOM    550  N   GLY A  72      75.239 100.468 158.188  1.00 27.86           N  
ATOM    551  CA  GLY A  72      75.856 100.302 159.493  1.00 25.75           C  
ATOM    552  C   GLY A  72      75.484  99.068 160.294  1.00 26.59           C  
ATOM    553  O   GLY A  72      76.142  98.758 161.285  1.00 25.49           O  
ATOM    554  N   SER A  73      74.425  98.371 159.887  1.00 25.06           N  
ATOM    555  CA  SER A  73      74.006  97.155 160.578  1.00 23.96           C  
ATOM    556  C   SER A  73      72.844  96.497 159.844  1.00 22.29           C  
ATOM    557  O   SER A  73      72.362  97.004 158.837  1.00 21.82           O  
ATOM    558  CB  SER A  73      73.560  97.472 162.010  1.00 22.92           C  
ATOM    559  OG  SER A  73      72.374  98.254 161.999  1.00 23.51           O  
ATOM    560  N   ILE A  74      72.423  95.348 160.359  1.00 21.85           N  
ATOM    561  CA  ILE A  74      71.277  94.601 159.831  1.00 21.48           C  
ATOM    562  C   ILE A  74      70.659  93.964 161.077  1.00 19.51           C  
ATOM    563  O   ILE A  74      71.315  93.193 161.768  1.00 19.29           O  
ATOM    564  CB  ILE A  74      71.689  93.463 158.850  1.00 21.70           C  
ATOM    565  CG1 ILE A  74      72.459  94.027 157.654  1.00 22.65           C  
ATOM    566  CG2 ILE A  74      70.442  92.736 158.350  1.00 18.52           C  
ATOM    567  CD1 ILE A  74      73.093  92.949 156.773  1.00 21.30           C  
ATOM    568  N   SER A  75      69.415  94.307 161.382  1.00 19.97           N  
ATOM    569  CA  SER A  75      68.756  93.742 162.558  1.00 20.79           C  
ATOM    570  C   SER A  75      67.732  92.663 162.207  1.00 21.51           C  
ATOM    571  O   SER A  75      67.518  91.727 162.983  1.00 22.16           O  
ATOM    572  CB  SER A  75      68.051  94.842 163.368  1.00 19.44           C  
ATOM    573  OG  SER A  75      68.987  95.678 164.025  1.00 22.24           O  
ATOM    574  N   VAL A  76      67.103  92.794 161.041  1.00 21.29           N  
ATOM    575  CA  VAL A  76      66.078  91.840 160.620  1.00 18.33           C  
ATOM    576  C   VAL A  76      66.250  91.402 159.172  1.00 19.24           C  
ATOM    577  O   VAL A  76      66.546  92.221 158.296  1.00 18.64           O  
ATOM    578  CB  VAL A  76      64.646  92.460 160.743  1.00 17.66           C  
ATOM    579  CG1 VAL A  76      63.561  91.417 160.397  1.00 13.41           C  
ATOM    580  CG2 VAL A  76      64.426  93.013 162.147  1.00 16.60           C  
ATOM    581  N   LEU A  77      66.072  90.107 158.928  1.00 18.40           N  
ATOM    582  CA  LEU A  77      66.122  89.566 157.575  1.00 16.52           C  
ATOM    583  C   LEU A  77      64.831  88.786 157.393  1.00 17.64           C  
ATOM    584  O   LEU A  77      64.506  87.911 158.199  1.00 17.88           O  
ATOM    585  CB  LEU A  77      67.309  88.618 157.359  1.00 16.64           C  
ATOM    586  CG  LEU A  77      67.217  87.826 156.031  1.00 18.14           C  
ATOM    587  CD1 LEU A  77      67.398  88.775 154.853  1.00 17.87           C  
ATOM    588  CD2 LEU A  77      68.272  86.733 155.978  1.00 16.54           C  
ATOM    589  N   VAL A  78      64.072  89.128 156.362  1.00 15.66           N  
ATOM    590  CA  VAL A  78      62.857  88.403 156.078  1.00 17.13           C  
ATOM    591  C   VAL A  78      63.046  87.670 154.755  1.00 18.66           C  
ATOM    592  O   VAL A  78      63.130  88.299 153.701  1.00 20.67           O  
ATOM    593  CB  VAL A  78      61.630  89.329 155.958  1.00 16.02           C  
ATOM    594  CG1 VAL A  78      60.392  88.493 155.647  1.00 16.49           C  
ATOM    595  CG2 VAL A  78      61.425  90.115 157.262  1.00 18.12           C  
ATOM    596  N   ASN A  79      63.147  86.347 154.815  1.00 18.93           N  
ATOM    597  CA  ASN A  79      63.284  85.544 153.605  1.00 18.45           C  
ATOM    598  C   ASN A  79      61.882  85.268 153.105  1.00 19.10           C  
ATOM    599  O   ASN A  79      61.094  84.594 153.780  1.00 17.67           O  
ATOM    600  CB  ASN A  79      63.996  84.226 153.900  1.00 15.77           C  
ATOM    601  CG  ASN A  79      65.477  84.409 154.093  1.00 18.70           C  
ATOM    602  OD1 ASN A  79      66.171  84.889 153.193  1.00 19.70           O  
ATOM    603  ND2 ASN A  79      65.978  84.036 155.266  1.00 19.38           N  
ATOM    604  N   ASN A  80      61.573  85.791 151.923  1.00 18.17           N  
ATOM    605  CA  ASN A  80      60.250  85.622 151.342  1.00 18.50           C  
ATOM    606  C   ASN A  80      60.249  85.201 149.861  1.00 19.71           C  
ATOM    607  O   ASN A  80      59.343  84.518 149.416  1.00 19.40           O  
ATOM    608  CB  ASN A  80      59.454  86.919 151.508  1.00 18.63           C  
ATOM    609  CG  ASN A  80      58.125  86.869 150.808  1.00 21.70           C  
ATOM    610  OD1 ASN A  80      57.176  86.242 151.291  1.00 19.82           O  
ATOM    611  ND2 ASN A  80      58.047  87.514 149.646  1.00 20.63           N  
ATOM    612  N   ALA A  81      61.261  85.604 149.106  1.00 19.58           N  
ATOM    613  CA  ALA A  81      61.343  85.258 147.690  1.00 22.60           C  
ATOM    614  C   ALA A  81      61.020  83.782 147.421  1.00 23.43           C  
ATOM    615  O   ALA A  81      61.656  82.886 147.964  1.00 22.51           O  
ATOM    616  CB  ALA A  81      62.749  85.594 147.150  1.00 21.02           C  
ATOM    617  N   GLY A  82      60.035  83.541 146.566  1.00 25.57           N  
ATOM    618  CA  GLY A  82      59.668  82.174 146.235  1.00 27.45           C  
ATOM    619  C   GLY A  82      58.897  82.076 144.931  1.00 27.86           C  
ATOM    620  O   GLY A  82      58.455  83.089 144.388  1.00 28.81           O  
ATOM    621  N   ILE A  83      58.747  80.856 144.423  1.00 26.96           N  
ATOM    622  CA  ILE A  83      58.015  80.618 143.182  1.00 26.41           C  
ATOM    623  C   ILE A  83      57.237  79.311 143.302  1.00 26.77           C  
ATOM    624  O   ILE A  83      57.473  78.512 144.208  1.00 22.93           O  
ATOM    625  CB  ILE A  83      58.963  80.460 141.961  1.00 26.27           C  
ATOM    626  CG1 ILE A  83      59.876  79.246 142.175  1.00 23.96           C  
ATOM    627  CG2 ILE A  83      59.770  81.734 141.742  1.00 26.48           C  
ATOM    628  CD1 ILE A  83      60.744  78.892 140.983  1.00 27.55           C  
ATOM    629  N   GLU A  84      56.307  79.102 142.378  1.00 27.97           N  
ATOM    630  CA  GLU A  84      55.546  77.864 142.357  1.00 29.03           C  
ATOM    631  C   GLU A  84      55.130  77.492 140.954  1.00 30.47           C  
ATOM    632  O   GLU A  84      54.617  78.318 140.192  1.00 30.27           O  
ATOM    633  CB  GLU A  84      54.298  77.928 143.239  1.00 27.18           C  
ATOM    634  CG  GLU A  84      53.620  76.560 143.325  1.00 28.35           C  
ATOM    635  CD  GLU A  84      52.527  76.484 144.381  1.00 28.16           C  
ATOM    636  OE1 GLU A  84      52.036  75.366 144.646  1.00 28.92           O  
ATOM    637  OE2 GLU A  84      52.162  77.532 144.944  1.00 26.75           O  
ATOM    638  N   SER A  85      55.377  76.231 140.628  1.00 30.44           N  
ATOM    639  CA  SER A  85      55.029  75.667 139.339  1.00 33.03           C  
ATOM    640  C   SER A  85      54.373  74.348 139.707  1.00 32.95           C  
ATOM    641  O   SER A  85      54.708  73.767 140.738  1.00 33.33           O  
ATOM    642  CB  SER A  85      56.288  75.427 138.506  1.00 32.48           C  
ATOM    643  OG  SER A  85      55.938  74.925 137.239  1.00 38.29           O  
ATOM    644  N   TYR A  86      53.470  73.859 138.866  1.00 32.80           N  
ATOM    645  CA  TYR A  86      52.755  72.624 139.164  1.00 32.43           C  
ATOM    646  C   TYR A  86      53.106  71.437 138.291  1.00 33.33           C  
ATOM    647  O   TYR A  86      53.538  71.600 137.151  1.00 34.82           O  
ATOM    648  CB  TYR A  86      51.257  72.896 139.070  1.00 31.55           C  
ATOM    649  CG  TYR A  86      50.842  74.060 139.930  1.00 30.20           C  
ATOM    650  CD1 TYR A  86      50.616  73.894 141.298  1.00 29.16           C  
ATOM    651  CD2 TYR A  86      50.719  75.339 139.386  1.00 29.19           C  
ATOM    652  CE1 TYR A  86      50.274  74.974 142.104  1.00 28.82           C  
ATOM    653  CE2 TYR A  86      50.380  76.426 140.181  1.00 28.49           C  
ATOM    654  CZ  TYR A  86      50.158  76.240 141.539  1.00 28.47           C  
ATOM    655  OH  TYR A  86      49.827  77.320 142.332  1.00 29.04           O  
ATOM    656  N   GLY A  87      52.910  70.237 138.831  1.00 31.93           N  
ATOM    657  CA  GLY A  87      53.193  69.045 138.063  1.00 31.85           C  
ATOM    658  C   GLY A  87      53.539  67.815 138.872  1.00 32.60           C  
ATOM    659  O   GLY A  87      54.138  67.904 139.941  1.00 31.42           O  
ATOM    660  N   LYS A  88      53.150  66.660 138.347  1.00 32.63           N  
ATOM    661  CA  LYS A  88      53.424  65.385 138.987  1.00 35.02           C  
ATOM    662  C   LYS A  88      54.932  65.154 138.889  1.00 35.01           C  
ATOM    663  O   LYS A  88      55.580  65.625 137.956  1.00 32.74           O  
ATOM    664  CB  LYS A  88      52.676  64.267 138.252  1.00 38.10           C  
ATOM    665  CG  LYS A  88      52.376  63.037 139.095  1.00 41.73           C  
ATOM    666  CD  LYS A  88      51.117  63.225 139.931  1.00 42.62           C  
ATOM    667  CE  LYS A  88      49.874  63.266 139.054  1.00 44.02           C  
ATOM    668  NZ  LYS A  88      48.630  63.551 139.827  1.00 44.80           N  
ATOM    669  N   ILE A  89      55.486  64.429 139.853  1.00 36.84           N  
ATOM    670  CA  ILE A  89      56.912  64.144 139.876  1.00 38.33           C  
ATOM    671  C   ILE A  89      57.368  63.549 138.541  1.00 39.74           C  
ATOM    672  O   ILE A  89      58.506  63.751 138.116  1.00 39.64           O  
ATOM    673  CB  ILE A  89      57.242  63.177 141.044  1.00 39.58           C  
ATOM    674  CG1 ILE A  89      58.745  63.127 141.292  1.00 39.28           C  
ATOM    675  CG2 ILE A  89      56.727  61.782 140.740  1.00 39.99           C  
ATOM    676  CD1 ILE A  89      59.110  62.349 142.548  1.00 39.03           C  
ATOM    677  N   GLU A  90      56.462  62.841 137.872  1.00 40.97           N  
ATOM    678  CA  GLU A  90      56.755  62.203 136.594  1.00 41.74           C  
ATOM    679  C   GLU A  90      56.698  63.115 135.380  1.00 40.57           C  
ATOM    680  O   GLU A  90      57.302  62.815 134.351  1.00 42.19           O  
ATOM    681  CB  GLU A  90      55.795  61.031 136.350  1.00 44.21           C  
ATOM    682  CG  GLU A  90      55.959  59.895 137.323  1.00 48.29           C  
ATOM    683  CD  GLU A  90      57.421  59.598 137.597  1.00 51.39           C  
ATOM    684  OE1 GLU A  90      58.209  59.528 136.627  1.00 53.10           O  
ATOM    685  OE2 GLU A  90      57.781  59.436 138.784  1.00 53.15           O  
ATOM    686  N   SER A  91      55.968  64.219 135.484  1.00 38.60           N  
ATOM    687  CA  SER A  91      55.841  65.122 134.352  1.00 37.51           C  
ATOM    688  C   SER A  91      56.730  66.361 134.430  1.00 35.26           C  
ATOM    689  O   SER A  91      57.228  66.833 133.407  1.00 35.31           O  
ATOM    690  CB  SER A  91      54.382  65.553 134.195  1.00 39.49           C  
ATOM    691  OG  SER A  91      53.955  66.295 135.323  1.00 44.66           O  
ATOM    692  N   MET A  92      56.918  66.899 135.634  1.00 31.25           N  
ATOM    693  CA  MET A  92      57.752  68.080 135.786  1.00 26.80           C  
ATOM    694  C   MET A  92      59.198  67.689 135.516  1.00 25.07           C  
ATOM    695  O   MET A  92      59.680  66.689 136.038  1.00 25.01           O  
ATOM    696  CB  MET A  92      57.617  68.657 137.198  1.00 25.51           C  
ATOM    697  CG  MET A  92      58.513  69.868 137.445  1.00 23.88           C  
ATOM    698  SD  MET A  92      58.249  70.635 139.052  1.00 23.79           S  
ATOM    699  CE  MET A  92      57.120  71.886 138.646  1.00 16.30           C  
ATOM    700  N   SER A  93      59.888  68.459 134.687  1.00 25.00           N  
ATOM    701  CA  SER A  93      61.279  68.146 134.387  1.00 25.25           C  
ATOM    702  C   SER A  93      62.085  68.250 135.676  1.00 25.16           C  
ATOM    703  O   SER A  93      61.705  68.975 136.598  1.00 23.40           O  
ATOM    704  CB  SER A  93      61.839  69.116 133.339  1.00 26.96           C  
ATOM    705  OG  SER A  93      61.938  70.436 133.845  1.00 28.24           O  
ATOM    706  N   MET A  94      63.195  67.524 135.745  1.00 25.71           N  
ATOM    707  CA  MET A  94      64.028  67.560 136.934  1.00 25.64           C  
ATOM    708  C   MET A  94      64.579  68.968 137.136  1.00 27.41           C  
ATOM    709  O   MET A  94      64.734  69.435 138.267  1.00 27.52           O  
ATOM    710  CB  MET A  94      65.159  66.544 136.803  1.00 25.79           C  
ATOM    711  CG  MET A  94      64.661  65.105 136.691  1.00 27.12           C  
ATOM    712  SD  MET A  94      66.010  63.915 136.730  1.00 30.98           S  
ATOM    713  CE  MET A  94      66.768  64.214 135.082  1.00 29.84           C  
ATOM    714  N   GLY A  95      64.855  69.648 136.027  1.00 27.25           N  
ATOM    715  CA  GLY A  95      65.378  70.996 136.093  1.00 25.82           C  
ATOM    716  C   GLY A  95      64.427  71.956 136.783  1.00 25.10           C  
ATOM    717  O   GLY A  95      64.834  72.711 137.656  1.00 25.92           O  
ATOM    718  N   GLU A  96      63.159  71.934 136.396  1.00 25.19           N  
ATOM    719  CA  GLU A  96      62.182  72.831 136.996  1.00 25.80           C  
ATOM    720  C   GLU A  96      61.969  72.491 138.469  1.00 24.71           C  
ATOM    721  O   GLU A  96      61.854  73.383 139.311  1.00 23.54           O  
ATOM    722  CB  GLU A  96      60.852  72.748 136.246  1.00 27.41           C  
ATOM    723  CG  GLU A  96      59.799  73.700 136.762  1.00 31.21           C  
ATOM    724  CD  GLU A  96      60.335  75.114 136.940  1.00 36.99           C  
ATOM    725  OE1 GLU A  96      61.226  75.519 136.157  1.00 38.92           O  
ATOM    726  OE2 GLU A  96      59.864  75.827 137.859  1.00 40.12           O  
ATOM    727  N   TRP A  97      61.917  71.197 138.763  1.00 23.23           N  
ATOM    728  CA  TRP A  97      61.728  70.718 140.128  1.00 23.32           C  
ATOM    729  C   TRP A  97      62.873  71.284 140.971  1.00 23.33           C  
ATOM    730  O   TRP A  97      62.652  71.871 142.035  1.00 22.04           O  
ATOM    731  CB  TRP A  97      61.771  69.179 140.156  1.00 20.56           C  
ATOM    732  CG  TRP A  97      61.080  68.559 141.339  1.00 21.88           C  
ATOM    733  CD1 TRP A  97      59.765  68.190 141.422  1.00 20.39           C  
ATOM    734  CD2 TRP A  97      61.653  68.291 142.631  1.00 22.51           C  
ATOM    735  NE1 TRP A  97      59.484  67.713 142.684  1.00 21.68           N  
ATOM    736  CE2 TRP A  97      60.622  67.767 143.447  1.00 21.97           C  
ATOM    737  CE3 TRP A  97      62.939  68.449 143.179  1.00 21.99           C  
ATOM    738  CZ2 TRP A  97      60.833  67.400 144.784  1.00 19.53           C  
ATOM    739  CZ3 TRP A  97      63.149  68.083 144.516  1.00 21.01           C  
ATOM    740  CH2 TRP A  97      62.096  67.565 145.298  1.00 22.47           C  
ATOM    741  N   ARG A  98      64.099  71.100 140.487  1.00 23.37           N  
ATOM    742  CA  ARG A  98      65.282  71.587 141.192  1.00 24.69           C  
ATOM    743  C   ARG A  98      65.293  73.112 141.297  1.00 23.44           C  
ATOM    744  O   ARG A  98      65.742  73.670 142.303  1.00 21.85           O  
ATOM    745  CB  ARG A  98      66.561  71.109 140.491  1.00 28.48           C  
ATOM    746  CG  ARG A  98      67.845  71.642 141.116  1.00 33.03           C  
ATOM    747  CD  ARG A  98      69.090  71.128 140.399  1.00 36.94           C  
ATOM    748  NE  ARG A  98      69.409  69.739 140.732  1.00 42.03           N  
ATOM    749  CZ  ARG A  98      69.959  69.343 141.880  1.00 42.87           C  
ATOM    750  NH1 ARG A  98      70.212  68.055 142.085  1.00 42.84           N  
ATOM    751  NH2 ARG A  98      70.264  70.229 142.820  1.00 44.13           N  
ATOM    752  N   ARG A  99      64.790  73.792 140.270  1.00 21.90           N  
ATOM    753  CA  ARG A  99      64.764  75.249 140.302  1.00 24.08           C  
ATOM    754  C   ARG A  99      63.843  75.760 141.410  1.00 23.53           C  
ATOM    755  O   ARG A  99      64.077  76.829 141.978  1.00 20.88           O  
ATOM    756  CB  ARG A  99      64.292  75.831 138.972  1.00 26.26           C  
ATOM    757  CG  ARG A  99      64.224  77.349 139.000  1.00 32.19           C  
ATOM    758  CD  ARG A  99      63.250  77.897 137.969  1.00 38.22           C  
ATOM    759  NE  ARG A  99      63.053  79.336 138.129  1.00 42.83           N  
ATOM    760  CZ  ARG A  99      61.943  79.979 137.780  1.00 45.00           C  
ATOM    761  NH1 ARG A  99      60.929  79.306 137.247  1.00 46.59           N  
ATOM    762  NH2 ARG A  99      61.839  81.288 137.973  1.00 45.67           N  
ATOM    763  N   ILE A 100      62.784  75.010 141.706  1.00 21.66           N  
ATOM    764  CA  ILE A 100      61.865  75.433 142.757  1.00 21.43           C  
ATOM    765  C   ILE A 100      62.582  75.340 144.102  1.00 19.77           C  
ATOM    766  O   ILE A 100      62.455  76.229 144.940  1.00 19.61           O  
ATOM    767  CB  ILE A 100      60.573  74.574 142.761  1.00 20.26           C  
ATOM    768  CG1 ILE A 100      59.741  74.911 141.517  1.00 17.53           C  
ATOM    769  CG2 ILE A 100      59.764  74.837 144.037  1.00 17.76           C  
ATOM    770  CD1 ILE A 100      58.506  74.023 141.303  1.00 18.78           C  
ATOM    771  N   ILE A 101      63.361  74.279 144.287  1.00 19.58           N  
ATOM    772  CA  ILE A 101      64.116  74.091 145.523  1.00 20.71           C  
ATOM    773  C   ILE A 101      65.202  75.180 145.664  1.00 23.85           C  
ATOM    774  O   ILE A 101      65.477  75.669 146.772  1.00 21.63           O  
ATOM    775  CB  ILE A 101      64.808  72.710 145.542  1.00 20.73           C  
ATOM    776  CG1 ILE A 101      63.771  71.595 145.341  1.00 22.24           C  
ATOM    777  CG2 ILE A 101      65.569  72.516 146.848  1.00 20.86           C  
ATOM    778  CD1 ILE A 101      62.572  71.657 146.287  1.00 19.36           C  
ATOM    779  N   ASP A 102      65.820  75.538 144.535  1.00 23.10           N  
ATOM    780  CA  ASP A 102      66.877  76.546 144.498  1.00 24.21           C  
ATOM    781  C   ASP A 102      66.384  77.884 145.010  1.00 20.84           C  
ATOM    782  O   ASP A 102      67.013  78.497 145.854  1.00 19.39           O  
ATOM    783  CB  ASP A 102      67.402  76.713 143.068  1.00 27.65           C  
ATOM    784  CG  ASP A 102      68.329  75.581 142.642  1.00 33.37           C  
ATOM    785  OD1 ASP A 102      68.518  75.404 141.416  1.00 36.72           O  
ATOM    786  OD2 ASP A 102      68.880  74.873 143.521  1.00 34.89           O  
ATOM    787  N   VAL A 103      65.251  78.338 144.490  1.00 22.25           N  
ATOM    788  CA  VAL A 103      64.700  79.607 144.925  1.00 22.80           C  
ATOM    789  C   VAL A 103      64.097  79.537 146.328  1.00 23.99           C  
ATOM    790  O   VAL A 103      64.472  80.313 147.206  1.00 24.52           O  
ATOM    791  CB  VAL A 103      63.608  80.108 143.951  1.00 24.18           C  
ATOM    792  CG1 VAL A 103      63.016  81.433 144.463  1.00 22.40           C  
ATOM    793  CG2 VAL A 103      64.202  80.293 142.536  1.00 22.20           C  
ATOM    794  N   ASN A 104      63.179  78.593 146.533  1.00 22.87           N  
ATOM    795  CA  ASN A 104      62.459  78.454 147.800  1.00 20.36           C  
ATOM    796  C   ASN A 104      63.255  78.047 149.030  1.00 21.25           C  
ATOM    797  O   ASN A 104      62.909  78.447 150.144  1.00 21.13           O  
ATOM    798  CB  ASN A 104      61.276  77.503 147.609  1.00 20.62           C  
ATOM    799  CG  ASN A 104      60.219  78.084 146.695  1.00 20.92           C  
ATOM    800  OD1 ASN A 104      60.466  79.075 146.008  1.00 23.48           O  
ATOM    801  ND2 ASN A 104      59.044  77.465 146.663  1.00 21.25           N  
ATOM    802  N   LEU A 105      64.307  77.255 148.837  1.00 19.59           N  
ATOM    803  CA  LEU A 105      65.133  76.833 149.956  1.00 19.95           C  
ATOM    804  C   LEU A 105      66.549  77.431 149.945  1.00 19.30           C  
ATOM    805  O   LEU A 105      66.958  78.077 150.909  1.00 17.10           O  
ATOM    806  CB  LEU A 105      65.228  75.304 150.012  1.00 16.86           C  
ATOM    807  CG  LEU A 105      66.284  74.772 150.987  1.00 19.31           C  
ATOM    808  CD1 LEU A 105      65.919  75.146 152.421  1.00 19.31           C  
ATOM    809  CD2 LEU A 105      66.416  73.269 150.829  1.00 20.19           C  
ATOM    810  N   PHE A 106      67.300  77.210 148.868  1.00 18.62           N  
ATOM    811  CA  PHE A 106      68.665  77.721 148.815  1.00 20.61           C  
ATOM    812  C   PHE A 106      68.723  79.244 148.899  1.00 19.63           C  
ATOM    813  O   PHE A 106      69.675  79.799 149.438  1.00 19.75           O  
ATOM    814  CB  PHE A 106      69.382  77.204 147.562  1.00 18.94           C  
ATOM    815  CG  PHE A 106      69.853  75.778 147.693  1.00 23.71           C  
ATOM    816  CD1 PHE A 106      71.026  75.483 148.383  1.00 22.14           C  
ATOM    817  CD2 PHE A 106      69.111  74.729 147.149  1.00 22.57           C  
ATOM    818  CE1 PHE A 106      71.456  74.160 148.530  1.00 24.86           C  
ATOM    819  CE2 PHE A 106      69.527  73.411 147.288  1.00 23.98           C  
ATOM    820  CZ  PHE A 106      70.706  73.123 147.981  1.00 24.26           C  
ATOM    821  N   GLY A 107      67.702  79.909 148.371  1.00 18.59           N  
ATOM    822  CA  GLY A 107      67.657  81.359 148.439  1.00 18.57           C  
ATOM    823  C   GLY A 107      67.618  81.809 149.891  1.00 20.52           C  
ATOM    824  O   GLY A 107      68.233  82.814 150.246  1.00 20.79           O  
ATOM    825  N   TYR A 108      66.890  81.070 150.729  1.00 17.69           N  
ATOM    826  CA  TYR A 108      66.781  81.379 152.157  1.00 15.77           C  
ATOM    827  C   TYR A 108      68.117  81.048 152.823  1.00 17.06           C  
ATOM    828  O   TYR A 108      68.578  81.784 153.691  1.00 17.40           O  
ATOM    829  CB  TYR A 108      65.672  80.535 152.818  1.00 15.35           C  
ATOM    830  CG  TYR A 108      64.255  81.025 152.585  1.00 14.49           C  
ATOM    831  CD1 TYR A 108      63.906  81.694 151.409  1.00 15.28           C  
ATOM    832  CD2 TYR A 108      63.246  80.768 153.517  1.00 15.54           C  
ATOM    833  CE1 TYR A 108      62.585  82.089 151.157  1.00 14.44           C  
ATOM    834  CE2 TYR A 108      61.920  81.155 153.281  1.00 14.30           C  
ATOM    835  CZ  TYR A 108      61.599  81.811 152.098  1.00 15.68           C  
ATOM    836  OH  TYR A 108      60.298  82.176 151.846  1.00 15.08           O  
ATOM    837  N   TYR A 109      68.723  79.928 152.428  1.00 15.56           N  
ATOM    838  CA  TYR A 109      70.014  79.524 152.984  1.00 15.83           C  
ATOM    839  C   TYR A 109      71.102  80.568 152.675  1.00 16.74           C  
ATOM    840  O   TYR A 109      71.869  80.948 153.563  1.00 16.36           O  
ATOM    841  CB  TYR A 109      70.401  78.143 152.437  1.00 15.69           C  
ATOM    842  CG  TYR A 109      71.865  77.772 152.553  1.00 17.19           C  
ATOM    843  CD1 TYR A 109      72.674  77.705 151.419  1.00 15.66           C  
ATOM    844  CD2 TYR A 109      72.444  77.477 153.790  1.00 18.20           C  
ATOM    845  CE1 TYR A 109      74.014  77.356 151.511  1.00 17.13           C  
ATOM    846  CE2 TYR A 109      73.791  77.128 153.891  1.00 19.20           C  
ATOM    847  CZ  TYR A 109      74.570  77.069 152.742  1.00 18.85           C  
ATOM    848  OH  TYR A 109      75.903  76.729 152.821  1.00 19.63           O  
ATOM    849  N   TYR A 110      71.157  81.042 151.429  1.00 17.33           N  
ATOM    850  CA  TYR A 110      72.157  82.043 151.033  1.00 17.29           C  
ATOM    851  C   TYR A 110      71.986  83.365 151.777  1.00 18.77           C  
ATOM    852  O   TYR A 110      72.940  83.885 152.364  1.00 18.56           O  
ATOM    853  CB  TYR A 110      72.098  82.318 149.523  1.00 17.42           C  
ATOM    854  CG  TYR A 110      72.476  81.135 148.649  1.00 17.48           C  
ATOM    855  CD1 TYR A 110      73.464  80.240 149.044  1.00 17.57           C  
ATOM    856  CD2 TYR A 110      71.845  80.917 147.428  1.00 19.20           C  
ATOM    857  CE1 TYR A 110      73.818  79.150 148.247  1.00 18.71           C  
ATOM    858  CE2 TYR A 110      72.193  79.826 146.617  1.00 18.22           C  
ATOM    859  CZ  TYR A 110      73.179  78.951 147.034  1.00 18.73           C  
ATOM    860  OH  TYR A 110      73.539  77.883 146.237  1.00 21.99           O  
ATOM    861  N   ALA A 111      70.776  83.919 151.748  1.00 18.12           N  
ATOM    862  CA  ALA A 111      70.538  85.186 152.425  1.00 19.06           C  
ATOM    863  C   ALA A 111      70.878  85.085 153.912  1.00 19.12           C  
ATOM    864  O   ALA A 111      71.522  85.981 154.466  1.00 20.56           O  
ATOM    865  CB  ALA A 111      69.076  85.634 152.230  1.00 18.92           C  
ATOM    866  N   SER A 112      70.451  83.995 154.553  1.00 16.90           N  
ATOM    867  CA  SER A 112      70.722  83.774 155.978  1.00 18.75           C  
ATOM    868  C   SER A 112      72.205  83.628 156.277  1.00 19.19           C  
ATOM    869  O   SER A 112      72.724  84.255 157.194  1.00 19.67           O  
ATOM    870  CB  SER A 112      69.994  82.513 156.478  1.00 19.48           C  
ATOM    871  OG  SER A 112      68.590  82.653 156.333  1.00 19.83           O  
ATOM    872  N   LYS A 113      72.879  82.785 155.502  1.00 20.06           N  
ATOM    873  CA  LYS A 113      74.302  82.526 155.671  1.00 20.90           C  
ATOM    874  C   LYS A 113      75.169  83.799 155.641  1.00 20.39           C  
ATOM    875  O   LYS A 113      76.114  83.938 156.419  1.00 20.00           O  
ATOM    876  CB  LYS A 113      74.780  81.566 154.574  1.00 24.37           C  
ATOM    877  CG  LYS A 113      76.215  81.116 154.718  1.00 26.94           C  
ATOM    878  CD  LYS A 113      76.649  80.252 153.539  1.00 27.08           C  
ATOM    879  CE  LYS A 113      78.137  80.425 153.271  1.00 26.00           C  
ATOM    880  NZ  LYS A 113      79.004  80.039 154.416  1.00 31.44           N  
ATOM    881  N   PHE A 114      74.845  84.725 154.748  1.00 18.56           N  
ATOM    882  CA  PHE A 114      75.639  85.940 154.634  1.00 20.99           C  
ATOM    883  C   PHE A 114      75.214  87.092 155.530  1.00 20.93           C  
ATOM    884  O   PHE A 114      76.033  87.934 155.874  1.00 21.17           O  
ATOM    885  CB  PHE A 114      75.695  86.380 153.173  1.00 18.83           C  
ATOM    886  CG  PHE A 114      76.341  85.366 152.284  1.00 19.62           C  
ATOM    887  CD1 PHE A 114      75.603  84.701 151.306  1.00 21.13           C  
ATOM    888  CD2 PHE A 114      77.669  84.996 152.492  1.00 20.64           C  
ATOM    889  CE1 PHE A 114      76.175  83.672 150.551  1.00 19.08           C  
ATOM    890  CE2 PHE A 114      78.251  83.963 151.742  1.00 23.10           C  
ATOM    891  CZ  PHE A 114      77.499  83.302 150.772  1.00 20.96           C  
ATOM    892  N   ALA A 115      73.944  87.120 155.920  1.00 21.63           N  
ATOM    893  CA  ALA A 115      73.452  88.185 156.781  1.00 20.83           C  
ATOM    894  C   ALA A 115      73.760  87.936 158.256  1.00 22.86           C  
ATOM    895  O   ALA A 115      74.039  88.877 159.004  1.00 21.39           O  
ATOM    896  CB  ALA A 115      71.944  88.353 156.595  1.00 22.46           C  
ATOM    897  N   ILE A 116      73.717  86.671 158.671  1.00 21.81           N  
ATOM    898  CA  ILE A 116      73.940  86.334 160.072  1.00 22.52           C  
ATOM    899  C   ILE A 116      75.202  86.923 160.713  1.00 22.62           C  
ATOM    900  O   ILE A 116      75.121  87.542 161.777  1.00 24.20           O  
ATOM    901  CB  ILE A 116      73.870  84.798 160.283  1.00 20.90           C  
ATOM    902  CG1 ILE A 116      72.411  84.333 160.127  1.00 23.02           C  
ATOM    903  CG2 ILE A 116      74.398  84.427 161.653  1.00 21.93           C  
ATOM    904  CD1 ILE A 116      72.204  82.801 160.107  1.00 19.93           C  
ATOM    905  N   PRO A 117      76.377  86.746 160.083  1.00 23.61           N  
ATOM    906  CA  PRO A 117      77.609  87.297 160.662  1.00 24.50           C  
ATOM    907  C   PRO A 117      77.472  88.782 161.016  1.00 25.47           C  
ATOM    908  O   PRO A 117      78.004  89.236 162.026  1.00 25.73           O  
ATOM    909  CB  PRO A 117      78.641  87.057 159.564  1.00 26.51           C  
ATOM    910  CG  PRO A 117      78.163  85.749 158.964  1.00 23.72           C  
ATOM    911  CD  PRO A 117      76.671  85.978 158.857  1.00 22.46           C  
ATOM    912  N   TYR A 118      76.753  89.527 160.180  1.00 23.40           N  
ATOM    913  CA  TYR A 118      76.534  90.947 160.418  1.00 23.09           C  
ATOM    914  C   TYR A 118      75.459  91.157 161.478  1.00 24.90           C  
ATOM    915  O   TYR A 118      75.597  92.010 162.365  1.00 22.27           O  
ATOM    916  CB  TYR A 118      76.087  91.646 159.134  1.00 22.45           C  
ATOM    917  CG  TYR A 118      77.134  91.694 158.044  1.00 24.57           C  
ATOM    918  CD1 TYR A 118      76.886  91.128 156.795  1.00 22.35           C  
ATOM    919  CD2 TYR A 118      78.348  92.363 158.241  1.00 22.35           C  
ATOM    920  CE1 TYR A 118      77.816  91.232 155.757  1.00 24.24           C  
ATOM    921  CE2 TYR A 118      79.288  92.475 157.211  1.00 22.81           C  
ATOM    922  CZ  TYR A 118      79.011  91.912 155.972  1.00 24.69           C  
ATOM    923  OH  TYR A 118      79.899  92.063 154.935  1.00 24.89           O  
ATOM    924  N   MET A 119      74.389  90.371 161.374  1.00 22.55           N  
ATOM    925  CA  MET A 119      73.274  90.468 162.301  1.00 23.13           C  
ATOM    926  C   MET A 119      73.660  90.268 163.763  1.00 22.12           C  
ATOM    927  O   MET A 119      73.166  90.979 164.639  1.00 21.58           O  
ATOM    928  CB  MET A 119      72.177  89.480 161.889  1.00 22.49           C  
ATOM    929  CG  MET A 119      71.496  89.883 160.590  1.00 21.30           C  
ATOM    930  SD  MET A 119      70.221  88.745 160.015  1.00 23.16           S  
ATOM    931  CE  MET A 119      68.883  89.172 161.090  1.00 17.61           C  
ATOM    932  N   ILE A 120      74.539  89.310 164.037  1.00 22.95           N  
ATOM    933  CA  ILE A 120      74.940  89.088 165.411  1.00 25.77           C  
ATOM    934  C   ILE A 120      75.774  90.252 165.951  1.00 27.03           C  
ATOM    935  O   ILE A 120      76.201  90.232 167.101  1.00 25.57           O  
ATOM    936  CB  ILE A 120      75.722  87.766 165.591  1.00 27.35           C  
ATOM    937  CG1 ILE A 120      76.933  87.734 164.668  1.00 29.42           C  
ATOM    938  CG2 ILE A 120      74.798  86.567 165.331  1.00 29.16           C  
ATOM    939  CD1 ILE A 120      77.775  86.469 164.839  1.00 32.06           C  
ATOM    940  N   ARG A 121      76.016  91.263 165.123  1.00 29.58           N  
ATOM    941  CA  ARG A 121      76.764  92.425 165.586  1.00 32.40           C  
ATOM    942  C   ARG A 121      75.798  93.495 166.069  1.00 33.58           C  
ATOM    943  O   ARG A 121      76.223  94.559 166.519  1.00 36.30           O  
ATOM    944  CB  ARG A 121      77.649  92.999 164.484  1.00 33.12           C  
ATOM    945  CG  ARG A 121      78.807  92.115 164.083  1.00 34.30           C  
ATOM    946  CD  ARG A 121      79.623  92.804 163.005  1.00 39.45           C  
ATOM    947  NE  ARG A 121      80.323  91.848 162.161  1.00 43.25           N  
ATOM    948  CZ  ARG A 121      81.086  92.186 161.127  1.00 45.14           C  
ATOM    949  NH1 ARG A 121      81.248  93.468 160.817  1.00 43.85           N  
ATOM    950  NH2 ARG A 121      81.668  91.239 160.395  1.00 45.19           N  
ATOM    951  N   SER A 122      74.500  93.219 165.964  1.00 33.30           N  
ATOM    952  CA  SER A 122      73.477  94.155 166.427  1.00 33.44           C  
ATOM    953  C   SER A 122      72.792  93.570 167.650  1.00 33.90           C  
ATOM    954  O   SER A 122      73.025  92.412 168.008  1.00 30.97           O  
ATOM    955  CB  SER A 122      72.423  94.407 165.354  1.00 34.56           C  
ATOM    956  OG  SER A 122      73.006  94.884 164.159  1.00 38.89           O  
ATOM    957  N   ARG A 123      71.941  94.376 168.279  1.00 34.67           N  
ATOM    958  CA  ARG A 123      71.208  93.954 169.468  1.00 36.14           C  
ATOM    959  C   ARG A 123      69.965  93.157 169.097  1.00 32.98           C  
ATOM    960  O   ARG A 123      69.116  93.629 168.345  1.00 29.64           O  
ATOM    961  CB  ARG A 123      70.782  95.173 170.299  1.00 41.08           C  
ATOM    962  CG  ARG A 123      71.910  95.874 171.050  1.00 47.86           C  
ATOM    963  CD  ARG A 123      72.451  95.002 172.181  1.00 51.97           C  
ATOM    964  NE  ARG A 123      73.168  93.834 171.683  1.00 56.49           N  
ATOM    965  CZ  ARG A 123      73.593  92.834 172.451  1.00 58.91           C  
ATOM    966  NH1 ARG A 123      73.370  92.858 173.761  1.00 59.90           N  
ATOM    967  NH2 ARG A 123      74.250  91.811 171.910  1.00 59.32           N  
ATOM    968  N   ASP A 124      69.870  91.944 169.631  1.00 31.93           N  
ATOM    969  CA  ASP A 124      68.723  91.081 169.377  1.00 29.25           C  
ATOM    970  C   ASP A 124      68.216  91.082 167.931  1.00 26.20           C  
ATOM    971  O   ASP A 124      67.124  91.585 167.616  1.00 23.64           O  
ATOM    972  CB  ASP A 124      67.583  91.442 170.332  1.00 31.19           C  
ATOM    973  CG  ASP A 124      67.968  91.249 171.785  1.00 33.43           C  
ATOM    974  OD1 ASP A 124      68.533  90.181 172.123  1.00 34.72           O  
ATOM    975  OD2 ASP A 124      67.702  92.163 172.589  1.00 35.48           O  
ATOM    976  N   PRO A 125      69.029  90.535 167.024  1.00 23.15           N  
ATOM    977  CA  PRO A 125      68.649  90.460 165.615  1.00 22.77           C  
ATOM    978  C   PRO A 125      67.584  89.369 165.477  1.00 21.38           C  
ATOM    979  O   PRO A 125      67.460  88.497 166.345  1.00 19.31           O  
ATOM    980  CB  PRO A 125      69.959  90.095 164.927  1.00 20.61           C  
ATOM    981  CG  PRO A 125      70.670  89.288 165.965  1.00 21.87           C  
ATOM    982  CD  PRO A 125      70.426  90.111 167.214  1.00 23.72           C  
ATOM    983  N   SER A 126      66.827  89.414 164.388  1.00 20.68           N  
ATOM    984  CA  SER A 126      65.765  88.444 164.169  1.00 21.59           C  
ATOM    985  C   SER A 126      65.582  88.111 162.688  1.00 21.62           C  
ATOM    986  O   SER A 126      65.703  88.987 161.820  1.00 19.14           O  
ATOM    987  CB  SER A 126      64.447  89.006 164.725  1.00 22.56           C  
ATOM    988  OG  SER A 126      63.408  88.049 164.643  1.00 28.75           O  
ATOM    989  N   ILE A 127      65.301  86.840 162.407  1.00 19.25           N  
ATOM    990  CA  ILE A 127      65.057  86.400 161.040  1.00 16.88           C  
ATOM    991  C   ILE A 127      63.671  85.771 160.989  1.00 18.45           C  
ATOM    992  O   ILE A 127      63.275  85.045 161.907  1.00 16.76           O  
ATOM    993  CB  ILE A 127      66.082  85.340 160.574  1.00 17.91           C  
ATOM    994  CG1 ILE A 127      67.484  85.958 160.489  1.00 17.38           C  
ATOM    995  CG2 ILE A 127      65.666  84.774 159.216  1.00 14.58           C  
ATOM    996  CD1 ILE A 127      68.571  84.954 160.108  1.00 17.61           C  
ATOM    997  N   VAL A 128      62.924  86.088 159.940  1.00 16.89           N  
ATOM    998  CA  VAL A 128      61.603  85.511 159.753  1.00 16.56           C  
ATOM    999  C   VAL A 128      61.548  84.910 158.356  1.00 16.49           C  
ATOM   1000  O   VAL A 128      61.769  85.602 157.364  1.00 16.06           O  
ATOM   1001  CB  VAL A 128      60.465  86.555 159.890  1.00 15.27           C  
ATOM   1002  CG1 VAL A 128      59.121  85.861 159.786  1.00 13.79           C  
ATOM   1003  CG2 VAL A 128      60.571  87.283 161.235  1.00 16.42           C  
ATOM   1004  N   ASN A 129      61.278  83.610 158.294  1.00 15.30           N  
ATOM   1005  CA  ASN A 129      61.180  82.892 157.030  1.00 16.12           C  
ATOM   1006  C   ASN A 129      59.722  82.650 156.669  1.00 16.85           C  
ATOM   1007  O   ASN A 129      58.933  82.188 157.503  1.00 18.85           O  
ATOM   1008  CB  ASN A 129      61.927  81.561 157.137  1.00 14.49           C  
ATOM   1009  CG  ASN A 129      63.406  81.764 157.366  1.00 16.27           C  
ATOM   1010  OD1 ASN A 129      63.961  82.745 156.889  1.00 15.95           O  
ATOM   1011  ND2 ASN A 129      64.055  80.841 158.083  1.00 14.54           N  
ATOM   1012  N   ILE A 130      59.342  82.995 155.444  1.00 16.45           N  
ATOM   1013  CA  ILE A 130      57.966  82.768 155.031  1.00 15.74           C  
ATOM   1014  C   ILE A 130      57.899  81.361 154.466  1.00 16.39           C  
ATOM   1015  O   ILE A 130      58.505  81.057 153.441  1.00 17.05           O  
ATOM   1016  CB  ILE A 130      57.494  83.762 153.951  1.00 16.00           C  
ATOM   1017  CG1 ILE A 130      57.738  85.206 154.418  1.00 14.96           C  
ATOM   1018  CG2 ILE A 130      56.019  83.494 153.614  1.00 16.08           C  
ATOM   1019  CD1 ILE A 130      57.211  85.532 155.813  1.00 13.51           C  
ATOM   1020  N   SER A 131      57.196  80.491 155.176  1.00 16.49           N  
ATOM   1021  CA  SER A 131      57.025  79.122 154.740  1.00 16.32           C  
ATOM   1022  C   SER A 131      55.635  79.051 154.102  1.00 16.74           C  
ATOM   1023  O   SER A 131      55.332  79.817 153.191  1.00 19.65           O  
ATOM   1024  CB  SER A 131      57.135  78.167 155.936  1.00 15.65           C  
ATOM   1025  OG  SER A 131      57.013  76.818 155.534  1.00 19.50           O  
ATOM   1026  N   SER A 132      54.784  78.161 154.599  1.00 16.98           N  
ATOM   1027  CA  SER A 132      53.441  78.009 154.058  1.00 16.10           C  
ATOM   1028  C   SER A 132      52.625  77.075 154.927  1.00 16.65           C  
ATOM   1029  O   SER A 132      53.184  76.304 155.711  1.00 16.74           O  
ATOM   1030  CB  SER A 132      53.505  77.443 152.636  1.00 15.90           C  
ATOM   1031  OG  SER A 132      52.236  76.975 152.198  1.00 17.50           O  
ATOM   1032  N   VAL A 133      51.305  77.142 154.796  1.00 15.50           N  
ATOM   1033  CA  VAL A 133      50.456  76.240 155.565  1.00 16.36           C  
ATOM   1034  C   VAL A 133      50.776  74.834 155.051  1.00 16.59           C  
ATOM   1035  O   VAL A 133      50.535  73.834 155.729  1.00 15.78           O  
ATOM   1036  CB  VAL A 133      48.947  76.544 155.345  1.00 14.69           C  
ATOM   1037  CG1 VAL A 133      48.544  76.228 153.888  1.00 14.17           C  
ATOM   1038  CG2 VAL A 133      48.105  75.737 156.319  1.00 14.38           C  
ATOM   1039  N   GLN A 134      51.348  74.772 153.849  1.00 15.91           N  
ATOM   1040  CA  GLN A 134      51.678  73.499 153.238  1.00 16.58           C  
ATOM   1041  C   GLN A 134      52.921  72.839 153.829  1.00 17.97           C  
ATOM   1042  O   GLN A 134      53.481  71.889 153.266  1.00 17.46           O  
ATOM   1043  CB  GLN A 134      51.774  73.640 151.709  1.00 16.66           C  
ATOM   1044  CG  GLN A 134      50.436  74.046 151.074  1.00 13.94           C  
ATOM   1045  CD  GLN A 134      50.428  73.931 149.556  1.00 15.66           C  
ATOM   1046  OE1 GLN A 134      50.674  72.862 149.008  1.00 14.47           O  
ATOM   1047  NE2 GLN A 134      50.138  75.039 148.872  1.00 13.13           N  
ATOM   1048  N   ALA A 135      53.342  73.365 154.973  1.00 18.68           N  
ATOM   1049  CA  ALA A 135      54.429  72.780 155.731  1.00 18.31           C  
ATOM   1050  C   ALA A 135      53.716  71.701 156.573  1.00 18.52           C  
ATOM   1051  O   ALA A 135      54.370  70.886 157.212  1.00 17.47           O  
ATOM   1052  CB  ALA A 135      55.077  73.822 156.644  1.00 19.65           C  
ATOM   1053  N   SER A 136      52.375  71.721 156.563  1.00 18.55           N  
ATOM   1054  CA  SER A 136      51.544  70.747 157.293  1.00 20.78           C  
ATOM   1055  C   SER A 136      50.542  70.048 156.378  1.00 18.93           C  
ATOM   1056  O   SER A 136      50.638  68.845 156.167  1.00 18.97           O  
ATOM   1057  CB  SER A 136      50.756  71.409 158.438  1.00 23.64           C  
ATOM   1058  OG  SER A 136      51.623  71.927 159.430  1.00 31.03           O  
ATOM   1059  N   ILE A 137      49.556  70.795 155.878  1.00 18.14           N  
ATOM   1060  CA  ILE A 137      48.544  70.249 154.963  1.00 17.48           C  
ATOM   1061  C   ILE A 137      48.887  70.729 153.554  1.00 19.04           C  
ATOM   1062  O   ILE A 137      49.072  71.929 153.320  1.00 19.09           O  
ATOM   1063  CB  ILE A 137      47.106  70.688 155.358  1.00 17.76           C  
ATOM   1064  CG1 ILE A 137      47.065  72.195 155.629  1.00 16.02           C  
ATOM   1065  CG2 ILE A 137      46.652  69.908 156.593  1.00 19.32           C  
ATOM   1066  CD1 ILE A 137      45.653  72.764 155.708  1.00 17.34           C  
ATOM   1067  N   ILE A 138      48.932  69.788 152.614  1.00 18.92           N  
ATOM   1068  CA  ILE A 138      49.374  70.084 151.256  1.00 19.50           C  
ATOM   1069  C   ILE A 138      48.401  69.926 150.092  1.00 21.32           C  
ATOM   1070  O   ILE A 138      47.313  69.351 150.225  1.00 18.96           O  
ATOM   1071  CB  ILE A 138      50.615  69.232 150.932  1.00 19.58           C  
ATOM   1072  CG1 ILE A 138      50.197  67.774 150.689  1.00 17.50           C  
ATOM   1073  CG2 ILE A 138      51.581  69.261 152.123  1.00 15.97           C  
ATOM   1074  CD1 ILE A 138      51.207  66.948 149.882  1.00 18.04           C  
ATOM   1075  N   THR A 139      48.830  70.434 148.939  1.00 21.38           N  
ATOM   1076  CA  THR A 139      48.027  70.379 147.728  1.00 22.42           C  
ATOM   1077  C   THR A 139      48.606  69.376 146.749  1.00 22.39           C  
ATOM   1078  O   THR A 139      49.770  68.995 146.846  1.00 20.20           O  
ATOM   1079  CB  THR A 139      47.928  71.780 147.049  1.00 22.63           C  
ATOM   1080  OG1 THR A 139      49.239  72.268 146.717  1.00 19.68           O  
ATOM   1081  CG2 THR A 139      47.254  72.754 147.992  1.00 21.48           C  
ATOM   1082  N   LYS A 140      47.780  68.948 145.805  1.00 24.07           N  
ATOM   1083  CA  LYS A 140      48.210  67.972 144.818  1.00 25.34           C  
ATOM   1084  C   LYS A 140      49.064  68.591 143.712  1.00 24.96           C  
ATOM   1085  O   LYS A 140      48.952  69.784 143.414  1.00 25.11           O  
ATOM   1086  CB  LYS A 140      46.985  67.288 144.212  1.00 27.73           C  
ATOM   1087  CG  LYS A 140      47.304  66.001 143.461  1.00 33.40           C  
ATOM   1088  CD  LYS A 140      46.033  65.209 143.153  1.00 35.92           C  
ATOM   1089  CE  LYS A 140      46.357  63.930 142.395  1.00 37.98           C  
ATOM   1090  NZ  LYS A 140      45.161  63.044 142.250  1.00 39.75           N  
ATOM   1091  N   ASN A 141      49.917  67.760 143.122  1.00 25.07           N  
ATOM   1092  CA  ASN A 141      50.815  68.157 142.039  1.00 26.56           C  
ATOM   1093  C   ASN A 141      51.674  69.375 142.365  1.00 25.15           C  
ATOM   1094  O   ASN A 141      51.916  70.215 141.500  1.00 24.91           O  
ATOM   1095  CB  ASN A 141      50.018  68.430 140.762  1.00 28.17           C  
ATOM   1096  CG  ASN A 141      49.073  67.302 140.416  1.00 29.81           C  
ATOM   1097  OD1 ASN A 141      49.444  66.128 140.471  1.00 32.75           O  
ATOM   1098  ND2 ASN A 141      47.845  67.650 140.052  1.00 31.27           N  
ATOM   1099  N   ALA A 142      52.133  69.464 143.612  1.00 23.05           N  
ATOM   1100  CA  ALA A 142      52.973  70.578 144.041  1.00 21.89           C  
ATOM   1101  C   ALA A 142      54.176  70.040 144.807  1.00 20.97           C  
ATOM   1102  O   ALA A 142      54.653  70.651 145.763  1.00 19.78           O  
ATOM   1103  CB  ALA A 142      52.172  71.528 144.918  1.00 23.66           C  
ATOM   1104  N   SER A 143      54.661  68.892 144.356  1.00 20.63           N  
ATOM   1105  CA  SER A 143      55.796  68.199 144.958  1.00 22.10           C  
ATOM   1106  C   SER A 143      57.004  69.079 145.331  1.00 21.84           C  
ATOM   1107  O   SER A 143      57.419  69.118 146.486  1.00 22.43           O  
ATOM   1108  CB  SER A 143      56.249  67.083 144.013  1.00 22.10           C  
ATOM   1109  OG  SER A 143      57.302  66.343 144.584  1.00 32.20           O  
ATOM   1110  N   ALA A 144      57.584  69.764 144.356  1.00 20.71           N  
ATOM   1111  CA  ALA A 144      58.746  70.611 144.634  1.00 20.55           C  
ATOM   1112  C   ALA A 144      58.415  71.717 145.636  1.00 20.06           C  
ATOM   1113  O   ALA A 144      59.185  71.968 146.557  1.00 19.49           O  
ATOM   1114  CB  ALA A 144      59.280  71.232 143.334  1.00 16.73           C  
ATOM   1115  N   TYR A 145      57.277  72.376 145.439  1.00 18.98           N  
ATOM   1116  CA  TYR A 145      56.860  73.460 146.314  1.00 19.36           C  
ATOM   1117  C   TYR A 145      56.699  72.980 147.755  1.00 18.37           C  
ATOM   1118  O   TYR A 145      57.277  73.557 148.686  1.00 15.88           O  
ATOM   1119  CB  TYR A 145      55.532  74.051 145.828  1.00 19.48           C  
ATOM   1120  CG  TYR A 145      55.035  75.221 146.653  1.00 19.46           C  
ATOM   1121  CD1 TYR A 145      55.540  76.506 146.460  1.00 20.08           C  
ATOM   1122  CD2 TYR A 145      54.057  75.038 147.630  1.00 19.23           C  
ATOM   1123  CE1 TYR A 145      55.076  77.590 147.230  1.00 21.20           C  
ATOM   1124  CE2 TYR A 145      53.589  76.098 148.395  1.00 19.83           C  
ATOM   1125  CZ  TYR A 145      54.095  77.369 148.195  1.00 22.92           C  
ATOM   1126  OH  TYR A 145      53.599  78.406 148.951  1.00 24.81           O  
ATOM   1127  N   VAL A 146      55.902  71.929 147.925  1.00 17.10           N  
ATOM   1128  CA  VAL A 146      55.636  71.353 149.239  1.00 18.41           C  
ATOM   1129  C   VAL A 146      56.941  70.920 149.898  1.00 18.35           C  
ATOM   1130  O   VAL A 146      57.162  71.159 151.089  1.00 16.43           O  
ATOM   1131  CB  VAL A 146      54.673  70.132 149.122  1.00 19.03           C  
ATOM   1132  CG1 VAL A 146      54.573  69.399 150.448  1.00 17.17           C  
ATOM   1133  CG2 VAL A 146      53.291  70.613 148.698  1.00 21.97           C  
ATOM   1134  N   THR A 147      57.808  70.286 149.121  1.00 18.14           N  
ATOM   1135  CA  THR A 147      59.086  69.843 149.654  1.00 18.20           C  
ATOM   1136  C   THR A 147      59.894  71.042 150.136  1.00 18.55           C  
ATOM   1137  O   THR A 147      60.429  71.033 151.245  1.00 18.94           O  
ATOM   1138  CB  THR A 147      59.888  69.067 148.599  1.00 18.22           C  
ATOM   1139  OG1 THR A 147      59.156  67.892 148.229  1.00 15.92           O  
ATOM   1140  CG2 THR A 147      61.246  68.642 149.152  1.00 18.09           C  
ATOM   1141  N   SER A 148      59.955  72.087 149.320  1.00 16.33           N  
ATOM   1142  CA  SER A 148      60.715  73.271 149.689  1.00 17.47           C  
ATOM   1143  C   SER A 148      60.168  73.926 150.963  1.00 16.91           C  
ATOM   1144  O   SER A 148      60.944  74.340 151.818  1.00 19.10           O  
ATOM   1145  CB  SER A 148      60.741  74.290 148.533  1.00 14.72           C  
ATOM   1146  OG  SER A 148      59.479  74.920 148.322  1.00 15.35           O  
ATOM   1147  N   LYS A 149      58.848  74.014 151.100  1.00 15.38           N  
ATOM   1148  CA  LYS A 149      58.272  74.635 152.292  1.00 16.44           C  
ATOM   1149  C   LYS A 149      58.522  73.839 153.585  1.00 17.27           C  
ATOM   1150  O   LYS A 149      58.644  74.427 154.661  1.00 17.55           O  
ATOM   1151  CB  LYS A 149      56.775  74.899 152.089  1.00 17.37           C  
ATOM   1152  CG  LYS A 149      56.493  75.959 151.038  1.00 14.88           C  
ATOM   1153  CD  LYS A 149      57.258  77.238 151.364  1.00 21.39           C  
ATOM   1154  CE  LYS A 149      57.044  78.328 150.314  1.00 25.23           C  
ATOM   1155  NZ  LYS A 149      57.415  79.687 150.857  1.00 26.75           N  
ATOM   1156  N   HIS A 150      58.590  72.512 153.490  1.00 16.01           N  
ATOM   1157  CA  HIS A 150      58.892  71.688 154.664  1.00 15.32           C  
ATOM   1158  C   HIS A 150      60.367  71.954 155.001  1.00 16.09           C  
ATOM   1159  O   HIS A 150      60.734  72.128 156.167  1.00 14.73           O  
ATOM   1160  CB  HIS A 150      58.711  70.188 154.360  1.00 16.03           C  
ATOM   1161  CG  HIS A 150      57.300  69.702 154.502  1.00 16.00           C  
ATOM   1162  ND1 HIS A 150      56.292  70.067 153.635  1.00 13.12           N  
ATOM   1163  CD2 HIS A 150      56.727  68.884 155.419  1.00 13.39           C  
ATOM   1164  CE1 HIS A 150      55.161  69.495 154.011  1.00 14.17           C  
ATOM   1165  NE2 HIS A 150      55.397  68.772 155.091  1.00 16.61           N  
ATOM   1166  N   ALA A 151      61.207  71.983 153.966  1.00 13.65           N  
ATOM   1167  CA  ALA A 151      62.639  72.228 154.153  1.00 13.95           C  
ATOM   1168  C   ALA A 151      62.874  73.556 154.869  1.00 15.76           C  
ATOM   1169  O   ALA A 151      63.730  73.642 155.759  1.00 17.01           O  
ATOM   1170  CB  ALA A 151      63.361  72.211 152.805  1.00 12.63           C  
ATOM   1171  N   VAL A 152      62.116  74.588 154.496  1.00 14.82           N  
ATOM   1172  CA  VAL A 152      62.254  75.901 155.139  1.00 16.18           C  
ATOM   1173  C   VAL A 152      62.021  75.813 156.655  1.00 16.79           C  
ATOM   1174  O   VAL A 152      62.664  76.517 157.435  1.00 17.27           O  
ATOM   1175  CB  VAL A 152      61.270  76.940 154.524  1.00 15.04           C  
ATOM   1176  CG1 VAL A 152      61.215  78.196 155.387  1.00 14.71           C  
ATOM   1177  CG2 VAL A 152      61.734  77.297 153.096  1.00 17.84           C  
ATOM   1178  N   ILE A 153      61.087  74.967 157.073  1.00 16.11           N  
ATOM   1179  CA  ILE A 153      60.840  74.795 158.501  1.00 16.05           C  
ATOM   1180  C   ILE A 153      62.102  74.203 159.153  1.00 16.30           C  
ATOM   1181  O   ILE A 153      62.497  74.601 160.249  1.00 15.27           O  
ATOM   1182  CB  ILE A 153      59.640  73.844 158.758  1.00 16.47           C  
ATOM   1183  CG1 ILE A 153      58.360  74.455 158.185  1.00 14.15           C  
ATOM   1184  CG2 ILE A 153      59.484  73.593 160.261  1.00 14.00           C  
ATOM   1185  CD1 ILE A 153      58.074  75.851 158.701  1.00 15.59           C  
ATOM   1186  N   GLY A 154      62.743  73.256 158.471  1.00 16.37           N  
ATOM   1187  CA  GLY A 154      63.947  72.655 159.032  1.00 14.95           C  
ATOM   1188  C   GLY A 154      65.074  73.666 159.166  1.00 15.74           C  
ATOM   1189  O   GLY A 154      65.775  73.719 160.188  1.00 16.36           O  
ATOM   1190  N   LEU A 155      65.257  74.472 158.126  1.00 15.50           N  
ATOM   1191  CA  LEU A 155      66.294  75.505 158.131  1.00 16.60           C  
ATOM   1192  C   LEU A 155      66.026  76.493 159.275  1.00 15.89           C  
ATOM   1193  O   LEU A 155      66.951  76.924 159.974  1.00 17.19           O  
ATOM   1194  CB  LEU A 155      66.308  76.252 156.784  1.00 15.25           C  
ATOM   1195  CG  LEU A 155      67.318  77.406 156.659  1.00 18.59           C  
ATOM   1196  CD1 LEU A 155      68.739  76.861 156.710  1.00 18.66           C  
ATOM   1197  CD2 LEU A 155      67.097  78.165 155.367  1.00 16.68           C  
ATOM   1198  N   THR A 156      64.757  76.838 159.460  1.00 15.26           N  
ATOM   1199  CA  THR A 156      64.342  77.771 160.509  1.00 15.31           C  
ATOM   1200  C   THR A 156      64.688  77.279 161.919  1.00 16.73           C  
ATOM   1201  O   THR A 156      65.220  78.042 162.733  1.00 14.80           O  
ATOM   1202  CB  THR A 156      62.832  78.034 160.423  1.00 15.24           C  
ATOM   1203  OG1 THR A 156      62.541  78.625 159.154  1.00 13.18           O  
ATOM   1204  CG2 THR A 156      62.370  78.988 161.558  1.00 14.34           C  
ATOM   1205  N   LYS A 157      64.378  76.014 162.204  1.00 15.94           N  
ATOM   1206  CA  LYS A 157      64.687  75.423 163.512  1.00 16.39           C  
ATOM   1207  C   LYS A 157      66.195  75.417 163.732  1.00 17.09           C  
ATOM   1208  O   LYS A 157      66.673  75.786 164.811  1.00 18.93           O  
ATOM   1209  CB  LYS A 157      64.171  73.977 163.600  1.00 14.54           C  
ATOM   1210  CG  LYS A 157      62.651  73.845 163.552  1.00 15.55           C  
ATOM   1211  CD  LYS A 157      62.232  72.384 163.634  1.00 15.20           C  
ATOM   1212  CE  LYS A 157      60.717  72.236 163.733  1.00 15.79           C  
ATOM   1213  NZ  LYS A 157      60.326  70.800 163.615  1.00 17.07           N  
ATOM   1214  N   SER A 158      66.937  74.991 162.709  1.00 15.42           N  
ATOM   1215  CA  SER A 158      68.395  74.918 162.774  1.00 17.70           C  
ATOM   1216  C   SER A 158      69.010  76.270 163.125  1.00 16.99           C  
ATOM   1217  O   SER A 158      69.798  76.364 164.059  1.00 18.02           O  
ATOM   1218  CB  SER A 158      68.984  74.449 161.439  1.00 18.30           C  
ATOM   1219  OG  SER A 158      68.551  73.147 161.118  1.00 27.08           O  
ATOM   1220  N   ILE A 159      68.669  77.303 162.357  1.00 15.67           N  
ATOM   1221  CA  ILE A 159      69.190  78.639 162.624  1.00 17.23           C  
ATOM   1222  C   ILE A 159      68.818  79.077 164.043  1.00 18.85           C  
ATOM   1223  O   ILE A 159      69.650  79.624 164.773  1.00 19.35           O  
ATOM   1224  CB  ILE A 159      68.642  79.669 161.610  1.00 17.03           C  
ATOM   1225  CG1 ILE A 159      69.168  79.335 160.207  1.00 16.46           C  
ATOM   1226  CG2 ILE A 159      69.045  81.084 162.024  1.00 16.08           C  
ATOM   1227  CD1 ILE A 159      68.615  80.235 159.097  1.00 16.44           C  
ATOM   1228  N   ALA A 160      67.573  78.824 164.434  1.00 17.74           N  
ATOM   1229  CA  ALA A 160      67.113  79.190 165.767  1.00 18.82           C  
ATOM   1230  C   ALA A 160      67.954  78.504 166.835  1.00 18.14           C  
ATOM   1231  O   ALA A 160      68.395  79.140 167.783  1.00 19.65           O  
ATOM   1232  CB  ALA A 160      65.630  78.821 165.953  1.00 15.51           C  
ATOM   1233  N   LEU A 161      68.165  77.203 166.688  1.00 19.92           N  
ATOM   1234  CA  LEU A 161      68.954  76.461 167.663  1.00 19.94           C  
ATOM   1235  C   LEU A 161      70.439  76.801 167.619  1.00 21.15           C  
ATOM   1236  O   LEU A 161      71.091  76.868 168.665  1.00 19.80           O  
ATOM   1237  CB  LEU A 161      68.794  74.949 167.461  1.00 20.73           C  
ATOM   1238  CG  LEU A 161      69.561  74.077 168.471  1.00 23.20           C  
ATOM   1239  CD1 LEU A 161      69.048  74.355 169.874  1.00 21.09           C  
ATOM   1240  CD2 LEU A 161      69.396  72.597 168.132  1.00 21.27           C  
ATOM   1241  N   ASP A 162      70.980  77.007 166.421  1.00 20.04           N  
ATOM   1242  CA  ASP A 162      72.406  77.302 166.278  1.00 21.43           C  
ATOM   1243  C   ASP A 162      72.842  78.666 166.836  1.00 23.17           C  
ATOM   1244  O   ASP A 162      73.967  78.807 167.315  1.00 22.64           O  
ATOM   1245  CB  ASP A 162      72.828  77.227 164.804  1.00 21.90           C  
ATOM   1246  CG  ASP A 162      72.898  75.794 164.262  1.00 26.78           C  
ATOM   1247  OD1 ASP A 162      72.575  74.838 164.997  1.00 26.77           O  
ATOM   1248  OD2 ASP A 162      73.283  75.632 163.077  1.00 26.67           O  
ATOM   1249  N   TYR A 163      71.964  79.664 166.767  1.00 22.97           N  
ATOM   1250  CA  TYR A 163      72.322  80.998 167.226  1.00 23.67           C  
ATOM   1251  C   TYR A 163      71.609  81.570 168.454  1.00 23.69           C  
ATOM   1252  O   TYR A 163      71.853  82.721 168.823  1.00 24.42           O  
ATOM   1253  CB  TYR A 163      72.212  81.991 166.058  1.00 24.55           C  
ATOM   1254  CG  TYR A 163      73.152  81.661 164.916  1.00 25.38           C  
ATOM   1255  CD1 TYR A 163      72.716  80.905 163.823  1.00 26.46           C  
ATOM   1256  CD2 TYR A 163      74.496  82.033 164.964  1.00 26.09           C  
ATOM   1257  CE1 TYR A 163      73.592  80.523 162.815  1.00 25.87           C  
ATOM   1258  CE2 TYR A 163      75.386  81.653 163.960  1.00 27.14           C  
ATOM   1259  CZ  TYR A 163      74.924  80.895 162.890  1.00 27.78           C  
ATOM   1260  OH  TYR A 163      75.796  80.490 161.909  1.00 30.05           O  
ATOM   1261  N   ALA A 164      70.726  80.801 169.080  1.00 22.45           N  
ATOM   1262  CA  ALA A 164      70.062  81.293 170.283  1.00 22.57           C  
ATOM   1263  C   ALA A 164      71.181  81.411 171.324  1.00 22.78           C  
ATOM   1264  O   ALA A 164      72.118  80.625 171.308  1.00 21.93           O  
ATOM   1265  CB  ALA A 164      69.005  80.296 170.756  1.00 23.19           C  
ATOM   1266  N   PRO A 165      71.086  82.371 172.256  1.00 22.25           N  
ATOM   1267  CA  PRO A 165      70.020  83.357 172.428  1.00 22.59           C  
ATOM   1268  C   PRO A 165      70.293  84.680 171.711  1.00 22.54           C  
ATOM   1269  O   PRO A 165      69.479  85.585 171.770  1.00 24.70           O  
ATOM   1270  CB  PRO A 165      69.982  83.532 173.940  1.00 21.88           C  
ATOM   1271  CG  PRO A 165      71.468  83.581 174.259  1.00 21.08           C  
ATOM   1272  CD  PRO A 165      72.065  82.469 173.360  1.00 22.10           C  
ATOM   1273  N   LEU A 166      71.438  84.787 171.046  1.00 23.69           N  
ATOM   1274  CA  LEU A 166      71.818  86.009 170.336  1.00 26.16           C  
ATOM   1275  C   LEU A 166      70.843  86.427 169.246  1.00 26.37           C  
ATOM   1276  O   LEU A 166      70.466  87.596 169.145  1.00 29.42           O  
ATOM   1277  CB  LEU A 166      73.196  85.847 169.695  1.00 27.78           C  
ATOM   1278  CG  LEU A 166      74.376  85.557 170.618  1.00 32.27           C  
ATOM   1279  CD1 LEU A 166      75.646  85.461 169.785  1.00 33.08           C  
ATOM   1280  CD2 LEU A 166      74.492  86.648 171.678  1.00 32.76           C  
ATOM   1281  N   LEU A 167      70.445  85.470 168.421  1.00 22.66           N  
ATOM   1282  CA  LEU A 167      69.546  85.752 167.315  1.00 19.85           C  
ATOM   1283  C   LEU A 167      68.382  84.771 167.308  1.00 19.06           C  
ATOM   1284  O   LEU A 167      68.559  83.588 167.605  1.00 18.58           O  
ATOM   1285  CB  LEU A 167      70.349  85.668 166.008  1.00 18.87           C  
ATOM   1286  CG  LEU A 167      69.665  85.691 164.646  1.00 19.66           C  
ATOM   1287  CD1 LEU A 167      70.640  86.267 163.610  1.00 21.57           C  
ATOM   1288  CD2 LEU A 167      69.230  84.284 164.268  1.00 16.03           C  
ATOM   1289  N   ARG A 168      67.194  85.274 166.990  1.00 17.43           N  
ATOM   1290  CA  ARG A 168      65.999  84.443 166.937  1.00 17.70           C  
ATOM   1291  C   ARG A 168      65.649  84.175 165.485  1.00 18.14           C  
ATOM   1292  O   ARG A 168      65.964  84.974 164.606  1.00 19.29           O  
ATOM   1293  CB  ARG A 168      64.818  85.143 167.625  1.00 14.48           C  
ATOM   1294  CG  ARG A 168      65.025  85.383 169.128  1.00 15.54           C  
ATOM   1295  CD  ARG A 168      63.827  86.040 169.768  1.00 13.74           C  
ATOM   1296  NE  ARG A 168      63.539  87.327 169.162  1.00 16.16           N  
ATOM   1297  CZ  ARG A 168      62.533  87.549 168.325  1.00 19.06           C  
ATOM   1298  NH1 ARG A 168      61.704  86.559 168.001  1.00 17.19           N  
ATOM   1299  NH2 ARG A 168      62.375  88.760 167.798  1.00 17.75           N  
ATOM   1300  N   CYS A 169      65.010  83.041 165.234  1.00 17.04           N  
ATOM   1301  CA  CYS A 169      64.591  82.697 163.883  1.00 17.10           C  
ATOM   1302  C   CYS A 169      63.260  81.953 163.938  1.00 16.31           C  
ATOM   1303  O   CYS A 169      63.147  80.922 164.593  1.00 16.45           O  
ATOM   1304  CB  CYS A 169      65.633  81.816 163.190  1.00 16.75           C  
ATOM   1305  SG  CYS A 169      65.210  81.482 161.455  1.00 16.42           S  
ATOM   1306  N   ASN A 170      62.263  82.481 163.243  1.00 15.55           N  
ATOM   1307  CA  ASN A 170      60.944  81.867 163.215  1.00 15.39           C  
ATOM   1308  C   ASN A 170      60.409  81.914 161.789  1.00 16.59           C  
ATOM   1309  O   ASN A 170      60.985  82.573 160.915  1.00 16.93           O  
ATOM   1310  CB  ASN A 170      59.984  82.627 164.137  1.00 13.85           C  
ATOM   1311  CG  ASN A 170      60.402  82.577 165.598  1.00 14.85           C  
ATOM   1312  OD1 ASN A 170      60.203  81.563 166.284  1.00 15.47           O  
ATOM   1313  ND2 ASN A 170      60.984  83.675 166.088  1.00 11.55           N  
ATOM   1314  N   ALA A 171      59.302  81.218 161.561  1.00 14.60           N  
ATOM   1315  CA  ALA A 171      58.678  81.205 160.252  1.00 14.88           C  
ATOM   1316  C   ALA A 171      57.204  81.576 160.361  1.00 15.66           C  
ATOM   1317  O   ALA A 171      56.618  81.559 161.458  1.00 15.83           O  
ATOM   1318  CB  ALA A 171      58.820  79.835 159.625  1.00 14.68           C  
ATOM   1319  N   VAL A 172      56.619  81.956 159.231  1.00 14.89           N  
ATOM   1320  CA  VAL A 172      55.193  82.268 159.178  1.00 15.33           C  
ATOM   1321  C   VAL A 172      54.647  81.283 158.144  1.00 16.58           C  
ATOM   1322  O   VAL A 172      55.250  81.095 157.074  1.00 15.32           O  
ATOM   1323  CB  VAL A 172      54.915  83.735 158.747  1.00 17.03           C  
ATOM   1324  CG1 VAL A 172      53.423  83.944 158.558  1.00 16.39           C  
ATOM   1325  CG2 VAL A 172      55.409  84.697 159.824  1.00 15.77           C  
ATOM   1326  N   CYS A 173      53.536  80.634 158.487  1.00 15.18           N  
ATOM   1327  CA  CYS A 173      52.912  79.631 157.633  1.00 16.07           C  
ATOM   1328  C   CYS A 173      51.538  80.099 157.141  1.00 16.58           C  
ATOM   1329  O   CYS A 173      50.499  79.745 157.699  1.00 16.51           O  
ATOM   1330  CB  CYS A 173      52.842  78.285 158.402  1.00 17.29           C  
ATOM   1331  SG  CYS A 173      54.511  77.540 158.580  1.00 17.91           S  
ATOM   1332  N   PRO A 174      51.525  80.897 156.059  1.00 18.11           N  
ATOM   1333  CA  PRO A 174      50.314  81.455 155.442  1.00 17.81           C  
ATOM   1334  C   PRO A 174      49.520  80.453 154.610  1.00 17.17           C  
ATOM   1335  O   PRO A 174      50.101  79.622 153.916  1.00 13.52           O  
ATOM   1336  CB  PRO A 174      50.851  82.582 154.541  1.00 19.98           C  
ATOM   1337  CG  PRO A 174      52.316  82.728 154.921  1.00 21.82           C  
ATOM   1338  CD  PRO A 174      52.721  81.341 155.328  1.00 18.26           C  
ATOM   1339  N   ALA A 175      48.193  80.522 154.690  1.00 16.81           N  
ATOM   1340  CA  ALA A 175      47.368  79.648 153.862  1.00 16.47           C  
ATOM   1341  C   ALA A 175      47.116  80.487 152.594  1.00 19.04           C  
ATOM   1342  O   ALA A 175      48.032  81.161 152.115  1.00 19.78           O  
ATOM   1343  CB  ALA A 175      46.056  79.306 154.569  1.00 14.34           C  
ATOM   1344  N   THR A 176      45.896  80.480 152.061  1.00 19.81           N  
ATOM   1345  CA  THR A 176      45.618  81.248 150.847  1.00 19.82           C  
ATOM   1346  C   THR A 176      45.507  82.745 151.123  1.00 19.23           C  
ATOM   1347  O   THR A 176      44.652  83.182 151.890  1.00 21.17           O  
ATOM   1348  CB  THR A 176      44.317  80.765 150.156  1.00 19.66           C  
ATOM   1349  OG1 THR A 176      44.389  79.351 149.953  1.00 18.85           O  
ATOM   1350  CG2 THR A 176      44.144  81.456 148.798  1.00 18.47           C  
ATOM   1351  N   ILE A 177      46.370  83.522 150.471  1.00 19.88           N  
ATOM   1352  CA  ILE A 177      46.428  84.976 150.635  1.00 18.95           C  
ATOM   1353  C   ILE A 177      46.173  85.682 149.290  1.00 20.59           C  
ATOM   1354  O   ILE A 177      46.557  85.181 148.239  1.00 20.58           O  
ATOM   1355  CB  ILE A 177      47.826  85.394 151.168  1.00 19.48           C  
ATOM   1356  CG1 ILE A 177      48.177  84.563 152.411  1.00 16.87           C  
ATOM   1357  CG2 ILE A 177      47.848  86.904 151.495  1.00 16.70           C  
ATOM   1358  CD1 ILE A 177      47.224  84.750 153.591  1.00 14.07           C  
ATOM   1359  N   ASP A 178      45.533  86.845 149.321  1.00 21.48           N  
ATOM   1360  CA  ASP A 178      45.233  87.567 148.083  1.00 22.95           C  
ATOM   1361  C   ASP A 178      46.474  88.248 147.496  1.00 23.20           C  
ATOM   1362  O   ASP A 178      46.810  89.371 147.867  1.00 22.78           O  
ATOM   1363  CB  ASP A 178      44.152  88.616 148.337  1.00 24.20           C  
ATOM   1364  CG  ASP A 178      43.482  89.088 147.049  1.00 27.03           C  
ATOM   1365  OD1 ASP A 178      43.941  88.705 145.950  1.00 27.85           O  
ATOM   1366  OD2 ASP A 178      42.494  89.847 147.141  1.00 29.10           O  
ATOM   1367  N   THR A 179      47.148  87.553 146.589  1.00 24.60           N  
ATOM   1368  CA  THR A 179      48.360  88.068 145.945  1.00 27.83           C  
ATOM   1369  C   THR A 179      48.310  87.772 144.441  1.00 30.41           C  
ATOM   1370  O   THR A 179      47.434  87.043 143.963  1.00 28.17           O  
ATOM   1371  CB  THR A 179      49.632  87.377 146.494  1.00 26.87           C  
ATOM   1372  OG1 THR A 179      49.653  86.015 146.051  1.00 28.32           O  
ATOM   1373  CG2 THR A 179      49.650  87.393 148.012  1.00 27.16           C  
ATOM   1374  N   PRO A 180      49.247  88.350 143.672  1.00 33.34           N  
ATOM   1375  CA  PRO A 180      49.264  88.103 142.226  1.00 33.55           C  
ATOM   1376  C   PRO A 180      49.501  86.626 141.922  1.00 33.76           C  
ATOM   1377  O   PRO A 180      48.896  86.066 141.009  1.00 33.34           O  
ATOM   1378  CB  PRO A 180      50.405  88.994 141.742  1.00 34.67           C  
ATOM   1379  CG  PRO A 180      50.269  90.188 142.642  1.00 35.91           C  
ATOM   1380  CD  PRO A 180      50.072  89.528 144.008  1.00 34.40           C  
ATOM   1381  N   LEU A 181      50.378  86.000 142.699  1.00 34.19           N  
ATOM   1382  CA  LEU A 181      50.682  84.587 142.514  1.00 34.20           C  
ATOM   1383  C   LEU A 181      49.406  83.759 142.639  1.00 33.49           C  
ATOM   1384  O   LEU A 181      49.151  82.878 141.816  1.00 33.28           O  
ATOM   1385  CB  LEU A 181      51.703  84.121 143.562  1.00 37.67           C  
ATOM   1386  CG  LEU A 181      52.331  82.718 143.454  1.00 40.50           C  
ATOM   1387  CD1 LEU A 181      53.316  82.528 144.604  1.00 42.21           C  
ATOM   1388  CD2 LEU A 181      51.271  81.622 143.505  1.00 41.95           C  
ATOM   1389  N   VAL A 182      48.615  84.040 143.675  1.00 30.61           N  
ATOM   1390  CA  VAL A 182      47.369  83.314 143.910  1.00 29.44           C  
ATOM   1391  C   VAL A 182      46.338  83.608 142.821  1.00 29.63           C  
ATOM   1392  O   VAL A 182      45.642  82.703 142.371  1.00 28.66           O  
ATOM   1393  CB  VAL A 182      46.769  83.649 145.303  1.00 26.97           C  
ATOM   1394  CG1 VAL A 182      45.336  83.158 145.394  1.00 26.96           C  
ATOM   1395  CG2 VAL A 182      47.607  82.994 146.393  1.00 29.18           C  
ATOM   1396  N   ARG A 183      46.228  84.869 142.410  1.00 30.34           N  
ATOM   1397  CA  ARG A 183      45.292  85.229 141.342  1.00 32.51           C  
ATOM   1398  C   ARG A 183      45.706  84.450 140.092  1.00 32.68           C  
ATOM   1399  O   ARG A 183      44.871  83.919 139.361  1.00 33.42           O  
ATOM   1400  CB  ARG A 183      45.358  86.731 141.050  1.00 34.94           C  
ATOM   1401  CG  ARG A 183      44.836  87.630 142.167  1.00 38.29           C  
ATOM   1402  CD  ARG A 183      43.327  87.806 142.095  1.00 40.80           C  
ATOM   1403  NE  ARG A 183      42.793  88.482 143.277  1.00 42.36           N  
ATOM   1404  CZ  ARG A 183      41.498  88.710 143.482  1.00 43.48           C  
ATOM   1405  NH1 ARG A 183      40.603  88.327 142.579  1.00 44.81           N  
ATOM   1406  NH2 ARG A 183      41.092  89.287 144.606  1.00 42.01           N  
ATOM   1407  N   LYS A 184      47.012  84.373 139.862  1.00 32.98           N  
ATOM   1408  CA  LYS A 184      47.549  83.659 138.711  1.00 33.40           C  
ATOM   1409  C   LYS A 184      47.245  82.163 138.827  1.00 32.08           C  
ATOM   1410  O   LYS A 184      46.925  81.506 137.839  1.00 30.73           O  
ATOM   1411  CB  LYS A 184      49.061  83.894 138.623  1.00 36.45           C  
ATOM   1412  CG  LYS A 184      49.686  83.640 137.252  1.00 41.37           C  
ATOM   1413  CD  LYS A 184      49.723  82.163 136.895  1.00 44.59           C  
ATOM   1414  CE  LYS A 184      50.488  81.924 135.589  1.00 46.53           C  
ATOM   1415  NZ  LYS A 184      49.878  82.655 134.436  1.00 48.25           N  
ATOM   1416  N   ALA A 185      47.341  81.623 140.040  1.00 31.21           N  
ATOM   1417  CA  ALA A 185      47.061  80.208 140.259  1.00 30.42           C  
ATOM   1418  C   ALA A 185      45.605  79.921 139.887  1.00 30.76           C  
ATOM   1419  O   ALA A 185      45.294  78.878 139.306  1.00 31.13           O  
ATOM   1420  CB  ALA A 185      47.319  79.837 141.721  1.00 30.53           C  
ATOM   1421  N   ALA A 186      44.719  80.853 140.228  1.00 31.61           N  
ATOM   1422  CA  ALA A 186      43.303  80.715 139.914  1.00 34.10           C  
ATOM   1423  C   ALA A 186      43.122  80.814 138.403  1.00 35.86           C  
ATOM   1424  O   ALA A 186      42.429  79.998 137.801  1.00 37.14           O  
ATOM   1425  CB  ALA A 186      42.497  81.804 140.614  1.00 32.03           C  
ATOM   1426  N   GLU A 187      43.752  81.811 137.789  1.00 38.04           N  
ATOM   1427  CA  GLU A 187      43.651  81.980 136.340  1.00 40.70           C  
ATOM   1428  C   GLU A 187      44.059  80.709 135.603  1.00 40.11           C  
ATOM   1429  O   GLU A 187      43.436  80.342 134.610  1.00 41.26           O  
ATOM   1430  CB  GLU A 187      44.510  83.155 135.861  1.00 43.14           C  
ATOM   1431  CG  GLU A 187      44.543  83.287 134.339  1.00 48.63           C  
ATOM   1432  CD  GLU A 187      44.794  84.707 133.865  1.00 51.18           C  
ATOM   1433  OE1 GLU A 187      44.917  84.903 132.635  1.00 53.60           O  
ATOM   1434  OE2 GLU A 187      44.859  85.627 134.715  1.00 52.23           O  
ATOM   1435  N   LEU A 188      45.095  80.033 136.095  1.00 39.61           N  
ATOM   1436  CA  LEU A 188      45.564  78.786 135.490  1.00 40.94           C  
ATOM   1437  C   LEU A 188      44.482  77.708 135.507  1.00 42.71           C  
ATOM   1438  O   LEU A 188      44.610  76.673 134.841  1.00 42.95           O  
ATOM   1439  CB  LEU A 188      46.791  78.251 136.236  1.00 40.24           C  
ATOM   1440  CG  LEU A 188      48.146  78.907 135.992  1.00 41.20           C  
ATOM   1441  CD1 LEU A 188      49.155  78.397 137.013  1.00 40.95           C  
ATOM   1442  CD2 LEU A 188      48.606  78.605 134.571  1.00 40.42           C  
ATOM   1443  N   GLU A 189      43.432  77.942 136.289  1.00 43.80           N  
ATOM   1444  CA  GLU A 189      42.326  76.996 136.406  1.00 44.14           C  
ATOM   1445  C   GLU A 189      41.037  77.489 135.741  1.00 45.13           C  
ATOM   1446  O   GLU A 189      40.321  76.706 135.123  1.00 45.76           O  
ATOM   1447  CB  GLU A 189      42.029  76.699 137.887  1.00 43.63           C  
ATOM   1448  CG  GLU A 189      42.621  75.397 138.423  1.00 43.30           C  
ATOM   1449  CD  GLU A 189      42.122  75.049 139.827  1.00 43.00           C  
ATOM   1450  OE1 GLU A 189      42.600  75.650 140.810  1.00 40.62           O  
ATOM   1451  OE2 GLU A 189      41.242  74.173 139.944  1.00 42.73           O  
ATOM   1452  N   VAL A 190      40.751  78.784 135.848  1.00 45.70           N  
ATOM   1453  CA  VAL A 190      39.507  79.318 135.299  1.00 46.74           C  
ATOM   1454  C   VAL A 190      39.560  80.389 134.197  1.00 47.27           C  
ATOM   1455  O   VAL A 190      38.511  80.821 133.710  1.00 47.25           O  
ATOM   1456  CB  VAL A 190      38.620  79.859 136.448  1.00 45.80           C  
ATOM   1457  CG1 VAL A 190      38.449  78.786 137.508  1.00 45.80           C  
ATOM   1458  CG2 VAL A 190      39.242  81.111 137.052  1.00 46.37           C  
ATOM   1459  N   GLY A 191      40.754  80.823 133.803  1.00 47.76           N  
ATOM   1460  CA  GLY A 191      40.846  81.834 132.763  1.00 47.65           C  
ATOM   1461  C   GLY A 191      40.933  83.251 133.306  1.00 49.20           C  
ATOM   1462  O   GLY A 191      40.992  83.456 134.523  1.00 47.53           O  
ATOM   1463  N   SER A 192      40.909  84.231 132.402  1.00 49.15           N  
ATOM   1464  CA  SER A 192      41.037  85.637 132.780  1.00 50.56           C  
ATOM   1465  C   SER A 192      39.763  86.368 133.194  1.00 51.23           C  
ATOM   1466  O   SER A 192      39.812  87.557 133.508  1.00 50.39           O  
ATOM   1467  CB  SER A 192      41.700  86.417 131.641  1.00 50.97           C  
ATOM   1468  OG  SER A 192      40.848  86.464 130.507  1.00 51.37           O  
ATOM   1469  N   ASP A 193      38.625  85.683 133.193  1.00 52.45           N  
ATOM   1470  CA  ASP A 193      37.381  86.336 133.581  1.00 53.79           C  
ATOM   1471  C   ASP A 193      37.451  86.760 135.051  1.00 54.19           C  
ATOM   1472  O   ASP A 193      37.406  85.921 135.947  1.00 53.65           O  
ATOM   1473  CB  ASP A 193      36.192  85.392 133.378  1.00 55.71           C  
ATOM   1474  CG  ASP A 193      34.854  86.108 133.477  1.00 56.98           C  
ATOM   1475  OD1 ASP A 193      34.719  87.009 134.332  1.00 57.28           O  
ATOM   1476  OD2 ASP A 193      33.933  85.765 132.706  1.00 57.81           O  
ATOM   1477  N   PRO A 194      37.555  88.074 135.316  1.00 55.02           N  
ATOM   1478  CA  PRO A 194      37.630  88.577 136.694  1.00 55.87           C  
ATOM   1479  C   PRO A 194      36.460  88.090 137.549  1.00 56.37           C  
ATOM   1480  O   PRO A 194      36.515  88.115 138.778  1.00 55.59           O  
ATOM   1481  CB  PRO A 194      37.631  90.094 136.509  1.00 56.04           C  
ATOM   1482  CG  PRO A 194      36.862  90.280 135.240  1.00 56.37           C  
ATOM   1483  CD  PRO A 194      37.417  89.189 134.363  1.00 55.20           C  
ATOM   1484  N   MET A 195      35.404  87.647 136.877  1.00 56.87           N  
ATOM   1485  CA  MET A 195      34.213  87.138 137.539  1.00 57.37           C  
ATOM   1486  C   MET A 195      34.415  85.657 137.889  1.00 55.71           C  
ATOM   1487  O   MET A 195      34.100  85.222 138.997  1.00 54.96           O  
ATOM   1488  CB  MET A 195      33.011  87.319 136.610  1.00 59.93           C  
ATOM   1489  CG  MET A 195      31.722  86.708 137.089  1.00 63.83           C  
ATOM   1490  SD  MET A 195      30.485  86.770 135.771  1.00 70.39           S  
ATOM   1491  CE  MET A 195      30.868  85.248 134.856  1.00 68.37           C  
ATOM   1492  N   ARG A 196      34.951  84.889 136.945  1.00 53.96           N  
ATOM   1493  CA  ARG A 196      35.199  83.468 137.169  1.00 52.21           C  
ATOM   1494  C   ARG A 196      36.389  83.258 138.110  1.00 51.20           C  
ATOM   1495  O   ARG A 196      36.473  82.247 138.814  1.00 49.49           O  
ATOM   1496  CB  ARG A 196      35.464  82.763 135.841  1.00 53.39           C  
ATOM   1497  CG  ARG A 196      34.281  82.767 134.889  1.00 56.92           C  
ATOM   1498  CD  ARG A 196      34.587  81.943 133.648  1.00 59.89           C  
ATOM   1499  NE  ARG A 196      34.988  80.580 133.995  1.00 62.16           N  
ATOM   1500  CZ  ARG A 196      35.434  79.680 133.122  1.00 63.84           C  
ATOM   1501  NH1 ARG A 196      35.539  79.993 131.833  1.00 64.71           N  
ATOM   1502  NH2 ARG A 196      35.793  78.471 133.536  1.00 63.69           N  
ATOM   1503  N   ILE A 197      37.315  84.211 138.103  1.00 48.34           N  
ATOM   1504  CA  ILE A 197      38.481  84.137 138.966  1.00 47.40           C  
ATOM   1505  C   ILE A 197      38.041  84.432 140.387  1.00 46.25           C  
ATOM   1506  O   ILE A 197      38.438  83.740 141.323  1.00 47.71           O  
ATOM   1507  CB  ILE A 197      39.562  85.167 138.556  1.00 47.40           C  
ATOM   1508  CG1 ILE A 197      40.313  84.666 137.321  1.00 47.61           C  
ATOM   1509  CG2 ILE A 197      40.530  85.409 139.710  1.00 46.24           C  
ATOM   1510  CD1 ILE A 197      41.340  85.647 136.788  1.00 49.57           C  
ATOM   1511  N   GLU A 198      37.219  85.462 140.543  1.00 44.51           N  
ATOM   1512  CA  GLU A 198      36.733  85.839 141.860  1.00 43.78           C  
ATOM   1513  C   GLU A 198      35.950  84.670 142.448  1.00 42.02           C  
ATOM   1514  O   GLU A 198      35.926  84.470 143.663  1.00 42.16           O  
ATOM   1515  CB  GLU A 198      35.848  87.086 141.759  1.00 44.27           C  
ATOM   1516  CG  GLU A 198      35.669  87.836 143.081  1.00 46.41           C  
ATOM   1517  CD  GLU A 198      34.565  87.261 143.956  1.00 47.40           C  
ATOM   1518  OE1 GLU A 198      34.555  87.567 145.171  1.00 47.70           O  
ATOM   1519  OE2 GLU A 198      33.702  86.518 143.434  1.00 47.74           O  
ATOM   1520  N   LYS A 199      35.325  83.892 141.574  1.00 39.43           N  
ATOM   1521  CA  LYS A 199      34.541  82.743 141.999  1.00 38.58           C  
ATOM   1522  C   LYS A 199      35.451  81.646 142.530  1.00 37.13           C  
ATOM   1523  O   LYS A 199      35.164  81.033 143.559  1.00 34.94           O  
ATOM   1524  CB  LYS A 199      33.712  82.214 140.826  1.00 40.20           C  
ATOM   1525  CG  LYS A 199      32.893  80.980 141.145  1.00 43.48           C  
ATOM   1526  CD  LYS A 199      31.905  80.688 140.025  1.00 47.79           C  
ATOM   1527  CE  LYS A 199      31.071  79.446 140.325  1.00 49.61           C  
ATOM   1528  NZ  LYS A 199      30.036  79.211 139.278  1.00 51.39           N  
ATOM   1529  N   LYS A 200      36.547  81.402 141.818  1.00 34.56           N  
ATOM   1530  CA  LYS A 200      37.498  80.383 142.222  1.00 33.86           C  
ATOM   1531  C   LYS A 200      38.117  80.778 143.558  1.00 31.80           C  
ATOM   1532  O   LYS A 200      38.274  79.941 144.451  1.00 30.48           O  
ATOM   1533  CB  LYS A 200      38.597  80.220 141.169  1.00 33.77           C  
ATOM   1534  CG  LYS A 200      39.438  78.974 141.382  1.00 35.42           C  
ATOM   1535  CD  LYS A 200      38.562  77.744 141.277  1.00 35.45           C  
ATOM   1536  CE  LYS A 200      39.315  76.494 141.646  1.00 36.78           C  
ATOM   1537  NZ  LYS A 200      38.424  75.304 141.653  1.00 35.15           N  
ATOM   1538  N   ILE A 201      38.458  82.058 143.688  1.00 30.75           N  
ATOM   1539  CA  ILE A 201      39.050  82.570 144.915  1.00 30.79           C  
ATOM   1540  C   ILE A 201      38.058  82.527 146.072  1.00 30.30           C  
ATOM   1541  O   ILE A 201      38.440  82.309 147.224  1.00 30.86           O  
ATOM   1542  CB  ILE A 201      39.549  84.011 144.728  1.00 32.45           C  
ATOM   1543  CG1 ILE A 201      40.805  84.010 143.856  1.00 34.58           C  
ATOM   1544  CG2 ILE A 201      39.846  84.646 146.072  1.00 31.92           C  
ATOM   1545  CD1 ILE A 201      41.315  85.397 143.535  1.00 37.33           C  
ATOM   1546  N   SER A 202      36.784  82.743 145.772  1.00 29.13           N  
ATOM   1547  CA  SER A 202      35.767  82.702 146.811  1.00 28.03           C  
ATOM   1548  C   SER A 202      35.599  81.245 147.247  1.00 26.16           C  
ATOM   1549  O   SER A 202      35.302  80.965 148.404  1.00 26.81           O  
ATOM   1550  CB  SER A 202      34.439  83.262 146.286  1.00 29.20           C  
ATOM   1551  OG  SER A 202      33.455  83.251 147.309  1.00 34.06           O  
ATOM   1552  N   GLU A 203      35.800  80.320 146.318  1.00 24.13           N  
ATOM   1553  CA  GLU A 203      35.696  78.898 146.626  1.00 26.27           C  
ATOM   1554  C   GLU A 203      36.783  78.531 147.644  1.00 24.36           C  
ATOM   1555  O   GLU A 203      36.512  77.884 148.657  1.00 22.27           O  
ATOM   1556  CB  GLU A 203      35.895  78.061 145.363  1.00 29.00           C  
ATOM   1557  CG  GLU A 203      35.920  76.563 145.616  1.00 35.78           C  
ATOM   1558  CD  GLU A 203      36.310  75.769 144.378  1.00 39.87           C  
ATOM   1559  OE1 GLU A 203      37.525  75.621 144.114  1.00 42.00           O  
ATOM   1560  OE2 GLU A 203      35.394  75.307 143.663  1.00 42.63           O  
ATOM   1561  N   TRP A 204      38.015  78.944 147.359  1.00 22.17           N  
ATOM   1562  CA  TRP A 204      39.127  78.671 148.259  1.00 22.57           C  
ATOM   1563  C   TRP A 204      38.856  79.339 149.602  1.00 21.99           C  
ATOM   1564  O   TRP A 204      39.098  78.751 150.654  1.00 23.34           O  
ATOM   1565  CB  TRP A 204      40.444  79.194 147.675  1.00 22.03           C  
ATOM   1566  CG  TRP A 204      40.924  78.471 146.448  1.00 21.03           C  
ATOM   1567  CD1 TRP A 204      40.679  77.174 146.107  1.00 21.09           C  
ATOM   1568  CD2 TRP A 204      41.784  78.998 145.426  1.00 22.13           C  
ATOM   1569  NE1 TRP A 204      41.334  76.857 144.938  1.00 23.86           N  
ATOM   1570  CE2 TRP A 204      42.019  77.961 144.499  1.00 20.78           C  
ATOM   1571  CE3 TRP A 204      42.377  80.251 145.206  1.00 21.32           C  
ATOM   1572  CZ2 TRP A 204      42.822  78.134 143.369  1.00 23.26           C  
ATOM   1573  CZ3 TRP A 204      43.180  80.426 144.076  1.00 21.44           C  
ATOM   1574  CH2 TRP A 204      43.393  79.375 143.175  1.00 20.43           C  
ATOM   1575  N   GLY A 205      38.330  80.563 149.560  1.00 20.95           N  
ATOM   1576  CA  GLY A 205      38.028  81.276 150.786  1.00 22.06           C  
ATOM   1577  C   GLY A 205      37.067  80.512 151.688  1.00 21.72           C  
ATOM   1578  O   GLY A 205      37.267  80.438 152.899  1.00 23.84           O  
ATOM   1579  N   HIS A 206      36.025  79.936 151.103  1.00 22.30           N  
ATOM   1580  CA  HIS A 206      35.045  79.187 151.880  1.00 24.33           C  
ATOM   1581  C   HIS A 206      35.580  77.880 152.442  1.00 23.68           C  
ATOM   1582  O   HIS A 206      34.914  77.236 153.249  1.00 24.34           O  
ATOM   1583  CB  HIS A 206      33.793  78.922 151.047  1.00 27.83           C  
ATOM   1584  CG  HIS A 206      33.100  80.172 150.611  1.00 31.60           C  
ATOM   1585  ND1 HIS A 206      32.866  81.226 151.470  1.00 35.16           N  
ATOM   1586  CD2 HIS A 206      32.619  80.553 149.405  1.00 33.96           C  
ATOM   1587  CE1 HIS A 206      32.272  82.204 150.809  1.00 34.72           C  
ATOM   1588  NE2 HIS A 206      32.112  81.822 149.555  1.00 35.04           N  
ATOM   1589  N   GLU A 207      36.772  77.478 152.012  1.00 23.65           N  
ATOM   1590  CA  GLU A 207      37.387  76.256 152.529  1.00 22.50           C  
ATOM   1591  C   GLU A 207      38.075  76.577 153.864  1.00 21.09           C  
ATOM   1592  O   GLU A 207      38.322  75.686 154.676  1.00 20.31           O  
ATOM   1593  CB  GLU A 207      38.408  75.705 151.533  1.00 23.37           C  
ATOM   1594  CG  GLU A 207      37.802  75.208 150.232  1.00 25.90           C  
ATOM   1595  CD  GLU A 207      36.986  73.947 150.418  1.00 30.65           C  
ATOM   1596  OE1 GLU A 207      36.448  73.433 149.416  1.00 34.33           O  
ATOM   1597  OE2 GLU A 207      36.888  73.459 151.564  1.00 33.52           O  
ATOM   1598  N   HIS A 208      38.400  77.853 154.072  1.00 19.36           N  
ATOM   1599  CA  HIS A 208      39.020  78.298 155.322  1.00 19.59           C  
ATOM   1600  C   HIS A 208      37.911  78.604 156.332  1.00 19.67           C  
ATOM   1601  O   HIS A 208      36.888  79.196 155.982  1.00 19.90           O  
ATOM   1602  CB  HIS A 208      39.827  79.592 155.121  1.00 20.54           C  
ATOM   1603  CG  HIS A 208      40.959  79.477 154.142  1.00 21.11           C  
ATOM   1604  ND1 HIS A 208      40.774  79.111 152.826  1.00 21.70           N  
ATOM   1605  CD2 HIS A 208      42.281  79.741 154.277  1.00 19.87           C  
ATOM   1606  CE1 HIS A 208      41.933  79.155 152.191  1.00 21.81           C  
ATOM   1607  NE2 HIS A 208      42.863  79.534 153.049  1.00 22.04           N  
ATOM   1608  N   PRO A 209      38.088  78.197 157.596  1.00 19.82           N  
ATOM   1609  CA  PRO A 209      37.055  78.486 158.595  1.00 19.01           C  
ATOM   1610  C   PRO A 209      36.691  79.985 158.611  1.00 19.35           C  
ATOM   1611  O   PRO A 209      35.531  80.344 158.785  1.00 19.12           O  
ATOM   1612  CB  PRO A 209      37.703  78.017 159.894  1.00 18.85           C  
ATOM   1613  CG  PRO A 209      38.478  76.795 159.426  1.00 18.51           C  
ATOM   1614  CD  PRO A 209      39.119  77.292 158.143  1.00 21.01           C  
ATOM   1615  N   MET A 210      37.674  80.856 158.410  1.00 18.75           N  
ATOM   1616  CA  MET A 210      37.400  82.298 158.396  1.00 21.71           C  
ATOM   1617  C   MET A 210      36.526  82.743 157.201  1.00 22.78           C  
ATOM   1618  O   MET A 210      36.132  83.905 157.115  1.00 22.90           O  
ATOM   1619  CB  MET A 210      38.710  83.100 158.419  1.00 21.82           C  
ATOM   1620  CG  MET A 210      39.431  83.097 159.768  1.00 22.24           C  
ATOM   1621  SD  MET A 210      38.363  83.642 161.150  1.00 25.51           S  
ATOM   1622  CE  MET A 210      38.264  85.394 160.842  1.00 21.25           C  
ATOM   1623  N   GLN A 211      36.244  81.818 156.285  1.00 23.20           N  
ATOM   1624  CA  GLN A 211      35.383  82.065 155.116  1.00 24.16           C  
ATOM   1625  C   GLN A 211      35.848  83.095 154.086  1.00 24.33           C  
ATOM   1626  O   GLN A 211      35.040  83.637 153.325  1.00 25.64           O  
ATOM   1627  CB  GLN A 211      33.965  82.434 155.577  1.00 24.42           C  
ATOM   1628  CG  GLN A 211      33.257  81.325 156.329  1.00 25.27           C  
ATOM   1629  CD  GLN A 211      33.208  80.044 155.534  1.00 27.02           C  
ATOM   1630  OE1 GLN A 211      32.597  79.985 154.470  1.00 28.69           O  
ATOM   1631  NE2 GLN A 211      33.865  79.009 156.038  1.00 28.78           N  
ATOM   1632  N   ARG A 212      37.143  83.367 154.069  1.00 23.08           N  
ATOM   1633  CA  ARG A 212      37.726  84.300 153.114  1.00 22.72           C  
ATOM   1634  C   ARG A 212      39.194  83.938 153.047  1.00 21.87           C  
ATOM   1635  O   ARG A 212      39.684  83.175 153.885  1.00 19.43           O  
ATOM   1636  CB  ARG A 212      37.562  85.759 153.577  1.00 22.16           C  
ATOM   1637  CG  ARG A 212      38.343  86.139 154.834  1.00 21.06           C  
ATOM   1638  CD  ARG A 212      38.140  87.610 155.193  1.00 22.57           C  
ATOM   1639  NE  ARG A 212      38.691  87.944 156.508  1.00 22.85           N  
ATOM   1640  CZ  ARG A 212      39.981  88.131 156.766  1.00 22.92           C  
ATOM   1641  NH1 ARG A 212      40.372  88.422 158.001  1.00 22.23           N  
ATOM   1642  NH2 ARG A 212      40.881  88.043 155.793  1.00 21.22           N  
ATOM   1643  N   ILE A 213      39.891  84.436 152.034  1.00 20.74           N  
ATOM   1644  CA  ILE A 213      41.312  84.164 151.941  1.00 21.14           C  
ATOM   1645  C   ILE A 213      41.945  85.313 152.711  1.00 20.26           C  
ATOM   1646  O   ILE A 213      41.280  86.310 152.985  1.00 19.79           O  
ATOM   1647  CB  ILE A 213      41.815  84.132 150.473  1.00 21.58           C  
ATOM   1648  CG1 ILE A 213      41.531  85.460 149.771  1.00 24.22           C  
ATOM   1649  CG2 ILE A 213      41.154  82.980 149.728  1.00 21.12           C  
ATOM   1650  CD1 ILE A 213      42.191  85.553 148.385  1.00 24.17           C  
ATOM   1651  N   GLY A 214      43.210  85.169 153.092  1.00 20.85           N  
ATOM   1652  CA  GLY A 214      43.862  86.226 153.841  1.00 19.81           C  
ATOM   1653  C   GLY A 214      44.336  87.382 152.979  1.00 21.73           C  
ATOM   1654  O   GLY A 214      44.344  87.303 151.743  1.00 19.64           O  
ATOM   1655  N   LYS A 215      44.717  88.467 153.644  1.00 22.59           N  
ATOM   1656  CA  LYS A 215      45.231  89.660 152.982  1.00 24.47           C  
ATOM   1657  C   LYS A 215      46.721  89.720 153.310  1.00 25.21           C  
ATOM   1658  O   LYS A 215      47.141  89.301 154.387  1.00 26.53           O  
ATOM   1659  CB  LYS A 215      44.507  90.903 153.507  1.00 27.09           C  
ATOM   1660  CG  LYS A 215      42.995  90.791 153.362  1.00 32.10           C  
ATOM   1661  CD  LYS A 215      42.251  92.025 153.842  1.00 38.58           C  
ATOM   1662  CE  LYS A 215      42.293  93.154 152.824  1.00 41.55           C  
ATOM   1663  NZ  LYS A 215      41.453  94.322 153.261  1.00 45.95           N  
ATOM   1664  N   PRO A 216      47.540  90.234 152.380  1.00 25.12           N  
ATOM   1665  CA  PRO A 216      48.988  90.335 152.583  1.00 23.26           C  
ATOM   1666  C   PRO A 216      49.369  91.065 153.867  1.00 22.86           C  
ATOM   1667  O   PRO A 216      50.343  90.700 154.523  1.00 21.86           O  
ATOM   1668  CB  PRO A 216      49.458  91.080 151.334  1.00 24.05           C  
ATOM   1669  CG  PRO A 216      48.470  90.648 150.290  1.00 24.82           C  
ATOM   1670  CD  PRO A 216      47.159  90.738 151.046  1.00 24.07           C  
ATOM   1671  N   GLN A 217      48.611  92.102 154.223  1.00 21.41           N  
ATOM   1672  CA  GLN A 217      48.897  92.865 155.430  1.00 22.26           C  
ATOM   1673  C   GLN A 217      48.730  91.995 156.683  1.00 20.45           C  
ATOM   1674  O   GLN A 217      49.328  92.270 157.714  1.00 19.56           O  
ATOM   1675  CB  GLN A 217      47.976  94.092 155.526  1.00 26.89           C  
ATOM   1676  CG  GLN A 217      47.677  94.742 154.185  1.00 33.28           C  
ATOM   1677  CD  GLN A 217      46.566  94.020 153.436  1.00 36.11           C  
ATOM   1678  OE1 GLN A 217      45.387  94.134 153.786  1.00 42.36           O  
ATOM   1679  NE2 GLN A 217      46.935  93.267 152.416  1.00 35.42           N  
ATOM   1680  N   GLU A 218      47.925  90.944 156.586  1.00 19.65           N  
ATOM   1681  CA  GLU A 218      47.715  90.060 157.733  1.00 19.76           C  
ATOM   1682  C   GLU A 218      48.936  89.177 157.932  1.00 20.14           C  
ATOM   1683  O   GLU A 218      49.277  88.821 159.061  1.00 19.91           O  
ATOM   1684  CB  GLU A 218      46.434  89.232 157.541  1.00 17.33           C  
ATOM   1685  CG  GLU A 218      45.187  90.123 157.435  1.00 17.78           C  
ATOM   1686  CD  GLU A 218      43.888  89.333 157.285  1.00 18.61           C  
ATOM   1687  OE1 GLU A 218      43.728  88.618 156.278  1.00 20.29           O  
ATOM   1688  OE2 GLU A 218      43.026  89.426 158.186  1.00 20.45           O  
ATOM   1689  N   VAL A 219      49.610  88.834 156.840  1.00 19.61           N  
ATOM   1690  CA  VAL A 219      50.822  88.037 156.956  1.00 18.61           C  
ATOM   1691  C   VAL A 219      51.907  88.976 157.501  1.00 18.82           C  
ATOM   1692  O   VAL A 219      52.705  88.599 158.367  1.00 17.25           O  
ATOM   1693  CB  VAL A 219      51.251  87.448 155.583  1.00 20.02           C  
ATOM   1694  CG1 VAL A 219      52.660  86.847 155.670  1.00 17.88           C  
ATOM   1695  CG2 VAL A 219      50.262  86.369 155.158  1.00 17.25           C  
ATOM   1696  N   ALA A 220      51.914  90.213 157.004  1.00 18.89           N  
ATOM   1697  CA  ALA A 220      52.894  91.199 157.434  1.00 18.19           C  
ATOM   1698  C   ALA A 220      52.811  91.491 158.934  1.00 18.48           C  
ATOM   1699  O   ALA A 220      53.832  91.756 159.568  1.00 18.15           O  
ATOM   1700  CB  ALA A 220      52.733  92.487 156.629  1.00 18.65           C  
ATOM   1701  N   SER A 221      51.603  91.454 159.497  1.00 17.68           N  
ATOM   1702  CA  SER A 221      51.424  91.687 160.935  1.00 19.24           C  
ATOM   1703  C   SER A 221      52.155  90.616 161.756  1.00 18.37           C  
ATOM   1704  O   SER A 221      52.765  90.915 162.788  1.00 17.35           O  
ATOM   1705  CB  SER A 221      49.933  91.659 161.298  1.00 21.47           C  
ATOM   1706  OG  SER A 221      49.247  92.756 160.726  1.00 25.58           O  
ATOM   1707  N   ALA A 222      52.084  89.372 161.288  1.00 17.01           N  
ATOM   1708  CA  ALA A 222      52.729  88.246 161.964  1.00 18.09           C  
ATOM   1709  C   ALA A 222      54.248  88.359 161.855  1.00 17.92           C  
ATOM   1710  O   ALA A 222      54.971  88.059 162.808  1.00 19.40           O  
ATOM   1711  CB  ALA A 222      52.257  86.916 161.351  1.00 16.02           C  
ATOM   1712  N   VAL A 223      54.727  88.792 160.689  1.00 16.98           N  
ATOM   1713  CA  VAL A 223      56.155  88.955 160.465  1.00 14.62           C  
ATOM   1714  C   VAL A 223      56.719  90.038 161.389  1.00 16.36           C  
ATOM   1715  O   VAL A 223      57.741  89.842 162.036  1.00 16.73           O  
ATOM   1716  CB  VAL A 223      56.449  89.337 158.985  1.00 15.68           C  
ATOM   1717  CG1 VAL A 223      57.963  89.575 158.794  1.00 14.49           C  
ATOM   1718  CG2 VAL A 223      55.974  88.209 158.050  1.00 14.83           C  
ATOM   1719  N   ALA A 224      56.046  91.185 161.443  1.00 17.05           N  
ATOM   1720  CA  ALA A 224      56.474  92.291 162.294  1.00 17.50           C  
ATOM   1721  C   ALA A 224      56.510  91.858 163.765  1.00 17.11           C  
ATOM   1722  O   ALA A 224      57.457  92.168 164.490  1.00 18.30           O  
ATOM   1723  CB  ALA A 224      55.527  93.481 162.118  1.00 17.43           C  
ATOM   1724  N   PHE A 225      55.474  91.147 164.201  1.00 17.63           N  
ATOM   1725  CA  PHE A 225      55.409  90.655 165.579  1.00 16.42           C  
ATOM   1726  C   PHE A 225      56.620  89.779 165.903  1.00 16.73           C  
ATOM   1727  O   PHE A 225      57.337  90.025 166.881  1.00 17.45           O  
ATOM   1728  CB  PHE A 225      54.114  89.859 165.790  1.00 15.93           C  
ATOM   1729  CG  PHE A 225      54.087  89.070 167.072  1.00 18.06           C  
ATOM   1730  CD1 PHE A 225      54.208  87.678 167.052  1.00 17.28           C  
ATOM   1731  CD2 PHE A 225      53.944  89.716 168.301  1.00 18.24           C  
ATOM   1732  CE1 PHE A 225      54.186  86.943 168.239  1.00 20.16           C  
ATOM   1733  CE2 PHE A 225      53.921  88.993 169.492  1.00 19.66           C  
ATOM   1734  CZ  PHE A 225      54.041  87.606 169.461  1.00 19.37           C  
ATOM   1735  N   LEU A 226      56.865  88.766 165.072  1.00 17.43           N  
ATOM   1736  CA  LEU A 226      58.000  87.864 165.290  1.00 17.78           C  
ATOM   1737  C   LEU A 226      59.360  88.555 165.199  1.00 18.46           C  
ATOM   1738  O   LEU A 226      60.311  88.150 165.856  1.00 18.01           O  
ATOM   1739  CB  LEU A 226      57.964  86.708 164.287  1.00 17.66           C  
ATOM   1740  CG  LEU A 226      56.784  85.741 164.442  1.00 18.62           C  
ATOM   1741  CD1 LEU A 226      56.741  84.799 163.251  1.00 17.81           C  
ATOM   1742  CD2 LEU A 226      56.914  84.976 165.759  1.00 18.17           C  
ATOM   1743  N   ALA A 227      59.460  89.599 164.383  1.00 18.56           N  
ATOM   1744  CA  ALA A 227      60.732  90.294 164.255  1.00 18.31           C  
ATOM   1745  C   ALA A 227      60.975  91.238 165.434  1.00 20.48           C  
ATOM   1746  O   ALA A 227      62.121  91.566 165.742  1.00 19.48           O  
ATOM   1747  CB  ALA A 227      60.775  91.067 162.948  1.00 18.07           C  
ATOM   1748  N   SER A 228      59.896  91.651 166.103  1.00 20.93           N  
ATOM   1749  CA  SER A 228      59.987  92.576 167.231  1.00 23.83           C  
ATOM   1750  C   SER A 228      60.335  91.926 168.571  1.00 24.25           C  
ATOM   1751  O   SER A 228      60.349  90.701 168.708  1.00 22.34           O  
ATOM   1752  CB  SER A 228      58.665  93.336 167.396  1.00 23.82           C  
ATOM   1753  OG  SER A 228      57.696  92.512 168.024  1.00 26.75           O  
ATOM   1754  N   ARG A 229      60.592  92.770 169.565  1.00 25.78           N  
ATOM   1755  CA  ARG A 229      60.929  92.306 170.907  1.00 26.50           C  
ATOM   1756  C   ARG A 229      59.703  91.751 171.626  1.00 25.15           C  
ATOM   1757  O   ARG A 229      59.817  91.161 172.698  1.00 26.92           O  
ATOM   1758  CB  ARG A 229      61.560  93.440 171.720  1.00 29.99           C  
ATOM   1759  CG  ARG A 229      62.928  93.836 171.201  1.00 37.19           C  
ATOM   1760  CD  ARG A 229      63.574  94.904 172.064  1.00 42.89           C  
ATOM   1761  NE  ARG A 229      63.740  94.449 173.441  1.00 49.08           N  
ATOM   1762  CZ  ARG A 229      64.529  95.037 174.336  1.00 50.99           C  
ATOM   1763  NH1 ARG A 229      64.613  94.551 175.569  1.00 50.46           N  
ATOM   1764  NH2 ARG A 229      65.241  96.103 173.994  1.00 52.43           N  
ATOM   1765  N   GLU A 230      58.529  91.943 171.043  1.00 23.91           N  
ATOM   1766  CA  GLU A 230      57.310  91.397 171.627  1.00 24.88           C  
ATOM   1767  C   GLU A 230      57.377  89.863 171.532  1.00 23.74           C  
ATOM   1768  O   GLU A 230      56.549  89.160 172.107  1.00 25.74           O  
ATOM   1769  CB  GLU A 230      56.076  91.866 170.849  1.00 26.22           C  
ATOM   1770  CG  GLU A 230      55.736  93.340 170.978  1.00 31.79           C  
ATOM   1771  CD  GLU A 230      55.384  93.728 172.394  1.00 33.57           C  
ATOM   1772  OE1 GLU A 230      54.488  93.087 172.993  1.00 34.75           O  
ATOM   1773  OE2 GLU A 230      56.007  94.675 172.909  1.00 37.52           O  
ATOM   1774  N   ALA A 231      58.361  89.356 170.797  1.00 20.59           N  
ATOM   1775  CA  ALA A 231      58.513  87.913 170.598  1.00 19.04           C  
ATOM   1776  C   ALA A 231      59.875  87.442 171.095  1.00 17.55           C  
ATOM   1777  O   ALA A 231      60.398  86.432 170.624  1.00 13.38           O  
ATOM   1778  CB  ALA A 231      58.356  87.591 169.102  1.00 16.53           C  
ATOM   1779  N   SER A 232      60.428  88.172 172.064  1.00 17.01           N  
ATOM   1780  CA  SER A 232      61.747  87.885 172.618  1.00 17.27           C  
ATOM   1781  C   SER A 232      61.991  86.476 173.148  1.00 18.32           C  
ATOM   1782  O   SER A 232      63.140  86.045 173.237  1.00 17.51           O  
ATOM   1783  CB  SER A 232      62.090  88.907 173.710  1.00 15.81           C  
ATOM   1784  OG  SER A 232      61.042  89.000 174.645  1.00 18.14           O  
ATOM   1785  N   PHE A 233      60.931  85.760 173.502  1.00 18.77           N  
ATOM   1786  CA  PHE A 233      61.112  84.399 173.999  1.00 19.17           C  
ATOM   1787  C   PHE A 233      60.533  83.394 172.999  1.00 18.90           C  
ATOM   1788  O   PHE A 233      60.307  82.235 173.327  1.00 18.68           O  
ATOM   1789  CB  PHE A 233      60.448  84.230 175.379  1.00 17.06           C  
ATOM   1790  CG  PHE A 233      60.945  83.019 176.144  1.00 17.15           C  
ATOM   1791  CD1 PHE A 233      60.083  81.980 176.479  1.00 16.27           C  
ATOM   1792  CD2 PHE A 233      62.283  82.920 176.511  1.00 18.23           C  
ATOM   1793  CE1 PHE A 233      60.548  80.850 177.171  1.00 17.76           C  
ATOM   1794  CE2 PHE A 233      62.759  81.798 177.203  1.00 21.17           C  
ATOM   1795  CZ  PHE A 233      61.885  80.762 177.532  1.00 17.73           C  
ATOM   1796  N   ILE A 234      60.302  83.856 171.773  1.00 19.30           N  
ATOM   1797  CA  ILE A 234      59.755  83.013 170.710  1.00 17.37           C  
ATOM   1798  C   ILE A 234      60.825  82.764 169.655  1.00 17.20           C  
ATOM   1799  O   ILE A 234      61.345  83.709 169.049  1.00 16.52           O  
ATOM   1800  CB  ILE A 234      58.550  83.689 170.014  1.00 17.01           C  
ATOM   1801  CG1 ILE A 234      57.466  84.009 171.047  1.00 14.09           C  
ATOM   1802  CG2 ILE A 234      58.007  82.780 168.894  1.00 16.89           C  
ATOM   1803  CD1 ILE A 234      56.262  84.737 170.490  1.00 13.15           C  
ATOM   1804  N   THR A 235      61.169  81.499 169.452  1.00 16.28           N  
ATOM   1805  CA  THR A 235      62.167  81.144 168.452  1.00 17.21           C  
ATOM   1806  C   THR A 235      62.005  79.679 168.026  1.00 18.14           C  
ATOM   1807  O   THR A 235      61.588  78.828 168.831  1.00 17.14           O  
ATOM   1808  CB  THR A 235      63.612  81.385 168.975  1.00 16.93           C  
ATOM   1809  OG1 THR A 235      64.517  81.397 167.867  1.00 17.16           O  
ATOM   1810  CG2 THR A 235      64.052  80.275 169.954  1.00 15.64           C  
ATOM   1811  N   GLY A 236      62.307  79.414 166.754  1.00 17.15           N  
ATOM   1812  CA  GLY A 236      62.213  78.075 166.199  1.00 16.29           C  
ATOM   1813  C   GLY A 236      60.813  77.601 165.816  1.00 17.20           C  
ATOM   1814  O   GLY A 236      60.658  76.454 165.399  1.00 14.38           O  
ATOM   1815  N   THR A 237      59.804  78.468 165.917  1.00 15.74           N  
ATOM   1816  CA  THR A 237      58.427  78.064 165.606  1.00 16.71           C  
ATOM   1817  C   THR A 237      57.871  78.612 164.287  1.00 17.84           C  
ATOM   1818  O   THR A 237      58.524  79.424 163.625  1.00 15.71           O  
ATOM   1819  CB  THR A 237      57.463  78.510 166.760  1.00 16.80           C  
ATOM   1820  OG1 THR A 237      56.252  77.741 166.710  1.00 17.21           O  
ATOM   1821  CG2 THR A 237      57.091  79.997 166.623  1.00 13.59           C  
ATOM   1822  N   CYS A 238      56.693  78.123 163.880  1.00 17.89           N  
ATOM   1823  CA  CYS A 238      56.019  78.671 162.698  1.00 17.85           C  
ATOM   1824  C   CYS A 238      54.688  79.200 163.193  1.00 18.31           C  
ATOM   1825  O   CYS A 238      53.910  78.464 163.808  1.00 17.49           O  
ATOM   1826  CB  CYS A 238      55.690  77.669 161.567  1.00 20.19           C  
ATOM   1827  SG  CYS A 238      55.457  78.649 160.010  1.00 23.85           S  
ATOM   1828  N   LEU A 239      54.431  80.475 162.932  1.00 16.31           N  
ATOM   1829  CA  LEU A 239      53.172  81.073 163.321  1.00 15.01           C  
ATOM   1830  C   LEU A 239      52.233  80.881 162.124  1.00 15.95           C  
ATOM   1831  O   LEU A 239      52.482  81.418 161.036  1.00 15.86           O  
ATOM   1832  CB  LEU A 239      53.386  82.557 163.655  1.00 14.57           C  
ATOM   1833  CG  LEU A 239      52.146  83.402 163.966  1.00 16.56           C  
ATOM   1834  CD1 LEU A 239      51.214  82.675 164.956  1.00 15.95           C  
ATOM   1835  CD2 LEU A 239      52.591  84.746 164.513  1.00 15.85           C  
ATOM   1836  N   TYR A 240      51.183  80.075 162.299  1.00 12.99           N  
ATOM   1837  CA  TYR A 240      50.242  79.841 161.207  1.00 15.66           C  
ATOM   1838  C   TYR A 240      49.257  80.992 161.037  1.00 16.62           C  
ATOM   1839  O   TYR A 240      48.596  81.412 161.989  1.00 17.31           O  
ATOM   1840  CB  TYR A 240      49.490  78.515 161.416  1.00 15.87           C  
ATOM   1841  CG  TYR A 240      50.293  77.308 160.983  1.00 14.63           C  
ATOM   1842  CD1 TYR A 240      49.933  76.581 159.846  1.00 15.79           C  
ATOM   1843  CD2 TYR A 240      51.462  76.942 161.658  1.00 14.72           C  
ATOM   1844  CE1 TYR A 240      50.721  75.522 159.384  1.00 19.19           C  
ATOM   1845  CE2 TYR A 240      52.263  75.883 161.207  1.00 16.93           C  
ATOM   1846  CZ  TYR A 240      51.887  75.180 160.066  1.00 20.64           C  
ATOM   1847  OH  TYR A 240      52.677  74.153 159.587  1.00 22.19           O  
ATOM   1848  N   VAL A 241      49.186  81.517 159.817  1.00 16.22           N  
ATOM   1849  CA  VAL A 241      48.271  82.612 159.489  1.00 17.15           C  
ATOM   1850  C   VAL A 241      47.459  81.982 158.385  1.00 17.14           C  
ATOM   1851  O   VAL A 241      47.616  82.310 157.209  1.00 15.84           O  
ATOM   1852  CB  VAL A 241      49.019  83.854 158.944  1.00 16.68           C  
ATOM   1853  CG1 VAL A 241      48.015  84.968 158.632  1.00 17.59           C  
ATOM   1854  CG2 VAL A 241      50.046  84.341 159.973  1.00 14.52           C  
ATOM   1855  N   ASP A 242      46.585  81.065 158.791  1.00 17.45           N  
ATOM   1856  CA  ASP A 242      45.799  80.286 157.847  1.00 16.55           C  
ATOM   1857  C   ASP A 242      44.279  80.336 157.995  1.00 15.12           C  
ATOM   1858  O   ASP A 242      43.581  79.512 157.425  1.00 18.18           O  
ATOM   1859  CB  ASP A 242      46.276  78.828 157.920  1.00 17.18           C  
ATOM   1860  CG  ASP A 242      45.933  78.152 159.262  1.00 16.15           C  
ATOM   1861  OD1 ASP A 242      46.243  76.957 159.404  1.00 15.33           O  
ATOM   1862  OD2 ASP A 242      45.358  78.804 160.164  1.00 15.76           O  
ATOM   1863  N   GLY A 243      43.774  81.305 158.749  1.00 16.53           N  
ATOM   1864  CA  GLY A 243      42.343  81.419 158.940  1.00 17.24           C  
ATOM   1865  C   GLY A 243      41.692  80.137 159.442  1.00 17.53           C  
ATOM   1866  O   GLY A 243      40.485  79.938 159.252  1.00 16.84           O  
ATOM   1867  N   GLY A 244      42.495  79.270 160.066  1.00 14.88           N  
ATOM   1868  CA  GLY A 244      42.000  78.013 160.595  1.00 14.36           C  
ATOM   1869  C   GLY A 244      42.107  76.833 159.639  1.00 16.78           C  
ATOM   1870  O   GLY A 244      41.727  75.709 159.981  1.00 15.02           O  
ATOM   1871  N   LEU A 245      42.636  77.066 158.442  1.00 16.23           N  
ATOM   1872  CA  LEU A 245      42.719  75.989 157.467  1.00 16.41           C  
ATOM   1873  C   LEU A 245      43.366  74.700 157.968  1.00 15.81           C  
ATOM   1874  O   LEU A 245      42.805  73.625 157.780  1.00 13.79           O  
ATOM   1875  CB  LEU A 245      43.465  76.441 156.203  1.00 16.06           C  
ATOM   1876  CG  LEU A 245      43.251  75.474 155.029  1.00 16.83           C  
ATOM   1877  CD1 LEU A 245      41.772  75.527 154.619  1.00 14.06           C  
ATOM   1878  CD2 LEU A 245      44.165  75.829 153.840  1.00 16.08           C  
ATOM   1879  N   SER A 246      44.528  74.799 158.611  1.00 14.86           N  
ATOM   1880  CA  SER A 246      45.232  73.590 159.049  1.00 18.35           C  
ATOM   1881  C   SER A 246      44.595  72.754 160.162  1.00 19.07           C  
ATOM   1882  O   SER A 246      45.081  71.668 160.456  1.00 20.11           O  
ATOM   1883  CB  SER A 246      46.680  73.922 159.438  1.00 17.23           C  
ATOM   1884  OG  SER A 246      46.727  74.696 160.625  1.00 19.73           O  
ATOM   1885  N   ILE A 247      43.519  73.229 160.779  1.00 19.26           N  
ATOM   1886  CA  ILE A 247      42.878  72.438 161.835  1.00 22.55           C  
ATOM   1887  C   ILE A 247      41.484  71.930 161.448  1.00 23.67           C  
ATOM   1888  O   ILE A 247      40.763  71.357 162.267  1.00 22.19           O  
ATOM   1889  CB  ILE A 247      42.800  73.238 163.158  1.00 21.66           C  
ATOM   1890  CG1 ILE A 247      42.124  74.589 162.931  1.00 24.90           C  
ATOM   1891  CG2 ILE A 247      44.212  73.457 163.709  1.00 21.22           C  
ATOM   1892  CD1 ILE A 247      40.619  74.528 162.859  1.00 26.31           C  
ATOM   1893  N   ARG A 248      41.121  72.130 160.186  1.00 24.99           N  
ATOM   1894  CA  ARG A 248      39.821  71.700 159.701  1.00 26.12           C  
ATOM   1895  C   ARG A 248      39.799  70.407 158.883  1.00 25.30           C  
ATOM   1896  O   ARG A 248      40.459  70.291 157.845  1.00 26.03           O  
ATOM   1897  CB  ARG A 248      39.176  72.820 158.876  1.00 27.96           C  
ATOM   1898  CG  ARG A 248      38.069  72.317 157.954  1.00 31.12           C  
ATOM   1899  CD  ARG A 248      37.312  73.432 157.260  1.00 33.50           C  
ATOM   1900  NE  ARG A 248      36.356  72.890 156.299  1.00 34.31           N  
ATOM   1901  CZ  ARG A 248      36.632  72.634 155.022  1.00 36.84           C  
ATOM   1902  NH1 ARG A 248      37.846  72.882 154.540  1.00 36.68           N  
ATOM   1903  NH2 ARG A 248      35.696  72.112 154.232  1.00 35.23           N  
ATOM   1904  N   ALA A 249      39.033  69.432 159.357  1.00 23.15           N  
ATOM   1905  CA  ALA A 249      38.867  68.182 158.626  1.00 24.99           C  
ATOM   1906  C   ALA A 249      37.681  68.428 157.681  1.00 26.31           C  
ATOM   1907  O   ALA A 249      36.651  68.967 158.093  1.00 27.23           O  
ATOM   1908  CB  ALA A 249      38.551  67.044 159.585  1.00 22.14           C  
ATOM   1909  N   PRO A 250      37.807  68.040 156.401  1.00 28.12           N  
ATOM   1910  CA  PRO A 250      36.723  68.237 155.428  1.00 27.87           C  
ATOM   1911  C   PRO A 250      35.607  67.183 155.499  1.00 28.52           C  
ATOM   1912  O   PRO A 250      35.113  66.724 154.471  1.00 30.14           O  
ATOM   1913  CB  PRO A 250      37.465  68.207 154.099  1.00 26.89           C  
ATOM   1914  CG  PRO A 250      38.519  67.172 154.357  1.00 30.01           C  
ATOM   1915  CD  PRO A 250      39.025  67.530 155.742  1.00 28.41           C  
ATOM   1916  N   ILE A 251      35.212  66.814 156.713  1.00 29.39           N  
ATOM   1917  CA  ILE A 251      34.171  65.806 156.941  1.00 29.01           C  
ATOM   1918  C   ILE A 251      32.970  66.457 157.639  1.00 29.71           C  
ATOM   1919  O   ILE A 251      33.101  67.002 158.737  1.00 28.59           O  
ATOM   1920  CB  ILE A 251      34.718  64.659 157.836  1.00 29.99           C  
ATOM   1921  CG1 ILE A 251      35.978  64.057 157.198  1.00 27.77           C  
ATOM   1922  CG2 ILE A 251      33.650  63.590 158.049  1.00 28.79           C  
ATOM   1923  CD1 ILE A 251      35.751  63.441 155.826  1.00 28.77           C  
ATOM   1924  N   SER A 252      31.803  66.401 156.997  1.00 29.13           N  
ATOM   1925  CA  SER A 252      30.593  67.004 157.554  1.00 29.71           C  
ATOM   1926  C   SER A 252      30.068  66.271 158.785  1.00 29.20           C  
ATOM   1927  O   SER A 252      30.332  65.082 158.974  1.00 28.75           O  
ATOM   1928  CB  SER A 252      29.482  67.042 156.497  1.00 29.00           C  
ATOM   1929  OG  SER A 252      29.053  65.731 156.164  1.00 30.54           O  
ATOM   1930  N   THR A 253      29.344  67.004 159.627  1.00 31.16           N  
ATOM   1931  CA  THR A 253      28.722  66.453 160.833  1.00 33.40           C  
ATOM   1932  C   THR A 253      27.305  67.014 160.848  1.00 36.39           C  
ATOM   1933  O   THR A 253      27.041  68.042 160.229  1.00 33.46           O  
ATOM   1934  CB  THR A 253      29.443  66.890 162.148  1.00 33.49           C  
ATOM   1935  OG1 THR A 253      29.577  68.321 162.189  1.00 30.92           O  
ATOM   1936  CG2 THR A 253      30.806  66.222 162.257  1.00 31.34           C  
ATOM   1937  N   PRO A 254      26.379  66.355 161.561  1.00 40.42           N  
ATOM   1938  CA  PRO A 254      25.006  66.867 161.594  1.00 42.94           C  
ATOM   1939  C   PRO A 254      24.900  68.282 162.155  1.00 45.75           C  
ATOM   1940  O   PRO A 254      25.694  68.691 163.001  1.00 45.49           O  
ATOM   1941  CB  PRO A 254      24.269  65.832 162.446  1.00 42.51           C  
ATOM   1942  CG  PRO A 254      25.333  65.334 163.368  1.00 43.91           C  
ATOM   1943  CD  PRO A 254      26.532  65.192 162.453  1.00 41.80           C  
ATOM   1944  N   GLU A 255      23.921  69.028 161.657  1.00 49.42           N  
ATOM   1945  CA  GLU A 255      23.687  70.396 162.098  1.00 53.66           C  
ATOM   1946  C   GLU A 255      22.252  70.798 161.775  1.00 55.07           C  
ATOM   1947  O   GLU A 255      21.591  70.028 161.043  1.00 56.15           O  
ATOM   1948  CB  GLU A 255      24.675  71.345 161.408  1.00 55.68           C  
ATOM   1949  CG  GLU A 255      24.431  72.835 161.650  1.00 59.21           C  
ATOM   1950  CD  GLU A 255      24.391  73.223 163.124  1.00 60.78           C  
ATOM   1951  OE1 GLU A 255      24.394  74.440 163.410  1.00 62.20           O  
ATOM   1952  OE2 GLU A 255      24.347  72.327 163.997  1.00 61.98           O  
TER    1953      GLU A 255                                                      
END
MOLECULE T0433.pdb
ATOM     20  N   MET     1      66.006 100.902 164.016  1.00 30.54           N  
ATOM     21  CA  MET     1      66.034  99.529 163.534  1.00 31.40           C  
ATOM     22  C   MET     1      66.182  99.479 162.021  1.00 29.91           C  
ATOM     23  O   MET     1      65.465 100.179 161.296  1.00 29.44           O  
ATOM     24  CB  MET     1      64.765  98.773 163.923  1.00 31.12           C  
ATOM     25  CG  MET     1      64.859  97.281 163.566  1.00 33.22           C  
ATOM     26  SD  MET     1      63.341  96.179 164.096  0.60 38.15          SE  
ATOM     27  CE  MET     1      63.492  96.512 165.999  1.00 34.50           C  
ATOM     28  N   LYS     2      67.106  98.634 161.558  1.00 29.48           N  
ATOM     29  CA  LYS     2      67.339  98.409 160.121  1.00 28.09           C  
ATOM     30  C   LYS     2      66.846  97.026 159.675  1.00 27.23           C  
ATOM     31  O   LYS     2      67.326  96.009 160.189  1.00 27.45           O  
ATOM     32  CB  LYS     2      68.816  98.523 159.822  1.00 27.77           C  
ATOM     33  CG  LYS     2      69.356  99.917 159.951  1.00 28.85           C  
ATOM     34  CD  LYS     2      70.835  99.967 159.595  1.00 29.12           C  
ATOM     35  CE  LYS     2      71.363 101.430 159.579  1.00 27.44           C  
ATOM     36  NZ  LYS     2      70.977 102.131 158.307  1.00 28.69           N  
ATOM     37  N   ILE     3      65.910  96.999 158.723  1.00 25.89           N  
ATOM     38  CA  ILE     3      65.296  95.750 158.256  1.00 25.76           C  
ATOM     39  C   ILE     3      65.605  95.566 156.788  1.00 25.88           C  
ATOM     40  O   ILE     3      65.255  96.405 156.002  1.00 27.10           O  
ATOM     41  CB  ILE     3      63.753  95.745 158.441  1.00 25.79           C  
ATOM     42  CG1 ILE     3      63.394  95.872 159.921  1.00 25.30           C  
ATOM     43  CG2 ILE     3      63.126  94.472 157.901  1.00 24.82           C  
ATOM     44  CD1 ILE     3      61.903  95.840 160.165  1.00 25.00           C  
ATOM     45  N   LEU     4      66.306  94.498 156.431  1.00 25.66           N  
ATOM     46  CA  LEU     4      66.484  94.169 155.036  1.00 26.82           C  
ATOM     47  C   LEU     4      65.292  93.313 154.574  1.00 26.72           C  
ATOM     48  O   LEU     4      65.126  92.175 155.019  1.00 27.97           O  
ATOM     49  CB  LEU     4      67.817  93.439 154.807  1.00 26.60           C  
ATOM     50  CG  LEU     4      68.076  92.994 153.362  1.00 25.81           C  
ATOM     51  CD1 LEU     4      68.199  94.183 152.401  1.00 23.22           C  
ATOM     52  CD2 LEU     4      69.319  92.113 153.294  1.00 27.38           C  
ATOM     53  N   LEU     5      64.458  93.886 153.709  1.00 27.66           N  
ATOM     54  CA  LEU     5      63.302  93.194 153.117  1.00 27.99           C  
ATOM     55  C   LEU     5      63.556  92.704 151.672  1.00 28.42           C  
ATOM     56  O   LEU     5      63.510  93.478 150.710  1.00 28.87           O  
ATOM     57  CB  LEU     5      62.084  94.121 153.146  1.00 28.06           C  
ATOM     58  CG  LEU     5      60.723  93.525 152.740  1.00 27.67           C  
ATOM     59  CD1 LEU     5      60.434  92.306 153.565  1.00 25.96           C  
ATOM     60  CD2 LEU     5      59.625  94.532 152.942  1.00 27.45           C  
ATOM     61  N   ILE     6      63.793  91.412 151.521  1.00 29.13           N  
ATOM     62  CA  ILE     6      64.044  90.827 150.202  1.00 29.17           C  
ATOM     63  C   ILE     6      62.724  90.345 149.605  1.00 29.51           C  
ATOM     64  O   ILE     6      62.002  89.601 150.241  1.00 29.55           O  
ATOM     65  CB  ILE     6      65.099  89.709 150.282  1.00 29.51           C  
ATOM     66  CG1 ILE     6      66.315  90.194 151.102  1.00 29.55           C  
ATOM     67  CG2 ILE     6      65.525  89.244 148.891  1.00 29.32           C  
ATOM     68  CD1 ILE     6      66.874  89.125 151.998  1.00 29.14           C  
ATOM     69  N   GLY     7      62.399  90.856 148.415  1.00 30.23           N  
ATOM     70  CA  GLY     7      61.140  90.591 147.744  1.00 31.22           C  
ATOM     71  C   GLY     7      60.100  91.656 148.035  1.00 32.04           C  
ATOM     72  O   GLY     7      58.896  91.406 147.908  1.00 32.57           O  
ATOM     73  N   ALA     8      60.569  92.846 148.411  1.00 32.09           N  
ATOM     74  CA  ALA     8      59.720  93.956 148.854  1.00 31.87           C  
ATOM     75  C   ALA     8      58.684  94.452 147.836  1.00 32.25           C  
ATOM     76  O   ALA     8      57.696  95.101 148.208  1.00 31.65           O  
ATOM     77  CB  ALA     8      60.595  95.095 149.276  1.00 31.67           C  
ATOM     78  N   SER     9      58.926  94.173 146.558  1.00 32.33           N  
ATOM     79  CA  SER     9      58.029  94.616 145.519  1.00 33.35           C  
ATOM     80  C   SER     9      57.001  93.558 145.126  1.00 33.22           C  
ATOM     81  O   SER     9      56.157  93.825 144.301  1.00 33.62           O  
ATOM     82  CB  SER     9      58.813  95.157 144.311  1.00 34.03           C  
ATOM     83  OG  SER     9      59.392  94.098 143.571  1.00 36.88           O  
ATOM     84  N   GLY    10      57.043  92.378 145.748  1.00 33.16           N  
ATOM     85  CA  GLY    10      56.023  91.363 145.524  1.00 33.46           C  
ATOM     86  C   GLY    10      54.745  91.676 146.287  1.00 33.31           C  
ATOM     87  O   GLY    10      54.741  92.545 147.160  1.00 32.91           O  
ATOM     88  N   THR    11      53.663  90.967 145.961  1.00 33.48           N  
ATOM     89  CA  THR    11      52.366  91.118 146.662  1.00 33.27           C  
ATOM     90  C   THR    11      52.492  91.023 148.180  1.00 32.36           C  
ATOM     91  O   THR    11      51.963  91.860 148.902  1.00 32.98           O  
ATOM     92  CB  THR    11      51.328  90.066 146.159  1.00 34.07           C  
ATOM     93  OG1 THR    11      51.277  90.113 144.734  1.00 34.95           O  
ATOM     94  CG2 THR    11      49.928  90.350 146.725  1.00 34.27           C  
ATOM     95  N   LEU    12      53.212  90.008 148.654  1.00 31.60           N  
ATOM     96  CA  LEU    12      53.394  89.769 150.076  1.00 30.72           C  
ATOM     97  C   LEU    12      54.449  90.702 150.655  1.00 30.82           C  
ATOM     98  O   LEU    12      54.247  91.293 151.726  1.00 30.91           O  
ATOM     99  CB  LEU    12      53.771  88.298 150.347  1.00 31.02           C  
ATOM    100  CG  LEU    12      54.141  87.988 151.805  1.00 30.39           C  
ATOM    101  CD1 LEU    12      52.931  88.264 152.698  1.00 29.48           C  
ATOM    102  CD2 LEU    12      54.697  86.563 152.015  1.00 30.19           C  
ATOM    103  N   GLY    13      55.572  90.834 149.952  1.00 30.22           N  
ATOM    104  CA  GLY    13      56.627  91.740 150.392  1.00 30.16           C  
ATOM    105  C   GLY    13      56.081  93.139 150.577  1.00 29.55           C  
ATOM    106  O   GLY    13      56.441  93.836 151.523  1.00 29.43           O  
ATOM    107  N   SER    14      55.166  93.524 149.695  1.00 29.09           N  
ATOM    108  CA  SER    14      54.622  94.875 149.693  1.00 29.34           C  
ATOM    109  C   SER    14      53.779  95.149 150.937  1.00 28.73           C  
ATOM    110  O   SER    14      53.922  96.194 151.573  1.00 29.08           O  
ATOM    111  CB  SER    14      53.818  95.119 148.400  1.00 30.09           C  
ATOM    112  OG  SER    14      53.418  96.478 148.322  1.00 33.26           O  
ATOM    113  N   ALA    15      52.906  94.203 151.285  1.00 28.08           N  
ATOM    114  CA  ALA    15      52.120  94.297 152.515  1.00 26.86           C  
ATOM    115  C   ALA    15      53.006  94.274 153.751  1.00 26.45           C  
ATOM    116  O   ALA    15      52.717  94.945 154.719  1.00 26.48           O  
ATOM    117  CB  ALA    15      51.114  93.188 152.580  1.00 26.72           C  
ATOM    118  N   VAL    16      54.069  93.478 153.727  1.00 26.38           N  
ATOM    119  CA  VAL    16      55.050  93.487 154.816  1.00 26.86           C  
ATOM    120  C   VAL    16      55.751  94.850 154.960  1.00 27.51           C  
ATOM    121  O   VAL    16      55.927  95.342 156.073  1.00 28.52           O  
ATOM    122  CB  VAL    16      56.087  92.335 154.646  1.00 26.98           C  
ATOM    123  CG1 VAL    16      57.167  92.382 155.752  1.00 24.98           C  
ATOM    124  CG2 VAL    16      55.353  90.983 154.654  1.00 25.96           C  
ATOM    125  N   LYS    17      56.156  95.452 153.845  1.00 27.51           N  
ATOM    126  CA  LYS    17      56.826  96.750 153.881  1.00 28.86           C  
ATOM    127  C   LYS    17      55.901  97.808 154.506  1.00 28.85           C  
ATOM    128  O   LYS    17      56.310  98.571 155.375  1.00 28.00           O  
ATOM    129  CB  LYS    17      57.250  97.176 152.473  1.00 28.12           C  
ATOM    130  CG  LYS    17      58.136  98.424 152.420  1.00 28.98           C  
ATOM    131  CD  LYS    17      58.199  99.019 151.016  1.00 30.35           C  
ATOM    132  CE  LYS    17      59.040 100.287 151.006  1.00 36.34           C  
ATOM    133  NZ  LYS    17      58.269 101.477 150.476  1.00 39.61           N  
ATOM    134  N   GLU    18      54.647  97.814 154.079  1.00 29.40           N  
ATOM    135  CA  GLU    18      53.669  98.723 154.635  1.00 31.13           C  
ATOM    136  C   GLU    18      53.607  98.684 156.180  1.00 30.02           C  
ATOM    137  O   GLU    18      53.508  99.723 156.820  1.00 30.06           O  
ATOM    138  CB  GLU    18      52.296  98.450 154.025  1.00 31.24           C  
ATOM    139  CG  GLU    18      51.297  99.584 154.201  1.00 33.76           C  
ATOM    140  CD  GLU    18      50.037  99.390 153.365  1.00 36.05           C  
ATOM    141  OE1 GLU    18      50.053  98.555 152.420  1.00 42.91           O  
ATOM    142  OE2 GLU    18      49.021 100.082 153.641  1.00 43.15           O  
ATOM    143  N   ARG    19      53.685  97.509 156.785  1.00 29.53           N  
ATOM    144  CA  ARG    19      53.645  97.464 158.252  1.00 29.61           C  
ATOM    145  C   ARG    19      54.988  97.830 158.865  1.00 29.47           C  
ATOM    146  O   ARG    19      55.037  98.579 159.803  1.00 28.55           O  
ATOM    147  CB  ARG    19      53.228  96.100 158.771  1.00 28.97           C  
ATOM    148  CG  ARG    19      51.860  95.659 158.312  1.00 29.53           C  
ATOM    149  CD  ARG    19      51.364  94.561 159.240  1.00 31.28           C  
ATOM    150  NE  ARG    19      51.271  95.028 160.621  1.00 31.95           N  
ATOM    151  CZ  ARG    19      50.165  95.513 161.180  1.00 32.20           C  
ATOM    152  NH1 ARG    19      49.029  95.619 160.487  1.00 30.24           N  
ATOM    153  NH2 ARG    19      50.205  95.917 162.436  1.00 31.68           N  
ATOM    154  N   LEU    20      56.069  97.282 158.326  1.00 30.11           N  
ATOM    155  CA  LEU    20      57.398  97.467 158.932  1.00 30.83           C  
ATOM    156  C   LEU    20      57.906  98.916 158.888  1.00 30.81           C  
ATOM    157  O   LEU    20      58.534  99.418 159.824  1.00 30.95           O  
ATOM    158  CB  LEU    20      58.395  96.490 158.301  1.00 30.17           C  
ATOM    159  CG  LEU    20      58.128  95.001 158.562  1.00 32.14           C  
ATOM    160  CD1 LEU    20      59.241  94.109 157.934  1.00 32.94           C  
ATOM    161  CD2 LEU    20      57.908  94.629 160.038  1.00 30.05           C  
ATOM    162  N   GLU    21      57.599  99.558 157.771  1.00 31.32           N  
ATOM    163  CA  GLU    21      57.940 100.918 157.400  1.00 31.24           C  
ATOM    164  C   GLU    21      57.522 101.953 158.455  1.00 31.01           C  
ATOM    165  O   GLU    21      58.148 103.001 158.582  1.00 31.01           O  
ATOM    166  CB  GLU    21      57.152 101.149 156.123  1.00 31.39           C  
ATOM    167  CG  GLU    21      57.388 102.338 155.355  1.00 35.19           C  
ATOM    168  CD  GLU    21      56.609 102.275 154.070  1.00 38.08           C  
ATOM    169  OE1 GLU    21      57.232 102.044 153.021  1.00 40.66           O  
ATOM    170  OE2 GLU    21      55.372 102.421 154.110  1.00 40.60           O  
ATOM    171  N   LYS    22      56.455 101.658 159.197  1.00 31.04           N  
ATOM    172  CA  LYS    22      55.924 102.564 160.221  1.00 30.94           C  
ATOM    173  C   LYS    22      56.811 102.630 161.465  1.00 30.52           C  
ATOM    174  O   LYS    22      56.681 103.547 162.270  1.00 30.90           O  
ATOM    175  CB  LYS    22      54.511 102.139 160.628  1.00 31.54           C  
ATOM    176  CG  LYS    22      53.556 101.944 159.460  1.00 32.93           C  
ATOM    177  CD  LYS    22      52.289 101.284 159.920  1.00 36.32           C  
ATOM    178  CE  LYS    22      51.331 101.128 158.754  1.00 40.34           C  
ATOM    179  NZ  LYS    22      51.088 102.441 158.083  1.00 39.09           N  
ATOM    180  N   LYS    23      57.728 101.684 161.619  1.00 29.61           N  
ATOM    181  CA  LYS    23      58.566 101.657 162.835  1.00 29.72           C  
ATOM    182  C   LYS    23      60.012 101.231 162.686  1.00 28.69           C  
ATOM    183  O   LYS    23      60.709 101.091 163.674  1.00 29.01           O  
ATOM    184  CB  LYS    23      57.921 100.821 163.935  1.00 29.86           C  
ATOM    185  CG  LYS    23      56.832  99.941 163.461  1.00 32.38           C  
ATOM    186  CD  LYS    23      55.808  99.771 164.568  1.00 37.27           C  
ATOM    187  CE  LYS    23      55.798  98.363 165.087  1.00 36.51           C  
ATOM    188  NZ  LYS    23      54.492  98.134 165.729  1.00 38.60           N  
ATOM    189  N   ALA    24      60.461 101.009 161.461  1.00 28.04           N  
ATOM    190  CA  ALA    24      61.866 100.760 161.229  1.00 27.63           C  
ATOM    191  C   ALA    24      62.245 101.307 159.865  1.00 27.25           C  
ATOM    192  O   ALA    24      61.366 101.642 159.060  1.00 26.73           O  
ATOM    193  CB  ALA    24      62.169  99.289 161.329  1.00 27.37           C  
ATOM    194  N   GLU    25      63.551 101.433 159.638  1.00 27.27           N  
ATOM    195  CA  GLU    25      64.081 101.772 158.330  1.00 27.27           C  
ATOM    196  C   GLU    25      64.102 100.507 157.472  1.00 26.92           C  
ATOM    197  O   GLU    25      64.846  99.565 157.768  1.00 26.87           O  
ATOM    198  CB  GLU    25      65.496 102.383 158.422  1.00 26.99           C  
ATOM    199  CG  GLU    25      66.170 102.460 157.029  1.00 26.98           C  
ATOM    200  CD  GLU    25      67.656 102.799 157.053  1.00 28.27           C  
ATOM    201  OE1 GLU    25      68.276 102.751 158.132  1.00 28.17           O  
ATOM    202  OE2 GLU    25      68.201 103.151 155.975  1.00 28.59           O  
ATOM    203  N   VAL    26      63.305 100.491 156.401  1.00 26.81           N  
ATOM    204  CA  VAL    26      63.250  99.314 155.551  1.00 26.96           C  
ATOM    205  C   VAL    26      64.162  99.482 154.333  1.00 27.22           C  
ATOM    206  O   VAL    26      63.985 100.391 153.533  1.00 27.46           O  
ATOM    207  CB  VAL    26      61.793  98.920 155.140  1.00 26.65           C  
ATOM    208  CG1 VAL    26      61.803  97.693 154.228  1.00 25.56           C  
ATOM    209  CG2 VAL    26      60.922  98.621 156.364  1.00 27.09           C  
ATOM    210  N   ILE    27      65.152  98.605 154.217  1.00 27.33           N  
ATOM    211  CA  ILE    27      66.029  98.558 153.039  1.00 27.69           C  
ATOM    212  C   ILE    27      65.476  97.465 152.133  1.00 27.86           C  
ATOM    213  O   ILE    27      65.402  96.301 152.508  1.00 27.58           O  
ATOM    214  CB  ILE    27      67.489  98.245 153.447  1.00 26.97           C  
ATOM    215  CG1 ILE    27      67.937  99.270 154.470  1.00 28.56           C  
ATOM    216  CG2 ILE    27      68.435  98.229 152.224  1.00 27.55           C  
ATOM    217  CD1 ILE    27      68.847  98.698 155.600  1.00 29.58           C  
ATOM    218  N   THR    28      65.029  97.863 150.954  1.00 28.51           N  
ATOM    219  CA  THR    28      64.392  96.927 150.047  1.00 28.43           C  
ATOM    220  C   THR    28      65.405  96.255 149.115  1.00 28.83           C  
ATOM    221  O   THR    28      66.370  96.876 148.662  1.00 28.93           O  
ATOM    222  CB  THR    28      63.295  97.615 149.229  1.00 28.34           C  
ATOM    223  OG1 THR    28      63.894  98.645 148.433  1.00 28.18           O  
ATOM    224  CG2 THR    28      62.241  98.245 150.179  1.00 28.07           C  
ATOM    225  N   ALA    29      65.157  94.979 148.841  1.00 29.69           N  
ATOM    226  CA  ALA    29      65.945  94.185 147.916  1.00 30.05           C  
ATOM    227  C   ALA    29      64.978  93.373 147.062  1.00 30.59           C  
ATOM    228  O   ALA    29      63.919  92.962 147.533  1.00 30.68           O  
ATOM    229  CB  ALA    29      66.860  93.273 148.665  1.00 29.79           C  
ATOM    230  N   GLY    30      65.329  93.178 145.799  1.00 30.69           N  
ATOM    231  CA  GLY    30      64.541  92.346 144.898  1.00 31.31           C  
ATOM    232  C   GLY    30      65.432  91.992 143.732  1.00 31.66           C  
ATOM    233  O   GLY    30      66.581  92.450 143.660  1.00 30.63           O  
ATOM    234  N   ARG    31      64.918  91.189 142.811  1.00 33.00           N  
ATOM    235  CA  ARG    31      65.729  90.819 141.665  1.00 33.89           C  
ATOM    236  C   ARG    31      65.957  91.991 140.738  1.00 34.88           C  
ATOM    237  O   ARG    31      67.078  92.171 140.268  1.00 34.83           O  
ATOM    238  CB  ARG    31      65.204  89.598 140.898  1.00 34.45           C  
ATOM    239  CG  ARG    31      66.369  88.613 140.619  1.00 34.99           C  
ATOM    240  CD  ARG    31      66.404  88.239 139.212  1.00 33.69           C  
ATOM    241  NE  ARG    31      67.719  87.953 138.626  1.00 32.87           N  
ATOM    242  CZ  ARG    31      68.771  88.779 138.582  1.00 33.03           C  
ATOM    243  NH1 ARG    31      69.856  88.388 137.936  1.00 33.24           N  
ATOM    244  NH2 ARG    31      68.784  89.960 139.209  1.00 30.66           N  
ATOM    245  N   HIS    32      64.925  92.805 140.516  1.00 35.93           N  
ATOM    246  CA  HIS    32      65.015  93.907 139.530  1.00 37.44           C  
ATOM    247  C   HIS    32      64.922  95.323 140.066  1.00 38.17           C  
ATOM    248  O   HIS    32      65.514  96.238 139.478  1.00 39.14           O  
ATOM    249  CB  HIS    32      63.972  93.724 138.434  1.00 37.91           C  
ATOM    250  CG  HIS    32      64.083  92.411 137.742  1.00 38.14           C  
ATOM    251  ND1 HIS    32      65.207  92.046 137.032  1.00 38.54           N  
ATOM    252  CD2 HIS    32      63.239  91.354 137.694  1.00 38.48           C  
ATOM    253  CE1 HIS    32      65.036  90.824 136.555  1.00 39.45           C  
ATOM    254  NE2 HIS    32      63.844  90.391 136.927  1.00 37.38           N  
ATOM    255  N   SER    33      64.176  95.491 141.157  1.00 38.58           N  
ATOM    256  CA  SER    33      63.980  96.777 141.831  1.00 39.46           C  
ATOM    257  C   SER    33      64.320  96.670 143.307  1.00 38.87           C  
ATOM    258  O   SER    33      64.323  95.584 143.871  1.00 38.68           O  
ATOM    259  CB  SER    33      62.518  97.216 141.729  1.00 39.72           C  
ATOM    260  OG  SER    33      62.332  98.018 140.580  1.00 42.93           O  
ATOM    261  N   GLY    34      64.579  97.814 143.926  1.00 38.45           N  
ATOM    262  CA  GLY    34      64.831  97.882 145.360  1.00 38.14           C  
ATOM    263  C   GLY    34      66.042  98.756 145.591  1.00 37.85           C  
ATOM    264  O   GLY    34      66.692  99.180 144.632  1.00 37.39           O  
ATOM    265  N   ASP    35      66.326  99.040 146.858  1.00 37.48           N  
ATOM    266  CA  ASP    35      67.518  99.773 147.235  1.00 37.26           C  
ATOM    267  C   ASP    35      68.748  98.949 146.807  1.00 37.19           C  
ATOM    268  O   ASP    35      69.730  99.506 146.326  1.00 37.10           O  
ATOM    269  CB  ASP    35      67.542 100.052 148.750  1.00 37.63           C  
ATOM    270  CG  ASP    35      66.417 100.997 149.216  1.00 38.42           C  
ATOM    271  OD1 ASP    35      66.225 102.081 148.612  1.00 40.32           O  
ATOM    272  OD2 ASP    35      65.729 100.673 150.217  1.00 39.20           O  
ATOM    273  N   VAL    36      68.683  97.624 146.980  1.00 36.53           N  
ATOM    274  CA  VAL    36      69.713  96.702 146.448  1.00 35.63           C  
ATOM    275  C   VAL    36      69.098  95.563 145.633  1.00 34.64           C  
ATOM    276  O   VAL    36      67.989  95.111 145.904  1.00 34.27           O  
ATOM    277  CB  VAL    36      70.649  96.101 147.556  1.00 35.05           C  
ATOM    278  CG1 VAL    36      71.406  97.188 148.271  1.00 36.74           C  
ATOM    279  CG2 VAL    36      69.870  95.272 148.559  1.00 35.22           C  
ATOM    280  N   THR    37      69.823  95.092 144.631  1.00 34.22           N  
ATOM    281  CA  THR    37      69.319  93.988 143.828  1.00 33.79           C  
ATOM    282  C   THR    37      70.066  92.688 144.146  1.00 32.97           C  
ATOM    283  O   THR    37      71.248  92.697 144.509  1.00 32.63           O  
ATOM    284  CB  THR    37      69.267  94.309 142.320  1.00 33.76           C  
ATOM    285  OG1 THR    37      70.584  94.587 141.828  1.00 35.76           O  
ATOM    286  CG2 THR    37      68.369  95.514 142.077  1.00 34.81           C  
ATOM    287  N   VAL    38      69.341  91.578 144.062  1.00 32.25           N  
ATOM    288  CA  VAL    38      69.899  90.289 144.443  1.00 31.31           C  
ATOM    289  C   VAL    38      69.334  89.132 143.634  1.00 31.41           C  
ATOM    290  O   VAL    38      68.132  89.093 143.354  1.00 31.72           O  
ATOM    291  CB  VAL    38      69.757  90.018 145.965  1.00 30.70           C  
ATOM    292  CG1 VAL    38      68.293  89.876 146.395  1.00 28.51           C  
ATOM    293  CG2 VAL    38      70.534  88.791 146.321  1.00 31.36           C  
ATOM    294  N   ASP    39      70.221  88.211 143.249  1.00 30.53           N  
ATOM    295  CA  ASP    39      69.826  86.923 142.681  1.00 30.50           C  
ATOM    296  C   ASP    39      70.025  85.799 143.726  1.00 29.76           C  
ATOM    297  O   ASP    39      71.139  85.248 143.868  1.00 29.33           O  
ATOM    298  CB  ASP    39      70.633  86.625 141.395  1.00 30.79           C  
ATOM    299  CG  ASP    39      70.195  85.334 140.716  1.00 32.20           C  
ATOM    300  OD1 ASP    39      69.159  84.760 141.128  1.00 33.16           O  
ATOM    301  OD2 ASP    39      70.886  84.901 139.753  1.00 36.58           O  
ATOM    302  N   ILE    40      68.955  85.473 144.460  1.00 29.38           N  
ATOM    303  CA  ILE    40      69.036  84.476 145.548  1.00 28.94           C  
ATOM    304  C   ILE    40      69.465  83.069 145.123  1.00 28.58           C  
ATOM    305  O   ILE    40      69.821  82.266 145.989  1.00 28.65           O  
ATOM    306  CB  ILE    40      67.759  84.392 146.405  1.00 28.74           C  
ATOM    307  CG1 ILE    40      66.595  83.795 145.595  1.00 30.50           C  
ATOM    308  CG2 ILE    40      67.430  85.767 147.045  1.00 28.60           C  
ATOM    309  CD1 ILE    40      65.492  83.172 146.464  1.00 29.39           C  
ATOM    310  N   THR    41      69.441  82.774 143.813  1.00 27.92           N  
ATOM    311  CA  THR    41      69.923  81.477 143.305  1.00 26.91           C  
ATOM    312  C   THR    41      71.449  81.479 143.140  1.00 27.43           C  
ATOM    313  O   THR    41      72.046  80.455 142.797  1.00 26.35           O  
ATOM    314  CB  THR    41      69.296  81.096 141.933  1.00 27.63           C  
ATOM    315  OG1 THR    41      69.809  81.944 140.883  1.00 26.03           O  
ATOM    316  CG2 THR    41      67.723  81.111 141.968  1.00 28.15           C  
ATOM    317  N   ASN    42      72.064  82.650 143.350  1.00 27.04           N  
ATOM    318  CA  ASN    42      73.477  82.841 143.110  1.00 27.38           C  
ATOM    319  C   ASN    42      74.171  83.352 144.377  1.00 27.71           C  
ATOM    320  O   ASN    42      73.952  84.491 144.798  1.00 27.18           O  
ATOM    321  CB  ASN    42      73.656  83.833 141.975  1.00 27.56           C  
ATOM    322  CG  ASN    42      75.078  83.923 141.505  1.00 28.64           C  
ATOM    323  OD1 ASN    42      75.955  84.414 142.227  1.00 30.86           O  
ATOM    324  ND2 ASN    42      75.317  83.498 140.266  1.00 27.24           N  
ATOM    325  N   ILE    43      74.979  82.510 145.012  1.00 27.57           N  
ATOM    326  CA  ILE    43      75.523  82.916 146.309  1.00 28.51           C  
ATOM    327  C   ILE    43      76.486  84.094 146.218  1.00 28.08           C  
ATOM    328  O   ILE    43      76.567  84.874 147.167  1.00 27.91           O  
ATOM    329  CB  ILE    43      76.103  81.730 147.170  1.00 28.59           C  
ATOM    330  CG1 ILE    43      77.521  81.310 146.740  1.00 30.31           C  
ATOM    331  CG2 ILE    43      75.080  80.578 147.279  1.00 30.61           C  
ATOM    332  CD1 ILE    43      77.572  80.470 145.499  1.00 31.38           C  
ATOM    333  N   ASP    44      77.191  84.263 145.093  1.00 27.91           N  
ATOM    334  CA  ASP    44      78.040  85.466 144.991  1.00 29.17           C  
ATOM    335  C   ASP    44      77.154  86.727 144.899  1.00 27.92           C  
ATOM    336  O   ASP    44      77.510  87.768 145.420  1.00 26.84           O  
ATOM    337  CB  ASP    44      79.098  85.401 143.875  1.00 30.14           C  
ATOM    338  CG  ASP    44      80.095  86.589 143.934  1.00 35.50           C  
ATOM    339  OD1 ASP    44      80.582  86.952 145.053  1.00 40.68           O  
ATOM    340  OD2 ASP    44      80.397  87.167 142.855  1.00 41.54           O  
ATOM    341  N   SER    45      75.963  86.599 144.320  1.00 27.03           N  
ATOM    342  CA  SER    45      75.034  87.722 144.307  1.00 26.97           C  
ATOM    343  C   SER    45      74.516  88.028 145.718  1.00 26.48           C  
ATOM    344  O   SER    45      74.399  89.182 146.095  1.00 26.21           O  
ATOM    345  CB  SER    45      73.890  87.495 143.333  1.00 26.64           C  
ATOM    346  OG  SER    45      72.957  88.558 143.445  1.00 28.69           O  
ATOM    347  N   ILE    46      74.224  86.996 146.494  1.00 25.96           N  
ATOM    348  CA  ILE    46      73.833  87.201 147.897  1.00 26.95           C  
ATOM    349  C   ILE    46      74.968  87.862 148.692  1.00 27.59           C  
ATOM    350  O   ILE    46      74.747  88.814 149.427  1.00 27.43           O  
ATOM    351  CB  ILE    46      73.394  85.893 148.581  1.00 26.24           C  
ATOM    352  CG1 ILE    46      72.147  85.345 147.878  1.00 26.54           C  
ATOM    353  CG2 ILE    46      73.116  86.133 150.097  1.00 26.47           C  
ATOM    354  CD1 ILE    46      71.788  83.933 148.305  1.00 24.99           C  
ATOM    355  N   LYS    47      76.178  87.343 148.525  1.00 28.50           N  
ATOM    356  CA  LYS    47      77.356  87.895 149.171  1.00 29.72           C  
ATOM    357  C   LYS    47      77.564  89.393 148.848  1.00 30.13           C  
ATOM    358  O   LYS    47      77.805  90.203 149.751  1.00 29.54           O  
ATOM    359  CB  LYS    47      78.578  87.064 148.767  1.00 30.30           C  
ATOM    360  CG  LYS    47      78.673  85.716 149.477  1.00 32.50           C  
ATOM    361  CD  LYS    47      79.887  84.944 148.971  1.00 36.21           C  
ATOM    362  CE  LYS    47      80.083  83.653 149.768  1.00 37.75           C  
ATOM    363  NZ  LYS    47      81.284  82.869 149.334  1.00 38.21           N  
ATOM    364  N   LYS    48      77.468  89.741 147.559  1.00 30.44           N  
ATOM    365  CA  LYS    48      77.582  91.122 147.096  1.00 31.51           C  
ATOM    366  C   LYS    48      76.504  92.002 147.731  1.00 31.18           C  
ATOM    367  O   LYS    48      76.784  93.135 148.130  1.00 30.84           O  
ATOM    368  CB  LYS    48      77.493  91.185 145.566  1.00 31.62           C  
ATOM    369  CG  LYS    48      78.736  90.634 144.841  1.00 33.07           C  
ATOM    370  CD  LYS    48      78.630  90.787 143.303  1.00 33.79           C  
ATOM    371  CE  LYS    48      78.160  89.476 142.644  1.00 37.12           C  
ATOM    372  NZ  LYS    48      77.685  89.583 141.225  1.00 36.87           N  
ATOM    373  N   MET    49      75.283  91.471 147.837  1.00 30.83           N  
ATOM    374  CA  MET    49      74.181  92.190 148.491  1.00 31.77           C  
ATOM    375  C   MET    49      74.504  92.558 149.934  1.00 30.97           C  
ATOM    376  O   MET    49      74.351  93.702 150.324  1.00 30.22           O  
ATOM    377  CB  MET    49      72.872  91.393 148.461  1.00 31.29           C  
ATOM    378  CG  MET    49      71.749  92.116 149.184  1.00 32.56           C  
ATOM    379  SD  MET    49      70.139  91.076 149.565  0.70 34.45          SE  
ATOM    380  CE  MET    49      70.849  89.754 150.815  1.00 34.11           C  
ATOM    381  N   TYR    50      74.922  91.577 150.728  1.00 30.70           N  
ATOM    382  CA  TYR    50      75.252  91.834 152.147  1.00 31.24           C  
ATOM    383  C   TYR    50      76.454  92.804 152.321  1.00 32.06           C  
ATOM    384  O   TYR    50      76.481  93.637 153.238  1.00 32.05           O  
ATOM    385  CB  TYR    50      75.513  90.516 152.861  1.00 29.92           C  
ATOM    386  CG  TYR    50      74.266  89.723 153.203  1.00 29.82           C  
ATOM    387  CD1 TYR    50      73.207  90.306 153.916  1.00 27.46           C  
ATOM    388  CD2 TYR    50      74.153  88.375 152.844  1.00 27.81           C  
ATOM    389  CE1 TYR    50      72.071  89.567 154.236  1.00 28.82           C  
ATOM    390  CE2 TYR    50      73.019  87.629 153.170  1.00 27.43           C  
ATOM    391  CZ  TYR    50      71.980  88.227 153.878  1.00 27.56           C  
ATOM    392  OH  TYR    50      70.857  87.480 154.231  1.00 28.16           O  
ATOM    393  N   GLU    51      77.428  92.682 151.418  1.00 33.53           N  
ATOM    394  CA  GLU    51      78.585  93.579 151.337  1.00 35.20           C  
ATOM    395  C   GLU    51      78.158  95.036 151.106  1.00 35.05           C  
ATOM    396  O   GLU    51      78.655  95.949 151.784  1.00 35.18           O  
ATOM    397  CB  GLU    51      79.495  93.115 150.212  1.00 35.29           C  
ATOM    398  CG  GLU    51      80.946  93.479 150.349  1.00 40.27           C  
ATOM    399  CD  GLU    51      81.719  93.192 149.059  1.00 46.04           C  
ATOM    400  OE1 GLU    51      82.614  93.999 148.696  1.00 48.04           O  
ATOM    401  OE2 GLU    51      81.412  92.169 148.395  1.00 48.24           O  
ATOM    402  N   GLN    52      77.231  95.239 150.168  1.00 35.03           N  
ATOM    403  CA  GLN    52      76.595  96.549 149.922  1.00 35.53           C  
ATOM    404  C   GLN    52      75.787  97.080 151.117  1.00 34.17           C  
ATOM    405  O   GLN    52      75.843  98.253 151.428  1.00 33.89           O  
ATOM    406  CB  GLN    52      75.610  96.444 148.753  1.00 35.67           C  
ATOM    407  CG  GLN    52      76.161  96.623 147.348  1.00 38.30           C  
ATOM    408  CD  GLN    52      75.059  96.444 146.286  1.00 38.67           C  
ATOM    409  OE1 GLN    52      74.758  97.377 145.545  1.00 42.38           O  
ATOM    410  NE2 GLN    52      74.427  95.250 146.245  1.00 40.22           N  
ATOM    411  N   VAL    53      74.982  96.221 151.738  1.00 33.02           N  
ATOM    412  CA  VAL    53      74.032  96.657 152.756  1.00 31.77           C  
ATOM    413  C   VAL    53      74.734  96.975 154.079  1.00 31.61           C  
ATOM    414  O   VAL    53      74.300  97.863 154.814  1.00 31.13           O  
ATOM    415  CB  VAL    53      72.917  95.592 152.966  1.00 32.14           C  
ATOM    416  CG1 VAL    53      72.124  95.847 154.210  1.00 31.65           C  
ATOM    417  CG2 VAL    53      71.977  95.593 151.792  1.00 31.28           C  
ATOM    418  N   GLY    54      75.808  96.243 154.371  1.00 30.90           N  
ATOM    419  CA  GLY    54      76.457  96.317 155.683  1.00 31.39           C  
ATOM    420  C   GLY    54      75.587  95.602 156.690  1.00 31.14           C  
ATOM    421  O   GLY    54      74.890  94.655 156.324  1.00 32.58           O  
ATOM    422  N   LYS    55      75.583  96.063 157.935  1.00 30.24           N  
ATOM    423  CA  LYS    55      74.870  95.363 159.016  1.00 30.12           C  
ATOM    424  C   LYS    55      73.449  95.876 159.255  1.00 29.19           C  
ATOM    425  O   LYS    55      73.196  97.062 159.150  1.00 28.55           O  
ATOM    426  CB  LYS    55      75.681  95.401 160.335  1.00 30.87           C  
ATOM    427  CG  LYS    55      77.011  94.668 160.203  1.00 32.75           C  
ATOM    428  CD  LYS    55      77.630  94.306 161.510  1.00 38.98           C  
ATOM    429  CE  LYS    55      79.014  93.684 161.267  1.00 42.47           C  
ATOM    430  NZ  LYS    55      79.386  92.731 162.356  1.00 45.84           N  
ATOM    431  N   VAL    56      72.537  94.953 159.574  1.00 28.65           N  
ATOM    432  CA  VAL    56      71.131  95.280 159.860  1.00 27.78           C  
ATOM    433  C   VAL    56      70.663  94.563 161.118  1.00 27.25           C  
ATOM    434  O   VAL    56      71.383  93.736 161.658  1.00 26.65           O  
ATOM    435  CB  VAL    56      70.186  94.930 158.674  1.00 26.85           C  
ATOM    436  CG1 VAL    56      70.496  95.801 157.470  1.00 26.81           C  
ATOM    437  CG2 VAL    56      70.271  93.453 158.301  1.00 27.49           C  
ATOM    438  N   ASP    57      69.451  94.887 161.568  1.00 27.80           N  
ATOM    439  CA  ASP    57      68.850  94.240 162.733  1.00 27.89           C  
ATOM    440  C   ASP    57      67.907  93.094 162.380  1.00 28.18           C  
ATOM    441  O   ASP    57      67.706  92.209 163.204  1.00 28.86           O  
ATOM    442  CB  ASP    57      68.083  95.260 163.551  1.00 28.40           C  
ATOM    443  CG  ASP    57      68.963  96.391 163.998  1.00 31.59           C  
ATOM    444  OD1 ASP    57      68.652  97.551 163.631  1.00 36.21           O  
ATOM    445  OD2 ASP    57      69.999  96.108 164.654  1.00 32.98           O  
ATOM    446  N   ALA    58      67.310  93.117 161.190  1.00 27.40           N  
ATOM    447  CA  ALA    58      66.459  91.995 160.772  1.00 27.62           C  
ATOM    448  C   ALA    58      66.603  91.758 159.272  1.00 27.39           C  
ATOM    449  O   ALA    58      66.736  92.695 158.499  1.00 27.58           O  
ATOM    450  CB  ALA    58      64.995  92.232 161.156  1.00 26.95           C  
ATOM    451  N   ILE    59      66.623  90.492 158.885  1.00 27.49           N  
ATOM    452  CA  ILE    59      66.607  90.095 157.472  1.00 27.11           C  
ATOM    453  C   ILE    59      65.295  89.344 157.267  1.00 27.57           C  
ATOM    454  O   ILE    59      64.981  88.409 158.008  1.00 27.71           O  
ATOM    455  CB  ILE    59      67.840  89.222 157.126  1.00 27.27           C  
ATOM    456  CG1 ILE    59      69.127  90.078 157.261  1.00 26.57           C  
ATOM    457  CG2 ILE    59      67.715  88.626 155.703  1.00 24.63           C  
ATOM    458  CD1 ILE    59      70.394  89.295 157.412  1.00 26.03           C  
ATOM    459  N   VAL    60      64.493  89.826 156.326  1.00 28.08           N  
ATOM    460  CA  VAL    60      63.169  89.251 156.072  1.00 27.73           C  
ATOM    461  C   VAL    60      63.071  88.781 154.618  1.00 28.57           C  
ATOM    462  O   VAL    60      63.349  89.533 153.693  1.00 28.21           O  
ATOM    463  CB  VAL    60      62.067  90.264 156.378  1.00 27.44           C  
ATOM    464  CG1 VAL    60      60.679  89.721 155.932  1.00 27.80           C  
ATOM    465  CG2 VAL    60      62.092  90.646 157.886  1.00 26.89           C  
ATOM    466  N   SER    61      62.671  87.530 154.421  1.00 29.95           N  
ATOM    467  CA  SER    61      62.568  86.978 153.068  1.00 30.37           C  
ATOM    468  C   SER    61      61.116  86.686 152.779  1.00 31.23           C  
ATOM    469  O   SER    61      60.509  85.805 153.389  1.00 31.34           O  
ATOM    470  CB  SER    61      63.416  85.717 152.948  1.00 29.63           C  
ATOM    471  OG  SER    61      63.170  85.050 151.737  1.00 30.77           O  
ATOM    472  N   ALA    62      60.558  87.497 151.899  1.00 32.52           N  
ATOM    473  CA  ALA    62      59.273  87.253 151.277  1.00 33.81           C  
ATOM    474  C   ALA    62      59.503  86.978 149.782  1.00 34.83           C  
ATOM    475  O   ALA    62      58.849  87.562 148.909  1.00 35.84           O  
ATOM    476  CB  ALA    62      58.354  88.468 151.486  1.00 33.75           C  
ATOM    477  N   THR    63      60.475  86.117 149.494  1.00 35.60           N  
ATOM    478  CA  THR    63      60.778  85.681 148.124  1.00 37.14           C  
ATOM    479  C   THR    63      61.004  84.190 148.079  1.00 36.99           C  
ATOM    480  O   THR    63      60.865  83.493 149.086  1.00 37.39           O  
ATOM    481  CB  THR    63      62.093  86.266 147.543  1.00 37.08           C  
ATOM    482  OG1 THR    63      62.952  86.718 148.605  1.00 39.36           O  
ATOM    483  CG2 THR    63      61.825  87.333 146.527  1.00 37.63           C  
ATOM    484  N   GLY    64      61.408  83.735 146.897  1.00 37.22           N  
ATOM    485  CA  GLY    64      61.683  82.331 146.643  1.00 36.82           C  
ATOM    486  C   GLY    64      60.583  81.837 145.742  1.00 35.98           C  
ATOM    487  O   GLY    64      59.418  82.145 145.962  1.00 36.07           O  
ATOM    488  N   SER    65      60.939  81.100 144.707  1.00 35.86           N  
ATOM    489  CA  SER    65      59.905  80.462 143.920  1.00 35.87           C  
ATOM    490  C   SER    65      60.063  78.947 143.811  1.00 35.53           C  
ATOM    491  O   SER    65      61.174  78.383 143.968  1.00 34.12           O  
ATOM    492  CB  SER    65      59.684  81.168 142.565  1.00 36.59           C  
ATOM    493  OG  SER    65      60.868  81.261 141.797  1.00 39.05           O  
ATOM    494  N   ALA    66      58.916  78.301 143.633  1.00 35.28           N  
ATOM    495  CA  ALA    66      58.827  76.860 143.396  1.00 36.00           C  
ATOM    496  C   ALA    66      58.163  76.570 142.050  1.00 36.09           C  
ATOM    497  O   ALA    66      57.241  77.278 141.642  1.00 36.27           O  
ATOM    498  CB  ALA    66      58.027  76.190 144.525  1.00 36.26           C  
ATOM    499  N   THR    67      58.658  75.537 141.366  1.00 36.15           N  
ATOM    500  CA  THR    67      58.007  74.924 140.217  1.00 35.80           C  
ATOM    501  C   THR    67      56.640  74.362 140.623  1.00 35.12           C  
ATOM    502  O   THR    67      56.534  73.695 141.632  1.00 33.77           O  
ATOM    503  CB  THR    67      58.855  73.723 139.720  1.00 35.97           C  
ATOM    504  OG1 THR    67      60.120  74.176 139.214  1.00 37.36           O  
ATOM    505  CG2 THR    67      58.142  72.977 138.614  1.00 37.64           C  
ATOM    506  N   PHE    68      55.599  74.641 139.838  1.00 35.09           N  
ATOM    507  CA  PHE    68      54.312  73.933 139.978  1.00 34.98           C  
ATOM    508  C   PHE    68      54.224  72.974 138.822  1.00 33.96           C  
ATOM    509  O   PHE    68      54.343  73.385 137.669  1.00 33.07           O  
ATOM    510  CB  PHE    68      53.132  74.902 139.924  1.00 36.51           C  
ATOM    511  CG  PHE    68      52.751  75.477 141.250  1.00 40.26           C  
ATOM    512  CD1 PHE    68      53.709  75.705 142.245  1.00 43.38           C  
ATOM    513  CD2 PHE    68      51.424  75.816 141.505  1.00 44.04           C  
ATOM    514  CE1 PHE    68      53.346  76.253 143.487  1.00 45.21           C  
ATOM    515  CE2 PHE    68      51.047  76.360 142.725  1.00 43.90           C  
ATOM    516  CZ  PHE    68      52.009  76.580 143.724  1.00 43.50           C  
ATOM    517  N   SER    69      54.054  71.691 139.121  1.00 32.62           N  
ATOM    518  CA  SER    69      54.065  70.663 138.087  1.00 31.53           C  
ATOM    519  C   SER    69      53.362  69.406 138.586  1.00 30.99           C  
ATOM    520  O   SER    69      53.619  68.991 139.713  1.00 30.87           O  
ATOM    521  CB  SER    69      55.518  70.330 137.748  1.00 31.58           C  
ATOM    522  OG  SER    69      55.631  69.135 137.004  1.00 33.02           O  
ATOM    523  N   PRO    70      52.533  68.755 137.734  1.00 30.90           N  
ATOM    524  CA  PRO    70      51.981  67.455 138.136  1.00 30.68           C  
ATOM    525  C   PRO    70      53.160  66.574 138.537  1.00 30.72           C  
ATOM    526  O   PRO    70      54.210  66.631 137.880  1.00 30.60           O  
ATOM    527  CB  PRO    70      51.361  66.918 136.839  1.00 30.70           C  
ATOM    528  CG  PRO    70      51.105  68.137 135.992  1.00 30.49           C  
ATOM    529  CD  PRO    70      52.158  69.121 136.349  1.00 30.41           C  
ATOM    530  N   LEU    71      53.015  65.798 139.606  1.00 30.90           N  
ATOM    531  CA  LEU    71      54.097  64.924 140.113  1.00 31.49           C  
ATOM    532  C   LEU    71      54.744  64.086 139.017  1.00 31.74           C  
ATOM    533  O   LEU    71      55.959  63.940 138.922  1.00 32.18           O  
ATOM    534  CB  LEU    71      53.545  63.993 141.186  1.00 30.66           C  
ATOM    535  CG  LEU    71      54.503  62.961 141.788  1.00 31.94           C  
ATOM    536  CD1 LEU    71      55.565  63.600 142.665  1.00 30.84           C  
ATOM    537  CD2 LEU    71      53.683  61.964 142.612  1.00 32.08           C  
ATOM    538  N   THR    72      53.887  63.553 138.173  1.00 32.64           N  
ATOM    539  CA  THR    72      54.258  62.726 137.060  1.00 33.06           C  
ATOM    540  C   THR    72      55.042  63.486 135.965  1.00 32.56           C  
ATOM    541  O   THR    72      55.696  62.858 135.127  1.00 32.65           O  
ATOM    542  CB  THR    72      52.957  62.015 136.616  1.00 33.40           C  
ATOM    543  OG1 THR    72      52.720  60.934 137.547  1.00 36.49           O  
ATOM    544  CG2 THR    72      53.013  61.504 135.252  1.00 34.96           C  
ATOM    545  N   GLU    73      55.021  64.826 136.015  1.00 31.73           N  
ATOM    546  CA  GLU    73      55.843  65.673 135.120  1.00 31.59           C  
ATOM    547  C   GLU    73      56.975  66.381 135.861  1.00 29.95           C  
ATOM    548  O   GLU    73      57.780  67.069 135.254  1.00 30.07           O  
ATOM    549  CB  GLU    73      54.987  66.697 134.383  1.00 31.08           C  
ATOM    550  CG  GLU    73      53.937  66.051 133.505  1.00 35.57           C  
ATOM    551  CD  GLU    73      53.010  67.061 132.838  1.00 41.39           C  
ATOM    552  OE1 GLU    73      51.892  66.651 132.444  1.00 44.05           O  
ATOM    553  OE2 GLU    73      53.390  68.255 132.707  1.00 43.21           O  
ATOM    554  N   LEU    74      57.016  66.198 137.174  1.00 28.83           N  
ATOM    555  CA  LEU    74      58.048  66.789 138.039  1.00 27.67           C  
ATOM    556  C   LEU    74      59.365  66.013 137.915  1.00 27.27           C  
ATOM    557  O   LEU    74      59.589  65.029 138.629  1.00 26.82           O  
ATOM    558  CB  LEU    74      57.563  66.810 139.505  1.00 26.60           C  
ATOM    559  CG  LEU    74      58.449  67.428 140.613  1.00 27.55           C  
ATOM    560  CD1 LEU    74      58.978  68.823 140.266  1.00 24.85           C  
ATOM    561  CD2 LEU    74      57.707  67.474 141.970  1.00 26.28           C  
ATOM    562  N   THR    75      60.223  66.450 137.000  1.00 26.79           N  
ATOM    563  CA  THR    75      61.547  65.835 136.829  1.00 26.48           C  
ATOM    564  C   THR    75      62.536  66.357 137.851  1.00 26.20           C  
ATOM    565  O   THR    75      62.317  67.418 138.433  1.00 26.47           O  
ATOM    566  CB  THR    75      62.153  66.120 135.444  1.00 26.52           C  
ATOM    567  OG1 THR    75      62.149  67.524 135.223  1.00 24.43           O  
ATOM    568  CG2 THR    75      61.344  65.450 134.358  1.00 26.42           C  
ATOM    569  N   PRO    76      63.640  65.611 138.079  1.00 26.32           N  
ATOM    570  CA  PRO    76      64.732  66.158 138.892  1.00 26.02           C  
ATOM    571  C   PRO    76      65.150  67.551 138.406  1.00 25.77           C  
ATOM    572  O   PRO    76      65.433  68.419 139.235  1.00 25.48           O  
ATOM    573  CB  PRO    76      65.873  65.155 138.684  1.00 26.18           C  
ATOM    574  CG  PRO    76      65.168  63.840 138.414  1.00 26.15           C  
ATOM    575  CD  PRO    76      63.933  64.241 137.599  1.00 26.60           C  
ATOM    576  N   GLU    77      65.167  67.769 137.088  1.00 24.97           N  
ATOM    577  CA  GLU    77      65.473  69.095 136.543  1.00 25.17           C  
ATOM    578  C   GLU    77      64.515  70.192 137.009  1.00 25.61           C  
ATOM    579  O   GLU    77      64.957  71.254 137.446  1.00 24.80           O  
ATOM    580  CB  GLU    77      65.573  69.074 135.022  1.00 24.98           C  
ATOM    581  CG  GLU    77      66.775  68.319 134.524  1.00 25.56           C  
ATOM    582  CD  GLU    77      66.472  66.868 134.177  1.00 28.15           C  
ATOM    583  OE1 GLU    77      65.548  66.240 134.766  1.00 26.20           O  
ATOM    584  OE2 GLU    77      67.191  66.348 133.297  1.00 31.05           O  
ATOM    585  N   LYS    78      63.217  69.926 136.928  1.00 26.16           N  
ATOM    586  CA  LYS    78      62.196  70.873 137.404  1.00 27.26           C  
ATOM    587  C   LYS    78      62.325  71.088 138.896  1.00 26.94           C  
ATOM    588  O   LYS    78      62.309  72.231 139.351  1.00 26.88           O  
ATOM    589  CB  LYS    78      60.777  70.383 137.083  1.00 27.15           C  
ATOM    590  CG  LYS    78      60.290  70.681 135.659  1.00 30.35           C  
ATOM    591  CD  LYS    78      58.816  70.209 135.530  1.00 29.14           C  
ATOM    592  CE  LYS    78      57.998  70.960 134.498  1.00 34.52           C  
ATOM    593  NZ  LYS    78      56.547  70.486 134.496  1.00 34.23           N  
ATOM    594  N   ASN    79      62.452  69.996 139.660  1.00 27.20           N  
ATOM    595  CA  ASN    79      62.626  70.085 141.123  1.00 26.73           C  
ATOM    596  C   ASN    79      63.874  70.869 141.548  1.00 26.65           C  
ATOM    597  O   ASN    79      63.895  71.491 142.613  1.00 26.71           O  
ATOM    598  CB  ASN    79      62.610  68.682 141.738  1.00 27.21           C  
ATOM    599  CG  ASN    79      62.160  68.676 143.178  1.00 28.62           C  
ATOM    600  OD1 ASN    79      62.779  68.024 144.018  1.00 33.29           O  
ATOM    601  ND2 ASN    79      61.090  69.383 143.475  1.00 26.18           N  
ATOM    602  N   ALA    80      64.903  70.878 140.694  1.00 26.39           N  
ATOM    603  CA  ALA    80      66.127  71.656 140.955  1.00 25.89           C  
ATOM    604  C   ALA    80      65.910  73.174 140.911  1.00 25.82           C  
ATOM    605  O   ALA    80      66.600  73.918 141.590  1.00 25.69           O  
ATOM    606  CB  ALA    80      67.297  71.226 140.000  1.00 25.06           C  
ATOM    607  N   VAL    81      64.923  73.623 140.151  1.00 25.68           N  
ATOM    608  CA  VAL    81      64.539  75.035 140.159  1.00 25.94           C  
ATOM    609  C   VAL    81      64.059  75.469 141.558  1.00 25.91           C  
ATOM    610  O   VAL    81      64.607  76.405 142.135  1.00 26.06           O  
ATOM    611  CB  VAL    81      63.479  75.350 139.066  1.00 26.11           C  
ATOM    612  CG1 VAL    81      63.002  76.785 139.182  1.00 26.25           C  
ATOM    613  CG2 VAL    81      64.054  75.092 137.656  1.00 26.72           C  
ATOM    614  N   THR    82      63.066  74.778 142.110  1.00 25.85           N  
ATOM    615  CA  THR    82      62.599  75.042 143.478  1.00 26.11           C  
ATOM    616  C   THR    82      63.733  75.033 144.503  1.00 26.87           C  
ATOM    617  O   THR    82      63.779  75.891 145.402  1.00 28.39           O  
ATOM    618  CB  THR    82      61.551  73.991 143.906  1.00 26.20           C  
ATOM    619  OG1 THR    82      60.541  73.893 142.889  1.00 26.44           O  
ATOM    620  CG2 THR    82      60.895  74.359 145.221  1.00 23.76           C  
ATOM    621  N   ILE    83      64.611  74.038 144.385  1.00 26.79           N  
ATOM    622  CA  ILE    83      65.729  73.837 145.289  1.00 27.08           C  
ATOM    623  C   ILE    83      66.688  75.029 145.286  1.00 27.28           C  
ATOM    624  O   ILE    83      67.136  75.493 146.357  1.00 27.62           O  
ATOM    625  CB  ILE    83      66.471  72.481 144.992  1.00 27.10           C  
ATOM    626  CG1 ILE    83      65.593  71.310 145.480  1.00 26.85           C  
ATOM    627  CG2 ILE    83      67.847  72.444 145.690  1.00 26.25           C  
ATOM    628  CD1 ILE    83      66.019  69.878 144.998  1.00 28.20           C  
ATOM    629  N   SER    84      66.936  75.567 144.100  1.00 27.43           N  
ATOM    630  CA  SER    84      67.817  76.732 143.953  1.00 27.65           C  
ATOM    631  C   SER    84      67.198  78.043 144.460  1.00 27.57           C  
ATOM    632  O   SER    84      67.926  79.009 144.737  1.00 28.54           O  
ATOM    633  CB  SER    84      68.244  76.883 142.486  1.00 27.23           C  
ATOM    634  OG  SER    84      67.200  77.441 141.728  1.00 27.53           O  
ATOM    635  N   SER    85      65.873  78.094 144.574  1.00 27.44           N  
ATOM    636  CA  SER    85      65.181  79.354 144.869  1.00 27.45           C  
ATOM    637  C   SER    85      64.446  79.349 146.211  1.00 27.88           C  
ATOM    638  O   SER    85      65.037  79.680 147.229  1.00 28.39           O  
ATOM    639  CB  SER    85      64.247  79.767 143.720  1.00 27.61           C  
ATOM    640  OG  SER    85      63.509  80.937 144.072  1.00 26.70           O  
ATOM    641  N   LYS    86      63.172  78.968 146.219  1.00 27.88           N  
ATOM    642  CA  LYS    86      62.366  78.895 147.467  1.00 28.51           C  
ATOM    643  C   LYS    86      63.087  78.216 148.624  1.00 28.64           C  
ATOM    644  O   LYS    86      62.995  78.643 149.788  1.00 28.02           O  
ATOM    645  CB  LYS    86      61.045  78.147 147.211  1.00 29.14           C  
ATOM    646  CG  LYS    86      60.010  78.236 148.382  1.00 30.48           C  
ATOM    647  CD  LYS    86      59.167  79.482 148.254  1.00 34.46           C  
ATOM    648  CE  LYS    86      58.569  79.951 149.569  1.00 34.96           C  
ATOM    649  NZ  LYS    86      57.220  79.357 149.728  1.00 31.88           N  
ATOM    650  N   LEU    87      63.776  77.129 148.302  1.00 29.57           N  
ATOM    651  CA  LEU    87      64.456  76.314 149.306  1.00 29.64           C  
ATOM    652  C   LEU    87      65.875  76.830 149.556  1.00 30.00           C  
ATOM    653  O   LEU    87      66.131  77.502 150.566  1.00 30.14           O  
ATOM    654  CB  LEU    87      64.463  74.841 148.877  1.00 29.27           C  
ATOM    655  CG  LEU    87      64.831  73.748 149.902  1.00 30.59           C  
ATOM    656  CD1 LEU    87      64.349  72.366 149.404  1.00 32.32           C  
ATOM    657  CD2 LEU    87      66.311  73.696 150.247  1.00 32.75           C  
ATOM    658  N   GLY    88      66.780  76.532 148.624  1.00 30.59           N  
ATOM    659  CA  GLY    88      68.199  76.853 148.761  1.00 31.07           C  
ATOM    660  C   GLY    88      68.492  78.326 148.872  1.00 31.31           C  
ATOM    661  O   GLY    88      69.367  78.713 149.633  1.00 32.61           O  
ATOM    662  N   GLY    89      67.767  79.137 148.103  1.00 31.02           N  
ATOM    663  CA  GLY    89      67.925  80.580 148.092  1.00 29.84           C  
ATOM    664  C   GLY    89      67.605  81.191 149.436  1.00 30.31           C  
ATOM    665  O   GLY    89      68.421  81.922 149.978  1.00 30.30           O  
ATOM    666  N   GLN    90      66.437  80.866 149.992  1.00 29.06           N  
ATOM    667  CA  GLN    90      66.097  81.319 151.347  1.00 29.14           C  
ATOM    668  C   GLN    90      67.073  80.842 152.433  1.00 28.89           C  
ATOM    669  O   GLN    90      67.494  81.635 153.287  1.00 29.66           O  
ATOM    670  CB  GLN    90      64.652  80.933 151.700  1.00 28.34           C  
ATOM    671  CG  GLN    90      63.610  81.768 150.939  1.00 28.39           C  
ATOM    672  CD  GLN    90      62.258  81.727 151.609  1.00 29.55           C  
ATOM    673  OE1 GLN    90      61.856  82.694 152.264  1.00 30.50           O  
ATOM    674  NE2 GLN    90      61.548  80.597 151.470  1.00 26.71           N  
ATOM    675  N   ILE    91      67.427  79.558 152.416  1.00 28.75           N  
ATOM    676  CA  ILE    91      68.419  79.035 153.371  1.00 28.76           C  
ATOM    677  C   ILE    91      69.764  79.763 153.227  1.00 28.01           C  
ATOM    678  O   ILE    91      70.419  80.073 154.235  1.00 28.41           O  
ATOM    679  CB  ILE    91      68.664  77.501 153.248  1.00 29.14           C  
ATOM    680  CG1 ILE    91      67.356  76.678 153.259  1.00 31.79           C  
ATOM    681  CG2 ILE    91      69.675  77.016 154.299  1.00 28.95           C  
ATOM    682  CD1 ILE    91      66.668  76.636 154.480  1.00 29.78           C  
ATOM    683  N   ASN    92      70.181  80.042 151.988  1.00 27.06           N  
ATOM    684  CA  ASN    92      71.444  80.743 151.772  1.00 27.02           C  
ATOM    685  C   ASN    92      71.465  82.161 152.266  1.00 26.98           C  
ATOM    686  O   ASN    92      72.519  82.643 152.684  1.00 27.44           O  
ATOM    687  CB  ASN    92      71.914  80.662 150.315  1.00 26.86           C  
ATOM    688  CG  ASN    92      72.399  79.283 149.961  1.00 26.96           C  
ATOM    689  OD1 ASN    92      72.732  78.520 150.851  1.00 27.06           O  
ATOM    690  ND2 ASN    92      72.416  78.940 148.663  1.00 25.66           N  
ATOM    691  N   LEU    93      70.324  82.845 152.219  1.00 26.76           N  
ATOM    692  CA  LEU    93      70.257  84.163 152.830  1.00 26.77           C  
ATOM    693  C   LEU    93      70.639  84.071 154.305  1.00 27.03           C  
ATOM    694  O   LEU    93      71.293  84.979 154.819  1.00 27.41           O  
ATOM    695  CB  LEU    93      68.875  84.789 152.669  1.00 27.04           C  
ATOM    696  CG  LEU    93      68.462  85.196 151.250  1.00 25.94           C  
ATOM    697  CD1 LEU    93      67.011  85.533 151.231  1.00 25.95           C  
ATOM    698  CD2 LEU    93      69.290  86.389 150.729  1.00 25.48           C  
ATOM    699  N   VAL    94      70.288  82.962 154.959  1.00 26.50           N  
ATOM    700  CA  VAL    94      70.625  82.762 156.389  1.00 26.28           C  
ATOM    701  C   VAL    94      72.090  82.396 156.583  1.00 26.41           C  
ATOM    702  O   VAL    94      72.800  83.051 157.352  1.00 27.38           O  
ATOM    703  CB  VAL    94      69.722  81.714 157.090  1.00 26.49           C  
ATOM    704  CG1 VAL    94      70.141  81.549 158.592  1.00 26.24           C  
ATOM    705  CG2 VAL    94      68.236  82.109 156.983  1.00 26.22           C  
ATOM    706  N   LEU    95      72.568  81.381 155.869  1.00 26.02           N  
ATOM    707  CA  LEU    95      73.964  80.967 156.006  1.00 26.29           C  
ATOM    708  C   LEU    95      74.968  82.068 155.582  1.00 26.53           C  
ATOM    709  O   LEU    95      76.086  82.108 156.090  1.00 26.46           O  
ATOM    710  CB  LEU    95      74.259  79.694 155.204  1.00 25.49           C  
ATOM    711  CG  LEU    95      73.319  78.503 155.339  1.00 25.72           C  
ATOM    712  CD1 LEU    95      73.702  77.432 154.329  1.00 24.65           C  
ATOM    713  CD2 LEU    95      73.328  77.962 156.828  1.00 26.36           C  
ATOM    714  N   LEU    96      74.567  82.949 154.661  1.00 26.05           N  
ATOM    715  CA  LEU    96      75.457  84.036 154.254  1.00 25.87           C  
ATOM    716  C   LEU    96      75.225  85.338 155.022  1.00 26.07           C  
ATOM    717  O   LEU    96      75.962  86.310 154.847  1.00 25.26           O  
ATOM    718  CB  LEU    96      75.373  84.260 152.743  1.00 24.41           C  
ATOM    719  CG  LEU    96      75.816  83.071 151.886  1.00 25.07           C  
ATOM    720  CD1 LEU    96      75.501  83.358 150.389  1.00 25.66           C  
ATOM    721  CD2 LEU    96      77.307  82.737 152.077  1.00 26.31           C  
ATOM    722  N   GLY    97      74.202  85.348 155.870  1.00 26.63           N  
ATOM    723  CA  GLY    97      73.707  86.574 156.460  1.00 27.76           C  
ATOM    724  C   GLY    97      73.912  86.744 157.953  1.00 29.04           C  
ATOM    725  O   GLY    97      73.792  87.853 158.453  1.00 29.23           O  
ATOM    726  N   ILE    98      74.214  85.663 158.671  1.00 30.03           N  
ATOM    727  CA  ILE    98      74.404  85.732 160.136  1.00 30.69           C  
ATOM    728  C   ILE    98      75.422  86.841 160.506  1.00 31.11           C  
ATOM    729  O   ILE    98      75.172  87.668 161.401  1.00 31.16           O  
ATOM    730  CB  ILE    98      74.832  84.352 160.720  1.00 30.38           C  
ATOM    731  CG1 ILE    98      73.669  83.339 160.651  1.00 32.15           C  
ATOM    732  CG2 ILE    98      75.336  84.480 162.173  1.00 32.07           C  
ATOM    733  CD1 ILE    98      74.129  81.852 160.633  1.00 30.74           C  
ATOM    734  N   ASP    99      76.553  86.851 159.804  1.00 31.56           N  
ATOM    735  CA  ASP    99      77.611  87.856 160.001  1.00 32.42           C  
ATOM    736  C   ASP    99      77.161  89.290 159.705  1.00 31.42           C  
ATOM    737  O   ASP    99      77.771  90.244 160.178  1.00 31.67           O  
ATOM    738  CB  ASP    99      78.826  87.516 159.132  1.00 33.58           C  
ATOM    739  CG  ASP    99      79.685  86.382 159.717  1.00 37.44           C  
ATOM    740  OD1 ASP    99      79.584  86.099 160.944  1.00 39.04           O  
ATOM    741  OD2 ASP    99      80.472  85.786 158.927  1.00 41.53           O  
ATOM    742  N   SER   100      76.083  89.434 158.943  1.00 30.23           N  
ATOM    743  CA  SER   100      75.492  90.737 158.682  1.00 29.66           C  
ATOM    744  C   SER   100      74.395  91.160 159.674  1.00 29.81           C  
ATOM    745  O   SER   100      73.822  92.222 159.511  1.00 31.57           O  
ATOM    746  CB  SER   100      74.931  90.788 157.253  1.00 29.18           C  
ATOM    747  OG  SER   100      75.976  90.695 156.306  1.00 28.62           O  
ATOM    748  N   LEU   101      74.086  90.354 160.681  1.00 28.76           N  
ATOM    749  CA  LEU   101      73.079  90.746 161.664  1.00 28.40           C  
ATOM    750  C   LEU   101      73.696  91.267 162.957  1.00 28.66           C  
ATOM    751  O   LEU   101      74.635  90.651 163.500  1.00 27.21           O  
ATOM    752  CB  LEU   101      72.163  89.572 162.015  1.00 28.12           C  
ATOM    753  CG  LEU   101      70.907  89.290 161.195  1.00 27.99           C  
ATOM    754  CD1 LEU   101      70.125  88.202 161.924  1.00 27.76           C  
ATOM    755  CD2 LEU   101      70.047  90.522 161.030  1.00 28.00           C  
ATOM    756  N   ASN   102      73.156  92.379 163.463  1.00 28.81           N  
ATOM    757  CA  ASN   102      73.526  92.854 164.801  1.00 29.36           C  
ATOM    758  C   ASN   102      73.030  91.901 165.893  1.00 29.27           C  
ATOM    759  O   ASN   102      72.095  91.126 165.672  1.00 28.85           O  
ATOM    760  CB  ASN   102      72.944  94.240 165.069  1.00 30.11           C  
ATOM    761  CG  ASN   102      73.452  95.300 164.094  1.00 32.51           C  
ATOM    762  OD1 ASN   102      74.610  95.259 163.637  1.00 34.10           O  
ATOM    763  ND2 ASN   102      72.593  96.276 163.793  1.00 30.65           N  
ATOM    764  N   ASP   103      73.643  91.984 167.072  1.00 29.21           N  
ATOM    765  CA  ASP   103      73.211  91.216 168.239  1.00 29.76           C  
ATOM    766  C   ASP   103      71.707  91.332 168.435  1.00 29.57           C  
ATOM    767  O   ASP   103      71.155  92.410 168.269  1.00 29.00           O  
ATOM    768  CB  ASP   103      73.897  91.757 169.505  1.00 29.66           C  
ATOM    769  CG  ASP   103      75.411  91.637 169.453  1.00 31.57           C  
ATOM    770  OD1 ASP   103      76.080  91.996 170.460  1.00 36.18           O  
ATOM    771  OD2 ASP   103      75.934  91.162 168.426  1.00 30.89           O  
ATOM    772  N   LYS   104      71.074  90.231 168.850  1.00 30.49           N  
ATOM    773  CA  LYS   104      69.618  90.156 169.117  1.00 30.56           C  
ATOM    774  C   LYS   104      68.788  90.410 167.845  1.00 29.55           C  
ATOM    775  O   LYS   104      67.591  90.683 167.922  1.00 28.41           O  
ATOM    776  CB  LYS   104      69.181  91.093 170.277  1.00 32.09           C  
ATOM    777  CG  LYS   104      69.681  90.720 171.720  1.00 34.10           C  
ATOM    778  CD  LYS   104      68.699  89.710 172.415  1.00 39.98           C  
ATOM    779  CE  LYS   104      69.035  89.366 173.903  1.00 41.01           C  
ATOM    780  NZ  LYS   104      70.146  88.351 174.163  1.00 45.27           N  
ATOM    781  N   GLY   105      69.441  90.307 166.684  1.00 29.04           N  
ATOM    782  CA  GLY   105      68.789  90.467 165.385  1.00 28.30           C  
ATOM    783  C   GLY   105      67.854  89.312 165.094  1.00 28.17           C  
ATOM    784  O   GLY   105      67.672  88.410 165.939  1.00 28.00           O  
ATOM    785  N   SER   106      67.245  89.325 163.911  1.00 27.25           N  
ATOM    786  CA  SER   106      66.358  88.232 163.520  1.00 26.99           C  
ATOM    787  C   SER   106      66.375  87.930 162.012  1.00 27.04           C  
ATOM    788  O   SER   106      66.676  88.809 161.188  1.00 27.12           O  
ATOM    789  CB  SER   106      64.929  88.520 163.975  1.00 27.32           C  
ATOM    790  OG  SER   106      64.314  89.454 163.114  1.00 25.57           O  
ATOM    791  N   PHE   107      66.101  86.668 161.678  1.00 26.57           N  
ATOM    792  CA  PHE   107      65.713  86.245 160.324  1.00 25.77           C  
ATOM    793  C   PHE   107      64.216  85.882 160.327  1.00 25.99           C  
ATOM    794  O   PHE   107      63.696  85.319 161.316  1.00 25.67           O  
ATOM    795  CB  PHE   107      66.463  84.980 159.888  1.00 25.17           C  
ATOM    796  CG  PHE   107      67.943  85.148 159.704  1.00 24.98           C  
ATOM    797  CD1 PHE   107      68.455  85.707 158.532  1.00 26.78           C  
ATOM    798  CD2 PHE   107      68.836  84.699 160.700  1.00 24.95           C  
ATOM    799  CE1 PHE   107      69.850  85.859 158.350  1.00 26.97           C  
ATOM    800  CE2 PHE   107      70.224  84.857 160.554  1.00 27.03           C  
ATOM    801  CZ  PHE   107      70.736  85.433 159.357  1.00 26.65           C  
ATOM    802  N   THR   108      63.527  86.170 159.221  1.00 25.06           N  
ATOM    803  CA  THR   108      62.152  85.716 159.035  1.00 25.07           C  
ATOM    804  C   THR   108      62.024  85.236 157.613  1.00 25.47           C  
ATOM    805  O   THR   108      62.214  86.005 156.681  1.00 27.31           O  
ATOM    806  CB  THR   108      61.134  86.836 159.278  1.00 24.34           C  
ATOM    807  OG1 THR   108      61.396  87.412 160.564  1.00 25.14           O  
ATOM    808  CG2 THR   108      59.674  86.280 159.281  1.00 22.40           C  
ATOM    809  N   LEU   109      61.666  83.979 157.444  1.00 27.11           N  
ATOM    810  CA  LEU   109      61.626  83.354 156.112  1.00 28.52           C  
ATOM    811  C   LEU   109      60.178  83.004 155.785  1.00 28.63           C  
ATOM    812  O   LEU   109      59.371  82.881 156.700  1.00 29.01           O  
ATOM    813  CB  LEU   109      62.494  82.091 156.133  1.00 29.08           C  
ATOM    814  CG  LEU   109      64.000  82.057 155.795  1.00 30.85           C  
ATOM    815  CD1 LEU   109      64.689  83.338 156.038  1.00 30.71           C  
ATOM    816  CD2 LEU   109      64.744  80.907 156.480  1.00 29.65           C  
ATOM    817  N   THR   110      59.853  82.827 154.499  1.00 28.09           N  
ATOM    818  CA  THR   110      58.492  82.482 154.068  1.00 28.41           C  
ATOM    819  C   THR   110      58.332  81.000 153.665  1.00 28.40           C  
ATOM    820  O   THR   110      59.138  80.471 152.891  1.00 28.54           O  
ATOM    821  CB  THR   110      58.048  83.366 152.861  1.00 28.39           C  
ATOM    822  OG1 THR   110      58.126  84.735 153.251  1.00 30.95           O  
ATOM    823  CG2 THR   110      56.624  83.067 152.455  1.00 27.86           C  
ATOM    824  N   THR   111      57.293  80.336 154.185  1.00 28.30           N  
ATOM    825  CA  THR   111      57.019  78.948 153.815  1.00 27.25           C  
ATOM    826  C   THR   111      55.667  78.887 153.103  1.00 27.90           C  
ATOM    827  O   THR   111      55.539  79.433 152.004  1.00 27.18           O  
ATOM    828  CB  THR   111      57.142  77.948 155.011  1.00 27.87           C  
ATOM    829  OG1 THR   111      56.303  78.347 156.095  1.00 27.34           O  
ATOM    830  CG2 THR   111      58.595  77.874 155.522  1.00 27.01           C  
ATOM    831  N   GLY   112      54.660  78.250 153.704  1.00 27.83           N  
ATOM    832  CA  GLY   112      53.378  78.088 153.002  1.00 28.14           C  
ATOM    833  C   GLY   112      52.584  76.853 153.361  1.00 27.55           C  
ATOM    834  O   GLY   112      53.152  75.810 153.713  1.00 28.59           O  
ATOM    835  N   ILE   113      51.261  76.999 153.276  1.00 27.70           N  
ATOM    836  CA  ILE   113      50.273  75.982 153.622  1.00 28.07           C  
ATOM    837  C   ILE   113      50.415  74.626 152.894  1.00 28.92           C  
ATOM    838  O   ILE   113      50.069  73.603 153.449  1.00 29.77           O  
ATOM    839  CB  ILE   113      48.812  76.535 153.438  1.00 27.86           C  
ATOM    840  CG1 ILE   113      47.809  75.673 154.245  1.00 27.79           C  
ATOM    841  CG2 ILE   113      48.448  76.666 151.929  1.00 25.50           C  
ATOM    842  CD1 ILE   113      46.405  76.294 154.400  1.00 27.83           C  
ATOM    843  N   MET   114      50.947  74.622 151.680  1.00 29.93           N  
ATOM    844  CA  MET   114      51.113  73.383 150.894  1.00 32.78           C  
ATOM    845  C   MET   114      51.845  72.241 151.580  1.00 32.46           C  
ATOM    846  O   MET   114      51.562  71.068 151.319  1.00 33.47           O  
ATOM    847  CB  MET   114      51.745  73.691 149.542  1.00 32.06           C  
ATOM    848  CG  MET   114      50.756  74.361 148.626  1.00 33.19           C  
ATOM    849  SD  MET   114      51.529  74.649 146.886  0.60 39.28          SE  
ATOM    850  CE  MET   114      52.049  76.420 147.086  1.00 26.65           C  
ATOM    851  N   MET   115      52.763  72.565 152.477  1.00 32.63           N  
ATOM    852  CA  MET   115      53.460  71.544 153.207  1.00 34.07           C  
ATOM    853  C   MET   115      52.487  70.799 154.130  1.00 34.16           C  
ATOM    854  O   MET   115      52.763  69.661 154.538  1.00 34.36           O  
ATOM    855  CB  MET   115      54.597  72.163 154.029  1.00 33.63           C  
ATOM    856  CG  MET   115      54.129  72.973 155.206  1.00 33.93           C  
ATOM    857  SD  MET   115      55.632  73.646 156.231  0.70 37.96          SE  
ATOM    858  CE  MET   115      54.615  74.982 157.229  1.00 33.39           C  
ATOM    859  N   GLU   116      51.368  71.465 154.448  1.00 34.23           N  
ATOM    860  CA  GLU   116      50.374  71.017 155.446  1.00 34.85           C  
ATOM    861  C   GLU   116      49.034  70.565 154.824  1.00 33.35           C  
ATOM    862  O   GLU   116      48.345  69.685 155.347  1.00 33.07           O  
ATOM    863  CB  GLU   116      50.092  72.192 156.397  1.00 35.66           C  
ATOM    864  CG  GLU   116      49.267  71.846 157.592  1.00 43.32           C  
ATOM    865  CD  GLU   116      50.134  71.435 158.769  1.00 52.53           C  
ATOM    866  OE1 GLU   116      49.796  71.837 159.913  1.00 55.85           O  
ATOM    867  OE2 GLU   116      51.173  70.747 158.543  1.00 55.65           O  
ATOM    868  N   ASP   117      48.649  71.211 153.728  1.00 31.58           N  
ATOM    869  CA  ASP   117      47.341  71.016 153.122  1.00 29.98           C  
ATOM    870  C   ASP   117      47.644  70.899 151.625  1.00 30.10           C  
ATOM    871  O   ASP   117      47.528  71.900 150.882  1.00 29.37           O  
ATOM    872  CB  ASP   117      46.499  72.252 153.449  1.00 30.25           C  
ATOM    873  CG  ASP   117      45.029  72.065 153.194  1.00 30.32           C  
ATOM    874  OD1 ASP   117      44.657  71.195 152.386  1.00 32.67           O  
ATOM    875  OD2 ASP   117      44.237  72.818 153.797  1.00 31.54           O  
ATOM    876  N   PRO   118      48.128  69.711 151.191  1.00 29.23           N  
ATOM    877  CA  PRO   118      48.691  69.577 149.835  1.00 29.07           C  
ATOM    878  C   PRO   118      47.689  69.646 148.678  1.00 28.01           C  
ATOM    879  O   PRO   118      46.520  69.288 148.835  1.00 27.34           O  
ATOM    880  CB  PRO   118      49.389  68.206 149.868  1.00 29.33           C  
ATOM    881  CG  PRO   118      48.718  67.448 150.938  1.00 29.37           C  
ATOM    882  CD  PRO   118      48.186  68.436 151.943  1.00 29.96           C  
ATOM    883  N   ILE   119      48.173  70.111 147.528  1.00 28.08           N  
ATOM    884  CA  ILE   119      47.369  70.257 146.313  1.00 26.60           C  
ATOM    885  C   ILE   119      48.086  69.559 145.161  1.00 27.24           C  
ATOM    886  O   ILE   119      49.309  69.308 145.217  1.00 26.94           O  
ATOM    887  CB  ILE   119      47.125  71.776 145.950  1.00 27.72           C  
ATOM    888  CG1 ILE   119      48.452  72.559 145.871  1.00 27.60           C  
ATOM    889  CG2 ILE   119      46.230  72.439 146.978  1.00 26.14           C  
ATOM    890  CD1 ILE   119      48.447  73.728 144.818  1.00 25.37           C  
ATOM    891  N   VAL   120      47.337  69.227 144.116  1.00 26.98           N  
ATOM    892  CA  VAL   120      47.945  68.699 142.901  1.00 27.63           C  
ATOM    893  C   VAL   120      48.863  69.782 142.296  1.00 27.90           C  
ATOM    894  O   VAL   120      48.525  70.965 142.309  1.00 27.91           O  
ATOM    895  CB  VAL   120      46.881  68.252 141.883  1.00 27.36           C  
ATOM    896  CG1 VAL   120      47.531  67.905 140.545  1.00 28.60           C  
ATOM    897  CG2 VAL   120      46.073  67.076 142.436  1.00 27.22           C  
ATOM    898  N   GLN   121      50.027  69.343 141.804  1.00 28.10           N  
ATOM    899  CA  GLN   121      51.118  70.183 141.283  1.00 27.54           C  
ATOM    900  C   GLN   121      51.988  70.789 142.378  1.00 27.92           C  
ATOM    901  O   GLN   121      52.966  71.491 142.067  1.00 27.38           O  
ATOM    902  CB  GLN   121      50.633  71.265 140.314  1.00 27.15           C  
ATOM    903  CG  GLN   121      49.855  70.715 139.107  1.00 28.14           C  
ATOM    904  CD  GLN   121      49.955  71.620 137.895  1.00 28.34           C  
ATOM    905  OE1 GLN   121      50.863  72.455 137.800  1.00 31.14           O  
ATOM    906  NE2 GLN   121      49.015  71.481 136.974  1.00 27.72           N  
ATOM    907  N   GLY   122      51.665  70.500 143.644  1.00 27.70           N  
ATOM    908  CA  GLY   122      52.272  71.237 144.768  1.00 28.38           C  
ATOM    909  C   GLY   122      53.429  70.558 145.469  1.00 28.72           C  
ATOM    910  O   GLY   122      53.937  71.080 146.456  1.00 30.58           O  
ATOM    911  N   ALA   123      53.871  69.400 144.977  1.00 28.79           N  
ATOM    912  CA  ALA   123      54.842  68.570 145.732  1.00 28.32           C  
ATOM    913  C   ALA   123      56.237  69.214 145.942  1.00 28.38           C  
ATOM    914  O   ALA   123      56.876  69.046 146.996  1.00 28.17           O  
ATOM    915  CB  ALA   123      54.982  67.187 145.083  1.00 26.61           C  
ATOM    916  N   SER   124      56.704  69.917 144.914  1.00 28.00           N  
ATOM    917  CA  SER   124      57.985  70.650 144.955  1.00 28.18           C  
ATOM    918  C   SER   124      57.897  71.822 145.923  1.00 27.47           C  
ATOM    919  O   SER   124      58.744  71.990 146.798  1.00 28.38           O  
ATOM    920  CB  SER   124      58.354  71.128 143.540  1.00 26.89           C  
ATOM    921  OG  SER   124      59.713  71.537 143.451  1.00 26.74           O  
ATOM    922  N   ALA   125      56.839  72.612 145.792  1.00 27.16           N  
ATOM    923  CA  ALA   125      56.578  73.691 146.724  1.00 27.52           C  
ATOM    924  C   ALA   125      56.492  73.207 148.187  1.00 26.85           C  
ATOM    925  O   ALA   125      57.084  73.804 149.083  1.00 26.79           O  
ATOM    926  CB  ALA   125      55.298  74.434 146.313  1.00 27.11           C  
ATOM    927  N   ALA   126      55.755  72.122 148.401  1.00 27.19           N  
ATOM    928  CA  ALA   126      55.613  71.490 149.730  1.00 27.11           C  
ATOM    929  C   ALA   126      56.963  71.063 150.299  1.00 26.96           C  
ATOM    930  O   ALA   126      57.259  71.338 151.466  1.00 26.27           O  
ATOM    931  CB  ALA   126      54.656  70.287 149.665  1.00 26.52           C  
ATOM    932  N   MET   127      57.801  70.445 149.468  1.00 27.45           N  
ATOM    933  CA  MET   127      59.170  70.106 149.894  1.00 29.26           C  
ATOM    934  C   MET   127      59.977  71.336 150.386  1.00 28.56           C  
ATOM    935  O   MET   127      60.629  71.280 151.444  1.00 28.62           O  
ATOM    936  CB  MET   127      59.934  69.373 148.770  1.00 29.08           C  
ATOM    937  CG  MET   127      61.465  69.358 148.936  1.00 28.64           C  
ATOM    938  SD  MET   127      62.403  69.154 147.208  0.75 36.16          SE  
ATOM    939  CE  MET   127      62.175  70.994 146.489  1.00 32.20           C  
ATOM    940  N   ALA   128      59.950  72.427 149.611  1.00 28.02           N  
ATOM    941  CA  ALA   128      60.661  73.668 149.983  1.00 26.96           C  
ATOM    942  C   ALA   128      60.188  74.226 151.344  1.00 27.32           C  
ATOM    943  O   ALA   128      61.007  74.612 152.202  1.00 26.50           O  
ATOM    944  CB  ALA   128      60.517  74.724 148.880  1.00 27.40           C  
ATOM    945  N   ASN   129      58.874  74.211 151.553  1.00 26.64           N  
ATOM    946  CA  ASN   129      58.270  74.760 152.756  1.00 27.07           C  
ATOM    947  C   ASN   129      58.595  73.912 153.982  1.00 26.72           C  
ATOM    948  O   ASN   129      58.838  74.452 155.060  1.00 27.53           O  
ATOM    949  CB  ASN   129      56.752  74.930 152.581  1.00 26.67           C  
ATOM    950  CG  ASN   129      56.398  75.968 151.517  1.00 29.08           C  
ATOM    951  OD1 ASN   129      57.255  76.771 151.089  1.00 33.20           O  
ATOM    952  ND2 ASN   129      55.154  75.931 151.046  1.00 28.50           N  
ATOM    953  N   GLY   130      58.567  72.592 153.833  1.00 25.78           N  
ATOM    954  CA  GLY   130      59.005  71.700 154.892  1.00 25.32           C  
ATOM    955  C   GLY   130      60.479  71.899 155.216  1.00 25.16           C  
ATOM    956  O   GLY   130      60.862  72.001 156.370  1.00 25.37           O  
ATOM    957  N   ALA   131      61.308  71.957 154.184  1.00 25.57           N  
ATOM    958  CA  ALA   131      62.755  72.155 154.348  1.00 26.33           C  
ATOM    959  C   ALA   131      63.084  73.432 155.136  1.00 26.35           C  
ATOM    960  O   ALA   131      63.914  73.430 156.048  1.00 26.68           O  
ATOM    961  CB  ALA   131      63.431  72.234 152.959  1.00 25.86           C  
ATOM    962  N   VAL   132      62.436  74.525 154.741  1.00 26.94           N  
ATOM    963  CA  VAL   132      62.687  75.813 155.345  1.00 26.56           C  
ATOM    964  C   VAL   132      62.150  75.857 156.793  1.00 26.67           C  
ATOM    965  O   VAL   132      62.825  76.404 157.709  1.00 26.53           O  
ATOM    966  CB  VAL   132      62.141  76.905 154.439  1.00 26.44           C  
ATOM    967  CG1 VAL   132      62.171  78.299 155.128  1.00 27.72           C  
ATOM    968  CG2 VAL   132      62.961  76.916 153.110  1.00 26.29           C  
ATOM    969  N   THR   133      60.965  75.275 157.010  1.00 25.76           N  
ATOM    970  CA  THR   133      60.386  75.195 158.372  1.00 25.92           C  
ATOM    971  C   THR   133      61.319  74.450 159.317  1.00 26.25           C  
ATOM    972  O   THR   133      61.600  74.923 160.415  1.00 27.21           O  
ATOM    973  CB  THR   133      59.022  74.443 158.362  1.00 25.31           C  
ATOM    974  OG1 THR   133      58.095  75.124 157.491  1.00 24.22           O  
ATOM    975  CG2 THR   133      58.452  74.314 159.773  1.00 25.19           C  
ATOM    976  N   ALA   134      61.756  73.253 158.910  1.00 27.08           N  
ATOM    977  CA  ALA   134      62.595  72.416 159.773  1.00 26.79           C  
ATOM    978  C   ALA   134      63.962  73.037 159.938  1.00 26.88           C  
ATOM    979  O   ALA   134      64.556  72.949 161.028  1.00 26.43           O  
ATOM    980  CB  ALA   134      62.719  71.011 159.235  1.00 27.14           C  
ATOM    981  N   PHE   135      64.462  73.686 158.876  1.00 27.35           N  
ATOM    982  CA  PHE   135      65.766  74.357 158.984  1.00 27.59           C  
ATOM    983  C   PHE   135      65.788  75.443 160.066  1.00 27.62           C  
ATOM    984  O   PHE   135      66.691  75.518 160.868  1.00 27.62           O  
ATOM    985  CB  PHE   135      66.213  74.978 157.670  1.00 26.50           C  
ATOM    986  CG  PHE   135      67.410  75.855 157.833  1.00 27.59           C  
ATOM    987  CD1 PHE   135      68.685  75.289 157.965  1.00 28.36           C  
ATOM    988  CD2 PHE   135      67.275  77.239 157.900  1.00 27.24           C  
ATOM    989  CE1 PHE   135      69.808  76.097 158.139  1.00 25.71           C  
ATOM    990  CE2 PHE   135      68.372  78.056 158.073  1.00 28.16           C  
ATOM    991  CZ  PHE   135      69.649  77.490 158.206  1.00 27.41           C  
ATOM    992  N   ALA   136      64.766  76.279 160.049  1.00 28.28           N  
ATOM    993  CA  ALA   136      64.626  77.387 160.957  1.00 28.31           C  
ATOM    994  C   ALA   136      64.379  76.948 162.404  1.00 28.70           C  
ATOM    995  O   ALA   136      64.932  77.529 163.345  1.00 29.30           O  
ATOM    996  CB  ALA   136      63.510  78.284 160.467  1.00 28.08           C  
ATOM    997  N   LYS   137      63.556  75.930 162.579  1.00 29.20           N  
ATOM    998  CA  LYS   137      63.317  75.368 163.903  1.00 29.09           C  
ATOM    999  C   LYS   137      64.621  74.955 164.580  1.00 28.56           C  
ATOM   1000  O   LYS   137      64.826  75.189 165.761  1.00 28.36           O  
ATOM   1001  CB  LYS   137      62.383  74.157 163.810  1.00 29.36           C  
ATOM   1002  CG  LYS   137      62.116  73.474 165.159  1.00 30.78           C  
ATOM   1003  CD  LYS   137      60.879  72.605 165.071  1.00 36.89           C  
ATOM   1004  CE  LYS   137      59.956  72.794 166.271  1.00 39.40           C  
ATOM   1005  NZ  LYS   137      60.437  72.106 167.469  1.00 40.74           N  
ATOM   1006  N   SER   138      65.485  74.304 163.814  1.00 28.80           N  
ATOM   1007  CA  SER   138      66.711  73.746 164.332  1.00 28.52           C  
ATOM   1008  C   SER   138      67.809  74.792 164.434  1.00 28.59           C  
ATOM   1009  O   SER   138      68.573  74.804 165.407  1.00 29.88           O  
ATOM   1010  CB  SER   138      67.151  72.607 163.433  1.00 28.20           C  
ATOM   1011  OG  SER   138      68.342  72.052 163.936  1.00 28.95           O  
ATOM   1012  N   ALA   139      67.902  75.663 163.427  1.00 28.55           N  
ATOM   1013  CA  ALA   139      68.878  76.773 163.429  1.00 27.42           C  
ATOM   1014  C   ALA   139      68.718  77.669 164.665  1.00 27.45           C  
ATOM   1015  O   ALA   139      69.698  78.220 165.183  1.00 26.17           O  
ATOM   1016  CB  ALA   139      68.758  77.587 162.177  1.00 26.12           C  
ATOM   1017  N   ALA   140      67.474  77.793 165.131  1.00 27.58           N  
ATOM   1018  CA  ALA   140      67.130  78.660 166.268  1.00 27.35           C  
ATOM   1019  C   ALA   140      67.930  78.354 167.532  1.00 27.90           C  
ATOM   1020  O   ALA   140      68.181  79.256 168.334  1.00 27.91           O  
ATOM   1021  CB  ALA   140      65.643  78.555 166.571  1.00 27.07           C  
ATOM   1022  N   ILE   141      68.308  77.093 167.724  1.00 28.66           N  
ATOM   1023  CA  ILE   141      68.983  76.683 168.983  1.00 29.50           C  
ATOM   1024  C   ILE   141      70.491  76.907 168.868  1.00 30.14           C  
ATOM   1025  O   ILE   141      71.226  76.822 169.843  1.00 29.75           O  
ATOM   1026  CB  ILE   141      68.650  75.208 169.401  1.00 30.14           C  
ATOM   1027  CG1 ILE   141      69.224  74.219 168.372  1.00 31.29           C  
ATOM   1028  CG2 ILE   141      67.112  75.029 169.636  1.00 28.75           C  
ATOM   1029  CD1 ILE   141      69.251  72.771 168.789  1.00 28.37           C  
ATOM   1030  N   GLU   142      70.943  77.228 167.667  1.00 30.33           N  
ATOM   1031  CA  GLU   142      72.349  77.492 167.469  1.00 31.64           C  
ATOM   1032  C   GLU   142      72.666  78.930 167.094  1.00 31.42           C  
ATOM   1033  O   GLU   142      73.814  79.188 166.788  1.00 31.46           O  
ATOM   1034  CB  GLU   142      72.903  76.621 166.333  1.00 32.65           C  
ATOM   1035  CG  GLU   142      73.004  75.106 166.585  1.00 33.02           C  
ATOM   1036  CD  GLU   142      73.808  74.423 165.486  1.00 32.54           C  
ATOM   1037  OE1 GLU   142      73.225  73.637 164.718  1.00 34.31           O  
ATOM   1038  OE2 GLU   142      75.019  74.714 165.372  1.00 32.66           O  
ATOM   1039  N   MET   143      71.698  79.851 167.041  1.00 30.57           N  
ATOM   1040  CA  MET   143      72.053  81.220 166.592  1.00 30.15           C  
ATOM   1041  C   MET   143      73.014  81.862 167.597  1.00 29.13           C  
ATOM   1042  O   MET   143      72.848  81.679 168.792  1.00 29.60           O  
ATOM   1043  CB  MET   143      70.829  82.120 166.390  1.00 29.98           C  
ATOM   1044  CG  MET   143      70.030  81.815 165.150  1.00 30.12           C  
ATOM   1045  SD  MET   143      71.034  82.276 163.536  0.75 36.60          SE  
ATOM   1046  CE  MET   143      69.785  81.604 162.229  1.00 31.00           C  
ATOM   1047  N   PRO   144      74.041  82.584 167.113  1.00 28.48           N  
ATOM   1048  CA  PRO   144      74.903  83.295 168.067  1.00 27.86           C  
ATOM   1049  C   PRO   144      74.323  84.651 168.412  1.00 27.84           C  
ATOM   1050  O   PRO   144      73.400  85.108 167.740  1.00 27.64           O  
ATOM   1051  CB  PRO   144      76.182  83.497 167.280  1.00 28.14           C  
ATOM   1052  CG  PRO   144      75.703  83.695 165.861  1.00 27.72           C  
ATOM   1053  CD  PRO   144      74.468  82.795 165.720  1.00 27.56           C  
ATOM   1054  N   ARG   145      74.849  85.282 169.458  1.00 27.88           N  
ATOM   1055  CA  ARG   145      74.591  86.699 169.739  1.00 27.88           C  
ATOM   1056  C   ARG   145      73.115  87.075 169.963  1.00 27.79           C  
ATOM   1057  O   ARG   145      72.728  88.233 169.794  1.00 27.11           O  
ATOM   1058  CB  ARG   145      75.254  87.579 168.654  1.00 28.24           C  
ATOM   1059  CG  ARG   145      76.797  87.485 168.691  1.00 27.24           C  
ATOM   1060  CD  ARG   145      77.477  88.351 167.620  1.00 28.22           C  
ATOM   1061  NE  ARG   145      77.182  87.989 166.226  1.00 27.87           N  
ATOM   1062  CZ  ARG   145      76.338  88.643 165.432  1.00 28.14           C  
ATOM   1063  NH1 ARG   145      76.166  88.257 164.175  1.00 30.10           N  
ATOM   1064  NH2 ARG   145      75.660  89.688 165.876  1.00 30.67           N  
ATOM   1065  N   GLY   146      72.312  86.102 170.405  1.00 27.44           N  
ATOM   1066  CA  GLY   146      70.907  86.341 170.705  1.00 26.93           C  
ATOM   1067  C   GLY   146      70.045  86.511 169.457  1.00 26.30           C  
ATOM   1068  O   GLY   146      68.929  87.050 169.522  1.00 26.44           O  
ATOM   1069  N   ILE   147      70.555  86.050 168.325  1.00 25.53           N  
ATOM   1070  CA  ILE   147      69.789  86.110 167.071  1.00 24.86           C  
ATOM   1071  C   ILE   147      68.634  85.097 167.089  1.00 24.78           C  
ATOM   1072  O   ILE   147      68.768  83.999 167.624  1.00 24.13           O  
ATOM   1073  CB  ILE   147      70.702  86.007 165.818  1.00 24.02           C  
ATOM   1074  CG1 ILE   147      71.513  87.294 165.674  1.00 23.86           C  
ATOM   1075  CG2 ILE   147      69.861  85.796 164.550  1.00 24.99           C  
ATOM   1076  CD1 ILE   147      72.889  87.135 164.966  1.00 24.20           C  
ATOM   1077  N   ARG   148      67.488  85.518 166.549  1.00 24.82           N  
ATOM   1078  CA  ARG   148      66.280  84.731 166.467  1.00 25.56           C  
ATOM   1079  C   ARG   148      65.967  84.422 165.005  1.00 26.45           C  
ATOM   1080  O   ARG   148      66.387  85.161 164.091  1.00 26.05           O  
ATOM   1081  CB  ARG   148      65.116  85.532 167.051  1.00 26.11           C  
ATOM   1082  CG  ARG   148      65.262  85.839 168.574  1.00 25.10           C  
ATOM   1083  CD  ARG   148      64.062  86.610 169.080  1.00 25.56           C  
ATOM   1084  NE  ARG   148      63.920  87.885 168.367  1.00 23.44           N  
ATOM   1085  CZ  ARG   148      62.976  88.172 167.463  1.00 24.37           C  
ATOM   1086  NH1 ARG   148      62.022  87.295 167.137  1.00 21.29           N  
ATOM   1087  NH2 ARG   148      62.992  89.364 166.870  1.00 22.75           N  
ATOM   1088  N   ILE   149      65.239  83.335 164.780  1.00 26.28           N  
ATOM   1089  CA  ILE   149      64.811  82.988 163.422  1.00 26.18           C  
ATOM   1090  C   ILE   149      63.420  82.357 163.457  1.00 26.80           C  
ATOM   1091  O   ILE   149      63.188  81.427 164.221  1.00 26.28           O  
ATOM   1092  CB  ILE   149      65.829  82.045 162.706  1.00 26.44           C  
ATOM   1093  CG1 ILE   149      65.273  81.545 161.363  1.00 26.18           C  
ATOM   1094  CG2 ILE   149      66.283  80.834 163.594  1.00 24.22           C  
ATOM   1095  CD1 ILE   149      66.388  81.090 160.447  1.00 27.20           C  
ATOM   1096  N   ASN   150      62.492  82.882 162.655  1.00 26.81           N  
ATOM   1097  CA  ASN   150      61.161  82.300 162.556  1.00 26.44           C  
ATOM   1098  C   ASN   150      60.768  82.167 161.098  1.00 26.61           C  
ATOM   1099  O   ASN   150      61.460  82.660 160.202  1.00 26.32           O  
ATOM   1100  CB  ASN   150      60.107  83.126 163.299  1.00 26.04           C  
ATOM   1101  CG  ASN   150      60.434  83.313 164.789  1.00 26.58           C  
ATOM   1102  OD1 ASN   150      60.370  82.370 165.593  1.00 28.88           O  
ATOM   1103  ND2 ASN   150      60.740  84.551 165.164  1.00 23.47           N  
ATOM   1104  N   THR   151      59.687  81.433 160.862  1.00 26.73           N  
ATOM   1105  CA  THR   151      59.098  81.354 159.536  1.00 26.71           C  
ATOM   1106  C   THR   151      57.626  81.763 159.652  1.00 26.39           C  
ATOM   1107  O   THR   151      57.017  81.672 160.742  1.00 25.33           O  
ATOM   1108  CB  THR   151      59.242  79.948 158.882  1.00 26.38           C  
ATOM   1109  OG1 THR   151      58.574  78.969 159.668  1.00 29.57           O  
ATOM   1110  CG2 THR   151      60.717  79.529 158.731  1.00 26.96           C  
ATOM   1111  N   VAL   152      57.091  82.229 158.528  1.00 25.84           N  
ATOM   1112  CA  VAL   152      55.674  82.582 158.363  1.00 25.85           C  
ATOM   1113  C   VAL   152      55.125  81.721 157.255  1.00 26.18           C  
ATOM   1114  O   VAL   152      55.683  81.683 156.145  1.00 26.66           O  
ATOM   1115  CB  VAL   152      55.499  84.066 157.989  1.00 25.76           C  
ATOM   1116  CG1 VAL   152      54.014  84.436 157.827  1.00 24.94           C  
ATOM   1117  CG2 VAL   152      56.119  84.922 159.061  1.00 26.52           C  
ATOM   1118  N   SER   153      54.032  81.023 157.546  1.00 26.57           N  
ATOM   1119  CA  SER   153      53.426  80.126 156.584  1.00 26.81           C  
ATOM   1120  C   SER   153      52.070  80.679 156.164  1.00 27.47           C  
ATOM   1121  O   SER   153      51.086  80.555 156.910  1.00 28.54           O  
ATOM   1122  CB  SER   153      53.253  78.731 157.186  1.00 26.92           C  
ATOM   1123  OG  SER   153      52.866  77.808 156.183  1.00 27.39           O  
ATOM   1124  N   PRO   154      52.009  81.324 154.984  1.00 27.74           N  
ATOM   1125  CA  PRO   154      50.736  81.842 154.479  1.00 27.92           C  
ATOM   1126  C   PRO   154      49.852  80.820 153.751  1.00 27.65           C  
ATOM   1127  O   PRO   154      50.357  79.934 153.051  1.00 26.86           O  
ATOM   1128  CB  PRO   154      51.168  82.892 153.457  1.00 28.70           C  
ATOM   1129  CG  PRO   154      52.540  82.446 152.990  1.00 28.72           C  
ATOM   1130  CD  PRO   154      53.158  81.650 154.108  1.00 27.17           C  
ATOM   1131  N   ASN   155      48.541  80.972 153.899  1.00 27.35           N  
ATOM   1132  CA  ASN   155      47.584  80.379 152.952  1.00 27.86           C  
ATOM   1133  C   ASN   155      47.739  81.147 151.625  1.00 27.91           C  
ATOM   1134  O   ASN   155      48.511  82.126 151.548  1.00 27.74           O  
ATOM   1135  CB  ASN   155      46.136  80.479 153.488  1.00 27.07           C  
ATOM   1136  CG  ASN   155      45.206  79.361 152.935  1.00 27.68           C  
ATOM   1137  OD1 ASN   155      45.385  78.870 151.824  1.00 28.19           O  
ATOM   1138  ND2 ASN   155      44.228  78.955 153.739  1.00 26.74           N  
ATOM   1139  N   VAL   156      47.038  80.701 150.583  1.00 27.77           N  
ATOM   1140  CA  VAL   156      46.952  81.467 149.337  1.00 28.36           C  
ATOM   1141  C   VAL   156      46.368  82.853 149.706  1.00 28.20           C  
ATOM   1142  O   VAL   156      45.542  82.944 150.629  1.00 27.43           O  
ATOM   1143  CB  VAL   156      46.090  80.698 148.271  1.00 28.36           C  
ATOM   1144  CG1 VAL   156      44.675  80.460 148.761  1.00 28.71           C  
ATOM   1145  CG2 VAL   156      46.055  81.426 146.958  1.00 28.96           C  
ATOM   1146  N   LEU   157      46.859  83.915 149.054  1.00 28.00           N  
ATOM   1147  CA  LEU   157      46.436  85.293 149.343  1.00 27.99           C  
ATOM   1148  C   LEU   157      45.222  85.683 148.531  1.00 28.36           C  
ATOM   1149  O   LEU   157      45.129  85.336 147.349  1.00 28.03           O  
ATOM   1150  CB  LEU   157      47.575  86.315 149.065  1.00 28.06           C  
ATOM   1151  CG  LEU   157      48.947  86.088 149.699  1.00 28.76           C  
ATOM   1152  CD1 LEU   157      49.990  87.111 149.180  1.00 28.28           C  
ATOM   1153  CD2 LEU   157      48.841  86.082 151.234  1.00 25.28           C  
ATOM   1154  N   GLU   158      44.292  86.395 149.173  1.00 28.88           N  
ATOM   1155  CA  GLU   158      43.162  87.051 148.497  1.00 29.77           C  
ATOM   1156  C   GLU   158      43.593  87.826 147.253  1.00 29.98           C  
ATOM   1157  O   GLU   158      42.920  87.802 146.214  1.00 29.81           O  
ATOM   1158  CB  GLU   158      42.459  88.009 149.444  1.00 29.09           C  
ATOM   1159  CG  GLU   158      41.609  87.320 150.501  1.00 31.90           C  
ATOM   1160  CD  GLU   158      40.891  88.296 151.422  1.00 32.37           C  
ATOM   1161  OE1 GLU   158      41.096  89.530 151.280  1.00 34.89           O  
ATOM   1162  OE2 GLU   158      40.110  87.823 152.287  1.00 35.84           O  
ATOM   1163  N   GLU   159      44.722  88.508 147.363  1.00 30.68           N  
ATOM   1164  CA  GLU   159      45.248  89.313 146.267  1.00 31.78           C  
ATOM   1165  C   GLU   159      45.688  88.475 145.058  1.00 32.45           C  
ATOM   1166  O   GLU   159      45.776  88.989 143.951  1.00 33.02           O  
ATOM   1167  CB  GLU   159      46.407  90.201 146.766  1.00 31.26           C  
ATOM   1168  CG  GLU   159      45.959  91.324 147.679  1.00 31.64           C  
ATOM   1169  CD  GLU   159      45.696  90.902 149.145  1.00 32.05           C  
ATOM   1170  OE1 GLU   159      45.914  89.725 149.527  1.00 30.32           O  
ATOM   1171  OE2 GLU   159      45.267  91.784 149.924  1.00 31.99           O  
ATOM   1172  N   SER   160      45.971  87.193 145.273  1.00 33.26           N  
ATOM   1173  CA  SER   160      46.399  86.302 144.208  1.00 34.06           C  
ATOM   1174  C   SER   160      45.300  85.328 143.800  1.00 34.70           C  
ATOM   1175  O   SER   160      45.506  84.512 142.899  1.00 34.77           O  
ATOM   1176  CB  SER   160      47.642  85.525 144.635  1.00 33.78           C  
ATOM   1177  OG  SER   160      48.610  86.394 145.190  1.00 35.39           O  
ATOM   1178  N   TRP   161      44.140  85.426 144.457  1.00 35.05           N  
ATOM   1179  CA  TRP   161      43.020  84.479 144.289  1.00 35.64           C  
ATOM   1180  C   TRP   161      42.526  84.405 142.858  1.00 37.08           C  
ATOM   1181  O   TRP   161      42.155  83.328 142.365  1.00 36.84           O  
ATOM   1182  CB  TRP   161      41.861  84.862 145.207  1.00 34.35           C  
ATOM   1183  CG  TRP   161      40.734  83.857 145.335  1.00 33.76           C  
ATOM   1184  CD1 TRP   161      39.401  84.097 145.132  1.00 32.45           C  
ATOM   1185  CD2 TRP   161      40.835  82.475 145.730  1.00 31.53           C  
ATOM   1186  NE1 TRP   161      38.670  82.950 145.363  1.00 32.32           N  
ATOM   1187  CE2 TRP   161      39.520  81.942 145.734  1.00 32.64           C  
ATOM   1188  CE3 TRP   161      41.904  81.636 146.073  1.00 31.94           C  
ATOM   1189  CZ2 TRP   161      39.245  80.604 146.081  1.00 33.12           C  
ATOM   1190  CZ3 TRP   161      41.631  80.296 146.428  1.00 32.94           C  
ATOM   1191  CH2 TRP   161      40.313  79.795 146.413  1.00 32.40           C  
ATOM   1192  N   ASP   162      42.518  85.549 142.183  1.00 38.75           N  
ATOM   1193  CA  ASP   162      41.972  85.605 140.828  1.00 40.57           C  
ATOM   1194  C   ASP   162      42.903  84.968 139.793  1.00 40.25           C  
ATOM   1195  O   ASP   162      42.520  84.792 138.654  1.00 41.45           O  
ATOM   1196  CB  ASP   162      41.541  87.038 140.440  1.00 41.67           C  
ATOM   1197  CG  ASP   162      40.012  87.251 140.538  1.00 45.20           C  
ATOM   1198  OD1 ASP   162      39.358  86.634 141.427  1.00 48.00           O  
ATOM   1199  OD2 ASP   162      39.457  88.040 139.715  1.00 48.43           O  
ATOM   1200  N   LYS   163      44.119  84.627 140.201  1.00 39.98           N  
ATOM   1201  CA  LYS   163      45.042  83.847 139.373  1.00 39.57           C  
ATOM   1202  C   LYS   163      45.200  82.380 139.851  1.00 37.72           C  
ATOM   1203  O   LYS   163      45.343  81.470 139.037  1.00 37.60           O  
ATOM   1204  CB  LYS   163      46.397  84.563 139.300  1.00 39.50           C  
ATOM   1205  CG  LYS   163      47.585  83.647 139.029  1.00 41.83           C  
ATOM   1206  CD  LYS   163      48.862  84.449 138.837  1.00 42.81           C  
ATOM   1207  CE  LYS   163      49.983  83.943 139.737  1.00 47.93           C  
ATOM   1208  NZ  LYS   163      49.698  84.227 141.188  1.00 50.55           N  
ATOM   1209  N   LEU   164      45.124  82.166 141.165  1.00 35.65           N  
ATOM   1210  CA  LEU   164      45.529  80.910 141.796  1.00 34.47           C  
ATOM   1211  C   LEU   164      44.398  79.973 142.200  1.00 33.80           C  
ATOM   1212  O   LEU   164      44.645  78.821 142.548  1.00 33.95           O  
ATOM   1213  CB  LEU   164      46.411  81.205 143.037  1.00 34.28           C  
ATOM   1214  CG  LEU   164      47.788  81.795 142.746  1.00 33.69           C  
ATOM   1215  CD1 LEU   164      48.581  81.862 144.038  1.00 34.51           C  
ATOM   1216  CD2 LEU   164      48.545  80.963 141.690  1.00 32.19           C  
ATOM   1217  N   GLU   165      43.166  80.472 142.171  1.00 33.60           N  
ATOM   1218  CA  GLU   165      41.977  79.693 142.566  1.00 33.10           C  
ATOM   1219  C   GLU   165      41.940  78.302 141.920  1.00 32.44           C  
ATOM   1220  O   GLU   165      41.680  77.316 142.613  1.00 31.34           O  
ATOM   1221  CB  GLU   165      40.690  80.476 142.261  1.00 33.45           C  
ATOM   1222  CG  GLU   165      39.396  79.811 142.709  1.00 35.66           C  
ATOM   1223  CD  GLU   165      38.824  78.793 141.716  1.00 41.20           C  
ATOM   1224  OE1 GLU   165      38.061  77.908 142.178  1.00 42.85           O  
ATOM   1225  OE2 GLU   165      39.103  78.872 140.486  1.00 41.94           O  
ATOM   1226  N   PRO   166      42.212  78.213 140.598  1.00 31.78           N  
ATOM   1227  CA  PRO   166      42.118  76.905 139.964  1.00 31.86           C  
ATOM   1228  C   PRO   166      43.047  75.854 140.585  1.00 31.31           C  
ATOM   1229  O   PRO   166      42.779  74.680 140.430  1.00 31.11           O  
ATOM   1230  CB  PRO   166      42.540  77.193 138.515  1.00 31.85           C  
ATOM   1231  CG  PRO   166      42.182  78.614 138.300  1.00 31.97           C  
ATOM   1232  CD  PRO   166      42.605  79.235 139.614  1.00 32.37           C  
ATOM   1233  N   PHE   167      44.103  76.283 141.281  1.00 30.34           N  
ATOM   1234  CA  PHE   167      45.022  75.376 141.953  1.00 30.80           C  
ATOM   1235  C   PHE   167      44.562  75.099 143.378  1.00 29.84           C  
ATOM   1236  O   PHE   167      45.033  74.139 143.998  1.00 29.14           O  
ATOM   1237  CB  PHE   167      46.445  75.972 142.042  1.00 31.12           C  
ATOM   1238  CG  PHE   167      47.173  76.042 140.714  1.00 34.05           C  
ATOM   1239  CD1 PHE   167      48.020  75.003 140.310  1.00 35.62           C  
ATOM   1240  CD2 PHE   167      47.028  77.156 139.878  1.00 35.05           C  
ATOM   1241  CE1 PHE   167      48.703  75.048 139.069  1.00 36.61           C  
ATOM   1242  CE2 PHE   167      47.701  77.212 138.620  1.00 37.84           C  
ATOM   1243  CZ  PHE   167      48.543  76.158 138.225  1.00 36.35           C  
ATOM   1244  N   PHE   168      43.668  75.942 143.900  1.00 28.91           N  
ATOM   1245  CA  PHE   168      43.342  75.925 145.345  1.00 28.98           C  
ATOM   1246  C   PHE   168      41.839  75.842 145.566  1.00 28.68           C  
ATOM   1247  O   PHE   168      41.280  76.529 146.425  1.00 29.25           O  
ATOM   1248  CB  PHE   168      43.929  77.151 146.062  1.00 28.60           C  
ATOM   1249  CG  PHE   168      45.426  77.088 146.271  1.00 30.43           C  
ATOM   1250  CD1 PHE   168      45.969  76.533 147.449  1.00 30.16           C  
ATOM   1251  CD2 PHE   168      46.305  77.591 145.301  1.00 29.81           C  
ATOM   1252  CE1 PHE   168      47.389  76.475 147.632  1.00 30.62           C  
ATOM   1253  CE2 PHE   168      47.705  77.535 145.482  1.00 27.69           C  
ATOM   1254  CZ  PHE   168      48.242  76.979 146.646  1.00 29.23           C  
ATOM   1255  N   GLU   169      41.185  74.982 144.797  1.00 28.27           N  
ATOM   1256  CA  GLU   169      39.730  74.900 144.822  1.00 28.70           C  
ATOM   1257  C   GLU   169      39.211  74.522 146.205  1.00 27.93           C  
ATOM   1258  O   GLU   169      39.628  73.503 146.760  1.00 28.49           O  
ATOM   1259  CB  GLU   169      39.223  73.951 143.747  1.00 27.95           C  
ATOM   1260  CG  GLU   169      39.253  74.617 142.390  1.00 30.84           C  
ATOM   1261  CD  GLU   169      39.099  73.651 141.252  1.00 33.19           C  
ATOM   1262  OE1 GLU   169      39.925  72.719 141.171  1.00 34.96           O  
ATOM   1263  OE2 GLU   169      38.167  73.839 140.421  1.00 35.33           O  
ATOM   1264  N   GLY   170      38.336  75.365 146.761  1.00 27.46           N  
ATOM   1265  CA  GLY   170      37.771  75.127 148.088  1.00 26.08           C  
ATOM   1266  C   GLY   170      38.629  75.610 149.253  1.00 26.14           C  
ATOM   1267  O   GLY   170      38.229  75.458 150.421  1.00 26.25           O  
ATOM   1268  N   PHE   171      39.801  76.186 148.973  1.00 26.13           N  
ATOM   1269  CA  PHE   171      40.579  76.853 150.040  1.00 26.26           C  
ATOM   1270  C   PHE   171      39.887  78.187 150.311  1.00 26.70           C  
ATOM   1271  O   PHE   171      39.094  78.661 149.486  1.00 26.33           O  
ATOM   1272  CB  PHE   171      42.021  77.153 149.608  1.00 26.10           C  
ATOM   1273  CG  PHE   171      42.957  75.978 149.674  1.00 26.33           C  
ATOM   1274  CD1 PHE   171      44.059  76.011 150.526  1.00 26.64           C  
ATOM   1275  CD2 PHE   171      42.761  74.855 148.859  1.00 25.07           C  
ATOM   1276  CE1 PHE   171      44.942  74.949 150.583  1.00 25.73           C  
ATOM   1277  CE2 PHE   171      43.623  73.786 148.909  1.00 26.13           C  
ATOM   1278  CZ  PHE   171      44.721  73.823 149.766  1.00 26.48           C  
ATOM   1279  N   LEU   172      40.178  78.779 151.460  1.00 26.77           N  
ATOM   1280  CA  LEU   172      39.725  80.120 151.754  1.00 27.65           C  
ATOM   1281  C   LEU   172      40.930  81.031 151.893  1.00 27.07           C  
ATOM   1282  O   LEU   172      41.660  80.921 152.882  1.00 27.75           O  
ATOM   1283  CB  LEU   172      38.846  80.139 153.013  1.00 27.73           C  
ATOM   1284  CG  LEU   172      38.101  81.435 153.369  1.00 28.21           C  
ATOM   1285  CD1 LEU   172      37.032  81.777 152.389  1.00 31.69           C  
ATOM   1286  CD2 LEU   172      37.516  81.350 154.786  1.00 29.69           C  
ATOM   1287  N   PRO   173      41.143  81.944 150.913  1.00 26.72           N  
ATOM   1288  CA  PRO   173      42.366  82.784 150.930  1.00 26.42           C  
ATOM   1289  C   PRO   173      42.373  83.777 152.091  1.00 26.62           C  
ATOM   1290  O   PRO   173      41.319  84.069 152.660  1.00 26.99           O  
ATOM   1291  CB  PRO   173      42.299  83.546 149.597  1.00 26.22           C  
ATOM   1292  CG  PRO   173      40.850  83.537 149.203  1.00 25.68           C  
ATOM   1293  CD  PRO   173      40.252  82.271 149.775  1.00 26.21           C  
ATOM   1294  N   VAL   174      43.550  84.289 152.428  1.00 27.21           N  
ATOM   1295  CA  VAL   174      43.722  85.240 153.533  1.00 26.74           C  
ATOM   1296  C   VAL   174      44.233  86.544 152.953  1.00 27.30           C  
ATOM   1297  O   VAL   174      44.909  86.530 151.921  1.00 27.96           O  
ATOM   1298  CB  VAL   174      44.727  84.690 154.607  1.00 26.89           C  
ATOM   1299  CG1 VAL   174      44.141  83.403 155.312  1.00 27.71           C  
ATOM   1300  CG2 VAL   174      46.112  84.436 154.007  1.00 25.68           C  
ATOM   1301  N   PRO   175      43.900  87.688 153.586  1.00 27.97           N  
ATOM   1302  CA  PRO   175      44.459  88.933 153.066  1.00 27.37           C  
ATOM   1303  C   PRO   175      45.971  88.991 153.330  1.00 27.29           C  
ATOM   1304  O   PRO   175      46.423  88.590 154.416  1.00 27.52           O  
ATOM   1305  CB  PRO   175      43.718  90.018 153.860  1.00 27.66           C  
ATOM   1306  CG  PRO   175      42.593  89.318 154.603  1.00 27.78           C  
ATOM   1307  CD  PRO   175      43.030  87.904 154.763  1.00 27.90           C  
ATOM   1308  N   ALA   176      46.739  89.475 152.346  1.00 26.80           N  
ATOM   1309  CA  ALA   176      48.171  89.767 152.531  1.00 26.82           C  
ATOM   1310  C   ALA   176      48.460  90.584 153.795  1.00 26.95           C  
ATOM   1311  O   ALA   176      49.473  90.359 154.471  1.00 26.85           O  
ATOM   1312  CB  ALA   176      48.775  90.477 151.262  1.00 26.26           C  
ATOM   1313  N   ALA   177      47.585  91.539 154.112  1.00 27.41           N  
ATOM   1314  CA  ALA   177      47.798  92.396 155.295  1.00 27.90           C  
ATOM   1315  C   ALA   177      47.721  91.605 156.595  1.00 27.75           C  
ATOM   1316  O   ALA   177      48.385  91.951 157.583  1.00 27.36           O  
ATOM   1317  CB  ALA   177      46.809  93.566 155.319  1.00 28.76           C  
ATOM   1318  N   LYS   178      46.915  90.539 156.599  1.00 27.25           N  
ATOM   1319  CA  LYS   178      46.855  89.644 157.758  1.00 27.46           C  
ATOM   1320  C   LYS   178      48.164  88.826 157.915  1.00 25.78           C  
ATOM   1321  O   LYS   178      48.661  88.674 159.017  1.00 24.76           O  
ATOM   1322  CB  LYS   178      45.605  88.765 157.682  1.00 27.38           C  
ATOM   1323  CG  LYS   178      45.332  87.917 158.914  1.00 29.99           C  
ATOM   1324  CD  LYS   178      44.134  86.987 158.637  1.00 30.78           C  
ATOM   1325  CE  LYS   178      43.800  86.094 159.835  1.00 35.73           C  
ATOM   1326  NZ  LYS   178      42.937  84.941 159.393  1.00 38.66           N  
ATOM   1327  N   VAL   179      48.714  88.338 156.800  1.00 25.07           N  
ATOM   1328  CA  VAL   179      49.996  87.630 156.762  1.00 25.31           C  
ATOM   1329  C   VAL   179      51.124  88.551 157.215  1.00 25.93           C  
ATOM   1330  O   VAL   179      51.997  88.134 157.989  1.00 26.07           O  
ATOM   1331  CB  VAL   179      50.308  87.035 155.319  1.00 25.33           C  
ATOM   1332  CG1 VAL   179      51.571  86.189 155.301  1.00 24.52           C  
ATOM   1333  CG2 VAL   179      49.155  86.179 154.846  1.00 25.95           C  
ATOM   1334  N   ALA   180      51.084  89.808 156.745  1.00 25.40           N  
ATOM   1335  CA  ALA   180      52.097  90.817 157.087  1.00 25.14           C  
ATOM   1336  C   ALA   180      52.262  91.000 158.607  1.00 25.03           C  
ATOM   1337  O   ALA   180      53.349  91.328 159.071  1.00 25.04           O  
ATOM   1338  CB  ALA   180      51.751  92.140 156.426  1.00 23.84           C  
ATOM   1339  N   ARG   181      51.180  90.807 159.366  1.00 25.41           N  
ATOM   1340  CA  ARG   181      51.222  90.921 160.838  1.00 26.72           C  
ATOM   1341  C   ARG   181      52.166  89.880 161.453  1.00 26.60           C  
ATOM   1342  O   ARG   181      52.815  90.134 162.479  1.00 27.10           O  
ATOM   1343  CB  ARG   181      49.819  90.737 161.451  1.00 26.71           C  
ATOM   1344  CG  ARG   181      48.830  91.862 161.131  1.00 28.71           C  
ATOM   1345  CD  ARG   181      47.529  91.744 161.945  1.00 28.49           C  
ATOM   1346  NE  ARG   181      46.600  92.813 161.560  1.00 30.42           N  
ATOM   1347  CZ  ARG   181      46.406  93.933 162.253  1.00 33.48           C  
ATOM   1348  NH1 ARG   181      47.047  94.132 163.403  1.00 33.02           N  
ATOM   1349  NH2 ARG   181      45.546  94.851 161.805  1.00 33.70           N  
ATOM   1350  N   ALA   182      52.224  88.704 160.841  1.00 26.25           N  
ATOM   1351  CA  ALA   182      53.003  87.602 161.398  1.00 26.81           C  
ATOM   1352  C   ALA   182      54.493  87.880 161.195  1.00 26.67           C  
ATOM   1353  O   ALA   182      55.305  87.517 162.036  1.00 26.13           O  
ATOM   1354  CB  ALA   182      52.579  86.240 160.795  1.00 25.55           C  
ATOM   1355  N   PHE   183      54.828  88.530 160.079  1.00 26.73           N  
ATOM   1356  CA  PHE   183      56.174  89.066 159.882  1.00 26.74           C  
ATOM   1357  C   PHE   183      56.520  90.105 160.950  1.00 27.20           C  
ATOM   1358  O   PHE   183      57.593  90.024 161.560  1.00 27.83           O  
ATOM   1359  CB  PHE   183      56.323  89.639 158.467  1.00 26.75           C  
ATOM   1360  CG  PHE   183      56.432  88.569 157.377  1.00 26.73           C  
ATOM   1361  CD1 PHE   183      57.674  88.070 156.999  1.00 26.99           C  
ATOM   1362  CD2 PHE   183      55.285  88.045 156.766  1.00 25.26           C  
ATOM   1363  CE1 PHE   183      57.774  87.081 156.001  1.00 29.07           C  
ATOM   1364  CE2 PHE   183      55.373  87.078 155.770  1.00 24.89           C  
ATOM   1365  CZ  PHE   183      56.626  86.588 155.391  1.00 27.08           C  
ATOM   1366  N   GLU   184      55.612  91.048 161.212  1.00 26.75           N  
ATOM   1367  CA  GLU   184      55.826  92.022 162.283  1.00 28.06           C  
ATOM   1368  C   GLU   184      56.041  91.344 163.656  1.00 27.14           C  
ATOM   1369  O   GLU   184      56.925  91.744 164.407  1.00 26.79           O  
ATOM   1370  CB  GLU   184      54.716  93.083 162.325  1.00 26.61           C  
ATOM   1371  CG  GLU   184      55.013  94.210 163.289  1.00 30.67           C  
ATOM   1372  CD  GLU   184      53.800  95.099 163.623  1.00 31.00           C  
ATOM   1373  OE1 GLU   184      52.749  94.980 162.982  1.00 35.43           O  
ATOM   1374  OE2 GLU   184      53.897  95.925 164.553  1.00 33.69           O  
ATOM   1375  N   LYS   185      55.244  90.312 163.956  1.00 27.04           N  
ATOM   1376  CA  LYS   185      55.409  89.476 165.136  1.00 27.01           C  
ATOM   1377  C   LYS   185      56.817  88.874 165.233  1.00 28.06           C  
ATOM   1378  O   LYS   185      57.440  88.873 166.323  1.00 28.16           O  
ATOM   1379  CB  LYS   185      54.402  88.330 165.109  1.00 27.15           C  
ATOM   1380  CG  LYS   185      54.185  87.647 166.456  1.00 27.26           C  
ATOM   1381  CD  LYS   185      53.266  86.469 166.251  1.00 26.34           C  
ATOM   1382  CE  LYS   185      52.707  85.946 167.541  1.00 31.80           C  
ATOM   1383  NZ  LYS   185      53.650  85.548 168.561  1.00 28.33           N  
ATOM   1384  N   SER   186      57.322  88.353 164.112  1.00 26.77           N  
ATOM   1385  CA  SER   186      58.678  87.808 164.126  1.00 27.37           C  
ATOM   1386  C   SER   186      59.719  88.912 164.371  1.00 26.57           C  
ATOM   1387  O   SER   186      60.652  88.730 165.170  1.00 25.36           O  
ATOM   1388  CB  SER   186      58.990  87.029 162.840  1.00 27.27           C  
ATOM   1389  OG  SER   186      60.324  86.537 162.884  1.00 28.67           O  
ATOM   1390  N   VAL   187      59.545  90.065 163.712  1.00 25.81           N  
ATOM   1391  CA  VAL   187      60.538  91.149 163.833  1.00 25.39           C  
ATOM   1392  C   VAL   187      60.571  91.841 165.199  1.00 25.69           C  
ATOM   1393  O   VAL   187      61.661  92.019 165.768  1.00 25.48           O  
ATOM   1394  CB  VAL   187      60.449  92.177 162.658  1.00 25.68           C  
ATOM   1395  CG1 VAL   187      61.470  93.280 162.816  1.00 25.75           C  
ATOM   1396  CG2 VAL   187      60.658  91.454 161.314  1.00 25.10           C  
ATOM   1397  N   PHE   188      59.400  92.208 165.732  1.00 25.07           N  
ATOM   1398  CA  PHE   188      59.310  93.034 166.940  1.00 25.59           C  
ATOM   1399  C   PHE   188      59.056  92.250 168.210  1.00 25.80           C  
ATOM   1400  O   PHE   188      59.178  92.791 169.326  1.00 25.49           O  
ATOM   1401  CB  PHE   188      58.272  94.172 166.757  1.00 25.70           C  
ATOM   1402  CG  PHE   188      58.709  95.190 165.743  1.00 28.12           C  
ATOM   1403  CD1 PHE   188      59.617  96.172 166.087  1.00 29.21           C  
ATOM   1404  CD2 PHE   188      58.312  95.089 164.414  1.00 28.34           C  
ATOM   1405  CE1 PHE   188      60.069  97.098 165.131  1.00 30.52           C  
ATOM   1406  CE2 PHE   188      58.770  96.009 163.443  1.00 27.97           C  
ATOM   1407  CZ  PHE   188      59.644  97.000 163.805  1.00 28.57           C  
ATOM   1408  N   GLY   189      58.702  90.975 168.039  1.00 25.53           N  
ATOM   1409  CA  GLY   189      58.512  90.078 169.169  1.00 25.82           C  
ATOM   1410  C   GLY   189      59.839  89.501 169.620  1.00 25.64           C  
ATOM   1411  O   GLY   189      60.902  89.923 169.143  1.00 26.52           O  
ATOM   1412  N   ALA   190      59.783  88.531 170.528  1.00 25.06           N  
ATOM   1413  CA  ALA   190      60.993  87.938 171.102  1.00 25.22           C  
ATOM   1414  C   ALA   190      61.068  86.398 170.955  1.00 25.59           C  
ATOM   1415  O   ALA   190      61.878  85.735 171.637  1.00 24.73           O  
ATOM   1416  CB  ALA   190      61.127  88.348 172.583  1.00 25.07           C  
ATOM   1417  N   GLN   191      60.239  85.826 170.080  1.00 25.26           N  
ATOM   1418  CA  GLN   191      60.155  84.364 170.004  1.00 26.40           C  
ATOM   1419  C   GLN   191      61.125  83.848 168.963  1.00 26.95           C  
ATOM   1420  O   GLN   191      61.536  84.599 168.073  1.00 28.17           O  
ATOM   1421  CB  GLN   191      58.735  83.895 169.671  1.00 25.78           C  
ATOM   1422  CG  GLN   191      57.707  84.184 170.732  1.00 26.54           C  
ATOM   1423  CD  GLN   191      56.273  83.896 170.300  1.00 27.80           C  
ATOM   1424  OE1 GLN   191      55.995  83.381 169.184  1.00 28.88           O  
ATOM   1425  NE2 GLN   191      55.344  84.259 171.171  1.00 27.31           N  
ATOM   1426  N   THR   192      61.474  82.569 169.049  1.00 26.92           N  
ATOM   1427  CA  THR   192      62.391  81.971 168.086  1.00 26.53           C  
ATOM   1428  C   THR   192      62.063  80.504 167.753  1.00 26.55           C  
ATOM   1429  O   THR   192      61.501  79.774 168.578  1.00 25.66           O  
ATOM   1430  CB  THR   192      63.885  82.150 168.526  1.00 26.29           C  
ATOM   1431  OG1 THR   192      64.751  81.913 167.406  1.00 26.86           O  
ATOM   1432  CG2 THR   192      64.255  81.247 169.691  1.00 25.27           C  
ATOM   1433  N   GLY   193      62.417  80.079 166.545  1.00 25.43           N  
ATOM   1434  CA  GLY   193      62.176  78.706 166.131  1.00 26.08           C  
ATOM   1435  C   GLY   193      60.713  78.389 165.860  1.00 26.87           C  
ATOM   1436  O   GLY   193      60.334  77.209 165.724  1.00 27.01           O  
ATOM   1437  N   GLU   194      59.893  79.432 165.761  1.00 27.25           N  
ATOM   1438  CA  GLU   194      58.459  79.268 165.499  1.00 27.78           C  
ATOM   1439  C   GLU   194      58.100  79.291 164.018  1.00 27.44           C  
ATOM   1440  O   GLU   194      58.802  79.886 163.191  1.00 27.24           O  
ATOM   1441  CB  GLU   194      57.651  80.359 166.190  1.00 28.49           C  
ATOM   1442  CG  GLU   194      57.958  80.530 167.692  1.00 31.75           C  
ATOM   1443  CD  GLU   194      57.503  79.344 168.521  1.00 36.75           C  
ATOM   1444  OE1 GLU   194      56.539  78.665 168.120  1.00 36.63           O  
ATOM   1445  OE2 GLU   194      58.106  79.088 169.581  1.00 41.39           O  
ATOM   1446  N   SER   195      56.963  78.673 163.724  1.00 27.04           N  
ATOM   1447  CA  SER   195      56.339  78.722 162.430  1.00 28.18           C  
ATOM   1448  C   SER   195      54.971  79.407 162.644  1.00 27.83           C  
ATOM   1449  O   SER   195      54.056  78.839 163.249  1.00 26.88           O  
ATOM   1450  CB  SER   195      56.153  77.281 161.917  1.00 28.75           C  
ATOM   1451  OG  SER   195      55.373  77.254 160.725  1.00 29.89           O  
ATOM   1452  N   TYR   196      54.834  80.619 162.138  1.00 26.76           N  
ATOM   1453  CA  TYR   196      53.598  81.359 162.296  1.00 27.55           C  
ATOM   1454  C   TYR   196      52.660  81.063 161.117  1.00 28.47           C  
ATOM   1455  O   TYR   196      52.894  81.537 160.010  1.00 28.15           O  
ATOM   1456  CB  TYR   196      53.934  82.838 162.366  1.00 27.66           C  
ATOM   1457  CG  TYR   196      54.767  83.226 163.571  1.00 27.83           C  
ATOM   1458  CD1 TYR   196      54.441  82.756 164.861  1.00 28.25           C  
ATOM   1459  CD2 TYR   196      55.859  84.075 163.429  1.00 27.61           C  
ATOM   1460  CE1 TYR   196      55.193  83.131 165.976  1.00 26.08           C  
ATOM   1461  CE2 TYR   196      56.631  84.460 164.531  1.00 28.24           C  
ATOM   1462  CZ  TYR   196      56.279  83.989 165.803  1.00 28.36           C  
ATOM   1463  OH  TYR   196      57.026  84.404 166.892  1.00 30.86           O  
ATOM   1464  N   GLN   197      51.629  80.256 161.350  1.00 28.97           N  
ATOM   1465  CA  GLN   197      50.691  79.903 160.300  1.00 30.42           C  
ATOM   1466  C   GLN   197      49.650  80.995 160.186  1.00 30.12           C  
ATOM   1467  O   GLN   197      49.078  81.422 161.207  1.00 29.90           O  
ATOM   1468  CB  GLN   197      49.981  78.571 160.605  1.00 30.06           C  
ATOM   1469  CG  GLN   197      50.909  77.415 160.925  1.00 32.19           C  
ATOM   1470  CD  GLN   197      50.195  76.275 161.692  1.00 35.31           C  
ATOM   1471  OE1 GLN   197      49.368  76.524 162.578  1.00 41.81           O  
ATOM   1472  NE2 GLN   197      50.525  75.026 161.356  1.00 36.84           N  
ATOM   1473  N   VAL   198      49.392  81.450 158.959  1.00 28.33           N  
ATOM   1474  CA  VAL   198      48.281  82.354 158.739  1.00 29.20           C  
ATOM   1475  C   VAL   198      47.370  81.698 157.703  1.00 29.40           C  
ATOM   1476  O   VAL   198      47.506  81.923 156.510  1.00 29.57           O  
ATOM   1477  CB  VAL   198      48.723  83.792 158.307  1.00 29.44           C  
ATOM   1478  CG1 VAL   198      47.512  84.711 158.258  1.00 28.69           C  
ATOM   1479  CG2 VAL   198      49.780  84.385 159.302  1.00 29.55           C  
ATOM   1480  N   TYR   199      46.465  80.860 158.188  1.00 30.45           N  
ATOM   1481  CA  TYR   199      45.725  79.931 157.336  1.00 31.50           C  
ATOM   1482  C   TYR   199      44.236  80.245 157.291  1.00 32.19           C  
ATOM   1483  O   TYR   199      43.690  80.826 158.258  1.00 32.13           O  
ATOM   1484  CB  TYR   199      45.893  78.481 157.823  1.00 31.61           C  
ATOM   1485  CG  TYR   199      47.281  77.875 157.663  1.00 31.88           C  
ATOM   1486  CD1 TYR   199      48.251  78.447 156.810  1.00 29.09           C  
ATOM   1487  CD2 TYR   199      47.603  76.695 158.327  1.00 29.78           C  
ATOM   1488  CE1 TYR   199      49.497  77.860 156.658  1.00 31.97           C  
ATOM   1489  CE2 TYR   199      48.857  76.102 158.183  1.00 30.54           C  
ATOM   1490  CZ  TYR   199      49.801  76.681 157.356  1.00 32.26           C  
ATOM   1491  OH  TYR   199      51.049  76.072 157.238  1.00 33.82           O  
ATOM   1492  OXT TYR   199      43.567  79.870 156.297  1.00 32.08           O  
END
