
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 1952),  selected  260 , name 1h5q_F
# Molecule2: number of CA atoms  199 ( 1473),  selected  199 , name T0433.pdb
# PARAMETERS: 1h5q_F.T0433.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     3_F      -       -           -
LGA    G     4_F      -       -           -
LGA    F     5_F      -       -           -
LGA    T     6_F      -       -           -
LGA    I     7_F      -       -           -
LGA    S     8_F      -       -           -
LGA    F     9_F      -       -           -
LGA    V    10_F      -       -           -
LGA    N    11_F      -       -           -
LGA    K    12_F      M       1          1.363
LGA    T    13_F      K       2          1.314
LGA    I    14_F      I       3          0.805
LGA    I    15_F      L       4          1.109
LGA    V    16_F      L       5          1.456
LGA    T    17_F      I       6          1.493
LGA    G    18_F      G       7          1.324
LGA    G    19_F      A       8          1.370
LGA    N    20_F      S       9          0.722
LGA    R    21_F      G      10          1.495
LGA    G    22_F      T      11          1.037
LGA    I    23_F      L      12          0.557
LGA    G    24_F      G      13          1.121
LGA    L    25_F      S      14          1.151
LGA    A    26_F      A      15          0.951
LGA    F    27_F      V      16          0.868
LGA    T    28_F      K      17          1.399
LGA    R    29_F      E      18          1.596
LGA    A    30_F      R      19          1.239
LGA    V    31_F      L      20          0.469
LGA    A    32_F      E      21          0.577
LGA    A    33_F      K      22          2.044
LGA    A    34_F      K      23          2.527
LGA    G    35_F      -       -           -
LGA    A    36_F      A      24          1.591
LGA    N    37_F      E      25          1.518
LGA    V    38_F      V      26          1.529
LGA    A    39_F      I      27          1.849
LGA    V    40_F      T      28          1.761
LGA    I    41_F      A      29          1.820
LGA    Y    42_F      G      30          1.331
LGA    R    43_F      R      31          1.722
LGA    S    44_F      H      32          3.458
LGA    A    45_F      -       -           -
LGA    A    46_F      -       -           -
LGA    D    47_F      -       -           -
LGA    A    48_F      -       -           -
LGA    V    49_F      S      33          3.782
LGA    E    50_F      -       -           -
LGA    V    51_F      -       -           -
LGA    T    52_F      -       -           -
LGA    E    53_F      -       -           -
LGA    K    54_F      -       -           -
LGA    V    55_F      -       -           -
LGA    G    56_F      -       -           -
LGA    K    57_F      -       -           -
LGA    E    58_F      -       -           -
LGA    F    59_F      -       -           -
LGA    G    60_F      -       -           -
LGA    V    61_F      -       -           -
LGA    K    62_F      -       -           -
LGA    T    63_F      -       -           -
LGA    K    64_F      G      34          4.748
LGA    A    65_F      D      35          2.450
LGA    Y    66_F      V      36          1.799
LGA    Q    67_F      T      37          1.766
LGA    C    68_F      V      38          0.598
LGA    D    69_F      D      39          0.668
LGA    V    70_F      I      40          0.813
LGA    S    71_F      T      41          1.523
LGA    N    72_F      N      42          1.115
LGA    T    73_F      I      43          1.030
LGA    D    74_F      D      44          1.220
LGA    I    75_F      S      45          1.080
LGA    V    76_F      I      46          0.574
LGA    T    77_F      K      47          1.095
LGA    K    78_F      K      48          1.260
LGA    T    79_F      M      49          0.451
LGA    I    80_F      Y      50          1.019
LGA    Q    81_F      E      51          1.710
LGA    Q    82_F      Q      52          0.715
LGA    I    83_F      V      53          1.079
LGA    D    84_F      G      54          1.660
LGA    A    85_F      -       -           -
LGA    D    86_F      -       -           -
LGA    L    87_F      -       -           -
LGA    G    88_F      -       -           -
LGA    P    89_F      K      55          3.906
LGA    I    90_F      V      56          0.501
LGA    S    91_F      D      57          0.968
LGA    G    92_F      A      58          0.432
LGA    L    93_F      I      59          1.187
LGA    I    94_F      V      60          1.061
LGA    A    95_F      S      61          1.640
LGA    N    96_F      A      62          1.835
LGA    A    97_F      T      63          0.763
LGA    G    98_F      G      64          1.924
LGA    V    99_F      S      65          1.389
LGA    S   100_F      A      66          2.412
LGA    V   101_F      T      67          1.925
LGA    V   102_F      F      68          1.979
LGA    K   103_F      S      69          1.725
LGA    P   104_F      P      70          1.264
LGA    A   105_F      L      71          0.569
LGA    T   106_F      T      72          1.345
LGA    E   107_F      E      73          0.913
LGA    L   108_F      L      74          1.037
LGA    T   109_F      T      75          1.695
LGA    H   110_F      P      76          2.055
LGA    E   111_F      E      77          2.130
LGA    D   112_F      K      78          1.201
LGA    F   113_F      N      79          1.134
LGA    A   114_F      A      80          1.370
LGA    F   115_F      V      81          0.856
LGA    V   116_F      T      82          0.685
LGA    Y   117_F      I      83          1.201
LGA    D   118_F      S      84          0.937
LGA    V   119_F      S      85          0.983
LGA    N   120_F      K      86          1.239
LGA    V   121_F      L      87          1.500
LGA    F   122_F      G      88          1.050
LGA    G   123_F      G      89          0.698
LGA    V   124_F      Q      90          0.939
LGA    F   125_F      I      91          1.243
LGA    N   126_F      N      92          1.054
LGA    T   127_F      L      93          0.818
LGA    C   128_F      V      94          1.384
LGA    R   129_F      L      95          1.956
LGA    A   130_F      L      96          2.176
LGA    V   131_F      G      97          2.002
LGA    A   132_F      I      98          0.551
LGA    K   133_F      D      99          1.986
LGA    L   134_F      S     100          2.412
LGA    W   135_F      L     101          3.117
LGA    L   136_F      -       -           -
LGA    Q   137_F      -       -           -
LGA    K   138_F      -       -           -
LGA    Q   139_F      N     102           #
LGA    Q   140_F      D     103          2.693
LGA    K   141_F      K     104          2.737
LGA    G   142_F      G     105          0.476
LGA    S   143_F      S     106          0.964
LGA    I   144_F      F     107          1.066
LGA    V   145_F      T     108          0.947
LGA    V   146_F      L     109          0.905
LGA    T   147_F      T     110          0.905
LGA    S   148_F      T     111          0.867
LGA    S   149_F      G     112          1.047
LGA    M   150_F      I     113          1.996
LGA    S   151_F      M     114          1.967
LGA    S   152_F      M     115          2.445
LGA    Q   153_F      E     116          2.254
LGA    I   154_F      D     117          2.826
LGA    I   155_F      P     118          0.806
LGA    N   156_F      I     119          2.752
LGA    Q   157_F      -       -           -
LGA    S   158_F      -       -           -
LGA    S   159_F      -       -           -
LGA    L   160_F      -       -           -
LGA    N   161_F      -       -           -
LGA    G   162_F      -       -           -
LGA    S   163_F      -       -           -
LGA    L   164_F      V     120          2.473
LGA    T   165_F      Q     121          1.583
LGA    Q   166_F      G     122          2.087
LGA    V   167_F      A     123          0.715
LGA    F   168_F      S     124          0.562
LGA    Y   169_F      A     125          0.489
LGA    N   170_F      A     126          0.666
LGA    S   171_F      M     127          1.061
LGA    S   172_F      A     128          0.921
LGA    K   173_F      N     129          0.417
LGA    A   174_F      G     130          0.450
LGA    A   175_F      A     131          0.519
LGA    C   176_F      V     132          0.646
LGA    S   177_F      T     133          0.134
LGA    N   178_F      A     134          0.393
LGA    L   179_F      F     135          0.747
LGA    V   180_F      A     136          0.391
LGA    K   181_F      K     137          1.637
LGA    G   182_F      S     138          2.521
LGA    L   183_F      A     139          1.765
LGA    A   184_F      A     140          1.201
LGA    A   185_F      I     141          2.089
LGA    E   186_F      E     142          1.661
LGA    W   187_F      M     143          0.637
LGA    A   188_F      -       -           -
LGA    S   189_F      P     144          4.312
LGA    A   190_F      R     145          2.091
LGA    G   191_F      G     146          0.575
LGA    I   192_F      I     147          0.593
LGA    R   193_F      R     148          0.415
LGA    V   194_F      I     149          0.454
LGA    N   195_F      N     150          0.681
LGA    A   196_F      T     151          0.963
LGA    L   197_F      V     152          0.830
LGA    S   198_F      S     153          0.642
LGA    P   199_F      P     154          0.832
LGA    G   200_F      N     155          1.264
LGA    Y   201_F      V     156          2.085
LGA    V   202_F      L     157          1.067
LGA    N   203_F      E     158          1.977
LGA    T   204_F      E     159          2.749
LGA    D   205_F      S     160          4.369
LGA    Q   206_F      -       -           -
LGA    T   207_F      W     161          2.891
LGA    A   208_F      D     162          2.034
LGA    H   209_F      K     163          3.082
LGA    M   210_F      L     164          4.151
LGA    D   211_F      E     165          5.379
LGA    K   212_F      -       -           -
LGA    K   213_F      -       -           -
LGA    I   214_F      P     166          2.702
LGA    R   215_F      F     167           #
LGA    D   216_F      F     168           #
LGA    H   217_F      E     169          2.704
LGA    Q   218_F      G     170          2.551
LGA    A   219_F      F     171          3.315
LGA    S   220_F      -       -           -
LGA    N   221_F      -       -           -
LGA    I   222_F      -       -           -
LGA    P   223_F      -       -           -
LGA    L   224_F      -       -           -
LGA    N   225_F      -       -           -
LGA    R   226_F      L     172          3.671
LGA    F   227_F      P     173          1.310
LGA    A   228_F      V     174          1.007
LGA    Q   229_F      P     175          1.153
LGA    P   230_F      A     176          0.501
LGA    E   231_F      A     177          0.526
LGA    E   232_F      K     178          0.503
LGA    M   233_F      V     179          0.858
LGA    T   234_F      A     180          1.600
LGA    G   235_F      R     181          1.557
LGA    Q   236_F      A     182          1.806
LGA    A   237_F      F     183          1.338
LGA    I   238_F      E     184          1.005
LGA    L   239_F      K     185          1.798
LGA    L   240_F      S     186          1.474
LGA    L   241_F      V     187          0.818
LGA    S   242_F      F     188          1.251
LGA    D   243_F      -       -           -
LGA    H   244_F      G     189          3.448
LGA    A   245_F      A     190          1.564
LGA    T   246_F      -       -           -
LGA    Y   247_F      -       -           -
LGA    M   248_F      Q     191          1.486
LGA    T   249_F      T     192          1.044
LGA    G   250_F      G     193          0.966
LGA    G   251_F      E     194          1.253
LGA    E   252_F      S     195          0.864
LGA    Y   253_F      Y     196          1.219
LGA    F   254_F      Q     197          0.656
LGA    I   255_F      V     198          0.742
LGA    D   256_F      Y     199          0.490
LGA    G   257_F      -       -           -
LGA    G   258_F      -       -           -
LGA    Q   259_F      -       -           -
LGA    L   260_F      -       -           -
LGA    I   261_F      -       -           -
LGA    W   262_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  199    5.0    196    1.72    20.41     89.652    10.742

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.736827 * X  +  -0.647820 * Y  +  -0.193431 * Z  +  32.195789
  Y_new =  -0.123256 * X  +  -0.410027 * Y  +   0.903707 * Z  +  33.912670
  Z_new =  -0.664751 * X  +  -0.642034 * Y  +  -0.381967 * Z  + 223.856949 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.107481    1.034111  [ DEG:  -120.7498     59.2502 ]
  Theta =   0.727161    2.414432  [ DEG:    41.6632    138.3367 ]
  Phi   =  -0.165746    2.975847  [ DEG:    -9.4965    170.5035 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1h5q_F                                        
REMARK     2: T0433.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1h5q_F.T0433.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  199   5.0  196   1.72   20.41  89.652
REMARK  ---------------------------------------------------------- 
MOLECULE 1h5q_F
HEADER    OXIDOREDUCTASE                          24-MAY-01   1H5Q              
TITLE     MANNITOL DEHYDROGENASE FROM AGARICUS BISPORUS                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NADP-DEPENDENT MANNITOL DEHYDROGENASE;                     
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: MTDH, MANNITOL 2-DEHYDROGENASE [NADP+];                     
COMPND   5 EC: 1.1.1.138;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGARICUS BISPORUS;                              
SOURCE   3 ORGANISM_COMMON: COMMON MUSHROOM;                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PET28                                     
KEYWDS    OXIDOREDUCTASE, MANNITOL METABOLISM                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.HORER,J.STOOP,H.MOOIBROEK,U.BAUMANN,J.SASSOON                       
REVDAT   6   26-JUN-07 1H5Q    1       REMARK                                   
REVDAT   5   07-JUN-06 1H5Q    1       REMARK                                   
REVDAT   4   18-JUL-03 1H5Q    1       REMARK                                   
REVDAT   3   23-NOV-01 1H5Q    1       JRNL   LINK                              
REVDAT   2   16-AUG-01 1H5Q    1       SHEET                                    
REVDAT   1   21-JUN-01 1H5Q    0                                                
JRNL        AUTH   S.HORER,J.STOOP,H.MOOIBROEK,U.BAUMANN,J.SASSOON              
JRNL        TITL   THE CRYSTALLOGRAPHIC STRUCTURE OF THE MANNITOL               
JRNL        TITL 2 2-DEHYDROGENASE NADP+ BINARY COMPLEX FROM AGARICUS           
JRNL        TITL 3 BISPORUS                                                     
JRNL        REF    J.BIOL.CHEM.                  V. 276 27555 2001              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1H5Q A   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q A    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q B   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q B    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q C   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q C    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q D   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q D    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q E   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q E    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q F   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q F    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q G   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q G    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q H   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q H    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q I   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q I    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q J   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q J    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q K   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q K    2   262  UNP    O93868   MTDH_AGABI       1    261             
DBREF  1H5Q L   -2     1  PDB    1H5Q     1H5Q            -2      1             
DBREF  1H5Q L    2   262  UNP    O93868   MTDH_AGABI       1    261             
SEQRES   1 A  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 A  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 A  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 A  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 A  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 A  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 A  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 A  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 A  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 A  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 A  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 A  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 A  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 A  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 A  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 A  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 A  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 A  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 A  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 A  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 A  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 B  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 B  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 B  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 B  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 B  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 B  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 B  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 B  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 B  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 B  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 B  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 B  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 B  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 B  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 B  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 B  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 B  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 B  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 B  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 B  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 B  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 C  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 C  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 C  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 C  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 C  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 C  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 C  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 C  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 C  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 C  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 C  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 C  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 C  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 C  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 C  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 C  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 C  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 C  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 C  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 C  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 C  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 D  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 D  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 D  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 D  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 D  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 D  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 D  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 D  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 D  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 D  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 D  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 D  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 D  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 D  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 D  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 D  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 D  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 D  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 D  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 D  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 D  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 E  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 E  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 E  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 E  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 E  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 E  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 E  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 E  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 E  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 E  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 E  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 E  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 E  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 E  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 E  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 E  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 E  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 E  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 E  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 E  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 E  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 F  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 F  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 F  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 F  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 F  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 F  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 F  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 F  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 F  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 F  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 F  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 F  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 F  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 F  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 F  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 F  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 F  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 F  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 F  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 F  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 F  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 G  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 G  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 G  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 G  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 G  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 G  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 G  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 G  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 G  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 G  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 G  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 G  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 G  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 G  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 G  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 G  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 G  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 G  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 G  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 G  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 G  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 H  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 H  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 H  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 H  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 H  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 H  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 H  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 H  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 H  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 H  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 H  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 H  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 H  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 H  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 H  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 H  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 H  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 H  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 H  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 H  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 H  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 I  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 I  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 I  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 I  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 I  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 I  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 I  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 I  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 I  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 I  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 I  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 I  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 I  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 I  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 I  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 I  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 I  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 I  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 I  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 I  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 I  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 J  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 J  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 J  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 J  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 J  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 J  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 J  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 J  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 J  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 J  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 J  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 J  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 J  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 J  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 J  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 J  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 J  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 J  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 J  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 J  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 J  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 K  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 K  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 K  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 K  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 K  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 K  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 K  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 K  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 K  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 K  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 K  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 K  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 K  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 K  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 K  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 K  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 K  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 K  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 K  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 K  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 K  265  GLY GLN LEU ILE TRP                                          
SEQRES   1 L  265  GLY SER HIS MET ALA PRO GLY PHE THR ILE SER PHE VAL          
SEQRES   2 L  265  ASN LYS THR ILE ILE VAL THR GLY GLY ASN ARG GLY ILE          
SEQRES   3 L  265  GLY LEU ALA PHE THR ARG ALA VAL ALA ALA ALA GLY ALA          
SEQRES   4 L  265  ASN VAL ALA VAL ILE TYR ARG SER ALA ALA ASP ALA VAL          
SEQRES   5 L  265  GLU VAL THR GLU LYS VAL GLY LYS GLU PHE GLY VAL LYS          
SEQRES   6 L  265  THR LYS ALA TYR GLN CYS ASP VAL SER ASN THR ASP ILE          
SEQRES   7 L  265  VAL THR LYS THR ILE GLN GLN ILE ASP ALA ASP LEU GLY          
SEQRES   8 L  265  PRO ILE SER GLY LEU ILE ALA ASN ALA GLY VAL SER VAL          
SEQRES   9 L  265  VAL LYS PRO ALA THR GLU LEU THR HIS GLU ASP PHE ALA          
SEQRES  10 L  265  PHE VAL TYR ASP VAL ASN VAL PHE GLY VAL PHE ASN THR          
SEQRES  11 L  265  CYS ARG ALA VAL ALA LYS LEU TRP LEU GLN LYS GLN GLN          
SEQRES  12 L  265  LYS GLY SER ILE VAL VAL THR SER SER MET SER SER GLN          
SEQRES  13 L  265  ILE ILE ASN GLN SER SER LEU ASN GLY SER LEU THR GLN          
SEQRES  14 L  265  VAL PHE TYR ASN SER SER LYS ALA ALA CYS SER ASN LEU          
SEQRES  15 L  265  VAL LYS GLY LEU ALA ALA GLU TRP ALA SER ALA GLY ILE          
SEQRES  16 L  265  ARG VAL ASN ALA LEU SER PRO GLY TYR VAL ASN THR ASP          
SEQRES  17 L  265  GLN THR ALA HIS MET ASP LYS LYS ILE ARG ASP HIS GLN          
SEQRES  18 L  265  ALA SER ASN ILE PRO LEU ASN ARG PHE ALA GLN PRO GLU          
SEQRES  19 L  265  GLU MET THR GLY GLN ALA ILE LEU LEU LEU SER ASP HIS          
SEQRES  20 L  265  ALA THR TYR MET THR GLY GLY GLU TYR PHE ILE ASP GLY          
SEQRES  21 L  265  GLY GLN LEU ILE TRP                                          
HET     NI  A2263       1                                                       
HET     NI  B2263       1                                                       
HET     NI  E2263       1                                                       
HET     NI  F2263       1                                                       
HET     NI  I2263       1                                                       
HET     NI  J2263       1                                                       
HET    NAP  A 263      48                                                       
HET    NAP  B 263      48                                                       
HET    NAP  C 263      48                                                       
HET    NAP  D 263      48                                                       
HET    NAP  E 263      48                                                       
HET    NAP  F 263      48                                                       
HET    NAP  G 263      48                                                       
HET    NAP  H 263      48                                                       
HET    NAP  I 263      48                                                       
HET    NAP  J 263      48                                                       
HET    NAP  K 263      48                                                       
HET    NAP  L 263      48                                                       
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     NAP NADP NICOTINAMIDE-ADENINE-DINUCLEOTIDE PHOSPHATE                 
HETSYN     NAP 2'-MONOPHOSPHOADENOSINE 5'-DIPHOSPHORIBOSE                       
FORMUL  13   NI    6(NI 2+)                                                     
FORMUL  19  NAP    12(C21 H28 N7 O17 P3)                                        
FORMUL  31  HOH   *3191(H2 O)                                                   
CRYST1  227.250  124.850  132.690  90.00 118.54  90.00 C 1 2 1      48          
ATOM   9766  N   PRO F   3      47.557 105.163 176.147  1.00 34.80           N  
ATOM   9767  CA  PRO F   3      47.897 103.722 176.259  1.00 33.75           C  
ATOM   9768  C   PRO F   3      47.931 103.051 174.901  1.00 32.89           C  
ATOM   9769  O   PRO F   3      47.488 103.623 173.901  1.00 34.70           O  
ATOM   9770  CB  PRO F   3      46.736 103.170 177.093  1.00 33.49           C  
ATOM   9771  CG  PRO F   3      45.678 104.185 176.959  1.00 34.96           C  
ATOM   9772  CD  PRO F   3      46.418 105.499 177.015  1.00 35.28           C  
ATOM   9773  N   GLY F   4      48.466 101.837 174.861  1.00 31.17           N  
ATOM   9774  CA  GLY F   4      48.566 101.095 173.625  1.00 29.52           C  
ATOM   9775  C   GLY F   4      49.801 100.223 173.609  1.00 28.45           C  
ATOM   9776  O   GLY F   4      50.757 100.463 174.349  1.00 29.60           O  
ATOM   9777  N   PHE F   5      49.752  99.194 172.775  1.00 27.51           N  
ATOM   9778  CA  PHE F   5      50.863  98.286 172.561  1.00 26.43           C  
ATOM   9779  C   PHE F   5      51.533  98.793 171.296  1.00 26.70           C  
ATOM   9780  O   PHE F   5      50.927  98.784 170.232  1.00 27.47           O  
ATOM   9781  CB  PHE F   5      50.321  96.871 172.349  1.00 25.58           C  
ATOM   9782  CG  PHE F   5      51.355  95.862 171.932  1.00 24.33           C  
ATOM   9783  CD1 PHE F   5      52.184  95.273 172.870  1.00 24.99           C  
ATOM   9784  CD2 PHE F   5      51.481  95.480 170.602  1.00 23.54           C  
ATOM   9785  CE1 PHE F   5      53.128  94.335 172.500  1.00 24.02           C  
ATOM   9786  CE2 PHE F   5      52.418  94.524 170.222  1.00 24.42           C  
ATOM   9787  CZ  PHE F   5      53.244  93.952 171.175  1.00 23.81           C  
ATOM   9788  N   THR F   6      52.771  99.257 171.408  1.00 27.38           N  
ATOM   9789  CA  THR F   6      53.452  99.829 170.250  1.00 27.44           C  
ATOM   9790  C   THR F   6      54.789  99.183 169.962  1.00 27.04           C  
ATOM   9791  O   THR F   6      55.576  98.919 170.871  1.00 28.97           O  
ATOM   9792  CB  THR F   6      53.668 101.350 170.433  1.00 28.18           C  
ATOM   9793  OG1 THR F   6      52.410 102.043 170.425  1.00 30.38           O  
ATOM   9794  CG2 THR F   6      54.418 101.927 169.228  1.00 28.56           C  
ATOM   9795  N   ILE F   7      55.043  98.955 168.684  1.00 25.55           N  
ATOM   9796  CA  ILE F   7      56.320  98.424 168.228  1.00 24.77           C  
ATOM   9797  C   ILE F   7      56.873  99.437 167.253  1.00 25.27           C  
ATOM   9798  O   ILE F   7      56.236  99.743 166.246  1.00 25.47           O  
ATOM   9799  CB  ILE F   7      56.149  97.075 167.534  1.00 23.89           C  
ATOM   9800  CG1 ILE F   7      55.741  96.004 168.550  1.00 24.33           C  
ATOM   9801  CG2 ILE F   7      57.445  96.690 166.835  1.00 23.09           C  
ATOM   9802  CD1 ILE F   7      55.379  94.681 167.928  1.00 22.49           C  
ATOM   9803  N   SER F   8      58.049  99.970 167.565  1.00 25.87           N  
ATOM   9804  CA  SER F   8      58.675 100.974 166.714  1.00 26.08           C  
ATOM   9805  C   SER F   8      59.971 100.465 166.120  1.00 25.81           C  
ATOM   9806  O   SER F   8      60.822  99.938 166.838  1.00 26.36           O  
ATOM   9807  CB  SER F   8      58.963 102.244 167.508  1.00 27.29           C  
ATOM   9808  OG  SER F   8      59.748 103.139 166.738  1.00 26.63           O  
ATOM   9809  N   PHE F   9      60.105 100.620 164.805  1.00 25.14           N  
ATOM   9810  CA  PHE F   9      61.313 100.241 164.093  1.00 24.26           C  
ATOM   9811  C   PHE F   9      62.039 101.489 163.578  1.00 24.47           C  
ATOM   9812  O   PHE F   9      62.767 101.426 162.597  1.00 23.96           O  
ATOM   9813  CB  PHE F   9      60.976  99.302 162.925  1.00 23.29           C  
ATOM   9814  CG  PHE F   9      60.548  97.916 163.346  1.00 23.77           C  
ATOM   9815  CD1 PHE F   9      61.092  97.300 164.466  1.00 24.65           C  
ATOM   9816  CD2 PHE F   9      59.612  97.222 162.601  1.00 23.09           C  
ATOM   9817  CE1 PHE F   9      60.699  96.005 164.836  1.00 25.13           C  
ATOM   9818  CE2 PHE F   9      59.213  95.940 162.963  1.00 23.13           C  
ATOM   9819  CZ  PHE F   9      59.763  95.333 164.075  1.00 22.09           C  
ATOM   9820  N   VAL F  10      61.852 102.631 164.232  1.00 24.94           N  
ATOM   9821  CA  VAL F  10      62.556 103.830 163.787  1.00 25.95           C  
ATOM   9822  C   VAL F  10      64.047 103.611 163.975  1.00 26.43           C  
ATOM   9823  O   VAL F  10      64.470 103.065 164.989  1.00 26.67           O  
ATOM   9824  CB  VAL F  10      62.113 105.086 164.556  1.00 26.53           C  
ATOM   9825  CG1 VAL F  10      62.971 106.290 164.160  1.00 27.95           C  
ATOM   9826  CG2 VAL F  10      60.652 105.365 164.297  1.00 26.90           C  
ATOM   9827  N   ASN F  11      64.833 104.020 162.984  1.00 27.10           N  
ATOM   9828  CA  ASN F  11      66.288 103.851 163.013  1.00 27.98           C  
ATOM   9829  C   ASN F  11      66.749 102.408 162.966  1.00 27.75           C  
ATOM   9830  O   ASN F  11      67.874 102.091 163.364  1.00 29.52           O  
ATOM   9831  CB  ASN F  11      66.893 104.549 164.231  1.00 28.83           C  
ATOM   9832  CG  ASN F  11      66.774 106.038 164.154  1.00 30.82           C  
ATOM   9833  OD1 ASN F  11      66.788 106.622 163.068  1.00 32.76           O  
ATOM   9834  ND2 ASN F  11      66.661 106.676 165.310  1.00 32.28           N  
ATOM   9835  N   LYS F  12      65.876 101.532 162.478  1.00 26.12           N  
ATOM   9836  CA  LYS F  12      66.204 100.127 162.321  1.00 25.09           C  
ATOM   9837  C   LYS F  12      66.044  99.797 160.849  1.00 24.07           C  
ATOM   9838  O   LYS F  12      65.248 100.430 160.164  1.00 24.60           O  
ATOM   9839  CB  LYS F  12      65.279  99.254 163.167  1.00 24.58           C  
ATOM   9840  CG  LYS F  12      65.484  99.424 164.676  1.00 26.38           C  
ATOM   9841  CD  LYS F  12      64.672  98.434 165.472  1.00 28.37           C  
ATOM   9842  CE  LYS F  12      64.961  98.556 166.960  1.00 30.25           C  
ATOM   9843  NZ  LYS F  12      64.090  97.616 167.723  1.00 34.69           N  
ATOM   9844  N   THR F  13      66.822  98.838 160.358  1.00 23.01           N  
ATOM   9845  CA  THR F  13      66.734  98.440 158.955  1.00 22.58           C  
ATOM   9846  C   THR F  13      66.310  96.991 158.816  1.00 21.87           C  
ATOM   9847  O   THR F  13      66.864  96.111 159.469  1.00 22.05           O  
ATOM   9848  CB  THR F  13      68.079  98.644 158.260  1.00 22.87           C  
ATOM   9849  OG1 THR F  13      68.279 100.051 158.049  1.00 24.47           O  
ATOM   9850  CG2 THR F  13      68.048  98.031 156.853  1.00 22.17           C  
ATOM   9851  N   ILE F  14      65.321  96.755 157.960  1.00 21.12           N  
ATOM   9852  CA  ILE F  14      64.834  95.408 157.693  1.00 20.39           C  
ATOM   9853  C   ILE F  14      65.058  95.082 156.227  1.00 19.81           C  
ATOM   9854  O   ILE F  14      64.745  95.893 155.365  1.00 20.08           O  
ATOM   9855  CB  ILE F  14      63.321  95.304 158.001  1.00 20.15           C  
ATOM   9856  CG1 ILE F  14      63.046  95.622 159.474  1.00 21.47           C  
ATOM   9857  CG2 ILE F  14      62.769  93.934 157.613  1.00 20.49           C  
ATOM   9858  CD1 ILE F  14      63.793  94.733 160.432  1.00 22.92           C  
ATOM   9859  N   ILE F  15      65.605  93.895 155.962  1.00 18.93           N  
ATOM   9860  CA  ILE F  15      65.798  93.413 154.604  1.00 18.93           C  
ATOM   9861  C   ILE F  15      64.608  92.526 154.271  1.00 18.45           C  
ATOM   9862  O   ILE F  15      64.243  91.659 155.071  1.00 17.83           O  
ATOM   9863  CB  ILE F  15      67.065  92.561 154.522  1.00 19.00           C  
ATOM   9864  CG1 ILE F  15      68.293  93.383 154.918  1.00 20.04           C  
ATOM   9865  CG2 ILE F  15      67.206  91.962 153.116  1.00 19.14           C  
ATOM   9866  CD1 ILE F  15      69.585  92.614 154.822  1.00 20.53           C  
ATOM   9867  N   VAL F  16      64.003  92.729 153.104  1.00 18.07           N  
ATOM   9868  CA  VAL F  16      62.891  91.867 152.681  1.00 18.10           C  
ATOM   9869  C   VAL F  16      63.162  91.322 151.285  1.00 17.98           C  
ATOM   9870  O   VAL F  16      63.188  92.088 150.329  1.00 18.22           O  
ATOM   9871  CB  VAL F  16      61.542  92.628 152.655  1.00 18.36           C  
ATOM   9872  CG1 VAL F  16      60.392  91.691 152.264  1.00 18.35           C  
ATOM   9873  CG2 VAL F  16      61.249  93.283 154.020  1.00 19.10           C  
ATOM   9874  N   THR F  17      63.398  90.018 151.166  1.00 17.04           N  
ATOM   9875  CA  THR F  17      63.618  89.446 149.829  1.00 17.22           C  
ATOM   9876  C   THR F  17      62.268  89.216 149.167  1.00 16.91           C  
ATOM   9877  O   THR F  17      61.302  88.824 149.831  1.00 16.71           O  
ATOM   9878  CB  THR F  17      64.466  88.145 149.839  1.00 16.72           C  
ATOM   9879  OG1 THR F  17      63.770  87.092 150.530  1.00 15.82           O  
ATOM   9880  CG2 THR F  17      65.761  88.356 150.608  1.00 18.21           C  
ATOM   9881  N   GLY F  18      62.191  89.469 147.864  1.00 16.95           N  
ATOM   9882  CA  GLY F  18      60.913  89.414 147.181  1.00 17.45           C  
ATOM   9883  C   GLY F  18      59.990  90.469 147.784  1.00 17.63           C  
ATOM   9884  O   GLY F  18      58.778  90.283 147.871  1.00 17.85           O  
ATOM   9885  N   GLY F  19      60.564  91.586 148.215  1.00 17.78           N  
ATOM   9886  CA  GLY F  19      59.770  92.588 148.909  1.00 18.49           C  
ATOM   9887  C   GLY F  19      59.164  93.674 148.054  1.00 18.82           C  
ATOM   9888  O   GLY F  19      58.673  94.664 148.591  1.00 19.16           O  
ATOM   9889  N   ASN F  20      59.186  93.492 146.736  1.00 19.30           N  
ATOM   9890  CA  ASN F  20      58.680  94.497 145.806  1.00 19.57           C  
ATOM   9891  C   ASN F  20      57.268  94.208 145.303  1.00 19.95           C  
ATOM   9892  O   ASN F  20      56.654  95.051 144.646  1.00 19.97           O  
ATOM   9893  CB  ASN F  20      59.636  94.611 144.621  1.00 20.07           C  
ATOM   9894  CG  ASN F  20      59.853  93.270 143.938  1.00 19.60           C  
ATOM   9895  OD1 ASN F  20      60.327  92.322 144.556  1.00 19.89           O  
ATOM   9896  ND2 ASN F  20      59.478  93.183 142.665  1.00 20.09           N  
ATOM   9897  N   ARG F  21      56.762  93.015 145.582  1.00 19.33           N  
ATOM   9898  CA  ARG F  21      55.409  92.680 145.170  1.00 20.22           C  
ATOM   9899  C   ARG F  21      54.822  91.546 146.003  1.00 19.29           C  
ATOM   9900  O   ARG F  21      55.518  90.922 146.802  1.00 18.94           O  
ATOM   9901  CB  ARG F  21      55.350  92.367 143.667  1.00 20.55           C  
ATOM   9902  CG  ARG F  21      56.122  91.137 143.209  1.00 20.94           C  
ATOM   9903  CD  ARG F  21      56.233  91.082 141.673  1.00 21.55           C  
ATOM   9904  NE  ARG F  21      57.063  89.987 141.191  1.00 21.15           N  
ATOM   9905  CZ  ARG F  21      56.592  88.792 140.839  1.00 20.79           C  
ATOM   9906  NH1 ARG F  21      57.422  87.833 140.426  1.00 22.16           N  
ATOM   9907  NH2 ARG F  21      55.288  88.545 140.912  1.00 24.44           N  
ATOM   9908  N   GLY F  22      53.531  91.288 145.813  1.00 19.64           N  
ATOM   9909  CA  GLY F  22      52.863  90.217 146.535  1.00 19.39           C  
ATOM   9910  C   GLY F  22      52.944  90.368 148.047  1.00 19.10           C  
ATOM   9911  O   GLY F  22      52.866  91.488 148.585  1.00 19.96           O  
ATOM   9912  N   ILE F  23      53.117  89.247 148.737  1.00 18.33           N  
ATOM   9913  CA  ILE F  23      53.193  89.264 150.196  1.00 17.70           C  
ATOM   9914  C   ILE F  23      54.416  90.017 150.672  1.00 17.76           C  
ATOM   9915  O   ILE F  23      54.360  90.692 151.698  1.00 17.55           O  
ATOM   9916  CB  ILE F  23      53.193  87.829 150.775  1.00 17.75           C  
ATOM   9917  CG1 ILE F  23      51.967  87.066 150.279  1.00 18.92           C  
ATOM   9918  CG2 ILE F  23      53.186  87.868 152.302  1.00 18.36           C  
ATOM   9919  CD1 ILE F  23      51.853  85.658 150.809  1.00 20.08           C  
ATOM   9920  N   GLY F  24      55.512  89.927 149.921  1.00 16.67           N  
ATOM   9921  CA  GLY F  24      56.732  90.630 150.274  1.00 17.36           C  
ATOM   9922  C   GLY F  24      56.502  92.133 150.349  1.00 17.96           C  
ATOM   9923  O   GLY F  24      57.003  92.801 151.256  1.00 17.45           O  
ATOM   9924  N   LEU F  25      55.736  92.676 149.410  1.00 17.80           N  
ATOM   9925  CA  LEU F  25      55.442  94.109 149.440  1.00 18.73           C  
ATOM   9926  C   LEU F  25      54.598  94.461 150.662  1.00 19.28           C  
ATOM   9927  O   LEU F  25      54.763  95.524 151.245  1.00 19.23           O  
ATOM   9928  CB  LEU F  25      54.756  94.549 148.148  1.00 19.35           C  
ATOM   9929  CG  LEU F  25      54.369  96.028 148.078  1.00 20.25           C  
ATOM   9930  CD1 LEU F  25      55.598  96.914 148.284  1.00 20.96           C  
ATOM   9931  CD2 LEU F  25      53.711  96.323 146.740  1.00 23.23           C  
ATOM   9932  N   ALA F  26      53.695  93.566 151.046  1.00 18.65           N  
ATOM   9933  CA  ALA F  26      52.887  93.811 152.233  1.00 19.21           C  
ATOM   9934  C   ALA F  26      53.805  93.901 153.450  1.00 19.11           C  
ATOM   9935  O   ALA F  26      53.616  94.754 154.314  1.00 19.19           O  
ATOM   9936  CB  ALA F  26      51.830  92.716 152.412  1.00 18.69           C  
ATOM   9937  N   PHE F  27      54.811  93.033 153.506  1.00 18.46           N  
ATOM   9938  CA  PHE F  27      55.776  93.061 154.604  1.00 18.54           C  
ATOM   9939  C   PHE F  27      56.563  94.374 154.567  1.00 19.35           C  
ATOM   9940  O   PHE F  27      56.754  95.015 155.592  1.00 19.65           O  
ATOM   9941  CB  PHE F  27      56.757  91.891 154.506  1.00 18.30           C  
ATOM   9942  CG  PHE F  27      56.175  90.553 154.869  1.00 18.31           C  
ATOM   9943  CD1 PHE F  27      56.450  89.442 154.088  1.00 17.31           C  
ATOM   9944  CD2 PHE F  27      55.381  90.392 155.993  1.00 18.08           C  
ATOM   9945  CE1 PHE F  27      55.937  88.191 154.416  1.00 16.88           C  
ATOM   9946  CE2 PHE F  27      54.862  89.145 156.326  1.00 18.36           C  
ATOM   9947  CZ  PHE F  27      55.138  88.045 155.534  1.00 17.40           C  
ATOM   9948  N   THR F  28      57.027  94.754 153.377  1.00 18.87           N  
ATOM   9949  CA  THR F  28      57.774  95.995 153.181  1.00 19.72           C  
ATOM   9950  C   THR F  28      56.994  97.198 153.680  1.00 20.39           C  
ATOM   9951  O   THR F  28      57.520  98.027 154.427  1.00 20.74           O  
ATOM   9952  CB  THR F  28      58.092  96.156 151.697  1.00 19.29           C  
ATOM   9953  OG1 THR F  28      59.076  95.170 151.338  1.00 19.52           O  
ATOM   9954  CG2 THR F  28      58.769  97.511 151.422  1.00 20.75           C  
ATOM   9955  N   ARG F  29      55.735  97.289 153.274  1.00 20.70           N  
ATOM   9956  CA  ARG F  29      54.898  98.419 153.663  1.00 21.38           C  
ATOM   9957  C   ARG F  29      54.599  98.420 155.161  1.00 21.46           C  
ATOM   9958  O   ARG F  29      54.548  99.481 155.784  1.00 21.98           O  
ATOM   9959  CB  ARG F  29      53.586  98.405 152.880  1.00 21.67           C  
ATOM   9960  CG  ARG F  29      53.736  98.708 151.404  1.00 22.91           C  
ATOM   9961  CD  ARG F  29      52.446  98.505 150.630  1.00 24.75           C  
ATOM   9962  NE  ARG F  29      51.368  99.342 151.157  1.00 27.55           N  
ATOM   9963  CZ  ARG F  29      51.317 100.656 151.028  1.00 27.14           C  
ATOM   9964  NH1 ARG F  29      52.267 101.298 150.355  1.00 30.11           N  
ATOM   9965  NH2 ARG F  29      50.304 101.340 151.548  1.00 29.55           N  
ATOM   9966  N   ALA F  30      54.395  97.236 155.729  1.00 20.78           N  
ATOM   9967  CA  ALA F  30      54.092  97.105 157.154  1.00 21.01           C  
ATOM   9968  C   ALA F  30      55.271  97.517 158.029  1.00 21.43           C  
ATOM   9969  O   ALA F  30      55.096  98.251 158.999  1.00 21.68           O  
ATOM   9970  CB  ALA F  30      53.660  95.664 157.484  1.00 20.60           C  
ATOM   9971  N   VAL F  31      56.475  97.053 157.705  1.00 21.02           N  
ATOM   9972  CA  VAL F  31      57.624  97.432 158.523  1.00 21.28           C  
ATOM   9973  C   VAL F  31      57.961  98.906 158.318  1.00 22.01           C  
ATOM   9974  O   VAL F  31      58.398  99.581 159.258  1.00 21.93           O  
ATOM   9975  CB  VAL F  31      58.854  96.532 158.304  1.00 20.98           C  
ATOM   9976  CG1 VAL F  31      58.526  95.085 158.686  1.00 20.52           C  
ATOM   9977  CG2 VAL F  31      59.336  96.610 156.880  1.00 20.89           C  
ATOM   9978  N   ALA F  32      57.746  99.408 157.102  1.00 21.68           N  
ATOM   9979  CA  ALA F  32      57.978 100.833 156.831  1.00 22.66           C  
ATOM   9980  C   ALA F  32      57.056 101.688 157.697  1.00 23.26           C  
ATOM   9981  O   ALA F  32      57.476 102.691 158.271  1.00 23.96           O  
ATOM   9982  CB  ALA F  32      57.762 101.151 155.340  1.00 22.36           C  
ATOM   9983  N   ALA F  33      55.799 101.266 157.801  1.00 23.22           N  
ATOM   9984  CA  ALA F  33      54.812 101.964 158.614  1.00 24.16           C  
ATOM   9985  C   ALA F  33      55.216 101.952 160.082  1.00 24.44           C  
ATOM   9986  O   ALA F  33      54.908 102.884 160.833  1.00 25.89           O  
ATOM   9987  CB  ALA F  33      53.453 101.324 158.431  1.00 24.06           C  
ATOM   9988  N   ALA F  34      55.917 100.902 160.487  1.00 23.69           N  
ATOM   9989  CA  ALA F  34      56.396 100.804 161.859  1.00 23.76           C  
ATOM   9990  C   ALA F  34      57.647 101.647 162.045  1.00 24.38           C  
ATOM   9991  O   ALA F  34      58.205 101.677 163.134  1.00 24.72           O  
ATOM   9992  CB  ALA F  34      56.686  99.362 162.231  1.00 23.13           C  
ATOM   9993  N   GLY F  35      58.092 102.305 160.973  1.00 24.47           N  
ATOM   9994  CA  GLY F  35      59.247 103.188 161.022  1.00 25.02           C  
ATOM   9995  C   GLY F  35      60.580 102.642 160.528  1.00 24.33           C  
ATOM   9996  O   GLY F  35      61.580 103.351 160.551  1.00 25.06           O  
ATOM   9997  N   ALA F  36      60.614 101.386 160.083  1.00 23.56           N  
ATOM   9998  CA  ALA F  36      61.871 100.806 159.639  1.00 23.06           C  
ATOM   9999  C   ALA F  36      62.344 101.291 158.274  1.00 23.46           C  
ATOM  10000  O   ALA F  36      61.545 101.595 157.389  1.00 23.43           O  
ATOM  10001  CB  ALA F  36      61.770  99.266 159.628  1.00 22.67           C  
ATOM  10002  N   ASN F  37      63.659 101.371 158.124  1.00 23.29           N  
ATOM  10003  CA  ASN F  37      64.252 101.625 156.829  1.00 23.39           C  
ATOM  10004  C   ASN F  37      64.203 100.271 156.154  1.00 22.52           C  
ATOM  10005  O   ASN F  37      64.367  99.254 156.829  1.00 22.21           O  
ATOM  10006  CB  ASN F  37      65.690 102.102 156.995  1.00 24.25           C  
ATOM  10007  CG  ASN F  37      65.774 103.425 157.736  1.00 26.03           C  
ATOM  10008  OD1 ASN F  37      65.120 104.403 157.364  1.00 28.16           O  
ATOM  10009  ND2 ASN F  37      66.573 103.460 158.799  1.00 29.47           N  
ATOM  10010  N   VAL F  38      63.975 100.226 154.845  1.00 21.97           N  
ATOM  10011  CA  VAL F  38      63.830  98.921 154.192  1.00 21.40           C  
ATOM  10012  C   VAL F  38      64.738  98.693 152.986  1.00 21.27           C  
ATOM  10013  O   VAL F  38      64.806  99.510 152.078  1.00 21.28           O  
ATOM  10014  CB  VAL F  38      62.377  98.655 153.753  1.00 21.07           C  
ATOM  10015  CG1 VAL F  38      62.185  97.170 153.373  1.00 20.82           C  
ATOM  10016  CG2 VAL F  38      61.406  99.036 154.859  1.00 21.93           C  
ATOM  10017  N   ALA F  39      65.427  97.557 152.998  1.00 20.75           N  
ATOM  10018  CA  ALA F  39      66.239  97.145 151.865  1.00 20.85           C  
ATOM  10019  C   ALA F  39      65.434  96.067 151.162  1.00 20.33           C  
ATOM  10020  O   ALA F  39      65.171  95.021 151.734  1.00 20.34           O  
ATOM  10021  CB  ALA F  39      67.569  96.592 152.333  1.00 21.22           C  
ATOM  10022  N   VAL F  40      65.034  96.348 149.926  1.00 20.66           N  
ATOM  10023  CA  VAL F  40      64.230  95.426 149.140  1.00 19.91           C  
ATOM  10024  C   VAL F  40      65.074  94.656 148.128  1.00 19.48           C  
ATOM  10025  O   VAL F  40      65.728  95.249 147.279  1.00 19.98           O  
ATOM  10026  CB  VAL F  40      63.100  96.179 148.398  1.00 20.43           C  
ATOM  10027  CG1 VAL F  40      62.372  95.248 147.434  1.00 20.36           C  
ATOM  10028  CG2 VAL F  40      62.122  96.801 149.407  1.00 21.19           C  
ATOM  10029  N   ILE F  41      65.058  93.326 148.235  1.00 18.41           N  
ATOM  10030  CA  ILE F  41      65.782  92.481 147.298  1.00 18.55           C  
ATOM  10031  C   ILE F  41      64.785  91.885 146.317  1.00 18.14           C  
ATOM  10032  O   ILE F  41      63.739  91.393 146.717  1.00 17.51           O  
ATOM  10033  CB  ILE F  41      66.564  91.372 148.061  1.00 18.25           C  
ATOM  10034  CG1 ILE F  41      67.843  91.971 148.663  1.00 19.81           C  
ATOM  10035  CG2 ILE F  41      66.870  90.168 147.150  1.00 18.28           C  
ATOM  10036  CD1 ILE F  41      68.641  91.024 149.553  1.00 19.75           C  
ATOM  10037  N   TYR F  42      65.108  91.958 145.029  1.00 18.33           N  
ATOM  10038  CA  TYR F  42      64.249  91.421 143.986  1.00 18.49           C  
ATOM  10039  C   TYR F  42      65.112  90.761 142.916  1.00 18.74           C  
ATOM  10040  O   TYR F  42      66.331  90.903 142.923  1.00 18.29           O  
ATOM  10041  CB  TYR F  42      63.405  92.540 143.360  1.00 19.55           C  
ATOM  10042  CG  TYR F  42      64.233  93.524 142.577  1.00 19.90           C  
ATOM  10043  CD1 TYR F  42      64.281  93.468 141.183  1.00 20.81           C  
ATOM  10044  CD2 TYR F  42      64.989  94.504 143.224  1.00 20.44           C  
ATOM  10045  CE1 TYR F  42      65.050  94.363 140.457  1.00 22.05           C  
ATOM  10046  CE2 TYR F  42      65.753  95.409 142.501  1.00 21.17           C  
ATOM  10047  CZ  TYR F  42      65.785  95.330 141.120  1.00 22.54           C  
ATOM  10048  OH  TYR F  42      66.552  96.230 140.412  1.00 24.37           O  
ATOM  10049  N   ARG F  43      64.472  90.061 141.987  1.00 18.14           N  
ATOM  10050  CA  ARG F  43      65.203  89.352 140.933  1.00 18.70           C  
ATOM  10051  C   ARG F  43      65.232  90.061 139.579  1.00 18.99           C  
ATOM  10052  O   ARG F  43      66.293  90.213 138.980  1.00 18.97           O  
ATOM  10053  CB  ARG F  43      64.642  87.942 140.744  1.00 18.13           C  
ATOM  10054  CG  ARG F  43      65.445  87.100 139.762  1.00 19.32           C  
ATOM  10055  CD  ARG F  43      64.893  85.719 139.550  1.00 21.28           C  
ATOM  10056  NE  ARG F  43      63.592  85.756 138.891  1.00 27.56           N  
ATOM  10057  CZ  ARG F  43      62.853  84.679 138.611  1.00 28.51           C  
ATOM  10058  NH1 ARG F  43      63.281  83.459 138.922  1.00 33.04           N  
ATOM  10059  NH2 ARG F  43      61.677  84.829 138.006  1.00 34.15           N  
ATOM  10060  N   SER F  44      64.070  90.489 139.089  1.00 19.20           N  
ATOM  10061  CA  SER F  44      64.022  91.106 137.761  1.00 19.66           C  
ATOM  10062  C   SER F  44      62.873  92.067 137.470  1.00 20.25           C  
ATOM  10063  O   SER F  44      62.804  92.609 136.373  1.00 20.65           O  
ATOM  10064  CB  SER F  44      63.991  90.029 136.678  1.00 19.73           C  
ATOM  10065  OG  SER F  44      62.732  89.373 136.661  1.00 19.36           O  
ATOM  10066  N   ALA F  45      61.962  92.260 138.422  1.00 19.97           N  
ATOM  10067  CA  ALA F  45      60.815  93.135 138.187  1.00 20.36           C  
ATOM  10068  C   ALA F  45      61.231  94.500 137.644  1.00 21.18           C  
ATOM  10069  O   ALA F  45      62.029  95.204 138.261  1.00 21.31           O  
ATOM  10070  CB  ALA F  45      60.016  93.303 139.464  1.00 20.01           C  
ATOM  10071  N   ALA F  46      60.675  94.868 136.495  1.00 21.73           N  
ATOM  10072  CA  ALA F  46      61.007  96.138 135.847  1.00 22.68           C  
ATOM  10073  C   ALA F  46      60.668  97.354 136.693  1.00 23.24           C  
ATOM  10074  O   ALA F  46      61.291  98.399 136.552  1.00 23.77           O  
ATOM  10075  CB  ALA F  46      60.310  96.242 134.497  1.00 23.45           C  
ATOM  10076  N   ASP F  47      59.694  97.215 137.584  1.00 23.31           N  
ATOM  10077  CA  ASP F  47      59.257  98.363 138.377  1.00 23.74           C  
ATOM  10078  C   ASP F  47      59.632  98.282 139.858  1.00 23.45           C  
ATOM  10079  O   ASP F  47      59.112  99.047 140.672  1.00 23.54           O  
ATOM  10080  CB  ASP F  47      57.741  98.541 138.238  1.00 24.49           C  
ATOM  10081  CG  ASP F  47      56.965  97.386 138.818  1.00 24.44           C  
ATOM  10082  OD1 ASP F  47      57.539  96.272 138.973  1.00 24.19           O  
ATOM  10083  OD2 ASP F  47      55.764  97.496 139.147  1.00 26.78           O  
ATOM  10084  N   ALA F  48      60.543  97.380 140.210  1.00 22.22           N  
ATOM  10085  CA  ALA F  48      60.936  97.206 141.610  1.00 22.12           C  
ATOM  10086  C   ALA F  48      61.508  98.471 142.244  1.00 22.91           C  
ATOM  10087  O   ALA F  48      61.212  98.793 143.406  1.00 22.91           O  
ATOM  10088  CB  ALA F  48      61.927  96.070 141.740  1.00 21.64           C  
ATOM  10089  N   VAL F  49      62.349  99.172 141.497  1.00 23.33           N  
ATOM  10090  CA  VAL F  49      62.941 100.410 141.994  1.00 24.00           C  
ATOM  10091  C   VAL F  49      61.867 101.453 142.273  1.00 24.63           C  
ATOM  10092  O   VAL F  49      61.859 102.068 143.338  1.00 24.73           O  
ATOM  10093  CB  VAL F  49      63.996 100.975 141.016  1.00 24.47           C  
ATOM  10094  CG1 VAL F  49      64.393 102.390 141.398  1.00 26.16           C  
ATOM  10095  CG2 VAL F  49      65.210 100.060 140.985  1.00 24.55           C  
ATOM  10096  N   GLU F  50      60.957 101.644 141.322  1.00 25.05           N  
ATOM  10097  CA  GLU F  50      59.868 102.605 141.484  1.00 26.12           C  
ATOM  10098  C   GLU F  50      59.041 102.277 142.727  1.00 25.39           C  
ATOM  10099  O   GLU F  50      58.795 103.131 143.581  1.00 25.57           O  
ATOM  10100  CB  GLU F  50      58.950 102.565 140.269  1.00 27.02           C  
ATOM  10101  CG  GLU F  50      59.638 102.707 138.928  1.00 30.16           C  
ATOM  10102  CD  GLU F  50      58.725 102.293 137.789  1.00 33.02           C  
ATOM  10103  OE1 GLU F  50      57.565 102.791 137.753  1.00 36.31           O  
ATOM  10104  OE2 GLU F  50      59.154 101.465 136.951  1.00 33.77           O  
ATOM  10105  N   VAL F  51      58.622 101.018 142.827  1.00 23.87           N  
ATOM  10106  CA  VAL F  51      57.807 100.579 143.951  1.00 23.49           C  
ATOM  10107  C   VAL F  51      58.488 100.839 145.284  1.00 23.56           C  
ATOM  10108  O   VAL F  51      57.865 101.340 146.222  1.00 23.77           O  
ATOM  10109  CB  VAL F  51      57.478  99.072 143.837  1.00 22.46           C  
ATOM  10110  CG1 VAL F  51      56.776  98.581 145.102  1.00 22.50           C  
ATOM  10111  CG2 VAL F  51      56.619  98.807 142.615  1.00 22.48           C  
ATOM  10112  N   THR F  52      59.759 100.475 145.381  1.00 23.77           N  
ATOM  10113  CA  THR F  52      60.507 100.645 146.617  1.00 23.76           C  
ATOM  10114  C   THR F  52      60.635 102.118 146.991  1.00 24.72           C  
ATOM  10115  O   THR F  52      60.508 102.484 148.161  1.00 24.88           O  
ATOM  10116  CB  THR F  52      61.890 100.004 146.493  1.00 23.77           C  
ATOM  10117  OG1 THR F  52      61.727  98.597 146.276  1.00 22.23           O  
ATOM  10118  CG2 THR F  52      62.642 100.075 147.820  1.00 24.49           C  
ATOM  10119  N   GLU F  53      60.882 102.966 145.997  1.00 25.53           N  
ATOM  10120  CA  GLU F  53      61.030 104.395 146.258  1.00 27.01           C  
ATOM  10121  C   GLU F  53      59.721 104.990 146.760  1.00 27.11           C  
ATOM  10122  O   GLU F  53      59.711 105.816 147.672  1.00 27.54           O  
ATOM  10123  CB  GLU F  53      61.524 105.112 145.004  1.00 27.75           C  
ATOM  10124  CG  GLU F  53      62.859 104.573 144.510  1.00 31.55           C  
ATOM  10125  CD  GLU F  53      63.504 105.426 143.435  1.00 34.19           C  
ATOM  10126  OE1 GLU F  53      62.784 105.971 142.558  1.00 38.96           O  
ATOM  10127  OE2 GLU F  53      64.753 105.551 143.457  1.00 36.42           O  
ATOM  10128  N   LYS F  54      58.615 104.543 146.180  1.00 26.81           N  
ATOM  10129  CA  LYS F  54      57.302 105.031 146.576  1.00 27.25           C  
ATOM  10130  C   LYS F  54      56.945 104.668 148.014  1.00 26.48           C  
ATOM  10131  O   LYS F  54      56.188 105.388 148.665  1.00 27.20           O  
ATOM  10132  CB  LYS F  54      56.231 104.528 145.606  1.00 27.40           C  
ATOM  10133  CG  LYS F  54      56.294 105.194 144.245  1.00 29.55           C  
ATOM  10134  CD  LYS F  54      55.297 104.578 143.275  1.00 31.32           C  
ATOM  10135  CE  LYS F  54      55.376 105.239 141.911  1.00 34.99           C  
ATOM  10136  NZ  LYS F  54      54.388 104.647 140.950  1.00 37.15           N  
ATOM  10137  N   VAL F  55      57.469 103.541 148.504  1.00 25.33           N  
ATOM  10138  CA  VAL F  55      57.232 103.139 149.888  1.00 24.90           C  
ATOM  10139  C   VAL F  55      57.984 104.073 150.829  1.00 25.45           C  
ATOM  10140  O   VAL F  55      57.450 104.518 151.854  1.00 25.63           O  
ATOM  10141  CB  VAL F  55      57.707 101.698 150.148  1.00 24.02           C  
ATOM  10142  CG1 VAL F  55      57.684 101.393 151.629  1.00 23.85           C  
ATOM  10143  CG2 VAL F  55      56.834 100.704 149.397  1.00 23.90           C  
ATOM  10144  N   GLY F  56      59.233 104.358 150.486  1.00 25.61           N  
ATOM  10145  CA  GLY F  56      60.048 105.256 151.283  1.00 26.14           C  
ATOM  10146  C   GLY F  56      59.421 106.634 151.407  1.00 27.71           C  
ATOM  10147  O   GLY F  56      59.434 107.253 152.480  1.00 28.08           O  
ATOM  10148  N   LYS F  57      58.857 107.118 150.305  1.00 27.88           N  
ATOM  10149  CA  LYS F  57      58.211 108.424 150.299  1.00 29.26           C  
ATOM  10150  C   LYS F  57      56.902 108.408 151.080  1.00 29.08           C  
ATOM  10151  O   LYS F  57      56.570 109.365 151.780  1.00 29.71           O  
ATOM  10152  CB  LYS F  57      57.942 108.870 148.862  1.00 29.81           C  
ATOM  10153  CG  LYS F  57      59.185 109.149 148.051  1.00 32.11           C  
ATOM  10154  CD  LYS F  57      58.822 109.681 146.669  1.00 34.76           C  
ATOM  10155  CE  LYS F  57      60.058 109.876 145.805  1.00 36.10           C  
ATOM  10156  NZ  LYS F  57      59.730 110.526 144.497  1.00 39.75           N  
ATOM  10157  N   GLU F  58      56.154 107.319 150.955  1.00 28.33           N  
ATOM  10158  CA  GLU F  58      54.868 107.209 151.632  1.00 28.44           C  
ATOM  10159  C   GLU F  58      54.978 107.234 153.159  1.00 28.37           C  
ATOM  10160  O   GLU F  58      54.203 107.920 153.835  1.00 29.33           O  
ATOM  10161  CB  GLU F  58      54.142 105.939 151.183  1.00 27.92           C  
ATOM  10162  CG  GLU F  58      52.789 105.731 151.841  1.00 28.55           C  
ATOM  10163  CD  GLU F  58      51.988 104.623 151.178  1.00 29.58           C  
ATOM  10164  OE1 GLU F  58      50.853 104.357 151.625  1.00 31.22           O  
ATOM  10165  OE2 GLU F  58      52.502 104.012 150.210  1.00 32.51           O  
ATOM  10166  N   PHE F  59      55.943 106.498 153.698  1.00 27.47           N  
ATOM  10167  CA  PHE F  59      56.094 106.378 155.146  1.00 27.11           C  
ATOM  10168  C   PHE F  59      57.252 107.174 155.748  1.00 27.93           C  
ATOM  10169  O   PHE F  59      57.517 107.069 156.947  1.00 27.99           O  
ATOM  10170  CB  PHE F  59      56.193 104.899 155.528  1.00 26.47           C  
ATOM  10171  CG  PHE F  59      55.008 104.099 155.094  1.00 26.21           C  
ATOM  10172  CD1 PHE F  59      55.056 103.327 153.942  1.00 26.79           C  
ATOM  10173  CD2 PHE F  59      53.823 104.146 155.820  1.00 26.85           C  
ATOM  10174  CE1 PHE F  59      53.950 102.599 153.532  1.00 25.73           C  
ATOM  10175  CE2 PHE F  59      52.717 103.424 155.416  1.00 25.89           C  
ATOM  10176  CZ  PHE F  59      52.779 102.649 154.267  1.00 26.80           C  
ATOM  10177  N   GLY F  60      57.919 107.982 154.928  1.00 28.47           N  
ATOM  10178  CA  GLY F  60      59.017 108.810 155.399  1.00 29.11           C  
ATOM  10179  C   GLY F  60      60.172 108.011 155.971  1.00 28.67           C  
ATOM  10180  O   GLY F  60      60.691 108.312 157.050  1.00 29.23           O  
ATOM  10181  N   VAL F  61      60.576 106.974 155.251  1.00 27.31           N  
ATOM  10182  CA  VAL F  61      61.701 106.157 155.683  1.00 26.84           C  
ATOM  10183  C   VAL F  61      62.670 105.995 154.527  1.00 26.79           C  
ATOM  10184  O   VAL F  61      62.338 106.288 153.377  1.00 27.33           O  
ATOM  10185  CB  VAL F  61      61.261 104.746 156.179  1.00 25.94           C  
ATOM  10186  CG1 VAL F  61      60.381 104.850 157.418  1.00 26.16           C  
ATOM  10187  CG2 VAL F  61      60.544 103.971 155.078  1.00 25.19           C  
ATOM  10188  N   LYS F  62      63.874 105.531 154.837  1.00 26.56           N  
ATOM  10189  CA  LYS F  62      64.868 105.299 153.805  1.00 26.39           C  
ATOM  10190  C   LYS F  62      64.631 103.915 153.229  1.00 25.30           C  
ATOM  10191  O   LYS F  62      64.480 102.939 153.970  1.00 25.18           O  
ATOM  10192  CB  LYS F  62      66.278 105.379 154.387  1.00 26.86           C  
ATOM  10193  CG  LYS F  62      66.571 106.686 155.117  1.00 28.58           C  
ATOM  10194  CD  LYS F  62      67.844 106.587 155.946  1.00 30.55           C  
ATOM  10195  CE  LYS F  62      69.083 106.639 155.074  1.00 33.11           C  
ATOM  10196  NZ  LYS F  62      70.346 106.678 155.876  1.00 37.18           N  
ATOM  10197  N   THR F  63      64.559 103.834 151.905  1.00 25.37           N  
ATOM  10198  CA  THR F  63      64.425 102.547 151.232  1.00 24.36           C  
ATOM  10199  C   THR F  63      65.352 102.492 150.035  1.00 24.27           C  
ATOM  10200  O   THR F  63      65.760 103.520 149.490  1.00 24.87           O  
ATOM  10201  CB  THR F  63      62.995 102.261 150.723  1.00 24.33           C  
ATOM  10202  OG1 THR F  63      62.624 103.234 149.740  1.00 26.01           O  
ATOM  10203  CG2 THR F  63      61.958 102.391 151.827  1.00 24.57           C  
ATOM  10204  N   LYS F  64      65.678 101.273 149.632  1.00 23.17           N  
ATOM  10205  CA  LYS F  64      66.507 101.060 148.464  1.00 23.19           C  
ATOM  10206  C   LYS F  64      66.277  99.650 147.968  1.00 22.41           C  
ATOM  10207  O   LYS F  64      66.089  98.727 148.764  1.00 21.90           O  
ATOM  10208  CB  LYS F  64      67.984 101.269 148.784  1.00 23.42           C  
ATOM  10209  CG  LYS F  64      68.877 101.205 147.555  1.00 24.10           C  
ATOM  10210  CD  LYS F  64      70.306 101.614 147.870  1.00 24.80           C  
ATOM  10211  CE  LYS F  64      71.207 101.440 146.651  1.00 26.17           C  
ATOM  10212  NZ  LYS F  64      72.624 101.805 146.950  1.00 30.17           N  
ATOM  10213  N   ALA F  65      66.279  99.500 146.647  1.00 22.71           N  
ATOM  10214  CA  ALA F  65      66.088  98.199 146.018  1.00 21.95           C  
ATOM  10215  C   ALA F  65      67.417  97.653 145.511  1.00 21.71           C  
ATOM  10216  O   ALA F  65      68.253  98.398 144.986  1.00 22.73           O  
ATOM  10217  CB  ALA F  65      65.094  98.310 144.881  1.00 22.43           C  
ATOM  10218  N   TYR F  66      67.607  96.348 145.683  1.00 20.74           N  
ATOM  10219  CA  TYR F  66      68.826  95.693 145.251  1.00 20.71           C  
ATOM  10220  C   TYR F  66      68.474  94.488 144.403  1.00 20.17           C  
ATOM  10221  O   TYR F  66      67.755  93.596 144.857  1.00 18.88           O  
ATOM  10222  CB  TYR F  66      69.625  95.207 146.461  1.00 20.95           C  
ATOM  10223  CG  TYR F  66      70.030  96.294 147.435  1.00 21.38           C  
ATOM  10224  CD1 TYR F  66      69.118  96.814 148.346  1.00 21.93           C  
ATOM  10225  CD2 TYR F  66      71.330  96.788 147.456  1.00 22.00           C  
ATOM  10226  CE1 TYR F  66      69.487  97.809 149.236  1.00 21.87           C  
ATOM  10227  CE2 TYR F  66      71.707  97.777 148.348  1.00 22.22           C  
ATOM  10228  CZ  TYR F  66      70.781  98.274 149.242  1.00 22.71           C  
ATOM  10229  OH  TYR F  66      71.149  99.255 150.138  1.00 22.86           O  
ATOM  10230  N   GLN F  67      68.963  94.465 143.169  1.00 20.34           N  
ATOM  10231  CA  GLN F  67      68.759  93.307 142.297  1.00 20.12           C  
ATOM  10232  C   GLN F  67      69.720  92.227 142.773  1.00 19.94           C  
ATOM  10233  O   GLN F  67      70.938  92.390 142.702  1.00 20.18           O  
ATOM  10234  CB  GLN F  67      69.031  93.678 140.845  1.00 20.81           C  
ATOM  10235  CG  GLN F  67      68.720  92.553 139.856  1.00 21.11           C  
ATOM  10236  CD  GLN F  67      68.481  93.081 138.447  1.00 21.75           C  
ATOM  10237  OE1 GLN F  67      69.066  94.087 138.057  1.00 24.12           O  
ATOM  10238  NE2 GLN F  67      67.628  92.397 137.682  1.00 21.38           N  
ATOM  10239  N   CYS F  68      69.174  91.125 143.261  1.00 18.99           N  
ATOM  10240  CA  CYS F  68      70.008  90.108 143.884  1.00 18.94           C  
ATOM  10241  C   CYS F  68      69.352  88.742 143.841  1.00 18.40           C  
ATOM  10242  O   CYS F  68      68.377  88.500 144.532  1.00 18.20           O  
ATOM  10243  CB  CYS F  68      70.286  90.521 145.337  1.00 18.76           C  
ATOM  10244  SG  CYS F  68      71.104  89.285 146.376  1.00 19.21           S  
ATOM  10245  N   ASP F  69      69.890  87.851 143.012  1.00 17.84           N  
ATOM  10246  CA  ASP F  69      69.373  86.488 142.908  1.00 17.54           C  
ATOM  10247  C   ASP F  69      69.764  85.737 144.176  1.00 17.32           C  
ATOM  10248  O   ASP F  69      70.932  85.442 144.377  1.00 17.62           O  
ATOM  10249  CB  ASP F  69      70.009  85.819 141.689  1.00 17.90           C  
ATOM  10250  CG  ASP F  69      69.408  84.476 141.367  1.00 17.97           C  
ATOM  10251  OD1 ASP F  69      68.860  83.820 142.271  1.00 17.17           O  
ATOM  10252  OD2 ASP F  69      69.458  84.017 140.197  1.00 20.75           O  
ATOM  10253  N   VAL F  70      68.784  85.413 145.012  1.00 16.43           N  
ATOM  10254  CA  VAL F  70      69.077  84.779 146.301  1.00 16.75           C  
ATOM  10255  C   VAL F  70      69.672  83.375 146.195  1.00 16.70           C  
ATOM  10256  O   VAL F  70      70.177  82.838 147.178  1.00 17.21           O  
ATOM  10257  CB  VAL F  70      67.844  84.743 147.223  1.00 16.54           C  
ATOM  10258  CG1 VAL F  70      67.367  86.170 147.510  1.00 17.62           C  
ATOM  10259  CG2 VAL F  70      66.722  83.918 146.599  1.00 16.81           C  
ATOM  10260  N   SER F  71      69.626  82.796 145.002  1.00 16.70           N  
ATOM  10261  CA  SER F  71      70.156  81.453 144.810  1.00 16.77           C  
ATOM  10262  C   SER F  71      71.664  81.454 144.558  1.00 17.25           C  
ATOM  10263  O   SER F  71      72.267  80.389 144.424  1.00 17.22           O  
ATOM  10264  CB  SER F  71      69.437  80.756 143.653  1.00 16.53           C  
ATOM  10265  OG  SER F  71      69.825  81.266 142.392  1.00 17.48           O  
ATOM  10266  N   ASN F  72      72.261  82.637 144.469  1.00 17.16           N  
ATOM  10267  CA  ASN F  72      73.693  82.746 144.200  1.00 17.66           C  
ATOM  10268  C   ASN F  72      74.427  83.223 145.448  1.00 17.75           C  
ATOM  10269  O   ASN F  72      74.128  84.283 145.986  1.00 18.63           O  
ATOM  10270  CB  ASN F  72      73.947  83.697 143.024  1.00 18.32           C  
ATOM  10271  CG  ASN F  72      75.423  83.832 142.689  1.00 19.81           C  
ATOM  10272  OD1 ASN F  72      76.133  84.642 143.274  1.00 19.43           O  
ATOM  10273  ND2 ASN F  72      75.897  83.015 141.750  1.00 22.16           N  
ATOM  10274  N   THR F  73      75.400  82.436 145.891  1.00 17.50           N  
ATOM  10275  CA  THR F  73      76.131  82.740 147.122  1.00 17.57           C  
ATOM  10276  C   THR F  73      76.790  84.101 147.128  1.00 18.30           C  
ATOM  10277  O   THR F  73      76.534  84.931 148.008  1.00 18.02           O  
ATOM  10278  CB  THR F  73      77.208  81.678 147.355  1.00 17.62           C  
ATOM  10279  OG1 THR F  73      76.587  80.402 147.530  1.00 16.16           O  
ATOM  10280  CG2 THR F  73      77.983  81.951 148.651  1.00 18.14           C  
ATOM  10281  N   ASP F  74      77.639  84.344 146.138  1.00 18.37           N  
ATOM  10282  CA  ASP F  74      78.427  85.572 146.143  1.00 18.90           C  
ATOM  10283  C   ASP F  74      77.644  86.860 145.964  1.00 19.21           C  
ATOM  10284  O   ASP F  74      77.980  87.875 146.578  1.00 19.05           O  
ATOM  10285  CB  ASP F  74      79.552  85.504 145.113  1.00 19.43           C  
ATOM  10286  CG  ASP F  74      80.605  84.472 145.460  1.00 20.02           C  
ATOM  10287  OD1 ASP F  74      80.657  84.005 146.621  1.00 19.70           O  
ATOM  10288  OD2 ASP F  74      81.421  84.068 144.612  1.00 20.46           O  
ATOM  10289  N   ILE F  75      76.607  86.841 145.126  1.00 19.04           N  
ATOM  10290  CA  ILE F  75      75.835  88.073 144.941  1.00 19.70           C  
ATOM  10291  C   ILE F  75      75.081  88.422 146.220  1.00 19.28           C  
ATOM  10292  O   ILE F  75      74.906  89.594 146.554  1.00 18.82           O  
ATOM  10293  CB  ILE F  75      74.868  87.967 143.750  1.00 19.79           C  
ATOM  10294  CG1 ILE F  75      75.639  87.636 142.472  1.00 22.34           C  
ATOM  10295  CG2 ILE F  75      74.094  89.268 143.599  1.00 20.69           C  
ATOM  10296  CD1 ILE F  75      74.757  87.327 141.263  1.00 25.40           C  
ATOM  10297  N   VAL F  76      74.637  87.403 146.944  1.00 18.10           N  
ATOM  10298  CA  VAL F  76      73.973  87.654 148.220  1.00 18.39           C  
ATOM  10299  C   VAL F  76      74.970  88.181 149.258  1.00 18.90           C  
ATOM  10300  O   VAL F  76      74.685  89.134 149.987  1.00 18.79           O  
ATOM  10301  CB  VAL F  76      73.238  86.393 148.725  1.00 17.83           C  
ATOM  10302  CG1 VAL F  76      72.856  86.540 150.188  1.00 17.79           C  
ATOM  10303  CG2 VAL F  76      72.006  86.115 147.872  1.00 18.17           C  
ATOM  10304  N   THR F  77      76.162  87.593 149.310  1.00 19.16           N  
ATOM  10305  CA  THR F  77      77.175  88.092 150.232  1.00 19.72           C  
ATOM  10306  C   THR F  77      77.453  89.567 149.944  1.00 20.08           C  
ATOM  10307  O   THR F  77      77.453  90.406 150.848  1.00 20.66           O  
ATOM  10308  CB  THR F  77      78.469  87.281 150.083  1.00 19.65           C  
ATOM  10309  OG1 THR F  77      78.251  85.940 150.539  1.00 19.20           O  
ATOM  10310  CG2 THR F  77      79.579  87.837 151.001  1.00 21.46           C  
ATOM  10311  N   LYS F  78      77.691  89.883 148.677  1.00 20.07           N  
ATOM  10312  CA  LYS F  78      77.999  91.257 148.277  1.00 21.22           C  
ATOM  10313  C   LYS F  78      76.827  92.206 148.532  1.00 21.09           C  
ATOM  10314  O   LYS F  78      77.012  93.351 148.920  1.00 21.52           O  
ATOM  10315  CB  LYS F  78      78.397  91.281 146.802  1.00 21.81           C  
ATOM  10316  CG  LYS F  78      79.639  90.447 146.503  1.00 24.14           C  
ATOM  10317  CD  LYS F  78      79.937  90.345 145.013  1.00 26.70           C  
ATOM  10318  CE  LYS F  78      81.150  89.435 144.769  1.00 27.45           C  
ATOM  10319  NZ  LYS F  78      81.287  88.995 143.356  1.00 30.40           N  
ATOM  10320  N   THR F  79      75.610  91.719 148.323  1.00 20.16           N  
ATOM  10321  CA  THR F  79      74.442  92.556 148.528  1.00 20.75           C  
ATOM  10322  C   THR F  79      74.224  92.871 150.002  1.00 20.86           C  
ATOM  10323  O   THR F  79      73.879  94.002 150.356  1.00 21.13           O  
ATOM  10324  CB  THR F  79      73.206  91.872 147.944  1.00 19.89           C  
ATOM  10325  OG1 THR F  79      73.328  91.816 146.511  1.00 20.16           O  
ATOM  10326  CG2 THR F  79      71.931  92.705 148.206  1.00 20.16           C  
ATOM  10327  N   ILE F  80      74.435  91.881 150.866  1.00 20.58           N  
ATOM  10328  CA  ILE F  80      74.283  92.108 152.304  1.00 20.67           C  
ATOM  10329  C   ILE F  80      75.319  93.117 152.785  1.00 21.40           C  
ATOM  10330  O   ILE F  80      75.018  93.993 153.601  1.00 21.66           O  
ATOM  10331  CB  ILE F  80      74.420  90.784 153.075  1.00 20.56           C  
ATOM  10332  CG1 ILE F  80      73.293  89.820 152.698  1.00 21.43           C  
ATOM  10333  CG2 ILE F  80      74.449  91.032 154.580  1.00 20.77           C  
ATOM  10334  CD1 ILE F  80      71.928  90.419 152.680  1.00 21.69           C  
ATOM  10335  N   GLN F  81      76.539  93.007 152.284  1.00 21.65           N  
ATOM  10336  CA  GLN F  81      77.579  93.958 152.667  1.00 22.77           C  
ATOM  10337  C   GLN F  81      77.182  95.361 152.241  1.00 22.99           C  
ATOM  10338  O   GLN F  81      77.342  96.326 153.005  1.00 23.37           O  
ATOM  10339  CB  GLN F  81      78.915  93.564 152.047  1.00 23.45           C  
ATOM  10340  CG  GLN F  81      79.434  92.256 152.588  1.00 25.72           C  
ATOM  10341  CD  GLN F  81      80.681  91.760 151.874  1.00 28.97           C  
ATOM  10342  OE1 GLN F  81      80.767  91.791 150.632  1.00 32.81           O  
ATOM  10343  NE2 GLN F  81      81.653  91.290 152.655  1.00 35.30           N  
ATOM  10344  N   GLN F  82      76.668  95.476 151.021  1.00 22.67           N  
ATOM  10345  CA  GLN F  82      76.235  96.764 150.501  1.00 23.32           C  
ATOM  10346  C   GLN F  82      75.092  97.352 151.328  1.00 22.99           C  
ATOM  10347  O   GLN F  82      75.066  98.553 151.606  1.00 23.56           O  
ATOM  10348  CB  GLN F  82      75.821  96.648 149.033  1.00 23.26           C  
ATOM  10349  CG  GLN F  82      75.660  98.005 148.359  1.00 24.56           C  
ATOM  10350  CD  GLN F  82      76.941  98.818 148.394  1.00 26.85           C  
ATOM  10351  OE1 GLN F  82      77.974  98.386 147.875  1.00 30.16           O  
ATOM  10352  NE2 GLN F  82      76.881 100.000 149.008  1.00 28.12           N  
ATOM  10353  N   ILE F  83      74.141  96.510 151.717  1.00 22.06           N  
ATOM  10354  CA  ILE F  83      73.026  96.974 152.528  1.00 22.07           C  
ATOM  10355  C   ILE F  83      73.519  97.480 153.873  1.00 22.61           C  
ATOM  10356  O   ILE F  83      73.041  98.504 154.380  1.00 23.20           O  
ATOM  10357  CB  ILE F  83      71.984  95.848 152.730  1.00 21.30           C  
ATOM  10358  CG1 ILE F  83      71.249  95.567 151.421  1.00 20.65           C  
ATOM  10359  CG2 ILE F  83      70.987  96.245 153.826  1.00 21.76           C  
ATOM  10360  CD1 ILE F  83      70.466  94.255 151.413  1.00 19.87           C  
ATOM  10361  N   ASP F  84      74.470  96.762 154.457  1.00 22.69           N  
ATOM  10362  CA  ASP F  84      75.036  97.173 155.740  1.00 23.50           C  
ATOM  10363  C   ASP F  84      75.780  98.497 155.622  1.00 24.72           C  
ATOM  10364  O   ASP F  84      75.766  99.304 156.552  1.00 25.74           O  
ATOM  10365  CB  ASP F  84      75.968  96.093 156.282  1.00 23.86           C  
ATOM  10366  CG  ASP F  84      76.597  96.476 157.599  1.00 24.86           C  
ATOM  10367  OD1 ASP F  84      75.854  96.665 158.593  1.00 26.47           O  
ATOM  10368  OD2 ASP F  84      77.831  96.623 157.718  1.00 27.92           O  
ATOM  10369  N   ALA F  85      76.432  98.726 154.483  1.00 24.54           N  
ATOM  10370  CA  ALA F  85      77.148  99.982 154.257  1.00 25.65           C  
ATOM  10371  C   ALA F  85      76.169 101.130 154.017  1.00 25.79           C  
ATOM  10372  O   ALA F  85      76.396 102.264 154.463  1.00 27.53           O  
ATOM  10373  CB  ALA F  85      78.097  99.842 153.074  1.00 25.50           C  
ATOM  10374  N   ASP F  86      75.078 100.825 153.317  1.00 25.69           N  
ATOM  10375  CA  ASP F  86      74.084 101.830 152.966  1.00 25.80           C  
ATOM  10376  C   ASP F  86      73.146 102.182 154.115  1.00 25.77           C  
ATOM  10377  O   ASP F  86      72.917 103.353 154.397  1.00 27.20           O  
ATOM  10378  CB  ASP F  86      73.211 101.336 151.814  1.00 25.29           C  
ATOM  10379  CG  ASP F  86      73.955 101.215 150.505  1.00 25.75           C  
ATOM  10380  OD1 ASP F  86      75.087 101.743 150.366  1.00 26.30           O  
ATOM  10381  OD2 ASP F  86      73.449 100.591 149.547  1.00 24.68           O  
ATOM  10382  N   LEU F  87      72.605 101.154 154.762  1.00 25.41           N  
ATOM  10383  CA  LEU F  87      71.579 101.327 155.781  1.00 25.23           C  
ATOM  10384  C   LEU F  87      71.837 100.601 157.103  1.00 25.28           C  
ATOM  10385  O   LEU F  87      70.919 100.452 157.911  1.00 25.50           O  
ATOM  10386  CB  LEU F  87      70.242 100.833 155.231  1.00 25.23           C  
ATOM  10387  CG  LEU F  87      69.757 101.428 153.909  1.00 24.72           C  
ATOM  10388  CD1 LEU F  87      68.767 100.503 153.240  1.00 24.93           C  
ATOM  10389  CD2 LEU F  87      69.143 102.799 154.127  1.00 27.03           C  
ATOM  10390  N   GLY F  88      73.064 100.143 157.327  1.00 25.49           N  
ATOM  10391  CA  GLY F  88      73.379  99.433 158.556  1.00 25.22           C  
ATOM  10392  C   GLY F  88      73.167 100.268 159.807  1.00 26.23           C  
ATOM  10393  O   GLY F  88      73.115 101.498 159.736  1.00 27.39           O  
ATOM  10394  N   PRO F  89      73.061  99.615 160.963  1.00 26.10           N  
ATOM  10395  CA  PRO F  89      73.051  98.149 161.063  1.00 25.45           C  
ATOM  10396  C   PRO F  89      71.743  97.493 160.620  1.00 24.45           C  
ATOM  10397  O   PRO F  89      70.674  98.115 160.658  1.00 24.67           O  
ATOM  10398  CB  PRO F  89      73.250  97.910 162.564  1.00 25.85           C  
ATOM  10399  CG  PRO F  89      72.723  99.150 163.204  1.00 27.73           C  
ATOM  10400  CD  PRO F  89      73.123 100.263 162.292  1.00 26.88           C  
ATOM  10401  N   ILE F  90      71.847  96.242 160.178  1.00 23.70           N  
ATOM  10402  CA  ILE F  90      70.675  95.474 159.785  1.00 22.64           C  
ATOM  10403  C   ILE F  90      70.062  94.936 161.062  1.00 22.36           C  
ATOM  10404  O   ILE F  90      70.763  94.326 161.869  1.00 23.27           O  
ATOM  10405  CB  ILE F  90      71.069  94.320 158.845  1.00 21.84           C  
ATOM  10406  CG1 ILE F  90      71.718  94.872 157.575  1.00 22.42           C  
ATOM  10407  CG2 ILE F  90      69.850  93.469 158.489  1.00 21.58           C  
ATOM  10408  CD1 ILE F  90      72.440  93.833 156.747  1.00 23.31           C  
ATOM  10409  N   SER F  91      68.764  95.163 161.244  1.00 22.07           N  
ATOM  10410  CA  SER F  91      68.074  94.751 162.463  1.00 22.45           C  
ATOM  10411  C   SER F  91      67.293  93.462 162.301  1.00 21.55           C  
ATOM  10412  O   SER F  91      67.081  92.717 163.256  1.00 22.13           O  
ATOM  10413  CB  SER F  91      67.109  95.850 162.919  1.00 22.58           C  
ATOM  10414  OG  SER F  91      67.751  97.113 162.946  1.00 26.82           O  
ATOM  10415  N   GLY F  92      66.824  93.218 161.087  1.00 20.33           N  
ATOM  10416  CA  GLY F  92      66.033  92.029 160.834  1.00 19.79           C  
ATOM  10417  C   GLY F  92      65.991  91.674 159.371  1.00 19.67           C  
ATOM  10418  O   GLY F  92      66.346  92.472 158.503  1.00 20.40           O  
ATOM  10419  N   LEU F  93      65.555  90.454 159.105  1.00 18.58           N  
ATOM  10420  CA  LEU F  93      65.460  89.957 157.745  1.00 18.39           C  
ATOM  10421  C   LEU F  93      64.176  89.173 157.585  1.00 18.02           C  
ATOM  10422  O   LEU F  93      63.797  88.409 158.468  1.00 18.40           O  
ATOM  10423  CB  LEU F  93      66.641  89.037 157.442  1.00 18.21           C  
ATOM  10424  CG  LEU F  93      66.511  88.078 156.251  1.00 17.70           C  
ATOM  10425  CD1 LEU F  93      66.492  88.841 154.940  1.00 18.59           C  
ATOM  10426  CD2 LEU F  93      67.645  87.054 156.274  1.00 18.18           C  
ATOM  10427  N   ILE F  94      63.509  89.381 156.458  1.00 17.72           N  
ATOM  10428  CA  ILE F  94      62.352  88.576 156.113  1.00 17.36           C  
ATOM  10429  C   ILE F  94      62.736  87.885 154.808  1.00 17.03           C  
ATOM  10430  O   ILE F  94      62.816  88.528 153.745  1.00 17.41           O  
ATOM  10431  CB  ILE F  94      61.093  89.431 155.934  1.00 17.54           C  
ATOM  10432  CG1 ILE F  94      60.796  90.216 157.211  1.00 18.46           C  
ATOM  10433  CG2 ILE F  94      59.903  88.520 155.594  1.00 17.95           C  
ATOM  10434  CD1 ILE F  94      59.549  91.086 157.112  1.00 18.70           C  
ATOM  10435  N   ALA F  95      63.041  86.596 154.913  1.00 16.68           N  
ATOM  10436  CA  ALA F  95      63.452  85.790 153.772  1.00 16.59           C  
ATOM  10437  C   ALA F  95      62.163  85.253 153.173  1.00 16.01           C  
ATOM  10438  O   ALA F  95      61.668  84.170 153.541  1.00 16.20           O  
ATOM  10439  CB  ALA F  95      64.362  84.653 154.221  1.00 15.97           C  
ATOM  10440  N   ASN F  96      61.624  86.026 152.244  1.00 15.87           N  
ATOM  10441  CA  ASN F  96      60.307  85.791 151.678  1.00 15.79           C  
ATOM  10442  C   ASN F  96      60.277  85.307 150.219  1.00 15.91           C  
ATOM  10443  O   ASN F  96      59.299  84.672 149.814  1.00 15.68           O  
ATOM  10444  CB  ASN F  96      59.483  87.082 151.862  1.00 16.09           C  
ATOM  10445  CG  ASN F  96      58.269  87.156 150.959  1.00 16.92           C  
ATOM  10446  OD1 ASN F  96      58.321  87.748 149.848  1.00 18.79           O  
ATOM  10447  ND2 ASN F  96      57.147  86.641 151.447  1.00 14.02           N  
ATOM  10448  N   ALA F  97      61.326  85.574 149.440  1.00 15.23           N  
ATOM  10449  CA  ALA F  97      61.332  85.164 148.033  1.00 16.15           C  
ATOM  10450  C   ALA F  97      61.029  83.673 147.889  1.00 15.74           C  
ATOM  10451  O   ALA F  97      61.588  82.858 148.602  1.00 15.69           O  
ATOM  10452  CB  ALA F  97      62.667  85.508 147.377  1.00 16.32           C  
ATOM  10453  N   GLY F  98      60.151  83.321 146.956  1.00 15.72           N  
ATOM  10454  CA  GLY F  98      59.805  81.926 146.752  1.00 15.78           C  
ATOM  10455  C   GLY F  98      59.141  81.741 145.404  1.00 16.13           C  
ATOM  10456  O   GLY F  98      58.622  82.699 144.814  1.00 16.88           O  
ATOM  10457  N   VAL F  99      59.150  80.502 144.921  1.00 15.49           N  
ATOM  10458  CA  VAL F  99      58.584  80.157 143.616  1.00 16.05           C  
ATOM  10459  C   VAL F  99      57.904  78.793 143.681  1.00 15.81           C  
ATOM  10460  O   VAL F  99      58.016  78.072 144.657  1.00 15.67           O  
ATOM  10461  CB  VAL F  99      59.666  80.098 142.503  1.00 15.78           C  
ATOM  10462  CG1 VAL F  99      60.394  81.440 142.386  1.00 16.71           C  
ATOM  10463  CG2 VAL F  99      60.684  78.978 142.772  1.00 16.26           C  
ATOM  10464  N   SER F 100      57.187  78.443 142.623  1.00 16.38           N  
ATOM  10465  CA  SER F 100      56.588  77.117 142.536  1.00 15.86           C  
ATOM  10466  C   SER F 100      56.596  76.609 141.102  1.00 16.28           C  
ATOM  10467  O   SER F 100      56.838  77.367 140.166  1.00 16.89           O  
ATOM  10468  CB  SER F 100      55.146  77.125 143.054  1.00 16.10           C  
ATOM  10469  OG  SER F 100      54.650  75.794 143.092  1.00 16.51           O  
ATOM  10470  N   VAL F 101      56.373  75.305 140.947  1.00 15.76           N  
ATOM  10471  CA  VAL F 101      56.186  74.685 139.640  1.00 16.17           C  
ATOM  10472  C   VAL F 101      54.994  73.752 139.808  1.00 16.47           C  
ATOM  10473  O   VAL F 101      55.033  72.854 140.658  1.00 16.59           O  
ATOM  10474  CB  VAL F 101      57.408  73.859 139.172  1.00 16.03           C  
ATOM  10475  CG1 VAL F 101      57.051  73.081 137.910  1.00 17.32           C  
ATOM  10476  CG2 VAL F 101      58.610  74.756 138.926  1.00 16.29           C  
ATOM  10477  N   VAL F 102      53.948  73.983 139.015  1.00 16.37           N  
ATOM  10478  CA  VAL F 102      52.729  73.181 139.059  1.00 16.81           C  
ATOM  10479  C   VAL F 102      52.681  72.229 137.861  1.00 17.11           C  
ATOM  10480  O   VAL F 102      52.463  72.653 136.724  1.00 17.93           O  
ATOM  10481  CB  VAL F 102      51.480  74.093 139.072  1.00 16.89           C  
ATOM  10482  CG1 VAL F 102      50.193  73.256 139.045  1.00 17.99           C  
ATOM  10483  CG2 VAL F 102      51.504  75.016 140.285  1.00 17.83           C  
ATOM  10484  N   LYS F 103      52.894  70.936 138.128  1.00 16.77           N  
ATOM  10485  CA  LYS F 103      52.878  69.873 137.115  1.00 17.50           C  
ATOM  10486  C   LYS F 103      52.605  68.557 137.832  1.00 17.16           C  
ATOM  10487  O   LYS F 103      52.958  68.420 139.003  1.00 16.32           O  
ATOM  10488  CB  LYS F 103      54.252  69.704 136.462  1.00 18.40           C  
ATOM  10489  CG  LYS F 103      54.793  70.852 135.665  1.00 19.79           C  
ATOM  10490  CD  LYS F 103      56.048  70.334 134.984  1.00 20.09           C  
ATOM  10491  CE  LYS F 103      56.798  71.383 134.270  1.00 21.13           C  
ATOM  10492  NZ  LYS F 103      58.046  70.764 133.768  1.00 20.81           N  
ATOM  10493  N   PRO F 104      51.996  67.586 137.150  1.00 17.08           N  
ATOM  10494  CA  PRO F 104      51.812  66.262 137.752  1.00 17.23           C  
ATOM  10495  C   PRO F 104      53.184  65.758 138.189  1.00 16.64           C  
ATOM  10496  O   PRO F 104      54.174  65.982 137.489  1.00 16.76           O  
ATOM  10497  CB  PRO F 104      51.232  65.431 136.606  1.00 18.12           C  
ATOM  10498  CG  PRO F 104      50.539  66.452 135.743  1.00 18.60           C  
ATOM  10499  CD  PRO F 104      51.450  67.656 135.779  1.00 18.38           C  
ATOM  10500  N   ALA F 105      53.244  65.091 139.335  1.00 16.02           N  
ATOM  10501  CA  ALA F 105      54.515  64.615 139.881  1.00 16.30           C  
ATOM  10502  C   ALA F 105      55.332  63.800 138.882  1.00 16.69           C  
ATOM  10503  O   ALA F 105      56.547  63.995 138.770  1.00 16.55           O  
ATOM  10504  CB  ALA F 105      54.272  63.810 141.143  1.00 16.32           C  
ATOM  10505  N   THR F 106      54.686  62.908 138.132  1.00 16.61           N  
ATOM  10506  CA  THR F 106      55.435  62.087 137.181  1.00 17.58           C  
ATOM  10507  C   THR F 106      56.181  62.889 136.123  1.00 18.01           C  
ATOM  10508  O   THR F 106      57.168  62.399 135.563  1.00 18.60           O  
ATOM  10509  CB  THR F 106      54.540  61.055 136.482  1.00 18.62           C  
ATOM  10510  OG1 THR F 106      53.397  61.706 135.899  1.00 19.30           O  
ATOM  10511  CG2 THR F 106      53.982  60.054 137.506  1.00 18.94           C  
ATOM  10512  N   GLU F 107      55.719  64.110 135.856  1.00 17.03           N  
ATOM  10513  CA  GLU F 107      56.299  64.945 134.810  1.00 18.56           C  
ATOM  10514  C   GLU F 107      57.358  65.939 135.290  1.00 17.73           C  
ATOM  10515  O   GLU F 107      58.019  66.572 134.470  1.00 18.55           O  
ATOM  10516  CB  GLU F 107      55.189  65.696 134.069  1.00 18.76           C  
ATOM  10517  CG  GLU F 107      54.091  64.795 133.512  1.00 21.28           C  
ATOM  10518  CD  GLU F 107      54.631  63.599 132.758  1.00 24.77           C  
ATOM  10519  OE1 GLU F 107      54.641  62.479 133.333  1.00 28.91           O  
ATOM  10520  OE2 GLU F 107      55.043  63.762 131.591  1.00 28.16           O  
ATOM  10521  N   LEU F 108      57.530  66.066 136.602  1.00 16.93           N  
ATOM  10522  CA  LEU F 108      58.521  66.999 137.140  1.00 16.13           C  
ATOM  10523  C   LEU F 108      59.930  66.564 136.793  1.00 16.62           C  
ATOM  10524  O   LEU F 108      60.226  65.371 136.777  1.00 16.85           O  
ATOM  10525  CB  LEU F 108      58.374  67.110 138.656  1.00 15.57           C  
ATOM  10526  CG  LEU F 108      57.145  67.886 139.122  1.00 15.45           C  
ATOM  10527  CD1 LEU F 108      56.964  67.658 140.607  1.00 15.18           C  
ATOM  10528  CD2 LEU F 108      57.301  69.380 138.858  1.00 16.29           C  
ATOM  10529  N   THR F 109      60.802  67.540 136.536  1.00 16.52           N  
ATOM  10530  CA  THR F 109      62.185  67.252 136.153  1.00 16.81           C  
ATOM  10531  C   THR F 109      63.191  67.704 137.194  1.00 16.63           C  
ATOM  10532  O   THR F 109      62.845  68.384 138.151  1.00 15.61           O  
ATOM  10533  CB  THR F 109      62.546  67.940 134.836  1.00 17.07           C  
ATOM  10534  OG1 THR F 109      62.549  69.365 135.039  1.00 17.95           O  
ATOM  10535  CG2 THR F 109      61.493  67.672 133.759  1.00 18.38           C  
ATOM  10536  N   HIS F 110      64.450  67.324 136.988  1.00 16.78           N  
ATOM  10537  CA  HIS F 110      65.533  67.750 137.868  1.00 16.94           C  
ATOM  10538  C   HIS F 110      65.665  69.266 137.747  1.00 16.74           C  
ATOM  10539  O   HIS F 110      65.987  69.955 138.709  1.00 16.04           O  
ATOM  10540  CB  HIS F 110      66.847  67.084 137.443  1.00 17.83           C  
ATOM  10541  CG  HIS F 110      67.833  66.871 138.553  1.00 18.30           C  
ATOM  10542  ND1 HIS F 110      67.882  67.648 139.686  1.00 21.21           N  
ATOM  10543  CD2 HIS F 110      68.833  65.962 138.677  1.00 18.53           C  
ATOM  10544  CE1 HIS F 110      68.864  67.231 140.464  1.00 18.93           C  
ATOM  10545  NE2 HIS F 110      69.452  66.202 139.879  1.00 22.79           N  
ATOM  10546  N   GLU F 111      65.422  69.775 136.546  1.00 17.17           N  
ATOM  10547  CA  GLU F 111      65.458  71.211 136.305  1.00 17.50           C  
ATOM  10548  C   GLU F 111      64.379  71.913 137.142  1.00 16.56           C  
ATOM  10549  O   GLU F 111      64.630  72.963 137.759  1.00 16.58           O  
ATOM  10550  CB  GLU F 111      65.300  71.448 134.804  1.00 18.35           C  
ATOM  10551  CG  GLU F 111      64.911  72.829 134.342  1.00 22.38           C  
ATOM  10552  CD  GLU F 111      64.815  72.927 132.823  1.00 25.05           C  
ATOM  10553  OE1 GLU F 111      63.853  72.434 132.197  1.00 23.22           O  
ATOM  10554  OE2 GLU F 111      65.744  73.503 132.219  1.00 31.15           O  
ATOM  10555  N   ASP F 112      63.186  71.326 137.199  1.00 15.99           N  
ATOM  10556  CA  ASP F 112      62.130  71.899 138.024  1.00 16.15           C  
ATOM  10557  C   ASP F 112      62.522  71.861 139.501  1.00 15.36           C  
ATOM  10558  O   ASP F 112      62.236  72.783 140.242  1.00 15.58           O  
ATOM  10559  CB  ASP F 112      60.826  71.124 137.882  1.00 16.14           C  
ATOM  10560  CG  ASP F 112      60.260  71.158 136.484  1.00 16.91           C  
ATOM  10561  OD1 ASP F 112      60.457  72.162 135.773  1.00 18.77           O  
ATOM  10562  OD2 ASP F 112      59.592  70.208 136.044  1.00 16.59           O  
ATOM  10563  N   PHE F 113      63.163  70.766 139.913  1.00 15.31           N  
ATOM  10564  CA  PHE F 113      63.619  70.607 141.288  1.00 15.13           C  
ATOM  10565  C   PHE F 113      64.605  71.704 141.652  1.00 15.31           C  
ATOM  10566  O   PHE F 113      64.466  72.354 142.687  1.00 14.50           O  
ATOM  10567  CB  PHE F 113      64.266  69.226 141.474  1.00 15.31           C  
ATOM  10568  CG  PHE F 113      64.767  68.985 142.862  1.00 15.36           C  
ATOM  10569  CD1 PHE F 113      66.086  69.262 143.199  1.00 16.20           C  
ATOM  10570  CD2 PHE F 113      63.923  68.497 143.835  1.00 15.71           C  
ATOM  10571  CE1 PHE F 113      66.548  69.046 144.492  1.00 16.33           C  
ATOM  10572  CE2 PHE F 113      64.382  68.277 145.133  1.00 14.96           C  
ATOM  10573  CZ  PHE F 113      65.696  68.573 145.461  1.00 16.07           C  
ATOM  10574  N   ALA F 114      65.596  71.914 140.788  1.00 14.95           N  
ATOM  10575  CA  ALA F 114      66.606  72.937 141.043  1.00 15.71           C  
ATOM  10576  C   ALA F 114      65.947  74.307 141.128  1.00 15.73           C  
ATOM  10577  O   ALA F 114      66.257  75.101 142.025  1.00 15.34           O  
ATOM  10578  CB  ALA F 114      67.650  72.916 139.940  1.00 16.99           C  
ATOM  10579  N   PHE F 115      65.046  74.580 140.189  1.00 16.02           N  
ATOM  10580  CA  PHE F 115      64.378  75.875 140.137  1.00 16.32           C  
ATOM  10581  C   PHE F 115      63.687  76.206 141.463  1.00 16.28           C  
ATOM  10582  O   PHE F 115      63.880  77.269 142.030  1.00 17.02           O  
ATOM  10583  CB  PHE F 115      63.362  75.898 139.000  1.00 17.24           C  
ATOM  10584  CG  PHE F 115      62.572  77.174 138.926  1.00 16.72           C  
ATOM  10585  CD1 PHE F 115      63.188  78.376 138.614  1.00 19.20           C  
ATOM  10586  CD2 PHE F 115      61.215  77.172 139.195  1.00 16.54           C  
ATOM  10587  CE1 PHE F 115      62.444  79.551 138.553  1.00 20.17           C  
ATOM  10588  CE2 PHE F 115      60.470  78.341 139.126  1.00 17.68           C  
ATOM  10589  CZ  PHE F 115      61.082  79.517 138.810  1.00 19.17           C  
ATOM  10590  N   VAL F 116      62.882  75.278 141.953  1.00 15.25           N  
ATOM  10591  CA  VAL F 116      62.156  75.482 143.196  1.00 15.13           C  
ATOM  10592  C   VAL F 116      63.063  75.489 144.421  1.00 15.18           C  
ATOM  10593  O   VAL F 116      63.011  76.404 145.240  1.00 15.54           O  
ATOM  10594  CB  VAL F 116      61.054  74.409 143.375  1.00 14.76           C  
ATOM  10595  CG1 VAL F 116      60.389  74.526 144.738  1.00 14.98           C  
ATOM  10596  CG2 VAL F 116      60.007  74.513 142.255  1.00 14.87           C  
ATOM  10597  N   TYR F 117      63.911  74.469 144.541  1.00 15.18           N  
ATOM  10598  CA  TYR F 117      64.741  74.354 145.735  1.00 15.05           C  
ATOM  10599  C   TYR F 117      65.850  75.403 145.849  1.00 15.00           C  
ATOM  10600  O   TYR F 117      66.226  75.790 146.959  1.00 15.36           O  
ATOM  10601  CB  TYR F 117      65.292  72.931 145.867  1.00 15.23           C  
ATOM  10602  CG  TYR F 117      64.306  72.004 146.535  1.00 14.82           C  
ATOM  10603  CD1 TYR F 117      63.158  71.577 145.876  1.00 15.06           C  
ATOM  10604  CD2 TYR F 117      64.503  71.589 147.848  1.00 14.37           C  
ATOM  10605  CE1 TYR F 117      62.230  70.744 146.523  1.00 14.94           C  
ATOM  10606  CE2 TYR F 117      63.596  70.763 148.488  1.00 14.81           C  
ATOM  10607  CZ  TYR F 117      62.470  70.336 147.830  1.00 14.64           C  
ATOM  10608  OH  TYR F 117      61.581  69.519 148.503  1.00 14.32           O  
ATOM  10609  N   ASP F 118      66.375  75.869 144.724  1.00 15.38           N  
ATOM  10610  CA  ASP F 118      67.432  76.878 144.795  1.00 15.96           C  
ATOM  10611  C   ASP F 118      66.941  78.184 145.391  1.00 16.09           C  
ATOM  10612  O   ASP F 118      67.723  78.912 146.008  1.00 16.00           O  
ATOM  10613  CB  ASP F 118      68.002  77.158 143.410  1.00 16.86           C  
ATOM  10614  CG  ASP F 118      69.232  76.355 143.107  1.00 18.62           C  
ATOM  10615  OD1 ASP F 118      69.713  75.601 143.986  1.00 20.80           O  
ATOM  10616  OD2 ASP F 118      69.798  76.452 141.991  1.00 24.11           O  
ATOM  10617  N   VAL F 119      65.660  78.495 145.212  1.00 15.70           N  
ATOM  10618  CA  VAL F 119      65.110  79.727 145.775  1.00 16.00           C  
ATOM  10619  C   VAL F 119      64.464  79.463 147.130  1.00 15.96           C  
ATOM  10620  O   VAL F 119      64.756  80.133 148.123  1.00 17.00           O  
ATOM  10621  CB  VAL F 119      64.045  80.361 144.850  1.00 16.50           C  
ATOM  10622  CG1 VAL F 119      63.420  81.607 145.517  1.00 17.12           C  
ATOM  10623  CG2 VAL F 119      64.643  80.725 143.524  1.00 17.28           C  
ATOM  10624  N   ASN F 120      63.600  78.452 147.173  1.00 15.23           N  
ATOM  10625  CA  ASN F 120      62.818  78.190 148.380  1.00 15.17           C  
ATOM  10626  C   ASN F 120      63.577  77.644 149.584  1.00 15.19           C  
ATOM  10627  O   ASN F 120      63.121  77.794 150.732  1.00 15.65           O  
ATOM  10628  CB  ASN F 120      61.664  77.247 148.068  1.00 15.08           C  
ATOM  10629  CG  ASN F 120      60.620  77.875 147.200  1.00 15.20           C  
ATOM  10630  OD1 ASN F 120      60.831  78.931 146.602  1.00 16.74           O  
ATOM  10631  ND2 ASN F 120      59.475  77.214 147.106  1.00 16.05           N  
ATOM  10632  N   VAL F 121      64.694  76.967 149.332  1.00 14.75           N  
ATOM  10633  CA  VAL F 121      65.459  76.394 150.419  1.00 14.94           C  
ATOM  10634  C   VAL F 121      66.869  76.961 150.416  1.00 14.94           C  
ATOM  10635  O   VAL F 121      67.277  77.576 151.395  1.00 14.87           O  
ATOM  10636  CB  VAL F 121      65.483  74.854 150.385  1.00 14.76           C  
ATOM  10637  CG1 VAL F 121      66.093  74.312 151.679  1.00 15.55           C  
ATOM  10638  CG2 VAL F 121      64.072  74.307 150.233  1.00 15.40           C  
ATOM  10639  N   PHE F 122      67.619  76.756 149.336  1.00 14.52           N  
ATOM  10640  CA  PHE F 122      68.968  77.304 149.317  1.00 15.16           C  
ATOM  10641  C   PHE F 122      68.925  78.826 149.424  1.00 15.21           C  
ATOM  10642  O   PHE F 122      69.699  79.418 150.170  1.00 15.34           O  
ATOM  10643  CB  PHE F 122      69.794  76.877 148.094  1.00 15.34           C  
ATOM  10644  CG  PHE F 122      71.188  77.440 148.125  1.00 16.01           C  
ATOM  10645  CD1 PHE F 122      72.130  76.923 149.003  1.00 16.00           C  
ATOM  10646  CD2 PHE F 122      71.524  78.551 147.361  1.00 17.04           C  
ATOM  10647  CE1 PHE F 122      73.410  77.483 149.085  1.00 17.60           C  
ATOM  10648  CE2 PHE F 122      72.794  79.111 147.430  1.00 17.55           C  
ATOM  10649  CZ  PHE F 122      73.735  78.578 148.294  1.00 17.26           C  
ATOM  10650  N   GLY F 123      68.031  79.460 148.671  1.00 15.17           N  
ATOM  10651  CA  GLY F 123      67.923  80.908 148.709  1.00 15.73           C  
ATOM  10652  C   GLY F 123      67.645  81.431 150.113  1.00 15.80           C  
ATOM  10653  O   GLY F 123      68.205  82.447 150.543  1.00 16.24           O  
ATOM  10654  N   VAL F 124      66.748  80.754 150.821  1.00 15.43           N  
ATOM  10655  CA  VAL F 124      66.443  81.114 152.196  1.00 15.61           C  
ATOM  10656  C   VAL F 124      67.692  80.946 153.046  1.00 15.73           C  
ATOM  10657  O   VAL F 124      68.113  81.879 153.749  1.00 15.90           O  
ATOM  10658  CB  VAL F 124      65.302  80.236 152.773  1.00 15.24           C  
ATOM  10659  CG1 VAL F 124      65.203  80.418 154.279  1.00 15.53           C  
ATOM  10660  CG2 VAL F 124      63.980  80.587 152.100  1.00 16.09           C  
ATOM  10661  N   PHE F 125      68.294  79.761 152.975  1.00 15.29           N  
ATOM  10662  CA  PHE F 125      69.514  79.501 153.731  1.00 15.40           C  
ATOM  10663  C   PHE F 125      70.604  80.536 153.447  1.00 16.11           C  
ATOM  10664  O   PHE F 125      71.233  81.052 154.354  1.00 15.75           O  
ATOM  10665  CB  PHE F 125      70.082  78.104 153.418  1.00 16.30           C  
ATOM  10666  CG  PHE F 125      71.528  77.982 153.774  1.00 16.23           C  
ATOM  10667  CD1 PHE F 125      71.910  77.774 155.087  1.00 15.87           C  
ATOM  10668  CD2 PHE F 125      72.509  78.153 152.809  1.00 16.50           C  
ATOM  10669  CE1 PHE F 125      73.251  77.719 155.429  1.00 16.80           C  
ATOM  10670  CE2 PHE F 125      73.838  78.101 153.133  1.00 16.78           C  
ATOM  10671  CZ  PHE F 125      74.219  77.876 154.442  1.00 17.71           C  
ATOM  10672  N   ASN F 126      70.815  80.810 152.170  1.00 15.33           N  
ATOM  10673  CA  ASN F 126      71.875  81.703 151.712  1.00 15.89           C  
ATOM  10674  C   ASN F 126      71.690  83.117 152.258  1.00 16.34           C  
ATOM  10675  O   ASN F 126      72.633  83.717 152.787  1.00 16.01           O  
ATOM  10676  CB  ASN F 126      71.863  81.678 150.176  1.00 15.82           C  
ATOM  10677  CG  ASN F 126      73.017  82.449 149.540  1.00 16.83           C  
ATOM  10678  OD1 ASN F 126      74.133  82.531 150.076  1.00 17.47           O  
ATOM  10679  ND2 ASN F 126      72.762  82.968 148.346  1.00 16.26           N  
ATOM  10680  N   THR F 127      70.461  83.620 152.161  1.00 16.51           N  
ATOM  10681  CA  THR F 127      70.139  84.955 152.664  1.00 17.32           C  
ATOM  10682  C   THR F 127      70.305  85.004 154.181  1.00 17.14           C  
ATOM  10683  O   THR F 127      70.885  85.939 154.719  1.00 17.73           O  
ATOM  10684  CB  THR F 127      68.704  85.321 152.286  1.00 17.92           C  
ATOM  10685  OG1 THR F 127      68.567  85.299 150.856  1.00 21.51           O  
ATOM  10686  CG2 THR F 127      68.418  86.762 152.640  1.00 19.51           C  
ATOM  10687  N   CYS F 128      69.786  83.992 154.869  1.00 16.56           N  
ATOM  10688  CA  CYS F 128      69.918  83.950 156.326  1.00 16.71           C  
ATOM  10689  C   CYS F 128      71.380  83.887 156.746  1.00 17.27           C  
ATOM  10690  O   CYS F 128      71.810  84.595 157.668  1.00 17.66           O  
ATOM  10691  CB  CYS F 128      69.185  82.728 156.900  1.00 16.76           C  
ATOM  10692  SG  CYS F 128      67.383  82.793 156.813  1.00 16.40           S  
ATOM  10693  N   ARG F 129      72.139  83.031 156.072  1.00 17.05           N  
ATOM  10694  CA  ARG F 129      73.549  82.841 156.384  1.00 17.33           C  
ATOM  10695  C   ARG F 129      74.368  84.110 156.202  1.00 17.57           C  
ATOM  10696  O   ARG F 129      75.203  84.436 157.040  1.00 18.02           O  
ATOM  10697  CB  ARG F 129      74.124  81.694 155.537  1.00 17.43           C  
ATOM  10698  CG  ARG F 129      75.622  81.445 155.727  1.00 18.04           C  
ATOM  10699  CD  ARG F 129      76.508  82.228 154.760  1.00 18.20           C  
ATOM  10700  NE  ARG F 129      76.112  81.956 153.380  1.00 18.59           N  
ATOM  10701  CZ  ARG F 129      76.393  80.828 152.746  1.00 18.51           C  
ATOM  10702  NH1 ARG F 129      77.103  79.886 153.362  1.00 17.54           N  
ATOM  10703  NH2 ARG F 129      75.962  80.630 151.504  1.00 17.10           N  
ATOM  10704  N   ALA F 130      74.122  84.827 155.110  1.00 17.49           N  
ATOM  10705  CA  ALA F 130      74.874  86.050 154.839  1.00 18.18           C  
ATOM  10706  C   ALA F 130      74.652  87.098 155.925  1.00 18.90           C  
ATOM  10707  O   ALA F 130      75.595  87.734 156.390  1.00 20.12           O  
ATOM  10708  CB  ALA F 130      74.495  86.617 153.477  1.00 18.38           C  
ATOM  10709  N   VAL F 131      73.397  87.276 156.318  1.00 18.61           N  
ATOM  10710  CA  VAL F 131      73.072  88.249 157.355  1.00 19.01           C  
ATOM  10711  C   VAL F 131      73.632  87.779 158.692  1.00 19.31           C  
ATOM  10712  O   VAL F 131      74.234  88.552 159.428  1.00 19.61           O  
ATOM  10713  CB  VAL F 131      71.544  88.461 157.459  1.00 19.02           C  
ATOM  10714  CG1 VAL F 131      71.190  89.359 158.640  1.00 19.34           C  
ATOM  10715  CG2 VAL F 131      70.984  89.052 156.162  1.00 18.90           C  
ATOM  10716  N   ALA F 132      73.442  86.502 159.011  1.00 18.86           N  
ATOM  10717  CA  ALA F 132      73.937  85.986 160.281  1.00 19.32           C  
ATOM  10718  C   ALA F 132      75.456  86.115 160.409  1.00 19.98           C  
ATOM  10719  O   ALA F 132      75.976  86.435 161.484  1.00 20.60           O  
ATOM  10720  CB  ALA F 132      73.501  84.536 160.478  1.00 19.25           C  
ATOM  10721  N   LYS F 133      76.176  85.853 159.318  1.00 20.09           N  
ATOM  10722  CA  LYS F 133      77.628  85.981 159.349  1.00 21.01           C  
ATOM  10723  C   LYS F 133      78.036  87.415 159.674  1.00 21.57           C  
ATOM  10724  O   LYS F 133      78.972  87.649 160.435  1.00 22.37           O  
ATOM  10725  CB  LYS F 133      78.244  85.559 158.009  1.00 21.33           C  
ATOM  10726  CG  LYS F 133      78.325  84.069 157.813  1.00 22.21           C  
ATOM  10727  CD  LYS F 133      79.291  83.708 156.694  1.00 22.68           C  
ATOM  10728  CE  LYS F 133      80.739  83.869 157.131  1.00 24.72           C  
ATOM  10729  NZ  LYS F 133      81.676  83.570 156.019  1.00 28.18           N  
ATOM  10730  N   LEU F 134      77.333  88.370 159.077  1.00 21.48           N  
ATOM  10731  CA  LEU F 134      77.608  89.776 159.329  1.00 22.32           C  
ATOM  10732  C   LEU F 134      77.354  90.096 160.806  1.00 22.45           C  
ATOM  10733  O   LEU F 134      78.169  90.749 161.468  1.00 23.84           O  
ATOM  10734  CB  LEU F 134      76.732  90.638 158.424  1.00 22.50           C  
ATOM  10735  CG  LEU F 134      76.802  92.161 158.539  1.00 24.64           C  
ATOM  10736  CD1 LEU F 134      78.202  92.648 158.321  1.00 27.49           C  
ATOM  10737  CD2 LEU F 134      75.851  92.740 157.496  1.00 26.38           C  
ATOM  10738  N   TRP F 135      76.222  89.623 161.323  1.00 22.12           N  
ATOM  10739  CA  TRP F 135      75.873  89.854 162.718  1.00 22.28           C  
ATOM  10740  C   TRP F 135      76.899  89.241 163.658  1.00 22.84           C  
ATOM  10741  O   TRP F 135      77.299  89.859 164.643  1.00 23.94           O  
ATOM  10742  CB  TRP F 135      74.493  89.281 163.026  1.00 21.65           C  
ATOM  10743  CG  TRP F 135      73.359  90.118 162.516  1.00 20.80           C  
ATOM  10744  CD1 TRP F 135      73.399  91.437 162.168  1.00 21.97           C  
ATOM  10745  CD2 TRP F 135      72.012  89.686 162.291  1.00 20.35           C  
ATOM  10746  NE1 TRP F 135      72.157  91.854 161.752  1.00 20.05           N  
ATOM  10747  CE2 TRP F 135      71.286  90.798 161.817  1.00 20.70           C  
ATOM  10748  CE3 TRP F 135      71.343  88.465 162.440  1.00 19.78           C  
ATOM  10749  CZ2 TRP F 135      69.928  90.732 161.505  1.00 19.69           C  
ATOM  10750  CZ3 TRP F 135      69.990  88.399 162.126  1.00 19.77           C  
ATOM  10751  CH2 TRP F 135      69.299  89.524 161.658  1.00 19.93           C  
ATOM  10752  N   LEU F 136      77.324  88.020 163.358  1.00 22.44           N  
ATOM  10753  CA  LEU F 136      78.301  87.338 164.204  1.00 23.10           C  
ATOM  10754  C   LEU F 136      79.628  88.082 164.185  1.00 24.42           C  
ATOM  10755  O   LEU F 136      80.298  88.206 165.216  1.00 25.59           O  
ATOM  10756  CB  LEU F 136      78.507  85.902 163.734  1.00 22.79           C  
ATOM  10757  CG  LEU F 136      77.304  84.986 163.920  1.00 22.00           C  
ATOM  10758  CD1 LEU F 136      77.490  83.678 163.163  1.00 22.83           C  
ATOM  10759  CD2 LEU F 136      77.057  84.727 165.397  1.00 22.67           C  
ATOM  10760  N   GLN F 137      80.010  88.575 163.009  1.00 24.51           N  
ATOM  10761  CA  GLN F 137      81.260  89.309 162.851  1.00 25.81           C  
ATOM  10762  C   GLN F 137      81.254  90.610 163.645  1.00 26.51           C  
ATOM  10763  O   GLN F 137      82.275  91.004 164.223  1.00 28.08           O  
ATOM  10764  CB  GLN F 137      81.514  89.617 161.369  1.00 25.57           C  
ATOM  10765  CG  GLN F 137      82.745  90.458 161.104  1.00 29.12           C  
ATOM  10766  CD  GLN F 137      82.872  90.861 159.647  1.00 32.44           C  
ATOM  10767  OE1 GLN F 137      81.961  91.482 159.080  1.00 36.12           O  
ATOM  10768  NE2 GLN F 137      83.998  90.515 159.034  1.00 35.95           N  
ATOM  10769  N   LYS F 138      80.105  91.281 163.657  1.00 26.15           N  
ATOM  10770  CA  LYS F 138      79.978  92.571 164.327  1.00 26.93           C  
ATOM  10771  C   LYS F 138      79.385  92.479 165.726  1.00 27.01           C  
ATOM  10772  O   LYS F 138      79.100  93.507 166.354  1.00 28.04           O  
ATOM  10773  CB  LYS F 138      79.141  93.518 163.463  1.00 26.82           C  
ATOM  10774  CG  LYS F 138      79.728  93.742 162.082  1.00 27.82           C  
ATOM  10775  CD  LYS F 138      79.124  94.957 161.405  1.00 29.25           C  
ATOM  10776  CE  LYS F 138      79.906  95.324 160.152  1.00 30.87           C  
ATOM  10777  NZ  LYS F 138      79.594  96.709 159.703  1.00 33.36           N  
ATOM  10778  N   GLN F 139      79.212  91.255 166.216  1.00 26.85           N  
ATOM  10779  CA  GLN F 139      78.631  91.011 167.536  1.00 26.92           C  
ATOM  10780  C   GLN F 139      77.294  91.737 167.692  1.00 26.16           C  
ATOM  10781  O   GLN F 139      77.027  92.375 168.710  1.00 27.25           O  
ATOM  10782  CB  GLN F 139      79.612  91.400 168.652  1.00 28.52           C  
ATOM  10783  CG  GLN F 139      80.962  90.678 168.580  1.00 30.19           C  
ATOM  10784  CD  GLN F 139      81.823  90.921 169.806  1.00 32.88           C  
ATOM  10785  OE1 GLN F 139      81.458  90.524 170.915  1.00 37.07           O  
ATOM  10786  NE2 GLN F 139      82.951  91.587 169.617  1.00 36.64           N  
ATOM  10787  N   GLN F 140      76.460  91.634 166.663  1.00 25.20           N  
ATOM  10788  CA  GLN F 140      75.138  92.244 166.665  1.00 24.65           C  
ATOM  10789  C   GLN F 140      74.067  91.164 166.828  1.00 24.02           C  
ATOM  10790  O   GLN F 140      74.279  90.003 166.462  1.00 23.68           O  
ATOM  10791  CB  GLN F 140      74.904  93.003 165.347  1.00 24.82           C  
ATOM  10792  CG  GLN F 140      75.881  94.161 165.072  1.00 25.02           C  
ATOM  10793  CD  GLN F 140      75.657  94.811 163.708  1.00 25.46           C  
ATOM  10794  OE1 GLN F 140      75.396  94.117 162.725  1.00 25.74           O  
ATOM  10795  NE2 GLN F 140      75.767  96.136 163.646  1.00 29.03           N  
ATOM  10796  N   LYS F 141      72.920  91.548 167.377  1.00 23.72           N  
ATOM  10797  CA  LYS F 141      71.798  90.626 167.530  1.00 23.15           C  
ATOM  10798  C   LYS F 141      70.798  90.896 166.422  1.00 22.37           C  
ATOM  10799  O   LYS F 141      70.815  91.967 165.825  1.00 23.20           O  
ATOM  10800  CB  LYS F 141      71.133  90.827 168.889  1.00 23.55           C  
ATOM  10801  CG  LYS F 141      72.010  90.449 170.068  1.00 25.36           C  
ATOM  10802  CD  LYS F 141      71.236  90.559 171.362  1.00 27.91           C  
ATOM  10803  CE  LYS F 141      72.129  90.359 172.579  1.00 29.66           C  
ATOM  10804  NZ  LYS F 141      71.396  90.575 173.863  1.00 34.27           N  
ATOM  10805  N   GLY F 142      69.923  89.936 166.140  1.00 21.08           N  
ATOM  10806  CA  GLY F 142      68.957  90.142 165.080  1.00 20.50           C  
ATOM  10807  C   GLY F 142      67.852  89.114 165.087  1.00 19.05           C  
ATOM  10808  O   GLY F 142      67.922  88.107 165.798  1.00 19.51           O  
ATOM  10809  N   SER F 143      66.834  89.370 164.281  1.00 18.52           N  
ATOM  10810  CA  SER F 143      65.699  88.459 164.186  1.00 18.49           C  
ATOM  10811  C   SER F 143      65.398  88.180 162.722  1.00 18.29           C  
ATOM  10812  O   SER F 143      65.354  89.115 161.910  1.00 17.78           O  
ATOM  10813  CB  SER F 143      64.478  89.074 164.867  1.00 19.02           C  
ATOM  10814  OG  SER F 143      63.358  88.207 164.737  1.00 18.75           O  
ATOM  10815  N   ILE F 144      65.219  86.902 162.396  1.00 17.14           N  
ATOM  10816  CA  ILE F 144      64.944  86.472 161.027  1.00 17.26           C  
ATOM  10817  C   ILE F 144      63.590  85.793 160.943  1.00 17.00           C  
ATOM  10818  O   ILE F 144      63.283  84.896 161.732  1.00 16.53           O  
ATOM  10819  CB  ILE F 144      66.025  85.496 160.537  1.00 17.22           C  
ATOM  10820  CG1 ILE F 144      67.402  86.168 160.560  1.00 18.05           C  
ATOM  10821  CG2 ILE F 144      65.683  84.994 159.140  1.00 17.06           C  
ATOM  10822  CD1 ILE F 144      68.541  85.239 160.141  1.00 18.78           C  
ATOM  10823  N   VAL F 145      62.788  86.233 159.984  1.00 16.87           N  
ATOM  10824  CA  VAL F 145      61.497  85.607 159.710  1.00 16.71           C  
ATOM  10825  C   VAL F 145      61.564  85.030 158.305  1.00 16.68           C  
ATOM  10826  O   VAL F 145      61.966  85.717 157.372  1.00 17.14           O  
ATOM  10827  CB  VAL F 145      60.332  86.628 159.776  1.00 16.99           C  
ATOM  10828  CG1 VAL F 145      59.020  85.961 159.332  1.00 17.62           C  
ATOM  10829  CG2 VAL F 145      60.200  87.225 161.184  1.00 17.65           C  
ATOM  10830  N   VAL F 146      61.212  83.756 158.171  1.00 15.84           N  
ATOM  10831  CA  VAL F 146      61.215  83.091 156.875  1.00 15.95           C  
ATOM  10832  C   VAL F 146      59.787  82.826 156.446  1.00 15.48           C  
ATOM  10833  O   VAL F 146      59.004  82.289 157.230  1.00 15.89           O  
ATOM  10834  CB  VAL F 146      61.951  81.750 156.936  1.00 15.51           C  
ATOM  10835  CG1 VAL F 146      61.833  81.024 155.597  1.00 16.49           C  
ATOM  10836  CG2 VAL F 146      63.411  81.957 157.310  1.00 16.86           C  
ATOM  10837  N   THR F 147      59.428  83.220 155.222  1.00 15.52           N  
ATOM  10838  CA  THR F 147      58.079  82.935 154.734  1.00 15.72           C  
ATOM  10839  C   THR F 147      58.018  81.504 154.247  1.00 15.55           C  
ATOM  10840  O   THR F 147      58.571  81.175 153.194  1.00 15.33           O  
ATOM  10841  CB  THR F 147      57.670  83.841 153.560  1.00 15.84           C  
ATOM  10842  OG1 THR F 147      57.864  85.224 153.885  1.00 16.29           O  
ATOM  10843  CG2 THR F 147      56.144  83.700 153.310  1.00 16.30           C  
ATOM  10844  N   SER F 148      57.355  80.654 155.015  1.00 15.04           N  
ATOM  10845  CA  SER F 148      57.174  79.270 154.605  1.00 14.96           C  
ATOM  10846  C   SER F 148      55.782  79.171 153.998  1.00 15.24           C  
ATOM  10847  O   SER F 148      55.472  79.923 153.077  1.00 15.89           O  
ATOM  10848  CB  SER F 148      57.360  78.329 155.773  1.00 15.15           C  
ATOM  10849  OG  SER F 148      57.313  76.998 155.305  1.00 14.45           O  
ATOM  10850  N   SER F 149      54.944  78.277 154.525  1.00 14.32           N  
ATOM  10851  CA  SER F 149      53.587  78.098 154.027  1.00 14.75           C  
ATOM  10852  C   SER F 149      52.923  76.990 154.814  1.00 14.57           C  
ATOM  10853  O   SER F 149      53.619  76.108 155.327  1.00 14.38           O  
ATOM  10854  CB  SER F 149      53.615  77.693 152.548  1.00 14.78           C  
ATOM  10855  OG  SER F 149      52.309  77.335 152.107  1.00 15.28           O  
ATOM  10856  N   MET F 150      51.591  77.018 154.904  1.00 14.57           N  
ATOM  10857  CA  MET F 150      50.874  75.907 155.524  1.00 14.79           C  
ATOM  10858  C   MET F 150      51.136  74.629 154.726  1.00 14.75           C  
ATOM  10859  O   MET F 150      50.906  73.513 155.218  1.00 14.66           O  
ATOM  10860  CB  MET F 150      49.371  76.198 155.647  1.00 15.57           C  
ATOM  10861  CG  MET F 150      48.611  76.223 154.341  1.00 15.25           C  
ATOM  10862  SD  MET F 150      46.861  76.421 154.671  1.00 15.39           S  
ATOM  10863  CE  MET F 150      46.239  76.470 152.970  1.00 15.78           C  
ATOM  10864  N   SER F 151      51.624  74.797 153.492  1.00 14.72           N  
ATOM  10865  CA  SER F 151      51.990  73.668 152.632  1.00 14.89           C  
ATOM  10866  C   SER F 151      53.130  72.849 153.230  1.00 14.47           C  
ATOM  10867  O   SER F 151      53.464  71.771 152.733  1.00 14.08           O  
ATOM  10868  CB  SER F 151      52.396  74.154 151.238  1.00 14.98           C  
ATOM  10869  OG  SER F 151      51.325  74.822 150.583  1.00 15.49           O  
ATOM  10870  N   SER F 152      53.745  73.367 154.287  1.00 14.29           N  
ATOM  10871  CA  SER F 152      54.786  72.611 154.962  1.00 13.89           C  
ATOM  10872  C   SER F 152      54.177  71.405 155.680  1.00 14.29           C  
ATOM  10873  O   SER F 152      54.892  70.442 155.996  1.00 14.85           O  
ATOM  10874  CB  SER F 152      55.486  73.502 155.988  1.00 13.89           C  
ATOM  10875  OG  SER F 152      54.621  73.710 157.095  1.00 14.29           O  
ATOM  10876  N   GLN F 153      52.865  71.452 155.918  1.00 14.76           N  
ATOM  10877  CA  GLN F 153      52.166  70.416 156.673  1.00 14.80           C  
ATOM  10878  C   GLN F 153      51.197  69.602 155.840  1.00 15.33           C  
ATOM  10879  O   GLN F 153      50.949  68.446 156.153  1.00 16.20           O  
ATOM  10880  CB  GLN F 153      51.355  71.033 157.827  1.00 15.65           C  
ATOM  10881  CG  GLN F 153      52.153  71.881 158.774  1.00 17.04           C  
ATOM  10882  CD  GLN F 153      53.279  71.113 159.413  1.00 17.66           C  
ATOM  10883  OE1 GLN F 153      54.405  71.618 159.501  1.00 22.25           O  
ATOM  10884  NE2 GLN F 153      52.994  69.884 159.852  1.00 24.27           N  
ATOM  10885  N   ILE F 154      50.606  70.217 154.824  1.00 14.66           N  
ATOM  10886  CA  ILE F 154      49.580  69.548 154.028  1.00 14.95           C  
ATOM  10887  C   ILE F 154      49.833  69.724 152.541  1.00 14.84           C  
ATOM  10888  O   ILE F 154      50.661  70.527 152.144  1.00 15.84           O  
ATOM  10889  CB  ILE F 154      48.181  70.126 154.356  1.00 14.75           C  
ATOM  10890  CG1 ILE F 154      48.160  71.628 154.058  1.00 15.36           C  
ATOM  10891  CG2 ILE F 154      47.809  69.858 155.821  1.00 14.63           C  
ATOM  10892  CD1 ILE F 154      46.777  72.245 154.092  1.00 15.60           C  
ATOM  10893  N   ILE F 155      49.111  68.956 151.737  1.00 14.81           N  
ATOM  10894  CA  ILE F 155      49.134  69.082 150.291  1.00 14.93           C  
ATOM  10895  C   ILE F 155      47.877  69.850 149.912  1.00 15.21           C  
ATOM  10896  O   ILE F 155      46.788  69.561 150.419  1.00 15.28           O  
ATOM  10897  CB  ILE F 155      49.143  67.687 149.641  1.00 15.27           C  
ATOM  10898  CG1 ILE F 155      50.367  66.897 150.115  1.00 14.67           C  
ATOM  10899  CG2 ILE F 155      49.112  67.795 148.117  1.00 15.70           C  
ATOM  10900  CD1 ILE F 155      51.726  67.609 149.861  1.00 15.05           C  
ATOM  10901  N   ASN F 156      48.026  70.837 149.044  1.00 15.57           N  
ATOM  10902  CA  ASN F 156      46.905  71.664 148.632  1.00 15.71           C  
ATOM  10903  C   ASN F 156      46.025  70.943 147.625  1.00 16.37           C  
ATOM  10904  O   ASN F 156      46.479  70.014 146.951  1.00 16.56           O  
ATOM  10905  CB  ASN F 156      47.430  72.954 148.013  1.00 15.97           C  
ATOM  10906  CG  ASN F 156      48.306  73.726 148.962  1.00 16.23           C  
ATOM  10907  OD1 ASN F 156      49.520  73.510 149.010  1.00 15.65           O  
ATOM  10908  ND2 ASN F 156      47.702  74.625 149.737  1.00 17.01           N  
ATOM  10909  N   GLN F 157      44.769  71.378 147.514  1.00 16.77           N  
ATOM  10910  CA  GLN F 157      43.845  70.757 146.565  1.00 17.13           C  
ATOM  10911  C   GLN F 157      43.480  71.713 145.461  1.00 17.75           C  
ATOM  10912  O   GLN F 157      43.430  72.924 145.678  1.00 18.19           O  
ATOM  10913  CB  GLN F 157      42.539  70.342 147.237  1.00 18.13           C  
ATOM  10914  CG  GLN F 157      42.678  69.306 148.340  1.00 17.60           C  
ATOM  10915  CD  GLN F 157      41.317  68.785 148.771  1.00 18.27           C  
ATOM  10916  OE1 GLN F 157      40.327  69.517 148.725  1.00 23.67           O  
ATOM  10917  NE2 GLN F 157      41.256  67.531 149.172  1.00 20.32           N  
ATOM  10918  N   SER F 158      43.246  71.159 144.280  1.00 17.84           N  
ATOM  10919  CA  SER F 158      42.746  71.934 143.144  1.00 18.58           C  
ATOM  10920  C   SER F 158      41.261  71.651 142.948  1.00 19.09           C  
ATOM  10921  O   SER F 158      40.535  72.460 142.368  1.00 18.83           O  
ATOM  10922  CB  SER F 158      43.531  71.613 141.869  1.00 18.85           C  
ATOM  10923  OG  SER F 158      43.541  70.219 141.589  1.00 20.15           O  
ATOM  10924  N   SER F 159      40.823  70.480 143.404  1.00 18.62           N  
ATOM  10925  CA  SER F 159      39.429  70.061 143.325  1.00 19.86           C  
ATOM  10926  C   SER F 159      39.156  69.104 144.481  1.00 19.47           C  
ATOM  10927  O   SER F 159      40.071  68.762 145.229  1.00 18.81           O  
ATOM  10928  CB  SER F 159      39.128  69.380 141.982  1.00 20.61           C  
ATOM  10929  OG  SER F 159      39.865  68.173 141.836  1.00 22.43           O  
ATOM  10930  N   LEU F 160      37.905  68.673 144.634  1.00 20.79           N  
ATOM  10931  CA  LEU F 160      37.569  67.769 145.729  1.00 21.08           C  
ATOM  10932  C   LEU F 160      38.420  66.507 145.683  1.00 20.01           C  
ATOM  10933  O   LEU F 160      38.414  65.795 144.686  1.00 20.62           O  
ATOM  10934  CB  LEU F 160      36.092  67.393 145.693  1.00 22.49           C  
ATOM  10935  CG  LEU F 160      35.656  66.361 146.739  1.00 23.26           C  
ATOM  10936  CD1 LEU F 160      35.905  66.918 148.121  1.00 23.50           C  
ATOM  10937  CD2 LEU F 160      34.214  65.998 146.541  1.00 25.58           C  
ATOM  10938  N   ASN F 161      39.157  66.250 146.763  1.00 19.01           N  
ATOM  10939  CA  ASN F 161      40.001  65.054 146.850  1.00 18.45           C  
ATOM  10940  C   ASN F 161      41.027  65.008 145.727  1.00 18.61           C  
ATOM  10941  O   ASN F 161      41.499  63.934 145.362  1.00 18.92           O  
ATOM  10942  CB  ASN F 161      39.130  63.796 146.796  1.00 18.78           C  
ATOM  10943  CG  ASN F 161      39.758  62.594 147.494  1.00 19.16           C  
ATOM  10944  OD1 ASN F 161      39.465  61.445 147.144  1.00 20.56           O  
ATOM  10945  ND2 ASN F 161      40.580  62.844 148.496  1.00 14.93           N  
ATOM  10946  N   GLY F 162      41.365  66.177 145.185  1.00 17.71           N  
ATOM  10947  CA  GLY F 162      42.293  66.256 144.065  1.00 17.93           C  
ATOM  10948  C   GLY F 162      43.408  67.238 144.313  1.00 17.44           C  
ATOM  10949  O   GLY F 162      43.172  68.419 144.556  1.00 17.00           O  
ATOM  10950  N   SER F 163      44.638  66.752 144.254  1.00 16.87           N  
ATOM  10951  CA  SER F 163      45.797  67.586 144.564  1.00 16.58           C  
ATOM  10952  C   SER F 163      46.042  68.748 143.604  1.00 16.73           C  
ATOM  10953  O   SER F 163      45.765  68.650 142.405  1.00 17.11           O  
ATOM  10954  CB  SER F 163      47.056  66.711 144.567  1.00 17.00           C  
ATOM  10955  OG  SER F 163      48.227  67.494 144.697  1.00 17.07           O  
ATOM  10956  N   LEU F 164      46.518  69.858 144.170  1.00 15.95           N  
ATOM  10957  CA  LEU F 164      47.062  70.956 143.395  1.00 16.84           C  
ATOM  10958  C   LEU F 164      48.488  70.443 143.234  1.00 16.32           C  
ATOM  10959  O   LEU F 164      49.289  70.512 144.168  1.00 16.15           O  
ATOM  10960  CB  LEU F 164      47.031  72.251 144.206  1.00 17.42           C  
ATOM  10961  CG  LEU F 164      47.700  73.449 143.532  1.00 18.01           C  
ATOM  10962  CD1 LEU F 164      46.947  73.853 142.293  1.00 20.71           C  
ATOM  10963  CD2 LEU F 164      47.836  74.613 144.514  1.00 18.78           C  
ATOM  10964  N   THR F 165      48.788  69.890 142.066  1.00 16.13           N  
ATOM  10965  CA  THR F 165      50.048  69.172 141.865  1.00 16.32           C  
ATOM  10966  C   THR F 165      51.283  70.050 141.803  1.00 15.62           C  
ATOM  10967  O   THR F 165      51.570  70.670 140.785  1.00 16.16           O  
ATOM  10968  CB  THR F 165      49.989  68.322 140.592  1.00 16.46           C  
ATOM  10969  OG1 THR F 165      49.760  69.171 139.460  1.00 17.30           O  
ATOM  10970  CG2 THR F 165      48.783  67.369 140.630  1.00 17.47           C  
ATOM  10971  N   GLN F 166      52.040  70.060 142.893  1.00 14.94           N  
ATOM  10972  CA  GLN F 166      53.262  70.850 142.972  1.00 15.00           C  
ATOM  10973  C   GLN F 166      54.116  70.274 144.096  1.00 15.04           C  
ATOM  10974  O   GLN F 166      54.494  70.979 145.030  1.00 14.66           O  
ATOM  10975  CB  GLN F 166      52.927  72.327 143.246  1.00 15.23           C  
ATOM  10976  CG  GLN F 166      51.964  72.548 144.421  1.00 15.68           C  
ATOM  10977  CD  GLN F 166      51.748  74.020 144.758  1.00 16.08           C  
ATOM  10978  OE1 GLN F 166      52.077  74.899 143.973  1.00 18.45           O  
ATOM  10979  NE2 GLN F 166      51.200  74.284 145.944  1.00 17.30           N  
ATOM  10980  N   VAL F 167      54.442  68.984 143.991  1.00 14.66           N  
ATOM  10981  CA  VAL F 167      55.121  68.330 145.119  1.00 14.63           C  
ATOM  10982  C   VAL F 167      56.435  68.970 145.551  1.00 13.90           C  
ATOM  10983  O   VAL F 167      56.790  68.886 146.721  1.00 14.08           O  
ATOM  10984  CB  VAL F 167      55.319  66.791 144.944  1.00 14.40           C  
ATOM  10985  CG1 VAL F 167      53.982  66.088 144.842  1.00 15.19           C  
ATOM  10986  CG2 VAL F 167      56.157  66.459 143.706  1.00 14.67           C  
ATOM  10987  N   PHE F 168      57.145  69.609 144.625  1.00 14.34           N  
ATOM  10988  CA  PHE F 168      58.391  70.265 144.999  1.00 14.73           C  
ATOM  10989  C   PHE F 168      58.132  71.516 145.838  1.00 14.81           C  
ATOM  10990  O   PHE F 168      58.943  71.871 146.698  1.00 14.39           O  
ATOM  10991  CB  PHE F 168      59.217  70.624 143.758  1.00 14.92           C  
ATOM  10992  CG  PHE F 168      59.775  69.430 143.012  1.00 15.00           C  
ATOM  10993  CD1 PHE F 168      60.233  69.586 141.710  1.00 14.86           C  
ATOM  10994  CD2 PHE F 168      59.841  68.175 143.600  1.00 15.14           C  
ATOM  10995  CE1 PHE F 168      60.756  68.517 141.008  1.00 15.99           C  
ATOM  10996  CE2 PHE F 168      60.358  67.087 142.895  1.00 15.50           C  
ATOM  10997  CZ  PHE F 168      60.815  67.263 141.599  1.00 14.83           C  
ATOM  10998  N   TYR F 169      57.017  72.192 145.582  1.00 14.81           N  
ATOM  10999  CA  TYR F 169      56.670  73.358 146.377  1.00 14.29           C  
ATOM  11000  C   TYR F 169      56.400  72.971 147.827  1.00 14.24           C  
ATOM  11001  O   TYR F 169      57.054  73.457 148.737  1.00 14.03           O  
ATOM  11002  CB  TYR F 169      55.447  74.080 145.815  1.00 15.11           C  
ATOM  11003  CG  TYR F 169      55.085  75.290 146.640  1.00 15.15           C  
ATOM  11004  CD1 TYR F 169      55.810  76.478 146.525  1.00 14.93           C  
ATOM  11005  CD2 TYR F 169      54.044  75.240 147.566  1.00 15.28           C  
ATOM  11006  CE1 TYR F 169      55.493  77.594 147.288  1.00 15.97           C  
ATOM  11007  CE2 TYR F 169      53.718  76.359 148.327  1.00 14.96           C  
ATOM  11008  CZ  TYR F 169      54.443  77.530 148.181  1.00 15.81           C  
ATOM  11009  OH  TYR F 169      54.115  78.628 148.956  1.00 16.02           O  
ATOM  11010  N   ASN F 170      55.434  72.085 148.040  1.00 13.50           N  
ATOM  11011  CA  ASN F 170      55.076  71.719 149.409  1.00 14.00           C  
ATOM  11012  C   ASN F 170      56.271  71.146 150.149  1.00 13.94           C  
ATOM  11013  O   ASN F 170      56.500  71.488 151.311  1.00 13.58           O  
ATOM  11014  CB  ASN F 170      53.878  70.755 149.435  1.00 14.24           C  
ATOM  11015  CG  ASN F 170      52.605  71.396 148.908  1.00 14.33           C  
ATOM  11016  OD1 ASN F 170      51.585  71.484 149.607  1.00 16.10           O  
ATOM  11017  ND2 ASN F 170      52.640  71.820 147.670  1.00 13.83           N  
ATOM  11018  N   SER F 171      57.067  70.323 149.467  1.00 14.01           N  
ATOM  11019  CA  SER F 171      58.214  69.716 150.138  1.00 13.86           C  
ATOM  11020  C   SER F 171      59.296  70.753 150.442  1.00 14.34           C  
ATOM  11021  O   SER F 171      59.942  70.690 151.492  1.00 13.85           O  
ATOM  11022  CB  SER F 171      58.761  68.483 149.384  1.00 13.99           C  
ATOM  11023  OG  SER F 171      59.079  68.762 148.027  1.00 13.95           O  
ATOM  11024  N   SER F 172      59.449  71.739 149.562  1.00 13.54           N  
ATOM  11025  CA  SER F 172      60.439  72.789 149.819  1.00 14.27           C  
ATOM  11026  C   SER F 172      60.052  73.624 151.039  1.00 14.05           C  
ATOM  11027  O   SER F 172      60.911  74.142 151.771  1.00 14.39           O  
ATOM  11028  CB  SER F 172      60.634  73.685 148.595  1.00 14.34           C  
ATOM  11029  OG  SER F 172      59.567  74.604 148.417  1.00 13.93           O  
ATOM  11030  N   LYS F 173      58.749  73.776 151.261  1.00 14.06           N  
ATOM  11031  CA  LYS F 173      58.292  74.551 152.396  1.00 14.40           C  
ATOM  11032  C   LYS F 173      58.464  73.759 153.690  1.00 14.06           C  
ATOM  11033  O   LYS F 173      58.734  74.326 154.745  1.00 14.56           O  
ATOM  11034  CB  LYS F 173      56.851  75.008 152.186  1.00 14.59           C  
ATOM  11035  CG  LYS F 173      56.721  76.059 151.081  1.00 14.56           C  
ATOM  11036  CD  LYS F 173      57.611  77.285 151.350  1.00 14.99           C  
ATOM  11037  CE  LYS F 173      57.277  78.446 150.418  1.00 15.69           C  
ATOM  11038  NZ  LYS F 173      57.988  79.709 150.796  1.00 16.57           N  
ATOM  11039  N   ALA F 174      58.297  72.439 153.621  1.00 14.49           N  
ATOM  11040  CA  ALA F 174      58.570  71.628 154.798  1.00 14.14           C  
ATOM  11041  C   ALA F 174      60.055  71.721 155.137  1.00 14.16           C  
ATOM  11042  O   ALA F 174      60.441  71.828 156.301  1.00 13.86           O  
ATOM  11043  CB  ALA F 174      58.162  70.192 154.551  1.00 14.02           C  
ATOM  11044  N   ALA F 175      60.891  71.730 154.108  1.00 14.17           N  
ATOM  11045  CA  ALA F 175      62.330  71.859 154.326  1.00 14.01           C  
ATOM  11046  C   ALA F 175      62.636  73.195 154.989  1.00 14.85           C  
ATOM  11047  O   ALA F 175      63.415  73.281 155.939  1.00 14.70           O  
ATOM  11048  CB  ALA F 175      63.061  71.754 152.973  1.00 14.62           C  
ATOM  11049  N   CYS F 176      62.006  74.240 154.476  1.00 14.84           N  
ATOM  11050  CA  CYS F 176      62.193  75.589 154.994  1.00 15.95           C  
ATOM  11051  C   CYS F 176      61.846  75.700 156.477  1.00 15.28           C  
ATOM  11052  O   CYS F 176      62.572  76.321 157.273  1.00 16.34           O  
ATOM  11053  CB  CYS F 176      61.296  76.530 154.214  1.00 18.08           C  
ATOM  11054  SG  CYS F 176      61.497  78.236 154.609  1.00 22.62           S  
ATOM  11055  N   SER F 177      60.717  75.115 156.867  1.00 14.76           N  
ATOM  11056  CA  SER F 177      60.310  75.211 158.263  1.00 15.01           C  
ATOM  11057  C   SER F 177      61.237  74.420 159.187  1.00 15.44           C  
ATOM  11058  O   SER F 177      61.428  74.786 160.347  1.00 16.90           O  
ATOM  11059  CB  SER F 177      58.850  74.780 158.423  1.00 14.83           C  
ATOM  11060  OG  SER F 177      58.022  75.681 157.681  1.00 14.98           O  
ATOM  11061  N   ASN F 178      61.819  73.339 158.682  1.00 14.75           N  
ATOM  11062  CA  ASN F 178      62.786  72.588 159.476  1.00 14.43           C  
ATOM  11063  C   ASN F 178      64.118  73.344 159.523  1.00 14.94           C  
ATOM  11064  O   ASN F 178      64.790  73.383 160.559  1.00 14.77           O  
ATOM  11065  CB  ASN F 178      62.971  71.188 158.874  1.00 14.49           C  
ATOM  11066  CG  ASN F 178      63.910  70.322 159.678  1.00 15.53           C  
ATOM  11067  OD1 ASN F 178      63.473  69.468 160.470  1.00 18.53           O  
ATOM  11068  ND2 ASN F 178      65.192  70.524 159.491  1.00 11.93           N  
ATOM  11069  N   LEU F 179      64.489  73.952 158.403  1.00 14.79           N  
ATOM  11070  CA  LEU F 179      65.733  74.717 158.330  1.00 14.61           C  
ATOM  11071  C   LEU F 179      65.736  75.822 159.383  1.00 15.30           C  
ATOM  11072  O   LEU F 179      66.777  76.133 159.978  1.00 14.75           O  
ATOM  11073  CB  LEU F 179      65.874  75.318 156.928  1.00 14.86           C  
ATOM  11074  CG  LEU F 179      67.016  76.308 156.694  1.00 15.70           C  
ATOM  11075  CD1 LEU F 179      68.325  75.569 156.884  1.00 16.18           C  
ATOM  11076  CD2 LEU F 179      66.925  76.886 155.303  1.00 16.52           C  
ATOM  11077  N   VAL F 180      64.580  76.445 159.581  1.00 15.50           N  
ATOM  11078  CA  VAL F 180      64.452  77.464 160.616  1.00 15.83           C  
ATOM  11079  C   VAL F 180      64.859  76.927 162.000  1.00 16.12           C  
ATOM  11080  O   VAL F 180      65.482  77.636 162.801  1.00 16.41           O  
ATOM  11081  CB  VAL F 180      63.013  78.030 160.647  1.00 16.43           C  
ATOM  11082  CG1 VAL F 180      62.736  78.730 161.939  1.00 18.52           C  
ATOM  11083  CG2 VAL F 180      62.779  78.969 159.474  1.00 16.82           C  
ATOM  11084  N   LYS F 181      64.500  75.674 162.293  1.00 15.27           N  
ATOM  11085  CA  LYS F 181      64.888  75.062 163.559  1.00 15.84           C  
ATOM  11086  C   LYS F 181      66.396  74.849 163.618  1.00 15.50           C  
ATOM  11087  O   LYS F 181      67.028  75.102 164.632  1.00 15.65           O  
ATOM  11088  CB  LYS F 181      64.184  73.715 163.758  1.00 16.23           C  
ATOM  11089  CG  LYS F 181      62.687  73.765 163.610  1.00 15.93           C  
ATOM  11090  CD  LYS F 181      62.090  72.370 163.845  1.00 16.71           C  
ATOM  11091  CE  LYS F 181      60.612  72.351 163.591  1.00 18.27           C  
ATOM  11092  NZ  LYS F 181      60.018  70.995 163.817  1.00 22.92           N  
ATOM  11093  N   GLY F 182      66.969  74.375 162.519  1.00 15.46           N  
ATOM  11094  CA  GLY F 182      68.397  74.114 162.494  1.00 15.64           C  
ATOM  11095  C   GLY F 182      69.240  75.362 162.652  1.00 16.26           C  
ATOM  11096  O   GLY F 182      70.224  75.359 163.383  1.00 16.47           O  
ATOM  11097  N   LEU F 183      68.831  76.436 161.990  1.00 15.57           N  
ATOM  11098  CA  LEU F 183      69.566  77.699 162.094  1.00 16.09           C  
ATOM  11099  C   LEU F 183      69.360  78.312 163.478  1.00 16.28           C  
ATOM  11100  O   LEU F 183      70.306  78.822 164.082  1.00 16.54           O  
ATOM  11101  CB  LEU F 183      69.127  78.679 161.002  1.00 15.93           C  
ATOM  11102  CG  LEU F 183      69.323  78.199 159.561  1.00 15.69           C  
ATOM  11103  CD1 LEU F 183      68.779  79.250 158.607  1.00 15.78           C  
ATOM  11104  CD2 LEU F 183      70.792  77.918 159.283  1.00 16.62           C  
ATOM  11105  N   ALA F 184      68.129  78.253 163.987  1.00 15.95           N  
ATOM  11106  CA  ALA F 184      67.837  78.795 165.307  1.00 16.32           C  
ATOM  11107  C   ALA F 184      68.687  78.090 166.359  1.00 16.98           C  
ATOM  11108  O   ALA F 184      69.154  78.706 167.314  1.00 17.46           O  
ATOM  11109  CB  ALA F 184      66.355  78.643 165.623  1.00 16.20           C  
ATOM  11110  N   ALA F 185      68.873  76.785 166.185  1.00 16.98           N  
ATOM  11111  CA  ALA F 185      69.661  75.991 167.132  1.00 17.64           C  
ATOM  11112  C   ALA F 185      71.106  76.458 167.205  1.00 18.37           C  
ATOM  11113  O   ALA F 185      71.684  76.548 168.280  1.00 19.60           O  
ATOM  11114  CB  ALA F 185      69.624  74.506 166.748  1.00 18.38           C  
ATOM  11115  N   GLU F 186      71.692  76.746 166.053  1.00 17.87           N  
ATOM  11116  CA  GLU F 186      73.090  77.145 166.024  1.00 17.95           C  
ATOM  11117  C   GLU F 186      73.339  78.598 166.404  1.00 18.69           C  
ATOM  11118  O   GLU F 186      74.414  78.921 166.895  1.00 19.39           O  
ATOM  11119  CB  GLU F 186      73.685  76.860 164.645  1.00 18.08           C  
ATOM  11120  CG  GLU F 186      73.876  75.377 164.378  1.00 18.01           C  
ATOM  11121  CD  GLU F 186      74.510  75.102 163.032  1.00 17.81           C  
ATOM  11122  OE1 GLU F 186      75.517  75.764 162.706  1.00 18.02           O  
ATOM  11123  OE2 GLU F 186      74.001  74.221 162.314  1.00 16.35           O  
ATOM  11124  N   TRP F 187      72.353  79.463 166.180  1.00 18.07           N  
ATOM  11125  CA  TRP F 187      72.561  80.897 166.384  1.00 18.72           C  
ATOM  11126  C   TRP F 187      71.930  81.451 167.660  1.00 19.25           C  
ATOM  11127  O   TRP F 187      72.084  82.631 167.978  1.00 19.52           O  
ATOM  11128  CB  TRP F 187      72.089  81.681 165.152  1.00 18.62           C  
ATOM  11129  CG  TRP F 187      72.760  81.237 163.873  1.00 18.62           C  
ATOM  11130  CD1 TRP F 187      73.953  80.568 163.757  1.00 18.74           C  
ATOM  11131  CD2 TRP F 187      72.278  81.424 162.538  1.00 18.36           C  
ATOM  11132  NE1 TRP F 187      74.243  80.345 162.431  1.00 18.47           N  
ATOM  11133  CE2 TRP F 187      73.228  80.852 161.664  1.00 18.13           C  
ATOM  11134  CE3 TRP F 187      71.136  82.021 161.986  1.00 17.87           C  
ATOM  11135  CZ2 TRP F 187      73.076  80.860 160.283  1.00 17.54           C  
ATOM  11136  CZ3 TRP F 187      70.982  82.020 160.613  1.00 17.96           C  
ATOM  11137  CH2 TRP F 187      71.952  81.445 159.776  1.00 17.95           C  
ATOM  11138  N   ALA F 188      71.244  80.590 168.403  1.00 18.98           N  
ATOM  11139  CA  ALA F 188      70.598  81.007 169.650  1.00 19.55           C  
ATOM  11140  C   ALA F 188      71.546  81.677 170.640  1.00 21.04           C  
ATOM  11141  O   ALA F 188      71.236  82.749 171.191  1.00 21.22           O  
ATOM  11142  CB  ALA F 188      69.908  79.810 170.311  1.00 19.59           C  
ATOM  11143  N   SER F 189      72.705  81.062 170.861  1.00 21.48           N  
ATOM  11144  CA  SER F 189      73.656  81.596 171.830  1.00 23.09           C  
ATOM  11145  C   SER F 189      74.180  82.978 171.437  1.00 23.05           C  
ATOM  11146  O   SER F 189      74.633  83.729 172.301  1.00 24.14           O  
ATOM  11147  CB  SER F 189      74.803  80.612 172.067  1.00 23.59           C  
ATOM  11148  OG  SER F 189      75.592  80.456 170.905  1.00 26.47           O  
ATOM  11149  N   ALA F 190      74.096  83.317 170.149  1.00 22.81           N  
ATOM  11150  CA  ALA F 190      74.584  84.610 169.661  1.00 23.14           C  
ATOM  11151  C   ALA F 190      73.518  85.695 169.662  1.00 23.07           C  
ATOM  11152  O   ALA F 190      73.755  86.802 169.170  1.00 24.17           O  
ATOM  11153  CB  ALA F 190      75.182  84.475 168.262  1.00 22.83           C  
ATOM  11154  N   GLY F 191      72.346  85.385 170.200  1.00 22.92           N  
ATOM  11155  CA  GLY F 191      71.257  86.351 170.249  1.00 22.44           C  
ATOM  11156  C   GLY F 191      70.561  86.567 168.915  1.00 22.01           C  
ATOM  11157  O   GLY F 191      70.006  87.638 168.640  1.00 22.32           O  
ATOM  11158  N   ILE F 192      70.605  85.554 168.064  1.00 19.89           N  
ATOM  11159  CA  ILE F 192      69.956  85.629 166.767  1.00 19.81           C  
ATOM  11160  C   ILE F 192      68.777  84.667 166.758  1.00 19.26           C  
ATOM  11161  O   ILE F 192      68.955  83.478 166.980  1.00 20.81           O  
ATOM  11162  CB  ILE F 192      70.961  85.259 165.652  1.00 19.08           C  
ATOM  11163  CG1 ILE F 192      72.081  86.306 165.575  1.00 20.51           C  
ATOM  11164  CG2 ILE F 192      70.240  85.140 164.308  1.00 19.23           C  
ATOM  11165  CD1 ILE F 192      73.240  85.860 164.716  1.00 21.02           C  
ATOM  11166  N   ARG F 193      67.582  85.179 166.503  1.00 18.58           N  
ATOM  11167  CA  ARG F 193      66.390  84.330 166.471  1.00 17.87           C  
ATOM  11168  C   ARG F 193      65.954  84.083 165.038  1.00 17.43           C  
ATOM  11169  O   ARG F 193      66.126  84.930 164.175  1.00 17.22           O  
ATOM  11170  CB  ARG F 193      65.241  84.974 167.251  1.00 18.21           C  
ATOM  11171  CG  ARG F 193      65.532  85.168 168.727  1.00 18.75           C  
ATOM  11172  CD  ARG F 193      64.358  85.705 169.529  1.00 19.88           C  
ATOM  11173  NE  ARG F 193      64.052  87.090 169.177  1.00 18.41           N  
ATOM  11174  CZ  ARG F 193      63.083  87.462 168.348  1.00 19.03           C  
ATOM  11175  NH1 ARG F 193      62.293  86.559 167.772  1.00 16.46           N  
ATOM  11176  NH2 ARG F 193      62.896  88.756 168.104  1.00 19.06           N  
ATOM  11177  N   VAL F 194      65.396  82.903 164.790  1.00 16.35           N  
ATOM  11178  CA  VAL F 194      64.933  82.552 163.452  1.00 16.50           C  
ATOM  11179  C   VAL F 194      63.594  81.847 163.594  1.00 16.21           C  
ATOM  11180  O   VAL F 194      63.480  80.902 164.361  1.00 16.71           O  
ATOM  11181  CB  VAL F 194      65.910  81.594 162.744  1.00 16.30           C  
ATOM  11182  CG1 VAL F 194      65.509  81.415 161.291  1.00 16.48           C  
ATOM  11183  CG2 VAL F 194      67.346  82.113 162.846  1.00 16.94           C  
ATOM  11184  N   ASN F 195      62.590  82.313 162.863  1.00 15.92           N  
ATOM  11185  CA  ASN F 195      61.244  81.740 162.934  1.00 15.49           C  
ATOM  11186  C   ASN F 195      60.608  81.680 161.561  1.00 15.71           C  
ATOM  11187  O   ASN F 195      60.979  82.436 160.667  1.00 15.77           O  
ATOM  11188  CB  ASN F 195      60.329  82.556 163.866  1.00 15.84           C  
ATOM  11189  CG  ASN F 195      60.758  82.489 165.310  1.00 15.70           C  
ATOM  11190  OD1 ASN F 195      60.546  81.487 165.979  1.00 15.83           O  
ATOM  11191  ND2 ASN F 195      61.387  83.558 165.795  1.00 16.55           N  
ATOM  11192  N   ALA F 196      59.646  80.778 161.409  1.00 15.04           N  
ATOM  11193  CA  ALA F 196      58.918  80.641 160.158  1.00 14.70           C  
ATOM  11194  C   ALA F 196      57.516  81.216 160.291  1.00 15.19           C  
ATOM  11195  O   ALA F 196      56.871  81.068 161.332  1.00 15.20           O  
ATOM  11196  CB  ALA F 196      58.827  79.159 159.750  1.00 15.00           C  
ATOM  11197  N   LEU F 197      57.067  81.909 159.249  1.00 14.93           N  
ATOM  11198  CA  LEU F 197      55.715  82.444 159.181  1.00 15.33           C  
ATOM  11199  C   LEU F 197      55.084  81.712 158.004  1.00 14.64           C  
ATOM  11200  O   LEU F 197      55.587  81.800 156.881  1.00 14.19           O  
ATOM  11201  CB  LEU F 197      55.749  83.955 158.945  1.00 15.99           C  
ATOM  11202  CG  LEU F 197      54.428  84.733 158.940  1.00 16.66           C  
ATOM  11203  CD1 LEU F 197      54.686  86.209 159.189  1.00 17.05           C  
ATOM  11204  CD2 LEU F 197      53.705  84.569 157.605  1.00 16.70           C  
ATOM  11205  N   SER F 198      54.002  80.985 158.260  1.00 14.64           N  
ATOM  11206  CA  SER F 198      53.410  80.125 157.226  1.00 14.84           C  
ATOM  11207  C   SER F 198      51.990  80.507 156.831  1.00 15.23           C  
ATOM  11208  O   SER F 198      51.041  80.147 157.516  1.00 14.78           O  
ATOM  11209  CB  SER F 198      53.445  78.683 157.718  1.00 15.35           C  
ATOM  11210  OG  SER F 198      54.803  78.308 157.845  1.00 15.56           O  
ATOM  11211  N   PRO F 199      51.844  81.229 155.726  1.00 15.19           N  
ATOM  11212  CA  PRO F 199      50.516  81.647 155.257  1.00 15.83           C  
ATOM  11213  C   PRO F 199      49.670  80.514 154.690  1.00 15.70           C  
ATOM  11214  O   PRO F 199      50.182  79.500 154.231  1.00 15.12           O  
ATOM  11215  CB  PRO F 199      50.840  82.633 154.131  1.00 16.13           C  
ATOM  11216  CG  PRO F 199      52.246  83.075 154.419  1.00 15.96           C  
ATOM  11217  CD  PRO F 199      52.928  81.824 154.921  1.00 15.47           C  
ATOM  11218  N   GLY F 200      48.358  80.712 154.759  1.00 15.71           N  
ATOM  11219  CA  GLY F 200      47.402  79.857 154.088  1.00 16.06           C  
ATOM  11220  C   GLY F 200      47.173  80.455 152.709  1.00 16.47           C  
ATOM  11221  O   GLY F 200      48.073  81.080 152.139  1.00 17.41           O  
ATOM  11222  N   TYR F 201      45.981  80.269 152.160  1.00 16.56           N  
ATOM  11223  CA  TYR F 201      45.664  80.827 150.847  1.00 17.07           C  
ATOM  11224  C   TYR F 201      45.572  82.338 150.916  1.00 17.71           C  
ATOM  11225  O   TYR F 201      44.796  82.873 151.699  1.00 17.61           O  
ATOM  11226  CB  TYR F 201      44.342  80.266 150.302  1.00 17.84           C  
ATOM  11227  CG  TYR F 201      44.423  78.795 149.965  1.00 17.41           C  
ATOM  11228  CD1 TYR F 201      43.738  77.853 150.718  1.00 17.39           C  
ATOM  11229  CD2 TYR F 201      45.167  78.363 148.880  1.00 17.37           C  
ATOM  11230  CE1 TYR F 201      43.828  76.482 150.415  1.00 16.78           C  
ATOM  11231  CE2 TYR F 201      45.262  77.018 148.566  1.00 17.02           C  
ATOM  11232  CZ  TYR F 201      44.590  76.089 149.325  1.00 17.72           C  
ATOM  11233  OH  TYR F 201      44.715  74.753 148.981  1.00 17.74           O  
ATOM  11234  N   VAL F 202      46.349  83.017 150.076  1.00 17.31           N  
ATOM  11235  CA  VAL F 202      46.357  84.488 150.039  1.00 18.14           C  
ATOM  11236  C   VAL F 202      45.943  85.042 148.675  1.00 18.95           C  
ATOM  11237  O   VAL F 202      46.275  84.471 147.643  1.00 19.03           O  
ATOM  11238  CB  VAL F 202      47.753  85.040 150.386  1.00 18.28           C  
ATOM  11239  CG1 VAL F 202      47.716  86.572 150.414  1.00 18.79           C  
ATOM  11240  CG2 VAL F 202      48.211  84.512 151.734  1.00 18.21           C  
ATOM  11241  N   ASN F 203      45.191  86.142 148.675  1.00 19.25           N  
ATOM  11242  CA  ASN F 203      44.816  86.824 147.438  1.00 20.62           C  
ATOM  11243  C   ASN F 203      45.956  87.709 146.968  1.00 20.76           C  
ATOM  11244  O   ASN F 203      46.346  88.636 147.671  1.00 21.98           O  
ATOM  11245  CB  ASN F 203      43.598  87.719 147.656  1.00 21.16           C  
ATOM  11246  CG  ASN F 203      42.296  86.958 147.640  1.00 22.85           C  
ATOM  11247  OD1 ASN F 203      42.080  86.076 146.801  1.00 24.76           O  
ATOM  11248  ND2 ASN F 203      41.398  87.314 148.556  1.00 25.41           N  
ATOM  11249  N   THR F 204      46.487  87.424 145.782  1.00 21.21           N  
ATOM  11250  CA  THR F 204      47.533  88.243 145.177  1.00 21.96           C  
ATOM  11251  C   THR F 204      47.086  88.546 143.758  1.00 22.88           C  
ATOM  11252  O   THR F 204      46.035  88.073 143.323  1.00 23.71           O  
ATOM  11253  CB  THR F 204      48.880  87.509 145.146  1.00 21.24           C  
ATOM  11254  OG1 THR F 204      48.734  86.281 144.425  1.00 22.33           O  
ATOM  11255  CG2 THR F 204      49.302  87.072 146.559  1.00 20.67           C  
ATOM  11256  N   ASP F 205      47.880  89.326 143.029  1.00 23.66           N  
ATOM  11257  CA  ASP F 205      47.515  89.670 141.660  1.00 24.75           C  
ATOM  11258  C   ASP F 205      47.314  88.419 140.820  1.00 24.48           C  
ATOM  11259  O   ASP F 205      46.442  88.390 139.953  1.00 25.53           O  
ATOM  11260  CB  ASP F 205      48.568  90.574 141.014  1.00 25.47           C  
ATOM  11261  CG  ASP F 205      48.765  91.874 141.770  1.00 28.14           C  
ATOM  11262  OD1 ASP F 205      47.770  92.553 142.099  1.00 31.73           O  
ATOM  11263  OD2 ASP F 205      49.897  92.300 142.086  1.00 34.99           O  
ATOM  11264  N   GLN F 206      48.106  87.385 141.088  1.00 24.25           N  
ATOM  11265  CA  GLN F 206      48.010  86.138 140.339  1.00 24.19           C  
ATOM  11266  C   GLN F 206      46.669  85.431 140.556  1.00 24.53           C  
ATOM  11267  O   GLN F 206      46.165  84.731 139.664  1.00 25.48           O  
ATOM  11268  CB  GLN F 206      49.165  85.214 140.701  1.00 23.38           C  
ATOM  11269  CG  GLN F 206      50.542  85.742 140.302  1.00 24.02           C  
ATOM  11270  CD  GLN F 206      51.195  86.628 141.364  1.00 24.42           C  
ATOM  11271  OE1 GLN F 206      50.539  87.455 141.992  1.00 27.37           O  
ATOM  11272  NE2 GLN F 206      52.501  86.451 141.552  1.00 28.18           N  
ATOM  11273  N   THR F 207      46.086  85.631 141.736  1.00 24.18           N  
ATOM  11274  CA  THR F 207      44.816  85.000 142.084  1.00 23.58           C  
ATOM  11275  C   THR F 207      43.717  85.401 141.119  1.00 24.47           C  
ATOM  11276  O   THR F 207      42.840  84.598 140.799  1.00 25.65           O  
ATOM  11277  CB  THR F 207      44.388  85.403 143.508  1.00 23.03           C  
ATOM  11278  OG1 THR F 207      45.426  85.088 144.434  1.00 23.69           O  
ATOM  11279  CG2 THR F 207      43.189  84.574 143.971  1.00 23.70           C  
ATOM  11280  N   ALA F 208      43.752  86.650 140.666  1.00 25.29           N  
ATOM  11281  CA  ALA F 208      42.728  87.163 139.761  1.00 25.90           C  
ATOM  11282  C   ALA F 208      42.863  86.603 138.355  1.00 26.33           C  
ATOM  11283  O   ALA F 208      42.038  86.896 137.489  1.00 28.61           O  
ATOM  11284  CB  ALA F 208      42.752  88.687 139.727  1.00 26.83           C  
ATOM  11285  N   HIS F 209      43.893  85.797 138.122  1.00 26.00           N  
ATOM  11286  CA  HIS F 209      44.101  85.237 136.788  1.00 26.01           C  
ATOM  11287  C   HIS F 209      44.067  83.718 136.782  1.00 25.28           C  
ATOM  11288  O   HIS F 209      44.189  83.088 135.730  1.00 26.33           O  
ATOM  11289  CB  HIS F 209      45.430  85.730 136.208  1.00 26.34           C  
ATOM  11290  CG  HIS F 209      45.471  87.207 135.975  1.00 27.36           C  
ATOM  11291  ND1 HIS F 209      44.628  87.847 135.091  1.00 30.43           N  
ATOM  11292  CD2 HIS F 209      46.252  88.173 136.515  1.00 27.27           C  
ATOM  11293  CE1 HIS F 209      44.891  89.143 135.098  1.00 30.61           C  
ATOM  11294  NE2 HIS F 209      45.873  89.365 135.953  1.00 30.78           N  
ATOM  11295  N   MET F 210      43.883  83.131 137.955  1.00 24.28           N  
ATOM  11296  CA  MET F 210      43.864  81.679 138.073  1.00 23.49           C  
ATOM  11297  C   MET F 210      42.486  81.128 137.746  1.00 23.61           C  
ATOM  11298  O   MET F 210      41.506  81.870 137.673  1.00 23.77           O  
ATOM  11299  CB  MET F 210      44.268  81.256 139.485  1.00 22.63           C  
ATOM  11300  CG  MET F 210      43.185  81.487 140.548  1.00 23.36           C  
ATOM  11301  SD  MET F 210      43.664  81.001 142.223  1.00 24.17           S  
ATOM  11302  CE  MET F 210      43.667  79.254 142.105  1.00 21.74           C  
ATOM  11303  N   ASP F 211      42.421  79.812 137.563  1.00 23.53           N  
ATOM  11304  CA  ASP F 211      41.166  79.148 137.277  1.00 24.20           C  
ATOM  11305  C   ASP F 211      40.208  79.413 138.427  1.00 23.71           C  
ATOM  11306  O   ASP F 211      40.477  79.037 139.575  1.00 22.91           O  
ATOM  11307  CB  ASP F 211      41.401  77.648 137.112  1.00 24.08           C  
ATOM  11308  CG  ASP F 211      40.129  76.883 136.810  1.00 25.61           C  
ATOM  11309  OD1 ASP F 211      40.232  75.667 136.521  1.00 30.39           O  
ATOM  11310  OD2 ASP F 211      38.989  77.390 136.822  1.00 29.12           O  
ATOM  11311  N   LYS F 212      39.105  80.083 138.121  1.00 24.55           N  
ATOM  11312  CA  LYS F 212      38.097  80.402 139.126  1.00 24.35           C  
ATOM  11313  C   LYS F 212      37.565  79.155 139.824  1.00 23.82           C  
ATOM  11314  O   LYS F 212      37.325  79.167 141.034  1.00 22.87           O  
ATOM  11315  CB  LYS F 212      36.959  81.204 138.497  1.00 25.73           C  
ATOM  11316  CG  LYS F 212      37.457  82.505 137.908  1.00 28.32           C  
ATOM  11317  CD  LYS F 212      36.374  83.335 137.263  1.00 31.65           C  
ATOM  11318  CE  LYS F 212      36.987  84.535 136.528  1.00 33.85           C  
ATOM  11319  NZ  LYS F 212      37.980  85.278 137.379  1.00 35.91           N  
ATOM  11320  N   LYS F 213      37.423  78.065 139.080  1.00 23.35           N  
ATOM  11321  CA  LYS F 213      36.934  76.831 139.687  1.00 23.70           C  
ATOM  11322  C   LYS F 213      37.851  76.370 140.809  1.00 22.44           C  
ATOM  11323  O   LYS F 213      37.382  75.928 141.864  1.00 22.67           O  
ATOM  11324  CB  LYS F 213      36.794  75.723 138.649  1.00 23.99           C  
ATOM  11325  CG  LYS F 213      35.690  75.956 137.640  1.00 25.65           C  
ATOM  11326  CD  LYS F 213      35.397  74.678 136.842  1.00 28.03           C  
ATOM  11327  CE  LYS F 213      34.486  74.953 135.660  1.00 30.80           C  
ATOM  11328  NZ  LYS F 213      34.228  73.754 134.792  1.00 35.02           N  
ATOM  11329  N   ILE F 214      39.158  76.464 140.584  1.00 21.49           N  
ATOM  11330  CA  ILE F 214      40.134  76.059 141.592  1.00 20.55           C  
ATOM  11331  C   ILE F 214      40.085  76.994 142.787  1.00 20.56           C  
ATOM  11332  O   ILE F 214      40.036  76.556 143.930  1.00 19.90           O  
ATOM  11333  CB  ILE F 214      41.555  76.037 141.004  1.00 20.11           C  
ATOM  11334  CG1 ILE F 214      41.669  74.933 139.955  1.00 21.62           C  
ATOM  11335  CG2 ILE F 214      42.581  75.820 142.117  1.00 19.80           C  
ATOM  11336  CD1 ILE F 214      43.041  74.824 139.319  1.00 21.77           C  
ATOM  11337  N   ARG F 215      40.110  78.289 142.512  1.00 20.62           N  
ATOM  11338  CA  ARG F 215      40.051  79.303 143.558  1.00 20.78           C  
ATOM  11339  C   ARG F 215      38.816  79.117 144.439  1.00 20.51           C  
ATOM  11340  O   ARG F 215      38.903  79.164 145.672  1.00 20.31           O  
ATOM  11341  CB  ARG F 215      40.006  80.684 142.899  1.00 21.84           C  
ATOM  11342  CG  ARG F 215      40.023  81.862 143.853  1.00 23.65           C  
ATOM  11343  CD  ARG F 215      40.103  83.199 143.134  1.00 26.02           C  
ATOM  11344  NE  ARG F 215      38.931  83.477 142.316  1.00 30.81           N  
ATOM  11345  CZ  ARG F 215      38.962  84.015 141.098  1.00 30.15           C  
ATOM  11346  NH1 ARG F 215      40.119  84.328 140.525  1.00 33.76           N  
ATOM  11347  NH2 ARG F 215      37.828  84.244 140.446  1.00 33.33           N  
ATOM  11348  N   ASP F 216      37.665  78.918 143.806  1.00 20.52           N  
ATOM  11349  CA  ASP F 216      36.424  78.724 144.537  1.00 21.23           C  
ATOM  11350  C   ASP F 216      36.452  77.426 145.337  1.00 21.03           C  
ATOM  11351  O   ASP F 216      35.923  77.369 146.447  1.00 21.27           O  
ATOM  11352  CB  ASP F 216      35.236  78.729 143.579  1.00 21.79           C  
ATOM  11353  CG  ASP F 216      34.919  80.116 143.056  1.00 23.67           C  
ATOM  11354  OD1 ASP F 216      35.301  81.110 143.712  1.00 24.13           O  
ATOM  11355  OD2 ASP F 216      34.281  80.309 142.000  1.00 23.56           O  
ATOM  11356  N   HIS F 217      37.057  76.376 144.785  1.00 20.64           N  
ATOM  11357  CA  HIS F 217      37.134  75.136 145.540  1.00 20.61           C  
ATOM  11358  C   HIS F 217      37.979  75.340 146.785  1.00 19.99           C  
ATOM  11359  O   HIS F 217      37.591  74.942 147.887  1.00 20.40           O  
ATOM  11360  CB  HIS F 217      37.744  73.987 144.737  1.00 20.52           C  
ATOM  11361  CG  HIS F 217      38.096  72.811 145.594  1.00 20.69           C  
ATOM  11362  ND1 HIS F 217      37.133  72.013 146.175  1.00 23.23           N  
ATOM  11363  CD2 HIS F 217      39.290  72.338 146.025  1.00 20.94           C  
ATOM  11364  CE1 HIS F 217      37.719  71.080 146.902  1.00 21.19           C  
ATOM  11365  NE2 HIS F 217      39.026  71.257 146.836  1.00 22.22           N  
ATOM  11366  N   GLN F 218      39.136  75.963 146.604  1.00 19.75           N  
ATOM  11367  CA  GLN F 218      40.056  76.195 147.710  1.00 19.35           C  
ATOM  11368  C   GLN F 218      39.430  77.018 148.839  1.00 20.18           C  
ATOM  11369  O   GLN F 218      39.653  76.728 150.012  1.00 21.32           O  
ATOM  11370  CB  GLN F 218      41.346  76.837 147.210  1.00 19.13           C  
ATOM  11371  CG  GLN F 218      42.145  75.919 146.282  1.00 18.47           C  
ATOM  11372  CD  GLN F 218      43.343  76.615 145.680  1.00 19.21           C  
ATOM  11373  OE1 GLN F 218      43.344  77.833 145.533  1.00 20.28           O  
ATOM  11374  NE2 GLN F 218      44.380  75.847 145.349  1.00 19.64           N  
ATOM  11375  N   ALA F 219      38.654  78.039 148.491  1.00 19.81           N  
ATOM  11376  CA  ALA F 219      38.007  78.876 149.506  1.00 20.25           C  
ATOM  11377  C   ALA F 219      36.869  78.135 150.197  1.00 20.80           C  
ATOM  11378  O   ALA F 219      36.503  78.455 151.333  1.00 21.13           O  
ATOM  11379  CB  ALA F 219      37.490  80.170 148.876  1.00 20.82           C  
ATOM  11380  N   SER F 220      36.311  77.143 149.511  1.00 20.96           N  
ATOM  11381  CA  SER F 220      35.151  76.403 150.008  1.00 21.32           C  
ATOM  11382  C   SER F 220      35.395  75.567 151.272  1.00 20.55           C  
ATOM  11383  O   SER F 220      34.433  75.220 151.964  1.00 20.20           O  
ATOM  11384  CB  SER F 220      34.586  75.487 148.916  1.00 21.71           C  
ATOM  11385  OG  SER F 220      35.384  74.318 148.782  1.00 23.00           O  
ATOM  11386  N   ASN F 221      36.650  75.246 151.566  1.00 19.43           N  
ATOM  11387  CA  ASN F 221      36.976  74.415 152.731  1.00 19.29           C  
ATOM  11388  C   ASN F 221      37.865  75.120 153.753  1.00 18.52           C  
ATOM  11389  O   ASN F 221      38.559  74.465 154.532  1.00 18.25           O  
ATOM  11390  CB  ASN F 221      37.614  73.086 152.299  1.00 19.48           C  
ATOM  11391  CG  ASN F 221      37.276  71.914 153.241  1.00 20.16           C  
ATOM  11392  OD1 ASN F 221      37.953  70.859 153.217  1.00 26.00           O  
ATOM  11393  ND2 ASN F 221      36.255  72.076 154.059  1.00 22.14           N  
ATOM  11394  N   ILE F 222      37.867  76.449 153.721  1.00 18.43           N  
ATOM  11395  CA  ILE F 222      38.569  77.259 154.711  1.00 18.42           C  
ATOM  11396  C   ILE F 222      37.530  77.722 155.720  1.00 18.69           C  
ATOM  11397  O   ILE F 222      36.538  78.339 155.334  1.00 19.06           O  
ATOM  11398  CB  ILE F 222      39.196  78.515 154.060  1.00 18.41           C  
ATOM  11399  CG1 ILE F 222      40.124  78.126 152.901  1.00 18.03           C  
ATOM  11400  CG2 ILE F 222      39.968  79.313 155.112  1.00 18.65           C  
ATOM  11401  CD1 ILE F 222      40.629  79.313 152.095  1.00 18.76           C  
ATOM  11402  N   PRO F 223      37.715  77.435 157.007  1.00 18.24           N  
ATOM  11403  CA  PRO F 223      36.719  77.858 158.002  1.00 18.85           C  
ATOM  11404  C   PRO F 223      36.307  79.325 157.927  1.00 19.34           C  
ATOM  11405  O   PRO F 223      35.122  79.618 158.080  1.00 19.86           O  
ATOM  11406  CB  PRO F 223      37.392  77.515 159.326  1.00 18.74           C  
ATOM  11407  CG  PRO F 223      38.157  76.279 158.977  1.00 18.11           C  
ATOM  11408  CD  PRO F 223      38.777  76.618 157.618  1.00 18.18           C  
ATOM  11409  N   LEU F 224      37.259  80.213 157.674  1.00 19.13           N  
ATOM  11410  CA  LEU F 224      36.955  81.628 157.546  1.00 20.47           C  
ATOM  11411  C   LEU F 224      36.254  81.986 156.229  1.00 21.15           C  
ATOM  11412  O   LEU F 224      35.866  83.139 156.024  1.00 21.64           O  
ATOM  11413  CB  LEU F 224      38.228  82.440 157.719  1.00 20.22           C  
ATOM  11414  CG  LEU F 224      38.389  83.180 159.038  1.00 23.98           C  
ATOM  11415  CD1 LEU F 224      37.551  82.596 160.182  1.00 22.64           C  
ATOM  11416  CD2 LEU F 224      39.838  83.356 159.425  1.00 21.24           C  
ATOM  11417  N   ASN F 225      36.135  81.013 155.330  1.00 21.30           N  
ATOM  11418  CA  ASN F 225      35.395  81.183 154.075  1.00 22.33           C  
ATOM  11419  C   ASN F 225      35.976  82.162 153.064  1.00 21.74           C  
ATOM  11420  O   ASN F 225      35.235  82.726 152.259  1.00 23.30           O  
ATOM  11421  CB  ASN F 225      33.949  81.588 154.357  1.00 23.88           C  
ATOM  11422  CG  ASN F 225      33.135  80.469 154.948  1.00 25.57           C  
ATOM  11423  OD1 ASN F 225      32.991  79.408 154.340  1.00 28.42           O  
ATOM  11424  ND2 ASN F 225      32.595  80.693 156.146  1.00 28.61           N  
ATOM  11425  N   ARG F 226      37.283  82.368 153.100  1.00 20.83           N  
ATOM  11426  CA  ARG F 226      37.913  83.285 152.167  1.00 20.68           C  
ATOM  11427  C   ARG F 226      39.417  83.146 152.194  1.00 19.84           C  
ATOM  11428  O   ARG F 226      39.977  82.573 153.125  1.00 19.58           O  
ATOM  11429  CB  ARG F 226      37.544  84.726 152.528  1.00 21.32           C  
ATOM  11430  CG  ARG F 226      38.104  85.196 153.869  1.00 21.07           C  
ATOM  11431  CD  ARG F 226      37.725  86.638 154.212  1.00 21.62           C  
ATOM  11432  NE  ARG F 226      38.185  87.035 155.542  1.00 22.18           N  
ATOM  11433  CZ  ARG F 226      39.447  87.338 155.840  1.00 20.83           C  
ATOM  11434  NH1 ARG F 226      40.394  87.293 154.913  1.00 20.34           N  
ATOM  11435  NH2 ARG F 226      39.774  87.686 157.074  1.00 20.81           N  
ATOM  11436  N   PHE F 227      40.062  83.668 151.152  1.00 19.76           N  
ATOM  11437  CA  PHE F 227      41.509  83.760 151.094  1.00 19.21           C  
ATOM  11438  C   PHE F 227      41.859  84.963 151.957  1.00 19.21           C  
ATOM  11439  O   PHE F 227      41.014  85.830 152.207  1.00 19.85           O  
ATOM  11440  CB  PHE F 227      41.982  84.037 149.656  1.00 19.66           C  
ATOM  11441  CG  PHE F 227      42.029  82.815 148.771  1.00 19.42           C  
ATOM  11442  CD1 PHE F 227      41.324  81.665 149.106  1.00 19.62           C  
ATOM  11443  CD2 PHE F 227      42.770  82.828 147.595  1.00 19.01           C  
ATOM  11444  CE1 PHE F 227      41.379  80.531 148.300  1.00 19.36           C  
ATOM  11445  CE2 PHE F 227      42.823  81.702 146.778  1.00 19.42           C  
ATOM  11446  CZ  PHE F 227      42.117  80.557 147.129  1.00 18.55           C  
ATOM  11447  N   ALA F 228      43.108  85.030 152.397  1.00 18.64           N  
ATOM  11448  CA  ALA F 228      43.539  86.173 153.202  1.00 18.93           C  
ATOM  11449  C   ALA F 228      44.015  87.288 152.306  1.00 19.56           C  
ATOM  11450  O   ALA F 228      44.313  87.062 151.140  1.00 19.43           O  
ATOM  11451  CB  ALA F 228      44.672  85.756 154.106  1.00 18.94           C  
ATOM  11452  N   GLN F 229      44.071  88.497 152.857  1.00 19.41           N  
ATOM  11453  CA  GLN F 229      44.699  89.609 152.163  1.00 19.97           C  
ATOM  11454  C   GLN F 229      46.146  89.585 152.641  1.00 19.69           C  
ATOM  11455  O   GLN F 229      46.408  89.201 153.773  1.00 18.12           O  
ATOM  11456  CB  GLN F 229      44.039  90.930 152.550  1.00 20.68           C  
ATOM  11457  CG  GLN F 229      42.600  91.059 152.085  1.00 21.97           C  
ATOM  11458  CD  GLN F 229      42.459  90.813 150.597  1.00 22.86           C  
ATOM  11459  OE1 GLN F 229      41.736  89.905 150.178  1.00 25.76           O  
ATOM  11460  NE2 GLN F 229      43.157  91.611 149.791  1.00 25.30           N  
ATOM  11461  N   PRO F 230      47.099  89.981 151.800  1.00 19.71           N  
ATOM  11462  CA  PRO F 230      48.509  89.939 152.204  1.00 19.45           C  
ATOM  11463  C   PRO F 230      48.767  90.678 153.516  1.00 19.31           C  
ATOM  11464  O   PRO F 230      49.599  90.231 154.307  1.00 18.45           O  
ATOM  11465  CB  PRO F 230      49.229  90.595 151.014  1.00 19.70           C  
ATOM  11466  CG  PRO F 230      48.164  91.331 150.308  1.00 22.93           C  
ATOM  11467  CD  PRO F 230      46.939  90.454 150.415  1.00 20.79           C  
ATOM  11468  N   GLU F 231      48.039  91.767 153.749  1.00 19.64           N  
ATOM  11469  CA  GLU F 231      48.190  92.545 154.977  1.00 20.26           C  
ATOM  11470  C   GLU F 231      47.965  91.710 156.241  1.00 19.79           C  
ATOM  11471  O   GLU F 231      48.500  92.026 157.303  1.00 20.14           O  
ATOM  11472  CB  GLU F 231      47.221  93.737 154.993  1.00 21.10           C  
ATOM  11473  CG  GLU F 231      47.487  94.825 153.964  1.00 23.82           C  
ATOM  11474  CD  GLU F 231      47.325  94.363 152.531  1.00 26.28           C  
ATOM  11475  OE1 GLU F 231      46.402  93.562 152.241  1.00 24.94           O  
ATOM  11476  OE2 GLU F 231      48.142  94.808 151.689  1.00 30.96           O  
ATOM  11477  N   GLU F 232      47.180  90.643 156.127  1.00 18.86           N  
ATOM  11478  CA  GLU F 232      46.881  89.798 157.280  1.00 18.75           C  
ATOM  11479  C   GLU F 232      48.053  88.927 157.719  1.00 18.28           C  
ATOM  11480  O   GLU F 232      47.968  88.242 158.731  1.00 17.89           O  
ATOM  11481  CB  GLU F 232      45.634  88.958 157.011  1.00 18.33           C  
ATOM  11482  CG  GLU F 232      44.366  89.800 156.895  1.00 19.90           C  
ATOM  11483  CD  GLU F 232      43.141  88.952 156.627  1.00 21.22           C  
ATOM  11484  OE1 GLU F 232      42.935  88.568 155.459  1.00 20.85           O  
ATOM  11485  OE2 GLU F 232      42.379  88.687 157.580  1.00 20.63           O  
ATOM  11486  N   MET F 233      49.148  88.968 156.964  1.00 17.35           N  
ATOM  11487  CA  MET F 233      50.338  88.200 157.304  1.00 17.52           C  
ATOM  11488  C   MET F 233      51.332  89.059 158.084  1.00 17.67           C  
ATOM  11489  O   MET F 233      52.278  88.543 158.682  1.00 17.93           O  
ATOM  11490  CB  MET F 233      51.049  87.717 156.030  1.00 17.28           C  
ATOM  11491  CG  MET F 233      50.177  86.872 155.117  1.00 17.68           C  
ATOM  11492  SD  MET F 233      49.623  85.384 155.960  1.00 18.03           S  
ATOM  11493  CE  MET F 233      47.850  85.490 155.664  1.00 19.76           C  
ATOM  11494  N   THR F 234      51.113  90.369 158.091  1.00 18.10           N  
ATOM  11495  CA  THR F 234      52.133  91.275 158.619  1.00 18.69           C  
ATOM  11496  C   THR F 234      52.241  91.407 160.136  1.00 18.79           C  
ATOM  11497  O   THR F 234      53.340  91.592 160.656  1.00 19.40           O  
ATOM  11498  CB  THR F 234      52.012  92.667 157.980  1.00 18.91           C  
ATOM  11499  OG1 THR F 234      50.736  93.229 158.291  1.00 19.94           O  
ATOM  11500  CG2 THR F 234      52.045  92.554 156.435  1.00 19.53           C  
ATOM  11501  N   GLY F 235      51.118  91.334 160.844  1.00 18.56           N  
ATOM  11502  CA  GLY F 235      51.150  91.467 162.294  1.00 18.91           C  
ATOM  11503  C   GLY F 235      52.109  90.468 162.931  1.00 18.31           C  
ATOM  11504  O   GLY F 235      52.933  90.832 163.772  1.00 18.26           O  
ATOM  11505  N   GLN F 236      51.994  89.204 162.547  1.00 17.99           N  
ATOM  11506  CA  GLN F 236      52.861  88.181 163.103  1.00 18.22           C  
ATOM  11507  C   GLN F 236      54.335  88.430 162.793  1.00 18.09           C  
ATOM  11508  O   GLN F 236      55.200  88.174 163.629  1.00 18.00           O  
ATOM  11509  CB  GLN F 236      52.429  86.802 162.604  1.00 17.48           C  
ATOM  11510  CG  GLN F 236      53.239  85.643 163.173  1.00 18.41           C  
ATOM  11511  CD  GLN F 236      52.945  85.408 164.625  1.00 19.25           C  
ATOM  11512  OE1 GLN F 236      51.969  84.738 164.952  1.00 24.38           O  
ATOM  11513  NE2 GLN F 236      53.770  85.955 165.499  1.00 22.72           N  
ATOM  11514  N   ALA F 237      54.614  88.923 161.588  1.00 17.81           N  
ATOM  11515  CA  ALA F 237      55.987  89.230 161.197  1.00 17.98           C  
ATOM  11516  C   ALA F 237      56.557  90.348 162.053  1.00 18.35           C  
ATOM  11517  O   ALA F 237      57.685  90.260 162.537  1.00 18.32           O  
ATOM  11518  CB  ALA F 237      56.058  89.614 159.726  1.00 18.10           C  
ATOM  11519  N   ILE F 238      55.772  91.405 162.246  1.00 18.35           N  
ATOM  11520  CA  ILE F 238      56.228  92.518 163.059  1.00 19.38           C  
ATOM  11521  C   ILE F 238      56.508  92.045 164.491  1.00 19.13           C  
ATOM  11522  O   ILE F 238      57.526  92.384 165.075  1.00 19.16           O  
ATOM  11523  CB  ILE F 238      55.208  93.684 162.995  1.00 19.73           C  
ATOM  11524  CG1 ILE F 238      55.283  94.341 161.608  1.00 21.05           C  
ATOM  11525  CG2 ILE F 238      55.466  94.716 164.102  1.00 20.85           C  
ATOM  11526  CD1 ILE F 238      54.253  95.415 161.364  1.00 23.96           C  
ATOM  11527  N   LEU F 239      55.625  91.216 165.037  1.00 19.00           N  
ATOM  11528  CA  LEU F 239      55.841  90.705 166.376  1.00 19.41           C  
ATOM  11529  C   LEU F 239      57.153  89.919 166.474  1.00 18.92           C  
ATOM  11530  O   LEU F 239      57.966  90.152 167.370  1.00 18.75           O  
ATOM  11531  CB  LEU F 239      54.679  89.800 166.775  1.00 19.47           C  
ATOM  11532  CG  LEU F 239      54.775  89.192 168.169  1.00 20.87           C  
ATOM  11533  CD1 LEU F 239      54.694  90.313 169.201  1.00 22.51           C  
ATOM  11534  CD2 LEU F 239      53.681  88.134 168.390  1.00 21.15           C  
ATOM  11535  N   LEU F 240      57.352  88.983 165.549  1.00 18.17           N  
ATOM  11536  CA  LEU F 240      58.546  88.133 165.558  1.00 17.90           C  
ATOM  11537  C   LEU F 240      59.849  88.930 165.410  1.00 18.23           C  
ATOM  11538  O   LEU F 240      60.885  88.559 165.963  1.00 17.85           O  
ATOM  11539  CB  LEU F 240      58.455  87.069 164.460  1.00 17.32           C  
ATOM  11540  CG  LEU F 240      57.391  85.990 164.658  1.00 17.29           C  
ATOM  11541  CD1 LEU F 240      57.225  85.147 163.400  1.00 17.10           C  
ATOM  11542  CD2 LEU F 240      57.729  85.100 165.849  1.00 17.38           C  
ATOM  11543  N   LEU F 241      59.792  90.021 164.656  1.00 18.41           N  
ATOM  11544  CA  LEU F 241      60.967  90.867 164.470  1.00 19.23           C  
ATOM  11545  C   LEU F 241      61.235  91.768 165.671  1.00 19.93           C  
ATOM  11546  O   LEU F 241      62.348  92.277 165.822  1.00 20.40           O  
ATOM  11547  CB  LEU F 241      60.779  91.743 163.230  1.00 19.07           C  
ATOM  11548  CG  LEU F 241      60.834  91.069 161.865  1.00 19.69           C  
ATOM  11549  CD1 LEU F 241      60.348  92.028 160.793  1.00 19.88           C  
ATOM  11550  CD2 LEU F 241      62.233  90.572 161.546  1.00 18.97           C  
ATOM  11551  N   SER F 242      60.218  91.956 166.513  1.00 19.64           N  
ATOM  11552  CA  SER F 242      60.311  92.857 167.669  1.00 20.83           C  
ATOM  11553  C   SER F 242      60.916  92.250 168.927  1.00 21.31           C  
ATOM  11554  O   SER F 242      61.034  91.032 169.061  1.00 20.36           O  
ATOM  11555  CB  SER F 242      58.925  93.404 168.013  1.00 21.34           C  
ATOM  11556  OG  SER F 242      58.189  92.488 168.817  1.00 19.86           O  
ATOM  11557  N   ASP F 243      61.284  93.117 169.864  1.00 22.28           N  
ATOM  11558  CA  ASP F 243      61.867  92.670 171.124  1.00 22.86           C  
ATOM  11559  C   ASP F 243      60.848  91.996 172.035  1.00 23.20           C  
ATOM  11560  O   ASP F 243      61.205  91.483 173.090  1.00 24.17           O  
ATOM  11561  CB  ASP F 243      62.547  93.818 171.854  1.00 24.27           C  
ATOM  11562  CG  ASP F 243      63.714  94.392 171.087  1.00 25.11           C  
ATOM  11563  OD1 ASP F 243      64.397  93.636 170.354  1.00 29.23           O  
ATOM  11564  OD2 ASP F 243      64.021  95.609 171.190  1.00 29.27           O  
ATOM  11565  N   HIS F 244      59.583  91.990 171.626  1.00 22.41           N  
ATOM  11566  CA  HIS F 244      58.551  91.311 172.389  1.00 22.34           C  
ATOM  11567  C   HIS F 244      58.655  89.824 172.167  1.00 21.38           C  
ATOM  11568  O   HIS F 244      58.117  89.040 172.942  1.00 22.05           O  
ATOM  11569  CB  HIS F 244      57.160  91.794 171.979  1.00 22.14           C  
ATOM  11570  CG  HIS F 244      56.908  93.222 172.322  1.00 23.57           C  
ATOM  11571  ND1 HIS F 244      56.637  93.637 173.607  1.00 24.86           N  
ATOM  11572  CD2 HIS F 244      56.905  94.337 171.556  1.00 24.27           C  
ATOM  11573  CE1 HIS F 244      56.477  94.948 173.618  1.00 24.96           C  
ATOM  11574  NE2 HIS F 244      56.627  95.396 172.384  1.00 26.26           N  
ATOM  11575  N   ALA F 245      59.349  89.439 171.099  1.00 20.24           N  
ATOM  11576  CA  ALA F 245      59.472  88.028 170.749  1.00 19.45           C  
ATOM  11577  C   ALA F 245      60.794  87.400 171.189  1.00 19.20           C  
ATOM  11578  O   ALA F 245      61.232  86.420 170.594  1.00 18.59           O  
ATOM  11579  CB  ALA F 245      59.258  87.844 169.254  1.00 19.28           C  
ATOM  11580  N   THR F 246      61.404  87.936 172.252  1.00 19.83           N  
ATOM  11581  CA  THR F 246      62.693  87.425 172.741  1.00 20.42           C  
ATOM  11582  C   THR F 246      62.735  85.951 173.118  1.00 20.18           C  
ATOM  11583  O   THR F 246      63.815  85.377 173.154  1.00 21.06           O  
ATOM  11584  CB  THR F 246      63.208  88.234 173.947  1.00 20.98           C  
ATOM  11585  OG1 THR F 246      62.126  88.505 174.849  1.00 22.12           O  
ATOM  11586  CG2 THR F 246      63.741  89.599 173.498  1.00 22.23           C  
ATOM  11587  N   TYR F 247      61.589  85.347 173.428  1.00 19.45           N  
ATOM  11588  CA  TYR F 247      61.578  83.933 173.799  1.00 19.16           C  
ATOM  11589  C   TYR F 247      61.021  83.084 172.669  1.00 18.83           C  
ATOM  11590  O   TYR F 247      60.668  81.932 172.873  1.00 18.37           O  
ATOM  11591  CB  TYR F 247      60.764  83.695 175.080  1.00 19.40           C  
ATOM  11592  CG  TYR F 247      61.252  82.514 175.894  1.00 20.02           C  
ATOM  11593  CD1 TYR F 247      62.507  82.528 176.488  1.00 20.10           C  
ATOM  11594  CD2 TYR F 247      60.471  81.380 176.055  1.00 19.14           C  
ATOM  11595  CE1 TYR F 247      62.972  81.452 177.218  1.00 19.48           C  
ATOM  11596  CE2 TYR F 247      60.924  80.295 176.794  1.00 18.64           C  
ATOM  11597  CZ  TYR F 247      62.175  80.335 177.373  1.00 19.81           C  
ATOM  11598  OH  TYR F 247      62.630  79.258 178.106  1.00 18.83           O  
ATOM  11599  N   MET F 248      60.937  83.666 171.478  1.00 17.89           N  
ATOM  11600  CA  MET F 248      60.416  82.939 170.334  1.00 17.77           C  
ATOM  11601  C   MET F 248      61.485  82.654 169.297  1.00 17.38           C  
ATOM  11602  O   MET F 248      62.012  83.572 168.658  1.00 17.44           O  
ATOM  11603  CB  MET F 248      59.263  83.723 169.708  1.00 18.32           C  
ATOM  11604  CG  MET F 248      58.155  84.012 170.709  1.00 17.79           C  
ATOM  11605  SD  MET F 248      56.917  85.206 170.159  1.00 18.85           S  
ATOM  11606  CE  MET F 248      55.905  84.199 169.089  1.00 19.06           C  
ATOM  11607  N   THR F 249      61.841  81.384 169.160  1.00 16.60           N  
ATOM  11608  CA  THR F 249      62.827  81.025 168.152  1.00 16.82           C  
ATOM  11609  C   THR F 249      62.659  79.571 167.762  1.00 16.64           C  
ATOM  11610  O   THR F 249      62.310  78.735 168.596  1.00 17.16           O  
ATOM  11611  CB  THR F 249      64.255  81.326 168.654  1.00 17.42           C  
ATOM  11612  OG1 THR F 249      65.153  81.300 167.532  1.00 16.77           O  
ATOM  11613  CG2 THR F 249      64.764  80.240 169.638  1.00 18.28           C  
ATOM  11614  N   GLY F 250      62.898  79.295 166.489  1.00 15.66           N  
ATOM  11615  CA  GLY F 250      62.751  77.952 165.949  1.00 15.91           C  
ATOM  11616  C   GLY F 250      61.318  77.564 165.646  1.00 16.05           C  
ATOM  11617  O   GLY F 250      61.060  76.466 165.145  1.00 15.71           O  
ATOM  11618  N   GLY F 251      60.387  78.477 165.903  1.00 15.65           N  
ATOM  11619  CA  GLY F 251      58.982  78.152 165.723  1.00 15.66           C  
ATOM  11620  C   GLY F 251      58.415  78.400 164.346  1.00 15.38           C  
ATOM  11621  O   GLY F 251      59.026  79.061 163.525  1.00 15.43           O  
ATOM  11622  N   GLU F 252      57.247  77.814 164.102  1.00 14.53           N  
ATOM  11623  CA  GLU F 252      56.510  77.990 162.855  1.00 14.80           C  
ATOM  11624  C   GLU F 252      55.150  78.548 163.259  1.00 15.13           C  
ATOM  11625  O   GLU F 252      54.434  77.935 164.062  1.00 15.34           O  
ATOM  11626  CB  GLU F 252      56.351  76.649 162.113  1.00 14.53           C  
ATOM  11627  CG  GLU F 252      55.580  76.797 160.807  1.00 14.57           C  
ATOM  11628  CD  GLU F 252      55.651  75.592 159.898  1.00 14.65           C  
ATOM  11629  OE1 GLU F 252      55.907  74.472 160.375  1.00 16.39           O  
ATOM  11630  OE2 GLU F 252      55.453  75.775 158.688  1.00 14.70           O  
ATOM  11631  N   TYR F 253      54.804  79.709 162.711  1.00 14.94           N  
ATOM  11632  CA  TYR F 253      53.589  80.423 163.076  1.00 15.68           C  
ATOM  11633  C   TYR F 253      52.650  80.460 161.889  1.00 15.44           C  
ATOM  11634  O   TYR F 253      52.910  81.142 160.902  1.00 15.37           O  
ATOM  11635  CB  TYR F 253      53.974  81.824 163.598  1.00 16.45           C  
ATOM  11636  CG  TYR F 253      54.864  81.666 164.826  1.00 16.41           C  
ATOM  11637  CD1 TYR F 253      56.234  81.505 164.689  1.00 15.66           C  
ATOM  11638  CD2 TYR F 253      54.323  81.581 166.104  1.00 17.70           C  
ATOM  11639  CE1 TYR F 253      57.052  81.286 165.783  1.00 15.73           C  
ATOM  11640  CE2 TYR F 253      55.130  81.365 167.207  1.00 17.45           C  
ATOM  11641  CZ  TYR F 253      56.493  81.207 167.037  1.00 16.53           C  
ATOM  11642  OH  TYR F 253      57.292  80.993 168.135  1.00 18.33           O  
ATOM  11643  N   PHE F 254      51.550  79.717 161.990  1.00 15.76           N  
ATOM  11644  CA  PHE F 254      50.615  79.594 160.873  1.00 15.92           C  
ATOM  11645  C   PHE F 254      49.594  80.713 160.871  1.00 16.32           C  
ATOM  11646  O   PHE F 254      49.150  81.151 161.915  1.00 16.73           O  
ATOM  11647  CB  PHE F 254      49.883  78.246 160.943  1.00 15.67           C  
ATOM  11648  CG  PHE F 254      50.782  77.066 160.764  1.00 15.75           C  
ATOM  11649  CD1 PHE F 254      51.241  76.361 161.859  1.00 15.22           C  
ATOM  11650  CD2 PHE F 254      51.203  76.682 159.499  1.00 15.18           C  
ATOM  11651  CE1 PHE F 254      52.084  75.281 161.702  1.00 15.71           C  
ATOM  11652  CE2 PHE F 254      52.049  75.609 159.329  1.00 15.37           C  
ATOM  11653  CZ  PHE F 254      52.499  74.909 160.433  1.00 15.62           C  
ATOM  11654  N   ILE F 255      49.240  81.162 159.670  1.00 16.32           N  
ATOM  11655  CA  ILE F 255      48.229  82.193 159.461  1.00 16.44           C  
ATOM  11656  C   ILE F 255      47.379  81.608 158.342  1.00 16.62           C  
ATOM  11657  O   ILE F 255      47.438  82.042 157.190  1.00 15.24           O  
ATOM  11658  CB  ILE F 255      48.883  83.536 159.055  1.00 17.03           C  
ATOM  11659  CG1 ILE F 255      50.023  83.882 160.022  1.00 18.23           C  
ATOM  11660  CG2 ILE F 255      47.843  84.649 159.064  1.00 17.11           C  
ATOM  11661  CD1 ILE F 255      50.666  85.263 159.783  1.00 18.70           C  
ATOM  11662  N   ASP F 256      46.603  80.585 158.705  1.00 15.84           N  
ATOM  11663  CA  ASP F 256      45.938  79.731 157.729  1.00 16.32           C  
ATOM  11664  C   ASP F 256      44.434  79.849 157.618  1.00 16.51           C  
ATOM  11665  O   ASP F 256      43.838  79.091 156.856  1.00 16.26           O  
ATOM  11666  CB  ASP F 256      46.241  78.272 158.054  1.00 16.15           C  
ATOM  11667  CG  ASP F 256      45.622  77.849 159.369  1.00 18.06           C  
ATOM  11668  OD1 ASP F 256      45.183  76.708 159.520  1.00 19.38           O  
ATOM  11669  OD2 ASP F 256      45.506  78.635 160.322  1.00 26.72           O  
ATOM  11670  N   GLY F 257      43.816  80.762 158.365  1.00 16.66           N  
ATOM  11671  CA  GLY F 257      42.373  80.949 158.296  1.00 17.21           C  
ATOM  11672  C   GLY F 257      41.600  79.735 158.772  1.00 16.81           C  
ATOM  11673  O   GLY F 257      40.414  79.602 158.503  1.00 17.22           O  
ATOM  11674  N   GLY F 258      42.290  78.821 159.451  1.00 16.42           N  
ATOM  11675  CA  GLY F 258      41.649  77.621 159.953  1.00 16.50           C  
ATOM  11676  C   GLY F 258      41.782  76.396 159.066  1.00 16.63           C  
ATOM  11677  O   GLY F 258      41.281  75.342 159.407  1.00 16.28           O  
ATOM  11678  N   GLN F 259      42.451  76.523 157.924  1.00 16.06           N  
ATOM  11679  CA  GLN F 259      42.566  75.391 157.006  1.00 15.95           C  
ATOM  11680  C   GLN F 259      43.142  74.130 157.667  1.00 15.70           C  
ATOM  11681  O   GLN F 259      42.730  72.999 157.351  1.00 15.36           O  
ATOM  11682  CB  GLN F 259      43.442  75.754 155.802  1.00 16.13           C  
ATOM  11683  CG  GLN F 259      43.559  74.631 154.784  1.00 16.92           C  
ATOM  11684  CD  GLN F 259      42.259  74.390 154.064  1.00 18.36           C  
ATOM  11685  OE1 GLN F 259      41.923  75.118 153.138  1.00 21.24           O  
ATOM  11686  NE2 GLN F 259      41.508  73.381 154.500  1.00 19.30           N  
ATOM  11687  N   LEU F 260      44.108  74.315 158.568  1.00 14.86           N  
ATOM  11688  CA  LEU F 260      44.758  73.182 159.230  1.00 15.23           C  
ATOM  11689  C   LEU F 260      43.873  72.499 160.272  1.00 15.64           C  
ATOM  11690  O   LEU F 260      44.262  71.469 160.830  1.00 15.02           O  
ATOM  11691  CB  LEU F 260      46.089  73.608 159.859  1.00 15.29           C  
ATOM  11692  CG  LEU F 260      47.129  74.046 158.822  1.00 15.78           C  
ATOM  11693  CD1 LEU F 260      48.407  74.536 159.481  1.00 15.38           C  
ATOM  11694  CD2 LEU F 260      47.432  72.900 157.864  1.00 16.06           C  
ATOM  11695  N   ILE F 261      42.684  73.037 160.514  1.00 15.72           N  
ATOM  11696  CA  ILE F 261      41.748  72.431 161.460  1.00 16.17           C  
ATOM  11697  C   ILE F 261      41.210  71.122 160.902  1.00 16.44           C  
ATOM  11698  O   ILE F 261      40.977  70.172 161.643  1.00 15.52           O  
ATOM  11699  CB  ILE F 261      40.574  73.396 161.733  1.00 16.81           C  
ATOM  11700  CG1 ILE F 261      41.038  74.571 162.578  1.00 17.03           C  
ATOM  11701  CG2 ILE F 261      39.426  72.683 162.445  1.00 17.95           C  
ATOM  11702  CD1 ILE F 261      39.955  75.630 162.738  1.00 17.95           C  
ATOM  11703  N   TRP F 262      40.989  71.089 159.591  1.00 15.20           N  
ATOM  11704  CA  TRP F 262      40.395  69.937 158.933  1.00 16.03           C  
ATOM  11705  C   TRP F 262      41.424  68.873 158.532  1.00 15.31           C  
ATOM  11706  O   TRP F 262      41.009  67.761 158.151  1.00 14.98           O  
ATOM  11707  CB  TRP F 262      39.661  70.365 157.672  1.00 16.13           C  
ATOM  11708  CG  TRP F 262      38.630  71.453 157.786  1.00 17.29           C  
ATOM  11709  CD1 TRP F 262      38.497  72.527 156.943  1.00 17.59           C  
ATOM  11710  CD2 TRP F 262      37.544  71.547 158.723  1.00 17.51           C  
ATOM  11711  NE1 TRP F 262      37.413  73.283 157.307  1.00 17.02           N  
ATOM  11712  CE2 TRP F 262      36.810  72.711 158.398  1.00 17.93           C  
ATOM  11713  CE3 TRP F 262      37.117  70.776 159.818  1.00 17.98           C  
ATOM  11714  CZ2 TRP F 262      35.680  73.115 159.115  1.00 19.18           C  
ATOM  11715  CZ3 TRP F 262      35.991  71.176 160.523  1.00 18.57           C  
ATOM  11716  CH2 TRP F 262      35.286  72.340 160.171  1.00 18.45           C  
ATOM  11717  OXT TRP F 262      42.652  69.095 158.520  1.00 14.79           O  
TER   11718      TRP F 262                                                      
END
MOLECULE T0433.pdb
ATOM     20  N   MET     1      66.006 100.902 164.016  1.00 30.54           N  
ATOM     21  CA  MET     1      66.034  99.529 163.534  1.00 31.40           C  
ATOM     22  C   MET     1      66.182  99.479 162.021  1.00 29.91           C  
ATOM     23  O   MET     1      65.465 100.179 161.296  1.00 29.44           O  
ATOM     24  CB  MET     1      64.765  98.773 163.923  1.00 31.12           C  
ATOM     25  CG  MET     1      64.859  97.281 163.566  1.00 33.22           C  
ATOM     26  SD  MET     1      63.341  96.179 164.096  0.60 38.15          SE  
ATOM     27  CE  MET     1      63.492  96.512 165.999  1.00 34.50           C  
ATOM     28  N   LYS     2      67.106  98.634 161.558  1.00 29.48           N  
ATOM     29  CA  LYS     2      67.339  98.409 160.121  1.00 28.09           C  
ATOM     30  C   LYS     2      66.846  97.026 159.675  1.00 27.23           C  
ATOM     31  O   LYS     2      67.326  96.009 160.189  1.00 27.45           O  
ATOM     32  CB  LYS     2      68.816  98.523 159.822  1.00 27.77           C  
ATOM     33  CG  LYS     2      69.356  99.917 159.951  1.00 28.85           C  
ATOM     34  CD  LYS     2      70.835  99.967 159.595  1.00 29.12           C  
ATOM     35  CE  LYS     2      71.363 101.430 159.579  1.00 27.44           C  
ATOM     36  NZ  LYS     2      70.977 102.131 158.307  1.00 28.69           N  
ATOM     37  N   ILE     3      65.910  96.999 158.723  1.00 25.89           N  
ATOM     38  CA  ILE     3      65.296  95.750 158.256  1.00 25.76           C  
ATOM     39  C   ILE     3      65.605  95.566 156.788  1.00 25.88           C  
ATOM     40  O   ILE     3      65.255  96.405 156.002  1.00 27.10           O  
ATOM     41  CB  ILE     3      63.753  95.745 158.441  1.00 25.79           C  
ATOM     42  CG1 ILE     3      63.394  95.872 159.921  1.00 25.30           C  
ATOM     43  CG2 ILE     3      63.126  94.472 157.901  1.00 24.82           C  
ATOM     44  CD1 ILE     3      61.903  95.840 160.165  1.00 25.00           C  
ATOM     45  N   LEU     4      66.306  94.498 156.431  1.00 25.66           N  
ATOM     46  CA  LEU     4      66.484  94.169 155.036  1.00 26.82           C  
ATOM     47  C   LEU     4      65.292  93.313 154.574  1.00 26.72           C  
ATOM     48  O   LEU     4      65.126  92.175 155.019  1.00 27.97           O  
ATOM     49  CB  LEU     4      67.817  93.439 154.807  1.00 26.60           C  
ATOM     50  CG  LEU     4      68.076  92.994 153.362  1.00 25.81           C  
ATOM     51  CD1 LEU     4      68.199  94.183 152.401  1.00 23.22           C  
ATOM     52  CD2 LEU     4      69.319  92.113 153.294  1.00 27.38           C  
ATOM     53  N   LEU     5      64.458  93.886 153.709  1.00 27.66           N  
ATOM     54  CA  LEU     5      63.302  93.194 153.117  1.00 27.99           C  
ATOM     55  C   LEU     5      63.556  92.704 151.672  1.00 28.42           C  
ATOM     56  O   LEU     5      63.510  93.478 150.710  1.00 28.87           O  
ATOM     57  CB  LEU     5      62.084  94.121 153.146  1.00 28.06           C  
ATOM     58  CG  LEU     5      60.723  93.525 152.740  1.00 27.67           C  
ATOM     59  CD1 LEU     5      60.434  92.306 153.565  1.00 25.96           C  
ATOM     60  CD2 LEU     5      59.625  94.532 152.942  1.00 27.45           C  
ATOM     61  N   ILE     6      63.793  91.412 151.521  1.00 29.13           N  
ATOM     62  CA  ILE     6      64.044  90.827 150.202  1.00 29.17           C  
ATOM     63  C   ILE     6      62.724  90.345 149.605  1.00 29.51           C  
ATOM     64  O   ILE     6      62.002  89.601 150.241  1.00 29.55           O  
ATOM     65  CB  ILE     6      65.099  89.709 150.282  1.00 29.51           C  
ATOM     66  CG1 ILE     6      66.315  90.194 151.102  1.00 29.55           C  
ATOM     67  CG2 ILE     6      65.525  89.244 148.891  1.00 29.32           C  
ATOM     68  CD1 ILE     6      66.874  89.125 151.998  1.00 29.14           C  
ATOM     69  N   GLY     7      62.399  90.856 148.415  1.00 30.23           N  
ATOM     70  CA  GLY     7      61.140  90.591 147.744  1.00 31.22           C  
ATOM     71  C   GLY     7      60.100  91.656 148.035  1.00 32.04           C  
ATOM     72  O   GLY     7      58.896  91.406 147.908  1.00 32.57           O  
ATOM     73  N   ALA     8      60.569  92.846 148.411  1.00 32.09           N  
ATOM     74  CA  ALA     8      59.720  93.956 148.854  1.00 31.87           C  
ATOM     75  C   ALA     8      58.684  94.452 147.836  1.00 32.25           C  
ATOM     76  O   ALA     8      57.696  95.101 148.208  1.00 31.65           O  
ATOM     77  CB  ALA     8      60.595  95.095 149.276  1.00 31.67           C  
ATOM     78  N   SER     9      58.926  94.173 146.558  1.00 32.33           N  
ATOM     79  CA  SER     9      58.029  94.616 145.519  1.00 33.35           C  
ATOM     80  C   SER     9      57.001  93.558 145.126  1.00 33.22           C  
ATOM     81  O   SER     9      56.157  93.825 144.301  1.00 33.62           O  
ATOM     82  CB  SER     9      58.813  95.157 144.311  1.00 34.03           C  
ATOM     83  OG  SER     9      59.392  94.098 143.571  1.00 36.88           O  
ATOM     84  N   GLY    10      57.043  92.378 145.748  1.00 33.16           N  
ATOM     85  CA  GLY    10      56.023  91.363 145.524  1.00 33.46           C  
ATOM     86  C   GLY    10      54.745  91.676 146.287  1.00 33.31           C  
ATOM     87  O   GLY    10      54.741  92.545 147.160  1.00 32.91           O  
ATOM     88  N   THR    11      53.663  90.967 145.961  1.00 33.48           N  
ATOM     89  CA  THR    11      52.366  91.118 146.662  1.00 33.27           C  
ATOM     90  C   THR    11      52.492  91.023 148.180  1.00 32.36           C  
ATOM     91  O   THR    11      51.963  91.860 148.902  1.00 32.98           O  
ATOM     92  CB  THR    11      51.328  90.066 146.159  1.00 34.07           C  
ATOM     93  OG1 THR    11      51.277  90.113 144.734  1.00 34.95           O  
ATOM     94  CG2 THR    11      49.928  90.350 146.725  1.00 34.27           C  
ATOM     95  N   LEU    12      53.212  90.008 148.654  1.00 31.60           N  
ATOM     96  CA  LEU    12      53.394  89.769 150.076  1.00 30.72           C  
ATOM     97  C   LEU    12      54.449  90.702 150.655  1.00 30.82           C  
ATOM     98  O   LEU    12      54.247  91.293 151.726  1.00 30.91           O  
ATOM     99  CB  LEU    12      53.771  88.298 150.347  1.00 31.02           C  
ATOM    100  CG  LEU    12      54.141  87.988 151.805  1.00 30.39           C  
ATOM    101  CD1 LEU    12      52.931  88.264 152.698  1.00 29.48           C  
ATOM    102  CD2 LEU    12      54.697  86.563 152.015  1.00 30.19           C  
ATOM    103  N   GLY    13      55.572  90.834 149.952  1.00 30.22           N  
ATOM    104  CA  GLY    13      56.627  91.740 150.392  1.00 30.16           C  
ATOM    105  C   GLY    13      56.081  93.139 150.577  1.00 29.55           C  
ATOM    106  O   GLY    13      56.441  93.836 151.523  1.00 29.43           O  
ATOM    107  N   SER    14      55.166  93.524 149.695  1.00 29.09           N  
ATOM    108  CA  SER    14      54.622  94.875 149.693  1.00 29.34           C  
ATOM    109  C   SER    14      53.779  95.149 150.937  1.00 28.73           C  
ATOM    110  O   SER    14      53.922  96.194 151.573  1.00 29.08           O  
ATOM    111  CB  SER    14      53.818  95.119 148.400  1.00 30.09           C  
ATOM    112  OG  SER    14      53.418  96.478 148.322  1.00 33.26           O  
ATOM    113  N   ALA    15      52.906  94.203 151.285  1.00 28.08           N  
ATOM    114  CA  ALA    15      52.120  94.297 152.515  1.00 26.86           C  
ATOM    115  C   ALA    15      53.006  94.274 153.751  1.00 26.45           C  
ATOM    116  O   ALA    15      52.717  94.945 154.719  1.00 26.48           O  
ATOM    117  CB  ALA    15      51.114  93.188 152.580  1.00 26.72           C  
ATOM    118  N   VAL    16      54.069  93.478 153.727  1.00 26.38           N  
ATOM    119  CA  VAL    16      55.050  93.487 154.816  1.00 26.86           C  
ATOM    120  C   VAL    16      55.751  94.850 154.960  1.00 27.51           C  
ATOM    121  O   VAL    16      55.927  95.342 156.073  1.00 28.52           O  
ATOM    122  CB  VAL    16      56.087  92.335 154.646  1.00 26.98           C  
ATOM    123  CG1 VAL    16      57.167  92.382 155.752  1.00 24.98           C  
ATOM    124  CG2 VAL    16      55.353  90.983 154.654  1.00 25.96           C  
ATOM    125  N   LYS    17      56.156  95.452 153.845  1.00 27.51           N  
ATOM    126  CA  LYS    17      56.826  96.750 153.881  1.00 28.86           C  
ATOM    127  C   LYS    17      55.901  97.808 154.506  1.00 28.85           C  
ATOM    128  O   LYS    17      56.310  98.571 155.375  1.00 28.00           O  
ATOM    129  CB  LYS    17      57.250  97.176 152.473  1.00 28.12           C  
ATOM    130  CG  LYS    17      58.136  98.424 152.420  1.00 28.98           C  
ATOM    131  CD  LYS    17      58.199  99.019 151.016  1.00 30.35           C  
ATOM    132  CE  LYS    17      59.040 100.287 151.006  1.00 36.34           C  
ATOM    133  NZ  LYS    17      58.269 101.477 150.476  1.00 39.61           N  
ATOM    134  N   GLU    18      54.647  97.814 154.079  1.00 29.40           N  
ATOM    135  CA  GLU    18      53.669  98.723 154.635  1.00 31.13           C  
ATOM    136  C   GLU    18      53.607  98.684 156.180  1.00 30.02           C  
ATOM    137  O   GLU    18      53.508  99.723 156.820  1.00 30.06           O  
ATOM    138  CB  GLU    18      52.296  98.450 154.025  1.00 31.24           C  
ATOM    139  CG  GLU    18      51.297  99.584 154.201  1.00 33.76           C  
ATOM    140  CD  GLU    18      50.037  99.390 153.365  1.00 36.05           C  
ATOM    141  OE1 GLU    18      50.053  98.555 152.420  1.00 42.91           O  
ATOM    142  OE2 GLU    18      49.021 100.082 153.641  1.00 43.15           O  
ATOM    143  N   ARG    19      53.685  97.509 156.785  1.00 29.53           N  
ATOM    144  CA  ARG    19      53.645  97.464 158.252  1.00 29.61           C  
ATOM    145  C   ARG    19      54.988  97.830 158.865  1.00 29.47           C  
ATOM    146  O   ARG    19      55.037  98.579 159.803  1.00 28.55           O  
ATOM    147  CB  ARG    19      53.228  96.100 158.771  1.00 28.97           C  
ATOM    148  CG  ARG    19      51.860  95.659 158.312  1.00 29.53           C  
ATOM    149  CD  ARG    19      51.364  94.561 159.240  1.00 31.28           C  
ATOM    150  NE  ARG    19      51.271  95.028 160.621  1.00 31.95           N  
ATOM    151  CZ  ARG    19      50.165  95.513 161.180  1.00 32.20           C  
ATOM    152  NH1 ARG    19      49.029  95.619 160.487  1.00 30.24           N  
ATOM    153  NH2 ARG    19      50.205  95.917 162.436  1.00 31.68           N  
ATOM    154  N   LEU    20      56.069  97.282 158.326  1.00 30.11           N  
ATOM    155  CA  LEU    20      57.398  97.467 158.932  1.00 30.83           C  
ATOM    156  C   LEU    20      57.906  98.916 158.888  1.00 30.81           C  
ATOM    157  O   LEU    20      58.534  99.418 159.824  1.00 30.95           O  
ATOM    158  CB  LEU    20      58.395  96.490 158.301  1.00 30.17           C  
ATOM    159  CG  LEU    20      58.128  95.001 158.562  1.00 32.14           C  
ATOM    160  CD1 LEU    20      59.241  94.109 157.934  1.00 32.94           C  
ATOM    161  CD2 LEU    20      57.908  94.629 160.038  1.00 30.05           C  
ATOM    162  N   GLU    21      57.599  99.558 157.771  1.00 31.32           N  
ATOM    163  CA  GLU    21      57.940 100.918 157.400  1.00 31.24           C  
ATOM    164  C   GLU    21      57.522 101.953 158.455  1.00 31.01           C  
ATOM    165  O   GLU    21      58.148 103.001 158.582  1.00 31.01           O  
ATOM    166  CB  GLU    21      57.152 101.149 156.123  1.00 31.39           C  
ATOM    167  CG  GLU    21      57.388 102.338 155.355  1.00 35.19           C  
ATOM    168  CD  GLU    21      56.609 102.275 154.070  1.00 38.08           C  
ATOM    169  OE1 GLU    21      57.232 102.044 153.021  1.00 40.66           O  
ATOM    170  OE2 GLU    21      55.372 102.421 154.110  1.00 40.60           O  
ATOM    171  N   LYS    22      56.455 101.658 159.197  1.00 31.04           N  
ATOM    172  CA  LYS    22      55.924 102.564 160.221  1.00 30.94           C  
ATOM    173  C   LYS    22      56.811 102.630 161.465  1.00 30.52           C  
ATOM    174  O   LYS    22      56.681 103.547 162.270  1.00 30.90           O  
ATOM    175  CB  LYS    22      54.511 102.139 160.628  1.00 31.54           C  
ATOM    176  CG  LYS    22      53.556 101.944 159.460  1.00 32.93           C  
ATOM    177  CD  LYS    22      52.289 101.284 159.920  1.00 36.32           C  
ATOM    178  CE  LYS    22      51.331 101.128 158.754  1.00 40.34           C  
ATOM    179  NZ  LYS    22      51.088 102.441 158.083  1.00 39.09           N  
ATOM    180  N   LYS    23      57.728 101.684 161.619  1.00 29.61           N  
ATOM    181  CA  LYS    23      58.566 101.657 162.835  1.00 29.72           C  
ATOM    182  C   LYS    23      60.012 101.231 162.686  1.00 28.69           C  
ATOM    183  O   LYS    23      60.709 101.091 163.674  1.00 29.01           O  
ATOM    184  CB  LYS    23      57.921 100.821 163.935  1.00 29.86           C  
ATOM    185  CG  LYS    23      56.832  99.941 163.461  1.00 32.38           C  
ATOM    186  CD  LYS    23      55.808  99.771 164.568  1.00 37.27           C  
ATOM    187  CE  LYS    23      55.798  98.363 165.087  1.00 36.51           C  
ATOM    188  NZ  LYS    23      54.492  98.134 165.729  1.00 38.60           N  
ATOM    189  N   ALA    24      60.461 101.009 161.461  1.00 28.04           N  
ATOM    190  CA  ALA    24      61.866 100.760 161.229  1.00 27.63           C  
ATOM    191  C   ALA    24      62.245 101.307 159.865  1.00 27.25           C  
ATOM    192  O   ALA    24      61.366 101.642 159.060  1.00 26.73           O  
ATOM    193  CB  ALA    24      62.169  99.289 161.329  1.00 27.37           C  
ATOM    194  N   GLU    25      63.551 101.433 159.638  1.00 27.27           N  
ATOM    195  CA  GLU    25      64.081 101.772 158.330  1.00 27.27           C  
ATOM    196  C   GLU    25      64.102 100.507 157.472  1.00 26.92           C  
ATOM    197  O   GLU    25      64.846  99.565 157.768  1.00 26.87           O  
ATOM    198  CB  GLU    25      65.496 102.383 158.422  1.00 26.99           C  
ATOM    199  CG  GLU    25      66.170 102.460 157.029  1.00 26.98           C  
ATOM    200  CD  GLU    25      67.656 102.799 157.053  1.00 28.27           C  
ATOM    201  OE1 GLU    25      68.276 102.751 158.132  1.00 28.17           O  
ATOM    202  OE2 GLU    25      68.201 103.151 155.975  1.00 28.59           O  
ATOM    203  N   VAL    26      63.305 100.491 156.401  1.00 26.81           N  
ATOM    204  CA  VAL    26      63.250  99.314 155.551  1.00 26.96           C  
ATOM    205  C   VAL    26      64.162  99.482 154.333  1.00 27.22           C  
ATOM    206  O   VAL    26      63.985 100.391 153.533  1.00 27.46           O  
ATOM    207  CB  VAL    26      61.793  98.920 155.140  1.00 26.65           C  
ATOM    208  CG1 VAL    26      61.803  97.693 154.228  1.00 25.56           C  
ATOM    209  CG2 VAL    26      60.922  98.621 156.364  1.00 27.09           C  
ATOM    210  N   ILE    27      65.152  98.605 154.217  1.00 27.33           N  
ATOM    211  CA  ILE    27      66.029  98.558 153.039  1.00 27.69           C  
ATOM    212  C   ILE    27      65.476  97.465 152.133  1.00 27.86           C  
ATOM    213  O   ILE    27      65.402  96.301 152.508  1.00 27.58           O  
ATOM    214  CB  ILE    27      67.489  98.245 153.447  1.00 26.97           C  
ATOM    215  CG1 ILE    27      67.937  99.270 154.470  1.00 28.56           C  
ATOM    216  CG2 ILE    27      68.435  98.229 152.224  1.00 27.55           C  
ATOM    217  CD1 ILE    27      68.847  98.698 155.600  1.00 29.58           C  
ATOM    218  N   THR    28      65.029  97.863 150.954  1.00 28.51           N  
ATOM    219  CA  THR    28      64.392  96.927 150.047  1.00 28.43           C  
ATOM    220  C   THR    28      65.405  96.255 149.115  1.00 28.83           C  
ATOM    221  O   THR    28      66.370  96.876 148.662  1.00 28.93           O  
ATOM    222  CB  THR    28      63.295  97.615 149.229  1.00 28.34           C  
ATOM    223  OG1 THR    28      63.894  98.645 148.433  1.00 28.18           O  
ATOM    224  CG2 THR    28      62.241  98.245 150.179  1.00 28.07           C  
ATOM    225  N   ALA    29      65.157  94.979 148.841  1.00 29.69           N  
ATOM    226  CA  ALA    29      65.945  94.185 147.916  1.00 30.05           C  
ATOM    227  C   ALA    29      64.978  93.373 147.062  1.00 30.59           C  
ATOM    228  O   ALA    29      63.919  92.962 147.533  1.00 30.68           O  
ATOM    229  CB  ALA    29      66.860  93.273 148.665  1.00 29.79           C  
ATOM    230  N   GLY    30      65.329  93.178 145.799  1.00 30.69           N  
ATOM    231  CA  GLY    30      64.541  92.346 144.898  1.00 31.31           C  
ATOM    232  C   GLY    30      65.432  91.992 143.732  1.00 31.66           C  
ATOM    233  O   GLY    30      66.581  92.450 143.660  1.00 30.63           O  
ATOM    234  N   ARG    31      64.918  91.189 142.811  1.00 33.00           N  
ATOM    235  CA  ARG    31      65.729  90.819 141.665  1.00 33.89           C  
ATOM    236  C   ARG    31      65.957  91.991 140.738  1.00 34.88           C  
ATOM    237  O   ARG    31      67.078  92.171 140.268  1.00 34.83           O  
ATOM    238  CB  ARG    31      65.204  89.598 140.898  1.00 34.45           C  
ATOM    239  CG  ARG    31      66.369  88.613 140.619  1.00 34.99           C  
ATOM    240  CD  ARG    31      66.404  88.239 139.212  1.00 33.69           C  
ATOM    241  NE  ARG    31      67.719  87.953 138.626  1.00 32.87           N  
ATOM    242  CZ  ARG    31      68.771  88.779 138.582  1.00 33.03           C  
ATOM    243  NH1 ARG    31      69.856  88.388 137.936  1.00 33.24           N  
ATOM    244  NH2 ARG    31      68.784  89.960 139.209  1.00 30.66           N  
ATOM    245  N   HIS    32      64.925  92.805 140.516  1.00 35.93           N  
ATOM    246  CA  HIS    32      65.015  93.907 139.530  1.00 37.44           C  
ATOM    247  C   HIS    32      64.922  95.323 140.066  1.00 38.17           C  
ATOM    248  O   HIS    32      65.514  96.238 139.478  1.00 39.14           O  
ATOM    249  CB  HIS    32      63.972  93.724 138.434  1.00 37.91           C  
ATOM    250  CG  HIS    32      64.083  92.411 137.742  1.00 38.14           C  
ATOM    251  ND1 HIS    32      65.207  92.046 137.032  1.00 38.54           N  
ATOM    252  CD2 HIS    32      63.239  91.354 137.694  1.00 38.48           C  
ATOM    253  CE1 HIS    32      65.036  90.824 136.555  1.00 39.45           C  
ATOM    254  NE2 HIS    32      63.844  90.391 136.927  1.00 37.38           N  
ATOM    255  N   SER    33      64.176  95.491 141.157  1.00 38.58           N  
ATOM    256  CA  SER    33      63.980  96.777 141.831  1.00 39.46           C  
ATOM    257  C   SER    33      64.320  96.670 143.307  1.00 38.87           C  
ATOM    258  O   SER    33      64.323  95.584 143.871  1.00 38.68           O  
ATOM    259  CB  SER    33      62.518  97.216 141.729  1.00 39.72           C  
ATOM    260  OG  SER    33      62.332  98.018 140.580  1.00 42.93           O  
ATOM    261  N   GLY    34      64.579  97.814 143.926  1.00 38.45           N  
ATOM    262  CA  GLY    34      64.831  97.882 145.360  1.00 38.14           C  
ATOM    263  C   GLY    34      66.042  98.756 145.591  1.00 37.85           C  
ATOM    264  O   GLY    34      66.692  99.180 144.632  1.00 37.39           O  
ATOM    265  N   ASP    35      66.326  99.040 146.858  1.00 37.48           N  
ATOM    266  CA  ASP    35      67.518  99.773 147.235  1.00 37.26           C  
ATOM    267  C   ASP    35      68.748  98.949 146.807  1.00 37.19           C  
ATOM    268  O   ASP    35      69.730  99.506 146.326  1.00 37.10           O  
ATOM    269  CB  ASP    35      67.542 100.052 148.750  1.00 37.63           C  
ATOM    270  CG  ASP    35      66.417 100.997 149.216  1.00 38.42           C  
ATOM    271  OD1 ASP    35      66.225 102.081 148.612  1.00 40.32           O  
ATOM    272  OD2 ASP    35      65.729 100.673 150.217  1.00 39.20           O  
ATOM    273  N   VAL    36      68.683  97.624 146.980  1.00 36.53           N  
ATOM    274  CA  VAL    36      69.713  96.702 146.448  1.00 35.63           C  
ATOM    275  C   VAL    36      69.098  95.563 145.633  1.00 34.64           C  
ATOM    276  O   VAL    36      67.989  95.111 145.904  1.00 34.27           O  
ATOM    277  CB  VAL    36      70.649  96.101 147.556  1.00 35.05           C  
ATOM    278  CG1 VAL    36      71.406  97.188 148.271  1.00 36.74           C  
ATOM    279  CG2 VAL    36      69.870  95.272 148.559  1.00 35.22           C  
ATOM    280  N   THR    37      69.823  95.092 144.631  1.00 34.22           N  
ATOM    281  CA  THR    37      69.319  93.988 143.828  1.00 33.79           C  
ATOM    282  C   THR    37      70.066  92.688 144.146  1.00 32.97           C  
ATOM    283  O   THR    37      71.248  92.697 144.509  1.00 32.63           O  
ATOM    284  CB  THR    37      69.267  94.309 142.320  1.00 33.76           C  
ATOM    285  OG1 THR    37      70.584  94.587 141.828  1.00 35.76           O  
ATOM    286  CG2 THR    37      68.369  95.514 142.077  1.00 34.81           C  
ATOM    287  N   VAL    38      69.341  91.578 144.062  1.00 32.25           N  
ATOM    288  CA  VAL    38      69.899  90.289 144.443  1.00 31.31           C  
ATOM    289  C   VAL    38      69.334  89.132 143.634  1.00 31.41           C  
ATOM    290  O   VAL    38      68.132  89.093 143.354  1.00 31.72           O  
ATOM    291  CB  VAL    38      69.757  90.018 145.965  1.00 30.70           C  
ATOM    292  CG1 VAL    38      68.293  89.876 146.395  1.00 28.51           C  
ATOM    293  CG2 VAL    38      70.534  88.791 146.321  1.00 31.36           C  
ATOM    294  N   ASP    39      70.221  88.211 143.249  1.00 30.53           N  
ATOM    295  CA  ASP    39      69.826  86.923 142.681  1.00 30.50           C  
ATOM    296  C   ASP    39      70.025  85.799 143.726  1.00 29.76           C  
ATOM    297  O   ASP    39      71.139  85.248 143.868  1.00 29.33           O  
ATOM    298  CB  ASP    39      70.633  86.625 141.395  1.00 30.79           C  
ATOM    299  CG  ASP    39      70.195  85.334 140.716  1.00 32.20           C  
ATOM    300  OD1 ASP    39      69.159  84.760 141.128  1.00 33.16           O  
ATOM    301  OD2 ASP    39      70.886  84.901 139.753  1.00 36.58           O  
ATOM    302  N   ILE    40      68.955  85.473 144.460  1.00 29.38           N  
ATOM    303  CA  ILE    40      69.036  84.476 145.548  1.00 28.94           C  
ATOM    304  C   ILE    40      69.465  83.069 145.123  1.00 28.58           C  
ATOM    305  O   ILE    40      69.821  82.266 145.989  1.00 28.65           O  
ATOM    306  CB  ILE    40      67.759  84.392 146.405  1.00 28.74           C  
ATOM    307  CG1 ILE    40      66.595  83.795 145.595  1.00 30.50           C  
ATOM    308  CG2 ILE    40      67.430  85.767 147.045  1.00 28.60           C  
ATOM    309  CD1 ILE    40      65.492  83.172 146.464  1.00 29.39           C  
ATOM    310  N   THR    41      69.441  82.774 143.813  1.00 27.92           N  
ATOM    311  CA  THR    41      69.923  81.477 143.305  1.00 26.91           C  
ATOM    312  C   THR    41      71.449  81.479 143.140  1.00 27.43           C  
ATOM    313  O   THR    41      72.046  80.455 142.797  1.00 26.35           O  
ATOM    314  CB  THR    41      69.296  81.096 141.933  1.00 27.63           C  
ATOM    315  OG1 THR    41      69.809  81.944 140.883  1.00 26.03           O  
ATOM    316  CG2 THR    41      67.723  81.111 141.968  1.00 28.15           C  
ATOM    317  N   ASN    42      72.064  82.650 143.350  1.00 27.04           N  
ATOM    318  CA  ASN    42      73.477  82.841 143.110  1.00 27.38           C  
ATOM    319  C   ASN    42      74.171  83.352 144.377  1.00 27.71           C  
ATOM    320  O   ASN    42      73.952  84.491 144.798  1.00 27.18           O  
ATOM    321  CB  ASN    42      73.656  83.833 141.975  1.00 27.56           C  
ATOM    322  CG  ASN    42      75.078  83.923 141.505  1.00 28.64           C  
ATOM    323  OD1 ASN    42      75.955  84.414 142.227  1.00 30.86           O  
ATOM    324  ND2 ASN    42      75.317  83.498 140.266  1.00 27.24           N  
ATOM    325  N   ILE    43      74.979  82.510 145.012  1.00 27.57           N  
ATOM    326  CA  ILE    43      75.523  82.916 146.309  1.00 28.51           C  
ATOM    327  C   ILE    43      76.486  84.094 146.218  1.00 28.08           C  
ATOM    328  O   ILE    43      76.567  84.874 147.167  1.00 27.91           O  
ATOM    329  CB  ILE    43      76.103  81.730 147.170  1.00 28.59           C  
ATOM    330  CG1 ILE    43      77.521  81.310 146.740  1.00 30.31           C  
ATOM    331  CG2 ILE    43      75.080  80.578 147.279  1.00 30.61           C  
ATOM    332  CD1 ILE    43      77.572  80.470 145.499  1.00 31.38           C  
ATOM    333  N   ASP    44      77.191  84.263 145.093  1.00 27.91           N  
ATOM    334  CA  ASP    44      78.040  85.466 144.991  1.00 29.17           C  
ATOM    335  C   ASP    44      77.154  86.727 144.899  1.00 27.92           C  
ATOM    336  O   ASP    44      77.510  87.768 145.420  1.00 26.84           O  
ATOM    337  CB  ASP    44      79.098  85.401 143.875  1.00 30.14           C  
ATOM    338  CG  ASP    44      80.095  86.589 143.934  1.00 35.50           C  
ATOM    339  OD1 ASP    44      80.582  86.952 145.053  1.00 40.68           O  
ATOM    340  OD2 ASP    44      80.397  87.167 142.855  1.00 41.54           O  
ATOM    341  N   SER    45      75.963  86.599 144.320  1.00 27.03           N  
ATOM    342  CA  SER    45      75.034  87.722 144.307  1.00 26.97           C  
ATOM    343  C   SER    45      74.516  88.028 145.718  1.00 26.48           C  
ATOM    344  O   SER    45      74.399  89.182 146.095  1.00 26.21           O  
ATOM    345  CB  SER    45      73.890  87.495 143.333  1.00 26.64           C  
ATOM    346  OG  SER    45      72.957  88.558 143.445  1.00 28.69           O  
ATOM    347  N   ILE    46      74.224  86.996 146.494  1.00 25.96           N  
ATOM    348  CA  ILE    46      73.833  87.201 147.897  1.00 26.95           C  
ATOM    349  C   ILE    46      74.968  87.862 148.692  1.00 27.59           C  
ATOM    350  O   ILE    46      74.747  88.814 149.427  1.00 27.43           O  
ATOM    351  CB  ILE    46      73.394  85.893 148.581  1.00 26.24           C  
ATOM    352  CG1 ILE    46      72.147  85.345 147.878  1.00 26.54           C  
ATOM    353  CG2 ILE    46      73.116  86.133 150.097  1.00 26.47           C  
ATOM    354  CD1 ILE    46      71.788  83.933 148.305  1.00 24.99           C  
ATOM    355  N   LYS    47      76.178  87.343 148.525  1.00 28.50           N  
ATOM    356  CA  LYS    47      77.356  87.895 149.171  1.00 29.72           C  
ATOM    357  C   LYS    47      77.564  89.393 148.848  1.00 30.13           C  
ATOM    358  O   LYS    47      77.805  90.203 149.751  1.00 29.54           O  
ATOM    359  CB  LYS    47      78.578  87.064 148.767  1.00 30.30           C  
ATOM    360  CG  LYS    47      78.673  85.716 149.477  1.00 32.50           C  
ATOM    361  CD  LYS    47      79.887  84.944 148.971  1.00 36.21           C  
ATOM    362  CE  LYS    47      80.083  83.653 149.768  1.00 37.75           C  
ATOM    363  NZ  LYS    47      81.284  82.869 149.334  1.00 38.21           N  
ATOM    364  N   LYS    48      77.468  89.741 147.559  1.00 30.44           N  
ATOM    365  CA  LYS    48      77.582  91.122 147.096  1.00 31.51           C  
ATOM    366  C   LYS    48      76.504  92.002 147.731  1.00 31.18           C  
ATOM    367  O   LYS    48      76.784  93.135 148.130  1.00 30.84           O  
ATOM    368  CB  LYS    48      77.493  91.185 145.566  1.00 31.62           C  
ATOM    369  CG  LYS    48      78.736  90.634 144.841  1.00 33.07           C  
ATOM    370  CD  LYS    48      78.630  90.787 143.303  1.00 33.79           C  
ATOM    371  CE  LYS    48      78.160  89.476 142.644  1.00 37.12           C  
ATOM    372  NZ  LYS    48      77.685  89.583 141.225  1.00 36.87           N  
ATOM    373  N   MET    49      75.283  91.471 147.837  1.00 30.83           N  
ATOM    374  CA  MET    49      74.181  92.190 148.491  1.00 31.77           C  
ATOM    375  C   MET    49      74.504  92.558 149.934  1.00 30.97           C  
ATOM    376  O   MET    49      74.351  93.702 150.324  1.00 30.22           O  
ATOM    377  CB  MET    49      72.872  91.393 148.461  1.00 31.29           C  
ATOM    378  CG  MET    49      71.749  92.116 149.184  1.00 32.56           C  
ATOM    379  SD  MET    49      70.139  91.076 149.565  0.70 34.45          SE  
ATOM    380  CE  MET    49      70.849  89.754 150.815  1.00 34.11           C  
ATOM    381  N   TYR    50      74.922  91.577 150.728  1.00 30.70           N  
ATOM    382  CA  TYR    50      75.252  91.834 152.147  1.00 31.24           C  
ATOM    383  C   TYR    50      76.454  92.804 152.321  1.00 32.06           C  
ATOM    384  O   TYR    50      76.481  93.637 153.238  1.00 32.05           O  
ATOM    385  CB  TYR    50      75.513  90.516 152.861  1.00 29.92           C  
ATOM    386  CG  TYR    50      74.266  89.723 153.203  1.00 29.82           C  
ATOM    387  CD1 TYR    50      73.207  90.306 153.916  1.00 27.46           C  
ATOM    388  CD2 TYR    50      74.153  88.375 152.844  1.00 27.81           C  
ATOM    389  CE1 TYR    50      72.071  89.567 154.236  1.00 28.82           C  
ATOM    390  CE2 TYR    50      73.019  87.629 153.170  1.00 27.43           C  
ATOM    391  CZ  TYR    50      71.980  88.227 153.878  1.00 27.56           C  
ATOM    392  OH  TYR    50      70.857  87.480 154.231  1.00 28.16           O  
ATOM    393  N   GLU    51      77.428  92.682 151.418  1.00 33.53           N  
ATOM    394  CA  GLU    51      78.585  93.579 151.337  1.00 35.20           C  
ATOM    395  C   GLU    51      78.158  95.036 151.106  1.00 35.05           C  
ATOM    396  O   GLU    51      78.655  95.949 151.784  1.00 35.18           O  
ATOM    397  CB  GLU    51      79.495  93.115 150.212  1.00 35.29           C  
ATOM    398  CG  GLU    51      80.946  93.479 150.349  1.00 40.27           C  
ATOM    399  CD  GLU    51      81.719  93.192 149.059  1.00 46.04           C  
ATOM    400  OE1 GLU    51      82.614  93.999 148.696  1.00 48.04           O  
ATOM    401  OE2 GLU    51      81.412  92.169 148.395  1.00 48.24           O  
ATOM    402  N   GLN    52      77.231  95.239 150.168  1.00 35.03           N  
ATOM    403  CA  GLN    52      76.595  96.549 149.922  1.00 35.53           C  
ATOM    404  C   GLN    52      75.787  97.080 151.117  1.00 34.17           C  
ATOM    405  O   GLN    52      75.843  98.253 151.428  1.00 33.89           O  
ATOM    406  CB  GLN    52      75.610  96.444 148.753  1.00 35.67           C  
ATOM    407  CG  GLN    52      76.161  96.623 147.348  1.00 38.30           C  
ATOM    408  CD  GLN    52      75.059  96.444 146.286  1.00 38.67           C  
ATOM    409  OE1 GLN    52      74.758  97.377 145.545  1.00 42.38           O  
ATOM    410  NE2 GLN    52      74.427  95.250 146.245  1.00 40.22           N  
ATOM    411  N   VAL    53      74.982  96.221 151.738  1.00 33.02           N  
ATOM    412  CA  VAL    53      74.032  96.657 152.756  1.00 31.77           C  
ATOM    413  C   VAL    53      74.734  96.975 154.079  1.00 31.61           C  
ATOM    414  O   VAL    53      74.300  97.863 154.814  1.00 31.13           O  
ATOM    415  CB  VAL    53      72.917  95.592 152.966  1.00 32.14           C  
ATOM    416  CG1 VAL    53      72.124  95.847 154.210  1.00 31.65           C  
ATOM    417  CG2 VAL    53      71.977  95.593 151.792  1.00 31.28           C  
ATOM    418  N   GLY    54      75.808  96.243 154.371  1.00 30.90           N  
ATOM    419  CA  GLY    54      76.457  96.317 155.683  1.00 31.39           C  
ATOM    420  C   GLY    54      75.587  95.602 156.690  1.00 31.14           C  
ATOM    421  O   GLY    54      74.890  94.655 156.324  1.00 32.58           O  
ATOM    422  N   LYS    55      75.583  96.063 157.935  1.00 30.24           N  
ATOM    423  CA  LYS    55      74.870  95.363 159.016  1.00 30.12           C  
ATOM    424  C   LYS    55      73.449  95.876 159.255  1.00 29.19           C  
ATOM    425  O   LYS    55      73.196  97.062 159.150  1.00 28.55           O  
ATOM    426  CB  LYS    55      75.681  95.401 160.335  1.00 30.87           C  
ATOM    427  CG  LYS    55      77.011  94.668 160.203  1.00 32.75           C  
ATOM    428  CD  LYS    55      77.630  94.306 161.510  1.00 38.98           C  
ATOM    429  CE  LYS    55      79.014  93.684 161.267  1.00 42.47           C  
ATOM    430  NZ  LYS    55      79.386  92.731 162.356  1.00 45.84           N  
ATOM    431  N   VAL    56      72.537  94.953 159.574  1.00 28.65           N  
ATOM    432  CA  VAL    56      71.131  95.280 159.860  1.00 27.78           C  
ATOM    433  C   VAL    56      70.663  94.563 161.118  1.00 27.25           C  
ATOM    434  O   VAL    56      71.383  93.736 161.658  1.00 26.65           O  
ATOM    435  CB  VAL    56      70.186  94.930 158.674  1.00 26.85           C  
ATOM    436  CG1 VAL    56      70.496  95.801 157.470  1.00 26.81           C  
ATOM    437  CG2 VAL    56      70.271  93.453 158.301  1.00 27.49           C  
ATOM    438  N   ASP    57      69.451  94.887 161.568  1.00 27.80           N  
ATOM    439  CA  ASP    57      68.850  94.240 162.733  1.00 27.89           C  
ATOM    440  C   ASP    57      67.907  93.094 162.380  1.00 28.18           C  
ATOM    441  O   ASP    57      67.706  92.209 163.204  1.00 28.86           O  
ATOM    442  CB  ASP    57      68.083  95.260 163.551  1.00 28.40           C  
ATOM    443  CG  ASP    57      68.963  96.391 163.998  1.00 31.59           C  
ATOM    444  OD1 ASP    57      68.652  97.551 163.631  1.00 36.21           O  
ATOM    445  OD2 ASP    57      69.999  96.108 164.654  1.00 32.98           O  
ATOM    446  N   ALA    58      67.310  93.117 161.190  1.00 27.40           N  
ATOM    447  CA  ALA    58      66.459  91.995 160.772  1.00 27.62           C  
ATOM    448  C   ALA    58      66.603  91.758 159.272  1.00 27.39           C  
ATOM    449  O   ALA    58      66.736  92.695 158.499  1.00 27.58           O  
ATOM    450  CB  ALA    58      64.995  92.232 161.156  1.00 26.95           C  
ATOM    451  N   ILE    59      66.623  90.492 158.885  1.00 27.49           N  
ATOM    452  CA  ILE    59      66.607  90.095 157.472  1.00 27.11           C  
ATOM    453  C   ILE    59      65.295  89.344 157.267  1.00 27.57           C  
ATOM    454  O   ILE    59      64.981  88.409 158.008  1.00 27.71           O  
ATOM    455  CB  ILE    59      67.840  89.222 157.126  1.00 27.27           C  
ATOM    456  CG1 ILE    59      69.127  90.078 157.261  1.00 26.57           C  
ATOM    457  CG2 ILE    59      67.715  88.626 155.703  1.00 24.63           C  
ATOM    458  CD1 ILE    59      70.394  89.295 157.412  1.00 26.03           C  
ATOM    459  N   VAL    60      64.493  89.826 156.326  1.00 28.08           N  
ATOM    460  CA  VAL    60      63.169  89.251 156.072  1.00 27.73           C  
ATOM    461  C   VAL    60      63.071  88.781 154.618  1.00 28.57           C  
ATOM    462  O   VAL    60      63.349  89.533 153.693  1.00 28.21           O  
ATOM    463  CB  VAL    60      62.067  90.264 156.378  1.00 27.44           C  
ATOM    464  CG1 VAL    60      60.679  89.721 155.932  1.00 27.80           C  
ATOM    465  CG2 VAL    60      62.092  90.646 157.886  1.00 26.89           C  
ATOM    466  N   SER    61      62.671  87.530 154.421  1.00 29.95           N  
ATOM    467  CA  SER    61      62.568  86.978 153.068  1.00 30.37           C  
ATOM    468  C   SER    61      61.116  86.686 152.779  1.00 31.23           C  
ATOM    469  O   SER    61      60.509  85.805 153.389  1.00 31.34           O  
ATOM    470  CB  SER    61      63.416  85.717 152.948  1.00 29.63           C  
ATOM    471  OG  SER    61      63.170  85.050 151.737  1.00 30.77           O  
ATOM    472  N   ALA    62      60.558  87.497 151.899  1.00 32.52           N  
ATOM    473  CA  ALA    62      59.273  87.253 151.277  1.00 33.81           C  
ATOM    474  C   ALA    62      59.503  86.978 149.782  1.00 34.83           C  
ATOM    475  O   ALA    62      58.849  87.562 148.909  1.00 35.84           O  
ATOM    476  CB  ALA    62      58.354  88.468 151.486  1.00 33.75           C  
ATOM    477  N   THR    63      60.475  86.117 149.494  1.00 35.60           N  
ATOM    478  CA  THR    63      60.778  85.681 148.124  1.00 37.14           C  
ATOM    479  C   THR    63      61.004  84.190 148.079  1.00 36.99           C  
ATOM    480  O   THR    63      60.865  83.493 149.086  1.00 37.39           O  
ATOM    481  CB  THR    63      62.093  86.266 147.543  1.00 37.08           C  
ATOM    482  OG1 THR    63      62.952  86.718 148.605  1.00 39.36           O  
ATOM    483  CG2 THR    63      61.825  87.333 146.527  1.00 37.63           C  
ATOM    484  N   GLY    64      61.408  83.735 146.897  1.00 37.22           N  
ATOM    485  CA  GLY    64      61.683  82.331 146.643  1.00 36.82           C  
ATOM    486  C   GLY    64      60.583  81.837 145.742  1.00 35.98           C  
ATOM    487  O   GLY    64      59.418  82.145 145.962  1.00 36.07           O  
ATOM    488  N   SER    65      60.939  81.100 144.707  1.00 35.86           N  
ATOM    489  CA  SER    65      59.905  80.462 143.920  1.00 35.87           C  
ATOM    490  C   SER    65      60.063  78.947 143.811  1.00 35.53           C  
ATOM    491  O   SER    65      61.174  78.383 143.968  1.00 34.12           O  
ATOM    492  CB  SER    65      59.684  81.168 142.565  1.00 36.59           C  
ATOM    493  OG  SER    65      60.868  81.261 141.797  1.00 39.05           O  
ATOM    494  N   ALA    66      58.916  78.301 143.633  1.00 35.28           N  
ATOM    495  CA  ALA    66      58.827  76.860 143.396  1.00 36.00           C  
ATOM    496  C   ALA    66      58.163  76.570 142.050  1.00 36.09           C  
ATOM    497  O   ALA    66      57.241  77.278 141.642  1.00 36.27           O  
ATOM    498  CB  ALA    66      58.027  76.190 144.525  1.00 36.26           C  
ATOM    499  N   THR    67      58.658  75.537 141.366  1.00 36.15           N  
ATOM    500  CA  THR    67      58.007  74.924 140.217  1.00 35.80           C  
ATOM    501  C   THR    67      56.640  74.362 140.623  1.00 35.12           C  
ATOM    502  O   THR    67      56.534  73.695 141.632  1.00 33.77           O  
ATOM    503  CB  THR    67      58.855  73.723 139.720  1.00 35.97           C  
ATOM    504  OG1 THR    67      60.120  74.176 139.214  1.00 37.36           O  
ATOM    505  CG2 THR    67      58.142  72.977 138.614  1.00 37.64           C  
ATOM    506  N   PHE    68      55.599  74.641 139.838  1.00 35.09           N  
ATOM    507  CA  PHE    68      54.312  73.933 139.978  1.00 34.98           C  
ATOM    508  C   PHE    68      54.224  72.974 138.822  1.00 33.96           C  
ATOM    509  O   PHE    68      54.343  73.385 137.669  1.00 33.07           O  
ATOM    510  CB  PHE    68      53.132  74.902 139.924  1.00 36.51           C  
ATOM    511  CG  PHE    68      52.751  75.477 141.250  1.00 40.26           C  
ATOM    512  CD1 PHE    68      53.709  75.705 142.245  1.00 43.38           C  
ATOM    513  CD2 PHE    68      51.424  75.816 141.505  1.00 44.04           C  
ATOM    514  CE1 PHE    68      53.346  76.253 143.487  1.00 45.21           C  
ATOM    515  CE2 PHE    68      51.047  76.360 142.725  1.00 43.90           C  
ATOM    516  CZ  PHE    68      52.009  76.580 143.724  1.00 43.50           C  
ATOM    517  N   SER    69      54.054  71.691 139.121  1.00 32.62           N  
ATOM    518  CA  SER    69      54.065  70.663 138.087  1.00 31.53           C  
ATOM    519  C   SER    69      53.362  69.406 138.586  1.00 30.99           C  
ATOM    520  O   SER    69      53.619  68.991 139.713  1.00 30.87           O  
ATOM    521  CB  SER    69      55.518  70.330 137.748  1.00 31.58           C  
ATOM    522  OG  SER    69      55.631  69.135 137.004  1.00 33.02           O  
ATOM    523  N   PRO    70      52.533  68.755 137.734  1.00 30.90           N  
ATOM    524  CA  PRO    70      51.981  67.455 138.136  1.00 30.68           C  
ATOM    525  C   PRO    70      53.160  66.574 138.537  1.00 30.72           C  
ATOM    526  O   PRO    70      54.210  66.631 137.880  1.00 30.60           O  
ATOM    527  CB  PRO    70      51.361  66.918 136.839  1.00 30.70           C  
ATOM    528  CG  PRO    70      51.105  68.137 135.992  1.00 30.49           C  
ATOM    529  CD  PRO    70      52.158  69.121 136.349  1.00 30.41           C  
ATOM    530  N   LEU    71      53.015  65.798 139.606  1.00 30.90           N  
ATOM    531  CA  LEU    71      54.097  64.924 140.113  1.00 31.49           C  
ATOM    532  C   LEU    71      54.744  64.086 139.017  1.00 31.74           C  
ATOM    533  O   LEU    71      55.959  63.940 138.922  1.00 32.18           O  
ATOM    534  CB  LEU    71      53.545  63.993 141.186  1.00 30.66           C  
ATOM    535  CG  LEU    71      54.503  62.961 141.788  1.00 31.94           C  
ATOM    536  CD1 LEU    71      55.565  63.600 142.665  1.00 30.84           C  
ATOM    537  CD2 LEU    71      53.683  61.964 142.612  1.00 32.08           C  
ATOM    538  N   THR    72      53.887  63.553 138.173  1.00 32.64           N  
ATOM    539  CA  THR    72      54.258  62.726 137.060  1.00 33.06           C  
ATOM    540  C   THR    72      55.042  63.486 135.965  1.00 32.56           C  
ATOM    541  O   THR    72      55.696  62.858 135.127  1.00 32.65           O  
ATOM    542  CB  THR    72      52.957  62.015 136.616  1.00 33.40           C  
ATOM    543  OG1 THR    72      52.720  60.934 137.547  1.00 36.49           O  
ATOM    544  CG2 THR    72      53.013  61.504 135.252  1.00 34.96           C  
ATOM    545  N   GLU    73      55.021  64.826 136.015  1.00 31.73           N  
ATOM    546  CA  GLU    73      55.843  65.673 135.120  1.00 31.59           C  
ATOM    547  C   GLU    73      56.975  66.381 135.861  1.00 29.95           C  
ATOM    548  O   GLU    73      57.780  67.069 135.254  1.00 30.07           O  
ATOM    549  CB  GLU    73      54.987  66.697 134.383  1.00 31.08           C  
ATOM    550  CG  GLU    73      53.937  66.051 133.505  1.00 35.57           C  
ATOM    551  CD  GLU    73      53.010  67.061 132.838  1.00 41.39           C  
ATOM    552  OE1 GLU    73      51.892  66.651 132.444  1.00 44.05           O  
ATOM    553  OE2 GLU    73      53.390  68.255 132.707  1.00 43.21           O  
ATOM    554  N   LEU    74      57.016  66.198 137.174  1.00 28.83           N  
ATOM    555  CA  LEU    74      58.048  66.789 138.039  1.00 27.67           C  
ATOM    556  C   LEU    74      59.365  66.013 137.915  1.00 27.27           C  
ATOM    557  O   LEU    74      59.589  65.029 138.629  1.00 26.82           O  
ATOM    558  CB  LEU    74      57.563  66.810 139.505  1.00 26.60           C  
ATOM    559  CG  LEU    74      58.449  67.428 140.613  1.00 27.55           C  
ATOM    560  CD1 LEU    74      58.978  68.823 140.266  1.00 24.85           C  
ATOM    561  CD2 LEU    74      57.707  67.474 141.970  1.00 26.28           C  
ATOM    562  N   THR    75      60.223  66.450 137.000  1.00 26.79           N  
ATOM    563  CA  THR    75      61.547  65.835 136.829  1.00 26.48           C  
ATOM    564  C   THR    75      62.536  66.357 137.851  1.00 26.20           C  
ATOM    565  O   THR    75      62.317  67.418 138.433  1.00 26.47           O  
ATOM    566  CB  THR    75      62.153  66.120 135.444  1.00 26.52           C  
ATOM    567  OG1 THR    75      62.149  67.524 135.223  1.00 24.43           O  
ATOM    568  CG2 THR    75      61.344  65.450 134.358  1.00 26.42           C  
ATOM    569  N   PRO    76      63.640  65.611 138.079  1.00 26.32           N  
ATOM    570  CA  PRO    76      64.732  66.158 138.892  1.00 26.02           C  
ATOM    571  C   PRO    76      65.150  67.551 138.406  1.00 25.77           C  
ATOM    572  O   PRO    76      65.433  68.419 139.235  1.00 25.48           O  
ATOM    573  CB  PRO    76      65.873  65.155 138.684  1.00 26.18           C  
ATOM    574  CG  PRO    76      65.168  63.840 138.414  1.00 26.15           C  
ATOM    575  CD  PRO    76      63.933  64.241 137.599  1.00 26.60           C  
ATOM    576  N   GLU    77      65.167  67.769 137.088  1.00 24.97           N  
ATOM    577  CA  GLU    77      65.473  69.095 136.543  1.00 25.17           C  
ATOM    578  C   GLU    77      64.515  70.192 137.009  1.00 25.61           C  
ATOM    579  O   GLU    77      64.957  71.254 137.446  1.00 24.80           O  
ATOM    580  CB  GLU    77      65.573  69.074 135.022  1.00 24.98           C  
ATOM    581  CG  GLU    77      66.775  68.319 134.524  1.00 25.56           C  
ATOM    582  CD  GLU    77      66.472  66.868 134.177  1.00 28.15           C  
ATOM    583  OE1 GLU    77      65.548  66.240 134.766  1.00 26.20           O  
ATOM    584  OE2 GLU    77      67.191  66.348 133.297  1.00 31.05           O  
ATOM    585  N   LYS    78      63.217  69.926 136.928  1.00 26.16           N  
ATOM    586  CA  LYS    78      62.196  70.873 137.404  1.00 27.26           C  
ATOM    587  C   LYS    78      62.325  71.088 138.896  1.00 26.94           C  
ATOM    588  O   LYS    78      62.309  72.231 139.351  1.00 26.88           O  
ATOM    589  CB  LYS    78      60.777  70.383 137.083  1.00 27.15           C  
ATOM    590  CG  LYS    78      60.290  70.681 135.659  1.00 30.35           C  
ATOM    591  CD  LYS    78      58.816  70.209 135.530  1.00 29.14           C  
ATOM    592  CE  LYS    78      57.998  70.960 134.498  1.00 34.52           C  
ATOM    593  NZ  LYS    78      56.547  70.486 134.496  1.00 34.23           N  
ATOM    594  N   ASN    79      62.452  69.996 139.660  1.00 27.20           N  
ATOM    595  CA  ASN    79      62.626  70.085 141.123  1.00 26.73           C  
ATOM    596  C   ASN    79      63.874  70.869 141.548  1.00 26.65           C  
ATOM    597  O   ASN    79      63.895  71.491 142.613  1.00 26.71           O  
ATOM    598  CB  ASN    79      62.610  68.682 141.738  1.00 27.21           C  
ATOM    599  CG  ASN    79      62.160  68.676 143.178  1.00 28.62           C  
ATOM    600  OD1 ASN    79      62.779  68.024 144.018  1.00 33.29           O  
ATOM    601  ND2 ASN    79      61.090  69.383 143.475  1.00 26.18           N  
ATOM    602  N   ALA    80      64.903  70.878 140.694  1.00 26.39           N  
ATOM    603  CA  ALA    80      66.127  71.656 140.955  1.00 25.89           C  
ATOM    604  C   ALA    80      65.910  73.174 140.911  1.00 25.82           C  
ATOM    605  O   ALA    80      66.600  73.918 141.590  1.00 25.69           O  
ATOM    606  CB  ALA    80      67.297  71.226 140.000  1.00 25.06           C  
ATOM    607  N   VAL    81      64.923  73.623 140.151  1.00 25.68           N  
ATOM    608  CA  VAL    81      64.539  75.035 140.159  1.00 25.94           C  
ATOM    609  C   VAL    81      64.059  75.469 141.558  1.00 25.91           C  
ATOM    610  O   VAL    81      64.607  76.405 142.135  1.00 26.06           O  
ATOM    611  CB  VAL    81      63.479  75.350 139.066  1.00 26.11           C  
ATOM    612  CG1 VAL    81      63.002  76.785 139.182  1.00 26.25           C  
ATOM    613  CG2 VAL    81      64.054  75.092 137.656  1.00 26.72           C  
ATOM    614  N   THR    82      63.066  74.778 142.110  1.00 25.85           N  
ATOM    615  CA  THR    82      62.599  75.042 143.478  1.00 26.11           C  
ATOM    616  C   THR    82      63.733  75.033 144.503  1.00 26.87           C  
ATOM    617  O   THR    82      63.779  75.891 145.402  1.00 28.39           O  
ATOM    618  CB  THR    82      61.551  73.991 143.906  1.00 26.20           C  
ATOM    619  OG1 THR    82      60.541  73.893 142.889  1.00 26.44           O  
ATOM    620  CG2 THR    82      60.895  74.359 145.221  1.00 23.76           C  
ATOM    621  N   ILE    83      64.611  74.038 144.385  1.00 26.79           N  
ATOM    622  CA  ILE    83      65.729  73.837 145.289  1.00 27.08           C  
ATOM    623  C   ILE    83      66.688  75.029 145.286  1.00 27.28           C  
ATOM    624  O   ILE    83      67.136  75.493 146.357  1.00 27.62           O  
ATOM    625  CB  ILE    83      66.471  72.481 144.992  1.00 27.10           C  
ATOM    626  CG1 ILE    83      65.593  71.310 145.480  1.00 26.85           C  
ATOM    627  CG2 ILE    83      67.847  72.444 145.690  1.00 26.25           C  
ATOM    628  CD1 ILE    83      66.019  69.878 144.998  1.00 28.20           C  
ATOM    629  N   SER    84      66.936  75.567 144.100  1.00 27.43           N  
ATOM    630  CA  SER    84      67.817  76.732 143.953  1.00 27.65           C  
ATOM    631  C   SER    84      67.198  78.043 144.460  1.00 27.57           C  
ATOM    632  O   SER    84      67.926  79.009 144.737  1.00 28.54           O  
ATOM    633  CB  SER    84      68.244  76.883 142.486  1.00 27.23           C  
ATOM    634  OG  SER    84      67.200  77.441 141.728  1.00 27.53           O  
ATOM    635  N   SER    85      65.873  78.094 144.574  1.00 27.44           N  
ATOM    636  CA  SER    85      65.181  79.354 144.869  1.00 27.45           C  
ATOM    637  C   SER    85      64.446  79.349 146.211  1.00 27.88           C  
ATOM    638  O   SER    85      65.037  79.680 147.229  1.00 28.39           O  
ATOM    639  CB  SER    85      64.247  79.767 143.720  1.00 27.61           C  
ATOM    640  OG  SER    85      63.509  80.937 144.072  1.00 26.70           O  
ATOM    641  N   LYS    86      63.172  78.968 146.219  1.00 27.88           N  
ATOM    642  CA  LYS    86      62.366  78.895 147.467  1.00 28.51           C  
ATOM    643  C   LYS    86      63.087  78.216 148.624  1.00 28.64           C  
ATOM    644  O   LYS    86      62.995  78.643 149.788  1.00 28.02           O  
ATOM    645  CB  LYS    86      61.045  78.147 147.211  1.00 29.14           C  
ATOM    646  CG  LYS    86      60.010  78.236 148.382  1.00 30.48           C  
ATOM    647  CD  LYS    86      59.167  79.482 148.254  1.00 34.46           C  
ATOM    648  CE  LYS    86      58.569  79.951 149.569  1.00 34.96           C  
ATOM    649  NZ  LYS    86      57.220  79.357 149.728  1.00 31.88           N  
ATOM    650  N   LEU    87      63.776  77.129 148.302  1.00 29.57           N  
ATOM    651  CA  LEU    87      64.456  76.314 149.306  1.00 29.64           C  
ATOM    652  C   LEU    87      65.875  76.830 149.556  1.00 30.00           C  
ATOM    653  O   LEU    87      66.131  77.502 150.566  1.00 30.14           O  
ATOM    654  CB  LEU    87      64.463  74.841 148.877  1.00 29.27           C  
ATOM    655  CG  LEU    87      64.831  73.748 149.902  1.00 30.59           C  
ATOM    656  CD1 LEU    87      64.349  72.366 149.404  1.00 32.32           C  
ATOM    657  CD2 LEU    87      66.311  73.696 150.247  1.00 32.75           C  
ATOM    658  N   GLY    88      66.780  76.532 148.624  1.00 30.59           N  
ATOM    659  CA  GLY    88      68.199  76.853 148.761  1.00 31.07           C  
ATOM    660  C   GLY    88      68.492  78.326 148.872  1.00 31.31           C  
ATOM    661  O   GLY    88      69.367  78.713 149.633  1.00 32.61           O  
ATOM    662  N   GLY    89      67.767  79.137 148.103  1.00 31.02           N  
ATOM    663  CA  GLY    89      67.925  80.580 148.092  1.00 29.84           C  
ATOM    664  C   GLY    89      67.605  81.191 149.436  1.00 30.31           C  
ATOM    665  O   GLY    89      68.421  81.922 149.978  1.00 30.30           O  
ATOM    666  N   GLN    90      66.437  80.866 149.992  1.00 29.06           N  
ATOM    667  CA  GLN    90      66.097  81.319 151.347  1.00 29.14           C  
ATOM    668  C   GLN    90      67.073  80.842 152.433  1.00 28.89           C  
ATOM    669  O   GLN    90      67.494  81.635 153.287  1.00 29.66           O  
ATOM    670  CB  GLN    90      64.652  80.933 151.700  1.00 28.34           C  
ATOM    671  CG  GLN    90      63.610  81.768 150.939  1.00 28.39           C  
ATOM    672  CD  GLN    90      62.258  81.727 151.609  1.00 29.55           C  
ATOM    673  OE1 GLN    90      61.856  82.694 152.264  1.00 30.50           O  
ATOM    674  NE2 GLN    90      61.548  80.597 151.470  1.00 26.71           N  
ATOM    675  N   ILE    91      67.427  79.558 152.416  1.00 28.75           N  
ATOM    676  CA  ILE    91      68.419  79.035 153.371  1.00 28.76           C  
ATOM    677  C   ILE    91      69.764  79.763 153.227  1.00 28.01           C  
ATOM    678  O   ILE    91      70.419  80.073 154.235  1.00 28.41           O  
ATOM    679  CB  ILE    91      68.664  77.501 153.248  1.00 29.14           C  
ATOM    680  CG1 ILE    91      67.356  76.678 153.259  1.00 31.79           C  
ATOM    681  CG2 ILE    91      69.675  77.016 154.299  1.00 28.95           C  
ATOM    682  CD1 ILE    91      66.668  76.636 154.480  1.00 29.78           C  
ATOM    683  N   ASN    92      70.181  80.042 151.988  1.00 27.06           N  
ATOM    684  CA  ASN    92      71.444  80.743 151.772  1.00 27.02           C  
ATOM    685  C   ASN    92      71.465  82.161 152.266  1.00 26.98           C  
ATOM    686  O   ASN    92      72.519  82.643 152.684  1.00 27.44           O  
ATOM    687  CB  ASN    92      71.914  80.662 150.315  1.00 26.86           C  
ATOM    688  CG  ASN    92      72.399  79.283 149.961  1.00 26.96           C  
ATOM    689  OD1 ASN    92      72.732  78.520 150.851  1.00 27.06           O  
ATOM    690  ND2 ASN    92      72.416  78.940 148.663  1.00 25.66           N  
ATOM    691  N   LEU    93      70.324  82.845 152.219  1.00 26.76           N  
ATOM    692  CA  LEU    93      70.257  84.163 152.830  1.00 26.77           C  
ATOM    693  C   LEU    93      70.639  84.071 154.305  1.00 27.03           C  
ATOM    694  O   LEU    93      71.293  84.979 154.819  1.00 27.41           O  
ATOM    695  CB  LEU    93      68.875  84.789 152.669  1.00 27.04           C  
ATOM    696  CG  LEU    93      68.462  85.196 151.250  1.00 25.94           C  
ATOM    697  CD1 LEU    93      67.011  85.533 151.231  1.00 25.95           C  
ATOM    698  CD2 LEU    93      69.290  86.389 150.729  1.00 25.48           C  
ATOM    699  N   VAL    94      70.288  82.962 154.959  1.00 26.50           N  
ATOM    700  CA  VAL    94      70.625  82.762 156.389  1.00 26.28           C  
ATOM    701  C   VAL    94      72.090  82.396 156.583  1.00 26.41           C  
ATOM    702  O   VAL    94      72.800  83.051 157.352  1.00 27.38           O  
ATOM    703  CB  VAL    94      69.722  81.714 157.090  1.00 26.49           C  
ATOM    704  CG1 VAL    94      70.141  81.549 158.592  1.00 26.24           C  
ATOM    705  CG2 VAL    94      68.236  82.109 156.983  1.00 26.22           C  
ATOM    706  N   LEU    95      72.568  81.381 155.869  1.00 26.02           N  
ATOM    707  CA  LEU    95      73.964  80.967 156.006  1.00 26.29           C  
ATOM    708  C   LEU    95      74.968  82.068 155.582  1.00 26.53           C  
ATOM    709  O   LEU    95      76.086  82.108 156.090  1.00 26.46           O  
ATOM    710  CB  LEU    95      74.259  79.694 155.204  1.00 25.49           C  
ATOM    711  CG  LEU    95      73.319  78.503 155.339  1.00 25.72           C  
ATOM    712  CD1 LEU    95      73.702  77.432 154.329  1.00 24.65           C  
ATOM    713  CD2 LEU    95      73.328  77.962 156.828  1.00 26.36           C  
ATOM    714  N   LEU    96      74.567  82.949 154.661  1.00 26.05           N  
ATOM    715  CA  LEU    96      75.457  84.036 154.254  1.00 25.87           C  
ATOM    716  C   LEU    96      75.225  85.338 155.022  1.00 26.07           C  
ATOM    717  O   LEU    96      75.962  86.310 154.847  1.00 25.26           O  
ATOM    718  CB  LEU    96      75.373  84.260 152.743  1.00 24.41           C  
ATOM    719  CG  LEU    96      75.816  83.071 151.886  1.00 25.07           C  
ATOM    720  CD1 LEU    96      75.501  83.358 150.389  1.00 25.66           C  
ATOM    721  CD2 LEU    96      77.307  82.737 152.077  1.00 26.31           C  
ATOM    722  N   GLY    97      74.202  85.348 155.870  1.00 26.63           N  
ATOM    723  CA  GLY    97      73.707  86.574 156.460  1.00 27.76           C  
ATOM    724  C   GLY    97      73.912  86.744 157.953  1.00 29.04           C  
ATOM    725  O   GLY    97      73.792  87.853 158.453  1.00 29.23           O  
ATOM    726  N   ILE    98      74.214  85.663 158.671  1.00 30.03           N  
ATOM    727  CA  ILE    98      74.404  85.732 160.136  1.00 30.69           C  
ATOM    728  C   ILE    98      75.422  86.841 160.506  1.00 31.11           C  
ATOM    729  O   ILE    98      75.172  87.668 161.401  1.00 31.16           O  
ATOM    730  CB  ILE    98      74.832  84.352 160.720  1.00 30.38           C  
ATOM    731  CG1 ILE    98      73.669  83.339 160.651  1.00 32.15           C  
ATOM    732  CG2 ILE    98      75.336  84.480 162.173  1.00 32.07           C  
ATOM    733  CD1 ILE    98      74.129  81.852 160.633  1.00 30.74           C  
ATOM    734  N   ASP    99      76.553  86.851 159.804  1.00 31.56           N  
ATOM    735  CA  ASP    99      77.611  87.856 160.001  1.00 32.42           C  
ATOM    736  C   ASP    99      77.161  89.290 159.705  1.00 31.42           C  
ATOM    737  O   ASP    99      77.771  90.244 160.178  1.00 31.67           O  
ATOM    738  CB  ASP    99      78.826  87.516 159.132  1.00 33.58           C  
ATOM    739  CG  ASP    99      79.685  86.382 159.717  1.00 37.44           C  
ATOM    740  OD1 ASP    99      79.584  86.099 160.944  1.00 39.04           O  
ATOM    741  OD2 ASP    99      80.472  85.786 158.927  1.00 41.53           O  
ATOM    742  N   SER   100      76.083  89.434 158.943  1.00 30.23           N  
ATOM    743  CA  SER   100      75.492  90.737 158.682  1.00 29.66           C  
ATOM    744  C   SER   100      74.395  91.160 159.674  1.00 29.81           C  
ATOM    745  O   SER   100      73.822  92.222 159.511  1.00 31.57           O  
ATOM    746  CB  SER   100      74.931  90.788 157.253  1.00 29.18           C  
ATOM    747  OG  SER   100      75.976  90.695 156.306  1.00 28.62           O  
ATOM    748  N   LEU   101      74.086  90.354 160.681  1.00 28.76           N  
ATOM    749  CA  LEU   101      73.079  90.746 161.664  1.00 28.40           C  
ATOM    750  C   LEU   101      73.696  91.267 162.957  1.00 28.66           C  
ATOM    751  O   LEU   101      74.635  90.651 163.500  1.00 27.21           O  
ATOM    752  CB  LEU   101      72.163  89.572 162.015  1.00 28.12           C  
ATOM    753  CG  LEU   101      70.907  89.290 161.195  1.00 27.99           C  
ATOM    754  CD1 LEU   101      70.125  88.202 161.924  1.00 27.76           C  
ATOM    755  CD2 LEU   101      70.047  90.522 161.030  1.00 28.00           C  
ATOM    756  N   ASN   102      73.156  92.379 163.463  1.00 28.81           N  
ATOM    757  CA  ASN   102      73.526  92.854 164.801  1.00 29.36           C  
ATOM    758  C   ASN   102      73.030  91.901 165.893  1.00 29.27           C  
ATOM    759  O   ASN   102      72.095  91.126 165.672  1.00 28.85           O  
ATOM    760  CB  ASN   102      72.944  94.240 165.069  1.00 30.11           C  
ATOM    761  CG  ASN   102      73.452  95.300 164.094  1.00 32.51           C  
ATOM    762  OD1 ASN   102      74.610  95.259 163.637  1.00 34.10           O  
ATOM    763  ND2 ASN   102      72.593  96.276 163.793  1.00 30.65           N  
ATOM    764  N   ASP   103      73.643  91.984 167.072  1.00 29.21           N  
ATOM    765  CA  ASP   103      73.211  91.216 168.239  1.00 29.76           C  
ATOM    766  C   ASP   103      71.707  91.332 168.435  1.00 29.57           C  
ATOM    767  O   ASP   103      71.155  92.410 168.269  1.00 29.00           O  
ATOM    768  CB  ASP   103      73.897  91.757 169.505  1.00 29.66           C  
ATOM    769  CG  ASP   103      75.411  91.637 169.453  1.00 31.57           C  
ATOM    770  OD1 ASP   103      76.080  91.996 170.460  1.00 36.18           O  
ATOM    771  OD2 ASP   103      75.934  91.162 168.426  1.00 30.89           O  
ATOM    772  N   LYS   104      71.074  90.231 168.850  1.00 30.49           N  
ATOM    773  CA  LYS   104      69.618  90.156 169.117  1.00 30.56           C  
ATOM    774  C   LYS   104      68.788  90.410 167.845  1.00 29.55           C  
ATOM    775  O   LYS   104      67.591  90.683 167.922  1.00 28.41           O  
ATOM    776  CB  LYS   104      69.181  91.093 170.277  1.00 32.09           C  
ATOM    777  CG  LYS   104      69.681  90.720 171.720  1.00 34.10           C  
ATOM    778  CD  LYS   104      68.699  89.710 172.415  1.00 39.98           C  
ATOM    779  CE  LYS   104      69.035  89.366 173.903  1.00 41.01           C  
ATOM    780  NZ  LYS   104      70.146  88.351 174.163  1.00 45.27           N  
ATOM    781  N   GLY   105      69.441  90.307 166.684  1.00 29.04           N  
ATOM    782  CA  GLY   105      68.789  90.467 165.385  1.00 28.30           C  
ATOM    783  C   GLY   105      67.854  89.312 165.094  1.00 28.17           C  
ATOM    784  O   GLY   105      67.672  88.410 165.939  1.00 28.00           O  
ATOM    785  N   SER   106      67.245  89.325 163.911  1.00 27.25           N  
ATOM    786  CA  SER   106      66.358  88.232 163.520  1.00 26.99           C  
ATOM    787  C   SER   106      66.375  87.930 162.012  1.00 27.04           C  
ATOM    788  O   SER   106      66.676  88.809 161.188  1.00 27.12           O  
ATOM    789  CB  SER   106      64.929  88.520 163.975  1.00 27.32           C  
ATOM    790  OG  SER   106      64.314  89.454 163.114  1.00 25.57           O  
ATOM    791  N   PHE   107      66.101  86.668 161.678  1.00 26.57           N  
ATOM    792  CA  PHE   107      65.713  86.245 160.324  1.00 25.77           C  
ATOM    793  C   PHE   107      64.216  85.882 160.327  1.00 25.99           C  
ATOM    794  O   PHE   107      63.696  85.319 161.316  1.00 25.67           O  
ATOM    795  CB  PHE   107      66.463  84.980 159.888  1.00 25.17           C  
ATOM    796  CG  PHE   107      67.943  85.148 159.704  1.00 24.98           C  
ATOM    797  CD1 PHE   107      68.455  85.707 158.532  1.00 26.78           C  
ATOM    798  CD2 PHE   107      68.836  84.699 160.700  1.00 24.95           C  
ATOM    799  CE1 PHE   107      69.850  85.859 158.350  1.00 26.97           C  
ATOM    800  CE2 PHE   107      70.224  84.857 160.554  1.00 27.03           C  
ATOM    801  CZ  PHE   107      70.736  85.433 159.357  1.00 26.65           C  
ATOM    802  N   THR   108      63.527  86.170 159.221  1.00 25.06           N  
ATOM    803  CA  THR   108      62.152  85.716 159.035  1.00 25.07           C  
ATOM    804  C   THR   108      62.024  85.236 157.613  1.00 25.47           C  
ATOM    805  O   THR   108      62.214  86.005 156.681  1.00 27.31           O  
ATOM    806  CB  THR   108      61.134  86.836 159.278  1.00 24.34           C  
ATOM    807  OG1 THR   108      61.396  87.412 160.564  1.00 25.14           O  
ATOM    808  CG2 THR   108      59.674  86.280 159.281  1.00 22.40           C  
ATOM    809  N   LEU   109      61.666  83.979 157.444  1.00 27.11           N  
ATOM    810  CA  LEU   109      61.626  83.354 156.112  1.00 28.52           C  
ATOM    811  C   LEU   109      60.178  83.004 155.785  1.00 28.63           C  
ATOM    812  O   LEU   109      59.371  82.881 156.700  1.00 29.01           O  
ATOM    813  CB  LEU   109      62.494  82.091 156.133  1.00 29.08           C  
ATOM    814  CG  LEU   109      64.000  82.057 155.795  1.00 30.85           C  
ATOM    815  CD1 LEU   109      64.689  83.338 156.038  1.00 30.71           C  
ATOM    816  CD2 LEU   109      64.744  80.907 156.480  1.00 29.65           C  
ATOM    817  N   THR   110      59.853  82.827 154.499  1.00 28.09           N  
ATOM    818  CA  THR   110      58.492  82.482 154.068  1.00 28.41           C  
ATOM    819  C   THR   110      58.332  81.000 153.665  1.00 28.40           C  
ATOM    820  O   THR   110      59.138  80.471 152.891  1.00 28.54           O  
ATOM    821  CB  THR   110      58.048  83.366 152.861  1.00 28.39           C  
ATOM    822  OG1 THR   110      58.126  84.735 153.251  1.00 30.95           O  
ATOM    823  CG2 THR   110      56.624  83.067 152.455  1.00 27.86           C  
ATOM    824  N   THR   111      57.293  80.336 154.185  1.00 28.30           N  
ATOM    825  CA  THR   111      57.019  78.948 153.815  1.00 27.25           C  
ATOM    826  C   THR   111      55.667  78.887 153.103  1.00 27.90           C  
ATOM    827  O   THR   111      55.539  79.433 152.004  1.00 27.18           O  
ATOM    828  CB  THR   111      57.142  77.948 155.011  1.00 27.87           C  
ATOM    829  OG1 THR   111      56.303  78.347 156.095  1.00 27.34           O  
ATOM    830  CG2 THR   111      58.595  77.874 155.522  1.00 27.01           C  
ATOM    831  N   GLY   112      54.660  78.250 153.704  1.00 27.83           N  
ATOM    832  CA  GLY   112      53.378  78.088 153.002  1.00 28.14           C  
ATOM    833  C   GLY   112      52.584  76.853 153.361  1.00 27.55           C  
ATOM    834  O   GLY   112      53.152  75.810 153.713  1.00 28.59           O  
ATOM    835  N   ILE   113      51.261  76.999 153.276  1.00 27.70           N  
ATOM    836  CA  ILE   113      50.273  75.982 153.622  1.00 28.07           C  
ATOM    837  C   ILE   113      50.415  74.626 152.894  1.00 28.92           C  
ATOM    838  O   ILE   113      50.069  73.603 153.449  1.00 29.77           O  
ATOM    839  CB  ILE   113      48.812  76.535 153.438  1.00 27.86           C  
ATOM    840  CG1 ILE   113      47.809  75.673 154.245  1.00 27.79           C  
ATOM    841  CG2 ILE   113      48.448  76.666 151.929  1.00 25.50           C  
ATOM    842  CD1 ILE   113      46.405  76.294 154.400  1.00 27.83           C  
ATOM    843  N   MET   114      50.947  74.622 151.680  1.00 29.93           N  
ATOM    844  CA  MET   114      51.113  73.383 150.894  1.00 32.78           C  
ATOM    845  C   MET   114      51.845  72.241 151.580  1.00 32.46           C  
ATOM    846  O   MET   114      51.562  71.068 151.319  1.00 33.47           O  
ATOM    847  CB  MET   114      51.745  73.691 149.542  1.00 32.06           C  
ATOM    848  CG  MET   114      50.756  74.361 148.626  1.00 33.19           C  
ATOM    849  SD  MET   114      51.529  74.649 146.886  0.60 39.28          SE  
ATOM    850  CE  MET   114      52.049  76.420 147.086  1.00 26.65           C  
ATOM    851  N   MET   115      52.763  72.565 152.477  1.00 32.63           N  
ATOM    852  CA  MET   115      53.460  71.544 153.207  1.00 34.07           C  
ATOM    853  C   MET   115      52.487  70.799 154.130  1.00 34.16           C  
ATOM    854  O   MET   115      52.763  69.661 154.538  1.00 34.36           O  
ATOM    855  CB  MET   115      54.597  72.163 154.029  1.00 33.63           C  
ATOM    856  CG  MET   115      54.129  72.973 155.206  1.00 33.93           C  
ATOM    857  SD  MET   115      55.632  73.646 156.231  0.70 37.96          SE  
ATOM    858  CE  MET   115      54.615  74.982 157.229  1.00 33.39           C  
ATOM    859  N   GLU   116      51.368  71.465 154.448  1.00 34.23           N  
ATOM    860  CA  GLU   116      50.374  71.017 155.446  1.00 34.85           C  
ATOM    861  C   GLU   116      49.034  70.565 154.824  1.00 33.35           C  
ATOM    862  O   GLU   116      48.345  69.685 155.347  1.00 33.07           O  
ATOM    863  CB  GLU   116      50.092  72.192 156.397  1.00 35.66           C  
ATOM    864  CG  GLU   116      49.267  71.846 157.592  1.00 43.32           C  
ATOM    865  CD  GLU   116      50.134  71.435 158.769  1.00 52.53           C  
ATOM    866  OE1 GLU   116      49.796  71.837 159.913  1.00 55.85           O  
ATOM    867  OE2 GLU   116      51.173  70.747 158.543  1.00 55.65           O  
ATOM    868  N   ASP   117      48.649  71.211 153.728  1.00 31.58           N  
ATOM    869  CA  ASP   117      47.341  71.016 153.122  1.00 29.98           C  
ATOM    870  C   ASP   117      47.644  70.899 151.625  1.00 30.10           C  
ATOM    871  O   ASP   117      47.528  71.900 150.882  1.00 29.37           O  
ATOM    872  CB  ASP   117      46.499  72.252 153.449  1.00 30.25           C  
ATOM    873  CG  ASP   117      45.029  72.065 153.194  1.00 30.32           C  
ATOM    874  OD1 ASP   117      44.657  71.195 152.386  1.00 32.67           O  
ATOM    875  OD2 ASP   117      44.237  72.818 153.797  1.00 31.54           O  
ATOM    876  N   PRO   118      48.128  69.711 151.191  1.00 29.23           N  
ATOM    877  CA  PRO   118      48.691  69.577 149.835  1.00 29.07           C  
ATOM    878  C   PRO   118      47.689  69.646 148.678  1.00 28.01           C  
ATOM    879  O   PRO   118      46.520  69.288 148.835  1.00 27.34           O  
ATOM    880  CB  PRO   118      49.389  68.206 149.868  1.00 29.33           C  
ATOM    881  CG  PRO   118      48.718  67.448 150.938  1.00 29.37           C  
ATOM    882  CD  PRO   118      48.186  68.436 151.943  1.00 29.96           C  
ATOM    883  N   ILE   119      48.173  70.111 147.528  1.00 28.08           N  
ATOM    884  CA  ILE   119      47.369  70.257 146.313  1.00 26.60           C  
ATOM    885  C   ILE   119      48.086  69.559 145.161  1.00 27.24           C  
ATOM    886  O   ILE   119      49.309  69.308 145.217  1.00 26.94           O  
ATOM    887  CB  ILE   119      47.125  71.776 145.950  1.00 27.72           C  
ATOM    888  CG1 ILE   119      48.452  72.559 145.871  1.00 27.60           C  
ATOM    889  CG2 ILE   119      46.230  72.439 146.978  1.00 26.14           C  
ATOM    890  CD1 ILE   119      48.447  73.728 144.818  1.00 25.37           C  
ATOM    891  N   VAL   120      47.337  69.227 144.116  1.00 26.98           N  
ATOM    892  CA  VAL   120      47.945  68.699 142.901  1.00 27.63           C  
ATOM    893  C   VAL   120      48.863  69.782 142.296  1.00 27.90           C  
ATOM    894  O   VAL   120      48.525  70.965 142.309  1.00 27.91           O  
ATOM    895  CB  VAL   120      46.881  68.252 141.883  1.00 27.36           C  
ATOM    896  CG1 VAL   120      47.531  67.905 140.545  1.00 28.60           C  
ATOM    897  CG2 VAL   120      46.073  67.076 142.436  1.00 27.22           C  
ATOM    898  N   GLN   121      50.027  69.343 141.804  1.00 28.10           N  
ATOM    899  CA  GLN   121      51.118  70.183 141.283  1.00 27.54           C  
ATOM    900  C   GLN   121      51.988  70.789 142.378  1.00 27.92           C  
ATOM    901  O   GLN   121      52.966  71.491 142.067  1.00 27.38           O  
ATOM    902  CB  GLN   121      50.633  71.265 140.314  1.00 27.15           C  
ATOM    903  CG  GLN   121      49.855  70.715 139.107  1.00 28.14           C  
ATOM    904  CD  GLN   121      49.955  71.620 137.895  1.00 28.34           C  
ATOM    905  OE1 GLN   121      50.863  72.455 137.800  1.00 31.14           O  
ATOM    906  NE2 GLN   121      49.015  71.481 136.974  1.00 27.72           N  
ATOM    907  N   GLY   122      51.665  70.500 143.644  1.00 27.70           N  
ATOM    908  CA  GLY   122      52.272  71.237 144.768  1.00 28.38           C  
ATOM    909  C   GLY   122      53.429  70.558 145.469  1.00 28.72           C  
ATOM    910  O   GLY   122      53.937  71.080 146.456  1.00 30.58           O  
ATOM    911  N   ALA   123      53.871  69.400 144.977  1.00 28.79           N  
ATOM    912  CA  ALA   123      54.842  68.570 145.732  1.00 28.32           C  
ATOM    913  C   ALA   123      56.237  69.214 145.942  1.00 28.38           C  
ATOM    914  O   ALA   123      56.876  69.046 146.996  1.00 28.17           O  
ATOM    915  CB  ALA   123      54.982  67.187 145.083  1.00 26.61           C  
ATOM    916  N   SER   124      56.704  69.917 144.914  1.00 28.00           N  
ATOM    917  CA  SER   124      57.985  70.650 144.955  1.00 28.18           C  
ATOM    918  C   SER   124      57.897  71.822 145.923  1.00 27.47           C  
ATOM    919  O   SER   124      58.744  71.990 146.798  1.00 28.38           O  
ATOM    920  CB  SER   124      58.354  71.128 143.540  1.00 26.89           C  
ATOM    921  OG  SER   124      59.713  71.537 143.451  1.00 26.74           O  
ATOM    922  N   ALA   125      56.839  72.612 145.792  1.00 27.16           N  
ATOM    923  CA  ALA   125      56.578  73.691 146.724  1.00 27.52           C  
ATOM    924  C   ALA   125      56.492  73.207 148.187  1.00 26.85           C  
ATOM    925  O   ALA   125      57.084  73.804 149.083  1.00 26.79           O  
ATOM    926  CB  ALA   125      55.298  74.434 146.313  1.00 27.11           C  
ATOM    927  N   ALA   126      55.755  72.122 148.401  1.00 27.19           N  
ATOM    928  CA  ALA   126      55.613  71.490 149.730  1.00 27.11           C  
ATOM    929  C   ALA   126      56.963  71.063 150.299  1.00 26.96           C  
ATOM    930  O   ALA   126      57.259  71.338 151.466  1.00 26.27           O  
ATOM    931  CB  ALA   126      54.656  70.287 149.665  1.00 26.52           C  
ATOM    932  N   MET   127      57.801  70.445 149.468  1.00 27.45           N  
ATOM    933  CA  MET   127      59.170  70.106 149.894  1.00 29.26           C  
ATOM    934  C   MET   127      59.977  71.336 150.386  1.00 28.56           C  
ATOM    935  O   MET   127      60.629  71.280 151.444  1.00 28.62           O  
ATOM    936  CB  MET   127      59.934  69.373 148.770  1.00 29.08           C  
ATOM    937  CG  MET   127      61.465  69.358 148.936  1.00 28.64           C  
ATOM    938  SD  MET   127      62.403  69.154 147.208  0.75 36.16          SE  
ATOM    939  CE  MET   127      62.175  70.994 146.489  1.00 32.20           C  
ATOM    940  N   ALA   128      59.950  72.427 149.611  1.00 28.02           N  
ATOM    941  CA  ALA   128      60.661  73.668 149.983  1.00 26.96           C  
ATOM    942  C   ALA   128      60.188  74.226 151.344  1.00 27.32           C  
ATOM    943  O   ALA   128      61.007  74.612 152.202  1.00 26.50           O  
ATOM    944  CB  ALA   128      60.517  74.724 148.880  1.00 27.40           C  
ATOM    945  N   ASN   129      58.874  74.211 151.553  1.00 26.64           N  
ATOM    946  CA  ASN   129      58.270  74.760 152.756  1.00 27.07           C  
ATOM    947  C   ASN   129      58.595  73.912 153.982  1.00 26.72           C  
ATOM    948  O   ASN   129      58.838  74.452 155.060  1.00 27.53           O  
ATOM    949  CB  ASN   129      56.752  74.930 152.581  1.00 26.67           C  
ATOM    950  CG  ASN   129      56.398  75.968 151.517  1.00 29.08           C  
ATOM    951  OD1 ASN   129      57.255  76.771 151.089  1.00 33.20           O  
ATOM    952  ND2 ASN   129      55.154  75.931 151.046  1.00 28.50           N  
ATOM    953  N   GLY   130      58.567  72.592 153.833  1.00 25.78           N  
ATOM    954  CA  GLY   130      59.005  71.700 154.892  1.00 25.32           C  
ATOM    955  C   GLY   130      60.479  71.899 155.216  1.00 25.16           C  
ATOM    956  O   GLY   130      60.862  72.001 156.370  1.00 25.37           O  
ATOM    957  N   ALA   131      61.308  71.957 154.184  1.00 25.57           N  
ATOM    958  CA  ALA   131      62.755  72.155 154.348  1.00 26.33           C  
ATOM    959  C   ALA   131      63.084  73.432 155.136  1.00 26.35           C  
ATOM    960  O   ALA   131      63.914  73.430 156.048  1.00 26.68           O  
ATOM    961  CB  ALA   131      63.431  72.234 152.959  1.00 25.86           C  
ATOM    962  N   VAL   132      62.436  74.525 154.741  1.00 26.94           N  
ATOM    963  CA  VAL   132      62.687  75.813 155.345  1.00 26.56           C  
ATOM    964  C   VAL   132      62.150  75.857 156.793  1.00 26.67           C  
ATOM    965  O   VAL   132      62.825  76.404 157.709  1.00 26.53           O  
ATOM    966  CB  VAL   132      62.141  76.905 154.439  1.00 26.44           C  
ATOM    967  CG1 VAL   132      62.171  78.299 155.128  1.00 27.72           C  
ATOM    968  CG2 VAL   132      62.961  76.916 153.110  1.00 26.29           C  
ATOM    969  N   THR   133      60.965  75.275 157.010  1.00 25.76           N  
ATOM    970  CA  THR   133      60.386  75.195 158.372  1.00 25.92           C  
ATOM    971  C   THR   133      61.319  74.450 159.317  1.00 26.25           C  
ATOM    972  O   THR   133      61.600  74.923 160.415  1.00 27.21           O  
ATOM    973  CB  THR   133      59.022  74.443 158.362  1.00 25.31           C  
ATOM    974  OG1 THR   133      58.095  75.124 157.491  1.00 24.22           O  
ATOM    975  CG2 THR   133      58.452  74.314 159.773  1.00 25.19           C  
ATOM    976  N   ALA   134      61.756  73.253 158.910  1.00 27.08           N  
ATOM    977  CA  ALA   134      62.595  72.416 159.773  1.00 26.79           C  
ATOM    978  C   ALA   134      63.962  73.037 159.938  1.00 26.88           C  
ATOM    979  O   ALA   134      64.556  72.949 161.028  1.00 26.43           O  
ATOM    980  CB  ALA   134      62.719  71.011 159.235  1.00 27.14           C  
ATOM    981  N   PHE   135      64.462  73.686 158.876  1.00 27.35           N  
ATOM    982  CA  PHE   135      65.766  74.357 158.984  1.00 27.59           C  
ATOM    983  C   PHE   135      65.788  75.443 160.066  1.00 27.62           C  
ATOM    984  O   PHE   135      66.691  75.518 160.868  1.00 27.62           O  
ATOM    985  CB  PHE   135      66.213  74.978 157.670  1.00 26.50           C  
ATOM    986  CG  PHE   135      67.410  75.855 157.833  1.00 27.59           C  
ATOM    987  CD1 PHE   135      68.685  75.289 157.965  1.00 28.36           C  
ATOM    988  CD2 PHE   135      67.275  77.239 157.900  1.00 27.24           C  
ATOM    989  CE1 PHE   135      69.808  76.097 158.139  1.00 25.71           C  
ATOM    990  CE2 PHE   135      68.372  78.056 158.073  1.00 28.16           C  
ATOM    991  CZ  PHE   135      69.649  77.490 158.206  1.00 27.41           C  
ATOM    992  N   ALA   136      64.766  76.279 160.049  1.00 28.28           N  
ATOM    993  CA  ALA   136      64.626  77.387 160.957  1.00 28.31           C  
ATOM    994  C   ALA   136      64.379  76.948 162.404  1.00 28.70           C  
ATOM    995  O   ALA   136      64.932  77.529 163.345  1.00 29.30           O  
ATOM    996  CB  ALA   136      63.510  78.284 160.467  1.00 28.08           C  
ATOM    997  N   LYS   137      63.556  75.930 162.579  1.00 29.20           N  
ATOM    998  CA  LYS   137      63.317  75.368 163.903  1.00 29.09           C  
ATOM    999  C   LYS   137      64.621  74.955 164.580  1.00 28.56           C  
ATOM   1000  O   LYS   137      64.826  75.189 165.761  1.00 28.36           O  
ATOM   1001  CB  LYS   137      62.383  74.157 163.810  1.00 29.36           C  
ATOM   1002  CG  LYS   137      62.116  73.474 165.159  1.00 30.78           C  
ATOM   1003  CD  LYS   137      60.879  72.605 165.071  1.00 36.89           C  
ATOM   1004  CE  LYS   137      59.956  72.794 166.271  1.00 39.40           C  
ATOM   1005  NZ  LYS   137      60.437  72.106 167.469  1.00 40.74           N  
ATOM   1006  N   SER   138      65.485  74.304 163.814  1.00 28.80           N  
ATOM   1007  CA  SER   138      66.711  73.746 164.332  1.00 28.52           C  
ATOM   1008  C   SER   138      67.809  74.792 164.434  1.00 28.59           C  
ATOM   1009  O   SER   138      68.573  74.804 165.407  1.00 29.88           O  
ATOM   1010  CB  SER   138      67.151  72.607 163.433  1.00 28.20           C  
ATOM   1011  OG  SER   138      68.342  72.052 163.936  1.00 28.95           O  
ATOM   1012  N   ALA   139      67.902  75.663 163.427  1.00 28.55           N  
ATOM   1013  CA  ALA   139      68.878  76.773 163.429  1.00 27.42           C  
ATOM   1014  C   ALA   139      68.718  77.669 164.665  1.00 27.45           C  
ATOM   1015  O   ALA   139      69.698  78.220 165.183  1.00 26.17           O  
ATOM   1016  CB  ALA   139      68.758  77.587 162.177  1.00 26.12           C  
ATOM   1017  N   ALA   140      67.474  77.793 165.131  1.00 27.58           N  
ATOM   1018  CA  ALA   140      67.130  78.660 166.268  1.00 27.35           C  
ATOM   1019  C   ALA   140      67.930  78.354 167.532  1.00 27.90           C  
ATOM   1020  O   ALA   140      68.181  79.256 168.334  1.00 27.91           O  
ATOM   1021  CB  ALA   140      65.643  78.555 166.571  1.00 27.07           C  
ATOM   1022  N   ILE   141      68.308  77.093 167.724  1.00 28.66           N  
ATOM   1023  CA  ILE   141      68.983  76.683 168.983  1.00 29.50           C  
ATOM   1024  C   ILE   141      70.491  76.907 168.868  1.00 30.14           C  
ATOM   1025  O   ILE   141      71.226  76.822 169.843  1.00 29.75           O  
ATOM   1026  CB  ILE   141      68.650  75.208 169.401  1.00 30.14           C  
ATOM   1027  CG1 ILE   141      69.224  74.219 168.372  1.00 31.29           C  
ATOM   1028  CG2 ILE   141      67.112  75.029 169.636  1.00 28.75           C  
ATOM   1029  CD1 ILE   141      69.251  72.771 168.789  1.00 28.37           C  
ATOM   1030  N   GLU   142      70.943  77.228 167.667  1.00 30.33           N  
ATOM   1031  CA  GLU   142      72.349  77.492 167.469  1.00 31.64           C  
ATOM   1032  C   GLU   142      72.666  78.930 167.094  1.00 31.42           C  
ATOM   1033  O   GLU   142      73.814  79.188 166.788  1.00 31.46           O  
ATOM   1034  CB  GLU   142      72.903  76.621 166.333  1.00 32.65           C  
ATOM   1035  CG  GLU   142      73.004  75.106 166.585  1.00 33.02           C  
ATOM   1036  CD  GLU   142      73.808  74.423 165.486  1.00 32.54           C  
ATOM   1037  OE1 GLU   142      73.225  73.637 164.718  1.00 34.31           O  
ATOM   1038  OE2 GLU   142      75.019  74.714 165.372  1.00 32.66           O  
ATOM   1039  N   MET   143      71.698  79.851 167.041  1.00 30.57           N  
ATOM   1040  CA  MET   143      72.053  81.220 166.592  1.00 30.15           C  
ATOM   1041  C   MET   143      73.014  81.862 167.597  1.00 29.13           C  
ATOM   1042  O   MET   143      72.848  81.679 168.792  1.00 29.60           O  
ATOM   1043  CB  MET   143      70.829  82.120 166.390  1.00 29.98           C  
ATOM   1044  CG  MET   143      70.030  81.815 165.150  1.00 30.12           C  
ATOM   1045  SD  MET   143      71.034  82.276 163.536  0.75 36.60          SE  
ATOM   1046  CE  MET   143      69.785  81.604 162.229  1.00 31.00           C  
ATOM   1047  N   PRO   144      74.041  82.584 167.113  1.00 28.48           N  
ATOM   1048  CA  PRO   144      74.903  83.295 168.067  1.00 27.86           C  
ATOM   1049  C   PRO   144      74.323  84.651 168.412  1.00 27.84           C  
ATOM   1050  O   PRO   144      73.400  85.108 167.740  1.00 27.64           O  
ATOM   1051  CB  PRO   144      76.182  83.497 167.280  1.00 28.14           C  
ATOM   1052  CG  PRO   144      75.703  83.695 165.861  1.00 27.72           C  
ATOM   1053  CD  PRO   144      74.468  82.795 165.720  1.00 27.56           C  
ATOM   1054  N   ARG   145      74.849  85.282 169.458  1.00 27.88           N  
ATOM   1055  CA  ARG   145      74.591  86.699 169.739  1.00 27.88           C  
ATOM   1056  C   ARG   145      73.115  87.075 169.963  1.00 27.79           C  
ATOM   1057  O   ARG   145      72.728  88.233 169.794  1.00 27.11           O  
ATOM   1058  CB  ARG   145      75.254  87.579 168.654  1.00 28.24           C  
ATOM   1059  CG  ARG   145      76.797  87.485 168.691  1.00 27.24           C  
ATOM   1060  CD  ARG   145      77.477  88.351 167.620  1.00 28.22           C  
ATOM   1061  NE  ARG   145      77.182  87.989 166.226  1.00 27.87           N  
ATOM   1062  CZ  ARG   145      76.338  88.643 165.432  1.00 28.14           C  
ATOM   1063  NH1 ARG   145      76.166  88.257 164.175  1.00 30.10           N  
ATOM   1064  NH2 ARG   145      75.660  89.688 165.876  1.00 30.67           N  
ATOM   1065  N   GLY   146      72.312  86.102 170.405  1.00 27.44           N  
ATOM   1066  CA  GLY   146      70.907  86.341 170.705  1.00 26.93           C  
ATOM   1067  C   GLY   146      70.045  86.511 169.457  1.00 26.30           C  
ATOM   1068  O   GLY   146      68.929  87.050 169.522  1.00 26.44           O  
ATOM   1069  N   ILE   147      70.555  86.050 168.325  1.00 25.53           N  
ATOM   1070  CA  ILE   147      69.789  86.110 167.071  1.00 24.86           C  
ATOM   1071  C   ILE   147      68.634  85.097 167.089  1.00 24.78           C  
ATOM   1072  O   ILE   147      68.768  83.999 167.624  1.00 24.13           O  
ATOM   1073  CB  ILE   147      70.702  86.007 165.818  1.00 24.02           C  
ATOM   1074  CG1 ILE   147      71.513  87.294 165.674  1.00 23.86           C  
ATOM   1075  CG2 ILE   147      69.861  85.796 164.550  1.00 24.99           C  
ATOM   1076  CD1 ILE   147      72.889  87.135 164.966  1.00 24.20           C  
ATOM   1077  N   ARG   148      67.488  85.518 166.549  1.00 24.82           N  
ATOM   1078  CA  ARG   148      66.280  84.731 166.467  1.00 25.56           C  
ATOM   1079  C   ARG   148      65.967  84.422 165.005  1.00 26.45           C  
ATOM   1080  O   ARG   148      66.387  85.161 164.091  1.00 26.05           O  
ATOM   1081  CB  ARG   148      65.116  85.532 167.051  1.00 26.11           C  
ATOM   1082  CG  ARG   148      65.262  85.839 168.574  1.00 25.10           C  
ATOM   1083  CD  ARG   148      64.062  86.610 169.080  1.00 25.56           C  
ATOM   1084  NE  ARG   148      63.920  87.885 168.367  1.00 23.44           N  
ATOM   1085  CZ  ARG   148      62.976  88.172 167.463  1.00 24.37           C  
ATOM   1086  NH1 ARG   148      62.022  87.295 167.137  1.00 21.29           N  
ATOM   1087  NH2 ARG   148      62.992  89.364 166.870  1.00 22.75           N  
ATOM   1088  N   ILE   149      65.239  83.335 164.780  1.00 26.28           N  
ATOM   1089  CA  ILE   149      64.811  82.988 163.422  1.00 26.18           C  
ATOM   1090  C   ILE   149      63.420  82.357 163.457  1.00 26.80           C  
ATOM   1091  O   ILE   149      63.188  81.427 164.221  1.00 26.28           O  
ATOM   1092  CB  ILE   149      65.829  82.045 162.706  1.00 26.44           C  
ATOM   1093  CG1 ILE   149      65.273  81.545 161.363  1.00 26.18           C  
ATOM   1094  CG2 ILE   149      66.283  80.834 163.594  1.00 24.22           C  
ATOM   1095  CD1 ILE   149      66.388  81.090 160.447  1.00 27.20           C  
ATOM   1096  N   ASN   150      62.492  82.882 162.655  1.00 26.81           N  
ATOM   1097  CA  ASN   150      61.161  82.300 162.556  1.00 26.44           C  
ATOM   1098  C   ASN   150      60.768  82.167 161.098  1.00 26.61           C  
ATOM   1099  O   ASN   150      61.460  82.660 160.202  1.00 26.32           O  
ATOM   1100  CB  ASN   150      60.107  83.126 163.299  1.00 26.04           C  
ATOM   1101  CG  ASN   150      60.434  83.313 164.789  1.00 26.58           C  
ATOM   1102  OD1 ASN   150      60.370  82.370 165.593  1.00 28.88           O  
ATOM   1103  ND2 ASN   150      60.740  84.551 165.164  1.00 23.47           N  
ATOM   1104  N   THR   151      59.687  81.433 160.862  1.00 26.73           N  
ATOM   1105  CA  THR   151      59.098  81.354 159.536  1.00 26.71           C  
ATOM   1106  C   THR   151      57.626  81.763 159.652  1.00 26.39           C  
ATOM   1107  O   THR   151      57.017  81.672 160.742  1.00 25.33           O  
ATOM   1108  CB  THR   151      59.242  79.948 158.882  1.00 26.38           C  
ATOM   1109  OG1 THR   151      58.574  78.969 159.668  1.00 29.57           O  
ATOM   1110  CG2 THR   151      60.717  79.529 158.731  1.00 26.96           C  
ATOM   1111  N   VAL   152      57.091  82.229 158.528  1.00 25.84           N  
ATOM   1112  CA  VAL   152      55.674  82.582 158.363  1.00 25.85           C  
ATOM   1113  C   VAL   152      55.125  81.721 157.255  1.00 26.18           C  
ATOM   1114  O   VAL   152      55.683  81.683 156.145  1.00 26.66           O  
ATOM   1115  CB  VAL   152      55.499  84.066 157.989  1.00 25.76           C  
ATOM   1116  CG1 VAL   152      54.014  84.436 157.827  1.00 24.94           C  
ATOM   1117  CG2 VAL   152      56.119  84.922 159.061  1.00 26.52           C  
ATOM   1118  N   SER   153      54.032  81.023 157.546  1.00 26.57           N  
ATOM   1119  CA  SER   153      53.426  80.126 156.584  1.00 26.81           C  
ATOM   1120  C   SER   153      52.070  80.679 156.164  1.00 27.47           C  
ATOM   1121  O   SER   153      51.086  80.555 156.910  1.00 28.54           O  
ATOM   1122  CB  SER   153      53.253  78.731 157.186  1.00 26.92           C  
ATOM   1123  OG  SER   153      52.866  77.808 156.183  1.00 27.39           O  
ATOM   1124  N   PRO   154      52.009  81.324 154.984  1.00 27.74           N  
ATOM   1125  CA  PRO   154      50.736  81.842 154.479  1.00 27.92           C  
ATOM   1126  C   PRO   154      49.852  80.820 153.751  1.00 27.65           C  
ATOM   1127  O   PRO   154      50.357  79.934 153.051  1.00 26.86           O  
ATOM   1128  CB  PRO   154      51.168  82.892 153.457  1.00 28.70           C  
ATOM   1129  CG  PRO   154      52.540  82.446 152.990  1.00 28.72           C  
ATOM   1130  CD  PRO   154      53.158  81.650 154.108  1.00 27.17           C  
ATOM   1131  N   ASN   155      48.541  80.972 153.899  1.00 27.35           N  
ATOM   1132  CA  ASN   155      47.584  80.379 152.952  1.00 27.86           C  
ATOM   1133  C   ASN   155      47.739  81.147 151.625  1.00 27.91           C  
ATOM   1134  O   ASN   155      48.511  82.126 151.548  1.00 27.74           O  
ATOM   1135  CB  ASN   155      46.136  80.479 153.488  1.00 27.07           C  
ATOM   1136  CG  ASN   155      45.206  79.361 152.935  1.00 27.68           C  
ATOM   1137  OD1 ASN   155      45.385  78.870 151.824  1.00 28.19           O  
ATOM   1138  ND2 ASN   155      44.228  78.955 153.739  1.00 26.74           N  
ATOM   1139  N   VAL   156      47.038  80.701 150.583  1.00 27.77           N  
ATOM   1140  CA  VAL   156      46.952  81.467 149.337  1.00 28.36           C  
ATOM   1141  C   VAL   156      46.368  82.853 149.706  1.00 28.20           C  
ATOM   1142  O   VAL   156      45.542  82.944 150.629  1.00 27.43           O  
ATOM   1143  CB  VAL   156      46.090  80.698 148.271  1.00 28.36           C  
ATOM   1144  CG1 VAL   156      44.675  80.460 148.761  1.00 28.71           C  
ATOM   1145  CG2 VAL   156      46.055  81.426 146.958  1.00 28.96           C  
ATOM   1146  N   LEU   157      46.859  83.915 149.054  1.00 28.00           N  
ATOM   1147  CA  LEU   157      46.436  85.293 149.343  1.00 27.99           C  
ATOM   1148  C   LEU   157      45.222  85.683 148.531  1.00 28.36           C  
ATOM   1149  O   LEU   157      45.129  85.336 147.349  1.00 28.03           O  
ATOM   1150  CB  LEU   157      47.575  86.315 149.065  1.00 28.06           C  
ATOM   1151  CG  LEU   157      48.947  86.088 149.699  1.00 28.76           C  
ATOM   1152  CD1 LEU   157      49.990  87.111 149.180  1.00 28.28           C  
ATOM   1153  CD2 LEU   157      48.841  86.082 151.234  1.00 25.28           C  
ATOM   1154  N   GLU   158      44.292  86.395 149.173  1.00 28.88           N  
ATOM   1155  CA  GLU   158      43.162  87.051 148.497  1.00 29.77           C  
ATOM   1156  C   GLU   158      43.593  87.826 147.253  1.00 29.98           C  
ATOM   1157  O   GLU   158      42.920  87.802 146.214  1.00 29.81           O  
ATOM   1158  CB  GLU   158      42.459  88.009 149.444  1.00 29.09           C  
ATOM   1159  CG  GLU   158      41.609  87.320 150.501  1.00 31.90           C  
ATOM   1160  CD  GLU   158      40.891  88.296 151.422  1.00 32.37           C  
ATOM   1161  OE1 GLU   158      41.096  89.530 151.280  1.00 34.89           O  
ATOM   1162  OE2 GLU   158      40.110  87.823 152.287  1.00 35.84           O  
ATOM   1163  N   GLU   159      44.722  88.508 147.363  1.00 30.68           N  
ATOM   1164  CA  GLU   159      45.248  89.313 146.267  1.00 31.78           C  
ATOM   1165  C   GLU   159      45.688  88.475 145.058  1.00 32.45           C  
ATOM   1166  O   GLU   159      45.776  88.989 143.951  1.00 33.02           O  
ATOM   1167  CB  GLU   159      46.407  90.201 146.766  1.00 31.26           C  
ATOM   1168  CG  GLU   159      45.959  91.324 147.679  1.00 31.64           C  
ATOM   1169  CD  GLU   159      45.696  90.902 149.145  1.00 32.05           C  
ATOM   1170  OE1 GLU   159      45.914  89.725 149.527  1.00 30.32           O  
ATOM   1171  OE2 GLU   159      45.267  91.784 149.924  1.00 31.99           O  
ATOM   1172  N   SER   160      45.971  87.193 145.273  1.00 33.26           N  
ATOM   1173  CA  SER   160      46.399  86.302 144.208  1.00 34.06           C  
ATOM   1174  C   SER   160      45.300  85.328 143.800  1.00 34.70           C  
ATOM   1175  O   SER   160      45.506  84.512 142.899  1.00 34.77           O  
ATOM   1176  CB  SER   160      47.642  85.525 144.635  1.00 33.78           C  
ATOM   1177  OG  SER   160      48.610  86.394 145.190  1.00 35.39           O  
ATOM   1178  N   TRP   161      44.140  85.426 144.457  1.00 35.05           N  
ATOM   1179  CA  TRP   161      43.020  84.479 144.289  1.00 35.64           C  
ATOM   1180  C   TRP   161      42.526  84.405 142.858  1.00 37.08           C  
ATOM   1181  O   TRP   161      42.155  83.328 142.365  1.00 36.84           O  
ATOM   1182  CB  TRP   161      41.861  84.862 145.207  1.00 34.35           C  
ATOM   1183  CG  TRP   161      40.734  83.857 145.335  1.00 33.76           C  
ATOM   1184  CD1 TRP   161      39.401  84.097 145.132  1.00 32.45           C  
ATOM   1185  CD2 TRP   161      40.835  82.475 145.730  1.00 31.53           C  
ATOM   1186  NE1 TRP   161      38.670  82.950 145.363  1.00 32.32           N  
ATOM   1187  CE2 TRP   161      39.520  81.942 145.734  1.00 32.64           C  
ATOM   1188  CE3 TRP   161      41.904  81.636 146.073  1.00 31.94           C  
ATOM   1189  CZ2 TRP   161      39.245  80.604 146.081  1.00 33.12           C  
ATOM   1190  CZ3 TRP   161      41.631  80.296 146.428  1.00 32.94           C  
ATOM   1191  CH2 TRP   161      40.313  79.795 146.413  1.00 32.40           C  
ATOM   1192  N   ASP   162      42.518  85.549 142.183  1.00 38.75           N  
ATOM   1193  CA  ASP   162      41.972  85.605 140.828  1.00 40.57           C  
ATOM   1194  C   ASP   162      42.903  84.968 139.793  1.00 40.25           C  
ATOM   1195  O   ASP   162      42.520  84.792 138.654  1.00 41.45           O  
ATOM   1196  CB  ASP   162      41.541  87.038 140.440  1.00 41.67           C  
ATOM   1197  CG  ASP   162      40.012  87.251 140.538  1.00 45.20           C  
ATOM   1198  OD1 ASP   162      39.358  86.634 141.427  1.00 48.00           O  
ATOM   1199  OD2 ASP   162      39.457  88.040 139.715  1.00 48.43           O  
ATOM   1200  N   LYS   163      44.119  84.627 140.201  1.00 39.98           N  
ATOM   1201  CA  LYS   163      45.042  83.847 139.373  1.00 39.57           C  
ATOM   1202  C   LYS   163      45.200  82.380 139.851  1.00 37.72           C  
ATOM   1203  O   LYS   163      45.343  81.470 139.037  1.00 37.60           O  
ATOM   1204  CB  LYS   163      46.397  84.563 139.300  1.00 39.50           C  
ATOM   1205  CG  LYS   163      47.585  83.647 139.029  1.00 41.83           C  
ATOM   1206  CD  LYS   163      48.862  84.449 138.837  1.00 42.81           C  
ATOM   1207  CE  LYS   163      49.983  83.943 139.737  1.00 47.93           C  
ATOM   1208  NZ  LYS   163      49.698  84.227 141.188  1.00 50.55           N  
ATOM   1209  N   LEU   164      45.124  82.166 141.165  1.00 35.65           N  
ATOM   1210  CA  LEU   164      45.529  80.910 141.796  1.00 34.47           C  
ATOM   1211  C   LEU   164      44.398  79.973 142.200  1.00 33.80           C  
ATOM   1212  O   LEU   164      44.645  78.821 142.548  1.00 33.95           O  
ATOM   1213  CB  LEU   164      46.411  81.205 143.037  1.00 34.28           C  
ATOM   1214  CG  LEU   164      47.788  81.795 142.746  1.00 33.69           C  
ATOM   1215  CD1 LEU   164      48.581  81.862 144.038  1.00 34.51           C  
ATOM   1216  CD2 LEU   164      48.545  80.963 141.690  1.00 32.19           C  
ATOM   1217  N   GLU   165      43.166  80.472 142.171  1.00 33.60           N  
ATOM   1218  CA  GLU   165      41.977  79.693 142.566  1.00 33.10           C  
ATOM   1219  C   GLU   165      41.940  78.302 141.920  1.00 32.44           C  
ATOM   1220  O   GLU   165      41.680  77.316 142.613  1.00 31.34           O  
ATOM   1221  CB  GLU   165      40.690  80.476 142.261  1.00 33.45           C  
ATOM   1222  CG  GLU   165      39.396  79.811 142.709  1.00 35.66           C  
ATOM   1223  CD  GLU   165      38.824  78.793 141.716  1.00 41.20           C  
ATOM   1224  OE1 GLU   165      38.061  77.908 142.178  1.00 42.85           O  
ATOM   1225  OE2 GLU   165      39.103  78.872 140.486  1.00 41.94           O  
ATOM   1226  N   PRO   166      42.212  78.213 140.598  1.00 31.78           N  
ATOM   1227  CA  PRO   166      42.118  76.905 139.964  1.00 31.86           C  
ATOM   1228  C   PRO   166      43.047  75.854 140.585  1.00 31.31           C  
ATOM   1229  O   PRO   166      42.779  74.680 140.430  1.00 31.11           O  
ATOM   1230  CB  PRO   166      42.540  77.193 138.515  1.00 31.85           C  
ATOM   1231  CG  PRO   166      42.182  78.614 138.300  1.00 31.97           C  
ATOM   1232  CD  PRO   166      42.605  79.235 139.614  1.00 32.37           C  
ATOM   1233  N   PHE   167      44.103  76.283 141.281  1.00 30.34           N  
ATOM   1234  CA  PHE   167      45.022  75.376 141.953  1.00 30.80           C  
ATOM   1235  C   PHE   167      44.562  75.099 143.378  1.00 29.84           C  
ATOM   1236  O   PHE   167      45.033  74.139 143.998  1.00 29.14           O  
ATOM   1237  CB  PHE   167      46.445  75.972 142.042  1.00 31.12           C  
ATOM   1238  CG  PHE   167      47.173  76.042 140.714  1.00 34.05           C  
ATOM   1239  CD1 PHE   167      48.020  75.003 140.310  1.00 35.62           C  
ATOM   1240  CD2 PHE   167      47.028  77.156 139.878  1.00 35.05           C  
ATOM   1241  CE1 PHE   167      48.703  75.048 139.069  1.00 36.61           C  
ATOM   1242  CE2 PHE   167      47.701  77.212 138.620  1.00 37.84           C  
ATOM   1243  CZ  PHE   167      48.543  76.158 138.225  1.00 36.35           C  
ATOM   1244  N   PHE   168      43.668  75.942 143.900  1.00 28.91           N  
ATOM   1245  CA  PHE   168      43.342  75.925 145.345  1.00 28.98           C  
ATOM   1246  C   PHE   168      41.839  75.842 145.566  1.00 28.68           C  
ATOM   1247  O   PHE   168      41.280  76.529 146.425  1.00 29.25           O  
ATOM   1248  CB  PHE   168      43.929  77.151 146.062  1.00 28.60           C  
ATOM   1249  CG  PHE   168      45.426  77.088 146.271  1.00 30.43           C  
ATOM   1250  CD1 PHE   168      45.969  76.533 147.449  1.00 30.16           C  
ATOM   1251  CD2 PHE   168      46.305  77.591 145.301  1.00 29.81           C  
ATOM   1252  CE1 PHE   168      47.389  76.475 147.632  1.00 30.62           C  
ATOM   1253  CE2 PHE   168      47.705  77.535 145.482  1.00 27.69           C  
ATOM   1254  CZ  PHE   168      48.242  76.979 146.646  1.00 29.23           C  
ATOM   1255  N   GLU   169      41.185  74.982 144.797  1.00 28.27           N  
ATOM   1256  CA  GLU   169      39.730  74.900 144.822  1.00 28.70           C  
ATOM   1257  C   GLU   169      39.211  74.522 146.205  1.00 27.93           C  
ATOM   1258  O   GLU   169      39.628  73.503 146.760  1.00 28.49           O  
ATOM   1259  CB  GLU   169      39.223  73.951 143.747  1.00 27.95           C  
ATOM   1260  CG  GLU   169      39.253  74.617 142.390  1.00 30.84           C  
ATOM   1261  CD  GLU   169      39.099  73.651 141.252  1.00 33.19           C  
ATOM   1262  OE1 GLU   169      39.925  72.719 141.171  1.00 34.96           O  
ATOM   1263  OE2 GLU   169      38.167  73.839 140.421  1.00 35.33           O  
ATOM   1264  N   GLY   170      38.336  75.365 146.761  1.00 27.46           N  
ATOM   1265  CA  GLY   170      37.771  75.127 148.088  1.00 26.08           C  
ATOM   1266  C   GLY   170      38.629  75.610 149.253  1.00 26.14           C  
ATOM   1267  O   GLY   170      38.229  75.458 150.421  1.00 26.25           O  
ATOM   1268  N   PHE   171      39.801  76.186 148.973  1.00 26.13           N  
ATOM   1269  CA  PHE   171      40.579  76.853 150.040  1.00 26.26           C  
ATOM   1270  C   PHE   171      39.887  78.187 150.311  1.00 26.70           C  
ATOM   1271  O   PHE   171      39.094  78.661 149.486  1.00 26.33           O  
ATOM   1272  CB  PHE   171      42.021  77.153 149.608  1.00 26.10           C  
ATOM   1273  CG  PHE   171      42.957  75.978 149.674  1.00 26.33           C  
ATOM   1274  CD1 PHE   171      44.059  76.011 150.526  1.00 26.64           C  
ATOM   1275  CD2 PHE   171      42.761  74.855 148.859  1.00 25.07           C  
ATOM   1276  CE1 PHE   171      44.942  74.949 150.583  1.00 25.73           C  
ATOM   1277  CE2 PHE   171      43.623  73.786 148.909  1.00 26.13           C  
ATOM   1278  CZ  PHE   171      44.721  73.823 149.766  1.00 26.48           C  
ATOM   1279  N   LEU   172      40.178  78.779 151.460  1.00 26.77           N  
ATOM   1280  CA  LEU   172      39.725  80.120 151.754  1.00 27.65           C  
ATOM   1281  C   LEU   172      40.930  81.031 151.893  1.00 27.07           C  
ATOM   1282  O   LEU   172      41.660  80.921 152.882  1.00 27.75           O  
ATOM   1283  CB  LEU   172      38.846  80.139 153.013  1.00 27.73           C  
ATOM   1284  CG  LEU   172      38.101  81.435 153.369  1.00 28.21           C  
ATOM   1285  CD1 LEU   172      37.032  81.777 152.389  1.00 31.69           C  
ATOM   1286  CD2 LEU   172      37.516  81.350 154.786  1.00 29.69           C  
ATOM   1287  N   PRO   173      41.143  81.944 150.913  1.00 26.72           N  
ATOM   1288  CA  PRO   173      42.366  82.784 150.930  1.00 26.42           C  
ATOM   1289  C   PRO   173      42.373  83.777 152.091  1.00 26.62           C  
ATOM   1290  O   PRO   173      41.319  84.069 152.660  1.00 26.99           O  
ATOM   1291  CB  PRO   173      42.299  83.546 149.597  1.00 26.22           C  
ATOM   1292  CG  PRO   173      40.850  83.537 149.203  1.00 25.68           C  
ATOM   1293  CD  PRO   173      40.252  82.271 149.775  1.00 26.21           C  
ATOM   1294  N   VAL   174      43.550  84.289 152.428  1.00 27.21           N  
ATOM   1295  CA  VAL   174      43.722  85.240 153.533  1.00 26.74           C  
ATOM   1296  C   VAL   174      44.233  86.544 152.953  1.00 27.30           C  
ATOM   1297  O   VAL   174      44.909  86.530 151.921  1.00 27.96           O  
ATOM   1298  CB  VAL   174      44.727  84.690 154.607  1.00 26.89           C  
ATOM   1299  CG1 VAL   174      44.141  83.403 155.312  1.00 27.71           C  
ATOM   1300  CG2 VAL   174      46.112  84.436 154.007  1.00 25.68           C  
ATOM   1301  N   PRO   175      43.900  87.688 153.586  1.00 27.97           N  
ATOM   1302  CA  PRO   175      44.459  88.933 153.066  1.00 27.37           C  
ATOM   1303  C   PRO   175      45.971  88.991 153.330  1.00 27.29           C  
ATOM   1304  O   PRO   175      46.423  88.590 154.416  1.00 27.52           O  
ATOM   1305  CB  PRO   175      43.718  90.018 153.860  1.00 27.66           C  
ATOM   1306  CG  PRO   175      42.593  89.318 154.603  1.00 27.78           C  
ATOM   1307  CD  PRO   175      43.030  87.904 154.763  1.00 27.90           C  
ATOM   1308  N   ALA   176      46.739  89.475 152.346  1.00 26.80           N  
ATOM   1309  CA  ALA   176      48.171  89.767 152.531  1.00 26.82           C  
ATOM   1310  C   ALA   176      48.460  90.584 153.795  1.00 26.95           C  
ATOM   1311  O   ALA   176      49.473  90.359 154.471  1.00 26.85           O  
ATOM   1312  CB  ALA   176      48.775  90.477 151.262  1.00 26.26           C  
ATOM   1313  N   ALA   177      47.585  91.539 154.112  1.00 27.41           N  
ATOM   1314  CA  ALA   177      47.798  92.396 155.295  1.00 27.90           C  
ATOM   1315  C   ALA   177      47.721  91.605 156.595  1.00 27.75           C  
ATOM   1316  O   ALA   177      48.385  91.951 157.583  1.00 27.36           O  
ATOM   1317  CB  ALA   177      46.809  93.566 155.319  1.00 28.76           C  
ATOM   1318  N   LYS   178      46.915  90.539 156.599  1.00 27.25           N  
ATOM   1319  CA  LYS   178      46.855  89.644 157.758  1.00 27.46           C  
ATOM   1320  C   LYS   178      48.164  88.826 157.915  1.00 25.78           C  
ATOM   1321  O   LYS   178      48.661  88.674 159.017  1.00 24.76           O  
ATOM   1322  CB  LYS   178      45.605  88.765 157.682  1.00 27.38           C  
ATOM   1323  CG  LYS   178      45.332  87.917 158.914  1.00 29.99           C  
ATOM   1324  CD  LYS   178      44.134  86.987 158.637  1.00 30.78           C  
ATOM   1325  CE  LYS   178      43.800  86.094 159.835  1.00 35.73           C  
ATOM   1326  NZ  LYS   178      42.937  84.941 159.393  1.00 38.66           N  
ATOM   1327  N   VAL   179      48.714  88.338 156.800  1.00 25.07           N  
ATOM   1328  CA  VAL   179      49.996  87.630 156.762  1.00 25.31           C  
ATOM   1329  C   VAL   179      51.124  88.551 157.215  1.00 25.93           C  
ATOM   1330  O   VAL   179      51.997  88.134 157.989  1.00 26.07           O  
ATOM   1331  CB  VAL   179      50.308  87.035 155.319  1.00 25.33           C  
ATOM   1332  CG1 VAL   179      51.571  86.189 155.301  1.00 24.52           C  
ATOM   1333  CG2 VAL   179      49.155  86.179 154.846  1.00 25.95           C  
ATOM   1334  N   ALA   180      51.084  89.808 156.745  1.00 25.40           N  
ATOM   1335  CA  ALA   180      52.097  90.817 157.087  1.00 25.14           C  
ATOM   1336  C   ALA   180      52.262  91.000 158.607  1.00 25.03           C  
ATOM   1337  O   ALA   180      53.349  91.328 159.071  1.00 25.04           O  
ATOM   1338  CB  ALA   180      51.751  92.140 156.426  1.00 23.84           C  
ATOM   1339  N   ARG   181      51.180  90.807 159.366  1.00 25.41           N  
ATOM   1340  CA  ARG   181      51.222  90.921 160.838  1.00 26.72           C  
ATOM   1341  C   ARG   181      52.166  89.880 161.453  1.00 26.60           C  
ATOM   1342  O   ARG   181      52.815  90.134 162.479  1.00 27.10           O  
ATOM   1343  CB  ARG   181      49.819  90.737 161.451  1.00 26.71           C  
ATOM   1344  CG  ARG   181      48.830  91.862 161.131  1.00 28.71           C  
ATOM   1345  CD  ARG   181      47.529  91.744 161.945  1.00 28.49           C  
ATOM   1346  NE  ARG   181      46.600  92.813 161.560  1.00 30.42           N  
ATOM   1347  CZ  ARG   181      46.406  93.933 162.253  1.00 33.48           C  
ATOM   1348  NH1 ARG   181      47.047  94.132 163.403  1.00 33.02           N  
ATOM   1349  NH2 ARG   181      45.546  94.851 161.805  1.00 33.70           N  
ATOM   1350  N   ALA   182      52.224  88.704 160.841  1.00 26.25           N  
ATOM   1351  CA  ALA   182      53.003  87.602 161.398  1.00 26.81           C  
ATOM   1352  C   ALA   182      54.493  87.880 161.195  1.00 26.67           C  
ATOM   1353  O   ALA   182      55.305  87.517 162.036  1.00 26.13           O  
ATOM   1354  CB  ALA   182      52.579  86.240 160.795  1.00 25.55           C  
ATOM   1355  N   PHE   183      54.828  88.530 160.079  1.00 26.73           N  
ATOM   1356  CA  PHE   183      56.174  89.066 159.882  1.00 26.74           C  
ATOM   1357  C   PHE   183      56.520  90.105 160.950  1.00 27.20           C  
ATOM   1358  O   PHE   183      57.593  90.024 161.560  1.00 27.83           O  
ATOM   1359  CB  PHE   183      56.323  89.639 158.467  1.00 26.75           C  
ATOM   1360  CG  PHE   183      56.432  88.569 157.377  1.00 26.73           C  
ATOM   1361  CD1 PHE   183      57.674  88.070 156.999  1.00 26.99           C  
ATOM   1362  CD2 PHE   183      55.285  88.045 156.766  1.00 25.26           C  
ATOM   1363  CE1 PHE   183      57.774  87.081 156.001  1.00 29.07           C  
ATOM   1364  CE2 PHE   183      55.373  87.078 155.770  1.00 24.89           C  
ATOM   1365  CZ  PHE   183      56.626  86.588 155.391  1.00 27.08           C  
ATOM   1366  N   GLU   184      55.612  91.048 161.212  1.00 26.75           N  
ATOM   1367  CA  GLU   184      55.826  92.022 162.283  1.00 28.06           C  
ATOM   1368  C   GLU   184      56.041  91.344 163.656  1.00 27.14           C  
ATOM   1369  O   GLU   184      56.925  91.744 164.407  1.00 26.79           O  
ATOM   1370  CB  GLU   184      54.716  93.083 162.325  1.00 26.61           C  
ATOM   1371  CG  GLU   184      55.013  94.210 163.289  1.00 30.67           C  
ATOM   1372  CD  GLU   184      53.800  95.099 163.623  1.00 31.00           C  
ATOM   1373  OE1 GLU   184      52.749  94.980 162.982  1.00 35.43           O  
ATOM   1374  OE2 GLU   184      53.897  95.925 164.553  1.00 33.69           O  
ATOM   1375  N   LYS   185      55.244  90.312 163.956  1.00 27.04           N  
ATOM   1376  CA  LYS   185      55.409  89.476 165.136  1.00 27.01           C  
ATOM   1377  C   LYS   185      56.817  88.874 165.233  1.00 28.06           C  
ATOM   1378  O   LYS   185      57.440  88.873 166.323  1.00 28.16           O  
ATOM   1379  CB  LYS   185      54.402  88.330 165.109  1.00 27.15           C  
ATOM   1380  CG  LYS   185      54.185  87.647 166.456  1.00 27.26           C  
ATOM   1381  CD  LYS   185      53.266  86.469 166.251  1.00 26.34           C  
ATOM   1382  CE  LYS   185      52.707  85.946 167.541  1.00 31.80           C  
ATOM   1383  NZ  LYS   185      53.650  85.548 168.561  1.00 28.33           N  
ATOM   1384  N   SER   186      57.322  88.353 164.112  1.00 26.77           N  
ATOM   1385  CA  SER   186      58.678  87.808 164.126  1.00 27.37           C  
ATOM   1386  C   SER   186      59.719  88.912 164.371  1.00 26.57           C  
ATOM   1387  O   SER   186      60.652  88.730 165.170  1.00 25.36           O  
ATOM   1388  CB  SER   186      58.990  87.029 162.840  1.00 27.27           C  
ATOM   1389  OG  SER   186      60.324  86.537 162.884  1.00 28.67           O  
ATOM   1390  N   VAL   187      59.545  90.065 163.712  1.00 25.81           N  
ATOM   1391  CA  VAL   187      60.538  91.149 163.833  1.00 25.39           C  
ATOM   1392  C   VAL   187      60.571  91.841 165.199  1.00 25.69           C  
ATOM   1393  O   VAL   187      61.661  92.019 165.768  1.00 25.48           O  
ATOM   1394  CB  VAL   187      60.449  92.177 162.658  1.00 25.68           C  
ATOM   1395  CG1 VAL   187      61.470  93.280 162.816  1.00 25.75           C  
ATOM   1396  CG2 VAL   187      60.658  91.454 161.314  1.00 25.10           C  
ATOM   1397  N   PHE   188      59.400  92.208 165.732  1.00 25.07           N  
ATOM   1398  CA  PHE   188      59.310  93.034 166.940  1.00 25.59           C  
ATOM   1399  C   PHE   188      59.056  92.250 168.210  1.00 25.80           C  
ATOM   1400  O   PHE   188      59.178  92.791 169.326  1.00 25.49           O  
ATOM   1401  CB  PHE   188      58.272  94.172 166.757  1.00 25.70           C  
ATOM   1402  CG  PHE   188      58.709  95.190 165.743  1.00 28.12           C  
ATOM   1403  CD1 PHE   188      59.617  96.172 166.087  1.00 29.21           C  
ATOM   1404  CD2 PHE   188      58.312  95.089 164.414  1.00 28.34           C  
ATOM   1405  CE1 PHE   188      60.069  97.098 165.131  1.00 30.52           C  
ATOM   1406  CE2 PHE   188      58.770  96.009 163.443  1.00 27.97           C  
ATOM   1407  CZ  PHE   188      59.644  97.000 163.805  1.00 28.57           C  
ATOM   1408  N   GLY   189      58.702  90.975 168.039  1.00 25.53           N  
ATOM   1409  CA  GLY   189      58.512  90.078 169.169  1.00 25.82           C  
ATOM   1410  C   GLY   189      59.839  89.501 169.620  1.00 25.64           C  
ATOM   1411  O   GLY   189      60.902  89.923 169.143  1.00 26.52           O  
ATOM   1412  N   ALA   190      59.783  88.531 170.528  1.00 25.06           N  
ATOM   1413  CA  ALA   190      60.993  87.938 171.102  1.00 25.22           C  
ATOM   1414  C   ALA   190      61.068  86.398 170.955  1.00 25.59           C  
ATOM   1415  O   ALA   190      61.878  85.735 171.637  1.00 24.73           O  
ATOM   1416  CB  ALA   190      61.127  88.348 172.583  1.00 25.07           C  
ATOM   1417  N   GLN   191      60.239  85.826 170.080  1.00 25.26           N  
ATOM   1418  CA  GLN   191      60.155  84.364 170.004  1.00 26.40           C  
ATOM   1419  C   GLN   191      61.125  83.848 168.963  1.00 26.95           C  
ATOM   1420  O   GLN   191      61.536  84.599 168.073  1.00 28.17           O  
ATOM   1421  CB  GLN   191      58.735  83.895 169.671  1.00 25.78           C  
ATOM   1422  CG  GLN   191      57.707  84.184 170.732  1.00 26.54           C  
ATOM   1423  CD  GLN   191      56.273  83.896 170.300  1.00 27.80           C  
ATOM   1424  OE1 GLN   191      55.995  83.381 169.184  1.00 28.88           O  
ATOM   1425  NE2 GLN   191      55.344  84.259 171.171  1.00 27.31           N  
ATOM   1426  N   THR   192      61.474  82.569 169.049  1.00 26.92           N  
ATOM   1427  CA  THR   192      62.391  81.971 168.086  1.00 26.53           C  
ATOM   1428  C   THR   192      62.063  80.504 167.753  1.00 26.55           C  
ATOM   1429  O   THR   192      61.501  79.774 168.578  1.00 25.66           O  
ATOM   1430  CB  THR   192      63.885  82.150 168.526  1.00 26.29           C  
ATOM   1431  OG1 THR   192      64.751  81.913 167.406  1.00 26.86           O  
ATOM   1432  CG2 THR   192      64.255  81.247 169.691  1.00 25.27           C  
ATOM   1433  N   GLY   193      62.417  80.079 166.545  1.00 25.43           N  
ATOM   1434  CA  GLY   193      62.176  78.706 166.131  1.00 26.08           C  
ATOM   1435  C   GLY   193      60.713  78.389 165.860  1.00 26.87           C  
ATOM   1436  O   GLY   193      60.334  77.209 165.724  1.00 27.01           O  
ATOM   1437  N   GLU   194      59.893  79.432 165.761  1.00 27.25           N  
ATOM   1438  CA  GLU   194      58.459  79.268 165.499  1.00 27.78           C  
ATOM   1439  C   GLU   194      58.100  79.291 164.018  1.00 27.44           C  
ATOM   1440  O   GLU   194      58.802  79.886 163.191  1.00 27.24           O  
ATOM   1441  CB  GLU   194      57.651  80.359 166.190  1.00 28.49           C  
ATOM   1442  CG  GLU   194      57.958  80.530 167.692  1.00 31.75           C  
ATOM   1443  CD  GLU   194      57.503  79.344 168.521  1.00 36.75           C  
ATOM   1444  OE1 GLU   194      56.539  78.665 168.120  1.00 36.63           O  
ATOM   1445  OE2 GLU   194      58.106  79.088 169.581  1.00 41.39           O  
ATOM   1446  N   SER   195      56.963  78.673 163.724  1.00 27.04           N  
ATOM   1447  CA  SER   195      56.339  78.722 162.430  1.00 28.18           C  
ATOM   1448  C   SER   195      54.971  79.407 162.644  1.00 27.83           C  
ATOM   1449  O   SER   195      54.056  78.839 163.249  1.00 26.88           O  
ATOM   1450  CB  SER   195      56.153  77.281 161.917  1.00 28.75           C  
ATOM   1451  OG  SER   195      55.373  77.254 160.725  1.00 29.89           O  
ATOM   1452  N   TYR   196      54.834  80.619 162.138  1.00 26.76           N  
ATOM   1453  CA  TYR   196      53.598  81.359 162.296  1.00 27.55           C  
ATOM   1454  C   TYR   196      52.660  81.063 161.117  1.00 28.47           C  
ATOM   1455  O   TYR   196      52.894  81.537 160.010  1.00 28.15           O  
ATOM   1456  CB  TYR   196      53.934  82.838 162.366  1.00 27.66           C  
ATOM   1457  CG  TYR   196      54.767  83.226 163.571  1.00 27.83           C  
ATOM   1458  CD1 TYR   196      54.441  82.756 164.861  1.00 28.25           C  
ATOM   1459  CD2 TYR   196      55.859  84.075 163.429  1.00 27.61           C  
ATOM   1460  CE1 TYR   196      55.193  83.131 165.976  1.00 26.08           C  
ATOM   1461  CE2 TYR   196      56.631  84.460 164.531  1.00 28.24           C  
ATOM   1462  CZ  TYR   196      56.279  83.989 165.803  1.00 28.36           C  
ATOM   1463  OH  TYR   196      57.026  84.404 166.892  1.00 30.86           O  
ATOM   1464  N   GLN   197      51.629  80.256 161.350  1.00 28.97           N  
ATOM   1465  CA  GLN   197      50.691  79.903 160.300  1.00 30.42           C  
ATOM   1466  C   GLN   197      49.650  80.995 160.186  1.00 30.12           C  
ATOM   1467  O   GLN   197      49.078  81.422 161.207  1.00 29.90           O  
ATOM   1468  CB  GLN   197      49.981  78.571 160.605  1.00 30.06           C  
ATOM   1469  CG  GLN   197      50.909  77.415 160.925  1.00 32.19           C  
ATOM   1470  CD  GLN   197      50.195  76.275 161.692  1.00 35.31           C  
ATOM   1471  OE1 GLN   197      49.368  76.524 162.578  1.00 41.81           O  
ATOM   1472  NE2 GLN   197      50.525  75.026 161.356  1.00 36.84           N  
ATOM   1473  N   VAL   198      49.392  81.450 158.959  1.00 28.33           N  
ATOM   1474  CA  VAL   198      48.281  82.354 158.739  1.00 29.20           C  
ATOM   1475  C   VAL   198      47.370  81.698 157.703  1.00 29.40           C  
ATOM   1476  O   VAL   198      47.506  81.923 156.510  1.00 29.57           O  
ATOM   1477  CB  VAL   198      48.723  83.792 158.307  1.00 29.44           C  
ATOM   1478  CG1 VAL   198      47.512  84.711 158.258  1.00 28.69           C  
ATOM   1479  CG2 VAL   198      49.780  84.385 159.302  1.00 29.55           C  
ATOM   1480  N   TYR   199      46.465  80.860 158.188  1.00 30.45           N  
ATOM   1481  CA  TYR   199      45.725  79.931 157.336  1.00 31.50           C  
ATOM   1482  C   TYR   199      44.236  80.245 157.291  1.00 32.19           C  
ATOM   1483  O   TYR   199      43.690  80.826 158.258  1.00 32.13           O  
ATOM   1484  CB  TYR   199      45.893  78.481 157.823  1.00 31.61           C  
ATOM   1485  CG  TYR   199      47.281  77.875 157.663  1.00 31.88           C  
ATOM   1486  CD1 TYR   199      48.251  78.447 156.810  1.00 29.09           C  
ATOM   1487  CD2 TYR   199      47.603  76.695 158.327  1.00 29.78           C  
ATOM   1488  CE1 TYR   199      49.497  77.860 156.658  1.00 31.97           C  
ATOM   1489  CE2 TYR   199      48.857  76.102 158.183  1.00 30.54           C  
ATOM   1490  CZ  TYR   199      49.801  76.681 157.356  1.00 32.26           C  
ATOM   1491  OH  TYR   199      51.049  76.072 157.238  1.00 33.82           O  
ATOM   1492  OXT TYR   199      43.567  79.870 156.297  1.00 32.08           O  
END
