
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   68 ( 1015),  selected   68 , name 2e5p_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 2e5p_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E      22           -
LGA    S     2_A      T      23           -
LGA    S     3_A      E      24           -
LGA    G     4_A      L      25           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    P     8_A      -       -           -
LGA    R     9_A      L      27          2.437
LGA    L    10_A      Y      28          1.079
LGA    W    11_A      K      29          0.520
LGA    E    12_A      V      30          0.814
LGA    G    13_A      N      31          1.224
LGA    Q    14_A      E      32          1.118
LGA    D    15_A      Y      33          1.043
LGA    V    16_A      V      34          0.735
LGA    L    17_A      D      35          0.901
LGA    A    18_A      A      36          0.815
LGA    R    19_A      R      37          0.878
LGA    W    20_A      D      38          1.209
LGA    T    21_A      T      39          3.175
LGA    -       -      N      40           -
LGA    D    22_A      M      41          0.751
LGA    G    23_A      G      42          0.898
LGA    L    24_A      A      43          1.021
LGA    L    25_A      W      44          0.427
LGA    Y    26_A      F      45          1.137
LGA    L    27_A      E      46          1.388
LGA    G    28_A      A      47          0.950
LGA    T    29_A      Q      48          0.382
LGA    I    30_A      V      49          0.633
LGA    K    31_A      V      50          0.623
LGA    K    32_A      R      51          0.727
LGA    V    33_A      V      52          0.847
LGA    D    34_A      T      53          1.242
LGA    S    35_A      R      54          2.875
LGA    A    36_A      E      73           -
LGA    R    37_A      D      74          4.960
LGA    E    38_A      V      75          0.867
LGA    V    39_A      I      76          1.054
LGA    C    40_A      Y      77          0.689
LGA    L    41_A      H      78          0.233
LGA    V    42_A      V      79          0.482
LGA    Q    43_A      K      80          0.534
LGA    F    44_A      Y      81          1.622
LGA    E    45_A      D      82          3.730
LGA    -       -      D      83           -
LGA    -       -      Y      84           -
LGA    D    46_A      P      85          1.822
LGA    D    47_A      E      86          4.590
LGA    S    48_A      N      87          2.812
LGA    -       -      G      88           -
LGA    Q    49_A      V      89          0.400
LGA    F    50_A      V      90          1.454
LGA    L    51_A      Q      91          0.900
LGA    V    52_A      M      92          0.547
LGA    L    53_A      N      93          0.970
LGA    W    54_A      S      94          0.502
LGA    K    55_A      R      95          0.529
LGA    D    56_A      D      96          1.018
LGA    I    57_A      V      97          0.972
LGA    S    58_A      R      98          2.756
LGA    P    59_A      A      99          2.281
LGA    A    60_A      R     100          0.900
LGA    A    61_A      A     101          3.071
LGA    L    62_A      R     102          3.724
LGA    S    63_A      -       -           -
LGA    G    64_A      T     103          1.937
LGA    P    65_A      I     104          4.890
LGA    S    66_A      I     105           -
LGA    S    67_A      K     106           -
LGA    G    68_A      W     107           -
LGA    -       -      Q     108           -
LGA    -       -      D     109           -
LGA    -       -      L     110           -
LGA    -       -      E     111           -
LGA    -       -      V     112           -
LGA    -       -      G     113           -
LGA    -       -      Q     114           -
LGA    -       -      V     115           -
LGA    -       -      V     116           -
LGA    -       -      M     117           -
LGA    -       -      L     118           -
LGA    -       -      N     119           -
LGA    -       -      Y     120           -
LGA    -       -      N     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    -       -      E     127           -
LGA    -       -      R     128           -
LGA    -       -      G     129           -
LGA    -       -      F     130           -
LGA    -       -      W     131           -
LGA    -       -      Y     132           -
LGA    -       -      D     133           -
LGA    -       -      A     134           -
LGA    -       -      E     135           -
LGA    -       -      I     136           -
LGA    -       -      S     137           -
LGA    -       -      R     138           -
LGA    -       -      K     139           -
LGA    -       -      R     140           -
LGA    -       -      E     141           -
LGA    -       -      T     142           -
LGA    -       -      R     143           -
LGA    -       -      T     144           -
LGA    -       -      A     145           -
LGA    -       -      R     146           -
LGA    -       -      E     147           -
LGA    -       -      L     148           -
LGA    -       -      Y     149           -
LGA    -       -      A     150           -
LGA    -       -      N     151           -
LGA    -       -      V     152           -
LGA    -       -      V     153           -
LGA    -       -      L     154           -
LGA    -       -      D     156           -
LGA    -       -      D     157           -
LGA    -       -      S     158           -
LGA    -       -      L     159           -
LGA    -       -      N     160           -
LGA    -       -      D     161           -
LGA    -       -      C     162           -
LGA    -       -      R     163           -
LGA    -       -      I     164           -
LGA    -       -      I     165           -
LGA    -       -      F     166           -
LGA    -       -      V     167           -
LGA    -       -      D     168           -
LGA    -       -      E     169           -
LGA    -       -      V     170           -
LGA    -       -      F     171           -
LGA    -       -      K     172           -
LGA    -       -      I     173           -
LGA    -       -      E     174           -
LGA    -       -      R     175           -
LGA    -       -      P     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   68  135    5.0     55    1.87    16.36     37.518     2.790

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.054939 * X  +   0.787448 * Y  +  -0.613928 * Z  +  29.900869
  Y_new =   0.987711 * X  +   0.047239 * Y  +   0.148978 * Z  +  -6.122360
  Z_new =   0.146314 * X  +  -0.614569 * Y  +  -0.775176 * Z  +  12.104486 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.471250    0.670343  [ DEG:  -141.5922     38.4078 ]
  Theta =  -0.146841   -2.994752  [ DEG:    -8.4134   -171.5866 ]
  Phi   =   1.515231   -1.626361  [ DEG:    86.8164    -93.1836 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e5p_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e5p_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   68  135   5.0   55   1.87   16.36  37.518
REMARK  ---------------------------------------------------------- 
MOLECULE 2e5p_A
HEADER    TRANSCRIPTION                           22-DEC-06   2E5P              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 1 (PHF1 PROTEIN)                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 1;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN, RESIDUES 8-62;                               
COMPND   5 SYNONYM: PROTEIN PHF1;                                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF1;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050822-22;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, TUDOR DOMAIN, PHD FINGER PROTEIN 1, PHF1 PROTEIN,                
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   26-JUN-07 2E5P    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 1 (PHF1 PROTEIN)                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E5P A    8    62  UNP    O43189   PHF1_HUMAN      29     83             
SEQRES   1 A   68  GLY SER SER GLY SER SER GLY PRO ARG LEU TRP GLU GLY          
SEQRES   2 A   68  GLN ASP VAL LEU ALA ARG TRP THR ASP GLY LEU LEU TYR          
SEQRES   3 A   68  LEU GLY THR ILE LYS LYS VAL ASP SER ALA ARG GLU VAL          
SEQRES   4 A   68  CYS LEU VAL GLN PHE GLU ASP ASP SER GLN PHE LEU VAL          
SEQRES   5 A   68  LEU TRP LYS ASP ILE SER PRO ALA ALA LEU SER GLY PRO          
SEQRES   6 A   68  SER SER GLY                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      10.971 -25.128  22.787  1.00  0.00           N  
ATOM      2  CA  GLY A   1      11.779 -24.581  23.862  1.00  0.00           C  
ATOM      3  C   GLY A   1      12.655 -23.432  23.401  1.00  0.00           C  
ATOM      4  O   GLY A   1      13.857 -23.603  23.197  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      11.125 -24.229  24.646  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      12.409 -25.364  24.257  1.00  0.00           H  
ATOM      7  H1  GLY A   1      10.474 -24.526  22.196  1.00  0.00           H  
ATOM      8  N   SER A   2      12.052 -22.259  23.237  1.00  0.00           N  
ATOM      9  CA  SER A   2      12.784 -21.079  22.793  1.00  0.00           C  
ATOM     10  C   SER A   2      12.156 -19.807  23.354  1.00  0.00           C  
ATOM     11  O   SER A   2      10.933 -19.675  23.404  1.00  0.00           O  
ATOM     12  CB  SER A   2      12.814 -21.016  21.265  1.00  0.00           C  
ATOM     13  OG  SER A   2      13.814 -21.871  20.739  1.00  0.00           O  
ATOM     14  H   SER A   2      11.091 -22.186  23.417  1.00  0.00           H  
ATOM     15  HA  SER A   2      13.796 -21.159  23.161  1.00  0.00           H  
ATOM     16  HB2 SER A   2      11.855 -21.322  20.876  1.00  0.00           H  
ATOM     17  HB3 SER A   2      13.023 -20.003  20.953  1.00  0.00           H  
ATOM     18  HG  SER A   2      13.497 -22.274  19.927  1.00  0.00           H  
ATOM     19  N   SER A   3      13.002 -18.872  23.774  1.00  0.00           N  
ATOM     20  CA  SER A   3      12.531 -17.611  24.335  1.00  0.00           C  
ATOM     21  C   SER A   3      13.276 -16.431  23.719  1.00  0.00           C  
ATOM     22  O   SER A   3      14.240 -16.610  22.977  1.00  0.00           O  
ATOM     23  CB  SER A   3      12.711 -17.606  25.854  1.00  0.00           C  
ATOM     24  OG  SER A   3      14.064 -17.828  26.209  1.00  0.00           O  
ATOM     25  H   SER A   3      13.966 -19.036  23.708  1.00  0.00           H  
ATOM     26  HA  SER A   3      11.480 -17.518  24.105  1.00  0.00           H  
ATOM     27  HB2 SER A   3      12.401 -16.650  26.248  1.00  0.00           H  
ATOM     28  HB3 SER A   3      12.104 -18.388  26.289  1.00  0.00           H  
ATOM     29  HG  SER A   3      14.634 -17.544  25.491  1.00  0.00           H  
ATOM     30  N   GLY A   4      12.821 -15.222  24.036  1.00  0.00           N  
ATOM     31  CA  GLY A   4      13.455 -14.029  23.505  1.00  0.00           C  
ATOM     32  C   GLY A   4      14.846 -13.812  24.069  1.00  0.00           C  
ATOM     33  O   GLY A   4      15.005 -13.531  25.257  1.00  0.00           O  
ATOM     34  H   GLY A   4      12.049 -15.139  24.633  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      13.523 -14.117  22.432  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      12.844 -13.172  23.748  1.00  0.00           H  
ATOM     37  N   SER A   5      15.855 -13.944  23.215  1.00  0.00           N  
ATOM     38  CA  SER A   5      17.241 -13.766  23.636  1.00  0.00           C  
ATOM     39  C   SER A   5      18.094 -13.236  22.488  1.00  0.00           C  
ATOM     40  O   SER A   5      17.902 -13.613  21.331  1.00  0.00           O  
ATOM     41  CB  SER A   5      17.815 -15.090  24.145  1.00  0.00           C  
ATOM     42  OG  SER A   5      19.087 -14.899  24.740  1.00  0.00           O  
ATOM     43  H   SER A   5      15.665 -14.169  22.280  1.00  0.00           H  
ATOM     44  HA  SER A   5      17.253 -13.045  24.440  1.00  0.00           H  
ATOM     45  HB2 SER A   5      17.147 -15.510  24.880  1.00  0.00           H  
ATOM     46  HB3 SER A   5      17.918 -15.776  23.317  1.00  0.00           H  
ATOM     47  HG  SER A   5      19.543 -14.179  24.296  1.00  0.00           H  
ATOM     48  N   SER A   6      19.037 -12.359  22.815  1.00  0.00           N  
ATOM     49  CA  SER A   6      19.918 -11.774  21.812  1.00  0.00           C  
ATOM     50  C   SER A   6      21.070 -12.718  21.483  1.00  0.00           C  
ATOM     51  O   SER A   6      21.800 -13.158  22.370  1.00  0.00           O  
ATOM     52  CB  SER A   6      20.467 -10.433  22.304  1.00  0.00           C  
ATOM     53  OG  SER A   6      21.273 -10.604  23.457  1.00  0.00           O  
ATOM     54  H   SER A   6      19.141 -12.098  23.754  1.00  0.00           H  
ATOM     55  HA  SER A   6      19.337 -11.608  20.917  1.00  0.00           H  
ATOM     56  HB2 SER A   6      21.065  -9.984  21.526  1.00  0.00           H  
ATOM     57  HB3 SER A   6      19.643  -9.778  22.549  1.00  0.00           H  
ATOM     58  HG  SER A   6      22.007  -9.987  23.430  1.00  0.00           H  
ATOM     59  N   GLY A   7      21.226 -13.026  20.198  1.00  0.00           N  
ATOM     60  CA  GLY A   7      22.290 -13.916  19.773  1.00  0.00           C  
ATOM     61  C   GLY A   7      23.613 -13.196  19.597  1.00  0.00           C  
ATOM     62  O   GLY A   7      24.562 -13.402  20.354  1.00  0.00           O  
ATOM     63  H   GLY A   7      20.614 -12.645  19.534  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      22.411 -14.694  20.513  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      22.012 -14.368  18.832  1.00  0.00           H  
ATOM     66  N   PRO A   8      23.688 -12.331  18.575  1.00  0.00           N  
ATOM     67  CA  PRO A   8      24.901 -11.562  18.278  1.00  0.00           C  
ATOM     68  C   PRO A   8      25.183 -10.495  19.330  1.00  0.00           C  
ATOM     69  O   PRO A   8      24.269 -10.009  19.996  1.00  0.00           O  
ATOM     70  CB  PRO A   8      24.585 -10.911  16.928  1.00  0.00           C  
ATOM     71  CG  PRO A   8      23.099 -10.832  16.883  1.00  0.00           C  
ATOM     72  CD  PRO A   8      22.597 -12.037  17.632  1.00  0.00           C  
ATOM     73  HA  PRO A   8      25.764 -12.203  18.177  1.00  0.00           H  
ATOM     74  HB2 PRO A   8      25.036  -9.929  16.884  1.00  0.00           H  
ATOM     75  HB3 PRO A   8      24.971 -11.526  16.129  1.00  0.00           H  
ATOM     76  HG2 PRO A   8      22.765  -9.926  17.366  1.00  0.00           H  
ATOM     77  HG3 PRO A   8      22.760 -10.861  15.859  1.00  0.00           H  
ATOM     78  HD2 PRO A   8      21.685 -11.800  18.159  1.00  0.00           H  
ATOM     79  HD3 PRO A   8      22.440 -12.863  16.954  1.00  0.00           H  
ATOM     80  N   ARG A   9      26.454 -10.134  19.473  1.00  0.00           N  
ATOM     81  CA  ARG A   9      26.857  -9.126  20.446  1.00  0.00           C  
ATOM     82  C   ARG A   9      27.303  -7.844  19.747  1.00  0.00           C  
ATOM     83  O   ARG A   9      26.860  -6.749  20.095  1.00  0.00           O  
ATOM     84  CB  ARG A   9      27.988  -9.658  21.327  1.00  0.00           C  
ATOM     85  CG  ARG A   9      27.516 -10.603  22.420  1.00  0.00           C  
ATOM     86  CD  ARG A   9      26.952  -9.839  23.610  1.00  0.00           C  
ATOM     87  NE  ARG A   9      27.141 -10.564  24.863  1.00  0.00           N  
ATOM     88  CZ  ARG A   9      27.172  -9.977  26.054  1.00  0.00           C  
ATOM     89  NH1 ARG A   9      27.027  -8.663  26.153  1.00  0.00           N  
ATOM     90  NH2 ARG A   9      27.347 -10.705  27.150  1.00  0.00           N  
ATOM     91  H   ARG A   9      27.138 -10.558  18.914  1.00  0.00           H  
ATOM     92  HA  ARG A   9      26.003  -8.904  21.067  1.00  0.00           H  
ATOM     93  HB2 ARG A   9      28.695 -10.188  20.705  1.00  0.00           H  
ATOM     94  HB3 ARG A   9      28.489  -8.823  21.793  1.00  0.00           H  
ATOM     95  HG2 ARG A   9      26.745 -11.244  22.020  1.00  0.00           H  
ATOM     96  HG3 ARG A   9      28.351 -11.202  22.751  1.00  0.00           H  
ATOM     97  HD2 ARG A   9      27.453  -8.885  23.678  1.00  0.00           H  
ATOM     98  HD3 ARG A   9      25.897  -9.682  23.450  1.00  0.00           H  
ATOM     99  HE  ARG A   9      27.251 -11.537  24.813  1.00  0.00           H  
ATOM    100 HH11 ARG A   9      26.893  -8.112  25.329  1.00  0.00           H  
ATOM    101 HH12 ARG A   9      27.048  -8.223  27.051  1.00  0.00           H  
ATOM    102 HH21 ARG A   9      27.457 -11.696  27.079  1.00  0.00           H  
ATOM    103 HH22 ARG A   9      27.370 -10.262  28.045  1.00  0.00           H  
ATOM    104  N   LEU A  10      28.182  -7.989  18.761  1.00  0.00           N  
ATOM    105  CA  LEU A  10      28.687  -6.844  18.013  1.00  0.00           C  
ATOM    106  C   LEU A  10      29.024  -5.687  18.950  1.00  0.00           C  
ATOM    107  O   LEU A  10      28.696  -4.534  18.669  1.00  0.00           O  
ATOM    108  CB  LEU A  10      27.658  -6.392  16.975  1.00  0.00           C  
ATOM    109  CG  LEU A  10      27.705  -7.111  15.627  1.00  0.00           C  
ATOM    110  CD1 LEU A  10      27.538  -8.611  15.816  1.00  0.00           C  
ATOM    111  CD2 LEU A  10      26.633  -6.566  14.694  1.00  0.00           C  
ATOM    112  H   LEU A  10      28.497  -8.887  18.530  1.00  0.00           H  
ATOM    113  HA  LEU A  10      29.588  -7.153  17.504  1.00  0.00           H  
ATOM    114  HB2 LEU A  10      26.676  -6.543  17.396  1.00  0.00           H  
ATOM    115  HB3 LEU A  10      27.813  -5.337  16.795  1.00  0.00           H  
ATOM    116  HG  LEU A  10      28.669  -6.939  15.167  1.00  0.00           H  
ATOM    117 HD11 LEU A  10      26.509  -8.831  16.053  1.00  0.00           H  
ATOM    118 HD12 LEU A  10      28.173  -8.945  16.622  1.00  0.00           H  
ATOM    119 HD13 LEU A  10      27.815  -9.121  14.904  1.00  0.00           H  
ATOM    120 HD21 LEU A  10      25.668  -6.637  15.176  1.00  0.00           H  
ATOM    121 HD22 LEU A  10      26.622  -7.144  13.781  1.00  0.00           H  
ATOM    122 HD23 LEU A  10      26.847  -5.533  14.465  1.00  0.00           H  
ATOM    123  N   TRP A  11      29.681  -6.004  20.060  1.00  0.00           N  
ATOM    124  CA  TRP A  11      30.064  -4.990  21.036  1.00  0.00           C  
ATOM    125  C   TRP A  11      31.273  -4.198  20.552  1.00  0.00           C  
ATOM    126  O   TRP A  11      31.995  -4.636  19.658  1.00  0.00           O  
ATOM    127  CB  TRP A  11      30.372  -5.644  22.385  1.00  0.00           C  
ATOM    128  CG  TRP A  11      31.505  -6.623  22.325  1.00  0.00           C  
ATOM    129  CD1 TRP A  11      32.753  -6.403  21.817  1.00  0.00           C  
ATOM    130  CD2 TRP A  11      31.491  -7.978  22.788  1.00  0.00           C  
ATOM    131  NE1 TRP A  11      33.517  -7.539  21.937  1.00  0.00           N  
ATOM    132  CE2 TRP A  11      32.766  -8.519  22.529  1.00  0.00           C  
ATOM    133  CE3 TRP A  11      30.527  -8.786  23.397  1.00  0.00           C  
ATOM    134  CZ2 TRP A  11      33.098  -9.830  22.859  1.00  0.00           C  
ATOM    135  CZ3 TRP A  11      30.858 -10.087  23.723  1.00  0.00           C  
ATOM    136  CH2 TRP A  11      32.135 -10.599  23.455  1.00  0.00           C  
ATOM    137  H   TRP A  11      29.914  -6.942  20.226  1.00  0.00           H  
ATOM    138  HA  TRP A  11      29.230  -4.315  21.156  1.00  0.00           H  
ATOM    139  HB2 TRP A  11      30.632  -4.876  23.098  1.00  0.00           H  
ATOM    140  HB3 TRP A  11      29.494  -6.168  22.730  1.00  0.00           H  
ATOM    141  HD1 TRP A  11      33.078  -5.468  21.387  1.00  0.00           H  
ATOM    142  HE1 TRP A  11      34.449  -7.631  21.646  1.00  0.00           H  
ATOM    143  HE3 TRP A  11      29.538  -8.409  23.612  1.00  0.00           H  
ATOM    144  HZ2 TRP A  11      34.077 -10.240  22.659  1.00  0.00           H  
ATOM    145  HZ3 TRP A  11      30.126 -10.726  24.194  1.00  0.00           H  
ATOM    146  HH2 TRP A  11      32.349 -11.621  23.726  1.00  0.00           H  
ATOM    147  N   GLU A  12      31.486  -3.030  21.149  1.00  0.00           N  
ATOM    148  CA  GLU A  12      32.609  -2.177  20.777  1.00  0.00           C  
ATOM    149  C   GLU A  12      33.937  -2.895  21.004  1.00  0.00           C  
ATOM    150  O   GLU A  12      34.273  -3.260  22.130  1.00  0.00           O  
ATOM    151  CB  GLU A  12      32.578  -0.874  21.580  1.00  0.00           C  
ATOM    152  CG  GLU A  12      31.447   0.059  21.182  1.00  0.00           C  
ATOM    153  CD  GLU A  12      31.309   1.242  22.120  1.00  0.00           C  
ATOM    154  OE1 GLU A  12      32.307   1.970  22.307  1.00  0.00           O  
ATOM    155  OE2 GLU A  12      30.205   1.440  22.667  1.00  0.00           O  
ATOM    156  H   GLU A  12      30.875  -2.734  21.855  1.00  0.00           H  
ATOM    157  HA  GLU A  12      32.515  -1.943  19.728  1.00  0.00           H  
ATOM    158  HB2 GLU A  12      32.467  -1.115  22.628  1.00  0.00           H  
ATOM    159  HB3 GLU A  12      33.514  -0.354  21.437  1.00  0.00           H  
ATOM    160  HG2 GLU A  12      31.638   0.430  20.186  1.00  0.00           H  
ATOM    161  HG3 GLU A  12      30.521  -0.496  21.186  1.00  0.00           H  
ATOM    162  N   GLY A  13      34.687  -3.094  19.924  1.00  0.00           N  
ATOM    163  CA  GLY A  13      35.969  -3.768  20.026  1.00  0.00           C  
ATOM    164  C   GLY A  13      35.880  -5.237  19.666  1.00  0.00           C  
ATOM    165  O   GLY A  13      36.696  -6.043  20.116  1.00  0.00           O  
ATOM    166  H   GLY A  13      34.368  -2.781  19.052  1.00  0.00           H  
ATOM    167  HA2 GLY A  13      36.670  -3.286  19.361  1.00  0.00           H  
ATOM    168  HA3 GLY A  13      36.330  -3.679  21.039  1.00  0.00           H  
ATOM    169  N   GLN A  14      34.887  -5.589  18.855  1.00  0.00           N  
ATOM    170  CA  GLN A  14      34.696  -6.973  18.438  1.00  0.00           C  
ATOM    171  C   GLN A  14      35.064  -7.155  16.970  1.00  0.00           C  
ATOM    172  O   GLN A  14      34.448  -6.558  16.086  1.00  0.00           O  
ATOM    173  CB  GLN A  14      33.246  -7.400  18.669  1.00  0.00           C  
ATOM    174  CG  GLN A  14      32.834  -8.619  17.860  1.00  0.00           C  
ATOM    175  CD  GLN A  14      31.381  -8.996  18.069  1.00  0.00           C  
ATOM    176  OE1 GLN A  14      30.605  -9.081  17.116  1.00  0.00           O  
ATOM    177  NE2 GLN A  14      31.003  -9.225  19.321  1.00  0.00           N  
ATOM    178  H   GLN A  14      34.270  -4.902  18.531  1.00  0.00           H  
ATOM    179  HA  GLN A  14      35.344  -7.593  19.039  1.00  0.00           H  
ATOM    180  HB2 GLN A  14      33.112  -7.628  19.716  1.00  0.00           H  
ATOM    181  HB3 GLN A  14      32.594  -6.581  18.402  1.00  0.00           H  
ATOM    182  HG2 GLN A  14      32.987  -8.408  16.812  1.00  0.00           H  
ATOM    183  HG3 GLN A  14      33.453  -9.454  18.152  1.00  0.00           H  
ATOM    184 HE21 GLN A  14      31.674  -9.138  20.030  1.00  0.00           H  
ATOM    185 HE22 GLN A  14      30.069  -9.470  19.486  1.00  0.00           H  
ATOM    186  N   ASP A  15      36.071  -7.982  16.716  1.00  0.00           N  
ATOM    187  CA  ASP A  15      36.522  -8.243  15.353  1.00  0.00           C  
ATOM    188  C   ASP A  15      35.431  -8.939  14.544  1.00  0.00           C  
ATOM    189  O   ASP A  15      35.075 -10.085  14.820  1.00  0.00           O  
ATOM    190  CB  ASP A  15      37.789  -9.101  15.368  1.00  0.00           C  
ATOM    191  CG  ASP A  15      38.855  -8.541  16.289  1.00  0.00           C  
ATOM    192  OD1 ASP A  15      38.641  -8.552  17.519  1.00  0.00           O  
ATOM    193  OD2 ASP A  15      39.904  -8.095  15.780  1.00  0.00           O  
ATOM    194  H   ASP A  15      36.523  -8.429  17.463  1.00  0.00           H  
ATOM    195  HA  ASP A  15      36.745  -7.294  14.890  1.00  0.00           H  
ATOM    196  HB2 ASP A  15      37.538 -10.097  15.702  1.00  0.00           H  
ATOM    197  HB3 ASP A  15      38.192  -9.151  14.368  1.00  0.00           H  
ATOM    198  N   VAL A  16      34.903  -8.238  13.546  1.00  0.00           N  
ATOM    199  CA  VAL A  16      33.853  -8.788  12.697  1.00  0.00           C  
ATOM    200  C   VAL A  16      34.206  -8.641  11.222  1.00  0.00           C  
ATOM    201  O   VAL A  16      35.238  -8.064  10.873  1.00  0.00           O  
ATOM    202  CB  VAL A  16      32.501  -8.101  12.961  1.00  0.00           C  
ATOM    203  CG1 VAL A  16      32.144  -8.173  14.439  1.00  0.00           C  
ATOM    204  CG2 VAL A  16      32.534  -6.658  12.482  1.00  0.00           C  
ATOM    205  H   VAL A  16      35.228  -7.330  13.376  1.00  0.00           H  
ATOM    206  HA  VAL A  16      33.752  -9.838  12.931  1.00  0.00           H  
ATOM    207  HB  VAL A  16      31.739  -8.626  12.404  1.00  0.00           H  
ATOM    208 HG11 VAL A  16      31.118  -7.866  14.576  1.00  0.00           H  
ATOM    209 HG12 VAL A  16      32.268  -9.187  14.790  1.00  0.00           H  
ATOM    210 HG13 VAL A  16      32.793  -7.516  14.997  1.00  0.00           H  
ATOM    211 HG21 VAL A  16      31.536  -6.248  12.505  1.00  0.00           H  
ATOM    212 HG22 VAL A  16      33.175  -6.078  13.131  1.00  0.00           H  
ATOM    213 HG23 VAL A  16      32.916  -6.622  11.473  1.00  0.00           H  
ATOM    214  N   LEU A  17      33.344  -9.164  10.358  1.00  0.00           N  
ATOM    215  CA  LEU A  17      33.564  -9.092   8.917  1.00  0.00           C  
ATOM    216  C   LEU A  17      32.397  -8.395   8.224  1.00  0.00           C  
ATOM    217  O   LEU A  17      31.283  -8.916   8.187  1.00  0.00           O  
ATOM    218  CB  LEU A  17      33.752 -10.495   8.338  1.00  0.00           C  
ATOM    219  CG  LEU A  17      34.784 -11.378   9.039  1.00  0.00           C  
ATOM    220  CD1 LEU A  17      34.791 -12.773   8.437  1.00  0.00           C  
ATOM    221  CD2 LEU A  17      36.168 -10.750   8.955  1.00  0.00           C  
ATOM    222  H   LEU A  17      32.541  -9.612  10.695  1.00  0.00           H  
ATOM    223  HA  LEU A  17      34.462  -8.517   8.748  1.00  0.00           H  
ATOM    224  HB2 LEU A  17      32.800 -11.001   8.382  1.00  0.00           H  
ATOM    225  HB3 LEU A  17      34.054 -10.388   7.306  1.00  0.00           H  
ATOM    226  HG  LEU A  17      34.520 -11.467  10.085  1.00  0.00           H  
ATOM    227 HD11 LEU A  17      34.736 -12.701   7.361  1.00  0.00           H  
ATOM    228 HD12 LEU A  17      33.941 -13.329   8.803  1.00  0.00           H  
ATOM    229 HD13 LEU A  17      35.702 -13.281   8.717  1.00  0.00           H  
ATOM    230 HD21 LEU A  17      36.105  -9.703   9.215  1.00  0.00           H  
ATOM    231 HD22 LEU A  17      36.547 -10.848   7.948  1.00  0.00           H  
ATOM    232 HD23 LEU A  17      36.834 -11.252   9.641  1.00  0.00           H  
ATOM    233  N   ALA A  18      32.663  -7.215   7.673  1.00  0.00           N  
ATOM    234  CA  ALA A  18      31.637  -6.449   6.976  1.00  0.00           C  
ATOM    235  C   ALA A  18      31.651  -6.744   5.480  1.00  0.00           C  
ATOM    236  O   ALA A  18      32.683  -6.609   4.821  1.00  0.00           O  
ATOM    237  CB  ALA A  18      31.830  -4.960   7.224  1.00  0.00           C  
ATOM    238  H   ALA A  18      33.570  -6.852   7.735  1.00  0.00           H  
ATOM    239  HA  ALA A  18      30.676  -6.734   7.379  1.00  0.00           H  
ATOM    240  HB1 ALA A  18      32.444  -4.819   8.102  1.00  0.00           H  
ATOM    241  HB2 ALA A  18      32.313  -4.513   6.369  1.00  0.00           H  
ATOM    242  HB3 ALA A  18      30.867  -4.494   7.379  1.00  0.00           H  
ATOM    243  N   ARG A  19      30.502  -7.149   4.950  1.00  0.00           N  
ATOM    244  CA  ARG A  19      30.384  -7.465   3.531  1.00  0.00           C  
ATOM    245  C   ARG A  19      30.490  -6.202   2.682  1.00  0.00           C  
ATOM    246  O   ARG A  19      30.243  -5.096   3.163  1.00  0.00           O  
ATOM    247  CB  ARG A  19      29.056  -8.170   3.252  1.00  0.00           C  
ATOM    248  CG  ARG A  19      28.928  -8.688   1.829  1.00  0.00           C  
ATOM    249  CD  ARG A  19      27.877  -9.782   1.727  1.00  0.00           C  
ATOM    250  NE  ARG A  19      26.542  -9.291   2.060  1.00  0.00           N  
ATOM    251  CZ  ARG A  19      25.512 -10.086   2.326  1.00  0.00           C  
ATOM    252  NH1 ARG A  19      25.663 -11.403   2.299  1.00  0.00           N  
ATOM    253  NH2 ARG A  19      24.328  -9.564   2.622  1.00  0.00           N  
ATOM    254  H   ARG A  19      29.715  -7.237   5.526  1.00  0.00           H  
ATOM    255  HA  ARG A  19      31.196  -8.129   3.271  1.00  0.00           H  
ATOM    256  HB2 ARG A  19      28.958  -9.009   3.927  1.00  0.00           H  
ATOM    257  HB3 ARG A  19      28.249  -7.476   3.434  1.00  0.00           H  
ATOM    258  HG2 ARG A  19      28.645  -7.870   1.183  1.00  0.00           H  
ATOM    259  HG3 ARG A  19      29.881  -9.085   1.514  1.00  0.00           H  
ATOM    260  HD2 ARG A  19      27.868 -10.160   0.715  1.00  0.00           H  
ATOM    261  HD3 ARG A  19      28.138 -10.577   2.407  1.00  0.00           H  
ATOM    262  HE  ARG A  19      26.408  -8.321   2.086  1.00  0.00           H  
ATOM    263 HH11 ARG A  19      26.554 -11.799   2.078  1.00  0.00           H  
ATOM    264 HH12 ARG A  19      24.886 -12.000   2.502  1.00  0.00           H  
ATOM    265 HH21 ARG A  19      24.210  -8.571   2.643  1.00  0.00           H  
ATOM    266 HH22 ARG A  19      23.554 -10.163   2.822  1.00  0.00           H  
ATOM    267  N   TRP A  20      30.860  -6.374   1.418  1.00  0.00           N  
ATOM    268  CA  TRP A  20      30.999  -5.248   0.502  1.00  0.00           C  
ATOM    269  C   TRP A  20      30.032  -5.376  -0.670  1.00  0.00           C  
ATOM    270  O   TRP A  20      29.466  -6.445  -0.907  1.00  0.00           O  
ATOM    271  CB  TRP A  20      32.437  -5.159  -0.014  1.00  0.00           C  
ATOM    272  CG  TRP A  20      32.857  -3.762  -0.361  1.00  0.00           C  
ATOM    273  CD1 TRP A  20      32.863  -3.193  -1.602  1.00  0.00           C  
ATOM    274  CD2 TRP A  20      33.334  -2.761   0.544  1.00  0.00           C  
ATOM    275  NE1 TRP A  20      33.315  -1.897  -1.523  1.00  0.00           N  
ATOM    276  CE2 TRP A  20      33.610  -1.609  -0.216  1.00  0.00           C  
ATOM    277  CE3 TRP A  20      33.554  -2.726   1.924  1.00  0.00           C  
ATOM    278  CZ2 TRP A  20      34.095  -0.436   0.357  1.00  0.00           C  
ATOM    279  CZ3 TRP A  20      34.035  -1.561   2.492  1.00  0.00           C  
ATOM    280  CH2 TRP A  20      34.301  -0.429   1.710  1.00  0.00           C  
ATOM    281  H   TRP A  20      31.044  -7.281   1.092  1.00  0.00           H  
ATOM    282  HA  TRP A  20      30.765  -4.346   1.049  1.00  0.00           H  
ATOM    283  HB2 TRP A  20      33.108  -5.530   0.745  1.00  0.00           H  
ATOM    284  HB3 TRP A  20      32.530  -5.766  -0.903  1.00  0.00           H  
ATOM    285  HD1 TRP A  20      32.555  -3.698  -2.504  1.00  0.00           H  
ATOM    286  HE1 TRP A  20      33.409  -1.281  -2.279  1.00  0.00           H  
ATOM    287  HE3 TRP A  20      33.356  -3.588   2.544  1.00  0.00           H  
ATOM    288  HZ2 TRP A  20      34.304   0.444  -0.232  1.00  0.00           H  
ATOM    289  HZ3 TRP A  20      34.211  -1.515   3.557  1.00  0.00           H  
ATOM    290  HH2 TRP A  20      34.676   0.458   2.195  1.00  0.00           H  
ATOM    291  N   THR A  21      29.845  -4.282  -1.400  1.00  0.00           N  
ATOM    292  CA  THR A  21      28.946  -4.272  -2.548  1.00  0.00           C  
ATOM    293  C   THR A  21      29.187  -5.481  -3.444  1.00  0.00           C  
ATOM    294  O   THR A  21      28.275  -5.952  -4.125  1.00  0.00           O  
ATOM    295  CB  THR A  21      29.112  -2.988  -3.380  1.00  0.00           C  
ATOM    296  OG1 THR A  21      30.494  -2.774  -3.683  1.00  0.00           O  
ATOM    297  CG2 THR A  21      28.558  -1.783  -2.633  1.00  0.00           C  
ATOM    298  H   THR A  21      30.324  -3.461  -1.161  1.00  0.00           H  
ATOM    299  HA  THR A  21      27.932  -4.308  -2.176  1.00  0.00           H  
ATOM    300  HB  THR A  21      28.563  -3.102  -4.304  1.00  0.00           H  
ATOM    301  HG1 THR A  21      30.898  -3.606  -3.943  1.00  0.00           H  
ATOM    302 HG21 THR A  21      28.166  -1.069  -3.341  1.00  0.00           H  
ATOM    303 HG22 THR A  21      29.348  -1.324  -2.057  1.00  0.00           H  
ATOM    304 HG23 THR A  21      27.769  -2.103  -1.970  1.00  0.00           H  
ATOM    305  N   ASP A  22      30.419  -5.977  -3.442  1.00  0.00           N  
ATOM    306  CA  ASP A  22      30.779  -7.133  -4.255  1.00  0.00           C  
ATOM    307  C   ASP A  22      30.104  -8.397  -3.732  1.00  0.00           C  
ATOM    308  O   ASP A  22      29.614  -9.218  -4.507  1.00  0.00           O  
ATOM    309  CB  ASP A  22      32.297  -7.320  -4.271  1.00  0.00           C  
ATOM    310  CG  ASP A  22      32.788  -7.964  -5.552  1.00  0.00           C  
ATOM    311  OD1 ASP A  22      32.157  -8.942  -6.004  1.00  0.00           O  
ATOM    312  OD2 ASP A  22      33.803  -7.491  -6.103  1.00  0.00           O  
ATOM    313  H   ASP A  22      31.102  -5.558  -2.879  1.00  0.00           H  
ATOM    314  HA  ASP A  22      30.438  -6.949  -5.263  1.00  0.00           H  
ATOM    315  HB2 ASP A  22      32.772  -6.355  -4.170  1.00  0.00           H  
ATOM    316  HB3 ASP A  22      32.585  -7.947  -3.440  1.00  0.00           H  
ATOM    317  N   GLY A  23      30.085  -8.548  -2.411  1.00  0.00           N  
ATOM    318  CA  GLY A  23      29.469  -9.715  -1.807  1.00  0.00           C  
ATOM    319  C   GLY A  23      30.366 -10.379  -0.781  1.00  0.00           C  
ATOM    320  O   GLY A  23      29.889 -10.883   0.237  1.00  0.00           O  
ATOM    321  H   GLY A  23      30.491  -7.862  -1.843  1.00  0.00           H  
ATOM    322  HA2 GLY A  23      28.549  -9.416  -1.327  1.00  0.00           H  
ATOM    323  HA3 GLY A  23      29.241 -10.431  -2.585  1.00  0.00           H  
ATOM    324  N   LEU A  24      31.666 -10.379  -1.048  1.00  0.00           N  
ATOM    325  CA  LEU A  24      32.633 -10.988  -0.139  1.00  0.00           C  
ATOM    326  C   LEU A  24      32.641 -10.270   1.207  1.00  0.00           C  
ATOM    327  O   LEU A  24      32.093  -9.176   1.342  1.00  0.00           O  
ATOM    328  CB  LEU A  24      34.032 -10.954  -0.756  1.00  0.00           C  
ATOM    329  CG  LEU A  24      34.296 -11.961  -1.877  1.00  0.00           C  
ATOM    330  CD1 LEU A  24      34.236 -13.383  -1.342  1.00  0.00           C  
ATOM    331  CD2 LEU A  24      33.297 -11.772  -3.009  1.00  0.00           C  
ATOM    332  H   LEU A  24      31.987  -9.963  -1.874  1.00  0.00           H  
ATOM    333  HA  LEU A  24      32.341 -12.015   0.015  1.00  0.00           H  
ATOM    334  HB2 LEU A  24      34.195  -9.965  -1.155  1.00  0.00           H  
ATOM    335  HB3 LEU A  24      34.746 -11.143   0.034  1.00  0.00           H  
ATOM    336  HG  LEU A  24      35.288 -11.796  -2.274  1.00  0.00           H  
ATOM    337 HD11 LEU A  24      33.257 -13.571  -0.927  1.00  0.00           H  
ATOM    338 HD12 LEU A  24      34.983 -13.511  -0.573  1.00  0.00           H  
ATOM    339 HD13 LEU A  24      34.426 -14.079  -2.147  1.00  0.00           H  
ATOM    340 HD21 LEU A  24      32.295 -11.907  -2.630  1.00  0.00           H  
ATOM    341 HD22 LEU A  24      33.490 -12.499  -3.784  1.00  0.00           H  
ATOM    342 HD23 LEU A  24      33.398 -10.777  -3.415  1.00  0.00           H  
ATOM    343  N   LEU A  25      33.267 -10.893   2.199  1.00  0.00           N  
ATOM    344  CA  LEU A  25      33.350 -10.314   3.535  1.00  0.00           C  
ATOM    345  C   LEU A  25      34.667  -9.568   3.725  1.00  0.00           C  
ATOM    346  O   LEU A  25      35.723 -10.035   3.302  1.00  0.00           O  
ATOM    347  CB  LEU A  25      33.212 -11.407   4.596  1.00  0.00           C  
ATOM    348  CG  LEU A  25      31.944 -12.257   4.522  1.00  0.00           C  
ATOM    349  CD1 LEU A  25      31.977 -13.357   5.571  1.00  0.00           C  
ATOM    350  CD2 LEU A  25      30.707 -11.389   4.695  1.00  0.00           C  
ATOM    351  H   LEU A  25      33.686 -11.763   2.031  1.00  0.00           H  
ATOM    352  HA  LEU A  25      32.535  -9.613   3.643  1.00  0.00           H  
ATOM    353  HB2 LEU A  25      34.060 -12.067   4.503  1.00  0.00           H  
ATOM    354  HB3 LEU A  25      33.235 -10.930   5.567  1.00  0.00           H  
ATOM    355  HG  LEU A  25      31.890 -12.727   3.549  1.00  0.00           H  
ATOM    356 HD11 LEU A  25      31.632 -12.965   6.516  1.00  0.00           H  
ATOM    357 HD12 LEU A  25      32.989 -13.720   5.680  1.00  0.00           H  
ATOM    358 HD13 LEU A  25      31.335 -14.170   5.261  1.00  0.00           H  
ATOM    359 HD21 LEU A  25      29.847 -12.019   4.870  1.00  0.00           H  
ATOM    360 HD22 LEU A  25      30.549 -10.804   3.801  1.00  0.00           H  
ATOM    361 HD23 LEU A  25      30.847 -10.729   5.539  1.00  0.00           H  
ATOM    362  N   TYR A  26      34.596  -8.406   4.367  1.00  0.00           N  
ATOM    363  CA  TYR A  26      35.782  -7.595   4.613  1.00  0.00           C  
ATOM    364  C   TYR A  26      36.053  -7.468   6.109  1.00  0.00           C  
ATOM    365  O   TYR A  26      35.130  -7.488   6.924  1.00  0.00           O  
ATOM    366  CB  TYR A  26      35.615  -6.208   3.993  1.00  0.00           C  
ATOM    367  CG  TYR A  26      35.683  -6.207   2.483  1.00  0.00           C  
ATOM    368  CD1 TYR A  26      34.915  -7.088   1.732  1.00  0.00           C  
ATOM    369  CD2 TYR A  26      36.516  -5.324   1.806  1.00  0.00           C  
ATOM    370  CE1 TYR A  26      34.974  -7.091   0.352  1.00  0.00           C  
ATOM    371  CE2 TYR A  26      36.580  -5.320   0.426  1.00  0.00           C  
ATOM    372  CZ  TYR A  26      35.808  -6.205  -0.297  1.00  0.00           C  
ATOM    373  OH  TYR A  26      35.869  -6.205  -1.671  1.00  0.00           O  
ATOM    374  H   TYR A  26      33.725  -8.086   4.681  1.00  0.00           H  
ATOM    375  HA  TYR A  26      36.623  -8.089   4.147  1.00  0.00           H  
ATOM    376  HB2 TYR A  26      34.656  -5.805   4.282  1.00  0.00           H  
ATOM    377  HB3 TYR A  26      36.397  -5.559   4.361  1.00  0.00           H  
ATOM    378  HD1 TYR A  26      34.261  -7.781   2.245  1.00  0.00           H  
ATOM    379  HD2 TYR A  26      37.120  -4.632   2.374  1.00  0.00           H  
ATOM    380  HE1 TYR A  26      34.369  -7.785  -0.214  1.00  0.00           H  
ATOM    381  HE2 TYR A  26      37.234  -4.626  -0.083  1.00  0.00           H  
ATOM    382  HH  TYR A  26      36.781  -6.084  -1.950  1.00  0.00           H  
ATOM    383  N   LEU A  27      37.327  -7.334   6.464  1.00  0.00           N  
ATOM    384  CA  LEU A  27      37.722  -7.200   7.862  1.00  0.00           C  
ATOM    385  C   LEU A  27      37.277  -5.856   8.428  1.00  0.00           C  
ATOM    386  O   LEU A  27      37.669  -4.801   7.931  1.00  0.00           O  
ATOM    387  CB  LEU A  27      39.239  -7.348   7.999  1.00  0.00           C  
ATOM    388  CG  LEU A  27      39.738  -7.934   9.320  1.00  0.00           C  
ATOM    389  CD1 LEU A  27      41.194  -8.357   9.200  1.00  0.00           C  
ATOM    390  CD2 LEU A  27      39.566  -6.927  10.449  1.00  0.00           C  
ATOM    391  H   LEU A  27      38.018  -7.323   5.770  1.00  0.00           H  
ATOM    392  HA  LEU A  27      37.239  -7.989   8.418  1.00  0.00           H  
ATOM    393  HB2 LEU A  27      39.581  -7.990   7.203  1.00  0.00           H  
ATOM    394  HB3 LEU A  27      39.678  -6.367   7.884  1.00  0.00           H  
ATOM    395  HG  LEU A  27      39.154  -8.811   9.562  1.00  0.00           H  
ATOM    396 HD11 LEU A  27      41.385  -8.708   8.197  1.00  0.00           H  
ATOM    397 HD12 LEU A  27      41.398  -9.150   9.905  1.00  0.00           H  
ATOM    398 HD13 LEU A  27      41.832  -7.512   9.415  1.00  0.00           H  
ATOM    399 HD21 LEU A  27      38.735  -6.274  10.225  1.00  0.00           H  
ATOM    400 HD22 LEU A  27      40.468  -6.341  10.550  1.00  0.00           H  
ATOM    401 HD23 LEU A  27      39.371  -7.452  11.373  1.00  0.00           H  
ATOM    402  N   GLY A  28      36.457  -5.902   9.473  1.00  0.00           N  
ATOM    403  CA  GLY A  28      35.973  -4.681  10.092  1.00  0.00           C  
ATOM    404  C   GLY A  28      35.973  -4.759  11.605  1.00  0.00           C  
ATOM    405  O   GLY A  28      35.814  -5.836  12.180  1.00  0.00           O  
ATOM    406  H   GLY A  28      36.177  -6.772   9.828  1.00  0.00           H  
ATOM    407  HA2 GLY A  28      36.604  -3.860   9.783  1.00  0.00           H  
ATOM    408  HA3 GLY A  28      34.965  -4.494   9.752  1.00  0.00           H  
ATOM    409  N   THR A  29      36.153  -3.613  12.255  1.00  0.00           N  
ATOM    410  CA  THR A  29      36.176  -3.556  13.712  1.00  0.00           C  
ATOM    411  C   THR A  29      34.995  -2.755  14.249  1.00  0.00           C  
ATOM    412  O   THR A  29      34.789  -1.603  13.865  1.00  0.00           O  
ATOM    413  CB  THR A  29      37.485  -2.930  14.228  1.00  0.00           C  
ATOM    414  OG1 THR A  29      38.602  -3.737  13.839  1.00  0.00           O  
ATOM    415  CG2 THR A  29      37.456  -2.789  15.743  1.00  0.00           C  
ATOM    416  H   THR A  29      36.275  -2.787  11.741  1.00  0.00           H  
ATOM    417  HA  THR A  29      36.113  -4.566  14.086  1.00  0.00           H  
ATOM    418  HB  THR A  29      37.593  -1.946  13.792  1.00  0.00           H  
ATOM    419  HG1 THR A  29      38.382  -4.224  13.042  1.00  0.00           H  
ATOM    420 HG21 THR A  29      38.343  -3.240  16.162  1.00  0.00           H  
ATOM    421 HG22 THR A  29      36.580  -3.285  16.133  1.00  0.00           H  
ATOM    422 HG23 THR A  29      37.426  -1.743  16.006  1.00  0.00           H  
ATOM    423  N   ILE A  30      34.224  -3.370  15.138  1.00  0.00           N  
ATOM    424  CA  ILE A  30      33.066  -2.713  15.729  1.00  0.00           C  
ATOM    425  C   ILE A  30      33.471  -1.439  16.463  1.00  0.00           C  
ATOM    426  O   ILE A  30      33.958  -1.488  17.593  1.00  0.00           O  
ATOM    427  CB  ILE A  30      32.330  -3.644  16.710  1.00  0.00           C  
ATOM    428  CG1 ILE A  30      31.863  -4.912  15.990  1.00  0.00           C  
ATOM    429  CG2 ILE A  30      31.149  -2.922  17.342  1.00  0.00           C  
ATOM    430  CD1 ILE A  30      30.753  -4.665  14.991  1.00  0.00           C  
ATOM    431  H   ILE A  30      34.441  -4.288  15.404  1.00  0.00           H  
ATOM    432  HA  ILE A  30      32.387  -2.454  14.930  1.00  0.00           H  
ATOM    433  HB  ILE A  30      33.016  -3.918  17.497  1.00  0.00           H  
ATOM    434 HG12 ILE A  30      32.695  -5.344  15.460  1.00  0.00           H  
ATOM    435 HG13 ILE A  30      31.500  -5.619  16.722  1.00  0.00           H  
ATOM    436 HG21 ILE A  30      31.222  -2.985  18.417  1.00  0.00           H  
ATOM    437 HG22 ILE A  30      31.160  -1.885  17.042  1.00  0.00           H  
ATOM    438 HG23 ILE A  30      30.228  -3.382  17.016  1.00  0.00           H  
ATOM    439 HD11 ILE A  30      31.111  -4.883  13.996  1.00  0.00           H  
ATOM    440 HD12 ILE A  30      29.913  -5.302  15.221  1.00  0.00           H  
ATOM    441 HD13 ILE A  30      30.446  -3.631  15.043  1.00  0.00           H  
ATOM    442  N   LYS A  31      33.267  -0.298  15.814  1.00  0.00           N  
ATOM    443  CA  LYS A  31      33.607   0.991  16.405  1.00  0.00           C  
ATOM    444  C   LYS A  31      32.454   1.526  17.247  1.00  0.00           C  
ATOM    445  O   LYS A  31      32.660   2.039  18.346  1.00  0.00           O  
ATOM    446  CB  LYS A  31      33.964   1.998  15.310  1.00  0.00           C  
ATOM    447  CG  LYS A  31      34.797   1.408  14.186  1.00  0.00           C  
ATOM    448  CD  LYS A  31      36.055   0.740  14.717  1.00  0.00           C  
ATOM    449  CE  LYS A  31      37.205   1.729  14.832  1.00  0.00           C  
ATOM    450  NZ  LYS A  31      38.528   1.060  14.692  1.00  0.00           N  
ATOM    451  H   LYS A  31      32.875  -0.324  14.915  1.00  0.00           H  
ATOM    452  HA  LYS A  31      34.466   0.847  17.042  1.00  0.00           H  
ATOM    453  HB2 LYS A  31      33.050   2.388  14.885  1.00  0.00           H  
ATOM    454  HB3 LYS A  31      34.520   2.812  15.753  1.00  0.00           H  
ATOM    455  HG2 LYS A  31      34.208   0.671  13.660  1.00  0.00           H  
ATOM    456  HG3 LYS A  31      35.080   2.197  13.505  1.00  0.00           H  
ATOM    457  HD2 LYS A  31      35.849   0.330  15.695  1.00  0.00           H  
ATOM    458  HD3 LYS A  31      36.342  -0.055  14.044  1.00  0.00           H  
ATOM    459  HE2 LYS A  31      37.102   2.472  14.057  1.00  0.00           H  
ATOM    460  HE3 LYS A  31      37.155   2.209  15.799  1.00  0.00           H  
ATOM    461  HZ1 LYS A  31      38.734   0.495  15.540  1.00  0.00           H  
ATOM    462  HZ2 LYS A  31      39.277   1.771  14.573  1.00  0.00           H  
ATOM    463  HZ3 LYS A  31      38.526   0.433  13.862  1.00  0.00           H  
ATOM    464  N   LYS A  32      31.239   1.401  16.724  1.00  0.00           N  
ATOM    465  CA  LYS A  32      30.051   1.869  17.428  1.00  0.00           C  
ATOM    466  C   LYS A  32      28.891   0.895  17.245  1.00  0.00           C  
ATOM    467  O   LYS A  32      28.860   0.124  16.286  1.00  0.00           O  
ATOM    468  CB  LYS A  32      29.648   3.257  16.926  1.00  0.00           C  
ATOM    469  CG  LYS A  32      28.844   4.059  17.934  1.00  0.00           C  
ATOM    470  CD  LYS A  32      28.096   5.203  17.267  1.00  0.00           C  
ATOM    471  CE  LYS A  32      28.933   6.472  17.236  1.00  0.00           C  
ATOM    472  NZ  LYS A  32      28.949   7.159  18.556  1.00  0.00           N  
ATOM    473  H   LYS A  32      31.138   0.982  15.843  1.00  0.00           H  
ATOM    474  HA  LYS A  32      30.290   1.931  18.478  1.00  0.00           H  
ATOM    475  HB2 LYS A  32      30.543   3.813  16.687  1.00  0.00           H  
ATOM    476  HB3 LYS A  32      29.055   3.145  16.030  1.00  0.00           H  
ATOM    477  HG2 LYS A  32      28.129   3.406  18.412  1.00  0.00           H  
ATOM    478  HG3 LYS A  32      29.516   4.465  18.677  1.00  0.00           H  
ATOM    479  HD2 LYS A  32      27.852   4.920  16.254  1.00  0.00           H  
ATOM    480  HD3 LYS A  32      27.186   5.395  17.818  1.00  0.00           H  
ATOM    481  HE2 LYS A  32      29.944   6.214  16.962  1.00  0.00           H  
ATOM    482  HE3 LYS A  32      28.519   7.141  16.496  1.00  0.00           H  
ATOM    483  HZ1 LYS A  32      29.572   7.992  18.518  1.00  0.00           H  
ATOM    484  HZ2 LYS A  32      29.297   6.513  19.292  1.00  0.00           H  
ATOM    485  HZ3 LYS A  32      27.989   7.470  18.809  1.00  0.00           H  
ATOM    486  N   VAL A  33      27.936   0.937  18.170  1.00  0.00           N  
ATOM    487  CA  VAL A  33      26.773   0.060  18.109  1.00  0.00           C  
ATOM    488  C   VAL A  33      25.496   0.818  18.452  1.00  0.00           C  
ATOM    489  O   VAL A  33      25.294   1.231  19.594  1.00  0.00           O  
ATOM    490  CB  VAL A  33      26.921  -1.136  19.067  1.00  0.00           C  
ATOM    491  CG1 VAL A  33      27.360  -0.665  20.446  1.00  0.00           C  
ATOM    492  CG2 VAL A  33      25.617  -1.914  19.152  1.00  0.00           C  
ATOM    493  H   VAL A  33      28.017   1.574  18.911  1.00  0.00           H  
ATOM    494  HA  VAL A  33      26.695  -0.321  17.100  1.00  0.00           H  
ATOM    495  HB  VAL A  33      27.684  -1.793  18.676  1.00  0.00           H  
ATOM    496 HG11 VAL A  33      27.665  -1.517  21.036  1.00  0.00           H  
ATOM    497 HG12 VAL A  33      28.189   0.020  20.345  1.00  0.00           H  
ATOM    498 HG13 VAL A  33      26.537  -0.165  20.934  1.00  0.00           H  
ATOM    499 HG21 VAL A  33      25.802  -2.875  19.610  1.00  0.00           H  
ATOM    500 HG22 VAL A  33      24.906  -1.363  19.748  1.00  0.00           H  
ATOM    501 HG23 VAL A  33      25.219  -2.060  18.159  1.00  0.00           H  
ATOM    502  N   ASP A  34      24.634   0.996  17.457  1.00  0.00           N  
ATOM    503  CA  ASP A  34      23.374   1.703  17.652  1.00  0.00           C  
ATOM    504  C   ASP A  34      22.202   0.727  17.672  1.00  0.00           C  
ATOM    505  O   ASP A  34      21.991  -0.024  16.721  1.00  0.00           O  
ATOM    506  CB  ASP A  34      23.171   2.742  16.549  1.00  0.00           C  
ATOM    507  CG  ASP A  34      23.751   4.094  16.914  1.00  0.00           C  
ATOM    508  OD1 ASP A  34      23.370   4.638  17.973  1.00  0.00           O  
ATOM    509  OD2 ASP A  34      24.584   4.610  16.141  1.00  0.00           O  
ATOM    510  H   ASP A  34      24.852   0.643  16.567  1.00  0.00           H  
ATOM    511  HA  ASP A  34      23.423   2.208  18.605  1.00  0.00           H  
ATOM    512  HB2 ASP A  34      23.652   2.398  15.645  1.00  0.00           H  
ATOM    513  HB3 ASP A  34      22.113   2.861  16.366  1.00  0.00           H  
ATOM    514  N   SER A  35      21.442   0.746  18.763  1.00  0.00           N  
ATOM    515  CA  SER A  35      20.293  -0.141  18.909  1.00  0.00           C  
ATOM    516  C   SER A  35      19.079   0.417  18.171  1.00  0.00           C  
ATOM    517  O   SER A  35      18.315  -0.329  17.558  1.00  0.00           O  
ATOM    518  CB  SER A  35      19.958  -0.338  20.389  1.00  0.00           C  
ATOM    519  OG  SER A  35      19.217   0.759  20.894  1.00  0.00           O  
ATOM    520  H   SER A  35      21.661   1.368  19.488  1.00  0.00           H  
ATOM    521  HA  SER A  35      20.554  -1.096  18.477  1.00  0.00           H  
ATOM    522  HB2 SER A  35      19.374  -1.237  20.507  1.00  0.00           H  
ATOM    523  HB3 SER A  35      20.876  -0.428  20.953  1.00  0.00           H  
ATOM    524  HG  SER A  35      18.307   0.490  21.040  1.00  0.00           H  
ATOM    525  N   ALA A  36      18.909   1.733  18.237  1.00  0.00           N  
ATOM    526  CA  ALA A  36      17.791   2.392  17.573  1.00  0.00           C  
ATOM    527  C   ALA A  36      17.664   1.935  16.124  1.00  0.00           C  
ATOM    528  O   ALA A  36      16.618   1.436  15.711  1.00  0.00           O  
ATOM    529  CB  ALA A  36      17.954   3.903  17.640  1.00  0.00           C  
ATOM    530  H   ALA A  36      19.552   2.274  18.741  1.00  0.00           H  
ATOM    531  HA  ALA A  36      16.886   2.129  18.105  1.00  0.00           H  
ATOM    532  HB1 ALA A  36      16.979   4.370  17.648  1.00  0.00           H  
ATOM    533  HB2 ALA A  36      18.487   4.168  18.541  1.00  0.00           H  
ATOM    534  HB3 ALA A  36      18.509   4.243  16.780  1.00  0.00           H  
ATOM    535  N   ARG A  37      18.735   2.110  15.358  1.00  0.00           N  
ATOM    536  CA  ARG A  37      18.743   1.717  13.955  1.00  0.00           C  
ATOM    537  C   ARG A  37      19.266   0.293  13.791  1.00  0.00           C  
ATOM    538  O   ARG A  37      19.415  -0.199  12.674  1.00  0.00           O  
ATOM    539  CB  ARG A  37      19.601   2.685  13.137  1.00  0.00           C  
ATOM    540  CG  ARG A  37      18.875   3.961  12.744  1.00  0.00           C  
ATOM    541  CD  ARG A  37      19.536   4.634  11.552  1.00  0.00           C  
ATOM    542  NE  ARG A  37      19.319   3.890  10.314  1.00  0.00           N  
ATOM    543  CZ  ARG A  37      19.617   4.365   9.109  1.00  0.00           C  
ATOM    544  NH1 ARG A  37      20.142   5.576   8.982  1.00  0.00           N  
ATOM    545  NH2 ARG A  37      19.389   3.628   8.029  1.00  0.00           N  
ATOM    546  H   ARG A  37      19.540   2.514  15.745  1.00  0.00           H  
ATOM    547  HA  ARG A  37      17.726   1.759  13.592  1.00  0.00           H  
ATOM    548  HB2 ARG A  37      20.471   2.955  13.718  1.00  0.00           H  
ATOM    549  HB3 ARG A  37      19.922   2.186  12.234  1.00  0.00           H  
ATOM    550  HG2 ARG A  37      17.854   3.719  12.486  1.00  0.00           H  
ATOM    551  HG3 ARG A  37      18.885   4.641  13.582  1.00  0.00           H  
ATOM    552  HD2 ARG A  37      19.125   5.626  11.441  1.00  0.00           H  
ATOM    553  HD3 ARG A  37      20.598   4.703  11.738  1.00  0.00           H  
ATOM    554  HE  ARG A  37      18.932   2.993  10.385  1.00  0.00           H  
ATOM    555 HH11 ARG A  37      20.315   6.133   9.794  1.00  0.00           H  
ATOM    556 HH12 ARG A  37      20.366   5.931   8.074  1.00  0.00           H  
ATOM    557 HH21 ARG A  37      18.994   2.715   8.121  1.00  0.00           H  
ATOM    558 HH22 ARG A  37      19.613   3.987   7.123  1.00  0.00           H  
ATOM    559  N   GLU A  38      19.544  -0.362  14.915  1.00  0.00           N  
ATOM    560  CA  GLU A  38      20.053  -1.729  14.894  1.00  0.00           C  
ATOM    561  C   GLU A  38      21.227  -1.858  13.929  1.00  0.00           C  
ATOM    562  O   GLU A  38      21.222  -2.708  13.038  1.00  0.00           O  
ATOM    563  CB  GLU A  38      18.942  -2.703  14.498  1.00  0.00           C  
ATOM    564  CG  GLU A  38      17.945  -2.976  15.612  1.00  0.00           C  
ATOM    565  CD  GLU A  38      17.196  -4.281  15.418  1.00  0.00           C  
ATOM    566  OE1 GLU A  38      16.430  -4.384  14.437  1.00  0.00           O  
ATOM    567  OE2 GLU A  38      17.375  -5.196  16.247  1.00  0.00           O  
ATOM    568  H   GLU A  38      19.405   0.084  15.775  1.00  0.00           H  
ATOM    569  HA  GLU A  38      20.392  -1.971  15.890  1.00  0.00           H  
ATOM    570  HB2 GLU A  38      18.406  -2.296  13.654  1.00  0.00           H  
ATOM    571  HB3 GLU A  38      19.391  -3.642  14.208  1.00  0.00           H  
ATOM    572  HG2 GLU A  38      18.476  -3.020  16.550  1.00  0.00           H  
ATOM    573  HG3 GLU A  38      17.229  -2.167  15.642  1.00  0.00           H  
ATOM    574  N   VAL A  39      22.233  -1.009  14.112  1.00  0.00           N  
ATOM    575  CA  VAL A  39      23.415  -1.028  13.259  1.00  0.00           C  
ATOM    576  C   VAL A  39      24.693  -0.979  14.088  1.00  0.00           C  
ATOM    577  O   VAL A  39      24.644  -0.907  15.317  1.00  0.00           O  
ATOM    578  CB  VAL A  39      23.412   0.153  12.270  1.00  0.00           C  
ATOM    579  CG1 VAL A  39      22.005   0.419  11.759  1.00  0.00           C  
ATOM    580  CG2 VAL A  39      23.995   1.396  12.925  1.00  0.00           C  
ATOM    581  H   VAL A  39      22.179  -0.354  14.839  1.00  0.00           H  
ATOM    582  HA  VAL A  39      23.401  -1.947  12.690  1.00  0.00           H  
ATOM    583  HB  VAL A  39      24.034  -0.108  11.427  1.00  0.00           H  
ATOM    584 HG11 VAL A  39      22.053   1.061  10.891  1.00  0.00           H  
ATOM    585 HG12 VAL A  39      21.536  -0.516  11.491  1.00  0.00           H  
ATOM    586 HG13 VAL A  39      21.426   0.904  12.532  1.00  0.00           H  
ATOM    587 HG21 VAL A  39      25.023   1.212  13.197  1.00  0.00           H  
ATOM    588 HG22 VAL A  39      23.948   2.225  12.232  1.00  0.00           H  
ATOM    589 HG23 VAL A  39      23.425   1.637  13.811  1.00  0.00           H  
ATOM    590  N   CYS A  40      25.834  -1.020  13.410  1.00  0.00           N  
ATOM    591  CA  CYS A  40      27.126  -0.981  14.085  1.00  0.00           C  
ATOM    592  C   CYS A  40      28.176  -0.302  13.210  1.00  0.00           C  
ATOM    593  O   CYS A  40      28.483  -0.769  12.113  1.00  0.00           O  
ATOM    594  CB  CYS A  40      27.581  -2.396  14.442  1.00  0.00           C  
ATOM    595  SG  CYS A  40      26.514  -3.236  15.637  1.00  0.00           S  
ATOM    596  H   CYS A  40      25.808  -1.077  12.432  1.00  0.00           H  
ATOM    597  HA  CYS A  40      27.008  -0.410  14.993  1.00  0.00           H  
ATOM    598  HB2 CYS A  40      27.604  -2.997  13.544  1.00  0.00           H  
ATOM    599  HB3 CYS A  40      28.576  -2.351  14.860  1.00  0.00           H  
ATOM    600  HG  CYS A  40      27.190  -3.362  16.769  1.00  0.00           H  
ATOM    601  N   LEU A  41      28.723   0.805  13.703  1.00  0.00           N  
ATOM    602  CA  LEU A  41      29.737   1.550  12.966  1.00  0.00           C  
ATOM    603  C   LEU A  41      31.062   0.795  12.949  1.00  0.00           C  
ATOM    604  O   LEU A  41      31.768   0.735  13.956  1.00  0.00           O  
ATOM    605  CB  LEU A  41      29.933   2.934  13.589  1.00  0.00           C  
ATOM    606  CG  LEU A  41      30.823   3.900  12.807  1.00  0.00           C  
ATOM    607  CD1 LEU A  41      29.995   4.715  11.826  1.00  0.00           C  
ATOM    608  CD2 LEU A  41      31.579   4.816  13.758  1.00  0.00           C  
ATOM    609  H   LEU A  41      28.438   1.127  14.583  1.00  0.00           H  
ATOM    610  HA  LEU A  41      29.389   1.667  11.950  1.00  0.00           H  
ATOM    611  HB2 LEU A  41      28.961   3.390  13.691  1.00  0.00           H  
ATOM    612  HB3 LEU A  41      30.371   2.796  14.567  1.00  0.00           H  
ATOM    613  HG  LEU A  41      31.549   3.333  12.240  1.00  0.00           H  
ATOM    614 HD11 LEU A  41      29.891   5.725  12.194  1.00  0.00           H  
ATOM    615 HD12 LEU A  41      29.017   4.268  11.722  1.00  0.00           H  
ATOM    616 HD13 LEU A  41      30.488   4.730  10.864  1.00  0.00           H  
ATOM    617 HD21 LEU A  41      32.036   5.619  13.198  1.00  0.00           H  
ATOM    618 HD22 LEU A  41      32.347   4.251  14.269  1.00  0.00           H  
ATOM    619 HD23 LEU A  41      30.893   5.228  14.483  1.00  0.00           H  
ATOM    620  N   VAL A  42      31.396   0.221  11.797  1.00  0.00           N  
ATOM    621  CA  VAL A  42      32.639  -0.527  11.648  1.00  0.00           C  
ATOM    622  C   VAL A  42      33.658   0.259  10.832  1.00  0.00           C  
ATOM    623  O   VAL A  42      33.295   1.046   9.958  1.00  0.00           O  
ATOM    624  CB  VAL A  42      32.395  -1.888  10.970  1.00  0.00           C  
ATOM    625  CG1 VAL A  42      33.695  -2.670  10.858  1.00  0.00           C  
ATOM    626  CG2 VAL A  42      31.349  -2.685  11.735  1.00  0.00           C  
ATOM    627  H   VAL A  42      30.792   0.304  11.030  1.00  0.00           H  
ATOM    628  HA  VAL A  42      33.041  -0.707  12.634  1.00  0.00           H  
ATOM    629  HB  VAL A  42      32.023  -1.710   9.972  1.00  0.00           H  
ATOM    630 HG11 VAL A  42      34.344  -2.406  11.681  1.00  0.00           H  
ATOM    631 HG12 VAL A  42      33.484  -3.728  10.892  1.00  0.00           H  
ATOM    632 HG13 VAL A  42      34.182  -2.428   9.925  1.00  0.00           H  
ATOM    633 HG21 VAL A  42      30.623  -2.008  12.162  1.00  0.00           H  
ATOM    634 HG22 VAL A  42      30.850  -3.367  11.061  1.00  0.00           H  
ATOM    635 HG23 VAL A  42      31.827  -3.245  12.524  1.00  0.00           H  
ATOM    636  N   GLN A  43      34.936   0.040  11.124  1.00  0.00           N  
ATOM    637  CA  GLN A  43      36.009   0.729  10.417  1.00  0.00           C  
ATOM    638  C   GLN A  43      36.783  -0.238   9.526  1.00  0.00           C  
ATOM    639  O   GLN A  43      36.880  -1.429   9.822  1.00  0.00           O  
ATOM    640  CB  GLN A  43      36.960   1.394  11.413  1.00  0.00           C  
ATOM    641  CG  GLN A  43      38.258   1.878  10.786  1.00  0.00           C  
ATOM    642  CD  GLN A  43      39.330   2.173  11.817  1.00  0.00           C  
ATOM    643  OE1 GLN A  43      40.023   1.269  12.285  1.00  0.00           O  
ATOM    644  NE2 GLN A  43      39.472   3.443  12.177  1.00  0.00           N  
ATOM    645  H   GLN A  43      35.163  -0.599  11.830  1.00  0.00           H  
ATOM    646  HA  GLN A  43      35.562   1.491   9.796  1.00  0.00           H  
ATOM    647  HB2 GLN A  43      36.462   2.243  11.856  1.00  0.00           H  
ATOM    648  HB3 GLN A  43      37.204   0.684  12.189  1.00  0.00           H  
ATOM    649  HG2 GLN A  43      38.626   1.114  10.116  1.00  0.00           H  
ATOM    650  HG3 GLN A  43      38.059   2.780  10.227  1.00  0.00           H  
ATOM    651 HE21 GLN A  43      38.883   4.110  11.762  1.00  0.00           H  
ATOM    652 HE22 GLN A  43      40.156   3.663  12.842  1.00  0.00           H  
ATOM    653  N   PHE A  44      37.332   0.282   8.433  1.00  0.00           N  
ATOM    654  CA  PHE A  44      38.096  -0.535   7.498  1.00  0.00           C  
ATOM    655  C   PHE A  44      39.576  -0.165   7.536  1.00  0.00           C  
ATOM    656  O   PHE A  44      39.947   0.906   8.015  1.00  0.00           O  
ATOM    657  CB  PHE A  44      37.554  -0.365   6.078  1.00  0.00           C  
ATOM    658  CG  PHE A  44      36.066  -0.545   5.980  1.00  0.00           C  
ATOM    659  CD1 PHE A  44      35.439  -1.604   6.617  1.00  0.00           C  
ATOM    660  CD2 PHE A  44      35.293   0.346   5.251  1.00  0.00           C  
ATOM    661  CE1 PHE A  44      34.070  -1.772   6.527  1.00  0.00           C  
ATOM    662  CE2 PHE A  44      33.923   0.183   5.159  1.00  0.00           C  
ATOM    663  CZ  PHE A  44      33.311  -0.877   5.798  1.00  0.00           C  
ATOM    664  H   PHE A  44      37.221   1.240   8.251  1.00  0.00           H  
ATOM    665  HA  PHE A  44      37.988  -1.566   7.796  1.00  0.00           H  
ATOM    666  HB2 PHE A  44      37.790   0.627   5.725  1.00  0.00           H  
ATOM    667  HB3 PHE A  44      38.020  -1.095   5.433  1.00  0.00           H  
ATOM    668  HD1 PHE A  44      36.030  -2.304   7.188  1.00  0.00           H  
ATOM    669  HD2 PHE A  44      35.771   1.176   4.750  1.00  0.00           H  
ATOM    670  HE1 PHE A  44      33.593  -2.601   7.028  1.00  0.00           H  
ATOM    671  HE2 PHE A  44      33.334   0.885   4.588  1.00  0.00           H  
ATOM    672  HZ  PHE A  44      32.241  -1.006   5.727  1.00  0.00           H  
ATOM    673  N   GLU A  45      40.418  -1.061   7.029  1.00  0.00           N  
ATOM    674  CA  GLU A  45      41.857  -0.830   7.006  1.00  0.00           C  
ATOM    675  C   GLU A  45      42.180   0.527   6.387  1.00  0.00           C  
ATOM    676  O   GLU A  45      43.267   1.070   6.588  1.00  0.00           O  
ATOM    677  CB  GLU A  45      42.562  -1.940   6.225  1.00  0.00           C  
ATOM    678  CG  GLU A  45      42.280  -3.334   6.758  1.00  0.00           C  
ATOM    679  CD  GLU A  45      43.154  -4.393   6.116  1.00  0.00           C  
ATOM    680  OE1 GLU A  45      43.414  -4.291   4.898  1.00  0.00           O  
ATOM    681  OE2 GLU A  45      43.579  -5.325   6.832  1.00  0.00           O  
ATOM    682  H   GLU A  45      40.062  -1.897   6.661  1.00  0.00           H  
ATOM    683  HA  GLU A  45      42.210  -0.840   8.026  1.00  0.00           H  
ATOM    684  HB2 GLU A  45      42.240  -1.899   5.194  1.00  0.00           H  
ATOM    685  HB3 GLU A  45      43.628  -1.771   6.266  1.00  0.00           H  
ATOM    686  HG2 GLU A  45      42.456  -3.341   7.823  1.00  0.00           H  
ATOM    687  HG3 GLU A  45      41.244  -3.577   6.565  1.00  0.00           H  
ATOM    688  N   ASP A  46      41.230   1.068   5.634  1.00  0.00           N  
ATOM    689  CA  ASP A  46      41.411   2.362   4.985  1.00  0.00           C  
ATOM    690  C   ASP A  46      40.788   3.479   5.817  1.00  0.00           C  
ATOM    691  O   ASP A  46      40.104   4.354   5.287  1.00  0.00           O  
ATOM    692  CB  ASP A  46      40.794   2.347   3.586  1.00  0.00           C  
ATOM    693  CG  ASP A  46      41.058   3.630   2.823  1.00  0.00           C  
ATOM    694  OD1 ASP A  46      42.203   4.126   2.876  1.00  0.00           O  
ATOM    695  OD2 ASP A  46      40.120   4.137   2.173  1.00  0.00           O  
ATOM    696  H   ASP A  46      40.385   0.588   5.512  1.00  0.00           H  
ATOM    697  HA  ASP A  46      42.472   2.544   4.899  1.00  0.00           H  
ATOM    698  HB2 ASP A  46      41.212   1.524   3.025  1.00  0.00           H  
ATOM    699  HB3 ASP A  46      39.726   2.213   3.673  1.00  0.00           H  
ATOM    700  N   ASP A  47      41.030   3.443   7.123  1.00  0.00           N  
ATOM    701  CA  ASP A  47      40.494   4.452   8.028  1.00  0.00           C  
ATOM    702  C   ASP A  47      39.073   4.840   7.629  1.00  0.00           C  
ATOM    703  O   ASP A  47      38.619   5.948   7.912  1.00  0.00           O  
ATOM    704  CB  ASP A  47      41.391   5.691   8.036  1.00  0.00           C  
ATOM    705  CG  ASP A  47      42.788   5.390   8.539  1.00  0.00           C  
ATOM    706  OD1 ASP A  47      42.911   4.705   9.577  1.00  0.00           O  
ATOM    707  OD2 ASP A  47      43.760   5.839   7.896  1.00  0.00           O  
ATOM    708  H   ASP A  47      41.584   2.720   7.486  1.00  0.00           H  
ATOM    709  HA  ASP A  47      40.472   4.029   9.022  1.00  0.00           H  
ATOM    710  HB2 ASP A  47      41.466   6.079   7.030  1.00  0.00           H  
ATOM    711  HB3 ASP A  47      40.951   6.442   8.674  1.00  0.00           H  
ATOM    712  N   SER A  48      38.377   3.920   6.969  1.00  0.00           N  
ATOM    713  CA  SER A  48      37.010   4.167   6.527  1.00  0.00           C  
ATOM    714  C   SER A  48      36.007   3.711   7.582  1.00  0.00           C  
ATOM    715  O   SER A  48      35.764   2.516   7.747  1.00  0.00           O  
ATOM    716  CB  SER A  48      36.741   3.445   5.205  1.00  0.00           C  
ATOM    717  OG  SER A  48      37.251   4.181   4.108  1.00  0.00           O  
ATOM    718  H   SER A  48      38.794   3.054   6.774  1.00  0.00           H  
ATOM    719  HA  SER A  48      36.897   5.230   6.376  1.00  0.00           H  
ATOM    720  HB2 SER A  48      37.215   2.475   5.224  1.00  0.00           H  
ATOM    721  HB3 SER A  48      35.675   3.322   5.077  1.00  0.00           H  
ATOM    722  HG  SER A  48      38.032   3.742   3.763  1.00  0.00           H  
ATOM    723  N   GLN A  49      35.427   4.673   8.292  1.00  0.00           N  
ATOM    724  CA  GLN A  49      34.450   4.371   9.333  1.00  0.00           C  
ATOM    725  C   GLN A  49      33.045   4.766   8.891  1.00  0.00           C  
ATOM    726  O   GLN A  49      32.768   5.940   8.642  1.00  0.00           O  
ATOM    727  CB  GLN A  49      34.813   5.098  10.629  1.00  0.00           C  
ATOM    728  CG  GLN A  49      36.310   5.179  10.882  1.00  0.00           C  
ATOM    729  CD  GLN A  49      36.655   6.081  12.051  1.00  0.00           C  
ATOM    730  OE1 GLN A  49      35.777   6.511  12.799  1.00  0.00           O  
ATOM    731  NE2 GLN A  49      37.941   6.374  12.214  1.00  0.00           N  
ATOM    732  H   GLN A  49      35.662   5.607   8.114  1.00  0.00           H  
ATOM    733  HA  GLN A  49      34.472   3.307   9.509  1.00  0.00           H  
ATOM    734  HB2 GLN A  49      34.421   6.103  10.586  1.00  0.00           H  
ATOM    735  HB3 GLN A  49      34.357   4.577  11.458  1.00  0.00           H  
ATOM    736  HG2 GLN A  49      36.682   4.188  11.090  1.00  0.00           H  
ATOM    737  HG3 GLN A  49      36.790   5.564   9.994  1.00  0.00           H  
ATOM    738 HE21 GLN A  49      38.584   5.996  11.577  1.00  0.00           H  
ATOM    739 HE22 GLN A  49      38.192   6.955  12.960  1.00  0.00           H  
ATOM    740  N   PHE A  50      32.161   3.779   8.794  1.00  0.00           N  
ATOM    741  CA  PHE A  50      30.784   4.023   8.381  1.00  0.00           C  
ATOM    742  C   PHE A  50      29.811   3.192   9.212  1.00  0.00           C  
ATOM    743  O   PHE A  50      30.222   2.382  10.044  1.00  0.00           O  
ATOM    744  CB  PHE A  50      30.609   3.699   6.896  1.00  0.00           C  
ATOM    745  CG  PHE A  50      29.496   4.465   6.241  1.00  0.00           C  
ATOM    746  CD1 PHE A  50      29.590   5.837   6.069  1.00  0.00           C  
ATOM    747  CD2 PHE A  50      28.357   3.815   5.796  1.00  0.00           C  
ATOM    748  CE1 PHE A  50      28.566   6.545   5.468  1.00  0.00           C  
ATOM    749  CE2 PHE A  50      27.331   4.517   5.194  1.00  0.00           C  
ATOM    750  CZ  PHE A  50      27.436   5.884   5.028  1.00  0.00           C  
ATOM    751  H   PHE A  50      32.442   2.864   9.005  1.00  0.00           H  
ATOM    752  HA  PHE A  50      30.571   5.069   8.539  1.00  0.00           H  
ATOM    753  HB2 PHE A  50      31.525   3.933   6.373  1.00  0.00           H  
ATOM    754  HB3 PHE A  50      30.398   2.645   6.787  1.00  0.00           H  
ATOM    755  HD1 PHE A  50      30.474   6.354   6.412  1.00  0.00           H  
ATOM    756  HD2 PHE A  50      28.274   2.744   5.925  1.00  0.00           H  
ATOM    757  HE1 PHE A  50      28.652   7.614   5.340  1.00  0.00           H  
ATOM    758  HE2 PHE A  50      26.448   3.997   4.851  1.00  0.00           H  
ATOM    759  HZ  PHE A  50      26.635   6.434   4.559  1.00  0.00           H  
ATOM    760  N   LEU A  51      28.519   3.400   8.981  1.00  0.00           N  
ATOM    761  CA  LEU A  51      27.486   2.670   9.708  1.00  0.00           C  
ATOM    762  C   LEU A  51      27.088   1.400   8.964  1.00  0.00           C  
ATOM    763  O   LEU A  51      26.479   1.458   7.896  1.00  0.00           O  
ATOM    764  CB  LEU A  51      26.258   3.558   9.916  1.00  0.00           C  
ATOM    765  CG  LEU A  51      26.383   4.638  10.992  1.00  0.00           C  
ATOM    766  CD1 LEU A  51      25.234   5.629  10.890  1.00  0.00           C  
ATOM    767  CD2 LEU A  51      26.426   4.008  12.377  1.00  0.00           C  
ATOM    768  H   LEU A  51      28.252   4.057   8.306  1.00  0.00           H  
ATOM    769  HA  LEU A  51      27.889   2.397  10.673  1.00  0.00           H  
ATOM    770  HB2 LEU A  51      26.042   4.049   8.979  1.00  0.00           H  
ATOM    771  HB3 LEU A  51      25.429   2.918  10.184  1.00  0.00           H  
ATOM    772  HG  LEU A  51      27.306   5.181  10.841  1.00  0.00           H  
ATOM    773 HD11 LEU A  51      24.691   5.648  11.823  1.00  0.00           H  
ATOM    774 HD12 LEU A  51      24.571   5.330  10.093  1.00  0.00           H  
ATOM    775 HD13 LEU A  51      25.627   6.614  10.681  1.00  0.00           H  
ATOM    776 HD21 LEU A  51      25.599   3.324  12.486  1.00  0.00           H  
ATOM    777 HD22 LEU A  51      26.355   4.783  13.126  1.00  0.00           H  
ATOM    778 HD23 LEU A  51      27.355   3.473  12.500  1.00  0.00           H  
ATOM    779  N   VAL A  52      27.437   0.251   9.536  1.00  0.00           N  
ATOM    780  CA  VAL A  52      27.114  -1.034   8.928  1.00  0.00           C  
ATOM    781  C   VAL A  52      25.978  -1.725   9.675  1.00  0.00           C  
ATOM    782  O   VAL A  52      26.084  -2.003  10.870  1.00  0.00           O  
ATOM    783  CB  VAL A  52      28.340  -1.967   8.904  1.00  0.00           C  
ATOM    784  CG1 VAL A  52      28.046  -3.215   8.085  1.00  0.00           C  
ATOM    785  CG2 VAL A  52      29.556  -1.234   8.357  1.00  0.00           C  
ATOM    786  H   VAL A  52      27.921   0.269  10.388  1.00  0.00           H  
ATOM    787  HA  VAL A  52      26.805  -0.854   7.909  1.00  0.00           H  
ATOM    788  HB  VAL A  52      28.555  -2.271   9.918  1.00  0.00           H  
ATOM    789 HG11 VAL A  52      28.517  -4.069   8.548  1.00  0.00           H  
ATOM    790 HG12 VAL A  52      26.978  -3.371   8.039  1.00  0.00           H  
ATOM    791 HG13 VAL A  52      28.434  -3.088   7.085  1.00  0.00           H  
ATOM    792 HG21 VAL A  52      30.001  -1.819   7.567  1.00  0.00           H  
ATOM    793 HG22 VAL A  52      29.252  -0.273   7.967  1.00  0.00           H  
ATOM    794 HG23 VAL A  52      30.275  -1.090   9.149  1.00  0.00           H  
ATOM    795  N   LEU A  53      24.891  -1.999   8.962  1.00  0.00           N  
ATOM    796  CA  LEU A  53      23.733  -2.658   9.556  1.00  0.00           C  
ATOM    797  C   LEU A  53      24.156  -3.887  10.354  1.00  0.00           C  
ATOM    798  O   LEU A  53      25.299  -4.335  10.263  1.00  0.00           O  
ATOM    799  CB  LEU A  53      22.736  -3.061   8.467  1.00  0.00           C  
ATOM    800  CG  LEU A  53      22.082  -1.913   7.698  1.00  0.00           C  
ATOM    801  CD1 LEU A  53      21.359  -2.439   6.468  1.00  0.00           C  
ATOM    802  CD2 LEU A  53      21.122  -1.149   8.598  1.00  0.00           C  
ATOM    803  H   LEU A  53      24.864  -1.752   8.014  1.00  0.00           H  
ATOM    804  HA  LEU A  53      23.258  -1.956  10.225  1.00  0.00           H  
ATOM    805  HB2 LEU A  53      23.259  -3.681   7.755  1.00  0.00           H  
ATOM    806  HB3 LEU A  53      21.951  -3.637   8.936  1.00  0.00           H  
ATOM    807  HG  LEU A  53      22.849  -1.228   7.367  1.00  0.00           H  
ATOM    808 HD11 LEU A  53      21.142  -3.488   6.598  1.00  0.00           H  
ATOM    809 HD12 LEU A  53      21.986  -2.306   5.599  1.00  0.00           H  
ATOM    810 HD13 LEU A  53      20.436  -1.894   6.332  1.00  0.00           H  
ATOM    811 HD21 LEU A  53      20.130  -1.566   8.502  1.00  0.00           H  
ATOM    812 HD22 LEU A  53      21.104  -0.109   8.303  1.00  0.00           H  
ATOM    813 HD23 LEU A  53      21.449  -1.227   9.624  1.00  0.00           H  
ATOM    814  N   TRP A  54      23.228  -4.429  11.133  1.00  0.00           N  
ATOM    815  CA  TRP A  54      23.504  -5.608  11.945  1.00  0.00           C  
ATOM    816  C   TRP A  54      23.544  -6.866  11.084  1.00  0.00           C  
ATOM    817  O   TRP A  54      24.381  -7.745  11.289  1.00  0.00           O  
ATOM    818  CB  TRP A  54      22.447  -5.758  13.041  1.00  0.00           C  
ATOM    819  CG  TRP A  54      22.679  -4.861  14.218  1.00  0.00           C  
ATOM    820  CD1 TRP A  54      23.613  -3.871  14.323  1.00  0.00           C  
ATOM    821  CD2 TRP A  54      21.966  -4.876  15.460  1.00  0.00           C  
ATOM    822  NE1 TRP A  54      23.525  -3.268  15.554  1.00  0.00           N  
ATOM    823  CE2 TRP A  54      22.521  -3.866  16.270  1.00  0.00           C  
ATOM    824  CE3 TRP A  54      20.912  -5.642  15.965  1.00  0.00           C  
ATOM    825  CZ2 TRP A  54      22.057  -3.605  17.557  1.00  0.00           C  
ATOM    826  CZ3 TRP A  54      20.454  -5.382  17.243  1.00  0.00           C  
ATOM    827  CH2 TRP A  54      21.025  -4.370  18.026  1.00  0.00           C  
ATOM    828  H   TRP A  54      22.334  -4.026  11.164  1.00  0.00           H  
ATOM    829  HA  TRP A  54      24.471  -5.472  12.408  1.00  0.00           H  
ATOM    830  HB2 TRP A  54      21.477  -5.524  12.630  1.00  0.00           H  
ATOM    831  HB3 TRP A  54      22.447  -6.780  13.392  1.00  0.00           H  
ATOM    832  HD1 TRP A  54      24.314  -3.612  13.543  1.00  0.00           H  
ATOM    833  HE1 TRP A  54      24.087  -2.529  15.867  1.00  0.00           H  
ATOM    834  HE3 TRP A  54      20.460  -6.426  15.377  1.00  0.00           H  
ATOM    835  HZ2 TRP A  54      22.486  -2.828  18.172  1.00  0.00           H  
ATOM    836  HZ3 TRP A  54      19.640  -5.964  17.651  1.00  0.00           H  
ATOM    837  HH2 TRP A  54      20.634  -4.202  19.018  1.00  0.00           H  
ATOM    838  N   LYS A  55      22.634  -6.946  10.120  1.00  0.00           N  
ATOM    839  CA  LYS A  55      22.566  -8.095   9.225  1.00  0.00           C  
ATOM    840  C   LYS A  55      23.742  -8.098   8.252  1.00  0.00           C  
ATOM    841  O   LYS A  55      24.319  -9.146   7.965  1.00  0.00           O  
ATOM    842  CB  LYS A  55      21.248  -8.085   8.448  1.00  0.00           C  
ATOM    843  CG  LYS A  55      20.971  -6.773   7.736  1.00  0.00           C  
ATOM    844  CD  LYS A  55      19.885  -6.926   6.684  1.00  0.00           C  
ATOM    845  CE  LYS A  55      19.774  -5.685   5.812  1.00  0.00           C  
ATOM    846  NZ  LYS A  55      18.846  -4.677   6.397  1.00  0.00           N  
ATOM    847  H   LYS A  55      21.993  -6.213  10.005  1.00  0.00           H  
ATOM    848  HA  LYS A  55      22.612  -8.989   9.828  1.00  0.00           H  
ATOM    849  HB2 LYS A  55      21.273  -8.873   7.710  1.00  0.00           H  
ATOM    850  HB3 LYS A  55      20.437  -8.276   9.137  1.00  0.00           H  
ATOM    851  HG2 LYS A  55      20.653  -6.039   8.463  1.00  0.00           H  
ATOM    852  HG3 LYS A  55      21.879  -6.435   7.256  1.00  0.00           H  
ATOM    853  HD2 LYS A  55      20.120  -7.774   6.058  1.00  0.00           H  
ATOM    854  HD3 LYS A  55      18.939  -7.094   7.179  1.00  0.00           H  
ATOM    855  HE2 LYS A  55      20.754  -5.245   5.711  1.00  0.00           H  
ATOM    856  HE3 LYS A  55      19.407  -5.977   4.839  1.00  0.00           H  
ATOM    857  HZ1 LYS A  55      19.273  -4.248   7.242  1.00  0.00           H  
ATOM    858  HZ2 LYS A  55      17.950  -5.131   6.667  1.00  0.00           H  
ATOM    859  HZ3 LYS A  55      18.649  -3.929   5.703  1.00  0.00           H  
ATOM    860  N   ASP A  56      24.090  -6.919   7.750  1.00  0.00           N  
ATOM    861  CA  ASP A  56      25.199  -6.786   6.811  1.00  0.00           C  
ATOM    862  C   ASP A  56      26.493  -7.318   7.419  1.00  0.00           C  
ATOM    863  O   ASP A  56      27.344  -7.861   6.714  1.00  0.00           O  
ATOM    864  CB  ASP A  56      25.377  -5.322   6.404  1.00  0.00           C  
ATOM    865  CG  ASP A  56      24.211  -4.803   5.586  1.00  0.00           C  
ATOM    866  OD1 ASP A  56      23.052  -5.069   5.968  1.00  0.00           O  
ATOM    867  OD2 ASP A  56      24.458  -4.130   4.564  1.00  0.00           O  
ATOM    868  H   ASP A  56      23.592  -6.119   8.017  1.00  0.00           H  
ATOM    869  HA  ASP A  56      24.962  -7.367   5.933  1.00  0.00           H  
ATOM    870  HB2 ASP A  56      25.466  -4.716   7.294  1.00  0.00           H  
ATOM    871  HB3 ASP A  56      26.278  -5.226   5.816  1.00  0.00           H  
ATOM    872  N   ILE A  57      26.634  -7.158   8.731  1.00  0.00           N  
ATOM    873  CA  ILE A  57      27.823  -7.624   9.433  1.00  0.00           C  
ATOM    874  C   ILE A  57      27.831  -9.143   9.557  1.00  0.00           C  
ATOM    875  O   ILE A  57      26.797  -9.760   9.813  1.00  0.00           O  
ATOM    876  CB  ILE A  57      27.925  -7.005  10.840  1.00  0.00           C  
ATOM    877  CG1 ILE A  57      27.996  -5.479  10.746  1.00  0.00           C  
ATOM    878  CG2 ILE A  57      29.140  -7.553  11.573  1.00  0.00           C  
ATOM    879  CD1 ILE A  57      27.399  -4.772  11.942  1.00  0.00           C  
ATOM    880  H   ILE A  57      25.921  -6.719   9.239  1.00  0.00           H  
ATOM    881  HA  ILE A  57      28.688  -7.315   8.863  1.00  0.00           H  
ATOM    882  HB  ILE A  57      27.043  -7.284  11.396  1.00  0.00           H  
ATOM    883 HG12 ILE A  57      29.029  -5.177  10.664  1.00  0.00           H  
ATOM    884 HG13 ILE A  57      27.460  -5.155   9.866  1.00  0.00           H  
ATOM    885 HG21 ILE A  57      28.915  -8.538  11.955  1.00  0.00           H  
ATOM    886 HG22 ILE A  57      29.974  -7.615  10.890  1.00  0.00           H  
ATOM    887 HG23 ILE A  57      29.393  -6.897  12.393  1.00  0.00           H  
ATOM    888 HD11 ILE A  57      27.266  -3.725  11.712  1.00  0.00           H  
ATOM    889 HD12 ILE A  57      26.443  -5.214  12.183  1.00  0.00           H  
ATOM    890 HD13 ILE A  57      28.064  -4.872  12.788  1.00  0.00           H  
ATOM    891  N   SER A  58      29.004  -9.741   9.373  1.00  0.00           N  
ATOM    892  CA  SER A  58      29.145 -11.189   9.461  1.00  0.00           C  
ATOM    893  C   SER A  58      30.047 -11.577  10.630  1.00  0.00           C  
ATOM    894  O   SER A  58      31.028 -10.901  10.940  1.00  0.00           O  
ATOM    895  CB  SER A  58      29.714 -11.749   8.156  1.00  0.00           C  
ATOM    896  OG  SER A  58      29.266 -13.074   7.930  1.00  0.00           O  
ATOM    897  H   SER A  58      29.791  -9.195   9.170  1.00  0.00           H  
ATOM    898  HA  SER A  58      28.164 -11.610   9.626  1.00  0.00           H  
ATOM    899  HB2 SER A  58      29.394 -11.129   7.333  1.00  0.00           H  
ATOM    900  HB3 SER A  58      30.793 -11.749   8.209  1.00  0.00           H  
ATOM    901  HG  SER A  58      29.752 -13.456   7.196  1.00  0.00           H  
ATOM    902  N   PRO A  59      29.709 -12.692  11.293  1.00  0.00           N  
ATOM    903  CA  PRO A  59      30.475 -13.195  12.437  1.00  0.00           C  
ATOM    904  C   PRO A  59      31.840 -13.736  12.027  1.00  0.00           C  
ATOM    905  O   PRO A  59      31.953 -14.507  11.075  1.00  0.00           O  
ATOM    906  CB  PRO A  59      29.596 -14.323  12.984  1.00  0.00           C  
ATOM    907  CG  PRO A  59      28.787 -14.773  11.817  1.00  0.00           C  
ATOM    908  CD  PRO A  59      28.553 -13.548  10.978  1.00  0.00           C  
ATOM    909  HA  PRO A  59      30.603 -12.436  13.195  1.00  0.00           H  
ATOM    910  HB2 PRO A  59      30.222 -15.119  13.363  1.00  0.00           H  
ATOM    911  HB3 PRO A  59      28.968 -13.943  13.776  1.00  0.00           H  
ATOM    912  HG2 PRO A  59      29.336 -15.513  11.254  1.00  0.00           H  
ATOM    913  HG3 PRO A  59      27.846 -15.180  12.157  1.00  0.00           H  
ATOM    914  HD2 PRO A  59      28.538 -13.805   9.929  1.00  0.00           H  
ATOM    915  HD3 PRO A  59      27.629 -13.066  11.263  1.00  0.00           H  
ATOM    916  N   ALA A  60      32.876 -13.327  12.753  1.00  0.00           N  
ATOM    917  CA  ALA A  60      34.234 -13.773  12.465  1.00  0.00           C  
ATOM    918  C   ALA A  60      34.717 -14.771  13.513  1.00  0.00           C  
ATOM    919  O   ALA A  60      34.973 -14.407  14.660  1.00  0.00           O  
ATOM    920  CB  ALA A  60      35.177 -12.581  12.395  1.00  0.00           C  
ATOM    921  H   ALA A  60      32.723 -12.713  13.500  1.00  0.00           H  
ATOM    922  HA  ALA A  60      34.230 -14.256  11.499  1.00  0.00           H  
ATOM    923  HB1 ALA A  60      35.623 -12.419  13.366  1.00  0.00           H  
ATOM    924  HB2 ALA A  60      35.953 -12.779  11.671  1.00  0.00           H  
ATOM    925  HB3 ALA A  60      34.624 -11.702  12.101  1.00  0.00           H  
ATOM    926  N   ALA A  61      34.838 -16.033  13.110  1.00  0.00           N  
ATOM    927  CA  ALA A  61      35.292 -17.082  14.013  1.00  0.00           C  
ATOM    928  C   ALA A  61      36.784 -16.955  14.299  1.00  0.00           C  
ATOM    929  O   ALA A  61      37.588 -16.770  13.384  1.00  0.00           O  
ATOM    930  CB  ALA A  61      34.980 -18.452  13.429  1.00  0.00           C  
ATOM    931  H   ALA A  61      34.619 -16.261  12.183  1.00  0.00           H  
ATOM    932  HA  ALA A  61      34.748 -16.981  14.942  1.00  0.00           H  
ATOM    933  HB1 ALA A  61      34.315 -18.983  14.095  1.00  0.00           H  
ATOM    934  HB2 ALA A  61      34.506 -18.333  12.466  1.00  0.00           H  
ATOM    935  HB3 ALA A  61      35.896 -19.011  13.314  1.00  0.00           H  
ATOM    936  N   LEU A  62      37.149 -17.052  15.573  1.00  0.00           N  
ATOM    937  CA  LEU A  62      38.546 -16.947  15.979  1.00  0.00           C  
ATOM    938  C   LEU A  62      39.224 -18.313  15.957  1.00  0.00           C  
ATOM    939  O   LEU A  62      40.251 -18.497  15.305  1.00  0.00           O  
ATOM    940  CB  LEU A  62      38.646 -16.338  17.378  1.00  0.00           C  
ATOM    941  CG  LEU A  62      38.644 -14.810  17.447  1.00  0.00           C  
ATOM    942  CD1 LEU A  62      38.452 -14.340  18.880  1.00  0.00           C  
ATOM    943  CD2 LEU A  62      39.934 -14.248  16.868  1.00  0.00           C  
ATOM    944  H   LEU A  62      36.464 -17.200  16.257  1.00  0.00           H  
ATOM    945  HA  LEU A  62      39.048 -16.299  15.276  1.00  0.00           H  
ATOM    946  HB2 LEU A  62      37.808 -16.696  17.955  1.00  0.00           H  
ATOM    947  HB3 LEU A  62      39.565 -16.688  17.825  1.00  0.00           H  
ATOM    948  HG  LEU A  62      37.819 -14.431  16.858  1.00  0.00           H  
ATOM    949 HD11 LEU A  62      39.288 -14.662  19.480  1.00  0.00           H  
ATOM    950 HD12 LEU A  62      37.540 -14.762  19.278  1.00  0.00           H  
ATOM    951 HD13 LEU A  62      38.387 -13.262  18.900  1.00  0.00           H  
ATOM    952 HD21 LEU A  62      40.002 -14.507  15.822  1.00  0.00           H  
ATOM    953 HD22 LEU A  62      40.778 -14.665  17.398  1.00  0.00           H  
ATOM    954 HD23 LEU A  62      39.938 -13.174  16.974  1.00  0.00           H  
ATOM    955  N   SER A  63      38.641 -19.270  16.674  1.00  0.00           N  
ATOM    956  CA  SER A  63      39.189 -20.619  16.737  1.00  0.00           C  
ATOM    957  C   SER A  63      38.974 -21.356  15.419  1.00  0.00           C  
ATOM    958  O   SER A  63      39.930 -21.732  14.742  1.00  0.00           O  
ATOM    959  CB  SER A  63      38.544 -21.400  17.883  1.00  0.00           C  
ATOM    960  OG  SER A  63      39.044 -22.725  17.942  1.00  0.00           O  
ATOM    961  H   SER A  63      37.823 -19.061  17.172  1.00  0.00           H  
ATOM    962  HA  SER A  63      40.250 -20.537  16.921  1.00  0.00           H  
ATOM    963  HB2 SER A  63      38.758 -20.906  18.818  1.00  0.00           H  
ATOM    964  HB3 SER A  63      37.475 -21.438  17.732  1.00  0.00           H  
ATOM    965  HG  SER A  63      39.341 -22.995  17.070  1.00  0.00           H  
ATOM    966  N   GLY A  64      37.710 -21.559  15.061  1.00  0.00           N  
ATOM    967  CA  GLY A  64      37.390 -22.250  13.826  1.00  0.00           C  
ATOM    968  C   GLY A  64      36.318 -23.305  14.012  1.00  0.00           C  
ATOM    969  O   GLY A  64      35.541 -23.269  14.967  1.00  0.00           O  
ATOM    970  H   GLY A  64      36.989 -21.236  15.641  1.00  0.00           H  
ATOM    971  HA2 GLY A  64      37.047 -21.528  13.100  1.00  0.00           H  
ATOM    972  HA3 GLY A  64      38.285 -22.725  13.452  1.00  0.00           H  
ATOM    973  N   PRO A  65      36.264 -24.270  13.082  1.00  0.00           N  
ATOM    974  CA  PRO A  65      35.281 -25.358  13.126  1.00  0.00           C  
ATOM    975  C   PRO A  65      35.549 -26.334  14.267  1.00  0.00           C  
ATOM    976  O   PRO A  65      36.230 -27.344  14.085  1.00  0.00           O  
ATOM    977  CB  PRO A  65      35.460 -26.052  11.774  1.00  0.00           C  
ATOM    978  CG  PRO A  65      36.862 -25.745  11.373  1.00  0.00           C  
ATOM    979  CD  PRO A  65      37.158 -24.375  11.918  1.00  0.00           C  
ATOM    980  HA  PRO A  65      34.273 -24.979  13.208  1.00  0.00           H  
ATOM    981  HB2 PRO A  65      35.305 -27.116  11.890  1.00  0.00           H  
ATOM    982  HB3 PRO A  65      34.751 -25.654  11.064  1.00  0.00           H  
ATOM    983  HG2 PRO A  65      37.534 -26.473  11.803  1.00  0.00           H  
ATOM    984  HG3 PRO A  65      36.944 -25.746  10.297  1.00  0.00           H  
ATOM    985  HD2 PRO A  65      38.193 -24.304  12.218  1.00  0.00           H  
ATOM    986  HD3 PRO A  65      36.924 -23.618  11.183  1.00  0.00           H  
ATOM    987  N   SER A  66      35.009 -26.028  15.441  1.00  0.00           N  
ATOM    988  CA  SER A  66      35.192 -26.878  16.613  1.00  0.00           C  
ATOM    989  C   SER A  66      34.758 -28.310  16.317  1.00  0.00           C  
ATOM    990  O   SER A  66      33.567 -28.613  16.267  1.00  0.00           O  
ATOM    991  CB  SER A  66      34.397 -26.327  17.798  1.00  0.00           C  
ATOM    992  OG  SER A  66      34.965 -26.739  19.028  1.00  0.00           O  
ATOM    993  H   SER A  66      34.476 -25.209  15.523  1.00  0.00           H  
ATOM    994  HA  SER A  66      36.242 -26.876  16.862  1.00  0.00           H  
ATOM    995  HB2 SER A  66      34.397 -25.249  17.758  1.00  0.00           H  
ATOM    996  HB3 SER A  66      33.380 -26.690  17.746  1.00  0.00           H  
ATOM    997  HG  SER A  66      35.429 -27.571  18.905  1.00  0.00           H  
ATOM    998  N   SER A  67      35.737 -29.189  16.121  1.00  0.00           N  
ATOM    999  CA  SER A  67      35.458 -30.590  15.826  1.00  0.00           C  
ATOM   1000  C   SER A  67      35.690 -31.460  17.057  1.00  0.00           C  
ATOM   1001  O   SER A  67      36.550 -31.166  17.886  1.00  0.00           O  
ATOM   1002  CB  SER A  67      36.337 -31.074  14.672  1.00  0.00           C  
ATOM   1003  OG  SER A  67      35.825 -30.641  13.423  1.00  0.00           O  
ATOM   1004  H   SER A  67      36.668 -28.887  16.173  1.00  0.00           H  
ATOM   1005  HA  SER A  67      34.421 -30.667  15.535  1.00  0.00           H  
ATOM   1006  HB2 SER A  67      37.335 -30.681  14.793  1.00  0.00           H  
ATOM   1007  HB3 SER A  67      36.373 -32.154  14.678  1.00  0.00           H  
ATOM   1008  HG  SER A  67      35.676 -31.402  12.857  1.00  0.00           H  
ATOM   1009  N   GLY A  68      34.915 -32.534  17.169  1.00  0.00           N  
ATOM   1010  CA  GLY A  68      35.051 -33.433  18.301  1.00  0.00           C  
ATOM   1011  C   GLY A  68      33.721 -33.734  18.964  1.00  0.00           C  
ATOM   1012  O   GLY A  68      33.595 -34.713  19.700  1.00  0.00           O  
ATOM   1013  H   GLY A  68      34.246 -32.720  16.478  1.00  0.00           H  
ATOM   1014  HA2 GLY A  68      35.491 -34.358  17.962  1.00  0.00           H  
ATOM   1015  HA3 GLY A  68      35.708 -32.979  19.029  1.00  0.00           H  
TER    1016      GLY A  68                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
