
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  179 ( 1363),  selected  179 , name 1jwq_A
# Molecule2: number of CA atoms  181 ( 1354),  selected  181 , name T0425.pdb
# PARAMETERS: 1jwq_A.T0425.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    M     1_A      S       2          2.608
LGA    K     2_A      K       3          1.349
LGA    V     3_A      I       4          0.960
LGA    V     4_A      I       5          0.682
LGA    V     5_A      C       6          0.681
LGA    I     6_A      L       7          0.701
LGA    D     7_A      T       8          1.232
LGA    A     8_A      A       9          1.123
LGA    G     9_A      G      10          1.137
LGA    H    10_A      H      11          1.104
LGA    G    11_A      S      12          1.461
LGA    A    12_A      N      13          2.169
LGA    K    13_A      T      14          1.838
LGA    D    14_A      D      15          1.985
LGA    S    15_A      P      16          0.461
LGA    G    16_A      G      17          0.975
LGA    A    17_A      A      18          0.824
LGA    V    18_A      V      19          0.980
LGA    G    19_A      N      20          1.420
LGA    I    20_A      -       -           -
LGA    S    21_A      -       -           -
LGA    R    22_A      G      21          2.147
LGA    K    23_A      S      22          1.335
LGA    N    24_A      D      23          1.088
LGA    Y    25_A      R      24          0.615
LGA    E    26_A      E      25          0.361
LGA    K    27_A      A      26          0.571
LGA    T    28_A      D      27          0.306
LGA    F    29_A      L      28          0.243
LGA    N    30_A      A      29          0.472
LGA    L    31_A      Q      30          0.480
LGA    A    32_A      D      31          0.620
LGA    M    33_A      M      32          1.056
LGA    A    34_A      R      33          0.932
LGA    L    35_A      N      34          0.825
LGA    K    36_A      I      35          0.758
LGA    V    37_A      V      36          0.484
LGA    E    38_A      A      37          1.145
LGA    S    39_A      S      38          1.439
LGA    I    40_A      I      39          0.830
LGA    L    41_A      L      40          0.486
LGA    K    42_A      R      41          0.727
LGA    Q    43_A      N      42          2.184
LGA    N    44_A      D      43          4.600
LGA    P    45_A      Y      44          5.039
LGA    K    46_A      G      45          5.113
LGA    L    47_A      L      46          1.530
LGA    E    48_A      T      47          0.411
LGA    V    49_A      V      48          1.088
LGA    V    50_A      K      49          1.494
LGA    L    51_A      T      50          1.434
LGA    T    52_A      D      51          1.862
LGA    R    53_A      G      52          3.312
LGA    S    54_A      T      53          1.509
LGA    D    55_A      G      54          0.100
LGA    D    56_A      K      55          2.270
LGA    T    57_A      G      56          5.094
LGA    F    58_A      N      57          4.378
LGA    L    59_A      M      58          2.199
LGA    E    60_A      P      59          2.453
LGA    L    61_A      L      60          2.822
LGA    K    62_A      R      61          3.007
LGA    Q    63_A      D      62          2.444
LGA    R    64_A      A      63          1.870
LGA    V    65_A      V      64          2.017
LGA    K    66_A      K      65          1.942
LGA    V    67_A      L      66          2.362
LGA    A    68_A      I      67          2.822
LGA    E    69_A      R      68          2.329
LGA    N    70_A      -       -           -
LGA    L    71_A      -       -           -
LGA    K    72_A      G      69          1.748
LGA    A    73_A      S      70          0.993
LGA    N    74_A      D      71          1.266
LGA    V    75_A      V      72          0.753
LGA    F    76_A      A      73          0.625
LGA    V    77_A      I      74          1.202
LGA    S    78_A      E      75          1.402
LGA    I    79_A      F      76          1.079
LGA    H    80_A      H      77          1.091
LGA    A    81_A      T      78          0.891
LGA    N    82_A      N      79          0.879
LGA    S    83_A      A      80          0.358
LGA    S    84_A      A      81          0.243
LGA    G    85_A      A      82          1.299
LGA    S    86_A      N      83          0.754
LGA    S    87_A      K      84          0.890
LGA    A    88_A      T      85          1.195
LGA    S    89_A      A      86          0.759
LGA    N    90_A      T      87          1.339
LGA    G    91_A      G      88          1.672
LGA    T    92_A      I      89          1.755
LGA    E    93_A      E      90          1.692
LGA    T    94_A      A      91          2.498
LGA    Y    95_A      L      92          2.461
LGA    Y    96_A      S      93          2.320
LGA    Q    97_A      T      94          2.114
LGA    R    98_A      -       -           -
LGA    S    99_A      P      95          2.306
LGA    A   100_A      K      96          1.576
LGA    S   101_A      N      97          0.864
LGA    K   102_A      K      98          1.443
LGA    A   103_A      R      99          2.054
LGA    F   104_A      W     100          1.587
LGA    A   105_A      C     101          1.824
LGA    N   106_A      Q     102          2.420
LGA    V   107_A      V     103          2.283
LGA    M   108_A      L     104          2.331
LGA    H   109_A      G     105          2.379
LGA    K   110_A      K     106          2.736
LGA    Y   111_A      A     107          1.835
LGA    F   112_A      V     108          2.709
LGA    A   113_A      A     109          2.245
LGA    P   114_A      K     110          1.462
LGA    A   115_A      K     111          2.112
LGA    T   116_A      T     112          3.046
LGA    G   117_A      G     113          2.715
LGA    L   118_A      W     114          1.990
LGA    T   119_A      K     115          2.610
LGA    D   120_A      L     116          2.727
LGA    R   121_A      R     117          2.246
LGA    G   122_A      G     118          4.380
LGA    -       -      E     119           -
LGA    -       -      D     120           -
LGA    I   123_A      G     121          1.986
LGA    R   124_A      F     122          3.005
LGA    Y   125_A      K     123          2.072
LGA    G   126_A      P     124          4.013
LGA    -       -      D     125           -
LGA    -       -      N     126           -
LGA    -       -      A     127           -
LGA    N   127_A      G     128          3.553
LGA    -       -      Q     129           -
LGA    -       -      H     130           -
LGA    -       -      S     131           -
LGA    -       -      R     132           -
LGA    F   128_A      L     133          1.822
LGA    H   129_A      A     134          1.502
LGA    V   130_A      Y     135          1.211
LGA    I   131_A      A     136          2.037
LGA    R   132_A      Q     137          1.419
LGA    E   133_A      A     138          0.910
LGA    T   134_A      G     139          3.075
LGA    T   135_A      -       -           -
LGA    M   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    A   138_A      G     140          3.599
LGA    V   139_A      I     141          2.281
LGA    L   140_A      V     142          2.151
LGA    L   141_A      F     143          1.567
LGA    E   142_A      E     144          0.811
LGA    V   143_A      P     145          1.420
LGA    G   144_A      F     146          0.941
LGA    Y   145_A      F     147          1.035
LGA    L   146_A      I     148          1.159
LGA    S   147_A      S     149          1.023
LGA    N   148_A      N     150          1.837
LGA    A   149_A      D     151          1.923
LGA    K   150_A      T     152          1.812
LGA    E   151_A      D     153          2.074
LGA    E   152_A      L     154          2.391
LGA    A   153_A      A     155          2.427
LGA    T   154_A      L     156          2.512
LGA    L   155_A      F     157          2.594
LGA    F   156_A      K     158          2.565
LGA    D   157_A      T     159          2.643
LGA    E   158_A      -       -           -
LGA    D   159_A      -       -           -
LGA    F   160_A      T     160          1.392
LGA    Q   161_A      K     161          0.917
LGA    N   162_A      W     162          1.056
LGA    R   163_A      G     163          1.497
LGA    V   164_A      I     164          1.138
LGA    A   165_A      C     165          0.455
LGA    Q   166_A      R     166          1.329
LGA    G   167_A      A     167          1.643
LGA    I   168_A      I     168          1.110
LGA    A   169_A      A     169          0.740
LGA    D   170_A      D     170          2.126
LGA    G   171_A      A     171          2.384
LGA    I   172_A      I     172          1.171
LGA    T   173_A      A     173          0.934
LGA    E   174_A      M     174          1.914
LGA    Y   175_A      E     175          1.867
LGA    L   176_A      L     176          1.379
LGA    D   177_A      G     177          1.597
LGA    V   178_A      A     178          1.426
LGA    K   179_A      A     179          2.441
LGA    -       -      K     180           -
LGA    -       -      V     181           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  179  181    5.0    169    1.97    24.26     82.117     8.177

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.810763 * X  +   0.572129 * Y  +   0.123824 * Z  +  -3.945711
  Y_new =  -0.550415 * X  +   0.673087 * Y  +   0.493960 * Z  +  -3.543526
  Z_new =   0.199265 * X  +  -0.468639 * Y  +   0.860622 * Z  +   8.275582 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.498638    2.642955  [ DEG:   -28.5698    151.4301 ]
  Theta =  -0.200607   -2.940985  [ DEG:   -11.4940   -168.5060 ]
  Phi   =  -0.596414    2.545178  [ DEG:   -34.1720    145.8280 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jwq_A                                        
REMARK     2: T0425.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jwq_A.T0425.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  179  181   5.0  169   1.97   24.26  82.117
REMARK  ---------------------------------------------------------- 
MOLECULE 1jwq_A
HEADER    HYDROLASE                               05-SEP-01   1JWQ              
TITLE     STRUCTURE OF THE CATALYTIC DOMAIN OF CWLV, N-ACETYLMURAMOYL-          
TITLE    2 L-ALANINE AMIDASE FROM BACILLUS(PAENIBACILLUS) POLYMYXA              
TITLE    3 VAR.COLISTINUS                                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: N-ACETYLMURAMOYL-L-ALANINE AMIDASE CWLV;                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CATALYTIC DOMAIN;                                          
COMPND   5 EC: 3.5.1.28;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PAENIBACILLUS POLYMYXA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 SPECIES: VAR.COLISTINUS;                                             
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    OPEN ALPHA-BETA-ALPHA                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.YAMANE,Y.KOYAMA,Y.NOJIRI,T.HIKAGE,M.AKITA,A.SUZUKI,                 
AUTHOR   2 T.SHIRAI,F.ISE,T.SHIDA,J.SEKIGUCHI                                   
REVDAT   1   18-NOV-03 1JWQ    0                                                
JRNL        AUTH   T.YAMANE,Y.KOYAMA,Y.NOJIRI,T.HIKAGE,M.AKITA,                 
JRNL        AUTH 2 A.SUZUKI,T.SHIRAI,F.ISE,T.SHIDA,J.SEKIGUCHI                  
JRNL        TITL   THE STRUCTURE OF THE CATALYTIC DOMAIN OF                     
JRNL        TITL 2 N-ACETYLMURAMOYL-L-ALANINE AMIDASE, A CELL WALL              
JRNL        TITL 3 HYDROLASE FROM BACILLUS POLYMYXA VAR.COLISTINUS              
JRNL        TITL 4 AND ITS RESEMBLANCE TO THE STRUCTURE OF                      
JRNL        TITL 5 CARBOXYPEPTIDASES                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1JWQ A    2   179  UNP    Q9LCR3   Q9LCR3_PAEPO   322    499             
SEQRES   1 A  179  MET LYS VAL VAL VAL ILE ASP ALA GLY HIS GLY ALA LYS          
SEQRES   2 A  179  ASP SER GLY ALA VAL GLY ILE SER ARG LYS ASN TYR GLU          
SEQRES   3 A  179  LYS THR PHE ASN LEU ALA MET ALA LEU LYS VAL GLU SER          
SEQRES   4 A  179  ILE LEU LYS GLN ASN PRO LYS LEU GLU VAL VAL LEU THR          
SEQRES   5 A  179  ARG SER ASP ASP THR PHE LEU GLU LEU LYS GLN ARG VAL          
SEQRES   6 A  179  LYS VAL ALA GLU ASN LEU LYS ALA ASN VAL PHE VAL SER          
SEQRES   7 A  179  ILE HIS ALA ASN SER SER GLY SER SER ALA SER ASN GLY          
SEQRES   8 A  179  THR GLU THR TYR TYR GLN ARG SER ALA SER LYS ALA PHE          
SEQRES   9 A  179  ALA ASN VAL MET HIS LYS TYR PHE ALA PRO ALA THR GLY          
SEQRES  10 A  179  LEU THR ASP ARG GLY ILE ARG TYR GLY ASN PHE HIS VAL          
SEQRES  11 A  179  ILE ARG GLU THR THR MET PRO ALA VAL LEU LEU GLU VAL          
SEQRES  12 A  179  GLY TYR LEU SER ASN ALA LYS GLU GLU ALA THR LEU PHE          
SEQRES  13 A  179  ASP GLU ASP PHE GLN ASN ARG VAL ALA GLN GLY ILE ALA          
SEQRES  14 A  179  ASP GLY ILE THR GLU TYR LEU ASP VAL LYS                      
HET     ZN  A1001       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   2   ZN    ZN 2+                                                        
FORMUL   3  HOH   *229(H2 O)                                                    
CRYST1   66.500   66.500   88.340  90.00  90.00 120.00 P 61          6          
ATOM      1  N   MET A   1      32.568  14.116  64.463  1.00 34.81           N  
ATOM      2  CA  MET A   1      33.351  15.058  63.612  1.00 33.16           C  
ATOM      3  C   MET A   1      32.499  16.254  63.213  1.00 30.48           C  
ATOM      4  O   MET A   1      31.291  16.277  63.450  1.00 30.06           O  
ATOM      5  CB  MET A   1      33.828  14.352  62.340  1.00 36.11           C  
ATOM      6  CG  MET A   1      34.689  13.132  62.579  1.00 39.45           C  
ATOM      7  SD  MET A   1      35.109  12.333  61.025  1.00 46.17           S  
ATOM      8  CE  MET A   1      33.699  11.235  60.811  1.00 43.34           C  
ATOM      9  N   LYS A   2      33.139  17.249  62.608  1.00 26.33           N  
ATOM     10  CA  LYS A   2      32.427  18.431  62.150  1.00 23.17           C  
ATOM     11  C   LYS A   2      32.013  18.176  60.708  1.00 21.41           C  
ATOM     12  O   LYS A   2      32.815  17.725  59.891  1.00 19.38           O  
ATOM     13  CB  LYS A   2      33.318  19.671  62.255  1.00 23.93           C  
ATOM     14  CG  LYS A   2      33.678  20.018  63.695  1.00 24.85           C  
ATOM     15  CD  LYS A   2      34.350  21.375  63.817  1.00 26.16           C  
ATOM     16  CE  LYS A   2      34.587  21.721  65.283  1.00 26.74           C  
ATOM     17  NZ  LYS A   2      35.140  23.093  65.460  1.00 29.58           N  
ATOM     18  N   VAL A   3      30.747  18.447  60.413  1.00 17.09           N  
ATOM     19  CA  VAL A   3      30.203  18.226  59.083  1.00 15.40           C  
ATOM     20  C   VAL A   3      30.300  19.471  58.217  1.00 14.03           C  
ATOM     21  O   VAL A   3      29.913  20.564  58.628  1.00 12.38           O  
ATOM     22  CB  VAL A   3      28.731  17.776  59.172  1.00 15.18           C  
ATOM     23  CG1 VAL A   3      28.140  17.618  57.789  1.00 14.87           C  
ATOM     24  CG2 VAL A   3      28.645  16.463  59.937  1.00 16.76           C  
ATOM     25  N   VAL A   4      30.816  19.282  57.009  1.00 13.50           N  
ATOM     26  CA  VAL A   4      30.979  20.368  56.055  1.00 12.18           C  
ATOM     27  C   VAL A   4      30.182  20.046  54.801  1.00 11.80           C  
ATOM     28  O   VAL A   4      30.421  19.028  54.157  1.00 13.00           O  
ATOM     29  CB  VAL A   4      32.462  20.533  55.655  1.00 13.47           C  
ATOM     30  CG1 VAL A   4      32.614  21.672  54.645  1.00 13.74           C  
ATOM     31  CG2 VAL A   4      33.303  20.791  56.891  1.00 13.50           C  
ATOM     32  N   VAL A   5      29.229  20.905  54.454  1.00 10.31           N  
ATOM     33  CA  VAL A   5      28.440  20.666  53.255  1.00 10.39           C  
ATOM     34  C   VAL A   5      28.886  21.633  52.172  1.00  8.53           C  
ATOM     35  O   VAL A   5      28.913  22.843  52.379  1.00  9.59           O  
ATOM     36  CB  VAL A   5      26.925  20.828  53.525  1.00 10.09           C  
ATOM     37  CG1 VAL A   5      26.144  20.778  52.209  1.00 10.32           C  
ATOM     38  CG2 VAL A   5      26.449  19.710  54.442  1.00 11.99           C  
ATOM     39  N   ILE A   6      29.273  21.075  51.031  1.00  9.06           N  
ATOM     40  CA  ILE A   6      29.720  21.864  49.895  1.00  9.92           C  
ATOM     41  C   ILE A   6      28.655  21.714  48.829  1.00 10.55           C  
ATOM     42  O   ILE A   6      28.325  20.604  48.413  1.00 11.26           O  
ATOM     43  CB  ILE A   6      31.058  21.359  49.337  1.00 10.51           C  
ATOM     44  CG1 ILE A   6      32.115  21.348  50.446  1.00 10.53           C  
ATOM     45  CG2 ILE A   6      31.494  22.242  48.171  1.00  8.13           C  
ATOM     46  CD1 ILE A   6      32.460  22.712  51.002  1.00 11.57           C  
ATOM     47  N   ASP A   7      28.131  22.850  48.393  1.00  9.48           N  
ATOM     48  CA  ASP A   7      27.072  22.888  47.408  1.00 10.34           C  
ATOM     49  C   ASP A   7      27.532  23.498  46.090  1.00 10.74           C  
ATOM     50  O   ASP A   7      27.807  24.700  46.013  1.00 10.91           O  
ATOM     51  CB  ASP A   7      25.906  23.693  47.990  1.00  8.61           C  
ATOM     52  CG  ASP A   7      24.775  23.873  47.010  1.00  9.15           C  
ATOM     53  OD1 ASP A   7      24.425  25.036  46.723  1.00 11.88           O  
ATOM     54  OD2 ASP A   7      24.245  22.854  46.533  1.00 11.16           O  
ATOM     55  N   ALA A   8      27.633  22.659  45.062  1.00  9.91           N  
ATOM     56  CA  ALA A   8      28.028  23.115  43.732  1.00  9.53           C  
ATOM     57  C   ALA A   8      26.748  23.636  43.101  1.00 10.10           C  
ATOM     58  O   ALA A   8      25.844  22.864  42.799  1.00 11.04           O  
ATOM     59  CB  ALA A   8      28.583  21.952  42.914  1.00 10.11           C  
ATOM     60  N   GLY A   9      26.672  24.947  42.913  1.00 11.06           N  
ATOM     61  CA  GLY A   9      25.477  25.540  42.352  1.00 12.11           C  
ATOM     62  C   GLY A   9      25.014  24.979  41.023  1.00 12.54           C  
ATOM     63  O   GLY A   9      25.822  24.558  40.191  1.00 12.26           O  
ATOM     64  N   HIS A  10      23.698  24.959  40.844  1.00 11.73           N  
ATOM     65  CA  HIS A  10      23.074  24.503  39.609  1.00 11.74           C  
ATOM     66  C   HIS A  10      23.306  23.026  39.310  1.00 13.44           C  
ATOM     67  O   HIS A  10      23.614  22.245  40.208  1.00 12.24           O  
ATOM     68  CB  HIS A  10      23.581  25.378  38.467  1.00 11.73           C  
ATOM     69  CG  HIS A  10      23.585  26.835  38.807  1.00 11.11           C  
ATOM     70  ND1 HIS A  10      22.424  27.549  39.012  1.00 11.45           N  
ATOM     71  CD2 HIS A  10      24.603  27.680  39.092  1.00 10.88           C  
ATOM     72  CE1 HIS A  10      22.729  28.771  39.413  1.00 11.82           C  
ATOM     73  NE2 HIS A  10      24.043  28.877  39.472  1.00 10.06           N  
ATOM     74  N   GLY A  11      23.135  22.646  38.048  1.00 13.66           N  
ATOM     75  CA  GLY A  11      23.339  21.259  37.677  1.00 13.46           C  
ATOM     76  C   GLY A  11      22.278  20.718  36.744  1.00 16.15           C  
ATOM     77  O   GLY A  11      21.117  21.131  36.795  1.00 16.77           O  
ATOM     78  N   ALA A  12      22.687  19.789  35.889  1.00 17.14           N  
ATOM     79  CA  ALA A  12      21.788  19.164  34.930  1.00 18.74           C  
ATOM     80  C   ALA A  12      21.123  20.218  34.052  1.00 19.41           C  
ATOM     81  O   ALA A  12      21.805  21.011  33.404  1.00 19.83           O  
ATOM     82  CB  ALA A  12      20.737  18.334  35.665  1.00 20.48           C  
ATOM     83  N   LYS A  13      19.793  20.235  34.036  1.00 20.62           N  
ATOM     84  CA  LYS A  13      19.063  21.192  33.216  1.00 20.46           C  
ATOM     85  C   LYS A  13      19.408  22.639  33.548  1.00 19.70           C  
ATOM     86  O   LYS A  13      19.249  23.519  32.707  1.00 19.35           O  
ATOM     87  CB  LYS A  13      17.552  20.963  33.336  1.00 24.10           C  
ATOM     88  CG  LYS A  13      16.990  21.072  34.744  1.00 28.05           C  
ATOM     89  CD  LYS A  13      15.497  20.774  34.740  1.00 32.63           C  
ATOM     90  CE  LYS A  13      14.896  20.912  36.128  1.00 35.05           C  
ATOM     91  NZ  LYS A  13      13.441  20.599  36.138  1.00 37.40           N  
ATOM     92  N   ASP A  14      19.879  22.883  34.768  1.00 17.69           N  
ATOM     93  CA  ASP A  14      20.267  24.233  35.180  1.00 18.04           C  
ATOM     94  C   ASP A  14      21.769  24.377  34.957  1.00 17.35           C  
ATOM     95  O   ASP A  14      22.575  23.901  35.752  1.00 17.81           O  
ATOM     96  CB  ASP A  14      19.935  24.466  36.659  1.00 16.98           C  
ATOM     97  CG  ASP A  14      20.243  25.887  37.113  1.00 18.94           C  
ATOM     98  OD1 ASP A  14      20.559  26.743  36.255  1.00 17.60           O  
ATOM     99  OD2 ASP A  14      20.160  26.152  38.334  1.00 16.68           O  
ATOM    100  N   SER A  15      22.143  25.023  33.860  1.00 17.50           N  
ATOM    101  CA  SER A  15      23.550  25.204  33.535  1.00 17.61           C  
ATOM    102  C   SER A  15      24.170  26.370  34.289  1.00 16.67           C  
ATOM    103  O   SER A  15      25.390  26.497  34.353  1.00 15.30           O  
ATOM    104  CB  SER A  15      23.711  25.454  32.038  1.00 20.13           C  
ATOM    105  OG  SER A  15      23.066  26.662  31.670  1.00 22.43           O  
ATOM    106  N   GLY A  16      23.327  27.213  34.871  1.00 16.35           N  
ATOM    107  CA  GLY A  16      23.843  28.380  35.555  1.00 17.26           C  
ATOM    108  C   GLY A  16      24.246  29.336  34.447  1.00 17.22           C  
ATOM    109  O   GLY A  16      23.710  29.257  33.343  1.00 17.13           O  
ATOM    110  N   ALA A  17      25.190  30.227  34.719  1.00 17.09           N  
ATOM    111  CA  ALA A  17      25.634  31.180  33.712  1.00 16.01           C  
ATOM    112  C   ALA A  17      26.425  30.502  32.596  1.00 16.51           C  
ATOM    113  O   ALA A  17      27.147  29.536  32.828  1.00 16.01           O  
ATOM    114  CB  ALA A  17      26.488  32.266  34.365  1.00 16.69           C  
ATOM    115  N   VAL A  18      26.272  31.012  31.378  1.00 16.39           N  
ATOM    116  CA  VAL A  18      26.996  30.484  30.229  1.00 16.75           C  
ATOM    117  C   VAL A  18      28.145  31.460  29.986  1.00 17.70           C  
ATOM    118  O   VAL A  18      27.927  32.670  29.901  1.00 16.83           O  
ATOM    119  CB  VAL A  18      26.090  30.423  28.975  1.00 18.71           C  
ATOM    120  CG1 VAL A  18      26.858  29.840  27.796  1.00 18.29           C  
ATOM    121  CG2 VAL A  18      24.859  29.585  29.271  1.00 17.82           C  
ATOM    122  N   GLY A  19      29.365  30.938  29.900  1.00 16.06           N  
ATOM    123  CA  GLY A  19      30.519  31.795  29.686  1.00 16.47           C  
ATOM    124  C   GLY A  19      30.401  32.611  28.415  1.00 17.21           C  
ATOM    125  O   GLY A  19      29.651  32.249  27.515  1.00 18.01           O  
ATOM    126  N   ILE A  20      31.136  33.714  28.335  1.00 18.73           N  
ATOM    127  CA  ILE A  20      31.080  34.557  27.148  1.00 19.75           C  
ATOM    128  C   ILE A  20      31.568  33.782  25.920  1.00 21.86           C  
ATOM    129  O   ILE A  20      31.132  34.046  24.798  1.00 22.09           O  
ATOM    130  CB  ILE A  20      31.917  35.843  27.339  1.00 18.70           C  
ATOM    131  CG1 ILE A  20      31.815  36.723  26.088  1.00 20.08           C  
ATOM    132  CG2 ILE A  20      33.362  35.489  27.644  1.00 17.18           C  
ATOM    133  CD1 ILE A  20      32.494  38.070  26.236  1.00 19.91           C  
ATOM    134  N   SER A  21      32.450  32.811  26.140  1.00 21.33           N  
ATOM    135  CA  SER A  21      32.981  31.989  25.053  1.00 22.03           C  
ATOM    136  C   SER A  21      31.868  31.121  24.476  1.00 23.02           C  
ATOM    137  O   SER A  21      31.961  30.643  23.342  1.00 23.89           O  
ATOM    138  CB  SER A  21      34.083  31.072  25.573  1.00 20.89           C  
ATOM    139  OG  SER A  21      33.517  30.047  26.374  1.00 18.13           O  
ATOM    140  N   ARG A  22      30.830  30.914  25.282  1.00 23.41           N  
ATOM    141  CA  ARG A  22      29.677  30.099  24.921  1.00 24.07           C  
ATOM    142  C   ARG A  22      30.029  28.611  24.897  1.00 24.34           C  
ATOM    143  O   ARG A  22      29.252  27.789  24.410  1.00 24.94           O  
ATOM    144  CB  ARG A  22      29.123  30.537  23.562  1.00 25.33           C  
ATOM    145  N   LYS A  23      31.194  28.271  25.441  1.00 22.83           N  
ATOM    146  CA  LYS A  23      31.654  26.886  25.474  1.00 22.14           C  
ATOM    147  C   LYS A  23      31.725  26.320  26.889  1.00 21.22           C  
ATOM    148  O   LYS A  23      31.965  25.126  27.070  1.00 20.84           O  
ATOM    149  CB  LYS A  23      33.022  26.778  24.816  1.00 23.72           C  
ATOM    150  N   ASN A  24      31.516  27.175  27.886  1.00 18.87           N  
ATOM    151  CA  ASN A  24      31.573  26.747  29.282  1.00 17.51           C  
ATOM    152  C   ASN A  24      30.301  27.078  30.054  1.00 16.90           C  
ATOM    153  O   ASN A  24      29.683  28.120  29.837  1.00 16.32           O  
ATOM    154  CB  ASN A  24      32.757  27.406  29.993  1.00 17.97           C  
ATOM    155  CG  ASN A  24      34.084  27.092  29.341  1.00 19.24           C  
ATOM    156  OD1 ASN A  24      34.803  27.993  28.913  1.00 21.38           O  
ATOM    157  ND2 ASN A  24      34.419  25.812  29.267  1.00 16.32           N  
ATOM    158  N   TYR A  25      29.927  26.183  30.963  1.00 17.19           N  
ATOM    159  CA  TYR A  25      28.743  26.354  31.805  1.00 16.98           C  
ATOM    160  C   TYR A  25      29.184  26.513  33.250  1.00 15.69           C  
ATOM    161  O   TYR A  25      30.118  25.852  33.691  1.00 12.67           O  
ATOM    162  CB  TYR A  25      27.837  25.124  31.721  1.00 20.61           C  
ATOM    163  CG  TYR A  25      27.049  24.991  30.442  1.00 23.72           C  
ATOM    164  CD1 TYR A  25      26.614  23.739  30.003  1.00 25.19           C  
ATOM    165  CD2 TYR A  25      26.705  26.113  29.686  1.00 24.73           C  
ATOM    166  CE1 TYR A  25      25.855  23.607  28.846  1.00 27.48           C  
ATOM    167  CE2 TYR A  25      25.944  25.992  28.526  1.00 27.57           C  
ATOM    168  CZ  TYR A  25      25.523  24.738  28.114  1.00 28.73           C  
ATOM    169  OH  TYR A  25      24.769  24.612  26.969  1.00 31.77           O  
ATOM    170  N   GLU A  26      28.501  27.378  33.990  1.00 13.07           N  
ATOM    171  CA  GLU A  26      28.836  27.590  35.392  1.00 13.44           C  
ATOM    172  C   GLU A  26      28.719  26.294  36.201  1.00 12.22           C  
ATOM    173  O   GLU A  26      29.540  26.030  37.079  1.00 11.11           O  
ATOM    174  CB  GLU A  26      27.908  28.646  35.998  1.00 12.31           C  
ATOM    175  CG  GLU A  26      28.112  28.858  37.491  1.00 12.22           C  
ATOM    176  CD  GLU A  26      26.993  29.653  38.124  1.00 12.29           C  
ATOM    177  OE1 GLU A  26      26.946  29.718  39.373  1.00 11.26           O  
ATOM    178  OE2 GLU A  26      26.161  30.216  37.375  1.00 11.75           O  
ATOM    179  N   LYS A  27      27.697  25.490  35.911  1.00 12.16           N  
ATOM    180  CA  LYS A  27      27.493  24.241  36.642  1.00 11.76           C  
ATOM    181  C   LYS A  27      28.726  23.349  36.603  1.00 12.00           C  
ATOM    182  O   LYS A  27      29.031  22.648  37.572  1.00 13.01           O  
ATOM    183  CB  LYS A  27      26.286  23.468  36.086  1.00 12.54           C  
ATOM    184  CG  LYS A  27      26.443  22.972  34.654  1.00 13.41           C  
ATOM    185  CD  LYS A  27      25.319  22.004  34.283  1.00 15.38           C  
ATOM    186  CE  LYS A  27      25.522  21.415  32.888  1.00 17.69           C  
ATOM    187  NZ  LYS A  27      24.515  20.344  32.576  1.00 16.95           N  
ATOM    188  N   THR A  28      29.426  23.382  35.475  1.00 12.27           N  
ATOM    189  CA  THR A  28      30.631  22.586  35.273  1.00 11.62           C  
ATOM    190  C   THR A  28      31.728  23.079  36.209  1.00 12.02           C  
ATOM    191  O   THR A  28      32.407  22.285  36.863  1.00 11.77           O  
ATOM    192  CB  THR A  28      31.114  22.713  33.815  1.00 12.83           C  
ATOM    193  OG1 THR A  28      30.019  22.438  32.933  1.00 13.86           O  
ATOM    194  CG2 THR A  28      32.242  21.734  33.535  1.00 12.87           C  
ATOM    195  N   PHE A  29      31.902  24.395  36.257  1.00 10.37           N  
ATOM    196  CA  PHE A  29      32.896  25.002  37.131  1.00 10.10           C  
ATOM    197  C   PHE A  29      32.579  24.702  38.596  1.00 10.00           C  
ATOM    198  O   PHE A  29      33.456  24.301  39.357  1.00 11.23           O  
ATOM    199  CB  PHE A  29      32.923  26.519  36.927  1.00  9.94           C  
ATOM    200  CG  PHE A  29      33.781  27.253  37.926  1.00 11.72           C  
ATOM    201  CD1 PHE A  29      35.165  27.252  37.810  1.00 11.47           C  
ATOM    202  CD2 PHE A  29      33.198  27.927  38.997  1.00 11.77           C  
ATOM    203  CE1 PHE A  29      35.961  27.910  38.745  1.00 11.71           C  
ATOM    204  CE2 PHE A  29      33.984  28.588  39.936  1.00 11.04           C  
ATOM    205  CZ  PHE A  29      35.372  28.580  39.809  1.00 13.67           C  
ATOM    206  N   ASN A  30      31.323  24.899  38.987  1.00  9.44           N  
ATOM    207  CA  ASN A  30      30.919  24.670  40.367  1.00  9.34           C  
ATOM    208  C   ASN A  30      31.210  23.258  40.847  1.00 10.00           C  
ATOM    209  O   ASN A  30      31.704  23.062  41.957  1.00  9.18           O  
ATOM    210  CB  ASN A  30      29.427  24.977  40.548  1.00 10.30           C  
ATOM    211  CG  ASN A  30      29.095  26.439  40.276  1.00  9.88           C  
ATOM    212  OD1 ASN A  30      29.974  27.302  40.313  1.00  9.53           O  
ATOM    213  ND2 ASN A  30      27.820  26.724  40.016  1.00  9.42           N  
ATOM    214  N   LEU A  31      30.901  22.273  40.014  1.00 10.86           N  
ATOM    215  CA  LEU A  31      31.137  20.883  40.383  1.00 11.59           C  
ATOM    216  C   LEU A  31      32.631  20.591  40.502  1.00 10.79           C  
ATOM    217  O   LEU A  31      33.075  19.995  41.477  1.00 10.70           O  
ATOM    218  CB  LEU A  31      30.507  19.952  39.348  1.00 12.06           C  
ATOM    219  CG  LEU A  31      30.708  18.457  39.607  1.00 11.51           C  
ATOM    220  CD1 LEU A  31      30.093  18.075  40.949  1.00 12.26           C  
ATOM    221  CD2 LEU A  31      30.058  17.668  38.484  1.00 14.36           C  
ATOM    222  N   ALA A  32      33.404  21.011  39.504  1.00 12.24           N  
ATOM    223  CA  ALA A  32      34.846  20.789  39.519  1.00 11.45           C  
ATOM    224  C   ALA A  32      35.460  21.363  40.794  1.00 13.35           C  
ATOM    225  O   ALA A  32      36.340  20.751  41.407  1.00 13.55           O  
ATOM    226  CB  ALA A  32      35.492  21.433  38.281  1.00  9.82           C  
ATOM    227  N   MET A  33      34.991  22.540  41.195  1.00 11.97           N  
ATOM    228  CA  MET A  33      35.497  23.185  42.402  1.00 11.71           C  
ATOM    229  C   MET A  33      35.088  22.412  43.653  1.00 10.74           C  
ATOM    230  O   MET A  33      35.909  22.168  44.534  1.00 10.65           O  
ATOM    231  CB  MET A  33      34.979  24.625  42.501  1.00 12.32           C  
ATOM    232  CG  MET A  33      35.586  25.569  41.479  1.00 13.32           C  
ATOM    233  SD  MET A  33      37.385  25.613  41.605  1.00 16.59           S  
ATOM    234  CE  MET A  33      37.585  25.927  43.348  1.00 11.90           C  
ATOM    235  N   ALA A  34      33.815  22.034  43.724  1.00 10.86           N  
ATOM    236  CA  ALA A  34      33.307  21.287  44.868  1.00 11.34           C  
ATOM    237  C   ALA A  34      34.073  19.981  45.050  1.00 11.71           C  
ATOM    238  O   ALA A  34      34.437  19.612  46.169  1.00 11.95           O  
ATOM    239  CB  ALA A  34      31.816  21.003  44.693  1.00 11.87           C  
ATOM    240  N   LEU A  35      34.327  19.282  43.951  1.00 12.00           N  
ATOM    241  CA  LEU A  35      35.049  18.016  44.017  1.00 12.88           C  
ATOM    242  C   LEU A  35      36.488  18.219  44.491  1.00 13.39           C  
ATOM    243  O   LEU A  35      37.018  17.405  45.243  1.00 13.83           O  
ATOM    244  CB  LEU A  35      35.040  17.329  42.649  1.00 14.48           C  
ATOM    245  CG  LEU A  35      33.660  16.889  42.152  1.00 15.53           C  
ATOM    246  CD1 LEU A  35      33.791  16.241  40.790  1.00 17.97           C  
ATOM    247  CD2 LEU A  35      33.030  15.920  43.150  1.00 17.70           C  
ATOM    248  N   LYS A  36      37.118  19.301  44.047  1.00 13.06           N  
ATOM    249  CA  LYS A  36      38.490  19.584  44.457  1.00 13.07           C  
ATOM    250  C   LYS A  36      38.547  19.940  45.940  1.00 13.16           C  
ATOM    251  O   LYS A  36      39.447  19.499  46.657  1.00 12.50           O  
ATOM    252  CB  LYS A  36      39.081  20.718  43.616  1.00 13.45           C  
ATOM    253  CG  LYS A  36      39.474  20.301  42.208  1.00 15.14           C  
ATOM    254  CD  LYS A  36      39.935  21.489  41.380  1.00 19.40           C  
ATOM    255  CE  LYS A  36      40.286  21.078  39.948  1.00 18.38           C  
ATOM    256  NZ  LYS A  36      41.441  20.141  39.915  1.00 21.63           N  
ATOM    257  N   VAL A  37      37.587  20.734  46.404  1.00 12.85           N  
ATOM    258  CA  VAL A  37      37.562  21.112  47.810  1.00 12.10           C  
ATOM    259  C   VAL A  37      37.333  19.854  48.642  1.00 14.10           C  
ATOM    260  O   VAL A  37      37.943  19.674  49.695  1.00 13.73           O  
ATOM    261  CB  VAL A  37      36.451  22.157  48.089  1.00 13.22           C  
ATOM    262  CG1 VAL A  37      36.317  22.406  49.590  1.00 11.92           C  
ATOM    263  CG2 VAL A  37      36.789  23.459  47.381  1.00 10.41           C  
ATOM    264  N   GLU A  38      36.474  18.970  48.146  1.00 13.78           N  
ATOM    265  CA  GLU A  38      36.186  17.729  48.848  1.00 14.94           C  
ATOM    266  C   GLU A  38      37.450  16.891  49.006  1.00 15.01           C  
ATOM    267  O   GLU A  38      37.747  16.398  50.094  1.00 14.73           O  
ATOM    268  CB  GLU A  38      35.135  16.919  48.095  1.00 14.81           C  
ATOM    269  CG  GLU A  38      34.638  15.710  48.875  1.00 17.32           C  
ATOM    270  CD  GLU A  38      33.784  14.783  48.043  1.00 16.96           C  
ATOM    271  OE1 GLU A  38      33.011  14.003  48.633  1.00 20.92           O  
ATOM    272  OE2 GLU A  38      33.891  14.826  46.801  1.00 16.74           O  
ATOM    273  N   SER A  39      38.190  16.726  47.914  1.00 16.03           N  
ATOM    274  CA  SER A  39      39.420  15.937  47.942  1.00 17.00           C  
ATOM    275  C   SER A  39      40.409  16.462  48.975  1.00 16.07           C  
ATOM    276  O   SER A  39      41.052  15.686  49.686  1.00 16.52           O  
ATOM    277  CB  SER A  39      40.084  15.936  46.563  1.00 19.19           C  
ATOM    278  OG  SER A  39      39.208  15.410  45.581  1.00 26.44           O  
ATOM    279  N   ILE A  40      40.529  17.782  49.058  1.00 13.92           N  
ATOM    280  CA  ILE A  40      41.445  18.402  50.006  1.00 14.16           C  
ATOM    281  C   ILE A  40      40.986  18.192  51.447  1.00 15.16           C  
ATOM    282  O   ILE A  40      41.771  17.780  52.296  1.00 15.18           O  
ATOM    283  CB  ILE A  40      41.576  19.919  49.741  1.00 13.14           C  
ATOM    284  CG1 ILE A  40      42.176  20.147  48.351  1.00 13.09           C  
ATOM    285  CG2 ILE A  40      42.450  20.570  50.806  1.00 11.37           C  
ATOM    286  CD1 ILE A  40      42.105  21.585  47.886  1.00 13.24           C  
ATOM    287  N   LEU A  41      39.712  18.466  51.714  1.00 14.84           N  
ATOM    288  CA  LEU A  41      39.179  18.319  53.063  1.00 15.80           C  
ATOM    289  C   LEU A  41      39.057  16.868  53.523  1.00 17.49           C  
ATOM    290  O   LEU A  41      39.046  16.599  54.725  1.00 16.92           O  
ATOM    291  CB  LEU A  41      37.818  19.013  53.175  1.00 15.45           C  
ATOM    292  CG  LEU A  41      37.826  20.534  52.986  1.00 16.17           C  
ATOM    293  CD1 LEU A  41      36.411  21.076  53.143  1.00 14.66           C  
ATOM    294  CD2 LEU A  41      38.753  21.182  54.001  1.00 15.91           C  
ATOM    295  N   LYS A  42      38.962  15.943  52.573  1.00 17.32           N  
ATOM    296  CA  LYS A  42      38.841  14.524  52.898  1.00 20.09           C  
ATOM    297  C   LYS A  42      40.061  14.021  53.668  1.00 21.56           C  
ATOM    298  O   LYS A  42      39.971  13.044  54.416  1.00 22.63           O  
ATOM    299  CB  LYS A  42      38.661  13.707  51.621  1.00 20.12           C  
ATOM    300  N   GLN A  43      41.194  14.690  53.484  1.00 21.54           N  
ATOM    301  CA  GLN A  43      42.428  14.299  54.159  1.00 23.00           C  
ATOM    302  C   GLN A  43      42.395  14.629  55.651  1.00 22.05           C  
ATOM    303  O   GLN A  43      43.244  14.161  56.412  1.00 21.82           O  
ATOM    304  CB  GLN A  43      43.634  14.995  53.518  1.00 25.68           C  
ATOM    305  CG  GLN A  43      43.698  14.882  52.003  1.00 32.17           C  
ATOM    306  CD  GLN A  43      45.077  15.195  51.456  1.00 35.95           C  
ATOM    307  OE1 GLN A  43      45.778  16.076  51.961  1.00 38.64           O  
ATOM    308  NE2 GLN A  43      45.471  14.480  50.406  1.00 38.82           N  
ATOM    309  N   ASN A  44      41.418  15.432  56.065  1.00 20.67           N  
ATOM    310  CA  ASN A  44      41.286  15.822  57.465  1.00 19.16           C  
ATOM    311  C   ASN A  44      40.308  14.902  58.193  1.00 20.14           C  
ATOM    312  O   ASN A  44      39.101  14.957  57.959  1.00 19.45           O  
ATOM    313  CB  ASN A  44      40.790  17.266  57.565  1.00 18.17           C  
ATOM    314  CG  ASN A  44      40.985  17.854  58.947  1.00 18.95           C  
ATOM    315  OD1 ASN A  44      40.883  17.154  59.954  1.00 16.68           O  
ATOM    316  ND2 ASN A  44      41.252  19.154  59.004  1.00 16.12           N  
ATOM    317  N   PRO A  45      40.816  14.050  59.100  1.00 20.46           N  
ATOM    318  CA  PRO A  45      39.961  13.125  59.849  1.00 19.35           C  
ATOM    319  C   PRO A  45      38.987  13.784  60.832  1.00 19.19           C  
ATOM    320  O   PRO A  45      38.079  13.132  61.338  1.00 18.82           O  
ATOM    321  CB  PRO A  45      40.973  12.212  60.545  1.00 21.10           C  
ATOM    322  CG  PRO A  45      42.123  13.124  60.797  1.00 20.54           C  
ATOM    323  CD  PRO A  45      42.229  13.895  59.493  1.00 20.77           C  
ATOM    324  N   LYS A  46      39.172  15.071  61.098  1.00 19.82           N  
ATOM    325  CA  LYS A  46      38.291  15.785  62.014  1.00 20.52           C  
ATOM    326  C   LYS A  46      37.059  16.299  61.278  1.00 20.70           C  
ATOM    327  O   LYS A  46      36.142  16.854  61.888  1.00 21.50           O  
ATOM    328  CB  LYS A  46      39.022  16.969  62.649  1.00 21.88           C  
ATOM    329  CG  LYS A  46      40.208  16.586  63.522  1.00 25.24           C  
ATOM    330  CD  LYS A  46      40.859  17.822  64.114  1.00 27.49           C  
ATOM    331  CE  LYS A  46      42.074  17.468  64.960  1.00 29.35           C  
ATOM    332  NZ  LYS A  46      42.683  18.692  65.552  1.00 33.81           N  
ATOM    333  N   LEU A  47      37.042  16.107  59.965  1.00 19.38           N  
ATOM    334  CA  LEU A  47      35.932  16.573  59.143  1.00 18.50           C  
ATOM    335  C   LEU A  47      35.174  15.477  58.416  1.00 18.43           C  
ATOM    336  O   LEU A  47      35.726  14.437  58.060  1.00 18.75           O  
ATOM    337  CB  LEU A  47      36.439  17.570  58.098  1.00 18.54           C  
ATOM    338  CG  LEU A  47      37.092  18.865  58.583  1.00 18.27           C  
ATOM    339  CD1 LEU A  47      37.608  19.637  57.376  1.00 17.54           C  
ATOM    340  CD2 LEU A  47      36.082  19.701  59.367  1.00 19.23           C  
ATOM    341  N   GLU A  48      33.892  15.734  58.194  1.00 17.40           N  
ATOM    342  CA  GLU A  48      33.026  14.828  57.464  1.00 18.38           C  
ATOM    343  C   GLU A  48      32.473  15.704  56.349  1.00 17.41           C  
ATOM    344  O   GLU A  48      31.584  16.519  56.578  1.00 17.15           O  
ATOM    345  CB  GLU A  48      31.897  14.323  58.362  1.00 20.97           C  
ATOM    346  CG  GLU A  48      30.921  13.402  57.661  1.00 23.55           C  
ATOM    347  CD  GLU A  48      29.908  12.799  58.614  1.00 28.06           C  
ATOM    348  OE1 GLU A  48      28.953  12.161  58.130  1.00 29.47           O  
ATOM    349  OE2 GLU A  48      30.072  12.958  59.845  1.00 29.27           O  
ATOM    350  N   VAL A  49      33.020  15.549  55.147  1.00 16.98           N  
ATOM    351  CA  VAL A  49      32.604  16.359  54.008  1.00 15.88           C  
ATOM    352  C   VAL A  49      31.470  15.740  53.210  1.00 15.58           C  
ATOM    353  O   VAL A  49      31.547  14.590  52.779  1.00 15.47           O  
ATOM    354  CB  VAL A  49      33.793  16.615  53.061  1.00 16.82           C  
ATOM    355  CG1 VAL A  49      33.376  17.555  51.938  1.00 16.04           C  
ATOM    356  CG2 VAL A  49      34.956  17.195  53.849  1.00 17.92           C  
ATOM    357  N   VAL A  50      30.414  16.520  53.010  1.00 11.58           N  
ATOM    358  CA  VAL A  50      29.257  16.058  52.265  1.00 10.79           C  
ATOM    359  C   VAL A  50      28.947  17.029  51.139  1.00 10.81           C  
ATOM    360  O   VAL A  50      28.829  18.229  51.365  1.00 11.12           O  
ATOM    361  CB  VAL A  50      28.013  15.958  53.172  1.00 11.35           C  
ATOM    362  CG1 VAL A  50      26.793  15.572  52.340  1.00  9.97           C  
ATOM    363  CG2 VAL A  50      28.253  14.929  54.278  1.00 12.08           C  
ATOM    364  N   LEU A  51      28.824  16.510  49.925  1.00 11.01           N  
ATOM    365  CA  LEU A  51      28.500  17.353  48.784  1.00 11.11           C  
ATOM    366  C   LEU A  51      27.037  17.172  48.414  1.00 11.51           C  
ATOM    367  O   LEU A  51      26.561  16.043  48.292  1.00 12.06           O  
ATOM    368  CB  LEU A  51      29.377  16.998  47.578  1.00 12.62           C  
ATOM    369  CG  LEU A  51      30.685  17.781  47.426  1.00 13.90           C  
ATOM    370  CD1 LEU A  51      31.543  17.637  48.680  1.00 13.74           C  
ATOM    371  CD2 LEU A  51      31.424  17.267  46.199  1.00 15.28           C  
ATOM    372  N   THR A  52      26.320  18.276  48.236  1.00 11.25           N  
ATOM    373  CA  THR A  52      24.914  18.182  47.847  1.00 12.41           C  
ATOM    374  C   THR A  52      24.827  17.441  46.514  1.00 13.75           C  
ATOM    375  O   THR A  52      23.882  16.688  46.275  1.00 13.29           O  
ATOM    376  CB  THR A  52      24.269  19.571  47.701  1.00 12.44           C  
ATOM    377  OG1 THR A  52      25.033  20.364  46.786  1.00 12.28           O  
ATOM    378  CG2 THR A  52      24.207  20.266  49.053  1.00 12.87           C  
ATOM    379  N   ARG A  53      25.811  17.662  45.647  1.00 13.97           N  
ATOM    380  CA  ARG A  53      25.862  16.969  44.366  1.00 14.91           C  
ATOM    381  C   ARG A  53      27.310  16.711  43.978  1.00 15.79           C  
ATOM    382  O   ARG A  53      28.180  17.577  44.128  1.00 14.68           O  
ATOM    383  CB  ARG A  53      25.136  17.757  43.269  1.00 18.21           C  
ATOM    384  CG  ARG A  53      25.894  18.915  42.665  1.00 16.40           C  
ATOM    385  CD  ARG A  53      25.083  19.507  41.517  1.00 15.80           C  
ATOM    386  NE  ARG A  53      25.698  20.709  40.960  1.00 14.91           N  
ATOM    387  CZ  ARG A  53      26.470  20.734  39.879  1.00 15.55           C  
ATOM    388  NH1 ARG A  53      26.738  19.612  39.215  1.00 13.35           N  
ATOM    389  NH2 ARG A  53      26.966  21.888  39.455  1.00 12.38           N  
ATOM    390  N   SER A  54      27.567  15.503  43.488  1.00 14.15           N  
ATOM    391  CA  SER A  54      28.910  15.094  43.107  1.00 17.02           C  
ATOM    392  C   SER A  54      28.992  14.787  41.621  1.00 15.52           C  
ATOM    393  O   SER A  54      30.026  14.343  41.132  1.00 16.19           O  
ATOM    394  CB  SER A  54      29.313  13.861  43.912  1.00 19.15           C  
ATOM    395  OG  SER A  54      29.132  14.101  45.298  1.00 22.15           O  
ATOM    396  N   ASP A  55      27.889  15.021  40.921  1.00 16.86           N  
ATOM    397  CA  ASP A  55      27.813  14.791  39.487  1.00 18.00           C  
ATOM    398  C   ASP A  55      26.850  15.807  38.882  1.00 17.81           C  
ATOM    399  O   ASP A  55      26.335  16.679  39.583  1.00 17.75           O  
ATOM    400  CB  ASP A  55      27.344  13.361  39.192  1.00 19.55           C  
ATOM    401  CG  ASP A  55      25.959  13.075  39.730  1.00 22.58           C  
ATOM    402  OD1 ASP A  55      25.494  11.922  39.581  1.00 24.63           O  
ATOM    403  OD2 ASP A  55      25.331  13.992  40.299  1.00 18.89           O  
ATOM    404  N   ASP A  56      26.599  15.692  37.585  1.00 16.84           N  
ATOM    405  CA  ASP A  56      25.721  16.634  36.918  1.00 20.28           C  
ATOM    406  C   ASP A  56      24.243  16.321  37.103  1.00 21.75           C  
ATOM    407  O   ASP A  56      23.538  15.997  36.147  1.00 22.21           O  
ATOM    408  CB  ASP A  56      26.067  16.706  35.433  1.00 20.55           C  
ATOM    409  CG  ASP A  56      25.412  17.881  34.750  1.00 21.94           C  
ATOM    410  OD1 ASP A  56      25.232  18.923  35.416  1.00 19.59           O  
ATOM    411  OD2 ASP A  56      25.092  17.766  33.550  1.00 21.68           O  
ATOM    412  N   THR A  57      23.779  16.429  38.344  1.00 24.21           N  
ATOM    413  CA  THR A  57      22.384  16.161  38.665  1.00 26.15           C  
ATOM    414  C   THR A  57      21.693  17.451  39.080  1.00 25.70           C  
ATOM    415  O   THR A  57      22.333  18.378  39.576  1.00 24.14           O  
ATOM    416  CB  THR A  57      22.245  15.165  39.831  1.00 28.15           C  
ATOM    417  OG1 THR A  57      23.214  14.121  39.696  1.00 32.81           O  
ATOM    418  CG2 THR A  57      20.852  14.540  39.827  1.00 32.41           C  
ATOM    419  N   PHE A  58      20.380  17.497  38.880  1.00 25.57           N  
ATOM    420  CA  PHE A  58      19.595  18.667  39.240  1.00 24.24           C  
ATOM    421  C   PHE A  58      19.164  18.590  40.697  1.00 22.79           C  
ATOM    422  O   PHE A  58      18.815  17.523  41.196  1.00 21.04           O  
ATOM    423  CB  PHE A  58      18.361  18.777  38.341  1.00 26.59           C  
ATOM    424  CG  PHE A  58      17.460  19.930  38.687  1.00 28.70           C  
ATOM    425  CD1 PHE A  58      16.416  19.771  39.595  1.00 28.96           C  
ATOM    426  CD2 PHE A  58      17.674  21.183  38.125  1.00 29.82           C  
ATOM    427  CE1 PHE A  58      15.599  20.844  39.939  1.00 29.36           C  
ATOM    428  CE2 PHE A  58      16.862  22.265  38.462  1.00 30.93           C  
ATOM    429  CZ  PHE A  58      15.823  22.095  39.372  1.00 31.04           C  
ATOM    430  N   LEU A  59      19.201  19.733  41.373  1.00 21.28           N  
ATOM    431  CA  LEU A  59      18.812  19.818  42.774  1.00 20.51           C  
ATOM    432  C   LEU A  59      18.123  21.140  43.049  1.00 18.95           C  
ATOM    433  O   LEU A  59      18.665  22.197  42.737  1.00 18.53           O  
ATOM    434  CB  LEU A  59      20.035  19.713  43.688  1.00 22.94           C  
ATOM    435  CG  LEU A  59      20.576  18.330  44.032  1.00 25.84           C  
ATOM    436  CD1 LEU A  59      21.793  18.468  44.929  1.00 28.23           C  
ATOM    437  CD2 LEU A  59      19.493  17.531  44.730  1.00 26.89           C  
ATOM    438  N   GLU A  60      16.932  21.079  43.633  1.00 17.03           N  
ATOM    439  CA  GLU A  60      16.191  22.286  43.971  1.00 17.19           C  
ATOM    440  C   GLU A  60      16.925  22.967  45.120  1.00 15.63           C  
ATOM    441  O   GLU A  60      17.654  22.316  45.866  1.00 14.60           O  
ATOM    442  CB  GLU A  60      14.771  21.929  44.413  1.00 19.71           C  
ATOM    443  CG  GLU A  60      13.958  21.214  43.345  1.00 23.63           C  
ATOM    444  CD  GLU A  60      13.369  22.163  42.318  1.00 26.87           C  
ATOM    445  OE1 GLU A  60      13.973  23.224  42.056  1.00 26.30           O  
ATOM    446  OE2 GLU A  60      12.299  21.837  41.761  1.00 30.58           O  
ATOM    447  N   LEU A  61      16.730  24.274  45.266  1.00 14.26           N  
ATOM    448  CA  LEU A  61      17.381  25.012  46.340  1.00 14.24           C  
ATOM    449  C   LEU A  61      16.987  24.438  47.699  1.00 14.02           C  
ATOM    450  O   LEU A  61      17.829  24.277  48.582  1.00 12.54           O  
ATOM    451  CB  LEU A  61      16.997  26.494  46.266  1.00 15.23           C  
ATOM    452  CG  LEU A  61      17.374  27.204  44.963  1.00 17.21           C  
ATOM    453  CD1 LEU A  61      16.825  28.628  44.982  1.00 18.73           C  
ATOM    454  CD2 LEU A  61      18.888  27.208  44.797  1.00 18.17           C  
ATOM    455  N   LYS A  62      15.705  24.121  47.859  1.00 15.08           N  
ATOM    456  CA  LYS A  62      15.206  23.567  49.113  1.00 14.38           C  
ATOM    457  C   LYS A  62      15.889  22.248  49.454  1.00 14.67           C  
ATOM    458  O   LYS A  62      16.142  21.952  50.623  1.00 14.61           O  
ATOM    459  CB  LYS A  62      13.701  23.364  49.028  1.00 16.51           C  
ATOM    460  N   GLN A  63      16.187  21.460  48.426  1.00 15.05           N  
ATOM    461  CA  GLN A  63      16.834  20.168  48.612  1.00 15.16           C  
ATOM    462  C   GLN A  63      18.265  20.320  49.126  1.00 14.21           C  
ATOM    463  O   GLN A  63      18.708  19.547  49.976  1.00 13.00           O  
ATOM    464  CB  GLN A  63      16.825  19.383  47.294  1.00 16.41           C  
ATOM    465  N   ARG A  64      18.983  21.313  48.607  1.00 12.60           N  
ATOM    466  CA  ARG A  64      20.361  21.560  49.022  1.00 11.47           C  
ATOM    467  C   ARG A  64      20.388  21.966  50.490  1.00 11.96           C  
ATOM    468  O   ARG A  64      21.253  21.528  51.256  1.00 12.01           O  
ATOM    469  CB  ARG A  64      20.978  22.665  48.162  1.00 11.84           C  
ATOM    470  CG  ARG A  64      21.014  22.331  46.678  1.00 11.18           C  
ATOM    471  CD  ARG A  64      21.097  23.579  45.819  1.00  9.26           C  
ATOM    472  NE  ARG A  64      20.908  23.262  44.406  1.00  9.23           N  
ATOM    473  CZ  ARG A  64      21.890  22.959  43.563  1.00 11.66           C  
ATOM    474  NH1 ARG A  64      23.150  22.934  43.983  1.00 10.68           N  
ATOM    475  NH2 ARG A  64      21.610  22.682  42.296  1.00 11.46           N  
ATOM    476  N   VAL A  65      19.440  22.813  50.880  1.00 10.85           N  
ATOM    477  CA  VAL A  65      19.360  23.270  52.263  1.00 10.58           C  
ATOM    478  C   VAL A  65      18.981  22.110  53.182  1.00 12.01           C  
ATOM    479  O   VAL A  65      19.565  21.939  54.254  1.00 10.94           O  
ATOM    480  CB  VAL A  65      18.308  24.399  52.426  1.00 10.92           C  
ATOM    481  CG1 VAL A  65      18.092  24.705  53.902  1.00 12.59           C  
ATOM    482  CG2 VAL A  65      18.761  25.645  51.684  1.00 11.35           C  
ATOM    483  N   LYS A  66      18.018  21.302  52.750  1.00 13.18           N  
ATOM    484  CA  LYS A  66      17.563  20.177  53.561  1.00 14.32           C  
ATOM    485  C   LYS A  66      18.697  19.238  53.958  1.00 13.84           C  
ATOM    486  O   LYS A  66      18.744  18.753  55.089  1.00 14.51           O  
ATOM    487  CB  LYS A  66      16.466  19.398  52.832  1.00 18.28           C  
ATOM    488  CG  LYS A  66      15.819  18.320  53.697  1.00 23.27           C  
ATOM    489  CD  LYS A  66      14.424  17.958  53.203  1.00 28.74           C  
ATOM    490  CE  LYS A  66      14.442  17.416  51.787  1.00 30.22           C  
ATOM    491  NZ  LYS A  66      13.069  17.051  51.328  1.00 32.86           N  
ATOM    492  N   VAL A  67      19.614  18.979  53.033  1.00 14.35           N  
ATOM    493  CA  VAL A  67      20.746  18.110  53.331  1.00 15.21           C  
ATOM    494  C   VAL A  67      21.560  18.702  54.475  1.00 13.01           C  
ATOM    495  O   VAL A  67      21.909  18.012  55.432  1.00 12.41           O  
ATOM    496  CB  VAL A  67      21.676  17.955  52.108  1.00 16.36           C  
ATOM    497  CG1 VAL A  67      22.915  17.156  52.493  1.00 20.36           C  
ATOM    498  CG2 VAL A  67      20.931  17.273  50.975  1.00 19.40           C  
ATOM    499  N   ALA A  68      21.870  19.988  54.365  1.00 12.86           N  
ATOM    500  CA  ALA A  68      22.645  20.668  55.388  1.00 11.36           C  
ATOM    501  C   ALA A  68      21.932  20.621  56.734  1.00 11.51           C  
ATOM    502  O   ALA A  68      22.550  20.335  57.754  1.00 12.51           O  
ATOM    503  CB  ALA A  68      22.904  22.116  54.976  1.00 10.97           C  
ATOM    504  N   GLU A  69      20.629  20.888  56.738  1.00 10.85           N  
ATOM    505  CA  GLU A  69      19.875  20.872  57.988  1.00 11.45           C  
ATOM    506  C   GLU A  69      19.768  19.475  58.583  1.00 12.16           C  
ATOM    507  O   GLU A  69      20.011  19.277  59.775  1.00 11.68           O  
ATOM    508  CB  GLU A  69      18.473  21.445  57.776  1.00 11.70           C  
ATOM    509  CG  GLU A  69      18.484  22.890  57.313  1.00 12.07           C  
ATOM    510  CD  GLU A  69      19.286  23.776  58.242  1.00 13.76           C  
ATOM    511  OE1 GLU A  69      20.121  24.562  57.746  1.00 11.39           O  
ATOM    512  OE2 GLU A  69      19.082  23.688  59.472  1.00 15.40           O  
ATOM    513  N   ASN A  70      19.411  18.507  57.746  1.00 13.05           N  
ATOM    514  CA  ASN A  70      19.257  17.131  58.203  1.00 14.08           C  
ATOM    515  C   ASN A  70      20.545  16.512  58.746  1.00 14.22           C  
ATOM    516  O   ASN A  70      20.516  15.792  59.741  1.00 14.36           O  
ATOM    517  CB  ASN A  70      18.688  16.267  57.075  1.00 13.46           C  
ATOM    518  CG  ASN A  70      18.573  14.803  57.465  1.00 14.03           C  
ATOM    519  OD1 ASN A  70      19.408  13.983  57.084  1.00 12.33           O  
ATOM    520  ND2 ASN A  70      17.543  14.471  58.241  1.00 14.19           N  
ATOM    521  N   LEU A  71      21.673  16.789  58.098  1.00 13.48           N  
ATOM    522  CA  LEU A  71      22.951  16.243  58.547  1.00 13.05           C  
ATOM    523  C   LEU A  71      23.608  17.120  59.609  1.00 13.09           C  
ATOM    524  O   LEU A  71      24.729  16.846  60.053  1.00 13.49           O  
ATOM    525  CB  LEU A  71      23.894  16.068  57.352  1.00 13.56           C  
ATOM    526  CG  LEU A  71      23.351  15.187  56.222  1.00 12.75           C  
ATOM    527  CD1 LEU A  71      24.412  15.038  55.128  1.00 13.85           C  
ATOM    528  CD2 LEU A  71      22.964  13.822  56.779  1.00 13.12           C  
ATOM    529  N   LYS A  72      22.895  18.166  60.018  1.00 13.61           N  
ATOM    530  CA  LYS A  72      23.374  19.104  61.028  1.00 14.09           C  
ATOM    531  C   LYS A  72      24.766  19.626  60.695  1.00 13.29           C  
ATOM    532  O   LYS A  72      25.687  19.537  61.504  1.00 13.36           O  
ATOM    533  CB  LYS A  72      23.386  18.439  62.408  1.00 18.64           C  
ATOM    534  CG  LYS A  72      22.031  17.903  62.848  1.00 21.43           C  
ATOM    535  CD  LYS A  72      22.072  17.369  64.277  1.00 26.33           C  
ATOM    536  CE  LYS A  72      23.106  16.265  64.442  1.00 29.33           C  
ATOM    537  NZ  LYS A  72      22.861  15.118  63.526  1.00 31.17           N  
ATOM    538  N   ALA A  73      24.914  20.176  59.496  1.00 11.67           N  
ATOM    539  CA  ALA A  73      26.204  20.699  59.068  1.00 12.05           C  
ATOM    540  C   ALA A  73      26.714  21.791  60.007  1.00 11.96           C  
ATOM    541  O   ALA A  73      25.931  22.533  60.595  1.00 12.12           O  
ATOM    542  CB  ALA A  73      26.094  21.247  57.643  1.00  8.99           C  
ATOM    543  N   ASN A  74      28.032  21.870  60.156  1.00 11.71           N  
ATOM    544  CA  ASN A  74      28.635  22.895  60.991  1.00 11.69           C  
ATOM    545  C   ASN A  74      28.801  24.139  60.126  1.00 11.48           C  
ATOM    546  O   ASN A  74      28.759  25.266  60.617  1.00 10.77           O  
ATOM    547  CB  ASN A  74      29.986  22.422  61.531  1.00 12.36           C  
ATOM    548  CG  ASN A  74      29.842  21.320  62.564  1.00 14.58           C  
ATOM    549  OD1 ASN A  74      29.499  20.183  62.236  1.00 15.75           O  
ATOM    550  ND2 ASN A  74      30.088  21.657  63.822  1.00 17.37           N  
ATOM    551  N   VAL A  75      28.998  23.919  58.830  1.00 12.44           N  
ATOM    552  CA  VAL A  75      29.116  25.016  57.875  1.00 11.65           C  
ATOM    553  C   VAL A  75      28.565  24.577  56.530  1.00 11.14           C  
ATOM    554  O   VAL A  75      28.497  23.386  56.226  1.00  9.99           O  
ATOM    555  CB  VAL A  75      30.576  25.480  57.663  1.00 12.52           C  
ATOM    556  CG1 VAL A  75      31.134  26.044  58.958  1.00 14.27           C  
ATOM    557  CG2 VAL A  75      31.429  24.327  57.152  1.00 14.36           C  
ATOM    558  N   PHE A  76      28.174  25.559  55.729  1.00  9.85           N  
ATOM    559  CA  PHE A  76      27.630  25.315  54.405  1.00  9.51           C  
ATOM    560  C   PHE A  76      28.301  26.294  53.452  1.00  9.36           C  
ATOM    561  O   PHE A  76      28.370  27.488  53.726  1.00 11.13           O  
ATOM    562  CB  PHE A  76      26.114  25.531  54.433  1.00  9.51           C  
ATOM    563  CG  PHE A  76      25.439  25.367  53.099  1.00  9.25           C  
ATOM    564  CD1 PHE A  76      25.299  26.450  52.238  1.00  9.75           C  
ATOM    565  CD2 PHE A  76      24.906  24.135  52.721  1.00 10.43           C  
ATOM    566  CE1 PHE A  76      24.633  26.315  51.019  1.00  7.81           C  
ATOM    567  CE2 PHE A  76      24.239  23.985  51.505  1.00  9.47           C  
ATOM    568  CZ  PHE A  76      24.101  25.080  50.653  1.00  9.67           C  
ATOM    569  N   VAL A  77      28.820  25.780  52.348  1.00  9.55           N  
ATOM    570  CA  VAL A  77      29.473  26.627  51.362  1.00  9.06           C  
ATOM    571  C   VAL A  77      28.915  26.307  49.988  1.00  7.40           C  
ATOM    572  O   VAL A  77      29.001  25.170  49.524  1.00  9.05           O  
ATOM    573  CB  VAL A  77      31.000  26.399  51.320  1.00  8.03           C  
ATOM    574  CG1 VAL A  77      31.632  27.299  50.261  1.00 10.67           C  
ATOM    575  CG2 VAL A  77      31.614  26.689  52.688  1.00  9.32           C  
ATOM    576  N   SER A  78      28.333  27.312  49.347  1.00  8.41           N  
ATOM    577  CA  SER A  78      27.791  27.133  48.009  1.00  6.91           C  
ATOM    578  C   SER A  78      28.783  27.791  47.057  1.00  8.50           C  
ATOM    579  O   SER A  78      29.186  28.934  47.267  1.00  9.92           O  
ATOM    580  CB  SER A  78      26.414  27.786  47.893  1.00  7.92           C  
ATOM    581  OG  SER A  78      25.816  27.449  46.653  1.00  8.68           O  
ATOM    582  N   ILE A  79      29.194  27.052  46.031  1.00  8.28           N  
ATOM    583  CA  ILE A  79      30.164  27.548  45.067  1.00  9.37           C  
ATOM    584  C   ILE A  79      29.499  27.894  43.742  1.00  8.33           C  
ATOM    585  O   ILE A  79      28.777  27.086  43.159  1.00 10.45           O  
ATOM    586  CB  ILE A  79      31.283  26.513  44.834  1.00  9.52           C  
ATOM    587  CG1 ILE A  79      31.993  26.213  46.160  1.00 11.30           C  
ATOM    588  CG2 ILE A  79      32.279  27.052  43.820  1.00 11.57           C  
ATOM    589  CD1 ILE A  79      33.090  25.155  46.048  1.00 11.15           C  
ATOM    590  N   HIS A  80      29.753  29.114  43.287  1.00  9.46           N  
ATOM    591  CA  HIS A  80      29.169  29.629  42.059  1.00  9.42           C  
ATOM    592  C   HIS A  80      30.171  30.439  41.244  1.00  9.94           C  
ATOM    593  O   HIS A  80      31.281  30.720  41.692  1.00 10.36           O  
ATOM    594  CB  HIS A  80      27.984  30.539  42.402  1.00  8.41           C  
ATOM    595  CG  HIS A  80      26.791  29.812  42.934  1.00  9.48           C  
ATOM    596  ND1 HIS A  80      25.670  29.569  42.173  1.00  9.43           N  
ATOM    597  CD2 HIS A  80      26.541  29.279  44.154  1.00  6.20           C  
ATOM    598  CE1 HIS A  80      24.777  28.920  42.898  1.00 10.07           C  
ATOM    599  NE2 HIS A  80      25.281  28.731  44.105  1.00  8.83           N  
ATOM    600  N   ALA A  81      29.753  30.800  40.034  1.00 11.35           N  
ATOM    601  CA  ALA A  81      30.541  31.632  39.131  1.00 12.15           C  
ATOM    602  C   ALA A  81      29.535  32.708  38.738  1.00 14.48           C  
ATOM    603  O   ALA A  81      28.351  32.416  38.540  1.00 14.00           O  
ATOM    604  CB  ALA A  81      30.996  30.842  37.911  1.00 14.91           C  
ATOM    605  N   ASN A  82      30.009  33.943  38.626  1.00 13.72           N  
ATOM    606  CA  ASN A  82      29.161  35.094  38.337  1.00 13.16           C  
ATOM    607  C   ASN A  82      28.978  35.435  36.858  1.00 13.21           C  
ATOM    608  O   ASN A  82      29.658  34.898  35.984  1.00 11.67           O  
ATOM    609  CB  ASN A  82      29.744  36.306  39.071  1.00 14.00           C  
ATOM    610  CG  ASN A  82      28.687  37.161  39.739  1.00 15.26           C  
ATOM    611  OD1 ASN A  82      28.979  37.871  40.703  1.00 20.35           O  
ATOM    612  ND2 ASN A  82      27.465  37.110  39.232  1.00 15.62           N  
ATOM    613  N   SER A  83      28.046  36.343  36.592  1.00 13.66           N  
ATOM    614  CA  SER A  83      27.776  36.788  35.234  1.00 14.29           C  
ATOM    615  C   SER A  83      27.195  38.187  35.291  1.00 15.01           C  
ATOM    616  O   SER A  83      26.427  38.514  36.199  1.00 15.28           O  
ATOM    617  CB  SER A  83      26.794  35.851  34.535  1.00 15.65           C  
ATOM    618  OG  SER A  83      26.728  36.151  33.152  1.00 19.07           O  
ATOM    619  N   SER A  84      27.572  39.009  34.318  1.00 13.96           N  
ATOM    620  CA  SER A  84      27.109  40.387  34.242  1.00 14.19           C  
ATOM    621  C   SER A  84      26.740  40.753  32.810  1.00 13.89           C  
ATOM    622  O   SER A  84      27.238  40.148  31.867  1.00 14.94           O  
ATOM    623  CB  SER A  84      28.209  41.327  34.730  1.00 14.68           C  
ATOM    624  OG  SER A  84      27.897  42.682  34.439  1.00 16.08           O  
ATOM    625  N   GLY A  85      25.871  41.747  32.663  1.00 14.81           N  
ATOM    626  CA  GLY A  85      25.469  42.198  31.342  1.00 15.03           C  
ATOM    627  C   GLY A  85      26.636  42.842  30.615  1.00 17.00           C  
ATOM    628  O   GLY A  85      26.608  42.996  29.393  1.00 19.15           O  
ATOM    629  N   SER A  86      27.661  43.233  31.367  1.00 16.46           N  
ATOM    630  CA  SER A  86      28.858  43.838  30.785  1.00 16.86           C  
ATOM    631  C   SER A  86      30.024  42.861  30.893  1.00 17.17           C  
ATOM    632  O   SER A  86      30.273  42.303  31.964  1.00 15.36           O  
ATOM    633  CB  SER A  86      29.224  45.130  31.516  1.00 16.25           C  
ATOM    634  OG  SER A  86      30.495  45.594  31.090  1.00 16.40           O  
ATOM    635  N   SER A  87      30.746  42.666  29.792  1.00 16.28           N  
ATOM    636  CA  SER A  87      31.879  41.742  29.790  1.00 17.14           C  
ATOM    637  C   SER A  87      33.055  42.299  30.586  1.00 15.75           C  
ATOM    638  O   SER A  87      34.047  41.605  30.815  1.00 16.44           O  
ATOM    639  CB  SER A  87      32.335  41.444  28.357  1.00 18.12           C  
ATOM    640  OG  SER A  87      33.114  42.508  27.836  1.00 17.94           O  
ATOM    641  N   ALA A  88      32.942  43.554  31.006  1.00 15.95           N  
ATOM    642  CA  ALA A  88      33.995  44.202  31.772  1.00 15.32           C  
ATOM    643  C   ALA A  88      33.985  43.788  33.243  1.00 15.00           C  
ATOM    644  O   ALA A  88      35.027  43.783  33.901  1.00 15.05           O  
ATOM    645  CB  ALA A  88      33.857  45.721  31.663  1.00 17.13           C  
ATOM    646  N   SER A  89      32.807  43.450  33.757  1.00 14.63           N  
ATOM    647  CA  SER A  89      32.678  43.060  35.161  1.00 14.10           C  
ATOM    648  C   SER A  89      33.623  41.919  35.512  1.00 13.81           C  
ATOM    649  O   SER A  89      33.789  40.979  34.737  1.00 14.66           O  
ATOM    650  CB  SER A  89      31.231  42.669  35.462  1.00 14.99           C  
ATOM    651  OG  SER A  89      30.360  43.749  35.165  1.00 14.98           O  
ATOM    652  N   ASN A  90      34.237  42.005  36.689  1.00 14.78           N  
ATOM    653  CA  ASN A  90      35.189  40.990  37.111  1.00 13.97           C  
ATOM    654  C   ASN A  90      35.446  41.031  38.609  1.00 12.26           C  
ATOM    655  O   ASN A  90      35.255  42.058  39.266  1.00 12.88           O  
ATOM    656  CB  ASN A  90      36.524  41.208  36.401  1.00 14.21           C  
ATOM    657  CG  ASN A  90      37.154  42.546  36.760  1.00 15.91           C  
ATOM    658  OD1 ASN A  90      36.736  43.597  36.271  1.00 18.76           O  
ATOM    659  ND2 ASN A  90      38.148  42.513  37.637  1.00 15.97           N  
ATOM    660  N   GLY A  91      35.891  39.906  39.148  1.00 11.71           N  
ATOM    661  CA  GLY A  91      36.191  39.874  40.562  1.00 10.75           C  
ATOM    662  C   GLY A  91      35.558  38.744  41.339  1.00 11.36           C  
ATOM    663  O   GLY A  91      34.666  38.044  40.862  1.00 11.05           O  
ATOM    664  N   THR A  92      36.041  38.595  42.566  1.00 11.59           N  
ATOM    665  CA  THR A  92      35.599  37.562  43.489  1.00 10.63           C  
ATOM    666  C   THR A  92      34.746  38.169  44.604  1.00 11.11           C  
ATOM    667  O   THR A  92      35.112  39.192  45.191  1.00 11.21           O  
ATOM    668  CB  THR A  92      36.821  36.872  44.115  1.00 11.60           C  
ATOM    669  OG1 THR A  92      37.614  36.290  43.073  1.00 10.43           O  
ATOM    670  CG2 THR A  92      36.391  35.807  45.093  1.00 10.51           C  
ATOM    671  N   GLU A  93      33.617  37.522  44.898  1.00 11.57           N  
ATOM    672  CA  GLU A  93      32.706  37.988  45.937  1.00 12.10           C  
ATOM    673  C   GLU A  93      32.291  36.842  46.869  1.00 10.60           C  
ATOM    674  O   GLU A  93      32.153  35.688  46.432  1.00 11.35           O  
ATOM    675  CB  GLU A  93      31.449  38.593  45.296  1.00 16.08           C  
ATOM    676  CG  GLU A  93      31.707  39.290  43.959  1.00 22.44           C  
ATOM    677  CD  GLU A  93      30.431  39.717  43.243  1.00 26.33           C  
ATOM    678  OE1 GLU A  93      29.372  39.076  43.447  1.00 25.42           O  
ATOM    679  OE2 GLU A  93      30.480  40.691  42.452  1.00 28.89           O  
ATOM    680  N   THR A  94      32.087  37.180  48.142  1.00 10.58           N  
ATOM    681  CA  THR A  94      31.670  36.220  49.159  1.00  9.65           C  
ATOM    682  C   THR A  94      30.393  36.782  49.752  1.00  9.93           C  
ATOM    683  O   THR A  94      30.368  37.936  50.161  1.00 11.80           O  
ATOM    684  CB  THR A  94      32.703  36.088  50.273  1.00 10.33           C  
ATOM    685  OG1 THR A  94      33.911  35.530  49.737  1.00 11.25           O  
ATOM    686  CG2 THR A  94      32.156  35.176  51.373  1.00 12.73           C  
ATOM    687  N   TYR A  95      29.336  35.976  49.772  1.00 10.67           N  
ATOM    688  CA  TYR A  95      28.043  36.405  50.300  1.00 10.33           C  
ATOM    689  C   TYR A  95      27.602  35.686  51.567  1.00 10.84           C  
ATOM    690  O   TYR A  95      27.886  34.504  51.760  1.00 11.52           O  
ATOM    691  CB  TYR A  95      26.947  36.182  49.262  1.00 11.00           C  
ATOM    692  CG  TYR A  95      27.042  37.055  48.047  1.00 12.37           C  
ATOM    693  CD1 TYR A  95      27.780  36.664  46.931  1.00 12.37           C  
ATOM    694  CD2 TYR A  95      26.376  38.277  48.006  1.00 13.03           C  
ATOM    695  CE1 TYR A  95      27.846  37.472  45.799  1.00 12.93           C  
ATOM    696  CE2 TYR A  95      26.433  39.088  46.887  1.00 12.29           C  
ATOM    697  CZ  TYR A  95      27.166  38.683  45.788  1.00 12.73           C  
ATOM    698  OH  TYR A  95      27.198  39.481  44.669  1.00 14.51           O  
ATOM    699  N   TYR A  96      26.882  36.412  52.416  1.00  9.90           N  
ATOM    700  CA  TYR A  96      26.316  35.866  53.644  1.00 10.38           C  
ATOM    701  C   TYR A  96      24.908  36.462  53.649  1.00  9.78           C  
ATOM    702  O   TYR A  96      24.654  37.442  52.943  1.00 10.50           O  
ATOM    703  CB  TYR A  96      27.073  36.356  54.885  1.00 10.11           C  
ATOM    704  CG  TYR A  96      26.788  37.803  55.219  1.00 11.44           C  
ATOM    705  CD1 TYR A  96      27.452  38.838  54.560  1.00 12.70           C  
ATOM    706  CD2 TYR A  96      25.793  38.142  56.138  1.00 13.50           C  
ATOM    707  CE1 TYR A  96      27.128  40.173  54.807  1.00 12.92           C  
ATOM    708  CE2 TYR A  96      25.462  39.467  56.388  1.00 14.55           C  
ATOM    709  CZ  TYR A  96      26.133  40.476  55.717  1.00 16.05           C  
ATOM    710  OH  TYR A  96      25.795  41.784  55.952  1.00 18.93           O  
ATOM    711  N   GLN A  97      23.994  35.884  54.421  1.00 10.36           N  
ATOM    712  CA  GLN A  97      22.632  36.419  54.495  1.00  9.71           C  
ATOM    713  C   GLN A  97      22.218  36.623  55.942  1.00  8.51           C  
ATOM    714  O   GLN A  97      21.415  37.502  56.246  1.00 11.00           O  
ATOM    715  CB  GLN A  97      21.631  35.486  53.800  1.00 10.41           C  
ATOM    716  CG  GLN A  97      20.248  36.102  53.517  1.00  9.69           C  
ATOM    717  CD  GLN A  97      19.302  36.094  54.714  1.00 12.34           C  
ATOM    718  OE1 GLN A  97      19.283  35.150  55.508  1.00 11.46           O  
ATOM    719  NE2 GLN A  97      18.487  37.140  54.828  1.00 10.16           N  
ATOM    720  N   ARG A  98      22.783  35.819  56.836  1.00 10.17           N  
ATOM    721  CA  ARG A  98      22.456  35.915  58.254  1.00  9.73           C  
ATOM    722  C   ARG A  98      23.633  36.378  59.095  1.00  9.07           C  
ATOM    723  O   ARG A  98      24.787  36.113  58.772  1.00 11.08           O  
ATOM    724  CB  ARG A  98      21.961  34.563  58.775  1.00  8.51           C  
ATOM    725  CG  ARG A  98      20.585  34.189  58.263  1.00 10.74           C  
ATOM    726  CD  ARG A  98      20.270  32.721  58.494  1.00  9.66           C  
ATOM    727  NE  ARG A  98      21.100  31.843  57.674  1.00 11.24           N  
ATOM    728  CZ  ARG A  98      22.117  31.120  58.131  1.00 10.43           C  
ATOM    729  NH1 ARG A  98      22.441  31.163  59.418  1.00 11.88           N  
ATOM    730  NH2 ARG A  98      22.809  30.348  57.298  1.00 10.20           N  
ATOM    731  N   SER A  99      23.329  37.080  60.179  1.00 10.60           N  
ATOM    732  CA  SER A  99      24.364  37.578  61.071  1.00 11.29           C  
ATOM    733  C   SER A  99      25.303  36.468  61.541  1.00 11.82           C  
ATOM    734  O   SER A  99      26.518  36.648  61.575  1.00 14.52           O  
ATOM    735  CB  SER A  99      23.725  38.249  62.292  1.00 13.27           C  
ATOM    736  OG  SER A  99      24.719  38.639  63.225  1.00 14.12           O  
ATOM    737  N   ALA A 100      24.733  35.321  61.899  1.00 13.38           N  
ATOM    738  CA  ALA A 100      25.511  34.188  62.391  1.00 13.17           C  
ATOM    739  C   ALA A 100      26.495  33.612  61.372  1.00 12.70           C  
ATOM    740  O   ALA A 100      27.338  32.780  61.720  1.00 13.44           O  
ATOM    741  CB  ALA A 100      24.569  33.087  62.886  1.00 13.84           C  
ATOM    742  N   SER A 101      26.392  34.055  60.120  1.00 11.08           N  
ATOM    743  CA  SER A 101      27.277  33.580  59.054  1.00 10.78           C  
ATOM    744  C   SER A 101      28.405  34.563  58.739  1.00 12.42           C  
ATOM    745  O   SER A 101      29.330  34.234  57.998  1.00 12.44           O  
ATOM    746  CB  SER A 101      26.477  33.342  57.765  1.00  8.28           C  
ATOM    747  OG  SER A 101      25.479  32.352  57.936  1.00  8.78           O  
ATOM    748  N   LYS A 102      28.331  35.769  59.294  1.00 13.41           N  
ATOM    749  CA  LYS A 102      29.350  36.775  59.007  1.00 13.40           C  
ATOM    750  C   LYS A 102      30.771  36.397  59.417  1.00 13.42           C  
ATOM    751  O   LYS A 102      31.715  36.642  58.663  1.00 13.36           O  
ATOM    752  CB  LYS A 102      28.967  38.114  59.646  1.00 15.66           C  
ATOM    753  CG  LYS A 102      27.587  38.603  59.237  1.00 21.48           C  
ATOM    754  CD  LYS A 102      27.324  40.028  59.711  1.00 27.08           C  
ATOM    755  CE  LYS A 102      28.183  41.028  58.952  1.00 29.66           C  
ATOM    756  NZ  LYS A 102      27.888  42.435  59.345  1.00 32.14           N  
ATOM    757  N   ALA A 103      30.929  35.803  60.597  1.00 11.30           N  
ATOM    758  CA  ALA A 103      32.258  35.416  61.067  1.00 12.05           C  
ATOM    759  C   ALA A 103      32.885  34.451  60.076  1.00 11.58           C  
ATOM    760  O   ALA A 103      34.048  34.587  59.706  1.00 13.15           O  
ATOM    761  CB  ALA A 103      32.165  34.764  62.441  1.00 11.69           C  
ATOM    762  N   PHE A 104      32.097  33.476  59.645  1.00 11.54           N  
ATOM    763  CA  PHE A 104      32.568  32.488  58.690  1.00 11.95           C  
ATOM    764  C   PHE A 104      32.885  33.171  57.356  1.00 10.98           C  
ATOM    765  O   PHE A 104      33.903  32.881  56.737  1.00 11.97           O  
ATOM    766  CB  PHE A 104      31.504  31.398  58.520  1.00 11.29           C  
ATOM    767  CG  PHE A 104      31.862  30.333  57.517  1.00 10.24           C  
ATOM    768  CD1 PHE A 104      33.178  29.895  57.370  1.00 10.46           C  
ATOM    769  CD2 PHE A 104      30.871  29.743  56.746  1.00  8.93           C  
ATOM    770  CE1 PHE A 104      33.493  28.877  56.460  1.00  9.49           C  
ATOM    771  CE2 PHE A 104      31.170  28.727  55.838  1.00 10.79           C  
ATOM    772  CZ  PHE A 104      32.488  28.293  55.695  1.00  8.62           C  
ATOM    773  N   ALA A 105      32.024  34.080  56.911  1.00 10.50           N  
ATOM    774  CA  ALA A 105      32.286  34.776  55.652  1.00 10.68           C  
ATOM    775  C   ALA A 105      33.621  35.522  55.739  1.00 10.83           C  
ATOM    776  O   ALA A 105      34.410  35.511  54.795  1.00 10.40           O  
ATOM    777  CB  ALA A 105      31.156  35.756  55.337  1.00 11.46           C  
ATOM    778  N   ASN A 106      33.872  36.162  56.877  1.00 12.46           N  
ATOM    779  CA  ASN A 106      35.122  36.897  57.067  1.00 13.85           C  
ATOM    780  C   ASN A 106      36.330  35.966  56.979  1.00 13.31           C  
ATOM    781  O   ASN A 106      37.294  36.258  56.275  1.00 15.33           O  
ATOM    782  CB  ASN A 106      35.133  37.616  58.422  1.00 15.64           C  
ATOM    783  CG  ASN A 106      34.157  38.780  58.476  1.00 21.93           C  
ATOM    784  OD1 ASN A 106      34.060  39.568  57.537  1.00 23.48           O  
ATOM    785  ND2 ASN A 106      33.441  38.904  59.590  1.00 26.30           N  
ATOM    786  N   VAL A 107      36.284  34.849  57.698  1.00 12.45           N  
ATOM    787  CA  VAL A 107      37.399  33.908  57.667  1.00 12.78           C  
ATOM    788  C   VAL A 107      37.533  33.321  56.264  1.00 12.54           C  
ATOM    789  O   VAL A 107      38.625  33.290  55.699  1.00 12.55           O  
ATOM    790  CB  VAL A 107      37.210  32.770  58.701  1.00 12.53           C  
ATOM    791  CG1 VAL A 107      38.338  31.740  58.580  1.00 13.51           C  
ATOM    792  CG2 VAL A 107      37.191  33.359  60.110  1.00 13.78           C  
ATOM    793  N   MET A 108      36.421  32.868  55.694  1.00 11.02           N  
ATOM    794  CA  MET A 108      36.460  32.296  54.352  1.00 11.67           C  
ATOM    795  C   MET A 108      37.088  33.263  53.349  1.00 11.48           C  
ATOM    796  O   MET A 108      38.006  32.901  52.615  1.00 11.67           O  
ATOM    797  CB  MET A 108      35.048  31.925  53.886  1.00 11.65           C  
ATOM    798  CG  MET A 108      34.975  31.475  52.435  1.00 11.87           C  
ATOM    799  SD  MET A 108      36.009  30.028  52.090  1.00 11.24           S  
ATOM    800  CE  MET A 108      34.924  28.732  52.662  1.00 11.01           C  
ATOM    801  N   HIS A 109      36.602  34.497  53.324  1.00 11.86           N  
ATOM    802  CA  HIS A 109      37.120  35.488  52.387  1.00 11.84           C  
ATOM    803  C   HIS A 109      38.618  35.716  52.565  1.00 12.06           C  
ATOM    804  O   HIS A 109      39.340  35.920  51.595  1.00 12.40           O  
ATOM    805  CB  HIS A 109      36.381  36.818  52.553  1.00 12.24           C  
ATOM    806  CG  HIS A 109      36.470  37.705  51.352  1.00 14.18           C  
ATOM    807  ND1 HIS A 109      35.882  37.386  50.146  1.00 15.81           N  
ATOM    808  CD2 HIS A 109      37.092  38.895  51.163  1.00 13.07           C  
ATOM    809  CE1 HIS A 109      36.138  38.339  49.269  1.00 15.84           C  
ATOM    810  NE2 HIS A 109      36.870  39.266  49.860  1.00 14.93           N  
ATOM    811  N   LYS A 110      39.071  35.683  53.815  1.00 12.44           N  
ATOM    812  CA  LYS A 110      40.483  35.888  54.143  1.00 11.84           C  
ATOM    813  C   LYS A 110      41.406  34.944  53.365  1.00 12.56           C  
ATOM    814  O   LYS A 110      42.479  35.343  52.910  1.00 14.98           O  
ATOM    815  CB  LYS A 110      40.695  35.689  55.649  1.00 13.32           C  
ATOM    816  CG  LYS A 110      42.111  35.974  56.141  1.00 13.59           C  
ATOM    817  CD  LYS A 110      42.243  35.694  57.633  1.00 18.94           C  
ATOM    818  CE  LYS A 110      43.541  36.264  58.201  1.00 23.73           C  
ATOM    819  NZ  LYS A 110      44.740  35.849  57.424  1.00 27.38           N  
ATOM    820  N   TYR A 111      40.987  33.696  53.201  1.00 12.85           N  
ATOM    821  CA  TYR A 111      41.811  32.720  52.488  1.00 14.41           C  
ATOM    822  C   TYR A 111      41.373  32.477  51.055  1.00 14.56           C  
ATOM    823  O   TYR A 111      42.187  32.185  50.174  1.00 15.27           O  
ATOM    824  CB  TYR A 111      41.821  31.399  53.255  1.00 16.20           C  
ATOM    825  CG  TYR A 111      42.353  31.561  54.655  1.00 16.53           C  
ATOM    826  CD1 TYR A 111      41.493  31.811  55.725  1.00 16.81           C  
ATOM    827  CD2 TYR A 111      43.725  31.536  54.901  1.00 17.13           C  
ATOM    828  CE1 TYR A 111      41.990  32.038  57.008  1.00 17.63           C  
ATOM    829  CE2 TYR A 111      44.230  31.762  56.172  1.00 17.05           C  
ATOM    830  CZ  TYR A 111      43.358  32.014  57.220  1.00 17.67           C  
ATOM    831  OH  TYR A 111      43.861  32.248  58.479  1.00 18.63           O  
ATOM    832  N   PHE A 112      40.076  32.606  50.829  1.00 14.18           N  
ATOM    833  CA  PHE A 112      39.488  32.394  49.517  1.00 13.99           C  
ATOM    834  C   PHE A 112      39.834  33.495  48.505  1.00 14.26           C  
ATOM    835  O   PHE A 112      40.334  33.214  47.413  1.00 12.97           O  
ATOM    836  CB  PHE A 112      37.970  32.269  49.695  1.00 13.96           C  
ATOM    837  CG  PHE A 112      37.181  32.429  48.433  1.00 13.77           C  
ATOM    838  CD1 PHE A 112      36.136  33.348  48.377  1.00 11.67           C  
ATOM    839  CD2 PHE A 112      37.448  31.647  47.316  1.00 13.54           C  
ATOM    840  CE1 PHE A 112      35.369  33.484  47.228  1.00 11.39           C  
ATOM    841  CE2 PHE A 112      36.684  31.776  46.162  1.00 10.99           C  
ATOM    842  CZ  PHE A 112      35.645  32.692  46.116  1.00 11.27           C  
ATOM    843  N   ALA A 113      39.581  34.745  48.875  1.00 14.40           N  
ATOM    844  CA  ALA A 113      39.831  35.872  47.984  1.00 15.26           C  
ATOM    845  C   ALA A 113      41.250  35.962  47.415  1.00 14.49           C  
ATOM    846  O   ALA A 113      41.431  36.054  46.202  1.00 15.07           O  
ATOM    847  CB  ALA A 113      39.458  37.179  48.690  1.00 16.42           C  
ATOM    848  N   PRO A 114      42.277  35.943  48.280  1.00 15.15           N  
ATOM    849  CA  PRO A 114      43.654  36.029  47.778  1.00 14.80           C  
ATOM    850  C   PRO A 114      44.011  34.878  46.845  1.00 14.46           C  
ATOM    851  O   PRO A 114      44.834  35.032  45.944  1.00 15.66           O  
ATOM    852  CB  PRO A 114      44.490  36.004  49.056  1.00 15.38           C  
ATOM    853  CG  PRO A 114      43.576  36.631  50.068  1.00 16.80           C  
ATOM    854  CD  PRO A 114      42.259  35.969  49.752  1.00 15.63           C  
ATOM    855  N   ALA A 115      43.385  33.724  47.061  1.00 14.01           N  
ATOM    856  CA  ALA A 115      43.652  32.552  46.236  1.00 14.80           C  
ATOM    857  C   ALA A 115      43.206  32.719  44.785  1.00 13.92           C  
ATOM    858  O   ALA A 115      43.836  32.178  43.882  1.00 12.90           O  
ATOM    859  CB  ALA A 115      42.995  31.312  46.852  1.00 12.52           C  
ATOM    860  N   THR A 116      42.123  33.455  44.547  1.00 14.86           N  
ATOM    861  CA  THR A 116      41.669  33.647  43.172  1.00 15.62           C  
ATOM    862  C   THR A 116      42.597  34.618  42.450  1.00 17.31           C  
ATOM    863  O   THR A 116      42.792  34.523  41.237  1.00 17.43           O  
ATOM    864  CB  THR A 116      40.233  34.213  43.095  1.00 13.69           C  
ATOM    865  OG1 THR A 116      40.230  35.586  43.501  1.00 15.10           O  
ATOM    866  CG2 THR A 116      39.293  33.413  43.992  1.00 12.24           C  
ATOM    867  N   GLY A 117      43.168  35.551  43.207  1.00 19.05           N  
ATOM    868  CA  GLY A 117      44.060  36.533  42.619  1.00 19.20           C  
ATOM    869  C   GLY A 117      43.302  37.505  41.736  1.00 18.82           C  
ATOM    870  O   GLY A 117      43.902  38.312  41.030  1.00 20.75           O  
ATOM    871  N   LEU A 118      41.976  37.426  41.772  1.00 16.16           N  
ATOM    872  CA  LEU A 118      41.136  38.308  40.973  1.00 14.63           C  
ATOM    873  C   LEU A 118      40.779  39.533  41.806  1.00 15.02           C  
ATOM    874  O   LEU A 118      41.112  39.605  42.990  1.00 14.10           O  
ATOM    875  CB  LEU A 118      39.865  37.576  40.544  1.00 14.51           C  
ATOM    876  CG  LEU A 118      40.085  36.232  39.840  1.00 13.63           C  
ATOM    877  CD1 LEU A 118      38.735  35.571  39.580  1.00 13.95           C  
ATOM    878  CD2 LEU A 118      40.842  36.443  38.532  1.00 13.36           C  
ATOM    879  N   THR A 119      40.104  40.499  41.194  1.00 15.74           N  
ATOM    880  CA  THR A 119      39.739  41.701  41.924  1.00 15.84           C  
ATOM    881  C   THR A 119      38.875  41.347  43.125  1.00 17.27           C  
ATOM    882  O   THR A 119      37.859  40.663  42.995  1.00 15.65           O  
ATOM    883  CB  THR A 119      38.988  42.697  41.033  1.00 17.59           C  
ATOM    884  OG1 THR A 119      39.836  43.090  39.947  1.00 16.59           O  
ATOM    885  CG2 THR A 119      38.591  43.932  41.836  1.00 17.98           C  
ATOM    886  N   ASP A 120      39.298  41.814  44.293  1.00 16.48           N  
ATOM    887  CA  ASP A 120      38.586  41.554  45.534  1.00 15.64           C  
ATOM    888  C   ASP A 120      37.348  42.428  45.646  1.00 16.67           C  
ATOM    889  O   ASP A 120      37.441  43.613  45.970  1.00 15.46           O  
ATOM    890  CB  ASP A 120      39.513  41.811  46.720  1.00 17.04           C  
ATOM    891  CG  ASP A 120      38.847  41.554  48.050  1.00 16.26           C  
ATOM    892  OD1 ASP A 120      39.517  41.731  49.085  1.00 18.03           O  
ATOM    893  OD2 ASP A 120      37.658  41.174  48.066  1.00 15.72           O  
ATOM    894  N   ARG A 121      36.184  41.841  45.384  1.00 14.56           N  
ATOM    895  CA  ARG A 121      34.937  42.585  45.463  1.00 15.26           C  
ATOM    896  C   ARG A 121      34.332  42.524  46.867  1.00 16.02           C  
ATOM    897  O   ARG A 121      33.220  42.999  47.098  1.00 14.41           O  
ATOM    898  CB  ARG A 121      33.948  42.062  44.422  1.00 17.33           C  
ATOM    899  CG  ARG A 121      34.432  42.198  42.976  1.00 18.80           C  
ATOM    900  CD  ARG A 121      33.396  41.621  42.025  1.00 23.28           C  
ATOM    901  NE  ARG A 121      32.136  42.343  42.146  1.00 23.88           N  
ATOM    902  CZ  ARG A 121      31.731  43.290  41.308  1.00 26.71           C  
ATOM    903  NH1 ARG A 121      32.486  43.626  40.268  1.00 27.17           N  
ATOM    904  NH2 ARG A 121      30.584  43.919  41.529  1.00 26.33           N  
ATOM    905  N   GLY A 122      35.079  41.933  47.796  1.00 14.80           N  
ATOM    906  CA  GLY A 122      34.655  41.857  49.183  1.00 14.18           C  
ATOM    907  C   GLY A 122      33.543  40.914  49.596  1.00 13.22           C  
ATOM    908  O   GLY A 122      33.109  40.042  48.838  1.00 13.38           O  
ATOM    909  N   ILE A 123      33.098  41.106  50.837  1.00 13.56           N  
ATOM    910  CA  ILE A 123      32.031  40.319  51.443  1.00 12.87           C  
ATOM    911  C   ILE A 123      30.761  41.151  51.367  1.00 14.06           C  
ATOM    912  O   ILE A 123      30.742  42.306  51.790  1.00 12.10           O  
ATOM    913  CB  ILE A 123      32.368  40.000  52.910  1.00 13.93           C  
ATOM    914  CG1 ILE A 123      33.690  39.225  52.965  1.00 15.04           C  
ATOM    915  CG2 ILE A 123      31.248  39.193  53.544  1.00 14.54           C  
ATOM    916  CD1 ILE A 123      34.284  39.098  54.357  1.00 16.04           C  
ATOM    917  N   ARG A 124      29.701  40.561  50.827  1.00 13.15           N  
ATOM    918  CA  ARG A 124      28.449  41.284  50.655  1.00 16.12           C  
ATOM    919  C   ARG A 124      27.231  40.514  51.137  1.00 15.28           C  
ATOM    920  O   ARG A 124      27.261  39.292  51.262  1.00 12.43           O  
ATOM    921  CB  ARG A 124      28.260  41.605  49.171  1.00 18.93           C  
ATOM    922  CG  ARG A 124      29.532  42.075  48.480  1.00 22.41           C  
ATOM    923  CD  ARG A 124      29.300  42.331  47.001  1.00 25.89           C  
ATOM    924  NE  ARG A 124      30.396  43.102  46.425  1.00 28.72           N  
ATOM    925  CZ  ARG A 124      30.265  43.930  45.395  1.00 28.42           C  
ATOM    926  NH1 ARG A 124      29.079  44.090  44.824  1.00 30.34           N  
ATOM    927  NH2 ARG A 124      31.313  44.608  44.947  1.00 29.05           N  
ATOM    928  N   TYR A 125      26.156  41.246  51.402  1.00 14.62           N  
ATOM    929  CA  TYR A 125      24.917  40.623  51.819  1.00 12.41           C  
ATOM    930  C   TYR A 125      24.246  40.131  50.548  1.00 12.43           C  
ATOM    931  O   TYR A 125      24.242  40.825  49.530  1.00 11.23           O  
ATOM    932  CB  TYR A 125      23.997  41.627  52.524  1.00 12.02           C  
ATOM    933  CG  TYR A 125      22.588  41.108  52.713  1.00  9.80           C  
ATOM    934  CD1 TYR A 125      21.593  41.363  51.767  1.00 10.28           C  
ATOM    935  CD2 TYR A 125      22.258  40.333  53.817  1.00 10.40           C  
ATOM    936  CE1 TYR A 125      20.303  40.858  51.923  1.00  9.00           C  
ATOM    937  CE2 TYR A 125      20.973  39.821  53.984  1.00  9.57           C  
ATOM    938  CZ  TYR A 125      20.002  40.088  53.033  1.00 10.04           C  
ATOM    939  OH  TYR A 125      18.737  39.584  53.199  1.00 10.61           O  
ATOM    940  N   GLY A 126      23.703  38.923  50.604  1.00 12.13           N  
ATOM    941  CA  GLY A 126      23.022  38.366  49.454  1.00 11.39           C  
ATOM    942  C   GLY A 126      21.825  37.566  49.922  1.00 12.23           C  
ATOM    943  O   GLY A 126      21.969  36.634  50.717  1.00 11.89           O  
ATOM    944  N   ASN A 127      20.638  37.932  49.454  1.00 10.59           N  
ATOM    945  CA  ASN A 127      19.436  37.215  49.842  1.00 11.99           C  
ATOM    946  C   ASN A 127      19.247  35.998  48.949  1.00 12.35           C  
ATOM    947  O   ASN A 127      18.367  35.969  48.093  1.00 13.24           O  
ATOM    948  CB  ASN A 127      18.209  38.124  49.764  1.00 10.75           C  
ATOM    949  CG  ASN A 127      16.950  37.432  50.249  1.00 14.51           C  
ATOM    950  OD1 ASN A 127      16.988  36.657  51.207  1.00 16.06           O  
ATOM    951  ND2 ASN A 127      15.829  37.714  49.601  1.00 15.04           N  
ATOM    952  N   PHE A 128      20.086  34.990  49.166  1.00 13.31           N  
ATOM    953  CA  PHE A 128      20.042  33.761  48.384  1.00 11.58           C  
ATOM    954  C   PHE A 128      19.508  32.626  49.247  1.00 11.27           C  
ATOM    955  O   PHE A 128      19.961  32.422  50.372  1.00 10.86           O  
ATOM    956  CB  PHE A 128      21.446  33.431  47.872  1.00 12.77           C  
ATOM    957  CG  PHE A 128      22.092  34.560  47.109  1.00 15.59           C  
ATOM    958  CD1 PHE A 128      23.429  34.880  47.315  1.00 16.08           C  
ATOM    959  CD2 PHE A 128      21.357  35.311  46.194  1.00 19.27           C  
ATOM    960  CE1 PHE A 128      24.029  35.931  46.627  1.00 15.83           C  
ATOM    961  CE2 PHE A 128      21.949  36.368  45.499  1.00 20.36           C  
ATOM    962  CZ  PHE A 128      23.286  36.678  45.717  1.00 19.66           C  
ATOM    963  N   HIS A 129      18.548  31.889  48.701  1.00 10.84           N  
ATOM    964  CA  HIS A 129      17.899  30.789  49.401  1.00 11.25           C  
ATOM    965  C   HIS A 129      18.822  29.885  50.215  1.00  9.45           C  
ATOM    966  O   HIS A 129      18.619  29.702  51.411  1.00 10.02           O  
ATOM    967  CB  HIS A 129      17.113  29.937  48.396  1.00 12.19           C  
ATOM    968  CG  HIS A 129      16.249  28.890  49.031  1.00 14.48           C  
ATOM    969  ND1 HIS A 129      14.878  28.876  48.891  1.00 17.10           N  
ATOM    970  CD2 HIS A 129      16.559  27.823  49.805  1.00 16.07           C  
ATOM    971  CE1 HIS A 129      14.380  27.845  49.553  1.00 16.75           C  
ATOM    972  NE2 HIS A 129      15.378  27.190  50.115  1.00 15.51           N  
ATOM    973  N   VAL A 130      19.837  29.318  49.573  1.00 10.54           N  
ATOM    974  CA  VAL A 130      20.723  28.399  50.282  1.00  9.13           C  
ATOM    975  C   VAL A 130      21.467  28.963  51.491  1.00  7.65           C  
ATOM    976  O   VAL A 130      21.811  28.207  52.399  1.00  8.62           O  
ATOM    977  CB  VAL A 130      21.734  27.731  49.313  1.00  9.26           C  
ATOM    978  CG1 VAL A 130      20.972  26.988  48.216  1.00 10.24           C  
ATOM    979  CG2 VAL A 130      22.659  28.767  48.712  1.00 11.39           C  
ATOM    980  N   ILE A 131      21.717  30.271  51.527  1.00  8.74           N  
ATOM    981  CA  ILE A 131      22.408  30.836  52.685  1.00  9.05           C  
ATOM    982  C   ILE A 131      21.428  31.517  53.647  1.00  8.61           C  
ATOM    983  O   ILE A 131      21.785  31.886  54.766  1.00  9.20           O  
ATOM    984  CB  ILE A 131      23.545  31.822  52.261  1.00  9.26           C  
ATOM    985  CG1 ILE A 131      23.017  32.917  51.326  1.00  8.35           C  
ATOM    986  CG2 ILE A 131      24.652  31.041  51.548  1.00  8.81           C  
ATOM    987  CD1 ILE A 131      24.069  33.985  50.984  1.00  7.59           C  
ATOM    988  N   ARG A 132      20.181  31.652  53.205  1.00 10.02           N  
ATOM    989  CA  ARG A 132      19.133  32.266  54.014  1.00 10.07           C  
ATOM    990  C   ARG A 132      18.378  31.236  54.848  1.00 11.86           C  
ATOM    991  O   ARG A 132      18.148  31.438  56.040  1.00 12.42           O  
ATOM    992  CB  ARG A 132      18.119  32.978  53.119  1.00 11.88           C  
ATOM    993  CG  ARG A 132      16.904  33.494  53.879  1.00 14.63           C  
ATOM    994  CD  ARG A 132      15.877  34.105  52.940  1.00 14.89           C  
ATOM    995  NE  ARG A 132      15.269  33.108  52.063  1.00 15.50           N  
ATOM    996  CZ  ARG A 132      15.314  33.153  50.734  1.00 16.95           C  
ATOM    997  NH1 ARG A 132      15.940  34.146  50.120  1.00 15.72           N  
ATOM    998  NH2 ARG A 132      14.725  32.205  50.017  1.00 16.29           N  
ATOM    999  N   GLU A 133      17.986  30.141  54.201  1.00 11.10           N  
ATOM   1000  CA  GLU A 133      17.212  29.087  54.848  1.00 12.51           C  
ATOM   1001  C   GLU A 133      18.031  28.122  55.694  1.00 13.07           C  
ATOM   1002  O   GLU A 133      17.472  27.359  56.481  1.00 12.03           O  
ATOM   1003  CB  GLU A 133      16.405  28.326  53.795  1.00 12.75           C  
ATOM   1004  CG  GLU A 133      15.442  29.230  53.030  1.00 14.43           C  
ATOM   1005  CD  GLU A 133      14.446  29.934  53.943  1.00 16.98           C  
ATOM   1006  OE1 GLU A 133      14.114  31.110  53.681  1.00 16.08           O  
ATOM   1007  OE2 GLU A 133      13.990  29.308  54.920  1.00 17.91           O  
ATOM   1008  N   THR A 134      19.348  28.155  55.531  1.00 12.42           N  
ATOM   1009  CA  THR A 134      20.224  27.302  56.325  1.00 13.07           C  
ATOM   1010  C   THR A 134      20.281  27.906  57.724  1.00 12.64           C  
ATOM   1011  O   THR A 134      20.041  29.104  57.894  1.00 11.84           O  
ATOM   1012  CB  THR A 134      21.638  27.248  55.728  1.00 12.82           C  
ATOM   1013  OG1 THR A 134      21.914  28.476  55.043  1.00 11.69           O  
ATOM   1014  CG2 THR A 134      21.759  26.077  54.754  1.00  9.43           C  
ATOM   1015  N   THR A 135      20.589  27.082  58.722  1.00 12.89           N  
ATOM   1016  CA  THR A 135      20.652  27.557  60.101  1.00 12.66           C  
ATOM   1017  C   THR A 135      22.062  27.569  60.675  1.00 12.10           C  
ATOM   1018  O   THR A 135      22.269  28.032  61.796  1.00 12.78           O  
ATOM   1019  CB  THR A 135      19.773  26.705  61.031  1.00 14.17           C  
ATOM   1020  OG1 THR A 135      20.282  25.366  61.069  1.00 13.44           O  
ATOM   1021  CG2 THR A 135      18.332  26.684  60.532  1.00 15.60           C  
ATOM   1022  N   MET A 136      23.024  27.036  59.926  1.00 10.38           N  
ATOM   1023  CA  MET A 136      24.410  27.034  60.376  1.00 10.09           C  
ATOM   1024  C   MET A 136      25.143  28.090  59.552  1.00  9.21           C  
ATOM   1025  O   MET A 136      24.593  28.606  58.575  1.00  9.80           O  
ATOM   1026  CB  MET A 136      25.058  25.653  60.161  1.00 10.00           C  
ATOM   1027  CG  MET A 136      25.336  25.267  58.701  1.00  9.29           C  
ATOM   1028  SD  MET A 136      23.869  24.907  57.701  1.00 10.88           S  
ATOM   1029  CE  MET A 136      23.044  23.630  58.725  1.00 11.21           C  
ATOM   1030  N   PRO A 137      26.384  28.439  59.935  1.00  9.71           N  
ATOM   1031  CA  PRO A 137      27.103  29.450  59.151  1.00  9.25           C  
ATOM   1032  C   PRO A 137      27.108  29.029  57.690  1.00  9.50           C  
ATOM   1033  O   PRO A 137      27.523  27.921  57.360  1.00  8.73           O  
ATOM   1034  CB  PRO A 137      28.492  29.441  59.780  1.00  9.77           C  
ATOM   1035  CG  PRO A 137      28.179  29.186  61.225  1.00 10.95           C  
ATOM   1036  CD  PRO A 137      27.147  28.065  61.139  1.00 10.72           C  
ATOM   1037  N   ALA A 138      26.636  29.911  56.815  1.00 10.67           N  
ATOM   1038  CA  ALA A 138      26.556  29.578  55.403  1.00  9.31           C  
ATOM   1039  C   ALA A 138      26.926  30.735  54.504  1.00  7.87           C  
ATOM   1040  O   ALA A 138      26.438  31.851  54.671  1.00 11.06           O  
ATOM   1041  CB  ALA A 138      25.141  29.094  55.062  1.00  8.36           C  
ATOM   1042  N   VAL A 139      27.786  30.463  53.535  1.00  8.39           N  
ATOM   1043  CA  VAL A 139      28.194  31.500  52.604  1.00  8.22           C  
ATOM   1044  C   VAL A 139      28.100  30.998  51.177  1.00  8.72           C  
ATOM   1045  O   VAL A 139      28.122  29.792  50.923  1.00  9.04           O  
ATOM   1046  CB  VAL A 139      29.636  31.972  52.878  1.00  9.00           C  
ATOM   1047  CG1 VAL A 139      29.733  32.556  54.291  1.00  7.92           C  
ATOM   1048  CG2 VAL A 139      30.609  30.813  52.707  1.00 10.39           C  
ATOM   1049  N   LEU A 140      27.963  31.935  50.250  1.00  8.08           N  
ATOM   1050  CA  LEU A 140      27.893  31.597  48.839  1.00  9.33           C  
ATOM   1051  C   LEU A 140      29.039  32.347  48.184  1.00  8.77           C  
ATOM   1052  O   LEU A 140      29.187  33.558  48.352  1.00  8.70           O  
ATOM   1053  CB  LEU A 140      26.551  32.026  48.242  1.00  7.70           C  
ATOM   1054  CG  LEU A 140      26.330  31.603  46.787  1.00  9.21           C  
ATOM   1055  CD1 LEU A 140      24.847  31.333  46.543  1.00 10.08           C  
ATOM   1056  CD2 LEU A 140      26.858  32.690  45.854  1.00  8.65           C  
ATOM   1057  N   LEU A 141      29.868  31.614  47.459  1.00  8.70           N  
ATOM   1058  CA  LEU A 141      31.019  32.210  46.812  1.00  9.42           C  
ATOM   1059  C   LEU A 141      30.814  32.359  45.316  1.00  8.97           C  
ATOM   1060  O   LEU A 141      30.433  31.411  44.643  1.00 10.43           O  
ATOM   1061  CB  LEU A 141      32.258  31.344  47.068  1.00  9.68           C  
ATOM   1062  CG  LEU A 141      32.491  30.880  48.511  1.00  9.50           C  
ATOM   1063  CD1 LEU A 141      33.738  29.998  48.552  1.00  9.15           C  
ATOM   1064  CD2 LEU A 141      32.652  32.081  49.435  1.00 10.11           C  
ATOM   1065  N   GLU A 142      31.034  33.567  44.813  1.00  9.17           N  
ATOM   1066  CA  GLU A 142      30.949  33.826  43.380  1.00 11.02           C  
ATOM   1067  C   GLU A 142      32.429  34.009  43.065  1.00 10.65           C  
ATOM   1068  O   GLU A 142      32.987  35.089  43.244  1.00 11.35           O  
ATOM   1069  CB  GLU A 142      30.152  35.103  43.110  1.00 11.23           C  
ATOM   1070  CG  GLU A 142      28.643  34.928  43.278  1.00 13.13           C  
ATOM   1071  CD  GLU A 142      28.026  34.057  42.196  1.00 17.20           C  
ATOM   1072  OE1 GLU A 142      26.818  33.742  42.293  1.00 18.93           O  
ATOM   1073  OE2 GLU A 142      28.744  33.692  41.242  1.00 18.10           O  
ATOM   1074  N   VAL A 143      33.060  32.928  42.620  1.00 10.50           N  
ATOM   1075  CA  VAL A 143      34.494  32.923  42.356  1.00 10.67           C  
ATOM   1076  C   VAL A 143      35.011  33.956  41.370  1.00 11.57           C  
ATOM   1077  O   VAL A 143      36.027  34.596  41.623  1.00 11.55           O  
ATOM   1078  CB  VAL A 143      34.957  31.525  41.902  1.00 10.95           C  
ATOM   1079  CG1 VAL A 143      36.476  31.490  41.794  1.00 11.38           C  
ATOM   1080  CG2 VAL A 143      34.474  30.474  42.900  1.00 11.71           C  
ATOM   1081  N   GLY A 144      34.316  34.108  40.251  1.00 11.01           N  
ATOM   1082  CA  GLY A 144      34.726  35.065  39.241  1.00 11.00           C  
ATOM   1083  C   GLY A 144      33.625  35.200  38.210  1.00 10.95           C  
ATOM   1084  O   GLY A 144      32.608  34.512  38.303  1.00 11.75           O  
ATOM   1085  N   TYR A 145      33.825  36.070  37.224  1.00 10.28           N  
ATOM   1086  CA  TYR A 145      32.819  36.296  36.184  1.00 11.15           C  
ATOM   1087  C   TYR A 145      33.070  35.526  34.901  1.00 12.20           C  
ATOM   1088  O   TYR A 145      34.122  35.657  34.281  1.00 12.36           O  
ATOM   1089  CB  TYR A 145      32.728  37.794  35.864  1.00 11.74           C  
ATOM   1090  CG  TYR A 145      31.988  38.576  36.915  1.00 11.79           C  
ATOM   1091  CD1 TYR A 145      30.683  39.014  36.694  1.00 11.39           C  
ATOM   1092  CD2 TYR A 145      32.575  38.837  38.154  1.00 12.57           C  
ATOM   1093  CE1 TYR A 145      29.974  39.695  37.684  1.00 11.71           C  
ATOM   1094  CE2 TYR A 145      31.878  39.510  39.151  1.00 12.65           C  
ATOM   1095  CZ  TYR A 145      30.582  39.936  38.911  1.00 12.89           C  
ATOM   1096  OH  TYR A 145      29.899  40.602  39.902  1.00 13.89           O  
ATOM   1097  N   LEU A 146      32.084  34.726  34.505  1.00 12.46           N  
ATOM   1098  CA  LEU A 146      32.174  33.934  33.288  1.00 14.29           C  
ATOM   1099  C   LEU A 146      31.824  34.792  32.079  1.00 13.47           C  
ATOM   1100  O   LEU A 146      31.968  34.358  30.939  1.00 14.01           O  
ATOM   1101  CB  LEU A 146      31.211  32.748  33.358  1.00 14.03           C  
ATOM   1102  CG  LEU A 146      31.500  31.755  34.485  1.00 16.17           C  
ATOM   1103  CD1 LEU A 146      30.488  30.618  34.445  1.00 16.39           C  
ATOM   1104  CD2 LEU A 146      32.915  31.213  34.326  1.00 17.49           C  
ATOM   1105  N   SER A 147      31.352  36.006  32.347  1.00 14.41           N  
ATOM   1106  CA  SER A 147      30.966  36.946  31.297  1.00 15.56           C  
ATOM   1107  C   SER A 147      32.153  37.761  30.787  1.00 15.09           C  
ATOM   1108  O   SER A 147      32.030  38.524  29.827  1.00 16.22           O  
ATOM   1109  CB  SER A 147      29.868  37.880  31.819  1.00 14.39           C  
ATOM   1110  OG  SER A 147      30.130  38.275  33.153  1.00 15.87           O  
ATOM   1111  N   ASN A 148      33.298  37.603  31.443  1.00 16.16           N  
ATOM   1112  CA  ASN A 148      34.523  38.290  31.052  1.00 17.15           C  
ATOM   1113  C   ASN A 148      35.404  37.238  30.382  1.00 17.31           C  
ATOM   1114  O   ASN A 148      35.671  36.189  30.957  1.00 16.93           O  
ATOM   1115  CB  ASN A 148      35.221  38.881  32.283  1.00 17.26           C  
ATOM   1116  CG  ASN A 148      36.582  39.470  31.964  1.00 19.01           C  
ATOM   1117  OD1 ASN A 148      37.575  38.751  31.859  1.00 17.75           O  
ATOM   1118  ND2 ASN A 148      36.633  40.789  31.800  1.00 20.21           N  
ATOM   1119  N   ALA A 149      35.837  37.519  29.158  1.00 17.82           N  
ATOM   1120  CA  ALA A 149      36.655  36.577  28.399  1.00 17.89           C  
ATOM   1121  C   ALA A 149      37.878  36.045  29.136  1.00 15.79           C  
ATOM   1122  O   ALA A 149      38.073  34.831  29.230  1.00 16.86           O  
ATOM   1123  CB  ALA A 149      37.083  37.208  27.078  1.00 17.34           C  
ATOM   1124  N   LYS A 150      38.708  36.945  29.650  1.00 16.48           N  
ATOM   1125  CA  LYS A 150      39.914  36.528  30.361  1.00 18.22           C  
ATOM   1126  C   LYS A 150      39.595  35.775  31.648  1.00 17.72           C  
ATOM   1127  O   LYS A 150      40.191  34.736  31.934  1.00 17.57           O  
ATOM   1128  CB  LYS A 150      40.795  37.745  30.679  1.00 19.25           C  
ATOM   1129  CG  LYS A 150      41.769  38.144  29.562  1.00 24.44           C  
ATOM   1130  CD  LYS A 150      42.508  39.437  29.912  1.00 26.69           C  
ATOM   1131  CE  LYS A 150      43.776  39.634  29.086  1.00 29.33           C  
ATOM   1132  NZ  LYS A 150      44.802  38.576  29.316  1.00 31.96           N  
ATOM   1133  N   GLU A 151      38.647  36.298  32.418  1.00 15.74           N  
ATOM   1134  CA  GLU A 151      38.281  35.669  33.677  1.00 14.69           C  
ATOM   1135  C   GLU A 151      37.651  34.292  33.483  1.00 14.45           C  
ATOM   1136  O   GLU A 151      37.907  33.375  34.264  1.00 13.70           O  
ATOM   1137  CB  GLU A 151      37.348  36.582  34.473  1.00 13.35           C  
ATOM   1138  CG  GLU A 151      37.339  36.259  35.952  1.00 13.53           C  
ATOM   1139  CD  GLU A 151      37.132  37.491  36.809  1.00 15.03           C  
ATOM   1140  OE1 GLU A 151      36.041  37.633  37.396  1.00 15.14           O  
ATOM   1141  OE2 GLU A 151      38.069  38.318  36.897  1.00 15.18           O  
ATOM   1142  N   GLU A 152      36.829  34.139  32.450  1.00 12.88           N  
ATOM   1143  CA  GLU A 152      36.216  32.840  32.183  1.00 15.24           C  
ATOM   1144  C   GLU A 152      37.317  31.808  31.937  1.00 16.39           C  
ATOM   1145  O   GLU A 152      37.281  30.705  32.478  1.00 15.50           O  
ATOM   1146  CB  GLU A 152      35.310  32.892  30.949  1.00 14.78           C  
ATOM   1147  CG  GLU A 152      34.690  31.542  30.614  1.00 17.48           C  
ATOM   1148  CD  GLU A 152      34.057  31.492  29.241  1.00 19.09           C  
ATOM   1149  OE1 GLU A 152      33.426  30.462  28.926  1.00 20.41           O  
ATOM   1150  OE2 GLU A 152      34.194  32.468  28.474  1.00 18.40           O  
ATOM   1151  N   ALA A 153      38.290  32.170  31.105  1.00 16.55           N  
ATOM   1152  CA  ALA A 153      39.399  31.268  30.800  1.00 17.28           C  
ATOM   1153  C   ALA A 153      40.124  30.894  32.089  1.00 16.01           C  
ATOM   1154  O   ALA A 153      40.467  29.731  32.313  1.00 16.88           O  
ATOM   1155  CB  ALA A 153      40.371  31.939  29.830  1.00 16.48           C  
ATOM   1156  N   THR A 154      40.347  31.889  32.937  1.00 16.01           N  
ATOM   1157  CA  THR A 154      41.026  31.677  34.206  1.00 16.16           C  
ATOM   1158  C   THR A 154      40.251  30.726  35.115  1.00 15.63           C  
ATOM   1159  O   THR A 154      40.834  29.824  35.710  1.00 15.20           O  
ATOM   1160  CB  THR A 154      41.237  33.014  34.941  1.00 17.99           C  
ATOM   1161  OG1 THR A 154      42.128  33.838  34.179  1.00 20.21           O  
ATOM   1162  CG2 THR A 154      41.823  32.782  36.322  1.00 19.26           C  
ATOM   1163  N   LEU A 155      38.940  30.923  35.224  1.00 15.09           N  
ATOM   1164  CA  LEU A 155      38.139  30.058  36.082  1.00 14.58           C  
ATOM   1165  C   LEU A 155      38.174  28.604  35.627  1.00 15.81           C  
ATOM   1166  O   LEU A 155      38.023  27.693  36.441  1.00 15.25           O  
ATOM   1167  CB  LEU A 155      36.688  30.552  36.161  1.00 14.52           C  
ATOM   1168  CG  LEU A 155      36.352  31.302  37.460  1.00 15.81           C  
ATOM   1169  CD1 LEU A 155      37.178  32.579  37.546  1.00 18.96           C  
ATOM   1170  CD2 LEU A 155      34.865  31.622  37.509  1.00 17.29           C  
ATOM   1171  N   PHE A 156      38.375  28.379  34.331  1.00 16.29           N  
ATOM   1172  CA  PHE A 156      38.440  27.013  33.836  1.00 17.07           C  
ATOM   1173  C   PHE A 156      39.866  26.515  33.677  1.00 17.65           C  
ATOM   1174  O   PHE A 156      40.113  25.508  33.016  1.00 18.95           O  
ATOM   1175  CB  PHE A 156      37.661  26.865  32.529  1.00 17.24           C  
ATOM   1176  CG  PHE A 156      36.180  26.752  32.735  1.00 17.44           C  
ATOM   1177  CD1 PHE A 156      35.403  27.885  32.942  1.00 17.30           C  
ATOM   1178  CD2 PHE A 156      35.572  25.505  32.796  1.00 19.40           C  
ATOM   1179  CE1 PHE A 156      34.039  27.777  33.212  1.00 16.53           C  
ATOM   1180  CE2 PHE A 156      34.209  25.383  33.066  1.00 19.19           C  
ATOM   1181  CZ  PHE A 156      33.443  26.521  33.274  1.00 18.80           C  
ATOM   1182  N   ASP A 157      40.800  27.225  34.298  1.00 19.19           N  
ATOM   1183  CA  ASP A 157      42.203  26.836  34.272  1.00 20.57           C  
ATOM   1184  C   ASP A 157      42.421  25.911  35.468  1.00 20.31           C  
ATOM   1185  O   ASP A 157      42.076  26.254  36.600  1.00 17.62           O  
ATOM   1186  CB  ASP A 157      43.106  28.069  34.382  1.00 22.11           C  
ATOM   1187  CG  ASP A 157      44.582  27.708  34.468  1.00 25.52           C  
ATOM   1188  OD1 ASP A 157      45.056  27.358  35.573  1.00 24.43           O  
ATOM   1189  OD2 ASP A 157      45.267  27.767  33.428  1.00 26.99           O  
ATOM   1190  N   GLU A 158      42.987  24.737  35.212  1.00 20.42           N  
ATOM   1191  CA  GLU A 158      43.227  23.760  36.268  1.00 23.52           C  
ATOM   1192  C   GLU A 158      44.023  24.257  37.460  1.00 21.94           C  
ATOM   1193  O   GLU A 158      43.651  23.994  38.603  1.00 20.81           O  
ATOM   1194  CB  GLU A 158      43.898  22.512  35.689  1.00 27.87           C  
ATOM   1195  CG  GLU A 158      42.897  21.447  35.303  1.00 34.92           C  
ATOM   1196  CD  GLU A 158      42.022  21.051  36.477  1.00 37.89           C  
ATOM   1197  OE1 GLU A 158      42.284  19.997  37.100  1.00 38.94           O  
ATOM   1198  OE2 GLU A 158      41.076  21.807  36.783  1.00 42.48           O  
ATOM   1199  N   ASP A 159      45.115  24.969  37.207  1.00 21.12           N  
ATOM   1200  CA  ASP A 159      45.939  25.467  38.299  1.00 21.89           C  
ATOM   1201  C   ASP A 159      45.166  26.467  39.150  1.00 19.56           C  
ATOM   1202  O   ASP A 159      45.265  26.457  40.375  1.00 19.24           O  
ATOM   1203  CB  ASP A 159      47.222  26.102  37.758  1.00 24.46           C  
ATOM   1204  CG  ASP A 159      48.067  25.116  36.976  1.00 28.87           C  
ATOM   1205  OD1 ASP A 159      48.170  23.948  37.411  1.00 28.99           O  
ATOM   1206  OD2 ASP A 159      48.634  25.506  35.933  1.00 32.77           O  
ATOM   1207  N   PHE A 160      44.396  27.325  38.491  1.00 19.27           N  
ATOM   1208  CA  PHE A 160      43.582  28.319  39.183  1.00 16.75           C  
ATOM   1209  C   PHE A 160      42.630  27.602  40.133  1.00 14.92           C  
ATOM   1210  O   PHE A 160      42.557  27.928  41.317  1.00 15.25           O  
ATOM   1211  CB  PHE A 160      42.766  29.133  38.171  1.00 16.66           C  
ATOM   1212  CG  PHE A 160      41.716  30.013  38.799  1.00 14.73           C  
ATOM   1213  CD1 PHE A 160      42.045  31.266  39.306  1.00 14.27           C  
ATOM   1214  CD2 PHE A 160      40.396  29.577  38.897  1.00 14.22           C  
ATOM   1215  CE1 PHE A 160      41.074  32.072  39.902  1.00 11.80           C  
ATOM   1216  CE2 PHE A 160      39.418  30.377  39.493  1.00 12.38           C  
ATOM   1217  CZ  PHE A 160      39.762  31.626  39.995  1.00 14.35           C  
ATOM   1218  N   GLN A 161      41.909  26.620  39.603  1.00 13.80           N  
ATOM   1219  CA  GLN A 161      40.951  25.862  40.402  1.00 15.40           C  
ATOM   1220  C   GLN A 161      41.598  25.203  41.612  1.00 15.11           C  
ATOM   1221  O   GLN A 161      41.066  25.265  42.717  1.00 13.34           O  
ATOM   1222  CB  GLN A 161      40.263  24.798  39.543  1.00 14.33           C  
ATOM   1223  CG  GLN A 161      39.552  25.367  38.328  1.00 13.84           C  
ATOM   1224  CD  GLN A 161      38.667  24.355  37.625  1.00 13.85           C  
ATOM   1225  OE1 GLN A 161      38.765  23.152  37.865  1.00 13.54           O  
ATOM   1226  NE2 GLN A 161      37.804  24.841  36.738  1.00 13.23           N  
ATOM   1227  N   ASN A 162      42.748  24.575  41.407  1.00 15.73           N  
ATOM   1228  CA  ASN A 162      43.430  23.911  42.509  1.00 14.80           C  
ATOM   1229  C   ASN A 162      43.838  24.886  43.601  1.00 14.68           C  
ATOM   1230  O   ASN A 162      43.706  24.594  44.787  1.00 13.80           O  
ATOM   1231  CB  ASN A 162      44.660  23.159  41.996  1.00 16.05           C  
ATOM   1232  CG  ASN A 162      44.287  21.947  41.170  1.00 17.82           C  
ATOM   1233  OD1 ASN A 162      43.372  21.202  41.527  1.00 18.23           O  
ATOM   1234  ND2 ASN A 162      45.000  21.731  40.068  1.00 18.32           N  
ATOM   1235  N   ARG A 163      44.331  26.047  43.191  1.00 16.09           N  
ATOM   1236  CA  ARG A 163      44.765  27.076  44.122  1.00 16.96           C  
ATOM   1237  C   ARG A 163      43.573  27.616  44.916  1.00 15.13           C  
ATOM   1238  O   ARG A 163      43.636  27.777  46.137  1.00 13.85           O  
ATOM   1239  CB  ARG A 163      45.426  28.210  43.345  1.00 19.46           C  
ATOM   1240  CG  ARG A 163      45.996  29.302  44.211  1.00 26.46           C  
ATOM   1241  CD  ARG A 163      46.098  30.582  43.420  1.00 31.04           C  
ATOM   1242  NE  ARG A 163      46.526  30.352  42.043  1.00 35.12           N  
ATOM   1243  CZ  ARG A 163      46.159  31.119  41.025  1.00 36.30           C  
ATOM   1244  NH1 ARG A 163      45.354  32.153  41.235  1.00 33.90           N  
ATOM   1245  NH2 ARG A 163      46.618  30.873  39.806  1.00 37.60           N  
ATOM   1246  N   VAL A 164      42.485  27.887  44.206  1.00 13.70           N  
ATOM   1247  CA  VAL A 164      41.275  28.415  44.820  1.00 12.35           C  
ATOM   1248  C   VAL A 164      40.616  27.373  45.712  1.00 11.11           C  
ATOM   1249  O   VAL A 164      40.117  27.699  46.786  1.00 10.61           O  
ATOM   1250  CB  VAL A 164      40.282  28.889  43.740  1.00 12.80           C  
ATOM   1251  CG1 VAL A 164      38.964  29.309  44.377  1.00 12.11           C  
ATOM   1252  CG2 VAL A 164      40.888  30.062  42.976  1.00 12.80           C  
ATOM   1253  N   ALA A 165      40.625  26.118  45.268  1.00 11.02           N  
ATOM   1254  CA  ALA A 165      40.038  25.039  46.050  1.00 10.66           C  
ATOM   1255  C   ALA A 165      40.765  24.941  47.384  1.00 11.22           C  
ATOM   1256  O   ALA A 165      40.153  24.685  48.422  1.00  9.50           O  
ATOM   1257  CB  ALA A 165      40.142  23.713  45.293  1.00 10.41           C  
ATOM   1258  N   GLN A 166      42.078  25.140  47.357  1.00 10.90           N  
ATOM   1259  CA  GLN A 166      42.848  25.074  48.592  1.00 11.63           C  
ATOM   1260  C   GLN A 166      42.478  26.251  49.480  1.00 11.91           C  
ATOM   1261  O   GLN A 166      42.397  26.116  50.699  1.00 12.92           O  
ATOM   1262  CB  GLN A 166      44.351  25.104  48.307  1.00 12.03           C  
ATOM   1263  CG  GLN A 166      45.201  24.986  49.568  1.00 11.60           C  
ATOM   1264  CD  GLN A 166      45.024  23.649  50.272  1.00 13.18           C  
ATOM   1265  OE1 GLN A 166      45.295  22.591  49.700  1.00 16.00           O  
ATOM   1266  NE2 GLN A 166      44.569  23.690  51.519  1.00 11.57           N  
ATOM   1267  N   GLY A 167      42.258  27.407  48.861  1.00 11.47           N  
ATOM   1268  CA  GLY A 167      41.887  28.589  49.616  1.00 10.87           C  
ATOM   1269  C   GLY A 167      40.545  28.387  50.298  1.00 11.52           C  
ATOM   1270  O   GLY A 167      40.367  28.743  51.464  1.00 11.39           O  
ATOM   1271  N   ILE A 168      39.595  27.814  49.569  1.00 11.25           N  
ATOM   1272  CA  ILE A 168      38.269  27.553  50.119  1.00 10.43           C  
ATOM   1273  C   ILE A 168      38.388  26.538  51.255  1.00 12.34           C  
ATOM   1274  O   ILE A 168      37.764  26.687  52.311  1.00 10.06           O  
ATOM   1275  CB  ILE A 168      37.319  27.028  49.016  1.00  9.31           C  
ATOM   1276  CG1 ILE A 168      37.097  28.133  47.978  1.00  9.60           C  
ATOM   1277  CG2 ILE A 168      35.997  26.583  49.617  1.00  8.62           C  
ATOM   1278  CD1 ILE A 168      36.232  27.716  46.787  1.00 10.66           C  
ATOM   1279  N   ALA A 169      39.207  25.515  51.040  1.00 12.32           N  
ATOM   1280  CA  ALA A 169      39.419  24.496  52.058  1.00 13.42           C  
ATOM   1281  C   ALA A 169      39.998  25.141  53.316  1.00 12.32           C  
ATOM   1282  O   ALA A 169      39.571  24.835  54.423  1.00 12.87           O  
ATOM   1283  CB  ALA A 169      40.362  23.408  51.528  1.00 11.11           C  
ATOM   1284  N   ASP A 170      40.969  26.035  53.144  1.00 13.74           N  
ATOM   1285  CA  ASP A 170      41.582  26.709  54.286  1.00 13.27           C  
ATOM   1286  C   ASP A 170      40.540  27.528  55.050  1.00 13.38           C  
ATOM   1287  O   ASP A 170      40.520  27.530  56.279  1.00 12.39           O  
ATOM   1288  CB  ASP A 170      42.722  27.622  53.827  1.00 12.56           C  
ATOM   1289  CG  ASP A 170      43.950  26.849  53.382  1.00 12.84           C  
ATOM   1290  OD1 ASP A 170      44.868  27.473  52.809  1.00 12.74           O  
ATOM   1291  OD2 ASP A 170      44.003  25.623  53.605  1.00 14.76           O  
ATOM   1292  N   GLY A 171      39.674  28.222  54.319  1.00 12.12           N  
ATOM   1293  CA  GLY A 171      38.643  29.014  54.966  1.00 12.16           C  
ATOM   1294  C   GLY A 171      37.808  28.158  55.904  1.00 11.59           C  
ATOM   1295  O   GLY A 171      37.484  28.565  57.019  1.00 12.65           O  
ATOM   1296  N   ILE A 172      37.466  26.957  55.451  1.00 11.64           N  
ATOM   1297  CA  ILE A 172      36.663  26.032  56.246  1.00 11.83           C  
ATOM   1298  C   ILE A 172      37.467  25.466  57.409  1.00 11.32           C  
ATOM   1299  O   ILE A 172      36.998  25.429  58.548  1.00 10.78           O  
ATOM   1300  CB  ILE A 172      36.157  24.869  55.371  1.00 11.83           C  
ATOM   1301  CG1 ILE A 172      35.152  25.407  54.350  1.00 11.68           C  
ATOM   1302  CG2 ILE A 172      35.538  23.782  56.244  1.00 10.69           C  
ATOM   1303  CD1 ILE A 172      34.875  24.462  53.194  1.00 10.50           C  
ATOM   1304  N   THR A 173      38.682  25.029  57.110  1.00 12.38           N  
ATOM   1305  CA  THR A 173      39.562  24.460  58.119  1.00 12.40           C  
ATOM   1306  C   THR A 173      39.880  25.467  59.217  1.00 13.50           C  
ATOM   1307  O   THR A 173      39.831  25.140  60.403  1.00 15.32           O  
ATOM   1308  CB  THR A 173      40.873  23.986  57.483  1.00 12.38           C  
ATOM   1309  OG1 THR A 173      40.578  23.016  56.473  1.00 13.52           O  
ATOM   1310  CG2 THR A 173      41.785  23.362  58.533  1.00 11.37           C  
ATOM   1311  N   GLU A 174      40.206  26.691  58.820  1.00 12.21           N  
ATOM   1312  CA  GLU A 174      40.533  27.732  59.785  1.00 13.61           C  
ATOM   1313  C   GLU A 174      39.328  28.094  60.639  1.00 14.00           C  
ATOM   1314  O   GLU A 174      39.443  28.207  61.854  1.00 13.58           O  
ATOM   1315  CB  GLU A 174      41.044  28.986  59.070  1.00 14.86           C  
ATOM   1316  CG  GLU A 174      42.391  28.824  58.384  1.00 12.63           C  
ATOM   1317  CD  GLU A 174      43.559  28.803  59.354  1.00 15.21           C  
ATOM   1318  OE1 GLU A 174      43.353  29.080  60.557  1.00 15.10           O  
ATOM   1319  OE2 GLU A 174      44.689  28.523  58.905  1.00 15.32           O  
ATOM   1320  N   TYR A 175      38.172  28.273  60.006  1.00 13.66           N  
ATOM   1321  CA  TYR A 175      36.970  28.636  60.750  1.00 13.55           C  
ATOM   1322  C   TYR A 175      36.560  27.560  61.745  1.00 14.14           C  
ATOM   1323  O   TYR A 175      36.192  27.863  62.881  1.00 15.80           O  
ATOM   1324  CB  TYR A 175      35.792  28.900  59.808  1.00 13.89           C  
ATOM   1325  CG  TYR A 175      34.553  29.348  60.556  1.00 13.31           C  
ATOM   1326  CD1 TYR A 175      34.496  30.611  61.146  1.00 16.72           C  
ATOM   1327  CD2 TYR A 175      33.462  28.494  60.719  1.00 15.09           C  
ATOM   1328  CE1 TYR A 175      33.380  31.014  61.886  1.00 16.17           C  
ATOM   1329  CE2 TYR A 175      32.341  28.885  61.457  1.00 15.09           C  
ATOM   1330  CZ  TYR A 175      32.311  30.147  62.036  1.00 17.00           C  
ATOM   1331  OH  TYR A 175      31.211  30.542  62.764  1.00 16.20           O  
ATOM   1332  N   LEU A 176      36.619  26.304  61.315  1.00 13.88           N  
ATOM   1333  CA  LEU A 176      36.237  25.190  62.173  1.00 12.94           C  
ATOM   1334  C   LEU A 176      37.344  24.798  63.142  1.00 15.53           C  
ATOM   1335  O   LEU A 176      37.160  23.919  63.982  1.00 15.11           O  
ATOM   1336  CB  LEU A 176      35.826  23.990  61.321  1.00 12.86           C  
ATOM   1337  CG  LEU A 176      34.511  24.199  60.562  1.00 12.87           C  
ATOM   1338  CD1 LEU A 176      34.196  22.964  59.731  1.00 11.94           C  
ATOM   1339  CD2 LEU A 176      33.389  24.478  61.561  1.00 14.61           C  
ATOM   1340  N   ASP A 177      38.491  25.458  63.012  1.00 15.39           N  
ATOM   1341  CA  ASP A 177      39.632  25.218  63.886  1.00 17.73           C  
ATOM   1342  C   ASP A 177      39.984  23.735  63.978  1.00 18.22           C  
ATOM   1343  O   ASP A 177      40.082  23.168  65.067  1.00 19.06           O  
ATOM   1344  CB  ASP A 177      39.331  25.798  65.274  1.00 20.29           C  
ATOM   1345  CG  ASP A 177      40.552  25.845  66.173  1.00 23.16           C  
ATOM   1346  OD1 ASP A 177      41.672  26.056  65.660  1.00 21.23           O  
ATOM   1347  OD2 ASP A 177      40.381  25.689  67.399  1.00 23.26           O  
ATOM   1348  N   VAL A 178      40.174  23.108  62.821  1.00 18.56           N  
ATOM   1349  CA  VAL A 178      40.529  21.694  62.769  1.00 18.49           C  
ATOM   1350  C   VAL A 178      41.856  21.484  62.043  1.00 19.60           C  
ATOM   1351  O   VAL A 178      42.046  20.480  61.357  1.00 20.86           O  
ATOM   1352  CB  VAL A 178      39.435  20.857  62.065  1.00 18.41           C  
ATOM   1353  CG1 VAL A 178      38.191  20.789  62.942  1.00 18.03           C  
ATOM   1354  CG2 VAL A 178      39.094  21.469  60.708  1.00 16.64           C  
ATOM   1355  N   LYS A 179      42.774  22.434  62.199  1.00 19.06           N  
ATOM   1356  CA  LYS A 179      44.081  22.334  61.562  1.00 21.12           C  
ATOM   1357  C   LYS A 179      44.882  21.166  62.135  1.00 22.00           C  
ATOM   1358  O   LYS A 179      44.466  20.621  63.180  1.00 22.55           O  
ATOM   1359  CB  LYS A 179      44.860  23.639  61.750  1.00 22.31           C  
ATOM   1360  CG  LYS A 179      44.306  24.801  60.940  1.00 24.58           C  
ATOM   1361  CD  LYS A 179      45.054  26.099  61.206  1.00 26.54           C  
ATOM   1362  CE  LYS A 179      44.671  26.707  62.545  1.00 27.92           C  
ATOM   1363  NZ  LYS A 179      45.222  28.085  62.690  1.00 28.16           N  
TER    1364      LYS A 179                                                      
END
MOLECULE T0425.pdb
ATOM      6  N   MET     1      36.423  17.492  64.352  1.00 31.12           N  
ATOM      7  CA  MET     1      35.930  16.166  63.965  1.00 31.50           C  
ATOM      8  C   MET     1      34.461  15.933  64.276  1.00 29.86           C  
ATOM      9  O   MET     1      33.860  14.997  63.755  1.00 29.39           O  
ATOM     10  CB  MET     1      36.786  15.083  64.613  1.00 32.85           C  
ATOM     11  CG  MET     1      38.174  15.019  64.030  1.00 36.70           C  
ATOM     12  SD  MET     1      38.154  14.656  62.078  1.00 50.42          SE  
ATOM     13  CE  MET     1      40.064  14.280  61.848  1.00 40.13           C  
ATOM     14  N   SER     2      33.886  16.776  65.123  1.00 28.33           N  
ATOM     15  CA  SER     2      32.453  16.755  65.376  1.00 28.02           C  
ATOM     16  C   SER     2      31.703  17.639  64.394  1.00 27.37           C  
ATOM     17  O   SER     2      30.485  17.554  64.321  1.00 27.84           O  
ATOM     18  CB  SER     2      32.157  17.247  66.794  1.00 28.30           C  
ATOM     19  OG  SER     2      32.410  18.640  66.920  1.00 30.26           O  
ATOM     20  N   LYS     3      32.428  18.492  63.665  1.00 26.75           N  
ATOM     21  CA  LYS     3      31.837  19.475  62.767  1.00 25.52           C  
ATOM     22  C   LYS     3      31.355  18.825  61.461  1.00 24.26           C  
ATOM     23  O   LYS     3      31.845  17.810  61.097  1.00 24.30           O  
ATOM     24  CB  LYS     3      32.809  20.599  62.504  1.00 26.09           C  
ATOM     25  CG  LYS     3      33.227  21.373  63.748  1.00 27.83           C  
ATOM     26  CD  LYS     3      32.346  22.463  64.157  1.00 30.66           C  
ATOM     27  CE  LYS     3      32.951  23.299  65.301  1.00 31.08           C  
ATOM     28  NZ  LYS     3      33.077  24.768  64.940  1.00 33.51           N  
ATOM     29  N   ILE     4      30.354  19.416  60.846  1.00 22.71           N  
ATOM     30  CA  ILE     4      29.813  18.956  59.571  1.00 21.21           C  
ATOM     31  C   ILE     4      29.862  20.121  58.580  1.00 20.02           C  
ATOM     32  O   ILE     4      29.303  21.199  58.834  1.00 20.65           O  
ATOM     33  CB  ILE     4      28.377  18.487  59.717  1.00 21.75           C  
ATOM     34  CG1 ILE     4      28.312  17.283  60.670  1.00 22.21           C  
ATOM     35  CG2 ILE     4      27.795  18.147  58.381  1.00 20.77           C  
ATOM     36  CD1 ILE     4      26.900  16.693  60.810  1.00 22.64           C  
ATOM     37  N   ILE     5      30.541  19.883  57.462  1.00 17.23           N  
ATOM     38  CA  ILE     5      30.639  20.860  56.384  1.00 16.60           C  
ATOM     39  C   ILE     5      29.713  20.366  55.279  1.00 15.40           C  
ATOM     40  O   ILE     5      29.824  19.205  54.874  1.00 16.52           O  
ATOM     41  CB  ILE     5      32.066  20.926  55.849  1.00 16.46           C  
ATOM     42  CG1 ILE     5      33.042  21.366  56.949  1.00 16.61           C  
ATOM     43  CG2 ILE     5      32.186  21.905  54.670  1.00 15.78           C  
ATOM     44  CD1 ILE     5      34.337  20.653  56.919  1.00 17.99           C  
ATOM     45  N   CYS     6      28.834  21.220  54.790  1.00 14.60           N  
ATOM     46  CA  CYS     6      27.954  20.914  53.662  1.00 13.73           C  
ATOM     47  C   CYS     6      28.471  21.679  52.452  1.00 12.88           C  
ATOM     48  O   CYS     6      28.686  22.884  52.531  1.00 11.21           O  
ATOM     49  CB  CYS     6      26.499  21.312  53.963  1.00 14.26           C  
ATOM     50  SG  CYS     6      25.365  21.259  52.561  1.00 19.53           S  
ATOM     51  N   LEU     7      28.725  20.968  51.354  1.00 11.20           N  
ATOM     52  CA  LEU     7      29.108  21.595  50.106  1.00 10.68           C  
ATOM     53  C   LEU     7      28.186  21.143  48.983  1.00 11.06           C  
ATOM     54  O   LEU     7      28.036  19.912  48.780  1.00 12.55           O  
ATOM     55  CB  LEU     7      30.540  21.195  49.739  1.00 11.02           C  
ATOM     56  CG  LEU     7      31.665  21.538  50.718  1.00  9.80           C  
ATOM     57  CD1 LEU     7      32.985  21.042  50.177  1.00 12.57           C  
ATOM     58  CD2 LEU     7      31.794  23.059  51.044  1.00  8.88           C  
ATOM     59  N   THR     8      27.605  22.090  48.250  1.00 11.01           N  
ATOM     60  CA  THR     8      26.811  21.732  47.073  1.00 10.33           C  
ATOM     61  C   THR     8      27.201  22.550  45.884  1.00 10.86           C  
ATOM     62  O   THR     8      27.988  23.476  46.002  1.00 10.27           O  
ATOM     63  CB  THR     8      25.311  21.873  47.399  1.00 11.70           C  
ATOM     64  OG1 THR     8      25.012  23.221  47.714  1.00 12.41           O  
ATOM     65  CG2 THR     8      24.971  20.959  48.617  1.00 10.61           C  
ATOM     66  N   ALA     9      26.690  22.161  44.707  1.00 12.09           N  
ATOM     67  CA  ALA     9      26.974  22.852  43.446  1.00 12.81           C  
ATOM     68  C   ALA     9      25.678  23.423  42.922  1.00 14.98           C  
ATOM     69  O   ALA     9      24.636  22.762  42.948  1.00 16.54           O  
ATOM     70  CB  ALA     9      27.606  21.882  42.376  1.00 12.24           C  
ATOM     71  N   GLY    10      25.736  24.637  42.403  1.00 16.10           N  
ATOM     72  CA  GLY    10      24.585  25.208  41.729  1.00 17.64           C  
ATOM     73  C   GLY    10      24.359  24.595  40.369  1.00 18.60           C  
ATOM     74  O   GLY    10      25.295  24.161  39.692  1.00 17.50           O  
ATOM     75  N   HIS    11      23.094  24.586  39.973  1.00 19.96           N  
ATOM     76  CA  HIS    11      22.689  24.264  38.603  1.00 21.57           C  
ATOM     77  C   HIS    11      22.892  22.796  38.218  1.00 22.37           C  
ATOM     78  O   HIS    11      23.403  21.992  39.000  1.00 22.07           O  
ATOM     79  CB  HIS    11      23.386  25.206  37.622  1.00 21.34           C  
ATOM     80  CG  HIS    11      23.216  26.655  37.960  1.00 20.22           C  
ATOM     81  ND1 HIS    11      22.037  27.339  37.736  1.00 23.35           N  
ATOM     82  CD2 HIS    11      24.064  27.545  38.526  1.00 18.50           C  
ATOM     83  CE1 HIS    11      22.176  28.592  38.133  1.00 21.68           C  
ATOM     84  NE2 HIS    11      23.401  28.745  38.605  1.00 19.68           N  
ATOM     85  N   SER    12      22.477  22.452  36.999  1.00 23.53           N  
ATOM     86  CA  SER    12      22.396  21.041  36.583  1.00 25.53           C  
ATOM     87  C   SER    12      22.748  20.848  35.114  1.00 26.61           C  
ATOM     88  O   SER    12      23.008  21.820  34.407  1.00 26.91           O  
ATOM     89  CB  SER    12      20.971  20.532  36.852  1.00 25.98           C  
ATOM     90  OG  SER    12      20.054  21.198  36.010  1.00 26.71           O  
ATOM     91  N   ASN    13      22.755  19.592  34.653  1.00 28.58           N  
ATOM     92  CA  ASN    13      23.174  19.269  33.264  1.00 29.46           C  
ATOM     93  C   ASN    13      22.186  19.779  32.228  1.00 30.64           C  
ATOM     94  O   ASN    13      22.585  20.100  31.074  1.00 31.00           O  
ATOM     95  CB  ASN    13      23.374  17.757  33.072  1.00 29.73           C  
ATOM     96  CG  ASN    13      24.124  17.422  31.797  1.00 30.74           C  
ATOM     97  OD1 ASN    13      25.123  18.066  31.461  1.00 34.79           O  
ATOM     98  ND2 ASN    13      23.640  16.407  31.064  1.00 32.97           N  
ATOM     99  N   THR    14      20.912  19.851  32.636  1.00 30.93           N  
ATOM    100  CA  THR    14      19.832  20.334  31.784  1.00 31.23           C  
ATOM    101  C   THR    14      19.669  21.849  31.862  1.00 31.26           C  
ATOM    102  O   THR    14      19.325  22.468  30.855  1.00 32.36           O  
ATOM    103  CB  THR    14      18.445  19.669  32.139  1.00 31.81           C  
ATOM    104  OG1 THR    14      17.440  20.119  31.217  1.00 36.17           O  
ATOM    105  CG2 THR    14      17.982  20.016  33.541  1.00 32.41           C  
ATOM    106  N   ASP    15      19.869  22.423  33.058  1.00 30.47           N  
ATOM    107  CA  ASP    15      19.790  23.877  33.286  1.00 28.73           C  
ATOM    108  C   ASP    15      21.103  24.387  33.895  1.00 27.17           C  
ATOM    109  O   ASP    15      21.213  24.568  35.128  1.00 26.68           O  
ATOM    110  CB  ASP    15      18.630  24.209  34.216  1.00 29.94           C  
ATOM    111  CG  ASP    15      18.386  25.708  34.337  1.00 32.73           C  
ATOM    112  OD1 ASP    15      19.154  26.468  33.691  1.00 39.36           O  
ATOM    113  OD2 ASP    15      17.436  26.127  35.067  1.00 40.27           O  
ATOM    114  N   PRO    16      22.106  24.624  33.039  1.00 24.79           N  
ATOM    115  CA  PRO    16      23.496  24.749  33.487  1.00 23.54           C  
ATOM    116  C   PRO    16      23.967  26.111  34.003  1.00 22.69           C  
ATOM    117  O   PRO    16      25.174  26.284  34.231  1.00 22.57           O  
ATOM    118  CB  PRO    16      24.271  24.375  32.222  1.00 23.62           C  
ATOM    119  CG  PRO    16      23.451  24.994  31.144  1.00 23.52           C  
ATOM    120  CD  PRO    16      22.015  24.711  31.565  1.00 24.08           C  
ATOM    121  N   GLY    17      23.054  27.050  34.227  1.00 20.48           N  
ATOM    122  CA  GLY    17      23.437  28.383  34.668  1.00 20.23           C  
ATOM    123  C   GLY    17      24.104  29.153  33.556  1.00 19.42           C  
ATOM    124  O   GLY    17      23.811  28.903  32.386  1.00 20.15           O  
ATOM    125  N   ALA    18      24.964  30.103  33.901  1.00 18.26           N  
ATOM    126  CA  ALA    18      25.617  30.960  32.918  1.00 18.29           C  
ATOM    127  C   ALA    18      26.639  30.160  32.119  1.00 18.34           C  
ATOM    128  O   ALA    18      27.159  29.148  32.606  1.00 17.24           O  
ATOM    129  CB  ALA    18      26.256  32.180  33.572  1.00 17.66           C  
ATOM    130  N   VAL    19      26.828  30.572  30.866  1.00 18.55           N  
ATOM    131  CA  VAL    19      27.746  29.923  29.943  1.00 18.16           C  
ATOM    132  C   VAL    19      28.656  30.979  29.327  1.00 18.50           C  
ATOM    133  O   VAL    19      28.245  32.108  29.098  1.00 18.76           O  
ATOM    134  CB  VAL    19      27.013  29.065  28.833  1.00 18.69           C  
ATOM    135  CG1 VAL    19      26.073  28.021  29.478  1.00 17.93           C  
ATOM    136  CG2 VAL    19      26.273  29.947  27.804  1.00 20.19           C  
ATOM    137  N   ASN    20      29.911  30.608  29.085  1.00 17.43           N  
ATOM    138  CA  ASN    20      30.836  31.427  28.352  1.00 18.07           C  
ATOM    139  C   ASN    20      31.555  30.468  27.409  1.00 18.76           C  
ATOM    140  O   ASN    20      32.430  29.716  27.814  1.00 18.85           O  
ATOM    141  CB  ASN    20      31.794  32.169  29.308  1.00 18.32           C  
ATOM    142  CG  ASN    20      32.749  33.124  28.594  1.00 18.13           C  
ATOM    143  OD1 ASN    20      32.964  33.031  27.373  1.00 19.34           O  
ATOM    144  ND2 ASN    20      33.353  34.030  29.348  1.00 13.79           N  
ATOM    145  N   GLY    21      31.172  30.470  26.140  1.00 18.80           N  
ATOM    146  CA  GLY    21      31.703  29.460  25.227  1.00 18.59           C  
ATOM    147  C   GLY    21      31.263  28.087  25.672  1.00 17.83           C  
ATOM    148  O   GLY    21      30.070  27.871  25.978  1.00 18.51           O  
ATOM    149  N   SER    22      32.212  27.148  25.731  1.00 17.19           N  
ATOM    150  CA  SER    22      31.897  25.807  26.222  1.00 16.49           C  
ATOM    151  C   SER    22      32.140  25.666  27.725  1.00 15.79           C  
ATOM    152  O   SER    22      32.018  24.562  28.251  1.00 16.57           O  
ATOM    153  CB  SER    22      32.639  24.717  25.441  1.00 16.94           C  
ATOM    154  OG  SER    22      34.029  24.902  25.519  1.00 19.74           O  
ATOM    155  N   ASP    23      32.468  26.773  28.392  1.00 13.76           N  
ATOM    156  CA  ASP    23      32.501  26.784  29.850  1.00 14.32           C  
ATOM    157  C   ASP    23      31.109  27.034  30.416  1.00 13.41           C  
ATOM    158  O   ASP    23      30.464  28.041  30.100  1.00 15.08           O  
ATOM    159  CB  ASP    23      33.474  27.851  30.331  1.00 13.07           C  
ATOM    160  CG  ASP    23      34.910  27.527  29.929  1.00 15.45           C  
ATOM    161  OD1 ASP    23      35.328  26.377  30.088  1.00 17.00           O  
ATOM    162  OD2 ASP    23      35.605  28.427  29.458  1.00 17.54           O  
ATOM    163  N   ARG    24      30.663  26.127  31.279  1.00 11.44           N  
ATOM    164  CA  ARG    24      29.335  26.205  31.877  1.00 12.54           C  
ATOM    165  C   ARG    24      29.427  26.315  33.391  1.00 11.65           C  
ATOM    166  O   ARG    24      30.147  25.539  34.024  1.00 11.73           O  
ATOM    167  CB  ARG    24      28.528  24.963  31.575  1.00 12.64           C  
ATOM    168  CG  ARG    24      28.396  24.612  30.063  1.00 13.85           C  
ATOM    169  CD  ARG    24      27.294  23.576  29.866  1.00 16.07           C  
ATOM    170  NE  ARG    24      27.524  22.367  30.649  1.00 17.93           N  
ATOM    171  CZ  ARG    24      26.634  21.392  30.824  1.00 19.14           C  
ATOM    172  NH1 ARG    24      25.405  21.438  30.279  1.00 19.60           N  
ATOM    173  NH2 ARG    24      26.954  20.369  31.587  1.00 19.55           N  
ATOM    174  N   GLU    25      28.630  27.213  33.951  1.00 11.39           N  
ATOM    175  CA  GLU    25      28.553  27.367  35.417  1.00 11.24           C  
ATOM    176  C   GLU    25      28.376  26.040  36.128  1.00 11.45           C  
ATOM    177  O   GLU    25      29.027  25.769  37.138  1.00 11.20           O  
ATOM    178  CB  GLU    25      27.435  28.339  35.806  1.00 11.67           C  
ATOM    179  CG  GLU    25      27.300  28.556  37.335  1.00 10.13           C  
ATOM    180  CD  GLU    25      26.340  29.638  37.719  1.00 14.58           C  
ATOM    181  OE1 GLU    25      25.728  30.240  36.810  1.00 14.67           O  
ATOM    182  OE2 GLU    25      26.221  29.909  38.947  1.00 13.96           O  
ATOM    183  N   ALA    26      27.499  25.195  35.625  1.00 10.85           N  
ATOM    184  CA  ALA    26      27.196  23.918  36.276  1.00 11.61           C  
ATOM    185  C   ALA    26      28.463  23.075  36.420  1.00 11.50           C  
ATOM    186  O   ALA    26      28.640  22.350  37.420  1.00 12.45           O  
ATOM    187  CB  ALA    26      26.161  23.159  35.498  1.00 12.98           C  
ATOM    188  N   ASP    27      29.327  23.157  35.413  1.00 10.03           N  
ATOM    189  CA  ASP    27      30.520  22.312  35.349  1.00 10.95           C  
ATOM    190  C   ASP    27      31.553  22.896  36.277  1.00 11.07           C  
ATOM    191  O   ASP    27      32.276  22.143  36.946  1.00 11.92           O  
ATOM    192  CB  ASP    27      31.047  22.262  33.904  1.00 11.23           C  
ATOM    193  CG  ASP    27      30.040  21.627  32.935  1.00 11.56           C  
ATOM    194  OD1 ASP    27      29.148  20.867  33.381  1.00 13.87           O  
ATOM    195  OD2 ASP    27      30.167  21.896  31.718  1.00 12.86           O  
ATOM    196  N   LEU    28      31.710  24.228  36.254  1.00 10.38           N  
ATOM    197  CA  LEU    28      32.677  24.899  37.147  1.00  9.76           C  
ATOM    198  C   LEU    28      32.280  24.691  38.619  1.00  9.49           C  
ATOM    199  O   LEU    28      33.159  24.484  39.506  1.00  9.41           O  
ATOM    200  CB  LEU    28      32.801  26.396  36.808  1.00 10.45           C  
ATOM    201  CG  LEU    28      33.278  26.732  35.387  1.00 12.99           C  
ATOM    202  CD1 LEU    28      33.074  28.238  35.003  1.00 15.81           C  
ATOM    203  CD2 LEU    28      34.720  26.314  35.229  1.00 19.45           C  
ATOM    204  N   ALA    29      30.977  24.730  38.900  1.00  8.57           N  
ATOM    205  CA  ALA    29      30.476  24.549  40.257  1.00  9.01           C  
ATOM    206  C   ALA    29      30.700  23.100  40.743  1.00  9.96           C  
ATOM    207  O   ALA    29      31.100  22.878  41.902  1.00 10.28           O  
ATOM    208  CB  ALA    29      28.994  24.961  40.332  1.00  9.96           C  
ATOM    209  N   GLN    30      30.441  22.114  39.884  1.00  9.30           N  
ATOM    210  CA  GLN    30      30.756  20.719  40.141  1.00 10.04           C  
ATOM    211  C   GLN    30      32.247  20.577  40.497  1.00 10.05           C  
ATOM    212  O   GLN    30      32.573  19.920  41.478  1.00 10.36           O  
ATOM    213  CB  GLN    30      30.390  19.863  38.914  1.00 11.31           C  
ATOM    214  CG  GLN    30      30.905  18.463  38.929  1.00 10.11           C  
ATOM    215  CD  GLN    30      30.533  17.694  37.689  1.00 12.69           C  
ATOM    216  OE1 GLN    30      30.444  18.282  36.609  1.00 13.24           O  
ATOM    217  NE2 GLN    30      30.287  16.385  37.835  1.00 14.06           N  
ATOM    218  N   ASP    31      33.131  21.191  39.723  1.00  9.89           N  
ATOM    219  CA  ASP    31      34.565  21.073  39.992  1.00 10.56           C  
ATOM    220  C   ASP    31      34.864  21.670  41.363  1.00 10.68           C  
ATOM    221  O   ASP    31      35.609  21.080  42.162  1.00 10.44           O  
ATOM    222  CB  ASP    31      35.422  21.819  38.979  1.00 11.53           C  
ATOM    223  CG  ASP    31      35.630  21.041  37.681  1.00 14.92           C  
ATOM    224  OD1 ASP    31      35.252  19.845  37.647  1.00 16.30           O  
ATOM    225  OD2 ASP    31      36.148  21.673  36.725  1.00 17.43           O  
ATOM    226  N   MET    32      34.344  22.881  41.636  1.00 10.14           N  
ATOM    227  CA  MET    32      34.638  23.501  42.929  1.00 10.43           C  
ATOM    228  C   MET    32      34.187  22.638  44.088  1.00 10.00           C  
ATOM    229  O   MET    32      34.967  22.437  45.041  1.00 10.09           O  
ATOM    230  CB  MET    32      34.025  24.897  43.030  1.00  9.19           C  
ATOM    231  CG  MET    32      34.678  25.871  42.125  1.00  9.01           C  
ATOM    232  SD  MET    32      34.068  27.736  42.301  1.00 19.23          SE  
ATOM    233  CE  MET    32      32.833  27.762  40.782  1.00 14.94           C  
ATOM    234  N   ARG    33      32.954  22.155  44.041  1.00  9.94           N  
ATOM    235  CA  ARG    33      32.414  21.320  45.130  1.00 10.38           C  
ATOM    236  C   ARG    33      33.269  20.039  45.278  1.00  9.82           C  
ATOM    237  O   ARG    33      33.715  19.685  46.384  1.00  9.83           O  
ATOM    238  CB  ARG    33      30.928  21.010  44.922  1.00  9.45           C  
ATOM    239  CG  ARG    33      30.369  19.989  45.910  1.00  9.78           C  
ATOM    240  CD  ARG    33      30.038  18.660  45.242  1.00 13.14           C  
ATOM    241  NE  ARG    33      28.760  18.730  44.559  1.00 12.54           N  
ATOM    242  CZ  ARG    33      28.517  18.324  43.313  1.00 14.81           C  
ATOM    243  NH1 ARG    33      27.298  18.442  42.833  1.00 14.41           N  
ATOM    244  NH2 ARG    33      29.482  17.872  42.538  1.00 15.96           N  
ATOM    245  N   ASN    34      33.528  19.351  44.160  1.00 10.79           N  
ATOM    246  CA  ASN    34      34.253  18.076  44.225  1.00 11.50           C  
ATOM    247  C   ASN    34      35.656  18.229  44.773  1.00 12.72           C  
ATOM    248  O   ASN    34      36.126  17.390  45.571  1.00 13.06           O  
ATOM    249  CB  ASN    34      34.278  17.399  42.837  1.00 11.26           C  
ATOM    250  CG  ASN    34      32.961  16.763  42.473  1.00 12.52           C  
ATOM    251  OD1 ASN    34      32.053  16.694  43.272  1.00 13.84           O  
ATOM    252  ND2 ASN    34      32.830  16.296  41.215  1.00 14.42           N  
ATOM    253  N   ILE    35      36.357  19.252  44.298  1.00 12.28           N  
ATOM    254  CA  ILE    35      37.774  19.435  44.658  1.00 13.00           C  
ATOM    255  C   ILE    35      37.857  19.862  46.110  1.00 12.52           C  
ATOM    256  O   ILE    35      38.661  19.345  46.902  1.00 13.65           O  
ATOM    257  CB  ILE    35      38.490  20.403  43.748  1.00 14.17           C  
ATOM    258  CG1 ILE    35      38.486  19.846  42.309  1.00 12.74           C  
ATOM    259  CG2 ILE    35      39.895  20.646  44.213  1.00 13.69           C  
ATOM    260  CD1 ILE    35      38.963  20.868  41.308  1.00 14.97           C  
ATOM    261  N   VAL    36      37.054  20.847  46.507  1.00 10.02           N  
ATOM    262  CA  VAL    36      37.111  21.267  47.891  1.00 10.14           C  
ATOM    263  C   VAL    36      36.728  20.129  48.816  1.00 10.72           C  
ATOM    264  O   VAL    36      37.354  19.965  49.854  1.00 11.57           O  
ATOM    265  CB  VAL    36      36.235  22.524  48.125  1.00  9.33           C  
ATOM    266  CG1 VAL    36      36.181  22.903  49.630  1.00  9.47           C  
ATOM    267  CG2 VAL    36      36.745  23.698  47.349  1.00  8.29           C  
ATOM    268  N   ALA    37      35.714  19.366  48.456  1.00 10.89           N  
ATOM    269  CA  ALA    37      35.248  18.225  49.280  1.00 11.10           C  
ATOM    270  C   ALA    37      36.363  17.200  49.418  1.00 13.30           C  
ATOM    271  O   ALA    37      36.659  16.709  50.531  1.00 12.63           O  
ATOM    272  CB  ALA    37      34.016  17.597  48.664  1.00 12.73           C  
ATOM    273  N   SER    38      36.991  16.868  48.286  1.00 14.73           N  
ATOM    274  CA  SER    38      38.031  15.831  48.302  1.00 16.08           C  
ATOM    275  C   SER    38      39.228  16.204  49.197  1.00 16.27           C  
ATOM    276  O   SER    38      39.761  15.334  49.883  1.00 17.01           O  
ATOM    277  CB  SER    38      38.510  15.531  46.890  1.00 17.06           C  
ATOM    278  OG  SER    38      39.215  16.628  46.370  1.00 21.32           O  
ATOM    279  N   ILE    39      39.618  17.479  49.215  1.00 14.55           N  
ATOM    280  CA  ILE    39      40.744  17.957  50.011  1.00 15.13           C  
ATOM    281  C   ILE    39      40.364  17.964  51.495  1.00 14.88           C  
ATOM    282  O   ILE    39      41.161  17.586  52.370  1.00 16.06           O  
ATOM    283  CB  ILE    39      41.243  19.339  49.537  1.00 15.07           C  
ATOM    284  CG1 ILE    39      41.827  19.215  48.114  1.00 15.18           C  
ATOM    285  CG2 ILE    39      42.300  19.898  50.493  1.00 15.03           C  
ATOM    286  CD1 ILE    39      42.255  20.513  47.445  1.00 16.14           C  
ATOM    287  N   LEU    40      39.148  18.407  51.806  1.00 13.81           N  
ATOM    288  CA  LEU    40      38.722  18.401  53.208  1.00 13.95           C  
ATOM    289  C   LEU    40      38.720  16.965  53.747  1.00 15.02           C  
ATOM    290  O   LEU    40      39.154  16.720  54.876  1.00 14.90           O  
ATOM    291  CB  LEU    40      37.354  19.081  53.352  1.00 13.74           C  
ATOM    292  CG  LEU    40      37.322  20.607  53.210  1.00 10.75           C  
ATOM    293  CD1 LEU    40      35.913  21.077  53.071  1.00 12.08           C  
ATOM    294  CD2 LEU    40      38.022  21.347  54.377  1.00 13.08           C  
ATOM    295  N   ARG    41      38.247  16.032  52.940  1.00 15.03           N  
ATOM    296  CA  ARG    41      38.257  14.593  53.325  1.00 16.92           C  
ATOM    297  C   ARG    41      39.671  14.007  53.352  1.00 18.20           C  
ATOM    298  O   ARG    41      40.094  13.454  54.397  1.00 19.57           O  
ATOM    299  CB  ARG    41      37.331  13.822  52.404  1.00 16.23           C  
ATOM    300  CG  ARG    41      35.918  14.167  52.569  1.00 17.42           C  
ATOM    301  CD  ARG    41      35.067  13.682  51.412  1.00 15.12           C  
ATOM    302  NE  ARG    41      33.652  13.717  51.668  1.00 15.35           N  
ATOM    303  CZ  ARG    41      32.691  13.708  50.742  1.00 15.60           C  
ATOM    304  NH1 ARG    41      32.978  13.647  49.430  1.00 16.22           N  
ATOM    305  NH2 ARG    41      31.428  13.734  51.097  1.00 15.43           N  
ATOM    306  N   ASN    42      40.436  14.151  52.265  1.00 19.20           N  
ATOM    307  CA  ASN    42      41.817  13.575  52.191  1.00 19.64           C  
ATOM    308  C   ASN    42      42.844  14.140  53.107  1.00 20.59           C  
ATOM    309  O   ASN    42      43.552  13.386  53.799  1.00 21.54           O  
ATOM    310  CB  ASN    42      42.404  13.722  50.785  1.00 20.29           C  
ATOM    311  CG  ASN    42      41.590  13.026  49.748  1.00 22.39           C  
ATOM    312  OD1 ASN    42      40.771  12.172  50.070  1.00 26.17           O  
ATOM    313  ND2 ASN    42      41.810  13.386  48.476  1.00 25.83           N  
ATOM    314  N   ASP    43      43.003  15.457  53.092  1.00 19.66           N  
ATOM    315  CA  ASP    43      44.088  16.076  53.825  1.00 19.99           C  
ATOM    316  C   ASP    43      43.759  16.237  55.297  1.00 18.96           C  
ATOM    317  O   ASP    43      44.676  16.278  56.140  1.00 20.41           O  
ATOM    318  CB  ASP    43      44.458  17.454  53.243  1.00 19.95           C  
ATOM    319  CG  ASP    43      45.107  17.368  51.899  1.00 22.44           C  
ATOM    320  OD1 ASP    43      45.067  16.288  51.267  1.00 26.59           O  
ATOM    321  OD2 ASP    43      45.677  18.401  51.486  1.00 23.44           O  
ATOM    322  N   TYR    44      42.470  16.356  55.615  1.00 16.69           N  
ATOM    323  CA  TYR    44      42.059  16.691  56.973  1.00 15.90           C  
ATOM    324  C   TYR    44      41.163  15.689  57.685  1.00 15.95           C  
ATOM    325  O   TYR    44      40.929  15.845  58.881  1.00 16.24           O  
ATOM    326  CB  TYR    44      41.364  18.060  56.989  1.00 15.05           C  
ATOM    327  CG  TYR    44      42.249  19.198  56.498  1.00 13.70           C  
ATOM    328  CD1 TYR    44      43.066  19.895  57.377  1.00 14.41           C  
ATOM    329  CD2 TYR    44      42.236  19.585  55.146  1.00 13.64           C  
ATOM    330  CE1 TYR    44      43.861  20.933  56.945  1.00 14.62           C  
ATOM    331  CE2 TYR    44      43.032  20.663  54.691  1.00 13.60           C  
ATOM    332  CZ  TYR    44      43.857  21.317  55.603  1.00 12.47           C  
ATOM    333  OH  TYR    44      44.654  22.392  55.259  1.00 13.71           O  
ATOM    334  N   GLY    45      40.660  14.684  56.985  1.00 15.27           N  
ATOM    335  CA  GLY    45      39.744  13.705  57.575  1.00 15.41           C  
ATOM    336  C   GLY    45      38.422  14.261  58.096  1.00 15.31           C  
ATOM    337  O   GLY    45      37.771  13.672  58.988  1.00 17.14           O  
ATOM    338  N   LEU    46      37.981  15.386  57.526  1.00 15.14           N  
ATOM    339  CA  LEU    46      36.780  16.069  57.973  1.00 14.01           C  
ATOM    340  C   LEU    46      35.514  15.454  57.360  1.00 13.71           C  
ATOM    341  O   LEU    46      35.560  14.802  56.303  1.00 13.89           O  
ATOM    342  CB  LEU    46      36.871  17.576  57.622  1.00 13.80           C  
ATOM    343  CG  LEU    46      37.940  18.294  58.444  1.00 13.99           C  
ATOM    344  CD1 LEU    46      38.244  19.717  57.929  1.00 15.02           C  
ATOM    345  CD2 LEU    46      37.574  18.352  59.929  1.00 18.51           C  
ATOM    346  N   THR    47      34.401  15.641  58.062  1.00 13.91           N  
ATOM    347  CA  THR    47      33.083  15.205  57.618  1.00 13.64           C  
ATOM    348  C   THR    47      32.528  16.254  56.687  1.00 13.50           C  
ATOM    349  O   THR    47      32.273  17.397  57.094  1.00 13.89           O  
ATOM    350  CB  THR    47      32.100  15.108  58.779  1.00 15.11           C  
ATOM    351  OG1 THR    47      32.564  14.135  59.706  1.00 17.00           O  
ATOM    352  CG2 THR    47      30.748  14.693  58.303  1.00 14.65           C  
ATOM    353  N   VAL    48      32.298  15.822  55.460  1.00 13.99           N  
ATOM    354  CA  VAL    48      31.646  16.642  54.439  1.00 13.85           C  
ATOM    355  C   VAL    48      30.418  15.937  53.908  1.00 14.82           C  
ATOM    356  O   VAL    48      30.479  14.763  53.521  1.00 15.07           O  
ATOM    357  CB  VAL    48      32.589  16.958  53.279  1.00 14.07           C  
ATOM    358  CG1 VAL    48      31.941  17.953  52.320  1.00 13.27           C  
ATOM    359  CG2 VAL    48      33.919  17.499  53.814  1.00 14.60           C  
ATOM    360  N   LYS    49      29.309  16.650  53.871  1.00 14.50           N  
ATOM    361  CA  LYS    49      28.104  16.165  53.209  1.00 16.82           C  
ATOM    362  C   LYS    49      27.884  16.970  51.948  1.00 16.81           C  
ATOM    363  O   LYS    49      27.956  18.175  51.967  1.00 15.15           O  
ATOM    364  CB  LYS    49      26.901  16.254  54.146  1.00 18.01           C  
ATOM    365  CG  LYS    49      27.099  15.473  55.437  1.00 20.46           C  
ATOM    366  CD  LYS    49      25.826  15.216  56.208  1.00 21.91           C  
ATOM    367  CE  LYS    49      26.147  14.896  57.692  1.00 25.30           C  
ATOM    368  NZ  LYS    49      24.930  14.375  58.385  1.00 28.75           N  
ATOM    369  N   THR    50      27.581  16.283  50.853  1.00 16.95           N  
ATOM    370  CA  THR    50      27.379  16.939  49.577  1.00 17.12           C  
ATOM    371  C   THR    50      26.097  16.461  48.897  1.00 17.78           C  
ATOM    372  O   THR    50      25.414  15.534  49.361  1.00 18.96           O  
ATOM    373  CB  THR    50      28.568  16.658  48.642  1.00 16.81           C  
ATOM    374  OG1 THR    50      28.523  15.272  48.232  1.00 18.23           O  
ATOM    375  CG2 THR    50      29.908  16.918  49.312  1.00 17.06           C  
ATOM    376  N   ASP    51      25.823  17.110  47.774  1.00 17.45           N  
ATOM    377  CA  ASP    51      24.846  16.658  46.779  1.00 18.13           C  
ATOM    378  C   ASP    51      25.485  15.729  45.728  1.00 18.62           C  
ATOM    379  O   ASP    51      24.996  15.643  44.594  1.00 20.29           O  
ATOM    380  CB  ASP    51      24.221  17.858  46.095  1.00 17.22           C  
ATOM    381  CG  ASP    51      25.275  18.819  45.449  1.00 16.96           C  
ATOM    382  OD1 ASP    51      26.446  18.763  45.837  1.00 15.87           O  
ATOM    383  OD2 ASP    51      24.885  19.656  44.603  1.00 17.18           O  
ATOM    384  N   GLY    52      26.570  15.066  46.089  1.00 18.80           N  
ATOM    385  CA  GLY    52      27.265  14.093  45.221  1.00 19.12           C  
ATOM    386  C   GLY    52      28.445  14.623  44.446  1.00 19.47           C  
ATOM    387  O   GLY    52      28.960  15.702  44.728  1.00 17.95           O  
ATOM    388  N   THR    53      28.900  13.850  43.464  1.00 19.52           N  
ATOM    389  CA  THR    53      30.041  14.222  42.620  1.00 18.90           C  
ATOM    390  C   THR    53      29.635  14.613  41.189  1.00 18.68           C  
ATOM    391  O   THR    53      30.484  15.049  40.409  1.00 18.71           O  
ATOM    392  CB  THR    53      31.100  13.098  42.588  1.00 20.40           C  
ATOM    393  OG1 THR    53      30.591  11.929  41.936  1.00 19.40           O  
ATOM    394  CG2 THR    53      31.487  12.730  43.989  1.00 18.56           C  
ATOM    395  N   GLY    54      28.342  14.479  40.890  1.00 18.08           N  
ATOM    396  CA  GLY    54      27.797  14.852  39.565  1.00 18.15           C  
ATOM    397  C   GLY    54      27.422  16.310  39.529  1.00 17.99           C  
ATOM    398  O   GLY    54      28.044  17.126  40.196  1.00 16.30           O  
ATOM    399  N   LYS    55      26.431  16.669  38.714  1.00 18.61           N  
ATOM    400  CA  LYS    55      25.984  18.066  38.660  1.00 19.18           C  
ATOM    401  C   LYS    55      25.172  18.410  39.928  1.00 19.61           C  
ATOM    402  O   LYS    55      24.874  17.545  40.740  1.00 20.47           O  
ATOM    403  CB  LYS    55      25.155  18.341  37.402  1.00 18.09           C  
ATOM    404  CG  LYS    55      25.779  17.855  36.100  1.00 18.97           C  
ATOM    405  CD  LYS    55      27.137  18.440  35.786  1.00 16.78           C  
ATOM    406  CE  LYS    55      27.666  17.904  34.463  1.00 17.15           C  
ATOM    407  NZ  LYS    55      29.043  18.299  34.203  1.00 15.64           N  
ATOM    408  N   GLY    56      24.841  19.674  40.112  1.00 21.23           N  
ATOM    409  CA  GLY    56      24.195  20.095  41.347  1.00 23.40           C  
ATOM    410  C   GLY    56      22.706  20.367  41.212  1.00 26.27           C  
ATOM    411  O   GLY    56      21.982  19.583  40.578  1.00 26.45           O  
ATOM    412  N   ASN    57      22.269  21.475  41.834  1.00 28.70           N  
ATOM    413  CA  ASN    57      20.861  21.884  41.927  1.00 29.78           C  
ATOM    414  C   ASN    57      19.958  20.920  42.715  1.00 31.60           C  
ATOM    415  O   ASN    57      18.855  20.566  42.258  1.00 31.48           O  
ATOM    416  CB  ASN    57      20.262  22.123  40.542  1.00 30.37           C  
ATOM    417  CG  ASN    57      18.956  22.890  40.607  1.00 31.02           C  
ATOM    418  OD1 ASN    57      18.850  23.915  41.305  1.00 33.00           O  
ATOM    419  ND2 ASN    57      17.941  22.385  39.897  1.00 34.64           N  
ATOM    420  N   MET    58      20.430  20.504  43.890  1.00 32.93           N  
ATOM    421  CA  MET    58      19.658  19.659  44.798  1.00 33.89           C  
ATOM    422  C   MET    58      18.407  20.432  45.169  1.00 33.89           C  
ATOM    423  O   MET    58      18.487  21.638  45.423  1.00 33.20           O  
ATOM    424  CB  MET    58      20.477  19.331  46.057  1.00 34.06           C  
ATOM    425  CG  MET    58      19.687  18.736  47.231  1.00 34.27           C  
ATOM    426  SD  MET    58      20.804  18.380  48.823  1.00 39.46          SE  
ATOM    427  CE  MET    58      21.504  16.625  48.283  1.00 37.15           C  
ATOM    428  N   PRO    59      17.248  19.746  45.220  1.00 34.77           N  
ATOM    429  CA  PRO    59      16.009  20.439  45.575  1.00 34.69           C  
ATOM    430  C   PRO    59      16.161  21.249  46.847  1.00 34.46           C  
ATOM    431  O   PRO    59      16.751  20.763  47.809  1.00 34.35           O  
ATOM    432  CB  PRO    59      15.019  19.289  45.787  1.00 34.79           C  
ATOM    433  CG  PRO    59      15.520  18.207  44.935  1.00 35.42           C  
ATOM    434  CD  PRO    59      17.012  18.311  44.971  1.00 34.36           C  
ATOM    435  N   LEU    60      15.638  22.473  46.827  1.00 34.85           N  
ATOM    436  CA  LEU    60      15.724  23.401  47.958  1.00 35.19           C  
ATOM    437  C   LEU    60      15.330  22.734  49.275  1.00 35.44           C  
ATOM    438  O   LEU    60      16.056  22.842  50.268  1.00 35.44           O  
ATOM    439  CB  LEU    60      14.866  24.653  47.672  1.00 35.52           C  
ATOM    440  CG  LEU    60      14.630  25.741  48.730  1.00 35.95           C  
ATOM    441  CD1 LEU    60      15.938  26.400  49.194  1.00 37.05           C  
ATOM    442  CD2 LEU    60      13.665  26.795  48.181  1.00 35.81           C  
ATOM    443  N   ARG    61      14.202  22.023  49.279  1.00 35.40           N  
ATOM    444  CA  ARG    61      13.754  21.312  50.472  1.00 35.63           C  
ATOM    445  C   ARG    61      14.837  20.413  51.034  1.00 34.40           C  
ATOM    446  O   ARG    61      15.057  20.387  52.241  1.00 34.12           O  
ATOM    447  CB  ARG    61      12.506  20.462  50.181  1.00 35.88           C  
ATOM    448  CG  ARG    61      11.754  20.016  51.437  1.00 37.02           C  
ATOM    449  CD  ARG    61      10.643  19.007  51.127  1.00 38.89           C  
ATOM    450  NE  ARG    61       9.479  19.199  52.007  1.00 42.60           N  
ATOM    451  CZ  ARG    61       9.298  18.623  53.201  1.00 43.79           C  
ATOM    452  NH1 ARG    61      10.199  17.782  53.711  1.00 44.88           N  
ATOM    453  NH2 ARG    61       8.197  18.896  53.903  1.00 44.04           N  
ATOM    454  N   ASP    62      15.504  19.663  50.157  1.00 33.41           N  
ATOM    455  CA  ASP    62      16.564  18.757  50.588  1.00 32.98           C  
ATOM    456  C   ASP    62      17.827  19.509  51.000  1.00 32.56           C  
ATOM    457  O   ASP    62      18.515  19.122  51.956  1.00 31.80           O  
ATOM    458  CB  ASP    62      16.915  17.787  49.464  1.00 33.50           C  
ATOM    459  CG  ASP    62      15.813  16.796  49.195  1.00 35.55           C  
ATOM    460  OD1 ASP    62      15.448  16.083  50.143  1.00 36.84           O  
ATOM    461  OD2 ASP    62      15.324  16.732  48.044  1.00 36.66           O  
ATOM    462  N   ALA    63      18.130  20.569  50.262  1.00 32.41           N  
ATOM    463  CA  ALA    63      19.303  21.392  50.555  1.00 32.21           C  
ATOM    464  C   ALA    63      19.179  22.007  51.940  1.00 31.80           C  
ATOM    465  O   ALA    63      20.131  21.981  52.736  1.00 30.34           O  
ATOM    466  CB  ALA    63      19.463  22.486  49.497  1.00 32.12           C  
ATOM    467  N   VAL    64      17.999  22.554  52.222  1.00 31.75           N  
ATOM    468  CA  VAL    64      17.757  23.243  53.487  1.00 32.01           C  
ATOM    469  C   VAL    64      17.885  22.299  54.663  1.00 32.04           C  
ATOM    470  O   VAL    64      18.405  22.677  55.720  1.00 32.24           O  
ATOM    471  CB  VAL    64      16.379  23.922  53.494  1.00 31.90           C  
ATOM    472  CG1 VAL    64      15.985  24.363  54.913  1.00 33.17           C  
ATOM    473  CG2 VAL    64      16.380  25.112  52.519  1.00 32.38           C  
ATOM    474  N   LYS    65      17.425  21.061  54.484  1.00 32.28           N  
ATOM    475  CA  LYS    65      17.626  20.045  55.498  1.00 32.15           C  
ATOM    476  C   LYS    65      19.121  19.869  55.797  1.00 31.69           C  
ATOM    477  O   LYS    65      19.510  19.743  56.965  1.00 32.06           O  
ATOM    478  CB  LYS    65      16.998  18.719  55.059  1.00 32.23           C  
ATOM    479  CG  LYS    65      17.071  17.622  56.112  1.00 33.52           C  
ATOM    480  CD  LYS    65      16.074  16.482  55.803  1.00 33.68           C  
ATOM    481  CE  LYS    65      16.172  15.331  56.814  1.00 35.08           C  
ATOM    482  NZ  LYS    65      15.380  14.141  56.361  1.00 35.51           N  
ATOM    483  N   LEU    66      19.952  19.871  54.749  1.00 31.99           N  
ATOM    484  CA  LEU    66      21.418  19.735  54.908  1.00 31.64           C  
ATOM    485  C   LEU    66      22.007  20.970  55.569  1.00 31.14           C  
ATOM    486  O   LEU    66      22.910  20.867  56.397  1.00 31.20           O  
ATOM    487  CB  LEU    66      22.134  19.532  53.555  1.00 32.33           C  
ATOM    488  CG  LEU    66      22.199  18.149  52.920  1.00 32.67           C  
ATOM    489  CD1 LEU    66      23.110  18.180  51.702  1.00 32.46           C  
ATOM    490  CD2 LEU    66      22.693  17.158  53.941  1.00 33.60           C  
ATOM    491  N   ILE    67      21.520  22.144  55.186  1.00 30.65           N  
ATOM    492  CA  ILE    67      22.019  23.390  55.794  1.00 30.53           C  
ATOM    493  C   ILE    67      21.781  23.317  57.296  1.00 30.61           C  
ATOM    494  O   ILE    67      22.689  23.557  58.101  1.00 30.70           O  
ATOM    495  CB  ILE    67      21.329  24.636  55.237  1.00 29.98           C  
ATOM    496  CG1 ILE    67      21.652  24.811  53.750  1.00 30.27           C  
ATOM    497  CG2 ILE    67      21.773  25.856  56.013  1.00 30.49           C  
ATOM    498  CD1 ILE    67      20.812  25.860  53.071  1.00 29.74           C  
ATOM    499  N   ARG    68      20.561  22.939  57.671  1.00 31.39           N  
ATOM    500  CA  ARG    68      20.193  22.903  59.084  1.00 31.83           C  
ATOM    501  C   ARG    68      21.047  21.912  59.868  1.00 31.40           C  
ATOM    502  O   ARG    68      21.397  22.174  61.016  1.00 31.46           O  
ATOM    503  CB  ARG    68      18.695  22.595  59.260  1.00 33.01           C  
ATOM    504  CG  ARG    68      17.772  23.795  59.029  1.00 36.24           C  
ATOM    505  CD  ARG    68      17.873  24.818  60.177  1.00 41.17           C  
ATOM    506  NE  ARG    68      19.045  25.675  60.003  1.00 43.00           N  
ATOM    507  CZ  ARG    68      19.035  26.899  59.468  1.00 45.56           C  
ATOM    508  NH1 ARG    68      17.895  27.480  59.083  1.00 46.79           N  
ATOM    509  NH2 ARG    68      20.187  27.566  59.342  1.00 45.68           N  
ATOM    510  N   GLY    69      21.401  20.794  59.242  1.00 30.57           N  
ATOM    511  CA  GLY    69      22.248  19.787  59.879  1.00 30.43           C  
ATOM    512  C   GLY    69      23.749  20.043  59.892  1.00 30.53           C  
ATOM    513  O   GLY    69      24.517  19.191  60.351  1.00 32.13           O  
ATOM    514  N   SER    70      24.201  21.199  59.400  1.00 29.47           N  
ATOM    515  CA  SER    70      25.638  21.486  59.285  1.00 28.02           C  
ATOM    516  C   SER    70      26.085  22.722  60.038  1.00 27.20           C  
ATOM    517  O   SER    70      25.262  23.587  60.365  1.00 27.08           O  
ATOM    518  CB  SER    70      25.987  21.693  57.807  1.00 28.14           C  
ATOM    519  OG  SER    70      25.222  22.756  57.272  1.00 28.59           O  
ATOM    520  N   ASP    71      27.398  22.820  60.261  1.00 24.97           N  
ATOM    521  CA  ASP    71      28.044  24.004  60.844  1.00 25.41           C  
ATOM    522  C   ASP    71      28.418  25.113  59.857  1.00 23.39           C  
ATOM    523  O   ASP    71      28.356  26.310  60.191  1.00 23.55           O  
ATOM    524  CB  ASP    71      29.315  23.588  61.558  1.00 25.77           C  
ATOM    525  CG  ASP    71      29.038  22.582  62.645  1.00 28.16           C  
ATOM    526  OD1 ASP    71      28.244  22.909  63.548  1.00 33.39           O  
ATOM    527  OD2 ASP    71      29.580  21.469  62.588  1.00 31.28           O  
ATOM    528  N   VAL    72      28.853  24.722  58.660  1.00 19.86           N  
ATOM    529  CA  VAL    72      28.913  25.665  57.552  1.00 17.24           C  
ATOM    530  C   VAL    72      28.384  24.944  56.302  1.00 15.12           C  
ATOM    531  O   VAL    72      28.620  23.756  56.147  1.00 15.39           O  
ATOM    532  CB  VAL    72      30.332  26.228  57.353  1.00 17.18           C  
ATOM    533  CG1 VAL    72      31.298  25.148  56.926  1.00 18.57           C  
ATOM    534  CG2 VAL    72      30.288  27.413  56.372  1.00 17.39           C  
ATOM    535  N   ALA    73      27.631  25.665  55.469  1.00 15.30           N  
ATOM    536  CA  ALA    73      27.054  25.135  54.239  1.00 13.84           C  
ATOM    537  C   ALA    73      27.324  26.114  53.114  1.00 12.77           C  
ATOM    538  O   ALA    73      26.961  27.282  53.216  1.00 13.46           O  
ATOM    539  CB  ALA    73      25.550  24.914  54.363  1.00 14.11           C  
ATOM    540  N   ILE    74      27.958  25.633  52.039  1.00 11.08           N  
ATOM    541  CA  ILE    74      28.370  26.460  50.913  1.00 11.00           C  
ATOM    542  C   ILE    74      27.899  25.858  49.594  1.00 10.38           C  
ATOM    543  O   ILE    74      28.153  24.651  49.330  1.00 10.14           O  
ATOM    544  CB  ILE    74      29.931  26.550  50.860  1.00 10.21           C  
ATOM    545  CG1 ILE    74      30.482  27.113  52.173  1.00 11.60           C  
ATOM    546  CG2 ILE    74      30.360  27.423  49.691  1.00  9.66           C  
ATOM    547  CD1 ILE    74      31.927  26.715  52.489  1.00 11.66           C  
ATOM    548  N   GLU    75      27.193  26.642  48.794  1.00 10.25           N  
ATOM    549  CA  GLU    75      26.860  26.260  47.429  1.00 10.99           C  
ATOM    550  C   GLU    75      27.640  27.099  46.429  1.00  9.77           C  
ATOM    551  O   GLU    75      27.563  28.339  46.420  1.00 10.46           O  
ATOM    552  CB  GLU    75      25.354  26.385  47.146  1.00 10.58           C  
ATOM    553  CG  GLU    75      25.032  25.820  45.795  1.00 15.14           C  
ATOM    554  CD  GLU    75      23.600  25.573  45.593  1.00 15.12           C  
ATOM    555  OE1 GLU    75      22.938  26.493  45.060  1.00 16.51           O  
ATOM    556  OE2 GLU    75      23.154  24.462  45.954  1.00 18.39           O  
ATOM    557  N   PHE    76      28.400  26.431  45.574  1.00  8.35           N  
ATOM    558  CA  PHE    76      29.277  27.099  44.647  1.00  9.71           C  
ATOM    559  C   PHE    76      28.517  27.496  43.375  1.00 10.51           C  
ATOM    560  O   PHE    76      27.781  26.696  42.794  1.00 11.05           O  
ATOM    561  CB  PHE    76      30.497  26.220  44.294  1.00  9.16           C  
ATOM    562  CG  PHE    76      31.382  25.910  45.472  1.00  8.67           C  
ATOM    563  CD1 PHE    76      32.393  26.767  45.867  1.00  8.62           C  
ATOM    564  CD2 PHE    76      31.198  24.750  46.174  1.00  8.57           C  
ATOM    565  CE1 PHE    76      33.206  26.436  46.959  1.00  9.67           C  
ATOM    566  CE2 PHE    76      31.996  24.415  47.297  1.00  8.81           C  
ATOM    567  CZ  PHE    76      32.977  25.270  47.673  1.00 10.15           C  
ATOM    568  N   HIS    77      28.705  28.743  43.013  1.00 10.51           N  
ATOM    569  CA  HIS    77      28.141  29.362  41.811  1.00 10.64           C  
ATOM    570  C   HIS    77      29.202  30.218  41.149  1.00 11.18           C  
ATOM    571  O   HIS    77      30.275  30.426  41.719  1.00 11.20           O  
ATOM    572  CB  HIS    77      27.005  30.298  42.193  1.00 11.61           C  
ATOM    573  CG  HIS    77      25.734  29.603  42.540  1.00 13.77           C  
ATOM    574  ND1 HIS    77      24.664  29.542  41.668  1.00 16.79           N  
ATOM    575  CD2 HIS    77      25.367  28.904  43.639  1.00 14.60           C  
ATOM    576  CE1 HIS    77      23.707  28.805  42.206  1.00 18.08           C  
ATOM    577  NE2 HIS    77      24.100  28.420  43.406  1.00 15.03           N  
ATOM    578  N   THR    78      28.917  30.680  39.920  1.00 10.44           N  
ATOM    579  CA  THR    78      29.678  31.759  39.310  1.00 11.99           C  
ATOM    580  C   THR    78      28.761  32.965  39.114  1.00 13.76           C  
ATOM    581  O   THR    78      27.549  32.793  38.805  1.00 15.81           O  
ATOM    582  CB  THR    78      30.295  31.391  37.935  1.00 12.15           C  
ATOM    583  OG1 THR    78      29.256  31.049  37.021  1.00 12.01           O  
ATOM    584  CG2 THR    78      31.174  30.207  38.044  1.00 12.25           C  
ATOM    585  N   ASN    79      29.329  34.154  39.286  1.00 14.04           N  
ATOM    586  CA  ASN    79      28.639  35.387  38.980  1.00 14.97           C  
ATOM    587  C   ASN    79      28.612  35.580  37.466  1.00 15.24           C  
ATOM    588  O   ASN    79      29.242  34.834  36.728  1.00 13.52           O  
ATOM    589  CB  ASN    79      29.265  36.568  39.718  1.00 13.90           C  
ATOM    590  CG  ASN    79      28.223  37.540  40.231  1.00 17.46           C  
ATOM    591  OD1 ASN    79      27.185  37.762  39.574  1.00 16.55           O  
ATOM    592  ND2 ASN    79      28.477  38.119  41.409  1.00 18.08           N  
ATOM    593  N   ALA    80      27.808  36.522  36.998  1.00 15.48           N  
ATOM    594  CA  ALA    80      27.708  36.818  35.584  1.00 16.11           C  
ATOM    595  C   ALA    80      27.127  38.226  35.427  1.00 17.59           C  
ATOM    596  O   ALA    80      26.250  38.614  36.191  1.00 18.01           O  
ATOM    597  CB  ALA    80      26.802  35.817  34.892  1.00 15.30           C  
ATOM    598  N   ALA    81      27.604  38.947  34.427  1.00 18.26           N  
ATOM    599  CA  ALA    81      27.067  40.254  34.042  1.00 18.58           C  
ATOM    600  C   ALA    81      27.149  40.405  32.530  1.00 20.23           C  
ATOM    601  O   ALA    81      28.008  39.798  31.859  1.00 19.95           O  
ATOM    602  CB  ALA    81      27.827  41.366  34.700  1.00 18.94           C  
ATOM    603  N   ALA    82      26.240  41.219  31.988  1.00 20.94           N  
ATOM    604  CA  ALA    82      26.350  41.615  30.586  1.00 21.78           C  
ATOM    605  C   ALA    82      27.650  42.410  30.379  1.00 21.80           C  
ATOM    606  O   ALA    82      28.279  42.336  29.320  1.00 22.94           O  
ATOM    607  CB  ALA    82      25.120  42.420  30.167  1.00 22.32           C  
ATOM    608  N   ASN    83      28.060  43.144  31.402  1.00 21.82           N  
ATOM    609  CA  ASN    83      29.319  43.871  31.381  1.00 22.00           C  
ATOM    610  C   ASN    83      30.470  42.900  31.610  1.00 21.89           C  
ATOM    611  O   ASN    83      30.705  42.478  32.752  1.00 20.94           O  
ATOM    612  CB  ASN    83      29.359  44.926  32.480  1.00 21.98           C  
ATOM    613  CG  ASN    83      30.709  45.613  32.586  1.00 22.90           C  
ATOM    614  OD1 ASN    83      31.650  45.345  31.820  1.00 24.69           O  
ATOM    615  ND2 ASN    83      30.814  46.525  33.554  1.00 29.12           N  
ATOM    616  N   LYS    84      31.196  42.592  30.536  1.00 21.83           N  
ATOM    617  CA  LYS    84      32.234  41.554  30.585  1.00 20.98           C  
ATOM    618  C   LYS    84      33.527  42.002  31.263  1.00 20.68           C  
ATOM    619  O   LYS    84      34.496  41.243  31.290  1.00 21.88           O  
ATOM    620  CB  LYS    84      32.489  40.998  29.188  1.00 21.81           C  
ATOM    621  CG  LYS    84      31.383  40.109  28.702  1.00 21.21           C  
ATOM    622  CD  LYS    84      31.703  39.516  27.332  1.00 21.90           C  
ATOM    623  CE  LYS    84      32.824  38.473  27.401  1.00 22.19           C  
ATOM    624  NZ  LYS    84      32.484  37.334  28.296  1.00 19.65           N  
ATOM    625  N   THR    85      33.537  43.217  31.822  1.00 19.47           N  
ATOM    626  CA  THR    85      34.599  43.686  32.664  1.00 19.21           C  
ATOM    627  C   THR    85      34.235  43.611  34.160  1.00 17.60           C  
ATOM    628  O   THR    85      35.103  43.816  34.996  1.00 17.31           O  
ATOM    629  CB  THR    85      35.004  45.138  32.316  1.00 20.58           C  
ATOM    630  OG1 THR    85      33.946  46.017  32.680  1.00 22.41           O  
ATOM    631  CG2 THR    85      35.322  45.292  30.829  1.00 21.49           C  
ATOM    632  N   ALA    86      32.985  43.297  34.488  1.00 16.49           N  
ATOM    633  CA  ALA    86      32.551  43.124  35.906  1.00 15.81           C  
ATOM    634  C   ALA    86      33.445  42.034  36.508  1.00 15.39           C  
ATOM    635  O   ALA    86      33.701  41.024  35.862  1.00 14.80           O  
ATOM    636  CB  ALA    86      31.118  42.697  35.991  1.00 15.94           C  
ATOM    637  N   THR    87      33.902  42.248  37.737  1.00 13.83           N  
ATOM    638  CA  THR    87      34.869  41.358  38.358  1.00 14.06           C  
ATOM    639  C   THR    87      34.712  41.352  39.874  1.00 13.07           C  
ATOM    640  O   THR    87      34.234  42.324  40.455  1.00 13.94           O  
ATOM    641  CB  THR    87      36.310  41.767  38.003  1.00 13.33           C  
ATOM    642  OG1 THR    87      37.258  40.793  38.493  1.00 13.66           O  
ATOM    643  CG2 THR    87      36.672  43.160  38.539  1.00 13.70           C  
ATOM    644  N   GLY    88      35.112  40.248  40.500  1.00 13.12           N  
ATOM    645  CA  GLY    88      35.325  40.216  41.951  1.00 12.05           C  
ATOM    646  C   GLY    88      34.592  39.055  42.593  1.00 11.93           C  
ATOM    647  O   GLY    88      33.816  38.357  41.950  1.00 11.41           O  
ATOM    648  N   ILE    89      34.801  38.950  43.904  1.00 11.18           N  
ATOM    649  CA  ILE    89      34.398  37.844  44.738  1.00 11.60           C  
ATOM    650  C   ILE    89      33.299  38.263  45.670  1.00 11.65           C  
ATOM    651  O   ILE    89      33.416  39.274  46.348  1.00 11.50           O  
ATOM    652  CB  ILE    89      35.585  37.452  45.661  1.00 11.34           C  
ATOM    653  CG1 ILE    89      36.784  36.947  44.847  1.00 11.27           C  
ATOM    654  CG2 ILE    89      35.141  36.418  46.722  1.00 10.92           C  
ATOM    655  CD1 ILE    89      38.109  37.062  45.614  1.00 11.84           C  
ATOM    656  N   GLU    90      32.265  37.443  45.759  1.00 12.53           N  
ATOM    657  CA  GLU    90      31.277  37.665  46.783  1.00 13.96           C  
ATOM    658  C   GLU    90      30.591  36.393  47.222  1.00 13.12           C  
ATOM    659  O   GLU    90      30.554  35.382  46.512  1.00 12.13           O  
ATOM    660  CB  GLU    90      30.283  38.725  46.358  1.00 14.33           C  
ATOM    661  CG  GLU    90      29.404  38.392  45.194  1.00 17.54           C  
ATOM    662  CD  GLU    90      28.499  39.573  44.774  1.00 18.10           C  
ATOM    663  OE1 GLU    90      28.939  40.737  44.758  1.00 19.74           O  
ATOM    664  OE2 GLU    90      27.329  39.312  44.496  1.00 23.13           O  
ATOM    665  N   ALA    91      30.038  36.476  48.424  1.00 12.59           N  
ATOM    666  CA  ALA    91      29.327  35.362  49.052  1.00 12.55           C  
ATOM    667  C   ALA    91      28.122  35.963  49.739  1.00 13.67           C  
ATOM    668  O   ALA    91      28.273  36.935  50.503  1.00 14.76           O  
ATOM    669  CB  ALA    91      30.219  34.677  50.058  1.00 12.93           C  
ATOM    670  N   LEU    92      26.951  35.405  49.434  1.00 14.00           N  
ATOM    671  CA  LEU    92      25.669  35.901  49.894  1.00 13.72           C  
ATOM    672  C   LEU    92      25.204  35.014  51.015  1.00 12.84           C  
ATOM    673  O   LEU    92      25.123  33.816  50.833  1.00 11.78           O  
ATOM    674  CB  LEU    92      24.647  35.813  48.754  1.00 14.51           C  
ATOM    675  CG  LEU    92      23.236  36.266  49.016  1.00 16.47           C  
ATOM    676  CD1 LEU    92      23.256  37.810  49.091  1.00 17.66           C  
ATOM    677  CD2 LEU    92      22.222  35.729  47.904  1.00 17.15           C  
ATOM    678  N   SER    93      24.880  35.584  52.184  1.00 12.23           N  
ATOM    679  CA  SER    93      24.316  34.760  53.245  1.00 12.45           C  
ATOM    680  C   SER    93      23.635  35.658  54.259  1.00 12.65           C  
ATOM    681  O   SER    93      23.597  36.861  54.081  1.00 12.45           O  
ATOM    682  CB  SER    93      25.409  33.928  53.905  1.00 12.94           C  
ATOM    683  OG  SER    93      24.908  32.896  54.741  1.00 13.48           O  
ATOM    684  N   THR    94      23.139  35.036  55.311  1.00 13.32           N  
ATOM    685  CA  THR    94      22.671  35.777  56.508  1.00 13.48           C  
ATOM    686  C   THR    94      23.869  36.378  57.264  1.00 13.60           C  
ATOM    687  O   THR    94      24.983  35.864  57.215  1.00 12.44           O  
ATOM    688  CB  THR    94      21.946  34.807  57.472  1.00 14.03           C  
ATOM    689  OG1 THR    94      22.769  33.662  57.747  1.00 16.62           O  
ATOM    690  CG2 THR    94      20.622  34.304  56.892  1.00 14.67           C  
ATOM    691  N   PRO    95      23.641  37.462  58.015  1.00 13.65           N  
ATOM    692  CA  PRO    95      24.695  38.017  58.832  1.00 14.02           C  
ATOM    693  C   PRO    95      25.406  37.061  59.774  1.00 12.53           C  
ATOM    694  O   PRO    95      26.605  37.214  60.041  1.00 13.27           O  
ATOM    695  CB  PRO    95      23.967  39.123  59.608  1.00 14.04           C  
ATOM    696  CG  PRO    95      22.923  39.551  58.678  1.00 14.14           C  
ATOM    697  CD  PRO    95      22.422  38.288  58.055  1.00 14.36           C  
ATOM    698  N   LYS    96      24.697  36.061  60.268  1.00 13.72           N  
ATOM    699  CA  LYS    96      25.327  35.005  61.056  1.00 13.47           C  
ATOM    700  C   LYS    96      26.614  34.467  60.393  1.00 12.50           C  
ATOM    701  O   LYS    96      27.602  34.152  61.057  1.00 11.32           O  
ATOM    702  CB  LYS    96      24.337  33.826  61.254  1.00 12.75           C  
ATOM    703  CG  LYS    96      24.934  32.634  61.984  1.00 16.30           C  
ATOM    704  CD  LYS    96      23.953  31.513  62.266  1.00 17.97           C  
ATOM    705  CE  LYS    96      24.717  30.253  62.700  1.00 21.40           C  
ATOM    706  NZ  LYS    96      23.894  29.085  63.065  1.00 25.06           N  
ATOM    707  N   ASN    97      26.545  34.328  59.076  1.00 12.01           N  
ATOM    708  CA  ASN    97      27.620  33.750  58.280  1.00 12.17           C  
ATOM    709  C   ASN    97      28.623  34.782  57.706  1.00 12.27           C  
ATOM    710  O   ASN    97      29.440  34.436  56.863  1.00 10.54           O  
ATOM    711  CB  ASN    97      26.958  32.985  57.125  1.00 12.11           C  
ATOM    712  CG  ASN    97      26.285  31.706  57.593  1.00 15.07           C  
ATOM    713  OD1 ASN    97      25.115  31.447  57.304  1.00 21.97           O  
ATOM    714  ND2 ASN    97      27.032  30.882  58.250  1.00 16.86           N  
ATOM    715  N   LYS    98      28.584  36.037  58.153  1.00 12.10           N  
ATOM    716  CA  LYS    98      29.499  37.051  57.599  1.00 12.23           C  
ATOM    717  C   LYS    98      30.976  36.647  57.732  1.00 12.22           C  
ATOM    718  O   LYS    98      31.729  36.716  56.764  1.00 11.65           O  
ATOM    719  CB  LYS    98      29.243  38.412  58.250  1.00 12.92           C  
ATOM    720  CG  LYS    98      30.237  39.490  57.867  1.00 13.96           C  
ATOM    721  CD  LYS    98      30.074  40.704  58.794  1.00 17.06           C  
ATOM    722  CE  LYS    98      28.920  41.501  58.450  1.00 22.64           C  
ATOM    723  NZ  LYS    98      29.107  42.802  59.189  1.00 20.35           N  
ATOM    724  N   ARG    99      31.378  36.207  58.903  1.00 11.77           N  
ATOM    725  CA  ARG    99      32.744  35.789  59.107  1.00 12.07           C  
ATOM    726  C   ARG    99      33.094  34.658  58.164  1.00 11.35           C  
ATOM    727  O   ARG    99      34.126  34.721  57.524  1.00 11.10           O  
ATOM    728  CB  ARG    99      32.954  35.391  60.564  1.00 13.09           C  
ATOM    729  CG  ARG    99      34.216  34.658  60.867  1.00 16.31           C  
ATOM    730  CD  ARG    99      35.448  35.363  60.520  1.00 21.09           C  
ATOM    731  NE  ARG    99      36.585  34.562  60.980  1.00 23.61           N  
ATOM    732  CZ  ARG    99      37.858  34.905  60.808  1.00 26.74           C  
ATOM    733  NH1 ARG    99      38.170  36.030  60.161  1.00 30.25           N  
ATOM    734  NH2 ARG    99      38.827  34.113  61.253  1.00 25.52           N  
ATOM    735  N   TRP   100      32.236  33.649  58.028  1.00 12.14           N  
ATOM    736  CA  TRP   100      32.545  32.561  57.104  1.00 11.87           C  
ATOM    737  C   TRP   100      32.693  33.058  55.674  1.00 11.50           C  
ATOM    738  O   TRP   100      33.613  32.646  54.974  1.00 10.33           O  
ATOM    739  CB  TRP   100      31.477  31.483  57.131  1.00 12.98           C  
ATOM    740  CG  TRP   100      31.705  30.440  58.097  1.00 13.96           C  
ATOM    741  CD1 TRP   100      30.933  30.156  59.171  1.00 15.73           C  
ATOM    742  CD2 TRP   100      32.760  29.466  58.084  1.00 13.06           C  
ATOM    743  NE1 TRP   100      31.432  29.062  59.837  1.00 17.23           N  
ATOM    744  CE2 TRP   100      32.556  28.619  59.183  1.00 14.23           C  
ATOM    745  CE3 TRP   100      33.836  29.211  57.225  1.00 14.96           C  
ATOM    746  CZ2 TRP   100      33.425  27.555  59.478  1.00 16.73           C  
ATOM    747  CZ3 TRP   100      34.706  28.138  57.523  1.00 15.72           C  
ATOM    748  CH2 TRP   100      34.474  27.330  58.630  1.00 14.54           C  
ATOM    749  N   CYS   101      31.795  33.948  55.252  1.00  9.83           N  
ATOM    750  CA  CYS   101      31.874  34.555  53.889  1.00 10.02           C  
ATOM    751  C   CYS   101      33.208  35.250  53.680  1.00  9.88           C  
ATOM    752  O   CYS   101      33.783  35.183  52.573  1.00 11.02           O  
ATOM    753  CB  CYS   101      30.717  35.543  53.680  1.00  9.62           C  
ATOM    754  SG  CYS   101      29.117  34.722  53.540  1.00 11.35           S  
ATOM    755  N   GLN   102      33.680  35.915  54.725  1.00 10.27           N  
ATOM    756  CA  GLN   102      34.921  36.693  54.664  1.00 10.90           C  
ATOM    757  C   GLN   102      36.145  35.754  54.643  1.00 10.48           C  
ATOM    758  O   GLN   102      37.108  35.992  53.899  1.00  9.96           O  
ATOM    759  CB  GLN   102      34.988  37.704  55.808  1.00 10.56           C  
ATOM    760  CG  GLN   102      33.984  38.826  55.606  1.00 11.18           C  
ATOM    761  CD  GLN   102      33.833  39.773  56.760  1.00 13.02           C  
ATOM    762  OE1 GLN   102      34.134  39.432  57.933  1.00 15.34           O  
ATOM    763  NE2 GLN   102      33.329  40.964  56.452  1.00 13.22           N  
ATOM    764  N   VAL   103      36.088  34.673  55.419  1.00 10.76           N  
ATOM    765  CA  VAL   103      37.157  33.648  55.411  1.00 10.87           C  
ATOM    766  C   VAL   103      37.288  33.048  54.002  1.00 10.54           C  
ATOM    767  O   VAL   103      38.392  32.952  53.459  1.00 11.78           O  
ATOM    768  CB  VAL   103      36.849  32.521  56.424  1.00 11.27           C  
ATOM    769  CG1 VAL   103      37.772  31.322  56.244  1.00 13.27           C  
ATOM    770  CG2 VAL   103      36.933  33.055  57.852  1.00 13.41           C  
ATOM    771  N   LEU   104      36.153  32.681  53.412  1.00  9.58           N  
ATOM    772  CA  LEU   104      36.140  32.080  52.053  1.00  9.35           C  
ATOM    773  C   LEU   104      36.664  33.079  51.038  1.00  9.21           C  
ATOM    774  O   LEU   104      37.482  32.758  50.193  1.00 11.19           O  
ATOM    775  CB  LEU   104      34.739  31.647  51.640  1.00  9.52           C  
ATOM    776  CG  LEU   104      34.160  30.513  52.521  1.00  8.90           C  
ATOM    777  CD1 LEU   104      32.654  30.405  52.286  1.00 10.86           C  
ATOM    778  CD2 LEU   104      34.872  29.178  52.233  1.00 13.22           C  
ATOM    779  N   GLY   105      36.147  34.306  51.094  1.00  8.98           N  
ATOM    780  CA  GLY   105      36.502  35.320  50.096  1.00  9.40           C  
ATOM    781  C   GLY   105      37.992  35.659  50.134  1.00 10.13           C  
ATOM    782  O   GLY   105      38.671  35.743  49.095  1.00 11.62           O  
ATOM    783  N   LYS   106      38.526  35.826  51.332  1.00 10.33           N  
ATOM    784  CA  LYS   106      39.908  36.195  51.486  1.00 12.55           C  
ATOM    785  C   LYS   106      40.833  35.104  50.976  1.00 11.45           C  
ATOM    786  O   LYS   106      41.879  35.381  50.381  1.00 12.15           O  
ATOM    787  CB  LYS   106      40.185  36.499  52.943  1.00 12.66           C  
ATOM    788  CG  LYS   106      39.510  37.788  53.388  1.00 17.60           C  
ATOM    789  CD  LYS   106      39.545  37.955  54.884  1.00 17.18           C  
ATOM    790  CE  LYS   106      39.110  39.365  55.291  1.00 19.61           C  
ATOM    791  NZ  LYS   106      38.972  39.476  56.751  1.00 23.27           N  
ATOM    792  N   ALA   107      40.459  33.852  51.218  1.00 11.47           N  
ATOM    793  CA  ALA   107      41.229  32.723  50.748  1.00 11.15           C  
ATOM    794  C   ALA   107      41.401  32.791  49.233  1.00 11.45           C  
ATOM    795  O   ALA   107      42.497  32.562  48.706  1.00 13.01           O  
ATOM    796  CB  ALA   107      40.532  31.423  51.126  1.00 12.40           C  
ATOM    797  N   VAL   108      40.306  33.097  48.529  1.00 10.23           N  
ATOM    798  CA  VAL   108      40.342  33.188  47.071  1.00  9.98           C  
ATOM    799  C   VAL   108      41.085  34.450  46.576  1.00 10.11           C  
ATOM    800  O   VAL   108      41.883  34.385  45.625  1.00 10.44           O  
ATOM    801  CB  VAL   108      38.912  33.156  46.492  1.00  9.24           C  
ATOM    802  CG1 VAL   108      38.914  33.468  44.967  1.00 10.50           C  
ATOM    803  CG2 VAL   108      38.249  31.776  46.798  1.00 10.79           C  
ATOM    804  N   ALA   109      40.855  35.587  47.243  1.00 10.91           N  
ATOM    805  CA  ALA   109      41.550  36.822  46.896  1.00 10.67           C  
ATOM    806  C   ALA   109      43.075  36.695  46.993  1.00 11.73           C  
ATOM    807  O   ALA   109      43.785  37.207  46.132  1.00 11.79           O  
ATOM    808  CB  ALA   109      41.042  37.993  47.821  1.00 11.42           C  
ATOM    809  N   LYS   110      43.570  36.059  48.053  1.00 11.85           N  
ATOM    810  CA  LYS   110      45.033  35.892  48.243  1.00 13.10           C  
ATOM    811  C   LYS   110      45.627  35.163  47.049  1.00 12.65           C  
ATOM    812  O   LYS   110      46.688  35.530  46.561  1.00 13.57           O  
ATOM    813  CB  LYS   110      45.362  35.124  49.530  1.00 14.62           C  
ATOM    814  CG  LYS   110      45.117  35.920  50.776  1.00 16.13           C  
ATOM    815  CD  LYS   110      44.815  35.056  51.987  1.00 19.63           C  
ATOM    816  CE  LYS   110      45.943  34.932  52.919  1.00 26.45           C  
ATOM    817  NZ  LYS   110      45.389  34.270  54.158  1.00 25.77           N  
ATOM    818  N   LYS   111      44.929  34.154  46.541  1.00 11.13           N  
ATOM    819  CA  LYS   111      45.470  33.309  45.476  1.00 11.70           C  
ATOM    820  C   LYS   111      45.361  33.940  44.088  1.00 11.62           C  
ATOM    821  O   LYS   111      46.088  33.564  43.178  1.00 12.40           O  
ATOM    822  CB  LYS   111      44.727  31.970  45.457  1.00 13.48           C  
ATOM    823  CG  LYS   111      45.279  30.903  44.493  1.00 14.55           C  
ATOM    824  CD  LYS   111      46.568  30.336  45.031  1.00 17.32           C  
ATOM    825  CE  LYS   111      47.072  29.144  44.239  1.00 19.95           C  
ATOM    826  NZ  LYS   111      48.352  28.630  44.887  1.00 21.40           N  
ATOM    827  N   THR   112      44.467  34.909  43.946  1.00  9.70           N  
ATOM    828  CA  THR   112      44.079  35.425  42.614  1.00  9.96           C  
ATOM    829  C   THR   112      44.300  36.903  42.348  1.00  9.64           C  
ATOM    830  O   THR   112      44.335  37.297  41.202  1.00 11.46           O  
ATOM    831  CB  THR   112      42.600  35.161  42.341  1.00 10.16           C  
ATOM    832  OG1 THR   112      41.830  35.824  43.356  1.00  9.79           O  
ATOM    833  CG2 THR   112      42.299  33.664  42.371  1.00 11.05           C  
ATOM    834  N   GLY   113      44.384  37.709  43.391  1.00 10.13           N  
ATOM    835  CA  GLY   113      44.385  39.161  43.219  1.00 10.05           C  
ATOM    836  C   GLY   113      43.025  39.709  42.795  1.00 10.96           C  
ATOM    837  O   GLY   113      42.913  40.856  42.398  1.00 12.09           O  
ATOM    838  N   TRP   114      41.960  38.888  42.891  1.00 10.00           N  
ATOM    839  CA  TRP   114      40.610  39.350  42.585  1.00 10.54           C  
ATOM    840  C   TRP   114      40.111  40.254  43.721  1.00 12.42           C  
ATOM    841  O   TRP   114      40.457  40.058  44.895  1.00 13.56           O  
ATOM    842  CB  TRP   114      39.657  38.156  42.466  1.00 10.87           C  
ATOM    843  CG  TRP   114      39.904  37.283  41.260  1.00  9.66           C  
ATOM    844  CD1 TRP   114      40.566  37.618  40.107  1.00 10.29           C  
ATOM    845  CD2 TRP   114      39.488  35.921  41.099  1.00  7.93           C  
ATOM    846  NE1 TRP   114      40.601  36.529  39.242  1.00 10.00           N  
ATOM    847  CE2 TRP   114      39.925  35.484  39.815  1.00 10.00           C  
ATOM    848  CE3 TRP   114      38.815  35.026  41.908  1.00  9.75           C  
ATOM    849  CZ2 TRP   114      39.702  34.186  39.341  1.00  8.47           C  
ATOM    850  CZ3 TRP   114      38.573  33.723  41.416  1.00 10.15           C  
ATOM    851  CH2 TRP   114      39.016  33.332  40.134  1.00  8.86           C  
ATOM    852  N   LYS   115      39.264  41.198  43.337  1.00 13.64           N  
ATOM    853  CA  LYS   115      38.708  42.165  44.276  1.00 14.67           C  
ATOM    854  C   LYS   115      37.636  41.510  45.156  1.00 11.91           C  
ATOM    855  O   LYS   115      36.812  40.794  44.645  1.00 12.64           O  
ATOM    856  CB  LYS   115      38.080  43.306  43.468  1.00 15.77           C  
ATOM    857  CG  LYS   115      37.622  44.494  44.326  1.00 17.87           C  
ATOM    858  CD  LYS   115      36.614  45.369  43.606  1.00 20.92           C  
ATOM    859  CE  LYS   115      36.054  46.446  44.569  1.00 25.23           C  
ATOM    860  NZ  LYS   115      37.054  47.515  44.884  1.00 29.82           N  
ATOM    861  N   LEU   116      37.671  41.783  46.456  1.00 12.36           N  
ATOM    862  CA  LEU   116      36.582  41.416  47.379  1.00 12.13           C  
ATOM    863  C   LEU   116      35.464  42.474  47.263  1.00 12.39           C  
ATOM    864  O   LEU   116      35.691  43.665  47.562  1.00 13.14           O  
ATOM    865  CB  LEU   116      37.080  41.375  48.823  1.00 12.34           C  
ATOM    866  CG  LEU   116      37.983  40.230  49.245  1.00 14.20           C  
ATOM    867  CD1 LEU   116      38.622  40.523  50.595  1.00 13.71           C  
ATOM    868  CD2 LEU   116      37.124  38.966  49.220  1.00 13.95           C  
ATOM    869  N   ARG   117      34.290  42.036  46.820  1.00 11.44           N  
ATOM    870  CA  ARG   117      33.100  42.864  46.725  1.00 12.43           C  
ATOM    871  C   ARG   117      32.391  42.841  48.089  1.00 12.06           C  
ATOM    872  O   ARG   117      32.672  42.021  48.922  1.00 11.35           O  
ATOM    873  CB  ARG   117      32.188  42.363  45.626  1.00 12.68           C  
ATOM    874  CG  ARG   117      32.869  42.344  44.242  1.00 13.67           C  
ATOM    875  CD  ARG   117      32.135  41.462  43.266  1.00 15.62           C  
ATOM    876  NE  ARG   117      30.805  41.953  42.947  1.00 17.01           N  
ATOM    877  CZ  ARG   117      30.510  42.761  41.919  1.00 17.54           C  
ATOM    878  NH1 ARG   117      31.435  43.187  41.095  1.00 18.56           N  
ATOM    879  NH2 ARG   117      29.249  43.145  41.730  1.00 19.20           N  
ATOM    880  N   GLY   118      31.448  43.752  48.302  1.00 13.43           N  
ATOM    881  CA  GLY   118      30.753  43.805  49.585  1.00 12.89           C  
ATOM    882  C   GLY   118      31.701  44.100  50.713  1.00 11.76           C  
ATOM    883  O   GLY   118      32.681  44.815  50.534  1.00 12.46           O  
ATOM    884  N   GLU   119      31.383  43.560  51.887  1.00 12.32           N  
ATOM    885  CA  GLU   119      32.226  43.774  53.070  1.00 12.40           C  
ATOM    886  C   GLU   119      33.239  42.653  53.128  1.00 12.48           C  
ATOM    887  O   GLU   119      32.966  41.611  53.696  1.00 10.01           O  
ATOM    888  CB  GLU   119      31.393  43.825  54.366  1.00 13.67           C  
ATOM    889  CG  GLU   119      32.257  44.276  55.533  1.00 13.78           C  
ATOM    890  CD  GLU   119      31.655  44.017  56.893  1.00 13.67           C  
ATOM    891  OE1 GLU   119      30.409  44.001  57.021  1.00 14.27           O  
ATOM    892  OE2 GLU   119      32.457  43.826  57.833  1.00 16.81           O  
ATOM    893  N   ASP   120      34.389  42.870  52.511  1.00 13.10           N  
ATOM    894  CA  ASP   120      35.452  41.865  52.462  1.00 13.44           C  
ATOM    895  C   ASP   120      34.884  40.535  51.985  1.00 12.50           C  
ATOM    896  O   ASP   120      35.243  39.465  52.503  1.00 12.56           O  
ATOM    897  CB  ASP   120      36.181  41.738  53.820  1.00 13.89           C  
ATOM    898  CG  ASP   120      36.865  43.026  54.252  1.00 20.67           C  
ATOM    899  OD1 ASP   120      37.330  43.779  53.377  1.00 23.92           O  
ATOM    900  OD2 ASP   120      36.949  43.273  55.474  1.00 25.46           O  
ATOM    901  N   GLY   121      33.984  40.611  50.988  1.00 11.55           N  
ATOM    902  CA  GLY   121      33.421  39.438  50.331  1.00 11.09           C  
ATOM    903  C   GLY   121      32.013  39.051  50.731  1.00 11.84           C  
ATOM    904  O   GLY   121      31.416  38.188  50.135  1.00 12.72           O  
ATOM    905  N   PHE   122      31.481  39.686  51.763  1.00 10.55           N  
ATOM    906  CA  PHE   122      30.125  39.363  52.246  1.00 11.05           C  
ATOM    907  C   PHE   122      29.060  40.313  51.703  1.00 11.44           C  
ATOM    908  O   PHE   122      29.249  41.526  51.754  1.00 11.01           O  
ATOM    909  CB  PHE   122      30.072  39.495  53.781  1.00 11.49           C  
ATOM    910  CG  PHE   122      28.661  39.437  54.343  1.00 10.55           C  
ATOM    911  CD1 PHE   122      27.960  38.233  54.375  1.00 10.86           C  
ATOM    912  CD2 PHE   122      28.015  40.578  54.862  1.00 11.00           C  
ATOM    913  CE1 PHE   122      26.677  38.147  54.876  1.00 11.97           C  
ATOM    914  CE2 PHE   122      26.732  40.469  55.373  1.00 11.71           C  
ATOM    915  CZ  PHE   122      26.055  39.257  55.354  1.00 10.90           C  
ATOM    916  N   LYS   123      27.964  39.742  51.212  1.00 12.18           N  
ATOM    917  CA  LYS   123      26.765  40.479  50.894  1.00 14.01           C  
ATOM    918  C   LYS   123      25.597  39.824  51.610  1.00 14.43           C  
ATOM    919  O   LYS   123      25.500  38.602  51.652  1.00 12.73           O  
ATOM    920  CB  LYS   123      26.563  40.495  49.393  1.00 16.43           C  
ATOM    921  CG  LYS   123      27.616  41.417  48.767  1.00 18.94           C  
ATOM    922  CD  LYS   123      27.091  42.230  47.675  1.00 21.85           C  
ATOM    923  CE  LYS   123      28.213  43.025  47.001  1.00 22.83           C  
ATOM    924  NZ  LYS   123      28.044  43.099  45.511  1.00 26.23           N  
ATOM    925  N   PRO   124      24.718  40.638  52.227  1.00 15.05           N  
ATOM    926  CA  PRO   124      23.640  40.060  53.039  1.00 15.71           C  
ATOM    927  C   PRO   124      22.471  39.585  52.222  1.00 16.93           C  
ATOM    928  O   PRO   124      22.184  40.135  51.181  1.00 16.72           O  
ATOM    929  CB  PRO   124      23.200  41.255  53.911  1.00 15.62           C  
ATOM    930  CG  PRO   124      23.434  42.433  53.013  1.00 15.82           C  
ATOM    931  CD  PRO   124      24.738  42.104  52.301  1.00 15.65           C  
ATOM    932  N   ASP   125      21.760  38.598  52.743  1.00 19.39           N  
ATOM    933  CA  ASP   125      20.599  38.053  52.036  1.00 22.69           C  
ATOM    934  C   ASP   125      19.461  39.072  51.843  1.00 23.55           C  
ATOM    935  O   ASP   125      18.789  39.068  50.805  1.00 24.59           O  
ATOM    936  CB  ASP   125      20.084  36.808  52.760  1.00 21.94           C  
ATOM    937  CG  ASP   125      19.582  37.105  54.173  1.00 24.27           C  
ATOM    938  OD1 ASP   125      18.448  36.698  54.492  1.00 28.44           O  
ATOM    939  OD2 ASP   125      20.315  37.722  54.958  1.00 24.80           O  
ATOM    940  N   ASN   126      19.285  39.979  52.809  1.00 25.64           N  
ATOM    941  CA  ASN   126      18.164  40.920  52.776  1.00 26.92           C  
ATOM    942  C   ASN   126      18.192  41.866  51.596  1.00 28.26           C  
ATOM    943  O   ASN   126      17.166  42.489  51.283  1.00 29.44           O  
ATOM    944  CB  ASN   126      18.053  41.699  54.102  1.00 27.46           C  
ATOM    945  CG  ASN   126      19.091  42.809  54.249  1.00 27.34           C  
ATOM    946  OD1 ASN   126      20.152  42.784  53.631  1.00 29.16           O  
ATOM    947  ND2 ASN   126      18.777  43.806  55.093  1.00 27.43           N  
ATOM    948  N   ALA   127      19.344  41.967  50.936  1.00 28.77           N  
ATOM    949  CA  ALA   127      19.522  42.820  49.774  1.00 28.90           C  
ATOM    950  C   ALA   127      19.862  42.014  48.503  1.00 29.57           C  
ATOM    951  O   ALA   127      20.195  42.587  47.467  1.00 29.68           O  
ATOM    952  CB  ALA   127      20.603  43.844  50.071  1.00 29.09           C  
ATOM    953  N   GLY   128      19.743  40.690  48.585  1.00 29.83           N  
ATOM    954  CA  GLY   128      20.235  39.799  47.538  1.00 30.20           C  
ATOM    955  C   GLY   128      19.236  39.566  46.425  1.00 30.73           C  
ATOM    956  O   GLY   128      18.022  39.646  46.634  1.00 30.71           O  
ATOM    957  N   GLN   129      19.763  39.288  45.236  1.00 30.79           N  
ATOM    958  CA  GLN   129      18.967  38.857  44.086  1.00 30.91           C  
ATOM    959  C   GLN   129      19.671  37.635  43.504  1.00 29.38           C  
ATOM    960  O   GLN   129      20.780  37.754  42.991  1.00 29.79           O  
ATOM    961  CB  GLN   129      18.857  39.981  43.050  1.00 31.07           C  
ATOM    962  CG  GLN   129      20.187  40.453  42.439  1.00 33.96           C  
ATOM    963  CD  GLN   129      20.140  41.908  41.970  1.00 34.61           C  
ATOM    964  OE1 GLN   129      20.145  42.843  42.787  1.00 40.04           O  
ATOM    965  NE2 GLN   129      20.087  42.107  40.647  1.00 39.07           N  
ATOM    966  N   HIS   130      19.057  36.459  43.623  1.00 28.43           N  
ATOM    967  CA  HIS   130      19.724  35.214  43.196  1.00 28.47           C  
ATOM    968  C   HIS   130      18.742  34.057  43.010  1.00 28.51           C  
ATOM    969  O   HIS   130      17.790  33.926  43.767  1.00 29.20           O  
ATOM    970  CB  HIS   130      20.823  34.817  44.210  1.00 27.89           C  
ATOM    971  CG  HIS   130      21.811  33.827  43.661  1.00 25.84           C  
ATOM    972  ND1 HIS   130      21.604  32.465  43.720  1.00 21.04           N  
ATOM    973  CD2 HIS   130      22.987  34.005  43.012  1.00 23.26           C  
ATOM    974  CE1 HIS   130      22.621  31.845  43.138  1.00 21.92           C  
ATOM    975  NE2 HIS   130      23.473  32.759  42.700  1.00 21.26           N  
ATOM    976  N   SER   131      18.985  33.197  42.014  1.00 28.61           N  
ATOM    977  CA  SER   131      18.184  31.966  41.827  1.00 28.50           C  
ATOM    978  C   SER   131      18.109  31.066  43.064  1.00 28.18           C  
ATOM    979  O   SER   131      17.120  30.348  43.272  1.00 28.59           O  
ATOM    980  CB  SER   131      18.706  31.149  40.617  1.00 28.79           C  
ATOM    981  OG  SER   131      19.884  30.407  40.906  1.00 29.05           O  
ATOM    982  N   ARG   132      19.152  31.106  43.895  1.00 27.57           N  
ATOM    983  CA  ARG   132      19.223  30.309  45.101  1.00 27.32           C  
ATOM    984  C   ARG   132      19.290  31.209  46.339  1.00 27.23           C  
ATOM    985  O   ARG   132      19.839  30.814  47.376  1.00 27.64           O  
ATOM    986  CB  ARG   132      20.446  29.378  45.050  1.00 27.18           C  
ATOM    987  CG  ARG   132      20.415  28.399  43.885  1.00 26.20           C  
ATOM    988  CD  ARG   132      19.482  27.244  44.175  1.00 24.88           C  
ATOM    989  NE  ARG   132      20.176  26.156  44.844  1.00 23.37           N  
ATOM    990  CZ  ARG   132      19.670  24.944  45.062  1.00 24.93           C  
ATOM    991  NH1 ARG   132      18.417  24.660  44.730  1.00 26.06           N  
ATOM    992  NH2 ARG   132      20.412  24.010  45.652  1.00 26.43           N  
ATOM    993  N   LEU   133      18.719  32.412  46.236  1.00 26.84           N  
ATOM    994  CA  LEU   133      18.580  33.298  47.401  1.00 26.45           C  
ATOM    995  C   LEU   133      17.960  32.553  48.574  1.00 26.19           C  
ATOM    996  O   LEU   133      18.358  32.765  49.729  1.00 26.89           O  
ATOM    997  CB  LEU   133      17.727  34.514  47.041  1.00 26.34           C  
ATOM    998  CG  LEU   133      17.597  35.641  48.071  1.00 27.38           C  
ATOM    999  CD1 LEU   133      18.951  36.225  48.445  1.00 29.45           C  
ATOM   1000  CD2 LEU   133      16.691  36.726  47.481  1.00 26.95           C  
ATOM   1001  N   ALA   134      17.009  31.648  48.293  1.00 25.49           N  
ATOM   1002  CA  ALA   134      16.398  30.816  49.362  1.00 24.48           C  
ATOM   1003  C   ALA   134      17.409  30.004  50.186  1.00 23.99           C  
ATOM   1004  O   ALA   134      17.227  29.804  51.399  1.00 24.52           O  
ATOM   1005  CB  ALA   134      15.336  29.881  48.780  1.00 25.40           C  
ATOM   1006  N   TYR   135      18.476  29.549  49.519  1.00 22.93           N  
ATOM   1007  CA  TYR   135      19.593  28.819  50.162  1.00 21.87           C  
ATOM   1008  C   TYR   135      20.329  29.741  51.130  1.00 21.07           C  
ATOM   1009  O   TYR   135      20.623  29.353  52.258  1.00 18.90           O  
ATOM   1010  CB  TYR   135      20.550  28.319  49.071  1.00 21.51           C  
ATOM   1011  CG  TYR   135      21.656  27.349  49.460  1.00 21.15           C  
ATOM   1012  CD1 TYR   135      21.556  25.987  49.153  1.00 21.88           C  
ATOM   1013  CD2 TYR   135      22.845  27.800  50.029  1.00 17.37           C  
ATOM   1014  CE1 TYR   135      22.583  25.089  49.464  1.00 20.02           C  
ATOM   1015  CE2 TYR   135      23.843  26.924  50.369  1.00 18.29           C  
ATOM   1016  CZ  TYR   135      23.729  25.566  50.067  1.00 19.69           C  
ATOM   1017  OH  TYR   135      24.747  24.677  50.333  1.00 20.15           O  
ATOM   1018  N   ALA   136      20.596  30.959  50.672  1.00 20.77           N  
ATOM   1019  CA  ALA   136      21.219  31.997  51.507  1.00 21.45           C  
ATOM   1020  C   ALA   136      20.300  32.384  52.667  1.00 21.78           C  
ATOM   1021  O   ALA   136      20.732  32.438  53.819  1.00 22.05           O  
ATOM   1022  CB  ALA   136      21.589  33.239  50.654  1.00 20.65           C  
ATOM   1023  N   GLN   137      19.022  32.629  52.366  1.00 22.68           N  
ATOM   1024  CA  GLN   137      18.037  32.950  53.427  1.00 23.69           C  
ATOM   1025  C   GLN   137      17.932  31.879  54.501  1.00 23.78           C  
ATOM   1026  O   GLN   137      17.739  32.186  55.705  1.00 24.50           O  
ATOM   1027  CB  GLN   137      16.668  33.255  52.816  1.00 24.37           C  
ATOM   1028  CG  GLN   137      16.692  34.514  51.976  1.00 26.01           C  
ATOM   1029  CD  GLN   137      15.419  34.739  51.183  1.00 26.99           C  
ATOM   1030  OE1 GLN   137      14.712  33.784  50.815  1.00 31.66           O  
ATOM   1031  NE2 GLN   137      15.133  36.007  50.886  1.00 29.66           N  
ATOM   1032  N   ALA   138      18.087  30.613  54.095  1.00 23.37           N  
ATOM   1033  CA  ALA   138      18.008  29.491  55.029  1.00 22.88           C  
ATOM   1034  C   ALA   138      19.255  29.321  55.883  1.00 23.01           C  
ATOM   1035  O   ALA   138      19.296  28.424  56.719  1.00 24.27           O  
ATOM   1036  CB  ALA   138      17.715  28.214  54.274  1.00 23.00           C  
ATOM   1037  N   GLY   139      20.277  30.156  55.659  1.00 21.52           N  
ATOM   1038  CA  GLY   139      21.526  30.087  56.407  1.00 20.68           C  
ATOM   1039  C   GLY   139      22.671  29.351  55.717  1.00 19.15           C  
ATOM   1040  O   GLY   139      23.701  29.064  56.323  1.00 19.84           O  
ATOM   1041  N   GLY   140      22.490  29.038  54.445  1.00 17.06           N  
ATOM   1042  CA  GLY   140      23.596  28.574  53.619  1.00 14.44           C  
ATOM   1043  C   GLY   140      24.316  29.783  53.038  1.00 13.98           C  
ATOM   1044  O   GLY   140      23.814  30.913  53.092  1.00 13.51           O  
ATOM   1045  N   ILE   141      25.452  29.517  52.409  1.00 11.86           N  
ATOM   1046  CA  ILE   141      26.285  30.567  51.775  1.00 11.73           C  
ATOM   1047  C   ILE   141      26.312  30.303  50.275  1.00 11.74           C  
ATOM   1048  O   ILE   141      26.716  29.214  49.858  1.00 11.27           O  
ATOM   1049  CB  ILE   141      27.719  30.480  52.316  1.00 10.06           C  
ATOM   1050  CG1 ILE   141      27.745  30.698  53.842  1.00 10.14           C  
ATOM   1051  CG2 ILE   141      28.675  31.491  51.606  1.00 11.36           C  
ATOM   1052  CD1 ILE   141      29.091  30.394  54.452  1.00 11.64           C  
ATOM   1053  N   VAL   142      25.838  31.261  49.491  1.00 11.92           N  
ATOM   1054  CA  VAL   142      25.941  31.192  48.031  1.00 11.72           C  
ATOM   1055  C   VAL   142      27.237  31.880  47.677  1.00 11.25           C  
ATOM   1056  O   VAL   142      27.338  33.107  47.740  1.00 11.47           O  
ATOM   1057  CB  VAL   142      24.723  31.863  47.349  1.00 12.90           C  
ATOM   1058  CG1 VAL   142      24.920  31.996  45.814  1.00 14.95           C  
ATOM   1059  CG2 VAL   142      23.467  31.097  47.692  1.00 12.82           C  
ATOM   1060  N   PHE   143      28.249  31.074  47.318  1.00 10.70           N  
ATOM   1061  CA  PHE   143      29.600  31.595  47.062  1.00 10.59           C  
ATOM   1062  C   PHE   143      29.840  31.752  45.576  1.00 10.88           C  
ATOM   1063  O   PHE   143      29.739  30.769  44.838  1.00 10.76           O  
ATOM   1064  CB  PHE   143      30.646  30.652  47.707  1.00  9.96           C  
ATOM   1065  CG  PHE   143      32.059  31.178  47.731  1.00 11.16           C  
ATOM   1066  CD1 PHE   143      32.335  32.519  47.821  1.00 10.30           C  
ATOM   1067  CD2 PHE   143      33.129  30.291  47.714  1.00 11.80           C  
ATOM   1068  CE1 PHE   143      33.655  32.983  47.880  1.00 11.13           C  
ATOM   1069  CE2 PHE   143      34.409  30.752  47.772  1.00 12.98           C  
ATOM   1070  CZ  PHE   143      34.686  32.080  47.844  1.00 11.88           C  
ATOM   1071  N   GLU   144      30.166  32.977  45.175  1.00 11.14           N  
ATOM   1072  CA  GLU   144      30.456  33.332  43.792  1.00 12.14           C  
ATOM   1073  C   GLU   144      31.850  33.912  43.707  1.00 10.26           C  
ATOM   1074  O   GLU   144      32.057  35.117  43.700  1.00 10.17           O  
ATOM   1075  CB  GLU   144      29.418  34.322  43.281  1.00 12.77           C  
ATOM   1076  CG  GLU   144      28.017  33.774  43.343  1.00 16.17           C  
ATOM   1077  CD  GLU   144      27.026  34.699  42.708  1.00 19.30           C  
ATOM   1078  OE1 GLU   144      26.913  34.716  41.475  1.00 29.93           O  
ATOM   1079  OE2 GLU   144      26.370  35.420  43.451  1.00 29.21           O  
ATOM   1080  N   PRO   145      32.840  33.039  43.618  1.00  9.49           N  
ATOM   1081  CA  PRO   145      34.217  33.545  43.602  1.00  9.81           C  
ATOM   1082  C   PRO   145      34.604  34.412  42.398  1.00  9.40           C  
ATOM   1083  O   PRO   145      35.524  35.210  42.537  1.00 10.34           O  
ATOM   1084  CB  PRO   145      35.065  32.278  43.635  1.00 10.32           C  
ATOM   1085  CG  PRO   145      34.202  31.181  43.863  1.00 11.66           C  
ATOM   1086  CD  PRO   145      32.769  31.577  43.652  1.00 10.79           C  
ATOM   1087  N   PHE   146      33.943  34.256  41.256  1.00  9.86           N  
ATOM   1088  CA  PHE   146      34.297  35.057  40.079  1.00  9.87           C  
ATOM   1089  C   PHE   146      33.132  35.109  39.091  1.00 10.29           C  
ATOM   1090  O   PHE   146      32.198  34.345  39.214  1.00  9.40           O  
ATOM   1091  CB  PHE   146      35.575  34.523  39.383  1.00 10.34           C  
ATOM   1092  CG  PHE   146      35.392  33.179  38.739  1.00 10.11           C  
ATOM   1093  CD1 PHE   146      35.091  33.051  37.406  1.00 13.33           C  
ATOM   1094  CD2 PHE   146      35.471  32.032  39.496  1.00 11.06           C  
ATOM   1095  CE1 PHE   146      34.888  31.792  36.835  1.00 13.37           C  
ATOM   1096  CE2 PHE   146      35.305  30.778  38.936  1.00 13.64           C  
ATOM   1097  CZ  PHE   146      34.980  30.670  37.608  1.00 13.72           C  
ATOM   1098  N   PHE   147      33.271  36.021  38.136  1.00 10.75           N  
ATOM   1099  CA  PHE   147      32.300  36.213  37.075  1.00 10.66           C  
ATOM   1100  C   PHE   147      32.735  35.353  35.906  1.00 11.10           C  
ATOM   1101  O   PHE   147      33.801  35.577  35.332  1.00 12.05           O  
ATOM   1102  CB  PHE   147      32.290  37.678  36.637  1.00 11.63           C  
ATOM   1103  CG  PHE   147      31.543  38.597  37.556  1.00 12.86           C  
ATOM   1104  CD1 PHE   147      30.334  39.150  37.173  1.00 14.43           C  
ATOM   1105  CD2 PHE   147      32.058  38.912  38.808  1.00 13.83           C  
ATOM   1106  CE1 PHE   147      29.649  39.984  38.035  1.00 15.29           C  
ATOM   1107  CE2 PHE   147      31.362  39.749  39.671  1.00 13.84           C  
ATOM   1108  CZ  PHE   147      30.163  40.287  39.268  1.00 12.68           C  
ATOM   1109  N   ILE   148      31.882  34.402  35.522  1.00 11.82           N  
ATOM   1110  CA  ILE   148      32.143  33.557  34.383  1.00 12.18           C  
ATOM   1111  C   ILE   148      32.204  34.381  33.108  1.00 12.34           C  
ATOM   1112  O   ILE   148      32.849  33.971  32.130  1.00 13.41           O  
ATOM   1113  CB  ILE   148      31.105  32.432  34.263  1.00 12.56           C  
ATOM   1114  CG1 ILE   148      31.624  31.314  33.377  1.00 13.43           C  
ATOM   1115  CG2 ILE   148      29.725  32.965  33.785  1.00 11.32           C  
ATOM   1116  CD1 ILE   148      30.673  30.135  33.279  1.00 13.97           C  
ATOM   1117  N   SER   149      31.522  35.521  33.151  1.00 12.19           N  
ATOM   1118  CA  SER   149      31.501  36.479  32.034  1.00 13.19           C  
ATOM   1119  C   SER   149      32.796  37.291  31.880  1.00 14.14           C  
ATOM   1120  O   SER   149      33.007  37.953  30.858  1.00 16.10           O  
ATOM   1121  CB  SER   149      30.272  37.374  32.181  1.00 14.13           C  
ATOM   1122  OG  SER   149      30.209  37.899  33.472  1.00 13.74           O  
ATOM   1123  N   ASN   150      33.683  37.275  32.882  1.00 13.78           N  
ATOM   1124  CA  ASN   150      34.969  37.909  32.793  1.00 12.57           C  
ATOM   1125  C   ASN   150      36.001  36.969  32.168  1.00 13.36           C  
ATOM   1126  O   ASN   150      36.466  36.054  32.829  1.00 12.09           O  
ATOM   1127  CB  ASN   150      35.430  38.376  34.183  1.00 12.67           C  
ATOM   1128  CG  ASN   150      36.603  39.312  34.107  1.00 12.09           C  
ATOM   1129  OD1 ASN   150      37.701  38.948  33.662  1.00 14.19           O  
ATOM   1130  ND2 ASN   150      36.378  40.560  34.483  1.00 13.36           N  
ATOM   1131  N   ASP   151      36.320  37.150  30.883  1.00 13.04           N  
ATOM   1132  CA  ASP   151      37.183  36.197  30.208  1.00 12.64           C  
ATOM   1133  C   ASP   151      38.552  36.003  30.882  1.00 12.47           C  
ATOM   1134  O   ASP   151      39.086  34.867  30.942  1.00 12.50           O  
ATOM   1135  CB  ASP   151      37.435  36.605  28.744  1.00 13.64           C  
ATOM   1136  CG  ASP   151      36.207  36.564  27.899  1.00 16.47           C  
ATOM   1137  OD1 ASP   151      35.150  36.036  28.304  1.00 17.47           O  
ATOM   1138  OD2 ASP   151      36.318  37.060  26.756  1.00 20.25           O  
ATOM   1139  N   THR   152      39.149  37.099  31.340  1.00 11.43           N  
ATOM   1140  CA  THR   152      40.463  37.098  31.991  1.00 12.57           C  
ATOM   1141  C   THR   152      40.399  36.349  33.324  1.00 12.00           C  
ATOM   1142  O   THR   152      41.233  35.460  33.588  1.00 12.54           O  
ATOM   1143  CB  THR   152      40.993  38.547  32.211  1.00 13.21           C  
ATOM   1144  OG1 THR   152      41.269  39.126  30.918  1.00 16.15           O  
ATOM   1145  CG2 THR   152      42.281  38.546  33.053  1.00 11.92           C  
ATOM   1146  N   ASP   153      39.412  36.680  34.166  1.00 11.15           N  
ATOM   1147  CA  ASP   153      39.284  35.968  35.467  1.00 11.43           C  
ATOM   1148  C   ASP   153      38.971  34.468  35.281  1.00 10.32           C  
ATOM   1149  O   ASP   153      39.483  33.612  35.974  1.00 10.53           O  
ATOM   1150  CB  ASP   153      38.170  36.570  36.313  1.00 10.81           C  
ATOM   1151  CG  ASP   153      38.412  38.019  36.664  1.00 11.25           C  
ATOM   1152  OD1 ASP   153      39.558  38.501  36.554  1.00 10.17           O  
ATOM   1153  OD2 ASP   153      37.407  38.670  37.036  1.00 13.92           O  
ATOM   1154  N   LEU   154      38.124  34.167  34.302  1.00  9.86           N  
ATOM   1155  CA  LEU   154      37.803  32.799  33.971  1.00 10.29           C  
ATOM   1156  C   LEU   154      39.055  32.031  33.519  1.00 10.39           C  
ATOM   1157  O   LEU   154      39.273  30.860  33.903  1.00 10.20           O  
ATOM   1158  CB  LEU   154      36.710  32.749  32.884  1.00 11.22           C  
ATOM   1159  CG  LEU   154      36.384  31.367  32.304  1.00 10.39           C  
ATOM   1160  CD1 LEU   154      35.954  30.309  33.330  1.00 11.09           C  
ATOM   1161  CD2 LEU   154      35.368  31.469  31.189  1.00 10.45           C  
ATOM   1162  N   ALA   155      39.882  32.654  32.697  1.00  8.80           N  
ATOM   1163  CA  ALA   155      41.159  32.007  32.299  1.00  8.74           C  
ATOM   1164  C   ALA   155      42.027  31.725  33.516  1.00  9.15           C  
ATOM   1165  O   ALA   155      42.658  30.667  33.573  1.00 11.09           O  
ATOM   1166  CB  ALA   155      41.934  32.882  31.300  1.00  9.16           C  
ATOM   1167  N   LEU   156      42.100  32.667  34.440  1.00  9.15           N  
ATOM   1168  CA  LEU   156      42.914  32.471  35.659  1.00 10.15           C  
ATOM   1169  C   LEU   156      42.379  31.323  36.459  1.00  9.96           C  
ATOM   1170  O   LEU   156      43.163  30.483  36.929  1.00 10.10           O  
ATOM   1171  CB  LEU   156      42.944  33.753  36.503  1.00  9.65           C  
ATOM   1172  CG  LEU   156      43.945  33.654  37.664  1.00 10.20           C  
ATOM   1173  CD1 LEU   156      45.356  33.589  37.129  1.00 16.89           C  
ATOM   1174  CD2 LEU   156      43.762  34.893  38.514  1.00 14.21           C  
ATOM   1175  N   PHE   157      41.055  31.260  36.599  1.00  9.04           N  
ATOM   1176  CA  PHE   157      40.405  30.177  37.339  1.00  9.74           C  
ATOM   1177  C   PHE   157      40.764  28.851  36.683  1.00 10.11           C  
ATOM   1178  O   PHE   157      41.138  27.929  37.356  1.00 10.81           O  
ATOM   1179  CB  PHE   157      38.901  30.292  37.423  1.00  9.62           C  
ATOM   1180  CG  PHE   157      38.251  29.133  38.137  1.00 10.55           C  
ATOM   1181  CD1 PHE   157      38.308  29.015  39.513  1.00 11.92           C  
ATOM   1182  CD2 PHE   157      37.647  28.101  37.429  1.00  9.97           C  
ATOM   1183  CE1 PHE   157      37.726  27.918  40.168  1.00 10.72           C  
ATOM   1184  CE2 PHE   157      37.078  27.017  38.109  1.00 11.60           C  
ATOM   1185  CZ  PHE   157      37.143  26.947  39.486  1.00 10.73           C  
ATOM   1186  N   LYS   158      40.585  28.767  35.366  1.00 10.38           N  
ATOM   1187  CA  LYS   158      40.815  27.498  34.674  1.00 11.37           C  
ATOM   1188  C   LYS   158      42.242  26.989  34.822  1.00 10.97           C  
ATOM   1189  O   LYS   158      42.445  25.775  34.889  1.00 13.84           O  
ATOM   1190  CB  LYS   158      40.421  27.626  33.184  1.00 11.18           C  
ATOM   1191  CG  LYS   158      38.949  27.787  32.943  1.00 12.13           C  
ATOM   1192  CD  LYS   158      38.564  28.251  31.534  1.00 14.64           C  
ATOM   1193  CE  LYS   158      38.764  27.242  30.502  1.00 19.00           C  
ATOM   1194  NZ  LYS   158      38.247  27.734  29.161  1.00 15.13           N  
ATOM   1195  N   THR   159      43.230  27.875  34.830  1.00 10.84           N  
ATOM   1196  CA  THR   159      44.662  27.509  34.971  1.00 10.73           C  
ATOM   1197  C   THR   159      45.118  27.266  36.397  1.00 10.33           C  
ATOM   1198  O   THR   159      46.177  26.700  36.570  1.00  9.78           O  
ATOM   1199  CB  THR   159      45.582  28.570  34.357  1.00 11.71           C  
ATOM   1200  OG1 THR   159      45.468  29.790  35.112  1.00 13.97           O  
ATOM   1201  CG2 THR   159      45.232  28.777  32.877  1.00 11.09           C  
ATOM   1202  N   THR   160      44.322  27.683  37.397  1.00 10.99           N  
ATOM   1203  CA  THR   160      44.710  27.587  38.823  1.00 11.25           C  
ATOM   1204  C   THR   160      43.586  26.994  39.689  1.00 12.02           C  
ATOM   1205  O   THR   160      43.597  27.132  40.883  1.00 12.05           O  
ATOM   1206  CB  THR   160      45.138  28.951  39.374  1.00 13.42           C  
ATOM   1207  OG1 THR   160      45.947  29.597  38.383  1.00 17.50           O  
ATOM   1208  CG2 THR   160      45.968  28.813  40.656  1.00 14.63           C  
ATOM   1209  N   LYS   161      42.688  26.272  39.057  1.00 12.76           N  
ATOM   1210  CA  LYS   161      41.505  25.685  39.693  1.00 13.44           C  
ATOM   1211  C   LYS   161      41.851  24.870  40.939  1.00 12.27           C  
ATOM   1212  O   LYS   161      41.264  25.072  42.015  1.00 11.29           O  
ATOM   1213  CB  LYS   161      40.854  24.764  38.641  1.00 14.03           C  
ATOM   1214  CG  LYS   161      39.642  24.060  39.077  1.00 15.23           C  
ATOM   1215  CD  LYS   161      38.921  23.536  37.881  1.00 15.58           C  
ATOM   1216  CE  LYS   161      39.605  22.309  37.330  1.00 14.37           C  
ATOM   1217  NZ  LYS   161      38.945  21.934  36.086  1.00 16.84           N  
ATOM   1218  N   TRP   162      42.821  23.983  40.820  1.00 11.61           N  
ATOM   1219  CA  TRP   162      43.110  23.083  41.938  1.00 11.17           C  
ATOM   1220  C   TRP   162      43.730  23.842  43.080  1.00 11.12           C  
ATOM   1221  O   TRP   162      43.465  23.556  44.253  1.00 11.03           O  
ATOM   1222  CB  TRP   162      43.978  21.874  41.477  1.00 11.38           C  
ATOM   1223  CG  TRP   162      43.248  20.983  40.566  1.00 10.36           C  
ATOM   1224  CD1 TRP   162      43.051  21.154  39.230  1.00 13.84           C  
ATOM   1225  CD2 TRP   162      42.567  19.774  40.913  1.00 11.58           C  
ATOM   1226  NE1 TRP   162      42.274  20.146  38.725  1.00 13.49           N  
ATOM   1227  CE2 TRP   162      41.960  19.284  39.736  1.00 12.58           C  
ATOM   1228  CE3 TRP   162      42.395  19.063  42.109  1.00 11.66           C  
ATOM   1229  CZ2 TRP   162      41.212  18.116  39.717  1.00 13.19           C  
ATOM   1230  CZ3 TRP   162      41.637  17.908  42.078  1.00 13.93           C  
ATOM   1231  CH2 TRP   162      41.058  17.449  40.896  1.00 13.38           C  
ATOM   1232  N   GLY   163      44.552  24.839  42.757  1.00 10.01           N  
ATOM   1233  CA  GLY   163      45.170  25.680  43.765  1.00 10.68           C  
ATOM   1234  C   GLY   163      44.180  26.587  44.483  1.00 10.55           C  
ATOM   1235  O   GLY   163      44.289  26.814  45.708  1.00 10.58           O  
ATOM   1236  N   ILE   164      43.234  27.147  43.710  1.00  9.92           N  
ATOM   1237  CA  ILE   164      42.183  27.989  44.283  1.00 10.03           C  
ATOM   1238  C   ILE   164      41.311  27.147  45.238  1.00 10.08           C  
ATOM   1239  O   ILE   164      41.024  27.573  46.365  1.00 11.10           O  
ATOM   1240  CB  ILE   164      41.337  28.716  43.167  1.00  9.58           C  
ATOM   1241  CG1 ILE   164      42.199  29.739  42.415  1.00  9.34           C  
ATOM   1242  CG2 ILE   164      40.038  29.323  43.746  1.00 10.81           C  
ATOM   1243  CD1 ILE   164      41.555  30.251  41.154  1.00 10.81           C  
ATOM   1244  N   CYS   165      40.882  25.976  44.787  1.00  9.04           N  
ATOM   1245  CA  CYS   165      40.026  25.084  45.597  1.00 10.34           C  
ATOM   1246  C   CYS   165      40.782  24.558  46.805  1.00 10.63           C  
ATOM   1247  O   CYS   165      40.199  24.465  47.878  1.00 11.03           O  
ATOM   1248  CB  CYS   165      39.416  23.987  44.816  1.00 10.63           C  
ATOM   1249  SG  CYS   165      38.306  24.548  43.496  1.00 15.09           S  
ATOM   1250  N   ARG   166      42.091  24.317  46.674  1.00 11.01           N  
ATOM   1251  CA  ARG   166      42.918  23.971  47.853  1.00 11.25           C  
ATOM   1252  C   ARG   166      42.976  25.108  48.859  1.00 12.11           C  
ATOM   1253  O   ARG   166      42.852  24.876  50.066  1.00 11.58           O  
ATOM   1254  CB  ARG   166      44.339  23.562  47.447  1.00 12.52           C  
ATOM   1255  CG  ARG   166      45.165  23.084  48.655  1.00 12.44           C  
ATOM   1256  CD  ARG   166      46.473  22.497  48.246  1.00 16.26           C  
ATOM   1257  NE  ARG   166      46.292  21.333  47.401  1.00 18.64           N  
ATOM   1258  CZ  ARG   166      46.069  20.087  47.809  1.00 22.11           C  
ATOM   1259  NH1 ARG   166      45.980  19.793  49.088  1.00 22.62           N  
ATOM   1260  NH2 ARG   166      45.920  19.124  46.912  1.00 25.06           N  
ATOM   1261  N   ALA   167      43.151  26.349  48.386  1.00 10.43           N  
ATOM   1262  CA  ALA   167      43.113  27.554  49.262  1.00 10.62           C  
ATOM   1263  C   ALA   167      41.776  27.599  50.037  1.00 10.68           C  
ATOM   1264  O   ALA   167      41.742  27.891  51.242  1.00 11.02           O  
ATOM   1265  CB  ALA   167      43.322  28.876  48.442  1.00 11.76           C  
ATOM   1266  N   ILE   168      40.673  27.303  49.346  1.00  9.56           N  
ATOM   1267  CA  ILE   168      39.352  27.346  49.989  1.00  9.76           C  
ATOM   1268  C   ILE   168      39.268  26.266  51.091  1.00  9.74           C  
ATOM   1269  O   ILE   168      38.907  26.545  52.244  1.00 10.47           O  
ATOM   1270  CB  ILE   168      38.211  27.173  48.939  1.00  9.83           C  
ATOM   1271  CG1 ILE   168      38.123  28.403  48.024  1.00  8.70           C  
ATOM   1272  CG2 ILE   168      36.830  26.893  49.641  1.00  9.27           C  
ATOM   1273  CD1 ILE   168      37.239  28.184  46.740  1.00  8.33           C  
ATOM   1274  N   ALA   169      39.628  25.048  50.733  1.00  9.68           N  
ATOM   1275  CA  ALA   169      39.623  23.908  51.658  1.00  9.82           C  
ATOM   1276  C   ALA   169      40.516  24.233  52.865  1.00 10.17           C  
ATOM   1277  O   ALA   169      40.133  24.014  54.021  1.00 11.00           O  
ATOM   1278  CB  ALA   169      40.089  22.637  50.920  1.00  9.64           C  
ATOM   1279  N   ASP   170      41.734  24.688  52.607  1.00 10.41           N  
ATOM   1280  CA  ASP   170      42.673  24.981  53.701  1.00 11.26           C  
ATOM   1281  C   ASP   170      42.122  26.048  54.674  1.00 11.37           C  
ATOM   1282  O   ASP   170      42.348  25.974  55.911  1.00 11.14           O  
ATOM   1283  CB  ASP   170      44.022  25.451  53.156  1.00 11.26           C  
ATOM   1284  CG  ASP   170      44.862  24.335  52.554  1.00 11.32           C  
ATOM   1285  OD1 ASP   170      44.616  23.120  52.808  1.00 14.21           O  
ATOM   1286  OD2 ASP   170      45.784  24.699  51.797  1.00 15.87           O  
ATOM   1287  N   ALA   171      41.447  27.057  54.118  1.00 11.14           N  
ATOM   1288  CA  ALA   171      40.858  28.134  54.913  1.00 11.60           C  
ATOM   1289  C   ALA   171      39.706  27.621  55.786  1.00 11.59           C  
ATOM   1290  O   ALA   171      39.528  28.081  56.925  1.00 11.40           O  
ATOM   1291  CB  ALA   171      40.411  29.300  54.006  1.00 12.23           C  
ATOM   1292  N   ILE   172      38.894  26.707  55.248  1.00 11.81           N  
ATOM   1293  CA  ILE   172      37.804  26.110  55.995  1.00 11.90           C  
ATOM   1294  C   ILE   172      38.393  25.323  57.148  1.00 12.39           C  
ATOM   1295  O   ILE   172      38.024  25.544  58.276  1.00 12.77           O  
ATOM   1296  CB  ILE   172      36.883  25.220  55.102  1.00 11.32           C  
ATOM   1297  CG1 ILE   172      36.120  26.043  54.078  1.00 11.58           C  
ATOM   1298  CG2 ILE   172      35.883  24.421  55.937  1.00 11.73           C  
ATOM   1299  CD1 ILE   172      35.451  25.219  52.981  1.00  9.94           C  
ATOM   1300  N   ALA   173      39.365  24.472  56.859  1.00 12.78           N  
ATOM   1301  CA  ALA   173      40.004  23.665  57.904  1.00 13.62           C  
ATOM   1302  C   ALA   173      40.633  24.545  58.963  1.00 14.01           C  
ATOM   1303  O   ALA   173      40.459  24.309  60.155  1.00 14.80           O  
ATOM   1304  CB  ALA   173      41.028  22.722  57.304  1.00 14.44           C  
ATOM   1305  N   MET   174      41.328  25.583  58.547  1.00 14.81           N  
ATOM   1306  CA  MET   174      41.970  26.494  59.528  1.00 15.25           C  
ATOM   1307  C   MET   174      40.939  27.153  60.458  1.00 15.41           C  
ATOM   1308  O   MET   174      41.141  27.257  61.690  1.00 15.70           O  
ATOM   1309  CB  MET   174      42.806  27.538  58.805  1.00 16.99           C  
ATOM   1310  CG  MET   174      43.336  28.657  59.653  1.00 20.15           C  
ATOM   1311  SD  MET   174      44.853  28.016  60.694  1.00 42.79          SE  
ATOM   1312  CE  MET   174      46.172  28.147  59.270  1.00 33.95           C  
ATOM   1313  N   GLU   175      39.819  27.581  59.889  1.00 14.50           N  
ATOM   1314  CA  GLU   175      38.800  28.274  60.680  1.00 14.57           C  
ATOM   1315  C   GLU   175      38.181  27.335  61.708  1.00 14.44           C  
ATOM   1316  O   GLU   175      37.775  27.763  62.779  1.00 16.78           O  
ATOM   1317  CB  GLU   175      37.752  28.858  59.740  1.00 14.29           C  
ATOM   1318  CG  GLU   175      36.609  29.583  60.385  1.00 14.38           C  
ATOM   1319  CD  GLU   175      36.999  30.893  61.054  1.00 15.83           C  
ATOM   1320  OE1 GLU   175      38.170  31.324  60.985  1.00 15.40           O  
ATOM   1321  OE2 GLU   175      36.081  31.514  61.658  1.00 17.95           O  
ATOM   1322  N   LEU   176      38.113  26.059  61.362  1.00 14.98           N  
ATOM   1323  CA  LEU   176      37.601  24.998  62.235  1.00 16.17           C  
ATOM   1324  C   LEU   176      38.666  24.512  63.222  1.00 16.94           C  
ATOM   1325  O   LEU   176      38.357  23.768  64.159  1.00 18.58           O  
ATOM   1326  CB  LEU   176      37.132  23.817  61.405  1.00 16.00           C  
ATOM   1327  CG  LEU   176      35.946  24.130  60.493  1.00 16.60           C  
ATOM   1328  CD1 LEU   176      35.611  22.940  59.622  1.00 17.54           C  
ATOM   1329  CD2 LEU   176      34.749  24.559  61.324  1.00 16.01           C  
ATOM   1330  N   GLY   177      39.911  24.924  63.014  1.00 17.90           N  
ATOM   1331  CA  GLY   177      41.047  24.479  63.820  1.00 17.93           C  
ATOM   1332  C   GLY   177      41.475  23.052  63.559  1.00 18.38           C  
ATOM   1333  O   GLY   177      42.044  22.398  64.452  1.00 20.04           O  
ATOM   1334  N   ALA   178      41.218  22.548  62.346  1.00 17.99           N  
ATOM   1335  CA  ALA   178      41.591  21.193  61.959  1.00 18.35           C  
ATOM   1336  C   ALA   178      42.983  21.171  61.386  1.00 20.02           C  
ATOM   1337  O   ALA   178      43.282  21.877  60.409  1.00 18.20           O  
ATOM   1338  CB  ALA   178      40.611  20.623  60.923  1.00 19.25           C  
ATOM   1339  N   ALA   179      43.834  20.336  61.975  1.00 20.88           N  
ATOM   1340  CA  ALA   179      45.182  20.157  61.467  1.00 22.69           C  
ATOM   1341  C   ALA   179      45.183  19.087  60.382  1.00 22.31           C  
ATOM   1342  O   ALA   179      44.307  18.207  60.367  1.00 22.87           O  
ATOM   1343  CB  ALA   179      46.114  19.772  62.600  1.00 21.96           C  
ATOM   1344  N   LYS   180      46.149  19.168  59.470  1.00 23.78           N  
ATOM   1345  CA  LYS   180      46.295  18.130  58.447  1.00 25.26           C  
ATOM   1346  C   LYS   180      46.585  16.775  59.088  1.00 26.88           C  
ATOM   1347  O   LYS   180      47.250  16.719  60.129  1.00 27.84           O  
ATOM   1348  CB  LYS   180      47.382  18.479  57.429  1.00 25.80           C  
ATOM   1349  CG  LYS   180      47.061  19.695  56.566  1.00 26.16           C  
ATOM   1350  CD  LYS   180      47.889  19.696  55.305  1.00 26.94           C  
ATOM   1351  CE  LYS   180      47.945  21.080  54.691  1.00 27.05           C  
ATOM   1352  NZ  LYS   180      48.368  21.003  53.286  1.00 28.72           N  
ATOM   1353  N   VAL   181      46.044  15.708  58.484  1.00 27.38           N  
ATOM   1354  CA  VAL   181      46.266  14.325  58.916  1.00 28.40           C  
ATOM   1355  C   VAL   181      47.119  13.602  57.869  1.00 29.75           C  
ATOM   1356  O   VAL   181      48.108  14.167  57.352  1.00 31.82           O  
ATOM   1357  CB  VAL   181      44.946  13.547  59.124  1.00 28.47           C  
ATOM   1358  CG1 VAL   181      44.050  14.231  60.169  1.00 29.95           C  
ATOM   1359  CG2 VAL   181      44.192  13.374  57.794  1.00 28.65           C  
END
