
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1523),  selected  104 , name 2d1u_A
# Molecule2: number of CA atoms   84 (  623),  selected   84 , name T0424_94_177.pdb
# PARAMETERS: 2d1u_A.T0424_94_177.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L      94           -
LGA    -       -      A      95           -
LGA    -       -      G      96           -
LGA    -       -      F      97           -
LGA    -       -      L      98           -
LGA    -       -      V      99           -
LGA    -       -      D     100           -
LGA    -       -      C     101           -
LGA    A     1_A      S     102          1.303
LGA    Q     2_A      A     103          4.325
LGA    V     3_A      P     104          1.437
LGA    N     4_A      Q     105          0.728
LGA    I     5_A      L     106          0.941
LGA    A     6_A      N     107          1.486
LGA    P     7_A      V     108          2.277
LGA    G     8_A      K     109          2.317
LGA    -       -      G     110           -
LGA    S     9_A      M     111          1.347
LGA    L    10_A      T     112          1.733
LGA    -       -      V     113           -
LGA    D    11_A      L     114          4.021
LGA    K    12_A      D     115          3.400
LGA    A    13_A      A     116          1.925
LGA    L    14_A      A     117          2.477
LGA    N    15_A      K     118          2.550
LGA    Q    16_A      K     119          2.050
LGA    Y    17_A      L     120          1.170
LGA    A    18_A      A     121          2.152
LGA    A    19_A      A     122          1.375
LGA    H    20_A      P     123          3.814
LGA    S    21_A      W     124          4.644
LGA    G    22_A      P     125          4.212
LGA    -       -      Q     126           -
LGA    F    23_A      I     127          2.430
LGA    -       -      K     128           -
LGA    T    24_A      A     129          3.363
LGA    L    25_A      V     130          2.295
LGA    S    26_A      V     131          1.537
LGA    V    27_A      L     132          0.836
LGA    D    28_A      K     133          4.069
LGA    A    29_A      A     134           #
LGA    S    30_A      E     135          5.224
LGA    L    31_A      N     136          1.045
LGA    T    32_A      N     137          0.609
LGA    R    33_A      -       -           -
LGA    G    34_A      P     138          5.323
LGA    K    35_A      A     139          2.613
LGA    Q    36_A      L     140          2.353
LGA    S    37_A      G     141          4.383
LGA    N    38_A      K     142          4.158
LGA    G    39_A      I     143          4.393
LGA    L    40_A      D     144           #
LGA    H    41_A      I     145          3.274
LGA    G    42_A      E     146          3.375
LGA    D    43_A      P     147          3.912
LGA    -       -      G     148           -
LGA    Y    44_A      E     149          2.608
LGA    D    45_A      T     150          2.596
LGA    V    46_A      V     151          3.091
LGA    E    47_A      W     152          1.817
LGA    S    48_A      Q     153          1.679
LGA    G    49_A      A     154          1.890
LGA    L    50_A      L     155          0.896
LGA    Q    51_A      T     156          0.627
LGA    Q    52_A      X     157          2.029
LGA    L    53_A      I     158          1.764
LGA    L    54_A      A     159          1.915
LGA    D    55_A      N     160          3.101
LGA    G    56_A      S     161          1.823
LGA    S    57_A      V     162          3.934
LGA    G    58_A      G     163          3.959
LGA    L    59_A      L     164          3.115
LGA    Q    60_A      X     165          3.664
LGA    V    61_A      P     166          3.256
LGA    K    62_A      W     167          3.268
LGA    P    63_A      L     168          2.402
LGA    L    64_A      E     169          1.753
LGA    G    65_A      P     170          2.082
LGA    N    66_A      D     171          3.192
LGA    N    67_A      G     172          2.122
LGA    S    68_A      T     173          1.565
LGA    W    69_A      L     174          2.730
LGA    T    70_A      V     175          1.917
LGA    L    71_A      V     176          2.983
LGA    E    72_A      G     177          3.244
LGA    P    73_A      -       -           -
LGA    A    74_A      -       -           -
LGA    P    75_A      -       -           -
LGA    A    76_A      -       -           -
LGA    P    77_A      -       -           -
LGA    K    78_A      -       -           -
LGA    E    79_A      -       -           -
LGA    D    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    L    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    V    84_A      -       -           -
LGA    V    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    W    88_A      -       -           -
LGA    L    89_A      -       -           -
LGA    G    90_A      -       -           -
LGA    D    91_A      -       -           -
LGA    A    92_A      -       -           -
LGA    R    93_A      -       -           -
LGA    E    94_A      -       -           -
LGA    N    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    L    97_A      -       -           -
LGA    E    98_A      -       -           -
LGA    H    99_A      -       -           -
LGA    H   100_A      -       -           -
LGA    H   101_A      -       -           -
LGA    H   102_A      -       -           -
LGA    H   103_A      -       -           -
LGA    H   104_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104   84    5.0     69    2.82    10.14     50.858     2.359

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.821452 * X  +   0.563604 * Y  +   0.086986 * Z  + -45.421040
  Y_new =   0.558382 * X  +  -0.763915 * Y  +  -0.323487 * Z  +  65.193527
  Z_new =  -0.115869 * X  +   0.314300 * Y  +  -0.942226 * Z  + 136.485931 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.819627   -0.321966  [ DEG:   161.5527    -18.4473 ]
  Theta =   0.116129    3.025463  [ DEG:     6.6537    173.3463 ]
  Phi   =   0.597005   -2.544587  [ DEG:    34.2059   -145.7941 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d1u_A                                        
REMARK     2: T0424_94_177.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d1u_A.T0424_94_177.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104   84   5.0   69   2.82   10.14  50.858
REMARK  ---------------------------------------------------------- 
MOLECULE 2d1u_A
HEADER    METAL TRANSPORT                         01-SEP-05   2D1U              
TITLE     SOLUTION STRCUTURE OF THE PERIPLASMIC SIGNALING DOMAIN OF             
TITLE    2 FECA FROM ESCHERICHIA COLI                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IRON(III) DICITRATE TRANSPORT PROTEIN FECA;                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PERIPLASMIC SIGNALING DOMAIN;                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: FECA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET30A                                    
KEYWDS    FECA, SURFACE SIGNALING, IRON-UPTAKE                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.GARCIA-HERRERO,H.J.VOGEL                                            
REVDAT   1   27-DEC-05 2D1U    0                                                
JRNL        AUTH   A.GARCIA-HERRERO,H.J.VOGEL                                   
JRNL        TITL   NUCLEAR MAGNETIC RESONANCE SOLUTION STRUCTURE OF             
JRNL        TITL 2 THE PERIPLASMIC SIGNALLING DOMAIN OF THE                     
JRNL        TITL 3 TONB-DEPENDENT OUTER MEMBRANE TRANSPORTER FECA               
JRNL        TITL 4 FROM ESCHERICHIA COLI                                        
JRNL        REF    MOL.MICROBIOL.                V.  58  1226 2005              
JRNL        REFN   ASTM MOMIEE  UK ISSN 0950-382X                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2D1U A    1    96  UNP    P13036   FECA_ECOLI      34    129             
SEQRES   1 A  104  ALA GLN VAL ASN ILE ALA PRO GLY SER LEU ASP LYS ALA          
SEQRES   2 A  104  LEU ASN GLN TYR ALA ALA HIS SER GLY PHE THR LEU SER          
SEQRES   3 A  104  VAL ASP ALA SER LEU THR ARG GLY LYS GLN SER ASN GLY          
SEQRES   4 A  104  LEU HIS GLY ASP TYR ASP VAL GLU SER GLY LEU GLN GLN          
SEQRES   5 A  104  LEU LEU ASP GLY SER GLY LEU GLN VAL LYS PRO LEU GLY          
SEQRES   6 A  104  ASN ASN SER TRP THR LEU GLU PRO ALA PRO ALA PRO LYS          
SEQRES   7 A  104  GLU ASP ALA LEU THR VAL VAL GLY ASP TRP LEU GLY ASP          
SEQRES   8 A  104  ALA ARG GLU ASN ASP LEU GLU HIS HIS HIS HIS HIS HIS          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1     -44.329  65.936 136.332  1.00  0.00           N  
ATOM      2  CA  ALA A   1     -43.810  66.764 137.412  1.00  0.00           C  
ATOM      3  C   ALA A   1     -44.523  68.112 137.463  1.00  0.00           C  
ATOM      4  O   ALA A   1     -44.312  68.968 136.603  1.00  0.00           O  
ATOM      5  CB  ALA A   1     -42.311  66.965 137.251  1.00  0.00           C  
ATOM      6  HA  ALA A   1     -43.981  66.244 138.344  1.00  0.00           H  
ATOM      7  HB1 ALA A   1     -42.086  68.022 137.259  1.00  0.00           H  
ATOM      8  HB2 ALA A   1     -41.793  66.481 138.066  1.00  0.00           H  
ATOM      9  HB3 ALA A   1     -41.990  66.535 136.314  1.00  0.00           H  
ATOM     10  H1  ALA A   1     -43.863  65.927 135.471  1.00  0.00           H  
ATOM     11  N   GLN A   2     -45.369  68.291 138.472  1.00  0.00           N  
ATOM     12  CA  GLN A   2     -46.114  69.535 138.631  1.00  0.00           C  
ATOM     13  C   GLN A   2     -45.171  70.732 138.687  1.00  0.00           C  
ATOM     14  O   GLN A   2     -44.303  70.811 139.557  1.00  0.00           O  
ATOM     15  CB  GLN A   2     -46.968  69.483 139.899  1.00  0.00           C  
ATOM     16  CG  GLN A   2     -47.714  70.777 140.183  1.00  0.00           C  
ATOM     17  CD  GLN A   2     -48.736  71.108 139.114  1.00  0.00           C  
ATOM     18  OE1 GLN A   2     -49.480  70.239 138.659  1.00  0.00           O  
ATOM     19  NE2 GLN A   2     -48.778  72.371 138.705  1.00  0.00           N  
ATOM     20  H   GLN A   2     -45.495  67.571 139.124  1.00  0.00           H  
ATOM     21  HA  GLN A   2     -46.763  69.644 137.775  1.00  0.00           H  
ATOM     22  HB2 GLN A   2     -47.692  68.689 139.799  1.00  0.00           H  
ATOM     23  HB3 GLN A   2     -46.327  69.271 140.742  1.00  0.00           H  
ATOM     24  HG2 GLN A   2     -48.225  70.683 141.131  1.00  0.00           H  
ATOM     25  HG3 GLN A   2     -47.000  71.585 140.240  1.00  0.00           H  
ATOM     26 HE21 GLN A   2     -48.154  73.009 139.111  1.00  0.00           H  
ATOM     27 HE22 GLN A   2     -49.429  72.613 138.015  1.00  0.00           H  
ATOM     28  N   VAL A   3     -45.345  71.662 137.753  1.00  0.00           N  
ATOM     29  CA  VAL A   3     -44.510  72.855 137.697  1.00  0.00           C  
ATOM     30  C   VAL A   3     -45.353  74.106 137.479  1.00  0.00           C  
ATOM     31  O   VAL A   3     -45.999  74.260 136.442  1.00  0.00           O  
ATOM     32  CB  VAL A   3     -43.462  72.754 136.573  1.00  0.00           C  
ATOM     33  CG1 VAL A   3     -42.611  74.012 136.521  1.00  0.00           C  
ATOM     34  CG2 VAL A   3     -42.592  71.520 136.765  1.00  0.00           C  
ATOM     35  H   VAL A   3     -46.054  71.541 137.087  1.00  0.00           H  
ATOM     36  HA  VAL A   3     -43.989  72.943 138.639  1.00  0.00           H  
ATOM     37  HB  VAL A   3     -43.982  72.658 135.631  1.00  0.00           H  
ATOM     38 HG11 VAL A   3     -42.126  74.158 137.475  1.00  0.00           H  
ATOM     39 HG12 VAL A   3     -41.863  73.912 135.748  1.00  0.00           H  
ATOM     40 HG13 VAL A   3     -43.240  74.863 136.304  1.00  0.00           H  
ATOM     41 HG21 VAL A   3     -42.842  71.048 137.704  1.00  0.00           H  
ATOM     42 HG22 VAL A   3     -42.769  70.825 135.955  1.00  0.00           H  
ATOM     43 HG23 VAL A   3     -41.552  71.809 136.771  1.00  0.00           H  
ATOM     44  N   ASN A   4     -45.343  74.998 138.464  1.00  0.00           N  
ATOM     45  CA  ASN A   4     -46.107  76.238 138.381  1.00  0.00           C  
ATOM     46  C   ASN A   4     -45.183  77.451 138.421  1.00  0.00           C  
ATOM     47  O   ASN A   4     -44.545  77.724 139.439  1.00  0.00           O  
ATOM     48  CB  ASN A   4     -47.119  76.315 139.525  1.00  0.00           C  
ATOM     49  CG  ASN A   4     -46.534  75.857 140.846  1.00  0.00           C  
ATOM     50  OD1 ASN A   4     -46.087  76.671 141.655  1.00  0.00           O  
ATOM     51  ND2 ASN A   4     -46.534  74.549 141.073  1.00  0.00           N  
ATOM     52  H   ASN A   4     -44.810  74.819 139.266  1.00  0.00           H  
ATOM     53  HA  ASN A   4     -46.639  76.236 137.441  1.00  0.00           H  
ATOM     54  HB2 ASN A   4     -47.451  77.337 139.636  1.00  0.00           H  
ATOM     55  HB3 ASN A   4     -47.967  75.689 139.291  1.00  0.00           H  
ATOM     56 HD21 ASN A   4     -46.907  73.960 140.383  1.00  0.00           H  
ATOM     57 HD22 ASN A   4     -46.162  74.225 141.920  1.00  0.00           H  
ATOM     58  N   ILE A   5     -45.117  78.175 137.310  1.00  0.00           N  
ATOM     59  CA  ILE A   5     -44.272  79.359 137.219  1.00  0.00           C  
ATOM     60  C   ILE A   5     -45.084  80.583 136.809  1.00  0.00           C  
ATOM     61  O   ILE A   5     -45.932  80.508 135.921  1.00  0.00           O  
ATOM     62  CB  ILE A   5     -43.124  79.156 136.212  1.00  0.00           C  
ATOM     63  CG1 ILE A   5     -42.279  77.943 136.606  1.00  0.00           C  
ATOM     64  CG2 ILE A   5     -42.260  80.407 136.134  1.00  0.00           C  
ATOM     65  CD1 ILE A   5     -41.534  77.324 135.444  1.00  0.00           C  
ATOM     66  H   ILE A   5     -45.648  77.906 136.531  1.00  0.00           H  
ATOM     67  HA  ILE A   5     -43.841  79.537 138.194  1.00  0.00           H  
ATOM     68  HB  ILE A   5     -43.556  78.985 135.238  1.00  0.00           H  
ATOM     69 HG12 ILE A   5     -41.552  78.242 137.344  1.00  0.00           H  
ATOM     70 HG13 ILE A   5     -42.924  77.187 137.029  1.00  0.00           H  
ATOM     71 HG21 ILE A   5     -42.755  81.149 135.525  1.00  0.00           H  
ATOM     72 HG22 ILE A   5     -42.110  80.802 137.128  1.00  0.00           H  
ATOM     73 HG23 ILE A   5     -41.307  80.159 135.696  1.00  0.00           H  
ATOM     74 HD11 ILE A   5     -40.889  78.063 134.994  1.00  0.00           H  
ATOM     75 HD12 ILE A   5     -40.940  76.495 135.798  1.00  0.00           H  
ATOM     76 HD13 ILE A   5     -42.243  76.970 134.709  1.00  0.00           H  
ATOM     77  N   ALA A   6     -44.815  81.710 137.459  1.00  0.00           N  
ATOM     78  CA  ALA A   6     -45.517  82.951 137.159  1.00  0.00           C  
ATOM     79  C   ALA A   6     -44.825  83.717 136.037  1.00  0.00           C  
ATOM     80  O   ALA A   6     -43.611  83.924 136.050  1.00  0.00           O  
ATOM     81  CB  ALA A   6     -45.616  83.817 138.407  1.00  0.00           C  
ATOM     82  H   ALA A   6     -44.127  81.707 138.157  1.00  0.00           H  
ATOM     83  HA  ALA A   6     -46.520  82.700 136.845  1.00  0.00           H  
ATOM     84  HB1 ALA A   6     -46.621  84.205 138.496  1.00  0.00           H  
ATOM     85  HB2 ALA A   6     -45.382  83.222 139.277  1.00  0.00           H  
ATOM     86  HB3 ALA A   6     -44.918  84.637 138.333  1.00  0.00           H  
ATOM     87  N   PRO A   7     -45.612  84.147 135.040  1.00  0.00           N  
ATOM     88  CA  PRO A   7     -45.095  84.896 133.890  1.00  0.00           C  
ATOM     89  C   PRO A   7     -44.642  86.301 134.270  1.00  0.00           C  
ATOM     90  O   PRO A   7     -44.462  86.609 135.448  1.00  0.00           O  
ATOM     91  CB  PRO A   7     -46.293  84.959 132.940  1.00  0.00           C  
ATOM     92  CG  PRO A   7     -47.486  84.832 133.825  1.00  0.00           C  
ATOM     93  CD  PRO A   7     -47.066  83.936 134.958  1.00  0.00           C  
ATOM     94  HA  PRO A   7     -44.281  84.374 133.410  1.00  0.00           H  
ATOM     95  HB2 PRO A   7     -46.290  85.903 132.414  1.00  0.00           H  
ATOM     96  HB3 PRO A   7     -46.240  84.146 132.232  1.00  0.00           H  
ATOM     97  HG2 PRO A   7     -47.769  85.803 134.200  1.00  0.00           H  
ATOM     98  HG3 PRO A   7     -48.303  84.386 133.277  1.00  0.00           H  
ATOM     99  HD2 PRO A   7     -47.552  84.235 135.875  1.00  0.00           H  
ATOM    100  HD3 PRO A   7     -47.294  82.905 134.727  1.00  0.00           H  
ATOM    101  N   GLY A   8     -44.459  87.151 133.265  1.00  0.00           N  
ATOM    102  CA  GLY A   8     -44.029  88.515 133.514  1.00  0.00           C  
ATOM    103  C   GLY A   8     -42.556  88.721 133.224  1.00  0.00           C  
ATOM    104  O   GLY A   8     -41.999  89.778 133.520  1.00  0.00           O  
ATOM    105  H   GLY A   8     -44.617  86.851 132.345  1.00  0.00           H  
ATOM    106  HA2 GLY A   8     -44.605  89.182 132.891  1.00  0.00           H  
ATOM    107  HA3 GLY A   8     -44.216  88.755 134.551  1.00  0.00           H  
ATOM    108  N   SER A   9     -41.921  87.706 132.644  1.00  0.00           N  
ATOM    109  CA  SER A   9     -40.502  87.779 132.318  1.00  0.00           C  
ATOM    110  C   SER A   9     -40.023  86.477 131.684  1.00  0.00           C  
ATOM    111  O   SER A   9     -40.076  85.414 132.305  1.00  0.00           O  
ATOM    112  CB  SER A   9     -39.684  88.079 133.575  1.00  0.00           C  
ATOM    113  OG  SER A   9     -39.105  89.371 133.511  1.00  0.00           O  
ATOM    114  H   SER A   9     -42.420  86.890 132.431  1.00  0.00           H  
ATOM    115  HA  SER A   9     -40.365  88.582 131.609  1.00  0.00           H  
ATOM    116  HB2 SER A   9     -40.326  88.028 134.440  1.00  0.00           H  
ATOM    117  HB3 SER A   9     -38.892  87.348 133.669  1.00  0.00           H  
ATOM    118  HG  SER A   9     -38.158  89.306 133.653  1.00  0.00           H  
ATOM    119  N   LEU A  10     -39.554  86.566 130.445  1.00  0.00           N  
ATOM    120  CA  LEU A  10     -39.066  85.395 129.725  1.00  0.00           C  
ATOM    121  C   LEU A  10     -37.812  84.833 130.388  1.00  0.00           C  
ATOM    122  O   LEU A  10     -37.711  83.628 130.627  1.00  0.00           O  
ATOM    123  CB  LEU A  10     -38.767  85.755 128.269  1.00  0.00           C  
ATOM    124  CG  LEU A  10     -38.618  84.579 127.303  1.00  0.00           C  
ATOM    125  CD1 LEU A  10     -38.780  85.044 125.864  1.00  0.00           C  
ATOM    126  CD2 LEU A  10     -37.270  83.899 127.496  1.00  0.00           C  
ATOM    127  H   LEU A  10     -39.538  87.439 130.002  1.00  0.00           H  
ATOM    128  HA  LEU A  10     -39.841  84.643 129.749  1.00  0.00           H  
ATOM    129  HB2 LEU A  10     -39.573  86.377 127.910  1.00  0.00           H  
ATOM    130  HB3 LEU A  10     -37.844  86.319 128.250  1.00  0.00           H  
ATOM    131  HG  LEU A  10     -39.393  83.852 127.508  1.00  0.00           H  
ATOM    132 HD11 LEU A  10     -37.835  85.413 125.496  1.00  0.00           H  
ATOM    133 HD12 LEU A  10     -39.517  85.834 125.824  1.00  0.00           H  
ATOM    134 HD13 LEU A  10     -39.108  84.216 125.254  1.00  0.00           H  
ATOM    135 HD21 LEU A  10     -36.676  84.469 128.194  1.00  0.00           H  
ATOM    136 HD22 LEU A  10     -36.755  83.844 126.547  1.00  0.00           H  
ATOM    137 HD23 LEU A  10     -37.423  82.901 127.881  1.00  0.00           H  
ATOM    138  N   ASP A  11     -36.862  85.712 130.686  1.00  0.00           N  
ATOM    139  CA  ASP A  11     -35.616  85.303 131.325  1.00  0.00           C  
ATOM    140  C   ASP A  11     -35.892  84.570 132.635  1.00  0.00           C  
ATOM    141  O   ASP A  11     -35.268  83.552 132.933  1.00  0.00           O  
ATOM    142  CB  ASP A  11     -34.728  86.521 131.586  1.00  0.00           C  
ATOM    143  CG  ASP A  11     -33.694  86.263 132.664  1.00  0.00           C  
ATOM    144  OD1 ASP A  11     -32.827  85.388 132.457  1.00  0.00           O  
ATOM    145  OD2 ASP A  11     -33.749  86.938 133.712  1.00  0.00           O  
ATOM    146  H   ASP A  11     -37.001  86.658 130.470  1.00  0.00           H  
ATOM    147  HA  ASP A  11     -35.103  84.632 130.653  1.00  0.00           H  
ATOM    148  HB2 ASP A  11     -34.214  86.785 130.674  1.00  0.00           H  
ATOM    149  HB3 ASP A  11     -35.348  87.349 131.897  1.00  0.00           H  
ATOM    150  N   LYS A  12     -36.832  85.095 133.414  1.00  0.00           N  
ATOM    151  CA  LYS A  12     -37.192  84.493 134.692  1.00  0.00           C  
ATOM    152  C   LYS A  12     -37.840  83.127 134.486  1.00  0.00           C  
ATOM    153  O   LYS A  12     -37.376  82.122 135.025  1.00  0.00           O  
ATOM    154  CB  LYS A  12     -38.146  85.409 135.461  1.00  0.00           C  
ATOM    155  CG  LYS A  12     -37.482  86.665 135.996  1.00  0.00           C  
ATOM    156  CD  LYS A  12     -37.931  86.972 137.416  1.00  0.00           C  
ATOM    157  CE  LYS A  12     -37.369  85.966 138.408  1.00  0.00           C  
ATOM    158  NZ  LYS A  12     -37.727  86.310 139.811  1.00  0.00           N  
ATOM    159  H   LYS A  12     -37.295  85.910 133.122  1.00  0.00           H  
ATOM    160  HA  LYS A  12     -36.287  84.366 135.266  1.00  0.00           H  
ATOM    161  HB2 LYS A  12     -38.951  85.705 134.803  1.00  0.00           H  
ATOM    162  HB3 LYS A  12     -38.558  84.861 136.296  1.00  0.00           H  
ATOM    163  HG2 LYS A  12     -36.412  86.527 135.992  1.00  0.00           H  
ATOM    164  HG3 LYS A  12     -37.742  87.500 135.359  1.00  0.00           H  
ATOM    165  HD2 LYS A  12     -37.588  87.959 137.687  1.00  0.00           H  
ATOM    166  HD3 LYS A  12     -39.011  86.940 137.457  1.00  0.00           H  
ATOM    167  HE2 LYS A  12     -37.763  84.990 138.174  1.00  0.00           H  
ATOM    168  HE3 LYS A  12     -36.292  85.951 138.314  1.00  0.00           H  
ATOM    169  HZ1 LYS A  12     -38.491  85.690 140.147  1.00  0.00           H  
ATOM    170  HZ2 LYS A  12     -38.049  87.298 139.866  1.00  0.00           H  
ATOM    171  HZ3 LYS A  12     -36.901  86.192 140.431  1.00  0.00           H  
ATOM    172  N   ALA A  13     -38.911  83.096 133.700  1.00  0.00           N  
ATOM    173  CA  ALA A  13     -39.619  81.853 133.420  1.00  0.00           C  
ATOM    174  C   ALA A  13     -38.657  80.770 132.946  1.00  0.00           C  
ATOM    175  O   ALA A  13     -38.910  79.577 133.127  1.00  0.00           O  
ATOM    176  CB  ALA A  13     -40.706  82.087 132.382  1.00  0.00           C  
ATOM    177  H   ALA A  13     -39.232  83.931 133.298  1.00  0.00           H  
ATOM    178  HA  ALA A  13     -40.093  81.526 134.335  1.00  0.00           H  
ATOM    179  HB1 ALA A  13     -41.314  81.199 132.291  1.00  0.00           H  
ATOM    180  HB2 ALA A  13     -41.325  82.917 132.690  1.00  0.00           H  
ATOM    181  HB3 ALA A  13     -40.252  82.312 131.429  1.00  0.00           H  
ATOM    182  N   LEU A  14     -37.554  81.189 132.337  1.00  0.00           N  
ATOM    183  CA  LEU A  14     -36.554  80.253 131.836  1.00  0.00           C  
ATOM    184  C   LEU A  14     -35.809  79.583 132.987  1.00  0.00           C  
ATOM    185  O   LEU A  14     -35.748  78.357 133.070  1.00  0.00           O  
ATOM    186  CB  LEU A  14     -35.560  80.976 130.924  1.00  0.00           C  
ATOM    187  CG  LEU A  14     -34.142  80.408 130.891  1.00  0.00           C  
ATOM    188  CD1 LEU A  14     -34.151  78.977 130.376  1.00  0.00           C  
ATOM    189  CD2 LEU A  14     -33.238  81.279 130.032  1.00  0.00           C  
ATOM    190  H   LEU A  14     -37.407  82.150 132.221  1.00  0.00           H  
ATOM    191  HA  LEU A  14     -37.066  79.494 131.265  1.00  0.00           H  
ATOM    192  HB2 LEU A  14     -35.952  80.945 129.919  1.00  0.00           H  
ATOM    193  HB3 LEU A  14     -35.498  82.004 131.254  1.00  0.00           H  
ATOM    194  HG  LEU A  14     -33.742  80.398 131.896  1.00  0.00           H  
ATOM    195 HD11 LEU A  14     -34.474  78.313 131.165  1.00  0.00           H  
ATOM    196 HD12 LEU A  14     -33.157  78.702 130.060  1.00  0.00           H  
ATOM    197 HD13 LEU A  14     -34.831  78.900 129.540  1.00  0.00           H  
ATOM    198 HD21 LEU A  14     -32.295  80.776 129.877  1.00  0.00           H  
ATOM    199 HD22 LEU A  14     -33.063  82.221 130.533  1.00  0.00           H  
ATOM    200 HD23 LEU A  14     -33.711  81.459 129.079  1.00  0.00           H  
ATOM    201  N   ASN A  15     -35.245  80.397 133.874  1.00  0.00           N  
ATOM    202  CA  ASN A  15     -34.507  79.884 135.022  1.00  0.00           C  
ATOM    203  C   ASN A  15     -35.421  79.081 135.941  1.00  0.00           C  
ATOM    204  O   ASN A  15     -34.986  78.125 136.584  1.00  0.00           O  
ATOM    205  CB  ASN A  15     -33.866  81.035 135.799  1.00  0.00           C  
ATOM    206  CG  ASN A  15     -34.634  81.379 137.061  1.00  0.00           C  
ATOM    207  OD1 ASN A  15     -34.374  80.826 138.129  1.00  0.00           O  
ATOM    208  ND2 ASN A  15     -35.588  82.297 136.941  1.00  0.00           N  
ATOM    209  H   ASN A  15     -35.328  81.366 133.753  1.00  0.00           H  
ATOM    210  HA  ASN A  15     -33.728  79.235 134.651  1.00  0.00           H  
ATOM    211  HB2 ASN A  15     -32.860  80.757 136.078  1.00  0.00           H  
ATOM    212  HB3 ASN A  15     -33.831  81.912 135.170  1.00  0.00           H  
ATOM    213 HD21 ASN A  15     -35.739  82.695 136.058  1.00  0.00           H  
ATOM    214 HD22 ASN A  15     -36.099  82.538 137.740  1.00  0.00           H  
ATOM    215  N   GLN A  16     -36.689  79.475 135.998  1.00  0.00           N  
ATOM    216  CA  GLN A  16     -37.664  78.792 136.840  1.00  0.00           C  
ATOM    217  C   GLN A  16     -37.806  77.329 136.431  1.00  0.00           C  
ATOM    218  O   GLN A  16     -37.621  76.426 137.247  1.00  0.00           O  
ATOM    219  CB  GLN A  16     -39.022  79.492 136.755  1.00  0.00           C  
ATOM    220  CG  GLN A  16     -38.971  80.965 137.123  1.00  0.00           C  
ATOM    221  CD  GLN A  16     -39.515  81.239 138.511  1.00  0.00           C  
ATOM    222  OE1 GLN A  16     -39.787  80.314 139.278  1.00  0.00           O  
ATOM    223  NE2 GLN A  16     -39.677  82.514 138.844  1.00  0.00           N  
ATOM    224  H   GLN A  16     -36.975  80.243 135.462  1.00  0.00           H  
ATOM    225  HA  GLN A  16     -37.311  78.835 137.859  1.00  0.00           H  
ATOM    226  HB2 GLN A  16     -39.394  79.408 135.744  1.00  0.00           H  
ATOM    227  HB3 GLN A  16     -39.710  78.999 137.425  1.00  0.00           H  
ATOM    228  HG2 GLN A  16     -37.945  81.298 137.084  1.00  0.00           H  
ATOM    229  HG3 GLN A  16     -39.556  81.523 136.407  1.00  0.00           H  
ATOM    230 HE21 GLN A  16     -39.440  83.198 138.182  1.00  0.00           H  
ATOM    231 HE22 GLN A  16     -40.027  82.720 139.734  1.00  0.00           H  
ATOM    232  N   TYR A  17     -38.136  77.104 135.164  1.00  0.00           N  
ATOM    233  CA  TYR A  17     -38.307  75.751 134.648  1.00  0.00           C  
ATOM    234  C   TYR A  17     -36.957  75.057 134.486  1.00  0.00           C  
ATOM    235  O   TYR A  17     -36.832  73.857 134.727  1.00  0.00           O  
ATOM    236  CB  TYR A  17     -39.041  75.782 133.307  1.00  0.00           C  
ATOM    237  CG  TYR A  17     -38.116  75.780 132.110  1.00  0.00           C  
ATOM    238  CD1 TYR A  17     -37.690  74.588 131.539  1.00  0.00           C  
ATOM    239  CD2 TYR A  17     -37.671  76.972 131.550  1.00  0.00           C  
ATOM    240  CE1 TYR A  17     -36.845  74.582 130.446  1.00  0.00           C  
ATOM    241  CE2 TYR A  17     -36.828  76.975 130.456  1.00  0.00           C  
ATOM    242  CZ  TYR A  17     -36.417  75.777 129.908  1.00  0.00           C  
ATOM    243  OH  TYR A  17     -35.576  75.775 128.818  1.00  0.00           O  
ATOM    244  H   TYR A  17     -38.271  77.865 134.563  1.00  0.00           H  
ATOM    245  HA  TYR A  17     -38.901  75.196 135.360  1.00  0.00           H  
ATOM    246  HB2 TYR A  17     -39.679  74.916 133.234  1.00  0.00           H  
ATOM    247  HB3 TYR A  17     -39.647  76.676 133.257  1.00  0.00           H  
ATOM    248  HD1 TYR A  17     -38.028  73.653 131.963  1.00  0.00           H  
ATOM    249  HD2 TYR A  17     -37.995  77.908 131.982  1.00  0.00           H  
ATOM    250  HE1 TYR A  17     -36.524  73.645 130.016  1.00  0.00           H  
ATOM    251  HE2 TYR A  17     -36.491  77.911 130.035  1.00  0.00           H  
ATOM    252  HH  TYR A  17     -35.817  75.056 128.230  1.00  0.00           H  
ATOM    253  N   ALA A  18     -35.951  75.821 134.075  1.00  0.00           N  
ATOM    254  CA  ALA A  18     -34.611  75.283 133.883  1.00  0.00           C  
ATOM    255  C   ALA A  18     -34.058  74.707 135.183  1.00  0.00           C  
ATOM    256  O   ALA A  18     -33.299  73.739 135.171  1.00  0.00           O  
ATOM    257  CB  ALA A  18     -33.681  76.360 133.343  1.00  0.00           C  
ATOM    258  H   ALA A  18     -36.114  76.772 133.900  1.00  0.00           H  
ATOM    259  HA  ALA A  18     -34.672  74.492 133.148  1.00  0.00           H  
ATOM    260  HB1 ALA A  18     -32.737  75.913 133.066  1.00  0.00           H  
ATOM    261  HB2 ALA A  18     -34.130  76.821 132.476  1.00  0.00           H  
ATOM    262  HB3 ALA A  18     -33.517  77.107 134.104  1.00  0.00           H  
ATOM    263  N   ALA A  19     -34.445  75.309 136.303  1.00  0.00           N  
ATOM    264  CA  ALA A  19     -33.989  74.856 137.611  1.00  0.00           C  
ATOM    265  C   ALA A  19     -34.754  73.616 138.059  1.00  0.00           C  
ATOM    266  O   ALA A  19     -34.227  72.780 138.793  1.00  0.00           O  
ATOM    267  CB  ALA A  19     -34.138  75.970 138.637  1.00  0.00           C  
ATOM    268  H   ALA A  19     -35.052  76.077 136.247  1.00  0.00           H  
ATOM    269  HA  ALA A  19     -32.939  74.610 137.532  1.00  0.00           H  
ATOM    270  HB1 ALA A  19     -35.172  76.279 138.684  1.00  0.00           H  
ATOM    271  HB2 ALA A  19     -33.824  75.611 139.605  1.00  0.00           H  
ATOM    272  HB3 ALA A  19     -33.523  76.809 138.347  1.00  0.00           H  
ATOM    273  N   HIS A  20     -36.002  73.502 137.613  1.00  0.00           N  
ATOM    274  CA  HIS A  20     -36.840  72.362 137.969  1.00  0.00           C  
ATOM    275  C   HIS A  20     -36.450  71.129 137.160  1.00  0.00           C  
ATOM    276  O   HIS A  20     -36.649  69.998 137.602  1.00  0.00           O  
ATOM    277  CB  HIS A  20     -38.314  72.695 137.736  1.00  0.00           C  
ATOM    278  CG  HIS A  20     -38.928  71.933 136.602  1.00  0.00           C  
ATOM    279  ND1 HIS A  20     -39.343  70.621 136.715  1.00  0.00           N  
ATOM    280  CD2 HIS A  20     -39.199  72.303 135.328  1.00  0.00           C  
ATOM    281  CE1 HIS A  20     -39.840  70.219 135.559  1.00  0.00           C  
ATOM    282  NE2 HIS A  20     -39.765  71.221 134.701  1.00  0.00           N  
ATOM    283  H   HIS A  20     -36.366  74.200 137.030  1.00  0.00           H  
ATOM    284  HA  HIS A  20     -36.688  72.154 139.016  1.00  0.00           H  
ATOM    285  HB2 HIS A  20     -38.873  72.466 138.631  1.00  0.00           H  
ATOM    286  HB3 HIS A  20     -38.409  73.749 137.517  1.00  0.00           H  
ATOM    287  HD1 HIS A  20     -39.281  70.068 137.521  1.00  0.00           H  
ATOM    288  HD2 HIS A  20     -39.005  73.270 134.888  1.00  0.00           H  
ATOM    289  HE1 HIS A  20     -40.242  69.239 135.350  1.00  0.00           H  
ATOM    290  N   SER A  21     -35.896  71.355 135.974  1.00  0.00           N  
ATOM    291  CA  SER A  21     -35.483  70.261 135.102  1.00  0.00           C  
ATOM    292  C   SER A  21     -34.097  69.752 135.488  1.00  0.00           C  
ATOM    293  O   SER A  21     -33.913  68.568 135.765  1.00  0.00           O  
ATOM    294  CB  SER A  21     -35.483  70.716 133.641  1.00  0.00           C  
ATOM    295  OG  SER A  21     -36.801  70.976 133.188  1.00  0.00           O  
ATOM    296  H   SER A  21     -35.764  72.280 135.677  1.00  0.00           H  
ATOM    297  HA  SER A  21     -36.194  69.457 135.219  1.00  0.00           H  
ATOM    298  HB2 SER A  21     -34.900  71.620 133.549  1.00  0.00           H  
ATOM    299  HB3 SER A  21     -35.049  69.942 133.026  1.00  0.00           H  
ATOM    300  HG  SER A  21     -37.417  70.404 133.653  1.00  0.00           H  
ATOM    301  N   GLY A  22     -33.125  70.658 135.504  1.00  0.00           N  
ATOM    302  CA  GLY A  22     -31.767  70.284 135.857  1.00  0.00           C  
ATOM    303  C   GLY A  22     -30.869  70.149 134.643  1.00  0.00           C  
ATOM    304  O   GLY A  22     -29.863  69.441 134.682  1.00  0.00           O  
ATOM    305  H   GLY A  22     -33.330  71.589 135.274  1.00  0.00           H  
ATOM    306  HA2 GLY A  22     -31.357  71.036 136.514  1.00  0.00           H  
ATOM    307  HA3 GLY A  22     -31.791  69.338 136.379  1.00  0.00           H  
ATOM    308  N   PHE A  23     -31.233  70.829 133.561  1.00  0.00           N  
ATOM    309  CA  PHE A  23     -30.455  70.780 132.329  1.00  0.00           C  
ATOM    310  C   PHE A  23     -30.001  72.177 131.916  1.00  0.00           C  
ATOM    311  O   PHE A  23     -30.433  73.177 132.489  1.00  0.00           O  
ATOM    312  CB  PHE A  23     -31.277  70.146 131.205  1.00  0.00           C  
ATOM    313  CG  PHE A  23     -32.194  71.114 130.514  1.00  0.00           C  
ATOM    314  CD1 PHE A  23     -33.266  71.676 131.189  1.00  0.00           C  
ATOM    315  CD2 PHE A  23     -31.984  71.464 129.190  1.00  0.00           C  
ATOM    316  CE1 PHE A  23     -34.113  72.566 130.556  1.00  0.00           C  
ATOM    317  CE2 PHE A  23     -32.827  72.354 128.552  1.00  0.00           C  
ATOM    318  CZ  PHE A  23     -33.892  72.907 129.236  1.00  0.00           C  
ATOM    319  H   PHE A  23     -32.047  71.376 133.591  1.00  0.00           H  
ATOM    320  HA  PHE A  23     -29.583  70.170 132.513  1.00  0.00           H  
ATOM    321  HB2 PHE A  23     -30.606  69.738 130.464  1.00  0.00           H  
ATOM    322  HB3 PHE A  23     -31.881  69.350 131.616  1.00  0.00           H  
ATOM    323  HD1 PHE A  23     -33.440  71.411 132.222  1.00  0.00           H  
ATOM    324  HD2 PHE A  23     -31.152  71.032 128.654  1.00  0.00           H  
ATOM    325  HE1 PHE A  23     -34.944  72.997 131.093  1.00  0.00           H  
ATOM    326  HE2 PHE A  23     -32.652  72.618 127.519  1.00  0.00           H  
ATOM    327  HZ  PHE A  23     -34.551  73.602 128.739  1.00  0.00           H  
ATOM    328  N   THR A  24     -29.125  72.237 130.918  1.00  0.00           N  
ATOM    329  CA  THR A  24     -28.609  73.510 130.430  1.00  0.00           C  
ATOM    330  C   THR A  24     -29.303  73.924 129.136  1.00  0.00           C  
ATOM    331  O   THR A  24     -29.688  73.077 128.329  1.00  0.00           O  
ATOM    332  CB  THR A  24     -27.090  73.445 130.185  1.00  0.00           C  
ATOM    333  OG1 THR A  24     -26.426  72.961 131.358  1.00  0.00           O  
ATOM    334  CG2 THR A  24     -26.542  74.814 129.815  1.00  0.00           C  
ATOM    335  H   THR A  24     -28.817  71.404 130.502  1.00  0.00           H  
ATOM    336  HA  THR A  24     -28.800  74.259 131.185  1.00  0.00           H  
ATOM    337  HB  THR A  24     -26.901  72.765 129.367  1.00  0.00           H  
ATOM    338  HG1 THR A  24     -26.223  72.028 131.250  1.00  0.00           H  
ATOM    339 HG21 THR A  24     -26.587  74.942 128.743  1.00  0.00           H  
ATOM    340 HG22 THR A  24     -25.517  74.893 130.145  1.00  0.00           H  
ATOM    341 HG23 THR A  24     -27.134  75.580 130.293  1.00  0.00           H  
ATOM    342  N   LEU A  25     -29.458  75.229 128.946  1.00  0.00           N  
ATOM    343  CA  LEU A  25     -30.105  75.755 127.749  1.00  0.00           C  
ATOM    344  C   LEU A  25     -29.369  76.986 127.229  1.00  0.00           C  
ATOM    345  O   LEU A  25     -29.059  77.903 127.989  1.00  0.00           O  
ATOM    346  CB  LEU A  25     -31.564  76.108 128.047  1.00  0.00           C  
ATOM    347  CG  LEU A  25     -32.417  76.509 126.843  1.00  0.00           C  
ATOM    348  CD1 LEU A  25     -33.312  75.356 126.414  1.00  0.00           C  
ATOM    349  CD2 LEU A  25     -33.251  77.740 127.168  1.00  0.00           C  
ATOM    350  H   LEU A  25     -29.131  75.854 129.625  1.00  0.00           H  
ATOM    351  HA  LEU A  25     -30.077  74.986 126.991  1.00  0.00           H  
ATOM    352  HB2 LEU A  25     -32.025  75.246 128.506  1.00  0.00           H  
ATOM    353  HB3 LEU A  25     -31.569  76.931 128.747  1.00  0.00           H  
ATOM    354  HG  LEU A  25     -31.767  76.753 126.014  1.00  0.00           H  
ATOM    355 HD11 LEU A  25     -32.746  74.437 126.433  1.00  0.00           H  
ATOM    356 HD12 LEU A  25     -33.674  75.535 125.414  1.00  0.00           H  
ATOM    357 HD13 LEU A  25     -34.148  75.278 127.091  1.00  0.00           H  
ATOM    358 HD21 LEU A  25     -32.597  78.549 127.460  1.00  0.00           H  
ATOM    359 HD22 LEU A  25     -33.928  77.513 127.978  1.00  0.00           H  
ATOM    360 HD23 LEU A  25     -33.817  78.032 126.295  1.00  0.00           H  
ATOM    361  N   SER A  26     -29.096  76.999 125.928  1.00  0.00           N  
ATOM    362  CA  SER A  26     -28.395  78.116 125.306  1.00  0.00           C  
ATOM    363  C   SER A  26     -29.269  78.784 124.249  1.00  0.00           C  
ATOM    364  O   SER A  26     -29.431  78.267 123.144  1.00  0.00           O  
ATOM    365  CB  SER A  26     -27.086  77.637 124.674  1.00  0.00           C  
ATOM    366  OG  SER A  26     -25.975  78.325 125.220  1.00  0.00           O  
ATOM    367  H   SER A  26     -29.369  76.237 125.375  1.00  0.00           H  
ATOM    368  HA  SER A  26     -28.169  78.837 126.078  1.00  0.00           H  
ATOM    369  HB2 SER A  26     -26.966  76.580 124.858  1.00  0.00           H  
ATOM    370  HB3 SER A  26     -27.118  77.816 123.609  1.00  0.00           H  
ATOM    371  HG  SER A  26     -25.943  78.181 126.169  1.00  0.00           H  
ATOM    372  N   VAL A  27     -29.829  79.938 124.597  1.00  0.00           N  
ATOM    373  CA  VAL A  27     -30.686  80.680 123.678  1.00  0.00           C  
ATOM    374  C   VAL A  27     -30.286  82.149 123.618  1.00  0.00           C  
ATOM    375  O   VAL A  27     -29.985  82.764 124.643  1.00  0.00           O  
ATOM    376  CB  VAL A  27     -32.168  80.578 124.088  1.00  0.00           C  
ATOM    377  CG1 VAL A  27     -32.338  80.906 125.563  1.00  0.00           C  
ATOM    378  CG2 VAL A  27     -33.022  81.498 123.227  1.00  0.00           C  
ATOM    379  H   VAL A  27     -29.662  80.300 125.492  1.00  0.00           H  
ATOM    380  HA  VAL A  27     -30.575  80.246 122.695  1.00  0.00           H  
ATOM    381  HB  VAL A  27     -32.496  79.562 123.927  1.00  0.00           H  
ATOM    382 HG11 VAL A  27     -31.604  81.643 125.854  1.00  0.00           H  
ATOM    383 HG12 VAL A  27     -33.330  81.296 125.733  1.00  0.00           H  
ATOM    384 HG13 VAL A  27     -32.198  80.009 126.149  1.00  0.00           H  
ATOM    385 HG21 VAL A  27     -32.802  82.525 123.472  1.00  0.00           H  
ATOM    386 HG22 VAL A  27     -32.802  81.321 122.184  1.00  0.00           H  
ATOM    387 HG23 VAL A  27     -34.066  81.298 123.414  1.00  0.00           H  
ATOM    388  N   ASP A  28     -30.284  82.707 122.413  1.00  0.00           N  
ATOM    389  CA  ASP A  28     -29.923  84.106 122.219  1.00  0.00           C  
ATOM    390  C   ASP A  28     -30.837  85.021 123.028  1.00  0.00           C  
ATOM    391  O   ASP A  28     -31.945  85.344 122.601  1.00  0.00           O  
ATOM    392  CB  ASP A  28     -29.996  84.474 120.736  1.00  0.00           C  
ATOM    393  CG  ASP A  28     -28.845  83.893 119.939  1.00  0.00           C  
ATOM    394  OD1 ASP A  28     -27.711  84.396 120.082  1.00  0.00           O  
ATOM    395  OD2 ASP A  28     -29.078  82.936 119.171  1.00  0.00           O  
ATOM    396  H   ASP A  28     -30.533  82.165 121.635  1.00  0.00           H  
ATOM    397  HA  ASP A  28     -28.908  84.238 122.563  1.00  0.00           H  
ATOM    398  HB2 ASP A  28     -30.920  84.098 120.324  1.00  0.00           H  
ATOM    399  HB3 ASP A  28     -29.973  85.549 120.636  1.00  0.00           H  
ATOM    400  N   ALA A  29     -30.365  85.436 124.198  1.00  0.00           N  
ATOM    401  CA  ALA A  29     -31.139  86.315 125.067  1.00  0.00           C  
ATOM    402  C   ALA A  29     -31.177  87.736 124.516  1.00  0.00           C  
ATOM    403  O   ALA A  29     -31.897  88.593 125.031  1.00  0.00           O  
ATOM    404  CB  ALA A  29     -30.563  86.308 126.475  1.00  0.00           C  
ATOM    405  H   ALA A  29     -29.474  85.147 124.485  1.00  0.00           H  
ATOM    406  HA  ALA A  29     -32.148  85.931 125.115  1.00  0.00           H  
ATOM    407  HB1 ALA A  29     -29.986  87.208 126.632  1.00  0.00           H  
ATOM    408  HB2 ALA A  29     -31.368  86.266 127.193  1.00  0.00           H  
ATOM    409  HB3 ALA A  29     -29.925  85.445 126.597  1.00  0.00           H  
ATOM    410  N   SER A  30     -30.397  87.981 123.468  1.00  0.00           N  
ATOM    411  CA  SER A  30     -30.339  89.302 122.850  1.00  0.00           C  
ATOM    412  C   SER A  30     -31.740  89.820 122.542  1.00  0.00           C  
ATOM    413  O   SER A  30     -32.071  90.967 122.845  1.00  0.00           O  
ATOM    414  CB  SER A  30     -29.508  89.251 121.567  1.00  0.00           C  
ATOM    415  OG  SER A  30     -28.342  88.465 121.745  1.00  0.00           O  
ATOM    416  H   SER A  30     -29.847  87.258 123.103  1.00  0.00           H  
ATOM    417  HA  SER A  30     -29.865  89.973 123.550  1.00  0.00           H  
ATOM    418  HB2 SER A  30     -30.101  88.820 120.774  1.00  0.00           H  
ATOM    419  HB3 SER A  30     -29.213  90.253 121.293  1.00  0.00           H  
ATOM    420  HG  SER A  30     -27.795  88.854 122.431  1.00  0.00           H  
ATOM    421  N   LEU A  31     -32.560  88.966 121.939  1.00  0.00           N  
ATOM    422  CA  LEU A  31     -33.928  89.336 121.589  1.00  0.00           C  
ATOM    423  C   LEU A  31     -34.864  89.149 122.779  1.00  0.00           C  
ATOM    424  O   LEU A  31     -35.832  89.893 122.945  1.00  0.00           O  
ATOM    425  CB  LEU A  31     -34.415  88.500 120.405  1.00  0.00           C  
ATOM    426  CG  LEU A  31     -33.336  88.011 119.439  1.00  0.00           C  
ATOM    427  CD1 LEU A  31     -32.903  86.597 119.796  1.00  0.00           C  
ATOM    428  CD2 LEU A  31     -33.838  88.069 118.004  1.00  0.00           C  
ATOM    429  H   LEU A  31     -32.240  88.066 121.725  1.00  0.00           H  
ATOM    430  HA  LEU A  31     -33.927  90.379 121.308  1.00  0.00           H  
ATOM    431  HB2 LEU A  31     -34.924  87.634 120.799  1.00  0.00           H  
ATOM    432  HB3 LEU A  31     -35.116  89.102 119.843  1.00  0.00           H  
ATOM    433  HG  LEU A  31     -32.471  88.654 119.519  1.00  0.00           H  
ATOM    434 HD11 LEU A  31     -32.944  86.467 120.867  1.00  0.00           H  
ATOM    435 HD12 LEU A  31     -31.893  86.433 119.452  1.00  0.00           H  
ATOM    436 HD13 LEU A  31     -33.564  85.886 119.321  1.00  0.00           H  
ATOM    437 HD21 LEU A  31     -34.901  87.883 117.987  1.00  0.00           H  
ATOM    438 HD22 LEU A  31     -33.330  87.320 117.414  1.00  0.00           H  
ATOM    439 HD23 LEU A  31     -33.638  89.048 117.593  1.00  0.00           H  
ATOM    440  N   THR A  32     -34.568  88.152 123.607  1.00  0.00           N  
ATOM    441  CA  THR A  32     -35.383  87.867 124.781  1.00  0.00           C  
ATOM    442  C   THR A  32     -35.508  89.097 125.674  1.00  0.00           C  
ATOM    443  O   THR A  32     -36.605  89.455 126.104  1.00  0.00           O  
ATOM    444  CB  THR A  32     -34.795  86.707 125.605  1.00  0.00           C  
ATOM    445  OG1 THR A  32     -34.829  85.496 124.840  1.00  0.00           O  
ATOM    446  CG2 THR A  32     -35.569  86.515 126.901  1.00  0.00           C  
ATOM    447  H   THR A  32     -33.784  87.594 123.421  1.00  0.00           H  
ATOM    448  HA  THR A  32     -36.368  87.579 124.443  1.00  0.00           H  
ATOM    449  HB  THR A  32     -33.768  86.941 125.848  1.00  0.00           H  
ATOM    450  HG1 THR A  32     -34.179  84.880 125.186  1.00  0.00           H  
ATOM    451 HG21 THR A  32     -35.385  87.353 127.557  1.00  0.00           H  
ATOM    452 HG22 THR A  32     -35.247  85.604 127.382  1.00  0.00           H  
ATOM    453 HG23 THR A  32     -36.624  86.454 126.683  1.00  0.00           H  
ATOM    454  N   ARG A  33     -34.378  89.739 125.951  1.00  0.00           N  
ATOM    455  CA  ARG A  33     -34.362  90.929 126.793  1.00  0.00           C  
ATOM    456  C   ARG A  33     -35.291  92.003 126.236  1.00  0.00           C  
ATOM    457  O   ARG A  33     -34.937  92.721 125.301  1.00  0.00           O  
ATOM    458  CB  ARG A  33     -32.939  91.480 126.908  1.00  0.00           C  
ATOM    459  CG  ARG A  33     -32.153  90.898 128.072  1.00  0.00           C  
ATOM    460  CD  ARG A  33     -32.370  89.399 128.197  1.00  0.00           C  
ATOM    461  NE  ARG A  33     -31.285  88.747 128.926  1.00  0.00           N  
ATOM    462  CZ  ARG A  33     -31.179  88.758 130.250  1.00  0.00           C  
ATOM    463  NH1 ARG A  33     -32.088  89.381 130.987  1.00  0.00           N  
ATOM    464  NH2 ARG A  33     -30.162  88.142 130.840  1.00  0.00           N  
ATOM    465  H   ARG A  33     -33.535  89.405 125.578  1.00  0.00           H  
ATOM    466  HA  ARG A  33     -34.708  90.644 127.776  1.00  0.00           H  
ATOM    467  HB2 ARG A  33     -32.405  91.258 125.996  1.00  0.00           H  
ATOM    468  HB3 ARG A  33     -32.990  92.550 127.035  1.00  0.00           H  
ATOM    469  HG2 ARG A  33     -31.101  91.086 127.914  1.00  0.00           H  
ATOM    470  HG3 ARG A  33     -32.473  91.378 128.984  1.00  0.00           H  
ATOM    471  HD2 ARG A  33     -33.298  89.225 128.722  1.00  0.00           H  
ATOM    472  HD3 ARG A  33     -32.433  88.974 127.207  1.00  0.00           H  
ATOM    473  HE  ARG A  33     -30.602  88.280 128.401  1.00  0.00           H  
ATOM    474 HH11 ARG A  33     -32.855  89.845 130.544  1.00  0.00           H  
ATOM    475 HH12 ARG A  33     -32.006  89.386 131.984  1.00  0.00           H  
ATOM    476 HH21 ARG A  33     -29.475  87.670 130.288  1.00  0.00           H  
ATOM    477 HH22 ARG A  33     -30.082  88.150 131.837  1.00  0.00           H  
ATOM    478  N   GLY A  34     -36.483  92.107 126.817  1.00  0.00           N  
ATOM    479  CA  GLY A  34     -37.444  93.095 126.364  1.00  0.00           C  
ATOM    480  C   GLY A  34     -38.842  92.525 126.228  1.00  0.00           C  
ATOM    481  O   GLY A  34     -39.820  93.268 126.144  1.00  0.00           O  
ATOM    482  H   GLY A  34     -36.710  91.509 127.558  1.00  0.00           H  
ATOM    483  HA2 GLY A  34     -37.467  93.910 127.071  1.00  0.00           H  
ATOM    484  HA3 GLY A  34     -37.128  93.475 125.403  1.00  0.00           H  
ATOM    485  N   LYS A  35     -38.938  91.199 126.204  1.00  0.00           N  
ATOM    486  CA  LYS A  35     -40.226  90.528 126.077  1.00  0.00           C  
ATOM    487  C   LYS A  35     -40.459  89.573 127.243  1.00  0.00           C  
ATOM    488  O   LYS A  35     -39.576  89.369 128.076  1.00  0.00           O  
ATOM    489  CB  LYS A  35     -40.295  89.761 124.755  1.00  0.00           C  
ATOM    490  CG  LYS A  35     -39.490  88.474 124.754  1.00  0.00           C  
ATOM    491  CD  LYS A  35     -39.580  87.760 123.416  1.00  0.00           C  
ATOM    492  CE  LYS A  35     -38.542  88.282 122.435  1.00  0.00           C  
ATOM    493  NZ  LYS A  35     -39.171  88.811 121.192  1.00  0.00           N  
ATOM    494  H   LYS A  35     -38.122  90.660 126.275  1.00  0.00           H  
ATOM    495  HA  LYS A  35     -40.997  91.283 126.087  1.00  0.00           H  
ATOM    496  HB2 LYS A  35     -41.327  89.516 124.548  1.00  0.00           H  
ATOM    497  HB3 LYS A  35     -39.921  90.396 123.964  1.00  0.00           H  
ATOM    498  HG2 LYS A  35     -38.456  88.707 124.957  1.00  0.00           H  
ATOM    499  HG3 LYS A  35     -39.872  87.821 125.527  1.00  0.00           H  
ATOM    500  HD2 LYS A  35     -39.415  86.704 123.569  1.00  0.00           H  
ATOM    501  HD3 LYS A  35     -40.566  87.916 123.001  1.00  0.00           H  
ATOM    502  HE2 LYS A  35     -37.983  89.073 122.910  1.00  0.00           H  
ATOM    503  HE3 LYS A  35     -37.874  87.474 122.175  1.00  0.00           H  
ATOM    504  HZ1 LYS A  35     -38.787  89.752 120.970  1.00  0.00           H  
ATOM    505  HZ2 LYS A  35     -40.199  88.889 121.317  1.00  0.00           H  
ATOM    506  HZ3 LYS A  35     -38.976  88.173 120.393  1.00  0.00           H  
ATOM    507  N   GLN A  36     -41.652  88.989 127.295  1.00  0.00           N  
ATOM    508  CA  GLN A  36     -41.999  88.055 128.360  1.00  0.00           C  
ATOM    509  C   GLN A  36     -42.449  86.717 127.783  1.00  0.00           C  
ATOM    510  O   GLN A  36     -42.516  86.545 126.567  1.00  0.00           O  
ATOM    511  CB  GLN A  36     -43.103  88.640 129.241  1.00  0.00           C  
ATOM    512  CG  GLN A  36     -42.740  89.980 129.863  1.00  0.00           C  
ATOM    513  CD  GLN A  36     -43.930  90.910 129.982  1.00  0.00           C  
ATOM    514  OE1 GLN A  36     -43.857  92.082 129.610  1.00  0.00           O  
ATOM    515  NE2 GLN A  36     -45.037  90.393 130.503  1.00  0.00           N  
ATOM    516  H   GLN A  36     -42.314  89.192 126.603  1.00  0.00           H  
ATOM    517  HA  GLN A  36     -41.117  87.896 128.961  1.00  0.00           H  
ATOM    518  HB2 GLN A  36     -43.992  88.775 128.643  1.00  0.00           H  
ATOM    519  HB3 GLN A  36     -43.318  87.945 130.039  1.00  0.00           H  
ATOM    520  HG2 GLN A  36     -42.338  89.807 130.850  1.00  0.00           H  
ATOM    521  HG3 GLN A  36     -41.989  90.455 129.249  1.00  0.00           H  
ATOM    522 HE21 GLN A  36     -45.021  89.452 130.779  1.00  0.00           H  
ATOM    523 HE22 GLN A  36     -45.821  90.973 130.592  1.00  0.00           H  
ATOM    524  N   SER A  37     -42.755  85.770 128.666  1.00  0.00           N  
ATOM    525  CA  SER A  37     -43.194  84.445 128.245  1.00  0.00           C  
ATOM    526  C   SER A  37     -44.292  83.920 129.164  1.00  0.00           C  
ATOM    527  O   SER A  37     -44.454  84.391 130.289  1.00  0.00           O  
ATOM    528  CB  SER A  37     -42.013  83.473 128.233  1.00  0.00           C  
ATOM    529  OG  SER A  37     -42.460  82.129 128.182  1.00  0.00           O  
ATOM    530  H   SER A  37     -42.681  85.968 129.623  1.00  0.00           H  
ATOM    531  HA  SER A  37     -43.589  84.530 127.243  1.00  0.00           H  
ATOM    532  HB2 SER A  37     -41.398  83.668 127.369  1.00  0.00           H  
ATOM    533  HB3 SER A  37     -41.428  83.612 129.131  1.00  0.00           H  
ATOM    534  HG  SER A  37     -42.859  81.892 129.023  1.00  0.00           H  
ATOM    535  N   ASN A  38     -45.044  82.939 128.676  1.00  0.00           N  
ATOM    536  CA  ASN A  38     -46.128  82.348 129.453  1.00  0.00           C  
ATOM    537  C   ASN A  38     -45.590  81.315 130.439  1.00  0.00           C  
ATOM    538  O   ASN A  38     -44.876  80.388 130.057  1.00  0.00           O  
ATOM    539  CB  ASN A  38     -47.153  81.695 128.523  1.00  0.00           C  
ATOM    540  CG  ASN A  38     -47.603  82.626 127.415  1.00  0.00           C  
ATOM    541  OD1 ASN A  38     -46.904  82.803 126.416  1.00  0.00           O  
ATOM    542  ND2 ASN A  38     -48.774  83.228 127.585  1.00  0.00           N  
ATOM    543  H   ASN A  38     -44.867  82.603 127.773  1.00  0.00           H  
ATOM    544  HA  ASN A  38     -46.610  83.140 130.006  1.00  0.00           H  
ATOM    545  HB2 ASN A  38     -46.714  80.816 128.074  1.00  0.00           H  
ATOM    546  HB3 ASN A  38     -48.019  81.405 129.099  1.00  0.00           H  
ATOM    547 HD21 ASN A  38     -49.276  83.039 128.406  1.00  0.00           H  
ATOM    548 HD22 ASN A  38     -49.090  83.835 126.884  1.00  0.00           H  
ATOM    549  N   GLY A  39     -45.939  81.482 131.712  1.00  0.00           N  
ATOM    550  CA  GLY A  39     -45.483  80.557 132.733  1.00  0.00           C  
ATOM    551  C   GLY A  39     -46.042  79.162 132.544  1.00  0.00           C  
ATOM    552  O   GLY A  39     -46.789  78.907 131.597  1.00  0.00           O  
ATOM    553  H   GLY A  39     -46.510  82.239 131.959  1.00  0.00           H  
ATOM    554  HA2 GLY A  39     -44.404  80.508 132.704  1.00  0.00           H  
ATOM    555  HA3 GLY A  39     -45.790  80.927 133.700  1.00  0.00           H  
ATOM    556  N   LEU A  40     -45.680  78.253 133.443  1.00  0.00           N  
ATOM    557  CA  LEU A  40     -46.151  76.874 133.369  1.00  0.00           C  
ATOM    558  C   LEU A  40     -47.172  76.587 134.465  1.00  0.00           C  
ATOM    559  O   LEU A  40     -47.213  77.277 135.485  1.00  0.00           O  
ATOM    560  CB  LEU A  40     -44.973  75.906 133.490  1.00  0.00           C  
ATOM    561  CG  LEU A  40     -45.256  74.453 133.108  1.00  0.00           C  
ATOM    562  CD1 LEU A  40     -45.821  74.371 131.699  1.00  0.00           C  
ATOM    563  CD2 LEU A  40     -43.993  73.613 133.227  1.00  0.00           C  
ATOM    564  H   LEU A  40     -45.083  78.515 134.173  1.00  0.00           H  
ATOM    565  HA  LEU A  40     -46.623  76.735 132.408  1.00  0.00           H  
ATOM    566  HB2 LEU A  40     -44.181  76.267 132.850  1.00  0.00           H  
ATOM    567  HB3 LEU A  40     -44.637  75.920 134.517  1.00  0.00           H  
ATOM    568  HG  LEU A  40     -45.993  74.047 133.786  1.00  0.00           H  
ATOM    569 HD11 LEU A  40     -45.740  75.336 131.222  1.00  0.00           H  
ATOM    570 HD12 LEU A  40     -46.859  74.078 131.743  1.00  0.00           H  
ATOM    571 HD13 LEU A  40     -45.265  73.640 131.130  1.00  0.00           H  
ATOM    572 HD21 LEU A  40     -43.395  73.978 134.051  1.00  0.00           H  
ATOM    573 HD22 LEU A  40     -43.424  73.686 132.311  1.00  0.00           H  
ATOM    574 HD23 LEU A  40     -44.261  72.583 133.406  1.00  0.00           H  
ATOM    575  N   HIS A  41     -47.995  75.566 134.248  1.00  0.00           N  
ATOM    576  CA  HIS A  41     -49.015  75.187 135.219  1.00  0.00           C  
ATOM    577  C   HIS A  41     -49.495  73.760 134.973  1.00  0.00           C  
ATOM    578  O   HIS A  41     -50.297  73.511 134.075  1.00  0.00           O  
ATOM    579  CB  HIS A  41     -50.198  76.154 135.153  1.00  0.00           C  
ATOM    580  CG  HIS A  41     -50.629  76.666 136.492  1.00  0.00           C  
ATOM    581  ND1 HIS A  41     -51.951  76.786 136.862  1.00  0.00           N  
ATOM    582  CD2 HIS A  41     -49.903  77.088 137.555  1.00  0.00           C  
ATOM    583  CE1 HIS A  41     -52.022  77.261 138.093  1.00  0.00           C  
ATOM    584  NE2 HIS A  41     -50.793  77.452 138.536  1.00  0.00           N  
ATOM    585  H   HIS A  41     -47.913  75.055 133.417  1.00  0.00           H  
ATOM    586  HA  HIS A  41     -48.573  75.240 136.203  1.00  0.00           H  
ATOM    587  HB2 HIS A  41     -49.924  77.004 134.546  1.00  0.00           H  
ATOM    588  HB3 HIS A  41     -51.041  75.651 134.701  1.00  0.00           H  
ATOM    589  HD1 HIS A  41     -52.724  76.558 136.304  1.00  0.00           H  
ATOM    590  HD2 HIS A  41     -48.825  77.131 137.620  1.00  0.00           H  
ATOM    591  HE1 HIS A  41     -52.929  77.460 138.642  1.00  0.00           H  
ATOM    592  N   GLY A  42     -48.997  72.825 135.777  1.00  0.00           N  
ATOM    593  CA  GLY A  42     -49.386  71.435 135.629  1.00  0.00           C  
ATOM    594  C   GLY A  42     -48.195  70.499 135.612  1.00  0.00           C  
ATOM    595  O   GLY A  42     -47.050  70.938 135.720  1.00  0.00           O  
ATOM    596  H   GLY A  42     -48.360  73.083 136.477  1.00  0.00           H  
ATOM    597  HA2 GLY A  42     -50.032  71.164 136.451  1.00  0.00           H  
ATOM    598  HA3 GLY A  42     -49.932  71.322 134.704  1.00  0.00           H  
ATOM    599  N   ASP A  43     -48.464  69.204 135.477  1.00  0.00           N  
ATOM    600  CA  ASP A  43     -47.405  68.202 135.446  1.00  0.00           C  
ATOM    601  C   ASP A  43     -46.784  68.110 134.055  1.00  0.00           C  
ATOM    602  O   ASP A  43     -47.372  67.535 133.139  1.00  0.00           O  
ATOM    603  CB  ASP A  43     -47.953  66.837 135.865  1.00  0.00           C  
ATOM    604  CG  ASP A  43     -49.205  66.457 135.101  1.00  0.00           C  
ATOM    605  OD1 ASP A  43     -50.282  67.008 135.413  1.00  0.00           O  
ATOM    606  OD2 ASP A  43     -49.109  65.608 134.190  1.00  0.00           O  
ATOM    607  H   ASP A  43     -49.397  68.916 135.395  1.00  0.00           H  
ATOM    608  HA  ASP A  43     -46.642  68.505 136.148  1.00  0.00           H  
ATOM    609  HB2 ASP A  43     -47.200  66.084 135.684  1.00  0.00           H  
ATOM    610  HB3 ASP A  43     -48.188  66.860 136.919  1.00  0.00           H  
ATOM    611  N   TYR A  44     -45.594  68.682 133.905  1.00  0.00           N  
ATOM    612  CA  TYR A  44     -44.895  68.668 132.626  1.00  0.00           C  
ATOM    613  C   TYR A  44     -43.400  68.435 132.825  1.00  0.00           C  
ATOM    614  O   TYR A  44     -42.767  69.075 133.664  1.00  0.00           O  
ATOM    615  CB  TYR A  44     -45.123  69.984 131.881  1.00  0.00           C  
ATOM    616  CG  TYR A  44     -46.579  70.268 131.587  1.00  0.00           C  
ATOM    617  CD1 TYR A  44     -47.275  69.526 130.639  1.00  0.00           C  
ATOM    618  CD2 TYR A  44     -47.259  71.278 132.255  1.00  0.00           C  
ATOM    619  CE1 TYR A  44     -48.604  69.783 130.367  1.00  0.00           C  
ATOM    620  CE2 TYR A  44     -48.589  71.542 131.990  1.00  0.00           C  
ATOM    621  CZ  TYR A  44     -49.257  70.791 131.045  1.00  0.00           C  
ATOM    622  OH  TYR A  44     -50.582  71.050 130.777  1.00  0.00           O  
ATOM    623  H   TYR A  44     -45.176  69.126 134.673  1.00  0.00           H  
ATOM    624  HA  TYR A  44     -45.299  67.857 132.037  1.00  0.00           H  
ATOM    625  HB2 TYR A  44     -44.742  70.798 132.479  1.00  0.00           H  
ATOM    626  HB3 TYR A  44     -44.594  69.954 130.941  1.00  0.00           H  
ATOM    627  HD1 TYR A  44     -46.760  68.737 130.111  1.00  0.00           H  
ATOM    628  HD2 TYR A  44     -46.733  71.864 132.996  1.00  0.00           H  
ATOM    629  HE1 TYR A  44     -49.127  69.196 129.627  1.00  0.00           H  
ATOM    630  HE2 TYR A  44     -49.101  72.331 132.521  1.00  0.00           H  
ATOM    631  HH  TYR A  44     -51.029  70.230 130.554  1.00  0.00           H  
ATOM    632  N   ASP A  45     -42.843  67.516 132.044  1.00  0.00           N  
ATOM    633  CA  ASP A  45     -41.423  67.198 132.132  1.00  0.00           C  
ATOM    634  C   ASP A  45     -40.573  68.378 131.670  1.00  0.00           C  
ATOM    635  O   ASP A  45     -41.094  69.455 131.377  1.00  0.00           O  
ATOM    636  CB  ASP A  45     -41.101  65.963 131.290  1.00  0.00           C  
ATOM    637  CG  ASP A  45     -42.036  64.805 131.581  1.00  0.00           C  
ATOM    638  OD1 ASP A  45     -41.776  64.061 132.550  1.00  0.00           O  
ATOM    639  OD2 ASP A  45     -43.028  64.643 130.840  1.00  0.00           O  
ATOM    640  H   ASP A  45     -43.401  67.039 131.393  1.00  0.00           H  
ATOM    641  HA  ASP A  45     -41.193  66.988 133.166  1.00  0.00           H  
ATOM    642  HB2 ASP A  45     -41.188  66.215 130.243  1.00  0.00           H  
ATOM    643  HB3 ASP A  45     -40.090  65.646 131.497  1.00  0.00           H  
ATOM    644  N   VAL A  46     -39.262  68.169 131.610  1.00  0.00           N  
ATOM    645  CA  VAL A  46     -38.339  69.215 131.184  1.00  0.00           C  
ATOM    646  C   VAL A  46     -38.683  69.716 129.786  1.00  0.00           C  
ATOM    647  O   VAL A  46     -38.754  70.921 129.548  1.00  0.00           O  
ATOM    648  CB  VAL A  46     -36.882  68.716 131.195  1.00  0.00           C  
ATOM    649  CG1 VAL A  46     -36.762  67.400 130.441  1.00  0.00           C  
ATOM    650  CG2 VAL A  46     -35.956  69.765 130.599  1.00  0.00           C  
ATOM    651  H   VAL A  46     -38.906  67.289 131.856  1.00  0.00           H  
ATOM    652  HA  VAL A  46     -38.421  70.035 131.881  1.00  0.00           H  
ATOM    653  HB  VAL A  46     -36.588  68.547 132.219  1.00  0.00           H  
ATOM    654 HG11 VAL A  46     -36.881  67.579 129.383  1.00  0.00           H  
ATOM    655 HG12 VAL A  46     -35.791  66.965 130.627  1.00  0.00           H  
ATOM    656 HG13 VAL A  46     -37.532  66.721 130.779  1.00  0.00           H  
ATOM    657 HG21 VAL A  46     -36.222  70.739 130.983  1.00  0.00           H  
ATOM    658 HG22 VAL A  46     -34.934  69.539 130.869  1.00  0.00           H  
ATOM    659 HG23 VAL A  46     -36.053  69.763 129.523  1.00  0.00           H  
ATOM    660  N   GLU A  47     -38.898  68.782 128.865  1.00  0.00           N  
ATOM    661  CA  GLU A  47     -39.235  69.130 127.490  1.00  0.00           C  
ATOM    662  C   GLU A  47     -40.675  69.627 127.392  1.00  0.00           C  
ATOM    663  O   GLU A  47     -40.936  70.701 126.850  1.00  0.00           O  
ATOM    664  CB  GLU A  47     -39.038  67.922 126.572  1.00  0.00           C  
ATOM    665  CG  GLU A  47     -38.002  68.148 125.483  1.00  0.00           C  
ATOM    666  CD  GLU A  47     -37.814  66.933 124.596  1.00  0.00           C  
ATOM    667  OE1 GLU A  47     -37.505  65.848 125.132  1.00  0.00           O  
ATOM    668  OE2 GLU A  47     -37.975  67.067 123.364  1.00  0.00           O  
ATOM    669  H   GLU A  47     -38.828  67.837 129.115  1.00  0.00           H  
ATOM    670  HA  GLU A  47     -38.572  69.922 127.175  1.00  0.00           H  
ATOM    671  HB2 GLU A  47     -38.724  67.078 127.168  1.00  0.00           H  
ATOM    672  HB3 GLU A  47     -39.980  67.687 126.099  1.00  0.00           H  
ATOM    673  HG2 GLU A  47     -38.320  68.977 124.869  1.00  0.00           H  
ATOM    674  HG3 GLU A  47     -37.057  68.387 125.948  1.00  0.00           H  
ATOM    675  N   SER A  48     -41.605  68.837 127.919  1.00  0.00           N  
ATOM    676  CA  SER A  48     -43.018  69.194 127.888  1.00  0.00           C  
ATOM    677  C   SER A  48     -43.241  70.582 128.481  1.00  0.00           C  
ATOM    678  O   SER A  48     -43.869  71.440 127.862  1.00  0.00           O  
ATOM    679  CB  SER A  48     -43.845  68.161 128.657  1.00  0.00           C  
ATOM    680  OG  SER A  48     -44.654  67.400 127.778  1.00  0.00           O  
ATOM    681  H   SER A  48     -41.334  67.993 128.338  1.00  0.00           H  
ATOM    682  HA  SER A  48     -43.335  69.202 126.856  1.00  0.00           H  
ATOM    683  HB2 SER A  48     -43.180  67.493 129.184  1.00  0.00           H  
ATOM    684  HB3 SER A  48     -44.482  68.669 129.366  1.00  0.00           H  
ATOM    685  HG  SER A  48     -44.223  66.563 127.588  1.00  0.00           H  
ATOM    686  N   GLY A  49     -42.722  70.795 129.686  1.00  0.00           N  
ATOM    687  CA  GLY A  49     -42.874  72.080 130.344  1.00  0.00           C  
ATOM    688  C   GLY A  49     -42.161  73.197 129.607  1.00  0.00           C  
ATOM    689  O   GLY A  49     -42.646  74.329 129.560  1.00  0.00           O  
ATOM    690  H   GLY A  49     -42.231  70.074 130.133  1.00  0.00           H  
ATOM    691  HA2 GLY A  49     -43.926  72.318 130.406  1.00  0.00           H  
ATOM    692  HA3 GLY A  49     -42.471  72.010 131.343  1.00  0.00           H  
ATOM    693  N   LEU A  50     -41.007  72.880 129.032  1.00  0.00           N  
ATOM    694  CA  LEU A  50     -40.224  73.866 128.295  1.00  0.00           C  
ATOM    695  C   LEU A  50     -41.001  74.392 127.093  1.00  0.00           C  
ATOM    696  O   LEU A  50     -41.057  75.598 126.857  1.00  0.00           O  
ATOM    697  CB  LEU A  50     -38.900  73.254 127.832  1.00  0.00           C  
ATOM    698  CG  LEU A  50     -38.299  73.841 126.554  1.00  0.00           C  
ATOM    699  CD1 LEU A  50     -38.102  75.342 126.699  1.00  0.00           C  
ATOM    700  CD2 LEU A  50     -36.981  73.157 126.223  1.00  0.00           C  
ATOM    701  H   LEU A  50     -40.671  71.963 129.104  1.00  0.00           H  
ATOM    702  HA  LEU A  50     -40.015  74.689 128.962  1.00  0.00           H  
ATOM    703  HB2 LEU A  50     -38.180  73.382 128.626  1.00  0.00           H  
ATOM    704  HB3 LEU A  50     -39.065  72.198 127.666  1.00  0.00           H  
ATOM    705  HG  LEU A  50     -38.981  73.672 125.732  1.00  0.00           H  
ATOM    706 HD11 LEU A  50     -38.583  75.683 127.603  1.00  0.00           H  
ATOM    707 HD12 LEU A  50     -38.536  75.845 125.849  1.00  0.00           H  
ATOM    708 HD13 LEU A  50     -37.045  75.563 126.747  1.00  0.00           H  
ATOM    709 HD21 LEU A  50     -36.919  72.218 126.753  1.00  0.00           H  
ATOM    710 HD22 LEU A  50     -36.160  73.794 126.522  1.00  0.00           H  
ATOM    711 HD23 LEU A  50     -36.928  72.976 125.160  1.00  0.00           H  
ATOM    712  N   GLN A  51     -41.603  73.478 126.338  1.00  0.00           N  
ATOM    713  CA  GLN A  51     -42.379  73.851 125.162  1.00  0.00           C  
ATOM    714  C   GLN A  51     -43.632  74.624 125.559  1.00  0.00           C  
ATOM    715  O   GLN A  51     -44.167  75.402 124.770  1.00  0.00           O  
ATOM    716  CB  GLN A  51     -42.768  72.603 124.366  1.00  0.00           C  
ATOM    717  CG  GLN A  51     -41.577  71.760 123.937  1.00  0.00           C  
ATOM    718  CD  GLN A  51     -41.238  71.931 122.469  1.00  0.00           C  
ATOM    719  OE1 GLN A  51     -41.583  71.090 121.638  1.00  0.00           O  
ATOM    720  NE2 GLN A  51     -40.560  73.025 122.143  1.00  0.00           N  
ATOM    721  H   GLN A  51     -41.521  72.532 126.578  1.00  0.00           H  
ATOM    722  HA  GLN A  51     -41.761  74.483 124.543  1.00  0.00           H  
ATOM    723  HB2 GLN A  51     -43.416  71.990 124.972  1.00  0.00           H  
ATOM    724  HB3 GLN A  51     -43.302  72.909 123.478  1.00  0.00           H  
ATOM    725  HG2 GLN A  51     -40.719  72.048 124.525  1.00  0.00           H  
ATOM    726  HG3 GLN A  51     -41.806  70.720 124.119  1.00  0.00           H  
ATOM    727 HE21 GLN A  51     -40.318  73.651 122.859  1.00  0.00           H  
ATOM    728 HE22 GLN A  51     -40.328  73.161 121.201  1.00  0.00           H  
ATOM    729  N   GLN A  52     -44.092  74.406 126.786  1.00  0.00           N  
ATOM    730  CA  GLN A  52     -45.282  75.084 127.287  1.00  0.00           C  
ATOM    731  C   GLN A  52     -44.967  76.525 127.671  1.00  0.00           C  
ATOM    732  O   GLN A  52     -45.844  77.390 127.655  1.00  0.00           O  
ATOM    733  CB  GLN A  52     -45.851  74.335 128.494  1.00  0.00           C  
ATOM    734  CG  GLN A  52     -47.057  73.471 128.159  1.00  0.00           C  
ATOM    735  CD  GLN A  52     -48.155  74.246 127.460  1.00  0.00           C  
ATOM    736  OE1 GLN A  52     -48.617  73.860 126.386  1.00  0.00           O  
ATOM    737  NE2 GLN A  52     -48.580  75.349 128.066  1.00  0.00           N  
ATOM    738  H   GLN A  52     -43.621  73.775 127.369  1.00  0.00           H  
ATOM    739  HA  GLN A  52     -46.018  75.088 126.497  1.00  0.00           H  
ATOM    740  HB2 GLN A  52     -45.081  73.699 128.903  1.00  0.00           H  
ATOM    741  HB3 GLN A  52     -46.149  75.055 129.241  1.00  0.00           H  
ATOM    742  HG2 GLN A  52     -46.738  72.666 127.514  1.00  0.00           H  
ATOM    743  HG3 GLN A  52     -47.453  73.060 129.076  1.00  0.00           H  
ATOM    744 HE21 GLN A  52     -48.166  75.596 128.919  1.00  0.00           H  
ATOM    745 HE22 GLN A  52     -49.289  75.869 127.636  1.00  0.00           H  
ATOM    746  N   LEU A  53     -43.710  76.779 128.018  1.00  0.00           N  
ATOM    747  CA  LEU A  53     -43.278  78.117 128.406  1.00  0.00           C  
ATOM    748  C   LEU A  53     -43.185  79.034 127.191  1.00  0.00           C  
ATOM    749  O   LEU A  53     -43.806  80.097 127.153  1.00  0.00           O  
ATOM    750  CB  LEU A  53     -41.923  78.052 129.115  1.00  0.00           C  
ATOM    751  CG  LEU A  53     -41.917  78.455 130.589  1.00  0.00           C  
ATOM    752  CD1 LEU A  53     -43.171  77.952 131.286  1.00  0.00           C  
ATOM    753  CD2 LEU A  53     -40.669  77.925 131.282  1.00  0.00           C  
ATOM    754  H   LEU A  53     -43.055  76.050 128.012  1.00  0.00           H  
ATOM    755  HA  LEU A  53     -44.012  78.517 129.089  1.00  0.00           H  
ATOM    756  HB2 LEU A  53     -41.565  77.036 129.049  1.00  0.00           H  
ATOM    757  HB3 LEU A  53     -41.244  78.707 128.588  1.00  0.00           H  
ATOM    758  HG  LEU A  53     -41.906  79.534 130.661  1.00  0.00           H  
ATOM    759 HD11 LEU A  53     -43.908  78.739 131.315  1.00  0.00           H  
ATOM    760 HD12 LEU A  53     -42.926  77.651 132.294  1.00  0.00           H  
ATOM    761 HD13 LEU A  53     -43.567  77.105 130.745  1.00  0.00           H  
ATOM    762 HD21 LEU A  53     -40.725  76.848 131.346  1.00  0.00           H  
ATOM    763 HD22 LEU A  53     -40.605  78.343 132.276  1.00  0.00           H  
ATOM    764 HD23 LEU A  53     -39.795  78.208 130.715  1.00  0.00           H  
ATOM    765  N   LEU A  54     -42.408  78.615 126.199  1.00  0.00           N  
ATOM    766  CA  LEU A  54     -42.236  79.398 124.979  1.00  0.00           C  
ATOM    767  C   LEU A  54     -43.435  79.232 124.052  1.00  0.00           C  
ATOM    768  O   LEU A  54     -43.524  79.887 123.013  1.00  0.00           O  
ATOM    769  CB  LEU A  54     -40.955  78.977 124.256  1.00  0.00           C  
ATOM    770  CG  LEU A  54     -41.122  77.939 123.146  1.00  0.00           C  
ATOM    771  CD1 LEU A  54     -42.079  76.840 123.582  1.00  0.00           C  
ATOM    772  CD2 LEU A  54     -41.612  78.601 121.867  1.00  0.00           C  
ATOM    773  H   LEU A  54     -41.938  77.761 126.286  1.00  0.00           H  
ATOM    774  HA  LEU A  54     -42.155  80.437 125.261  1.00  0.00           H  
ATOM    775  HB2 LEU A  54     -40.516  79.861 123.819  1.00  0.00           H  
ATOM    776  HB3 LEU A  54     -40.279  78.568 124.994  1.00  0.00           H  
ATOM    777  HG  LEU A  54     -40.162  77.484 122.941  1.00  0.00           H  
ATOM    778 HD11 LEU A  54     -43.039  76.993 123.114  1.00  0.00           H  
ATOM    779 HD12 LEU A  54     -42.193  76.867 124.655  1.00  0.00           H  
ATOM    780 HD13 LEU A  54     -41.682  75.880 123.287  1.00  0.00           H  
ATOM    781 HD21 LEU A  54     -42.637  78.312 121.683  1.00  0.00           H  
ATOM    782 HD22 LEU A  54     -40.995  78.284 121.038  1.00  0.00           H  
ATOM    783 HD23 LEU A  54     -41.554  79.673 121.971  1.00  0.00           H  
ATOM    784  N   ASP A  55     -44.355  78.353 124.434  1.00  0.00           N  
ATOM    785  CA  ASP A  55     -45.552  78.104 123.639  1.00  0.00           C  
ATOM    786  C   ASP A  55     -46.222  79.414 123.241  1.00  0.00           C  
ATOM    787  O   ASP A  55     -46.641  80.194 124.096  1.00  0.00           O  
ATOM    788  CB  ASP A  55     -46.534  77.228 124.418  1.00  0.00           C  
ATOM    789  CG  ASP A  55     -47.960  77.380 123.926  1.00  0.00           C  
ATOM    790  OD1 ASP A  55     -48.245  76.947 122.790  1.00  0.00           O  
ATOM    791  OD2 ASP A  55     -48.792  77.931 124.677  1.00  0.00           O  
ATOM    792  H   ASP A  55     -44.227  77.862 125.273  1.00  0.00           H  
ATOM    793  HA  ASP A  55     -45.251  77.582 122.743  1.00  0.00           H  
ATOM    794  HB2 ASP A  55     -46.245  76.193 124.314  1.00  0.00           H  
ATOM    795  HB3 ASP A  55     -46.502  77.504 125.462  1.00  0.00           H  
ATOM    796  N   GLY A  56     -46.322  79.651 121.936  1.00  0.00           N  
ATOM    797  CA  GLY A  56     -46.942  80.869 121.448  1.00  0.00           C  
ATOM    798  C   GLY A  56     -46.401  81.292 120.096  1.00  0.00           C  
ATOM    799  O   GLY A  56     -47.103  81.933 119.313  1.00  0.00           O  
ATOM    800  H   GLY A  56     -45.970  78.993 121.300  1.00  0.00           H  
ATOM    801  HA2 GLY A  56     -48.006  80.709 121.365  1.00  0.00           H  
ATOM    802  HA3 GLY A  56     -46.761  81.662 122.160  1.00  0.00           H  
ATOM    803  N   SER A  57     -45.151  80.936 119.822  1.00  0.00           N  
ATOM    804  CA  SER A  57     -44.516  81.288 118.557  1.00  0.00           C  
ATOM    805  C   SER A  57     -44.192  80.038 117.745  1.00  0.00           C  
ATOM    806  O   SER A  57     -44.176  80.070 116.516  1.00  0.00           O  
ATOM    807  CB  SER A  57     -43.238  82.091 118.811  1.00  0.00           C  
ATOM    808  OG  SER A  57     -42.411  81.445 119.763  1.00  0.00           O  
ATOM    809  H   SER A  57     -44.643  80.425 120.487  1.00  0.00           H  
ATOM    810  HA  SER A  57     -45.209  81.898 117.998  1.00  0.00           H  
ATOM    811  HB2 SER A  57     -42.690  82.192 117.886  1.00  0.00           H  
ATOM    812  HB3 SER A  57     -43.500  83.070 119.185  1.00  0.00           H  
ATOM    813  HG  SER A  57     -42.585  80.501 119.751  1.00  0.00           H  
ATOM    814  N   GLY A  58     -43.934  78.937 118.444  1.00  0.00           N  
ATOM    815  CA  GLY A  58     -43.615  77.690 117.772  1.00  0.00           C  
ATOM    816  C   GLY A  58     -42.182  77.648 117.280  1.00  0.00           C  
ATOM    817  O   GLY A  58     -41.874  78.148 116.197  1.00  0.00           O  
ATOM    818  H   GLY A  58     -43.962  78.970 119.424  1.00  0.00           H  
ATOM    819  HA2 GLY A  58     -43.772  76.873 118.460  1.00  0.00           H  
ATOM    820  HA3 GLY A  58     -44.276  77.569 116.927  1.00  0.00           H  
ATOM    821  N   LEU A  59     -41.301  77.052 118.077  1.00  0.00           N  
ATOM    822  CA  LEU A  59     -39.891  76.948 117.717  1.00  0.00           C  
ATOM    823  C   LEU A  59     -39.401  75.509 117.843  1.00  0.00           C  
ATOM    824  O   LEU A  59     -40.120  74.641 118.339  1.00  0.00           O  
ATOM    825  CB  LEU A  59     -39.049  77.866 118.606  1.00  0.00           C  
ATOM    826  CG  LEU A  59     -38.988  79.334 118.187  1.00  0.00           C  
ATOM    827  CD1 LEU A  59     -39.886  80.181 119.075  1.00  0.00           C  
ATOM    828  CD2 LEU A  59     -37.554  79.843 118.235  1.00  0.00           C  
ATOM    829  H   LEU A  59     -41.605  76.673 118.927  1.00  0.00           H  
ATOM    830  HA  LEU A  59     -39.788  77.262 116.689  1.00  0.00           H  
ATOM    831  HB2 LEU A  59     -39.456  77.823 119.604  1.00  0.00           H  
ATOM    832  HB3 LEU A  59     -38.039  77.481 118.614  1.00  0.00           H  
ATOM    833  HG  LEU A  59     -39.343  79.427 117.169  1.00  0.00           H  
ATOM    834 HD11 LEU A  59     -40.841  79.693 119.191  1.00  0.00           H  
ATOM    835 HD12 LEU A  59     -40.030  81.151 118.622  1.00  0.00           H  
ATOM    836 HD13 LEU A  59     -39.423  80.302 120.043  1.00  0.00           H  
ATOM    837 HD21 LEU A  59     -37.146  79.862 117.235  1.00  0.00           H  
ATOM    838 HD22 LEU A  59     -36.960  79.189 118.854  1.00  0.00           H  
ATOM    839 HD23 LEU A  59     -37.540  80.841 118.647  1.00  0.00           H  
ATOM    840  N   GLN A  60     -38.174  75.266 117.396  1.00  0.00           N  
ATOM    841  CA  GLN A  60     -37.588  73.932 117.461  1.00  0.00           C  
ATOM    842  C   GLN A  60     -36.485  73.873 118.512  1.00  0.00           C  
ATOM    843  O   GLN A  60     -35.712  74.817 118.670  1.00  0.00           O  
ATOM    844  CB  GLN A  60     -37.030  73.530 116.095  1.00  0.00           C  
ATOM    845  CG  GLN A  60     -35.719  74.219 115.747  1.00  0.00           C  
ATOM    846  CD  GLN A  60     -35.680  74.706 114.312  1.00  0.00           C  
ATOM    847  OE1 GLN A  60     -35.257  73.982 113.410  1.00  0.00           O  
ATOM    848  NE2 GLN A  60     -36.121  75.938 114.092  1.00  0.00           N  
ATOM    849  H   GLN A  60     -37.651  76.000 117.013  1.00  0.00           H  
ATOM    850  HA  GLN A  60     -38.369  73.240 117.738  1.00  0.00           H  
ATOM    851  HB2 GLN A  60     -36.864  72.463 116.087  1.00  0.00           H  
ATOM    852  HB3 GLN A  60     -37.755  73.779 115.335  1.00  0.00           H  
ATOM    853  HG2 GLN A  60     -35.589  75.067 116.402  1.00  0.00           H  
ATOM    854  HG3 GLN A  60     -34.910  73.521 115.898  1.00  0.00           H  
ATOM    855 HE21 GLN A  60     -36.443  76.458 114.860  1.00  0.00           H  
ATOM    856 HE22 GLN A  60     -36.106  76.279 113.174  1.00  0.00           H  
ATOM    857  N   VAL A  61     -36.418  72.755 119.231  1.00  0.00           N  
ATOM    858  CA  VAL A  61     -35.410  72.572 120.267  1.00  0.00           C  
ATOM    859  C   VAL A  61     -34.538  71.355 119.977  1.00  0.00           C  
ATOM    860  O   VAL A  61     -35.036  70.235 119.862  1.00  0.00           O  
ATOM    861  CB  VAL A  61     -36.055  72.409 121.656  1.00  0.00           C  
ATOM    862  CG1 VAL A  61     -35.011  72.564 122.752  1.00  0.00           C  
ATOM    863  CG2 VAL A  61     -37.185  73.409 121.839  1.00  0.00           C  
ATOM    864  H   VAL A  61     -37.064  72.037 119.059  1.00  0.00           H  
ATOM    865  HA  VAL A  61     -34.786  73.454 120.285  1.00  0.00           H  
ATOM    866  HB  VAL A  61     -36.469  71.413 121.724  1.00  0.00           H  
ATOM    867 HG11 VAL A  61     -35.176  73.495 123.276  1.00  0.00           H  
ATOM    868 HG12 VAL A  61     -35.091  71.740 123.445  1.00  0.00           H  
ATOM    869 HG13 VAL A  61     -34.025  72.569 122.311  1.00  0.00           H  
ATOM    870 HG21 VAL A  61     -37.128  74.162 121.066  1.00  0.00           H  
ATOM    871 HG22 VAL A  61     -38.135  72.898 121.773  1.00  0.00           H  
ATOM    872 HG23 VAL A  61     -37.097  73.881 122.808  1.00  0.00           H  
ATOM    873  N   LYS A  62     -33.235  71.582 119.860  1.00  0.00           N  
ATOM    874  CA  LYS A  62     -32.292  70.505 119.584  1.00  0.00           C  
ATOM    875  C   LYS A  62     -31.074  70.600 120.498  1.00  0.00           C  
ATOM    876  O   LYS A  62     -30.561  71.684 120.777  1.00  0.00           O  
ATOM    877  CB  LYS A  62     -31.849  70.549 118.120  1.00  0.00           C  
ATOM    878  CG  LYS A  62     -31.425  71.930 117.654  1.00  0.00           C  
ATOM    879  CD  LYS A  62     -32.535  72.622 116.879  1.00  0.00           C  
ATOM    880  CE  LYS A  62     -32.485  72.269 115.401  1.00  0.00           C  
ATOM    881  NZ  LYS A  62     -33.346  71.096 115.081  1.00  0.00           N  
ATOM    882  H   LYS A  62     -32.898  72.498 119.963  1.00  0.00           H  
ATOM    883  HA  LYS A  62     -32.794  69.567 119.772  1.00  0.00           H  
ATOM    884  HB2 LYS A  62     -31.014  69.875 117.989  1.00  0.00           H  
ATOM    885  HB3 LYS A  62     -32.668  70.218 117.499  1.00  0.00           H  
ATOM    886  HG2 LYS A  62     -31.176  72.531 118.516  1.00  0.00           H  
ATOM    887  HG3 LYS A  62     -30.558  71.835 117.016  1.00  0.00           H  
ATOM    888  HD2 LYS A  62     -33.489  72.312 117.279  1.00  0.00           H  
ATOM    889  HD3 LYS A  62     -32.426  73.692 116.989  1.00  0.00           H  
ATOM    890  HE2 LYS A  62     -32.824  73.119 114.830  1.00  0.00           H  
ATOM    891  HE3 LYS A  62     -31.464  72.038 115.133  1.00  0.00           H  
ATOM    892  HZ1 LYS A  62     -32.756  70.257 114.908  1.00  0.00           H  
ATOM    893  HZ2 LYS A  62     -33.912  71.290 114.231  1.00  0.00           H  
ATOM    894  HZ3 LYS A  62     -33.988  70.898 115.874  1.00  0.00           H  
ATOM    895  N   PRO A  63     -30.599  69.440 120.976  1.00  0.00           N  
ATOM    896  CA  PRO A  63     -29.435  69.368 121.863  1.00  0.00           C  
ATOM    897  C   PRO A  63     -28.135  69.718 121.146  1.00  0.00           C  
ATOM    898  O   PRO A  63     -28.063  69.679 119.917  1.00  0.00           O  
ATOM    899  CB  PRO A  63     -29.421  67.904 122.311  1.00  0.00           C  
ATOM    900  CG  PRO A  63     -30.119  67.168 121.220  1.00  0.00           C  
ATOM    901  CD  PRO A  63     -31.161  68.111 120.686  1.00  0.00           C  
ATOM    902  HA  PRO A  63     -29.552  70.009 122.726  1.00  0.00           H  
ATOM    903  HB2 PRO A  63     -28.399  67.569 122.424  1.00  0.00           H  
ATOM    904  HB3 PRO A  63     -29.943  67.806 123.251  1.00  0.00           H  
ATOM    905  HG2 PRO A  63     -29.416  66.907 120.445  1.00  0.00           H  
ATOM    906  HG3 PRO A  63     -30.588  66.279 121.619  1.00  0.00           H  
ATOM    907  HD2 PRO A  63     -31.287  67.969 119.622  1.00  0.00           H  
ATOM    908  HD3 PRO A  63     -32.099  67.969 121.201  1.00  0.00           H  
ATOM    909  N   LEU A  64     -27.111  70.058 121.919  1.00  0.00           N  
ATOM    910  CA  LEU A  64     -25.813  70.416 121.357  1.00  0.00           C  
ATOM    911  C   LEU A  64     -24.739  69.426 121.798  1.00  0.00           C  
ATOM    912  O   LEU A  64     -24.163  68.713 120.977  1.00  0.00           O  
ATOM    913  CB  LEU A  64     -25.423  71.832 121.781  1.00  0.00           C  
ATOM    914  CG  LEU A  64     -26.578  72.814 121.986  1.00  0.00           C  
ATOM    915  CD1 LEU A  64     -26.072  74.115 122.589  1.00  0.00           C  
ATOM    916  CD2 LEU A  64     -27.294  73.077 120.669  1.00  0.00           C  
ATOM    917  H   LEU A  64     -27.229  70.072 122.892  1.00  0.00           H  
ATOM    918  HA  LEU A  64     -25.897  70.381 120.281  1.00  0.00           H  
ATOM    919  HB2 LEU A  64     -24.881  71.761 122.712  1.00  0.00           H  
ATOM    920  HB3 LEU A  64     -24.774  72.238 121.019  1.00  0.00           H  
ATOM    921  HG  LEU A  64     -27.291  72.382 122.675  1.00  0.00           H  
ATOM    922 HD11 LEU A  64     -25.712  73.931 123.590  1.00  0.00           H  
ATOM    923 HD12 LEU A  64     -26.878  74.833 122.623  1.00  0.00           H  
ATOM    924 HD13 LEU A  64     -25.268  74.504 121.982  1.00  0.00           H  
ATOM    925 HD21 LEU A  64     -28.234  72.545 120.658  1.00  0.00           H  
ATOM    926 HD22 LEU A  64     -26.677  72.734 119.850  1.00  0.00           H  
ATOM    927 HD23 LEU A  64     -27.477  74.136 120.564  1.00  0.00           H  
ATOM    928  N   GLY A  65     -24.475  69.388 123.101  1.00  0.00           N  
ATOM    929  CA  GLY A  65     -23.472  68.482 123.628  1.00  0.00           C  
ATOM    930  C   GLY A  65     -24.065  67.436 124.552  1.00  0.00           C  
ATOM    931  O   GLY A  65     -24.840  66.585 124.120  1.00  0.00           O  
ATOM    932  H   GLY A  65     -24.966  69.980 123.709  1.00  0.00           H  
ATOM    933  HA2 GLY A  65     -22.983  67.985 122.804  1.00  0.00           H  
ATOM    934  HA3 GLY A  65     -22.739  69.055 124.177  1.00  0.00           H  
ATOM    935  N   ASN A  66     -23.696  67.498 125.827  1.00  0.00           N  
ATOM    936  CA  ASN A  66     -24.194  66.547 126.814  1.00  0.00           C  
ATOM    937  C   ASN A  66     -25.717  66.596 126.896  1.00  0.00           C  
ATOM    938  O   ASN A  66     -26.409  65.790 126.275  1.00  0.00           O  
ATOM    939  CB  ASN A  66     -23.589  66.840 128.188  1.00  0.00           C  
ATOM    940  CG  ASN A  66     -24.115  65.908 129.263  1.00  0.00           C  
ATOM    941  OD1 ASN A  66     -23.719  64.745 129.340  1.00  0.00           O  
ATOM    942  ND2 ASN A  66     -25.011  66.417 130.099  1.00  0.00           N  
ATOM    943  H   ASN A  66     -23.074  68.200 126.112  1.00  0.00           H  
ATOM    944  HA  ASN A  66     -23.895  65.558 126.502  1.00  0.00           H  
ATOM    945  HB2 ASN A  66     -22.516  66.726 128.133  1.00  0.00           H  
ATOM    946  HB3 ASN A  66     -23.824  67.855 128.470  1.00  0.00           H  
ATOM    947 HD21 ASN A  66     -25.280  67.353 129.978  1.00  0.00           H  
ATOM    948 HD22 ASN A  66     -25.367  65.837 130.805  1.00  0.00           H  
ATOM    949  N   ASN A  67     -26.232  67.548 127.668  1.00  0.00           N  
ATOM    950  CA  ASN A  67     -27.672  67.703 127.832  1.00  0.00           C  
ATOM    951  C   ASN A  67     -28.090  69.158 127.635  1.00  0.00           C  
ATOM    952  O   ASN A  67     -29.079  69.613 128.207  1.00  0.00           O  
ATOM    953  CB  ASN A  67     -28.104  67.221 129.219  1.00  0.00           C  
ATOM    954  CG  ASN A  67     -29.611  67.126 129.355  1.00  0.00           C  
ATOM    955  OD1 ASN A  67     -30.317  66.843 128.387  1.00  0.00           O  
ATOM    956  ND2 ASN A  67     -30.112  67.366 130.562  1.00  0.00           N  
ATOM    957  H   ASN A  67     -25.629  68.160 128.139  1.00  0.00           H  
ATOM    958  HA  ASN A  67     -28.158  67.097 127.083  1.00  0.00           H  
ATOM    959  HB2 ASN A  67     -27.683  66.242 129.399  1.00  0.00           H  
ATOM    960  HB3 ASN A  67     -27.736  67.909 129.964  1.00  0.00           H  
ATOM    961 HD21 ASN A  67     -29.489  67.585 131.287  1.00  0.00           H  
ATOM    962 HD22 ASN A  67     -31.083  67.311 130.679  1.00  0.00           H  
ATOM    963  N   SER A  68     -27.326  69.881 126.821  1.00  0.00           N  
ATOM    964  CA  SER A  68     -27.614  71.284 126.551  1.00  0.00           C  
ATOM    965  C   SER A  68     -28.489  71.430 125.311  1.00  0.00           C  
ATOM    966  O   SER A  68     -28.146  70.940 124.234  1.00  0.00           O  
ATOM    967  CB  SER A  68     -26.312  72.067 126.366  1.00  0.00           C  
ATOM    968  OG  SER A  68     -26.565  73.457 126.247  1.00  0.00           O  
ATOM    969  H   SER A  68     -26.550  69.460 126.395  1.00  0.00           H  
ATOM    970  HA  SER A  68     -28.146  71.684 127.401  1.00  0.00           H  
ATOM    971  HB2 SER A  68     -25.672  71.902 127.218  1.00  0.00           H  
ATOM    972  HB3 SER A  68     -25.814  71.726 125.470  1.00  0.00           H  
ATOM    973  HG  SER A  68     -27.207  73.607 125.549  1.00  0.00           H  
ATOM    974  N   TRP A  69     -29.620  72.107 125.468  1.00  0.00           N  
ATOM    975  CA  TRP A  69     -30.546  72.320 124.361  1.00  0.00           C  
ATOM    976  C   TRP A  69     -30.583  73.788 123.955  1.00  0.00           C  
ATOM    977  O   TRP A  69     -30.236  74.670 124.743  1.00  0.00           O  
ATOM    978  CB  TRP A  69     -31.949  71.847 124.746  1.00  0.00           C  
ATOM    979  CG  TRP A  69     -31.994  70.419 125.193  1.00  0.00           C  
ATOM    980  CD1 TRP A  69     -31.289  69.858 126.220  1.00  0.00           C  
ATOM    981  CD2 TRP A  69     -32.783  69.367 124.626  1.00  0.00           C  
ATOM    982  NE1 TRP A  69     -31.593  68.522 126.326  1.00  0.00           N  
ATOM    983  CE2 TRP A  69     -32.507  68.197 125.360  1.00  0.00           C  
ATOM    984  CE3 TRP A  69     -33.697  69.300 123.571  1.00  0.00           C  
ATOM    985  CZ2 TRP A  69     -33.113  66.977 125.070  1.00  0.00           C  
ATOM    986  CZ3 TRP A  69     -34.298  68.089 123.285  1.00  0.00           C  
ATOM    987  CH2 TRP A  69     -34.004  66.941 124.032  1.00  0.00           C  
ATOM    988  H   TRP A  69     -29.838  72.476 126.351  1.00  0.00           H  
ATOM    989  HA  TRP A  69     -30.197  71.734 123.522  1.00  0.00           H  
ATOM    990  HB2 TRP A  69     -32.320  72.461 125.553  1.00  0.00           H  
ATOM    991  HB3 TRP A  69     -32.602  71.951 123.891  1.00  0.00           H  
ATOM    992  HD1 TRP A  69     -30.596  70.398 126.848  1.00  0.00           H  
ATOM    993  HE1 TRP A  69     -31.216  67.904 126.987  1.00  0.00           H  
ATOM    994  HE3 TRP A  69     -33.936  70.175 122.984  1.00  0.00           H  
ATOM    995  HZ2 TRP A  69     -32.898  66.083 125.637  1.00  0.00           H  
ATOM    996  HZ3 TRP A  69     -35.007  68.019 122.472  1.00  0.00           H  
ATOM    997  HH2 TRP A  69     -34.496  66.016 123.773  1.00  0.00           H  
ATOM    998  N   THR A  70     -31.007  74.047 122.723  1.00  0.00           N  
ATOM    999  CA  THR A  70     -31.089  75.410 122.212  1.00  0.00           C  
ATOM   1000  C   THR A  70     -32.385  75.631 121.441  1.00  0.00           C  
ATOM   1001  O   THR A  70     -32.969  74.689 120.905  1.00  0.00           O  
ATOM   1002  CB  THR A  70     -29.896  75.738 121.295  1.00  0.00           C  
ATOM   1003  OG1 THR A  70     -29.959  77.108 120.880  1.00  0.00           O  
ATOM   1004  CG2 THR A  70     -29.888  74.833 120.071  1.00  0.00           C  
ATOM   1005  H   THR A  70     -31.270  73.302 122.142  1.00  0.00           H  
ATOM   1006  HA  THR A  70     -31.063  76.084 123.056  1.00  0.00           H  
ATOM   1007  HB  THR A  70     -28.981  75.579 121.847  1.00  0.00           H  
ATOM   1008  HG1 THR A  70     -29.207  77.585 121.240  1.00  0.00           H  
ATOM   1009 HG21 THR A  70     -29.761  73.807 120.383  1.00  0.00           H  
ATOM   1010 HG22 THR A  70     -29.076  75.116 119.419  1.00  0.00           H  
ATOM   1011 HG23 THR A  70     -30.825  74.935 119.544  1.00  0.00           H  
ATOM   1012  N   LEU A  71     -32.829  76.883 121.388  1.00  0.00           N  
ATOM   1013  CA  LEU A  71     -34.058  77.228 120.680  1.00  0.00           C  
ATOM   1014  C   LEU A  71     -33.752  78.026 119.417  1.00  0.00           C  
ATOM   1015  O   LEU A  71     -33.120  79.081 119.476  1.00  0.00           O  
ATOM   1016  CB  LEU A  71     -34.985  78.032 121.593  1.00  0.00           C  
ATOM   1017  CG  LEU A  71     -36.062  77.233 122.328  1.00  0.00           C  
ATOM   1018  CD1 LEU A  71     -37.116  76.734 121.351  1.00  0.00           C  
ATOM   1019  CD2 LEU A  71     -35.439  76.069 123.084  1.00  0.00           C  
ATOM   1020  H   LEU A  71     -32.320  77.591 121.834  1.00  0.00           H  
ATOM   1021  HA  LEU A  71     -34.549  76.309 120.401  1.00  0.00           H  
ATOM   1022  HB2 LEU A  71     -34.375  78.524 122.335  1.00  0.00           H  
ATOM   1023  HB3 LEU A  71     -35.481  78.777 120.986  1.00  0.00           H  
ATOM   1024  HG  LEU A  71     -36.552  77.876 123.045  1.00  0.00           H  
ATOM   1025 HD11 LEU A  71     -36.638  76.166 120.566  1.00  0.00           H  
ATOM   1026 HD12 LEU A  71     -37.635  77.577 120.920  1.00  0.00           H  
ATOM   1027 HD13 LEU A  71     -37.822  76.105 121.873  1.00  0.00           H  
ATOM   1028 HD21 LEU A  71     -34.912  75.430 122.390  1.00  0.00           H  
ATOM   1029 HD22 LEU A  71     -36.217  75.501 123.574  1.00  0.00           H  
ATOM   1030 HD23 LEU A  71     -34.749  76.447 123.822  1.00  0.00           H  
ATOM   1031  N   GLU A  72     -34.206  77.515 118.277  1.00  0.00           N  
ATOM   1032  CA  GLU A  72     -33.981  78.183 116.999  1.00  0.00           C  
ATOM   1033  C   GLU A  72     -35.304  78.462 116.292  1.00  0.00           C  
ATOM   1034  O   GLU A  72     -36.327  77.832 116.562  1.00  0.00           O  
ATOM   1035  CB  GLU A  72     -33.082  77.327 116.104  1.00  0.00           C  
ATOM   1036  CG  GLU A  72     -31.614  77.716 116.168  1.00  0.00           C  
ATOM   1037  CD  GLU A  72     -30.850  76.932 117.218  1.00  0.00           C  
ATOM   1038  OE1 GLU A  72     -30.878  75.685 117.164  1.00  0.00           O  
ATOM   1039  OE2 GLU A  72     -30.222  77.566 118.092  1.00  0.00           O  
ATOM   1040  H   GLU A  72     -34.703  76.671 118.294  1.00  0.00           H  
ATOM   1041  HA  GLU A  72     -33.488  79.122 117.198  1.00  0.00           H  
ATOM   1042  HB2 GLU A  72     -33.173  76.294 116.403  1.00  0.00           H  
ATOM   1043  HB3 GLU A  72     -33.414  77.427 115.081  1.00  0.00           H  
ATOM   1044  HG2 GLU A  72     -31.164  77.531 115.205  1.00  0.00           H  
ATOM   1045  HG3 GLU A  72     -31.543  78.768 116.402  1.00  0.00           H  
ATOM   1046  N   PRO A  73     -35.285  79.430 115.364  1.00  0.00           N  
ATOM   1047  CA  PRO A  73     -36.474  79.815 114.598  1.00  0.00           C  
ATOM   1048  C   PRO A  73     -36.900  78.739 113.607  1.00  0.00           C  
ATOM   1049  O   PRO A  73     -36.120  78.332 112.745  1.00  0.00           O  
ATOM   1050  CB  PRO A  73     -36.025  81.078 113.857  1.00  0.00           C  
ATOM   1051  CG  PRO A  73     -34.545  80.946 113.750  1.00  0.00           C  
ATOM   1052  CD  PRO A  73     -34.102  80.223 114.990  1.00  0.00           C  
ATOM   1053  HA  PRO A  73     -37.305  80.054 115.247  1.00  0.00           H  
ATOM   1054  HB2 PRO A  73     -36.491  81.110 112.882  1.00  0.00           H  
ATOM   1055  HB3 PRO A  73     -36.304  81.952 114.425  1.00  0.00           H  
ATOM   1056  HG2 PRO A  73     -34.290  80.375 112.870  1.00  0.00           H  
ATOM   1057  HG3 PRO A  73     -34.093  81.927 113.705  1.00  0.00           H  
ATOM   1058  HD2 PRO A  73     -33.262  79.581 114.773  1.00  0.00           H  
ATOM   1059  HD3 PRO A  73     -33.850  80.927 115.769  1.00  0.00           H  
ATOM   1060  N   ALA A  74     -38.141  78.281 113.733  1.00  0.00           N  
ATOM   1061  CA  ALA A  74     -38.671  77.253 112.845  1.00  0.00           C  
ATOM   1062  C   ALA A  74     -39.731  77.826 111.912  1.00  0.00           C  
ATOM   1063  O   ALA A  74     -40.310  78.883 112.165  1.00  0.00           O  
ATOM   1064  CB  ALA A  74     -39.246  76.101 113.657  1.00  0.00           C  
ATOM   1065  H   ALA A  74     -38.715  78.645 114.439  1.00  0.00           H  
ATOM   1066  HA  ALA A  74     -37.852  76.870 112.253  1.00  0.00           H  
ATOM   1067  HB1 ALA A  74     -38.688  75.200 113.446  1.00  0.00           H  
ATOM   1068  HB2 ALA A  74     -39.175  76.331 114.709  1.00  0.00           H  
ATOM   1069  HB3 ALA A  74     -40.281  75.955 113.390  1.00  0.00           H  
ATOM   1070  N   PRO A  75     -39.994  77.114 110.806  1.00  0.00           N  
ATOM   1071  CA  PRO A  75     -40.986  77.534 109.812  1.00  0.00           C  
ATOM   1072  C   PRO A  75     -42.414  77.428 110.337  1.00  0.00           C  
ATOM   1073  O   PRO A  75     -42.763  76.468 111.024  1.00  0.00           O  
ATOM   1074  CB  PRO A  75     -40.768  76.553 108.657  1.00  0.00           C  
ATOM   1075  CG  PRO A  75     -40.176  75.344 109.294  1.00  0.00           C  
ATOM   1076  CD  PRO A  75     -39.343  75.845 110.440  1.00  0.00           C  
ATOM   1077  HA  PRO A  75     -40.804  78.542 109.470  1.00  0.00           H  
ATOM   1078  HB2 PRO A  75     -41.715  76.331 108.186  1.00  0.00           H  
ATOM   1079  HB3 PRO A  75     -40.094  76.988 107.933  1.00  0.00           H  
ATOM   1080  HG2 PRO A  75     -40.962  74.697 109.654  1.00  0.00           H  
ATOM   1081  HG3 PRO A  75     -39.555  74.821 108.581  1.00  0.00           H  
ATOM   1082  HD2 PRO A  75     -39.373  75.146 111.262  1.00  0.00           H  
ATOM   1083  HD3 PRO A  75     -38.324  76.013 110.122  1.00  0.00           H  
ATOM   1084  N   ALA A  76     -43.235  78.421 110.010  1.00  0.00           N  
ATOM   1085  CA  ALA A  76     -44.626  78.436 110.447  1.00  0.00           C  
ATOM   1086  C   ALA A  76     -45.541  78.958 109.345  1.00  0.00           C  
ATOM   1087  O   ALA A  76     -45.106  79.625 108.407  1.00  0.00           O  
ATOM   1088  CB  ALA A  76     -44.774  79.282 111.703  1.00  0.00           C  
ATOM   1089  H   ALA A  76     -42.898  79.158 109.460  1.00  0.00           H  
ATOM   1090  HA  ALA A  76     -44.912  77.423 110.689  1.00  0.00           H  
ATOM   1091  HB1 ALA A  76     -43.905  79.915 111.814  1.00  0.00           H  
ATOM   1092  HB2 ALA A  76     -45.659  79.894 111.622  1.00  0.00           H  
ATOM   1093  HB3 ALA A  76     -44.860  78.635 112.563  1.00  0.00           H  
ATOM   1094  N   PRO A  77     -46.842  78.649 109.459  1.00  0.00           N  
ATOM   1095  CA  PRO A  77     -47.846  79.076 108.480  1.00  0.00           C  
ATOM   1096  C   PRO A  77     -48.099  80.580 108.529  1.00  0.00           C  
ATOM   1097  O   PRO A  77     -47.677  81.261 109.463  1.00  0.00           O  
ATOM   1098  CB  PRO A  77     -49.102  78.309 108.902  1.00  0.00           C  
ATOM   1099  CG  PRO A  77     -48.911  78.040 110.355  1.00  0.00           C  
ATOM   1100  CD  PRO A  77     -47.431  77.857 110.552  1.00  0.00           C  
ATOM   1101  HA  PRO A  77     -47.568  78.792 107.476  1.00  0.00           H  
ATOM   1102  HB2 PRO A  77     -49.976  78.919 108.724  1.00  0.00           H  
ATOM   1103  HB3 PRO A  77     -49.174  77.392 108.337  1.00  0.00           H  
ATOM   1104  HG2 PRO A  77     -49.265  78.880 110.933  1.00  0.00           H  
ATOM   1105  HG3 PRO A  77     -49.440  77.140 110.634  1.00  0.00           H  
ATOM   1106  HD2 PRO A  77     -47.128  78.243 111.514  1.00  0.00           H  
ATOM   1107  HD3 PRO A  77     -47.164  76.815 110.459  1.00  0.00           H  
ATOM   1108  N   LYS A  78     -48.791  81.091 107.516  1.00  0.00           N  
ATOM   1109  CA  LYS A  78     -49.103  82.514 107.444  1.00  0.00           C  
ATOM   1110  C   LYS A  78     -49.767  82.992 108.732  1.00  0.00           C  
ATOM   1111  O   LYS A  78     -50.945  82.727 108.968  1.00  0.00           O  
ATOM   1112  CB  LYS A  78     -50.018  82.796 106.250  1.00  0.00           C  
ATOM   1113  CG  LYS A  78     -50.427  84.254 106.129  1.00  0.00           C  
ATOM   1114  CD  LYS A  78     -49.249  85.131 105.739  1.00  0.00           C  
ATOM   1115  CE  LYS A  78     -49.406  86.545 106.279  1.00  0.00           C  
ATOM   1116  NZ  LYS A  78     -49.189  86.603 107.751  1.00  0.00           N  
ATOM   1117  H   LYS A  78     -49.101  80.496 106.802  1.00  0.00           H  
ATOM   1118  HA  LYS A  78     -48.176  83.050 107.311  1.00  0.00           H  
ATOM   1119  HB2 LYS A  78     -49.506  82.510 105.344  1.00  0.00           H  
ATOM   1120  HB3 LYS A  78     -50.915  82.200 106.351  1.00  0.00           H  
ATOM   1121  HG2 LYS A  78     -51.192  84.341 105.372  1.00  0.00           H  
ATOM   1122  HG3 LYS A  78     -50.816  84.590 107.079  1.00  0.00           H  
ATOM   1123  HD2 LYS A  78     -48.343  84.703 106.140  1.00  0.00           H  
ATOM   1124  HD3 LYS A  78     -49.183  85.172 104.661  1.00  0.00           H  
ATOM   1125  HE2 LYS A  78     -48.684  87.184 105.792  1.00  0.00           H  
ATOM   1126  HE3 LYS A  78     -50.403  86.893 106.056  1.00  0.00           H  
ATOM   1127  HZ1 LYS A  78     -48.533  85.852 108.045  1.00  0.00           H  
ATOM   1128  HZ2 LYS A  78     -50.092  86.475 108.250  1.00  0.00           H  
ATOM   1129  HZ3 LYS A  78     -48.786  87.524 108.017  1.00  0.00           H  
ATOM   1130  N   GLU A  79     -49.003  83.698 109.559  1.00  0.00           N  
ATOM   1131  CA  GLU A  79     -49.520  84.214 110.822  1.00  0.00           C  
ATOM   1132  C   GLU A  79     -50.808  85.002 110.602  1.00  0.00           C  
ATOM   1133  O   GLU A  79     -51.078  85.473 109.497  1.00  0.00           O  
ATOM   1134  CB  GLU A  79     -48.475  85.101 111.501  1.00  0.00           C  
ATOM   1135  CG  GLU A  79     -47.323  84.325 112.116  1.00  0.00           C  
ATOM   1136  CD  GLU A  79     -46.378  85.209 112.905  1.00  0.00           C  
ATOM   1137  OE1 GLU A  79     -45.925  86.233 112.352  1.00  0.00           O  
ATOM   1138  OE2 GLU A  79     -46.091  84.878 114.074  1.00  0.00           O  
ATOM   1139  H   GLU A  79     -48.071  83.877 109.315  1.00  0.00           H  
ATOM   1140  HA  GLU A  79     -49.733  83.370 111.461  1.00  0.00           H  
ATOM   1141  HB2 GLU A  79     -48.071  85.786 110.769  1.00  0.00           H  
ATOM   1142  HB3 GLU A  79     -48.958  85.668 112.284  1.00  0.00           H  
ATOM   1143  HG2 GLU A  79     -47.725  83.573 112.779  1.00  0.00           H  
ATOM   1144  HG3 GLU A  79     -46.767  83.844 111.324  1.00  0.00           H  
ATOM   1145  N   ASP A  80     -51.598  85.140 111.661  1.00  0.00           N  
ATOM   1146  CA  ASP A  80     -52.858  85.870 111.585  1.00  0.00           C  
ATOM   1147  C   ASP A  80     -53.018  86.802 112.782  1.00  0.00           C  
ATOM   1148  O   ASP A  80     -52.142  86.879 113.644  1.00  0.00           O  
ATOM   1149  CB  ASP A  80     -54.034  84.896 111.520  1.00  0.00           C  
ATOM   1150  CG  ASP A  80     -54.248  84.340 110.126  1.00  0.00           C  
ATOM   1151  OD1 ASP A  80     -55.004  84.960 109.348  1.00  0.00           O  
ATOM   1152  OD2 ASP A  80     -53.660  83.284 109.812  1.00  0.00           O  
ATOM   1153  H   ASP A  80     -51.327  84.740 112.514  1.00  0.00           H  
ATOM   1154  HA  ASP A  80     -52.843  86.463 110.683  1.00  0.00           H  
ATOM   1155  HB2 ASP A  80     -53.847  84.071 112.192  1.00  0.00           H  
ATOM   1156  HB3 ASP A  80     -54.934  85.408 111.827  1.00  0.00           H  
ATOM   1157  N   ALA A  81     -54.143  87.509 112.829  1.00  0.00           N  
ATOM   1158  CA  ALA A  81     -54.418  88.434 113.922  1.00  0.00           C  
ATOM   1159  C   ALA A  81     -55.543  87.915 114.810  1.00  0.00           C  
ATOM   1160  O   ALA A  81     -56.606  87.527 114.322  1.00  0.00           O  
ATOM   1161  CB  ALA A  81     -54.768  89.809 113.372  1.00  0.00           C  
ATOM   1162  H   ALA A  81     -54.803  87.404 112.113  1.00  0.00           H  
ATOM   1163  HA  ALA A  81     -53.519  88.529 114.513  1.00  0.00           H  
ATOM   1164  HB1 ALA A  81     -54.699  90.540 114.164  1.00  0.00           H  
ATOM   1165  HB2 ALA A  81     -54.079  90.067 112.581  1.00  0.00           H  
ATOM   1166  HB3 ALA A  81     -55.775  89.794 112.981  1.00  0.00           H  
ATOM   1167  N   LEU A  82     -55.304  87.910 116.117  1.00  0.00           N  
ATOM   1168  CA  LEU A  82     -56.298  87.438 117.075  1.00  0.00           C  
ATOM   1169  C   LEU A  82     -57.314  88.530 117.388  1.00  0.00           C  
ATOM   1170  O   LEU A  82     -57.045  89.718 117.199  1.00  0.00           O  
ATOM   1171  CB  LEU A  82     -55.614  86.976 118.363  1.00  0.00           C  
ATOM   1172  CG  LEU A  82     -55.068  85.548 118.358  1.00  0.00           C  
ATOM   1173  CD1 LEU A  82     -56.192  84.547 118.146  1.00  0.00           C  
ATOM   1174  CD2 LEU A  82     -54.000  85.390 117.285  1.00  0.00           C  
ATOM   1175  H   LEU A  82     -54.439  88.231 116.446  1.00  0.00           H  
ATOM   1176  HA  LEU A  82     -56.814  86.600 116.630  1.00  0.00           H  
ATOM   1177  HB2 LEU A  82     -54.790  87.645 118.557  1.00  0.00           H  
ATOM   1178  HB3 LEU A  82     -56.335  87.053 119.165  1.00  0.00           H  
ATOM   1179  HG  LEU A  82     -54.612  85.341 119.317  1.00  0.00           H  
ATOM   1180 HD11 LEU A  82     -57.125  84.978 118.476  1.00  0.00           H  
ATOM   1181 HD12 LEU A  82     -55.988  83.651 118.714  1.00  0.00           H  
ATOM   1182 HD13 LEU A  82     -56.260  84.299 117.097  1.00  0.00           H  
ATOM   1183 HD21 LEU A  82     -53.255  84.683 117.621  1.00  0.00           H  
ATOM   1184 HD22 LEU A  82     -53.531  86.345 117.100  1.00  0.00           H  
ATOM   1185 HD23 LEU A  82     -54.454  85.028 116.376  1.00  0.00           H  
ATOM   1186  N   THR A  83     -58.484  88.123 117.872  1.00  0.00           N  
ATOM   1187  CA  THR A  83     -59.541  89.066 118.212  1.00  0.00           C  
ATOM   1188  C   THR A  83     -59.024  90.158 119.143  1.00  0.00           C  
ATOM   1189  O   THR A  83     -58.035  89.967 119.851  1.00  0.00           O  
ATOM   1190  CB  THR A  83     -60.732  88.357 118.883  1.00  0.00           C  
ATOM   1191  OG1 THR A  83     -61.690  89.325 119.328  1.00  0.00           O  
ATOM   1192  CG2 THR A  83     -60.267  87.516 120.063  1.00  0.00           C  
ATOM   1193  H   THR A  83     -58.639  87.164 118.000  1.00  0.00           H  
ATOM   1194  HA  THR A  83     -59.889  89.523 117.297  1.00  0.00           H  
ATOM   1195  HB  THR A  83     -61.199  87.707 118.158  1.00  0.00           H  
ATOM   1196  HG1 THR A  83     -62.532  88.891 119.488  1.00  0.00           H  
ATOM   1197 HG21 THR A  83     -59.453  88.018 120.564  1.00  0.00           H  
ATOM   1198 HG22 THR A  83     -59.932  86.553 119.707  1.00  0.00           H  
ATOM   1199 HG23 THR A  83     -61.086  87.381 120.752  1.00  0.00           H  
ATOM   1200  N   VAL A  84     -59.700  91.302 119.139  1.00  0.00           N  
ATOM   1201  CA  VAL A  84     -59.310  92.424 119.985  1.00  0.00           C  
ATOM   1202  C   VAL A  84     -59.865  92.268 121.396  1.00  0.00           C  
ATOM   1203  O   VAL A  84     -61.055  92.009 121.581  1.00  0.00           O  
ATOM   1204  CB  VAL A  84     -59.795  93.764 119.399  1.00  0.00           C  
ATOM   1205  CG1 VAL A  84     -59.346  94.923 120.276  1.00  0.00           C  
ATOM   1206  CG2 VAL A  84     -59.291  93.935 117.974  1.00  0.00           C  
ATOM   1207  H   VAL A  84     -60.481  91.394 118.553  1.00  0.00           H  
ATOM   1208  HA  VAL A  84     -58.231  92.447 120.033  1.00  0.00           H  
ATOM   1209  HB  VAL A  84     -60.875  93.754 119.378  1.00  0.00           H  
ATOM   1210 HG11 VAL A  84     -60.213  95.461 120.631  1.00  0.00           H  
ATOM   1211 HG12 VAL A  84     -58.787  94.543 121.117  1.00  0.00           H  
ATOM   1212 HG13 VAL A  84     -58.722  95.590 119.698  1.00  0.00           H  
ATOM   1213 HG21 VAL A  84     -59.619  93.100 117.374  1.00  0.00           H  
ATOM   1214 HG22 VAL A  84     -59.686  94.853 117.560  1.00  0.00           H  
ATOM   1215 HG23 VAL A  84     -58.212  93.977 117.976  1.00  0.00           H  
ATOM   1216  N   VAL A  85     -58.996  92.426 122.389  1.00  0.00           N  
ATOM   1217  CA  VAL A  85     -59.400  92.305 123.785  1.00  0.00           C  
ATOM   1218  C   VAL A  85     -60.460  93.340 124.143  1.00  0.00           C  
ATOM   1219  O   VAL A  85     -60.410  94.480 123.682  1.00  0.00           O  
ATOM   1220  CB  VAL A  85     -58.197  92.468 124.733  1.00  0.00           C  
ATOM   1221  CG1 VAL A  85     -58.600  92.154 126.166  1.00  0.00           C  
ATOM   1222  CG2 VAL A  85     -57.045  91.580 124.288  1.00  0.00           C  
ATOM   1223  H   VAL A  85     -58.061  92.631 122.178  1.00  0.00           H  
ATOM   1224  HA  VAL A  85     -59.813  91.316 123.928  1.00  0.00           H  
ATOM   1225  HB  VAL A  85     -57.869  93.496 124.691  1.00  0.00           H  
ATOM   1226 HG11 VAL A  85     -58.945  91.133 126.227  1.00  0.00           H  
ATOM   1227 HG12 VAL A  85     -57.750  92.288 126.817  1.00  0.00           H  
ATOM   1228 HG13 VAL A  85     -59.395  92.820 126.470  1.00  0.00           H  
ATOM   1229 HG21 VAL A  85     -56.343  92.164 123.711  1.00  0.00           H  
ATOM   1230 HG22 VAL A  85     -56.545  91.175 125.157  1.00  0.00           H  
ATOM   1231 HG23 VAL A  85     -57.425  90.772 123.683  1.00  0.00           H  
ATOM   1232  N   GLY A  86     -61.420  92.935 124.969  1.00  0.00           N  
ATOM   1233  CA  GLY A  86     -62.479  93.841 125.375  1.00  0.00           C  
ATOM   1234  C   GLY A  86     -62.037  94.796 126.466  1.00  0.00           C  
ATOM   1235  O   GLY A  86     -61.046  95.510 126.311  1.00  0.00           O  
ATOM   1236  H   GLY A  86     -61.409  92.014 125.305  1.00  0.00           H  
ATOM   1237  HA2 GLY A  86     -62.798  94.412 124.517  1.00  0.00           H  
ATOM   1238  HA3 GLY A  86     -63.314  93.260 125.740  1.00  0.00           H  
ATOM   1239  N   ASP A  87     -62.774  94.812 127.571  1.00  0.00           N  
ATOM   1240  CA  ASP A  87     -62.453  95.689 128.691  1.00  0.00           C  
ATOM   1241  C   ASP A  87     -62.713  94.987 130.022  1.00  0.00           C  
ATOM   1242  O   ASP A  87     -63.228  93.869 130.055  1.00  0.00           O  
ATOM   1243  CB  ASP A  87     -63.276  96.976 128.612  1.00  0.00           C  
ATOM   1244  CG  ASP A  87     -62.576  98.151 129.265  1.00  0.00           C  
ATOM   1245  OD1 ASP A  87     -61.366  98.335 129.016  1.00  0.00           O  
ATOM   1246  OD2 ASP A  87     -63.239  98.887 130.025  1.00  0.00           O  
ATOM   1247  H   ASP A  87     -63.552  94.219 127.635  1.00  0.00           H  
ATOM   1248  HA  ASP A  87     -61.405  95.937 128.628  1.00  0.00           H  
ATOM   1249  HB2 ASP A  87     -63.452  97.219 127.574  1.00  0.00           H  
ATOM   1250  HB3 ASP A  87     -64.223  96.822 129.108  1.00  0.00           H  
ATOM   1251  N   TRP A  88     -62.350  95.650 131.114  1.00  0.00           N  
ATOM   1252  CA  TRP A  88     -62.542  95.089 132.446  1.00  0.00           C  
ATOM   1253  C   TRP A  88     -63.889  95.507 133.024  1.00  0.00           C  
ATOM   1254  O   TRP A  88     -64.734  96.061 132.319  1.00  0.00           O  
ATOM   1255  CB  TRP A  88     -61.413  95.534 133.377  1.00  0.00           C  
ATOM   1256  CG  TRP A  88     -60.079  95.612 132.699  1.00  0.00           C  
ATOM   1257  CD1 TRP A  88     -59.350  96.739 132.451  1.00  0.00           C  
ATOM   1258  CD2 TRP A  88     -59.317  94.516 132.180  1.00  0.00           C  
ATOM   1259  NE1 TRP A  88     -58.180  96.411 131.810  1.00  0.00           N  
ATOM   1260  CE2 TRP A  88     -58.136  95.053 131.632  1.00  0.00           C  
ATOM   1261  CE3 TRP A  88     -59.517  93.134 132.126  1.00  0.00           C  
ATOM   1262  CZ2 TRP A  88     -57.161  94.256 131.039  1.00  0.00           C  
ATOM   1263  CZ3 TRP A  88     -58.549  92.344 131.537  1.00  0.00           C  
ATOM   1264  CH2 TRP A  88     -57.383  92.906 131.000  1.00  0.00           C  
ATOM   1265  H   TRP A  88     -61.944  96.537 131.023  1.00  0.00           H  
ATOM   1266  HA  TRP A  88     -62.520  94.012 132.359  1.00  0.00           H  
ATOM   1267  HB2 TRP A  88     -61.645  96.513 133.770  1.00  0.00           H  
ATOM   1268  HB3 TRP A  88     -61.333  94.833 134.195  1.00  0.00           H  
ATOM   1269  HD1 TRP A  88     -59.661  97.736 132.724  1.00  0.00           H  
ATOM   1270  HE1 TRP A  88     -57.489  97.046 131.526  1.00  0.00           H  
ATOM   1271  HE3 TRP A  88     -60.409  92.682 132.536  1.00  0.00           H  
ATOM   1272  HZ2 TRP A  88     -56.257  94.673 130.620  1.00  0.00           H  
ATOM   1273  HZ3 TRP A  88     -58.686  91.273 131.487  1.00  0.00           H  
ATOM   1274  HH2 TRP A  88     -56.654  92.251 130.549  1.00  0.00           H  
ATOM   1275  N   LEU A  89     -64.086  95.240 134.311  1.00  0.00           N  
ATOM   1276  CA  LEU A  89     -65.332  95.590 134.983  1.00  0.00           C  
ATOM   1277  C   LEU A  89     -65.372  97.077 135.316  1.00  0.00           C  
ATOM   1278  O   LEU A  89     -66.396  97.736 135.138  1.00  0.00           O  
ATOM   1279  CB  LEU A  89     -65.493  94.765 136.262  1.00  0.00           C  
ATOM   1280  CG  LEU A  89     -66.220  93.429 136.112  1.00  0.00           C  
ATOM   1281  CD1 LEU A  89     -65.260  92.349 135.640  1.00  0.00           C  
ATOM   1282  CD2 LEU A  89     -66.874  93.027 137.426  1.00  0.00           C  
ATOM   1283  H   LEU A  89     -63.376  94.797 134.820  1.00  0.00           H  
ATOM   1284  HA  LEU A  89     -66.146  95.361 134.313  1.00  0.00           H  
ATOM   1285  HB2 LEU A  89     -64.507  94.563 136.651  1.00  0.00           H  
ATOM   1286  HB3 LEU A  89     -66.042  95.365 136.974  1.00  0.00           H  
ATOM   1287  HG  LEU A  89     -66.999  93.532 135.368  1.00  0.00           H  
ATOM   1288 HD11 LEU A  89     -64.946  92.563 134.630  1.00  0.00           H  
ATOM   1289 HD12 LEU A  89     -65.756  91.390 135.667  1.00  0.00           H  
ATOM   1290 HD13 LEU A  89     -64.398  92.325 136.289  1.00  0.00           H  
ATOM   1291 HD21 LEU A  89     -66.365  93.515 138.245  1.00  0.00           H  
ATOM   1292 HD22 LEU A  89     -66.808  91.956 137.549  1.00  0.00           H  
ATOM   1293 HD23 LEU A  89     -67.912  93.327 137.419  1.00  0.00           H  
ATOM   1294  N   GLY A  90     -64.249  97.602 135.796  1.00  0.00           N  
ATOM   1295  CA  GLY A  90     -64.177  99.010 136.145  1.00  0.00           C  
ATOM   1296  C   GLY A  90     -65.309  99.440 137.057  1.00  0.00           C  
ATOM   1297  O   GLY A  90     -66.320  99.969 136.595  1.00  0.00           O  
ATOM   1298  H   GLY A  90     -63.463  97.029 135.917  1.00  0.00           H  
ATOM   1299  HA2 GLY A  90     -63.236  99.199 136.640  1.00  0.00           H  
ATOM   1300  HA3 GLY A  90     -64.219  99.595 135.237  1.00  0.00           H  
ATOM   1301  N   ASP A  91     -65.138  99.214 138.355  1.00  0.00           N  
ATOM   1302  CA  ASP A  91     -66.154  99.581 139.334  1.00  0.00           C  
ATOM   1303  C   ASP A  91     -65.668 100.725 140.218  1.00  0.00           C  
ATOM   1304  O   ASP A  91     -65.827 100.691 141.438  1.00  0.00           O  
ATOM   1305  CB  ASP A  91     -66.520  98.373 140.198  1.00  0.00           C  
ATOM   1306  CG  ASP A  91     -65.300  97.603 140.665  1.00  0.00           C  
ATOM   1307  OD1 ASP A  91     -64.672  96.923 139.827  1.00  0.00           O  
ATOM   1308  OD2 ASP A  91     -64.974  97.683 141.868  1.00  0.00           O  
ATOM   1309  H   ASP A  91     -64.310  98.789 138.661  1.00  0.00           H  
ATOM   1310  HA  ASP A  91     -67.031  99.907 138.796  1.00  0.00           H  
ATOM   1311  HB2 ASP A  91     -67.064  98.712 141.068  1.00  0.00           H  
ATOM   1312  HB3 ASP A  91     -67.148  97.706 139.625  1.00  0.00           H  
ATOM   1313  N   ALA A  92     -65.072 101.736 139.594  1.00  0.00           N  
ATOM   1314  CA  ALA A  92     -64.563 102.891 140.323  1.00  0.00           C  
ATOM   1315  C   ALA A  92     -65.621 103.983 140.429  1.00  0.00           C  
ATOM   1316  O   ALA A  92     -66.693 103.884 139.830  1.00  0.00           O  
ATOM   1317  CB  ALA A  92     -63.310 103.430 139.649  1.00  0.00           C  
ATOM   1318  H   ALA A  92     -64.975 101.705 138.619  1.00  0.00           H  
ATOM   1319  HA  ALA A  92     -64.295 102.566 141.318  1.00  0.00           H  
ATOM   1320  HB1 ALA A  92     -63.047 104.381 140.089  1.00  0.00           H  
ATOM   1321  HB2 ALA A  92     -62.499 102.733 139.788  1.00  0.00           H  
ATOM   1322  HB3 ALA A  92     -63.497 103.561 138.594  1.00  0.00           H  
ATOM   1323  N   ARG A  93     -65.314 105.026 141.194  1.00  0.00           N  
ATOM   1324  CA  ARG A  93     -66.241 106.136 141.379  1.00  0.00           C  
ATOM   1325  C   ARG A  93     -65.614 107.450 140.920  1.00  0.00           C  
ATOM   1326  O   ARG A  93     -64.393 107.560 140.807  1.00  0.00           O  
ATOM   1327  CB  ARG A  93     -66.656 106.243 142.848  1.00  0.00           C  
ATOM   1328  CG  ARG A  93     -65.487 106.174 143.817  1.00  0.00           C  
ATOM   1329  CD  ARG A  93     -65.960 106.191 145.262  1.00  0.00           C  
ATOM   1330  NE  ARG A  93     -67.026 105.222 145.501  1.00  0.00           N  
ATOM   1331  CZ  ARG A  93     -66.814 103.921 145.660  1.00  0.00           C  
ATOM   1332  NH1 ARG A  93     -65.581 103.435 145.608  1.00  0.00           N  
ATOM   1333  NH2 ARG A  93     -67.836 103.103 145.873  1.00  0.00           N  
ATOM   1334  H   ARG A  93     -64.446 105.049 141.645  1.00  0.00           H  
ATOM   1335  HA  ARG A  93     -67.118 105.942 140.780  1.00  0.00           H  
ATOM   1336  HB2 ARG A  93     -67.165 107.184 142.999  1.00  0.00           H  
ATOM   1337  HB3 ARG A  93     -67.334 105.435 143.077  1.00  0.00           H  
ATOM   1338  HG2 ARG A  93     -64.938 105.260 143.640  1.00  0.00           H  
ATOM   1339  HG3 ARG A  93     -64.841 107.023 143.648  1.00  0.00           H  
ATOM   1340  HD2 ARG A  93     -65.124 105.956 145.904  1.00  0.00           H  
ATOM   1341  HD3 ARG A  93     -66.326 107.180 145.495  1.00  0.00           H  
ATOM   1342  HE  ARG A  93     -67.945 105.560 145.544  1.00  0.00           H  
ATOM   1343 HH11 ARG A  93     -64.809 104.050 145.448  1.00  0.00           H  
ATOM   1344 HH12 ARG A  93     -65.424 102.454 145.729  1.00  0.00           H  
ATOM   1345 HH21 ARG A  93     -68.767 103.465 145.915  1.00  0.00           H  
ATOM   1346 HH22 ARG A  93     -67.675 102.122 145.993  1.00  0.00           H  
ATOM   1347  N   GLU A  94     -66.458 108.442 140.657  1.00  0.00           N  
ATOM   1348  CA  GLU A  94     -65.986 109.748 140.208  1.00  0.00           C  
ATOM   1349  C   GLU A  94     -66.491 110.854 141.129  1.00  0.00           C  
ATOM   1350  O   GLU A  94     -67.573 110.751 141.705  1.00  0.00           O  
ATOM   1351  CB  GLU A  94     -66.442 110.014 138.773  1.00  0.00           C  
ATOM   1352  CG  GLU A  94     -65.957 108.975 137.776  1.00  0.00           C  
ATOM   1353  CD  GLU A  94     -66.133 109.419 136.337  1.00  0.00           C  
ATOM   1354  OE1 GLU A  94     -65.945 110.623 136.060  1.00  0.00           O  
ATOM   1355  OE2 GLU A  94     -66.460 108.564 135.487  1.00  0.00           O  
ATOM   1356  H   GLU A  94     -67.421 108.294 140.765  1.00  0.00           H  
ATOM   1357  HA  GLU A  94     -64.907 109.737 140.236  1.00  0.00           H  
ATOM   1358  HB2 GLU A  94     -67.522 110.031 138.748  1.00  0.00           H  
ATOM   1359  HB3 GLU A  94     -66.070 110.980 138.463  1.00  0.00           H  
ATOM   1360  HG2 GLU A  94     -64.908 108.788 137.952  1.00  0.00           H  
ATOM   1361  HG3 GLU A  94     -66.515 108.063 137.927  1.00  0.00           H  
ATOM   1362  N   ASN A  95     -65.699 111.914 141.260  1.00  0.00           N  
ATOM   1363  CA  ASN A  95     -66.066 113.041 142.111  1.00  0.00           C  
ATOM   1364  C   ASN A  95     -66.307 114.296 141.278  1.00  0.00           C  
ATOM   1365  O   ASN A  95     -65.646 114.514 140.262  1.00  0.00           O  
ATOM   1366  CB  ASN A  95     -64.969 113.303 143.145  1.00  0.00           C  
ATOM   1367  CG  ASN A  95     -65.162 112.492 144.412  1.00  0.00           C  
ATOM   1368  OD1 ASN A  95     -65.920 112.880 145.301  1.00  0.00           O  
ATOM   1369  ND2 ASN A  95     -64.476 111.358 144.499  1.00  0.00           N  
ATOM   1370  H   ASN A  95     -64.849 111.939 140.774  1.00  0.00           H  
ATOM   1371  HA  ASN A  95     -66.980 112.784 142.625  1.00  0.00           H  
ATOM   1372  HB2 ASN A  95     -64.011 113.045 142.718  1.00  0.00           H  
ATOM   1373  HB3 ASN A  95     -64.972 114.351 143.406  1.00  0.00           H  
ATOM   1374 HD21 ASN A  95     -63.892 111.113 143.752  1.00  0.00           H  
ATOM   1375 HD22 ASN A  95     -64.583 110.814 145.307  1.00  0.00           H  
ATOM   1376  N   ASP A  96     -67.254 115.117 141.715  1.00  0.00           N  
ATOM   1377  CA  ASP A  96     -67.581 116.351 141.012  1.00  0.00           C  
ATOM   1378  C   ASP A  96     -66.485 117.395 141.208  1.00  0.00           C  
ATOM   1379  O   ASP A  96     -65.703 117.318 142.156  1.00  0.00           O  
ATOM   1380  CB  ASP A  96     -68.920 116.903 141.500  1.00  0.00           C  
ATOM   1381  CG  ASP A  96     -70.078 115.973 141.190  1.00  0.00           C  
ATOM   1382  OD1 ASP A  96     -70.327 115.048 141.991  1.00  0.00           O  
ATOM   1383  OD2 ASP A  96     -70.734 116.172 140.147  1.00  0.00           O  
ATOM   1384  H   ASP A  96     -67.746 114.888 142.532  1.00  0.00           H  
ATOM   1385  HA  ASP A  96     -67.658 116.123 139.959  1.00  0.00           H  
ATOM   1386  HB2 ASP A  96     -68.876 117.047 142.570  1.00  0.00           H  
ATOM   1387  HB3 ASP A  96     -69.108 117.853 141.022  1.00  0.00           H  
ATOM   1388  N   LEU A  97     -66.434 118.369 140.305  1.00  0.00           N  
ATOM   1389  CA  LEU A  97     -65.434 119.428 140.378  1.00  0.00           C  
ATOM   1390  C   LEU A  97     -66.091 120.803 140.311  1.00  0.00           C  
ATOM   1391  O   LEU A  97     -67.215 120.941 139.831  1.00  0.00           O  
ATOM   1392  CB  LEU A  97     -64.421 119.278 139.242  1.00  0.00           C  
ATOM   1393  CG  LEU A  97     -65.003 119.192 137.831  1.00  0.00           C  
ATOM   1394  CD1 LEU A  97     -64.026 119.764 136.815  1.00  0.00           C  
ATOM   1395  CD2 LEU A  97     -65.353 117.752 137.485  1.00  0.00           C  
ATOM   1396  H   LEU A  97     -67.085 118.377 139.573  1.00  0.00           H  
ATOM   1397  HA  LEU A  97     -64.920 119.334 141.323  1.00  0.00           H  
ATOM   1398  HB2 LEU A  97     -63.758 120.130 139.275  1.00  0.00           H  
ATOM   1399  HB3 LEU A  97     -63.854 118.376 139.422  1.00  0.00           H  
ATOM   1400  HG  LEU A  97     -65.911 119.778 137.786  1.00  0.00           H  
ATOM   1401 HD11 LEU A  97     -63.082 119.248 136.892  1.00  0.00           H  
ATOM   1402 HD12 LEU A  97     -63.879 120.816 137.010  1.00  0.00           H  
ATOM   1403 HD13 LEU A  97     -64.427 119.637 135.820  1.00  0.00           H  
ATOM   1404 HD21 LEU A  97     -66.302 117.727 136.970  1.00  0.00           H  
ATOM   1405 HD22 LEU A  97     -65.420 117.170 138.392  1.00  0.00           H  
ATOM   1406 HD23 LEU A  97     -64.585 117.339 136.846  1.00  0.00           H  
ATOM   1407  N   GLU A  98     -65.380 121.817 140.795  1.00  0.00           N  
ATOM   1408  CA  GLU A  98     -65.894 123.181 140.787  1.00  0.00           C  
ATOM   1409  C   GLU A  98     -64.985 124.102 139.979  1.00  0.00           C  
ATOM   1410  O   GLU A  98     -63.761 124.052 140.108  1.00  0.00           O  
ATOM   1411  CB  GLU A  98     -66.028 123.706 142.219  1.00  0.00           C  
ATOM   1412  CG  GLU A  98     -66.924 124.928 142.337  1.00  0.00           C  
ATOM   1413  CD  GLU A  98     -68.283 124.719 141.698  1.00  0.00           C  
ATOM   1414  OE1 GLU A  98     -69.196 124.230 142.394  1.00  0.00           O  
ATOM   1415  OE2 GLU A  98     -68.432 125.043 140.501  1.00  0.00           O  
ATOM   1416  H   GLU A  98     -64.489 121.643 141.165  1.00  0.00           H  
ATOM   1417  HA  GLU A  98     -66.870 123.165 140.327  1.00  0.00           H  
ATOM   1418  HB2 GLU A  98     -66.436 122.923 142.840  1.00  0.00           H  
ATOM   1419  HB3 GLU A  98     -65.046 123.970 142.585  1.00  0.00           H  
ATOM   1420  HG2 GLU A  98     -67.067 125.153 143.383  1.00  0.00           H  
ATOM   1421  HG3 GLU A  98     -66.439 125.763 141.853  1.00  0.00           H  
ATOM   1422  N   HIS A  99     -65.590 124.940 139.145  1.00  0.00           N  
ATOM   1423  CA  HIS A  99     -64.836 125.873 138.315  1.00  0.00           C  
ATOM   1424  C   HIS A  99     -65.684 127.087 137.953  1.00  0.00           C  
ATOM   1425  O   HIS A  99     -66.769 126.953 137.385  1.00  0.00           O  
ATOM   1426  CB  HIS A  99     -64.350 125.177 137.043  1.00  0.00           C  
ATOM   1427  CG  HIS A  99     -63.554 126.068 136.139  1.00  0.00           C  
ATOM   1428  ND1 HIS A  99     -63.911 126.328 134.833  1.00  0.00           N  
ATOM   1429  CD2 HIS A  99     -62.414 126.764 136.362  1.00  0.00           C  
ATOM   1430  CE1 HIS A  99     -63.025 127.142 134.290  1.00  0.00           C  
ATOM   1431  NE2 HIS A  99     -62.106 127.423 135.198  1.00  0.00           N  
ATOM   1432  H   HIS A  99     -66.569 124.933 139.087  1.00  0.00           H  
ATOM   1433  HA  HIS A  99     -63.980 126.204 138.883  1.00  0.00           H  
ATOM   1434  HB2 HIS A  99     -63.726 124.339 137.315  1.00  0.00           H  
ATOM   1435  HB3 HIS A  99     -65.205 124.818 136.487  1.00  0.00           H  
ATOM   1436  HD1 HIS A  99     -64.696 125.966 134.372  1.00  0.00           H  
ATOM   1437  HD2 HIS A  99     -61.852 126.795 137.284  1.00  0.00           H  
ATOM   1438  HE1 HIS A  99     -63.046 127.516 133.278  1.00  0.00           H  
ATOM   1439  N   HIS A 100     -65.185 128.274 138.286  1.00  0.00           N  
ATOM   1440  CA  HIS A 100     -65.898 129.512 137.996  1.00  0.00           C  
ATOM   1441  C   HIS A 100     -65.027 130.461 137.179  1.00  0.00           C  
ATOM   1442  O   HIS A 100     -63.802 130.456 137.301  1.00  0.00           O  
ATOM   1443  CB  HIS A 100     -66.334 130.191 139.295  1.00  0.00           C  
ATOM   1444  CG  HIS A 100     -65.222 130.357 140.286  1.00  0.00           C  
ATOM   1445  ND1 HIS A 100     -64.159 131.213 140.089  1.00  0.00           N  
ATOM   1446  CD2 HIS A 100     -65.014 129.771 141.489  1.00  0.00           C  
ATOM   1447  CE1 HIS A 100     -63.345 131.145 141.125  1.00  0.00           C  
ATOM   1448  NE2 HIS A 100     -63.840 130.278 141.990  1.00  0.00           N  
ATOM   1449  H   HIS A 100     -64.316 128.316 138.737  1.00  0.00           H  
ATOM   1450  HA  HIS A 100     -66.775 129.262 137.419  1.00  0.00           H  
ATOM   1451  HB2 HIS A 100     -66.724 131.172 139.068  1.00  0.00           H  
ATOM   1452  HB3 HIS A 100     -67.109 129.599 139.760  1.00  0.00           H  
ATOM   1453  HD1 HIS A 100     -64.022 131.783 139.304  1.00  0.00           H  
ATOM   1454  HD2 HIS A 100     -65.652 129.040 141.965  1.00  0.00           H  
ATOM   1455  HE1 HIS A 100     -62.428 131.704 141.247  1.00  0.00           H  
ATOM   1456  N   HIS A 101     -65.667 131.276 136.346  1.00  0.00           N  
ATOM   1457  CA  HIS A 101     -64.951 132.231 135.508  1.00  0.00           C  
ATOM   1458  C   HIS A 101     -64.639 133.508 136.284  1.00  0.00           C  
ATOM   1459  O   HIS A 101     -65.320 133.837 137.256  1.00  0.00           O  
ATOM   1460  CB  HIS A 101     -65.772 132.566 134.262  1.00  0.00           C  
ATOM   1461  CG  HIS A 101     -67.060 133.265 134.564  1.00  0.00           C  
ATOM   1462  ND1 HIS A 101     -67.174 134.638 134.628  1.00  0.00           N  
ATOM   1463  CD2 HIS A 101     -68.296 132.775 134.819  1.00  0.00           C  
ATOM   1464  CE1 HIS A 101     -68.424 134.961 134.910  1.00  0.00           C  
ATOM   1465  NE2 HIS A 101     -69.125 133.849 135.031  1.00  0.00           N  
ATOM   1466  H   HIS A 101     -66.645 131.233 136.294  1.00  0.00           H  
ATOM   1467  HA  HIS A 101     -64.021 131.773 135.204  1.00  0.00           H  
ATOM   1468  HB2 HIS A 101     -65.189 133.206 133.617  1.00  0.00           H  
ATOM   1469  HB3 HIS A 101     -66.005 131.651 133.737  1.00  0.00           H  
ATOM   1470  HD1 HIS A 101     -66.447 135.279 134.489  1.00  0.00           H  
ATOM   1471  HD2 HIS A 101     -68.579 131.731 134.851  1.00  0.00           H  
ATOM   1472  HE1 HIS A 101     -68.807 135.964 135.024  1.00  0.00           H  
ATOM   1473  N   HIS A 102     -63.605 134.221 135.849  1.00  0.00           N  
ATOM   1474  CA  HIS A 102     -63.204 135.461 136.504  1.00  0.00           C  
ATOM   1475  C   HIS A 102     -63.032 136.582 135.484  1.00  0.00           C  
ATOM   1476  O   HIS A 102     -62.899 136.331 134.286  1.00  0.00           O  
ATOM   1477  CB  HIS A 102     -61.901 135.255 137.277  1.00  0.00           C  
ATOM   1478  CG  HIS A 102     -60.783 134.722 136.436  1.00  0.00           C  
ATOM   1479  ND1 HIS A 102     -60.250 133.460 136.603  1.00  0.00           N  
ATOM   1480  CD2 HIS A 102     -60.096 135.286 135.416  1.00  0.00           C  
ATOM   1481  CE1 HIS A 102     -59.284 133.273 135.723  1.00  0.00           C  
ATOM   1482  NE2 HIS A 102     -59.171 134.365 134.989  1.00  0.00           N  
ATOM   1483  H   HIS A 102     -63.102 133.907 135.070  1.00  0.00           H  
ATOM   1484  HA  HIS A 102     -63.984 135.738 137.196  1.00  0.00           H  
ATOM   1485  HB2 HIS A 102     -61.583 136.201 137.691  1.00  0.00           H  
ATOM   1486  HB3 HIS A 102     -62.075 134.556 138.083  1.00  0.00           H  
ATOM   1487  HD1 HIS A 102     -60.538 132.802 137.270  1.00  0.00           H  
ATOM   1488  HD2 HIS A 102     -60.247 136.277 135.011  1.00  0.00           H  
ATOM   1489  HE1 HIS A 102     -58.688 132.378 135.619  1.00  0.00           H  
ATOM   1490  N   HIS A 103     -63.035 137.820 135.966  1.00  0.00           N  
ATOM   1491  CA  HIS A 103     -62.879 138.981 135.096  1.00  0.00           C  
ATOM   1492  C   HIS A 103     -61.487 139.588 135.244  1.00  0.00           C  
ATOM   1493  O   HIS A 103     -60.660 139.093 136.010  1.00  0.00           O  
ATOM   1494  CB  HIS A 103     -63.943 140.031 135.416  1.00  0.00           C  
ATOM   1495  CG  HIS A 103     -64.061 140.338 136.877  1.00  0.00           C  
ATOM   1496  ND1 HIS A 103     -63.164 141.138 137.553  1.00  0.00           N  
ATOM   1497  CD2 HIS A 103     -64.980 139.948 137.792  1.00  0.00           C  
ATOM   1498  CE1 HIS A 103     -63.525 141.226 138.821  1.00  0.00           C  
ATOM   1499  NE2 HIS A 103     -64.624 140.513 138.992  1.00  0.00           N  
ATOM   1500  H   HIS A 103     -63.144 137.957 136.931  1.00  0.00           H  
ATOM   1501  HA  HIS A 103     -63.007 138.651 134.077  1.00  0.00           H  
ATOM   1502  HB2 HIS A 103     -63.698 140.950 134.903  1.00  0.00           H  
ATOM   1503  HB3 HIS A 103     -64.904 139.678 135.072  1.00  0.00           H  
ATOM   1504  HD1 HIS A 103     -62.380 141.576 137.162  1.00  0.00           H  
ATOM   1505  HD2 HIS A 103     -65.834 139.311 137.612  1.00  0.00           H  
ATOM   1506  HE1 HIS A 103     -63.011 141.785 139.588  1.00  0.00           H  
ATOM   1507  N   HIS A 104     -61.234 140.664 134.504  1.00  0.00           N  
ATOM   1508  CA  HIS A 104     -59.941 141.338 134.553  1.00  0.00           C  
ATOM   1509  C   HIS A 104     -59.635 141.824 135.966  1.00  0.00           C  
ATOM   1510  O   HIS A 104     -58.522 142.262 136.255  1.00  0.00           O  
ATOM   1511  CB  HIS A 104     -59.921 142.518 133.580  1.00  0.00           C  
ATOM   1512  CG  HIS A 104     -60.919 143.585 133.912  1.00  0.00           C  
ATOM   1513  ND1 HIS A 104     -62.140 143.695 133.280  1.00  0.00           N  
ATOM   1514  CD2 HIS A 104     -60.872 144.591 134.815  1.00  0.00           C  
ATOM   1515  CE1 HIS A 104     -62.800 144.724 133.781  1.00  0.00           C  
ATOM   1516  NE2 HIS A 104     -62.052 145.285 134.714  1.00  0.00           N  
ATOM   1517  H   HIS A 104     -61.932 141.011 133.912  1.00  0.00           H  
ATOM   1518  HA  HIS A 104     -59.185 140.627 134.259  1.00  0.00           H  
ATOM   1519  HB2 HIS A 104     -58.940 142.968 133.591  1.00  0.00           H  
ATOM   1520  HB3 HIS A 104     -60.137 142.159 132.584  1.00  0.00           H  
ATOM   1521  HD1 HIS A 104     -62.472 143.108 132.570  1.00  0.00           H  
ATOM   1522  HD2 HIS A 104     -60.057 144.808 135.492  1.00  0.00           H  
ATOM   1523  HE1 HIS A 104     -63.783 145.053 133.478  1.00  0.00           H  
TER    1524      HIS A 104                                                      
END
MOLECULE T0424_94_177.pdb
ATOM    631  N   LEU    94     -30.472  64.408 127.901  1.00 31.32          
ATOM    632  CA  LEU    94     -30.886  64.905 129.205  1.00 32.87          
ATOM    633  C   LEU    94     -32.322  65.427 129.206  1.00 33.92          
ATOM    634  O   LEU    94     -32.903  65.626 130.272  1.00 35.10          
ATOM    635  CB  LEU    94     -29.910  65.974 129.722  1.00 33.73          
ATOM    636  CG  LEU    94     -28.424  65.627 129.839  1.00 32.67          
ATOM    637  CD1 LEU    94     -27.614  66.889 130.295  1.00 35.22          
ATOM    638  CD2 LEU    94     -28.201  64.465 130.777  1.00 36.22          
ATOM    639  N   ALA    95     -32.898  65.651 128.017  1.00 34.10          
ATOM    640  CA  ALA    95     -34.322  65.969 127.907  1.00 33.68          
ATOM    641  C   ALA    95     -35.155  64.865 128.454  1.00 33.59          
ATOM    642  O   ALA    95     -36.242  65.114 128.802  1.00 34.14          
ATOM    643  CB  ALA    95     -34.719  66.234 126.452  1.00 33.56          
ATOM    644  N   GLY    96     -34.670  63.617 128.470  1.00 34.66          
ATOM    645  CA  GLY    96     -35.368  62.512 129.122  1.00 34.70          
ATOM    646  C   GLY    96     -35.872  62.796 130.538  1.00 35.90          
ATOM    647  O   GLY    96     -36.962  62.417 130.865  1.00 34.43          
ATOM    648  N   PHE    97     -35.065  63.447 131.378  1.00 36.84          
ATOM    649  CA  PHE    97     -35.525  63.962 132.659  1.00 38.40          
ATOM    650  C   PHE    97     -36.748  64.897 132.567  1.00 39.55          
ATOM    651  O   PHE    97     -37.732  64.733 133.280  1.00 39.69          
ATOM    652  CB  PHE    97     -34.412  64.763 133.346  1.00 39.36          
ATOM    653  CG  PHE    97     -33.257  63.921 133.826  1.00 40.36          
ATOM    654  CD1 PHE    97     -33.431  63.017 134.884  1.00 39.09          
ATOM    655  CD2 PHE    97     -31.987  64.059 133.235  1.00 40.34          
ATOM    656  CE1 PHE    97     -32.368  62.255 135.343  1.00 39.78          
ATOM    657  CE2 PHE    97     -30.914  63.298 133.678  1.00 40.54          
ATOM    658  CZ  PHE    97     -31.100  62.395 134.751  1.00 40.74          
ATOM    659  N   LEU    98     -36.672  65.894 131.694  1.00 40.37          
ATOM    660  CA  LEU    98     -37.772  66.857 131.533  1.00 40.15          
ATOM    661  C   LEU    98     -39.030  66.214 130.937  1.00 39.84          
ATOM    662  O   LEU    98     -40.129  66.541 131.332  1.00 39.74          
ATOM    663  CB  LEU    98     -37.295  68.022 130.673  1.00 40.91          
ATOM    664  CG  LEU    98     -35.984  68.692 131.136  1.00 43.39          
ATOM    665  CD1 LEU    98     -35.953  70.177 130.823  1.00 43.56          
ATOM    666  CD2 LEU    98     -35.758  68.472 132.615  1.00 42.31          
ATOM    667  N   VAL    99     -38.852  65.269 130.009  1.00 39.53          
ATOM    668  CA  VAL    99     -39.957  64.488 129.435  1.00 39.36          
ATOM    669  C   VAL    99     -40.648  63.600 130.446  1.00 40.07          
ATOM    670  O   VAL    99     -41.878  63.367 130.373  1.00 39.79          
ATOM    671  CB  VAL    99     -39.471  63.564 128.251  1.00 39.09          
ATOM    672  CG1 VAL    99     -40.508  62.518 127.940  1.00 36.51          
ATOM    673  CG2 VAL    99     -39.104  64.394 127.002  1.00 36.11          
ATOM    674  N   ASP   100     -39.857  63.064 131.370  1.00 40.79          
ATOM    675  CA  ASP   100     -40.359  62.121 132.363  1.00 41.66          
ATOM    676  C   ASP   100     -40.960  62.854 133.571  1.00 42.67          
ATOM    677  O   ASP   100     -41.981  62.449 134.085  1.00 41.73          
ATOM    678  CB  ASP   100     -39.246  61.232 132.919  1.00 41.09          
ATOM    679  CG  ASP   100     -38.685  60.220 131.916  1.00 41.20          
ATOM    680  OD1 ASP   100     -39.215  59.974 130.789  1.00 38.12          
ATOM    681  OD2 ASP   100     -37.632  59.673 132.300  1.00 41.45          
ATOM    682  N   CYS   101     -40.278  63.902 134.029  1.00 44.72          
ATOM    683  CA  CYS   101     -40.550  64.551 135.332  1.00 46.08          
ATOM    684  C   CYS   101     -41.570  65.680 135.232  1.00 46.69          
ATOM    685  O   CYS   101     -41.947  66.110 134.135  1.00 47.06          
ATOM    686  CB  CYS   101     -39.250  65.098 135.940  1.00 46.62          
ATOM    687  SG  CYS   101     -37.867  63.848 136.081  1.00 50.78          
ATOM    688  N   SER   102     -42.043  66.144 136.372  1.00 46.92          
ATOM    689  CA  SER   102     -43.159  67.124 136.343  1.00 48.06          
ATOM    690  C   SER   102     -42.742  68.584 136.408  1.00 48.09          
ATOM    691  O   SER   102     -41.796  68.941 137.112  1.00 47.53          
ATOM    692  CB  SER   102     -44.225  66.827 137.396  1.00 47.32          
ATOM    693  OG  SER   102     -45.338  66.314 136.694  1.00 49.89          
ATOM    694  N   ALA   103     -43.453  69.415 135.642  1.00 48.78          
ATOM    695  CA  ALA   103     -43.223  70.842 135.693  1.00 50.33          
ATOM    696  C   ALA   103     -43.653  71.293 137.097  1.00 50.76          
ATOM    697  O   ALA   103     -44.521  70.648 137.704  1.00 50.85          
ATOM    698  CB  ALA   103     -44.022  71.585 134.574  1.00 50.30          
ATOM    699  N   PRO   104     -42.977  72.317 137.648  1.00 52.08          
ATOM    700  CA  PRO   104     -43.571  73.101 138.756  1.00 52.25          
ATOM    701  C   PRO   104     -44.711  73.997 138.257  1.00 52.65          
ATOM    702  O   PRO   104     -44.948  74.092 137.031  1.00 51.65          
ATOM    703  CB  PRO   104     -42.397  73.979 139.259  1.00 52.72          
ATOM    704  CG  PRO   104     -41.134  73.462 138.542  1.00 52.36          
ATOM    705  CD  PRO   104     -41.623  72.800 137.286  1.00 52.44          
ATOM    706  N   GLN   105     -45.404  74.682 139.177  1.00 53.39          
ATOM    707  CA  GLN   105     -46.384  75.662 138.729  1.00 53.36          
ATOM    708  C   GLN   105     -45.828  77.097 138.835  1.00 53.55          
ATOM    709  O   GLN   105     -46.276  77.958 139.619  1.00 54.37          
ATOM    710  CB  GLN   105     -47.743  75.426 139.387  1.00 54.93          
ATOM    711  CG  GLN   105     -48.659  74.561 138.496  1.00 56.49          
ATOM    712  CD  GLN   105     -48.902  75.173 137.103  1.00 59.08          
ATOM    713  OE1 GLN   105     -48.718  76.391 136.890  1.00 61.74          
ATOM    714  NE2 GLN   105     -49.322  74.326 136.150  1.00 57.67          
ATOM    715  N   LEU   106     -44.809  77.298 138.010  1.00 52.41          
ATOM    716  CA  LEU   106     -44.190  78.576 137.734  1.00 51.29          
ATOM    717  C   LEU   106     -45.162  79.445 136.912  1.00 50.32          
ATOM    718  O   LEU   106     -45.873  78.933 136.044  1.00 50.83          
ATOM    719  CB  LEU   106     -42.886  78.300 136.954  1.00 51.27          
ATOM    720  CG  LEU   106     -41.997  79.408 136.379  1.00 52.24          
ATOM    721  CD1 LEU   106     -41.282  80.194 137.495  1.00 53.40          
ATOM    722  CD2 LEU   106     -40.970  78.808 135.358  1.00 50.96          
ATOM    723  N   ASN   107     -45.214  80.739 137.221  1.00 48.24          
ATOM    724  CA  ASN   107     -45.879  81.725 136.403  1.00 47.41          
ATOM    725  C   ASN   107     -44.772  82.501 135.657  1.00 46.64          
ATOM    726  O   ASN   107     -43.835  82.973 136.303  1.00 46.31          
ATOM    727  CB  ASN   107     -46.645  82.650 137.358  1.00 48.25          
ATOM    728  CG  ASN   107     -47.477  83.705 136.649  1.00 47.27          
ATOM    729  OD1 ASN   107     -47.103  84.183 135.586  1.00 50.28          
ATOM    730  ND2 ASN   107     -48.607  84.053 137.227  1.00 38.82          
ATOM    731  N   VAL   108     -44.863  82.670 134.334  1.00 45.26          
ATOM    732  CA  VAL   108     -43.685  83.142 133.544  1.00 45.06          
ATOM    733  C   VAL   108     -43.683  84.642 133.065  1.00 44.11          
ATOM    734  O   VAL   108     -42.734  85.179 132.496  1.00 43.95          
ATOM    735  CB  VAL   108     -43.426  82.114 132.377  1.00 45.46          
ATOM    736  CG1 VAL   108     -44.108  82.505 131.042  1.00 44.93          
ATOM    737  CG2 VAL   108     -41.952  81.773 132.261  1.00 45.52          
ATOM    738  N   LYS   109     -44.726  85.329 133.426  1.00 43.87          
ATOM    739  CA  LYS   109     -45.102  86.585 132.812  1.00 42.70          
ATOM    740  C   LYS   109     -44.436  87.708 133.590  1.00 43.86          
ATOM    741  O   LYS   109     -44.481  87.722 134.863  1.00 44.65          
ATOM    742  CB  LYS   109     -46.620  86.697 132.913  1.00 42.23          
ATOM    743  CG  LYS   109     -47.374  85.326 133.160  1.00 38.08          
ATOM    744  CD  LYS   109     -48.900  85.477 133.340  1.00 39.19          
ATOM    745  CE  LYS   109     -49.295  86.274 134.621  1.00 29.34          
ATOM    746  NZ  LYS   109     -50.691  86.169 134.931  1.00 18.04          
ATOM    747  N   GLY   110     -43.756  88.655 132.948  1.00 44.07          
ATOM    748  CA  GLY   110     -42.920  88.525 131.831  1.00 43.27          
ATOM    749  C   GLY   110     -41.511  88.520 132.435  1.00 43.32          
ATOM    750  O   GLY   110     -40.797  89.554 132.525  1.00 41.80          
ATOM    751  N   MET   111     -41.210  87.329 132.954  1.00 43.59          
ATOM    752  CA  MET   111     -39.920  86.671 132.815  1.00 43.57          
ATOM    753  C   MET   111     -39.646  86.503 131.313  1.00 42.73          
ATOM    754  O   MET   111     -40.509  86.070 130.556  1.00 41.71          
ATOM    755  CB  MET   111     -39.927  85.248 133.412  1.00 44.40          
ATOM    756  CG  MET   111     -40.241  85.083 134.939  1.00 45.70          
ATOM    757  SD  MET   111     -40.165  83.323 135.375  1.00 45.54          
ATOM    758  CE  MET   111     -38.430  83.087 135.002  1.00 48.04          
ATOM    759  N   THR   112     -38.459  86.936 130.921  1.00 41.67          
ATOM    760  CA  THR   112     -37.744  86.516 129.741  1.00 41.00          
ATOM    761  C   THR   112     -37.883  84.995 129.458  1.00 40.91          
ATOM    762  O   THR   112     -38.128  84.184 130.395  1.00 39.90          
ATOM    763  CB  THR   112     -36.287  87.018 129.973  1.00 41.99          
ATOM    764  OG1 THR   112     -36.238  88.466 129.743  1.00 42.94          
ATOM    765  CG2 THR   112     -35.313  86.350 129.194  1.00 39.55          
ATOM    766  N   VAL   113     -37.794  84.613 128.171  1.00 39.19          
ATOM    767  CA  VAL   113     -37.938  83.192 127.803  1.00 38.99          
ATOM    768  C   VAL   113     -36.696  82.465 128.351  1.00 37.74          
ATOM    769  O   VAL   113     -36.825  81.404 128.904  1.00 35.89          
ATOM    770  CB  VAL   113     -38.263  82.983 126.259  1.00 38.81          
ATOM    771  CG1 VAL   113     -37.023  83.105 125.436  1.00 40.05          
ATOM    772  CG2 VAL   113     -38.950  81.625 125.988  1.00 39.74          
ATOM    773  N   LEU   114     -35.522  83.107 128.305  1.00 37.73          
ATOM    774  CA  LEU   114     -34.285  82.497 128.772  1.00 37.80          
ATOM    775  C   LEU   114     -34.320  82.209 130.247  1.00 38.39          
ATOM    776  O   LEU   114     -33.726  81.240 130.660  1.00 37.46          
ATOM    777  CB  LEU   114     -33.065  83.369 128.446  1.00 37.76          
ATOM    778  CG  LEU   114     -31.664  82.862 128.828  1.00 38.09          
ATOM    779  CD1 LEU   114     -31.431  81.365 128.458  1.00 42.92          
ATOM    780  CD2 LEU   114     -30.550  83.742 128.229  1.00 39.46          
ATOM    781  N   ASP   115     -34.982  83.090 131.036  1.00 38.71          
ATOM    782  CA  ASP   115     -35.118  82.929 132.498  1.00 38.65          
ATOM    783  C   ASP   115     -36.194  81.944 132.901  1.00 37.85          
ATOM    784  O   ASP   115     -35.982  81.173 133.823  1.00 38.57          
ATOM    785  CB  ASP   115     -35.376  84.286 133.206  1.00 39.19          
ATOM    786  CG  ASP   115     -34.157  85.156 133.233  1.00 43.54          
ATOM    787  OD1 ASP   115     -33.033  84.688 132.846  1.00 46.56          
ATOM    788  OD2 ASP   115     -34.319  86.335 133.651  1.00 51.72          
ATOM    789  N   ALA   116     -37.332  81.925 132.230  1.00 37.36          
ATOM    790  CA  ALA   116     -38.301  80.835 132.454  1.00 38.07          
ATOM    791  C   ALA   116     -37.730  79.423 132.036  1.00 38.99          
ATOM    792  O   ALA   116     -38.122  78.383 132.623  1.00 38.98          
ATOM    793  CB  ALA   116     -39.587  81.122 131.734  1.00 37.10          
ATOM    794  N   ALA   117     -36.798  79.383 131.076  1.00 38.86          
ATOM    795  CA  ALA   117     -36.160  78.084 130.707  1.00 39.89          
ATOM    796  C   ALA   117     -35.150  77.668 131.782  1.00 40.38          
ATOM    797  O   ALA   117     -35.124  76.492 132.188  1.00 40.63          
ATOM    798  CB  ALA   117     -35.469  78.156 129.324  1.00 38.98          
ATOM    799  N   LYS   118     -34.321  78.639 132.208  1.00 41.01          
ATOM    800  CA  LYS   118     -33.322  78.457 133.271  1.00 42.11          
ATOM    801  C   LYS   118     -34.018  77.916 134.505  1.00 43.02          
ATOM    802  O   LYS   118     -33.518  76.974 135.151  1.00 43.96          
ATOM    803  CB  LYS   118     -32.580  79.785 133.617  1.00 42.13          
ATOM    804  CG  LYS   118     -31.428  80.134 132.659  1.00 41.02          
ATOM    805  CD  LYS   118     -30.839  81.500 132.877  1.00 42.50          
ATOM    806  CE  LYS   118     -29.590  81.723 131.995  1.00 43.19          
ATOM    807  NZ  LYS   118     -29.103  83.173 132.155  1.00 41.67          
ATOM    808  N   LYS   119     -35.181  78.480 134.803  1.00 43.80          
ATOM    809  CA  LYS   119     -35.934  78.090 135.995  1.00 44.10          
ATOM    810  C   LYS   119     -36.285  76.642 135.900  1.00 43.70          
ATOM    811  O   LYS   119     -35.894  75.869 136.747  1.00 43.50          
ATOM    812  CB  LYS   119     -37.205  78.943 136.201  1.00 45.44          
ATOM    813  CG  LYS   119     -38.055  78.533 137.433  1.00 46.50          
ATOM    814  CD  LYS   119     -37.393  79.020 138.778  1.00 52.06          
ATOM    815  CE  LYS   119     -37.514  77.994 139.967  1.00 52.67          
ATOM    816  NZ  LYS   119     -38.758  78.151 140.813  1.00 52.88          
ATOM    817  N   LEU   120     -36.977  76.276 134.837  1.00 44.23          
ATOM    818  CA  LEU   120     -37.508  74.896 134.634  1.00 43.33          
ATOM    819  C   LEU   120     -36.463  73.796 134.554  1.00 42.75          
ATOM    820  O   LEU   120     -36.755  72.643 134.856  1.00 43.41          
ATOM    821  CB  LEU   120     -38.373  74.844 133.382  1.00 43.67          
ATOM    822  CG  LEU   120     -39.670  75.648 133.318  1.00 44.94          
ATOM    823  CD1 LEU   120     -40.015  75.948 131.830  1.00 43.41          
ATOM    824  CD2 LEU   120     -40.793  74.895 134.015  1.00 45.47          
ATOM    825  N   ALA   121     -35.259  74.138 134.105  1.00 42.53          
ATOM    826  CA  ALA   121     -34.130  73.190 134.025  1.00 42.11          
ATOM    827  C   ALA   121     -33.273  73.156 135.319  1.00 41.97          
ATOM    828  O   ALA   121     -32.373  72.329 135.447  1.00 40.35          
ATOM    829  CB  ALA   121     -33.250  73.562 132.857  1.00 41.60          
ATOM    830  N   ALA   122     -33.510  74.120 136.217  1.00 40.98          
ATOM    831  CA  ALA   122     -32.759  74.256 137.477  1.00 41.87          
ATOM    832  C   ALA   122     -32.574  72.959 138.288  1.00 41.61          
ATOM    833  O   ALA   122     -31.434  72.664 138.670  1.00 41.78          
ATOM    834  CB  ALA   122     -33.387  75.391 138.400  1.00 40.34          
ATOM    835  N   PRO   123     -33.672  72.192 138.545  1.00 42.01          
ATOM    836  CA  PRO   123     -33.565  70.900 139.267  1.00 42.75          
ATOM    837  C   PRO   123     -32.626  69.842 138.666  1.00 43.38          
ATOM    838  O   PRO   123     -32.307  68.854 139.327  1.00 44.75          
ATOM    839  CB  PRO   123     -35.008  70.356 139.251  1.00 43.04          
ATOM    840  CG  PRO   123     -35.880  71.511 138.977  1.00 40.40          
ATOM    841  CD  PRO   123     -35.068  72.462 138.141  1.00 41.52          
ATOM    842  N   TRP   124     -32.187  70.020 137.422  1.00 43.74          
ATOM    843  CA  TRP   124     -31.322  69.083 136.794  1.00 43.10          
ATOM    844  C   TRP   124     -29.997  69.711 136.519  1.00 44.01          
ATOM    845  O   TRP   124     -29.716  70.114 135.393  1.00 42.99          
ATOM    846  CB  TRP   124     -31.978  68.471 135.551  1.00 42.86          
ATOM    847  CG  TRP   124     -33.145  67.675 135.984  1.00 40.78          
ATOM    848  CD1 TRP   124     -33.137  66.395 136.468  1.00 41.48          
ATOM    849  CD2 TRP   124     -34.483  68.110 136.021  1.00 39.28          
ATOM    850  NE1 TRP   124     -34.413  66.012 136.797  1.00 40.34          
ATOM    851  CE2 TRP   124     -35.260  67.047 136.517  1.00 39.98          
ATOM    852  CE3 TRP   124     -35.124  69.293 135.637  1.00 40.65          
ATOM    853  CZ2 TRP   124     -36.648  67.140 136.680  1.00 41.02          
ATOM    854  CZ3 TRP   124     -36.499  69.381 135.806  1.00 41.19          
ATOM    855  CH2 TRP   124     -37.244  68.307 136.313  1.00 40.55          
ATOM    856  N   PRO   125     -29.139  69.762 137.570  1.00 45.64          
ATOM    857  CA  PRO   125     -27.870  70.448 137.445  1.00 45.93          
ATOM    858  C   PRO   125     -26.997  69.785 136.445  1.00 46.37          
ATOM    859  O   PRO   125     -26.049  70.413 135.948  1.00 46.58          
ATOM    860  CB  PRO   125     -27.278  70.399 138.869  1.00 46.66          
ATOM    861  CG  PRO   125     -27.981  69.307 139.540  1.00 46.96          
ATOM    862  CD  PRO   125     -29.340  69.236 138.933  1.00 45.91          
ATOM    863  N   GLN   126     -27.334  68.521 136.160  1.00 47.12          
ATOM    864  CA  GLN   126     -26.809  67.771 135.035  1.00 47.00          
ATOM    865  C   GLN   126     -26.909  68.582 133.696  1.00 47.32          
ATOM    866  O   GLN   126     -26.002  68.547 132.840  1.00 46.71          
ATOM    867  CB  GLN   126     -27.448  66.327 135.010  1.00 47.77          
ATOM    868  CG  GLN   126     -28.985  66.168 135.505  1.00 48.57          
ATOM    869  CD  GLN   126     -29.302  65.663 137.009  1.00 44.32          
ATOM    870  OE1 GLN   126     -28.717  66.048 137.940  1.00 46.03          
ATOM    871  NE2 GLN   126     -30.297  64.872 137.148  1.00 44.90          
ATOM    872  N   ILE   127     -27.979  69.366 133.549  1.00 47.63          
ATOM    873  CA  ILE   127     -28.061  70.396 132.492  1.00 47.76          
ATOM    874  C   ILE   127     -27.288  71.635 133.009  1.00 48.07          
ATOM    875  O   ILE   127     -27.789  72.407 133.818  1.00 47.78          
ATOM    876  CB  ILE   127     -29.560  70.743 132.119  1.00 47.78          
ATOM    877  CG1 ILE   127     -30.325  69.480 131.695  1.00 47.09          
ATOM    878  CG2 ILE   127     -29.624  71.797 131.003  1.00 46.93          
ATOM    879  CD  ILE   127     -31.862  69.582 131.763  1.00 47.45          
ATOM    880  N   LYS   128     -26.065  71.812 132.521  1.00 48.75          
ATOM    881  CA  LYS   128     -25.120  72.760 133.100  1.00 48.87          
ATOM    882  C   LYS   128     -25.129  74.162 132.479  1.00 48.31          
ATOM    883  O   LYS   128     -24.464  75.052 133.012  1.00 49.33          
ATOM    884  CB  LYS   128     -23.703  72.199 133.023  1.00 50.03          
ATOM    885  CG  LYS   128     -23.388  71.080 133.994  1.00 51.17          
ATOM    886  CD  LYS   128     -22.050  70.447 133.658  1.00 51.13          
ATOM    887  CE  LYS   128     -21.696  69.316 134.648  1.00 53.76          
ATOM    888  NZ  LYS   128     -20.685  68.320 134.094  1.00 53.98          
ATOM    889  N   ALA   129     -25.850  74.367 131.371  1.00 47.27          
ATOM    890  CA  ALA   129     -26.104  75.716 130.840  1.00 46.07          
ATOM    891  C   ALA   129     -27.409  75.745 130.084  1.00 45.68          
ATOM    892  O   ALA   129     -27.808  74.742 129.469  1.00 43.86          
ATOM    893  CB  ALA   129     -24.981  76.192 129.933  1.00 46.37          
ATOM    894  N   VAL   130     -28.086  76.896 130.157  1.00 44.12          
ATOM    895  CA  VAL   130     -29.263  77.178 129.340  1.00 44.02          
ATOM    896  C   VAL   130     -28.959  78.423 128.478  1.00 44.72          
ATOM    897  O   VAL   130     -28.543  79.460 128.989  1.00 45.08          
ATOM    898  CB  VAL   130     -30.505  77.382 130.206  1.00 43.13          
ATOM    899  CG1 VAL   130     -31.764  77.440 129.356  1.00 39.96          
ATOM    900  CG2 VAL   130     -30.582  76.277 131.252  1.00 40.18          
ATOM    901  N   VAL   131     -29.192  78.306 127.183  1.00 44.93          
ATOM    902  CA  VAL   131     -28.793  79.298 126.205  1.00 45.42          
ATOM    903  C   VAL   131     -30.030  79.632 125.369  1.00 45.75          
ATOM    904  O   VAL   131     -30.989  78.822 125.278  1.00 44.30          
ATOM    905  CB  VAL   131     -27.585  78.752 125.369  1.00 46.08          
ATOM    906  CG1 VAL   131     -27.494  79.360 123.963  1.00 48.27          
ATOM    907  CG2 VAL   131     -26.264  78.982 126.129  1.00 45.62          
ATOM    908  N   LEU   132     -30.048  80.858 124.832  1.00 46.00          
ATOM    909  CA  LEU   132     -31.140  81.319 123.968  1.00 46.49          
ATOM    910  C   LEU   132     -30.516  81.350 122.590  1.00 47.11          
ATOM    911  O   LEU   132     -29.404  81.861 122.391  1.00 47.20          
ATOM    912  CB  LEU   132     -31.750  82.672 124.411  1.00 46.61          
ATOM    913  CG  LEU   132     -32.940  83.301 123.642  1.00 44.73          
ATOM    914  CD1 LEU   132     -34.275  82.678 123.969  1.00 39.44          
ATOM    915  CD2 LEU   132     -33.014  84.840 123.863  1.00 46.67          
ATOM    916  N   LYS   133     -31.198  80.708 121.652  1.00 47.95          
ATOM    917  CA  LYS   133     -30.695  80.612 120.283  1.00 48.56          
ATOM    918  C   LYS   133     -31.656  81.439 119.411  1.00 48.77          
ATOM    919  O   LYS   133     -32.410  80.929 118.563  1.00 48.35          
ATOM    920  CB  LYS   133     -30.589  79.130 119.885  1.00 48.79          
ATOM    921  CG  LYS   133     -29.248  78.707 119.355  1.00 49.90          
ATOM    922  CD  LYS   133     -28.164  78.764 120.403  1.00 51.28          
ATOM    923  CE  LYS   133     -26.824  78.442 119.797  1.00 52.13          
ATOM    924  NZ  LYS   133     -26.748  76.998 119.425  1.00 52.63          
ATOM    925  N   ALA   134     -31.628  82.749 119.668  1.00 49.39          
ATOM    926  CA  ALA   134     -32.589  83.690 119.085  1.00 49.87          
ATOM    927  C   ALA   134     -32.058  85.143 119.188  1.00 50.83          
ATOM    928  O   ALA   134     -31.184  85.445 120.015  1.00 50.97          
ATOM    929  CB  ALA   134     -33.952  83.531 119.758  1.00 48.85          
ATOM    930  N   GLU   135     -32.554  86.030 118.329  1.00 51.95          
ATOM    931  CA  GLU   135     -32.065  87.403 118.300  1.00 53.09          
ATOM    932  C   GLU   135     -32.486  88.131 119.583  1.00 53.81          
ATOM    933  O   GLU   135     -31.697  88.862 120.217  1.00 53.87          
ATOM    934  CB  GLU   135     -32.619  88.146 117.080  1.00 53.66          
ATOM    935  CG  GLU   135     -31.982  87.753 115.720  1.00 56.72          
ATOM    936  CD  GLU   135     -30.635  88.448 115.438  1.00 59.74          
ATOM    937  OE1 GLU   135     -30.557  89.681 115.664  1.00 61.44          
ATOM    938  OE2 GLU   135     -29.671  87.759 114.974  1.00 60.19          
ATOM    939  N   ASN   136     -33.745  87.905 119.944  1.00 54.10          
ATOM    940  CA  ASN   136     -34.395  88.606 121.006  1.00 54.11          
ATOM    941  C   ASN   136     -34.900  87.657 122.071  1.00 53.84          
ATOM    942  O   ASN   136     -35.187  86.495 121.820  1.00 54.30          
ATOM    943  CB  ASN   136     -35.506  89.429 120.393  1.00 54.65          
ATOM    944  CG  ASN   136     -34.957  90.464 119.392  1.00 57.00          
ATOM    945  OD1 ASN   136     -34.323  91.464 119.794  1.00 58.44          
ATOM    946  ND2 ASN   136     -35.164  90.210 118.089  1.00 57.01          
ATOM    947  N   ASN   137     -34.994  88.174 123.280  1.00 53.24          
ATOM    948  CA  ASN   137     -35.226  87.376 124.458  1.00 52.32          
ATOM    949  C   ASN   137     -36.498  87.872 125.119  1.00 52.82          
ATOM    950  O   ASN   137     -36.456  88.587 126.164  1.00 52.03          
ATOM    951  CB  ASN   137     -34.020  87.533 125.363  1.00 52.07          
ATOM    952  CG  ASN   137     -34.135  86.738 126.615  1.00 50.83          
ATOM    953  OD1 ASN   137     -35.141  86.039 126.849  1.00 47.05          
ATOM    954  ND2 ASN   137     -33.106  86.841 127.454  1.00 49.01          
ATOM    955  N   PRO   138     -37.642  87.534 124.497  1.00 52.42          
ATOM    956  CA  PRO   138     -38.893  88.211 124.821  1.00 52.30          
ATOM    957  C   PRO   138     -39.328  87.955 126.241  1.00 51.98          
ATOM    958  O   PRO   138     -39.159  86.836 126.744  1.00 51.56          
ATOM    959  CB  PRO   138     -39.903  87.561 123.863  1.00 52.52          
ATOM    960  CG  PRO   138     -39.343  86.244 123.610  1.00 52.20          
ATOM    961  CD  PRO   138     -37.863  86.505 123.478  1.00 52.66          
ATOM    962  N   ALA   139     -39.870  89.007 126.861  1.00 51.66          
ATOM    963  CA  ALA   139     -40.711  88.881 128.047  1.00 50.96          
ATOM    964  C   ALA   139     -41.902  88.036 127.631  1.00 50.06          
ATOM    965  O   ALA   139     -42.499  88.273 126.601  1.00 50.30          
ATOM    966  CB  ALA   139     -41.163  90.267 128.569  1.00 50.90          
ATOM    967  N   LEU   140     -42.207  87.026 128.424  1.00 49.66          
ATOM    968  CA  LEU   140     -43.278  86.094 128.128  1.00 49.15          
ATOM    969  C   LEU   140     -44.588  86.691 128.508  1.00 49.75          
ATOM    970  O   LEU   140     -44.653  87.538 129.423  1.00 49.81          
ATOM    971  CB  LEU   140     -43.097  84.804 128.937  1.00 48.86          
ATOM    972  CG  LEU   140     -42.199  83.637 128.448  1.00 46.34          
ATOM    973  CD1 LEU   140     -42.354  83.399 126.920  1.00 42.72          
ATOM    974  CD2 LEU   140     -40.747  83.767 128.864  1.00 41.96          
ATOM    975  N   GLY   141     -45.636  86.243 127.831  1.00 50.37          
ATOM    976  CA  GLY   141     -47.001  86.615 128.146  1.00 51.04          
ATOM    977  C   GLY   141     -47.554  85.726 129.236  1.00 51.33          
ATOM    978  O   GLY   141     -46.819  85.243 130.074  1.00 51.56          
ATOM    979  N   LYS   142     -48.859  85.513 129.219  1.00 52.49          
ATOM    980  CA  LYS   142     -49.526  84.634 130.170  1.00 53.66          
ATOM    981  C   LYS   142     -49.550  83.203 129.663  1.00 54.43          
ATOM    982  O   LYS   142     -50.239  82.904 128.697  1.00 55.46          
ATOM    983  CB  LYS   142     -50.961  85.133 130.408  1.00 53.71          
ATOM    984  CG  LYS   142     -51.928  84.155 131.108  1.00 53.61          
ATOM    985  CD  LYS   142     -53.238  84.909 131.445  1.00 54.28          
ATOM    986  CE  LYS   142     -54.079  84.236 132.548  1.00 55.34          
ATOM    987  NZ  LYS   142     -55.125  85.190 133.141  1.00 53.75          
ATOM    988  N   ILE   143     -48.808  82.312 130.304  1.00 55.53          
ATOM    989  CA  ILE   143     -48.804  80.903 129.878  1.00 56.18          
ATOM    990  C   ILE   143     -49.408  80.027 130.984  1.00 57.50          
ATOM    991  O   ILE   143     -48.841  79.899 132.076  1.00 58.04          
ATOM    992  CB  ILE   143     -47.410  80.408 129.456  1.00 56.47          
ATOM    993  CG1 ILE   143     -46.854  81.252 128.300  1.00 55.69          
ATOM    994  CG2 ILE   143     -47.477  78.950 128.992  1.00 54.86          
ATOM    995  CD  ILE   143     -47.407  80.885 126.971  1.00 56.04          
ATOM    996  N   ASP   144     -50.589  79.477 130.681  1.00 58.48          
ATOM    997  CA  ASP   144     -51.377  78.666 131.595  1.00 58.74          
ATOM    998  C   ASP   144     -51.047  77.219 131.288  1.00 59.75          
ATOM    999  O   ASP   144     -51.443  76.702 130.236  1.00 60.47          
ATOM   1000  CB  ASP   144     -52.886  78.902 131.368  1.00 58.87          
ATOM   1001  CG  ASP   144     -53.512  79.842 132.385  1.00 59.00          
ATOM   1002  OD1 ASP   144     -53.044  79.876 133.545  1.00 60.52          
ATOM   1003  OD2 ASP   144     -54.501  80.531 132.031  1.00 57.39          
ATOM   1004  N   ILE   145     -50.322  76.576 132.200  1.00 60.31          
ATOM   1005  CA  ILE   145     -49.944  75.166 132.080  1.00 60.43          
ATOM   1006  C   ILE   145     -50.761  74.286 133.054  1.00 60.93          
ATOM   1007  O   ILE   145     -51.069  74.715 134.175  1.00 61.93          
ATOM   1008  CB  ILE   145     -48.407  74.969 132.305  1.00 60.88          
ATOM   1009  CG1 ILE   145     -47.846  75.996 133.290  1.00 59.56          
ATOM   1010  CG2 ILE   145     -47.643  75.040 130.930  1.00 61.16          
ATOM   1011  CD  ILE   145     -46.384  75.809 133.636  1.00 59.89          
ATOM   1012  N   GLU   146     -51.122  73.072 132.641  1.00 60.81          
ATOM   1013  CA  GLU   146     -51.909  72.166 133.510  1.00 60.96          
ATOM   1014  C   GLU   146     -51.009  71.194 134.329  1.00 60.57          
ATOM   1015  O   GLU   146     -49.988  70.737 133.827  1.00 60.80          
ATOM   1016  CB  GLU   146     -53.006  71.441 132.716  1.00 61.11          
ATOM   1017  CG  GLU   146     -52.580  70.916 131.336  1.00 62.49          
ATOM   1018  CD  GLU   146     -53.711  70.205 130.578  1.00 63.25          
ATOM   1019  OE1 GLU   146     -53.412  69.211 129.852  1.00 65.14          
ATOM   1020  OE2 GLU   146     -54.889  70.656 130.699  1.00 65.30          
ATOM   1021  N   PRO   147     -51.401  70.865 135.587  1.00 60.04          
ATOM   1022  CA  PRO   147     -50.441  70.366 136.631  1.00 59.24          
ATOM   1023  C   PRO   147     -49.634  69.080 136.336  1.00 58.69          
ATOM   1024  O   PRO   147     -48.431  68.991 136.689  1.00 59.18          
ATOM   1025  CB  PRO   147     -51.328  70.185 137.880  1.00 59.35          
ATOM   1026  CG  PRO   147     -52.592  71.023 137.596  1.00 59.88          
ATOM   1027  CD  PRO   147     -52.788  70.926 136.105  1.00 59.93          
ATOM   1028  N   GLY   148     -50.256  68.095 135.692  1.00 57.37          
ATOM   1029  CA  GLY   148     -49.506  66.911 135.222  1.00 55.91          
ATOM   1030  C   GLY   148     -48.594  67.148 134.010  1.00 54.75          
ATOM   1031  O   GLY   148     -48.077  66.200 133.424  1.00 53.38          
ATOM   1032  N   GLU   149     -48.408  68.407 133.607  1.00 53.32          
ATOM   1033  CA  GLU   149     -47.500  68.703 132.489  1.00 52.60          
ATOM   1034  C   GLU   149     -46.070  68.408 132.907  1.00 49.31          
ATOM   1035  O   GLU   149     -45.677  68.566 134.111  1.00 49.20          
ATOM   1036  CB  GLU   149     -47.660  70.139 131.915  1.00 52.19          
ATOM   1037  CG  GLU   149     -48.786  70.201 130.852  1.00 54.72          
ATOM   1038  CD  GLU   149     -48.742  71.407 129.903  1.00 55.39          
ATOM   1039  OE1 GLU   149     -48.753  72.582 130.353  1.00 58.89          
ATOM   1040  OE2 GLU   149     -48.757  71.155 128.680  1.00 60.76          
ATOM   1041  N   THR   150     -45.321  67.958 131.902  1.00 45.19          
ATOM   1042  CA  THR   150     -43.992  67.565 132.084  1.00 42.07          
ATOM   1043  C   THR   150     -43.217  68.842 131.964  1.00 41.31          
ATOM   1044  O   THR   150     -43.680  69.807 131.390  1.00 39.74          
ATOM   1045  CB  THR   150     -43.559  66.539 130.959  1.00 42.90          
ATOM   1046  OG1 THR   150     -43.569  67.170 129.657  1.00 40.69          
ATOM   1047  CG2 THR   150     -44.472  65.290 130.952  1.00 39.70          
ATOM   1048  N   VAL   151     -42.010  68.854 132.475  1.00 40.18          
ATOM   1049  CA  VAL   151     -41.131  70.005 132.249  1.00 39.70          
ATOM   1050  C   VAL   151     -41.011  70.330 130.727  1.00 38.66          
ATOM   1051  O   VAL   151     -41.045  71.521 130.319  1.00 37.43          
ATOM   1052  CB  VAL   151     -39.750  69.784 132.910  1.00 39.49          
ATOM   1053  CG1 VAL   151     -38.908  71.052 132.844  1.00 40.08          
ATOM   1054  CG2 VAL   151     -39.912  69.333 134.369  1.00 40.15          
ATOM   1055  N   TRP   152     -40.861  69.265 129.917  1.00 37.91          
ATOM   1056  CA  TRP   152     -40.750  69.360 128.466  1.00 36.89          
ATOM   1057  C   TRP   152     -41.972  70.007 127.810  1.00 35.94          
ATOM   1058  O   TRP   152     -41.827  70.971 127.094  1.00 35.39          
ATOM   1059  CB  TRP   152     -40.441  68.006 127.787  1.00 34.74          
ATOM   1060  CG  TRP   152     -39.829  68.290 126.487  1.00 32.36          
ATOM   1061  CD1 TRP   152     -40.449  68.267 125.250  1.00 31.54          
ATOM   1062  CD2 TRP   152     -38.534  68.813 126.272  1.00 32.04          
ATOM   1063  NE1 TRP   152     -39.592  68.724 124.291  1.00 31.01          
ATOM   1064  CE2 TRP   152     -38.401  69.044 124.871  1.00 29.15          
ATOM   1065  CE3 TRP   152     -37.432  69.042 127.108  1.00 29.95          
ATOM   1066  CZ2 TRP   152     -37.226  69.496 124.298  1.00 31.01          
ATOM   1067  CZ3 TRP   152     -36.276  69.504 126.548  1.00 31.50          
ATOM   1068  CH2 TRP   152     -36.158  69.715 125.152  1.00 30.71          
ATOM   1069  N   GLN   153     -43.150  69.464 128.044  1.00 36.92          
ATOM   1070  CA  GLN   153     -44.406  70.094 127.600  1.00 38.21          
ATOM   1071  C   GLN   153     -44.504  71.549 127.954  1.00 38.85          
ATOM   1072  O   GLN   153     -44.873  72.368 127.106  1.00 39.73          
ATOM   1073  CB  GLN   153     -45.597  69.403 128.220  1.00 38.30          
ATOM   1074  CG  GLN   153     -45.938  68.131 127.540  1.00 38.80          
ATOM   1075  CD  GLN   153     -46.993  67.336 128.295  1.00 39.06          
ATOM   1076  OE1 GLN   153     -47.016  67.343 129.521  1.00 41.00          
ATOM   1077  NE2 GLN   153     -47.842  66.611 127.563  1.00 38.45          
ATOM   1078  N   ALA   154     -44.140  71.878 129.197  1.00 38.88          
ATOM   1079  CA  ALA   154     -44.220  73.226 129.675  1.00 38.65          
ATOM   1080  C   ALA   154     -43.212  74.091 128.955  1.00 38.64          
ATOM   1081  O   ALA   154     -43.469  75.255 128.619  1.00 37.52          
ATOM   1082  CB  ALA   154     -43.956  73.277 131.230  1.00 39.17          
ATOM   1083  N   LEU   155     -42.042  73.526 128.732  1.00 37.76          
ATOM   1084  CA  LEU   155     -41.000  74.261 128.085  1.00 38.20          
ATOM   1085  C   LEU   155     -41.363  74.537 126.589  1.00 37.62          
ATOM   1086  O   LEU   155     -41.023  75.599 126.038  1.00 35.67          
ATOM   1087  CB  LEU   155     -39.726  73.433 128.181  1.00 38.96          
ATOM   1088  CG  LEU   155     -38.340  74.005 128.050  1.00 38.74          
ATOM   1089  CD1 LEU   155     -38.154  75.179 128.954  1.00 38.22          
ATOM   1090  CD2 LEU   155     -37.448  72.854 128.455  1.00 38.79          
ATOM   1091  N   THR   156     -42.049  73.579 125.978  1.00 37.91          
ATOM   1092  CA  THR   156     -42.426  73.649 124.570  1.00 39.28          
ATOM   1093  C   THR   156     -43.489  74.754 124.396  1.00 39.91          
ATOM   1094  O   THR   156     -43.328  75.671 123.582  1.00 39.56          
ATOM   1095  CB  THR   156     -42.943  72.275 124.075  1.00 39.40          
ATOM   1096  OG1 THR   156     -41.913  71.276 124.222  1.00 40.32          
ATOM   1097  CG2 THR   156     -43.414  72.344 122.597  1.00 37.44          
ATOM   1098  N   HSD   157     -44.506  74.700 125.253  1.00 41.29          
ATOM   1099  CA  HSD   157     -45.563  75.742 125.389  1.00 40.52          
ATOM   1100  C   HSD   157     -44.960  77.148 125.489  1.00 40.40          
ATOM   1101  O   HSD   157     -45.144  78.009 124.630  1.00 40.47          
ATOM   1102  CB  HSD   157     -46.370  75.403 126.629  1.00 42.29          
ATOM   1103  CG  HSD   157     -47.824  75.773 126.555  1.00 46.21          
ATOM   1104  ND1 HSD   157     -48.795  74.896 126.108  1.00 49.77          
ATOM   1105  CD2 HSD   157     -48.474  76.912 126.900  1.00 46.73          
ATOM   1106  CE1 HSD   157     -49.978  75.493 126.168  1.00 51.70          
ATOM   1107  NE2 HSD   157     -49.812  76.717 126.654  1.00 48.91          
ATOM   1108  N   ILE   158     -44.174  77.364 126.520  1.00 39.54          
ATOM   1109  CA  ILE   158     -43.512  78.617 126.731  1.00 38.46          
ATOM   1110  C   ILE   158     -42.707  79.077 125.507  1.00 37.00          
ATOM   1111  O   ILE   158     -42.830  80.226 125.019  1.00 35.33          
ATOM   1112  CB  ILE   158     -42.575  78.495 127.969  1.00 38.55          
ATOM   1113  CG1 ILE   158     -43.399  78.372 129.259  1.00 39.19          
ATOM   1114  CG2 ILE   158     -41.672  79.670 128.051  1.00 39.72          
ATOM   1115  CD  ILE   158     -42.637  77.673 130.405  1.00 39.44          
ATOM   1116  N   ALA   159     -41.855  78.178 125.038  1.00 35.87          
ATOM   1117  CA  ALA   159     -40.969  78.441 123.908  1.00 36.02          
ATOM   1118  C   ALA   159     -41.790  78.802 122.666  1.00 34.45          
ATOM   1119  O   ALA   159     -41.479  79.781 121.981  1.00 33.92          
ATOM   1120  CB  ALA   159     -40.046  77.145 123.618  1.00 35.86          
ATOM   1121  N   ASN   160     -42.849  78.034 122.438  1.00 34.51          
ATOM   1122  CA  ASN   160     -43.613  78.102 121.219  1.00 35.17          
ATOM   1123  C   ASN   160     -44.446  79.389 121.199  1.00 36.44          
ATOM   1124  O   ASN   160     -44.602  80.017 120.125  1.00 35.86          
ATOM   1125  CB  ASN   160     -44.474  76.837 121.014  1.00 35.63          
ATOM   1126  CG  ASN   160     -43.655  75.604 120.495  1.00 36.13          
ATOM   1127  OD1 ASN   160     -42.459  75.699 120.157  1.00 39.58          
ATOM   1128  ND2 ASN   160     -44.304  74.453 120.455  1.00 33.50          
ATOM   1129  N   SER   161     -44.866  79.845 122.405  1.00 36.15          
ATOM   1130  CA  SER   161     -45.554  81.128 122.601  1.00 35.46          
ATOM   1131  C   SER   161     -44.818  82.297 121.978  1.00 36.28          
ATOM   1132  O   SER   161     -45.426  83.324 121.646  1.00 37.39          
ATOM   1133  CB  SER   161     -45.710  81.447 124.122  1.00 35.38          
ATOM   1134  OG  SER   161     -44.568  82.200 124.583  1.00 32.69          
ATOM   1135  N   VAL   162     -43.504  82.202 121.922  1.00 36.46          
ATOM   1136  CA  VAL   162     -42.673  83.279 121.406  1.00 36.60          
ATOM   1137  C   VAL   162     -42.010  82.827 120.125  1.00 36.85          
ATOM   1138  O   VAL   162     -40.958  83.366 119.759  1.00 38.04          
ATOM   1139  CB  VAL   162     -41.593  83.742 122.399  1.00 36.81          
ATOM   1140  CG1 VAL   162     -42.120  84.930 123.261  1.00 36.35          
ATOM   1141  CG2 VAL   162     -41.109  82.571 123.273  1.00 36.48          
ATOM   1142  N   GLY   163     -42.637  81.866 119.448  1.00 36.83          
ATOM   1143  CA  GLY   163     -42.131  81.340 118.161  1.00 37.06          
ATOM   1144  C   GLY   163     -40.766  80.660 118.283  1.00 37.55          
ATOM   1145  O   GLY   163     -39.929  80.738 117.358  1.00 39.28          
ATOM   1146  N   LEU   164     -40.529  80.019 119.428  1.00 36.30          
ATOM   1147  CA  LEU   164     -39.276  79.301 119.664  1.00 34.93          
ATOM   1148  C   LEU   164     -39.552  77.827 119.978  1.00 33.23          
ATOM   1149  O   LEU   164     -40.697  77.377 119.979  1.00 32.15          
ATOM   1150  CB  LEU   164     -38.430  80.004 120.741  1.00 35.47          
ATOM   1151  CG  LEU   164     -38.075  81.498 120.526  1.00 36.01          
ATOM   1152  CD1 LEU   164     -37.096  82.084 121.621  1.00 32.99          
ATOM   1153  CD2 LEU   164     -37.478  81.714 119.146  1.00 35.69          
ATOM   1154  N   HSD   165     -38.482  77.056 120.178  1.00 32.10          
ATOM   1155  CA  HSD   165     -38.619  75.656 120.526  1.00 31.62          
ATOM   1156  C   HSD   165     -37.429  75.231 121.376  1.00 30.28          
ATOM   1157  O   HSD   165     -36.324  75.719 121.153  1.00 29.79          
ATOM   1158  CB  HSD   165     -38.681  74.807 119.202  1.00 30.88          
ATOM   1159  CG  HSD   165     -39.192  73.426 119.405  1.00 30.41          
ATOM   1160  ND1 HSD   165     -40.535  73.131 119.449  1.00 29.82          
ATOM   1161  CD2 HSD   165     -38.545  72.250 119.587  1.00 31.56          
ATOM   1162  CE1 HSD   165     -40.701  71.845 119.687  1.00 29.33          
ATOM   1163  NE2 HSD   165     -39.505  71.281 119.757  1.00 30.96          
ATOM   1164  N   PRO   166     -37.625  74.280 122.312  1.00 30.00          
ATOM   1165  CA  PRO   166     -36.509  73.764 123.090  1.00 30.28          
ATOM   1166  C   PRO   166     -35.787  72.569 122.455  1.00 30.15          
ATOM   1167  O   PRO   166     -36.433  71.732 121.835  1.00 27.70          
ATOM   1168  CB  PRO   166     -37.182  73.285 124.373  1.00 29.87          
ATOM   1169  CG  PRO   166     -38.484  72.805 123.934  1.00 30.07          
ATOM   1170  CD  PRO   166     -38.887  73.653 122.728  1.00 30.73          
ATOM   1171  N   TRP   167     -34.466  72.493 122.639  1.00 30.72          
ATOM   1172  CA  TRP   167     -33.748  71.235 122.417  1.00 31.72          
ATOM   1173  C   TRP   167     -32.515  71.189 123.247  1.00 32.15          
ATOM   1174  O   TRP   167     -32.037  72.226 123.675  1.00 29.50          
ATOM   1175  CB  TRP   167     -33.379  71.044 120.941  1.00 31.26          
ATOM   1176  CG  TRP   167     -32.440  72.074 120.371  1.00 31.67          
ATOM   1177  CD1 TRP   167     -31.100  71.991 120.304  1.00 31.39          
ATOM   1178  CD2 TRP   167     -32.792  73.329 119.752  1.00 31.95          
ATOM   1179  NE1 TRP   167     -30.578  73.119 119.711  1.00 32.32          
ATOM   1180  CE2 TRP   167     -31.604  73.939 119.349  1.00 29.37          
ATOM   1181  CE3 TRP   167     -34.003  73.982 119.512  1.00 29.78          
ATOM   1182  CZ2 TRP   167     -31.585  75.138 118.684  1.00 32.42          
ATOM   1183  CZ3 TRP   167     -33.997  75.130 118.860  1.00 30.03          
ATOM   1184  CH2 TRP   167     -32.812  75.727 118.453  1.00 31.64          
ATOM   1185  N   LEU   168     -31.985  69.977 123.414  1.00 31.88          
ATOM   1186  CA  LEU   168     -30.630  69.763 123.909  1.00 32.07          
ATOM   1187  C   LEU   168     -29.591  69.720 122.814  1.00 32.16          
ATOM   1188  O   LEU   168     -29.769  69.077 121.778  1.00 31.77          
ATOM   1189  CB  LEU   168     -30.531  68.448 124.728  1.00 33.02          
ATOM   1190  CG  LEU   168     -31.072  68.455 126.145  1.00 32.11          
ATOM   1191  CD1 LEU   168     -30.187  69.333 127.075  1.00 31.71          
ATOM   1192  CD2 LEU   168     -32.495  68.955 126.096  1.00 33.18          
ATOM   1193  N   GLU   169     -28.480  70.392 123.095  1.00 33.09          
ATOM   1194  CA  GLU   169     -27.297  70.352 122.289  1.00 34.11          
ATOM   1195  C   GLU   169     -26.418  69.195 122.690  1.00 32.63          
ATOM   1196  O   GLU   169     -26.570  68.632 123.762  1.00 32.76          
ATOM   1197  CB  GLU   169     -26.506  71.654 122.435  1.00 35.73          
ATOM   1198  CG  GLU   169     -27.307  72.852 122.012  1.00 41.78          
ATOM   1199  CD  GLU   169     -26.585  73.743 121.024  1.00 49.95          
ATOM   1200  OE1 GLU   169     -25.838  74.666 121.452  1.00 53.88          
ATOM   1201  OE2 GLU   169     -26.810  73.547 119.807  1.00 57.45          
ATOM   1202  N   PRO   170     -25.519  68.817 121.810  1.00 31.65          
ATOM   1203  CA  PRO   170     -24.605  67.724 122.055  1.00 32.58          
ATOM   1204  C   PRO   170     -23.891  67.695 123.425  1.00 32.35          
ATOM   1205  O   PRO   170     -23.740  66.614 124.027  1.00 32.03          
ATOM   1206  CB  PRO   170     -23.635  67.841 120.881  1.00 31.62          
ATOM   1207  CG  PRO   170     -24.494  68.300 119.782  1.00 30.98          
ATOM   1208  CD  PRO   170     -25.387  69.323 120.426  1.00 32.12          
ATOM   1209  N   ASP   171     -23.421  68.837 123.894  1.00 32.06          
ATOM   1210  CA  ASP   171     -22.757  68.891 125.194  1.00 32.67          
ATOM   1211  C   ASP   171     -23.691  68.959 126.392  1.00 31.95          
ATOM   1212  O   ASP   171     -23.216  69.175 127.470  1.00 32.48          
ATOM   1213  CB  ASP   171     -21.724  70.048 125.276  1.00 34.02          
ATOM   1214  CG  ASP   171     -22.351  71.432 125.304  1.00 35.15          
ATOM   1215  OD1 ASP   171     -23.597  71.583 125.243  1.00 37.32          
ATOM   1216  OD2 ASP   171     -21.534  72.389 125.320  1.00 43.55          
ATOM   1217  N   GLY   172     -25.004  68.818 126.209  1.00 31.43          
ATOM   1218  CA  GLY   172     -25.924  68.798 127.335  1.00 31.63          
ATOM   1219  C   GLY   172     -26.556  70.158 127.700  1.00 31.89          
ATOM   1220  O   GLY   172     -27.315  70.227 128.662  1.00 30.08          
ATOM   1221  N   THR   173     -26.247  71.214 126.936  1.00 32.65          
ATOM   1222  CA  THR   173     -26.887  72.551 127.114  1.00 33.39          
ATOM   1223  C   THR   173     -28.309  72.510 126.579  1.00 33.70          
ATOM   1224  O   THR   173     -28.561  71.994 125.487  1.00 32.21          
ATOM   1225  CB  THR   173     -26.106  73.635 126.323  1.00 33.52          
ATOM   1226  OG1 THR   173     -24.736  73.609 126.693  1.00 36.35          
ATOM   1227  CG2 THR   173     -26.641  75.020 126.525  1.00 34.69          
ATOM   1228  N   LEU   174     -29.248  73.034 127.373  1.00 33.64          
ATOM   1229  CA  LEU   174     -30.600  73.225 126.936  1.00 34.20          
ATOM   1230  C   LEU   174     -30.659  74.558 126.120  1.00 35.02          
ATOM   1231  O   LEU   174     -30.139  75.597 126.570  1.00 34.35          
ATOM   1232  CB  LEU   174     -31.513  73.252 128.148  1.00 33.97          
ATOM   1233  CG  LEU   174     -32.999  73.531 127.922  1.00 35.80          
ATOM   1234  CD1 LEU   174     -33.683  72.475 127.025  1.00 32.98          
ATOM   1235  CD2 LEU   174     -33.686  73.668 129.299  1.00 33.70          
ATOM   1236  N   VAL   175     -31.250  74.505 124.924  1.00 34.48          
ATOM   1237  CA  VAL   175     -31.397  75.678 124.085  1.00 34.67          
ATOM   1238  C   VAL   175     -32.884  75.926 123.990  1.00 35.50          
ATOM   1239  O   VAL   175     -33.639  74.974 123.968  1.00 35.14          
ATOM   1240  CB  VAL   175     -30.773  75.497 122.729  1.00 33.55          
ATOM   1241  CG1 VAL   175     -31.181  76.628 121.773  1.00 33.55          
ATOM   1242  CG2 VAL   175     -29.270  75.425 122.841  1.00 33.74          
ATOM   1243  N   VAL   176     -33.312  77.197 124.100  1.00 37.14          
ATOM   1244  CA  VAL   176     -34.637  77.626 123.579  1.00 37.35          
ATOM   1245  C   VAL   176     -34.275  78.560 122.464  1.00 37.18          
ATOM   1246  O   VAL   176     -33.380  79.418 122.604  1.00 38.43          
ATOM   1247  CB  VAL   176     -35.612  78.244 124.598  1.00 38.40          
ATOM   1248  CG1 VAL   176     -36.820  78.818 123.876  1.00 40.93          
ATOM   1249  CG2 VAL   176     -36.132  77.184 125.554  1.00 39.70          
ATOM   1250  N   GLY   177     -34.885  78.329 121.311  1.00 36.41          
ATOM   1251  CA  GLY   177     -34.430  78.992 120.109  1.00 36.42          
ATOM   1252  C   GLY   177     -35.118  78.567 118.833  1.00 36.01          
ATOM   1253  O   GLY   177     -36.227  78.056 118.836  1.00 35.78          
END
