
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   80 (  653),  selected   80 , name 2nwa_F
# Molecule2: number of CA atoms  165 ( 1315),  selected  165 , name T0424_6_93_186_208_278_338.pdb
# PARAMETERS: 2nwa_F.T0424_6_93_186_208_278_338.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_F      Y       6           -
LGA    -       -      G       7           -
LGA    -       -      Y       8           -
LGA    G     2_F      A       9          3.533
LGA    X     3_F      V      10          3.923
LGA    -       -      S      11           -
LGA    -       -      V      12           -
LGA    -       -      R      13           -
LGA    -       -      V      14           -
LGA    -       -      G      15           -
LGA    -       -      G      16           -
LGA    -       -      K      17           -
LGA    -       -      E      18           -
LGA    -       -      X      19           -
LGA    -       -      R      20           -
LGA    -       -      X      21           -
LGA    -       -      W      22           -
LGA    -       -      E      23           -
LGA    -       -      R      24           -
LGA    -       -      Y      25           -
LGA    -       -      D      26           -
LGA    -       -      I      27           -
LGA    -       -      D      28           -
LGA    -       -      S      29           -
LGA    -       -      D      30           -
LGA    -       -      F      31           -
LGA    -       -      L      32           -
LGA    -       -      I      33           -
LGA    -       -      P      34           -
LGA    -       -      A      35           -
LGA    -       -      D      36           -
LGA    -       -      S      37           -
LGA    -       -      F      38           -
LGA    -       -      D      39           -
LGA    -       -      F      40           -
LGA    -       -      V      41           -
LGA    -       -      I      42           -
LGA    -       -      G      43           -
LGA    -       -      R      44           -
LGA    -       -      P      52           -
LGA    -       -      D      53           -
LGA    -       -      L      54           -
LGA    -       -      S      55           -
LGA    -       -      G      56           -
LGA    -       -      E      57           -
LGA    -       -      S      58           -
LGA    -       -      C      59           -
LGA    -       -      E      60           -
LGA    -       -      V      61           -
LGA    -       -      V      62           -
LGA    -       -      I      63           -
LGA    P     4_F      D      64          4.584
LGA    V     5_F      G      65           -
LGA    E     6_F      Q      66           -
LGA    F     7_F      I      67           -
LGA    N     8_F      V      68           -
LGA    -       -      M      69           -
LGA    -       -      T      70           -
LGA    -       -      G      71           -
LGA    -       -      I      72           -
LGA    -       -      I      73           -
LGA    -       -      G      74           -
LGA    -       -      S      75           -
LGA    -       -      Q      76           -
LGA    -       -      R      77           -
LGA    -       -      X      78           -
LGA    -       -      G      79           -
LGA    -       -      K      80           -
LGA    -       -      S      81           -
LGA    -       -      K      82           -
LGA    -       -      G      83           -
LGA    -       -      S      84           -
LGA    -       -      R      85           -
LGA    -       -      E      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    -       -      L      89           -
LGA    -       -      S      90           -
LGA    -       -      G      91           -
LGA    -       -      R      92           -
LGA    -       -      D      93           -
LGA    T     9_F      V     186          1.920
LGA    L    10_F      A     187          1.542
LGA    I    11_F      T     188          4.211
LGA    V    12_F      L     189          0.807
LGA    T    13_F      C     190          3.428
LGA    K    14_F      W     191          1.418
LGA    G    15_F      S     192          5.221
LGA    -       -      R     193           -
LGA    -       -      T     194           -
LGA    -       -      D     195           -
LGA    -       -      S     196           -
LGA    -       -      R     197           -
LGA    -       -      C     198           -
LGA    -       -      N     199           -
LGA    -       -      I     200           -
LGA    -       -      E     201           -
LGA    K    16_F      R     202          3.555
LGA    E    17_F      M     203          1.200
LGA    V    18_F      D     204          0.647
LGA    R    19_F      I     205          0.860
LGA    I    20_F      E     206          2.876
LGA    D    21_F      W     207          3.208
LGA    E    22_F      D     208          5.026
LGA    N    23_F      F     278          2.584
LGA    I    24_F      T     279          1.241
LGA    F    25_F      L     280          0.893
LGA    T    26_F      T     281          0.589
LGA    L    27_F      I     282          0.801
LGA    E    28_F      T     283          0.877
LGA    K    29_F      V     284          0.957
LGA    D    30_F      G     285          1.060
LGA    G    31_F      G     286          1.703
LGA    Y    32_F      X     287          2.118
LGA    R    33_F      K     288          3.094
LGA    -       -      T     289           -
LGA    -       -      R     290           -
LGA    -       -      D     291           -
LGA    -       -      G     292           -
LGA    -       -      V     293           -
LGA    V    34_F      L     294          2.126
LGA    Y    35_F      W     295          2.424
LGA    P    36_F      Q     296          4.645
LGA    X    37_F      P     297          2.166
LGA    E    38_F      G     298          2.415
LGA    I    39_F      L     299          3.633
LGA    P    40_F      R     300          3.105
LGA    X    41_F      V     301          3.434
LGA    D    42_F      X     302          1.982
LGA    V    43_F      V     303          1.913
LGA    R    44_F      I     304          2.090
LGA    K    45_F      D     305          3.215
LGA    T    46_F      -       -           -
LGA    K    47_F      -       -           -
LGA    F    48_F      -       -           -
LGA    E    50_F      D     306           #
LGA    K    51_F      E     307           -
LGA    -       -      X     308           -
LGA    -       -      G     309           -
LGA    S    52_F      I     310          4.646
LGA    -       -      D     311           -
LGA    G    53_F      A     312          0.404
LGA    T    54_F      V     313          1.106
LGA    A    55_F      F     314          0.355
LGA    E    56_F      F     315          0.420
LGA    V    57_F      L     316          0.803
LGA    Q    58_F      M     317          1.105
LGA    K    59_F      G     318          0.710
LGA    L    60_F      R     319          0.350
LGA    Q    61_F      R     320          0.431
LGA    W    62_F      F     321          1.212
LGA    E    63_F      M     322          1.508
LGA    E    64_F      L     323          1.102
LGA    -       -      S     324           -
LGA    -       -      R     325           -
LGA    -       -      M     326           -
LGA    -       -      D     327           -
LGA    -       -      G     328           -
LGA    G    65_F      T     329          1.644
LGA    R    66_F      Q     330          1.523
LGA    T    67_F      T     331          1.165
LGA    I    68_F      E     332          0.901
LGA    I    69_F      L     333          0.969
LGA    T    70_F      R     334          0.729
LGA    Y    71_F      L     335          0.282
LGA    K    72_F      K     336          0.699
LGA    L    73_F      E     337          2.998
LGA    T    74_F      D     338          2.866
LGA    S    75_F      -       -           -
LGA    L    76_F      -       -           -
LGA    H    77_F      -       -           -
LGA    S    78_F      -       -           -
LGA    V    79_F      -       -           -
LGA    N    80_F      -       -           -
LGA    L    81_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   80  165    5.0     63    2.39     7.94     26.839     2.530

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.274494 * X  +   0.547744 * Y  +  -0.790335 * Z  + -68.196190
  Y_new =   0.584466 * X  +  -0.557622 * Y  +  -0.589455 * Z  +  73.129181
  Z_new =  -0.763579 * X  +  -0.623726 * Y  +  -0.167074 * Z  + 137.475372 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.832516    1.309076  [ DEG:  -104.9954     75.0046 ]
  Theta =   0.868837    2.272755  [ DEG:    49.7807    130.2193 ]
  Phi   =   2.009870   -1.131722  [ DEG:   115.1571    -64.8429 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nwa_F                                        
REMARK     2: T0424_6_93_186_208_278_338.pdb                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nwa_F.T0424_6_93_186_208_278_338.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   80  165   5.0   63   2.39    7.94  26.839
REMARK  ---------------------------------------------------------- 
MOLECULE 2nwa_F
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   14-NOV-06   2NWA              
TITLE     X-RAY CRYSTAL STRUCTURE OF PROTEIN YTMB FROM BACILLUS                 
TITLE    2 SUBTILIS. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM TARGET            
TITLE    3 SR466                                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN YTMB;                                 
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YTMB;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+ MAGIC;                          
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    MOSTLY BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN              
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    W.ZHOU,F.FOROUHAR,J.SEETHARAMAN,D.WANG,K.CUNNINGHAM,L.-C.MA,          
AUTHOR   2 Y.FANG,R.XIAO,M.C.BARAN,T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,           
AUTHOR   3 L.TONG,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)               
REVDAT   1   09-JAN-07 2NWA    0                                                
JRNL        AUTH   W.ZHOU,F.FOROUHAR,J.SEETHARAMAN,D.WANG,                      
JRNL        AUTH 2 K.CUNNINGHAM,L.-C.MA,Y.FANG,R.XIAO,M.C.BARAN,                
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE HYPOTHETICAL PROTEIN YTMB           
JRNL        TITL 2 FROM BACILLUS SUBTILIS SUBSP. (SUBTILIS STR. 168),           
JRNL        TITL 3 NORTHEAST STRUCTURAL GENOMICS TARGET SR466                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  2NWA A    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA B    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA C    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA D    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA E    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA F    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA G    1    80  UNP    O34365   YTMB_BACSU       1     80             
DBREF  2NWA H    1    80  UNP    O34365   YTMB_BACSU       1     80             
SEQRES   1 A   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 A   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 A   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 A   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 A   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 A   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 A   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 B   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 B   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 B   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 B   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 B   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 B   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 B   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 C   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 C   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 C   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 C   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 C   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 C   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 C   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 D   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 D   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 D   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 D   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 D   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 D   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 D   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 E   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 E   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 E   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 E   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 E   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 E   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 E   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 F   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 F   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 F   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 F   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 F   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 F   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 F   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 G   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 G   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 G   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 G   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 G   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 G   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 G   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
SEQRES   1 H   88  MSE GLY MSE PRO VAL GLU PHE ASN THR LEU ILE VAL THR          
SEQRES   2 H   88  LYS GLY LYS GLU VAL ARG ILE ASP GLU ASN ILE PHE THR          
SEQRES   3 H   88  LEU GLU LYS ASP GLY TYR ARG VAL TYR PRO MSE GLU ILE          
SEQRES   4 H   88  PRO MSE ASP VAL ARG LYS THR LYS PHE GLY GLU LYS SER          
SEQRES   5 H   88  GLY THR ALA GLU VAL GLN LYS LEU GLN TRP GLU GLU GLY          
SEQRES   6 H   88  ARG THR ILE ILE THR TYR LYS LEU THR SER LEU HIS SER          
SEQRES   7 H   88  VAL ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
HET    MSE  A   1       8                                                       
HET    MSE  A   3       8                                                       
HET    MSE  A  37       8                                                       
HET    MSE  A  41       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   3       8                                                       
HET    MSE  B  37       8                                                       
HET    MSE  B  41       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C   3       8                                                       
HET    MSE  C  37       8                                                       
HET    MSE  C  41       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D   3       8                                                       
HET    MSE  D  37       8                                                       
HET    MSE  D  41       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E   3       8                                                       
HET    MSE  E  37       8                                                       
HET    MSE  E  41       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  F   3       8                                                       
HET    MSE  F  37       8                                                       
HET    MSE  F  41       8                                                       
HET    MSE  G   1       8                                                       
HET    MSE  G   3       8                                                       
HET    MSE  G  37       8                                                       
HET    MSE  G  41       8                                                       
HET    MSE  H   1       8                                                       
HET    MSE  H   3       8                                                       
HET    MSE  H  37       8                                                       
HET    MSE  H  41       8                                                       
HET    SO4  A 201       5                                                       
HET    SO4  B 201       5                                                       
HET    SO4  C 201       5                                                       
HET    SO4  D 201       5                                                       
HET    SO4  E 201       5                                                       
HET    SO4  F 201       5                                                       
HET    SO4  G 201       5                                                       
HET    SO4  H 201       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    32(C5 H11 N O2 SE)                                           
FORMUL   9  SO4    8(O4 S 2-)                                                   
FORMUL  17  HOH   *92(H2 O)                                                     
CRYST1   60.662  110.739   60.672  90.00 111.06  90.00 P 1 21 1     16          
HETATM 3271  N   MSE F   1     -11.028  53.463 118.295  1.00 73.58           N  
HETATM 3272  CA  MSE F   1     -10.148  53.760 117.127  1.00 73.59           C  
HETATM 3273  C   MSE F   1      -9.945  55.257 116.991  1.00 71.15           C  
HETATM 3274  O   MSE F   1      -8.923  55.715 116.469  1.00 71.33           O  
HETATM 3275  CB  MSE F   1     -10.749  53.209 115.830  1.00 77.71           C  
HETATM 3276  CG  MSE F   1     -10.916  51.699 115.823  1.00 82.41           C  
HETATM 3277 SE   MSE F   1     -12.226  51.091 117.122  1.00 91.24          SE  
HETATM 3278  CE  MSE F   1     -13.729  50.785 115.904  1.00 87.81           C  
ATOM   3279  N   GLY F   2     -10.922  56.021 117.470  1.00 67.67           N  
ATOM   3280  CA  GLY F   2     -10.819  57.469 117.395  1.00 63.40           C  
ATOM   3281  C   GLY F   2     -12.078  58.131 116.872  1.00 60.00           C  
ATOM   3282  O   GLY F   2     -12.106  59.339 116.645  1.00 61.69           O  
HETATM 3283  N   MSE F   3     -13.118  57.325 116.685  1.00 53.98           N  
HETATM 3284  CA  MSE F   3     -14.418  57.773 116.193  1.00 48.95           C  
HETATM 3285  C   MSE F   3     -14.347  58.774 115.035  1.00 44.59           C  
HETATM 3286  O   MSE F   3     -14.296  59.989 115.251  1.00 42.71           O  
HETATM 3287  CB  MSE F   3     -15.250  58.362 117.342  1.00 49.87           C  
HETATM 3288  CG  MSE F   3     -16.637  58.864 116.919  1.00 51.81           C  
HETATM 3289 SE   MSE F   3     -17.672  57.582 115.850  1.00 60.02          SE  
HETATM 3290  CE  MSE F   3     -19.171  58.691 115.355  1.00 55.22           C  
ATOM   3291  N   PRO F   4     -14.350  58.266 113.792  1.00 40.63           N  
ATOM   3292  CA  PRO F   4     -14.289  59.091 112.585  1.00 37.51           C  
ATOM   3293  C   PRO F   4     -15.674  59.589 112.149  1.00 35.50           C  
ATOM   3294  O   PRO F   4     -16.651  58.832 112.143  1.00 33.89           O  
ATOM   3295  CB  PRO F   4     -13.675  58.147 111.573  1.00 37.49           C  
ATOM   3296  CG  PRO F   4     -14.358  56.863 111.923  1.00 38.04           C  
ATOM   3297  CD  PRO F   4     -14.320  56.834 113.447  1.00 40.03           C  
ATOM   3298  N   VAL F   5     -15.750  60.871 111.800  1.00 33.28           N  
ATOM   3299  CA  VAL F   5     -16.989  61.480 111.330  1.00 31.13           C  
ATOM   3300  C   VAL F   5     -16.642  62.417 110.177  1.00 30.22           C  
ATOM   3301  O   VAL F   5     -15.501  62.844 110.060  1.00 29.01           O  
ATOM   3302  CB  VAL F   5     -17.681  62.303 112.426  1.00 30.46           C  
ATOM   3303  CG1 VAL F   5     -17.816  61.478 113.690  1.00 28.94           C  
ATOM   3304  CG2 VAL F   5     -16.905  63.599 112.676  1.00 30.05           C  
ATOM   3305  N   GLU F   6     -17.623  62.723 109.330  1.00 30.02           N  
ATOM   3306  CA  GLU F   6     -17.423  63.631 108.216  1.00 30.28           C  
ATOM   3307  C   GLU F   6     -18.336  64.865 108.408  1.00 30.81           C  
ATOM   3308  O   GLU F   6     -19.503  64.741 108.773  1.00 28.61           O  
ATOM   3309  CB  GLU F   6     -17.762  62.919 106.915  1.00 30.48           C  
ATOM   3310  CG  GLU F   6     -17.424  63.685 105.642  1.00 31.42           C  
ATOM   3311  CD  GLU F   6     -17.717  62.865 104.364  1.00 32.18           C  
ATOM   3312  OE1 GLU F   6     -17.568  61.620 104.393  1.00 32.41           O  
ATOM   3313  OE2 GLU F   6     -18.069  63.464 103.330  1.00 31.27           O  
ATOM   3314  N   PHE F   7     -17.795  66.058 108.198  1.00 32.54           N  
ATOM   3315  CA  PHE F   7     -18.592  67.261 108.321  1.00 33.25           C  
ATOM   3316  C   PHE F   7     -19.004  67.711 106.931  1.00 32.56           C  
ATOM   3317  O   PHE F   7     -18.155  67.944 106.065  1.00 30.48           O  
ATOM   3318  CB  PHE F   7     -17.803  68.383 108.987  1.00 37.22           C  
ATOM   3319  CG  PHE F   7     -17.348  68.049 110.373  1.00 42.26           C  
ATOM   3320  CD1 PHE F   7     -18.192  67.384 111.257  1.00 44.32           C  
ATOM   3321  CD2 PHE F   7     -16.079  68.407 110.807  1.00 45.43           C  
ATOM   3322  CE1 PHE F   7     -17.770  67.051 112.549  1.00 46.08           C  
ATOM   3323  CE2 PHE F   7     -15.649  68.078 112.104  1.00 46.88           C  
ATOM   3324  CZ  PHE F   7     -16.502  67.409 112.974  1.00 45.93           C  
ATOM   3325  N   ASN F   8     -20.310  67.831 106.715  1.00 32.42           N  
ATOM   3326  CA  ASN F   8     -20.821  68.255 105.418  1.00 31.59           C  
ATOM   3327  C   ASN F   8     -21.492  69.611 105.540  1.00 32.21           C  
ATOM   3328  O   ASN F   8     -22.164  69.903 106.521  1.00 32.32           O  
ATOM   3329  CB  ASN F   8     -21.788  67.202 104.884  1.00 30.35           C  
ATOM   3330  CG  ASN F   8     -21.083  65.930 104.476  1.00 30.64           C  
ATOM   3331  OD1 ASN F   8     -21.556  64.836 104.759  1.00 33.05           O  
ATOM   3332  ND2 ASN F   8     -19.952  66.063 103.807  1.00 27.18           N  
ATOM   3333  N   THR F   9     -21.291  70.452 104.540  1.00 32.76           N  
ATOM   3334  CA  THR F   9     -21.887  71.774 104.577  1.00 33.27           C  
ATOM   3335  C   THR F   9     -23.000  71.890 103.531  1.00 33.46           C  
ATOM   3336  O   THR F   9     -23.714  72.887 103.473  1.00 33.28           O  
ATOM   3337  CB  THR F   9     -20.825  72.855 104.313  1.00 32.60           C  
ATOM   3338  OG1 THR F   9     -20.381  72.776 102.950  1.00 32.30           O  
ATOM   3339  CG2 THR F   9     -19.653  72.641 105.234  1.00 32.22           C  
ATOM   3340  N   LEU F  10     -23.136  70.858 102.714  1.00 33.75           N  
ATOM   3341  CA  LEU F  10     -24.133  70.838 101.663  1.00 35.00           C  
ATOM   3342  C   LEU F  10     -24.809  69.485 101.526  1.00 34.00           C  
ATOM   3343  O   LEU F  10     -24.209  68.457 101.818  1.00 33.21           O  
ATOM   3344  CB  LEU F  10     -23.499  71.207 100.313  1.00 37.31           C  
ATOM   3345  CG  LEU F  10     -23.413  72.692  99.972  1.00 40.65           C  
ATOM   3346  CD1 LEU F  10     -22.286  73.384 100.727  1.00 40.37           C  
ATOM   3347  CD2 LEU F  10     -23.209  72.803  98.476  1.00 41.51           C  
ATOM   3348  N   ILE F  11     -26.062  69.486 101.080  1.00 33.44           N  
ATOM   3349  CA  ILE F  11     -26.774  68.231 100.875  1.00 33.30           C  
ATOM   3350  C   ILE F  11     -26.608  67.826  99.407  1.00 34.08           C  
ATOM   3351  O   ILE F  11     -27.133  68.497  98.504  1.00 32.80           O  
ATOM   3352  CB  ILE F  11     -28.275  68.355 101.124  1.00 33.34           C  
ATOM   3353  CG1 ILE F  11     -28.563  68.912 102.517  1.00 33.28           C  
ATOM   3354  CG2 ILE F  11     -28.918  66.994 100.946  1.00 31.36           C  
ATOM   3355  CD1 ILE F  11     -28.245  67.957 103.633  1.00 35.58           C  
ATOM   3356  N   VAL F  12     -25.880  66.738  99.164  1.00 34.47           N  
ATOM   3357  CA  VAL F  12     -25.683  66.249  97.798  1.00 34.84           C  
ATOM   3358  C   VAL F  12     -26.440  64.951  97.580  1.00 34.21           C  
ATOM   3359  O   VAL F  12     -25.972  63.892  97.968  1.00 32.36           O  
ATOM   3360  CB  VAL F  12     -24.192  65.993  97.474  1.00 34.71           C  
ATOM   3361  CG1 VAL F  12     -24.067  65.398  96.083  1.00 33.10           C  
ATOM   3362  CG2 VAL F  12     -23.409  67.293  97.554  1.00 33.62           C  
ATOM   3363  N   THR F  13     -27.610  65.048  96.957  1.00 36.50           N  
ATOM   3364  CA  THR F  13     -28.451  63.881  96.673  1.00 39.30           C  
ATOM   3365  C   THR F  13     -28.073  63.285  95.313  1.00 41.24           C  
ATOM   3366  O   THR F  13     -28.310  63.905  94.282  1.00 43.19           O  
ATOM   3367  CB  THR F  13     -29.941  64.279  96.600  1.00 38.53           C  
ATOM   3368  OG1 THR F  13     -30.146  65.167  95.490  1.00 36.21           O  
ATOM   3369  CG2 THR F  13     -30.370  64.990  97.874  1.00 39.60           C  
ATOM   3370  N   LYS F  14     -27.485  62.097  95.303  1.00 41.95           N  
ATOM   3371  CA  LYS F  14     -27.107  61.477  94.044  1.00 41.96           C  
ATOM   3372  C   LYS F  14     -28.376  60.911  93.399  1.00 42.72           C  
ATOM   3373  O   LYS F  14     -28.371  59.823  92.818  1.00 42.79           O  
ATOM   3374  CB  LYS F  14     -26.104  60.339  94.277  1.00 42.73           C  
ATOM   3375  CG  LYS F  14     -24.836  60.737  95.037  1.00 43.33           C  
ATOM   3376  CD  LYS F  14     -24.119  61.911  94.401  1.00 42.96           C  
ATOM   3377  CE  LYS F  14     -22.759  62.146  95.039  1.00 42.79           C  
ATOM   3378  NZ  LYS F  14     -21.822  61.017  94.820  1.00 44.23           N  
ATOM   3379  N   GLY F  15     -29.468  61.656  93.510  1.00 43.51           N  
ATOM   3380  CA  GLY F  15     -30.730  61.207  92.961  1.00 43.13           C  
ATOM   3381  C   GLY F  15     -31.258  60.067  93.800  1.00 43.95           C  
ATOM   3382  O   GLY F  15     -32.241  59.435  93.440  1.00 44.45           O  
ATOM   3383  N   LYS F  16     -30.610  59.815  94.935  1.00 44.47           N  
ATOM   3384  CA  LYS F  16     -30.998  58.721  95.822  1.00 44.05           C  
ATOM   3385  C   LYS F  16     -31.843  59.144  97.011  1.00 42.53           C  
ATOM   3386  O   LYS F  16     -32.018  58.367  97.949  1.00 41.37           O  
ATOM   3387  CB  LYS F  16     -29.746  57.988  96.319  1.00 45.86           C  
ATOM   3388  CG  LYS F  16     -28.700  58.923  96.896  1.00 48.38           C  
ATOM   3389  CD  LYS F  16     -27.567  58.191  97.598  1.00 49.12           C  
ATOM   3390  CE  LYS F  16     -26.593  59.188  98.198  1.00 48.97           C  
ATOM   3391  NZ  LYS F  16     -25.532  58.504  98.967  1.00 52.36           N  
ATOM   3392  N   GLU F  17     -32.379  60.361  96.978  1.00 42.64           N  
ATOM   3393  CA  GLU F  17     -33.210  60.828  98.086  1.00 43.64           C  
ATOM   3394  C   GLU F  17     -34.625  60.266  97.969  1.00 43.77           C  
ATOM   3395  O   GLU F  17     -35.098  59.978  96.879  1.00 44.59           O  
ATOM   3396  CB  GLU F  17     -33.253  62.370  98.148  1.00 44.20           C  
ATOM   3397  CG  GLU F  17     -34.130  63.063  97.108  1.00 45.21           C  
ATOM   3398  CD  GLU F  17     -33.444  63.220  95.766  1.00 45.69           C  
ATOM   3399  OE1 GLU F  17     -33.973  63.958  94.903  1.00 45.19           O  
ATOM   3400  OE2 GLU F  17     -32.375  62.605  95.566  1.00 46.22           O  
ATOM   3401  N   VAL F  18     -35.293  60.112  99.101  1.00 44.23           N  
ATOM   3402  CA  VAL F  18     -36.644  59.572  99.125  1.00 45.29           C  
ATOM   3403  C   VAL F  18     -37.584  60.520  99.870  1.00 47.55           C  
ATOM   3404  O   VAL F  18     -37.267  60.969 100.975  1.00 49.22           O  
ATOM   3405  CB  VAL F  18     -36.662  58.208  99.849  1.00 44.33           C  
ATOM   3406  CG1 VAL F  18     -38.040  57.606  99.805  1.00 43.45           C  
ATOM   3407  CG2 VAL F  18     -35.640  57.281  99.233  1.00 43.65           C  
ATOM   3408  N   ARG F  19     -38.735  60.840  99.290  1.00 48.96           N  
ATOM   3409  CA  ARG F  19     -39.657  61.727  99.988  1.00 50.84           C  
ATOM   3410  C   ARG F  19     -40.606  60.909 100.847  1.00 51.43           C  
ATOM   3411  O   ARG F  19     -41.210  59.955 100.374  1.00 51.92           O  
ATOM   3412  CB  ARG F  19     -40.453  62.587  99.006  1.00 52.18           C  
ATOM   3413  CG  ARG F  19     -41.147  61.820  97.906  1.00 54.00           C  
ATOM   3414  CD  ARG F  19     -42.484  62.465  97.566  1.00 54.90           C  
ATOM   3415  NE  ARG F  19     -42.367  63.896  97.317  1.00 55.68           N  
ATOM   3416  CZ  ARG F  19     -41.649  64.431  96.334  1.00 56.53           C  
ATOM   3417  NH1 ARG F  19     -40.973  63.650  95.497  1.00 57.22           N  
ATOM   3418  NH2 ARG F  19     -41.612  65.750  96.183  1.00 56.76           N  
ATOM   3419  N   ILE F  20     -40.722  61.278 102.117  1.00 52.41           N  
ATOM   3420  CA  ILE F  20     -41.598  60.564 103.040  1.00 53.13           C  
ATOM   3421  C   ILE F  20     -42.879  61.365 103.276  1.00 54.56           C  
ATOM   3422  O   ILE F  20     -43.841  60.871 103.872  1.00 55.07           O  
ATOM   3423  CB  ILE F  20     -40.905  60.318 104.396  1.00 52.36           C  
ATOM   3424  CG1 ILE F  20     -40.548  61.653 105.047  1.00 51.37           C  
ATOM   3425  CG2 ILE F  20     -39.678  59.453 104.195  1.00 50.24           C  
ATOM   3426  CD1 ILE F  20     -40.016  61.529 106.454  1.00 51.77           C  
ATOM   3427  N   ASP F  21     -42.877  62.610 102.816  1.00 55.75           N  
ATOM   3428  CA  ASP F  21     -44.036  63.473 102.949  1.00 56.98           C  
ATOM   3429  C   ASP F  21     -44.075  64.367 101.713  1.00 57.86           C  
ATOM   3430  O   ASP F  21     -43.633  63.954 100.635  1.00 59.23           O  
ATOM   3431  CB  ASP F  21     -43.946  64.338 104.202  1.00 57.36           C  
ATOM   3432  CG  ASP F  21     -45.306  64.628 104.806  1.00 57.62           C  
ATOM   3433  OD1 ASP F  21     -46.295  64.722 104.044  1.00 57.33           O  
ATOM   3434  OD2 ASP F  21     -45.381  64.786 106.042  1.00 57.43           O  
ATOM   3435  N   GLU F  22     -44.586  65.587 101.864  1.00 57.79           N  
ATOM   3436  CA  GLU F  22     -44.681  66.487 100.730  1.00 58.73           C  
ATOM   3437  C   GLU F  22     -43.403  67.267 100.446  1.00 58.39           C  
ATOM   3438  O   GLU F  22     -42.954  67.329  99.295  1.00 59.55           O  
ATOM   3439  CB  GLU F  22     -45.845  67.462 100.908  1.00 59.74           C  
ATOM   3440  CG  GLU F  22     -45.778  68.320 102.157  1.00 62.52           C  
ATOM   3441  CD  GLU F  22     -46.752  69.496 102.110  1.00 64.24           C  
ATOM   3442  OE1 GLU F  22     -47.947  69.276 101.787  1.00 64.71           O  
ATOM   3443  OE2 GLU F  22     -46.325  70.643 102.401  1.00 65.54           O  
ATOM   3444  N   ASN F  23     -42.808  67.859 101.475  1.00 56.44           N  
ATOM   3445  CA  ASN F  23     -41.595  68.628 101.270  1.00 54.45           C  
ATOM   3446  C   ASN F  23     -40.395  68.107 102.039  1.00 52.62           C  
ATOM   3447  O   ASN F  23     -39.294  68.661 101.944  1.00 52.24           O  
ATOM   3448  CB  ASN F  23     -41.845  70.091 101.617  1.00 55.86           C  
ATOM   3449  CG  ASN F  23     -42.574  70.833 100.504  1.00 56.30           C  
ATOM   3450  OD1 ASN F  23     -43.078  71.945 100.704  1.00 57.66           O  
ATOM   3451  ND2 ASN F  23     -42.619  70.226  99.320  1.00 55.13           N  
ATOM   3452  N   ILE F  24     -40.595  67.039 102.801  1.00 50.60           N  
ATOM   3453  CA  ILE F  24     -39.501  66.456 103.574  1.00 47.74           C  
ATOM   3454  C   ILE F  24     -38.993  65.166 102.936  1.00 44.81           C  
ATOM   3455  O   ILE F  24     -39.766  64.281 102.593  1.00 44.11           O  
ATOM   3456  CB  ILE F  24     -39.934  66.177 105.050  1.00 48.58           C  
ATOM   3457  CG1 ILE F  24     -40.932  65.027 105.101  1.00 48.73           C  
ATOM   3458  CG2 ILE F  24     -40.562  67.426 105.656  1.00 46.75           C  
ATOM   3459  CD1 ILE F  24     -41.300  64.616 106.506  1.00 50.88           C  
ATOM   3460  N   PHE F  25     -37.681  65.067 102.795  1.00 42.89           N  
ATOM   3461  CA  PHE F  25     -37.059  63.908 102.169  1.00 41.37           C  
ATOM   3462  C   PHE F  25     -36.106  63.216 103.130  1.00 40.39           C  
ATOM   3463  O   PHE F  25     -35.848  63.706 104.231  1.00 41.08           O  
ATOM   3464  CB  PHE F  25     -36.267  64.360 100.935  1.00 41.59           C  
ATOM   3465  CG  PHE F  25     -37.098  65.116  99.935  1.00 40.77           C  
ATOM   3466  CD1 PHE F  25     -37.649  64.464  98.838  1.00 40.83           C  
ATOM   3467  CD2 PHE F  25     -37.327  66.479 100.088  1.00 39.94           C  
ATOM   3468  CE1 PHE F  25     -38.441  65.148  97.933  1.00 40.60           C  
ATOM   3469  CE2 PHE F  25     -38.117  67.169  99.191  1.00 40.12           C  
ATOM   3470  CZ  PHE F  25     -38.664  66.507  98.102  1.00 40.89           C  
ATOM   3471  N   THR F  26     -35.585  62.072 102.712  1.00 38.28           N  
ATOM   3472  CA  THR F  26     -34.634  61.350 103.527  1.00 36.44           C  
ATOM   3473  C   THR F  26     -33.482  60.956 102.623  1.00 35.83           C  
ATOM   3474  O   THR F  26     -33.693  60.519 101.492  1.00 35.24           O  
ATOM   3475  CB  THR F  26     -35.243  60.092 104.162  1.00 36.23           C  
ATOM   3476  OG1 THR F  26     -35.658  59.188 103.137  1.00 37.15           O  
ATOM   3477  CG2 THR F  26     -36.424  60.454 105.030  1.00 34.86           C  
ATOM   3478  N   LEU F  27     -32.263  61.141 103.117  1.00 34.60           N  
ATOM   3479  CA  LEU F  27     -31.064  60.798 102.365  1.00 33.72           C  
ATOM   3480  C   LEU F  27     -30.165  59.920 103.228  1.00 33.97           C  
ATOM   3481  O   LEU F  27     -29.941  60.207 104.402  1.00 33.68           O  
ATOM   3482  CB  LEU F  27     -30.301  62.057 101.957  1.00 32.33           C  
ATOM   3483  CG  LEU F  27     -29.805  62.104 100.510  1.00 31.26           C  
ATOM   3484  CD1 LEU F  27     -28.645  63.076 100.407  1.00 31.07           C  
ATOM   3485  CD2 LEU F  27     -29.374  60.728 100.061  1.00 28.88           C  
ATOM   3486  N   GLU F  28     -29.659  58.843 102.641  1.00 34.44           N  
ATOM   3487  CA  GLU F  28     -28.783  57.931 103.355  1.00 35.73           C  
ATOM   3488  C   GLU F  28     -27.374  58.077 102.806  1.00 35.26           C  
ATOM   3489  O   GLU F  28     -27.150  57.927 101.602  1.00 35.52           O  
ATOM   3490  CB  GLU F  28     -29.270  56.490 103.189  1.00 37.46           C  
ATOM   3491  CG  GLU F  28     -28.701  55.521 104.214  1.00 38.80           C  
ATOM   3492  CD  GLU F  28     -29.359  54.156 104.141  1.00 38.85           C  
ATOM   3493  OE1 GLU F  28     -30.607  54.105 104.087  1.00 38.64           O  
ATOM   3494  OE2 GLU F  28     -28.633  53.136 104.148  1.00 40.45           O  
ATOM   3495  N   LYS F  29     -26.435  58.395 103.694  1.00 34.80           N  
ATOM   3496  CA  LYS F  29     -25.038  58.567 103.324  1.00 33.39           C  
ATOM   3497  C   LYS F  29     -24.167  57.495 103.983  1.00 33.63           C  
ATOM   3498  O   LYS F  29     -24.544  56.901 104.987  1.00 32.76           O  
ATOM   3499  CB  LYS F  29     -24.579  59.948 103.744  1.00 32.00           C  
ATOM   3500  CG  LYS F  29     -25.167  61.060 102.919  1.00 31.41           C  
ATOM   3501  CD  LYS F  29     -24.565  61.068 101.523  1.00 31.18           C  
ATOM   3502  CE  LYS F  29     -25.094  62.222 100.689  1.00 30.87           C  
ATOM   3503  NZ  LYS F  29     -24.695  62.065  99.273  1.00 32.32           N  
ATOM   3504  N   ASP F  30     -23.003  57.242 103.395  1.00 35.38           N  
ATOM   3505  CA  ASP F  30     -22.068  56.256 103.922  1.00 35.85           C  
ATOM   3506  C   ASP F  30     -21.180  56.947 104.960  1.00 34.41           C  
ATOM   3507  O   ASP F  30     -20.726  58.074 104.747  1.00 34.50           O  
ATOM   3508  CB  ASP F  30     -21.207  55.703 102.788  1.00 38.04           C  
ATOM   3509  CG  ASP F  30     -20.617  54.353 103.120  1.00 42.24           C  
ATOM   3510  OD1 ASP F  30     -19.865  54.246 104.123  1.00 43.24           O  
ATOM   3511  OD2 ASP F  30     -20.897  53.382 102.371  1.00 45.00           O  
ATOM   3512  N   GLY F  31     -20.939  56.275 106.080  1.00 32.72           N  
ATOM   3513  CA  GLY F  31     -20.108  56.863 107.117  1.00 32.15           C  
ATOM   3514  C   GLY F  31     -20.919  57.750 108.047  1.00 31.49           C  
ATOM   3515  O   GLY F  31     -22.042  58.138 107.713  1.00 32.48           O  
ATOM   3516  N   TYR F  32     -20.368  58.069 109.217  1.00 29.16           N  
ATOM   3517  CA  TYR F  32     -21.075  58.924 110.181  1.00 27.38           C  
ATOM   3518  C   TYR F  32     -20.834  60.375 109.828  1.00 26.22           C  
ATOM   3519  O   TYR F  32     -19.749  60.885 110.081  1.00 24.16           O  
ATOM   3520  CB  TYR F  32     -20.590  58.645 111.605  1.00 25.38           C  
ATOM   3521  CG  TYR F  32     -20.776  57.203 112.012  1.00 25.51           C  
ATOM   3522  CD1 TYR F  32     -22.045  56.625 112.006  1.00 25.94           C  
ATOM   3523  CD2 TYR F  32     -19.691  56.417 112.418  1.00 25.73           C  
ATOM   3524  CE1 TYR F  32     -22.248  55.305 112.393  1.00 25.97           C  
ATOM   3525  CE2 TYR F  32     -19.877  55.086 112.815  1.00 24.96           C  
ATOM   3526  CZ  TYR F  32     -21.162  54.538 112.797  1.00 26.03           C  
ATOM   3527  OH  TYR F  32     -21.364  53.224 113.173  1.00 26.94           O  
ATOM   3528  N   ARG F  33     -21.841  61.029 109.238  1.00 25.98           N  
ATOM   3529  CA  ARG F  33     -21.726  62.435 108.843  1.00 25.67           C  
ATOM   3530  C   ARG F  33     -22.356  63.399 109.845  1.00 24.95           C  
ATOM   3531  O   ARG F  33     -23.277  63.033 110.564  1.00 25.61           O  
ATOM   3532  CB  ARG F  33     -22.380  62.676 107.472  1.00 27.43           C  
ATOM   3533  CG  ARG F  33     -21.517  62.350 106.258  1.00 30.31           C  
ATOM   3534  CD  ARG F  33     -21.553  60.866 105.923  1.00 31.98           C  
ATOM   3535  NE  ARG F  33     -20.906  60.545 104.647  1.00 33.30           N  
ATOM   3536  CZ  ARG F  33     -21.140  61.167 103.496  1.00 33.07           C  
ATOM   3537  NH1 ARG F  33     -22.002  62.162 103.425  1.00 31.04           N  
ATOM   3538  NH2 ARG F  33     -20.519  60.769 102.405  1.00 35.01           N  
ATOM   3539  N   VAL F  34     -21.846  64.626 109.884  1.00 24.47           N  
ATOM   3540  CA  VAL F  34     -22.368  65.677 110.755  1.00 23.16           C  
ATOM   3541  C   VAL F  34     -22.932  66.757 109.836  1.00 23.14           C  
ATOM   3542  O   VAL F  34     -22.221  67.305 108.995  1.00 21.09           O  
ATOM   3543  CB  VAL F  34     -21.238  66.305 111.654  1.00 22.65           C  
ATOM   3544  CG1 VAL F  34     -21.692  67.599 112.283  1.00 20.09           C  
ATOM   3545  CG2 VAL F  34     -20.838  65.319 112.743  1.00 21.37           C  
ATOM   3546  N   TYR F  35     -24.216  67.041 109.973  1.00 24.51           N  
ATOM   3547  CA  TYR F  35     -24.849  68.061 109.148  1.00 26.61           C  
ATOM   3548  C   TYR F  35     -25.372  69.177 110.043  1.00 28.24           C  
ATOM   3549  O   TYR F  35     -25.811  68.916 111.162  1.00 28.37           O  
ATOM   3550  CB  TYR F  35     -26.019  67.439 108.363  1.00 25.82           C  
ATOM   3551  CG  TYR F  35     -25.627  66.634 107.141  1.00 23.14           C  
ATOM   3552  CD1 TYR F  35     -25.427  67.248 105.900  1.00 21.86           C  
ATOM   3553  CD2 TYR F  35     -25.455  65.258 107.227  1.00 22.77           C  
ATOM   3554  CE1 TYR F  35     -25.070  66.510 104.774  1.00 21.29           C  
ATOM   3555  CE2 TYR F  35     -25.093  64.499 106.109  1.00 22.10           C  
ATOM   3556  CZ  TYR F  35     -24.903  65.134 104.886  1.00 21.07           C  
ATOM   3557  OH  TYR F  35     -24.549  64.388 103.792  1.00 20.34           O  
ATOM   3558  N   PRO F  36     -25.290  70.438 109.582  1.00 29.54           N  
ATOM   3559  CA  PRO F  36     -25.802  71.544 110.404  1.00 31.58           C  
ATOM   3560  C   PRO F  36     -27.286  71.255 110.616  1.00 33.12           C  
ATOM   3561  O   PRO F  36     -27.978  70.888 109.662  1.00 33.80           O  
ATOM   3562  CB  PRO F  36     -25.587  72.765 109.511  1.00 30.96           C  
ATOM   3563  CG  PRO F  36     -24.341  72.416 108.771  1.00 29.46           C  
ATOM   3564  CD  PRO F  36     -24.535  70.948 108.423  1.00 29.48           C  
HETATM 3565  N   MSE F  37     -27.778  71.401 111.840  1.00 34.12           N  
HETATM 3566  CA  MSE F  37     -29.180  71.108 112.116  1.00 36.92           C  
HETATM 3567  C   MSE F  37     -30.008  72.384 112.203  1.00 37.95           C  
HETATM 3568  O   MSE F  37     -29.505  73.425 112.620  1.00 39.00           O  
HETATM 3569  CB  MSE F  37     -29.285  70.329 113.421  1.00 38.96           C  
HETATM 3570  CG  MSE F  37     -30.423  69.323 113.475  1.00 44.58           C  
HETATM 3571 SE   MSE F  37     -29.962  67.541 112.839  1.00 49.27          SE  
HETATM 3572  CE  MSE F  37     -28.736  68.076 111.445  1.00 47.71           C  
ATOM   3573  N   GLU F  38     -31.273  72.317 111.784  1.00 39.59           N  
ATOM   3574  CA  GLU F  38     -32.174  73.476 111.846  1.00 40.72           C  
ATOM   3575  C   GLU F  38     -31.673  74.654 111.034  1.00 40.59           C  
ATOM   3576  O   GLU F  38     -32.351  75.670 110.937  1.00 40.16           O  
ATOM   3577  CB  GLU F  38     -32.319  73.939 113.290  1.00 42.91           C  
ATOM   3578  CG  GLU F  38     -33.711  73.955 113.813  1.00 46.54           C  
ATOM   3579  CD  GLU F  38     -34.178  72.602 114.232  1.00 49.62           C  
ATOM   3580  OE1 GLU F  38     -34.285  71.717 113.346  1.00 52.12           O  
ATOM   3581  OE2 GLU F  38     -34.431  72.419 115.454  1.00 49.47           O  
ATOM   3582  N   ILE F  39     -30.474  74.524 110.480  1.00 40.92           N  
ATOM   3583  CA  ILE F  39     -29.859  75.590 109.693  1.00 41.28           C  
ATOM   3584  C   ILE F  39     -30.054  75.355 108.194  1.00 41.89           C  
ATOM   3585  O   ILE F  39     -29.833  74.253 107.687  1.00 43.67           O  
ATOM   3586  CB  ILE F  39     -28.350  75.663 109.983  1.00 39.94           C  
ATOM   3587  CG1 ILE F  39     -28.132  75.838 111.483  1.00 40.51           C  
ATOM   3588  CG2 ILE F  39     -27.721  76.794 109.200  1.00 40.13           C  
ATOM   3589  CD1 ILE F  39     -26.704  75.656 111.915  1.00 39.82           C  
ATOM   3590  N   PRO F  40     -30.463  76.393 107.461  1.00 42.09           N  
ATOM   3591  CA  PRO F  40     -30.672  76.250 106.023  1.00 43.00           C  
ATOM   3592  C   PRO F  40     -29.363  76.085 105.256  1.00 43.86           C  
ATOM   3593  O   PRO F  40     -28.390  76.792 105.518  1.00 43.33           O  
ATOM   3594  CB  PRO F  40     -31.394  77.540 105.661  1.00 42.77           C  
ATOM   3595  CG  PRO F  40     -30.765  78.528 106.593  1.00 42.06           C  
ATOM   3596  CD  PRO F  40     -30.746  77.770 107.901  1.00 42.40           C  
HETATM 3597  N   MSE F  41     -29.352  75.154 104.303  1.00 45.17           N  
HETATM 3598  CA  MSE F  41     -28.168  74.897 103.479  1.00 46.43           C  
HETATM 3599  C   MSE F  41     -28.539  74.539 102.044  1.00 45.74           C  
HETATM 3600  O   MSE F  41     -29.700  74.270 101.742  1.00 45.10           O  
HETATM 3601  CB  MSE F  41     -27.342  73.772 104.081  1.00 47.88           C  
HETATM 3602  CG  MSE F  41     -28.060  72.460 104.156  1.00 50.92           C  
HETATM 3603 SE   MSE F  41     -27.020  71.209 105.177  1.00 55.73          SE  
HETATM 3604  CE  MSE F  41     -28.061  71.232 106.787  1.00 55.57           C  
ATOM   3605  N   ASP F  42     -27.533  74.533 101.176  1.00 45.37           N  
ATOM   3606  CA  ASP F  42     -27.717  74.236  99.764  1.00 46.64           C  
ATOM   3607  C   ASP F  42     -27.852  72.751  99.479  1.00 46.52           C  
ATOM   3608  O   ASP F  42     -27.179  71.925 100.102  1.00 46.34           O  
ATOM   3609  CB  ASP F  42     -26.545  74.793  98.952  1.00 48.51           C  
ATOM   3610  CG  ASP F  42     -26.603  76.296  98.812  1.00 51.57           C  
ATOM   3611  OD1 ASP F  42     -26.746  77.002  99.846  1.00 53.77           O  
ATOM   3612  OD2 ASP F  42     -26.493  76.788  97.666  1.00 54.35           O  
ATOM   3613  N   VAL F  43     -28.730  72.413  98.534  1.00 46.02           N  
ATOM   3614  CA  VAL F  43     -28.927  71.019  98.136  1.00 45.39           C  
ATOM   3615  C   VAL F  43     -28.707  70.909  96.638  1.00 44.35           C  
ATOM   3616  O   VAL F  43     -29.131  71.768  95.875  1.00 42.92           O  
ATOM   3617  CB  VAL F  43     -30.349  70.501  98.504  1.00 45.07           C  
ATOM   3618  CG1 VAL F  43     -30.600  70.697  99.993  1.00 45.45           C  
ATOM   3619  CG2 VAL F  43     -31.412  71.237  97.698  1.00 46.94           C  
ATOM   3620  N   ARG F  44     -28.012  69.861  96.226  1.00 44.80           N  
ATOM   3621  CA  ARG F  44     -27.741  69.658  94.810  1.00 46.00           C  
ATOM   3622  C   ARG F  44     -27.704  68.178  94.435  1.00 46.53           C  
ATOM   3623  O   ARG F  44     -27.518  67.310  95.292  1.00 46.62           O  
ATOM   3624  CB  ARG F  44     -26.423  70.338  94.420  1.00 46.15           C  
ATOM   3625  CG  ARG F  44     -25.247  69.984  95.298  1.00 45.67           C  
ATOM   3626  CD  ARG F  44     -24.016  70.792  94.929  1.00 46.15           C  
ATOM   3627  NE  ARG F  44     -24.111  72.195  95.284  1.00 45.98           N  
ATOM   3628  CZ  ARG F  44     -23.097  73.053  95.251  1.00 46.49           C  
ATOM   3629  NH1 ARG F  44     -21.887  72.659  94.871  1.00 46.65           N  
ATOM   3630  NH2 ARG F  44     -23.291  74.314  95.612  1.00 45.79           N  
ATOM   3631  N   LYS F  45     -27.888  67.903  93.143  1.00 47.72           N  
ATOM   3632  CA  LYS F  45     -27.903  66.537  92.639  1.00 48.42           C  
ATOM   3633  C   LYS F  45     -26.508  65.953  92.569  1.00 48.93           C  
ATOM   3634  O   LYS F  45     -26.286  64.812  92.964  1.00 48.54           O  
ATOM   3635  CB  LYS F  45     -28.526  66.499  91.248  1.00 48.37           C  
ATOM   3636  CG  LYS F  45     -29.319  65.244  90.944  1.00 50.59           C  
ATOM   3637  CD  LYS F  45     -30.627  65.244  91.725  1.00 53.78           C  
ATOM   3638  CE  LYS F  45     -31.588  64.168  91.230  1.00 53.41           C  
ATOM   3639  NZ  LYS F  45     -31.870  64.317  89.769  1.00 54.36           N  
ATOM   3640  N   THR F  46     -25.567  66.736  92.056  1.00 50.99           N  
ATOM   3641  CA  THR F  46     -24.193  66.270  91.924  1.00 53.12           C  
ATOM   3642  C   THR F  46     -23.219  67.286  92.498  1.00 54.96           C  
ATOM   3643  O   THR F  46     -23.561  68.455  92.683  1.00 55.29           O  
ATOM   3644  CB  THR F  46     -23.805  66.051  90.444  1.00 53.43           C  
ATOM   3645  OG1 THR F  46     -24.921  65.522  89.720  1.00 52.84           O  
ATOM   3646  CG2 THR F  46     -22.651  65.073  90.353  1.00 54.23           C  
ATOM   3647  N   LYS F  47     -21.998  66.826  92.758  1.00 56.69           N  
ATOM   3648  CA  LYS F  47     -20.943  67.664  93.299  1.00 57.97           C  
ATOM   3649  C   LYS F  47     -20.700  68.858  92.393  1.00 58.63           C  
ATOM   3650  O   LYS F  47     -20.350  69.948  92.844  1.00 59.33           O  
ATOM   3651  CB  LYS F  47     -19.647  66.847  93.448  1.00 58.39           C  
ATOM   3652  CG  LYS F  47     -19.655  65.806  94.581  1.00 59.28           C  
ATOM   3653  CD  LYS F  47     -19.814  66.454  95.977  1.00 60.78           C  
ATOM   3654  CE  LYS F  47     -19.746  65.425  97.111  1.00 62.05           C  
ATOM   3655  NZ  LYS F  47     -19.995  66.007  98.477  1.00 63.61           N  
ATOM   3656  N   PHE F  48     -20.902  68.638  91.103  1.00 58.91           N  
ATOM   3657  CA  PHE F  48     -20.700  69.671  90.083  1.00 58.67           C  
ATOM   3658  C   PHE F  48     -21.748  70.785  90.186  1.00 58.05           C  
ATOM   3659  O   PHE F  48     -22.957  70.531  90.116  1.00 56.10           O  
ATOM   3660  CB  PHE F  48     -20.761  69.013  88.698  1.00 59.04           C  
ATOM   3661  CG  PHE F  48     -19.794  67.854  88.524  1.00 59.38           C  
ATOM   3662  CD1 PHE F  48     -18.441  68.090  88.276  1.00 59.30           C  
ATOM   3663  CD2 PHE F  48     -20.239  66.530  88.596  1.00 58.43           C  
ATOM   3664  CE1 PHE F  48     -17.551  67.031  88.100  1.00 59.01           C  
ATOM   3665  CE2 PHE F  48     -19.354  65.464  88.422  1.00 57.79           C  
ATOM   3666  CZ  PHE F  48     -18.008  65.717  88.173  1.00 58.32           C  
ATOM   3667  N   GLU F  50     -25.230  72.388  89.584  1.00 48.25           N  
ATOM   3668  CA  GLU F  50     -25.725  73.651  90.109  1.00 48.09           C  
ATOM   3669  C   GLU F  50     -26.715  73.482  91.274  1.00 47.29           C  
ATOM   3670  O   GLU F  50     -27.344  72.425  91.436  1.00 46.26           O  
ATOM   3671  CB  GLU F  50     -26.384  74.455  88.985  1.00 49.08           C  
ATOM   3672  CG  GLU F  50     -26.697  75.908  89.358  1.00 50.58           C  
ATOM   3673  CD  GLU F  50     -26.949  76.790  88.140  1.00 52.34           C  
ATOM   3674  OE1 GLU F  50     -28.084  76.794  87.615  1.00 52.23           O  
ATOM   3675  OE2 GLU F  50     -25.995  77.471  87.704  1.00 52.67           O  
ATOM   3676  N   LYS F  51     -26.844  74.537  92.076  1.00 45.73           N  
ATOM   3677  CA  LYS F  51     -27.739  74.548  93.227  1.00 44.49           C  
ATOM   3678  C   LYS F  51     -29.148  74.115  92.834  1.00 42.64           C  
ATOM   3679  O   LYS F  51     -29.751  74.671  91.933  1.00 42.98           O  
ATOM   3680  CB  LYS F  51     -27.769  75.955  93.846  1.00 45.57           C  
ATOM   3681  CG  LYS F  51     -28.602  76.090  95.122  1.00 44.18           C  
ATOM   3682  CD  LYS F  51     -28.531  77.511  95.650  1.00 44.07           C  
ATOM   3683  CE  LYS F  51     -29.281  77.648  96.948  1.00 45.26           C  
ATOM   3684  NZ  LYS F  51     -29.168  79.010  97.522  1.00 45.85           N  
ATOM   3685  N   SER F  52     -29.661  73.113  93.523  1.00 41.84           N  
ATOM   3686  CA  SER F  52     -30.984  72.590  93.255  1.00 40.51           C  
ATOM   3687  C   SER F  52     -32.048  73.164  94.173  1.00 39.81           C  
ATOM   3688  O   SER F  52     -33.244  73.085  93.880  1.00 39.04           O  
ATOM   3689  CB  SER F  52     -30.967  71.077  93.409  1.00 39.95           C  
ATOM   3690  OG  SER F  52     -32.289  70.597  93.591  1.00 41.64           O  
ATOM   3691  N   GLY F  53     -31.612  73.725  95.297  1.00 38.90           N  
ATOM   3692  CA  GLY F  53     -32.547  74.298  96.248  1.00 37.14           C  
ATOM   3693  C   GLY F  53     -31.969  74.460  97.641  1.00 35.66           C  
ATOM   3694  O   GLY F  53     -30.784  74.226  97.868  1.00 34.84           O  
ATOM   3695  N   THR F  54     -32.822  74.862  98.571  1.00 34.17           N  
ATOM   3696  CA  THR F  54     -32.421  75.073  99.942  1.00 34.21           C  
ATOM   3697  C   THR F  54     -33.227  74.148 100.821  1.00 34.50           C  
ATOM   3698  O   THR F  54     -34.397  73.891 100.541  1.00 34.37           O  
ATOM   3699  CB  THR F  54     -32.684  76.512 100.371  1.00 33.96           C  
ATOM   3700  OG1 THR F  54     -31.912  77.398  99.547  1.00 34.25           O  
ATOM   3701  CG2 THR F  54     -32.314  76.712 101.824  1.00 33.08           C  
ATOM   3702  N   ALA F  55     -32.605  73.632 101.880  1.00 33.99           N  
ATOM   3703  CA  ALA F  55     -33.301  72.722 102.782  1.00 32.04           C  
ATOM   3704  C   ALA F  55     -32.763  72.842 104.195  1.00 31.59           C  
ATOM   3705  O   ALA F  55     -31.758  73.499 104.417  1.00 31.06           O  
ATOM   3706  CB  ALA F  55     -33.167  71.298 102.272  1.00 30.90           C  
ATOM   3707  N   GLU F  56     -33.454  72.220 105.142  1.00 31.78           N  
ATOM   3708  CA  GLU F  56     -33.065  72.239 106.547  1.00 32.81           C  
ATOM   3709  C   GLU F  56     -33.257  70.846 107.155  1.00 32.05           C  
ATOM   3710  O   GLU F  56     -34.363  70.302 107.142  1.00 33.07           O  
ATOM   3711  CB  GLU F  56     -33.913  73.256 107.308  1.00 33.03           C  
ATOM   3712  CG  GLU F  56     -33.560  74.703 107.006  1.00 36.52           C  
ATOM   3713  CD  GLU F  56     -34.659  75.681 107.432  1.00 38.76           C  
ATOM   3714  OE1 GLU F  56     -35.114  75.619 108.601  1.00 38.43           O  
ATOM   3715  OE2 GLU F  56     -35.058  76.515 106.590  1.00 39.55           O  
ATOM   3716  N   VAL F  57     -32.184  70.271 107.686  1.00 30.73           N  
ATOM   3717  CA  VAL F  57     -32.258  68.951 108.297  1.00 29.63           C  
ATOM   3718  C   VAL F  57     -33.133  68.960 109.562  1.00 30.54           C  
ATOM   3719  O   VAL F  57     -32.916  69.770 110.466  1.00 29.37           O  
ATOM   3720  CB  VAL F  57     -30.845  68.434 108.640  1.00 28.06           C  
ATOM   3721  CG1 VAL F  57     -30.932  67.050 109.262  1.00 27.46           C  
ATOM   3722  CG2 VAL F  57     -29.997  68.389 107.382  1.00 26.82           C  
ATOM   3723  N   GLN F  58     -34.133  68.074 109.611  1.00 30.83           N  
ATOM   3724  CA  GLN F  58     -35.033  67.993 110.759  1.00 31.65           C  
ATOM   3725  C   GLN F  58     -34.578  66.862 111.674  1.00 31.53           C  
ATOM   3726  O   GLN F  58     -34.782  66.914 112.884  1.00 33.09           O  
ATOM   3727  CB  GLN F  58     -36.474  67.706 110.323  1.00 33.85           C  
ATOM   3728  CG  GLN F  58     -37.020  68.566 109.199  1.00 37.40           C  
ATOM   3729  CD  GLN F  58     -37.123  70.037 109.556  1.00 39.84           C  
ATOM   3730  OE1 GLN F  58     -36.117  70.693 109.831  1.00 41.34           O  
ATOM   3731  NE2 GLN F  58     -38.349  70.563 109.561  1.00 41.25           N  
ATOM   3732  N   LYS F  59     -33.978  65.829 111.100  1.00 30.78           N  
ATOM   3733  CA  LYS F  59     -33.519  64.716 111.905  1.00 30.09           C  
ATOM   3734  C   LYS F  59     -32.291  64.049 111.308  1.00 31.13           C  
ATOM   3735  O   LYS F  59     -32.145  63.974 110.084  1.00 31.20           O  
ATOM   3736  CB  LYS F  59     -34.626  63.686 112.067  1.00 30.22           C  
ATOM   3737  CG  LYS F  59     -34.201  62.498 112.879  1.00 33.59           C  
ATOM   3738  CD  LYS F  59     -35.362  61.719 113.449  1.00 34.63           C  
ATOM   3739  CE  LYS F  59     -36.095  60.966 112.384  1.00 37.51           C  
ATOM   3740  NZ  LYS F  59     -37.090  60.031 112.976  1.00 37.89           N  
ATOM   3741  N   LEU F  60     -31.400  63.568 112.175  1.00 30.63           N  
ATOM   3742  CA  LEU F  60     -30.176  62.901 111.715  1.00 28.03           C  
ATOM   3743  C   LEU F  60     -29.909  61.684 112.581  1.00 27.82           C  
ATOM   3744  O   LEU F  60     -30.008  61.754 113.799  1.00 29.72           O  
ATOM   3745  CB  LEU F  60     -28.990  63.879 111.782  1.00 27.88           C  
ATOM   3746  CG  LEU F  60     -27.575  63.352 111.504  1.00 26.02           C  
ATOM   3747  CD1 LEU F  60     -26.725  64.464 110.917  1.00 25.17           C  
ATOM   3748  CD2 LEU F  60     -26.966  62.819 112.779  1.00 25.56           C  
ATOM   3749  N   GLN F  61     -29.606  60.555 111.961  1.00 27.32           N  
ATOM   3750  CA  GLN F  61     -29.317  59.362 112.738  1.00 27.47           C  
ATOM   3751  C   GLN F  61     -28.139  58.577 112.213  1.00 27.43           C  
ATOM   3752  O   GLN F  61     -27.839  58.601 111.019  1.00 26.71           O  
ATOM   3753  CB  GLN F  61     -30.533  58.458 112.839  1.00 27.46           C  
ATOM   3754  CG  GLN F  61     -31.199  58.212 111.550  1.00 29.90           C  
ATOM   3755  CD  GLN F  61     -32.454  57.383 111.694  1.00 31.34           C  
ATOM   3756  OE1 GLN F  61     -32.386  56.179 111.966  1.00 30.07           O  
ATOM   3757  NE2 GLN F  61     -33.619  58.029 111.523  1.00 32.62           N  
ATOM   3758  N   TRP F  62     -27.447  57.916 113.139  1.00 27.95           N  
ATOM   3759  CA  TRP F  62     -26.279  57.100 112.817  1.00 27.84           C  
ATOM   3760  C   TRP F  62     -26.600  55.657 113.149  1.00 28.83           C  
ATOM   3761  O   TRP F  62     -27.208  55.369 114.174  1.00 28.90           O  
ATOM   3762  CB  TRP F  62     -25.064  57.535 113.627  1.00 24.32           C  
ATOM   3763  CG  TRP F  62     -24.498  58.858 113.234  1.00 22.81           C  
ATOM   3764  CD1 TRP F  62     -24.734  59.545 112.085  1.00 23.48           C  
ATOM   3765  CD2 TRP F  62     -23.522  59.628 113.963  1.00 23.22           C  
ATOM   3766  NE1 TRP F  62     -23.965  60.698 112.049  1.00 23.05           N  
ATOM   3767  CE2 TRP F  62     -23.229  60.773 113.201  1.00 23.08           C  
ATOM   3768  CE3 TRP F  62     -22.884  59.463 115.205  1.00 22.68           C  
ATOM   3769  CZ2 TRP F  62     -22.314  61.736 113.621  1.00 23.08           C  
ATOM   3770  CZ3 TRP F  62     -21.971  60.422 115.621  1.00 21.13           C  
ATOM   3771  CH2 TRP F  62     -21.705  61.549 114.839  1.00 22.94           C  
ATOM   3772  N   GLU F  63     -26.204  54.748 112.271  1.00 31.02           N  
ATOM   3773  CA  GLU F  63     -26.441  53.333 112.490  1.00 32.60           C  
ATOM   3774  C   GLU F  63     -25.647  52.487 111.503  1.00 33.31           C  
ATOM   3775  O   GLU F  63     -25.689  52.732 110.299  1.00 34.45           O  
ATOM   3776  CB  GLU F  63     -27.930  53.030 112.374  1.00 32.56           C  
ATOM   3777  CG  GLU F  63     -28.253  51.554 112.404  1.00 34.30           C  
ATOM   3778  CD  GLU F  63     -29.556  51.273 113.106  1.00 35.55           C  
ATOM   3779  OE1 GLU F  63     -30.537  52.018 112.853  1.00 35.18           O  
ATOM   3780  OE2 GLU F  63     -29.587  50.297 113.897  1.00 36.99           O  
ATOM   3781  N   GLU F  64     -24.914  51.509 112.016  1.00 34.31           N  
ATOM   3782  CA  GLU F  64     -24.123  50.629 111.173  1.00 35.41           C  
ATOM   3783  C   GLU F  64     -23.318  51.383 110.122  1.00 35.31           C  
ATOM   3784  O   GLU F  64     -23.613  51.315 108.929  1.00 35.17           O  
ATOM   3785  CB  GLU F  64     -25.036  49.606 110.499  1.00 37.56           C  
ATOM   3786  CG  GLU F  64     -25.593  48.561 111.471  1.00 41.36           C  
ATOM   3787  CD  GLU F  64     -26.779  47.796 110.902  1.00 44.53           C  
ATOM   3788  OE1 GLU F  64     -26.629  47.165 109.829  1.00 44.91           O  
ATOM   3789  OE2 GLU F  64     -27.860  47.825 111.539  1.00 47.33           O  
ATOM   3790  N   GLY F  65     -22.310  52.127 110.579  1.00 34.60           N  
ATOM   3791  CA  GLY F  65     -21.447  52.876 109.678  1.00 32.08           C  
ATOM   3792  C   GLY F  65     -22.121  53.795 108.684  1.00 31.74           C  
ATOM   3793  O   GLY F  65     -21.439  54.428 107.881  1.00 31.91           O  
ATOM   3794  N   ARG F  66     -23.445  53.887 108.716  1.00 31.55           N  
ATOM   3795  CA  ARG F  66     -24.125  54.776 107.773  1.00 32.64           C  
ATOM   3796  C   ARG F  66     -24.915  55.868 108.503  1.00 31.02           C  
ATOM   3797  O   ARG F  66     -25.189  55.753 109.700  1.00 29.80           O  
ATOM   3798  CB  ARG F  66     -25.055  53.965 106.860  1.00 33.83           C  
ATOM   3799  CG  ARG F  66     -24.330  52.873 106.072  1.00 38.51           C  
ATOM   3800  CD  ARG F  66     -25.236  52.130 105.068  1.00 39.64           C  
ATOM   3801  NE  ARG F  66     -25.571  52.945 103.907  1.00 42.39           N  
ATOM   3802  CZ  ARG F  66     -24.690  53.385 103.006  1.00 44.46           C  
ATOM   3803  NH1 ARG F  66     -23.402  53.087 103.122  1.00 44.36           N  
ATOM   3804  NH2 ARG F  66     -25.097  54.139 101.984  1.00 45.02           N  
ATOM   3805  N   THR F  67     -25.242  56.927 107.770  1.00 29.63           N  
ATOM   3806  CA  THR F  67     -26.011  58.036 108.292  1.00 29.35           C  
ATOM   3807  C   THR F  67     -27.161  58.341 107.346  1.00 28.65           C  
ATOM   3808  O   THR F  67     -26.982  58.374 106.128  1.00 27.53           O  
ATOM   3809  CB  THR F  67     -25.184  59.327 108.414  1.00 29.01           C  
ATOM   3810  OG1 THR F  67     -26.073  60.442 108.605  1.00 28.60           O  
ATOM   3811  CG2 THR F  67     -24.381  59.565 107.152  1.00 28.64           C  
ATOM   3812  N   ILE F  68     -28.344  58.558 107.911  1.00 28.60           N  
ATOM   3813  CA  ILE F  68     -29.530  58.866 107.130  1.00 27.43           C  
ATOM   3814  C   ILE F  68     -30.137  60.138 107.692  1.00 25.66           C  
ATOM   3815  O   ILE F  68     -30.406  60.205 108.875  1.00 25.48           O  
ATOM   3816  CB  ILE F  68     -30.544  57.699 107.210  1.00 29.13           C  
ATOM   3817  CG1 ILE F  68     -31.944  58.188 106.836  1.00 30.60           C  
ATOM   3818  CG2 ILE F  68     -30.579  57.126 108.594  1.00 28.87           C  
ATOM   3819  CD1 ILE F  68     -32.972  57.067 106.830  1.00 32.88           C  
ATOM   3820  N   ILE F  69     -30.333  61.148 106.849  1.00 24.89           N  
ATOM   3821  CA  ILE F  69     -30.905  62.411 107.303  1.00 25.21           C  
ATOM   3822  C   ILE F  69     -32.281  62.631 106.705  1.00 26.05           C  
ATOM   3823  O   ILE F  69     -32.589  62.131 105.626  1.00 26.24           O  
ATOM   3824  CB  ILE F  69     -30.068  63.625 106.898  1.00 24.53           C  
ATOM   3825  CG1 ILE F  69     -29.940  63.671 105.388  1.00 25.25           C  
ATOM   3826  CG2 ILE F  69     -28.711  63.580 107.576  1.00 25.06           C  
ATOM   3827  CD1 ILE F  69     -29.301  64.948 104.861  1.00 24.54           C  
ATOM   3828  N   THR F  70     -33.100  63.392 107.421  1.00 25.96           N  
ATOM   3829  CA  THR F  70     -34.438  63.724 106.996  1.00 25.92           C  
ATOM   3830  C   THR F  70     -34.448  65.239 106.920  1.00 26.82           C  
ATOM   3831  O   THR F  70     -34.299  65.917 107.938  1.00 26.49           O  
ATOM   3832  CB  THR F  70     -35.480  63.268 108.036  1.00 26.31           C  
ATOM   3833  OG1 THR F  70     -35.318  61.869 108.299  1.00 28.12           O  
ATOM   3834  CG2 THR F  70     -36.885  63.518 107.532  1.00 26.45           C  
ATOM   3835  N   TYR F  71     -34.595  65.782 105.718  1.00 27.38           N  
ATOM   3836  CA  TYR F  71     -34.618  67.227 105.587  1.00 28.09           C  
ATOM   3837  C   TYR F  71     -35.897  67.758 104.950  1.00 28.99           C  
ATOM   3838  O   TYR F  71     -36.608  67.048 104.259  1.00 27.93           O  
ATOM   3839  CB  TYR F  71     -33.391  67.710 104.808  1.00 29.04           C  
ATOM   3840  CG  TYR F  71     -33.294  67.192 103.397  1.00 31.24           C  
ATOM   3841  CD1 TYR F  71     -33.828  67.914 102.330  1.00 31.63           C  
ATOM   3842  CD2 TYR F  71     -32.665  65.978 103.120  1.00 31.54           C  
ATOM   3843  CE1 TYR F  71     -33.734  67.430 101.024  1.00 32.12           C  
ATOM   3844  CE2 TYR F  71     -32.573  65.496 101.808  1.00 32.15           C  
ATOM   3845  CZ  TYR F  71     -33.110  66.231 100.776  1.00 31.82           C  
ATOM   3846  OH  TYR F  71     -33.036  65.774  99.492  1.00 30.96           O  
ATOM   3847  N   LYS F  72     -36.168  69.025 105.221  1.00 30.90           N  
ATOM   3848  CA  LYS F  72     -37.327  69.728 104.716  1.00 32.14           C  
ATOM   3849  C   LYS F  72     -36.866  70.683 103.633  1.00 32.64           C  
ATOM   3850  O   LYS F  72     -36.132  71.626 103.918  1.00 32.34           O  
ATOM   3851  CB  LYS F  72     -37.982  70.529 105.847  1.00 33.66           C  
ATOM   3852  CG  LYS F  72     -39.099  71.467 105.407  1.00 34.37           C  
ATOM   3853  CD  LYS F  72     -39.536  72.346 106.560  1.00 37.56           C  
ATOM   3854  CE  LYS F  72     -40.637  73.319 106.153  1.00 38.76           C  
ATOM   3855  NZ  LYS F  72     -41.945  72.634 105.902  1.00 39.79           N  
ATOM   3856  N   LEU F  73     -37.290  70.442 102.393  1.00 32.86           N  
ATOM   3857  CA  LEU F  73     -36.911  71.317 101.286  1.00 34.21           C  
ATOM   3858  C   LEU F  73     -37.704  72.623 101.422  1.00 35.23           C  
ATOM   3859  O   LEU F  73     -38.930  72.610 101.372  1.00 37.85           O  
ATOM   3860  CB  LEU F  73     -37.230  70.632  99.955  1.00 32.46           C  
ATOM   3861  CG  LEU F  73     -36.511  71.115  98.689  1.00 31.36           C  
ATOM   3862  CD1 LEU F  73     -35.011  70.976  98.874  1.00 31.55           C  
ATOM   3863  CD2 LEU F  73     -36.963  70.292  97.493  1.00 30.64           C  
ATOM   3864  N   THR F  74     -37.016  73.746 101.598  1.00 35.25           N  
ATOM   3865  CA  THR F  74     -37.705  75.020 101.763  1.00 36.64           C  
ATOM   3866  C   THR F  74     -37.797  75.850 100.480  1.00 38.26           C  
ATOM   3867  O   THR F  74     -38.480  76.873 100.450  1.00 39.50           O  
ATOM   3868  CB  THR F  74     -37.037  75.898 102.869  1.00 35.47           C  
ATOM   3869  OG1 THR F  74     -35.718  76.294 102.465  1.00 36.78           O  
ATOM   3870  CG2 THR F  74     -36.932  75.133 104.168  1.00 33.98           C  
ATOM   3871  N   SER F  75     -37.112  75.430  99.420  1.00 39.52           N  
ATOM   3872  CA  SER F  75     -37.164  76.171  98.160  1.00 40.32           C  
ATOM   3873  C   SER F  75     -36.395  75.496  97.034  1.00 41.48           C  
ATOM   3874  O   SER F  75     -35.477  74.714  97.287  1.00 42.21           O  
ATOM   3875  CB  SER F  75     -36.633  77.594  98.360  1.00 38.74           C  
ATOM   3876  OG  SER F  75     -35.371  77.585  98.975  1.00 39.12           O  
ATOM   3877  N   LEU F  76     -36.781  75.793  95.794  1.00 42.78           N  
ATOM   3878  CA  LEU F  76     -36.113  75.239  94.613  1.00 44.54           C  
ATOM   3879  C   LEU F  76     -35.348  76.365  93.930  1.00 45.98           C  
ATOM   3880  O   LEU F  76     -35.776  77.513  93.971  1.00 47.21           O  
ATOM   3881  CB  LEU F  76     -37.138  74.626  93.651  1.00 44.39           C  
ATOM   3882  CG  LEU F  76     -37.586  73.193  93.940  1.00 43.99           C  
ATOM   3883  CD1 LEU F  76     -38.065  73.088  95.378  1.00 45.38           C  
ATOM   3884  CD2 LEU F  76     -38.684  72.791  92.986  1.00 44.33           C  
ATOM   3885  N   HIS F  77     -34.223  76.042  93.298  1.00 47.63           N  
ATOM   3886  CA  HIS F  77     -33.407  77.070  92.648  1.00 50.00           C  
ATOM   3887  C   HIS F  77     -33.786  77.296  91.193  1.00 51.42           C  
ATOM   3888  O   HIS F  77     -34.774  77.973  90.903  1.00 52.11           O  
ATOM   3889  CB  HIS F  77     -31.914  76.708  92.747  1.00 50.18           C  
ATOM   3890  CG  HIS F  77     -30.988  77.856  92.466  1.00 49.63           C  
ATOM   3891  ND1 HIS F  77     -30.953  78.980  93.246  1.00 50.39           N  
ATOM   3892  CD2 HIS F  77     -30.052  78.022  91.503  1.00 50.24           C  
ATOM   3893  CE1 HIS F  77     -30.023  79.808  92.779  1.00 49.82           C  
ATOM   3894  NE2 HIS F  77     -29.469  79.248  91.729  1.00 49.95           N  
ATOM   3895  N   SER F  78     -32.997  76.741  90.277  1.00 52.12           N  
ATOM   3896  CA  SER F  78     -33.263  76.905  88.849  1.00 52.72           C  
ATOM   3897  C   SER F  78     -34.287  75.889  88.332  1.00 53.19           C  
ATOM   3898  O   SER F  78     -33.965  75.022  87.521  1.00 52.61           O  
ATOM   3899  CB  SER F  78     -31.957  76.773  88.056  1.00 53.03           C  
ATOM   3900  OG  SER F  78     -31.031  77.767  88.430  1.00 52.69           O  
ATOM   3901  N   VAL F  79     -35.520  76.002  88.800  1.00 54.09           N  
ATOM   3902  CA  VAL F  79     -36.555  75.084  88.363  1.00 55.91           C  
ATOM   3903  C   VAL F  79     -36.983  75.431  86.942  1.00 57.24           C  
ATOM   3904  O   VAL F  79     -37.787  76.341  86.720  1.00 57.48           O  
ATOM   3905  CB  VAL F  79     -37.779  75.128  89.296  1.00 55.58           C  
ATOM   3906  CG1 VAL F  79     -38.187  76.568  89.548  1.00 56.28           C  
ATOM   3907  CG2 VAL F  79     -38.936  74.358  88.674  1.00 54.76           C  
ATOM   3908  N   ASN F  80     -36.438  74.698  85.978  1.00 58.43           N  
ATOM   3909  CA  ASN F  80     -36.740  74.925  84.570  1.00 59.25           C  
ATOM   3910  C   ASN F  80     -38.198  74.680  84.201  1.00 59.47           C  
ATOM   3911  O   ASN F  80     -38.947  74.060  84.949  1.00 59.25           O  
ATOM   3912  CB  ASN F  80     -35.871  74.031  83.696  1.00 59.66           C  
ATOM   3913  CG  ASN F  80     -36.111  74.273  82.229  1.00 60.47           C  
ATOM   3914  OD1 ASN F  80     -35.756  75.333  81.696  1.00 61.06           O  
ATOM   3915  ND2 ASN F  80     -36.741  73.306  81.565  1.00 62.29           N  
ATOM   3916  N   LEU F  81     -38.584  75.157  83.026  1.00 60.06           N  
ATOM   3917  CA  LEU F  81     -39.943  74.987  82.548  1.00 61.31           C  
ATOM   3918  C   LEU F  81     -39.955  74.334  81.167  1.00 62.09           C  
ATOM   3919  O   LEU F  81     -40.861  73.498  80.913  1.00 63.13           O  
ATOM   3920  CB  LEU F  81     -40.681  76.339  82.520  1.00 61.58           C  
ATOM   3921  CG  LEU F  81     -41.332  76.843  83.822  1.00 61.95           C  
ATOM   3922  CD1 LEU F  81     -42.363  75.826  84.294  1.00 61.91           C  
ATOM   3923  CD2 LEU F  81     -40.295  77.067  84.912  1.00 62.66           C  
TER    3924      LEU F  81                                                      
END
MOLECULE T0424_6_93_186_208_278_338.pdb
ATOM      1  N   TYR     6      -8.706  54.439 110.650  1.00 55.48          
ATOM      2  CA  TYR     6      -9.099  54.469 109.185  1.00 54.88          
ATOM      3  C   TYR     6     -10.610  54.644 108.884  1.00 54.73          
ATOM      4  O   TYR     6     -10.973  54.947 107.710  1.00 55.76          
ATOM      5  CB  TYR     6      -8.552  53.237 108.438  1.00 56.05          
ATOM      6  CG  TYR     6      -7.046  53.270 108.318  1.00 57.14          
ATOM      7  CD1 TYR     6      -6.408  54.146 107.429  1.00 58.26          
ATOM      8  CD2 TYR     6      -6.251  52.451 109.112  1.00 57.96          
ATOM      9  CE1 TYR     6      -5.010  54.182 107.338  1.00 57.86          
ATOM     10  CE2 TYR     6      -4.858  52.498 109.038  1.00 57.90          
ATOM     11  CZ  TYR     6      -4.249  53.345 108.151  1.00 57.39          
ATOM     12  OH  TYR     6      -2.873  53.358 108.099  1.00 58.55          
ATOM     13  N   GLY     7     -11.463  54.386 109.896  1.00 52.62          
ATOM     14  CA  GLY     7     -12.902  54.744 109.895  1.00 50.38          
ATOM     15  C   GLY     7     -13.150  55.602 111.141  1.00 48.60          
ATOM     16  O   GLY     7     -12.203  56.112 111.728  1.00 50.20          
ATOM     17  N   TYR     8     -14.395  55.716 111.593  1.00 45.70          
ATOM     18  CA  TYR     8     -14.715  56.508 112.795  1.00 42.86          
ATOM     19  C   TYR     8     -14.490  55.756 114.115  1.00 40.78          
ATOM     20  O   TYR     8     -14.914  54.619 114.260  1.00 39.86          
ATOM     21  CB  TYR     8     -16.179  56.964 112.761  1.00 41.95          
ATOM     22  CG  TYR     8     -16.535  57.803 111.567  1.00 41.51          
ATOM     23  CD1 TYR     8     -16.218  59.161 111.525  1.00 41.32          
ATOM     24  CD2 TYR     8     -17.157  57.246 110.473  1.00 41.64          
ATOM     25  CE1 TYR     8     -16.508  59.917 110.427  1.00 40.85          
ATOM     26  CE2 TYR     8     -17.434  57.994 109.361  1.00 42.07          
ATOM     27  CZ  TYR     8     -17.137  59.344 109.358  1.00 39.72          
ATOM     28  OH  TYR     8     -17.440  60.104 108.270  1.00 39.32          
ATOM     29  N   ALA     9     -13.887  56.429 115.095  1.00 38.46          
ATOM     30  CA  ALA     9     -13.874  55.957 116.464  1.00 37.59          
ATOM     31  C   ALA     9     -15.143  56.493 117.146  1.00 35.95          
ATOM     32  O   ALA     9     -15.298  57.688 117.348  1.00 35.75          
ATOM     33  CB  ALA     9     -12.580  56.434 117.226  1.00 37.57          
ATOM     34  N   VAL    10     -16.067  55.586 117.434  1.00 34.50          
ATOM     35  CA  VAL    10     -17.328  55.922 118.062  1.00 33.87          
ATOM     36  C   VAL    10     -17.322  55.232 119.421  1.00 34.21          
ATOM     37  O   VAL    10     -17.174  53.973 119.503  1.00 34.14          
ATOM     38  CB  VAL    10     -18.526  55.466 117.206  1.00 32.89          
ATOM     39  CG1 VAL    10     -19.853  55.872 117.905  1.00 28.71          
ATOM     40  CG2 VAL    10     -18.465  56.060 115.827  1.00 28.37          
ATOM     41  N   SER    11     -17.494  56.014 120.487  1.00 34.36          
ATOM     42  CA  SER    11     -17.583  55.418 121.818  1.00 35.11          
ATOM     43  C   SER    11     -18.739  55.927 122.677  1.00 34.90          
ATOM     44  O   SER    11     -19.282  57.010 122.457  1.00 35.31          
ATOM     45  CB  SER    11     -16.296  55.621 122.604  1.00 35.08          
ATOM     46  OG  SER    11     -16.102  56.984 122.777  1.00 38.92          
ATOM     47  N   VAL    12     -19.081  55.121 123.681  1.00 34.70          
ATOM     48  CA  VAL    12     -19.976  55.504 124.754  1.00 34.48          
ATOM     49  C   VAL    12     -19.043  55.667 125.917  1.00 34.69          
ATOM     50  O   VAL    12     -18.476  54.693 126.377  1.00 34.17          
ATOM     51  CB  VAL    12     -21.053  54.425 125.008  1.00 34.67          
ATOM     52  CG1 VAL    12     -21.944  54.776 126.223  1.00 32.94          
ATOM     53  CG2 VAL    12     -21.883  54.232 123.766  1.00 34.93          
ATOM     54  N   ARG    13     -18.827  56.911 126.338  1.00 34.75          
ATOM     55  CA  ARG    13     -17.941  57.207 127.431  1.00 36.44          
ATOM     56  C   ARG    13     -18.735  57.186 128.739  1.00 37.29          
ATOM     57  O   ARG    13     -19.695  57.929 128.884  1.00 35.23          
ATOM     58  CB  ARG    13     -17.337  58.601 127.216  1.00 35.54          
ATOM     59  CG  ARG    13     -16.094  58.839 127.959  1.00 37.35          
ATOM     60  CD  ARG    13     -15.609  60.272 127.725  1.00 37.69          
ATOM     61  NE  ARG    13     -14.899  60.375 126.447  1.00 37.94          
ATOM     62  CZ  ARG    13     -14.655  61.520 125.812  1.00 37.94          
ATOM     63  NH1 ARG    13     -15.145  62.644 126.239  1.00 39.48          
ATOM     64  NH2 ARG    13     -13.933  61.528 124.707  1.00 42.49          
ATOM     65  N   VAL    14     -18.364  56.298 129.661  1.00 39.06          
ATOM     66  CA  VAL    14     -19.008  56.201 130.967  1.00 41.33          
ATOM     67  C   VAL    14     -17.912  56.071 132.024  1.00 43.53          
ATOM     68  O   VAL    14     -17.089  55.114 131.954  1.00 44.53          
ATOM     69  CB  VAL    14     -19.871  54.912 131.106  1.00 41.93          
ATOM     70  CG1 VAL    14     -20.374  54.788 132.558  1.00 42.53          
ATOM     71  CG2 VAL    14     -20.999  54.857 130.106  1.00 40.13          
ATOM     72  N   GLY    15     -17.897  56.980 132.997  1.00 45.42          
ATOM     73  CA  GLY    15     -16.885  56.939 134.055  1.00 47.15          
ATOM     74  C   GLY    15     -15.499  56.907 133.434  1.00 48.87          
ATOM     75  O   GLY    15     -14.743  55.938 133.609  1.00 49.11          
ATOM     76  N   GLY    16     -15.219  57.952 132.638  1.00 50.40          
ATOM     77  CA  GLY    16     -13.922  58.162 131.979  1.00 50.14          
ATOM     78  C   GLY    16     -13.533  57.070 131.009  1.00 50.82          
ATOM     79  O   GLY    16     -12.560  57.208 130.261  1.00 52.89          
ATOM     80  N   LYS    17     -14.305  55.996 131.002  1.00 50.20          
ATOM     81  CA  LYS    17     -13.974  54.787 130.309  1.00 49.62          
ATOM     82  C   LYS    17     -14.687  54.799 128.962  1.00 48.41          
ATOM     83  O   LYS    17     -15.862  55.122 128.891  1.00 46.98          
ATOM     84  CB  LYS    17     -14.439  53.606 131.174  1.00 50.22          
ATOM     85  CG  LYS    17     -13.985  52.228 130.741  1.00 51.09          
ATOM     86  CD  LYS    17     -14.278  51.215 131.849  1.00 53.10          
ATOM     87  CE  LYS    17     -13.305  51.338 133.071  1.00 56.25          
ATOM     88  NZ  LYS    17     -12.288  50.215 133.161  1.00 57.19          
ATOM     89  N   GLU    18     -13.950  54.470 127.908  1.00 47.48          
ATOM     90  CA  GLU    18     -14.453  54.464 126.546  1.00 47.17          
ATOM     91  C   GLU    18     -14.893  53.071 126.219  1.00 46.59          
ATOM     92  O   GLU    18     -14.116  52.135 126.375  1.00 46.67          
ATOM     93  CB  GLU    18     -13.350  54.818 125.539  1.00 47.20          
ATOM     94  CG  GLU    18     -12.624  56.097 125.829  1.00 47.70          
ATOM     95  CD  GLU    18     -13.484  57.330 125.660  1.00 48.97          
ATOM     96  OE1 GLU    18     -14.539  57.270 124.985  1.00 46.32          
ATOM     97  OE2 GLU    18     -13.090  58.374 126.218  1.00 52.33          
ATOM     98  N   HSD    19     -16.120  52.922 125.758  1.00 45.77          
ATOM     99  CA  HSD    19     -16.574  51.667 125.182  1.00 45.52          
ATOM    100  C   HSD    19     -16.753  51.854 123.691  1.00 46.49          
ATOM    101  O   HSD    19     -17.568  52.673 123.219  1.00 45.34          
ATOM    102  CB  HSD    19     -17.861  51.211 125.852  1.00 44.75          
ATOM    103  CG  HSD    19     -17.701  51.008 127.322  1.00 44.48          
ATOM    104  ND1 HSD    19     -17.739  52.052 128.220  1.00 44.36          
ATOM    105  CD2 HSD    19     -17.417  49.899 128.046  1.00 44.04          
ATOM    106  CE1 HSD    19     -17.537  51.589 129.440  1.00 43.66          
ATOM    107  NE2 HSD    19     -17.332  50.287 129.359  1.00 42.78          
ATOM    108  N   ARG    20     -16.014  51.027 122.968  1.00 47.16          
ATOM    109  CA  ARG    20     -15.710  51.196 121.574  1.00 48.34          
ATOM    110  C   ARG    20     -16.084  49.881 120.858  1.00 47.64          
ATOM    111  O   ARG    20     -16.609  48.966 121.468  1.00 47.88          
ATOM    112  CB  ARG    20     -14.204  51.438 121.499  1.00 49.71          
ATOM    113  CG  ARG    20     -13.759  52.286 120.365  1.00 55.41          
ATOM    114  CD  ARG    20     -13.346  53.683 120.818  1.00 60.08          
ATOM    115  NE  ARG    20     -12.227  53.659 121.770  1.00 62.25          
ATOM    116  CZ  ARG    20     -11.632  54.757 122.253  1.00 61.21          
ATOM    117  NH1 ARG    20     -10.641  54.627 123.137  1.00 62.00          
ATOM    118  NH2 ARG    20     -12.028  55.979 121.868  1.00 60.56          
ATOM    119  N   HSD    21     -15.855  49.793 119.569  1.00 47.03          
ATOM    120  CA  HSD    21     -15.919  48.486 118.902  1.00 47.29          
ATOM    121  C   HSD    21     -17.347  47.903 118.716  1.00 46.08          
ATOM    122  O   HSD    21     -17.548  46.713 118.777  1.00 47.79          
ATOM    123  CB  HSD    21     -14.997  47.435 119.602  1.00 48.81          
ATOM    124  CG  HSD    21     -13.556  47.861 119.716  1.00 52.63          
ATOM    125  ND1 HSD    21     -12.839  47.770 120.897  1.00 56.04          
ATOM    126  CD2 HSD    21     -12.709  48.400 118.800  1.00 54.62          
ATOM    127  CE1 HSD    21     -11.609  48.220 120.697  1.00 55.52          
ATOM    128  NE2 HSD    21     -11.508  48.617 119.437  1.00 55.41          
ATOM    129  N   TRP    22     -18.295  48.740 118.379  1.00 43.25          
ATOM    130  CA  TRP    22     -19.671  48.333 118.161  1.00 41.81          
ATOM    131  C   TRP    22     -19.852  47.623 116.855  1.00 40.13          
ATOM    132  O   TRP    22     -19.193  47.943 115.884  1.00 38.60          
ATOM    133  CB  TRP    22     -20.543  49.574 118.180  1.00 39.77          
ATOM    134  CG  TRP    22     -20.243  50.337 119.377  1.00 38.93          
ATOM    135  CD1 TRP    22     -19.458  51.460 119.469  1.00 39.64          
ATOM    136  CD2 TRP    22     -20.630  50.003 120.698  1.00 36.22          
ATOM    137  NE1 TRP    22     -19.387  51.856 120.774  1.00 39.31          
ATOM    138  CE2 TRP    22     -20.094  50.972 121.546  1.00 37.61          
ATOM    139  CE3 TRP    22     -21.408  48.987 121.241  1.00 38.71          
ATOM    140  CZ2 TRP    22     -20.316  50.968 122.905  1.00 38.11          
ATOM    141  CZ3 TRP    22     -21.620  48.973 122.604  1.00 40.34          
ATOM    142  CH2 TRP    22     -21.059  49.948 123.419  1.00 39.17          
ATOM    143  N   GLU    23     -20.756  46.656 116.809  1.00 38.33          
ATOM    144  CA  GLU    23     -21.162  46.146 115.532  1.00 37.50          
ATOM    145  C   GLU    23     -22.280  46.918 114.876  1.00 35.74          
ATOM    146  O   GLU    23     -22.360  46.936 113.670  1.00 32.93          
ATOM    147  CB  GLU    23     -21.494  44.671 115.619  1.00 39.44          
ATOM    148  CG  GLU    23     -22.842  44.278 116.172  1.00 41.96          
ATOM    149  CD  GLU    23     -23.361  43.019 115.494  1.00 44.58          
ATOM    150  OE1 GLU    23     -22.543  42.037 115.373  1.00 53.28          
ATOM    151  OE2 GLU    23     -24.560  43.023 115.059  1.00 50.03          
ATOM    152  N   ARG    24     -23.174  47.541 115.676  1.00 33.96          
ATOM    153  CA  ARG    24     -24.224  48.354 115.112  1.00 34.08          
ATOM    154  C   ARG    24     -24.621  49.490 116.090  1.00 30.10          
ATOM    155  O   ARG    24     -24.369  49.404 117.264  1.00 29.54          
ATOM    156  CB  ARG    24     -25.409  47.473 114.636  1.00 35.42          
ATOM    157  CG  ARG    24     -26.380  47.086 115.677  1.00 40.19          
ATOM    158  CD  ARG    24     -27.530  46.211 115.107  1.00 41.68          
ATOM    159  NE  ARG    24     -26.968  44.884 115.052  1.00 49.81          
ATOM    160  CZ  ARG    24     -27.314  43.852 115.813  1.00 48.51          
ATOM    161  NH1 ARG    24     -28.331  43.902 116.677  1.00 48.82          
ATOM    162  NH2 ARG    24     -26.614  42.762 115.692  1.00 47.52          
ATOM    163  N   TYR    25     -25.068  50.610 115.553  1.00 27.46          
ATOM    164  CA  TYR    25     -25.624  51.658 116.394  1.00 26.73          
ATOM    165  C   TYR    25     -26.568  52.514 115.591  1.00 25.23          
ATOM    166  O   TYR    25     -26.585  52.486 114.348  1.00 25.51          
ATOM    167  CB  TYR    25     -24.511  52.513 117.077  1.00 25.20          
ATOM    168  CG  TYR    25     -23.488  53.133 116.105  1.00 24.60          
ATOM    169  CD1 TYR    25     -23.837  54.179 115.260  1.00 25.41          
ATOM    170  CD2 TYR    25     -22.154  52.705 116.084  1.00 27.24          
ATOM    171  CE1 TYR    25     -22.906  54.782 114.412  1.00 23.78          
ATOM    172  CE2 TYR    25     -21.210  53.268 115.162  1.00 26.60          
ATOM    173  CZ  TYR    25     -21.600  54.300 114.359  1.00 25.65          
ATOM    174  OH  TYR    25     -20.710  54.895 113.515  1.00 24.26          
ATOM    175  N   ASP    26     -27.360  53.277 116.337  1.00 24.61          
ATOM    176  CA  ASP    26     -28.285  54.254 115.824  1.00 25.29          
ATOM    177  C   ASP    26     -28.249  55.387 116.812  1.00 25.00          
ATOM    178  O   ASP    26     -28.538  55.189 117.988  1.00 24.73          
ATOM    179  CB  ASP    26     -29.689  53.678 115.797  1.00 27.31          
ATOM    180  CG  ASP    26     -29.882  52.662 114.678  1.00 33.25          
ATOM    181  OD1 ASP    26     -29.868  53.024 113.461  1.00 42.40          
ATOM    182  OD2 ASP    26     -29.945  51.466 115.026  1.00 44.44          
ATOM    183  N   ILE    27     -27.935  56.597 116.339  1.00 26.07          
ATOM    184  CA  ILE    27     -27.857  57.789 117.175  1.00 25.03          
ATOM    185  C   ILE    27     -28.742  58.825 116.487  1.00 25.31          
ATOM    186  O   ILE    27     -28.410  59.288 115.392  1.00 24.24          
ATOM    187  CB  ILE    27     -26.405  58.277 117.294  1.00 26.14          
ATOM    188  CG1 ILE    27     -25.489  57.179 117.836  1.00 25.54          
ATOM    189  CG2 ILE    27     -26.275  59.580 118.182  1.00 24.99          
ATOM    190  CD  ILE    27     -23.974  57.428 117.466  1.00 27.47          
ATOM    191  N   ASP    28     -29.881  59.137 117.124  1.00 25.11          
ATOM    192  CA  ASP    28     -30.917  59.895 116.519  1.00 26.04          
ATOM    193  C   ASP    28     -31.190  61.197 117.236  1.00 25.57          
ATOM    194  O   ASP    28     -31.423  61.217 118.445  1.00 26.64          
ATOM    195  CB  ASP    28     -32.191  59.084 116.315  1.00 26.75          
ATOM    196  CG  ASP    28     -33.106  59.731 115.261  1.00 26.90          
ATOM    197  OD1 ASP    28     -33.636  60.832 115.492  1.00 30.60          
ATOM    198  OD2 ASP    28     -33.332  59.125 114.218  1.00 34.56          
ATOM    199  N   SER    29     -30.990  62.288 116.497  1.00 25.45          
ATOM    200  CA  SER    29     -31.312  63.660 116.958  1.00 26.69          
ATOM    201  C   SER    29     -32.316  64.352 116.041  1.00 26.16          
ATOM    202  O   SER    29     -32.253  64.230 114.830  1.00 25.37          
ATOM    203  CB  SER    29     -30.054  64.523 117.053  1.00 26.38          
ATOM    204  OG  SER    29     -29.073  63.857 117.785  1.00 28.27          
ATOM    205  N   ASP    30     -33.206  65.111 116.653  1.00 27.40          
ATOM    206  CA  ASP    30     -34.402  65.677 115.995  1.00 28.42          
ATOM    207  C   ASP    30     -34.903  66.900 116.763  1.00 28.49          
ATOM    208  O   ASP    30     -35.030  66.883 117.971  1.00 30.23          
ATOM    209  CB  ASP    30     -35.516  64.631 115.871  1.00 28.93          
ATOM    210  CG  ASP    30     -36.570  65.014 114.850  1.00 28.04          
ATOM    211  OD1 ASP    30     -36.518  64.492 113.740  1.00 29.18          
ATOM    212  OD2 ASP    30     -37.406  65.879 115.119  1.00 32.17          
ATOM    213  N   PHE    31     -35.177  67.997 116.082  1.00 28.36          
ATOM    214  CA  PHE    31     -35.700  69.153 116.805  1.00 29.05          
ATOM    215  C   PHE    31     -37.104  68.936 117.434  1.00 28.82          
ATOM    216  O   PHE    31     -37.407  69.530 118.448  1.00 28.59          
ATOM    217  CB  PHE    31     -35.757  70.382 115.887  1.00 28.32          
ATOM    218  CG  PHE    31     -34.445  71.032 115.623  1.00 26.78          
ATOM    219  CD1 PHE    31     -33.658  71.523 116.662  1.00 31.08          
ATOM    220  CD2 PHE    31     -34.031  71.270 114.328  1.00 26.36          
ATOM    221  CE1 PHE    31     -32.470  72.208 116.397  1.00 29.31          
ATOM    222  CE2 PHE    31     -32.869  71.963 114.071  1.00 28.07          
ATOM    223  CZ  PHE    31     -32.097  72.452 115.097  1.00 28.36          
ATOM    224  N   LEU    32     -37.924  68.106 116.808  1.00 29.46          
ATOM    225  CA  LEU    32     -39.292  67.925 117.196  1.00 30.85          
ATOM    226  C   LEU    32     -39.486  66.743 118.123  1.00 30.87          
ATOM    227  O   LEU    32     -40.280  66.838 119.039  1.00 34.95          
ATOM    228  CB  LEU    32     -40.230  67.840 115.981  1.00 30.36          
ATOM    229  CG  LEU    32     -40.170  69.071 115.057  1.00 33.44          
ATOM    230  CD1 LEU    32     -41.098  68.806 113.791  1.00 34.67          
ATOM    231  CD2 LEU    32     -40.541  70.415 115.712  1.00 34.28          
ATOM    232  N   ILE    33     -38.743  65.672 117.993  1.00 29.62          
ATOM    233  CA  ILE    33     -38.834  64.622 118.991  1.00 29.33          
ATOM    234  C   ILE    33     -38.074  65.110 120.249  1.00 28.93          
ATOM    235  O   ILE    33     -36.911  65.445 120.166  1.00 29.79          
ATOM    236  CB  ILE    33     -38.343  63.272 118.421  1.00 30.27          
ATOM    237  CG1 ILE    33     -39.194  62.877 117.229  1.00 27.51          
ATOM    238  CG2 ILE    33     -38.332  62.117 119.489  1.00 27.56          
ATOM    239  CD  ILE    33     -38.501  61.803 116.322  1.00 30.77          
ATOM    240  N   PRO    34     -38.755  65.199 121.411  1.00 28.60          
ATOM    241  CA  PRO    34     -38.187  65.759 122.658  1.00 29.40          
ATOM    242  C   PRO    34     -36.805  65.220 123.074  1.00 29.36          
ATOM    243  O   PRO    34     -35.859  65.990 123.162  1.00 31.54          
ATOM    244  CB  PRO    34     -39.243  65.382 123.722  1.00 28.23          
ATOM    245  CG  PRO    34     -40.538  65.444 122.973  1.00 29.15          
ATOM    246  CD  PRO    34     -40.145  64.736 121.640  1.00 28.39          
ATOM    247  N   ALA    35     -36.688  63.922 123.298  1.00 29.36          
ATOM    248  CA  ALA    35     -35.441  63.331 123.801  1.00 29.30          
ATOM    249  C   ALA    35     -34.730  62.597 122.656  1.00 29.34          
ATOM    250  O   ALA    35     -35.249  61.607 122.155  1.00 30.98          
ATOM    251  CB  ALA    35     -35.720  62.354 124.942  1.00 29.07          
ATOM    252  N   ASP    36     -33.571  63.106 122.233  1.00 28.90          
ATOM    253  CA  ASP    36     -32.702  62.400 121.293  1.00 28.01          
ATOM    254  C   ASP    36     -32.294  61.067 121.950  1.00 27.95          
ATOM    255  O   ASP    36     -32.331  60.929 123.162  1.00 28.46          
ATOM    256  CB  ASP    36     -31.467  63.236 120.934  1.00 26.50          
ATOM    257  CG  ASP    36     -31.798  64.557 120.222  1.00 26.98          
ATOM    258  OD1 ASP    36     -32.948  64.770 119.727  1.00 23.46          
ATOM    259  OD2 ASP    36     -30.855  65.365 120.088  1.00 23.87          
ATOM    260  N   SER    37     -31.985  60.065 121.134  1.00 28.79          
ATOM    261  CA  SER    37     -31.723  58.750 121.626  1.00 28.70          
ATOM    262  C   SER    37     -30.560  58.050 120.920  1.00 27.89          
ATOM    263  O   SER    37     -30.061  58.428 119.851  1.00 26.11          
ATOM    264  CB  SER    37     -32.978  57.877 121.452  1.00 29.30          
ATOM    265  OG  SER    37     -33.322  57.817 120.116  1.00 31.89          
ATOM    266  N   PHE    38     -30.110  57.025 121.590  1.00 28.12          
ATOM    267  CA  PHE    38     -29.028  56.225 121.114  1.00 28.90          
ATOM    268  C   PHE    38     -29.276  54.767 121.450  1.00 29.11          
ATOM    269  O   PHE    38     -29.956  54.427 122.433  1.00 27.02          
ATOM    270  CB  PHE    38     -27.684  56.694 121.682  1.00 30.05          
ATOM    271  CG  PHE    38     -27.565  56.585 123.177  1.00 30.44          
ATOM    272  CD1 PHE    38     -27.075  55.419 123.772  1.00 30.89          
ATOM    273  CD2 PHE    38     -27.886  57.671 123.989  1.00 30.41          
ATOM    274  CE1 PHE    38     -26.949  55.308 125.176  1.00 30.91          
ATOM    275  CE2 PHE    38     -27.760  57.563 125.417  1.00 32.29          
ATOM    276  CZ  PHE    38     -27.295  56.378 125.990  1.00 30.51          
ATOM    277  N   ASP    39     -28.673  53.944 120.601  1.00 29.44          
ATOM    278  CA  ASP    39     -28.730  52.511 120.658  1.00 30.97          
ATOM    279  C   ASP    39     -27.452  51.863 120.094  1.00 29.53          
ATOM    280  O   ASP    39     -27.089  52.155 118.971  1.00 28.17          
ATOM    281  CB  ASP    39     -29.940  52.119 119.853  1.00 32.66          
ATOM    282  CG  ASP    39     -30.703  51.106 120.524  1.00 40.22          
ATOM    283  OD1 ASP    39     -30.298  49.934 120.321  1.00 48.36          
ATOM    284  OD2 ASP    39     -31.637  51.504 121.306  1.00 47.26          
ATOM    285  N   PHE    40     -26.770  51.055 120.900  1.00 29.52          
ATOM    286  CA  PHE    40     -25.504  50.397 120.545  1.00 31.48          
ATOM    287  C   PHE    40     -25.529  48.881 120.806  1.00 32.15          
ATOM    288  O   PHE    40     -26.050  48.444 121.825  1.00 30.45          
ATOM    289  CB  PHE    40     -24.320  51.001 121.362  1.00 30.38          
ATOM    290  CG  PHE    40     -23.957  52.419 120.966  1.00 30.03          
ATOM    291  CD1 PHE    40     -22.936  52.676 120.045  1.00 31.18          
ATOM    292  CD2 PHE    40     -24.609  53.517 121.572  1.00 30.67          
ATOM    293  CE1 PHE    40     -22.614  53.994 119.697  1.00 28.39          
ATOM    294  CE2 PHE    40     -24.271  54.823 121.239  1.00 29.61          
ATOM    295  CZ  PHE    40     -23.292  55.053 120.286  1.00 30.48          
ATOM    296  N   VAL    41     -24.947  48.105 119.897  1.00 33.62          
ATOM    297  CA  VAL    41     -24.826  46.667 120.039  1.00 37.19          
ATOM    298  C   VAL    41     -23.402  46.243 119.651  1.00 40.00          
ATOM    299  O   VAL    41     -22.859  46.725 118.659  1.00 38.21          
ATOM    300  CB  VAL    41     -25.790  45.893 119.105  1.00 36.93          
ATOM    301  CG1 VAL    41     -25.584  44.420 119.276  1.00 38.74          
ATOM    302  CG2 VAL    41     -27.252  46.317 119.318  1.00 35.53          
ATOM    303  N   ILE    42     -22.782  45.409 120.476  1.00 42.82          
ATOM    304  CA  ILE    42     -21.613  44.648 120.010  1.00 45.72          
ATOM    305  C   ILE    42     -21.963  43.142 120.113  1.00 48.12          
ATOM    306  O   ILE    42     -22.742  42.713 120.987  1.00 45.70          
ATOM    307  CB  ILE    42     -20.324  45.111 120.758  1.00 46.45          
ATOM    308  CG1 ILE    42     -19.081  44.220 120.408  1.00 48.80          
ATOM    309  CG2 ILE    42     -20.613  45.262 122.260  1.00 42.49          
ATOM    310  CD  ILE    42     -18.712  44.077 118.895  1.00 47.82          
ATOM    311  N   GLY    43     -21.416  42.350 119.192  1.00 51.07          
ATOM    312  CA  GLY    43     -21.754  40.920 119.113  1.00 53.22          
ATOM    313  C   GLY    43     -20.572  39.988 118.872  1.00 55.73          
ATOM    314  O   GLY    43     -20.428  39.454 117.757  1.00 56.71          
ATOM    315  N   ARG    44     -19.711  39.832 119.891  1.00 57.77          
ATOM    316  CA  ARG    44     -18.540  38.938 119.812  1.00 59.60          
ATOM    317  C   ARG    44     -18.368  38.186 121.132  1.00 60.03          
ATOM    318  O   ARG    44     -18.223  38.807 122.186  1.00 60.04          
ATOM    319  CB  ARG    44     -17.231  39.706 119.493  1.00 60.72          
ATOM    320  CG  ARG    44     -17.316  40.833 118.457  1.00 62.24          
ATOM    321  CD  ARG    44     -16.059  41.777 118.548  1.00 64.13          
ATOM    322  NE  ARG    44     -16.320  43.132 118.004  1.00 67.08          
ATOM    323  CZ  ARG    44     -16.290  43.465 116.703  1.00 69.42          
ATOM    324  NH1 ARG    44     -16.577  44.721 116.347  1.00 68.97          
ATOM    325  NH2 ARG    44     -15.962  42.570 115.750  1.00 68.78          
ATOM    326  N   PRO    52     -20.360  44.369 132.751  1.00 51.41          
ATOM    327  CA  PRO    52     -20.621  45.410 133.743  1.00 51.01          
ATOM    328  C   PRO    52     -22.010  46.079 133.543  1.00 50.36          
ATOM    329  O   PRO    52     -22.361  46.421 132.422  1.00 50.01          
ATOM    330  CB  PRO    52     -19.479  46.402 133.480  1.00 51.00          
ATOM    331  CG  PRO    52     -19.171  46.243 131.978  1.00 51.93          
ATOM    332  CD  PRO    52     -19.766  44.923 131.510  1.00 51.79          
ATOM    333  N   ASP    53     -22.796  46.248 134.599  1.00 50.12          
ATOM    334  CA  ASP    53     -24.080  46.971 134.459  1.00 49.58          
ATOM    335  C   ASP    53     -23.901  48.513 134.407  1.00 48.78          
ATOM    336  O   ASP    53     -23.615  49.162 135.423  1.00 49.39          
ATOM    337  CB  ASP    53     -25.093  46.582 135.545  1.00 49.94          
ATOM    338  CG  ASP    53     -26.471  47.289 135.365  1.00 50.41          
ATOM    339  OD1 ASP    53     -26.875  47.605 134.232  1.00 49.88          
ATOM    340  OD2 ASP    53     -27.166  47.527 136.371  1.00 53.02          
ATOM    341  N   LEU    54     -24.107  49.076 133.215  1.00 47.28          
ATOM    342  CA  LEU    54     -23.997  50.513 132.985  1.00 45.95          
ATOM    343  C   LEU    54     -25.370  51.191 132.975  1.00 44.69          
ATOM    344  O   LEU    54     -25.441  52.374 132.773  1.00 43.24          
ATOM    345  CB  LEU    54     -23.281  50.813 131.650  1.00 45.80          
ATOM    346  CG  LEU    54     -21.942  50.143 131.349  1.00 44.90          
ATOM    347  CD1 LEU    54     -21.535  50.393 129.920  1.00 45.87          
ATOM    348  CD2 LEU    54     -20.866  50.614 132.302  1.00 46.93          
ATOM    349  N   SER    55     -26.452  50.444 133.196  1.00 43.87          
ATOM    350  CA  SER    55     -27.783  51.033 133.174  1.00 43.13          
ATOM    351  C   SER    55     -27.891  52.050 134.283  1.00 41.74          
ATOM    352  O   SER    55     -27.423  51.830 135.417  1.00 41.47          
ATOM    353  CB  SER    55     -28.905  49.975 133.287  1.00 42.85          
ATOM    354  OG  SER    55     -28.809  49.244 134.523  1.00 45.20          
ATOM    355  N   GLY    56     -28.483  53.190 133.934  1.00 39.70          
ATOM    356  CA  GLY    56     -28.630  54.279 134.839  1.00 38.72          
ATOM    357  C   GLY    56     -27.416  55.163 134.964  1.00 37.91          
ATOM    358  O   GLY    56     -27.478  56.133 135.692  1.00 39.38          
ATOM    359  N   GLU    57     -26.324  54.840 134.275  1.00 37.42          
ATOM    360  CA  GLU    57     -25.086  55.653 134.301  1.00 36.82          
ATOM    361  C   GLU    57     -25.166  56.824 133.312  1.00 35.22          
ATOM    362  O   GLU    57     -25.780  56.718 132.266  1.00 34.58          
ATOM    363  CB  GLU    57     -23.873  54.806 133.890  1.00 37.68          
ATOM    364  CG  GLU    57     -23.460  53.727 134.863  1.00 40.94          
ATOM    365  CD  GLU    57     -23.071  54.297 136.165  1.00 47.97          
ATOM    366  OE1 GLU    57     -22.421  55.358 136.155  1.00 52.96          
ATOM    367  OE2 GLU    57     -23.457  53.729 137.214  1.00 54.33          
ATOM    368  N   SER    58     -24.510  57.919 133.659  1.00 34.25          
ATOM    369  CA  SER    58     -24.381  59.070 132.808  1.00 34.06          
ATOM    370  C   SER    58     -23.392  58.750 131.717  1.00 32.78          
ATOM    371  O   SER    58     -22.433  58.043 131.946  1.00 31.76          
ATOM    372  CB  SER    58     -23.857  60.264 133.601  1.00 34.38          
ATOM    373  OG  SER    58     -24.908  60.783 134.347  1.00 38.01          
ATOM    374  N   CYS    59     -23.637  59.243 130.513  1.00 31.58          
ATOM    375  CA  CYS    59     -22.721  58.927 129.414  1.00 31.05          
ATOM    376  C   CYS    59     -22.598  60.060 128.402  1.00 29.79          
ATOM    377  O   CYS    59     -23.385  60.976 128.377  1.00 29.15          
ATOM    378  CB  CYS    59     -23.125  57.629 128.707  1.00 30.54          
ATOM    379  SG  CYS    59     -24.696  57.691 127.807  1.00 32.76          
ATOM    380  N   GLU    60     -21.599  59.931 127.561  1.00 30.21          
ATOM    381  CA  GLU    60     -21.435  60.791 126.401  1.00 31.12          
ATOM    382  C   GLU    60     -21.197  59.906 125.208  1.00 29.98          
ATOM    383  O   GLU    60     -20.539  58.866 125.306  1.00 30.47          
ATOM    384  CB  GLU    60     -20.268  61.785 126.616  1.00 30.94          
ATOM    385  CG  GLU    60     -20.602  62.824 127.644  1.00 30.64          
ATOM    386  CD  GLU    60     -19.359  63.549 128.197  1.00 34.21          
ATOM    387  OE1 GLU    60     -18.306  62.927 128.278  1.00 36.60          
ATOM    388  OE2 GLU    60     -19.442  64.749 128.550  1.00 36.62          
ATOM    389  N   VAL    61     -21.787  60.288 124.078  1.00 29.42          
ATOM    390  CA  VAL    61     -21.582  59.567 122.869  1.00 27.93          
ATOM    391  C   VAL    61     -20.532  60.381 122.112  1.00 28.61          
ATOM    392  O   VAL    61     -20.652  61.566 122.006  1.00 28.62          
ATOM    393  CB  VAL    61     -22.883  59.392 122.080  1.00 28.17          
ATOM    394  CG1 VAL    61     -22.582  58.661 120.643  1.00 22.78          
ATOM    395  CG2 VAL    61     -23.964  58.664 122.970  1.00 30.05          
ATOM    396  N   VAL    62     -19.467  59.743 121.647  1.00 29.74          
ATOM    397  CA  VAL    62     -18.340  60.500 121.092  1.00 30.10          
ATOM    398  C   VAL    62     -17.980  59.899 119.736  1.00 29.90          
ATOM    399  O   VAL    62     -17.868  58.692 119.590  1.00 28.89          
ATOM    400  CB  VAL    62     -17.102  60.494 122.062  1.00 31.61          
ATOM    401  CG1 VAL    62     -16.053  61.571 121.654  1.00 30.69          
ATOM    402  CG2 VAL    62     -17.536  60.751 123.492  1.00 30.57          
ATOM    403  N   ILE    63     -17.823  60.757 118.749  1.00 29.96          
ATOM    404  CA  ILE    63     -17.340  60.355 117.430  1.00 31.08          
ATOM    405  C   ILE    63     -16.049  61.154 117.162  1.00 31.62          
ATOM    406  O   ILE    63     -16.078  62.376 117.163  1.00 32.57          
ATOM    407  CB  ILE    63     -18.393  60.638 116.313  1.00 31.34          
ATOM    408  CG1 ILE    63     -19.756  59.990 116.661  1.00 30.81          
ATOM    409  CG2 ILE    63     -17.824  60.226 114.871  1.00 29.45          
ATOM    410  CD  ILE    63     -20.823  60.087 115.590  1.00 30.53          
ATOM    411  N   ASP    64     -14.950  60.444 116.947  1.00 32.82          
ATOM    412  CA  ASP    64     -13.612  61.033 116.682  1.00 34.22          
ATOM    413  C   ASP    64     -13.324  62.113 117.672  1.00 34.19          
ATOM    414  O   ASP    64     -12.936  63.210 117.282  1.00 34.77          
ATOM    415  CB  ASP    64     -13.504  61.630 115.257  1.00 35.15          
ATOM    416  CG  ASP    64     -13.480  60.601 114.188  1.00 37.26          
ATOM    417  OD1 ASP    64     -13.060  59.440 114.470  1.00 40.92          
ATOM    418  OD2 ASP    64     -13.850  60.966 113.036  1.00 42.61          
ATOM    419  N   GLY    65     -13.543  61.800 118.953  1.00 34.28          
ATOM    420  CA  GLY    65     -13.271  62.714 120.052  1.00 33.84          
ATOM    421  C   GLY    65     -14.208  63.861 120.169  1.00 34.28          
ATOM    422  O   GLY    65     -14.031  64.705 121.029  1.00 32.77          
ATOM    423  N   GLN    66     -15.246  63.912 119.337  1.00 34.01          
ATOM    424  CA  GLN    66     -16.229  64.977 119.509  1.00 34.53          
ATOM    425  C   GLN    66     -17.528  64.417 120.108  1.00 33.59          
ATOM    426  O   GLN    66     -18.117  63.422 119.598  1.00 32.86          
ATOM    427  CB  GLN    66     -16.470  65.654 118.189  1.00 33.65          
ATOM    428  CG  GLN    66     -17.451  66.763 118.281  1.00 39.74          
ATOM    429  CD  GLN    66     -17.464  67.628 117.021  1.00 40.80          
ATOM    430  OE1 GLN    66     -16.657  67.407 116.057  1.00 51.57          
ATOM    431  NE2 GLN    66     -18.366  68.593 117.002  1.00 43.72          
ATOM    432  N   ILE    67     -17.940  65.019 121.208  1.00 31.44          
ATOM    433  CA  ILE    67     -19.157  64.608 121.867  1.00 31.76          
ATOM    434  C   ILE    67     -20.352  65.013 120.967  1.00 31.10          
ATOM    435  O   ILE    67     -20.475  66.176 120.572  1.00 29.67          
ATOM    436  CB  ILE    67     -19.298  65.264 123.236  1.00 31.24          
ATOM    437  CG1 ILE    67     -18.222  64.702 124.197  1.00 32.93          
ATOM    438  CG2 ILE    67     -20.705  65.056 123.795  1.00 29.63          
ATOM    439  CD  ILE    67     -17.940  65.629 125.406  1.00 34.21          
ATOM    440  N   VAL    68     -21.216  64.040 120.656  1.00 29.01          
ATOM    441  CA  VAL    68     -22.414  64.282 119.843  1.00 27.58          
ATOM    442  C   VAL    68     -23.721  64.220 120.659  1.00 27.15          
ATOM    443  O   VAL    68     -24.784  64.682 120.201  1.00 27.48          
ATOM    444  CB  VAL    68     -22.426  63.350 118.546  1.00 28.05          
ATOM    445  CG1 VAL    68     -21.122  63.554 117.712  1.00 28.41          
ATOM    446  CG2 VAL    68     -22.540  61.863 118.868  1.00 24.79          
ATOM    447  N   MET    69     -23.646  63.699 121.875  1.00 26.51          
ATOM    448  CA  MET    69     -24.822  63.573 122.748  1.00 27.13          
ATOM    449  C   MET    69     -24.372  63.322 124.175  1.00 26.60          
ATOM    450  O   MET    69     -23.422  62.573 124.400  1.00 26.59          
ATOM    451  CB  MET    69     -25.743  62.413 122.283  1.00 27.30          
ATOM    452  CG  MET    69     -27.172  62.388 122.887  1.00 27.36          
ATOM    453  SD  MET    69     -28.231  61.018 122.163  1.00 23.27          
ATOM    454  CE  MET    69     -28.401  61.593 120.493  1.00 27.69          
ATOM    455  N   THR    70     -25.104  63.923 125.112  1.00 27.88          
ATOM    456  CA  THR    70     -24.901  63.773 126.537  1.00 28.17          
ATOM    457  C   THR    70     -26.198  63.210 127.096  1.00 28.42          
ATOM    458  O   THR    70     -27.255  63.757 126.864  1.00 30.38          
ATOM    459  CB  THR    70     -24.507  65.178 127.196  1.00 27.99          
ATOM    460  OG1 THR    70     -23.398  65.721 126.466  1.00 28.79          
ATOM    461  CG2 THR    70     -24.125  65.044 128.688  1.00 28.27          
ATOM    462  N   GLY    71     -26.138  62.103 127.819  1.00 29.29          
ATOM    463  CA  GLY    71     -27.352  61.473 128.321  1.00 29.34          
ATOM    464  C   GLY    71     -27.150  60.417 129.383  1.00 29.13          
ATOM    465  O   GLY    71     -26.175  60.423 130.092  1.00 27.81          
ATOM    466  N   ILE    72     -28.087  59.481 129.436  1.00 29.73          
ATOM    467  CA  ILE    72     -28.169  58.499 130.497  1.00 29.85          
ATOM    468  C   ILE    72     -28.516  57.189 129.814  1.00 29.96          
ATOM    469  O   ILE    72     -29.427  57.133 128.987  1.00 29.60          
ATOM    470  CB  ILE    72     -29.279  58.852 131.599  1.00 30.07          
ATOM    471  CG1 ILE    72     -28.987  60.189 132.263  1.00 32.10          
ATOM    472  CG2 ILE    72     -29.343  57.796 132.746  1.00 28.43          
ATOM    473  CD  ILE    72     -29.440  61.348 131.446  1.00 39.19          
ATOM    474  N   ILE    73     -27.786  56.142 130.177  1.00 29.97          
ATOM    475  CA  ILE    73     -28.104  54.771 129.736  1.00 30.54          
ATOM    476  C   ILE    73     -29.386  54.357 130.481  1.00 30.87          
ATOM    477  O   ILE    73     -29.442  54.326 131.733  1.00 30.92          
ATOM    478  CB  ILE    73     -26.942  53.831 129.988  1.00 30.25          
ATOM    479  CG1 ILE    73     -25.724  54.341 129.186  1.00 32.28          
ATOM    480  CG2 ILE    73     -27.241  52.312 129.540  1.00 29.68          
ATOM    481  CD  ILE    73     -24.506  53.577 129.438  1.00 31.15          
ATOM    482  N   GLY    74     -30.441  54.129 129.709  1.00 30.69          
ATOM    483  CA  GLY    74     -31.705  53.738 130.269  1.00 31.51          
ATOM    484  C   GLY    74     -31.825  52.248 130.401  1.00 32.49          
ATOM    485  O   GLY    74     -32.529  51.758 131.256  1.00 34.55          
ATOM    486  N   SER    75     -31.186  51.503 129.526  1.00 32.88          
ATOM    487  CA  SER    75     -31.353  50.082 129.545  1.00 33.02          
ATOM    488  C   SER    75     -30.193  49.341 128.920  1.00 31.93          
ATOM    489  O   SER    75     -29.443  49.865 128.096  1.00 30.02          
ATOM    490  CB  SER    75     -32.683  49.663 128.907  1.00 33.20          
ATOM    491  OG  SER    75     -32.669  49.675 127.522  1.00 34.22          
ATOM    492  N   GLN    76     -30.041  48.110 129.373  1.00 31.69          
ATOM    493  CA  GLN    76     -28.957  47.245 128.932  1.00 31.80          
ATOM    494  C   GLN    76     -29.450  45.830 128.784  1.00 30.44          
ATOM    495  O   GLN    76     -30.176  45.325 129.626  1.00 29.95          
ATOM    496  CB  GLN    76     -27.784  47.340 129.945  1.00 31.30          
ATOM    497  CG  GLN    76     -26.566  46.457 129.568  1.00 34.09          
ATOM    498  CD  GLN    76     -25.351  46.680 130.501  1.00 35.74          
ATOM    499  OE1 GLN    76     -25.058  47.790 130.923  1.00 39.07          
ATOM    500  NE2 GLN    76     -24.670  45.602 130.830  1.00 41.85          
ATOM    501  N   ARG    77     -29.033  45.167 127.713  1.00 31.71          
ATOM    502  CA  ARG    77     -29.298  43.765 127.497  1.00 32.42          
ATOM    503  C   ARG    77     -27.997  42.951 127.231  1.00 32.84          
ATOM    504  O   ARG    77     -27.079  43.374 126.504  1.00 30.95          
ATOM    505  CB  ARG    77     -30.283  43.598 126.340  1.00 32.59          
ATOM    506  CG  ARG    77     -31.654  44.186 126.575  1.00 35.10          
ATOM    507  CD  ARG    77     -32.322  44.631 125.300  1.00 36.82          
ATOM    508  NE  ARG    77     -31.593  45.792 124.772  1.00 42.64          
ATOM    509  CZ  ARG    77     -31.728  47.044 125.224  1.00 41.01          
ATOM    510  NH1 ARG    77     -32.613  47.342 126.181  1.00 41.81          
ATOM    511  NH2 ARG    77     -30.978  47.986 124.702  1.00 37.70          
ATOM    512  N   HSD    78     -27.901  41.801 127.877  1.00 33.52          
ATOM    513  CA  HSD    78     -26.949  40.794 127.464  1.00 33.07          
ATOM    514  C   HSD    78     -27.656  39.518 127.018  1.00 32.46          
ATOM    515  O   HSD    78     -28.532  38.975 127.709  1.00 31.46          
ATOM    516  CB  HSD    78     -25.921  40.498 128.572  1.00 34.49          
ATOM    517  CG  HSD    78     -24.818  39.605 128.093  1.00 37.37          
ATOM    518  ND1 HSD    78     -24.605  38.332 128.592  1.00 45.39          
ATOM    519  CD2 HSD    78     -23.923  39.771 127.086  1.00 42.06          
ATOM    520  CE1 HSD    78     -23.602  37.771 127.931  1.00 44.64          
ATOM    521  NE2 HSD    78     -23.169  38.626 127.020  1.00 41.81          
ATOM    522  N   GLY    79     -27.307  39.055 125.845  1.00 30.57          
ATOM    523  CA  GLY    79     -27.870  37.839 125.298  1.00 32.15          
ATOM    524  C   GLY    79     -26.770  36.919 124.812  1.00 32.40          
ATOM    525  O   GLY    79     -25.793  37.394 124.224  1.00 29.66          
ATOM    526  N   LYS    80     -26.949  35.626 125.096  1.00 32.10          
ATOM    527  CA  LYS    80     -26.021  34.533 124.813  1.00 34.30          
ATOM    528  C   LYS    80     -26.820  33.361 124.250  1.00 34.78          
ATOM    529  O   LYS    80     -27.835  32.951 124.846  1.00 32.43          
ATOM    530  CB  LYS    80     -25.499  33.959 126.135  1.00 34.96          
ATOM    531  CG  LYS    80     -24.097  34.193 126.578  1.00 36.81          
ATOM    532  CD  LYS    80     -23.875  33.428 127.873  1.00 36.49          
ATOM    533  CE  LYS    80     -22.920  34.102 128.806  1.00 39.99          
ATOM    534  NZ  LYS    80     -22.635  33.139 129.862  1.00 39.29          
ATOM    535  N   SER    81     -26.347  32.783 123.166  1.00 35.54          
ATOM    536  CA  SER    81     -26.737  31.433 122.776  1.00 38.54          
ATOM    537  C   SER    81     -25.448  30.747 122.281  1.00 39.03          
ATOM    538  O   SER    81     -24.384  31.335 122.387  1.00 37.77          
ATOM    539  CB  SER    81     -27.824  31.468 121.706  1.00 39.48          
ATOM    540  OG  SER    81     -27.405  32.214 120.578  1.00 43.00          
ATOM    541  N   LYS    82     -25.511  29.506 121.801  1.00 41.44          
ATOM    542  CA  LYS    82     -24.273  28.843 121.342  1.00 42.63          
ATOM    543  C   LYS    82     -23.960  29.511 120.015  1.00 42.67          
ATOM    544  O   LYS    82     -24.824  29.665 119.170  1.00 43.27          
ATOM    545  CB  LYS    82     -24.377  27.309 121.231  1.00 43.30          
ATOM    546  CG  LYS    82     -24.337  26.532 122.576  1.00 45.93          
ATOM    547  CD  LYS    82     -23.298  27.032 123.629  1.00 47.10          
ATOM    548  CE  LYS    82     -23.455  26.248 124.941  1.00 47.79          
ATOM    549  NZ  LYS    82     -24.326  26.988 125.877  1.00 49.19          
ATOM    550  N   GLY    83     -22.767  30.034 119.878  1.00 44.07          
ATOM    551  CA  GLY    83     -22.469  30.856 118.704  1.00 45.15          
ATOM    552  C   GLY    83     -22.598  32.375 118.766  1.00 46.07          
ATOM    553  O   GLY    83     -22.019  33.035 117.940  1.00 47.28          
ATOM    554  N   SER    84     -23.334  32.968 119.704  1.00 47.26          
ATOM    555  CA  SER    84     -23.395  34.457 119.758  1.00 47.59          
ATOM    556  C   SER    84     -23.544  34.977 121.147  1.00 47.33          
ATOM    557  O   SER    84     -24.134  34.305 121.970  1.00 46.47          
ATOM    558  CB  SER    84     -24.519  35.011 118.867  1.00 49.07          
ATOM    559  OG  SER    84     -25.319  33.966 118.299  1.00 52.71          
ATOM    560  N   ARG    85     -22.929  36.133 121.417  1.00 47.23          
ATOM    561  CA  ARG    85     -23.128  36.917 122.628  1.00 47.91          
ATOM    562  C   ARG    85     -23.341  38.320 122.111  1.00 47.71          
ATOM    563  O   ARG    85     -22.612  38.776 121.194  1.00 47.15          
ATOM    564  CB  ARG    85     -21.931  36.899 123.590  1.00 48.04          
ATOM    565  CG  ARG    85     -21.512  35.481 124.042  1.00 52.51          
ATOM    566  CD  ARG    85     -20.060  35.337 124.608  1.00 53.32          
ATOM    567  NE  ARG    85     -20.000  35.485 126.068  1.00 56.77          
ATOM    568  CZ  ARG    85     -20.037  36.666 126.702  1.00 57.94          
ATOM    569  NH1 ARG    85     -19.989  36.708 128.038  1.00 57.44          
ATOM    570  NH2 ARG    85     -20.111  37.812 126.020  1.00 58.75          
ATOM    571  N   GLU    86     -24.359  38.987 122.639  1.00 46.30          
ATOM    572  CA  GLU    86     -24.697  40.339 122.222  1.00 46.68          
ATOM    573  C   GLU    86     -24.937  41.172 123.457  1.00 44.93          
ATOM    574  O   GLU    86     -25.667  40.747 124.337  1.00 43.84          
ATOM    575  CB  GLU    86     -25.928  40.320 121.297  1.00 47.33          
ATOM    576  CG  GLU    86     -25.919  41.429 120.286  1.00 49.90          
ATOM    577  CD  GLU    86     -26.569  41.076 118.952  1.00 50.63          
ATOM    578  OE1 GLU    86     -27.809  41.257 118.881  1.00 53.84          
ATOM    579  OE2 GLU    86     -25.821  40.702 117.983  1.00 53.84          
ATOM    580  N   LEU    87     -24.223  42.289 123.582  1.00 43.49          
ATOM    581  CA  LEU    87     -24.468  43.261 124.634  1.00 42.46          
ATOM    582  C   LEU    87     -25.047  44.503 123.950  1.00 40.99          
ATOM    583  O   LEU    87     -24.481  44.987 122.959  1.00 39.38          
ATOM    584  CB  LEU    87     -23.177  43.598 125.376  1.00 42.72          
ATOM    585  CG  LEU    87     -23.063  44.955 126.122  1.00 45.50          
ATOM    586  CD1 LEU    87     -23.970  45.068 127.320  1.00 47.28          
ATOM    587  CD2 LEU    87     -21.603  45.247 126.567  1.00 45.25          
ATOM    588  N   SER    88     -26.194  44.977 124.435  1.00 38.36          
ATOM    589  CA  SER    88     -26.748  46.246 123.958  1.00 37.40          
ATOM    590  C   SER    88     -27.058  47.228 125.047  1.00 35.11          
ATOM    591  O   SER    88     -27.282  46.854 126.199  1.00 34.20          
ATOM    592  CB  SER    88     -27.944  46.041 123.034  1.00 37.42          
ATOM    593  OG  SER    88     -28.992  45.422 123.708  1.00 38.44          
ATOM    594  N   LEU    89     -26.978  48.504 124.663  1.00 34.34          
ATOM    595  CA  LEU    89     -27.235  49.691 125.517  1.00 34.13          
ATOM    596  C   LEU    89     -28.169  50.659 124.773  1.00 32.88          
ATOM    597  O   LEU    89     -27.952  50.916 123.564  1.00 32.03          
ATOM    598  CB  LEU    89     -25.946  50.501 125.764  1.00 34.70          
ATOM    599  CG  LEU    89     -24.712  49.823 126.318  1.00 37.91          
ATOM    600  CD1 LEU    89     -23.656  50.881 126.512  1.00 40.65          
ATOM    601  CD2 LEU    89     -25.029  49.110 127.641  1.00 41.44          
ATOM    602  N   SER    90     -29.150  51.210 125.485  1.00 30.40          
ATOM    603  CA  SER    90     -29.939  52.308 124.961  1.00 31.01          
ATOM    604  C   SER    90     -30.065  53.383 125.981  1.00 27.83          
ATOM    605  O   SER    90     -29.941  53.155 127.172  1.00 27.66          
ATOM    606  CB  SER    90     -31.365  51.920 124.551  1.00 30.70          
ATOM    607  OG  SER    90     -31.329  50.742 123.887  1.00 35.89          
ATOM    608  N   GLY    91     -30.428  54.527 125.472  1.00 26.17          
ATOM    609  CA  GLY    91     -30.664  55.674 126.281  1.00 26.41          
ATOM    610  C   GLY    91     -31.151  56.870 125.530  1.00 26.03          
ATOM    611  O   GLY    91     -31.442  56.852 124.303  1.00 23.36          
ATOM    612  N   ARG    92     -31.284  57.916 126.319  1.00 26.23          
ATOM    613  CA  ARG    92     -31.796  59.207 125.857  1.00 28.53          
ATOM    614  C   ARG    92     -30.883  60.316 126.319  1.00 28.27          
ATOM    615  O   ARG    92     -30.095  60.118 127.240  1.00 27.49          
ATOM    616  CB  ARG    92     -33.203  59.424 126.397  1.00 28.23          
ATOM    617  CG  ARG    92     -34.230  58.419 125.803  1.00 28.41          
ATOM    618  CD  ARG    92     -35.590  58.664 126.413  1.00 29.85          
ATOM    619  NE  ARG    92     -35.496  58.465 127.847  1.00 29.68          
ATOM    620  CZ  ARG    92     -36.383  58.833 128.764  1.00 33.83          
ATOM    621  NH1 ARG    92     -37.460  59.533 128.433  1.00 34.27          
ATOM    622  NH2 ARG    92     -36.115  58.568 130.041  1.00 31.84          
ATOM    623  N   ASP    93     -30.995  61.469 125.660  1.00 29.24          
ATOM    624  CA  ASP    93     -30.323  62.712 126.117  1.00 29.92          
ATOM    625  C   ASP    93     -30.971  63.270 127.407  1.00 29.75          
ATOM    626  O   ASP    93     -31.891  62.670 127.948  1.00 29.21          
ATOM    627  CB  ASP    93     -30.229  63.767 124.985  1.00 29.47          
ATOM    628  CG  ASP    93     -31.552  64.427 124.685  1.00 29.95          
ATOM    629  OD1 ASP    93     -32.540  64.185 125.415  1.00 27.66          
ATOM    630  OD2 ASP    93     -31.642  65.138 123.668  1.00 31.80          
ATOM   1309  N   VAL   186     -23.964  74.031 104.498  1.00 38.85          
ATOM   1310  CA  VAL   186     -22.664  73.500 104.900  1.00 38.79          
ATOM   1311  C   VAL   186     -22.119  72.544 103.908  1.00 37.25          
ATOM   1312  O   VAL   186     -20.950  72.178 104.008  1.00 37.70          
ATOM   1313  CB  VAL   186     -22.683  72.775 106.264  1.00 38.08          
ATOM   1314  CG1 VAL   186     -22.982  73.792 107.344  1.00 42.00          
ATOM   1315  CG2 VAL   186     -23.643  71.592 106.213  1.00 39.56          
ATOM   1316  N   ALA   187     -22.969  72.123 102.976  1.00 36.35          
ATOM   1317  CA  ALA   187     -22.658  71.065 102.051  1.00 35.53          
ATOM   1318  C   ALA   187     -23.634  71.137 100.881  1.00 35.65          
ATOM   1319  O   ALA   187     -24.734  71.674 101.017  1.00 34.50          
ATOM   1320  CB  ALA   187     -22.765  69.707 102.747  1.00 35.65          
ATOM   1321  N   THR   188     -23.172  70.637  99.738  1.00 35.67          
ATOM   1322  CA  THR   188     -23.961  70.356  98.573  1.00 35.97          
ATOM   1323  C   THR   188     -23.915  68.864  98.316  1.00 36.00          
ATOM   1324  O   THR   188     -22.844  68.261  98.103  1.00 36.69          
ATOM   1325  CB  THR   188     -23.462  71.082  97.347  1.00 36.05          
ATOM   1326  OG1 THR   188     -23.626  72.485  97.560  1.00 38.83          
ATOM   1327  CG2 THR   188     -24.250  70.651  96.123  1.00 35.54          
ATOM   1328  N   LEU   189     -25.091  68.249  98.377  1.00 35.59          
ATOM   1329  CA  LEU   189     -25.216  66.830  98.106  1.00 34.74          
ATOM   1330  C   LEU   189     -25.929  66.668  96.774  1.00 34.27          
ATOM   1331  O   LEU   189     -26.823  67.427  96.443  1.00 33.23          
ATOM   1332  CB  LEU   189     -25.993  66.166  99.196  1.00 34.34          
ATOM   1333  CG  LEU   189     -25.417  66.239 100.608  1.00 35.64          
ATOM   1334  CD1 LEU   189     -26.417  65.614 101.548  1.00 32.81          
ATOM   1335  CD2 LEU   189     -24.062  65.557 100.735  1.00 31.70          
ATOM   1336  N   CYS   190     -25.520  65.683  96.000  1.00 35.02          
ATOM   1337  CA  CYS   190     -26.134  65.460  94.701  1.00 36.34          
ATOM   1338  C   CYS   190     -26.325  63.981  94.414  1.00 35.56          
ATOM   1339  O   CYS   190     -25.655  63.107  94.980  1.00 33.56          
ATOM   1340  CB  CYS   190     -25.365  66.189  93.560  1.00 37.51          
ATOM   1341  SG  CYS   190     -23.684  65.583  93.143  1.00 44.19          
ATOM   1342  N   TRP   191     -27.330  63.729  93.584  1.00 36.84          
ATOM   1343  CA  TRP   191     -27.722  62.399  93.160  1.00 38.48          
ATOM   1344  C   TRP   191     -27.388  62.248  91.701  1.00 40.25          
ATOM   1345  O   TRP   191     -27.761  63.094  90.892  1.00 40.61          
ATOM   1346  CB  TRP   191     -29.225  62.181  93.300  1.00 37.49          
ATOM   1347  CG  TRP   191     -29.643  60.957  92.609  1.00 36.49          
ATOM   1348  CD1 TRP   191     -30.014  60.836  91.302  1.00 36.57          
ATOM   1349  CD2 TRP   191     -29.650  59.638  93.156  1.00 33.61          
ATOM   1350  NE1 TRP   191     -30.255  59.521  91.004  1.00 34.86          
ATOM   1351  CE2 TRP   191     -30.053  58.764  92.129  1.00 34.26          
ATOM   1352  CE3 TRP   191     -29.335  59.111  94.401  1.00 34.88          
ATOM   1353  CZ2 TRP   191     -30.184  57.394  92.331  1.00 36.10          
ATOM   1354  CZ3 TRP   191     -29.482  57.758  94.617  1.00 35.30          
ATOM   1355  CH2 TRP   191     -29.891  56.909  93.589  1.00 37.65          
ATOM   1356  N   SER   192     -26.706  61.161  91.358  1.00 43.18          
ATOM   1357  CA  SER   192     -26.477  60.816  89.958  1.00 45.35          
ATOM   1358  C   SER   192     -26.181  59.322  89.752  1.00 47.25          
ATOM   1359  O   SER   192     -25.384  58.731  90.474  1.00 47.96          
ATOM   1360  CB  SER   192     -25.343  61.663  89.383  1.00 45.38          
ATOM   1361  OG  SER   192     -25.148  61.335  88.022  1.00 49.51          
ATOM   1362  N   ARG   193     -26.819  58.724  88.747  1.00 49.21          
ATOM   1363  CA  ARG   193     -26.532  57.336  88.365  1.00 50.48          
ATOM   1364  C   ARG   193     -25.312  57.200  87.470  1.00 50.65          
ATOM   1365  O   ARG   193     -24.903  56.086  87.145  1.00 51.68          
ATOM   1366  CB  ARG   193     -27.739  56.731  87.662  1.00 51.01          
ATOM   1367  CG  ARG   193     -28.821  56.282  88.625  1.00 53.54          
ATOM   1368  CD  ARG   193     -30.190  56.434  87.974  1.00 55.23          
ATOM   1369  NE  ARG   193     -30.271  55.670  86.743  1.00 59.01          
ATOM   1370  CZ  ARG   193     -31.155  55.845  85.760  1.00 60.18          
ATOM   1371  NH1 ARG   193     -32.078  56.799  85.799  1.00 62.61          
ATOM   1372  NH2 ARG   193     -31.101  55.046  84.708  1.00 60.66          
ATOM   1373  N   THR   194     -24.735  58.324  87.048  1.00 51.21          
ATOM   1374  CA  THR   194     -23.526  58.317  86.212  1.00 50.82          
ATOM   1375  C   THR   194     -22.390  59.196  86.752  1.00 50.77          
ATOM   1376  O   THR   194     -21.219  58.941  86.465  1.00 49.94          
ATOM   1377  CB  THR   194     -23.852  58.731  84.755  1.00 51.00          
ATOM   1378  OG1 THR   194     -24.366  60.078  84.722  1.00 52.91          
ATOM   1379  CG2 THR   194     -24.860  57.753  84.162  1.00 49.93          
ATOM   1380  N   ASP   195     -22.716  60.233  87.521  1.00 50.93          
ATOM   1381  CA  ASP   195     -21.677  61.058  88.144  1.00 50.82          
ATOM   1382  C   ASP   195     -21.243  60.449  89.497  1.00 51.01          
ATOM   1383  O   ASP   195     -22.004  60.428  90.489  1.00 49.22          
ATOM   1384  CB  ASP   195     -22.126  62.520  88.266  1.00 50.95          
ATOM   1385  CG  ASP   195     -20.978  63.451  88.564  1.00 51.03          
ATOM   1386  OD1 ASP   195     -19.929  62.918  88.972  1.00 53.53          
ATOM   1387  OD2 ASP   195     -21.130  64.690  88.427  1.00 49.32          
ATOM   1388  N   SER   196     -20.005  59.928  89.501  1.00 51.04          
ATOM   1389  CA  SER   196     -19.387  59.317  90.693  1.00 51.28          
ATOM   1390  C   SER   196     -19.037  60.343  91.786  1.00 50.76          
ATOM   1391  O   SER   196     -18.823  59.974  92.949  1.00 49.65          
ATOM   1392  CB  SER   196     -18.114  58.552  90.289  1.00 51.87          
ATOM   1393  OG  SER   196     -17.160  59.451  89.725  1.00 54.08          
ATOM   1394  N   ARG   197     -18.953  61.619  91.402  1.00 50.33          
ATOM   1395  CA  ARG   197     -18.740  62.691  92.362  1.00 50.59          
ATOM   1396  C   ARG   197     -20.026  62.840  93.272  1.00 49.73          
ATOM   1397  O   ARG   197     -19.959  63.358  94.397  1.00 49.56          
ATOM   1398  CB  ARG   197     -18.342  63.997  91.621  1.00 50.74          
ATOM   1399  CG  ARG   197     -17.228  63.766  90.528  1.00 53.83          
ATOM   1400  CD  ARG   197     -16.419  64.999  90.050  1.00 54.51          
ATOM   1401  NE  ARG   197     -17.187  65.907  89.185  1.00 58.42          
ATOM   1402  CZ  ARG   197     -16.701  66.991  88.535  1.00 59.35          
ATOM   1403  NH1 ARG   197     -15.401  67.363  88.600  1.00 59.88          
ATOM   1404  NH2 ARG   197     -17.532  67.733  87.795  1.00 59.67          
ATOM   1405  N   CYS   198     -21.171  62.345  92.785  1.00 48.14          
ATOM   1406  CA  CYS   198     -22.419  62.419  93.511  1.00 47.25          
ATOM   1407  C   CYS   198     -22.537  61.263  94.461  1.00 45.83          
ATOM   1408  O   CYS   198     -22.404  60.100  94.131  1.00 47.34          
ATOM   1409  CB  CYS   198     -23.623  62.481  92.595  1.00 46.41          
ATOM   1410  SG  CYS   198     -23.794  64.042  91.734  1.00 47.30          
ATOM   1411  N   ASN   199     -22.880  61.631  95.655  1.00 43.83          
ATOM   1412  CA  ASN   199     -22.598  60.876  96.828  1.00 41.52          
ATOM   1413  C   ASN   199     -23.873  60.386  97.578  1.00 40.05          
ATOM   1414  O   ASN   199     -23.791  59.610  98.513  1.00 40.12          
ATOM   1415  CB  ASN   199     -21.753  61.837  97.702  1.00 42.73          
ATOM   1416  CG  ASN   199     -22.489  63.203  98.079  1.00 40.92          
ATOM   1417  OD1 ASN   199     -22.883  63.291  99.232  1.00 51.66          
ATOM   1418  ND2 ASN   199     -22.582  64.245  97.189  1.00 23.80          
ATOM   1419  N   ILE   200     -25.042  60.869  97.186  1.00 37.32          
ATOM   1420  CA  ILE   200     -26.310  60.418  97.805  1.00 36.46          
ATOM   1421  C   ILE   200     -26.498  58.929  97.480  1.00 35.01          
ATOM   1422  O   ILE   200     -26.463  58.552  96.319  1.00 31.85          
ATOM   1423  CB  ILE   200     -27.514  61.266  97.297  1.00 35.89          
ATOM   1424  CG1 ILE   200     -27.412  62.691  97.843  1.00 34.83          
ATOM   1425  CG2 ILE   200     -28.838  60.646  97.670  1.00 34.86          
ATOM   1426  CD  ILE   200     -28.267  63.686  97.067  1.00 35.99          
ATOM   1427  N   GLU   201     -26.662  58.111  98.513  1.00 33.66          
ATOM   1428  CA  GLU   201     -26.908  56.676  98.369  1.00 35.74          
ATOM   1429  C   GLU   201     -28.404  56.301  98.217  1.00 35.64          
ATOM   1430  O   GLU   201     -28.755  55.354  97.525  1.00 33.84          
ATOM   1431  CB  GLU   201     -26.369  55.941  99.574  1.00 34.47          
ATOM   1432  CG  GLU   201     -24.867  56.031  99.702  1.00 39.20          
ATOM   1433  CD  GLU   201     -24.389  55.243 100.922  1.00 43.22          
ATOM   1434  OE1 GLU   201     -25.258  54.832 101.738  1.00 53.80          
ATOM   1435  OE2 GLU   201     -23.169  55.029 101.063  1.00 52.75          
ATOM   1436  N   ARG   202     -29.263  57.124  98.812  1.00 35.33          
ATOM   1437  CA  ARG   202     -30.648  56.872  98.838  1.00 36.74          
ATOM   1438  C   ARG   202     -31.375  58.220  99.066  1.00 35.56          
ATOM   1439  O   ARG   202     -30.941  59.096  99.863  1.00 33.01          
ATOM   1440  CB  ARG   202     -30.812  55.747  99.868  1.00 37.01          
ATOM   1441  CG  ARG   202     -32.033  55.649 100.504  1.00 41.58          
ATOM   1442  CD  ARG   202     -32.393  54.222 100.961  1.00 44.19          
ATOM   1443  NE  ARG   202     -33.790  54.214 100.604  1.00 51.61          
ATOM   1444  CZ  ARG   202     -34.354  53.445  99.680  1.00 53.87          
ATOM   1445  NH1 ARG   202     -33.667  52.474  99.107  1.00 53.08          
ATOM   1446  NH2 ARG   202     -35.643  53.650  99.382  1.00 54.17          
ATOM   1447  N   MET   203     -32.410  58.445  98.268  1.00 35.06          
ATOM   1448  CA  MET   203     -33.237  59.655  98.338  1.00 36.49          
ATOM   1449  C   MET   203     -34.712  59.217  98.442  1.00 35.65          
ATOM   1450  O   MET   203     -35.171  58.431  97.596  1.00 35.12          
ATOM   1451  CB  MET   203     -32.997  60.514  97.099  1.00 36.92          
ATOM   1452  CG  MET   203     -33.707  61.863  97.149  1.00 39.75          
ATOM   1453  SD  MET   203     -32.927  63.058  96.018  1.00 44.52          
ATOM   1454  CE  MET   203     -31.454  63.422  96.893  1.00 44.02          
ATOM   1455  N   ASP   204     -35.398  59.621  99.520  1.00 33.79          
ATOM   1456  CA  ASP   204     -36.825  59.358  99.708  1.00 33.72          
ATOM   1457  C   ASP   204     -37.595  60.669  99.917  1.00 31.58          
ATOM   1458  O   ASP   204     -37.242  61.459 100.777  1.00 30.27          
ATOM   1459  CB  ASP   204     -37.065  58.404 100.883  1.00 34.25          
ATOM   1460  CG  ASP   204     -36.547  57.003 100.621  1.00 38.19          
ATOM   1461  OD1 ASP   204     -36.485  56.522  99.453  1.00 45.54          
ATOM   1462  OD2 ASP   204     -36.117  56.381 101.599  1.00 44.01          
ATOM   1463  N   ILE   205     -38.598  60.917  99.096  1.00 30.07          
ATOM   1464  CA  ILE   205     -39.439  62.077  99.234  1.00 32.25          
ATOM   1465  C   ILE   205     -40.881  61.644  99.575  1.00 31.79          
ATOM   1466  O   ILE   205     -41.405  60.683  99.005  1.00 29.36          
ATOM   1467  CB  ILE   205     -39.428  62.922  97.958  1.00 31.53          
ATOM   1468  CG1 ILE   205     -37.980  63.052  97.443  1.00 33.89          
ATOM   1469  CG2 ILE   205     -40.169  64.214  98.168  1.00 30.81          
ATOM   1470  CD  ILE   205     -37.748  64.222  96.567  1.00 35.92          
ATOM   1471  N   GLU   206     -41.468  62.333 100.545  1.00 31.71          
ATOM   1472  CA  GLU   206     -42.830  62.117 100.956  1.00 34.42          
ATOM   1473  C   GLU   206     -43.624  63.386 101.002  1.00 33.23          
ATOM   1474  O   GLU   206     -43.208  64.376 101.627  1.00 30.69          
ATOM   1475  CB  GLU   206     -42.893  61.555 102.357  1.00 35.01          
ATOM   1476  CG  GLU   206     -42.052  60.334 102.595  1.00 39.92          
ATOM   1477  CD  GLU   206     -42.154  59.937 104.049  1.00 43.44          
ATOM   1478  OE1 GLU   206     -43.240  59.389 104.380  1.00 54.62          
ATOM   1479  OE2 GLU   206     -41.209  60.243 104.864  1.00 54.21          
ATOM   1480  N   TRP   207     -44.785  63.335 100.363  1.00 33.45          
ATOM   1481  CA  TRP   207     -45.734  64.396 100.389  1.00 34.27          
ATOM   1482  C   TRP   207     -47.021  63.842 100.992  1.00 34.02          
ATOM   1483  O   TRP   207     -47.497  62.746 100.630  1.00 30.84          
ATOM   1484  CB  TRP   207     -46.087  64.849  99.000  1.00 36.06          
ATOM   1485  CG  TRP   207     -45.039  65.385  98.144  1.00 36.58          
ATOM   1486  CD1 TRP   207     -44.765  66.721  97.912  1.00 38.67          
ATOM   1487  CD2 TRP   207     -44.183  64.647  97.293  1.00 36.99          
ATOM   1488  NE1 TRP   207     -43.761  66.829  96.974  1.00 37.66          
ATOM   1489  CE2 TRP   207     -43.391  65.575  96.581  1.00 37.04          
ATOM   1490  CE3 TRP   207     -43.984  63.287  97.073  1.00 38.87          
ATOM   1491  CZ2 TRP   207     -42.427  65.180  95.670  1.00 39.47          
ATOM   1492  CZ3 TRP   207     -43.029  62.895  96.166  1.00 38.59          
ATOM   1493  CH2 TRP   207     -42.259  63.841  95.471  1.00 39.20          
ATOM   1494  N   ASP   208     -47.602  64.641 101.859  1.00 33.72          
ATOM   1495  CA  ASP   208     -48.759  64.246 102.630  1.00 35.75          
ATOM   1496  C   ASP   208     -49.686  65.456 102.740  1.00 35.71          
ATOM   1497  O   ASP   208     -49.255  66.523 103.125  1.00 34.56          
ATOM   1498  CB  ASP   208     -48.251  63.810 103.996  1.00 36.66          
ATOM   1499  CG  ASP   208     -49.323  63.380 104.886  1.00 42.13          
ATOM   1500  OD1 ASP   208     -50.213  64.195 105.154  1.00 46.05          
ATOM   1501  OD2 ASP   208     -49.269  62.216 105.336  1.00 51.90          
ATOM   1986  N   PHE   278     -44.232  67.727 103.864  1.00 29.97          
ATOM   1987  CA  PHE   278     -43.131  67.386 102.936  1.00 29.85          
ATOM   1988  C   PHE   278     -41.900  66.977 103.736  1.00 28.88          
ATOM   1989  O   PHE   278     -41.505  67.682 104.663  1.00 26.59          
ATOM   1990  CB  PHE   278     -42.810  68.564 101.982  1.00 30.86          
ATOM   1991  CG  PHE   278     -41.583  68.341 101.136  1.00 31.60          
ATOM   1992  CD1 PHE   278     -41.674  67.756  99.897  1.00 33.96          
ATOM   1993  CD2 PHE   278     -40.338  68.724 101.599  1.00 35.17          
ATOM   1994  CE1 PHE   278     -40.596  67.553  99.134  1.00 35.44          
ATOM   1995  CE2 PHE   278     -39.236  68.520 100.841  1.00 35.77          
ATOM   1996  CZ  PHE   278     -39.354  67.930  99.606  1.00 36.45          
ATOM   1997  N   THR   279     -41.319  65.836 103.374  1.00 29.13          
ATOM   1998  CA  THR   279     -40.030  65.397 103.947  1.00 29.88          
ATOM   1999  C   THR   279     -39.158  64.845 102.829  1.00 28.94          
ATOM   2000  O   THR   279     -39.619  64.048 102.020  1.00 29.73          
ATOM   2001  CB  THR   279     -40.200  64.275 105.035  1.00 29.89          
ATOM   2002  OG1 THR   279     -41.270  64.645 105.910  1.00 32.98          
ATOM   2003  CG2 THR   279     -38.874  64.081 105.838  1.00 28.89          
ATOM   2004  N   LEU   280     -37.908  65.296 102.798  1.00 28.65          
ATOM   2005  CA  LEU   280     -36.848  64.751 101.960  1.00 27.94          
ATOM   2006  C   LEU   280     -35.870  64.046 102.878  1.00 27.35          
ATOM   2007  O   LEU   280     -35.268  64.694 103.732  1.00 26.94          
ATOM   2008  CB  LEU   280     -36.160  65.885 101.219  1.00 28.24          
ATOM   2009  CG  LEU   280     -34.887  65.571 100.417  1.00 28.04          
ATOM   2010  CD1 LEU   280     -35.134  64.622  99.280  1.00 26.87          
ATOM   2011  CD2 LEU   280     -34.252  66.943  99.944  1.00 27.88          
ATOM   2012  N   THR   281     -35.773  62.729 102.765  1.00 26.98          
ATOM   2013  CA  THR   281     -34.830  61.905 103.551  1.00 27.57          
ATOM   2014  C   THR   281     -33.679  61.426 102.669  1.00 28.05          
ATOM   2015  O   THR   281     -33.869  60.661 101.715  1.00 28.51          
ATOM   2016  CB  THR   281     -35.556  60.702 104.249  1.00 26.94          
ATOM   2017  OG1 THR   281     -36.714  61.191 104.930  1.00 29.16          
ATOM   2018  CG2 THR   281     -34.693  60.047 105.251  1.00 27.97          
ATOM   2019  N   ILE   282     -32.477  61.946 102.932  1.00 28.26          
ATOM   2020  CA  ILE   282     -31.294  61.542 102.178  1.00 27.99          
ATOM   2021  C   ILE   282     -30.390  60.667 103.028  1.00 28.52          
ATOM   2022  O   ILE   282     -30.105  60.971 104.184  1.00 28.50          
ATOM   2023  CB  ILE   282     -30.538  62.791 101.685  1.00 29.30          
ATOM   2024  CG1 ILE   282     -31.377  63.480 100.610  1.00 29.13          
ATOM   2025  CG2 ILE   282     -29.084  62.417 101.217  1.00 27.60          
ATOM   2026  CD  ILE   282     -30.869  64.805 100.152  1.00 26.29          
ATOM   2027  N   THR   283     -29.920  59.572 102.458  1.00 28.35          
ATOM   2028  CA  THR   283     -28.944  58.758 103.112  1.00 28.25          
ATOM   2029  C   THR   283     -27.553  58.916 102.407  1.00 28.53          
ATOM   2030  O   THR   283     -27.487  58.852 101.159  1.00 27.11          
ATOM   2031  CB  THR   283     -29.413  57.282 103.137  1.00 30.01          
ATOM   2032  OG1 THR   283     -30.737  57.217 103.726  1.00 32.20          
ATOM   2033  CG2 THR   283     -28.440  56.443 103.951  1.00 29.23          
ATOM   2034  N   VAL   284     -26.513  59.176 103.231  1.00 27.77          
ATOM   2035  CA  VAL   284     -25.129  59.372 102.815  1.00 27.52          
ATOM   2036  C   VAL   284     -24.220  58.420 103.541  1.00 27.70          
ATOM   2037  O   VAL   284     -24.543  57.916 104.603  1.00 27.66          
ATOM   2038  CB  VAL   284     -24.605  60.828 102.931  1.00 27.18          
ATOM   2039  CG1 VAL   284     -25.288  61.713 101.924  1.00 26.23          
ATOM   2040  CG2 VAL   284     -24.729  61.376 104.399  1.00 25.21          
ATOM   2041  N   GLY   285     -23.065  58.122 102.931  1.00 28.50          
ATOM   2042  CA  GLY   285     -22.092  57.263 103.593  1.00 27.48          
ATOM   2043  C   GLY   285     -21.322  58.190 104.536  1.00 27.30          
ATOM   2044  O   GLY   285     -21.214  59.353 104.270  1.00 26.80          
ATOM   2045  N   GLY   286     -20.773  57.653 105.613  1.00 28.45          
ATOM   2046  CA  GLY   286     -20.052  58.491 106.623  1.00 28.67          
ATOM   2047  C   GLY   286     -20.988  59.226 107.572  1.00 28.63          
ATOM   2048  O   GLY   286     -22.227  59.073 107.511  1.00 28.51          
ATOM   2049  N   HSD   287     -20.365  60.042 108.423  1.00 27.05          
ATOM   2050  CA  HSD   287     -20.981  60.891 109.403  1.00 27.43          
ATOM   2051  C   HSD   287     -20.611  62.375 109.310  1.00 27.41          
ATOM   2052  O   HSD   287     -21.171  63.187 110.025  1.00 25.65          
ATOM   2053  CB  HSD   287     -20.648  60.394 110.791  1.00 27.49          
ATOM   2054  CG  HSD   287     -21.227  59.040 111.078  1.00 27.55          
ATOM   2055  ND1 HSD   287     -20.674  58.181 111.997  1.00 29.74          
ATOM   2056  CD2 HSD   287     -22.255  58.372 110.512  1.00 22.71          
ATOM   2057  CE1 HSD   287     -21.355  57.051 112.002  1.00 25.84          
ATOM   2058  NE2 HSD   287     -22.349  57.169 111.150  1.00 29.06          
ATOM   2059  N   LYS   288     -19.687  62.715 108.399  1.00 27.09          
ATOM   2060  CA  LYS   288     -19.182  64.091 108.249  1.00 28.28          
ATOM   2061  C   LYS   288     -19.341  64.596 106.839  1.00 28.54          
ATOM   2062  O   LYS   288     -19.268  63.842 105.912  1.00 27.15          
ATOM   2063  CB  LYS   288     -17.711  64.148 108.580  1.00 28.31          
ATOM   2064  CG  LYS   288     -17.482  64.065 110.045  1.00 29.49          
ATOM   2065  CD  LYS   288     -16.028  63.787 110.393  1.00 27.50          
ATOM   2066  CE  LYS   288     -15.835  64.015 111.891  1.00 33.09          
ATOM   2067  NZ  LYS   288     -14.442  63.696 112.446  1.00 34.10          
ATOM   2068  N   THR   289     -19.581  65.881 106.712  1.00 29.27          
ATOM   2069  CA  THR   289     -19.378  66.545 105.444  1.00 31.36          
ATOM   2070  C   THR   289     -17.907  66.474 104.978  1.00 31.99          
ATOM   2071  O   THR   289     -16.995  66.195 105.738  1.00 29.46          
ATOM   2072  CB  THR   289     -19.706  68.009 105.523  1.00 30.73          
ATOM   2073  OG1 THR   289     -18.689  68.686 106.307  1.00 31.58          
ATOM   2074  CG2 THR   289     -21.094  68.232 106.118  1.00 29.24          
ATOM   2075  N   ARG   290     -17.707  66.782 103.710  1.00 34.33          
ATOM   2076  CA  ARG   290     -16.376  66.870 103.141  1.00 36.15          
ATOM   2077  C   ARG   290     -15.428  67.800 103.923  1.00 34.26          
ATOM   2078  O   ARG   290     -14.235  67.566 103.966  1.00 34.54          
ATOM   2079  CB  ARG   290     -16.448  67.338 101.672  1.00 36.83          
ATOM   2080  CG  ARG   290     -16.516  66.210 100.721  1.00 41.51          
ATOM   2081  CD  ARG   290     -15.766  66.494  99.381  1.00 44.35          
ATOM   2082  NE  ARG   290     -14.337  66.102  99.398  1.00 49.74          
ATOM   2083  CZ  ARG   290     -13.877  64.851  99.565  1.00 50.49          
ATOM   2084  NH1 ARG   290     -14.687  63.812  99.732  1.00 50.61          
ATOM   2085  NH2 ARG   290     -12.570  64.643  99.576  1.00 51.73          
ATOM   2086  N   ASP   291     -15.950  68.849 104.524  1.00 35.06          
ATOM   2087  CA  ASP   291     -15.120  69.743 105.332  1.00 34.69          
ATOM   2088  C   ASP   291     -15.156  69.418 106.824  1.00 32.97          
ATOM   2089  O   ASP   291     -14.829  70.236 107.668  1.00 31.73          
ATOM   2090  CB  ASP   291     -15.447  71.213 105.065  1.00 37.42          
ATOM   2091  CG  ASP   291     -16.851  71.605 105.481  1.00 41.86          
ATOM   2092  OD1 ASP   291     -17.753  70.737 105.381  1.00 49.06          
ATOM   2093  OD2 ASP   291     -17.046  72.808 105.864  1.00 52.37          
ATOM   2094  N   GLY   292     -15.506  68.184 107.138  1.00 31.58          
ATOM   2095  CA  GLY   292     -15.250  67.651 108.463  1.00 30.82          
ATOM   2096  C   GLY   292     -16.274  67.970 109.501  1.00 29.28          
ATOM   2097  O   GLY   292     -16.005  67.779 110.682  1.00 30.25          
ATOM   2098  N   VAL   293     -17.458  68.407 109.081  1.00 28.07          
ATOM   2099  CA  VAL   293     -18.544  68.792 110.042  1.00 27.94          
ATOM   2100  C   VAL   293     -19.473  67.564 110.237  1.00 27.88          
ATOM   2101  O   VAL   293     -19.977  67.000 109.260  1.00 26.91          
ATOM   2102  CB  VAL   293     -19.334  70.049 109.554  1.00 27.16          
ATOM   2103  CG1 VAL   293     -20.512  70.380 110.444  1.00 29.73          
ATOM   2104  CG2 VAL   293     -18.400  71.332 109.430  1.00 25.68          
ATOM   2105  N   LEU   294     -19.631  67.142 111.488  1.00 27.74          
ATOM   2106  CA  LEU   294     -20.627  66.165 111.872  1.00 28.34          
ATOM   2107  C   LEU   294     -22.043  66.651 111.540  1.00 27.68          
ATOM   2108  O   LEU   294     -22.419  67.700 111.943  1.00 27.48          
ATOM   2109  CB  LEU   294     -20.495  65.828 113.346  1.00 28.03          
ATOM   2110  CG  LEU   294     -19.292  64.972 113.670  1.00 27.38          
ATOM   2111  CD1 LEU   294     -18.883  65.064 115.125  1.00 28.60          
ATOM   2112  CD2 LEU   294     -19.489  63.510 113.253  1.00 23.72          
ATOM   2113  N   TRP   295     -22.797  65.843 110.785  1.00 27.86          
ATOM   2114  CA  TRP   295     -24.190  66.150 110.484  1.00 27.00          
ATOM   2115  C   TRP   295     -24.928  66.343 111.815  1.00 26.62          
ATOM   2116  O   TRP   295     -24.754  65.574 112.744  1.00 26.26          
ATOM   2117  CB  TRP   295     -24.850  65.030 109.661  1.00 26.18          
ATOM   2118  CG  TRP   295     -24.240  64.761 108.355  1.00 24.81          
ATOM   2119  CD1 TRP   295     -23.524  63.664 108.013  1.00 24.24          
ATOM   2120  CD2 TRP   295     -24.322  65.560 107.176  1.00 24.47          
ATOM   2121  NE1 TRP   295     -23.161  63.718 106.719  1.00 23.32          
ATOM   2122  CE2 TRP   295     -23.596  64.892 106.182  1.00 23.56          
ATOM   2123  CE3 TRP   295     -24.886  66.801 106.879  1.00 24.38          
ATOM   2124  CZ2 TRP   295     -23.457  65.402 104.897  1.00 26.34          
ATOM   2125  CZ3 TRP   295     -24.729  67.302 105.630  1.00 24.09          
ATOM   2126  CH2 TRP   295     -24.053  66.611 104.650  1.00 23.43          
ATOM   2127  N   GLN   296     -25.732  67.382 111.877  1.00 27.94          
ATOM   2128  CA  GLN   296     -26.394  67.809 113.101  1.00 28.07          
ATOM   2129  C   GLN   296     -27.589  68.637 112.714  1.00 27.15          
ATOM   2130  O   GLN   296     -27.485  69.522 111.831  1.00 25.99          
ATOM   2131  CB  GLN   296     -25.424  68.685 113.909  1.00 28.21          
ATOM   2132  CG  GLN   296     -25.901  69.065 115.309  1.00 31.26          
ATOM   2133  CD  GLN   296     -25.962  67.866 116.251  1.00 34.70          
ATOM   2134  OE1 GLN   296     -26.783  67.869 117.178  1.00 42.16          
ATOM   2135  NE2 GLN   296     -25.100  66.864 116.047  1.00 28.46          
ATOM   2136  N   PRO   297     -28.737  68.429 113.401  1.00 27.66          
ATOM   2137  CA  PRO   297     -29.902  69.299 113.063  1.00 27.27          
ATOM   2138  C   PRO   297     -29.571  70.770 113.176  1.00 28.02          
ATOM   2139  O   PRO   297     -28.839  71.123 114.091  1.00 27.83          
ATOM   2140  CB  PRO   297     -30.955  68.861 114.094  1.00 26.50          
ATOM   2141  CG  PRO   297     -30.580  67.428 114.391  1.00 27.15          
ATOM   2142  CD  PRO   297     -29.088  67.450 114.439  1.00 26.81          
ATOM   2143  N   GLY   298     -30.138  71.632 112.290  1.00 28.48          
ATOM   2144  CA  GLY   298     -29.842  73.063 112.316  1.00 28.98          
ATOM   2145  C   GLY   298     -28.965  73.517 111.177  1.00 29.95          
ATOM   2146  O   GLY   298     -28.945  74.704 110.849  1.00 30.26          
ATOM   2147  N   LEU   299     -28.287  72.568 110.545  1.00 29.32          
ATOM   2148  CA  LEU   299     -27.580  72.790 109.278  1.00 29.82          
ATOM   2149  C   LEU   299     -28.525  72.928 108.074  1.00 30.18          
ATOM   2150  O   LEU   299     -29.651  72.407 108.070  1.00 29.93          
ATOM   2151  CB  LEU   299     -26.576  71.670 109.013  1.00 29.91          
ATOM   2152  CG  LEU   299     -25.544  71.437 110.100  1.00 31.22          
ATOM   2153  CD1 LEU   299     -24.701  70.271 109.783  1.00 33.49          
ATOM   2154  CD2 LEU   299     -24.694  72.774 110.279  1.00 31.74          
ATOM   2155  N   ARG   300     -28.076  73.683 107.078  1.00 29.74          
ATOM   2156  CA  ARG   300     -28.787  73.793 105.801  1.00 30.00          
ATOM   2157  C   ARG   300     -27.935  73.097 104.762  1.00 30.26          
ATOM   2158  O   ARG   300     -26.710  73.131 104.850  1.00 30.99          
ATOM   2159  CB  ARG   300     -29.087  75.237 105.459  1.00 29.99          
ATOM   2160  CG  ARG   300     -30.101  75.821 106.436  1.00 29.81          
ATOM   2161  CD  ARG   300     -30.160  77.287 106.399  1.00 31.28          
ATOM   2162  NE  ARG   300     -30.760  77.855 105.191  1.00 31.51          
ATOM   2163  CZ  ARG   300     -30.112  78.549 104.268  1.00 33.58          
ATOM   2164  NH1 ARG   300     -28.804  78.768 104.363  1.00 35.88          
ATOM   2165  NH2 ARG   300     -30.778  79.032 103.225  1.00 35.91          
ATOM   2166  N   VAL   301     -28.597  72.384 103.842  1.00 29.67          
ATOM   2167  CA  VAL   301     -27.965  71.520 102.888  1.00 29.94          
ATOM   2168  C   VAL   301     -28.510  71.838 101.487  1.00 31.58          
ATOM   2169  O   VAL   301     -29.742  71.867 101.253  1.00 30.80          
ATOM   2170  CB  VAL   301     -28.170  69.987 103.235  1.00 30.65          
ATOM   2171  CG1 VAL   301     -27.373  69.136 102.266  1.00 28.33          
ATOM   2172  CG2 VAL   301     -27.760  69.673 104.681  1.00 27.26          
ATOM   2173  N   HSD   302     -27.595  72.164 100.578  1.00 31.55          
ATOM   2174  CA  HSD   302     -27.953  72.353  99.192  1.00 32.23          
ATOM   2175  C   HSD   302     -28.041  70.986  98.526  1.00 31.37          
ATOM   2176  O   HSD   302     -27.097  70.171  98.589  1.00 32.13          
ATOM   2177  CB  HSD   302     -26.911  73.261  98.510  1.00 32.95          
ATOM   2178  CG  HSD   302     -27.172  73.505  97.064  1.00 34.06          
ATOM   2179  ND1 HSD   302     -26.161  73.702  96.154  1.00 36.79          
ATOM   2180  CD2 HSD   302     -28.328  73.609  96.370  1.00 38.85          
ATOM   2181  CE1 HSD   302     -26.683  73.944  94.965  1.00 39.09          
ATOM   2182  NE2 HSD   302     -27.997  73.893  95.070  1.00 39.37          
ATOM   2183  N   VAL   303     -29.190  70.682  97.941  1.00 31.02          
ATOM   2184  CA  VAL   303     -29.392  69.379  97.270  1.00 31.30          
ATOM   2185  C   VAL   303     -29.617  69.543  95.778  1.00 31.14          
ATOM   2186  O   VAL   303     -30.439  70.371  95.364  1.00 29.83          
ATOM   2187  CB  VAL   303     -30.597  68.590  97.893  1.00 31.25          
ATOM   2188  CG1 VAL   303     -30.845  67.231  97.161  1.00 29.14          
ATOM   2189  CG2 VAL   303     -30.376  68.361  99.395  1.00 31.18          
ATOM   2190  N   ILE   304     -28.879  68.751  94.983  1.00 32.99          
ATOM   2191  CA  ILE   304     -29.075  68.689  93.526  1.00 34.53          
ATOM   2192  C   ILE   304     -29.426  67.272  93.051  1.00 35.26          
ATOM   2193  O   ILE   304     -28.724  66.287  93.318  1.00 36.52          
ATOM   2194  CB  ILE   304     -27.875  69.275  92.715  1.00 34.55          
ATOM   2195  CG1 ILE   304     -27.548  70.683  93.194  1.00 33.97          
ATOM   2196  CG2 ILE   304     -28.177  69.298  91.168  1.00 33.99          
ATOM   2197  CD  ILE   304     -26.141  71.130  92.758  1.00 35.10          
ATOM   2198  N   ASP   305     -30.547  67.175  92.363  1.00 36.86          
ATOM   2199  CA  ASP   305     -30.912  65.944  91.672  1.00 38.59          
ATOM   2200  C   ASP   305     -31.396  66.361  90.294  1.00 39.68          
ATOM   2201  O   ASP   305     -32.540  66.759  90.137  1.00 39.11          
ATOM   2202  CB  ASP   305     -32.010  65.218  92.446  1.00 39.04          
ATOM   2203  CG  ASP   305     -32.369  63.887  91.851  1.00 39.30          
ATOM   2204  OD1 ASP   305     -32.053  63.644  90.662  1.00 41.42          
ATOM   2205  OD2 ASP   305     -32.920  63.040  92.607  1.00 41.17          
ATOM   2206  N   ASP   306     -30.504  66.294  89.313  1.00 41.83          
ATOM   2207  CA  ASP   306     -30.861  66.621  87.920  1.00 43.37          
ATOM   2208  C   ASP   306     -31.980  65.740  87.364  1.00 44.42          
ATOM   2209  O   ASP   306     -32.884  66.248  86.717  1.00 45.02          
ATOM   2210  CB  ASP   306     -29.629  66.563  87.009  1.00 43.68          
ATOM   2211  CG  ASP   306     -28.715  67.805  87.158  1.00 44.12          
ATOM   2212  OD1 ASP   306     -29.036  68.735  87.901  1.00 39.27          
ATOM   2213  OD2 ASP   306     -27.656  67.843  86.500  1.00 49.45          
ATOM   2214  N   GLU   307     -31.932  64.436  87.625  1.00 46.06          
ATOM   2215  CA  GLU   307     -33.020  63.511  87.214  1.00 46.63          
ATOM   2216  C   GLU   307     -34.388  64.037  87.632  1.00 46.84          
ATOM   2217  O   GLU   307     -35.303  64.096  86.826  1.00 48.14          
ATOM   2218  CB  GLU   307     -32.851  62.113  87.825  1.00 46.92          
ATOM   2219  CG  GLU   307     -31.954  61.219  87.078  1.00 48.32          
ATOM   2220  CD  GLU   307     -31.621  59.902  87.826  1.00 49.07          
ATOM   2221  OE1 GLU   307     -32.459  59.383  88.610  1.00 49.61          
ATOM   2222  OE2 GLU   307     -30.481  59.413  87.621  1.00 50.52          
ATOM   2223  N   HSD   308     -34.506  64.435  88.885  1.00 46.50          
ATOM   2224  CA  HSD   308     -35.770  64.891  89.475  1.00 45.69          
ATOM   2225  C   HSD   308     -36.055  66.399  89.261  1.00 44.73          
ATOM   2226  O   HSD   308     -37.128  66.893  89.570  1.00 45.68          
ATOM   2227  CB  HSD   308     -35.693  64.610  90.978  1.00 46.96          
ATOM   2228  CG  HSD   308     -37.015  64.369  91.642  1.00 48.22          
ATOM   2229  ND1 HSD   308     -37.372  63.135  92.132  1.00 46.81          
ATOM   2230  CD2 HSD   308     -38.050  65.200  91.921  1.00 51.58          
ATOM   2231  CE1 HSD   308     -38.576  63.207  92.672  1.00 50.47          
ATOM   2232  NE2 HSD   308     -39.008  64.450  92.566  1.00 52.30          
ATOM   2233  N   GLY   309     -35.081  67.155  88.787  1.00 43.53          
ATOM   2234  CA  GLY   309     -35.238  68.599  88.696  1.00 41.90          
ATOM   2235  C   GLY   309     -35.137  69.324  90.015  1.00 40.82          
ATOM   2236  O   GLY   309     -35.636  70.416  90.140  1.00 40.47          
ATOM   2237  N   ILE   310     -34.507  68.736  91.030  1.00 39.55          
ATOM   2238  CA  ILE   310     -34.294  69.474  92.294  1.00 38.03          
ATOM   2239  C   ILE   310     -32.953  70.205  92.296  1.00 36.50          
ATOM   2240  O   ILE   310     -31.926  69.643  91.960  1.00 36.80          
ATOM   2241  CB  ILE   310     -34.327  68.554  93.528  1.00 38.13          
ATOM   2242  CG1 ILE   310     -35.665  67.822  93.620  1.00 38.45          
ATOM   2243  CG2 ILE   310     -34.037  69.346  94.840  1.00 37.69          
ATOM   2244  CD  ILE   310     -35.661  66.720  94.675  1.00 38.86          
ATOM   2245  N   ASP   311     -32.982  71.459  92.695  1.00 36.19          
ATOM   2246  CA  ASP   311     -31.784  72.229  92.992  1.00 35.53          
ATOM   2247  C   ASP   311     -32.228  73.311  93.968  1.00 34.23          
ATOM   2248  O   ASP   311     -32.729  74.342  93.564  1.00 34.17          
ATOM   2249  CB  ASP   311     -31.195  72.861  91.721  1.00 36.57          
ATOM   2250  CG  ASP   311     -29.932  73.652  92.003  1.00 37.77          
ATOM   2251  OD1 ASP   311     -29.750  74.082  93.157  1.00 41.17          
ATOM   2252  OD2 ASP   311     -29.120  73.854  91.083  1.00 41.09          
ATOM   2253  N   ALA   312     -32.077  73.039  95.266  1.00 32.86          
ATOM   2254  CA  ALA   312     -32.591  73.906  96.334  1.00 31.34          
ATOM   2255  C   ALA   312     -31.880  73.626  97.636  1.00 29.67          
ATOM   2256  O   ALA   312     -31.139  72.635  97.768  1.00 28.28          
ATOM   2257  CB  ALA   312     -34.099  73.678  96.502  1.00 31.36          
ATOM   2258  N   VAL   313     -32.083  74.523  98.585  1.00 28.02          
ATOM   2259  CA  VAL   313     -31.544  74.401  99.912  1.00 28.82          
ATOM   2260  C   VAL   313     -32.698  73.925 100.822  1.00 28.68          
ATOM   2261  O   VAL   313     -33.871  74.367 100.695  1.00 28.96          
ATOM   2262  CB  VAL   313     -30.955  75.736 100.457  1.00 28.82          
ATOM   2263  CG1 VAL   313     -30.481  75.593 101.921  1.00 26.37          
ATOM   2264  CG2 VAL   313     -29.835  76.244  99.558  1.00 29.71          
ATOM   2265  N   PHE   314     -32.336  72.991 101.688  1.00 28.23          
ATOM   2266  CA  PHE   314     -33.210  72.398 102.670  1.00 28.36          
ATOM   2267  C   PHE   314     -32.578  72.530 104.059  1.00 27.88          
ATOM   2268  O   PHE   314     -31.347  72.653 104.212  1.00 25.11          
ATOM   2269  CB  PHE   314     -33.504  70.927 102.340  1.00 28.86          
ATOM   2270  CG  PHE   314     -34.160  70.730 101.007  1.00 28.05          
ATOM   2271  CD1 PHE   314     -35.539  70.778 100.879  1.00 30.97          
ATOM   2272  CD2 PHE   314     -33.393  70.531  99.867  1.00 30.10          
ATOM   2273  CE1 PHE   314     -36.154  70.626  99.629  1.00 30.35          
ATOM   2274  CE2 PHE   314     -33.983  70.396  98.609  1.00 29.99          
ATOM   2275  CZ  PHE   314     -35.380  70.424  98.490  1.00 31.51          
ATOM   2276  N   PHE   315     -33.472  72.511 105.043  1.00 27.86          
ATOM   2277  CA  PHE   315     -33.162  72.638 106.456  1.00 28.00          
ATOM   2278  C   PHE   315     -33.187  71.267 107.149  1.00 27.73          
ATOM   2279  O   PHE   315     -34.153  70.484 107.023  1.00 27.25          
ATOM   2280  CB  PHE   315     -34.169  73.541 107.118  1.00 29.50          
ATOM   2281  CG  PHE   315     -33.904  73.754 108.569  1.00 29.11          
ATOM   2282  CD1 PHE   315     -32.784  74.466 108.970  1.00 31.00          
ATOM   2283  CD2 PHE   315     -34.763  73.228 109.550  1.00 30.26          
ATOM   2284  CE1 PHE   315     -32.508  74.658 110.337  1.00 31.48          
ATOM   2285  CE2 PHE   315     -34.494  73.412 110.921  1.00 31.50          
ATOM   2286  CZ  PHE   315     -33.364  74.131 111.315  1.00 31.75          
ATOM   2287  N   LEU   316     -32.094  70.954 107.819  1.00 26.56          
ATOM   2288  CA  LEU   316     -31.927  69.665 108.457  1.00 27.23          
ATOM   2289  C   LEU   316     -32.578  69.627 109.844  1.00 26.15          
ATOM   2290  O   LEU   316     -32.131  70.251 110.769  1.00 25.64          
ATOM   2291  CB  LEU   316     -30.453  69.256 108.513  1.00 26.93          
ATOM   2292  CG  LEU   316     -30.104  67.879 109.059  1.00 26.08          
ATOM   2293  CD1 LEU   316     -30.642  66.778 108.102  1.00 23.97          
ATOM   2294  CD2 LEU   316     -28.545  67.755 109.257  1.00 27.60          
ATOM   2295  N   MET   317     -33.631  68.849 109.953  1.00 26.52          
ATOM   2296  CA  MET   317     -34.509  68.886 111.144  1.00 27.18          
ATOM   2297  C   MET   317     -34.206  67.698 112.034  1.00 26.56          
ATOM   2298  O   MET   317     -34.477  67.716 113.208  1.00 27.44          
ATOM   2299  CB  MET   317     -35.985  68.866 110.644  1.00 26.65          
ATOM   2300  CG  MET   317     -37.036  69.047 111.657  1.00 28.87          
ATOM   2301  SD  MET   317     -37.310  70.752 112.300  1.00 30.49          
ATOM   2302  CE  MET   317     -38.016  71.356 110.728  1.00 18.25          
ATOM   2303  N   GLY   318     -33.698  66.636 111.429  1.00 26.90          
ATOM   2304  CA  GLY   318     -33.388  65.387 112.094  1.00 26.18          
ATOM   2305  C   GLY   318     -32.274  64.639 111.409  1.00 26.53          
ATOM   2306  O   GLY   318     -32.060  64.784 110.203  1.00 26.69          
ATOM   2307  N   ARG   319     -31.488  63.908 112.200  1.00 26.53          
ATOM   2308  CA  ARG   319     -30.439  63.125 111.656  1.00 27.48          
ATOM   2309  C   ARG   319     -30.087  61.915 112.481  1.00 25.89          
ATOM   2310  O   ARG   319     -30.086  61.949 113.702  1.00 23.49          
ATOM   2311  CB  ARG   319     -29.191  63.966 111.332  1.00 29.26          
ATOM   2312  CG  ARG   319     -28.339  64.329 112.436  1.00 31.52          
ATOM   2313  CD  ARG   319     -27.234  63.287 112.766  1.00 28.69          
ATOM   2314  NE  ARG   319     -26.663  63.845 113.964  1.00 28.97          
ATOM   2315  CZ  ARG   319     -26.998  63.607 115.223  1.00 30.63          
ATOM   2316  NH1 ARG   319     -27.849  62.686 115.593  1.00 29.46          
ATOM   2317  NH2 ARG   319     -26.407  64.318 116.140  1.00 32.35          
ATOM   2318  N   ARG   320     -29.768  60.849 111.769  1.00 25.95          
ATOM   2319  CA  ARG   320     -29.462  59.573 112.392  1.00 27.46          
ATOM   2320  C   ARG   320     -28.137  59.026 111.876  1.00 25.46          
ATOM   2321  O   ARG   320     -28.006  58.699 110.712  1.00 26.34          
ATOM   2322  CB  ARG   320     -30.667  58.667 112.130  1.00 27.26          
ATOM   2323  CG  ARG   320     -30.732  57.249 112.672  1.00 30.05          
ATOM   2324  CD  ARG   320     -32.104  56.684 112.171  1.00 32.80          
ATOM   2325  NE  ARG   320     -32.068  55.263 112.197  1.00 42.05          
ATOM   2326  CZ  ARG   320     -32.670  54.429 111.331  1.00 44.78          
ATOM   2327  NH1 ARG   320     -33.468  54.858 110.328  1.00 43.92          
ATOM   2328  NH2 ARG   320     -32.433  53.119 111.479  1.00 45.28          
ATOM   2329  N   PHE   321     -27.153  58.973 112.781  1.00 25.95          
ATOM   2330  CA  PHE   321     -25.919  58.238 112.603  1.00 26.17          
ATOM   2331  C   PHE   321     -26.193  56.736 112.784  1.00 25.98          
ATOM   2332  O   PHE   321     -26.776  56.299 113.783  1.00 25.53          
ATOM   2333  CB  PHE   321     -24.814  58.646 113.611  1.00 25.45          
ATOM   2334  CG  PHE   321     -24.414  60.097 113.578  1.00 25.54          
ATOM   2335  CD1 PHE   321     -24.066  60.740 112.390  1.00 27.58          
ATOM   2336  CD2 PHE   321     -24.296  60.810 114.783  1.00 23.16          
ATOM   2337  CE1 PHE   321     -23.631  62.108 112.393  1.00 26.07          
ATOM   2338  CE2 PHE   321     -23.854  62.185 114.804  1.00 23.26          
ATOM   2339  CZ  PHE   321     -23.514  62.816 113.641  1.00 26.64          
ATOM   2340  N   MET   322     -25.774  55.966 111.798  1.00 26.25          
ATOM   2341  CA  MET   322     -26.041  54.567 111.723  1.00 27.37          
ATOM   2342  C   MET   322     -24.771  53.760 111.370  1.00 27.69          
ATOM   2343  O   MET   322     -23.949  54.191 110.581  1.00 27.81          
ATOM   2344  CB  MET   322     -27.102  54.307 110.643  1.00 28.03          
ATOM   2345  CG  MET   322     -28.421  55.129 110.764  1.00 29.05          
ATOM   2346  SD  MET   322     -29.690  54.593 109.525  1.00 25.30          
ATOM   2347  CE  MET   322     -28.936  55.213 108.051  1.00 33.90          
ATOM   2348  N   LEU   323     -24.636  52.604 111.986  1.00 29.16          
ATOM   2349  CA  LEU   323     -23.704  51.561 111.585  1.00 30.37          
ATOM   2350  C   LEU   323     -24.494  50.263 111.521  1.00 31.48          
ATOM   2351  O   LEU   323     -25.209  49.953 112.455  1.00 30.81          
ATOM   2352  CB  LEU   323     -22.581  51.358 112.627  1.00 29.30          
ATOM   2353  CG  LEU   323     -21.548  50.201 112.523  1.00 30.50          
ATOM   2354  CD1 LEU   323     -20.688  50.282 111.259  1.00 29.94          
ATOM   2355  CD2 LEU   323     -20.709  50.162 113.803  1.00 30.63          
ATOM   2356  N   SER   324     -24.311  49.517 110.437  1.00 34.25          
ATOM   2357  CA  SER   324     -24.772  48.149 110.311  1.00 36.55          
ATOM   2358  C   SER   324     -23.718  47.306 109.635  1.00 38.49          
ATOM   2359  O   SER   324     -22.856  47.820 108.900  1.00 37.33          
ATOM   2360  CB  SER   324     -26.073  48.052 109.500  1.00 36.41          
ATOM   2361  OG  SER   324     -26.003  48.606 108.193  1.00 37.53          
ATOM   2362  N   ARG   325     -23.817  45.991 109.836  1.00 41.39          
ATOM   2363  CA  ARG   325     -22.961  45.056 109.107  1.00 44.37          
ATOM   2364  C   ARG   325     -23.240  45.135 107.625  1.00 43.29          
ATOM   2365  O   ARG   325     -22.331  45.208 106.836  1.00 42.12          
ATOM   2366  CB  ARG   325     -23.107  43.626 109.649  1.00 45.90          
ATOM   2367  CG  ARG   325     -22.863  43.542 111.173  1.00 53.21          
ATOM   2368  CD  ARG   325     -22.187  42.208 111.598  1.00 53.91          
ATOM   2369  NE  ARG   325     -23.071  41.029 111.469  1.00 62.03          
ATOM   2370  CZ  ARG   325     -22.931  39.876 112.158  1.00 63.91          
ATOM   2371  NH1 ARG   325     -21.924  39.715 113.053  1.00 66.67          
ATOM   2372  NH2 ARG   325     -23.799  38.861 111.959  1.00 63.87          
ATOM   2373  N   MET   326     -24.498  45.251 107.248  1.00 45.04          
ATOM   2374  CA  MET   326     -24.861  45.250 105.840  1.00 46.01          
ATOM   2375  C   MET   326     -24.425  46.521 105.112  1.00 45.33          
ATOM   2376  O   MET   326     -23.883  46.456 104.011  1.00 45.58          
ATOM   2377  CB  MET   326     -26.355  45.052 105.736  1.00 46.15          
ATOM   2378  CG  MET   326     -26.926  45.005 104.335  1.00 48.67          
ATOM   2379  SD  MET   326     -28.784  44.864 104.408  1.00 59.00          
ATOM   2380  CE  MET   326     -29.006  43.220 105.199  1.00 54.55          
ATOM   2381  N   ASP   327     -24.648  47.691 105.727  1.00 43.58          
ATOM   2382  CA  ASP   327     -24.444  48.960 105.053  1.00 41.92          
ATOM   2383  C   ASP   327     -23.271  49.783 105.600  1.00 39.90          
ATOM   2384  O   ASP   327     -23.055  50.844 105.125  1.00 38.73          
ATOM   2385  CB  ASP   327     -25.743  49.770 105.101  1.00 43.60          
ATOM   2386  CG  ASP   327     -26.897  49.069 104.373  1.00 47.01          
ATOM   2387  OD1 ASP   327     -26.747  48.871 103.140  1.00 53.14          
ATOM   2388  OD2 ASP   327     -27.929  48.737 105.018  1.00 49.09          
ATOM   2389  N   GLY   328     -22.502  49.294 106.576  1.00 37.36          
ATOM   2390  CA  GLY   328     -21.478  50.120 107.211  1.00 35.33          
ATOM   2391  C   GLY   328     -21.996  51.428 107.832  1.00 33.43          
ATOM   2392  O   GLY   328     -23.103  51.501 108.378  1.00 31.05          
ATOM   2393  N   THR   329     -21.193  52.463 107.677  1.00 32.02          
ATOM   2394  CA  THR   329     -21.377  53.777 108.304  1.00 32.08          
ATOM   2395  C   THR   329     -22.156  54.718 107.393  1.00 29.60          
ATOM   2396  O   THR   329     -21.749  54.987 106.300  1.00 29.57          
ATOM   2397  CB  THR   329     -19.941  54.349 108.685  1.00 33.33          
ATOM   2398  OG1 THR   329     -19.356  53.495 109.686  1.00 37.14          
ATOM   2399  CG2 THR   329     -20.064  55.685 109.294  1.00 32.75          
ATOM   2400  N   GLN   330     -23.290  55.212 107.861  1.00 27.24          
ATOM   2401  CA  GLN   330     -24.115  56.162 107.141  1.00 28.40          
ATOM   2402  C   GLN   330     -24.778  57.184 108.051  1.00 26.45          
ATOM   2403  O   GLN   330     -24.765  57.039 109.248  1.00 27.37          
ATOM   2404  CB  GLN   330     -25.236  55.377 106.379  1.00 27.36          
ATOM   2405  CG  GLN   330     -24.705  54.330 105.296  1.00 29.28          
ATOM   2406  CD  GLN   330     -25.879  53.471 104.875  1.00 30.47          
ATOM   2407  OE1 GLN   330     -26.532  52.873 105.734  1.00 32.29          
ATOM   2408  NE2 GLN   330     -26.155  53.412 103.595  1.00 32.09          
ATOM   2409  N   THR   331     -25.367  58.197 107.423  1.00 26.86          
ATOM   2410  CA  THR   331     -26.176  59.167 108.065  1.00 26.44          
ATOM   2411  C   THR   331     -27.478  59.298 107.261  1.00 26.36          
ATOM   2412  O   THR   331     -27.473  59.472 106.026  1.00 25.85          
ATOM   2413  CB  THR   331     -25.460  60.569 108.297  1.00 27.19          
ATOM   2414  OG1 THR   331     -24.123  60.351 108.772  1.00 26.59          
ATOM   2415  CG2 THR   331     -26.265  61.450 109.346  1.00 25.13          
ATOM   2416  N   GLU   332     -28.593  59.206 107.985  1.00 27.15          
ATOM   2417  CA  GLU   332     -29.890  59.632 107.439  1.00 27.00          
ATOM   2418  C   GLU   332     -30.138  61.041 107.790  1.00 25.55          
ATOM   2419  O   GLU   332     -30.030  61.475 108.985  1.00 25.90          
ATOM   2420  CB  GLU   332     -30.981  58.714 108.001  1.00 26.91          
ATOM   2421  CG  GLU   332     -32.407  59.197 107.781  1.00 30.28          
ATOM   2422  CD  GLU   332     -33.422  58.260 108.516  1.00 31.82          
ATOM   2423  OE1 GLU   332     -33.332  57.039 108.199  1.00 34.04          
ATOM   2424  OE2 GLU   332     -34.230  58.778 109.364  1.00 29.45          
ATOM   2425  N   LEU   333     -30.458  61.807 106.764  1.00 26.16          
ATOM   2426  CA  LEU   333     -30.669  63.245 106.869  1.00 25.45          
ATOM   2427  C   LEU   333     -32.142  63.558 106.568  1.00 25.97          
ATOM   2428  O   LEU   333     -32.609  63.312 105.450  1.00 25.31          
ATOM   2429  CB  LEU   333     -29.735  64.003 105.918  1.00 26.04          
ATOM   2430  CG  LEU   333     -28.216  63.664 105.968  1.00 28.28          
ATOM   2431  CD1 LEU   333     -27.537  64.304 104.761  1.00 28.25          
ATOM   2432  CD2 LEU   333     -27.599  64.120 107.294  1.00 25.31          
ATOM   2433  N   ARG   334     -32.879  63.998 107.580  1.00 24.76          
ATOM   2434  CA  ARG   334     -34.312  64.296 107.431  1.00 26.24          
ATOM   2435  C   ARG   334     -34.426  65.784 107.201  1.00 25.60          
ATOM   2436  O   ARG   334     -34.272  66.582 108.096  1.00 25.70          
ATOM   2437  CB  ARG   334     -35.123  63.845 108.656  1.00 25.66          
ATOM   2438  CG  ARG   334     -34.933  62.334 108.879  1.00 28.60          
ATOM   2439  CD  ARG   334     -35.934  61.765 109.906  1.00 28.59          
ATOM   2440  NE  ARG   334     -35.692  62.275 111.246  1.00 25.52          
ATOM   2441  CZ  ARG   334     -34.930  61.682 112.153  1.00 28.97          
ATOM   2442  NH1 ARG   334     -34.268  60.556 111.883  1.00 29.98          
ATOM   2443  NH2 ARG   334     -34.781  62.243 113.327  1.00 28.01          
ATOM   2444  N   LEU   335     -34.668  66.123 105.948  1.00 26.43          
ATOM   2445  CA  LEU   335     -34.630  67.471 105.445  1.00 25.73          
ATOM   2446  C   LEU   335     -36.032  68.035 105.186  1.00 26.18          
ATOM   2447  O   LEU   335     -36.964  67.326 104.763  1.00 25.40          
ATOM   2448  CB  LEU   335     -33.773  67.485 104.196  1.00 25.62          
ATOM   2449  CG  LEU   335     -32.282  67.259 104.403  1.00 24.59          
ATOM   2450  CD1 LEU   335     -31.615  66.794 103.122  1.00 25.01          
ATOM   2451  CD2 LEU   335     -31.619  68.563 104.978  1.00 20.46          
ATOM   2452  N   LYS   336     -36.178  69.327 105.452  1.00 27.14          
ATOM   2453  CA  LYS   336     -37.434  70.021 105.342  1.00 27.45          
ATOM   2454  C   LYS   336     -37.260  71.245 104.481  1.00 28.53          
ATOM   2455  O   LYS   336     -36.142  71.724 104.301  1.00 28.31          
ATOM   2456  CB  LYS   336     -37.943  70.421 106.742  1.00 27.17          
ATOM   2457  CG  LYS   336     -38.249  69.202 107.679  1.00 26.90          
ATOM   2458  CD  LYS   336     -39.572  68.572 107.219  1.00 28.61          
ATOM   2459  CE  LYS   336     -40.187  67.601 108.147  1.00 29.73          
ATOM   2460  NZ  LYS   336     -41.466  67.123 107.580  1.00 27.01          
ATOM   2461  N   GLU   337     -38.380  71.725 103.928  1.00 29.00          
ATOM   2462  CA  GLU   337     -38.431  72.999 103.248  1.00 29.23          
ATOM   2463  C   GLU   337     -37.708  74.080 104.064  1.00 29.88          
ATOM   2464  O   GLU   337     -37.919  74.247 105.286  1.00 28.83          
ATOM   2465  CB  GLU   337     -39.882  73.421 103.021  1.00 29.20          
ATOM   2466  CG  GLU   337     -40.070  74.654 102.167  1.00 30.12          
ATOM   2467  CD  GLU   337     -41.532  75.004 101.895  1.00 31.72          
ATOM   2468  OE1 GLU   337     -42.459  74.358 102.444  1.00 32.87          
ATOM   2469  OE2 GLU   337     -41.731  75.995 101.173  1.00 37.47          
ATOM   2470  N   ASP   338     -36.895  74.855 103.359  1.00 30.43          
ATOM   2471  CA  ASP   338     -36.136  75.965 103.967  1.00 30.20          
ATOM   2472  C   ASP   338     -36.967  77.168 104.374  1.00 30.35          
ATOM   2473  O   ASP   338     -37.965  77.495 103.747  1.00 31.16          
ATOM   2474  CB  ASP   338     -35.055  76.370 102.965  1.00 31.49          
ATOM   2475  CG  ASP   338     -33.934  77.207 103.572  1.00 31.24          
ATOM   2476  OD1 ASP   338     -33.525  76.923 104.715  1.00 32.55          
ATOM   2477  OD2 ASP   338     -33.470  78.118 102.836  1.00 32.57          
END
