
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 (  969),  selected  127 , name 2uyk_A
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2uyk_A.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_A      M       1           -
LGA    K     3_A      S       2           -
LGA    I     4_A      D       3           -
LGA    I     5_A      V       4           -
LGA    E     6_A      I       5           -
LGA    T     7_A      E       6           -
LGA    -       -      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    Q     8_A      P      17          5.834
LGA    R     9_A      V      18          2.149
LGA    A    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    I    14_A      -       -           -
LGA    G    15_A      A      23           #
LGA    P    16_A      A      24          3.449
LGA    -       -      N      25           -
LGA    Y    17_A      Y      26          1.768
LGA    V    18_A      V      27          1.266
LGA    Q    19_A      P      28          0.974
LGA    G    20_A      F      29          1.033
LGA    V    21_A      T      30          1.580
LGA    D    22_A      I      31          2.542
LGA    L    23_A      S      32          2.961
LGA    G    24_A      G      33          4.061
LGA    S    25_A      N      34          1.339
LGA    M    26_A      L      35          1.413
LGA    V    27_A      L      36          0.928
LGA    F    28_A      Y      37          0.814
LGA    T    29_A      V      38          0.884
LGA    S    30_A      S      39          0.790
LGA    G    31_A      G      40          0.506
LGA    Q    32_A      Q      41          0.438
LGA    I    33_A      L      42          0.830
LGA    P    34_A      P      43          0.786
LGA    V    35_A      M      44          2.040
LGA    X    36_A      E      45          2.023
LGA    P    37_A      S      46          4.852
LGA    Q    38_A      G      47          3.630
LGA    T    39_A      -       -           -
LGA    G    40_A      -       -           -
LGA    E    41_A      K      48          2.122
LGA    I    42_A      I      49          2.230
LGA    P    43_A      A      50          2.285
LGA    A    44_A      V      51          3.359
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    45_A      S      63          2.556
LGA    V    46_A      A      64          1.292
LGA    Q    47_A      Q      65          2.351
LGA    D    48_A      R      66          1.897
LGA    Q    49_A      A      67          0.804
LGA    A    50_A      A      68          1.014
LGA    R    51_A      E      69          0.941
LGA    L    52_A      L      70          0.497
LGA    S    53_A      C      71          0.413
LGA    L    54_A      A      72          0.581
LGA    E    55_A      V      73          0.308
LGA    N    56_A      N      74          0.347
LGA    V    57_A      I      75          0.485
LGA    K    58_A      L      76          0.740
LGA    A    59_A      A      77          0.724
LGA    I    60_A      Q      78          0.790
LGA    V    61_A      V      79          1.114
LGA    V    62_A      K      80          1.598
LGA    A    63_A      A      81          1.517
LGA    A    64_A      A      82          1.738
LGA    G    65_A      L      83          1.837
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    L    66_A      L      87          4.237
LGA    -       -      S      88           -
LGA    -       -      K      89           -
LGA    S    67_A      I      90          3.643
LGA    V    68_A      R      91           -
LGA    G    69_A      -       -           -
LGA    D    70_A      R      92          2.575
LGA    I    71_A      V      93          1.562
LGA    I    72_A      I      94          0.404
LGA    K    73_A      K      95          1.168
LGA    M    74_A      L      96          1.243
LGA    T    75_A      N      97          1.126
LGA    V    76_A      G      98          1.112
LGA    F    77_A      F      99          1.322
LGA    I    78_A      V     100          1.268
LGA    T    79_A      A     101          1.444
LGA    D    80_A      S     102          2.152
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    L    81_A      F     106          4.396
LGA    N    82_A      V     107          3.582
LGA    D    83_A      E     108          4.424
LGA    F    84_A      Q     109          2.309
LGA    A    85_A      H     110          4.988
LGA    T    86_A      L     111          3.770
LGA    I    87_A      V     112          1.555
LGA    N    88_A      I     113          3.704
LGA    E    89_A      N     114          3.344
LGA    V    90_A      G     115          1.610
LGA    Y    91_A      A     116          2.766
LGA    K    92_A      S     117          3.558
LGA    Q    93_A      N     118          2.025
LGA    F    94_A      L     119          1.055
LGA    F    95_A      I     120          2.907
LGA    D    96_A      A     121          2.886
LGA    E    97_A      T     122          1.097
LGA    H    98_A      V     123          2.222
LGA    -       -      L     124           -
LGA    Q    99_A      G     125          0.524
LGA    A   100_A      E     126          3.193
LGA    T   101_A      P     127          4.102
LGA    -       -      G     128           -
LGA    Y   102_A      R     129          1.873
LGA    P   103_A      H     130          1.303
LGA    T   104_A      A     131          1.378
LGA    R   105_A      R     132          1.323
LGA    S   106_A      A     133          1.687
LGA    C   107_A      A     134          1.883
LGA    V   108_A      V     135          1.634
LGA    Q   109_A      G     136          1.131
LGA    V   110_A      M     137          1.604
LGA    A   111_A      A     138          1.069
LGA    R   112_A      S     139          1.010
LGA    L   113_A      L     140          0.606
LGA    P   114_A      P     141          0.216
LGA    K   115_A      F     142          0.599
LGA    D   116_A      N     143          0.760
LGA    V   117_A      A     144          0.944
LGA    K   118_A      S     145          1.358
LGA    L   119_A      V     146          1.299
LGA    E   120_A      E     147          0.922
LGA    I   121_A      I     148          0.751
LGA    E   122_A      D     149          0.810
LGA    A   123_A      A     150          0.523
LGA    I   124_A      I     151          0.854
LGA    A   125_A      V     152          1.028
LGA    V   126_A      E     153          1.364
LGA    R   127_A      I     154          1.847
LGA    S   128_A      D     155          3.995
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  152    5.0    111    2.16    26.13     58.315     4.906

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.889796 * X  +  -0.287212 * Y  +   0.354644 * Z  +  85.331528
  Y_new =  -0.239228 * X  +  -0.368225 * Y  +  -0.898432 * Z  +  73.724525
  Z_new =   0.388629 * X  +  -0.884262 * Y  +   0.258936 * Z  +  34.530121 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.285933    1.855659  [ DEG:   -73.6786    106.3214 ]
  Theta =  -0.399144   -2.742449  [ DEG:   -22.8692   -157.1308 ]
  Phi   =  -2.878946    0.262647  [ DEG:  -164.9514     15.0486 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uyk_A                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uyk_A.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  152   5.0  111   2.16   26.13  58.315
REMARK  ---------------------------------------------------------- 
MOLECULE 2uyk_A
HEADER    UNKNOWN FUNCTION                        10-APR-07   2UYK              
TITLE     CRYSTAL STRUCTURE OF E. COLI TDCF WITH BOUND SERINE                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN TDCF;                                              
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: TDCF;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: MC4100;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21-DE3 GOLD;                             
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PET28A;                                    
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PETHF1                                    
KEYWDS    UNKNOWN FUNCTION, YJGF/YER057C/UK114 FAMILY, SERINE, TDCF             
KEYWDS   2 PROTEIN, LIGAND BINDING, 2-KETOBUTYRATE                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON                      
REVDAT   1   29-MAY-07 2UYK    0                                                
JRNL        AUTH   J.D.BURMAN,C.E.M.STEVENSON,R.G.SAWERS,D.M.LAWSON             
JRNL        TITL   THE CRYSTAL STRUCTURE OF ESCHERICHIA COLI TDCF, A            
JRNL        TITL 2 MEMBER OF THE HIGHLY CONSERVED YJGF/YER057C/UK114            
JRNL        TITL 3 FAMILY.                                                      
JRNL        REF    BMC STRUCT.BIOL.              V.   7    30 2007              
JRNL        REFN                UK ESSN 1472-6807                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2UYK A    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYK B    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
DBREF  2UYK C    1   129  UNP    P0AGL2   TDCF_ECOLI       1    129             
SEQRES   1 A  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 A  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 A  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 A  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 A  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 A  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 A  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 A  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 A  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 A  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 B  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 B  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 B  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 B  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 B  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 B  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 B  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 B  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 B  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 B  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
SEQRES   1 C  129  MET LYS LYS ILE ILE GLU THR GLN ARG ALA PRO GLY ALA          
SEQRES   2 C  129  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY SER MET          
SEQRES   3 C  129  VAL PHE THR SER GLY GLN ILE PRO VAL OCS PRO GLN THR          
SEQRES   4 C  129  GLY GLU ILE PRO ALA ASP VAL GLN ASP GLN ALA ARG LEU          
SEQRES   5 C  129  SER LEU GLU ASN VAL LYS ALA ILE VAL VAL ALA ALA GLY          
SEQRES   6 C  129  LEU SER VAL GLY ASP ILE ILE LYS MET THR VAL PHE ILE          
SEQRES   7 C  129  THR ASP LEU ASN ASP PHE ALA THR ILE ASN GLU VAL TYR          
SEQRES   8 C  129  LYS GLN PHE PHE ASP GLU HIS GLN ALA THR TYR PRO THR          
SEQRES   9 C  129  ARG SER CYS VAL GLN VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 C  129  LYS LEU GLU ILE GLU ALA ILE ALA VAL ARG SER ALA              
HET    OCS  A  36       9                                                       
HET    OCS  B  36       9                                                       
HET    OCS  C  36       9                                                       
HET    SER  C1129       9                                                       
HETNAM     OCS CYSTEINESULFONIC ACID                                            
HETNAM     SER SERINE                                                           
FORMUL   1  OCS    3(C3 H7 N O5 S)                                              
FORMUL   4  SER    C3 H7 N O3                                                   
FORMUL   5  HOH   *457(H2 O)                                                    
CRYST1   72.685   86.351   62.598  90.00  90.00  90.00 P 21 21 2    12          
ATOM      1  N   LYS A   2      57.379  44.234  33.765  1.00 24.76           N  
ATOM      2  CA  LYS A   2      58.744  43.983  34.317  1.00 23.39           C  
ATOM      3  C   LYS A   2      58.631  43.292  35.692  1.00 22.99           C  
ATOM      4  O   LYS A   2      57.583  43.387  36.360  1.00 25.84           O  
ATOM      5  CB  LYS A   2      59.463  45.315  34.491  1.00 23.73           C  
ATOM      6  CG  LYS A   2      58.715  46.276  35.434  1.00 24.38           C  
ATOM      7  CD  LYS A   2      59.536  47.492  35.883  1.00 24.91           C  
ATOM      8  CE  LYS A   2      58.652  48.767  35.859  1.00 26.02           C  
ATOM      9  NZ  LYS A   2      59.028  49.863  36.820  1.00 27.42           N  
ATOM     10  N   LYS A   3      59.680  42.597  36.113  1.00 21.65           N  
ATOM     11  CA  LYS A   3      59.786  42.067  37.468  1.00 19.92           C  
ATOM     12  C   LYS A   3      61.132  42.490  38.065  1.00 18.50           C  
ATOM     13  O   LYS A   3      62.174  42.296  37.441  1.00 18.80           O  
ATOM     14  CB  LYS A   3      59.669  40.536  37.443  1.00 19.99           C  
ATOM     15  CG  LYS A   3      59.903  39.833  38.758  1.00 22.31           C  
ATOM     16  N   ILE A   4      61.084  43.066  39.264  1.00 17.54           N  
ATOM     17  CA  ILE A   4      62.294  43.394  40.027  1.00 17.23           C  
ATOM     18  C   ILE A   4      62.972  42.125  40.543  1.00 16.38           C  
ATOM     19  O   ILE A   4      62.296  41.221  41.066  1.00 16.65           O  
ATOM     20  CB  ILE A   4      61.983  44.291  41.239  1.00 17.24           C  
ATOM     21  CG1 ILE A   4      61.410  45.645  40.812  1.00 18.77           C  
ATOM     22  CG2 ILE A   4      63.208  44.469  42.090  1.00 19.49           C  
ATOM     23  CD1 ILE A   4      60.869  46.407  41.943  1.00 20.94           C  
ATOM     24  N   ILE A   5      64.307  42.061  40.422  1.00 15.11           N  
ATOM     25  CA  ILE A   5      65.111  40.971  40.979  1.00 15.32           C  
ATOM     26  C   ILE A   5      65.769  41.461  42.282  1.00 15.92           C  
ATOM     27  O   ILE A   5      66.376  42.532  42.326  1.00 15.97           O  
ATOM     28  CB  ILE A   5      66.199  40.475  39.972  1.00 14.88           C  
ATOM     29  CG1 ILE A   5      65.584  40.050  38.634  1.00 15.43           C  
ATOM     30  CG2 ILE A   5      67.101  39.396  40.611  1.00 15.42           C  
ATOM     31  CD1 ILE A   5      66.566  39.987  37.439  1.00 17.13           C  
ATOM     32  N   GLU A   6      65.590  40.696  43.356  1.00 16.97           N  
ATOM     33  CA  GLU A   6      66.109  41.067  44.656  1.00 18.66           C  
ATOM     34  C   GLU A   6      66.673  39.763  45.235  1.00 18.25           C  
ATOM     35  O   GLU A   6      65.972  38.742  45.265  1.00 20.00           O  
ATOM     36  CB  GLU A   6      65.002  41.684  45.540  1.00 18.87           C  
ATOM     37  CG  GLU A   6      65.492  42.217  46.901  1.00 21.12           C  
ATOM     38  CD  GLU A   6      64.442  43.035  47.667  1.00 24.58           C  
ATOM     39  OE1 GLU A   6      63.317  43.254  47.146  1.00 32.97           O  
ATOM     40  OE2 GLU A   6      64.736  43.453  48.815  1.00 33.57           O  
ATOM     41  N   THR A   7      67.949  39.788  45.632  1.00 17.77           N  
ATOM     42  CA  THR A   7      68.599  38.654  46.270  1.00 16.71           C  
ATOM     43  C   THR A   7      69.533  39.097  47.384  1.00 16.88           C  
ATOM     44  O   THR A   7      70.218  40.094  47.263  1.00 17.55           O  
ATOM     45  CB  THR A   7      69.335  37.754  45.261  1.00 16.89           C  
ATOM     46  OG1 THR A   7      70.006  36.688  45.946  1.00 19.49           O  
ATOM     47  CG2 THR A   7      70.359  38.565  44.443  1.00 18.21           C  
ATOM     48  N   GLN A   8      69.539  38.374  48.512  1.00 17.72           N  
ATOM     49  CA  GLN A   8      70.514  38.680  49.572  1.00 17.62           C  
ATOM     50  C   GLN A   8      71.914  38.133  49.252  1.00 17.62           C  
ATOM     51  O   GLN A   8      72.857  38.349  50.029  1.00 17.75           O  
ATOM     52  CB  GLN A   8      70.054  38.111  50.931  1.00 19.10           C  
ATOM     53  CG  GLN A   8      68.621  38.464  51.333  1.00 23.29           C  
ATOM     54  CD  GLN A   8      68.421  39.905  51.721  1.00 28.99           C  
ATOM     55  OE1 GLN A   8      69.173  40.471  52.531  1.00 35.50           O  
ATOM     56  NE2 GLN A   8      67.363  40.510  51.183  1.00 35.27           N  
ATOM     57  N   ARG A   9      72.039  37.416  48.142  1.00 17.08           N  
ATOM     58  CA  ARG A   9      73.337  36.891  47.674  1.00 17.85           C  
ATOM     59  C   ARG A   9      74.207  37.883  46.885  1.00 17.33           C  
ATOM     60  O   ARG A   9      75.352  37.556  46.517  1.00 18.08           O  
ATOM     61  CB  ARG A   9      73.122  35.610  46.875  1.00 18.22           C  
ATOM     62  CG  ARG A   9      72.654  34.439  47.760  1.00 20.05           C  
ATOM     63  CD  ARG A   9      72.239  33.267  46.932  1.00 22.28           C  
ATOM     64  NE  ARG A   9      71.899  32.079  47.732  1.00 26.27           N  
ATOM     65  CZ  ARG A   9      71.116  31.072  47.332  1.00 27.86           C  
ATOM     66  NH1 ARG A   9      70.523  31.098  46.137  1.00 30.37           N  
ATOM     67  NH2 ARG A   9      70.904  30.036  48.163  1.00 27.75           N  
ATOM     68  N   ALA A  10      73.653  39.060  46.605  1.00 16.82           N  
ATOM     69  CA  ALA A  10      74.412  40.204  46.094  1.00 16.54           C  
ATOM     70  C   ALA A  10      74.147  41.367  47.055  1.00 16.56           C  
ATOM     71  O   ALA A  10      73.123  41.364  47.749  1.00 17.45           O  
ATOM     72  CB  ALA A  10      73.938  40.536  44.648  1.00 16.21           C  
ATOM     73  N   PRO A  11      75.039  42.372  47.105  1.00 16.60           N  
ATOM     74  CA  PRO A  11      74.849  43.458  48.057  1.00 17.04           C  
ATOM     75  C   PRO A  11      73.505  44.178  47.853  1.00 17.69           C  
ATOM     76  O   PRO A  11      73.049  44.359  46.706  1.00 17.78           O  
ATOM     77  CB  PRO A  11      76.019  44.403  47.763  1.00 18.04           C  
ATOM     78  CG  PRO A  11      76.983  43.651  46.899  1.00 17.63           C  
ATOM     79  CD  PRO A  11      76.277  42.504  46.314  1.00 16.75           C  
ATOM     80  N   GLY A  12      72.871  44.591  48.940  1.00 18.66           N  
ATOM     81  CA  GLY A  12      71.608  45.314  48.854  1.00 19.35           C  
ATOM     82  C   GLY A  12      71.832  46.678  48.234  1.00 19.74           C  
ATOM     83  O   GLY A  12      72.901  47.266  48.392  1.00 20.73           O  
ATOM     84  N   ALA A  13      70.839  47.177  47.492  1.00 21.91           N  
ATOM     85  CA  ALA A  13      70.947  48.511  46.878  1.00 22.17           C  
ATOM     86  C   ALA A  13      71.293  49.570  47.906  1.00 22.77           C  
ATOM     87  O   ALA A  13      70.598  49.703  48.898  1.00 24.98           O  
ATOM     88  CB  ALA A  13      69.651  48.887  46.197  1.00 22.14           C  
ATOM     89  N   ILE A  14      72.356  50.341  47.686  1.00 23.32           N  
ATOM     90  CA  ILE A  14      72.543  51.511  48.531  1.00 23.90           C  
ATOM     91  C   ILE A  14      71.548  52.594  47.974  1.00 23.65           C  
ATOM     92  O   ILE A  14      70.409  52.755  48.498  1.00 26.80           O  
ATOM     93  CB  ILE A  14      74.074  51.827  48.832  1.00 24.56           C  
ATOM     94  CG1 ILE A  14      74.980  51.763  47.608  1.00 24.51           C  
ATOM     95  CG2 ILE A  14      74.604  50.789  49.852  1.00 26.95           C  
ATOM     96  CD1 ILE A  14      76.458  51.535  47.931  1.00 25.96           C  
ATOM     97  N   GLY A  15      71.873  53.203  46.851  1.00 22.40           N  
ATOM     98  CA  GLY A  15      70.989  54.216  46.276  1.00 20.65           C  
ATOM     99  C   GLY A  15      69.676  53.745  45.625  1.00 19.80           C  
ATOM    100  O   GLY A  15      69.226  52.590  45.798  1.00 20.84           O  
ATOM    101  N   PRO A  16      69.046  54.665  44.876  1.00 18.23           N  
ATOM    102  CA  PRO A  16      67.742  54.515  44.242  1.00 16.89           C  
ATOM    103  C   PRO A  16      67.882  53.673  42.958  1.00 15.15           C  
ATOM    104  O   PRO A  16      67.876  54.208  41.869  1.00 13.19           O  
ATOM    105  CB  PRO A  16      67.338  55.956  43.944  1.00 16.55           C  
ATOM    106  CG  PRO A  16      68.634  56.671  43.722  1.00 16.63           C  
ATOM    107  CD  PRO A  16      69.663  55.970  44.563  1.00 17.60           C  
ATOM    108  N   TYR A  17      68.086  52.369  43.148  1.00 14.30           N  
ATOM    109  CA  TYR A  17      68.195  51.400  42.058  1.00 14.15           C  
ATOM    110  C   TYR A  17      67.800  50.024  42.609  1.00 13.61           C  
ATOM    111  O   TYR A  17      67.788  49.802  43.824  1.00 15.36           O  
ATOM    112  CB  TYR A  17      69.612  51.382  41.422  1.00 14.92           C  
ATOM    113  CG  TYR A  17      70.708  51.038  42.384  1.00 16.67           C  
ATOM    114  CD1 TYR A  17      71.011  49.718  42.697  1.00 16.57           C  
ATOM    115  CD2 TYR A  17      71.442  52.047  42.989  1.00 18.94           C  
ATOM    116  CE1 TYR A  17      72.000  49.419  43.611  1.00 19.27           C  
ATOM    117  CE2 TYR A  17      72.429  51.762  43.903  1.00 20.58           C  
ATOM    118  CZ  TYR A  17      72.707  50.446  44.200  1.00 19.81           C  
ATOM    119  OH  TYR A  17      73.709  50.185  45.123  1.00 22.58           O  
ATOM    120  N   VAL A  18      67.447  49.125  41.708  1.00 12.03           N  
ATOM    121  CA  VAL A  18      67.253  47.725  42.014  1.00 12.07           C  
ATOM    122  C   VAL A  18      68.387  46.908  41.426  1.00 11.20           C  
ATOM    123  O   VAL A  18      69.036  47.315  40.459  1.00 11.70           O  
ATOM    124  CB  VAL A  18      65.879  47.227  41.517  1.00 11.41           C  
ATOM    125  CG1 VAL A  18      64.779  48.066  42.181  1.00 13.27           C  
ATOM    126  CG2 VAL A  18      65.747  47.303  39.945  1.00 11.60           C  
ATOM    127  N   GLN A  19      68.625  45.725  41.995  1.00 11.02           N  
ATOM    128  CA  GLN A  19      69.734  44.867  41.570  1.00 11.66           C  
ATOM    129  C   GLN A  19      69.610  44.400  40.136  1.00 10.84           C  
ATOM    130  O   GLN A  19      70.609  44.326  39.415  1.00  9.83           O  
ATOM    131  CB  GLN A  19      69.832  43.633  42.472  1.00 11.99           C  
ATOM    132  CG  GLN A  19      70.243  43.949  43.892  1.00 12.89           C  
ATOM    133  CD  GLN A  19      70.127  42.717  44.784  1.00 14.20           C  
ATOM    134  OE1 GLN A  19      69.241  41.869  44.566  1.00 19.12           O  
ATOM    135  NE2 GLN A  19      71.051  42.562  45.722  1.00 17.21           N  
ATOM    136  N   GLY A  20      68.382  44.046  39.727  1.00 10.69           N  
ATOM    137  CA  GLY A  20      68.157  43.523  38.403  1.00 10.57           C  
ATOM    138  C   GLY A  20      66.721  43.745  38.018  1.00 11.42           C  
ATOM    139  O   GLY A  20      65.873  44.010  38.874  1.00 11.78           O  
ATOM    140  N   VAL A  21      66.459  43.673  36.721  1.00 12.06           N  
ATOM    141  CA  VAL A  21      65.079  43.715  36.196  1.00 13.39           C  
ATOM    142  C   VAL A  21      64.947  42.601  35.158  1.00 13.10           C  
ATOM    143  O   VAL A  21      65.836  42.394  34.335  1.00 12.61           O  
ATOM    144  CB  VAL A  21      64.707  45.108  35.613  1.00 14.17           C  
ATOM    145  CG1 VAL A  21      63.315  45.075  34.971  1.00 17.12           C  
ATOM    146  CG2 VAL A  21      64.694  46.167  36.698  1.00 16.96           C  
ATOM    147  N   ASP A  22      63.833  41.866  35.226  1.00 13.49           N  
ATOM    148  CA  ASP A  22      63.571  40.749  34.341  1.00 14.63           C  
ATOM    149  C   ASP A  22      62.410  41.144  33.414  1.00 15.38           C  
ATOM    150  O   ASP A  22      61.287  41.391  33.877  1.00 16.71           O  
ATOM    151  CB  ASP A  22      63.212  39.532  35.202  1.00 14.87           C  
ATOM    152  CG  ASP A  22      62.959  38.279  34.400  1.00 18.06           C  
ATOM    153  OD1 ASP A  22      62.855  38.308  33.157  1.00 18.33           O  
ATOM    154  OD2 ASP A  22      62.840  37.246  35.061  1.00 21.47           O  
ATOM    155  N   LEU A  23      62.713  41.264  32.127  1.00 15.02           N  
ATOM    156  CA  LEU A  23      61.751  41.700  31.114  1.00 16.12           C  
ATOM    157  C   LEU A  23      61.072  40.519  30.392  1.00 17.22           C  
ATOM    158  O   LEU A  23      60.295  40.719  29.443  1.00 20.56           O  
ATOM    159  CB  LEU A  23      62.468  42.535  30.063  1.00 16.63           C  
ATOM    160  CG  LEU A  23      63.250  43.754  30.508  1.00 18.14           C  
ATOM    161  CD1 LEU A  23      63.794  44.491  29.280  1.00 19.55           C  
ATOM    162  CD2 LEU A  23      62.383  44.641  31.346  1.00 21.11           C  
ATOM    163  N   GLY A  24      61.373  39.309  30.815  1.00 17.73           N  
ATOM    164  CA  GLY A  24      60.901  38.089  30.136  1.00 18.42           C  
ATOM    165  C   GLY A  24      61.958  37.522  29.213  1.00 18.38           C  
ATOM    166  O   GLY A  24      62.551  36.500  29.495  1.00 22.32           O  
ATOM    167  N   SER A  25      62.237  38.191  28.115  1.00 18.69           N  
ATOM    168  CA  SER A  25      63.219  37.682  27.174  1.00 18.90           C  
ATOM    169  C   SER A  25      64.630  38.060  27.625  1.00 17.72           C  
ATOM    170  O   SER A  25      65.582  37.437  27.222  1.00 17.41           O  
ATOM    171  CB  SER A  25      62.990  38.261  25.790  1.00 19.41           C  
ATOM    172  OG  SER A  25      62.944  39.675  25.856  1.00 24.98           O  
ATOM    173  N   MET A  26      64.729  39.094  28.450  1.00 17.41           N  
ATOM    174  CA  MET A  26      66.026  39.721  28.728  1.00 17.92           C  
ATOM    175  C   MET A  26      66.068  40.099  30.187  1.00 15.28           C  
ATOM    176  O   MET A  26      65.059  40.543  30.729  1.00 13.84           O  
ATOM    177  CB  MET A  26      66.148  41.048  27.979  1.00 18.41           C  
ATOM    178  CG  MET A  26      66.461  41.047  26.561  1.00 22.90           C  
ATOM    179  SD  MET A  26      67.369  42.611  26.231  1.00 27.40           S  
ATOM    180  CE  MET A  26      68.436  41.843  25.039  1.00 25.74           C  
ATOM    181  N   VAL A  27      67.253  39.986  30.800  1.00 13.31           N  
ATOM    182  CA  VAL A  27      67.480  40.451  32.154  1.00 11.49           C  
ATOM    183  C   VAL A  27      68.654  41.440  32.125  1.00 11.23           C  
ATOM    184  O   VAL A  27      69.686  41.166  31.504  1.00 10.84           O  
ATOM    185  CB  VAL A  27      67.841  39.284  33.095  1.00 11.88           C  
ATOM    186  CG1 VAL A  27      68.375  39.799  34.432  1.00 13.58           C  
ATOM    187  CG2 VAL A  27      66.626  38.331  33.272  1.00 13.19           C  
ATOM    188  N   PHE A  28      68.462  42.567  32.808  1.00 10.37           N  
ATOM    189  CA  PHE A  28      69.511  43.583  33.012  1.00 11.17           C  
ATOM    190  C   PHE A  28      69.909  43.587  34.476  1.00 11.18           C  
ATOM    191  O   PHE A  28      69.033  43.543  35.355  1.00 10.22           O  
ATOM    192  CB  PHE A  28      69.007  44.991  32.669  1.00 12.37           C  
ATOM    193  CG  PHE A  28      68.827  45.231  31.212  1.00 12.56           C  
ATOM    194  CD1 PHE A  28      67.734  44.701  30.553  1.00 15.16           C  
ATOM    195  CD2 PHE A  28      69.747  45.969  30.488  1.00 13.34           C  
ATOM    196  CE1 PHE A  28      67.551  44.921  29.190  1.00 15.54           C  
ATOM    197  CE2 PHE A  28      69.574  46.165  29.130  1.00 15.12           C  
ATOM    198  CZ  PHE A  28      68.456  45.635  28.489  1.00 14.53           C  
ATOM    199  N   THR A  29      71.214  43.675  34.739  1.00 10.12           N  
ATOM    200  CA  THR A  29      71.699  43.914  36.096  1.00  9.99           C  
ATOM    201  C   THR A  29      72.172  45.374  36.238  1.00  9.34           C  
ATOM    202  O   THR A  29      72.595  46.033  35.263  1.00  8.77           O  
ATOM    203  CB  THR A  29      72.880  42.989  36.525  1.00  9.74           C  
ATOM    204  OG1 THR A  29      74.131  43.459  35.985  1.00  8.05           O  
ATOM    205  CG2 THR A  29      72.671  41.552  36.110  1.00 10.78           C  
ATOM    206  N   SER A  30      72.118  45.865  37.466  1.00  9.22           N  
ATOM    207  CA  SER A  30      72.876  47.060  37.841  1.00  9.02           C  
ATOM    208  C   SER A  30      74.363  46.756  37.776  1.00  9.19           C  
ATOM    209  O   SER A  30      74.775  45.601  37.707  1.00  9.49           O  
ATOM    210  CB  SER A  30      72.462  47.537  39.231  1.00  8.60           C  
ATOM    211  OG  SER A  30      71.150  48.119  39.173  1.00  9.90           O  
ATOM    212  N   GLY A  31      75.179  47.813  37.762  1.00  9.11           N  
ATOM    213  CA  GLY A  31      76.620  47.654  37.790  1.00  9.51           C  
ATOM    214  C   GLY A  31      77.057  47.093  39.118  1.00  9.78           C  
ATOM    215  O   GLY A  31      76.833  47.716  40.169  1.00 11.29           O  
ATOM    216  N   GLN A  32      77.663  45.914  39.073  1.00  8.96           N  
ATOM    217  CA  GLN A  32      78.080  45.211  40.288  1.00  9.59           C  
ATOM    218  C   GLN A  32      79.501  45.552  40.655  1.00  9.62           C  
ATOM    219  O   GLN A  32      80.426  45.426  39.853  1.00  9.31           O  
ATOM    220  CB  GLN A  32      77.938  43.712  40.133  1.00  9.87           C  
ATOM    221  CG  GLN A  32      76.510  43.302  39.899  1.00 10.93           C  
ATOM    222  CD  GLN A  32      75.577  43.837  40.969  1.00 11.79           C  
ATOM    223  OE1 GLN A  32      75.739  43.537  42.172  1.00 11.76           O  
ATOM    224  NE2 GLN A  32      74.585  44.630  40.553  1.00 11.90           N  
ATOM    225  N   ILE A  33      79.647  45.968  41.904  1.00  9.69           N  
ATOM    226  CA  ILE A  33      80.940  46.322  42.480  1.00  9.56           C  
ATOM    227  C   ILE A  33      81.364  45.257  43.497  1.00 10.20           C  
ATOM    228  O   ILE A  33      80.527  44.477  43.978  1.00  9.49           O  
ATOM    229  CB  ILE A  33      80.923  47.776  43.121  1.00  9.62           C  
ATOM    230  CG1 ILE A  33      79.828  47.947  44.177  1.00  9.85           C  
ATOM    231  CG2 ILE A  33      80.686  48.839  42.030  1.00 10.38           C  
ATOM    232  CD1 ILE A  33      79.959  49.194  45.028  1.00 10.23           C  
ATOM    233  N   PRO A  34      82.676  45.177  43.775  1.00  9.34           N  
ATOM    234  CA  PRO A  34      83.218  44.154  44.700  1.00  9.70           C  
ATOM    235  C   PRO A  34      82.977  44.500  46.173  1.00 10.48           C  
ATOM    236  O   PRO A  34      83.922  44.725  46.938  1.00 11.32           O  
ATOM    237  CB  PRO A  34      84.705  44.097  44.328  1.00  9.41           C  
ATOM    238  CG  PRO A  34      85.008  45.517  43.902  1.00  9.77           C  
ATOM    239  CD  PRO A  34      83.771  45.942  43.116  1.00  9.53           C  
ATOM    240  N   VAL A  35      81.702  44.566  46.547  1.00 11.06           N  
ATOM    241  CA  VAL A  35      81.288  44.688  47.952  1.00 12.26           C  
ATOM    242  C   VAL A  35      80.744  43.322  48.377  1.00 12.93           C  
ATOM    243  O   VAL A  35      79.942  42.723  47.681  1.00 13.30           O  
ATOM    244  CB  VAL A  35      80.204  45.772  48.113  1.00 12.16           C  
ATOM    245  CG1 VAL A  35      79.554  45.714  49.543  1.00 14.63           C  
ATOM    246  CG2 VAL A  35      80.804  47.142  47.859  1.00 12.72           C  
HETATM  247  N   OCS A  36      81.212  42.836  49.517  1.00 14.14           N  
HETATM  248  CA  OCS A  36      80.805  41.543  50.001  1.00 15.82           C  
HETATM  249  CB  OCS A  36      81.811  41.098  51.047  1.00 15.88           C  
HETATM  250  SG  OCS A  36      81.561  39.406  51.571  1.00 19.34           S  
HETATM  251  C   OCS A  36      79.370  41.600  50.546  1.00 15.60           C  
HETATM  252  O   OCS A  36      79.058  42.464  51.361  1.00 15.64           O  
HETATM  253  OD1 OCS A  36      80.354  39.341  52.332  1.00 21.27           O  
HETATM  254  OD2 OCS A  36      81.610  38.525  50.454  1.00 18.90           O  
HETATM  255  OD3 OCS A  36      82.697  39.133  52.414  1.00 20.40           O  
ATOM    256  N   PRO A  37      78.466  40.730  50.022  1.00 16.56           N  
ATOM    257  CA  PRO A  37      77.052  40.844  50.372  1.00 17.71           C  
ATOM    258  C   PRO A  37      76.718  40.587  51.833  1.00 19.12           C  
ATOM    259  O   PRO A  37      75.727  41.120  52.336  1.00 20.92           O  
ATOM    260  CB  PRO A  37      76.369  39.825  49.465  1.00 17.59           C  
ATOM    261  CG  PRO A  37      77.431  38.942  48.959  1.00 17.83           C  
ATOM    262  CD  PRO A  37      78.713  39.668  49.023  1.00 16.10           C  
ATOM    263  N   GLN A  38      77.548  39.804  52.501  1.00 19.55           N  
ATOM    264  CA  GLN A  38      77.297  39.496  53.914  1.00 19.83           C  
ATOM    265  C   GLN A  38      77.961  40.522  54.871  1.00 19.97           C  
ATOM    266  O   GLN A  38      77.343  40.938  55.868  1.00 21.88           O  
ATOM    267  CB  GLN A  38      77.635  38.019  54.174  1.00 20.58           C  
ATOM    268  CG  GLN A  38      76.452  36.994  53.945  1.00 24.85           C  
ATOM    269  CD  GLN A  38      75.350  37.335  52.872  1.00 29.69           C  
ATOM    270  OE1 GLN A  38      74.524  38.232  53.075  1.00 34.68           O  
ATOM    271  NE2 GLN A  38      75.288  36.538  51.781  1.00 30.84           N  
ATOM    272  N   THR A  39      79.149  41.028  54.534  1.00 19.68           N  
ATOM    273  CA  THR A  39      79.887  41.904  55.456  1.00 19.23           C  
ATOM    274  C   THR A  39      80.022  43.350  55.039  1.00 19.53           C  
ATOM    275  O   THR A  39      80.351  44.193  55.872  1.00 20.78           O  
ATOM    276  CB  THR A  39      81.319  41.410  55.705  1.00 19.83           C  
ATOM    277  OG1 THR A  39      82.067  41.599  54.503  1.00 20.22           O  
ATOM    278  CG2 THR A  39      81.340  39.938  56.113  1.00 20.92           C  
ATOM    279  N   GLY A  40      79.829  43.647  53.754  1.00 18.03           N  
ATOM    280  CA  GLY A  40      80.014  45.006  53.267  1.00 18.07           C  
ATOM    281  C   GLY A  40      81.453  45.343  52.890  1.00 17.28           C  
ATOM    282  O   GLY A  40      81.714  46.452  52.397  1.00 18.12           O  
ATOM    283  N   GLU A  41      82.386  44.428  53.117  1.00 15.93           N  
ATOM    284  CA  GLU A  41      83.802  44.761  52.925  1.00 16.89           C  
ATOM    285  C   GLU A  41      84.142  44.720  51.441  1.00 14.78           C  
ATOM    286  O   GLU A  41      83.552  43.954  50.693  1.00 14.12           O  
ATOM    287  CB  GLU A  41      84.708  43.787  53.674  1.00 17.78           C  
ATOM    288  CG  GLU A  41      84.714  42.399  53.113  1.00 21.47           C  
ATOM    289  CD  GLU A  41      85.227  41.343  54.085  1.00 24.23           C  
ATOM    290  OE1 GLU A  41      86.345  41.528  54.637  1.00 33.20           O  
ATOM    291  OE2 GLU A  41      84.534  40.305  54.255  1.00 32.75           O  
ATOM    292  N   ILE A  42      85.142  45.509  51.065  1.00 13.54           N  
ATOM    293  CA  ILE A  42      85.712  45.476  49.739  1.00 12.87           C  
ATOM    294  C   ILE A  42      87.101  44.855  49.869  1.00 12.02           C  
ATOM    295  O   ILE A  42      87.936  45.395  50.597  1.00 13.79           O  
ATOM    296  CB  ILE A  42      85.833  46.917  49.173  1.00 12.67           C  
ATOM    297  CG1 ILE A  42      84.433  47.517  48.974  1.00 13.47           C  
ATOM    298  CG2 ILE A  42      86.568  46.914  47.844  1.00 13.69           C  
ATOM    299  CD1 ILE A  42      84.444  48.991  48.860  1.00 13.52           C  
ATOM    300  N   PRO A  43      87.356  43.724  49.201  1.00 12.15           N  
ATOM    301  CA  PRO A  43      88.691  43.110  49.280  1.00 12.36           C  
ATOM    302  C   PRO A  43      89.742  44.004  48.647  1.00 12.04           C  
ATOM    303  O   PRO A  43      89.457  44.659  47.649  1.00 12.50           O  
ATOM    304  CB  PRO A  43      88.577  41.842  48.457  1.00 13.32           C  
ATOM    305  CG  PRO A  43      87.251  41.861  47.828  1.00 14.83           C  
ATOM    306  CD  PRO A  43      86.435  42.973  48.328  1.00 12.56           C  
ATOM    307  N   ALA A  44      90.949  44.005  49.192  1.00 11.71           N  
ATOM    308  CA  ALA A  44      91.960  44.940  48.703  1.00 11.64           C  
ATOM    309  C   ALA A  44      92.525  44.559  47.353  1.00 11.68           C  
ATOM    310  O   ALA A  44      92.853  45.443  46.542  1.00 11.82           O  
ATOM    311  CB  ALA A  44      93.080  45.067  49.711  1.00 13.98           C  
ATOM    312  N   ASP A  45      92.682  43.263  47.119  1.00 11.77           N  
ATOM    313  CA  ASP A  45      93.410  42.766  45.980  1.00 12.71           C  
ATOM    314  C   ASP A  45      92.561  42.747  44.723  1.00 11.69           C  
ATOM    315  O   ASP A  45      91.417  42.314  44.770  1.00 11.82           O  
ATOM    316  CB  ASP A  45      93.856  41.338  46.288  1.00 14.33           C  
ATOM    317  CG  ASP A  45      94.771  40.786  45.265  1.00 20.23           C  
ATOM    318  OD1 ASP A  45      94.354  40.627  44.096  1.00 28.83           O  
ATOM    319  OD2 ASP A  45      95.916  40.455  45.636  1.00 29.32           O  
ATOM    320  N   VAL A  46      93.120  43.167  43.592  1.00 11.44           N  
ATOM    321  CA  VAL A  46      92.311  43.267  42.396  1.00 12.25           C  
ATOM    322  C   VAL A  46      91.781  41.899  41.923  1.00 12.38           C  
ATOM    323  O   VAL A  46      90.672  41.835  41.423  1.00 11.62           O  
ATOM    324  CB  VAL A  46      93.038  44.021  41.279  1.00 13.22           C  
ATOM    325  CG1 VAL A  46      94.187  43.244  40.773  1.00 13.28           C  
ATOM    326  CG2 VAL A  46      92.053  44.451  40.189  1.00 12.92           C  
ATOM    327  N   GLN A  47      92.551  40.823  42.097  1.00 12.97           N  
ATOM    328  CA  GLN A  47      92.049  39.480  41.773  1.00 14.68           C  
ATOM    329  C   GLN A  47      90.766  39.167  42.562  1.00 12.69           C  
ATOM    330  O   GLN A  47      89.762  38.645  42.032  1.00 11.76           O  
ATOM    331  CB  GLN A  47      93.117  38.448  42.119  1.00 15.66           C  
ATOM    332  CG  GLN A  47      92.861  37.112  41.507  1.00 20.52           C  
ATOM    333  CD  GLN A  47      93.864  36.050  41.952  1.00 22.12           C  
ATOM    334  OE1 GLN A  47      94.903  36.351  42.534  1.00 28.77           O  
ATOM    335  NE2 GLN A  47      93.528  34.796  41.696  1.00 30.99           N  
ATOM    336  N   ASP A  48      90.799  39.480  43.843  1.00 11.76           N  
ATOM    337  CA  ASP A  48      89.653  39.231  44.712  1.00 11.76           C  
ATOM    338  C   ASP A  48      88.491  40.148  44.361  1.00 11.14           C  
ATOM    339  O   ASP A  48      87.320  39.723  44.403  1.00 10.15           O  
ATOM    340  CB  ASP A  48      90.046  39.381  46.174  1.00 12.26           C  
ATOM    341  CG  ASP A  48      91.020  38.318  46.622  1.00 15.40           C  
ATOM    342  OD1 ASP A  48      90.984  37.183  46.086  1.00 16.50           O  
ATOM    343  OD2 ASP A  48      91.802  38.614  47.538  1.00 19.84           O  
ATOM    344  N   GLN A  49      88.790  41.409  44.004  1.00  9.32           N  
ATOM    345  CA  GLN A  49      87.680  42.281  43.592  1.00  9.15           C  
ATOM    346  C   GLN A  49      87.018  41.774  42.306  1.00  8.80           C  
ATOM    347  O   GLN A  49      85.787  41.812  42.174  1.00  9.10           O  
ATOM    348  CB  GLN A  49      88.165  43.729  43.386  1.00  9.07           C  
ATOM    349  CG  GLN A  49      88.544  44.423  44.696  1.00  8.33           C  
ATOM    350  CD  GLN A  49      88.672  45.932  44.551  1.00  9.44           C  
ATOM    351  OE1 GLN A  49      88.104  46.538  43.621  1.00  8.68           O  
ATOM    352  NE2 GLN A  49      89.409  46.542  45.461  1.00  9.01           N  
ATOM    353  N   ALA A  50      87.820  41.336  41.346  1.00  8.71           N  
ATOM    354  CA  ALA A  50      87.313  40.868  40.078  1.00  9.96           C  
ATOM    355  C   ALA A  50      86.399  39.647  40.337  1.00 10.72           C  
ATOM    356  O   ALA A  50      85.288  39.576  39.811  1.00  9.80           O  
ATOM    357  CB  ALA A  50      88.473  40.520  39.148  1.00  9.90           C  
ATOM    358  N   ARG A  51      86.870  38.708  41.151  1.00 11.19           N  
ATOM    359  CA  ARG A  51      86.059  37.509  41.473  1.00 11.58           C  
ATOM    360  C   ARG A  51      84.724  37.907  42.136  1.00 10.74           C  
ATOM    361  O   ARG A  51      83.663  37.384  41.793  1.00 11.67           O  
ATOM    362  CB  ARG A  51      86.849  36.525  42.330  1.00 13.07           C  
ATOM    363  CG  ARG A  51      86.088  35.245  42.625  1.00 15.98           C  
ATOM    364  CD  ARG A  51      86.033  34.307  41.464  1.00 22.65           C  
ATOM    365  NE  ARG A  51      85.074  33.207  41.695  1.00 25.96           N  
ATOM    366  CZ  ARG A  51      84.777  32.286  40.787  1.00 27.73           C  
ATOM    367  NH1 ARG A  51      85.360  32.319  39.596  1.00 28.42           N  
ATOM    368  NH2 ARG A  51      83.920  31.306  41.082  1.00 28.34           N  
ATOM    369  N   LEU A  52      84.768  38.830  43.073  1.00  9.88           N  
ATOM    370  CA  LEU A  52      83.584  39.214  43.823  1.00 10.31           C  
ATOM    371  C   LEU A  52      82.562  39.955  42.968  1.00 10.22           C  
ATOM    372  O   LEU A  52      81.373  39.748  43.069  1.00 10.08           O  
ATOM    373  CB  LEU A  52      83.987  40.046  45.011  1.00 10.71           C  
ATOM    374  CG  LEU A  52      82.888  40.447  45.972  1.00 10.04           C  
ATOM    375  CD1 LEU A  52      81.937  39.267  46.413  1.00 12.82           C  
ATOM    376  CD2 LEU A  52      83.550  41.143  47.170  1.00 10.41           C  
ATOM    377  N   SER A  53      83.022  40.862  42.121  1.00 10.21           N  
ATOM    378  CA  SER A  53      82.101  41.544  41.221  1.00 10.68           C  
ATOM    379  C   SER A  53      81.358  40.539  40.381  1.00 10.60           C  
ATOM    380  O   SER A  53      80.146  40.637  40.213  1.00 11.02           O  
ATOM    381  CB  SER A  53      82.833  42.500  40.285  1.00 12.46           C  
ATOM    382  OG  SER A  53      83.515  43.439  41.033  1.00 19.27           O  
ATOM    383  N   LEU A  54      82.101  39.575  39.832  1.00 10.77           N  
ATOM    384  CA  LEU A  54      81.511  38.541  39.002  1.00 10.40           C  
ATOM    385  C   LEU A  54      80.527  37.659  39.788  1.00 11.15           C  
ATOM    386  O   LEU A  54      79.454  37.328  39.264  1.00 10.67           O  
ATOM    387  CB  LEU A  54      82.582  37.711  38.311  1.00 10.02           C  
ATOM    388  CG  LEU A  54      83.356  38.459  37.213  1.00 10.01           C  
ATOM    389  CD1 LEU A  54      84.673  37.757  36.859  1.00 11.31           C  
ATOM    390  CD2 LEU A  54      82.454  38.619  35.997  1.00 12.77           C  
ATOM    391  N   GLU A  55      80.856  37.329  41.030  1.00 10.67           N  
ATOM    392  CA  GLU A  55      79.919  36.529  41.856  1.00 11.68           C  
ATOM    393  C   GLU A  55      78.634  37.298  42.115  1.00 11.51           C  
ATOM    394  O   GLU A  55      77.525  36.734  42.215  1.00 11.57           O  
ATOM    395  CB  GLU A  55      80.573  36.128  43.194  1.00 12.56           C  
ATOM    396  CG  GLU A  55      81.663  35.091  43.043  1.00 15.42           C  
ATOM    397  CD  GLU A  55      81.142  33.810  42.377  1.00 19.01           C  
ATOM    398  OE1 GLU A  55      80.238  33.191  42.988  1.00 24.73           O  
ATOM    399  OE2 GLU A  55      81.605  33.447  41.272  1.00 22.98           O  
ATOM    400  N   ASN A  56      78.760  38.612  42.262  1.00 10.54           N  
ATOM    401  CA  ASN A  56      77.579  39.446  42.502  1.00 10.62           C  
ATOM    402  C   ASN A  56      76.697  39.481  41.250  1.00 10.61           C  
ATOM    403  O   ASN A  56      75.467  39.410  41.343  1.00 10.33           O  
ATOM    404  CB  ASN A  56      77.989  40.843  42.951  1.00 10.58           C  
ATOM    405  CG  ASN A  56      78.485  40.889  44.396  1.00 10.45           C  
ATOM    406  OD1 ASN A  56      78.209  39.967  45.188  1.00 12.22           O  
ATOM    407  ND2 ASN A  56      79.174  41.976  44.767  1.00  9.62           N  
ATOM    408  N   VAL A  57      77.311  39.560  40.072  1.00 10.33           N  
ATOM    409  CA  VAL A  57      76.546  39.442  38.836  1.00 10.27           C  
ATOM    410  C   VAL A  57      75.824  38.080  38.792  1.00 11.25           C  
ATOM    411  O   VAL A  57      74.624  38.018  38.457  1.00 10.98           O  
ATOM    412  CB  VAL A  57      77.431  39.601  37.592  1.00 10.41           C  
ATOM    413  CG1 VAL A  57      76.635  39.262  36.273  1.00 11.34           C  
ATOM    414  CG2 VAL A  57      78.040  41.015  37.565  1.00  9.53           C  
ATOM    415  N   LYS A  58      76.559  37.020  39.100  1.00 11.62           N  
ATOM    416  CA  LYS A  58      76.018  35.659  39.069  1.00 12.67           C  
ATOM    417  C   LYS A  58      74.802  35.528  39.979  1.00 12.46           C  
ATOM    418  O   LYS A  58      73.777  34.941  39.586  1.00 13.62           O  
ATOM    419  CB  LYS A  58      77.117  34.643  39.435  1.00 12.11           C  
ATOM    420  CG  LYS A  58      76.601  33.175  39.476  1.00 13.89           C  
ATOM    421  CD  LYS A  58      77.593  32.228  40.125  1.00 15.32           C  
ATOM    422  CE  LYS A  58      77.400  32.148  41.641  1.00 18.19           C  
ATOM    423  NZ  LYS A  58      78.434  31.289  42.311  1.00 21.54           N  
ATOM    424  N   ALA A  59      74.885  36.101  41.177  1.00 11.80           N  
ATOM    425  CA  ALA A  59      73.802  36.005  42.156  1.00 12.18           C  
ATOM    426  C   ALA A  59      72.491  36.566  41.585  1.00 12.58           C  
ATOM    427  O   ALA A  59      71.396  36.011  41.787  1.00 13.24           O  
ATOM    428  CB  ALA A  59      74.190  36.724  43.433  1.00 12.89           C  
ATOM    429  N   ILE A  60      72.606  37.677  40.871  1.00 11.33           N  
ATOM    430  CA  ILE A  60      71.422  38.353  40.339  1.00 11.30           C  
ATOM    431  C   ILE A  60      70.829  37.565  39.152  1.00 11.35           C  
ATOM    432  O   ILE A  60      69.610  37.404  39.069  1.00 11.89           O  
ATOM    433  CB  ILE A  60      71.774  39.786  39.905  1.00 11.02           C  
ATOM    434  CG1 ILE A  60      72.251  40.571  41.125  1.00 11.30           C  
ATOM    435  CG2 ILE A  60      70.566  40.452  39.210  1.00 11.54           C  
ATOM    436  CD1 ILE A  60      72.858  41.901  40.768  1.00 11.89           C  
ATOM    437  N   VAL A  61      71.680  37.106  38.238  1.00 12.07           N  
ATOM    438  CA  VAL A  61      71.249  36.335  37.066  1.00 13.07           C  
ATOM    439  C   VAL A  61      70.589  35.028  37.543  1.00 12.93           C  
ATOM    440  O   VAL A  61      69.543  34.622  37.032  1.00 13.71           O  
ATOM    441  CB  VAL A  61      72.451  36.098  36.086  1.00 13.46           C  
ATOM    442  CG1 VAL A  61      72.139  35.108  35.026  1.00 17.67           C  
ATOM    443  CG2 VAL A  61      72.917  37.477  35.470  1.00 13.32           C  
ATOM    444  N   VAL A  62      71.156  34.435  38.589  1.00 13.18           N  
ATOM    445  CA  VAL A  62      70.601  33.190  39.161  1.00 13.42           C  
ATOM    446  C   VAL A  62      69.262  33.475  39.833  1.00 12.97           C  
ATOM    447  O   VAL A  62      68.326  32.647  39.719  1.00 14.41           O  
ATOM    448  CB  VAL A  62      71.602  32.503  40.140  1.00 12.85           C  
ATOM    449  CG1 VAL A  62      70.902  31.393  40.984  1.00 13.42           C  
ATOM    450  CG2 VAL A  62      72.809  31.941  39.376  1.00 12.26           C  
ATOM    451  N   ALA A  63      69.150  34.586  40.548  1.00 14.01           N  
ATOM    452  CA  ALA A  63      67.882  34.977  41.216  1.00 14.40           C  
ATOM    453  C   ALA A  63      66.744  35.155  40.198  1.00 15.24           C  
ATOM    454  O   ALA A  63      65.560  34.968  40.536  1.00 17.05           O  
ATOM    455  CB  ALA A  63      68.073  36.252  42.021  1.00 14.89           C  
ATOM    456  N   ALA A  64      67.106  35.482  38.957  1.00 15.57           N  
ATOM    457  CA  ALA A  64      66.118  35.639  37.861  1.00 15.81           C  
ATOM    458  C   ALA A  64      65.727  34.305  37.209  1.00 16.29           C  
ATOM    459  O   ALA A  64      64.883  34.293  36.296  1.00 18.28           O  
ATOM    460  CB  ALA A  64      66.630  36.601  36.776  1.00 16.59           C  
ATOM    461  N   GLY A  65      66.342  33.210  37.646  1.00 15.93           N  
ATOM    462  CA  GLY A  65      66.154  31.884  37.042  1.00 16.05           C  
ATOM    463  C   GLY A  65      67.019  31.567  35.842  1.00 15.90           C  
ATOM    464  O   GLY A  65      66.731  30.668  35.072  1.00 17.29           O  
ATOM    465  N   LEU A  66      68.100  32.319  35.677  1.00 15.62           N  
ATOM    466  CA  LEU A  66      69.034  32.120  34.616  1.00 14.43           C  
ATOM    467  C   LEU A  66      70.366  31.649  35.219  1.00 14.36           C  
ATOM    468  O   LEU A  66      70.454  31.326  36.417  1.00 14.81           O  
ATOM    469  CB  LEU A  66      69.189  33.457  33.857  1.00 14.41           C  
ATOM    470  CG  LEU A  66      67.919  33.946  33.149  1.00 14.41           C  
ATOM    471  CD1 LEU A  66      68.250  35.260  32.425  1.00 16.29           C  
ATOM    472  CD2 LEU A  66      67.394  32.889  32.169  1.00 17.55           C  
ATOM    473  N   SER A  67      71.403  31.577  34.394  1.00 14.75           N  
ATOM    474  CA  SER A  67      72.725  31.175  34.847  1.00 14.99           C  
ATOM    475  C   SER A  67      73.746  31.997  34.064  1.00 13.94           C  
ATOM    476  O   SER A  67      73.408  32.709  33.121  1.00 14.14           O  
ATOM    477  CB  SER A  67      72.996  29.682  34.621  1.00 15.57           C  
ATOM    478  OG  SER A  67      72.956  29.304  33.264  1.00 17.80           O  
ATOM    479  N   VAL A  68      75.002  31.830  34.426  1.00 14.28           N  
ATOM    480  CA  VAL A  68      76.101  32.602  33.802  1.00 13.53           C  
ATOM    481  C   VAL A  68      76.146  32.411  32.276  1.00 13.37           C  
ATOM    482  O   VAL A  68      76.392  33.372  31.542  1.00 12.51           O  
ATOM    483  CB  VAL A  68      77.438  32.226  34.443  1.00 14.26           C  
ATOM    484  CG1 VAL A  68      78.614  32.680  33.601  1.00 13.34           C  
ATOM    485  CG2 VAL A  68      77.497  32.792  35.852  1.00 15.93           C  
ATOM    486  N   GLY A  69      75.836  31.204  31.785  1.00 13.63           N  
ATOM    487  CA  GLY A  69      75.814  30.931  30.364  1.00 14.20           C  
ATOM    488  C   GLY A  69      74.730  31.639  29.562  1.00 13.91           C  
ATOM    489  O   GLY A  69      74.730  31.575  28.333  1.00 15.65           O  
ATOM    490  N   ASP A  70      73.808  32.306  30.257  1.00 12.54           N  
ATOM    491  CA  ASP A  70      72.765  33.116  29.621  1.00 12.97           C  
ATOM    492  C   ASP A  70      73.194  34.582  29.403  1.00 12.60           C  
ATOM    493  O   ASP A  70      72.483  35.362  28.749  1.00 12.12           O  
ATOM    494  CB  ASP A  70      71.492  33.083  30.474  1.00 13.24           C  
ATOM    495  CG  ASP A  70      70.889  31.699  30.570  1.00 14.79           C  
ATOM    496  OD1 ASP A  70      70.748  31.043  29.518  1.00 17.45           O  
ATOM    497  OD2 ASP A  70      70.566  31.271  31.701  1.00 17.14           O  
ATOM    498  N   ILE A  71      74.348  34.947  29.961  1.00 11.98           N  
ATOM    499  CA  ILE A  71      74.838  36.320  29.819  1.00 11.59           C  
ATOM    500  C   ILE A  71      75.365  36.531  28.397  1.00 11.70           C  
ATOM    501  O   ILE A  71      76.169  35.739  27.911  1.00 12.35           O  
ATOM    502  CB  ILE A  71      75.941  36.591  30.820  1.00 11.50           C  
ATOM    503  CG1 ILE A  71      75.384  36.534  32.253  1.00 11.81           C  
ATOM    504  CG2 ILE A  71      76.596  37.949  30.501  1.00 11.09           C  
ATOM    505  CD1 ILE A  71      76.447  36.661  33.378  1.00 12.25           C  
ATOM    506  N   ILE A  72      74.952  37.624  27.751  1.00 11.78           N  
ATOM    507  CA  ILE A  72      75.337  37.895  26.363  1.00 12.03           C  
ATOM    508  C   ILE A  72      76.147  39.176  26.193  1.00 11.86           C  
ATOM    509  O   ILE A  72      76.804  39.340  25.203  1.00 11.28           O  
ATOM    510  CB  ILE A  72      74.124  37.835  25.420  1.00 12.25           C  
ATOM    511  CG1 ILE A  72      73.003  38.790  25.832  1.00 14.77           C  
ATOM    512  CG2 ILE A  72      73.587  36.387  25.380  1.00 15.44           C  
ATOM    513  CD1 ILE A  72      73.120  40.144  25.309  1.00 16.48           C  
ATOM    514  N   LYS A  73      76.125  40.048  27.191  1.00 11.10           N  
ATOM    515  CA  LYS A  73      76.941  41.282  27.123  1.00 12.02           C  
ATOM    516  C   LYS A  73      77.360  41.691  28.533  1.00 12.04           C  
ATOM    517  O   LYS A  73      76.546  41.649  29.460  1.00 10.66           O  
ATOM    518  CB  LYS A  73      76.148  42.413  26.455  1.00 11.80           C  
ATOM    519  CG  LYS A  73      76.831  43.794  26.524  1.00 12.83           C  
ATOM    520  CD  LYS A  73      76.125  44.804  25.688  1.00 15.39           C  
ATOM    521  CE  LYS A  73      76.684  46.244  25.807  1.00 18.34           C  
ATOM    522  NZ  LYS A  73      75.994  47.242  24.952  1.00 20.22           N  
ATOM    523  N   MET A  74      78.619  42.101  28.660  1.00 11.41           N  
ATOM    524  CA  MET A  74      79.143  42.668  29.891  1.00 13.79           C  
ATOM    525  C   MET A  74      79.820  43.976  29.572  1.00 11.94           C  
ATOM    526  O   MET A  74      80.510  44.071  28.578  1.00 12.86           O  
ATOM    527  CB  MET A  74      80.184  41.770  30.519  1.00 14.12           C  
ATOM    528  CG  MET A  74      79.817  40.327  30.644  1.00 17.20           C  
ATOM    529  SD  MET A  74      80.289  39.707  32.227  1.00 24.67           S  
ATOM    530  CE  MET A  74      78.872  40.125  32.652  1.00  3.45           C  
ATOM    531  N   THR A  75      79.606  44.982  30.403  1.00  9.89           N  
ATOM    532  CA  THR A  75      80.424  46.188  30.328  1.00 10.02           C  
ATOM    533  C   THR A  75      81.256  46.230  31.608  1.00  9.91           C  
ATOM    534  O   THR A  75      80.693  46.129  32.691  1.00  9.84           O  
ATOM    535  CB  THR A  75      79.558  47.438  30.170  1.00 11.01           C  
ATOM    536  OG1 THR A  75      78.711  47.281  29.024  1.00 13.68           O  
ATOM    537  CG2 THR A  75      80.454  48.631  29.996  1.00 11.73           C  
ATOM    538  N   VAL A  76      82.577  46.333  31.451  1.00  9.15           N  
ATOM    539  CA  VAL A  76      83.514  46.260  32.573  1.00  8.96           C  
ATOM    540  C   VAL A  76      84.209  47.621  32.670  1.00  9.27           C  
ATOM    541  O   VAL A  76      85.048  47.981  31.814  1.00  8.66           O  
ATOM    542  CB  VAL A  76      84.550  45.099  32.380  1.00  9.00           C  
ATOM    543  CG1 VAL A  76      85.525  45.030  33.554  1.00 10.44           C  
ATOM    544  CG2 VAL A  76      83.786  43.783  32.155  1.00  9.28           C  
ATOM    545  N   PHE A  77      83.792  48.416  33.661  1.00  8.06           N  
ATOM    546  CA  PHE A  77      84.433  49.713  33.924  1.00  8.31           C  
ATOM    547  C   PHE A  77      85.516  49.481  34.952  1.00  8.41           C  
ATOM    548  O   PHE A  77      85.229  48.868  35.967  1.00  7.12           O  
ATOM    549  CB  PHE A  77      83.446  50.711  34.486  1.00  9.21           C  
ATOM    550  CG  PHE A  77      82.233  50.958  33.617  1.00  8.98           C  
ATOM    551  CD1 PHE A  77      81.017  50.358  33.943  1.00  9.51           C  
ATOM    552  CD2 PHE A  77      82.293  51.788  32.519  1.00  9.73           C  
ATOM    553  CE1 PHE A  77      79.865  50.619  33.178  1.00 11.68           C  
ATOM    554  CE2 PHE A  77      81.128  52.043  31.753  1.00 11.09           C  
ATOM    555  CZ  PHE A  77      79.931  51.458  32.107  1.00 11.18           C  
ATOM    556  N   ILE A  78      86.745  49.915  34.684  1.00  7.39           N  
ATOM    557  CA  ILE A  78      87.853  49.672  35.610  1.00  7.64           C  
ATOM    558  C   ILE A  78      88.613  50.956  35.899  1.00  7.62           C  
ATOM    559  O   ILE A  78      88.519  51.903  35.142  1.00  7.78           O  
ATOM    560  CB  ILE A  78      88.805  48.567  35.060  1.00  8.68           C  
ATOM    561  CG1 ILE A  78      89.603  49.023  33.846  1.00  7.83           C  
ATOM    562  CG2 ILE A  78      87.984  47.295  34.739  1.00  7.43           C  
ATOM    563  CD1 ILE A  78      90.651  47.976  33.335  1.00  9.81           C  
ATOM    564  N   THR A  79      89.382  50.982  36.982  1.00  6.06           N  
ATOM    565  CA  THR A  79      90.173  52.172  37.302  1.00  6.81           C  
ATOM    566  C   THR A  79      91.642  52.125  36.830  1.00  6.68           C  
ATOM    567  O   THR A  79      92.350  53.158  36.860  1.00  7.32           O  
ATOM    568  CB  THR A  79      90.095  52.496  38.783  1.00  7.04           C  
ATOM    569  OG1 THR A  79      90.500  51.351  39.526  1.00  7.47           O  
ATOM    570  CG2 THR A  79      88.694  52.905  39.163  1.00  9.54           C  
ATOM    571  N   ASP A  80      92.124  50.966  36.382  1.00  7.42           N  
ATOM    572  CA  ASP A  80      93.512  50.861  35.951  1.00  8.02           C  
ATOM    573  C   ASP A  80      93.691  49.713  34.963  1.00  7.67           C  
ATOM    574  O   ASP A  80      93.637  48.558  35.355  1.00  7.91           O  
ATOM    575  CB  ASP A  80      94.451  50.707  37.191  1.00  8.69           C  
ATOM    576  CG  ASP A  80      95.927  50.782  36.843  1.00  8.95           C  
ATOM    577  OD1 ASP A  80      96.268  50.786  35.622  1.00  7.96           O  
ATOM    578  OD2 ASP A  80      96.753  50.859  37.803  1.00  9.24           O  
ATOM    579  N   LEU A  81      93.925  50.050  33.696  1.00  7.79           N  
ATOM    580  CA  LEU A  81      94.159  49.035  32.660  1.00  8.91           C  
ATOM    581  C   LEU A  81      95.380  48.161  32.932  1.00  9.21           C  
ATOM    582  O   LEU A  81      95.478  47.071  32.378  1.00 10.08           O  
ATOM    583  CB  LEU A  81      94.253  49.670  31.269  1.00  9.86           C  
ATOM    584  CG  LEU A  81      92.877  49.872  30.623  1.00 12.99           C  
ATOM    585  CD1 LEU A  81      92.901  50.982  29.576  1.00 16.88           C  
ATOM    586  CD2 LEU A  81      92.382  48.542  29.986  1.00 13.71           C  
ATOM    587  N   ASN A  82      96.300  48.593  33.793  1.00  9.06           N  
ATOM    588  CA  ASN A  82      97.398  47.689  34.188  1.00  9.91           C  
ATOM    589  C   ASN A  82      96.913  46.483  34.992  1.00 10.14           C  
ATOM    590  O   ASN A  82      97.612  45.467  35.046  1.00 10.21           O  
ATOM    591  CB  ASN A  82      98.527  48.448  34.885  1.00 10.61           C  
ATOM    592  CG  ASN A  82      99.217  49.431  33.921  1.00 13.63           C  
ATOM    593  OD1 ASN A  82      99.454  50.598  34.238  1.00 15.89           O  
ATOM    594  ND2 ASN A  82      99.431  48.983  32.703  1.00 19.44           N  
ATOM    595  N   ASP A  83      95.700  46.573  35.551  1.00  8.79           N  
ATOM    596  CA  ASP A  83      95.022  45.456  36.222  1.00  8.96           C  
ATOM    597  C   ASP A  83      94.394  44.468  35.247  1.00  9.81           C  
ATOM    598  O   ASP A  83      93.899  43.423  35.700  1.00  9.63           O  
ATOM    599  CB  ASP A  83      93.871  45.959  37.109  1.00  9.40           C  
ATOM    600  CG  ASP A  83      94.336  46.842  38.281  1.00  9.21           C  
ATOM    601  OD1 ASP A  83      95.497  46.782  38.712  1.00  9.69           O  
ATOM    602  OD2 ASP A  83      93.486  47.566  38.812  1.00  8.34           O  
ATOM    603  N   PHE A  84      94.334  44.812  33.961  1.00  9.90           N  
ATOM    604  CA  PHE A  84      93.497  44.078  33.033  1.00 12.20           C  
ATOM    605  C   PHE A  84      93.889  42.630  32.864  1.00 11.37           C  
ATOM    606  O   PHE A  84      93.009  41.766  32.793  1.00 11.64           O  
ATOM    607  CB  PHE A  84      93.440  44.736  31.651  1.00 15.30           C  
ATOM    608  CG  PHE A  84      92.473  44.035  30.752  1.00 19.04           C  
ATOM    609  CD1 PHE A  84      91.129  44.173  30.984  1.00 21.90           C  
ATOM    610  CD2 PHE A  84      92.908  43.144  29.790  1.00 20.88           C  
ATOM    611  CE1 PHE A  84      90.180  43.468  30.202  1.00 22.65           C  
ATOM    612  CE2 PHE A  84      91.980  42.431  29.010  1.00 21.51           C  
ATOM    613  CZ  PHE A  84      90.615  42.618  29.219  1.00 20.89           C  
ATOM    614  N   ALA A  85      95.177  42.333  32.857  1.00 10.87           N  
ATOM    615  CA  ALA A  85      95.598  40.933  32.670  1.00 11.48           C  
ATOM    616  C   ALA A  85      95.039  40.068  33.793  1.00 11.27           C  
ATOM    617  O   ALA A  85      94.499  38.974  33.568  1.00 11.80           O  
ATOM    618  CB  ALA A  85      97.126  40.838  32.582  1.00 12.97           C  
ATOM    619  N   THR A  86      95.136  40.551  35.023  1.00 10.95           N  
ATOM    620  CA  THR A  86      94.633  39.806  36.178  1.00 11.68           C  
ATOM    621  C   THR A  86      93.122  39.708  36.123  1.00 11.02           C  
ATOM    622  O   THR A  86      92.527  38.628  36.350  1.00 11.44           O  
ATOM    623  CB  THR A  86      95.098  40.459  37.497  1.00 12.44           C  
ATOM    624  OG1 THR A  86      96.523  40.307  37.622  1.00 14.44           O  
ATOM    625  CG2 THR A  86      94.420  39.822  38.709  1.00 14.77           C  
ATOM    626  N   ILE A  87      92.472  40.827  35.823  1.00 10.00           N  
ATOM    627  CA  ILE A  87      91.021  40.832  35.747  1.00  9.92           C  
ATOM    628  C   ILE A  87      90.560  39.839  34.666  1.00 10.40           C  
ATOM    629  O   ILE A  87      89.612  39.048  34.879  1.00 11.01           O  
ATOM    630  CB  ILE A  87      90.476  42.234  35.444  1.00  9.65           C  
ATOM    631  CG1 ILE A  87      90.688  43.144  36.649  1.00  9.31           C  
ATOM    632  CG2 ILE A  87      88.978  42.161  35.107  1.00 10.41           C  
ATOM    633  CD1 ILE A  87      90.376  44.619  36.417  1.00  9.55           C  
ATOM    634  N   ASN A  88      91.214  39.887  33.517  1.00 10.24           N  
ATOM    635  CA  ASN A  88      90.832  39.059  32.361  1.00 11.99           C  
ATOM    636  C   ASN A  88      90.992  37.583  32.699  1.00 12.58           C  
ATOM    637  O   ASN A  88      90.172  36.756  32.255  1.00 13.14           O  
ATOM    638  CB  ASN A  88      91.712  39.429  31.171  1.00 12.70           C  
ATOM    639  CG  ASN A  88      91.076  39.153  29.842  1.00 17.57           C  
ATOM    640  OD1 ASN A  88      89.868  39.204  29.709  1.00 20.71           O  
ATOM    641  ND2 ASN A  88      91.908  38.924  28.823  1.00 21.08           N  
ATOM    642  N   GLU A  89      92.048  37.238  33.443  1.00 12.85           N  
ATOM    643  CA  GLU A  89      92.252  35.827  33.818  1.00 13.75           C  
ATOM    644  C   GLU A  89      91.170  35.325  34.747  1.00 13.19           C  
ATOM    645  O   GLU A  89      90.626  34.204  34.550  1.00 13.17           O  
ATOM    646  CB  GLU A  89      93.628  35.562  34.406  1.00 15.10           C  
ATOM    647  CG  GLU A  89      93.910  34.022  34.551  1.00 17.90           C  
ATOM    648  CD  GLU A  89      93.533  33.145  33.290  1.00 24.84           C  
ATOM    649  OE1 GLU A  89      94.016  33.410  32.152  1.00 25.85           O  
ATOM    650  OE2 GLU A  89      92.730  32.162  33.443  1.00 28.65           O  
ATOM    651  N   VAL A  90      90.777  36.148  35.709  1.00 12.86           N  
ATOM    652  CA  VAL A  90      89.674  35.802  36.597  1.00 12.67           C  
ATOM    653  C   VAL A  90      88.366  35.677  35.814  1.00 12.42           C  
ATOM    654  O   VAL A  90      87.560  34.756  36.028  1.00 12.95           O  
ATOM    655  CB  VAL A  90      89.491  36.831  37.698  1.00 12.91           C  
ATOM    656  CG1 VAL A  90      88.161  36.611  38.474  1.00 13.81           C  
ATOM    657  CG2 VAL A  90      90.704  36.840  38.628  1.00 12.56           C  
ATOM    658  N   TYR A  91      88.171  36.595  34.887  1.00 11.29           N  
ATOM    659  CA  TYR A  91      86.936  36.638  34.056  1.00 11.34           C  
ATOM    660  C   TYR A  91      86.837  35.411  33.174  1.00 11.93           C  
ATOM    661  O   TYR A  91      85.769  34.790  33.060  1.00 12.63           O  
ATOM    662  CB  TYR A  91      87.018  37.921  33.203  1.00 11.34           C  
ATOM    663  CG  TYR A  91      85.846  38.285  32.343  1.00 10.21           C  
ATOM    664  CD1 TYR A  91      85.594  37.621  31.151  1.00 10.91           C  
ATOM    665  CD2 TYR A  91      85.065  39.388  32.643  1.00 10.99           C  
ATOM    666  CE1 TYR A  91      84.539  38.012  30.300  1.00 11.15           C  
ATOM    667  CE2 TYR A  91      84.025  39.780  31.819  1.00 10.71           C  
ATOM    668  CZ  TYR A  91      83.752  39.105  30.653  1.00 11.38           C  
ATOM    669  OH  TYR A  91      82.728  39.576  29.857  1.00 12.51           O  
ATOM    670  N   LYS A  92      87.932  35.080  32.506  1.00 12.57           N  
ATOM    671  CA  LYS A  92      87.983  33.861  31.671  1.00 13.42           C  
ATOM    672  C   LYS A  92      87.680  32.622  32.517  1.00 13.04           C  
ATOM    673  O   LYS A  92      86.917  31.759  32.113  1.00 13.12           O  
ATOM    674  CB  LYS A  92      89.368  33.702  31.065  1.00 14.08           C  
ATOM    675  CG  LYS A  92      89.519  32.475  30.106  1.00 15.16           C  
ATOM    676  CD  LYS A  92      90.882  32.442  29.481  1.00 15.97           C  
ATOM    677  CE  LYS A  92      91.217  31.124  28.760  1.00 19.66           C  
ATOM    678  NZ  LYS A  92      90.067  30.239  28.496  1.00 22.91           N  
ATOM    679  N   GLN A  93      88.331  32.516  33.673  1.00 13.03           N  
ATOM    680  CA  GLN A  93      88.138  31.353  34.561  1.00 15.56           C  
ATOM    681  C   GLN A  93      86.686  31.229  35.016  1.00 14.54           C  
ATOM    682  O   GLN A  93      86.156  30.119  35.126  1.00 14.77           O  
ATOM    683  CB  GLN A  93      89.113  31.427  35.739  1.00 15.84           C  
ATOM    684  CG  GLN A  93      90.567  31.231  35.324  1.00 20.55           C  
ATOM    685  CD  GLN A  93      91.562  30.997  36.490  1.00 22.48           C  
ATOM    686  OE1 GLN A  93      92.790  31.192  36.327  1.00 30.99           O  
ATOM    687  NE2 GLN A  93      91.051  30.578  37.656  1.00 29.33           N  
ATOM    688  N   PHE A  94      86.044  32.360  35.292  1.00 13.24           N  
ATOM    689  CA  PHE A  94      84.644  32.421  35.719  1.00 13.27           C  
ATOM    690  C   PHE A  94      83.716  31.831  34.636  1.00 13.49           C  
ATOM    691  O   PHE A  94      82.877  30.944  34.909  1.00 14.34           O  
ATOM    692  CB  PHE A  94      84.296  33.889  36.040  1.00 13.94           C  
ATOM    693  CG  PHE A  94      82.845  34.141  36.324  1.00 14.31           C  
ATOM    694  CD1 PHE A  94      82.034  34.694  35.352  1.00 14.48           C  
ATOM    695  CD2 PHE A  94      82.322  33.922  37.601  1.00 15.16           C  
ATOM    696  CE1 PHE A  94      80.708  34.995  35.597  1.00 15.95           C  
ATOM    697  CE2 PHE A  94      80.962  34.204  37.861  1.00 15.74           C  
ATOM    698  CZ  PHE A  94      80.175  34.744  36.877  1.00 15.62           C  
ATOM    699  N   PHE A  95      83.860  32.283  33.403  1.00 12.33           N  
ATOM    700  CA  PHE A  95      83.044  31.734  32.307  1.00 13.40           C  
ATOM    701  C   PHE A  95      83.400  30.288  32.033  1.00 14.38           C  
ATOM    702  O   PHE A  95      82.498  29.440  31.854  1.00 15.33           O  
ATOM    703  CB  PHE A  95      83.081  32.627  31.056  1.00 13.12           C  
ATOM    704  CG  PHE A  95      82.221  33.854  31.209  1.00 12.12           C  
ATOM    705  CD1 PHE A  95      80.879  33.797  30.908  1.00 12.55           C  
ATOM    706  CD2 PHE A  95      82.747  35.042  31.718  1.00 13.78           C  
ATOM    707  CE1 PHE A  95      80.032  34.898  31.102  1.00 13.55           C  
ATOM    708  CE2 PHE A  95      81.933  36.148  31.904  1.00 13.18           C  
ATOM    709  CZ  PHE A  95      80.574  36.085  31.587  1.00 12.72           C  
ATOM    710  N   ASP A  96      84.692  29.979  32.035  1.00 14.66           N  
ATOM    711  CA  ASP A  96      85.116  28.569  31.797  1.00 14.95           C  
ATOM    712  C   ASP A  96      84.587  27.633  32.882  1.00 15.37           C  
ATOM    713  O   ASP A  96      84.140  26.511  32.556  1.00 16.38           O  
ATOM    714  CB  ASP A  96      86.635  28.446  31.684  1.00 14.92           C  
ATOM    715  CG  ASP A  96      87.208  29.099  30.421  1.00 14.44           C  
ATOM    716  OD1 ASP A  96      86.464  29.541  29.506  1.00 15.70           O  
ATOM    717  OD2 ASP A  96      88.445  29.176  30.331  1.00 16.62           O  
ATOM    718  N   GLU A  97      84.600  28.048  34.145  1.00 16.33           N  
ATOM    719  CA  GLU A  97      84.067  27.205  35.242  1.00 18.11           C  
ATOM    720  C   GLU A  97      82.579  26.898  35.079  1.00 18.13           C  
ATOM    721  O   GLU A  97      82.093  25.842  35.539  1.00 20.45           O  
ATOM    722  CB  GLU A  97      84.236  27.874  36.596  1.00 18.81           C  
ATOM    723  CG  GLU A  97      85.628  27.842  37.199  1.00 22.67           C  
ATOM    724  CD  GLU A  97      85.710  28.620  38.517  1.00 24.38           C  
ATOM    725  OE1 GLU A  97      84.643  29.017  39.077  1.00 31.22           O  
ATOM    726  OE2 GLU A  97      86.853  28.817  39.003  1.00 33.14           O  
ATOM    727  N   HIS A  98      81.843  27.815  34.444  1.00 17.44           N  
ATOM    728  CA  HIS A  98      80.424  27.659  34.226  1.00 17.38           C  
ATOM    729  C   HIS A  98      80.124  27.120  32.831  1.00 17.42           C  
ATOM    730  O   HIS A  98      78.990  27.140  32.390  1.00 19.12           O  
ATOM    731  CB  HIS A  98      79.727  29.000  34.491  1.00 17.44           C  
ATOM    732  CG  HIS A  98      79.702  29.369  35.937  1.00 18.17           C  
ATOM    733  ND1 HIS A  98      80.598  30.250  36.499  1.00 19.13           N  
ATOM    734  CD2 HIS A  98      78.941  28.912  36.960  1.00 19.31           C  
ATOM    735  CE1 HIS A  98      80.348  30.366  37.789  1.00 19.02           C  
ATOM    736  NE2 HIS A  98      79.356  29.553  38.096  1.00 23.11           N  
ATOM    737  N   GLN A  99      81.158  26.646  32.141  1.00 18.41           N  
ATOM    738  CA  GLN A  99      81.043  26.059  30.811  1.00 18.63           C  
ATOM    739  C   GLN A  99      80.209  26.962  29.915  1.00 18.67           C  
ATOM    740  O   GLN A  99      79.344  26.518  29.170  1.00 19.89           O  
ATOM    741  CB  GLN A  99      80.517  24.606  30.933  1.00 19.28           C  
ATOM    742  CG  GLN A  99      81.477  23.756  31.786  1.00 21.36           C  
ATOM    743  CD  GLN A  99      81.084  22.304  31.871  1.00 23.67           C  
ATOM    744  OE1 GLN A  99      80.866  21.650  30.848  1.00 31.02           O  
ATOM    745  NE2 GLN A  99      81.030  21.778  33.086  1.00 28.12           N  
ATOM    746  N   ALA A 100      80.513  28.271  29.988  1.00 17.09           N  
ATOM    747  CA  ALA A 100      79.708  29.345  29.391  1.00 17.60           C  
ATOM    748  C   ALA A 100      80.468  29.980  28.218  1.00 17.57           C  
ATOM    749  O   ALA A 100      81.661  30.261  28.332  1.00 18.58           O  
ATOM    750  CB  ALA A 100      79.399  30.389  30.440  1.00 17.51           C  
ATOM    751  N   THR A 101      79.782  30.165  27.093  1.00 18.12           N  
ATOM    752  CA  THR A 101      80.324  30.887  25.951  1.00 17.89           C  
ATOM    753  C   THR A 101      80.616  32.296  26.421  1.00 16.26           C  
ATOM    754  O   THR A 101      79.835  32.881  27.167  1.00 17.13           O  
ATOM    755  CB  THR A 101      79.288  30.907  24.754  1.00 17.96           C  
ATOM    756  OG1 THR A 101      79.025  29.543  24.320  1.00 23.75           O  
ATOM    757  CG2 THR A 101      79.785  31.744  23.571  1.00 20.32           C  
ATOM    758  N   TYR A 102      81.711  32.870  25.943  1.00 15.41           N  
ATOM    759  CA  TYR A 102      82.038  34.244  26.341  1.00 14.27           C  
ATOM    760  C   TYR A 102      81.034  35.244  25.743  1.00 14.06           C  
ATOM    761  O   TYR A 102      80.663  35.144  24.562  1.00 15.67           O  
ATOM    762  CB  TYR A 102      83.431  34.613  25.888  1.00 14.36           C  
ATOM    763  CG  TYR A 102      84.464  33.631  26.348  1.00 13.90           C  
ATOM    764  CD1 TYR A 102      84.578  33.275  27.693  1.00 14.57           C  
ATOM    765  CD2 TYR A 102      85.332  33.053  25.443  1.00 16.52           C  
ATOM    766  CE1 TYR A 102      85.560  32.368  28.120  1.00 14.75           C  
ATOM    767  CE2 TYR A 102      86.271  32.136  25.857  1.00 15.84           C  
ATOM    768  CZ  TYR A 102      86.380  31.791  27.188  1.00 14.98           C  
ATOM    769  OH  TYR A 102      87.346  30.873  27.601  1.00 16.12           O  
ATOM    770  N   PRO A 103      80.574  36.190  26.566  1.00 13.21           N  
ATOM    771  CA  PRO A 103      79.683  37.233  26.047  1.00 12.55           C  
ATOM    772  C   PRO A 103      80.436  38.297  25.233  1.00 11.50           C  
ATOM    773  O   PRO A 103      81.672  38.253  25.143  1.00 11.02           O  
ATOM    774  CB  PRO A 103      79.060  37.821  27.310  1.00 12.32           C  
ATOM    775  CG  PRO A 103      80.043  37.612  28.343  1.00 12.54           C  
ATOM    776  CD  PRO A 103      80.769  36.314  28.020  1.00 12.22           C  
ATOM    777  N   THR A 104      79.694  39.219  24.628  1.00 10.30           N  
ATOM    778  CA  THR A 104      80.317  40.442  24.112  1.00 10.54           C  
ATOM    779  C   THR A 104      80.798  41.263  25.320  1.00 10.06           C  
ATOM    780  O   THR A 104      80.331  41.081  26.417  1.00  9.57           O  
ATOM    781  CB  THR A 104      79.373  41.268  23.235  1.00 10.09           C  
ATOM    782  OG1 THR A 104      78.275  41.726  24.004  1.00 11.88           O  
ATOM    783  CG2 THR A 104      78.830  40.449  22.050  1.00 12.08           C  
ATOM    784  N   ARG A 105      81.723  42.192  25.106  1.00 10.41           N  
ATOM    785  CA  ARG A 105      82.246  42.982  26.211  1.00 10.66           C  
ATOM    786  C   ARG A 105      82.803  44.300  25.713  1.00 10.06           C  
ATOM    787  O   ARG A 105      83.281  44.400  24.585  1.00  9.95           O  
ATOM    788  CB  ARG A 105      83.360  42.221  26.898  1.00 12.09           C  
ATOM    789  CG  ARG A 105      83.906  42.840  28.144  1.00 14.92           C  
ATOM    790  CD  ARG A 105      84.987  41.949  28.798  1.00 14.49           C  
ATOM    791  NE  ARG A 105      86.196  41.738  28.010  1.00 17.30           N  
ATOM    792  CZ  ARG A 105      87.215  40.950  28.394  1.00 19.52           C  
ATOM    793  NH1 ARG A 105      87.185  40.317  29.567  1.00 18.60           N  
ATOM    794  NH2 ARG A 105      88.269  40.782  27.611  1.00 20.71           N  
ATOM    795  N   SER A 106      82.686  45.310  26.568  1.00  9.47           N  
ATOM    796  CA  SER A 106      83.424  46.577  26.424  1.00 10.17           C  
ATOM    797  C   SER A 106      84.160  46.766  27.733  1.00 10.31           C  
ATOM    798  O   SER A 106      83.625  46.450  28.787  1.00  9.02           O  
ATOM    799  CB  SER A 106      82.493  47.743  26.152  1.00 10.56           C  
ATOM    800  OG  SER A 106      81.959  47.605  24.828  1.00 14.66           O  
ATOM    801  N   CYS A 107      85.394  47.256  27.639  1.00 12.17           N  
ATOM    802  CA  CYS A 107      86.220  47.493  28.816  1.00 11.96           C  
ATOM    803  C   CYS A 107      86.885  48.842  28.628  1.00 11.31           C  
ATOM    804  O   CYS A 107      87.495  49.110  27.592  1.00 11.65           O  
ATOM    805  CB  CYS A 107      87.284  46.420  28.998  1.00 14.73           C  
ATOM    806  SG  CYS A 107      88.185  46.540  30.602  1.00 20.33           S  
ATOM    807  N   VAL A 108      86.722  49.696  29.623  1.00  8.66           N  
ATOM    808  CA  VAL A 108      87.298  51.022  29.566  1.00  8.61           C  
ATOM    809  C   VAL A 108      87.791  51.412  30.944  1.00  7.92           C  
ATOM    810  O   VAL A 108      87.213  50.984  31.938  1.00  7.29           O  
ATOM    811  CB  VAL A 108      86.275  52.065  29.073  1.00  9.28           C  
ATOM    812  CG1 VAL A 108      85.769  51.669  27.693  1.00 11.63           C  
ATOM    813  CG2 VAL A 108      85.134  52.276  30.061  1.00 10.09           C  
ATOM    814  N   GLN A 109      88.820  52.262  30.989  1.00  6.87           N  
ATOM    815  CA  GLN A 109      89.324  52.773  32.266  1.00  6.63           C  
ATOM    816  C   GLN A 109      88.675  54.120  32.562  1.00  7.24           C  
ATOM    817  O   GLN A 109      88.867  55.073  31.810  1.00  6.84           O  
ATOM    818  CB  GLN A 109      90.834  52.964  32.244  1.00  6.28           C  
ATOM    819  CG  GLN A 109      91.425  53.435  33.585  1.00  7.18           C  
ATOM    820  CD  GLN A 109      92.909  53.712  33.482  1.00  6.80           C  
ATOM    821  OE1 GLN A 109      93.669  52.869  32.988  1.00  7.95           O  
ATOM    822  NE2 GLN A 109      93.327  54.869  33.932  1.00  8.27           N  
ATOM    823  N   VAL A 110      87.888  54.172  33.620  1.00  6.92           N  
ATOM    824  CA  VAL A 110      87.241  55.404  34.059  1.00  6.89           C  
ATOM    825  C   VAL A 110      88.114  56.092  35.103  1.00  7.42           C  
ATOM    826  O   VAL A 110      89.157  55.561  35.475  1.00  7.72           O  
ATOM    827  CB  VAL A 110      85.833  55.091  34.605  1.00  6.83           C  
ATOM    828  CG1 VAL A 110      84.973  54.456  33.486  1.00  8.40           C  
ATOM    829  CG2 VAL A 110      85.887  54.183  35.826  1.00  7.96           C  
ATOM    830  N   ALA A 111      87.690  57.259  35.576  1.00  7.47           N  
ATOM    831  CA  ALA A 111      88.413  57.995  36.625  1.00  7.73           C  
ATOM    832  C   ALA A 111      88.275  57.400  38.025  1.00  8.00           C  
ATOM    833  O   ALA A 111      89.249  57.327  38.788  1.00  8.60           O  
ATOM    834  CB  ALA A 111      87.986  59.483  36.653  1.00  8.48           C  
ATOM    835  N   ARG A 112      87.066  57.006  38.373  1.00  7.38           N  
ATOM    836  CA  ARG A 112      86.772  56.559  39.732  1.00  7.49           C  
ATOM    837  C   ARG A 112      85.424  55.853  39.704  1.00  7.72           C  
ATOM    838  O   ARG A 112      84.622  56.076  38.801  1.00  7.70           O  
ATOM    839  CB  ARG A 112      86.735  57.784  40.662  1.00  7.44           C  
ATOM    840  CG  ARG A 112      87.016  57.476  42.117  1.00  8.47           C  
ATOM    841  CD  ARG A 112      87.171  58.766  42.899  1.00  9.32           C  
ATOM    842  NE  ARG A 112      87.344  58.493  44.320  1.00  8.71           N  
ATOM    843  CZ  ARG A 112      87.251  59.404  45.270  1.00 10.63           C  
ATOM    844  NH1 ARG A 112      86.924  60.638  44.961  1.00 11.67           N  
ATOM    845  NH2 ARG A 112      87.414  59.043  46.551  1.00 11.85           N  
ATOM    846  N   LEU A 113      85.186  55.003  40.693  1.00  6.65           N  
ATOM    847  CA  LEU A 113      83.950  54.277  40.814  1.00  7.86           C  
ATOM    848  C   LEU A 113      83.359  54.429  42.227  1.00  8.64           C  
ATOM    849  O   LEU A 113      84.086  54.771  43.202  1.00  7.34           O  
ATOM    850  CB  LEU A 113      84.231  52.795  40.512  1.00  7.86           C  
ATOM    851  CG  LEU A 113      84.631  52.471  39.073  1.00  7.34           C  
ATOM    852  CD1 LEU A 113      85.235  51.062  38.997  1.00  8.12           C  
ATOM    853  CD2 LEU A 113      83.421  52.645  38.094  1.00  8.25           C  
ATOM    854  N   PRO A 114      82.060  54.148  42.362  1.00  9.40           N  
ATOM    855  CA  PRO A 114      81.450  54.127  43.695  1.00  9.43           C  
ATOM    856  C   PRO A 114      82.250  53.304  44.678  1.00  9.75           C  
ATOM    857  O   PRO A 114      82.745  52.224  44.352  1.00  9.75           O  
ATOM    858  CB  PRO A 114      80.081  53.502  43.444  1.00 10.57           C  
ATOM    859  CG  PRO A 114      79.756  54.004  42.023  1.00 11.25           C  
ATOM    860  CD  PRO A 114      81.065  53.878  41.297  1.00 10.82           C  
ATOM    861  N   LYS A 115      82.385  53.862  45.866  1.00 11.03           N  
ATOM    862  CA  LYS A 115      83.099  53.220  46.961  1.00 12.08           C  
ATOM    863  C   LYS A 115      84.562  52.925  46.646  1.00 10.40           C  
ATOM    864  O   LYS A 115      85.188  52.106  47.326  1.00 11.44           O  
ATOM    865  CB  LYS A 115      82.365  51.946  47.417  1.00 13.28           C  
ATOM    866  CG  LYS A 115      80.952  52.156  48.001  1.00 16.71           C  
ATOM    867  CD  LYS A 115      80.381  50.899  48.678  1.00 18.26           C  
ATOM    868  CE  LYS A 115      79.407  51.251  49.832  1.00 21.08           C  
ATOM    869  NZ  LYS A 115      78.778  50.055  50.523  1.00 24.27           N  
ATOM    870  N   ASP A 116      85.147  53.631  45.677  1.00  9.61           N  
ATOM    871  CA  ASP A 116      86.564  53.498  45.338  1.00 10.36           C  
ATOM    872  C   ASP A 116      86.973  52.093  44.956  1.00 10.52           C  
ATOM    873  O   ASP A 116      88.114  51.709  45.108  1.00 12.14           O  
ATOM    874  CB  ASP A 116      87.504  54.064  46.441  1.00 11.69           C  
ATOM    875  CG  ASP A 116      87.773  55.557  46.250  1.00 12.78           C  
ATOM    876  OD1 ASP A 116      88.518  55.964  45.310  1.00 11.93           O  
ATOM    877  OD2 ASP A 116      87.182  56.304  47.020  1.00 14.35           O  
ATOM    878  N   VAL A 117      86.050  51.345  44.384  1.00  9.04           N  
ATOM    879  CA  VAL A 117      86.359  50.007  43.881  1.00  8.27           C  
ATOM    880  C   VAL A 117      87.164  50.062  42.567  1.00  8.28           C  
ATOM    881  O   VAL A 117      87.175  51.088  41.886  1.00  8.32           O  
ATOM    882  CB  VAL A 117      85.085  49.194  43.711  1.00  8.85           C  
ATOM    883  CG1 VAL A 117      84.378  49.015  45.078  1.00  8.46           C  
ATOM    884  CG2 VAL A 117      84.143  49.824  42.634  1.00  7.92           C  
ATOM    885  N   LYS A 118      87.848  48.968  42.230  1.00  7.06           N  
ATOM    886  CA  LYS A 118      88.680  48.877  41.038  1.00  7.39           C  
ATOM    887  C   LYS A 118      87.918  48.516  39.750  1.00  7.29           C  
ATOM    888  O   LYS A 118      88.438  48.708  38.641  1.00  7.52           O  
ATOM    889  CB  LYS A 118      89.800  47.868  41.219  1.00  7.09           C  
ATOM    890  CG  LYS A 118      90.768  48.304  42.322  1.00  7.01           C  
ATOM    891  CD  LYS A 118      91.899  47.274  42.507  1.00  8.04           C  
ATOM    892  CE  LYS A 118      92.816  47.636  43.687  1.00  8.55           C  
ATOM    893  NZ  LYS A 118      93.605  48.839  43.416  1.00  7.88           N  
ATOM    894  N   LEU A 119      86.700  48.006  39.897  1.00  7.01           N  
ATOM    895  CA  LEU A 119      85.854  47.667  38.747  1.00  6.88           C  
ATOM    896  C   LEU A 119      84.385  47.638  39.104  1.00  7.29           C  
ATOM    897  O   LEU A 119      84.018  47.412  40.262  1.00  7.07           O  
ATOM    898  CB  LEU A 119      86.292  46.337  38.090  1.00  6.78           C  
ATOM    899  CG  LEU A 119      85.878  45.015  38.723  1.00  7.98           C  
ATOM    900  CD1 LEU A 119      86.293  43.825  37.823  1.00  8.80           C  
ATOM    901  CD2 LEU A 119      86.441  44.827  40.163  1.00  8.75           C  
ATOM    902  N   GLU A 120      83.570  47.778  38.063  1.00  7.74           N  
ATOM    903  CA  GLU A 120      82.116  47.696  38.130  1.00  8.23           C  
ATOM    904  C   GLU A 120      81.641  46.991  36.863  1.00  7.90           C  
ATOM    905  O   GLU A 120      82.049  47.380  35.767  1.00  7.38           O  
ATOM    906  CB  GLU A 120      81.505  49.104  38.195  1.00  7.96           C  
ATOM    907  CG  GLU A 120      79.991  49.150  38.213  1.00  9.14           C  
ATOM    908  CD  GLU A 120      79.444  50.591  38.283  1.00  9.64           C  
ATOM    909  OE1 GLU A 120      80.177  51.501  38.781  1.00  8.98           O  
ATOM    910  OE2 GLU A 120      78.293  50.823  37.834  1.00 10.84           O  
ATOM    911  N   ILE A 121      80.821  45.948  37.007  1.00  7.54           N  
ATOM    912  CA  ILE A 121      80.446  45.097  35.863  1.00  8.41           C  
ATOM    913  C   ILE A 121      78.938  45.037  35.766  1.00  9.76           C  
ATOM    914  O   ILE A 121      78.274  44.643  36.716  1.00  9.87           O  
ATOM    915  CB  ILE A 121      80.985  43.667  36.017  1.00  8.28           C  
ATOM    916  CG1 ILE A 121      82.518  43.680  36.186  1.00  9.28           C  
ATOM    917  CG2 ILE A 121      80.530  42.828  34.829  1.00  9.65           C  
ATOM    918  CD1 ILE A 121      83.155  42.272  36.285  1.00 11.18           C  
ATOM    919  N   GLU A 122      78.407  45.466  34.623  1.00  9.95           N  
ATOM    920  CA  GLU A 122      76.982  45.330  34.331  1.00 10.70           C  
ATOM    921  C   GLU A 122      76.789  44.244  33.281  1.00 10.51           C  
ATOM    922  O   GLU A 122      77.569  44.131  32.345  1.00  9.42           O  
ATOM    923  CB  GLU A 122      76.381  46.655  33.845  1.00 12.55           C  
ATOM    924  CG  GLU A 122      77.020  47.199  32.636  1.00 13.65           C  
ATOM    925  CD  GLU A 122      76.266  48.322  31.967  1.00 16.29           C  
ATOM    926  OE1 GLU A 122      75.574  49.083  32.622  1.00 16.60           O  
ATOM    927  OE2 GLU A 122      76.406  48.419  30.724  1.00 26.90           O  
ATOM    928  N   ALA A 123      75.752  43.434  33.457  1.00 10.36           N  
ATOM    929  CA  ALA A 123      75.471  42.339  32.532  1.00 10.22           C  
ATOM    930  C   ALA A 123      74.075  42.456  31.928  1.00 10.11           C  
ATOM    931  O   ALA A 123      73.149  43.003  32.516  1.00  9.49           O  
ATOM    932  CB  ALA A 123      75.596  40.979  33.244  1.00 10.26           C  
ATOM    933  N   ILE A 124      73.941  41.862  30.750  1.00  9.49           N  
ATOM    934  CA  ILE A 124      72.634  41.640  30.095  1.00  9.99           C  
ATOM    935  C   ILE A 124      72.602  40.149  29.754  1.00  9.70           C  
ATOM    936  O   ILE A 124      73.579  39.578  29.218  1.00  9.87           O  
ATOM    937  CB  ILE A 124      72.492  42.447  28.791  1.00 10.72           C  
ATOM    938  CG1 ILE A 124      72.759  43.937  29.037  1.00 10.74           C  
ATOM    939  CG2 ILE A 124      71.094  42.242  28.200  1.00 10.76           C  
ATOM    940  CD1 ILE A 124      72.652  44.842  27.765  1.00 11.40           C  
ATOM    941  N   ALA A 125      71.513  39.510  30.135  1.00  9.77           N  
ATOM    942  CA  ALA A 125      71.310  38.068  29.890  1.00 10.14           C  
ATOM    943  C   ALA A 125      70.010  37.883  29.149  1.00 11.34           C  
ATOM    944  O   ALA A 125      69.116  38.719  29.233  1.00 12.88           O  
ATOM    945  CB  ALA A 125      71.286  37.296  31.199  1.00  9.80           C  
ATOM    946  N   VAL A 126      69.923  36.771  28.435  1.00 13.93           N  
ATOM    947  CA  VAL A 126      68.722  36.421  27.682  1.00 14.38           C  
ATOM    948  C   VAL A 126      68.218  35.066  28.152  1.00 15.56           C  
ATOM    949  O   VAL A 126      69.031  34.170  28.493  1.00 14.67           O  
ATOM    950  CB  VAL A 126      68.954  36.435  26.175  1.00 15.25           C  
ATOM    951  CG1 VAL A 126      69.180  37.901  25.732  1.00 18.01           C  
ATOM    952  CG2 VAL A 126      70.076  35.520  25.775  1.00 16.91           C  
ATOM    953  N   ARG A 127      66.886  34.952  28.177  1.00 16.14           N  
ATOM    954  CA  ARG A 127      66.211  33.705  28.533  1.00 17.42           C  
ATOM    955  C   ARG A 127      65.997  32.957  27.216  1.00 19.72           C  
ATOM    956  O   ARG A 127      65.272  33.433  26.334  1.00 22.00           O  
ATOM    957  CB  ARG A 127      64.894  33.997  29.270  1.00 17.64           C  
ATOM    958  CG  ARG A 127      64.233  32.739  29.832  1.00 19.16           C  
ATOM    959  CD  ARG A 127      63.095  33.042  30.741  1.00 18.85           C  
ATOM    960  NE  ARG A 127      63.538  33.427  32.080  1.00 20.18           N  
ATOM    961  CZ  ARG A 127      63.513  34.663  32.567  1.00 21.91           C  
ATOM    962  NH1 ARG A 127      63.096  35.683  31.843  1.00 24.21           N  
ATOM    963  NH2 ARG A 127      63.944  34.878  33.801  1.00 21.66           N  
ATOM    964  N   SER A 128      66.692  31.836  27.074  1.00 21.37           N  
ATOM    965  CA  SER A 128      66.503  30.899  25.946  1.00 22.74           C  
ATOM    966  C   SER A 128      65.471  29.858  26.376  1.00 23.89           C  
ATOM    967  O   SER A 128      64.339  30.230  26.742  1.00 26.31           O  
ATOM    968  CB  SER A 128      67.822  30.214  25.582  1.00 23.28           C  
ATOM    969  OG  SER A 128      68.799  31.151  25.113  1.00 25.98           O  
TER     970      SER A 128                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
