
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  116 (  895),  selected  116 , name 2dyy_I
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2dyy_I.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_I      M       1           -
LGA    E     3_I      S       2           -
LGA    V     4_I      D       3           -
LGA    I     5_I      V       4           -
LGA    F     6_I      I       5           -
LGA    T     7_I      E       6           -
LGA    -       -      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    E     8_I      P      17           #
LGA    N     9_I      V      18          1.599
LGA    A    10_I      -       -           -
LGA    P    11_I      -       -           -
LGA    K    12_I      -       -           -
LGA    P    13_I      -       -           -
LGA    I    14_I      A      23           #
LGA    G    15_I      A      24          3.784
LGA    P    16_I      N      25          1.818
LGA    Y    17_I      Y      26          1.350
LGA    S    18_I      V      27          0.873
LGA    Q    19_I      P      28          0.859
LGA    A    20_I      F      29          0.649
LGA    I    21_I      T      30          1.008
LGA    K    22_I      I      31          1.589
LGA    A    23_I      S      32          2.033
LGA    G    24_I      G      33          1.308
LGA    N    25_I      N      34          1.083
LGA    F    26_I      L      35          1.175
LGA    L    27_I      L      36          0.629
LGA    F    28_I      Y      37          0.561
LGA    I    29_I      V      38          0.254
LGA    A    30_I      S      39          0.149
LGA    G    31_I      G      40          0.245
LGA    Q    32_I      Q      41          0.364
LGA    I    33_I      L      42          0.469
LGA    P    34_I      P      43          0.774
LGA    I    35_I      M      44          1.658
LGA    D    36_I      E      45          2.391
LGA    P    37_I      S      46          5.146
LGA    K    38_I      -       -           -
LGA    T    39_I      -       -           -
LGA    G    40_I      G      47          2.509
LGA    E    41_I      K      48          1.393
LGA    I    42_I      I      49          1.391
LGA    V    43_I      A      50          1.490
LGA    K    44_I      V      51          3.371
LGA    G    45_I      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    D    46_I      D      60          5.749
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    -       -      S      63           -
LGA    I    47_I      A      64          1.278
LGA    K    48_I      Q      65          2.345
LGA    D    49_I      R      66          2.204
LGA    Q    50_I      A      67          1.045
LGA    T    51_I      A      68          1.213
LGA    R    52_I      E      69          1.624
LGA    Q    53_I      L      70          0.972
LGA    V    54_I      C      71          0.741
LGA    L    55_I      A      72          0.757
LGA    E    56_I      V      73          0.522
LGA    N    57_I      N      74          0.481
LGA    I    58_I      I      75          0.719
LGA    K    59_I      L      76          0.744
LGA    A    60_I      A      77          0.817
LGA    I    61_I      Q      78          0.857
LGA    L    62_I      V      79          0.878
LGA    E    63_I      K      80          1.079
LGA    A    64_I      A      81          1.333
LGA    A    65_I      A      82          1.925
LGA    G    66_I      L      83          1.954
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    Y    67_I      L      87          4.092
LGA    S    68_I      S      88          4.245
LGA    L    69_I      K      89           -
LGA    N    70_I      I      90          5.140
LGA    D    71_I      R      91          3.368
LGA    -       -      R      92           -
LGA    V    72_I      V      93          1.251
LGA    I    73_I      I      94          0.811
LGA    K    74_I      K      95          1.095
LGA    V    75_I      L      96          1.002
LGA    T    76_I      N      97          0.632
LGA    V    77_I      G      98          0.523
LGA    Y    78_I      F      99          0.806
LGA    L    79_I      V     100          0.978
LGA    K    80_I      A     101          1.379
LGA    D    81_I      S     102          1.817
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    -       -      V     107           -
LGA    -       -      E     108           -
LGA    -       -      Q     109           -
LGA    -       -      H     110           -
LGA    -       -      L     111           -
LGA    -       -      V     112           -
LGA    -       -      I     113           -
LGA    -       -      N     114           -
LGA    V    91_I      G     115          3.032
LGA    Y    92_I      A     116          3.112
LGA    -       -      S     117           -
LGA    A    93_I      N     118          1.322
LGA    E    94_I      L     119          2.281
LGA    Y    95_I      I     120          1.111
LGA    F    96_I      A     121          2.243
LGA    -       -      T     122           -
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    G    97_I      G     125          4.563
LGA    E    98_I      E     126          2.019
LGA    S    99_I      P     127          2.988
LGA    -       -      G     128           -
LGA    K   100_I      R     129          1.181
LGA    P   101_I      H     130          0.885
LGA    A   102_I      A     131          1.051
LGA    R   103_I      R     132          0.733
LGA    V   104_I      A     133          1.186
LGA    A   105_I      A     134          1.439
LGA    V   106_I      V     135          1.129
LGA    E   107_I      G     136          0.904
LGA    V   108_I      M     137          1.246
LGA    S   109_I      A     138          0.799
LGA    R   110_I      S     139          1.092
LGA    L   111_I      L     140          0.994
LGA    P   112_I      P     141          0.741
LGA    K   113_I      F     142          0.894
LGA    D   114_I      N     143          1.236
LGA    V   115_I      A     144          1.120
LGA    L   116_I      S     145          1.083
LGA    I   117_I      V     146          0.724
LGA    E   118_I      E     147          0.673
LGA    I   119_I      I     148          0.425
LGA    E   120_I      D     149          0.440
LGA    A   121_I      A     150          0.160
LGA    I   122_I      I     151          0.622
LGA    A   123_I      V     152          0.889
LGA    Y   124_I      E     153          1.090
LGA    K   125_I      I     154          1.807
LGA    E   126_I      D     155          3.945
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  116  152    5.0    100    1.88    31.00     60.620     5.041

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.510103 * X  +  -0.854438 * Y  +   0.098642 * Z  +  32.678925
  Y_new =  -0.721163 * X  +  -0.362374 * Y  +   0.590431 * Z  +  95.180115
  Z_new =  -0.468741 * X  +  -0.372317 * Y  +  -0.801038 * Z  +  83.095345 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.706504    0.435088  [ DEG:  -155.0713     24.9287 ]
  Theta =   0.487865    2.653727  [ DEG:    27.9526    152.0474 ]
  Phi   =  -0.955165    2.186427  [ DEG:   -54.7269    125.2731 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dyy_I                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dyy_I.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  116  152   5.0  100   1.88   31.00  60.620
REMARK  ---------------------------------------------------------- 
MOLECULE 2dyy_I
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-SEP-06   2DYY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION INITIATION                  
TITLE    2 INHIBITOR PH0854 FROM PYROCOCCUS HORIKOSHII                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0076 PROTEIN PH0854;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PUTATIVE TRANSLATION INITIATION INHIBITOR;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    PUTATIVE TRANSLATION INITIATION INHIBITOR, PYROCOCCUS                 
KEYWDS   2 HORIKOSHII, TRIMER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL            
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,B.C.WANG,           
AUTHOR   2 M.SHIROUZU,Y.BESSHO,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-SEP-07 2DYY    1       AUTHOR                                   
REVDAT   1   19-MAR-07 2DYY    0                                                
JRNL        AUTH   IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,           
JRNL        AUTH 2 B.C.WANG,M.SHIROUZU,Y.BESSHO,S.YOKOYAMA                      
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION                    
JRNL        TITL 2 INITIATION INHIBITOR PH0854 FROM PYROCOCCUS                  
JRNL        TITL 3 HORIKOSHII                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2DYY A    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY B    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY C    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY D    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY E    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY F    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY G    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY H    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY I    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY J    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY K    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY L    1   126  UNP    O58584   Y854_PYRHO       1    126             
SEQRES   1 A  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 A  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 A  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 A  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 A  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 A  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 A  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 A  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 A  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 A  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 B  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 B  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 B  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 B  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 B  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 B  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 B  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 B  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 B  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 B  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 C  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 C  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 C  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 C  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 C  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 C  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 C  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 C  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 C  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 C  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 D  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 D  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 D  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 D  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 D  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 D  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 D  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 D  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 D  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 D  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 E  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 E  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 E  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 E  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 E  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 E  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 E  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 E  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 E  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 E  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 F  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 F  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 F  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 F  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 F  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 F  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 F  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 F  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 F  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 F  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 G  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 G  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 G  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 G  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 G  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 G  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 G  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 G  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 G  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 G  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 H  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 H  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 H  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 H  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 H  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 H  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 H  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 H  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 H  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 H  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 I  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 I  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 I  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 I  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 I  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 I  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 I  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 I  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 I  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 I  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 J  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 J  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 J  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 J  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 J  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 J  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 J  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 J  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 J  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 J  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 K  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 K  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 K  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 K  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 K  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 K  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 K  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 K  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 K  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 K  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 L  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 L  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 L  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 L  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 L  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 L  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 L  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 L  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 L  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 L  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
FORMUL  13  HOH   *233(H2 O)                                                    
CRYST1   92.490   43.090  170.210  90.00  91.51  90.00 P 1 2 1      24          
ATOM   7521  N   LYS I   2      57.481  43.575  32.560  1.00 65.88           N  
ATOM   7522  CA  LYS I   2      58.667  44.040  33.331  1.00 66.12           C  
ATOM   7523  C   LYS I   2      58.609  43.536  34.761  1.00 65.56           C  
ATOM   7524  O   LYS I   2      57.529  43.402  35.331  1.00 66.64           O  
ATOM   7525  CB  LYS I   2      58.729  45.572  33.339  1.00 66.36           C  
ATOM   7526  CG  LYS I   2      59.787  46.150  34.276  1.00 66.13           C  
ATOM   7527  CD  LYS I   2      59.761  47.678  34.282  1.00 67.47           C  
ATOM   7528  CE  LYS I   2      60.659  48.258  35.373  1.00 66.86           C  
ATOM   7529  NZ  LYS I   2      60.741  49.744  35.302  1.00 65.83           N  
ATOM   7530  N   GLU I   3      59.772  43.255  35.337  1.00 65.11           N  
ATOM   7531  CA  GLU I   3      59.841  42.779  36.709  1.00 65.09           C  
ATOM   7532  C   GLU I   3      61.183  43.039  37.382  1.00 63.86           C  
ATOM   7533  O   GLU I   3      62.238  42.910  36.770  1.00 63.28           O  
ATOM   7534  CB  GLU I   3      59.521  41.283  36.778  1.00 67.57           C  
ATOM   7535  CG  GLU I   3      58.029  40.957  36.810  1.00 71.25           C  
ATOM   7536  CD  GLU I   3      57.744  39.556  37.335  1.00 73.79           C  
ATOM   7537  OE1 GLU I   3      56.553  39.205  37.503  1.00 73.73           O  
ATOM   7538  OE2 GLU I   3      58.714  38.805  37.581  1.00 76.47           O  
ATOM   7539  N   VAL I   4      61.128  43.406  38.654  1.00 63.79           N  
ATOM   7540  CA  VAL I   4      62.328  43.670  39.436  1.00 62.83           C  
ATOM   7541  C   VAL I   4      62.725  42.411  40.209  1.00 61.73           C  
ATOM   7542  O   VAL I   4      61.875  41.670  40.699  1.00 62.16           O  
ATOM   7543  CB  VAL I   4      62.088  44.832  40.424  1.00 62.57           C  
ATOM   7544  CG1 VAL I   4      60.856  44.552  41.250  1.00 64.17           C  
ATOM   7545  CG2 VAL I   4      63.297  45.021  41.323  1.00 62.84           C  
ATOM   7546  N   ILE I   5      64.026  42.166  40.302  1.00 60.94           N  
ATOM   7547  CA  ILE I   5      64.546  41.002  41.006  1.00 60.43           C  
ATOM   7548  C   ILE I   5      65.337  41.477  42.220  1.00 60.30           C  
ATOM   7549  O   ILE I   5      65.990  42.519  42.171  1.00 59.50           O  
ATOM   7550  CB  ILE I   5      65.480  40.162  40.088  1.00 61.51           C  
ATOM   7551  CG1 ILE I   5      64.661  39.452  39.004  1.00 62.66           C  
ATOM   7552  CG2 ILE I   5      66.244  39.130  40.910  1.00 62.02           C  
ATOM   7553  CD1 ILE I   5      63.914  40.376  38.053  1.00 63.54           C  
ATOM   7554  N   PHE I   6      65.275  40.711  43.306  1.00 60.32           N  
ATOM   7555  CA  PHE I   6      65.983  41.057  44.532  1.00 60.20           C  
ATOM   7556  C   PHE I   6      66.532  39.801  45.200  1.00 60.60           C  
ATOM   7557  O   PHE I   6      66.042  38.695  44.967  1.00 59.84           O  
ATOM   7558  CB  PHE I   6      65.033  41.784  45.489  1.00 60.70           C  
ATOM   7559  CG  PHE I   6      65.717  42.391  46.677  1.00 62.23           C  
ATOM   7560  CD1 PHE I   6      66.707  43.356  46.508  1.00 63.85           C  
ATOM   7561  CD2 PHE I   6      65.368  42.009  47.969  1.00 62.95           C  
ATOM   7562  CE1 PHE I   6      67.343  43.937  47.606  1.00 64.12           C  
ATOM   7563  CE2 PHE I   6      65.998  42.582  49.079  1.00 64.14           C  
ATOM   7564  CZ  PHE I   6      66.987  43.548  48.896  1.00 64.86           C  
ATOM   7565  N   THR I   7      67.555  39.975  46.028  1.00 61.09           N  
ATOM   7566  CA  THR I   7      68.171  38.859  46.737  1.00 62.71           C  
ATOM   7567  C   THR I   7      69.090  39.395  47.815  1.00 63.41           C  
ATOM   7568  O   THR I   7      69.586  40.517  47.717  1.00 62.72           O  
ATOM   7569  CB  THR I   7      69.017  37.972  45.799  1.00 63.68           C  
ATOM   7570  OG1 THR I   7      69.591  36.891  46.548  1.00 63.77           O  
ATOM   7571  CG2 THR I   7      70.143  38.786  45.174  1.00 62.81           C  
ATOM   7572  N   GLU I   8      69.322  38.580  48.837  1.00 64.54           N  
ATOM   7573  CA  GLU I   8      70.183  38.969  49.944  1.00 65.45           C  
ATOM   7574  C   GLU I   8      71.611  38.517  49.638  1.00 65.37           C  
ATOM   7575  O   GLU I   8      72.556  38.893  50.332  1.00 64.85           O  
ATOM   7576  CB  GLU I   8      69.677  38.325  51.244  1.00 66.76           C  
ATOM   7577  CG  GLU I   8      70.053  39.066  52.528  1.00 69.04           C  
ATOM   7578  CD  GLU I   8      71.377  38.612  53.130  1.00 70.33           C  
ATOM   7579  OE1 GLU I   8      71.841  39.259  54.097  1.00 70.61           O  
ATOM   7580  OE2 GLU I   8      71.949  37.609  52.648  1.00 70.57           O  
ATOM   7581  N   ASN I   9      71.759  37.720  48.584  1.00 65.52           N  
ATOM   7582  CA  ASN I   9      73.069  37.210  48.185  1.00 65.69           C  
ATOM   7583  C   ASN I   9      73.943  38.219  47.441  1.00 65.27           C  
ATOM   7584  O   ASN I   9      75.083  37.919  47.082  1.00 65.75           O  
ATOM   7585  CB  ASN I   9      72.899  35.956  47.331  1.00 66.10           C  
ATOM   7586  CG  ASN I   9      72.558  34.736  48.155  1.00 65.77           C  
ATOM   7587  OD1 ASN I   9      71.578  34.732  48.901  1.00 63.46           O  
ATOM   7588  ND2 ASN I   9      73.368  33.688  48.024  1.00 65.60           N  
ATOM   7589  N   ALA I  10      73.409  39.413  47.216  1.00 64.54           N  
ATOM   7590  CA  ALA I  10      74.146  40.463  46.525  1.00 63.64           C  
ATOM   7591  C   ALA I  10      73.828  41.804  47.174  1.00 62.48           C  
ATOM   7592  O   ALA I  10      72.722  42.016  47.664  1.00 61.74           O  
ATOM   7593  CB  ALA I  10      73.764  40.487  45.049  1.00 64.55           C  
ATOM   7594  N   PRO I  11      74.799  42.729  47.181  1.00 62.29           N  
ATOM   7595  CA  PRO I  11      74.628  44.057  47.774  1.00 61.94           C  
ATOM   7596  C   PRO I  11      73.236  44.651  47.558  1.00 62.91           C  
ATOM   7597  O   PRO I  11      72.659  44.534  46.480  1.00 61.63           O  
ATOM   7598  CB  PRO I  11      75.726  44.865  47.104  1.00 61.26           C  
ATOM   7599  CG  PRO I  11      76.829  43.859  47.010  1.00 61.58           C  
ATOM   7600  CD  PRO I  11      76.114  42.617  46.523  1.00 61.25           C  
ATOM   7601  N   LYS I  12      72.707  45.283  48.601  1.00 65.08           N  
ATOM   7602  CA  LYS I  12      71.383  45.896  48.558  1.00 66.52           C  
ATOM   7603  C   LYS I  12      71.454  47.218  47.802  1.00 67.26           C  
ATOM   7604  O   LYS I  12      72.279  48.078  48.108  1.00 65.95           O  
ATOM   7605  CB  LYS I  12      70.873  46.133  49.987  1.00 67.94           C  
ATOM   7606  CG  LYS I  12      69.357  46.258  50.117  1.00 68.24           C  
ATOM   7607  CD  LYS I  12      68.918  46.113  51.573  1.00 68.70           C  
ATOM   7608  CE  LYS I  12      67.430  45.806  51.677  1.00 69.04           C  
ATOM   7609  NZ  LYS I  12      67.018  45.451  53.067  1.00 69.36           N  
ATOM   7610  N   PRO I  13      70.582  47.397  46.798  1.00 68.52           N  
ATOM   7611  CA  PRO I  13      70.577  48.635  46.012  1.00 69.67           C  
ATOM   7612  C   PRO I  13      70.211  49.885  46.818  1.00 70.91           C  
ATOM   7613  O   PRO I  13      69.034  50.244  46.935  1.00 70.94           O  
ATOM   7614  CB  PRO I  13      69.570  48.330  44.903  1.00 68.94           C  
ATOM   7615  CG  PRO I  13      68.602  47.400  45.579  1.00 67.98           C  
ATOM   7616  CD  PRO I  13      69.517  46.480  46.349  1.00 68.12           C  
ATOM   7617  N   ILE I  14      71.222  50.545  47.377  1.00 71.63           N  
ATOM   7618  CA  ILE I  14      70.978  51.756  48.147  1.00 71.86           C  
ATOM   7619  C   ILE I  14      70.584  52.877  47.188  1.00 71.82           C  
ATOM   7620  O   ILE I  14      71.425  53.452  46.494  1.00 71.83           O  
ATOM   7621  CB  ILE I  14      72.221  52.186  48.967  1.00 71.53           C  
ATOM   7622  CG1 ILE I  14      71.907  53.482  49.718  1.00 71.88           C  
ATOM   7623  CG2 ILE I  14      73.436  52.343  48.055  1.00 71.26           C  
ATOM   7624  CD1 ILE I  14      73.028  53.975  50.599  1.00 73.02           C  
ATOM   7625  N   GLY I  15      69.290  53.171  47.148  1.00 71.31           N  
ATOM   7626  CA  GLY I  15      68.798  54.213  46.270  1.00 70.35           C  
ATOM   7627  C   GLY I  15      67.626  53.713  45.452  1.00 68.79           C  
ATOM   7628  O   GLY I  15      67.283  52.534  45.529  1.00 69.68           O  
ATOM   7629  N   PRO I  16      66.986  54.584  44.659  1.00 67.12           N  
ATOM   7630  CA  PRO I  16      65.843  54.183  43.837  1.00 64.99           C  
ATOM   7631  C   PRO I  16      66.366  53.414  42.632  1.00 63.49           C  
ATOM   7632  O   PRO I  16      66.194  53.831  41.485  1.00 63.39           O  
ATOM   7633  CB  PRO I  16      65.228  55.516  43.453  1.00 65.55           C  
ATOM   7634  CG  PRO I  16      66.453  56.353  43.222  1.00 65.97           C  
ATOM   7635  CD  PRO I  16      67.339  55.995  44.409  1.00 66.44           C  
ATOM   7636  N   TYR I  17      67.021  52.293  42.915  1.00 60.47           N  
ATOM   7637  CA  TYR I  17      67.597  51.441  41.888  1.00 57.04           C  
ATOM   7638  C   TYR I  17      67.403  49.986  42.271  1.00 53.58           C  
ATOM   7639  O   TYR I  17      67.154  49.675  43.432  1.00 53.95           O  
ATOM   7640  CB  TYR I  17      69.085  51.737  41.751  1.00 59.83           C  
ATOM   7641  CG  TYR I  17      69.392  53.163  41.365  1.00 62.78           C  
ATOM   7642  CD1 TYR I  17      69.125  53.627  40.079  1.00 63.89           C  
ATOM   7643  CD2 TYR I  17      69.968  54.046  42.281  1.00 63.79           C  
ATOM   7644  CE1 TYR I  17      69.431  54.931  39.713  1.00 64.46           C  
ATOM   7645  CE2 TYR I  17      70.277  55.355  41.925  1.00 64.15           C  
ATOM   7646  CZ  TYR I  17      70.006  55.791  40.639  1.00 64.85           C  
ATOM   7647  OH  TYR I  17      70.314  57.084  40.275  1.00 65.54           O  
ATOM   7648  N   SER I  18      67.528  49.098  41.292  1.00 49.56           N  
ATOM   7649  CA  SER I  18      67.361  47.671  41.518  1.00 44.59           C  
ATOM   7650  C   SER I  18      68.630  46.901  41.190  1.00 44.03           C  
ATOM   7651  O   SER I  18      69.551  47.437  40.572  1.00 44.00           O  
ATOM   7652  CB  SER I  18      66.211  47.138  40.671  1.00 42.74           C  
ATOM   7653  OG  SER I  18      64.989  47.747  41.041  1.00 40.79           O  
ATOM   7654  N   GLN I  19      68.674  45.643  41.617  1.00 42.72           N  
ATOM   7655  CA  GLN I  19      69.821  44.784  41.370  1.00 41.15           C  
ATOM   7656  C   GLN I  19      69.761  44.289  39.932  1.00 40.81           C  
ATOM   7657  O   GLN I  19      70.795  44.038  39.308  1.00 40.65           O  
ATOM   7658  CB  GLN I  19      69.816  43.593  42.340  1.00 42.07           C  
ATOM   7659  CG  GLN I  19      70.084  43.978  43.799  1.00 43.23           C  
ATOM   7660  CD  GLN I  19      70.134  42.778  44.743  1.00 43.55           C  
ATOM   7661  OE1 GLN I  19      69.143  42.069  44.919  1.00 46.48           O  
ATOM   7662  NE2 GLN I  19      71.292  42.552  45.352  1.00 42.31           N  
ATOM   7663  N   ALA I  20      68.542  44.162  39.410  1.00 39.52           N  
ATOM   7664  CA  ALA I  20      68.335  43.709  38.045  1.00 38.89           C  
ATOM   7665  C   ALA I  20      66.879  43.865  37.638  1.00 39.70           C  
ATOM   7666  O   ALA I  20      65.990  43.888  38.485  1.00 40.74           O  
ATOM   7667  CB  ALA I  20      68.760  42.251  37.910  1.00 37.57           C  
ATOM   7668  N   ILE I  21      66.650  44.008  36.334  1.00 39.34           N  
ATOM   7669  CA  ILE I  21      65.307  44.134  35.782  1.00 38.94           C  
ATOM   7670  C   ILE I  21      65.162  43.052  34.725  1.00 40.07           C  
ATOM   7671  O   ILE I  21      66.133  42.697  34.049  1.00 39.66           O  
ATOM   7672  CB  ILE I  21      65.056  45.504  35.095  1.00 39.36           C  
ATOM   7673  CG1 ILE I  21      65.025  46.622  36.132  1.00 40.08           C  
ATOM   7674  CG2 ILE I  21      63.719  45.482  34.350  1.00 36.59           C  
ATOM   7675  CD1 ILE I  21      66.343  46.847  36.792  1.00 43.06           C  
ATOM   7676  N   LYS I  22      63.947  42.535  34.591  1.00 40.45           N  
ATOM   7677  CA  LYS I  22      63.654  41.490  33.627  1.00 40.30           C  
ATOM   7678  C   LYS I  22      62.572  42.015  32.724  1.00 40.39           C  
ATOM   7679  O   LYS I  22      61.475  42.323  33.176  1.00 43.49           O  
ATOM   7680  CB  LYS I  22      63.177  40.228  34.347  1.00 42.50           C  
ATOM   7681  CG  LYS I  22      63.225  38.948  33.518  1.00 46.22           C  
ATOM   7682  CD  LYS I  22      61.975  38.763  32.669  1.00 49.56           C  
ATOM   7683  CE  LYS I  22      62.010  37.431  31.916  1.00 50.50           C  
ATOM   7684  NZ  LYS I  22      62.126  36.255  32.825  1.00 51.13           N  
ATOM   7685  N   ALA I  23      62.903  42.143  31.447  1.00 39.97           N  
ATOM   7686  CA  ALA I  23      61.979  42.636  30.432  1.00 39.67           C  
ATOM   7687  C   ALA I  23      62.136  41.694  29.248  1.00 39.43           C  
ATOM   7688  O   ALA I  23      63.261  41.382  28.848  1.00 39.17           O  
ATOM   7689  CB  ALA I  23      62.351  44.046  30.034  1.00 38.32           C  
ATOM   7690  N   GLY I  24      61.021  41.247  28.680  1.00 39.33           N  
ATOM   7691  CA  GLY I  24      61.105  40.307  27.575  1.00 39.89           C  
ATOM   7692  C   GLY I  24      61.829  39.077  28.109  1.00 40.08           C  
ATOM   7693  O   GLY I  24      61.570  38.655  29.238  1.00 39.69           O  
ATOM   7694  N   ASN I  25      62.742  38.514  27.319  1.00 39.56           N  
ATOM   7695  CA  ASN I  25      63.514  37.344  27.746  1.00 38.89           C  
ATOM   7696  C   ASN I  25      64.902  37.798  28.224  1.00 36.89           C  
ATOM   7697  O   ASN I  25      65.799  36.981  28.444  1.00 33.31           O  
ATOM   7698  CB  ASN I  25      63.703  36.363  26.584  1.00 43.69           C  
ATOM   7699  CG  ASN I  25      62.406  36.038  25.856  1.00 47.91           C  
ATOM   7700  OD1 ASN I  25      62.418  35.297  24.875  1.00 51.87           O  
ATOM   7701  ND2 ASN I  25      61.290  36.582  26.327  1.00 50.36           N  
ATOM   7702  N   PHE I  26      65.071  39.107  28.388  1.00 35.21           N  
ATOM   7703  CA  PHE I  26      66.354  39.656  28.804  1.00 34.29           C  
ATOM   7704  C   PHE I  26      66.448  40.026  30.271  1.00 33.09           C  
ATOM   7705  O   PHE I  26      65.486  40.454  30.887  1.00 32.88           O  
ATOM   7706  CB  PHE I  26      66.697  40.875  27.949  1.00 32.39           C  
ATOM   7707  CG  PHE I  26      66.946  40.546  26.514  1.00 33.76           C  
ATOM   7708  CD1 PHE I  26      68.231  40.264  26.063  1.00 34.59           C  
ATOM   7709  CD2 PHE I  26      65.890  40.488  25.610  1.00 34.40           C  
ATOM   7710  CE1 PHE I  26      68.455  39.931  24.733  1.00 35.61           C  
ATOM   7711  CE2 PHE I  26      66.106  40.155  24.276  1.00 32.63           C  
ATOM   7712  CZ  PHE I  26      67.385  39.878  23.837  1.00 34.17           C  
ATOM   7713  N   LEU I  27      67.635  39.842  30.821  1.00 33.31           N  
ATOM   7714  CA  LEU I  27      67.888  40.170  32.205  1.00 33.41           C  
ATOM   7715  C   LEU I  27      68.982  41.217  32.198  1.00 33.75           C  
ATOM   7716  O   LEU I  27      70.115  40.948  31.785  1.00 33.38           O  
ATOM   7717  CB  LEU I  27      68.367  38.943  32.989  1.00 32.64           C  
ATOM   7718  CG  LEU I  27      68.445  39.242  34.485  1.00 29.57           C  
ATOM   7719  CD1 LEU I  27      67.036  39.460  34.998  1.00 30.66           C  
ATOM   7720  CD2 LEU I  27      69.112  38.117  35.228  1.00 29.52           C  
ATOM   7721  N   PHE I  28      68.633  42.417  32.642  1.00 32.64           N  
ATOM   7722  CA  PHE I  28      69.588  43.501  32.696  1.00 32.44           C  
ATOM   7723  C   PHE I  28      70.061  43.608  34.137  1.00 32.52           C  
ATOM   7724  O   PHE I  28      69.273  43.870  35.039  1.00 29.95           O  
ATOM   7725  CB  PHE I  28      68.926  44.799  32.233  1.00 32.22           C  
ATOM   7726  CG  PHE I  28      68.675  44.862  30.745  1.00 32.81           C  
ATOM   7727  CD1 PHE I  28      69.642  45.380  29.884  1.00 32.83           C  
ATOM   7728  CD2 PHE I  28      67.470  44.412  30.203  1.00 32.27           C  
ATOM   7729  CE1 PHE I  28      69.408  45.453  28.517  1.00 31.86           C  
ATOM   7730  CE2 PHE I  28      67.230  44.478  28.835  1.00 28.90           C  
ATOM   7731  CZ  PHE I  28      68.197  44.999  27.993  1.00 30.94           C  
ATOM   7732  N   ILE I  29      71.352  43.382  34.348  1.00 34.79           N  
ATOM   7733  CA  ILE I  29      71.923  43.441  35.685  1.00 36.93           C  
ATOM   7734  C   ILE I  29      72.720  44.721  35.940  1.00 39.52           C  
ATOM   7735  O   ILE I  29      73.622  45.065  35.179  1.00 39.86           O  
ATOM   7736  CB  ILE I  29      72.848  42.235  35.941  1.00 35.66           C  
ATOM   7737  CG1 ILE I  29      72.081  40.922  35.735  1.00 34.65           C  
ATOM   7738  CG2 ILE I  29      73.401  42.308  37.349  1.00 35.35           C  
ATOM   7739  CD1 ILE I  29      72.929  39.677  35.923  1.00 30.69           C  
ATOM   7740  N   ALA I  30      72.392  45.416  37.025  1.00 41.72           N  
ATOM   7741  CA  ALA I  30      73.094  46.644  37.380  1.00 43.79           C  
ATOM   7742  C   ALA I  30      74.570  46.375  37.666  1.00 44.87           C  
ATOM   7743  O   ALA I  30      74.938  45.293  38.114  1.00 43.59           O  
ATOM   7744  CB  ALA I  30      72.439  47.289  38.602  1.00 43.46           C  
ATOM   7745  N   GLY I  31      75.409  47.375  37.405  1.00 48.21           N  
ATOM   7746  CA  GLY I  31      76.835  47.239  37.645  1.00 50.44           C  
ATOM   7747  C   GLY I  31      77.123  46.909  39.095  1.00 52.92           C  
ATOM   7748  O   GLY I  31      76.751  47.653  40.000  1.00 53.47           O  
ATOM   7749  N   GLN I  32      77.789  45.785  39.323  1.00 54.88           N  
ATOM   7750  CA  GLN I  32      78.109  45.360  40.673  1.00 56.12           C  
ATOM   7751  C   GLN I  32      79.534  45.737  41.043  1.00 57.76           C  
ATOM   7752  O   GLN I  32      80.369  45.980  40.173  1.00 57.67           O  
ATOM   7753  CB  GLN I  32      77.942  43.845  40.786  1.00 57.29           C  
ATOM   7754  CG  GLN I  32      76.551  43.358  40.481  1.00 56.99           C  
ATOM   7755  CD  GLN I  32      75.532  43.933  41.432  1.00 58.88           C  
ATOM   7756  OE1 GLN I  32      75.700  43.864  42.649  1.00 59.34           O  
ATOM   7757  NE2 GLN I  32      74.466  44.503  40.886  1.00 59.64           N  
ATOM   7758  N   ILE I  33      79.804  45.794  42.342  1.00 59.45           N  
ATOM   7759  CA  ILE I  33      81.135  46.106  42.835  1.00 61.38           C  
ATOM   7760  C   ILE I  33      81.471  45.120  43.943  1.00 62.73           C  
ATOM   7761  O   ILE I  33      80.576  44.561  44.576  1.00 62.92           O  
ATOM   7762  CB  ILE I  33      81.226  47.544  43.378  1.00 61.79           C  
ATOM   7763  CG1 ILE I  33      80.240  47.735  44.530  1.00 61.93           C  
ATOM   7764  CG2 ILE I  33      80.954  48.536  42.255  1.00 61.71           C  
ATOM   7765  CD1 ILE I  33      80.284  49.120  45.134  1.00 62.11           C  
ATOM   7766  N   PRO I  34      82.769  44.892  44.191  1.00 64.01           N  
ATOM   7767  CA  PRO I  34      83.211  43.957  45.231  1.00 65.94           C  
ATOM   7768  C   PRO I  34      82.736  44.328  46.636  1.00 67.89           C  
ATOM   7769  O   PRO I  34      83.471  44.935  47.417  1.00 67.68           O  
ATOM   7770  CB  PRO I  34      84.729  43.997  45.097  1.00 65.73           C  
ATOM   7771  CG  PRO I  34      84.976  45.416  44.690  1.00 65.17           C  
ATOM   7772  CD  PRO I  34      83.913  45.640  43.641  1.00 63.59           C  
ATOM   7773  N   ILE I  35      81.496  43.962  46.942  1.00 69.64           N  
ATOM   7774  CA  ILE I  35      80.905  44.229  48.246  1.00 71.25           C  
ATOM   7775  C   ILE I  35      80.281  42.943  48.755  1.00 73.13           C  
ATOM   7776  O   ILE I  35      79.451  42.341  48.072  1.00 71.98           O  
ATOM   7777  CB  ILE I  35      79.801  45.298  48.165  1.00 71.84           C  
ATOM   7778  CG1 ILE I  35      80.422  46.673  47.927  1.00 72.48           C  
ATOM   7779  CG2 ILE I  35      78.977  45.293  49.442  1.00 71.59           C  
ATOM   7780  CD1 ILE I  35      79.412  47.807  47.960  1.00 71.67           C  
ATOM   7781  N   ASP I  36      80.680  42.525  49.954  1.00 76.20           N  
ATOM   7782  CA  ASP I  36      80.149  41.303  50.550  1.00 78.01           C  
ATOM   7783  C   ASP I  36      78.678  41.451  50.925  1.00 78.34           C  
ATOM   7784  O   ASP I  36      78.313  42.318  51.718  1.00 78.19           O  
ATOM   7785  CB  ASP I  36      80.951  40.921  51.794  1.00 78.91           C  
ATOM   7786  CG  ASP I  36      80.360  39.724  52.513  1.00 80.63           C  
ATOM   7787  OD1 ASP I  36      80.202  38.664  51.867  1.00 80.92           O  
ATOM   7788  OD2 ASP I  36      80.048  39.846  53.718  1.00 81.22           O  
ATOM   7789  N   PRO I  37      77.815  40.591  50.367  1.00 79.44           N  
ATOM   7790  CA  PRO I  37      76.374  40.624  50.638  1.00 80.34           C  
ATOM   7791  C   PRO I  37      76.031  40.434  52.116  1.00 80.93           C  
ATOM   7792  O   PRO I  37      74.956  40.830  52.571  1.00 81.01           O  
ATOM   7793  CB  PRO I  37      75.840  39.490  49.764  1.00 80.11           C  
ATOM   7794  CG  PRO I  37      76.972  38.507  49.773  1.00 80.05           C  
ATOM   7795  CD  PRO I  37      78.168  39.408  49.560  1.00 79.98           C  
ATOM   7796  N   LYS I  38      76.953  39.827  52.857  1.00 81.24           N  
ATOM   7797  CA  LYS I  38      76.755  39.577  54.278  1.00 81.28           C  
ATOM   7798  C   LYS I  38      77.037  40.831  55.099  1.00 81.77           C  
ATOM   7799  O   LYS I  38      76.144  41.360  55.764  1.00 82.34           O  
ATOM   7800  CB  LYS I  38      77.654  38.434  54.737  1.00 79.61           C  
ATOM   7801  N   THR I  39      78.279  41.304  55.048  1.00 81.88           N  
ATOM   7802  CA  THR I  39      78.674  42.494  55.798  1.00 81.72           C  
ATOM   7803  C   THR I  39      78.169  43.768  55.118  1.00 81.65           C  
ATOM   7804  O   THR I  39      77.258  44.438  55.614  1.00 81.49           O  
ATOM   7805  CB  THR I  39      80.221  42.581  55.951  1.00 81.70           C  
ATOM   7806  OG1 THR I  39      80.818  42.948  54.701  1.00 81.09           O  
ATOM   7807  CG2 THR I  39      80.789  41.238  56.395  1.00 80.18           C  
ATOM   7808  N   GLY I  40      78.758  44.084  53.972  1.00 81.27           N  
ATOM   7809  CA  GLY I  40      78.382  45.276  53.237  1.00 80.37           C  
ATOM   7810  C   GLY I  40      79.617  46.137  53.075  1.00 80.29           C  
ATOM   7811  O   GLY I  40      79.529  47.354  52.896  1.00 80.07           O  
ATOM   7812  N   GLU I  41      80.777  45.489  53.145  1.00 80.28           N  
ATOM   7813  CA  GLU I  41      82.063  46.166  53.019  1.00 80.16           C  
ATOM   7814  C   GLU I  41      82.854  45.624  51.823  1.00 79.59           C  
ATOM   7815  O   GLU I  41      82.523  44.571  51.272  1.00 79.46           O  
ATOM   7816  CB  GLU I  41      82.887  45.972  54.298  1.00 80.66           C  
ATOM   7817  CG  GLU I  41      82.174  46.330  55.605  1.00 81.48           C  
ATOM   7818  CD  GLU I  41      81.680  47.769  55.648  1.00 81.40           C  
ATOM   7819  OE1 GLU I  41      82.422  48.675  55.211  1.00 81.74           O  
ATOM   7820  OE2 GLU I  41      80.550  47.995  56.133  1.00 81.11           O  
ATOM   7821  N   ILE I  42      83.902  46.349  51.437  1.00 78.56           N  
ATOM   7822  CA  ILE I  42      84.748  45.951  50.316  1.00 77.56           C  
ATOM   7823  C   ILE I  42      85.555  44.722  50.701  1.00 77.57           C  
ATOM   7824  O   ILE I  42      86.315  44.753  51.665  1.00 77.98           O  
ATOM   7825  CB  ILE I  42      85.722  47.077  49.919  1.00 77.18           C  
ATOM   7826  CG1 ILE I  42      84.937  48.345  49.576  1.00 76.19           C  
ATOM   7827  CG2 ILE I  42      86.569  46.637  48.731  1.00 76.61           C  
ATOM   7828  CD1 ILE I  42      85.811  49.519  49.204  1.00 75.90           C  
ATOM   7829  N   VAL I  43      85.390  43.646  49.938  1.00 77.71           N  
ATOM   7830  CA  VAL I  43      86.086  42.392  50.197  1.00 77.59           C  
ATOM   7831  C   VAL I  43      87.606  42.578  50.221  1.00 78.27           C  
ATOM   7832  O   VAL I  43      88.365  41.607  50.177  1.00 78.86           O  
ATOM   7833  CB  VAL I  43      85.706  41.326  49.135  1.00 76.55           C  
ATOM   7834  CG1 VAL I  43      86.370  41.648  47.811  1.00 76.96           C  
ATOM   7835  CG2 VAL I  43      86.088  39.943  49.617  1.00 76.87           C  
ATOM   7836  N   LYS I  44      88.044  43.830  50.295  1.00 78.35           N  
ATOM   7837  CA  LYS I  44      89.465  44.140  50.335  1.00 78.82           C  
ATOM   7838  C   LYS I  44      90.194  43.425  49.206  1.00 78.65           C  
ATOM   7839  O   LYS I  44      89.886  43.631  48.033  1.00 79.01           O  
ATOM   7840  CB  LYS I  44      90.054  43.726  51.687  1.00 78.36           C  
ATOM   7841  N   GLY I  45      91.156  42.581  49.567  1.00 78.19           N  
ATOM   7842  CA  GLY I  45      91.911  41.851  48.567  1.00 77.67           C  
ATOM   7843  C   GLY I  45      92.586  42.762  47.558  1.00 77.29           C  
ATOM   7844  O   GLY I  45      92.455  43.984  47.616  1.00 78.11           O  
ATOM   7845  N   ASP I  46      93.309  42.162  46.620  1.00 76.42           N  
ATOM   7846  CA  ASP I  46      94.012  42.917  45.594  1.00 75.90           C  
ATOM   7847  C   ASP I  46      93.081  43.396  44.479  1.00 74.31           C  
ATOM   7848  O   ASP I  46      92.546  44.504  44.533  1.00 73.84           O  
ATOM   7849  CB  ASP I  46      95.138  42.054  45.015  1.00 78.32           C  
ATOM   7850  CG  ASP I  46      95.749  42.646  43.758  1.00 80.73           C  
ATOM   7851  OD1 ASP I  46      96.078  43.855  43.754  1.00 81.32           O  
ATOM   7852  OD2 ASP I  46      95.905  41.887  42.776  1.00 82.02           O  
ATOM   7853  N   ILE I  47      92.899  42.553  43.470  1.00 71.99           N  
ATOM   7854  CA  ILE I  47      92.046  42.862  42.331  1.00 70.01           C  
ATOM   7855  C   ILE I  47      91.351  41.562  41.927  1.00 68.89           C  
ATOM   7856  O   ILE I  47      90.203  41.564  41.480  1.00 68.64           O  
ATOM   7857  CB  ILE I  47      92.887  43.417  41.143  1.00 69.24           C  
ATOM   7858  CG1 ILE I  47      91.997  43.688  39.928  1.00 68.84           C  
ATOM   7859  CG2 ILE I  47      93.981  42.437  40.776  1.00 68.05           C  
ATOM   7860  CD1 ILE I  47      91.105  44.894  40.070  1.00 68.72           C  
ATOM   7861  N   LYS I  48      92.055  40.449  42.103  1.00 67.41           N  
ATOM   7862  CA  LYS I  48      91.511  39.137  41.779  1.00 65.98           C  
ATOM   7863  C   LYS I  48      90.405  38.803  42.775  1.00 65.13           C  
ATOM   7864  O   LYS I  48      89.483  38.049  42.466  1.00 63.79           O  
ATOM   7865  CB  LYS I  48      92.612  38.085  41.844  1.00 65.69           C  
ATOM   7866  N   ASP I  49      90.508  39.378  43.972  1.00 65.14           N  
ATOM   7867  CA  ASP I  49      89.531  39.152  45.027  1.00 65.09           C  
ATOM   7868  C   ASP I  49      88.270  39.955  44.740  1.00 63.54           C  
ATOM   7869  O   ASP I  49      87.154  39.524  45.055  1.00 62.29           O  
ATOM   7870  CB  ASP I  49      90.117  39.555  46.389  1.00 68.17           C  
ATOM   7871  CG  ASP I  49      90.158  38.391  47.382  1.00 70.62           C  
ATOM   7872  OD1 ASP I  49      89.080  37.842  47.708  1.00 73.23           O  
ATOM   7873  OD2 ASP I  49      91.266  38.024  47.835  1.00 70.59           O  
ATOM   7874  N   GLN I  50      88.453  41.126  44.139  1.00 61.78           N  
ATOM   7875  CA  GLN I  50      87.323  41.971  43.796  1.00 59.01           C  
ATOM   7876  C   GLN I  50      86.646  41.423  42.547  1.00 57.10           C  
ATOM   7877  O   GLN I  50      85.418  41.414  42.453  1.00 57.92           O  
ATOM   7878  CB  GLN I  50      87.780  43.409  43.584  1.00 59.35           C  
ATOM   7879  CG  GLN I  50      88.298  44.055  44.855  1.00 59.83           C  
ATOM   7880  CD  GLN I  50      88.395  45.562  44.753  1.00 60.36           C  
ATOM   7881  OE1 GLN I  50      88.740  46.236  45.720  1.00 60.13           O  
ATOM   7882  NE2 GLN I  50      88.089  46.102  43.579  1.00 61.37           N  
ATOM   7883  N   THR I  51      87.440  40.955  41.591  1.00 53.93           N  
ATOM   7884  CA  THR I  51      86.863  40.376  40.383  1.00 52.25           C  
ATOM   7885  C   THR I  51      86.053  39.172  40.840  1.00 51.34           C  
ATOM   7886  O   THR I  51      84.863  39.048  40.542  1.00 51.73           O  
ATOM   7887  CB  THR I  51      87.950  39.900  39.403  1.00 51.87           C  
ATOM   7888  OG1 THR I  51      88.761  41.015  39.012  1.00 52.55           O  
ATOM   7889  CG2 THR I  51      87.314  39.281  38.162  1.00 51.62           C  
ATOM   7890  N   ARG I  52      86.722  38.295  41.580  1.00 50.09           N  
ATOM   7891  CA  ARG I  52      86.113  37.091  42.127  1.00 48.47           C  
ATOM   7892  C   ARG I  52      84.785  37.449  42.786  1.00 48.83           C  
ATOM   7893  O   ARG I  52      83.759  36.833  42.508  1.00 48.74           O  
ATOM   7894  CB  ARG I  52      87.046  36.478  43.174  1.00 46.66           C  
ATOM   7895  CG  ARG I  52      86.589  35.146  43.746  1.00 45.96           C  
ATOM   7896  CD  ARG I  52      87.164  34.002  42.946  1.00 45.19           C  
ATOM   7897  NE  ARG I  52      88.622  34.063  42.952  1.00 44.22           N  
ATOM   7898  CZ  ARG I  52      89.398  33.333  42.159  1.00 45.50           C  
ATOM   7899  NH1 ARG I  52      90.721  33.452  42.234  1.00 45.22           N  
ATOM   7900  NH2 ARG I  52      88.850  32.491  41.285  1.00 42.11           N  
ATOM   7901  N   GLN I  53      84.815  38.457  43.655  1.00 49.11           N  
ATOM   7902  CA  GLN I  53      83.621  38.885  44.373  1.00 50.25           C  
ATOM   7903  C   GLN I  53      82.533  39.411  43.446  1.00 51.23           C  
ATOM   7904  O   GLN I  53      81.369  39.007  43.556  1.00 51.66           O  
ATOM   7905  CB  GLN I  53      83.979  39.956  45.409  1.00 51.17           C  
ATOM   7906  CG  GLN I  53      82.834  40.308  46.369  1.00 51.68           C  
ATOM   7907  CD  GLN I  53      82.388  39.118  47.207  1.00 52.31           C  
ATOM   7908  OE1 GLN I  53      83.198  38.485  47.877  1.00 55.44           O  
ATOM   7909  NE2 GLN I  53      81.098  38.815  47.175  1.00 51.49           N  
ATOM   7910  N   VAL I  54      82.913  40.318  42.545  1.00 50.45           N  
ATOM   7911  CA  VAL I  54      81.972  40.900  41.592  1.00 49.14           C  
ATOM   7912  C   VAL I  54      81.230  39.793  40.851  1.00 47.68           C  
ATOM   7913  O   VAL I  54      80.001  39.746  40.834  1.00 45.88           O  
ATOM   7914  CB  VAL I  54      82.709  41.793  40.560  1.00 50.06           C  
ATOM   7915  CG1 VAL I  54      81.735  42.301  39.496  1.00 49.04           C  
ATOM   7916  CG2 VAL I  54      83.355  42.968  41.267  1.00 50.07           C  
ATOM   7917  N   LEU I  55      81.992  38.894  40.250  1.00 48.28           N  
ATOM   7918  CA  LEU I  55      81.410  37.791  39.506  1.00 49.64           C  
ATOM   7919  C   LEU I  55      80.392  37.020  40.347  1.00 50.17           C  
ATOM   7920  O   LEU I  55      79.291  36.707  39.879  1.00 49.99           O  
ATOM   7921  CB  LEU I  55      82.529  36.879  38.998  1.00 49.20           C  
ATOM   7922  CG  LEU I  55      83.385  37.583  37.932  1.00 49.50           C  
ATOM   7923  CD1 LEU I  55      84.677  36.825  37.674  1.00 50.12           C  
ATOM   7924  CD2 LEU I  55      82.572  37.714  36.660  1.00 47.92           C  
ATOM   7925  N   GLU I  56      80.746  36.726  41.593  1.00 50.51           N  
ATOM   7926  CA  GLU I  56      79.829  36.012  42.467  1.00 50.42           C  
ATOM   7927  C   GLU I  56      78.578  36.853  42.732  1.00 49.95           C  
ATOM   7928  O   GLU I  56      77.464  36.330  42.716  1.00 50.34           O  
ATOM   7929  CB  GLU I  56      80.522  35.641  43.784  1.00 52.21           C  
ATOM   7930  CG  GLU I  56      81.501  34.469  43.664  1.00 54.51           C  
ATOM   7931  CD  GLU I  56      80.825  33.166  43.233  1.00 55.88           C  
ATOM   7932  OE1 GLU I  56      79.927  32.681  43.955  1.00 57.70           O  
ATOM   7933  OE2 GLU I  56      81.188  32.619  42.174  1.00 55.87           O  
ATOM   7934  N   ASN I  57      78.755  38.152  42.966  1.00 49.12           N  
ATOM   7935  CA  ASN I  57      77.609  39.032  43.208  1.00 48.57           C  
ATOM   7936  C   ASN I  57      76.642  38.949  42.038  1.00 46.96           C  
ATOM   7937  O   ASN I  57      75.425  39.009  42.205  1.00 47.05           O  
ATOM   7938  CB  ASN I  57      78.065  40.484  43.374  1.00 50.09           C  
ATOM   7939  CG  ASN I  57      78.763  40.724  44.689  1.00 50.45           C  
ATOM   7940  OD1 ASN I  57      78.187  40.516  45.754  1.00 51.95           O  
ATOM   7941  ND2 ASN I  57      80.010  41.166  44.624  1.00 51.82           N  
ATOM   7942  N   ILE I  58      77.203  38.813  40.847  1.00 45.98           N  
ATOM   7943  CA  ILE I  58      76.405  38.719  39.639  1.00 44.96           C  
ATOM   7944  C   ILE I  58      75.686  37.377  39.571  1.00 44.68           C  
ATOM   7945  O   ILE I  58      74.496  37.321  39.248  1.00 43.37           O  
ATOM   7946  CB  ILE I  58      77.294  38.879  38.397  1.00 45.46           C  
ATOM   7947  CG1 ILE I  58      78.064  40.199  38.489  1.00 45.51           C  
ATOM   7948  CG2 ILE I  58      76.442  38.833  37.134  1.00 46.17           C  
ATOM   7949  CD1 ILE I  58      79.102  40.390  37.403  1.00 45.11           C  
ATOM   7950  N   LYS I  59      76.410  36.301  39.884  1.00 44.44           N  
ATOM   7951  CA  LYS I  59      75.840  34.958  39.846  1.00 45.62           C  
ATOM   7952  C   LYS I  59      74.597  34.855  40.726  1.00 45.28           C  
ATOM   7953  O   LYS I  59      73.567  34.320  40.307  1.00 45.09           O  
ATOM   7954  CB  LYS I  59      76.872  33.924  40.301  1.00 47.98           C  
ATOM   7955  CG  LYS I  59      76.411  32.486  40.104  1.00 52.15           C  
ATOM   7956  CD  LYS I  59      76.961  31.540  41.172  1.00 55.41           C  
ATOM   7957  CE  LYS I  59      78.481  31.502  41.175  1.00 58.18           C  
ATOM   7958  NZ  LYS I  59      79.017  30.521  42.170  1.00 59.42           N  
ATOM   7959  N   ALA I  60      74.700  35.372  41.947  1.00 44.10           N  
ATOM   7960  CA  ALA I  60      73.589  35.350  42.887  1.00 43.67           C  
ATOM   7961  C   ALA I  60      72.337  35.996  42.301  1.00 44.60           C  
ATOM   7962  O   ALA I  60      71.239  35.440  42.402  1.00 44.79           O  
ATOM   7963  CB  ALA I  60      73.985  36.058  44.157  1.00 43.98           C  
ATOM   7964  N   ILE I  61      72.502  37.172  41.695  1.00 44.13           N  
ATOM   7965  CA  ILE I  61      71.380  37.895  41.084  1.00 44.02           C  
ATOM   7966  C   ILE I  61      70.810  37.111  39.898  1.00 43.01           C  
ATOM   7967  O   ILE I  61      69.602  37.101  39.662  1.00 41.82           O  
ATOM   7968  CB  ILE I  61      71.826  39.288  40.585  1.00 45.26           C  
ATOM   7969  CG1 ILE I  61      72.594  40.011  41.689  1.00 45.62           C  
ATOM   7970  CG2 ILE I  61      70.617  40.107  40.169  1.00 45.48           C  
ATOM   7971  CD1 ILE I  61      73.137  41.356  41.275  1.00 47.27           C  
ATOM   7972  N   LEU I  62      71.696  36.463  39.151  1.00 43.05           N  
ATOM   7973  CA  LEU I  62      71.297  35.662  38.000  1.00 44.63           C  
ATOM   7974  C   LEU I  62      70.327  34.579  38.437  1.00 46.30           C  
ATOM   7975  O   LEU I  62      69.217  34.470  37.911  1.00 45.91           O  
ATOM   7976  CB  LEU I  62      72.521  35.001  37.374  1.00 44.22           C  
ATOM   7977  CG  LEU I  62      73.300  35.788  36.332  1.00 41.79           C  
ATOM   7978  CD1 LEU I  62      74.699  35.234  36.201  1.00 43.11           C  
ATOM   7979  CD2 LEU I  62      72.559  35.716  35.021  1.00 41.77           C  
ATOM   7980  N   GLU I  63      70.776  33.782  39.404  1.00 48.31           N  
ATOM   7981  CA  GLU I  63      69.997  32.683  39.965  1.00 50.57           C  
ATOM   7982  C   GLU I  63      68.625  33.162  40.439  1.00 50.68           C  
ATOM   7983  O   GLU I  63      67.594  32.593  40.072  1.00 50.20           O  
ATOM   7984  CB  GLU I  63      70.776  32.057  41.125  1.00 52.48           C  
ATOM   7985  CG  GLU I  63      72.249  31.837  40.785  1.00 56.31           C  
ATOM   7986  CD  GLU I  63      73.092  31.345  41.954  1.00 58.92           C  
ATOM   7987  OE1 GLU I  63      72.976  31.910  43.067  1.00 58.96           O  
ATOM   7988  OE2 GLU I  63      73.885  30.397  41.749  1.00 59.63           O  
ATOM   7989  N   ALA I  64      68.613  34.218  41.246  1.00 50.44           N  
ATOM   7990  CA  ALA I  64      67.364  34.774  41.757  1.00 51.65           C  
ATOM   7991  C   ALA I  64      66.274  34.919  40.681  1.00 52.82           C  
ATOM   7992  O   ALA I  64      65.075  34.851  40.987  1.00 51.98           O  
ATOM   7993  CB  ALA I  64      67.637  36.122  42.404  1.00 50.66           C  
ATOM   7994  N   ALA I  65      66.688  35.114  39.429  1.00 53.29           N  
ATOM   7995  CA  ALA I  65      65.743  35.281  38.323  1.00 52.86           C  
ATOM   7996  C   ALA I  65      65.614  34.028  37.463  1.00 53.70           C  
ATOM   7997  O   ALA I  65      65.001  34.057  36.395  1.00 53.89           O  
ATOM   7998  CB  ALA I  65      66.165  36.453  37.464  1.00 51.36           C  
ATOM   7999  N   GLY I  66      66.192  32.927  37.933  1.00 53.55           N  
ATOM   8000  CA  GLY I  66      66.124  31.684  37.185  1.00 53.52           C  
ATOM   8001  C   GLY I  66      67.043  31.705  35.981  1.00 52.71           C  
ATOM   8002  O   GLY I  66      66.716  31.174  34.922  1.00 54.06           O  
ATOM   8003  N   TYR I  67      68.204  32.322  36.150  1.00 51.74           N  
ATOM   8004  CA  TYR I  67      69.178  32.428  35.072  1.00 50.44           C  
ATOM   8005  C   TYR I  67      70.494  31.767  35.460  1.00 49.72           C  
ATOM   8006  O   TYR I  67      70.930  31.851  36.602  1.00 49.24           O  
ATOM   8007  CB  TYR I  67      69.427  33.907  34.746  1.00 49.52           C  
ATOM   8008  CG  TYR I  67      68.359  34.569  33.897  1.00 48.35           C  
ATOM   8009  CD1 TYR I  67      68.570  34.786  32.538  1.00 47.99           C  
ATOM   8010  CD2 TYR I  67      67.150  34.995  34.451  1.00 47.16           C  
ATOM   8011  CE1 TYR I  67      67.616  35.412  31.749  1.00 46.53           C  
ATOM   8012  CE2 TYR I  67      66.182  35.621  33.665  1.00 46.36           C  
ATOM   8013  CZ  TYR I  67      66.426  35.827  32.311  1.00 47.03           C  
ATOM   8014  OH  TYR I  67      65.489  36.434  31.501  1.00 46.82           O  
ATOM   8015  N   SER I  68      71.126  31.100  34.504  1.00 49.73           N  
ATOM   8016  CA  SER I  68      72.404  30.458  34.768  1.00 51.25           C  
ATOM   8017  C   SER I  68      73.505  31.412  34.315  1.00 51.02           C  
ATOM   8018  O   SER I  68      73.223  32.550  33.941  1.00 51.95           O  
ATOM   8019  CB  SER I  68      72.500  29.138  34.001  1.00 52.45           C  
ATOM   8020  OG  SER I  68      72.169  29.316  32.636  1.00 55.38           O  
ATOM   8021  N   LEU I  69      74.757  30.969  34.364  1.00 49.99           N  
ATOM   8022  CA  LEU I  69      75.851  31.822  33.924  1.00 49.20           C  
ATOM   8023  C   LEU I  69      76.005  31.727  32.411  1.00 49.49           C  
ATOM   8024  O   LEU I  69      76.543  32.638  31.782  1.00 50.21           O  
ATOM   8025  CB  LEU I  69      77.173  31.432  34.595  1.00 48.54           C  
ATOM   8026  CG  LEU I  69      77.575  32.135  35.897  1.00 47.17           C  
ATOM   8027  CD1 LEU I  69      78.973  31.704  36.282  1.00 47.09           C  
ATOM   8028  CD2 LEU I  69      77.549  33.638  35.714  1.00 46.71           C  
ATOM   8029  N   ASN I  70      75.519  30.636  31.825  1.00 49.00           N  
ATOM   8030  CA  ASN I  70      75.633  30.453  30.382  1.00 49.24           C  
ATOM   8031  C   ASN I  70      74.511  31.169  29.624  1.00 47.54           C  
ATOM   8032  O   ASN I  70      74.324  30.977  28.421  1.00 47.60           O  
ATOM   8033  CB  ASN I  70      75.676  28.953  30.042  1.00 51.96           C  
ATOM   8034  CG  ASN I  70      74.422  28.465  29.345  1.00 55.49           C  
ATOM   8035  OD1 ASN I  70      74.490  27.901  28.248  1.00 57.22           O  
ATOM   8036  ND2 ASN I  70      73.267  28.672  29.979  1.00 57.91           N  
ATOM   8037  N   ASP I  71      73.778  32.012  30.345  1.00 45.45           N  
ATOM   8038  CA  ASP I  71      72.686  32.797  29.770  1.00 42.30           C  
ATOM   8039  C   ASP I  71      73.173  34.214  29.487  1.00 39.43           C  
ATOM   8040  O   ASP I  71      72.483  35.004  28.852  1.00 36.54           O  
ATOM   8041  CB  ASP I  71      71.514  32.863  30.742  1.00 44.01           C  
ATOM   8042  CG  ASP I  71      70.699  31.605  30.747  1.00 43.97           C  
ATOM   8043  OD1 ASP I  71      69.884  31.433  31.674  1.00 47.07           O  
ATOM   8044  OD2 ASP I  71      70.866  30.795  29.817  1.00 44.01           O  
ATOM   8045  N   VAL I  72      74.370  34.522  29.969  1.00 37.74           N  
ATOM   8046  CA  VAL I  72      74.962  35.838  29.791  1.00 36.90           C  
ATOM   8047  C   VAL I  72      75.434  36.078  28.354  1.00 36.14           C  
ATOM   8048  O   VAL I  72      76.339  35.404  27.855  1.00 34.83           O  
ATOM   8049  CB  VAL I  72      76.136  36.027  30.768  1.00 35.79           C  
ATOM   8050  CG1 VAL I  72      76.618  37.465  30.739  1.00 35.78           C  
ATOM   8051  CG2 VAL I  72      75.695  35.644  32.165  1.00 35.93           C  
ATOM   8052  N   ILE I  73      74.810  37.054  27.695  1.00 35.55           N  
ATOM   8053  CA  ILE I  73      75.149  37.390  26.318  1.00 32.90           C  
ATOM   8054  C   ILE I  73      76.113  38.568  26.155  1.00 31.75           C  
ATOM   8055  O   ILE I  73      76.882  38.597  25.200  1.00 33.19           O  
ATOM   8056  CB  ILE I  73      73.880  37.658  25.510  1.00 31.92           C  
ATOM   8057  CG1 ILE I  73      73.037  38.734  26.193  1.00 31.70           C  
ATOM   8058  CG2 ILE I  73      73.075  36.381  25.395  1.00 32.73           C  
ATOM   8059  CD1 ILE I  73      71.738  39.015  25.473  1.00 31.08           C  
ATOM   8060  N   LYS I  74      76.081  39.522  27.082  1.00 29.42           N  
ATOM   8061  CA  LYS I  74      76.961  40.685  27.025  1.00 28.47           C  
ATOM   8062  C   LYS I  74      77.448  41.120  28.413  1.00 28.82           C  
ATOM   8063  O   LYS I  74      76.693  41.135  29.387  1.00 27.87           O  
ATOM   8064  CB  LYS I  74      76.242  41.865  26.354  1.00 30.80           C  
ATOM   8065  CG  LYS I  74      77.103  43.126  26.234  1.00 31.55           C  
ATOM   8066  CD  LYS I  74      76.276  44.352  25.882  1.00 35.98           C  
ATOM   8067  CE  LYS I  74      77.117  45.620  25.969  1.00 38.25           C  
ATOM   8068  NZ  LYS I  74      76.284  46.860  26.016  1.00 40.22           N  
ATOM   8069  N   VAL I  75      78.716  41.499  28.488  1.00 27.69           N  
ATOM   8070  CA  VAL I  75      79.314  41.922  29.741  1.00 26.88           C  
ATOM   8071  C   VAL I  75      80.171  43.149  29.509  1.00 28.12           C  
ATOM   8072  O   VAL I  75      80.844  43.262  28.480  1.00 29.23           O  
ATOM   8073  CB  VAL I  75      80.205  40.792  30.339  1.00 26.09           C  
ATOM   8074  CG1 VAL I  75      81.016  41.308  31.503  1.00 24.58           C  
ATOM   8075  CG2 VAL I  75      79.335  39.640  30.798  1.00 26.05           C  
ATOM   8076  N   THR I  76      80.133  44.075  30.458  1.00 27.97           N  
ATOM   8077  CA  THR I  76      80.938  45.272  30.362  1.00 32.01           C  
ATOM   8078  C   THR I  76      81.716  45.446  31.660  1.00 32.41           C  
ATOM   8079  O   THR I  76      81.147  45.536  32.744  1.00 28.90           O  
ATOM   8080  CB  THR I  76      80.075  46.514  30.075  1.00 35.35           C  
ATOM   8081  OG1 THR I  76      79.363  46.315  28.844  1.00 40.64           O  
ATOM   8082  CG2 THR I  76      80.960  47.760  29.925  1.00 37.27           C  
ATOM   8083  N   VAL I  77      83.036  45.470  31.528  1.00 35.28           N  
ATOM   8084  CA  VAL I  77      83.934  45.606  32.662  1.00 37.24           C  
ATOM   8085  C   VAL I  77      84.631  46.965  32.688  1.00 38.06           C  
ATOM   8086  O   VAL I  77      85.364  47.318  31.764  1.00 37.08           O  
ATOM   8087  CB  VAL I  77      85.006  44.497  32.634  1.00 36.84           C  
ATOM   8088  CG1 VAL I  77      85.918  44.624  33.849  1.00 38.09           C  
ATOM   8089  CG2 VAL I  77      84.335  43.132  32.596  1.00 36.80           C  
ATOM   8090  N   TYR I  78      84.375  47.727  33.745  1.00 39.69           N  
ATOM   8091  CA  TYR I  78      84.988  49.036  33.911  1.00 41.95           C  
ATOM   8092  C   TYR I  78      86.092  48.904  34.955  1.00 43.46           C  
ATOM   8093  O   TYR I  78      85.824  48.619  36.123  1.00 44.20           O  
ATOM   8094  CB  TYR I  78      83.962  50.075  34.390  1.00 41.74           C  
ATOM   8095  CG  TYR I  78      82.768  50.292  33.480  1.00 40.52           C  
ATOM   8096  CD1 TYR I  78      81.646  49.473  33.565  1.00 41.26           C  
ATOM   8097  CD2 TYR I  78      82.751  51.332  32.555  1.00 39.83           C  
ATOM   8098  CE1 TYR I  78      80.534  49.686  32.760  1.00 39.98           C  
ATOM   8099  CE2 TYR I  78      81.646  51.551  31.743  1.00 40.61           C  
ATOM   8100  CZ  TYR I  78      80.539  50.726  31.850  1.00 41.97           C  
ATOM   8101  OH  TYR I  78      79.429  50.941  31.054  1.00 44.22           O  
ATOM   8102  N   LEU I  79      87.332  49.101  34.526  1.00 46.95           N  
ATOM   8103  CA  LEU I  79      88.480  49.009  35.420  1.00 49.31           C  
ATOM   8104  C   LEU I  79      88.975  50.399  35.778  1.00 51.44           C  
ATOM   8105  O   LEU I  79      88.734  51.363  35.047  1.00 51.33           O  
ATOM   8106  CB  LEU I  79      89.615  48.225  34.763  1.00 48.58           C  
ATOM   8107  CG  LEU I  79      89.355  46.755  34.452  1.00 49.43           C  
ATOM   8108  CD1 LEU I  79      90.623  46.131  33.910  1.00 49.57           C  
ATOM   8109  CD2 LEU I  79      88.902  46.030  35.710  1.00 50.11           C  
ATOM   8110  N   LYS I  80      89.662  50.495  36.912  1.00 54.83           N  
ATOM   8111  CA  LYS I  80      90.202  51.763  37.375  1.00 58.37           C  
ATOM   8112  C   LYS I  80      91.628  51.950  36.882  1.00 61.42           C  
ATOM   8113  O   LYS I  80      91.954  52.978  36.285  1.00 63.15           O  
ATOM   8114  CB  LYS I  80      90.184  51.831  38.902  1.00 58.33           C  
ATOM   8115  CG  LYS I  80      90.694  53.146  39.459  1.00 58.52           C  
ATOM   8116  CD  LYS I  80      90.676  53.152  40.972  1.00 59.90           C  
ATOM   8117  CE  LYS I  80      91.097  54.505  41.519  1.00 60.59           C  
ATOM   8118  NZ  LYS I  80      91.186  54.490  43.007  1.00 61.61           N  
ATOM   8119  N   ASP I  81      92.480  50.957  37.125  1.00 64.53           N  
ATOM   8120  CA  ASP I  81      93.877  51.054  36.704  1.00 68.32           C  
ATOM   8121  C   ASP I  81      94.677  49.773  36.970  1.00 69.31           C  
ATOM   8122  O   ASP I  81      95.286  49.250  36.006  1.00 69.15           O  
ATOM   8123  CB  ASP I  81      94.543  52.244  37.408  1.00 69.58           C  
ATOM   8124  CG  ASP I  81      95.875  52.616  36.791  1.00 72.00           C  
ATOM   8125  OD1 ASP I  81      96.430  53.670  37.183  1.00 72.80           O  
ATOM   8126  OD2 ASP I  81      96.364  51.859  35.920  1.00 71.66           O  
ATOM   8127  N   VAL I  91      90.460  33.862  36.339  1.00 57.82           N  
ATOM   8128  CA  VAL I  91      89.315  34.301  37.191  1.00 59.97           C  
ATOM   8129  C   VAL I  91      88.038  34.422  36.366  1.00 60.91           C  
ATOM   8130  O   VAL I  91      87.035  33.766  36.647  1.00 59.74           O  
ATOM   8131  CB  VAL I  91      89.578  35.680  37.844  1.00 59.12           C  
ATOM   8132  CG1 VAL I  91      88.471  35.998  38.844  1.00 57.23           C  
ATOM   8133  CG2 VAL I  91      90.932  35.693  38.525  1.00 59.75           C  
ATOM   8134  N   TYR I  92      88.088  35.280  35.353  1.00 62.86           N  
ATOM   8135  CA  TYR I  92      86.950  35.517  34.473  1.00 64.85           C  
ATOM   8136  C   TYR I  92      86.475  34.229  33.815  1.00 64.74           C  
ATOM   8137  O   TYR I  92      85.282  33.917  33.828  1.00 64.01           O  
ATOM   8138  CB  TYR I  92      87.339  36.517  33.385  1.00 67.42           C  
ATOM   8139  CG  TYR I  92      87.669  37.903  33.891  1.00 69.91           C  
ATOM   8140  CD1 TYR I  92      86.681  38.885  33.977  1.00 71.31           C  
ATOM   8141  CD2 TYR I  92      88.974  38.242  34.259  1.00 70.24           C  
ATOM   8142  CE1 TYR I  92      86.984  40.176  34.410  1.00 72.27           C  
ATOM   8143  CE2 TYR I  92      89.287  39.527  34.697  1.00 71.49           C  
ATOM   8144  CZ  TYR I  92      88.286  40.491  34.767  1.00 72.21           C  
ATOM   8145  OH  TYR I  92      88.581  41.771  35.180  1.00 72.33           O  
ATOM   8146  N   ALA I  93      87.415  33.487  33.238  1.00 64.80           N  
ATOM   8147  CA  ALA I  93      87.101  32.234  32.560  1.00 66.06           C  
ATOM   8148  C   ALA I  93      86.276  31.288  33.427  1.00 66.64           C  
ATOM   8149  O   ALA I  93      85.468  30.511  32.916  1.00 66.03           O  
ATOM   8150  CB  ALA I  93      88.386  31.550  32.119  1.00 65.78           C  
ATOM   8151  N   GLU I  94      86.478  31.360  34.738  1.00 67.75           N  
ATOM   8152  CA  GLU I  94      85.752  30.505  35.672  1.00 68.36           C  
ATOM   8153  C   GLU I  94      84.239  30.647  35.559  1.00 67.35           C  
ATOM   8154  O   GLU I  94      83.509  29.658  35.588  1.00 67.66           O  
ATOM   8155  CB  GLU I  94      86.159  30.819  37.116  1.00 70.40           C  
ATOM   8156  CG  GLU I  94      87.607  30.513  37.460  1.00 73.34           C  
ATOM   8157  CD  GLU I  94      87.903  30.686  38.946  1.00 75.32           C  
ATOM   8158  OE1 GLU I  94      89.080  30.522  39.341  1.00 75.04           O  
ATOM   8159  OE2 GLU I  94      86.956  30.983  39.718  1.00 75.22           O  
ATOM   8160  N   TYR I  95      83.769  31.879  35.427  1.00 66.13           N  
ATOM   8161  CA  TYR I  95      82.338  32.129  35.358  1.00 64.81           C  
ATOM   8162  C   TYR I  95      81.745  32.149  33.963  1.00 63.83           C  
ATOM   8163  O   TYR I  95      80.563  31.860  33.786  1.00 64.80           O  
ATOM   8164  CB  TYR I  95      82.016  33.449  36.057  1.00 64.47           C  
ATOM   8165  CG  TYR I  95      82.517  33.501  37.480  1.00 63.57           C  
ATOM   8166  CD1 TYR I  95      83.884  33.569  37.756  1.00 62.73           C  
ATOM   8167  CD2 TYR I  95      81.628  33.443  38.551  1.00 62.23           C  
ATOM   8168  CE1 TYR I  95      84.352  33.578  39.063  1.00 63.04           C  
ATOM   8169  CE2 TYR I  95      82.084  33.450  39.859  1.00 62.24           C  
ATOM   8170  CZ  TYR I  95      83.447  33.515  40.112  1.00 63.30           C  
ATOM   8171  OH  TYR I  95      83.908  33.513  41.412  1.00 64.12           O  
ATOM   8172  N   PHE I  96      82.560  32.476  32.972  1.00 62.73           N  
ATOM   8173  CA  PHE I  96      82.067  32.550  31.606  1.00 61.85           C  
ATOM   8174  C   PHE I  96      82.650  31.492  30.691  1.00 61.96           C  
ATOM   8175  O   PHE I  96      82.522  31.582  29.472  1.00 61.14           O  
ATOM   8176  CB  PHE I  96      82.367  33.930  31.038  1.00 59.69           C  
ATOM   8177  CG  PHE I  96      81.920  35.048  31.921  1.00 56.81           C  
ATOM   8178  CD1 PHE I  96      80.590  35.138  32.325  1.00 53.76           C  
ATOM   8179  CD2 PHE I  96      82.820  36.026  32.330  1.00 55.47           C  
ATOM   8180  CE1 PHE I  96      80.162  36.187  33.119  1.00 52.18           C  
ATOM   8181  CE2 PHE I  96      82.402  37.085  33.127  1.00 54.55           C  
ATOM   8182  CZ  PHE I  96      81.068  37.164  33.522  1.00 53.70           C  
ATOM   8183  N   GLY I  97      83.283  30.488  31.286  1.00 63.15           N  
ATOM   8184  CA  GLY I  97      83.886  29.426  30.501  1.00 63.33           C  
ATOM   8185  C   GLY I  97      83.012  28.927  29.366  1.00 63.46           C  
ATOM   8186  O   GLY I  97      83.396  29.009  28.204  1.00 64.07           O  
ATOM   8187  N   GLU I  98      81.831  28.419  29.703  1.00 62.94           N  
ATOM   8188  CA  GLU I  98      80.910  27.880  28.708  1.00 62.88           C  
ATOM   8189  C   GLU I  98      79.950  28.933  28.167  1.00 60.75           C  
ATOM   8190  O   GLU I  98      79.060  28.626  27.371  1.00 60.95           O  
ATOM   8191  CB  GLU I  98      80.099  26.729  29.320  1.00 65.92           C  
ATOM   8192  CG  GLU I  98      80.927  25.751  30.156  1.00 70.04           C  
ATOM   8193  CD  GLU I  98      80.107  24.595  30.712  1.00 71.87           C  
ATOM   8194  OE1 GLU I  98      79.034  24.851  31.308  1.00 72.37           O  
ATOM   8195  OE2 GLU I  98      80.542  23.429  30.558  1.00 72.45           O  
ATOM   8196  N   SER I  99      80.126  30.175  28.600  1.00 58.30           N  
ATOM   8197  CA  SER I  99      79.247  31.251  28.159  1.00 54.85           C  
ATOM   8198  C   SER I  99      79.865  32.097  27.046  1.00 52.57           C  
ATOM   8199  O   SER I  99      79.209  32.400  26.047  1.00 52.39           O  
ATOM   8200  CB  SER I  99      78.881  32.141  29.346  1.00 53.22           C  
ATOM   8201  OG  SER I  99      77.801  32.991  29.014  1.00 52.59           O  
ATOM   8202  N   LYS I 100      81.125  32.481  27.229  1.00 48.47           N  
ATOM   8203  CA  LYS I 100      81.829  33.285  26.244  1.00 45.05           C  
ATOM   8204  C   LYS I 100      80.897  34.374  25.715  1.00 41.13           C  
ATOM   8205  O   LYS I 100      80.491  34.355  24.554  1.00 38.21           O  
ATOM   8206  CB  LYS I 100      82.306  32.391  25.095  1.00 46.86           C  
ATOM   8207  CG  LYS I 100      83.085  31.149  25.539  1.00 49.06           C  
ATOM   8208  CD  LYS I 100      84.466  31.479  26.110  1.00 50.72           C  
ATOM   8209  CE  LYS I 100      85.446  31.904  25.018  1.00 54.67           C  
ATOM   8210  NZ  LYS I 100      85.689  30.847  23.987  1.00 55.75           N  
ATOM   8211  N   PRO I 101      80.544  35.339  26.574  1.00 37.89           N  
ATOM   8212  CA  PRO I 101      79.655  36.441  26.203  1.00 34.95           C  
ATOM   8213  C   PRO I 101      80.397  37.532  25.454  1.00 31.70           C  
ATOM   8214  O   PRO I 101      81.624  37.543  25.410  1.00 28.94           O  
ATOM   8215  CB  PRO I 101      79.152  36.962  27.556  1.00 36.31           C  
ATOM   8216  CG  PRO I 101      79.562  35.906  28.558  1.00 36.71           C  
ATOM   8217  CD  PRO I 101      80.850  35.396  28.010  1.00 37.87           C  
ATOM   8218  N   ALA I 102      79.641  38.450  24.866  1.00 32.09           N  
ATOM   8219  CA  ALA I 102      80.230  39.580  24.164  1.00 32.56           C  
ATOM   8220  C   ALA I 102      80.791  40.448  25.277  1.00 33.99           C  
ATOM   8221  O   ALA I 102      80.098  40.720  26.260  1.00 35.16           O  
ATOM   8222  CB  ALA I 102      79.171  40.331  23.401  1.00 32.23           C  
ATOM   8223  N   ARG I 103      82.040  40.877  25.132  1.00 34.66           N  
ATOM   8224  CA  ARG I 103      82.672  41.683  26.164  1.00 35.58           C  
ATOM   8225  C   ARG I 103      83.145  43.067  25.724  1.00 35.37           C  
ATOM   8226  O   ARG I 103      83.533  43.268  24.579  1.00 35.90           O  
ATOM   8227  CB  ARG I 103      83.874  40.926  26.728  1.00 36.36           C  
ATOM   8228  CG  ARG I 103      84.399  41.484  28.038  1.00 41.23           C  
ATOM   8229  CD  ARG I 103      85.704  40.828  28.433  1.00 43.80           C  
ATOM   8230  NE  ARG I 103      86.830  41.527  27.833  1.00 49.08           N  
ATOM   8231  CZ  ARG I 103      88.083  41.097  27.873  1.00 50.55           C  
ATOM   8232  NH1 ARG I 103      89.043  41.813  27.298  1.00 50.68           N  
ATOM   8233  NH2 ARG I 103      88.371  39.947  28.474  1.00 51.65           N  
ATOM   8234  N   VAL I 104      83.108  44.016  26.653  1.00 34.02           N  
ATOM   8235  CA  VAL I 104      83.593  45.366  26.416  1.00 34.48           C  
ATOM   8236  C   VAL I 104      84.418  45.721  27.659  1.00 36.63           C  
ATOM   8237  O   VAL I 104      83.990  45.461  28.781  1.00 36.02           O  
ATOM   8238  CB  VAL I 104      82.453  46.384  26.283  1.00 34.43           C  
ATOM   8239  CG1 VAL I 104      83.033  47.769  26.048  1.00 34.06           C  
ATOM   8240  CG2 VAL I 104      81.538  46.004  25.143  1.00 35.22           C  
ATOM   8241  N   ALA I 105      85.598  46.301  27.469  1.00 38.26           N  
ATOM   8242  CA  ALA I 105      86.439  46.657  28.607  1.00 40.27           C  
ATOM   8243  C   ALA I 105      87.118  48.011  28.437  1.00 41.33           C  
ATOM   8244  O   ALA I 105      87.730  48.290  27.408  1.00 42.74           O  
ATOM   8245  CB  ALA I 105      87.482  45.575  28.835  1.00 38.46           C  
ATOM   8246  N   VAL I 106      87.015  48.850  29.460  1.00 42.47           N  
ATOM   8247  CA  VAL I 106      87.620  50.178  29.421  1.00 43.82           C  
ATOM   8248  C   VAL I 106      88.151  50.586  30.791  1.00 44.96           C  
ATOM   8249  O   VAL I 106      87.794  49.997  31.807  1.00 44.43           O  
ATOM   8250  CB  VAL I 106      86.591  51.254  28.997  1.00 42.57           C  
ATOM   8251  CG1 VAL I 106      86.006  50.916  27.636  1.00 41.86           C  
ATOM   8252  CG2 VAL I 106      85.494  51.359  30.056  1.00 40.45           C  
ATOM   8253  N   GLU I 107      89.007  51.600  30.809  1.00 46.91           N  
ATOM   8254  CA  GLU I 107      89.537  52.112  32.061  1.00 48.72           C  
ATOM   8255  C   GLU I 107      88.843  53.422  32.336  1.00 48.25           C  
ATOM   8256  O   GLU I 107      88.738  54.272  31.453  1.00 47.59           O  
ATOM   8257  CB  GLU I 107      91.042  52.364  31.985  1.00 50.96           C  
ATOM   8258  CG  GLU I 107      91.888  51.253  32.576  1.00 55.68           C  
ATOM   8259  CD  GLU I 107      93.062  51.786  33.385  1.00 58.92           C  
ATOM   8260  OE1 GLU I 107      93.884  50.968  33.856  1.00 59.80           O  
ATOM   8261  OE2 GLU I 107      93.158  53.024  33.556  1.00 60.55           O  
ATOM   8262  N   VAL I 108      88.356  53.581  33.558  1.00 48.19           N  
ATOM   8263  CA  VAL I 108      87.689  54.813  33.929  1.00 49.39           C  
ATOM   8264  C   VAL I 108      88.533  55.489  34.998  1.00 50.10           C  
ATOM   8265  O   VAL I 108      89.542  54.936  35.435  1.00 50.33           O  
ATOM   8266  CB  VAL I 108      86.284  54.534  34.472  1.00 48.28           C  
ATOM   8267  CG1 VAL I 108      85.529  53.655  33.488  1.00 47.62           C  
ATOM   8268  CG2 VAL I 108      86.374  53.875  35.824  1.00 46.65           C  
ATOM   8269  N   SER I 109      88.125  56.683  35.413  1.00 50.45           N  
ATOM   8270  CA  SER I 109      88.862  57.418  36.429  1.00 50.43           C  
ATOM   8271  C   SER I 109      88.502  56.952  37.832  1.00 50.73           C  
ATOM   8272  O   SER I 109      89.351  56.915  38.720  1.00 51.77           O  
ATOM   8273  CB  SER I 109      88.575  58.909  36.306  1.00 51.52           C  
ATOM   8274  OG  SER I 109      88.960  59.392  35.033  1.00 55.37           O  
ATOM   8275  N   ARG I 110      87.239  56.599  38.031  1.00 49.91           N  
ATOM   8276  CA  ARG I 110      86.781  56.153  39.333  1.00 49.69           C  
ATOM   8277  C   ARG I 110      85.460  55.421  39.253  1.00 48.58           C  
ATOM   8278  O   ARG I 110      84.641  55.688  38.379  1.00 48.17           O  
ATOM   8279  CB  ARG I 110      86.619  57.339  40.288  1.00 51.64           C  
ATOM   8280  CG  ARG I 110      87.827  57.657  41.150  1.00 53.75           C  
ATOM   8281  CD  ARG I 110      87.436  58.664  42.213  1.00 57.03           C  
ATOM   8282  NE  ARG I 110      86.268  58.207  42.966  1.00 61.80           N  
ATOM   8283  CZ  ARG I 110      85.540  58.982  43.767  1.00 63.60           C  
ATOM   8284  NH1 ARG I 110      84.492  58.477  44.413  1.00 63.99           N  
ATOM   8285  NH2 ARG I 110      85.855  60.264  43.917  1.00 65.12           N  
ATOM   8286  N   LEU I 111      85.264  54.504  40.192  1.00 48.46           N  
ATOM   8287  CA  LEU I 111      84.046  53.717  40.294  1.00 48.03           C  
ATOM   8288  C   LEU I 111      83.457  54.006  41.674  1.00 48.92           C  
ATOM   8289  O   LEU I 111      84.117  54.603  42.526  1.00 50.45           O  
ATOM   8290  CB  LEU I 111      84.379  52.230  40.154  1.00 45.84           C  
ATOM   8291  CG  LEU I 111      85.069  51.844  38.839  1.00 43.01           C  
ATOM   8292  CD1 LEU I 111      85.448  50.371  38.844  1.00 40.52           C  
ATOM   8293  CD2 LEU I 111      84.134  52.149  37.683  1.00 39.20           C  
ATOM   8294  N   PRO I 112      82.202  53.611  41.914  1.00 49.22           N  
ATOM   8295  CA  PRO I 112      81.622  53.878  43.237  1.00 49.75           C  
ATOM   8296  C   PRO I 112      82.501  53.352  44.383  1.00 50.44           C  
ATOM   8297  O   PRO I 112      83.251  52.384  44.208  1.00 49.90           O  
ATOM   8298  CB  PRO I 112      80.273  53.176  43.157  1.00 49.62           C  
ATOM   8299  CG  PRO I 112      79.888  53.400  41.724  1.00 50.04           C  
ATOM   8300  CD  PRO I 112      81.183  53.094  40.984  1.00 49.49           C  
ATOM   8301  N   LYS I 113      82.404  54.000  45.547  1.00 50.14           N  
ATOM   8302  CA  LYS I 113      83.186  53.633  46.736  1.00 49.14           C  
ATOM   8303  C   LYS I 113      84.657  53.336  46.423  1.00 48.43           C  
ATOM   8304  O   LYS I 113      85.301  52.533  47.097  1.00 45.59           O  
ATOM   8305  CB  LYS I 113      82.557  52.427  47.442  1.00 50.36           C  
ATOM   8306  CG  LYS I 113      81.126  52.647  47.930  1.00 53.65           C  
ATOM   8307  CD  LYS I 113      80.683  51.512  48.852  1.00 55.74           C  
ATOM   8308  CE  LYS I 113      79.227  51.655  49.293  1.00 57.54           C  
ATOM   8309  NZ  LYS I 113      78.251  51.279  48.222  1.00 57.88           N  
ATOM   8310  N   ASP I 114      85.176  54.001  45.394  1.00 49.76           N  
ATOM   8311  CA  ASP I 114      86.561  53.845  44.945  1.00 51.03           C  
ATOM   8312  C   ASP I 114      87.048  52.393  44.829  1.00 49.52           C  
ATOM   8313  O   ASP I 114      88.130  52.047  45.304  1.00 48.92           O  
ATOM   8314  CB  ASP I 114      87.515  54.620  45.860  1.00 54.13           C  
ATOM   8315  CG  ASP I 114      88.815  54.980  45.164  1.00 57.67           C  
ATOM   8316  OD1 ASP I 114      89.849  55.151  45.850  1.00 59.90           O  
ATOM   8317  OD2 ASP I 114      88.793  55.102  43.920  1.00 59.84           O  
ATOM   8318  N   VAL I 115      86.250  51.556  44.178  1.00 48.55           N  
ATOM   8319  CA  VAL I 115      86.592  50.154  43.977  1.00 46.40           C  
ATOM   8320  C   VAL I 115      87.455  50.005  42.712  1.00 45.68           C  
ATOM   8321  O   VAL I 115      87.611  50.954  41.944  1.00 45.01           O  
ATOM   8322  CB  VAL I 115      85.310  49.317  43.851  1.00 46.95           C  
ATOM   8323  CG1 VAL I 115      84.484  49.446  45.130  1.00 44.06           C  
ATOM   8324  CG2 VAL I 115      84.492  49.798  42.654  1.00 46.59           C  
ATOM   8325  N   LEU I 116      88.010  48.816  42.493  1.00 44.59           N  
ATOM   8326  CA  LEU I 116      88.875  48.579  41.335  1.00 42.27           C  
ATOM   8327  C   LEU I 116      88.185  48.056  40.083  1.00 42.29           C  
ATOM   8328  O   LEU I 116      88.742  48.130  38.983  1.00 39.37           O  
ATOM   8329  CB  LEU I 116      89.997  47.614  41.712  1.00 41.01           C  
ATOM   8330  CG  LEU I 116      90.946  48.061  42.825  1.00 40.26           C  
ATOM   8331  CD1 LEU I 116      92.062  47.038  42.969  1.00 37.99           C  
ATOM   8332  CD2 LEU I 116      91.520  49.442  42.496  1.00 39.15           C  
ATOM   8333  N   ILE I 117      86.975  47.531  40.237  1.00 41.53           N  
ATOM   8334  CA  ILE I 117      86.271  46.997  39.087  1.00 42.18           C  
ATOM   8335  C   ILE I 117      84.760  47.006  39.264  1.00 42.50           C  
ATOM   8336  O   ILE I 117      84.248  46.839  40.371  1.00 42.75           O  
ATOM   8337  CB  ILE I 117      86.734  45.558  38.800  1.00 43.13           C  
ATOM   8338  CG1 ILE I 117      86.046  45.029  37.536  1.00 43.72           C  
ATOM   8339  CG2 ILE I 117      86.441  44.675  40.013  1.00 42.42           C  
ATOM   8340  CD1 ILE I 117      86.523  43.658  37.097  1.00 41.93           C  
ATOM   8341  N   GLU I 118      84.051  47.219  38.162  1.00 41.07           N  
ATOM   8342  CA  GLU I 118      82.595  47.237  38.190  1.00 40.72           C  
ATOM   8343  C   GLU I 118      82.132  46.492  36.949  1.00 39.93           C  
ATOM   8344  O   GLU I 118      82.565  46.791  35.841  1.00 42.22           O  
ATOM   8345  CB  GLU I 118      82.076  48.673  38.162  1.00 38.83           C  
ATOM   8346  CG  GLU I 118      80.645  48.820  38.643  1.00 38.68           C  
ATOM   8347  CD  GLU I 118      80.111  50.236  38.468  1.00 40.23           C  
ATOM   8348  OE1 GLU I 118      80.912  51.189  38.545  1.00 40.63           O  
ATOM   8349  OE2 GLU I 118      78.891  50.397  38.265  1.00 39.25           O  
ATOM   8350  N   ILE I 119      81.264  45.510  37.129  1.00 37.72           N  
ATOM   8351  CA  ILE I 119      80.788  44.741  36.000  1.00 37.24           C  
ATOM   8352  C   ILE I 119      79.280  44.794  35.852  1.00 36.73           C  
ATOM   8353  O   ILE I 119      78.545  44.656  36.830  1.00 36.29           O  
ATOM   8354  CB  ILE I 119      81.220  43.258  36.119  1.00 39.45           C  
ATOM   8355  CG1 ILE I 119      82.746  43.147  35.989  1.00 38.81           C  
ATOM   8356  CG2 ILE I 119      80.509  42.416  35.049  1.00 39.64           C  
ATOM   8357  CD1 ILE I 119      83.284  41.739  36.180  1.00 36.62           C  
ATOM   8358  N   GLU I 120      78.826  45.016  34.621  1.00 36.44           N  
ATOM   8359  CA  GLU I 120      77.403  45.040  34.319  1.00 35.27           C  
ATOM   8360  C   GLU I 120      77.194  43.954  33.280  1.00 33.63           C  
ATOM   8361  O   GLU I 120      78.020  43.764  32.392  1.00 32.88           O  
ATOM   8362  CB  GLU I 120      76.961  46.402  33.773  1.00 39.03           C  
ATOM   8363  CG  GLU I 120      77.503  46.788  32.409  1.00 46.36           C  
ATOM   8364  CD  GLU I 120      76.837  48.053  31.862  1.00 52.04           C  
ATOM   8365  OE1 GLU I 120      75.599  48.045  31.688  1.00 52.75           O  
ATOM   8366  OE2 GLU I 120      77.547  49.056  31.608  1.00 56.69           O  
ATOM   8367  N   ALA I 121      76.097  43.226  33.397  1.00 33.20           N  
ATOM   8368  CA  ALA I 121      75.837  42.153  32.460  1.00 32.17           C  
ATOM   8369  C   ALA I 121      74.409  42.144  31.981  1.00 32.43           C  
ATOM   8370  O   ALA I 121      73.526  42.746  32.593  1.00 32.80           O  
ATOM   8371  CB  ALA I 121      76.181  40.808  33.106  1.00 31.13           C  
ATOM   8372  N   ILE I 122      74.205  41.461  30.862  1.00 33.02           N  
ATOM   8373  CA  ILE I 122      72.893  41.299  30.257  1.00 35.15           C  
ATOM   8374  C   ILE I 122      72.813  39.816  29.968  1.00 36.95           C  
ATOM   8375  O   ILE I 122      73.834  39.166  29.753  1.00 38.46           O  
ATOM   8376  CB  ILE I 122      72.760  42.056  28.919  1.00 34.71           C  
ATOM   8377  CG1 ILE I 122      72.866  43.563  29.153  1.00 32.36           C  
ATOM   8378  CG2 ILE I 122      71.427  41.700  28.250  1.00 32.85           C  
ATOM   8379  CD1 ILE I 122      72.814  44.374  27.893  1.00 33.09           C  
ATOM   8380  N   ALA I 123      71.608  39.271  29.958  1.00 38.65           N  
ATOM   8381  CA  ALA I 123      71.452  37.855  29.703  1.00 38.48           C  
ATOM   8382  C   ALA I 123      70.124  37.581  29.031  1.00 38.84           C  
ATOM   8383  O   ALA I 123      69.163  38.320  29.203  1.00 37.70           O  
ATOM   8384  CB  ALA I 123      71.562  37.080  31.011  1.00 37.31           C  
ATOM   8385  N   TYR I 124      70.091  36.508  28.251  1.00 42.71           N  
ATOM   8386  CA  TYR I 124      68.898  36.103  27.527  1.00 45.82           C  
ATOM   8387  C   TYR I 124      68.507  34.725  28.041  1.00 48.24           C  
ATOM   8388  O   TYR I 124      69.349  33.988  28.556  1.00 49.09           O  
ATOM   8389  CB  TYR I 124      69.205  36.058  26.028  1.00 45.06           C  
ATOM   8390  CG  TYR I 124      68.062  35.638  25.132  1.00 45.35           C  
ATOM   8391  CD1 TYR I 124      66.916  36.421  25.008  1.00 46.14           C  
ATOM   8392  CD2 TYR I 124      68.157  34.485  24.354  1.00 47.03           C  
ATOM   8393  CE1 TYR I 124      65.889  36.069  24.122  1.00 47.34           C  
ATOM   8394  CE2 TYR I 124      67.140  34.120  23.465  1.00 48.50           C  
ATOM   8395  CZ  TYR I 124      66.010  34.918  23.352  1.00 48.97           C  
ATOM   8396  OH  TYR I 124      65.017  34.572  22.458  1.00 49.10           O  
ATOM   8397  N   LYS I 125      67.226  34.394  27.920  1.00 51.17           N  
ATOM   8398  CA  LYS I 125      66.702  33.109  28.368  1.00 53.52           C  
ATOM   8399  C   LYS I 125      65.599  32.746  27.392  1.00 55.61           C  
ATOM   8400  O   LYS I 125      64.560  33.407  27.353  1.00 55.65           O  
ATOM   8401  CB  LYS I 125      66.143  33.247  29.782  1.00 55.06           C  
ATOM   8402  CG  LYS I 125      65.698  31.960  30.448  1.00 56.47           C  
ATOM   8403  CD  LYS I 125      65.249  32.240  31.884  1.00 57.31           C  
ATOM   8404  CE  LYS I 125      64.646  31.005  32.549  1.00 59.57           C  
ATOM   8405  NZ  LYS I 125      63.392  30.550  31.862  1.00 61.05           N  
ATOM   8406  N   GLU I 126      65.837  31.705  26.597  1.00 58.45           N  
ATOM   8407  CA  GLU I 126      64.882  31.262  25.584  1.00 61.70           C  
ATOM   8408  C   GLU I 126      63.557  30.813  26.195  1.00 62.57           C  
ATOM   8409  O   GLU I 126      63.474  30.711  27.439  1.00 63.43           O  
ATOM   8410  CB  GLU I 126      65.468  30.105  24.758  1.00 64.25           C  
ATOM   8411  CG  GLU I 126      66.974  30.167  24.520  1.00 65.88           C  
ATOM   8412  CD  GLU I 126      67.779  29.863  25.775  1.00 67.86           C  
ATOM   8413  OE1 GLU I 126      67.569  28.781  26.369  1.00 68.46           O  
ATOM   8414  OE2 GLU I 126      68.619  30.706  26.167  1.00 69.04           O  
ATOM   8415  OXT GLU I 126      62.617  30.556  25.411  1.00 62.91           O  
TER    8416      GLU I 126                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
