
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  120 (  922),  selected  120 , name 2dyy_E
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2dyy_E.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_E      M       1           -
LGA    K     2_E      S       2           -
LGA    E     3_E      D       3           -
LGA    V     4_E      V       4           -
LGA    I     5_E      I       5           -
LGA    F     6_E      E       6           -
LGA    T     7_E      G       7           -
LGA    E     8_E      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    N     9_E      P      17          3.451
LGA    A    10_E      V      18          4.737
LGA    P    11_E      -       -           -
LGA    K    12_E      -       -           -
LGA    P    13_E      -       -           -
LGA    I    14_E      A      23           #
LGA    G    15_E      A      24          3.390
LGA    P    16_E      N      25          1.595
LGA    Y    17_E      Y      26          1.044
LGA    S    18_E      V      27          0.743
LGA    Q    19_E      P      28          0.803
LGA    A    20_E      F      29          0.551
LGA    I    21_E      T      30          0.977
LGA    K    22_E      I      31          1.633
LGA    A    23_E      S      32          1.863
LGA    G    24_E      G      33          1.751
LGA    N    25_E      N      34          1.117
LGA    F    26_E      L      35          1.196
LGA    L    27_E      L      36          0.678
LGA    F    28_E      Y      37          0.845
LGA    I    29_E      V      38          0.519
LGA    A    30_E      S      39          0.571
LGA    G    31_E      G      40          0.670
LGA    Q    32_E      Q      41          0.471
LGA    I    33_E      L      42          0.628
LGA    P    34_E      P      43          0.874
LGA    I    35_E      M      44          1.443
LGA    D    36_E      E      45          2.028
LGA    P    37_E      -       -           -
LGA    K    38_E      -       -           -
LGA    T    39_E      S      46          3.193
LGA    G    40_E      G      47          1.760
LGA    E    41_E      K      48          0.732
LGA    I    42_E      I      49          0.970
LGA    V    43_E      A      50          1.262
LGA    G    45_E      V      51          3.202
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    46_E      S      63          2.301
LGA    I    47_E      A      64          0.867
LGA    K    48_E      Q      65          2.223
LGA    D    49_E      R      66          1.909
LGA    Q    50_E      A      67          1.187
LGA    T    51_E      A      68          1.114
LGA    R    52_E      E      69          1.272
LGA    Q    53_E      L      70          1.067
LGA    V    54_E      C      71          0.749
LGA    L    55_E      A      72          0.557
LGA    E    56_E      V      73          0.441
LGA    N    57_E      N      74          0.628
LGA    I    58_E      I      75          0.560
LGA    K    59_E      L      76          0.689
LGA    A    60_E      A      77          0.993
LGA    I    61_E      Q      78          1.085
LGA    L    62_E      V      79          1.208
LGA    E    63_E      K      80          1.572
LGA    A    64_E      A      81          1.867
LGA    A    65_E      A      82          2.134
LGA    G    66_E      L      83          2.281
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    Y    67_E      K      89          3.732
LGA    S    68_E      I      90          2.975
LGA    L    69_E      -       -           -
LGA    N    70_E      R      91          4.926
LGA    D    71_E      R      92          2.245
LGA    V    72_E      V      93          1.204
LGA    I    73_E      I      94          0.436
LGA    K    74_E      K      95          1.121
LGA    V    75_E      L      96          1.058
LGA    T    76_E      N      97          0.798
LGA    V    77_E      G      98          0.923
LGA    Y    78_E      F      99          0.556
LGA    L    79_E      V     100          0.881
LGA    K    80_E      A     101          1.088
LGA    D    81_E      S     102          1.509
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    -       -      V     107           -
LGA    -       -      E     108           -
LGA    -       -      Q     109           -
LGA    A    86_E      H     110          4.773
LGA    K    87_E      L     111          3.975
LGA    M    88_E      V     112          2.114
LGA    N    89_E      I     113          4.317
LGA    E    90_E      N     114          4.164
LGA    V    91_E      G     115          2.359
LGA    Y    92_E      A     116          2.834
LGA    A    93_E      S     117          3.774
LGA    -       -      N     118           -
LGA    E    94_E      L     119          2.803
LGA    Y    95_E      I     120          1.432
LGA    F    96_E      A     121          2.624
LGA    G    97_E      T     122          5.311
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    E    98_E      G     125          3.450
LGA    S    99_E      E     126          4.183
LGA    -       -      P     127           -
LGA    -       -      G     128           -
LGA    K   100_E      R     129          1.487
LGA    P   101_E      H     130          1.045
LGA    A   102_E      A     131          1.029
LGA    R   103_E      R     132          0.727
LGA    V   104_E      A     133          1.393
LGA    A   105_E      A     134          1.740
LGA    V   106_E      V     135          1.355
LGA    E   107_E      G     136          0.972
LGA    V   108_E      M     137          1.160
LGA    S   109_E      A     138          0.443
LGA    R   110_E      S     139          0.747
LGA    L   111_E      L     140          0.649
LGA    P   112_E      P     141          0.614
LGA    K   113_E      F     142          0.690
LGA    D   114_E      N     143          1.098
LGA    V   115_E      A     144          0.865
LGA    L   116_E      S     145          0.625
LGA    I   117_E      V     146          0.503
LGA    E   118_E      E     147          0.457
LGA    I   119_E      I     148          0.591
LGA    E   120_E      D     149          0.691
LGA    A   121_E      A     150          0.516
LGA    I   122_E      I     151          0.639
LGA    A   123_E      V     152          0.888
LGA    Y   124_E      E     153          1.005
LGA    K   125_E      I     154          2.171
LGA    -       -      D     155           -
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  120  152    5.0    105    1.98    25.71     61.998     5.045

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.492546 * X  +  -0.707049 * Y  +   0.507425 * Z  +  15.832204
  Y_new =  -0.671022 * X  +  -0.679823 * Y  +  -0.295923 * Z  + 107.173294
  Z_new =   0.554191 * X  +  -0.194737 * Y  +  -0.809289 * Z  +  47.911610 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.905455    0.236138  [ DEG:  -166.4703     13.5297 ]
  Theta =  -0.587391   -2.554201  [ DEG:   -33.6550   -146.3450 ]
  Phi   =  -0.937598    2.203995  [ DEG:   -53.7204    126.2796 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dyy_E                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dyy_E.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  120  152   5.0  105   1.98   25.71  61.998
REMARK  ---------------------------------------------------------- 
MOLECULE 2dyy_E
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-SEP-06   2DYY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION INITIATION                  
TITLE    2 INHIBITOR PH0854 FROM PYROCOCCUS HORIKOSHII                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0076 PROTEIN PH0854;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PUTATIVE TRANSLATION INITIATION INHIBITOR;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    PUTATIVE TRANSLATION INITIATION INHIBITOR, PYROCOCCUS                 
KEYWDS   2 HORIKOSHII, TRIMER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL            
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,B.C.WANG,           
AUTHOR   2 M.SHIROUZU,Y.BESSHO,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-SEP-07 2DYY    1       AUTHOR                                   
REVDAT   1   19-MAR-07 2DYY    0                                                
JRNL        AUTH   IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,           
JRNL        AUTH 2 B.C.WANG,M.SHIROUZU,Y.BESSHO,S.YOKOYAMA                      
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION                    
JRNL        TITL 2 INITIATION INHIBITOR PH0854 FROM PYROCOCCUS                  
JRNL        TITL 3 HORIKOSHII                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2DYY A    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY B    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY C    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY D    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY E    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY F    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY G    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY H    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY I    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY J    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY K    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY L    1   126  UNP    O58584   Y854_PYRHO       1    126             
SEQRES   1 A  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 A  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 A  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 A  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 A  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 A  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 A  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 A  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 A  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 A  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 B  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 B  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 B  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 B  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 B  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 B  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 B  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 B  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 B  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 B  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 C  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 C  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 C  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 C  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 C  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 C  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 C  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 C  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 C  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 C  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 D  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 D  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 D  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 D  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 D  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 D  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 D  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 D  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 D  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 D  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 E  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 E  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 E  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 E  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 E  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 E  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 E  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 E  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 E  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 E  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 F  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 F  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 F  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 F  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 F  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 F  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 F  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 F  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 F  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 F  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 G  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 G  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 G  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 G  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 G  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 G  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 G  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 G  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 G  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 G  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 H  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 H  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 H  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 H  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 H  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 H  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 H  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 H  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 H  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 H  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 I  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 I  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 I  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 I  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 I  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 I  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 I  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 I  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 I  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 I  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 J  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 J  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 J  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 J  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 J  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 J  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 J  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 J  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 J  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 J  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 K  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 K  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 K  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 K  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 K  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 K  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 K  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 K  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 K  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 K  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 L  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 L  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 L  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 L  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 L  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 L  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 L  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 L  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 L  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 L  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
FORMUL  13  HOH   *233(H2 O)                                                    
CRYST1   92.490   43.090  170.210  90.00  91.51  90.00 P 1 2 1      24          
ATOM   3789  N   MET E   1      55.672  40.512  31.510  1.00 48.02           N  
ATOM   3790  CA  MET E   1      57.026  40.278  30.926  1.00 47.68           C  
ATOM   3791  C   MET E   1      58.050  41.287  31.452  1.00 46.83           C  
ATOM   3792  O   MET E   1      59.172  41.351  30.954  1.00 47.12           O  
ATOM   3793  CB  MET E   1      56.958  40.345  29.397  1.00 47.06           C  
ATOM   3794  N   LYS E   2      57.656  42.064  32.462  1.00 45.19           N  
ATOM   3795  CA  LYS E   2      58.523  43.076  33.084  1.00 44.18           C  
ATOM   3796  C   LYS E   2      58.591  42.897  34.612  1.00 44.63           C  
ATOM   3797  O   LYS E   2      57.698  43.348  35.331  1.00 45.47           O  
ATOM   3798  CB  LYS E   2      57.991  44.472  32.754  1.00 42.48           C  
ATOM   3799  CG  LYS E   2      58.367  45.558  33.752  1.00 41.34           C  
ATOM   3800  CD  LYS E   2      59.839  45.872  33.739  1.00 40.62           C  
ATOM   3801  CE  LYS E   2      60.189  46.796  34.892  1.00 42.70           C  
ATOM   3802  NZ  LYS E   2      59.447  48.084  34.854  1.00 43.70           N  
ATOM   3803  N   GLU E   3      59.642  42.246  35.112  1.00 42.45           N  
ATOM   3804  CA  GLU E   3      59.751  42.030  36.550  1.00 41.04           C  
ATOM   3805  C   GLU E   3      61.080  42.385  37.191  1.00 39.12           C  
ATOM   3806  O   GLU E   3      62.153  42.115  36.647  1.00 38.12           O  
ATOM   3807  CB  GLU E   3      59.408  40.578  36.916  1.00 43.31           C  
ATOM   3808  CG  GLU E   3      60.174  39.518  36.146  1.00 48.98           C  
ATOM   3809  CD  GLU E   3      60.423  38.255  36.970  1.00 53.23           C  
ATOM   3810  OE1 GLU E   3      59.493  37.807  37.681  1.00 54.26           O  
ATOM   3811  OE2 GLU E   3      61.551  37.709  36.898  1.00 54.04           O  
ATOM   3812  N   VAL E   4      60.986  43.003  38.364  1.00 36.29           N  
ATOM   3813  CA  VAL E   4      62.157  43.383  39.121  1.00 33.62           C  
ATOM   3814  C   VAL E   4      62.655  42.146  39.869  1.00 33.01           C  
ATOM   3815  O   VAL E   4      61.867  41.347  40.376  1.00 32.00           O  
ATOM   3816  CB  VAL E   4      61.831  44.523  40.107  1.00 32.59           C  
ATOM   3817  CG1 VAL E   4      60.497  44.270  40.764  1.00 33.98           C  
ATOM   3818  CG2 VAL E   4      62.921  44.635  41.152  1.00 30.98           C  
ATOM   3819  N   ILE E   5      63.973  41.989  39.903  1.00 31.78           N  
ATOM   3820  CA  ILE E   5      64.612  40.867  40.565  1.00 31.01           C  
ATOM   3821  C   ILE E   5      65.255  41.328  41.859  1.00 32.30           C  
ATOM   3822  O   ILE E   5      65.847  42.403  41.920  1.00 32.81           O  
ATOM   3823  CB  ILE E   5      65.722  40.261  39.687  1.00 28.98           C  
ATOM   3824  CG1 ILE E   5      65.138  39.779  38.357  1.00 27.18           C  
ATOM   3825  CG2 ILE E   5      66.431  39.153  40.446  1.00 27.50           C  
ATOM   3826  CD1 ILE E   5      64.067  38.726  38.482  1.00 27.05           C  
ATOM   3827  N   PHE E   6      65.137  40.509  42.896  1.00 33.93           N  
ATOM   3828  CA  PHE E   6      65.745  40.828  44.179  1.00 35.11           C  
ATOM   3829  C   PHE E   6      66.141  39.569  44.906  1.00 35.11           C  
ATOM   3830  O   PHE E   6      65.325  38.667  45.078  1.00 37.32           O  
ATOM   3831  CB  PHE E   6      64.797  41.610  45.082  1.00 36.08           C  
ATOM   3832  CG  PHE E   6      65.368  41.883  46.443  1.00 36.57           C  
ATOM   3833  CD1 PHE E   6      66.275  42.920  46.634  1.00 36.31           C  
ATOM   3834  CD2 PHE E   6      65.045  41.063  47.523  1.00 36.98           C  
ATOM   3835  CE1 PHE E   6      66.860  43.140  47.884  1.00 37.74           C  
ATOM   3836  CE2 PHE E   6      65.622  41.270  48.778  1.00 37.93           C  
ATOM   3837  CZ  PHE E   6      66.536  42.315  48.958  1.00 38.22           C  
ATOM   3838  N   THR E   7      67.400  39.515  45.328  1.00 34.29           N  
ATOM   3839  CA  THR E   7      67.920  38.380  46.077  1.00 33.12           C  
ATOM   3840  C   THR E   7      68.819  38.864  47.209  1.00 33.48           C  
ATOM   3841  O   THR E   7      69.622  39.782  47.034  1.00 32.45           O  
ATOM   3842  CB  THR E   7      68.739  37.428  45.188  1.00 33.90           C  
ATOM   3843  OG1 THR E   7      69.203  36.322  45.979  1.00 33.43           O  
ATOM   3844  CG2 THR E   7      69.943  38.153  44.589  1.00 32.46           C  
ATOM   3845  N   GLU E   8      68.672  38.248  48.375  1.00 35.20           N  
ATOM   3846  CA  GLU E   8      69.494  38.606  49.526  1.00 36.90           C  
ATOM   3847  C   GLU E   8      70.950  38.176  49.252  1.00 36.15           C  
ATOM   3848  O   GLU E   8      71.882  38.628  49.926  1.00 38.21           O  
ATOM   3849  CB  GLU E   8      68.963  37.915  50.795  1.00 37.60           C  
ATOM   3850  CG  GLU E   8      67.600  38.397  51.319  1.00 39.95           C  
ATOM   3851  CD  GLU E   8      67.686  39.682  52.148  1.00 42.84           C  
ATOM   3852  OE1 GLU E   8      68.751  39.910  52.758  1.00 43.47           O  
ATOM   3853  OE2 GLU E   8      66.689  40.449  52.207  1.00 40.28           O  
ATOM   3854  N   ASN E   9      71.133  37.325  48.247  1.00 33.20           N  
ATOM   3855  CA  ASN E   9      72.455  36.822  47.873  1.00 32.14           C  
ATOM   3856  C   ASN E   9      73.350  37.822  47.132  1.00 31.10           C  
ATOM   3857  O   ASN E   9      74.496  37.516  46.821  1.00 29.23           O  
ATOM   3858  CB  ASN E   9      72.302  35.564  47.018  1.00 33.81           C  
ATOM   3859  CG  ASN E   9      71.590  34.446  47.754  1.00 37.06           C  
ATOM   3860  OD1 ASN E   9      71.020  33.536  47.139  1.00 37.52           O  
ATOM   3861  ND2 ASN E   9      71.625  34.502  49.079  1.00 39.30           N  
ATOM   3862  N   ALA E  10      72.843  39.012  46.836  1.00 29.80           N  
ATOM   3863  CA  ALA E  10      73.656  40.005  46.135  1.00 29.43           C  
ATOM   3864  C   ALA E  10      73.571  41.324  46.874  1.00 28.26           C  
ATOM   3865  O   ALA E  10      72.650  41.534  47.648  1.00 28.08           O  
ATOM   3866  CB  ALA E  10      73.175  40.170  44.675  1.00 28.28           C  
ATOM   3867  N   PRO E  11      74.530  42.233  46.643  1.00 29.18           N  
ATOM   3868  CA  PRO E  11      74.507  43.531  47.329  1.00 30.25           C  
ATOM   3869  C   PRO E  11      73.142  44.209  47.211  1.00 32.31           C  
ATOM   3870  O   PRO E  11      72.575  44.299  46.122  1.00 33.83           O  
ATOM   3871  CB  PRO E  11      75.607  44.316  46.618  1.00 28.93           C  
ATOM   3872  CG  PRO E  11      76.571  43.241  46.209  1.00 30.55           C  
ATOM   3873  CD  PRO E  11      75.655  42.158  45.695  1.00 27.58           C  
ATOM   3874  N   LYS E  12      72.614  44.684  48.333  1.00 33.98           N  
ATOM   3875  CA  LYS E  12      71.313  45.340  48.328  1.00 34.51           C  
ATOM   3876  C   LYS E  12      71.326  46.704  47.643  1.00 34.50           C  
ATOM   3877  O   LYS E  12      72.215  47.522  47.868  1.00 35.33           O  
ATOM   3878  CB  LYS E  12      70.783  45.479  49.757  1.00 33.20           C  
ATOM   3879  CG  LYS E  12      70.194  44.195  50.313  1.00 36.32           C  
ATOM   3880  CD  LYS E  12      69.557  44.442  51.673  1.00 40.33           C  
ATOM   3881  CE  LYS E  12      68.858  43.203  52.198  1.00 40.04           C  
ATOM   3882  NZ  LYS E  12      69.805  42.069  52.224  1.00 42.09           N  
ATOM   3883  N   PRO E  13      70.337  46.958  46.777  1.00 35.08           N  
ATOM   3884  CA  PRO E  13      70.309  48.253  46.096  1.00 35.57           C  
ATOM   3885  C   PRO E  13      69.820  49.380  47.015  1.00 36.26           C  
ATOM   3886  O   PRO E  13      68.672  49.382  47.472  1.00 34.24           O  
ATOM   3887  CB  PRO E  13      69.383  47.992  44.914  1.00 34.73           C  
ATOM   3888  CG  PRO E  13      68.406  46.996  45.482  1.00 34.66           C  
ATOM   3889  CD  PRO E  13      69.270  46.063  46.286  1.00 33.64           C  
ATOM   3890  N   ILE E  14      70.719  50.321  47.292  1.00 36.44           N  
ATOM   3891  CA  ILE E  14      70.410  51.471  48.135  1.00 37.34           C  
ATOM   3892  C   ILE E  14      70.090  52.653  47.243  1.00 38.28           C  
ATOM   3893  O   ILE E  14      70.989  53.287  46.691  1.00 39.51           O  
ATOM   3894  CB  ILE E  14      71.600  51.888  49.008  1.00 38.37           C  
ATOM   3895  CG1 ILE E  14      71.961  50.766  49.987  1.00 37.62           C  
ATOM   3896  CG2 ILE E  14      71.267  53.203  49.726  1.00 36.84           C  
ATOM   3897  CD1 ILE E  14      73.363  50.893  50.570  1.00 38.05           C  
ATOM   3898  N   GLY E  15      68.808  52.949  47.102  1.00 38.95           N  
ATOM   3899  CA  GLY E  15      68.417  54.061  46.272  1.00 38.08           C  
ATOM   3900  C   GLY E  15      67.278  53.694  45.356  1.00 37.62           C  
ATOM   3901  O   GLY E  15      66.713  52.606  45.465  1.00 36.32           O  
ATOM   3902  N   PRO E  16      66.919  54.597  44.434  1.00 37.25           N  
ATOM   3903  CA  PRO E  16      65.830  54.360  43.490  1.00 37.01           C  
ATOM   3904  C   PRO E  16      66.202  53.448  42.323  1.00 36.84           C  
ATOM   3905  O   PRO E  16      66.024  53.820  41.169  1.00 37.03           O  
ATOM   3906  CB  PRO E  16      65.467  55.770  43.040  1.00 37.99           C  
ATOM   3907  CG  PRO E  16      66.793  56.457  43.044  1.00 36.50           C  
ATOM   3908  CD  PRO E  16      67.427  55.977  44.319  1.00 34.62           C  
ATOM   3909  N   TYR E  17      66.730  52.262  42.620  1.00 37.38           N  
ATOM   3910  CA  TYR E  17      67.075  51.323  41.560  1.00 37.55           C  
ATOM   3911  C   TYR E  17      66.979  49.852  41.973  1.00 35.11           C  
ATOM   3912  O   TYR E  17      66.860  49.535  43.150  1.00 35.60           O  
ATOM   3913  CB  TYR E  17      68.462  51.659  40.989  1.00 43.56           C  
ATOM   3914  CG  TYR E  17      69.680  51.100  41.703  1.00 47.87           C  
ATOM   3915  CD1 TYR E  17      70.068  51.566  42.959  1.00 51.49           C  
ATOM   3916  CD2 TYR E  17      70.493  50.149  41.075  1.00 50.72           C  
ATOM   3917  CE1 TYR E  17      71.251  51.099  43.571  1.00 52.35           C  
ATOM   3918  CE2 TYR E  17      71.663  49.680  41.673  1.00 52.23           C  
ATOM   3919  CZ  TYR E  17      72.037  50.158  42.915  1.00 52.64           C  
ATOM   3920  OH  TYR E  17      73.193  49.690  43.492  1.00 53.82           O  
ATOM   3921  N   SER E  18      67.006  48.947  41.002  1.00 31.94           N  
ATOM   3922  CA  SER E  18      66.903  47.522  41.301  1.00 28.15           C  
ATOM   3923  C   SER E  18      68.179  46.753  40.985  1.00 28.40           C  
ATOM   3924  O   SER E  18      69.043  47.244  40.260  1.00 29.52           O  
ATOM   3925  CB  SER E  18      65.753  46.914  40.507  1.00 26.86           C  
ATOM   3926  OG  SER E  18      64.510  47.479  40.882  1.00 27.88           O  
ATOM   3927  N   GLN E  19      68.302  45.542  41.524  1.00 26.86           N  
ATOM   3928  CA  GLN E  19      69.473  44.722  41.243  1.00 26.00           C  
ATOM   3929  C   GLN E  19      69.428  44.321  39.773  1.00 25.32           C  
ATOM   3930  O   GLN E  19      70.447  44.299  39.085  1.00 26.31           O  
ATOM   3931  CB  GLN E  19      69.485  43.474  42.126  1.00 26.43           C  
ATOM   3932  CG  GLN E  19      69.743  43.765  43.592  1.00 27.61           C  
ATOM   3933  CD  GLN E  19      69.635  42.530  44.451  1.00 27.81           C  
ATOM   3934  OE1 GLN E  19      68.720  41.726  44.279  1.00 30.37           O  
ATOM   3935  NE2 GLN E  19      70.559  42.377  45.390  1.00 25.96           N  
ATOM   3936  N   ALA E  20      68.233  44.011  39.291  1.00 24.69           N  
ATOM   3937  CA  ALA E  20      68.053  43.636  37.900  1.00 23.09           C  
ATOM   3938  C   ALA E  20      66.590  43.748  37.494  1.00 24.31           C  
ATOM   3939  O   ALA E  20      65.691  43.673  38.334  1.00 23.71           O  
ATOM   3940  CB  ALA E  20      68.546  42.218  37.672  1.00 23.05           C  
ATOM   3941  N   ILE E  21      66.373  43.948  36.197  1.00 23.18           N  
ATOM   3942  CA  ILE E  21      65.042  44.048  35.625  1.00 19.80           C  
ATOM   3943  C   ILE E  21      64.953  42.962  34.561  1.00 20.42           C  
ATOM   3944  O   ILE E  21      65.881  42.767  33.781  1.00 20.52           O  
ATOM   3945  CB  ILE E  21      64.808  45.421  34.929  1.00 20.47           C  
ATOM   3946  CG1 ILE E  21      65.023  46.575  35.925  1.00 18.00           C  
ATOM   3947  CG2 ILE E  21      63.406  45.460  34.308  1.00 17.80           C  
ATOM   3948  CD1 ILE E  21      64.091  46.557  37.129  1.00 13.38           C  
ATOM   3949  N   LYS E  22      63.850  42.230  34.551  1.00 20.67           N  
ATOM   3950  CA  LYS E  22      63.653  41.208  33.548  1.00 22.40           C  
ATOM   3951  C   LYS E  22      62.631  41.793  32.569  1.00 23.77           C  
ATOM   3952  O   LYS E  22      61.526  42.155  32.967  1.00 25.54           O  
ATOM   3953  CB  LYS E  22      63.127  39.924  34.199  1.00 24.05           C  
ATOM   3954  CG  LYS E  22      62.879  38.789  33.225  1.00 25.79           C  
ATOM   3955  CD  LYS E  22      62.234  37.608  33.912  1.00 31.27           C  
ATOM   3956  CE  LYS E  22      61.856  36.531  32.901  1.00 37.38           C  
ATOM   3957  NZ  LYS E  22      63.054  36.056  32.142  1.00 40.13           N  
ATOM   3958  N   ALA E  23      63.004  41.908  31.297  1.00 24.53           N  
ATOM   3959  CA  ALA E  23      62.108  42.464  30.276  1.00 25.40           C  
ATOM   3960  C   ALA E  23      61.990  41.483  29.114  1.00 26.19           C  
ATOM   3961  O   ALA E  23      62.966  41.219  28.409  1.00 25.79           O  
ATOM   3962  CB  ALA E  23      62.643  43.797  29.786  1.00 24.05           C  
ATOM   3963  N   GLY E  24      60.794  40.946  28.902  1.00 26.56           N  
ATOM   3964  CA  GLY E  24      60.643  39.971  27.846  1.00 27.66           C  
ATOM   3965  C   GLY E  24      61.586  38.842  28.218  1.00 29.53           C  
ATOM   3966  O   GLY E  24      61.565  38.359  29.354  1.00 28.27           O  
ATOM   3967  N   ASN E  25      62.436  38.443  27.278  1.00 31.66           N  
ATOM   3968  CA  ASN E  25      63.394  37.376  27.517  1.00 32.52           C  
ATOM   3969  C   ASN E  25      64.762  37.886  27.964  1.00 32.61           C  
ATOM   3970  O   ASN E  25      65.684  37.094  28.183  1.00 32.29           O  
ATOM   3971  CB  ASN E  25      63.564  36.539  26.252  1.00 36.41           C  
ATOM   3972  CG  ASN E  25      62.260  35.937  25.776  1.00 40.53           C  
ATOM   3973  OD1 ASN E  25      61.419  35.523  26.588  1.00 41.88           O  
ATOM   3974  ND2 ASN E  25      62.081  35.873  24.454  1.00 40.16           N  
ATOM   3975  N   PHE E  26      64.901  39.200  28.088  1.00 30.56           N  
ATOM   3976  CA  PHE E  26      66.170  39.782  28.506  1.00 29.27           C  
ATOM   3977  C   PHE E  26      66.215  40.083  29.994  1.00 29.17           C  
ATOM   3978  O   PHE E  26      65.186  40.351  30.628  1.00 28.16           O  
ATOM   3979  CB  PHE E  26      66.445  41.066  27.727  1.00 28.92           C  
ATOM   3980  CG  PHE E  26      66.887  40.831  26.321  1.00 31.29           C  
ATOM   3981  CD1 PHE E  26      68.219  40.513  26.041  1.00 31.04           C  
ATOM   3982  CD2 PHE E  26      65.972  40.894  25.273  1.00 31.82           C  
ATOM   3983  CE1 PHE E  26      68.637  40.255  24.735  1.00 31.95           C  
ATOM   3984  CE2 PHE E  26      66.375  40.637  23.958  1.00 32.98           C  
ATOM   3985  CZ  PHE E  26      67.716  40.316  23.689  1.00 32.70           C  
ATOM   3986  N   LEU E  27      67.422  40.021  30.546  1.00 27.41           N  
ATOM   3987  CA  LEU E  27      67.632  40.319  31.951  1.00 24.02           C  
ATOM   3988  C   LEU E  27      68.683  41.411  32.007  1.00 22.74           C  
ATOM   3989  O   LEU E  27      69.799  41.218  31.560  1.00 21.91           O  
ATOM   3990  CB  LEU E  27      68.126  39.079  32.698  1.00 22.99           C  
ATOM   3991  CG  LEU E  27      68.301  39.274  34.209  1.00 21.33           C  
ATOM   3992  CD1 LEU E  27      66.939  39.554  34.849  1.00 16.17           C  
ATOM   3993  CD2 LEU E  27      68.948  38.032  34.815  1.00 20.69           C  
ATOM   3994  N   PHE E  28      68.323  42.574  32.525  1.00 24.17           N  
ATOM   3995  CA  PHE E  28      69.286  43.667  32.617  1.00 23.19           C  
ATOM   3996  C   PHE E  28      69.813  43.775  34.043  1.00 24.84           C  
ATOM   3997  O   PHE E  28      69.054  44.039  34.981  1.00 23.62           O  
ATOM   3998  CB  PHE E  28      68.632  44.978  32.162  1.00 21.98           C  
ATOM   3999  CG  PHE E  28      68.288  44.991  30.692  1.00 19.84           C  
ATOM   4000  CD1 PHE E  28      67.219  44.249  30.208  1.00 18.04           C  
ATOM   4001  CD2 PHE E  28      69.091  45.680  29.786  1.00 18.25           C  
ATOM   4002  CE1 PHE E  28      66.962  44.186  28.841  1.00 20.11           C  
ATOM   4003  CE2 PHE E  28      68.843  45.624  28.427  1.00 17.16           C  
ATOM   4004  CZ  PHE E  28      67.775  44.873  27.951  1.00 17.89           C  
ATOM   4005  N   ILE E  29      71.120  43.568  34.202  1.00 24.88           N  
ATOM   4006  CA  ILE E  29      71.729  43.611  35.525  1.00 24.45           C  
ATOM   4007  C   ILE E  29      72.459  44.898  35.865  1.00 24.95           C  
ATOM   4008  O   ILE E  29      73.351  45.353  35.146  1.00 23.60           O  
ATOM   4009  CB  ILE E  29      72.684  42.434  35.729  1.00 24.48           C  
ATOM   4010  CG1 ILE E  29      71.992  41.133  35.306  1.00 28.10           C  
ATOM   4011  CG2 ILE E  29      73.055  42.333  37.198  1.00 28.54           C  
ATOM   4012  CD1 ILE E  29      72.809  39.877  35.519  1.00 26.83           C  
ATOM   4013  N   ALA E  30      72.061  45.486  36.983  1.00 24.32           N  
ATOM   4014  CA  ALA E  30      72.658  46.722  37.433  1.00 23.08           C  
ATOM   4015  C   ALA E  30      74.160  46.539  37.645  1.00 22.98           C  
ATOM   4016  O   ALA E  30      74.640  45.415  37.839  1.00 23.80           O  
ATOM   4017  CB  ALA E  30      71.992  47.159  38.716  1.00 24.46           C  
ATOM   4018  N   GLY E  31      74.899  47.643  37.597  1.00 19.43           N  
ATOM   4019  CA  GLY E  31      76.325  47.564  37.804  1.00 21.63           C  
ATOM   4020  C   GLY E  31      76.607  46.978  39.179  1.00 24.37           C  
ATOM   4021  O   GLY E  31      76.041  47.424  40.176  1.00 25.68           O  
ATOM   4022  N   GLN E  32      77.473  45.970  39.229  1.00 24.99           N  
ATOM   4023  CA  GLN E  32      77.832  45.324  40.483  1.00 24.66           C  
ATOM   4024  C   GLN E  32      79.250  45.659  40.917  1.00 23.76           C  
ATOM   4025  O   GLN E  32      80.177  45.629  40.113  1.00 20.10           O  
ATOM   4026  CB  GLN E  32      77.720  43.804  40.348  1.00 26.14           C  
ATOM   4027  CG  GLN E  32      76.317  43.310  40.131  1.00 27.50           C  
ATOM   4028  CD  GLN E  32      75.379  43.791  41.209  1.00 28.20           C  
ATOM   4029  OE1 GLN E  32      75.524  43.442  42.381  1.00 25.28           O  
ATOM   4030  NE2 GLN E  32      74.409  44.606  40.819  1.00 27.62           N  
ATOM   4031  N   ILE E  33      79.406  45.980  42.196  1.00 25.44           N  
ATOM   4032  CA  ILE E  33      80.716  46.275  42.758  1.00 27.25           C  
ATOM   4033  C   ILE E  33      81.041  45.155  43.751  1.00 28.51           C  
ATOM   4034  O   ILE E  33      80.153  44.427  44.189  1.00 26.84           O  
ATOM   4035  CB  ILE E  33      80.759  47.664  43.450  1.00 27.80           C  
ATOM   4036  CG1 ILE E  33      79.658  47.782  44.494  1.00 29.61           C  
ATOM   4037  CG2 ILE E  33      80.603  48.767  42.420  1.00 25.61           C  
ATOM   4038  CD1 ILE E  33      79.699  49.108  45.230  1.00 32.74           C  
ATOM   4039  N   PRO E  34      82.324  45.000  44.108  1.00 30.62           N  
ATOM   4040  CA  PRO E  34      82.814  43.975  45.035  1.00 31.90           C  
ATOM   4041  C   PRO E  34      82.426  44.080  46.518  1.00 32.88           C  
ATOM   4042  O   PRO E  34      83.276  44.283  47.388  1.00 34.27           O  
ATOM   4043  CB  PRO E  34      84.324  44.031  44.818  1.00 31.01           C  
ATOM   4044  CG  PRO E  34      84.543  45.465  44.565  1.00 29.53           C  
ATOM   4045  CD  PRO E  34      83.447  45.795  43.590  1.00 30.15           C  
ATOM   4046  N   ILE E  35      81.140  43.921  46.797  1.00 32.10           N  
ATOM   4047  CA  ILE E  35      80.643  43.962  48.159  1.00 30.57           C  
ATOM   4048  C   ILE E  35      80.275  42.556  48.581  1.00 31.38           C  
ATOM   4049  O   ILE E  35      79.685  41.803  47.820  1.00 30.41           O  
ATOM   4050  CB  ILE E  35      79.387  44.837  48.280  1.00 30.42           C  
ATOM   4051  CG1 ILE E  35      79.776  46.309  48.192  1.00 30.13           C  
ATOM   4052  CG2 ILE E  35      78.653  44.534  49.591  1.00 28.78           C  
ATOM   4053  CD1 ILE E  35      78.625  47.189  47.814  1.00 29.05           C  
ATOM   4054  N   ASP E  36      80.636  42.207  49.805  1.00 33.91           N  
ATOM   4055  CA  ASP E  36      80.321  40.904  50.344  1.00 34.81           C  
ATOM   4056  C   ASP E  36      78.921  41.081  50.906  1.00 35.19           C  
ATOM   4057  O   ASP E  36      78.743  41.717  51.939  1.00 35.17           O  
ATOM   4058  CB  ASP E  36      81.290  40.559  51.465  1.00 36.45           C  
ATOM   4059  CG  ASP E  36      81.218  39.114  51.866  1.00 39.88           C  
ATOM   4060  OD1 ASP E  36      80.112  38.529  51.804  1.00 42.57           O  
ATOM   4061  OD2 ASP E  36      82.270  38.566  52.259  1.00 42.90           O  
ATOM   4062  N   PRO E  37      77.904  40.534  50.226  1.00 35.18           N  
ATOM   4063  CA  PRO E  37      76.527  40.678  50.718  1.00 35.76           C  
ATOM   4064  C   PRO E  37      76.249  40.183  52.149  1.00 35.54           C  
ATOM   4065  O   PRO E  37      75.429  40.766  52.861  1.00 32.90           O  
ATOM   4066  CB  PRO E  37      75.695  39.949  49.649  1.00 35.03           C  
ATOM   4067  CG  PRO E  37      76.672  38.981  49.040  1.00 35.21           C  
ATOM   4068  CD  PRO E  37      77.938  39.787  48.959  1.00 33.88           C  
ATOM   4069  N   LYS E  38      76.924  39.119  52.568  1.00 36.57           N  
ATOM   4070  CA  LYS E  38      76.723  38.586  53.912  1.00 38.28           C  
ATOM   4071  C   LYS E  38      77.159  39.602  54.962  1.00 38.22           C  
ATOM   4072  O   LYS E  38      76.566  39.699  56.036  1.00 37.86           O  
ATOM   4073  CB  LYS E  38      77.534  37.298  54.110  1.00 40.96           C  
ATOM   4074  CG  LYS E  38      76.892  36.034  53.564  1.00 43.86           C  
ATOM   4075  CD  LYS E  38      75.638  35.670  54.346  1.00 48.24           C  
ATOM   4076  CE  LYS E  38      74.976  34.410  53.799  1.00 48.70           C  
ATOM   4077  NZ  LYS E  38      75.851  33.206  53.931  1.00 52.13           N  
ATOM   4078  N   THR E  39      78.194  40.362  54.632  1.00 37.39           N  
ATOM   4079  CA  THR E  39      78.745  41.347  55.549  1.00 36.32           C  
ATOM   4080  C   THR E  39      78.443  42.791  55.156  1.00 35.62           C  
ATOM   4081  O   THR E  39      78.501  43.691  55.993  1.00 35.49           O  
ATOM   4082  CB  THR E  39      80.271  41.168  55.654  1.00 35.85           C  
ATOM   4083  OG1 THR E  39      80.706  41.532  56.967  1.00 39.21           O  
ATOM   4084  CG2 THR E  39      80.984  42.041  54.632  1.00 34.35           C  
ATOM   4085  N   GLY E  40      78.139  43.009  53.880  1.00 34.68           N  
ATOM   4086  CA  GLY E  40      77.837  44.345  53.396  1.00 34.74           C  
ATOM   4087  C   GLY E  40      79.046  45.245  53.226  1.00 36.78           C  
ATOM   4088  O   GLY E  40      78.902  46.461  53.114  1.00 38.12           O  
ATOM   4089  N   GLU E  41      80.239  44.655  53.193  1.00 38.38           N  
ATOM   4090  CA  GLU E  41      81.477  45.412  53.045  1.00 37.98           C  
ATOM   4091  C   GLU E  41      82.252  44.986  51.806  1.00 38.51           C  
ATOM   4092  O   GLU E  41      82.041  43.895  51.275  1.00 36.29           O  
ATOM   4093  CB  GLU E  41      82.351  45.206  54.278  1.00 39.07           C  
ATOM   4094  CG  GLU E  41      81.645  45.536  55.577  1.00 42.10           C  
ATOM   4095  CD  GLU E  41      82.319  44.895  56.774  1.00 44.80           C  
ATOM   4096  OE1 GLU E  41      81.777  44.999  57.895  1.00 45.92           O  
ATOM   4097  OE2 GLU E  41      83.391  44.285  56.594  1.00 47.28           O  
ATOM   4098  N   ILE E  42      83.156  45.847  51.349  1.00 39.44           N  
ATOM   4099  CA  ILE E  42      83.957  45.536  50.175  1.00 41.16           C  
ATOM   4100  C   ILE E  42      84.985  44.474  50.557  1.00 42.14           C  
ATOM   4101  O   ILE E  42      85.495  44.478  51.675  1.00 43.17           O  
ATOM   4102  CB  ILE E  42      84.691  46.780  49.654  1.00 40.90           C  
ATOM   4103  CG1 ILE E  42      83.723  47.956  49.562  1.00 41.54           C  
ATOM   4104  CG2 ILE E  42      85.248  46.505  48.268  1.00 42.37           C  
ATOM   4105  CD1 ILE E  42      84.366  49.225  49.055  1.00 42.62           C  
ATOM   4106  N   VAL E  43      85.292  43.559  49.645  1.00 42.35           N  
ATOM   4107  CA  VAL E  43      86.258  42.518  49.970  1.00 43.40           C  
ATOM   4108  C   VAL E  43      87.681  43.057  50.024  1.00 43.81           C  
ATOM   4109  O   VAL E  43      88.562  42.333  50.543  1.00 46.38           O  
ATOM   4110  CB  VAL E  43      86.196  41.332  48.968  1.00 43.29           C  
ATOM   4111  CG1 VAL E  43      84.827  40.665  49.032  1.00 41.11           C  
ATOM   4112  CG2 VAL E  43      86.498  41.816  47.559  1.00 44.84           C  
ATOM   4113  N   GLY E  45      91.422  42.220  49.040  1.00 60.13           N  
ATOM   4114  CA  GLY E  45      91.294  43.638  48.585  1.00 60.25           C  
ATOM   4115  C   GLY E  45      91.923  43.898  47.225  1.00 59.80           C  
ATOM   4116  O   GLY E  45      91.754  44.978  46.653  1.00 58.83           O  
ATOM   4117  N   ASP E  46      92.651  42.908  46.707  1.00 58.69           N  
ATOM   4118  CA  ASP E  46      93.303  43.031  45.403  1.00 57.56           C  
ATOM   4119  C   ASP E  46      92.328  42.708  44.264  1.00 55.54           C  
ATOM   4120  O   ASP E  46      91.350  41.978  44.457  1.00 54.18           O  
ATOM   4121  CB  ASP E  46      94.514  42.096  45.330  1.00 59.27           C  
ATOM   4122  CG  ASP E  46      94.119  40.628  45.285  1.00 62.35           C  
ATOM   4123  OD1 ASP E  46      93.377  40.172  46.186  1.00 62.32           O  
ATOM   4124  OD2 ASP E  46      94.557  39.929  44.343  1.00 64.18           O  
ATOM   4125  N   ILE E  47      92.611  43.251  43.081  1.00 52.08           N  
ATOM   4126  CA  ILE E  47      91.773  43.055  41.899  1.00 50.31           C  
ATOM   4127  C   ILE E  47      91.260  41.621  41.696  1.00 49.78           C  
ATOM   4128  O   ILE E  47      90.081  41.414  41.418  1.00 49.70           O  
ATOM   4129  CB  ILE E  47      92.521  43.522  40.615  1.00 49.89           C  
ATOM   4130  CG1 ILE E  47      91.637  43.342  39.375  1.00 49.11           C  
ATOM   4131  CG2 ILE E  47      93.802  42.735  40.450  1.00 49.02           C  
ATOM   4132  CD1 ILE E  47      90.332  44.124  39.399  1.00 47.56           C  
ATOM   4133  N   LYS E  48      92.136  40.634  41.836  1.00 48.89           N  
ATOM   4134  CA  LYS E  48      91.738  39.239  41.655  1.00 48.61           C  
ATOM   4135  C   LYS E  48      90.557  38.851  42.547  1.00 46.77           C  
ATOM   4136  O   LYS E  48      89.679  38.089  42.144  1.00 43.53           O  
ATOM   4137  CB  LYS E  48      92.922  38.323  41.962  1.00 51.34           C  
ATOM   4138  CG  LYS E  48      93.314  37.392  40.827  1.00 52.65           C  
ATOM   4139  CD  LYS E  48      94.650  36.732  41.121  1.00 54.99           C  
ATOM   4140  CE  LYS E  48      95.105  35.901  39.946  1.00 56.86           C  
ATOM   4141  NZ  LYS E  48      95.072  36.697  38.685  1.00 60.00           N  
ATOM   4142  N   ASP E  49      90.553  39.378  43.765  1.00 46.37           N  
ATOM   4143  CA  ASP E  49      89.498  39.089  44.728  1.00 45.49           C  
ATOM   4144  C   ASP E  49      88.251  39.950  44.505  1.00 42.96           C  
ATOM   4145  O   ASP E  49      87.136  39.452  44.613  1.00 41.67           O  
ATOM   4146  CB  ASP E  49      90.044  39.267  46.146  1.00 49.14           C  
ATOM   4147  CG  ASP E  49      91.103  38.224  46.496  1.00 53.36           C  
ATOM   4148  OD1 ASP E  49      91.871  38.452  47.460  1.00 54.92           O  
ATOM   4149  OD2 ASP E  49      91.158  37.172  45.810  1.00 53.86           O  
ATOM   4150  N   GLN E  50      88.436  41.233  44.201  1.00 40.45           N  
ATOM   4151  CA  GLN E  50      87.299  42.114  43.933  1.00 39.87           C  
ATOM   4152  C   GLN E  50      86.610  41.674  42.637  1.00 37.99           C  
ATOM   4153  O   GLN E  50      85.388  41.740  42.506  1.00 34.03           O  
ATOM   4154  CB  GLN E  50      87.756  43.577  43.810  1.00 38.98           C  
ATOM   4155  CG  GLN E  50      87.797  44.314  45.137  1.00 40.74           C  
ATOM   4156  CD  GLN E  50      88.147  45.783  44.996  1.00 42.63           C  
ATOM   4157  OE1 GLN E  50      87.478  46.538  44.284  1.00 44.45           O  
ATOM   4158  NE2 GLN E  50      89.197  46.200  45.683  1.00 46.08           N  
ATOM   4159  N   THR E  51      87.405  41.206  41.685  1.00 36.88           N  
ATOM   4160  CA  THR E  51      86.852  40.754  40.426  1.00 38.08           C  
ATOM   4161  C   THR E  51      86.048  39.461  40.642  1.00 37.18           C  
ATOM   4162  O   THR E  51      85.052  39.227  39.962  1.00 38.23           O  
ATOM   4163  CB  THR E  51      87.972  40.551  39.365  1.00 36.34           C  
ATOM   4164  OG1 THR E  51      87.396  40.156  38.117  1.00 35.78           O  
ATOM   4165  CG2 THR E  51      88.931  39.482  39.803  1.00 42.59           C  
ATOM   4166  N   ARG E  52      86.440  38.636  41.604  1.00 36.85           N  
ATOM   4167  CA  ARG E  52      85.690  37.402  41.844  1.00 38.25           C  
ATOM   4168  C   ARG E  52      84.372  37.634  42.599  1.00 36.27           C  
ATOM   4169  O   ARG E  52      83.364  36.974  42.323  1.00 35.99           O  
ATOM   4170  CB  ARG E  52      86.531  36.391  42.625  1.00 40.50           C  
ATOM   4171  CG  ARG E  52      85.915  34.997  42.656  1.00 44.91           C  
ATOM   4172  CD  ARG E  52      86.198  34.305  43.975  1.00 49.73           C  
ATOM   4173  NE  ARG E  52      87.627  34.216  44.263  1.00 55.23           N  
ATOM   4174  CZ  ARG E  52      88.134  34.197  45.493  1.00 57.61           C  
ATOM   4175  NH1 ARG E  52      89.447  34.108  45.674  1.00 57.86           N  
ATOM   4176  NH2 ARG E  52      87.325  34.284  46.545  1.00 59.00           N  
ATOM   4177  N   GLN E  53      84.373  38.558  43.558  1.00 32.95           N  
ATOM   4178  CA  GLN E  53      83.159  38.831  44.318  1.00 30.88           C  
ATOM   4179  C   GLN E  53      82.117  39.472  43.409  1.00 29.37           C  
ATOM   4180  O   GLN E  53      80.932  39.191  43.530  1.00 27.90           O  
ATOM   4181  CB  GLN E  53      83.456  39.740  45.522  1.00 30.36           C  
ATOM   4182  CG  GLN E  53      82.239  40.092  46.390  1.00 28.92           C  
ATOM   4183  CD  GLN E  53      81.540  38.872  46.972  1.00 29.74           C  
ATOM   4184  OE1 GLN E  53      82.168  38.024  47.597  1.00 31.95           O  
ATOM   4185  NE2 GLN E  53      80.230  38.786  46.774  1.00 28.69           N  
ATOM   4186  N   VAL E  54      82.555  40.322  42.488  1.00 29.18           N  
ATOM   4187  CA  VAL E  54      81.608  40.950  41.577  1.00 28.78           C  
ATOM   4188  C   VAL E  54      80.937  39.884  40.724  1.00 28.96           C  
ATOM   4189  O   VAL E  54      79.719  39.912  40.533  1.00 31.63           O  
ATOM   4190  CB  VAL E  54      82.275  41.962  40.638  1.00 27.20           C  
ATOM   4191  CG1 VAL E  54      81.253  42.494  39.669  1.00 27.60           C  
ATOM   4192  CG2 VAL E  54      82.864  43.101  41.426  1.00 26.32           C  
ATOM   4193  N   LEU E  55      81.732  38.946  40.221  1.00 27.36           N  
ATOM   4194  CA  LEU E  55      81.207  37.869  39.390  1.00 29.37           C  
ATOM   4195  C   LEU E  55      80.286  36.961  40.192  1.00 30.83           C  
ATOM   4196  O   LEU E  55      79.331  36.391  39.655  1.00 30.12           O  
ATOM   4197  CB  LEU E  55      82.354  37.049  38.786  1.00 29.96           C  
ATOM   4198  CG  LEU E  55      82.704  37.268  37.304  1.00 29.07           C  
ATOM   4199  CD1 LEU E  55      82.666  38.745  36.976  1.00 28.90           C  
ATOM   4200  CD2 LEU E  55      84.087  36.689  36.998  1.00 26.59           C  
ATOM   4201  N   GLU E  56      80.568  36.841  41.484  1.00 32.32           N  
ATOM   4202  CA  GLU E  56      79.756  36.002  42.352  1.00 33.81           C  
ATOM   4203  C   GLU E  56      78.400  36.678  42.529  1.00 32.12           C  
ATOM   4204  O   GLU E  56      77.364  36.015  42.561  1.00 33.30           O  
ATOM   4205  CB  GLU E  56      80.438  35.823  43.713  1.00 38.57           C  
ATOM   4206  CG  GLU E  56      80.183  34.471  44.393  1.00 48.16           C  
ATOM   4207  CD  GLU E  56      81.131  33.357  43.925  1.00 54.06           C  
ATOM   4208  OE1 GLU E  56      82.365  33.581  43.946  1.00 57.78           O  
ATOM   4209  OE2 GLU E  56      80.648  32.256  43.552  1.00 55.46           O  
ATOM   4210  N   ASN E  57      78.401  38.003  42.616  1.00 31.52           N  
ATOM   4211  CA  ASN E  57      77.157  38.746  42.793  1.00 29.46           C  
ATOM   4212  C   ASN E  57      76.307  38.672  41.539  1.00 28.73           C  
ATOM   4213  O   ASN E  57      75.082  38.518  41.609  1.00 26.25           O  
ATOM   4214  CB  ASN E  57      77.448  40.210  43.161  1.00 29.69           C  
ATOM   4215  CG  ASN E  57      78.061  40.354  44.567  1.00 31.18           C  
ATOM   4216  OD1 ASN E  57      77.883  39.480  45.423  1.00 27.36           O  
ATOM   4217  ND2 ASN E  57      78.773  41.460  44.804  1.00 25.97           N  
ATOM   4218  N   ILE E  58      76.964  38.771  40.385  1.00 26.90           N  
ATOM   4219  CA  ILE E  58      76.253  38.706  39.124  1.00 23.69           C  
ATOM   4220  C   ILE E  58      75.595  37.348  38.969  1.00 24.77           C  
ATOM   4221  O   ILE E  58      74.463  37.243  38.481  1.00 24.32           O  
ATOM   4222  CB  ILE E  58      77.199  38.955  37.951  1.00 24.86           C  
ATOM   4223  CG1 ILE E  58      77.714  40.393  38.034  1.00 22.79           C  
ATOM   4224  CG2 ILE E  58      76.498  38.631  36.620  1.00 19.26           C  
ATOM   4225  CD1 ILE E  58      78.445  40.871  36.802  1.00 26.57           C  
ATOM   4226  N   LYS E  59      76.302  36.310  39.405  1.00 24.43           N  
ATOM   4227  CA  LYS E  59      75.790  34.953  39.310  1.00 24.86           C  
ATOM   4228  C   LYS E  59      74.609  34.725  40.270  1.00 24.59           C  
ATOM   4229  O   LYS E  59      73.704  33.929  39.993  1.00 22.32           O  
ATOM   4230  CB  LYS E  59      76.919  33.951  39.583  1.00 26.69           C  
ATOM   4231  CG  LYS E  59      76.504  32.492  39.390  1.00 28.70           C  
ATOM   4232  CD  LYS E  59      77.626  31.535  39.739  1.00 31.57           C  
ATOM   4233  CE  LYS E  59      77.193  30.095  39.504  1.00 37.46           C  
ATOM   4234  NZ  LYS E  59      78.258  29.113  39.853  1.00 39.15           N  
ATOM   4235  N   ALA E  60      74.623  35.415  41.406  1.00 24.27           N  
ATOM   4236  CA  ALA E  60      73.534  35.290  42.366  1.00 22.87           C  
ATOM   4237  C   ALA E  60      72.297  35.871  41.704  1.00 22.45           C  
ATOM   4238  O   ALA E  60      71.249  35.213  41.615  1.00 23.73           O  
ATOM   4239  CB  ALA E  60      73.856  36.063  43.651  1.00 23.62           C  
ATOM   4240  N   ILE E  61      72.422  37.110  41.242  1.00 19.92           N  
ATOM   4241  CA  ILE E  61      71.317  37.772  40.569  1.00 20.63           C  
ATOM   4242  C   ILE E  61      70.829  36.889  39.413  1.00 22.05           C  
ATOM   4243  O   ILE E  61      69.644  36.610  39.319  1.00 21.19           O  
ATOM   4244  CB  ILE E  61      71.742  39.166  40.042  1.00 19.04           C  
ATOM   4245  CG1 ILE E  61      72.134  40.068  41.219  1.00 14.84           C  
ATOM   4246  CG2 ILE E  61      70.608  39.793  39.237  1.00 19.10           C  
ATOM   4247  CD1 ILE E  61      72.981  41.292  40.849  1.00 13.32           C  
ATOM   4248  N   LEU E  62      71.747  36.435  38.556  1.00 25.68           N  
ATOM   4249  CA  LEU E  62      71.395  35.569  37.423  1.00 27.30           C  
ATOM   4250  C   LEU E  62      70.563  34.366  37.846  1.00 30.55           C  
ATOM   4251  O   LEU E  62      69.568  34.018  37.208  1.00 32.07           O  
ATOM   4252  CB  LEU E  62      72.653  35.050  36.729  1.00 25.35           C  
ATOM   4253  CG  LEU E  62      73.263  35.872  35.592  1.00 28.12           C  
ATOM   4254  CD1 LEU E  62      74.603  35.265  35.183  1.00 23.45           C  
ATOM   4255  CD2 LEU E  62      72.292  35.905  34.411  1.00 26.95           C  
ATOM   4256  N   GLU E  63      70.979  33.724  38.929  1.00 33.73           N  
ATOM   4257  CA  GLU E  63      70.289  32.547  39.429  1.00 36.10           C  
ATOM   4258  C   GLU E  63      68.927  32.867  40.048  1.00 36.26           C  
ATOM   4259  O   GLU E  63      67.996  32.069  39.962  1.00 35.74           O  
ATOM   4260  CB  GLU E  63      71.173  31.834  40.450  1.00 38.46           C  
ATOM   4261  CG  GLU E  63      71.107  30.330  40.351  1.00 45.08           C  
ATOM   4262  CD  GLU E  63      72.475  29.680  40.423  1.00 50.15           C  
ATOM   4263  OE1 GLU E  63      72.556  28.450  40.183  1.00 54.00           O  
ATOM   4264  OE2 GLU E  63      73.466  30.390  40.720  1.00 51.06           O  
ATOM   4265  N   ALA E  64      68.804  34.035  40.666  1.00 35.66           N  
ATOM   4266  CA  ALA E  64      67.537  34.404  41.286  1.00 35.21           C  
ATOM   4267  C   ALA E  64      66.448  34.661  40.249  1.00 35.66           C  
ATOM   4268  O   ALA E  64      65.268  34.632  40.577  1.00 37.25           O  
ATOM   4269  CB  ALA E  64      67.718  35.630  42.176  1.00 33.32           C  
ATOM   4270  N   ALA E  65      66.841  34.906  38.999  1.00 35.00           N  
ATOM   4271  CA  ALA E  65      65.877  35.167  37.933  1.00 34.47           C  
ATOM   4272  C   ALA E  65      65.621  33.932  37.059  1.00 34.95           C  
ATOM   4273  O   ALA E  65      64.773  33.958  36.165  1.00 35.64           O  
ATOM   4274  CB  ALA E  65      66.354  36.329  37.069  1.00 31.38           C  
ATOM   4275  N   GLY E  66      66.349  32.851  37.315  1.00 33.80           N  
ATOM   4276  CA  GLY E  66      66.157  31.644  36.534  1.00 31.66           C  
ATOM   4277  C   GLY E  66      67.081  31.547  35.338  1.00 31.87           C  
ATOM   4278  O   GLY E  66      66.863  30.728  34.447  1.00 32.45           O  
ATOM   4279  N   TYR E  67      68.111  32.385  35.320  1.00 31.49           N  
ATOM   4280  CA  TYR E  67      69.097  32.407  34.243  1.00 30.45           C  
ATOM   4281  C   TYR E  67      70.394  31.763  34.732  1.00 32.60           C  
ATOM   4282  O   TYR E  67      70.570  31.523  35.934  1.00 32.77           O  
ATOM   4283  CB  TYR E  67      69.393  33.850  33.824  1.00 28.80           C  
ATOM   4284  CG  TYR E  67      68.302  34.539  33.028  1.00 26.56           C  
ATOM   4285  CD1 TYR E  67      68.485  34.826  31.670  1.00 23.40           C  
ATOM   4286  CD2 TYR E  67      67.116  34.953  33.637  1.00 25.63           C  
ATOM   4287  CE1 TYR E  67      67.527  35.512  30.943  1.00 22.69           C  
ATOM   4288  CE2 TYR E  67      66.136  35.639  32.910  1.00 26.90           C  
ATOM   4289  CZ  TYR E  67      66.355  35.922  31.560  1.00 25.04           C  
ATOM   4290  OH  TYR E  67      65.426  36.641  30.842  1.00 21.22           O  
ATOM   4291  N   SER E  68      71.307  31.509  33.795  1.00 32.97           N  
ATOM   4292  CA  SER E  68      72.602  30.897  34.100  1.00 32.04           C  
ATOM   4293  C   SER E  68      73.726  31.707  33.461  1.00 31.43           C  
ATOM   4294  O   SER E  68      73.476  32.630  32.693  1.00 33.35           O  
ATOM   4295  CB  SER E  68      72.643  29.464  33.558  1.00 32.30           C  
ATOM   4296  OG  SER E  68      72.574  29.454  32.142  1.00 30.49           O  
ATOM   4297  N   LEU E  69      74.967  31.362  33.764  1.00 30.36           N  
ATOM   4298  CA  LEU E  69      76.086  32.085  33.188  1.00 30.97           C  
ATOM   4299  C   LEU E  69      76.164  31.900  31.671  1.00 31.89           C  
ATOM   4300  O   LEU E  69      76.799  32.691  30.970  1.00 30.88           O  
ATOM   4301  CB  LEU E  69      77.390  31.640  33.852  1.00 30.48           C  
ATOM   4302  CG  LEU E  69      77.624  32.305  35.202  1.00 30.06           C  
ATOM   4303  CD1 LEU E  69      78.823  31.684  35.885  1.00 31.08           C  
ATOM   4304  CD2 LEU E  69      77.836  33.798  34.988  1.00 28.56           C  
ATOM   4305  N   ASN E  70      75.511  30.856  31.169  1.00 32.99           N  
ATOM   4306  CA  ASN E  70      75.497  30.586  29.732  1.00 33.45           C  
ATOM   4307  C   ASN E  70      74.514  31.502  29.004  1.00 31.30           C  
ATOM   4308  O   ASN E  70      74.531  31.603  27.779  1.00 27.72           O  
ATOM   4309  CB  ASN E  70      75.127  29.123  29.465  1.00 37.27           C  
ATOM   4310  CG  ASN E  70      76.214  28.155  29.900  1.00 43.96           C  
ATOM   4311  OD1 ASN E  70      77.316  28.155  29.345  1.00 46.08           O  
ATOM   4312  ND2 ASN E  70      75.912  27.323  30.905  1.00 47.81           N  
ATOM   4313  N   ASP E  71      73.660  32.175  29.767  1.00 30.49           N  
ATOM   4314  CA  ASP E  71      72.671  33.068  29.188  1.00 29.71           C  
ATOM   4315  C   ASP E  71      73.223  34.471  28.948  1.00 29.47           C  
ATOM   4316  O   ASP E  71      72.644  35.253  28.186  1.00 29.04           O  
ATOM   4317  CB  ASP E  71      71.434  33.140  30.089  1.00 30.82           C  
ATOM   4318  CG  ASP E  71      70.712  31.802  30.205  1.00 33.48           C  
ATOM   4319  OD1 ASP E  71      70.632  31.082  29.183  1.00 35.02           O  
ATOM   4320  OD2 ASP E  71      70.213  31.476  31.306  1.00 33.55           O  
ATOM   4321  N   VAL E  72      74.345  34.782  29.591  1.00 27.31           N  
ATOM   4322  CA  VAL E  72      74.954  36.096  29.453  1.00 24.81           C  
ATOM   4323  C   VAL E  72      75.395  36.331  28.011  1.00 26.42           C  
ATOM   4324  O   VAL E  72      76.078  35.501  27.421  1.00 27.61           O  
ATOM   4325  CB  VAL E  72      76.147  36.244  30.410  1.00 21.43           C  
ATOM   4326  CG1 VAL E  72      76.745  37.636  30.300  1.00 21.83           C  
ATOM   4327  CG2 VAL E  72      75.690  35.979  31.835  1.00 20.89           C  
ATOM   4328  N   ILE E  73      74.997  37.467  27.445  1.00 25.33           N  
ATOM   4329  CA  ILE E  73      75.345  37.779  26.069  1.00 25.39           C  
ATOM   4330  C   ILE E  73      76.247  39.007  25.943  1.00 26.26           C  
ATOM   4331  O   ILE E  73      76.984  39.151  24.975  1.00 25.54           O  
ATOM   4332  CB  ILE E  73      74.060  37.975  25.220  1.00 25.04           C  
ATOM   4333  CG1 ILE E  73      73.309  39.236  25.673  1.00 24.39           C  
ATOM   4334  CG2 ILE E  73      73.166  36.733  25.344  1.00 19.57           C  
ATOM   4335  CD1 ILE E  73      71.992  39.473  24.963  1.00 23.20           C  
ATOM   4336  N   LYS E  74      76.205  39.887  26.933  1.00 28.26           N  
ATOM   4337  CA  LYS E  74      77.028  41.086  26.887  1.00 28.99           C  
ATOM   4338  C   LYS E  74      77.435  41.553  28.289  1.00 28.33           C  
ATOM   4339  O   LYS E  74      76.606  41.727  29.187  1.00 28.49           O  
ATOM   4340  CB  LYS E  74      76.280  42.203  26.152  1.00 30.80           C  
ATOM   4341  CG  LYS E  74      77.057  43.501  26.028  1.00 32.97           C  
ATOM   4342  CD  LYS E  74      76.129  44.631  25.615  1.00 34.35           C  
ATOM   4343  CE  LYS E  74      76.832  45.975  25.673  1.00 37.97           C  
ATOM   4344  NZ  LYS E  74      75.913  47.114  25.344  1.00 40.38           N  
ATOM   4345  N   VAL E  75      78.731  41.744  28.456  1.00 27.50           N  
ATOM   4346  CA  VAL E  75      79.294  42.176  29.713  1.00 26.89           C  
ATOM   4347  C   VAL E  75      80.053  43.479  29.525  1.00 27.71           C  
ATOM   4348  O   VAL E  75      80.802  43.638  28.567  1.00 30.12           O  
ATOM   4349  CB  VAL E  75      80.274  41.123  30.262  1.00 25.08           C  
ATOM   4350  CG1 VAL E  75      80.967  41.659  31.501  1.00 26.30           C  
ATOM   4351  CG2 VAL E  75      79.534  39.847  30.597  1.00 25.78           C  
ATOM   4352  N   THR E  76      79.859  44.422  30.433  1.00 28.34           N  
ATOM   4353  CA  THR E  76      80.588  45.669  30.337  1.00 30.74           C  
ATOM   4354  C   THR E  76      81.457  45.750  31.579  1.00 29.90           C  
ATOM   4355  O   THR E  76      80.970  45.592  32.693  1.00 31.47           O  
ATOM   4356  CB  THR E  76      79.644  46.877  30.267  1.00 31.98           C  
ATOM   4357  OG1 THR E  76      78.658  46.639  29.254  1.00 34.43           O  
ATOM   4358  CG2 THR E  76      80.433  48.156  29.908  1.00 31.45           C  
ATOM   4359  N   VAL E  77      82.750  45.968  31.390  1.00 30.30           N  
ATOM   4360  CA  VAL E  77      83.652  46.036  32.534  1.00 31.00           C  
ATOM   4361  C   VAL E  77      84.273  47.402  32.735  1.00 30.83           C  
ATOM   4362  O   VAL E  77      84.768  48.014  31.794  1.00 28.39           O  
ATOM   4363  CB  VAL E  77      84.801  45.012  32.414  1.00 30.14           C  
ATOM   4364  CG1 VAL E  77      85.692  45.090  33.659  1.00 29.60           C  
ATOM   4365  CG2 VAL E  77      84.240  43.609  32.236  1.00 26.43           C  
ATOM   4366  N   TYR E  78      84.239  47.872  33.971  1.00 33.28           N  
ATOM   4367  CA  TYR E  78      84.831  49.157  34.300  1.00 37.62           C  
ATOM   4368  C   TYR E  78      86.021  48.946  35.230  1.00 39.74           C  
ATOM   4369  O   TYR E  78      85.867  48.432  36.338  1.00 37.93           O  
ATOM   4370  CB  TYR E  78      83.797  50.073  34.960  1.00 36.07           C  
ATOM   4371  CG  TYR E  78      82.640  50.438  34.056  1.00 36.69           C  
ATOM   4372  CD1 TYR E  78      81.505  49.636  33.991  1.00 37.07           C  
ATOM   4373  CD2 TYR E  78      82.677  51.594  33.274  1.00 35.68           C  
ATOM   4374  CE1 TYR E  78      80.428  49.980  33.179  1.00 37.35           C  
ATOM   4375  CE2 TYR E  78      81.612  51.943  32.456  1.00 34.79           C  
ATOM   4376  CZ  TYR E  78      80.485  51.137  32.416  1.00 37.30           C  
ATOM   4377  OH  TYR E  78      79.397  51.497  31.648  1.00 37.05           O  
ATOM   4378  N   LEU E  79      87.205  49.329  34.765  1.00 44.98           N  
ATOM   4379  CA  LEU E  79      88.424  49.193  35.557  1.00 50.92           C  
ATOM   4380  C   LEU E  79      88.899  50.539  36.053  1.00 55.86           C  
ATOM   4381  O   LEU E  79      88.588  51.576  35.467  1.00 56.48           O  
ATOM   4382  CB  LEU E  79      89.554  48.564  34.742  1.00 51.29           C  
ATOM   4383  CG  LEU E  79      89.539  47.068  34.445  1.00 51.43           C  
ATOM   4384  CD1 LEU E  79      90.789  46.709  33.656  1.00 52.90           C  
ATOM   4385  CD2 LEU E  79      89.492  46.285  35.742  1.00 52.03           C  
ATOM   4386  N   LYS E  80      89.674  50.503  37.132  1.00 62.31           N  
ATOM   4387  CA  LYS E  80      90.224  51.702  37.748  1.00 67.60           C  
ATOM   4388  C   LYS E  80      91.735  51.739  37.514  1.00 70.97           C  
ATOM   4389  O   LYS E  80      92.518  51.644  38.461  1.00 73.51           O  
ATOM   4390  CB  LYS E  80      89.930  51.688  39.251  1.00 68.50           C  
ATOM   4391  CG  LYS E  80      90.179  53.001  39.983  1.00 70.39           C  
ATOM   4392  CD  LYS E  80      90.183  52.769  41.491  1.00 71.77           C  
ATOM   4393  CE  LYS E  80      90.161  54.072  42.280  1.00 73.67           C  
ATOM   4394  NZ  LYS E  80      88.836  54.758  42.201  1.00 75.24           N  
ATOM   4395  N   ASP E  81      92.139  51.859  36.252  1.00 73.70           N  
ATOM   4396  CA  ASP E  81      93.556  51.924  35.885  1.00 76.41           C  
ATOM   4397  C   ASP E  81      94.398  50.795  36.492  1.00 76.56           C  
ATOM   4398  O   ASP E  81      95.101  51.048  37.493  1.00 76.71           O  
ATOM   4399  CB  ASP E  81      94.140  53.288  36.288  1.00 78.18           C  
ATOM   4400  CG  ASP E  81      93.419  54.462  35.623  1.00 80.08           C  
ATOM   4401  OD1 ASP E  81      93.816  55.623  35.867  1.00 80.81           O  
ATOM   4402  OD2 ASP E  81      92.455  54.227  34.860  1.00 81.00           O  
ATOM   4403  N   ALA E  86      94.280  42.165  33.014  1.00 60.04           N  
ATOM   4404  CA  ALA E  86      95.313  41.104  32.800  1.00 60.59           C  
ATOM   4405  C   ALA E  86      95.065  39.938  33.750  1.00 60.06           C  
ATOM   4406  O   ALA E  86      94.737  38.829  33.320  1.00 59.23           O  
ATOM   4407  CB  ALA E  86      96.712  41.681  33.024  1.00 61.06           C  
ATOM   4408  N   LYS E  87      95.229  40.186  35.045  1.00 60.01           N  
ATOM   4409  CA  LYS E  87      94.990  39.150  36.041  1.00 59.64           C  
ATOM   4410  C   LYS E  87      93.477  39.036  36.228  1.00 58.95           C  
ATOM   4411  O   LYS E  87      92.966  37.998  36.646  1.00 58.54           O  
ATOM   4412  CB  LYS E  87      95.663  39.519  37.360  1.00 60.12           C  
ATOM   4413  N   MET E  88      92.769  40.114  35.892  1.00 59.07           N  
ATOM   4414  CA  MET E  88      91.315  40.164  36.016  1.00 58.00           C  
ATOM   4415  C   MET E  88      90.644  39.319  34.932  1.00 56.80           C  
ATOM   4416  O   MET E  88      89.437  39.088  34.963  1.00 56.93           O  
ATOM   4417  CB  MET E  88      90.829  41.626  35.961  1.00 58.11           C  
ATOM   4418  CG  MET E  88      90.276  42.123  34.624  1.00 59.62           C  
ATOM   4419  SD  MET E  88      88.488  41.864  34.425  1.00 57.74           S  
ATOM   4420  CE  MET E  88      88.434  40.972  32.875  1.00 57.50           C  
ATOM   4421  N   ASN E  89      91.436  38.848  33.978  1.00 54.99           N  
ATOM   4422  CA  ASN E  89      90.908  38.008  32.916  1.00 54.04           C  
ATOM   4423  C   ASN E  89      91.008  36.544  33.341  1.00 53.31           C  
ATOM   4424  O   ASN E  89      90.290  35.688  32.820  1.00 53.92           O  
ATOM   4425  CB  ASN E  89      91.685  38.251  31.621  1.00 54.44           C  
ATOM   4426  CG  ASN E  89      91.567  39.685  31.135  1.00 56.22           C  
ATOM   4427  OD1 ASN E  89      91.548  40.624  31.936  1.00 58.07           O  
ATOM   4428  ND2 ASN E  89      91.497  39.863  29.824  1.00 56.00           N  
ATOM   4429  N   GLU E  90      91.892  36.255  34.294  1.00 50.74           N  
ATOM   4430  CA  GLU E  90      92.046  34.886  34.773  1.00 48.78           C  
ATOM   4431  C   GLU E  90      90.750  34.445  35.431  1.00 45.95           C  
ATOM   4432  O   GLU E  90      90.211  33.386  35.127  1.00 45.52           O  
ATOM   4433  CB  GLU E  90      93.175  34.779  35.802  1.00 52.08           C  
ATOM   4434  CG  GLU E  90      93.347  33.358  36.347  1.00 56.39           C  
ATOM   4435  CD  GLU E  90      93.853  33.315  37.785  1.00 58.87           C  
ATOM   4436  OE1 GLU E  90      94.939  33.877  38.052  1.00 58.86           O  
ATOM   4437  OE2 GLU E  90      93.162  32.712  38.645  1.00 58.71           O  
ATOM   4438  N   VAL E  91      90.253  35.268  36.344  1.00 43.18           N  
ATOM   4439  CA  VAL E  91      89.018  34.953  37.044  1.00 40.33           C  
ATOM   4440  C   VAL E  91      87.867  35.046  36.058  1.00 37.22           C  
ATOM   4441  O   VAL E  91      86.940  34.231  36.081  1.00 36.32           O  
ATOM   4442  CB  VAL E  91      88.773  35.932  38.229  1.00 41.08           C  
ATOM   4443  CG1 VAL E  91      87.545  35.501  39.036  1.00 37.69           C  
ATOM   4444  CG2 VAL E  91      90.005  35.976  39.116  1.00 40.25           C  
ATOM   4445  N   TYR E  92      87.943  36.032  35.177  1.00 34.27           N  
ATOM   4446  CA  TYR E  92      86.901  36.230  34.181  1.00 34.97           C  
ATOM   4447  C   TYR E  92      86.635  34.967  33.342  1.00 34.73           C  
ATOM   4448  O   TYR E  92      85.482  34.618  33.061  1.00 31.70           O  
ATOM   4449  CB  TYR E  92      87.271  37.394  33.261  1.00 34.23           C  
ATOM   4450  CG  TYR E  92      86.132  37.807  32.365  1.00 37.58           C  
ATOM   4451  CD1 TYR E  92      85.139  38.686  32.812  1.00 38.02           C  
ATOM   4452  CD2 TYR E  92      86.020  37.284  31.080  1.00 37.11           C  
ATOM   4453  CE1 TYR E  92      84.066  39.032  31.987  1.00 38.13           C  
ATOM   4454  CE2 TYR E  92      84.960  37.614  30.256  1.00 38.24           C  
ATOM   4455  CZ  TYR E  92      83.986  38.485  30.707  1.00 39.58           C  
ATOM   4456  OH  TYR E  92      82.938  38.782  29.867  1.00 38.87           O  
ATOM   4457  N   ALA E  93      87.706  34.279  32.955  1.00 35.53           N  
ATOM   4458  CA  ALA E  93      87.590  33.074  32.144  1.00 35.55           C  
ATOM   4459  C   ALA E  93      87.026  31.886  32.907  1.00 36.27           C  
ATOM   4460  O   ALA E  93      86.516  30.951  32.296  1.00 36.73           O  
ATOM   4461  CB  ALA E  93      88.947  32.714  31.542  1.00 35.74           C  
ATOM   4462  N   GLU E  94      87.114  31.909  34.234  1.00 36.55           N  
ATOM   4463  CA  GLU E  94      86.582  30.803  35.025  1.00 37.92           C  
ATOM   4464  C   GLU E  94      85.071  30.799  34.941  1.00 36.92           C  
ATOM   4465  O   GLU E  94      84.442  29.748  34.897  1.00 38.77           O  
ATOM   4466  CB  GLU E  94      87.003  30.935  36.489  1.00 40.54           C  
ATOM   4467  CG  GLU E  94      88.487  30.742  36.717  1.00 44.76           C  
ATOM   4468  CD  GLU E  94      88.911  31.072  38.133  1.00 47.42           C  
ATOM   4469  OE1 GLU E  94      90.102  30.870  38.447  1.00 50.06           O  
ATOM   4470  OE2 GLU E  94      88.063  31.533  38.927  1.00 48.48           O  
ATOM   4471  N   TYR E  95      84.501  31.995  34.908  1.00 36.41           N  
ATOM   4472  CA  TYR E  95      83.063  32.182  34.846  1.00 35.62           C  
ATOM   4473  C   TYR E  95      82.481  32.212  33.433  1.00 35.27           C  
ATOM   4474  O   TYR E  95      81.449  31.600  33.171  1.00 34.36           O  
ATOM   4475  CB  TYR E  95      82.679  33.476  35.574  1.00 36.05           C  
ATOM   4476  CG  TYR E  95      82.806  33.414  37.084  1.00 36.16           C  
ATOM   4477  CD1 TYR E  95      84.043  33.563  37.719  1.00 35.79           C  
ATOM   4478  CD2 TYR E  95      81.680  33.206  37.879  1.00 36.69           C  
ATOM   4479  CE1 TYR E  95      84.150  33.510  39.107  1.00 35.20           C  
ATOM   4480  CE2 TYR E  95      81.774  33.145  39.263  1.00 36.83           C  
ATOM   4481  CZ  TYR E  95      83.005  33.300  39.870  1.00 37.00           C  
ATOM   4482  OH  TYR E  95      83.069  33.258  41.243  1.00 37.51           O  
ATOM   4483  N   PHE E  96      83.141  32.917  32.523  1.00 34.45           N  
ATOM   4484  CA  PHE E  96      82.637  33.028  31.164  1.00 35.40           C  
ATOM   4485  C   PHE E  96      83.358  32.173  30.130  1.00 37.09           C  
ATOM   4486  O   PHE E  96      83.213  32.392  28.927  1.00 38.12           O  
ATOM   4487  CB  PHE E  96      82.644  34.502  30.739  1.00 33.41           C  
ATOM   4488  CG  PHE E  96      81.727  35.364  31.564  1.00 31.58           C  
ATOM   4489  CD1 PHE E  96      80.360  35.103  31.607  1.00 30.75           C  
ATOM   4490  CD2 PHE E  96      82.232  36.410  32.328  1.00 30.29           C  
ATOM   4491  CE1 PHE E  96      79.510  35.869  32.402  1.00 31.36           C  
ATOM   4492  CE2 PHE E  96      81.400  37.182  33.127  1.00 30.22           C  
ATOM   4493  CZ  PHE E  96      80.033  36.914  33.167  1.00 31.55           C  
ATOM   4494  N   GLY E  97      84.119  31.190  30.608  1.00 38.67           N  
ATOM   4495  CA  GLY E  97      84.858  30.303  29.724  1.00 39.16           C  
ATOM   4496  C   GLY E  97      83.990  29.511  28.760  1.00 40.62           C  
ATOM   4497  O   GLY E  97      84.426  29.173  27.661  1.00 40.45           O  
ATOM   4498  N   GLU E  98      82.768  29.195  29.163  1.00 41.27           N  
ATOM   4499  CA  GLU E  98      81.873  28.459  28.281  1.00 42.71           C  
ATOM   4500  C   GLU E  98      80.928  29.430  27.570  1.00 40.72           C  
ATOM   4501  O   GLU E  98      80.797  29.383  26.351  1.00 39.60           O  
ATOM   4502  CB  GLU E  98      81.085  27.410  29.074  1.00 46.41           C  
ATOM   4503  CG  GLU E  98      79.906  26.815  28.318  1.00 51.46           C  
ATOM   4504  CD  GLU E  98      79.372  25.551  28.973  1.00 56.42           C  
ATOM   4505  OE1 GLU E  98      80.018  24.488  28.817  1.00 57.68           O  
ATOM   4506  OE2 GLU E  98      78.317  25.620  29.652  1.00 57.75           O  
ATOM   4507  N   SER E  99      80.293  30.313  28.337  1.00 38.96           N  
ATOM   4508  CA  SER E  99      79.373  31.319  27.803  1.00 38.45           C  
ATOM   4509  C   SER E  99      80.009  32.222  26.746  1.00 38.75           C  
ATOM   4510  O   SER E  99      79.387  32.535  25.736  1.00 38.66           O  
ATOM   4511  CB  SER E  99      78.849  32.199  28.931  1.00 38.70           C  
ATOM   4512  OG  SER E  99      77.962  33.174  28.421  1.00 40.54           O  
ATOM   4513  N   LYS E 100      81.240  32.658  27.000  1.00 38.50           N  
ATOM   4514  CA  LYS E 100      81.974  33.518  26.077  1.00 38.14           C  
ATOM   4515  C   LYS E 100      81.098  34.625  25.477  1.00 36.86           C  
ATOM   4516  O   LYS E 100      80.884  34.677  24.268  1.00 36.33           O  
ATOM   4517  CB  LYS E 100      82.584  32.670  24.951  1.00 39.73           C  
ATOM   4518  CG  LYS E 100      82.824  31.211  25.339  1.00 42.64           C  
ATOM   4519  CD  LYS E 100      84.137  30.633  24.793  1.00 45.10           C  
ATOM   4520  CE  LYS E 100      84.224  30.640  23.277  1.00 47.21           C  
ATOM   4521  NZ  LYS E 100      84.338  32.019  22.697  1.00 50.23           N  
ATOM   4522  N   PRO E 101      80.578  35.525  26.322  1.00 36.08           N  
ATOM   4523  CA  PRO E 101      79.730  36.619  25.839  1.00 34.12           C  
ATOM   4524  C   PRO E 101      80.520  37.742  25.166  1.00 34.31           C  
ATOM   4525  O   PRO E 101      81.754  37.699  25.085  1.00 34.81           O  
ATOM   4526  CB  PRO E 101      79.030  37.092  27.110  1.00 35.04           C  
ATOM   4527  CG  PRO E 101      80.082  36.875  28.168  1.00 35.06           C  
ATOM   4528  CD  PRO E 101      80.649  35.517  27.799  1.00 36.27           C  
ATOM   4529  N   ALA E 102      79.797  38.741  24.670  1.00 32.98           N  
ATOM   4530  CA  ALA E 102      80.418  39.890  24.028  1.00 31.35           C  
ATOM   4531  C   ALA E 102      80.830  40.810  25.166  1.00 31.91           C  
ATOM   4532  O   ALA E 102      80.053  41.073  26.083  1.00 31.79           O  
ATOM   4533  CB  ALA E 102      79.423  40.580  23.119  1.00 31.58           C  
ATOM   4534  N   ARG E 103      82.049  41.317  25.113  1.00 32.07           N  
ATOM   4535  CA  ARG E 103      82.520  42.151  26.196  1.00 30.71           C  
ATOM   4536  C   ARG E 103      83.007  43.508  25.747  1.00 28.76           C  
ATOM   4537  O   ARG E 103      83.449  43.683  24.617  1.00 29.87           O  
ATOM   4538  CB  ARG E 103      83.643  41.412  26.939  1.00 33.42           C  
ATOM   4539  CG  ARG E 103      84.043  42.029  28.265  1.00 35.06           C  
ATOM   4540  CD  ARG E 103      85.109  41.209  28.980  1.00 36.87           C  
ATOM   4541  NE  ARG E 103      86.452  41.434  28.453  1.00 38.71           N  
ATOM   4542  CZ  ARG E 103      87.559  40.955  29.011  1.00 41.00           C  
ATOM   4543  NH1 ARG E 103      87.485  40.226  30.123  1.00 42.25           N  
ATOM   4544  NH2 ARG E 103      88.739  41.185  28.452  1.00 41.25           N  
ATOM   4545  N   VAL E 104      82.907  44.467  26.654  1.00 27.66           N  
ATOM   4546  CA  VAL E 104      83.358  45.827  26.431  1.00 27.77           C  
ATOM   4547  C   VAL E 104      84.101  46.141  27.706  1.00 30.02           C  
ATOM   4548  O   VAL E 104      83.602  45.856  28.797  1.00 31.28           O  
ATOM   4549  CB  VAL E 104      82.199  46.819  26.317  1.00 27.20           C  
ATOM   4550  CG1 VAL E 104      82.741  48.226  26.236  1.00 23.43           C  
ATOM   4551  CG2 VAL E 104      81.353  46.497  25.095  1.00 27.02           C  
ATOM   4552  N   ALA E 105      85.286  46.718  27.580  1.00 31.16           N  
ATOM   4553  CA  ALA E 105      86.083  47.048  28.751  1.00 32.54           C  
ATOM   4554  C   ALA E 105      86.749  48.399  28.608  1.00 33.39           C  
ATOM   4555  O   ALA E 105      87.374  48.702  27.590  1.00 33.34           O  
ATOM   4556  CB  ALA E 105      87.135  45.977  28.987  1.00 31.63           C  
ATOM   4557  N   VAL E 106      86.610  49.216  29.637  1.00 34.65           N  
ATOM   4558  CA  VAL E 106      87.210  50.528  29.617  1.00 35.59           C  
ATOM   4559  C   VAL E 106      87.797  50.831  30.979  1.00 37.50           C  
ATOM   4560  O   VAL E 106      87.515  50.153  31.962  1.00 33.85           O  
ATOM   4561  CB  VAL E 106      86.175  51.617  29.263  1.00 35.45           C  
ATOM   4562  CG1 VAL E 106      85.331  51.168  28.078  1.00 34.56           C  
ATOM   4563  CG2 VAL E 106      85.309  51.928  30.468  1.00 33.06           C  
ATOM   4564  N   GLU E 107      88.626  51.863  31.020  1.00 42.58           N  
ATOM   4565  CA  GLU E 107      89.260  52.286  32.248  1.00 46.62           C  
ATOM   4566  C   GLU E 107      88.722  53.666  32.547  1.00 47.40           C  
ATOM   4567  O   GLU E 107      88.534  54.477  31.642  1.00 47.37           O  
ATOM   4568  CB  GLU E 107      90.782  52.312  32.066  1.00 50.52           C  
ATOM   4569  CG  GLU E 107      91.535  51.438  33.069  1.00 56.21           C  
ATOM   4570  CD  GLU E 107      92.731  50.707  32.464  1.00 58.55           C  
ATOM   4571  OE1 GLU E 107      92.527  49.931  31.497  1.00 59.17           O  
ATOM   4572  OE2 GLU E 107      93.866  50.902  32.959  1.00 57.89           O  
ATOM   4573  N   VAL E 108      88.450  53.924  33.817  1.00 50.01           N  
ATOM   4574  CA  VAL E 108      87.923  55.218  34.223  1.00 51.64           C  
ATOM   4575  C   VAL E 108      88.678  55.791  35.413  1.00 51.72           C  
ATOM   4576  O   VAL E 108      89.572  55.155  35.974  1.00 52.43           O  
ATOM   4577  CB  VAL E 108      86.414  55.128  34.571  1.00 51.52           C  
ATOM   4578  CG1 VAL E 108      85.606  54.919  33.302  1.00 51.15           C  
ATOM   4579  CG2 VAL E 108      86.171  53.980  35.541  1.00 51.35           C  
ATOM   4580  N   SER E 109      88.302  57.005  35.788  1.00 52.23           N  
ATOM   4581  CA  SER E 109      88.927  57.706  36.895  1.00 53.25           C  
ATOM   4582  C   SER E 109      88.624  57.052  38.242  1.00 53.24           C  
ATOM   4583  O   SER E 109      89.539  56.637  38.959  1.00 53.70           O  
ATOM   4584  CB  SER E 109      88.455  59.158  36.883  1.00 53.39           C  
ATOM   4585  OG  SER E 109      87.325  59.288  36.035  1.00 52.02           O  
ATOM   4586  N   ARG E 110      87.341  56.958  38.575  1.00 52.09           N  
ATOM   4587  CA  ARG E 110      86.920  56.358  39.829  1.00 51.37           C  
ATOM   4588  C   ARG E 110      85.600  55.596  39.682  1.00 51.80           C  
ATOM   4589  O   ARG E 110      84.813  55.853  38.776  1.00 50.24           O  
ATOM   4590  CB  ARG E 110      86.788  57.440  40.899  1.00 49.56           C  
ATOM   4591  N   LEU E 111      85.374  54.653  40.589  1.00 54.20           N  
ATOM   4592  CA  LEU E 111      84.158  53.845  40.605  1.00 56.16           C  
ATOM   4593  C   LEU E 111      83.474  54.081  41.950  1.00 58.03           C  
ATOM   4594  O   LEU E 111      84.093  54.606  42.878  1.00 58.89           O  
ATOM   4595  CB  LEU E 111      84.511  52.365  40.445  1.00 55.35           C  
ATOM   4596  CG  LEU E 111      85.077  51.951  39.084  1.00 55.08           C  
ATOM   4597  CD1 LEU E 111      85.799  50.623  39.201  1.00 54.62           C  
ATOM   4598  CD2 LEU E 111      83.946  51.872  38.070  1.00 54.50           C  
ATOM   4599  N   PRO E 112      82.189  53.705  42.075  1.00 59.00           N  
ATOM   4600  CA  PRO E 112      81.474  53.905  43.343  1.00 59.67           C  
ATOM   4601  C   PRO E 112      82.270  53.371  44.535  1.00 59.74           C  
ATOM   4602  O   PRO E 112      82.956  52.355  44.425  1.00 58.98           O  
ATOM   4603  CB  PRO E 112      80.168  53.144  43.122  1.00 59.78           C  
ATOM   4604  CG  PRO E 112      79.932  53.326  41.649  1.00 59.63           C  
ATOM   4605  CD  PRO E 112      81.312  53.078  41.070  1.00 59.30           C  
ATOM   4606  N   LYS E 113      82.178  54.066  45.666  1.00 60.13           N  
ATOM   4607  CA  LYS E 113      82.893  53.682  46.881  1.00 61.51           C  
ATOM   4608  C   LYS E 113      84.392  53.478  46.634  1.00 61.12           C  
ATOM   4609  O   LYS E 113      85.066  52.758  47.378  1.00 61.09           O  
ATOM   4610  CB  LYS E 113      82.285  52.406  47.479  1.00 62.97           C  
ATOM   4611  CG  LYS E 113      80.803  52.520  47.798  1.00 64.38           C  
ATOM   4612  CD  LYS E 113      80.324  51.343  48.635  1.00 66.29           C  
ATOM   4613  CE  LYS E 113      78.802  51.265  48.671  1.00 66.71           C  
ATOM   4614  NZ  LYS E 113      78.180  52.557  49.088  1.00 68.08           N  
ATOM   4615  N   ASP E 114      84.902  54.123  45.589  1.00 60.29           N  
ATOM   4616  CA  ASP E 114      86.314  54.041  45.219  1.00 59.68           C  
ATOM   4617  C   ASP E 114      86.777  52.592  45.132  1.00 56.65           C  
ATOM   4618  O   ASP E 114      87.815  52.212  45.671  1.00 57.20           O  
ATOM   4619  CB  ASP E 114      87.174  54.815  46.227  1.00 62.86           C  
ATOM   4620  CG  ASP E 114      88.482  55.309  45.622  1.00 66.30           C  
ATOM   4621  OD1 ASP E 114      89.372  54.471  45.333  1.00 67.74           O  
ATOM   4622  OD2 ASP E 114      88.613  56.541  45.432  1.00 67.36           O  
ATOM   4623  N   VAL E 115      85.984  51.791  44.438  1.00 53.23           N  
ATOM   4624  CA  VAL E 115      86.263  50.381  44.244  1.00 49.70           C  
ATOM   4625  C   VAL E 115      87.202  50.220  43.049  1.00 48.00           C  
ATOM   4626  O   VAL E 115      87.415  51.169  42.294  1.00 48.76           O  
ATOM   4627  CB  VAL E 115      84.946  49.628  43.981  1.00 49.44           C  
ATOM   4628  CG1 VAL E 115      85.228  48.309  43.317  1.00 51.69           C  
ATOM   4629  CG2 VAL E 115      84.195  49.421  45.290  1.00 47.10           C  
ATOM   4630  N   LEU E 116      87.764  49.028  42.880  1.00 44.12           N  
ATOM   4631  CA  LEU E 116      88.666  48.761  41.764  1.00 41.88           C  
ATOM   4632  C   LEU E 116      87.967  48.391  40.447  1.00 41.06           C  
ATOM   4633  O   LEU E 116      88.409  48.789  39.369  1.00 40.40           O  
ATOM   4634  CB  LEU E 116      89.641  47.642  42.139  1.00 42.01           C  
ATOM   4635  CG  LEU E 116      91.108  48.025  42.375  1.00 42.00           C  
ATOM   4636  CD1 LEU E 116      91.207  49.140  43.402  1.00 42.59           C  
ATOM   4637  CD2 LEU E 116      91.878  46.805  42.842  1.00 41.90           C  
ATOM   4638  N   ILE E 117      86.876  47.635  40.532  1.00 40.37           N  
ATOM   4639  CA  ILE E 117      86.162  47.192  39.341  1.00 37.81           C  
ATOM   4640  C   ILE E 117      84.657  47.152  39.528  1.00 36.87           C  
ATOM   4641  O   ILE E 117      84.164  46.913  40.631  1.00 37.24           O  
ATOM   4642  CB  ILE E 117      86.626  45.777  38.930  1.00 37.41           C  
ATOM   4643  CG1 ILE E 117      85.736  45.224  37.813  1.00 37.29           C  
ATOM   4644  CG2 ILE E 117      86.588  44.852  40.143  1.00 36.57           C  
ATOM   4645  CD1 ILE E 117      86.196  43.877  37.255  1.00 35.43           C  
ATOM   4646  N   GLU E 118      83.942  47.388  38.432  1.00 34.85           N  
ATOM   4647  CA  GLU E 118      82.483  47.361  38.404  1.00 33.78           C  
ATOM   4648  C   GLU E 118      82.099  46.660  37.107  1.00 32.31           C  
ATOM   4649  O   GLU E 118      82.761  46.829  36.089  1.00 33.07           O  
ATOM   4650  CB  GLU E 118      81.906  48.778  38.418  1.00 35.09           C  
ATOM   4651  CG  GLU E 118      80.387  48.820  38.477  1.00 38.25           C  
ATOM   4652  CD  GLU E 118      79.834  50.237  38.434  1.00 41.51           C  
ATOM   4653  OE1 GLU E 118      78.591  50.407  38.362  1.00 41.24           O  
ATOM   4654  OE2 GLU E 118      80.649  51.182  38.473  1.00 43.17           O  
ATOM   4655  N   ILE E 119      81.038  45.866  37.140  1.00 30.98           N  
ATOM   4656  CA  ILE E 119      80.614  45.142  35.956  1.00 29.07           C  
ATOM   4657  C   ILE E 119      79.107  45.095  35.778  1.00 30.12           C  
ATOM   4658  O   ILE E 119      78.368  44.827  36.735  1.00 30.99           O  
ATOM   4659  CB  ILE E 119      81.106  43.683  36.008  1.00 30.68           C  
ATOM   4660  CG1 ILE E 119      82.637  43.637  35.963  1.00 29.08           C  
ATOM   4661  CG2 ILE E 119      80.500  42.885  34.870  1.00 30.10           C  
ATOM   4662  CD1 ILE E 119      83.190  42.246  36.068  1.00 27.96           C  
ATOM   4663  N   GLU E 120      78.653  45.358  34.552  1.00 26.84           N  
ATOM   4664  CA  GLU E 120      77.233  45.270  34.226  1.00 26.82           C  
ATOM   4665  C   GLU E 120      77.096  44.160  33.191  1.00 25.49           C  
ATOM   4666  O   GLU E 120      78.065  43.830  32.504  1.00 26.32           O  
ATOM   4667  CB  GLU E 120      76.672  46.595  33.677  1.00 28.97           C  
ATOM   4668  CG  GLU E 120      77.487  47.301  32.604  1.00 34.36           C  
ATOM   4669  CD  GLU E 120      76.631  48.227  31.754  1.00 38.59           C  
ATOM   4670  OE1 GLU E 120      77.137  49.268  31.273  1.00 38.05           O  
ATOM   4671  OE2 GLU E 120      75.436  47.897  31.561  1.00 43.52           O  
ATOM   4672  N   ALA E 121      75.914  43.563  33.088  1.00 22.35           N  
ATOM   4673  CA  ALA E 121      75.720  42.483  32.130  1.00 21.68           C  
ATOM   4674  C   ALA E 121      74.274  42.305  31.684  1.00 22.59           C  
ATOM   4675  O   ALA E 121      73.328  42.622  32.410  1.00 22.02           O  
ATOM   4676  CB  ALA E 121      76.238  41.158  32.719  1.00 17.74           C  
ATOM   4677  N   ILE E 122      74.112  41.793  30.472  1.00 22.78           N  
ATOM   4678  CA  ILE E 122      72.790  41.523  29.946  1.00 22.94           C  
ATOM   4679  C   ILE E 122      72.756  40.027  29.651  1.00 22.24           C  
ATOM   4680  O   ILE E 122      73.733  39.450  29.189  1.00 23.43           O  
ATOM   4681  CB  ILE E 122      72.524  42.326  28.653  1.00 25.54           C  
ATOM   4682  CG1 ILE E 122      72.756  43.814  28.918  1.00 22.48           C  
ATOM   4683  CG2 ILE E 122      71.092  42.091  28.161  1.00 20.87           C  
ATOM   4684  CD1 ILE E 122      73.006  44.600  27.659  1.00 27.06           C  
ATOM   4685  N   ALA E 123      71.636  39.397  29.953  1.00 22.32           N  
ATOM   4686  CA  ALA E 123      71.487  37.979  29.711  1.00 22.71           C  
ATOM   4687  C   ALA E 123      70.249  37.765  28.850  1.00 23.71           C  
ATOM   4688  O   ALA E 123      69.333  38.607  28.822  1.00 19.92           O  
ATOM   4689  CB  ALA E 123      71.349  37.223  31.042  1.00 21.04           C  
ATOM   4690  N   TYR E 124      70.235  36.629  28.161  1.00 25.95           N  
ATOM   4691  CA  TYR E 124      69.130  36.261  27.296  1.00 29.34           C  
ATOM   4692  C   TYR E 124      68.747  34.795  27.475  1.00 31.68           C  
ATOM   4693  O   TYR E 124      69.595  33.901  27.429  1.00 32.60           O  
ATOM   4694  CB  TYR E 124      69.507  36.515  25.835  1.00 30.84           C  
ATOM   4695  CG  TYR E 124      68.446  36.103  24.841  1.00 34.02           C  
ATOM   4696  CD1 TYR E 124      67.277  36.854  24.682  1.00 35.29           C  
ATOM   4697  CD2 TYR E 124      68.594  34.942  24.089  1.00 35.57           C  
ATOM   4698  CE1 TYR E 124      66.281  36.455  23.802  1.00 37.76           C  
ATOM   4699  CE2 TYR E 124      67.608  34.528  23.207  1.00 39.61           C  
ATOM   4700  CZ  TYR E 124      66.452  35.285  23.061  1.00 41.71           C  
ATOM   4701  OH  TYR E 124      65.478  34.866  22.170  1.00 44.50           O  
ATOM   4702  N   LYS E 125      67.460  34.557  27.683  1.00 33.53           N  
ATOM   4703  CA  LYS E 125      66.935  33.209  27.830  1.00 36.01           C  
ATOM   4704  C   LYS E 125      65.717  33.120  26.913  1.00 38.71           C  
ATOM   4705  O   LYS E 125      64.637  33.581  27.343  1.00 38.68           O  
ATOM   4706  CB  LYS E 125      66.513  32.941  29.272  1.00 37.33           C  
ATOM   4707  CG  LYS E 125      65.982  31.552  29.492  1.00 38.77           C  
ATOM   4708  CD  LYS E 125      65.044  31.501  30.683  1.00 43.55           C  
ATOM   4709  CE  LYS E 125      65.751  31.827  31.984  1.00 45.86           C  
ATOM   4710  NZ  LYS E 125      64.836  31.590  33.138  1.00 47.20           N  
TER    4711      LYS E 125                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
