
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  118 (  905),  selected  118 , name 2dyy_F
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2dyy_F.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_F      M       1           -
LGA    E     3_F      S       2           -
LGA    V     4_F      D       3           -
LGA    I     5_F      V       4           -
LGA    F     6_F      I       5           -
LGA    T     7_F      E       6           -
LGA    E     8_F      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    N     9_F      P      17          3.468
LGA    A    10_F      V      18          4.534
LGA    P    11_F      -       -           -
LGA    K    12_F      -       -           -
LGA    P    13_F      -       -           -
LGA    I    14_F      A      23          4.991
LGA    G    15_F      A      24          2.575
LGA    P    16_F      N      25          1.574
LGA    Y    17_F      Y      26          1.894
LGA    S    18_F      V      27          0.933
LGA    Q    19_F      P      28          0.916
LGA    A    20_F      F      29          0.558
LGA    I    21_F      T      30          0.933
LGA    K    22_F      I      31          1.513
LGA    A    23_F      S      32          1.631
LGA    G    24_F      G      33          1.528
LGA    N    25_F      N      34          0.786
LGA    F    26_F      L      35          0.841
LGA    L    27_F      L      36          0.397
LGA    F    28_F      Y      37          0.438
LGA    I    29_F      V      38          0.233
LGA    A    30_F      S      39          0.365
LGA    G    31_F      G      40          0.413
LGA    Q    32_F      Q      41          0.253
LGA    I    33_F      L      42          0.511
LGA    P    34_F      P      43          0.940
LGA    I    35_F      M      44          1.678
LGA    D    36_F      E      45          2.437
LGA    P    37_F      S      46          5.269
LGA    K    38_F      -       -           -
LGA    T    39_F      -       -           -
LGA    G    40_F      G      47          2.238
LGA    E    41_F      K      48          1.297
LGA    I    42_F      I      49          1.000
LGA    V    43_F      A      50          1.337
LGA    K    44_F      V      51          3.775
LGA    G    45_F      T      52           #
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    46_F      S      63          2.275
LGA    I    47_F      A      64          0.710
LGA    K    48_F      Q      65          2.386
LGA    D    49_F      R      66          2.208
LGA    Q    50_F      A      67          1.285
LGA    T    51_F      A      68          1.282
LGA    R    52_F      E      69          1.680
LGA    Q    53_F      L      70          1.247
LGA    V    54_F      C      71          0.824
LGA    L    55_F      A      72          0.843
LGA    E    56_F      V      73          0.620
LGA    N    57_F      N      74          0.683
LGA    I    58_F      I      75          0.759
LGA    K    59_F      L      76          0.925
LGA    A    60_F      A      77          1.011
LGA    I    61_F      Q      78          1.202
LGA    L    62_F      V      79          1.215
LGA    E    63_F      K      80          1.358
LGA    A    64_F      A      81          1.548
LGA    A    65_F      A      82          1.871
LGA    G    66_F      L      83          2.026
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    Y    67_F      K      89          3.821
LGA    S    68_F      I      90          3.435
LGA    L    69_F      -       -           -
LGA    N    70_F      R      91           #
LGA    D    71_F      R      92          2.386
LGA    V    72_F      V      93          1.105
LGA    I    73_F      I      94          0.553
LGA    K    74_F      K      95          0.913
LGA    V    75_F      L      96          0.946
LGA    T    76_F      N      97          0.605
LGA    V    77_F      G      98          0.476
LGA    Y    78_F      F      99          0.388
LGA    L    79_F      V     100          0.492
LGA    K    80_F      A     101          0.848
LGA    -       -      S     102           -
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    -       -      F     106           -
LGA    -       -      V     107           -
LGA    -       -      E     108           -
LGA    -       -      Q     109           -
LGA    -       -      H     110           -
LGA    -       -      L     111           -
LGA    M    88_F      V     112          2.680
LGA    N    89_F      I     113          3.889
LGA    E    90_F      N     114          3.903
LGA    V    91_F      G     115          2.274
LGA    Y    92_F      A     116          2.648
LGA    A    93_F      S     117          3.911
LGA    -       -      N     118           -
LGA    E    94_F      L     119          2.613
LGA    Y    95_F      I     120          1.700
LGA    F    96_F      A     121          2.016
LGA    G    97_F      T     122          4.443
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    E    98_F      G     125          2.441
LGA    S    99_F      E     126          3.806
LGA    -       -      P     127           -
LGA    -       -      G     128           -
LGA    K   100_F      R     129          1.655
LGA    P   101_F      H     130          0.731
LGA    A   102_F      A     131          0.846
LGA    R   103_F      R     132          0.717
LGA    V   104_F      A     133          0.896
LGA    A   105_F      A     134          1.104
LGA    V   106_F      V     135          1.009
LGA    E   107_F      G     136          0.657
LGA    V   108_F      M     137          1.044
LGA    S   109_F      A     138          0.569
LGA    R   110_F      S     139          0.625
LGA    L   111_F      L     140          0.572
LGA    P   112_F      P     141          0.541
LGA    K   113_F      F     142          0.810
LGA    D   114_F      N     143          1.097
LGA    V   115_F      A     144          1.141
LGA    L   116_F      S     145          0.761
LGA    I   117_F      V     146          0.426
LGA    E   118_F      E     147          0.402
LGA    I   119_F      I     148          0.366
LGA    E   120_F      D     149          0.515
LGA    A   121_F      A     150          0.222
LGA    I   122_F      I     151          0.299
LGA    A   123_F      V     152          0.848
LGA    Y   124_F      E     153          0.936
LGA    K   125_F      I     154          2.011
LGA    E   126_F      D     155          4.083
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  118  152    5.0    103    1.92    26.21     61.005     5.093

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.444398 * X  +  -0.895563 * Y  +  -0.021845 * Z  + 103.188354
  Y_new =   0.747332 * X  +  -0.357175 * Y  +  -0.560287 * Z  +  43.349907
  Z_new =   0.493970 * X  +  -0.265316 * Y  +   0.828011 * Z  + -52.911613 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.310089    2.831504  [ DEG:   -17.7668    162.2332 ]
  Theta =  -0.516649   -2.624943  [ DEG:   -29.6018   -150.3982 ]
  Phi   =   2.107270   -1.034323  [ DEG:   120.7376    -59.2623 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dyy_F                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dyy_F.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  118  152   5.0  103   1.92   26.21  61.005
REMARK  ---------------------------------------------------------- 
MOLECULE 2dyy_F
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-SEP-06   2DYY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION INITIATION                  
TITLE    2 INHIBITOR PH0854 FROM PYROCOCCUS HORIKOSHII                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0076 PROTEIN PH0854;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PUTATIVE TRANSLATION INITIATION INHIBITOR;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    PUTATIVE TRANSLATION INITIATION INHIBITOR, PYROCOCCUS                 
KEYWDS   2 HORIKOSHII, TRIMER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL            
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,B.C.WANG,           
AUTHOR   2 M.SHIROUZU,Y.BESSHO,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-SEP-07 2DYY    1       AUTHOR                                   
REVDAT   1   19-MAR-07 2DYY    0                                                
JRNL        AUTH   IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,           
JRNL        AUTH 2 B.C.WANG,M.SHIROUZU,Y.BESSHO,S.YOKOYAMA                      
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION                    
JRNL        TITL 2 INITIATION INHIBITOR PH0854 FROM PYROCOCCUS                  
JRNL        TITL 3 HORIKOSHII                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2DYY A    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY B    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY C    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY D    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY E    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY F    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY G    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY H    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY I    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY J    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY K    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY L    1   126  UNP    O58584   Y854_PYRHO       1    126             
SEQRES   1 A  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 A  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 A  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 A  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 A  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 A  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 A  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 A  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 A  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 A  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 B  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 B  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 B  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 B  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 B  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 B  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 B  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 B  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 B  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 B  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 C  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 C  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 C  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 C  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 C  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 C  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 C  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 C  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 C  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 C  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 D  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 D  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 D  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 D  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 D  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 D  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 D  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 D  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 D  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 D  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 E  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 E  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 E  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 E  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 E  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 E  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 E  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 E  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 E  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 E  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 F  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 F  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 F  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 F  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 F  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 F  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 F  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 F  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 F  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 F  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 G  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 G  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 G  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 G  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 G  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 G  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 G  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 G  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 G  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 G  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 H  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 H  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 H  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 H  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 H  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 H  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 H  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 H  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 H  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 H  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 I  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 I  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 I  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 I  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 I  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 I  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 I  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 I  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 I  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 I  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 J  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 J  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 J  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 J  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 J  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 J  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 J  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 J  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 J  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 J  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 K  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 K  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 K  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 K  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 K  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 K  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 K  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 K  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 K  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 K  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 L  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 L  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 L  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 L  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 L  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 L  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 L  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 L  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 L  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 L  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
FORMUL  13  HOH   *233(H2 O)                                                    
CRYST1   92.490   43.090  170.210  90.00  91.51  90.00 P 1 2 1      24          
ATOM   4712  N   LYS F   2      57.853  44.176  32.477  1.00 49.06           N  
ATOM   4713  CA  LYS F   2      59.030  44.602  33.290  1.00 48.38           C  
ATOM   4714  C   LYS F   2      58.948  43.974  34.670  1.00 49.37           C  
ATOM   4715  O   LYS F   2      57.986  44.194  35.398  1.00 51.82           O  
ATOM   4716  CB  LYS F   2      59.056  46.127  33.435  1.00 47.46           C  
ATOM   4717  CG  LYS F   2      60.271  46.662  34.180  1.00 45.96           C  
ATOM   4718  CD  LYS F   2      60.158  48.155  34.452  1.00 43.38           C  
ATOM   4719  CE  LYS F   2      61.380  48.662  35.207  1.00 43.27           C  
ATOM   4720  NZ  LYS F   2      61.217  50.051  35.705  1.00 42.47           N  
ATOM   4721  N   GLU F   3      59.956  43.193  35.034  1.00 49.29           N  
ATOM   4722  CA  GLU F   3      59.959  42.552  36.338  1.00 49.25           C  
ATOM   4723  C   GLU F   3      61.274  42.839  37.073  1.00 47.11           C  
ATOM   4724  O   GLU F   3      62.359  42.723  36.506  1.00 45.23           O  
ATOM   4725  CB  GLU F   3      59.760  41.036  36.181  1.00 53.51           C  
ATOM   4726  CG  GLU F   3      58.699  40.603  35.136  1.00 60.59           C  
ATOM   4727  CD  GLU F   3      57.245  40.881  35.548  1.00 63.98           C  
ATOM   4728  OE1 GLU F   3      56.326  40.480  34.793  1.00 64.95           O  
ATOM   4729  OE2 GLU F   3      57.018  41.494  36.617  1.00 66.47           O  
ATOM   4730  N   VAL F   4      61.168  43.221  38.338  1.00 44.93           N  
ATOM   4731  CA  VAL F   4      62.346  43.510  39.141  1.00 43.79           C  
ATOM   4732  C   VAL F   4      62.803  42.251  39.890  1.00 42.76           C  
ATOM   4733  O   VAL F   4      61.994  41.515  40.462  1.00 41.84           O  
ATOM   4734  CB  VAL F   4      62.053  44.645  40.156  1.00 43.57           C  
ATOM   4735  CG1 VAL F   4      60.918  44.246  41.063  1.00 44.10           C  
ATOM   4736  CG2 VAL F   4      63.286  44.954  40.974  1.00 43.35           C  
ATOM   4737  N   ILE F   5      64.103  41.987  39.863  1.00 41.49           N  
ATOM   4738  CA  ILE F   5      64.639  40.830  40.563  1.00 39.78           C  
ATOM   4739  C   ILE F   5      65.344  41.336  41.803  1.00 39.90           C  
ATOM   4740  O   ILE F   5      65.942  42.412  41.796  1.00 40.19           O  
ATOM   4741  CB  ILE F   5      65.690  40.048  39.735  1.00 39.70           C  
ATOM   4742  CG1 ILE F   5      65.064  39.495  38.460  1.00 38.52           C  
ATOM   4743  CG2 ILE F   5      66.269  38.906  40.571  1.00 38.91           C  
ATOM   4744  CD1 ILE F   5      64.776  40.538  37.434  1.00 43.28           C  
ATOM   4745  N   PHE F   6      65.269  40.548  42.865  1.00 38.27           N  
ATOM   4746  CA  PHE F   6      65.924  40.882  44.105  1.00 37.04           C  
ATOM   4747  C   PHE F   6      66.333  39.587  44.778  1.00 35.85           C  
ATOM   4748  O   PHE F   6      65.666  38.575  44.626  1.00 37.40           O  
ATOM   4749  CB  PHE F   6      64.989  41.669  45.022  1.00 36.56           C  
ATOM   4750  CG  PHE F   6      65.580  41.957  46.372  1.00 35.98           C  
ATOM   4751  CD1 PHE F   6      66.711  42.757  46.492  1.00 33.35           C  
ATOM   4752  CD2 PHE F   6      65.031  41.390  47.520  1.00 36.58           C  
ATOM   4753  CE1 PHE F   6      67.289  42.992  47.731  1.00 34.48           C  
ATOM   4754  CE2 PHE F   6      65.602  41.617  48.764  1.00 35.62           C  
ATOM   4755  CZ  PHE F   6      66.734  42.419  48.871  1.00 35.52           C  
ATOM   4756  N   THR F   7      67.435  39.621  45.513  1.00 35.31           N  
ATOM   4757  CA  THR F   7      67.925  38.453  46.229  1.00 34.52           C  
ATOM   4758  C   THR F   7      68.882  38.922  47.324  1.00 34.71           C  
ATOM   4759  O   THR F   7      69.672  39.843  47.104  1.00 31.97           O  
ATOM   4760  CB  THR F   7      68.684  37.486  45.283  1.00 36.09           C  
ATOM   4761  OG1 THR F   7      69.071  36.309  46.005  1.00 36.06           O  
ATOM   4762  CG2 THR F   7      69.942  38.152  44.718  1.00 35.79           C  
ATOM   4763  N   GLU F   8      68.819  38.301  48.501  1.00 35.01           N  
ATOM   4764  CA  GLU F   8      69.725  38.702  49.566  1.00 35.53           C  
ATOM   4765  C   GLU F   8      71.111  38.175  49.249  1.00 35.62           C  
ATOM   4766  O   GLU F   8      72.103  38.598  49.839  1.00 34.96           O  
ATOM   4767  CB  GLU F   8      69.250  38.192  50.934  1.00 36.31           C  
ATOM   4768  CG  GLU F   8      68.961  36.705  51.052  1.00 35.78           C  
ATOM   4769  CD  GLU F   8      68.833  36.257  52.515  1.00 36.00           C  
ATOM   4770  OE1 GLU F   8      68.340  35.133  52.759  1.00 34.84           O  
ATOM   4771  OE2 GLU F   8      69.241  37.023  53.423  1.00 33.06           O  
ATOM   4772  N   ASN F   9      71.166  37.259  48.287  1.00 36.94           N  
ATOM   4773  CA  ASN F   9      72.414  36.662  47.844  1.00 37.29           C  
ATOM   4774  C   ASN F   9      73.351  37.684  47.214  1.00 38.22           C  
ATOM   4775  O   ASN F   9      74.495  37.365  46.902  1.00 37.82           O  
ATOM   4776  CB  ASN F   9      72.133  35.564  46.824  1.00 41.83           C  
ATOM   4777  CG  ASN F   9      71.868  34.220  47.466  1.00 46.03           C  
ATOM   4778  OD1 ASN F   9      72.713  33.694  48.189  1.00 50.21           O  
ATOM   4779  ND2 ASN F   9      70.693  33.649  47.198  1.00 48.03           N  
ATOM   4780  N   ALA F  10      72.873  38.908  47.010  1.00 39.13           N  
ATOM   4781  CA  ALA F  10      73.713  39.941  46.404  1.00 40.28           C  
ATOM   4782  C   ALA F  10      73.432  41.340  46.946  1.00 40.71           C  
ATOM   4783  O   ALA F  10      72.347  41.613  47.448  1.00 38.18           O  
ATOM   4784  CB  ALA F  10      73.538  39.928  44.893  1.00 38.58           C  
ATOM   4785  N   PRO F  11      74.417  42.249  46.838  1.00 41.97           N  
ATOM   4786  CA  PRO F  11      74.255  43.619  47.322  1.00 43.24           C  
ATOM   4787  C   PRO F  11      73.031  44.261  46.694  1.00 44.68           C  
ATOM   4788  O   PRO F  11      72.440  43.716  45.767  1.00 46.16           O  
ATOM   4789  CB  PRO F  11      75.539  44.300  46.871  1.00 41.47           C  
ATOM   4790  CG  PRO F  11      76.528  43.194  46.892  1.00 43.66           C  
ATOM   4791  CD  PRO F  11      75.752  42.068  46.249  1.00 42.20           C  
ATOM   4792  N   LYS F  12      72.661  45.427  47.201  1.00 46.76           N  
ATOM   4793  CA  LYS F  12      71.518  46.157  46.683  1.00 49.61           C  
ATOM   4794  C   LYS F  12      71.576  47.578  47.212  1.00 51.49           C  
ATOM   4795  O   LYS F  12      71.163  47.845  48.342  1.00 52.33           O  
ATOM   4796  CB  LYS F  12      70.211  45.472  47.102  1.00 50.85           C  
ATOM   4797  CG  LYS F  12      68.978  46.380  47.153  1.00 51.00           C  
ATOM   4798  CD  LYS F  12      68.683  47.061  45.831  1.00 50.30           C  
ATOM   4799  CE  LYS F  12      67.607  48.132  46.017  1.00 51.22           C  
ATOM   4800  NZ  LYS F  12      66.279  47.566  46.377  1.00 51.61           N  
ATOM   4801  N   PRO F  13      72.100  48.513  46.401  1.00 53.13           N  
ATOM   4802  CA  PRO F  13      72.198  49.912  46.829  1.00 53.42           C  
ATOM   4803  C   PRO F  13      70.835  50.483  47.217  1.00 53.49           C  
ATOM   4804  O   PRO F  13      69.923  50.573  46.392  1.00 53.40           O  
ATOM   4805  CB  PRO F  13      72.824  50.604  45.615  1.00 53.68           C  
ATOM   4806  CG  PRO F  13      72.351  49.761  44.455  1.00 53.70           C  
ATOM   4807  CD  PRO F  13      72.511  48.360  44.993  1.00 53.72           C  
ATOM   4808  N   ILE F  14      70.714  50.849  48.490  1.00 53.08           N  
ATOM   4809  CA  ILE F  14      69.487  51.404  49.045  1.00 52.72           C  
ATOM   4810  C   ILE F  14      68.928  52.578  48.239  1.00 53.66           C  
ATOM   4811  O   ILE F  14      69.677  53.451  47.790  1.00 53.00           O  
ATOM   4812  CB  ILE F  14      69.721  51.856  50.501  1.00 53.25           C  
ATOM   4813  CG1 ILE F  14      68.475  52.554  51.042  1.00 53.33           C  
ATOM   4814  CG2 ILE F  14      70.931  52.770  50.570  1.00 52.52           C  
ATOM   4815  CD1 ILE F  14      68.589  52.952  52.488  1.00 54.22           C  
ATOM   4816  N   GLY F  15      67.608  52.590  48.064  1.00 53.36           N  
ATOM   4817  CA  GLY F  15      66.971  53.660  47.318  1.00 54.22           C  
ATOM   4818  C   GLY F  15      66.214  53.191  46.088  1.00 54.31           C  
ATOM   4819  O   GLY F  15      65.635  52.103  46.102  1.00 56.74           O  
ATOM   4820  N   PRO F  16      66.186  53.994  45.008  1.00 52.71           N  
ATOM   4821  CA  PRO F  16      65.485  53.645  43.767  1.00 50.27           C  
ATOM   4822  C   PRO F  16      66.329  52.899  42.715  1.00 47.53           C  
ATOM   4823  O   PRO F  16      66.417  53.321  41.559  1.00 45.12           O  
ATOM   4824  CB  PRO F  16      65.000  54.997  43.270  1.00 50.98           C  
ATOM   4825  CG  PRO F  16      66.169  55.878  43.618  1.00 53.61           C  
ATOM   4826  CD  PRO F  16      66.538  55.429  45.023  1.00 52.54           C  
ATOM   4827  N   TYR F  17      66.935  51.788  43.130  1.00 45.45           N  
ATOM   4828  CA  TYR F  17      67.760  50.963  42.247  1.00 43.99           C  
ATOM   4829  C   TYR F  17      67.371  49.499  42.396  1.00 41.05           C  
ATOM   4830  O   TYR F  17      66.976  49.065  43.473  1.00 42.68           O  
ATOM   4831  CB  TYR F  17      69.243  51.098  42.600  1.00 44.73           C  
ATOM   4832  CG  TYR F  17      69.661  52.502  42.948  1.00 48.24           C  
ATOM   4833  CD1 TYR F  17      69.967  52.853  44.269  1.00 50.91           C  
ATOM   4834  CD2 TYR F  17      69.727  53.496  41.967  1.00 48.94           C  
ATOM   4835  CE1 TYR F  17      70.329  54.162  44.605  1.00 51.99           C  
ATOM   4836  CE2 TYR F  17      70.081  54.803  42.291  1.00 50.70           C  
ATOM   4837  CZ  TYR F  17      70.381  55.129  43.611  1.00 51.43           C  
ATOM   4838  OH  TYR F  17      70.726  56.419  43.935  1.00 52.36           O  
ATOM   4839  N   SER F  18      67.472  48.741  41.314  1.00 36.88           N  
ATOM   4840  CA  SER F  18      67.161  47.319  41.354  1.00 32.45           C  
ATOM   4841  C   SER F  18      68.460  46.610  41.040  1.00 30.67           C  
ATOM   4842  O   SER F  18      69.340  47.172  40.387  1.00 30.07           O  
ATOM   4843  CB  SER F  18      66.120  46.942  40.297  1.00 33.02           C  
ATOM   4844  OG  SER F  18      64.907  47.651  40.482  1.00 35.87           O  
ATOM   4845  N   GLN F  19      68.583  45.378  41.514  1.00 28.22           N  
ATOM   4846  CA  GLN F  19      69.772  44.584  41.273  1.00 24.21           C  
ATOM   4847  C   GLN F  19      69.787  44.184  39.816  1.00 22.09           C  
ATOM   4848  O   GLN F  19      70.848  44.003  39.204  1.00 19.72           O  
ATOM   4849  CB  GLN F  19      69.731  43.338  42.125  1.00 26.19           C  
ATOM   4850  CG  GLN F  19      69.641  43.623  43.587  1.00 28.56           C  
ATOM   4851  CD  GLN F  19      69.589  42.359  44.385  1.00 29.62           C  
ATOM   4852  OE1 GLN F  19      68.642  41.579  44.268  1.00 30.28           O  
ATOM   4853  NE2 GLN F  19      70.611  42.135  45.195  1.00 29.75           N  
ATOM   4854  N   ALA F  20      68.584  44.043  39.274  1.00 20.44           N  
ATOM   4855  CA  ALA F  20      68.395  43.652  37.889  1.00 20.99           C  
ATOM   4856  C   ALA F  20      66.929  43.790  37.483  1.00 21.36           C  
ATOM   4857  O   ALA F  20      66.025  43.793  38.324  1.00 23.34           O  
ATOM   4858  CB  ALA F  20      68.853  42.214  37.700  1.00 19.34           C  
ATOM   4859  N   ILE F  21      66.698  43.922  36.187  1.00 21.49           N  
ATOM   4860  CA  ILE F  21      65.345  44.021  35.672  1.00 21.10           C  
ATOM   4861  C   ILE F  21      65.189  42.976  34.569  1.00 21.70           C  
ATOM   4862  O   ILE F  21      66.112  42.722  33.801  1.00 22.10           O  
ATOM   4863  CB  ILE F  21      65.055  45.428  35.093  1.00 18.82           C  
ATOM   4864  CG1 ILE F  21      65.151  46.489  36.196  1.00 17.84           C  
ATOM   4865  CG2 ILE F  21      63.666  45.446  34.462  1.00 19.26           C  
ATOM   4866  CD1 ILE F  21      63.949  46.532  37.141  1.00 15.01           C  
ATOM   4867  N   LYS F  22      64.024  42.359  34.513  1.00 23.50           N  
ATOM   4868  CA  LYS F  22      63.737  41.356  33.511  1.00 28.04           C  
ATOM   4869  C   LYS F  22      62.800  42.018  32.504  1.00 31.35           C  
ATOM   4870  O   LYS F  22      61.703  42.462  32.852  1.00 31.91           O  
ATOM   4871  CB  LYS F  22      63.050  40.164  34.173  1.00 29.80           C  
ATOM   4872  CG  LYS F  22      63.259  38.822  33.508  1.00 31.71           C  
ATOM   4873  CD  LYS F  22      62.287  38.581  32.379  1.00 33.78           C  
ATOM   4874  CE  LYS F  22      61.849  37.117  32.370  1.00 35.09           C  
ATOM   4875  NZ  LYS F  22      63.009  36.169  32.403  1.00 35.65           N  
ATOM   4876  N   ALA F  23      63.245  42.106  31.258  1.00 32.50           N  
ATOM   4877  CA  ALA F  23      62.436  42.709  30.213  1.00 32.73           C  
ATOM   4878  C   ALA F  23      62.370  41.732  29.053  1.00 32.87           C  
ATOM   4879  O   ALA F  23      63.271  41.685  28.212  1.00 32.57           O  
ATOM   4880  CB  ALA F  23      63.056  44.022  29.765  1.00 35.27           C  
ATOM   4881  N   GLY F  24      61.295  40.955  29.010  1.00 33.24           N  
ATOM   4882  CA  GLY F  24      61.152  39.964  27.959  1.00 31.00           C  
ATOM   4883  C   GLY F  24      62.046  38.789  28.298  1.00 28.78           C  
ATOM   4884  O   GLY F  24      62.007  38.289  29.416  1.00 28.24           O  
ATOM   4885  N   ASN F  25      62.866  38.354  27.349  1.00 28.08           N  
ATOM   4886  CA  ASN F  25      63.760  37.234  27.599  1.00 28.79           C  
ATOM   4887  C   ASN F  25      65.122  37.739  28.059  1.00 27.60           C  
ATOM   4888  O   ASN F  25      65.998  36.956  28.410  1.00 27.47           O  
ATOM   4889  CB  ASN F  25      63.919  36.393  26.334  1.00 29.68           C  
ATOM   4890  CG  ASN F  25      62.596  35.852  25.822  1.00 32.77           C  
ATOM   4891  OD1 ASN F  25      62.429  35.632  24.619  1.00 37.04           O  
ATOM   4892  ND2 ASN F  25      61.648  35.630  26.727  1.00 31.08           N  
ATOM   4893  N   PHE F  26      65.280  39.057  28.066  1.00 27.27           N  
ATOM   4894  CA  PHE F  26      66.532  39.689  28.463  1.00 26.15           C  
ATOM   4895  C   PHE F  26      66.581  40.074  29.931  1.00 26.94           C  
ATOM   4896  O   PHE F  26      65.593  40.531  30.511  1.00 29.53           O  
ATOM   4897  CB  PHE F  26      66.767  40.940  27.620  1.00 24.82           C  
ATOM   4898  CG  PHE F  26      67.137  40.656  26.184  1.00 24.43           C  
ATOM   4899  CD1 PHE F  26      68.455  40.394  25.833  1.00 21.09           C  
ATOM   4900  CD2 PHE F  26      66.163  40.635  25.190  1.00 24.07           C  
ATOM   4901  CE1 PHE F  26      68.798  40.120  24.526  1.00 22.73           C  
ATOM   4902  CE2 PHE F  26      66.501  40.357  23.866  1.00 23.77           C  
ATOM   4903  CZ  PHE F  26      67.817  40.098  23.535  1.00 23.65           C  
ATOM   4904  N   LEU F  27      67.743  39.880  30.535  1.00 25.36           N  
ATOM   4905  CA  LEU F  27      67.927  40.248  31.922  1.00 21.72           C  
ATOM   4906  C   LEU F  27      69.040  41.278  31.976  1.00 21.80           C  
ATOM   4907  O   LEU F  27      70.174  41.004  31.603  1.00 20.49           O  
ATOM   4908  CB  LEU F  27      68.318  39.041  32.763  1.00 22.44           C  
ATOM   4909  CG  LEU F  27      68.667  39.416  34.207  1.00 22.85           C  
ATOM   4910  CD1 LEU F  27      67.394  39.759  34.970  1.00 20.88           C  
ATOM   4911  CD2 LEU F  27      69.402  38.256  34.864  1.00 23.15           C  
ATOM   4912  N   PHE F  28      68.699  42.475  32.423  1.00 22.83           N  
ATOM   4913  CA  PHE F  28      69.671  43.548  32.552  1.00 23.27           C  
ATOM   4914  C   PHE F  28      70.099  43.624  34.014  1.00 22.73           C  
ATOM   4915  O   PHE F  28      69.289  43.904  34.898  1.00 22.42           O  
ATOM   4916  CB  PHE F  28      69.049  44.868  32.093  1.00 21.74           C  
ATOM   4917  CG  PHE F  28      68.808  44.931  30.617  1.00 21.91           C  
ATOM   4918  CD1 PHE F  28      69.785  45.447  29.764  1.00 21.75           C  
ATOM   4919  CD2 PHE F  28      67.636  44.407  30.067  1.00 21.78           C  
ATOM   4920  CE1 PHE F  28      69.601  45.435  28.391  1.00 21.71           C  
ATOM   4921  CE2 PHE F  28      67.438  44.384  28.690  1.00 19.90           C  
ATOM   4922  CZ  PHE F  28      68.419  44.895  27.847  1.00 22.86           C  
ATOM   4923  N   ILE F  29      71.371  43.348  34.262  1.00 22.94           N  
ATOM   4924  CA  ILE F  29      71.905  43.381  35.617  1.00 26.02           C  
ATOM   4925  C   ILE F  29      72.609  44.688  35.908  1.00 27.31           C  
ATOM   4926  O   ILE F  29      73.474  45.116  35.154  1.00 28.38           O  
ATOM   4927  CB  ILE F  29      72.918  42.232  35.864  1.00 26.12           C  
ATOM   4928  CG1 ILE F  29      72.183  40.884  35.923  1.00 25.35           C  
ATOM   4929  CG2 ILE F  29      73.708  42.497  37.148  1.00 24.42           C  
ATOM   4930  CD1 ILE F  29      73.104  39.674  36.043  1.00 23.40           C  
ATOM   4931  N   ALA F  30      72.240  45.309  37.022  1.00 30.37           N  
ATOM   4932  CA  ALA F  30      72.841  46.567  37.444  1.00 31.45           C  
ATOM   4933  C   ALA F  30      74.344  46.377  37.580  1.00 32.11           C  
ATOM   4934  O   ALA F  30      74.829  45.249  37.594  1.00 34.35           O  
ATOM   4935  CB  ALA F  30      72.250  46.999  38.773  1.00 30.11           C  
ATOM   4936  N   GLY F  31      75.082  47.478  37.676  1.00 32.88           N  
ATOM   4937  CA  GLY F  31      76.524  47.379  37.825  1.00 32.74           C  
ATOM   4938  C   GLY F  31      76.858  46.801  39.185  1.00 33.58           C  
ATOM   4939  O   GLY F  31      76.363  47.275  40.201  1.00 33.04           O  
ATOM   4940  N   GLN F  32      77.689  45.769  39.216  1.00 34.26           N  
ATOM   4941  CA  GLN F  32      78.050  45.154  40.482  1.00 35.25           C  
ATOM   4942  C   GLN F  32      79.445  45.534  40.976  1.00 36.19           C  
ATOM   4943  O   GLN F  32      80.417  45.517  40.213  1.00 36.32           O  
ATOM   4944  CB  GLN F  32      77.938  43.637  40.358  1.00 36.05           C  
ATOM   4945  CG  GLN F  32      76.533  43.155  40.068  1.00 36.11           C  
ATOM   4946  CD  GLN F  32      75.564  43.576  41.145  1.00 38.24           C  
ATOM   4947  OE1 GLN F  32      75.757  43.261  42.325  1.00 34.45           O  
ATOM   4948  NE2 GLN F  32      74.512  44.298  40.750  1.00 39.30           N  
ATOM   4949  N   ILE F  33      79.528  45.881  42.258  1.00 36.13           N  
ATOM   4950  CA  ILE F  33      80.792  46.244  42.884  1.00 38.89           C  
ATOM   4951  C   ILE F  33      81.176  45.161  43.890  1.00 40.99           C  
ATOM   4952  O   ILE F  33      80.331  44.385  44.339  1.00 39.76           O  
ATOM   4953  CB  ILE F  33      80.703  47.617  43.592  1.00 39.92           C  
ATOM   4954  CG1 ILE F  33      79.556  47.614  44.606  1.00 40.87           C  
ATOM   4955  CG2 ILE F  33      80.513  48.713  42.560  1.00 39.39           C  
ATOM   4956  CD1 ILE F  33      79.328  48.941  45.285  1.00 42.06           C  
ATOM   4957  N   PRO F  34      82.466  45.090  44.251  1.00 42.34           N  
ATOM   4958  CA  PRO F  34      82.978  44.098  45.197  1.00 44.29           C  
ATOM   4959  C   PRO F  34      82.542  44.227  46.654  1.00 46.91           C  
ATOM   4960  O   PRO F  34      83.375  44.387  47.549  1.00 48.08           O  
ATOM   4961  CB  PRO F  34      84.490  44.213  45.022  1.00 44.37           C  
ATOM   4962  CG  PRO F  34      84.678  45.650  44.680  1.00 43.16           C  
ATOM   4963  CD  PRO F  34      83.561  45.909  43.706  1.00 42.65           C  
ATOM   4964  N   ILE F  35      81.233  44.148  46.880  1.00 48.00           N  
ATOM   4965  CA  ILE F  35      80.665  44.207  48.222  1.00 49.81           C  
ATOM   4966  C   ILE F  35      80.125  42.819  48.601  1.00 51.60           C  
ATOM   4967  O   ILE F  35      79.468  42.151  47.791  1.00 50.65           O  
ATOM   4968  CB  ILE F  35      79.499  45.243  48.313  1.00 50.96           C  
ATOM   4969  CG1 ILE F  35      80.055  46.672  48.333  1.00 51.51           C  
ATOM   4970  CG2 ILE F  35      78.681  45.006  49.578  1.00 50.73           C  
ATOM   4971  CD1 ILE F  35      78.988  47.759  48.398  1.00 49.99           C  
ATOM   4972  N   ASP F  36      80.412  42.400  49.836  1.00 52.80           N  
ATOM   4973  CA  ASP F  36      79.968  41.110  50.380  1.00 52.90           C  
ATOM   4974  C   ASP F  36      78.541  41.229  50.947  1.00 51.95           C  
ATOM   4975  O   ASP F  36      78.316  41.887  51.959  1.00 50.43           O  
ATOM   4976  CB  ASP F  36      80.934  40.667  51.476  1.00 55.81           C  
ATOM   4977  CG  ASP F  36      80.518  39.375  52.142  1.00 58.83           C  
ATOM   4978  OD1 ASP F  36      81.309  38.869  52.970  1.00 60.19           O  
ATOM   4979  OD2 ASP F  36      79.409  38.875  51.847  1.00 58.93           O  
ATOM   4980  N   PRO F  37      77.564  40.569  50.305  1.00 50.92           N  
ATOM   4981  CA  PRO F  37      76.159  40.600  50.722  1.00 50.69           C  
ATOM   4982  C   PRO F  37      75.871  40.335  52.187  1.00 52.30           C  
ATOM   4983  O   PRO F  37      74.855  40.789  52.710  1.00 52.87           O  
ATOM   4984  CB  PRO F  37      75.495  39.576  49.799  1.00 51.02           C  
ATOM   4985  CG  PRO F  37      76.608  38.641  49.455  1.00 51.27           C  
ATOM   4986  CD  PRO F  37      77.769  39.570  49.241  1.00 50.49           C  
ATOM   4987  N   LYS F  38      76.757  39.607  52.855  1.00 54.45           N  
ATOM   4988  CA  LYS F  38      76.554  39.300  54.266  1.00 55.80           C  
ATOM   4989  C   LYS F  38      76.893  40.491  55.162  1.00 57.03           C  
ATOM   4990  O   LYS F  38      76.014  41.049  55.826  1.00 56.90           O  
ATOM   4991  CB  LYS F  38      77.387  38.090  54.663  1.00 56.53           C  
ATOM   4992  N   THR F  39      78.163  40.888  55.164  1.00 57.83           N  
ATOM   4993  CA  THR F  39      78.628  42.001  55.991  1.00 58.48           C  
ATOM   4994  C   THR F  39      78.227  43.380  55.479  1.00 59.58           C  
ATOM   4995  O   THR F  39      78.032  44.309  56.262  1.00 59.95           O  
ATOM   4996  CB  THR F  39      80.156  41.984  56.116  1.00 58.60           C  
ATOM   4997  OG1 THR F  39      80.741  42.597  54.959  1.00 59.08           O  
ATOM   4998  CG2 THR F  39      80.652  40.553  56.215  1.00 59.28           C  
ATOM   4999  N   GLY F  40      78.113  43.516  54.163  1.00 61.04           N  
ATOM   5000  CA  GLY F  40      77.768  44.799  53.584  1.00 61.63           C  
ATOM   5001  C   GLY F  40      79.035  45.600  53.351  1.00 62.71           C  
ATOM   5002  O   GLY F  40      78.988  46.708  52.815  1.00 63.15           O  
ATOM   5003  N   GLU F  41      80.170  45.026  53.747  1.00 63.29           N  
ATOM   5004  CA  GLU F  41      81.478  45.666  53.601  1.00 65.57           C  
ATOM   5005  C   GLU F  41      82.140  45.299  52.270  1.00 65.42           C  
ATOM   5006  O   GLU F  41      81.871  44.237  51.711  1.00 65.57           O  
ATOM   5007  CB  GLU F  41      82.402  45.235  54.744  1.00 67.78           C  
ATOM   5008  CG  GLU F  41      81.794  45.329  56.136  1.00 71.21           C  
ATOM   5009  CD  GLU F  41      81.443  46.750  56.533  1.00 73.29           C  
ATOM   5010  OE1 GLU F  41      82.338  47.621  56.487  1.00 73.76           O  
ATOM   5011  OE2 GLU F  41      80.270  46.994  56.896  1.00 75.10           O  
ATOM   5012  N   ILE F  42      83.015  46.172  51.777  1.00 65.21           N  
ATOM   5013  CA  ILE F  42      83.712  45.929  50.514  1.00 66.28           C  
ATOM   5014  C   ILE F  42      84.883  44.974  50.683  1.00 66.81           C  
ATOM   5015  O   ILE F  42      85.903  45.331  51.263  1.00 67.38           O  
ATOM   5016  CB  ILE F  42      84.241  47.250  49.892  1.00 66.20           C  
ATOM   5017  CG1 ILE F  42      83.078  48.027  49.268  1.00 66.49           C  
ATOM   5018  CG2 ILE F  42      85.320  46.956  48.847  1.00 65.14           C  
ATOM   5019  CD1 ILE F  42      83.484  49.310  48.575  1.00 66.62           C  
ATOM   5020  N   VAL F  43      84.735  43.759  50.167  1.00 67.70           N  
ATOM   5021  CA  VAL F  43      85.796  42.764  50.266  1.00 68.27           C  
ATOM   5022  C   VAL F  43      87.136  43.421  49.970  1.00 69.68           C  
ATOM   5023  O   VAL F  43      87.474  43.679  48.814  1.00 71.45           O  
ATOM   5024  CB  VAL F  43      85.565  41.600  49.275  1.00 66.98           C  
ATOM   5025  CG1 VAL F  43      86.765  40.675  49.265  1.00 65.99           C  
ATOM   5026  CG2 VAL F  43      84.307  40.835  49.661  1.00 64.78           C  
ATOM   5027  N   LYS F  44      87.895  43.705  51.022  1.00 70.61           N  
ATOM   5028  CA  LYS F  44      89.199  44.336  50.861  1.00 71.33           C  
ATOM   5029  C   LYS F  44      90.183  43.352  50.242  1.00 71.13           C  
ATOM   5030  O   LYS F  44      90.252  42.187  50.638  1.00 70.56           O  
ATOM   5031  CB  LYS F  44      89.726  44.829  52.216  1.00 71.19           C  
ATOM   5032  N   GLY F  45      90.938  43.830  49.261  1.00 70.99           N  
ATOM   5033  CA  GLY F  45      91.916  42.978  48.616  1.00 69.50           C  
ATOM   5034  C   GLY F  45      92.479  43.614  47.364  1.00 68.54           C  
ATOM   5035  O   GLY F  45      92.385  44.829  47.166  1.00 66.74           O  
ATOM   5036  N   ASP F  46      93.079  42.784  46.519  1.00 67.70           N  
ATOM   5037  CA  ASP F  46      93.648  43.258  45.269  1.00 66.24           C  
ATOM   5038  C   ASP F  46      92.576  43.151  44.193  1.00 63.89           C  
ATOM   5039  O   ASP F  46      91.412  42.880  44.480  1.00 62.73           O  
ATOM   5040  CB  ASP F  46      94.862  42.409  44.877  1.00 67.21           C  
ATOM   5041  CG  ASP F  46      94.488  40.976  44.545  1.00 68.98           C  
ATOM   5042  OD1 ASP F  46      93.895  40.301  45.416  1.00 68.86           O  
ATOM   5043  OD2 ASP F  46      94.785  40.529  43.414  1.00 69.52           O  
ATOM   5044  N   ILE F  47      92.980  43.356  42.951  1.00 61.75           N  
ATOM   5045  CA  ILE F  47      92.060  43.286  41.834  1.00 60.15           C  
ATOM   5046  C   ILE F  47      91.449  41.888  41.692  1.00 58.60           C  
ATOM   5047  O   ILE F  47      90.285  41.748  41.322  1.00 58.91           O  
ATOM   5048  CB  ILE F  47      92.786  43.663  40.526  1.00 59.81           C  
ATOM   5049  CG1 ILE F  47      91.780  43.795  39.378  1.00 59.41           C  
ATOM   5050  CG2 ILE F  47      93.856  42.625  40.220  1.00 58.63           C  
ATOM   5051  CD1 ILE F  47      90.796  44.942  39.537  1.00 57.21           C  
ATOM   5052  N   LYS F  48      92.231  40.860  42.003  1.00 57.15           N  
ATOM   5053  CA  LYS F  48      91.767  39.482  41.876  1.00 55.79           C  
ATOM   5054  C   LYS F  48      90.602  39.122  42.793  1.00 54.66           C  
ATOM   5055  O   LYS F  48      89.712  38.360  42.411  1.00 54.77           O  
ATOM   5056  CB  LYS F  48      92.932  38.521  42.108  1.00 55.51           C  
ATOM   5057  N   ASP F  49      90.610  39.677  43.999  1.00 53.96           N  
ATOM   5058  CA  ASP F  49      89.566  39.400  44.979  1.00 51.79           C  
ATOM   5059  C   ASP F  49      88.293  40.215  44.797  1.00 49.42           C  
ATOM   5060  O   ASP F  49      87.213  39.781  45.187  1.00 48.06           O  
ATOM   5061  CB  ASP F  49      90.117  39.600  46.392  1.00 54.85           C  
ATOM   5062  CG  ASP F  49      90.962  38.425  46.855  1.00 58.09           C  
ATOM   5063  OD1 ASP F  49      92.005  38.145  46.220  1.00 59.35           O  
ATOM   5064  OD2 ASP F  49      90.572  37.773  47.852  1.00 60.05           O  
ATOM   5065  N   GLN F  50      88.409  41.402  44.216  1.00 47.23           N  
ATOM   5066  CA  GLN F  50      87.226  42.210  43.992  1.00 45.34           C  
ATOM   5067  C   GLN F  50      86.525  41.679  42.750  1.00 43.91           C  
ATOM   5068  O   GLN F  50      85.302  41.727  42.661  1.00 43.12           O  
ATOM   5069  CB  GLN F  50      87.595  43.689  43.827  1.00 46.55           C  
ATOM   5070  CG  GLN F  50      88.205  44.307  45.079  1.00 47.75           C  
ATOM   5071  CD  GLN F  50      87.860  45.777  45.250  1.00 49.05           C  
ATOM   5072  OE1 GLN F  50      88.124  46.602  44.378  1.00 50.43           O  
ATOM   5073  NE2 GLN F  50      87.266  46.110  46.386  1.00 50.09           N  
ATOM   5074  N   THR F  51      87.300  41.153  41.803  1.00 42.94           N  
ATOM   5075  CA  THR F  51      86.733  40.590  40.579  1.00 43.04           C  
ATOM   5076  C   THR F  51      85.852  39.401  40.926  1.00 42.72           C  
ATOM   5077  O   THR F  51      84.742  39.254  40.413  1.00 42.39           O  
ATOM   5078  CB  THR F  51      87.825  40.080  39.623  1.00 43.31           C  
ATOM   5079  OG1 THR F  51      88.685  41.163  39.255  1.00 43.71           O  
ATOM   5080  CG2 THR F  51      87.194  39.487  38.366  1.00 40.73           C  
ATOM   5081  N   ARG F  52      86.372  38.557  41.810  1.00 42.40           N  
ATOM   5082  CA  ARG F  52      85.687  37.353  42.251  1.00 42.52           C  
ATOM   5083  C   ARG F  52      84.383  37.653  42.981  1.00 41.99           C  
ATOM   5084  O   ARG F  52      83.383  36.954  42.801  1.00 41.80           O  
ATOM   5085  CB  ARG F  52      86.630  36.542  43.141  1.00 44.81           C  
ATOM   5086  CG  ARG F  52      86.193  35.112  43.424  1.00 48.90           C  
ATOM   5087  CD  ARG F  52      87.412  34.220  43.655  1.00 51.92           C  
ATOM   5088  NE  ARG F  52      88.127  33.930  42.409  1.00 55.30           N  
ATOM   5089  CZ  ARG F  52      89.410  33.570  42.344  1.00 57.65           C  
ATOM   5090  NH1 ARG F  52      90.131  33.459  43.451  1.00 59.85           N  
ATOM   5091  NH2 ARG F  52      89.979  33.316  41.175  1.00 58.09           N  
ATOM   5092  N   GLN F  53      84.385  38.699  43.800  1.00 40.95           N  
ATOM   5093  CA  GLN F  53      83.184  39.051  44.541  1.00 40.00           C  
ATOM   5094  C   GLN F  53      82.114  39.580  43.590  1.00 39.30           C  
ATOM   5095  O   GLN F  53      80.937  39.231  43.709  1.00 39.60           O  
ATOM   5096  CB  GLN F  53      83.503  40.096  45.618  1.00 40.40           C  
ATOM   5097  CG  GLN F  53      82.312  40.437  46.506  1.00 42.63           C  
ATOM   5098  CD  GLN F  53      81.769  39.215  47.231  1.00 43.09           C  
ATOM   5099  OE1 GLN F  53      82.436  38.652  48.095  1.00 44.44           O  
ATOM   5100  NE2 GLN F  53      80.559  38.793  46.872  1.00 42.41           N  
ATOM   5101  N   VAL F  54      82.523  40.432  42.653  1.00 37.62           N  
ATOM   5102  CA  VAL F  54      81.590  40.986  41.678  1.00 35.92           C  
ATOM   5103  C   VAL F  54      80.980  39.838  40.878  1.00 34.42           C  
ATOM   5104  O   VAL F  54      79.769  39.758  40.711  1.00 34.25           O  
ATOM   5105  CB  VAL F  54      82.301  41.974  40.709  1.00 35.52           C  
ATOM   5106  CG1 VAL F  54      81.432  42.232  39.480  1.00 35.08           C  
ATOM   5107  CG2 VAL F  54      82.583  43.279  41.421  1.00 30.18           C  
ATOM   5108  N   LEU F  55      81.832  38.946  40.395  1.00 34.50           N  
ATOM   5109  CA  LEU F  55      81.376  37.793  39.631  1.00 35.32           C  
ATOM   5110  C   LEU F  55      80.399  36.914  40.406  1.00 34.52           C  
ATOM   5111  O   LEU F  55      79.475  36.351  39.827  1.00 33.43           O  
ATOM   5112  CB  LEU F  55      82.577  36.970  39.176  1.00 34.07           C  
ATOM   5113  CG  LEU F  55      83.323  37.650  38.032  1.00 33.77           C  
ATOM   5114  CD1 LEU F  55      84.545  36.851  37.658  1.00 34.33           C  
ATOM   5115  CD2 LEU F  55      82.377  37.785  36.840  1.00 33.63           C  
ATOM   5116  N   GLU F  56      80.606  36.804  41.715  1.00 35.71           N  
ATOM   5117  CA  GLU F  56      79.734  35.996  42.566  1.00 35.68           C  
ATOM   5118  C   GLU F  56      78.374  36.662  42.691  1.00 33.68           C  
ATOM   5119  O   GLU F  56      77.330  35.998  42.614  1.00 33.53           O  
ATOM   5120  CB  GLU F  56      80.344  35.830  43.959  1.00 40.26           C  
ATOM   5121  CG  GLU F  56      81.545  34.888  44.038  1.00 47.56           C  
ATOM   5122  CD  GLU F  56      81.166  33.420  43.860  1.00 53.17           C  
ATOM   5123  OE1 GLU F  56      80.836  33.013  42.718  1.00 54.36           O  
ATOM   5124  OE2 GLU F  56      81.194  32.675  44.871  1.00 55.67           O  
ATOM   5125  N   ASN F  57      78.391  37.976  42.887  1.00 30.99           N  
ATOM   5126  CA  ASN F  57      77.157  38.730  43.018  1.00 30.47           C  
ATOM   5127  C   ASN F  57      76.361  38.644  41.718  1.00 29.22           C  
ATOM   5128  O   ASN F  57      75.133  38.566  41.741  1.00 27.98           O  
ATOM   5129  CB  ASN F  57      77.459  40.188  43.385  1.00 33.37           C  
ATOM   5130  CG  ASN F  57      78.098  40.329  44.775  1.00 35.88           C  
ATOM   5131  OD1 ASN F  57      77.755  39.598  45.707  1.00 34.57           O  
ATOM   5132  ND2 ASN F  57      79.021  41.279  44.914  1.00 35.99           N  
ATOM   5133  N   ILE F  58      77.068  38.642  40.585  1.00 28.00           N  
ATOM   5134  CA  ILE F  58      76.430  38.526  39.274  1.00 24.97           C  
ATOM   5135  C   ILE F  58      75.755  37.155  39.156  1.00 25.65           C  
ATOM   5136  O   ILE F  58      74.602  37.048  38.715  1.00 24.20           O  
ATOM   5137  CB  ILE F  58      77.454  38.683  38.143  1.00 23.69           C  
ATOM   5138  CG1 ILE F  58      78.035  40.096  38.166  1.00 24.70           C  
ATOM   5139  CG2 ILE F  58      76.797  38.449  36.807  1.00 21.92           C  
ATOM   5140  CD1 ILE F  58      79.163  40.321  37.169  1.00 23.29           C  
ATOM   5141  N   LYS F  59      76.479  36.113  39.570  1.00 25.69           N  
ATOM   5142  CA  LYS F  59      75.974  34.747  39.546  1.00 24.81           C  
ATOM   5143  C   LYS F  59      74.739  34.623  40.449  1.00 25.33           C  
ATOM   5144  O   LYS F  59      73.753  33.983  40.084  1.00 22.97           O  
ATOM   5145  CB  LYS F  59      77.068  33.784  40.007  1.00 26.61           C  
ATOM   5146  CG  LYS F  59      76.709  32.311  39.893  1.00 27.97           C  
ATOM   5147  CD  LYS F  59      77.936  31.435  40.041  1.00 29.50           C  
ATOM   5148  CE  LYS F  59      77.654  29.966  39.675  1.00 35.35           C  
ATOM   5149  NZ  LYS F  59      76.762  29.258  40.645  1.00 38.35           N  
ATOM   5150  N   ALA F  60      74.788  35.250  41.624  1.00 24.83           N  
ATOM   5151  CA  ALA F  60      73.655  35.198  42.543  1.00 24.34           C  
ATOM   5152  C   ALA F  60      72.404  35.833  41.938  1.00 25.78           C  
ATOM   5153  O   ALA F  60      71.291  35.337  42.125  1.00 26.41           O  
ATOM   5154  CB  ALA F  60      74.001  35.895  43.828  1.00 23.98           C  
ATOM   5155  N   ILE F  61      72.584  36.927  41.204  1.00 25.57           N  
ATOM   5156  CA  ILE F  61      71.452  37.619  40.604  1.00 24.43           C  
ATOM   5157  C   ILE F  61      70.858  36.808  39.457  1.00 26.44           C  
ATOM   5158  O   ILE F  61      69.637  36.673  39.353  1.00 27.14           O  
ATOM   5159  CB  ILE F  61      71.875  39.032  40.130  1.00 24.84           C  
ATOM   5160  CG1 ILE F  61      72.355  39.851  41.337  1.00 22.79           C  
ATOM   5161  CG2 ILE F  61      70.709  39.749  39.455  1.00 22.93           C  
ATOM   5162  CD1 ILE F  61      72.932  41.192  40.988  1.00 20.51           C  
ATOM   5163  N   LEU F  62      71.723  36.261  38.607  1.00 27.82           N  
ATOM   5164  CA  LEU F  62      71.275  35.441  37.489  1.00 27.37           C  
ATOM   5165  C   LEU F  62      70.416  34.313  38.036  1.00 29.64           C  
ATOM   5166  O   LEU F  62      69.318  34.049  37.539  1.00 28.71           O  
ATOM   5167  CB  LEU F  62      72.482  34.865  36.746  1.00 26.89           C  
ATOM   5168  CG  LEU F  62      73.152  35.794  35.727  1.00 24.64           C  
ATOM   5169  CD1 LEU F  62      74.555  35.300  35.387  1.00 23.84           C  
ATOM   5170  CD2 LEU F  62      72.281  35.871  34.511  1.00 18.99           C  
ATOM   5171  N   GLU F  63      70.927  33.655  39.072  1.00 32.64           N  
ATOM   5172  CA  GLU F  63      70.218  32.562  39.723  1.00 36.26           C  
ATOM   5173  C   GLU F  63      68.858  33.022  40.242  1.00 35.65           C  
ATOM   5174  O   GLU F  63      67.838  32.379  39.988  1.00 36.40           O  
ATOM   5175  CB  GLU F  63      71.062  32.002  40.867  1.00 40.73           C  
ATOM   5176  CG  GLU F  63      72.211  31.123  40.383  1.00 49.69           C  
ATOM   5177  CD  GLU F  63      73.177  30.716  41.493  1.00 55.40           C  
ATOM   5178  OE1 GLU F  63      74.075  31.521  41.850  1.00 56.79           O  
ATOM   5179  OE2 GLU F  63      73.029  29.584  42.010  1.00 60.24           O  
ATOM   5180  N   ALA F  64      68.837  34.141  40.957  1.00 34.85           N  
ATOM   5181  CA  ALA F  64      67.588  34.670  41.485  1.00 33.90           C  
ATOM   5182  C   ALA F  64      66.562  34.856  40.365  1.00 35.12           C  
ATOM   5183  O   ALA F  64      65.356  34.698  40.587  1.00 32.40           O  
ATOM   5184  CB  ALA F  64      67.835  35.999  42.185  1.00 31.61           C  
ATOM   5185  N   ALA F  65      67.052  35.189  39.168  1.00 34.83           N  
ATOM   5186  CA  ALA F  65      66.189  35.423  38.014  1.00 36.07           C  
ATOM   5187  C   ALA F  65      65.876  34.172  37.196  1.00 37.88           C  
ATOM   5188  O   ALA F  65      65.087  34.231  36.250  1.00 37.83           O  
ATOM   5189  CB  ALA F  65      66.813  36.478  37.111  1.00 37.04           C  
ATOM   5190  N   GLY F  66      66.498  33.050  37.549  1.00 38.37           N  
ATOM   5191  CA  GLY F  66      66.261  31.815  36.822  1.00 38.10           C  
ATOM   5192  C   GLY F  66      67.216  31.611  35.656  1.00 38.51           C  
ATOM   5193  O   GLY F  66      66.994  30.752  34.807  1.00 39.89           O  
ATOM   5194  N   TYR F  67      68.281  32.402  35.616  1.00 36.27           N  
ATOM   5195  CA  TYR F  67      69.267  32.313  34.550  1.00 34.25           C  
ATOM   5196  C   TYR F  67      70.532  31.656  35.073  1.00 34.79           C  
ATOM   5197  O   TYR F  67      70.658  31.369  36.262  1.00 35.61           O  
ATOM   5198  CB  TYR F  67      69.622  33.710  34.026  1.00 32.16           C  
ATOM   5199  CG  TYR F  67      68.522  34.440  33.285  1.00 31.18           C  
ATOM   5200  CD1 TYR F  67      68.771  35.020  32.036  1.00 31.99           C  
ATOM   5201  CD2 TYR F  67      67.251  34.587  33.829  1.00 31.07           C  
ATOM   5202  CE1 TYR F  67      67.793  35.726  31.351  1.00 28.29           C  
ATOM   5203  CE2 TYR F  67      66.257  35.300  33.146  1.00 31.50           C  
ATOM   5204  CZ  TYR F  67      66.541  35.863  31.906  1.00 30.28           C  
ATOM   5205  OH  TYR F  67      65.573  36.556  31.208  1.00 32.24           O  
ATOM   5206  N   SER F  68      71.480  31.430  34.179  1.00 35.56           N  
ATOM   5207  CA  SER F  68      72.743  30.824  34.564  1.00 36.86           C  
ATOM   5208  C   SER F  68      73.885  31.595  33.926  1.00 36.79           C  
ATOM   5209  O   SER F  68      73.664  32.474  33.101  1.00 37.39           O  
ATOM   5210  CB  SER F  68      72.793  29.366  34.112  1.00 36.11           C  
ATOM   5211  OG  SER F  68      72.713  29.280  32.704  1.00 37.03           O  
ATOM   5212  N   LEU F  69      75.109  31.256  34.303  1.00 37.78           N  
ATOM   5213  CA  LEU F  69      76.274  31.933  33.759  1.00 38.05           C  
ATOM   5214  C   LEU F  69      76.396  31.910  32.229  1.00 38.72           C  
ATOM   5215  O   LEU F  69      76.854  32.890  31.637  1.00 39.29           O  
ATOM   5216  CB  LEU F  69      77.536  31.374  34.416  1.00 36.82           C  
ATOM   5217  CG  LEU F  69      77.731  31.971  35.814  1.00 36.55           C  
ATOM   5218  CD1 LEU F  69      78.714  31.144  36.619  1.00 37.58           C  
ATOM   5219  CD2 LEU F  69      78.206  33.408  35.677  1.00 32.68           C  
ATOM   5220  N   ASN F  70      75.979  30.830  31.569  1.00 38.97           N  
ATOM   5221  CA  ASN F  70      76.097  30.815  30.112  1.00 39.21           C  
ATOM   5222  C   ASN F  70      74.916  31.441  29.360  1.00 36.49           C  
ATOM   5223  O   ASN F  70      74.830  31.355  28.130  1.00 34.64           O  
ATOM   5224  CB  ASN F  70      76.412  29.402  29.583  1.00 42.41           C  
ATOM   5225  CG  ASN F  70      75.378  28.374  29.977  1.00 46.81           C  
ATOM   5226  OD1 ASN F  70      75.594  27.175  29.799  1.00 48.55           O  
ATOM   5227  ND2 ASN F  70      74.249  28.830  30.511  1.00 49.27           N  
ATOM   5228  N   ASP F  71      74.019  32.083  30.103  1.00 33.49           N  
ATOM   5229  CA  ASP F  71      72.885  32.787  29.499  1.00 32.24           C  
ATOM   5230  C   ASP F  71      73.344  34.235  29.259  1.00 29.28           C  
ATOM   5231  O   ASP F  71      72.668  35.011  28.595  1.00 29.67           O  
ATOM   5232  CB  ASP F  71      71.662  32.775  30.431  1.00 32.59           C  
ATOM   5233  CG  ASP F  71      70.807  31.517  30.283  1.00 36.09           C  
ATOM   5234  OD1 ASP F  71      69.894  31.339  31.128  1.00 36.58           O  
ATOM   5235  OD2 ASP F  71      71.027  30.722  29.329  1.00 33.35           O  
ATOM   5236  N   VAL F  72      74.505  34.575  29.816  1.00 27.25           N  
ATOM   5237  CA  VAL F  72      75.100  35.903  29.679  1.00 25.44           C  
ATOM   5238  C   VAL F  72      75.588  36.084  28.254  1.00 26.08           C  
ATOM   5239  O   VAL F  72      76.371  35.269  27.747  1.00 25.14           O  
ATOM   5240  CB  VAL F  72      76.311  36.080  30.633  1.00 25.50           C  
ATOM   5241  CG1 VAL F  72      76.987  37.425  30.391  1.00 25.05           C  
ATOM   5242  CG2 VAL F  72      75.853  35.967  32.079  1.00 24.23           C  
ATOM   5243  N   ILE F  73      75.137  37.165  27.618  1.00 26.54           N  
ATOM   5244  CA  ILE F  73      75.507  37.454  26.236  1.00 25.91           C  
ATOM   5245  C   ILE F  73      76.406  38.681  26.079  1.00 27.97           C  
ATOM   5246  O   ILE F  73      77.140  38.799  25.102  1.00 28.95           O  
ATOM   5247  CB  ILE F  73      74.248  37.634  25.364  1.00 24.35           C  
ATOM   5248  CG1 ILE F  73      73.458  38.855  25.826  1.00 21.28           C  
ATOM   5249  CG2 ILE F  73      73.382  36.377  25.437  1.00 21.49           C  
ATOM   5250  CD1 ILE F  73      72.232  39.126  24.992  1.00 21.49           C  
ATOM   5251  N   LYS F  74      76.362  39.596  27.036  1.00 29.00           N  
ATOM   5252  CA  LYS F  74      77.196  40.783  26.951  1.00 30.88           C  
ATOM   5253  C   LYS F  74      77.670  41.228  28.329  1.00 30.72           C  
ATOM   5254  O   LYS F  74      76.901  41.237  29.286  1.00 30.32           O  
ATOM   5255  CB  LYS F  74      76.429  41.928  26.273  1.00 33.46           C  
ATOM   5256  CG  LYS F  74      77.243  43.213  26.134  1.00 35.17           C  
ATOM   5257  CD  LYS F  74      76.414  44.353  25.557  1.00 39.39           C  
ATOM   5258  CE  LYS F  74      77.220  45.650  25.513  1.00 39.55           C  
ATOM   5259  NZ  LYS F  74      76.440  46.778  24.926  1.00 40.58           N  
ATOM   5260  N   VAL F  75      78.939  41.605  28.421  1.00 29.48           N  
ATOM   5261  CA  VAL F  75      79.498  42.054  29.688  1.00 29.07           C  
ATOM   5262  C   VAL F  75      80.328  43.314  29.464  1.00 28.52           C  
ATOM   5263  O   VAL F  75      81.001  43.447  28.442  1.00 27.12           O  
ATOM   5264  CB  VAL F  75      80.430  40.961  30.326  1.00 31.65           C  
ATOM   5265  CG1 VAL F  75      81.099  41.507  31.579  1.00 30.10           C  
ATOM   5266  CG2 VAL F  75      79.633  39.694  30.669  1.00 30.33           C  
ATOM   5267  N   THR F  76      80.259  44.248  30.403  1.00 27.94           N  
ATOM   5268  CA  THR F  76      81.068  45.455  30.309  1.00 29.78           C  
ATOM   5269  C   THR F  76      81.831  45.552  31.619  1.00 29.36           C  
ATOM   5270  O   THR F  76      81.239  45.605  32.701  1.00 27.60           O  
ATOM   5271  CB  THR F  76      80.226  46.741  30.117  1.00 32.14           C  
ATOM   5272  OG1 THR F  76      79.375  46.593  28.976  1.00 34.72           O  
ATOM   5273  CG2 THR F  76      81.147  47.949  29.889  1.00 29.89           C  
ATOM   5274  N   VAL F  77      83.151  45.563  31.512  1.00 28.99           N  
ATOM   5275  CA  VAL F  77      84.007  45.635  32.684  1.00 29.89           C  
ATOM   5276  C   VAL F  77      84.602  47.027  32.833  1.00 30.28           C  
ATOM   5277  O   VAL F  77      85.179  47.569  31.887  1.00 29.83           O  
ATOM   5278  CB  VAL F  77      85.162  44.594  32.589  1.00 29.62           C  
ATOM   5279  CG1 VAL F  77      85.977  44.570  33.884  1.00 27.79           C  
ATOM   5280  CG2 VAL F  77      84.587  43.213  32.288  1.00 28.40           C  
ATOM   5281  N   TYR F  78      84.433  47.606  34.017  1.00 32.64           N  
ATOM   5282  CA  TYR F  78      84.987  48.924  34.326  1.00 36.29           C  
ATOM   5283  C   TYR F  78      86.100  48.769  35.368  1.00 37.66           C  
ATOM   5284  O   TYR F  78      85.858  48.305  36.485  1.00 37.56           O  
ATOM   5285  CB  TYR F  78      83.910  49.866  34.876  1.00 35.72           C  
ATOM   5286  CG  TYR F  78      82.767  50.131  33.918  1.00 39.05           C  
ATOM   5287  CD1 TYR F  78      81.530  49.502  34.086  1.00 38.70           C  
ATOM   5288  CD2 TYR F  78      82.922  51.003  32.831  1.00 37.77           C  
ATOM   5289  CE1 TYR F  78      80.478  49.729  33.201  1.00 36.80           C  
ATOM   5290  CE2 TYR F  78      81.874  51.240  31.945  1.00 36.25           C  
ATOM   5291  CZ  TYR F  78      80.653  50.598  32.135  1.00 37.02           C  
ATOM   5292  OH  TYR F  78      79.604  50.819  31.264  1.00 36.18           O  
ATOM   5293  N   LEU F  79      87.320  49.138  34.998  1.00 39.66           N  
ATOM   5294  CA  LEU F  79      88.445  49.045  35.921  1.00 43.17           C  
ATOM   5295  C   LEU F  79      88.934  50.418  36.371  1.00 44.50           C  
ATOM   5296  O   LEU F  79      88.671  51.426  35.714  1.00 43.40           O  
ATOM   5297  CB  LEU F  79      89.594  48.280  35.279  1.00 43.93           C  
ATOM   5298  CG  LEU F  79      89.371  46.777  35.150  1.00 45.73           C  
ATOM   5299  CD1 LEU F  79      90.555  46.152  34.427  1.00 45.97           C  
ATOM   5300  CD2 LEU F  79      89.198  46.169  36.541  1.00 45.71           C  
ATOM   5301  N   LYS F  80      89.649  50.439  37.494  1.00 47.16           N  
ATOM   5302  CA  LYS F  80      90.192  51.672  38.069  1.00 49.62           C  
ATOM   5303  C   LYS F  80      91.716  51.716  37.924  1.00 50.07           C  
ATOM   5304  O   LYS F  80      92.210  52.512  37.090  1.00 49.82           O  
ATOM   5305  CB  LYS F  80      89.808  51.756  39.554  1.00 51.67           C  
ATOM   5306  CG  LYS F  80      90.141  53.065  40.269  1.00 53.38           C  
ATOM   5307  CD  LYS F  80      89.404  53.110  41.611  1.00 56.69           C  
ATOM   5308  CE  LYS F  80      89.628  54.412  42.382  1.00 59.19           C  
ATOM   5309  NZ  LYS F  80      90.979  54.493  43.012  1.00 59.31           N  
ATOM   5310  N   MET F  88      89.692  42.577  34.507  1.00 77.35           N  
ATOM   5311  CA  MET F  88      89.294  41.282  35.127  1.00 79.14           C  
ATOM   5312  C   MET F  88      90.252  40.151  34.729  1.00 79.77           C  
ATOM   5313  O   MET F  88      91.252  39.899  35.412  1.00 78.58           O  
ATOM   5314  CB  MET F  88      87.859  40.933  34.714  1.00 77.78           C  
ATOM   5315  N   ASN F  89      89.933  39.480  33.620  1.00 80.41           N  
ATOM   5316  CA  ASN F  89      90.733  38.374  33.092  1.00 79.79           C  
ATOM   5317  C   ASN F  89      90.970  37.302  34.141  1.00 79.72           C  
ATOM   5318  O   ASN F  89      90.534  37.441  35.283  1.00 81.17           O  
ATOM   5319  CB  ASN F  89      92.082  38.884  32.579  1.00 79.74           C  
ATOM   5320  CG  ASN F  89      91.949  39.728  31.328  1.00 79.98           C  
ATOM   5321  OD1 ASN F  89      91.447  39.266  30.303  1.00 78.80           O  
ATOM   5322  ND2 ASN F  89      92.404  40.977  31.406  1.00 80.66           N  
ATOM   5323  N   GLU F  90      91.658  36.234  33.740  1.00 78.02           N  
ATOM   5324  CA  GLU F  90      91.988  35.124  34.630  1.00 76.35           C  
ATOM   5325  C   GLU F  90      90.774  34.664  35.444  1.00 73.86           C  
ATOM   5326  O   GLU F  90      90.157  33.646  35.122  1.00 73.08           O  
ATOM   5327  CB  GLU F  90      93.131  35.546  35.557  1.00 78.96           C  
ATOM   5328  CG  GLU F  90      93.829  34.398  36.273  1.00 82.76           C  
ATOM   5329  CD  GLU F  90      95.059  34.853  37.047  1.00 85.20           C  
ATOM   5330  OE1 GLU F  90      95.982  35.413  36.413  1.00 86.23           O  
ATOM   5331  OE2 GLU F  90      95.100  34.653  38.285  1.00 85.54           O  
ATOM   5332  N   VAL F  91      90.450  35.409  36.502  1.00 70.92           N  
ATOM   5333  CA  VAL F  91      89.297  35.109  37.354  1.00 68.22           C  
ATOM   5334  C   VAL F  91      88.082  35.078  36.432  1.00 66.20           C  
ATOM   5335  O   VAL F  91      87.224  34.194  36.517  1.00 64.95           O  
ATOM   5336  CB  VAL F  91      89.069  36.222  38.411  1.00 68.85           C  
ATOM   5337  CG1 VAL F  91      88.142  35.717  39.514  1.00 68.17           C  
ATOM   5338  CG2 VAL F  91      90.400  36.692  38.981  1.00 68.88           C  
ATOM   5339  N   TYR F  92      88.040  36.070  35.547  1.00 63.87           N  
ATOM   5340  CA  TYR F  92      86.984  36.225  34.563  1.00 60.95           C  
ATOM   5341  C   TYR F  92      86.841  34.930  33.757  1.00 59.34           C  
ATOM   5342  O   TYR F  92      85.736  34.427  33.560  1.00 58.57           O  
ATOM   5343  CB  TYR F  92      87.332  37.392  33.630  1.00 61.38           C  
ATOM   5344  CG  TYR F  92      86.185  37.888  32.771  1.00 61.53           C  
ATOM   5345  CD1 TYR F  92      85.210  38.733  33.300  1.00 61.39           C  
ATOM   5346  CD2 TYR F  92      86.063  37.494  31.435  1.00 60.01           C  
ATOM   5347  CE1 TYR F  92      84.144  39.175  32.521  1.00 61.07           C  
ATOM   5348  CE2 TYR F  92      85.000  37.927  30.649  1.00 59.27           C  
ATOM   5349  CZ  TYR F  92      84.044  38.766  31.197  1.00 59.85           C  
ATOM   5350  OH  TYR F  92      82.981  39.193  30.432  1.00 58.67           O  
ATOM   5351  N   ALA F  93      87.965  34.387  33.302  1.00 57.94           N  
ATOM   5352  CA  ALA F  93      87.953  33.159  32.513  1.00 58.08           C  
ATOM   5353  C   ALA F  93      87.309  31.991  33.261  1.00 58.49           C  
ATOM   5354  O   ALA F  93      86.772  31.063  32.650  1.00 58.81           O  
ATOM   5355  CB  ALA F  93      89.369  32.797  32.104  1.00 56.80           C  
ATOM   5356  N   GLU F  94      87.352  32.047  34.587  1.00 58.67           N  
ATOM   5357  CA  GLU F  94      86.786  30.989  35.411  1.00 58.52           C  
ATOM   5358  C   GLU F  94      85.272  30.886  35.332  1.00 56.75           C  
ATOM   5359  O   GLU F  94      84.736  29.790  35.188  1.00 57.70           O  
ATOM   5360  CB  GLU F  94      87.221  31.173  36.866  1.00 60.97           C  
ATOM   5361  CG  GLU F  94      88.717  30.977  37.067  1.00 65.12           C  
ATOM   5362  CD  GLU F  94      89.181  31.307  38.475  1.00 67.95           C  
ATOM   5363  OE1 GLU F  94      88.650  30.701  39.436  1.00 70.37           O  
ATOM   5364  OE2 GLU F  94      90.081  32.167  38.616  1.00 67.08           O  
ATOM   5365  N   TYR F  95      84.579  32.016  35.421  1.00 54.60           N  
ATOM   5366  CA  TYR F  95      83.119  32.004  35.364  1.00 52.07           C  
ATOM   5367  C   TYR F  95      82.576  31.922  33.948  1.00 51.93           C  
ATOM   5368  O   TYR F  95      81.531  31.330  33.701  1.00 51.74           O  
ATOM   5369  CB  TYR F  95      82.553  33.242  36.053  1.00 49.28           C  
ATOM   5370  CG  TYR F  95      82.807  33.260  37.537  1.00 48.33           C  
ATOM   5371  CD1 TYR F  95      84.094  33.458  38.041  1.00 46.88           C  
ATOM   5372  CD2 TYR F  95      81.766  33.056  38.439  1.00 46.58           C  
ATOM   5373  CE1 TYR F  95      84.338  33.454  39.406  1.00 45.59           C  
ATOM   5374  CE2 TYR F  95      81.996  33.050  39.804  1.00 47.22           C  
ATOM   5375  CZ  TYR F  95      83.284  33.249  40.284  1.00 46.89           C  
ATOM   5376  OH  TYR F  95      83.515  33.237  41.640  1.00 48.17           O  
ATOM   5377  N   PHE F  96      83.295  32.523  33.016  1.00 52.41           N  
ATOM   5378  CA  PHE F  96      82.865  32.523  31.633  1.00 53.46           C  
ATOM   5379  C   PHE F  96      83.740  31.601  30.788  1.00 55.76           C  
ATOM   5380  O   PHE F  96      84.596  32.053  30.019  1.00 55.59           O  
ATOM   5381  CB  PHE F  96      82.897  33.957  31.098  1.00 50.83           C  
ATOM   5382  CG  PHE F  96      81.973  34.889  31.828  1.00 46.58           C  
ATOM   5383  CD1 PHE F  96      80.594  34.691  31.789  1.00 45.95           C  
ATOM   5384  CD2 PHE F  96      82.476  35.953  32.566  1.00 45.22           C  
ATOM   5385  CE1 PHE F  96      79.730  35.536  32.472  1.00 44.31           C  
ATOM   5386  CE2 PHE F  96      81.621  36.808  33.255  1.00 44.02           C  
ATOM   5387  CZ  PHE F  96      80.243  36.598  33.209  1.00 44.76           C  
ATOM   5388  N   GLY F  97      83.524  30.299  30.956  1.00 56.96           N  
ATOM   5389  CA  GLY F  97      84.279  29.317  30.204  1.00 56.85           C  
ATOM   5390  C   GLY F  97      83.392  28.723  29.127  1.00 57.42           C  
ATOM   5391  O   GLY F  97      83.677  28.839  27.932  1.00 56.74           O  
ATOM   5392  N   GLU F  98      82.305  28.088  29.559  1.00 57.54           N  
ATOM   5393  CA  GLU F  98      81.356  27.475  28.637  1.00 58.18           C  
ATOM   5394  C   GLU F  98      80.628  28.585  27.895  1.00 58.13           C  
ATOM   5395  O   GLU F  98      80.022  28.363  26.841  1.00 58.71           O  
ATOM   5396  CB  GLU F  98      80.358  26.613  29.402  1.00 58.55           C  
ATOM   5397  N   SER F  99      80.693  29.782  28.470  1.00 56.31           N  
ATOM   5398  CA  SER F  99      80.064  30.966  27.903  1.00 53.57           C  
ATOM   5399  C   SER F  99      81.168  31.944  27.527  1.00 51.37           C  
ATOM   5400  O   SER F  99      82.108  32.154  28.300  1.00 52.23           O  
ATOM   5401  CB  SER F  99      79.126  31.614  28.929  1.00 54.08           C  
ATOM   5402  OG  SER F  99      78.513  32.787  28.414  1.00 54.98           O  
ATOM   5403  N   LYS F 100      81.064  32.519  26.335  1.00 45.97           N  
ATOM   5404  CA  LYS F 100      82.044  33.487  25.870  1.00 41.93           C  
ATOM   5405  C   LYS F 100      81.211  34.687  25.454  1.00 38.17           C  
ATOM   5406  O   LYS F 100      80.848  34.830  24.284  1.00 38.79           O  
ATOM   5407  CB  LYS F 100      82.814  32.940  24.664  1.00 43.38           C  
ATOM   5408  CG  LYS F 100      83.467  31.581  24.881  1.00 44.41           C  
ATOM   5409  CD  LYS F 100      84.769  31.678  25.665  1.00 46.45           C  
ATOM   5410  CE  LYS F 100      85.955  32.057  24.771  1.00 46.49           C  
ATOM   5411  NZ  LYS F 100      86.349  30.967  23.832  1.00 41.55           N  
ATOM   5412  N   PRO F 101      80.872  35.561  26.410  1.00 33.82           N  
ATOM   5413  CA  PRO F 101      80.064  36.741  26.081  1.00 30.16           C  
ATOM   5414  C   PRO F 101      80.832  37.813  25.327  1.00 28.47           C  
ATOM   5415  O   PRO F 101      82.068  37.833  25.330  1.00 26.09           O  
ATOM   5416  CB  PRO F 101      79.608  37.260  27.449  1.00 28.42           C  
ATOM   5417  CG  PRO F 101      79.795  36.093  28.376  1.00 32.16           C  
ATOM   5418  CD  PRO F 101      81.045  35.433  27.867  1.00 33.32           C  
ATOM   5419  N   ALA F 102      80.087  38.697  24.670  1.00 28.12           N  
ATOM   5420  CA  ALA F 102      80.692  39.822  23.975  1.00 28.02           C  
ATOM   5421  C   ALA F 102      81.278  40.628  25.132  1.00 28.42           C  
ATOM   5422  O   ALA F 102      80.661  40.738  26.196  1.00 27.39           O  
ATOM   5423  CB  ALA F 102      79.628  40.628  23.243  1.00 25.65           C  
ATOM   5424  N   ARG F 103      82.463  41.184  24.935  1.00 31.67           N  
ATOM   5425  CA  ARG F 103      83.124  41.926  25.992  1.00 34.39           C  
ATOM   5426  C   ARG F 103      83.557  43.340  25.645  1.00 34.75           C  
ATOM   5427  O   ARG F 103      83.949  43.647  24.518  1.00 34.35           O  
ATOM   5428  CB  ARG F 103      84.346  41.128  26.476  1.00 39.82           C  
ATOM   5429  CG  ARG F 103      85.426  41.946  27.189  1.00 44.77           C  
ATOM   5430  CD  ARG F 103      85.336  41.839  28.708  1.00 49.29           C  
ATOM   5431  NE  ARG F 103      85.968  40.622  29.210  1.00 53.40           N  
ATOM   5432  CZ  ARG F 103      87.245  40.305  29.012  1.00 56.36           C  
ATOM   5433  NH1 ARG F 103      87.733  39.175  29.509  1.00 58.72           N  
ATOM   5434  NH2 ARG F 103      88.034  41.116  28.316  1.00 55.51           N  
ATOM   5435  N   VAL F 104      83.466  44.201  26.645  1.00 33.53           N  
ATOM   5436  CA  VAL F 104      83.895  45.574  26.512  1.00 34.04           C  
ATOM   5437  C   VAL F 104      84.638  45.845  27.803  1.00 34.31           C  
ATOM   5438  O   VAL F 104      84.108  45.610  28.887  1.00 34.47           O  
ATOM   5439  CB  VAL F 104      82.716  46.553  26.394  1.00 35.44           C  
ATOM   5440  CG1 VAL F 104      83.240  47.982  26.301  1.00 32.71           C  
ATOM   5441  CG2 VAL F 104      81.882  46.214  25.171  1.00 36.05           C  
ATOM   5442  N   ALA F 105      85.875  46.311  27.678  1.00 35.65           N  
ATOM   5443  CA  ALA F 105      86.708  46.619  28.832  1.00 36.48           C  
ATOM   5444  C   ALA F 105      87.370  47.973  28.644  1.00 37.04           C  
ATOM   5445  O   ALA F 105      88.080  48.197  27.663  1.00 39.58           O  
ATOM   5446  CB  ALA F 105      87.764  45.547  29.017  1.00 35.02           C  
ATOM   5447  N   VAL F 106      87.119  48.879  29.583  1.00 36.26           N  
ATOM   5448  CA  VAL F 106      87.699  50.215  29.537  1.00 34.81           C  
ATOM   5449  C   VAL F 106      88.162  50.607  30.940  1.00 35.70           C  
ATOM   5450  O   VAL F 106      87.644  50.098  31.942  1.00 33.39           O  
ATOM   5451  CB  VAL F 106      86.673  51.269  29.032  1.00 31.61           C  
ATOM   5452  CG1 VAL F 106      86.199  50.910  27.651  1.00 32.22           C  
ATOM   5453  CG2 VAL F 106      85.497  51.358  29.980  1.00 29.76           C  
ATOM   5454  N   GLU F 107      89.151  51.491  31.005  1.00 36.29           N  
ATOM   5455  CA  GLU F 107      89.659  51.967  32.285  1.00 38.22           C  
ATOM   5456  C   GLU F 107      89.012  53.318  32.544  1.00 36.51           C  
ATOM   5457  O   GLU F 107      88.988  54.177  31.663  1.00 34.72           O  
ATOM   5458  CB  GLU F 107      91.176  52.137  32.233  1.00 42.09           C  
ATOM   5459  CG  GLU F 107      91.952  50.867  31.913  1.00 46.59           C  
ATOM   5460  CD  GLU F 107      92.555  50.227  33.149  1.00 50.89           C  
ATOM   5461  OE1 GLU F 107      93.276  49.213  33.004  1.00 51.19           O  
ATOM   5462  OE2 GLU F 107      92.312  50.741  34.266  1.00 54.85           O  
ATOM   5463  N   VAL F 108      88.471  53.501  33.742  1.00 36.23           N  
ATOM   5464  CA  VAL F 108      87.837  54.767  34.097  1.00 36.95           C  
ATOM   5465  C   VAL F 108      88.622  55.420  35.229  1.00 38.69           C  
ATOM   5466  O   VAL F 108      89.567  54.835  35.753  1.00 39.00           O  
ATOM   5467  CB  VAL F 108      86.353  54.571  34.503  1.00 35.72           C  
ATOM   5468  CG1 VAL F 108      85.576  53.969  33.335  1.00 33.97           C  
ATOM   5469  CG2 VAL F 108      86.248  53.667  35.723  1.00 35.44           C  
ATOM   5470  N   SER F 109      88.232  56.630  35.609  1.00 41.27           N  
ATOM   5471  CA  SER F 109      88.941  57.370  36.650  1.00 42.26           C  
ATOM   5472  C   SER F 109      88.683  56.933  38.083  1.00 42.61           C  
ATOM   5473  O   SER F 109      89.595  56.936  38.910  1.00 42.98           O  
ATOM   5474  CB  SER F 109      88.628  58.863  36.524  1.00 44.06           C  
ATOM   5475  OG  SER F 109      89.176  59.399  35.333  1.00 46.29           O  
ATOM   5476  N   ARG F 110      87.445  56.570  38.380  1.00 43.08           N  
ATOM   5477  CA  ARG F 110      87.081  56.166  39.726  1.00 45.23           C  
ATOM   5478  C   ARG F 110      85.716  55.489  39.692  1.00 45.14           C  
ATOM   5479  O   ARG F 110      84.889  55.783  38.836  1.00 44.34           O  
ATOM   5480  CB  ARG F 110      87.040  57.402  40.636  1.00 47.26           C  
ATOM   5481  CG  ARG F 110      86.520  57.139  42.049  1.00 52.47           C  
ATOM   5482  CD  ARG F 110      86.395  58.430  42.866  1.00 55.42           C  
ATOM   5483  NE  ARG F 110      85.673  58.217  44.122  1.00 58.63           N  
ATOM   5484  CZ  ARG F 110      84.367  57.969  44.209  1.00 59.59           C  
ATOM   5485  NH1 ARG F 110      83.626  57.908  43.111  1.00 60.29           N  
ATOM   5486  NH2 ARG F 110      83.800  57.766  45.393  1.00 58.94           N  
ATOM   5487  N   LEU F 111      85.483  54.573  40.621  1.00 46.47           N  
ATOM   5488  CA  LEU F 111      84.208  53.881  40.674  1.00 47.54           C  
ATOM   5489  C   LEU F 111      83.554  54.178  42.010  1.00 49.71           C  
ATOM   5490  O   LEU F 111      84.216  54.638  42.938  1.00 50.25           O  
ATOM   5491  CB  LEU F 111      84.425  52.379  40.494  1.00 46.19           C  
ATOM   5492  CG  LEU F 111      84.964  52.029  39.105  1.00 45.08           C  
ATOM   5493  CD1 LEU F 111      85.447  50.595  39.070  1.00 44.97           C  
ATOM   5494  CD2 LEU F 111      83.873  52.263  38.074  1.00 42.42           C  
ATOM   5495  N   PRO F 112      82.240  53.933  42.122  1.00 51.04           N  
ATOM   5496  CA  PRO F 112      81.545  54.200  43.382  1.00 51.75           C  
ATOM   5497  C   PRO F 112      82.287  53.600  44.575  1.00 52.90           C  
ATOM   5498  O   PRO F 112      82.856  52.507  44.483  1.00 51.83           O  
ATOM   5499  CB  PRO F 112      80.174  53.560  43.162  1.00 52.38           C  
ATOM   5500  CG  PRO F 112      79.965  53.708  41.693  1.00 51.69           C  
ATOM   5501  CD  PRO F 112      81.323  53.331  41.137  1.00 51.57           C  
ATOM   5502  N   LYS F 113      82.283  54.328  45.689  1.00 54.83           N  
ATOM   5503  CA  LYS F 113      82.946  53.880  46.909  1.00 55.35           C  
ATOM   5504  C   LYS F 113      84.435  53.600  46.681  1.00 54.80           C  
ATOM   5505  O   LYS F 113      85.052  52.825  47.411  1.00 55.22           O  
ATOM   5506  CB  LYS F 113      82.234  52.629  47.438  1.00 55.38           C  
ATOM   5507  CG  LYS F 113      80.755  52.858  47.744  1.00 56.97           C  
ATOM   5508  CD  LYS F 113      80.093  51.613  48.332  1.00 58.04           C  
ATOM   5509  CE  LYS F 113      78.720  51.925  48.926  1.00 57.53           C  
ATOM   5510  NZ  LYS F 113      77.750  52.436  47.919  1.00 56.65           N  
ATOM   5511  N   ASP F 114      85.003  54.263  45.674  1.00 54.98           N  
ATOM   5512  CA  ASP F 114      86.408  54.099  45.295  1.00 54.16           C  
ATOM   5513  C   ASP F 114      86.763  52.619  45.309  1.00 53.13           C  
ATOM   5514  O   ASP F 114      87.434  52.121  46.216  1.00 53.44           O  
ATOM   5515  CB  ASP F 114      87.328  54.882  46.238  1.00 55.56           C  
ATOM   5516  CG  ASP F 114      88.720  55.080  45.660  1.00 57.69           C  
ATOM   5517  OD1 ASP F 114      89.485  54.095  45.581  1.00 58.99           O  
ATOM   5518  OD2 ASP F 114      89.048  56.222  45.270  1.00 59.50           O  
ATOM   5519  N   VAL F 115      86.285  51.926  44.283  1.00 50.84           N  
ATOM   5520  CA  VAL F 115      86.493  50.496  44.114  1.00 47.16           C  
ATOM   5521  C   VAL F 115      87.351  50.246  42.870  1.00 44.73           C  
ATOM   5522  O   VAL F 115      87.391  51.074  41.967  1.00 45.44           O  
ATOM   5523  CB  VAL F 115      85.115  49.793  43.995  1.00 46.64           C  
ATOM   5524  CG1 VAL F 115      85.195  48.600  43.079  1.00 48.78           C  
ATOM   5525  CG2 VAL F 115      84.637  49.373  45.364  1.00 44.15           C  
ATOM   5526  N   LEU F 116      88.033  49.109  42.826  1.00 42.40           N  
ATOM   5527  CA  LEU F 116      88.897  48.772  41.696  1.00 41.51           C  
ATOM   5528  C   LEU F 116      88.199  48.201  40.461  1.00 40.80           C  
ATOM   5529  O   LEU F 116      88.820  48.073  39.401  1.00 40.11           O  
ATOM   5530  CB  LEU F 116      89.953  47.759  42.133  1.00 41.77           C  
ATOM   5531  CG  LEU F 116      91.040  48.139  43.131  1.00 41.84           C  
ATOM   5532  CD1 LEU F 116      91.748  46.860  43.561  1.00 41.61           C  
ATOM   5533  CD2 LEU F 116      92.023  49.124  42.498  1.00 41.89           C  
ATOM   5534  N   ILE F 117      86.924  47.847  40.586  1.00 39.38           N  
ATOM   5535  CA  ILE F 117      86.222  47.258  39.456  1.00 39.85           C  
ATOM   5536  C   ILE F 117      84.704  47.180  39.613  1.00 39.61           C  
ATOM   5537  O   ILE F 117      84.183  46.942  40.703  1.00 39.04           O  
ATOM   5538  CB  ILE F 117      86.759  45.821  39.182  1.00 41.35           C  
ATOM   5539  CG1 ILE F 117      86.070  45.212  37.960  1.00 40.33           C  
ATOM   5540  CG2 ILE F 117      86.523  44.928  40.412  1.00 40.96           C  
ATOM   5541  CD1 ILE F 117      86.521  43.791  37.664  1.00 41.07           C  
ATOM   5542  N   GLU F 118      84.007  47.391  38.502  1.00 38.56           N  
ATOM   5543  CA  GLU F 118      82.555  47.316  38.455  1.00 38.67           C  
ATOM   5544  C   GLU F 118      82.205  46.586  37.156  1.00 37.64           C  
ATOM   5545  O   GLU F 118      82.840  46.796  36.116  1.00 35.40           O  
ATOM   5546  CB  GLU F 118      81.929  48.722  38.460  1.00 40.14           C  
ATOM   5547  CG  GLU F 118      80.418  48.749  38.165  1.00 42.19           C  
ATOM   5548  CD  GLU F 118      79.823  50.164  38.166  1.00 43.75           C  
ATOM   5549  OE1 GLU F 118      80.485  51.094  37.662  1.00 43.74           O  
ATOM   5550  OE2 GLU F 118      78.685  50.349  38.660  1.00 43.76           O  
ATOM   5551  N   ILE F 119      81.209  45.710  37.217  1.00 34.83           N  
ATOM   5552  CA  ILE F 119      80.819  44.977  36.028  1.00 32.60           C  
ATOM   5553  C   ILE F 119      79.310  44.921  35.842  1.00 31.76           C  
ATOM   5554  O   ILE F 119      78.564  44.707  36.793  1.00 31.57           O  
ATOM   5555  CB  ILE F 119      81.384  43.536  36.053  1.00 31.33           C  
ATOM   5556  CG1 ILE F 119      82.918  43.577  36.086  1.00 30.41           C  
ATOM   5557  CG2 ILE F 119      80.915  42.781  34.832  1.00 29.66           C  
ATOM   5558  CD1 ILE F 119      83.590  42.204  36.165  1.00 28.44           C  
ATOM   5559  N   GLU F 120      78.876  45.148  34.607  1.00 31.74           N  
ATOM   5560  CA  GLU F 120      77.463  45.095  34.244  1.00 31.92           C  
ATOM   5561  C   GLU F 120      77.326  43.969  33.225  1.00 29.16           C  
ATOM   5562  O   GLU F 120      78.263  43.673  32.485  1.00 27.97           O  
ATOM   5563  CB  GLU F 120      76.999  46.415  33.621  1.00 35.32           C  
ATOM   5564  CG  GLU F 120      77.822  46.863  32.421  1.00 41.89           C  
ATOM   5565  CD  GLU F 120      77.126  47.929  31.584  1.00 45.91           C  
ATOM   5566  OE1 GLU F 120      77.804  48.578  30.750  1.00 46.48           O  
ATOM   5567  OE2 GLU F 120      75.898  48.106  31.751  1.00 47.83           O  
ATOM   5568  N   ALA F 121      76.163  43.331  33.196  1.00 27.91           N  
ATOM   5569  CA  ALA F 121      75.946  42.229  32.272  1.00 25.39           C  
ATOM   5570  C   ALA F 121      74.535  42.213  31.708  1.00 25.01           C  
ATOM   5571  O   ALA F 121      73.630  42.895  32.204  1.00 23.30           O  
ATOM   5572  CB  ALA F 121      76.241  40.911  32.961  1.00 24.13           C  
ATOM   5573  N   ILE F 122      74.374  41.431  30.648  1.00 23.64           N  
ATOM   5574  CA  ILE F 122      73.103  41.273  29.974  1.00 23.57           C  
ATOM   5575  C   ILE F 122      72.992  39.798  29.687  1.00 23.38           C  
ATOM   5576  O   ILE F 122      73.985  39.158  29.363  1.00 24.86           O  
ATOM   5577  CB  ILE F 122      73.062  42.069  28.650  1.00 24.01           C  
ATOM   5578  CG1 ILE F 122      73.142  43.569  28.947  1.00 24.23           C  
ATOM   5579  CG2 ILE F 122      71.771  41.774  27.891  1.00 26.62           C  
ATOM   5580  CD1 ILE F 122      73.075  44.440  27.705  1.00 25.71           C  
ATOM   5581  N   ALA F 123      71.789  39.252  29.827  1.00 24.34           N  
ATOM   5582  CA  ALA F 123      71.565  37.835  29.582  1.00 23.75           C  
ATOM   5583  C   ALA F 123      70.285  37.601  28.800  1.00 25.46           C  
ATOM   5584  O   ALA F 123      69.338  38.393  28.850  1.00 23.65           O  
ATOM   5585  CB  ALA F 123      71.511  37.078  30.903  1.00 23.79           C  
ATOM   5586  N   TYR F 124      70.273  36.488  28.084  1.00 28.18           N  
ATOM   5587  CA  TYR F 124      69.144  36.094  27.272  1.00 31.48           C  
ATOM   5588  C   TYR F 124      68.775  34.677  27.667  1.00 35.04           C  
ATOM   5589  O   TYR F 124      69.647  33.866  27.965  1.00 36.79           O  
ATOM   5590  CB  TYR F 124      69.535  36.146  25.800  1.00 30.41           C  
ATOM   5591  CG  TYR F 124      68.448  35.703  24.859  1.00 33.33           C  
ATOM   5592  CD1 TYR F 124      67.349  36.515  24.599  1.00 34.26           C  
ATOM   5593  CD2 TYR F 124      68.521  34.467  24.221  1.00 35.33           C  
ATOM   5594  CE1 TYR F 124      66.355  36.108  23.724  1.00 37.73           C  
ATOM   5595  CE2 TYR F 124      67.534  34.048  23.349  1.00 37.49           C  
ATOM   5596  CZ  TYR F 124      66.454  34.872  23.102  1.00 38.96           C  
ATOM   5597  OH  TYR F 124      65.480  34.459  22.228  1.00 41.95           O  
ATOM   5598  N   LYS F 125      67.480  34.391  27.686  1.00 40.06           N  
ATOM   5599  CA  LYS F 125      66.974  33.068  28.039  1.00 44.42           C  
ATOM   5600  C   LYS F 125      65.779  32.830  27.136  1.00 46.78           C  
ATOM   5601  O   LYS F 125      64.843  33.631  27.123  1.00 47.02           O  
ATOM   5602  CB  LYS F 125      66.528  33.036  29.506  1.00 46.88           C  
ATOM   5603  CG  LYS F 125      66.186  31.648  30.042  1.00 49.51           C  
ATOM   5604  CD  LYS F 125      65.632  31.711  31.472  1.00 50.45           C  
ATOM   5605  CE  LYS F 125      64.301  32.471  31.520  1.00 52.24           C  
ATOM   5606  NZ  LYS F 125      63.688  32.501  32.884  1.00 51.85           N  
ATOM   5607  N   GLU F 126      65.824  31.738  26.378  1.00 49.39           N  
ATOM   5608  CA  GLU F 126      64.753  31.383  25.449  1.00 52.04           C  
ATOM   5609  C   GLU F 126      63.370  31.384  26.116  1.00 53.89           C  
ATOM   5610  O   GLU F 126      63.295  31.319  27.364  1.00 53.89           O  
ATOM   5611  CB  GLU F 126      65.019  29.995  24.854  1.00 54.41           C  
ATOM   5612  CG  GLU F 126      66.323  29.837  24.054  1.00 57.26           C  
ATOM   5613  CD  GLU F 126      67.592  30.063  24.882  1.00 58.62           C  
ATOM   5614  OE1 GLU F 126      67.620  29.678  26.079  1.00 57.60           O  
ATOM   5615  OE2 GLU F 126      68.567  30.617  24.320  1.00 57.95           O  
ATOM   5616  OXT GLU F 126      62.365  31.430  25.374  1.00 55.83           O  
TER    5617      GLU F 126                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
