
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  127 (  947),  selected  127 , name 1qu9_A
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 1qu9_A.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      M       1           -
LGA    K     3_A      S       2           -
LGA    T     4_A      D       3           -
LGA    I     5_A      V       4           -
LGA    A     6_A      I       5           -
LGA    T     7_A      E       6           -
LGA    -       -      G       7           -
LGA    -       -      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    E     8_A      P      17           #
LGA    N     9_A      V      18          2.425
LGA    A    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    A    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    I    14_A      A      23          4.891
LGA    G    15_A      A      24          4.476
LGA    P    16_A      N      25          2.996
LGA    Y    17_A      Y      26          1.327
LGA    V    18_A      V      27          0.871
LGA    Q    19_A      P      28          0.693
LGA    G    20_A      F      29          0.375
LGA    V    21_A      T      30          1.005
LGA    D    22_A      I      31          2.209
LGA    L    23_A      S      32          2.310
LGA    G    24_A      G      33          3.282
LGA    N    25_A      N      34          0.874
LGA    M    26_A      L      35          1.066
LGA    I    27_A      L      36          0.678
LGA    I    28_A      Y      37          0.455
LGA    T    29_A      V      38          0.720
LGA    S    30_A      S      39          0.658
LGA    G    31_A      G      40          0.734
LGA    Q    32_A      Q      41          0.659
LGA    I    33_A      L      42          0.981
LGA    P    34_A      P      43          1.029
LGA    V    35_A      M      44          1.693
LGA    N    36_A      E      45          2.281
LGA    P    37_A      -       -           -
LGA    K    38_A      -       -           -
LGA    T    39_A      S      46          2.490
LGA    G    40_A      G      47          1.604
LGA    E    41_A      K      48          1.289
LGA    V    42_A      I      49          1.937
LGA    P    43_A      A      50          1.934
LGA    A    44_A      V      51          2.956
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    -       -      V      59           -
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    45_A      S      63          2.609
LGA    V    46_A      A      64          1.275
LGA    A    47_A      Q      65          1.766
LGA    A    48_A      R      66          1.688
LGA    Q    49_A      A      67          0.924
LGA    A    50_A      A      68          0.506
LGA    R    51_A      E      69          0.827
LGA    Q    52_A      L      70          0.878
LGA    S    53_A      C      71          0.493
LGA    L    54_A      A      72          0.436
LGA    D    55_A      V      73          0.625
LGA    N    56_A      N      74          0.792
LGA    V    57_A      I      75          0.754
LGA    K    58_A      L      76          0.912
LGA    A    59_A      A      77          1.192
LGA    I    60_A      Q      78          1.359
LGA    V    61_A      V      79          1.539
LGA    E    62_A      K      80          2.100
LGA    A    63_A      A      81          2.062
LGA    A    64_A      A      82          2.415
LGA    G    65_A      L      83          2.451
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    -       -      K      89           -
LGA    L    66_A      I      90          2.775
LGA    K    67_A      R      91           #
LGA    V    68_A      -       -           -
LGA    G    69_A      -       -           -
LGA    D    70_A      R      92          2.039
LGA    I    71_A      V      93          1.259
LGA    V    72_A      I      94          0.280
LGA    K    73_A      K      95          1.111
LGA    T    74_A      L      96          1.563
LGA    T    75_A      N      97          1.155
LGA    V    76_A      G      98          1.080
LGA    F    77_A      F      99          1.141
LGA    V    78_A      V     100          1.064
LGA    K    79_A      A     101          0.769
LGA    D    80_A      S     102          1.832
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    L    81_A      F     106          4.495
LGA    N    82_A      V     107          3.621
LGA    D    83_A      E     108          4.609
LGA    F    84_A      Q     109          2.406
LGA    A    85_A      H     110          5.161
LGA    T    86_A      L     111          3.931
LGA    V    87_A      V     112          1.481
LGA    N    88_A      I     113          3.758
LGA    A    89_A      N     114          3.448
LGA    T    90_A      G     115          1.473
LGA    Y    91_A      A     116          2.611
LGA    E    92_A      S     117          3.494
LGA    A    93_A      N     118          2.039
LGA    F    94_A      L     119          0.831
LGA    F    95_A      I     120          2.734
LGA    T    96_A      A     121          2.845
LGA    E    97_A      T     122          1.231
LGA    H    98_A      V     123          2.224
LGA    -       -      L     124           -
LGA    N    99_A      G     125          0.569
LGA    A   100_A      E     126          3.138
LGA    T   101_A      P     127          4.384
LGA    -       -      G     128           -
LGA    F   102_A      R     129          1.882
LGA    P   103_A      H     130          1.124
LGA    A   104_A      A     131          1.189
LGA    R   105_A      R     132          1.336
LGA    S   106_A      A     133          1.815
LGA    X   107_A      A     134          2.052
LGA    V   108_A      V     135          1.607
LGA    E   109_A      G     136          1.106
LGA    V   110_A      M     137          1.564
LGA    A   111_A      A     138          1.323
LGA    R   112_A      S     139          1.325
LGA    L   113_A      L     140          0.652
LGA    P   114_A      P     141          0.347
LGA    K   115_A      F     142          0.495
LGA    D   116_A      N     143          0.823
LGA    V   117_A      A     144          0.692
LGA    K   118_A      S     145          1.087
LGA    I   119_A      V     146          0.983
LGA    E   120_A      E     147          0.877
LGA    I   121_A      I     148          0.815
LGA    E   122_A      D     149          0.841
LGA    A   123_A      A     150          0.576
LGA    I   124_A      I     151          0.636
LGA    A   125_A      V     152          0.891
LGA    V   126_A      E     153          1.167
LGA    R   127_A      I     154          2.270
LGA    R   128_A      D     155           #
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  127  152    5.0    110    2.01    26.36     63.872     5.211

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.461666 * X  +   0.014228 * Y  +  -0.886940 * Z  + 150.896332
  Y_new =   0.154654 * X  +  -0.983267 * Y  +  -0.096273 * Z  + 102.484810
  Z_new =  -0.873468 * X  +  -0.181615 * Y  +   0.451741 * Z  +  61.813290 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.382259    2.759334  [ DEG:   -21.9018    158.0982 ]
  Theta =   1.062280    2.079312  [ DEG:    60.8642    119.1358 ]
  Phi   =   2.818350   -0.323243  [ DEG:   161.4796    -18.5204 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1qu9_A                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1qu9_A.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  127  152   5.0  110   2.01   26.36  63.872
REMARK  ---------------------------------------------------------- 
MOLECULE 1qu9_A
HEADER    STRUCTURAL GENOMICS                     07-JUL-99   1QU9              
TITLE     1.2 A CRYSTAL STRUCTURE OF YJGF GENE PRODUCT FROM E. COLI             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: YJGF PROTEIN;                                              
COMPND   3 CHAIN: A, B, C                                                       
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA                                            
KEYWDS    STRUCTURAL GENOMICS                                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.VOLZ                                                                
REVDAT   1   01-DEC-99 1QU9    0                                                
JRNL        AUTH   K.VOLZ                                                       
JRNL        TITL   A TEST CASE FOR STRUCTURE-BASED FUNCTIONAL                   
JRNL        TITL 2 ASSIGNMENT: THE 1.2 A CRYSTAL STRUCTURE OF THE               
JRNL        TITL 3 YJGF GENE PRODUCT FROM ESCHERICHIA COLI                      
JRNL        REF    PROTEIN SCI.                  V.   8  2428 1999              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 1.20 ANGSTROMS.                                          
DBREF  1QU9 A    2   128  UNP    P39330   YJGF_ECOLI       1    127             
DBREF  1QU9 B    2   128  UNP    P39330   YJGF_ECOLI       1    127             
DBREF  1QU9 C    2   128  UNP    P39330   YJGF_ECOLI       1    127             
SEQRES   1 A  128  MET SER LYS THR ILE ALA THR GLU ASN ALA PRO ALA ALA          
SEQRES   2 A  128  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY ASN MET          
SEQRES   3 A  128  ILE ILE THR SER GLY GLN ILE PRO VAL ASN PRO LYS THR          
SEQRES   4 A  128  GLY GLU VAL PRO ALA ASP VAL ALA ALA GLN ALA ARG GLN          
SEQRES   5 A  128  SER LEU ASP ASN VAL LYS ALA ILE VAL GLU ALA ALA GLY          
SEQRES   6 A  128  LEU LYS VAL GLY ASP ILE VAL LYS THR THR VAL PHE VAL          
SEQRES   7 A  128  LYS ASP LEU ASN ASP PHE ALA THR VAL ASN ALA THR TYR          
SEQRES   8 A  128  GLU ALA PHE PHE THR GLU HIS ASN ALA THR PHE PRO ALA          
SEQRES   9 A  128  ARG SER CSP VAL GLU VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 A  128  LYS ILE GLU ILE GLU ALA ILE ALA VAL ARG ARG                  
SEQRES   1 B  128  MET SER LYS THR ILE ALA THR GLU ASN ALA PRO ALA ALA          
SEQRES   2 B  128  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY ASN MET          
SEQRES   3 B  128  ILE ILE THR SER GLY GLN ILE PRO VAL ASN PRO LYS THR          
SEQRES   4 B  128  GLY GLU VAL PRO ALA ASP VAL ALA ALA GLN ALA ARG GLN          
SEQRES   5 B  128  SER LEU ASP ASN VAL LYS ALA ILE VAL GLU ALA ALA GLY          
SEQRES   6 B  128  LEU LYS VAL GLY ASP ILE VAL LYS THR THR VAL PHE VAL          
SEQRES   7 B  128  LYS ASP LEU ASN ASP PHE ALA THR VAL ASN ALA THR TYR          
SEQRES   8 B  128  GLU ALA PHE PHE THR GLU HIS ASN ALA THR PHE PRO ALA          
SEQRES   9 B  128  ARG SER CSP VAL GLU VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 B  128  LYS ILE GLU ILE GLU ALA ILE ALA VAL ARG ARG                  
SEQRES   1 C  128  MET SER LYS THR ILE ALA THR GLU ASN ALA PRO ALA ALA          
SEQRES   2 C  128  ILE GLY PRO TYR VAL GLN GLY VAL ASP LEU GLY ASN MET          
SEQRES   3 C  128  ILE ILE THR SER GLY GLN ILE PRO VAL ASN PRO LYS THR          
SEQRES   4 C  128  GLY GLU VAL PRO ALA ASP VAL ALA ALA GLN ALA ARG GLN          
SEQRES   5 C  128  SER LEU ASP ASN VAL LYS ALA ILE VAL GLU ALA ALA GLY          
SEQRES   6 C  128  LEU LYS VAL GLY ASP ILE VAL LYS THR THR VAL PHE VAL          
SEQRES   7 C  128  LYS ASP LEU ASN ASP PHE ALA THR VAL ASN ALA THR TYR          
SEQRES   8 C  128  GLU ALA PHE PHE THR GLU HIS ASN ALA THR PHE PRO ALA          
SEQRES   9 C  128  ARG SER CSP VAL GLU VAL ALA ARG LEU PRO LYS ASP VAL          
SEQRES  10 C  128  LYS ILE GLU ILE GLU ALA ILE ALA VAL ARG ARG                  
HET    CSP  A 107      12                                                       
HET    CSP  B 107      12                                                       
HET    CSP  C 107      12                                                       
HETNAM     CSP S-PHOSPHOCYSTEINE                                                
FORMUL   1  CSP    3(C3 H8 N O5 P S)                                            
FORMUL   4  HOH   *474(H2 O)                                                    
CRYST1   72.220   72.220   72.220  90.00  90.00  90.00 P 2 2 2      12          
ATOM      1  N   SER A   2      57.368  43.389  32.450  1.00 16.24           N  
ATOM      2  CA  SER A   2      58.740  43.421  33.038  1.00 15.30           C  
ATOM      3  C   SER A   2      58.644  43.450  34.570  1.00 13.90           C  
ATOM      4  O   SER A   2      57.634  43.928  35.140  1.00 15.02           O  
ATOM      5  CB  SER A   2      59.580  44.556  32.508  1.00 16.11           C  
ATOM      6  OG  SER A   2      59.224  45.811  33.067  1.00 18.37           O  
ATOM      7  N   LYS A   3      59.697  42.930  35.197  1.00 12.13           N  
ATOM      8  CA  LYS A   3      59.689  42.876  36.665  1.00 11.35           C  
ATOM      9  C   LYS A   3      61.080  43.055  37.247  1.00  8.65           C  
ATOM     10  O   LYS A   3      62.138  42.819  36.655  1.00  7.83           O  
ATOM     11  CB  LYS A   3      59.076  41.549  37.151  1.00 13.69           C  
ATOM     12  CG  LYS A   3      59.966  40.378  36.817  1.00 15.79           C  
ATOM     13  CD  LYS A   3      59.401  38.988  37.043  1.00 17.79           C  
ATOM     14  CE  LYS A   3      58.417  38.586  35.964  1.00 18.86           C  
ATOM     15  NZ  LYS A   3      58.080  37.126  36.027  1.00 20.35           N  
ATOM     16  N   THR A   4      61.042  43.503  38.489  1.00  7.14           N  
ATOM     17  CA  THR A   4      62.278  43.676  39.249  1.00  6.44           C  
ATOM     18  C   THR A   4      62.860  42.311  39.633  1.00  5.57           C  
ATOM     19  O   THR A   4      62.092  41.364  39.980  1.00  6.47           O  
ATOM     20  CB  THR A   4      61.901  44.384  40.612  1.00  7.10           C  
ATOM     21  OG1 THR A   4      61.485  45.729  40.268  1.00  8.40           O  
ATOM     22  CG2 THR A   4      63.052  44.404  41.622  1.00  7.78           C  
ATOM     23  N   ILE A   5      64.177  42.220  39.603  1.00  4.90           N  
ATOM     24  CA  ILE A   5      64.898  41.057  40.133  1.00  5.03           C  
ATOM     25  C   ILE A   5      65.431  41.535  41.513  1.00  5.26           C  
ATOM     26  O   ILE A   5      66.075  42.569  41.615  1.00  5.95           O  
ATOM     27  CB  ILE A   5      66.071  40.594  39.242  1.00  5.22           C  
ATOM     28  CG1 ILE A   5      65.591  40.262  37.814  1.00  5.41           C  
ATOM     29  CG2 ILE A   5      66.827  39.412  39.893  1.00  6.47           C  
ATOM     30  CD1 ILE A   5      66.753  40.109  36.797  1.00  4.98           C  
ATOM     31  N   ALA A   6      65.092  40.742  42.537  1.00  5.80           N  
ATOM     32  CA  ALA A   6      65.524  41.065  43.915  1.00  7.32           C  
ATOM     33  C   ALA A   6      65.964  39.760  44.568  1.00  7.57           C  
ATOM     34  O   ALA A   6      65.186  38.794  44.685  1.00 10.07           O  
ATOM     35  CB  ALA A   6      64.425  41.764  44.697  1.00  8.24           C  
ATOM     36  N   THR A   7      67.239  39.700  44.922  1.00  6.19           N  
ATOM     37  CA  THR A   7      67.828  38.508  45.533  1.00  6.55           C  
ATOM     38  C   THR A   7      68.722  38.848  46.712  1.00  5.76           C  
ATOM     39  O   THR A   7      69.412  39.854  46.686  1.00  6.20           O  
ATOM     40  CB  THR A   7      68.659  37.722  44.449  1.00  7.01           C  
ATOM     41  OG1 THR A   7      69.277  36.622  45.170  1.00  7.16           O  
ATOM     42  CG2 THR A   7      69.734  38.530  43.743  1.00  7.30           C  
ATOM     43  N   GLU A   8      68.645  38.035  47.758  1.00  6.37           N  
ATOM     44  CA  GLU A   8      69.492  38.215  48.930  1.00  6.48           C  
ATOM     45  C   GLU A   8      70.929  37.869  48.565  1.00  6.14           C  
ATOM     46  O   GLU A   8      71.855  38.212  49.323  1.00  6.07           O  
ATOM     47  CB  GLU A   8      69.072  37.323  50.108  1.00  7.91           C  
ATOM     48  CG  GLU A   8      69.247  35.817  49.978  1.00  9.70           C  
ATOM     49  CD  GLU A   8      68.257  35.091  49.122  1.00 11.36           C  
ATOM     50  OE1 GLU A   8      67.537  35.657  48.294  1.00 12.18           O  
ATOM     51  OE2 GLU A   8      68.225  33.831  49.289  1.00 13.35           O  
ATOM     52  N   ASN A   9      71.139  37.194  47.431  1.00  6.75           N  
ATOM     53  CA  ASN A   9      72.469  36.737  47.013  1.00  7.05           C  
ATOM     54  C   ASN A   9      73.377  37.789  46.409  1.00  7.06           C  
ATOM     55  O   ASN A   9      74.533  37.491  46.064  1.00  6.95           O  
ATOM     56  CB  ASN A   9      72.365  35.504  46.136  1.00  7.91           C  
ATOM     57  CG  ASN A   9      71.737  34.353  46.905  1.00  9.05           C  
ATOM     58  OD1 ASN A   9      72.033  34.195  48.111  1.00 10.43           O  
ATOM     59  ND2 ASN A   9      70.893  33.616  46.222  1.00  9.59           N  
ATOM     60  N   ALA A  10      72.883  39.009  46.198  1.00  5.82           N  
ATOM     61  CA  ALA A  10      73.695  40.138  45.705  1.00  5.77           C  
ATOM     62  C   ALA A  10      73.427  41.261  46.738  1.00  6.13           C  
ATOM     63  O   ALA A  10      72.417  41.209  47.439  1.00  5.80           O  
ATOM     64  CB  ALA A  10      73.328  40.589  44.310  1.00  6.12           C  
ATOM     65  N   PRO A  11      74.328  42.223  46.818  1.00  6.62           N  
ATOM     66  CA  PRO A  11      74.141  43.328  47.766  1.00  6.86           C  
ATOM     67  C   PRO A  11      72.802  43.987  47.588  1.00  6.78           C  
ATOM     68  O   PRO A  11      72.377  44.262  46.432  1.00  6.19           O  
ATOM     69  CB  PRO A  11      75.258  44.297  47.431  1.00  7.77           C  
ATOM     70  CG  PRO A  11      76.304  43.501  46.704  1.00  8.11           C  
ATOM     71  CD  PRO A  11      75.561  42.356  46.026  1.00  7.42           C  
ATOM     72  N   ALA A  12      72.135  44.306  48.686  1.00  8.21           N  
ATOM     73  CA  ALA A  12      70.811  44.937  48.648  1.00  9.55           C  
ATOM     74  C   ALA A  12      70.901  46.295  47.952  1.00 10.63           C  
ATOM     75  O   ALA A  12      71.895  47.021  48.063  1.00  9.79           O  
ATOM     76  CB  ALA A  12      70.315  45.167  50.076  1.00 10.50           C  
ATOM     77  N   ALA A  13      69.838  46.578  47.223  1.00 11.95           N  
ATOM     78  CA  ALA A  13      69.692  47.838  46.476  1.00 14.35           C  
ATOM     79  C   ALA A  13      69.123  48.874  47.451  1.00 15.86           C  
ATOM     80  O   ALA A  13      67.890  48.911  47.605  1.00 17.22           O  
ATOM     81  CB  ALA A  13      68.777  47.675  45.274  1.00 14.52           C  
ATOM     82  N   ILE A  14      70.046  49.619  48.027  1.00 16.89           N  
ATOM     83  CA  ILE A  14      69.637  50.669  48.991  1.00 18.21           C  
ATOM     84  C   ILE A  14      69.258  51.956  48.262  1.00 18.11           C  
ATOM     85  O   ILE A  14      68.126  52.466  48.511  1.00 19.37           O  
ATOM     86  CB  ILE A  14      70.714  50.797  50.107  1.00 19.06           C  
ATOM     87  CG1 ILE A  14      70.933  49.401  50.771  1.00 19.75           C  
ATOM     88  CG2 ILE A  14      70.374  51.849  51.198  1.00 19.75           C  
ATOM     89  CD1 ILE A  14      72.194  49.412  51.686  1.00 20.29           C  
ATOM     90  N   GLY A  15      70.106  52.448  47.383  1.00 17.28           N  
ATOM     91  CA  GLY A  15      69.777  53.684  46.621  1.00 15.10           C  
ATOM     92  C   GLY A  15      68.557  53.489  45.713  1.00 13.16           C  
ATOM     93  O   GLY A  15      67.825  52.484  45.743  1.00 14.07           O  
ATOM     94  N   PRO A  16      68.348  54.503  44.867  1.00 11.29           N  
ATOM     95  CA  PRO A  16      67.230  54.527  43.925  1.00  9.14           C  
ATOM     96  C   PRO A  16      67.499  53.693  42.686  1.00  8.00           C  
ATOM     97  O   PRO A  16      67.586  54.228  41.571  1.00  6.68           O  
ATOM     98  CB  PRO A  16      67.059  56.023  43.651  1.00  9.25           C  
ATOM     99  CG  PRO A  16      68.490  56.523  43.627  1.00  9.12           C  
ATOM    100  CD  PRO A  16      69.145  55.759  44.780  1.00 10.61           C  
ATOM    101  N   TYR A  17      67.595  52.386  42.890  1.00  6.92           N  
ATOM    102  CA  TYR A  17      67.811  51.445  41.773  1.00  6.14           C  
ATOM    103  C   TYR A  17      67.354  50.074  42.241  1.00  5.54           C  
ATOM    104  O   TYR A  17      67.130  49.883  43.460  1.00  7.15           O  
ATOM    105  CB  TYR A  17      69.302  51.417  41.342  1.00  6.78           C  
ATOM    106  CG  TYR A  17      70.230  50.956  42.451  1.00  7.73           C  
ATOM    107  CD1 TYR A  17      70.629  49.607  42.527  1.00  8.18           C  
ATOM    108  CD2 TYR A  17      70.682  51.797  43.465  1.00  8.87           C  
ATOM    109  CE1 TYR A  17      71.477  49.138  43.529  1.00  9.51           C  
ATOM    110  CE2 TYR A  17      71.522  51.337  44.487  1.00 10.50           C  
ATOM    111  CZ  TYR A  17      71.901  50.012  44.516  1.00 10.45           C  
ATOM    112  OH  TYR A  17      72.724  49.540  45.516  1.00 12.81           O  
ATOM    113  N   VAL A  18      67.212  49.149  41.321  1.00  5.53           N  
ATOM    114  CA  VAL A  18      66.935  47.740  41.618  1.00  5.01           C  
ATOM    115  C   VAL A  18      68.184  46.990  41.144  1.00  5.01           C  
ATOM    116  O   VAL A  18      68.947  47.481  40.307  1.00  5.04           O  
ATOM    117  CB  VAL A  18      65.662  47.201  40.983  1.00  5.59           C  
ATOM    118  CG1 VAL A  18      64.467  47.891  41.632  1.00  6.33           C  
ATOM    119  CG2 VAL A  18      65.650  47.316  39.467  1.00  6.00           C  
ATOM    120  N   GLN A  19      68.363  45.780  41.650  1.00  4.48           N  
ATOM    121  CA  GLN A  19      69.517  44.950  41.288  1.00  4.00           C  
ATOM    122  C   GLN A  19      69.525  44.580  39.806  1.00  3.80           C  
ATOM    123  O   GLN A  19      70.588  44.444  39.193  1.00  3.75           O  
ATOM    124  CB  GLN A  19      69.567  43.656  42.105  1.00  5.03           C  
ATOM    125  CG  GLN A  19      69.769  43.916  43.594  1.00  5.44           C  
ATOM    126  CD  GLN A  19      69.532  42.656  44.375  1.00  5.87           C  
ATOM    127  OE1 GLN A  19      68.614  41.903  44.054  1.00  7.44           O  
ATOM    128  NE2 GLN A  19      70.318  42.413  45.430  1.00  6.86           N  
ATOM    129  N   GLY A  20      68.340  44.334  39.253  1.00  4.08           N  
ATOM    130  CA  GLY A  20      68.267  43.957  37.819  1.00  3.84           C  
ATOM    131  C   GLY A  20      66.810  43.945  37.416  1.00  3.63           C  
ATOM    132  O   GLY A  20      65.911  44.059  38.270  1.00  3.92           O  
ATOM    133  N   VAL A  21      66.586  43.795  36.116  1.00  3.33           N  
ATOM    134  CA  VAL A  21      65.242  43.738  35.560  1.00  3.95           C  
ATOM    135  C   VAL A  21      65.127  42.518  34.652  1.00  3.79           C  
ATOM    136  O   VAL A  21      66.051  42.192  33.903  1.00  4.94           O  
ATOM    137  CB  VAL A  21      64.885  45.042  34.822  1.00  3.78           C  
ATOM    138  CG1 VAL A  21      64.751  46.171  35.833  1.00  4.83           C  
ATOM    139  CG2 VAL A  21      65.930  45.366  33.769  1.00  4.51           C  
ATOM    140  N   ASP A  22      63.972  41.890  34.745  1.00  4.14           N  
ATOM    141  CA  ASP A  22      63.628  40.709  33.922  1.00  4.70           C  
ATOM    142  C   ASP A  22      62.609  41.239  32.916  1.00  4.45           C  
ATOM    143  O   ASP A  22      61.460  41.531  33.306  1.00  5.58           O  
ATOM    144  CB  ASP A  22      63.103  39.585  34.801  1.00  6.22           C  
ATOM    145  CG  ASP A  22      62.575  38.387  34.057  1.00  7.08           C  
ATOM    146  OD1 ASP A  22      62.324  37.358  34.746  1.00  8.97           O  
ATOM    147  OD2 ASP A  22      62.409  38.439  32.846  1.00  7.76           O  
ATOM    148  N   LEU A  23      62.979  41.382  31.666  1.00  4.71           N  
ATOM    149  CA  LEU A  23      62.124  41.909  30.609  1.00  5.58           C  
ATOM    150  C   LEU A  23      61.425  40.847  29.790  1.00  6.38           C  
ATOM    151  O   LEU A  23      60.801  41.196  28.768  1.00  8.55           O  
ATOM    152  CB  LEU A  23      63.002  42.799  29.693  1.00  5.54           C  
ATOM    153  CG  LEU A  23      63.860  43.808  30.444  1.00  6.24           C  
ATOM    154  CD1 LEU A  23      64.626  44.661  29.422  1.00  6.77           C  
ATOM    155  CD2 LEU A  23      63.043  44.752  31.327  1.00  6.93           C  
ATOM    156  N   GLY A  24      61.517  39.619  30.186  1.00  6.72           N  
ATOM    157  CA  GLY A  24      60.921  38.491  29.438  1.00  7.67           C  
ATOM    158  C   GLY A  24      62.145  37.716  28.898  1.00  7.60           C  
ATOM    159  O   GLY A  24      62.813  37.028  29.691  1.00  8.31           O  
ATOM    160  N   ASN A  25      62.427  37.878  27.637  1.00  7.01           N  
ATOM    161  CA  ASN A  25      63.597  37.154  27.096  1.00  7.87           C  
ATOM    162  C   ASN A  25      64.903  37.769  27.607  1.00  7.17           C  
ATOM    163  O   ASN A  25      65.874  37.030  27.856  1.00  7.79           O  
ATOM    164  CB  ASN A  25      63.592  37.226  25.568  1.00  9.22           C  
ATOM    165  CG  ASN A  25      64.769  36.449  24.990  1.00 10.32           C  
ATOM    166  OD1 ASN A  25      64.956  35.263  25.298  1.00 12.32           O  
ATOM    167  ND2 ASN A  25      65.568  37.145  24.171  1.00 11.31           N  
ATOM    168  N   MET A  26      64.994  39.066  27.759  1.00  6.21           N  
ATOM    169  CA  MET A  26      66.221  39.740  28.180  1.00  5.60           C  
ATOM    170  C   MET A  26      66.208  40.142  29.643  1.00  5.14           C  
ATOM    171  O   MET A  26      65.200  40.681  30.148  1.00  5.60           O  
ATOM    172  CB  MET A  26      66.374  41.004  27.302  1.00  6.37           C  
ATOM    173  CG  MET A  26      67.688  41.675  27.603  1.00  7.10           C  
ATOM    174  SD  MET A  26      68.038  43.017  26.442  1.00  8.83           S  
ATOM    175  CE  MET A  26      68.580  42.054  24.994  1.00  9.98           C  
ATOM    176  N   ILE A  27      67.329  39.894  30.290  1.00  4.19           N  
ATOM    177  CA  ILE A  27      67.577  40.293  31.675  1.00  4.28           C  
ATOM    178  C   ILE A  27      68.716  41.328  31.631  1.00  3.82           C  
ATOM    179  O   ILE A  27      69.702  41.089  30.899  1.00  3.92           O  
ATOM    180  CB  ILE A  27      68.029  39.045  32.514  1.00  6.29           C  
ATOM    181  CG1 ILE A  27      66.802  38.205  32.968  1.00  7.15           C  
ATOM    182  CG2 ILE A  27      68.924  39.421  33.719  1.00  7.40           C  
ATOM    183  CD1 ILE A  27      65.880  37.747  31.824  1.00  7.34           C  
ATOM    184  N   ILE A  28      68.583  42.397  32.382  1.00  3.50           N  
ATOM    185  CA  ILE A  28      69.650  43.380  32.468  1.00  3.86           C  
ATOM    186  C   ILE A  28      69.984  43.600  33.939  1.00  3.50           C  
ATOM    187  O   ILE A  28      69.056  43.866  34.758  1.00  4.39           O  
ATOM    188  CB  ILE A  28      69.278  44.755  31.815  1.00  4.84           C  
ATOM    189  CG1 ILE A  28      68.721  44.534  30.396  1.00  5.31           C  
ATOM    190  CG2 ILE A  28      70.503  45.697  31.846  1.00  5.87           C  
ATOM    191  CD1 ILE A  28      68.371  45.862  29.685  1.00  5.89           C  
ATOM    192  N   THR A  29      71.247  43.528  34.286  1.00  3.96           N  
ATOM    193  CA  THR A  29      71.650  43.832  35.655  1.00  4.14           C  
ATOM    194  C   THR A  29      72.122  45.273  35.800  1.00  3.59           C  
ATOM    195  O   THR A  29      72.560  45.920  34.864  1.00  4.36           O  
ATOM    196  CB  THR A  29      72.819  42.886  36.168  1.00  4.08           C  
ATOM    197  OG1 THR A  29      74.091  43.354  35.667  1.00  3.82           O  
ATOM    198  CG2 THR A  29      72.627  41.412  35.797  1.00  4.97           C  
ATOM    199  N   SER A  30      72.067  45.727  37.050  1.00  3.82           N  
ATOM    200  CA  SER A  30      72.708  46.978  37.420  1.00  3.64           C  
ATOM    201  C   SER A  30      74.233  46.669  37.402  1.00  3.76           C  
ATOM    202  O   SER A  30      74.656  45.497  37.435  1.00  4.49           O  
ATOM    203  CB  SER A  30      72.342  47.343  38.866  1.00  3.92           C  
ATOM    204  OG  SER A  30      71.074  47.970  38.864  1.00  4.47           O  
ATOM    205  N   GLY A  31      75.024  47.727  37.364  1.00  3.83           N  
ATOM    206  CA  GLY A  31      76.490  47.640  37.419  1.00  4.29           C  
ATOM    207  C   GLY A  31      76.841  47.101  38.797  1.00  4.32           C  
ATOM    208  O   GLY A  31      76.537  47.798  39.790  1.00  6.10           O  
ATOM    209  N   GLN A  32      77.445  45.944  38.918  1.00  3.41           N  
ATOM    210  CA  GLN A  32      77.789  45.328  40.201  1.00  3.93           C  
ATOM    211  C   GLN A  32      79.207  45.719  40.606  1.00  3.99           C  
ATOM    212  O   GLN A  32      80.173  45.569  39.865  1.00  4.71           O  
ATOM    213  CB  GLN A  32      77.685  43.799  40.113  1.00  4.22           C  
ATOM    214  CG  GLN A  32      76.274  43.308  39.837  1.00  3.95           C  
ATOM    215  CD  GLN A  32      75.275  43.853  40.820  1.00  4.74           C  
ATOM    216  OE1 GLN A  32      75.417  43.620  42.027  1.00  5.56           O  
ATOM    217  NE2 GLN A  32      74.323  44.643  40.320  1.00  4.99           N  
ATOM    218  N   ILE A  33      79.288  46.133  41.861  1.00  5.20           N  
ATOM    219  CA  ILE A  33      80.571  46.463  42.487  1.00  5.52           C  
ATOM    220  C   ILE A  33      80.906  45.313  43.431  1.00  5.61           C  
ATOM    221  O   ILE A  33      80.028  44.504  43.816  1.00  5.33           O  
ATOM    222  CB  ILE A  33      80.525  47.849  43.156  1.00  6.50           C  
ATOM    223  CG1 ILE A  33      79.388  47.942  44.205  1.00  7.36           C  
ATOM    224  CG2 ILE A  33      80.397  48.985  42.103  1.00  7.63           C  
ATOM    225  CD1 ILE A  33      79.558  49.191  45.101  1.00  8.30           C  
ATOM    226  N   PRO A  34      82.169  45.220  43.801  1.00  5.57           N  
ATOM    227  CA  PRO A  34      82.653  44.089  44.586  1.00  5.47           C  
ATOM    228  C   PRO A  34      82.334  44.109  46.076  1.00  5.79           C  
ATOM    229  O   PRO A  34      83.247  43.890  46.904  1.00  7.27           O  
ATOM    230  CB  PRO A  34      84.170  44.067  44.343  1.00  5.88           C  
ATOM    231  CG  PRO A  34      84.474  45.527  44.104  1.00  6.23           C  
ATOM    232  CD  PRO A  34      83.292  46.010  43.265  1.00  5.26           C  
ATOM    233  N   VAL A  35      81.074  44.336  46.381  1.00  5.68           N  
ATOM    234  CA  VAL A  35      80.612  44.285  47.778  1.00  6.40           C  
ATOM    235  C   VAL A  35      80.114  42.865  48.035  1.00  5.88           C  
ATOM    236  O   VAL A  35      79.355  42.278  47.264  1.00  5.93           O  
ATOM    237  CB  VAL A  35      79.470  45.290  47.995  1.00  7.54           C  
ATOM    238  CG1 VAL A  35      78.789  45.091  49.350  1.00  7.74           C  
ATOM    239  CG2 VAL A  35      79.945  46.708  47.816  1.00  7.73           C  
ATOM    240  N   ASN A  36      80.571  42.325  49.167  1.00  6.56           N  
ATOM    241  CA  ASN A  36      80.159  40.961  49.575  1.00  7.61           C  
ATOM    242  C   ASN A  36      78.746  41.042  50.133  1.00  7.47           C  
ATOM    243  O   ASN A  36      78.515  41.812  51.091  1.00  8.51           O  
ATOM    244  CB  ASN A  36      81.180  40.477  50.592  1.00  9.42           C  
ATOM    245  CG  ASN A  36      80.924  39.103  51.151  1.00 11.61           C  
ATOM    246  OD1 ASN A  36      79.800  38.795  51.580  1.00 12.84           O  
ATOM    247  ND2 ASN A  36      81.996  38.309  51.213  1.00 12.39           N  
ATOM    248  N   PRO A  37      77.794  40.284  49.646  1.00  7.10           N  
ATOM    249  CA  PRO A  37      76.416  40.355  50.137  1.00  8.07           C  
ATOM    250  C   PRO A  37      76.222  39.828  51.539  1.00  8.69           C  
ATOM    251  O   PRO A  37      75.193  40.115  52.165  1.00  9.39           O  
ATOM    252  CB  PRO A  37      75.611  39.552  49.117  1.00  8.93           C  
ATOM    253  CG  PRO A  37      76.622  38.567  48.605  1.00  9.33           C  
ATOM    254  CD  PRO A  37      77.934  39.343  48.533  1.00  8.45           C  
ATOM    255  N   LYS A  38      77.150  39.015  52.005  1.00  9.24           N  
ATOM    256  CA  LYS A  38      77.058  38.450  53.370  1.00 11.17           C  
ATOM    257  C   LYS A  38      77.544  39.465  54.388  1.00 11.35           C  
ATOM    258  O   LYS A  38      76.884  39.628  55.449  1.00 12.18           O  
ATOM    259  CB  LYS A  38      77.894  37.190  53.455  1.00 12.66           C  
ATOM    260  CG  LYS A  38      77.830  36.365  54.731  1.00 13.74           C  
ATOM    261  CD  LYS A  38      78.610  35.033  54.624  1.00 14.42           C  
ATOM    262  CE  LYS A  38      78.043  34.141  53.694  1.00 17.20           C  
ATOM    263  NZ  LYS A  38      76.653  33.774  54.084  1.00 18.80           N  
ATOM    264  N   THR A  39      78.660  40.140  54.140  1.00 11.29           N  
ATOM    265  CA  THR A  39      79.248  41.073  55.096  1.00 11.38           C  
ATOM    266  C   THR A  39      79.233  42.545  54.795  1.00 11.67           C  
ATOM    267  O   THR A  39      79.480  43.355  55.722  1.00 12.12           O  
ATOM    268  CB  THR A  39      80.777  40.668  55.303  1.00 11.46           C  
ATOM    269  OG1 THR A  39      81.415  40.984  54.015  1.00 11.47           O  
ATOM    270  CG2 THR A  39      80.981  39.208  55.656  1.00 12.27           C  
ATOM    271  N   GLY A  40      79.044  42.901  53.531  1.00 11.14           N  
ATOM    272  CA  GLY A  40      79.054  44.304  53.126  1.00 11.25           C  
ATOM    273  C   GLY A  40      80.473  44.801  52.857  1.00 11.36           C  
ATOM    274  O   GLY A  40      80.630  45.972  52.473  1.00 12.70           O  
ATOM    275  N   GLU A  41      81.469  43.963  53.038  1.00 11.11           N  
ATOM    276  CA  GLU A  41      82.865  44.363  52.816  1.00 11.71           C  
ATOM    277  C   GLU A  41      83.322  44.198  51.380  1.00 10.19           C  
ATOM    278  O   GLU A  41      82.717  43.416  50.642  1.00 10.11           O  
ATOM    279  CB  GLU A  41      83.788  43.500  53.699  1.00 13.86           C  
ATOM    280  CG  GLU A  41      83.526  43.780  55.191  1.00 16.75           C  
ATOM    281  CD  GLU A  41      84.346  42.965  56.146  1.00 18.82           C  
ATOM    282  OE1 GLU A  41      84.869  41.907  55.833  1.00 19.76           O  
ATOM    283  OE2 GLU A  41      84.381  43.529  57.269  1.00 20.70           O  
ATOM    284  N   VAL A  42      84.388  44.897  51.048  1.00  9.39           N  
ATOM    285  CA  VAL A  42      84.993  44.850  49.700  1.00  8.66           C  
ATOM    286  C   VAL A  42      86.397  44.283  49.871  1.00  8.84           C  
ATOM    287  O   VAL A  42      87.143  44.873  50.703  1.00  8.91           O  
ATOM    288  CB  VAL A  42      85.046  46.271  49.115  1.00  8.81           C  
ATOM    289  CG1 VAL A  42      85.855  46.276  47.818  1.00  8.55           C  
ATOM    290  CG2 VAL A  42      83.646  46.823  48.892  1.00  9.11           C  
ATOM    291  N   PRO A  43      86.749  43.263  49.153  1.00  8.44           N  
ATOM    292  CA  PRO A  43      88.090  42.661  49.253  1.00  9.28           C  
ATOM    293  C   PRO A  43      89.088  43.642  48.666  1.00  9.79           C  
ATOM    294  O   PRO A  43      88.761  44.417  47.738  1.00  9.85           O  
ATOM    295  CB  PRO A  43      87.963  41.330  48.521  1.00  9.38           C  
ATOM    296  CG  PRO A  43      86.904  41.593  47.472  1.00  9.11           C  
ATOM    297  CD  PRO A  43      85.931  42.560  48.148  1.00  8.87           C  
ATOM    298  N   ALA A  44      90.306  43.625  49.205  1.00 11.00           N  
ATOM    299  CA  ALA A  44      91.364  44.533  48.750  1.00 11.90           C  
ATOM    300  C   ALA A  44      91.891  44.257  47.344  1.00 12.03           C  
ATOM    301  O   ALA A  44      92.037  45.142  46.488  1.00 13.47           O  
ATOM    302  CB  ALA A  44      92.490  44.432  49.795  1.00 12.50           C  
ATOM    303  N   ASP A  45      92.187  43.024  47.097  1.00 11.52           N  
ATOM    304  CA  ASP A  45      92.778  42.405  45.913  1.00 11.81           C  
ATOM    305  C   ASP A  45      91.950  42.652  44.657  1.00 10.80           C  
ATOM    306  O   ASP A  45      90.733  42.364  44.712  1.00  9.73           O  
ATOM    307  CB  ASP A  45      92.967  40.921  46.328  1.00 12.76           C  
ATOM    308  CG  ASP A  45      93.635  40.132  45.241  1.00 14.25           C  
ATOM    309  OD1 ASP A  45      92.914  39.460  44.485  1.00 13.77           O  
ATOM    310  OD2 ASP A  45      94.888  40.151  45.112  1.00 15.41           O  
ATOM    311  N   VAL A  46      92.538  43.111  43.570  1.00 10.67           N  
ATOM    312  CA  VAL A  46      91.740  43.352  42.349  1.00  9.52           C  
ATOM    313  C   VAL A  46      91.145  42.077  41.763  1.00  7.84           C  
ATOM    314  O   VAL A  46      90.020  42.101  41.232  1.00  7.66           O  
ATOM    315  CB  VAL A  46      92.514  44.193  41.319  1.00 10.26           C  
ATOM    316  CG1 VAL A  46      93.715  43.466  40.736  1.00 10.79           C  
ATOM    317  CG2 VAL A  46      91.580  44.722  40.252  1.00 10.65           C  
ATOM    318  N   ALA A  47      91.882  40.980  41.833  1.00  7.55           N  
ATOM    319  CA  ALA A  47      91.332  39.710  41.313  1.00  7.95           C  
ATOM    320  C   ALA A  47      90.095  39.343  42.130  1.00  7.45           C  
ATOM    321  O   ALA A  47      89.046  38.935  41.570  1.00  7.40           O  
ATOM    322  CB  ALA A  47      92.377  38.606  41.359  1.00  8.33           C  
ATOM    323  N   ALA A  48      90.198  39.472  43.439  1.00  6.86           N  
ATOM    324  CA  ALA A  48      89.062  39.157  44.312  1.00  6.14           C  
ATOM    325  C   ALA A  48      87.914  40.111  44.016  1.00  5.74           C  
ATOM    326  O   ALA A  48      86.755  39.681  44.066  1.00  5.87           O  
ATOM    327  CB  ALA A  48      89.518  39.212  45.757  1.00  6.39           C  
ATOM    328  N   GLN A  49      88.201  41.357  43.748  1.00  5.59           N  
ATOM    329  CA  GLN A  49      87.123  42.316  43.412  1.00  5.03           C  
ATOM    330  C   GLN A  49      86.430  41.883  42.121  1.00  4.68           C  
ATOM    331  O   GLN A  49      85.197  41.894  42.039  1.00  5.23           O  
ATOM    332  CB  GLN A  49      87.666  43.735  43.324  1.00  5.71           C  
ATOM    333  CG  GLN A  49      87.983  44.329  44.705  1.00  6.17           C  
ATOM    334  CD  GLN A  49      88.123  45.838  44.661  1.00  5.93           C  
ATOM    335  OE1 GLN A  49      87.631  46.511  43.737  1.00  5.99           O  
ATOM    336  NE2 GLN A  49      88.759  46.418  45.677  1.00  6.38           N  
ATOM    337  N   ALA A  50      87.241  41.530  41.127  1.00  4.71           N  
ATOM    338  CA  ALA A  50      86.609  41.100  39.857  1.00  4.54           C  
ATOM    339  C   ALA A  50      85.691  39.901  40.093  1.00  4.94           C  
ATOM    340  O   ALA A  50      84.555  39.835  39.591  1.00  4.87           O  
ATOM    341  CB  ALA A  50      87.639  40.760  38.794  1.00  5.66           C  
ATOM    342  N   ARG A  51      86.168  38.961  40.899  1.00  5.38           N  
ATOM    343  CA  ARG A  51      85.351  37.775  41.197  1.00  5.49           C  
ATOM    344  C   ARG A  51      84.106  38.109  41.983  1.00  5.04           C  
ATOM    345  O   ARG A  51      83.045  37.520  41.701  1.00  6.12           O  
ATOM    346  CB  ARG A  51      86.169  36.668  41.856  1.00  6.73           C  
ATOM    347  CG  ARG A  51      85.416  35.371  42.095  1.00  7.56           C  
ATOM    348  CD  ARG A  51      86.335  34.228  42.401  1.00  8.32           C  
ATOM    349  NE  ARG A  51      87.131  33.737  41.287  1.00  8.95           N  
ATOM    350  CZ  ARG A  51      86.725  32.862  40.355  1.00  9.18           C  
ATOM    351  NH1 ARG A  51      85.494  32.352  40.363  1.00  8.39           N  
ATOM    352  NH2 ARG A  51      87.572  32.493  39.387  1.00 10.81           N  
ATOM    353  N   GLN A  52      84.181  39.003  42.949  1.00  4.75           N  
ATOM    354  CA  GLN A  52      82.996  39.380  43.739  1.00  4.61           C  
ATOM    355  C   GLN A  52      81.986  40.062  42.814  1.00  4.34           C  
ATOM    356  O   GLN A  52      80.765  39.804  42.949  1.00  4.87           O  
ATOM    357  CB  GLN A  52      83.389  40.248  44.920  1.00  5.74           C  
ATOM    358  CG  GLN A  52      82.189  40.577  45.782  1.00  5.80           C  
ATOM    359  CD  GLN A  52      81.565  39.381  46.437  1.00  6.30           C  
ATOM    360  OE1 GLN A  52      82.066  38.913  47.473  1.00  7.97           O  
ATOM    361  NE2 GLN A  52      80.481  38.882  45.895  1.00  7.04           N  
ATOM    362  N   SER A  53      82.440  40.964  41.952  1.00  4.36           N  
ATOM    363  CA  SER A  53      81.497  41.599  41.008  1.00  4.64           C  
ATOM    364  C   SER A  53      80.814  40.561  40.116  1.00  4.34           C  
ATOM    365  O   SER A  53      79.596  40.631  39.906  1.00  4.42           O  
ATOM    366  CB  SER A  53      82.225  42.635  40.177  1.00  5.03           C  
ATOM    367  OG  SER A  53      82.402  43.858  40.840  1.00  7.71           O  
ATOM    368  N   LEU A  54      81.587  39.622  39.607  1.00  4.12           N  
ATOM    369  CA  LEU A  54      81.025  38.554  38.766  1.00  4.70           C  
ATOM    370  C   LEU A  54      80.049  37.688  39.554  1.00  3.93           C  
ATOM    371  O   LEU A  54      79.003  37.290  39.010  1.00  4.71           O  
ATOM    372  CB  LEU A  54      82.152  37.763  38.138  1.00  5.03           C  
ATOM    373  CG  LEU A  54      82.876  38.519  37.020  1.00  5.82           C  
ATOM    374  CD1 LEU A  54      84.177  37.797  36.669  1.00  5.88           C  
ATOM    375  CD2 LEU A  54      82.026  38.675  35.772  1.00  6.70           C  
ATOM    376  N   ASP A  55      80.361  37.390  40.798  1.00  4.46           N  
ATOM    377  CA  ASP A  55      79.442  36.573  41.612  1.00  4.76           C  
ATOM    378  C   ASP A  55      78.135  37.342  41.825  1.00  5.09           C  
ATOM    379  O   ASP A  55      77.078  36.714  41.883  1.00  4.83           O  
ATOM    380  CB  ASP A  55      80.121  36.197  42.919  1.00  6.75           C  
ATOM    381  CG  ASP A  55      81.027  34.978  42.831  1.00  8.66           C  
ATOM    382  OD1 ASP A  55      81.954  34.828  43.651  1.00 10.67           O  
ATOM    383  OD2 ASP A  55      80.762  34.146  41.954  1.00 10.74           O  
ATOM    384  N   ASN A  56      78.272  38.645  41.995  1.00  4.45           N  
ATOM    385  CA  ASN A  56      77.042  39.468  42.205  1.00  3.71           C  
ATOM    386  C   ASN A  56      76.214  39.416  40.924  1.00  3.25           C  
ATOM    387  O   ASN A  56      74.968  39.309  40.988  1.00  4.24           O  
ATOM    388  CB  ASN A  56      77.386  40.901  42.615  1.00  4.47           C  
ATOM    389  CG  ASN A  56      77.891  40.934  44.055  1.00  4.53           C  
ATOM    390  OD1 ASN A  56      77.717  39.962  44.822  1.00  5.62           O  
ATOM    391  ND2 ASN A  56      78.569  42.019  44.442  1.00  4.94           N  
ATOM    392  N   VAL A  57      76.856  39.580  39.767  1.00  4.41           N  
ATOM    393  CA  VAL A  57      76.126  39.479  38.480  1.00  4.09           C  
ATOM    394  C   VAL A  57      75.454  38.124  38.405  1.00  3.73           C  
ATOM    395  O   VAL A  57      74.259  37.984  38.064  1.00  4.05           O  
ATOM    396  CB  VAL A  57      77.075  39.668  37.301  1.00  4.49           C  
ATOM    397  CG1 VAL A  57      76.429  39.197  35.995  1.00  5.66           C  
ATOM    398  CG2 VAL A  57      77.555  41.098  37.175  1.00  5.00           C  
ATOM    399  N   LYS A  58      76.185  37.064  38.700  1.00  3.78           N  
ATOM    400  CA  LYS A  58      75.661  35.687  38.661  1.00  4.51           C  
ATOM    401  C   LYS A  58      74.442  35.533  39.554  1.00  4.64           C  
ATOM    402  O   LYS A  58      73.449  34.911  39.175  1.00  4.91           O  
ATOM    403  CB  LYS A  58      76.764  34.732  39.122  1.00  5.87           C  
ATOM    404  CG  LYS A  58      76.261  33.306  39.362  1.00  6.61           C  
ATOM    405  CD  LYS A  58      77.421  32.377  39.668  1.00  8.95           C  
ATOM    406  CE  LYS A  58      76.982  31.100  40.355  1.00  9.79           C  
ATOM    407  NZ  LYS A  58      78.121  30.189  40.603  1.00 10.97           N  
ATOM    408  N   ALA A  59      74.492  36.083  40.760  1.00  4.57           N  
ATOM    409  CA  ALA A  59      73.350  35.969  41.683  1.00  4.83           C  
ATOM    410  C   ALA A  59      72.077  36.545  41.066  1.00  4.63           C  
ATOM    411  O   ALA A  59      70.975  35.976  41.237  1.00  4.41           O  
ATOM    412  CB  ALA A  59      73.650  36.706  42.978  1.00  5.64           C  
ATOM    413  N   ILE A  60      72.199  37.685  40.399  1.00  4.27           N  
ATOM    414  CA  ILE A  60      71.038  38.359  39.794  1.00  4.66           C  
ATOM    415  C   ILE A  60      70.520  37.571  38.608  1.00  3.81           C  
ATOM    416  O   ILE A  60      69.305  37.402  38.435  1.00  4.20           O  
ATOM    417  CB  ILE A  60      71.448  39.819  39.464  1.00  4.36           C  
ATOM    418  CG1 ILE A  60      71.789  40.555  40.778  1.00  4.56           C  
ATOM    419  CG2 ILE A  60      70.350  40.542  38.654  1.00  4.23           C  
ATOM    420  CD1 ILE A  60      72.604  41.852  40.511  1.00  5.34           C  
ATOM    421  N   VAL A  61      71.434  37.128  37.742  1.00  3.65           N  
ATOM    422  CA  VAL A  61      71.049  36.315  36.572  1.00  4.56           C  
ATOM    423  C   VAL A  61      70.383  35.017  37.011  1.00  4.22           C  
ATOM    424  O   VAL A  61      69.345  34.633  36.462  1.00  4.43           O  
ATOM    425  CB  VAL A  61      72.295  36.091  35.698  1.00  4.74           C  
ATOM    426  CG1 VAL A  61      72.085  35.055  34.605  1.00  5.69           C  
ATOM    427  CG2 VAL A  61      72.777  37.408  35.118  1.00  5.47           C  
ATOM    428  N   GLU A  62      70.946  34.376  38.028  1.00  4.43           N  
ATOM    429  CA  GLU A  62      70.349  33.122  38.512  1.00  4.95           C  
ATOM    430  C   GLU A  62      69.014  33.389  39.179  1.00  5.30           C  
ATOM    431  O   GLU A  62      68.097  32.540  39.091  1.00  5.38           O  
ATOM    432  CB  GLU A  62      71.267  32.348  39.445  1.00  5.58           C  
ATOM    433  CG  GLU A  62      72.488  31.799  38.697  1.00  7.08           C  
ATOM    434  CD  GLU A  62      73.393  30.893  39.456  1.00  8.46           C  
ATOM    435  OE1 GLU A  62      74.124  30.096  38.870  1.00 10.06           O  
ATOM    436  OE2 GLU A  62      73.377  30.950  40.711  1.00 10.50           O  
ATOM    437  N   ALA A  63      68.827  34.523  39.825  1.00  5.02           N  
ATOM    438  CA  ALA A  63      67.545  34.852  40.480  1.00  4.80           C  
ATOM    439  C   ALA A  63      66.453  34.991  39.426  1.00  4.67           C  
ATOM    440  O   ALA A  63      65.259  34.858  39.748  1.00  5.23           O  
ATOM    441  CB  ALA A  63      67.729  36.080  41.321  1.00  4.87           C  
ATOM    442  N   ALA A  64      66.813  35.260  38.182  1.00  4.95           N  
ATOM    443  CA  ALA A  64      65.853  35.363  37.098  1.00  5.12           C  
ATOM    444  C   ALA A  64      65.679  34.025  36.384  1.00  5.56           C  
ATOM    445  O   ALA A  64      64.975  34.007  35.348  1.00  6.36           O  
ATOM    446  CB  ALA A  64      66.261  36.464  36.120  1.00  6.01           C  
ATOM    447  N   GLY A  65      66.290  32.969  36.853  1.00  5.32           N  
ATOM    448  CA  GLY A  65      66.141  31.647  36.236  1.00  5.69           C  
ATOM    449  C   GLY A  65      67.144  31.387  35.127  1.00  5.00           C  
ATOM    450  O   GLY A  65      66.921  30.404  34.383  1.00  6.60           O  
ATOM    451  N   LEU A  66      68.194  32.189  34.999  1.00  4.89           N  
ATOM    452  CA  LEU A  66      69.186  32.006  33.928  1.00  5.10           C  
ATOM    453  C   LEU A  66      70.487  31.531  34.520  1.00  5.52           C  
ATOM    454  O   LEU A  66      70.668  31.463  35.736  1.00  6.12           O  
ATOM    455  CB  LEU A  66      69.316  33.315  33.142  1.00  5.47           C  
ATOM    456  CG  LEU A  66      68.097  33.631  32.288  1.00  7.05           C  
ATOM    457  CD1 LEU A  66      68.371  34.886  31.468  1.00  7.79           C  
ATOM    458  CD2 LEU A  66      67.692  32.439  31.424  1.00  8.50           C  
ATOM    459  N   LYS A  67      71.445  31.271  33.648  1.00  5.84           N  
ATOM    460  CA  LYS A  67      72.786  30.809  34.048  1.00  6.22           C  
ATOM    461  C   LYS A  67      73.816  31.807  33.549  1.00  5.40           C  
ATOM    462  O   LYS A  67      73.570  32.622  32.639  1.00  5.50           O  
ATOM    463  CB  LYS A  67      73.079  29.469  33.357  1.00  8.08           C  
ATOM    464  CG  LYS A  67      72.074  28.368  33.705  1.00 10.38           C  
ATOM    465  CD  LYS A  67      72.380  27.097  32.907  1.00 13.10           C  
ATOM    466  CE  LYS A  67      71.412  25.982  33.290  1.00 14.74           C  
ATOM    467  NZ  LYS A  67      71.878  24.701  32.686  1.00 16.76           N  
ATOM    468  N   VAL A  68      75.018  31.677  34.130  1.00  5.45           N  
ATOM    469  CA  VAL A  68      76.148  32.489  33.661  1.00  5.05           C  
ATOM    470  C   VAL A  68      76.302  32.297  32.140  1.00  5.56           C  
ATOM    471  O   VAL A  68      76.647  33.272  31.455  1.00  5.83           O  
ATOM    472  CB  VAL A  68      77.426  32.112  34.425  1.00  5.97           C  
ATOM    473  CG1 VAL A  68      78.683  32.652  33.755  1.00  6.44           C  
ATOM    474  CG2 VAL A  68      77.317  32.489  35.897  1.00  7.15           C  
ATOM    475  N   GLY A  69      76.059  31.098  31.644  1.00  5.71           N  
ATOM    476  CA  GLY A  69      76.182  30.814  30.209  1.00  6.22           C  
ATOM    477  C   GLY A  69      75.182  31.584  29.348  1.00  5.67           C  
ATOM    478  O   GLY A  69      75.356  31.590  28.112  1.00  6.75           O  
ATOM    479  N   ASP A  70      74.162  32.179  29.954  1.00  4.83           N  
ATOM    480  CA  ASP A  70      73.167  32.986  29.228  1.00  5.11           C  
ATOM    481  C   ASP A  70      73.580  34.460  29.126  1.00  4.14           C  
ATOM    482  O   ASP A  70      72.836  35.224  28.501  1.00  4.50           O  
ATOM    483  CB  ASP A  70      71.792  32.818  29.870  1.00  5.29           C  
ATOM    484  CG  ASP A  70      71.311  31.368  29.874  1.00  6.10           C  
ATOM    485  OD1 ASP A  70      70.817  30.936  30.936  1.00  6.91           O  
ATOM    486  OD2 ASP A  70      71.486  30.722  28.836  1.00  6.71           O  
ATOM    487  N   ILE A  71      74.659  34.816  29.761  1.00  4.31           N  
ATOM    488  CA  ILE A  71      75.113  36.223  29.684  1.00  4.32           C  
ATOM    489  C   ILE A  71      75.701  36.436  28.277  1.00  3.98           C  
ATOM    490  O   ILE A  71      76.607  35.672  27.904  1.00  5.01           O  
ATOM    491  CB  ILE A  71      76.153  36.533  30.802  1.00  4.70           C  
ATOM    492  CG1 ILE A  71      75.498  36.423  32.211  1.00  4.36           C  
ATOM    493  CG2 ILE A  71      76.759  37.933  30.549  1.00  4.30           C  
ATOM    494  CD1 ILE A  71      76.512  36.394  33.383  1.00  4.71           C  
ATOM    495  N   VAL A  72      75.221  37.454  27.586  1.00  3.47           N  
ATOM    496  CA  VAL A  72      75.651  37.696  26.204  1.00  3.99           C  
ATOM    497  C   VAL A  72      76.400  38.989  26.032  1.00  3.90           C  
ATOM    498  O   VAL A  72      77.090  39.132  24.997  1.00  4.27           O  
ATOM    499  CB  VAL A  72      74.432  37.596  25.252  1.00  4.41           C  
ATOM    500  CG1 VAL A  72      73.905  36.176  25.208  1.00  5.07           C  
ATOM    501  CG2 VAL A  72      73.360  38.601  25.631  1.00  5.77           C  
ATOM    502  N   LYS A  73      76.347  39.922  26.994  1.00  3.52           N  
ATOM    503  CA  LYS A  73      77.092  41.179  26.857  1.00  4.16           C  
ATOM    504  C   LYS A  73      77.410  41.720  28.255  1.00  4.31           C  
ATOM    505  O   LYS A  73      76.474  41.721  29.093  1.00  4.84           O  
ATOM    506  CB  LYS A  73      76.253  42.245  26.151  1.00  5.02           C  
ATOM    507  CG  LYS A  73      76.823  43.662  26.024  1.00  5.28           C  
ATOM    508  CD  LYS A  73      78.141  43.781  25.291  1.00  5.37           C  
ATOM    509  CE  LYS A  73      78.600  45.199  25.049  1.00  6.08           C  
ATOM    510  NZ  LYS A  73      78.698  46.054  26.262  1.00  6.35           N  
ATOM    511  N   THR A  74      78.628  42.160  28.431  1.00  3.73           N  
ATOM    512  CA  THR A  74      78.975  42.844  29.675  1.00  3.85           C  
ATOM    513  C   THR A  74      79.668  44.151  29.299  1.00  3.84           C  
ATOM    514  O   THR A  74      80.193  44.352  28.193  1.00  3.85           O  
ATOM    515  CB  THR A  74      79.950  41.986  30.549  1.00  4.06           C  
ATOM    516  OG1 THR A  74      81.177  41.843  29.788  1.00  4.62           O  
ATOM    517  CG2 THR A  74      79.374  40.651  30.982  1.00  4.69           C  
ATOM    518  N   THR A  75      79.671  45.044  30.286  1.00  3.73           N  
ATOM    519  CA  THR A  75      80.523  46.228  30.215  1.00  4.09           C  
ATOM    520  C   THR A  75      81.338  46.170  31.537  1.00  4.02           C  
ATOM    521  O   THR A  75      80.719  46.059  32.610  1.00  4.60           O  
ATOM    522  CB  THR A  75      79.853  47.608  30.054  1.00  5.33           C  
ATOM    523  OG1 THR A  75      79.156  47.493  28.766  1.00  6.90           O  
ATOM    524  CG2 THR A  75      80.857  48.763  30.037  1.00  6.26           C  
ATOM    525  N   VAL A  76      82.630  46.238  31.394  1.00  3.79           N  
ATOM    526  CA  VAL A  76      83.547  46.199  32.525  1.00  4.37           C  
ATOM    527  C   VAL A  76      84.232  47.555  32.630  1.00  4.23           C  
ATOM    528  O   VAL A  76      85.000  47.977  31.741  1.00  5.09           O  
ATOM    529  CB  VAL A  76      84.576  45.068  32.299  1.00  5.09           C  
ATOM    530  CG1 VAL A  76      85.563  45.024  33.468  1.00  6.10           C  
ATOM    531  CG2 VAL A  76      83.936  43.683  32.132  1.00  5.44           C  
ATOM    532  N   PHE A  77      83.909  48.227  33.713  1.00  3.73           N  
ATOM    533  CA  PHE A  77      84.491  49.552  34.011  1.00  4.03           C  
ATOM    534  C   PHE A  77      85.592  49.307  35.044  1.00  3.31           C  
ATOM    535  O   PHE A  77      85.247  48.715  36.093  1.00  5.04           O  
ATOM    536  CB  PHE A  77      83.451  50.483  34.604  1.00  3.99           C  
ATOM    537  CG  PHE A  77      82.225  50.709  33.774  1.00  3.46           C  
ATOM    538  CD1 PHE A  77      81.020  50.062  34.078  1.00  4.75           C  
ATOM    539  CD2 PHE A  77      82.254  51.605  32.709  1.00  4.57           C  
ATOM    540  CE1 PHE A  77      79.849  50.331  33.368  1.00  5.64           C  
ATOM    541  CE2 PHE A  77      81.087  51.855  31.980  1.00  5.55           C  
ATOM    542  CZ  PHE A  77      79.889  51.254  32.313  1.00  5.75           C  
ATOM    543  N   VAL A  78      86.816  49.724  34.802  1.00  3.70           N  
ATOM    544  CA  VAL A  78      87.888  49.522  35.775  1.00  4.71           C  
ATOM    545  C   VAL A  78      88.480  50.860  36.182  1.00  4.55           C  
ATOM    546  O   VAL A  78      88.444  51.829  35.436  1.00  4.79           O  
ATOM    547  CB  VAL A  78      88.987  48.578  35.250  1.00  5.00           C  
ATOM    548  CG1 VAL A  78      88.448  47.187  34.947  1.00  6.84           C  
ATOM    549  CG2 VAL A  78      89.694  49.122  34.011  1.00  5.75           C  
ATOM    550  N   LYS A  79      89.082  50.847  37.366  1.00  5.21           N  
ATOM    551  CA  LYS A  79      89.808  52.014  37.865  1.00  5.74           C  
ATOM    552  C   LYS A  79      91.217  52.051  37.260  1.00  6.17           C  
ATOM    553  O   LYS A  79      91.770  53.169  37.119  1.00  6.76           O  
ATOM    554  CB  LYS A  79      89.884  52.004  39.379  1.00  6.81           C  
ATOM    555  CG  LYS A  79      90.712  53.136  39.972  1.00  8.82           C  
ATOM    556  CD  LYS A  79      90.226  54.529  39.607  1.00 10.71           C  
ATOM    557  CE  LYS A  79      91.241  55.625  39.885  1.00 11.66           C  
ATOM    558  NZ  LYS A  79      92.406  55.548  38.959  1.00 13.37           N  
ATOM    559  N   ASP A  80      91.797  50.931  36.893  1.00  6.31           N  
ATOM    560  CA  ASP A  80      93.179  50.935  36.370  1.00  6.74           C  
ATOM    561  C   ASP A  80      93.439  49.824  35.376  1.00  6.52           C  
ATOM    562  O   ASP A  80      93.498  48.651  35.799  1.00  7.52           O  
ATOM    563  CB  ASP A  80      94.135  50.852  37.585  1.00  7.41           C  
ATOM    564  CG  ASP A  80      95.595  51.006  37.219  1.00  8.15           C  
ATOM    565  OD1 ASP A  80      96.451  51.095  38.142  1.00 10.21           O  
ATOM    566  OD2 ASP A  80      95.959  51.058  36.038  1.00  8.03           O  
ATOM    567  N   LEU A  81      93.572  50.158  34.105  1.00  6.91           N  
ATOM    568  CA  LEU A  81      93.840  49.153  33.081  1.00  8.19           C  
ATOM    569  C   LEU A  81      95.176  48.460  33.328  1.00  8.43           C  
ATOM    570  O   LEU A  81      95.385  47.404  32.699  1.00  9.36           O  
ATOM    571  CB  LEU A  81      93.707  49.690  31.667  1.00  8.43           C  
ATOM    572  CG  LEU A  81      92.264  49.711  31.162  1.00  8.40           C  
ATOM    573  CD1 LEU A  81      92.236  50.555  29.889  1.00  9.27           C  
ATOM    574  CD2 LEU A  81      91.784  48.301  30.903  1.00  9.04           C  
ATOM    575  N   ASN A  82      96.035  48.989  34.180  1.00  8.67           N  
ATOM    576  CA  ASN A  82      97.296  48.247  34.435  1.00  9.87           C  
ATOM    577  C   ASN A  82      97.004  46.935  35.175  1.00 10.44           C  
ATOM    578  O   ASN A  82      97.861  46.034  35.162  1.00 11.63           O  
ATOM    579  CB  ASN A  82      98.341  49.076  35.161  1.00 10.51           C  
ATOM    580  CG  ASN A  82      98.954  50.111  34.209  1.00 10.87           C  
ATOM    581  OD1 ASN A  82      99.100  49.847  33.026  1.00 11.41           O  
ATOM    582  ND2 ASN A  82      99.271  51.266  34.774  1.00 11.83           N  
ATOM    583  N   ASP A  83      95.843  46.809  35.783  1.00 10.73           N  
ATOM    584  CA  ASP A  83      95.476  45.556  36.489  1.00 11.58           C  
ATOM    585  C   ASP A  83      94.639  44.675  35.568  1.00 11.57           C  
ATOM    586  O   ASP A  83      94.120  43.619  36.006  1.00 11.86           O  
ATOM    587  CB  ASP A  83      94.727  45.879  37.775  1.00 12.86           C  
ATOM    588  CG  ASP A  83      95.597  46.315  38.927  1.00 13.31           C  
ATOM    589  OD1 ASP A  83      95.127  47.088  39.755  1.00 14.31           O  
ATOM    590  OD2 ASP A  83      96.759  45.813  39.036  1.00 15.40           O  
ATOM    591  N   PHE A  84      94.514  45.029  34.304  1.00 11.64           N  
ATOM    592  CA  PHE A  84      93.645  44.220  33.431  1.00 12.27           C  
ATOM    593  C   PHE A  84      94.072  42.794  33.155  1.00 11.14           C  
ATOM    594  O   PHE A  84      93.154  41.962  32.935  1.00 10.67           O  
ATOM    595  CB  PHE A  84      93.232  45.001  32.188  1.00 13.85           C  
ATOM    596  CG  PHE A  84      91.788  44.682  31.855  1.00 15.36           C  
ATOM    597  CD1 PHE A  84      91.480  43.879  30.761  1.00 16.41           C  
ATOM    598  CD2 PHE A  84      90.776  45.192  32.674  1.00 15.95           C  
ATOM    599  CE1 PHE A  84      90.143  43.603  30.473  1.00 17.08           C  
ATOM    600  CE2 PHE A  84      89.436  44.919  32.378  1.00 16.89           C  
ATOM    601  CZ  PHE A  84      89.122  44.125  31.272  1.00 16.95           C  
ATOM    602  N   ALA A  85      95.348  42.447  33.155  1.00 10.77           N  
ATOM    603  CA  ALA A  85      95.721  41.043  32.906  1.00 10.60           C  
ATOM    604  C   ALA A  85      95.112  40.164  34.003  1.00  9.89           C  
ATOM    605  O   ALA A  85      94.615  39.067  33.749  1.00  9.55           O  
ATOM    606  CB  ALA A  85      97.236  40.885  32.816  1.00 11.44           C  
ATOM    607  N   THR A  86      95.170  40.704  35.217  1.00 10.27           N  
ATOM    608  CA  THR A  86      94.650  39.993  36.392  1.00 10.82           C  
ATOM    609  C   THR A  86      93.139  39.828  36.314  1.00  9.25           C  
ATOM    610  O   THR A  86      92.561  38.755  36.572  1.00  8.54           O  
ATOM    611  CB  THR A  86      95.073  40.712  37.740  1.00 12.16           C  
ATOM    612  OG1 THR A  86      96.531  40.785  37.713  1.00 13.99           O  
ATOM    613  CG2 THR A  86      94.529  39.972  38.962  1.00 12.79           C  
ATOM    614  N   VAL A  87      92.491  40.924  35.976  1.00  8.71           N  
ATOM    615  CA  VAL A  87      91.024  40.928  35.824  1.00  8.40           C  
ATOM    616  C   VAL A  87      90.635  39.946  34.725  1.00  7.98           C  
ATOM    617  O   VAL A  87      89.683  39.175  34.914  1.00  8.35           O  
ATOM    618  CB  VAL A  87      90.513  42.351  35.524  1.00  8.84           C  
ATOM    619  CG1 VAL A  87      89.067  42.293  35.040  1.00  9.19           C  
ATOM    620  CG2 VAL A  87      90.689  43.240  36.741  1.00  9.80           C  
ATOM    621  N   ASN A  88      91.327  40.003  33.611  1.00  7.83           N  
ATOM    622  CA  ASN A  88      91.041  39.127  32.472  1.00  9.07           C  
ATOM    623  C   ASN A  88      91.154  37.666  32.854  1.00  8.46           C  
ATOM    624  O   ASN A  88      90.339  36.831  32.452  1.00  7.86           O  
ATOM    625  CB  ASN A  88      91.933  39.398  31.268  1.00 10.40           C  
ATOM    626  CG  ASN A  88      91.247  40.171  30.170  1.00 11.76           C  
ATOM    627  OD1 ASN A  88      90.006  40.105  30.048  1.00 12.61           O  
ATOM    628  ND2 ASN A  88      92.089  40.886  29.416  1.00 13.35           N  
ATOM    629  N   ALA A  89      92.201  37.343  33.603  1.00  7.67           N  
ATOM    630  CA  ALA A  89      92.400  35.946  34.039  1.00  7.58           C  
ATOM    631  C   ALA A  89      91.237  35.467  34.909  1.00  6.88           C  
ATOM    632  O   ALA A  89      90.749  34.338  34.751  1.00  7.11           O  
ATOM    633  CB  ALA A  89      93.744  35.836  34.754  1.00  8.02           C  
ATOM    634  N   THR A  90      90.848  36.324  35.845  1.00  7.04           N  
ATOM    635  CA  THR A  90      89.729  35.967  36.734  1.00  7.07           C  
ATOM    636  C   THR A  90      88.429  35.852  35.942  1.00  6.37           C  
ATOM    637  O   THR A  90      87.630  34.929  36.165  1.00  6.22           O  
ATOM    638  CB  THR A  90      89.601  37.042  37.878  1.00  7.91           C  
ATOM    639  OG1 THR A  90      90.747  36.869  38.766  1.00 10.49           O  
ATOM    640  CG2 THR A  90      88.277  36.915  38.628  1.00  9.07           C  
ATOM    641  N   TYR A  91      88.204  36.806  35.048  1.00  6.16           N  
ATOM    642  CA  TYR A  91      86.988  36.835  34.222  1.00  5.79           C  
ATOM    643  C   TYR A  91      86.918  35.571  33.377  1.00  5.81           C  
ATOM    644  O   TYR A  91      85.883  34.888  33.274  1.00  6.66           O  
ATOM    645  CB  TYR A  91      87.031  38.113  33.403  1.00  5.88           C  
ATOM    646  CG  TYR A  91      85.839  38.435  32.541  1.00  5.59           C  
ATOM    647  CD1 TYR A  91      84.948  39.449  32.894  1.00  5.96           C  
ATOM    648  CD2 TYR A  91      85.598  37.736  31.363  1.00  6.04           C  
ATOM    649  CE1 TYR A  91      83.858  39.812  32.100  1.00  5.47           C  
ATOM    650  CE2 TYR A  91      84.527  38.050  30.537  1.00  6.05           C  
ATOM    651  CZ  TYR A  91      83.677  39.093  30.924  1.00  5.90           C  
ATOM    652  OH  TYR A  91      82.609  39.412  30.106  1.00  5.93           O  
ATOM    653  N   GLU A  92      88.041  35.241  32.753  1.00  6.05           N  
ATOM    654  CA  GLU A  92      88.111  34.035  31.916  1.00  6.75           C  
ATOM    655  C   GLU A  92      87.783  32.786  32.726  1.00  6.71           C  
ATOM    656  O   GLU A  92      86.991  31.905  32.319  1.00  7.08           O  
ATOM    657  CB  GLU A  92      89.483  33.876  31.251  1.00  8.59           C  
ATOM    658  CG  GLU A  92      89.597  32.642  30.340  1.00 11.80           C  
ATOM    659  CD  GLU A  92      90.562  32.746  29.213  1.00 15.28           C  
ATOM    660  OE1 GLU A  92      90.552  32.071  28.177  1.00 18.01           O  
ATOM    661  OE2 GLU A  92      91.423  33.629  29.329  1.00 17.25           O  
ATOM    662  N   ALA A  93      88.408  32.673  33.899  1.00  6.56           N  
ATOM    663  CA  ALA A  93      88.194  31.526  34.795  1.00  7.09           C  
ATOM    664  C   ALA A  93      86.725  31.403  35.175  1.00  6.90           C  
ATOM    665  O   ALA A  93      86.160  30.307  35.131  1.00  7.00           O  
ATOM    666  CB  ALA A  93      89.053  31.637  36.056  1.00  7.57           C  
ATOM    667  N   PHE A  94      86.131  32.549  35.529  1.00  6.67           N  
ATOM    668  CA  PHE A  94      84.710  32.554  35.950  1.00  6.61           C  
ATOM    669  C   PHE A  94      83.801  31.954  34.876  1.00  5.97           C  
ATOM    670  O   PHE A  94      82.943  31.109  35.168  1.00  6.59           O  
ATOM    671  CB  PHE A  94      84.348  33.988  36.316  1.00  7.02           C  
ATOM    672  CG  PHE A  94      82.963  34.138  36.848  1.00  7.23           C  
ATOM    673  CD1 PHE A  94      82.774  33.942  38.212  1.00  8.12           C  
ATOM    674  CD2 PHE A  94      81.896  34.444  36.020  1.00  8.71           C  
ATOM    675  CE1 PHE A  94      81.528  34.055  38.798  1.00  9.74           C  
ATOM    676  CE2 PHE A  94      80.608  34.563  36.588  1.00  9.96           C  
ATOM    677  CZ  PHE A  94      80.474  34.344  37.955  1.00  9.82           C  
ATOM    678  N   PHE A  95      83.958  32.391  33.636  1.00  5.98           N  
ATOM    679  CA  PHE A  95      83.147  31.880  32.513  1.00  6.00           C  
ATOM    680  C   PHE A  95      83.453  30.402  32.281  1.00  6.18           C  
ATOM    681  O   PHE A  95      82.524  29.592  32.076  1.00  6.81           O  
ATOM    682  CB  PHE A  95      83.200  32.776  31.283  1.00  6.51           C  
ATOM    683  CG  PHE A  95      82.338  33.992  31.514  1.00  6.57           C  
ATOM    684  CD1 PHE A  95      82.851  35.179  32.021  1.00  7.43           C  
ATOM    685  CD2 PHE A  95      80.954  33.909  31.295  1.00  6.79           C  
ATOM    686  CE1 PHE A  95      82.041  36.279  32.299  1.00  7.20           C  
ATOM    687  CE2 PHE A  95      80.136  35.005  31.546  1.00  7.08           C  
ATOM    688  CZ  PHE A  95      80.667  36.183  32.074  1.00  7.03           C  
ATOM    689  N   THR A  96      84.742  30.068  32.310  1.00  6.49           N  
ATOM    690  CA  THR A  96      85.127  28.657  32.102  1.00  8.11           C  
ATOM    691  C   THR A  96      84.513  27.761  33.167  1.00  7.33           C  
ATOM    692  O   THR A  96      84.053  26.634  32.848  1.00  7.70           O  
ATOM    693  CB  THR A  96      86.693  28.506  32.062  1.00  9.27           C  
ATOM    694  OG1 THR A  96      87.118  29.325  30.953  1.00 11.25           O  
ATOM    695  CG2 THR A  96      87.135  27.048  31.920  1.00  9.94           C  
ATOM    696  N   GLU A  97      84.495  28.214  34.409  1.00  7.31           N  
ATOM    697  CA  GLU A  97      83.934  27.435  35.529  1.00  8.29           C  
ATOM    698  C   GLU A  97      82.476  27.126  35.288  1.00  7.86           C  
ATOM    699  O   GLU A  97      81.953  26.102  35.788  1.00  9.08           O  
ATOM    700  CB  GLU A  97      84.046  28.217  36.857  1.00  8.63           C  
ATOM    701  CG  GLU A  97      85.518  28.354  37.341  1.00  9.19           C  
ATOM    702  CD  GLU A  97      85.737  29.583  38.191  1.00  9.70           C  
ATOM    703  OE1 GLU A  97      84.783  30.206  38.638  1.00 10.55           O  
ATOM    704  OE2 GLU A  97      86.931  29.904  38.372  1.00 11.38           O  
ATOM    705  N   HIS A  98      81.771  27.958  34.528  1.00  7.67           N  
ATOM    706  CA  HIS A  98      80.353  27.780  34.242  1.00  7.40           C  
ATOM    707  C   HIS A  98      80.107  27.193  32.866  1.00  7.94           C  
ATOM    708  O   HIS A  98      78.957  27.268  32.380  1.00  8.19           O  
ATOM    709  CB  HIS A  98      79.609  29.151  34.409  1.00  7.48           C  
ATOM    710  CG  HIS A  98      79.655  29.592  35.840  1.00  7.83           C  
ATOM    711  ND1 HIS A  98      80.631  30.374  36.415  1.00  7.93           N  
ATOM    712  CD2 HIS A  98      78.747  29.319  36.831  1.00  8.60           C  
ATOM    713  CE1 HIS A  98      80.333  30.541  37.689  1.00  8.30           C  
ATOM    714  NE2 HIS A  98      79.207  29.931  37.976  1.00  9.30           N  
ATOM    715  N   ASN A  99      81.152  26.661  32.254  1.00  8.01           N  
ATOM    716  CA  ASN A  99      81.053  26.074  30.906  1.00  8.93           C  
ATOM    717  C   ASN A  99      80.300  27.025  29.979  1.00  7.82           C  
ATOM    718  O   ASN A  99      79.443  26.612  29.158  1.00  8.81           O  
ATOM    719  CB  ASN A  99      80.341  24.715  30.997  1.00 10.58           C  
ATOM    720  CG  ASN A  99      80.431  23.947  29.686  1.00 11.86           C  
ATOM    721  OD1 ASN A  99      81.424  24.110  28.955  1.00 13.08           O  
ATOM    722  ND2 ASN A  99      79.401  23.146  29.420  1.00 13.49           N  
ATOM    723  N   ALA A 100      80.648  28.299  30.064  1.00  7.10           N  
ATOM    724  CA  ALA A 100      79.973  29.360  29.329  1.00  7.43           C  
ATOM    725  C   ALA A 100      80.741  29.943  28.162  1.00  8.24           C  
ATOM    726  O   ALA A 100      81.944  30.185  28.323  1.00  9.53           O  
ATOM    727  CB  ALA A 100      79.662  30.503  30.321  1.00  7.38           C  
ATOM    728  N   THR A 101      80.040  30.167  27.064  1.00  7.83           N  
ATOM    729  CA  THR A 101      80.655  30.877  25.933  1.00  8.26           C  
ATOM    730  C   THR A 101      80.892  32.296  26.475  1.00  7.07           C  
ATOM    731  O   THR A 101      80.016  32.823  27.199  1.00  7.16           O  
ATOM    732  CB  THR A 101      79.677  30.908  24.698  1.00  9.39           C  
ATOM    733  OG1 THR A 101      79.516  29.510  24.318  1.00 10.96           O  
ATOM    734  CG2 THR A 101      80.175  31.770  23.540  1.00 10.68           C  
ATOM    735  N   PHE A 102      81.985  32.914  26.105  1.00  6.83           N  
ATOM    736  CA  PHE A 102      82.243  34.272  26.611  1.00  6.82           C  
ATOM    737  C   PHE A 102      81.271  35.288  26.010  1.00  6.10           C  
ATOM    738  O   PHE A 102      80.968  35.238  24.812  1.00  6.28           O  
ATOM    739  CB  PHE A 102      83.670  34.703  26.269  1.00  7.29           C  
ATOM    740  CG  PHE A 102      84.757  33.785  26.739  1.00  7.87           C  
ATOM    741  CD1 PHE A 102      85.692  33.247  25.860  1.00  8.98           C  
ATOM    742  CD2 PHE A 102      84.848  33.460  28.101  1.00  7.94           C  
ATOM    743  CE1 PHE A 102      86.700  32.398  26.295  1.00 10.13           C  
ATOM    744  CE2 PHE A 102      85.853  32.611  28.574  1.00  8.74           C  
ATOM    745  CZ  PHE A 102      86.776  32.075  27.656  1.00  9.67           C  
ATOM    746  N   PRO A 103      80.804  36.215  26.844  1.00  6.23           N  
ATOM    747  CA  PRO A 103      79.910  37.249  26.277  1.00  6.02           C  
ATOM    748  C   PRO A 103      80.679  38.229  25.384  1.00  4.53           C  
ATOM    749  O   PRO A 103      81.926  38.325  25.395  1.00  4.36           O  
ATOM    750  CB  PRO A 103      79.547  38.056  27.559  1.00  7.30           C  
ATOM    751  CG  PRO A 103      79.806  37.152  28.730  1.00  7.26           C  
ATOM    752  CD  PRO A 103      81.013  36.317  28.287  1.00  6.81           C  
ATOM    753  N   ALA A 104      79.916  39.014  24.629  1.00  4.08           N  
ATOM    754  CA  ALA A 104      80.461  40.218  23.987  1.00  3.99           C  
ATOM    755  C   ALA A 104      80.815  41.153  25.181  1.00  3.68           C  
ATOM    756  O   ALA A 104      80.249  41.040  26.297  1.00  4.10           O  
ATOM    757  CB  ALA A 104      79.458  40.847  23.083  1.00  4.60           C  
ATOM    758  N   ARG A 105      81.765  42.066  24.969  1.00  4.14           N  
ATOM    759  CA  ARG A 105      82.241  42.911  26.073  1.00  4.07           C  
ATOM    760  C   ARG A 105      82.784  44.246  25.637  1.00  3.75           C  
ATOM    761  O   ARG A 105      83.332  44.351  24.511  1.00  3.67           O  
ATOM    762  CB  ARG A 105      83.400  42.104  26.762  1.00  5.04           C  
ATOM    763  CG  ARG A 105      83.924  42.732  28.051  1.00  6.68           C  
ATOM    764  CD  ARG A 105      84.892  41.856  28.813  1.00  7.36           C  
ATOM    765  NE  ARG A 105      86.138  41.719  28.105  1.00  9.16           N  
ATOM    766  CZ  ARG A 105      87.248  41.171  28.646  1.00  9.60           C  
ATOM    767  NH1 ARG A 105      88.402  41.140  28.002  1.00 10.15           N  
ATOM    768  NH2 ARG A 105      87.181  40.592  29.845  1.00  9.57           N  
ATOM    769  N   SER A 106      82.593  45.232  26.506  1.00  3.97           N  
ATOM    770  CA  SER A 106      83.252  46.534  26.335  1.00  4.51           C  
ATOM    771  C   SER A 106      84.058  46.735  27.642  1.00  4.12           C  
ATOM    772  O   SER A 106      83.601  46.332  28.721  1.00  4.73           O  
ATOM    773  CB  SER A 106      82.338  47.701  26.123  1.00  5.49           C  
ATOM    774  OG  SER A 106      81.719  47.496  24.860  1.00  6.48           O  
HETATM  775  N   CSP A 107      85.227  47.354  27.505  1.00  4.52           N  
HETATM  776  CA  CSP A 107      86.120  47.538  28.646  1.00  5.72           C  
HETATM  777  CB  CSP A 107      87.294  46.582  28.632  0.67  8.42           C  
HETATM  779  SG  CSP A 107      86.908  44.861  28.444  0.67 12.80           S  
HETATM  781  C   CSP A 107      86.744  48.931  28.589  1.00  4.97           C  
HETATM  782  O   CSP A 107      87.374  49.269  27.550  1.00  4.62           O  
HETATM  783  P   CSP A 107      87.576  44.682  26.467  0.67 14.01           P  
HETATM  784  O1P CSP A 107      86.956  45.699  25.644  0.67 15.06           O  
HETATM  785  O2P CSP A 107      89.106  44.981  26.458  0.67 15.90           O  
HETATM  786  O3P CSP A 107      87.369  43.203  26.126  0.67 14.77           O  
ATOM    787  N   VAL A 108      86.645  49.666  29.668  1.00  4.59           N  
ATOM    788  CA  VAL A 108      87.227  51.021  29.700  1.00  4.55           C  
ATOM    789  C   VAL A 108      87.732  51.303  31.098  1.00  4.55           C  
ATOM    790  O   VAL A 108      87.199  50.759  32.086  1.00  4.69           O  
ATOM    791  CB  VAL A 108      86.149  52.075  29.304  1.00  4.96           C  
ATOM    792  CG1 VAL A 108      85.580  51.870  27.899  1.00  5.33           C  
ATOM    793  CG2 VAL A 108      85.039  52.225  30.329  1.00  6.15           C  
ATOM    794  N   GLU A 109      88.692  52.221  31.204  1.00  4.88           N  
ATOM    795  CA  GLU A 109      89.170  52.706  32.488  1.00  4.49           C  
ATOM    796  C   GLU A 109      88.427  54.021  32.775  1.00  4.13           C  
ATOM    797  O   GLU A 109      88.525  54.946  31.949  1.00  5.16           O  
ATOM    798  CB  GLU A 109      90.666  53.002  32.489  1.00  5.33           C  
ATOM    799  CG  GLU A 109      91.168  53.362  33.886  1.00  5.37           C  
ATOM    800  CD  GLU A 109      92.634  53.746  33.874  1.00  6.00           C  
ATOM    801  OE1 GLU A 109      92.966  54.843  34.330  1.00  7.16           O  
ATOM    802  OE2 GLU A 109      93.420  52.892  33.400  1.00  5.73           O  
ATOM    803  N   VAL A 110      87.709  54.063  33.881  1.00  4.12           N  
ATOM    804  CA  VAL A 110      86.992  55.293  34.266  1.00  5.16           C  
ATOM    805  C   VAL A 110      87.824  56.067  35.291  1.00  4.97           C  
ATOM    806  O   VAL A 110      88.871  55.560  35.732  1.00  5.83           O  
ATOM    807  CB  VAL A 110      85.623  54.929  34.858  1.00  5.61           C  
ATOM    808  CG1 VAL A 110      84.743  54.225  33.828  1.00  6.03           C  
ATOM    809  CG2 VAL A 110      85.739  54.094  36.124  1.00  5.94           C  
ATOM    810  N   ALA A 111      87.399  57.272  35.624  1.00  5.19           N  
ATOM    811  CA  ALA A 111      88.131  58.075  36.606  1.00  5.46           C  
ATOM    812  C   ALA A 111      87.927  57.595  38.033  1.00  5.34           C  
ATOM    813  O   ALA A 111      88.867  57.686  38.868  1.00  6.46           O  
ATOM    814  CB  ALA A 111      87.700  59.549  36.492  1.00  5.06           C  
ATOM    815  N   ARG A 112      86.730  57.113  38.361  1.00  5.42           N  
ATOM    816  CA  ARG A 112      86.421  56.685  39.730  1.00  5.97           C  
ATOM    817  C   ARG A 112      85.136  55.888  39.689  1.00  5.15           C  
ATOM    818  O   ARG A 112      84.300  56.070  38.779  1.00  5.33           O  
ATOM    819  CB  ARG A 112      86.227  57.928  40.609  1.00  5.86           C  
ATOM    820  CG  ARG A 112      86.287  57.681  42.105  1.00  7.01           C  
ATOM    821  CD  ARG A 112      86.071  58.962  42.856  1.00  7.87           C  
ATOM    822  NE  ARG A 112      86.119  58.698  44.292  1.00  9.03           N  
ATOM    823  CZ  ARG A 112      85.679  59.535  45.247  1.00  9.58           C  
ATOM    824  NH1 ARG A 112      85.788  59.145  46.529  1.00 10.53           N  
ATOM    825  NH2 ARG A 112      85.186  60.735  44.938  1.00 10.02           N  
ATOM    826  N   LEU A 113      84.981  55.000  40.652  1.00  5.16           N  
ATOM    827  CA  LEU A 113      83.806  54.147  40.791  1.00  5.23           C  
ATOM    828  C   LEU A 113      83.207  54.322  42.171  1.00  5.70           C  
ATOM    829  O   LEU A 113      83.886  54.779  43.116  1.00  6.10           O  
ATOM    830  CB  LEU A 113      84.222  52.687  40.573  1.00  5.50           C  
ATOM    831  CG  LEU A 113      84.617  52.347  39.140  1.00  5.34           C  
ATOM    832  CD1 LEU A 113      85.254  50.955  39.099  1.00  5.70           C  
ATOM    833  CD2 LEU A 113      83.412  52.417  38.206  1.00  4.99           C  
ATOM    834  N   PRO A 114      81.940  53.965  42.316  1.00  6.67           N  
ATOM    835  CA  PRO A 114      81.276  54.053  43.624  1.00  7.38           C  
ATOM    836  C   PRO A 114      82.124  53.323  44.666  1.00  7.04           C  
ATOM    837  O   PRO A 114      82.700  52.237  44.471  1.00  7.08           O  
ATOM    838  CB  PRO A 114      79.932  53.347  43.408  1.00  7.55           C  
ATOM    839  CG  PRO A 114      79.655  53.506  41.934  1.00  7.89           C  
ATOM    840  CD  PRO A 114      81.032  53.446  41.266  1.00  7.17           C  
ATOM    841  N   LYS A 115      82.219  53.947  45.840  1.00  7.96           N  
ATOM    842  CA  LYS A 115      82.948  53.434  47.006  1.00  9.22           C  
ATOM    843  C   LYS A 115      84.418  53.251  46.702  1.00  9.21           C  
ATOM    844  O   LYS A 115      85.056  52.484  47.457  1.00  9.21           O  
ATOM    845  CB  LYS A 115      82.356  52.099  47.469  1.00 10.55           C  
ATOM    846  CG  LYS A 115      80.882  52.248  47.862  1.00 12.98           C  
ATOM    847  CD  LYS A 115      80.433  50.930  48.508  1.00 15.15           C  
ATOM    848  CE  LYS A 115      79.110  51.098  49.227  1.00 16.92           C  
ATOM    849  NZ  LYS A 115      79.125  50.459  50.572  1.00 18.34           N  
ATOM    850  N   ASP A 116      84.950  53.880  45.680  1.00  8.41           N  
ATOM    851  CA  ASP A 116      86.365  53.735  45.327  1.00  8.14           C  
ATOM    852  C   ASP A 116      86.745  52.294  45.004  1.00  7.11           C  
ATOM    853  O   ASP A 116      87.936  51.919  45.171  1.00  8.04           O  
ATOM    854  CB  ASP A 116      87.288  54.380  46.378  1.00  9.13           C  
ATOM    855  CG  ASP A 116      87.175  55.908  46.280  1.00 10.16           C  
ATOM    856  OD1 ASP A 116      86.619  56.472  47.232  1.00 11.23           O  
ATOM    857  OD2 ASP A 116      87.631  56.455  45.266  1.00 10.06           O  
ATOM    858  N   VAL A 117      85.805  51.513  44.485  1.00  6.39           N  
ATOM    859  CA  VAL A 117      86.140  50.125  44.092  1.00  5.93           C  
ATOM    860  C   VAL A 117      87.010  50.177  42.828  1.00  5.45           C  
ATOM    861  O   VAL A 117      87.132  51.211  42.164  1.00  5.92           O  
ATOM    862  CB  VAL A 117      84.876  49.270  43.953  1.00  5.41           C  
ATOM    863  CG1 VAL A 117      84.094  49.096  45.257  1.00  6.56           C  
ATOM    864  CG2 VAL A 117      84.016  49.753  42.788  1.00  4.77           C  
ATOM    865  N   LYS A 118      87.550  49.040  42.486  1.00  5.60           N  
ATOM    866  CA  LYS A 118      88.428  48.926  41.330  1.00  5.78           C  
ATOM    867  C   LYS A 118      87.717  48.439  40.079  1.00  5.20           C  
ATOM    868  O   LYS A 118      88.324  48.480  39.015  1.00  4.89           O  
ATOM    869  CB  LYS A 118      89.565  47.958  41.665  1.00  6.48           C  
ATOM    870  CG  LYS A 118      90.483  48.409  42.792  1.00  8.03           C  
ATOM    871  CD  LYS A 118      91.521  47.406  43.267  1.00 10.35           C  
ATOM    872  CE  LYS A 118      92.324  47.954  44.444  1.00 12.02           C  
ATOM    873  NZ  LYS A 118      93.350  47.028  44.964  1.00 13.89           N  
ATOM    874  N   ILE A 119      86.471  47.988  40.191  1.00  4.72           N  
ATOM    875  CA  ILE A 119      85.745  47.423  39.054  1.00  4.45           C  
ATOM    876  C   ILE A 119      84.243  47.473  39.277  1.00  4.59           C  
ATOM    877  O   ILE A 119      83.789  47.404  40.418  1.00  4.61           O  
ATOM    878  CB  ILE A 119      86.272  45.958  38.832  1.00  4.91           C  
ATOM    879  CG1 ILE A 119      85.733  45.381  37.492  1.00  4.94           C  
ATOM    880  CG2 ILE A 119      85.942  45.002  40.007  1.00  5.42           C  
ATOM    881  CD1 ILE A 119      86.523  44.113  37.102  1.00  5.66           C  
ATOM    882  N   GLU A 120      83.522  47.607  38.173  1.00  4.02           N  
ATOM    883  CA  GLU A 120      82.053  47.584  38.177  1.00  3.81           C  
ATOM    884  C   GLU A 120      81.678  46.846  36.892  1.00  3.77           C  
ATOM    885  O   GLU A 120      82.200  47.192  35.813  1.00  4.01           O  
ATOM    886  CB  GLU A 120      81.456  48.973  38.189  1.00  4.09           C  
ATOM    887  CG  GLU A 120      79.933  49.013  38.197  1.00  4.28           C  
ATOM    888  CD  GLU A 120      79.330  50.389  38.167  1.00  4.49           C  
ATOM    889  OE1 GLU A 120      78.239  50.618  37.635  1.00  6.49           O  
ATOM    890  OE2 GLU A 120      80.023  51.293  38.736  1.00  5.06           O  
ATOM    891  N   ILE A 121      80.784  45.877  36.983  1.00  3.35           N  
ATOM    892  CA  ILE A 121      80.401  45.083  35.809  1.00  3.57           C  
ATOM    893  C   ILE A 121      78.891  44.989  35.684  1.00  3.38           C  
ATOM    894  O   ILE A 121      78.205  44.570  36.613  1.00  3.55           O  
ATOM    895  CB  ILE A 121      80.952  43.622  35.926  1.00  4.18           C  
ATOM    896  CG1 ILE A 121      82.465  43.622  36.169  1.00  5.00           C  
ATOM    897  CG2 ILE A 121      80.575  42.795  34.675  1.00  5.16           C  
ATOM    898  CD1 ILE A 121      83.075  42.217  36.388  1.00  5.62           C  
ATOM    899  N   GLU A 122      78.406  45.372  34.504  1.00  3.62           N  
ATOM    900  CA  GLU A 122      76.980  45.242  34.195  1.00  3.82           C  
ATOM    901  C   GLU A 122      76.850  44.137  33.146  1.00  3.47           C  
ATOM    902  O   GLU A 122      77.797  43.887  32.371  1.00  3.81           O  
ATOM    903  CB  GLU A 122      76.317  46.515  33.725  1.00  6.01           C  
ATOM    904  CG  GLU A 122      76.919  47.065  32.442  1.00  7.17           C  
ATOM    905  CD  GLU A 122      76.257  48.261  31.852  1.00  8.33           C  
ATOM    906  OE1 GLU A 122      76.443  48.508  30.651  1.00 10.86           O  
ATOM    907  OE2 GLU A 122      75.548  48.989  32.576  1.00  7.19           O  
ATOM    908  N   ALA A 123      75.697  43.487  33.125  1.00  4.17           N  
ATOM    909  CA  ALA A 123      75.509  42.376  32.197  1.00  4.16           C  
ATOM    910  C   ALA A 123      74.110  42.294  31.644  1.00  3.85           C  
ATOM    911  O   ALA A 123      73.137  42.767  32.269  1.00  4.05           O  
ATOM    912  CB  ALA A 123      75.780  41.036  32.901  1.00  5.43           C  
ATOM    913  N   ILE A 124      74.015  41.746  30.451  1.00  3.64           N  
ATOM    914  CA  ILE A 124      72.782  41.452  29.749  1.00  4.00           C  
ATOM    915  C   ILE A 124      72.776  39.936  29.504  1.00  3.37           C  
ATOM    916  O   ILE A 124      73.809  39.437  29.003  1.00  3.97           O  
ATOM    917  CB  ILE A 124      72.663  42.194  28.376  1.00  5.41           C  
ATOM    918  CG1 ILE A 124      72.584  43.713  28.609  1.00  6.98           C  
ATOM    919  CG2 ILE A 124      71.428  41.694  27.586  1.00  6.64           C  
ATOM    920  CD1 ILE A 124      72.704  44.513  27.290  1.00  8.60           C  
ATOM    921  N   ALA A 125      71.686  39.272  29.803  1.00  3.70           N  
ATOM    922  CA  ALA A 125      71.515  37.828  29.574  1.00  4.32           C  
ATOM    923  C   ALA A 125      70.191  37.605  28.838  1.00  3.88           C  
ATOM    924  O   ALA A 125      69.299  38.454  28.893  1.00  4.96           O  
ATOM    925  CB  ALA A 125      71.562  37.090  30.915  1.00  5.11           C  
ATOM    926  N   VAL A 126      70.108  36.479  28.118  1.00  4.73           N  
ATOM    927  CA  VAL A 126      68.867  36.173  27.389  1.00  5.32           C  
ATOM    928  C   VAL A 126      68.460  34.730  27.676  1.00  5.65           C  
ATOM    929  O   VAL A 126      69.286  33.856  27.898  1.00  6.01           O  
ATOM    930  CB  VAL A 126      68.980  36.410  25.867  1.00  6.36           C  
ATOM    931  CG1 VAL A 126      69.063  37.889  25.514  1.00  7.37           C  
ATOM    932  CG2 VAL A 126      70.090  35.599  25.249  1.00  7.21           C  
ATOM    933  N   ARG A 127      67.148  34.549  27.643  1.00  5.90           N  
ATOM    934  CA  ARG A 127      66.599  33.189  27.849  1.00  8.86           C  
ATOM    935  C   ARG A 127      66.751  32.308  26.604  1.00 10.67           C  
ATOM    936  O   ARG A 127      66.942  31.080  26.802  1.00 12.25           O  
ATOM    937  CB  ARG A 127      65.109  33.204  28.178  1.00  8.97           C  
ATOM    938  CG  ARG A 127      64.826  33.997  29.431  1.00  8.83           C  
ATOM    939  CD  ARG A 127      63.397  33.712  29.903  1.00  9.65           C  
ATOM    940  NE  ARG A 127      63.123  34.558  31.053  1.00  8.63           N  
ATOM    941  CZ  ARG A 127      63.526  34.285  32.273  1.00  8.65           C  
ATOM    942  NH1 ARG A 127      64.095  33.137  32.600  1.00  8.88           N  
ATOM    943  NH2 ARG A 127      63.456  35.247  33.194  1.00  8.68           N  
ATOM    944  N   ARG A 128      66.639  32.891  25.442  1.00 12.46           N  
ATOM    945  CA  ARG A 128      66.732  32.183  24.160  1.00 14.89           C  
ATOM    946  C   ARG A 128      67.932  32.623  23.312  1.00 16.10           C  
ATOM    947  O   ARG A 128      68.218  33.849  23.395  1.00 17.58           O  
ATOM    948  CB  ARG A 128      65.448  32.437  23.339  1.00 15.67           C  
ATOM    949  OXT ARG A 128      68.023  32.027  22.206  1.00 17.72           O  
TER     950      ARG A 128                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
