
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  221 ( 1738),  selected  221 , name 1vpa_A
# Molecule2: number of CA atoms  178 ( 1356),  selected  178 , name T0420.pdb
# PARAMETERS: 1vpa_A.T0420.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -1_A      -       -           -
LGA    H     0_A      M       1          3.019
LGA    M     1_A      N       2          1.902
LGA    N     2_A      I       3          1.280
LGA    V     3_A      G       4          0.882
LGA    A     4_A      V       5          0.619
LGA    I     5_A      I       6          1.029
LGA    L     6_A      I       7          0.900
LGA    L     7_A      L       8          1.300
LGA    A     8_A      A       9          0.996
LGA    A     9_A      A      10          1.212
LGA    G    10_A      G      11          2.727
LGA    -       -      E      12           -
LGA    -       -      G      13           -
LGA    -       -      K      14           -
LGA    K    11_A      R      15          3.708
LGA    G    12_A      F      16          3.336
LGA    E    13_A      G      17           -
LGA    R    14_A      G      18           -
LGA    M    15_A      -       -           -
LGA    S    16_A      -       -           -
LGA    E    17_A      -       -           -
LGA    N    18_A      -       -           -
LGA    V    19_A      D      19          2.887
LGA    P    20_A      K      20          2.711
LGA    K    21_A      -       -           -
LGA    Q    22_A      L      21          2.181
LGA    F    23_A      L      22          2.272
LGA    L    24_A      A      23          1.619
LGA    E    25_A      K      24          1.798
LGA    I    26_A      I      25          2.135
LGA    E    27_A      D      26          2.209
LGA    G    28_A      N      27          2.134
LGA    R    29_A      T      28          1.578
LGA    M    30_A      P      29          1.300
LGA    L    31_A      I      30          0.808
LGA    F    32_A      I      31          1.352
LGA    E    33_A      M      32          1.197
LGA    Y    34_A      R      33          1.245
LGA    P    35_A      T      34          1.953
LGA    L    36_A      I      35          0.591
LGA    S    37_A      R      36          0.979
LGA    T    38_A      I      37          1.395
LGA    F    39_A      Y      38          1.057
LGA    L    40_A      G      39          2.159
LGA    K    41_A      D      40          4.461
LGA    S    42_A      -       -           -
LGA    E    43_A      -       -           -
LGA    A    44_A      -       -           -
LGA    I    45_A      -       -           -
LGA    D    46_A      L      41          3.708
LGA    G    47_A      E      42          0.796
LGA    V    48_A      K      43          0.412
LGA    V    49_A      I      44          0.746
LGA    I    50_A      I      45          0.512
LGA    V    51_A      I      46          1.261
LGA    T    52_A      V      47          1.601
LGA    R    53_A      G      48          0.712
LGA    R    54_A      K      49          5.364
LGA    E    55_A      Y      50          3.269
LGA    W    56_A      V      51          1.717
LGA    F    57_A      -       -           -
LGA    E    58_A      N      52          4.025
LGA    V    59_A      E      53          3.479
LGA    V    60_A      M      54          3.276
LGA    E    61_A      L      55          3.006
LGA    K    62_A      P      56          2.010
LGA    R    63_A      L      57          1.877
LGA    V    64_A      L      58          2.737
LGA    F    65_A      M      59          4.576
LGA    H    66_A      D      60          4.130
LGA    E    67_A      -       -           -
LGA    K    68_A      -       -           -
LGA    V    69_A      -       -           -
LGA    L    70_A      Q      61           #
LGA    G    71_A      I      62          2.371
LGA    I    72_A      V      63          1.098
LGA    V    73_A      I      64          1.816
LGA    E    74_A      Y      65          2.867
LGA    -       -      N      66           -
LGA    -       -      P      67           -
LGA    G    75_A      F      68           #
LGA    G    76_A      W      69          2.556
LGA    D    77_A      N      70          3.331
LGA    -       -      E      71           -
LGA    T    78_A      G      72          2.489
LGA    R    79_A      I      73          2.732
LGA    S    80_A      S      74          2.764
LGA    Q    81_A      T      75          2.585
LGA    S    82_A      S      76          2.055
LGA    V    83_A      L      77          1.292
LGA    R    84_A      K      78          1.528
LGA    S    85_A      L      79          1.754
LGA    A    86_A      G      80          1.028
LGA    L    87_A      L      81          0.895
LGA    E    88_A      R      82          2.361
LGA    F    89_A      F      83          3.426
LGA    L    90_A      F      84          3.028
LGA    E    91_A      K      85          3.431
LGA    K    92_A      -       -           -
LGA    F    93_A      -       -           -
LGA    S    94_A      D      86          2.266
LGA    P    95_A      Y      87          1.704
LGA    S    96_A      D      88          1.762
LGA    Y    97_A      A      89          1.707
LGA    V    98_A      V      90          0.690
LGA    L    99_A      L      91          0.395
LGA    V   100_A      V      92          0.858
LGA    H   101_A      A      93          1.293
LGA    D   102_A      L      94          1.476
LGA    S   103_A      G      95          1.693
LGA    A   104_A      D      96          1.512
LGA    R   105_A      M      97          1.476
LGA    P   106_A      P      98          0.508
LGA    F   107_A      F      99          1.608
LGA    L   108_A      V     100          2.289
LGA    R   109_A      T     101          1.585
LGA    K   110_A      K     102          1.719
LGA    K   111_A      E     103          1.900
LGA    H   112_A      D     104          1.348
LGA    V   113_A      V     105          1.105
LGA    S   114_A      N     106          2.051
LGA    E   115_A      K     107          1.598
LGA    V   116_A      I     108          1.019
LGA    L   117_A      I     109          1.606
LGA    R   118_A      N     110          2.516
LGA    R   119_A      T     111          1.723
LGA    A   120_A      F     112          2.464
LGA    R   121_A      K     113          2.951
LGA    E   122_A      P     114          3.709
LGA    T   123_A      N     115          3.311
LGA    G   124_A      C     116          3.155
LGA    -       -      K     117           -
LGA    A   125_A      A     118          0.638
LGA    A   126_A      V     119          0.819
LGA    T   127_A      I     120          1.189
LGA    L   128_A      P     121          0.897
LGA    A   129_A      T     122          1.449
LGA    L   130_A      H     123          1.652
LGA    K   131_A      K     124          1.865
LGA    N   132_A      G     125          4.417
LGA    S   133_A      -       -           -
LGA    D   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    L   136_A      -       -           -
LGA    V   137_A      -       -           -
LGA    R   138_A      -       -           -
LGA    V   139_A      -       -           -
LGA    E   140_A      -       -           -
LGA    N   141_A      -       -           -
LGA    D   142_A      -       -           -
LGA    R   143_A      -       -           -
LGA    I   144_A      -       -           -
LGA    E   145_A      -       -           -
LGA    Y   146_A      -       -           -
LGA    I   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    R   149_A      -       -           -
LGA    K   150_A      -       -           -
LGA    G   151_A      -       -           -
LGA    V   152_A      -       -           -
LGA    Y   153_A      -       -           -
LGA    R   154_A      E     126          2.332
LGA    I   155_A      R     127          2.166
LGA    L   156_A      G     128          1.060
LGA    T   157_A      N     129          0.617
LGA    P   158_A      P     130          1.299
LGA    Q   159_A      V     131          0.651
LGA    A   160_A      L     132          0.442
LGA    F   161_A      I     133          1.876
LGA    S   162_A      S     134          1.717
LGA    Y   163_A      K     135          2.909
LGA    E   164_A      -       -           -
LGA    I   165_A      S     136          2.363
LGA    L   166_A      L     137          3.125
LGA    K   167_A      F     138          1.422
LGA    K   168_A      N     139          1.351
LGA    A   169_A      E     140          1.402
LGA    H   170_A      I     141          1.607
LGA    E   171_A      E     142          2.881
LGA    N   172_A      K     143          1.940
LGA    G   173_A      L     144          1.900
LGA    G   174_A      R     145          3.875
LGA    -       -      G     146           -
LGA    E   175_A      D     147          4.853
LGA    W   176_A      V     148          3.793
LGA    A   177_A      G     149           #
LGA    D   178_A      -       -           -
LGA    D   179_A      A     150          2.483
LGA    T   180_A      R     151          4.416
LGA    E   181_A      V     152          3.434
LGA    P   182_A      I     153          0.375
LGA    V   183_A      L     154          3.825
LGA    Q   184_A      N     155          4.709
LGA    K   185_A      K     156          2.735
LGA    L   186_A      I     157          5.012
LGA    G   187_A      K     158          4.386
LGA    V   188_A      I     159           #
LGA    -       -      E     160           -
LGA    K   189_A      E     161          2.130
LGA    I   190_A      L     162          1.895
LGA    A   191_A      C     163          1.394
LGA    L   192_A      F     164          1.497
LGA    V   193_A      I     165          1.216
LGA    E   194_A      E     166          0.419
LGA    G   195_A      C     167          1.871
LGA    D   196_A      S     168          2.126
LGA    P   197_A      E     169          1.831
LGA    L   198_A      G     170          2.854
LGA    C   199_A      V     171          2.931
LGA    F   200_A      L     172          3.472
LGA    K   201_A      I     173          2.734
LGA    -       -      D     174           -
LGA    V   202_A      I     175          1.694
LGA    T   203_A      D     176          1.731
LGA    F   204_A      K     177          5.328
LGA    K   205_A      -       -           -
LGA    E   206_A      -       -           -
LGA    D   207_A      K     178          2.208
LGA    L   208_A      -       -           -
LGA    E   209_A      -       -           -
LGA    L   210_A      -       -           -
LGA    A   211_A      -       -           -
LGA    R   212_A      -       -           -
LGA    I   213_A      -       -           -
LGA    I   214_A      -       -           -
LGA    A   215_A      -       -           -
LGA    R   216_A      -       -           -
LGA    E   217_A      -       -           -
LGA    W   218_A      -       -           -
LGA    E   219_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  221  178    5.0    162    2.38    16.05     60.518     6.538

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.526276 * X  +   0.354362 * Y  +   0.772956 * Z  +  42.056065
  Y_new =  -0.613275 * X  +  -0.787856 * Y  +  -0.056363 * Z  + 194.218307
  Z_new =   0.589005 * X  +  -0.503697 * Y  +   0.631951 * Z  + 131.384964 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.672940    2.468653  [ DEG:   -38.5566    141.4434 ]
  Theta =  -0.629827   -2.511765  [ DEG:   -36.0864   -143.9136 ]
  Phi   =  -2.279997    0.861595  [ DEG:  -130.6342     49.3658 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vpa_A                                        
REMARK     2: T0420.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vpa_A.T0420.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  221  178   5.0  162   2.38   16.05  60.518
REMARK  ---------------------------------------------------------- 
MOLECULE 1vpa_A
HEADER    TRANSFERASE                             14-OCT-04   1VPA              
TITLE     CRYSTAL STRUCTURE OF 2-C-METHYL-D-ERYTHRITOL 4-PHOSPHATE              
TITLE    2 CYTIDYLYLTRANSFERASE (TM1393) FROM THERMOTOGA MARITIMA AT            
TITLE    3 2.67 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 2-C-METHYL-D-ERYTHRITOL 4-PHOSPHATE                        
COMPND   3 CYTIDYLYLTRANSFERASE;                                                
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 SYNONYM: 4-DIPHOSPHOCYTIDYL-2C-METHYL-D-ERYTHRITOL                   
COMPND   6 SYNTHASE, MEP CYTIDYLYLTRANSFERASE, MCT;                             
COMPND   7 EC: 2.7.7.60;                                                        
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TM1393, ISPD;                                                  
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    TM1393, 2-C-METHYL-D-ERYTHRITOL 4-PHOSPHATE                           
KEYWDS   2 CYTIDYLYLTRANSFERASE, STRUCTURAL GENOMICS, JCSG, JOINT               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE               
KEYWDS   4 INITIATIVE                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   2   18-JAN-05 1VPA    1       REMARK                                   
REVDAT   1   02-NOV-04 1VPA    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF 2-C-METHYL-D-ERYTHRITOL                 
JRNL        TITL 2 4-PHOSPHATE CYTIDYLYLTRANSFERASE (TM1393) FROM               
JRNL        TITL 3 THERMOTOGA MARITIMA AT 2.67 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.67 ANGSTROMS.                                          
DBREF  1VPA A    1   222  UNP    Q9X1B3   ISPD_THEMA       1    222             
DBREF  1VPA B    1   222  UNP    Q9X1B3   ISPD_THEMA       1    222             
SEQRES   1 A  234  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 A  234  ASN VAL ALA ILE LEU LEU ALA ALA GLY LYS GLY GLU ARG          
SEQRES   3 A  234  MET SER GLU ASN VAL PRO LYS GLN PHE LEU GLU ILE GLU          
SEQRES   4 A  234  GLY ARG MET LEU PHE GLU TYR PRO LEU SER THR PHE LEU          
SEQRES   5 A  234  LYS SER GLU ALA ILE ASP GLY VAL VAL ILE VAL THR ARG          
SEQRES   6 A  234  ARG GLU TRP PHE GLU VAL VAL GLU LYS ARG VAL PHE HIS          
SEQRES   7 A  234  GLU LYS VAL LEU GLY ILE VAL GLU GLY GLY ASP THR ARG          
SEQRES   8 A  234  SER GLN SER VAL ARG SER ALA LEU GLU PHE LEU GLU LYS          
SEQRES   9 A  234  PHE SER PRO SER TYR VAL LEU VAL HIS ASP SER ALA ARG          
SEQRES  10 A  234  PRO PHE LEU ARG LYS LYS HIS VAL SER GLU VAL LEU ARG          
SEQRES  11 A  234  ARG ALA ARG GLU THR GLY ALA ALA THR LEU ALA LEU LYS          
SEQRES  12 A  234  ASN SER ASP ALA LEU VAL ARG VAL GLU ASN ASP ARG ILE          
SEQRES  13 A  234  GLU TYR ILE PRO ARG LYS GLY VAL TYR ARG ILE LEU THR          
SEQRES  14 A  234  PRO GLN ALA PHE SER TYR GLU ILE LEU LYS LYS ALA HIS          
SEQRES  15 A  234  GLU ASN GLY GLY GLU TRP ALA ASP ASP THR GLU PRO VAL          
SEQRES  16 A  234  GLN LYS LEU GLY VAL LYS ILE ALA LEU VAL GLU GLY ASP          
SEQRES  17 A  234  PRO LEU CYS PHE LYS VAL THR PHE LYS GLU ASP LEU GLU          
SEQRES  18 A  234  LEU ALA ARG ILE ILE ALA ARG GLU TRP GLU ARG ILE PRO          
SEQRES   1 B  234  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 B  234  ASN VAL ALA ILE LEU LEU ALA ALA GLY LYS GLY GLU ARG          
SEQRES   3 B  234  MET SER GLU ASN VAL PRO LYS GLN PHE LEU GLU ILE GLU          
SEQRES   4 B  234  GLY ARG MET LEU PHE GLU TYR PRO LEU SER THR PHE LEU          
SEQRES   5 B  234  LYS SER GLU ALA ILE ASP GLY VAL VAL ILE VAL THR ARG          
SEQRES   6 B  234  ARG GLU TRP PHE GLU VAL VAL GLU LYS ARG VAL PHE HIS          
SEQRES   7 B  234  GLU LYS VAL LEU GLY ILE VAL GLU GLY GLY ASP THR ARG          
SEQRES   8 B  234  SER GLN SER VAL ARG SER ALA LEU GLU PHE LEU GLU LYS          
SEQRES   9 B  234  PHE SER PRO SER TYR VAL LEU VAL HIS ASP SER ALA ARG          
SEQRES  10 B  234  PRO PHE LEU ARG LYS LYS HIS VAL SER GLU VAL LEU ARG          
SEQRES  11 B  234  ARG ALA ARG GLU THR GLY ALA ALA THR LEU ALA LEU LYS          
SEQRES  12 B  234  ASN SER ASP ALA LEU VAL ARG VAL GLU ASN ASP ARG ILE          
SEQRES  13 B  234  GLU TYR ILE PRO ARG LYS GLY VAL TYR ARG ILE LEU THR          
SEQRES  14 B  234  PRO GLN ALA PHE SER TYR GLU ILE LEU LYS LYS ALA HIS          
SEQRES  15 B  234  GLU ASN GLY GLY GLU TRP ALA ASP ASP THR GLU PRO VAL          
SEQRES  16 B  234  GLN LYS LEU GLY VAL LYS ILE ALA LEU VAL GLU GLY ASP          
SEQRES  17 B  234  PRO LEU CYS PHE LYS VAL THR PHE LYS GLU ASP LEU GLU          
SEQRES  18 B  234  LEU ALA ARG ILE ILE ALA ARG GLU TRP GLU ARG ILE PRO          
HET     MG  A 600       1                                                       
HET     MG  B 600       1                                                       
HET    CTP  A 500      29                                                       
HET    CTP  B 500      29                                                       
HET    ACY  A 700       4                                                       
HET    ACY  B 700       4                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     CTP CYTIDINE-5'-TRIPHOSPHATE                                         
HETNAM     ACY ACETIC ACID                                                      
FORMUL   3   MG    2(MG 2+)                                                     
FORMUL   5  CTP    2(C9 H16 N3 O14 P3)                                          
FORMUL   7  ACY    2(C2 H4 O2)                                                  
FORMUL   9  HOH   *119(H2 O)                                                    
CRYST1  144.230  144.230   53.724  90.00  90.00 120.00 P 61         12          
ATOM      1  N   HIS A  -1      66.933 103.594  43.906  1.00 50.41           N  
ATOM      2  CA  HIS A  -1      67.506 103.766  45.292  1.00 50.15           C  
ATOM      3  C   HIS A  -1      69.031 103.817  45.208  1.00 49.42           C  
ATOM      4  O   HIS A  -1      69.661 103.032  44.475  1.00 49.52           O  
ATOM      5  CB  HIS A  -1      67.049 102.636  46.239  1.00 50.27           C  
ATOM      6  CG  HIS A  -1      67.508 102.793  47.667  1.00 51.21           C  
ATOM      7  ND1 HIS A  -1      67.013 103.765  48.515  1.00 51.88           N  
ATOM      8  CD2 HIS A  -1      68.382 102.063  48.408  1.00 51.61           C  
ATOM      9  CE1 HIS A  -1      67.581 103.645  49.704  1.00 51.70           C  
ATOM     10  NE2 HIS A  -1      68.413 102.619  49.666  1.00 51.58           N  
ATOM     11  N   HIS A   0      69.613 104.764  45.940  1.00 48.33           N  
ATOM     12  CA  HIS A   0      71.063 104.928  45.970  1.00 47.44           C  
ATOM     13  C   HIS A   0      71.531 105.014  47.411  1.00 46.14           C  
ATOM     14  O   HIS A   0      71.776 106.100  47.934  1.00 46.83           O  
ATOM     15  CB  HIS A   0      71.502 106.144  45.143  1.00 47.48           C  
ATOM     16  CG  HIS A   0      71.447 105.903  43.668  1.00 47.87           C  
ATOM     17  ND1 HIS A   0      72.324 105.054  43.023  1.00 48.39           N  
ATOM     18  CD2 HIS A   0      70.603 106.365  42.714  1.00 48.66           C  
ATOM     19  CE1 HIS A   0      72.031 105.013  41.734  1.00 48.45           C  
ATOM     20  NE2 HIS A   0      70.987 105.794  41.520  1.00 48.88           N  
ATOM     21  N   MET A   1      71.653 103.843  48.029  1.00 44.21           N  
ATOM     22  CA  MET A   1      72.070 103.703  49.421  1.00 42.46           C  
ATOM     23  C   MET A   1      73.377 104.433  49.747  1.00 41.03           C  
ATOM     24  O   MET A   1      74.399 104.221  49.092  1.00 40.66           O  
ATOM     25  CB  MET A   1      72.234 102.223  49.741  1.00 42.31           C  
ATOM     26  CG  MET A   1      72.345 101.933  51.202  1.00 42.32           C  
ATOM     27  SD  MET A   1      72.759 100.212  51.493  1.00 41.53           S  
ATOM     28  CE  MET A   1      72.579 100.179  53.271  1.00 41.73           C  
ATOM     29  N   ASN A   2      73.328 105.284  50.765  1.00 39.44           N  
ATOM     30  CA  ASN A   2      74.520 105.918  51.317  1.00 38.58           C  
ATOM     31  C   ASN A   2      74.896 105.327  52.662  1.00 37.67           C  
ATOM     32  O   ASN A   2      74.147 105.439  53.639  1.00 37.32           O  
ATOM     33  CB  ASN A   2      74.313 107.410  51.520  1.00 38.59           C  
ATOM     34  CG  ASN A   2      73.738 108.083  50.314  1.00 38.36           C  
ATOM     35  OD1 ASN A   2      74.111 107.787  49.183  1.00 37.59           O  
ATOM     36  ND2 ASN A   2      72.815 109.002  50.548  1.00 37.97           N  
ATOM     37  N   VAL A   3      76.073 104.725  52.714  1.00 36.87           N  
ATOM     38  CA  VAL A   3      76.591 104.203  53.951  1.00 36.56           C  
ATOM     39  C   VAL A   3      77.808 104.988  54.435  1.00 36.07           C  
ATOM     40  O   VAL A   3      78.676 105.372  53.657  1.00 35.38           O  
ATOM     41  CB  VAL A   3      76.943 102.733  53.809  1.00 36.76           C  
ATOM     42  CG1 VAL A   3      77.760 102.249  55.021  1.00 37.81           C  
ATOM     43  CG2 VAL A   3      75.673 101.919  53.657  1.00 36.13           C  
ATOM     44  N   ALA A   4      77.832 105.205  55.748  1.00 35.81           N  
ATOM     45  CA  ALA A   4      78.891 105.914  56.435  1.00 35.42           C  
ATOM     46  C   ALA A   4      79.803 104.955  57.187  1.00 35.12           C  
ATOM     47  O   ALA A   4      79.356 104.001  57.837  1.00 35.29           O  
ATOM     48  CB  ALA A   4      78.287 106.908  57.400  1.00 35.67           C  
ATOM     49  N   ILE A   5      81.095 105.220  57.107  1.00 34.83           N  
ATOM     50  CA  ILE A   5      82.084 104.384  57.762  1.00 34.17           C  
ATOM     51  C   ILE A   5      82.788 105.220  58.794  1.00 33.93           C  
ATOM     52  O   ILE A   5      83.467 106.208  58.456  1.00 33.87           O  
ATOM     53  CB  ILE A   5      83.094 103.889  56.766  1.00 34.12           C  
ATOM     54  CG1 ILE A   5      82.397 102.944  55.782  1.00 33.93           C  
ATOM     55  CG2 ILE A   5      84.274 103.236  57.500  1.00 34.36           C  
ATOM     56  CD1 ILE A   5      83.196 102.650  54.534  1.00 34.63           C  
ATOM     57  N   LEU A   6      82.634 104.816  60.047  1.00 33.58           N  
ATOM     58  CA  LEU A   6      83.249 105.526  61.150  1.00 33.68           C  
ATOM     59  C   LEU A   6      84.523 104.794  61.574  1.00 33.51           C  
ATOM     60  O   LEU A   6      84.473 103.686  62.136  1.00 33.03           O  
ATOM     61  CB  LEU A   6      82.265 105.667  62.317  1.00 33.95           C  
ATOM     62  CG  LEU A   6      82.695 106.638  63.423  1.00 33.79           C  
ATOM     63  CD1 LEU A   6      83.063 107.982  62.857  1.00 33.20           C  
ATOM     64  CD2 LEU A   6      81.611 106.792  64.464  1.00 33.99           C  
ATOM     65  N   LEU A   7      85.663 105.422  61.272  1.00 33.37           N  
ATOM     66  CA  LEU A   7      86.977 104.861  61.564  1.00 33.27           C  
ATOM     67  C   LEU A   7      87.352 105.119  63.015  1.00 32.79           C  
ATOM     68  O   LEU A   7      87.517 106.260  63.410  1.00 33.08           O  
ATOM     69  CB  LEU A   7      88.016 105.497  60.647  1.00 33.46           C  
ATOM     70  CG  LEU A   7      87.812 105.235  59.153  1.00 33.98           C  
ATOM     71  CD1 LEU A   7      88.877 105.945  58.270  1.00 33.34           C  
ATOM     72  CD2 LEU A   7      87.788 103.719  58.891  1.00 34.32           C  
ATOM     73  N   ALA A   8      87.477 104.057  63.800  1.00 32.53           N  
ATOM     74  CA  ALA A   8      87.812 104.161  65.223  1.00 32.56           C  
ATOM     75  C   ALA A   8      88.633 102.950  65.667  1.00 32.48           C  
ATOM     76  O   ALA A   8      88.406 102.387  66.758  1.00 32.69           O  
ATOM     77  CB  ALA A   8      86.531 104.277  66.056  1.00 32.63           C  
ATOM     78  N   ALA A   9      89.575 102.571  64.800  1.00 32.41           N  
ATOM     79  CA  ALA A   9      90.506 101.459  65.009  1.00 32.31           C  
ATOM     80  C   ALA A   9      91.931 101.910  65.344  1.00 32.76           C  
ATOM     81  O   ALA A   9      92.788 101.079  65.708  1.00 33.72           O  
ATOM     82  CB  ALA A   9      90.531 100.573  63.793  1.00 31.86           C  
ATOM     83  N   GLY A  10      92.195 103.206  65.228  1.00 32.86           N  
ATOM     84  CA  GLY A  10      93.506 103.746  65.575  1.00 32.90           C  
ATOM     85  C   GLY A  10      93.833 103.721  67.062  1.00 33.07           C  
ATOM     86  O   GLY A  10      92.963 103.440  67.914  1.00 32.18           O  
ATOM     87  N   LYS A  11      95.095 104.030  67.369  1.00 33.44           N  
ATOM     88  CA  LYS A  11      95.627 103.896  68.729  1.00 34.01           C  
ATOM     89  C   LYS A  11      95.947 105.264  69.380  1.00 34.65           C  
ATOM     90  O   LYS A  11      96.069 105.367  70.614  1.00 34.77           O  
ATOM     91  CB  LYS A  11      96.841 102.966  68.699  1.00 33.81           C  
ATOM     92  CG  LYS A  11      96.653 101.758  67.750  1.00 34.00           C  
ATOM     93  CD  LYS A  11      97.743 100.686  67.916  1.00 34.25           C  
ATOM     94  N   GLY A  12      96.047 106.317  68.568  1.00 34.94           N  
ATOM     95  CA  GLY A  12      96.279 107.662  69.091  1.00 35.31           C  
ATOM     96  C   GLY A  12      97.596 107.784  69.819  1.00 35.60           C  
ATOM     97  O   GLY A  12      97.674 108.345  70.904  1.00 35.48           O  
ATOM     98  N   GLU A  13      98.643 107.255  69.202  1.00 36.36           N  
ATOM     99  CA  GLU A  13      99.951 107.214  69.830  1.00 36.96           C  
ATOM    100  C   GLU A  13     100.465 108.593  70.121  1.00 36.95           C  
ATOM    101  O   GLU A  13     101.085 108.804  71.151  1.00 37.29           O  
ATOM    102  CB  GLU A  13     100.948 106.480  68.950  1.00 37.22           C  
ATOM    103  CG  GLU A  13     100.585 105.017  68.739  1.00 39.37           C  
ATOM    104  CD  GLU A  13     101.698 104.246  68.067  1.00 42.26           C  
ATOM    105  OE1 GLU A  13     102.827 104.793  67.966  1.00 43.71           O  
ATOM    106  OE2 GLU A  13     101.438 103.098  67.636  1.00 44.46           O  
ATOM    107  N   ARG A  14     100.196 109.539  69.228  1.00 37.26           N  
ATOM    108  CA  ARG A  14     100.664 110.913  69.416  1.00 37.61           C  
ATOM    109  C   ARG A  14      99.966 111.657  70.569  1.00 38.15           C  
ATOM    110  O   ARG A  14     100.442 112.697  71.004  1.00 38.09           O  
ATOM    111  CB  ARG A  14     100.571 111.695  68.104  1.00 37.62           C  
ATOM    112  CG  ARG A  14     101.514 111.144  67.013  1.00 37.34           C  
ATOM    113  CD  ARG A  14     101.307 111.842  65.694  1.00 36.71           C  
ATOM    114  NE  ARG A  14     100.057 111.420  65.081  1.00 36.71           N  
ATOM    115  CZ  ARG A  14      99.439 112.046  64.081  1.00 37.00           C  
ATOM    116  NH1 ARG A  14      99.941 113.153  63.553  1.00 36.78           N  
ATOM    117  NH2 ARG A  14      98.304 111.554  63.602  1.00 36.71           N  
ATOM    118  N   MET A  15      98.857 111.113  71.062  1.00 38.85           N  
ATOM    119  CA  MET A  15      98.139 111.679  72.208  1.00 39.42           C  
ATOM    120  C   MET A  15      98.893 111.499  73.520  1.00 39.91           C  
ATOM    121  O   MET A  15      98.719 112.282  74.460  1.00 39.48           O  
ATOM    122  CB  MET A  15      96.782 110.988  72.356  1.00 39.41           C  
ATOM    123  CG  MET A  15      95.824 111.274  71.244  1.00 39.29           C  
ATOM    124  SD  MET A  15      95.321 113.016  71.208  1.00 39.62           S  
ATOM    125  CE  MET A  15      94.663 113.297  72.854  1.00 39.33           C  
ATOM    126  N   SER A  16      99.684 110.428  73.574  1.00 40.46           N  
ATOM    127  CA  SER A  16     100.371 109.989  74.778  1.00 40.85           C  
ATOM    128  C   SER A  16      99.382 109.776  75.941  1.00 41.07           C  
ATOM    129  O   SER A  16      99.510 110.376  77.007  1.00 41.63           O  
ATOM    130  CB  SER A  16     101.505 110.963  75.134  1.00 40.98           C  
ATOM    131  OG  SER A  16     102.574 110.305  75.803  1.00 40.71           O  
ATOM    132  N   GLU A  17      98.393 108.916  75.706  1.00 41.15           N  
ATOM    133  CA  GLU A  17      97.461 108.452  76.742  1.00 41.09           C  
ATOM    134  C   GLU A  17      97.450 106.919  76.801  1.00 40.63           C  
ATOM    135  O   GLU A  17      97.943 106.250  75.887  1.00 40.46           O  
ATOM    136  CB  GLU A  17      96.043 108.947  76.435  1.00 41.42           C  
ATOM    137  CG  GLU A  17      95.877 110.472  76.379  1.00 42.29           C  
ATOM    138  CD  GLU A  17      95.947 111.127  77.755  1.00 43.35           C  
ATOM    139  OE1 GLU A  17      95.783 110.388  78.757  1.00 43.23           O  
ATOM    140  OE2 GLU A  17      96.166 112.368  77.832  1.00 42.93           O  
ATOM    141  N   ASN A  18      96.867 106.368  77.867  1.00 40.04           N  
ATOM    142  CA  ASN A  18      96.645 104.921  77.970  1.00 39.59           C  
ATOM    143  C   ASN A  18      95.623 104.398  76.985  1.00 38.77           C  
ATOM    144  O   ASN A  18      95.684 103.246  76.570  1.00 39.64           O  
ATOM    145  CB  ASN A  18      96.101 104.566  79.343  1.00 39.79           C  
ATOM    146  CG  ASN A  18      97.172 104.443  80.374  1.00 40.97           C  
ATOM    147  OD1 ASN A  18      98.085 105.278  80.437  1.00 42.35           O  
ATOM    148  ND2 ASN A  18      97.074 103.400  81.212  1.00 41.13           N  
ATOM    149  N   VAL A  19      94.661 105.248  76.655  1.00 37.36           N  
ATOM    150  CA  VAL A  19      93.434 104.872  75.992  1.00 36.05           C  
ATOM    151  C   VAL A  19      93.376 105.597  74.652  1.00 35.40           C  
ATOM    152  O   VAL A  19      93.652 106.802  74.577  1.00 35.26           O  
ATOM    153  CB  VAL A  19      92.227 105.308  76.883  1.00 36.04           C  
ATOM    154  CG1 VAL A  19      90.900 105.078  76.198  1.00 36.02           C  
ATOM    155  CG2 VAL A  19      92.271 104.599  78.237  1.00 35.45           C  
ATOM    156  N   PRO A  20      93.021 104.878  73.580  1.00 34.42           N  
ATOM    157  CA  PRO A  20      92.916 105.548  72.298  1.00 34.20           C  
ATOM    158  C   PRO A  20      91.949 106.719  72.348  1.00 34.07           C  
ATOM    159  O   PRO A  20      90.896 106.623  72.964  1.00 34.59           O  
ATOM    160  CB  PRO A  20      92.392 104.455  71.372  1.00 34.05           C  
ATOM    161  CG  PRO A  20      92.810 103.201  72.015  1.00 34.22           C  
ATOM    162  CD  PRO A  20      92.709 103.451  73.470  1.00 34.31           C  
ATOM    163  N   LYS A  21      92.324 107.810  71.699  1.00 33.71           N  
ATOM    164  CA  LYS A  21      91.594 109.079  71.759  1.00 33.50           C  
ATOM    165  C   LYS A  21      90.090 108.983  71.518  1.00 33.33           C  
ATOM    166  O   LYS A  21      89.307 109.707  72.131  1.00 33.13           O  
ATOM    167  CB  LYS A  21      92.201 110.061  70.742  1.00 33.64           C  
ATOM    168  CG  LYS A  21      92.339 109.504  69.302  1.00 33.15           C  
ATOM    169  CD  LYS A  21      93.421 110.231  68.565  1.00 32.80           C  
ATOM    170  CE  LYS A  21      93.489 109.849  67.113  1.00 33.45           C  
ATOM    171  NZ  LYS A  21      94.364 110.804  66.373  1.00 33.66           N  
ATOM    172  N   GLN A  22      89.700 108.101  70.603  1.00 33.25           N  
ATOM    173  CA  GLN A  22      88.292 107.939  70.223  1.00 32.86           C  
ATOM    174  C   GLN A  22      87.419 107.435  71.358  1.00 32.82           C  
ATOM    175  O   GLN A  22      86.204 107.590  71.290  1.00 32.69           O  
ATOM    176  CB  GLN A  22      88.160 106.997  69.016  1.00 32.51           C  
ATOM    177  CG  GLN A  22      88.634 105.573  69.248  1.00 32.21           C  
ATOM    178  CD  GLN A  22      90.045 105.335  68.770  1.00 32.15           C  
ATOM    179  OE1 GLN A  22      90.918 106.175  68.957  1.00 32.18           O  
ATOM    180  NE2 GLN A  22      90.278 104.180  68.151  1.00 32.26           N  
ATOM    181  N   PHE A  23      88.042 106.819  72.376  1.00 33.07           N  
ATOM    182  CA  PHE A  23      87.344 106.286  73.565  1.00 33.14           C  
ATOM    183  C   PHE A  23      87.534 107.133  74.825  1.00 33.41           C  
ATOM    184  O   PHE A  23      87.084 106.745  75.912  1.00 33.08           O  
ATOM    185  CB  PHE A  23      87.779 104.847  73.836  1.00 32.95           C  
ATOM    186  CG  PHE A  23      87.711 103.977  72.628  1.00 33.73           C  
ATOM    187  CD1 PHE A  23      86.506 103.791  71.962  1.00 33.83           C  
ATOM    188  CD2 PHE A  23      88.860 103.373  72.110  1.00 35.19           C  
ATOM    189  CE1 PHE A  23      86.434 102.991  70.798  1.00 33.50           C  
ATOM    190  CE2 PHE A  23      88.799 102.576  70.945  1.00 34.28           C  
ATOM    191  CZ  PHE A  23      87.582 102.387  70.299  1.00 33.65           C  
ATOM    192  N   LEU A  24      88.190 108.290  74.687  1.00 33.86           N  
ATOM    193  CA  LEU A  24      88.218 109.277  75.775  1.00 34.03           C  
ATOM    194  C   LEU A  24      86.839 109.918  75.935  1.00 33.98           C  
ATOM    195  O   LEU A  24      86.173 110.210  74.964  1.00 33.81           O  
ATOM    196  CB  LEU A  24      89.252 110.371  75.507  1.00 33.99           C  
ATOM    197  CG  LEU A  24      90.735 110.012  75.551  1.00 34.18           C  
ATOM    198  CD1 LEU A  24      91.581 111.208  75.152  1.00 33.72           C  
ATOM    199  CD2 LEU A  24      91.136 109.517  76.933  1.00 33.67           C  
ATOM    200  N   GLU A  25      86.418 110.130  77.170  1.00 34.72           N  
ATOM    201  CA  GLU A  25      85.142 110.777  77.444  1.00 35.18           C  
ATOM    202  C   GLU A  25      85.285 112.296  77.479  1.00 35.29           C  
ATOM    203  O   GLU A  25      86.259 112.830  77.990  1.00 35.54           O  
ATOM    204  CB  GLU A  25      84.548 110.257  78.754  1.00 35.23           C  
ATOM    205  CG  GLU A  25      84.204 108.751  78.695  1.00 36.67           C  
ATOM    206  CD  GLU A  25      82.862 108.395  79.319  1.00 38.70           C  
ATOM    207  OE1 GLU A  25      82.369 109.218  80.144  1.00 40.16           O  
ATOM    208  OE2 GLU A  25      82.310 107.300  78.977  1.00 37.38           O  
ATOM    209  N   ILE A  26      84.325 112.984  76.888  1.00 35.41           N  
ATOM    210  CA  ILE A  26      84.170 114.411  77.089  1.00 35.52           C  
ATOM    211  C   ILE A  26      82.688 114.678  77.251  1.00 34.92           C  
ATOM    212  O   ILE A  26      81.861 114.073  76.555  1.00 34.41           O  
ATOM    213  CB  ILE A  26      84.778 115.261  75.946  1.00 35.99           C  
ATOM    214  CG1 ILE A  26      84.355 114.754  74.571  1.00 36.49           C  
ATOM    215  CG2 ILE A  26      86.312 115.269  76.021  1.00 36.83           C  
ATOM    216  CD1 ILE A  26      84.835 115.660  73.453  1.00 36.22           C  
ATOM    217  N   GLU A  27      82.365 115.564  78.193  1.00 34.44           N  
ATOM    218  CA  GLU A  27      80.988 115.786  78.618  1.00 34.27           C  
ATOM    219  C   GLU A  27      80.183 114.486  78.693  1.00 33.96           C  
ATOM    220  O   GLU A  27      79.059 114.412  78.213  1.00 34.20           O  
ATOM    221  CB  GLU A  27      80.309 116.802  77.700  1.00 34.43           C  
ATOM    222  CG  GLU A  27      80.883 118.216  77.825  1.00 35.21           C  
ATOM    223  CD  GLU A  27      80.537 118.876  79.152  1.00 35.63           C  
ATOM    224  OE1 GLU A  27      79.362 118.809  79.579  1.00 35.34           O  
ATOM    225  OE2 GLU A  27      81.448 119.462  79.774  1.00 36.96           O  
ATOM    226  N   GLY A  28      80.777 113.463  79.296  1.00 33.70           N  
ATOM    227  CA  GLY A  28      80.093 112.204  79.548  1.00 33.70           C  
ATOM    228  C   GLY A  28      79.766 111.321  78.355  1.00 33.75           C  
ATOM    229  O   GLY A  28      78.858 110.504  78.437  1.00 34.62           O  
ATOM    230  N   ARG A  29      80.479 111.470  77.247  1.00 33.35           N  
ATOM    231  CA  ARG A  29      80.285 110.597  76.091  1.00 33.01           C  
ATOM    232  C   ARG A  29      81.638 110.362  75.460  1.00 32.63           C  
ATOM    233  O   ARG A  29      82.505 111.233  75.516  1.00 32.57           O  
ATOM    234  CB  ARG A  29      79.353 111.242  75.067  1.00 33.11           C  
ATOM    235  CG  ARG A  29      78.269 112.121  75.659  1.00 33.22           C  
ATOM    236  N   MET A  30      81.839 109.196  74.862  1.00 32.27           N  
ATOM    237  CA  MET A  30      83.116 108.930  74.183  1.00 31.90           C  
ATOM    238  C   MET A  30      83.215 109.725  72.890  1.00 31.64           C  
ATOM    239  O   MET A  30      82.217 109.929  72.217  1.00 31.53           O  
ATOM    240  CB  MET A  30      83.284 107.452  73.908  1.00 31.85           C  
ATOM    241  CG  MET A  30      83.560 106.653  75.161  1.00 31.98           C  
ATOM    242  SD  MET A  30      83.805 104.904  74.839  1.00 31.07           S  
ATOM    243  CE  MET A  30      84.337 104.383  76.480  1.00 30.51           C  
ATOM    244  N   LEU A  31      84.411 110.179  72.546  1.00 31.32           N  
ATOM    245  CA  LEU A  31      84.566 111.015  71.369  1.00 31.46           C  
ATOM    246  C   LEU A  31      83.832 110.470  70.179  1.00 30.89           C  
ATOM    247  O   LEU A  31      83.172 111.210  69.482  1.00 30.15           O  
ATOM    248  CB  LEU A  31      86.031 111.190  70.978  1.00 32.06           C  
ATOM    249  CG  LEU A  31      86.891 112.240  71.664  1.00 32.89           C  
ATOM    250  CD1 LEU A  31      88.003 112.710  70.745  1.00 33.21           C  
ATOM    251  CD2 LEU A  31      86.070 113.392  72.038  1.00 34.20           C  
ATOM    252  N   PHE A  32      83.945 109.173  69.944  1.00 31.31           N  
ATOM    253  CA  PHE A  32      83.367 108.578  68.733  1.00 31.87           C  
ATOM    254  C   PHE A  32      81.834 108.698  68.682  1.00 31.86           C  
ATOM    255  O   PHE A  32      81.232 108.593  67.618  1.00 32.29           O  
ATOM    256  CB  PHE A  32      83.809 107.123  68.584  1.00 31.77           C  
ATOM    257  CG  PHE A  32      82.956 106.148  69.330  1.00 32.29           C  
ATOM    258  CD1 PHE A  32      81.770 105.662  68.771  1.00 32.03           C  
ATOM    259  CD2 PHE A  32      83.338 105.686  70.574  1.00 32.49           C  
ATOM    260  CE1 PHE A  32      80.978 104.737  69.452  1.00 31.23           C  
ATOM    261  CE2 PHE A  32      82.540 104.753  71.259  1.00 32.67           C  
ATOM    262  CZ  PHE A  32      81.360 104.289  70.694  1.00 31.26           C  
ATOM    263  N   GLU A  33      81.217 108.943  69.828  1.00 31.79           N  
ATOM    264  CA  GLU A  33      79.778 109.062  69.905  1.00 31.83           C  
ATOM    265  C   GLU A  33      79.270 110.337  69.252  1.00 31.65           C  
ATOM    266  O   GLU A  33      78.200 110.359  68.645  1.00 31.11           O  
ATOM    267  CB  GLU A  33      79.337 108.976  71.365  1.00 31.98           C  
ATOM    268  CG  GLU A  33      79.765 107.660  72.038  1.00 32.24           C  
ATOM    269  CD  GLU A  33      79.094 107.443  73.364  1.00 32.08           C  
ATOM    270  OE1 GLU A  33      77.913 107.047  73.356  1.00 32.20           O  
ATOM    271  OE2 GLU A  33      79.741 107.671  74.410  1.00 32.32           O  
ATOM    272  N   TYR A  34      80.056 111.394  69.347  1.00 32.30           N  
ATOM    273  CA  TYR A  34      79.663 112.693  68.789  1.00 32.43           C  
ATOM    274  C   TYR A  34      79.363 112.573  67.290  1.00 32.08           C  
ATOM    275  O   TYR A  34      78.220 112.789  66.882  1.00 32.80           O  
ATOM    276  CB  TYR A  34      80.696 113.782  69.120  1.00 32.40           C  
ATOM    277  CG  TYR A  34      80.685 114.156  70.590  1.00 32.43           C  
ATOM    278  CD1 TYR A  34      81.364 113.391  71.531  1.00 32.70           C  
ATOM    279  CD2 TYR A  34      79.986 115.272  71.041  1.00 32.80           C  
ATOM    280  CE1 TYR A  34      81.346 113.724  72.889  1.00 33.40           C  
ATOM    281  CE2 TYR A  34      79.953 115.614  72.394  1.00 32.41           C  
ATOM    282  CZ  TYR A  34      80.638 114.840  73.311  1.00 33.08           C  
ATOM    283  OH  TYR A  34      80.614 115.174  74.642  1.00 32.97           O  
ATOM    284  N   PRO A  35      80.337 112.161  66.487  1.00 31.33           N  
ATOM    285  CA  PRO A  35      80.060 112.025  65.066  1.00 31.55           C  
ATOM    286  C   PRO A  35      79.078 110.913  64.745  1.00 32.12           C  
ATOM    287  O   PRO A  35      78.322 111.011  63.782  1.00 31.79           O  
ATOM    288  CB  PRO A  35      81.428 111.724  64.457  1.00 31.66           C  
ATOM    289  CG  PRO A  35      82.267 111.237  65.562  1.00 31.97           C  
ATOM    290  CD  PRO A  35      81.714 111.794  66.832  1.00 31.74           C  
ATOM    291  N   LEU A  36      79.088 109.855  65.550  1.00 32.91           N  
ATOM    292  CA  LEU A  36      78.152 108.764  65.368  1.00 32.78           C  
ATOM    293  C   LEU A  36      76.721 109.238  65.359  1.00 33.16           C  
ATOM    294  O   LEU A  36      75.931 108.767  64.553  1.00 33.77           O  
ATOM    295  CB  LEU A  36      78.318 107.698  66.452  1.00 32.97           C  
ATOM    296  CG  LEU A  36      77.411 106.461  66.269  1.00 32.66           C  
ATOM    297  CD1 LEU A  36      77.690 105.789  64.936  1.00 31.95           C  
ATOM    298  CD2 LEU A  36      77.565 105.459  67.399  1.00 32.30           C  
ATOM    299  N   SER A  37      76.353 110.152  66.246  1.00 33.42           N  
ATOM    300  CA  SER A  37      74.950 110.549  66.273  1.00 33.87           C  
ATOM    301  C   SER A  37      74.638 111.589  65.220  1.00 33.57           C  
ATOM    302  O   SER A  37      73.483 111.752  64.874  1.00 33.70           O  
ATOM    303  CB  SER A  37      74.519 111.057  67.638  1.00 33.94           C  
ATOM    304  OG  SER A  37      75.265 112.192  67.968  1.00 35.61           O  
ATOM    305  N   THR A  38      75.631 112.311  64.716  1.00 33.38           N  
ATOM    306  CA  THR A  38      75.372 113.122  63.531  1.00 33.37           C  
ATOM    307  C   THR A  38      74.944 112.195  62.374  1.00 33.82           C  
ATOM    308  O   THR A  38      73.961 112.480  61.709  1.00 33.85           O  
ATOM    309  CB  THR A  38      76.564 113.991  63.115  1.00 33.27           C  
ATOM    310  OG1 THR A  38      76.978 114.813  64.215  1.00 32.90           O  
ATOM    311  CG2 THR A  38      76.176 114.883  61.940  1.00 32.72           C  
ATOM    312  N   PHE A  39      75.653 111.084  62.155  1.00 34.07           N  
ATOM    313  CA  PHE A  39      75.239 110.093  61.153  1.00 34.84           C  
ATOM    314  C   PHE A  39      73.879 109.434  61.437  1.00 35.40           C  
ATOM    315  O   PHE A  39      73.112 109.169  60.507  1.00 35.51           O  
ATOM    316  CB  PHE A  39      76.252 108.948  61.033  1.00 35.23           C  
ATOM    317  CG  PHE A  39      77.586 109.344  60.468  1.00 35.08           C  
ATOM    318  CD1 PHE A  39      77.686 110.201  59.397  1.00 35.50           C  
ATOM    319  CD2 PHE A  39      78.746 108.806  60.991  1.00 34.96           C  
ATOM    320  CE1 PHE A  39      78.918 110.536  58.890  1.00 36.65           C  
ATOM    321  CE2 PHE A  39      79.977 109.146  60.492  1.00 34.83           C  
ATOM    322  CZ  PHE A  39      80.071 110.000  59.445  1.00 35.71           C  
ATOM    323  N   LEU A  40      73.596 109.125  62.704  1.00 35.71           N  
ATOM    324  CA  LEU A  40      72.339 108.446  63.041  1.00 35.77           C  
ATOM    325  C   LEU A  40      71.139 109.366  62.924  1.00 35.63           C  
ATOM    326  O   LEU A  40      70.035 108.899  62.673  1.00 35.98           O  
ATOM    327  CB  LEU A  40      72.378 107.852  64.449  1.00 35.83           C  
ATOM    328  CG  LEU A  40      73.418 106.768  64.721  1.00 35.35           C  
ATOM    329  CD1 LEU A  40      73.342 106.392  66.199  1.00 35.17           C  
ATOM    330  CD2 LEU A  40      73.222 105.545  63.825  1.00 34.62           C  
ATOM    331  N   LYS A  41      71.352 110.663  63.117  1.00 35.59           N  
ATOM    332  CA  LYS A  41      70.294 111.669  62.933  1.00 35.59           C  
ATOM    333  C   LYS A  41      70.186 112.167  61.474  1.00 35.30           C  
ATOM    334  O   LYS A  41      69.245 112.876  61.134  1.00 35.07           O  
ATOM    335  CB  LYS A  41      70.523 112.871  63.861  1.00 35.38           C  
ATOM    336  CG  LYS A  41      70.459 112.568  65.353  1.00 35.50           C  
ATOM    337  CD  LYS A  41      70.367 113.874  66.162  1.00 36.27           C  
ATOM    338  CE  LYS A  41      71.073 113.802  67.512  1.00 37.03           C  
ATOM    339  NZ  LYS A  41      72.573 114.004  67.395  1.00 37.76           N  
ATOM    340  N   SER A  42      71.142 111.791  60.624  1.00 35.23           N  
ATOM    341  CA  SER A  42      71.205 112.298  59.246  1.00 35.37           C  
ATOM    342  C   SER A  42      70.394 111.463  58.280  1.00 35.52           C  
ATOM    343  O   SER A  42      70.687 110.283  58.059  1.00 35.44           O  
ATOM    344  CB  SER A  42      72.650 112.354  58.731  1.00 35.28           C  
ATOM    345  OG  SER A  42      72.673 112.669  57.345  1.00 35.27           O  
ATOM    346  N   GLU A  43      69.401 112.105  57.676  1.00 35.92           N  
ATOM    347  CA  GLU A  43      68.533 111.472  56.689  1.00 36.47           C  
ATOM    348  C   GLU A  43      69.256 111.021  55.417  1.00 36.15           C  
ATOM    349  O   GLU A  43      68.818 110.084  54.765  1.00 36.46           O  
ATOM    350  CB  GLU A  43      67.387 112.423  56.333  1.00 36.62           C  
ATOM    351  CG  GLU A  43      66.193 112.279  57.272  1.00 37.42           C  
ATOM    352  CD  GLU A  43      65.191 113.406  57.126  1.00 37.79           C  
ATOM    353  OE1 GLU A  43      65.601 114.538  56.763  1.00 40.26           O  
ATOM    354  OE2 GLU A  43      63.991 113.161  57.387  1.00 38.64           O  
ATOM    355  N   ALA A  44      70.359 111.683  55.077  1.00 36.01           N  
ATOM    356  CA  ALA A  44      71.220 111.274  53.955  1.00 35.74           C  
ATOM    357  C   ALA A  44      71.940 109.939  54.195  1.00 35.75           C  
ATOM    358  O   ALA A  44      72.485 109.352  53.252  1.00 36.13           O  
ATOM    359  CB  ALA A  44      72.262 112.374  53.655  1.00 35.54           C  
ATOM    360  N   ILE A  45      71.954 109.463  55.439  1.00 35.48           N  
ATOM    361  CA  ILE A  45      72.679 108.244  55.794  1.00 35.18           C  
ATOM    362  C   ILE A  45      71.743 107.073  56.038  1.00 34.96           C  
ATOM    363  O   ILE A  45      71.014 107.036  57.033  1.00 34.76           O  
ATOM    364  CB  ILE A  45      73.507 108.466  57.043  1.00 35.31           C  
ATOM    365  CG1 ILE A  45      74.558 109.552  56.777  1.00 35.00           C  
ATOM    366  CG2 ILE A  45      74.139 107.131  57.517  1.00 35.87           C  
ATOM    367  CD1 ILE A  45      75.618 109.121  55.813  1.00 34.98           C  
ATOM    368  N   ASP A  46      71.804 106.097  55.135  1.00 34.70           N  
ATOM    369  CA  ASP A  46      70.982 104.889  55.222  1.00 34.31           C  
ATOM    370  C   ASP A  46      71.556 103.848  56.214  1.00 33.99           C  
ATOM    371  O   ASP A  46      70.810 103.125  56.855  1.00 33.19           O  
ATOM    372  CB  ASP A  46      70.832 104.281  53.828  1.00 34.20           C  
ATOM    373  CG  ASP A  46      70.080 105.187  52.877  1.00 34.60           C  
ATOM    374  OD1 ASP A  46      68.911 105.518  53.164  1.00 36.99           O  
ATOM    375  OD2 ASP A  46      70.638 105.551  51.826  1.00 34.67           O  
ATOM    376  N   GLY A  47      72.876 103.793  56.347  1.00 33.82           N  
ATOM    377  CA  GLY A  47      73.500 102.856  57.263  1.00 34.00           C  
ATOM    378  C   GLY A  47      74.885 103.272  57.737  1.00 34.24           C  
ATOM    379  O   GLY A  47      75.560 104.093  57.109  1.00 33.89           O  
ATOM    380  N   VAL A  48      75.305 102.675  58.855  1.00 34.31           N  
ATOM    381  CA  VAL A  48      76.583 102.988  59.476  1.00 34.14           C  
ATOM    382  C   VAL A  48      77.363 101.716  59.790  1.00 34.06           C  
ATOM    383  O   VAL A  48      76.810 100.717  60.237  1.00 33.98           O  
ATOM    384  CB  VAL A  48      76.378 103.783  60.785  1.00 34.38           C  
ATOM    385  CG1 VAL A  48      77.708 104.042  61.484  1.00 34.47           C  
ATOM    386  CG2 VAL A  48      75.629 105.108  60.509  1.00 34.42           C  
ATOM    387  N   VAL A  49      78.662 101.775  59.531  1.00 34.35           N  
ATOM    388  CA  VAL A  49      79.594 100.740  59.933  1.00 34.22           C  
ATOM    389  C   VAL A  49      80.611 101.399  60.845  1.00 33.98           C  
ATOM    390  O   VAL A  49      81.195 102.418  60.497  1.00 34.08           O  
ATOM    391  CB  VAL A  49      80.291 100.161  58.720  1.00 34.26           C  
ATOM    392  CG1 VAL A  49      81.453  99.293  59.128  1.00 35.07           C  
ATOM    393  CG2 VAL A  49      79.304  99.361  57.918  1.00 35.14           C  
ATOM    394  N   ILE A  50      80.791 100.833  62.028  1.00 34.08           N  
ATOM    395  CA  ILE A  50      81.818 101.301  62.960  1.00 34.16           C  
ATOM    396  C   ILE A  50      82.985 100.310  62.947  1.00 34.05           C  
ATOM    397  O   ILE A  50      82.810  99.099  63.161  1.00 34.32           O  
ATOM    398  CB  ILE A  50      81.273 101.485  64.390  1.00 33.94           C  
ATOM    399  CG1 ILE A  50      79.904 102.168  64.338  1.00 33.93           C  
ATOM    400  CG2 ILE A  50      82.233 102.311  65.214  1.00 33.49           C  
ATOM    401  CD1 ILE A  50      79.384 102.617  65.687  1.00 34.29           C  
ATOM    402  N   VAL A  51      84.159 100.854  62.666  1.00 33.84           N  
ATOM    403  CA  VAL A  51      85.376 100.090  62.526  1.00 33.85           C  
ATOM    404  C   VAL A  51      86.264 100.324  63.750  1.00 34.16           C  
ATOM    405  O   VAL A  51      86.733 101.430  64.008  1.00 34.57           O  
ATOM    406  CB  VAL A  51      86.115 100.500  61.220  1.00 33.52           C  
ATOM    407  CG1 VAL A  51      87.386  99.687  61.025  1.00 32.64           C  
ATOM    408  CG2 VAL A  51      85.180 100.338  60.042  1.00 32.94           C  
ATOM    409  N   THR A  52      86.500  99.272  64.509  1.00 34.78           N  
ATOM    410  CA  THR A  52      87.364  99.368  65.679  1.00 35.11           C  
ATOM    411  C   THR A  52      88.213  98.122  65.854  1.00 34.17           C  
ATOM    412  O   THR A  52      88.049  97.157  65.125  1.00 33.42           O  
ATOM    413  CB  THR A  52      86.531  99.611  66.946  1.00 35.45           C  
ATOM    414  OG1 THR A  52      87.383 100.178  67.945  1.00 38.19           O  
ATOM    415  CG2 THR A  52      85.934  98.323  67.458  1.00 34.87           C  
ATOM    416  N   ARG A  53      89.125  98.157  66.811  1.00 34.05           N  
ATOM    417  CA  ARG A  53      89.932  96.977  67.114  1.00 34.55           C  
ATOM    418  C   ARG A  53      89.119  95.962  67.913  1.00 33.94           C  
ATOM    419  O   ARG A  53      88.176  96.313  68.621  1.00 33.82           O  
ATOM    420  CB  ARG A  53      91.184  97.332  67.907  1.00 35.05           C  
ATOM    421  CG  ARG A  53      92.250  98.048  67.124  1.00 37.33           C  
ATOM    422  CD  ARG A  53      93.415  98.360  68.046  1.00 41.67           C  
ATOM    423  NE  ARG A  53      94.712  98.055  67.445  1.00 44.39           N  
ATOM    424  CZ  ARG A  53      95.190  96.826  67.282  1.00 45.20           C  
ATOM    425  NH1 ARG A  53      94.488  95.763  67.659  1.00 46.72           N  
ATOM    426  NH2 ARG A  53      96.376  96.656  66.730  1.00 46.06           N  
ATOM    427  N   ARG A  54      89.523  94.707  67.815  1.00 33.03           N  
ATOM    428  CA  ARG A  54      88.771  93.612  68.401  1.00 32.89           C  
ATOM    429  C   ARG A  54      88.529  93.856  69.905  1.00 32.25           C  
ATOM    430  O   ARG A  54      87.461  93.567  70.414  1.00 32.20           O  
ATOM    431  CB  ARG A  54      89.502  92.281  68.136  1.00 32.79           C  
ATOM    432  CG  ARG A  54      88.639  91.063  68.056  1.00 34.37           C  
ATOM    433  CD  ARG A  54      89.253  89.978  67.142  1.00 35.62           C  
ATOM    434  N   GLU A  55      89.495  94.442  70.600  1.00 31.63           N  
ATOM    435  CA  GLU A  55      89.370  94.641  72.041  1.00 31.37           C  
ATOM    436  C   GLU A  55      88.346  95.710  72.449  1.00 31.00           C  
ATOM    437  O   GLU A  55      87.961  95.779  73.629  1.00 30.68           O  
ATOM    438  CB  GLU A  55      90.734  94.932  72.689  1.00 31.55           C  
ATOM    439  CG  GLU A  55      91.447  96.183  72.214  1.00 32.09           C  
ATOM    440  CD  GLU A  55      92.371  95.930  71.037  1.00 33.40           C  
ATOM    441  OE1 GLU A  55      92.116  94.989  70.263  1.00 32.99           O  
ATOM    442  OE2 GLU A  55      93.345  96.687  70.871  1.00 35.30           O  
ATOM    443  N   TRP A  56      87.896  96.519  71.488  1.00 30.34           N  
ATOM    444  CA  TRP A  56      86.921  97.567  71.767  1.00 30.23           C  
ATOM    445  C   TRP A  56      85.485  97.252  71.369  1.00 30.10           C  
ATOM    446  O   TRP A  56      84.605  98.074  71.617  1.00 30.53           O  
ATOM    447  CB  TRP A  56      87.379  98.890  71.139  1.00 30.65           C  
ATOM    448  CG  TRP A  56      88.600  99.368  71.818  1.00 30.77           C  
ATOM    449  CD1 TRP A  56      89.879  99.200  71.403  1.00 30.91           C  
ATOM    450  CD2 TRP A  56      88.666 100.016  73.091  1.00 31.57           C  
ATOM    451  NE1 TRP A  56      90.745  99.732  72.328  1.00 31.87           N  
ATOM    452  CE2 TRP A  56      90.025 100.240  73.375  1.00 31.02           C  
ATOM    453  CE3 TRP A  56      87.705 100.452  74.010  1.00 31.20           C  
ATOM    454  CZ2 TRP A  56      90.450 100.875  74.532  1.00 30.49           C  
ATOM    455  CZ3 TRP A  56      88.132 101.077  75.172  1.00 30.69           C  
ATOM    456  CH2 TRP A  56      89.488 101.282  75.421  1.00 30.51           C  
ATOM    457  N   PHE A  57      85.238  96.066  70.803  1.00 29.66           N  
ATOM    458  CA  PHE A  57      83.904  95.675  70.347  1.00 29.37           C  
ATOM    459  C   PHE A  57      82.844  95.800  71.435  1.00 29.20           C  
ATOM    460  O   PHE A  57      81.750  96.280  71.167  1.00 29.07           O  
ATOM    461  CB  PHE A  57      83.880  94.232  69.827  1.00 29.52           C  
ATOM    462  CG  PHE A  57      84.452  94.034  68.409  1.00 30.52           C  
ATOM    463  CD1 PHE A  57      84.908  95.089  67.631  1.00 30.22           C  
ATOM    464  CD2 PHE A  57      84.551  92.739  67.873  1.00 30.22           C  
ATOM    465  CE1 PHE A  57      85.426  94.866  66.335  1.00 30.54           C  
ATOM    466  CE2 PHE A  57      85.063  92.520  66.579  1.00 29.84           C  
ATOM    467  CZ  PHE A  57      85.497  93.586  65.814  1.00 29.38           C  
ATOM    468  N   GLU A  58      83.135  95.368  72.658  1.00 29.20           N  
ATOM    469  CA  GLU A  58      82.106  95.418  73.709  1.00 29.28           C  
ATOM    470  C   GLU A  58      81.799  96.854  74.157  1.00 29.63           C  
ATOM    471  O   GLU A  58      80.629  97.230  74.291  1.00 29.16           O  
ATOM    472  CB  GLU A  58      82.481  94.552  74.904  1.00 29.13           C  
ATOM    473  CG  GLU A  58      82.255  93.074  74.663  1.00 29.41           C  
ATOM    474  CD  GLU A  58      81.961  92.290  75.938  1.00 30.58           C  
ATOM    475  OE1 GLU A  58      81.175  92.770  76.804  1.00 29.77           O  
ATOM    476  OE2 GLU A  58      82.527  91.177  76.066  1.00 30.57           O  
ATOM    477  N   VAL A  59      82.859  97.641  74.362  1.00 30.02           N  
ATOM    478  CA  VAL A  59      82.746  99.046  74.729  1.00 30.23           C  
ATOM    479  C   VAL A  59      81.885  99.784  73.709  1.00 31.22           C  
ATOM    480  O   VAL A  59      81.140 100.690  74.076  1.00 31.37           O  
ATOM    481  CB  VAL A  59      84.135  99.725  74.801  1.00 30.14           C  
ATOM    482  CG1 VAL A  59      84.021 101.240  74.913  1.00 29.83           C  
ATOM    483  CG2 VAL A  59      84.921  99.201  75.961  1.00 29.78           C  
ATOM    484  N   VAL A  60      81.993  99.406  72.436  1.00 31.94           N  
ATOM    485  CA  VAL A  60      81.164 100.003  71.397  1.00 32.79           C  
ATOM    486  C   VAL A  60      79.760  99.414  71.452  1.00 33.85           C  
ATOM    487  O   VAL A  60      78.790 100.163  71.517  1.00 34.27           O  
ATOM    488  CB  VAL A  60      81.783  99.835  69.994  1.00 32.49           C  
ATOM    489  CG1 VAL A  60      80.844 100.317  68.932  1.00 32.89           C  
ATOM    490  CG2 VAL A  60      83.033 100.624  69.898  1.00 32.91           C  
ATOM    491  N   GLU A  61      79.654  98.084  71.441  1.00 35.04           N  
ATOM    492  CA  GLU A  61      78.349  97.407  71.496  1.00 36.25           C  
ATOM    493  C   GLU A  61      77.470  97.929  72.618  1.00 36.55           C  
ATOM    494  O   GLU A  61      76.258  97.972  72.453  1.00 37.27           O  
ATOM    495  CB  GLU A  61      78.477  95.876  71.646  1.00 36.10           C  
ATOM    496  CG  GLU A  61      78.581  95.124  70.323  1.00 37.10           C  
ATOM    497  CD  GLU A  61      78.823  93.603  70.468  1.00 38.51           C  
ATOM    498  OE1 GLU A  61      78.488  93.011  71.541  1.00 40.49           O  
ATOM    499  OE2 GLU A  61      79.353  93.002  69.480  1.00 41.34           O  
ATOM    500  N   LYS A  62      78.057  98.315  73.751  1.00 37.03           N  
ATOM    501  CA  LYS A  62      77.255  98.769  74.905  1.00 37.52           C  
ATOM    502  C   LYS A  62      76.873 100.262  74.861  1.00 38.05           C  
ATOM    503  O   LYS A  62      76.230 100.753  75.777  1.00 38.35           O  
ATOM    504  CB  LYS A  62      77.947  98.425  76.241  1.00 37.34           C  
ATOM    505  CG  LYS A  62      79.120  99.326  76.626  1.00 37.35           C  
ATOM    506  N   ARG A  63      77.264 100.965  73.807  1.00 38.58           N  
ATOM    507  CA  ARG A  63      76.959 102.386  73.655  1.00 39.46           C  
ATOM    508  C   ARG A  63      76.157 102.700  72.390  1.00 39.98           C  
ATOM    509  O   ARG A  63      75.809 103.853  72.134  1.00 40.73           O  
ATOM    510  CB  ARG A  63      78.270 103.186  73.605  1.00 39.60           C  
ATOM    511  CG  ARG A  63      78.763 103.624  74.968  1.00 40.31           C  
ATOM    512  CD  ARG A  63      80.254 103.879  74.954  1.00 42.38           C  
ATOM    513  NE  ARG A  63      80.840 103.524  76.238  1.00 42.96           N  
ATOM    514  CZ  ARG A  63      80.937 104.343  77.278  1.00 44.72           C  
ATOM    515  NH1 ARG A  63      80.502 105.604  77.194  1.00 45.69           N  
ATOM    516  NH2 ARG A  63      81.479 103.899  78.414  1.00 44.86           N  
ATOM    517  N   VAL A  64      75.874 101.676  71.602  1.00 40.24           N  
ATOM    518  CA  VAL A  64      75.288 101.835  70.287  1.00 40.08           C  
ATOM    519  C   VAL A  64      74.148 100.837  70.142  1.00 40.15           C  
ATOM    520  O   VAL A  64      74.376  99.621  70.016  1.00 40.59           O  
ATOM    521  CB  VAL A  64      76.348 101.543  69.230  1.00 40.27           C  
ATOM    522  CG1 VAL A  64      75.727 101.372  67.853  1.00 40.49           C  
ATOM    523  CG2 VAL A  64      77.399 102.627  69.250  1.00 40.38           C  
ATOM    524  N   PHE A  65      72.926 101.352  70.226  1.00 39.83           N  
ATOM    525  CA  PHE A  65      71.722 100.603  69.889  1.00 39.57           C  
ATOM    526  C   PHE A  65      70.995 101.490  68.895  1.00 38.46           C  
ATOM    527  O   PHE A  65      70.357 102.462  69.287  1.00 38.80           O  
ATOM    528  CB  PHE A  65      70.833 100.356  71.121  1.00 40.05           C  
ATOM    529  CG  PHE A  65      71.584  99.883  72.344  1.00 41.25           C  
ATOM    530  CD1 PHE A  65      72.275 100.795  73.145  1.00 41.96           C  
ATOM    531  CD2 PHE A  65      71.569  98.536  72.722  1.00 42.19           C  
ATOM    532  CE1 PHE A  65      72.966 100.375  74.286  1.00 42.01           C  
ATOM    533  CE2 PHE A  65      72.256  98.099  73.868  1.00 41.42           C  
ATOM    534  CZ  PHE A  65      72.959  99.028  74.651  1.00 41.66           C  
ATOM    535  N   HIS A  66      71.138 101.195  67.611  1.00 37.17           N  
ATOM    536  CA  HIS A  66      70.412 101.935  66.590  1.00 36.23           C  
ATOM    537  C   HIS A  66      70.291 101.107  65.347  1.00 35.84           C  
ATOM    538  O   HIS A  66      71.259 100.519  64.891  1.00 35.12           O  
ATOM    539  CB  HIS A  66      71.099 103.246  66.270  1.00 35.91           C  
ATOM    540  CG  HIS A  66      70.202 104.252  65.624  1.00 36.01           C  
ATOM    541  ND1 HIS A  66      69.750 104.123  64.327  1.00 35.74           N  
ATOM    542  CD2 HIS A  66      69.682 105.415  66.090  1.00 35.08           C  
ATOM    543  CE1 HIS A  66      68.987 105.158  64.025  1.00 35.83           C  
ATOM    544  NE2 HIS A  66      68.922 105.951  65.081  1.00 35.43           N  
ATOM    545  N   GLU A  67      69.083 101.066  64.801  1.00 36.04           N  
ATOM    546  CA  GLU A  67      68.790 100.227  63.636  1.00 36.08           C  
ATOM    547  C   GLU A  67      69.641 100.554  62.415  1.00 35.30           C  
ATOM    548  O   GLU A  67      69.892  99.674  61.631  1.00 34.93           O  
ATOM    549  CB  GLU A  67      67.288 100.273  63.293  1.00 36.40           C  
ATOM    550  CG  GLU A  67      66.724 101.632  62.830  1.00 37.08           C  
ATOM    551  CD  GLU A  67      65.212 101.607  62.593  1.00 37.28           C  
ATOM    552  OE1 GLU A  67      64.506 100.788  63.217  1.00 40.24           O  
ATOM    553  OE2 GLU A  67      64.720 102.413  61.781  1.00 38.82           O  
ATOM    554  N   LYS A  68      70.103 101.801  62.280  1.00 35.11           N  
ATOM    555  CA  LYS A  68      71.021 102.207  61.180  1.00 35.22           C  
ATOM    556  C   LYS A  68      72.441 101.588  61.233  1.00 35.17           C  
ATOM    557  O   LYS A  68      73.208 101.655  60.246  1.00 34.64           O  
ATOM    558  CB  LYS A  68      71.215 103.726  61.161  1.00 35.24           C  
ATOM    559  CG  LYS A  68      70.191 104.553  60.413  1.00 35.64           C  
ATOM    560  CD  LYS A  68      70.760 105.959  60.244  1.00 36.03           C  
ATOM    561  CE  LYS A  68      69.725 106.993  59.892  1.00 36.37           C  
ATOM    562  NZ  LYS A  68      70.417 108.317  59.742  1.00 36.91           N  
ATOM    563  N   VAL A  69      72.816 101.050  62.392  1.00 34.95           N  
ATOM    564  CA  VAL A  69      74.141 100.451  62.549  1.00 34.70           C  
ATOM    565  C   VAL A  69      74.117  99.037  61.995  1.00 34.51           C  
ATOM    566  O   VAL A  69      73.447  98.164  62.544  1.00 33.96           O  
ATOM    567  CB  VAL A  69      74.600 100.431  64.015  1.00 34.44           C  
ATOM    568  CG1 VAL A  69      75.979  99.747  64.143  1.00 34.19           C  
ATOM    569  CG2 VAL A  69      74.657 101.838  64.529  1.00 34.63           C  
ATOM    570  N   LEU A  70      74.859  98.843  60.908  1.00 34.57           N  
ATOM    571  CA  LEU A  70      74.857  97.598  60.149  1.00 34.83           C  
ATOM    572  C   LEU A  70      75.821  96.592  60.742  1.00 35.01           C  
ATOM    573  O   LEU A  70      75.685  95.403  60.528  1.00 35.11           O  
ATOM    574  CB  LEU A  70      75.266  97.868  58.695  1.00 34.62           C  
ATOM    575  CG  LEU A  70      74.356  98.790  57.885  1.00 35.02           C  
ATOM    576  CD1 LEU A  70      75.004  99.091  56.534  1.00 35.28           C  
ATOM    577  CD2 LEU A  70      72.964  98.182  57.695  1.00 34.14           C  
ATOM    578  N   GLY A  71      76.830  97.076  61.454  1.00 35.46           N  
ATOM    579  CA  GLY A  71      77.827  96.193  62.039  1.00 35.31           C  
ATOM    580  C   GLY A  71      78.977  96.947  62.668  1.00 35.21           C  
ATOM    581  O   GLY A  71      79.246  98.104  62.335  1.00 35.15           O  
ATOM    582  N   ILE A  72      79.633  96.277  63.604  1.00 35.28           N  
ATOM    583  CA  ILE A  72      80.896  96.721  64.154  1.00 35.41           C  
ATOM    584  C   ILE A  72      81.909  95.821  63.504  1.00 35.28           C  
ATOM    585  O   ILE A  72      81.766  94.620  63.547  1.00 34.78           O  
ATOM    586  CB  ILE A  72      80.917  96.516  65.651  1.00 35.61           C  
ATOM    587  CG1 ILE A  72      79.751  97.277  66.270  1.00 36.05           C  
ATOM    588  CG2 ILE A  72      82.241  97.004  66.256  1.00 36.52           C  
ATOM    589  CD1 ILE A  72      79.765  97.248  67.735  1.00 37.37           C  
ATOM    590  N   VAL A  73      82.921  96.405  62.888  1.00 35.66           N  
ATOM    591  CA  VAL A  73      83.810  95.664  62.004  1.00 35.56           C  
ATOM    592  C   VAL A  73      85.253  95.868  62.425  1.00 35.24           C  
ATOM    593  O   VAL A  73      85.682  96.979  62.705  1.00 34.80           O  
ATOM    594  CB  VAL A  73      83.635  96.139  60.553  1.00 35.99           C  
ATOM    595  CG1 VAL A  73      84.723  95.572  59.647  1.00 36.06           C  
ATOM    596  CG2 VAL A  73      82.261  95.740  60.052  1.00 36.78           C  
ATOM    597  N   GLU A  74      86.002  94.776  62.422  1.00 35.09           N  
ATOM    598  CA  GLU A  74      87.379  94.778  62.862  1.00 34.76           C  
ATOM    599  C   GLU A  74      88.248  95.639  61.967  1.00 34.20           C  
ATOM    600  O   GLU A  74      88.256  95.465  60.761  1.00 34.06           O  
ATOM    601  CB  GLU A  74      87.887  93.358  62.857  1.00 34.76           C  
ATOM    602  CG  GLU A  74      89.301  93.229  63.298  1.00 35.82           C  
ATOM    603  CD  GLU A  74      89.638  91.815  63.674  1.00 37.19           C  
ATOM    604  OE1 GLU A  74      88.965  90.872  63.191  1.00 37.87           O  
ATOM    605  OE2 GLU A  74      90.575  91.654  64.478  1.00 40.37           O  
ATOM    606  N   GLY A  75      88.971  96.578  62.567  1.00 34.00           N  
ATOM    607  CA  GLY A  75      89.879  97.444  61.822  1.00 33.66           C  
ATOM    608  C   GLY A  75      91.142  96.714  61.389  1.00 33.46           C  
ATOM    609  O   GLY A  75      91.319  95.528  61.669  1.00 32.69           O  
ATOM    610  N   GLY A  76      92.024  97.438  60.699  1.00 33.06           N  
ATOM    611  CA  GLY A  76      93.328  96.907  60.344  1.00 32.54           C  
ATOM    612  C   GLY A  76      94.426  97.593  61.130  1.00 32.47           C  
ATOM    613  O   GLY A  76      94.175  98.398  62.034  1.00 31.85           O  
ATOM    614  N   ASP A  77      95.659  97.289  60.760  1.00 32.60           N  
ATOM    615  CA  ASP A  77      96.809  97.909  61.397  1.00 32.75           C  
ATOM    616  C   ASP A  77      97.012  99.331  60.882  1.00 32.62           C  
ATOM    617  O   ASP A  77      97.803 100.067  61.453  1.00 33.02           O  
ATOM    618  CB  ASP A  77      98.085  97.079  61.178  1.00 32.79           C  
ATOM    619  CG  ASP A  77      97.890  95.610  61.467  1.00 32.17           C  
ATOM    620  OD1 ASP A  77      97.128  95.245  62.382  1.00 31.70           O  
ATOM    621  OD2 ASP A  77      98.505  94.812  60.751  1.00 33.32           O  
ATOM    622  N   THR A  78      96.321  99.701  59.801  1.00 32.47           N  
ATOM    623  CA  THR A  78      96.377 101.062  59.256  1.00 32.26           C  
ATOM    624  C   THR A  78      95.008 101.573  58.904  1.00 31.94           C  
ATOM    625  O   THR A  78      94.069 100.780  58.687  1.00 31.41           O  
ATOM    626  CB  THR A  78      97.184 101.164  57.937  1.00 32.22           C  
ATOM    627  OG1 THR A  78      96.600 100.312  56.944  1.00 31.53           O  
ATOM    628  CG2 THR A  78      98.621 100.777  58.155  1.00 33.23           C  
ATOM    629  N   ARG A  79      94.929 102.902  58.820  1.00 31.34           N  
ATOM    630  CA  ARG A  79      93.748 103.574  58.312  1.00 31.65           C  
ATOM    631  C   ARG A  79      93.249 102.950  57.005  1.00 31.75           C  
ATOM    632  O   ARG A  79      92.086 102.597  56.923  1.00 32.49           O  
ATOM    633  CB  ARG A  79      93.990 105.079  58.111  1.00 31.32           C  
ATOM    634  CG  ARG A  79      92.716 105.846  57.947  1.00 30.76           C  
ATOM    635  CD  ARG A  79      92.956 107.326  57.835  1.00 32.73           C  
ATOM    636  NE  ARG A  79      91.703 108.083  57.705  1.00 32.30           N  
ATOM    637  CZ  ARG A  79      90.957 108.108  56.601  1.00 32.64           C  
ATOM    638  NH1 ARG A  79      91.340 107.465  55.487  1.00 32.75           N  
ATOM    639  NH2 ARG A  79      89.836 108.814  56.594  1.00 32.58           N  
ATOM    640  N   SER A  80      94.114 102.808  56.001  1.00 31.80           N  
ATOM    641  CA  SER A  80      93.700 102.241  54.712  1.00 31.83           C  
ATOM    642  C   SER A  80      93.156 100.836  54.904  1.00 31.95           C  
ATOM    643  O   SER A  80      92.136 100.482  54.327  1.00 32.38           O  
ATOM    644  CB  SER A  80      94.856 102.213  53.698  1.00 31.84           C  
ATOM    645  OG  SER A  80      95.285 103.534  53.353  1.00 32.30           O  
ATOM    646  N   GLN A  81      93.816 100.036  55.728  1.00 31.93           N  
ATOM    647  CA  GLN A  81      93.353  98.672  55.968  1.00 32.00           C  
ATOM    648  C   GLN A  81      92.019  98.685  56.717  1.00 31.85           C  
ATOM    649  O   GLN A  81      91.167  97.817  56.521  1.00 31.33           O  
ATOM    650  CB  GLN A  81      94.402  97.852  56.728  1.00 31.80           C  
ATOM    651  CG  GLN A  81      95.594  97.455  55.887  1.00 31.90           C  
ATOM    652  CD  GLN A  81      96.770  96.970  56.718  1.00 32.60           C  
ATOM    653  OE1 GLN A  81      96.625  96.168  57.645  1.00 32.84           O  
ATOM    654  NE2 GLN A  81      97.948  97.469  56.395  1.00 33.68           N  
ATOM    655  N   SER A  82      91.825  99.678  57.568  1.00 31.89           N  
ATOM    656  CA  SER A  82      90.559  99.763  58.275  1.00 32.33           C  
ATOM    657  C   SER A  82      89.469 100.116  57.268  1.00 32.79           C  
ATOM    658  O   SER A  82      88.377  99.509  57.297  1.00 33.20           O  
ATOM    659  CB  SER A  82      90.637 100.730  59.468  1.00 32.32           C  
ATOM    660  OG  SER A  82      91.398 100.129  60.521  1.00 31.01           O  
ATOM    661  N   VAL A  83      89.780 101.018  56.328  1.00 32.46           N  
ATOM    662  CA  VAL A  83      88.845 101.312  55.257  1.00 32.59           C  
ATOM    663  C   VAL A  83      88.499 100.031  54.504  1.00 33.24           C  
ATOM    664  O   VAL A  83      87.339  99.662  54.428  1.00 33.71           O  
ATOM    665  CB  VAL A  83      89.337 102.439  54.324  1.00 32.76           C  
ATOM    666  CG1 VAL A  83      88.399 102.632  53.138  1.00 31.96           C  
ATOM    667  CG2 VAL A  83      89.441 103.784  55.114  1.00 33.13           C  
ATOM    668  N   ARG A  84      89.499  99.323  53.994  1.00 34.01           N  
ATOM    669  CA  ARG A  84      89.266  98.092  53.211  1.00 34.26           C  
ATOM    670  C   ARG A  84      88.384  97.071  53.943  1.00 34.69           C  
ATOM    671  O   ARG A  84      87.484  96.470  53.365  1.00 34.57           O  
ATOM    672  CB  ARG A  84      90.612  97.449  52.786  1.00 34.26           C  
ATOM    673  CG  ARG A  84      91.294  98.192  51.632  1.00 33.47           C  
ATOM    674  CD  ARG A  84      92.443  97.427  50.994  1.00 34.09           C  
ATOM    675  NE  ARG A  84      93.672  97.417  51.805  1.00 35.06           N  
ATOM    676  CZ  ARG A  84      94.616  98.366  51.809  1.00 34.90           C  
ATOM    677  NH1 ARG A  84      94.498  99.460  51.069  1.00 35.19           N  
ATOM    678  NH2 ARG A  84      95.689  98.227  52.582  1.00 34.52           N  
ATOM    679  N   SER A  85      88.654  96.891  55.229  1.00 35.20           N  
ATOM    680  CA  SER A  85      87.870  95.994  56.073  1.00 35.26           C  
ATOM    681  C   SER A  85      86.369  96.333  56.053  1.00 35.14           C  
ATOM    682  O   SER A  85      85.517  95.442  56.115  1.00 35.43           O  
ATOM    683  CB  SER A  85      88.408  96.090  57.494  1.00 35.44           C  
ATOM    684  OG  SER A  85      87.705  95.261  58.368  1.00 36.52           O  
ATOM    685  N   ALA A  86      86.059  97.624  55.988  1.00 34.86           N  
ATOM    686  CA  ALA A  86      84.682  98.100  55.914  1.00 34.59           C  
ATOM    687  C   ALA A  86      84.081  97.829  54.541  1.00 34.52           C  
ATOM    688  O   ALA A  86      82.897  97.438  54.420  1.00 34.52           O  
ATOM    689  CB  ALA A  86      84.634  99.585  56.193  1.00 34.76           C  
ATOM    690  N   LEU A  87      84.887  98.045  53.504  1.00 33.63           N  
ATOM    691  CA  LEU A  87      84.434  97.793  52.146  1.00 33.37           C  
ATOM    692  C   LEU A  87      84.069  96.322  51.928  1.00 32.99           C  
ATOM    693  O   LEU A  87      83.115  96.020  51.218  1.00 32.92           O  
ATOM    694  CB  LEU A  87      85.489  98.227  51.133  1.00 33.53           C  
ATOM    695  CG  LEU A  87      85.893  99.697  51.185  1.00 34.53           C  
ATOM    696  CD1 LEU A  87      87.085  99.931  50.285  1.00 35.20           C  
ATOM    697  CD2 LEU A  87      84.742 100.596  50.806  1.00 35.12           C  
ATOM    698  N   GLU A  88      84.826  95.408  52.525  1.00 32.72           N  
ATOM    699  CA  GLU A  88      84.556  93.992  52.349  1.00 32.54           C  
ATOM    700  C   GLU A  88      83.262  93.644  53.068  1.00 32.18           C  
ATOM    701  O   GLU A  88      82.425  92.933  52.535  1.00 31.89           O  
ATOM    702  CB  GLU A  88      85.719  93.139  52.849  1.00 32.76           C  
ATOM    703  CG  GLU A  88      87.025  93.346  52.083  1.00 33.48           C  
ATOM    704  N   PHE A  89      83.073  94.200  54.253  1.00 32.24           N  
ATOM    705  CA  PHE A  89      81.841  93.998  55.007  1.00 32.47           C  
ATOM    706  C   PHE A  89      80.611  94.526  54.273  1.00 32.52           C  
ATOM    707  O   PHE A  89      79.543  93.899  54.287  1.00 32.30           O  
ATOM    708  CB  PHE A  89      81.950  94.681  56.369  1.00 32.62           C  
ATOM    709  CG  PHE A  89      80.678  94.644  57.155  1.00 33.28           C  
ATOM    710  CD1 PHE A  89      79.718  95.644  57.002  1.00 33.74           C  
ATOM    711  CD2 PHE A  89      80.429  93.610  58.036  1.00 32.39           C  
ATOM    712  CE1 PHE A  89      78.543  95.586  57.716  1.00 33.31           C  
ATOM    713  CE2 PHE A  89      79.276  93.567  58.747  1.00 31.57           C  
ATOM    714  CZ  PHE A  89      78.332  94.549  58.591  1.00 32.72           C  
ATOM    715  N   LEU A  90      80.764  95.696  53.650  1.00 32.75           N  
ATOM    716  CA  LEU A  90      79.668  96.333  52.915  1.00 32.77           C  
ATOM    717  C   LEU A  90      79.359  95.688  51.563  1.00 32.69           C  
ATOM    718  O   LEU A  90      78.280  95.905  50.998  1.00 32.63           O  
ATOM    719  CB  LEU A  90      79.947  97.829  52.727  1.00 32.79           C  
ATOM    720  CG  LEU A  90      79.850  98.658  54.006  1.00 33.06           C  
ATOM    721  CD1 LEU A  90      80.388 100.060  53.775  1.00 32.87           C  
ATOM    722  CD2 LEU A  90      78.409  98.706  54.508  1.00 32.51           C  
ATOM    723  N   GLU A  91      80.288  94.888  51.049  1.00 32.73           N  
ATOM    724  CA  GLU A  91      80.121  94.265  49.742  1.00 32.60           C  
ATOM    725  C   GLU A  91      78.760  93.588  49.592  1.00 31.99           C  
ATOM    726  O   GLU A  91      78.106  93.783  48.579  1.00 32.19           O  
ATOM    727  CB  GLU A  91      81.262  93.292  49.461  1.00 32.90           C  
ATOM    728  CG  GLU A  91      81.450  92.987  47.995  1.00 35.32           C  
ATOM    729  CD  GLU A  91      82.908  92.904  47.605  1.00 39.92           C  
ATOM    730  OE1 GLU A  91      83.572  93.973  47.617  1.00 42.84           O  
ATOM    731  OE2 GLU A  91      83.383  91.783  47.278  1.00 42.72           O  
ATOM    732  N   LYS A  92      78.307  92.837  50.602  1.00 31.30           N  
ATOM    733  CA  LYS A  92      77.005  92.144  50.521  1.00 30.62           C  
ATOM    734  C   LYS A  92      75.785  93.063  50.323  1.00 29.99           C  
ATOM    735  O   LYS A  92      74.736  92.628  49.849  1.00 29.18           O  
ATOM    736  CB  LYS A  92      76.796  91.242  51.736  1.00 30.48           C  
ATOM    737  CG  LYS A  92      76.767  91.932  53.086  1.00 31.31           C  
ATOM    738  CD  LYS A  92      76.674  90.902  54.213  1.00 31.33           C  
ATOM    739  CE  LYS A  92      77.500  91.312  55.420  1.00 32.37           C  
ATOM    740  NZ  LYS A  92      78.912  91.009  55.167  1.00 32.02           N  
ATOM    741  N   PHE A  93      75.945  94.333  50.676  1.00 29.69           N  
ATOM    742  CA  PHE A  93      74.878  95.320  50.588  1.00 29.59           C  
ATOM    743  C   PHE A  93      74.820  96.030  49.249  1.00 29.50           C  
ATOM    744  O   PHE A  93      73.765  96.541  48.867  1.00 28.65           O  
ATOM    745  CB  PHE A  93      75.037  96.351  51.707  1.00 29.63           C  
ATOM    746  CG  PHE A  93      74.876  95.773  53.069  1.00 29.16           C  
ATOM    747  CD1 PHE A  93      73.657  95.252  53.466  1.00 29.31           C  
ATOM    748  CD2 PHE A  93      75.940  95.713  53.947  1.00 29.78           C  
ATOM    749  CE1 PHE A  93      73.490  94.695  54.731  1.00 29.02           C  
ATOM    750  CE2 PHE A  93      75.777  95.148  55.210  1.00 30.52           C  
ATOM    751  CZ  PHE A  93      74.533  94.645  55.596  1.00 29.09           C  
ATOM    752  N   SER A  94      75.963  96.057  48.556  1.00 29.96           N  
ATOM    753  CA  SER A  94      76.133  96.717  47.256  1.00 30.00           C  
ATOM    754  C   SER A  94      75.678  98.187  47.267  1.00 30.11           C  
ATOM    755  O   SER A  94      74.880  98.605  46.407  1.00 30.34           O  
ATOM    756  CB  SER A  94      75.398  95.941  46.168  1.00 29.87           C  
ATOM    757  OG  SER A  94      75.639  96.544  44.908  1.00 31.03           O  
ATOM    758  N   PRO A  95      76.197  98.979  48.227  1.00 30.02           N  
ATOM    759  CA  PRO A  95      75.764 100.361  48.436  1.00 30.06           C  
ATOM    760  C   PRO A  95      76.253 101.268  47.345  1.00 30.41           C  
ATOM    761  O   PRO A  95      77.368 101.073  46.855  1.00 30.81           O  
ATOM    762  CB  PRO A  95      76.449 100.747  49.740  1.00 30.20           C  
ATOM    763  CG  PRO A  95      77.654  99.905  49.780  1.00 29.95           C  
ATOM    764  CD  PRO A  95      77.270  98.601  49.164  1.00 29.92           C  
ATOM    765  N   SER A  96      75.445 102.264  46.984  1.00 30.43           N  
ATOM    766  CA  SER A  96      75.780 103.155  45.878  1.00 30.69           C  
ATOM    767  C   SER A  96      76.902 104.129  46.220  1.00 30.51           C  
ATOM    768  O   SER A  96      77.753 104.401  45.387  1.00 29.87           O  
ATOM    769  CB  SER A  96      74.544 103.928  45.418  1.00 31.01           C  
ATOM    770  OG  SER A  96      73.616 103.074  44.752  1.00 32.87           O  
ATOM    771  N   TYR A  97      76.872 104.667  47.440  1.00 30.98           N  
ATOM    772  CA  TYR A  97      77.837 105.682  47.893  1.00 31.13           C  
ATOM    773  C   TYR A  97      78.278 105.360  49.304  1.00 31.41           C  
ATOM    774  O   TYR A  97      77.525 104.744  50.094  1.00 30.52           O  
ATOM    775  CB  TYR A  97      77.260 107.112  47.815  1.00 30.94           C  
ATOM    776  CG  TYR A  97      77.001 107.522  46.389  1.00 31.48           C  
ATOM    777  CD1 TYR A  97      75.826 107.155  45.731  1.00 31.36           C  
ATOM    778  CD2 TYR A  97      77.969 108.201  45.662  1.00 31.61           C  
ATOM    779  CE1 TYR A  97      75.624 107.487  44.390  1.00 31.47           C  
ATOM    780  CE2 TYR A  97      77.769 108.540  44.340  1.00 31.52           C  
ATOM    781  CZ  TYR A  97      76.602 108.181  43.701  1.00 30.96           C  
ATOM    782  OH  TYR A  97      76.433 108.533  42.372  1.00 31.34           O  
ATOM    783  N   VAL A  98      79.513 105.770  49.601  1.00 31.73           N  
ATOM    784  CA  VAL A  98      80.121 105.506  50.884  1.00 31.93           C  
ATOM    785  C   VAL A  98      80.823 106.764  51.414  1.00 31.96           C  
ATOM    786  O   VAL A  98      81.558 107.448  50.701  1.00 31.85           O  
ATOM    787  CB  VAL A  98      81.038 104.244  50.787  1.00 32.19           C  
ATOM    788  CG1 VAL A  98      82.408 104.551  50.203  1.00 32.33           C  
ATOM    789  CG2 VAL A  98      81.186 103.613  52.100  1.00 32.79           C  
ATOM    790  N   LEU A  99      80.535 107.093  52.668  1.00 32.39           N  
ATOM    791  CA  LEU A  99      81.112 108.246  53.342  1.00 32.37           C  
ATOM    792  C   LEU A  99      82.076 107.773  54.395  1.00 32.29           C  
ATOM    793  O   LEU A  99      81.730 106.931  55.206  1.00 32.71           O  
ATOM    794  CB  LEU A  99      80.006 109.041  54.002  1.00 32.68           C  
ATOM    795  CG  LEU A  99      80.464 110.336  54.682  1.00 34.65           C  
ATOM    796  CD1 LEU A  99      79.420 111.424  54.527  1.00 35.50           C  
ATOM    797  CD2 LEU A  99      80.800 110.107  56.164  1.00 35.98           C  
ATOM    798  N   VAL A 100      83.285 108.317  54.404  1.00 32.65           N  
ATOM    799  CA  VAL A 100      84.323 107.889  55.355  1.00 32.67           C  
ATOM    800  C   VAL A 100      84.665 109.053  56.278  1.00 32.93           C  
ATOM    801  O   VAL A 100      84.741 110.199  55.814  1.00 33.59           O  
ATOM    802  CB  VAL A 100      85.571 107.381  54.628  1.00 32.31           C  
ATOM    803  CG1 VAL A 100      86.582 106.846  55.614  1.00 32.58           C  
ATOM    804  CG2 VAL A 100      85.181 106.290  53.658  1.00 32.53           C  
ATOM    805  N   HIS A 101      84.835 108.769  57.575  1.00 32.52           N  
ATOM    806  CA  HIS A 101      85.084 109.821  58.542  1.00 32.71           C  
ATOM    807  C   HIS A 101      85.956 109.369  59.690  1.00 33.24           C  
ATOM    808  O   HIS A 101      85.706 108.304  60.290  1.00 33.98           O  
ATOM    809  CB  HIS A 101      83.765 110.351  59.108  1.00 32.65           C  
ATOM    810  CG  HIS A 101      83.933 111.472  60.094  1.00 32.57           C  
ATOM    811  ND1 HIS A 101      84.170 112.778  59.708  1.00 30.65           N  
ATOM    812  CD2 HIS A 101      83.896 111.480  61.451  1.00 31.01           C  
ATOM    813  CE1 HIS A 101      84.269 113.540  60.784  1.00 30.57           C  
ATOM    814  NE2 HIS A 101      84.113 112.776  61.853  1.00 30.87           N  
ATOM    815  N   ASP A 102      86.958 110.183  60.024  1.00 33.00           N  
ATOM    816  CA  ASP A 102      87.786 109.893  61.187  1.00 32.99           C  
ATOM    817  C   ASP A 102      86.954 110.160  62.407  1.00 33.19           C  
ATOM    818  O   ASP A 102      86.428 111.260  62.552  1.00 33.32           O  
ATOM    819  CB  ASP A 102      89.029 110.775  61.238  1.00 33.02           C  
ATOM    820  CG  ASP A 102      89.886 110.660  59.985  1.00 33.03           C  
ATOM    821  OD1 ASP A 102      89.908 109.604  59.339  1.00 34.44           O  
ATOM    822  OD2 ASP A 102      90.560 111.630  59.645  1.00 32.80           O  
ATOM    823  N   SER A 103      86.813 109.160  63.280  1.00 33.11           N  
ATOM    824  CA  SER A 103      86.076 109.355  64.513  1.00 33.14           C  
ATOM    825  C   SER A 103      86.755 110.402  65.378  1.00 33.40           C  
ATOM    826  O   SER A 103      86.103 111.028  66.193  1.00 33.84           O  
ATOM    827  CB  SER A 103      85.944 108.053  65.290  1.00 33.20           C  
ATOM    828  OG  SER A 103      87.218 107.549  65.666  1.00 34.37           O  
ATOM    829  N   ALA A 104      88.061 110.582  65.198  1.00 33.80           N  
ATOM    830  CA  ALA A 104      88.840 111.578  65.937  1.00 34.23           C  
ATOM    831  C   ALA A 104      88.564 113.027  65.537  1.00 34.42           C  
ATOM    832  O   ALA A 104      89.090 113.940  66.149  1.00 34.17           O  
ATOM    833  CB  ALA A 104      90.315 111.283  65.786  1.00 34.70           C  
ATOM    834  N   ARG A 105      87.775 113.231  64.490  1.00 34.87           N  
ATOM    835  CA  ARG A 105      87.179 114.533  64.196  1.00 35.35           C  
ATOM    836  C   ARG A 105      85.768 114.395  64.700  1.00 35.29           C  
ATOM    837  O   ARG A 105      84.912 113.886  63.979  1.00 36.05           O  
ATOM    838  CB  ARG A 105      87.159 114.815  62.683  1.00 34.94           C  
ATOM    839  CG  ARG A 105      88.532 114.784  62.056  1.00 36.78           C  
ATOM    840  CD  ARG A 105      88.536 115.120  60.571  1.00 37.10           C  
ATOM    841  NE  ARG A 105      89.799 115.801  60.210  1.00 38.68           N  
ATOM    842  CZ  ARG A 105      90.856 115.168  59.735  1.00 38.29           C  
ATOM    843  NH1 ARG A 105      90.792 113.878  59.571  1.00 41.02           N  
ATOM    844  NH2 ARG A 105      91.966 115.807  59.429  1.00 38.01           N  
ATOM    845  N   PRO A 106      85.502 114.821  65.936  1.00 35.13           N  
ATOM    846  CA  PRO A 106      84.205 114.473  66.508  1.00 35.21           C  
ATOM    847  C   PRO A 106      83.062 115.430  66.210  1.00 35.04           C  
ATOM    848  O   PRO A 106      81.902 115.045  66.376  1.00 34.70           O  
ATOM    849  CB  PRO A 106      84.476 114.478  68.017  1.00 35.14           C  
ATOM    850  CG  PRO A 106      85.777 115.206  68.202  1.00 35.58           C  
ATOM    851  CD  PRO A 106      86.314 115.606  66.869  1.00 35.50           C  
ATOM    852  N   PHE A 107      83.378 116.663  65.816  1.00 34.94           N  
ATOM    853  CA  PHE A 107      82.360 117.710  65.700  1.00 35.08           C  
ATOM    854  C   PHE A 107      81.870 117.897  64.265  1.00 35.23           C  
ATOM    855  O   PHE A 107      82.071 118.912  63.626  1.00 34.50           O  
ATOM    856  CB  PHE A 107      82.904 118.982  66.291  1.00 35.46           C  
ATOM    857  CG  PHE A 107      83.443 118.787  67.662  1.00 35.91           C  
ATOM    858  CD1 PHE A 107      82.579 118.598  68.731  1.00 36.07           C  
ATOM    859  CD2 PHE A 107      84.806 118.727  67.882  1.00 36.12           C  
ATOM    860  CE1 PHE A 107      83.062 118.399  69.999  1.00 36.56           C  
ATOM    861  CE2 PHE A 107      85.304 118.537  69.149  1.00 37.12           C  
ATOM    862  CZ  PHE A 107      84.426 118.372  70.218  1.00 36.88           C  
ATOM    863  N   LEU A 108      81.185 116.862  63.805  1.00 35.95           N  
ATOM    864  CA  LEU A 108      80.692 116.741  62.465  1.00 36.42           C  
ATOM    865  C   LEU A 108      79.265 117.288  62.394  1.00 35.92           C  
ATOM    866  O   LEU A 108      78.411 116.872  63.164  1.00 35.91           O  
ATOM    867  CB  LEU A 108      80.715 115.250  62.069  1.00 36.36           C  
ATOM    868  CG  LEU A 108      80.112 114.906  60.698  1.00 37.44           C  
ATOM    869  CD1 LEU A 108      80.866 115.595  59.581  1.00 36.90           C  
ATOM    870  CD2 LEU A 108      80.068 113.397  60.489  1.00 37.68           C  
ATOM    871  N   ARG A 109      79.016 118.183  61.444  1.00 35.43           N  
ATOM    872  CA  ARG A 109      77.698 118.745  61.244  1.00 35.31           C  
ATOM    873  C   ARG A 109      76.899 118.044  60.159  1.00 34.91           C  
ATOM    874  O   ARG A 109      77.440 117.572  59.162  1.00 34.68           O  
ATOM    875  CB  ARG A 109      77.773 120.241  60.921  1.00 35.43           C  
ATOM    876  CG  ARG A 109      77.626 121.132  62.135  1.00 36.03           C  
ATOM    877  CD  ARG A 109      78.771 120.956  63.099  1.00 37.15           C  
ATOM    878  NE  ARG A 109      80.060 120.817  62.422  1.00 38.58           N  
ATOM    879  CZ  ARG A 109      80.814 121.811  61.934  1.00 38.77           C  
ATOM    880  NH1 ARG A 109      80.437 123.080  62.017  1.00 39.73           N  
ATOM    881  NH2 ARG A 109      81.974 121.520  61.360  1.00 38.42           N  
ATOM    882  N   LYS A 110      75.591 118.013  60.381  1.00 34.84           N  
ATOM    883  CA  LYS A 110      74.621 117.517  59.423  1.00 35.02           C  
ATOM    884  C   LYS A 110      74.890 118.080  58.032  1.00 35.05           C  
ATOM    885  O   LYS A 110      75.113 117.312  57.115  1.00 35.29           O  
ATOM    886  CB  LYS A 110      73.194 117.876  59.885  1.00 35.13           C  
ATOM    887  CG  LYS A 110      72.084 117.075  59.211  1.00 35.34           C  
ATOM    888  CD  LYS A 110      70.706 117.654  59.531  1.00 34.96           C  
ATOM    889  CE  LYS A 110      70.195 117.180  60.888  1.00 34.98           C  
ATOM    890  NZ  LYS A 110      69.820 115.736  60.842  1.00 34.63           N  
ATOM    891  N   LYS A 111      74.912 119.404  57.882  1.00 34.89           N  
ATOM    892  CA  LYS A 111      75.083 120.009  56.560  1.00 35.50           C  
ATOM    893  C   LYS A 111      76.323 119.507  55.819  1.00 34.95           C  
ATOM    894  O   LYS A 111      76.281 119.332  54.610  1.00 35.18           O  
ATOM    895  CB  LYS A 111      75.095 121.541  56.632  1.00 35.47           C  
ATOM    896  CG  LYS A 111      76.295 122.130  57.345  1.00 37.25           C  
ATOM    897  CD  LYS A 111      76.321 123.642  57.232  1.00 37.68           C  
ATOM    898  CE  LYS A 111      77.405 124.254  58.126  1.00 39.91           C  
ATOM    899  NZ  LYS A 111      76.804 124.864  59.367  1.00 40.97           N  
ATOM    900  N   HIS A 112      77.411 119.252  56.534  1.00 34.53           N  
ATOM    901  CA  HIS A 112      78.627 118.745  55.899  1.00 34.44           C  
ATOM    902  C   HIS A 112      78.450 117.355  55.297  1.00 34.34           C  
ATOM    903  O   HIS A 112      78.940 117.081  54.202  1.00 34.02           O  
ATOM    904  CB  HIS A 112      79.794 118.722  56.887  1.00 34.57           C  
ATOM    905  CG  HIS A 112      80.262 120.083  57.293  1.00 35.03           C  
ATOM    906  ND1 HIS A 112      80.256 121.162  56.430  1.00 36.48           N  
ATOM    907  CD2 HIS A 112      80.758 120.541  58.465  1.00 34.91           C  
ATOM    908  CE1 HIS A 112      80.728 122.228  57.054  1.00 35.49           C  
ATOM    909  NE2 HIS A 112      81.047 121.875  58.288  1.00 35.82           N  
ATOM    910  N   VAL A 113      77.760 116.481  56.025  1.00 34.33           N  
ATOM    911  CA  VAL A 113      77.487 115.126  55.566  1.00 34.04           C  
ATOM    912  C   VAL A 113      76.742 115.160  54.234  1.00 34.15           C  
ATOM    913  O   VAL A 113      77.146 114.501  53.271  1.00 34.24           O  
ATOM    914  CB  VAL A 113      76.683 114.329  56.634  1.00 34.15           C  
ATOM    915  CG1 VAL A 113      76.139 113.028  56.091  1.00 33.95           C  
ATOM    916  CG2 VAL A 113      77.568 114.026  57.846  1.00 35.38           C  
ATOM    917  N   SER A 114      75.664 115.934  54.162  1.00 34.03           N  
ATOM    918  CA  SER A 114      74.800 115.896  52.987  1.00 33.95           C  
ATOM    919  C   SER A 114      75.443 116.608  51.819  1.00 33.97           C  
ATOM    920  O   SER A 114      75.261 116.225  50.664  1.00 33.62           O  
ATOM    921  CB  SER A 114      73.416 116.470  53.296  1.00 33.83           C  
ATOM    922  OG  SER A 114      73.494 117.504  54.246  1.00 33.96           O  
ATOM    923  N   GLU A 115      76.221 117.636  52.119  1.00 34.55           N  
ATOM    924  CA  GLU A 115      76.881 118.389  51.064  1.00 35.24           C  
ATOM    925  C   GLU A 115      77.985 117.546  50.403  1.00 34.85           C  
ATOM    926  O   GLU A 115      78.104 117.521  49.185  1.00 34.78           O  
ATOM    927  CB  GLU A 115      77.415 119.727  51.606  1.00 35.77           C  
ATOM    928  CG  GLU A 115      78.027 120.676  50.548  1.00 38.63           C  
ATOM    929  CD  GLU A 115      77.092 120.952  49.364  1.00 42.43           C  
ATOM    930  OE1 GLU A 115      75.843 120.899  49.568  1.00 43.87           O  
ATOM    931  OE2 GLU A 115      77.609 121.212  48.238  1.00 42.95           O  
ATOM    932  N   VAL A 116      78.762 116.825  51.200  1.00 34.48           N  
ATOM    933  CA  VAL A 116      79.846 116.020  50.654  1.00 34.41           C  
ATOM    934  C   VAL A 116      79.295 114.827  49.852  1.00 34.47           C  
ATOM    935  O   VAL A 116      79.865 114.438  48.828  1.00 34.05           O  
ATOM    936  CB  VAL A 116      80.790 115.551  51.772  1.00 34.10           C  
ATOM    937  CG1 VAL A 116      80.201 114.401  52.512  1.00 34.69           C  
ATOM    938  CG2 VAL A 116      82.103 115.138  51.224  1.00 34.82           C  
ATOM    939  N   LEU A 117      78.179 114.262  50.320  1.00 34.55           N  
ATOM    940  CA  LEU A 117      77.533 113.158  49.635  1.00 34.33           C  
ATOM    941  C   LEU A 117      76.925 113.601  48.318  1.00 33.88           C  
ATOM    942  O   LEU A 117      77.049 112.890  47.335  1.00 33.39           O  
ATOM    943  CB  LEU A 117      76.459 112.502  50.510  1.00 34.45           C  
ATOM    944  CG  LEU A 117      77.004 111.434  51.462  1.00 35.65           C  
ATOM    945  CD1 LEU A 117      75.959 111.004  52.493  1.00 36.16           C  
ATOM    946  CD2 LEU A 117      77.539 110.218  50.702  1.00 35.37           C  
ATOM    947  N   ARG A 118      76.274 114.759  48.270  1.00 33.66           N  
ATOM    948  CA  ARG A 118      75.688 115.149  46.989  1.00 34.28           C  
ATOM    949  C   ARG A 118      76.793 115.600  46.037  1.00 34.16           C  
ATOM    950  O   ARG A 118      76.675 115.500  44.825  1.00 33.91           O  
ATOM    951  CB  ARG A 118      74.538 116.176  47.116  1.00 34.39           C  
ATOM    952  CG  ARG A 118      74.941 117.584  47.396  1.00 34.86           C  
ATOM    953  CD  ARG A 118      74.102 118.612  46.653  1.00 35.00           C  
ATOM    954  NE  ARG A 118      74.907 119.833  46.544  1.00 35.96           N  
ATOM    955  CZ  ARG A 118      75.249 120.451  45.414  1.00 35.77           C  
ATOM    956  NH1 ARG A 118      74.809 120.034  44.236  1.00 36.71           N  
ATOM    957  NH2 ARG A 118      76.019 121.526  45.470  1.00 36.00           N  
ATOM    958  N   ARG A 119      77.892 116.062  46.605  1.00 34.50           N  
ATOM    959  CA  ARG A 119      79.005 116.507  45.809  1.00 34.88           C  
ATOM    960  C   ARG A 119      79.759 115.311  45.247  1.00 34.95           C  
ATOM    961  O   ARG A 119      80.366 115.395  44.194  1.00 35.13           O  
ATOM    962  CB  ARG A 119      79.888 117.418  46.644  1.00 35.00           C  
ATOM    963  CG  ARG A 119      80.813 118.272  45.844  1.00 36.34           C  
ATOM    964  CD  ARG A 119      80.175 119.480  45.151  1.00 37.03           C  
ATOM    965  NE  ARG A 119      81.187 119.994  44.226  1.00 37.66           N  
ATOM    966  CZ  ARG A 119      81.215 119.786  42.907  1.00 38.97           C  
ATOM    967  NH1 ARG A 119      80.255 119.098  42.288  1.00 38.89           N  
ATOM    968  NH2 ARG A 119      82.224 120.292  42.194  1.00 38.92           N  
ATOM    969  N   ALA A 120      79.690 114.188  45.944  1.00 35.70           N  
ATOM    970  CA  ALA A 120      80.191 112.912  45.433  1.00 36.01           C  
ATOM    971  C   ALA A 120      79.253 112.252  44.392  1.00 36.49           C  
ATOM    972  O   ALA A 120      79.697 111.423  43.592  1.00 36.41           O  
ATOM    973  CB  ALA A 120      80.445 111.962  46.599  1.00 36.08           C  
ATOM    974  N   ARG A 121      77.963 112.597  44.411  1.00 37.02           N  
ATOM    975  CA  ARG A 121      77.028 112.128  43.376  1.00 37.55           C  
ATOM    976  C   ARG A 121      77.410 112.606  42.008  1.00 37.54           C  
ATOM    977  O   ARG A 121      77.255 111.878  41.030  1.00 38.37           O  
ATOM    978  CB  ARG A 121      75.623 112.663  43.587  1.00 38.00           C  
ATOM    979  CG  ARG A 121      74.628 111.658  43.998  1.00 39.96           C  
ATOM    980  CD  ARG A 121      74.635 111.448  45.492  1.00 42.86           C  
ATOM    981  NE  ARG A 121      73.490 110.634  45.883  1.00 44.62           N  
ATOM    982  CZ  ARG A 121      73.283 110.177  47.110  1.00 46.34           C  
ATOM    983  NH1 ARG A 121      74.145 110.477  48.085  1.00 48.05           N  
ATOM    984  NH2 ARG A 121      72.214 109.423  47.355  1.00 45.64           N  
ATOM    985  N   GLU A 122      77.855 113.852  41.934  1.00 37.08           N  
ATOM    986  CA  GLU A 122      78.170 114.462  40.666  1.00 37.15           C  
ATOM    987  C   GLU A 122      79.506 113.999  40.112  1.00 36.79           C  
ATOM    988  O   GLU A 122      79.614 113.774  38.934  1.00 37.01           O  
ATOM    989  CB  GLU A 122      78.177 115.975  40.807  1.00 37.57           C  
ATOM    990  CG  GLU A 122      76.843 116.546  41.290  1.00 39.36           C  
ATOM    991  CD  GLU A 122      77.006 117.892  41.969  1.00 41.82           C  
ATOM    992  OE1 GLU A 122      77.580 118.823  41.347  1.00 42.91           O  
ATOM    993  OE2 GLU A 122      76.567 118.010  43.133  1.00 43.46           O  
ATOM    994  N   THR A 123      80.523 113.856  40.953  1.00 36.54           N  
ATOM    995  CA  THR A 123      81.890 113.606  40.471  1.00 36.00           C  
ATOM    996  C   THR A 123      82.413 112.191  40.719  1.00 35.56           C  
ATOM    997  O   THR A 123      83.219 111.680  39.941  1.00 35.83           O  
ATOM    998  CB  THR A 123      82.827 114.571  41.148  1.00 36.29           C  
ATOM    999  OG1 THR A 123      82.726 114.403  42.571  1.00 35.49           O  
ATOM   1000  CG2 THR A 123      82.445 115.998  40.774  1.00 36.34           C  
ATOM   1001  N   GLY A 124      81.946 111.566  41.791  1.00 34.87           N  
ATOM   1002  CA  GLY A 124      82.359 110.222  42.169  1.00 34.53           C  
ATOM   1003  C   GLY A 124      83.172 110.249  43.444  1.00 34.40           C  
ATOM   1004  O   GLY A 124      83.324 109.233  44.117  1.00 33.96           O  
ATOM   1005  N   ALA A 125      83.671 111.438  43.779  1.00 34.29           N  
ATOM   1006  CA  ALA A 125      84.648 111.604  44.823  1.00 33.99           C  
ATOM   1007  C   ALA A 125      84.662 113.046  45.343  1.00 33.96           C  
ATOM   1008  O   ALA A 125      84.687 114.007  44.564  1.00 33.43           O  
ATOM   1009  CB  ALA A 125      86.015 111.241  44.280  1.00 34.29           C  
ATOM   1010  N   ALA A 126      84.673 113.184  46.668  1.00 34.03           N  
ATOM   1011  CA  ALA A 126      84.680 114.493  47.305  1.00 34.22           C  
ATOM   1012  C   ALA A 126      85.160 114.404  48.733  1.00 34.21           C  
ATOM   1013  O   ALA A 126      85.058 113.368  49.390  1.00 34.83           O  
ATOM   1014  CB  ALA A 126      83.285 115.127  47.266  1.00 34.33           C  
ATOM   1015  N   THR A 127      85.689 115.511  49.218  1.00 34.21           N  
ATOM   1016  CA  THR A 127      86.125 115.573  50.592  1.00 33.93           C  
ATOM   1017  C   THR A 127      85.954 116.963  51.127  1.00 33.65           C  
ATOM   1018  O   THR A 127      86.115 117.956  50.409  1.00 33.46           O  
ATOM   1019  CB  THR A 127      87.610 115.178  50.781  1.00 33.89           C  
ATOM   1020  OG1 THR A 127      87.904 115.141  52.191  1.00 33.24           O  
ATOM   1021  CG2 THR A 127      88.533 116.178  50.078  1.00 33.03           C  
ATOM   1022  N   LEU A 128      85.635 117.010  52.409  1.00 33.49           N  
ATOM   1023  CA  LEU A 128      85.605 118.254  53.120  1.00 33.46           C  
ATOM   1024  C   LEU A 128      87.066 118.698  53.219  1.00 33.11           C  
ATOM   1025  O   LEU A 128      87.991 117.874  53.290  1.00 32.74           O  
ATOM   1026  CB  LEU A 128      84.939 118.050  54.481  1.00 33.63           C  
ATOM   1027  CG  LEU A 128      84.149 119.223  55.037  1.00 34.93           C  
ATOM   1028  CD1 LEU A 128      82.922 119.518  54.208  1.00 36.13           C  
ATOM   1029  CD2 LEU A 128      83.723 118.941  56.434  1.00 36.02           C  
ATOM   1030  N   ALA A 129      87.272 120.002  53.164  1.00 33.08           N  
ATOM   1031  CA  ALA A 129      88.615 120.573  53.119  1.00 32.96           C  
ATOM   1032  C   ALA A 129      88.576 122.009  53.631  1.00 33.20           C  
ATOM   1033  O   ALA A 129      87.495 122.620  53.713  1.00 33.67           O  
ATOM   1034  CB  ALA A 129      89.150 120.531  51.720  1.00 32.57           C  
ATOM   1035  N   LEU A 130      89.751 122.537  53.963  1.00 33.13           N  
ATOM   1036  CA  LEU A 130      89.887 123.849  54.579  1.00 32.86           C  
ATOM   1037  C   LEU A 130      91.086 124.564  53.990  1.00 32.68           C  
ATOM   1038  O   LEU A 130      92.173 123.988  53.929  1.00 32.20           O  
ATOM   1039  CB  LEU A 130      90.105 123.643  56.064  1.00 33.38           C  
ATOM   1040  CG  LEU A 130      89.596 124.692  57.043  1.00 34.66           C  
ATOM   1041  CD1 LEU A 130      88.132 125.092  56.747  1.00 35.85           C  
ATOM   1042  CD2 LEU A 130      89.741 124.116  58.441  1.00 33.92           C  
ATOM   1043  N   LYS A 131      90.871 125.793  53.511  1.00 32.63           N  
ATOM   1044  CA  LYS A 131      91.954 126.658  53.046  1.00 32.36           C  
ATOM   1045  C   LYS A 131      92.938 126.881  54.180  1.00 31.76           C  
ATOM   1046  O   LYS A 131      92.554 127.124  55.314  1.00 31.87           O  
ATOM   1047  CB  LYS A 131      91.424 128.025  52.597  1.00 32.55           C  
ATOM   1048  CG  LYS A 131      90.751 128.062  51.221  1.00 33.92           C  
ATOM   1049  CD  LYS A 131      90.009 129.381  50.996  1.00 33.40           C  
ATOM   1050  CE  LYS A 131      89.265 129.393  49.649  1.00 34.76           C  
ATOM   1051  NZ  LYS A 131      88.654 130.740  49.303  1.00 35.35           N  
ATOM   1052  N   ASN A 132      94.215 126.802  53.869  1.00 31.31           N  
ATOM   1053  CA  ASN A 132      95.240 127.144  54.826  1.00 31.03           C  
ATOM   1054  C   ASN A 132      95.090 128.606  55.245  1.00 30.49           C  
ATOM   1055  O   ASN A 132      94.773 129.432  54.414  1.00 30.06           O  
ATOM   1056  CB  ASN A 132      96.606 126.915  54.181  1.00 31.31           C  
ATOM   1057  CG  ASN A 132      97.748 127.321  55.069  1.00 31.24           C  
ATOM   1058  OD1 ASN A 132      97.950 126.733  56.127  1.00 32.84           O  
ATOM   1059  ND2 ASN A 132      98.505 128.329  54.644  1.00 31.64           N  
ATOM   1060  N   SER A 133      95.312 128.913  56.522  1.00 30.04           N  
ATOM   1061  CA  SER A 133      95.343 130.310  56.992  1.00 29.95           C  
ATOM   1062  C   SER A 133      96.616 130.705  57.776  1.00 29.83           C  
ATOM   1063  O   SER A 133      96.673 131.782  58.391  1.00 29.46           O  
ATOM   1064  CB  SER A 133      94.143 130.563  57.880  1.00 29.95           C  
ATOM   1065  OG  SER A 133      94.172 129.645  58.953  1.00 29.68           O  
ATOM   1066  N   ASP A 134      97.619 129.833  57.762  1.00 29.67           N  
ATOM   1067  CA  ASP A 134      98.842 130.062  58.489  1.00 29.61           C  
ATOM   1068  C   ASP A 134     100.016 130.035  57.525  1.00 29.90           C  
ATOM   1069  O   ASP A 134      99.940 129.431  56.458  1.00 29.94           O  
ATOM   1070  CB  ASP A 134      99.042 128.967  59.525  1.00 29.61           C  
ATOM   1071  CG  ASP A 134      97.903 128.871  60.527  1.00 29.18           C  
ATOM   1072  OD1 ASP A 134      97.263 129.876  60.847  1.00 27.57           O  
ATOM   1073  OD2 ASP A 134      97.632 127.758  60.997  1.00 30.65           O  
ATOM   1074  N   ALA A 135     101.103 130.700  57.897  1.00 29.82           N  
ATOM   1075  CA  ALA A 135     102.367 130.441  57.250  1.00 29.94           C  
ATOM   1076  C   ALA A 135     102.711 128.958  57.435  1.00 30.28           C  
ATOM   1077  O   ALA A 135     102.413 128.362  58.465  1.00 30.51           O  
ATOM   1078  CB  ALA A 135     103.429 131.308  57.839  1.00 30.23           C  
ATOM   1079  N   LEU A 136     103.309 128.343  56.428  1.00 30.80           N  
ATOM   1080  CA  LEU A 136     103.574 126.906  56.471  1.00 31.22           C  
ATOM   1081  C   LEU A 136     105.045 126.640  56.256  1.00 31.59           C  
ATOM   1082  O   LEU A 136     105.655 127.263  55.376  1.00 31.72           O  
ATOM   1083  CB  LEU A 136     102.751 126.177  55.407  1.00 31.10           C  
ATOM   1084  CG  LEU A 136     101.324 125.845  55.830  1.00 31.45           C  
ATOM   1085  CD1 LEU A 136     100.525 125.360  54.647  1.00 32.01           C  
ATOM   1086  CD2 LEU A 136     101.320 124.808  56.948  1.00 31.90           C  
ATOM   1087  N   VAL A 137     105.600 125.717  57.052  1.00 31.90           N  
ATOM   1088  CA  VAL A 137     107.019 125.376  56.986  1.00 32.15           C  
ATOM   1089  C   VAL A 137     107.325 123.915  57.137  1.00 32.40           C  
ATOM   1090  O   VAL A 137     106.557 123.157  57.711  1.00 32.61           O  
ATOM   1091  CB  VAL A 137     107.824 126.023  58.108  1.00 32.35           C  
ATOM   1092  CG1 VAL A 137     107.742 127.539  58.028  1.00 32.79           C  
ATOM   1093  CG2 VAL A 137     107.353 125.506  59.459  1.00 32.46           C  
ATOM   1094  N   ARG A 138     108.512 123.558  56.669  1.00 32.99           N  
ATOM   1095  CA  ARG A 138     109.064 122.217  56.817  1.00 33.21           C  
ATOM   1096  C   ARG A 138     110.402 122.365  57.492  1.00 33.24           C  
ATOM   1097  O   ARG A 138     111.152 123.276  57.152  1.00 33.29           O  
ATOM   1098  CB  ARG A 138     109.278 121.606  55.443  1.00 33.29           C  
ATOM   1099  CG  ARG A 138     109.599 120.142  55.444  1.00 33.83           C  
ATOM   1100  CD  ARG A 138     109.963 119.709  54.036  1.00 35.12           C  
ATOM   1101  NE  ARG A 138     108.954 120.091  53.046  1.00 35.43           N  
ATOM   1102  CZ  ARG A 138     107.809 119.442  52.842  1.00 36.51           C  
ATOM   1103  NH1 ARG A 138     107.509 118.368  53.563  1.00 37.52           N  
ATOM   1104  NH2 ARG A 138     106.956 119.863  51.908  1.00 36.40           N  
ATOM   1105  N   VAL A 139     110.721 121.467  58.418  1.00 33.21           N  
ATOM   1106  CA  VAL A 139     112.020 121.507  59.083  1.00 33.33           C  
ATOM   1107  C   VAL A 139     112.984 120.555  58.379  1.00 33.38           C  
ATOM   1108  O   VAL A 139     112.690 119.373  58.266  1.00 33.17           O  
ATOM   1109  CB  VAL A 139     111.913 121.097  60.563  1.00 33.23           C  
ATOM   1110  CG1 VAL A 139     113.122 121.573  61.322  1.00 33.29           C  
ATOM   1111  CG2 VAL A 139     110.667 121.675  61.181  1.00 33.71           C  
ATOM   1112  N   GLU A 140     114.117 121.084  57.900  1.00 33.63           N  
ATOM   1113  CA  GLU A 140     115.222 120.268  57.361  1.00 33.69           C  
ATOM   1114  C   GLU A 140     116.505 120.594  58.125  1.00 33.88           C  
ATOM   1115  O   GLU A 140     116.909 121.758  58.189  1.00 33.92           O  
ATOM   1116  CB  GLU A 140     115.435 120.531  55.866  1.00 33.57           C  
ATOM   1117  N   ASN A 141     117.121 119.558  58.704  1.00 34.01           N  
ATOM   1118  CA  ASN A 141     118.381 119.643  59.469  1.00 34.03           C  
ATOM   1119  C   ASN A 141     118.679 121.001  60.118  1.00 34.08           C  
ATOM   1120  O   ASN A 141     119.684 121.642  59.798  1.00 34.23           O  
ATOM   1121  CB  ASN A 141     119.568 119.199  58.598  1.00 33.93           C  
ATOM   1122  N   ASP A 142     117.798 121.416  61.033  1.00 33.97           N  
ATOM   1123  CA  ASP A 142     117.942 122.663  61.817  1.00 33.90           C  
ATOM   1124  C   ASP A 142     117.847 123.962  60.988  1.00 33.79           C  
ATOM   1125  O   ASP A 142     118.485 124.964  61.312  1.00 33.74           O  
ATOM   1126  CB  ASP A 142     119.232 122.643  62.656  1.00 33.93           C  
ATOM   1127  N   ARG A 143     117.052 123.926  59.920  1.00 33.63           N  
ATOM   1128  CA  ARG A 143     116.616 125.125  59.207  1.00 33.41           C  
ATOM   1129  C   ARG A 143     115.160 124.865  58.881  1.00 33.49           C  
ATOM   1130  O   ARG A 143     114.758 123.707  58.760  1.00 33.53           O  
ATOM   1131  CB  ARG A 143     117.433 125.342  57.927  1.00 33.36           C  
ATOM   1132  CG  ARG A 143     117.264 126.712  57.279  1.00 32.72           C  
ATOM   1133  N   ILE A 144     114.361 125.925  58.779  1.00 33.57           N  
ATOM   1134  CA  ILE A 144     112.958 125.792  58.394  1.00 33.66           C  
ATOM   1135  C   ILE A 144     112.715 126.354  56.985  1.00 33.62           C  
ATOM   1136  O   ILE A 144     113.024 127.506  56.706  1.00 33.47           O  
ATOM   1137  CB  ILE A 144     111.965 126.430  59.442  1.00 33.94           C  
ATOM   1138  CG1 ILE A 144     111.986 127.955  59.421  1.00 33.93           C  
ATOM   1139  CG2 ILE A 144     112.276 125.964  60.858  1.00 34.30           C  
ATOM   1140  N   GLU A 145     112.169 125.515  56.105  1.00 33.89           N  
ATOM   1141  CA  GLU A 145     111.750 125.914  54.765  1.00 33.79           C  
ATOM   1142  C   GLU A 145     110.338 126.463  54.813  1.00 33.40           C  
ATOM   1143  O   GLU A 145     109.429 125.828  55.345  1.00 33.32           O  
ATOM   1144  CB  GLU A 145     111.762 124.717  53.809  1.00 34.11           C  
ATOM   1145  CG  GLU A 145     111.613 125.094  52.332  1.00 34.86           C  
ATOM   1146  N   TYR A 146     110.165 127.632  54.217  1.00 32.96           N  
ATOM   1147  CA  TYR A 146     108.884 128.301  54.140  1.00 32.43           C  
ATOM   1148  C   TYR A 146     108.175 127.855  52.874  1.00 32.81           C  
ATOM   1149  O   TYR A 146     108.569 128.206  51.771  1.00 32.65           O  
ATOM   1150  CB  TYR A 146     109.091 129.818  54.209  1.00 31.72           C  
ATOM   1151  CG  TYR A 146     109.510 130.244  55.607  1.00 30.89           C  
ATOM   1152  CD1 TYR A 146     110.850 130.251  55.996  1.00 29.30           C  
ATOM   1153  CD2 TYR A 146     108.554 130.570  56.559  1.00 30.30           C  
ATOM   1154  CE1 TYR A 146     111.218 130.604  57.292  1.00 29.48           C  
ATOM   1155  CE2 TYR A 146     108.912 130.929  57.857  1.00 30.37           C  
ATOM   1156  CZ  TYR A 146     110.239 130.942  58.223  1.00 29.86           C  
ATOM   1157  OH  TYR A 146     110.557 131.306  59.512  1.00 29.04           O  
ATOM   1158  N   ILE A 147     107.126 127.061  53.056  1.00 33.51           N  
ATOM   1159  CA  ILE A 147     106.422 126.426  51.951  1.00 34.15           C  
ATOM   1160  C   ILE A 147     105.506 127.423  51.259  1.00 34.47           C  
ATOM   1161  O   ILE A 147     104.813 128.193  51.933  1.00 34.74           O  
ATOM   1162  CB  ILE A 147     105.550 125.282  52.460  1.00 34.25           C  
ATOM   1163  CG1 ILE A 147     106.402 124.209  53.130  1.00 34.79           C  
ATOM   1164  CG2 ILE A 147     104.778 124.650  51.334  1.00 35.27           C  
ATOM   1165  CD1 ILE A 147     105.598 123.343  54.066  1.00 35.91           C  
ATOM   1166  N   PRO A 148     105.493 127.423  49.911  1.00 34.80           N  
ATOM   1167  CA  PRO A 148     104.520 128.247  49.180  1.00 34.68           C  
ATOM   1168  C   PRO A 148     103.085 127.911  49.580  1.00 34.43           C  
ATOM   1169  O   PRO A 148     102.771 126.751  49.778  1.00 34.19           O  
ATOM   1170  CB  PRO A 148     104.779 127.875  47.715  1.00 34.53           C  
ATOM   1171  CG  PRO A 148     106.181 127.422  47.693  1.00 34.49           C  
ATOM   1172  CD  PRO A 148     106.377 126.695  48.983  1.00 34.82           C  
ATOM   1173  N   ARG A 149     102.232 128.929  49.676  1.00 34.56           N  
ATOM   1174  CA  ARG A 149     100.892 128.798  50.262  1.00 34.72           C  
ATOM   1175  C   ARG A 149      99.711 128.839  49.285  1.00 34.32           C  
ATOM   1176  O   ARG A 149      98.601 128.431  49.650  1.00 33.88           O  
ATOM   1177  CB  ARG A 149     100.701 129.868  51.346  1.00 34.82           C  
ATOM   1178  CG  ARG A 149     101.109 129.375  52.729  1.00 35.60           C  
ATOM   1179  CD  ARG A 149     101.143 130.488  53.756  1.00 35.73           C  
ATOM   1180  NE  ARG A 149     102.126 131.520  53.406  1.00 36.09           N  
ATOM   1181  CZ  ARG A 149     101.846 132.664  52.794  1.00 36.58           C  
ATOM   1182  NH1 ARG A 149     100.594 132.947  52.443  1.00 37.35           N  
ATOM   1183  NH2 ARG A 149     102.826 133.531  52.518  1.00 36.44           N  
ATOM   1184  N   LYS A 150      99.933 129.318  48.064  1.00 34.26           N  
ATOM   1185  CA  LYS A 150      98.854 129.387  47.076  1.00 34.52           C  
ATOM   1186  C   LYS A 150      98.194 128.025  46.872  1.00 34.60           C  
ATOM   1187  O   LYS A 150      98.866 127.013  46.685  1.00 34.65           O  
ATOM   1188  CB  LYS A 150      99.351 129.924  45.736  1.00 34.50           C  
ATOM   1189  CG  LYS A 150      98.244 130.087  44.718  1.00 34.87           C  
ATOM   1190  CD  LYS A 150      98.583 131.151  43.675  1.00 35.36           C  
ATOM   1191  CE  LYS A 150      97.673 131.048  42.454  1.00 35.90           C  
ATOM   1192  NZ  LYS A 150      97.713 129.661  41.835  1.00 36.42           N  
ATOM   1193  N   GLY A 151      96.869 128.019  46.948  1.00 34.66           N  
ATOM   1194  CA  GLY A 151      96.084 126.831  46.683  1.00 34.55           C  
ATOM   1195  C   GLY A 151      96.277 125.700  47.655  1.00 34.75           C  
ATOM   1196  O   GLY A 151      95.957 124.559  47.325  1.00 35.47           O  
ATOM   1197  N   VAL A 152      96.784 125.986  48.853  1.00 34.70           N  
ATOM   1198  CA  VAL A 152      96.999 124.924  49.829  1.00 34.59           C  
ATOM   1199  C   VAL A 152      95.744 124.720  50.676  1.00 34.69           C  
ATOM   1200  O   VAL A 152      95.095 125.681  51.097  1.00 34.39           O  
ATOM   1201  CB  VAL A 152      98.219 125.179  50.730  1.00 34.63           C  
ATOM   1202  CG1 VAL A 152      98.373 124.050  51.737  1.00 34.57           C  
ATOM   1203  CG2 VAL A 152      99.489 125.290  49.894  1.00 34.78           C  
ATOM   1204  N   TYR A 153      95.417 123.449  50.910  1.00 34.64           N  
ATOM   1205  CA  TYR A 153      94.218 123.061  51.636  1.00 34.55           C  
ATOM   1206  C   TYR A 153      94.542 121.939  52.594  1.00 34.27           C  
ATOM   1207  O   TYR A 153      95.271 121.018  52.228  1.00 34.32           O  
ATOM   1208  CB  TYR A 153      93.182 122.505  50.656  1.00 34.90           C  
ATOM   1209  CG  TYR A 153      92.372 123.526  49.875  1.00 35.45           C  
ATOM   1210  CD1 TYR A 153      91.159 124.003  50.377  1.00 35.21           C  
ATOM   1211  CD2 TYR A 153      92.787 123.974  48.616  1.00 34.34           C  
ATOM   1212  CE1 TYR A 153      90.401 124.909  49.662  1.00 35.42           C  
ATOM   1213  CE2 TYR A 153      92.026 124.876  47.899  1.00 34.14           C  
ATOM   1214  CZ  TYR A 153      90.839 125.344  48.430  1.00 35.12           C  
ATOM   1215  OH  TYR A 153      90.059 126.253  47.740  1.00 36.10           O  
ATOM   1216  N   ARG A 154      93.970 121.983  53.796  1.00 33.86           N  
ATOM   1217  CA  ARG A 154      93.994 120.827  54.695  1.00 33.66           C  
ATOM   1218  C   ARG A 154      92.879 119.912  54.264  1.00 33.21           C  
ATOM   1219  O   ARG A 154      91.753 120.356  54.144  1.00 33.52           O  
ATOM   1220  CB  ARG A 154      93.772 121.247  56.147  1.00 33.47           C  
ATOM   1221  CG  ARG A 154      94.906 122.123  56.728  1.00 34.42           C  
ATOM   1222  CD  ARG A 154      94.436 123.024  57.879  1.00 35.09           C  
ATOM   1223  NE  ARG A 154      93.946 122.217  59.011  1.00 37.75           N  
ATOM   1224  CZ  ARG A 154      93.574 122.714  60.192  1.00 38.22           C  
ATOM   1225  NH1 ARG A 154      93.598 124.021  60.414  1.00 38.83           N  
ATOM   1226  NH2 ARG A 154      93.153 121.893  61.154  1.00 37.60           N  
ATOM   1227  N   ILE A 155      93.170 118.644  54.010  1.00 33.02           N  
ATOM   1228  CA  ILE A 155      92.116 117.680  53.758  1.00 33.05           C  
ATOM   1229  C   ILE A 155      91.508 117.191  55.091  1.00 33.18           C  
ATOM   1230  O   ILE A 155      92.182 116.576  55.910  1.00 32.76           O  
ATOM   1231  CB  ILE A 155      92.609 116.469  52.937  1.00 33.00           C  
ATOM   1232  CG1 ILE A 155      93.258 116.914  51.614  1.00 33.75           C  
ATOM   1233  CG2 ILE A 155      91.459 115.502  52.666  1.00 32.66           C  
ATOM   1234  CD1 ILE A 155      92.393 117.795  50.725  1.00 34.96           C  
ATOM   1235  N   LEU A 156      90.220 117.460  55.274  1.00 33.31           N  
ATOM   1236  CA  LEU A 156      89.460 116.949  56.416  1.00 33.55           C  
ATOM   1237  C   LEU A 156      88.750 115.663  56.014  1.00 33.77           C  
ATOM   1238  O   LEU A 156      88.974 115.151  54.911  1.00 34.41           O  
ATOM   1239  CB  LEU A 156      88.432 118.000  56.871  1.00 33.54           C  
ATOM   1240  CG  LEU A 156      88.980 119.445  56.934  1.00 33.27           C  
ATOM   1241  CD1 LEU A 156      87.939 120.414  57.417  1.00 33.89           C  
ATOM   1242  CD2 LEU A 156      90.192 119.519  57.816  1.00 33.74           C  
ATOM   1243  N   THR A 157      87.936 115.119  56.922  1.00 33.57           N  
ATOM   1244  CA  THR A 157      86.875 114.165  56.566  1.00 33.30           C  
ATOM   1245  C   THR A 157      85.622 114.809  57.136  1.00 33.28           C  
ATOM   1246  O   THR A 157      85.743 115.645  58.028  1.00 33.63           O  
ATOM   1247  CB  THR A 157      87.058 112.742  57.167  1.00 33.38           C  
ATOM   1248  OG1 THR A 157      86.530 112.673  58.506  1.00 33.60           O  
ATOM   1249  CG2 THR A 157      88.516 112.313  57.162  1.00 33.05           C  
ATOM   1250  N   PRO A 158      84.417 114.425  56.665  1.00 32.89           N  
ATOM   1251  CA  PRO A 158      84.042 113.341  55.773  1.00 32.79           C  
ATOM   1252  C   PRO A 158      84.657 113.421  54.396  1.00 33.30           C  
ATOM   1253  O   PRO A 158      84.873 114.514  53.861  1.00 33.19           O  
ATOM   1254  CB  PRO A 158      82.531 113.512  55.618  1.00 32.62           C  
ATOM   1255  CG  PRO A 158      82.117 114.352  56.701  1.00 32.51           C  
ATOM   1256  CD  PRO A 158      83.248 115.221  57.061  1.00 32.40           C  
ATOM   1257  N   GLN A 159      84.959 112.251  53.846  1.00 33.94           N  
ATOM   1258  CA  GLN A 159      85.198 112.101  52.413  1.00 34.19           C  
ATOM   1259  C   GLN A 159      84.141 111.124  51.924  1.00 34.35           C  
ATOM   1260  O   GLN A 159      83.732 110.237  52.675  1.00 33.97           O  
ATOM   1261  CB  GLN A 159      86.584 111.549  52.150  1.00 34.25           C  
ATOM   1262  CG  GLN A 159      87.661 112.112  53.036  1.00 33.97           C  
ATOM   1263  CD  GLN A 159      89.040 111.831  52.495  1.00 34.15           C  
ATOM   1264  OE1 GLN A 159      89.384 110.685  52.217  1.00 36.39           O  
ATOM   1265  NE2 GLN A 159      89.833 112.873  52.321  1.00 35.16           N  
ATOM   1266  N   ALA A 160      83.677 111.298  50.692  1.00 34.35           N  
ATOM   1267  CA  ALA A 160      82.622 110.430  50.162  1.00 34.53           C  
ATOM   1268  C   ALA A 160      82.897 110.033  48.720  1.00 34.17           C  
ATOM   1269  O   ALA A 160      83.412 110.834  47.939  1.00 34.17           O  
ATOM   1270  CB  ALA A 160      81.262 111.112  50.261  1.00 34.58           C  
ATOM   1271  N   PHE A 161      82.549 108.793  48.388  1.00 33.38           N  
ATOM   1272  CA  PHE A 161      82.793 108.244  47.068  1.00 32.81           C  
ATOM   1273  C   PHE A 161      81.653 107.320  46.643  1.00 32.46           C  
ATOM   1274  O   PHE A 161      80.968 106.739  47.483  1.00 32.23           O  
ATOM   1275  CB  PHE A 161      84.113 107.450  47.061  1.00 32.37           C  
ATOM   1276  CG  PHE A 161      85.249 108.139  47.781  1.00 32.83           C  
ATOM   1277  CD1 PHE A 161      85.448 107.951  49.146  1.00 32.18           C  
ATOM   1278  CD2 PHE A 161      86.124 108.989  47.093  1.00 32.91           C  
ATOM   1279  CE1 PHE A 161      86.493 108.597  49.803  1.00 31.97           C  
ATOM   1280  CE2 PHE A 161      87.169 109.648  47.759  1.00 31.49           C  
ATOM   1281  CZ  PHE A 161      87.353 109.450  49.096  1.00 31.73           C  
ATOM   1282  N   SER A 162      81.462 107.172  45.340  1.00 32.25           N  
ATOM   1283  CA  SER A 162      80.789 105.990  44.839  1.00 32.37           C  
ATOM   1284  C   SER A 162      81.607 104.757  45.283  1.00 32.19           C  
ATOM   1285  O   SER A 162      82.848 104.746  45.214  1.00 32.12           O  
ATOM   1286  CB  SER A 162      80.618 106.033  43.318  1.00 32.43           C  
ATOM   1287  OG  SER A 162      81.658 105.339  42.669  1.00 33.23           O  
ATOM   1288  N   TYR A 163      80.896 103.747  45.769  1.00 32.05           N  
ATOM   1289  CA  TYR A 163      81.495 102.570  46.382  1.00 32.27           C  
ATOM   1290  C   TYR A 163      82.465 101.865  45.429  1.00 32.17           C  
ATOM   1291  O   TYR A 163      83.562 101.489  45.819  1.00 31.55           O  
ATOM   1292  CB  TYR A 163      80.370 101.636  46.858  1.00 32.50           C  
ATOM   1293  CG  TYR A 163      80.800 100.318  47.460  1.00 32.61           C  
ATOM   1294  CD1 TYR A 163      81.490 100.263  48.671  1.00 33.31           C  
ATOM   1295  CD2 TYR A 163      80.480  99.116  46.834  1.00 33.30           C  
ATOM   1296  CE1 TYR A 163      81.874  99.027  49.230  1.00 33.09           C  
ATOM   1297  CE2 TYR A 163      80.853  97.889  47.377  1.00 33.02           C  
ATOM   1298  CZ  TYR A 163      81.551  97.847  48.564  1.00 33.19           C  
ATOM   1299  OH  TYR A 163      81.924  96.618  49.067  1.00 32.98           O  
ATOM   1300  N   GLU A 164      82.073 101.743  44.173  1.00 32.67           N  
ATOM   1301  CA  GLU A 164      82.871 101.052  43.162  1.00 33.32           C  
ATOM   1302  C   GLU A 164      84.182 101.775  42.885  1.00 33.25           C  
ATOM   1303  O   GLU A 164      85.216 101.138  42.669  1.00 33.47           O  
ATOM   1304  CB  GLU A 164      82.084 100.929  41.857  1.00 33.69           C  
ATOM   1305  CG  GLU A 164      80.768 100.155  41.964  1.00 36.24           C  
ATOM   1306  CD  GLU A 164      80.983  98.654  42.114  1.00 41.08           C  
ATOM   1307  OE1 GLU A 164      82.153  98.233  42.275  1.00 43.69           O  
ATOM   1308  OE2 GLU A 164      79.983  97.890  42.065  1.00 43.72           O  
ATOM   1309  N   ILE A 165      84.145 103.102  42.887  1.00 32.84           N  
ATOM   1310  CA  ILE A 165      85.365 103.874  42.737  1.00 32.93           C  
ATOM   1311  C   ILE A 165      86.323 103.658  43.920  1.00 33.03           C  
ATOM   1312  O   ILE A 165      87.523 103.419  43.734  1.00 33.26           O  
ATOM   1313  CB  ILE A 165      85.062 105.372  42.572  1.00 32.95           C  
ATOM   1314  CG1 ILE A 165      84.445 105.629  41.188  1.00 33.33           C  
ATOM   1315  CG2 ILE A 165      86.338 106.214  42.761  1.00 32.67           C  
ATOM   1316  CD1 ILE A 165      83.959 107.065  40.969  1.00 33.05           C  
ATOM   1317  N   LEU A 166      85.810 103.746  45.139  1.00 32.77           N  
ATOM   1318  CA  LEU A 166      86.685 103.625  46.286  1.00 32.54           C  
ATOM   1319  C   LEU A 166      87.251 102.212  46.358  1.00 32.33           C  
ATOM   1320  O   LEU A 166      88.443 102.023  46.603  1.00 31.91           O  
ATOM   1321  CB  LEU A 166      85.933 103.975  47.560  1.00 32.69           C  
ATOM   1322  CG  LEU A 166      86.741 103.867  48.843  1.00 32.14           C  
ATOM   1323  CD1 LEU A 166      87.926 104.810  48.767  1.00 32.53           C  
ATOM   1324  CD2 LEU A 166      85.875 104.158  50.038  1.00 31.67           C  
ATOM   1325  N   LYS A 167      86.377 101.234  46.141  1.00 32.33           N  
ATOM   1326  CA  LYS A 167      86.764  99.824  46.048  1.00 32.69           C  
ATOM   1327  C   LYS A 167      87.833  99.603  44.958  1.00 32.62           C  
ATOM   1328  O   LYS A 167      88.899  99.053  45.228  1.00 31.76           O  
ATOM   1329  CB  LYS A 167      85.520  98.964  45.786  1.00 32.47           C  
ATOM   1330  CG  LYS A 167      85.750  97.476  45.880  1.00 33.44           C  
ATOM   1331  CD  LYS A 167      84.444  96.630  45.916  1.00 33.77           C  
ATOM   1332  CE  LYS A 167      83.352  97.121  44.950  1.00 35.10           C  
ATOM   1333  NZ  LYS A 167      82.405  96.040  44.455  1.00 35.46           N  
ATOM   1334  N   LYS A 168      87.574 100.097  43.744  1.00 33.03           N  
ATOM   1335  CA  LYS A 168      88.523  99.922  42.647  1.00 33.21           C  
ATOM   1336  C   LYS A 168      89.893 100.445  43.073  1.00 33.70           C  
ATOM   1337  O   LYS A 168      90.917  99.849  42.749  1.00 34.05           O  
ATOM   1338  CB  LYS A 168      88.045 100.606  41.352  1.00 33.41           C  
ATOM   1339  CG  LYS A 168      88.220  99.776  40.061  1.00 32.55           C  
ATOM   1340  N   ALA A 169      89.897 101.539  43.832  1.00 34.13           N  
ATOM   1341  CA  ALA A 169      91.131 102.223  44.234  1.00 34.14           C  
ATOM   1342  C   ALA A 169      91.917 101.458  45.282  1.00 34.28           C  
ATOM   1343  O   ALA A 169      93.107 101.700  45.461  1.00 34.80           O  
ATOM   1344  CB  ALA A 169      90.810 103.635  44.757  1.00 34.03           C  
ATOM   1345  N   HIS A 170      91.251 100.559  45.998  1.00 34.47           N  
ATOM   1346  CA  HIS A 170      91.898  99.781  47.063  1.00 34.12           C  
ATOM   1347  C   HIS A 170      92.179  98.343  46.604  1.00 34.05           C  
ATOM   1348  O   HIS A 170      92.847  97.581  47.298  1.00 34.21           O  
ATOM   1349  CB  HIS A 170      91.029  99.801  48.329  1.00 33.82           C  
ATOM   1350  CG  HIS A 170      91.186 101.043  49.158  1.00 33.24           C  
ATOM   1351  ND1 HIS A 170      92.195 101.201  50.085  1.00 32.93           N  
ATOM   1352  CD2 HIS A 170      90.442 102.171  49.228  1.00 33.16           C  
ATOM   1353  CE1 HIS A 170      92.091 102.382  50.664  1.00 31.84           C  
ATOM   1354  NE2 HIS A 170      91.033 102.989  50.163  1.00 33.66           N  
ATOM   1355  N   GLU A 171      91.681  97.993  45.421  1.00 34.15           N  
ATOM   1356  CA  GLU A 171      91.832  96.648  44.853  1.00 34.16           C  
ATOM   1357  C   GLU A 171      93.196  96.042  44.985  1.00 33.71           C  
ATOM   1358  O   GLU A 171      93.290  94.851  45.086  1.00 33.83           O  
ATOM   1359  CB  GLU A 171      91.631  96.689  43.357  1.00 34.68           C  
ATOM   1360  CG  GLU A 171      90.261  96.482  42.834  1.00 35.18           C  
ATOM   1361  CD  GLU A 171      90.353  96.332  41.356  1.00 34.42           C  
ATOM   1362  OE1 GLU A 171      90.679  97.319  40.679  1.00 35.84           O  
ATOM   1363  OE2 GLU A 171      90.179  95.217  40.878  1.00 34.62           O  
ATOM   1364  N   ASN A 172      94.243  96.853  44.875  1.00 33.51           N  
ATOM   1365  CA  ASN A 172      95.615  96.356  44.911  1.00 33.67           C  
ATOM   1366  C   ASN A 172      96.369  96.722  46.181  1.00 33.46           C  
ATOM   1367  O   ASN A 172      97.594  96.754  46.188  1.00 33.57           O  
ATOM   1368  CB  ASN A 172      96.370  96.885  43.703  1.00 33.82           C  
ATOM   1369  CG  ASN A 172      95.648  96.582  42.405  1.00 35.70           C  
ATOM   1370  OD1 ASN A 172      95.256  97.489  41.672  1.00 37.91           O  
ATOM   1371  ND2 ASN A 172      95.436  95.296  42.130  1.00 37.17           N  
ATOM   1372  N   GLY A 173      95.642  96.986  47.260  1.00 33.09           N  
ATOM   1373  CA  GLY A 173      96.264  97.416  48.494  1.00 33.01           C  
ATOM   1374  C   GLY A 173      96.877  98.798  48.361  1.00 33.28           C  
ATOM   1375  O   GLY A 173      96.489  99.588  47.491  1.00 33.35           O  
ATOM   1376  N   GLY A 174      97.853  99.079  49.216  1.00 33.05           N  
ATOM   1377  CA  GLY A 174      98.498 100.377  49.269  1.00 32.78           C  
ATOM   1378  C   GLY A 174      98.164 100.975  50.617  1.00 32.80           C  
ATOM   1379  O   GLY A 174      97.220 100.540  51.267  1.00 32.37           O  
ATOM   1380  N   GLU A 175      98.962 101.951  51.041  1.00 32.87           N  
ATOM   1381  CA  GLU A 175      98.735 102.684  52.279  1.00 32.98           C  
ATOM   1382  C   GLU A 175      98.781 104.182  52.021  1.00 33.01           C  
ATOM   1383  O   GLU A 175      99.743 104.684  51.443  1.00 33.35           O  
ATOM   1384  CB  GLU A 175      99.801 102.319  53.299  1.00 32.91           C  
ATOM   1385  CG  GLU A 175      99.812 100.838  53.678  1.00 33.35           C  
ATOM   1386  CD  GLU A 175      98.558 100.400  54.411  1.00 32.89           C  
ATOM   1387  OE1 GLU A 175      97.855 101.269  54.945  1.00 33.91           O  
ATOM   1388  OE2 GLU A 175      98.284  99.188  54.472  1.00 32.67           O  
ATOM   1389  N   TRP A 176      97.737 104.894  52.443  1.00 32.87           N  
ATOM   1390  CA  TRP A 176      97.697 106.335  52.314  1.00 32.59           C  
ATOM   1391  C   TRP A 176      97.102 106.995  53.544  1.00 32.69           C  
ATOM   1392  O   TRP A 176      96.380 106.375  54.333  1.00 32.42           O  
ATOM   1393  CB  TRP A 176      96.853 106.750  51.117  1.00 32.78           C  
ATOM   1394  CG  TRP A 176      97.313 106.221  49.802  1.00 32.80           C  
ATOM   1395  CD1 TRP A 176      98.182 106.809  48.945  1.00 32.05           C  
ATOM   1396  CD2 TRP A 176      96.905 105.000  49.190  1.00 33.04           C  
ATOM   1397  NE1 TRP A 176      98.349 106.034  47.840  1.00 32.36           N  
ATOM   1398  CE2 TRP A 176      97.576 104.912  47.957  1.00 32.39           C  
ATOM   1399  CE3 TRP A 176      96.049 103.958  49.576  1.00 33.53           C  
ATOM   1400  CZ2 TRP A 176      97.414 103.836  47.086  1.00 32.09           C  
ATOM   1401  CZ3 TRP A 176      95.884 102.873  48.700  1.00 33.33           C  
ATOM   1402  CH2 TRP A 176      96.573 102.831  47.469  1.00 32.76           C  
ATOM   1403  N   ALA A 177      97.395 108.284  53.681  1.00 32.66           N  
ATOM   1404  CA  ALA A 177      96.863 109.062  54.783  1.00 32.29           C  
ATOM   1405  C   ALA A 177      95.336 109.186  54.658  1.00 32.14           C  
ATOM   1406  O   ALA A 177      94.624 109.087  55.664  1.00 31.77           O  
ATOM   1407  CB  ALA A 177      97.532 110.426  54.856  1.00 31.64           C  
ATOM   1408  N   ASP A 178      94.839 109.385  53.433  1.00 31.95           N  
ATOM   1409  CA  ASP A 178      93.398 109.545  53.219  1.00 31.89           C  
ATOM   1410  C   ASP A 178      92.904 108.661  52.088  1.00 31.64           C  
ATOM   1411  O   ASP A 178      93.597 107.724  51.672  1.00 30.71           O  
ATOM   1412  CB  ASP A 178      93.036 111.021  53.014  1.00 31.64           C  
ATOM   1413  CG  ASP A 178      93.128 111.457  51.582  1.00 32.28           C  
ATOM   1414  OD1 ASP A 178      93.933 110.891  50.813  1.00 34.70           O  
ATOM   1415  OD2 ASP A 178      92.368 112.370  51.211  1.00 31.60           O  
ATOM   1416  N   ASP A 179      91.691 108.936  51.614  1.00 31.91           N  
ATOM   1417  CA  ASP A 179      91.124 108.129  50.534  1.00 32.25           C  
ATOM   1418  C   ASP A 179      91.044 108.857  49.200  1.00 32.27           C  
ATOM   1419  O   ASP A 179      90.927 108.216  48.153  1.00 32.62           O  
ATOM   1420  CB  ASP A 179      89.777 107.513  50.951  1.00 31.72           C  
ATOM   1421  CG  ASP A 179      89.952 106.402  51.978  1.00 31.95           C  
ATOM   1422  OD1 ASP A 179      90.660 105.419  51.689  1.00 29.11           O  
ATOM   1423  OD2 ASP A 179      89.399 106.516  53.099  1.00 34.61           O  
ATOM   1424  N   THR A 180      91.143 110.180  49.212  1.00 32.26           N  
ATOM   1425  CA  THR A 180      91.116 110.906  47.952  1.00 32.31           C  
ATOM   1426  C   THR A 180      92.381 110.566  47.180  1.00 32.34           C  
ATOM   1427  O   THR A 180      92.341 110.439  45.963  1.00 32.68           O  
ATOM   1428  CB  THR A 180      90.961 112.443  48.131  1.00 32.24           C  
ATOM   1429  OG1 THR A 180      92.086 112.958  48.850  1.00 33.01           O  
ATOM   1430  CG2 THR A 180      89.679 112.790  48.880  1.00 31.35           C  
ATOM   1431  N   GLU A 181      93.498 110.399  47.887  1.00 32.50           N  
ATOM   1432  CA  GLU A 181      94.781 110.165  47.221  1.00 32.60           C  
ATOM   1433  C   GLU A 181      94.779 108.906  46.358  1.00 32.78           C  
ATOM   1434  O   GLU A 181      95.177 108.965  45.193  1.00 32.94           O  
ATOM   1435  CB  GLU A 181      95.963 110.153  48.208  1.00 32.71           C  
ATOM   1436  CG  GLU A 181      97.331 110.025  47.502  1.00 32.27           C  
ATOM   1437  CD  GLU A 181      98.563 110.247  48.395  1.00 32.56           C  
ATOM   1438  OE1 GLU A 181      98.498 110.241  49.659  1.00 31.60           O  
ATOM   1439  OE2 GLU A 181      99.639 110.430  47.801  1.00 33.62           O  
ATOM   1440  N   PRO A 182      94.366 107.764  46.918  1.00 33.03           N  
ATOM   1441  CA  PRO A 182      94.299 106.583  46.066  1.00 33.50           C  
ATOM   1442  C   PRO A 182      93.258 106.688  44.954  1.00 33.69           C  
ATOM   1443  O   PRO A 182      93.467 106.176  43.852  1.00 33.80           O  
ATOM   1444  CB  PRO A 182      93.956 105.446  47.051  1.00 33.44           C  
ATOM   1445  CG  PRO A 182      93.390 106.102  48.238  1.00 33.13           C  
ATOM   1446  CD  PRO A 182      94.032 107.446  48.316  1.00 33.51           C  
ATOM   1447  N   VAL A 183      92.156 107.361  45.250  1.00 34.15           N  
ATOM   1448  CA  VAL A 183      91.066 107.526  44.286  1.00 34.52           C  
ATOM   1449  C   VAL A 183      91.535 108.391  43.121  1.00 34.49           C  
ATOM   1450  O   VAL A 183      91.191 108.143  41.978  1.00 34.32           O  
ATOM   1451  CB  VAL A 183      89.788 108.116  44.987  1.00 34.66           C  
ATOM   1452  CG1 VAL A 183      88.718 108.515  43.982  1.00 34.57           C  
ATOM   1453  CG2 VAL A 183      89.206 107.092  45.988  1.00 35.04           C  
ATOM   1454  N   GLN A 184      92.342 109.398  43.414  1.00 34.72           N  
ATOM   1455  CA  GLN A 184      92.831 110.268  42.376  1.00 35.18           C  
ATOM   1456  C   GLN A 184      93.773 109.526  41.414  1.00 34.96           C  
ATOM   1457  O   GLN A 184      93.812 109.829  40.227  1.00 34.73           O  
ATOM   1458  CB  GLN A 184      93.533 111.475  42.976  1.00 35.30           C  
ATOM   1459  CG  GLN A 184      93.887 112.471  41.900  1.00 37.51           C  
ATOM   1460  CD  GLN A 184      94.861 113.518  42.362  1.00 40.38           C  
ATOM   1461  OE1 GLN A 184      94.550 114.720  42.347  1.00 41.37           O  
ATOM   1462  NE2 GLN A 184      96.050 113.078  42.777  1.00 40.36           N  
ATOM   1463  N   LYS A 185      94.521 108.554  41.922  1.00 34.79           N  
ATOM   1464  CA  LYS A 185      95.394 107.747  41.076  1.00 34.87           C  
ATOM   1465  C   LYS A 185      94.655 107.044  39.934  1.00 34.58           C  
ATOM   1466  O   LYS A 185      95.280 106.623  38.966  1.00 34.74           O  
ATOM   1467  CB  LYS A 185      96.137 106.704  41.907  1.00 34.95           C  
ATOM   1468  CG  LYS A 185      97.232 107.295  42.747  1.00 36.23           C  
ATOM   1469  CD  LYS A 185      98.140 106.230  43.334  1.00 37.79           C  
ATOM   1470  CE  LYS A 185      99.112 105.635  42.295  1.00 39.02           C  
ATOM   1471  NZ  LYS A 185      99.880 104.456  42.830  1.00 38.85           N  
ATOM   1472  N   LEU A 186      93.336 106.916  40.060  1.00 34.34           N  
ATOM   1473  CA  LEU A 186      92.482 106.372  39.005  1.00 34.13           C  
ATOM   1474  C   LEU A 186      92.071 107.423  38.008  1.00 34.31           C  
ATOM   1475  O   LEU A 186      91.267 107.145  37.143  1.00 35.21           O  
ATOM   1476  CB  LEU A 186      91.197 105.793  39.597  1.00 33.80           C  
ATOM   1477  CG  LEU A 186      91.334 104.779  40.724  1.00 33.70           C  
ATOM   1478  CD1 LEU A 186      89.954 104.253  41.128  1.00 33.75           C  
ATOM   1479  CD2 LEU A 186      92.227 103.658  40.269  1.00 34.03           C  
ATOM   1480  N   GLY A 187      92.587 108.638  38.121  1.00 34.48           N  
ATOM   1481  CA  GLY A 187      92.188 109.705  37.217  1.00 34.34           C  
ATOM   1482  C   GLY A 187      90.831 110.285  37.540  1.00 34.48           C  
ATOM   1483  O   GLY A 187      90.205 110.896  36.680  1.00 34.72           O  
ATOM   1484  N   VAL A 188      90.382 110.109  38.783  1.00 34.62           N  
ATOM   1485  CA  VAL A 188      89.118 110.679  39.257  1.00 34.40           C  
ATOM   1486  C   VAL A 188      89.381 112.066  39.885  1.00 34.56           C  
ATOM   1487  O   VAL A 188      90.273 112.230  40.730  1.00 34.79           O  
ATOM   1488  CB  VAL A 188      88.468 109.708  40.269  1.00 34.33           C  
ATOM   1489  CG1 VAL A 188      87.289 110.333  40.989  1.00 34.98           C  
ATOM   1490  CG2 VAL A 188      88.028 108.437  39.571  1.00 34.37           C  
ATOM   1491  N   LYS A 189      88.617 113.067  39.466  1.00 34.71           N  
ATOM   1492  CA  LYS A 189      88.723 114.413  40.054  1.00 34.79           C  
ATOM   1493  C   LYS A 189      88.129 114.397  41.451  1.00 34.85           C  
ATOM   1494  O   LYS A 189      87.055 113.825  41.672  1.00 35.20           O  
ATOM   1495  CB  LYS A 189      88.003 115.474  39.209  1.00 34.57           C  
ATOM   1496  CG  LYS A 189      88.902 116.241  38.258  1.00 35.32           C  
ATOM   1497  N   ILE A 190      88.834 115.038  42.377  1.00 34.73           N  
ATOM   1498  CA  ILE A 190      88.426 115.146  43.777  1.00 34.63           C  
ATOM   1499  C   ILE A 190      87.741 116.482  44.031  1.00 34.27           C  
ATOM   1500  O   ILE A 190      88.358 117.521  43.906  1.00 33.87           O  
ATOM   1501  CB  ILE A 190      89.658 115.065  44.708  1.00 34.54           C  
ATOM   1502  CG1 ILE A 190      90.494 113.818  44.373  1.00 35.22           C  
ATOM   1503  CG2 ILE A 190      89.228 115.096  46.167  1.00 34.28           C  
ATOM   1504  CD1 ILE A 190      89.699 112.529  44.298  1.00 35.59           C  
ATOM   1505  N   ALA A 191      86.468 116.454  44.390  1.00 34.40           N  
ATOM   1506  CA  ALA A 191      85.757 117.686  44.717  1.00 34.33           C  
ATOM   1507  C   ALA A 191      86.182 118.134  46.091  1.00 34.37           C  
ATOM   1508  O   ALA A 191      86.350 117.316  46.998  1.00 34.53           O  
ATOM   1509  CB  ALA A 191      84.266 117.471  44.693  1.00 34.48           C  
ATOM   1510  N   LEU A 192      86.377 119.437  46.229  1.00 34.20           N  
ATOM   1511  CA  LEU A 192      86.665 120.044  47.510  1.00 33.95           C  
ATOM   1512  C   LEU A 192      85.393 120.695  47.980  1.00 33.70           C  
ATOM   1513  O   LEU A 192      84.678 121.287  47.201  1.00 33.34           O  
ATOM   1514  CB  LEU A 192      87.767 121.078  47.364  1.00 33.97           C  
ATOM   1515  CG  LEU A 192      89.096 120.475  46.937  1.00 34.07           C  
ATOM   1516  CD1 LEU A 192      90.104 121.575  46.816  1.00 34.11           C  
ATOM   1517  CD2 LEU A 192      89.552 119.427  47.940  1.00 34.25           C  
ATOM   1518  N   VAL A 193      85.098 120.554  49.256  1.00 33.94           N  
ATOM   1519  CA  VAL A 193      83.864 121.082  49.811  1.00 34.21           C  
ATOM   1520  C   VAL A 193      84.275 121.868  51.028  1.00 34.17           C  
ATOM   1521  O   VAL A 193      84.935 121.333  51.898  1.00 33.76           O  
ATOM   1522  CB  VAL A 193      82.897 119.932  50.188  1.00 34.48           C  
ATOM   1523  CG1 VAL A 193      81.617 120.454  50.817  1.00 34.06           C  
ATOM   1524  CG2 VAL A 193      82.578 119.081  48.955  1.00 34.60           C  
ATOM   1525  N   GLU A 194      83.904 123.141  51.073  1.00 34.75           N  
ATOM   1526  CA  GLU A 194      84.358 124.042  52.134  1.00 35.08           C  
ATOM   1527  C   GLU A 194      83.915 123.517  53.493  1.00 35.16           C  
ATOM   1528  O   GLU A 194      82.723 123.260  53.708  1.00 35.21           O  
ATOM   1529  CB  GLU A 194      83.822 125.458  51.916  1.00 35.20           C  
ATOM   1530  N   GLY A 195      84.881 123.308  54.383  1.00 34.88           N  
ATOM   1531  CA  GLY A 195      84.585 122.908  55.752  1.00 34.95           C  
ATOM   1532  C   GLY A 195      84.801 124.089  56.690  1.00 34.87           C  
ATOM   1533  O   GLY A 195      84.788 125.235  56.269  1.00 34.65           O  
ATOM   1534  N   ASP A 196      85.002 123.801  57.965  1.00 34.96           N  
ATOM   1535  CA  ASP A 196      85.400 124.822  58.915  1.00 35.22           C  
ATOM   1536  C   ASP A 196      86.279 124.206  60.005  1.00 34.87           C  
ATOM   1537  O   ASP A 196      86.407 122.986  60.076  1.00 34.65           O  
ATOM   1538  CB  ASP A 196      84.163 125.522  59.492  1.00 35.49           C  
ATOM   1539  CG  ASP A 196      83.345 124.623  60.341  1.00 35.93           C  
ATOM   1540  OD1 ASP A 196      83.873 124.166  61.366  1.00 36.53           O  
ATOM   1541  OD2 ASP A 196      82.173 124.385  59.988  1.00 37.61           O  
ATOM   1542  N   PRO A 197      86.877 125.050  60.863  1.00 34.62           N  
ATOM   1543  CA  PRO A 197      87.846 124.583  61.857  1.00 34.47           C  
ATOM   1544  C   PRO A 197      87.314 123.643  62.972  1.00 34.29           C  
ATOM   1545  O   PRO A 197      88.127 123.030  63.688  1.00 33.74           O  
ATOM   1546  CB  PRO A 197      88.378 125.887  62.469  1.00 34.50           C  
ATOM   1547  CG  PRO A 197      87.962 126.960  61.558  1.00 34.93           C  
ATOM   1548  CD  PRO A 197      86.698 126.511  60.939  1.00 34.78           C  
ATOM   1549  N   LEU A 198      85.990 123.533  63.112  1.00 33.93           N  
ATOM   1550  CA  LEU A 198      85.386 122.516  63.986  1.00 34.07           C  
ATOM   1551  C   LEU A 198      85.628 121.082  63.505  1.00 34.19           C  
ATOM   1552  O   LEU A 198      85.409 120.127  64.265  1.00 33.65           O  
ATOM   1553  CB  LEU A 198      83.886 122.729  64.114  1.00 34.12           C  
ATOM   1554  CG  LEU A 198      83.518 123.990  64.875  1.00 34.08           C  
ATOM   1555  CD1 LEU A 198      82.157 124.513  64.454  1.00 34.81           C  
ATOM   1556  CD2 LEU A 198      83.555 123.678  66.333  1.00 34.57           C  
ATOM   1557  N   CYS A 199      86.082 120.948  62.256  1.00 34.01           N  
ATOM   1558  CA  CYS A 199      86.393 119.650  61.659  1.00 34.28           C  
ATOM   1559  C   CYS A 199      87.784 119.117  61.988  1.00 33.16           C  
ATOM   1560  O   CYS A 199      88.182 118.059  61.478  1.00 32.01           O  
ATOM   1561  CB  CYS A 199      86.270 119.756  60.147  1.00 34.65           C  
ATOM   1562  SG  CYS A 199      84.717 120.458  59.582  1.00 38.01           S  
ATOM   1563  N   PHE A 200      88.517 119.857  62.817  1.00 32.64           N  
ATOM   1564  CA  PHE A 200      89.860 119.457  63.260  1.00 32.53           C  
ATOM   1565  C   PHE A 200      89.865 118.083  63.938  1.00 32.66           C  
ATOM   1566  O   PHE A 200      88.852 117.634  64.515  1.00 32.56           O  
ATOM   1567  CB  PHE A 200      90.456 120.487  64.223  1.00 32.34           C  
ATOM   1568  CG  PHE A 200      90.009 120.311  65.631  1.00 32.02           C  
ATOM   1569  CD1 PHE A 200      88.677 120.504  65.980  1.00 32.26           C  
ATOM   1570  CD2 PHE A 200      90.897 119.910  66.600  1.00 32.12           C  
ATOM   1571  CE1 PHE A 200      88.251 120.323  67.289  1.00 32.48           C  
ATOM   1572  CE2 PHE A 200      90.471 119.720  67.920  1.00 33.07           C  
ATOM   1573  CZ  PHE A 200      89.150 119.928  68.261  1.00 32.61           C  
ATOM   1574  N   LYS A 201      91.022 117.439  63.869  1.00 32.53           N  
ATOM   1575  CA  LYS A 201      91.183 116.080  64.321  1.00 32.77           C  
ATOM   1576  C   LYS A 201      91.878 116.142  65.655  1.00 32.40           C  
ATOM   1577  O   LYS A 201      92.949 116.705  65.769  1.00 33.01           O  
ATOM   1578  CB  LYS A 201      92.025 115.295  63.316  1.00 32.54           C  
ATOM   1579  CG  LYS A 201      92.056 113.791  63.532  1.00 32.90           C  
ATOM   1580  CD  LYS A 201      92.795 113.113  62.372  1.00 33.76           C  
ATOM   1581  CE  LYS A 201      94.305 113.309  62.507  1.00 35.53           C  
ATOM   1582  NZ  LYS A 201      95.021 113.439  61.242  1.00 35.28           N  
ATOM   1583  N   VAL A 202      91.269 115.574  66.674  1.00 32.02           N  
ATOM   1584  CA  VAL A 202      91.945 115.471  67.929  1.00 31.96           C  
ATOM   1585  C   VAL A 202      93.092 114.523  67.658  1.00 32.62           C  
ATOM   1586  O   VAL A 202      92.863 113.342  67.338  1.00 33.18           O  
ATOM   1587  CB  VAL A 202      91.037 114.937  69.027  1.00 31.49           C  
ATOM   1588  CG1 VAL A 202      91.834 114.700  70.292  1.00 31.25           C  
ATOM   1589  CG2 VAL A 202      89.900 115.911  69.265  1.00 31.09           C  
ATOM   1590  N   THR A 203      94.313 115.065  67.738  1.00 33.04           N  
ATOM   1591  CA  THR A 203      95.544 114.335  67.426  1.00 33.11           C  
ATOM   1592  C   THR A 203      96.571 114.377  68.572  1.00 33.38           C  
ATOM   1593  O   THR A 203      97.218 113.369  68.853  1.00 33.22           O  
ATOM   1594  CB  THR A 203      96.190 114.930  66.183  1.00 33.18           C  
ATOM   1595  OG1 THR A 203      95.210 115.040  65.146  1.00 33.03           O  
ATOM   1596  CG2 THR A 203      97.358 114.076  65.713  1.00 33.43           C  
ATOM   1597  N   PHE A 204      96.724 115.537  69.219  1.00 33.53           N  
ATOM   1598  CA  PHE A 204      97.690 115.706  70.320  1.00 33.85           C  
ATOM   1599  C   PHE A 204      97.001 116.009  71.657  1.00 34.26           C  
ATOM   1600  O   PHE A 204      95.830 116.371  71.680  1.00 34.58           O  
ATOM   1601  CB  PHE A 204      98.709 116.798  69.962  1.00 33.63           C  
ATOM   1602  CG  PHE A 204      99.426 116.528  68.677  1.00 33.23           C  
ATOM   1603  CD1 PHE A 204     100.404 115.558  68.616  1.00 32.89           C  
ATOM   1604  CD2 PHE A 204      99.064 117.185  67.513  1.00 33.03           C  
ATOM   1605  CE1 PHE A 204     101.028 115.262  67.408  1.00 33.47           C  
ATOM   1606  CE2 PHE A 204      99.689 116.899  66.303  1.00 32.88           C  
ATOM   1607  CZ  PHE A 204     100.676 115.945  66.252  1.00 33.29           C  
ATOM   1608  N   LYS A 205      97.727 115.842  72.762  1.00 34.62           N  
ATOM   1609  CA  LYS A 205      97.168 116.090  74.097  1.00 35.13           C  
ATOM   1610  C   LYS A 205      96.530 117.492  74.203  1.00 35.26           C  
ATOM   1611  O   LYS A 205      95.462 117.658  74.776  1.00 35.28           O  
ATOM   1612  CB  LYS A 205      98.228 115.889  75.187  1.00 34.78           C  
ATOM   1613  CG  LYS A 205      97.622 115.450  76.529  1.00 35.53           C  
ATOM   1614  CD  LYS A 205      98.659 114.892  77.542  1.00 35.80           C  
ATOM   1615  CE  LYS A 205      99.145 113.480  77.186  1.00 36.05           C  
ATOM   1616  NZ  LYS A 205      99.929 112.858  78.285  1.00 36.18           N  
ATOM   1617  N   GLU A 206      97.171 118.475  73.584  1.00 35.59           N  
ATOM   1618  CA  GLU A 206      96.694 119.861  73.581  1.00 35.79           C  
ATOM   1619  C   GLU A 206      95.337 120.006  72.895  1.00 35.62           C  
ATOM   1620  O   GLU A 206      94.583 120.920  73.212  1.00 35.99           O  
ATOM   1621  CB  GLU A 206      97.700 120.789  72.874  1.00 35.87           C  
ATOM   1622  CG  GLU A 206      99.151 120.707  73.387  1.00 37.01           C  
ATOM   1623  CD  GLU A 206      99.949 119.530  72.806  1.00 38.73           C  
ATOM   1624  OE1 GLU A 206      99.680 119.118  71.657  1.00 39.71           O  
ATOM   1625  OE2 GLU A 206     100.842 119.007  73.508  1.00 39.68           O  
ATOM   1626  N   ASP A 207      95.033 119.119  71.951  1.00 35.36           N  
ATOM   1627  CA  ASP A 207      93.751 119.164  71.237  1.00 35.32           C  
ATOM   1628  C   ASP A 207      92.514 118.910  72.143  1.00 35.24           C  
ATOM   1629  O   ASP A 207      91.381 119.217  71.749  1.00 35.23           O  
ATOM   1630  CB  ASP A 207      93.760 118.183  70.054  1.00 35.14           C  
ATOM   1631  CG  ASP A 207      94.831 118.524  69.006  1.00 35.56           C  
ATOM   1632  OD1 ASP A 207      95.457 119.603  69.108  1.00 32.96           O  
ATOM   1633  OD2 ASP A 207      95.047 117.696  68.082  1.00 35.88           O  
ATOM   1634  N   LEU A 208      92.725 118.378  73.349  1.00 34.97           N  
ATOM   1635  CA  LEU A 208      91.613 118.021  74.236  1.00 34.78           C  
ATOM   1636  C   LEU A 208      90.924 119.204  74.879  1.00 34.39           C  
ATOM   1637  O   LEU A 208      89.711 119.195  75.066  1.00 33.94           O  
ATOM   1638  CB  LEU A 208      92.097 117.080  75.336  1.00 34.97           C  
ATOM   1639  CG  LEU A 208      92.427 115.697  74.791  1.00 35.65           C  
ATOM   1640  CD1 LEU A 208      92.956 114.777  75.898  1.00 35.11           C  
ATOM   1641  CD2 LEU A 208      91.181 115.107  74.114  1.00 35.94           C  
ATOM   1642  N   GLU A 209      91.705 120.211  75.238  1.00 34.33           N  
ATOM   1643  CA  GLU A 209      91.160 121.447  75.798  1.00 34.55           C  
ATOM   1644  C   GLU A 209      90.096 122.013  74.861  1.00 33.81           C  
ATOM   1645  O   GLU A 209      88.986 122.329  75.287  1.00 33.79           O  
ATOM   1646  CB  GLU A 209      92.283 122.472  76.029  1.00 34.61           C  
ATOM   1647  CG  GLU A 209      91.970 123.594  77.044  1.00 35.55           C  
ATOM   1648  CD  GLU A 209      92.849 124.838  76.815  1.00 36.42           C  
ATOM   1649  OE1 GLU A 209      93.612 124.838  75.814  1.00 39.71           O  
ATOM   1650  OE2 GLU A 209      92.781 125.814  77.607  1.00 36.88           O  
ATOM   1651  N   LEU A 210      90.425 122.115  73.579  1.00 33.33           N  
ATOM   1652  CA  LEU A 210      89.480 122.640  72.601  1.00 33.04           C  
ATOM   1653  C   LEU A 210      88.262 121.732  72.458  1.00 32.73           C  
ATOM   1654  O   LEU A 210      87.135 122.211  72.393  1.00 32.96           O  
ATOM   1655  CB  LEU A 210      90.151 122.853  71.237  1.00 32.93           C  
ATOM   1656  CG  LEU A 210      89.194 123.278  70.125  1.00 33.07           C  
ATOM   1657  CD1 LEU A 210      88.454 124.524  70.549  1.00 33.74           C  
ATOM   1658  CD2 LEU A 210      89.895 123.482  68.776  1.00 32.86           C  
ATOM   1659  N   ALA A 211      88.474 120.425  72.414  1.00 32.43           N  
ATOM   1660  CA  ALA A 211      87.348 119.511  72.237  1.00 32.58           C  
ATOM   1661  C   ALA A 211      86.361 119.554  73.409  1.00 32.26           C  
ATOM   1662  O   ALA A 211      85.172 119.365  73.234  1.00 31.89           O  
ATOM   1663  CB  ALA A 211      87.838 118.105  71.994  1.00 32.85           C  
ATOM   1664  N   ARG A 212      86.860 119.807  74.606  1.00 32.45           N  
ATOM   1665  CA  ARG A 212      85.998 119.926  75.764  1.00 32.45           C  
ATOM   1666  C   ARG A 212      85.139 121.180  75.654  1.00 32.19           C  
ATOM   1667  O   ARG A 212      83.951 121.187  76.009  1.00 32.20           O  
ATOM   1668  CB  ARG A 212      86.844 119.950  77.021  1.00 32.49           C  
ATOM   1669  CG  ARG A 212      87.397 118.585  77.361  1.00 34.18           C  
ATOM   1670  CD  ARG A 212      88.071 118.565  78.736  1.00 36.83           C  
ATOM   1671  NE  ARG A 212      89.499 118.852  78.623  1.00 37.93           N  
ATOM   1672  CZ  ARG A 212      90.482 117.954  78.708  1.00 38.76           C  
ATOM   1673  NH1 ARG A 212      90.242 116.653  78.958  1.00 38.05           N  
ATOM   1674  NH2 ARG A 212      91.733 118.383  78.560  1.00 38.92           N  
ATOM   1675  N   ILE A 213      85.748 122.232  75.123  1.00 31.74           N  
ATOM   1676  CA  ILE A 213      85.080 123.504  74.953  1.00 31.33           C  
ATOM   1677  C   ILE A 213      83.918 123.401  73.955  1.00 31.32           C  
ATOM   1678  O   ILE A 213      82.806 123.834  74.256  1.00 31.16           O  
ATOM   1679  CB  ILE A 213      86.118 124.592  74.598  1.00 31.07           C  
ATOM   1680  CG1 ILE A 213      86.902 124.945  75.871  1.00 29.92           C  
ATOM   1681  CG2 ILE A 213      85.457 125.823  73.994  1.00 31.12           C  
ATOM   1682  CD1 ILE A 213      88.223 125.608  75.629  1.00 28.98           C  
ATOM   1683  N   ILE A 214      84.148 122.803  72.796  1.00 31.46           N  
ATOM   1684  CA  ILE A 214      83.045 122.581  71.853  1.00 32.09           C  
ATOM   1685  C   ILE A 214      81.999 121.574  72.394  1.00 32.56           C  
ATOM   1686  O   ILE A 214      80.790 121.758  72.205  1.00 32.66           O  
ATOM   1687  CB  ILE A 214      83.560 122.128  70.473  1.00 32.05           C  
ATOM   1688  CG1 ILE A 214      84.445 123.222  69.861  1.00 31.68           C  
ATOM   1689  CG2 ILE A 214      82.395 121.814  69.529  1.00 31.95           C  
ATOM   1690  CD1 ILE A 214      85.646 122.668  69.090  1.00 31.27           C  
ATOM   1691  N   ALA A 215      82.475 120.532  73.074  1.00 33.11           N  
ATOM   1692  CA  ALA A 215      81.614 119.481  73.602  1.00 33.48           C  
ATOM   1693  C   ALA A 215      80.603 120.025  74.593  1.00 34.09           C  
ATOM   1694  O   ALA A 215      79.453 119.619  74.560  1.00 33.89           O  
ATOM   1695  CB  ALA A 215      82.441 118.387  74.251  1.00 33.53           C  
ATOM   1696  N   ARG A 216      81.022 120.948  75.455  1.00 34.87           N  
ATOM   1697  CA  ARG A 216      80.086 121.628  76.366  1.00 36.00           C  
ATOM   1698  C   ARG A 216      78.852 122.243  75.688  1.00 36.27           C  
ATOM   1699  O   ARG A 216      77.770 122.264  76.267  1.00 36.19           O  
ATOM   1700  CB  ARG A 216      80.803 122.694  77.213  1.00 35.76           C  
ATOM   1701  CG  ARG A 216      81.125 122.187  78.608  1.00 36.99           C  
ATOM   1702  CD  ARG A 216      81.519 123.270  79.617  1.00 38.15           C  
ATOM   1703  NE  ARG A 216      82.812 123.868  79.285  1.00 40.74           N  
ATOM   1704  CZ  ARG A 216      83.992 123.247  79.372  1.00 41.06           C  
ATOM   1705  NH1 ARG A 216      84.093 121.993  79.819  1.00 41.89           N  
ATOM   1706  NH2 ARG A 216      85.096 123.898  79.019  1.00 41.13           N  
ATOM   1707  N   GLU A 217      79.023 122.707  74.459  1.00 37.32           N  
ATOM   1708  CA  GLU A 217      77.989 123.435  73.722  1.00 38.02           C  
ATOM   1709  C   GLU A 217      77.163 122.514  72.832  1.00 38.42           C  
ATOM   1710  O   GLU A 217      76.073 122.870  72.392  1.00 38.55           O  
ATOM   1711  CB  GLU A 217      78.659 124.458  72.804  1.00 38.33           C  
ATOM   1712  CG  GLU A 217      79.732 125.329  73.465  1.00 39.01           C  
ATOM   1713  CD  GLU A 217      79.143 126.497  74.213  1.00 39.72           C  
ATOM   1714  OE1 GLU A 217      78.159 126.283  74.969  1.00 39.81           O  
ATOM   1715  OE2 GLU A 217      79.666 127.624  74.025  1.00 39.67           O  
ATOM   1716  N   TRP A 218      77.692 121.334  72.559  1.00 38.93           N  
ATOM   1717  CA  TRP A 218      77.223 120.542  71.438  1.00 39.42           C  
ATOM   1718  C   TRP A 218      75.780 120.062  71.549  1.00 39.87           C  
ATOM   1719  O   TRP A 218      74.964 120.392  70.689  1.00 40.04           O  
ATOM   1720  CB  TRP A 218      78.155 119.356  71.215  1.00 39.53           C  
ATOM   1721  CG  TRP A 218      78.272 118.978  69.783  1.00 39.41           C  
ATOM   1722  CD1 TRP A 218      78.869 119.702  68.787  1.00 39.42           C  
ATOM   1723  CD2 TRP A 218      77.804 117.773  69.186  1.00 39.02           C  
ATOM   1724  NE1 TRP A 218      78.795 119.014  67.591  1.00 39.82           N  
ATOM   1725  CE2 TRP A 218      78.145 117.828  67.809  1.00 39.72           C  
ATOM   1726  CE3 TRP A 218      77.115 116.655  69.676  1.00 39.38           C  
ATOM   1727  CZ2 TRP A 218      77.830 116.798  66.916  1.00 40.08           C  
ATOM   1728  CZ3 TRP A 218      76.803 115.620  68.793  1.00 39.72           C  
ATOM   1729  CH2 TRP A 218      77.162 115.699  67.426  1.00 40.08           C  
ATOM   1730  N   GLU A 219      75.470 119.283  72.583  1.00 40.49           N  
ATOM   1731  CA  GLU A 219      74.162 118.622  72.674  1.00 41.10           C  
ATOM   1732  C   GLU A 219      73.123 119.590  73.223  1.00 41.30           C  
ATOM   1733  O   GLU A 219      72.975 120.705  72.717  1.00 41.69           O  
ATOM   1734  CB  GLU A 219      74.233 117.362  73.552  1.00 41.32           C  
ATOM   1735  CG  GLU A 219      73.166 116.311  73.236  1.00 41.62           C  
ATOM   1736  CD  GLU A 219      73.706 115.116  72.450  1.00 43.37           C  
ATOM   1737  OE1 GLU A 219      74.590 115.304  71.571  1.00 44.81           O  
ATOM   1738  OE2 GLU A 219      73.240 113.976  72.713  1.00 43.72           O  
TER    1739      GLU A 219                                                      
END
MOLECULE T0420.pdb
ATOM      1  N   MET     1      71.619 109.167  47.132  1.00 90.29           N  
ATOM      2  CA  MET     1      71.053 107.807  46.878  1.00 90.45           C  
ATOM      3  C   MET     1      71.689 106.761  47.790  1.00 88.28           C  
ATOM      4  O   MET     1      71.664 106.906  49.016  1.00 88.91           O  
ATOM      5  CB  MET     1      71.260 107.411  45.415  1.00 91.73           C  
ATOM      6  CG  MET     1      71.941 108.488  44.584  1.00 97.36           C  
ATOM      7  SD  MET     1      73.841 108.693  44.978  1.00 99.73          SE  
ATOM      8  CE  MET     1      74.536 108.305  43.197  1.00 99.73           C  
ATOM      9  N   ASN     2      72.267 105.716  47.201  1.00 85.03           N  
ATOM     10  CA  ASN     2      72.888 104.659  47.995  1.00 81.84           C  
ATOM     11  C   ASN     2      74.252 104.994  48.583  1.00 79.10           C  
ATOM     12  O   ASN     2      75.284 104.814  47.940  1.00 78.70           O  
ATOM     13  CB  ASN     2      72.987 103.382  47.174  1.00 82.29           C  
ATOM     14  CG  ASN     2      71.873 102.422  47.485  1.00 83.43           C  
ATOM     15  OD1 ASN     2      70.725 102.827  47.659  1.00 85.52           O  
ATOM     16  ND2 ASN     2      72.199 101.137  47.553  1.00 86.02           N  
ATOM     17  N   ILE     3      74.248 105.472  49.821  1.00 75.30           N  
ATOM     18  CA  ILE     3      75.487 105.816  50.485  1.00 72.19           C  
ATOM     19  C   ILE     3      75.638 105.118  51.830  1.00 69.90           C  
ATOM     20  O   ILE     3      74.729 105.111  52.659  1.00 69.85           O  
ATOM     21  CB  ILE     3      75.600 107.327  50.711  1.00 72.15           C  
ATOM     22  CG1 ILE     3      75.446 108.067  49.383  1.00 72.99           C  
ATOM     23  CG2 ILE     3      76.953 107.658  51.291  1.00 70.73           C  
ATOM     24  CD1 ILE     3      75.531 109.580  49.521  1.00 74.41           C  
ATOM     25  N   GLY     4      76.799 104.515  52.034  1.00 66.94           N  
ATOM     26  CA  GLY     4      77.060 103.854  53.291  1.00 62.89           C  
ATOM     27  C   GLY     4      78.166 104.579  54.036  1.00 59.88           C  
ATOM     28  O   GLY     4      79.154 105.010  53.446  1.00 59.44           O  
ATOM     29  N   VAL     5      77.993 104.742  55.338  1.00 57.63           N  
ATOM     30  CA  VAL     5      79.015 105.385  56.139  1.00 55.30           C  
ATOM     31  C   VAL     5      79.820 104.305  56.867  1.00 54.83           C  
ATOM     32  O   VAL     5      79.258 103.415  57.519  1.00 55.29           O  
ATOM     33  CB  VAL     5      78.407 106.331  57.182  1.00 55.28           C  
ATOM     34  CG1 VAL     5      79.501 107.107  57.868  1.00 52.77           C  
ATOM     35  CG2 VAL     5      77.436 107.269  56.520  1.00 54.18           C  
ATOM     36  N   ILE     6      81.137 104.363  56.711  1.00 52.33           N  
ATOM     37  CA  ILE     6      82.026 103.430  57.382  1.00 49.91           C  
ATOM     38  C   ILE     6      82.772 104.247  58.432  1.00 49.12           C  
ATOM     39  O   ILE     6      83.618 105.076  58.104  1.00 48.62           O  
ATOM     40  CB  ILE     6      83.073 102.802  56.424  1.00 49.52           C  
ATOM     41  CG1 ILE     6      82.382 101.948  55.361  1.00 48.68           C  
ATOM     42  CG2 ILE     6      84.049 101.945  57.211  1.00 48.22           C  
ATOM     43  CD1 ILE     6      83.341 101.418  54.286  1.00 45.37           C  
ATOM     44  N   ILE     7      82.437 104.024  59.694  1.00 48.36           N  
ATOM     45  CA  ILE     7      83.100 104.722  60.774  1.00 47.98           C  
ATOM     46  C   ILE     7      84.274 103.877  61.245  1.00 48.52           C  
ATOM     47  O   ILE     7      84.083 102.855  61.902  1.00 49.70           O  
ATOM     48  CB  ILE     7      82.152 104.964  61.956  1.00 47.36           C  
ATOM     49  CG1 ILE     7      80.950 105.785  61.483  1.00 45.91           C  
ATOM     50  CG2 ILE     7      82.897 105.675  63.069  1.00 45.97           C  
ATOM     51  CD1 ILE     7      79.957 106.127  62.563  1.00 45.22           C  
ATOM     52  N   LEU     8      85.483 104.303  60.877  1.00 49.06           N  
ATOM     53  CA  LEU     8      86.714 103.622  61.268  1.00 49.60           C  
ATOM     54  C   LEU     8      87.006 104.013  62.709  1.00 50.81           C  
ATOM     55  O   LEU     8      87.061 105.197  63.029  1.00 51.50           O  
ATOM     56  CB  LEU     8      87.873 104.067  60.382  1.00 48.30           C  
ATOM     57  CG  LEU     8      87.724 103.786  58.888  1.00 46.60           C  
ATOM     58  CD1 LEU     8      88.961 104.291  58.149  1.00 42.20           C  
ATOM     59  CD2 LEU     8      87.531 102.280  58.665  1.00 43.49           C  
ATOM     60  N   ALA     9      87.171 103.020  63.575  1.00 52.52           N  
ATOM     61  CA  ALA     9      87.443 103.268  64.982  1.00 53.82           C  
ATOM     62  C   ALA     9      88.307 102.171  65.556  1.00 55.51           C  
ATOM     63  O   ALA     9      88.312 101.961  66.758  1.00 56.08           O  
ATOM     64  CB  ALA     9      86.139 103.372  65.772  1.00 52.59           C  
ATOM     65  N   ALA    10      89.020 101.455  64.693  1.00 59.12           N  
ATOM     66  CA  ALA    10      89.924 100.405  65.149  1.00 63.15           C  
ATOM     67  C   ALA    10      91.195 101.151  65.561  1.00 66.75           C  
ATOM     68  O   ALA    10      91.294 102.364  65.350  1.00 68.61           O  
ATOM     69  CB  ALA    10      90.206  99.433  64.026  1.00 62.44           C  
ATOM     70  N   GLY    11      92.175 100.469  66.134  1.00 70.21           N  
ATOM     71  CA  GLY    11      93.361 101.205  66.554  1.00 75.15           C  
ATOM     72  C   GLY    11      94.613 101.061  65.711  1.00 78.33           C  
ATOM     73  O   GLY    11      95.722 101.227  66.230  1.00 78.74           O  
ATOM     74  N   GLU    12      94.437 100.767  64.422  1.00 81.19           N  
ATOM     75  CA  GLU    12      95.550 100.577  63.494  1.00 83.59           C  
ATOM     76  C   GLU    12      96.612 101.665  63.553  1.00 85.71           C  
ATOM     77  O   GLU    12      96.314 102.831  63.835  1.00 85.98           O  
ATOM     78  CB  GLU    12      95.034 100.456  62.063  1.00 83.44           C  
ATOM     79  CG  GLU    12      94.041 101.527  61.667  1.00 82.74           C  
ATOM     80  CD  GLU    12      92.617 101.052  61.810  1.00 83.09           C  
ATOM     81  OE1 GLU    12      92.365  99.880  61.447  1.00 79.28           O  
ATOM     82  OE2 GLU    12      91.759 101.846  62.268  1.00 83.42           O  
ATOM     83  N   GLY    13      97.853 101.269  63.266  1.00 87.93           N  
ATOM     84  CA  GLY    13      98.965 102.201  63.319  1.00 90.43           C  
ATOM     85  C   GLY    13      99.062 102.724  64.740  1.00 92.14           C  
ATOM     86  O   GLY    13      98.707 102.020  65.697  1.00 91.86           O  
ATOM     87  N   LYS    14      99.551 103.951  64.888  1.00 93.73           N  
ATOM     88  CA  LYS    14      99.652 104.561  66.210  1.00 94.77           C  
ATOM     89  C   LYS    14      98.423 105.454  66.350  1.00 95.25           C  
ATOM     90  O   LYS    14      98.420 106.428  67.102  1.00 95.26           O  
ATOM     91  CB  LYS    14     100.936 105.384  66.328  1.00 94.77           C  
ATOM     92  N   ARG    15      97.380 105.105  65.601  1.00 95.97           N  
ATOM     93  CA  ARG    15      96.131 105.855  65.620  1.00 96.80           C  
ATOM     94  C   ARG    15      95.378 105.615  66.920  1.00 97.12           C  
ATOM     95  O   ARG    15      95.823 104.844  67.772  1.00 97.51           O  
ATOM     96  CB  ARG    15      95.254 105.445  64.439  1.00 96.58           C  
ATOM     97  CG  ARG    15      95.877 105.710  63.079  1.00 96.59           C  
ATOM     98  CD  ARG    15      94.898 105.384  61.960  1.00 96.12           C  
ATOM     99  NE  ARG    15      95.475 105.569  60.630  1.00 96.03           N  
ATOM    100  CZ  ARG    15      96.458 104.827  60.126  1.00 96.46           C  
ATOM    101  NH1 ARG    15      96.984 103.835  60.838  1.00 95.19           N  
ATOM    102  NH2 ARG    15      96.918 105.081  58.907  1.00 96.89           N  
ATOM    103  N   PHE    16      94.240 106.283  67.074  1.00 97.18           N  
ATOM    104  CA  PHE    16      93.436 106.119  68.275  1.00 97.49           C  
ATOM    105  C   PHE    16      92.698 104.794  68.262  1.00 97.80           C  
ATOM    106  O   PHE    16      92.768 104.042  67.287  1.00 98.44           O  
ATOM    107  CB  PHE    16      92.419 107.249  68.401  1.00 97.55           C  
ATOM    108  CG  PHE    16      92.908 108.410  69.205  1.00 98.14           C  
ATOM    109  CD1 PHE    16      92.008 109.219  69.890  1.00 98.54           C  
ATOM    110  CD2 PHE    16      94.269 108.692  69.288  1.00 98.99           C  
ATOM    111  CE1 PHE    16      92.454 110.286  70.657  1.00 99.73           C  
ATOM    112  CE2 PHE    16      94.730 109.756  70.052  1.00 99.73           C  
ATOM    113  CZ  PHE    16      93.821 110.559  70.737  1.00 99.73           C  
ATOM    114  N   GLY    17      91.990 104.498  69.346  1.00 97.56           N  
ATOM    115  CA  GLY    17      91.244 103.256  69.372  1.00 97.36           C  
ATOM    116  C   GLY    17      90.894 102.662  70.721  1.00 97.21           C  
ATOM    117  O   GLY    17      91.776 102.255  71.471  1.00 97.85           O  
ATOM    118  N   GLY    18      89.597 102.608  71.018  1.00 96.53           N  
ATOM    119  CA  GLY    18      89.120 102.023  72.260  1.00 94.80           C  
ATOM    120  C   GLY    18      89.396 102.785  73.541  1.00 93.58           C  
ATOM    121  O   GLY    18      88.477 103.303  74.183  1.00 93.59           O  
ATOM    122  N   ASP    19      90.660 102.835  73.938  1.00 91.98           N  
ATOM    123  CA  ASP    19      91.011 103.550  75.145  1.00 90.00           C  
ATOM    124  C   ASP    19      90.709 105.034  74.941  1.00 87.78           C  
ATOM    125  O   ASP    19      89.786 105.568  75.553  1.00 87.48           O  
ATOM    126  CB  ASP    19      92.493 103.309  75.509  1.00 91.01           C  
ATOM    127  CG  ASP    19      93.463 103.733  74.409  1.00 93.15           C  
ATOM    128  OD1 ASP    19      93.323 103.266  73.259  1.00 95.19           O  
ATOM    129  OD2 ASP    19      94.384 104.528  74.701  1.00 97.76           O  
ATOM    130  N   LYS    20      91.456 105.685  74.055  1.00 85.16           N  
ATOM    131  CA  LYS    20      91.273 107.110  73.786  1.00 82.92           C  
ATOM    132  C   LYS    20      89.816 107.477  73.458  1.00 80.52           C  
ATOM    133  O   LYS    20      89.253 108.420  74.027  1.00 80.56           O  
ATOM    134  CB  LYS    20      92.180 107.539  72.627  1.00 83.51           C  
ATOM    135  CG  LYS    20      93.671 107.243  72.823  1.00 86.11           C  
ATOM    136  CD  LYS    20      94.408 108.386  73.521  1.00 91.90           C  
ATOM    137  CE  LYS    20      95.905 108.087  73.660  1.00 92.28           C  
ATOM    138  NZ  LYS    20      96.592 107.877  72.350  1.00 91.97           N  
ATOM    139  N   LEU    21      89.210 106.721  72.546  1.00 77.43           N  
ATOM    140  CA  LEU    21      87.836 106.968  72.122  1.00 74.10           C  
ATOM    141  C   LEU    21      86.754 106.807  73.200  1.00 72.82           C  
ATOM    142  O   LEU    21      85.572 107.019  72.916  1.00 71.48           O  
ATOM    143  CB  LEU    21      87.507 106.089  70.906  1.00 73.69           C  
ATOM    144  CG  LEU    21      88.288 106.394  69.618  1.00 71.25           C  
ATOM    145  CD1 LEU    21      87.938 105.370  68.578  1.00 69.24           C  
ATOM    146  CD2 LEU    21      87.972 107.783  69.103  1.00 68.55           C  
ATOM    147  N   LEU    22      87.143 106.434  74.424  1.00 71.68           N  
ATOM    148  CA  LEU    22      86.172 106.290  75.512  1.00 70.37           C  
ATOM    149  C   LEU    22      86.095 107.557  76.356  1.00 69.76           C  
ATOM    150  O   LEU    22      85.162 107.730  77.144  1.00 69.42           O  
ATOM    151  CB  LEU    22      86.491 105.095  76.416  1.00 70.07           C  
ATOM    152  CG  LEU    22      86.082 103.676  75.982  1.00 71.01           C  
ATOM    153  CD1 LEU    22      85.902 102.800  77.220  1.00 68.76           C  
ATOM    154  CD2 LEU    22      84.773 103.705  75.206  1.00 72.70           C  
ATOM    155  N   ALA    23      87.078 108.441  76.174  1.00 69.46           N  
ATOM    156  CA  ALA    23      87.127 109.724  76.884  1.00 69.28           C  
ATOM    157  C   ALA    23      85.917 110.570  76.485  1.00 69.04           C  
ATOM    158  O   ALA    23      85.341 110.375  75.412  1.00 69.60           O  
ATOM    159  CB  ALA    23      88.409 110.460  76.543  1.00 69.01           C  
ATOM    160  N   LYS    24      85.549 111.522  77.337  1.00 68.45           N  
ATOM    161  CA  LYS    24      84.383 112.367  77.086  1.00 68.28           C  
ATOM    162  C   LYS    24      84.613 113.775  76.519  1.00 68.22           C  
ATOM    163  O   LYS    24      85.726 114.280  76.472  1.00 68.12           O  
ATOM    164  CB  LYS    24      83.569 112.483  78.376  1.00 67.78           C  
ATOM    165  CG  LYS    24      83.078 111.164  78.927  1.00 68.26           C  
ATOM    166  CD  LYS    24      82.344 111.376  80.231  1.00 66.88           C  
ATOM    167  CE  LYS    24      81.781 110.086  80.774  1.00 69.00           C  
ATOM    168  NZ  LYS    24      80.964 110.366  81.975  1.00 71.95           N  
ATOM    169  N   ILE    25      83.522 114.399  76.101  1.00 68.72           N  
ATOM    170  CA  ILE    25      83.525 115.746  75.553  1.00 69.60           C  
ATOM    171  C   ILE    25      82.113 116.231  75.805  1.00 70.70           C  
ATOM    172  O   ILE    25      81.199 115.924  75.039  1.00 70.98           O  
ATOM    173  CB  ILE    25      83.791 115.732  74.042  1.00 69.72           C  
ATOM    174  CG1 ILE    25      85.257 115.399  73.782  1.00 70.89           C  
ATOM    175  CG2 ILE    25      83.412 117.056  73.429  1.00 69.11           C  
ATOM    176  CD1 ILE    25      85.582 115.164  72.325  1.00 72.99           C  
ATOM    177  N   ASP    26      81.931 116.984  76.881  1.00 71.49           N  
ATOM    178  CA  ASP    26      80.604 117.463  77.233  1.00 72.41           C  
ATOM    179  C   ASP    26      79.866 116.270  77.805  1.00 71.27           C  
ATOM    180  O   ASP    26      78.696 116.051  77.478  1.00 71.67           O  
ATOM    181  CB  ASP    26      79.825 117.975  76.006  1.00 73.68           C  
ATOM    182  CG  ASP    26      80.186 119.402  75.626  1.00 79.66           C  
ATOM    183  OD1 ASP    26      80.133 120.280  76.516  1.00 86.88           O  
ATOM    184  OD2 ASP    26      80.510 119.650  74.441  1.00 84.59           O  
ATOM    185  N   ASN    27      80.559 115.481  78.628  1.00 68.93           N  
ATOM    186  CA  ASN    27      79.942 114.315  79.268  1.00 66.22           C  
ATOM    187  C   ASN    27      79.658 113.120  78.385  1.00 64.66           C  
ATOM    188  O   ASN    27      79.094 112.128  78.859  1.00 65.21           O  
ATOM    189  CB  ASN    27      78.612 114.688  79.922  1.00 65.54           C  
ATOM    190  CG  ASN    27      78.784 115.403  81.225  1.00 64.50           C  
ATOM    191  OD1 ASN    27      79.884 115.485  81.765  1.00 64.45           O  
ATOM    192  ND2 ASN    27      77.683 115.917  81.756  1.00 64.06           N  
ATOM    193  N   THR    28      80.000 113.196  77.108  1.00 62.05           N  
ATOM    194  CA  THR    28      79.717 112.060  76.257  1.00 59.69           C  
ATOM    195  C   THR    28      80.960 111.528  75.569  1.00 58.20           C  
ATOM    196  O   THR    28      81.777 112.288  75.050  1.00 57.50           O  
ATOM    197  CB  THR    28      78.640 112.384  75.191  1.00 59.45           C  
ATOM    198  OG1 THR    28      79.251 112.466  73.900  1.00 59.73           O  
ATOM    199  CG2 THR    28      77.942 113.690  75.508  1.00 57.57           C  
ATOM    200  N   PRO    29      81.119 110.198  75.579  1.00 56.76           N  
ATOM    201  CA  PRO    29      82.239 109.478  74.972  1.00 56.34           C  
ATOM    202  C   PRO    29      82.454 109.932  73.529  1.00 55.95           C  
ATOM    203  O   PRO    29      81.504 110.038  72.765  1.00 56.53           O  
ATOM    204  CB  PRO    29      81.788 108.027  75.065  1.00 56.52           C  
ATOM    205  CG  PRO    29      80.997 108.025  76.333  1.00 56.54           C  
ATOM    206  CD  PRO    29      80.176 109.262  76.213  1.00 55.49           C  
ATOM    207  N   ILE    30      83.700 110.192  73.157  1.00 55.38           N  
ATOM    208  CA  ILE    30      84.000 110.645  71.811  1.00 55.43           C  
ATOM    209  C   ILE    30      83.353 109.800  70.720  1.00 55.32           C  
ATOM    210  O   ILE    30      82.564 110.328  69.926  1.00 56.08           O  
ATOM    211  CB  ILE    30      85.522 110.709  71.577  1.00 55.57           C  
ATOM    212  CG1 ILE    30      86.136 111.685  72.580  1.00 58.50           C  
ATOM    213  CG2 ILE    30      85.833 111.166  70.152  1.00 55.90           C  
ATOM    214  CD1 ILE    30      87.631 111.558  72.699  1.00 61.89           C  
ATOM    215  N   ILE    31      83.672 108.504  70.676  1.00 54.45           N  
ATOM    216  CA  ILE    31      83.118 107.613  69.647  1.00 53.69           C  
ATOM    217  C   ILE    31      81.614 107.793  69.494  1.00 54.48           C  
ATOM    218  O   ILE    31      81.101 107.817  68.377  1.00 53.94           O  
ATOM    219  CB  ILE    31      83.430 106.091  69.930  1.00 53.14           C  
ATOM    220  CG1 ILE    31      82.977 105.234  68.744  1.00 52.34           C  
ATOM    221  CG2 ILE    31      82.709 105.612  71.178  1.00 49.66           C  
ATOM    222  CD1 ILE    31      83.529 105.698  67.414  1.00 48.24           C  
ATOM    223  N   MET    32      80.915 107.933  70.614  1.00 55.33           N  
ATOM    224  CA  MET    32      79.468 108.124  70.580  1.00 57.31           C  
ATOM    225  C   MET    32      79.075 109.453  69.925  1.00 57.61           C  
ATOM    226  O   MET    32      78.130 109.518  69.147  1.00 58.36           O  
ATOM    227  CB  MET    32      78.889 108.041  71.994  1.00 57.46           C  
ATOM    228  CG  MET    32      78.996 106.661  72.614  1.00 62.54           C  
ATOM    229  SD  MET    32      78.000 106.473  74.269  1.00 78.05          SE  
ATOM    230  CE  MET    32      76.220 106.221  73.530  1.00 73.81           C  
ATOM    231  N   ARG    33      79.804 110.515  70.236  1.00 57.73           N  
ATOM    232  CA  ARG    33      79.511 111.806  69.650  1.00 57.85           C  
ATOM    233  C   ARG    33      79.694 111.710  68.131  1.00 56.91           C  
ATOM    234  O   ARG    33      78.834 112.133  67.368  1.00 56.97           O  
ATOM    235  CB  ARG    33      80.455 112.857  70.228  1.00 58.89           C  
ATOM    236  CG  ARG    33      80.107 114.287  69.860  1.00 64.39           C  
ATOM    237  CD  ARG    33      81.310 115.202  70.074  1.00 73.49           C  
ATOM    238  NE  ARG    33      80.955 116.619  70.038  1.00 79.65           N  
ATOM    239  CZ  ARG    33      80.209 117.224  70.960  1.00 84.29           C  
ATOM    240  NH1 ARG    33      79.728 116.544  72.002  1.00 85.07           N  
ATOM    241  NH2 ARG    33      79.953 118.518  70.841  1.00 85.09           N  
ATOM    242  N   THR    34      80.818 111.141  67.710  1.00 55.65           N  
ATOM    243  CA  THR    34      81.154 110.977  66.299  1.00 55.20           C  
ATOM    244  C   THR    34      80.093 110.227  65.496  1.00 56.00           C  
ATOM    245  O   THR    34      79.744 110.616  64.383  1.00 57.09           O  
ATOM    246  CB  THR    34      82.487 110.233  66.153  1.00 54.71           C  
ATOM    247  OG1 THR    34      83.528 111.010  66.753  1.00 56.07           O  
ATOM    248  CG2 THR    34      82.817 109.991  64.698  1.00 53.23           C  
ATOM    249  N   ILE    35      79.595 109.135  66.050  1.00 55.81           N  
ATOM    250  CA  ILE    35      78.573 108.350  65.382  1.00 55.24           C  
ATOM    251  C   ILE    35      77.285 109.182  65.289  1.00 56.74           C  
ATOM    252  O   ILE    35      76.516 109.062  64.335  1.00 56.77           O  
ATOM    253  CB  ILE    35      78.314 107.055  66.181  1.00 54.53           C  
ATOM    254  CG1 ILE    35      79.523 106.122  66.057  1.00 52.33           C  
ATOM    255  CG2 ILE    35      77.025 106.392  65.721  1.00 54.33           C  
ATOM    256  CD1 ILE    35      79.511 104.992  67.061  1.00 52.36           C  
ATOM    257  N   ARG    36      77.063 110.034  66.285  1.00 58.78           N  
ATOM    258  CA  ARG    36      75.872 110.873  66.330  1.00 60.98           C  
ATOM    259  C   ARG    36      75.736 111.810  65.126  1.00 60.67           C  
ATOM    260  O   ARG    36      74.623 112.054  64.639  1.00 60.67           O  
ATOM    261  CB  ARG    36      75.856 111.709  67.617  1.00 62.08           C  
ATOM    262  CG  ARG    36      74.700 112.698  67.669  1.00 70.34           C  
ATOM    263  CD  ARG    36      74.838 113.806  68.723  1.00 81.85           C  
ATOM    264  NE  ARG    36      73.929 114.914  68.396  1.00 91.09           N  
ATOM    265  CZ  ARG    36      73.705 115.989  69.155  1.00 95.58           C  
ATOM    266  NH1 ARG    36      74.321 116.134  70.323  1.00 98.47           N  
ATOM    267  NH2 ARG    36      72.864 116.934  68.737  1.00 96.39           N  
ATOM    268  N   ILE    37      76.852 112.330  64.630  1.00 60.37           N  
ATOM    269  CA  ILE    37      76.760 113.262  63.520  1.00 60.38           C  
ATOM    270  C   ILE    37      76.210 112.662  62.239  1.00 59.58           C  
ATOM    271  O   ILE    37      75.575 113.366  61.461  1.00 60.82           O  
ATOM    272  CB  ILE    37      78.127 113.955  63.185  1.00 60.43           C  
ATOM    273  CG1 ILE    37      78.674 113.407  61.868  1.00 62.85           C  
ATOM    274  CG2 ILE    37      79.129 113.773  64.316  1.00 59.72           C  
ATOM    275  CD1 ILE    37      79.796 114.225  61.284  1.00 67.67           C  
ATOM    276  N   TYR    38      76.439 111.376  62.009  1.00 58.46           N  
ATOM    277  CA  TYR    38      75.958 110.767  60.772  1.00 58.42           C  
ATOM    278  C   TYR    38      74.512 110.287  60.843  1.00 59.45           C  
ATOM    279  O   TYR    38      74.027 109.572  59.957  1.00 59.42           O  
ATOM    280  CB  TYR    38      76.898 109.643  60.352  1.00 57.53           C  
ATOM    281  CG  TYR    38      78.318 110.140  60.220  1.00 57.36           C  
ATOM    282  CD1 TYR    38      79.162 110.183  61.328  1.00 55.51           C  
ATOM    283  CD2 TYR    38      78.800 110.631  59.012  1.00 55.63           C  
ATOM    284  CE1 TYR    38      80.441 110.698  61.244  1.00 49.86           C  
ATOM    285  CE2 TYR    38      80.086 111.152  58.916  1.00 54.10           C  
ATOM    286  CZ  TYR    38      80.901 111.178  60.041  1.00 51.45           C  
ATOM    287  OH  TYR    38      82.186 111.662  59.964  1.00 47.93           O  
ATOM    288  N   GLY    39      73.835 110.720  61.907  1.00 60.10           N  
ATOM    289  CA  GLY    39      72.436 110.407  62.143  1.00 60.00           C  
ATOM    290  C   GLY    39      71.855 109.148  61.549  1.00 60.55           C  
ATOM    291  O   GLY    39      72.378 108.058  61.752  1.00 61.52           O  
ATOM    292  N   ASP    40      70.771 109.296  60.796  1.00 60.94           N  
ATOM    293  CA  ASP    40      70.101 108.136  60.216  1.00 61.01           C  
ATOM    294  C   ASP    40      70.751 107.499  58.989  1.00 60.50           C  
ATOM    295  O   ASP    40      70.166 106.593  58.398  1.00 61.61           O  
ATOM    296  CB  ASP    40      68.633 108.467  59.925  1.00 61.37           C  
ATOM    297  N   LEU    41      71.943 107.952  58.601  1.00 59.40           N  
ATOM    298  CA  LEU    41      72.634 107.336  57.466  1.00 58.41           C  
ATOM    299  C   LEU    41      73.003 105.901  57.874  1.00 58.10           C  
ATOM    300  O   LEU    41      73.050 105.601  59.061  1.00 58.57           O  
ATOM    301  CB  LEU    41      73.916 108.105  57.132  1.00 57.99           C  
ATOM    302  CG  LEU    41      73.826 109.512  56.542  1.00 57.23           C  
ATOM    303  CD1 LEU    41      75.230 110.107  56.371  1.00 57.65           C  
ATOM    304  CD2 LEU    41      73.115 109.447  55.218  1.00 57.35           C  
ATOM    305  N   GLU    42      73.254 105.021  56.905  1.00 57.72           N  
ATOM    306  CA  GLU    42      73.638 103.638  57.205  1.00 58.18           C  
ATOM    307  C   GLU    42      75.083 103.558  57.672  1.00 57.58           C  
ATOM    308  O   GLU    42      76.007 103.563  56.865  1.00 58.58           O  
ATOM    309  CB  GLU    42      73.507 102.748  55.983  1.00 58.83           C  
ATOM    310  CG  GLU    42      72.111 102.537  55.499  1.00 63.58           C  
ATOM    311  CD  GLU    42      72.067 101.539  54.355  1.00 70.64           C  
ATOM    312  OE1 GLU    42      72.384 100.347  54.605  1.00 73.15           O  
ATOM    313  OE2 GLU    42      71.728 101.953  53.216  1.00 70.47           O  
ATOM    314  N   LYS    43      75.268 103.444  58.978  1.00 56.57           N  
ATOM    315  CA  LYS    43      76.589 103.388  59.574  1.00 54.94           C  
ATOM    316  C   LYS    43      77.058 101.962  59.729  1.00 53.93           C  
ATOM    317  O   LYS    43      76.296 101.025  59.586  1.00 54.99           O  
ATOM    318  CB  LYS    43      76.539 104.053  60.944  1.00 54.21           C  
ATOM    319  CG  LYS    43      76.089 105.493  60.873  1.00 56.44           C  
ATOM    320  CD  LYS    43      75.508 105.986  62.175  1.00 57.68           C  
ATOM    321  CE  LYS    43      74.133 105.422  62.382  1.00 62.41           C  
ATOM    322  NZ  LYS    43      73.639 105.759  63.752  1.00 70.06           N  
ATOM    323  N   ILE    44      78.336 101.815  60.023  1.00 53.03           N  
ATOM    324  CA  ILE    44      78.956 100.522  60.253  1.00 51.66           C  
ATOM    325  C   ILE    44      80.189 100.978  61.016  1.00 50.86           C  
ATOM    326  O   ILE    44      80.899 101.871  60.552  1.00 50.25           O  
ATOM    327  CB  ILE    44      79.325  99.798  58.892  1.00 51.74           C  
ATOM    328  CG1 ILE    44      78.773  98.381  58.892  1.00 53.42           C  
ATOM    329  CG2 ILE    44      80.828  99.652  58.706  1.00 51.40           C  
ATOM    330  CD1 ILE    44      77.286  98.305  59.143  1.00 58.76           C  
ATOM    331  N   ILE    45      80.414 100.441  62.209  1.00 49.37           N  
ATOM    332  CA  ILE    45      81.605 100.835  62.958  1.00 48.60           C  
ATOM    333  C   ILE    45      82.599  99.678  62.948  1.00 47.89           C  
ATOM    334  O   ILE    45      82.250  98.549  63.296  1.00 47.54           O  
ATOM    335  CB  ILE    45      81.288 101.224  64.429  1.00 48.70           C  
ATOM    336  CG1 ILE    45      80.526 102.551  64.500  1.00 51.62           C  
ATOM    337  CG2 ILE    45      82.577 101.466  65.175  1.00 48.08           C  
ATOM    338  CD1 ILE    45      79.121 102.524  64.017  1.00 50.63           C  
ATOM    339  N   ILE    46      83.832  99.957  62.530  1.00 47.84           N  
ATOM    340  CA  ILE    46      84.878  98.932  62.471  1.00 48.03           C  
ATOM    341  C   ILE    46      85.761  99.062  63.707  1.00 49.81           C  
ATOM    342  O   ILE    46      86.479 100.044  63.874  1.00 49.96           O  
ATOM    343  CB  ILE    46      85.750  99.079  61.206  1.00 47.88           C  
ATOM    344  CG1 ILE    46      84.863  99.339  59.981  1.00 46.63           C  
ATOM    345  CG2 ILE    46      86.567  97.822  61.007  1.00 45.07           C  
ATOM    346  CD1 ILE    46      83.919  98.205  59.659  1.00 46.69           C  
ATOM    347  N   VAL    47      85.713  98.050  64.563  1.00 51.65           N  
ATOM    348  CA  VAL    47      86.454  98.057  65.801  1.00 52.13           C  
ATOM    349  C   VAL    47      87.558  97.039  65.857  1.00 52.86           C  
ATOM    350  O   VAL    47      87.385  95.892  65.465  1.00 53.50           O  
ATOM    351  CB  VAL    47      85.489  97.786  66.997  1.00 52.29           C  
ATOM    352  CG1 VAL    47      86.271  97.710  68.308  1.00 58.76           C  
ATOM    353  CG2 VAL    47      84.434  98.880  67.086  1.00 49.63           C  
ATOM    354  N   GLY    48      88.700  97.489  66.340  1.00 53.86           N  
ATOM    355  CA  GLY    48      89.803  96.591  66.529  1.00 56.32           C  
ATOM    356  C   GLY    48      90.462  96.636  67.900  1.00 58.56           C  
ATOM    357  O   GLY    48      90.053  95.931  68.838  1.00 58.36           O  
ATOM    358  N   LYS    49      91.398  97.574  68.039  1.00 60.27           N  
ATOM    359  CA  LYS    49      92.245  97.618  69.209  1.00 61.92           C  
ATOM    360  C   LYS    49      91.645  97.359  70.559  1.00 62.63           C  
ATOM    361  O   LYS    49      92.151  96.541  71.335  1.00 63.40           O  
ATOM    362  CB  LYS    49      93.101  98.892  69.217  1.00 62.68           C  
ATOM    363  CG  LYS    49      94.220  98.881  70.262  1.00 65.72           C  
ATOM    364  CD  LYS    49      95.293  99.902  69.929  1.00 71.92           C  
ATOM    365  CE  LYS    49      96.442  99.825  70.923  1.00 74.57           C  
ATOM    366  NZ  LYS    49      97.419 100.945  70.723  1.00 77.45           N  
ATOM    367  N   TYR    50      90.541  98.024  70.825  1.00 61.98           N  
ATOM    368  CA  TYR    50      89.878  97.870  72.096  1.00 62.40           C  
ATOM    369  C   TYR    50      88.384  97.537  72.004  1.00 61.32           C  
ATOM    370  O   TYR    50      87.543  98.201  72.619  1.00 60.53           O  
ATOM    371  CB  TYR    50      90.093  99.142  72.913  1.00 64.35           C  
ATOM    372  CG  TYR    50      91.467  99.231  73.557  1.00 69.92           C  
ATOM    373  CD1 TYR    50      91.851  98.321  74.548  1.00 75.20           C  
ATOM    374  CD2 TYR    50      92.380 100.226  73.191  1.00 71.41           C  
ATOM    375  CE1 TYR    50      93.106  98.398  75.162  1.00 76.64           C  
ATOM    376  CE2 TYR    50      93.639 100.315  73.798  1.00 73.94           C  
ATOM    377  CZ  TYR    50      93.993  99.399  74.787  1.00 76.90           C  
ATOM    378  OH  TYR    50      95.211  99.503  75.430  1.00 78.80           O  
ATOM    379  N   VAL    51      88.073  96.495  71.237  1.00 59.63           N  
ATOM    380  CA  VAL    51      86.707  96.020  71.054  1.00 57.84           C  
ATOM    381  C   VAL    51      85.939  95.973  72.370  1.00 58.37           C  
ATOM    382  O   VAL    51      84.792  96.426  72.461  1.00 58.73           O  
ATOM    383  CB  VAL    51      86.667  94.573  70.482  1.00 58.21           C  
ATOM    384  CG1 VAL    51      85.824  94.537  69.223  1.00 57.69           C  
ATOM    385  CG2 VAL    51      88.069  94.054  70.218  1.00 57.30           C  
ATOM    386  N   ASN    52      86.588  95.412  73.385  1.00 58.63           N  
ATOM    387  CA  ASN    52      86.002  95.231  74.703  1.00 59.29           C  
ATOM    388  C   ASN    52      85.566  96.513  75.391  1.00 59.39           C  
ATOM    389  O   ASN    52      84.513  96.545  76.008  1.00 59.70           O  
ATOM    390  CB  ASN    52      86.986  94.443  75.559  1.00 60.17           C  
ATOM    391  CG  ASN    52      87.796  93.442  74.727  1.00 64.37           C  
ATOM    392  OD1 ASN    52      88.879  93.772  74.214  1.00 67.78           O  
ATOM    393  ND2 ASN    52      87.259  92.223  74.562  1.00 65.23           N  
ATOM    394  N   GLU    53      86.366  97.567  75.292  1.00 60.29           N  
ATOM    395  CA  GLU    53      86.020  98.851  75.889  1.00 60.62           C  
ATOM    396  C   GLU    53      84.865  99.468  75.113  1.00 60.18           C  
ATOM    397  O   GLU    53      83.879  99.925  75.678  1.00 60.82           O  
ATOM    398  CB  GLU    53      87.187  99.834  75.787  1.00 61.28           C  
ATOM    399  CG  GLU    53      88.107  99.932  76.968  1.00 65.75           C  
ATOM    400  CD  GLU    53      89.111  98.815  77.002  1.00 74.97           C  
ATOM    401  OE1 GLU    53      90.250  99.080  77.464  1.00 79.21           O  
ATOM    402  OE2 GLU    53      88.760  97.683  76.579  1.00 76.94           O  
ATOM    403  N   MET    54      85.035  99.481  73.800  1.00 59.89           N  
ATOM    404  CA  MET    54      84.103 100.063  72.844  1.00 60.56           C  
ATOM    405  C   MET    54      82.660  99.563  72.773  1.00 58.62           C  
ATOM    406  O   MET    54      81.708 100.349  72.841  1.00 58.00           O  
ATOM    407  CB  MET    54      84.697  99.924  71.449  1.00 62.14           C  
ATOM    408  CG  MET    54      86.053 100.549  71.282  1.00 69.52           C  
ATOM    409  SD  MET    54      85.886 102.012  70.073  1.00 90.15          SE  
ATOM    410  CE  MET    54      85.198 103.287  71.348  1.00 84.00           C  
ATOM    411  N   LEU    55      82.502  98.256  72.622  1.00 55.88           N  
ATOM    412  CA  LEU    55      81.184  97.676  72.459  1.00 54.39           C  
ATOM    413  C   LEU    55      80.040  98.066  73.373  1.00 53.04           C  
ATOM    414  O   LEU    55      78.959  98.398  72.897  1.00 53.20           O  
ATOM    415  CB  LEU    55      81.306  96.155  72.391  1.00 54.90           C  
ATOM    416  CG  LEU    55      81.307  95.787  70.903  1.00 56.33           C  
ATOM    417  CD1 LEU    55      82.157  94.570  70.662  1.00 61.30           C  
ATOM    418  CD2 LEU    55      79.872  95.590  70.432  1.00 52.82           C  
ATOM    419  N   PRO    56      80.249  98.046  74.694  1.00 51.29           N  
ATOM    420  CA  PRO    56      79.124  98.414  75.552  1.00 49.78           C  
ATOM    421  C   PRO    56      78.523  99.780  75.249  1.00 49.42           C  
ATOM    422  O   PRO    56      77.448 100.106  75.750  1.00 48.99           O  
ATOM    423  CB  PRO    56      79.719  98.312  76.948  1.00 49.07           C  
ATOM    424  CG  PRO    56      80.722  97.225  76.789  1.00 49.39           C  
ATOM    425  CD  PRO    56      81.395  97.595  75.498  1.00 49.72           C  
ATOM    426  N   LEU    57      79.216 100.574  74.436  1.00 49.11           N  
ATOM    427  CA  LEU    57      78.729 101.905  74.052  1.00 50.18           C  
ATOM    428  C   LEU    57      78.107 101.899  72.662  1.00 50.24           C  
ATOM    429  O   LEU    57      77.524 102.890  72.243  1.00 51.13           O  
ATOM    430  CB  LEU    57      79.862 102.932  74.024  1.00 50.39           C  
ATOM    431  CG  LEU    57      80.628 103.337  75.273  1.00 52.72           C  
ATOM    432  CD1 LEU    57      81.414 102.155  75.842  1.00 56.04           C  
ATOM    433  CD2 LEU    57      81.565 104.462  74.883  1.00 54.20           C  
ATOM    434  N   LEU    58      78.256 100.789  71.948  1.00 49.46           N  
ATOM    435  CA  LEU    58      77.741 100.660  70.593  1.00 48.48           C  
ATOM    436  C   LEU    58      76.717  99.532  70.493  1.00 49.44           C  
ATOM    437  O   LEU    58      76.510  98.994  69.411  1.00 50.42           O  
ATOM    438  CB  LEU    58      78.896 100.345  69.647  1.00 47.40           C  
ATOM    439  CG  LEU    58      80.166 101.180  69.771  1.00 44.88           C  
ATOM    440  CD1 LEU    58      81.278 100.576  68.929  1.00 42.95           C  
ATOM    441  CD2 LEU    58      79.876 102.572  69.324  1.00 44.85           C  
ATOM    442  N   MET    59      76.078  99.174  71.605  1.00 49.35           N  
ATOM    443  CA  MET    59      75.125  98.067  71.600  1.00 49.73           C  
ATOM    444  C   MET    59      73.985  98.168  70.591  1.00 49.30           C  
ATOM    445  O   MET    59      73.364  97.162  70.244  1.00 49.30           O  
ATOM    446  CB  MET    59      74.559  97.842  73.010  1.00 50.89           C  
ATOM    447  CG  MET    59      75.565  97.287  74.017  1.00 54.13           C  
ATOM    448  SD  MET    59      76.588  95.782  73.324  1.00 70.34          SE  
ATOM    449  CE  MET    59      75.361  94.347  73.753  1.00 58.89           C  
ATOM    450  N   ASP    60      73.708  99.374  70.110  1.00 47.86           N  
ATOM    451  CA  ASP    60      72.653  99.565  69.124  1.00 46.66           C  
ATOM    452  C   ASP    60      73.221  99.860  67.735  1.00 46.22           C  
ATOM    453  O   ASP    60      72.538 100.445  66.911  1.00 47.02           O  
ATOM    454  CB  ASP    60      71.777 100.727  69.535  1.00 46.17           C  
ATOM    455  CG  ASP    60      72.544 102.034  69.589  1.00 48.07           C  
ATOM    456  OD1 ASP    60      73.801 102.003  69.559  1.00 53.28           O  
ATOM    457  OD2 ASP    60      71.888 103.091  69.676  1.00 47.99           O  
ATOM    458  N   GLN    61      74.463  99.468  67.479  1.00 45.11           N  
ATOM    459  CA  GLN    61      75.091  99.721  66.192  1.00 45.51           C  
ATOM    460  C   GLN    61      75.570  98.418  65.558  1.00 45.51           C  
ATOM    461  O   GLN    61      75.632  97.396  66.234  1.00 47.80           O  
ATOM    462  CB  GLN    61      76.304 100.641  66.367  1.00 44.61           C  
ATOM    463  CG  GLN    61      76.029 101.970  67.031  1.00 47.76           C  
ATOM    464  CD  GLN    61      75.216 102.919  66.169  1.00 49.19           C  
ATOM    465  OE1 GLN    61      75.521 103.116  65.002  1.00 50.52           O  
ATOM    466  NE2 GLN    61      74.185 103.520  66.749  1.00 52.55           N  
ATOM    467  N   ILE    62      75.892  98.445  64.267  1.00 43.40           N  
ATOM    468  CA  ILE    62      76.422  97.260  63.623  1.00 42.80           C  
ATOM    469  C   ILE    62      77.933  97.417  63.754  1.00 43.20           C  
ATOM    470  O   ILE    62      78.536  98.329  63.179  1.00 43.46           O  
ATOM    471  CB  ILE    62      76.065  97.163  62.119  1.00 43.54           C  
ATOM    472  CG1 ILE    62      74.578  96.871  61.943  1.00 44.93           C  
ATOM    473  CG2 ILE    62      76.870  96.046  61.466  1.00 40.91           C  
ATOM    474  CD1 ILE    62      74.146  96.881  60.518  1.00 44.82           C  
ATOM    475  N   VAL    63      78.547  96.526  64.519  1.00 43.82           N  
ATOM    476  CA  VAL    63      79.975  96.594  64.738  1.00 42.60           C  
ATOM    477  C   VAL    63      80.726  95.410  64.165  1.00 43.60           C  
ATOM    478  O   VAL    63      80.362  94.255  64.412  1.00 44.70           O  
ATOM    479  CB  VAL    63      80.264  96.654  66.221  1.00 42.01           C  
ATOM    480  CG1 VAL    63      81.728  96.879  66.438  1.00 41.44           C  
ATOM    481  CG2 VAL    63      79.437  97.758  66.849  1.00 40.36           C  
ATOM    482  N   ILE    64      81.760  95.691  63.380  1.00 43.38           N  
ATOM    483  CA  ILE    64      82.579  94.618  62.834  1.00 43.76           C  
ATOM    484  C   ILE    64      83.935  94.756  63.513  1.00 43.62           C  
ATOM    485  O   ILE    64      84.577  95.801  63.455  1.00 43.62           O  
ATOM    486  CB  ILE    64      82.821  94.702  61.278  1.00 44.89           C  
ATOM    487  CG1 ILE    64      81.509  94.822  60.510  1.00 45.55           C  
ATOM    488  CG2 ILE    64      83.526  93.442  60.799  1.00 41.36           C  
ATOM    489  CD1 ILE    64      81.032  96.228  60.377  1.00 50.68           C  
ATOM    490  N   TYR    65      84.349  93.690  64.171  1.00 43.63           N  
ATOM    491  CA  TYR    65      85.625  93.649  64.829  1.00 43.37           C  
ATOM    492  C   TYR    65      86.648  93.145  63.818  1.00 44.75           C  
ATOM    493  O   TYR    65      86.500  92.057  63.249  1.00 43.95           O  
ATOM    494  CB  TYR    65      85.565  92.702  66.019  1.00 43.55           C  
ATOM    495  CG  TYR    65      86.918  92.251  66.487  1.00 41.43           C  
ATOM    496  CD1 TYR    65      87.852  93.164  66.972  1.00 38.27           C  
ATOM    497  CD2 TYR    65      87.280  90.912  66.418  1.00 41.59           C  
ATOM    498  CE1 TYR    65      89.120  92.749  67.377  1.00 40.70           C  
ATOM    499  CE2 TYR    65      88.550  90.489  66.822  1.00 45.09           C  
ATOM    500  CZ  TYR    65      89.460  91.409  67.299  1.00 42.17           C  
ATOM    501  OH  TYR    65      90.693  90.979  67.699  1.00 40.96           O  
ATOM    502  N   ASN    66      87.685  93.944  63.593  1.00 46.17           N  
ATOM    503  CA  ASN    66      88.737  93.574  62.660  1.00 47.65           C  
ATOM    504  C   ASN    66      89.911  92.902  63.383  1.00 49.38           C  
ATOM    505  O   ASN    66      90.732  93.568  63.999  1.00 50.31           O  
ATOM    506  CB  ASN    66      89.215  94.819  61.946  1.00 47.78           C  
ATOM    507  CG  ASN    66      90.256  94.527  60.923  1.00 47.90           C  
ATOM    508  OD1 ASN    66      90.794  95.442  60.318  1.00 49.13           O  
ATOM    509  ND2 ASN    66      90.552  93.247  60.710  1.00 45.03           N  
ATOM    510  N   PRO    67      90.018  91.566  63.301  1.00 50.88           N  
ATOM    511  CA  PRO    67      91.125  90.896  63.985  1.00 51.48           C  
ATOM    512  C   PRO    67      92.476  91.236  63.350  1.00 51.83           C  
ATOM    513  O   PRO    67      93.525  90.865  63.872  1.00 52.03           O  
ATOM    514  CB  PRO    67      90.772  89.428  63.819  1.00 50.88           C  
ATOM    515  CG  PRO    67      90.292  89.417  62.428  1.00 50.27           C  
ATOM    516  CD  PRO    67      89.335  90.615  62.409  1.00 51.26           C  
ATOM    517  N   PHE    68      92.447  91.941  62.226  1.00 51.67           N  
ATOM    518  CA  PHE    68      93.677  92.303  61.527  1.00 51.96           C  
ATOM    519  C   PHE    68      94.032  93.784  61.633  1.00 51.17           C  
ATOM    520  O   PHE    68      94.899  94.260  60.898  1.00 50.54           O  
ATOM    521  CB  PHE    68      93.555  91.945  60.047  1.00 52.16           C  
ATOM    522  CG  PHE    68      93.289  90.497  59.797  1.00 55.38           C  
ATOM    523  CD1 PHE    68      94.332  89.575  59.785  1.00 56.42           C  
ATOM    524  CD2 PHE    68      91.985  90.042  59.594  1.00 58.52           C  
ATOM    525  CE1 PHE    68      94.080  88.223  59.572  1.00 55.86           C  
ATOM    526  CE2 PHE    68      91.724  88.689  59.382  1.00 57.31           C  
ATOM    527  CZ  PHE    68      92.775  87.781  59.372  1.00 57.16           C  
ATOM    528  N   TRP    69      93.372  94.503  62.542  1.00 50.63           N  
ATOM    529  CA  TRP    69      93.603  95.940  62.694  1.00 50.90           C  
ATOM    530  C   TRP    69      95.071  96.320  62.846  1.00 51.38           C  
ATOM    531  O   TRP    69      95.521  97.326  62.316  1.00 50.73           O  
ATOM    532  CB  TRP    69      92.818  96.480  63.889  1.00 49.66           C  
ATOM    533  CG  TRP    69      93.264  95.906  65.183  1.00 49.78           C  
ATOM    534  CD1 TRP    69      92.800  94.774  65.775  1.00 47.87           C  
ATOM    535  CD2 TRP    69      94.302  96.408  66.032  1.00 49.42           C  
ATOM    536  NE1 TRP    69      93.478  94.536  66.941  1.00 49.11           N  
ATOM    537  CE2 TRP    69      94.411  95.524  67.126  1.00 49.69           C  
ATOM    538  CE3 TRP    69      95.154  97.522  65.977  1.00 49.81           C  
ATOM    539  CZ2 TRP    69      95.340  95.710  68.161  1.00 49.98           C  
ATOM    540  CZ3 TRP    69      96.077  97.709  67.006  1.00 48.86           C  
ATOM    541  CH2 TRP    69      96.160  96.806  68.082  1.00 50.99           C  
ATOM    542  N   ASN    70      95.801  95.490  63.574  1.00 52.70           N  
ATOM    543  CA  ASN    70      97.215  95.690  63.847  1.00 54.65           C  
ATOM    544  C   ASN    70      98.005  95.820  62.549  1.00 53.81           C  
ATOM    545  O   ASN    70      99.035  96.490  62.490  1.00 53.07           O  
ATOM    546  CB  ASN    70      97.723  94.499  64.672  1.00 56.29           C  
ATOM    547  CG  ASN    70      99.025  94.795  65.410  1.00 62.67           C  
ATOM    548  OD1 ASN    70      99.292  95.939  65.809  1.00 69.67           O  
ATOM    549  ND2 ASN    70      99.833  93.754  65.620  1.00 69.79           N  
ATOM    550  N   GLU    71      97.494  95.180  61.509  1.00 53.46           N  
ATOM    551  CA  GLU    71      98.120  95.181  60.202  1.00 53.66           C  
ATOM    552  C   GLU    71      98.038  96.539  59.483  1.00 53.22           C  
ATOM    553  O   GLU    71      98.893  96.854  58.649  1.00 53.15           O  
ATOM    554  CB  GLU    71      97.480  94.092  59.347  1.00 53.92           C  
ATOM    555  CG  GLU    71      98.156  93.870  58.026  1.00 58.69           C  
ATOM    556  CD  GLU    71      97.542  92.719  57.273  1.00 65.74           C  
ATOM    557  OE1 GLU    71      97.404  91.637  57.887  1.00 67.82           O  
ATOM    558  OE2 GLU    71      97.205  92.893  56.079  1.00 68.24           O  
ATOM    559  N   GLY    72      97.022  97.341  59.793  1.00 51.92           N  
ATOM    560  CA  GLY    72      96.920  98.636  59.147  1.00 50.61           C  
ATOM    561  C   GLY    72      95.502  99.049  58.821  1.00 49.73           C  
ATOM    562  O   GLY    72      94.600  98.212  58.787  1.00 50.44           O  
ATOM    563  N   ILE    73      95.305 100.336  58.544  1.00 47.95           N  
ATOM    564  CA  ILE    73      93.970 100.851  58.265  1.00 46.95           C  
ATOM    565  C   ILE    73      93.289 100.350  56.984  1.00 48.19           C  
ATOM    566  O   ILE    73      92.067 100.307  56.913  1.00 48.72           O  
ATOM    567  CB  ILE    73      93.965 102.408  58.279  1.00 45.94           C  
ATOM    568  CG1 ILE    73      92.529 102.910  58.439  1.00 44.83           C  
ATOM    569  CG2 ILE    73      94.575 102.956  57.005  1.00 43.64           C  
ATOM    570  CD1 ILE    73      92.435 104.343  58.871  1.00 42.31           C  
ATOM    571  N   SER    74      94.062  99.969  55.977  1.00 49.42           N  
ATOM    572  CA  SER    74      93.464  99.487  54.733  1.00 50.51           C  
ATOM    573  C   SER    74      92.662  98.231  55.036  1.00 51.13           C  
ATOM    574  O   SER    74      91.685  97.907  54.367  1.00 51.71           O  
ATOM    575  CB  SER    74      94.549  99.127  53.714  1.00 51.19           C  
ATOM    576  OG  SER    74      95.090  97.841  53.993  1.00 52.05           O  
ATOM    577  N   THR    75      93.106  97.528  56.064  1.00 51.38           N  
ATOM    578  CA  THR    75      92.490  96.288  56.472  1.00 51.08           C  
ATOM    579  C   THR    75      91.080  96.514  57.000  1.00 50.36           C  
ATOM    580  O   THR    75      90.183  95.709  56.767  1.00 50.15           O  
ATOM    581  CB  THR    75      93.368  95.617  57.536  1.00 51.62           C  
ATOM    582  OG1 THR    75      93.303  94.202  57.378  1.00 56.50           O  
ATOM    583  CG2 THR    75      92.908  95.984  58.939  1.00 50.68           C  
ATOM    584  N   SER    76      90.890  97.620  57.707  1.00 49.57           N  
ATOM    585  CA  SER    76      89.591  97.951  58.269  1.00 50.05           C  
ATOM    586  C   SER    76      88.694  98.509  57.170  1.00 50.81           C  
ATOM    587  O   SER    76      87.514  98.147  57.047  1.00 51.77           O  
ATOM    588  CB  SER    76      89.766  98.980  59.379  1.00 49.11           C  
ATOM    589  OG  SER    76      90.621  98.472  60.377  1.00 47.99           O  
ATOM    590  N   LEU    77      89.285  99.391  56.369  1.00 51.13           N  
ATOM    591  CA  LEU    77      88.623 100.039  55.248  1.00 51.45           C  
ATOM    592  C   LEU    77      88.006  99.002  54.297  1.00 51.62           C  
ATOM    593  O   LEU    77      86.872  99.147  53.844  1.00 51.07           O  
ATOM    594  CB  LEU    77      89.648 100.869  54.485  1.00 50.84           C  
ATOM    595  CG  LEU    77      89.208 102.173  53.837  1.00 52.69           C  
ATOM    596  CD1 LEU    77      90.141 102.457  52.676  1.00 53.42           C  
ATOM    597  CD2 LEU    77      87.781 102.084  53.355  1.00 53.75           C  
ATOM    598  N   LYS    78      88.761  97.957  53.991  1.00 52.16           N  
ATOM    599  CA  LYS    78      88.273  96.937  53.086  1.00 53.11           C  
ATOM    600  C   LYS    78      87.217  96.080  53.748  1.00 54.20           C  
ATOM    601  O   LYS    78      86.285  95.608  53.099  1.00 55.45           O  
ATOM    602  CB  LYS    78      89.437  96.079  52.584  1.00 52.56           C  
ATOM    603  CG  LYS    78      90.489  96.915  51.878  1.00 55.09           C  
ATOM    604  CD  LYS    78      91.324  96.128  50.892  1.00 58.22           C  
ATOM    605  CE  LYS    78      92.303  95.206  51.568  1.00 61.29           C  
ATOM    606  NZ  LYS    78      93.063  94.473  50.536  1.00 63.27           N  
ATOM    607  N   LEU    79      87.353  95.893  55.050  1.00 54.20           N  
ATOM    608  CA  LEU    79      86.397  95.088  55.777  1.00 53.58           C  
ATOM    609  C   LEU    79      85.031  95.748  55.653  1.00 53.51           C  
ATOM    610  O   LEU    79      84.059  95.111  55.263  1.00 53.13           O  
ATOM    611  CB  LEU    79      86.831  94.994  57.237  1.00 54.15           C  
ATOM    612  CG  LEU    79      86.457  93.736  58.017  1.00 55.50           C  
ATOM    613  CD1 LEU    79      86.571  92.523  57.124  1.00 57.45           C  
ATOM    614  CD2 LEU    79      87.383  93.600  59.221  1.00 55.73           C  
ATOM    615  N   GLY    80      84.972  97.039  55.959  1.00 53.82           N  
ATOM    616  CA  GLY    80      83.714  97.756  55.872  1.00 55.07           C  
ATOM    617  C   GLY    80      83.179  97.908  54.458  1.00 56.82           C  
ATOM    618  O   GLY    80      81.963  97.893  54.230  1.00 57.02           O  
ATOM    619  N   LEU    81      84.079  98.054  53.492  1.00 57.52           N  
ATOM    620  CA  LEU    81      83.648  98.220  52.116  1.00 57.35           C  
ATOM    621  C   LEU    81      82.893  97.011  51.573  1.00 57.82           C  
ATOM    622  O   LEU    81      82.142  97.142  50.619  1.00 58.82           O  
ATOM    623  CB  LEU    81      84.837  98.521  51.216  1.00 57.13           C  
ATOM    624  CG  LEU    81      84.401  99.039  49.844  1.00 56.54           C  
ATOM    625  CD1 LEU    81      83.556 100.301  50.013  1.00 58.60           C  
ATOM    626  CD2 LEU    81      85.625  99.330  48.999  1.00 55.16           C  
ATOM    627  N   ARG    82      83.091  95.837  52.163  1.00 58.01           N  
ATOM    628  CA  ARG    82      82.385  94.651  51.696  1.00 59.28           C  
ATOM    629  C   ARG    82      80.888  94.822  51.944  1.00 60.19           C  
ATOM    630  O   ARG    82      80.047  94.463  51.117  1.00 61.66           O  
ATOM    631  CB  ARG    82      82.862  93.400  52.440  1.00 58.88           C  
ATOM    632  CG  ARG    82      84.253  92.902  52.084  1.00 60.07           C  
ATOM    633  CD  ARG    82      84.664  91.815  53.061  1.00 64.01           C  
ATOM    634  NE  ARG    82      84.689  90.481  52.475  1.00 69.56           N  
ATOM    635  CZ  ARG    82      84.530  89.352  53.168  1.00 74.97           C  
ATOM    636  NH1 ARG    82      84.322  89.382  54.488  1.00 78.67           N  
ATOM    637  NH2 ARG    82      84.583  88.183  52.542  1.00 78.06           N  
ATOM    638  N   PHE    83      80.570  95.383  53.098  1.00 60.58           N  
ATOM    639  CA  PHE    83      79.201  95.589  53.510  1.00 61.91           C  
ATOM    640  C   PHE    83      78.471  96.590  52.596  1.00 62.30           C  
ATOM    641  O   PHE    83      77.239  96.590  52.521  1.00 62.65           O  
ATOM    642  CB  PHE    83      79.230  96.029  54.984  1.00 62.22           C  
ATOM    643  CG  PHE    83      77.879  96.200  55.616  1.00 66.17           C  
ATOM    644  CD1 PHE    83      77.191  97.415  55.517  1.00 71.26           C  
ATOM    645  CD2 PHE    83      77.296  95.162  56.333  1.00 69.17           C  
ATOM    646  CE1 PHE    83      75.936  97.597  56.129  1.00 71.89           C  
ATOM    647  CE2 PHE    83      76.044  95.337  56.947  1.00 72.59           C  
ATOM    648  CZ  PHE    83      75.363  96.561  56.841  1.00 71.44           C  
ATOM    649  N   PHE    84      79.223  97.416  51.874  1.00 62.51           N  
ATOM    650  CA  PHE    84      78.621  98.413  50.979  1.00 63.10           C  
ATOM    651  C   PHE    84      79.188  98.342  49.562  1.00 64.76           C  
ATOM    652  O   PHE    84      79.058  99.302  48.800  1.00 63.81           O  
ATOM    653  CB  PHE    84      78.899  99.832  51.485  1.00 62.18           C  
ATOM    654  CG  PHE    84      78.275 100.157  52.801  1.00 60.99           C  
ATOM    655  CD1 PHE    84      76.904 100.276  52.926  1.00 61.57           C  
ATOM    656  CD2 PHE    84      79.068 100.405  53.910  1.00 60.88           C  
ATOM    657  CE1 PHE    84      76.322 100.643  54.144  1.00 63.23           C  
ATOM    658  CE2 PHE    84      78.501 100.772  55.133  1.00 62.44           C  
ATOM    659  CZ  PHE    84      77.126 100.895  55.250  1.00 62.62           C  
ATOM    660  N   LYS    85      79.813  97.226  49.197  1.00 66.95           N  
ATOM    661  CA  LYS    85      80.441  97.130  47.882  1.00 69.13           C  
ATOM    662  C   LYS    85      79.574  97.522  46.688  1.00 70.31           C  
ATOM    663  O   LYS    85      80.069  98.143  45.749  1.00 71.72           O  
ATOM    664  CB  LYS    85      81.027  95.731  47.663  1.00 69.33           C  
ATOM    665  CG  LYS    85      80.041  94.693  47.173  1.00 72.38           C  
ATOM    666  CD  LYS    85      80.705  93.313  47.006  1.00 77.93           C  
ATOM    667  CE  LYS    85      81.890  93.326  46.034  1.00 79.05           C  
ATOM    668  NZ  LYS    85      82.423  91.957  45.746  1.00 80.80           N  
ATOM    669  N   ASP    86      78.290  97.185  46.710  1.00 70.75           N  
ATOM    670  CA  ASP    86      77.429  97.530  45.584  1.00 70.88           C  
ATOM    671  C   ASP    86      76.709  98.877  45.741  1.00 68.94           C  
ATOM    672  O   ASP    86      75.839  99.211  44.940  1.00 70.04           O  
ATOM    673  CB  ASP    86      76.405  96.415  45.354  1.00 72.35           C  
ATOM    674  CG  ASP    86      75.363  96.347  46.458  1.00 79.03           C  
ATOM    675  OD1 ASP    86      75.761  96.439  47.652  1.00 84.31           O  
ATOM    676  OD2 ASP    86      74.155  96.201  46.130  1.00 84.74           O  
ATOM    677  N   TYR    87      77.053  99.644  46.772  1.00 66.71           N  
ATOM    678  CA  TYR    87      76.431 100.956  46.985  1.00 64.20           C  
ATOM    679  C   TYR    87      77.049 101.957  46.031  1.00 64.05           C  
ATOM    680  O   TYR    87      78.094 101.699  45.440  1.00 64.34           O  
ATOM    681  CB  TYR    87      76.652 101.450  48.414  1.00 63.13           C  
ATOM    682  CG  TYR    87      75.656 100.939  49.422  1.00 59.15           C  
ATOM    683  CD1 TYR    87      75.514  99.576  49.662  1.00 54.93           C  
ATOM    684  CD2 TYR    87      74.858 101.828  50.142  1.00 56.10           C  
ATOM    685  CE1 TYR    87      74.593  99.106  50.605  1.00 53.69           C  
ATOM    686  CE2 TYR    87      73.935 101.380  51.080  1.00 54.90           C  
ATOM    687  CZ  TYR    87      73.805 100.017  51.311  1.00 55.64           C  
ATOM    688  OH  TYR    87      72.897  99.568  52.243  1.00 54.58           O  
ATOM    689  N   ASP    88      76.425 103.114  45.893  1.00 63.66           N  
ATOM    690  CA  ASP    88      76.956 104.114  44.983  1.00 64.27           C  
ATOM    691  C   ASP    88      78.246 104.726  45.519  1.00 63.88           C  
ATOM    692  O   ASP    88      79.174 105.003  44.759  1.00 64.49           O  
ATOM    693  CB  ASP    88      75.912 105.211  44.723  1.00 64.96           C  
ATOM    694  CG  ASP    88      74.598 104.650  44.172  1.00 66.85           C  
ATOM    695  OD1 ASP    88      74.657 103.802  43.253  1.00 66.84           O  
ATOM    696  OD2 ASP    88      73.515 105.060  44.654  1.00 69.17           O  
ATOM    697  N   ALA    89      78.302 104.927  46.831  1.00 62.91           N  
ATOM    698  CA  ALA    89      79.478 105.506  47.459  1.00 61.92           C  
ATOM    699  C   ALA    89      79.477 105.253  48.964  1.00 61.48           C  
ATOM    700  O   ALA    89      78.452 104.891  49.550  1.00 61.97           O  
ATOM    701  CB  ALA    89      79.522 107.005  47.184  1.00 61.21           C  
ATOM    702  N   VAL    90      80.636 105.432  49.588  1.00 60.01           N  
ATOM    703  CA  VAL    90      80.749 105.259  51.029  1.00 58.30           C  
ATOM    704  C   VAL    90      81.391 106.492  51.638  1.00 57.14           C  
ATOM    705  O   VAL    90      82.330 107.057  51.076  1.00 56.86           O  
ATOM    706  CB  VAL    90      81.620 104.030  51.415  1.00 58.42           C  
ATOM    707  CG1 VAL    90      80.921 102.750  51.026  1.00 59.19           C  
ATOM    708  CG2 VAL    90      82.986 104.127  50.750  1.00 56.69           C  
ATOM    709  N   LEU    91      80.869 106.918  52.779  1.00 55.61           N  
ATOM    710  CA  LEU    91      81.426 108.057  53.489  1.00 54.63           C  
ATOM    711  C   LEU    91      82.460 107.429  54.438  1.00 54.65           C  
ATOM    712  O   LEU    91      82.096 106.625  55.294  1.00 55.06           O  
ATOM    713  CB  LEU    91      80.334 108.748  54.298  1.00 53.78           C  
ATOM    714  CG  LEU    91      80.245 110.265  54.188  1.00 54.59           C  
ATOM    715  CD1 LEU    91      79.453 110.846  55.380  1.00 51.75           C  
ATOM    716  CD2 LEU    91      81.658 110.832  54.143  1.00 58.18           C  
ATOM    717  N   VAL    92      83.739 107.763  54.279  1.00 53.62           N  
ATOM    718  CA  VAL    92      84.768 107.187  55.140  1.00 52.79           C  
ATOM    719  C   VAL    92      85.057 108.091  56.320  1.00 52.56           C  
ATOM    720  O   VAL    92      85.872 109.001  56.217  1.00 53.69           O  
ATOM    721  CB  VAL    92      86.077 106.949  54.369  1.00 52.25           C  
ATOM    722  CG1 VAL    92      87.152 106.424  55.314  1.00 51.94           C  
ATOM    723  CG2 VAL    92      85.837 105.951  53.246  1.00 54.42           C  
ATOM    724  N   ALA    93      84.405 107.823  57.447  1.00 51.95           N  
ATOM    725  CA  ALA    93      84.571 108.639  58.646  1.00 51.84           C  
ATOM    726  C   ALA    93      85.574 108.062  59.635  1.00 52.15           C  
ATOM    727  O   ALA    93      85.803 106.856  59.683  1.00 52.28           O  
ATOM    728  CB  ALA    93      83.204 108.855  59.344  1.00 50.81           C  
ATOM    729  N   LEU    94      86.164 108.954  60.425  1.00 52.06           N  
ATOM    730  CA  LEU    94      87.140 108.589  61.436  1.00 52.16           C  
ATOM    731  C   LEU    94      86.519 108.758  62.808  1.00 52.91           C  
ATOM    732  O   LEU    94      85.943 109.803  63.096  1.00 52.88           O  
ATOM    733  CB  LEU    94      88.367 109.480  61.305  1.00 52.24           C  
ATOM    734  CG  LEU    94      89.047 109.292  59.954  1.00 51.55           C  
ATOM    735  CD1 LEU    94      89.981 110.437  59.677  1.00 52.65           C  
ATOM    736  CD2 LEU    94      89.772 107.968  59.958  1.00 50.12           C  
ATOM    737  N   GLY    95      86.645 107.719  63.639  1.00 52.92           N  
ATOM    738  CA  GLY    95      86.084 107.727  64.978  1.00 52.70           C  
ATOM    739  C   GLY    95      86.536 108.894  65.817  1.00 53.74           C  
ATOM    740  O   GLY    95      85.732 109.539  66.479  1.00 54.62           O  
ATOM    741  N   ASP    96      87.828 109.186  65.784  1.00 54.69           N  
ATOM    742  CA  ASP    96      88.369 110.287  66.567  1.00 55.37           C  
ATOM    743  C   ASP    96      88.098 111.692  66.000  1.00 56.11           C  
ATOM    744  O   ASP    96      88.752 112.658  66.391  1.00 57.21           O  
ATOM    745  CB  ASP    96      89.872 110.088  66.759  1.00 54.95           C  
ATOM    746  CG  ASP    96      90.627 110.138  65.458  1.00 58.10           C  
ATOM    747  OD1 ASP    96      89.983 110.169  64.388  1.00 60.60           O  
ATOM    748  OD2 ASP    96      91.872 110.139  65.500  1.00 63.56           O  
ATOM    749  N   MET    97      87.150 111.821  65.079  1.00 56.89           N  
ATOM    750  CA  MET    97      86.831 113.139  64.534  1.00 57.64           C  
ATOM    751  C   MET    97      85.379 113.487  64.838  1.00 57.73           C  
ATOM    752  O   MET    97      84.516 113.390  63.973  1.00 58.84           O  
ATOM    753  CB  MET    97      87.064 113.174  63.031  1.00 57.82           C  
ATOM    754  CG  MET    97      88.514 113.141  62.638  1.00 63.08           C  
ATOM    755  SD  MET    97      88.775 113.529  60.755  1.00 81.64          SE  
ATOM    756  CE  MET    97      90.719 113.549  60.713  1.00 79.03           C  
ATOM    757  N   PRO    98      85.097 113.909  66.080  1.00 57.33           N  
ATOM    758  CA  PRO    98      83.743 114.262  66.494  1.00 57.02           C  
ATOM    759  C   PRO    98      83.397 115.741  66.335  1.00 57.95           C  
ATOM    760  O   PRO    98      82.394 116.214  66.887  1.00 57.74           O  
ATOM    761  CB  PRO    98      83.740 113.840  67.950  1.00 56.71           C  
ATOM    762  CG  PRO    98      85.092 114.320  68.391  1.00 56.30           C  
ATOM    763  CD  PRO    98      86.005 113.905  67.244  1.00 57.38           C  
ATOM    764  N   PHE    99      84.215 116.484  65.596  1.00 58.99           N  
ATOM    765  CA  PHE    99      83.935 117.908  65.444  1.00 59.96           C  
ATOM    766  C   PHE    99      83.334 118.255  64.096  1.00 60.17           C  
ATOM    767  O   PHE    99      82.845 119.361  63.902  1.00 59.52           O  
ATOM    768  CB  PHE    99      85.192 118.738  65.731  1.00 60.42           C  
ATOM    769  CG  PHE    99      85.781 118.474  67.093  1.00 61.47           C  
ATOM    770  CD1 PHE    99      85.007 118.635  68.241  1.00 61.18           C  
ATOM    771  CD2 PHE    99      87.086 117.994  67.223  1.00 60.65           C  
ATOM    772  CE1 PHE    99      85.520 118.317  69.497  1.00 60.89           C  
ATOM    773  CE2 PHE    99      87.604 117.675  68.471  1.00 61.94           C  
ATOM    774  CZ  PHE    99      86.820 117.834  69.613  1.00 60.01           C  
ATOM    775  N   VAL   100      83.376 117.315  63.158  1.00 60.42           N  
ATOM    776  CA  VAL   100      82.751 117.542  61.868  1.00 59.65           C  
ATOM    777  C   VAL   100      81.269 117.660  62.251  1.00 59.60           C  
ATOM    778  O   VAL   100      80.797 116.968  63.151  1.00 58.98           O  
ATOM    779  CB  VAL   100      82.999 116.351  60.924  1.00 59.22           C  
ATOM    780  CG1 VAL   100      83.000 115.083  61.705  1.00 59.86           C  
ATOM    781  CG2 VAL   100      81.933 116.284  59.864  1.00 59.54           C  
ATOM    782  N   THR   101      80.538 118.551  61.594  1.00 60.41           N  
ATOM    783  CA  THR   101      79.130 118.766  61.923  1.00 60.04           C  
ATOM    784  C   THR   101      78.182 118.093  60.952  1.00 61.20           C  
ATOM    785  O   THR   101      78.576 117.754  59.839  1.00 61.16           O  
ATOM    786  CB  THR   101      78.803 120.244  61.913  1.00 59.27           C  
ATOM    787  OG1 THR   101      78.981 120.739  60.584  1.00 57.79           O  
ATOM    788  CG2 THR   101      79.711 120.997  62.861  1.00 56.24           C  
ATOM    789  N   LYS   102      76.933 117.903  61.376  1.00 62.74           N  
ATOM    790  CA  LYS   102      75.934 117.286  60.509  1.00 64.81           C  
ATOM    791  C   LYS   102      75.879 118.093  59.232  1.00 65.39           C  
ATOM    792  O   LYS   102      75.819 117.541  58.136  1.00 64.62           O  
ATOM    793  CB  LYS   102      74.548 117.289  61.156  1.00 65.69           C  
ATOM    794  CG  LYS   102      74.235 116.061  61.996  1.00 69.63           C  
ATOM    795  CD  LYS   102      72.739 115.824  62.059  1.00 74.55           C  
ATOM    796  CE  LYS   102      72.405 114.639  62.937  1.00 77.99           C  
ATOM    797  NZ  LYS   102      72.889 114.863  64.326  1.00 81.50           N  
ATOM    798  N   GLU   103      75.902 119.412  59.391  1.00 66.62           N  
ATOM    799  CA  GLU   103      75.878 120.323  58.257  1.00 68.07           C  
ATOM    800  C   GLU   103      76.974 119.993  57.244  1.00 67.62           C  
ATOM    801  O   GLU   103      76.724 119.985  56.037  1.00 67.46           O  
ATOM    802  CB  GLU   103      76.039 121.763  58.744  1.00 69.67           C  
ATOM    803  CG  GLU   103      74.842 122.277  59.505  1.00 75.46           C  
ATOM    804  CD  GLU   103      73.535 122.020  58.757  1.00 83.50           C  
ATOM    805  OE1 GLU   103      73.498 122.265  57.528  1.00 86.84           O  
ATOM    806  OE2 GLU   103      72.549 121.576  59.396  1.00 86.31           O  
ATOM    807  N   ASP   104      78.185 119.731  57.736  1.00 67.07           N  
ATOM    808  CA  ASP   104      79.305 119.393  56.867  1.00 66.63           C  
ATOM    809  C   ASP   104      78.984 118.133  56.083  1.00 66.12           C  
ATOM    810  O   ASP   104      79.264 118.044  54.886  1.00 65.91           O  
ATOM    811  CB  ASP   104      80.577 119.143  57.679  1.00 66.99           C  
ATOM    812  CG  ASP   104      81.038 120.362  58.440  1.00 68.35           C  
ATOM    813  OD1 ASP   104      80.997 121.463  57.863  1.00 72.59           O  
ATOM    814  OD2 ASP   104      81.458 120.220  59.608  1.00 65.48           O  
ATOM    815  N   VAL   105      78.405 117.150  56.761  1.00 65.88           N  
ATOM    816  CA  VAL   105      78.070 115.899  56.099  1.00 66.65           C  
ATOM    817  C   VAL   105      76.964 116.093  55.070  1.00 67.88           C  
ATOM    818  O   VAL   105      76.948 115.429  54.025  1.00 68.40           O  
ATOM    819  CB  VAL   105      77.632 114.819  57.111  1.00 66.21           C  
ATOM    820  CG1 VAL   105      77.236 113.530  56.369  1.00 63.28           C  
ATOM    821  CG2 VAL   105      78.767 114.554  58.092  1.00 64.83           C  
ATOM    822  N   ASN   106      76.046 117.006  55.372  1.00 68.52           N  
ATOM    823  CA  ASN   106      74.945 117.299  54.475  1.00 69.21           C  
ATOM    824  C   ASN   106      75.521 117.899  53.192  1.00 69.46           C  
ATOM    825  O   ASN   106      75.156 117.491  52.084  1.00 69.79           O  
ATOM    826  CB  ASN   106      73.980 118.278  55.146  1.00 70.36           C  
ATOM    827  CG  ASN   106      72.590 118.252  54.523  1.00 73.18           C  
ATOM    828  OD1 ASN   106      71.923 117.213  54.511  1.00 75.38           O  
ATOM    829  ND2 ASN   106      72.146 119.399  54.003  1.00 78.25           N  
ATOM    830  N   LYS   107      76.434 118.859  53.346  1.00 69.38           N  
ATOM    831  CA  LYS   107      77.072 119.498  52.198  1.00 69.64           C  
ATOM    832  C   LYS   107      77.833 118.484  51.361  1.00 69.90           C  
ATOM    833  O   LYS   107      77.671 118.426  50.147  1.00 70.92           O  
ATOM    834  CB  LYS   107      78.064 120.569  52.643  1.00 69.73           C  
ATOM    835  CG  LYS   107      77.466 121.815  53.240  1.00 70.89           C  
ATOM    836  CD  LYS   107      78.581 122.754  53.661  1.00 72.41           C  
ATOM    837  CE  LYS   107      78.020 123.994  54.287  1.00 75.34           C  
ATOM    838  NZ  LYS   107      77.084 123.633  55.384  1.00 78.79           N  
ATOM    839  N   ILE   108      78.674 117.694  52.018  1.00 69.99           N  
ATOM    840  CA  ILE   108      79.475 116.690  51.326  1.00 70.00           C  
ATOM    841  C   ILE   108      78.630 115.750  50.488  1.00 70.52           C  
ATOM    842  O   ILE   108      78.946 115.489  49.322  1.00 69.75           O  
ATOM    843  CB  ILE   108      80.301 115.837  52.323  1.00 69.97           C  
ATOM    844  CG1 ILE   108      81.223 116.744  53.141  1.00 68.99           C  
ATOM    845  CG2 ILE   108      81.121 114.792  51.562  1.00 67.40           C  
ATOM    846  CD1 ILE   108      82.050 116.021  54.165  1.00 68.64           C  
ATOM    847  N   ILE   109      77.559 115.235  51.084  1.00 71.82           N  
ATOM    848  CA  ILE   109      76.694 114.312  50.372  1.00 73.40           C  
ATOM    849  C   ILE   109      75.963 115.030  49.244  1.00 74.95           C  
ATOM    850  O   ILE   109      75.712 114.444  48.188  1.00 74.87           O  
ATOM    851  CB  ILE   109      75.669 113.648  51.317  1.00 72.92           C  
ATOM    852  CG1 ILE   109      76.396 112.902  52.438  1.00 72.32           C  
ATOM    853  CG2 ILE   109      74.815 112.658  50.543  1.00 73.00           C  
ATOM    854  CD1 ILE   109      75.471 112.152  53.374  1.00 72.12           C  
ATOM    855  N   ASN   110      75.640 116.304  49.454  1.00 76.62           N  
ATOM    856  CA  ASN   110      74.943 117.074  48.427  1.00 77.75           C  
ATOM    857  C   ASN   110      75.827 117.519  47.265  1.00 77.54           C  
ATOM    858  O   ASN   110      75.317 117.937  46.227  1.00 78.41           O  
ATOM    859  CB  ASN   110      74.271 118.306  49.037  1.00 78.60           C  
ATOM    860  CG  ASN   110      73.054 117.952  49.879  1.00 81.57           C  
ATOM    861  OD1 ASN   110      72.228 117.114  49.494  1.00 82.58           O  
ATOM    862  ND2 ASN   110      72.930 118.603  51.031  1.00 85.45           N  
ATOM    863  N   THR   111      77.142 117.424  47.427  1.00 76.50           N  
ATOM    864  CA  THR   111      78.069 117.836  46.379  1.00 75.76           C  
ATOM    865  C   THR   111      78.380 116.689  45.426  1.00 76.37           C  
ATOM    866  O   THR   111      78.986 116.884  44.377  1.00 76.43           O  
ATOM    867  CB  THR   111      79.388 118.337  46.994  1.00 75.39           C  
ATOM    868  OG1 THR   111      79.100 119.332  47.978  1.00 74.42           O  
ATOM    869  CG2 THR   111      80.290 118.936  45.937  1.00 75.41           C  
ATOM    870  N   PHE   112      77.945 115.491  45.788  1.00 77.34           N  
ATOM    871  CA  PHE   112      78.210 114.306  44.982  1.00 78.11           C  
ATOM    872  C   PHE   112      77.405 114.191  43.689  1.00 80.28           C  
ATOM    873  O   PHE   112      76.184 114.050  43.716  1.00 80.80           O  
ATOM    874  CB  PHE   112      77.994 113.060  45.836  1.00 76.72           C  
ATOM    875  CG  PHE   112      78.192 111.781  45.096  1.00 73.51           C  
ATOM    876  CD1 PHE   112      79.335 111.578  44.333  1.00 70.01           C  
ATOM    877  CD2 PHE   112      77.249 110.763  45.182  1.00 71.66           C  
ATOM    878  CE1 PHE   112      79.540 110.378  43.663  1.00 69.79           C  
ATOM    879  CE2 PHE   112      77.443 109.558  44.517  1.00 69.27           C  
ATOM    880  CZ  PHE   112      78.596 109.366  43.755  1.00 69.71           C  
ATOM    881  N   LYS   113      78.103 114.242  42.557  1.00 82.83           N  
ATOM    882  CA  LYS   113      77.463 114.128  41.250  1.00 85.02           C  
ATOM    883  C   LYS   113      78.089 112.966  40.486  1.00 86.49           C  
ATOM    884  O   LYS   113      79.163 112.479  40.850  1.00 86.93           O  
ATOM    885  CB  LYS   113      77.649 115.415  40.446  1.00 84.96           C  
ATOM    886  CG  LYS   113      77.320 116.675  41.213  1.00 85.92           C  
ATOM    887  CD  LYS   113      75.900 116.661  41.722  1.00 88.01           C  
ATOM    888  CE  LYS   113      75.673 117.838  42.646  1.00 90.37           C  
ATOM    889  NZ  LYS   113      74.331 117.785  43.276  1.00 92.40           N  
ATOM    890  N   PRO   114      77.430 112.511  39.406  1.00 87.82           N  
ATOM    891  CA  PRO   114      77.936 111.395  38.593  1.00 88.26           C  
ATOM    892  C   PRO   114      79.341 111.625  38.020  1.00 88.54           C  
ATOM    893  O   PRO   114      80.075 110.672  37.744  1.00 88.72           O  
ATOM    894  CB  PRO   114      76.876 111.262  37.495  1.00 88.45           C  
ATOM    895  CG  PRO   114      75.612 111.728  38.184  1.00 88.65           C  
ATOM    896  CD  PRO   114      76.107 112.954  38.921  1.00 87.87           C  
ATOM    897  N   ASN   115      79.708 112.891  37.838  1.00 88.27           N  
ATOM    898  CA  ASN   115      81.017 113.234  37.299  1.00 87.89           C  
ATOM    899  C   ASN   115      82.099 113.053  38.355  1.00 87.58           C  
ATOM    900  O   ASN   115      83.263 112.827  38.024  1.00 88.00           O  
ATOM    901  CB  ASN   115      81.011 114.676  36.803  1.00 87.90           C  
ATOM    902  N   CYS   116      81.701 113.145  39.623  1.00 86.76           N  
ATOM    903  CA  CYS   116      82.625 113.026  40.747  1.00 86.00           C  
ATOM    904  C   CYS   116      83.114 111.618  41.050  1.00 84.42           C  
ATOM    905  O   CYS   116      82.317 110.697  41.241  1.00 84.56           O  
ATOM    906  CB  CYS   116      81.992 113.593  42.023  1.00 86.32           C  
ATOM    907  SG  CYS   116      81.339 115.287  41.872  1.00 90.88           S  
ATOM    908  N   LYS   117      84.436 111.473  41.101  1.00 82.59           N  
ATOM    909  CA  LYS   117      85.085 110.208  41.429  1.00 80.48           C  
ATOM    910  C   LYS   117      85.085 110.109  42.955  1.00 78.41           C  
ATOM    911  O   LYS   117      84.997 109.026  43.536  1.00 77.64           O  
ATOM    912  CB  LYS   117      86.527 110.211  40.926  1.00 81.04           C  
ATOM    913  CG  LYS   117      86.693 109.859  39.469  1.00 83.13           C  
ATOM    914  CD  LYS   117      86.463 108.377  39.259  1.00 87.67           C  
ATOM    915  CE  LYS   117      86.861 107.948  37.863  1.00 91.25           C  
ATOM    916  NZ  LYS   117      86.017 108.607  36.834  1.00 94.86           N  
ATOM    917  N   ALA   118      85.181 111.268  43.592  1.00 75.75           N  
ATOM    918  CA  ALA   118      85.192 111.348  45.036  1.00 73.60           C  
ATOM    919  C   ALA   118      84.942 112.785  45.442  1.00 72.38           C  
ATOM    920  O   ALA   118      85.389 113.704  44.772  1.00 73.59           O  
ATOM    921  CB  ALA   118      86.529 110.890  45.564  1.00 74.01           C  
ATOM    922  N   VAL   119      84.210 112.976  46.530  1.00 70.08           N  
ATOM    923  CA  VAL   119      83.930 114.309  47.032  1.00 68.06           C  
ATOM    924  C   VAL   119      84.834 114.478  48.231  1.00 67.27           C  
ATOM    925  O   VAL   119      84.939 113.568  49.052  1.00 67.93           O  
ATOM    926  CB  VAL   119      82.487 114.445  47.513  1.00 68.04           C  
ATOM    927  CG1 VAL   119      82.307 115.773  48.190  1.00 66.10           C  
ATOM    928  CG2 VAL   119      81.532 114.315  46.355  1.00 68.91           C  
ATOM    929  N   ILE   120      85.481 115.632  48.348  1.00 65.82           N  
ATOM    930  CA  ILE   120      86.382 115.866  49.468  1.00 64.51           C  
ATOM    931  C   ILE   120      86.098 117.157  50.210  1.00 65.04           C  
ATOM    932  O   ILE   120      86.161 118.246  49.639  1.00 64.40           O  
ATOM    933  CB  ILE   120      87.863 115.901  49.012  1.00 63.92           C  
ATOM    934  CG1 ILE   120      88.264 114.544  48.425  1.00 63.65           C  
ATOM    935  CG2 ILE   120      88.763 116.263  50.187  1.00 61.60           C  
ATOM    936  CD1 ILE   120      89.684 114.494  47.896  1.00 60.61           C  
ATOM    937  N   PRO   121      85.773 117.059  51.505  1.00 65.27           N  
ATOM    938  CA  PRO   121      85.510 118.305  52.230  1.00 65.83           C  
ATOM    939  C   PRO   121      86.783 119.147  52.290  1.00 66.58           C  
ATOM    940  O   PRO   121      87.901 118.618  52.304  1.00 65.85           O  
ATOM    941  CB  PRO   121      85.050 117.820  53.605  1.00 65.49           C  
ATOM    942  CG  PRO   121      85.761 116.510  53.754  1.00 64.49           C  
ATOM    943  CD  PRO   121      85.607 115.889  52.382  1.00 64.85           C  
ATOM    944  N   THR   122      86.595 120.461  52.312  1.00 67.79           N  
ATOM    945  CA  THR   122      87.704 121.402  52.356  1.00 69.21           C  
ATOM    946  C   THR   122      87.402 122.530  53.319  1.00 69.43           C  
ATOM    947  O   THR   122      86.245 122.846  53.592  1.00 69.17           O  
ATOM    948  CB  THR   122      87.962 122.032  50.975  1.00 69.52           C  
ATOM    949  OG1 THR   122      88.161 121.001  50.000  1.00 71.78           O  
ATOM    950  CG2 THR   122      89.194 122.902  51.018  1.00 70.92           C  
ATOM    951  N   HIS   123      88.457 123.134  53.839  1.00 70.60           N  
ATOM    952  CA  HIS   123      88.293 124.250  54.742  1.00 72.73           C  
ATOM    953  C   HIS   123      89.555 125.079  54.795  1.00 74.60           C  
ATOM    954  O   HIS   123      90.575 124.650  55.336  1.00 75.01           O  
ATOM    955  CB  HIS   123      87.915 123.777  56.132  1.00 72.08           C  
ATOM    956  CG  HIS   123      87.799 124.884  57.127  1.00 72.75           C  
ATOM    957  ND1 HIS   123      88.891 125.434  57.756  1.00 74.49           N  
ATOM    958  CD2 HIS   123      86.715 125.527  57.625  1.00 73.58           C  
ATOM    959  CE1 HIS   123      88.487 126.361  58.608  1.00 74.84           C  
ATOM    960  NE2 HIS   123      87.170 126.436  58.547  1.00 73.86           N  
ATOM    961  N   LYS   124      89.463 126.272  54.207  1.00 76.62           N  
ATOM    962  CA  LYS   124      90.561 127.221  54.151  1.00 78.11           C  
ATOM    963  C   LYS   124      91.809 126.634  53.499  1.00 78.93           C  
ATOM    964  O   LYS   124      92.879 126.549  54.113  1.00 79.34           O  
ATOM    965  CB  LYS   124      90.867 127.743  55.553  1.00 78.57           C  
ATOM    966  CG  LYS   124      89.752 128.605  56.124  1.00 80.40           C  
ATOM    967  CD  LYS   124      90.060 129.065  57.544  1.00 83.67           C  
ATOM    968  CE  LYS   124      88.898 129.847  58.140  1.00 84.87           C  
ATOM    969  NZ  LYS   124      89.052 130.018  59.615  1.00 87.62           N  
ATOM    970  N   GLY   125      91.643 126.212  52.248  1.00 79.59           N  
ATOM    971  CA  GLY   125      92.753 125.675  51.485  1.00 80.41           C  
ATOM    972  C   GLY   125      93.002 124.184  51.559  1.00 81.19           C  
ATOM    973  O   GLY   125      93.167 123.532  50.525  1.00 81.94           O  
ATOM    974  N   GLU   126      93.037 123.637  52.771  1.00 81.23           N  
ATOM    975  CA  GLU   126      93.299 122.208  52.949  1.00 80.96           C  
ATOM    976  C   GLU   126      92.057 121.321  52.975  1.00 79.32           C  
ATOM    977  O   GLU   126      90.977 121.743  53.408  1.00 79.79           O  
ATOM    978  CB  GLU   126      94.115 121.994  54.225  1.00 81.55           C  
ATOM    979  CG  GLU   126      93.533 122.678  55.439  1.00 84.47           C  
ATOM    980  CD  GLU   126      94.508 122.726  56.598  1.00 89.37           C  
ATOM    981  OE1 GLU   126      94.954 121.646  57.051  1.00 90.89           O  
ATOM    982  OE2 GLU   126      94.831 123.845  57.058  1.00 91.20           O  
ATOM    983  N   ARG   127      92.225 120.093  52.489  1.00 76.70           N  
ATOM    984  CA  ARG   127      91.141 119.121  52.467  1.00 74.71           C  
ATOM    985  C   ARG   127      91.155 118.253  53.731  1.00 72.90           C  
ATOM    986  O   ARG   127      92.216 117.877  54.233  1.00 72.41           O  
ATOM    987  CB  ARG   127      91.232 118.245  51.211  1.00 74.97           C  
ATOM    988  CG  ARG   127      92.639 117.903  50.754  1.00 75.13           C  
ATOM    989  CD  ARG   127      92.898 118.419  49.339  1.00 76.10           C  
ATOM    990  NE  ARG   127      93.050 117.355  48.344  1.00 77.77           N  
ATOM    991  CZ  ARG   127      93.366 117.569  47.065  1.00 79.80           C  
ATOM    992  NH1 ARG   127      93.561 118.811  46.627  1.00 80.34           N  
ATOM    993  NH2 ARG   127      93.501 116.548  46.220  1.00 78.44           N  
ATOM    994  N   GLY   128      89.963 117.955  54.246  1.00 70.72           N  
ATOM    995  CA  GLY   128      89.845 117.150  55.450  1.00 66.93           C  
ATOM    996  C   GLY   128      88.973 115.917  55.308  1.00 64.25           C  
ATOM    997  O   GLY   128      88.916 115.298  54.250  1.00 64.67           O  
ATOM    998  N   ASN   129      88.294 115.559  56.390  1.00 61.56           N  
ATOM    999  CA  ASN   129      87.428 114.384  56.402  1.00 58.87           C  
ATOM   1000  C   ASN   129      86.078 114.722  57.020  1.00 57.79           C  
ATOM   1001  O   ASN   129      85.945 115.703  57.753  1.00 57.31           O  
ATOM   1002  CB  ASN   129      88.093 113.260  57.189  1.00 58.60           C  
ATOM   1003  CG  ASN   129      89.402 112.817  56.574  1.00 57.95           C  
ATOM   1004  OD1 ASN   129      89.422 112.151  55.537  1.00 56.78           O  
ATOM   1005  ND2 ASN   129      90.508 113.198  57.202  1.00 56.02           N  
ATOM   1006  N   PRO   130      85.071 113.869  56.797  1.00 57.42           N  
ATOM   1007  CA  PRO   130      85.104 112.632  56.014  1.00 56.93           C  
ATOM   1008  C   PRO   130      85.084 112.800  54.507  1.00 57.84           C  
ATOM   1009  O   PRO   130      84.498 113.745  53.983  1.00 58.47           O  
ATOM   1010  CB  PRO   130      83.875 111.898  56.512  1.00 56.26           C  
ATOM   1011  CG  PRO   130      82.909 113.030  56.684  1.00 57.24           C  
ATOM   1012  CD  PRO   130      83.743 114.066  57.403  1.00 56.49           C  
ATOM   1013  N   VAL   131      85.714 111.852  53.822  1.00 58.00           N  
ATOM   1014  CA  VAL   131      85.790 111.834  52.371  1.00 57.97           C  
ATOM   1015  C   VAL   131      84.782 110.849  51.776  1.00 58.42           C  
ATOM   1016  O   VAL   131      84.677 109.704  52.234  1.00 58.77           O  
ATOM   1017  CB  VAL   131      87.204 111.441  51.917  1.00 57.59           C  
ATOM   1018  CG1 VAL   131      87.198 111.014  50.476  1.00 59.19           C  
ATOM   1019  CG2 VAL   131      88.124 112.611  52.088  1.00 58.16           C  
ATOM   1020  N   LEU   132      84.055 111.293  50.750  1.00 58.08           N  
ATOM   1021  CA  LEU   132      83.058 110.449  50.092  1.00 57.65           C  
ATOM   1022  C   LEU   132      83.647 109.779  48.851  1.00 57.67           C  
ATOM   1023  O   LEU   132      83.900 110.443  47.856  1.00 59.54           O  
ATOM   1024  CB  LEU   132      81.833 111.293  49.717  1.00 57.41           C  
ATOM   1025  CG  LEU   132      80.631 110.589  49.074  1.00 58.34           C  
ATOM   1026  CD1 LEU   132      80.298 109.336  49.842  1.00 61.60           C  
ATOM   1027  CD2 LEU   132      79.430 111.512  49.063  1.00 55.91           C  
ATOM   1028  N   ILE   133      83.867 108.468  48.909  1.00 56.74           N  
ATOM   1029  CA  ILE   133      84.448 107.730  47.786  1.00 55.35           C  
ATOM   1030  C   ILE   133      83.375 106.967  47.010  1.00 55.07           C  
ATOM   1031  O   ILE   133      82.522 106.298  47.612  1.00 56.48           O  
ATOM   1032  CB  ILE   133      85.510 106.710  48.265  1.00 55.20           C  
ATOM   1033  CG1 ILE   133      86.601 107.417  49.071  1.00 56.29           C  
ATOM   1034  CG2 ILE   133      86.114 105.996  47.063  1.00 55.79           C  
ATOM   1035  CD1 ILE   133      87.725 106.513  49.499  1.00 57.86           C  
ATOM   1036  N   SER   134      83.443 107.040  45.679  1.00 52.85           N  
ATOM   1037  CA  SER   134      82.458 106.394  44.805  1.00 51.80           C  
ATOM   1038  C   SER   134      82.815 104.995  44.295  1.00 52.90           C  
ATOM   1039  O   SER   134      83.985 104.657  44.136  1.00 53.54           O  
ATOM   1040  CB  SER   134      82.181 107.294  43.602  1.00 51.85           C  
ATOM   1041  OG  SER   134      83.293 107.298  42.722  1.00 47.09           O  
ATOM   1042  N   LYS   135      81.789 104.200  44.007  1.00 55.28           N  
ATOM   1043  CA  LYS   135      81.978 102.836  43.526  1.00 57.82           C  
ATOM   1044  C   LYS   135      83.063 102.729  42.459  1.00 59.79           C  
ATOM   1045  O   LYS   135      83.720 101.689  42.340  1.00 60.63           O  
ATOM   1046  CB  LYS   135      80.648 102.266  42.992  1.00 56.16           C  
ATOM   1047  N   SER   136      83.259 103.791  41.681  1.00 62.28           N  
ATOM   1048  CA  SER   136      84.284 103.751  40.639  1.00 63.96           C  
ATOM   1049  C   SER   136      85.636 103.438  41.283  1.00 64.38           C  
ATOM   1050  O   SER   136      86.423 102.647  40.741  1.00 65.17           O  
ATOM   1051  CB  SER   136      84.355 105.083  39.887  1.00 64.03           C  
ATOM   1052  OG  SER   136      84.767 106.133  40.741  1.00 67.09           O  
ATOM   1053  N   LEU   137      85.880 104.042  42.448  1.00 64.20           N  
ATOM   1054  CA  LEU   137      87.118 103.840  43.199  1.00 64.30           C  
ATOM   1055  C   LEU   137      87.153 102.611  44.128  1.00 63.64           C  
ATOM   1056  O   LEU   137      88.192 102.327  44.717  1.00 63.46           O  
ATOM   1057  CB  LEU   137      87.443 105.078  44.042  1.00 64.99           C  
ATOM   1058  CG  LEU   137      87.910 106.363  43.359  1.00 67.10           C  
ATOM   1059  CD1 LEU   137      89.022 106.027  42.382  1.00 68.80           C  
ATOM   1060  CD2 LEU   137      86.754 107.025  42.647  1.00 70.31           C  
ATOM   1061  N   PHE   138      86.051 101.882  44.282  1.00 62.43           N  
ATOM   1062  CA  PHE   138      86.104 100.728  45.172  1.00 62.24           C  
ATOM   1063  C   PHE   138      87.174  99.736  44.722  1.00 63.75           C  
ATOM   1064  O   PHE   138      87.849  99.132  45.552  1.00 65.01           O  
ATOM   1065  CB  PHE   138      84.746 100.011  45.275  1.00 60.61           C  
ATOM   1066  CG  PHE   138      83.649 100.842  45.899  1.00 55.89           C  
ATOM   1067  CD1 PHE   138      83.911 102.108  46.424  1.00 52.20           C  
ATOM   1068  CD2 PHE   138      82.341 100.363  45.939  1.00 54.02           C  
ATOM   1069  CE1 PHE   138      82.884 102.891  46.974  1.00 50.00           C  
ATOM   1070  CE2 PHE   138      81.306 101.135  46.485  1.00 53.26           C  
ATOM   1071  CZ  PHE   138      81.580 102.401  47.005  1.00 52.41           C  
ATOM   1072  N   ASN   139      87.350  99.558  43.418  1.00 65.81           N  
ATOM   1073  CA  ASN   139      88.372  98.615  42.955  1.00 67.56           C  
ATOM   1074  C   ASN   139      89.744  99.043  43.470  1.00 68.24           C  
ATOM   1075  O   ASN   139      90.535  98.219  43.918  1.00 68.02           O  
ATOM   1076  CB  ASN   139      88.384  98.539  41.433  1.00 67.28           C  
ATOM   1077  N   GLU   140      90.012 100.342  43.413  1.00 69.37           N  
ATOM   1078  CA  GLU   140      91.285 100.880  43.863  1.00 70.51           C  
ATOM   1079  C   GLU   140      91.556 100.634  45.329  1.00 70.69           C  
ATOM   1080  O   GLU   140      92.644 100.196  45.703  1.00 71.04           O  
ATOM   1081  CB  GLU   140      91.342 102.380  43.597  1.00 71.48           C  
ATOM   1082  CG  GLU   140      91.568 102.719  42.147  1.00 74.90           C  
ATOM   1083  CD  GLU   140      92.902 102.195  41.651  1.00 79.72           C  
ATOM   1084  OE1 GLU   140      93.952 102.688  42.138  1.00 80.78           O  
ATOM   1085  OE2 GLU   140      92.894 101.287  40.783  1.00 81.31           O  
ATOM   1086  N   ILE   141      90.568 100.928  46.166  1.00 71.01           N  
ATOM   1087  CA  ILE   141      90.736 100.754  47.598  1.00 70.87           C  
ATOM   1088  C   ILE   141      91.025  99.294  47.941  1.00 70.05           C  
ATOM   1089  O   ILE   141      91.832  99.015  48.828  1.00 70.27           O  
ATOM   1090  CB  ILE   141      89.507 101.342  48.385  1.00 71.02           C  
ATOM   1091  CG1 ILE   141      89.560 100.931  49.851  1.00 72.11           C  
ATOM   1092  CG2 ILE   141      88.219 100.909  47.761  1.00 71.02           C  
ATOM   1093  CD1 ILE   141      88.892  99.606  50.139  1.00 75.02           C  
ATOM   1094  N   GLU   142      90.410  98.365  47.217  1.00 69.37           N  
ATOM   1095  CA  GLU   142      90.659  96.947  47.467  1.00 69.15           C  
ATOM   1096  C   GLU   142      92.147  96.636  47.267  1.00 68.76           C  
ATOM   1097  O   GLU   142      92.722  95.818  47.981  1.00 68.80           O  
ATOM   1098  CB  GLU   142      89.813  96.086  46.535  1.00 68.61           C  
ATOM   1099  N   LYS   143      92.766  97.308  46.299  1.00 68.67           N  
ATOM   1100  CA  LYS   143      94.184  97.113  45.980  1.00 68.20           C  
ATOM   1101  C   LYS   143      95.122  97.568  47.105  1.00 67.70           C  
ATOM   1102  O   LYS   143      96.254  97.090  47.225  1.00 68.14           O  
ATOM   1103  CB  LYS   143      94.525  97.850  44.676  1.00 68.56           C  
ATOM   1104  N   LEU   144      94.645  98.499  47.921  1.00 66.67           N  
ATOM   1105  CA  LEU   144      95.408  99.020  49.049  1.00 65.38           C  
ATOM   1106  C   LEU   144      96.016  97.900  49.921  1.00 64.92           C  
ATOM   1107  O   LEU   144      95.476  96.787  49.994  1.00 64.21           O  
ATOM   1108  CB  LEU   144      94.483  99.898  49.897  1.00 65.48           C  
ATOM   1109  CG  LEU   144      94.824 101.371  50.106  1.00 66.58           C  
ATOM   1110  CD1 LEU   144      95.439 101.960  48.858  1.00 67.08           C  
ATOM   1111  CD2 LEU   144      93.557 102.119  50.485  1.00 66.22           C  
ATOM   1112  N   ARG   145      97.138  98.207  50.578  1.00 64.60           N  
ATOM   1113  CA  ARG   145      97.823  97.256  51.465  1.00 64.15           C  
ATOM   1114  C   ARG   145      98.183  97.860  52.819  1.00 63.00           C  
ATOM   1115  O   ARG   145      98.368  99.075  52.951  1.00 62.62           O  
ATOM   1116  CB  ARG   145      99.101  96.724  50.813  1.00 64.74           C  
ATOM   1117  CG  ARG   145      98.853  95.634  49.791  1.00 69.68           C  
ATOM   1118  CD  ARG   145      99.825  95.721  48.615  1.00 76.97           C  
ATOM   1119  NE  ARG   145     101.228  95.680  49.025  1.00 79.89           N  
ATOM   1120  CZ  ARG   145     101.807  94.649  49.633  1.00 80.04           C  
ATOM   1121  NH1 ARG   145     101.106  93.557  49.911  1.00 77.46           N  
ATOM   1122  NH2 ARG   145     103.091  94.713  49.966  1.00 80.64           N  
ATOM   1123  N   GLY   146      98.270  96.987  53.819  1.00 61.83           N  
ATOM   1124  CA  GLY   146      98.634  97.387  55.168  1.00 59.45           C  
ATOM   1125  C   GLY   146      97.976  98.610  55.772  1.00 58.65           C  
ATOM   1126  O   GLY   146      96.751  98.673  55.929  1.00 57.38           O  
ATOM   1127  N   ASP   147      98.812  99.585  56.120  1.00 57.90           N  
ATOM   1128  CA  ASP   147      98.349 100.817  56.742  1.00 57.47           C  
ATOM   1129  C   ASP   147      98.253 101.992  55.776  1.00 57.66           C  
ATOM   1130  O   ASP   147      98.311 103.150  56.189  1.00 58.10           O  
ATOM   1131  CB  ASP   147      99.268 101.203  57.894  1.00 56.82           C  
ATOM   1132  CG  ASP   147      98.572 102.069  58.919  1.00 58.56           C  
ATOM   1133  OD1 ASP   147      99.230 102.956  59.494  1.00 60.43           O  
ATOM   1134  OD2 ASP   147      97.365 101.852  59.160  1.00 61.44           O  
ATOM   1135  N   VAL   148      98.118 101.695  54.491  1.00 57.82           N  
ATOM   1136  CA  VAL   148      97.990 102.741  53.491  1.00 57.65           C  
ATOM   1137  C   VAL   148      96.523 103.100  53.383  1.00 58.26           C  
ATOM   1138  O   VAL   148      95.702 102.241  53.075  1.00 57.77           O  
ATOM   1139  CB  VAL   148      98.470 102.259  52.130  1.00 57.60           C  
ATOM   1140  CG1 VAL   148      98.224 103.321  51.090  1.00 55.84           C  
ATOM   1141  CG2 VAL   148      99.929 101.907  52.207  1.00 57.70           C  
ATOM   1142  N   GLY   149      96.205 104.367  53.632  1.00 59.53           N  
ATOM   1143  CA  GLY   149      94.829 104.826  53.570  1.00 61.31           C  
ATOM   1144  C   GLY   149      94.349 105.192  52.182  1.00 63.72           C  
ATOM   1145  O   GLY   149      95.051 104.994  51.189  1.00 64.43           O  
ATOM   1146  N   ALA   150      93.147 105.746  52.110  1.00 65.36           N  
ATOM   1147  CA  ALA   150      92.564 106.128  50.831  1.00 67.42           C  
ATOM   1148  C   ALA   150      93.150 107.416  50.231  1.00 68.74           C  
ATOM   1149  O   ALA   150      93.027 107.648  49.025  1.00 68.20           O  
ATOM   1150  CB  ALA   150      91.052 106.251  50.975  1.00 67.32           C  
ATOM   1151  N   ARG   151      93.794 108.241  51.058  1.00 71.18           N  
ATOM   1152  CA  ARG   151      94.378 109.491  50.570  1.00 74.01           C  
ATOM   1153  C   ARG   151      95.388 109.269  49.453  1.00 75.14           C  
ATOM   1154  O   ARG   151      95.635 110.154  48.635  1.00 75.26           O  
ATOM   1155  CB  ARG   151      95.047 110.262  51.702  1.00 74.25           C  
ATOM   1156  CG  ARG   151      95.632 111.606  51.257  1.00 77.89           C  
ATOM   1157  CD  ARG   151      95.776 112.564  52.437  1.00 84.37           C  
ATOM   1158  NE  ARG   151      96.526 111.945  53.525  1.00 89.32           N  
ATOM   1159  CZ  ARG   151      97.811 111.612  53.452  1.00 91.28           C  
ATOM   1160  NH1 ARG   151      98.501 111.848  52.338  1.00 90.83           N  
ATOM   1161  NH2 ARG   151      98.400 111.020  54.487  1.00 92.52           N  
ATOM   1162  N   VAL   152      95.969 108.080  49.420  1.00 76.27           N  
ATOM   1163  CA  VAL   152      96.933 107.758  48.390  1.00 77.39           C  
ATOM   1164  C   VAL   152      96.218 107.653  47.055  1.00 77.89           C  
ATOM   1165  O   VAL   152      96.724 108.117  46.035  1.00 77.93           O  
ATOM   1166  CB  VAL   152      97.636 106.434  48.695  1.00 77.65           C  
ATOM   1167  CG1 VAL   152      98.684 106.155  47.643  1.00 76.78           C  
ATOM   1168  CG2 VAL   152      98.274 106.505  50.072  1.00 80.17           C  
ATOM   1169  N   ILE   153      95.033 107.050  47.069  1.00 78.94           N  
ATOM   1170  CA  ILE   153      94.243 106.886  45.852  1.00 79.79           C  
ATOM   1171  C   ILE   153      93.630 108.209  45.401  1.00 80.54           C  
ATOM   1172  O   ILE   153      93.329 108.391  44.220  1.00 80.78           O  
ATOM   1173  CB  ILE   153      93.086 105.892  46.051  1.00 79.53           C  
ATOM   1174  CG1 ILE   153      93.615 104.580  46.613  1.00 79.70           C  
ATOM   1175  CG2 ILE   153      92.392 105.624  44.723  1.00 78.74           C  
ATOM   1176  CD1 ILE   153      92.523 103.590  46.929  1.00 81.12           C  
ATOM   1177  N   LEU   154      93.443 109.130  46.344  1.00 81.43           N  
ATOM   1178  CA  LEU   154      92.851 110.427  46.027  1.00 81.93           C  
ATOM   1179  C   LEU   154      93.848 111.409  45.398  1.00 83.02           C  
ATOM   1180  O   LEU   154      93.465 112.300  44.639  1.00 83.08           O  
ATOM   1181  CB  LEU   154      92.225 111.044  47.288  1.00 81.24           C  
ATOM   1182  CG  LEU   154      91.005 110.341  47.899  1.00 79.35           C  
ATOM   1183  CD1 LEU   154      90.423 111.199  49.010  1.00 76.84           C  
ATOM   1184  CD2 LEU   154      89.957 110.092  46.833  1.00 78.09           C  
ATOM   1185  N   ASN   155      95.129 111.239  45.700  1.00 84.48           N  
ATOM   1186  CA  ASN   155      96.142 112.132  45.157  1.00 85.67           C  
ATOM   1187  C   ASN   155      96.621 111.689  43.787  1.00 86.38           C  
ATOM   1188  O   ASN   155      97.555 112.265  43.236  1.00 87.30           O  
ATOM   1189  CB  ASN   155      97.325 112.227  46.121  1.00 85.40           C  
ATOM   1190  CG  ASN   155      96.916 112.754  47.478  1.00 86.53           C  
ATOM   1191  OD1 ASN   155      96.189 113.743  47.572  1.00 89.43           O  
ATOM   1192  ND2 ASN   155      97.381 112.102  48.538  1.00 88.56           N  
ATOM   1193  N   LYS   156      95.978 110.669  43.234  1.00 86.65           N  
ATOM   1194  CA  LYS   156      96.355 110.163  41.924  1.00 87.07           C  
ATOM   1195  C   LYS   156      95.167 110.174  40.964  1.00 88.18           C  
ATOM   1196  O   LYS   156      95.101 109.362  40.039  1.00 88.52           O  
ATOM   1197  CB  LYS   156      96.917 108.754  42.049  1.00 86.22           C  
ATOM   1198  N   ILE   157      94.216 111.076  41.192  1.00 89.25           N  
ATOM   1199  CA  ILE   157      93.061 111.177  40.306  1.00 90.64           C  
ATOM   1200  C   ILE   157      92.924 112.613  39.819  1.00 91.38           C  
ATOM   1201  O   ILE   157      93.121 113.564  40.587  1.00 91.57           O  
ATOM   1202  CB  ILE   157      91.731 110.739  40.989  1.00 90.77           C  
ATOM   1203  CG1 ILE   157      91.471 111.576  42.236  1.00 91.50           C  
ATOM   1204  CG2 ILE   157      91.781 109.258  41.332  1.00 90.73           C  
ATOM   1205  CD1 ILE   157      90.091 111.361  42.823  1.00 92.69           C  
ATOM   1206  N   LYS   158      92.593 112.748  38.535  1.00 91.96           N  
ATOM   1207  CA  LYS   158      92.438 114.037  37.862  1.00 92.43           C  
ATOM   1208  C   LYS   158      91.547 115.037  38.592  1.00 92.49           C  
ATOM   1209  O   LYS   158      90.382 114.753  38.871  1.00 92.57           O  
ATOM   1210  CB  LYS   158      91.908 113.810  36.451  1.00 92.67           C  
ATOM   1211  N   ILE   159      92.100 116.215  38.877  1.00 92.42           N  
ATOM   1212  CA  ILE   159      91.364 117.269  39.573  1.00 93.01           C  
ATOM   1213  C   ILE   159      90.042 117.573  38.853  1.00 93.01           C  
ATOM   1214  O   ILE   159      89.114 118.143  39.440  1.00 93.13           O  
ATOM   1215  CB  ILE   159      92.188 118.581  39.649  1.00 93.16           C  
ATOM   1216  CG1 ILE   159      93.679 118.262  39.744  1.00 93.98           C  
ATOM   1217  CG2 ILE   159      91.762 119.392  40.874  1.00 92.59           C  
ATOM   1218  CD1 ILE   159      94.577 119.483  39.653  1.00 94.92           C  
ATOM   1219  N   GLU   160      89.963 117.196  37.579  1.00 92.43           N  
ATOM   1220  CA  GLU   160      88.762 117.430  36.794  1.00 91.90           C  
ATOM   1221  C   GLU   160      87.733 116.371  37.149  1.00 91.72           C  
ATOM   1222  O   GLU   160      86.686 116.271  36.510  1.00 91.47           O  
ATOM   1223  CB  GLU   160      89.089 117.375  35.303  1.00 91.77           C  
ATOM   1224  N   GLU   161      88.037 115.586  38.180  1.00 91.67           N  
ATOM   1225  CA  GLU   161      87.147 114.517  38.625  1.00 91.68           C  
ATOM   1226  C   GLU   161      86.845 114.537  40.126  1.00 90.79           C  
ATOM   1227  O   GLU   161      85.991 113.785  40.602  1.00 90.51           O  
ATOM   1228  CB  GLU   161      87.730 113.160  38.217  1.00 92.12           C  
ATOM   1229  CG  GLU   161      87.775 112.968  36.707  1.00 93.63           C  
ATOM   1230  CD  GLU   161      88.567 111.747  36.282  1.00 96.44           C  
ATOM   1231  OE1 GLU   161      89.811 111.760  36.419  1.00 95.88           O  
ATOM   1232  OE2 GLU   161      87.940 110.775  35.811  1.00 98.07           O  
ATOM   1233  N   LEU   162      87.548 115.385  40.871  1.00 89.70           N  
ATOM   1234  CA  LEU   162      87.294 115.503  42.300  1.00 89.10           C  
ATOM   1235  C   LEU   162      86.207 116.551  42.486  1.00 88.72           C  
ATOM   1236  O   LEU   162      85.885 117.288  41.560  1.00 89.15           O  
ATOM   1237  CB  LEU   162      88.553 115.929  43.061  1.00 89.13           C  
ATOM   1238  CG  LEU   162      89.606 114.852  43.310  1.00 89.45           C  
ATOM   1239  CD1 LEU   162      90.307 114.543  42.011  1.00 91.38           C  
ATOM   1240  CD2 LEU   162      90.605 115.324  44.347  1.00 88.04           C  
ATOM   1241  N   CYS   163      85.637 116.614  43.681  1.00 88.09           N  
ATOM   1242  CA  CYS   163      84.587 117.580  43.968  1.00 87.74           C  
ATOM   1243  C   CYS   163      84.738 118.035  45.410  1.00 86.55           C  
ATOM   1244  O   CYS   163      84.544 117.260  46.342  1.00 87.43           O  
ATOM   1245  CB  CYS   163      83.212 116.942  43.719  1.00 87.82           C  
ATOM   1246  SG  CYS   163      82.989 116.485  41.964  1.00 91.64           S  
ATOM   1247  N   PHE   164      85.096 119.298  45.590  1.00 84.52           N  
ATOM   1248  CA  PHE   164      85.305 119.839  46.919  1.00 83.15           C  
ATOM   1249  C   PHE   164      84.154 120.712  47.388  1.00 83.06           C  
ATOM   1250  O   PHE   164      83.250 121.019  46.622  1.00 83.89           O  
ATOM   1251  CB  PHE   164      86.589 120.658  46.921  1.00 82.45           C  
ATOM   1252  CG  PHE   164      87.750 119.951  46.296  1.00 82.05           C  
ATOM   1253  CD1 PHE   164      88.496 119.028  47.023  1.00 82.19           C  
ATOM   1254  CD2 PHE   164      88.092 120.191  44.975  1.00 81.98           C  
ATOM   1255  CE1 PHE   164      89.567 118.349  46.436  1.00 80.81           C  
ATOM   1256  CE2 PHE   164      89.158 119.517  44.382  1.00 82.43           C  
ATOM   1257  CZ  PHE   164      89.899 118.596  45.116  1.00 80.76           C  
ATOM   1258  N   ILE   165      84.194 121.082  48.665  1.00 82.73           N  
ATOM   1259  CA  ILE   165      83.211 121.965  49.289  1.00 82.62           C  
ATOM   1260  C   ILE   165      83.750 122.403  50.634  1.00 82.13           C  
ATOM   1261  O   ILE   165      84.364 121.619  51.355  1.00 82.40           O  
ATOM   1262  CB  ILE   165      81.819 121.317  49.546  1.00 82.92           C  
ATOM   1263  CG1 ILE   165      81.972 119.925  50.151  1.00 84.16           C  
ATOM   1264  CG2 ILE   165      81.006 121.307  48.272  1.00 84.02           C  
ATOM   1265  CD1 ILE   165      82.258 118.853  49.132  1.00 85.27           C  
ATOM   1266  N   GLU   166      83.519 123.664  50.965  1.00 81.04           N  
ATOM   1267  CA  GLU   166      83.980 124.201  52.224  1.00 80.04           C  
ATOM   1268  C   GLU   166      83.012 123.838  53.317  1.00 78.84           C  
ATOM   1269  O   GLU   166      81.819 124.131  53.224  1.00 79.05           O  
ATOM   1270  CB  GLU   166      84.098 125.715  52.143  1.00 80.39           C  
ATOM   1271  CG  GLU   166      85.356 126.183  51.475  1.00 81.73           C  
ATOM   1272  CD  GLU   166      86.570 126.002  52.358  1.00 84.18           C  
ATOM   1273  OE1 GLU   166      86.607 126.634  53.445  1.00 81.27           O  
ATOM   1274  OE2 GLU   166      87.480 125.233  51.962  1.00 87.18           O  
ATOM   1275  N   CYS   167      83.534 123.188  54.350  1.00 77.43           N  
ATOM   1276  CA  CYS   167      82.735 122.793  55.498  1.00 75.91           C  
ATOM   1277  C   CYS   167      83.425 123.449  56.682  1.00 75.37           C  
ATOM   1278  O   CYS   167      84.381 124.194  56.486  1.00 75.36           O  
ATOM   1279  CB  CYS   167      82.721 121.273  55.624  1.00 75.12           C  
ATOM   1280  SG  CYS   167      82.137 120.444  54.115  1.00 74.97           S  
ATOM   1281  N   SER   168      82.950 123.196  57.896  1.00 74.67           N  
ATOM   1282  CA  SER   168      83.546 123.796  59.087  1.00 74.46           C  
ATOM   1283  C   SER   168      84.979 123.341  59.315  1.00 74.78           C  
ATOM   1284  O   SER   168      85.503 122.490  58.590  1.00 74.75           O  
ATOM   1285  CB  SER   168      82.711 123.466  60.324  1.00 74.60           C  
ATOM   1286  OG  SER   168      82.611 122.068  60.524  1.00 75.49           O  
ATOM   1287  N   GLU   169      85.621 123.909  60.328  1.00 74.91           N  
ATOM   1288  CA  GLU   169      86.993 123.531  60.624  1.00 75.60           C  
ATOM   1289  C   GLU   169      87.033 122.111  61.208  1.00 75.03           C  
ATOM   1290  O   GLU   169      88.088 121.463  61.235  1.00 74.81           O  
ATOM   1291  CB  GLU   169      87.621 124.531  61.599  1.00 75.85           C  
ATOM   1292  CG  GLU   169      86.996 124.527  62.974  1.00 78.98           C  
ATOM   1293  CD  GLU   169      87.788 125.349  63.971  1.00 84.36           C  
ATOM   1294  OE1 GLU   169      89.031 125.397  63.838  1.00 85.45           O  
ATOM   1295  OE2 GLU   169      87.173 125.926  64.895  1.00 86.32           O  
ATOM   1296  N   GLY   170      85.872 121.634  61.661  1.00 74.49           N  
ATOM   1297  CA  GLY   170      85.775 120.301  62.230  1.00 73.18           C  
ATOM   1298  C   GLY   170      86.207 119.243  61.235  1.00 72.55           C  
ATOM   1299  O   GLY   170      86.525 118.121  61.612  1.00 73.48           O  
ATOM   1300  N   VAL   171      86.216 119.606  59.961  1.00 71.29           N  
ATOM   1301  CA  VAL   171      86.618 118.706  58.894  1.00 70.37           C  
ATOM   1302  C   VAL   171      88.126 118.515  58.897  1.00 69.66           C  
ATOM   1303  O   VAL   171      88.662 117.689  58.156  1.00 68.11           O  
ATOM   1304  CB  VAL   171      86.207 119.282  57.534  1.00 71.15           C  
ATOM   1305  CG1 VAL   171      86.843 118.491  56.404  1.00 72.17           C  
ATOM   1306  CG2 VAL   171      84.702 119.258  57.411  1.00 71.59           C  
ATOM   1307  N   LEU   172      88.808 119.284  59.740  1.00 70.43           N  
ATOM   1308  CA  LEU   172      90.262 119.220  59.819  1.00 71.06           C  
ATOM   1309  C   LEU   172      90.784 118.808  61.188  1.00 71.89           C  
ATOM   1310  O   LEU   172      91.947 118.422  61.330  1.00 72.18           O  
ATOM   1311  CB  LEU   172      90.859 120.579  59.460  1.00 70.49           C  
ATOM   1312  CG  LEU   172      90.604 121.171  58.072  1.00 71.03           C  
ATOM   1313  CD1 LEU   172      91.313 122.497  57.991  1.00 69.40           C  
ATOM   1314  CD2 LEU   172      91.105 120.243  56.971  1.00 72.40           C  
ATOM   1315  N   ILE   173      89.920 118.877  62.191  1.00 72.89           N  
ATOM   1316  CA  ILE   173      90.302 118.553  63.556  1.00 74.89           C  
ATOM   1317  C   ILE   173      89.966 117.147  64.029  1.00 75.88           C  
ATOM   1318  O   ILE   173      88.888 116.631  63.764  1.00 77.01           O  
ATOM   1319  CB  ILE   173      89.634 119.534  64.529  1.00 74.91           C  
ATOM   1320  CG1 ILE   173      89.966 120.971  64.114  1.00 75.25           C  
ATOM   1321  CG2 ILE   173      90.062 119.233  65.966  1.00 75.63           C  
ATOM   1322  CD1 ILE   173      89.124 122.017  64.825  1.00 77.55           C  
ATOM   1323  N   ASP   174      90.900 116.536  64.742  1.00 77.31           N  
ATOM   1324  CA  ASP   174      90.693 115.212  65.312  1.00 78.94           C  
ATOM   1325  C   ASP   174      91.163 115.357  66.754  1.00 79.67           C  
ATOM   1326  O   ASP   174      91.927 116.269  67.053  1.00 79.46           O  
ATOM   1327  CB  ASP   174      91.515 114.159  64.575  1.00 79.22           C  
ATOM   1328  CG  ASP   174      92.986 114.352  64.757  1.00 80.14           C  
ATOM   1329  OD1 ASP   174      93.473 114.155  65.890  1.00 84.16           O  
ATOM   1330  OD2 ASP   174      93.654 114.714  63.769  1.00 82.30           O  
ATOM   1331  N   ILE   175      90.709 114.474  67.640  1.00 80.72           N  
ATOM   1332  CA  ILE   175      91.065 114.561  69.055  1.00 81.80           C  
ATOM   1333  C   ILE   175      92.454 115.112  69.310  1.00 83.81           C  
ATOM   1334  O   ILE   175      92.608 116.069  70.067  1.00 84.37           O  
ATOM   1335  CB  ILE   175      90.933 113.211  69.766  1.00 81.18           C  
ATOM   1336  CG1 ILE   175      89.501 112.710  69.642  1.00 80.88           C  
ATOM   1337  CG2 ILE   175      91.239 113.373  71.235  1.00 78.89           C  
ATOM   1338  CD1 ILE   175      88.482 113.718  70.110  1.00 80.65           C  
ATOM   1339  N   ASP   176      93.462 114.527  68.675  1.00 85.66           N  
ATOM   1340  CA  ASP   176      94.826 115.003  68.853  1.00 87.67           C  
ATOM   1341  C   ASP   176      94.997 116.454  68.411  1.00 88.57           C  
ATOM   1342  O   ASP   176      95.491 117.284  69.176  1.00 88.51           O  
ATOM   1343  CB  ASP   176      95.794 114.119  68.078  1.00 88.25           C  
ATOM   1344  CG  ASP   176      95.807 112.694  68.588  1.00 91.14           C  
ATOM   1345  OD1 ASP   176      96.135 112.497  69.785  1.00 94.37           O  
ATOM   1346  OD2 ASP   176      95.487 111.777  67.793  1.00 93.54           O  
ATOM   1347  N   LYS   177      94.579 116.758  67.182  1.00 89.58           N  
ATOM   1348  CA  LYS   177      94.696 118.112  66.627  1.00 90.14           C  
ATOM   1349  C   LYS   177      94.159 119.185  67.567  1.00 90.65           C  
ATOM   1350  O   LYS   177      94.568 120.342  67.494  1.00 91.35           O  
ATOM   1351  CB  LYS   177      93.983 118.193  65.279  1.00 89.55           C  
ATOM   1352  N   LYS   178      93.238 118.801  68.444  1.00 90.82           N  
ATOM   1353  CA  LYS   178      92.670 119.738  69.400  1.00 91.07           C  
ATOM   1354  C   LYS   178      93.395 119.565  70.731  1.00 91.59           C  
ATOM   1355  O   LYS   178      92.770 119.099  71.711  1.00 92.20           O  
ATOM   1356  CB  LYS   178      91.170 119.489  69.564  1.00 90.86           C  
END
