
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  222 ( 1688),  selected  222 , name 2fdr_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 2fdr_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_A      K       2          0.779
LGA    F     4_A      Y       3          0.752
LGA    D     5_A      T       4          1.608
LGA    L     6_A      V       5          0.773
LGA    I     7_A      Y       6          0.503
LGA    I     8_A      L       7          0.500
LGA    F     9_A      F       8          0.888
LGA    D    10_A      D       9          1.426
LGA    C    11_A      F      10          1.665
LGA    D    12_A      D      11          1.771
LGA    G    13_A      Y      12          1.639
LGA    V    14_A      T      13          1.211
LGA    L    15_A      L      14          1.189
LGA    V    16_A      A      15          1.524
LGA    D    17_A      D      16          1.306
LGA    S    18_A      S      17          1.436
LGA    E    19_A      -       -           -
LGA    I    20_A      S      18          0.850
LGA    I    21_A      R      19          2.630
LGA    -       -      G      20           -
LGA    A    22_A      I      21          1.025
LGA    A    23_A      V      22          2.703
LGA    Q    24_A      T      23          3.848
LGA    V    25_A      C      24          3.301
LGA    E    26_A      F      25          2.538
LGA    S    27_A      R      26          4.593
LGA    -       -      S      27           -
LGA    -       -      V      28           -
LGA    R    28_A      L      29           #
LGA    L    29_A      E      30          3.463
LGA    L    30_A      R      31           -
LGA    T    31_A      H      32           -
LGA    E    32_A      G      33           #
LGA    A    33_A      Y      34          2.827
LGA    G    34_A      -       -           -
LGA    Y    35_A      T      35          3.002
LGA    P    36_A      G      36          1.812
LGA    I    37_A      I      37          3.565
LGA    S    38_A      T      38          3.115
LGA    V    39_A      D      39          1.714
LGA    E    40_A      D      40          2.870
LGA    E    41_A      M      41          3.993
LGA    X    42_A      I      42          3.106
LGA    G    43_A      K      43          3.712
LGA    E    44_A      -       -           -
LGA    R    45_A      -       -           -
LGA    F    46_A      R      44          4.253
LGA    A    47_A      T      45          2.837
LGA    G    48_A      I      46          5.103
LGA    -       -      G      47           -
LGA    X    49_A      K      48          4.495
LGA    -       -      T      49           -
LGA    -       -      L      50           -
LGA    -       -      E      51           -
LGA    T    50_A      E      52          2.530
LGA    W    51_A      S      53          2.751
LGA    K    52_A      F      54          2.336
LGA    N    53_A      S      55          1.226
LGA    I    54_A      I      56          2.217
LGA    L    55_A      L      57          3.325
LGA    L    56_A      T      58          3.381
LGA    Q    57_A      G      59          3.242
LGA    V    58_A      I      60           #
LGA    E    59_A      T      61           -
LGA    S    60_A      D      62           -
LGA    E    61_A      A      63           -
LGA    A    62_A      D      64           -
LGA    S    63_A      -       -           -
LGA    I    64_A      -       -           -
LGA    P    65_A      -       -           -
LGA    L    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    A    68_A      Q      65          4.616
LGA    S    69_A      L      66           -
LGA    L    70_A      E      67           -
LGA    -       -      S      68           -
LGA    L    71_A      F      69          1.551
LGA    -       -      R      70           -
LGA    D    72_A      Q      71          3.993
LGA    K    73_A      E      72          3.691
LGA    S    74_A      Y      73          2.810
LGA    E    75_A      S      74          2.717
LGA    K    76_A      K      75          1.909
LGA    L    77_A      E      76          1.692
LGA    L    78_A      A      77          2.460
LGA    D    79_A      D      78          2.703
LGA    X    80_A      I      79          1.418
LGA    R    81_A      Y      80          0.998
LGA    L    82_A      M      81          1.618
LGA    E    83_A      N      82          3.072
LGA    R    84_A      A      83          2.326
LGA    D    85_A      N      84          2.695
LGA    V    86_A      T      85          1.867
LGA    K    87_A      I      86          1.284
LGA    I    88_A      L      87          1.245
LGA    I    89_A      F      88          1.575
LGA    D    90_A      P      89          1.415
LGA    G    91_A      D      90          0.364
LGA    V    92_A      T      91          0.798
LGA    K    93_A      L      92          1.198
LGA    F    94_A      P      93          1.654
LGA    A    95_A      T      94          0.857
LGA    L    96_A      L      95          1.684
LGA    S    97_A      T      96          2.690
LGA    R    98_A      H      97          2.168
LGA    L    99_A      L      98          2.214
LGA    -       -      K      99           -
LGA    -       -      K     100           -
LGA    T   100_A      Q     101          1.632
LGA    -       -      G     102           -
LGA    T   101_A      I     103          1.853
LGA    P   102_A      R     104          1.555
LGA    R   103_A      I     105          0.999
LGA    C   104_A      G     106          1.124
LGA    I   105_A      I     107          1.316
LGA    C   106_A      I     108          1.577
LGA    S   107_A      S     109          1.724
LGA    N   108_A      T     110          2.108
LGA    S   109_A      K     111          2.242
LGA    S   110_A      Y     112          2.188
LGA    S   111_A      R     113          2.302
LGA    H   112_A      F     114          1.235
LGA    R   113_A      R     115          1.328
LGA    L   114_A      I     116          1.855
LGA    D   115_A      L     117          1.297
LGA    X   116_A      S     118          1.348
LGA    X   117_A      F     119          1.714
LGA    L   118_A      L     120          1.573
LGA    T   119_A      R     121          1.374
LGA    K   120_A      N     122          2.832
LGA    V   121_A      H     123          1.948
LGA    G   122_A      M     124          2.616
LGA    L   123_A      P     125          4.750
LGA    K   124_A      D     126          4.234
LGA    P   125_A      D     127          1.522
LGA    Y   126_A      W     128          1.213
LGA    F   127_A      F     129          1.104
LGA    A   128_A      -       -           -
LGA    P   129_A      D     130          4.989
LGA    H   130_A      I     131          1.620
LGA    I   131_A      I     132          1.455
LGA    Y   132_A      I     133          1.967
LGA    S   133_A      G     134          2.673
LGA    A   134_A      G     135          4.923
LGA    K   135_A      E     136          2.578
LGA    D   136_A      D     137          1.992
LGA    L   137_A      V     138          3.946
LGA    G   138_A      -       -           -
LGA    A   139_A      T     139          2.259
LGA    D   140_A      H     140          2.544
LGA    R   141_A      -       -           -
LGA    V   142_A      H     141          1.807
LGA    K   143_A      K     142          1.431
LGA    P   144_A      P     143          1.288
LGA    K   145_A      D     144          1.435
LGA    P   146_A      P     145          1.218
LGA    D   147_A      E     146          1.682
LGA    I   148_A      G     147          1.303
LGA    F   149_A      L     148          1.273
LGA    L   150_A      L     149          1.569
LGA    H   151_A      L     150          1.857
LGA    G   152_A      A     151          1.518
LGA    A   153_A      I     152          1.700
LGA    A   154_A      D     153          2.396
LGA    Q   155_A      R     154          2.630
LGA    F   156_A      L     155          2.725
LGA    G   157_A      K     156          2.409
LGA    V   158_A      A     157          2.111
LGA    S   159_A      C     158          1.439
LGA    P   160_A      P     159          0.959
LGA    D   161_A      E     160          1.908
LGA    R   162_A      E     161          1.663
LGA    V   163_A      V     162          0.763
LGA    V   164_A      L     163          0.583
LGA    V   165_A      Y     164          0.630
LGA    V   166_A      I     165          0.784
LGA    E   167_A      G     166          0.842
LGA    D   168_A      D     167          1.650
LGA    S   169_A      S     168          2.547
LGA    V   170_A      T     169          2.187
LGA    H   171_A      V     170          2.080
LGA    G   172_A      D     171          2.291
LGA    I   173_A      A     172          1.872
LGA    H   174_A      G     173          1.184
LGA    G   175_A      T     174          1.498
LGA    A   176_A      A     175          1.241
LGA    R   177_A      A     176          1.026
LGA    A   178_A      A     177          1.006
LGA    A   179_A      A     178          1.015
LGA    G   180_A      G     179          0.900
LGA    X   181_A      V     180          0.657
LGA    R   182_A      S     181          0.776
LGA    V   183_A      F     182          0.640
LGA    I   184_A      T     183          0.903
LGA    G   185_A      G     184          1.122
LGA    F   186_A      V     185          1.650
LGA    T   187_A      T     186          1.982
LGA    G   188_A      S     187          1.967
LGA    A   189_A      -       -           -
LGA    S   190_A      -       -           -
LGA    H   191_A      -       -           -
LGA    T   192_A      G     188          3.323
LGA    Y   193_A      M     189          3.548
LGA    P   194_A      -       -           -
LGA    S   195_A      T     190          4.928
LGA    H   196_A      T     191          3.330
LGA    A   197_A      A     192          3.182
LGA    D   198_A      Q     193          2.743
LGA    R   199_A      E     194          2.719
LGA    L   200_A      F     195          3.116
LGA    T   201_A      Q     196          3.369
LGA    D   202_A      A     197          1.991
LGA    A   203_A      Y     198          3.512
LGA    G   204_A      P     199          3.048
LGA    A   205_A      Y     200          3.389
LGA    E   206_A      D     201          3.209
LGA    T   207_A      R     202          2.353
LGA    V   208_A      I     203          1.844
LGA    I   209_A      I     204          1.720
LGA    S   210_A      S     205          2.168
LGA    R   211_A      T     206          1.230
LGA    X   212_A      L     207          1.437
LGA    Q   213_A      G     208          1.152
LGA    D   214_A      Q     209          0.709
LGA    L   215_A      L     210          0.958
LGA    P   216_A      I     211          1.012
LGA    A   217_A      -       -           -
LGA    V   218_A      -       -           -
LGA    I   219_A      -       -           -
LGA    A   220_A      -       -           -
LGA    A   221_A      -       -           -
LGA    X   222_A      -       -           -
LGA    A   223_A      -       -           -
LGA    E   224_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  222  210    5.0    187    2.32    20.32     66.612     7.743

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.658103 * X  +   0.253242 * Y  +   0.709062 * Z  + -25.340025
  Y_new =  -0.555970 * X  +   0.798509 * Y  +   0.230825 * Z  +  30.715347
  Z_new =  -0.507738 * X  +  -0.546124 * Y  +   0.666296 * Z  + 102.554031 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.686604    2.454989  [ DEG:   -39.3395    140.6605 ]
  Theta =   0.532557    2.609035  [ DEG:    30.5133    149.4867 ]
  Phi   =  -0.701472    2.440121  [ DEG:   -40.1914    139.8086 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fdr_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fdr_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  222  210   5.0  187   2.32   20.32  66.612
REMARK  ---------------------------------------------------------- 
MOLECULE 2fdr_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   14-DEC-05   2FDR              
TITLE     CRYSTAL STRUCTURE OF CONSERVED HALOACID DEHALOGENASE-LIKE             
TITLE    2 PROTEIN OF UNKNOWN FUNCTION ATU0790 FROM AGROBACTERIUM               
TITLE    3 TUMEFACIENS STR. C58                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    CONSERVED HYPOTHETICAL, SAD, STRUCTURAL GENOMICS,                     
KEYWDS   2 AGROBACTERIUM TUMEFACIENS, HAD-SUPERFAMILY HYDROLASE,                
KEYWDS   3 PUTATIVE B-PHOSPHOGLUCOMUTASE, PSI, PROTEIN STRUCTURE                
KEYWDS   4 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,              
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   31-JAN-06 2FDR    0                                                
JRNL        AUTH   B.NOCEK,X.XU,H.ZHENG,A.SAVCHENKO,A.EDWARDS,                  
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF HYDROLASES/PHOSPHATASES-LIKE            
JRNL        TITL 2 FOLD PROTEIN FROM AGROBACTERIUM TUMEFACIENS STR.             
JRNL        TITL 3 C58                                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2FDR A    1   229  GB     17739162 AAL41806         1    229             
SEQRES   1 A  229  MSE SER GLY PHE ASP LEU ILE ILE PHE ASP CYS ASP GLY          
SEQRES   2 A  229  VAL LEU VAL ASP SER GLU ILE ILE ALA ALA GLN VAL GLU          
SEQRES   3 A  229  SER ARG LEU LEU THR GLU ALA GLY TYR PRO ILE SER VAL          
SEQRES   4 A  229  GLU GLU MSE GLY GLU ARG PHE ALA GLY MSE THR TRP LYS          
SEQRES   5 A  229  ASN ILE LEU LEU GLN VAL GLU SER GLU ALA SER ILE PRO          
SEQRES   6 A  229  LEU SER ALA SER LEU LEU ASP LYS SER GLU LYS LEU LEU          
SEQRES   7 A  229  ASP MSE ARG LEU GLU ARG ASP VAL LYS ILE ILE ASP GLY          
SEQRES   8 A  229  VAL LYS PHE ALA LEU SER ARG LEU THR THR PRO ARG CYS          
SEQRES   9 A  229  ILE CYS SER ASN SER SER SER HIS ARG LEU ASP MSE MSE          
SEQRES  10 A  229  LEU THR LYS VAL GLY LEU LYS PRO TYR PHE ALA PRO HIS          
SEQRES  11 A  229  ILE TYR SER ALA LYS ASP LEU GLY ALA ASP ARG VAL LYS          
SEQRES  12 A  229  PRO LYS PRO ASP ILE PHE LEU HIS GLY ALA ALA GLN PHE          
SEQRES  13 A  229  GLY VAL SER PRO ASP ARG VAL VAL VAL VAL GLU ASP SER          
SEQRES  14 A  229  VAL HIS GLY ILE HIS GLY ALA ARG ALA ALA GLY MSE ARG          
SEQRES  15 A  229  VAL ILE GLY PHE THR GLY ALA SER HIS THR TYR PRO SER          
SEQRES  16 A  229  HIS ALA ASP ARG LEU THR ASP ALA GLY ALA GLU THR VAL          
SEQRES  17 A  229  ILE SER ARG MSE GLN ASP LEU PRO ALA VAL ILE ALA ALA          
SEQRES  18 A  229  MSE ALA GLU TRP GLU GLY ALA PHE                              
HET    MSE  A  42       8                                                       
HET    MSE  A  49       8                                                       
HET    MSE  A  80       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  A 117       8                                                       
HET    MSE  A 181       8                                                       
HET    MSE  A 212       8                                                       
HET    MSE  A 222       8                                                       
HET     MG   1001       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   2   MG    MG 2+                                                        
FORMUL   3  HOH   *139(H2 O)                                                    
CRYST1   40.237   48.179  104.420  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   GLY A   3     -12.396  37.573  66.990  1.00 33.74           N  
ATOM      2  CA  GLY A   3     -13.027  36.406  67.702  1.00 32.62           C  
ATOM      3  C   GLY A   3     -12.462  36.179  69.100  1.00 31.84           C  
ATOM      4  O   GLY A   3     -12.658  35.105  69.703  1.00 32.51           O  
ATOM      5  N   PHE A   4     -11.739  37.173  69.609  1.00 30.07           N  
ATOM      6  CA  PHE A   4     -11.268  37.140  70.991  1.00 27.46           C  
ATOM      7  C   PHE A   4     -11.876  38.292  71.783  1.00 26.08           C  
ATOM      8  O   PHE A   4     -11.909  39.430  71.320  1.00 26.47           O  
ATOM      9  CB  PHE A   4      -9.743  37.186  71.034  1.00 27.24           C  
ATOM     10  CG  PHE A   4      -9.083  36.034  70.313  1.00 27.26           C  
ATOM     11  CD1 PHE A   4      -9.214  34.724  70.791  1.00 26.14           C  
ATOM     12  CD2 PHE A   4      -8.340  36.258  69.161  1.00 26.41           C  
ATOM     13  CE1 PHE A   4      -8.606  33.645  70.128  1.00 26.97           C  
ATOM     14  CE2 PHE A   4      -7.721  35.196  68.481  1.00 26.98           C  
ATOM     15  CZ  PHE A   4      -7.847  33.887  68.966  1.00 26.98           C  
ATOM     16  N   ASP A   5     -12.397  37.986  72.963  1.00 24.12           N  
ATOM     17  CA  ASP A   5     -12.962  39.010  73.835  1.00 22.41           C  
ATOM     18  C   ASP A   5     -12.010  39.363  74.987  1.00 21.01           C  
ATOM     19  O   ASP A   5     -12.309  40.262  75.792  1.00 19.74           O  
ATOM     20  CB  ASP A   5     -14.292  38.549  74.426  1.00 22.77           C  
ATOM     21  CG  ASP A   5     -15.350  38.270  73.370  1.00 25.36           C  
ATOM     22  OD1 ASP A   5     -16.143  37.337  73.585  1.00 28.16           O  
ATOM     23  OD2 ASP A   5     -15.398  38.981  72.348  1.00 27.13           O  
ATOM     24  N   LEU A   6     -10.882  38.656  75.068  1.00 18.74           N  
ATOM     25  CA  LEU A   6      -9.880  38.942  76.095  1.00 17.85           C  
ATOM     26  C   LEU A   6      -8.483  38.498  75.651  1.00 17.41           C  
ATOM     27  O   LEU A   6      -8.330  37.422  75.053  1.00 17.27           O  
ATOM     28  CB  LEU A   6     -10.247  38.257  77.435  1.00 17.38           C  
ATOM     29  CG  LEU A   6      -9.278  38.411  78.615  1.00 17.47           C  
ATOM     30  CD1 LEU A   6      -9.223  39.879  79.044  1.00 15.52           C  
ATOM     31  CD2 LEU A   6      -9.707  37.500  79.765  1.00 16.57           C  
ATOM     32  N   ILE A   7      -7.486  39.334  75.955  1.00 15.93           N  
ATOM     33  CA  ILE A   7      -6.077  38.971  75.816  1.00 16.26           C  
ATOM     34  C   ILE A   7      -5.492  38.887  77.224  1.00 16.03           C  
ATOM     35  O   ILE A   7      -5.511  39.872  77.977  1.00 16.12           O  
ATOM     36  CB  ILE A   7      -5.246  40.022  75.012  1.00 16.05           C  
ATOM     37  CG1 ILE A   7      -5.896  40.303  73.674  1.00 16.49           C  
ATOM     38  CG2 ILE A   7      -3.787  39.542  74.814  1.00 16.52           C  
ATOM     39  CD1 ILE A   7      -5.309  41.508  72.988  1.00 21.80           C  
ATOM     40  N   ILE A   8      -4.966  37.716  77.569  1.00 15.65           N  
ATOM     41  CA  ILE A   8      -4.252  37.536  78.826  1.00 14.73           C  
ATOM     42  C   ILE A   8      -2.746  37.594  78.590  1.00 15.06           C  
ATOM     43  O   ILE A   8      -2.199  36.833  77.788  1.00 13.41           O  
ATOM     44  CB  ILE A   8      -4.653  36.177  79.520  1.00 15.57           C  
ATOM     45  CG1 ILE A   8      -6.162  36.160  79.836  1.00 14.63           C  
ATOM     46  CG2 ILE A   8      -3.821  35.941  80.781  1.00 14.97           C  
ATOM     47  CD1 ILE A   8      -6.660  34.877  80.564  1.00 15.20           C  
ATOM     48  N   PHE A   9      -2.068  38.474  79.315  1.00 14.32           N  
ATOM     49  CA  PHE A   9      -0.628  38.537  79.225  1.00 15.99           C  
ATOM     50  C   PHE A   9      -0.028  37.935  80.486  1.00 17.37           C  
ATOM     51  O   PHE A   9      -0.543  38.143  81.580  1.00 16.68           O  
ATOM     52  CB  PHE A   9      -0.142  39.992  79.143  1.00 15.45           C  
ATOM     53  CG  PHE A   9      -0.522  40.716  77.876  1.00 16.70           C  
ATOM     54  CD1 PHE A   9       0.362  40.743  76.786  1.00 16.12           C  
ATOM     55  CD2 PHE A   9      -1.715  41.426  77.797  1.00 14.16           C  
ATOM     56  CE1 PHE A   9       0.055  41.433  75.638  1.00 15.11           C  
ATOM     57  CE2 PHE A   9      -2.041  42.133  76.648  1.00 16.43           C  
ATOM     58  CZ  PHE A   9      -1.152  42.131  75.556  1.00 16.93           C  
ATOM     59  N   ASP A  10       1.079  37.211  80.331  1.00 19.04           N  
ATOM     60  CA  ASP A  10       1.981  37.005  81.463  1.00 20.87           C  
ATOM     61  C   ASP A  10       2.778  38.286  81.637  1.00 21.12           C  
ATOM     62  O   ASP A  10       2.833  39.122  80.729  1.00 21.98           O  
ATOM     63  CB  ASP A  10       2.906  35.799  81.221  1.00 21.86           C  
ATOM     64  CG  ASP A  10       3.716  35.425  82.460  1.00 24.32           C  
ATOM     65  OD1 ASP A  10       3.400  35.849  83.593  1.00 26.31           O  
ATOM     66  OD2 ASP A  10       4.701  34.713  82.291  1.00 28.78           O  
ATOM     67  N   CYS A  11       3.386  38.474  82.792  1.00 21.98           N  
ATOM     68  CA  CYS A  11       4.174  39.675  82.996  1.00 22.07           C  
ATOM     69  C   CYS A  11       5.649  39.416  82.652  1.00 22.17           C  
ATOM     70  O   CYS A  11       6.193  40.009  81.696  1.00 21.14           O  
ATOM     71  CB  CYS A  11       4.002  40.206  84.414  1.00 21.96           C  
ATOM     72  SG  CYS A  11       4.854  41.774  84.730  1.00 23.47           S  
ATOM     73  N   ASP A  12       6.280  38.533  83.430  1.00 21.80           N  
ATOM     74  CA  ASP A  12       7.696  38.197  83.284  1.00 22.31           C  
ATOM     75  C   ASP A  12       8.040  37.603  81.920  1.00 21.70           C  
ATOM     76  O   ASP A  12       7.536  36.527  81.536  1.00 22.14           O  
ATOM     77  CB  ASP A  12       8.113  37.213  84.373  1.00 23.90           C  
ATOM     78  CG  ASP A  12       7.927  37.784  85.767  1.00 27.36           C  
ATOM     79  OD1 ASP A  12       8.801  38.581  86.203  1.00 30.93           O  
ATOM     80  OD2 ASP A  12       6.910  37.432  86.412  1.00 30.78           O  
ATOM     81  N   GLY A  13       8.914  38.308  81.201  1.00 19.97           N  
ATOM     82  CA  GLY A  13       9.412  37.825  79.930  1.00 19.20           C  
ATOM     83  C   GLY A  13       8.483  38.166  78.775  1.00 18.69           C  
ATOM     84  O   GLY A  13       8.789  37.818  77.652  1.00 19.18           O  
ATOM     85  N   VAL A  14       7.358  38.848  79.055  1.00 17.90           N  
ATOM     86  CA  VAL A  14       6.361  39.222  78.032  1.00 16.91           C  
ATOM     87  C   VAL A  14       6.128  40.738  78.000  1.00 17.04           C  
ATOM     88  O   VAL A  14       6.319  41.391  76.972  1.00 16.85           O  
ATOM     89  CB  VAL A  14       5.006  38.471  78.248  1.00 17.67           C  
ATOM     90  CG1 VAL A  14       3.898  39.048  77.348  1.00 15.67           C  
ATOM     91  CG2 VAL A  14       5.187  36.984  78.011  1.00 17.39           C  
ATOM     92  N   LEU A  15       5.706  41.280  79.135  1.00 16.37           N  
ATOM     93  CA  LEU A  15       5.531  42.707  79.287  1.00 16.43           C  
ATOM     94  C   LEU A  15       6.809  43.368  79.773  1.00 16.80           C  
ATOM     95  O   LEU A  15       7.147  44.458  79.331  1.00 17.90           O  
ATOM     96  CB  LEU A  15       4.379  42.986  80.259  1.00 16.18           C  
ATOM     97  CG  LEU A  15       3.020  42.548  79.694  1.00 15.47           C  
ATOM     98  CD1 LEU A  15       1.966  42.704  80.787  1.00 19.41           C  
ATOM     99  CD2 LEU A  15       2.630  43.349  78.461  1.00 13.55           C  
ATOM    100  N   VAL A  16       7.511  42.713  80.684  1.00 17.23           N  
ATOM    101  CA  VAL A  16       8.754  43.278  81.263  1.00 18.01           C  
ATOM    102  C   VAL A  16       9.925  42.309  81.059  1.00 17.88           C  
ATOM    103  O   VAL A  16       9.738  41.109  81.063  1.00 17.58           O  
ATOM    104  CB  VAL A  16       8.597  43.627  82.781  1.00 17.96           C  
ATOM    105  CG1 VAL A  16       7.486  44.695  83.031  1.00 17.54           C  
ATOM    106  CG2 VAL A  16       8.331  42.397  83.593  1.00 17.63           C  
ATOM    107  N   ASP A  17      11.126  42.849  80.877  1.00 18.64           N  
ATOM    108  CA  ASP A  17      12.319  42.065  80.584  1.00 19.27           C  
ATOM    109  C   ASP A  17      12.980  41.570  81.893  1.00 19.93           C  
ATOM    110  O   ASP A  17      14.140  41.884  82.194  1.00 20.14           O  
ATOM    111  CB  ASP A  17      13.272  42.938  79.747  1.00 19.60           C  
ATOM    112  CG  ASP A  17      14.210  42.128  78.852  1.00 20.90           C  
ATOM    113  OD1 ASP A  17      14.010  40.900  78.699  1.00 21.05           O  
ATOM    114  OD2 ASP A  17      15.144  42.743  78.279  1.00 20.02           O  
ATOM    115  N   SER A  18      12.229  40.790  82.677  1.00 20.23           N  
ATOM    116  CA  SER A  18      12.646  40.413  84.037  1.00 19.96           C  
ATOM    117  C   SER A  18      13.404  39.078  84.100  1.00 20.69           C  
ATOM    118  O   SER A  18      14.144  38.798  85.065  1.00 18.65           O  
ATOM    119  CB  SER A  18      11.419  40.355  84.944  1.00 20.13           C  
ATOM    120  OG  SER A  18      10.433  39.480  84.390  1.00 19.11           O  
ATOM    121  N   GLU A  19      13.216  38.253  83.080  1.00 21.14           N  
ATOM    122  CA  GLU A  19      13.821  36.927  83.077  1.00 22.62           C  
ATOM    123  C   GLU A  19      15.311  36.946  82.730  1.00 22.08           C  
ATOM    124  O   GLU A  19      16.064  36.074  83.197  1.00 21.88           O  
ATOM    125  CB  GLU A  19      13.050  35.971  82.168  1.00 23.36           C  
ATOM    126  CG  GLU A  19      11.591  35.815  82.558  1.00 27.59           C  
ATOM    127  CD  GLU A  19      11.389  34.904  83.774  1.00 33.31           C  
ATOM    128  OE1 GLU A  19      12.389  34.449  84.387  1.00 35.18           O  
ATOM    129  OE2 GLU A  19      10.215  34.636  84.112  1.00 34.28           O  
ATOM    130  N   ILE A  20      15.737  37.936  81.946  1.00 21.61           N  
ATOM    131  CA  ILE A  20      17.174  38.174  81.724  1.00 21.71           C  
ATOM    132  C   ILE A  20      17.900  38.516  83.045  1.00 22.34           C  
ATOM    133  O   ILE A  20      19.054  38.138  83.245  1.00 22.24           O  
ATOM    134  CB  ILE A  20      17.449  39.236  80.601  1.00 22.12           C  
ATOM    135  CG1 ILE A  20      18.928  39.251  80.164  1.00 22.73           C  
ATOM    136  CG2 ILE A  20      17.010  40.653  81.005  1.00 20.74           C  
ATOM    137  CD1 ILE A  20      19.534  37.891  79.766  1.00 24.14           C  
ATOM    138  N   ILE A  21      17.200  39.178  83.960  1.00 22.32           N  
ATOM    139  CA  ILE A  21      17.780  39.563  85.245  1.00 22.10           C  
ATOM    140  C   ILE A  21      17.910  38.349  86.154  1.00 22.91           C  
ATOM    141  O   ILE A  21      18.956  38.166  86.794  1.00 22.76           O  
ATOM    142  CB  ILE A  21      17.001  40.729  85.914  1.00 22.42           C  
ATOM    143  CG1 ILE A  21      16.981  41.946  84.978  1.00 21.63           C  
ATOM    144  CG2 ILE A  21      17.609  41.088  87.306  1.00 20.70           C  
ATOM    145  CD1 ILE A  21      16.177  43.138  85.509  1.00 21.43           C  
ATOM    146  N   ALA A  22      16.875  37.507  86.193  1.00 22.89           N  
ATOM    147  CA  ALA A  22      16.972  36.223  86.902  1.00 23.22           C  
ATOM    148  C   ALA A  22      18.089  35.357  86.290  1.00 23.66           C  
ATOM    149  O   ALA A  22      18.944  34.841  87.030  1.00 23.90           O  
ATOM    150  CB  ALA A  22      15.647  35.492  86.905  1.00 22.37           C  
ATOM    151  N   ALA A  23      18.112  35.233  84.955  1.00 23.05           N  
ATOM    152  CA  ALA A  23      19.195  34.495  84.271  1.00 23.31           C  
ATOM    153  C   ALA A  23      20.595  35.001  84.663  1.00 23.69           C  
ATOM    154  O   ALA A  23      21.520  34.202  84.882  1.00 23.88           O  
ATOM    155  CB  ALA A  23      19.030  34.547  82.766  1.00 22.86           C  
ATOM    156  N   GLN A  24      20.748  36.323  84.731  1.00 23.78           N  
ATOM    157  CA  GLN A  24      22.020  36.946  85.121  1.00 24.11           C  
ATOM    158  C   GLN A  24      22.422  36.624  86.551  1.00 24.42           C  
ATOM    159  O   GLN A  24      23.595  36.306  86.820  1.00 24.20           O  
ATOM    160  CB  GLN A  24      21.966  38.458  84.936  1.00 24.20           C  
ATOM    161  CG  GLN A  24      22.144  38.925  83.481  1.00 25.63           C  
ATOM    162  CD  GLN A  24      21.621  40.330  83.266  1.00 28.41           C  
ATOM    163  OE1 GLN A  24      21.076  40.955  84.189  1.00 28.85           O  
ATOM    164  NE2 GLN A  24      21.781  40.843  82.047  1.00 29.10           N  
ATOM    165  N   VAL A  25      21.457  36.721  87.468  1.00 24.34           N  
ATOM    166  CA  VAL A  25      21.721  36.455  88.876  1.00 24.47           C  
ATOM    167  C   VAL A  25      22.110  34.989  89.040  1.00 25.02           C  
ATOM    168  O   VAL A  25      23.121  34.684  89.667  1.00 24.23           O  
ATOM    169  CB  VAL A  25      20.511  36.792  89.778  1.00 24.17           C  
ATOM    170  CG1 VAL A  25      20.704  36.202  91.185  1.00 24.59           C  
ATOM    171  CG2 VAL A  25      20.307  38.294  89.858  1.00 23.78           C  
ATOM    172  N   GLU A  26      21.317  34.099  88.441  1.00 25.13           N  
ATOM    173  CA  GLU A  26      21.493  32.669  88.607  1.00 26.40           C  
ATOM    174  C   GLU A  26      22.782  32.151  87.986  1.00 26.41           C  
ATOM    175  O   GLU A  26      23.493  31.371  88.617  1.00 26.74           O  
ATOM    176  CB  GLU A  26      20.280  31.916  88.053  1.00 26.44           C  
ATOM    177  CG  GLU A  26      18.997  32.122  88.849  1.00 27.24           C  
ATOM    178  CD  GLU A  26      17.764  31.553  88.154  1.00 28.66           C  
ATOM    179  OE1 GLU A  26      17.892  31.020  87.036  1.00 30.14           O  
ATOM    180  OE2 GLU A  26      16.644  31.664  88.719  1.00 32.83           O  
ATOM    181  N   SER A  27      23.088  32.585  86.765  1.00 27.18           N  
ATOM    182  CA  SER A  27      24.273  32.112  86.056  1.00 28.59           C  
ATOM    183  C   SER A  27      25.538  32.572  86.765  1.00 29.53           C  
ATOM    184  O   SER A  27      26.533  31.846  86.794  1.00 29.15           O  
ATOM    185  CB  SER A  27      24.288  32.554  84.592  1.00 29.11           C  
ATOM    186  OG  SER A  27      24.397  33.961  84.473  1.00 29.17           O  
ATOM    187  N   ARG A  28      25.481  33.749  87.374  1.00 30.47           N  
ATOM    188  CA  ARG A  28      26.609  34.229  88.171  1.00 32.34           C  
ATOM    189  C   ARG A  28      26.805  33.503  89.490  1.00 32.01           C  
ATOM    190  O   ARG A  28      27.941  33.231  89.876  1.00 32.32           O  
ATOM    191  CB  ARG A  28      26.535  35.733  88.382  1.00 32.71           C  
ATOM    192  CG  ARG A  28      27.123  36.499  87.213  1.00 37.08           C  
ATOM    193  CD  ARG A  28      28.666  36.509  87.257  1.00 41.99           C  
ATOM    194  NE  ARG A  28      29.207  37.460  88.239  1.00 45.19           N  
ATOM    195  CZ  ARG A  28      29.093  38.792  88.156  1.00 46.94           C  
ATOM    196  NH1 ARG A  28      28.431  39.365  87.142  1.00 47.72           N  
ATOM    197  NH2 ARG A  28      29.633  39.558  89.100  1.00 46.64           N  
ATOM    198  N   LEU A  29      25.705  33.195  90.173  1.00 32.01           N  
ATOM    199  CA  LEU A  29      25.741  32.388  91.391  1.00 31.96           C  
ATOM    200  C   LEU A  29      26.228  30.967  91.128  1.00 32.56           C  
ATOM    201  O   LEU A  29      26.995  30.410  91.914  1.00 32.21           O  
ATOM    202  CB  LEU A  29      24.372  32.369  92.078  1.00 31.87           C  
ATOM    203  CG  LEU A  29      23.933  33.742  92.603  1.00 32.23           C  
ATOM    204  CD1 LEU A  29      22.681  33.632  93.447  1.00 30.96           C  
ATOM    205  CD2 LEU A  29      25.056  34.430  93.383  1.00 32.55           C  
ATOM    206  N   LEU A  30      25.789  30.390  90.010  1.00 32.64           N  
ATOM    207  CA  LEU A  30      26.299  29.109  89.559  1.00 33.29           C  
ATOM    208  C   LEU A  30      27.780  29.162  89.199  1.00 34.08           C  
ATOM    209  O   LEU A  30      28.551  28.301  89.623  1.00 34.06           O  
ATOM    210  CB  LEU A  30      25.477  28.586  88.383  1.00 32.79           C  
ATOM    211  CG  LEU A  30      24.182  27.875  88.775  1.00 32.41           C  
ATOM    212  CD1 LEU A  30      23.390  27.489  87.528  1.00 31.19           C  
ATOM    213  CD2 LEU A  30      24.476  26.642  89.634  1.00 31.42           C  
ATOM    214  N   THR A  31      28.168  30.182  88.435  1.00 35.06           N  
ATOM    215  CA  THR A  31      29.535  30.329  87.949  1.00 36.28           C  
ATOM    216  C   THR A  31      30.499  30.401  89.123  1.00 37.32           C  
ATOM    217  O   THR A  31      31.519  29.701  89.148  1.00 38.00           O  
ATOM    218  CB  THR A  31      29.676  31.552  87.005  1.00 36.07           C  
ATOM    219  OG1 THR A  31      29.030  31.248  85.763  1.00 36.17           O  
ATOM    220  CG2 THR A  31      31.144  31.890  86.726  1.00 36.08           C  
ATOM    221  N   GLU A  32      30.142  31.220  90.105  1.00 37.98           N  
ATOM    222  CA  GLU A  32      30.955  31.407  91.290  1.00 39.00           C  
ATOM    223  C   GLU A  32      31.091  30.147  92.138  1.00 39.05           C  
ATOM    224  O   GLU A  32      32.132  29.931  92.758  1.00 39.57           O  
ATOM    225  CB  GLU A  32      30.414  32.563  92.127  1.00 39.02           C  
ATOM    226  CG  GLU A  32      30.797  33.919  91.571  1.00 41.44           C  
ATOM    227  CD  GLU A  32      30.214  35.075  92.367  1.00 45.06           C  
ATOM    228  OE1 GLU A  32      30.454  36.237  91.958  1.00 45.60           O  
ATOM    229  OE2 GLU A  32      29.516  34.825  93.389  1.00 46.24           O  
ATOM    230  N   ALA A  33      30.051  29.321  92.162  1.00 39.02           N  
ATOM    231  CA  ALA A  33      30.041  28.102  92.974  1.00 39.11           C  
ATOM    232  C   ALA A  33      30.847  26.949  92.368  1.00 38.85           C  
ATOM    233  O   ALA A  33      30.973  25.892  92.982  1.00 39.21           O  
ATOM    234  CB  ALA A  33      28.611  27.664  93.253  1.00 39.17           C  
ATOM    235  N   GLY A  34      31.389  27.156  91.171  1.00 38.77           N  
ATOM    236  CA  GLY A  34      32.160  26.126  90.467  1.00 38.59           C  
ATOM    237  C   GLY A  34      31.513  25.580  89.200  1.00 38.33           C  
ATOM    238  O   GLY A  34      31.959  24.571  88.657  1.00 38.47           O  
ATOM    239  N   TYR A  35      30.470  26.251  88.712  1.00 38.05           N  
ATOM    240  CA  TYR A  35      29.737  25.794  87.532  1.00 37.07           C  
ATOM    241  C   TYR A  35      29.611  26.937  86.521  1.00 37.15           C  
ATOM    242  O   TYR A  35      28.582  27.630  86.484  1.00 36.83           O  
ATOM    243  CB  TYR A  35      28.366  25.298  87.964  1.00 36.82           C  
ATOM    244  CG  TYR A  35      27.589  24.501  86.940  1.00 36.25           C  
ATOM    245  CD1 TYR A  35      26.566  25.089  86.200  1.00 35.08           C  
ATOM    246  CD2 TYR A  35      27.841  23.139  86.752  1.00 36.85           C  
ATOM    247  CE1 TYR A  35      25.831  24.356  85.280  1.00 35.25           C  
ATOM    248  CE2 TYR A  35      27.105  22.392  85.838  1.00 36.62           C  
ATOM    249  CZ  TYR A  35      26.103  23.008  85.108  1.00 36.21           C  
ATOM    250  OH  TYR A  35      25.379  22.269  84.208  1.00 36.17           O  
ATOM    251  N   PRO A  36      30.665  27.148  85.704  1.00 37.09           N  
ATOM    252  CA  PRO A  36      30.670  28.215  84.709  1.00 36.92           C  
ATOM    253  C   PRO A  36      29.588  28.031  83.642  1.00 36.74           C  
ATOM    254  O   PRO A  36      29.536  27.008  82.959  1.00 36.59           O  
ATOM    255  CB  PRO A  36      32.072  28.130  84.095  1.00 37.21           C  
ATOM    256  CG  PRO A  36      32.542  26.757  84.381  1.00 37.06           C  
ATOM    257  CD  PRO A  36      31.926  26.379  85.688  1.00 37.34           C  
ATOM    258  N   ILE A  37      28.724  29.031  83.526  1.00 36.32           N  
ATOM    259  CA  ILE A  37      27.593  28.989  82.618  1.00 36.89           C  
ATOM    260  C   ILE A  37      27.210  30.431  82.286  1.00 37.37           C  
ATOM    261  O   ILE A  37      27.221  31.302  83.159  1.00 37.18           O  
ATOM    262  CB  ILE A  37      26.395  28.161  83.210  1.00 36.13           C  
ATOM    263  CG1 ILE A  37      25.302  27.962  82.161  1.00 36.24           C  
ATOM    264  CG2 ILE A  37      25.842  28.802  84.495  1.00 36.04           C  
ATOM    265  CD1 ILE A  37      24.435  26.739  82.386  1.00 36.20           C  
ATOM    266  N   SER A  38      26.920  30.683  81.014  1.00 38.28           N  
ATOM    267  CA  SER A  38      26.588  32.028  80.551  1.00 38.88           C  
ATOM    268  C   SER A  38      25.089  32.163  80.690  1.00 39.36           C  
ATOM    269  O   SER A  38      24.397  31.149  80.807  1.00 38.70           O  
ATOM    270  CB  SER A  38      26.995  32.198  79.086  1.00 38.66           C  
ATOM    271  OG  SER A  38      26.122  31.460  78.226  1.00 39.27           O  
ATOM    272  N   VAL A  39      24.574  33.392  80.654  1.00 40.72           N  
ATOM    273  CA  VAL A  39      23.111  33.586  80.668  1.00 41.74           C  
ATOM    274  C   VAL A  39      22.430  32.827  79.531  1.00 42.15           C  
ATOM    275  O   VAL A  39      21.367  32.243  79.719  1.00 42.32           O  
ATOM    276  CB  VAL A  39      22.674  35.085  80.708  1.00 41.71           C  
ATOM    277  CG1 VAL A  39      23.249  35.773  81.943  1.00 42.45           C  
ATOM    278  CG2 VAL A  39      23.087  35.845  79.443  1.00 43.04           C  
ATOM    279  N   GLU A  40      23.061  32.806  78.360  1.00 43.16           N  
ATOM    280  CA  GLU A  40      22.480  32.129  77.193  1.00 43.96           C  
ATOM    281  C   GLU A  40      22.176  30.649  77.446  1.00 43.63           C  
ATOM    282  O   GLU A  40      21.096  30.159  77.090  1.00 43.68           O  
ATOM    283  CB  GLU A  40      23.387  32.272  75.963  1.00 44.81           C  
ATOM    284  CG  GLU A  40      23.688  33.711  75.542  1.00 47.48           C  
ATOM    285  CD  GLU A  40      24.985  34.242  76.125  1.00 50.49           C  
ATOM    286  OE1 GLU A  40      25.931  34.492  75.338  1.00 52.78           O  
ATOM    287  OE2 GLU A  40      25.069  34.407  77.362  1.00 52.05           O  
ATOM    288  N   GLU A  41      23.124  29.949  78.072  1.00 43.07           N  
ATOM    289  CA  GLU A  41      22.996  28.508  78.349  1.00 42.69           C  
ATOM    290  C   GLU A  41      21.978  28.180  79.448  1.00 41.87           C  
ATOM    291  O   GLU A  41      21.377  27.104  79.440  1.00 41.81           O  
ATOM    292  CB  GLU A  41      24.362  27.908  78.687  1.00 42.91           C  
ATOM    293  CG  GLU A  41      25.507  28.420  77.800  1.00 43.36           C  
ATOM    294  CD  GLU A  41      26.889  27.946  78.258  1.00 43.50           C  
ATOM    295  OE1 GLU A  41      27.159  26.728  78.172  1.00 45.79           O  
ATOM    296  OE2 GLU A  41      27.709  28.789  78.691  1.00 43.51           O  
HETATM  297  N   MSE A  42      21.795  29.104  80.388  1.00 40.96           N  
HETATM  298  CA  MSE A  42      20.714  29.027  81.380  1.00 40.62           C  
HETATM  299  C   MSE A  42      19.388  28.637  80.713  1.00 40.53           C  
HETATM  300  O   MSE A  42      18.652  27.777  81.209  1.00 39.49           O  
HETATM  301  CB  MSE A  42      20.514  30.384  82.067  1.00 40.26           C  
HETATM  302  CG  MSE A  42      21.631  30.817  82.997  1.00 40.29           C  
HETATM  303 SE   MSE A  42      21.842  29.625  84.521  0.90 39.02          SE  
HETATM  304  CE  MSE A  42      19.992  29.551  85.212  1.00 36.99           C  
ATOM    305  N   GLY A  43      19.104  29.306  79.592  1.00 40.65           N  
ATOM    306  CA  GLY A  43      17.895  29.078  78.818  1.00 40.80           C  
ATOM    307  C   GLY A  43      17.905  27.703  78.203  1.00 40.85           C  
ATOM    308  O   GLY A  43      16.963  26.942  78.375  1.00 41.01           O  
ATOM    309  N   GLU A  44      18.976  27.378  77.497  1.00 40.96           N  
ATOM    310  CA  GLU A  44      19.054  26.091  76.827  1.00 41.81           C  
ATOM    311  C   GLU A  44      18.994  24.905  77.797  1.00 42.12           C  
ATOM    312  O   GLU A  44      18.340  23.897  77.514  1.00 41.58           O  
ATOM    313  CB  GLU A  44      20.300  26.014  75.939  1.00 41.56           C  
ATOM    314  CG  GLU A  44      20.102  26.626  74.551  1.00 42.20           C  
ATOM    315  CD  GLU A  44      19.158  25.819  73.650  1.00 40.94           C  
ATOM    316  OE1 GLU A  44      18.678  26.370  72.658  1.00 39.28           O  
ATOM    317  OE2 GLU A  44      18.904  24.628  73.914  1.00 43.10           O  
ATOM    318  N   ARG A  45      19.649  25.034  78.949  1.00 42.50           N  
ATOM    319  CA  ARG A  45      19.732  23.907  79.866  1.00 42.85           C  
ATOM    320  C   ARG A  45      18.644  23.863  80.920  1.00 42.78           C  
ATOM    321  O   ARG A  45      18.216  22.785  81.306  1.00 42.81           O  
ATOM    322  CB  ARG A  45      21.118  23.811  80.495  1.00 43.21           C  
ATOM    323  CG  ARG A  45      22.080  23.038  79.630  1.00 45.26           C  
ATOM    324  CD  ARG A  45      23.439  23.699  79.579  1.00 47.87           C  
ATOM    325  NE  ARG A  45      24.301  23.303  80.694  1.00 49.50           N  
ATOM    326  CZ  ARG A  45      25.617  23.502  80.719  1.00 50.25           C  
ATOM    327  NH1 ARG A  45      26.327  23.118  81.767  1.00 50.82           N  
ATOM    328  NH2 ARG A  45      26.233  24.085  79.695  1.00 50.45           N  
ATOM    329  N   PHE A  46      18.178  25.020  81.374  1.00 42.76           N  
ATOM    330  CA  PHE A  46      17.357  25.048  82.579  1.00 43.05           C  
ATOM    331  C   PHE A  46      16.016  25.777  82.462  1.00 43.81           C  
ATOM    332  O   PHE A  46      15.374  26.063  83.488  1.00 43.91           O  
ATOM    333  CB  PHE A  46      18.154  25.649  83.750  1.00 42.31           C  
ATOM    334  CG  PHE A  46      19.478  24.960  84.029  1.00 40.79           C  
ATOM    335  CD1 PHE A  46      19.527  23.611  84.369  1.00 39.16           C  
ATOM    336  CD2 PHE A  46      20.671  25.678  83.974  1.00 38.18           C  
ATOM    337  CE1 PHE A  46      20.742  22.987  84.634  1.00 37.35           C  
ATOM    338  CE2 PHE A  46      21.882  25.054  84.234  1.00 37.06           C  
ATOM    339  CZ  PHE A  46      21.911  23.707  84.566  1.00 37.50           C  
ATOM    340  N   ALA A  47      15.589  26.077  81.236  1.00 44.35           N  
ATOM    341  CA  ALA A  47      14.357  26.867  81.042  1.00 44.76           C  
ATOM    342  C   ALA A  47      13.159  26.279  81.776  1.00 44.93           C  
ATOM    343  O   ALA A  47      12.929  25.063  81.761  1.00 44.74           O  
ATOM    344  CB  ALA A  47      14.033  27.038  79.574  1.00 44.88           C  
ATOM    345  N   GLY A  48      12.412  27.165  82.424  1.00 45.18           N  
ATOM    346  CA  GLY A  48      11.193  26.781  83.120  1.00 45.40           C  
ATOM    347  C   GLY A  48      11.481  26.405  84.557  1.00 45.58           C  
ATOM    348  O   GLY A  48      10.764  26.829  85.479  1.00 45.99           O  
HETATM  349  N   MSE A  49      12.546  25.629  84.744  1.00 44.88           N  
HETATM  350  CA  MSE A  49      12.874  25.048  86.034  1.00 44.46           C  
HETATM  351  C   MSE A  49      13.054  26.107  87.104  1.00 43.82           C  
HETATM  352  O   MSE A  49      13.580  27.178  86.834  1.00 44.02           O  
HETATM  353  CB  MSE A  49      14.141  24.203  85.928  1.00 44.65           C  
HETATM  354  CG  MSE A  49      14.034  23.033  84.964  1.00 44.04           C  
HETATM  355 SE   MSE A  49      15.700  22.018  84.890  0.70 45.10          SE  
HETATM  356  CE  MSE A  49      15.810  21.466  86.758  1.00 42.60           C  
ATOM    357  N   THR A  50      12.591  25.804  88.311  1.00 43.12           N  
ATOM    358  CA  THR A  50      12.821  26.660  89.470  1.00 42.53           C  
ATOM    359  C   THR A  50      14.303  26.700  89.853  1.00 41.87           C  
ATOM    360  O   THR A  50      15.064  25.788  89.547  1.00 41.28           O  
ATOM    361  CB  THR A  50      12.007  26.195  90.716  1.00 42.94           C  
ATOM    362  OG1 THR A  50      12.497  24.920  91.191  1.00 43.30           O  
ATOM    363  CG2 THR A  50      10.497  26.121  90.397  1.00 42.55           C  
ATOM    364  N   TRP A  51      14.691  27.764  90.545  1.00 41.39           N  
ATOM    365  CA  TRP A  51      16.045  27.894  91.054  1.00 40.94           C  
ATOM    366  C   TRP A  51      16.429  26.664  91.903  1.00 41.20           C  
ATOM    367  O   TRP A  51      17.556  26.164  91.801  1.00 41.22           O  
ATOM    368  CB  TRP A  51      16.171  29.199  91.838  1.00 40.28           C  
ATOM    369  CG  TRP A  51      17.540  29.534  92.346  1.00 39.32           C  
ATOM    370  CD1 TRP A  51      17.843  30.048  93.569  1.00 39.64           C  
ATOM    371  CD2 TRP A  51      18.787  29.391  91.648  1.00 38.38           C  
ATOM    372  NE1 TRP A  51      19.205  30.231  93.690  1.00 39.11           N  
ATOM    373  CE2 TRP A  51      19.807  29.842  92.523  1.00 39.48           C  
ATOM    374  CE3 TRP A  51      19.146  28.916  90.379  1.00 37.93           C  
ATOM    375  CZ2 TRP A  51      21.160  29.841  92.163  1.00 39.12           C  
ATOM    376  CZ3 TRP A  51      20.485  28.917  90.023  1.00 38.05           C  
ATOM    377  CH2 TRP A  51      21.478  29.377  90.912  1.00 39.00           C  
ATOM    378  N   LYS A  52      15.473  26.171  92.698  1.00 41.01           N  
ATOM    379  CA  LYS A  52      15.659  24.995  93.569  1.00 40.84           C  
ATOM    380  C   LYS A  52      15.989  23.707  92.793  1.00 40.39           C  
ATOM    381  O   LYS A  52      16.942  22.996  93.135  1.00 40.41           O  
ATOM    382  CB  LYS A  52      14.429  24.791  94.476  1.00 41.04           C  
ATOM    383  CG  LYS A  52      14.389  23.462  95.238  1.00 41.59           C  
ATOM    384  CD  LYS A  52      13.922  23.683  96.667  1.00 43.68           C  
ATOM    385  CE  LYS A  52      14.406  22.569  97.593  1.00 45.19           C  
ATOM    386  NZ  LYS A  52      15.006  23.114  98.854  1.00 45.39           N  
ATOM    387  N   ASN A  53      15.203  23.423  91.758  1.00 39.65           N  
ATOM    388  CA  ASN A  53      15.424  22.250  90.913  1.00 38.98           C  
ATOM    389  C   ASN A  53      16.674  22.322  90.028  1.00 38.45           C  
ATOM    390  O   ASN A  53      17.290  21.294  89.751  1.00 37.86           O  
ATOM    391  CB  ASN A  53      14.181  21.971  90.077  1.00 39.42           C  
ATOM    392  CG  ASN A  53      13.001  21.548  90.933  1.00 40.65           C  
ATOM    393  OD1 ASN A  53      13.181  21.120  92.078  1.00 42.32           O  
ATOM    394  ND2 ASN A  53      11.789  21.668  90.389  1.00 40.82           N  
ATOM    395  N   ILE A  54      17.019  23.532  89.582  1.00 37.63           N  
ATOM    396  CA  ILE A  54      18.252  23.782  88.839  1.00 36.56           C  
ATOM    397  C   ILE A  54      19.441  23.359  89.693  1.00 36.54           C  
ATOM    398  O   ILE A  54      20.346  22.662  89.207  1.00 35.86           O  
ATOM    399  CB  ILE A  54      18.395  25.291  88.422  1.00 36.78           C  
ATOM    400  CG1 ILE A  54      17.394  25.641  87.314  1.00 36.02           C  
ATOM    401  CG2 ILE A  54      19.845  25.635  87.983  1.00 35.67           C  
ATOM    402  CD1 ILE A  54      17.286  27.139  86.974  1.00 35.95           C  
ATOM    403  N   LEU A  55      19.431  23.776  90.963  1.00 36.18           N  
ATOM    404  CA  LEU A  55      20.539  23.472  91.872  1.00 36.24           C  
ATOM    405  C   LEU A  55      20.630  21.984  92.151  1.00 35.97           C  
ATOM    406  O   LEU A  55      21.726  21.445  92.255  1.00 35.73           O  
ATOM    407  CB  LEU A  55      20.445  24.285  93.163  1.00 36.44           C  
ATOM    408  CG  LEU A  55      20.680  25.781  92.935  1.00 36.48           C  
ATOM    409  CD1 LEU A  55      20.047  26.595  94.041  1.00 36.58           C  
ATOM    410  CD2 LEU A  55      22.165  26.098  92.788  1.00 37.45           C  
ATOM    411  N   LEU A  56      19.471  21.332  92.230  1.00 35.99           N  
ATOM    412  CA  LEU A  56      19.389  19.885  92.363  1.00 36.06           C  
ATOM    413  C   LEU A  56      19.933  19.172  91.127  1.00 35.87           C  
ATOM    414  O   LEU A  56      20.637  18.167  91.265  1.00 35.64           O  
ATOM    415  CB  LEU A  56      17.952  19.423  92.669  1.00 36.10           C  
ATOM    416  CG  LEU A  56      17.345  19.622  94.075  1.00 37.47           C  
ATOM    417  CD1 LEU A  56      15.979  18.933  94.189  1.00 37.36           C  
ATOM    418  CD2 LEU A  56      18.253  19.166  95.239  1.00 38.43           C  
ATOM    419  N   GLN A  57      19.614  19.683  89.931  1.00 35.75           N  
ATOM    420  CA  GLN A  57      20.146  19.112  88.682  1.00 35.85           C  
ATOM    421  C   GLN A  57      21.654  19.314  88.541  1.00 34.85           C  
ATOM    422  O   GLN A  57      22.348  18.463  87.989  1.00 34.60           O  
ATOM    423  CB  GLN A  57      19.450  19.660  87.430  1.00 35.64           C  
ATOM    424  CG  GLN A  57      19.815  18.848  86.184  1.00 36.66           C  
ATOM    425  CD  GLN A  57      19.278  19.411  84.881  1.00 38.10           C  
ATOM    426  OE1 GLN A  57      18.103  19.783  84.775  1.00 40.85           O  
ATOM    427  NE2 GLN A  57      20.136  19.458  83.866  1.00 40.05           N  
ATOM    428  N   VAL A  58      22.153  20.448  89.021  1.00 34.05           N  
ATOM    429  CA  VAL A  58      23.582  20.727  88.945  1.00 33.40           C  
ATOM    430  C   VAL A  58      24.375  19.800  89.881  1.00 33.88           C  
ATOM    431  O   VAL A  58      25.423  19.262  89.496  1.00 33.31           O  
ATOM    432  CB  VAL A  58      23.893  22.210  89.209  1.00 32.89           C  
ATOM    433  CG1 VAL A  58      25.399  22.444  89.320  1.00 32.61           C  
ATOM    434  CG2 VAL A  58      23.334  23.063  88.078  1.00 32.71           C  
ATOM    435  N   GLU A  59      23.863  19.601  91.093  1.00 34.12           N  
ATOM    436  CA  GLU A  59      24.521  18.713  92.032  1.00 35.50           C  
ATOM    437  C   GLU A  59      24.438  17.274  91.512  1.00 34.91           C  
ATOM    438  O   GLU A  59      25.427  16.534  91.576  1.00 35.26           O  
ATOM    439  CB  GLU A  59      23.979  18.890  93.468  1.00 35.48           C  
ATOM    440  CG  GLU A  59      22.786  18.023  93.871  1.00 37.11           C  
ATOM    441  CD  GLU A  59      22.482  18.101  95.370  1.00 38.15           C  
ATOM    442  OE1 GLU A  59      23.031  19.014  96.037  1.00 41.73           O  
ATOM    443  OE2 GLU A  59      21.693  17.255  95.877  1.00 40.69           O  
ATOM    444  N   SER A  60      23.282  16.911  90.955  1.00 34.41           N  
ATOM    445  CA  SER A  60      23.080  15.607  90.320  1.00 34.27           C  
ATOM    446  C   SER A  60      24.053  15.340  89.165  1.00 33.87           C  
ATOM    447  O   SER A  60      24.614  14.245  89.069  1.00 33.78           O  
ATOM    448  CB  SER A  60      21.623  15.463  89.848  1.00 34.49           C  
ATOM    449  OG  SER A  60      21.478  14.474  88.833  1.00 36.36           O  
ATOM    450  N   GLU A  61      24.256  16.341  88.308  1.00 32.93           N  
ATOM    451  CA  GLU A  61      25.038  16.191  87.083  1.00 32.91           C  
ATOM    452  C   GLU A  61      26.522  16.533  87.212  1.00 31.86           C  
ATOM    453  O   GLU A  61      27.311  16.148  86.348  1.00 31.30           O  
ATOM    454  CB  GLU A  61      24.452  17.071  85.977  1.00 32.95           C  
ATOM    455  CG  GLU A  61      23.165  16.558  85.372  1.00 35.12           C  
ATOM    456  CD  GLU A  61      22.564  17.531  84.365  1.00 35.68           C  
ATOM    457  OE1 GLU A  61      23.106  18.654  84.184  1.00 39.38           O  
ATOM    458  OE2 GLU A  61      21.535  17.164  83.752  1.00 39.85           O  
ATOM    459  N   ALA A  62      26.895  17.274  88.259  1.00 30.99           N  
ATOM    460  CA  ALA A  62      28.270  17.754  88.410  1.00 30.58           C  
ATOM    461  C   ALA A  62      28.801  17.800  89.854  1.00 30.83           C  
ATOM    462  O   ALA A  62      29.956  18.196  90.065  1.00 30.46           O  
ATOM    463  CB  ALA A  62      28.445  19.126  87.719  1.00 29.88           C  
ATOM    464  N   SER A  63      27.979  17.386  90.826  1.00 30.87           N  
ATOM    465  CA  SER A  63      28.381  17.337  92.256  1.00 31.83           C  
ATOM    466  C   SER A  63      28.882  18.668  92.843  1.00 32.47           C  
ATOM    467  O   SER A  63      29.590  18.689  93.855  1.00 32.43           O  
ATOM    468  CB  SER A  63      29.430  16.238  92.504  1.00 31.23           C  
ATOM    469  OG  SER A  63      28.977  14.992  92.023  1.00 30.28           O  
ATOM    470  N   ILE A  64      28.525  19.774  92.200  1.00 33.76           N  
ATOM    471  CA  ILE A  64      28.938  21.087  92.675  1.00 35.25           C  
ATOM    472  C   ILE A  64      28.343  21.321  94.064  1.00 36.38           C  
ATOM    473  O   ILE A  64      27.134  21.150  94.248  1.00 36.08           O  
ATOM    474  CB  ILE A  64      28.531  22.239  91.693  1.00 35.28           C  
ATOM    475  CG1 ILE A  64      29.027  21.956  90.272  1.00 34.78           C  
ATOM    476  CG2 ILE A  64      29.062  23.594  92.184  1.00 35.32           C  
ATOM    477  CD1 ILE A  64      30.536  21.930  90.118  1.00 35.04           C  
ATOM    478  N   PRO A  65      29.203  21.659  95.054  1.00 37.85           N  
ATOM    479  CA  PRO A  65      28.732  22.078  96.375  1.00 39.01           C  
ATOM    480  C   PRO A  65      27.933  23.378  96.283  1.00 40.41           C  
ATOM    481  O   PRO A  65      28.471  24.430  95.897  1.00 40.43           O  
ATOM    482  CB  PRO A  65      30.029  22.289  97.169  1.00 38.87           C  
ATOM    483  CG  PRO A  65      31.059  21.523  96.433  1.00 38.37           C  
ATOM    484  CD  PRO A  65      30.676  21.630  94.993  1.00 38.04           C  
ATOM    485  N   LEU A  66      26.652  23.278  96.624  1.00 42.02           N  
ATOM    486  CA  LEU A  66      25.694  24.374  96.510  1.00 43.67           C  
ATOM    487  C   LEU A  66      24.803  24.375  97.753  1.00 44.69           C  
ATOM    488  O   LEU A  66      23.987  23.468  97.935  1.00 44.93           O  
ATOM    489  CB  LEU A  66      24.826  24.188  95.255  1.00 43.71           C  
ATOM    490  CG  LEU A  66      25.459  23.938  93.878  1.00 43.96           C  
ATOM    491  CD1 LEU A  66      24.529  23.103  93.010  1.00 44.98           C  
ATOM    492  CD2 LEU A  66      25.830  25.228  93.159  1.00 44.19           C  
ATOM    493  N   SER A  67      24.960  25.383  98.605  1.00 46.12           N  
ATOM    494  CA  SER A  67      24.224  25.430  99.873  1.00 47.74           C  
ATOM    495  C   SER A  67      22.806  25.960  99.706  1.00 48.69           C  
ATOM    496  O   SER A  67      22.420  26.395  98.617  1.00 48.89           O  
ATOM    497  CB  SER A  67      24.974  26.274 100.909  1.00 47.66           C  
ATOM    498  OG  SER A  67      25.058  27.620 100.490  1.00 48.27           O  
ATOM    499  N   ALA A  68      22.037  25.909 100.794  1.00 49.92           N  
ATOM    500  CA  ALA A  68      20.691  26.477 100.854  1.00 51.00           C  
ATOM    501  C   ALA A  68      20.767  27.986 101.087  1.00 51.73           C  
ATOM    502  O   ALA A  68      19.815  28.719 100.814  1.00 51.94           O  
ATOM    503  CB  ALA A  68      19.896  25.810 101.959  1.00 51.14           C  
ATOM    504  N   SER A  69      21.918  28.433 101.592  1.00 52.58           N  
ATOM    505  CA  SER A  69      22.222  29.849 101.773  1.00 53.24           C  
ATOM    506  C   SER A  69      22.152  30.591 100.442  1.00 53.66           C  
ATOM    507  O   SER A  69      21.986  31.812 100.407  1.00 54.00           O  
ATOM    508  CB  SER A  69      23.625  30.006 102.361  1.00 53.45           C  
ATOM    509  OG  SER A  69      23.840  29.114 103.448  1.00 54.15           O  
ATOM    510  N   LEU A  70      22.278  29.837  99.353  1.00 53.71           N  
ATOM    511  CA  LEU A  70      22.306  30.388  98.008  1.00 53.77           C  
ATOM    512  C   LEU A  70      20.926  30.364  97.307  1.00 53.80           C  
ATOM    513  O   LEU A  70      20.770  30.860  96.184  1.00 53.96           O  
ATOM    514  CB  LEU A  70      23.447  29.722  97.219  1.00 53.89           C  
ATOM    515  CG  LEU A  70      23.410  29.163  95.799  1.00 54.11           C  
ATOM    516  CD1 LEU A  70      24.825  29.119  95.243  1.00 54.12           C  
ATOM    517  CD2 LEU A  70      22.820  27.778  95.801  1.00 54.49           C  
ATOM    518  N   LEU A  71      19.920  29.827  97.993  1.00 53.46           N  
ATOM    519  CA  LEU A  71      18.532  29.946  97.546  1.00 53.38           C  
ATOM    520  C   LEU A  71      17.964  31.333  97.860  1.00 53.31           C  
ATOM    521  O   LEU A  71      17.082  31.821  97.149  1.00 53.22           O  
ATOM    522  CB  LEU A  71      17.654  28.884  98.215  1.00 53.61           C  
ATOM    523  CG  LEU A  71      17.477  27.464  97.673  1.00 53.44           C  
ATOM    524  CD1 LEU A  71      18.743  26.908  97.058  1.00 53.42           C  
ATOM    525  CD2 LEU A  71      17.024  26.569  98.822  1.00 53.92           C  
ATOM    526  N   ASP A  72      18.464  31.952  98.929  1.00 52.97           N  
ATOM    527  CA  ASP A  72      17.975  33.260  99.377  1.00 52.89           C  
ATOM    528  C   ASP A  72      18.785  34.413  98.811  1.00 52.59           C  
ATOM    529  O   ASP A  72      18.271  35.518  98.680  1.00 52.60           O  
ATOM    530  CB  ASP A  72      17.973  33.352 100.903  1.00 53.15           C  
ATOM    531  CG  ASP A  72      17.183  32.238 101.550  1.00 53.87           C  
ATOM    532  OD1 ASP A  72      15.956  32.167 101.318  1.00 54.45           O  
ATOM    533  OD2 ASP A  72      17.798  31.431 102.286  1.00 55.08           O  
ATOM    534  N   LYS A  73      20.054  34.158  98.493  1.00 52.18           N  
ATOM    535  CA  LYS A  73      20.884  35.154  97.819  1.00 51.61           C  
ATOM    536  C   LYS A  73      20.295  35.477  96.444  1.00 50.84           C  
ATOM    537  O   LYS A  73      20.310  36.628  96.016  1.00 51.02           O  
ATOM    538  CB  LYS A  73      22.346  34.696  97.700  1.00 51.60           C  
ATOM    539  CG  LYS A  73      23.314  35.838  97.381  1.00 51.70           C  
ATOM    540  CD  LYS A  73      24.727  35.348  97.088  1.00 51.81           C  
ATOM    541  CE  LYS A  73      25.598  36.504  96.595  1.00 52.45           C  
ATOM    542  NZ  LYS A  73      27.054  36.193  96.654  1.00 52.23           N  
ATOM    543  N   SER A  74      19.760  34.458  95.777  1.00 50.02           N  
ATOM    544  CA  SER A  74      19.096  34.624  94.489  1.00 49.09           C  
ATOM    545  C   SER A  74      17.850  35.514  94.577  1.00 48.60           C  
ATOM    546  O   SER A  74      17.759  36.519  93.865  1.00 48.47           O  
ATOM    547  CB  SER A  74      18.723  33.265  93.915  1.00 48.92           C  
ATOM    548  OG  SER A  74      17.843  33.392  92.812  1.00 49.47           O  
ATOM    549  N   GLU A  75      16.903  35.134  95.442  1.00 47.74           N  
ATOM    550  CA  GLU A  75      15.617  35.827  95.577  1.00 46.96           C  
ATOM    551  C   GLU A  75      15.806  37.290  95.964  1.00 45.57           C  
ATOM    552  O   GLU A  75      15.160  38.166  95.395  1.00 45.09           O  
ATOM    553  CB  GLU A  75      14.702  35.122  96.589  1.00 46.88           C  
ATOM    554  CG  GLU A  75      13.228  35.577  96.526  1.00 48.17           C  
ATOM    555  CD  GLU A  75      12.458  35.362  97.840  1.00 48.97           C  
ATOM    556  OE1 GLU A  75      11.689  36.273  98.238  1.00 51.04           O  
ATOM    557  OE2 GLU A  75      12.617  34.290  98.478  1.00 51.88           O  
ATOM    558  N   LYS A  76      16.701  37.548  96.917  1.00 44.15           N  
ATOM    559  CA  LYS A  76      16.940  38.914  97.391  1.00 43.10           C  
ATOM    560  C   LYS A  76      17.766  39.754  96.414  1.00 41.53           C  
ATOM    561  O   LYS A  76      17.559  40.955  96.317  1.00 41.40           O  
ATOM    562  CB  LYS A  76      17.557  38.932  98.803  1.00 43.17           C  
ATOM    563  CG  LYS A  76      18.987  38.409  98.891  1.00 44.09           C  
ATOM    564  CD  LYS A  76      19.659  38.847 100.199  1.00 44.23           C  
ATOM    565  CE  LYS A  76      20.997  38.135 100.412  1.00 45.72           C  
ATOM    566  NZ  LYS A  76      20.838  36.724 100.914  1.00 45.80           N  
ATOM    567  N   LEU A  77      18.695  39.124  95.695  1.00 40.02           N  
ATOM    568  CA  LEU A  77      19.447  39.809  94.640  1.00 38.59           C  
ATOM    569  C   LEU A  77      18.504  40.176  93.494  1.00 37.22           C  
ATOM    570  O   LEU A  77      18.461  41.322  93.062  1.00 37.06           O  
ATOM    571  CB  LEU A  77      20.606  38.946  94.146  1.00 38.82           C  
ATOM    572  CG  LEU A  77      21.860  39.589  93.537  1.00 40.24           C  
ATOM    573  CD1 LEU A  77      22.221  40.925  94.183  1.00 40.47           C  
ATOM    574  CD2 LEU A  77      23.036  38.623  93.664  1.00 40.56           C  
ATOM    575  N   LEU A  78      17.718  39.207  93.043  1.00 35.60           N  
ATOM    576  CA  LEU A  78      16.673  39.444  92.064  1.00 34.36           C  
ATOM    577  C   LEU A  78      15.717  40.587  92.448  1.00 33.99           C  
ATOM    578  O   LEU A  78      15.462  41.466  91.625  1.00 33.63           O  
ATOM    579  CB  LEU A  78      15.890  38.160  91.823  1.00 34.19           C  
ATOM    580  CG  LEU A  78      14.906  38.161  90.658  1.00 33.80           C  
ATOM    581  CD1 LEU A  78      15.592  38.618  89.360  1.00 33.11           C  
ATOM    582  CD2 LEU A  78      14.268  36.782  90.510  1.00 33.68           C  
ATOM    583  N   ASP A  79      15.203  40.572  93.684  1.00 33.20           N  
ATOM    584  CA  ASP A  79      14.295  41.623  94.179  1.00 32.82           C  
ATOM    585  C   ASP A  79      14.895  43.005  93.961  1.00 31.44           C  
ATOM    586  O   ASP A  79      14.279  43.867  93.324  1.00 30.41           O  
ATOM    587  CB  ASP A  79      13.972  41.443  95.675  1.00 33.61           C  
ATOM    588  CG  ASP A  79      12.711  40.610  95.919  1.00 37.51           C  
ATOM    589  OD1 ASP A  79      12.660  39.911  96.967  1.00 40.38           O  
ATOM    590  OD2 ASP A  79      11.774  40.642  95.067  1.00 41.66           O  
HETATM  591  N   MSE A  80      16.106  43.183  94.495  1.00 30.00           N  
HETATM  592  CA  MSE A  80      16.850  44.421  94.382  1.00 28.83           C  
HETATM  593  C   MSE A  80      17.094  44.821  92.929  1.00 27.65           C  
HETATM  594  O   MSE A  80      16.856  45.967  92.543  1.00 26.91           O  
HETATM  595  CB  MSE A  80      18.184  44.300  95.125  1.00 28.81           C  
HETATM  596  CG  MSE A  80      18.971  45.603  95.169  1.00 32.33           C  
HETATM  597 SE   MSE A  80      20.102  45.843  93.591  0.60 39.33          SE  
HETATM  598  CE  MSE A  80      21.526  44.583  94.067  1.00 36.89           C  
ATOM    599  N   ARG A  81      17.573  43.880  92.122  0.50 27.19           N  
ATOM    601  CA  ARG A  81      17.910  44.207  90.744  0.50 26.91           C  
ATOM    603  C   ARG A  81      16.691  44.501  89.874  0.50 26.38           C  
ATOM    605  O   ARG A  81      16.770  45.323  88.966  0.50 25.88           O  
ATOM    607  CB  ARG A  81      18.814  43.151  90.119  0.50 26.95           C  
ATOM    609  CG  ARG A  81      20.272  43.527  90.200  0.50 27.96           C  
ATOM    611  CD  ARG A  81      21.003  43.094  88.950  0.50 29.69           C  
ATOM    613  NE  ARG A  81      21.783  41.878  89.146  0.50 31.09           N  
ATOM    615  CZ  ARG A  81      22.059  41.007  88.180  0.50 30.88           C  
ATOM    617  NH1 ARG A  81      21.590  41.191  86.949  0.50 30.25           N  
ATOM    619  NH2 ARG A  81      22.785  39.934  88.459  0.50 31.28           N  
ATOM    621  N   LEU A  82      15.570  43.838  90.157  1.00 26.10           N  
ATOM    622  CA  LEU A  82      14.325  44.126  89.451  1.00 26.12           C  
ATOM    623  C   LEU A  82      13.901  45.563  89.730  1.00 26.69           C  
ATOM    624  O   LEU A  82      13.646  46.327  88.805  1.00 26.03           O  
ATOM    625  CB  LEU A  82      13.206  43.146  89.829  1.00 25.91           C  
ATOM    626  CG  LEU A  82      13.326  41.730  89.253  1.00 26.05           C  
ATOM    627  CD1 LEU A  82      12.224  40.814  89.795  1.00 25.92           C  
ATOM    628  CD2 LEU A  82      13.337  41.706  87.709  1.00 24.33           C  
ATOM    629  N   GLU A  83      13.892  45.948  91.001  1.00 27.11           N  
ATOM    630  CA  GLU A  83      13.425  47.279  91.347  1.00 28.46           C  
ATOM    631  C   GLU A  83      14.322  48.364  90.746  1.00 27.30           C  
ATOM    632  O   GLU A  83      13.831  49.380  90.306  1.00 27.52           O  
ATOM    633  CB  GLU A  83      13.284  47.442  92.856  1.00 28.38           C  
ATOM    634  CG  GLU A  83      12.242  48.494  93.247  1.00 31.18           C  
ATOM    635  CD  GLU A  83      12.228  48.806  94.734  1.00 32.08           C  
ATOM    636  OE1 GLU A  83      12.525  47.899  95.541  1.00 36.34           O  
ATOM    637  OE2 GLU A  83      11.907  49.968  95.095  1.00 37.89           O  
ATOM    638  N   ARG A  84      15.626  48.121  90.690  1.00 26.43           N  
ATOM    639  CA  ARG A  84      16.565  49.108  90.153  1.00 25.77           C  
ATOM    640  C   ARG A  84      16.592  49.141  88.603  1.00 25.03           C  
ATOM    641  O   ARG A  84      16.667  50.212  88.006  1.00 24.46           O  
ATOM    642  CB  ARG A  84      17.972  48.822  90.707  1.00 25.94           C  
ATOM    643  CG  ARG A  84      18.994  49.952  90.522  1.00 26.48           C  
ATOM    644  CD  ARG A  84      20.412  49.465  90.783  1.00 26.76           C  
ATOM    645  NE  ARG A  84      20.745  48.300  89.962  1.00 30.00           N  
ATOM    646  CZ  ARG A  84      21.645  47.378  90.296  1.00 31.89           C  
ATOM    647  NH1 ARG A  84      22.326  47.490  91.431  1.00 33.14           N  
ATOM    648  NH2 ARG A  84      21.876  46.348  89.494  1.00 32.20           N  
ATOM    649  N   ASP A  85      16.536  47.972  87.964  1.00 23.13           N  
ATOM    650  CA  ASP A  85      16.933  47.852  86.555  1.00 22.70           C  
ATOM    651  C   ASP A  85      15.857  47.373  85.582  1.00 21.90           C  
ATOM    652  O   ASP A  85      16.054  47.464  84.380  1.00 21.91           O  
ATOM    653  CB  ASP A  85      18.085  46.858  86.396  1.00 21.95           C  
ATOM    654  CG  ASP A  85      19.317  47.237  87.177  1.00 22.99           C  
ATOM    655  OD1 ASP A  85      19.467  48.424  87.529  1.00 20.08           O  
ATOM    656  OD2 ASP A  85      20.151  46.327  87.409  1.00 22.41           O  
ATOM    657  N   VAL A  86      14.754  46.816  86.064  1.00 21.91           N  
ATOM    658  CA  VAL A  86      13.816  46.178  85.122  1.00 21.92           C  
ATOM    659  C   VAL A  86      13.271  47.136  84.038  1.00 21.69           C  
ATOM    660  O   VAL A  86      12.858  48.274  84.326  1.00 20.70           O  
ATOM    661  CB  VAL A  86      12.703  45.355  85.836  1.00 22.22           C  
ATOM    662  CG1 VAL A  86      11.532  46.226  86.254  1.00 22.27           C  
ATOM    663  CG2 VAL A  86      12.250  44.214  84.948  1.00 22.23           C  
ATOM    664  N   LYS A  87      13.299  46.647  82.794  1.00 21.53           N  
ATOM    665  CA  LYS A  87      12.857  47.392  81.624  1.00 21.21           C  
ATOM    666  C   LYS A  87      11.604  46.785  80.984  1.00 21.12           C  
ATOM    667  O   LYS A  87      11.458  45.558  80.918  1.00 20.50           O  
ATOM    668  CB  LYS A  87      13.972  47.400  80.563  1.00 21.64           C  
ATOM    669  CG  LYS A  87      15.300  48.018  81.006  1.00 24.01           C  
ATOM    670  CD  LYS A  87      15.102  49.476  81.413  1.00 29.14           C  
ATOM    671  CE  LYS A  87      16.434  50.199  81.587  1.00 31.12           C  
ATOM    672  NZ  LYS A  87      17.010  49.933  82.937  1.00 35.41           N  
ATOM    673  N   ILE A  88      10.743  47.653  80.468  1.00 20.21           N  
ATOM    674  CA  ILE A  88       9.632  47.243  79.606  1.00 20.41           C  
ATOM    675  C   ILE A  88      10.151  46.542  78.344  1.00 19.97           C  
ATOM    676  O   ILE A  88      11.225  46.837  77.854  1.00 20.22           O  
ATOM    677  CB  ILE A  88       8.731  48.464  79.223  1.00 19.90           C  
ATOM    678  CG1 ILE A  88       7.329  48.020  78.783  1.00 20.66           C  
ATOM    679  CG2 ILE A  88       9.389  49.341  78.155  1.00 21.86           C  
ATOM    680  CD1 ILE A  88       6.318  49.199  78.661  1.00 19.88           C  
ATOM    681  N   ILE A  89       9.365  45.616  77.817  1.00 19.71           N  
ATOM    682  CA  ILE A  89       9.692  44.959  76.568  1.00 19.43           C  
ATOM    683  C   ILE A  89       9.361  45.919  75.424  1.00 19.88           C  
ATOM    684  O   ILE A  89       8.325  46.589  75.460  1.00 18.80           O  
ATOM    685  CB  ILE A  89       8.925  43.599  76.470  1.00 19.17           C  
ATOM    686  CG1 ILE A  89       9.440  42.632  77.555  1.00 18.91           C  
ATOM    687  CG2 ILE A  89       9.012  42.977  75.066  1.00 18.61           C  
ATOM    688  CD1 ILE A  89      10.645  41.842  77.144  1.00 17.62           C  
ATOM    689  N   ASP A  90      10.257  45.998  74.434  1.00 20.24           N  
ATOM    690  CA  ASP A  90      10.019  46.776  73.209  1.00 21.26           C  
ATOM    691  C   ASP A  90       8.729  46.354  72.535  1.00 20.16           C  
ATOM    692  O   ASP A  90       8.422  45.161  72.445  1.00 19.94           O  
ATOM    693  CB  ASP A  90      11.144  46.579  72.183  1.00 22.47           C  
ATOM    694  CG  ASP A  90      12.501  47.119  72.651  1.00 27.44           C  
ATOM    695  OD1 ASP A  90      13.506  46.735  72.008  1.00 32.07           O  
ATOM    696  OD2 ASP A  90      12.586  47.892  73.647  1.00 31.71           O  
ATOM    697  N   GLY A  91       7.989  47.338  72.043  1.00 19.69           N  
ATOM    698  CA  GLY A  91       6.758  47.077  71.316  1.00 19.60           C  
ATOM    699  C   GLY A  91       5.522  46.868  72.174  1.00 19.66           C  
ATOM    700  O   GLY A  91       4.428  46.793  71.630  1.00 19.60           O  
ATOM    701  N   VAL A  92       5.677  46.786  73.501  1.00 19.47           N  
ATOM    702  CA  VAL A  92       4.494  46.676  74.371  1.00 19.92           C  
ATOM    703  C   VAL A  92       3.565  47.891  74.181  1.00 19.62           C  
ATOM    704  O   VAL A  92       2.386  47.724  73.817  1.00 18.89           O  
ATOM    705  CB  VAL A  92       4.836  46.389  75.850  1.00 19.49           C  
ATOM    706  CG1 VAL A  92       3.583  46.532  76.732  1.00 20.85           C  
ATOM    707  CG2 VAL A  92       5.426  45.002  75.987  1.00 19.62           C  
ATOM    708  N   LYS A  93       4.083  49.098  74.379  0.50 19.78           N  
ATOM    710  CA  LYS A  93       3.241  50.289  74.220  0.50 19.90           C  
ATOM    712  C   LYS A  93       2.716  50.420  72.772  0.50 19.81           C  
ATOM    714  O   LYS A  93       1.614  50.936  72.563  0.50 19.48           O  
ATOM    716  CB  LYS A  93       3.951  51.563  74.713  0.50 20.36           C  
ATOM    718  CG  LYS A  93       4.531  51.469  76.160  0.50 21.09           C  
ATOM    720  CD  LYS A  93       3.645  52.113  77.254  0.50 21.68           C  
ATOM    722  CE  LYS A  93       4.417  52.237  78.577  0.50 21.15           C  
ATOM    724  NZ  LYS A  93       4.066  53.416  79.448  0.50 21.91           N  
ATOM    726  N   PHE A  94       3.469  49.912  71.787  1.00 19.48           N  
ATOM    727  CA  PHE A  94       2.979  49.878  70.397  1.00 20.19           C  
ATOM    728  C   PHE A  94       1.768  48.968  70.290  1.00 20.03           C  
ATOM    729  O   PHE A  94       0.736  49.366  69.739  1.00 20.46           O  
ATOM    730  CB  PHE A  94       4.062  49.421  69.412  1.00 20.79           C  
ATOM    731  CG  PHE A  94       3.578  49.315  67.969  1.00 21.68           C  
ATOM    732  CD1 PHE A  94       3.786  50.362  67.071  1.00 24.77           C  
ATOM    733  CD2 PHE A  94       2.935  48.171  67.511  1.00 21.70           C  
ATOM    734  CE1 PHE A  94       3.374  50.264  65.755  1.00 24.15           C  
ATOM    735  CE2 PHE A  94       2.512  48.065  66.196  1.00 22.79           C  
ATOM    736  CZ  PHE A  94       2.723  49.115  65.316  1.00 23.49           C  
ATOM    737  N   ALA A  95       1.901  47.753  70.819  1.00 19.18           N  
ATOM    738  CA  ALA A  95       0.823  46.783  70.783  1.00 19.59           C  
ATOM    739  C   ALA A  95      -0.417  47.339  71.470  1.00 19.87           C  
ATOM    740  O   ALA A  95      -1.510  47.371  70.872  1.00 21.70           O  
ATOM    741  CB  ALA A  95       1.249  45.449  71.437  1.00 18.85           C  
ATOM    742  N   LEU A  96      -0.253  47.758  72.721  1.00 19.00           N  
ATOM    743  CA  LEU A  96      -1.358  48.293  73.535  1.00 19.27           C  
ATOM    744  C   LEU A  96      -2.058  49.486  72.900  1.00 18.57           C  
ATOM    745  O   LEU A  96      -3.254  49.666  73.090  1.00 18.79           O  
ATOM    746  CB  LEU A  96      -0.886  48.662  74.950  1.00 18.75           C  
ATOM    747  CG  LEU A  96      -0.389  47.493  75.791  1.00 20.72           C  
ATOM    748  CD1 LEU A  96       0.090  48.002  77.147  1.00 20.32           C  
ATOM    749  CD2 LEU A  96      -1.448  46.427  75.949  1.00 19.96           C  
ATOM    750  N   SER A  97      -1.310  50.280  72.142  0.50 19.05           N  
ATOM    752  CA  SER A  97      -1.889  51.391  71.394  0.50 19.33           C  
ATOM    754  C   SER A  97      -2.878  50.911  70.337  0.50 19.23           C  
ATOM    756  O   SER A  97      -3.894  51.556  70.106  0.50 19.54           O  
ATOM    758  CB  SER A  97      -0.796  52.232  70.737  0.50 19.36           C  
ATOM    760  OG  SER A  97      -0.009  52.877  71.721  0.50 20.48           O  
ATOM    762  N   ARG A  98      -2.583  49.775  69.712  0.50 19.08           N  
ATOM    764  CA  ARG A  98      -3.341  49.313  68.538  0.50 19.41           C  
ATOM    766  C   ARG A  98      -4.508  48.363  68.848  0.50 19.08           C  
ATOM    768  O   ARG A  98      -5.552  48.406  68.182  0.50 19.52           O  
ATOM    770  CB  ARG A  98      -2.396  48.648  67.523  0.50 19.57           C  
ATOM    772  CG  ARG A  98      -1.271  49.532  66.956  0.50 21.48           C  
ATOM    774  CD  ARG A  98      -1.746  50.467  65.841  0.50 25.32           C  
ATOM    776  NE  ARG A  98      -0.687  50.759  64.864  0.50 27.95           N  
ATOM    778  CZ  ARG A  98      -0.628  50.256  63.628  0.50 28.62           C  
ATOM    780  NH1 ARG A  98       0.380  50.581  62.832  0.50 30.23           N  
ATOM    782  NH2 ARG A  98      -1.566  49.433  63.178  0.50 28.75           N  
ATOM    784  N   LEU A  99      -4.333  47.511  69.852  1.00 19.05           N  
ATOM    785  CA  LEU A  99      -5.300  46.460  70.167  1.00 18.75           C  
ATOM    786  C   LEU A  99      -6.586  47.047  70.747  1.00 18.96           C  
ATOM    787  O   LEU A  99      -6.550  47.973  71.568  1.00 18.49           O  
ATOM    788  CB  LEU A  99      -4.679  45.477  71.168  1.00 18.64           C  
ATOM    789  CG  LEU A  99      -3.434  44.659  70.745  1.00 20.14           C  
ATOM    790  CD1 LEU A  99      -2.725  44.081  71.987  1.00 20.66           C  
ATOM    791  CD2 LEU A  99      -3.828  43.583  69.768  1.00 22.70           C  
ATOM    792  N   THR A 100      -7.725  46.511  70.325  1.00 18.87           N  
ATOM    793  CA  THR A 100      -9.020  46.982  70.825  1.00 19.61           C  
ATOM    794  C   THR A 100      -9.590  46.050  71.907  1.00 19.55           C  
ATOM    795  O   THR A 100     -10.569  46.389  72.594  1.00 20.85           O  
ATOM    796  CB  THR A 100     -10.059  47.102  69.675  1.00 19.66           C  
ATOM    797  OG1 THR A 100     -10.154  45.847  68.993  1.00 21.92           O  
ATOM    798  CG2 THR A 100      -9.632  48.161  68.671  1.00 20.24           C  
ATOM    799  N   THR A 101      -8.989  44.872  72.043  1.00 18.87           N  
ATOM    800  CA  THR A 101      -9.468  43.847  72.957  1.00 18.32           C  
ATOM    801  C   THR A 101      -9.060  44.182  74.391  1.00 17.70           C  
ATOM    802  O   THR A 101      -7.959  44.678  74.601  1.00 17.21           O  
ATOM    803  CB  THR A 101      -8.879  42.476  72.545  1.00 19.03           C  
ATOM    804  OG1 THR A 101      -9.083  42.288  71.139  1.00 19.35           O  
ATOM    805  CG2 THR A 101      -9.555  41.336  73.280  1.00 17.93           C  
ATOM    806  N   PRO A 102      -9.968  43.944  75.375  1.00 17.36           N  
ATOM    807  CA  PRO A 102      -9.671  44.082  76.804  1.00 17.44           C  
ATOM    808  C   PRO A 102      -8.503  43.190  77.196  1.00 17.72           C  
ATOM    809  O   PRO A 102      -8.215  42.205  76.503  1.00 17.82           O  
ATOM    810  CB  PRO A 102     -10.958  43.589  77.480  1.00 17.74           C  
ATOM    811  CG  PRO A 102     -12.001  43.759  76.488  1.00 17.54           C  
ATOM    812  CD  PRO A 102     -11.370  43.542  75.151  1.00 16.84           C  
ATOM    813  N   ARG A 103      -7.823  43.528  78.290  1.00 17.38           N  
ATOM    814  CA  ARG A 103      -6.590  42.838  78.621  1.00 18.27           C  
ATOM    815  C   ARG A 103      -6.492  42.610  80.117  1.00 17.57           C  
ATOM    816  O   ARG A 103      -7.110  43.334  80.912  1.00 17.43           O  
ATOM    817  CB  ARG A 103      -5.383  43.654  78.164  1.00 17.64           C  
ATOM    818  CG  ARG A 103      -5.190  44.937  79.010  1.00 19.62           C  
ATOM    819  CD  ARG A 103      -4.136  45.873  78.442  1.00 19.14           C  
ATOM    820  NE  ARG A 103      -4.654  46.626  77.304  1.00 22.49           N  
ATOM    821  CZ  ARG A 103      -5.063  47.893  77.359  1.00 23.41           C  
ATOM    822  NH1 ARG A 103      -5.517  48.491  76.252  1.00 22.76           N  
ATOM    823  NH2 ARG A 103      -5.016  48.556  78.512  1.00 22.44           N  
ATOM    824  N   CYS A 104      -5.721  41.604  80.488  1.00 16.71           N  
ATOM    825  CA  CYS A 104      -5.346  41.421  81.876  1.00 18.27           C  
ATOM    826  C   CYS A 104      -4.022  40.695  81.996  1.00 17.65           C  
ATOM    827  O   CYS A 104      -3.435  40.240  80.994  1.00 16.85           O  
ATOM    828  CB  CYS A 104      -6.443  40.707  82.676  1.00 18.78           C  
ATOM    829  SG  CYS A 104      -6.581  38.974  82.394  1.00 22.34           S  
ATOM    830  N   ILE A 105      -3.545  40.620  83.228  1.00 16.61           N  
ATOM    831  CA  ILE A 105      -2.324  39.912  83.536  1.00 16.87           C  
ATOM    832  C   ILE A 105      -2.651  38.735  84.433  1.00 17.46           C  
ATOM    833  O   ILE A 105      -3.355  38.912  85.434  1.00 17.29           O  
ATOM    834  CB  ILE A 105      -1.298  40.826  84.217  1.00 16.61           C  
ATOM    835  CG1 ILE A 105      -0.704  41.773  83.165  1.00 16.72           C  
ATOM    836  CG2 ILE A 105      -0.193  39.995  84.891  1.00 16.53           C  
ATOM    837  CD1 ILE A 105       0.169  42.894  83.764  1.00 14.08           C  
ATOM    838  N   CYS A 106      -2.185  37.544  84.032  1.00 17.32           N  
ATOM    839  CA  CYS A 106      -2.180  36.368  84.894  1.00 18.68           C  
ATOM    840  C   CYS A 106      -0.760  35.841  85.013  1.00 19.78           C  
ATOM    841  O   CYS A 106      -0.138  35.422  84.023  1.00 20.45           O  
ATOM    842  CB  CYS A 106      -3.089  35.266  84.372  1.00 18.06           C  
ATOM    843  SG  CYS A 106      -4.820  35.723  84.238  1.00 20.94           S  
ATOM    844  N   SER A 107      -0.251  35.850  86.235  1.00 20.28           N  
ATOM    845  CA  SER A 107       1.142  35.523  86.479  1.00 20.65           C  
ATOM    846  C   SER A 107       1.340  34.611  87.695  1.00 20.42           C  
ATOM    847  O   SER A 107       0.521  34.598  88.618  1.00 19.70           O  
ATOM    848  CB  SER A 107       1.915  36.812  86.707  1.00 20.37           C  
ATOM    849  OG  SER A 107       3.259  36.513  87.014  1.00 22.04           O  
ATOM    850  N   ASN A 108       2.445  33.869  87.679  1.00 20.89           N  
ATOM    851  CA  ASN A 108       2.903  33.098  88.831  1.00 21.77           C  
ATOM    852  C   ASN A 108       3.636  33.956  89.854  1.00 22.39           C  
ATOM    853  O   ASN A 108       3.793  33.535  91.013  1.00 23.59           O  
ATOM    854  CB  ASN A 108       3.840  31.974  88.401  1.00 21.28           C  
ATOM    855  CG  ASN A 108       3.111  30.704  88.041  1.00 21.89           C  
ATOM    856  OD1 ASN A 108       1.874  30.628  88.075  1.00 20.22           O  
ATOM    857  ND2 ASN A 108       3.879  29.681  87.695  1.00 20.22           N  
ATOM    858  N   SER A 109       4.115  35.131  89.438  1.00 22.48           N  
ATOM    859  CA  SER A 109       4.768  36.066  90.374  1.00 22.24           C  
ATOM    860  C   SER A 109       3.805  36.541  91.471  1.00 22.26           C  
ATOM    861  O   SER A 109       2.597  36.651  91.237  1.00 21.81           O  
ATOM    862  CB  SER A 109       5.338  37.266  89.632  1.00 21.95           C  
ATOM    863  OG  SER A 109       6.394  36.854  88.779  1.00 24.19           O  
ATOM    864  N   SER A 110       4.346  36.812  92.664  1.00 22.08           N  
ATOM    865  CA  SER A 110       3.551  37.342  93.772  1.00 22.26           C  
ATOM    866  C   SER A 110       2.961  38.677  93.347  1.00 22.87           C  
ATOM    867  O   SER A 110       3.493  39.330  92.453  1.00 22.15           O  
ATOM    868  CB  SER A 110       4.419  37.554  95.022  1.00 22.12           C  
ATOM    869  OG  SER A 110       5.337  38.626  94.811  1.00 21.74           O  
ATOM    870  N   SER A 111       1.876  39.084  94.011  1.00 23.82           N  
ATOM    871  CA  SER A 111       1.208  40.356  93.742  1.00 24.78           C  
ATOM    872  C   SER A 111       2.139  41.533  94.000  1.00 25.03           C  
ATOM    873  O   SER A 111       2.120  42.523  93.260  1.00 24.64           O  
ATOM    874  CB  SER A 111      -0.055  40.493  94.601  1.00 24.77           C  
ATOM    875  OG  SER A 111      -1.145  39.810  93.994  1.00 28.39           O  
ATOM    876  N   HIS A 112       2.936  41.420  95.062  1.00 26.27           N  
ATOM    877  CA  HIS A 112       3.912  42.447  95.418  1.00 27.61           C  
ATOM    878  C   HIS A 112       4.938  42.646  94.296  1.00 27.30           C  
ATOM    879  O   HIS A 112       5.197  43.778  93.884  1.00 27.41           O  
ATOM    880  CB  HIS A 112       4.625  42.092  96.721  1.00 28.61           C  
ATOM    881  CG  HIS A 112       5.918  42.820  96.917  1.00 32.65           C  
ATOM    882  ND1 HIS A 112       5.975  44.147  97.292  1.00 36.63           N  
ATOM    883  CD2 HIS A 112       7.204  42.407  96.791  1.00 35.75           C  
ATOM    884  CE1 HIS A 112       7.241  44.520  97.395  1.00 36.96           C  
ATOM    885  NE2 HIS A 112       8.006  43.483  97.096  1.00 38.52           N  
ATOM    886  N   ARG A 113       5.516  41.550  93.800  1.00 26.62           N  
ATOM    887  CA  ARG A 113       6.477  41.665  92.707  1.00 26.01           C  
ATOM    888  C   ARG A 113       5.846  42.268  91.446  1.00 25.27           C  
ATOM    889  O   ARG A 113       6.436  43.139  90.798  1.00 24.61           O  
ATOM    890  CB  ARG A 113       7.140  40.329  92.397  1.00 25.80           C  
ATOM    891  CG  ARG A 113       8.346  40.524  91.507  1.00 28.90           C  
ATOM    892  CD  ARG A 113       9.191  39.307  91.439  1.00 33.43           C  
ATOM    893  NE  ARG A 113      10.105  39.226  92.572  1.00 37.13           N  
ATOM    894  CZ  ARG A 113      10.917  38.198  92.772  1.00 37.93           C  
ATOM    895  NH1 ARG A 113      11.733  38.178  93.817  1.00 39.40           N  
ATOM    896  NH2 ARG A 113      10.911  37.194  91.906  1.00 37.84           N  
ATOM    897  N   LEU A 114       4.644  41.808  91.108  1.00 24.48           N  
ATOM    898  CA  LEU A 114       3.920  42.344  89.966  1.00 24.29           C  
ATOM    899  C   LEU A 114       3.722  43.839  90.105  1.00 24.41           C  
ATOM    900  O   LEU A 114       3.966  44.598  89.175  1.00 23.67           O  
ATOM    901  CB  LEU A 114       2.564  41.645  89.806  1.00 23.72           C  
ATOM    902  CG  LEU A 114       2.582  40.192  89.366  1.00 22.59           C  
ATOM    903  CD1 LEU A 114       1.177  39.574  89.456  1.00 20.88           C  
ATOM    904  CD2 LEU A 114       3.144  40.101  87.959  1.00 21.45           C  
ATOM    905  N   ASP A 115       3.281  44.259  91.284  1.00 25.28           N  
ATOM    906  CA  ASP A 115       3.047  45.663  91.539  1.00 26.41           C  
ATOM    907  C   ASP A 115       4.348  46.451  91.378  1.00 26.58           C  
ATOM    908  O   ASP A 115       4.385  47.482  90.708  1.00 27.02           O  
ATOM    909  CB  ASP A 115       2.461  45.843  92.937  1.00 27.24           C  
ATOM    910  CG  ASP A 115       2.105  47.273  93.233  1.00 29.45           C  
ATOM    911  OD1 ASP A 115       1.217  47.828  92.567  1.00 29.90           O  
ATOM    912  OD2 ASP A 115       2.731  47.842  94.141  1.00 33.47           O  
HETATM  913  N   MSE A 116       5.426  45.944  91.956  1.00 26.70           N  
HETATM  914  CA  MSE A 116       6.687  46.652  91.901  1.00 26.77           C  
HETATM  915  C   MSE A 116       7.193  46.823  90.458  1.00 25.76           C  
HETATM  916  O   MSE A 116       7.583  47.926  90.076  1.00 24.78           O  
HETATM  917  CB  MSE A 116       7.706  45.970  92.828  1.00 28.05           C  
HETATM  918  CG  MSE A 116       9.086  46.603  92.835  1.00 31.70           C  
HETATM  919 SE   MSE A 116      10.189  45.664  91.549  0.70 42.98          SE  
HETATM  920  CE  MSE A 116      10.501  44.053  92.642  1.00 37.83           C  
HETATM  921  N   MSE A 117       7.169  45.747  89.661  1.00 24.73           N  
HETATM  922  CA  MSE A 117       7.660  45.792  88.276  1.00 24.67           C  
HETATM  923  C   MSE A 117       6.787  46.681  87.379  1.00 23.82           C  
HETATM  924  O   MSE A 117       7.304  47.526  86.652  1.00 23.67           O  
HETATM  925  CB  MSE A 117       7.765  44.389  87.677  1.00 24.02           C  
HETATM  926  CG  MSE A 117       8.728  43.455  88.421  1.00 24.38           C  
HETATM  927 SE   MSE A 117       8.939  41.772  87.506  0.80 27.85          SE  
HETATM  928  CE  MSE A 117       7.096  41.093  87.627  1.00 23.87           C  
ATOM    929  N   LEU A 118       5.472  46.481  87.440  1.00 22.79           N  
ATOM    930  CA  LEU A 118       4.526  47.202  86.601  1.00 22.65           C  
ATOM    931  C   LEU A 118       4.461  48.706  86.905  1.00 22.96           C  
ATOM    932  O   LEU A 118       4.294  49.523  85.998  1.00 22.47           O  
ATOM    933  CB  LEU A 118       3.139  46.569  86.713  1.00 22.07           C  
ATOM    934  CG  LEU A 118       3.031  45.154  86.146  1.00 22.46           C  
ATOM    935  CD1 LEU A 118       1.726  44.515  86.595  1.00 22.63           C  
ATOM    936  CD2 LEU A 118       3.129  45.175  84.638  1.00 21.55           C  
ATOM    937  N   THR A 119       4.588  49.060  88.181  1.00 23.40           N  
ATOM    938  CA  THR A 119       4.657  50.460  88.570  1.00 24.81           C  
ATOM    939  C   THR A 119       5.940  51.066  87.976  1.00 25.15           C  
ATOM    940  O   THR A 119       5.875  52.105  87.280  1.00 24.73           O  
ATOM    941  CB  THR A 119       4.581  50.653  90.119  1.00 25.33           C  
ATOM    942  OG1 THR A 119       3.281  50.262  90.600  1.00 26.50           O  
ATOM    943  CG2 THR A 119       4.836  52.113  90.516  1.00 25.89           C  
ATOM    944  N   LYS A 120       7.077  50.394  88.197  1.00 25.03           N  
ATOM    945  CA  LYS A 120       8.370  50.912  87.715  1.00 25.74           C  
ATOM    946  C   LYS A 120       8.354  51.257  86.233  1.00 25.71           C  
ATOM    947  O   LYS A 120       8.770  52.357  85.853  1.00 26.22           O  
ATOM    948  CB  LYS A 120       9.527  49.949  87.985  1.00 26.23           C  
ATOM    949  CG  LYS A 120      10.859  50.553  87.536  1.00 27.94           C  
ATOM    950  CD  LYS A 120      12.041  49.629  87.700  1.00 30.38           C  
ATOM    951  CE  LYS A 120      13.342  50.362  87.279  1.00 31.47           C  
ATOM    952  NZ  LYS A 120      13.383  50.646  85.819  1.00 31.71           N  
ATOM    953  N   VAL A 121       7.865  50.330  85.402  1.00 24.91           N  
ATOM    954  CA  VAL A 121       7.885  50.503  83.953  1.00 24.39           C  
ATOM    955  C   VAL A 121       6.664  51.291  83.469  1.00 24.82           C  
ATOM    956  O   VAL A 121       6.474  51.479  82.256  1.00 25.10           O  
ATOM    957  CB  VAL A 121       7.969  49.124  83.190  1.00 24.76           C  
ATOM    958  CG1 VAL A 121       9.182  48.329  83.640  1.00 23.36           C  
ATOM    959  CG2 VAL A 121       6.687  48.292  83.385  1.00 23.04           C  
ATOM    960  N   GLY A 122       5.830  51.720  84.413  1.00 24.60           N  
ATOM    961  CA  GLY A 122       4.669  52.537  84.107  1.00 24.18           C  
ATOM    962  C   GLY A 122       3.505  51.831  83.427  1.00 24.07           C  
ATOM    963  O   GLY A 122       2.669  52.486  82.798  1.00 24.65           O  
ATOM    964  N   LEU A 123       3.431  50.508  83.554  1.00 23.56           N  
ATOM    965  CA  LEU A 123       2.348  49.753  82.920  1.00 22.96           C  
ATOM    966  C   LEU A 123       1.144  49.517  83.806  1.00 23.01           C  
ATOM    967  O   LEU A 123       0.068  49.164  83.299  1.00 22.55           O  
ATOM    968  CB  LEU A 123       2.834  48.394  82.396  1.00 22.17           C  
ATOM    969  CG  LEU A 123       3.538  48.374  81.049  1.00 22.20           C  
ATOM    970  CD1 LEU A 123       4.088  46.947  80.765  1.00 18.88           C  
ATOM    971  CD2 LEU A 123       2.603  48.874  79.929  1.00 19.92           C  
ATOM    972  N   LYS A 124       1.313  49.670  85.120  1.00 23.36           N  
ATOM    973  CA  LYS A 124       0.238  49.298  86.050  1.00 24.18           C  
ATOM    974  C   LYS A 124      -1.138  49.895  85.707  1.00 23.77           C  
ATOM    975  O   LYS A 124      -2.127  49.154  85.723  1.00 23.58           O  
ATOM    976  CB  LYS A 124       0.602  49.569  87.512  1.00 24.22           C  
ATOM    977  CG  LYS A 124      -0.402  48.977  88.507  1.00 25.97           C  
ATOM    978  CD  LYS A 124       0.053  49.202  89.954  1.00 26.07           C  
ATOM    979  CE  LYS A 124      -1.108  49.523  90.879  1.00 30.79           C  
ATOM    980  NZ  LYS A 124      -0.595  49.955  92.237  1.00 31.65           N  
ATOM    981  N   PRO A 125      -1.206  51.220  85.395  1.00 23.77           N  
ATOM    982  CA  PRO A 125      -2.505  51.829  85.116  1.00 23.21           C  
ATOM    983  C   PRO A 125      -3.211  51.231  83.915  1.00 22.89           C  
ATOM    984  O   PRO A 125      -4.419  51.401  83.790  1.00 22.22           O  
ATOM    985  CB  PRO A 125      -2.163  53.296  84.811  1.00 23.89           C  
ATOM    986  CG  PRO A 125      -0.814  53.529  85.415  1.00 24.32           C  
ATOM    987  CD  PRO A 125      -0.110  52.214  85.313  1.00 23.62           C  
ATOM    988  N   TYR A 126      -2.477  50.542  83.041  1.00 22.04           N  
ATOM    989  CA  TYR A 126      -3.110  49.922  81.858  1.00 21.71           C  
ATOM    990  C   TYR A 126      -3.680  48.534  82.104  1.00 20.37           C  
ATOM    991  O   TYR A 126      -4.346  47.970  81.216  1.00 19.92           O  
ATOM    992  CB  TYR A 126      -2.178  49.931  80.649  1.00 22.62           C  
ATOM    993  CG  TYR A 126      -1.734  51.336  80.333  1.00 25.84           C  
ATOM    994  CD1 TYR A 126      -0.514  51.821  80.795  1.00 26.81           C  
ATOM    995  CD2 TYR A 126      -2.564  52.206  79.622  1.00 27.69           C  
ATOM    996  CE1 TYR A 126      -0.109  53.133  80.527  1.00 27.61           C  
ATOM    997  CE2 TYR A 126      -2.171  53.513  79.353  1.00 26.95           C  
ATOM    998  CZ  TYR A 126      -0.953  53.966  79.805  1.00 27.44           C  
ATOM    999  OH  TYR A 126      -0.573  55.262  79.534  1.00 28.53           O  
ATOM   1000  N   PHE A 127      -3.457  48.020  83.312  1.00 18.90           N  
ATOM   1001  CA  PHE A 127      -3.933  46.696  83.696  1.00 18.87           C  
ATOM   1002  C   PHE A 127      -4.766  46.671  84.974  1.00 19.09           C  
ATOM   1003  O   PHE A 127      -5.766  45.976  85.023  1.00 19.01           O  
ATOM   1004  CB  PHE A 127      -2.763  45.708  83.777  1.00 18.41           C  
ATOM   1005  CG  PHE A 127      -2.107  45.420  82.428  1.00 18.18           C  
ATOM   1006  CD1 PHE A 127      -1.028  46.184  81.986  1.00 15.59           C  
ATOM   1007  CD2 PHE A 127      -2.591  44.388  81.601  1.00 18.53           C  
ATOM   1008  CE1 PHE A 127      -0.416  45.911  80.758  1.00 18.65           C  
ATOM   1009  CE2 PHE A 127      -1.996  44.123  80.365  1.00 16.68           C  
ATOM   1010  CZ  PHE A 127      -0.903  44.889  79.946  1.00 17.27           C  
ATOM   1011  N   ALA A 128      -4.377  47.441  85.992  1.00 19.51           N  
ATOM   1012  CA  ALA A 128      -5.114  47.451  87.282  1.00 20.68           C  
ATOM   1013  C   ALA A 128      -6.607  47.746  87.097  1.00 20.74           C  
ATOM   1014  O   ALA A 128      -6.974  48.599  86.278  1.00 21.14           O  
ATOM   1015  CB  ALA A 128      -4.488  48.448  88.281  1.00 19.79           C  
ATOM   1016  N   PRO A 129      -7.476  47.052  87.846  1.00 21.06           N  
ATOM   1017  CA  PRO A 129      -7.222  46.073  88.903  1.00 21.53           C  
ATOM   1018  C   PRO A 129      -7.113  44.624  88.377  1.00 21.40           C  
ATOM   1019  O   PRO A 129      -7.157  43.669  89.164  1.00 22.27           O  
ATOM   1020  CB  PRO A 129      -8.474  46.209  89.766  1.00 21.49           C  
ATOM   1021  CG  PRO A 129      -9.556  46.413  88.737  1.00 20.55           C  
ATOM   1022  CD  PRO A 129      -8.929  47.257  87.649  1.00 21.40           C  
ATOM   1023  N   HIS A 130      -6.932  44.465  87.070  1.00 21.38           N  
ATOM   1024  CA  HIS A 130      -6.946  43.147  86.448  1.00 20.94           C  
ATOM   1025  C   HIS A 130      -5.533  42.568  86.353  1.00 20.59           C  
ATOM   1026  O   HIS A 130      -5.028  42.277  85.258  1.00 19.40           O  
ATOM   1027  CB  HIS A 130      -7.611  43.237  85.078  1.00 21.63           C  
ATOM   1028  CG  HIS A 130      -8.965  43.863  85.121  1.00 24.36           C  
ATOM   1029  ND1 HIS A 130     -10.020  43.296  85.802  1.00 27.29           N  
ATOM   1030  CD2 HIS A 130      -9.436  45.016  84.583  1.00 26.82           C  
ATOM   1031  CE1 HIS A 130     -11.084  44.071  85.677  1.00 28.54           C  
ATOM   1032  NE2 HIS A 130     -10.758  45.117  84.938  1.00 26.58           N  
ATOM   1033  N   ILE A 131      -4.915  42.419  87.524  1.00 19.53           N  
ATOM   1034  CA  ILE A 131      -3.567  41.883  87.673  1.00 19.44           C  
ATOM   1035  C   ILE A 131      -3.683  40.737  88.681  1.00 20.35           C  
ATOM   1036  O   ILE A 131      -3.872  40.967  89.889  1.00 20.40           O  
ATOM   1037  CB  ILE A 131      -2.560  42.972  88.180  1.00 19.37           C  
ATOM   1038  CG1 ILE A 131      -2.563  44.204  87.257  1.00 18.38           C  
ATOM   1039  CG2 ILE A 131      -1.154  42.402  88.272  1.00 18.38           C  
ATOM   1040  CD1 ILE A 131      -1.849  45.431  87.808  1.00 18.50           C  
ATOM   1041  N   TYR A 132      -3.586  39.509  88.174  1.00 20.68           N  
ATOM   1042  CA  TYR A 132      -3.933  38.302  88.935  1.00 20.50           C  
ATOM   1043  C   TYR A 132      -2.730  37.429  89.169  1.00 20.45           C  
ATOM   1044  O   TYR A 132      -2.043  37.027  88.224  1.00 20.31           O  
ATOM   1045  CB  TYR A 132      -5.043  37.512  88.229  1.00 21.03           C  
ATOM   1046  CG  TYR A 132      -6.259  38.360  87.967  1.00 22.47           C  
ATOM   1047  CD1 TYR A 132      -6.624  38.730  86.670  1.00 21.66           C  
ATOM   1048  CD2 TYR A 132      -7.027  38.830  89.021  1.00 22.57           C  
ATOM   1049  CE1 TYR A 132      -7.747  39.539  86.454  1.00 21.22           C  
ATOM   1050  CE2 TYR A 132      -8.129  39.619  88.806  1.00 23.59           C  
ATOM   1051  CZ  TYR A 132      -8.483  39.975  87.538  1.00 22.97           C  
ATOM   1052  OH  TYR A 132      -9.603  40.763  87.391  1.00 23.47           O  
ATOM   1053  N   SER A 133      -2.462  37.171  90.447  1.00 20.60           N  
ATOM   1054  CA  SER A 133      -1.353  36.326  90.851  1.00 20.84           C  
ATOM   1055  C   SER A 133      -1.869  34.956  91.267  1.00 21.35           C  
ATOM   1056  O   SER A 133      -2.792  34.849  92.086  1.00 21.82           O  
ATOM   1057  CB  SER A 133      -0.579  36.968  92.003  1.00 20.52           C  
ATOM   1058  OG  SER A 133       0.331  36.032  92.563  1.00 20.01           O  
ATOM   1059  N   ALA A 134      -1.276  33.914  90.686  1.00 21.83           N  
ATOM   1060  CA  ALA A 134      -1.582  32.536  91.037  1.00 22.85           C  
ATOM   1061  C   ALA A 134      -1.228  32.206  92.498  1.00 24.06           C  
ATOM   1062  O   ALA A 134      -1.779  31.261  93.057  1.00 24.45           O  
ATOM   1063  CB  ALA A 134      -0.878  31.579  90.072  1.00 22.73           C  
ATOM   1064  N   LYS A 135      -0.343  33.001  93.110  1.00 24.96           N  
ATOM   1065  CA  LYS A 135      -0.021  32.884  94.547  1.00 26.49           C  
ATOM   1066  C   LYS A 135      -1.168  33.341  95.469  1.00 26.91           C  
ATOM   1067  O   LYS A 135      -1.263  32.884  96.603  1.00 27.69           O  
ATOM   1068  CB  LYS A 135       1.261  33.647  94.892  1.00 26.06           C  
ATOM   1069  CG  LYS A 135       2.507  33.135  94.172  1.00 29.27           C  
ATOM   1070  CD  LYS A 135       3.769  33.698  94.828  1.00 33.45           C  
ATOM   1071  CE  LYS A 135       4.999  33.600  93.924  1.00 35.83           C  
ATOM   1072  NZ  LYS A 135       5.439  32.203  93.656  1.00 37.32           N  
ATOM   1073  N   ASP A 136      -2.032  34.225  94.977  1.00 27.49           N  
ATOM   1074  CA  ASP A 136      -3.176  34.714  95.741  1.00 28.54           C  
ATOM   1075  C   ASP A 136      -4.374  33.768  95.699  1.00 29.59           C  
ATOM   1076  O   ASP A 136      -5.290  33.889  96.519  1.00 29.33           O  
ATOM   1077  CB  ASP A 136      -3.603  36.095  95.235  1.00 28.48           C  
ATOM   1078  CG  ASP A 136      -2.630  37.185  95.629  1.00 29.36           C  
ATOM   1079  OD1 ASP A 136      -1.682  36.898  96.402  1.00 28.90           O  
ATOM   1080  OD2 ASP A 136      -2.811  38.329  95.156  1.00 31.40           O  
ATOM   1081  N   LEU A 137      -4.376  32.836  94.747  1.00 30.55           N  
ATOM   1082  CA  LEU A 137      -5.500  31.903  94.594  1.00 32.27           C  
ATOM   1083  C   LEU A 137      -5.499  30.807  95.643  1.00 33.20           C  
ATOM   1084  O   LEU A 137      -6.542  30.232  95.978  1.00 34.01           O  
ATOM   1085  CB  LEU A 137      -5.471  31.245  93.211  1.00 31.99           C  
ATOM   1086  CG  LEU A 137      -5.974  32.098  92.055  1.00 31.42           C  
ATOM   1087  CD1 LEU A 137      -5.983  31.261  90.809  1.00 31.62           C  
ATOM   1088  CD2 LEU A 137      -7.361  32.668  92.361  1.00 30.45           C  
ATOM   1089  N   GLY A 138      -4.308  30.503  96.130  1.00 33.99           N  
ATOM   1090  CA  GLY A 138      -4.101  29.370  97.001  1.00 34.99           C  
ATOM   1091  C   GLY A 138      -2.688  28.866  96.806  1.00 35.53           C  
ATOM   1092  O   GLY A 138      -1.997  29.249  95.853  1.00 36.08           O  
ATOM   1093  N   ALA A 139      -2.254  28.016  97.727  1.00 35.84           N  
ATOM   1094  CA  ALA A 139      -0.961  27.372  97.612  1.00 36.11           C  
ATOM   1095  C   ALA A 139      -1.068  26.339  96.508  1.00 35.81           C  
ATOM   1096  O   ALA A 139      -2.096  25.664  96.382  1.00 36.40           O  
ATOM   1097  CB  ALA A 139      -0.585  26.704  98.939  1.00 36.38           C  
ATOM   1098  N   ASP A 140      -0.023  26.234  95.699  1.00 35.32           N  
ATOM   1099  CA  ASP A 140       0.058  25.187  94.686  1.00 35.02           C  
ATOM   1100  C   ASP A 140      -1.052  25.284  93.616  1.00 33.34           C  
ATOM   1101  O   ASP A 140      -1.513  24.254  93.120  1.00 32.84           O  
ATOM   1102  CB  ASP A 140       0.011  23.815  95.373  1.00 36.34           C  
ATOM   1103  CG  ASP A 140       0.987  22.814  94.779  1.00 40.66           C  
ATOM   1104  OD1 ASP A 140       1.649  22.106  95.585  1.00 45.89           O  
ATOM   1105  OD2 ASP A 140       1.090  22.713  93.526  1.00 45.62           O  
ATOM   1106  N   ARG A 141      -1.469  26.509  93.268  1.00 31.11           N  
ATOM   1107  CA  ARG A 141      -2.451  26.739  92.179  1.00 29.44           C  
ATOM   1108  C   ARG A 141      -1.769  27.385  90.963  1.00 27.76           C  
ATOM   1109  O   ARG A 141      -2.406  27.869  90.027  1.00 26.78           O  
ATOM   1110  CB  ARG A 141      -3.642  27.579  92.672  1.00 29.05           C  
ATOM   1111  CG  ARG A 141      -4.542  26.818  93.631  1.00 29.43           C  
ATOM   1112  CD  ARG A 141      -5.878  27.527  93.902  1.00 30.83           C  
ATOM   1113  NE  ARG A 141      -6.776  26.620  94.629  1.00 35.30           N  
ATOM   1114  CZ  ARG A 141      -7.599  25.733  94.059  1.00 35.07           C  
ATOM   1115  NH1 ARG A 141      -8.340  24.934  94.813  1.00 34.83           N  
ATOM   1116  NH2 ARG A 141      -7.685  25.639  92.739  1.00 33.89           N  
ATOM   1117  N   VAL A 142      -0.449  27.343  91.022  1.00 25.86           N  
ATOM   1118  CA  VAL A 142       0.492  27.934  90.095  1.00 24.76           C  
ATOM   1119  C   VAL A 142       0.457  27.260  88.692  1.00 23.63           C  
ATOM   1120  O   VAL A 142       0.131  26.077  88.580  1.00 22.66           O  
ATOM   1121  CB  VAL A 142       1.846  27.834  90.861  1.00 25.25           C  
ATOM   1122  CG1 VAL A 142       2.923  26.975  90.202  1.00 27.43           C  
ATOM   1123  CG2 VAL A 142       2.291  29.159  91.449  1.00 25.35           C  
ATOM   1124  N   LYS A 143       0.743  28.014  87.625  1.00 22.48           N  
ATOM   1125  CA  LYS A 143       0.940  27.419  86.281  1.00 21.74           C  
ATOM   1126  C   LYS A 143       2.041  26.356  86.397  1.00 20.96           C  
ATOM   1127  O   LYS A 143       3.030  26.606  87.076  1.00 21.69           O  
ATOM   1128  CB  LYS A 143       1.382  28.461  85.256  1.00 21.85           C  
ATOM   1129  CG  LYS A 143       0.544  29.720  85.145  1.00 20.14           C  
ATOM   1130  CD  LYS A 143       1.308  30.730  84.296  1.00 17.96           C  
ATOM   1131  CE  LYS A 143       0.729  32.122  84.415  1.00 19.26           C  
ATOM   1132  NZ  LYS A 143       1.545  33.112  83.628  1.00 20.48           N  
ATOM   1133  N   PRO A 144       1.904  25.191  85.728  1.00 20.09           N  
ATOM   1134  CA  PRO A 144       0.987  24.743  84.676  1.00 19.23           C  
ATOM   1135  C   PRO A 144      -0.488  24.467  84.994  1.00 19.02           C  
ATOM   1136  O   PRO A 144      -1.251  24.132  84.077  1.00 18.38           O  
ATOM   1137  CB  PRO A 144       1.660  23.471  84.133  1.00 19.37           C  
ATOM   1138  CG  PRO A 144       2.500  22.972  85.224  1.00 19.01           C  
ATOM   1139  CD  PRO A 144       2.901  24.151  86.062  1.00 19.90           C  
ATOM   1140  N   LYS A 145      -0.922  24.588  86.241  1.00 18.56           N  
ATOM   1141  CA  LYS A 145      -2.371  24.470  86.493  1.00 18.55           C  
ATOM   1142  C   LYS A 145      -3.096  25.568  85.713  1.00 17.49           C  
ATOM   1143  O   LYS A 145      -2.513  26.630  85.482  1.00 17.98           O  
ATOM   1144  CB  LYS A 145      -2.670  24.542  87.986  1.00 18.84           C  
ATOM   1145  CG  LYS A 145      -2.294  23.284  88.695  1.00 20.76           C  
ATOM   1146  CD  LYS A 145      -2.484  23.393  90.204  1.00 25.29           C  
ATOM   1147  CE  LYS A 145      -2.558  21.971  90.805  1.00 27.31           C  
ATOM   1148  NZ  LYS A 145      -1.925  21.854  92.147  1.00 30.66           N  
ATOM   1149  N   PRO A 146      -4.333  25.294  85.236  1.00 16.91           N  
ATOM   1150  CA  PRO A 146      -5.077  26.328  84.503  1.00 16.34           C  
ATOM   1151  C   PRO A 146      -5.688  27.437  85.391  1.00 15.94           C  
ATOM   1152  O   PRO A 146      -6.195  28.410  84.861  1.00 15.83           O  
ATOM   1153  CB  PRO A 146      -6.204  25.528  83.826  1.00 15.24           C  
ATOM   1154  CG  PRO A 146      -6.421  24.373  84.729  1.00 15.41           C  
ATOM   1155  CD  PRO A 146      -5.085  24.019  85.299  1.00 16.18           C  
ATOM   1156  N   ASP A 147      -5.609  27.276  86.707  1.00 16.08           N  
ATOM   1157  CA  ASP A 147      -6.364  28.066  87.674  1.00 16.72           C  
ATOM   1158  C   ASP A 147      -6.320  29.572  87.444  1.00 16.60           C  
ATOM   1159  O   ASP A 147      -7.373  30.195  87.350  1.00 17.24           O  
ATOM   1160  CB  ASP A 147      -5.876  27.772  89.101  1.00 17.04           C  
ATOM   1161  CG  ASP A 147      -6.034  26.298  89.506  1.00 19.78           C  
ATOM   1162  OD1 ASP A 147      -5.912  25.380  88.670  1.00 21.28           O  
ATOM   1163  OD2 ASP A 147      -6.260  26.063  90.700  1.00 25.23           O  
ATOM   1164  N   ILE A 148      -5.116  30.162  87.398  1.00 16.12           N  
ATOM   1165  CA  ILE A 148      -5.000  31.613  87.217  1.00 16.08           C  
ATOM   1166  C   ILE A 148      -5.640  32.148  85.917  1.00 16.53           C  
ATOM   1167  O   ILE A 148      -6.241  33.230  85.907  1.00 17.11           O  
ATOM   1168  CB  ILE A 148      -3.546  32.133  87.397  1.00 16.14           C  
ATOM   1169  CG1 ILE A 148      -3.566  33.638  87.702  1.00 15.32           C  
ATOM   1170  CG2 ILE A 148      -2.673  31.787  86.197  1.00 14.00           C  
ATOM   1171  CD1 ILE A 148      -4.273  33.966  89.032  1.00 13.56           C  
ATOM   1172  N   PHE A 149      -5.534  31.382  84.838  1.00 16.24           N  
ATOM   1173  CA  PHE A 149      -6.131  31.769  83.566  1.00 16.41           C  
ATOM   1174  C   PHE A 149      -7.653  31.738  83.628  1.00 16.67           C  
ATOM   1175  O   PHE A 149      -8.322  32.682  83.179  1.00 16.49           O  
ATOM   1176  CB  PHE A 149      -5.648  30.831  82.460  1.00 16.70           C  
ATOM   1177  CG  PHE A 149      -4.175  30.953  82.170  1.00 17.16           C  
ATOM   1178  CD1 PHE A 149      -3.656  32.144  81.648  1.00 17.51           C  
ATOM   1179  CD2 PHE A 149      -3.312  29.893  82.432  1.00 17.05           C  
ATOM   1180  CE1 PHE A 149      -2.297  32.268  81.369  1.00 17.54           C  
ATOM   1181  CE2 PHE A 149      -1.952  30.004  82.164  1.00 17.69           C  
ATOM   1182  CZ  PHE A 149      -1.441  31.189  81.617  1.00 18.93           C  
ATOM   1183  N   LEU A 150      -8.189  30.646  84.182  1.00 16.85           N  
ATOM   1184  CA  LEU A 150      -9.643  30.487  84.326  1.00 16.89           C  
ATOM   1185  C   LEU A 150     -10.193  31.598  85.218  1.00 17.18           C  
ATOM   1186  O   LEU A 150     -11.265  32.131  84.949  1.00 16.69           O  
ATOM   1187  CB  LEU A 150      -9.989  29.100  84.882  1.00 16.55           C  
ATOM   1188  CG  LEU A 150      -9.654  27.882  83.999  1.00 17.02           C  
ATOM   1189  CD1 LEU A 150      -9.783  26.604  84.843  1.00 16.81           C  
ATOM   1190  CD2 LEU A 150     -10.569  27.763  82.797  1.00 16.57           C  
ATOM   1191  N   HIS A 151      -9.430  31.965  86.250  1.00 17.19           N  
ATOM   1192  CA  HIS A 151      -9.818  33.069  87.139  1.00 18.44           C  
ATOM   1193  C   HIS A 151      -9.893  34.413  86.401  1.00 18.11           C  
ATOM   1194  O   HIS A 151     -10.890  35.136  86.522  1.00 18.35           O  
ATOM   1195  CB  HIS A 151      -8.862  33.190  88.330  1.00 18.55           C  
ATOM   1196  CG  HIS A 151      -9.238  34.272  89.295  1.00 21.31           C  
ATOM   1197  ND1 HIS A 151      -8.557  35.470  89.377  1.00 23.54           N  
ATOM   1198  CD2 HIS A 151     -10.234  34.343  90.212  1.00 23.17           C  
ATOM   1199  CE1 HIS A 151      -9.110  36.225  90.311  1.00 22.88           C  
ATOM   1200  NE2 HIS A 151     -10.129  35.565  90.832  1.00 24.14           N  
ATOM   1201  N   GLY A 152      -8.845  34.745  85.647  1.00 17.63           N  
ATOM   1202  CA  GLY A 152      -8.828  35.967  84.838  1.00 17.15           C  
ATOM   1203  C   GLY A 152      -9.941  36.024  83.809  1.00 17.76           C  
ATOM   1204  O   GLY A 152     -10.590  37.056  83.671  1.00 18.09           O  
ATOM   1205  N   ALA A 153     -10.179  34.937  83.081  1.00 17.65           N  
ATOM   1206  CA  ALA A 153     -11.271  34.926  82.083  1.00 18.08           C  
ATOM   1207  C   ALA A 153     -12.657  35.145  82.732  1.00 18.89           C  
ATOM   1208  O   ALA A 153     -13.481  35.919  82.242  1.00 19.36           O  
ATOM   1209  CB  ALA A 153     -11.256  33.639  81.286  1.00 16.93           C  
ATOM   1210  N   ALA A 154     -12.906  34.446  83.833  1.00 18.95           N  
ATOM   1211  CA  ALA A 154     -14.156  34.589  84.579  1.00 19.57           C  
ATOM   1212  C   ALA A 154     -14.390  36.019  85.094  1.00 19.64           C  
ATOM   1213  O   ALA A 154     -15.524  36.479  85.113  1.00 19.99           O  
ATOM   1214  CB  ALA A 154     -14.196  33.584  85.735  1.00 19.45           C  
ATOM   1215  N   GLN A 155     -13.336  36.722  85.498  1.00 19.86           N  
ATOM   1216  CA  GLN A 155     -13.492  38.136  85.901  1.00 21.14           C  
ATOM   1217  C   GLN A 155     -14.039  39.014  84.772  1.00 21.71           C  
ATOM   1218  O   GLN A 155     -14.665  40.035  85.040  1.00 22.21           O  
ATOM   1219  CB  GLN A 155     -12.200  38.752  86.435  1.00 20.76           C  
ATOM   1220  CG  GLN A 155     -11.478  37.946  87.502  1.00 25.03           C  
ATOM   1221  CD  GLN A 155     -12.355  37.615  88.699  1.00 31.83           C  
ATOM   1222  OE1 GLN A 155     -12.775  38.504  89.442  1.00 31.18           O  
ATOM   1223  NE2 GLN A 155     -12.646  36.309  88.883  1.00 34.45           N  
ATOM   1224  N   PHE A 156     -13.801  38.625  83.522  1.00 21.73           N  
ATOM   1225  CA  PHE A 156     -14.348  39.344  82.382  1.00 22.15           C  
ATOM   1226  C   PHE A 156     -15.610  38.728  81.826  1.00 23.33           C  
ATOM   1227  O   PHE A 156     -16.201  39.275  80.903  1.00 24.09           O  
ATOM   1228  CB  PHE A 156     -13.285  39.484  81.268  1.00 21.52           C  
ATOM   1229  CG  PHE A 156     -12.198  40.464  81.598  1.00 21.41           C  
ATOM   1230  CD1 PHE A 156     -12.223  41.760  81.056  1.00 22.19           C  
ATOM   1231  CD2 PHE A 156     -11.168  40.114  82.467  1.00 19.11           C  
ATOM   1232  CE1 PHE A 156     -11.222  42.678  81.358  1.00 22.29           C  
ATOM   1233  CE2 PHE A 156     -10.161  41.025  82.784  1.00 20.71           C  
ATOM   1234  CZ  PHE A 156     -10.184  42.308  82.234  1.00 21.47           C  
ATOM   1235  N   GLY A 157     -16.023  37.581  82.364  1.00 24.38           N  
ATOM   1236  CA  GLY A 157     -17.175  36.864  81.834  1.00 24.34           C  
ATOM   1237  C   GLY A 157     -16.946  36.329  80.437  1.00 24.99           C  
ATOM   1238  O   GLY A 157     -17.880  36.194  79.660  1.00 25.82           O  
ATOM   1239  N   VAL A 158     -15.701  36.000  80.112  1.00 25.29           N  
ATOM   1240  CA  VAL A 158     -15.361  35.547  78.764  1.00 25.54           C  
ATOM   1241  C   VAL A 158     -15.199  34.034  78.772  1.00 25.47           C  
ATOM   1242  O   VAL A 158     -14.554  33.505  79.659  1.00 26.31           O  
ATOM   1243  CB  VAL A 158     -14.082  36.301  78.232  1.00 25.32           C  
ATOM   1244  CG1 VAL A 158     -13.637  35.769  76.882  1.00 26.26           C  
ATOM   1245  CG2 VAL A 158     -14.370  37.788  78.119  1.00 24.82           C  
ATOM   1246  N   SER A 159     -15.797  33.324  77.816  1.00 25.85           N  
ATOM   1247  CA  SER A 159     -15.525  31.883  77.691  1.00 26.03           C  
ATOM   1248  C   SER A 159     -14.083  31.654  77.219  1.00 26.12           C  
ATOM   1249  O   SER A 159     -13.580  32.424  76.391  1.00 25.66           O  
ATOM   1250  CB  SER A 159     -16.502  31.220  76.732  1.00 26.62           C  
ATOM   1251  OG  SER A 159     -16.365  31.788  75.446  1.00 29.67           O  
ATOM   1252  N   PRO A 160     -13.418  30.594  77.728  1.00 25.75           N  
ATOM   1253  CA  PRO A 160     -12.017  30.349  77.410  1.00 25.62           C  
ATOM   1254  C   PRO A 160     -11.729  30.242  75.921  1.00 25.76           C  
ATOM   1255  O   PRO A 160     -10.686  30.701  75.488  1.00 25.25           O  
ATOM   1256  CB  PRO A 160     -11.723  29.032  78.124  1.00 26.15           C  
ATOM   1257  CG  PRO A 160     -12.689  29.038  79.309  1.00 26.65           C  
ATOM   1258  CD  PRO A 160     -13.945  29.574  78.661  1.00 26.45           C  
ATOM   1259  N   ASP A 161     -12.653  29.704  75.130  1.00 25.71           N  
ATOM   1260  CA  ASP A 161     -12.437  29.671  73.686  1.00 26.78           C  
ATOM   1261  C   ASP A 161     -12.350  31.050  73.001  1.00 25.95           C  
ATOM   1262  O   ASP A 161     -11.925  31.142  71.845  1.00 27.03           O  
ATOM   1263  CB  ASP A 161     -13.442  28.742  72.990  1.00 27.52           C  
ATOM   1264  CG  ASP A 161     -14.836  29.317  72.931  1.00 30.62           C  
ATOM   1265  OD1 ASP A 161     -15.272  30.004  73.877  1.00 32.64           O  
ATOM   1266  OD2 ASP A 161     -15.510  29.050  71.917  1.00 37.11           O  
ATOM   1267  N   ARG A 162     -12.734  32.112  73.714  1.00 24.57           N  
ATOM   1268  CA  ARG A 162     -12.634  33.476  73.198  1.00 23.76           C  
ATOM   1269  C   ARG A 162     -11.469  34.286  73.824  1.00 21.35           C  
ATOM   1270  O   ARG A 162     -11.412  35.517  73.698  1.00 20.57           O  
ATOM   1271  CB  ARG A 162     -13.984  34.206  73.334  1.00 23.74           C  
ATOM   1272  CG  ARG A 162     -15.061  33.579  72.410  1.00 26.96           C  
ATOM   1273  CD  ARG A 162     -16.297  34.437  72.263  1.00 28.39           C  
ATOM   1274  NE  ARG A 162     -16.688  34.552  70.858  1.00 37.61           N  
ATOM   1275  CZ  ARG A 162     -16.426  35.600  70.076  1.00 40.54           C  
ATOM   1276  NH1 ARG A 162     -16.834  35.586  68.814  1.00 42.93           N  
ATOM   1277  NH2 ARG A 162     -15.775  36.664  70.546  1.00 41.00           N  
ATOM   1278  N   VAL A 163     -10.538  33.585  74.461  1.00 18.73           N  
ATOM   1279  CA  VAL A 163      -9.370  34.221  75.098  1.00 17.33           C  
ATOM   1280  C   VAL A 163      -8.091  33.821  74.354  1.00 17.20           C  
ATOM   1281  O   VAL A 163      -7.920  32.653  73.992  1.00 17.46           O  
ATOM   1282  CB  VAL A 163      -9.212  33.794  76.587  1.00 17.01           C  
ATOM   1283  CG1 VAL A 163      -8.034  34.571  77.264  1.00 14.63           C  
ATOM   1284  CG2 VAL A 163     -10.541  33.969  77.357  1.00 15.15           C  
ATOM   1285  N   VAL A 164      -7.210  34.790  74.116  1.00 16.54           N  
ATOM   1286  CA  VAL A 164      -5.882  34.480  73.597  1.00 16.00           C  
ATOM   1287  C   VAL A 164      -4.871  34.818  74.684  1.00 15.84           C  
ATOM   1288  O   VAL A 164      -5.017  35.815  75.399  1.00 15.34           O  
ATOM   1289  CB  VAL A 164      -5.594  35.166  72.234  1.00 16.62           C  
ATOM   1290  CG1 VAL A 164      -5.597  36.721  72.345  1.00 16.09           C  
ATOM   1291  CG2 VAL A 164      -4.284  34.650  71.642  1.00 15.19           C  
ATOM   1292  N   VAL A 165      -3.885  33.955  74.864  1.00 15.65           N  
ATOM   1293  CA  VAL A 165      -2.899  34.183  75.913  1.00 15.78           C  
ATOM   1294  C   VAL A 165      -1.533  34.469  75.263  1.00 16.43           C  
ATOM   1295  O   VAL A 165      -1.187  33.831  74.264  1.00 17.04           O  
ATOM   1296  CB  VAL A 165      -2.800  32.961  76.875  1.00 15.71           C  
ATOM   1297  CG1 VAL A 165      -1.710  33.163  77.915  1.00 16.13           C  
ATOM   1298  CG2 VAL A 165      -4.127  32.688  77.564  1.00 15.42           C  
ATOM   1299  N   VAL A 166      -0.776  35.418  75.826  1.00 16.56           N  
ATOM   1300  CA  VAL A 166       0.614  35.678  75.415  1.00 17.26           C  
ATOM   1301  C   VAL A 166       1.593  35.213  76.488  1.00 17.93           C  
ATOM   1302  O   VAL A 166       1.583  35.720  77.606  1.00 18.24           O  
ATOM   1303  CB  VAL A 166       0.836  37.158  75.070  1.00 17.91           C  
ATOM   1304  CG1 VAL A 166       2.229  37.362  74.456  1.00 16.78           C  
ATOM   1305  CG2 VAL A 166      -0.274  37.635  74.072  1.00 17.19           C  
ATOM   1306  N   GLU A 167       2.427  34.236  76.142  1.00 18.03           N  
ATOM   1307  CA  GLU A 167       3.289  33.564  77.102  1.00 19.04           C  
ATOM   1308  C   GLU A 167       4.695  33.336  76.550  1.00 18.36           C  
ATOM   1309  O   GLU A 167       4.856  33.072  75.365  1.00 17.96           O  
ATOM   1310  CB  GLU A 167       2.678  32.216  77.490  1.00 19.13           C  
ATOM   1311  CG  GLU A 167       1.785  32.285  78.698  1.00 22.75           C  
ATOM   1312  CD  GLU A 167       2.569  32.405  79.996  1.00 26.91           C  
ATOM   1313  OE1 GLU A 167       1.897  32.478  81.035  1.00 28.57           O  
ATOM   1314  OE2 GLU A 167       3.840  32.407  79.996  1.00 27.45           O  
ATOM   1315  N   ASP A 168       5.690  33.440  77.421  1.00 18.03           N  
ATOM   1316  CA  ASP A 168       7.079  33.151  77.060  1.00 18.97           C  
ATOM   1317  C   ASP A 168       7.553  31.848  77.707  1.00 19.02           C  
ATOM   1318  O   ASP A 168       8.674  31.404  77.474  1.00 19.62           O  
ATOM   1319  CB  ASP A 168       7.977  34.281  77.527  1.00 18.63           C  
ATOM   1320  CG  ASP A 168       8.170  34.265  79.015  1.00 20.18           C  
ATOM   1321  OD1 ASP A 168       7.181  34.046  79.741  1.00 21.77           O  
ATOM   1322  OD2 ASP A 168       9.308  34.481  79.461  1.00 23.60           O  
ATOM   1323  N   SER A 169       6.691  31.230  78.513  1.00 19.83           N  
ATOM   1324  CA  SER A 169       7.088  30.031  79.247  1.00 19.89           C  
ATOM   1325  C   SER A 169       6.228  28.817  78.969  1.00 19.08           C  
ATOM   1326  O   SER A 169       5.022  28.917  78.790  1.00 18.65           O  
ATOM   1327  CB  SER A 169       7.103  30.273  80.755  1.00 20.85           C  
ATOM   1328  OG  SER A 169       5.814  30.023  81.304  1.00 25.10           O  
ATOM   1329  N   VAL A 170       6.885  27.662  78.989  0.50 18.77           N  
ATOM   1331  CA  VAL A 170       6.259  26.374  78.771  0.50 19.11           C  
ATOM   1333  C   VAL A 170       5.166  26.074  79.820  0.50 19.39           C  
ATOM   1335  O   VAL A 170       4.114  25.532  79.492  0.50 19.08           O  
ATOM   1337  CB  VAL A 170       7.357  25.274  78.677  0.50 19.40           C  
ATOM   1339  CG1 VAL A 170       7.590  24.560  80.008  0.50 17.52           C  
ATOM   1341  CG2 VAL A 170       7.038  24.306  77.578  0.50 19.36           C  
ATOM   1343  N   HIS A 171       5.404  26.455  81.071  1.00 19.45           N  
ATOM   1344  CA  HIS A 171       4.392  26.266  82.129  1.00 20.82           C  
ATOM   1345  C   HIS A 171       3.133  27.110  81.915  1.00 20.53           C  
ATOM   1346  O   HIS A 171       2.019  26.616  82.092  1.00 20.14           O  
ATOM   1347  CB  HIS A 171       4.990  26.530  83.505  1.00 21.79           C  
ATOM   1348  CG  HIS A 171       5.888  25.437  83.970  1.00 26.24           C  
ATOM   1349  ND1 HIS A 171       7.061  25.673  84.658  1.00 33.00           N  
ATOM   1350  CD2 HIS A 171       5.792  24.093  83.841  1.00 31.75           C  
ATOM   1351  CE1 HIS A 171       7.642  24.521  84.943  1.00 34.21           C  
ATOM   1352  NE2 HIS A 171       6.892  23.546  84.456  1.00 34.60           N  
ATOM   1353  N   GLY A 172       3.316  28.369  81.503  1.00 19.74           N  
ATOM   1354  CA  GLY A 172       2.183  29.233  81.135  1.00 19.45           C  
ATOM   1355  C   GLY A 172       1.412  28.739  79.928  1.00 19.33           C  
ATOM   1356  O   GLY A 172       0.193  28.866  79.853  1.00 19.55           O  
ATOM   1357  N   ILE A 173       2.123  28.149  78.972  1.00 19.13           N  
ATOM   1358  CA  ILE A 173       1.481  27.657  77.765  1.00 18.09           C  
ATOM   1359  C   ILE A 173       0.611  26.440  78.081  1.00 17.88           C  
ATOM   1360  O   ILE A 173      -0.531  26.365  77.635  1.00 17.96           O  
ATOM   1361  CB  ILE A 173       2.492  27.415  76.606  1.00 17.59           C  
ATOM   1362  CG1 ILE A 173       3.165  28.756  76.237  1.00 18.08           C  
ATOM   1363  CG2 ILE A 173       1.792  26.810  75.404  1.00 16.78           C  
ATOM   1364  CD1 ILE A 173       3.752  28.828  74.870  1.00 18.60           C  
ATOM   1365  N   HIS A 174       1.132  25.529  78.895  1.00 17.99           N  
ATOM   1366  CA  HIS A 174       0.372  24.340  79.306  1.00 18.05           C  
ATOM   1367  C   HIS A 174      -0.823  24.744  80.146  1.00 17.91           C  
ATOM   1368  O   HIS A 174      -1.910  24.243  79.920  1.00 17.49           O  
ATOM   1369  CB  HIS A 174       1.251  23.365  80.084  1.00 18.36           C  
ATOM   1370  CG  HIS A 174       2.239  22.634  79.230  1.00 17.25           C  
ATOM   1371  ND1 HIS A 174       1.859  21.811  78.195  1.00 18.58           N  
ATOM   1372  CD2 HIS A 174       3.592  22.586  79.273  1.00 17.70           C  
ATOM   1373  CE1 HIS A 174       2.935  21.305  77.623  1.00 17.82           C  
ATOM   1374  NE2 HIS A 174       3.996  21.757  78.262  1.00 17.28           N  
ATOM   1375  N   GLY A 175      -0.609  25.676  81.077  1.00 17.84           N  
ATOM   1376  CA  GLY A 175      -1.710  26.277  81.857  1.00 18.49           C  
ATOM   1377  C   GLY A 175      -2.827  26.785  80.964  1.00 17.93           C  
ATOM   1378  O   GLY A 175      -3.984  26.449  81.159  1.00 17.40           O  
ATOM   1379  N   ALA A 176      -2.461  27.565  79.949  1.00 18.15           N  
ATOM   1380  CA  ALA A 176      -3.432  28.172  79.075  1.00 18.62           C  
ATOM   1381  C   ALA A 176      -4.157  27.125  78.225  1.00 19.19           C  
ATOM   1382  O   ALA A 176      -5.374  27.224  78.018  1.00 19.64           O  
ATOM   1383  CB  ALA A 176      -2.774  29.235  78.202  1.00 18.75           C  
ATOM   1384  N   ARG A 177      -3.427  26.117  77.745  1.00 19.58           N  
ATOM   1385  CA  ARG A 177      -4.040  25.069  76.942  1.00 20.10           C  
ATOM   1386  C   ARG A 177      -4.975  24.240  77.823  1.00 20.30           C  
ATOM   1387  O   ARG A 177      -6.076  23.895  77.401  1.00 21.21           O  
ATOM   1388  CB  ARG A 177      -2.984  24.154  76.287  1.00 20.54           C  
ATOM   1389  CG  ARG A 177      -2.048  24.815  75.265  1.00 22.29           C  
ATOM   1390  CD  ARG A 177      -2.757  25.444  74.022  1.00 26.95           C  
ATOM   1391  NE  ARG A 177      -3.771  24.597  73.370  1.00 28.73           N  
ATOM   1392  CZ  ARG A 177      -3.601  23.947  72.216  1.00 31.98           C  
ATOM   1393  NH1 ARG A 177      -2.447  23.997  71.555  1.00 33.45           N  
ATOM   1394  NH2 ARG A 177      -4.592  23.221  71.719  1.00 31.96           N  
ATOM   1395  N   ALA A 178      -4.524  23.921  79.035  1.00 20.06           N  
ATOM   1396  CA  ALA A 178      -5.334  23.189  80.012  1.00 20.14           C  
ATOM   1397  C   ALA A 178      -6.648  23.933  80.335  1.00 20.56           C  
ATOM   1398  O   ALA A 178      -7.630  23.305  80.697  1.00 21.03           O  
ATOM   1399  CB  ALA A 178      -4.540  22.964  81.267  1.00 19.33           C  
ATOM   1400  N   ALA A 179      -6.643  25.259  80.184  1.00 20.06           N  
ATOM   1401  CA  ALA A 179      -7.810  26.131  80.384  1.00 20.12           C  
ATOM   1402  C   ALA A 179      -8.709  26.247  79.145  1.00 20.65           C  
ATOM   1403  O   ALA A 179      -9.773  26.876  79.203  1.00 20.51           O  
ATOM   1404  CB  ALA A 179      -7.345  27.535  80.824  1.00 20.22           C  
ATOM   1405  N   GLY A 180      -8.290  25.654  78.025  1.00 20.64           N  
ATOM   1406  CA  GLY A 180      -9.071  25.693  76.795  1.00 20.56           C  
ATOM   1407  C   GLY A 180      -8.901  26.961  75.971  1.00 21.37           C  
ATOM   1408  O   GLY A 180      -9.782  27.311  75.194  1.00 20.77           O  
HETATM 1409  N   MSE A 181      -7.751  27.620  76.106  1.00 21.04           N  
HETATM 1410  CA  MSE A 181      -7.490  28.876  75.425  1.00 22.78           C  
HETATM 1411  C   MSE A 181      -6.448  28.743  74.312  1.00 22.57           C  
HETATM 1412  O   MSE A 181      -5.709  27.771  74.251  1.00 23.50           O  
HETATM 1413  CB  MSE A 181      -7.015  29.921  76.431  1.00 21.89           C  
HETATM 1414  CG  MSE A 181      -8.002  30.199  77.510  1.00 21.84           C  
HETATM 1415 SE   MSE A 181      -7.261  31.302  78.942  1.00 26.82          SE  
HETATM 1416  CE  MSE A 181      -8.887  31.270  80.036  1.00 19.95           C  
ATOM   1417  N   ARG A 182      -6.384  29.746  73.443  1.00 22.55           N  
ATOM   1418  CA  ARG A 182      -5.420  29.737  72.347  1.00 22.44           C  
ATOM   1419  C   ARG A 182      -4.229  30.548  72.791  1.00 21.40           C  
ATOM   1420  O   ARG A 182      -4.388  31.489  73.576  1.00 21.74           O  
ATOM   1421  CB  ARG A 182      -6.072  30.271  71.071  1.00 22.43           C  
ATOM   1422  CG  ARG A 182      -7.076  29.229  70.530  1.00 24.62           C  
ATOM   1423  CD  ARG A 182      -7.939  29.762  69.442  1.00 24.25           C  
ATOM   1424  NE  ARG A 182      -7.180  29.956  68.211  1.00 26.78           N  
ATOM   1425  CZ  ARG A 182      -7.685  30.504  67.112  1.00 26.85           C  
ATOM   1426  NH1 ARG A 182      -6.934  30.662  66.031  1.00 25.74           N  
ATOM   1427  NH2 ARG A 182      -8.947  30.907  67.106  1.00 26.53           N  
ATOM   1428  N   VAL A 183      -3.044  30.153  72.333  1.00 20.39           N  
ATOM   1429  CA  VAL A 183      -1.798  30.683  72.861  1.00 19.55           C  
ATOM   1430  C   VAL A 183      -0.869  31.230  71.781  1.00 19.43           C  
ATOM   1431  O   VAL A 183      -0.632  30.575  70.771  1.00 18.88           O  
ATOM   1432  CB  VAL A 183      -0.989  29.599  73.658  1.00 19.39           C  
ATOM   1433  CG1 VAL A 183       0.282  30.204  74.279  1.00 20.00           C  
ATOM   1434  CG2 VAL A 183      -1.835  28.971  74.721  1.00 18.84           C  
ATOM   1435  N   ILE A 184      -0.316  32.411  72.042  1.00 18.51           N  
ATOM   1436  CA  ILE A 184       0.752  32.984  71.236  1.00 17.79           C  
ATOM   1437  C   ILE A 184       2.013  32.899  72.070  1.00 17.54           C  
ATOM   1438  O   ILE A 184       2.055  33.426  73.188  1.00 17.17           O  
ATOM   1439  CB  ILE A 184       0.458  34.463  70.853  1.00 18.13           C  
ATOM   1440  CG1 ILE A 184      -0.762  34.519  69.923  1.00 18.51           C  
ATOM   1441  CG2 ILE A 184       1.690  35.134  70.202  1.00 17.41           C  
ATOM   1442  CD1 ILE A 184      -1.360  35.900  69.746  1.00 20.48           C  
ATOM   1443  N   GLY A 185       3.029  32.207  71.555  1.00 16.81           N  
ATOM   1444  CA  GLY A 185       4.306  32.144  72.250  1.00 16.00           C  
ATOM   1445  C   GLY A 185       5.099  33.386  71.902  1.00 16.25           C  
ATOM   1446  O   GLY A 185       5.046  33.846  70.772  1.00 16.22           O  
ATOM   1447  N   PHE A 186       5.827  33.928  72.877  1.00 16.36           N  
ATOM   1448  CA  PHE A 186       6.616  35.128  72.682  1.00 16.32           C  
ATOM   1449  C   PHE A 186       8.091  34.894  73.049  1.00 16.38           C  
ATOM   1450  O   PHE A 186       8.412  34.589  74.195  1.00 16.40           O  
ATOM   1451  CB  PHE A 186       6.067  36.285  73.526  1.00 16.15           C  
ATOM   1452  CG  PHE A 186       6.888  37.543  73.410  1.00 16.92           C  
ATOM   1453  CD1 PHE A 186       6.889  38.275  72.206  1.00 14.56           C  
ATOM   1454  CD2 PHE A 186       7.683  37.989  74.483  1.00 16.45           C  
ATOM   1455  CE1 PHE A 186       7.662  39.432  72.065  1.00 14.64           C  
ATOM   1456  CE2 PHE A 186       8.462  39.168  74.355  1.00 17.16           C  
ATOM   1457  CZ  PHE A 186       8.450  39.882  73.148  1.00 15.21           C  
ATOM   1458  N   THR A 187       8.967  35.079  72.075  1.00 16.33           N  
ATOM   1459  CA  THR A 187      10.392  34.820  72.254  1.00 17.86           C  
ATOM   1460  C   THR A 187      11.206  36.073  71.926  1.00 18.66           C  
ATOM   1461  O   THR A 187      12.295  35.993  71.361  1.00 19.70           O  
ATOM   1462  CB  THR A 187      10.854  33.602  71.391  1.00 17.97           C  
ATOM   1463  OG1 THR A 187      10.658  33.884  70.002  1.00 16.57           O  
ATOM   1464  CG2 THR A 187      10.065  32.359  71.739  1.00 18.24           C  
ATOM   1465  N   GLY A 188      10.678  37.243  72.282  1.00 18.97           N  
ATOM   1466  CA  GLY A 188      11.367  38.505  71.969  1.00 18.89           C  
ATOM   1467  C   GLY A 188      12.136  39.051  73.151  1.00 19.14           C  
ATOM   1468  O   GLY A 188      12.910  40.003  73.023  1.00 19.48           O  
ATOM   1469  N   ALA A 189      11.961  38.448  74.312  1.00 18.89           N  
ATOM   1470  CA  ALA A 189      12.657  38.976  75.494  1.00 19.19           C  
ATOM   1471  C   ALA A 189      14.155  38.655  75.429  1.00 19.62           C  
ATOM   1472  O   ALA A 189      14.580  37.802  74.645  1.00 19.50           O  
ATOM   1473  CB  ALA A 189      12.036  38.461  76.741  1.00 18.46           C  
ATOM   1474  N   SER A 190      14.953  39.339  76.245  1.00 19.94           N  
ATOM   1475  CA  SER A 190      16.405  39.255  76.123  1.00 20.91           C  
ATOM   1476  C   SER A 190      16.998  37.932  76.586  1.00 21.62           C  
ATOM   1477  O   SER A 190      18.146  37.642  76.279  1.00 22.93           O  
ATOM   1478  CB  SER A 190      17.087  40.403  76.870  1.00 20.34           C  
ATOM   1479  OG  SER A 190      16.514  41.641  76.507  1.00 21.10           O  
ATOM   1480  N   HIS A 191      16.239  37.132  77.329  1.00 21.24           N  
ATOM   1481  CA  HIS A 191      16.751  35.846  77.814  1.00 21.47           C  
ATOM   1482  C   HIS A 191      16.543  34.703  76.815  1.00 21.91           C  
ATOM   1483  O   HIS A 191      16.878  33.544  77.124  1.00 22.63           O  
ATOM   1484  CB  HIS A 191      16.065  35.480  79.131  1.00 22.01           C  
ATOM   1485  CG  HIS A 191      14.595  35.259  78.987  1.00 22.27           C  
ATOM   1486  ND1 HIS A 191      14.009  34.018  79.130  1.00 23.24           N  
ATOM   1487  CD2 HIS A 191      13.596  36.116  78.667  1.00 22.03           C  
ATOM   1488  CE1 HIS A 191      12.707  34.122  78.927  1.00 23.28           C  
ATOM   1489  NE2 HIS A 191      12.431  35.385  78.642  1.00 26.51           N  
ATOM   1490  N   THR A 192      15.991  35.005  75.635  1.00 20.93           N  
ATOM   1491  CA  THR A 192      15.662  33.949  74.657  1.00 20.37           C  
ATOM   1492  C   THR A 192      16.916  33.167  74.232  1.00 20.96           C  
ATOM   1493  O   THR A 192      18.047  33.611  74.449  1.00 20.78           O  
ATOM   1494  CB  THR A 192      14.906  34.486  73.425  1.00 19.90           C  
ATOM   1495  OG1 THR A 192      14.245  33.404  72.750  1.00 20.40           O  
ATOM   1496  CG2 THR A 192      15.845  35.216  72.448  1.00 20.38           C  
ATOM   1497  N   TYR A 193      16.692  32.010  73.623  1.00 20.48           N  
ATOM   1498  CA  TYR A 193      17.745  31.042  73.363  1.00 21.09           C  
ATOM   1499  C   TYR A 193      17.272  30.244  72.153  1.00 21.15           C  
ATOM   1500  O   TYR A 193      16.091  30.306  71.799  1.00 20.95           O  
ATOM   1501  CB  TYR A 193      17.976  30.175  74.617  1.00 20.47           C  
ATOM   1502  CG  TYR A 193      16.691  29.604  75.207  1.00 20.65           C  
ATOM   1503  CD1 TYR A 193      16.277  28.315  74.870  1.00 18.78           C  
ATOM   1504  CD2 TYR A 193      15.874  30.369  76.058  1.00 18.90           C  
ATOM   1505  CE1 TYR A 193      15.123  27.785  75.377  1.00 20.16           C  
ATOM   1506  CE2 TYR A 193      14.698  29.837  76.578  1.00 19.66           C  
ATOM   1507  CZ  TYR A 193      14.327  28.547  76.222  1.00 20.03           C  
ATOM   1508  OH  TYR A 193      13.178  27.977  76.695  1.00 20.46           O  
ATOM   1509  N   PRO A 194      18.191  29.531  71.477  1.00 21.53           N  
ATOM   1510  CA  PRO A 194      17.859  28.872  70.228  1.00 21.15           C  
ATOM   1511  C   PRO A 194      16.658  27.904  70.253  1.00 20.62           C  
ATOM   1512  O   PRO A 194      15.880  27.874  69.312  1.00 19.72           O  
ATOM   1513  CB  PRO A 194      19.169  28.135  69.872  1.00 21.29           C  
ATOM   1514  CG  PRO A 194      20.226  28.968  70.535  1.00 22.09           C  
ATOM   1515  CD  PRO A 194      19.614  29.337  71.833  1.00 21.38           C  
ATOM   1516  N   SER A 195      16.505  27.119  71.309  1.00 20.94           N  
ATOM   1517  CA  SER A 195      15.415  26.154  71.344  1.00 21.85           C  
ATOM   1518  C   SER A 195      14.090  26.747  71.861  1.00 21.06           C  
ATOM   1519  O   SER A 195      13.094  26.036  71.950  1.00 21.74           O  
ATOM   1520  CB  SER A 195      15.835  24.944  72.178  1.00 21.74           C  
ATOM   1521  OG  SER A 195      15.737  25.273  73.543  1.00 26.40           O  
ATOM   1522  N   HIS A 196      14.073  28.049  72.181  1.00 20.08           N  
ATOM   1523  CA  HIS A 196      12.918  28.700  72.854  1.00 19.25           C  
ATOM   1524  C   HIS A 196      11.608  28.603  72.062  1.00 18.91           C  
ATOM   1525  O   HIS A 196      10.611  28.123  72.597  1.00 18.22           O  
ATOM   1526  CB  HIS A 196      13.271  30.163  73.189  1.00 19.11           C  
ATOM   1527  CG  HIS A 196      12.326  30.848  74.129  1.00 19.15           C  
ATOM   1528  ND1 HIS A 196      12.391  32.203  74.368  1.00 18.14           N  
ATOM   1529  CD2 HIS A 196      11.290  30.386  74.870  1.00 19.18           C  
ATOM   1530  CE1 HIS A 196      11.455  32.543  75.233  1.00 18.29           C  
ATOM   1531  NE2 HIS A 196      10.769  31.461  75.547  1.00 20.82           N  
ATOM   1532  N   ALA A 197      11.616  29.018  70.790  1.00 17.91           N  
ATOM   1533  CA  ALA A 197      10.402  28.971  69.987  1.00 18.63           C  
ATOM   1534  C   ALA A 197       9.866  27.544  69.798  1.00 19.11           C  
ATOM   1535  O   ALA A 197       8.644  27.308  69.888  1.00 18.92           O  
ATOM   1536  CB  ALA A 197      10.611  29.650  68.645  1.00 18.66           C  
ATOM   1537  N   ASP A 198      10.760  26.590  69.523  1.00 19.49           N  
ATOM   1538  CA  ASP A 198      10.336  25.198  69.395  1.00 20.30           C  
ATOM   1539  C   ASP A 198       9.707  24.695  70.698  1.00 20.37           C  
ATOM   1540  O   ASP A 198       8.673  24.028  70.666  1.00 20.31           O  
ATOM   1541  CB  ASP A 198      11.506  24.294  68.982  1.00 21.14           C  
ATOM   1542  CG  ASP A 198      11.998  24.566  67.557  1.00 22.68           C  
ATOM   1543  OD1 ASP A 198      11.220  25.034  66.690  1.00 26.02           O  
ATOM   1544  OD2 ASP A 198      13.184  24.316  67.298  1.00 27.48           O  
ATOM   1545  N   ARG A 199      10.317  25.025  71.835  1.00 20.18           N  
ATOM   1546  CA  ARG A 199       9.773  24.629  73.147  1.00 20.91           C  
ATOM   1547  C   ARG A 199       8.358  25.148  73.385  1.00 20.75           C  
ATOM   1548  O   ARG A 199       7.487  24.403  73.845  1.00 20.97           O  
ATOM   1549  CB  ARG A 199      10.672  25.072  74.298  1.00 20.93           C  
ATOM   1550  CG  ARG A 199      11.946  24.259  74.408  1.00 23.93           C  
ATOM   1551  CD  ARG A 199      12.647  24.533  75.699  1.00 28.18           C  
ATOM   1552  NE  ARG A 199      14.056  24.152  75.589  1.00 35.52           N  
ATOM   1553  CZ  ARG A 199      14.991  24.389  76.515  1.00 37.02           C  
ATOM   1554  NH1 ARG A 199      14.683  24.981  77.665  1.00 33.85           N  
ATOM   1555  NH2 ARG A 199      16.245  24.011  76.285  1.00 38.89           N  
ATOM   1556  N   LEU A 200       8.143  26.417  73.059  1.00 20.03           N  
ATOM   1557  CA  LEU A 200       6.819  27.046  73.151  1.00 19.72           C  
ATOM   1558  C   LEU A 200       5.795  26.397  72.215  1.00 19.80           C  
ATOM   1559  O   LEU A 200       4.668  26.120  72.617  1.00 20.56           O  
ATOM   1560  CB  LEU A 200       6.935  28.559  72.903  1.00 19.65           C  
ATOM   1561  CG  LEU A 200       7.808  29.368  73.880  1.00 17.69           C  
ATOM   1562  CD1 LEU A 200       7.476  30.870  73.782  1.00 17.37           C  
ATOM   1563  CD2 LEU A 200       7.661  28.886  75.334  1.00 18.56           C  
ATOM   1564  N   THR A 201       6.200  26.128  70.979  1.00 19.92           N  
ATOM   1565  CA  THR A 201       5.379  25.397  70.016  1.00 19.81           C  
ATOM   1566  C   THR A 201       4.998  24.008  70.547  1.00 20.15           C  
ATOM   1567  O   THR A 201       3.816  23.635  70.516  1.00 20.44           O  
ATOM   1568  CB  THR A 201       6.094  25.278  68.648  1.00 20.23           C  
ATOM   1569  OG1 THR A 201       6.385  26.595  68.140  1.00 18.98           O  
ATOM   1570  CG2 THR A 201       5.199  24.522  67.636  1.00 19.75           C  
ATOM   1571  N   ASP A 202       5.986  23.269  71.060  1.00 20.28           N  
ATOM   1572  CA  ASP A 202       5.774  21.902  71.583  1.00 20.73           C  
ATOM   1573  C   ASP A 202       4.796  21.906  72.764  1.00 20.80           C  
ATOM   1574  O   ASP A 202       4.048  20.931  72.960  1.00 21.50           O  
ATOM   1575  CB  ASP A 202       7.093  21.280  72.044  1.00 20.74           C  
ATOM   1576  CG  ASP A 202       8.052  20.924  70.883  1.00 21.91           C  
ATOM   1577  OD1 ASP A 202       7.657  20.971  69.686  1.00 23.08           O  
ATOM   1578  OD2 ASP A 202       9.211  20.575  71.212  1.00 20.64           O  
ATOM   1579  N   ALA A 203       4.791  23.003  73.523  1.00 19.46           N  
ATOM   1580  CA  ALA A 203       3.929  23.141  74.711  1.00 19.07           C  
ATOM   1581  C   ALA A 203       2.483  23.469  74.357  1.00 18.60           C  
ATOM   1582  O   ALA A 203       1.573  23.330  75.192  1.00 18.14           O  
ATOM   1583  CB  ALA A 203       4.504  24.205  75.695  1.00 18.63           C  
ATOM   1584  N   GLY A 204       2.299  23.939  73.127  1.00 18.70           N  
ATOM   1585  CA  GLY A 204       0.994  24.188  72.542  1.00 18.42           C  
ATOM   1586  C   GLY A 204       0.781  25.594  72.014  1.00 18.46           C  
ATOM   1587  O   GLY A 204      -0.354  25.974  71.745  1.00 18.32           O  
ATOM   1588  N   ALA A 205       1.850  26.373  71.857  1.00 18.49           N  
ATOM   1589  CA  ALA A 205       1.724  27.691  71.213  1.00 19.04           C  
ATOM   1590  C   ALA A 205       1.229  27.507  69.790  1.00 19.77           C  
ATOM   1591  O   ALA A 205       1.798  26.711  69.037  1.00 19.56           O  
ATOM   1592  CB  ALA A 205       3.055  28.442  71.218  1.00 18.34           C  
ATOM   1593  N   GLU A 206       0.156  28.211  69.447  1.00 19.90           N  
ATOM   1594  CA  GLU A 206      -0.417  28.160  68.122  1.00 21.89           C  
ATOM   1595  C   GLU A 206       0.514  28.850  67.124  1.00 22.30           C  
ATOM   1596  O   GLU A 206       0.620  28.468  65.946  1.00 22.79           O  
ATOM   1597  CB  GLU A 206      -1.778  28.869  68.124  1.00 22.01           C  
ATOM   1598  CG  GLU A 206      -2.548  28.671  66.825  1.00 25.72           C  
ATOM   1599  CD  GLU A 206      -3.987  29.106  66.902  1.00 28.16           C  
ATOM   1600  OE1 GLU A 206      -4.677  28.725  67.864  1.00 31.08           O  
ATOM   1601  OE2 GLU A 206      -4.420  29.831  65.992  1.00 30.70           O  
ATOM   1602  N   THR A 207       1.162  29.901  67.595  1.00 21.99           N  
ATOM   1603  CA  THR A 207       2.139  30.594  66.786  1.00 22.46           C  
ATOM   1604  C   THR A 207       3.139  31.219  67.743  1.00 21.26           C  
ATOM   1605  O   THR A 207       2.849  31.335  68.934  1.00 21.05           O  
ATOM   1606  CB  THR A 207       1.462  31.644  65.868  1.00 22.65           C  
ATOM   1607  OG1 THR A 207       2.431  32.132  64.934  1.00 27.44           O  
ATOM   1608  CG2 THR A 207       0.867  32.804  66.656  1.00 23.77           C  
ATOM   1609  N   VAL A 208       4.300  31.600  67.220  1.00 20.18           N  
ATOM   1610  CA  VAL A 208       5.330  32.267  67.983  1.00 19.44           C  
ATOM   1611  C   VAL A 208       5.672  33.614  67.318  1.00 18.87           C  
ATOM   1612  O   VAL A 208       5.824  33.701  66.097  1.00 17.92           O  
ATOM   1613  CB  VAL A 208       6.610  31.376  68.133  1.00 20.38           C  
ATOM   1614  CG1 VAL A 208       7.765  32.157  68.800  1.00 20.16           C  
ATOM   1615  CG2 VAL A 208       6.312  30.109  68.951  1.00 19.88           C  
ATOM   1616  N   ILE A 209       5.775  34.666  68.136  1.00 18.38           N  
ATOM   1617  CA  ILE A 209       6.306  35.948  67.687  1.00 16.71           C  
ATOM   1618  C   ILE A 209       7.518  36.384  68.526  1.00 16.25           C  
ATOM   1619  O   ILE A 209       7.688  35.952  69.667  1.00 15.81           O  
ATOM   1620  CB  ILE A 209       5.193  37.059  67.634  1.00 17.35           C  
ATOM   1621  CG1 ILE A 209       4.613  37.347  69.029  1.00 16.41           C  
ATOM   1622  CG2 ILE A 209       4.104  36.679  66.621  1.00 17.45           C  
ATOM   1623  CD1 ILE A 209       3.673  38.571  69.121  1.00 17.25           C  
ATOM   1624  N   SER A 210       8.377  37.211  67.940  1.00 16.25           N  
ATOM   1625  CA  SER A 210       9.543  37.786  68.635  1.00 16.33           C  
ATOM   1626  C   SER A 210       9.458  39.314  68.687  1.00 17.14           C  
ATOM   1627  O   SER A 210      10.250  39.973  69.371  1.00 17.19           O  
ATOM   1628  CB  SER A 210      10.855  37.370  67.959  1.00 16.46           C  
ATOM   1629  OG  SER A 210      11.132  35.996  68.190  1.00 17.01           O  
ATOM   1630  N   ARG A 211       8.514  39.882  67.944  1.00 17.67           N  
ATOM   1631  CA  ARG A 211       8.224  41.309  68.045  1.00 18.70           C  
ATOM   1632  C   ARG A 211       6.868  41.505  68.646  1.00 18.79           C  
ATOM   1633  O   ARG A 211       5.871  41.065  68.085  1.00 19.03           O  
ATOM   1634  CB  ARG A 211       8.273  42.007  66.687  1.00 18.85           C  
ATOM   1635  CG  ARG A 211       9.669  42.154  66.155  1.00 19.85           C  
ATOM   1636  CD  ARG A 211       9.697  42.877  64.817  1.00 20.13           C  
ATOM   1637  NE  ARG A 211       9.075  44.215  64.782  1.00 21.52           N  
ATOM   1638  CZ  ARG A 211       9.581  45.320  65.338  1.00 21.65           C  
ATOM   1639  NH1 ARG A 211       8.947  46.470  65.197  1.00 19.87           N  
ATOM   1640  NH2 ARG A 211      10.706  45.280  66.054  1.00 24.81           N  
HETATM 1641  N   MSE A 212       6.830  42.171  69.795  1.00 19.20           N  
HETATM 1642  CA  MSE A 212       5.550  42.488  70.411  1.00 20.33           C  
HETATM 1643  C   MSE A 212       4.685  43.324  69.460  1.00 19.45           C  
HETATM 1644  O   MSE A 212       3.454  43.212  69.462  1.00 18.72           O  
HETATM 1645  CB  MSE A 212       5.741  43.164  71.771  1.00 20.83           C  
HETATM 1646  CG  MSE A 212       4.517  43.135  72.635  1.00 24.86           C  
HETATM 1647 SE   MSE A 212       3.883  41.321  72.947  0.70 36.46          SE  
HETATM 1648  CE  MSE A 212       5.101  40.660  73.813  1.00 19.83           C  
ATOM   1649  N   GLN A 213       5.345  44.098  68.600  1.00 18.90           N  
ATOM   1650  CA  GLN A 213       4.630  44.915  67.620  1.00 19.87           C  
ATOM   1651  C   GLN A 213       3.784  44.091  66.642  1.00 19.91           C  
ATOM   1652  O   GLN A 213       2.934  44.650  65.960  1.00 19.89           O  
ATOM   1653  CB  GLN A 213       5.597  45.812  66.853  1.00 19.36           C  
ATOM   1654  CG  GLN A 213       6.252  46.878  67.701  1.00 20.07           C  
ATOM   1655  CD  GLN A 213       7.646  46.511  68.174  1.00 20.12           C  
ATOM   1656  OE1 GLN A 213       8.486  47.397  68.425  1.00 21.88           O  
ATOM   1657  NE2 GLN A 213       7.903  45.220  68.327  1.00 17.05           N  
ATOM   1658  N   ASP A 214       4.026  42.775  66.585  1.00 20.58           N  
ATOM   1659  CA  ASP A 214       3.312  41.866  65.688  1.00 21.34           C  
ATOM   1660  C   ASP A 214       2.003  41.362  66.289  1.00 21.51           C  
ATOM   1661  O   ASP A 214       1.171  40.787  65.589  1.00 21.29           O  
ATOM   1662  CB  ASP A 214       4.190  40.660  65.308  1.00 21.32           C  
ATOM   1663  CG  ASP A 214       5.231  40.985  64.222  1.00 24.22           C  
ATOM   1664  OD1 ASP A 214       5.040  41.943  63.431  1.00 24.38           O  
ATOM   1665  OD2 ASP A 214       6.243  40.249  64.154  1.00 26.78           O  
ATOM   1666  N   LEU A 215       1.819  41.556  67.591  1.00 21.82           N  
ATOM   1667  CA  LEU A 215       0.595  41.102  68.242  1.00 22.56           C  
ATOM   1668  C   LEU A 215      -0.719  41.469  67.558  1.00 23.16           C  
ATOM   1669  O   LEU A 215      -1.558  40.596  67.370  1.00 22.46           O  
ATOM   1670  CB  LEU A 215       0.542  41.552  69.699  1.00 23.23           C  
ATOM   1671  CG  LEU A 215       0.733  40.609  70.873  1.00 23.47           C  
ATOM   1672  CD1 LEU A 215      -0.013  41.238  72.059  1.00 22.74           C  
ATOM   1673  CD2 LEU A 215       0.163  39.251  70.611  1.00 21.63           C  
ATOM   1674  N   PRO A 216      -0.935  42.763  67.221  1.00 24.17           N  
ATOM   1675  CA  PRO A 216      -2.203  43.072  66.536  1.00 24.79           C  
ATOM   1676  C   PRO A 216      -2.421  42.248  65.260  1.00 25.40           C  
ATOM   1677  O   PRO A 216      -3.517  41.713  65.063  1.00 25.60           O  
ATOM   1678  CB  PRO A 216      -2.080  44.570  66.232  1.00 25.07           C  
ATOM   1679  CG  PRO A 216      -1.182  45.082  67.336  1.00 25.06           C  
ATOM   1680  CD  PRO A 216      -0.139  43.990  67.456  1.00 24.39           C  
ATOM   1681  N   ALA A 217      -1.381  42.101  64.431  1.00 25.23           N  
ATOM   1682  CA  ALA A 217      -1.503  41.321  63.186  1.00 25.59           C  
ATOM   1683  C   ALA A 217      -1.736  39.836  63.448  1.00 25.62           C  
ATOM   1684  O   ALA A 217      -2.576  39.207  62.803  1.00 25.89           O  
ATOM   1685  CB  ALA A 217      -0.271  41.505  62.300  1.00 25.02           C  
ATOM   1686  N   VAL A 218      -0.988  39.279  64.394  1.00 25.31           N  
ATOM   1687  CA  VAL A 218      -1.079  37.860  64.680  1.00 25.60           C  
ATOM   1688  C   VAL A 218      -2.454  37.511  65.273  1.00 25.29           C  
ATOM   1689  O   VAL A 218      -3.036  36.485  64.928  1.00 24.54           O  
ATOM   1690  CB  VAL A 218       0.094  37.409  65.577  1.00 25.48           C  
ATOM   1691  CG1 VAL A 218      -0.137  36.029  66.087  1.00 26.78           C  
ATOM   1692  CG2 VAL A 218       1.355  37.429  64.768  1.00 27.07           C  
ATOM   1693  N   ILE A 219      -2.980  38.387  66.134  1.00 25.75           N  
ATOM   1694  CA  ILE A 219      -4.297  38.165  66.753  1.00 25.79           C  
ATOM   1695  C   ILE A 219      -5.420  38.226  65.712  1.00 26.74           C  
ATOM   1696  O   ILE A 219      -6.267  37.339  65.654  1.00 26.84           O  
ATOM   1697  CB  ILE A 219      -4.550  39.086  67.965  1.00 25.37           C  
ATOM   1698  CG1 ILE A 219      -3.635  38.653  69.112  1.00 24.30           C  
ATOM   1699  CG2 ILE A 219      -6.022  38.987  68.434  1.00 25.27           C  
ATOM   1700  CD1 ILE A 219      -3.590  39.574  70.306  1.00 23.62           C  
ATOM   1701  N   ALA A 220      -5.383  39.247  64.866  1.00 28.29           N  
ATOM   1702  CA  ALA A 220      -6.321  39.367  63.764  1.00 29.64           C  
ATOM   1703  C   ALA A 220      -6.318  38.122  62.859  1.00 30.72           C  
ATOM   1704  O   ALA A 220      -7.381  37.602  62.494  1.00 32.23           O  
ATOM   1705  CB  ALA A 220      -6.044  40.644  62.968  1.00 29.24           C  
ATOM   1706  N   ALA A 221      -5.132  37.639  62.513  1.00 31.19           N  
ATOM   1707  CA  ALA A 221      -4.993  36.449  61.688  1.00 31.33           C  
ATOM   1708  C   ALA A 221      -5.505  35.169  62.374  1.00 31.71           C  
ATOM   1709  O   ALA A 221      -6.145  34.321  61.724  1.00 31.89           O  
ATOM   1710  CB  ALA A 221      -3.534  36.284  61.231  1.00 31.42           C  
HETATM 1711  N   MSE A 222      -5.232  35.019  63.667  1.00 31.30           N  
HETATM 1712  CA  MSE A 222      -5.754  33.872  64.427  1.00 31.81           C  
HETATM 1713  C   MSE A 222      -7.289  33.850  64.508  1.00 32.73           C  
HETATM 1714  O   MSE A 222      -7.904  32.773  64.436  1.00 32.13           O  
HETATM 1715  CB  MSE A 222      -5.138  33.792  65.824  1.00 31.41           C  
HETATM 1716  CG  MSE A 222      -3.680  33.366  65.826  1.00 30.49           C  
HETATM 1717 SE   MSE A 222      -2.848  33.510  67.602  0.70 31.34          SE  
HETATM 1718  CE  MSE A 222      -4.061  32.332  68.649  1.00 27.31           C  
ATOM   1719  N   ALA A 223      -7.891  35.033  64.644  1.00 33.94           N  
ATOM   1720  CA  ALA A 223      -9.348  35.181  64.661  1.00 36.07           C  
ATOM   1721  C   ALA A 223      -9.960  34.795  63.304  1.00 37.52           C  
ATOM   1722  O   ALA A 223     -11.159  34.544  63.215  1.00 38.24           O  
ATOM   1723  CB  ALA A 223      -9.737  36.598  65.049  1.00 35.75           C  
ATOM   1724  N   GLU A 224      -9.092  34.719  62.288  1.00 39.06           N  
ATOM   1725  CA  GLU A 224      -9.363  34.357  60.874  1.00 40.41           C  
ATOM   1726  C   GLU A 224      -9.868  35.526  60.033  1.00 40.48           C  
ATOM   1727  O   GLU A 224      -9.209  35.921  59.069  1.00 40.94           O  
ATOM   1728  CB  GLU A 224     -10.239  33.104  60.688  1.00 40.85           C  
ATOM   1729  CG  GLU A 224      -9.728  31.824  61.364  1.00 43.80           C  
ATOM   1730  CD  GLU A 224      -8.356  31.351  60.886  1.00 46.98           C  
ATOM   1731  OE1 GLU A 224      -7.641  30.726  61.707  1.00 48.50           O  
ATOM   1732  OE2 GLU A 224      -7.993  31.580  59.706  1.00 48.76           O  
TER    1733      GLU A 224                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
