
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  218 ( 1675),  selected  218 , name 1te2_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 1te2_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     5_A      -       -           -
LGA    Q     6_A      K       2          3.833
LGA    I     7_A      Y       3          1.803
LGA    L     8_A      T       4          2.070
LGA    A     9_A      V       5          0.775
LGA    A    10_A      Y       6          0.883
LGA    I    11_A      L       7          0.744
LGA    F    12_A      F       8          1.072
LGA    D    13_A      D       9          0.692
LGA    X    14_A      F      10          0.398
LGA    D    15_A      D      11          0.426
LGA    G    16_A      Y      12          0.556
LGA    L    17_A      T      13          0.678
LGA    L    18_A      L      14          0.969
LGA    I    19_A      A      15          0.966
LGA    D    20_A      D      16          0.615
LGA    S    21_A      S      17          0.913
LGA    E    22_A      S      18          2.355
LGA    P    23_A      R      19          3.320
LGA    L    24_A      G      20          2.162
LGA    W    25_A      I      21          1.072
LGA    D    26_A      V      22          1.934
LGA    R    27_A      T      23          2.029
LGA    A    28_A      C      24          0.856
LGA    E    29_A      F      25          0.723
LGA    L    30_A      R      26          1.233
LGA    D    31_A      S      27          1.137
LGA    V    32_A      V      28          0.686
LGA    X    33_A      L      29          1.069
LGA    A    34_A      E      30          0.570
LGA    S    35_A      R      31          0.443
LGA    L    36_A      H      32          1.414
LGA    G    37_A      G      33          1.776
LGA    V    38_A      Y      34          2.428
LGA    D    39_A      T      35          3.668
LGA    I    40_A      -       -           -
LGA    S    41_A      G      36          2.410
LGA    R    42_A      I      37           #
LGA    -       -      T      38           -
LGA    -       -      D      39           -
LGA    -       -      D      40           -
LGA    R    43_A      M      41           #
LGA    N    44_A      I      42           -
LGA    E    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    P    47_A      -       -           -
LGA    D    48_A      K      43           #
LGA    -       -      R      44           -
LGA    T    49_A      T      45          2.541
LGA    L    50_A      I      46          3.990
LGA    G    51_A      G      47          2.162
LGA    L    52_A      K      48          0.848
LGA    R    53_A      T      49          1.343
LGA    I    54_A      L      50          1.105
LGA    D    55_A      E      51          1.698
LGA    X    56_A      E      52          1.303
LGA    V    57_A      S      53          1.334
LGA    V    58_A      F      54          2.105
LGA    D    59_A      S      55          3.083
LGA    L    60_A      I      56          3.180
LGA    W    61_A      L      57          3.946
LGA    -       -      T      58           -
LGA    Y    62_A      G      59          4.669
LGA    A    63_A      I      60          2.147
LGA    R    64_A      T      61           -
LGA    Q    65_A      -       -           -
LGA    P    66_A      D      62           #
LGA    W    67_A      A      63           -
LGA    N    68_A      -       -           -
LGA    G    69_A      -       -           -
LGA    P    70_A      -       -           -
LGA    S    71_A      D      64          4.330
LGA    R    72_A      Q      65          3.214
LGA    -       -      L      66           -
LGA    Q    73_A      E      67          1.488
LGA    E    74_A      S      68          2.736
LGA    V    75_A      F      69          1.659
LGA    V    76_A      R      70          0.630
LGA    E    77_A      Q      71          2.329
LGA    R    78_A      E      72          2.252
LGA    V    79_A      Y      73          1.393
LGA    I    80_A      S      74          2.792
LGA    A    81_A      K      75          3.498
LGA    R    82_A      E      76          2.228
LGA    A    83_A      A      77          3.181
LGA    I    84_A      D      78          4.632
LGA    S    85_A      I      79          3.148
LGA    L    86_A      Y      80          2.581
LGA    V    87_A      M      81          3.491
LGA    E    88_A      N      82          2.821
LGA    E    89_A      A      83          1.983
LGA    T    90_A      N      84          3.340
LGA    R    91_A      T      85          4.219
LGA    P    92_A      I      86          0.578
LGA    L    93_A      L      87          0.636
LGA    L    94_A      F      88          0.947
LGA    P    95_A      P      89          1.408
LGA    G    96_A      D      90          0.418
LGA    V    97_A      T      91          0.355
LGA    R    98_A      L      92          0.551
LGA    E    99_A      P      93          1.119
LGA    A   100_A      T      94          1.321
LGA    V   101_A      L      95          0.854
LGA    A   102_A      T      96          1.041
LGA    L   103_A      H      97          1.720
LGA    C   104_A      L      98          1.498
LGA    K   105_A      K      99          1.054
LGA    E   106_A      K     100          1.915
LGA    Q   107_A      Q     101          2.002
LGA    G   108_A      G     102          1.847
LGA    L   109_A      I     103          1.134
LGA    L   110_A      R     104          1.028
LGA    V   111_A      I     105          1.016
LGA    G   112_A      G     106          0.738
LGA    L   113_A      I     107          0.698
LGA    A   114_A      I     108          0.432
LGA    S   115_A      S     109          0.292
LGA    A   116_A      T     110          0.360
LGA    S   117_A      K     111          0.862
LGA    P   118_A      Y     112          0.986
LGA    L   119_A      R     113          1.587
LGA    H   120_A      F     114          0.783
LGA    X   121_A      R     115          0.850
LGA    L   122_A      I     116          1.827
LGA    E   123_A      L     117          1.253
LGA    K   124_A      S     118          1.155
LGA    V   125_A      F     119          1.680
LGA    L   126_A      L     120          1.653
LGA    T   127_A      R     121          1.397
LGA    X   128_A      N     122          1.817
LGA    F   129_A      H     123          0.817
LGA    D   130_A      M     124          2.895
LGA    L   131_A      P     125          3.736
LGA    R   132_A      D     126          3.697
LGA    D   133_A      D     127          0.969
LGA    S   134_A      W     128          1.199
LGA    F   135_A      F     129          0.461
LGA    D   136_A      D     130          0.890
LGA    A   137_A      I     131          0.775
LGA    L   138_A      I     132          0.757
LGA    A   139_A      I     133          0.599
LGA    S   140_A      G     134          1.530
LGA    A   141_A      G     135          3.053
LGA    E   142_A      E     136          3.027
LGA    K   143_A      D     137          4.991
LGA    L   144_A      V     138          2.919
LGA    P   145_A      T     139          3.414
LGA    Y   146_A      H     140          2.271
LGA    S   147_A      H     141          1.117
LGA    K   148_A      K     142          1.095
LGA    P   149_A      P     143          1.116
LGA    H   150_A      D     144          1.196
LGA    P   151_A      P     145          1.122
LGA    Q   152_A      E     146          1.103
LGA    V   153_A      G     147          1.204
LGA    Y   154_A      L     148          0.801
LGA    L   155_A      L     149          0.837
LGA    D   156_A      L     150          1.124
LGA    C   157_A      A     151          1.430
LGA    A   158_A      I     152          1.348
LGA    A   159_A      D     153          1.720
LGA    K   160_A      R     154          2.172
LGA    L   161_A      L     155          2.003
LGA    G   162_A      K     156          2.262
LGA    V   163_A      A     157          1.002
LGA    D   164_A      C     158          2.231
LGA    P   165_A      P     159          2.631
LGA    L   166_A      E     160          2.783
LGA    T   167_A      E     161          1.756
LGA    C   168_A      V     162          0.890
LGA    V   169_A      L     163          0.747
LGA    A   170_A      Y     164          1.053
LGA    L   171_A      I     165          1.245
LGA    E   172_A      G     166          0.470
LGA    D   173_A      D     167          0.736
LGA    S   174_A      S     168          0.669
LGA    V   175_A      T     169          0.988
LGA    N   176_A      V     170          0.776
LGA    G   177_A      D     171          0.907
LGA    X   178_A      A     172          1.535
LGA    I   179_A      G     173          1.270
LGA    A   180_A      T     174          0.164
LGA    S   181_A      A     175          1.350
LGA    K   182_A      A     176          1.921
LGA    A   183_A      A     177          1.352
LGA    A   184_A      A     178          0.925
LGA    R   185_A      G     179          1.404
LGA    X   186_A      V     180          1.406
LGA    R   187_A      S     181          1.677
LGA    S   188_A      F     182          1.387
LGA    I   189_A      T     183          1.521
LGA    V   190_A      G     184          1.528
LGA    V   191_A      V     185          1.147
LGA    P   192_A      T     186          1.493
LGA    A   193_A      S     187          3.239
LGA    P   194_A      G     188          4.559
LGA    E   195_A      M     189          2.187
LGA    A   196_A      T     190          1.435
LGA    Q   197_A      T     191          2.191
LGA    N   198_A      A     192          3.680
LGA    D   199_A      Q     193          3.023
LGA    P   200_A      E     194          3.416
LGA    R   201_A      F     195          2.399
LGA    F   202_A      Q     196          4.189
LGA    V   203_A      A     197           #
LGA    -       -      Y     198           -
LGA    L   204_A      P     199          2.102
LGA    A   205_A      Y     200          1.559
LGA    N   206_A      D     201          0.549
LGA    V   207_A      R     202          1.536
LGA    K   208_A      I     203          1.362
LGA    L   209_A      I     204          1.247
LGA    S   210_A      S     205          0.695
LGA    S   211_A      T     206          0.765
LGA    L   212_A      L     207          1.238
LGA    T   213_A      G     208          2.433
LGA    E   214_A      Q     209          2.176
LGA    L   215_A      L     210          2.294
LGA    T   216_A      I     211          1.018
LGA    A   217_A      -       -           -
LGA    K   218_A      -       -           -
LGA    D   219_A      -       -           -
LGA    L   220_A      -       -           -
LGA    L   221_A      -       -           -
LGA    G   222_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  218  210    5.0    195    1.99    18.97     73.001     9.327

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.259744 * X  +   0.905098 * Y  +  -0.336647 * Z  + -49.777916
  Y_new =  -0.711690 * X  +  -0.056211 * Y  +  -0.700241 * Z  +  58.432327
  Z_new =  -0.652710 * X  +   0.421472 * Y  +   0.629548 * Z  +  84.462456 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.589950   -2.551643  [ DEG:    33.8016   -146.1984 ]
  Theta =   0.711156    2.430436  [ DEG:    40.7462    139.2538 ]
  Phi   =  -1.220849    1.920743  [ DEG:   -69.9495    110.0505 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1te2_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1te2_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  218  210   5.0  195   1.99   18.97  73.001
REMARK  ---------------------------------------------------------- 
MOLECULE 1te2_A
HEADER    HYDROLASE                               24-MAY-04   1TE2              
TITLE     PUTATIVE PHOSPHATASE YNIC FROM ESCHERICHIA COLI K12                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PHOSPHATASE;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 3.1.3.18;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI O157:H7;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YNIC;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET15                                     
KEYWDS    STRUCTURAL GENOMICS, PHOSPHATASE, PHOSPHATES, PSI, PROTEIN            
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,A.JOACHIMIAK,E.EVDOKIMOVA,A.SAVCHENKO,A.EDWARDS,                
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   2   18-JAN-05 1TE2    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   03-AUG-04 1TE2    0                                                
JRNL        AUTH   Y.KIM,A.JOACHIMIAK,E.EVDOKIMOVA,A.SAVCHENKO,                 
JRNL        AUTH 2 A.EDWARDS                                                    
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE PHOSPHATASE YNIC               
JRNL        TITL 2 FROM ESCHERICHIA COLI K12                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.76 ANGSTROMS.                                          
DBREF  1TE2 A    1   222  UNP    P77247   YNIC_ECOLI       1    222             
DBREF  1TE2 B    1   222  UNP    P77247   YNIC_ECOLI       1    222             
SEQRES   1 A  226  GLY HIS MET SER THR PRO ARG GLN ILE LEU ALA ALA ILE          
SEQRES   2 A  226  PHE ASP MSE ASP GLY LEU LEU ILE ASP SER GLU PRO LEU          
SEQRES   3 A  226  TRP ASP ARG ALA GLU LEU ASP VAL MSE ALA SER LEU GLY          
SEQRES   4 A  226  VAL ASP ILE SER ARG ARG ASN GLU LEU PRO ASP THR LEU          
SEQRES   5 A  226  GLY LEU ARG ILE ASP MSE VAL VAL ASP LEU TRP TYR ALA          
SEQRES   6 A  226  ARG GLN PRO TRP ASN GLY PRO SER ARG GLN GLU VAL VAL          
SEQRES   7 A  226  GLU ARG VAL ILE ALA ARG ALA ILE SER LEU VAL GLU GLU          
SEQRES   8 A  226  THR ARG PRO LEU LEU PRO GLY VAL ARG GLU ALA VAL ALA          
SEQRES   9 A  226  LEU CYS LYS GLU GLN GLY LEU LEU VAL GLY LEU ALA SER          
SEQRES  10 A  226  ALA SER PRO LEU HIS MSE LEU GLU LYS VAL LEU THR MSE          
SEQRES  11 A  226  PHE ASP LEU ARG ASP SER PHE ASP ALA LEU ALA SER ALA          
SEQRES  12 A  226  GLU LYS LEU PRO TYR SER LYS PRO HIS PRO GLN VAL TYR          
SEQRES  13 A  226  LEU ASP CYS ALA ALA LYS LEU GLY VAL ASP PRO LEU THR          
SEQRES  14 A  226  CYS VAL ALA LEU GLU ASP SER VAL ASN GLY MSE ILE ALA          
SEQRES  15 A  226  SER LYS ALA ALA ARG MSE ARG SER ILE VAL VAL PRO ALA          
SEQRES  16 A  226  PRO GLU ALA GLN ASN ASP PRO ARG PHE VAL LEU ALA ASN          
SEQRES  17 A  226  VAL LYS LEU SER SER LEU THR GLU LEU THR ALA LYS ASP          
SEQRES  18 A  226  LEU LEU GLY GLY SER                                          
SEQRES   1 B  226  GLY HIS MET SER THR PRO ARG GLN ILE LEU ALA ALA ILE          
SEQRES   2 B  226  PHE ASP MSE ASP GLY LEU LEU ILE ASP SER GLU PRO LEU          
SEQRES   3 B  226  TRP ASP ARG ALA GLU LEU ASP VAL MSE ALA SER LEU GLY          
SEQRES   4 B  226  VAL ASP ILE SER ARG ARG ASN GLU LEU PRO ASP THR LEU          
SEQRES   5 B  226  GLY LEU ARG ILE ASP MSE VAL VAL ASP LEU TRP TYR ALA          
SEQRES   6 B  226  ARG GLN PRO TRP ASN GLY PRO SER ARG GLN GLU VAL VAL          
SEQRES   7 B  226  GLU ARG VAL ILE ALA ARG ALA ILE SER LEU VAL GLU GLU          
SEQRES   8 B  226  THR ARG PRO LEU LEU PRO GLY VAL ARG GLU ALA VAL ALA          
SEQRES   9 B  226  LEU CYS LYS GLU GLN GLY LEU LEU VAL GLY LEU ALA SER          
SEQRES  10 B  226  ALA SER PRO LEU HIS MSE LEU GLU LYS VAL LEU THR MSE          
SEQRES  11 B  226  PHE ASP LEU ARG ASP SER PHE ASP ALA LEU ALA SER ALA          
SEQRES  12 B  226  GLU LYS LEU PRO TYR SER LYS PRO HIS PRO GLN VAL TYR          
SEQRES  13 B  226  LEU ASP CYS ALA ALA LYS LEU GLY VAL ASP PRO LEU THR          
SEQRES  14 B  226  CYS VAL ALA LEU GLU ASP SER VAL ASN GLY MSE ILE ALA          
SEQRES  15 B  226  SER LYS ALA ALA ARG MSE ARG SER ILE VAL VAL PRO ALA          
SEQRES  16 B  226  PRO GLU ALA GLN ASN ASP PRO ARG PHE VAL LEU ALA ASN          
SEQRES  17 B  226  VAL LYS LEU SER SER LEU THR GLU LEU THR ALA LYS ASP          
SEQRES  18 B  226  LEU LEU GLY GLY SER                                          
HET    MSE  A  14      16                                                       
HET    MSE  A  33       8                                                       
HET    MSE  A  56       8                                                       
HET    MSE  A 121       8                                                       
HET    MSE  A 128      16                                                       
HET    MSE  A 178       8                                                       
HET    MSE  A 186       8                                                       
HET    MSE  B  14       8                                                       
HET    MSE  B  33       8                                                       
HET    MSE  B  56      16                                                       
HET    MSE  B 121       8                                                       
HET    MSE  B 128       8                                                       
HET    MSE  B 178       8                                                       
HET    MSE  B 186       8                                                       
HET    PGA    711       8                                                       
HET    PGA    712       8                                                       
HET     CA    701       1                                                       
HET     CA    702       1                                                       
HET     CA    703       1                                                       
HET     CA    704       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PGA 2-PHOSPHOGLYCOLIC ACID                                           
HETNAM      CA CALCIUM ION                                                      
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   3  PGA    2(C2 H5 O6 P)                                                
FORMUL   5   CA    4(CA 2+)                                                     
FORMUL   9  HOH   *637(H2 O)                                                    
CRYST1   48.591   88.447   48.591  90.00  97.26  90.00 P 1 21 1      4          
ATOM      1  N   ARG A   5     -14.865  31.649  68.053  1.00 31.67           N  
ATOM      2  CA  ARG A   5     -14.175  32.092  69.306  1.00 31.28           C  
ATOM      3  C   ARG A   5     -14.244  33.611  69.427  1.00 30.44           C  
ATOM      4  O   ARG A   5     -13.556  34.314  68.691  1.00 31.30           O  
ATOM      5  CB  ARG A   5     -12.711  31.638  69.286  1.00 31.49           C  
ATOM      6  CG  ARG A   5     -11.773  32.394  70.229  1.00 31.55           C  
ATOM      7  CD  ARG A   5     -11.324  31.598  71.417  1.00 31.26           C  
ATOM      8  NE  ARG A   5     -10.302  30.621  71.052  1.00 29.79           N  
ATOM      9  CZ  ARG A   5      -9.806  29.721  71.894  1.00 29.20           C  
ATOM     10  NH1 ARG A   5     -10.238  29.658  73.146  1.00 26.00           N  
ATOM     11  NH2 ARG A   5      -8.872  28.873  71.480  1.00 31.02           N  
ATOM     12  N   GLN A   6     -15.059  34.125  70.345  1.00 29.20           N  
ATOM     13  CA  GLN A   6     -15.089  35.569  70.557  1.00 27.98           C  
ATOM     14  C   GLN A   6     -14.128  35.944  71.668  1.00 25.36           C  
ATOM     15  O   GLN A   6     -14.271  35.471  72.789  1.00 25.88           O  
ATOM     16  CB  GLN A   6     -16.481  36.064  70.918  1.00 28.36           C  
ATOM     17  CG  GLN A   6     -16.515  37.596  71.064  1.00 29.49           C  
ATOM     18  CD  GLN A   6     -17.885  38.148  71.413  1.00 30.80           C  
ATOM     19  OE1 GLN A   6     -18.418  37.882  72.505  1.00 33.29           O  
ATOM     20  NE2 GLN A   6     -18.453  38.939  70.497  1.00 32.80           N  
ATOM     21  N   ILE A   7     -13.173  36.813  71.362  1.00 22.31           N  
ATOM     22  CA  ILE A   7     -12.185  37.248  72.345  1.00 19.81           C  
ATOM     23  C   ILE A   7     -12.664  38.505  73.080  1.00 18.18           C  
ATOM     24  O   ILE A   7     -13.029  39.504  72.451  1.00 17.23           O  
ATOM     25  CB  ILE A   7     -10.827  37.508  71.669  1.00 19.28           C  
ATOM     26  CG1 ILE A   7     -10.313  36.228  70.987  1.00 18.53           C  
ATOM     27  CG2 ILE A   7      -9.809  38.026  72.689  1.00 18.56           C  
ATOM     28  CD1 ILE A   7     -10.052  35.054  71.917  1.00 18.60           C  
ATOM     29  N   LEU A   8     -12.673  38.417  74.411  1.00 16.55           N  
ATOM     30  CA  LEU A   8     -13.073  39.494  75.306  1.00 15.68           C  
ATOM     31  C   LEU A   8     -11.910  40.041  76.156  1.00 14.46           C  
ATOM     32  O   LEU A   8     -12.005  41.132  76.698  1.00 13.89           O  
ATOM     33  CB  LEU A   8     -14.163  38.985  76.255  1.00 16.00           C  
ATOM     34  CG  LEU A   8     -15.506  38.485  75.711  1.00 16.97           C  
ATOM     35  CD1 LEU A   8     -16.387  38.082  76.874  1.00 18.27           C  
ATOM     36  CD2 LEU A   8     -16.205  39.541  74.884  1.00 19.46           C  
ATOM     37  N   ALA A   9     -10.830  39.280  76.298  1.00 13.22           N  
ATOM     38  CA  ALA A   9      -9.702  39.705  77.122  1.00 13.39           C  
ATOM     39  C   ALA A   9      -8.371  39.207  76.597  1.00 13.12           C  
ATOM     40  O   ALA A   9      -8.297  38.149  75.976  1.00 13.21           O  
ATOM     41  CB  ALA A   9      -9.888  39.238  78.565  1.00 12.94           C  
ATOM     42  N   ALA A  10      -7.337  39.996  76.858  1.00 13.62           N  
ATOM     43  CA  ALA A  10      -5.953  39.625  76.591  1.00 13.53           C  
ATOM     44  C   ALA A  10      -5.223  39.534  77.932  1.00 13.45           C  
ATOM     45  O   ALA A  10      -5.296  40.457  78.732  1.00 14.14           O  
ATOM     46  CB  ALA A  10      -5.314  40.650  75.714  1.00 13.65           C  
ATOM     47  N   ILE A  11      -4.519  38.426  78.158  1.00 12.87           N  
ATOM     48  CA  ILE A  11      -3.730  38.219  79.373  1.00 12.93           C  
ATOM     49  C   ILE A  11      -2.273  38.099  78.963  1.00 12.86           C  
ATOM     50  O   ILE A  11      -1.914  37.206  78.197  1.00 13.09           O  
ATOM     51  CB  ILE A  11      -4.184  36.938  80.116  1.00 12.43           C  
ATOM     52  CG1 ILE A  11      -5.679  37.044  80.454  1.00 13.84           C  
ATOM     53  CG2 ILE A  11      -3.320  36.715  81.356  1.00 13.52           C  
ATOM     54  CD1 ILE A  11      -6.296  35.843  81.138  1.00 13.37           C  
ATOM     55  N   PHE A  12      -1.445  38.983  79.494  1.00 13.03           N  
ATOM     56  CA  PHE A  12      -0.021  38.986  79.216  1.00 13.54           C  
ATOM     57  C   PHE A  12       0.750  38.190  80.257  1.00 13.85           C  
ATOM     58  O   PHE A  12       0.465  38.268  81.454  1.00 14.63           O  
ATOM     59  CB  PHE A  12       0.490  40.427  79.210  1.00 13.66           C  
ATOM     60  CG  PHE A  12       0.032  41.228  78.033  1.00 12.80           C  
ATOM     61  CD1 PHE A  12       0.862  41.400  76.928  1.00 14.09           C  
ATOM     62  CD2 PHE A  12      -1.208  41.844  78.033  1.00 12.98           C  
ATOM     63  CE1 PHE A  12       0.444  42.150  75.836  1.00 13.35           C  
ATOM     64  CE2 PHE A  12      -1.634  42.589  76.933  1.00 12.34           C  
ATOM     65  CZ  PHE A  12      -0.810  42.741  75.842  1.00 13.78           C  
ATOM     66  N   ASP A  13       1.723  37.415  79.782  1.00 14.70           N  
ATOM     67  CA  ASP A  13       2.792  36.872  80.600  1.00 15.11           C  
ATOM     68  C   ASP A  13       3.636  38.067  81.000  1.00 15.57           C  
ATOM     69  O   ASP A  13       3.592  39.108  80.338  1.00 14.73           O  
ATOM     70  CB  ASP A  13       3.599  35.886  79.755  1.00 15.47           C  
ATOM     71  CG  ASP A  13       4.813  35.332  80.457  1.00 16.55           C  
ATOM     72  OD1 ASP A  13       4.729  34.971  81.632  1.00 17.62           O  
ATOM     73  OD2 ASP A  13       5.902  35.181  79.881  1.00 18.13           O  
HETATM   74  N   MSE A  14       4.333  37.902  82.116  0.50 15.34           N  
HETATM   76  CA  MSE A  14       5.230  38.942  82.570  0.49 16.09           C  
HETATM   78  C   MSE A  14       6.699  38.734  82.081  0.53 15.41           C  
HETATM   80  O   MSE A  14       7.112  39.324  81.100  0.48 15.14           O  
HETATM   82  CB  MSE A  14       5.141  39.172  84.095  0.51 15.77           C  
HETATM   84  CG  MSE A  14       5.978  40.413  84.368  0.49 17.42           C  
HETATM   86 SE   MSE A  14       6.111  41.083  86.096  0.56 19.54          SE  
HETATM   88  CE  MSE A  14       7.142  39.611  86.976  0.58 18.25           C  
ATOM     90  N   ASP A  15       7.445  37.927  82.808  1.00 15.01           N  
ATOM     91  CA  ASP A  15       8.884  37.732  82.607  1.00 14.94           C  
ATOM     92  C   ASP A  15       9.197  37.178  81.219  1.00 14.86           C  
ATOM     93  O   ASP A  15       8.741  36.107  80.852  1.00 13.91           O  
ATOM     94  CB  ASP A  15       9.457  36.790  83.670  1.00 15.30           C  
ATOM     95  CG  ASP A  15       9.303  37.322  85.071  1.00 17.32           C  
ATOM     96  OD1 ASP A  15       9.929  38.366  85.395  1.00 16.53           O  
ATOM     97  OD2 ASP A  15       8.584  36.741  85.922  1.00 18.57           O  
ATOM     98  N   GLY A  16      10.000  37.924  80.477  1.00 14.86           N  
ATOM     99  CA  GLY A  16      10.394  37.567  79.130  1.00 15.06           C  
ATOM    100  C   GLY A  16       9.411  37.999  78.062  1.00 15.10           C  
ATOM    101  O   GLY A  16       9.676  37.830  76.888  1.00 15.09           O  
ATOM    102  N   LEU A  17       8.276  38.551  78.470  1.00 15.16           N  
ATOM    103  CA  LEU A  17       7.220  38.960  77.550  1.00 15.33           C  
ATOM    104  C   LEU A  17       6.988  40.477  77.602  1.00 15.90           C  
ATOM    105  O   LEU A  17       7.033  41.155  76.563  1.00 15.84           O  
ATOM    106  CB  LEU A  17       5.935  38.192  77.855  1.00 14.58           C  
ATOM    107  CG  LEU A  17       4.791  38.185  76.816  1.00 15.57           C  
ATOM    108  CD1 LEU A  17       3.968  39.445  76.873  1.00 15.79           C  
ATOM    109  CD2 LEU A  17       5.309  37.953  75.420  1.00 13.95           C  
ATOM    110  N   LEU A  18       6.695  40.988  78.796  1.00 15.71           N  
ATOM    111  CA  LEU A  18       6.616  42.427  79.056  1.00 16.26           C  
ATOM    112  C   LEU A  18       7.965  43.026  79.429  1.00 16.50           C  
ATOM    113  O   LEU A  18       8.221  44.189  79.140  1.00 15.68           O  
ATOM    114  CB  LEU A  18       5.635  42.741  80.203  1.00 16.20           C  
ATOM    115  CG  LEU A  18       4.149  42.412  80.054  1.00 17.71           C  
ATOM    116  CD1 LEU A  18       3.409  42.832  81.323  1.00 18.97           C  
ATOM    117  CD2 LEU A  18       3.491  43.049  78.847  1.00 19.45           C  
ATOM    118  N   ILE A  19       8.798  42.255  80.127  1.00 17.30           N  
ATOM    119  CA  ILE A  19      10.091  42.745  80.599  1.00 17.92           C  
ATOM    120  C   ILE A  19      11.182  41.759  80.279  1.00 18.29           C  
ATOM    121  O   ILE A  19      10.964  40.544  80.245  1.00 18.16           O  
ATOM    122  CB  ILE A  19      10.081  43.056  82.133  1.00 18.22           C  
ATOM    123  CG1 ILE A  19       9.751  41.798  82.953  1.00 18.20           C  
ATOM    124  CG2 ILE A  19       9.102  44.174  82.444  1.00 18.43           C  
ATOM    125  CD1 ILE A  19       9.922  41.966  84.467  1.00 17.79           C  
ATOM    126  N   ASP A  20      12.374  42.283  80.051  1.00 18.72           N  
ATOM    127  CA  ASP A  20      13.504  41.457  79.711  1.00 18.95           C  
ATOM    128  C   ASP A  20      14.211  41.054  81.012  1.00 18.82           C  
ATOM    129  O   ASP A  20      15.377  41.421  81.259  1.00 18.61           O  
ATOM    130  CB  ASP A  20      14.433  42.221  78.761  1.00 19.26           C  
ATOM    131  CG  ASP A  20      15.450  41.326  78.103  1.00 20.78           C  
ATOM    132  OD1 ASP A  20      15.387  40.092  78.291  1.00 21.73           O  
ATOM    133  OD2 ASP A  20      16.369  41.770  77.379  1.00 22.20           O  
ATOM    134  N   SER A  21      13.503  40.263  81.822  1.00 18.21           N  
ATOM    135  CA  SER A  21      13.956  39.890  83.159  1.00 18.05           C  
ATOM    136  C   SER A  21      14.673  38.532  83.244  1.00 18.41           C  
ATOM    137  O   SER A  21      15.304  38.242  84.257  1.00 18.59           O  
ATOM    138  CB  SER A  21      12.762  39.881  84.110  1.00 17.97           C  
ATOM    139  OG  SER A  21      11.761  39.004  83.613  1.00 15.73           O  
ATOM    140  N   GLU A  22      14.577  37.702  82.206  1.00 18.75           N  
ATOM    141  CA  GLU A  22      15.189  36.368  82.241  1.00 19.36           C  
ATOM    142  C   GLU A  22      16.677  36.404  82.541  1.00 19.53           C  
ATOM    143  O   GLU A  22      17.131  35.625  83.371  1.00 19.02           O  
ATOM    144  CB  GLU A  22      14.921  35.574  80.962  1.00 19.51           C  
ATOM    145  CG  GLU A  22      13.475  35.119  80.806  1.00 20.71           C  
ATOM    146  CD  GLU A  22      13.024  34.153  81.889  1.00 22.70           C  
ATOM    147  OE1 GLU A  22      13.893  33.446  82.467  1.00 23.39           O  
ATOM    148  OE2 GLU A  22      11.795  34.098  82.163  1.00 23.83           O  
ATOM    149  N   PRO A  23      17.442  37.299  81.906  1.00 19.75           N  
ATOM    150  CA  PRO A  23      18.855  37.453  82.271  1.00 19.54           C  
ATOM    151  C   PRO A  23      19.062  37.994  83.689  1.00 18.73           C  
ATOM    152  O   PRO A  23      20.079  37.685  84.293  1.00 18.62           O  
ATOM    153  CB  PRO A  23      19.394  38.431  81.212  1.00 19.49           C  
ATOM    154  CG  PRO A  23      18.237  39.160  80.714  1.00 21.00           C  
ATOM    155  CD  PRO A  23      17.077  38.204  80.796  1.00 19.64           C  
ATOM    156  N   LEU A  24      18.119  38.779  84.203  1.00 18.71           N  
ATOM    157  CA  LEU A  24      18.189  39.289  85.575  1.00 17.80           C  
ATOM    158  C   LEU A  24      17.917  38.201  86.620  1.00 17.83           C  
ATOM    159  O   LEU A  24      18.628  38.104  87.630  1.00 17.57           O  
ATOM    160  CB  LEU A  24      17.253  40.487  85.750  1.00 17.89           C  
ATOM    161  CG  LEU A  24      17.473  41.594  84.713  1.00 18.01           C  
ATOM    162  CD1 LEU A  24      16.520  42.747  84.892  1.00 17.62           C  
ATOM    163  CD2 LEU A  24      18.934  42.070  84.694  1.00 17.90           C  
ATOM    164  N   TRP A  25      16.891  37.387  86.386  1.00 17.42           N  
ATOM    165  CA  TRP A  25      16.666  36.196  87.191  1.00 17.65           C  
ATOM    166  C   TRP A  25      17.880  35.281  87.155  1.00 17.86           C  
ATOM    167  O   TRP A  25      18.230  34.710  88.154  1.00 17.35           O  
ATOM    168  CB  TRP A  25      15.438  35.426  86.707  1.00 17.41           C  
ATOM    169  CG  TRP A  25      14.125  36.009  87.140  1.00 16.10           C  
ATOM    170  CD1 TRP A  25      13.250  36.743  86.378  1.00 16.68           C  
ATOM    171  CD2 TRP A  25      13.517  35.880  88.424  1.00 16.11           C  
ATOM    172  NE1 TRP A  25      12.140  37.074  87.118  1.00 16.02           N  
ATOM    173  CE2 TRP A  25      12.278  36.559  88.379  1.00 15.72           C  
ATOM    174  CE3 TRP A  25      13.896  35.265  89.617  1.00 15.22           C  
ATOM    175  CZ2 TRP A  25      11.418  36.634  89.483  1.00 16.65           C  
ATOM    176  CZ3 TRP A  25      13.032  35.341  90.714  1.00 16.06           C  
ATOM    177  CH2 TRP A  25      11.824  36.029  90.636  1.00 16.21           C  
ATOM    178  N   ASP A  26      18.523  35.132  85.999  1.00 18.05           N  
ATOM    179  CA  ASP A  26      19.701  34.262  85.906  1.00 18.60           C  
ATOM    180  C   ASP A  26      20.794  34.764  86.830  1.00 18.47           C  
ATOM    181  O   ASP A  26      21.391  33.997  87.577  1.00 18.61           O  
ATOM    182  CB  ASP A  26      20.293  34.262  84.489  1.00 18.81           C  
ATOM    183  CG  ASP A  26      19.467  33.494  83.490  1.00 21.47           C  
ATOM    184  OD1 ASP A  26      18.431  32.890  83.860  1.00 23.29           O  
ATOM    185  OD2 ASP A  26      19.808  33.431  82.277  1.00 24.50           O  
ATOM    186  N   ARG A  27      21.049  36.065  86.766  1.00 18.75           N  
ATOM    187  CA  ARG A  27      22.066  36.707  87.594  1.00 19.61           C  
ATOM    188  C   ARG A  27      21.730  36.590  89.092  1.00 18.95           C  
ATOM    189  O   ARG A  27      22.606  36.320  89.903  1.00 18.80           O  
ATOM    190  CB  ARG A  27      22.219  38.169  87.168  1.00 19.87           C  
ATOM    191  CG  ARG A  27      23.143  38.998  88.026  1.00 24.07           C  
ATOM    192  CD  ARG A  27      24.583  38.514  88.044  1.00 29.77           C  
ATOM    193  NE  ARG A  27      25.458  39.516  88.651  1.00 33.47           N  
ATOM    194  CZ  ARG A  27      26.770  39.382  88.824  1.00 35.59           C  
ATOM    195  NH1 ARG A  27      27.399  38.268  88.443  1.00 38.60           N  
ATOM    196  NH2 ARG A  27      27.461  40.373  89.383  1.00 35.92           N  
ATOM    197  N   ALA A  28      20.468  36.785  89.454  1.00 18.55           N  
ATOM    198  CA  ALA A  28      20.008  36.633  90.846  1.00 17.96           C  
ATOM    199  C   ALA A  28      20.264  35.208  91.341  1.00 18.14           C  
ATOM    200  O   ALA A  28      20.796  35.001  92.414  1.00 16.85           O  
ATOM    201  CB  ALA A  28      18.519  36.964  90.944  1.00 18.07           C  
ATOM    202  N   GLU A  29      19.878  34.193  90.554  0.50 18.22           N  
ATOM    204  CA  GLU A  29      20.082  32.743  90.902  0.50 18.38           C  
ATOM    206  C   GLU A  29      21.558  32.438  91.005  0.50 18.83           C  
ATOM    208  O   GLU A  29      21.999  31.798  91.958  0.50 18.27           O  
ATOM    210  CB  GLU A  29      19.404  31.767  89.843  0.48 18.39           C  
ATOM    212  CG  GLU A  29      19.718  30.207  89.755  0.55 18.35           C  
ATOM    214  CD  GLU A  29      19.153  29.587  88.448  0.52 18.84           C  
ATOM    216  OE1 GLU A  29      18.290  30.211  87.802  0.52 19.54           O  
ATOM    218  OE2 GLU A  29      19.566  28.490  88.039  0.48 19.18           O  
ATOM    220  N   LEU A  30      22.319  32.905  90.022  1.00 19.37           N  
ATOM    221  CA  LEU A  30      23.763  32.644  90.016  1.00 20.96           C  
ATOM    222  C   LEU A  30      24.440  33.157  91.272  1.00 20.62           C  
ATOM    223  O   LEU A  30      25.177  32.433  91.926  1.00 20.88           O  
ATOM    224  CB  LEU A  30      24.412  33.335  88.809  1.00 21.44           C  
ATOM    225  CG  LEU A  30      25.929  33.576  88.845  1.00 23.61           C  
ATOM    226  CD1 LEU A  30      26.661  32.263  89.019  1.00 25.01           C  
ATOM    227  CD2 LEU A  30      26.405  34.306  87.572  1.00 23.33           C  
ATOM    228  N   ASP A  31      24.205  34.422  91.575  1.00 20.92           N  
ATOM    229  CA  ASP A  31      24.815  35.077  92.711  1.00 21.01           C  
ATOM    230  C   ASP A  31      24.429  34.413  94.028  1.00 20.16           C  
ATOM    231  O   ASP A  31      25.276  34.187  94.888  1.00 19.53           O  
ATOM    232  CB  ASP A  31      24.409  36.548  92.735  1.00 21.91           C  
ATOM    233  CG  ASP A  31      25.072  37.360  91.636  1.00 23.79           C  
ATOM    234  OD1 ASP A  31      25.992  36.844  90.951  1.00 27.20           O  
ATOM    235  OD2 ASP A  31      24.714  38.519  91.389  1.00 27.32           O  
ATOM    236  N   VAL A  32      23.154  34.076  94.186  1.00 19.61           N  
ATOM    237  CA  VAL A  32      22.709  33.432  95.426  1.00 19.01           C  
ATOM    238  C   VAL A  32      23.284  32.018  95.533  1.00 18.94           C  
ATOM    239  O   VAL A  32      23.849  31.654  96.554  1.00 18.53           O  
ATOM    240  CB  VAL A  32      21.168  33.442  95.544  1.00 18.75           C  
ATOM    241  CG1 VAL A  32      20.708  32.603  96.709  1.00 19.03           C  
ATOM    242  CG2 VAL A  32      20.659  34.880  95.698  1.00 18.93           C  
HETATM  243  N   MSE A  33      23.145  31.220  94.478  1.00 18.89           N  
HETATM  244  CA  MSE A  33      23.708  29.866  94.464  1.00 19.53           C  
HETATM  245  C   MSE A  33      25.216  29.874  94.710  1.00 18.31           C  
HETATM  246  O   MSE A  33      25.718  29.053  95.464  1.00 19.24           O  
HETATM  247  CB  MSE A  33      23.409  29.145  93.136  1.00 20.52           C  
HETATM  248  CG  MSE A  33      21.986  28.718  92.960  1.00 22.97           C  
HETATM  249 SE   MSE A  33      21.274  27.598  94.395  0.73 30.24          SE  
HETATM  250  CE  MSE A  33      19.568  28.388  94.362  1.00 26.79           C  
ATOM    251  N   ALA A  34      25.933  30.813  94.115  1.00 18.08           N  
ATOM    252  CA  ALA A  34      27.384  30.879  94.302  1.00 17.60           C  
ATOM    253  C   ALA A  34      27.697  31.140  95.778  1.00 17.78           C  
ATOM    254  O   ALA A  34      28.604  30.532  96.336  1.00 16.17           O  
ATOM    255  CB  ALA A  34      28.000  31.942  93.425  1.00 17.80           C  
ATOM    256  N   SER A  35      26.915  32.011  96.414  1.00 18.27           N  
ATOM    257  CA  SER A  35      27.131  32.348  97.826  1.00 18.71           C  
ATOM    258  C   SER A  35      26.944  31.130  98.755  1.00 19.13           C  
ATOM    259  O   SER A  35      27.486  31.099  99.868  1.00 18.59           O  
ATOM    260  CB  SER A  35      26.212  33.498  98.267  1.00 19.21           C  
ATOM    261  OG  SER A  35      24.894  33.038  98.506  1.00 19.99           O  
ATOM    262  N   LEU A  36      26.168  30.145  98.302  1.00 19.32           N  
ATOM    263  CA  LEU A  36      25.886  28.938  99.091  1.00 20.18           C  
ATOM    264  C   LEU A  36      26.921  27.841  98.914  1.00 20.64           C  
ATOM    265  O   LEU A  36      26.852  26.802  99.586  1.00 20.93           O  
ATOM    266  CB  LEU A  36      24.505  28.387  98.730  1.00 19.75           C  
ATOM    267  CG  LEU A  36      23.321  29.280  99.114  1.00 21.56           C  
ATOM    268  CD1 LEU A  36      22.039  28.696  98.613  1.00 21.00           C  
ATOM    269  CD2 LEU A  36      23.256  29.421 100.620  1.00 23.67           C  
ATOM    270  N   GLY A  37      27.885  28.067  98.026  1.00 20.75           N  
ATOM    271  CA  GLY A  37      28.902  27.080  97.742  1.00 21.37           C  
ATOM    272  C   GLY A  37      28.534  26.179  96.578  1.00 21.89           C  
ATOM    273  O   GLY A  37      29.275  25.256  96.256  1.00 22.09           O  
ATOM    274  N   VAL A  38      27.399  26.442  95.940  1.00 22.25           N  
ATOM    275  CA  VAL A  38      26.918  25.605  94.851  1.00 22.81           C  
ATOM    276  C   VAL A  38      27.820  25.764  93.625  1.00 23.73           C  
ATOM    277  O   VAL A  38      28.128  26.865  93.188  1.00 23.49           O  
ATOM    278  CB  VAL A  38      25.428  25.908  94.515  1.00 22.82           C  
ATOM    279  CG1 VAL A  38      24.954  25.140  93.271  1.00 22.80           C  
ATOM    280  CG2 VAL A  38      24.561  25.562  95.707  1.00 23.19           C  
ATOM    281  N   ASP A  39      28.257  24.622  93.110  1.00 24.58           N  
ATOM    282  CA  ASP A  39      29.076  24.536  91.910  1.00 25.43           C  
ATOM    283  C   ASP A  39      28.234  24.834  90.673  1.00 26.12           C  
ATOM    284  O   ASP A  39      27.490  23.991  90.165  1.00 25.94           O  
ATOM    285  CB  ASP A  39      29.717  23.145  91.860  1.00 25.48           C  
ATOM    286  CG  ASP A  39      30.569  22.928  90.647  1.00 25.56           C  
ATOM    287  OD1 ASP A  39      30.780  23.861  89.850  1.00 24.17           O  
ATOM    288  OD2 ASP A  39      31.070  21.808  90.423  1.00 27.21           O  
ATOM    289  N   ILE A  40      28.375  26.066  90.201  1.00 27.37           N  
ATOM    290  CA  ILE A  40      27.597  26.611  89.095  1.00 28.65           C  
ATOM    291  C   ILE A  40      27.886  25.944  87.747  1.00 29.61           C  
ATOM    292  O   ILE A  40      26.985  25.814  86.926  1.00 30.42           O  
ATOM    293  CB  ILE A  40      27.864  28.141  88.976  1.00 28.61           C  
ATOM    294  CG1 ILE A  40      27.450  28.866  90.262  1.00 29.15           C  
ATOM    295  CG2 ILE A  40      27.121  28.732  87.776  1.00 28.57           C  
ATOM    296  CD1 ILE A  40      25.993  28.622  90.667  1.00 29.27           C  
ATOM    297  N   SER A  41      29.134  25.550  87.520  1.00 30.75           N  
ATOM    298  CA  SER A  41      29.543  24.920  86.256  1.00 31.23           C  
ATOM    299  C   SER A  41      28.679  23.710  85.866  1.00 31.59           C  
ATOM    300  O   SER A  41      28.539  23.390  84.680  1.00 31.92           O  
ATOM    301  CB  SER A  41      31.003  24.504  86.336  1.00 31.46           C  
ATOM    302  OG  SER A  41      31.217  23.571  87.374  1.00 32.44           O  
ATOM    303  N   ARG A  42      28.095  23.054  86.864  1.00 31.43           N  
ATOM    304  CA  ARG A  42      27.179  21.938  86.639  1.00 31.56           C  
ATOM    305  C   ARG A  42      25.740  22.375  86.365  1.00 31.88           C  
ATOM    306  O   ARG A  42      24.801  21.615  86.602  1.00 31.55           O  
ATOM    307  CB  ARG A  42      27.215  21.012  87.847  1.00 31.02           C  
ATOM    308  CG  ARG A  42      28.583  20.389  88.077  1.00 30.77           C  
ATOM    309  CD  ARG A  42      28.724  19.776  89.435  1.00 29.64           C  
ATOM    310  NE  ARG A  42      27.671  18.801  89.661  1.00 29.15           N  
ATOM    311  CZ  ARG A  42      27.372  18.255  90.833  1.00 29.25           C  
ATOM    312  NH1 ARG A  42      28.051  18.574  91.927  1.00 29.75           N  
ATOM    313  NH2 ARG A  42      26.370  17.385  90.912  1.00 29.83           N  
ATOM    314  N   ARG A  43      25.571  23.585  85.837  1.00 32.40           N  
ATOM    315  CA  ARG A  43      24.249  24.107  85.520  1.00 32.94           C  
ATOM    316  C   ARG A  43      23.614  23.266  84.415  1.00 31.86           C  
ATOM    317  O   ARG A  43      22.399  23.109  84.368  1.00 31.68           O  
ATOM    318  CB  ARG A  43      24.348  25.573  85.086  1.00 33.24           C  
ATOM    319  CG  ARG A  43      23.028  26.316  85.089  1.00 34.71           C  
ATOM    320  CD  ARG A  43      23.185  27.827  84.918  1.00 35.85           C  
ATOM    321  NE  ARG A  43      21.984  28.570  85.309  1.00 38.37           N  
ATOM    322  CZ  ARG A  43      21.889  29.900  85.317  1.00 39.69           C  
ATOM    323  NH1 ARG A  43      22.920  30.665  84.952  1.00 41.87           N  
ATOM    324  NH2 ARG A  43      20.753  30.477  85.687  1.00 39.44           N  
ATOM    325  N   ASN A  44      24.457  22.713  83.545  1.00 31.03           N  
ATOM    326  CA  ASN A  44      24.020  21.826  82.462  1.00 30.52           C  
ATOM    327  C   ASN A  44      23.236  20.583  82.915  1.00 29.53           C  
ATOM    328  O   ASN A  44      22.556  19.954  82.103  1.00 28.91           O  
ATOM    329  CB  ASN A  44      25.233  21.383  81.615  1.00 30.93           C  
ATOM    330  CG  ASN A  44      26.206  20.488  82.389  1.00 31.70           C  
ATOM    331  OD1 ASN A  44      26.961  20.962  83.237  1.00 33.93           O  
ATOM    332  ND2 ASN A  44      26.195  19.191  82.085  1.00 31.73           N  
ATOM    333  N   GLU A  45      23.351  20.238  84.199  1.00 28.38           N  
ATOM    334  CA  GLU A  45      22.671  19.079  84.779  1.00 27.87           C  
ATOM    335  C   GLU A  45      21.166  19.252  84.930  1.00 27.81           C  
ATOM    336  O   GLU A  45      20.430  18.262  84.951  1.00 27.98           O  
ATOM    337  CB  GLU A  45      23.266  18.731  86.149  1.00 27.69           C  
ATOM    338  CG  GLU A  45      24.572  17.968  86.039  1.00 27.70           C  
ATOM    339  CD  GLU A  45      25.288  17.781  87.363  1.00 27.45           C  
ATOM    340  OE1 GLU A  45      24.666  17.954  88.441  1.00 25.73           O  
ATOM    341  OE2 GLU A  45      26.487  17.452  87.307  1.00 25.83           O  
ATOM    342  N   LEU A  46      20.710  20.497  85.043  1.00 27.48           N  
ATOM    343  CA  LEU A  46      19.284  20.766  85.188  1.00 27.10           C  
ATOM    344  C   LEU A  46      18.608  20.734  83.822  1.00 26.83           C  
ATOM    345  O   LEU A  46      19.245  20.987  82.786  1.00 26.09           O  
ATOM    346  CB  LEU A  46      19.037  22.111  85.877  1.00 27.57           C  
ATOM    347  CG  LEU A  46      19.293  22.181  87.393  1.00 27.23           C  
ATOM    348  CD1 LEU A  46      20.782  22.096  87.722  1.00 27.86           C  
ATOM    349  CD2 LEU A  46      18.698  23.446  87.987  1.00 27.60           C  
ATOM    350  N   PRO A  47      17.311  20.437  83.818  1.00 26.58           N  
ATOM    351  CA  PRO A  47      16.525  20.500  82.584  1.00 26.60           C  
ATOM    352  C   PRO A  47      16.289  21.950  82.179  1.00 26.25           C  
ATOM    353  O   PRO A  47      16.710  22.874  82.875  1.00 26.17           O  
ATOM    354  CB  PRO A  47      15.208  19.814  82.976  1.00 26.91           C  
ATOM    355  CG  PRO A  47      15.087  20.050  84.445  1.00 26.62           C  
ATOM    356  CD  PRO A  47      16.490  20.021  84.967  1.00 26.56           C  
ATOM    357  N   ASP A  48      15.646  22.144  81.039  1.00 25.96           N  
ATOM    358  CA  ASP A  48      15.197  23.458  80.630  1.00 25.61           C  
ATOM    359  C   ASP A  48      14.228  23.951  81.715  1.00 24.59           C  
ATOM    360  O   ASP A  48      13.303  23.243  82.099  1.00 24.97           O  
ATOM    361  CB  ASP A  48      14.520  23.368  79.245  1.00 25.99           C  
ATOM    362  CG  ASP A  48      13.932  24.691  78.774  1.00 26.64           C  
ATOM    363  OD1 ASP A  48      14.448  25.766  79.140  1.00 27.42           O  
ATOM    364  OD2 ASP A  48      12.953  24.741  77.999  1.00 29.48           O  
ATOM    365  N   THR A  49      14.492  25.134  82.250  1.00 23.13           N  
ATOM    366  CA  THR A  49      13.637  25.712  83.271  1.00 22.08           C  
ATOM    367  C   THR A  49      12.918  26.954  82.786  1.00 20.67           C  
ATOM    368  O   THR A  49      12.327  27.646  83.596  1.00 19.76           O  
ATOM    369  CB  THR A  49      14.470  26.076  84.529  1.00 22.25           C  
ATOM    370  OG1 THR A  49      15.568  26.914  84.158  1.00 22.95           O  
ATOM    371  CG2 THR A  49      15.139  24.858  85.107  1.00 22.59           C  
ATOM    372  N   LEU A  50      12.958  27.258  81.487  1.00 19.70           N  
ATOM    373  CA  LEU A  50      12.334  28.491  81.011  1.00 19.48           C  
ATOM    374  C   LEU A  50      10.837  28.508  81.345  1.00 18.13           C  
ATOM    375  O   LEU A  50      10.096  27.619  80.933  1.00 17.36           O  
ATOM    376  CB  LEU A  50      12.521  28.706  79.509  1.00 19.69           C  
ATOM    377  CG  LEU A  50      12.000  30.076  79.029  1.00 20.36           C  
ATOM    378  CD1 LEU A  50      12.784  31.217  79.640  1.00 22.16           C  
ATOM    379  CD2 LEU A  50      12.020  30.198  77.503  1.00 21.11           C  
ATOM    380  N   GLY A  51      10.418  29.549  82.058  1.00 17.18           N  
ATOM    381  CA  GLY A  51       9.034  29.733  82.452  1.00 16.90           C  
ATOM    382  C   GLY A  51       8.613  29.012  83.717  1.00 16.66           C  
ATOM    383  O   GLY A  51       7.453  29.089  84.111  1.00 16.53           O  
ATOM    384  N   LEU A  52       9.536  28.291  84.347  1.00 16.24           N  
ATOM    385  CA  LEU A  52       9.230  27.623  85.602  1.00 16.24           C  
ATOM    386  C   LEU A  52       9.362  28.626  86.742  1.00 16.26           C  
ATOM    387  O   LEU A  52      10.196  29.539  86.699  1.00 16.20           O  
ATOM    388  CB  LEU A  52      10.150  26.429  85.854  1.00 16.89           C  
ATOM    389  CG  LEU A  52      10.125  25.232  84.899  1.00 16.43           C  
ATOM    390  CD1 LEU A  52      11.019  24.154  85.450  1.00 17.39           C  
ATOM    391  CD2 LEU A  52       8.747  24.677  84.704  1.00 17.93           C  
ATOM    392  N   ARG A  53       8.514  28.454  87.753  1.00 16.17           N  
ATOM    393  CA  ARG A  53       8.566  29.244  88.979  1.00 16.38           C  
ATOM    394  C   ARG A  53       9.879  29.015  89.732  1.00 16.08           C  
ATOM    395  O   ARG A  53      10.434  27.906  89.747  1.00 15.21           O  
ATOM    396  CB  ARG A  53       7.385  28.857  89.854  1.00 16.57           C  
ATOM    397  CG  ARG A  53       7.171  29.679  91.099  1.00 17.20           C  
ATOM    398  CD  ARG A  53       5.845  29.390  91.766  1.00 17.79           C  
ATOM    399  NE  ARG A  53       5.738  28.002  92.184  1.00 19.18           N  
ATOM    400  CZ  ARG A  53       4.677  27.488  92.793  1.00 18.43           C  
ATOM    401  NH1 ARG A  53       3.609  28.233  93.007  1.00 20.95           N  
ATOM    402  NH2 ARG A  53       4.687  26.216  93.154  1.00 17.97           N  
ATOM    403  N   ILE A  54      10.371  30.082  90.354  1.00 15.84           N  
ATOM    404  CA  ILE A  54      11.684  30.067  91.000  1.00 16.75           C  
ATOM    405  C   ILE A  54      11.868  28.947  92.025  1.00 16.76           C  
ATOM    406  O   ILE A  54      12.965  28.409  92.156  1.00 16.21           O  
ATOM    407  CB  ILE A  54      12.001  31.461  91.636  1.00 16.74           C  
ATOM    408  CG1 ILE A  54      13.415  31.486  92.235  1.00 17.94           C  
ATOM    409  CG2 ILE A  54      10.971  31.824  92.699  1.00 18.12           C  
ATOM    410  CD1 ILE A  54      14.525  31.266  91.227  1.00 18.14           C  
ATOM    411  N   ASP A  55      10.801  28.594  92.763  0.50 17.02           N  
ATOM    413  CA  ASP A  55      10.953  27.543  93.827  0.49 17.44           C  
ATOM    415  C   ASP A  55      11.239  26.154  93.176  0.50 17.56           C  
ATOM    417  O   ASP A  55      11.917  25.327  93.768  0.50 17.36           O  
ATOM    419  CB  ASP A  55       9.819  27.445  94.953  0.52 18.09           C  
ATOM    421  CG  ASP A  55       8.933  28.710  95.076  0.44 18.82           C  
ATOM    423  OD1 ASP A  55       8.224  28.788  96.107  0.50 21.40           O  
ATOM    425  OD2 ASP A  55       8.850  29.667  94.265  0.51 18.38           O  
HETATM  427  N   MSE A  56      10.736  25.930  91.961  1.00 17.73           N  
HETATM  428  CA  MSE A  56      11.021  24.693  91.233  1.00 18.43           C  
HETATM  429  C   MSE A  56      12.485  24.652  90.850  1.00 18.35           C  
HETATM  430  O   MSE A  56      13.103  23.607  90.914  1.00 18.35           O  
HETATM  431  CB  MSE A  56      10.179  24.594  89.945  1.00 19.24           C  
HETATM  432  CG  MSE A  56       8.689  24.500  90.167  1.00 22.70           C  
HETATM  433 SE   MSE A  56       8.201  23.086  91.411  0.41 29.86          SE  
HETATM  434  CE  MSE A  56       7.653  24.135  92.809  1.00 29.66           C  
ATOM    435  N   VAL A  57      13.020  25.795  90.438  1.00 17.99           N  
ATOM    436  CA  VAL A  57      14.426  25.916  90.050  1.00 18.52           C  
ATOM    437  C   VAL A  57      15.340  25.712  91.259  1.00 17.95           C  
ATOM    438  O   VAL A  57      16.328  24.991  91.186  1.00 18.46           O  
ATOM    439  CB  VAL A  57      14.701  27.290  89.370  1.00 18.25           C  
ATOM    440  CG1 VAL A  57      16.174  27.439  89.016  1.00 18.96           C  
ATOM    441  CG2 VAL A  57      13.843  27.459  88.114  1.00 18.78           C  
ATOM    442  N   VAL A  58      14.987  26.310  92.398  1.00 17.87           N  
ATOM    443  CA  VAL A  58      15.782  26.147  93.614  1.00 17.33           C  
ATOM    444  C   VAL A  58      15.785  24.672  94.033  1.00 17.55           C  
ATOM    445  O   VAL A  58      16.820  24.128  94.407  1.00 16.97           O  
ATOM    446  CB  VAL A  58      15.269  27.103  94.738  1.00 17.46           C  
ATOM    447  CG1 VAL A  58      15.919  26.812  96.078  1.00 17.47           C  
ATOM    448  CG2 VAL A  58      15.534  28.557  94.337  1.00 17.02           C  
ATOM    449  N   ASP A  59      14.631  24.021  93.925  1.00 18.38           N  
ATOM    450  CA  ASP A  59      14.484  22.601  94.255  1.00 19.24           C  
ATOM    451  C   ASP A  59      15.363  21.778  93.325  1.00 19.52           C  
ATOM    452  O   ASP A  59      15.977  20.816  93.760  1.00 20.21           O  
ATOM    453  CB  ASP A  59      13.031  22.136  94.090  1.00 19.32           C  
ATOM    454  CG  ASP A  59      12.107  22.544  95.261  1.00 20.52           C  
ATOM    455  OD1 ASP A  59      12.579  23.059  96.297  1.00 21.05           O  
ATOM    456  OD2 ASP A  59      10.872  22.357  95.216  1.00 23.17           O  
ATOM    457  N   LEU A  60      15.413  22.154  92.049  1.00 20.79           N  
ATOM    458  CA  LEU A  60      16.227  21.428  91.065  1.00 21.82           C  
ATOM    459  C   LEU A  60      17.713  21.488  91.444  1.00 22.77           C  
ATOM    460  O   LEU A  60      18.396  20.467  91.446  1.00 23.12           O  
ATOM    461  CB  LEU A  60      16.002  21.956  89.642  1.00 22.41           C  
ATOM    462  CG  LEU A  60      14.712  21.594  88.895  1.00 23.26           C  
ATOM    463  CD1 LEU A  60      14.558  22.427  87.618  1.00 24.87           C  
ATOM    464  CD2 LEU A  60      14.682  20.113  88.550  1.00 24.11           C  
ATOM    465  N   TRP A  61      18.211  22.679  91.778  1.00 23.30           N  
ATOM    466  CA  TRP A  61      19.583  22.825  92.269  1.00 23.70           C  
ATOM    467  C   TRP A  61      19.837  22.045  93.541  1.00 24.26           C  
ATOM    468  O   TRP A  61      20.876  21.430  93.678  1.00 24.86           O  
ATOM    469  CB  TRP A  61      19.935  24.280  92.561  1.00 23.62           C  
ATOM    470  CG  TRP A  61      20.269  25.093  91.388  1.00 23.19           C  
ATOM    471  CD1 TRP A  61      19.501  26.066  90.837  1.00 23.35           C  
ATOM    472  CD2 TRP A  61      21.483  25.049  90.614  1.00 23.64           C  
ATOM    473  NE1 TRP A  61      20.150  26.625  89.764  1.00 24.15           N  
ATOM    474  CE2 TRP A  61      21.368  26.019  89.602  1.00 23.03           C  
ATOM    475  CE3 TRP A  61      22.647  24.273  90.665  1.00 24.11           C  
ATOM    476  CZ2 TRP A  61      22.378  26.249  88.650  1.00 23.35           C  
ATOM    477  CZ3 TRP A  61      23.648  24.498  89.724  1.00 23.66           C  
ATOM    478  CH2 TRP A  61      23.501  25.479  88.727  1.00 23.41           C  
ATOM    479  N   TYR A  62      18.891  22.099  94.470  1.00 24.93           N  
ATOM    480  CA  TYR A  62      19.018  21.473  95.784  1.00 25.70           C  
ATOM    481  C   TYR A  62      19.049  19.940  95.700  1.00 26.26           C  
ATOM    482  O   TYR A  62      19.641  19.276  96.551  1.00 26.07           O  
ATOM    483  CB  TYR A  62      17.848  21.907  96.665  1.00 26.42           C  
ATOM    484  CG  TYR A  62      17.956  21.470  98.097  1.00 27.10           C  
ATOM    485  CD1 TYR A  62      18.650  22.235  99.027  1.00 27.98           C  
ATOM    486  CD2 TYR A  62      17.366  20.282  98.527  1.00 28.16           C  
ATOM    487  CE1 TYR A  62      18.751  21.837 100.348  1.00 28.16           C  
ATOM    488  CE2 TYR A  62      17.455  19.877  99.850  1.00 28.90           C  
ATOM    489  CZ  TYR A  62      18.146  20.656 100.754  1.00 28.61           C  
ATOM    490  OH  TYR A  62      18.244  20.275 102.070  1.00 29.42           O  
ATOM    491  N   ALA A  63      18.401  19.402  94.670  1.00 26.86           N  
ATOM    492  CA  ALA A  63      18.361  17.967  94.415  1.00 27.33           C  
ATOM    493  C   ALA A  63      19.715  17.475  93.913  1.00 27.91           C  
ATOM    494  O   ALA A  63      20.114  16.345  94.214  1.00 28.34           O  
ATOM    495  CB  ALA A  63      17.295  17.659  93.400  1.00 27.24           C  
ATOM    496  N   ARG A  64      20.394  18.320  93.135  1.00 28.37           N  
ATOM    497  CA  ARG A  64      21.736  18.033  92.614  1.00 28.85           C  
ATOM    498  C   ARG A  64      22.804  18.275  93.663  1.00 28.75           C  
ATOM    499  O   ARG A  64      23.660  17.424  93.906  1.00 29.04           O  
ATOM    500  CB  ARG A  64      22.061  18.920  91.407  1.00 29.28           C  
ATOM    501  CG  ARG A  64      21.585  18.390  90.079  1.00 32.09           C  
ATOM    502  CD  ARG A  64      20.114  18.348  89.992  1.00 35.73           C  
ATOM    503  NE  ARG A  64      19.597  18.151  88.644  1.00 37.83           N  
ATOM    504  CZ  ARG A  64      18.304  18.029  88.373  1.00 37.83           C  
ATOM    505  NH1 ARG A  64      17.411  18.087  89.358  1.00 38.40           N  
ATOM    506  NH2 ARG A  64      17.894  17.842  87.129  1.00 37.49           N  
ATOM    507  N   GLN A  65      22.763  19.457  94.269  1.00 28.36           N  
ATOM    508  CA  GLN A  65      23.798  19.891  95.197  1.00 28.32           C  
ATOM    509  C   GLN A  65      23.201  20.533  96.446  1.00 28.59           C  
ATOM    510  O   GLN A  65      23.215  21.764  96.562  1.00 29.11           O  
ATOM    511  CB  GLN A  65      24.722  20.894  94.520  1.00 28.29           C  
ATOM    512  CG  GLN A  65      25.106  20.570  93.082  1.00 27.72           C  
ATOM    513  CD  GLN A  65      26.102  21.557  92.537  1.00 27.30           C  
ATOM    514  OE1 GLN A  65      26.057  21.924  91.362  1.00 28.30           O  
ATOM    515  NE2 GLN A  65      26.994  22.011  93.395  1.00 24.57           N  
ATOM    516  N   PRO A  66      22.693  19.719  97.376  1.00 28.41           N  
ATOM    517  CA  PRO A  66      22.062  20.236  98.597  1.00 28.23           C  
ATOM    518  C   PRO A  66      23.003  21.006  99.503  1.00 27.82           C  
ATOM    519  O   PRO A  66      24.022  20.461  99.939  1.00 28.55           O  
ATOM    520  CB  PRO A  66      21.594  18.968  99.323  1.00 28.45           C  
ATOM    521  CG  PRO A  66      22.412  17.886  98.770  1.00 28.07           C  
ATOM    522  CD  PRO A  66      22.647  18.246  97.332  1.00 28.55           C  
ATOM    523  N   TRP A  67      22.618  22.235  99.838  1.00 26.65           N  
ATOM    524  CA  TRP A  67      23.417  23.110 100.685  1.00 25.66           C  
ATOM    525  C   TRP A  67      22.835  23.175 102.091  1.00 25.63           C  
ATOM    526  O   TRP A  67      21.705  22.748 102.326  1.00 25.50           O  
ATOM    527  CB  TRP A  67      23.445  24.523 100.097  1.00 25.27           C  
ATOM    528  CG  TRP A  67      22.079  25.093  99.969  1.00 24.27           C  
ATOM    529  CD1 TRP A  67      21.352  25.742 100.935  1.00 24.46           C  
ATOM    530  CD2 TRP A  67      21.255  25.048  98.815  1.00 24.09           C  
ATOM    531  NE1 TRP A  67      20.127  26.109 100.435  1.00 23.46           N  
ATOM    532  CE2 TRP A  67      20.037  25.690  99.137  1.00 22.19           C  
ATOM    533  CE3 TRP A  67      21.410  24.523  97.533  1.00 23.13           C  
ATOM    534  CZ2 TRP A  67      19.000  25.821  98.223  1.00 23.55           C  
ATOM    535  CZ3 TRP A  67      20.379  24.657  96.627  1.00 24.20           C  
ATOM    536  CH2 TRP A  67      19.189  25.300  96.978  1.00 23.84           C  
ATOM    537  N   ASN A  68      23.601  23.837 102.928  0.50 25.62           N  
ATOM    539  CA  ASN A  68      23.261  24.010 104.302  0.50 25.78           C  
ATOM    541  C   ASN A  68      23.026  25.484 104.635  0.50 25.36           C  
ATOM    543  O   ASN A  68      23.388  26.384 103.840  0.51 26.19           O  
ATOM    545  CB  ASN A  68      24.343  23.421 105.212  0.50 26.17           C  
ATOM    547  CG  ASN A  68      25.544  22.788 104.487  0.49 26.92           C  
ATOM    549  OD1 ASN A  68      25.938  21.682 104.851  0.48 27.84           O  
ATOM    551  ND2 ASN A  68      26.181  23.502 103.552  0.52 28.26           N  
ATOM    553  N   GLY A  69      22.426  25.743 105.800  1.00 24.88           N  
ATOM    554  CA  GLY A  69      22.178  27.128 106.172  1.00 24.11           C  
ATOM    555  C   GLY A  69      20.773  27.534 105.762  1.00 23.10           C  
ATOM    556  O   GLY A  69      19.808  26.981 106.288  1.00 21.45           O  
ATOM    557  N   PRO A  70      20.648  28.473 104.818  1.00 22.21           N  
ATOM    558  CA  PRO A  70      19.330  28.900 104.340  1.00 21.56           C  
ATOM    559  C   PRO A  70      18.522  27.744 103.778  1.00 20.70           C  
ATOM    560  O   PRO A  70      19.078  26.916 103.072  1.00 20.74           O  
ATOM    561  CB  PRO A  70      19.665  29.882 103.220  1.00 21.74           C  
ATOM    562  CG  PRO A  70      21.049  30.333 103.501  1.00 22.45           C  
ATOM    563  CD  PRO A  70      21.735  29.184 104.120  1.00 22.53           C  
ATOM    564  N   SER A  71      17.234  27.693 104.100  1.00 19.94           N  
ATOM    565  CA  SER A  71      16.339  26.696 103.544  1.00 19.15           C  
ATOM    566  C   SER A  71      16.093  27.034 102.082  1.00 18.87           C  
ATOM    567  O   SER A  71      16.430  28.118 101.627  1.00 17.80           O  
ATOM    568  CB  SER A  71      15.010  26.714 104.296  1.00 19.14           C  
ATOM    569  OG  SER A  71      14.295  27.897 103.997  1.00 17.42           O  
ATOM    570  N   ARG A  72      15.496  26.116 101.344  1.00 19.01           N  
ATOM    571  CA  ARG A  72      15.118  26.411  99.977  1.00 19.41           C  
ATOM    572  C   ARG A  72      14.196  27.628  99.907  1.00 18.91           C  
ATOM    573  O   ARG A  72      14.368  28.470  99.039  1.00 18.36           O  
ATOM    574  CB  ARG A  72      14.433  25.211  99.323  1.00 19.65           C  
ATOM    575  CG  ARG A  72      15.301  23.974  99.240  1.00 21.43           C  
ATOM    576  CD  ARG A  72      14.634  22.860  98.484  1.00 24.89           C  
ATOM    577  NE  ARG A  72      14.661  21.624  99.228  1.00 28.31           N  
ATOM    578  CZ  ARG A  72      13.887  21.357 100.266  1.00 30.31           C  
ATOM    579  NH1 ARG A  72      12.976  22.232 100.683  1.00 32.86           N  
ATOM    580  NH2 ARG A  72      14.017  20.187 100.888  1.00 30.26           N  
ATOM    581  N   GLN A  73      13.230  27.735 100.818  1.00 19.30           N  
ATOM    582  CA  GLN A  73      12.308  28.885 100.782  1.00 19.08           C  
ATOM    583  C   GLN A  73      13.031  30.202 101.094  1.00 18.19           C  
ATOM    584  O   GLN A  73      12.765  31.213 100.469  1.00 17.87           O  
ATOM    585  CB  GLN A  73      11.101  28.679 101.707  1.00 19.88           C  
ATOM    586  CG  GLN A  73       9.996  29.751 101.582  1.00 21.05           C  
ATOM    587  CD  GLN A  73       9.595  30.124 100.139  1.00 25.25           C  
ATOM    588  OE1 GLN A  73       9.449  29.253  99.251  1.00 27.66           O  
ATOM    589  NE2 GLN A  73       9.409  31.424  99.908  1.00 25.14           N  
ATOM    590  N   GLU A  74      13.979  30.178 102.019  1.00 17.41           N  
ATOM    591  CA  GLU A  74      14.791  31.357 102.311  1.00 17.00           C  
ATOM    592  C   GLU A  74      15.640  31.747 101.103  1.00 15.97           C  
ATOM    593  O   GLU A  74      15.831  32.935 100.829  1.00 15.91           O  
ATOM    594  CB  GLU A  74      15.686  31.100 103.520  1.00 17.36           C  
ATOM    595  CG  GLU A  74      14.907  31.250 104.833  1.00 18.38           C  
ATOM    596  CD  GLU A  74      15.578  30.601 106.032  1.00 21.47           C  
ATOM    597  OE1 GLU A  74      16.455  29.735 105.868  1.00 22.61           O  
ATOM    598  OE2 GLU A  74      15.211  30.958 107.165  1.00 22.97           O  
ATOM    599  N   VAL A  75      16.128  30.743 100.394  1.00 14.98           N  
ATOM    600  CA  VAL A  75      16.885  30.976  99.158  1.00 14.44           C  
ATOM    601  C   VAL A  75      15.992  31.561  98.061  1.00 14.37           C  
ATOM    602  O   VAL A  75      16.393  32.494  97.356  1.00 14.42           O  
ATOM    603  CB  VAL A  75      17.611  29.686  98.698  1.00 14.97           C  
ATOM    604  CG1 VAL A  75      18.130  29.823  97.264  1.00 13.48           C  
ATOM    605  CG2 VAL A  75      18.763  29.377  99.648  1.00 14.31           C  
ATOM    606  N   VAL A  76      14.771  31.051  97.945  1.00 13.98           N  
ATOM    607  CA  VAL A  76      13.797  31.582  96.993  1.00 14.37           C  
ATOM    608  C   VAL A  76      13.575  33.071  97.238  1.00 14.76           C  
ATOM    609  O   VAL A  76      13.564  33.879  96.307  1.00 14.57           O  
ATOM    610  CB  VAL A  76      12.457  30.843  97.100  1.00 13.40           C  
ATOM    611  CG1 VAL A  76      11.355  31.574  96.363  1.00 13.11           C  
ATOM    612  CG2 VAL A  76      12.579  29.423  96.553  1.00 15.48           C  
ATOM    613  N   GLU A  77      13.375  33.435  98.496  1.00 15.46           N  
ATOM    614  CA  GLU A  77      13.102  34.824  98.813  1.00 16.16           C  
ATOM    615  C   GLU A  77      14.287  35.718  98.523  1.00 16.19           C  
ATOM    616  O   GLU A  77      14.105  36.854  98.110  1.00 16.46           O  
ATOM    617  CB  GLU A  77      12.659  34.960 100.265  1.00 16.84           C  
ATOM    618  CG  GLU A  77      11.326  34.289 100.534  1.00 19.23           C  
ATOM    619  CD  GLU A  77      10.215  34.718  99.582  1.00 25.14           C  
ATOM    620  OE1 GLU A  77      10.009  35.951  99.390  1.00 27.89           O  
ATOM    621  OE2 GLU A  77       9.527  33.814  99.029  1.00 27.10           O  
ATOM    622  N   ARG A  78      15.498  35.204  98.731  1.00 16.64           N  
ATOM    623  CA  ARG A  78      16.708  35.958  98.438  1.00 16.81           C  
ATOM    624  C   ARG A  78      16.862  36.214  96.930  1.00 16.27           C  
ATOM    625  O   ARG A  78      17.233  37.322  96.503  1.00 15.83           O  
ATOM    626  CB  ARG A  78      17.924  35.227  99.011  1.00 17.39           C  
ATOM    627  CG  ARG A  78      19.091  36.127  99.222  1.00 19.43           C  
ATOM    628  CD  ARG A  78      20.222  35.503 100.000  1.00 22.43           C  
ATOM    629  NE  ARG A  78      21.489  36.057  99.545  1.00 22.99           N  
ATOM    630  CZ  ARG A  78      22.613  35.359  99.401  1.00 22.97           C  
ATOM    631  NH1 ARG A  78      22.667  34.073  99.721  1.00 23.42           N  
ATOM    632  NH2 ARG A  78      23.696  35.971  98.948  1.00 23.74           N  
ATOM    633  N   VAL A  79      16.551  35.204  96.126  1.00 15.66           N  
ATOM    634  CA  VAL A  79      16.661  35.329  94.676  1.00 15.44           C  
ATOM    635  C   VAL A  79      15.627  36.349  94.176  1.00 15.57           C  
ATOM    636  O   VAL A  79      15.961  37.241  93.391  1.00 15.87           O  
ATOM    637  CB  VAL A  79      16.501  33.977  93.953  1.00 15.10           C  
ATOM    638  CG1 VAL A  79      16.454  34.181  92.441  1.00 14.31           C  
ATOM    639  CG2 VAL A  79      17.654  33.046  94.293  1.00 15.74           C  
ATOM    640  N   ILE A  80      14.394  36.232  94.668  1.00 15.50           N  
ATOM    641  CA  ILE A  80      13.316  37.143  94.277  1.00 16.37           C  
ATOM    642  C   ILE A  80      13.707  38.602  94.556  1.00 16.24           C  
ATOM    643  O   ILE A  80      13.515  39.490  93.723  1.00 16.48           O  
ATOM    644  CB  ILE A  80      11.996  36.781  95.003  1.00 16.17           C  
ATOM    645  CG1 ILE A  80      11.424  35.451  94.486  1.00 16.59           C  
ATOM    646  CG2 ILE A  80      10.945  37.892  94.828  1.00 17.32           C  
ATOM    647  CD1 ILE A  80      10.242  34.921  95.319  1.00 16.47           C  
ATOM    648  N   ALA A  81      14.254  38.846  95.736  1.00 16.88           N  
ATOM    649  CA  ALA A  81      14.579  40.205  96.154  1.00 17.31           C  
ATOM    650  C   ALA A  81      15.647  40.794  95.251  1.00 17.96           C  
ATOM    651  O   ALA A  81      15.552  41.951  94.830  1.00 18.08           O  
ATOM    652  CB  ALA A  81      15.032  40.207  97.594  1.00 17.50           C  
ATOM    653  N   ARG A  82      16.654  39.986  94.945  1.00 18.67           N  
ATOM    654  CA  ARG A  82      17.750  40.379  94.062  1.00 19.41           C  
ATOM    655  C   ARG A  82      17.243  40.663  92.647  1.00 19.31           C  
ATOM    656  O   ARG A  82      17.571  41.674  92.046  1.00 17.86           O  
ATOM    657  CB  ARG A  82      18.815  39.280  94.060  1.00 20.12           C  
ATOM    658  CG  ARG A  82      19.959  39.465  93.086  1.00 23.19           C  
ATOM    659  CD  ARG A  82      20.654  40.800  93.172  1.00 28.62           C  
ATOM    660  NE  ARG A  82      21.843  40.835  92.320  1.00 30.73           N  
ATOM    661  CZ  ARG A  82      22.468  41.943  91.942  1.00 32.22           C  
ATOM    662  NH1 ARG A  82      22.013  43.132  92.323  1.00 34.37           N  
ATOM    663  NH2 ARG A  82      23.544  41.864  91.159  1.00 31.91           N  
ATOM    664  N   ALA A  83      16.406  39.773  92.130  1.00 19.59           N  
ATOM    665  CA  ALA A  83      15.813  39.943  90.811  1.00 20.13           C  
ATOM    666  C   ALA A  83      15.011  41.257  90.707  1.00 20.34           C  
ATOM    667  O   ALA A  83      15.154  42.010  89.737  1.00 20.59           O  
ATOM    668  CB  ALA A  83      14.916  38.749  90.504  1.00 20.19           C  
ATOM    669  N   ILE A  84      14.191  41.534  91.715  1.00 21.24           N  
ATOM    670  CA  ILE A  84      13.396  42.764  91.754  1.00 21.46           C  
ATOM    671  C   ILE A  84      14.303  43.993  91.696  1.00 21.76           C  
ATOM    672  O   ILE A  84      14.063  44.900  90.900  1.00 21.42           O  
ATOM    673  CB  ILE A  84      12.468  42.781  92.998  1.00 21.39           C  
ATOM    674  CG1 ILE A  84      11.282  41.837  92.763  1.00 20.84           C  
ATOM    675  CG2 ILE A  84      11.946  44.185  93.281  1.00 22.86           C  
ATOM    676  CD1 ILE A  84      10.491  41.498  94.005  1.00 21.81           C  
ATOM    677  N   SER A  85      15.372  44.003  92.485  1.00 22.02           N  
ATOM    678  CA  SER A  85      16.293  45.151  92.493  1.00 22.90           C  
ATOM    679  C   SER A  85      16.936  45.351  91.129  1.00 22.79           C  
ATOM    680  O   SER A  85      17.136  46.478  90.672  1.00 23.01           O  
ATOM    681  CB  SER A  85      17.367  44.989  93.577  1.00 23.16           C  
ATOM    682  OG  SER A  85      16.752  44.828  94.841  1.00 25.34           O  
ATOM    683  N   LEU A  86      17.224  44.249  90.458  1.00 22.66           N  
ATOM    684  CA  LEU A  86      17.808  44.314  89.134  1.00 22.91           C  
ATOM    685  C   LEU A  86      16.829  44.883  88.115  1.00 22.95           C  
ATOM    686  O   LEU A  86      17.230  45.646  87.245  1.00 21.73           O  
ATOM    687  CB  LEU A  86      18.285  42.935  88.705  1.00 23.13           C  
ATOM    688  CG  LEU A  86      19.510  42.419  89.468  1.00 24.02           C  
ATOM    689  CD1 LEU A  86      19.901  41.041  88.950  1.00 23.21           C  
ATOM    690  CD2 LEU A  86      20.664  43.382  89.357  1.00 25.29           C  
ATOM    691  N   VAL A  87      15.551  44.525  88.226  1.00 23.29           N  
ATOM    692  CA  VAL A  87      14.542  45.057  87.312  1.00 23.78           C  
ATOM    693  C   VAL A  87      14.359  46.560  87.536  1.00 24.93           C  
ATOM    694  O   VAL A  87      14.351  47.324  86.588  1.00 24.78           O  
ATOM    695  CB  VAL A  87      13.181  44.330  87.454  1.00 23.66           C  
ATOM    696  CG1 VAL A  87      12.134  44.960  86.540  1.00 23.00           C  
ATOM    697  CG2 VAL A  87      13.322  42.856  87.110  1.00 22.58           C  
ATOM    698  N   GLU A  88      14.218  46.977  88.790  1.00 26.40           N  
ATOM    699  CA  GLU A  88      14.054  48.395  89.114  1.00 28.07           C  
ATOM    700  C   GLU A  88      15.202  49.213  88.540  1.00 29.19           C  
ATOM    701  O   GLU A  88      15.001  50.289  87.981  1.00 29.24           O  
ATOM    702  CB  GLU A  88      13.999  48.590  90.624  1.00 27.88           C  
ATOM    703  CG  GLU A  88      12.752  48.022  91.278  1.00 28.68           C  
ATOM    704  CD  GLU A  88      12.788  48.111  92.796  1.00 29.16           C  
ATOM    705  OE1 GLU A  88      13.881  47.974  93.379  1.00 28.69           O  
ATOM    706  OE2 GLU A  88      11.723  48.323  93.410  1.00 31.24           O  
ATOM    707  N   GLU A  89      16.398  48.655  88.657  1.00 30.47           N  
ATOM    708  CA  GLU A  89      17.647  49.297  88.276  1.00 32.01           C  
ATOM    709  C   GLU A  89      17.770  49.495  86.771  1.00 31.54           C  
ATOM    710  O   GLU A  89      18.152  50.573  86.325  1.00 32.37           O  
ATOM    711  CB  GLU A  89      18.803  48.427  88.787  1.00 32.21           C  
ATOM    712  CG  GLU A  89      20.212  48.893  88.465  1.00 34.29           C  
ATOM    713  CD  GLU A  89      21.262  48.058  89.193  1.00 35.25           C  
ATOM    714  OE1 GLU A  89      21.033  47.693  90.377  1.00 39.66           O  
ATOM    715  OE2 GLU A  89      22.323  47.758  88.578  1.00 41.40           O  
ATOM    716  N   THR A  90      17.429  48.460  86.000  1.00 30.90           N  
ATOM    717  CA  THR A  90      17.600  48.461  84.548  1.00 30.32           C  
ATOM    718  C   THR A  90      16.327  48.864  83.795  1.00 29.57           C  
ATOM    719  O   THR A  90      16.402  49.314  82.657  1.00 30.12           O  
ATOM    720  CB  THR A  90      18.073  47.070  84.048  1.00 30.60           C  
ATOM    721  OG1 THR A  90      17.119  46.061  84.396  1.00 31.00           O  
ATOM    722  CG2 THR A  90      19.355  46.614  84.755  1.00 31.57           C  
ATOM    723  N   ARG A  91      15.167  48.680  84.421  1.00 28.70           N  
ATOM    724  CA  ARG A  91      13.867  48.982  83.804  1.00 27.97           C  
ATOM    725  C   ARG A  91      13.738  48.435  82.369  1.00 26.49           C  
ATOM    726  O   ARG A  91      13.532  49.204  81.427  1.00 26.39           O  
ATOM    727  CB  ARG A  91      13.640  50.489  83.788  1.00 28.17           C  
ATOM    728  CG  ARG A  91      13.836  51.194  85.099  1.00 28.57           C  
ATOM    729  CD  ARG A  91      13.747  52.704  84.944  1.00 29.61           C  
ATOM    730  NE  ARG A  91      12.747  53.031  83.931  1.00 31.78           N  
ATOM    731  CZ  ARG A  91      11.432  53.014  84.135  1.00 31.96           C  
ATOM    732  NH1 ARG A  91      10.938  52.709  85.325  1.00 33.33           N  
ATOM    733  NH2 ARG A  91      10.604  53.312  83.147  1.00 32.48           N  
ATOM    734  N   PRO A  92      13.839  47.114  82.213  1.00 24.61           N  
ATOM    735  CA  PRO A  92      13.938  46.478  80.893  1.00 24.03           C  
ATOM    736  C   PRO A  92      12.584  46.188  80.216  1.00 22.78           C  
ATOM    737  O   PRO A  92      12.191  45.034  80.081  1.00 22.19           O  
ATOM    738  CB  PRO A  92      14.663  45.167  81.224  1.00 24.01           C  
ATOM    739  CG  PRO A  92      14.160  44.804  82.571  1.00 24.29           C  
ATOM    740  CD  PRO A  92      13.869  46.103  83.291  1.00 24.87           C  
ATOM    741  N   LEU A  93      11.887  47.233  79.793  1.00 21.78           N  
ATOM    742  CA  LEU A  93      10.627  47.078  79.081  1.00 20.95           C  
ATOM    743  C   LEU A  93      10.950  46.584  77.699  1.00 20.34           C  
ATOM    744  O   LEU A  93      11.826  47.131  77.031  1.00 19.84           O  
ATOM    745  CB  LEU A  93       9.857  48.397  79.011  1.00 20.61           C  
ATOM    746  CG  LEU A  93       8.357  48.274  78.698  1.00 21.29           C  
ATOM    747  CD1 LEU A  93       7.642  47.458  79.730  1.00 19.64           C  
ATOM    748  CD2 LEU A  93       7.702  49.649  78.609  1.00 22.06           C  
ATOM    749  N   LEU A  94      10.277  45.525  77.280  1.00 19.05           N  
ATOM    750  CA  LEU A  94      10.534  44.955  75.971  1.00 19.32           C  
ATOM    751  C   LEU A  94       9.876  45.786  74.863  1.00 19.26           C  
ATOM    752  O   LEU A  94       8.930  46.530  75.116  1.00 18.51           O  
ATOM    753  CB  LEU A  94      10.075  43.485  75.928  1.00 19.46           C  
ATOM    754  CG  LEU A  94      11.062  42.520  76.584  1.00 19.22           C  
ATOM    755  CD1 LEU A  94      10.446  41.158  76.741  1.00 19.84           C  
ATOM    756  CD2 LEU A  94      12.333  42.421  75.784  1.00 20.16           C  
ATOM    757  N   PRO A  95      10.373  45.659  73.631  1.00 19.80           N  
ATOM    758  CA  PRO A  95       9.808  46.414  72.510  1.00 19.92           C  
ATOM    759  C   PRO A  95       8.359  46.083  72.245  1.00 19.34           C  
ATOM    760  O   PRO A  95       7.961  44.913  72.316  1.00 19.49           O  
ATOM    761  CB  PRO A  95      10.657  45.963  71.313  1.00 19.91           C  
ATOM    762  CG  PRO A  95      11.928  45.471  71.909  1.00 20.67           C  
ATOM    763  CD  PRO A  95      11.505  44.819  73.199  1.00 20.81           C  
ATOM    764  N   GLY A  96       7.576  47.118  71.960  1.00 18.49           N  
ATOM    765  CA  GLY A  96       6.215  46.950  71.492  1.00 18.52           C  
ATOM    766  C   GLY A  96       5.200  46.818  72.613  1.00 18.19           C  
ATOM    767  O   GLY A  96       4.020  46.745  72.344  1.00 17.93           O  
ATOM    768  N   VAL A  97       5.648  46.812  73.863  1.00 18.27           N  
ATOM    769  CA  VAL A  97       4.749  46.544  74.998  1.00 18.22           C  
ATOM    770  C   VAL A  97       3.625  47.570  75.154  1.00 18.59           C  
ATOM    771  O   VAL A  97       2.438  47.237  75.194  1.00 18.69           O  
ATOM    772  CB  VAL A  97       5.573  46.423  76.301  1.00 18.44           C  
ATOM    773  CG1 VAL A  97       4.707  46.584  77.539  1.00 18.30           C  
ATOM    774  CG2 VAL A  97       6.304  45.086  76.318  1.00 18.19           C  
ATOM    775  N   ARG A  98       4.000  48.832  75.262  1.00 18.97           N  
ATOM    776  CA  ARG A  98       3.043  49.900  75.473  1.00 18.98           C  
ATOM    777  C   ARG A  98       2.030  49.967  74.343  1.00 18.46           C  
ATOM    778  O   ARG A  98       0.856  50.205  74.579  1.00 17.67           O  
ATOM    779  CB  ARG A  98       3.790  51.226  75.593  1.00 19.95           C  
ATOM    780  CG  ARG A  98       3.148  52.203  76.516  1.00 21.80           C  
ATOM    781  CD  ARG A  98       4.003  53.434  76.737  1.00 23.48           C  
ATOM    782  NE  ARG A  98       5.148  53.184  77.603  1.00 22.65           N  
ATOM    783  CZ  ARG A  98       5.078  53.098  78.923  1.00 22.73           C  
ATOM    784  NH1 ARG A  98       3.907  53.207  79.540  1.00 21.41           N  
ATOM    785  NH2 ARG A  98       6.176  52.875  79.633  1.00 25.03           N  
ATOM    786  N   GLU A  99       2.502  49.746  73.117  1.00 17.71           N  
ATOM    787  CA  GLU A  99       1.646  49.748  71.940  1.00 17.89           C  
ATOM    788  C   GLU A  99       0.742  48.515  71.911  1.00 16.83           C  
ATOM    789  O   GLU A  99      -0.397  48.613  71.508  1.00 15.14           O  
ATOM    790  CB  GLU A  99       2.498  49.808  70.666  1.00 19.02           C  
ATOM    791  CG  GLU A  99       3.426  51.020  70.613  1.00 21.51           C  
ATOM    792  CD  GLU A  99       4.882  50.759  71.027  1.00 25.59           C  
ATOM    793  OE1 GLU A  99       5.761  51.313  70.328  1.00 28.67           O  
ATOM    794  OE2 GLU A  99       5.180  50.057  72.040  1.00 24.74           O  
ATOM    795  N   ALA A 100       1.261  47.366  72.352  1.00 16.30           N  
ATOM    796  CA  ALA A 100       0.475  46.133  72.403  1.00 16.23           C  
ATOM    797  C   ALA A 100      -0.696  46.262  73.371  1.00 15.96           C  
ATOM    798  O   ALA A 100      -1.813  45.851  73.061  1.00 14.85           O  
ATOM    799  CB  ALA A 100       1.339  44.959  72.793  1.00 16.24           C  
ATOM    800  N   VAL A 101      -0.419  46.821  74.549  1.00 16.32           N  
ATOM    801  CA  VAL A 101      -1.436  47.006  75.573  1.00 16.88           C  
ATOM    802  C   VAL A 101      -2.470  48.014  75.092  1.00 17.17           C  
ATOM    803  O   VAL A 101      -3.662  47.782  75.243  1.00 17.55           O  
ATOM    804  CB  VAL A 101      -0.810  47.446  76.938  1.00 16.71           C  
ATOM    805  CG1 VAL A 101      -1.892  47.791  77.955  1.00 17.80           C  
ATOM    806  CG2 VAL A 101       0.075  46.368  77.490  1.00 15.70           C  
ATOM    807  N   ALA A 102      -2.014  49.111  74.480  1.00 17.77           N  
ATOM    808  CA  ALA A 102      -2.925  50.093  73.889  1.00 18.45           C  
ATOM    809  C   ALA A 102      -3.796  49.454  72.805  1.00 18.67           C  
ATOM    810  O   ALA A 102      -4.994  49.725  72.739  1.00 19.12           O  
ATOM    811  CB  ALA A 102      -2.158  51.294  73.338  1.00 18.46           C  
ATOM    812  N   LEU A 103      -3.202  48.605  71.968  1.00 18.77           N  
ATOM    813  CA  LEU A 103      -3.947  47.919  70.918  1.00 18.92           C  
ATOM    814  C   LEU A 103      -5.073  47.065  71.479  1.00 18.73           C  
ATOM    815  O   LEU A 103      -6.161  47.026  70.916  1.00 18.50           O  
ATOM    816  CB  LEU A 103      -3.023  47.041  70.062  1.00 18.90           C  
ATOM    817  CG  LEU A 103      -3.742  46.213  68.998  1.00 18.62           C  
ATOM    818  CD1 LEU A 103      -4.427  47.129  67.982  1.00 19.31           C  
ATOM    819  CD2 LEU A 103      -2.818  45.243  68.302  1.00 19.43           C  
ATOM    820  N   CYS A 104      -4.801  46.369  72.579  1.00 18.69           N  
ATOM    821  CA  CYS A 104      -5.807  45.542  73.243  1.00 18.39           C  
ATOM    822  C   CYS A 104      -7.024  46.386  73.624  1.00 19.54           C  
ATOM    823  O   CYS A 104      -8.157  45.988  73.379  1.00 18.81           O  
ATOM    824  CB  CYS A 104      -5.210  44.841  74.475  1.00 18.26           C  
ATOM    825  SG  CYS A 104      -4.020  43.529  74.107  1.00 15.89           S  
ATOM    826  N   LYS A 105      -6.778  47.564  74.188  1.00 20.69           N  
ATOM    827  CA  LYS A 105      -7.848  48.485  74.592  1.00 21.75           C  
ATOM    828  C   LYS A 105      -8.626  49.028  73.398  1.00 22.39           C  
ATOM    829  O   LYS A 105      -9.849  49.122  73.438  1.00 22.89           O  
ATOM    830  CB  LYS A 105      -7.262  49.652  75.387  1.00 22.16           C  
ATOM    831  CG  LYS A 105      -6.582  49.249  76.682  1.00 23.41           C  
ATOM    832  CD  LYS A 105      -7.597  48.857  77.736  1.00 25.50           C  
ATOM    833  CE  LYS A 105      -6.950  48.812  79.112  1.00 26.55           C  
ATOM    834  NZ  LYS A 105      -7.941  48.731  80.228  1.00 28.38           N  
ATOM    835  N   GLU A 106      -7.907  49.390  72.339  1.00 22.73           N  
ATOM    836  CA  GLU A 106      -8.531  49.863  71.101  1.00 23.61           C  
ATOM    837  C   GLU A 106      -9.416  48.799  70.465  1.00 22.37           C  
ATOM    838  O   GLU A 106     -10.426  49.118  69.849  1.00 22.22           O  
ATOM    839  CB  GLU A 106      -7.460  50.303  70.099  1.00 24.16           C  
ATOM    840  CG  GLU A 106      -6.887  51.669  70.415  1.00 27.88           C  
ATOM    841  CD  GLU A 106      -7.952  52.745  70.392  1.00 32.19           C  
ATOM    842  OE1 GLU A 106      -8.649  52.858  69.354  1.00 36.68           O  
ATOM    843  OE2 GLU A 106      -8.101  53.465  71.407  1.00 35.58           O  
ATOM    844  N   GLN A 107      -9.053  47.537  70.648  1.00 20.96           N  
ATOM    845  CA  GLN A 107      -9.856  46.420  70.154  1.00 19.96           C  
ATOM    846  C   GLN A 107     -10.931  45.935  71.149  1.00 18.87           C  
ATOM    847  O   GLN A 107     -11.543  44.889  70.958  1.00 18.39           O  
ATOM    848  CB  GLN A 107      -8.934  45.287  69.733  1.00 19.98           C  
ATOM    849  CG  GLN A 107      -8.063  45.671  68.550  1.00 20.82           C  
ATOM    850  CD  GLN A 107      -8.880  46.010  67.321  1.00 20.42           C  
ATOM    851  OE1 GLN A 107      -9.751  45.248  66.940  1.00 22.12           O  
ATOM    852  NE2 GLN A 107      -8.600  47.150  66.706  1.00 20.79           N  
ATOM    853  N   GLY A 108     -11.171  46.704  72.206  1.00 17.97           N  
ATOM    854  CA  GLY A 108     -12.282  46.412  73.106  1.00 17.07           C  
ATOM    855  C   GLY A 108     -12.046  45.325  74.157  1.00 16.77           C  
ATOM    856  O   GLY A 108     -13.000  44.795  74.727  1.00 16.19           O  
ATOM    857  N   LEU A 109     -10.790  45.037  74.472  1.00 15.77           N  
ATOM    858  CA  LEU A 109     -10.472  43.930  75.371  1.00 15.51           C  
ATOM    859  C   LEU A 109     -10.159  44.400  76.797  1.00 15.09           C  
ATOM    860  O   LEU A 109      -9.608  45.477  77.001  1.00 15.34           O  
ATOM    861  CB  LEU A 109      -9.286  43.141  74.835  1.00 15.96           C  
ATOM    862  CG  LEU A 109      -9.369  42.702  73.363  1.00 15.06           C  
ATOM    863  CD1 LEU A 109      -8.105  41.951  73.011  1.00 16.66           C  
ATOM    864  CD2 LEU A 109     -10.590  41.836  73.081  1.00 16.26           C  
ATOM    865  N   LEU A 110     -10.527  43.569  77.765  1.00 14.67           N  
ATOM    866  CA  LEU A 110     -10.015  43.660  79.110  1.00 14.67           C  
ATOM    867  C   LEU A 110      -8.593  43.153  79.051  1.00 14.47           C  
ATOM    868  O   LEU A 110      -8.260  42.379  78.165  1.00 14.37           O  
ATOM    869  CB  LEU A 110     -10.823  42.787  80.051  1.00 14.79           C  
ATOM    870  CG  LEU A 110     -12.296  43.199  80.215  1.00 15.78           C  
ATOM    871  CD1 LEU A 110     -12.998  42.189  81.081  1.00 16.25           C  
ATOM    872  CD2 LEU A 110     -12.390  44.613  80.793  1.00 16.57           C  
ATOM    873  N   VAL A 111      -7.764  43.600  79.986  1.00 13.90           N  
ATOM    874  CA  VAL A 111      -6.363  43.270  80.004  1.00 13.11           C  
ATOM    875  C   VAL A 111      -5.988  42.673  81.350  1.00 13.09           C  
ATOM    876  O   VAL A 111      -6.204  43.301  82.385  1.00 12.94           O  
ATOM    877  CB  VAL A 111      -5.504  44.509  79.710  1.00 13.47           C  
ATOM    878  CG1 VAL A 111      -4.026  44.214  79.937  1.00 13.57           C  
ATOM    879  CG2 VAL A 111      -5.769  45.001  78.247  1.00 13.78           C  
ATOM    880  N   GLY A 112      -5.440  41.467  81.309  1.00 13.09           N  
ATOM    881  CA  GLY A 112      -4.896  40.783  82.467  1.00 12.69           C  
ATOM    882  C   GLY A 112      -3.399  40.511  82.460  1.00 13.15           C  
ATOM    883  O   GLY A 112      -2.727  40.588  81.433  1.00 13.16           O  
ATOM    884  N   LEU A 113      -2.879  40.192  83.635  1.00 13.67           N  
ATOM    885  CA  LEU A 113      -1.510  39.729  83.821  1.00 14.30           C  
ATOM    886  C   LEU A 113      -1.550  38.418  84.602  1.00 13.86           C  
ATOM    887  O   LEU A 113      -2.292  38.296  85.593  1.00 13.36           O  
ATOM    888  CB  LEU A 113      -0.674  40.787  84.544  1.00 14.44           C  
ATOM    889  CG  LEU A 113       0.850  40.588  84.597  1.00 15.83           C  
ATOM    890  CD1 LEU A 113       1.482  40.792  83.233  1.00 17.53           C  
ATOM    891  CD2 LEU A 113       1.504  41.532  85.561  1.00 16.15           C  
ATOM    892  N   ALA A 114      -0.825  37.415  84.104  1.00 13.86           N  
ATOM    893  CA  ALA A 114      -0.721  36.112  84.750  1.00 13.24           C  
ATOM    894  C   ALA A 114       0.732  35.707  84.787  1.00 13.63           C  
ATOM    895  O   ALA A 114       1.348  35.513  83.745  1.00 13.24           O  
ATOM    896  CB  ALA A 114      -1.534  35.062  84.012  1.00 13.26           C  
ATOM    897  N   SER A 115       1.272  35.530  85.992  1.00 13.22           N  
ATOM    898  CA  SER A 115       2.706  35.317  86.158  1.00 13.62           C  
ATOM    899  C   SER A 115       3.043  34.372  87.313  1.00 14.49           C  
ATOM    900  O   SER A 115       2.311  34.291  88.285  1.00 14.33           O  
ATOM    901  CB  SER A 115       3.381  36.666  86.420  1.00 13.59           C  
ATOM    902  OG  SER A 115       4.773  36.525  86.622  1.00 12.67           O  
ATOM    903  N   ALA A 116       4.191  33.703  87.212  1.00 15.64           N  
ATOM    904  CA  ALA A 116       4.706  32.868  88.296  1.00 16.86           C  
ATOM    905  C   ALA A 116       5.325  33.725  89.378  1.00 16.99           C  
ATOM    906  O   ALA A 116       5.502  33.269  90.502  1.00 18.40           O  
ATOM    907  CB  ALA A 116       5.718  31.899  87.786  1.00 16.97           C  
ATOM    908  N   SER A 117       5.647  34.974  89.039  1.00 17.03           N  
ATOM    909  CA  SER A 117       6.283  35.889  89.966  1.00 17.14           C  
ATOM    910  C   SER A 117       5.314  36.396  91.021  1.00 16.92           C  
ATOM    911  O   SER A 117       4.105  36.417  90.803  1.00 16.75           O  
ATOM    912  CB  SER A 117       6.911  37.059  89.211  1.00 17.74           C  
ATOM    913  OG  SER A 117       7.991  36.590  88.437  1.00 17.82           O  
ATOM    914  N   PRO A 118       5.844  36.795  92.175  1.00 16.84           N  
ATOM    915  CA  PRO A 118       4.999  37.239  93.287  1.00 16.45           C  
ATOM    916  C   PRO A 118       4.145  38.451  92.926  1.00 16.91           C  
ATOM    917  O   PRO A 118       4.576  39.307  92.158  1.00 16.56           O  
ATOM    918  CB  PRO A 118       6.018  37.587  94.380  1.00 16.84           C  
ATOM    919  CG  PRO A 118       7.244  36.850  94.004  1.00 17.59           C  
ATOM    920  CD  PRO A 118       7.280  36.857  92.514  1.00 16.67           C  
ATOM    921  N   LEU A 119       2.939  38.509  93.478  1.00 16.87           N  
ATOM    922  CA  LEU A 119       2.010  39.589  93.201  1.00 17.63           C  
ATOM    923  C   LEU A 119       2.630  40.952  93.457  1.00 17.88           C  
ATOM    924  O   LEU A 119       2.418  41.870  92.680  1.00 17.36           O  
ATOM    925  CB  LEU A 119       0.748  39.411  94.047  1.00 17.77           C  
ATOM    926  CG  LEU A 119      -0.379  40.438  93.934  1.00 19.03           C  
ATOM    927  CD1 LEU A 119      -0.878  40.613  92.514  1.00 19.67           C  
ATOM    928  CD2 LEU A 119      -1.525  39.983  94.824  1.00 19.39           C  
ATOM    929  N   HIS A 120       3.391  41.092  94.546  1.00 18.79           N  
ATOM    930  CA  HIS A 120       4.038  42.365  94.854  1.00 19.62           C  
ATOM    931  C   HIS A 120       4.999  42.778  93.733  1.00 20.15           C  
ATOM    932  O   HIS A 120       5.153  43.968  93.456  1.00 19.79           O  
ATOM    933  CB  HIS A 120       4.736  42.340  96.230  1.00 20.22           C  
ATOM    934  CG  HIS A 120       5.933  41.439  96.314  1.00 20.45           C  
ATOM    935  ND1 HIS A 120       5.863  40.144  96.788  1.00 21.81           N  
ATOM    936  CD2 HIS A 120       7.237  41.668  96.042  1.00 21.22           C  
ATOM    937  CE1 HIS A 120       7.064  39.602  96.757  1.00 20.57           C  
ATOM    938  NE2 HIS A 120       7.917  40.505  96.306  1.00 21.40           N  
HETATM  939  N   MSE A 121       5.651  41.808  93.099  1.00 20.96           N  
HETATM  940  CA  MSE A 121       6.527  42.114  91.964  1.00 21.74           C  
HETATM  941  C   MSE A 121       5.717  42.508  90.717  1.00 21.12           C  
HETATM  942  O   MSE A 121       6.158  43.328  89.902  1.00 20.69           O  
HETATM  943  CB  MSE A 121       7.432  40.932  91.638  1.00 22.50           C  
HETATM  944  CG  MSE A 121       8.407  41.205  90.520  1.00 22.80           C  
HETATM  945 SE   MSE A 121       9.520  39.706  90.171  0.81 25.06          SE  
HETATM  946  CE  MSE A 121      10.372  40.328  88.535  1.00 25.95           C  
ATOM    947  N   LEU A 122       4.550  41.905  90.548  1.00 20.33           N  
ATOM    948  CA  LEU A 122       3.703  42.241  89.408  1.00 20.24           C  
ATOM    949  C   LEU A 122       3.227  43.683  89.519  1.00 20.20           C  
ATOM    950  O   LEU A 122       3.263  44.432  88.545  1.00 19.60           O  
ATOM    951  CB  LEU A 122       2.505  41.301  89.318  1.00 19.60           C  
ATOM    952  CG  LEU A 122       2.760  39.796  89.318  1.00 20.55           C  
ATOM    953  CD1 LEU A 122       1.482  39.102  88.916  1.00 18.88           C  
ATOM    954  CD2 LEU A 122       3.920  39.382  88.396  1.00 19.46           C  
ATOM    955  N   GLU A 123       2.799  44.067  90.718  1.00 20.28           N  
ATOM    956  CA  GLU A 123       2.354  45.427  91.005  1.00 21.12           C  
ATOM    957  C   GLU A 123       3.491  46.420  90.793  1.00 21.73           C  
ATOM    958  O   GLU A 123       3.275  47.540  90.330  1.00 21.24           O  
ATOM    959  CB  GLU A 123       1.871  45.543  92.452  1.00 21.58           C  
ATOM    960  CG  GLU A 123       0.559  44.824  92.749  1.00 23.33           C  
ATOM    961  CD  GLU A 123      -0.692  45.616  92.384  1.00 26.46           C  
ATOM    962  OE1 GLU A 123      -0.607  46.833  92.085  1.00 27.16           O  
ATOM    963  OE2 GLU A 123      -1.796  45.013  92.430  1.00 29.71           O  
ATOM    964  N   LYS A 124       4.706  45.996  91.138  1.00 22.42           N  
ATOM    965  CA  LYS A 124       5.870  46.869  91.071  1.00 22.91           C  
ATOM    966  C   LYS A 124       6.295  47.137  89.640  1.00 22.17           C  
ATOM    967  O   LYS A 124       6.536  48.279  89.277  1.00 22.41           O  
ATOM    968  CB  LYS A 124       7.030  46.262  91.871  1.00 23.07           C  
ATOM    969  CG  LYS A 124       8.291  47.104  91.889  1.00 25.00           C  
ATOM    970  CD  LYS A 124       9.339  46.522  92.823  1.00 25.34           C  
ATOM    971  CE  LYS A 124       9.147  46.995  94.267  1.00 28.17           C  
ATOM    972  NZ  LYS A 124      10.437  46.938  95.026  1.00 30.41           N  
ATOM    973  N   VAL A 125       6.418  46.085  88.841  1.00 21.90           N  
ATOM    974  CA  VAL A 125       6.802  46.222  87.435  1.00 21.78           C  
ATOM    975  C   VAL A 125       5.765  47.034  86.650  1.00 21.84           C  
ATOM    976  O   VAL A 125       6.127  47.870  85.821  1.00 21.36           O  
ATOM    977  CB  VAL A 125       7.055  44.844  86.769  1.00 21.79           C  
ATOM    978  CG1 VAL A 125       7.254  44.997  85.256  1.00 21.54           C  
ATOM    979  CG2 VAL A 125       8.287  44.184  87.392  1.00 22.15           C  
ATOM    980  N   LEU A 126       4.478  46.806  86.910  1.00 21.62           N  
ATOM    981  CA  LEU A 126       3.430  47.560  86.212  1.00 21.51           C  
ATOM    982  C   LEU A 126       3.453  49.030  86.604  1.00 22.09           C  
ATOM    983  O   LEU A 126       3.400  49.914  85.757  1.00 22.06           O  
ATOM    984  CB  LEU A 126       2.056  46.977  86.504  1.00 21.31           C  
ATOM    985  CG  LEU A 126       1.800  45.617  85.865  1.00 20.13           C  
ATOM    986  CD1 LEU A 126       0.354  45.260  86.137  1.00 19.40           C  
ATOM    987  CD2 LEU A 126       2.085  45.579  84.338  1.00 20.23           C  
ATOM    988  N   THR A 127       3.539  49.288  87.894  1.00 22.96           N  
ATOM    989  CA  THR A 127       3.568  50.646  88.381  1.00 23.98           C  
ATOM    990  C   THR A 127       4.779  51.451  87.879  1.00 24.47           C  
ATOM    991  O   THR A 127       4.664  52.659  87.681  1.00 24.30           O  
ATOM    992  CB  THR A 127       3.486  50.639  89.910  1.00 23.91           C  
ATOM    993  OG1 THR A 127       2.208  50.124  90.297  1.00 24.49           O  
ATOM    994  CG2 THR A 127       3.501  52.041  90.490  1.00 24.30           C  
HETATM  995  N   MSE A 128       5.924  50.850  87.685  0.50 24.95           N  
HETATM  997  CA  MSE A 128       7.062  51.676  87.306  0.51 25.66           C  
HETATM  999  C   MSE A 128       7.073  51.971  85.791  0.50 24.51           C  
HETATM 1001  O   MSE A 128       7.849  52.817  85.358  0.47 24.39           O  
HETATM 1003  CB  MSE A 128       8.343  50.942  87.607  0.49 25.74           C  
HETATM 1005  CG  MSE A 128       8.940  51.043  88.924  0.44 27.12           C  
HETATM 1007 SE   MSE A 128      10.828  50.735  88.687  0.43 29.36          SE  
HETATM 1009  CE  MSE A 128      10.880  49.448  87.141  0.41 29.64           C  
ATOM   1011  N   PHE A 129       6.278  51.272  84.979  1.00 23.35           N  
ATOM   1012  CA  PHE A 129       6.161  51.597  83.576  1.00 22.62           C  
ATOM   1013  C   PHE A 129       4.847  52.333  83.323  1.00 21.52           C  
ATOM   1014  O   PHE A 129       4.393  52.416  82.195  1.00 21.68           O  
ATOM   1015  CB  PHE A 129       6.291  50.317  82.744  1.00 22.71           C  
ATOM   1016  CG  PHE A 129       7.676  49.697  82.808  1.00 23.18           C  
ATOM   1017  CD1 PHE A 129       8.765  50.330  82.227  1.00 22.90           C  
ATOM   1018  CD2 PHE A 129       7.883  48.479  83.444  1.00 23.29           C  
ATOM   1019  CE1 PHE A 129      10.028  49.762  82.282  1.00 23.03           C  
ATOM   1020  CE2 PHE A 129       9.151  47.913  83.508  1.00 23.55           C  
ATOM   1021  CZ  PHE A 129      10.216  48.547  82.926  1.00 22.60           C  
ATOM   1022  N   ASP A 130       4.240  52.865  84.385  1.00 20.12           N  
ATOM   1023  CA  ASP A 130       2.931  53.514  84.301  1.00 19.75           C  
ATOM   1024  C   ASP A 130       1.938  52.673  83.500  1.00 18.44           C  
ATOM   1025  O   ASP A 130       1.149  53.191  82.708  1.00 17.69           O  
ATOM   1026  CB  ASP A 130       3.078  54.939  83.717  1.00 20.45           C  
ATOM   1027  CG  ASP A 130       3.866  55.857  84.627  1.00 22.03           C  
ATOM   1028  OD1 ASP A 130       3.570  55.937  85.833  1.00 24.29           O  
ATOM   1029  OD2 ASP A 130       4.822  56.542  84.231  1.00 29.31           O  
ATOM   1030  N   LEU A 131       1.958  51.363  83.749  1.00 17.41           N  
ATOM   1031  CA  LEU A 131       1.044  50.432  83.101  1.00 17.10           C  
ATOM   1032  C   LEU A 131      -0.019  49.851  84.031  1.00 16.02           C  
ATOM   1033  O   LEU A 131      -0.878  49.125  83.570  1.00 16.13           O  
ATOM   1034  CB  LEU A 131       1.827  49.290  82.432  1.00 16.78           C  
ATOM   1035  CG  LEU A 131       2.717  49.633  81.231  1.00 18.42           C  
ATOM   1036  CD1 LEU A 131       3.612  48.445  80.889  1.00 19.52           C  
ATOM   1037  CD2 LEU A 131       1.930  50.044  80.003  1.00 17.20           C  
ATOM   1038  N   ARG A 132       0.025  50.159  85.328  1.00 15.96           N  
ATOM   1039  CA  ARG A 132      -0.907  49.532  86.274  1.00 15.97           C  
ATOM   1040  C   ARG A 132      -2.384  49.841  85.985  1.00 16.02           C  
ATOM   1041  O   ARG A 132      -3.245  48.983  86.142  1.00 14.53           O  
ATOM   1042  CB  ARG A 132      -0.551  49.918  87.712  1.00 16.35           C  
ATOM   1043  CG  ARG A 132      -1.339  49.167  88.781  1.00 17.14           C  
ATOM   1044  CD  ARG A 132      -1.163  47.659  88.734  1.00 19.19           C  
ATOM   1045  NE  ARG A 132      -2.067  47.008  89.674  1.00 19.16           N  
ATOM   1046  CZ  ARG A 132      -3.288  46.576  89.373  1.00 21.59           C  
ATOM   1047  NH1 ARG A 132      -3.803  46.727  88.153  1.00 21.88           N  
ATOM   1048  NH2 ARG A 132      -4.009  45.986  90.314  1.00 21.14           N  
ATOM   1049  N   ASP A 133      -2.663  51.065  85.554  1.00 15.81           N  
ATOM   1050  CA  ASP A 133      -4.013  51.472  85.189  1.00 15.95           C  
ATOM   1051  C   ASP A 133      -4.625  50.701  84.005  1.00 16.20           C  
ATOM   1052  O   ASP A 133      -5.849  50.507  83.963  1.00 17.29           O  
ATOM   1053  CB  ASP A 133      -4.084  52.992  84.946  1.00 15.93           C  
ATOM   1054  CG  ASP A 133      -3.111  53.486  83.890  1.00 16.60           C  
ATOM   1055  OD1 ASP A 133      -2.239  52.703  83.446  1.00 17.78           O  
ATOM   1056  OD2 ASP A 133      -3.136  54.680  83.466  1.00 15.74           O  
ATOM   1057  N   SER A 134      -3.787  50.276  83.057  1.00 15.47           N  
ATOM   1058  CA  SER A 134      -4.225  49.528  81.882  1.00 15.43           C  
ATOM   1059  C   SER A 134      -4.625  48.077  82.207  1.00 15.63           C  
ATOM   1060  O   SER A 134      -5.349  47.452  81.441  1.00 16.07           O  
ATOM   1061  CB  SER A 134      -3.129  49.526  80.807  1.00 15.04           C  
ATOM   1062  OG  SER A 134      -2.808  50.840  80.369  1.00 15.53           O  
ATOM   1063  N   PHE A 135      -4.158  47.549  83.334  1.00 15.80           N  
ATOM   1064  CA  PHE A 135      -4.441  46.164  83.704  1.00 15.88           C  
ATOM   1065  C   PHE A 135      -5.665  46.056  84.621  1.00 15.99           C  
ATOM   1066  O   PHE A 135      -5.723  46.633  85.706  1.00 17.11           O  
ATOM   1067  CB  PHE A 135      -3.194  45.501  84.298  1.00 15.41           C  
ATOM   1068  CG  PHE A 135      -2.186  45.121  83.261  1.00 16.19           C  
ATOM   1069  CD1 PHE A 135      -2.110  43.822  82.797  1.00 15.47           C  
ATOM   1070  CD2 PHE A 135      -1.346  46.079  82.707  1.00 15.35           C  
ATOM   1071  CE1 PHE A 135      -1.193  43.485  81.807  1.00 15.65           C  
ATOM   1072  CE2 PHE A 135      -0.427  45.735  81.717  1.00 15.73           C  
ATOM   1073  CZ  PHE A 135      -0.363  44.441  81.278  1.00 15.50           C  
ATOM   1074  N   ASP A 136      -6.661  45.332  84.136  1.00 15.77           N  
ATOM   1075  CA  ASP A 136      -7.925  45.130  84.837  1.00 16.35           C  
ATOM   1076  C   ASP A 136      -7.833  44.050  85.913  1.00 16.19           C  
ATOM   1077  O   ASP A 136      -8.661  43.996  86.816  1.00 15.65           O  
ATOM   1078  CB  ASP A 136      -9.001  44.757  83.811  1.00 16.02           C  
ATOM   1079  CG  ASP A 136      -9.207  45.839  82.788  1.00 17.92           C  
ATOM   1080  OD1 ASP A 136      -9.511  46.982  83.202  1.00 17.79           O  
ATOM   1081  OD2 ASP A 136      -9.046  45.669  81.557  1.00 16.78           O  
ATOM   1082  N   ALA A 137      -6.865  43.151  85.777  1.00 15.85           N  
ATOM   1083  CA  ALA A 137      -6.622  42.119  86.784  1.00 16.14           C  
ATOM   1084  C   ALA A 137      -5.189  41.574  86.717  1.00 16.28           C  
ATOM   1085  O   ALA A 137      -4.598  41.475  85.641  1.00 15.79           O  
ATOM   1086  CB  ALA A 137      -7.626  40.980  86.630  1.00 16.54           C  
ATOM   1087  N   LEU A 138      -4.656  41.237  87.891  1.00 16.09           N  
ATOM   1088  CA  LEU A 138      -3.349  40.585  88.039  1.00 15.67           C  
ATOM   1089  C   LEU A 138      -3.551  39.237  88.726  1.00 16.13           C  
ATOM   1090  O   LEU A 138      -4.352  39.140  89.670  1.00 14.64           O  
ATOM   1091  CB  LEU A 138      -2.406  41.438  88.908  1.00 16.18           C  
ATOM   1092  CG  LEU A 138      -2.221  42.927  88.636  1.00 16.79           C  
ATOM   1093  CD1 LEU A 138      -0.967  43.428  89.331  1.00 18.20           C  
ATOM   1094  CD2 LEU A 138      -2.145  43.244  87.180  1.00 16.77           C  
ATOM   1095  N   ALA A 139      -2.831  38.209  88.269  1.00 15.16           N  
ATOM   1096  CA  ALA A 139      -2.831  36.905  88.941  1.00 15.45           C  
ATOM   1097  C   ALA A 139      -1.411  36.358  89.048  1.00 15.47           C  
ATOM   1098  O   ALA A 139      -0.705  36.239  88.045  1.00 14.87           O  
ATOM   1099  CB  ALA A 139      -3.751  35.905  88.234  1.00 15.05           C  
ATOM   1100  N   SER A 140      -0.993  36.058  90.279  1.00 15.31           N  
ATOM   1101  CA  SER A 140       0.298  35.440  90.550  1.00 15.35           C  
ATOM   1102  C   SER A 140       0.108  33.973  90.937  1.00 15.87           C  
ATOM   1103  O   SER A 140      -0.860  33.624  91.647  1.00 16.09           O  
ATOM   1104  CB  SER A 140       1.024  36.177  91.681  1.00 15.51           C  
ATOM   1105  OG  SER A 140       2.170  35.467  92.117  1.00 13.79           O  
ATOM   1106  N   ALA A 141       1.037  33.128  90.498  1.00 15.86           N  
ATOM   1107  CA  ALA A 141       1.050  31.720  90.876  1.00 16.61           C  
ATOM   1108  C   ALA A 141       1.867  31.461  92.152  1.00 17.62           C  
ATOM   1109  O   ALA A 141       2.046  30.320  92.538  1.00 16.47           O  
ATOM   1110  CB  ALA A 141       1.584  30.894  89.759  1.00 16.52           C  
ATOM   1111  N   GLU A 142       2.379  32.508  92.794  1.00 19.04           N  
ATOM   1112  CA  GLU A 142       3.308  32.320  93.908  1.00 21.41           C  
ATOM   1113  C   GLU A 142       2.749  31.397  95.008  1.00 21.85           C  
ATOM   1114  O   GLU A 142       3.465  30.527  95.500  1.00 22.72           O  
ATOM   1115  CB  GLU A 142       3.698  33.664  94.527  1.00 21.69           C  
ATOM   1116  CG  GLU A 142       4.844  33.553  95.537  1.00 23.55           C  
ATOM   1117  CD  GLU A 142       5.030  34.788  96.408  1.00 24.10           C  
ATOM   1118  OE1 GLU A 142       4.062  35.560  96.608  1.00 26.44           O  
ATOM   1119  OE2 GLU A 142       6.162  34.982  96.908  1.00 28.29           O  
ATOM   1120  N   LYS A 143       1.486  31.599  95.380  1.00 22.14           N  
ATOM   1121  CA  LYS A 143       0.818  30.830  96.440  1.00 23.31           C  
ATOM   1122  C   LYS A 143       0.147  29.536  95.976  1.00 21.87           C  
ATOM   1123  O   LYS A 143      -0.373  28.790  96.806  1.00 22.88           O  
ATOM   1124  CB  LYS A 143      -0.282  31.662  97.103  1.00 23.43           C  
ATOM   1125  CG  LYS A 143       0.183  32.957  97.708  1.00 26.22           C  
ATOM   1126  CD  LYS A 143      -1.013  33.838  98.072  1.00 27.27           C  
ATOM   1127  CE  LYS A 143      -0.568  35.272  98.355  1.00 31.12           C  
ATOM   1128  NZ  LYS A 143      -1.586  36.288  97.893  1.00 33.54           N  
ATOM   1129  N   LEU A 144       0.121  29.274  94.667  1.00 19.80           N  
ATOM   1130  CA  LEU A 144      -0.571  28.100  94.146  1.00 18.21           C  
ATOM   1131  C   LEU A 144       0.276  26.847  94.311  1.00 17.79           C  
ATOM   1132  O   LEU A 144       1.501  26.932  94.375  1.00 17.70           O  
ATOM   1133  CB  LEU A 144      -0.954  28.296  92.680  1.00 17.61           C  
ATOM   1134  CG  LEU A 144      -1.717  29.568  92.299  1.00 17.93           C  
ATOM   1135  CD1 LEU A 144      -2.029  29.596  90.816  1.00 18.26           C  
ATOM   1136  CD2 LEU A 144      -2.991  29.671  93.117  1.00 18.59           C  
ATOM   1137  N   PRO A 145      -0.369  25.681  94.393  1.00 17.84           N  
ATOM   1138  CA  PRO A 145       0.346  24.402  94.421  1.00 17.91           C  
ATOM   1139  C   PRO A 145       1.237  24.188  93.205  1.00 17.54           C  
ATOM   1140  O   PRO A 145       2.343  23.675  93.356  1.00 17.78           O  
ATOM   1141  CB  PRO A 145      -0.783  23.361  94.437  1.00 18.34           C  
ATOM   1142  CG  PRO A 145      -1.979  24.079  94.924  1.00 19.17           C  
ATOM   1143  CD  PRO A 145      -1.825  25.505  94.519  1.00 18.18           C  
ATOM   1144  N   TYR A 146       0.751  24.582  92.022  1.00 17.33           N  
ATOM   1145  CA  TYR A 146       1.489  24.431  90.768  1.00 17.59           C  
ATOM   1146  C   TYR A 146       1.405  25.682  89.908  1.00 15.97           C  
ATOM   1147  O   TYR A 146       0.324  26.200  89.654  1.00 16.21           O  
ATOM   1148  CB  TYR A 146       0.900  23.299  89.948  1.00 18.82           C  
ATOM   1149  CG  TYR A 146       0.967  21.966  90.619  1.00 21.17           C  
ATOM   1150  CD1 TYR A 146       2.095  21.163  90.494  1.00 22.29           C  
ATOM   1151  CD2 TYR A 146      -0.099  21.505  91.388  1.00 22.38           C  
ATOM   1152  CE1 TYR A 146       2.157  19.925  91.114  1.00 23.73           C  
ATOM   1153  CE2 TYR A 146      -0.043  20.269  92.007  1.00 23.53           C  
ATOM   1154  CZ  TYR A 146       1.084  19.491  91.867  1.00 21.58           C  
ATOM   1155  OH  TYR A 146       1.139  18.257  92.481  1.00 25.30           O  
ATOM   1156  N   SER A 147       2.555  26.134  89.427  1.00 14.43           N  
ATOM   1157  CA  SER A 147       2.598  27.258  88.523  1.00 13.30           C  
ATOM   1158  C   SER A 147       2.544  26.715  87.089  1.00 12.91           C  
ATOM   1159  O   SER A 147       2.407  25.500  86.870  1.00 13.27           O  
ATOM   1160  CB  SER A 147       3.873  28.058  88.755  1.00 13.28           C  
ATOM   1161  OG  SER A 147       3.836  29.288  88.059  1.00 12.12           O  
ATOM   1162  N   LYS A 148       2.629  27.610  86.118  1.00 12.42           N  
ATOM   1163  CA  LYS A 148       2.745  27.197  84.703  1.00 11.90           C  
ATOM   1164  C   LYS A 148       3.807  26.064  84.622  1.00 11.80           C  
ATOM   1165  O   LYS A 148       4.863  26.198  85.239  1.00 11.36           O  
ATOM   1166  CB  LYS A 148       3.113  28.393  83.830  1.00 11.98           C  
ATOM   1167  CG  LYS A 148       2.163  29.611  83.982  1.00 12.53           C  
ATOM   1168  CD  LYS A 148       2.536  30.764  83.064  1.00 12.87           C  
ATOM   1169  CE  LYS A 148       2.037  32.101  83.549  1.00 13.12           C  
ATOM   1170  NZ  LYS A 148       2.692  33.245  82.865  1.00 13.19           N  
ATOM   1171  N   PRO A 149       3.588  24.976  83.873  1.00 11.41           N  
ATOM   1172  CA  PRO A 149       2.521  24.814  82.863  1.00 11.54           C  
ATOM   1173  C   PRO A 149       1.133  24.388  83.376  1.00 11.47           C  
ATOM   1174  O   PRO A 149       0.263  24.101  82.553  1.00 12.34           O  
ATOM   1175  CB  PRO A 149       3.097  23.738  81.931  1.00 11.18           C  
ATOM   1176  CG  PRO A 149       3.848  22.830  82.875  1.00 11.36           C  
ATOM   1177  CD  PRO A 149       4.441  23.775  83.946  1.00 12.49           C  
ATOM   1178  N   HIS A 150       0.917  24.368  84.686  1.00 10.99           N  
ATOM   1179  CA  HIS A 150      -0.435  24.221  85.226  1.00 10.90           C  
ATOM   1180  C   HIS A 150      -1.275  25.470  84.891  1.00 10.27           C  
ATOM   1181  O   HIS A 150      -0.785  26.590  85.018  1.00 11.07           O  
ATOM   1182  CB  HIS A 150      -0.344  24.011  86.734  1.00 11.06           C  
ATOM   1183  CG  HIS A 150      -1.590  23.495  87.375  1.00 10.80           C  
ATOM   1184  ND1 HIS A 150      -2.741  24.249  87.497  1.00 11.22           N  
ATOM   1185  CD2 HIS A 150      -1.837  22.326  88.012  1.00 13.06           C  
ATOM   1186  CE1 HIS A 150      -3.654  23.551  88.150  1.00 11.74           C  
ATOM   1187  NE2 HIS A 150      -3.132  22.378  88.479  1.00 10.91           N  
ATOM   1188  N   PRO A 151      -2.522  25.301  84.438  1.00 10.56           N  
ATOM   1189  CA  PRO A 151      -3.345  26.441  84.020  1.00 10.10           C  
ATOM   1190  C   PRO A 151      -3.968  27.275  85.151  1.00 10.19           C  
ATOM   1191  O   PRO A 151      -4.609  28.265  84.838  1.00 10.39           O  
ATOM   1192  CB  PRO A 151      -4.459  25.779  83.192  1.00 10.15           C  
ATOM   1193  CG  PRO A 151      -4.596  24.413  83.773  1.00 10.74           C  
ATOM   1194  CD  PRO A 151      -3.212  24.019  84.186  1.00 10.41           C  
ATOM   1195  N   GLN A 152      -3.774  26.916  86.408  1.00 11.40           N  
ATOM   1196  CA  GLN A 152      -4.503  27.572  87.491  1.00 12.20           C  
ATOM   1197  C   GLN A 152      -4.387  29.085  87.484  1.00 11.46           C  
ATOM   1198  O   GLN A 152      -5.380  29.783  87.675  1.00 11.32           O  
ATOM   1199  CB  GLN A 152      -4.056  27.052  88.853  1.00 12.83           C  
ATOM   1200  CG  GLN A 152      -4.969  27.485  89.982  1.00 17.06           C  
ATOM   1201  CD  GLN A 152      -6.357  26.910  89.842  1.00 21.73           C  
ATOM   1202  OE1 GLN A 152      -7.357  27.656  89.782  1.00 24.74           O  
ATOM   1203  NE2 GLN A 152      -6.432  25.584  89.737  1.00 24.81           N  
ATOM   1204  N   VAL A 153      -3.170  29.592  87.299  1.00 11.33           N  
ATOM   1205  CA  VAL A 153      -2.944  31.025  87.320  1.00 10.69           C  
ATOM   1206  C   VAL A 153      -3.738  31.732  86.220  1.00 11.00           C  
ATOM   1207  O   VAL A 153      -4.304  32.791  86.466  1.00 10.01           O  
ATOM   1208  CB  VAL A 153      -1.429  31.394  87.297  1.00 10.32           C  
ATOM   1209  CG1 VAL A 153      -0.758  31.049  85.968  1.00 10.72           C  
ATOM   1210  CG2 VAL A 153      -1.218  32.872  87.683  1.00 10.56           C  
ATOM   1211  N   TYR A 154      -3.753  31.153  85.012  1.00 11.53           N  
ATOM   1212  CA  TYR A 154      -4.571  31.687  83.927  1.00 12.06           C  
ATOM   1213  C   TYR A 154      -6.068  31.623  84.227  1.00 12.15           C  
ATOM   1214  O   TYR A 154      -6.795  32.550  83.889  1.00 12.30           O  
ATOM   1215  CB  TYR A 154      -4.258  30.987  82.601  1.00 12.77           C  
ATOM   1216  CG  TYR A 154      -3.108  31.604  81.865  1.00 12.67           C  
ATOM   1217  CD1 TYR A 154      -1.923  30.915  81.677  1.00 14.99           C  
ATOM   1218  CD2 TYR A 154      -3.206  32.893  81.358  1.00 14.25           C  
ATOM   1219  CE1 TYR A 154      -0.856  31.503  80.998  1.00 13.61           C  
ATOM   1220  CE2 TYR A 154      -2.166  33.485  80.663  1.00 13.34           C  
ATOM   1221  CZ  TYR A 154      -0.999  32.793  80.486  1.00 13.83           C  
ATOM   1222  OH  TYR A 154       0.019  33.407  79.817  1.00 14.53           O  
ATOM   1223  N   LEU A 155      -6.539  30.536  84.837  1.00 12.87           N  
ATOM   1224  CA  LEU A 155      -7.949  30.415  85.197  1.00 13.37           C  
ATOM   1225  C   LEU A 155      -8.318  31.441  86.291  1.00 13.21           C  
ATOM   1226  O   LEU A 155      -9.385  32.055  86.230  1.00 13.91           O  
ATOM   1227  CB  LEU A 155      -8.284  28.982  85.643  1.00 13.68           C  
ATOM   1228  CG  LEU A 155      -8.155  27.918  84.542  1.00 13.74           C  
ATOM   1229  CD1 LEU A 155      -8.172  26.539  85.156  1.00 16.36           C  
ATOM   1230  CD2 LEU A 155      -9.225  28.048  83.460  1.00 14.49           C  
ATOM   1231  N   ASP A 156      -7.419  31.663  87.244  1.00 13.59           N  
ATOM   1232  CA  ASP A 156      -7.638  32.654  88.300  1.00 14.59           C  
ATOM   1233  C   ASP A 156      -7.737  34.062  87.704  1.00 14.20           C  
ATOM   1234  O   ASP A 156      -8.553  34.885  88.142  1.00 13.62           O  
ATOM   1235  CB  ASP A 156      -6.490  32.669  89.314  1.00 14.88           C  
ATOM   1236  CG  ASP A 156      -6.441  31.450  90.204  1.00 16.22           C  
ATOM   1237  OD1 ASP A 156      -7.419  30.663  90.271  1.00 19.16           O  
ATOM   1238  OD2 ASP A 156      -5.430  31.215  90.897  1.00 17.97           O  
ATOM   1239  N   CYS A 157      -6.896  34.346  86.708  1.00 13.85           N  
ATOM   1240  CA  CYS A 157      -6.880  35.650  86.058  1.00 13.70           C  
ATOM   1241  C   CYS A 157      -8.193  35.883  85.319  1.00 13.68           C  
ATOM   1242  O   CYS A 157      -8.804  36.944  85.455  1.00 14.98           O  
ATOM   1243  CB  CYS A 157      -5.699  35.768  85.072  1.00 12.78           C  
ATOM   1244  SG  CYS A 157      -5.445  37.453  84.473  1.00 13.67           S  
ATOM   1245  N   ALA A 158      -8.632  34.882  84.560  1.00 13.39           N  
ATOM   1246  CA  ALA A 158      -9.893  34.938  83.846  1.00 13.98           C  
ATOM   1247  C   ALA A 158     -11.054  35.206  84.796  1.00 14.85           C  
ATOM   1248  O   ALA A 158     -11.937  35.993  84.475  1.00 14.87           O  
ATOM   1249  CB  ALA A 158     -10.119  33.635  83.108  1.00 14.21           C  
ATOM   1250  N   ALA A 159     -11.013  34.581  85.968  1.00 15.33           N  
ATOM   1251  CA  ALA A 159     -12.063  34.742  86.979  1.00 16.75           C  
ATOM   1252  C   ALA A 159     -12.057  36.150  87.557  1.00 17.19           C  
ATOM   1253  O   ALA A 159     -13.124  36.756  87.745  1.00 17.90           O  
ATOM   1254  CB  ALA A 159     -11.893  33.725  88.076  1.00 16.94           C  
ATOM   1255  N   LYS A 160     -10.866  36.674  87.811  1.00 17.57           N  
ATOM   1256  CA  LYS A 160     -10.706  38.020  88.349  1.00 18.83           C  
ATOM   1257  C   LYS A 160     -11.095  39.062  87.332  1.00 18.92           C  
ATOM   1258  O   LYS A 160     -11.595  40.122  87.697  1.00 19.45           O  
ATOM   1259  CB  LYS A 160      -9.265  38.270  88.761  1.00 19.11           C  
ATOM   1260  CG  LYS A 160      -8.853  37.558  90.019  1.00 20.94           C  
ATOM   1261  CD  LYS A 160      -7.372  37.673  90.209  1.00 24.26           C  
ATOM   1262  CE  LYS A 160      -6.918  36.888  91.396  1.00 26.58           C  
ATOM   1263  NZ  LYS A 160      -7.460  37.485  92.643  1.00 29.22           N  
ATOM   1264  N   LEU A 161     -10.847  38.761  86.060  1.00 19.00           N  
ATOM   1265  CA  LEU A 161     -11.310  39.587  84.948  1.00 18.98           C  
ATOM   1266  C   LEU A 161     -12.819  39.539  84.748  1.00 19.40           C  
ATOM   1267  O   LEU A 161     -13.381  40.498  84.251  1.00 20.57           O  
ATOM   1268  CB  LEU A 161     -10.662  39.163  83.635  1.00 18.47           C  
ATOM   1269  CG  LEU A 161      -9.209  39.565  83.422  1.00 17.34           C  
ATOM   1270  CD1 LEU A 161      -8.703  38.874  82.158  1.00 14.68           C  
ATOM   1271  CD2 LEU A 161      -8.999  41.073  83.326  1.00 16.23           C  
ATOM   1272  N   GLY A 162     -13.452  38.416  85.090  1.00 19.23           N  
ATOM   1273  CA  GLY A 162     -14.893  38.247  84.988  1.00 19.11           C  
ATOM   1274  C   GLY A 162     -15.347  37.672  83.665  1.00 18.95           C  
ATOM   1275  O   GLY A 162     -16.497  37.886  83.266  1.00 20.07           O  
ATOM   1276  N   VAL A 163     -14.456  36.954  82.970  1.00 18.15           N  
ATOM   1277  CA  VAL A 163     -14.779  36.332  81.695  1.00 17.63           C  
ATOM   1278  C   VAL A 163     -14.466  34.839  81.674  1.00 17.51           C  
ATOM   1279  O   VAL A 163     -13.694  34.348  82.483  1.00 16.85           O  
ATOM   1280  CB  VAL A 163     -14.045  37.005  80.503  1.00 17.95           C  
ATOM   1281  CG1 VAL A 163     -14.341  38.507  80.470  1.00 17.42           C  
ATOM   1282  CG2 VAL A 163     -12.544  36.773  80.562  1.00 16.46           C  
ATOM   1283  N   ASP A 164     -15.116  34.148  80.743  1.00 17.83           N  
ATOM   1284  CA  ASP A 164     -14.855  32.754  80.432  1.00 18.39           C  
ATOM   1285  C   ASP A 164     -13.432  32.667  79.897  1.00 17.89           C  
ATOM   1286  O   ASP A 164     -13.077  33.447  79.024  1.00 17.49           O  
ATOM   1287  CB  ASP A 164     -15.822  32.295  79.338  1.00 18.78           C  
ATOM   1288  CG  ASP A 164     -15.920  30.798  79.221  1.00 20.84           C  
ATOM   1289  OD1 ASP A 164     -14.881  30.109  79.201  1.00 22.28           O  
ATOM   1290  OD2 ASP A 164     -17.024  30.211  79.134  1.00 24.50           O  
ATOM   1291  N   PRO A 165     -12.622  31.731  80.396  1.00 17.63           N  
ATOM   1292  CA  PRO A 165     -11.279  31.517  79.836  1.00 16.82           C  
ATOM   1293  C   PRO A 165     -11.259  31.265  78.326  1.00 17.15           C  
ATOM   1294  O   PRO A 165     -10.305  31.653  77.657  1.00 15.81           O  
ATOM   1295  CB  PRO A 165     -10.777  30.282  80.597  1.00 16.95           C  
ATOM   1296  CG  PRO A 165     -11.990  29.674  81.190  1.00 17.87           C  
ATOM   1297  CD  PRO A 165     -12.885  30.820  81.528  1.00 16.94           C  
ATOM   1298  N   LEU A 166     -12.313  30.651  77.801  1.00 17.38           N  
ATOM   1299  CA  LEU A 166     -12.469  30.448  76.364  1.00 18.26           C  
ATOM   1300  C   LEU A 166     -12.461  31.744  75.558  1.00 17.95           C  
ATOM   1301  O   LEU A 166     -12.154  31.712  74.375  1.00 18.80           O  
ATOM   1302  CB  LEU A 166     -13.751  29.673  76.060  1.00 18.52           C  
ATOM   1303  CG  LEU A 166     -13.644  28.154  76.061  1.00 20.57           C  
ATOM   1304  CD1 LEU A 166     -12.951  27.636  77.305  1.00 23.15           C  
ATOM   1305  CD2 LEU A 166     -15.038  27.519  75.891  1.00 20.67           C  
ATOM   1306  N   THR A 167     -12.784  32.869  76.192  1.00 17.33           N  
ATOM   1307  CA  THR A 167     -12.757  34.168  75.523  1.00 16.98           C  
ATOM   1308  C   THR A 167     -11.456  34.944  75.736  1.00 15.75           C  
ATOM   1309  O   THR A 167     -11.411  36.136  75.439  1.00 15.93           O  
ATOM   1310  CB  THR A 167     -13.952  35.048  75.947  1.00 17.29           C  
ATOM   1311  OG1 THR A 167     -13.832  35.454  77.319  1.00 17.94           O  
ATOM   1312  CG2 THR A 167     -15.255  34.275  75.874  1.00 18.17           C  
ATOM   1313  N   CYS A 168     -10.403  34.271  76.199  1.00 14.62           N  
ATOM   1314  CA  CYS A 168      -9.132  34.930  76.492  1.00 13.96           C  
ATOM   1315  C   CYS A 168      -8.047  34.565  75.482  1.00 13.32           C  
ATOM   1316  O   CYS A 168      -7.998  33.443  74.999  1.00 13.17           O  
ATOM   1317  CB  CYS A 168      -8.633  34.564  77.879  1.00 14.61           C  
ATOM   1318  SG  CYS A 168      -9.650  35.142  79.254  1.00 14.58           S  
ATOM   1319  N   VAL A 169      -7.193  35.529  75.178  1.00 13.30           N  
ATOM   1320  CA  VAL A 169      -5.973  35.297  74.390  1.00 12.93           C  
ATOM   1321  C   VAL A 169      -4.773  35.571  75.295  1.00 12.83           C  
ATOM   1322  O   VAL A 169      -4.681  36.646  75.888  1.00 12.25           O  
ATOM   1323  CB  VAL A 169      -5.917  36.165  73.116  1.00 12.90           C  
ATOM   1324  CG1 VAL A 169      -6.024  37.673  73.401  1.00 13.44           C  
ATOM   1325  CG2 VAL A 169      -4.652  35.860  72.321  1.00 13.13           C  
ATOM   1326  N   ALA A 170      -3.867  34.598  75.411  1.00 12.00           N  
ATOM   1327  CA  ALA A 170      -2.735  34.694  76.317  1.00 12.38           C  
ATOM   1328  C   ALA A 170      -1.472  34.922  75.496  1.00 12.31           C  
ATOM   1329  O   ALA A 170      -1.225  34.213  74.511  1.00 12.47           O  
ATOM   1330  CB  ALA A 170      -2.599  33.424  77.174  1.00 12.51           C  
ATOM   1331  N   LEU A 171      -0.693  35.915  75.907  1.00 12.08           N  
ATOM   1332  CA  LEU A 171       0.560  36.261  75.220  1.00 12.81           C  
ATOM   1333  C   LEU A 171       1.710  35.766  76.084  1.00 12.97           C  
ATOM   1334  O   LEU A 171       1.843  36.180  77.230  1.00 12.75           O  
ATOM   1335  CB  LEU A 171       0.670  37.762  75.000  1.00 12.47           C  
ATOM   1336  CG  LEU A 171      -0.377  38.326  74.022  1.00 14.39           C  
ATOM   1337  CD1 LEU A 171      -1.613  38.841  74.761  1.00 13.41           C  
ATOM   1338  CD2 LEU A 171       0.212  39.418  73.122  1.00 15.85           C  
ATOM   1339  N   GLU A 172       2.508  34.874  75.525  1.00 13.58           N  
ATOM   1340  CA  GLU A 172       3.560  34.171  76.236  1.00 13.31           C  
ATOM   1341  C   GLU A 172       4.885  34.133  75.468  1.00 14.11           C  
ATOM   1342  O   GLU A 172       4.904  34.237  74.257  1.00 13.42           O  
ATOM   1343  CB  GLU A 172       3.087  32.739  76.500  1.00 13.95           C  
ATOM   1344  CG  GLU A 172       2.243  32.640  77.760  1.00 12.36           C  
ATOM   1345  CD  GLU A 172       3.089  32.628  79.010  1.00 15.02           C  
ATOM   1346  OE1 GLU A 172       4.313  32.526  78.908  1.00 14.98           O  
ATOM   1347  OE2 GLU A 172       2.531  32.700  80.106  1.00 16.18           O  
ATOM   1348  N   ASP A 173       5.985  33.955  76.192  1.00 14.36           N  
ATOM   1349  CA  ASP A 173       7.294  33.786  75.570  1.00 14.40           C  
ATOM   1350  C   ASP A 173       7.876  32.379  75.713  1.00 14.40           C  
ATOM   1351  O   ASP A 173       8.962  32.106  75.182  1.00 14.73           O  
ATOM   1352  CB  ASP A 173       8.282  34.804  76.126  1.00 14.42           C  
ATOM   1353  CG  ASP A 173       8.821  34.416  77.475  1.00 16.15           C  
ATOM   1354  OD1 ASP A 173       8.007  34.024  78.361  1.00 13.62           O  
ATOM   1355  OD2 ASP A 173      10.052  34.495  77.741  1.00 16.46           O  
ATOM   1356  N   SER A 174       7.193  31.493  76.431  1.00 13.54           N  
ATOM   1357  CA  SER A 174       7.752  30.168  76.686  1.00 13.09           C  
ATOM   1358  C   SER A 174       6.777  29.073  76.379  1.00 13.07           C  
ATOM   1359  O   SER A 174       5.569  29.295  76.388  1.00 13.99           O  
ATOM   1360  CB  SER A 174       8.248  30.035  78.124  1.00 13.23           C  
ATOM   1361  OG  SER A 174       7.181  29.879  79.057  1.00 12.90           O  
ATOM   1362  N   VAL A 175       7.312  27.888  76.116  1.00 12.30           N  
ATOM   1363  CA  VAL A 175       6.492  26.695  75.927  1.00 12.85           C  
ATOM   1364  C   VAL A 175       5.706  26.382  77.192  1.00 12.25           C  
ATOM   1365  O   VAL A 175       4.530  26.055  77.106  1.00 12.88           O  
ATOM   1366  CB  VAL A 175       7.338  25.498  75.544  1.00 13.62           C  
ATOM   1367  CG1 VAL A 175       6.585  24.178  75.739  1.00 14.33           C  
ATOM   1368  CG2 VAL A 175       7.782  25.665  74.087  1.00 12.52           C  
ATOM   1369  N   ASN A 176       6.338  26.499  78.351  1.00 12.28           N  
ATOM   1370  CA  ASN A 176       5.635  26.198  79.614  1.00 12.02           C  
ATOM   1371  C   ASN A 176       4.447  27.123  79.838  1.00 12.53           C  
ATOM   1372  O   ASN A 176       3.371  26.679  80.254  1.00 11.01           O  
ATOM   1373  CB  ASN A 176       6.579  26.231  80.842  1.00 12.55           C  
ATOM   1374  CG  ASN A 176       7.344  24.934  81.045  1.00 12.59           C  
ATOM   1375  OD1 ASN A 176       6.836  23.842  80.803  1.00 13.64           O  
ATOM   1376  ND2 ASN A 176       8.588  25.054  81.504  1.00 12.87           N  
ATOM   1377  N   GLY A 177       4.640  28.410  79.560  1.00 12.43           N  
ATOM   1378  CA  GLY A 177       3.557  29.373  79.659  1.00 12.41           C  
ATOM   1379  C   GLY A 177       2.467  29.122  78.620  1.00 12.08           C  
ATOM   1380  O   GLY A 177       1.271  29.146  78.936  1.00 12.02           O  
HETATM 1381  N   MSE A 178       2.865  28.854  77.381  1.00 12.64           N  
HETATM 1382  CA  MSE A 178       1.895  28.504  76.358  1.00 13.02           C  
HETATM 1383  C   MSE A 178       1.035  27.306  76.735  1.00 11.96           C  
HETATM 1384  O   MSE A 178      -0.182  27.325  76.518  1.00 11.40           O  
HETATM 1385  CB  MSE A 178       2.599  28.205  75.028  1.00 12.74           C  
HETATM 1386  CG  MSE A 178       1.673  27.730  73.972  1.00 13.27           C  
HETATM 1387 SE   MSE A 178       2.685  26.983  72.502  0.89 17.74          SE  
HETATM 1388  CE  MSE A 178       3.298  25.449  73.371  1.00 15.54           C  
ATOM   1389  N   ILE A 179       1.648  26.257  77.284  1.00 11.42           N  
ATOM   1390  CA  ILE A 179       0.918  25.042  77.621  1.00 11.84           C  
ATOM   1391  C   ILE A 179      -0.107  25.357  78.707  1.00 11.01           C  
ATOM   1392  O   ILE A 179      -1.231  24.873  78.665  1.00 10.26           O  
ATOM   1393  CB  ILE A 179       1.885  23.935  78.092  1.00 12.04           C  
ATOM   1394  CG1 ILE A 179       2.701  23.410  76.895  1.00 12.05           C  
ATOM   1395  CG2 ILE A 179       1.114  22.811  78.782  1.00 13.44           C  
ATOM   1396  CD1 ILE A 179       3.815  22.478  77.298  1.00 13.16           C  
ATOM   1397  N   ALA A 180       0.289  26.193  79.658  1.00 11.15           N  
ATOM   1398  CA  ALA A 180      -0.642  26.655  80.708  1.00 10.94           C  
ATOM   1399  C   ALA A 180      -1.883  27.325  80.109  1.00 11.38           C  
ATOM   1400  O   ALA A 180      -3.013  27.075  80.535  1.00 10.85           O  
ATOM   1401  CB  ALA A 180       0.052  27.602  81.654  1.00 12.37           C  
ATOM   1402  N   SER A 181      -1.679  28.201  79.134  1.00 10.59           N  
ATOM   1403  CA  SER A 181      -2.787  28.895  78.519  1.00 10.81           C  
ATOM   1404  C   SER A 181      -3.665  27.911  77.723  1.00 11.36           C  
ATOM   1405  O   SER A 181      -4.881  28.024  77.728  1.00 11.05           O  
ATOM   1406  CB  SER A 181      -2.295  30.086  77.684  1.00 10.88           C  
ATOM   1407  OG  SER A 181      -1.699  29.691  76.467  1.00 10.90           O  
ATOM   1408  N   LYS A 182      -3.045  26.923  77.088  1.00 11.74           N  
ATOM   1409  CA  LYS A 182      -3.774  25.935  76.290  1.00 12.25           C  
ATOM   1410  C   LYS A 182      -4.490  24.917  77.171  1.00 12.58           C  
ATOM   1411  O   LYS A 182      -5.564  24.437  76.809  1.00 12.54           O  
ATOM   1412  CB  LYS A 182      -2.843  25.267  75.283  1.00 13.73           C  
ATOM   1413  CG  LYS A 182      -2.577  26.158  74.085  1.00 13.20           C  
ATOM   1414  CD  LYS A 182      -3.804  26.202  73.144  1.00 16.20           C  
ATOM   1415  CE  LYS A 182      -3.758  27.360  72.151  1.00 16.37           C  
ATOM   1416  NZ  LYS A 182      -5.019  27.497  71.349  1.00 15.89           N  
ATOM   1417  N   ALA A 183      -3.924  24.641  78.341  1.00 12.20           N  
ATOM   1418  CA  ALA A 183      -4.594  23.821  79.353  1.00 11.90           C  
ATOM   1419  C   ALA A 183      -5.803  24.542  79.986  1.00 12.15           C  
ATOM   1420  O   ALA A 183      -6.703  23.889  80.512  1.00 12.28           O  
ATOM   1421  CB  ALA A 183      -3.604  23.362  80.417  1.00 11.51           C  
ATOM   1422  N   ALA A 184      -5.819  25.875  79.892  1.00 12.80           N  
ATOM   1423  CA  ALA A 184      -6.955  26.722  80.279  1.00 13.10           C  
ATOM   1424  C   ALA A 184      -7.938  26.937  79.124  1.00 13.26           C  
ATOM   1425  O   ALA A 184      -8.961  27.585  79.294  1.00 12.65           O  
ATOM   1426  CB  ALA A 184      -6.456  28.062  80.794  1.00 12.67           C  
ATOM   1427  N   ARG A 185      -7.597  26.400  77.948  1.00 13.60           N  
ATOM   1428  CA  ARG A 185      -8.434  26.430  76.740  1.00 14.49           C  
ATOM   1429  C   ARG A 185      -8.522  27.823  76.069  1.00 13.81           C  
ATOM   1430  O   ARG A 185      -9.520  28.155  75.422  1.00 14.41           O  
ATOM   1431  CB  ARG A 185      -9.834  25.843  77.019  1.00 13.96           C  
ATOM   1432  CG  ARG A 185      -9.805  24.358  77.333  1.00 16.11           C  
ATOM   1433  CD  ARG A 185     -11.152  23.732  77.466  1.00 17.79           C  
ATOM   1434  NE  ARG A 185     -11.898  23.681  76.204  1.00 20.85           N  
ATOM   1435  CZ  ARG A 185     -13.238  23.667  76.126  1.00 21.70           C  
ATOM   1436  NH1 ARG A 185     -13.997  23.725  77.219  1.00 24.59           N  
ATOM   1437  NH2 ARG A 185     -13.838  23.612  74.949  1.00 21.77           N  
HETATM 1438  N   MSE A 186      -7.440  28.590  76.173  1.00 13.08           N  
HETATM 1439  CA  MSE A 186      -7.369  29.957  75.680  1.00 13.64           C  
HETATM 1440  C   MSE A 186      -6.713  29.992  74.312  1.00 12.76           C  
HETATM 1441  O   MSE A 186      -6.062  29.027  73.906  1.00 13.03           O  
HETATM 1442  CB  MSE A 186      -6.532  30.826  76.627  1.00 13.11           C  
HETATM 1443  CG  MSE A 186      -7.114  30.972  78.011  1.00 13.45           C  
HETATM 1444 SE   MSE A 186      -5.983  31.945  79.206  0.95 17.96          SE  
HETATM 1445  CE  MSE A 186      -7.366  32.075  80.663  1.00 12.75           C  
ATOM   1446  N   ARG A 187      -6.909  31.099  73.607  1.00 13.24           N  
ATOM   1447  CA  ARG A 187      -6.167  31.410  72.380  1.00 13.34           C  
ATOM   1448  C   ARG A 187      -4.749  31.757  72.793  1.00 12.93           C  
ATOM   1449  O   ARG A 187      -4.545  32.337  73.856  1.00 13.51           O  
ATOM   1450  CB  ARG A 187      -6.812  32.598  71.664  1.00 13.73           C  
ATOM   1451  CG  ARG A 187      -6.193  32.997  70.327  1.00 14.18           C  
ATOM   1452  CD  ARG A 187      -6.945  34.154  69.640  1.00 14.31           C  
ATOM   1453  NE  ARG A 187      -6.219  34.669  68.481  1.00 15.39           N  
ATOM   1454  CZ  ARG A 187      -6.154  34.060  67.310  1.00 14.67           C  
ATOM   1455  NH1 ARG A 187      -6.750  32.906  67.125  1.00 14.42           N  
ATOM   1456  NH2 ARG A 187      -5.453  34.595  66.309  1.00 16.68           N  
ATOM   1457  N   SER A 188      -3.763  31.463  71.953  1.00 12.68           N  
ATOM   1458  CA  SER A 188      -2.376  31.694  72.325  1.00 12.67           C  
ATOM   1459  C   SER A 188      -1.595  32.431  71.247  1.00 13.11           C  
ATOM   1460  O   SER A 188      -1.586  31.998  70.089  1.00 13.32           O  
ATOM   1461  CB  SER A 188      -1.683  30.351  72.628  1.00 13.04           C  
ATOM   1462  OG  SER A 188      -0.298  30.521  72.809  1.00 15.10           O  
ATOM   1463  N   ILE A 189      -0.962  33.531  71.651  1.00 13.20           N  
ATOM   1464  CA  ILE A 189       0.068  34.218  70.874  1.00 13.43           C  
ATOM   1465  C   ILE A 189       1.377  34.059  71.624  1.00 13.85           C  
ATOM   1466  O   ILE A 189       1.446  34.321  72.828  1.00 13.68           O  
ATOM   1467  CB  ILE A 189      -0.245  35.727  70.721  1.00 13.34           C  
ATOM   1468  CG1 ILE A 189      -1.622  35.942  70.080  1.00 12.39           C  
ATOM   1469  CG2 ILE A 189       0.834  36.398  69.903  1.00 15.16           C  
ATOM   1470  CD1 ILE A 189      -2.114  37.370  70.138  1.00 13.40           C  
ATOM   1471  N   VAL A 190       2.416  33.646  70.922  1.00 13.72           N  
ATOM   1472  CA  VAL A 190       3.737  33.516  71.519  1.00 14.22           C  
ATOM   1473  C   VAL A 190       4.752  34.441  70.861  1.00 15.20           C  
ATOM   1474  O   VAL A 190       4.730  34.662  69.648  1.00 15.46           O  
ATOM   1475  CB  VAL A 190       4.249  32.037  71.531  1.00 14.36           C  
ATOM   1476  CG1 VAL A 190       3.355  31.173  72.376  1.00 14.76           C  
ATOM   1477  CG2 VAL A 190       4.358  31.448  70.124  1.00 14.93           C  
ATOM   1478  N   VAL A 191       5.615  35.002  71.693  1.00 15.32           N  
ATOM   1479  CA  VAL A 191       6.728  35.840  71.278  1.00 15.89           C  
ATOM   1480  C   VAL A 191       7.941  35.149  71.907  1.00 16.58           C  
ATOM   1481  O   VAL A 191       8.399  35.531  72.996  1.00 16.56           O  
ATOM   1482  CB  VAL A 191       6.535  37.274  71.780  1.00 15.24           C  
ATOM   1483  CG1 VAL A 191       7.594  38.198  71.185  1.00 16.87           C  
ATOM   1484  CG2 VAL A 191       5.139  37.767  71.413  1.00 14.99           C  
ATOM   1485  N   PRO A 192       8.408  34.086  71.250  1.00 18.31           N  
ATOM   1486  CA  PRO A 192       9.385  33.172  71.854  1.00 18.79           C  
ATOM   1487  C   PRO A 192      10.632  33.877  72.350  1.00 19.80           C  
ATOM   1488  O   PRO A 192      11.160  34.751  71.669  1.00 19.43           O  
ATOM   1489  CB  PRO A 192       9.731  32.222  70.714  1.00 19.25           C  
ATOM   1490  CG  PRO A 192       8.552  32.256  69.810  1.00 19.34           C  
ATOM   1491  CD  PRO A 192       8.055  33.659  69.882  1.00 18.60           C  
ATOM   1492  N   ALA A 193      11.100  33.477  73.521  1.00 19.91           N  
ATOM   1493  CA  ALA A 193      12.341  33.986  74.053  1.00 21.05           C  
ATOM   1494  C   ALA A 193      13.469  33.643  73.081  1.00 22.19           C  
ATOM   1495  O   ALA A 193      13.373  32.671  72.335  1.00 20.85           O  
ATOM   1496  CB  ALA A 193      12.612  33.379  75.418  1.00 21.24           C  
ATOM   1497  N   PRO A 194      14.537  34.435  73.082  1.00 23.93           N  
ATOM   1498  CA  PRO A 194      15.715  34.112  72.268  1.00 25.01           C  
ATOM   1499  C   PRO A 194      16.183  32.662  72.481  1.00 26.04           C  
ATOM   1500  O   PRO A 194      16.462  31.968  71.515  1.00 26.13           O  
ATOM   1501  CB  PRO A 194      16.759  35.115  72.759  1.00 25.19           C  
ATOM   1502  CG  PRO A 194      15.952  36.289  73.226  1.00 24.77           C  
ATOM   1503  CD  PRO A 194      14.713  35.689  73.842  1.00 24.41           C  
ATOM   1504  N   GLU A 195      16.222  32.213  73.734  1.00 27.53           N  
ATOM   1505  CA  GLU A 195      16.546  30.821  74.068  1.00 29.00           C  
ATOM   1506  C   GLU A 195      15.590  29.833  73.355  1.00 28.98           C  
ATOM   1507  O   GLU A 195      16.009  28.777  72.876  1.00 29.87           O  
ATOM   1508  CB  GLU A 195      16.453  30.594  75.589  1.00 29.41           C  
ATOM   1509  CG  GLU A 195      17.380  31.441  76.467  1.00 31.27           C  
ATOM   1510  CD  GLU A 195      17.034  31.363  77.962  1.00 32.30           C  
ATOM   1511  OE1 GLU A 195      17.374  30.339  78.597  1.00 36.51           O  
ATOM   1512  OE2 GLU A 195      16.441  32.332  78.528  1.00 35.97           O  
ATOM   1513  N   ALA A 196      14.307  30.174  73.295  1.00 28.00           N  
ATOM   1514  CA  ALA A 196      13.288  29.244  72.808  1.00 27.19           C  
ATOM   1515  C   ALA A 196      13.042  29.320  71.311  1.00 26.71           C  
ATOM   1516  O   ALA A 196      12.151  28.653  70.794  1.00 26.41           O  
ATOM   1517  CB  ALA A 196      11.977  29.467  73.564  1.00 26.91           C  
ATOM   1518  N   GLN A 197      13.819  30.124  70.597  1.00 26.44           N  
ATOM   1519  CA  GLN A 197      13.642  30.195  69.155  1.00 25.95           C  
ATOM   1520  C   GLN A 197      13.770  28.796  68.578  1.00 24.29           C  
ATOM   1521  O   GLN A 197      14.599  27.970  69.039  1.00 25.13           O  
ATOM   1522  CB  GLN A 197      14.677  31.099  68.485  1.00 25.96           C  
ATOM   1523  CG  GLN A 197      14.543  32.557  68.839  1.00 28.28           C  
ATOM   1524  CD  GLN A 197      15.559  33.387  68.115  1.00 29.80           C  
ATOM   1525  OE1 GLN A 197      16.508  33.876  68.730  1.00 34.37           O  
ATOM   1526  NE2 GLN A 197      15.387  33.530  66.800  1.00 30.83           N  
ATOM   1527  N   ASN A 198      12.922  28.541  67.592  1.00 22.43           N  
ATOM   1528  CA  ASN A 198      12.896  27.296  66.840  1.00 20.83           C  
ATOM   1529  C   ASN A 198      12.382  26.095  67.635  1.00 19.69           C  
ATOM   1530  O   ASN A 198      12.485  24.968  67.175  1.00 19.68           O  
ATOM   1531  CB  ASN A 198      14.272  27.029  66.222  1.00 20.51           C  
ATOM   1532  CG  ASN A 198      14.752  28.190  65.376  1.00 20.02           C  
ATOM   1533  OD1 ASN A 198      13.975  28.778  64.629  1.00 17.28           O  
ATOM   1534  ND2 ASN A 198      16.036  28.524  65.482  1.00 20.07           N  
ATOM   1535  N   ASP A 199      11.793  26.337  68.809  1.00 18.23           N  
ATOM   1536  CA  ASP A 199      11.199  25.251  69.561  1.00 17.45           C  
ATOM   1537  C   ASP A 199       9.972  24.801  68.763  1.00 17.37           C  
ATOM   1538  O   ASP A 199       9.046  25.600  68.573  1.00 16.49           O  
ATOM   1539  CB  ASP A 199      10.824  25.688  70.986  1.00 17.46           C  
ATOM   1540  CG  ASP A 199      10.520  24.501  71.893  1.00 18.10           C  
ATOM   1541  OD1 ASP A 199       9.831  23.582  71.435  1.00 19.00           O  
ATOM   1542  OD2 ASP A 199      10.945  24.388  73.057  1.00 18.18           O  
ATOM   1543  N   PRO A 200       9.965  23.556  68.273  1.00 16.97           N  
ATOM   1544  CA  PRO A 200       8.858  23.059  67.439  1.00 17.49           C  
ATOM   1545  C   PRO A 200       7.504  23.032  68.141  1.00 17.26           C  
ATOM   1546  O   PRO A 200       6.462  22.992  67.481  1.00 17.46           O  
ATOM   1547  CB  PRO A 200       9.292  21.636  67.110  1.00 17.76           C  
ATOM   1548  CG  PRO A 200      10.170  21.277  68.195  1.00 17.88           C  
ATOM   1549  CD  PRO A 200      10.977  22.502  68.477  1.00 17.71           C  
ATOM   1550  N   ARG A 201       7.537  23.054  69.463  1.00 16.40           N  
ATOM   1551  CA  ARG A 201       6.315  22.980  70.256  1.00 16.23           C  
ATOM   1552  C   ARG A 201       5.480  24.252  70.226  1.00 15.52           C  
ATOM   1553  O   ARG A 201       4.313  24.222  70.624  1.00 15.36           O  
ATOM   1554  CB  ARG A 201       6.656  22.591  71.682  1.00 16.40           C  
ATOM   1555  CG  ARG A 201       7.295  21.216  71.789  1.00 17.46           C  
ATOM   1556  CD  ARG A 201       7.751  20.892  73.171  1.00 20.81           C  
ATOM   1557  NE  ARG A 201       8.777  21.820  73.637  1.00 21.91           N  
ATOM   1558  CZ  ARG A 201       9.194  21.896  74.891  1.00 24.12           C  
ATOM   1559  NH1 ARG A 201       8.689  21.085  75.826  1.00 25.91           N  
ATOM   1560  NH2 ARG A 201      10.123  22.778  75.221  1.00 24.26           N  
ATOM   1561  N   PHE A 202       6.040  25.353  69.734  1.00 14.81           N  
ATOM   1562  CA  PHE A 202       5.258  26.581  69.509  1.00 14.56           C  
ATOM   1563  C   PHE A 202       4.186  26.466  68.411  1.00 15.08           C  
ATOM   1564  O   PHE A 202       3.340  27.361  68.264  1.00 14.72           O  
ATOM   1565  CB  PHE A 202       6.163  27.791  69.259  1.00 14.18           C  
ATOM   1566  CG  PHE A 202       6.890  28.270  70.483  1.00 14.76           C  
ATOM   1567  CD1 PHE A 202       6.187  28.635  71.623  1.00 13.91           C  
ATOM   1568  CD2 PHE A 202       8.280  28.402  70.487  1.00 13.36           C  
ATOM   1569  CE1 PHE A 202       6.853  29.100  72.757  1.00 14.26           C  
ATOM   1570  CE2 PHE A 202       8.942  28.854  71.615  1.00 13.23           C  
ATOM   1571  CZ  PHE A 202       8.220  29.195  72.758  1.00 12.63           C  
ATOM   1572  N   VAL A 203       4.189  25.356  67.670  1.00 15.40           N  
ATOM   1573  CA  VAL A 203       3.132  25.066  66.702  1.00 16.14           C  
ATOM   1574  C   VAL A 203       1.743  24.989  67.367  1.00 16.25           C  
ATOM   1575  O   VAL A 203       0.731  25.126  66.711  1.00 16.28           O  
ATOM   1576  CB  VAL A 203       3.429  23.757  65.932  1.00 16.06           C  
ATOM   1577  CG1 VAL A 203       3.250  22.543  66.801  1.00 16.39           C  
ATOM   1578  CG2 VAL A 203       2.576  23.649  64.682  1.00 17.50           C  
ATOM   1579  N   LEU A 204       1.704  24.768  68.673  1.00 16.88           N  
ATOM   1580  CA  LEU A 204       0.448  24.774  69.416  1.00 17.48           C  
ATOM   1581  C   LEU A 204      -0.176  26.169  69.531  1.00 17.00           C  
ATOM   1582  O   LEU A 204      -1.389  26.301  69.723  1.00 16.05           O  
ATOM   1583  CB  LEU A 204       0.678  24.181  70.809  1.00 17.54           C  
ATOM   1584  CG  LEU A 204      -0.498  24.132  71.771  1.00 19.85           C  
ATOM   1585  CD1 LEU A 204      -1.577  23.233  71.221  1.00 22.40           C  
ATOM   1586  CD2 LEU A 204      -0.051  23.650  73.135  1.00 20.05           C  
ATOM   1587  N   ALA A 205       0.645  27.208  69.437  1.00 16.53           N  
ATOM   1588  CA  ALA A 205       0.146  28.575  69.514  1.00 16.91           C  
ATOM   1589  C   ALA A 205      -0.681  28.864  68.272  1.00 17.08           C  
ATOM   1590  O   ALA A 205      -0.454  28.264  67.225  1.00 17.08           O  
ATOM   1591  CB  ALA A 205       1.289  29.552  69.648  1.00 16.99           C  
ATOM   1592  N   ASN A 206      -1.670  29.738  68.416  1.00 17.01           N  
ATOM   1593  CA  ASN A 206      -2.455  30.226  67.290  1.00 17.61           C  
ATOM   1594  C   ASN A 206      -1.698  31.227  66.429  1.00 17.79           C  
ATOM   1595  O   ASN A 206      -1.945  31.311  65.225  1.00 17.64           O  
ATOM   1596  CB  ASN A 206      -3.736  30.852  67.793  1.00 17.35           C  
ATOM   1597  CG  ASN A 206      -4.595  29.848  68.522  1.00 17.86           C  
ATOM   1598  OD1 ASN A 206      -4.612  29.797  69.749  1.00 16.05           O  
ATOM   1599  ND2 ASN A 206      -5.229  28.981  67.768  1.00 16.67           N  
ATOM   1600  N   VAL A 207      -0.838  32.015  67.079  1.00 17.90           N  
ATOM   1601  CA  VAL A 207       0.011  33.024  66.435  1.00 18.27           C  
ATOM   1602  C   VAL A 207       1.399  33.027  67.059  1.00 18.70           C  
ATOM   1603  O   VAL A 207       1.548  32.976  68.274  1.00 17.89           O  
ATOM   1604  CB  VAL A 207      -0.556  34.454  66.581  1.00 18.27           C  
ATOM   1605  CG1 VAL A 207       0.427  35.511  66.071  1.00 18.71           C  
ATOM   1606  CG2 VAL A 207      -1.880  34.581  65.860  1.00 18.39           C  
ATOM   1607  N   LYS A 208       2.406  33.131  66.200  1.00 19.93           N  
ATOM   1608  CA  LYS A 208       3.800  33.251  66.597  1.00 20.88           C  
ATOM   1609  C   LYS A 208       4.371  34.543  66.010  1.00 21.31           C  
ATOM   1610  O   LYS A 208       4.333  34.766  64.786  1.00 20.78           O  
ATOM   1611  CB  LYS A 208       4.568  32.035  66.088  1.00 21.58           C  
ATOM   1612  CG  LYS A 208       6.049  32.039  66.373  1.00 24.12           C  
ATOM   1613  CD  LYS A 208       6.602  30.625  66.131  1.00 26.32           C  
ATOM   1614  CE  LYS A 208       8.101  30.631  65.948  1.00 29.60           C  
ATOM   1615  NZ  LYS A 208       8.595  29.465  65.131  1.00 29.69           N  
ATOM   1616  N   LEU A 209       4.853  35.404  66.898  1.00 21.36           N  
ATOM   1617  CA  LEU A 209       5.431  36.697  66.548  1.00 22.02           C  
ATOM   1618  C   LEU A 209       6.928  36.698  66.871  1.00 22.54           C  
ATOM   1619  O   LEU A 209       7.355  36.096  67.853  1.00 21.90           O  
ATOM   1620  CB  LEU A 209       4.737  37.810  67.332  1.00 22.07           C  
ATOM   1621  CG  LEU A 209       3.216  37.975  67.187  1.00 22.90           C  
ATOM   1622  CD1 LEU A 209       2.697  39.058  68.146  1.00 23.48           C  
ATOM   1623  CD2 LEU A 209       2.818  38.292  65.746  1.00 23.14           C  
ATOM   1624  N   SER A 210       7.730  37.362  66.042  1.00 22.79           N  
ATOM   1625  CA  SER A 210       9.150  37.525  66.350  1.00 23.78           C  
ATOM   1626  C   SER A 210       9.332  38.591  67.415  1.00 23.14           C  
ATOM   1627  O   SER A 210      10.290  38.558  68.167  1.00 23.97           O  
ATOM   1628  CB  SER A 210       9.965  37.863  65.097  1.00 23.82           C  
ATOM   1629  OG  SER A 210       9.620  39.138  64.599  1.00 27.53           O  
ATOM   1630  N   SER A 211       8.386  39.528  67.484  1.00 23.18           N  
ATOM   1631  CA  SER A 211       8.380  40.579  68.496  1.00 22.49           C  
ATOM   1632  C   SER A 211       6.960  41.087  68.725  1.00 21.82           C  
ATOM   1633  O   SER A 211       6.120  40.976  67.838  1.00 21.21           O  
ATOM   1634  CB  SER A 211       9.276  41.736  68.055  1.00 22.69           C  
ATOM   1635  OG  SER A 211       9.137  42.853  68.908  1.00 22.97           O  
ATOM   1636  N   LEU A 212       6.706  41.669  69.899  1.00 21.84           N  
ATOM   1637  CA  LEU A 212       5.409  42.313  70.181  1.00 22.04           C  
ATOM   1638  C   LEU A 212       5.172  43.553  69.322  1.00 22.31           C  
ATOM   1639  O   LEU A 212       4.052  44.050  69.247  1.00 21.89           O  
ATOM   1640  CB  LEU A 212       5.265  42.712  71.659  1.00 21.96           C  
ATOM   1641  CG  LEU A 212       4.777  41.660  72.655  1.00 22.27           C  
ATOM   1642  CD1 LEU A 212       4.830  42.222  74.079  1.00 23.06           C  
ATOM   1643  CD2 LEU A 212       3.378  41.171  72.331  1.00 21.69           C  
ATOM   1644  N   THR A 213       6.222  44.062  68.682  1.00 22.28           N  
ATOM   1645  CA  THR A 213       6.060  45.186  67.755  1.00 22.66           C  
ATOM   1646  C   THR A 213       5.199  44.761  66.561  1.00 22.70           C  
ATOM   1647  O   THR A 213       4.537  45.583  65.942  1.00 23.12           O  
ATOM   1648  CB  THR A 213       7.431  45.706  67.259  1.00 22.40           C  
ATOM   1649  OG1 THR A 213       8.146  44.664  66.584  1.00 24.26           O  
ATOM   1650  CG2 THR A 213       8.326  46.090  68.421  1.00 23.08           C  
ATOM   1651  N   GLU A 214       5.205  43.463  66.270  1.00 22.54           N  
ATOM   1652  CA  GLU A 214       4.448  42.879  65.180  1.00 23.19           C  
ATOM   1653  C   GLU A 214       2.979  42.611  65.504  1.00 21.73           C  
ATOM   1654  O   GLU A 214       2.212  42.261  64.614  1.00 21.58           O  
ATOM   1655  CB  GLU A 214       5.078  41.553  64.767  1.00 23.05           C  
ATOM   1656  CG  GLU A 214       6.515  41.627  64.271  1.00 25.14           C  
ATOM   1657  CD  GLU A 214       7.011  40.273  63.775  1.00 26.97           C  
ATOM   1658  OE1 GLU A 214       6.422  39.240  64.174  1.00 32.04           O  
ATOM   1659  OE2 GLU A 214       7.986  40.226  62.980  1.00 32.74           O  
ATOM   1660  N   LEU A 215       2.577  42.772  66.758  1.00 20.60           N  
ATOM   1661  CA  LEU A 215       1.209  42.451  67.142  1.00 19.63           C  
ATOM   1662  C   LEU A 215       0.173  43.251  66.342  1.00 19.48           C  
ATOM   1663  O   LEU A 215       0.276  44.469  66.229  1.00 18.61           O  
ATOM   1664  CB  LEU A 215       1.012  42.660  68.655  1.00 19.25           C  
ATOM   1665  CG  LEU A 215      -0.346  42.261  69.238  1.00 18.48           C  
ATOM   1666  CD1 LEU A 215      -0.571  40.763  69.099  1.00 19.36           C  
ATOM   1667  CD2 LEU A 215      -0.432  42.690  70.690  1.00 18.82           C  
ATOM   1668  N   THR A 216      -0.828  42.551  65.809  1.00 19.92           N  
ATOM   1669  CA  THR A 216      -1.959  43.172  65.110  1.00 20.59           C  
ATOM   1670  C   THR A 216      -3.286  42.790  65.750  1.00 21.06           C  
ATOM   1671  O   THR A 216      -3.360  41.859  66.556  1.00 21.04           O  
ATOM   1672  CB  THR A 216      -2.003  42.751  63.621  1.00 20.56           C  
ATOM   1673  OG1 THR A 216      -2.293  41.351  63.506  1.00 20.24           O  
ATOM   1674  CG2 THR A 216      -0.657  42.924  62.947  1.00 21.58           C  
ATOM   1675  N   ALA A 217      -4.337  43.509  65.362  1.00 21.31           N  
ATOM   1676  CA  ALA A 217      -5.694  43.246  65.831  1.00 21.14           C  
ATOM   1677  C   ALA A 217      -6.148  41.844  65.453  1.00 21.23           C  
ATOM   1678  O   ALA A 217      -6.812  41.174  66.225  1.00 20.59           O  
ATOM   1679  CB  ALA A 217      -6.658  44.273  65.268  1.00 20.97           C  
ATOM   1680  N   LYS A 218      -5.786  41.411  64.249  1.00 21.36           N  
ATOM   1681  CA  LYS A 218      -6.125  40.080  63.768  1.00 21.37           C  
ATOM   1682  C   LYS A 218      -5.466  38.981  64.605  1.00 20.22           C  
ATOM   1683  O   LYS A 218      -6.033  37.915  64.785  1.00 19.54           O  
ATOM   1684  CB  LYS A 218      -5.703  39.936  62.300  1.00 22.39           C  
ATOM   1685  CG  LYS A 218      -5.945  38.574  61.672  1.00 25.19           C  
ATOM   1686  CD  LYS A 218      -7.430  38.190  61.657  1.00 27.48           C  
ATOM   1687  CE  LYS A 218      -7.674  36.890  60.882  1.00 28.09           C  
ATOM   1688  NZ  LYS A 218      -9.116  36.468  60.848  1.00 28.60           N  
ATOM   1689  N   ASP A 219      -4.247  39.221  65.079  1.00 19.87           N  
ATOM   1690  CA  ASP A 219      -3.564  38.236  65.929  1.00 19.31           C  
ATOM   1691  C   ASP A 219      -4.341  38.029  67.230  1.00 18.82           C  
ATOM   1692  O   ASP A 219      -4.511  36.909  67.680  1.00 18.50           O  
ATOM   1693  CB  ASP A 219      -2.151  38.684  66.292  1.00 19.22           C  
ATOM   1694  CG  ASP A 219      -1.241  38.833  65.080  1.00 20.23           C  
ATOM   1695  OD1 ASP A 219      -1.345  38.031  64.135  1.00 21.34           O  
ATOM   1696  OD2 ASP A 219      -0.376  39.724  65.006  1.00 22.23           O  
ATOM   1697  N   LEU A 220      -4.793  39.123  67.823  1.00 18.59           N  
ATOM   1698  CA  LEU A 220      -5.544  39.072  69.085  1.00 18.52           C  
ATOM   1699  C   LEU A 220      -6.898  38.397  68.936  1.00 19.19           C  
ATOM   1700  O   LEU A 220      -7.249  37.516  69.715  1.00 19.02           O  
ATOM   1701  CB  LEU A 220      -5.756  40.487  69.618  1.00 18.61           C  
ATOM   1702  CG  LEU A 220      -4.498  41.214  70.097  1.00 18.80           C  
ATOM   1703  CD1 LEU A 220      -4.766  42.701  70.205  1.00 19.75           C  
ATOM   1704  CD2 LEU A 220      -4.018  40.635  71.430  1.00 18.14           C  
ATOM   1705  N   LEU A 221      -7.663  38.820  67.929  1.00 19.78           N  
ATOM   1706  CA  LEU A 221      -9.075  38.451  67.824  1.00 20.69           C  
ATOM   1707  C   LEU A 221      -9.287  37.193  66.997  1.00 21.24           C  
ATOM   1708  O   LEU A 221     -10.282  36.498  67.174  1.00 20.90           O  
ATOM   1709  CB  LEU A 221      -9.892  39.617  67.249  1.00 20.69           C  
ATOM   1710  CG  LEU A 221      -9.805  40.943  68.016  1.00 21.54           C  
ATOM   1711  CD1 LEU A 221     -10.618  42.027  67.317  1.00 22.80           C  
ATOM   1712  CD2 LEU A 221     -10.253  40.805  69.461  1.00 22.28           C  
ATOM   1713  N   GLY A 222      -8.337  36.911  66.111  1.00 22.06           N  
ATOM   1714  CA  GLY A 222      -8.414  35.771  65.220  1.00 23.50           C  
ATOM   1715  C   GLY A 222      -9.283  36.087  64.020  1.00 24.61           C  
ATOM   1716  O   GLY A 222      -9.564  37.268  63.763  1.00 25.13           O  
TER    1717      GLY A 222                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
