
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  142 ( 1150),  selected  142 , name 2pdo_D
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 2pdo_D.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     0_D      R      26          4.424
LGA    X     1_D      Y      27          1.950
LGA    E     2_D      H      28          1.076
LGA    I     3_D      L      29          0.631
LGA    R     4_D      R      30          0.571
LGA    V     5_D      P      31          0.843
LGA    F     6_D      P      32          0.694
LGA    R     7_D      R      33          1.050
LGA    Q     8_D      R      34          1.885
LGA    E     9_D      N      35          1.970
LGA    D    10_D      D      36          1.508
LGA    F    11_D      G      37          1.831
LGA    E    12_D      A      38          1.834
LGA    E    13_D      A      39          1.405
LGA    V    14_D      I      40          1.115
LGA    I    15_D      H      41          1.610
LGA    T    16_D      Q      42          1.704
LGA    L    17_D      L      43          1.059
LGA    W    18_D      V      44          0.885
LGA    E    19_D      S      45          1.527
LGA    R    20_D      E      46          1.552
LGA    C    21_D      C      47          1.469
LGA    D    22_D      P      48          1.520
LGA    L    23_D      P      49          4.918
LGA    L    24_D      L      50          3.863
LGA    R    25_D      D      51          1.881
LGA    P    26_D      -       -           -
LGA    W    27_D      -       -           -
LGA    N    28_D      L      52          5.399
LGA    D    29_D      N      53          2.251
LGA    P    30_D      S      54          3.455
LGA    E    31_D      L      55          1.285
LGA    X    32_D      Y      56          3.285
LGA    D    33_D      A      57          2.113
LGA    I    34_D      Y      58          1.084
LGA    E    35_D      L      59          3.178
LGA    R    36_D      L      60          3.306
LGA    K    37_D      L      61          2.075
LGA    X    38_D      C      62          3.863
LGA    N    39_D      E      63          4.805
LGA    H    40_D      H      64          3.060
LGA    D    41_D      H      65          2.628
LGA    V    42_D      A      66          1.846
LGA    S    43_D      H      67          1.332
LGA    L    44_D      T      68          1.148
LGA    F    45_D      C      69          1.635
LGA    L    46_D      V      70          0.667
LGA    V    47_D      V      71          0.309
LGA    A    48_D      A      72          0.564
LGA    E    49_D      E      73          0.675
LGA    V    50_D      S      74          0.717
LGA    N    51_D      P      75          2.747
LGA    G    52_D      G      76          2.805
LGA    -       -      G      77           -
LGA    E    53_D      R      78          0.951
LGA    V    54_D      I      79          0.661
LGA    V    55_D      D      80          1.054
LGA    G    56_D      G      81          0.484
LGA    T    57_D      F      82          0.526
LGA    V    58_D      V      83          0.353
LGA    X    59_D      S      84          0.690
LGA    G    60_D      A      85          1.858
LGA    G    61_D      Y      86          1.035
LGA    Y    62_D      L      87          0.840
LGA    D    63_D      L      88          1.994
LGA    -       -      P      89           -
LGA    -       -      T      90           -
LGA    -       -      R      91           -
LGA    G    64_D      P      92          1.333
LGA    H    65_D      D      93          3.029
LGA    R    66_D      V      94          0.686
LGA    G    67_D      L      95          0.205
LGA    S    68_D      F      96          1.178
LGA    A    69_D      V      97          1.110
LGA    Y    70_D      W      98          2.019
LGA    Y    71_D      Q      99          1.868
LGA    L    72_D      V     100          0.739
LGA    G    73_D      A     101          1.565
LGA    V    74_D      V     102          1.432
LGA    H    75_D      H     103          1.407
LGA    P    76_D      S     104          0.911
LGA    E    77_D      R     105          1.063
LGA    F    78_D      A     106          1.573
LGA    R    79_D      R     107          0.993
LGA    G    80_D      G     108          0.443
LGA    R    81_D      H     109          1.490
LGA    G    82_D      R     110          2.190
LGA    I    83_D      L     111          1.819
LGA    A    84_D      G     112          1.691
LGA    N    85_D      R     113          1.594
LGA    A    86_D      A     114          1.025
LGA    L    87_D      M     115          0.326
LGA    L    88_D      L     116          0.969
LGA    N    89_D      G     117          0.737
LGA    R    90_D      H     118          0.448
LGA    L    91_D      I     119          1.210
LGA    E    92_D      L     120          1.305
LGA    K    93_D      E     121          1.007
LGA    K    94_D      R     122          1.884
LGA    -       -      Q     123           -
LGA    L    95_D      E     124          4.978
LGA    I    96_D      C     125          3.532
LGA    A    97_D      R     126          2.784
LGA    R    98_D      -       -           -
LGA    G    99_D      H     127          1.472
LGA    C   100_D      V     128          1.636
LGA    P   101_D      R     129          1.683
LGA    K   102_D      H     130          1.418
LGA    I   103_D      L     131          1.107
LGA    Q   104_D      E     132          1.170
LGA    I   105_D      T     133          1.517
LGA    N   106_D      T     134          1.194
LGA    V   107_D      V     135          0.985
LGA    P   108_D      G     136          0.931
LGA    E   109_D      P     137          1.640
LGA    D   110_D      D     138          1.919
LGA    N   111_D      N     139          1.396
LGA    D   112_D      Q     140          1.486
LGA    X   113_D      A     141          1.926
LGA    V   114_D      S     142          1.582
LGA    L   115_D      R     143          1.680
LGA    G   116_D      R     144          2.548
LGA    X   117_D      T     145          2.879
LGA    Y   118_D      F     146          2.072
LGA    E   119_D      A     147          1.634
LGA    R   120_D      G     148          2.563
LGA    L   121_D      L     149          2.492
LGA    G   122_D      A     150          1.931
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    Y   123_D      A     155           #
LGA    E   124_D      H     156          4.194
LGA    H   125_D      V     157          3.851
LGA    A   126_D      S     158          2.328
LGA    D   127_D      E     159          4.894
LGA    V   128_D      Q     160          3.216
LGA    L   129_D      P     161          3.157
LGA    S   130_D      F     162          1.810
LGA    L   131_D      -       -           -
LGA    G   132_D      F     163          5.502
LGA    -       -      D     164           -
LGA    -       -      R     165           -
LGA    -       -      Q     166           -
LGA    -       -      A     167           -
LGA    K   133_D      F     168           #
LGA    R   134_D      G     169           -
LGA    L   135_D      G     170           -
LGA    I   136_D      A     171           -
LGA    E   137_D      D     172           -
LGA    D   138_D      H     173           -
LGA    E   139_D      D     174           -
LGA    E   140_D      D     175           -
LGA    Y   141_D      E     176           -
LGA    -       -      M     177           -
LGA    -       -      L     178           -
LGA    -       -      L     179           -
LGA    -       -      R     180           -
LGA    -       -      I     181           -
LGA    -       -      G     182           -
LGA    -       -      P     183           -
LGA    -       -      F     184           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  142  159    5.0    128    2.14    17.97     69.259     5.713

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.746635 * X  +  -0.297723 * Y  +  -0.594892 * Z  +  58.474083
  Y_new =  -0.582489 * X  +   0.724527 * Y  +   0.368467 * Z  + -52.001949
  Z_new =   0.321314 * X  +   0.621628 * Y  +  -0.714378 * Z  +  52.978947 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.425506   -0.716086  [ DEG:   138.9713    -41.0287 ]
  Theta =  -0.327117   -2.814476  [ DEG:   -18.7424   -161.2576 ]
  Phi   =  -2.479072    0.662521  [ DEG:  -142.0404     37.9596 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pdo_D                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pdo_D.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  142  159   5.0  128   2.14   17.97  69.259
REMARK  ---------------------------------------------------------- 
MOLECULE 2pdo_D
HEADER    TRANSFERASE                             01-APR-07   2PDO              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE ACETYLTRANSFERASE OF GNAT           
TITLE    2 FAMILY FROM SHIGELLA FLEXNERI                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE YPEA;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 EC: 2.3.1.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHIGELLA FLEXNERI 2A;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 2457T;                                                       
SOURCE   5 ATCC: 700930;                                                        
SOURCE   6 GENE: YPEA, SF2487, S_2635;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPHA-BETA-ALPHA SANDWICH, STRUCTURAL GENOMICS, PSI-2,                
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,H.LI,D.HOLZLE,A.JOACHIMIAK,MIDWEST CENTER FOR                   
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   24-APR-07 2PDO    0                                                
JRNL        AUTH   Y.KIM,H.LI,D.HOLZLE,A.JOACHIMIAK                             
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE                            
JRNL        TITL 2 ACETYLTRANSFERASE OF GNAT FAMILY FROM SHIGELLA               
JRNL        TITL 3 FLEXNERI                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2PDO A    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO B    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO C    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO D    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO E    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO F    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO G    1   141  UNP    P63422   YPEA_SHIFL       1    141             
DBREF  2PDO H    1   141  UNP    P63422   YPEA_SHIFL       1    141             
SEQRES   1 A  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 A  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 A  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 A  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 A  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 A  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 A  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 A  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 A  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 A  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 A  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 A  144  TYR                                                          
SEQRES   1 B  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 B  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 B  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 B  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 B  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 B  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 B  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 B  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 B  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 B  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 B  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 B  144  TYR                                                          
SEQRES   1 C  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 C  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 C  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 C  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 C  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 C  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 C  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 C  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 C  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 C  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 C  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 C  144  TYR                                                          
SEQRES   1 D  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 D  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 D  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 D  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 D  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 D  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 D  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 D  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 D  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 D  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 D  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 D  144  TYR                                                          
SEQRES   1 E  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 E  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 E  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 E  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 E  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 E  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 E  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 E  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 E  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 E  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 E  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 E  144  TYR                                                          
SEQRES   1 F  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 F  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 F  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 F  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 F  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 F  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 F  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 F  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 F  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 F  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 F  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 F  144  TYR                                                          
SEQRES   1 G  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 G  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 G  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 G  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 G  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 G  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 G  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 G  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 G  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 G  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 G  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 G  144  TYR                                                          
SEQRES   1 H  144  SER ASN ALA MSE GLU ILE ARG VAL PHE ARG GLN GLU ASP          
SEQRES   2 H  144  PHE GLU GLU VAL ILE THR LEU TRP GLU ARG CYS ASP LEU          
SEQRES   3 H  144  LEU ARG PRO TRP ASN ASP PRO GLU MSE ASP ILE GLU ARG          
SEQRES   4 H  144  LYS MSE ASN HIS ASP VAL SER LEU PHE LEU VAL ALA GLU          
SEQRES   5 H  144  VAL ASN GLY GLU VAL VAL GLY THR VAL MSE GLY GLY TYR          
SEQRES   6 H  144  ASP GLY HIS ARG GLY SER ALA TYR TYR LEU GLY VAL HIS          
SEQRES   7 H  144  PRO GLU PHE ARG GLY ARG GLY ILE ALA ASN ALA LEU LEU          
SEQRES   8 H  144  ASN ARG LEU GLU LYS LYS LEU ILE ALA ARG GLY CYS PRO          
SEQRES   9 H  144  LYS ILE GLN ILE ASN VAL PRO GLU ASP ASN ASP MSE VAL          
SEQRES  10 H  144  LEU GLY MSE TYR GLU ARG LEU GLY TYR GLU HIS ALA ASP          
SEQRES  11 H  144  VAL LEU SER LEU GLY LYS ARG LEU ILE GLU ASP GLU GLU          
SEQRES  12 H  144  TYR                                                          
HET    MSE  A   1       8                                                       
HET    MSE  A  32       8                                                       
HET    MSE  A  38       8                                                       
HET    MSE  A  59       8                                                       
HET    MSE  A 113      16                                                       
HET    MSE  A 117       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  32       8                                                       
HET    MSE  B  38       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B 113       8                                                       
HET    MSE  B 117       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  32       8                                                       
HET    MSE  C  38       8                                                       
HET    MSE  C  59       8                                                       
HET    MSE  C 113       8                                                       
HET    MSE  C 117       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  32       8                                                       
HET    MSE  D  38       8                                                       
HET    MSE  D  59       8                                                       
HET    MSE  D 113       8                                                       
HET    MSE  D 117       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E  32       8                                                       
HET    MSE  E  38       8                                                       
HET    MSE  E  59       8                                                       
HET    MSE  E 113       8                                                       
HET    MSE  E 117       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  F  32       8                                                       
HET    MSE  F  38       8                                                       
HET    MSE  F  59       8                                                       
HET    MSE  F 113       8                                                       
HET    MSE  F 117       8                                                       
HET    MSE  G   1       8                                                       
HET    MSE  G  32       8                                                       
HET    MSE  G  38       8                                                       
HET    MSE  G  59       8                                                       
HET    MSE  G 113       8                                                       
HET    MSE  G 117       8                                                       
HET    MSE  H   1       8                                                       
HET    MSE  H  32       8                                                       
HET    MSE  H  38       8                                                       
HET    MSE  H  59       8                                                       
HET    MSE  H 113       8                                                       
HET    MSE  H 117       8                                                       
HET     ZN    601       1                                                       
HET     ZN    602       1                                                       
HET     ZN    603       1                                                       
HET     ZN    604       1                                                       
HET     ZN    605       1                                                       
HET    EDO    608       4                                                       
HET    EDO    609       4                                                       
HET    EDO    610       4                                                       
HET    EDO    611       4                                                       
HET    EDO    612       4                                                       
HET    EDO    613       4                                                       
HET    EDO    614       4                                                       
HET    ACY    606       4                                                       
HET    ACY    607       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     ACY ACETIC ACID                                                      
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    48(C5 H11 N O2 SE)                                           
FORMUL   9   ZN    5(ZN 2+)                                                     
FORMUL  14  EDO    7(C2 H6 O2)                                                  
FORMUL  21  ACY    2(C2 H4 O2)                                                  
FORMUL  23  HOH   *587(H2 O)                                                    
CRYST1   64.053  134.388   70.467  90.00 105.93  90.00 P 1 21 1     16          
ATOM   3625  N   ALA D   0      -7.830 -22.364  52.320  1.00 45.83           N  
ATOM   3626  CA  ALA D   0      -8.379 -21.342  53.269  1.00 45.88           C  
ATOM   3627  C   ALA D   0      -7.262 -20.664  54.087  1.00 45.74           C  
ATOM   3628  O   ALA D   0      -7.471 -20.223  55.231  1.00 46.43           O  
ATOM   3629  CB  ALA D   0      -9.488 -21.949  54.176  1.00 45.42           C  
HETATM 3630  N   MSE D   1      -6.075 -20.636  53.484  1.00 45.01           N  
HETATM 3631  CA  MSE D   1      -5.013 -19.678  53.781  1.00 44.91           C  
HETATM 3632  C   MSE D   1      -3.972 -19.889  52.694  1.00 43.65           C  
HETATM 3633  O   MSE D   1      -3.290 -20.923  52.694  1.00 44.71           O  
HETATM 3634  CB  MSE D   1      -4.408 -19.857  55.184  1.00 45.57           C  
HETATM 3635  CG  MSE D   1      -3.887 -18.558  55.837  1.00 48.02           C  
HETATM 3636 SE   MSE D   1      -2.105 -17.974  55.264  1.00 61.30          SE  
HETATM 3637  CE  MSE D   1      -0.994 -19.026  56.503  1.00 55.54           C  
ATOM   3638  N   GLU D   2      -3.880 -18.941  51.755  1.00 41.44           N  
ATOM   3639  CA  GLU D   2      -2.884 -18.950  50.664  1.00 39.84           C  
ATOM   3640  C   GLU D   2      -1.935 -17.724  50.729  1.00 37.14           C  
ATOM   3641  O   GLU D   2      -2.361 -16.622  51.024  1.00 36.87           O  
ATOM   3642  CB  GLU D   2      -3.606 -18.981  49.290  1.00 39.53           C  
ATOM   3643  CG  GLU D   2      -2.683 -18.883  48.041  1.00 41.67           C  
ATOM   3644  CD  GLU D   2      -3.390 -18.607  46.686  1.00 42.84           C  
ATOM   3645  OE1 GLU D   2      -4.637 -18.793  46.573  1.00 45.99           O  
ATOM   3646  OE2 GLU D   2      -2.668 -18.206  45.719  1.00 43.39           O  
ATOM   3647  N   ILE D   3      -0.658 -17.912  50.419  1.00 35.70           N  
ATOM   3648  CA  ILE D   3       0.277 -16.771  50.310  1.00 32.52           C  
ATOM   3649  C   ILE D   3       0.695 -16.643  48.869  1.00 31.90           C  
ATOM   3650  O   ILE D   3       1.186 -17.581  48.283  1.00 31.62           O  
ATOM   3651  CB  ILE D   3       1.516 -16.902  51.193  1.00 32.22           C  
ATOM   3652  CG1 ILE D   3       1.148 -16.744  52.663  1.00 30.58           C  
ATOM   3653  CG2 ILE D   3       2.582 -15.824  50.798  1.00 30.20           C  
ATOM   3654  CD1 ILE D   3       2.218 -17.279  53.635  1.00 28.48           C  
ATOM   3655  N   ARG D   4       0.484 -15.473  48.294  1.00 31.64           N  
ATOM   3656  CA  ARG D   4       0.813 -15.219  46.894  1.00 31.42           C  
ATOM   3657  C   ARG D   4       1.375 -13.819  46.684  1.00 30.36           C  
ATOM   3658  O   ARG D   4       1.321 -12.981  47.570  1.00 31.04           O  
ATOM   3659  CB  ARG D   4      -0.452 -15.368  46.067  1.00 32.26           C  
ATOM   3660  CG  ARG D   4      -1.619 -14.550  46.591  1.00 34.56           C  
ATOM   3661  CD  ARG D   4      -2.598 -14.412  45.480  1.00 35.52           C  
ATOM   3662  NE  ARG D   4      -3.761 -13.621  45.856  1.00 36.36           N  
ATOM   3663  CZ  ARG D   4      -3.844 -12.303  45.726  1.00 34.87           C  
ATOM   3664  NH1 ARG D   4      -2.813 -11.596  45.253  1.00 31.76           N  
ATOM   3665  NH2 ARG D   4      -4.959 -11.694  46.081  1.00 32.26           N  
ATOM   3666  N   VAL D   5       1.863 -13.547  45.498  1.00 28.82           N  
ATOM   3667  CA  VAL D   5       2.338 -12.191  45.180  1.00 28.75           C  
ATOM   3668  C   VAL D   5       1.163 -11.189  45.077  1.00 29.27           C  
ATOM   3669  O   VAL D   5       0.048 -11.578  44.695  1.00 28.80           O  
ATOM   3670  CB  VAL D   5       3.234 -12.205  43.954  1.00 28.73           C  
ATOM   3671  CG1 VAL D   5       3.675 -10.783  43.539  1.00 27.37           C  
ATOM   3672  CG2 VAL D   5       4.458 -13.115  44.233  1.00 27.13           C  
ATOM   3673  N   PHE D   6       1.403  -9.965  45.552  1.00 29.47           N  
ATOM   3674  CA  PHE D   6       0.452  -8.841  45.507  1.00 30.02           C  
ATOM   3675  C   PHE D   6       0.047  -8.634  44.050  1.00 31.37           C  
ATOM   3676  O   PHE D   6       0.908  -8.615  43.186  1.00 31.79           O  
ATOM   3677  CB  PHE D   6       1.128  -7.567  46.030  1.00 29.16           C  
ATOM   3678  CG  PHE D   6       0.394  -6.275  45.683  1.00 28.54           C  
ATOM   3679  CD1 PHE D   6      -0.586  -5.767  46.517  1.00 27.56           C  
ATOM   3680  CD2 PHE D   6       0.696  -5.575  44.538  1.00 29.56           C  
ATOM   3681  CE1 PHE D   6      -1.259  -4.584  46.202  1.00 28.69           C  
ATOM   3682  CE2 PHE D   6       0.035  -4.406  44.222  1.00 29.72           C  
ATOM   3683  CZ  PHE D   6      -0.945  -3.914  45.067  1.00 29.45           C  
ATOM   3684  N   ARG D   7      -1.235  -8.440  43.771  1.00 31.54           N  
ATOM   3685  CA  ARG D   7      -1.571  -7.919  42.448  1.00 33.09           C  
ATOM   3686  C   ARG D   7      -2.357  -6.640  42.495  1.00 33.79           C  
ATOM   3687  O   ARG D   7      -2.919  -6.268  43.531  1.00 32.70           O  
ATOM   3688  CB  ARG D   7      -2.266  -8.951  41.570  1.00 33.26           C  
ATOM   3689  CG  ARG D   7      -3.393  -9.628  42.207  1.00 36.94           C  
ATOM   3690  CD  ARG D   7      -4.019 -10.644  41.244  1.00 43.74           C  
ATOM   3691  NE  ARG D   7      -3.427 -11.971  41.389  1.00 46.59           N  
ATOM   3692  CZ  ARG D   7      -4.050 -13.022  41.924  1.00 46.83           C  
ATOM   3693  NH1 ARG D   7      -5.300 -12.927  42.373  1.00 45.28           N  
ATOM   3694  NH2 ARG D   7      -3.408 -14.176  41.999  1.00 46.89           N  
ATOM   3695  N   GLN D   8      -2.380  -5.955  41.365  1.00 34.58           N  
ATOM   3696  CA  GLN D   8      -3.053  -4.686  41.256  1.00 35.96           C  
ATOM   3697  C   GLN D   8      -4.400  -4.680  41.963  1.00 35.38           C  
ATOM   3698  O   GLN D   8      -4.694  -3.741  42.676  1.00 35.58           O  
ATOM   3699  CB  GLN D   8      -3.231  -4.310  39.784  1.00 36.54           C  
ATOM   3700  CG  GLN D   8      -2.986  -2.846  39.526  1.00 40.10           C  
ATOM   3701  CD  GLN D   8      -3.917  -2.261  38.463  1.00 41.93           C  
ATOM   3702  OE1 GLN D   8      -4.039  -2.779  37.362  1.00 45.09           O  
ATOM   3703  NE2 GLN D   8      -4.570  -1.183  38.805  1.00 41.63           N  
ATOM   3704  N   GLU D   9      -5.194  -5.734  41.796  1.00 34.89           N  
ATOM   3705  CA  GLU D   9      -6.545  -5.756  42.317  1.00 35.16           C  
ATOM   3706  C   GLU D   9      -6.638  -5.817  43.834  1.00 33.09           C  
ATOM   3707  O   GLU D   9      -7.731  -5.729  44.384  1.00 32.08           O  
ATOM   3708  CB  GLU D   9      -7.400  -6.879  41.677  1.00 35.17           C  
ATOM   3709  CG  GLU D   9      -8.184  -6.420  40.362  1.00 39.10           C  
ATOM   3710  CD  GLU D   9      -9.597  -7.076  40.156  1.00 39.72           C  
ATOM   3711  OE1 GLU D   9     -10.340  -7.333  41.154  1.00 46.63           O  
ATOM   3712  OE2 GLU D   9      -9.991  -7.306  38.972  1.00 43.97           O  
ATOM   3713  N   ASP D  10      -5.508  -6.012  44.498  1.00 31.23           N  
ATOM   3714  CA  ASP D  10      -5.473  -6.066  45.954  1.00 29.98           C  
ATOM   3715  C   ASP D  10      -5.276  -4.660  46.539  1.00 29.79           C  
ATOM   3716  O   ASP D  10      -5.297  -4.507  47.734  1.00 29.72           O  
ATOM   3717  CB  ASP D  10      -4.318  -6.945  46.463  1.00 29.06           C  
ATOM   3718  CG  ASP D  10      -4.306  -8.354  45.882  1.00 30.07           C  
ATOM   3719  OD1 ASP D  10      -5.391  -8.999  45.671  1.00 30.23           O  
ATOM   3720  OD2 ASP D  10      -3.180  -8.850  45.702  1.00 27.43           O  
ATOM   3721  N   PHE D  11      -5.031  -3.654  45.698  1.00 29.42           N  
ATOM   3722  CA  PHE D  11      -4.587  -2.322  46.161  1.00 29.49           C  
ATOM   3723  C   PHE D  11      -5.456  -1.738  47.310  1.00 29.29           C  
ATOM   3724  O   PHE D  11      -4.943  -1.481  48.402  1.00 29.53           O  
ATOM   3725  CB  PHE D  11      -4.482  -1.367  44.965  1.00 29.02           C  
ATOM   3726  CG  PHE D  11      -3.776  -0.052  45.255  1.00 29.13           C  
ATOM   3727  CD1 PHE D  11      -2.463   0.147  44.889  1.00 27.08           C  
ATOM   3728  CD2 PHE D  11      -4.467   1.013  45.807  1.00 31.31           C  
ATOM   3729  CE1 PHE D  11      -1.841   1.343  45.137  1.00 27.98           C  
ATOM   3730  CE2 PHE D  11      -3.848   2.219  46.040  1.00 29.64           C  
ATOM   3731  CZ  PHE D  11      -2.522   2.373  45.711  1.00 30.12           C  
ATOM   3732  N   GLU D  12      -6.740  -1.553  47.056  0.50 28.67           N  
ATOM   3734  CA  GLU D  12      -7.670  -0.990  48.042  0.50 28.57           C  
ATOM   3736  C   GLU D  12      -7.731  -1.802  49.354  0.50 28.40           C  
ATOM   3738  O   GLU D  12      -7.812  -1.227  50.444  0.50 28.52           O  
ATOM   3740  CB  GLU D  12      -9.062  -0.873  47.412  0.50 28.73           C  
ATOM   3742  CG  GLU D  12      -9.100  -0.095  46.080  0.50 28.54           C  
ATOM   3744  CD  GLU D  12      -8.566  -0.885  44.868  0.50 29.99           C  
ATOM   3746  OE1 GLU D  12      -8.425  -2.125  44.931  0.50 25.61           O  
ATOM   3748  OE2 GLU D  12      -8.285  -0.247  43.824  0.50 33.09           O  
ATOM   3750  N   GLU D  13      -7.672  -3.129  49.237  1.00 27.89           N  
ATOM   3751  CA  GLU D  13      -7.753  -4.056  50.390  1.00 28.44           C  
ATOM   3752  C   GLU D  13      -6.462  -4.083  51.216  1.00 26.93           C  
ATOM   3753  O   GLU D  13      -6.480  -4.247  52.429  1.00 27.88           O  
ATOM   3754  CB  GLU D  13      -8.051  -5.481  49.885  1.00 27.88           C  
ATOM   3755  CG  GLU D  13      -9.464  -5.678  49.298  1.00 31.76           C  
ATOM   3756  CD  GLU D  13      -9.564  -5.279  47.831  1.00 35.71           C  
ATOM   3757  OE1 GLU D  13      -8.569  -4.770  47.237  1.00 33.16           O  
ATOM   3758  OE2 GLU D  13     -10.657  -5.460  47.266  1.00 39.94           O  
ATOM   3759  N   VAL D  14      -5.326  -3.938  50.557  1.00 25.56           N  
ATOM   3760  CA  VAL D  14      -4.049  -3.883  51.296  1.00 24.78           C  
ATOM   3761  C   VAL D  14      -4.059  -2.629  52.213  1.00 25.43           C  
ATOM   3762  O   VAL D  14      -3.734  -2.682  53.398  1.00 25.43           O  
ATOM   3763  CB  VAL D  14      -2.904  -3.872  50.300  1.00 25.27           C  
ATOM   3764  CG1 VAL D  14      -1.599  -3.309  50.904  1.00 21.72           C  
ATOM   3765  CG2 VAL D  14      -2.707  -5.269  49.781  1.00 23.42           C  
ATOM   3766  N   ILE D  15      -4.490  -1.510  51.647  1.00 25.18           N  
ATOM   3767  CA  ILE D  15      -4.509  -0.228  52.364  1.00 25.64           C  
ATOM   3768  C   ILE D  15      -5.506  -0.272  53.525  1.00 24.54           C  
ATOM   3769  O   ILE D  15      -5.169   0.131  54.635  1.00 25.22           O  
ATOM   3770  CB  ILE D  15      -4.750   0.964  51.403  1.00 26.09           C  
ATOM   3771  CG1 ILE D  15      -3.436   1.264  50.678  1.00 26.85           C  
ATOM   3772  CG2 ILE D  15      -5.135   2.222  52.209  1.00 27.17           C  
ATOM   3773  CD1 ILE D  15      -3.610   1.897  49.368  1.00 28.40           C  
ATOM   3774  N   THR D  16      -6.708  -0.791  53.283  1.00 23.65           N  
ATOM   3775  CA  THR D  16      -7.665  -1.022  54.353  1.00 23.43           C  
ATOM   3776  C   THR D  16      -6.991  -1.821  55.473  1.00 23.41           C  
ATOM   3777  O   THR D  16      -7.089  -1.464  56.658  1.00 23.46           O  
ATOM   3778  CB  THR D  16      -8.882  -1.744  53.814  1.00 23.74           C  
ATOM   3779  OG1 THR D  16      -9.462  -0.946  52.771  1.00 27.22           O  
ATOM   3780  CG2 THR D  16      -9.927  -1.943  54.932  1.00 23.83           C  
ATOM   3781  N   LEU D  17      -6.284  -2.877  55.086  1.00 22.38           N  
ATOM   3782  CA  LEU D  17      -5.549  -3.715  56.021  1.00 22.73           C  
ATOM   3783  C   LEU D  17      -4.497  -2.955  56.815  1.00 23.84           C  
ATOM   3784  O   LEU D  17      -4.367  -3.138  58.028  1.00 26.32           O  
ATOM   3785  CB  LEU D  17      -4.900  -4.922  55.306  1.00 22.34           C  
ATOM   3786  CG  LEU D  17      -4.064  -5.834  56.214  1.00 20.47           C  
ATOM   3787  CD1 LEU D  17      -5.023  -6.584  57.113  1.00 22.94           C  
ATOM   3788  CD2 LEU D  17      -3.229  -6.789  55.402  1.00 22.56           C  
ATOM   3789  N   TRP D  18      -3.697  -2.170  56.125  1.00 24.33           N  
ATOM   3790  CA  TRP D  18      -2.725  -1.300  56.791  1.00 23.65           C  
ATOM   3791  C   TRP D  18      -3.365  -0.342  57.803  1.00 23.11           C  
ATOM   3792  O   TRP D  18      -2.824  -0.177  58.927  1.00 23.75           O  
ATOM   3793  CB  TRP D  18      -1.879  -0.592  55.765  1.00 22.68           C  
ATOM   3794  CG  TRP D  18      -0.958  -1.568  55.035  1.00 24.62           C  
ATOM   3795  CD1 TRP D  18      -0.715  -2.877  55.364  1.00 22.02           C  
ATOM   3796  CD2 TRP D  18      -0.133  -1.274  53.895  1.00 24.37           C  
ATOM   3797  NE1 TRP D  18       0.166  -3.425  54.474  1.00 28.30           N  
ATOM   3798  CE2 TRP D  18       0.548  -2.473  53.558  1.00 26.24           C  
ATOM   3799  CE3 TRP D  18       0.059  -0.125  53.090  1.00 22.97           C  
ATOM   3800  CZ2 TRP D  18       1.440  -2.554  52.471  1.00 25.50           C  
ATOM   3801  CZ3 TRP D  18       0.976  -0.187  52.037  1.00 24.01           C  
ATOM   3802  CH2 TRP D  18       1.639  -1.394  51.721  1.00 23.10           C  
ATOM   3803  N   GLU D  19      -4.511   0.212  57.420  0.50 22.69           N  
ATOM   3805  CA  GLU D  19      -5.272   1.133  58.242  0.50 22.22           C  
ATOM   3807  C   GLU D  19      -5.794   0.460  59.519  0.50 22.71           C  
ATOM   3809  O   GLU D  19      -5.768   1.064  60.593  0.50 22.18           O  
ATOM   3811  CB  GLU D  19      -6.402   1.779  57.419  0.50 22.48           C  
ATOM   3813  CG  GLU D  19      -5.858   2.604  56.237  0.50 21.02           C  
ATOM   3815  CD  GLU D  19      -6.865   3.475  55.535  0.50 21.52           C  
ATOM   3817  OE1 GLU D  19      -6.448   4.556  55.084  0.50 21.31           O  
ATOM   3819  OE2 GLU D  19      -8.055   3.111  55.441  0.50 19.40           O  
ATOM   3821  N   ARG D  20      -6.213  -0.795  59.401  1.00 22.63           N  
ATOM   3822  CA  ARG D  20      -6.735  -1.579  60.542  1.00 23.49           C  
ATOM   3823  C   ARG D  20      -5.620  -2.079  61.469  1.00 24.23           C  
ATOM   3824  O   ARG D  20      -5.794  -2.031  62.700  1.00 23.38           O  
ATOM   3825  CB  ARG D  20      -7.672  -2.705  60.086  1.00 23.63           C  
ATOM   3826  CG  ARG D  20      -8.274  -3.577  61.227  1.00 24.19           C  
ATOM   3827  CD  ARG D  20      -9.159  -2.819  62.201  1.00 24.20           C  
ATOM   3828  NE  ARG D  20      -9.758  -3.677  63.242  1.00 24.45           N  
ATOM   3829  CZ  ARG D  20     -10.846  -4.419  63.043  1.00 28.50           C  
ATOM   3830  NH1 ARG D  20     -11.442  -4.407  61.853  1.00 30.59           N  
ATOM   3831  NH2 ARG D  20     -11.363  -5.163  64.022  1.00 27.16           N  
ATOM   3832  N   CYS D  21      -4.474  -2.445  60.857  1.00 25.53           N  
ATOM   3833  CA  CYS D  21      -3.234  -2.933  61.520  1.00 27.36           C  
ATOM   3834  C   CYS D  21      -2.335  -1.819  62.037  1.00 27.98           C  
ATOM   3835  O   CYS D  21      -1.327  -2.082  62.724  1.00 27.49           O  
ATOM   3836  CB  CYS D  21      -2.389  -3.817  60.578  1.00 27.43           C  
ATOM   3837  SG  CYS D  21      -3.195  -5.372  60.153  1.00 30.62           S  
ATOM   3838  N   ASP D  22      -2.707  -0.584  61.707  1.00 27.60           N  
ATOM   3839  CA  ASP D  22      -1.966   0.604  62.129  1.00 28.46           C  
ATOM   3840  C   ASP D  22      -0.482   0.629  61.695  1.00 28.33           C  
ATOM   3841  O   ASP D  22       0.381   1.000  62.482  1.00 27.66           O  
ATOM   3842  CB  ASP D  22      -2.113   0.851  63.639  1.00 26.91           C  
ATOM   3843  CG  ASP D  22      -3.531   0.994  64.047  1.00 27.96           C  
ATOM   3844  OD1 ASP D  22      -4.286   1.756  63.382  1.00 25.84           O  
ATOM   3845  OD2 ASP D  22      -3.907   0.327  65.024  1.00 26.89           O  
ATOM   3846  N   LEU D  23      -0.219   0.271  60.432  1.00 29.13           N  
ATOM   3847  CA  LEU D  23       1.142   0.252  59.882  1.00 30.03           C  
ATOM   3848  C   LEU D  23       1.479   1.604  59.279  1.00 30.78           C  
ATOM   3849  O   LEU D  23       2.633   1.915  59.001  1.00 31.73           O  
ATOM   3850  CB  LEU D  23       1.281  -0.861  58.819  1.00 29.71           C  
ATOM   3851  CG  LEU D  23       1.071  -2.234  59.435  1.00 30.55           C  
ATOM   3852  CD1 LEU D  23       1.087  -3.352  58.430  1.00 32.91           C  
ATOM   3853  CD2 LEU D  23       2.108  -2.459  60.524  1.00 34.44           C  
ATOM   3854  N   LEU D  24       0.448   2.406  59.063  1.00 31.55           N  
ATOM   3855  CA  LEU D  24       0.630   3.696  58.461  1.00 32.94           C  
ATOM   3856  C   LEU D  24       1.454   4.655  59.326  1.00 34.49           C  
ATOM   3857  O   LEU D  24       1.143   4.869  60.508  1.00 34.85           O  
ATOM   3858  CB  LEU D  24      -0.718   4.295  58.117  1.00 31.64           C  
ATOM   3859  CG  LEU D  24      -1.619   3.486  57.194  1.00 30.71           C  
ATOM   3860  CD1 LEU D  24      -2.722   4.383  56.683  1.00 27.05           C  
ATOM   3861  CD2 LEU D  24      -0.858   2.872  56.032  1.00 28.62           C  
ATOM   3862  N   ARG D  25       2.506   5.206  58.719  0.50 35.57           N  
ATOM   3864  CA  ARG D  25       3.359   6.234  59.320  0.50 36.39           C  
ATOM   3866  C   ARG D  25       3.126   7.542  58.570  0.50 37.11           C  
ATOM   3868  O   ARG D  25       3.011   7.532  57.338  0.50 37.06           O  
ATOM   3870  CB  ARG D  25       4.831   5.843  59.209  0.50 36.58           C  
ATOM   3872  CG  ARG D  25       5.199   4.448  59.728  0.50 37.11           C  
ATOM   3874  CD  ARG D  25       5.358   4.427  61.242  0.50 37.99           C  
ATOM   3876  NE  ARG D  25       4.074   4.184  61.892  0.50 39.20           N  
ATOM   3878  CZ  ARG D  25       3.646   2.982  62.255  0.50 38.67           C  
ATOM   3880  NH1 ARG D  25       4.410   1.915  62.053  0.50 39.63           N  
ATOM   3882  NH2 ARG D  25       2.460   2.851  62.820  0.50 38.51           N  
ATOM   3884  N   PRO D  26       3.064   8.677  59.301  1.00 37.74           N  
ATOM   3885  CA  PRO D  26       2.648   9.974  58.688  1.00 38.55           C  
ATOM   3886  C   PRO D  26       3.442  10.553  57.476  1.00 39.19           C  
ATOM   3887  O   PRO D  26       2.819  11.192  56.607  1.00 40.24           O  
ATOM   3888  CB  PRO D  26       2.626  10.968  59.884  1.00 38.82           C  
ATOM   3889  CG  PRO D  26       3.489  10.320  60.955  1.00 38.51           C  
ATOM   3890  CD  PRO D  26       3.377   8.814  60.748  1.00 38.14           C  
ATOM   3891  N   TRP D  27       4.761  10.356  57.414  1.00 38.08           N  
ATOM   3892  CA  TRP D  27       5.560  10.879  56.289  1.00 37.53           C  
ATOM   3893  C   TRP D  27       5.783   9.776  55.242  1.00 36.03           C  
ATOM   3894  O   TRP D  27       6.640   9.913  54.389  1.00 36.27           O  
ATOM   3895  CB  TRP D  27       6.926  11.425  56.764  1.00 38.53           C  
ATOM   3896  CG  TRP D  27       6.908  12.780  57.535  1.00 39.80           C  
ATOM   3897  CD1 TRP D  27       7.198  12.981  58.866  1.00 39.49           C  
ATOM   3898  CD2 TRP D  27       6.607  14.083  56.997  1.00 39.01           C  
ATOM   3899  NE1 TRP D  27       7.079  14.307  59.183  1.00 39.93           N  
ATOM   3900  CE2 TRP D  27       6.721  15.009  58.062  1.00 39.86           C  
ATOM   3901  CE3 TRP D  27       6.238  14.552  55.722  1.00 39.20           C  
ATOM   3902  CZ2 TRP D  27       6.484  16.376  57.898  1.00 39.90           C  
ATOM   3903  CZ3 TRP D  27       6.009  15.906  55.554  1.00 39.37           C  
ATOM   3904  CH2 TRP D  27       6.131  16.810  56.639  1.00 40.59           C  
ATOM   3905  N   ASN D  28       5.024   8.683  55.348  1.00 34.03           N  
ATOM   3906  CA  ASN D  28       5.044   7.538  54.419  1.00 32.72           C  
ATOM   3907  C   ASN D  28       3.684   7.339  53.744  1.00 31.12           C  
ATOM   3908  O   ASN D  28       2.755   6.816  54.370  1.00 31.40           O  
ATOM   3909  CB  ASN D  28       5.398   6.243  55.170  1.00 32.86           C  
ATOM   3910  CG  ASN D  28       6.900   5.926  55.154  1.00 35.85           C  
ATOM   3911  OD1 ASN D  28       7.712   6.654  54.581  1.00 36.65           O  
ATOM   3912  ND2 ASN D  28       7.262   4.802  55.774  1.00 41.77           N  
ATOM   3913  N   ASP D  29       3.558   7.748  52.476  1.00 30.29           N  
ATOM   3914  CA  ASP D  29       2.277   7.654  51.769  1.00 28.52           C  
ATOM   3915  C   ASP D  29       2.119   6.215  51.293  1.00 28.51           C  
ATOM   3916  O   ASP D  29       2.875   5.760  50.448  1.00 27.68           O  
ATOM   3917  CB  ASP D  29       2.204   8.652  50.606  1.00 28.69           C  
ATOM   3918  CG  ASP D  29       0.887   8.562  49.812  1.00 29.38           C  
ATOM   3919  OD1 ASP D  29       0.149   7.556  49.869  1.00 34.80           O  
ATOM   3920  OD2 ASP D  29       0.555   9.517  49.116  1.00 30.96           O  
ATOM   3921  N   PRO D  30       1.122   5.497  51.844  1.00 27.79           N  
ATOM   3922  CA  PRO D  30       0.970   4.066  51.581  1.00 28.21           C  
ATOM   3923  C   PRO D  30       0.569   3.793  50.123  1.00 28.11           C  
ATOM   3924  O   PRO D  30       1.015   2.811  49.514  1.00 28.14           O  
ATOM   3925  CB  PRO D  30      -0.152   3.649  52.557  1.00 28.51           C  
ATOM   3926  CG  PRO D  30      -0.901   4.932  52.854  1.00 28.16           C  
ATOM   3927  CD  PRO D  30       0.080   6.028  52.744  1.00 27.62           C  
ATOM   3928  N   GLU D  31      -0.272   4.647  49.559  1.00 28.91           N  
ATOM   3929  CA  GLU D  31      -0.591   4.537  48.148  1.00 29.25           C  
ATOM   3930  C   GLU D  31       0.690   4.696  47.333  1.00 28.71           C  
ATOM   3931  O   GLU D  31       0.926   3.949  46.391  1.00 27.89           O  
ATOM   3932  CB  GLU D  31      -1.608   5.587  47.748  1.00 29.74           C  
ATOM   3933  CG  GLU D  31      -2.820   5.578  48.618  1.00 31.33           C  
ATOM   3934  CD  GLU D  31      -3.987   6.282  48.005  1.00 35.72           C  
ATOM   3935  OE1 GLU D  31      -3.820   7.086  47.034  1.00 34.82           O  
ATOM   3936  OE2 GLU D  31      -5.107   6.002  48.510  1.00 39.61           O  
HETATM 3937  N   MSE D  32       1.530   5.639  47.728  1.00 28.52           N  
HETATM 3938  CA  MSE D  32       2.787   5.863  47.052  1.00 29.67           C  
HETATM 3939  C   MSE D  32       3.771   4.684  47.233  1.00 30.15           C  
HETATM 3940  O   MSE D  32       4.485   4.310  46.283  1.00 29.56           O  
HETATM 3941  CB  MSE D  32       3.418   7.127  47.593  1.00 30.27           C  
HETATM 3942  CG  MSE D  32       4.590   7.565  46.804  1.00 35.24           C  
HETATM 3943 SE   MSE D  32       3.825   8.498  45.313  1.00 52.11          SE  
HETATM 3944  CE  MSE D  32       3.524  10.186  46.209  1.00 40.02           C  
ATOM   3945  N   ASP D  33       3.799   4.104  48.442  1.00 29.33           N  
ATOM   3946  CA  ASP D  33       4.714   2.983  48.740  1.00 29.12           C  
ATOM   3947  C   ASP D  33       4.321   1.762  47.928  1.00 28.95           C  
ATOM   3948  O   ASP D  33       5.181   0.979  47.474  1.00 29.42           O  
ATOM   3949  CB  ASP D  33       4.726   2.634  50.245  1.00 27.91           C  
ATOM   3950  CG  ASP D  33       5.429   3.716  51.111  1.00 28.50           C  
ATOM   3951  OD1 ASP D  33       6.256   4.442  50.560  1.00 29.68           O  
ATOM   3952  OD2 ASP D  33       5.171   3.819  52.345  1.00 29.93           O  
ATOM   3953  N   ILE D  34       3.023   1.574  47.757  1.00 28.32           N  
ATOM   3954  CA  ILE D  34       2.563   0.500  46.866  1.00 27.44           C  
ATOM   3955  C   ILE D  34       2.957   0.665  45.385  1.00 26.80           C  
ATOM   3956  O   ILE D  34       3.479  -0.282  44.769  1.00 25.61           O  
ATOM   3957  CB  ILE D  34       1.037   0.142  47.043  1.00 26.99           C  
ATOM   3958  CG1 ILE D  34       0.786  -0.448  48.432  1.00 24.68           C  
ATOM   3959  CG2 ILE D  34       0.631  -0.859  45.948  1.00 25.46           C  
ATOM   3960  CD1 ILE D  34      -0.689  -0.584  48.905  1.00 27.39           C  
ATOM   3961  N   GLU D  35       2.671   1.840  44.825  1.00 27.42           N  
ATOM   3962  CA  GLU D  35       3.103   2.258  43.486  1.00 27.69           C  
ATOM   3963  C   GLU D  35       4.611   2.137  43.241  1.00 27.76           C  
ATOM   3964  O   GLU D  35       5.054   1.667  42.178  1.00 26.89           O  
ATOM   3965  CB  GLU D  35       2.631   3.689  43.190  1.00 27.48           C  
ATOM   3966  CG  GLU D  35       1.106   3.890  43.277  1.00 26.15           C  
ATOM   3967  CD  GLU D  35       0.337   3.174  42.164  1.00 26.09           C  
ATOM   3968  OE1 GLU D  35       0.976   2.610  41.230  1.00 24.10           O  
ATOM   3969  OE2 GLU D  35      -0.920   3.147  42.223  1.00 27.98           O  
ATOM   3970  N   ARG D  36       5.390   2.560  44.223  1.00 28.51           N  
ATOM   3971  CA  ARG D  36       6.845   2.404  44.176  1.00 28.65           C  
ATOM   3972  C   ARG D  36       7.171   0.947  44.033  1.00 28.74           C  
ATOM   3973  O   ARG D  36       7.948   0.557  43.190  1.00 28.80           O  
ATOM   3974  CB  ARG D  36       7.487   2.927  45.472  1.00 29.53           C  
ATOM   3975  CG  ARG D  36       7.893   4.413  45.465  1.00 28.59           C  
ATOM   3976  CD  ARG D  36       7.740   4.981  46.919  1.00 28.74           C  
ATOM   3977  NE  ARG D  36       7.910   6.411  46.908  1.00 30.30           N  
ATOM   3978  CZ  ARG D  36       7.443   7.249  47.832  1.00 31.84           C  
ATOM   3979  NH1 ARG D  36       6.723   6.818  48.869  1.00 29.09           N  
ATOM   3980  NH2 ARG D  36       7.658   8.547  47.678  1.00 31.07           N  
ATOM   3981  N   LYS D  37       6.508   0.106  44.810  1.00 29.97           N  
ATOM   3982  CA  LYS D  37       6.887  -1.292  44.834  1.00 29.68           C  
ATOM   3983  C   LYS D  37       6.445  -1.939  43.537  1.00 30.50           C  
ATOM   3984  O   LYS D  37       7.125  -2.817  43.009  1.00 30.95           O  
ATOM   3985  CB  LYS D  37       6.283  -1.998  46.046  1.00 30.70           C  
ATOM   3986  CG  LYS D  37       6.746  -3.444  46.221  1.00 28.77           C  
ATOM   3987  CD  LYS D  37       8.280  -3.455  46.473  1.00 28.86           C  
ATOM   3988  CE  LYS D  37       8.799  -4.846  46.887  1.00 31.40           C  
ATOM   3989  NZ  LYS D  37      10.320  -4.834  46.853  1.00 33.32           N  
HETATM 3990  N   MSE D  38       5.296  -1.489  43.037  1.00 30.66           N  
HETATM 3991  CA  MSE D  38       4.741  -1.924  41.793  1.00 32.82           C  
HETATM 3992  C   MSE D  38       5.633  -1.600  40.633  1.00 31.71           C  
HETATM 3993  O   MSE D  38       5.775  -2.412  39.725  1.00 33.48           O  
HETATM 3994  CB  MSE D  38       3.380  -1.292  41.572  1.00 31.99           C  
HETATM 3995  CG  MSE D  38       2.272  -2.140  42.137  1.00 34.39           C  
HETATM 3996 SE   MSE D  38       0.545  -1.234  42.092  0.95 39.51          SE  
HETATM 3997  CE  MSE D  38       0.911   0.325  43.093  1.00 42.87           C  
ATOM   3998  N   ASN D  39       6.225  -0.416  40.648  1.00 30.23           N  
ATOM   3999  CA  ASN D  39       7.059  -0.040  39.544  1.00 29.96           C  
ATOM   4000  C   ASN D  39       8.383  -0.783  39.593  1.00 29.38           C  
ATOM   4001  O   ASN D  39       8.984  -1.098  38.573  1.00 28.06           O  
ATOM   4002  CB  ASN D  39       7.256   1.451  39.564  1.00 29.44           C  
ATOM   4003  CG  ASN D  39       8.044   1.924  38.402  1.00 29.97           C  
ATOM   4004  OD1 ASN D  39       7.570   1.908  37.263  1.00 32.45           O  
ATOM   4005  ND2 ASN D  39       9.260   2.361  38.670  1.00 29.98           N  
ATOM   4006  N   HIS D  40       8.813  -1.077  40.812  1.00 29.72           N  
ATOM   4007  CA  HIS D  40      10.079  -1.723  41.051  1.00 30.84           C  
ATOM   4008  C   HIS D  40      10.070  -3.198  40.719  1.00 32.04           C  
ATOM   4009  O   HIS D  40      10.769  -3.619  39.791  1.00 33.10           O  
ATOM   4010  CB  HIS D  40      10.492  -1.549  42.498  1.00 30.35           C  
ATOM   4011  CG  HIS D  40      11.847  -2.098  42.780  1.00 32.12           C  
ATOM   4012  ND1 HIS D  40      12.995  -1.486  42.328  1.00 27.99           N  
ATOM   4013  CD2 HIS D  40      12.243  -3.193  43.464  1.00 32.34           C  
ATOM   4014  CE1 HIS D  40      14.045  -2.188  42.714  1.00 32.88           C  
ATOM   4015  NE2 HIS D  40      13.617  -3.236  43.390  1.00 33.62           N  
ATOM   4016  N   ASP D  41       9.246  -3.967  41.445  1.00 32.89           N  
ATOM   4017  CA  ASP D  41       9.251  -5.425  41.382  1.00 33.06           C  
ATOM   4018  C   ASP D  41       8.361  -5.884  42.511  1.00 32.08           C  
ATOM   4019  O   ASP D  41       8.706  -5.719  43.678  1.00 32.22           O  
ATOM   4020  CB  ASP D  41      10.713  -5.929  41.551  1.00 34.09           C  
ATOM   4021  CG  ASP D  41      10.863  -7.460  41.530  1.00 35.82           C  
ATOM   4022  OD1 ASP D  41       9.865  -8.232  41.425  1.00 38.02           O  
ATOM   4023  OD2 ASP D  41      12.044  -7.863  41.668  1.00 38.36           O  
ATOM   4024  N   VAL D  42       7.206  -6.449  42.175  1.00 30.47           N  
ATOM   4025  CA  VAL D  42       6.284  -6.900  43.223  1.00 31.65           C  
ATOM   4026  C   VAL D  42       6.447  -8.340  43.732  1.00 31.19           C  
ATOM   4027  O   VAL D  42       5.685  -8.744  44.605  1.00 31.45           O  
ATOM   4028  CB  VAL D  42       4.756  -6.655  42.868  1.00 31.32           C  
ATOM   4029  CG1 VAL D  42       4.359  -5.197  43.138  1.00 31.87           C  
ATOM   4030  CG2 VAL D  42       4.443  -7.049  41.453  1.00 31.66           C  
ATOM   4031  N   SER D  43       7.409  -9.091  43.170  1.00 31.35           N  
ATOM   4032  CA  SER D  43       7.579 -10.533  43.391  1.00 30.50           C  
ATOM   4033  C   SER D  43       7.840 -10.880  44.831  1.00 29.09           C  
ATOM   4034  O   SER D  43       7.555 -11.998  45.245  1.00 29.29           O  
ATOM   4035  CB  SER D  43       8.689 -11.146  42.487  1.00 31.20           C  
ATOM   4036  OG  SER D  43       9.991 -10.694  42.860  1.00 34.30           O  
ATOM   4037  N   LEU D  44       8.304  -9.920  45.621  1.00 28.71           N  
ATOM   4038  CA  LEU D  44       8.608 -10.159  47.058  1.00 28.17           C  
ATOM   4039  C   LEU D  44       7.595  -9.397  47.948  1.00 28.51           C  
ATOM   4040  O   LEU D  44       7.694  -9.397  49.187  1.00 30.18           O  
ATOM   4041  CB  LEU D  44      10.063  -9.760  47.388  1.00 28.01           C  
ATOM   4042  CG  LEU D  44      11.190 -10.499  46.676  1.00 28.27           C  
ATOM   4043  CD1 LEU D  44      12.614  -9.793  46.824  1.00 29.07           C  
ATOM   4044  CD2 LEU D  44      11.239 -11.955  47.109  1.00 26.50           C  
ATOM   4045  N   PHE D  45       6.630  -8.752  47.317  1.00 27.17           N  
ATOM   4046  CA  PHE D  45       5.504  -8.161  48.027  1.00 25.69           C  
ATOM   4047  C   PHE D  45       4.399  -9.247  48.154  1.00 25.49           C  
ATOM   4048  O   PHE D  45       3.711  -9.557  47.165  1.00 23.74           O  
ATOM   4049  CB  PHE D  45       5.011  -6.954  47.218  1.00 26.61           C  
ATOM   4050  CG  PHE D  45       3.971  -6.098  47.920  1.00 28.75           C  
ATOM   4051  CD1 PHE D  45       3.672  -6.269  49.256  1.00 27.96           C  
ATOM   4052  CD2 PHE D  45       3.335  -5.070  47.230  1.00 28.00           C  
ATOM   4053  CE1 PHE D  45       2.729  -5.451  49.888  1.00 30.31           C  
ATOM   4054  CE2 PHE D  45       2.380  -4.273  47.849  1.00 28.72           C  
ATOM   4055  CZ  PHE D  45       2.072  -4.466  49.171  1.00 29.60           C  
ATOM   4056  N   LEU D  46       4.212  -9.800  49.360  1.00 25.04           N  
ATOM   4057  CA  LEU D  46       3.370 -11.013  49.546  1.00 25.24           C  
ATOM   4058  C   LEU D  46       2.104 -10.665  50.245  1.00 26.31           C  
ATOM   4059  O   LEU D  46       2.115  -9.774  51.064  1.00 26.81           O  
ATOM   4060  CB  LEU D  46       4.145 -12.078  50.391  1.00 24.83           C  
ATOM   4061  CG  LEU D  46       5.547 -12.440  49.852  1.00 20.64           C  
ATOM   4062  CD1 LEU D  46       6.306 -13.590  50.477  1.00 20.15           C  
ATOM   4063  CD2 LEU D  46       5.391 -12.762  48.433  1.00 15.02           C  
ATOM   4064  N   VAL D  47       1.023 -11.418  49.992  1.00 27.28           N  
ATOM   4065  CA  VAL D  47      -0.210 -11.222  50.686  1.00 27.99           C  
ATOM   4066  C   VAL D  47      -0.716 -12.544  51.152  1.00 28.13           C  
ATOM   4067  O   VAL D  47      -0.479 -13.583  50.525  1.00 28.45           O  
ATOM   4068  CB  VAL D  47      -1.347 -10.466  49.841  1.00 28.73           C  
ATOM   4069  CG1 VAL D  47      -0.877  -9.087  49.379  1.00 28.31           C  
ATOM   4070  CG2 VAL D  47      -1.852 -11.287  48.667  1.00 27.85           C  
ATOM   4071  N   ALA D  48      -1.409 -12.508  52.266  1.00 28.70           N  
ATOM   4072  CA  ALA D  48      -2.029 -13.688  52.789  1.00 29.71           C  
ATOM   4073  C   ALA D  48      -3.516 -13.538  52.535  1.00 31.43           C  
ATOM   4074  O   ALA D  48      -4.143 -12.558  52.965  1.00 30.83           O  
ATOM   4075  CB  ALA D  48      -1.695 -13.845  54.264  1.00 29.02           C  
ATOM   4076  N   GLU D  49      -4.057 -14.495  51.777  1.00 33.55           N  
ATOM   4077  CA  GLU D  49      -5.453 -14.477  51.319  1.00 36.29           C  
ATOM   4078  C   GLU D  49      -6.249 -15.566  52.039  1.00 36.26           C  
ATOM   4079  O   GLU D  49      -5.817 -16.722  52.105  1.00 36.72           O  
ATOM   4080  CB  GLU D  49      -5.512 -14.707  49.800  1.00 35.74           C  
ATOM   4081  CG  GLU D  49      -6.554 -13.871  49.069  1.00 39.20           C  
ATOM   4082  CD  GLU D  49      -6.741 -14.230  47.585  1.00 40.95           C  
ATOM   4083  OE1 GLU D  49      -6.733 -15.433  47.222  1.00 45.90           O  
ATOM   4084  OE2 GLU D  49      -6.928 -13.288  46.774  1.00 45.65           O  
ATOM   4085  N   VAL D  50      -7.390 -15.206  52.605  1.00 36.98           N  
ATOM   4086  CA  VAL D  50      -8.291 -16.181  53.241  1.00 37.46           C  
ATOM   4087  C   VAL D  50      -9.725 -15.778  52.849  1.00 37.96           C  
ATOM   4088  O   VAL D  50     -10.036 -14.582  52.831  1.00 38.01           O  
ATOM   4089  CB  VAL D  50      -8.121 -16.188  54.788  1.00 37.58           C  
ATOM   4090  CG1 VAL D  50      -9.117 -17.113  55.462  1.00 37.51           C  
ATOM   4091  CG2 VAL D  50      -6.722 -16.609  55.201  1.00 37.88           C  
ATOM   4092  N   ASN D  51     -10.592 -16.733  52.502  0.50 38.13           N  
ATOM   4094  CA  ASN D  51     -11.964 -16.369  52.119  0.50 38.12           C  
ATOM   4096  C   ASN D  51     -11.911 -15.418  50.895  0.50 38.05           C  
ATOM   4098  O   ASN D  51     -12.793 -14.568  50.706  0.50 38.40           O  
ATOM   4100  CB  ASN D  51     -12.646 -15.706  53.335  0.50 38.11           C  
ATOM   4102  CG  ASN D  51     -14.122 -15.439  53.140  0.50 38.22           C  
ATOM   4104  OD1 ASN D  51     -14.528 -14.323  52.805  0.50 38.09           O  
ATOM   4106  ND2 ASN D  51     -14.937 -16.448  53.399  0.50 38.63           N  
ATOM   4108  N   GLY D  52     -10.864 -15.549  50.076  1.00 37.84           N  
ATOM   4109  CA  GLY D  52     -10.654 -14.623  48.978  1.00 37.09           C  
ATOM   4110  C   GLY D  52     -10.430 -13.182  49.410  1.00 36.60           C  
ATOM   4111  O   GLY D  52     -10.585 -12.275  48.591  1.00 37.18           O  
ATOM   4112  N   GLU D  53     -10.120 -12.959  50.693  0.50 36.15           N  
ATOM   4114  CA  GLU D  53      -9.728 -11.616  51.186  0.50 35.59           C  
ATOM   4116  C   GLU D  53      -8.272 -11.565  51.685  0.50 35.09           C  
ATOM   4118  O   GLU D  53      -7.772 -12.547  52.236  0.50 34.91           O  
ATOM   4120  CB  GLU D  53     -10.713 -11.080  52.255  0.50 35.64           C  
ATOM   4122  CG  GLU D  53     -10.559 -11.651  53.668  0.50 35.32           C  
ATOM   4124  CD  GLU D  53     -11.520 -11.053  54.695  0.50 35.39           C  
ATOM   4126  OE1 GLU D  53     -11.986  -9.906  54.523  0.50 35.69           O  
ATOM   4128  OE2 GLU D  53     -11.804 -11.736  55.698  0.50 35.27           O  
ATOM   4130  N   VAL D  54      -7.609 -10.424  51.468  1.00 34.83           N  
ATOM   4131  CA  VAL D  54      -6.245 -10.165  51.946  1.00 33.23           C  
ATOM   4132  C   VAL D  54      -6.231  -9.944  53.453  1.00 32.69           C  
ATOM   4133  O   VAL D  54      -6.876  -9.038  53.941  1.00 32.42           O  
ATOM   4134  CB  VAL D  54      -5.645  -8.879  51.265  1.00 33.43           C  
ATOM   4135  CG1 VAL D  54      -4.364  -8.468  51.908  1.00 31.48           C  
ATOM   4136  CG2 VAL D  54      -5.430  -9.096  49.789  1.00 34.13           C  
ATOM   4137  N   VAL D  55      -5.497 -10.753  54.207  1.00 31.62           N  
ATOM   4138  CA  VAL D  55      -5.554 -10.579  55.659  1.00 31.51           C  
ATOM   4139  C   VAL D  55      -4.193 -10.401  56.250  1.00 30.53           C  
ATOM   4140  O   VAL D  55      -4.066 -10.277  57.454  1.00 30.33           O  
ATOM   4141  CB  VAL D  55      -6.338 -11.719  56.413  1.00 30.71           C  
ATOM   4142  CG1 VAL D  55      -7.762 -11.745  55.980  1.00 33.60           C  
ATOM   4143  CG2 VAL D  55      -5.727 -13.082  56.161  1.00 30.64           C  
ATOM   4144  N   GLY D  56      -3.169 -10.407  55.394  1.00 30.22           N  
ATOM   4145  CA  GLY D  56      -1.827 -10.222  55.836  1.00 29.27           C  
ATOM   4146  C   GLY D  56      -0.974  -9.777  54.672  1.00 29.34           C  
ATOM   4147  O   GLY D  56      -1.291 -10.044  53.493  1.00 28.41           O  
ATOM   4148  N   THR D  57       0.107  -9.086  55.002  1.00 29.26           N  
ATOM   4149  CA  THR D  57       1.095  -8.648  54.006  1.00 28.97           C  
ATOM   4150  C   THR D  57       2.484  -8.761  54.588  1.00 29.27           C  
ATOM   4151  O   THR D  57       2.634  -8.828  55.767  1.00 29.77           O  
ATOM   4152  CB  THR D  57       0.925  -7.147  53.598  1.00 30.24           C  
ATOM   4153  OG1 THR D  57       0.847  -6.279  54.770  1.00 29.84           O  
ATOM   4154  CG2 THR D  57      -0.270  -6.957  52.699  1.00 29.17           C  
ATOM   4155  N   VAL D  58       3.482  -8.788  53.725  1.00 28.91           N  
ATOM   4156  CA  VAL D  58       4.820  -8.342  54.049  1.00 30.49           C  
ATOM   4157  C   VAL D  58       5.297  -7.826  52.724  1.00 29.66           C  
ATOM   4158  O   VAL D  58       5.083  -8.455  51.683  1.00 29.18           O  
ATOM   4159  CB  VAL D  58       5.768  -9.463  54.647  1.00 30.40           C  
ATOM   4160  CG1 VAL D  58       5.919 -10.673  53.698  1.00 31.46           C  
ATOM   4161  CG2 VAL D  58       7.136  -8.877  55.040  1.00 30.91           C  
HETATM 4162  N   MSE D  59       5.930  -6.667  52.755  1.00 31.43           N  
HETATM 4163  CA  MSE D  59       6.603  -6.148  51.591  1.00 32.49           C  
HETATM 4164  C   MSE D  59       8.089  -6.512  51.656  1.00 31.54           C  
HETATM 4165  O   MSE D  59       8.916  -5.746  52.153  1.00 28.07           O  
HETATM 4166  CB  MSE D  59       6.376  -4.636  51.456  1.00 32.36           C  
HETATM 4167  CG  MSE D  59       6.925  -4.042  50.166  1.00 34.76           C  
HETATM 4168 SE   MSE D  59       6.933  -2.073  50.166  1.00 40.50          SE  
HETATM 4169  CE  MSE D  59       5.078  -1.674  49.627  1.00 34.53           C  
ATOM   4170  N   GLY D  60       8.408  -7.693  51.120  1.00 31.15           N  
ATOM   4171  CA  GLY D  60       9.778  -8.151  51.058  1.00 30.52           C  
ATOM   4172  C   GLY D  60      10.523  -7.391  49.992  1.00 31.14           C  
ATOM   4173  O   GLY D  60       9.929  -6.721  49.146  1.00 31.46           O  
ATOM   4174  N   GLY D  61      11.840  -7.468  50.043  1.00 29.98           N  
ATOM   4175  CA  GLY D  61      12.650  -6.786  49.060  1.00 27.99           C  
ATOM   4176  C   GLY D  61      13.999  -7.449  49.036  1.00 28.02           C  
ATOM   4177  O   GLY D  61      14.331  -8.253  49.917  1.00 27.59           O  
ATOM   4178  N   TYR D  62      14.792  -7.110  48.023  1.00 27.70           N  
ATOM   4179  CA  TYR D  62      16.115  -7.675  47.874  1.00 28.67           C  
ATOM   4180  C   TYR D  62      16.870  -6.692  47.016  1.00 28.91           C  
ATOM   4181  O   TYR D  62      16.408  -6.371  45.913  1.00 30.00           O  
ATOM   4182  CB  TYR D  62      16.074  -9.045  47.178  1.00 27.72           C  
ATOM   4183  CG  TYR D  62      17.436  -9.638  46.960  1.00 27.87           C  
ATOM   4184  CD1 TYR D  62      18.399  -9.578  47.972  1.00 27.16           C  
ATOM   4185  CD2 TYR D  62      17.762 -10.283  45.751  1.00 27.60           C  
ATOM   4186  CE1 TYR D  62      19.624 -10.122  47.803  1.00 29.02           C  
ATOM   4187  CE2 TYR D  62      19.010 -10.866  45.575  1.00 30.03           C  
ATOM   4188  CZ  TYR D  62      19.935 -10.775  46.616  1.00 30.05           C  
ATOM   4189  OH  TYR D  62      21.180 -11.315  46.489  1.00 27.76           O  
ATOM   4190  N   ASP D  63      18.026  -6.248  47.490  1.00 29.81           N  
ATOM   4191  CA  ASP D  63      18.839  -5.261  46.762  1.00 30.72           C  
ATOM   4192  C   ASP D  63      20.059  -5.816  46.024  1.00 30.95           C  
ATOM   4193  O   ASP D  63      20.879  -5.031  45.514  1.00 31.31           O  
ATOM   4194  CB  ASP D  63      19.257  -4.075  47.685  1.00 30.35           C  
ATOM   4195  CG  ASP D  63      20.140  -4.524  48.892  1.00 35.74           C  
ATOM   4196  OD1 ASP D  63      20.630  -5.688  48.959  1.00 36.17           O  
ATOM   4197  OD2 ASP D  63      20.339  -3.702  49.792  1.00 37.39           O  
ATOM   4198  N   GLY D  64      20.158  -7.137  45.915  1.00 29.96           N  
ATOM   4199  CA  GLY D  64      21.334  -7.766  45.340  1.00 29.13           C  
ATOM   4200  C   GLY D  64      22.359  -8.099  46.419  1.00 28.94           C  
ATOM   4201  O   GLY D  64      23.345  -8.759  46.143  1.00 29.97           O  
ATOM   4202  N   HIS D  65      22.157  -7.606  47.634  1.00 28.95           N  
ATOM   4203  CA  HIS D  65      23.094  -7.869  48.759  1.00 28.61           C  
ATOM   4204  C   HIS D  65      22.333  -8.422  49.963  1.00 29.99           C  
ATOM   4205  O   HIS D  65      22.724  -9.457  50.520  1.00 30.48           O  
ATOM   4206  CB  HIS D  65      23.908  -6.636  49.145  1.00 28.87           C  
ATOM   4207  CG  HIS D  65      25.118  -6.963  49.955  1.00 26.18           C  
ATOM   4208  ND1 HIS D  65      25.383  -6.357  51.158  1.00 24.47           N  
ATOM   4209  CD2 HIS D  65      26.054  -7.931  49.802  1.00 23.73           C  
ATOM   4210  CE1 HIS D  65      26.454  -6.910  51.701  1.00 25.65           C  
ATOM   4211  NE2 HIS D  65      26.885  -7.861  50.896  1.00 31.18           N  
ATOM   4212  N   ARG D  66      21.235  -7.737  50.324  1.00 28.95           N  
ATOM   4213  CA  ARG D  66      20.480  -8.048  51.518  1.00 28.56           C  
ATOM   4214  C   ARG D  66      18.997  -8.003  51.226  1.00 28.38           C  
ATOM   4215  O   ARG D  66      18.529  -7.154  50.433  1.00 27.52           O  
ATOM   4216  CB  ARG D  66      20.755  -7.021  52.635  1.00 29.05           C  
ATOM   4217  CG  ARG D  66      22.166  -7.007  53.212  1.00 28.82           C  
ATOM   4218  CD  ARG D  66      22.548  -8.385  53.615  1.00 31.90           C  
ATOM   4219  NE  ARG D  66      23.875  -8.483  54.229  1.00 28.57           N  
ATOM   4220  CZ  ARG D  66      24.889  -9.166  53.724  1.00 29.91           C  
ATOM   4221  NH1 ARG D  66      26.021  -9.258  54.414  1.00 31.76           N  
ATOM   4222  NH2 ARG D  66      24.762  -9.778  52.552  1.00 25.69           N  
ATOM   4223  N   GLY D  67      18.249  -8.909  51.869  1.00 27.50           N  
ATOM   4224  CA  GLY D  67      16.816  -8.867  51.800  1.00 26.31           C  
ATOM   4225  C   GLY D  67      16.255  -7.916  52.861  1.00 26.94           C  
ATOM   4226  O   GLY D  67      16.878  -7.678  53.913  1.00 26.49           O  
ATOM   4227  N   SER D  68      15.047  -7.421  52.624  1.00 27.42           N  
ATOM   4228  CA  SER D  68      14.386  -6.522  53.582  1.00 28.09           C  
ATOM   4229  C   SER D  68      12.937  -6.965  53.742  1.00 28.73           C  
ATOM   4230  O   SER D  68      12.449  -7.871  53.048  1.00 27.67           O  
ATOM   4231  CB  SER D  68      14.401  -5.128  53.053  1.00 28.88           C  
ATOM   4232  OG  SER D  68      13.939  -5.189  51.701  1.00 30.23           O  
ATOM   4233  N   ALA D  69      12.261  -6.334  54.690  1.00 28.45           N  
ATOM   4234  CA  ALA D  69      10.865  -6.618  54.924  1.00 28.78           C  
ATOM   4235  C   ALA D  69      10.244  -5.388  55.582  1.00 28.72           C  
ATOM   4236  O   ALA D  69      10.756  -4.892  56.604  1.00 28.13           O  
ATOM   4237  CB  ALA D  69      10.725  -7.832  55.787  1.00 27.38           C  
ATOM   4238  N   TYR D  70       9.157  -4.901  54.969  1.00 29.53           N  
ATOM   4239  CA  TYR D  70       8.352  -3.808  55.533  1.00 29.99           C  
ATOM   4240  C   TYR D  70       6.890  -4.206  55.546  1.00 30.03           C  
ATOM   4241  O   TYR D  70       6.517  -5.222  54.962  1.00 29.86           O  
ATOM   4242  CB  TYR D  70       8.500  -2.531  54.707  1.00 31.42           C  
ATOM   4243  CG  TYR D  70       9.935  -2.224  54.339  1.00 31.86           C  
ATOM   4244  CD1 TYR D  70      10.763  -1.523  55.197  1.00 34.24           C  
ATOM   4245  CD2 TYR D  70      10.468  -2.682  53.147  1.00 32.56           C  
ATOM   4246  CE1 TYR D  70      12.116  -1.267  54.840  1.00 35.01           C  
ATOM   4247  CE2 TYR D  70      11.777  -2.428  52.807  1.00 32.24           C  
ATOM   4248  CZ  TYR D  70      12.579  -1.724  53.653  1.00 31.97           C  
ATOM   4249  OH  TYR D  70      13.900  -1.490  53.273  1.00 37.23           O  
ATOM   4250  N   TYR D  71       6.079  -3.396  56.217  1.00 28.61           N  
ATOM   4251  CA  TYR D  71       4.627  -3.530  56.229  1.00 29.18           C  
ATOM   4252  C   TYR D  71       4.143  -4.928  56.531  1.00 28.95           C  
ATOM   4253  O   TYR D  71       3.228  -5.428  55.845  1.00 29.36           O  
ATOM   4254  CB  TYR D  71       4.045  -3.069  54.893  1.00 29.01           C  
ATOM   4255  CG  TYR D  71       3.946  -1.573  54.743  1.00 30.46           C  
ATOM   4256  CD1 TYR D  71       2.943  -0.848  55.375  1.00 25.60           C  
ATOM   4257  CD2 TYR D  71       4.847  -0.897  53.938  1.00 30.95           C  
ATOM   4258  CE1 TYR D  71       2.835   0.536  55.214  1.00 28.03           C  
ATOM   4259  CE2 TYR D  71       4.752   0.472  53.756  1.00 32.85           C  
ATOM   4260  CZ  TYR D  71       3.756   1.176  54.399  1.00 30.44           C  
ATOM   4261  OH  TYR D  71       3.722   2.518  54.193  1.00 32.24           O  
ATOM   4262  N   LEU D  72       4.752  -5.556  57.545  1.00 28.47           N  
ATOM   4263  CA  LEU D  72       4.318  -6.853  57.987  1.00 28.49           C  
ATOM   4264  C   LEU D  72       3.124  -6.672  58.909  1.00 28.14           C  
ATOM   4265  O   LEU D  72       3.181  -5.955  59.900  1.00 28.71           O  
ATOM   4266  CB  LEU D  72       5.467  -7.640  58.648  1.00 29.04           C  
ATOM   4267  CG  LEU D  72       5.191  -9.024  59.253  1.00 29.12           C  
ATOM   4268  CD1 LEU D  72       4.474  -9.916  58.316  1.00 27.14           C  
ATOM   4269  CD2 LEU D  72       6.549  -9.679  59.563  1.00 29.88           C  
ATOM   4270  N   GLY D  73       2.016  -7.302  58.567  1.00 27.30           N  
ATOM   4271  CA  GLY D  73       0.813  -7.038  59.300  1.00 26.06           C  
ATOM   4272  C   GLY D  73      -0.181  -8.139  59.084  1.00 26.10           C  
ATOM   4273  O   GLY D  73      -0.225  -8.727  58.022  1.00 25.04           O  
ATOM   4274  N   VAL D  74      -1.002  -8.391  60.087  1.00 27.04           N  
ATOM   4275  CA  VAL D  74      -2.049  -9.395  59.995  1.00 27.96           C  
ATOM   4276  C   VAL D  74      -3.280  -8.813  60.662  1.00 28.65           C  
ATOM   4277  O   VAL D  74      -3.205  -8.322  61.787  1.00 29.30           O  
ATOM   4278  CB  VAL D  74      -1.688 -10.725  60.726  1.00 28.31           C  
ATOM   4279  CG1 VAL D  74      -2.822 -11.801  60.537  1.00 26.12           C  
ATOM   4280  CG2 VAL D  74      -0.329 -11.252  60.295  1.00 27.70           C  
ATOM   4281  N   HIS D  75      -4.401  -8.882  59.954  1.00 29.08           N  
ATOM   4282  CA  HIS D  75      -5.660  -8.334  60.400  1.00 30.14           C  
ATOM   4283  C   HIS D  75      -5.889  -8.851  61.806  1.00 30.62           C  
ATOM   4284  O   HIS D  75      -5.645 -10.039  62.068  1.00 30.20           O  
ATOM   4285  CB  HIS D  75      -6.781  -8.780  59.463  1.00 29.54           C  
ATOM   4286  CG  HIS D  75      -8.087  -8.104  59.723  1.00 30.33           C  
ATOM   4287  ND1 HIS D  75      -8.826  -8.327  60.858  1.00 29.33           N  
ATOM   4288  CD2 HIS D  75      -8.796  -7.222  58.982  1.00 29.09           C  
ATOM   4289  CE1 HIS D  75      -9.929  -7.606  60.815  1.00 28.54           C  
ATOM   4290  NE2 HIS D  75      -9.931  -6.920  59.689  1.00 27.35           N  
ATOM   4291  N   PRO D  76      -6.283  -7.949  62.728  1.00 31.42           N  
ATOM   4292  CA  PRO D  76      -6.642  -8.286  64.114  1.00 32.23           C  
ATOM   4293  C   PRO D  76      -7.548  -9.537  64.261  1.00 32.85           C  
ATOM   4294  O   PRO D  76      -7.289 -10.402  65.117  1.00 33.43           O  
ATOM   4295  CB  PRO D  76      -7.346  -7.008  64.609  1.00 32.05           C  
ATOM   4296  CG  PRO D  76      -6.674  -5.917  63.840  1.00 32.75           C  
ATOM   4297  CD  PRO D  76      -6.348  -6.494  62.479  1.00 30.94           C  
ATOM   4298  N   GLU D  77      -8.563  -9.634  63.399  1.00 32.97           N  
ATOM   4299  CA  GLU D  77      -9.571 -10.707  63.409  1.00 33.50           C  
ATOM   4300  C   GLU D  77      -8.955 -12.100  63.099  1.00 32.91           C  
ATOM   4301  O   GLU D  77      -9.543 -13.124  63.440  1.00 32.35           O  
ATOM   4302  CB  GLU D  77     -10.677 -10.344  62.387  1.00 33.34           C  
ATOM   4303  CG  GLU D  77     -12.114 -10.733  62.718  1.00 35.20           C  
ATOM   4304  CD  GLU D  77     -13.156  -9.995  61.845  1.00 35.74           C  
ATOM   4305  OE1 GLU D  77     -14.039  -9.305  62.414  1.00 39.64           O  
ATOM   4306  OE2 GLU D  77     -13.103 -10.096  60.589  1.00 39.40           O  
ATOM   4307  N   PHE D  78      -7.774 -12.134  62.467  1.00 31.67           N  
ATOM   4308  CA  PHE D  78      -7.134 -13.399  62.058  1.00 31.43           C  
ATOM   4309  C   PHE D  78      -5.801 -13.641  62.741  1.00 31.04           C  
ATOM   4310  O   PHE D  78      -4.925 -14.311  62.189  1.00 30.20           O  
ATOM   4311  CB  PHE D  78      -6.930 -13.453  60.540  1.00 32.05           C  
ATOM   4312  CG  PHE D  78      -8.216 -13.424  59.750  1.00 33.94           C  
ATOM   4313  CD1 PHE D  78      -8.601 -14.526  58.982  1.00 34.03           C  
ATOM   4314  CD2 PHE D  78      -9.042 -12.287  59.765  1.00 32.62           C  
ATOM   4315  CE1 PHE D  78      -9.795 -14.490  58.233  1.00 35.23           C  
ATOM   4316  CE2 PHE D  78     -10.230 -12.244  59.033  1.00 33.04           C  
ATOM   4317  CZ  PHE D  78     -10.612 -13.350  58.270  1.00 33.98           C  
ATOM   4318  N   ARG D  79      -5.641 -13.081  63.931  1.00 31.11           N  
ATOM   4319  CA  ARG D  79      -4.412 -13.230  64.701  1.00 31.33           C  
ATOM   4320  C   ARG D  79      -4.378 -14.501  65.541  1.00 31.21           C  
ATOM   4321  O   ARG D  79      -5.426 -15.098  65.849  1.00 32.35           O  
ATOM   4322  CB  ARG D  79      -4.123 -11.977  65.535  1.00 31.66           C  
ATOM   4323  CG  ARG D  79      -3.223 -11.015  64.775  1.00 32.27           C  
ATOM   4324  CD  ARG D  79      -2.836  -9.807  65.606  1.00 37.97           C  
ATOM   4325  NE  ARG D  79      -2.526  -8.664  64.740  1.00 39.44           N  
ATOM   4326  CZ  ARG D  79      -2.752  -7.390  65.063  1.00 39.77           C  
ATOM   4327  NH1 ARG D  79      -3.280  -7.079  66.235  1.00 40.20           N  
ATOM   4328  NH2 ARG D  79      -2.472  -6.428  64.202  1.00 39.94           N  
ATOM   4329  N   GLY D  80      -3.168 -14.895  65.937  1.00 31.07           N  
ATOM   4330  CA  GLY D  80      -2.936 -16.153  66.639  1.00 29.89           C  
ATOM   4331  C   GLY D  80      -3.224 -17.370  65.773  1.00 29.64           C  
ATOM   4332  O   GLY D  80      -3.713 -18.371  66.278  1.00 30.33           O  
ATOM   4333  N   ARG D  81      -2.891 -17.315  64.489  0.50 29.36           N  
ATOM   4335  CA  ARG D  81      -3.079 -18.477  63.610  0.50 28.66           C  
ATOM   4337  C   ARG D  81      -1.826 -18.665  62.771  0.50 28.45           C  
ATOM   4339  O   ARG D  81      -1.814 -19.403  61.783  0.50 28.78           O  
ATOM   4341  CB  ARG D  81      -4.325 -18.288  62.730  0.50 28.44           C  
ATOM   4343  CG  ARG D  81      -5.627 -18.257  63.520  0.50 27.77           C  
ATOM   4345  CD  ARG D  81      -6.606 -17.205  63.013  0.50 24.53           C  
ATOM   4347  NE  ARG D  81      -7.408 -17.682  61.890  0.50 20.65           N  
ATOM   4349  CZ  ARG D  81      -8.589 -17.175  61.546  0.50 16.45           C  
ATOM   4351  NH1 ARG D  81      -9.242 -17.652  60.496  0.50 13.57           N  
ATOM   4353  NH2 ARG D  81      -9.104 -16.174  62.237  0.50 11.91           N  
ATOM   4355  N   GLY D  82      -0.767 -17.976  63.172  1.00 27.98           N  
ATOM   4356  CA  GLY D  82       0.560 -18.147  62.547  1.00 28.25           C  
ATOM   4357  C   GLY D  82       0.741 -17.605  61.146  1.00 27.65           C  
ATOM   4358  O   GLY D  82       1.620 -18.038  60.413  1.00 28.61           O  
ATOM   4359  N   ILE D  83      -0.088 -16.659  60.750  1.00 27.97           N  
ATOM   4360  CA  ILE D  83      -0.032 -16.126  59.393  1.00 27.67           C  
ATOM   4361  C   ILE D  83       1.255 -15.253  59.211  1.00 28.48           C  
ATOM   4362  O   ILE D  83       1.951 -15.363  58.220  1.00 27.79           O  
ATOM   4363  CB  ILE D  83      -1.368 -15.359  59.055  1.00 27.50           C  
ATOM   4364  CG1 ILE D  83      -2.574 -16.316  59.028  1.00 28.12           C  
ATOM   4365  CG2 ILE D  83      -1.296 -14.629  57.746  1.00 26.85           C  
ATOM   4366  CD1 ILE D  83      -3.869 -15.628  58.500  1.00 26.54           C  
ATOM   4367  N   ALA D  84       1.581 -14.431  60.203  1.00 29.42           N  
ATOM   4368  CA  ALA D  84       2.786 -13.624  60.183  1.00 30.01           C  
ATOM   4369  C   ALA D  84       4.055 -14.463  60.053  1.00 30.73           C  
ATOM   4370  O   ALA D  84       4.917 -14.156  59.218  1.00 31.47           O  
ATOM   4371  CB  ALA D  84       2.853 -12.747  61.441  1.00 30.57           C  
ATOM   4372  N   ASN D  85       4.174 -15.503  60.881  1.00 31.75           N  
ATOM   4373  CA  ASN D  85       5.236 -16.498  60.736  1.00 32.75           C  
ATOM   4374  C   ASN D  85       5.261 -17.135  59.349  1.00 31.87           C  
ATOM   4375  O   ASN D  85       6.330 -17.264  58.777  1.00 32.20           O  
ATOM   4376  CB  ASN D  85       5.119 -17.583  61.817  1.00 33.47           C  
ATOM   4377  CG  ASN D  85       5.789 -17.183  63.128  1.00 36.52           C  
ATOM   4378  OD1 ASN D  85       5.672 -17.880  64.139  1.00 41.10           O  
ATOM   4379  ND2 ASN D  85       6.516 -16.067  63.112  1.00 41.22           N  
ATOM   4380  N   ALA D  86       4.086 -17.518  58.826  1.00 30.82           N  
ATOM   4381  CA  ALA D  86       3.948 -18.098  57.465  1.00 29.85           C  
ATOM   4382  C   ALA D  86       4.414 -17.129  56.398  1.00 29.03           C  
ATOM   4383  O   ALA D  86       5.095 -17.514  55.417  1.00 28.70           O  
ATOM   4384  CB  ALA D  86       2.496 -18.546  57.198  1.00 29.93           C  
ATOM   4385  N   LEU D  87       4.109 -15.850  56.606  1.00 28.24           N  
ATOM   4386  CA  LEU D  87       4.530 -14.783  55.650  1.00 27.66           C  
ATOM   4387  C   LEU D  87       6.045 -14.586  55.619  1.00 27.73           C  
ATOM   4388  O   LEU D  87       6.655 -14.399  54.531  1.00 25.79           O  
ATOM   4389  CB  LEU D  87       3.807 -13.440  55.962  1.00 27.59           C  
ATOM   4390  CG  LEU D  87       2.398 -13.298  55.364  1.00 26.76           C  
ATOM   4391  CD1 LEU D  87       1.511 -12.317  56.157  1.00 24.18           C  
ATOM   4392  CD2 LEU D  87       2.528 -12.867  53.855  1.00 27.59           C  
ATOM   4393  N   LEU D  88       6.653 -14.639  56.811  1.00 27.27           N  
ATOM   4394  CA  LEU D  88       8.085 -14.395  56.914  1.00 27.70           C  
ATOM   4395  C   LEU D  88       8.847 -15.609  56.425  1.00 26.53           C  
ATOM   4396  O   LEU D  88       9.888 -15.467  55.830  1.00 26.59           O  
ATOM   4397  CB  LEU D  88       8.503 -14.130  58.341  1.00 28.84           C  
ATOM   4398  CG  LEU D  88       9.262 -12.830  58.587  1.00 32.82           C  
ATOM   4399  CD1 LEU D  88      10.015 -12.348  57.352  1.00 37.03           C  
ATOM   4400  CD2 LEU D  88       8.251 -11.824  58.932  1.00 33.69           C  
ATOM   4401  N   ASN D  89       8.316 -16.802  56.678  0.50 26.49           N  
ATOM   4403  CA  ASN D  89       8.923 -18.061  56.207  0.50 26.36           C  
ATOM   4405  C   ASN D  89       8.877 -18.219  54.700  0.50 25.72           C  
ATOM   4407  O   ASN D  89       9.849 -18.659  54.095  0.50 26.45           O  
ATOM   4409  CB  ASN D  89       8.281 -19.286  56.879  0.50 26.55           C  
ATOM   4411  CG  ASN D  89       9.074 -19.776  58.080  0.50 27.23           C  
ATOM   4413  OD1 ASN D  89       9.173 -19.087  59.090  0.50 29.15           O  
ATOM   4415  ND2 ASN D  89       9.630 -20.985  57.978  0.50 28.79           N  
ATOM   4417  N   ARG D  90       7.756 -17.845  54.096  1.00 24.20           N  
ATOM   4418  CA  ARG D  90       7.642 -17.779  52.663  1.00 24.25           C  
ATOM   4419  C   ARG D  90       8.609 -16.728  52.077  1.00 25.17           C  
ATOM   4420  O   ARG D  90       9.263 -17.023  51.088  1.00 25.21           O  
ATOM   4421  CB  ARG D  90       6.226 -17.476  52.231  1.00 23.71           C  
ATOM   4422  CG  ARG D  90       5.951 -17.716  50.781  1.00 25.28           C  
ATOM   4423  CD  ARG D  90       6.286 -19.157  50.296  1.00 23.40           C  
ATOM   4424  NE  ARG D  90       5.746 -19.251  48.955  1.00 25.12           N  
ATOM   4425  CZ  ARG D  90       4.473 -19.545  48.709  1.00 30.52           C  
ATOM   4426  NH1 ARG D  90       3.670 -19.810  49.715  1.00 28.86           N  
ATOM   4427  NH2 ARG D  90       4.009 -19.597  47.474  1.00 33.72           N  
ATOM   4428  N   LEU D  91       8.705 -15.534  52.671  1.00 25.85           N  
ATOM   4429  CA  LEU D  91       9.631 -14.527  52.110  1.00 28.14           C  
ATOM   4430  C   LEU D  91      11.054 -15.017  52.138  1.00 27.51           C  
ATOM   4431  O   LEU D  91      11.804 -14.813  51.176  1.00 30.06           O  
ATOM   4432  CB  LEU D  91       9.541 -13.169  52.829  1.00 27.91           C  
ATOM   4433  CG  LEU D  91      10.542 -12.059  52.498  1.00 28.04           C  
ATOM   4434  CD1 LEU D  91      10.611 -11.682  50.968  1.00 28.45           C  
ATOM   4435  CD2 LEU D  91      10.143 -10.845  53.367  1.00 27.98           C  
ATOM   4436  N   GLU D  92      11.449 -15.557  53.284  1.00 27.25           N  
ATOM   4437  CA  GLU D  92      12.792 -16.077  53.472  1.00 27.28           C  
ATOM   4438  C   GLU D  92      13.153 -17.147  52.394  1.00 26.65           C  
ATOM   4439  O   GLU D  92      14.208 -17.122  51.796  1.00 25.21           O  
ATOM   4440  CB  GLU D  92      12.911 -16.650  54.890  1.00 26.67           C  
ATOM   4441  CG  GLU D  92      13.004 -15.543  56.050  1.00 27.70           C  
ATOM   4442  CD  GLU D  92      13.016 -16.221  57.468  1.00 29.80           C  
ATOM   4443  OE1 GLU D  92      13.453 -17.377  57.577  1.00 30.89           O  
ATOM   4444  OE2 GLU D  92      12.571 -15.633  58.468  1.00 31.60           O  
ATOM   4445  N   LYS D  93      12.223 -18.055  52.151  1.00 25.49           N  
ATOM   4446  CA  LYS D  93      12.325 -19.052  51.083  1.00 26.38           C  
ATOM   4447  C   LYS D  93      12.413 -18.457  49.667  1.00 26.49           C  
ATOM   4448  O   LYS D  93      13.115 -18.997  48.833  1.00 28.28           O  
ATOM   4449  CB  LYS D  93      11.104 -19.977  51.207  1.00 26.88           C  
ATOM   4450  CG  LYS D  93      11.480 -21.349  51.558  1.00 27.71           C  
ATOM   4451  CD  LYS D  93      11.209 -21.770  52.929  1.00 29.49           C  
ATOM   4452  CE  LYS D  93      10.056 -22.782  52.863  1.00 27.19           C  
ATOM   4453  NZ  LYS D  93      10.362 -24.055  53.598  1.00 28.36           N  
ATOM   4454  N   LYS D  94      11.693 -17.359  49.406  1.00 26.53           N  
ATOM   4455  CA  LYS D  94      11.720 -16.669  48.114  1.00 24.66           C  
ATOM   4456  C   LYS D  94      13.056 -15.949  47.923  1.00 26.04           C  
ATOM   4457  O   LYS D  94      13.532 -15.836  46.810  1.00 25.74           O  
ATOM   4458  CB  LYS D  94      10.589 -15.671  47.983  1.00 24.43           C  
ATOM   4459  CG  LYS D  94       9.129 -16.333  47.738  1.00 23.92           C  
ATOM   4460  CD  LYS D  94       8.103 -15.284  47.393  1.00 22.36           C  
ATOM   4461  CE  LYS D  94       6.662 -15.862  47.105  1.00 25.53           C  
ATOM   4462  NZ  LYS D  94       6.517 -16.339  45.665  1.00 25.08           N  
ATOM   4463  N   LEU D  95      13.621 -15.430  49.007  1.00 25.74           N  
ATOM   4464  CA  LEU D  95      14.970 -14.825  49.004  1.00 25.02           C  
ATOM   4465  C   LEU D  95      16.068 -15.867  48.785  1.00 25.42           C  
ATOM   4466  O   LEU D  95      16.947 -15.702  47.911  1.00 27.19           O  
ATOM   4467  CB  LEU D  95      15.170 -14.108  50.349  1.00 24.22           C  
ATOM   4468  CG  LEU D  95      14.277 -12.876  50.545  1.00 24.62           C  
ATOM   4469  CD1 LEU D  95      14.338 -12.403  52.017  1.00 22.71           C  
ATOM   4470  CD2 LEU D  95      14.705 -11.753  49.590  1.00 26.16           C  
ATOM   4471  N   ILE D  96      16.054 -16.961  49.544  1.00 25.25           N  
ATOM   4472  CA  ILE D  96      17.064 -18.010  49.318  1.00 25.07           C  
ATOM   4473  C   ILE D  96      17.041 -18.474  47.870  1.00 26.28           C  
ATOM   4474  O   ILE D  96      18.131 -18.649  47.244  1.00 25.66           O  
ATOM   4475  CB  ILE D  96      16.905 -19.205  50.290  1.00 24.05           C  
ATOM   4476  CG1 ILE D  96      17.132 -18.704  51.707  1.00 24.11           C  
ATOM   4477  CG2 ILE D  96      17.825 -20.458  49.901  1.00 24.50           C  
ATOM   4478  CD1 ILE D  96      17.020 -19.783  52.775  1.00 26.73           C  
ATOM   4479  N   ALA D  97      15.808 -18.613  47.348  1.00 27.07           N  
ATOM   4480  CA  ALA D  97      15.542 -19.080  45.972  1.00 27.09           C  
ATOM   4481  C   ALA D  97      16.199 -18.208  44.927  1.00 26.64           C  
ATOM   4482  O   ALA D  97      16.579 -18.682  43.853  1.00 25.95           O  
ATOM   4483  CB  ALA D  97      14.060 -19.139  45.698  1.00 26.41           C  
ATOM   4484  N   ARG D  98      16.296 -16.919  45.207  1.00 26.00           N  
ATOM   4485  CA  ARG D  98      17.091 -16.045  44.312  1.00 25.91           C  
ATOM   4486  C   ARG D  98      18.501 -15.794  44.795  1.00 25.63           C  
ATOM   4487  O   ARG D  98      19.211 -14.891  44.295  1.00 25.83           O  
ATOM   4488  CB  ARG D  98      16.354 -14.749  43.994  1.00 25.76           C  
ATOM   4489  CG  ARG D  98      16.217 -13.746  45.100  1.00 28.07           C  
ATOM   4490  CD  ARG D  98      15.135 -12.660  44.686  1.00 30.18           C  
ATOM   4491  NE  ARG D  98      13.788 -13.262  44.583  1.00 33.16           N  
ATOM   4492  CZ  ARG D  98      12.696 -12.660  44.062  1.00 36.00           C  
ATOM   4493  NH1 ARG D  98      12.735 -11.416  43.577  1.00 37.13           N  
ATOM   4494  NH2 ARG D  98      11.543 -13.311  44.018  1.00 34.90           N  
ATOM   4495  N   GLY D  99      18.966 -16.575  45.768  1.00 25.60           N  
ATOM   4496  CA  GLY D  99      20.359 -16.366  46.161  1.00 24.84           C  
ATOM   4497  C   GLY D  99      20.660 -15.237  47.155  1.00 25.20           C  
ATOM   4498  O   GLY D  99      21.845 -14.892  47.337  1.00 26.54           O  
ATOM   4499  N   CYS D 100      19.627 -14.638  47.752  1.00 24.64           N  
ATOM   4500  CA  CYS D 100      19.817 -13.656  48.829  1.00 25.01           C  
ATOM   4501  C   CYS D 100      20.459 -14.316  50.047  1.00 25.51           C  
ATOM   4502  O   CYS D 100      19.901 -15.287  50.591  1.00 25.13           O  
ATOM   4503  CB  CYS D 100      18.514 -13.026  49.249  1.00 23.93           C  
ATOM   4504  SG  CYS D 100      18.634 -11.901  50.673  1.00 26.87           S  
ATOM   4505  N   PRO D 101      21.643 -13.832  50.460  1.00 24.55           N  
ATOM   4506  CA  PRO D 101      22.306 -14.510  51.576  1.00 26.07           C  
ATOM   4507  C   PRO D 101      21.894 -14.136  53.026  1.00 26.53           C  
ATOM   4508  O   PRO D 101      22.267 -14.825  54.006  1.00 26.27           O  
ATOM   4509  CB  PRO D 101      23.759 -14.079  51.390  1.00 25.70           C  
ATOM   4510  CG  PRO D 101      23.641 -12.668  50.891  1.00 25.22           C  
ATOM   4511  CD  PRO D 101      22.461 -12.734  49.927  1.00 25.67           C  
ATOM   4512  N   LYS D 102      21.259 -13.002  53.187  1.00 27.22           N  
ATOM   4513  CA  LYS D 102      20.951 -12.559  54.504  1.00 28.20           C  
ATOM   4514  C   LYS D 102      19.788 -11.607  54.368  1.00 29.16           C  
ATOM   4515  O   LYS D 102      19.726 -10.854  53.423  1.00 29.24           O  
ATOM   4516  CB  LYS D 102      22.163 -11.820  55.108  1.00 28.81           C  
ATOM   4517  CG  LYS D 102      21.969 -11.386  56.565  1.00 29.17           C  
ATOM   4518  CD  LYS D 102      23.061 -10.452  56.957  1.00 34.02           C  
ATOM   4519  CE  LYS D 102      22.817  -9.954  58.353  1.00 36.96           C  
ATOM   4520  NZ  LYS D 102      24.112  -9.449  58.856  1.00 39.44           N  
ATOM   4521  N   ILE D 103      18.889 -11.632  55.330  1.00 29.28           N  
ATOM   4522  CA  ILE D 103      17.844 -10.626  55.417  1.00 30.25           C  
ATOM   4523  C   ILE D 103      18.010  -9.815  56.703  1.00 30.49           C  
ATOM   4524  O   ILE D 103      18.419 -10.344  57.737  1.00 30.57           O  
ATOM   4525  CB  ILE D 103      16.429 -11.312  55.341  1.00 29.11           C  
ATOM   4526  CG1 ILE D 103      15.274 -10.316  55.530  1.00 31.96           C  
ATOM   4527  CG2 ILE D 103      16.329 -12.415  56.386  1.00 32.00           C  
ATOM   4528  CD1 ILE D 103      13.893 -10.976  55.613  1.00 28.83           C  
ATOM   4529  N   GLN D 104      17.662  -8.533  56.621  1.00 32.06           N  
ATOM   4530  CA  GLN D 104      17.782  -7.569  57.702  1.00 32.86           C  
ATOM   4531  C   GLN D 104      16.462  -6.823  57.889  1.00 32.37           C  
ATOM   4532  O   GLN D 104      15.792  -6.490  56.923  1.00 31.60           O  
ATOM   4533  CB  GLN D 104      18.896  -6.570  57.382  1.00 32.10           C  
ATOM   4534  CG  GLN D 104      20.265  -7.165  57.575  1.00 39.32           C  
ATOM   4535  CD  GLN D 104      21.349  -6.321  56.964  1.00 43.14           C  
ATOM   4536  OE1 GLN D 104      21.059  -5.401  56.203  1.00 47.89           O  
ATOM   4537  NE2 GLN D 104      22.603  -6.614  57.297  1.00 45.41           N  
ATOM   4538  N   ILE D 105      16.094  -6.584  59.141  1.00 32.58           N  
ATOM   4539  CA  ILE D 105      14.820  -5.954  59.495  1.00 32.32           C  
ATOM   4540  C   ILE D 105      15.141  -5.010  60.654  1.00 32.95           C  
ATOM   4541  O   ILE D 105      15.935  -5.369  61.549  1.00 32.34           O  
ATOM   4542  CB  ILE D 105      13.729  -7.045  59.893  1.00 32.73           C  
ATOM   4543  CG1 ILE D 105      13.540  -8.033  58.732  1.00 32.44           C  
ATOM   4544  CG2 ILE D 105      12.344  -6.385  60.278  1.00 32.75           C  
ATOM   4545  CD1 ILE D 105      12.407  -9.021  58.891  1.00 32.75           C  
ATOM   4546  N   ASN D 106      14.560  -3.808  60.601  1.00 33.29           N  
ATOM   4547  CA  ASN D 106      14.720  -2.771  61.611  1.00 33.83           C  
ATOM   4548  C   ASN D 106      13.440  -2.779  62.392  1.00 33.63           C  
ATOM   4549  O   ASN D 106      12.387  -2.855  61.818  1.00 34.14           O  
ATOM   4550  CB  ASN D 106      14.933  -1.401  60.971  1.00 33.96           C  
ATOM   4551  CG  ASN D 106      16.312  -1.259  60.291  1.00 36.04           C  
ATOM   4552  OD1 ASN D 106      17.309  -1.773  60.771  1.00 37.46           O  
ATOM   4553  ND2 ASN D 106      16.358  -0.517  59.188  1.00 36.80           N  
ATOM   4554  N   VAL D 107      13.550  -2.750  63.710  1.00 34.42           N  
ATOM   4555  CA  VAL D 107      12.434  -2.903  64.624  1.00 34.27           C  
ATOM   4556  C   VAL D 107      12.463  -1.725  65.625  1.00 34.73           C  
ATOM   4557  O   VAL D 107      13.501  -1.440  66.207  1.00 33.49           O  
ATOM   4558  CB  VAL D 107      12.537  -4.249  65.370  1.00 34.48           C  
ATOM   4559  CG1 VAL D 107      11.426  -4.369  66.393  1.00 35.58           C  
ATOM   4560  CG2 VAL D 107      12.468  -5.409  64.399  1.00 34.18           C  
ATOM   4561  N   PRO D 108      11.325  -1.040  65.828  1.00 35.87           N  
ATOM   4562  CA  PRO D 108      11.378   0.120  66.720  1.00 37.04           C  
ATOM   4563  C   PRO D 108      11.928  -0.303  68.064  1.00 38.45           C  
ATOM   4564  O   PRO D 108      11.611  -1.396  68.525  1.00 38.49           O  
ATOM   4565  CB  PRO D 108       9.909   0.532  66.866  1.00 37.15           C  
ATOM   4566  CG  PRO D 108       9.234  -0.014  65.696  1.00 36.46           C  
ATOM   4567  CD  PRO D 108       9.970  -1.270  65.300  1.00 36.50           C  
ATOM   4568  N   GLU D 109      12.761   0.548  68.665  1.00 40.64           N  
ATOM   4569  CA  GLU D 109      13.394   0.309  69.975  1.00 42.96           C  
ATOM   4570  C   GLU D 109      12.412  -0.037  71.101  1.00 44.75           C  
ATOM   4571  O   GLU D 109      12.718  -0.844  71.981  1.00 45.21           O  
ATOM   4572  CB  GLU D 109      14.193   1.546  70.384  1.00 42.77           C  
ATOM   4573  CG  GLU D 109      15.681   1.448  70.097  1.00 44.16           C  
ATOM   4574  CD  GLU D 109      16.351   2.805  69.912  1.00 44.64           C  
ATOM   4575  OE1 GLU D 109      15.798   3.817  70.401  1.00 46.64           O  
ATOM   4576  OE2 GLU D 109      17.433   2.851  69.266  1.00 43.59           O  
ATOM   4577  N   ASP D 110      11.242   0.594  71.071  1.00 46.77           N  
ATOM   4578  CA  ASP D 110      10.193   0.439  72.093  1.00 48.95           C  
ATOM   4579  C   ASP D 110       9.609  -0.978  72.221  1.00 49.86           C  
ATOM   4580  O   ASP D 110       9.295  -1.428  73.326  1.00 50.28           O  
ATOM   4581  CB  ASP D 110       9.052   1.420  71.777  1.00 49.07           C  
ATOM   4582  CG  ASP D 110       8.891   1.659  70.266  1.00 49.89           C  
ATOM   4583  OD1 ASP D 110       9.771   2.337  69.682  1.00 50.17           O  
ATOM   4584  OD2 ASP D 110       7.898   1.173  69.662  1.00 51.00           O  
ATOM   4585  N   ASN D 111       9.498  -1.670  71.091  1.00 51.25           N  
ATOM   4586  CA  ASN D 111       8.568  -2.787  70.920  1.00 52.58           C  
ATOM   4587  C   ASN D 111       9.121  -4.195  71.160  1.00 53.66           C  
ATOM   4588  O   ASN D 111       9.691  -4.822  70.250  1.00 53.71           O  
ATOM   4589  CB  ASN D 111       7.977  -2.703  69.518  1.00 52.75           C  
ATOM   4590  CG  ASN D 111       6.770  -3.584  69.338  1.00 52.93           C  
ATOM   4591  OD1 ASN D 111       6.137  -3.530  68.289  1.00 53.67           O  
ATOM   4592  ND2 ASN D 111       6.442  -4.405  70.345  1.00 51.40           N  
ATOM   4593  N   ASP D 112       8.903  -4.707  72.370  1.00 54.78           N  
ATOM   4594  CA  ASP D 112       9.500  -5.972  72.785  1.00 55.82           C  
ATOM   4595  C   ASP D 112       8.815  -7.215  72.224  1.00 56.29           C  
ATOM   4596  O   ASP D 112       9.480  -8.230  71.979  1.00 56.43           O  
ATOM   4597  CB  ASP D 112       9.616  -6.033  74.311  1.00 56.31           C  
ATOM   4598  CG  ASP D 112      10.517  -4.926  74.879  1.00 57.42           C  
ATOM   4599  OD1 ASP D 112      10.810  -4.977  76.097  1.00 58.34           O  
ATOM   4600  OD2 ASP D 112      10.926  -4.010  74.113  1.00 57.80           O  
HETATM 4601  N   MSE D 113       7.504  -7.132  72.017  1.00 56.77           N  
HETATM 4602  CA  MSE D 113       6.738  -8.250  71.470  1.00 57.27           C  
HETATM 4603  C   MSE D 113       7.272  -8.651  70.109  1.00 55.50           C  
HETATM 4604  O   MSE D 113       7.535  -9.834  69.856  1.00 55.82           O  
HETATM 4605  CB  MSE D 113       5.245  -7.912  71.348  1.00 59.66           C  
HETATM 4606  CG  MSE D 113       4.528  -7.690  72.671  1.00 64.06           C  
HETATM 4607 SE   MSE D 113       5.016  -9.097  73.923  1.00 78.53          SE  
HETATM 4608  CE  MSE D 113       4.209  -8.393  75.577  1.00 68.24           C  
ATOM   4609  N   VAL D 114       7.419  -7.670  69.227  1.00 52.82           N  
ATOM   4610  CA  VAL D 114       7.986  -7.953  67.920  1.00 50.48           C  
ATOM   4611  C   VAL D 114       9.481  -8.328  68.032  1.00 48.67           C  
ATOM   4612  O   VAL D 114       9.919  -9.251  67.361  1.00 47.99           O  
ATOM   4613  CB  VAL D 114       7.663  -6.846  66.873  1.00 50.36           C  
ATOM   4614  CG1 VAL D 114       8.494  -5.619  67.097  1.00 51.24           C  
ATOM   4615  CG2 VAL D 114       7.855  -7.358  65.457  1.00 50.33           C  
ATOM   4616  N   LEU D 115      10.232  -7.664  68.914  1.00 46.61           N  
ATOM   4617  CA  LEU D 115      11.640  -8.019  69.150  1.00 44.94           C  
ATOM   4618  C   LEU D 115      11.842  -9.487  69.560  1.00 43.73           C  
ATOM   4619  O   LEU D 115      12.637 -10.200  68.951  1.00 43.19           O  
ATOM   4620  CB  LEU D 115      12.282  -7.084  70.168  1.00 44.61           C  
ATOM   4621  CG  LEU D 115      12.748  -5.762  69.568  1.00 45.39           C  
ATOM   4622  CD1 LEU D 115      13.163  -4.803  70.676  1.00 44.27           C  
ATOM   4623  CD2 LEU D 115      13.892  -5.963  68.545  1.00 45.88           C  
ATOM   4624  N   GLY D 116      11.086  -9.934  70.557  1.00 42.26           N  
ATOM   4625  CA  GLY D 116      11.109 -11.325  70.991  1.00 41.03           C  
ATOM   4626  C   GLY D 116      10.689 -12.274  69.882  1.00 40.16           C  
ATOM   4627  O   GLY D 116      11.352 -13.303  69.688  1.00 39.81           O  
HETATM 4628  N   MSE D 117       9.601 -11.922  69.172  1.00 38.87           N  
HETATM 4629  CA  MSE D 117       9.111 -12.666  67.976  1.00 38.48           C  
HETATM 4630  C   MSE D 117      10.242 -12.948  67.005  1.00 35.19           C  
HETATM 4631  O   MSE D 117      10.456 -14.096  66.664  1.00 33.83           O  
HETATM 4632  CB  MSE D 117       7.907 -11.976  67.216  1.00 38.38           C  
HETATM 4633  CG  MSE D 117       7.862 -12.249  65.608  1.00 39.43           C  
HETATM 4634 SE   MSE D 117       6.326 -11.821  64.341  0.65 44.83          SE  
HETATM 4635  CE  MSE D 117       7.026 -12.143  62.569  1.00 39.60           C  
ATOM   4636  N   TYR D 118      10.942 -11.897  66.553  1.00 33.72           N  
ATOM   4637  CA  TYR D 118      12.023 -12.037  65.561  1.00 32.66           C  
ATOM   4638  C   TYR D 118      13.162 -12.897  66.070  1.00 32.32           C  
ATOM   4639  O   TYR D 118      13.790 -13.650  65.310  1.00 31.63           O  
ATOM   4640  CB  TYR D 118      12.570 -10.682  65.107  1.00 31.33           C  
ATOM   4641  CG  TYR D 118      11.710 -10.088  64.031  1.00 30.00           C  
ATOM   4642  CD1 TYR D 118      11.592 -10.728  62.779  1.00 27.60           C  
ATOM   4643  CD2 TYR D 118      10.969  -8.940  64.265  1.00 27.12           C  
ATOM   4644  CE1 TYR D 118      10.773 -10.237  61.803  1.00 28.12           C  
ATOM   4645  CE2 TYR D 118      10.128  -8.424  63.260  1.00 27.67           C  
ATOM   4646  CZ  TYR D 118      10.028  -9.095  62.049  1.00 30.23           C  
ATOM   4647  OH  TYR D 118       9.240  -8.597  61.033  1.00 33.73           O  
ATOM   4648  N   GLU D 119      13.428 -12.759  67.356  1.00 31.67           N  
ATOM   4649  CA  GLU D 119      14.472 -13.518  67.988  1.00 32.41           C  
ATOM   4650  C   GLU D 119      14.127 -15.009  68.048  1.00 32.14           C  
ATOM   4651  O   GLU D 119      14.972 -15.842  67.758  1.00 31.49           O  
ATOM   4652  CB  GLU D 119      14.852 -12.873  69.318  1.00 32.86           C  
ATOM   4653  CG  GLU D 119      15.624 -11.560  68.992  1.00 37.12           C  
ATOM   4654  CD  GLU D 119      16.196 -10.854  70.203  1.00 43.41           C  
ATOM   4655  OE1 GLU D 119      15.743 -11.148  71.334  1.00 43.25           O  
ATOM   4656  OE2 GLU D 119      17.108 -10.004  70.006  1.00 46.72           O  
ATOM   4657  N   ARG D 120      12.874 -15.338  68.361  1.00 32.45           N  
ATOM   4658  CA  ARG D 120      12.395 -16.715  68.225  1.00 33.05           C  
ATOM   4659  C   ARG D 120      12.560 -17.259  66.811  1.00 32.26           C  
ATOM   4660  O   ARG D 120      12.683 -18.469  66.634  1.00 32.32           O  
ATOM   4661  CB  ARG D 120      10.940 -16.843  68.682  1.00 33.07           C  
ATOM   4662  CG  ARG D 120      10.799 -16.683  70.173  1.00 35.01           C  
ATOM   4663  CD  ARG D 120       9.351 -16.630  70.687  1.00 35.19           C  
ATOM   4664  NE  ARG D 120       9.287 -16.250  72.112  1.00 39.09           N  
ATOM   4665  CZ  ARG D 120       9.368 -17.102  73.148  1.00 41.59           C  
ATOM   4666  NH1 ARG D 120       9.300 -16.615  74.388  1.00 41.94           N  
ATOM   4667  NH2 ARG D 120       9.531 -18.425  72.968  1.00 39.55           N  
ATOM   4668  N   LEU D 121      12.601 -16.374  65.812  1.00 31.97           N  
ATOM   4669  CA  LEU D 121      12.747 -16.812  64.434  1.00 32.12           C  
ATOM   4670  C   LEU D 121      14.183 -16.887  63.956  1.00 32.01           C  
ATOM   4671  O   LEU D 121      14.440 -17.188  62.781  1.00 32.48           O  
ATOM   4672  CB  LEU D 121      11.913 -15.949  63.476  1.00 32.16           C  
ATOM   4673  CG  LEU D 121      10.422 -15.915  63.775  1.00 32.43           C  
ATOM   4674  CD1 LEU D 121       9.748 -14.947  62.835  1.00 31.32           C  
ATOM   4675  CD2 LEU D 121       9.780 -17.320  63.772  1.00 34.13           C  
ATOM   4676  N   GLY D 122      15.122 -16.621  64.858  1.00 31.13           N  
ATOM   4677  CA  GLY D 122      16.520 -16.849  64.569  1.00 29.69           C  
ATOM   4678  C   GLY D 122      17.209 -15.588  64.131  1.00 28.53           C  
ATOM   4679  O   GLY D 122      18.297 -15.644  63.620  1.00 27.72           O  
ATOM   4680  N   TYR D 123      16.564 -14.448  64.376  1.00 28.25           N  
ATOM   4681  CA  TYR D 123      17.068 -13.144  64.025  1.00 28.38           C  
ATOM   4682  C   TYR D 123      17.997 -12.609  65.136  1.00 28.96           C  
ATOM   4683  O   TYR D 123      17.717 -12.771  66.302  1.00 30.11           O  
ATOM   4684  CB  TYR D 123      15.915 -12.189  63.756  1.00 28.32           C  
ATOM   4685  CG  TYR D 123      15.278 -12.351  62.390  1.00 28.21           C  
ATOM   4686  CD1 TYR D 123      15.595 -11.487  61.349  1.00 26.69           C  
ATOM   4687  CD2 TYR D 123      14.326 -13.327  62.157  1.00 31.21           C  
ATOM   4688  CE1 TYR D 123      15.010 -11.614  60.122  1.00 28.91           C  
ATOM   4689  CE2 TYR D 123      13.705 -13.451  60.886  1.00 29.74           C  
ATOM   4690  CZ  TYR D 123      14.084 -12.600  59.882  1.00 29.60           C  
ATOM   4691  OH  TYR D 123      13.490 -12.707  58.624  1.00 30.12           O  
ATOM   4692  N   GLU D 124      19.104 -11.982  64.766  1.00 29.37           N  
ATOM   4693  CA  GLU D 124      20.085 -11.543  65.739  1.00 28.84           C  
ATOM   4694  C   GLU D 124      20.221 -10.041  65.669  1.00 27.69           C  
ATOM   4695  O   GLU D 124      20.427  -9.496  64.614  1.00 27.86           O  
ATOM   4696  CB  GLU D 124      21.446 -12.174  65.471  1.00 29.44           C  
ATOM   4697  CG  GLU D 124      21.894 -13.262  66.475  1.00 34.65           C  
ATOM   4698  CD  GLU D 124      22.517 -12.767  67.811  1.00 36.90           C  
ATOM   4699  OE1 GLU D 124      22.900 -11.577  68.048  1.00 37.30           O  
ATOM   4700  OE2 GLU D 124      22.654 -13.652  68.673  1.00 43.44           O  
ATOM   4701  N   HIS D 125      20.141  -9.383  66.814  1.00 27.67           N  
ATOM   4702  CA  HIS D 125      20.414  -7.951  66.922  1.00 26.79           C  
ATOM   4703  C   HIS D 125      21.877  -7.597  66.651  1.00 27.50           C  
ATOM   4704  O   HIS D 125      22.816  -8.130  67.287  1.00 25.61           O  
ATOM   4705  CB  HIS D 125      20.050  -7.492  68.337  1.00 27.75           C  
ATOM   4706  CG  HIS D 125      20.322  -6.042  68.594  1.00 26.72           C  
ATOM   4707  ND1 HIS D 125      20.673  -5.569  69.836  1.00 28.10           N  
ATOM   4708  CD2 HIS D 125      20.321  -4.968  67.769  1.00 26.35           C  
ATOM   4709  CE1 HIS D 125      20.845  -4.262  69.779  1.00 24.80           C  
ATOM   4710  NE2 HIS D 125      20.627  -3.871  68.537  1.00 24.69           N  
ATOM   4711  N   ALA D 126      22.038  -6.671  65.729  1.00 27.78           N  
ATOM   4712  CA  ALA D 126      23.319  -6.157  65.314  1.00 29.01           C  
ATOM   4713  C   ALA D 126      23.645  -4.853  66.062  1.00 29.39           C  
ATOM   4714  O   ALA D 126      22.811  -3.951  66.158  1.00 29.19           O  
ATOM   4715  CB  ALA D 126      23.258  -5.902  63.816  1.00 29.71           C  
ATOM   4716  N   ASP D 127      24.867  -4.724  66.559  1.00 30.17           N  
ATOM   4717  CA  ASP D 127      25.231  -3.515  67.329  1.00 31.38           C  
ATOM   4718  C   ASP D 127      25.606  -2.392  66.373  1.00 31.67           C  
ATOM   4719  O   ASP D 127      26.743  -1.932  66.330  1.00 32.04           O  
ATOM   4720  CB  ASP D 127      26.371  -3.781  68.306  1.00 31.09           C  
ATOM   4721  CG  ASP D 127      25.981  -4.729  69.412  1.00 31.39           C  
ATOM   4722  OD1 ASP D 127      24.801  -4.749  69.838  1.00 30.52           O  
ATOM   4723  OD2 ASP D 127      26.871  -5.474  69.843  1.00 32.29           O  
ATOM   4724  N   VAL D 128      24.626  -1.965  65.602  1.00 32.21           N  
ATOM   4725  CA  VAL D 128      24.817  -0.940  64.596  1.00 32.90           C  
ATOM   4726  C   VAL D 128      23.743   0.095  64.781  1.00 33.60           C  
ATOM   4727  O   VAL D 128      22.664  -0.189  65.325  1.00 33.84           O  
ATOM   4728  CB  VAL D 128      24.700  -1.501  63.184  1.00 32.23           C  
ATOM   4729  CG1 VAL D 128      25.909  -2.298  62.824  1.00 30.43           C  
ATOM   4730  CG2 VAL D 128      23.440  -2.373  63.067  1.00 33.89           C  
ATOM   4731  N   LEU D 129      24.043   1.293  64.324  1.00 33.95           N  
ATOM   4732  CA  LEU D 129      23.077   2.354  64.307  1.00 34.45           C  
ATOM   4733  C   LEU D 129      22.479   2.489  62.918  1.00 34.29           C  
ATOM   4734  O   LEU D 129      23.207   2.626  61.928  1.00 33.10           O  
ATOM   4735  CB  LEU D 129      23.747   3.649  64.752  1.00 34.42           C  
ATOM   4736  CG  LEU D 129      24.123   3.717  66.229  1.00 35.70           C  
ATOM   4737  CD1 LEU D 129      24.932   4.980  66.538  1.00 34.29           C  
ATOM   4738  CD2 LEU D 129      22.868   3.640  67.100  1.00 38.93           C  
ATOM   4739  N   SER D 130      21.146   2.424  62.848  1.00 35.23           N  
ATOM   4740  CA  SER D 130      20.411   2.640  61.605  1.00 35.14           C  
ATOM   4741  C   SER D 130      20.300   4.113  61.292  1.00 34.77           C  
ATOM   4742  O   SER D 130      19.603   4.860  62.002  1.00 35.16           O  
ATOM   4743  CB  SER D 130      19.004   2.037  61.669  1.00 36.13           C  
ATOM   4744  OG  SER D 130      18.373   2.126  60.372  1.00 38.37           O  
ATOM   4745  N   LEU D 131      20.988   4.546  60.246  1.00 33.77           N  
ATOM   4746  CA  LEU D 131      20.945   5.950  59.854  1.00 33.64           C  
ATOM   4747  C   LEU D 131      20.058   6.073  58.613  1.00 33.28           C  
ATOM   4748  O   LEU D 131      20.040   5.188  57.761  1.00 32.85           O  
ATOM   4749  CB  LEU D 131      22.354   6.463  59.566  1.00 33.98           C  
ATOM   4750  CG  LEU D 131      23.193   7.070  60.699  1.00 34.78           C  
ATOM   4751  CD1 LEU D 131      23.004   6.402  62.043  1.00 34.10           C  
ATOM   4752  CD2 LEU D 131      24.653   7.101  60.310  1.00 34.78           C  
ATOM   4753  N   GLY D 132      19.307   7.153  58.527  1.00 32.24           N  
ATOM   4754  CA  GLY D 132      18.366   7.307  57.432  1.00 31.84           C  
ATOM   4755  C   GLY D 132      18.378   8.708  56.879  1.00 31.22           C  
ATOM   4756  O   GLY D 132      18.642   9.666  57.600  1.00 31.23           O  
ATOM   4757  N   LYS D 133      18.068   8.840  55.602  1.00 30.44           N  
ATOM   4758  CA  LYS D 133      18.028  10.151  55.008  1.00 30.30           C  
ATOM   4759  C   LYS D 133      16.958  10.255  53.903  1.00 29.76           C  
ATOM   4760  O   LYS D 133      17.033   9.566  52.901  1.00 28.77           O  
ATOM   4761  CB  LYS D 133      19.443  10.494  54.532  1.00 31.33           C  
ATOM   4762  CG  LYS D 133      19.560  11.502  53.456  1.00 31.59           C  
ATOM   4763  CD  LYS D 133      19.174  12.801  53.965  1.00 33.86           C  
ATOM   4764  CE  LYS D 133      20.104  13.796  53.368  1.00 36.49           C  
ATOM   4765  NZ  LYS D 133      20.658  13.178  52.155  1.00 33.10           N  
ATOM   4766  N   ARG D 134      15.963  11.114  54.126  1.00 29.14           N  
ATOM   4767  CA  ARG D 134      14.803  11.255  53.222  1.00 29.35           C  
ATOM   4768  C   ARG D 134      15.219  11.891  51.896  1.00 29.24           C  
ATOM   4769  O   ARG D 134      15.843  12.927  51.890  1.00 28.60           O  
ATOM   4770  CB  ARG D 134      13.686  12.097  53.878  1.00 30.30           C  
ATOM   4771  CG  ARG D 134      12.309  12.037  53.154  1.00 30.08           C  
ATOM   4772  CD  ARG D 134      11.671  10.716  53.468  1.00 30.36           C  
ATOM   4773  NE  ARG D 134      10.622  10.342  52.524  1.00 34.25           N  
ATOM   4774  CZ  ARG D 134       9.751   9.369  52.750  1.00 35.91           C  
ATOM   4775  NH1 ARG D 134       8.817   9.093  51.837  1.00 39.45           N  
ATOM   4776  NH2 ARG D 134       9.807   8.660  53.890  1.00 35.10           N  
ATOM   4777  N   LEU D 135      14.864  11.271  50.773  1.00 29.09           N  
ATOM   4778  CA  LEU D 135      15.290  11.779  49.469  1.00 28.98           C  
ATOM   4779  C   LEU D 135      14.159  12.519  48.726  1.00 29.17           C  
ATOM   4780  O   LEU D 135      14.386  13.521  48.050  1.00 30.55           O  
ATOM   4781  CB  LEU D 135      15.894  10.629  48.628  1.00 28.40           C  
ATOM   4782  CG  LEU D 135      17.148   9.923  49.171  1.00 25.55           C  
ATOM   4783  CD1 LEU D 135      17.636   8.785  48.250  1.00 22.78           C  
ATOM   4784  CD2 LEU D 135      18.237  10.929  49.368  1.00 21.11           C  
ATOM   4785  N   ILE D 136      12.945  12.021  48.893  1.00 29.91           N  
ATOM   4786  CA  ILE D 136      11.726  12.542  48.268  1.00 31.03           C  
ATOM   4787  C   ILE D 136      10.714  12.541  49.398  1.00 31.99           C  
ATOM   4788  O   ILE D 136      10.430  11.470  49.987  1.00 32.62           O  
ATOM   4789  CB  ILE D 136      11.210  11.613  47.106  1.00 30.96           C  
ATOM   4790  CG1 ILE D 136      12.216  11.592  45.954  1.00 29.81           C  
ATOM   4791  CG2 ILE D 136       9.815  12.069  46.597  1.00 31.36           C  
ATOM   4792  CD1 ILE D 136      11.922  10.568  44.861  1.00 29.40           C  
ATOM   4793  N   GLU D 137      10.216  13.718  49.739  1.00 33.40           N  
ATOM   4794  CA  GLU D 137       9.279  13.850  50.839  1.00 35.30           C  
ATOM   4795  C   GLU D 137       7.855  13.422  50.411  1.00 35.57           C  
ATOM   4796  O   GLU D 137       7.349  13.871  49.373  1.00 35.92           O  
ATOM   4797  CB  GLU D 137       9.307  15.306  51.369  1.00 35.63           C  
ATOM   4798  CG  GLU D 137       8.801  15.503  52.818  1.00 39.92           C  
ATOM   4799  CD  GLU D 137       9.847  15.177  53.914  1.00 46.47           C  
ATOM   4800  OE1 GLU D 137      10.835  15.925  54.066  1.00 47.96           O  
ATOM   4801  OE2 GLU D 137       9.664  14.181  54.655  1.00 49.92           O  
ATOM   4802  N   ASP D 138       7.229  12.529  51.175  1.00 35.34           N  
ATOM   4803  CA  ASP D 138       5.800  12.271  51.002  1.00 36.21           C  
ATOM   4804  C   ASP D 138       4.989  13.320  51.796  1.00 38.59           C  
ATOM   4805  O   ASP D 138       5.546  14.076  52.601  1.00 38.01           O  
ATOM   4806  CB  ASP D 138       5.442  10.845  51.438  1.00 34.75           C  
ATOM   4807  CG  ASP D 138       5.904   9.791  50.433  1.00 32.69           C  
ATOM   4808  OD1 ASP D 138       6.233  10.171  49.291  1.00 31.64           O  
ATOM   4809  OD2 ASP D 138       5.885   8.585  50.762  1.00 30.24           O  
ATOM   4810  N   GLU D 139       3.683  13.372  51.557  1.00 41.42           N  
ATOM   4811  CA  GLU D 139       2.811  14.160  52.408  1.00 44.94           C  
ATOM   4812  C   GLU D 139       2.941  13.633  53.840  1.00 46.29           C  
ATOM   4813  O   GLU D 139       3.388  12.488  54.069  1.00 46.48           O  
ATOM   4814  CB  GLU D 139       1.359  14.069  51.937  1.00 44.58           C  
ATOM   4815  CG  GLU D 139       1.110  14.635  50.542  1.00 46.56           C  
ATOM   4816  CD  GLU D 139      -0.307  14.342  49.997  1.00 47.90           C  
ATOM   4817  OE1 GLU D 139      -1.256  14.159  50.815  1.00 51.97           O  
ATOM   4818  OE2 GLU D 139      -0.467  14.313  48.744  1.00 51.08           O  
ATOM   4819  N   GLU D 140       2.598  14.482  54.800  1.00 47.55           N  
ATOM   4820  CA  GLU D 140       2.340  14.039  56.155  1.00 49.27           C  
ATOM   4821  C   GLU D 140       0.799  13.887  56.208  1.00 50.57           C  
ATOM   4822  O   GLU D 140       0.089  14.739  56.758  1.00 51.57           O  
ATOM   4823  CB  GLU D 140       2.866  15.095  57.142  1.00 49.01           C  
ATOM   4824  CG  GLU D 140       3.141  14.607  58.559  1.00 48.68           C  
ATOM   4825  CD  GLU D 140       3.276  15.746  59.554  1.00 49.47           C  
ATOM   4826  OE1 GLU D 140       2.557  16.771  59.428  1.00 47.76           O  
ATOM   4827  OE2 GLU D 140       4.106  15.616  60.474  1.00 49.94           O  
ATOM   4828  N   TYR D 141       0.290  12.818  55.594  1.00 51.98           N  
ATOM   4829  CA  TYR D 141      -1.145  12.683  55.305  1.00 52.82           C  
ATOM   4830  C   TYR D 141      -1.686  11.270  55.584  1.00 53.16           C  
ATOM   4831  O   TYR D 141      -2.081  10.939  56.714  1.00 53.46           O  
ATOM   4832  CB  TYR D 141      -1.447  13.137  53.856  1.00 53.46           C  
ATOM   4833  CG  TYR D 141      -1.921  12.059  52.889  1.00 54.94           C  
ATOM   4834  CD1 TYR D 141      -3.232  12.059  52.405  1.00 55.69           C  
ATOM   4835  CD2 TYR D 141      -1.055  11.029  52.464  1.00 56.02           C  
ATOM   4836  CE1 TYR D 141      -3.675  11.066  51.512  1.00 56.51           C  
ATOM   4837  CE2 TYR D 141      -1.490  10.040  51.590  1.00 55.99           C  
ATOM   4838  CZ  TYR D 141      -2.797  10.062  51.115  1.00 55.85           C  
ATOM   4839  OH  TYR D 141      -3.211   9.075  50.251  1.00 55.93           O  
TER    4840      TYR D 141                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
