
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1308),  selected  171 , name 1ghe_B
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 1ghe_B.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     3_B      R      26          4.606
LGA    A     4_B      Y      27          1.670
LGA    Q     5_B      H      28          0.521
LGA    L     6_B      L      29          0.737
LGA    R     7_B      R      30          0.896
LGA    R     8_B      P      31          1.918
LGA    V     9_B      P      32          2.490
LGA    T    10_B      -       -           -
LGA    A    11_B      -       -           -
LGA    E    12_B      -       -           -
LGA    S    13_B      -       -           -
LGA    F    14_B      R      33          1.543
LGA    A    15_B      R      34          3.732
LGA    H    16_B      N      35          4.063
LGA    Y    17_B      D      36          2.161
LGA    R    18_B      G      37          2.636
LGA    H    19_B      A      38          2.954
LGA    G    20_B      A      39          1.985
LGA    L    21_B      I      40          0.642
LGA    A    22_B      H      41          1.378
LGA    Q    23_B      Q      42          1.324
LGA    L    24_B      L      43          0.935
LGA    L    25_B      V      44          0.951
LGA    F    26_B      S      45          0.589
LGA    E    27_B      E      46          0.654
LGA    T    28_B      C      47          1.352
LGA    V    29_B      P      48          2.882
LGA    H    30_B      -       -           -
LGA    G    31_B      -       -           -
LGA    G    32_B      P      49          2.227
LGA    A    33_B      L      50          3.218
LGA    S    34_B      -       -           -
LGA    V    35_B      -       -           -
LGA    G    36_B      D      51          3.352
LGA    F    37_B      L      52          3.638
LGA    X    38_B      N      53           -
LGA    A    39_B      -       -           -
LGA    D    40_B      -       -           -
LGA    L    41_B      -       -           -
LGA    D    42_B      -       -           -
LGA    X    43_B      -       -           -
LGA    Q    44_B      -       -           -
LGA    Q    45_B      S      54          3.049
LGA    A    46_B      L      55          3.652
LGA    Y    47_B      -       -           -
LGA    A    48_B      Y      56          2.465
LGA    W    49_B      A      57          2.472
LGA    C    50_B      Y      58          1.940
LGA    D    51_B      L      59          1.829
LGA    G    52_B      L      60          2.461
LGA    L    53_B      L      61          1.666
LGA    K    54_B      C      62          3.260
LGA    A    55_B      E      63          3.974
LGA    D    56_B      H      64          2.410
LGA    I    57_B      H      65          2.655
LGA    A    58_B      A      66           #
LGA    A    59_B      -       -           -
LGA    G    60_B      -       -           -
LGA    S    61_B      -       -           -
LGA    L    62_B      H      67           #
LGA    L    63_B      T      68          1.765
LGA    L    64_B      C      69          1.527
LGA    W    65_B      V      70          0.693
LGA    V    66_B      V      71          0.446
LGA    V    67_B      A      72          0.550
LGA    A    68_B      E      73          0.290
LGA    E    69_B      S      74          1.363
LGA    -       -      P      75           -
LGA    D    70_B      G      76          3.909
LGA    D    71_B      G      77          2.689
LGA    N    72_B      R      78          0.741
LGA    V    73_B      I      79          0.547
LGA    L    74_B      D      80          1.023
LGA    A    75_B      G      81          0.316
LGA    S    76_B      F      82          0.907
LGA    A    77_B      V      83          0.982
LGA    Q    78_B      S      84          2.219
LGA    L    79_B      A      85          2.161
LGA    S    80_B      Y      86          0.747
LGA    L    81_B      L      87          1.235
LGA    C    82_B      L      88          1.875
LGA    Q    83_B      P      89          2.276
LGA    K    84_B      T      90          2.592
LGA    P    85_B      -       -           -
LGA    N    86_B      -       -           -
LGA    G    87_B      R      91          1.740
LGA    L    88_B      P      92          2.274
LGA    N    89_B      D      93          1.847
LGA    R    90_B      V      94          1.541
LGA    A    91_B      L      95          1.940
LGA    E    92_B      F      96          0.680
LGA    V    93_B      V      97          1.370
LGA    Q    94_B      W      98          1.725
LGA    K    95_B      Q      99          1.214
LGA    L    96_B      V     100          1.300
LGA    X    97_B      A     101          1.018
LGA    V    98_B      V     102          0.493
LGA    L    99_B      H     103          0.538
LGA    P   100_B      S     104          1.630
LGA    S   101_B      R     105          1.825
LGA    A   102_B      A     106          0.970
LGA    R   103_B      R     107          2.095
LGA    G   104_B      G     108          2.711
LGA    R   105_B      H     109          1.346
LGA    G   106_B      R     110          1.363
LGA    L   107_B      L     111          0.866
LGA    G   108_B      G     112          0.916
LGA    R   109_B      R     113          1.153
LGA    Q   110_B      A     114          0.678
LGA    L   111_B      M     115          0.658
LGA    X   112_B      L     116          1.246
LGA    D   113_B      G     117          1.148
LGA    E   114_B      H     118          1.379
LGA    V   115_B      I     119          1.884
LGA    E   116_B      L     120          1.801
LGA    Q   117_B      E     121          1.605
LGA    V   118_B      R     122          2.083
LGA    -       -      Q     123           -
LGA    A   119_B      E     124          5.497
LGA    V   120_B      C     125          3.795
LGA    K   121_B      R     126          2.026
LGA    H   122_B      -       -           -
LGA    K   123_B      H     127          1.242
LGA    R   124_B      V     128          1.561
LGA    G   125_B      R     129          1.092
LGA    L   126_B      H     130          1.407
LGA    L   127_B      L     131          1.277
LGA    H   128_B      E     132          0.828
LGA    L   129_B      T     133          0.974
LGA    D   130_B      T     134          0.825
LGA    T   131_B      V     135          1.886
LGA    E   132_B      G     136          1.790
LGA    A   133_B      P     137          2.117
LGA    G   134_B      D     138          1.054
LGA    S   135_B      N     139          1.593
LGA    -       -      Q     140           -
LGA    V   136_B      A     141          3.185
LGA    A   137_B      S     142          1.522
LGA    E   138_B      R     143          2.376
LGA    A   139_B      R     144          3.014
LGA    F   140_B      T     145          2.477
LGA    Y   141_B      F     146          1.941
LGA    S   142_B      A     147          2.685
LGA    A   143_B      G     148          3.373
LGA    L   144_B      L     149          2.906
LGA    A   145_B      A     150          2.859
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    Y   146_B      H     156           #
LGA    T   147_B      V     157          1.075
LGA    R   148_B      S     158          2.960
LGA    V   149_B      E     159          1.871
LGA    G   150_B      Q     160          1.978
LGA    E   151_B      P     161          2.322
LGA    L   152_B      F     162          3.018
LGA    -       -      F     163           -
LGA    P   153_B      D     164          2.656
LGA    G   154_B      R     165          2.383
LGA    -       -      Q     166           -
LGA    -       -      A     167           -
LGA    Y   155_B      F     168          4.998
LGA    -       -      G     169           -
LGA    -       -      G     170           -
LGA    -       -      A     171           -
LGA    C   156_B      D     172           #
LGA    A   157_B      H     173          1.145
LGA    T   158_B      -       -           -
LGA    P   159_B      -       -           -
LGA    D   160_B      -       -           -
LGA    G   161_B      -       -           -
LGA    R   162_B      -       -           -
LGA    L   163_B      -       -           -
LGA    H   164_B      D     174          1.833
LGA    P   165_B      D     175          1.517
LGA    T   166_B      E     176          1.025
LGA    A   167_B      M     177          1.906
LGA    I   168_B      L     178          1.243
LGA    Y   169_B      L     179          1.158
LGA    F   170_B      R     180          1.528
LGA    K   171_B      I     181          1.660
LGA    T   172_B      G     182          1.588
LGA    -       -      P     183           -
LGA    L   173_B      F     184          1.715

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  159    5.0    139    2.10    13.67     64.380     6.308

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.877864 * X  +  -0.476066 * Y  +  -0.052122 * Z  +   8.442012
  Y_new =  -0.463514 * X  +   0.817220 * Y  +   0.342500 * Z  +  -4.913718
  Z_new =  -0.120458 * X  +   0.324827 * Y  +  -0.938071 * Z  +  73.429474 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.808243   -0.333350  [ DEG:   160.9005    -19.0995 ]
  Theta =   0.120751    3.020842  [ DEG:     6.9185    173.0815 ]
  Phi   =  -2.655795    0.485798  [ DEG:  -152.1658     27.8342 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ghe_B                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ghe_B.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  159   5.0  139   2.10   13.67  64.380
REMARK  ---------------------------------------------------------- 
MOLECULE 1ghe_B
HEADER    TRANSFERASE                             13-DEC-00   1GHE              
TITLE     CRYSTAL STRUCTURE OF TABTOXIN RESISTANCE PROTEIN COMPLEXED            
TITLE    2 WITH AN ACYL COENZYME A                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: TABTOXIN RESISTANCE PROTEIN;                                
COMPND   5 EC: 2.3.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS SYRINGAE PV. TABACI;                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PQE-30                                    
KEYWDS    ACYL COENZYME A COMPLEX                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.HE,Y.DING,M.BARTLAM,F.SUN,Y.LE,X.QIN,H.TANG,R.ZHANG,                
AUTHOR   2 A.JOACHIMIAK,Y.LIU,N.ZHAO,Z.RAO                                      
REVDAT   2   30-SEP-03 1GHE    1       DBREF                                    
REVDAT   1   14-JAN-03 1GHE    0                                                
JRNL        AUTH   H.HE,Y.DING,M.BARTLAM,F.SUN,Y.LE,X.QIN,H.TANG,               
JRNL        AUTH 2 R.ZHANG,A.JOACHIMIAK,Y.LIU,N.ZHAO,Z.RAO                      
JRNL        TITL   CRYSTAL STRUCTURE OF TABTOXIN RESISTANCE PROTEIN             
JRNL        TITL 2 COMPLEXED WITH ACETYL COENZYME A REVEALS THE                 
JRNL        TITL 3 MECHANISM FOR BETA-LACTAM ACETYLATION                        
JRNL        REF    J.MOL.BIOL.                   V. 325  1019 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.55 ANGSTROMS.                                          
DBREF  1GHE A    1   177  UNP    P16966   TTR_PSESZ        1    177             
DBREF  1GHE B    1   177  UNP    P16966   TTR_PSESZ        1    177             
SEQRES   1 A  177  MSE ASN HIS ALA GLN LEU ARG ARG VAL THR ALA GLU SER          
SEQRES   2 A  177  PHE ALA HIS TYR ARG HIS GLY LEU ALA GLN LEU LEU PHE          
SEQRES   3 A  177  GLU THR VAL HIS GLY GLY ALA SER VAL GLY PHE MSE ALA          
SEQRES   4 A  177  ASP LEU ASP MSE GLN GLN ALA TYR ALA TRP CYS ASP GLY          
SEQRES   5 A  177  LEU LYS ALA ASP ILE ALA ALA GLY SER LEU LEU LEU TRP          
SEQRES   6 A  177  VAL VAL ALA GLU ASP ASP ASN VAL LEU ALA SER ALA GLN          
SEQRES   7 A  177  LEU SER LEU CYS GLN LYS PRO ASN GLY LEU ASN ARG ALA          
SEQRES   8 A  177  GLU VAL GLN LYS LEU MSE VAL LEU PRO SER ALA ARG GLY          
SEQRES   9 A  177  ARG GLY LEU GLY ARG GLN LEU MSE ASP GLU VAL GLU GLN          
SEQRES  10 A  177  VAL ALA VAL LYS HIS LYS ARG GLY LEU LEU HIS LEU ASP          
SEQRES  11 A  177  THR GLU ALA GLY SER VAL ALA GLU ALA PHE TYR SER ALA          
SEQRES  12 A  177  LEU ALA TYR THR ARG VAL GLY GLU LEU PRO GLY TYR CYS          
SEQRES  13 A  177  ALA THR PRO ASP GLY ARG LEU HIS PRO THR ALA ILE TYR          
SEQRES  14 A  177  PHE LYS THR LEU GLY GLN PRO THR                              
SEQRES   1 B  177  MSE ASN HIS ALA GLN LEU ARG ARG VAL THR ALA GLU SER          
SEQRES   2 B  177  PHE ALA HIS TYR ARG HIS GLY LEU ALA GLN LEU LEU PHE          
SEQRES   3 B  177  GLU THR VAL HIS GLY GLY ALA SER VAL GLY PHE MSE ALA          
SEQRES   4 B  177  ASP LEU ASP MSE GLN GLN ALA TYR ALA TRP CYS ASP GLY          
SEQRES   5 B  177  LEU LYS ALA ASP ILE ALA ALA GLY SER LEU LEU LEU TRP          
SEQRES   6 B  177  VAL VAL ALA GLU ASP ASP ASN VAL LEU ALA SER ALA GLN          
SEQRES   7 B  177  LEU SER LEU CYS GLN LYS PRO ASN GLY LEU ASN ARG ALA          
SEQRES   8 B  177  GLU VAL GLN LYS LEU MSE VAL LEU PRO SER ALA ARG GLY          
SEQRES   9 B  177  ARG GLY LEU GLY ARG GLN LEU MSE ASP GLU VAL GLU GLN          
SEQRES  10 B  177  VAL ALA VAL LYS HIS LYS ARG GLY LEU LEU HIS LEU ASP          
SEQRES  11 B  177  THR GLU ALA GLY SER VAL ALA GLU ALA PHE TYR SER ALA          
SEQRES  12 B  177  LEU ALA TYR THR ARG VAL GLY GLU LEU PRO GLY TYR CYS          
SEQRES  13 B  177  ALA THR PRO ASP GLY ARG LEU HIS PRO THR ALA ILE TYR          
SEQRES  14 B  177  PHE LYS THR LEU GLY GLN PRO THR                              
HET    MSE  A  38       8                                                       
HET    MSE  A  43       8                                                       
HET    MSE  A  97       8                                                       
HET    MSE  A 112       8                                                       
HET    MSE  B  38       8                                                       
HET    MSE  B  43       8                                                       
HET    MSE  B  97       8                                                       
HET    MSE  B 112       8                                                       
HET    ACO    301      51                                                       
HET    ACO    302      51                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  ACO    2(C23 H38 N7 O17 P3 S)                                       
FORMUL   5  HOH   *162(H2 O)                                                    
CRYST1  101.760   45.700   84.240  90.00 105.79  90.00 C 1 2 1       8          
ATOM   1300  N   HIS B   3     -10.810 -19.690  53.967  1.00 19.68           N  
ATOM   1301  CA  HIS B   3      -9.586 -20.424  53.508  1.00 17.85           C  
ATOM   1302  C   HIS B   3      -8.483 -19.424  53.201  1.00 18.43           C  
ATOM   1303  O   HIS B   3      -8.430 -18.868  52.102  1.00 19.69           O  
ATOM   1304  CB  HIS B   3      -9.877 -21.235  52.239  1.00 19.89           C  
ATOM   1305  CG  HIS B   3      -8.737 -22.102  51.806  1.00 18.49           C  
ATOM   1306  ND1 HIS B   3      -8.150 -21.997  50.562  1.00 20.76           N  
ATOM   1307  CD2 HIS B   3      -8.064 -23.079  52.458  1.00 18.81           C  
ATOM   1308  CE1 HIS B   3      -7.162 -22.871  50.467  1.00 20.18           C  
ATOM   1309  NE2 HIS B   3      -7.090 -23.540  51.604  1.00 21.90           N  
ATOM   1310  N   ALA B   4      -7.602 -19.208  54.170  1.00 15.77           N  
ATOM   1311  CA  ALA B   4      -6.516 -18.250  54.000  1.00 14.56           C  
ATOM   1312  C   ALA B   4      -5.353 -18.920  53.277  1.00 14.46           C  
ATOM   1313  O   ALA B   4      -5.009 -20.086  53.559  1.00 15.23           O  
ATOM   1314  CB  ALA B   4      -6.070 -17.720  55.378  1.00 14.81           C  
ATOM   1315  N   GLN B   5      -4.759 -18.213  52.318  1.00 12.65           N  
ATOM   1316  CA  GLN B   5      -3.638 -18.788  51.582  1.00 13.40           C  
ATOM   1317  C   GLN B   5      -2.541 -17.766  51.456  1.00 13.52           C  
ATOM   1318  O   GLN B   5      -2.813 -16.566  51.330  1.00 12.11           O  
ATOM   1319  CB  GLN B   5      -4.003 -19.166  50.143  1.00 12.70           C  
ATOM   1320  CG  GLN B   5      -5.160 -20.078  49.933  1.00 13.86           C  
ATOM   1321  CD  GLN B   5      -5.457 -20.173  48.438  1.00 17.01           C  
ATOM   1322  OE1 GLN B   5      -4.767 -20.882  47.689  1.00 17.53           O  
ATOM   1323  NE2 GLN B   5      -6.450 -19.421  47.994  1.00 19.10           N  
ATOM   1324  N   LEU B   6      -1.314 -18.265  51.472  1.00 11.69           N  
ATOM   1325  CA  LEU B   6      -0.140 -17.430  51.293  1.00 14.20           C  
ATOM   1326  C   LEU B   6       0.089 -17.379  49.786  1.00 13.44           C  
ATOM   1327  O   LEU B   6       0.257 -18.425  49.132  1.00 14.84           O  
ATOM   1328  CB  LEU B   6       1.066 -18.067  52.004  1.00 14.78           C  
ATOM   1329  CG  LEU B   6       2.469 -17.584  51.612  1.00 19.68           C  
ATOM   1330  CD1 LEU B   6       2.631 -16.127  51.920  1.00 18.80           C  
ATOM   1331  CD2 LEU B   6       3.512 -18.421  52.370  1.00 21.72           C  
ATOM   1332  N   ARG B   7       0.101 -16.184  49.215  1.00 12.82           N  
ATOM   1333  CA  ARG B   7       0.314 -16.054  47.791  1.00 11.99           C  
ATOM   1334  C   ARG B   7       1.398 -15.026  47.498  1.00 12.76           C  
ATOM   1335  O   ARG B   7       1.461 -13.973  48.160  1.00 12.74           O  
ATOM   1336  CB  ARG B   7      -0.956 -15.570  47.058  1.00 14.73           C  
ATOM   1337  CG  ARG B   7      -2.271 -16.268  47.388  1.00 14.76           C  
ATOM   1338  CD  ARG B   7      -2.313 -17.694  46.878  1.00 17.65           C  
ATOM   1339  NE  ARG B   7      -2.184 -17.860  45.421  1.00 15.04           N  
ATOM   1340  CZ  ARG B   7      -3.177 -17.740  44.529  1.00 16.63           C  
ATOM   1341  NH1 ARG B   7      -4.409 -17.427  44.902  1.00 18.37           N  
ATOM   1342  NH2 ARG B   7      -2.947 -18.018  43.256  1.00 16.41           N  
ATOM   1343  N   ARG B   8       2.236 -15.347  46.515  1.00 11.96           N  
ATOM   1344  CA  ARG B   8       3.256 -14.419  46.034  1.00 13.07           C  
ATOM   1345  C   ARG B   8       2.491 -13.589  44.991  1.00 14.33           C  
ATOM   1346  O   ARG B   8       1.902 -14.148  44.044  1.00 14.67           O  
ATOM   1347  CB  ARG B   8       4.388 -15.191  45.371  1.00 15.74           C  
ATOM   1348  CG  ARG B   8       5.269 -14.350  44.475  1.00 18.94           C  
ATOM   1349  CD  ARG B   8       6.445 -13.752  45.202  1.00 19.25           C  
ATOM   1350  NE  ARG B   8       7.308 -13.065  44.241  1.00 20.97           N  
ATOM   1351  CZ  ARG B   8       8.368 -13.599  43.640  1.00 23.38           C  
ATOM   1352  NH1 ARG B   8       8.742 -14.846  43.895  1.00 22.65           N  
ATOM   1353  NH2 ARG B   8       9.058 -12.874  42.769  1.00 22.82           N  
ATOM   1354  N   VAL B   9       2.474 -12.269  45.166  1.00 10.60           N  
ATOM   1355  CA  VAL B   9       1.766 -11.383  44.258  1.00 12.82           C  
ATOM   1356  C   VAL B   9       2.589 -11.119  42.993  1.00 15.78           C  
ATOM   1357  O   VAL B   9       3.805 -10.905  43.059  1.00 16.47           O  
ATOM   1358  CB  VAL B   9       1.412 -10.049  44.993  1.00 12.47           C  
ATOM   1359  CG1 VAL B   9       0.681  -9.090  44.051  1.00 14.28           C  
ATOM   1360  CG2 VAL B   9       0.511 -10.355  46.188  1.00 13.21           C  
ATOM   1361  N   THR B  10       1.941 -11.168  41.832  1.00 15.95           N  
ATOM   1362  CA  THR B  10       2.648 -10.926  40.584  1.00 18.49           C  
ATOM   1363  C   THR B  10       2.142  -9.623  40.008  1.00 19.04           C  
ATOM   1364  O   THR B  10       1.187  -9.051  40.520  1.00 18.48           O  
ATOM   1365  CB  THR B  10       2.360 -12.032  39.561  1.00 18.32           C  
ATOM   1366  OG1 THR B  10       0.974 -11.986  39.194  1.00 17.96           O  
ATOM   1367  CG2 THR B  10       2.680 -13.406  40.157  1.00 19.88           C  
ATOM   1368  N   ALA B  11       2.779  -9.142  38.947  1.00 19.96           N  
ATOM   1369  CA  ALA B  11       2.309  -7.911  38.337  1.00 21.93           C  
ATOM   1370  C   ALA B  11       0.872  -8.110  37.849  1.00 22.65           C  
ATOM   1371  O   ALA B  11       0.042  -7.204  37.940  1.00 23.25           O  
ATOM   1372  CB  ALA B  11       3.213  -7.519  37.173  1.00 22.70           C  
ATOM   1373  N   GLU B  12       0.565  -9.310  37.365  1.00 24.08           N  
ATOM   1374  CA  GLU B  12      -0.773  -9.604  36.868  1.00 24.38           C  
ATOM   1375  C   GLU B  12      -1.840  -9.756  37.953  1.00 24.04           C  
ATOM   1376  O   GLU B  12      -3.001  -9.383  37.756  1.00 25.35           O  
ATOM   1377  CB  GLU B  12      -0.756 -10.882  36.016  1.00 27.18           C  
ATOM   1378  CG  GLU B  12       0.124 -10.819  34.757  1.00 32.13           C  
ATOM   1379  CD  GLU B  12       1.620 -10.898  35.055  1.00 35.63           C  
ATOM   1380  OE1 GLU B  12       2.009 -11.374  36.152  1.00 38.36           O  
ATOM   1381  OE2 GLU B  12       2.420 -10.495  34.177  1.00 39.40           O  
ATOM   1382  N   SER B  13      -1.468 -10.289  39.109  1.00 21.47           N  
ATOM   1383  CA  SER B  13      -2.469 -10.489  40.145  1.00 18.99           C  
ATOM   1384  C   SER B  13      -2.573  -9.336  41.108  1.00 17.81           C  
ATOM   1385  O   SER B  13      -3.468  -9.330  41.942  1.00 17.20           O  
ATOM   1386  CB  SER B  13      -2.171 -11.761  40.944  1.00 18.75           C  
ATOM   1387  OG  SER B  13      -0.956 -11.620  41.675  1.00 18.60           O  
ATOM   1388  N   PHE B  14      -1.680  -8.359  40.971  1.00 17.09           N  
ATOM   1389  CA  PHE B  14      -1.658  -7.219  41.884  1.00 16.22           C  
ATOM   1390  C   PHE B  14      -3.005  -6.536  42.017  1.00 17.47           C  
ATOM   1391  O   PHE B  14      -3.469  -6.278  43.129  1.00 17.77           O  
ATOM   1392  CB  PHE B  14      -0.615  -6.181  41.454  1.00 15.06           C  
ATOM   1393  CG  PHE B  14      -0.418  -5.102  42.471  1.00 16.34           C  
ATOM   1394  CD1 PHE B  14       0.462  -5.287  43.534  1.00 16.08           C  
ATOM   1395  CD2 PHE B  14      -1.172  -3.938  42.418  1.00 15.32           C  
ATOM   1396  CE1 PHE B  14       0.586  -4.331  44.544  1.00 17.45           C  
ATOM   1397  CE2 PHE B  14      -1.061  -2.966  43.425  1.00 16.98           C  
ATOM   1398  CZ  PHE B  14      -0.187  -3.160  44.483  1.00 17.83           C  
ATOM   1399  N   ALA B  15      -3.634  -6.250  40.877  1.00 17.31           N  
ATOM   1400  CA  ALA B  15      -4.930  -5.573  40.852  1.00 19.78           C  
ATOM   1401  C   ALA B  15      -5.958  -6.184  41.775  1.00 18.72           C  
ATOM   1402  O   ALA B  15      -6.781  -5.474  42.350  1.00 19.58           O  
ATOM   1403  CB  ALA B  15      -5.487  -5.557  39.415  1.00 19.85           C  
ATOM   1404  N   HIS B  16      -5.917  -7.505  41.909  1.00 18.94           N  
ATOM   1405  CA  HIS B  16      -6.867  -8.240  42.734  1.00 20.18           C  
ATOM   1406  C   HIS B  16      -6.688  -7.996  44.245  1.00 19.26           C  
ATOM   1407  O   HIS B  16      -7.637  -8.122  45.027  1.00 18.99           O  
ATOM   1408  CB  HIS B  16      -6.722  -9.743  42.420  1.00 23.89           C  
ATOM   1409  CG  HIS B  16      -7.677 -10.625  43.163  1.00 28.70           C  
ATOM   1410  ND1 HIS B  16      -9.039 -10.596  42.952  1.00 31.21           N  
ATOM   1411  CD2 HIS B  16      -7.464 -11.568  44.112  1.00 31.46           C  
ATOM   1412  CE1 HIS B  16      -9.626 -11.482  43.739  1.00 32.39           C  
ATOM   1413  NE2 HIS B  16      -8.692 -12.086  44.453  1.00 32.83           N  
ATOM   1414  N   TYR B  17      -5.478  -7.630  44.644  1.00 17.24           N  
ATOM   1415  CA  TYR B  17      -5.162  -7.454  46.063  1.00 15.49           C  
ATOM   1416  C   TYR B  17      -5.038  -6.011  46.476  1.00 14.93           C  
ATOM   1417  O   TYR B  17      -4.916  -5.703  47.663  1.00 14.98           O  
ATOM   1418  CB  TYR B  17      -3.840  -8.140  46.371  1.00 15.97           C  
ATOM   1419  CG  TYR B  17      -3.905  -9.617  46.175  1.00 15.36           C  
ATOM   1420  CD1 TYR B  17      -3.126 -10.244  45.211  1.00 16.44           C  
ATOM   1421  CD2 TYR B  17      -4.805 -10.377  46.905  1.00 14.41           C  
ATOM   1422  CE1 TYR B  17      -3.253 -11.598  44.979  1.00 16.43           C  
ATOM   1423  CE2 TYR B  17      -4.946 -11.729  46.684  1.00 17.00           C  
ATOM   1424  CZ  TYR B  17      -4.176 -12.335  45.718  1.00 16.70           C  
ATOM   1425  OH  TYR B  17      -4.379 -13.672  45.484  1.00 19.16           O  
ATOM   1426  N   ARG B  18      -5.054  -5.130  45.485  1.00 13.78           N  
ATOM   1427  CA  ARG B  18      -4.908  -3.701  45.721  1.00 14.80           C  
ATOM   1428  C   ARG B  18      -5.776  -3.106  46.821  1.00 13.59           C  
ATOM   1429  O   ARG B  18      -5.259  -2.367  47.664  1.00 13.58           O  
ATOM   1430  CB  ARG B  18      -5.142  -2.942  44.410  1.00 16.16           C  
ATOM   1431  CG  ARG B  18      -5.002  -1.434  44.514  1.00 16.95           C  
ATOM   1432  CD  ARG B  18      -4.893  -0.827  43.112  1.00 23.69           C  
ATOM   1433  NE  ARG B  18      -4.779   0.632  43.095  1.00 25.52           N  
ATOM   1434  CZ  ARG B  18      -5.802   1.470  43.265  1.00 25.92           C  
ATOM   1435  NH1 ARG B  18      -7.022   0.998  43.468  1.00 25.57           N  
ATOM   1436  NH2 ARG B  18      -5.602   2.782  43.213  1.00 27.09           N  
ATOM   1437  N   HIS B  19      -7.084  -3.376  46.799  1.00 12.62           N  
ATOM   1438  CA  HIS B  19      -7.968  -2.821  47.823  1.00 13.95           C  
ATOM   1439  C   HIS B  19      -7.602  -3.369  49.194  1.00 14.02           C  
ATOM   1440  O   HIS B  19      -7.505  -2.622  50.160  1.00 14.06           O  
ATOM   1441  CB  HIS B  19      -9.447  -3.130  47.525  1.00 15.26           C  
ATOM   1442  CG  HIS B  19     -10.068  -2.236  46.492  1.00 17.30           C  
ATOM   1443  ND1 HIS B  19     -10.736  -2.725  45.387  1.00 19.12           N  
ATOM   1444  CD2 HIS B  19     -10.118  -0.888  46.393  1.00 17.69           C  
ATOM   1445  CE1 HIS B  19     -11.164  -1.713  44.647  1.00 15.31           C  
ATOM   1446  NE2 HIS B  19     -10.800  -0.587  45.235  1.00 20.08           N  
ATOM   1447  N   GLY B  20      -7.386  -4.678  49.272  1.00 14.18           N  
ATOM   1448  CA  GLY B  20      -7.034  -5.274  50.542  1.00 11.62           C  
ATOM   1449  C   GLY B  20      -5.702  -4.761  51.069  1.00 11.97           C  
ATOM   1450  O   GLY B  20      -5.559  -4.603  52.282  1.00 12.14           O  
ATOM   1451  N   LEU B  21      -4.729  -4.517  50.192  1.00 10.97           N  
ATOM   1452  CA  LEU B  21      -3.418  -4.011  50.632  1.00 11.06           C  
ATOM   1453  C   LEU B  21      -3.520  -2.594  51.195  1.00 12.32           C  
ATOM   1454  O   LEU B  21      -2.916  -2.280  52.216  1.00 12.75           O  
ATOM   1455  CB  LEU B  21      -2.408  -4.034  49.490  1.00 14.32           C  
ATOM   1456  CG  LEU B  21      -1.876  -5.416  49.145  1.00 14.76           C  
ATOM   1457  CD1 LEU B  21      -1.164  -5.399  47.780  1.00 15.36           C  
ATOM   1458  CD2 LEU B  21      -0.897  -5.819  50.244  1.00 16.44           C  
ATOM   1459  N   ALA B  22      -4.308  -1.739  50.549  1.00 13.21           N  
ATOM   1460  CA  ALA B  22      -4.477  -0.372  51.052  1.00 12.78           C  
ATOM   1461  C   ALA B  22      -5.174  -0.405  52.398  1.00 12.09           C  
ATOM   1462  O   ALA B  22      -4.827   0.371  53.297  1.00 11.07           O  
ATOM   1463  CB  ALA B  22      -5.299   0.454  50.069  1.00 14.66           C  
ATOM   1464  N   GLN B  23      -6.155  -1.294  52.555  1.00 12.04           N  
ATOM   1465  CA  GLN B  23      -6.861  -1.398  53.824  1.00 12.70           C  
ATOM   1466  C   GLN B  23      -5.946  -1.913  54.934  1.00 12.82           C  
ATOM   1467  O   GLN B  23      -6.006  -1.437  56.070  1.00 11.12           O  
ATOM   1468  CB  GLN B  23      -8.072  -2.314  53.690  1.00 15.20           C  
ATOM   1469  CG  GLN B  23      -9.076  -1.779  52.703  1.00 21.01           C  
ATOM   1470  CD  GLN B  23      -9.993  -2.859  52.196  1.00 24.17           C  
ATOM   1471  OE1 GLN B  23      -9.945  -4.009  52.666  1.00 25.39           O  
ATOM   1472  NE2 GLN B  23     -10.842  -2.508  51.235  1.00 24.94           N  
ATOM   1473  N   LEU B  24      -5.099  -2.879  54.601  1.00 10.66           N  
ATOM   1474  CA  LEU B  24      -4.170  -3.427  55.587  1.00 10.38           C  
ATOM   1475  C   LEU B  24      -3.264  -2.308  56.122  1.00 10.21           C  
ATOM   1476  O   LEU B  24      -3.031  -2.200  57.343  1.00 10.46           O  
ATOM   1477  CB  LEU B  24      -3.328  -4.534  54.945  1.00 10.20           C  
ATOM   1478  CG  LEU B  24      -2.207  -5.117  55.811  1.00  9.68           C  
ATOM   1479  CD1 LEU B  24      -2.799  -5.767  57.089  1.00  9.38           C  
ATOM   1480  CD2 LEU B  24      -1.432  -6.148  54.993  1.00 13.00           C  
ATOM   1481  N   LEU B  25      -2.730  -1.498  55.217  1.00  9.91           N  
ATOM   1482  CA  LEU B  25      -1.876  -0.377  55.602  1.00 10.77           C  
ATOM   1483  C   LEU B  25      -2.666   0.585  56.492  1.00 11.25           C  
ATOM   1484  O   LEU B  25      -2.211   0.997  57.564  1.00 10.91           O  
ATOM   1485  CB  LEU B  25      -1.390   0.387  54.354  1.00 10.00           C  
ATOM   1486  CG  LEU B  25      -0.480   1.558  54.762  1.00 11.97           C  
ATOM   1487  CD1 LEU B  25       0.869   0.992  55.202  1.00 13.40           C  
ATOM   1488  CD2 LEU B  25      -0.265   2.539  53.601  1.00 11.91           C  
ATOM   1489  N   PHE B  26      -3.871   0.913  56.044  1.00 12.79           N  
ATOM   1490  CA  PHE B  26      -4.716   1.845  56.778  1.00 13.37           C  
ATOM   1491  C   PHE B  26      -4.986   1.341  58.187  1.00 14.94           C  
ATOM   1492  O   PHE B  26      -4.768   2.061  59.172  1.00 13.95           O  
ATOM   1493  CB  PHE B  26      -6.018   2.043  55.997  1.00 15.25           C  
ATOM   1494  CG  PHE B  26      -6.893   3.124  56.533  1.00 17.06           C  
ATOM   1495  CD1 PHE B  26      -6.730   4.444  56.101  1.00 16.82           C  
ATOM   1496  CD2 PHE B  26      -7.895   2.825  57.444  1.00 17.01           C  
ATOM   1497  CE1 PHE B  26      -7.571   5.461  56.575  1.00 18.65           C  
ATOM   1498  CE2 PHE B  26      -8.755   3.833  57.934  1.00 18.96           C  
ATOM   1499  CZ  PHE B  26      -8.590   5.152  57.494  1.00 16.68           C  
ATOM   1500  N   GLU B  27      -5.412   0.087  58.302  1.00 13.97           N  
ATOM   1501  CA  GLU B  27      -5.689  -0.465  59.611  1.00 14.56           C  
ATOM   1502  C   GLU B  27      -4.450  -0.559  60.485  1.00 15.10           C  
ATOM   1503  O   GLU B  27      -4.530  -0.362  61.699  1.00 15.79           O  
ATOM   1504  CB  GLU B  27      -6.351  -1.845  59.486  1.00 17.06           C  
ATOM   1505  CG  GLU B  27      -7.724  -1.786  58.825  1.00 20.38           C  
ATOM   1506  CD  GLU B  27      -8.716  -0.919  59.601  1.00 26.12           C  
ATOM   1507  OE1 GLU B  27      -9.629  -0.335  58.973  1.00 26.92           O  
ATOM   1508  OE2 GLU B  27      -8.593  -0.836  60.844  1.00 28.97           O  
ATOM   1509  N   THR B  28      -3.302  -0.848  59.874  1.00 13.11           N  
ATOM   1510  CA  THR B  28      -2.058  -0.988  60.639  1.00 12.17           C  
ATOM   1511  C   THR B  28      -1.563   0.361  61.161  1.00 12.32           C  
ATOM   1512  O   THR B  28      -1.151   0.484  62.329  1.00 13.85           O  
ATOM   1513  CB  THR B  28      -0.985  -1.676  59.776  1.00 12.59           C  
ATOM   1514  OG1 THR B  28      -1.452  -2.984  59.431  1.00 13.12           O  
ATOM   1515  CG2 THR B  28       0.334  -1.806  60.544  1.00 13.74           C  
ATOM   1516  N   VAL B  29      -1.640   1.392  60.328  1.00 11.94           N  
ATOM   1517  CA  VAL B  29      -1.192   2.715  60.749  1.00 12.41           C  
ATOM   1518  C   VAL B  29      -2.137   3.274  61.812  1.00 14.94           C  
ATOM   1519  O   VAL B  29      -1.690   3.815  62.837  1.00 14.00           O  
ATOM   1520  CB  VAL B  29      -1.171   3.674  59.569  1.00 13.23           C  
ATOM   1521  CG1 VAL B  29      -0.874   5.085  60.047  1.00 15.64           C  
ATOM   1522  CG2 VAL B  29      -0.141   3.233  58.566  1.00 14.30           C  
ATOM   1523  N   HIS B  30      -3.443   3.141  61.588  1.00 13.55           N  
ATOM   1524  CA  HIS B  30      -4.355   3.676  62.572  1.00 16.03           C  
ATOM   1525  C   HIS B  30      -4.447   2.835  63.827  1.00 17.30           C  
ATOM   1526  O   HIS B  30      -5.003   3.274  64.838  1.00 19.70           O  
ATOM   1527  CB  HIS B  30      -5.700   3.955  61.924  1.00 17.10           C  
ATOM   1528  CG  HIS B  30      -5.633   5.095  60.960  1.00 16.96           C  
ATOM   1529  ND1 HIS B  30      -5.332   6.380  61.361  1.00 19.34           N  
ATOM   1530  CD2 HIS B  30      -5.716   5.132  59.608  1.00 18.14           C  
ATOM   1531  CE1 HIS B  30      -5.232   7.158  60.296  1.00 20.30           C  
ATOM   1532  NE2 HIS B  30      -5.460   6.426  59.221  1.00 18.15           N  
ATOM   1533  N   GLY B  31      -3.854   1.644  63.760  1.00 16.95           N  
ATOM   1534  CA  GLY B  31      -3.792   0.759  64.901  1.00 18.53           C  
ATOM   1535  C   GLY B  31      -2.592   1.189  65.746  1.00 20.42           C  
ATOM   1536  O   GLY B  31      -2.334   0.623  66.812  1.00 21.23           O  
ATOM   1537  N   GLY B  32      -1.839   2.174  65.257  1.00 19.44           N  
ATOM   1538  CA  GLY B  32      -0.705   2.695  66.006  1.00 19.89           C  
ATOM   1539  C   GLY B  32       0.700   2.253  65.626  1.00 19.41           C  
ATOM   1540  O   GLY B  32       1.670   2.667  66.281  1.00 19.22           O  
ATOM   1541  N   ALA B  33       0.840   1.442  64.582  1.00 14.87           N  
ATOM   1542  CA  ALA B  33       2.163   0.999  64.184  1.00 15.35           C  
ATOM   1543  C   ALA B  33       2.918   2.022  63.351  1.00 15.45           C  
ATOM   1544  O   ALA B  33       2.324   2.791  62.602  1.00 16.17           O  
ATOM   1545  CB  ALA B  33       2.063  -0.297  63.412  1.00 16.90           C  
ATOM   1546  N   SER B  34       4.244   2.020  63.488  1.00 15.50           N  
ATOM   1547  CA  SER B  34       5.106   2.907  62.711  1.00 18.66           C  
ATOM   1548  C   SER B  34       5.547   2.147  61.462  1.00 19.61           C  
ATOM   1549  O   SER B  34       6.490   1.356  61.507  1.00 21.64           O  
ATOM   1550  CB  SER B  34       6.348   3.325  63.518  1.00 18.19           C  
ATOM   1551  OG  SER B  34       6.005   4.313  64.481  1.00 23.10           O  
ATOM   1552  N   VAL B  35       4.855   2.373  60.352  1.00 20.02           N  
ATOM   1553  CA  VAL B  35       5.193   1.709  59.105  1.00 18.98           C  
ATOM   1554  C   VAL B  35       5.332   2.705  57.960  1.00 19.22           C  
ATOM   1555  O   VAL B  35       4.944   2.425  56.827  1.00 21.87           O  
ATOM   1556  CB  VAL B  35       4.154   0.617  58.752  1.00 18.82           C  
ATOM   1557  CG1 VAL B  35       4.285  -0.560  59.715  1.00 19.10           C  
ATOM   1558  CG2 VAL B  35       2.756   1.182  58.867  1.00 17.40           C  
ATOM   1559  N   GLY B  36       5.873   3.882  58.276  1.00 17.53           N  
ATOM   1560  CA  GLY B  36       6.119   4.897  57.268  1.00 16.66           C  
ATOM   1561  C   GLY B  36       5.153   6.062  57.168  1.00 16.06           C  
ATOM   1562  O   GLY B  36       5.454   7.036  56.479  1.00 16.80           O  
ATOM   1563  N   PHE B  37       4.013   5.981  57.852  1.00 14.60           N  
ATOM   1564  CA  PHE B  37       3.002   7.028  57.766  1.00 14.73           C  
ATOM   1565  C   PHE B  37       2.562   7.622  59.097  1.00 16.84           C  
ATOM   1566  O   PHE B  37       2.872   7.097  60.168  1.00 17.06           O  
ATOM   1567  CB  PHE B  37       1.781   6.468  57.007  1.00 13.27           C  
ATOM   1568  CG  PHE B  37       2.129   5.954  55.644  1.00 13.19           C  
ATOM   1569  CD1 PHE B  37       2.604   4.646  55.476  1.00 14.47           C  
ATOM   1570  CD2 PHE B  37       2.084   6.802  54.538  1.00 15.41           C  
ATOM   1571  CE1 PHE B  37       3.040   4.187  54.219  1.00 15.74           C  
ATOM   1572  CE2 PHE B  37       2.514   6.359  53.276  1.00 16.10           C  
ATOM   1573  CZ  PHE B  37       2.994   5.047  53.121  1.00 15.88           C  
HETATM 1574  N   MSE B  38       1.816   8.719  59.015  1.00 17.62           N  
HETATM 1575  CA  MSE B  38       1.338   9.399  60.208  1.00 19.89           C  
HETATM 1576  C   MSE B  38      -0.158   9.211  60.373  1.00 20.12           C  
HETATM 1577  O   MSE B  38      -0.839   8.733  59.469  1.00 17.96           O  
HETATM 1578  CB  MSE B  38       1.642  10.890  60.105  1.00 23.69           C  
HETATM 1579  CG  MSE B  38       3.110  11.164  59.864  1.00 28.31           C  
HETATM 1580 SE   MSE B  38       4.111  10.627  61.415  1.00 32.62          SE  
HETATM 1581  CE  MSE B  38       4.555  12.405  62.020  1.00 32.15           C  
ATOM   1582  N   ALA B  39      -0.678   9.608  61.526  1.00 20.32           N  
ATOM   1583  CA  ALA B  39      -2.120   9.457  61.761  1.00 21.22           C  
ATOM   1584  C   ALA B  39      -2.982  10.254  60.792  1.00 21.86           C  
ATOM   1585  O   ALA B  39      -4.204  10.134  60.825  1.00 23.97           O  
ATOM   1586  CB  ALA B  39      -2.465   9.826  63.207  1.00 21.07           C  
ATOM   1587  N   ASP B  40      -2.365  11.066  59.937  1.00 22.86           N  
ATOM   1588  CA  ASP B  40      -3.119  11.840  58.950  1.00 24.73           C  
ATOM   1589  C   ASP B  40      -3.294  11.000  57.679  1.00 24.81           C  
ATOM   1590  O   ASP B  40      -3.724  11.496  56.628  1.00 24.79           O  
ATOM   1591  CB  ASP B  40      -2.395  13.150  58.603  1.00 27.74           C  
ATOM   1592  CG  ASP B  40      -1.084  12.923  57.874  1.00 31.03           C  
ATOM   1593  OD1 ASP B  40      -0.611  13.863  57.189  1.00 33.43           O  
ATOM   1594  OD2 ASP B  40      -0.517  11.815  57.991  1.00 33.09           O  
ATOM   1595  N   LEU B  41      -2.965   9.716  57.781  1.00 21.99           N  
ATOM   1596  CA  LEU B  41      -3.077   8.816  56.644  1.00 20.13           C  
ATOM   1597  C   LEU B  41      -4.511   8.632  56.195  1.00 18.98           C  
ATOM   1598  O   LEU B  41      -5.351   8.220  56.995  1.00 19.03           O  
ATOM   1599  CB  LEU B  41      -2.525   7.433  57.007  1.00 19.34           C  
ATOM   1600  CG  LEU B  41      -2.716   6.422  55.877  1.00 19.74           C  
ATOM   1601  CD1 LEU B  41      -1.754   6.749  54.749  1.00 17.95           C  
ATOM   1602  CD2 LEU B  41      -2.491   5.016  56.386  1.00 20.39           C  
ATOM   1603  N   ASP B  42      -4.798   8.958  54.936  1.00 19.34           N  
ATOM   1604  CA  ASP B  42      -6.132   8.733  54.402  1.00 18.14           C  
ATOM   1605  C   ASP B  42      -6.033   7.628  53.352  1.00 16.41           C  
ATOM   1606  O   ASP B  42      -4.928   7.157  53.019  1.00 15.17           O  
ATOM   1607  CB  ASP B  42      -6.765  10.007  53.807  1.00 18.55           C  
ATOM   1608  CG  ASP B  42      -5.969  10.613  52.670  1.00 21.63           C  
ATOM   1609  OD1 ASP B  42      -5.043   9.963  52.123  1.00 20.28           O  
ATOM   1610  OD2 ASP B  42      -6.290  11.776  52.314  1.00 23.07           O  
HETATM 1611  N   MSE B  43      -7.169   7.169  52.838  1.00 13.88           N  
HETATM 1612  CA  MSE B  43      -7.081   6.089  51.874  1.00 16.17           C  
HETATM 1613  C   MSE B  43      -6.395   6.503  50.579  1.00 15.45           C  
HETATM 1614  O   MSE B  43      -5.780   5.682  49.901  1.00 16.50           O  
HETATM 1615  CB  MSE B  43      -8.465   5.499  51.599  1.00 16.46           C  
HETATM 1616  CG  MSE B  43      -8.949   4.595  52.718  1.00 18.71           C  
HETATM 1617 SE   MSE B  43      -7.745   3.054  52.975  1.00 21.60          SE  
HETATM 1618  CE  MSE B  43      -8.104   2.092  51.354  1.00 20.24           C  
ATOM   1619  N   GLN B  44      -6.488   7.776  50.218  1.00 15.70           N  
ATOM   1620  CA  GLN B  44      -5.826   8.206  48.997  1.00 15.50           C  
ATOM   1621  C   GLN B  44      -4.322   7.931  49.105  1.00 14.91           C  
ATOM   1622  O   GLN B  44      -3.705   7.418  48.166  1.00 14.57           O  
ATOM   1623  CB  GLN B  44      -6.043   9.702  48.761  1.00 18.50           C  
ATOM   1624  CG  GLN B  44      -5.330  10.189  47.508  1.00 22.35           C  
ATOM   1625  CD  GLN B  44      -5.605  11.637  47.212  1.00 26.44           C  
ATOM   1626  OE1 GLN B  44      -5.409  12.504  48.071  1.00 29.66           O  
ATOM   1627  NE2 GLN B  44      -6.058  11.918  45.994  1.00 28.66           N  
ATOM   1628  N   GLN B  45      -3.751   8.260  50.255  1.00 14.36           N  
ATOM   1629  CA  GLN B  45      -2.312   8.050  50.451  1.00 15.79           C  
ATOM   1630  C   GLN B  45      -2.009   6.563  50.506  1.00 14.18           C  
ATOM   1631  O   GLN B  45      -0.940   6.128  50.059  1.00 13.31           O  
ATOM   1632  CB  GLN B  45      -1.853   8.741  51.743  1.00 19.20           C  
ATOM   1633  CG  GLN B  45      -0.361   8.645  52.003  1.00 24.62           C  
ATOM   1634  CD  GLN B  45       0.112   9.639  53.055  1.00 27.86           C  
ATOM   1635  OE1 GLN B  45      -0.587   9.913  54.041  1.00 28.42           O  
ATOM   1636  NE2 GLN B  45       1.312  10.180  52.850  1.00 28.83           N  
ATOM   1637  N   ALA B  46      -2.933   5.776  51.057  1.00 13.10           N  
ATOM   1638  CA  ALA B  46      -2.724   4.329  51.124  1.00 14.51           C  
ATOM   1639  C   ALA B  46      -2.723   3.722  49.716  1.00 14.92           C  
ATOM   1640  O   ALA B  46      -1.909   2.840  49.412  1.00 14.17           O  
ATOM   1641  CB  ALA B  46      -3.799   3.672  52.005  1.00 13.59           C  
ATOM   1642  N   TYR B  47      -3.623   4.186  48.849  1.00 14.90           N  
ATOM   1643  CA  TYR B  47      -3.658   3.683  47.487  1.00 15.21           C  
ATOM   1644  C   TYR B  47      -2.428   4.143  46.729  1.00 16.04           C  
ATOM   1645  O   TYR B  47      -1.934   3.429  45.859  1.00 15.95           O  
ATOM   1646  CB  TYR B  47      -4.945   4.135  46.756  1.00 14.76           C  
ATOM   1647  CG  TYR B  47      -6.134   3.273  47.103  1.00 16.17           C  
ATOM   1648  CD1 TYR B  47      -7.209   3.791  47.817  1.00 16.79           C  
ATOM   1649  CD2 TYR B  47      -6.165   1.922  46.753  1.00 16.60           C  
ATOM   1650  CE1 TYR B  47      -8.290   2.992  48.192  1.00 17.36           C  
ATOM   1651  CE2 TYR B  47      -7.247   1.105  47.122  1.00 15.52           C  
ATOM   1652  CZ  TYR B  47      -8.301   1.654  47.849  1.00 18.06           C  
ATOM   1653  OH  TYR B  47      -9.351   0.879  48.290  1.00 20.43           O  
ATOM   1654  N   ALA B  48      -1.924   5.331  47.051  1.00 16.02           N  
ATOM   1655  CA  ALA B  48      -0.716   5.844  46.393  1.00 15.34           C  
ATOM   1656  C   ALA B  48       0.452   4.894  46.724  1.00 16.32           C  
ATOM   1657  O   ALA B  48       1.282   4.581  45.865  1.00 16.61           O  
ATOM   1658  CB  ALA B  48      -0.404   7.233  46.911  1.00 16.08           C  
ATOM   1659  N   TRP B  49       0.507   4.448  47.978  1.00 15.78           N  
ATOM   1660  CA  TRP B  49       1.556   3.526  48.417  1.00 15.52           C  
ATOM   1661  C   TRP B  49       1.422   2.232  47.620  1.00 15.81           C  
ATOM   1662  O   TRP B  49       2.399   1.735  47.063  1.00 14.20           O  
ATOM   1663  CB  TRP B  49       1.433   3.247  49.922  1.00 15.31           C  
ATOM   1664  CG  TRP B  49       2.259   2.087  50.427  1.00 12.85           C  
ATOM   1665  CD1 TRP B  49       3.603   2.064  50.634  1.00 16.36           C  
ATOM   1666  CD2 TRP B  49       1.774   0.796  50.789  1.00 13.96           C  
ATOM   1667  NE1 TRP B  49       3.990   0.830  51.103  1.00 14.24           N  
ATOM   1668  CE2 TRP B  49       2.884   0.032  51.209  1.00 12.96           C  
ATOM   1669  CE3 TRP B  49       0.506   0.204  50.798  1.00 13.62           C  
ATOM   1670  CZ2 TRP B  49       2.766  -1.297  51.632  1.00 14.98           C  
ATOM   1671  CZ3 TRP B  49       0.386  -1.137  51.221  1.00 14.87           C  
ATOM   1672  CH2 TRP B  49       1.513  -1.861  51.628  1.00 14.76           C  
ATOM   1673  N   CYS B  50       0.208   1.693  47.552  1.00 15.43           N  
ATOM   1674  CA  CYS B  50      -0.033   0.470  46.785  1.00 17.66           C  
ATOM   1675  C   CYS B  50       0.449   0.583  45.360  1.00 19.30           C  
ATOM   1676  O   CYS B  50       1.167  -0.290  44.870  1.00 18.62           O  
ATOM   1677  CB  CYS B  50      -1.508   0.167  46.697  1.00 20.19           C  
ATOM   1678  SG  CYS B  50      -2.160  -0.522  48.135  1.00 26.76           S  
ATOM   1679  N   ASP B  51       0.043   1.645  44.672  1.00 18.45           N  
ATOM   1680  CA  ASP B  51       0.458   1.774  43.278  1.00 21.17           C  
ATOM   1681  C   ASP B  51       1.968   1.876  43.134  1.00 21.57           C  
ATOM   1682  O   ASP B  51       2.535   1.472  42.110  1.00 20.66           O  
ATOM   1683  CB  ASP B  51      -0.267   2.949  42.607  1.00 24.92           C  
ATOM   1684  CG  ASP B  51      -1.776   2.713  42.511  1.00 26.45           C  
ATOM   1685  OD1 ASP B  51      -2.180   1.540  42.341  1.00 29.19           O  
ATOM   1686  OD2 ASP B  51      -2.559   3.684  42.597  1.00 29.59           O  
ATOM   1687  N   GLY B  52       2.627   2.378  44.175  1.00 20.18           N  
ATOM   1688  CA  GLY B  52       4.071   2.477  44.145  1.00 20.65           C  
ATOM   1689  C   GLY B  52       4.669   1.085  44.157  1.00 21.13           C  
ATOM   1690  O   GLY B  52       5.703   0.828  43.532  1.00 22.44           O  
ATOM   1691  N   LEU B  53       4.016   0.167  44.862  1.00 20.44           N  
ATOM   1692  CA  LEU B  53       4.503  -1.214  44.936  1.00 19.77           C  
ATOM   1693  C   LEU B  53       4.493  -1.866  43.560  1.00 20.39           C  
ATOM   1694  O   LEU B  53       5.450  -2.537  43.172  1.00 20.40           O  
ATOM   1695  CB  LEU B  53       3.624  -2.044  45.860  1.00 18.20           C  
ATOM   1696  CG  LEU B  53       3.451  -1.541  47.295  1.00 16.65           C  
ATOM   1697  CD1 LEU B  53       2.486  -2.466  48.036  1.00 18.40           C  
ATOM   1698  CD2 LEU B  53       4.806  -1.478  47.998  1.00 19.57           C  
ATOM   1699  N   LYS B  54       3.398  -1.667  42.833  1.00 21.95           N  
ATOM   1700  CA  LYS B  54       3.238  -2.246  41.501  1.00 22.70           C  
ATOM   1701  C   LYS B  54       4.462  -1.943  40.628  1.00 21.24           C  
ATOM   1702  O   LYS B  54       4.999  -2.821  39.952  1.00 19.76           O  
ATOM   1703  CB  LYS B  54       1.960  -1.674  40.863  1.00 25.38           C  
ATOM   1704  CG  LYS B  54       1.668  -2.125  39.434  1.00 29.23           C  
ATOM   1705  CD  LYS B  54       1.163  -3.553  39.388  1.00 29.45           C  
ATOM   1706  CE  LYS B  54       0.990  -4.049  37.949  1.00 31.08           C  
ATOM   1707  NZ  LYS B  54      -0.035  -3.278  37.182  1.00 31.98           N  
ATOM   1708  N   ALA B  55       4.916  -0.698  40.659  1.00 21.79           N  
ATOM   1709  CA  ALA B  55       6.068  -0.305  39.867  1.00 21.06           C  
ATOM   1710  C   ALA B  55       7.325  -1.093  40.233  1.00 21.29           C  
ATOM   1711  O   ALA B  55       8.038  -1.591  39.356  1.00 20.42           O  
ATOM   1712  CB  ALA B  55       6.315   1.197  40.033  1.00 21.99           C  
ATOM   1713  N   ASP B  56       7.580  -1.230  41.527  1.00 21.00           N  
ATOM   1714  CA  ASP B  56       8.762  -1.947  42.004  1.00 22.19           C  
ATOM   1715  C   ASP B  56       8.683  -3.450  41.728  1.00 18.86           C  
ATOM   1716  O   ASP B  56       9.691  -4.095  41.478  1.00 20.01           O  
ATOM   1717  CB  ASP B  56       8.962  -1.670  43.501  1.00 26.25           C  
ATOM   1718  CG  ASP B  56       9.402  -0.231  43.775  1.00 31.70           C  
ATOM   1719  OD1 ASP B  56       9.102   0.659  42.945  1.00 35.88           O  
ATOM   1720  OD2 ASP B  56      10.042   0.019  44.822  1.00 33.38           O  
ATOM   1721  N   ILE B  57       7.488  -4.019  41.803  1.00 17.89           N  
ATOM   1722  CA  ILE B  57       7.329  -5.431  41.504  1.00 17.71           C  
ATOM   1723  C   ILE B  57       7.627  -5.609  40.010  1.00 20.03           C  
ATOM   1724  O   ILE B  57       8.398  -6.474  39.608  1.00 20.86           O  
ATOM   1725  CB  ILE B  57       5.903  -5.882  41.790  1.00 17.16           C  
ATOM   1726  CG1 ILE B  57       5.668  -5.854  43.297  1.00 17.33           C  
ATOM   1727  CG2 ILE B  57       5.658  -7.279  41.215  1.00 18.28           C  
ATOM   1728  CD1 ILE B  57       4.228  -6.024  43.677  1.00 17.03           C  
ATOM   1729  N   ALA B  58       7.011  -4.778  39.188  1.00 20.28           N  
ATOM   1730  CA  ALA B  58       7.239  -4.876  37.754  1.00 22.24           C  
ATOM   1731  C   ALA B  58       8.732  -4.732  37.442  1.00 23.80           C  
ATOM   1732  O   ALA B  58       9.273  -5.448  36.586  1.00 24.86           O  
ATOM   1733  CB  ALA B  58       6.423  -3.796  37.029  1.00 21.36           C  
ATOM   1734  N   ALA B  59       9.395  -3.825  38.153  1.00 24.04           N  
ATOM   1735  CA  ALA B  59      10.821  -3.572  37.949  1.00 25.02           C  
ATOM   1736  C   ALA B  59      11.707  -4.694  38.455  1.00 24.86           C  
ATOM   1737  O   ALA B  59      12.919  -4.655  38.262  1.00 26.37           O  
ATOM   1738  CB  ALA B  59      11.221  -2.273  38.618  1.00 25.50           C  
ATOM   1739  N   GLY B  60      11.105  -5.670  39.125  1.00 23.83           N  
ATOM   1740  CA  GLY B  60      11.854  -6.807  39.631  1.00 24.28           C  
ATOM   1741  C   GLY B  60      12.680  -6.601  40.895  1.00 23.85           C  
ATOM   1742  O   GLY B  60      13.390  -7.500  41.319  1.00 25.64           O  
ATOM   1743  N   SER B  61      12.578  -5.441  41.519  1.00 23.66           N  
ATOM   1744  CA  SER B  61      13.369  -5.190  42.711  1.00 22.23           C  
ATOM   1745  C   SER B  61      12.606  -5.552  43.982  1.00 21.06           C  
ATOM   1746  O   SER B  61      13.202  -5.808  45.030  1.00 19.66           O  
ATOM   1747  CB  SER B  61      13.781  -3.720  42.752  1.00 23.87           C  
ATOM   1748  OG  SER B  61      12.709  -2.881  43.155  1.00 27.19           O  
ATOM   1749  N   LEU B  62      11.285  -5.583  43.886  1.00 14.96           N  
ATOM   1750  CA  LEU B  62      10.456  -5.873  45.050  1.00 12.55           C  
ATOM   1751  C   LEU B  62       9.674  -7.162  44.901  1.00 13.24           C  
ATOM   1752  O   LEU B  62       9.057  -7.386  43.860  1.00 11.78           O  
ATOM   1753  CB  LEU B  62       9.442  -4.749  45.244  1.00 15.00           C  
ATOM   1754  CG  LEU B  62       8.591  -4.777  46.512  1.00 18.10           C  
ATOM   1755  CD1 LEU B  62       9.493  -4.569  47.719  1.00 17.04           C  
ATOM   1756  CD2 LEU B  62       7.539  -3.667  46.457  1.00 19.55           C  
ATOM   1757  N   LEU B  63       9.688  -7.991  45.948  1.00 11.37           N  
ATOM   1758  CA  LEU B  63       8.912  -9.240  45.991  1.00 10.84           C  
ATOM   1759  C   LEU B  63       7.836  -8.991  47.042  1.00 10.33           C  
ATOM   1760  O   LEU B  63       8.111  -8.453  48.130  1.00 12.13           O  
ATOM   1761  CB  LEU B  63       9.782 -10.444  46.371  1.00 12.67           C  
ATOM   1762  CG  LEU B  63      11.162 -10.535  45.706  1.00 16.56           C  
ATOM   1763  CD1 LEU B  63      11.684 -11.960  45.887  1.00 15.87           C  
ATOM   1764  CD2 LEU B  63      11.097 -10.220  44.229  1.00 16.53           C  
ATOM   1765  N   LEU B  64       6.597  -9.344  46.714  1.00  8.82           N  
ATOM   1766  CA  LEU B  64       5.470  -9.082  47.611  1.00  8.82           C  
ATOM   1767  C   LEU B  64       4.616 -10.323  47.832  1.00  8.83           C  
ATOM   1768  O   LEU B  64       4.348 -11.074  46.884  1.00  9.88           O  
ATOM   1769  CB  LEU B  64       4.590  -7.966  46.994  1.00 11.11           C  
ATOM   1770  CG  LEU B  64       3.225  -7.670  47.648  1.00  9.90           C  
ATOM   1771  CD1 LEU B  64       3.468  -7.031  49.027  1.00 11.52           C  
ATOM   1772  CD2 LEU B  64       2.371  -6.747  46.758  1.00 11.37           C  
ATOM   1773  N   TRP B  65       4.208 -10.558  49.076  1.00  9.70           N  
ATOM   1774  CA  TRP B  65       3.333 -11.692  49.395  1.00  9.99           C  
ATOM   1775  C   TRP B  65       2.196 -11.190  50.248  1.00  9.97           C  
ATOM   1776  O   TRP B  65       2.319 -10.166  50.928  1.00  9.39           O  
ATOM   1777  CB  TRP B  65       4.038 -12.744  50.243  1.00 10.16           C  
ATOM   1778  CG  TRP B  65       5.170 -13.430  49.596  1.00 10.40           C  
ATOM   1779  CD1 TRP B  65       5.165 -14.684  49.037  1.00 10.78           C  
ATOM   1780  CD2 TRP B  65       6.511 -12.955  49.516  1.00 10.17           C  
ATOM   1781  NE1 TRP B  65       6.430 -15.019  48.624  1.00 12.91           N  
ATOM   1782  CE2 TRP B  65       7.278 -13.973  48.908  1.00 12.08           C  
ATOM   1783  CE3 TRP B  65       7.148 -11.758  49.900  1.00 10.04           C  
ATOM   1784  CZ2 TRP B  65       8.652 -13.838  48.684  1.00 11.22           C  
ATOM   1785  CZ3 TRP B  65       8.506 -11.631  49.675  1.00 11.30           C  
ATOM   1786  CH2 TRP B  65       9.240 -12.664  49.078  1.00 10.77           C  
ATOM   1787  N   VAL B  66       1.093 -11.925  50.218  1.00  9.08           N  
ATOM   1788  CA  VAL B  66      -0.039 -11.611  51.058  1.00 10.02           C  
ATOM   1789  C   VAL B  66      -0.561 -12.926  51.587  1.00 10.43           C  
ATOM   1790  O   VAL B  66      -0.238 -13.994  51.047  1.00 12.40           O  
ATOM   1791  CB  VAL B  66      -1.208 -10.988  50.277  1.00 10.03           C  
ATOM   1792  CG1 VAL B  66      -0.816  -9.599  49.747  1.00 11.16           C  
ATOM   1793  CG2 VAL B  66      -1.632 -11.922  49.116  1.00 10.48           C  
ATOM   1794  N   VAL B  67      -1.317 -12.851  52.674  1.00 10.99           N  
ATOM   1795  CA  VAL B  67      -2.042 -14.022  53.154  1.00 11.74           C  
ATOM   1796  C   VAL B  67      -3.450 -13.518  52.884  1.00 13.14           C  
ATOM   1797  O   VAL B  67      -3.872 -12.483  53.410  1.00 12.37           O  
ATOM   1798  CB  VAL B  67      -1.887 -14.279  54.642  1.00 10.91           C  
ATOM   1799  CG1 VAL B  67      -2.922 -15.339  55.074  1.00 14.37           C  
ATOM   1800  CG2 VAL B  67      -0.484 -14.768  54.919  1.00 12.94           C  
ATOM   1801  N   ALA B  68      -4.180 -14.218  52.029  1.00 14.19           N  
ATOM   1802  CA  ALA B  68      -5.511 -13.755  51.695  1.00 16.49           C  
ATOM   1803  C   ALA B  68      -6.555 -14.843  51.684  1.00 17.27           C  
ATOM   1804  O   ALA B  68      -6.241 -16.025  51.531  1.00 16.68           O  
ATOM   1805  CB  ALA B  68      -5.490 -13.080  50.333  1.00 16.64           C  
ATOM   1806  N   GLU B  69      -7.796 -14.401  51.851  1.00 19.31           N  
ATOM   1807  CA  GLU B  69      -8.978 -15.248  51.783  1.00 24.09           C  
ATOM   1808  C   GLU B  69      -9.646 -14.624  50.553  1.00 26.45           C  
ATOM   1809  O   GLU B  69     -10.395 -13.650  50.670  1.00 26.67           O  
ATOM   1810  CB  GLU B  69      -9.865 -15.041  53.003  1.00 25.69           C  
ATOM   1811  CG  GLU B  69      -9.152 -15.219  54.312  1.00 28.91           C  
ATOM   1812  CD  GLU B  69     -10.068 -15.000  55.506  1.00 33.54           C  
ATOM   1813  OE1 GLU B  69     -10.843 -14.006  55.496  1.00 33.65           O  
ATOM   1814  OE2 GLU B  69     -10.002 -15.816  56.455  1.00 32.75           O  
ATOM   1815  N   ASP B  70      -9.347 -15.176  49.377  1.00 29.69           N  
ATOM   1816  CA  ASP B  70      -9.837 -14.636  48.103  1.00 32.13           C  
ATOM   1817  C   ASP B  70      -9.206 -13.252  47.955  1.00 33.22           C  
ATOM   1818  O   ASP B  70      -7.990 -13.137  47.783  1.00 34.92           O  
ATOM   1819  CB  ASP B  70     -11.364 -14.505  48.072  1.00 35.07           C  
ATOM   1820  CG  ASP B  70     -11.909 -14.323  46.650  1.00 38.09           C  
ATOM   1821  OD1 ASP B  70     -11.123 -13.982  45.731  1.00 39.26           O  
ATOM   1822  OD2 ASP B  70     -13.132 -14.515  46.453  1.00 39.67           O  
ATOM   1823  N   ASP B  71     -10.008 -12.197  48.039  1.00 32.91           N  
ATOM   1824  CA  ASP B  71      -9.460 -10.847  47.898  1.00 33.38           C  
ATOM   1825  C   ASP B  71      -9.320 -10.115  49.231  1.00 30.88           C  
ATOM   1826  O   ASP B  71      -8.952  -8.937  49.266  1.00 32.03           O  
ATOM   1827  CB  ASP B  71     -10.328 -10.019  46.945  1.00 36.52           C  
ATOM   1828  CG  ASP B  71     -11.800 -10.112  47.279  1.00 39.73           C  
ATOM   1829  OD1 ASP B  71     -12.623  -9.481  46.569  1.00 42.17           O  
ATOM   1830  OD2 ASP B  71     -12.136 -10.822  48.255  1.00 42.38           O  
ATOM   1831  N   ASN B  72      -9.608 -10.812  50.325  1.00 27.75           N  
ATOM   1832  CA  ASN B  72      -9.491 -10.217  51.655  1.00 24.39           C  
ATOM   1833  C   ASN B  72      -8.039 -10.421  52.090  1.00 21.20           C  
ATOM   1834  O   ASN B  72      -7.614 -11.559  52.287  1.00 21.20           O  
ATOM   1835  CB  ASN B  72     -10.419 -10.935  52.636  1.00 26.55           C  
ATOM   1836  CG  ASN B  72     -10.363 -10.339  54.012  1.00 28.83           C  
ATOM   1837  OD1 ASN B  72     -10.804 -10.949  54.990  1.00 32.70           O  
ATOM   1838  ND2 ASN B  72      -9.820  -9.133  54.105  1.00 30.40           N  
ATOM   1839  N   VAL B  73      -7.290  -9.332  52.257  1.00 15.85           N  
ATOM   1840  CA  VAL B  73      -5.883  -9.446  52.618  1.00 13.18           C  
ATOM   1841  C   VAL B  73      -5.714  -9.369  54.123  1.00 13.04           C  
ATOM   1842  O   VAL B  73      -5.981  -8.327  54.737  1.00 14.66           O  
ATOM   1843  CB  VAL B  73      -5.057  -8.326  51.924  1.00 11.26           C  
ATOM   1844  CG1 VAL B  73      -3.613  -8.379  52.353  1.00 10.85           C  
ATOM   1845  CG2 VAL B  73      -5.146  -8.493  50.374  1.00 12.37           C  
ATOM   1846  N   LEU B  74      -5.307 -10.488  54.718  1.00 10.87           N  
ATOM   1847  CA  LEU B  74      -5.106 -10.553  56.165  1.00 10.71           C  
ATOM   1848  C   LEU B  74      -3.729 -10.088  56.597  1.00 10.68           C  
ATOM   1849  O   LEU B  74      -3.555  -9.630  57.726  1.00 10.04           O  
ATOM   1850  CB  LEU B  74      -5.269 -11.990  56.679  1.00 11.52           C  
ATOM   1851  CG  LEU B  74      -6.627 -12.644  56.415  1.00 13.80           C  
ATOM   1852  CD1 LEU B  74      -6.669 -14.006  57.085  1.00 15.04           C  
ATOM   1853  CD2 LEU B  74      -7.740 -11.737  56.958  1.00 16.67           C  
ATOM   1854  N   ALA B  75      -2.752 -10.221  55.710  1.00  9.54           N  
ATOM   1855  CA  ALA B  75      -1.395  -9.846  56.081  1.00  7.46           C  
ATOM   1856  C   ALA B  75      -0.578  -9.710  54.823  1.00  8.29           C  
ATOM   1857  O   ALA B  75      -0.990 -10.173  53.752  1.00  8.03           O  
ATOM   1858  CB  ALA B  75      -0.812 -10.917  56.938  1.00  8.09           C  
ATOM   1859  N   SER B  76       0.589  -9.100  54.948  1.00  7.73           N  
ATOM   1860  CA  SER B  76       1.464  -8.933  53.794  1.00  9.46           C  
ATOM   1861  C   SER B  76       2.902  -8.752  54.234  1.00  9.50           C  
ATOM   1862  O   SER B  76       3.167  -8.407  55.392  1.00  8.76           O  
ATOM   1863  CB  SER B  76       0.997  -7.714  53.006  1.00 11.07           C  
ATOM   1864  OG  SER B  76       1.749  -7.518  51.827  1.00 15.41           O  
ATOM   1865  N   ALA B  77       3.836  -9.026  53.333  1.00  9.28           N  
ATOM   1866  CA  ALA B  77       5.267  -8.814  53.619  1.00  8.57           C  
ATOM   1867  C   ALA B  77       5.979  -8.536  52.302  1.00  7.98           C  
ATOM   1868  O   ALA B  77       5.553  -9.018  51.244  1.00  9.85           O  
ATOM   1869  CB  ALA B  77       5.875 -10.036  54.292  1.00  9.73           C  
ATOM   1870  N   GLN B  78       7.060  -7.756  52.366  1.00  7.67           N  
ATOM   1871  CA  GLN B  78       7.827  -7.400  51.186  1.00 11.89           C  
ATOM   1872  C   GLN B  78       9.296  -7.651  51.374  1.00 10.75           C  
ATOM   1873  O   GLN B  78       9.826  -7.601  52.482  1.00 11.72           O  
ATOM   1874  CB  GLN B  78       7.666  -5.914  50.862  1.00 13.99           C  
ATOM   1875  CG  GLN B  78       6.330  -5.523  50.352  1.00 16.74           C  
ATOM   1876  CD  GLN B  78       6.160  -4.036  50.412  1.00 15.36           C  
ATOM   1877  OE1 GLN B  78       7.127  -3.272  50.261  1.00 19.52           O  
ATOM   1878  NE2 GLN B  78       4.938  -3.605  50.626  1.00 18.85           N  
ATOM   1879  N   LEU B  79       9.958  -7.941  50.266  1.00  9.97           N  
ATOM   1880  CA  LEU B  79      11.381  -8.152  50.301  1.00 10.77           C  
ATOM   1881  C   LEU B  79      11.940  -7.268  49.200  1.00 11.88           C  
ATOM   1882  O   LEU B  79      11.607  -7.456  48.020  1.00 11.45           O  
ATOM   1883  CB  LEU B  79      11.724  -9.607  50.012  1.00 12.57           C  
ATOM   1884  CG  LEU B  79      13.226  -9.884  50.120  1.00 12.64           C  
ATOM   1885  CD1 LEU B  79      13.675  -9.753  51.583  1.00 13.05           C  
ATOM   1886  CD2 LEU B  79      13.512 -11.273  49.577  1.00 14.46           C  
ATOM   1887  N   SER B  80      12.746  -6.285  49.585  1.00 11.01           N  
ATOM   1888  CA  SER B  80      13.368  -5.378  48.618  1.00 10.76           C  
ATOM   1889  C   SER B  80      14.784  -5.866  48.313  1.00 11.91           C  
ATOM   1890  O   SER B  80      15.667  -5.797  49.163  1.00 11.53           O  
ATOM   1891  CB  SER B  80      13.421  -3.952  49.183  1.00 12.29           C  
ATOM   1892  OG  SER B  80      14.033  -3.060  48.257  1.00 15.24           O  
ATOM   1893  N   LEU B  81      14.991  -6.348  47.086  1.00 11.39           N  
ATOM   1894  CA  LEU B  81      16.290  -6.859  46.658  1.00 12.55           C  
ATOM   1895  C   LEU B  81      17.252  -5.731  46.331  1.00 13.93           C  
ATOM   1896  O   LEU B  81      16.932  -4.863  45.517  1.00 13.08           O  
ATOM   1897  CB  LEU B  81      16.110  -7.715  45.407  1.00 13.46           C  
ATOM   1898  CG  LEU B  81      15.175  -8.911  45.515  1.00 13.98           C  
ATOM   1899  CD1 LEU B  81      15.056  -9.596  44.169  1.00 16.88           C  
ATOM   1900  CD2 LEU B  81      15.713  -9.862  46.554  1.00 14.52           C  
ATOM   1901  N   CYS B  82      18.429  -5.726  46.948  1.00 12.71           N  
ATOM   1902  CA  CYS B  82      19.386  -4.676  46.636  1.00 14.64           C  
ATOM   1903  C   CYS B  82      19.855  -4.873  45.199  1.00 15.56           C  
ATOM   1904  O   CYS B  82      20.175  -5.991  44.810  1.00 16.40           O  
ATOM   1905  CB  CYS B  82      20.589  -4.730  47.577  1.00 15.50           C  
ATOM   1906  SG  CYS B  82      21.772  -3.376  47.249  1.00 18.07           S  
ATOM   1907  N   GLN B  83      19.880  -3.799  44.410  1.00 16.54           N  
ATOM   1908  CA  GLN B  83      20.334  -3.904  43.025  1.00 17.73           C  
ATOM   1909  C   GLN B  83      21.715  -3.281  42.772  1.00 17.32           C  
ATOM   1910  O   GLN B  83      22.201  -3.274  41.640  1.00 17.26           O  
ATOM   1911  CB  GLN B  83      19.302  -3.275  42.092  1.00 22.19           C  
ATOM   1912  CG  GLN B  83      17.992  -4.038  42.042  1.00 27.48           C  
ATOM   1913  CD  GLN B  83      16.918  -3.244  41.335  1.00 30.74           C  
ATOM   1914  OE1 GLN B  83      16.605  -2.115  41.738  1.00 33.34           O  
ATOM   1915  NE2 GLN B  83      16.350  -3.816  40.274  1.00 32.98           N  
ATOM   1916  N   LYS B  84      22.354  -2.771  43.817  1.00 15.83           N  
ATOM   1917  CA  LYS B  84      23.691  -2.194  43.660  1.00 17.05           C  
ATOM   1918  C   LYS B  84      24.637  -3.329  43.282  1.00 17.56           C  
ATOM   1919  O   LYS B  84      24.544  -4.422  43.832  1.00 17.35           O  
ATOM   1920  CB  LYS B  84      24.133  -1.543  44.965  1.00 17.32           C  
ATOM   1921  CG  LYS B  84      23.347  -0.292  45.260  1.00 21.86           C  
ATOM   1922  CD  LYS B  84      23.752   0.313  46.585  1.00 25.40           C  
ATOM   1923  CE  LYS B  84      23.030   1.628  46.827  1.00 28.53           C  
ATOM   1924  NZ  LYS B  84      23.652   2.350  47.997  1.00 32.24           N  
ATOM   1925  N   PRO B  85      25.555  -3.084  42.335  1.00 17.91           N  
ATOM   1926  CA  PRO B  85      26.498  -4.122  41.907  1.00 17.21           C  
ATOM   1927  C   PRO B  85      27.225  -4.855  43.027  1.00 16.70           C  
ATOM   1928  O   PRO B  85      27.517  -6.044  42.892  1.00 17.30           O  
ATOM   1929  CB  PRO B  85      27.443  -3.359  40.992  1.00 17.51           C  
ATOM   1930  CG  PRO B  85      26.513  -2.367  40.345  1.00 18.92           C  
ATOM   1931  CD  PRO B  85      25.723  -1.859  41.533  1.00 17.85           C  
ATOM   1932  N   ASN B  86      27.537  -4.156  44.123  1.00 15.27           N  
ATOM   1933  CA  ASN B  86      28.237  -4.805  45.235  1.00 16.61           C  
ATOM   1934  C   ASN B  86      27.291  -5.191  46.374  1.00 16.51           C  
ATOM   1935  O   ASN B  86      27.739  -5.611  47.444  1.00 16.57           O  
ATOM   1936  CB  ASN B  86      29.349  -3.892  45.776  1.00 16.93           C  
ATOM   1937  CG  ASN B  86      28.817  -2.786  46.655  1.00 16.71           C  
ATOM   1938  OD1 ASN B  86      27.680  -2.351  46.488  1.00 16.37           O  
ATOM   1939  ND2 ASN B  86      29.644  -2.313  47.591  1.00 17.40           N  
ATOM   1940  N   GLY B  87      25.986  -5.077  46.148  1.00 14.91           N  
ATOM   1941  CA  GLY B  87      25.053  -5.410  47.212  1.00 14.49           C  
ATOM   1942  C   GLY B  87      24.126  -6.569  46.911  1.00 14.33           C  
ATOM   1943  O   GLY B  87      23.105  -6.754  47.584  1.00 15.58           O  
ATOM   1944  N   LEU B  88      24.486  -7.378  45.924  1.00 14.21           N  
ATOM   1945  CA  LEU B  88      23.631  -8.487  45.517  1.00 13.50           C  
ATOM   1946  C   LEU B  88      23.475  -9.584  46.557  1.00 12.96           C  
ATOM   1947  O   LEU B  88      22.625 -10.470  46.379  1.00 15.42           O  
ATOM   1948  CB  LEU B  88      24.134  -9.087  44.205  1.00 17.20           C  
ATOM   1949  CG  LEU B  88      24.196  -8.073  43.051  1.00 16.32           C  
ATOM   1950  CD1 LEU B  88      24.588  -8.783  41.774  1.00 20.22           C  
ATOM   1951  CD2 LEU B  88      22.860  -7.362  42.883  1.00 17.09           C  
ATOM   1952  N   ASN B  89      24.265  -9.543  47.631  1.00 13.02           N  
ATOM   1953  CA  ASN B  89      24.124 -10.563  48.682  1.00 12.95           C  
ATOM   1954  C   ASN B  89      22.999 -10.195  49.639  1.00 12.22           C  
ATOM   1955  O   ASN B  89      22.577 -11.037  50.423  1.00 12.06           O  
ATOM   1956  CB  ASN B  89      25.397 -10.692  49.542  1.00 12.99           C  
ATOM   1957  CG  ASN B  89      25.301 -11.826  50.583  1.00 14.20           C  
ATOM   1958  OD1 ASN B  89      25.474 -11.622  51.814  1.00 17.24           O  
ATOM   1959  ND2 ASN B  89      25.026 -13.025  50.102  1.00 12.52           N  
ATOM   1960  N   ARG B  90      22.492  -8.969  49.581  1.00 11.65           N  
ATOM   1961  CA  ARG B  90      21.504  -8.587  50.608  1.00  9.71           C  
ATOM   1962  C   ARG B  90      20.141  -8.176  50.133  1.00 10.48           C  
ATOM   1963  O   ARG B  90      19.945  -7.850  48.964  1.00 12.19           O  
ATOM   1964  CB  ARG B  90      22.064  -7.450  51.465  1.00 10.78           C  
ATOM   1965  CG  ARG B  90      22.261  -6.148  50.708  1.00 10.96           C  
ATOM   1966  CD  ARG B  90      22.481  -4.980  51.692  1.00 12.61           C  
ATOM   1967  NE  ARG B  90      22.401  -3.673  51.035  1.00 14.06           N  
ATOM   1968  CZ  ARG B  90      23.398  -3.080  50.380  1.00 18.65           C  
ATOM   1969  NH1 ARG B  90      24.584  -3.665  50.273  1.00 16.97           N  
ATOM   1970  NH2 ARG B  90      23.210  -1.873  49.844  1.00 20.04           N  
ATOM   1971  N   ALA B  91      19.184  -8.191  51.059  1.00  9.09           N  
ATOM   1972  CA  ALA B  91      17.828  -7.763  50.742  1.00  9.14           C  
ATOM   1973  C   ALA B  91      17.237  -7.237  52.022  1.00 10.59           C  
ATOM   1974  O   ALA B  91      17.589  -7.694  53.113  1.00 10.92           O  
ATOM   1975  CB  ALA B  91      16.983  -8.914  50.229  1.00  9.30           C  
ATOM   1976  N   GLU B  92      16.340  -6.267  51.886  1.00  9.88           N  
ATOM   1977  CA  GLU B  92      15.707  -5.693  53.062  1.00 10.12           C  
ATOM   1978  C   GLU B  92      14.256  -6.144  53.204  1.00 10.79           C  
ATOM   1979  O   GLU B  92      13.463  -6.081  52.265  1.00 11.24           O  
ATOM   1980  CB  GLU B  92      15.738  -4.173  53.009  1.00 12.44           C  
ATOM   1981  CG  GLU B  92      15.113  -3.528  54.226  1.00 18.60           C  
ATOM   1982  CD  GLU B  92      15.182  -2.019  54.191  1.00 24.18           C  
ATOM   1983  OE1 GLU B  92      15.736  -1.465  53.213  1.00 26.24           O  
ATOM   1984  OE2 GLU B  92      14.681  -1.386  55.154  1.00 26.82           O  
ATOM   1985  N   VAL B  93      13.905  -6.568  54.406  1.00 10.81           N  
ATOM   1986  CA  VAL B  93      12.534  -6.985  54.682  1.00 12.14           C  
ATOM   1987  C   VAL B  93      11.784  -5.735  55.093  1.00 14.28           C  
ATOM   1988  O   VAL B  93      12.275  -4.962  55.923  1.00 13.47           O  
ATOM   1989  CB  VAL B  93      12.472  -7.938  55.863  1.00 12.24           C  
ATOM   1990  CG1 VAL B  93      11.010  -8.231  56.205  1.00 12.32           C  
ATOM   1991  CG2 VAL B  93      13.221  -9.212  55.539  1.00 12.48           C  
ATOM   1992  N   GLN B  94      10.595  -5.516  54.535  1.00 13.50           N  
ATOM   1993  CA  GLN B  94       9.860  -4.339  54.951  1.00 15.20           C  
ATOM   1994  C   GLN B  94       8.366  -4.568  54.873  1.00 15.47           C  
ATOM   1995  O   GLN B  94       7.878  -5.534  54.256  1.00 15.16           O  
ATOM   1996  CB  GLN B  94      10.266  -3.148  54.085  1.00 17.86           C  
ATOM   1997  CG  GLN B  94       9.943  -3.361  52.616  1.00 17.77           C  
ATOM   1998  CD  GLN B  94      10.639  -2.376  51.677  1.00 20.87           C  
ATOM   1999  OE1 GLN B  94      10.140  -2.107  50.586  1.00 23.54           O  
ATOM   2000  NE2 GLN B  94      11.797  -1.856  52.084  1.00 22.85           N  
ATOM   2001  N   LYS B  95       7.633  -3.686  55.525  1.00 14.72           N  
ATOM   2002  CA  LYS B  95       6.189  -3.736  55.489  1.00 14.42           C  
ATOM   2003  C   LYS B  95       5.530  -5.065  55.849  1.00 13.93           C  
ATOM   2004  O   LYS B  95       4.544  -5.485  55.203  1.00 13.28           O  
ATOM   2005  CB  LYS B  95       5.716  -3.275  54.118  1.00 15.73           C  
ATOM   2006  CG  LYS B  95       6.004  -1.809  53.855  1.00 19.52           C  
ATOM   2007  CD  LYS B  95       5.100  -0.915  54.707  1.00 20.28           C  
ATOM   2008  CE  LYS B  95       5.288   0.555  54.376  1.00 19.92           C  
ATOM   2009  NZ  LYS B  95       6.664   1.035  54.716  1.00 20.62           N  
ATOM   2010  N   LEU B  96       6.067  -5.748  56.862  1.00 12.06           N  
ATOM   2011  CA  LEU B  96       5.426  -6.982  57.309  1.00 11.32           C  
ATOM   2012  C   LEU B  96       4.272  -6.469  58.184  1.00 12.19           C  
ATOM   2013  O   LEU B  96       4.498  -5.771  59.180  1.00 12.94           O  
ATOM   2014  CB  LEU B  96       6.394  -7.828  58.140  1.00 11.46           C  
ATOM   2015  CG  LEU B  96       5.676  -8.912  58.935  1.00 13.66           C  
ATOM   2016  CD1 LEU B  96       5.146  -9.973  57.983  1.00 14.05           C  
ATOM   2017  CD2 LEU B  96       6.640  -9.494  59.963  1.00 15.62           C  
HETATM 2018  N   MSE B  97       3.040  -6.770  57.784  1.00 10.30           N  
HETATM 2019  CA  MSE B  97       1.875  -6.280  58.506  1.00 10.60           C  
HETATM 2020  C   MSE B  97       0.782  -7.329  58.534  1.00  9.92           C  
HETATM 2021  O   MSE B  97       0.522  -8.002  57.530  1.00 10.68           O  
HETATM 2022  CB  MSE B  97       1.316  -5.029  57.817  1.00 11.42           C  
HETATM 2023  CG  MSE B  97       2.320  -3.918  57.656  1.00 15.37           C  
HETATM 2024 SE   MSE B  97       1.518  -2.394  56.792  1.00 19.64          SE  
HETATM 2025  CE  MSE B  97       1.281  -3.126  55.021  1.00 15.01           C  
ATOM   2026  N   VAL B  98       0.125  -7.444  59.676  1.00 10.59           N  
ATOM   2027  CA  VAL B  98      -0.973  -8.398  59.849  1.00  9.63           C  
ATOM   2028  C   VAL B  98      -2.145  -7.591  60.423  1.00 11.16           C  
ATOM   2029  O   VAL B  98      -1.959  -6.827  61.369  1.00 11.33           O  
ATOM   2030  CB  VAL B  98      -0.562  -9.519  60.845  1.00 10.25           C  
ATOM   2031  CG1 VAL B  98      -1.720 -10.482  61.096  1.00 10.91           C  
ATOM   2032  CG2 VAL B  98       0.650 -10.279  60.290  1.00 11.40           C  
ATOM   2033  N   LEU B  99      -3.343  -7.736  59.861  1.00 10.78           N  
ATOM   2034  CA  LEU B  99      -4.495  -7.001  60.383  1.00 12.16           C  
ATOM   2035  C   LEU B  99      -4.601  -7.270  61.901  1.00 13.95           C  
ATOM   2036  O   LEU B  99      -4.380  -8.391  62.349  1.00 14.07           O  
ATOM   2037  CB  LEU B  99      -5.784  -7.505  59.721  1.00 12.77           C  
ATOM   2038  CG  LEU B  99      -6.120  -7.141  58.278  1.00 13.67           C  
ATOM   2039  CD1 LEU B  99      -7.395  -7.909  57.873  1.00 13.74           C  
ATOM   2040  CD2 LEU B  99      -6.340  -5.636  58.157  1.00 13.46           C  
ATOM   2041  N   PRO B 100      -4.936  -6.246  62.714  1.00 15.09           N  
ATOM   2042  CA  PRO B 100      -5.060  -6.435  64.161  1.00 18.24           C  
ATOM   2043  C   PRO B 100      -5.927  -7.640  64.527  1.00 19.19           C  
ATOM   2044  O   PRO B 100      -5.609  -8.393  65.451  1.00 21.26           O  
ATOM   2045  CB  PRO B 100      -5.683  -5.115  64.620  1.00 18.22           C  
ATOM   2046  CG  PRO B 100      -5.041  -4.124  63.717  1.00 17.98           C  
ATOM   2047  CD  PRO B 100      -5.039  -4.817  62.356  1.00 16.38           C  
ATOM   2048  N   SER B 101      -7.022  -7.816  63.799  1.00 19.34           N  
ATOM   2049  CA  SER B 101      -7.942  -8.924  64.050  1.00 18.35           C  
ATOM   2050  C   SER B 101      -7.364 -10.280  63.689  1.00 18.12           C  
ATOM   2051  O   SER B 101      -7.891 -11.317  64.100  1.00 19.27           O  
ATOM   2052  CB  SER B 101      -9.235  -8.723  63.257  1.00 20.28           C  
ATOM   2053  OG  SER B 101      -8.989  -8.650  61.856  1.00 23.66           O  
ATOM   2054  N   ALA B 102      -6.267 -10.277  62.940  1.00 16.10           N  
ATOM   2055  CA  ALA B 102      -5.667 -11.528  62.477  1.00 13.69           C  
ATOM   2056  C   ALA B 102      -4.351 -11.895  63.114  1.00 13.25           C  
ATOM   2057  O   ALA B 102      -3.736 -12.899  62.732  1.00 13.06           O  
ATOM   2058  CB  ALA B 102      -5.487 -11.472  60.958  1.00 14.72           C  
ATOM   2059  N   ARG B 103      -3.925 -11.112  64.097  1.00 12.93           N  
ATOM   2060  CA  ARG B 103      -2.636 -11.357  64.751  1.00 12.05           C  
ATOM   2061  C   ARG B 103      -2.632 -12.534  65.725  1.00 11.68           C  
ATOM   2062  O   ARG B 103      -3.692 -12.984  66.204  1.00 13.53           O  
ATOM   2063  CB  ARG B 103      -2.186 -10.092  65.468  1.00 11.22           C  
ATOM   2064  CG  ARG B 103      -1.872  -8.973  64.492  1.00 11.76           C  
ATOM   2065  CD  ARG B 103      -1.606  -7.632  65.131  1.00 15.27           C  
ATOM   2066  NE  ARG B 103      -1.526  -6.609  64.085  1.00 15.29           N  
ATOM   2067  CZ  ARG B 103      -1.477  -5.300  64.310  1.00 17.63           C  
ATOM   2068  NH1 ARG B 103      -1.497  -4.833  65.553  1.00 18.43           N  
ATOM   2069  NH2 ARG B 103      -1.415  -4.448  63.292  1.00 15.83           N  
ATOM   2070  N   GLY B 104      -1.440 -13.042  66.005  1.00 11.88           N  
ATOM   2071  CA  GLY B 104      -1.311 -14.156  66.919  1.00 14.95           C  
ATOM   2072  C   GLY B 104      -1.806 -15.497  66.404  1.00 16.81           C  
ATOM   2073  O   GLY B 104      -2.076 -16.405  67.201  1.00 17.72           O  
ATOM   2074  N   ARG B 105      -1.903 -15.628  65.083  1.00 15.29           N  
ATOM   2075  CA  ARG B 105      -2.370 -16.847  64.434  1.00 18.50           C  
ATOM   2076  C   ARG B 105      -1.265 -17.534  63.640  1.00 17.62           C  
ATOM   2077  O   ARG B 105      -1.520 -18.526  62.956  1.00 17.72           O  
ATOM   2078  CB  ARG B 105      -3.519 -16.525  63.478  1.00 21.35           C  
ATOM   2079  CG  ARG B 105      -4.809 -16.056  64.130  1.00 28.08           C  
ATOM   2080  CD  ARG B 105      -5.822 -15.619  63.052  1.00 32.29           C  
ATOM   2081  NE  ARG B 105      -5.735 -16.425  61.825  1.00 36.05           N  
ATOM   2082  CZ  ARG B 105      -6.502 -16.249  60.745  1.00 37.60           C  
ATOM   2083  NH1 ARG B 105      -7.429 -15.297  60.731  1.00 38.06           N  
ATOM   2084  NH2 ARG B 105      -6.328 -17.010  59.665  1.00 35.81           N  
ATOM   2085  N   GLY B 106      -0.059 -16.972  63.686  1.00 15.02           N  
ATOM   2086  CA  GLY B 106       1.056 -17.559  62.968  1.00 13.78           C  
ATOM   2087  C   GLY B 106       1.243 -17.009  61.560  1.00 10.24           C  
ATOM   2088  O   GLY B 106       2.101 -17.505  60.830  1.00 12.57           O  
ATOM   2089  N   LEU B 107       0.465 -15.998  61.167  1.00 10.18           N  
ATOM   2090  CA  LEU B 107       0.570 -15.469  59.798  1.00 10.70           C  
ATOM   2091  C   LEU B 107       1.892 -14.774  59.552  1.00  8.27           C  
ATOM   2092  O   LEU B 107       2.469 -14.910  58.483  1.00 10.08           O  
ATOM   2093  CB  LEU B 107      -0.557 -14.480  59.477  1.00  9.29           C  
ATOM   2094  CG  LEU B 107      -1.953 -15.113  59.550  1.00 14.73           C  
ATOM   2095  CD1 LEU B 107      -3.025 -14.104  59.070  1.00 14.92           C  
ATOM   2096  CD2 LEU B 107      -1.959 -16.371  58.678  1.00 13.37           C  
ATOM   2097  N   GLY B 108       2.368 -14.008  60.524  1.00  7.46           N  
ATOM   2098  CA  GLY B 108       3.628 -13.303  60.341  1.00  7.60           C  
ATOM   2099  C   GLY B 108       4.749 -14.312  60.181  1.00  8.30           C  
ATOM   2100  O   GLY B 108       5.626 -14.162  59.306  1.00 10.74           O  
ATOM   2101  N   ARG B 109       4.756 -15.330  61.034  1.00  8.90           N  
ATOM   2102  CA  ARG B 109       5.788 -16.356  60.928  1.00  9.50           C  
ATOM   2103  C   ARG B 109       5.725 -17.104  59.566  1.00  9.84           C  
ATOM   2104  O   ARG B 109       6.747 -17.416  58.950  1.00 11.89           O  
ATOM   2105  CB  ARG B 109       5.662 -17.345  62.108  1.00 10.96           C  
ATOM   2106  CG  ARG B 109       6.815 -18.350  62.184  1.00 13.06           C  
ATOM   2107  CD  ARG B 109       6.584 -19.378  63.307  1.00 11.93           C  
ATOM   2108  NE  ARG B 109       6.768 -18.861  64.662  1.00 13.97           N  
ATOM   2109  CZ  ARG B 109       7.937 -18.807  65.289  1.00 14.95           C  
ATOM   2110  NH1 ARG B 109       9.038 -19.221  64.683  1.00 17.34           N  
ATOM   2111  NH2 ARG B 109       8.000 -18.388  66.546  1.00 15.10           N  
ATOM   2112  N   GLN B 110       4.518 -17.397  59.091  1.00 11.17           N  
ATOM   2113  CA  GLN B 110       4.363 -18.089  57.831  1.00 12.23           C  
ATOM   2114  C   GLN B 110       4.944 -17.216  56.720  1.00 11.67           C  
ATOM   2115  O   GLN B 110       5.671 -17.702  55.842  1.00 11.86           O  
ATOM   2116  CB  GLN B 110       2.881 -18.389  57.594  1.00 14.39           C  
ATOM   2117  CG  GLN B 110       2.543 -18.894  56.188  1.00 20.87           C  
ATOM   2118  CD  GLN B 110       1.108 -19.411  56.057  1.00 25.03           C  
ATOM   2119  OE1 GLN B 110       0.184 -18.903  56.701  1.00 29.53           O  
ATOM   2120  NE2 GLN B 110       0.921 -20.421  55.207  1.00 27.21           N  
ATOM   2121  N   LEU B 111       4.633 -15.923  56.757  1.00  9.91           N  
ATOM   2122  CA  LEU B 111       5.153 -15.008  55.739  1.00 10.13           C  
ATOM   2123  C   LEU B 111       6.677 -14.961  55.775  1.00 11.52           C  
ATOM   2124  O   LEU B 111       7.348 -15.091  54.753  1.00 10.82           O  
ATOM   2125  CB  LEU B 111       4.584 -13.585  55.947  1.00 11.26           C  
ATOM   2126  CG  LEU B 111       3.179 -13.392  55.382  1.00 11.81           C  
ATOM   2127  CD1 LEU B 111       2.562 -12.084  55.893  1.00 11.99           C  
ATOM   2128  CD2 LEU B 111       3.272 -13.389  53.859  1.00 12.12           C  
HETATM 2129  N   MSE B 112       7.242 -14.788  56.962  1.00 10.14           N  
HETATM 2130  CA  MSE B 112       8.692 -14.698  57.061  1.00 11.30           C  
HETATM 2131  C   MSE B 112       9.407 -15.975  56.657  1.00 12.06           C  
HETATM 2132  O   MSE B 112      10.484 -15.923  56.074  1.00 13.01           O  
HETATM 2133  CB  MSE B 112       9.096 -14.257  58.474  1.00 11.82           C  
HETATM 2134  CG  MSE B 112       8.666 -12.832  58.777  1.00 13.61           C  
HETATM 2135 SE   MSE B 112       9.409 -11.506  57.546  1.00 23.46          SE  
HETATM 2136  CE  MSE B 112      11.193 -12.163  57.538  1.00 17.03           C  
ATOM   2137  N   ASP B 113       8.813 -17.130  56.932  1.00 12.74           N  
ATOM   2138  CA  ASP B 113       9.455 -18.377  56.533  1.00 15.31           C  
ATOM   2139  C   ASP B 113       9.553 -18.428  55.008  1.00 15.37           C  
ATOM   2140  O   ASP B 113      10.569 -18.860  54.451  1.00 14.16           O  
ATOM   2141  CB  ASP B 113       8.656 -19.590  57.043  1.00 18.92           C  
ATOM   2142  CG  ASP B 113       8.814 -19.822  58.550  1.00 23.15           C  
ATOM   2143  OD1 ASP B 113       9.795 -19.328  59.156  1.00 24.81           O  
ATOM   2144  OD2 ASP B 113       7.958 -20.530  59.129  1.00 26.11           O  
ATOM   2145  N   GLU B 114       8.505 -17.970  54.329  1.00 14.45           N  
ATOM   2146  CA  GLU B 114       8.521 -18.004  52.883  1.00 15.27           C  
ATOM   2147  C   GLU B 114       9.474 -16.933  52.352  1.00 14.34           C  
ATOM   2148  O   GLU B 114      10.202 -17.158  51.383  1.00 13.34           O  
ATOM   2149  CB  GLU B 114       7.103 -17.801  52.331  1.00 17.95           C  
ATOM   2150  CG  GLU B 114       7.010 -17.911  50.796  1.00 20.00           C  
ATOM   2151  CD  GLU B 114       7.404 -19.296  50.265  1.00 23.77           C  
ATOM   2152  OE1 GLU B 114       7.583 -20.238  51.075  1.00 24.83           O  
ATOM   2153  OE2 GLU B 114       7.534 -19.451  49.028  1.00 22.99           O  
ATOM   2154  N   VAL B 115       9.487 -15.770  52.993  1.00 13.09           N  
ATOM   2155  CA  VAL B 115      10.378 -14.715  52.541  1.00 11.57           C  
ATOM   2156  C   VAL B 115      11.814 -15.213  52.583  1.00 10.27           C  
ATOM   2157  O   VAL B 115      12.577 -14.978  51.655  1.00 13.23           O  
ATOM   2158  CB  VAL B 115      10.274 -13.471  53.423  1.00 10.75           C  
ATOM   2159  CG1 VAL B 115      11.423 -12.500  53.103  1.00 13.51           C  
ATOM   2160  CG2 VAL B 115       8.915 -12.809  53.193  1.00 12.04           C  
ATOM   2161  N   GLU B 116      12.173 -15.938  53.634  1.00  9.23           N  
ATOM   2162  CA  GLU B 116      13.546 -16.420  53.734  1.00 10.96           C  
ATOM   2163  C   GLU B 116      13.814 -17.484  52.686  1.00 11.64           C  
ATOM   2164  O   GLU B 116      14.900 -17.521  52.123  1.00 13.31           O  
ATOM   2165  CB  GLU B 116      13.834 -16.986  55.130  1.00 11.84           C  
ATOM   2166  CG  GLU B 116      13.706 -15.902  56.220  1.00 15.51           C  
ATOM   2167  CD  GLU B 116      13.766 -16.443  57.639  1.00 20.34           C  
ATOM   2168  OE1 GLU B 116      14.105 -17.635  57.825  1.00 19.55           O  
ATOM   2169  OE2 GLU B 116      13.472 -15.654  58.565  1.00 19.55           O  
ATOM   2170  N   GLN B 117      12.835 -18.335  52.400  1.00 12.55           N  
ATOM   2171  CA  GLN B 117      13.078 -19.386  51.411  1.00 15.34           C  
ATOM   2172  C   GLN B 117      13.307 -18.786  50.021  1.00 14.96           C  
ATOM   2173  O   GLN B 117      14.221 -19.194  49.301  1.00 15.10           O  
ATOM   2174  CB  GLN B 117      11.923 -20.395  51.406  1.00 18.18           C  
ATOM   2175  CG  GLN B 117      11.860 -21.143  52.741  1.00 26.57           C  
ATOM   2176  CD  GLN B 117      11.155 -22.487  52.667  1.00 31.30           C  
ATOM   2177  OE1 GLN B 117      11.540 -23.370  51.885  1.00 35.57           O  
ATOM   2178  NE2 GLN B 117      10.128 -22.663  53.501  1.00 34.27           N  
ATOM   2179  N   VAL B 118      12.500 -17.793  49.666  1.00 13.70           N  
ATOM   2180  CA  VAL B 118      12.628 -17.143  48.371  1.00 11.70           C  
ATOM   2181  C   VAL B 118      13.879 -16.278  48.314  1.00 12.95           C  
ATOM   2182  O   VAL B 118      14.499 -16.170  47.269  1.00 13.48           O  
ATOM   2183  CB  VAL B 118      11.357 -16.315  48.037  1.00 13.95           C  
ATOM   2184  CG1 VAL B 118      11.527 -15.548  46.731  1.00 11.74           C  
ATOM   2185  CG2 VAL B 118      10.195 -17.257  47.877  1.00 12.40           C  
ATOM   2186  N   ALA B 119      14.259 -15.670  49.431  1.00 12.98           N  
ATOM   2187  CA  ALA B 119      15.477 -14.863  49.442  1.00 12.94           C  
ATOM   2188  C   ALA B 119      16.672 -15.770  49.089  1.00 13.15           C  
ATOM   2189  O   ALA B 119      17.559 -15.359  48.320  1.00 13.93           O  
ATOM   2190  CB  ALA B 119      15.678 -14.209  50.818  1.00 12.44           C  
ATOM   2191  N   VAL B 120      16.683 -16.998  49.619  1.00 13.58           N  
ATOM   2192  CA  VAL B 120      17.768 -17.942  49.326  1.00 13.93           C  
ATOM   2193  C   VAL B 120      17.765 -18.315  47.844  1.00 15.85           C  
ATOM   2194  O   VAL B 120      18.832 -18.500  47.244  1.00 16.55           O  
ATOM   2195  CB  VAL B 120      17.649 -19.206  50.199  1.00 13.09           C  
ATOM   2196  CG1 VAL B 120      18.627 -20.289  49.731  1.00 14.90           C  
ATOM   2197  CG2 VAL B 120      17.963 -18.837  51.630  1.00 13.89           C  
ATOM   2198  N   LYS B 121      16.580 -18.420  47.250  1.00 15.80           N  
ATOM   2199  CA  LYS B 121      16.480 -18.739  45.823  1.00 17.24           C  
ATOM   2200  C   LYS B 121      17.013 -17.595  44.969  1.00 17.60           C  
ATOM   2201  O   LYS B 121      17.409 -17.818  43.821  1.00 20.15           O  
ATOM   2202  CB  LYS B 121      15.029 -19.026  45.434  1.00 18.86           C  
ATOM   2203  CG  LYS B 121      14.523 -20.327  46.017  1.00 23.86           C  
ATOM   2204  CD  LYS B 121      13.031 -20.440  45.853  1.00 26.10           C  
ATOM   2205  CE  LYS B 121      12.528 -21.757  46.399  1.00 28.54           C  
ATOM   2206  NZ  LYS B 121      11.044 -21.818  46.285  1.00 32.46           N  
ATOM   2207  N   HIS B 122      17.008 -16.375  45.515  1.00 16.36           N  
ATOM   2208  CA  HIS B 122      17.519 -15.196  44.815  1.00 14.94           C  
ATOM   2209  C   HIS B 122      18.969 -14.926  45.243  1.00 15.87           C  
ATOM   2210  O   HIS B 122      19.486 -13.807  45.104  1.00 16.31           O  
ATOM   2211  CB  HIS B 122      16.635 -13.978  45.106  1.00 17.74           C  
ATOM   2212  CG  HIS B 122      15.327 -14.000  44.378  1.00 19.58           C  
ATOM   2213  ND1 HIS B 122      15.106 -13.277  43.224  1.00 22.30           N  
ATOM   2214  CD2 HIS B 122      14.178 -14.675  44.625  1.00 20.14           C  
ATOM   2215  CE1 HIS B 122      13.873 -13.498  42.796  1.00 19.37           C  
ATOM   2216  NE2 HIS B 122      13.289 -14.342  43.628  1.00 22.72           N  
ATOM   2217  N   LYS B 123      19.611 -15.975  45.754  1.00 15.50           N  
ATOM   2218  CA  LYS B 123      21.002 -15.948  46.193  1.00 16.57           C  
ATOM   2219  C   LYS B 123      21.332 -14.806  47.150  1.00 16.81           C  
ATOM   2220  O   LYS B 123      22.358 -14.143  47.009  1.00 17.26           O  
ATOM   2221  CB  LYS B 123      21.941 -15.878  44.982  1.00 19.72           C  
ATOM   2222  CG  LYS B 123      21.609 -16.860  43.871  1.00 23.55           C  
ATOM   2223  CD  LYS B 123      21.572 -18.287  44.366  1.00 26.34           C  
ATOM   2224  CE  LYS B 123      21.121 -19.210  43.238  1.00 28.51           C  
ATOM   2225  NZ  LYS B 123      20.789 -20.589  43.709  1.00 29.84           N  
ATOM   2226  N   ARG B 124      20.461 -14.570  48.122  1.00 15.20           N  
ATOM   2227  CA  ARG B 124      20.710 -13.522  49.093  1.00 12.88           C  
ATOM   2228  C   ARG B 124      21.172 -14.241  50.349  1.00 15.71           C  
ATOM   2229  O   ARG B 124      20.590 -15.271  50.733  1.00 19.93           O  
ATOM   2230  CB  ARG B 124      19.436 -12.721  49.340  1.00 13.08           C  
ATOM   2231  CG  ARG B 124      18.855 -12.125  48.070  1.00 13.18           C  
ATOM   2232  CD  ARG B 124      19.736 -11.000  47.501  1.00 14.36           C  
ATOM   2233  NE  ARG B 124      19.435 -10.755  46.088  1.00 13.69           N  
ATOM   2234  CZ  ARG B 124      19.623  -9.595  45.462  1.00 17.10           C  
ATOM   2235  NH1 ARG B 124      20.108  -8.543  46.109  1.00 15.94           N  
ATOM   2236  NH2 ARG B 124      19.339  -9.483  44.174  1.00 17.04           N  
ATOM   2237  N   GLY B 125      22.251 -13.753  50.948  1.00 13.93           N  
ATOM   2238  CA  GLY B 125      22.755 -14.385  52.151  1.00 13.97           C  
ATOM   2239  C   GLY B 125      22.465 -13.555  53.378  1.00 13.88           C  
ATOM   2240  O   GLY B 125      22.609 -14.021  54.507  1.00 13.04           O  
ATOM   2241  N   LEU B 126      22.042 -12.320  53.163  1.00 12.83           N  
ATOM   2242  CA  LEU B 126      21.769 -11.438  54.290  1.00 12.01           C  
ATOM   2243  C   LEU B 126      20.441 -10.735  54.172  1.00 10.72           C  
ATOM   2244  O   LEU B 126      20.173 -10.103  53.157  1.00 10.46           O  
ATOM   2245  CB  LEU B 126      22.850 -10.359  54.396  1.00  9.37           C  
ATOM   2246  CG  LEU B 126      22.491  -9.324  55.486  1.00 13.17           C  
ATOM   2247  CD1 LEU B 126      22.740  -9.962  56.836  1.00 12.16           C  
ATOM   2248  CD2 LEU B 126      23.293  -8.047  55.342  1.00 14.89           C  
ATOM   2249  N   LEU B 127      19.609 -10.859  55.202  1.00  8.92           N  
ATOM   2250  CA  LEU B 127      18.338 -10.128  55.254  1.00  9.13           C  
ATOM   2251  C   LEU B 127      18.490  -9.129  56.389  1.00 10.01           C  
ATOM   2252  O   LEU B 127      19.049  -9.463  57.443  1.00 13.38           O  
ATOM   2253  CB  LEU B 127      17.171 -11.046  55.600  1.00  9.85           C  
ATOM   2254  CG  LEU B 127      16.812 -12.108  54.568  1.00 11.10           C  
ATOM   2255  CD1 LEU B 127      15.507 -12.804  54.990  1.00 13.20           C  
ATOM   2256  CD2 LEU B 127      16.669 -11.462  53.210  1.00 12.48           C  
ATOM   2257  N   HIS B 128      18.003  -7.907  56.203  1.00  8.15           N  
ATOM   2258  CA  HIS B 128      18.103  -6.929  57.280  1.00  9.85           C  
ATOM   2259  C   HIS B 128      16.831  -6.099  57.274  1.00 10.34           C  
ATOM   2260  O   HIS B 128      16.084  -6.091  56.289  1.00 10.79           O  
ATOM   2261  CB  HIS B 128      19.352  -6.042  57.106  1.00 10.59           C  
ATOM   2262  CG  HIS B 128      19.263  -5.076  55.971  1.00 12.48           C  
ATOM   2263  ND1 HIS B 128      19.518  -5.436  54.668  1.00 13.58           N  
ATOM   2264  CD2 HIS B 128      18.925  -3.763  55.940  1.00 10.87           C  
ATOM   2265  CE1 HIS B 128      19.344  -4.389  53.880  1.00 13.04           C  
ATOM   2266  NE2 HIS B 128      18.983  -3.362  54.627  1.00 16.46           N  
ATOM   2267  N   LEU B 129      16.580  -5.403  58.373  1.00  9.66           N  
ATOM   2268  CA  LEU B 129      15.381  -4.596  58.480  1.00  9.56           C  
ATOM   2269  C   LEU B 129      15.507  -3.705  59.691  1.00 10.40           C  
ATOM   2270  O   LEU B 129      16.452  -3.818  60.477  1.00 10.54           O  
ATOM   2271  CB  LEU B 129      14.182  -5.522  58.675  1.00 10.94           C  
ATOM   2272  CG  LEU B 129      14.313  -6.471  59.892  1.00 11.57           C  
ATOM   2273  CD1 LEU B 129      13.675  -5.865  61.145  1.00 12.29           C  
ATOM   2274  CD2 LEU B 129      13.615  -7.769  59.576  1.00 13.95           C  
ATOM   2275  N   ASP B 130      14.545  -2.807  59.839  1.00 11.81           N  
ATOM   2276  CA  ASP B 130      14.530  -1.983  61.044  1.00 13.59           C  
ATOM   2277  C   ASP B 130      13.066  -1.850  61.405  1.00 14.17           C  
ATOM   2278  O   ASP B 130      12.197  -1.834  60.515  1.00 13.98           O  
ATOM   2279  CB  ASP B 130      15.175  -0.620  60.824  1.00 18.71           C  
ATOM   2280  CG  ASP B 130      14.350   0.272  59.961  1.00 23.28           C  
ATOM   2281  OD1 ASP B 130      14.506   0.198  58.725  1.00 24.93           O  
ATOM   2282  OD2 ASP B 130      13.536   1.041  60.520  1.00 24.86           O  
ATOM   2283  N   THR B 131      12.794  -1.779  62.704  1.00 12.57           N  
ATOM   2284  CA  THR B 131      11.436  -1.680  63.205  1.00 13.39           C  
ATOM   2285  C   THR B 131      11.431  -0.790  64.446  1.00 14.05           C  
ATOM   2286  O   THR B 131      12.439  -0.704  65.145  1.00 12.42           O  
ATOM   2287  CB  THR B 131      10.902  -3.094  63.553  1.00 16.14           C  
ATOM   2288  OG1 THR B 131       9.499  -3.033  63.797  1.00 20.41           O  
ATOM   2289  CG2 THR B 131      11.615  -3.673  64.761  1.00 17.93           C  
ATOM   2290  N   GLU B 132      10.298  -0.138  64.722  1.00 12.91           N  
ATOM   2291  CA  GLU B 132      10.187   0.736  65.889  1.00 13.46           C  
ATOM   2292  C   GLU B 132      10.673   0.039  67.164  1.00 13.48           C  
ATOM   2293  O   GLU B 132      10.216  -1.054  67.509  1.00 12.49           O  
ATOM   2294  CB  GLU B 132       8.731   1.204  66.073  1.00 15.53           C  
ATOM   2295  CG  GLU B 132       8.542   2.122  67.312  1.00 17.67           C  
ATOM   2296  CD  GLU B 132       7.075   2.311  67.716  1.00 24.32           C  
ATOM   2297  OE1 GLU B 132       6.187   1.949  66.927  1.00 24.81           O  
ATOM   2298  OE2 GLU B 132       6.810   2.831  68.829  1.00 27.31           O  
ATOM   2299  N   ALA B 133      11.619   0.668  67.863  1.00 12.98           N  
ATOM   2300  CA  ALA B 133      12.164   0.080  69.070  1.00 13.81           C  
ATOM   2301  C   ALA B 133      11.048  -0.043  70.106  1.00 14.05           C  
ATOM   2302  O   ALA B 133      10.254   0.882  70.296  1.00 14.86           O  
ATOM   2303  CB  ALA B 133      13.329   0.959  69.615  1.00 13.10           C  
ATOM   2304  N   GLY B 134      10.977  -1.190  70.757  1.00 14.32           N  
ATOM   2305  CA  GLY B 134       9.954  -1.375  71.772  1.00 15.47           C  
ATOM   2306  C   GLY B 134       8.629  -1.915  71.271  1.00 14.54           C  
ATOM   2307  O   GLY B 134       7.736  -2.239  72.068  1.00 15.76           O  
ATOM   2308  N   SER B 135       8.483  -2.032  69.956  1.00 13.33           N  
ATOM   2309  CA  SER B 135       7.232  -2.527  69.401  1.00 12.60           C  
ATOM   2310  C   SER B 135       7.152  -4.045  69.502  1.00 13.76           C  
ATOM   2311  O   SER B 135       8.154  -4.707  69.761  1.00 13.38           O  
ATOM   2312  CB  SER B 135       7.107  -2.110  67.930  1.00 14.80           C  
ATOM   2313  OG  SER B 135       8.138  -2.697  67.156  1.00 16.10           O  
ATOM   2314  N   VAL B 136       5.954  -4.593  69.298  1.00 11.08           N  
ATOM   2315  CA  VAL B 136       5.796  -6.036  69.313  1.00 12.77           C  
ATOM   2316  C   VAL B 136       6.674  -6.675  68.259  1.00 12.26           C  
ATOM   2317  O   VAL B 136       7.163  -7.803  68.443  1.00 12.39           O  
ATOM   2318  CB  VAL B 136       4.318  -6.434  69.049  1.00 13.47           C  
ATOM   2319  CG1 VAL B 136       4.201  -7.941  68.778  1.00 14.76           C  
ATOM   2320  CG2 VAL B 136       3.492  -6.054  70.261  1.00 15.37           C  
ATOM   2321  N   ALA B 137       6.896  -5.949  67.158  1.00 11.44           N  
ATOM   2322  CA  ALA B 137       7.715  -6.489  66.076  1.00 10.46           C  
ATOM   2323  C   ALA B 137       9.112  -6.876  66.587  1.00 10.99           C  
ATOM   2324  O   ALA B 137       9.735  -7.804  66.044  1.00 10.19           O  
ATOM   2325  CB  ALA B 137       7.806  -5.479  64.925  1.00 11.30           C  
ATOM   2326  N   GLU B 138       9.622  -6.185  67.616  1.00 10.87           N  
ATOM   2327  CA  GLU B 138      10.934  -6.567  68.131  1.00 10.59           C  
ATOM   2328  C   GLU B 138      10.895  -7.979  68.686  1.00 10.47           C  
ATOM   2329  O   GLU B 138      11.783  -8.784  68.425  1.00 11.53           O  
ATOM   2330  CB  GLU B 138      11.413  -5.634  69.243  1.00 11.84           C  
ATOM   2331  CG  GLU B 138      11.838  -4.259  68.754  1.00 13.11           C  
ATOM   2332  CD  GLU B 138      13.122  -3.785  69.434  1.00 12.17           C  
ATOM   2333  OE1 GLU B 138      14.147  -4.466  69.290  1.00 16.22           O  
ATOM   2334  OE2 GLU B 138      13.118  -2.746  70.112  1.00 14.75           O  
ATOM   2335  N   ALA B 139       9.875  -8.289  69.474  1.00 11.89           N  
ATOM   2336  CA  ALA B 139       9.815  -9.636  70.043  1.00 10.32           C  
ATOM   2337  C   ALA B 139       9.602 -10.648  68.929  1.00  8.73           C  
ATOM   2338  O   ALA B 139      10.148 -11.739  68.979  1.00 10.03           O  
ATOM   2339  CB  ALA B 139       8.711  -9.728  71.067  1.00 12.50           C  
ATOM   2340  N   PHE B 140       8.803 -10.278  67.929  1.00  9.00           N  
ATOM   2341  CA  PHE B 140       8.551 -11.148  66.775  1.00  9.67           C  
ATOM   2342  C   PHE B 140       9.830 -11.487  66.008  1.00  9.04           C  
ATOM   2343  O   PHE B 140      10.131 -12.665  65.767  1.00  9.13           O  
ATOM   2344  CB  PHE B 140       7.553 -10.456  65.828  1.00  9.47           C  
ATOM   2345  CG  PHE B 140       7.376 -11.150  64.524  1.00  9.79           C  
ATOM   2346  CD1 PHE B 140       6.471 -12.191  64.375  1.00  9.74           C  
ATOM   2347  CD2 PHE B 140       8.100 -10.736  63.417  1.00 11.05           C  
ATOM   2348  CE1 PHE B 140       6.294 -12.802  63.132  1.00 10.26           C  
ATOM   2349  CE2 PHE B 140       7.929 -11.344  62.178  1.00 10.78           C  
ATOM   2350  CZ  PHE B 140       7.024 -12.376  62.034  1.00 13.45           C  
ATOM   2351  N   TYR B 141      10.599 -10.479  65.592  1.00  9.98           N  
ATOM   2352  CA  TYR B 141      11.805 -10.815  64.855  1.00  9.92           C  
ATOM   2353  C   TYR B 141      12.813 -11.537  65.735  1.00  8.60           C  
ATOM   2354  O   TYR B 141      13.530 -12.428  65.254  1.00  8.56           O  
ATOM   2355  CB  TYR B 141      12.433  -9.575  64.220  1.00  8.22           C  
ATOM   2356  CG  TYR B 141      11.602  -9.028  63.075  1.00 10.95           C  
ATOM   2357  CD1 TYR B 141      11.005  -7.792  63.178  1.00 14.19           C  
ATOM   2358  CD2 TYR B 141      11.423  -9.765  61.906  1.00 12.10           C  
ATOM   2359  CE1 TYR B 141      10.236  -7.279  62.137  1.00 17.42           C  
ATOM   2360  CE2 TYR B 141      10.641  -9.256  60.847  1.00 14.34           C  
ATOM   2361  CZ  TYR B 141      10.067  -8.013  60.995  1.00 15.98           C  
ATOM   2362  OH  TYR B 141       9.330  -7.474  59.974  1.00 23.00           O  
ATOM   2363  N   SER B 142      12.879 -11.161  67.010  1.00  9.79           N  
ATOM   2364  CA  SER B 142      13.805 -11.828  67.914  1.00 10.93           C  
ATOM   2365  C   SER B 142      13.423 -13.295  68.021  1.00 10.66           C  
ATOM   2366  O   SER B 142      14.299 -14.175  68.010  1.00 11.17           O  
ATOM   2367  CB  SER B 142      13.762 -11.160  69.295  1.00 10.07           C  
ATOM   2368  OG  SER B 142      14.366  -9.869  69.220  1.00 10.11           O  
ATOM   2369  N   ALA B 143      12.114 -13.572  68.088  1.00 10.96           N  
ATOM   2370  CA  ALA B 143      11.641 -14.949  68.205  1.00 11.11           C  
ATOM   2371  C   ALA B 143      11.925 -15.743  66.931  1.00 10.39           C  
ATOM   2372  O   ALA B 143      12.056 -16.976  66.975  1.00 12.08           O  
ATOM   2373  CB  ALA B 143      10.141 -14.973  68.522  1.00 11.93           C  
ATOM   2374  N   LEU B 144      12.021 -15.046  65.799  1.00 10.68           N  
ATOM   2375  CA  LEU B 144      12.314 -15.711  64.526  1.00 11.53           C  
ATOM   2376  C   LEU B 144      13.813 -15.810  64.263  1.00 12.51           C  
ATOM   2377  O   LEU B 144      14.256 -16.043  63.127  1.00 12.20           O  
ATOM   2378  CB  LEU B 144      11.636 -14.970  63.373  1.00 12.69           C  
ATOM   2379  CG  LEU B 144      10.226 -15.431  63.011  1.00 15.33           C  
ATOM   2380  CD1 LEU B 144       9.330 -15.502  64.231  1.00 14.98           C  
ATOM   2381  CD2 LEU B 144       9.673 -14.445  61.973  1.00 16.01           C  
ATOM   2382  N   ALA B 145      14.589 -15.609  65.320  1.00 10.55           N  
ATOM   2383  CA  ALA B 145      16.032 -15.723  65.274  1.00 11.24           C  
ATOM   2384  C   ALA B 145      16.783 -14.644  64.526  1.00 11.59           C  
ATOM   2385  O   ALA B 145      17.893 -14.883  64.044  1.00 14.13           O  
ATOM   2386  CB  ALA B 145      16.440 -17.128  64.759  1.00 11.77           C  
ATOM   2387  N   TYR B 146      16.183 -13.459  64.410  1.00 11.38           N  
ATOM   2388  CA  TYR B 146      16.902 -12.336  63.799  1.00 11.17           C  
ATOM   2389  C   TYR B 146      17.760 -11.748  64.901  1.00 10.63           C  
ATOM   2390  O   TYR B 146      17.356 -11.734  66.068  1.00 12.57           O  
ATOM   2391  CB  TYR B 146      15.942 -11.254  63.293  1.00 10.80           C  
ATOM   2392  CG  TYR B 146      15.353 -11.607  61.964  1.00 11.56           C  
ATOM   2393  CD1 TYR B 146      14.427 -12.634  61.864  1.00 13.46           C  
ATOM   2394  CD2 TYR B 146      15.792 -10.980  60.782  1.00 14.50           C  
ATOM   2395  CE1 TYR B 146      13.952 -13.056  60.632  1.00 17.16           C  
ATOM   2396  CE2 TYR B 146      15.322 -11.394  59.550  1.00 16.78           C  
ATOM   2397  CZ  TYR B 146      14.404 -12.441  59.489  1.00 16.08           C  
ATOM   2398  OH  TYR B 146      13.961 -12.939  58.292  1.00 19.51           O  
ATOM   2399  N   THR B 147      18.939 -11.254  64.545  1.00  8.73           N  
ATOM   2400  CA  THR B 147      19.858 -10.685  65.527  1.00 11.17           C  
ATOM   2401  C   THR B 147      19.720  -9.173  65.590  1.00 10.48           C  
ATOM   2402  O   THR B 147      19.705  -8.499  64.552  1.00 10.21           O  
ATOM   2403  CB  THR B 147      21.296 -11.036  65.166  1.00 11.42           C  
ATOM   2404  OG1 THR B 147      21.460 -12.465  65.234  1.00 12.53           O  
ATOM   2405  CG2 THR B 147      22.291 -10.359  66.125  1.00 13.46           C  
ATOM   2406  N   ARG B 148      19.643  -8.634  66.799  1.00  9.91           N  
ATOM   2407  CA  ARG B 148      19.494  -7.201  66.969  1.00 10.72           C  
ATOM   2408  C   ARG B 148      20.849  -6.538  66.932  1.00 11.86           C  
ATOM   2409  O   ARG B 148      21.788  -6.914  67.672  1.00 12.83           O  
ATOM   2410  CB  ARG B 148      18.828  -6.882  68.294  1.00 10.53           C  
ATOM   2411  CG  ARG B 148      18.330  -5.430  68.432  1.00 10.73           C  
ATOM   2412  CD  ARG B 148      17.667  -5.287  69.796  1.00 10.15           C  
ATOM   2413  NE  ARG B 148      16.737  -4.159  69.879  1.00 12.97           N  
ATOM   2414  CZ  ARG B 148      17.009  -2.996  70.463  1.00 11.49           C  
ATOM   2415  NH1 ARG B 148      18.210  -2.772  71.024  1.00 12.42           N  
ATOM   2416  NH2 ARG B 148      16.058  -2.066  70.525  1.00 11.04           N  
ATOM   2417  N   VAL B 149      20.962  -5.542  66.070  1.00  9.35           N  
ATOM   2418  CA  VAL B 149      22.231  -4.843  65.959  1.00  9.95           C  
ATOM   2419  C   VAL B 149      22.287  -3.712  66.983  1.00 10.59           C  
ATOM   2420  O   VAL B 149      23.286  -3.542  67.709  1.00 12.03           O  
ATOM   2421  CB  VAL B 149      22.391  -4.276  64.549  1.00  9.32           C  
ATOM   2422  CG1 VAL B 149      23.680  -3.446  64.449  1.00 12.30           C  
ATOM   2423  CG2 VAL B 149      22.435  -5.424  63.561  1.00 12.43           C  
ATOM   2424  N   GLY B 150      21.203  -2.950  67.051  1.00 10.71           N  
ATOM   2425  CA  GLY B 150      21.150  -1.825  67.962  1.00 12.93           C  
ATOM   2426  C   GLY B 150      20.107  -0.850  67.479  1.00 12.88           C  
ATOM   2427  O   GLY B 150      19.339  -1.164  66.577  1.00 14.01           O  
ATOM   2428  N   GLU B 151      20.087   0.335  68.074  1.00 11.61           N  
ATOM   2429  CA  GLU B 151      19.108   1.376  67.749  1.00 12.93           C  
ATOM   2430  C   GLU B 151      19.665   2.655  67.116  1.00 13.60           C  
ATOM   2431  O   GLU B 151      20.822   3.008  67.330  1.00 14.09           O  
ATOM   2432  CB  GLU B 151      18.397   1.824  69.033  1.00 15.73           C  
ATOM   2433  CG  GLU B 151      17.461   0.820  69.664  1.00 18.51           C  
ATOM   2434  CD  GLU B 151      16.937   1.289  71.026  1.00 20.81           C  
ATOM   2435  OE1 GLU B 151      17.057   2.503  71.334  1.00 21.99           O  
ATOM   2436  OE2 GLU B 151      16.390   0.453  71.788  1.00 20.67           O  
ATOM   2437  N   LEU B 152      18.826   3.348  66.346  1.00 12.64           N  
ATOM   2438  CA  LEU B 152      19.191   4.659  65.811  1.00 11.18           C  
ATOM   2439  C   LEU B 152      18.130   5.553  66.488  1.00 12.54           C  
ATOM   2440  O   LEU B 152      16.943   5.391  66.244  1.00 12.44           O  
ATOM   2441  CB  LEU B 152      19.049   4.750  64.285  1.00 11.81           C  
ATOM   2442  CG  LEU B 152      20.075   4.032  63.400  1.00 13.72           C  
ATOM   2443  CD1 LEU B 152      19.681   4.205  61.917  1.00 15.44           C  
ATOM   2444  CD2 LEU B 152      21.480   4.605  63.660  1.00 15.35           C  
ATOM   2445  N   PRO B 153      18.553   6.504  67.335  1.00 12.12           N  
ATOM   2446  CA  PRO B 153      17.611   7.394  68.029  1.00 13.60           C  
ATOM   2447  C   PRO B 153      16.958   8.417  67.112  1.00 12.60           C  
ATOM   2448  O   PRO B 153      17.591   8.902  66.173  1.00 13.39           O  
ATOM   2449  CB  PRO B 153      18.493   8.070  69.076  1.00 14.66           C  
ATOM   2450  CG  PRO B 153      19.796   8.217  68.337  1.00 13.90           C  
ATOM   2451  CD  PRO B 153      19.945   6.840  67.687  1.00 14.36           C  
ATOM   2452  N   GLY B 154      15.698   8.753  67.414  1.00 12.31           N  
ATOM   2453  CA  GLY B 154      14.958   9.743  66.638  1.00 13.18           C  
ATOM   2454  C   GLY B 154      14.834   9.407  65.169  1.00 13.95           C  
ATOM   2455  O   GLY B 154      14.787  10.291  64.314  1.00 13.44           O  
ATOM   2456  N   TYR B 155      14.752   8.116  64.867  1.00 11.78           N  
ATOM   2457  CA  TYR B 155      14.668   7.662  63.489  1.00 13.32           C  
ATOM   2458  C   TYR B 155      13.320   7.908  62.833  1.00 15.41           C  
ATOM   2459  O   TYR B 155      13.249   8.439  61.724  1.00 16.03           O  
ATOM   2460  CB  TYR B 155      14.949   6.158  63.425  1.00 14.19           C  
ATOM   2461  CG  TYR B 155      15.193   5.629  62.028  1.00 12.74           C  
ATOM   2462  CD1 TYR B 155      16.462   5.702  61.461  1.00 15.11           C  
ATOM   2463  CD2 TYR B 155      14.180   4.990  61.310  1.00 15.23           C  
ATOM   2464  CE1 TYR B 155      16.724   5.142  60.220  1.00 16.49           C  
ATOM   2465  CE2 TYR B 155      14.436   4.420  60.063  1.00 15.81           C  
ATOM   2466  CZ  TYR B 155      15.709   4.499  59.534  1.00 17.84           C  
ATOM   2467  OH  TYR B 155      15.997   3.915  58.323  1.00 17.99           O  
ATOM   2468  N   CYS B 156      12.262   7.502  63.532  1.00 17.01           N  
ATOM   2469  CA  CYS B 156      10.908   7.582  63.014  1.00 21.50           C  
ATOM   2470  C   CYS B 156       9.960   8.216  64.002  1.00 21.97           C  
ATOM   2471  O   CYS B 156      10.169   8.146  65.209  1.00 22.05           O  
ATOM   2472  CB  CYS B 156      10.410   6.156  62.674  1.00 22.31           C  
ATOM   2473  SG  CYS B 156      10.827   4.875  63.948  1.00 35.03           S  
ATOM   2474  N   ALA B 157       8.916   8.843  63.481  1.00 21.37           N  
ATOM   2475  CA  ALA B 157       7.909   9.449  64.336  1.00 21.39           C  
ATOM   2476  C   ALA B 157       6.734   8.472  64.353  1.00 22.04           C  
ATOM   2477  O   ALA B 157       6.365   7.932  63.310  1.00 21.63           O  
ATOM   2478  CB  ALA B 157       7.471  10.801  63.764  1.00 22.17           C  
ATOM   2479  N   THR B 158       6.168   8.218  65.533  1.00 21.00           N  
ATOM   2480  CA  THR B 158       5.018   7.330  65.631  1.00 22.81           C  
ATOM   2481  C   THR B 158       3.882   8.085  64.937  1.00 22.75           C  
ATOM   2482  O   THR B 158       3.982   9.288  64.740  1.00 21.92           O  
ATOM   2483  CB  THR B 158       4.632   7.071  67.100  1.00 24.42           C  
ATOM   2484  OG1 THR B 158       4.291   8.311  67.723  1.00 26.15           O  
ATOM   2485  CG2 THR B 158       5.788   6.441  67.852  1.00 26.27           C  
ATOM   2486  N   PRO B 159       2.785   7.391  64.564  1.00 23.19           N  
ATOM   2487  CA  PRO B 159       1.676   8.076  63.885  1.00 24.53           C  
ATOM   2488  C   PRO B 159       1.181   9.334  64.603  1.00 25.63           C  
ATOM   2489  O   PRO B 159       0.783  10.313  63.957  1.00 24.04           O  
ATOM   2490  CB  PRO B 159       0.601   6.990  63.787  1.00 24.52           C  
ATOM   2491  CG  PRO B 159       1.409   5.734  63.669  1.00 25.27           C  
ATOM   2492  CD  PRO B 159       2.519   5.947  64.692  1.00 24.58           C  
ATOM   2493  N   ASP B 160       1.216   9.303  65.932  1.00 27.87           N  
ATOM   2494  CA  ASP B 160       0.790  10.440  66.748  1.00 30.43           C  
ATOM   2495  C   ASP B 160       1.851  11.559  66.808  1.00 30.67           C  
ATOM   2496  O   ASP B 160       1.658  12.568  67.495  1.00 31.91           O  
ATOM   2497  CB  ASP B 160       0.459   9.956  68.163  1.00 34.05           C  
ATOM   2498  CG  ASP B 160       1.674   9.411  68.890  1.00 37.02           C  
ATOM   2499  OD1 ASP B 160       1.502   8.582  69.808  1.00 39.88           O  
ATOM   2500  OD2 ASP B 160       2.804   9.821  68.552  1.00 38.99           O  
ATOM   2501  N   GLY B 161       2.973  11.366  66.108  1.00 29.52           N  
ATOM   2502  CA  GLY B 161       4.023  12.373  66.057  1.00 27.40           C  
ATOM   2503  C   GLY B 161       5.227  12.279  66.989  1.00 27.12           C  
ATOM   2504  O   GLY B 161       6.112  13.135  66.928  1.00 27.54           O  
ATOM   2505  N   ARG B 162       5.303  11.262  67.835  1.00 24.26           N  
ATOM   2506  CA  ARG B 162       6.442  11.177  68.748  1.00 24.71           C  
ATOM   2507  C   ARG B 162       7.668  10.482  68.169  1.00 24.29           C  
ATOM   2508  O   ARG B 162       7.578   9.361  67.669  1.00 23.54           O  
ATOM   2509  CB  ARG B 162       5.993  10.525  70.053  1.00 26.51           C  
ATOM   2510  CG  ARG B 162       5.243  11.539  70.934  1.00 28.62           C  
ATOM   2511  CD  ARG B 162       4.290  12.414  70.078  1.00 30.63           C  
ATOM   2512  NE  ARG B 162       3.963  13.723  70.660  1.00 33.13           N  
ATOM   2513  CZ  ARG B 162       4.827  14.733  70.798  1.00 33.54           C  
ATOM   2514  NH1 ARG B 162       6.091  14.603  70.403  1.00 33.50           N  
ATOM   2515  NH2 ARG B 162       4.417  15.888  71.318  1.00 33.63           N  
ATOM   2516  N   LEU B 163       8.810  11.168  68.229  1.00 23.78           N  
ATOM   2517  CA  LEU B 163      10.074  10.633  67.705  1.00 22.33           C  
ATOM   2518  C   LEU B 163      10.594   9.481  68.541  1.00 21.60           C  
ATOM   2519  O   LEU B 163      10.759   9.589  69.760  1.00 23.32           O  
ATOM   2520  CB  LEU B 163      11.133  11.735  67.626  1.00 23.46           C  
ATOM   2521  CG  LEU B 163      10.947  12.746  66.489  1.00 25.12           C  
ATOM   2522  CD1 LEU B 163      12.020  13.811  66.562  1.00 26.15           C  
ATOM   2523  CD2 LEU B 163      11.011  12.005  65.152  1.00 26.02           C  
ATOM   2524  N   HIS B 164      10.865   8.365  67.877  1.00 18.46           N  
ATOM   2525  CA  HIS B 164      11.301   7.174  68.566  1.00 16.91           C  
ATOM   2526  C   HIS B 164      12.465   6.553  67.830  1.00 14.81           C  
ATOM   2527  O   HIS B 164      12.689   6.823  66.649  1.00 12.26           O  
ATOM   2528  CB  HIS B 164      10.166   6.132  68.596  1.00 20.66           C  
ATOM   2529  CG  HIS B 164       9.191   6.298  69.721  1.00 26.94           C  
ATOM   2530  ND1 HIS B 164       8.116   5.448  69.897  1.00 28.88           N  
ATOM   2531  CD2 HIS B 164       9.132   7.193  70.737  1.00 28.55           C  
ATOM   2532  CE1 HIS B 164       7.439   5.811  70.975  1.00 30.87           C  
ATOM   2533  NE2 HIS B 164       8.035   6.867  71.503  1.00 31.88           N  
ATOM   2534  N   PRO B 165      13.211   5.690  68.518  1.00 13.35           N  
ATOM   2535  CA  PRO B 165      14.349   5.033  67.893  1.00 12.83           C  
ATOM   2536  C   PRO B 165      13.856   3.866  67.065  1.00 13.26           C  
ATOM   2537  O   PRO B 165      12.749   3.355  67.288  1.00 13.19           O  
ATOM   2538  CB  PRO B 165      15.156   4.518  69.082  1.00 13.61           C  
ATOM   2539  CG  PRO B 165      14.689   5.359  70.236  1.00 16.77           C  
ATOM   2540  CD  PRO B 165      13.220   5.470  69.971  1.00 15.05           C  
ATOM   2541  N   THR B 166      14.664   3.457  66.094  1.00 11.13           N  
ATOM   2542  CA  THR B 166      14.316   2.271  65.322  1.00 11.92           C  
ATOM   2543  C   THR B 166      15.368   1.243  65.718  1.00 10.59           C  
ATOM   2544  O   THR B 166      16.498   1.606  66.062  1.00 13.49           O  
ATOM   2545  CB  THR B 166      14.368   2.513  63.811  1.00 12.69           C  
ATOM   2546  OG1 THR B 166      13.659   1.453  63.148  1.00 15.33           O  
ATOM   2547  CG2 THR B 166      15.806   2.499  63.300  1.00 15.04           C  
ATOM   2548  N   ALA B 167      15.005  -0.033  65.687  1.00 10.34           N  
ATOM   2549  CA  ALA B 167      15.934  -1.115  66.008  1.00 11.46           C  
ATOM   2550  C   ALA B 167      16.268  -1.836  64.716  1.00 10.35           C  
ATOM   2551  O   ALA B 167      15.364  -2.192  63.959  1.00 11.81           O  
ATOM   2552  CB  ALA B 167      15.309  -2.092  66.965  1.00  9.39           C  
ATOM   2553  N   ILE B 168      17.557  -2.065  64.487  1.00 10.18           N  
ATOM   2554  CA  ILE B 168      18.053  -2.740  63.286  1.00 10.24           C  
ATOM   2555  C   ILE B 168      18.309  -4.209  63.595  1.00 10.74           C  
ATOM   2556  O   ILE B 168      18.954  -4.531  64.591  1.00 11.69           O  
ATOM   2557  CB  ILE B 168      19.366  -2.056  62.808  1.00 11.10           C  
ATOM   2558  CG1 ILE B 168      19.044  -0.622  62.355  1.00 13.42           C  
ATOM   2559  CG2 ILE B 168      20.018  -2.845  61.674  1.00 12.33           C  
ATOM   2560  CD1 ILE B 168      20.253   0.270  62.198  1.00 18.41           C  
ATOM   2561  N   TYR B 169      17.796  -5.083  62.734  1.00  9.28           N  
ATOM   2562  CA  TYR B 169      17.930  -6.530  62.869  1.00  9.96           C  
ATOM   2563  C   TYR B 169      18.436  -7.142  61.565  1.00  8.70           C  
ATOM   2564  O   TYR B 169      18.237  -6.577  60.481  1.00  9.98           O  
ATOM   2565  CB  TYR B 169      16.558  -7.159  63.119  1.00 11.20           C  
ATOM   2566  CG  TYR B 169      16.022  -7.059  64.520  1.00 10.82           C  
ATOM   2567  CD1 TYR B 169      15.353  -5.929  64.961  1.00 11.85           C  
ATOM   2568  CD2 TYR B 169      16.191  -8.115  65.399  1.00 10.80           C  
ATOM   2569  CE1 TYR B 169      14.863  -5.848  66.270  1.00 11.99           C  
ATOM   2570  CE2 TYR B 169      15.713  -8.055  66.684  1.00  9.73           C  
ATOM   2571  CZ  TYR B 169      15.052  -6.925  67.127  1.00 11.15           C  
ATOM   2572  OH  TYR B 169      14.598  -6.888  68.436  1.00 12.81           O  
ATOM   2573  N   PHE B 170      19.091  -8.301  61.655  1.00 10.18           N  
ATOM   2574  CA  PHE B 170      19.522  -9.003  60.442  1.00 10.06           C  
ATOM   2575  C   PHE B 170      19.491 -10.515  60.673  1.00 10.58           C  
ATOM   2576  O   PHE B 170      19.397 -10.996  61.809  1.00 10.49           O  
ATOM   2577  CB  PHE B 170      20.950  -8.601  60.035  1.00 10.13           C  
ATOM   2578  CG  PHE B 170      22.026  -9.208  60.915  1.00 12.06           C  
ATOM   2579  CD1 PHE B 170      22.550 -10.480  60.641  1.00 12.62           C  
ATOM   2580  CD2 PHE B 170      22.478  -8.527  62.030  1.00 11.58           C  
ATOM   2581  CE1 PHE B 170      23.506 -11.053  61.482  1.00 13.08           C  
ATOM   2582  CE2 PHE B 170      23.438  -9.087  62.878  1.00 14.47           C  
ATOM   2583  CZ  PHE B 170      23.955 -10.364  62.601  1.00 12.89           C  
ATOM   2584  N   LYS B 171      19.541 -11.266  59.586  1.00 10.85           N  
ATOM   2585  CA  LYS B 171      19.641 -12.707  59.708  1.00 11.30           C  
ATOM   2586  C   LYS B 171      20.483 -13.165  58.546  1.00 11.70           C  
ATOM   2587  O   LYS B 171      20.277 -12.738  57.403  1.00 13.17           O  
ATOM   2588  CB  LYS B 171      18.286 -13.428  59.660  1.00 11.05           C  
ATOM   2589  CG  LYS B 171      18.471 -14.958  59.805  1.00 14.62           C  
ATOM   2590  CD  LYS B 171      17.185 -15.753  59.562  1.00 18.19           C  
ATOM   2591  CE  LYS B 171      16.251 -15.707  60.765  1.00 19.74           C  
ATOM   2592  NZ  LYS B 171      15.074 -16.635  60.574  1.00 18.98           N  
ATOM   2593  N   THR B 172      21.469 -14.000  58.842  1.00 12.42           N  
ATOM   2594  CA  THR B 172      22.318 -14.546  57.802  1.00 12.05           C  
ATOM   2595  C   THR B 172      21.672 -15.850  57.373  1.00 14.90           C  
ATOM   2596  O   THR B 172      21.465 -16.739  58.196  1.00 14.67           O  
ATOM   2597  CB  THR B 172      23.740 -14.800  58.346  1.00 14.04           C  
ATOM   2598  OG1 THR B 172      24.357 -13.541  58.671  1.00 13.61           O  
ATOM   2599  CG2 THR B 172      24.598 -15.516  57.303  1.00 14.83           C  
ATOM   2600  N   LEU B 173      21.355 -15.957  56.082  1.00 14.96           N  
ATOM   2601  CA  LEU B 173      20.688 -17.131  55.537  1.00 18.25           C  
ATOM   2602  C   LEU B 173      21.633 -18.252  55.134  1.00 20.74           C  
ATOM   2603  O   LEU B 173      22.770 -17.958  54.724  1.00 22.71           O  
ATOM   2604  CB  LEU B 173      19.845 -16.720  54.327  1.00 16.65           C  
ATOM   2605  CG  LEU B 173      18.797 -15.662  54.659  1.00 18.22           C  
ATOM   2606  CD1 LEU B 173      17.968 -15.332  53.438  1.00 18.91           C  
ATOM   2607  CD2 LEU B 173      17.911 -16.200  55.784  1.00 19.75           C  
TER    2608      LEU B 173                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
