
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1074),  selected  138 , name 1znp_D
# Molecule2: number of CA atoms  138 ( 1133),  selected  138 , name T0414.pdb
# PARAMETERS: 1znp_D.T0414.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     5_D      A       3           -
LGA    S     6_D      M       4           -
LGA    A     7_D      K       5           -
LGA    Q     8_D      P       6           -
LGA    A     9_D      D       7           -
LGA    I    10_D      I       8           -
LGA    I    11_D      -       -           -
LGA    R    12_D      -       -           -
LGA    E    13_D      Y       9           #
LGA    L    14_D      E      10          3.059
LGA    G    15_D      N      11          4.261
LGA    L    16_D      N      12          4.890
LGA    E    17_D      R      13          4.705
LGA    P    18_D      E      14          4.821
LGA    H    19_D      -       -           -
LGA    P    20_D      -       -           -
LGA    E    21_D      -       -           -
LGA    G    22_D      -       -           -
LGA    G    23_D      -       -           -
LGA    F    24_D      G      15          0.682
LGA    Y    25_D      I      16          1.095
LGA    H    26_D      L      17          0.676
LGA    Q    27_D      C      18          0.570
LGA    T    28_D      V      19          1.081
LGA    F    29_D      Y      20          1.354
LGA    R    30_D      K      21          1.378
LGA    D    31_D      N      22          1.673
LGA    K    32_D      E      23          3.375
LGA    A    33_D      -       -           -
LGA    G    34_D      -       -           -
LGA    G    35_D      -       -           -
LGA    E    36_D      -       -           -
LGA    R    37_D      -       -           -
LGA    G    38_D      -       -           -
LGA    H    39_D      K      24          1.426
LGA    S    40_D      W      25          1.037
LGA    T    41_D      L      26          0.992
LGA    A    42_D      V      27          0.657
LGA    I    43_D      C      28          0.438
LGA    Y    44_D      I      29          0.207
LGA    Y    45_D      K      30          0.566
LGA    L    46_D      N      31          1.013
LGA    L    47_D      W      32          1.761
LGA    E    48_D      K      33          5.270
LGA    K    49_D      -       -           -
LGA    G    50_D      -       -           -
LGA    V    51_D      P      34          3.239
LGA    R    52_D      D      35          3.930
LGA    S    53_D      N      36          3.201
LGA    -       -      D      37           -
LGA    -       -      I      38           -
LGA    -       -      E      39           -
LGA    -       -      G      40           -
LGA    -       -      I      41           -
LGA    -       -      A      42           -
LGA    H    54_D      H      43          3.258
LGA    W    55_D      L      44          1.055
LGA    H    56_D      E      45          0.943
LGA    R    57_D      I      46          1.241
LGA    V    58_D      H      47          1.328
LGA    T    59_D      H      48          1.657
LGA    D    60_D      S      49          1.015
LGA    A    61_D      T      50          0.600
LGA    V    62_D      D      51          0.364
LGA    E    63_D      E      52          0.685
LGA    V    64_D      Q      53          0.495
LGA    W    65_D      F      54          0.591
LGA    H    66_D      I      55          0.469
LGA    Y    67_D      L      56          0.656
LGA    Y    68_D      S      57          0.822
LGA    A    69_D      A      58          1.152
LGA    G    70_D      G      59          1.831
LGA    A    71_D      K      60          2.638
LGA    P    72_D      -       -           -
LGA    I    73_D      A      61          0.695
LGA    A    74_D      I      62          1.076
LGA    L    75_D      L      63          0.757
LGA    H    76_D      I      64          0.550
LGA    L    77_D      T      65          0.140
LGA    S    78_D      A      66          0.986
LGA    Q    79_D      E      67          3.511
LGA    D    80_D      K      68          3.718
LGA    G    81_D      E      69           #
LGA    R    82_D      N      70           #
LGA    -       -      D      71           -
LGA    -       -      K      72           -
LGA    -       -      F      73           -
LGA    E    83_D      N      74          1.764
LGA    V    84_D      I      75          1.645
LGA    Q    85_D      E      76          1.443
LGA    T    86_D      L      77          1.201
LGA    F    87_D      T      78          1.090
LGA    T    88_D      L      79          0.985
LGA    L    89_D      M      80          1.061
LGA    G    90_D      E      81          2.033
LGA    P    91_D      K      82          2.203
LGA    A    92_D      G      83           -
LGA    I    93_D      -       -           -
LGA    L    94_D      -       -           -
LGA    E    95_D      -       -           -
LGA    G    96_D      -       -           -
LGA    E    97_D      -       -           -
LGA    R    98_D      -       -           -
LGA    P    99_D      K      84          2.997
LGA    Q   100_D      V      85          1.669
LGA    V   101_D      Y      86          0.863
LGA    I   102_D      N      87          0.501
LGA    V   103_D      V      88          0.334
LGA    P   104_D      P      89          0.862
LGA    A   105_D      A      90          0.408
LGA    N   106_D      E      91          1.905
LGA    C   107_D      C      92          1.100
LGA    W   108_D      W      93          0.730
LGA    Q   109_D      F      94          0.779
LGA    S   110_D      Y      95          1.663
LGA    A   111_D      S      96          1.503
LGA    E   112_D      I      97          0.947
LGA    S   113_D      T      98          1.680
LGA    L   114_D      -       -           -
LGA    G   115_D      Q      99          4.034
LGA    D   116_D      K     100          3.447
LGA    F   117_D      D     101          2.158
LGA    T   118_D      T     102          0.976
LGA    L   119_D      K     103          0.271
LGA    V   120_D      M     104          0.216
LGA    G   121_D      M     105          0.612
LGA    C   122_D      Y     106          0.647
LGA    T   123_D      V     107          0.270
LGA    V   124_D      Q     108          0.530
LGA    S   125_D      -       -           -
LGA    P   126_D      D     109          3.127
LGA    G   127_D      S     110          2.546
LGA    F   128_D      N     111          3.968
LGA    A   129_D      C     112          1.051
LGA    F   130_D      S     113          2.562
LGA    S   131_D      M     114          2.692
LGA    -       -      D     115           -
LGA    S   132_D      N     116          1.973
LGA    F   133_D      S     117          2.639
LGA    V   134_D      D     118          1.277
LGA    X   135_D      F     119          0.992
LGA    A   136_D      C     120          0.935
LGA    E   137_D      D     121          3.002
LGA    P   138_D      L     122           #
LGA    G   139_D      S     123          4.019
LGA    W   140_D      K     124           #
LGA    -       -      E     125           -
LGA    S   141_D      E     126          4.346
LGA    P   142_D      I     127           -
LGA    -       -      E     128           -
LGA    -       -      Y     129           -
LGA    -       -      I     130           -
LGA    -       -      Q     131           -
LGA    -       -      T     132           -
LGA    -       -      N     133           -
LGA    -       -      A     134           -
LGA    -       -      R     135           -
LGA    -       -      K     136           -
LGA    -       -      L     137           -
LGA    -       -      F     138           -
LGA    -       -      E     139           -
LGA    -       -      K     140           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  138    5.0    101    2.10    10.89     63.085     4.589

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.982037 * X  +   0.186838 * Y  +  -0.026347 * Z  +  90.878448
  Y_new =  -0.180610 * X  +  -0.971208 * Y  +  -0.155356 * Z  +  44.263897
  Z_new =  -0.054615 * X  +  -0.147807 * Y  +   0.987507 * Z  + -110.487984 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.148574    2.993019  [ DEG:    -8.5126    171.4874 ]
  Theta =   0.054642    3.086951  [ DEG:     3.1308    176.8692 ]
  Phi   =  -2.959712    0.181881  [ DEG:  -169.5790     10.4210 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1znp_D                                        
REMARK     2: T0414.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1znp_D.T0414.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  138   5.0  101   2.10   10.89  63.085
REMARK  ---------------------------------------------------------- 
MOLECULE 1znp_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   11-MAY-05   1ZNP              
TITLE     X-RAY CRYSTAL STRUCTURE OF PROTEIN Q8U9W0 FROM                        
TITLE    2 AGROBACTERIUM TUMEFACIENS. NORTHEAST STRUCTURAL GENOMICS             
TITLE    3 CONSORTIUM TARGET ATR55.                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN ATU3615;                              
COMPND   3 CHAIN: A, B, C, D, E, F, G;                                          
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: C58 / ATCC 33970;                                            
SOURCE   5 GENE: AGR L 2421;                                                    
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3) + MAGIC;                        
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_VECTOR: PET21                                      
KEYWDS    X-RAY, NESG, ATR55, Q8U9W0, STRUCTURAL GENOMICS, PSI,                 
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS          
KEYWDS   3 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,Y.CHEN,F.FOROUHAR,S.M.VOROBIEV,R.XIAO,L.-C.MA,              
AUTHOR   2 T.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL          
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   24-MAY-05 1ZNP    0                                                
JRNL        AUTH   A.P.KUZIN,Y.CHEN,F.FOROUHAR,S.M.VOROBIEV,R.XIAO,             
JRNL        AUTH 2 L.-C.MA,T.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG               
JRNL        TITL   X-RAY STRUCTURE OF THE HYPOTHETICAL PROTEIN Q8U9W0           
JRNL        TITL 2 FROM AGROBACTERIUM TUMEFACIENS. NORTHEAST                    
JRNL        TITL 3 STRUCTURAL GENOMICS CONSORTIUM TARGET ATR55.                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1ZNP A    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
DBREF  1ZNP B    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
DBREF  1ZNP C    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
DBREF  1ZNP D    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
DBREF  1ZNP E    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
DBREF  1ZNP F    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
DBREF  1ZNP G    1   146  UNP    Q8U9W0   Q8U9W0_AGRT5     1    146             
SEQRES   1 A  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 A  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 A  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 A  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 A  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 A  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 A  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 A  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 A  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 A  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 A  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 A  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 B  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 B  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 B  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 B  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 B  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 B  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 B  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 B  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 B  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 B  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 B  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 B  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 C  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 C  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 C  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 C  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 C  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 C  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 C  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 C  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 C  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 C  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 C  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 C  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 D  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 D  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 D  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 D  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 D  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 D  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 D  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 D  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 D  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 D  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 D  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 D  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 E  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 E  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 E  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 E  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 E  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 E  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 E  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 E  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 E  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 E  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 E  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 E  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 F  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 F  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 F  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 F  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 F  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 F  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 F  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 F  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 F  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 F  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 F  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 F  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
SEQRES   1 G  154  MSE GLY THR ASP MSE SER ALA GLN ALA ILE ILE ARG GLU          
SEQRES   2 G  154  LEU GLY LEU GLU PRO HIS PRO GLU GLY GLY PHE TYR HIS          
SEQRES   3 G  154  GLN THR PHE ARG ASP LYS ALA GLY GLY GLU ARG GLY HIS          
SEQRES   4 G  154  SER THR ALA ILE TYR TYR LEU LEU GLU LYS GLY VAL ARG          
SEQRES   5 G  154  SER HIS TRP HIS ARG VAL THR ASP ALA VAL GLU VAL TRP          
SEQRES   6 G  154  HIS TYR TYR ALA GLY ALA PRO ILE ALA LEU HIS LEU SER          
SEQRES   7 G  154  GLN ASP GLY ARG GLU VAL GLN THR PHE THR LEU GLY PRO          
SEQRES   8 G  154  ALA ILE LEU GLU GLY GLU ARG PRO GLN VAL ILE VAL PRO          
SEQRES   9 G  154  ALA ASN CYS TRP GLN SER ALA GLU SER LEU GLY ASP PHE          
SEQRES  10 G  154  THR LEU VAL GLY CYS THR VAL SER PRO GLY PHE ALA PHE          
SEQRES  11 G  154  SER SER PHE VAL MSE ALA GLU PRO GLY TRP SER PRO GLY          
SEQRES  12 G  154  ASP ALA PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
HET    MSE  A   5       8                                                       
HET    MSE  A 135       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B 135       8                                                       
HET    MSE  C   5       8                                                       
HET    MSE  C 135       8                                                       
HET    MSE  D   5       8                                                       
HET    MSE  D 135       8                                                       
HET    MSE  E   5       8                                                       
HET    MSE  E 135       8                                                       
HET    MSE  F   5       8                                                       
HET    MSE  F 135       8                                                       
HET    MSE  G   5       8                                                       
HET    MSE  G 135       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   8  HOH   *180(H2 O)                                                    
CRYST1   75.967   91.323  291.580  90.00  90.00  90.00 C 2 2 21     56          
HETATM 3250  N   MSE D   5      13.835  10.807  15.297  1.00 59.13           N  
HETATM 3251  CA  MSE D   5      15.104  10.273  14.728  1.00 59.25           C  
HETATM 3252  C   MSE D   5      15.105  10.260  13.208  1.00 57.81           C  
HETATM 3253  O   MSE D   5      14.628   9.316  12.578  1.00 58.92           O  
HETATM 3254  CB  MSE D   5      15.355   8.861  15.242  1.00 63.25           C  
HETATM 3255  CG  MSE D   5      15.929   8.813  16.641  1.00 69.78           C  
HETATM 3256 SE   MSE D   5      17.806   9.297  16.693  1.00 79.62          SE  
HETATM 3257  CE  MSE D   5      18.588   7.524  16.759  1.00 73.51           C  
ATOM   3258  N   SER D   6      15.643  11.324  12.625  1.00 54.77           N  
ATOM   3259  CA  SER D   6      15.734  11.449  11.179  1.00 51.92           C  
ATOM   3260  C   SER D   6      17.208  11.594  10.840  1.00 49.97           C  
ATOM   3261  O   SER D   6      17.992  12.095  11.650  1.00 49.42           O  
ATOM   3262  CB  SER D   6      14.970  12.680  10.701  1.00 51.90           C  
ATOM   3263  OG  SER D   6      15.497  13.850  11.300  1.00 53.41           O  
ATOM   3264  N   ALA D   7      17.586  11.152   9.648  1.00 46.77           N  
ATOM   3265  CA  ALA D   7      18.973  11.231   9.229  1.00 44.07           C  
ATOM   3266  C   ALA D   7      19.539  12.631   9.460  1.00 42.08           C  
ATOM   3267  O   ALA D   7      20.643  12.779   9.981  1.00 40.83           O  
ATOM   3268  CB  ALA D   7      19.092  10.841   7.762  1.00 43.95           C  
ATOM   3269  N   GLN D   8      18.773  13.654   9.087  1.00 41.38           N  
ATOM   3270  CA  GLN D   8      19.209  15.041   9.236  1.00 41.61           C  
ATOM   3271  C   GLN D   8      19.558  15.415  10.669  1.00 39.98           C  
ATOM   3272  O   GLN D   8      20.612  15.998  10.922  1.00 39.26           O  
ATOM   3273  CB  GLN D   8      18.139  16.006   8.715  1.00 43.98           C  
ATOM   3274  CG  GLN D   8      17.692  15.729   7.293  1.00 48.60           C  
ATOM   3275  CD  GLN D   8      16.464  14.830   7.234  1.00 52.50           C  
ATOM   3276  OE1 GLN D   8      15.335  15.281   7.465  1.00 53.88           O  
ATOM   3277  NE2 GLN D   8      16.680  13.548   6.938  1.00 53.41           N  
ATOM   3278  N   ALA D   9      18.669  15.085  11.601  1.00 39.31           N  
ATOM   3279  CA  ALA D   9      18.890  15.387  13.014  1.00 38.12           C  
ATOM   3280  C   ALA D   9      20.090  14.627  13.566  1.00 37.68           C  
ATOM   3281  O   ALA D   9      20.784  15.108  14.460  1.00 38.91           O  
ATOM   3282  CB  ALA D   9      17.649  15.048  13.818  1.00 36.30           C  
ATOM   3283  N   ILE D  10      20.326  13.432  13.036  1.00 37.39           N  
ATOM   3284  CA  ILE D  10      21.445  12.602  13.467  1.00 37.72           C  
ATOM   3285  C   ILE D  10      22.750  13.245  13.024  1.00 38.56           C  
ATOM   3286  O   ILE D  10      23.690  13.374  13.808  1.00 37.83           O  
ATOM   3287  CB  ILE D  10      21.337  11.193  12.862  1.00 37.36           C  
ATOM   3288  CG1 ILE D  10      20.100  10.493  13.433  1.00 37.61           C  
ATOM   3289  CG2 ILE D  10      22.597  10.400  13.144  1.00 36.09           C  
ATOM   3290  CD1 ILE D  10      19.788   9.161  12.785  1.00 39.54           C  
ATOM   3291  N   ILE D  11      22.789  13.652  11.758  1.00 40.28           N  
ATOM   3292  CA  ILE D  11      23.958  14.301  11.183  1.00 40.54           C  
ATOM   3293  C   ILE D  11      24.241  15.578  11.960  1.00 41.09           C  
ATOM   3294  O   ILE D  11      25.395  15.902  12.271  1.00 41.25           O  
ATOM   3295  CB  ILE D  11      23.709  14.695   9.716  1.00 40.46           C  
ATOM   3296  CG1 ILE D  11      23.511  13.444   8.861  1.00 41.99           C  
ATOM   3297  CG2 ILE D  11      24.862  15.538   9.208  1.00 41.52           C  
ATOM   3298  CD1 ILE D  11      23.243  13.742   7.388  1.00 39.83           C  
ATOM   3299  N   ARG D  12      23.172  16.299  12.268  1.00 40.73           N  
ATOM   3300  CA  ARG D  12      23.294  17.550  12.989  1.00 42.64           C  
ATOM   3301  C   ARG D  12      23.799  17.330  14.405  1.00 41.48           C  
ATOM   3302  O   ARG D  12      24.744  17.985  14.837  1.00 42.56           O  
ATOM   3303  CB  ARG D  12      21.942  18.270  13.023  1.00 47.08           C  
ATOM   3304  CG  ARG D  12      22.050  19.788  12.966  1.00 52.18           C  
ATOM   3305  CD  ARG D  12      22.365  20.297  11.548  1.00 57.76           C  
ATOM   3306  NE  ARG D  12      23.590  19.729  10.976  1.00 61.54           N  
ATOM   3307  CZ  ARG D  12      24.050  20.017   9.759  1.00 62.98           C  
ATOM   3308  NH1 ARG D  12      23.390  20.869   8.985  1.00 64.49           N  
ATOM   3309  NH2 ARG D  12      25.162  19.449   9.308  1.00 62.47           N  
ATOM   3310  N   GLU D  13      23.180  16.392  15.114  1.00 39.20           N  
ATOM   3311  CA  GLU D  13      23.543  16.084  16.498  1.00 37.01           C  
ATOM   3312  C   GLU D  13      24.944  15.506  16.720  1.00 35.14           C  
ATOM   3313  O   GLU D  13      25.564  15.754  17.753  1.00 34.03           O  
ATOM   3314  CB  GLU D  13      22.519  15.112  17.098  1.00 38.00           C  
ATOM   3315  CG  GLU D  13      22.775  14.742  18.562  1.00 38.51           C  
ATOM   3316  CD  GLU D  13      22.530  15.905  19.510  1.00 39.68           C  
ATOM   3317  OE1 GLU D  13      22.780  15.744  20.722  1.00 38.65           O  
ATOM   3318  OE2 GLU D  13      22.083  16.977  19.044  1.00 40.74           O  
ATOM   3319  N   LEU D  14      25.434  14.721  15.767  1.00 33.81           N  
ATOM   3320  CA  LEU D  14      26.742  14.097  15.920  1.00 33.46           C  
ATOM   3321  C   LEU D  14      27.852  14.805  15.167  1.00 33.68           C  
ATOM   3322  O   LEU D  14      28.978  14.323  15.124  1.00 33.68           O  
ATOM   3323  CB  LEU D  14      26.673  12.638  15.473  1.00 32.99           C  
ATOM   3324  CG  LEU D  14      25.628  11.761  16.158  1.00 32.16           C  
ATOM   3325  CD1 LEU D  14      25.612  10.389  15.498  1.00 34.45           C  
ATOM   3326  CD2 LEU D  14      25.945  11.628  17.637  1.00 30.85           C  
ATOM   3327  N   GLY D  15      27.537  15.949  14.574  1.00 34.06           N  
ATOM   3328  CA  GLY D  15      28.548  16.689  13.847  1.00 34.19           C  
ATOM   3329  C   GLY D  15      29.118  15.949  12.651  1.00 34.44           C  
ATOM   3330  O   GLY D  15      30.262  16.182  12.264  1.00 35.75           O  
ATOM   3331  N   LEU D  16      28.324  15.063  12.061  1.00 34.74           N  
ATOM   3332  CA  LEU D  16      28.753  14.289  10.901  1.00 36.00           C  
ATOM   3333  C   LEU D  16      29.011  15.150   9.666  1.00 37.07           C  
ATOM   3334  O   LEU D  16      28.421  16.221   9.508  1.00 38.96           O  
ATOM   3335  CB  LEU D  16      27.695  13.238  10.560  1.00 35.83           C  
ATOM   3336  CG  LEU D  16      27.669  11.910  11.320  1.00 35.72           C  
ATOM   3337  CD1 LEU D  16      28.439  12.002  12.618  1.00 33.82           C  
ATOM   3338  CD2 LEU D  16      26.220  11.524  11.559  1.00 34.91           C  
ATOM   3339  N   GLU D  17      29.894  14.664   8.797  1.00 36.83           N  
ATOM   3340  CA  GLU D  17      30.252  15.343   7.554  1.00 38.67           C  
ATOM   3341  C   GLU D  17      30.255  14.281   6.457  1.00 37.63           C  
ATOM   3342  O   GLU D  17      30.361  13.090   6.743  1.00 38.98           O  
ATOM   3343  CB  GLU D  17      31.649  15.968   7.656  1.00 40.97           C  
ATOM   3344  CG  GLU D  17      31.851  16.897   8.845  1.00 47.67           C  
ATOM   3345  CD  GLU D  17      31.273  18.290   8.630  1.00 51.94           C  
ATOM   3346  OE1 GLU D  17      31.327  19.107   9.582  1.00 54.00           O  
ATOM   3347  OE2 GLU D  17      30.775  18.572   7.514  1.00 52.86           O  
ATOM   3348  N   PRO D  18      30.145  14.695   5.187  1.00 35.97           N  
ATOM   3349  CA  PRO D  18      30.145  13.701   4.108  1.00 35.19           C  
ATOM   3350  C   PRO D  18      31.466  12.946   3.956  1.00 34.75           C  
ATOM   3351  O   PRO D  18      32.548  13.541   3.996  1.00 35.15           O  
ATOM   3352  CB  PRO D  18      29.772  14.528   2.872  1.00 34.33           C  
ATOM   3353  CG  PRO D  18      30.271  15.884   3.199  1.00 32.99           C  
ATOM   3354  CD  PRO D  18      29.942  16.054   4.658  1.00 35.10           C  
ATOM   3355  N   HIS D  19      31.350  11.630   3.785  1.00 33.92           N  
ATOM   3356  CA  HIS D  19      32.493  10.728   3.637  1.00 33.77           C  
ATOM   3357  C   HIS D  19      32.731  10.425   2.163  1.00 32.72           C  
ATOM   3358  O   HIS D  19      31.793  10.331   1.376  1.00 32.64           O  
ATOM   3359  CB  HIS D  19      32.222   9.421   4.410  1.00 35.80           C  
ATOM   3360  CG  HIS D  19      33.417   8.522   4.546  1.00 36.02           C  
ATOM   3361  ND1 HIS D  19      33.960   7.831   3.482  1.00 38.07           N  
ATOM   3362  CD2 HIS D  19      34.163   8.189   5.628  1.00 35.31           C  
ATOM   3363  CE1 HIS D  19      34.986   7.110   3.904  1.00 37.00           C  
ATOM   3364  NE2 HIS D  19      35.130   7.310   5.203  1.00 36.28           N  
ATOM   3365  N   PRO D  20      34.001  10.270   1.772  1.00 32.83           N  
ATOM   3366  CA  PRO D  20      34.395   9.979   0.394  1.00 32.64           C  
ATOM   3367  C   PRO D  20      33.699   8.791  -0.273  1.00 32.87           C  
ATOM   3368  O   PRO D  20      33.406   8.832  -1.466  1.00 32.09           O  
ATOM   3369  CB  PRO D  20      35.899   9.765   0.516  1.00 31.34           C  
ATOM   3370  CG  PRO D  20      36.273  10.736   1.574  1.00 31.96           C  
ATOM   3371  CD  PRO D  20      35.190  10.516   2.610  1.00 33.06           C  
ATOM   3372  N   GLU D  21      33.440   7.733   0.488  1.00 34.09           N  
ATOM   3373  CA  GLU D  21      32.801   6.545  -0.078  1.00 34.39           C  
ATOM   3374  C   GLU D  21      31.297   6.710  -0.161  1.00 33.74           C  
ATOM   3375  O   GLU D  21      30.594   5.846  -0.685  1.00 33.37           O  
ATOM   3376  CB  GLU D  21      33.126   5.317   0.774  1.00 35.77           C  
ATOM   3377  CG  GLU D  21      32.584   5.389   2.192  1.00 38.38           C  
ATOM   3378  CD  GLU D  21      33.115   4.272   3.068  1.00 41.58           C  
ATOM   3379  OE1 GLU D  21      34.347   4.095   3.104  1.00 40.93           O  
ATOM   3380  OE2 GLU D  21      32.311   3.571   3.726  1.00 44.47           O  
ATOM   3381  N   GLY D  22      30.816   7.836   0.354  1.00 32.44           N  
ATOM   3382  CA  GLY D  22      29.392   8.098   0.376  1.00 31.79           C  
ATOM   3383  C   GLY D  22      28.985   8.130   1.840  1.00 32.73           C  
ATOM   3384  O   GLY D  22      29.779   7.762   2.710  1.00 31.58           O  
ATOM   3385  N   GLY D  23      27.762   8.567   2.116  1.00 32.32           N  
ATOM   3386  CA  GLY D  23      27.301   8.636   3.491  1.00 34.38           C  
ATOM   3387  C   GLY D  23      27.998   9.735   4.274  1.00 35.49           C  
ATOM   3388  O   GLY D  23      28.819  10.471   3.721  1.00 36.24           O  
ATOM   3389  N   PHE D  24      27.667   9.859   5.555  1.00 34.78           N  
ATOM   3390  CA  PHE D  24      28.281  10.874   6.405  1.00 35.19           C  
ATOM   3391  C   PHE D  24      29.001  10.191   7.552  1.00 35.68           C  
ATOM   3392  O   PHE D  24      28.652   9.069   7.923  1.00 37.09           O  
ATOM   3393  CB  PHE D  24      27.228  11.820   6.977  1.00 34.86           C  
ATOM   3394  CG  PHE D  24      26.388  12.480   5.940  1.00 35.90           C  
ATOM   3395  CD1 PHE D  24      25.397  11.763   5.271  1.00 36.11           C  
ATOM   3396  CD2 PHE D  24      26.593  13.821   5.615  1.00 35.95           C  
ATOM   3397  CE1 PHE D  24      24.619  12.375   4.292  1.00 36.43           C  
ATOM   3398  CE2 PHE D  24      25.822  14.443   4.637  1.00 34.84           C  
ATOM   3399  CZ  PHE D  24      24.835  13.722   3.975  1.00 35.86           C  
ATOM   3400  N   TYR D  25      29.999  10.863   8.118  1.00 34.50           N  
ATOM   3401  CA  TYR D  25      30.739  10.281   9.223  1.00 33.78           C  
ATOM   3402  C   TYR D  25      31.461  11.306  10.082  1.00 34.53           C  
ATOM   3403  O   TYR D  25      31.489  12.498   9.779  1.00 34.95           O  
ATOM   3404  CB  TYR D  25      31.768   9.286   8.694  1.00 32.24           C  
ATOM   3405  CG  TYR D  25      33.095   9.914   8.342  1.00 32.16           C  
ATOM   3406  CD1 TYR D  25      34.255   9.552   9.020  1.00 31.24           C  
ATOM   3407  CD2 TYR D  25      33.194  10.862   7.322  1.00 34.64           C  
ATOM   3408  CE1 TYR D  25      35.481  10.108   8.693  1.00 33.73           C  
ATOM   3409  CE2 TYR D  25      34.425  11.430   6.981  1.00 34.45           C  
ATOM   3410  CZ  TYR D  25      35.564  11.045   7.669  1.00 33.81           C  
ATOM   3411  OH  TYR D  25      36.788  11.567   7.322  1.00 33.34           O  
ATOM   3412  N   HIS D  26      32.054  10.810  11.161  1.00 34.61           N  
ATOM   3413  CA  HIS D  26      32.820  11.633  12.080  1.00 34.45           C  
ATOM   3414  C   HIS D  26      33.768  10.726  12.834  1.00 35.00           C  
ATOM   3415  O   HIS D  26      33.360   9.692  13.349  1.00 36.71           O  
ATOM   3416  CB  HIS D  26      31.903  12.341  13.079  1.00 32.49           C  
ATOM   3417  CG  HIS D  26      32.642  13.078  14.148  1.00 30.36           C  
ATOM   3418  ND1 HIS D  26      33.471  14.145  13.875  1.00 28.68           N  
ATOM   3419  CD2 HIS D  26      32.697  12.890  15.487  1.00 29.92           C  
ATOM   3420  CE1 HIS D  26      34.004  14.584  15.001  1.00 28.95           C  
ATOM   3421  NE2 HIS D  26      33.551  13.840  15.994  1.00 29.87           N  
ATOM   3422  N   GLN D  27      35.042  11.087  12.882  1.00 35.71           N  
ATOM   3423  CA  GLN D  27      35.982  10.265  13.620  1.00 34.57           C  
ATOM   3424  C   GLN D  27      35.837  10.682  15.068  1.00 33.64           C  
ATOM   3425  O   GLN D  27      35.951  11.865  15.402  1.00 33.71           O  
ATOM   3426  CB  GLN D  27      37.415  10.495  13.162  1.00 35.48           C  
ATOM   3427  CG  GLN D  27      38.377   9.495  13.766  1.00 39.51           C  
ATOM   3428  CD  GLN D  27      39.785   9.619  13.223  1.00 43.13           C  
ATOM   3429  OE1 GLN D  27      40.523  10.538  13.583  1.00 45.56           O  
ATOM   3430  NE2 GLN D  27      40.166   8.696  12.342  1.00 43.72           N  
ATOM   3431  N   THR D  28      35.570   9.710  15.928  1.00 30.32           N  
ATOM   3432  CA  THR D  28      35.399  10.005  17.330  1.00 28.62           C  
ATOM   3433  C   THR D  28      36.644   9.702  18.127  1.00 29.18           C  
ATOM   3434  O   THR D  28      36.841  10.259  19.202  1.00 27.85           O  
ATOM   3435  CB  THR D  28      34.257   9.183  17.926  1.00 27.74           C  
ATOM   3436  OG1 THR D  28      34.486   7.795  17.653  1.00 26.72           O  
ATOM   3437  CG2 THR D  28      32.930   9.613  17.341  1.00 24.32           C  
ATOM   3438  N   PHE D  29      37.504   8.837  17.600  1.00 30.71           N  
ATOM   3439  CA  PHE D  29      38.678   8.464  18.365  1.00 32.69           C  
ATOM   3440  C   PHE D  29      39.881   7.943  17.579  1.00 34.63           C  
ATOM   3441  O   PHE D  29      39.739   7.230  16.584  1.00 34.85           O  
ATOM   3442  CB  PHE D  29      38.231   7.420  19.401  1.00 31.89           C  
ATOM   3443  CG  PHE D  29      39.353   6.725  20.112  1.00 30.15           C  
ATOM   3444  CD1 PHE D  29      40.071   7.368  21.114  1.00 29.92           C  
ATOM   3445  CD2 PHE D  29      39.654   5.394  19.815  1.00 30.00           C  
ATOM   3446  CE1 PHE D  29      41.068   6.698  21.817  1.00 28.88           C  
ATOM   3447  CE2 PHE D  29      40.649   4.711  20.508  1.00 30.66           C  
ATOM   3448  CZ  PHE D  29      41.359   5.362  21.516  1.00 30.54           C  
ATOM   3449  N   ARG D  30      41.068   8.331  18.036  1.00 34.89           N  
ATOM   3450  CA  ARG D  30      42.318   7.861  17.460  1.00 36.41           C  
ATOM   3451  C   ARG D  30      43.261   7.683  18.639  1.00 38.20           C  
ATOM   3452  O   ARG D  30      43.757   8.661  19.215  1.00 37.73           O  
ATOM   3453  CB  ARG D  30      42.935   8.847  16.460  1.00 35.59           C  
ATOM   3454  CG  ARG D  30      44.232   8.279  15.841  1.00 35.50           C  
ATOM   3455  CD  ARG D  30      44.909   9.222  14.845  1.00 36.78           C  
ATOM   3456  NE  ARG D  30      44.120   9.438  13.631  1.00 37.63           N  
ATOM   3457  CZ  ARG D  30      43.991   8.554  12.645  1.00 37.95           C  
ATOM   3458  NH1 ARG D  30      43.248   8.850  11.587  1.00 38.41           N  
ATOM   3459  NH2 ARG D  30      44.611   7.379  12.708  1.00 38.31           N  
ATOM   3460  N   ASP D  31      43.479   6.424  19.005  1.00 38.79           N  
ATOM   3461  CA  ASP D  31      44.351   6.076  20.111  1.00 40.31           C  
ATOM   3462  C   ASP D  31      45.663   6.845  19.992  1.00 41.01           C  
ATOM   3463  O   ASP D  31      46.358   6.726  18.984  1.00 40.79           O  
ATOM   3464  CB  ASP D  31      44.630   4.573  20.080  1.00 41.40           C  
ATOM   3465  CG  ASP D  31      45.064   4.036  21.422  1.00 42.72           C  
ATOM   3466  OD1 ASP D  31      45.779   4.760  22.147  1.00 41.92           O  
ATOM   3467  OD2 ASP D  31      44.695   2.887  21.745  1.00 43.91           O  
ATOM   3468  N   LYS D  32      46.000   7.633  21.009  1.00 41.53           N  
ATOM   3469  CA  LYS D  32      47.239   8.402  20.979  1.00 44.40           C  
ATOM   3470  C   LYS D  32      48.444   7.497  21.212  1.00 45.45           C  
ATOM   3471  O   LYS D  32      49.588   7.938  21.111  1.00 46.71           O  
ATOM   3472  CB  LYS D  32      47.230   9.505  22.045  1.00 46.41           C  
ATOM   3473  CG  LYS D  32      46.123  10.544  21.891  1.00 50.39           C  
ATOM   3474  CD  LYS D  32      46.152  11.281  20.544  1.00 53.13           C  
ATOM   3475  CE  LYS D  32      47.362  12.201  20.390  1.00 54.81           C  
ATOM   3476  NZ  LYS D  32      48.621  11.475  20.052  1.00 55.49           N  
ATOM   3477  N   ALA D  33      48.183   6.231  21.520  1.00 45.47           N  
ATOM   3478  CA  ALA D  33      49.246   5.268  21.768  1.00 45.95           C  
ATOM   3479  C   ALA D  33      49.386   4.275  20.620  1.00 46.94           C  
ATOM   3480  O   ALA D  33      48.410   3.956  19.939  1.00 45.69           O  
ATOM   3481  CB  ALA D  33      48.977   4.522  23.066  1.00 44.20           C  
ATOM   3482  N   GLY D  34      50.610   3.796  20.412  1.00 48.45           N  
ATOM   3483  CA  GLY D  34      50.871   2.824  19.362  1.00 50.08           C  
ATOM   3484  C   GLY D  34      51.030   3.374  17.955  1.00 51.12           C  
ATOM   3485  O   GLY D  34      50.201   3.106  17.087  1.00 52.01           O  
ATOM   3486  N   GLY D  35      52.092   4.137  17.723  1.00 50.91           N  
ATOM   3487  CA  GLY D  35      52.322   4.688  16.399  1.00 51.54           C  
ATOM   3488  C   GLY D  35      51.561   5.970  16.115  1.00 51.40           C  
ATOM   3489  O   GLY D  35      50.654   6.343  16.853  1.00 51.64           O  
ATOM   3490  N   GLU D  36      51.942   6.646  15.037  1.00 51.43           N  
ATOM   3491  CA  GLU D  36      51.296   7.895  14.648  1.00 51.35           C  
ATOM   3492  C   GLU D  36      49.851   7.607  14.241  1.00 49.65           C  
ATOM   3493  O   GLU D  36      48.936   8.387  14.532  1.00 48.29           O  
ATOM   3494  CB  GLU D  36      52.049   8.535  13.474  1.00 53.08           C  
ATOM   3495  CG  GLU D  36      51.728  10.007  13.267  1.00 57.20           C  
ATOM   3496  CD  GLU D  36      52.334  10.892  14.350  1.00 60.78           C  
ATOM   3497  OE1 GLU D  36      51.848  12.031  14.535  1.00 61.94           O  
ATOM   3498  OE2 GLU D  36      53.306  10.449  15.009  1.00 61.27           O  
ATOM   3499  N   ARG D  37      49.656   6.476  13.568  1.00 47.55           N  
ATOM   3500  CA  ARG D  37      48.333   6.074  13.121  1.00 44.97           C  
ATOM   3501  C   ARG D  37      47.483   5.683  14.329  1.00 43.17           C  
ATOM   3502  O   ARG D  37      46.251   5.724  14.278  1.00 42.80           O  
ATOM   3503  CB  ARG D  37      48.426   4.889  12.163  1.00 45.06           C  
ATOM   3504  CG  ARG D  37      47.224   4.794  11.252  1.00 47.83           C  
ATOM   3505  CD  ARG D  37      46.864   3.375  10.862  1.00 46.85           C  
ATOM   3506  NE  ARG D  37      47.866   2.735  10.022  1.00 48.49           N  
ATOM   3507  CZ  ARG D  37      47.602   1.709   9.217  1.00 49.81           C  
ATOM   3508  NH1 ARG D  37      48.565   1.171   8.484  1.00 50.39           N  
ATOM   3509  NH2 ARG D  37      46.368   1.228   9.133  1.00 50.58           N  
ATOM   3510  N   GLY D  38      48.155   5.310  15.416  1.00 40.82           N  
ATOM   3511  CA  GLY D  38      47.461   4.909  16.623  1.00 37.37           C  
ATOM   3512  C   GLY D  38      47.092   3.441  16.607  1.00 36.25           C  
ATOM   3513  O   GLY D  38      46.980   2.836  15.540  1.00 34.08           O  
ATOM   3514  N   HIS D  39      46.915   2.859  17.791  1.00 36.15           N  
ATOM   3515  CA  HIS D  39      46.537   1.456  17.900  1.00 35.16           C  
ATOM   3516  C   HIS D  39      45.233   1.235  17.154  1.00 33.51           C  
ATOM   3517  O   HIS D  39      45.027   0.185  16.560  1.00 33.91           O  
ATOM   3518  CB  HIS D  39      46.349   1.050  19.369  1.00 39.86           C  
ATOM   3519  CG  HIS D  39      47.634   0.816  20.104  1.00 43.28           C  
ATOM   3520  ND1 HIS D  39      47.987   1.522  21.235  1.00 43.48           N  
ATOM   3521  CD2 HIS D  39      48.645  -0.055  19.872  1.00 43.59           C  
ATOM   3522  CE1 HIS D  39      49.160   1.096  21.668  1.00 44.38           C  
ATOM   3523  NE2 HIS D  39      49.580   0.140  20.858  1.00 44.08           N  
ATOM   3524  N   SER D  40      44.344   2.223  17.192  1.00 29.85           N  
ATOM   3525  CA  SER D  40      43.075   2.093  16.492  1.00 28.40           C  
ATOM   3526  C   SER D  40      42.335   3.424  16.383  1.00 27.28           C  
ATOM   3527  O   SER D  40      42.752   4.426  16.955  1.00 26.10           O  
ATOM   3528  CB  SER D  40      42.176   1.113  17.225  1.00 27.01           C  
ATOM   3529  OG  SER D  40      41.537   1.795  18.282  1.00 28.48           O  
ATOM   3530  N   THR D  41      41.222   3.405  15.648  1.00 25.21           N  
ATOM   3531  CA  THR D  41      40.379   4.583  15.456  1.00 24.82           C  
ATOM   3532  C   THR D  41      38.914   4.180  15.596  1.00 24.96           C  
ATOM   3533  O   THR D  41      38.557   3.014  15.430  1.00 24.19           O  
ATOM   3534  CB  THR D  41      40.579   5.224  14.061  1.00 24.09           C  
ATOM   3535  OG1 THR D  41      40.371   4.233  13.044  1.00 24.40           O  
ATOM   3536  CG2 THR D  41      41.983   5.813  13.927  1.00 21.17           C  
ATOM   3537  N   ALA D  42      38.066   5.151  15.896  1.00 25.96           N  
ATOM   3538  CA  ALA D  42      36.644   4.883  16.065  1.00 27.94           C  
ATOM   3539  C   ALA D  42      35.861   5.864  15.224  1.00 28.42           C  
ATOM   3540  O   ALA D  42      36.270   7.023  15.073  1.00 27.45           O  
ATOM   3541  CB  ALA D  42      36.245   5.021  17.546  1.00 28.32           C  
ATOM   3542  N   ILE D  43      34.711   5.424  14.721  1.00 28.20           N  
ATOM   3543  CA  ILE D  43      33.919   6.293  13.871  1.00 28.17           C  
ATOM   3544  C   ILE D  43      32.407   6.071  13.860  1.00 28.07           C  
ATOM   3545  O   ILE D  43      31.944   4.945  13.983  1.00 30.01           O  
ATOM   3546  CB  ILE D  43      34.498   6.187  12.431  1.00 26.68           C  
ATOM   3547  CG1 ILE D  43      35.343   7.421  12.159  1.00 24.83           C  
ATOM   3548  CG2 ILE D  43      33.404   5.945  11.386  1.00 25.90           C  
ATOM   3549  CD1 ILE D  43      36.596   7.115  11.383  1.00 30.34           C  
ATOM   3550  N   TYR D  44      31.649   7.162  13.747  1.00 27.28           N  
ATOM   3551  CA  TYR D  44      30.189   7.101  13.622  1.00 27.64           C  
ATOM   3552  C   TYR D  44      29.980   7.179  12.110  1.00 28.38           C  
ATOM   3553  O   TYR D  44      30.567   8.034  11.446  1.00 28.64           O  
ATOM   3554  CB  TYR D  44      29.502   8.319  14.244  1.00 29.69           C  
ATOM   3555  CG  TYR D  44      29.275   8.278  15.741  1.00 29.93           C  
ATOM   3556  CD1 TYR D  44      29.657   9.358  16.548  1.00 28.36           C  
ATOM   3557  CD2 TYR D  44      28.672   7.180  16.351  1.00 28.95           C  
ATOM   3558  CE1 TYR D  44      29.456   9.343  17.922  1.00 28.40           C  
ATOM   3559  CE2 TYR D  44      28.461   7.155  17.735  1.00 29.06           C  
ATOM   3560  CZ  TYR D  44      28.864   8.241  18.511  1.00 29.30           C  
ATOM   3561  OH  TYR D  44      28.741   8.207  19.880  1.00 32.00           O  
ATOM   3562  N   TYR D  45      29.156   6.300  11.560  1.00 28.78           N  
ATOM   3563  CA  TYR D  45      28.914   6.307  10.123  1.00 28.29           C  
ATOM   3564  C   TYR D  45      27.418   6.259   9.854  1.00 29.37           C  
ATOM   3565  O   TYR D  45      26.690   5.490  10.479  1.00 29.27           O  
ATOM   3566  CB  TYR D  45      29.607   5.112   9.480  1.00 28.87           C  
ATOM   3567  CG  TYR D  45      29.574   5.094   7.962  1.00 30.97           C  
ATOM   3568  CD1 TYR D  45      30.007   6.193   7.222  1.00 30.40           C  
ATOM   3569  CD2 TYR D  45      29.162   3.956   7.270  1.00 28.68           C  
ATOM   3570  CE1 TYR D  45      30.035   6.157   5.835  1.00 31.23           C  
ATOM   3571  CE2 TYR D  45      29.186   3.912   5.884  1.00 31.08           C  
ATOM   3572  CZ  TYR D  45      29.625   5.015   5.171  1.00 30.44           C  
ATOM   3573  OH  TYR D  45      29.652   4.979   3.793  1.00 30.47           O  
ATOM   3574  N   LEU D  46      26.960   7.087   8.923  1.00 31.46           N  
ATOM   3575  CA  LEU D  46      25.544   7.141   8.598  1.00 32.50           C  
ATOM   3576  C   LEU D  46      25.233   7.012   7.109  1.00 33.44           C  
ATOM   3577  O   LEU D  46      25.818   7.695   6.271  1.00 33.30           O  
ATOM   3578  CB  LEU D  46      24.943   8.440   9.133  1.00 31.42           C  
ATOM   3579  CG  LEU D  46      23.442   8.594   8.892  1.00 30.62           C  
ATOM   3580  CD1 LEU D  46      22.814   9.323  10.053  1.00 31.19           C  
ATOM   3581  CD2 LEU D  46      23.208   9.322   7.591  1.00 27.94           C  
ATOM   3582  N   LEU D  47      24.298   6.125   6.793  1.00 35.29           N  
ATOM   3583  CA  LEU D  47      23.890   5.912   5.414  1.00 37.10           C  
ATOM   3584  C   LEU D  47      22.417   6.244   5.266  1.00 39.34           C  
ATOM   3585  O   LEU D  47      21.571   5.678   5.961  1.00 39.05           O  
ATOM   3586  CB  LEU D  47      24.149   4.464   4.992  1.00 35.34           C  
ATOM   3587  CG  LEU D  47      25.590   4.180   4.562  1.00 36.01           C  
ATOM   3588  CD1 LEU D  47      25.777   2.698   4.256  1.00 35.67           C  
ATOM   3589  CD2 LEU D  47      25.911   5.027   3.333  1.00 36.97           C  
ATOM   3590  N   GLU D  48      22.117   7.178   4.367  1.00 41.77           N  
ATOM   3591  CA  GLU D  48      20.744   7.583   4.123  1.00 44.61           C  
ATOM   3592  C   GLU D  48      20.104   6.670   3.090  1.00 44.80           C  
ATOM   3593  O   GLU D  48      20.780   5.885   2.421  1.00 43.04           O  
ATOM   3594  CB  GLU D  48      20.677   9.017   3.606  1.00 48.07           C  
ATOM   3595  CG  GLU D  48      21.263  10.079   4.518  1.00 54.60           C  
ATOM   3596  CD  GLU D  48      20.828  11.490   4.111  1.00 59.26           C  
ATOM   3597  OE1 GLU D  48      19.654  11.851   4.370  1.00 59.52           O  
ATOM   3598  OE2 GLU D  48      21.652  12.230   3.522  1.00 62.17           O  
ATOM   3599  N   LYS D  49      18.787   6.789   2.967  1.00 45.78           N  
ATOM   3600  CA  LYS D  49      18.021   6.000   2.020  1.00 46.86           C  
ATOM   3601  C   LYS D  49      18.609   6.153   0.621  1.00 47.60           C  
ATOM   3602  O   LYS D  49      18.873   7.263   0.158  1.00 47.67           O  
ATOM   3603  CB  LYS D  49      16.556   6.456   2.033  1.00 46.32           C  
ATOM   3604  CG  LYS D  49      15.712   5.875   0.916  1.00 47.04           C  
ATOM   3605  CD  LYS D  49      14.319   6.492   0.874  1.00 49.54           C  
ATOM   3606  CE  LYS D  49      13.342   5.794   1.819  1.00 50.95           C  
ATOM   3607  NZ  LYS D  49      13.740   5.834   3.257  1.00 51.52           N  
ATOM   3608  N   GLY D  50      18.829   5.028  -0.040  1.00 48.48           N  
ATOM   3609  CA  GLY D  50      19.365   5.066  -1.382  1.00 50.79           C  
ATOM   3610  C   GLY D  50      20.870   4.958  -1.480  1.00 52.25           C  
ATOM   3611  O   GLY D  50      21.399   3.932  -1.910  1.00 52.89           O  
ATOM   3612  N   VAL D  51      21.572   6.008  -1.078  1.00 52.53           N  
ATOM   3613  CA  VAL D  51      23.018   6.003  -1.177  1.00 53.01           C  
ATOM   3614  C   VAL D  51      23.702   4.759  -0.615  1.00 53.30           C  
ATOM   3615  O   VAL D  51      23.459   4.348   0.521  1.00 54.75           O  
ATOM   3616  CB  VAL D  51      23.623   7.262  -0.528  1.00 52.98           C  
ATOM   3617  CG1 VAL D  51      23.109   7.429   0.892  1.00 54.31           C  
ATOM   3618  CG2 VAL D  51      25.135   7.161  -0.546  1.00 53.53           C  
ATOM   3619  N   ARG D  52      24.550   4.157  -1.441  1.00 53.19           N  
ATOM   3620  CA  ARG D  52      25.315   2.976  -1.064  1.00 52.79           C  
ATOM   3621  C   ARG D  52      26.792   3.326  -1.189  1.00 51.87           C  
ATOM   3622  O   ARG D  52      27.211   3.926  -2.179  1.00 52.08           O  
ATOM   3623  CB  ARG D  52      24.969   1.797  -1.980  1.00 55.04           C  
ATOM   3624  CG  ARG D  52      24.847   2.145  -3.461  1.00 58.14           C  
ATOM   3625  CD  ARG D  52      26.192   2.361  -4.149  1.00 60.16           C  
ATOM   3626  NE  ARG D  52      26.032   3.086  -5.411  1.00 62.66           N  
ATOM   3627  CZ  ARG D  52      27.037   3.536  -6.161  1.00 62.58           C  
ATOM   3628  NH1 ARG D  52      26.779   4.187  -7.291  1.00 62.29           N  
ATOM   3629  NH2 ARG D  52      28.295   3.339  -5.785  1.00 62.49           N  
ATOM   3630  N   SER D  53      27.582   2.973  -0.182  1.00 49.15           N  
ATOM   3631  CA  SER D  53      29.002   3.268  -0.215  1.00 46.77           C  
ATOM   3632  C   SER D  53      29.637   2.632  -1.446  1.00 45.80           C  
ATOM   3633  O   SER D  53      29.272   1.530  -1.841  1.00 45.29           O  
ATOM   3634  CB  SER D  53      29.668   2.746   1.050  1.00 46.15           C  
ATOM   3635  OG  SER D  53      29.470   1.355   1.174  1.00 46.63           O  
ATOM   3636  N   HIS D  54      30.580   3.340  -2.057  1.00 46.06           N  
ATOM   3637  CA  HIS D  54      31.267   2.846  -3.244  1.00 46.36           C  
ATOM   3638  C   HIS D  54      32.208   1.751  -2.789  1.00 44.79           C  
ATOM   3639  O   HIS D  54      32.765   1.831  -1.699  1.00 44.47           O  
ATOM   3640  CB  HIS D  54      32.114   3.949  -3.891  1.00 49.45           C  
ATOM   3641  CG  HIS D  54      31.403   5.254  -4.065  1.00 52.80           C  
ATOM   3642  ND1 HIS D  54      32.076   6.439  -4.281  1.00 53.07           N  
ATOM   3643  CD2 HIS D  54      30.085   5.565  -4.054  1.00 54.41           C  
ATOM   3644  CE1 HIS D  54      31.204   7.425  -4.390  1.00 54.64           C  
ATOM   3645  NE2 HIS D  54      29.988   6.922  -4.257  1.00 56.54           N  
ATOM   3646  N   TRP D  55      32.407   0.737  -3.620  1.00 43.41           N  
ATOM   3647  CA  TRP D  55      33.317  -0.326  -3.237  1.00 42.12           C  
ATOM   3648  C   TRP D  55      34.668   0.255  -2.835  1.00 42.15           C  
ATOM   3649  O   TRP D  55      35.164   1.190  -3.463  1.00 40.48           O  
ATOM   3650  CB  TRP D  55      33.519  -1.307  -4.382  1.00 40.43           C  
ATOM   3651  CG  TRP D  55      32.353  -2.179  -4.615  1.00 39.56           C  
ATOM   3652  CD1 TRP D  55      31.359  -1.990  -5.525  1.00 37.17           C  
ATOM   3653  CD2 TRP D  55      32.043  -3.390  -3.920  1.00 39.72           C  
ATOM   3654  NE1 TRP D  55      30.447  -3.009  -5.443  1.00 37.75           N  
ATOM   3655  CE2 TRP D  55      30.841  -3.885  -4.464  1.00 38.96           C  
ATOM   3656  CE3 TRP D  55      32.665  -4.104  -2.887  1.00 39.67           C  
ATOM   3657  CZ2 TRP D  55      30.243  -5.067  -4.013  1.00 39.01           C  
ATOM   3658  CZ3 TRP D  55      32.070  -5.280  -2.435  1.00 39.80           C  
ATOM   3659  CH2 TRP D  55      30.870  -5.748  -3.001  1.00 38.97           C  
ATOM   3660  N   HIS D  56      35.257  -0.310  -1.788  1.00 41.53           N  
ATOM   3661  CA  HIS D  56      36.549   0.156  -1.309  1.00 41.06           C  
ATOM   3662  C   HIS D  56      37.167  -0.849  -0.347  1.00 41.00           C  
ATOM   3663  O   HIS D  56      36.589  -1.898  -0.050  1.00 41.03           O  
ATOM   3664  CB  HIS D  56      36.390   1.493  -0.588  1.00 41.12           C  
ATOM   3665  CG  HIS D  56      35.570   1.406   0.659  1.00 41.38           C  
ATOM   3666  ND1 HIS D  56      34.203   1.238   0.639  1.00 41.39           N  
ATOM   3667  CD2 HIS D  56      35.928   1.435   1.965  1.00 40.41           C  
ATOM   3668  CE1 HIS D  56      33.753   1.166   1.879  1.00 41.16           C  
ATOM   3669  NE2 HIS D  56      34.780   1.284   2.703  1.00 39.80           N  
ATOM   3670  N   ARG D  57      38.346  -0.517   0.150  1.00 39.96           N  
ATOM   3671  CA  ARG D  57      39.013  -1.395   1.079  1.00 40.91           C  
ATOM   3672  C   ARG D  57      40.070  -0.676   1.886  1.00 40.01           C  
ATOM   3673  O   ARG D  57      40.559   0.382   1.495  1.00 39.01           O  
ATOM   3674  CB  ARG D  57      39.641  -2.578   0.334  1.00 41.64           C  
ATOM   3675  CG  ARG D  57      40.636  -2.197  -0.747  1.00 44.52           C  
ATOM   3676  CD  ARG D  57      41.046  -3.421  -1.563  1.00 45.02           C  
ATOM   3677  NE  ARG D  57      41.748  -3.048  -2.790  1.00 46.60           N  
ATOM   3678  CZ  ARG D  57      43.000  -2.601  -2.841  1.00 46.12           C  
ATOM   3679  NH1 ARG D  57      43.709  -2.467  -1.730  1.00 46.04           N  
ATOM   3680  NH2 ARG D  57      43.536  -2.278  -4.010  1.00 43.26           N  
ATOM   3681  N   VAL D  58      40.382  -1.253   3.039  1.00 40.32           N  
ATOM   3682  CA  VAL D  58      41.413  -0.731   3.915  1.00 40.90           C  
ATOM   3683  C   VAL D  58      42.546  -1.720   3.672  1.00 41.67           C  
ATOM   3684  O   VAL D  58      42.529  -2.844   4.174  1.00 42.24           O  
ATOM   3685  CB  VAL D  58      40.966  -0.760   5.381  1.00 40.15           C  
ATOM   3686  CG1 VAL D  58      42.001  -0.064   6.255  1.00 39.09           C  
ATOM   3687  CG2 VAL D  58      39.603  -0.088   5.514  1.00 38.97           C  
ATOM   3688  N   THR D  59      43.507  -1.298   2.860  1.00 42.20           N  
ATOM   3689  CA  THR D  59      44.635  -2.138   2.479  1.00 42.55           C  
ATOM   3690  C   THR D  59      45.351  -2.880   3.607  1.00 42.35           C  
ATOM   3691  O   THR D  59      45.695  -4.051   3.454  1.00 43.65           O  
ATOM   3692  CB  THR D  59      45.693  -1.318   1.701  1.00 42.79           C  
ATOM   3693  OG1 THR D  59      46.335  -0.398   2.591  1.00 44.23           O  
ATOM   3694  CG2 THR D  59      45.038  -0.531   0.574  1.00 43.09           C  
ATOM   3695  N   ASP D  60      45.565  -2.225   4.742  1.00 40.95           N  
ATOM   3696  CA  ASP D  60      46.301  -2.873   5.823  1.00 40.29           C  
ATOM   3697  C   ASP D  60      45.646  -2.976   7.197  1.00 40.08           C  
ATOM   3698  O   ASP D  60      46.353  -3.051   8.202  1.00 40.08           O  
ATOM   3699  CB  ASP D  60      47.640  -2.166   5.973  1.00 40.28           C  
ATOM   3700  CG  ASP D  60      47.479  -0.674   6.207  1.00 41.59           C  
ATOM   3701  OD1 ASP D  60      48.488   0.059   6.120  1.00 43.33           O  
ATOM   3702  OD2 ASP D  60      46.342  -0.235   6.483  1.00 38.39           O  
ATOM   3703  N   ALA D  61      44.319  -3.000   7.262  1.00 39.19           N  
ATOM   3704  CA  ALA D  61      43.658  -3.078   8.557  1.00 37.78           C  
ATOM   3705  C   ALA D  61      42.287  -3.725   8.527  1.00 38.03           C  
ATOM   3706  O   ALA D  61      41.571  -3.650   7.526  1.00 40.25           O  
ATOM   3707  CB  ALA D  61      43.550  -1.690   9.161  1.00 39.11           C  
ATOM   3708  N   VAL D  62      41.934  -4.351   9.645  1.00 36.52           N  
ATOM   3709  CA  VAL D  62      40.648  -5.018   9.817  1.00 34.69           C  
ATOM   3710  C   VAL D  62      39.627  -3.983  10.252  1.00 33.60           C  
ATOM   3711  O   VAL D  62      39.885  -3.199  11.157  1.00 33.51           O  
ATOM   3712  CB  VAL D  62      40.733  -6.101  10.918  1.00 35.14           C  
ATOM   3713  CG1 VAL D  62      39.348  -6.615  11.261  1.00 32.28           C  
ATOM   3714  CG2 VAL D  62      41.631  -7.240  10.456  1.00 34.88           C  
ATOM   3715  N   GLU D  63      38.464  -3.973   9.612  1.00 33.62           N  
ATOM   3716  CA  GLU D  63      37.444  -3.011   9.991  1.00 34.49           C  
ATOM   3717  C   GLU D  63      36.225  -3.710  10.558  1.00 33.73           C  
ATOM   3718  O   GLU D  63      35.653  -4.594   9.924  1.00 34.11           O  
ATOM   3719  CB  GLU D  63      37.031  -2.135   8.801  1.00 37.35           C  
ATOM   3720  CG  GLU D  63      35.904  -1.148   9.141  1.00 38.85           C  
ATOM   3721  CD  GLU D  63      35.664  -0.118   8.054  1.00 40.29           C  
ATOM   3722  OE1 GLU D  63      35.593  -0.508   6.868  1.00 40.19           O  
ATOM   3723  OE2 GLU D  63      35.538   1.080   8.392  1.00 40.94           O  
ATOM   3724  N   VAL D  64      35.834  -3.304  11.764  1.00 32.03           N  
ATOM   3725  CA  VAL D  64      34.685  -3.891  12.423  1.00 30.34           C  
ATOM   3726  C   VAL D  64      33.500  -2.935  12.367  1.00 32.24           C  
ATOM   3727  O   VAL D  64      33.609  -1.770  12.736  1.00 32.67           O  
ATOM   3728  CB  VAL D  64      35.015  -4.232  13.887  1.00 28.73           C  
ATOM   3729  CG1 VAL D  64      33.853  -4.982  14.521  1.00 25.82           C  
ATOM   3730  CG2 VAL D  64      36.284  -5.067  13.945  1.00 23.54           C  
ATOM   3731  N   TRP D  65      32.371  -3.443  11.881  1.00 33.80           N  
ATOM   3732  CA  TRP D  65      31.146  -2.668  11.771  1.00 34.36           C  
ATOM   3733  C   TRP D  65      30.206  -2.960  12.934  1.00 33.33           C  
ATOM   3734  O   TRP D  65      29.977  -4.122  13.280  1.00 33.57           O  
ATOM   3735  CB  TRP D  65      30.422  -3.004  10.473  1.00 36.85           C  
ATOM   3736  CG  TRP D  65      31.040  -2.426   9.239  1.00 39.10           C  
ATOM   3737  CD1 TRP D  65      32.234  -2.766   8.674  1.00 39.42           C  
ATOM   3738  CD2 TRP D  65      30.458  -1.439   8.385  1.00 39.64           C  
ATOM   3739  NE1 TRP D  65      32.429  -2.055   7.515  1.00 38.76           N  
ATOM   3740  CE2 TRP D  65      31.353  -1.233   7.315  1.00 40.29           C  
ATOM   3741  CE3 TRP D  65      29.262  -0.710   8.420  1.00 39.79           C  
ATOM   3742  CZ2 TRP D  65      31.089  -0.327   6.285  1.00 40.58           C  
ATOM   3743  CZ3 TRP D  65      29.001   0.188   7.400  1.00 40.00           C  
ATOM   3744  CH2 TRP D  65      29.912   0.373   6.345  1.00 40.04           C  
ATOM   3745  N   HIS D  66      29.639  -1.909  13.517  1.00 31.53           N  
ATOM   3746  CA  HIS D  66      28.729  -2.077  14.644  1.00 30.30           C  
ATOM   3747  C   HIS D  66      27.404  -1.342  14.422  1.00 30.14           C  
ATOM   3748  O   HIS D  66      27.378  -0.120  14.300  1.00 31.97           O  
ATOM   3749  CB  HIS D  66      29.374  -1.567  15.945  1.00 29.63           C  
ATOM   3750  CG  HIS D  66      30.773  -2.063  16.184  1.00 29.22           C  
ATOM   3751  ND1 HIS D  66      31.877  -1.494  15.586  1.00 29.75           N  
ATOM   3752  CD2 HIS D  66      31.250  -3.034  16.999  1.00 28.85           C  
ATOM   3753  CE1 HIS D  66      32.974  -2.086  16.027  1.00 27.94           C  
ATOM   3754  NE2 HIS D  66      32.619  -3.025  16.887  1.00 29.04           N  
ATOM   3755  N   TYR D  67      26.305  -2.085  14.368  1.00 28.78           N  
ATOM   3756  CA  TYR D  67      24.999  -1.473  14.189  1.00 28.23           C  
ATOM   3757  C   TYR D  67      24.602  -0.721  15.462  1.00 29.10           C  
ATOM   3758  O   TYR D  67      24.807  -1.217  16.568  1.00 31.86           O  
ATOM   3759  CB  TYR D  67      23.940  -2.540  13.880  1.00 28.26           C  
ATOM   3760  CG  TYR D  67      22.522  -2.039  14.080  1.00 28.23           C  
ATOM   3761  CD1 TYR D  67      21.889  -2.151  15.310  1.00 25.67           C  
ATOM   3762  CD2 TYR D  67      21.842  -1.386  13.051  1.00 28.72           C  
ATOM   3763  CE1 TYR D  67      20.623  -1.627  15.513  1.00 27.36           C  
ATOM   3764  CE2 TYR D  67      20.575  -0.854  13.245  1.00 27.31           C  
ATOM   3765  CZ  TYR D  67      19.972  -0.977  14.477  1.00 28.28           C  
ATOM   3766  OH  TYR D  67      18.721  -0.435  14.671  1.00 28.64           O  
ATOM   3767  N   TYR D  68      24.031   0.470  15.310  1.00 29.05           N  
ATOM   3768  CA  TYR D  68      23.601   1.247  16.457  1.00 29.41           C  
ATOM   3769  C   TYR D  68      22.118   1.572  16.378  1.00 30.97           C  
ATOM   3770  O   TYR D  68      21.374   1.342  17.333  1.00 32.97           O  
ATOM   3771  CB  TYR D  68      24.370   2.564  16.571  1.00 29.13           C  
ATOM   3772  CG  TYR D  68      25.851   2.449  16.832  1.00 29.69           C  
ATOM   3773  CD1 TYR D  68      26.368   1.502  17.725  1.00 31.66           C  
ATOM   3774  CD2 TYR D  68      26.741   3.322  16.220  1.00 29.92           C  
ATOM   3775  CE1 TYR D  68      27.739   1.436  17.990  1.00 30.95           C  
ATOM   3776  CE2 TYR D  68      28.096   3.270  16.476  1.00 29.85           C  
ATOM   3777  CZ  TYR D  68      28.594   2.329  17.356  1.00 32.18           C  
ATOM   3778  OH  TYR D  68      29.949   2.287  17.581  1.00 33.69           O  
ATOM   3779  N   ALA D  69      21.680   2.116  15.249  1.00 30.88           N  
ATOM   3780  CA  ALA D  69      20.271   2.475  15.109  1.00 32.62           C  
ATOM   3781  C   ALA D  69      19.788   2.525  13.666  1.00 32.71           C  
ATOM   3782  O   ALA D  69      20.576   2.391  12.723  1.00 33.47           O  
ATOM   3783  CB  ALA D  69      20.010   3.825  15.789  1.00 32.29           C  
ATOM   3784  N   GLY D  70      18.486   2.728  13.506  1.00 33.12           N  
ATOM   3785  CA  GLY D  70      17.895   2.793  12.181  1.00 33.25           C  
ATOM   3786  C   GLY D  70      17.617   1.414  11.617  1.00 34.36           C  
ATOM   3787  O   GLY D  70      17.691   0.408  12.325  1.00 32.82           O  
ATOM   3788  N   ALA D  71      17.289   1.365  10.335  1.00 35.64           N  
ATOM   3789  CA  ALA D  71      17.008   0.100   9.673  1.00 36.62           C  
ATOM   3790  C   ALA D  71      18.298  -0.725   9.543  1.00 36.56           C  
ATOM   3791  O   ALA D  71      19.401  -0.206   9.715  1.00 35.26           O  
ATOM   3792  CB  ALA D  71      16.397   0.365   8.290  1.00 37.10           C  
ATOM   3793  N   PRO D  72      18.168  -2.028   9.251  1.00 36.81           N  
ATOM   3794  CA  PRO D  72      19.342  -2.895   9.107  1.00 36.34           C  
ATOM   3795  C   PRO D  72      20.165  -2.488   7.881  1.00 36.95           C  
ATOM   3796  O   PRO D  72      19.699  -1.710   7.045  1.00 37.46           O  
ATOM   3797  CB  PRO D  72      18.731  -4.284   8.943  1.00 35.80           C  
ATOM   3798  CG  PRO D  72      17.381  -4.153   9.610  1.00 37.60           C  
ATOM   3799  CD  PRO D  72      16.922  -2.811   9.164  1.00 35.41           C  
ATOM   3800  N   ILE D  73      21.373  -3.032   7.763  1.00 35.46           N  
ATOM   3801  CA  ILE D  73      22.245  -2.705   6.644  1.00 34.54           C  
ATOM   3802  C   ILE D  73      22.677  -3.924   5.838  1.00 35.16           C  
ATOM   3803  O   ILE D  73      22.861  -5.013   6.386  1.00 36.08           O  
ATOM   3804  CB  ILE D  73      23.518  -1.959   7.150  1.00 34.25           C  
ATOM   3805  CG1 ILE D  73      23.388  -0.464   6.859  1.00 33.18           C  
ATOM   3806  CG2 ILE D  73      24.788  -2.532   6.508  1.00 30.90           C  
ATOM   3807  CD1 ILE D  73      24.544   0.342   7.384  1.00 33.55           C  
ATOM   3808  N   ALA D  74      22.836  -3.735   4.531  1.00 34.17           N  
ATOM   3809  CA  ALA D  74      23.300  -4.809   3.668  1.00 34.97           C  
ATOM   3810  C   ALA D  74      24.770  -4.506   3.413  1.00 35.28           C  
ATOM   3811  O   ALA D  74      25.099  -3.583   2.674  1.00 35.58           O  
ATOM   3812  CB  ALA D  74      22.527  -4.822   2.356  1.00 33.57           C  
ATOM   3813  N   LEU D  75      25.643  -5.277   4.055  1.00 35.88           N  
ATOM   3814  CA  LEU D  75      27.090  -5.106   3.932  1.00 35.36           C  
ATOM   3815  C   LEU D  75      27.640  -6.153   2.980  1.00 34.68           C  
ATOM   3816  O   LEU D  75      27.620  -7.341   3.278  1.00 34.96           O  
ATOM   3817  CB  LEU D  75      27.734  -5.250   5.310  1.00 33.30           C  
ATOM   3818  CG  LEU D  75      29.242  -5.075   5.458  1.00 33.21           C  
ATOM   3819  CD1 LEU D  75      29.677  -3.695   4.995  1.00 31.99           C  
ATOM   3820  CD2 LEU D  75      29.597  -5.275   6.919  1.00 32.71           C  
ATOM   3821  N   HIS D  76      28.129  -5.699   1.832  1.00 35.51           N  
ATOM   3822  CA  HIS D  76      28.661  -6.585   0.800  1.00 35.67           C  
ATOM   3823  C   HIS D  76      30.175  -6.699   0.900  1.00 35.89           C  
ATOM   3824  O   HIS D  76      30.876  -5.693   0.926  1.00 35.61           O  
ATOM   3825  CB  HIS D  76      28.274  -6.041  -0.581  1.00 37.08           C  
ATOM   3826  CG  HIS D  76      26.826  -5.669  -0.699  1.00 37.43           C  
ATOM   3827  ND1 HIS D  76      25.816  -6.606  -0.753  1.00 36.67           N  
ATOM   3828  CD2 HIS D  76      26.217  -4.459  -0.717  1.00 37.98           C  
ATOM   3829  CE1 HIS D  76      24.647  -5.991  -0.795  1.00 37.90           C  
ATOM   3830  NE2 HIS D  76      24.863  -4.687  -0.773  1.00 38.97           N  
ATOM   3831  N   LEU D  77      30.678  -7.927   0.950  1.00 37.24           N  
ATOM   3832  CA  LEU D  77      32.116  -8.156   1.042  1.00 40.29           C  
ATOM   3833  C   LEU D  77      32.640  -8.978  -0.127  1.00 41.80           C  
ATOM   3834  O   LEU D  77      31.891  -9.673  -0.812  1.00 41.16           O  
ATOM   3835  CB  LEU D  77      32.458  -8.878   2.347  1.00 40.03           C  
ATOM   3836  CG  LEU D  77      32.013  -8.180   3.632  1.00 41.21           C  
ATOM   3837  CD1 LEU D  77      32.201  -9.117   4.804  1.00 41.90           C  
ATOM   3838  CD2 LEU D  77      32.806  -6.903   3.830  1.00 40.75           C  
ATOM   3839  N   SER D  78      33.946  -8.898  -0.340  1.00 44.96           N  
ATOM   3840  CA  SER D  78      34.602  -9.632  -1.411  1.00 47.98           C  
ATOM   3841  C   SER D  78      36.100  -9.571  -1.145  1.00 49.77           C  
ATOM   3842  O   SER D  78      36.754  -8.557  -1.389  1.00 50.21           O  
ATOM   3843  CB  SER D  78      34.271  -9.004  -2.770  1.00 48.27           C  
ATOM   3844  OG  SER D  78      34.761  -9.802  -3.832  1.00 47.97           O  
ATOM   3845  N   GLN D  79      36.634 -10.666  -0.621  1.00 52.51           N  
ATOM   3846  CA  GLN D  79      38.046 -10.738  -0.298  1.00 54.84           C  
ATOM   3847  C   GLN D  79      38.916 -10.723  -1.545  1.00 56.32           C  
ATOM   3848  O   GLN D  79      39.876  -9.966  -1.623  1.00 56.56           O  
ATOM   3849  CB  GLN D  79      38.321 -11.999   0.524  1.00 54.82           C  
ATOM   3850  CG  GLN D  79      39.790 -12.251   0.835  1.00 54.91           C  
ATOM   3851  CD  GLN D  79      40.442 -11.095   1.561  1.00 55.04           C  
ATOM   3852  OE1 GLN D  79      39.933 -10.614   2.575  1.00 54.94           O  
ATOM   3853  NE2 GLN D  79      41.583 -10.646   1.047  1.00 54.82           N  
ATOM   3854  N   ASP D  80      38.572 -11.555  -2.521  1.00 59.45           N  
ATOM   3855  CA  ASP D  80      39.348 -11.644  -3.756  1.00 62.56           C  
ATOM   3856  C   ASP D  80      38.793 -10.778  -4.883  1.00 62.93           C  
ATOM   3857  O   ASP D  80      39.340 -10.759  -5.987  1.00 63.46           O  
ATOM   3858  CB  ASP D  80      39.416 -13.102  -4.218  1.00 64.29           C  
ATOM   3859  CG  ASP D  80      38.042 -13.707  -4.445  1.00 66.48           C  
ATOM   3860  OD1 ASP D  80      37.968 -14.921  -4.725  1.00 67.59           O  
ATOM   3861  OD2 ASP D  80      37.035 -12.972  -4.346  1.00 68.22           O  
ATOM   3862  N   GLY D  81      37.713 -10.058  -4.600  1.00 62.98           N  
ATOM   3863  CA  GLY D  81      37.116  -9.215  -5.617  1.00 62.98           C  
ATOM   3864  C   GLY D  81      36.507 -10.055  -6.721  1.00 63.44           C  
ATOM   3865  O   GLY D  81      36.167  -9.544  -7.789  1.00 63.57           O  
ATOM   3866  N   ARG D  82      36.372 -11.352  -6.462  1.00 63.68           N  
ATOM   3867  CA  ARG D  82      35.796 -12.266  -7.435  1.00 64.03           C  
ATOM   3868  C   ARG D  82      34.401 -12.712  -7.018  1.00 63.86           C  
ATOM   3869  O   ARG D  82      33.464 -12.656  -7.815  1.00 63.90           O  
ATOM   3870  CB  ARG D  82      36.700 -13.487  -7.622  1.00 66.00           C  
ATOM   3871  CG  ARG D  82      36.133 -14.503  -8.602  1.00 69.08           C  
ATOM   3872  CD  ARG D  82      37.192 -15.459  -9.137  1.00 71.15           C  
ATOM   3873  NE  ARG D  82      36.649 -16.307 -10.197  1.00 73.08           N  
ATOM   3874  CZ  ARG D  82      37.384 -16.975 -11.081  1.00 73.17           C  
ATOM   3875  NH1 ARG D  82      38.709 -16.898 -11.042  1.00 73.04           N  
ATOM   3876  NH2 ARG D  82      36.791 -17.716 -12.012  1.00 72.13           N  
ATOM   3877  N   GLU D  83      34.268 -13.153  -5.770  1.00 63.03           N  
ATOM   3878  CA  GLU D  83      32.974 -13.599  -5.250  1.00 63.03           C  
ATOM   3879  C   GLU D  83      32.515 -12.594  -4.192  1.00 61.59           C  
ATOM   3880  O   GLU D  83      33.333 -11.860  -3.640  1.00 62.49           O  
ATOM   3881  CB  GLU D  83      33.110 -14.995  -4.632  1.00 65.30           C  
ATOM   3882  CG  GLU D  83      31.792 -15.679  -4.282  1.00 68.80           C  
ATOM   3883  CD  GLU D  83      31.001 -16.117  -5.509  1.00 71.95           C  
ATOM   3884  OE1 GLU D  83      29.944 -16.767  -5.331  1.00 71.96           O  
ATOM   3885  OE2 GLU D  83      31.435 -15.814  -6.645  1.00 72.81           O  
ATOM   3886  N   VAL D  84      31.217 -12.559  -3.902  1.00 58.27           N  
ATOM   3887  CA  VAL D  84      30.698 -11.615  -2.918  1.00 55.29           C  
ATOM   3888  C   VAL D  84      29.690 -12.217  -1.951  1.00 53.82           C  
ATOM   3889  O   VAL D  84      28.773 -12.927  -2.358  1.00 52.15           O  
ATOM   3890  CB  VAL D  84      30.021 -10.411  -3.607  1.00 55.18           C  
ATOM   3891  CG1 VAL D  84      28.982 -10.901  -4.603  1.00 54.71           C  
ATOM   3892  CG2 VAL D  84      29.359  -9.515  -2.563  1.00 54.43           C  
ATOM   3893  N   GLN D  85      29.860 -11.919  -0.665  1.00 52.67           N  
ATOM   3894  CA  GLN D  85      28.948 -12.418   0.360  1.00 52.70           C  
ATOM   3895  C   GLN D  85      28.265 -11.235   1.022  1.00 51.14           C  
ATOM   3896  O   GLN D  85      28.894 -10.214   1.279  1.00 51.00           O  
ATOM   3897  CB  GLN D  85      29.702 -13.217   1.430  1.00 54.35           C  
ATOM   3898  CG  GLN D  85      30.798 -14.122   0.898  1.00 58.17           C  
ATOM   3899  CD  GLN D  85      32.140 -13.413   0.807  1.00 60.42           C  
ATOM   3900  OE1 GLN D  85      32.706 -13.008   1.829  1.00 61.20           O  
ATOM   3901  NE2 GLN D  85      32.656 -13.255  -0.414  1.00 59.66           N  
ATOM   3902  N   THR D  86      26.977 -11.367   1.306  1.00 50.25           N  
ATOM   3903  CA  THR D  86      26.254 -10.278   1.940  1.00 49.27           C  
ATOM   3904  C   THR D  86      25.744 -10.609   3.334  1.00 49.60           C  
ATOM   3905  O   THR D  86      24.921 -11.504   3.523  1.00 49.35           O  
ATOM   3906  CB  THR D  86      25.078  -9.826   1.083  1.00 48.37           C  
ATOM   3907  OG1 THR D  86      25.578  -9.270  -0.137  1.00 50.73           O  
ATOM   3908  CG2 THR D  86      24.264  -8.779   1.805  1.00 48.26           C  
ATOM   3909  N   PHE D  87      26.252  -9.865   4.307  1.00 48.78           N  
ATOM   3910  CA  PHE D  87      25.869 -10.022   5.696  1.00 47.70           C  
ATOM   3911  C   PHE D  87      24.851  -8.931   5.982  1.00 46.91           C  
ATOM   3912  O   PHE D  87      24.936  -7.841   5.421  1.00 46.91           O  
ATOM   3913  CB  PHE D  87      27.090  -9.824   6.590  1.00 49.47           C  
ATOM   3914  CG  PHE D  87      28.165 -10.848   6.389  1.00 52.16           C  
ATOM   3915  CD1 PHE D  87      28.272 -11.937   7.249  1.00 54.03           C  
ATOM   3916  CD2 PHE D  87      29.069 -10.732   5.335  1.00 52.47           C  
ATOM   3917  CE1 PHE D  87      29.273 -12.902   7.066  1.00 56.20           C  
ATOM   3918  CE2 PHE D  87      30.073 -11.687   5.139  1.00 54.24           C  
ATOM   3919  CZ  PHE D  87      30.177 -12.776   6.008  1.00 55.25           C  
ATOM   3920  N   THR D  88      23.883  -9.219   6.844  1.00 46.05           N  
ATOM   3921  CA  THR D  88      22.879  -8.222   7.191  1.00 46.04           C  
ATOM   3922  C   THR D  88      23.143  -7.657   8.581  1.00 45.49           C  
ATOM   3923  O   THR D  88      22.695  -8.212   9.587  1.00 45.57           O  
ATOM   3924  CB  THR D  88      21.460  -8.810   7.162  1.00 46.41           C  
ATOM   3925  OG1 THR D  88      21.167  -9.281   5.841  1.00 48.85           O  
ATOM   3926  CG2 THR D  88      20.440  -7.750   7.552  1.00 45.51           C  
ATOM   3927  N   LEU D  89      23.876  -6.549   8.621  1.00 44.15           N  
ATOM   3928  CA  LEU D  89      24.215  -5.867   9.865  1.00 43.47           C  
ATOM   3929  C   LEU D  89      22.945  -5.309  10.500  1.00 42.70           C  
ATOM   3930  O   LEU D  89      22.387  -4.331  10.008  1.00 41.47           O  
ATOM   3931  CB  LEU D  89      25.186  -4.725   9.566  1.00 43.50           C  
ATOM   3932  CG  LEU D  89      25.776  -3.957  10.746  1.00 44.39           C  
ATOM   3933  CD1 LEU D  89      26.716  -4.879  11.510  1.00 44.00           C  
ATOM   3934  CD2 LEU D  89      26.527  -2.723  10.244  1.00 44.33           C  
ATOM   3935  N   GLY D  90      22.489  -5.936  11.586  1.00 44.06           N  
ATOM   3936  CA  GLY D  90      21.275  -5.492  12.257  1.00 44.79           C  
ATOM   3937  C   GLY D  90      21.107  -6.041  13.665  1.00 46.61           C  
ATOM   3938  O   GLY D  90      21.912  -6.857  14.116  1.00 46.79           O  
ATOM   3939  N   PRO D  91      20.060  -5.613  14.388  1.00 47.03           N  
ATOM   3940  CA  PRO D  91      19.788  -6.062  15.758  1.00 48.28           C  
ATOM   3941  C   PRO D  91      18.921  -7.316  15.943  1.00 49.69           C  
ATOM   3942  O   PRO D  91      18.835  -7.846  17.050  1.00 50.75           O  
ATOM   3943  CB  PRO D  91      19.146  -4.835  16.381  1.00 48.37           C  
ATOM   3944  CG  PRO D  91      18.312  -4.326  15.251  1.00 47.32           C  
ATOM   3945  CD  PRO D  91      19.237  -4.438  14.055  1.00 47.31           C  
ATOM   3946  N   ALA D  92      18.271  -7.786  14.884  1.00 51.05           N  
ATOM   3947  CA  ALA D  92      17.423  -8.978  14.990  1.00 50.97           C  
ATOM   3948  C   ALA D  92      18.278 -10.242  15.047  1.00 51.24           C  
ATOM   3949  O   ALA D  92      18.412 -10.961  14.057  1.00 50.89           O  
ATOM   3950  CB  ALA D  92      16.461  -9.046  13.806  1.00 51.52           C  
ATOM   3951  N   ILE D  93      18.851 -10.506  16.215  1.00 51.43           N  
ATOM   3952  CA  ILE D  93      19.708 -11.668  16.412  1.00 52.38           C  
ATOM   3953  C   ILE D  93      18.917 -12.967  16.307  1.00 52.90           C  
ATOM   3954  O   ILE D  93      19.412 -13.970  15.796  1.00 52.23           O  
ATOM   3955  CB  ILE D  93      20.371 -11.629  17.800  1.00 53.35           C  
ATOM   3956  CG1 ILE D  93      20.604 -10.177  18.221  1.00 54.33           C  
ATOM   3957  CG2 ILE D  93      21.693 -12.379  17.772  1.00 52.55           C  
ATOM   3958  CD1 ILE D  93      21.438  -9.380  17.248  1.00 53.93           C  
ATOM   3959  N   LEU D  94      17.685 -12.938  16.801  1.00 53.73           N  
ATOM   3960  CA  LEU D  94      16.821 -14.109  16.784  1.00 54.72           C  
ATOM   3961  C   LEU D  94      16.183 -14.353  15.421  1.00 54.47           C  
ATOM   3962  O   LEU D  94      15.328 -15.226  15.279  1.00 54.05           O  
ATOM   3963  CB  LEU D  94      15.733 -13.969  17.855  1.00 56.36           C  
ATOM   3964  CG  LEU D  94      16.247 -13.730  19.283  1.00 58.43           C  
ATOM   3965  CD1 LEU D  94      15.070 -13.548  20.237  1.00 58.07           C  
ATOM   3966  CD2 LEU D  94      17.123 -14.897  19.718  1.00 57.28           C  
ATOM   3967  N   GLU D  95      16.596 -13.580  14.423  1.00 53.97           N  
ATOM   3968  CA  GLU D  95      16.068 -13.741  13.075  1.00 53.22           C  
ATOM   3969  C   GLU D  95      17.171 -13.752  12.014  1.00 52.84           C  
ATOM   3970  O   GLU D  95      16.912 -13.478  10.844  1.00 53.31           O  
ATOM   3971  CB  GLU D  95      15.059 -12.636  12.749  1.00 53.13           C  
ATOM   3972  CG  GLU D  95      13.662 -12.818  13.356  1.00 55.12           C  
ATOM   3973  CD  GLU D  95      13.553 -12.338  14.795  1.00 55.89           C  
ATOM   3974  OE1 GLU D  95      13.916 -11.174  15.070  1.00 56.35           O  
ATOM   3975  OE2 GLU D  95      13.089 -13.121  15.652  1.00 57.08           O  
ATOM   3976  N   GLY D  96      18.400 -14.061  12.416  1.00 51.73           N  
ATOM   3977  CA  GLY D  96      19.487 -14.103  11.452  1.00 51.74           C  
ATOM   3978  C   GLY D  96      20.475 -12.947  11.485  1.00 51.66           C  
ATOM   3979  O   GLY D  96      21.687 -13.153  11.400  1.00 52.22           O  
ATOM   3980  N   GLU D  97      19.966 -11.727  11.607  1.00 50.03           N  
ATOM   3981  CA  GLU D  97      20.813 -10.534  11.639  1.00 48.43           C  
ATOM   3982  C   GLU D  97      21.938 -10.563  12.691  1.00 46.53           C  
ATOM   3983  O   GLU D  97      21.904 -11.352  13.638  1.00 45.78           O  
ATOM   3984  CB  GLU D  97      19.930  -9.292  11.851  1.00 48.04           C  
ATOM   3985  CG  GLU D  97      19.095  -8.911  10.630  1.00 48.15           C  
ATOM   3986  CD  GLU D  97      18.106  -7.799  10.912  1.00 48.11           C  
ATOM   3987  OE1 GLU D  97      18.366  -6.980  11.823  1.00 47.31           O  
ATOM   3988  OE2 GLU D  97      17.075  -7.737  10.208  1.00 47.72           O  
ATOM   3989  N   ARG D  98      22.932  -9.697  12.501  1.00 43.30           N  
ATOM   3990  CA  ARG D  98      24.066  -9.573  13.416  1.00 42.13           C  
ATOM   3991  C   ARG D  98      24.570  -8.124  13.458  1.00 41.70           C  
ATOM   3992  O   ARG D  98      24.966  -7.553  12.437  1.00 41.08           O  
ATOM   3993  CB  ARG D  98      25.193 -10.519  13.002  1.00 40.63           C  
ATOM   3994  CG  ARG D  98      24.922 -11.970  13.360  1.00 41.57           C  
ATOM   3995  CD  ARG D  98      24.800 -12.156  14.875  1.00 39.56           C  
ATOM   3996  NE  ARG D  98      24.622 -13.556  15.256  1.00 39.99           N  
ATOM   3997  CZ  ARG D  98      23.491 -14.243  15.115  1.00 37.81           C  
ATOM   3998  NH1 ARG D  98      23.438 -15.514  15.491  1.00 36.64           N  
ATOM   3999  NH2 ARG D  98      22.412 -13.663  14.612  1.00 37.40           N  
ATOM   4000  N   PRO D  99      24.567  -7.517  14.654  1.00 40.19           N  
ATOM   4001  CA  PRO D  99      25.000  -6.140  14.890  1.00 38.08           C  
ATOM   4002  C   PRO D  99      26.505  -5.933  14.832  1.00 37.43           C  
ATOM   4003  O   PRO D  99      26.994  -4.822  15.047  1.00 37.08           O  
ATOM   4004  CB  PRO D  99      24.448  -5.856  16.269  1.00 38.52           C  
ATOM   4005  CG  PRO D  99      24.697  -7.161  16.957  1.00 39.42           C  
ATOM   4006  CD  PRO D  99      24.232  -8.177  15.929  1.00 39.60           C  
ATOM   4007  N   GLN D 100      27.238  -7.001  14.551  1.00 35.07           N  
ATOM   4008  CA  GLN D 100      28.688  -6.904  14.461  1.00 33.84           C  
ATOM   4009  C   GLN D 100      29.196  -7.787  13.335  1.00 32.53           C  
ATOM   4010  O   GLN D 100      28.717  -8.899  13.154  1.00 31.65           O  
ATOM   4011  CB  GLN D 100      29.337  -7.332  15.781  1.00 32.86           C  
ATOM   4012  CG  GLN D 100      30.844  -7.121  15.817  1.00 34.89           C  
ATOM   4013  CD  GLN D 100      31.488  -7.649  17.088  1.00 37.71           C  
ATOM   4014  OE1 GLN D 100      31.579  -8.857  17.293  1.00 37.95           O  
ATOM   4015  NE2 GLN D 100      31.933  -6.742  17.951  1.00 37.42           N  
ATOM   4016  N   VAL D 101      30.151  -7.277  12.568  1.00 31.82           N  
ATOM   4017  CA  VAL D 101      30.742  -8.031  11.472  1.00 32.63           C  
ATOM   4018  C   VAL D 101      32.169  -7.561  11.207  1.00 34.64           C  
ATOM   4019  O   VAL D 101      32.416  -6.375  10.966  1.00 34.65           O  
ATOM   4020  CB  VAL D 101      29.910  -7.927  10.162  1.00 31.33           C  
ATOM   4021  CG1 VAL D 101      29.146  -6.631  10.127  1.00 33.79           C  
ATOM   4022  CG2 VAL D 101      30.826  -8.020   8.950  1.00 28.17           C  
ATOM   4023  N   ILE D 102      33.098  -8.512  11.275  1.00 34.51           N  
ATOM   4024  CA  ILE D 102      34.508  -8.249  11.046  1.00 34.25           C  
ATOM   4025  C   ILE D 102      34.818  -8.281   9.561  1.00 34.31           C  
ATOM   4026  O   ILE D 102      34.525  -9.258   8.871  1.00 36.08           O  
ATOM   4027  CB  ILE D 102      35.406  -9.302  11.736  1.00 34.12           C  
ATOM   4028  CG1 ILE D 102      35.320  -9.175  13.257  1.00 36.73           C  
ATOM   4029  CG2 ILE D 102      36.838  -9.116  11.311  1.00 34.33           C  
ATOM   4030  CD1 ILE D 102      34.003  -9.620  13.838  1.00 39.84           C  
ATOM   4031  N   VAL D 103      35.406  -7.200   9.069  1.00 33.52           N  
ATOM   4032  CA  VAL D 103      35.793  -7.115   7.671  1.00 32.85           C  
ATOM   4033  C   VAL D 103      37.307  -7.244   7.656  1.00 32.89           C  
ATOM   4034  O   VAL D 103      38.010  -6.344   8.113  1.00 31.89           O  
ATOM   4035  CB  VAL D 103      35.395  -5.757   7.057  1.00 33.20           C  
ATOM   4036  CG1 VAL D 103      35.937  -5.644   5.636  1.00 31.22           C  
ATOM   4037  CG2 VAL D 103      33.883  -5.612   7.072  1.00 31.35           C  
ATOM   4038  N   PRO D 104      37.828  -8.375   7.152  1.00 33.69           N  
ATOM   4039  CA  PRO D 104      39.280  -8.597   7.095  1.00 34.34           C  
ATOM   4040  C   PRO D 104      40.011  -7.513   6.318  1.00 35.95           C  
ATOM   4041  O   PRO D 104      39.417  -6.829   5.486  1.00 38.56           O  
ATOM   4042  CB  PRO D 104      39.400  -9.970   6.434  1.00 32.89           C  
ATOM   4043  CG  PRO D 104      38.162 -10.049   5.588  1.00 34.89           C  
ATOM   4044  CD  PRO D 104      37.099  -9.473   6.495  1.00 32.80           C  
ATOM   4045  N   ALA D 105      41.301  -7.355   6.585  1.00 37.33           N  
ATOM   4046  CA  ALA D 105      42.087  -6.332   5.905  1.00 38.53           C  
ATOM   4047  C   ALA D 105      42.135  -6.549   4.395  1.00 40.28           C  
ATOM   4048  O   ALA D 105      42.085  -7.684   3.919  1.00 42.07           O  
ATOM   4049  CB  ALA D 105      43.500  -6.292   6.476  1.00 35.65           C  
ATOM   4050  N   ASN D 106      42.213  -5.444   3.655  1.00 40.16           N  
ATOM   4051  CA  ASN D 106      42.284  -5.455   2.196  1.00 39.89           C  
ATOM   4052  C   ASN D 106      41.106  -6.143   1.516  1.00 38.99           C  
ATOM   4053  O   ASN D 106      41.155  -6.443   0.322  1.00 39.10           O  
ATOM   4054  CB  ASN D 106      43.590  -6.107   1.737  1.00 40.45           C  
ATOM   4055  CG  ASN D 106      43.911  -5.809   0.279  1.00 40.11           C  
ATOM   4056  OD1 ASN D 106      44.117  -4.661  -0.098  1.00 40.30           O  
ATOM   4057  ND2 ASN D 106      43.950  -6.846  -0.544  1.00 42.31           N  
ATOM   4058  N   CYS D 107      40.050  -6.395   2.273  1.00 38.17           N  
ATOM   4059  CA  CYS D 107      38.867  -7.028   1.711  1.00 37.85           C  
ATOM   4060  C   CYS D 107      37.944  -5.966   1.120  1.00 38.73           C  
ATOM   4061  O   CYS D 107      37.703  -4.933   1.743  1.00 39.28           O  
ATOM   4062  CB  CYS D 107      38.114  -7.796   2.790  1.00 37.41           C  
ATOM   4063  SG  CYS D 107      36.530  -8.414   2.215  1.00 34.75           S  
ATOM   4064  N   TRP D 108      37.423  -6.211  -0.076  1.00 37.74           N  
ATOM   4065  CA  TRP D 108      36.528  -5.246  -0.687  1.00 37.35           C  
ATOM   4066  C   TRP D 108      35.238  -5.158   0.117  1.00 37.24           C  
ATOM   4067  O   TRP D 108      34.750  -6.163   0.626  1.00 36.79           O  
ATOM   4068  CB  TRP D 108      36.201  -5.644  -2.129  1.00 39.20           C  
ATOM   4069  CG  TRP D 108      37.327  -5.437  -3.104  1.00 39.17           C  
ATOM   4070  CD1 TRP D 108      38.052  -6.403  -3.737  1.00 38.41           C  
ATOM   4071  CD2 TRP D 108      37.842  -4.181  -3.564  1.00 39.11           C  
ATOM   4072  NE1 TRP D 108      38.984  -5.831  -4.567  1.00 39.54           N  
ATOM   4073  CE2 TRP D 108      38.877  -4.467  -4.481  1.00 40.09           C  
ATOM   4074  CE3 TRP D 108      37.527  -2.844  -3.292  1.00 37.93           C  
ATOM   4075  CZ2 TRP D 108      39.602  -3.464  -5.130  1.00 40.10           C  
ATOM   4076  CZ3 TRP D 108      38.246  -1.847  -3.936  1.00 38.77           C  
ATOM   4077  CH2 TRP D 108      39.272  -2.161  -4.843  1.00 40.22           C  
ATOM   4078  N   GLN D 109      34.682  -3.954   0.219  1.00 37.00           N  
ATOM   4079  CA  GLN D 109      33.440  -3.755   0.954  1.00 37.03           C  
ATOM   4080  C   GLN D 109      32.611  -2.564   0.457  1.00 36.82           C  
ATOM   4081  O   GLN D 109      33.158  -1.534   0.056  1.00 37.74           O  
ATOM   4082  CB  GLN D 109      33.737  -3.576   2.448  1.00 36.06           C  
ATOM   4083  CG  GLN D 109      34.657  -2.404   2.761  1.00 37.03           C  
ATOM   4084  CD  GLN D 109      34.736  -2.092   4.246  1.00 36.12           C  
ATOM   4085  OE1 GLN D 109      33.723  -1.819   4.888  1.00 36.37           O  
ATOM   4086  NE2 GLN D 109      35.941  -2.122   4.793  1.00 34.46           N  
ATOM   4087  N   SER D 110      31.291  -2.733   0.475  1.00 35.71           N  
ATOM   4088  CA  SER D 110      30.338  -1.698   0.077  1.00 36.09           C  
ATOM   4089  C   SER D 110      29.082  -1.983   0.884  1.00 35.07           C  
ATOM   4090  O   SER D 110      28.814  -3.132   1.225  1.00 35.41           O  
ATOM   4091  CB  SER D 110      30.009  -1.782  -1.412  1.00 37.17           C  
ATOM   4092  OG  SER D 110      29.150  -2.872  -1.665  1.00 42.26           O  
ATOM   4093  N   ALA D 111      28.301  -0.956   1.191  1.00 34.02           N  
ATOM   4094  CA  ALA D 111      27.112  -1.180   1.989  1.00 33.88           C  
ATOM   4095  C   ALA D 111      25.974  -0.240   1.647  1.00 33.78           C  
ATOM   4096  O   ALA D 111      26.165   0.742   0.936  1.00 34.85           O  
ATOM   4097  CB  ALA D 111      27.462  -1.051   3.454  1.00 34.44           C  
ATOM   4098  N   GLU D 112      24.785  -0.550   2.153  1.00 33.28           N  
ATOM   4099  CA  GLU D 112      23.629   0.289   1.898  1.00 34.75           C  
ATOM   4100  C   GLU D 112      22.511  -0.012   2.884  1.00 34.06           C  
ATOM   4101  O   GLU D 112      22.143  -1.162   3.104  1.00 34.66           O  
ATOM   4102  CB  GLU D 112      23.144   0.112   0.452  1.00 36.04           C  
ATOM   4103  CG  GLU D 112      22.436  -1.201   0.156  1.00 42.44           C  
ATOM   4104  CD  GLU D 112      22.320  -1.492  -1.341  1.00 46.29           C  
ATOM   4105  OE1 GLU D 112      21.943  -0.577  -2.118  1.00 46.75           O  
ATOM   4106  OE2 GLU D 112      22.601  -2.647  -1.738  1.00 47.03           O  
ATOM   4107  N   SER D 113      21.989   1.044   3.494  1.00 33.34           N  
ATOM   4108  CA  SER D 113      20.912   0.921   4.458  1.00 31.96           C  
ATOM   4109  C   SER D 113      19.677   0.355   3.778  1.00 33.83           C  
ATOM   4110  O   SER D 113      19.440   0.618   2.598  1.00 33.72           O  
ATOM   4111  CB  SER D 113      20.595   2.291   5.038  1.00 29.67           C  
ATOM   4112  OG  SER D 113      19.428   2.249   5.824  1.00 28.33           O  
ATOM   4113  N   LEU D 114      18.886  -0.414   4.523  1.00 35.21           N  
ATOM   4114  CA  LEU D 114      17.664  -0.997   3.981  1.00 35.87           C  
ATOM   4115  C   LEU D 114      16.444  -0.183   4.339  1.00 36.85           C  
ATOM   4116  O   LEU D 114      15.318  -0.666   4.226  1.00 40.41           O  
ATOM   4117  CB  LEU D 114      17.465  -2.425   4.484  1.00 34.91           C  
ATOM   4118  CG  LEU D 114      18.298  -3.497   3.783  1.00 36.27           C  
ATOM   4119  CD1 LEU D 114      19.760  -3.224   3.999  1.00 38.30           C  
ATOM   4120  CD2 LEU D 114      17.945  -4.865   4.336  1.00 37.73           C  
ATOM   4121  N   GLY D 115      16.657   1.051   4.768  1.00 37.23           N  
ATOM   4122  CA  GLY D 115      15.533   1.887   5.141  1.00 37.81           C  
ATOM   4123  C   GLY D 115      15.830   3.353   4.957  1.00 38.95           C  
ATOM   4124  O   GLY D 115      16.576   3.738   4.052  1.00 38.72           O  
ATOM   4125  N   ASP D 116      15.243   4.173   5.817  1.00 40.48           N  
ATOM   4126  CA  ASP D 116      15.451   5.611   5.757  1.00 42.87           C  
ATOM   4127  C   ASP D 116      16.901   5.943   6.096  1.00 42.84           C  
ATOM   4128  O   ASP D 116      17.512   6.792   5.448  1.00 44.71           O  
ATOM   4129  CB  ASP D 116      14.503   6.319   6.718  1.00 46.20           C  
ATOM   4130  CG  ASP D 116      13.047   6.051   6.392  1.00 49.23           C  
ATOM   4131  OD1 ASP D 116      12.616   4.879   6.485  1.00 52.36           O  
ATOM   4132  OD2 ASP D 116      12.330   7.011   6.039  1.00 50.76           O  
ATOM   4133  N   PHE D 117      17.445   5.275   7.111  1.00 40.29           N  
ATOM   4134  CA  PHE D 117      18.841   5.486   7.501  1.00 37.61           C  
ATOM   4135  C   PHE D 117      19.328   4.359   8.389  1.00 36.08           C  
ATOM   4136  O   PHE D 117      18.546   3.539   8.857  1.00 36.37           O  
ATOM   4137  CB  PHE D 117      19.020   6.803   8.263  1.00 35.19           C  
ATOM   4138  CG  PHE D 117      18.357   6.815   9.608  1.00 34.61           C  
ATOM   4139  CD1 PHE D 117      17.074   7.316   9.760  1.00 34.63           C  
ATOM   4140  CD2 PHE D 117      19.000   6.276  10.718  1.00 35.75           C  
ATOM   4141  CE1 PHE D 117      16.434   7.275  10.991  1.00 34.73           C  
ATOM   4142  CE2 PHE D 117      18.372   6.230  11.958  1.00 34.74           C  
ATOM   4143  CZ  PHE D 117      17.087   6.729  12.095  1.00 36.11           C  
ATOM   4144  N   THR D 118      20.633   4.338   8.621  1.00 36.35           N  
ATOM   4145  CA  THR D 118      21.251   3.346   9.486  1.00 35.22           C  
ATOM   4146  C   THR D 118      22.528   3.921  10.070  1.00 34.53           C  
ATOM   4147  O   THR D 118      23.481   4.172   9.339  1.00 36.05           O  
ATOM   4148  CB  THR D 118      21.581   2.067   8.725  1.00 33.18           C  
ATOM   4149  OG1 THR D 118      20.376   1.532   8.181  1.00 33.87           O  
ATOM   4150  CG2 THR D 118      22.183   1.042   9.651  1.00 33.07           C  
ATOM   4151  N   LEU D 119      22.528   4.147  11.382  1.00 33.04           N  
ATOM   4152  CA  LEU D 119      23.690   4.697  12.082  1.00 30.46           C  
ATOM   4153  C   LEU D 119      24.534   3.526  12.559  1.00 30.51           C  
ATOM   4154  O   LEU D 119      24.027   2.630  13.232  1.00 30.70           O  
ATOM   4155  CB  LEU D 119      23.244   5.510  13.301  1.00 28.36           C  
ATOM   4156  CG  LEU D 119      24.144   6.607  13.889  1.00 26.20           C  
ATOM   4157  CD1 LEU D 119      23.853   6.734  15.380  1.00 23.27           C  
ATOM   4158  CD2 LEU D 119      25.608   6.297  13.662  1.00 26.88           C  
ATOM   4159  N   VAL D 120      25.821   3.536  12.231  1.00 30.24           N  
ATOM   4160  CA  VAL D 120      26.699   2.444  12.632  1.00 29.05           C  
ATOM   4161  C   VAL D 120      28.007   2.942  13.194  1.00 29.38           C  
ATOM   4162  O   VAL D 120      28.230   4.147  13.334  1.00 30.66           O  
ATOM   4163  CB  VAL D 120      27.032   1.542  11.443  1.00 27.96           C  
ATOM   4164  CG1 VAL D 120      25.755   1.053  10.792  1.00 28.30           C  
ATOM   4165  CG2 VAL D 120      27.894   2.304  10.451  1.00 26.90           C  
ATOM   4166  N   GLY D 121      28.880   1.993  13.506  1.00 29.03           N  
ATOM   4167  CA  GLY D 121      30.185   2.329  14.033  1.00 28.62           C  
ATOM   4168  C   GLY D 121      31.241   1.507  13.328  1.00 28.72           C  
ATOM   4169  O   GLY D 121      30.986   0.381  12.903  1.00 28.86           O  
ATOM   4170  N   CYS D 122      32.430   2.069  13.184  1.00 29.70           N  
ATOM   4171  CA  CYS D 122      33.515   1.351  12.536  1.00 32.02           C  
ATOM   4172  C   CYS D 122      34.809   1.579  13.316  1.00 32.15           C  
ATOM   4173  O   CYS D 122      35.211   2.730  13.547  1.00 33.43           O  
ATOM   4174  CB  CYS D 122      33.682   1.823  11.083  1.00 33.20           C  
ATOM   4175  SG  CYS D 122      32.216   1.609  10.022  1.00 35.89           S  
ATOM   4176  N   THR D 123      35.425   0.480  13.747  1.00 29.56           N  
ATOM   4177  CA  THR D 123      36.684   0.524  14.483  1.00 30.90           C  
ATOM   4178  C   THR D 123      37.742  -0.149  13.614  1.00 31.27           C  
ATOM   4179  O   THR D 123      37.601  -1.302  13.213  1.00 29.93           O  
ATOM   4180  CB  THR D 123      36.587  -0.205  15.857  1.00 31.01           C  
ATOM   4181  OG1 THR D 123      35.986  -1.495  15.687  1.00 30.03           O  
ATOM   4182  CG2 THR D 123      35.763   0.619  16.841  1.00 30.33           C  
ATOM   4183  N   VAL D 124      38.798   0.584  13.305  1.00 33.66           N  
ATOM   4184  CA  VAL D 124      39.846   0.054  12.448  1.00 36.09           C  
ATOM   4185  C   VAL D 124      40.983  -0.487  13.297  1.00 36.72           C  
ATOM   4186  O   VAL D 124      41.758   0.268  13.883  1.00 35.42           O  
ATOM   4187  CB  VAL D 124      40.312   1.151  11.466  1.00 36.02           C  
ATOM   4188  CG1 VAL D 124      41.345   0.604  10.493  1.00 35.72           C  
ATOM   4189  CG2 VAL D 124      39.098   1.672  10.708  1.00 33.81           C  
ATOM   4190  N   SER D 125      41.048  -1.817  13.351  1.00 40.66           N  
ATOM   4191  CA  SER D 125      42.015  -2.561  14.159  1.00 44.80           C  
ATOM   4192  C   SER D 125      43.347  -1.852  14.371  1.00 45.90           C  
ATOM   4193  O   SER D 125      43.612  -1.372  15.480  1.00 46.70           O  
ATOM   4194  CB  SER D 125      42.223  -3.971  13.582  1.00 46.22           C  
ATOM   4195  OG  SER D 125      42.392  -4.922  14.622  1.00 44.81           O  
ATOM   4196  N   PRO D 126      44.220  -1.801  13.346  1.00 44.90           N  
ATOM   4197  CA  PRO D 126      45.462  -1.089  13.648  1.00 46.04           C  
ATOM   4198  C   PRO D 126      45.445   0.349  13.146  1.00 46.97           C  
ATOM   4199  O   PRO D 126      46.250   0.714  12.298  1.00 48.85           O  
ATOM   4200  CB  PRO D 126      46.513  -1.925  12.943  1.00 44.92           C  
ATOM   4201  CG  PRO D 126      45.812  -2.319  11.721  1.00 46.43           C  
ATOM   4202  CD  PRO D 126      44.435  -2.730  12.226  1.00 45.11           C  
ATOM   4203  N   GLY D 127      44.529   1.156  13.679  1.00 48.25           N  
ATOM   4204  CA  GLY D 127      44.424   2.546  13.277  1.00 47.60           C  
ATOM   4205  C   GLY D 127      43.906   2.636  11.863  1.00 49.07           C  
ATOM   4206  O   GLY D 127      43.972   1.652  11.125  1.00 51.90           O  
ATOM   4207  N   PHE D 128      43.379   3.798  11.482  1.00 47.56           N  
ATOM   4208  CA  PHE D 128      42.860   4.001  10.130  1.00 44.96           C  
ATOM   4209  C   PHE D 128      43.467   5.260   9.551  1.00 44.22           C  
ATOM   4210  O   PHE D 128      43.543   6.289  10.223  1.00 42.33           O  
ATOM   4211  CB  PHE D 128      41.333   4.135  10.132  1.00 43.93           C  
ATOM   4212  CG  PHE D 128      40.746   4.443   8.778  1.00 43.46           C  
ATOM   4213  CD1 PHE D 128      40.864   5.714   8.216  1.00 43.11           C  
ATOM   4214  CD2 PHE D 128      40.100   3.452   8.049  1.00 42.04           C  
ATOM   4215  CE1 PHE D 128      40.348   5.991   6.949  1.00 43.22           C  
ATOM   4216  CE2 PHE D 128      39.582   3.715   6.789  1.00 41.72           C  
ATOM   4217  CZ  PHE D 128      39.708   4.988   6.235  1.00 43.09           C  
ATOM   4218  N   ALA D 129      43.884   5.171   8.292  1.00 43.17           N  
ATOM   4219  CA  ALA D 129      44.493   6.296   7.608  1.00 43.60           C  
ATOM   4220  C   ALA D 129      44.094   6.295   6.140  1.00 43.15           C  
ATOM   4221  O   ALA D 129      44.096   5.251   5.490  1.00 41.47           O  
ATOM   4222  CB  ALA D 129      46.000   6.222   7.739  1.00 44.14           C  
ATOM   4223  N   PHE D 130      43.746   7.470   5.624  1.00 42.72           N  
ATOM   4224  CA  PHE D 130      43.356   7.589   4.230  1.00 42.01           C  
ATOM   4225  C   PHE D 130      44.494   7.215   3.290  1.00 42.04           C  
ATOM   4226  O   PHE D 130      44.253   6.831   2.149  1.00 42.71           O  
ATOM   4227  CB  PHE D 130      42.860   9.005   3.927  1.00 41.16           C  
ATOM   4228  CG  PHE D 130      41.395   9.208   4.216  1.00 41.12           C  
ATOM   4229  CD1 PHE D 130      40.982  10.056   5.240  1.00 41.27           C  
ATOM   4230  CD2 PHE D 130      40.428   8.540   3.467  1.00 40.27           C  
ATOM   4231  CE1 PHE D 130      39.622  10.233   5.514  1.00 41.49           C  
ATOM   4232  CE2 PHE D 130      39.069   8.709   3.731  1.00 40.63           C  
ATOM   4233  CZ  PHE D 130      38.661   9.558   4.757  1.00 40.51           C  
ATOM   4234  N   SER D 131      45.729   7.305   3.769  1.00 41.89           N  
ATOM   4235  CA  SER D 131      46.872   6.952   2.936  1.00 42.42           C  
ATOM   4236  C   SER D 131      46.831   5.472   2.551  1.00 42.98           C  
ATOM   4237  O   SER D 131      47.497   5.050   1.603  1.00 45.51           O  
ATOM   4238  CB  SER D 131      48.178   7.251   3.661  1.00 41.16           C  
ATOM   4239  OG  SER D 131      48.285   6.471   4.834  1.00 42.99           O  
ATOM   4240  N   SER D 132      46.063   4.683   3.289  1.00 42.02           N  
ATOM   4241  CA  SER D 132      45.943   3.262   2.977  1.00 43.33           C  
ATOM   4242  C   SER D 132      44.474   2.938   2.694  1.00 43.14           C  
ATOM   4243  O   SER D 132      43.967   1.863   3.039  1.00 43.60           O  
ATOM   4244  CB  SER D 132      46.492   2.400   4.127  1.00 42.73           C  
ATOM   4245  OG  SER D 132      45.848   2.684   5.353  1.00 45.90           O  
ATOM   4246  N   PHE D 133      43.813   3.891   2.041  1.00 41.77           N  
ATOM   4247  CA  PHE D 133      42.407   3.792   1.675  1.00 40.27           C  
ATOM   4248  C   PHE D 133      42.267   3.835   0.160  1.00 40.04           C  
ATOM   4249  O   PHE D 133      42.682   4.801  -0.478  1.00 39.46           O  
ATOM   4250  CB  PHE D 133      41.644   4.957   2.290  1.00 40.53           C  
ATOM   4251  CG  PHE D 133      40.233   5.077   1.815  1.00 41.69           C  
ATOM   4252  CD1 PHE D 133      39.273   4.145   2.193  1.00 42.18           C  
ATOM   4253  CD2 PHE D 133      39.855   6.127   0.981  1.00 42.03           C  
ATOM   4254  CE1 PHE D 133      37.953   4.256   1.748  1.00 41.35           C  
ATOM   4255  CE2 PHE D 133      38.538   6.246   0.532  1.00 41.54           C  
ATOM   4256  CZ  PHE D 133      37.589   5.307   0.918  1.00 40.96           C  
ATOM   4257  N   VAL D 134      41.673   2.797  -0.414  1.00 39.89           N  
ATOM   4258  CA  VAL D 134      41.505   2.734  -1.859  1.00 40.96           C  
ATOM   4259  C   VAL D 134      40.115   2.290  -2.283  1.00 41.73           C  
ATOM   4260  O   VAL D 134      39.644   1.229  -1.871  1.00 42.06           O  
ATOM   4261  CB  VAL D 134      42.503   1.745  -2.502  1.00 41.96           C  
ATOM   4262  CG1 VAL D 134      42.266   1.681  -4.007  1.00 42.10           C  
ATOM   4263  CG2 VAL D 134      43.932   2.166  -2.201  1.00 42.57           C  
HETATM 4264  N   MSE D 135      39.456   3.097  -3.108  1.00 42.07           N  
HETATM 4265  CA  MSE D 135      38.140   2.718  -3.595  1.00 43.10           C  
HETATM 4266  C   MSE D 135      38.243   2.296  -5.052  1.00 42.41           C  
HETATM 4267  O   MSE D 135      39.152   2.712  -5.767  1.00 40.91           O  
HETATM 4268  CB  MSE D 135      37.122   3.850  -3.407  1.00 44.13           C  
HETATM 4269  CG  MSE D 135      37.651   5.258  -3.561  1.00 49.27           C  
HETATM 4270 SE   MSE D 135      36.313   6.539  -2.949  1.00 55.26          SE  
HETATM 4271  CE  MSE D 135      35.017   6.275  -4.369  1.00 54.83           C  
ATOM   4272  N   ALA D 136      37.326   1.436  -5.477  1.00 42.97           N  
ATOM   4273  CA  ALA D 136      37.336   0.937  -6.842  1.00 43.92           C  
ATOM   4274  C   ALA D 136      36.738   1.925  -7.837  1.00 45.05           C  
ATOM   4275  O   ALA D 136      36.021   2.858  -7.461  1.00 44.74           O  
ATOM   4276  CB  ALA D 136      36.595  -0.392  -6.911  1.00 44.56           C  
ATOM   4277  N   GLU D 137      37.038   1.705  -9.112  1.00 45.19           N  
ATOM   4278  CA  GLU D 137      36.541   2.560 -10.175  1.00 47.18           C  
ATOM   4279  C   GLU D 137      35.018   2.446 -10.229  1.00 47.51           C  
ATOM   4280  O   GLU D 137      34.474   1.348 -10.324  1.00 47.13           O  
ATOM   4281  CB  GLU D 137      37.150   2.120 -11.507  1.00 49.22           C  
ATOM   4282  CG  GLU D 137      37.406   3.246 -12.506  1.00 53.74           C  
ATOM   4283  CD  GLU D 137      38.455   4.246 -12.026  1.00 56.05           C  
ATOM   4284  OE1 GLU D 137      39.393   3.837 -11.303  1.00 57.08           O  
ATOM   4285  OE2 GLU D 137      38.348   5.440 -12.390  1.00 57.58           O  
ATOM   4286  N   PRO D 138      34.308   3.583 -10.162  1.00 48.09           N  
ATOM   4287  CA  PRO D 138      32.842   3.569 -10.203  1.00 49.62           C  
ATOM   4288  C   PRO D 138      32.284   2.799 -11.400  1.00 50.74           C  
ATOM   4289  O   PRO D 138      32.539   3.147 -12.553  1.00 51.40           O  
ATOM   4290  CB  PRO D 138      32.484   5.054 -10.242  1.00 48.67           C  
ATOM   4291  CG  PRO D 138      33.677   5.674 -10.900  1.00 48.26           C  
ATOM   4292  CD  PRO D 138      34.814   4.963 -10.226  1.00 48.00           C  
ATOM   4293  N   GLY D 139      31.517   1.755 -11.113  1.00 51.14           N  
ATOM   4294  CA  GLY D 139      30.947   0.946 -12.174  1.00 52.03           C  
ATOM   4295  C   GLY D 139      31.389  -0.492 -12.012  1.00 52.46           C  
ATOM   4296  O   GLY D 139      30.650  -1.422 -12.337  1.00 53.34           O  
ATOM   4297  N   TRP D 140      32.604  -0.663 -11.498  1.00 52.74           N  
ATOM   4298  CA  TRP D 140      33.183  -1.981 -11.252  1.00 52.99           C  
ATOM   4299  C   TRP D 140      32.374  -2.750 -10.208  1.00 54.13           C  
ATOM   4300  O   TRP D 140      31.710  -2.162  -9.350  1.00 54.59           O  
ATOM   4301  CB  TRP D 140      34.621  -1.835 -10.751  1.00 50.88           C  
ATOM   4302  CG  TRP D 140      35.268  -3.121 -10.344  1.00 49.65           C  
ATOM   4303  CD1 TRP D 140      35.914  -4.007 -11.154  1.00 50.01           C  
ATOM   4304  CD2 TRP D 140      35.343  -3.662  -9.019  1.00 49.83           C  
ATOM   4305  NE1 TRP D 140      36.391  -5.067 -10.418  1.00 48.94           N  
ATOM   4306  CE2 TRP D 140      36.053  -4.881  -9.105  1.00 49.93           C  
ATOM   4307  CE3 TRP D 140      34.878  -3.236  -7.768  1.00 49.96           C  
ATOM   4308  CZ2 TRP D 140      36.311  -5.680  -7.984  1.00 51.36           C  
ATOM   4309  CZ3 TRP D 140      35.135  -4.033  -6.651  1.00 50.75           C  
ATOM   4310  CH2 TRP D 140      35.845  -5.241  -6.769  1.00 51.30           C  
ATOM   4311  N   SER D 141      32.445  -4.069 -10.289  1.00 54.92           N  
ATOM   4312  CA  SER D 141      31.745  -4.938  -9.358  1.00 56.00           C  
ATOM   4313  C   SER D 141      32.614  -6.175  -9.217  1.00 56.95           C  
ATOM   4314  O   SER D 141      33.254  -6.600 -10.176  1.00 56.88           O  
ATOM   4315  CB  SER D 141      30.379  -5.331  -9.920  1.00 57.23           C  
ATOM   4316  OG  SER D 141      29.645  -4.194 -10.341  1.00 57.99           O  
ATOM   4317  N   PRO D 142      32.665  -6.762  -8.015  1.00 58.19           N  
ATOM   4318  CA  PRO D 142      33.485  -7.962  -7.816  1.00 58.12           C  
ATOM   4319  C   PRO D 142      33.126  -9.079  -8.802  1.00 59.07           C  
ATOM   4320  O   PRO D 142      33.965  -9.395  -9.674  1.00 59.42           O  
ATOM   4321  CB  PRO D 142      33.181  -8.340  -6.372  1.00 58.16           C  
ATOM   4322  CG  PRO D 142      32.972  -6.996  -5.724  1.00 58.47           C  
ATOM   4323  CD  PRO D 142      32.104  -6.286  -6.738  1.00 58.17           C  
TER    4324      PRO D 142                                                      
END
MOLECULE T0414.pdb
ATOM      1  N   ALA     3      33.302  15.772  39.809  1.00 36.36           N  
ATOM      2  CA  ALA     3      33.703  14.577  39.009  1.00 34.68           C  
ATOM      3  C   ALA     3      33.623  14.788  37.490  1.00 33.45           C  
ATOM      4  O   ALA     3      32.753  15.521  36.975  1.00 34.46           O  
ATOM      5  CB  ALA     3      32.891  13.338  39.421  1.00 34.63           C  
ATOM      6  N   MET     4      34.518  14.186  36.727  0.50 33.03           N  
ATOM      8  CA  MET     4      34.520  14.424  35.288  0.50 31.92           C  
ATOM     10  C   MET     4      33.425  13.560  34.616  0.50 29.87           C  
ATOM     12  O   MET     4      33.219  12.421  35.010  0.50 28.81           O  
ATOM     14  CB  MET     4      35.942  14.155  34.757  0.50 32.53           C  
ATOM     16  CG  MET     4      36.126  13.883  33.287  0.50 33.68           C  
ATOM     18  SD  MET     4      37.621  12.592  33.077  0.30 35.37          SE  
ATOM     20  CE  MET     4      38.935  13.454  34.246  0.50 35.07           C  
ATOM     22  N   LYS     5      32.683  14.127  33.663  0.50 27.74           N  
ATOM     24  CA  LYS     5      31.796  13.306  32.842  0.50 25.75           C  
ATOM     26  C   LYS     5      32.631  12.565  31.797  0.50 23.22           C  
ATOM     28  O   LYS     5      33.773  12.916  31.546  0.50 22.57           O  
ATOM     30  CB  LYS     5      30.709  14.150  32.160  0.50 26.57           C  
ATOM     32  CG  LYS     5      29.525  14.483  33.071  0.50 27.85           C  
ATOM     34  CD  LYS     5      28.325  14.912  32.262  0.50 29.82           C  
ATOM     36  CE  LYS     5      27.439  13.747  31.918  0.50 28.42           C  
ATOM     38  NZ  LYS     5      26.334  13.574  32.915  0.50 27.77           N  
ATOM     40  N   PRO     6      32.050  11.528  31.182  1.00 21.30           N  
ATOM     41  CA  PRO     6      32.693  10.923  29.996  1.00 19.52           C  
ATOM     42  C   PRO     6      32.625  11.935  28.854  1.00 18.68           C  
ATOM     43  O   PRO     6      31.774  12.839  28.867  1.00 19.30           O  
ATOM     44  CB  PRO     6      31.790   9.733  29.675  1.00 19.69           C  
ATOM     45  CG  PRO     6      30.458  10.178  30.200  1.00 20.34           C  
ATOM     46  CD  PRO     6      30.766  10.901  31.500  1.00 21.56           C  
ATOM     47  N   ASP     7      33.506  11.792  27.867  1.00 17.52           N  
ATOM     48  CA  ASP     7      33.309  12.556  26.627  1.00 16.91           C  
ATOM     49  C   ASP     7      32.131  11.917  25.899  1.00 15.85           C  
ATOM     50  O   ASP     7      31.966  10.690  25.921  1.00 17.32           O  
ATOM     51  CB  ASP     7      34.552  12.523  25.770  1.00 17.30           C  
ATOM     52  CG  ASP     7      35.764  13.025  26.518  1.00 20.36           C  
ATOM     53  OD1 ASP     7      35.723  14.200  26.989  1.00 22.01           O  
ATOM     54  OD2 ASP     7      36.738  12.272  26.639  1.00 20.73           O  
ATOM     55  N   ILE     8      31.291  12.738  25.293  1.00 16.43           N  
ATOM     56  CA  ILE     8      30.057  12.263  24.664  1.00 16.85           C  
ATOM     57  C   ILE     8      30.093  12.721  23.218  1.00 17.30           C  
ATOM     58  O   ILE     8      30.202  13.939  22.920  1.00 16.82           O  
ATOM     59  CB  ILE     8      28.808  12.859  25.331  1.00 16.75           C  
ATOM     60  CG1 ILE     8      28.809  12.531  26.831  1.00 17.21           C  
ATOM     61  CG2 ILE     8      27.531  12.326  24.628  1.00 17.36           C  
ATOM     62  CD1 ILE     8      27.659  13.134  27.576  1.00 21.50           C  
ATOM     63  N   TYR     9      30.035  11.755  22.304  1.00 16.25           N  
ATOM     64  CA  TYR     9      30.189  12.064  20.879  1.00 16.53           C  
ATOM     65  C   TYR     9      28.922  11.695  20.103  1.00 16.71           C  
ATOM     66  O   TYR     9      28.269  10.652  20.365  1.00 17.09           O  
ATOM     67  CB  TYR     9      31.309  11.207  20.307  1.00 18.16           C  
ATOM     68  CG  TYR     9      32.621  11.239  21.056  1.00 19.13           C  
ATOM     69  CD1 TYR     9      33.272  12.425  21.336  1.00 20.08           C  
ATOM     70  CD2 TYR     9      33.226  10.035  21.442  1.00 21.22           C  
ATOM     71  CE1 TYR     9      34.527  12.415  22.020  1.00 19.52           C  
ATOM     72  CE2 TYR     9      34.442  10.010  22.068  1.00 19.90           C  
ATOM     73  CZ  TYR     9      35.070  11.186  22.368  1.00 19.38           C  
ATOM     74  OH  TYR     9      36.285  11.080  23.009  1.00 22.23           O  
ATOM     75  N   GLU    10      28.590  12.535  19.113  1.00 16.20           N  
ATOM     76  CA  GLU    10      27.458  12.237  18.240  1.00 17.73           C  
ATOM     77  C   GLU    10      27.825  12.717  16.832  1.00 17.84           C  
ATOM     78  O   GLU    10      28.762  13.547  16.657  1.00 17.95           O  
ATOM     79  CB  GLU    10      26.181  12.949  18.724  1.00 18.99           C  
ATOM     80  CG  GLU    10      26.360  14.445  18.695  1.00 21.75           C  
ATOM     81  CD  GLU    10      25.209  15.268  19.281  1.00 25.44           C  
ATOM     82  OE1 GLU    10      24.163  14.693  19.649  1.00 33.26           O  
ATOM     83  OE2 GLU    10      25.399  16.514  19.308  1.00 33.86           O  
ATOM     84  N   ASN    11      27.070  12.220  15.860  1.00 15.68           N  
ATOM     85  CA  ASN    11      27.238  12.683  14.477  1.00 15.50           C  
ATOM     86  C   ASN    11      25.856  12.930  13.910  1.00 16.30           C  
ATOM     87  O   ASN    11      25.046  11.966  13.797  1.00 16.56           O  
ATOM     88  CB  ASN    11      27.966  11.608  13.647  1.00 17.10           C  
ATOM     89  CG  ASN    11      28.062  11.990  12.175  1.00 17.78           C  
ATOM     90  OD1 ASN    11      27.841  13.151  11.836  1.00 17.07           O  
ATOM     91  ND2 ASN    11      28.398  11.027  11.314  1.00 16.10           N  
ATOM     92  N   ASN    12      25.572  14.203  13.592  1.00 17.76           N  
ATOM     93  CA  ASN    12      24.307  14.543  12.923  1.00 18.55           C  
ATOM     94  C   ASN    12      24.489  14.954  11.485  1.00 19.79           C  
ATOM     95  O   ASN    12      23.556  15.494  10.875  1.00 23.14           O  
ATOM     96  CB  ASN    12      23.564  15.640  13.703  1.00 20.05           C  
ATOM     97  CG  ASN    12      23.156  15.160  15.094  1.00 23.62           C  
ATOM     98  OD1 ASN    12      23.532  15.777  16.086  1.00 32.59           O  
ATOM     99  ND2 ASN    12      22.482  14.022  15.159  1.00 27.73           N  
ATOM    100  N   ARG    13      25.665  14.690  10.940  1.00 16.78           N  
ATOM    101  CA  ARG    13      26.007  15.090   9.567  1.00 17.18           C  
ATOM    102  C   ARG    13      25.867  13.915   8.606  1.00 17.32           C  
ATOM    103  O   ARG    13      25.768  12.761   9.017  1.00 18.57           O  
ATOM    104  CB  ARG    13      27.463  15.613   9.536  1.00 16.99           C  
ATOM    105  CG  ARG    13      27.698  16.841  10.366  1.00 16.86           C  
ATOM    106  CD  ARG    13      29.145  17.340  10.231  1.00 18.64           C  
ATOM    107  NE  ARG    13      29.314  18.572  11.017  1.00 20.84           N  
ATOM    108  CZ  ARG    13      29.068  19.795  10.555  1.00 22.46           C  
ATOM    109  NH1 ARG    13      28.699  19.980   9.285  1.00 21.30           N  
ATOM    110  NH2 ARG    13      29.238  20.846  11.368  1.00 26.57           N  
ATOM    111  N   GLU    14      25.874  14.191   7.309  1.00 16.57           N  
ATOM    112  CA  GLU    14      25.895  13.116   6.308  1.00 17.51           C  
ATOM    113  C   GLU    14      27.211  12.302   6.422  1.00 16.26           C  
ATOM    114  O   GLU    14      28.303  12.837   6.662  1.00 18.17           O  
ATOM    115  CB  GLU    14      25.802  13.757   4.918  1.00 18.63           C  
ATOM    116  CG  GLU    14      25.635  12.781   3.785  1.00 22.71           C  
ATOM    117  CD  GLU    14      25.134  13.481   2.513  1.00 24.46           C  
ATOM    118  OE1 GLU    14      23.942  13.830   2.472  1.00 28.70           O  
ATOM    119  OE2 GLU    14      25.953  13.623   1.579  1.00 28.01           O  
ATOM    120  N   GLY    15      27.111  10.995   6.267  1.00 17.10           N  
ATOM    121  CA  GLY    15      28.324  10.243   6.152  1.00 18.01           C  
ATOM    122  C   GLY    15      29.095  10.097   7.455  1.00 17.23           C  
ATOM    123  O   GLY    15      28.526   9.934   8.543  1.00 17.23           O  
ATOM    124  N   ILE    16      30.411  10.148   7.345  1.00 17.29           N  
ATOM    125  CA  ILE    16      31.280   9.730   8.446  1.00 16.95           C  
ATOM    126  C   ILE    16      31.787  10.890   9.280  1.00 16.79           C  
ATOM    127  O   ILE    16      32.203  11.929   8.740  1.00 17.82           O  
ATOM    128  CB  ILE    16      32.507   8.989   7.861  1.00 16.44           C  
ATOM    129  CG1 ILE    16      32.046   7.772   7.049  1.00 18.83           C  
ATOM    130  CG2 ILE    16      33.466   8.593   8.953  1.00 17.93           C  
ATOM    131  CD1 ILE    16      33.193   7.165   6.146  1.00 19.62           C  
ATOM    132  N   LEU    17      31.774  10.717  10.609  1.00 16.67           N  
ATOM    133  CA  LEU    17      32.462  11.624  11.507  1.00 17.09           C  
ATOM    134  C   LEU    17      33.304  10.755  12.436  1.00 17.42           C  
ATOM    135  O   LEU    17      32.781   9.846  13.128  1.00 17.89           O  
ATOM    136  CB  LEU    17      31.464  12.429  12.342  1.00 17.81           C  
ATOM    137  CG  LEU    17      32.111  13.501  13.216  1.00 17.47           C  
ATOM    138  CD1 LEU    17      32.620  14.670  12.347  1.00 19.68           C  
ATOM    139  CD2 LEU    17      31.074  13.984  14.258  1.00 19.13           C  
ATOM    140  N   CYS    18      34.601  11.024  12.429  0.50 18.77           N  
ATOM    142  CA  CYS    18      35.503  10.383  13.334  0.50 18.68           C  
ATOM    144  C   CYS    18      35.329  11.084  14.662  0.50 17.75           C  
ATOM    146  O   CYS    18      35.414  12.342  14.749  0.50 17.11           O  
ATOM    148  CB  CYS    18      36.931  10.520  12.822  0.50 19.68           C  
ATOM    150  SG  CYS    18      38.169   9.741  13.895  0.50 25.35           S  
ATOM    152  N   VAL    19      35.090  10.285  15.703  1.00 17.60           N  
ATOM    153  CA  VAL    19      34.852  10.884  17.017  1.00 17.61           C  
ATOM    154  C   VAL    19      35.901  10.621  18.082  1.00 18.84           C  
ATOM    155  O   VAL    19      36.031  11.426  19.030  1.00 19.37           O  
ATOM    156  CB  VAL    19      33.441  10.554  17.541  1.00 18.37           C  
ATOM    157  CG1 VAL    19      32.386  11.066  16.565  1.00 19.97           C  
ATOM    158  CG2 VAL    19      33.285   9.036  17.807  1.00 19.29           C  
ATOM    159  N   TYR    20      36.659   9.537  17.949  1.00 17.79           N  
ATOM    160  CA  TYR    20      37.705   9.219  18.927  1.00 17.31           C  
ATOM    161  C   TYR    20      38.904   8.679  18.151  1.00 17.74           C  
ATOM    162  O   TYR    20      38.744   7.851  17.253  1.00 17.59           O  
ATOM    163  CB  TYR    20      37.239   8.164  19.938  1.00 18.63           C  
ATOM    164  CG  TYR    20      38.375   7.755  20.831  1.00 18.31           C  
ATOM    165  CD1 TYR    20      38.666   8.491  22.001  1.00 18.30           C  
ATOM    166  CD2 TYR    20      39.252   6.735  20.480  1.00 17.90           C  
ATOM    167  CE1 TYR    20      39.781   8.162  22.798  1.00 16.64           C  
ATOM    168  CE2 TYR    20      40.353   6.396  21.280  1.00 17.14           C  
ATOM    169  CZ  TYR    20      40.610   7.128  22.429  1.00 17.75           C  
ATOM    170  OH  TYR    20      41.720   6.807  23.204  1.00 18.23           O  
ATOM    171  N   LYS    21      40.092   9.175  18.494  0.50 18.45           N  
ATOM    173  CA  LYS    21      41.325   8.709  17.899  0.50 19.23           C  
ATOM    175  C   LYS    21      42.410   8.666  18.967  0.50 18.93           C  
ATOM    177  O   LYS    21      42.492   9.553  19.844  0.50 18.14           O  
ATOM    179  CB  LYS    21      41.769   9.654  16.755  0.50 19.72           C  
ATOM    181  CG  LYS    21      42.986   9.166  15.984  0.50 21.51           C  
ATOM    183  CD  LYS    21      43.277  10.047  14.777  0.50 22.28           C  
ATOM    185  CE  LYS    21      44.165   9.322  13.775  0.50 26.01           C  
ATOM    187  NZ  LYS    21      44.998  10.242  12.956  0.50 28.80           N  
ATOM    189  N   ASN    22      43.246   7.641  18.893  1.00 18.57           N  
ATOM    190  CA  ASN    22      44.510   7.675  19.646  1.00 19.63           C  
ATOM    191  C   ASN    22      45.633   7.170  18.740  1.00 20.21           C  
ATOM    192  O   ASN    22      45.442   7.146  17.525  1.00 21.67           O  
ATOM    193  CB  ASN    22      44.393   6.968  21.000  1.00 19.28           C  
ATOM    194  CG  ASN    22      44.119   5.476  20.878  1.00 18.68           C  
ATOM    195  OD1 ASN    22      44.477   4.855  19.876  1.00 18.07           O  
ATOM    196  ND2 ASN    22      43.512   4.893  21.908  1.00 19.31           N  
ATOM    197  N   GLU    23      46.798   6.802  19.268  0.50 20.33           N  
ATOM    199  CA  GLU    23      47.871   6.392  18.343  0.50 20.79           C  
ATOM    201  C   GLU    23      47.688   4.963  17.811  0.50 20.15           C  
ATOM    203  O   GLU    23      48.445   4.517  16.927  0.50 21.08           O  
ATOM    205  CB  GLU    23      49.271   6.615  18.948  0.50 21.32           C  
ATOM    207  CG  GLU    23      49.531   8.068  19.373  0.50 24.58           C  
ATOM    209  CD  GLU    23      49.988   9.002  18.251  0.50 28.91           C  
ATOM    211  OE1 GLU    23      50.063   8.588  17.074  0.50 31.75           O  
ATOM    213  OE2 GLU    23      50.296  10.181  18.573  0.50 31.68           O  
ATOM    215  N   LYS    24      46.657   4.262  18.314  1.00 19.87           N  
ATOM    216  CA  LYS    24      46.411   2.876  17.906  1.00 18.64           C  
ATOM    217  C   LYS    24      45.123   2.675  17.102  1.00 18.65           C  
ATOM    218  O   LYS    24      45.163   2.084  16.009  1.00 19.79           O  
ATOM    219  CB  LYS    24      46.397   1.937  19.115  1.00 19.67           C  
ATOM    220  CG  LYS    24      47.742   1.895  19.853  1.00 19.24           C  
ATOM    221  CD  LYS    24      47.728   0.842  20.946  1.00 23.27           C  
ATOM    222  CE  LYS    24      49.012   0.890  21.752  1.00 25.06           C  
ATOM    223  NZ  LYS    24      49.012  -0.142  22.838  1.00 26.49           N  
ATOM    224  N   TRP    25      43.996   3.147  17.659  1.00 17.80           N  
ATOM    225  CA  TRP    25      42.710   2.938  16.969  1.00 17.10           C  
ATOM    226  C   TRP    25      41.877   4.189  16.872  1.00 17.05           C  
ATOM    227  O   TRP    25      42.166   5.213  17.501  1.00 17.33           O  
ATOM    228  CB  TRP    25      41.866   1.812  17.636  1.00 17.38           C  
ATOM    229  CG  TRP    25      41.250   2.174  18.989  1.00 17.07           C  
ATOM    230  CD1 TRP    25      40.015   2.746  19.223  1.00 17.16           C  
ATOM    231  CD2 TRP    25      41.857   2.004  20.276  1.00 17.43           C  
ATOM    232  NE1 TRP    25      39.803   2.914  20.576  1.00 16.55           N  
ATOM    233  CE2 TRP    25      40.925   2.472  21.248  1.00 16.10           C  
ATOM    234  CE3 TRP    25      43.109   1.515  20.713  1.00 17.97           C  
ATOM    235  CZ2 TRP    25      41.217   2.471  22.613  1.00 17.89           C  
ATOM    236  CZ3 TRP    25      43.372   1.485  22.082  1.00 18.95           C  
ATOM    237  CH2 TRP    25      42.441   1.975  23.006  1.00 18.93           C  
ATOM    238  N   LEU    26      40.846   4.125  16.057  0.60 17.36           N  
ATOM    240  CA  LEU    26      39.876   5.195  16.053  0.60 18.29           C  
ATOM    242  C   LEU    26      38.473   4.598  16.034  0.60 17.48           C  
ATOM    244  O   LEU    26      38.259   3.406  15.788  0.60 17.47           O  
ATOM    246  CB  LEU    26      40.140   6.186  14.899  0.60 19.00           C  
ATOM    248  CG  LEU    26      40.146   5.630  13.476  0.60 19.25           C  
ATOM    250  CD1 LEU    26      38.728   5.417  13.012  0.60 20.31           C  
ATOM    252  CD2 LEU    26      40.883   6.556  12.503  0.60 20.54           C  
ATOM    254  N   VAL    27      37.519   5.464  16.315  1.00 16.98           N  
ATOM    255  CA  VAL    27      36.079   5.101  16.320  1.00 16.22           C  
ATOM    256  C   VAL    27      35.324   6.179  15.576  1.00 17.45           C  
ATOM    257  O   VAL    27      35.516   7.373  15.844  1.00 17.46           O  
ATOM    258  CB  VAL    27      35.508   5.013  17.747  1.00 17.18           C  
ATOM    259  CG1 VAL    27      34.016   4.551  17.698  1.00 17.61           C  
ATOM    260  CG2 VAL    27      36.386   4.029  18.599  1.00 18.01           C  
ATOM    261  N   CYS    28      34.532   5.742  14.596  1.00 16.21           N  
ATOM    262  CA  CYS    28      33.759   6.689  13.774  1.00 16.26           C  
ATOM    263  C   CYS    28      32.281   6.352  13.879  1.00 16.20           C  
ATOM    264  O   CYS    28      31.899   5.183  14.110  1.00 16.98           O  
ATOM    265  CB  CYS    28      34.172   6.658  12.295  1.00 17.39           C  
ATOM    266  SG  CYS    28      35.986   6.912  12.142  1.00 20.98           S  
ATOM    267  N   ILE    29      31.448   7.378  13.699  1.00 15.71           N  
ATOM    268  CA  ILE    29      30.004   7.183  13.582  1.00 16.13           C  
ATOM    269  C   ILE    29      29.622   7.517  12.143  1.00 16.17           C  
ATOM    270  O   ILE    29      29.951   8.598  11.640  1.00 16.02           O  
ATOM    271  CB  ILE    29      29.218   8.103  14.534  1.00 15.82           C  
ATOM    272  CG1 ILE    29      29.672   7.931  15.981  1.00 15.39           C  
ATOM    273  CG2 ILE    29      27.672   7.900  14.365  1.00 16.09           C  
ATOM    274  CD1 ILE    29      29.037   8.958  16.945  1.00 16.58           C  
ATOM    275  N   LYS    30      28.964   6.585  11.458  1.00 15.88           N  
ATOM    276  CA  LYS    30      28.619   6.785  10.046  1.00 16.21           C  
ATOM    277  C   LYS    30      27.111   6.820   9.855  1.00 16.94           C  
ATOM    278  O   LYS    30      26.400   5.844  10.190  1.00 17.39           O  
ATOM    279  CB  LYS    30      29.211   5.653   9.187  1.00 16.56           C  
ATOM    280  CG  LYS    30      28.903   5.844   7.679  1.00 16.88           C  
ATOM    281  CD  LYS    30      29.732   4.833   6.862  1.00 19.31           C  
ATOM    282  CE  LYS    30      28.991   3.507   6.870  1.00 23.50           C  
ATOM    283  NZ  LYS    30      29.684   2.542   5.986  1.00 28.32           N  
ATOM    284  N   ASN    31      26.611   7.913   9.293  1.00 16.40           N  
ATOM    285  CA  ASN    31      25.209   8.052   8.889  1.00 17.24           C  
ATOM    286  C   ASN    31      25.092   7.792   7.399  1.00 16.60           C  
ATOM    287  O   ASN    31      26.100   7.564   6.719  1.00 16.88           O  
ATOM    288  CB  ASN    31      24.767   9.479   9.184  1.00 17.08           C  
ATOM    289  CG  ASN    31      24.690   9.754  10.673  1.00 17.35           C  
ATOM    290  OD1 ASN    31      24.445   8.818  11.459  1.00 18.51           O  
ATOM    291  ND2 ASN    31      24.915  11.008  11.075  1.00 17.06           N  
ATOM    292  N   TRP    32      23.871   7.844   6.911  1.00 16.43           N  
ATOM    293  CA  TRP    32      23.640   7.654   5.477  1.00 16.87           C  
ATOM    294  C   TRP    32      24.449   8.658   4.661  1.00 16.97           C  
ATOM    295  O   TRP    32      24.639   9.823   5.074  1.00 16.70           O  
ATOM    296  CB  TRP    32      22.156   7.862   5.182  1.00 17.49           C  
ATOM    297  CG  TRP    32      21.767   7.703   3.743  1.00 17.90           C  
ATOM    298  CD1 TRP    32      21.359   6.557   3.112  1.00 18.47           C  
ATOM    299  CD2 TRP    32      21.714   8.745   2.762  1.00 18.65           C  
ATOM    300  NE1 TRP    32      21.081   6.816   1.771  1.00 18.32           N  
ATOM    301  CE2 TRP    32      21.286   8.155   1.538  1.00 18.64           C  
ATOM    302  CE3 TRP    32      22.008  10.118   2.789  1.00 19.67           C  
ATOM    303  CZ2 TRP    32      21.111   8.911   0.360  1.00 20.15           C  
ATOM    304  CZ3 TRP    32      21.847  10.867   1.615  1.00 19.53           C  
ATOM    305  CH2 TRP    32      21.417  10.252   0.420  1.00 19.49           C  
ATOM    306  N   LYS    33      24.952   8.206   3.512  0.50 17.41           N  
ATOM    308  CA  LYS    33      25.520   9.105   2.498  0.50 17.81           C  
ATOM    310  C   LYS    33      25.221   8.457   1.149  0.50 17.76           C  
ATOM    312  O   LYS    33      25.111   7.233   1.067  0.50 17.30           O  
ATOM    314  CB  LYS    33      27.029   9.355   2.697  0.50 18.50           C  
ATOM    316  CG  LYS    33      27.905   8.108   2.859  0.50 17.53           C  
ATOM    318  CD  LYS    33      29.408   8.459   2.928  0.50 18.75           C  
ATOM    320  CE  LYS    33      30.249   7.268   3.434  0.50 20.65           C  
ATOM    322  NZ  LYS    33      30.410   6.095   2.495  0.50 16.18           N  
ATOM    324  N   PRO    34      25.079   9.276   0.086  1.00 18.09           N  
ATOM    325  CA  PRO    34      24.701   8.769  -1.247  1.00 17.70           C  
ATOM    326  C   PRO    34      25.425   7.508  -1.743  1.00 17.56           C  
ATOM    327  O   PRO    34      24.713   6.627  -2.293  1.00 18.77           O  
ATOM    328  CB  PRO    34      24.961   9.981  -2.167  1.00 18.28           C  
ATOM    329  CG  PRO    34      24.611  11.156  -1.256  1.00 18.87           C  
ATOM    330  CD  PRO    34      25.223  10.745   0.112  1.00 18.21           C  
ATOM    331  N   ASP    35      26.747   7.350  -1.534  1.00 17.59           N  
ATOM    332  CA  ASP    35      27.385   6.155  -2.089  1.00 18.40           C  
ATOM    333  C   ASP    35      27.192   4.889  -1.257  1.00 18.59           C  
ATOM    334  O   ASP    35      27.739   3.819  -1.588  1.00 19.50           O  
ATOM    335  CB  ASP    35      28.859   6.364  -2.436  1.00 20.01           C  
ATOM    336  CG  ASP    35      29.792   6.326  -1.216  1.00 22.64           C  
ATOM    337  OD1 ASP    35      29.327   6.354  -0.069  1.00 22.36           O  
ATOM    338  OD2 ASP    35      31.036   6.280  -1.401  1.00 23.21           O  
ATOM    339  N   ASN    36      26.428   5.029  -0.175  1.00 18.02           N  
ATOM    340  CA  ASN    36      25.942   3.845   0.531  1.00 17.85           C  
ATOM    341  C   ASN    36      24.460   3.595   0.249  1.00 17.64           C  
ATOM    342  O   ASN    36      23.911   2.588   0.689  1.00 18.05           O  
ATOM    343  CB  ASN    36      26.070   3.983   2.065  1.00 17.18           C  
ATOM    344  CG  ASN    36      27.514   3.879   2.602  1.00 21.55           C  
ATOM    345  OD1 ASN    36      27.793   4.451   3.630  1.00 30.18           O  
ATOM    346  ND2 ASN    36      28.382   3.116   1.979  1.00 22.47           N  
ATOM    347  N   ASP    37      23.767   4.533  -0.402  1.00 17.32           N  
ATOM    348  CA  ASP    37      22.368   4.259  -0.719  1.00 17.22           C  
ATOM    349  C   ASP    37      22.249   3.126  -1.732  1.00 17.35           C  
ATOM    350  O   ASP    37      23.126   2.958  -2.584  1.00 16.67           O  
ATOM    351  CB  ASP    37      21.719   5.511  -1.320  1.00 17.88           C  
ATOM    352  CG  ASP    37      20.216   5.393  -1.364  1.00 19.89           C  
ATOM    353  OD1 ASP    37      19.582   5.512  -0.288  1.00 21.62           O  
ATOM    354  OD2 ASP    37      19.642   5.158  -2.463  1.00 21.16           O  
ATOM    355  N   ILE    38      21.133   2.394  -1.689  1.00 17.76           N  
ATOM    356  CA  ILE    38      20.948   1.345  -2.698  1.00 19.14           C  
ATOM    357  C   ILE    38      21.100   1.900  -4.142  1.00 19.71           C  
ATOM    358  O   ILE    38      21.650   1.209  -5.026  1.00 20.54           O  
ATOM    359  CB  ILE    38      19.631   0.599  -2.485  1.00 20.17           C  
ATOM    360  CG1 ILE    38      19.657  -0.700  -3.319  1.00 23.22           C  
ATOM    361  CG2 ILE    38      18.432   1.531  -2.673  1.00 21.76           C  
ATOM    362  CD1 ILE    38      18.852  -1.758  -2.799  1.00 26.67           C  
ATOM    363  N   GLU    39      20.657   3.123  -4.368  0.60 18.65           N  
ATOM    365  CA  GLU    39      20.767   3.699  -5.713  0.60 19.62           C  
ATOM    367  C   GLU    39      22.157   4.152  -6.078  0.60 18.83           C  
ATOM    369  O   GLU    39      22.462   4.334  -7.279  0.60 18.82           O  
ATOM    371  CB  GLU    39      19.802   4.868  -5.875  0.60 20.14           C  
ATOM    373  CG  GLU    39      18.363   4.498  -5.623  0.60 22.99           C  
ATOM    375  CD  GLU    39      17.802   3.417  -6.560  0.60 26.07           C  
ATOM    377  OE1 GLU    39      18.361   3.139  -7.646  0.60 28.94           O  
ATOM    379  OE2 GLU    39      16.752   2.856  -6.193  0.60 29.97           O  
ATOM    381  N   GLY    40      22.978   4.383  -5.045  1.00 18.92           N  
ATOM    382  CA  GLY    40      24.291   5.006  -5.202  1.00 18.70           C  
ATOM    383  C   GLY    40      25.463   4.046  -5.085  1.00 19.12           C  
ATOM    384  O   GLY    40      26.595   4.471  -5.205  1.00 19.59           O  
ATOM    385  N   ILE    41      25.200   2.751  -4.884  0.60 18.76           N  
ATOM    387  CA  ILE    41      26.291   1.771  -4.803  0.60 18.02           C  
ATOM    389  C   ILE    41      27.102   1.716  -6.095  0.60 19.31           C  
ATOM    391  O   ILE    41      26.554   1.450  -7.164  0.60 19.38           O  
ATOM    393  CB  ILE    41      25.747   0.371  -4.471  0.60 18.50           C  
ATOM    395  CG1 ILE    41      25.154   0.371  -3.047  0.60 16.67           C  
ATOM    397  CG2 ILE    41      26.865  -0.693  -4.714  0.60 18.56           C  
ATOM    399  CD1 ILE    41      26.117   0.701  -1.919  0.60 18.37           C  
ATOM    401  N   ALA    42      28.406   1.999  -6.003  1.00 18.68           N  
ATOM    402  CA  ALA    42      29.215   2.174  -7.214  1.00 18.88           C  
ATOM    403  C   ALA    42      30.629   1.659  -7.102  1.00 18.31           C  
ATOM    404  O   ALA    42      31.295   1.493  -8.116  1.00 19.25           O  
ATOM    405  CB  ALA    42      29.242   3.688  -7.591  1.00 20.23           C  
ATOM    406  N   HIS    43      31.115   1.464  -5.871  1.00 18.00           N  
ATOM    407  CA  HIS    43      32.509   1.052  -5.664  1.00 16.78           C  
ATOM    408  C   HIS    43      32.608   0.370  -4.335  1.00 17.54           C  
ATOM    409  O   HIS    43      31.736   0.546  -3.468  1.00 17.90           O  
ATOM    410  CB  HIS    43      33.476   2.259  -5.653  1.00 17.86           C  
ATOM    411  CG  HIS    43      32.934   3.453  -4.934  1.00 19.00           C  
ATOM    412  ND1 HIS    43      32.468   4.574  -5.596  1.00 21.45           N  
ATOM    413  CD2 HIS    43      32.713   3.670  -3.607  1.00 20.87           C  
ATOM    414  CE1 HIS    43      32.005   5.442  -4.703  1.00 21.76           C  
ATOM    415  NE2 HIS    43      32.134   4.915  -3.491  1.00 19.81           N  
ATOM    416  N   LEU    44      33.631  -0.452  -4.191  1.00 16.28           N  
ATOM    417  CA  LEU    44      33.989  -1.078  -2.928  1.00 17.41           C  
ATOM    418  C   LEU    44      35.303  -0.515  -2.426  1.00 17.57           C  
ATOM    419  O   LEU    44      36.044   0.102  -3.192  1.00 17.75           O  
ATOM    420  CB  LEU    44      34.140  -2.601  -3.105  1.00 17.41           C  
ATOM    421  CG  LEU    44      32.923  -3.314  -3.708  1.00 17.06           C  
ATOM    422  CD1 LEU    44      33.208  -4.832  -3.740  1.00 18.99           C  
ATOM    423  CD2 LEU    44      31.642  -3.059  -2.890  1.00 17.87           C  
ATOM    424  N   GLU    45      35.613  -0.780  -1.153  1.00 17.32           N  
ATOM    425  CA  GLU    45      36.838  -0.282  -0.525  1.00 17.85           C  
ATOM    426  C   GLU    45      37.617  -1.484  -0.022  1.00 17.53           C  
ATOM    427  O   GLU    45      37.061  -2.561   0.258  1.00 17.19           O  
ATOM    428  CB  GLU    45      36.464   0.633   0.652  1.00 17.71           C  
ATOM    429  CG  GLU    45      37.645   1.395   1.289  1.00 20.73           C  
ATOM    430  CD  GLU    45      37.161   2.412   2.345  1.00 20.50           C  
ATOM    431  OE1 GLU    45      35.935   2.549   2.565  1.00 24.99           O  
ATOM    432  OE2 GLU    45      38.030   3.068   2.921  1.00 32.85           O  
ATOM    433  N   ILE    46      38.916  -1.284   0.170  1.00 18.33           N  
ATOM    434  CA  ILE    46      39.732  -2.349   0.745  1.00 17.98           C  
ATOM    435  C   ILE    46      40.781  -1.674   1.626  1.00 18.08           C  
ATOM    436  O   ILE    46      41.329  -0.614   1.260  1.00 18.26           O  
ATOM    437  CB  ILE    46      40.416  -3.214  -0.352  1.00 18.64           C  
ATOM    438  CG1 ILE    46      41.137  -4.429   0.253  1.00 18.66           C  
ATOM    439  CG2 ILE    46      41.422  -2.371  -1.208  1.00 19.08           C  
ATOM    440  CD1 ILE    46      41.531  -5.521  -0.807  1.00 19.38           C  
ATOM    441  N   HIS    47      41.048  -2.282   2.786  1.00 16.96           N  
ATOM    442  CA  HIS    47      42.132  -1.817   3.653  1.00 17.05           C  
ATOM    443  C   HIS    47      43.253  -2.845   3.589  1.00 18.55           C  
ATOM    444  O   HIS    47      43.075  -4.019   3.928  1.00 19.63           O  
ATOM    445  CB  HIS    47      41.662  -1.750   5.117  1.00 16.94           C  
ATOM    446  CG  HIS    47      40.576  -0.758   5.342  1.00 18.33           C  
ATOM    447  ND1 HIS    47      40.674   0.562   4.944  1.00 20.82           N  
ATOM    448  CD2 HIS    47      39.376  -0.884   5.957  1.00 18.76           C  
ATOM    449  CE1 HIS    47      39.567   1.204   5.295  1.00 22.99           C  
ATOM    450  NE2 HIS    47      38.777   0.359   5.929  1.00 21.68           N  
ATOM    451  N   HIS    48      44.436  -2.396   3.203  1.00 19.42           N  
ATOM    452  CA  HIS    48      45.560  -3.339   3.148  1.00 19.25           C  
ATOM    453  C   HIS    48      46.243  -3.658   4.465  1.00 20.51           C  
ATOM    454  O   HIS    48      46.962  -4.659   4.545  1.00 22.55           O  
ATOM    455  CB  HIS    48      46.594  -2.852   2.116  1.00 19.61           C  
ATOM    456  CG  HIS    48      46.001  -2.629   0.756  1.00 19.32           C  
ATOM    457  ND1 HIS    48      45.428  -3.647   0.021  1.00 21.37           N  
ATOM    458  CD2 HIS    48      45.871  -1.508   0.005  1.00 21.07           C  
ATOM    459  CE1 HIS    48      44.980  -3.168  -1.128  1.00 23.63           C  
ATOM    460  NE2 HIS    48      45.210  -1.868  -1.151  1.00 20.64           N  
ATOM    461  N   SER    49      45.998  -2.843   5.488  0.50 19.93           N  
ATOM    463  CA  SER    49      46.805  -2.926   6.702  0.50 19.80           C  
ATOM    465  C   SER    49      46.013  -2.977   8.005  0.50 19.98           C  
ATOM    467  O   SER    49      46.602  -3.081   9.079  0.50 19.76           O  
ATOM    469  CB  SER    49      47.783  -1.755   6.733  0.50 21.12           C  
ATOM    471  OG  SER    49      48.664  -1.820   5.623  0.50 20.88           O  
ATOM    473  N   THR    50      44.689  -2.893   7.908  1.00 19.07           N  
ATOM    474  CA  THR    50      43.835  -2.910   9.105  1.00 18.53           C  
ATOM    475  C   THR    50      42.602  -3.775   8.911  1.00 18.49           C  
ATOM    476  O   THR    50      42.030  -3.815   7.816  1.00 18.74           O  
ATOM    477  CB  THR    50      43.401  -1.487   9.583  1.00 19.33           C  
ATOM    478  OG1 THR    50      42.743  -1.587  10.864  1.00 18.04           O  
ATOM    479  CG2 THR    50      42.423  -0.839   8.629  1.00 18.56           C  
ATOM    480  N   ASP    51      42.210  -4.431   9.995  1.00 17.41           N  
ATOM    481  CA  ASP    51      40.881  -4.992  10.096  1.00 17.63           C  
ATOM    482  C   ASP    51      39.907  -3.856  10.464  1.00 17.46           C  
ATOM    483  O   ASP    51      40.329  -2.803  10.977  1.00 17.76           O  
ATOM    484  CB  ASP    51      40.800  -6.071  11.184  1.00 17.59           C  
ATOM    485  CG  ASP    51      41.726  -7.267  10.947  1.00 19.72           C  
ATOM    486  OD1 ASP    51      42.217  -7.479   9.811  1.00 20.29           O  
ATOM    487  OD2 ASP    51      41.972  -8.026  11.927  1.00 20.23           O  
ATOM    488  N   GLU    52      38.607  -4.071  10.242  1.00 16.99           N  
ATOM    489  CA  GLU    52      37.626  -3.062  10.649  1.00 16.56           C  
ATOM    490  C   GLU    52      36.385  -3.735  11.205  1.00 16.04           C  
ATOM    491  O   GLU    52      35.928  -4.744  10.655  1.00 16.25           O  
ATOM    492  CB  GLU    52      37.261  -2.210   9.428  1.00 17.33           C  
ATOM    493  CG  GLU    52      36.173  -1.163   9.732  1.00 16.96           C  
ATOM    494  CD  GLU    52      35.956  -0.161   8.605  1.00 20.76           C  
ATOM    495  OE1 GLU    52      36.723  -0.186   7.649  1.00 25.16           O  
ATOM    496  OE2 GLU    52      35.003   0.653   8.675  1.00 22.73           O  
ATOM    497  N   GLN    53      35.891  -3.230  12.338  1.00 15.29           N  
ATOM    498  CA  GLN    53      34.665  -3.780  12.905  1.00 15.57           C  
ATOM    499  C   GLN    53      33.520  -2.794  12.783  1.00 15.96           C  
ATOM    500  O   GLN    53      33.738  -1.562  12.838  1.00 16.46           O  
ATOM    501  CB  GLN    53      34.829  -4.170  14.375  1.00 16.29           C  
ATOM    502  CG  GLN    53      35.923  -5.262  14.568  1.00 16.43           C  
ATOM    503  CD  GLN    53      37.313  -4.679  14.546  1.00 16.79           C  
ATOM    504  OE1 GLN    53      37.608  -3.724  15.302  1.00 18.53           O  
ATOM    505  NE2 GLN    53      38.222  -5.243  13.706  1.00 17.69           N  
ATOM    506  N   PHE    54      32.304  -3.328  12.595  1.00 15.22           N  
ATOM    507  CA  PHE    54      31.127  -2.504  12.339  1.00 16.12           C  
ATOM    508  C   PHE    54      30.054  -2.893  13.333  1.00 16.75           C  
ATOM    509  O   PHE    54      29.820  -4.072  13.596  1.00 16.26           O  
ATOM    510  CB  PHE    54      30.589  -2.820  10.928  1.00 18.13           C  
ATOM    511  CG  PHE    54      31.582  -2.567   9.813  1.00 18.64           C  
ATOM    512  CD1 PHE    54      31.539  -1.357   9.108  1.00 23.57           C  
ATOM    513  CD2 PHE    54      32.565  -3.497   9.498  1.00 20.61           C  
ATOM    514  CE1 PHE    54      32.466  -1.122   8.039  1.00 23.85           C  
ATOM    515  CE2 PHE    54      33.469  -3.245   8.445  1.00 21.03           C  
ATOM    516  CZ  PHE    54      33.403  -2.103   7.732  1.00 23.10           C  
ATOM    517  N   ILE    55      29.342  -1.885  13.826  1.00 16.51           N  
ATOM    518  CA  ILE    55      28.284  -2.074  14.793  1.00 17.03           C  
ATOM    519  C   ILE    55      27.113  -1.256  14.344  1.00 17.63           C  
ATOM    520  O   ILE    55      27.219  -0.042  14.280  1.00 19.02           O  
ATOM    521  CB  ILE    55      28.722  -1.606  16.189  1.00 17.26           C  
ATOM    522  CG1 ILE    55      29.903  -2.450  16.650  1.00 19.11           C  
ATOM    523  CG2 ILE    55      27.555  -1.596  17.205  1.00 20.27           C  
ATOM    524  CD1 ILE    55      30.713  -1.812  17.871  1.00 21.34           C  
ATOM    525  N   LEU    56      25.977  -1.905  14.085  1.00 16.33           N  
ATOM    526  CA  LEU    56      24.747  -1.204  13.647  1.00 16.30           C  
ATOM    527  C   LEU    56      24.031  -0.642  14.872  1.00 18.33           C  
ATOM    528  O   LEU    56      23.734  -1.411  15.823  1.00 18.34           O  
ATOM    529  CB  LEU    56      23.830  -2.203  12.892  1.00 16.00           C  
ATOM    530  CG  LEU    56      22.516  -1.620  12.334  1.00 17.40           C  
ATOM    531  CD1 LEU    56      22.773  -0.483  11.297  1.00 17.23           C  
ATOM    532  CD2 LEU    56      21.728  -2.718  11.668  1.00 17.81           C  
ATOM    533  N   SER    57      23.668   0.645  14.801  1.00 16.83           N  
ATOM    534  CA  SER    57      22.992   1.328  15.912  1.00 17.51           C  
ATOM    535  C   SER    57      21.512   1.580  15.625  1.00 17.72           C  
ATOM    536  O   SER    57      20.643   1.305  16.491  1.00 19.77           O  
ATOM    537  CB  SER    57      23.699   2.672  16.203  1.00 18.26           C  
ATOM    538  OG  SER    57      23.076   3.279  17.342  1.00 19.31           O  
ATOM    539  N   ALA    58      21.206   2.078  14.435  1.00 17.62           N  
ATOM    540  CA  ALA    58      19.819   2.443  14.049  1.00 17.30           C  
ATOM    541  C   ALA    58      19.572   2.038  12.608  1.00 17.02           C  
ATOM    542  O   ALA    58      20.517   1.998  11.804  1.00 17.01           O  
ATOM    543  CB  ALA    58      19.608   3.979  14.147  1.00 18.83           C  
ATOM    544  N   GLY    59      18.307   1.766  12.274  1.00 17.28           N  
ATOM    545  CA  GLY    59      17.964   1.495  10.891  1.00 16.19           C  
ATOM    546  C   GLY    59      18.505   0.148  10.443  1.00 16.70           C  
ATOM    547  O   GLY    59      18.883  -0.706  11.262  1.00 18.82           O  
ATOM    548  N   LYS    60      18.516  -0.003   9.130  1.00 17.10           N  
ATOM    549  CA  LYS    60      18.939  -1.270   8.509  1.00 17.10           C  
ATOM    550  C   LYS    60      20.211  -1.057   7.731  1.00 16.91           C  
ATOM    551  O   LYS    60      20.491   0.048   7.223  1.00 17.29           O  
ATOM    552  CB  LYS    60      17.868  -1.789   7.539  1.00 17.78           C  
ATOM    553  CG  LYS    60      16.534  -2.132   8.176  1.00 19.75           C  
ATOM    554  CD  LYS    60      15.542  -2.331   7.033  1.00 23.56           C  
ATOM    555  CE  LYS    60      14.212  -2.731   7.566  1.00 28.36           C  
ATOM    556  NZ  LYS    60      13.370  -2.904   6.333  1.00 31.59           N  
ATOM    557  N   ALA    61      21.001  -2.123   7.606  1.00 16.77           N  
ATOM    558  CA  ALA    61      22.221  -2.028   6.802  1.00 16.67           C  
ATOM    559  C   ALA    61      22.629  -3.387   6.313  1.00 15.90           C  
ATOM    560  O   ALA    61      22.370  -4.390   6.973  1.00 16.52           O  
ATOM    561  CB  ALA    61      23.365  -1.431   7.605  1.00 17.21           C  
ATOM    562  N   ILE    62      23.253  -3.381   5.140  1.00 15.63           N  
ATOM    563  CA  ILE    62      23.855  -4.564   4.557  1.00 16.08           C  
ATOM    564  C   ILE    62      25.346  -4.326   4.359  1.00 16.56           C  
ATOM    565  O   ILE    62      25.774  -3.236   3.948  1.00 17.64           O  
ATOM    566  CB  ILE    62      23.180  -4.862   3.187  1.00 16.18           C  
ATOM    567  CG1 ILE    62      21.712  -5.258   3.409  1.00 16.39           C  
ATOM    568  CG2 ILE    62      23.914  -5.966   2.429  1.00 17.86           C  
ATOM    569  CD1 ILE    62      20.897  -5.187   2.113  1.00 18.67           C  
ATOM    570  N   LEU    63      26.139  -5.328   4.702  0.60 17.10           N  
ATOM    572  CA  LEU    63      27.582  -5.258   4.487  0.60 17.07           C  
ATOM    574  C   LEU    63      27.917  -6.113   3.262  0.60 17.18           C  
ATOM    576  O   LEU    63      27.628  -7.325   3.249  0.60 17.35           O  
ATOM    578  CB  LEU    63      28.314  -5.806   5.717  0.60 17.84           C  
ATOM    580  CG  LEU    63      29.835  -5.699   5.783  0.60 19.15           C  
ATOM    582  CD1 LEU    63      30.335  -4.263   5.645  0.60 20.68           C  
ATOM    584  CD2 LEU    63      30.261  -6.285   7.125  0.60 20.79           C  
ATOM    586  N   ILE    64      28.462  -5.489   2.213  1.00 17.14           N  
ATOM    587  CA  ILE    64      28.939  -6.178   1.043  1.00 17.08           C  
ATOM    588  C   ILE    64      30.369  -6.603   1.362  1.00 17.38           C  
ATOM    589  O   ILE    64      31.166  -5.790   1.854  1.00 17.79           O  
ATOM    590  CB  ILE    64      29.025  -5.221  -0.204  1.00 17.12           C  
ATOM    591  CG1 ILE    64      27.653  -4.600  -0.477  1.00 20.00           C  
ATOM    592  CG2 ILE    64      29.565  -5.973  -1.440  1.00 18.04           C  
ATOM    593  CD1 ILE    64      27.724  -3.368  -1.404  1.00 18.37           C  
ATOM    594  N   THR    65      30.692  -7.855   1.036  1.00 17.86           N  
ATOM    595  CA  THR    65      32.085  -8.292   1.054  1.00 18.12           C  
ATOM    596  C   THR    65      32.351  -8.962  -0.277  1.00 18.58           C  
ATOM    597  O   THR    65      31.426  -9.489  -0.913  1.00 19.44           O  
ATOM    598  CB  THR    65      32.442  -9.196   2.224  1.00 18.08           C  
ATOM    599  OG1 THR    65      31.489 -10.258   2.313  1.00 17.62           O  
ATOM    600  CG2 THR    65      32.480  -8.375   3.559  1.00 18.10           C  
ATOM    601  N   ALA    66      33.604  -8.910  -0.732  1.00 18.05           N  
ATOM    602  CA  ALA    66      33.887  -9.450  -2.064  1.00 19.25           C  
ATOM    603  C   ALA    66      35.328  -9.878  -2.199  1.00 20.53           C  
ATOM    604  O   ALA    66      36.212  -9.407  -1.476  1.00 19.89           O  
ATOM    605  CB  ALA    66      33.524  -8.414  -3.132  1.00 18.61           C  
ATOM    606  N   GLU    67      35.552 -10.810  -3.119  0.50 21.75           N  
ATOM    608  CA  GLU    67      36.905 -11.053  -3.604  0.50 23.27           C  
ATOM    610  C   GLU    67      36.961 -10.670  -5.072  0.50 23.78           C  
ATOM    612  O   GLU    67      35.966 -10.742  -5.801  0.50 23.10           O  
ATOM    614  CB  GLU    67      37.331 -12.510  -3.419  0.50 24.24           C  
ATOM    616  CG  GLU    67      36.394 -13.509  -4.035  0.50 24.63           C  
ATOM    618  CD  GLU    67      37.087 -14.820  -4.402  0.50 28.22           C  
ATOM    620  OE1 GLU    67      38.147 -15.137  -3.823  0.50 32.90           O  
ATOM    622  OE2 GLU    67      36.559 -15.533  -5.271  0.50 28.66           O  
ATOM    624  N   LYS    68      38.146 -10.272  -5.497  1.00 25.28           N  
ATOM    625  CA  LYS    68      38.360  -9.857  -6.863  1.00 28.72           C  
ATOM    626  C   LYS    68      39.027 -11.029  -7.554  1.00 32.09           C  
ATOM    627  O   LYS    68      40.039 -11.551  -7.074  1.00 31.54           O  
ATOM    628  CB  LYS    68      39.241  -8.601  -6.884  1.00 29.61           C  
ATOM    629  CG  LYS    68      39.108  -7.741  -8.117  1.00 31.87           C  
ATOM    630  CD  LYS    68      40.084  -6.600  -7.985  1.00 36.13           C  
ATOM    631  CE  LYS    68      39.622  -5.388  -8.724  1.00 38.28           C  
ATOM    632  NZ  LYS    68      40.805  -4.612  -9.152  1.00 39.70           N  
ATOM    633  N   GLU    69      38.424 -11.473  -8.649  1.00 35.03           N  
ATOM    634  CA  GLU    69      38.917 -12.620  -9.406  1.00 39.92           C  
ATOM    635  C   GLU    69      39.030 -12.134 -10.841  1.00 40.91           C  
ATOM    636  O   GLU    69      38.033 -11.714 -11.454  1.00 41.18           O  
ATOM    637  CB  GLU    69      37.931 -13.779  -9.292  1.00 39.88           C  
ATOM    638  CG  GLU    69      38.377 -15.100  -9.892  1.00 43.51           C  
ATOM    639  CD  GLU    69      37.375 -16.216  -9.594  1.00 44.52           C  
ATOM    640  OE1 GLU    69      36.155 -16.024  -9.860  1.00 48.99           O  
ATOM    641  OE2 GLU    69      37.811 -17.284  -9.089  1.00 51.23           O  
ATOM    642  N   ASN    70      40.251 -12.181 -11.367  1.00 42.55           N  
ATOM    643  CA  ASN    70      40.575 -11.491 -12.608  1.00 43.92           C  
ATOM    644  C   ASN    70      40.117 -10.034 -12.458  1.00 43.58           C  
ATOM    645  O   ASN    70      40.566  -9.346 -11.534  1.00 44.59           O  
ATOM    646  CB  ASN    70      39.956 -12.229 -13.798  1.00 44.78           C  
ATOM    647  CG  ASN    70      40.392 -13.702 -13.857  1.00 47.87           C  
ATOM    648  OD1 ASN    70      39.561 -14.621 -13.749  1.00 50.12           O  
ATOM    649  ND2 ASN    70      41.705 -13.928 -13.996  1.00 49.37           N  
ATOM    650  N   ASP    71      39.205  -9.566 -13.303  1.00 42.45           N  
ATOM    651  CA  ASP    71      38.738  -8.185 -13.157  1.00 40.43           C  
ATOM    652  C   ASP    71      37.290  -8.046 -12.683  1.00 37.49           C  
ATOM    653  O   ASP    71      36.686  -6.980 -12.864  1.00 38.69           O  
ATOM    654  CB  ASP    71      38.957  -7.396 -14.460  1.00 42.43           C  
ATOM    655  CG  ASP    71      40.191  -6.496 -14.398  1.00 45.99           C  
ATOM    656  OD1 ASP    71      40.131  -5.434 -13.716  1.00 49.92           O  
ATOM    657  OD2 ASP    71      41.221  -6.850 -15.031  1.00 50.27           O  
ATOM    658  N   LYS    72      36.767  -9.099 -12.049  0.50 35.27           N  
ATOM    660  CA  LYS    72      35.371  -9.161 -11.600  0.50 32.39           C  
ATOM    662  C   LYS    72      35.275  -9.506 -10.110  0.50 29.34           C  
ATOM    664  O   LYS    72      36.090 -10.275  -9.587  0.50 28.53           O  
ATOM    666  CB  LYS    72      34.591 -10.201 -12.415  0.50 33.11           C  
ATOM    668  CG  LYS    72      34.608  -9.996 -13.937  0.50 35.22           C  
ATOM    670  CD  LYS    72      33.882  -8.716 -14.352  0.50 38.16           C  
ATOM    672  CE  LYS    72      34.141  -8.381 -15.814  0.50 39.07           C  
ATOM    674  NZ  LYS    72      33.714  -6.985 -16.107  0.50 40.06           N  
ATOM    676  N   PHE    73      34.262  -8.964  -9.438  1.00 26.19           N  
ATOM    677  CA  PHE    73      34.074  -9.258  -8.021  1.00 23.01           C  
ATOM    678  C   PHE    73      33.128 -10.431  -7.845  1.00 22.56           C  
ATOM    679  O   PHE    73      32.081 -10.476  -8.500  1.00 23.23           O  
ATOM    680  CB  PHE    73      33.469  -8.031  -7.331  1.00 20.77           C  
ATOM    681  CG  PHE    73      34.463  -6.919  -7.084  1.00 21.12           C  
ATOM    682  CD1 PHE    73      35.500  -7.085  -6.160  1.00 19.24           C  
ATOM    683  CD2 PHE    73      34.334  -5.723  -7.758  1.00 21.62           C  
ATOM    684  CE1 PHE    73      36.375  -6.072  -5.895  1.00 21.26           C  
ATOM    685  CE2 PHE    73      35.228  -4.661  -7.503  1.00 22.84           C  
ATOM    686  CZ  PHE    73      36.266  -4.864  -6.584  1.00 21.71           C  
ATOM    687  N   ASN    74      33.495 -11.335  -6.947  1.00 21.12           N  
ATOM    688  CA  ASN    74      32.560 -12.346  -6.421  1.00 20.80           C  
ATOM    689  C   ASN    74      31.983 -11.719  -5.159  1.00 20.55           C  
ATOM    690  O   ASN    74      32.750 -11.406  -4.236  1.00 22.73           O  
ATOM    691  CB  ASN    74      33.309 -13.625  -6.086  1.00 20.81           C  
ATOM    692  CG  ASN    74      33.834 -14.312  -7.327  1.00 25.44           C  
ATOM    693  OD1 ASN    74      33.216 -14.214  -8.401  1.00 27.61           O  
ATOM    694  ND2 ASN    74      34.993 -14.981  -7.207  1.00 30.25           N  
ATOM    695  N   ILE    75      30.669 -11.539  -5.100  1.00 18.59           N  
ATOM    696  CA  ILE    75      30.034 -10.671  -4.091  1.00 18.13           C  
ATOM    697  C   ILE    75      29.212 -11.482  -3.061  1.00 19.08           C  
ATOM    698  O   ILE    75      28.517 -12.471  -3.419  1.00 20.00           O  
ATOM    699  CB  ILE    75      29.156  -9.640  -4.810  1.00 18.07           C  
ATOM    700  CG1 ILE    75      30.044  -8.658  -5.589  1.00 20.24           C  
ATOM    701  CG2 ILE    75      28.174  -8.940  -3.848  1.00 20.77           C  
ATOM    702  CD1 ILE    75      29.365  -8.065  -6.753  1.00 22.60           C  
ATOM    703  N   GLU    76      29.308 -11.084  -1.800  0.60 18.87           N  
ATOM    705  CA  GLU    76      28.466 -11.612  -0.735  0.60 19.16           C  
ATOM    707  C   GLU    76      27.745 -10.407  -0.128  0.60 18.09           C  
ATOM    709  O   GLU    76      28.305  -9.282  -0.057  0.60 17.76           O  
ATOM    711  CB  GLU    76      29.339 -12.289   0.332  0.60 20.14           C  
ATOM    713  CG  GLU    76      28.599 -12.731   1.582  0.60 23.37           C  
ATOM    715  CD  GLU    76      27.702 -13.942   1.355  0.60 29.19           C  
ATOM    717  OE1 GLU    76      27.747 -14.565   0.258  0.60 32.28           O  
ATOM    719  OE2 GLU    76      26.959 -14.270   2.308  0.60 32.34           O  
ATOM    721  N   LEU    77      26.507 -10.648   0.309  1.00 17.46           N  
ATOM    722  CA  LEU    77      25.737  -9.644   1.062  1.00 16.79           C  
ATOM    723  C   LEU    77      25.380 -10.220   2.405  1.00 17.12           C  
ATOM    724  O   LEU    77      24.908 -11.374   2.464  1.00 18.05           O  
ATOM    725  CB  LEU    77      24.444  -9.268   0.347  1.00 17.08           C  
ATOM    726  CG  LEU    77      24.616  -8.756  -1.076  1.00 19.68           C  
ATOM    727  CD1 LEU    77      23.246  -8.352  -1.603  1.00 21.69           C  
ATOM    728  CD2 LEU    77      25.579  -7.545  -1.129  1.00 20.67           C  
ATOM    729  N   THR    78      25.559  -9.426   3.459  1.00 16.43           N  
ATOM    730  CA  THR    78      25.221  -9.860   4.834  1.00 15.99           C  
ATOM    731  C   THR    78      24.328  -8.790   5.447  1.00 15.43           C  
ATOM    732  O   THR    78      24.749  -7.629   5.601  1.00 17.08           O  
ATOM    733  CB  THR    78      26.486  -9.986   5.646  1.00 18.10           C  
ATOM    734  OG1 THR    78      27.333 -10.990   5.038  1.00 18.81           O  
ATOM    735  CG2 THR    78      26.154 -10.425   7.078  1.00 19.52           C  
ATOM    736  N   LEU    79      23.096  -9.173   5.798  1.00 16.06           N  
ATOM    737  CA  LEU    79      22.203  -8.219   6.475  1.00 16.46           C  
ATOM    738  C   LEU    79      22.688  -8.061   7.930  1.00 16.23           C  
ATOM    739  O   LEU    79      22.753  -9.061   8.674  1.00 18.78           O  
ATOM    740  CB  LEU    79      20.763  -8.778   6.464  1.00 16.37           C  
ATOM    741  CG  LEU    79      19.661  -7.907   7.062  1.00 17.37           C  
ATOM    742  CD1 LEU    79      19.486  -6.552   6.335  1.00 17.46           C  
ATOM    743  CD2 LEU    79      18.339  -8.679   7.091  1.00 17.44           C  
ATOM    744  N   MET    80      23.043  -6.836   8.320  1.00 17.05           N  
ATOM    745  CA  MET    80      23.489  -6.622   9.699  1.00 17.35           C  
ATOM    746  C   MET    80      22.360  -6.683  10.705  1.00 17.54           C  
ATOM    747  O   MET    80      21.228  -6.227  10.449  1.00 17.87           O  
ATOM    748  CB  MET    80      24.216  -5.268   9.819  1.00 17.15           C  
ATOM    749  CG  MET    80      25.447  -5.249   9.025  1.00 18.39           C  
ATOM    750  SD  MET    80      26.260  -3.413   9.223  0.65 23.14          SE  
ATOM    751  CE  MET    80      27.062  -3.666  10.979  1.00 20.64           C  
ATOM    752  N   GLU    81      22.687  -7.257  11.866  0.60 18.87           N  
ATOM    754  CA  GLU    81      21.777  -7.318  12.996  0.60 20.00           C  
ATOM    756  C   GLU    81      22.268  -6.434  14.122  0.60 18.60           C  
ATOM    758  O   GLU    81      23.461  -6.432  14.462  0.60 18.57           O  
ATOM    760  CB  GLU    81      21.696  -8.754  13.501  0.60 19.45           C  
ATOM    762  CG  GLU    81      21.101  -9.688  12.452  0.60 22.13           C  
ATOM    764  CD  GLU    81      21.019 -11.157  12.881  0.60 24.43           C  
ATOM    766  OE1 GLU    81      20.800 -11.435  14.084  0.60 29.15           O  
ATOM    768  OE2 GLU    81      21.169 -12.041  12.000  0.60 30.97           O  
ATOM    770  N   LYS    82      21.350  -5.682  14.714  0.60 18.42           N  
ATOM    772  CA  LYS    82      21.673  -4.932  15.912  0.60 18.51           C  
ATOM    774  C   LYS    82      21.959  -5.956  17.026  0.60 18.11           C  
ATOM    776  O   LYS    82      21.220  -6.944  17.204  0.60 18.72           O  
ATOM    778  CB  LYS    82      20.511  -4.024  16.313  0.60 18.81           C  
ATOM    780  CG  LYS    82      20.367  -2.809  15.416  0.60 18.90           C  
ATOM    782  CD  LYS    82      19.161  -1.970  15.834  0.60 20.64           C  
ATOM    784  CE  LYS    82      18.782  -1.014  14.727  0.60 21.42           C  
ATOM    786  NZ  LYS    82      18.024  -1.683  13.641  0.60 23.36           N  
ATOM    788  N   GLY    83      23.046  -5.688  17.747  1.00 17.31           N  
ATOM    789  CA  GLY    83      23.527  -6.516  18.854  1.00 17.58           C  
ATOM    790  C   GLY    83      24.740  -7.351  18.496  1.00 17.40           C  
ATOM    791  O   GLY    83      25.387  -7.936  19.376  1.00 18.34           O  
ATOM    792  N   LYS    84      25.042  -7.417  17.207  1.00 16.76           N  
ATOM    793  CA  LYS    84      26.235  -8.150  16.738  1.00 16.39           C  
ATOM    794  C   LYS    84      27.368  -7.205  16.328  1.00 16.76           C  
ATOM    795  O   LYS    84      27.148  -5.985  16.124  1.00 18.19           O  
ATOM    796  CB  LYS    84      25.878  -9.082  15.566  1.00 17.48           C  
ATOM    797  CG  LYS    84      24.850 -10.156  15.982  1.00 18.67           C  
ATOM    798  CD  LYS    84      24.706 -11.195  14.880  1.00 22.19           C  
ATOM    799  CE  LYS    84      23.681 -12.239  15.269  1.00 28.66           C  
ATOM    800  NZ  LYS    84      23.635 -13.207  14.106  1.00 32.70           N  
ATOM    801  N   VAL    85      28.578  -7.780  16.255  1.00 16.21           N  
ATOM    802  CA  VAL    85      29.724  -7.040  15.762  1.00 15.81           C  
ATOM    803  C   VAL    85      30.213  -7.783  14.514  1.00 16.70           C  
ATOM    804  O   VAL    85      30.260  -9.029  14.520  1.00 17.45           O  
ATOM    805  CB  VAL    85      30.846  -6.992  16.798  1.00 16.74           C  
ATOM    806  CG1 VAL    85      32.078  -6.270  16.245  1.00 17.88           C  
ATOM    807  CG2 VAL    85      30.371  -6.241  18.061  1.00 17.90           C  
ATOM    808  N   TYR    86      30.536  -7.031  13.450  1.00 15.64           N  
ATOM    809  CA  TYR    86      31.005  -7.610  12.178  1.00 17.07           C  
ATOM    810  C   TYR    86      32.428  -7.196  11.980  1.00 17.74           C  
ATOM    811  O   TYR    86      32.784  -6.042  12.192  1.00 18.97           O  
ATOM    812  CB  TYR    86      30.128  -7.093  11.010  1.00 16.66           C  
ATOM    813  CG  TYR    86      28.709  -7.580  11.209  1.00 15.88           C  
ATOM    814  CD1 TYR    86      28.249  -8.706  10.552  1.00 16.34           C  
ATOM    815  CD2 TYR    86      27.809  -6.907  12.072  1.00 16.28           C  
ATOM    816  CE1 TYR    86      26.958  -9.193  10.759  1.00 14.73           C  
ATOM    817  CE2 TYR    86      26.521  -7.416  12.280  1.00 15.61           C  
ATOM    818  CZ  TYR    86      26.114  -8.585  11.633  1.00 14.83           C  
ATOM    819  OH  TYR    86      24.834  -9.091  11.844  1.00 17.74           O  
ATOM    820  N   ASN    87      33.252  -8.143  11.539  1.00 16.15           N  
ATOM    821  CA  ASN    87      34.647  -7.813  11.249  1.00 16.28           C  
ATOM    822  C   ASN    87      34.967  -8.085   9.791  1.00 16.88           C  
ATOM    823  O   ASN    87      34.703  -9.187   9.297  1.00 16.54           O  
ATOM    824  CB  ASN    87      35.566  -8.680  12.140  1.00 16.99           C  
ATOM    825  CG  ASN    87      37.049  -8.507  11.803  1.00 18.96           C  
ATOM    826  OD1 ASN    87      37.591  -7.425  11.920  1.00 17.98           O  
ATOM    827  ND2 ASN    87      37.712  -9.592  11.402  1.00 18.13           N  
ATOM    828  N   VAL    88      35.546  -7.085   9.132  1.00 16.41           N  
ATOM    829  CA  VAL    88      36.085  -7.245   7.770  1.00 16.80           C  
ATOM    830  C   VAL    88      37.602  -7.279   7.914  1.00 17.60           C  
ATOM    831  O   VAL    88      38.200  -6.260   8.236  1.00 16.72           O  
ATOM    832  CB  VAL    88      35.655  -6.066   6.852  1.00 16.61           C  
ATOM    833  CG1 VAL    88      36.350  -6.207   5.486  1.00 17.54           C  
ATOM    834  CG2 VAL    88      34.145  -6.101   6.660  1.00 18.60           C  
ATOM    835  N   PRO    89      38.226  -8.441   7.691  1.00 17.46           N  
ATOM    836  CA  PRO    89      39.693  -8.472   7.841  1.00 18.21           C  
ATOM    837  C   PRO    89      40.371  -7.648   6.736  1.00 17.75           C  
ATOM    838  O   PRO    89      39.796  -7.459   5.639  1.00 17.90           O  
ATOM    839  CB  PRO    89      40.068  -9.953   7.641  1.00 19.26           C  
ATOM    840  CG  PRO    89      38.811 -10.684   7.578  1.00 22.10           C  
ATOM    841  CD  PRO    89      37.644  -9.760   7.350  1.00 19.36           C  
ATOM    842  N   ALA    90      41.602  -7.223   7.002  1.00 17.81           N  
ATOM    843  CA  ALA    90      42.410  -6.568   5.984  1.00 17.60           C  
ATOM    844  C   ALA    90      42.467  -7.417   4.715  1.00 17.75           C  
ATOM    845  O   ALA    90      42.462  -8.685   4.788  1.00 18.42           O  
ATOM    846  CB  ALA    90      43.820  -6.416   6.507  1.00 17.36           C  
ATOM    847  N   GLU    91      42.491  -6.715   3.575  1.00 17.80           N  
ATOM    848  CA  GLU    91      42.560  -7.340   2.249  1.00 19.04           C  
ATOM    849  C   GLU    91      41.258  -7.999   1.794  1.00 19.36           C  
ATOM    850  O   GLU    91      41.232  -8.778   0.813  1.00 21.60           O  
ATOM    851  CB  GLU    91      43.726  -8.338   2.133  1.00 19.33           C  
ATOM    852  CG  GLU    91      45.078  -7.770   2.532  1.00 21.26           C  
ATOM    853  CD  GLU    91      45.639  -6.748   1.523  1.00 23.31           C  
ATOM    854  OE1 GLU    91      44.913  -6.288   0.616  1.00 24.66           O  
ATOM    855  OE2 GLU    91      46.819  -6.375   1.678  1.00 27.27           O  
ATOM    856  N   CYS    92      40.167  -7.659   2.459  1.00 19.41           N  
ATOM    857  CA  CYS    92      38.849  -8.089   2.002  1.00 18.30           C  
ATOM    858  C   CYS    92      38.121  -6.846   1.474  1.00 17.59           C  
ATOM    859  O   CYS    92      37.976  -5.859   2.211  1.00 18.82           O  
ATOM    860  CB  CYS    92      38.069  -8.689   3.170  1.00 18.57           C  
ATOM    861  SG  CYS    92      36.398  -9.298   2.672  1.00 22.65           S  
ATOM    862  N   TRP    93      37.619  -6.904   0.239  1.00 16.71           N  
ATOM    863  CA  TRP    93      36.846  -5.767  -0.287  1.00 16.83           C  
ATOM    864  C   TRP    93      35.498  -5.678   0.429  1.00 17.61           C  
ATOM    865  O   TRP    93      34.892  -6.700   0.734  1.00 17.54           O  
ATOM    866  CB  TRP    93      36.578  -6.006  -1.784  1.00 17.22           C  
ATOM    867  CG  TRP    93      37.800  -5.880  -2.605  1.00 17.28           C  
ATOM    868  CD1 TRP    93      38.625  -6.899  -3.028  1.00 18.03           C  
ATOM    869  CD2 TRP    93      38.359  -4.657  -3.124  1.00 17.06           C  
ATOM    870  NE1 TRP    93      39.685  -6.363  -3.791  1.00 18.99           N  
ATOM    871  CE2 TRP    93      39.519  -5.001  -3.878  1.00 19.05           C  
ATOM    872  CE3 TRP    93      37.968  -3.311  -3.050  1.00 18.33           C  
ATOM    873  CZ2 TRP    93      40.312  -4.031  -4.522  1.00 18.83           C  
ATOM    874  CZ3 TRP    93      38.772  -2.329  -3.662  1.00 18.94           C  
ATOM    875  CH2 TRP    93      39.942  -2.697  -4.389  1.00 17.89           C  
ATOM    876  N   PHE    94      35.015  -4.463   0.670  1.00 16.25           N  
ATOM    877  CA  PHE    94      33.733  -4.347   1.367  1.00 16.00           C  
ATOM    878  C   PHE    94      33.103  -3.013   1.053  1.00 16.50           C  
ATOM    879  O   PHE    94      33.760  -2.078   0.536  1.00 16.78           O  
ATOM    880  CB  PHE    94      33.967  -4.407   2.892  1.00 16.42           C  
ATOM    881  CG  PHE    94      34.644  -3.171   3.432  1.00 15.99           C  
ATOM    882  CD1 PHE    94      33.879  -2.105   4.005  1.00 17.05           C  
ATOM    883  CD2 PHE    94      36.019  -3.046   3.357  1.00 18.78           C  
ATOM    884  CE1 PHE    94      34.525  -0.935   4.439  1.00 16.59           C  
ATOM    885  CE2 PHE    94      36.676  -1.882   3.776  1.00 17.42           C  
ATOM    886  CZ  PHE    94      35.928  -0.838   4.327  1.00 17.25           C  
ATOM    887  N   TYR    95      31.823  -2.894   1.409  1.00 16.04           N  
ATOM    888  CA  TYR    95      31.191  -1.568   1.498  1.00 17.12           C  
ATOM    889  C   TYR    95      29.856  -1.764   2.171  1.00 17.96           C  
ATOM    890  O   TYR    95      29.424  -2.879   2.367  1.00 20.58           O  
ATOM    891  CB  TYR    95      30.998  -0.895   0.113  1.00 18.45           C  
ATOM    892  CG  TYR    95      31.337   0.580   0.122  1.00 18.66           C  
ATOM    893  CD1 TYR    95      32.587   0.990   0.570  1.00 19.74           C  
ATOM    894  CD2 TYR    95      30.402   1.534  -0.287  1.00 19.52           C  
ATOM    895  CE1 TYR    95      32.943   2.365   0.605  1.00 19.65           C  
ATOM    896  CE2 TYR    95      30.732   2.907  -0.250  1.00 18.72           C  
ATOM    897  CZ  TYR    95      31.999   3.288   0.206  1.00 20.62           C  
ATOM    898  OH  TYR    95      32.344   4.665   0.229  1.00 22.21           O  
ATOM    899  N   SER    96      29.203  -0.670   2.536  0.60 17.85           N  
ATOM    901  CA  SER    96      27.903  -0.753   3.193  0.60 17.20           C  
ATOM    903  C   SER    96      26.789  -0.333   2.243  0.60 17.09           C  
ATOM    905  O   SER    96      26.997   0.501   1.358  0.60 17.78           O  
ATOM    907  CB  SER    96      27.841   0.244   4.360  0.60 17.61           C  
ATOM    909  OG  SER    96      28.810  -0.014   5.351  0.60 17.19           O  
ATOM    911  N   ILE    97      25.591  -0.868   2.483  1.00 16.44           N  
ATOM    912  CA  ILE    97      24.354  -0.321   1.901  1.00 16.59           C  
ATOM    913  C   ILE    97      23.466   0.075   3.073  1.00 16.37           C  
ATOM    914  O   ILE    97      23.232  -0.712   3.980  1.00 16.97           O  
ATOM    915  CB  ILE    97      23.598  -1.358   1.079  1.00 16.73           C  
ATOM    916  CG1 ILE    97      24.576  -2.160   0.227  1.00 18.48           C  
ATOM    917  CG2 ILE    97      22.560  -0.652   0.174  1.00 16.97           C  
ATOM    918  CD1 ILE    97      23.902  -3.326  -0.606  1.00 17.80           C  
ATOM    919  N   THR    98      23.017   1.331   3.080  1.00 15.49           N  
ATOM    920  CA  THR    98      22.286   1.859   4.223  1.00 16.39           C  
ATOM    921  C   THR    98      21.072   2.651   3.774  1.00 16.27           C  
ATOM    922  O   THR    98      20.908   2.874   2.568  1.00 17.78           O  
ATOM    923  CB  THR    98      23.211   2.765   5.097  1.00 16.82           C  
ATOM    924  OG1 THR    98      23.608   3.912   4.341  1.00 17.49           O  
ATOM    925  CG2 THR    98      24.464   2.014   5.498  1.00 16.73           C  
ATOM    926  N   GLN    99      20.236   3.037   4.733  1.00 16.84           N  
ATOM    927  CA  GLN    99      19.023   3.786   4.445  1.00 17.55           C  
ATOM    928  C   GLN    99      19.118   5.115   5.158  1.00 17.89           C  
ATOM    929  O   GLN    99      20.071   5.344   5.952  1.00 17.09           O  
ATOM    930  CB  GLN    99      17.817   2.960   4.903  1.00 17.09           C  
ATOM    931  CG  GLN    99      17.684   1.680   4.073  1.00 19.07           C  
ATOM    932  CD  GLN    99      16.368   0.929   4.356  1.00 17.48           C  
ATOM    933  OE1 GLN    99      15.827   0.962   5.462  1.00 19.87           O  
ATOM    934  NE2 GLN    99      15.842   0.280   3.318  1.00 20.07           N  
ATOM    935  N   LYS   100      18.167   6.016   4.869  1.00 18.24           N  
ATOM    936  CA  LYS   100      18.372   7.390   5.328  1.00 19.40           C  
ATOM    937  C   LYS   100      18.445   7.522   6.839  1.00 18.81           C  
ATOM    938  O   LYS   100      19.093   8.459   7.347  1.00 20.39           O  
ATOM    939  CB  LYS   100      17.344   8.344   4.722  1.00 20.14           C  
ATOM    940  CG  LYS   100      17.807   8.722   3.296  1.00 25.10           C  
ATOM    941  CD  LYS   100      17.413  10.126   2.880  1.00 35.39           C  
ATOM    942  CE  LYS   100      17.894  10.393   1.474  1.00 37.85           C  
ATOM    943  NZ  LYS   100      17.334   9.340   0.590  1.00 43.07           N  
ATOM    944  N   ASP   101      17.819   6.596   7.562  1.00 18.77           N  
ATOM    945  CA  ASP   101      17.849   6.637   9.032  1.00 18.97           C  
ATOM    946  C   ASP   101      18.862   5.684   9.673  1.00 19.71           C  
ATOM    947  O   ASP   101      18.846   5.468  10.885  1.00 20.13           O  
ATOM    948  CB  ASP   101      16.470   6.352   9.623  1.00 21.14           C  
ATOM    949  CG  ASP   101      15.902   5.004   9.206  1.00 24.80           C  
ATOM    950  OD1 ASP   101      16.414   4.346   8.270  1.00 24.17           O  
ATOM    951  OD2 ASP   101      14.860   4.613   9.808  1.00 30.33           O  
ATOM    952  N   THR   102      19.724   5.102   8.860  1.00 17.06           N  
ATOM    953  CA  THR   102      20.753   4.177   9.371  1.00 17.20           C  
ATOM    954  C   THR   102      21.889   4.902  10.090  1.00 17.58           C  
ATOM    955  O   THR   102      22.381   5.936   9.603  1.00 17.93           O  
ATOM    956  CB  THR   102      21.326   3.378   8.205  1.00 16.57           C  
ATOM    957  OG1 THR   102      20.262   2.654   7.559  1.00 17.53           O  
ATOM    958  CG2 THR   102      22.397   2.359   8.701  1.00 16.80           C  
ATOM    959  N   LYS   103      22.363   4.314  11.198  1.00 17.25           N  
ATOM    960  CA  LYS   103      23.555   4.803  11.872  1.00 16.04           C  
ATOM    961  C   LYS   103      24.375   3.590  12.301  1.00 17.48           C  
ATOM    962  O   LYS   103      23.787   2.647  12.869  1.00 17.08           O  
ATOM    963  CB  LYS   103      23.136   5.585  13.113  1.00 17.08           C  
ATOM    964  CG  LYS   103      24.323   6.281  13.816  1.00 18.18           C  
ATOM    965  CD  LYS   103      23.881   7.037  15.083  1.00 17.54           C  
ATOM    966  CE  LYS   103      22.969   8.210  14.792  1.00 17.74           C  
ATOM    967  NZ  LYS   103      23.675   9.408  14.151  1.00 17.79           N  
ATOM    968  N   MET   104      25.674   3.601  12.015  1.00 16.61           N  
ATOM    969  CA  MET   104      26.548   2.545  12.515  1.00 18.76           C  
ATOM    970  C   MET   104      27.829   3.126  13.028  1.00 18.07           C  
ATOM    971  O   MET   104      28.140   4.287  12.750  1.00 18.20           O  
ATOM    972  CB  MET   104      26.832   1.498  11.444  1.00 21.04           C  
ATOM    973  CG  MET   104      27.693   1.995  10.381  1.00 20.27           C  
ATOM    974  SD  MET   104      28.064   0.469   9.085  0.65 25.94          SE  
ATOM    975  CE  MET   104      26.490   0.644   8.340  1.00 12.83           C  
ATOM    976  N   MET   105      28.546   2.355  13.841  1.00 16.39           N  
ATOM    977  CA  MET   105      29.865   2.791  14.274  1.00 16.00           C  
ATOM    978  C   MET   105      30.870   1.843  13.689  1.00 16.24           C  
ATOM    979  O   MET   105      30.551   0.676  13.404  1.00 16.92           O  
ATOM    980  CB  MET   105      29.987   2.739  15.796  1.00 17.84           C  
ATOM    981  CG  MET   105      29.272   3.873  16.539  1.00 18.81           C  
ATOM    982  SD  MET   105      27.305   3.624  16.437  0.65 22.03          SE  
ATOM    983  CE  MET   105      26.852   4.856  17.895  1.00 19.82           C  
ATOM    984  N   TYR   106      32.079   2.338  13.459  1.00 15.94           N  
ATOM    985  CA  TYR   106      33.147   1.409  13.065  1.00 15.84           C  
ATOM    986  C   TYR   106      34.440   1.718  13.784  1.00 16.88           C  
ATOM    987  O   TYR   106      34.627   2.835  14.304  1.00 15.69           O  
ATOM    988  CB  TYR   106      33.333   1.386  11.548  1.00 17.37           C  
ATOM    989  CG  TYR   106      33.900   2.623  10.865  1.00 17.47           C  
ATOM    990  CD1 TYR   106      35.261   2.903  10.902  1.00 18.62           C  
ATOM    991  CD2 TYR   106      33.066   3.437  10.077  1.00 18.38           C  
ATOM    992  CE1 TYR   106      35.818   4.006  10.169  1.00 19.35           C  
ATOM    993  CE2 TYR   106      33.586   4.511   9.358  1.00 18.20           C  
ATOM    994  CZ  TYR   106      34.954   4.774   9.397  1.00 18.96           C  
ATOM    995  OH  TYR   106      35.485   5.823   8.665  1.00 20.37           O  
ATOM    996  N   VAL   107      35.269   0.673  13.871  1.00 16.69           N  
ATOM    997  CA  VAL   107      36.543   0.737  14.570  1.00 16.04           C  
ATOM    998  C   VAL   107      37.608   0.241  13.612  1.00 17.16           C  
ATOM    999  O   VAL   107      37.430  -0.776  12.944  1.00 16.81           O  
ATOM   1000  CB  VAL   107      36.533  -0.180  15.832  1.00 17.67           C  
ATOM   1001  CG1 VAL   107      37.847   0.002  16.625  1.00 17.38           C  
ATOM   1002  CG2 VAL   107      35.345   0.191  16.747  1.00 17.95           C  
ATOM   1003  N   GLN   108      38.702   0.982  13.518  1.00 17.82           N  
ATOM   1004  CA  GLN   108      39.866   0.519  12.703  1.00 18.01           C  
ATOM   1005  C   GLN   108      41.167   1.158  13.236  1.00 16.91           C  
ATOM   1006  O   GLN   108      41.138   1.936  14.171  1.00 17.32           O  
ATOM   1007  CB  GLN   108      39.712   0.894  11.213  1.00 18.57           C  
ATOM   1008  CG  GLN   108      39.699   2.410  11.035  1.00 19.50           C  
ATOM   1009  CD  GLN   108      39.527   2.873   9.607  1.00 24.12           C  
ATOM   1010  OE1 GLN   108      38.629   2.410   8.870  1.00 30.18           O  
ATOM   1011  NE2 GLN   108      40.376   3.781   9.213  1.00 32.65           N  
ATOM   1012  N   ASP   109      42.305   0.823  12.617  1.00 17.22           N  
ATOM   1013  CA  ASP   109      43.601   1.346  13.028  1.00 18.82           C  
ATOM   1014  C   ASP   109      43.622   2.853  12.801  1.00 20.82           C  
ATOM   1015  O   ASP   109      43.022   3.345  11.842  1.00 22.83           O  
ATOM   1016  CB  ASP   109      44.669   0.676  12.150  1.00 18.66           C  
ATOM   1017  CG  ASP   109      46.071   0.895  12.683  1.00 22.39           C  
ATOM   1018  OD1 ASP   109      46.557   2.062  12.669  1.00 24.76           O  
ATOM   1019  OD2 ASP   109      46.684  -0.113  13.066  1.00 24.55           O  
ATOM   1020  N   SER   110      44.262   3.596  13.694  1.00 21.00           N  
ATOM   1021  CA  SER   110      44.244   5.067  13.586  1.00 22.62           C  
ATOM   1022  C   SER   110      45.081   5.605  12.462  1.00 25.40           C  
ATOM   1023  O   SER   110      44.986   6.794  12.130  1.00 26.13           O  
ATOM   1024  CB  SER   110      44.637   5.744  14.889  1.00 22.48           C  
ATOM   1025  OG  SER   110      45.889   5.282  15.300  1.00 22.98           O  
ATOM   1026  N   ASN   111      45.892   4.759  11.841  0.50 26.61           N  
ATOM   1028  CA  ASN   111      46.619   5.173  10.626  0.50 29.51           C  
ATOM   1030  C   ASN   111      45.681   5.102   9.410  0.50 30.95           C  
ATOM   1032  O   ASN   111      45.748   4.156   8.625  0.50 32.22           O  
ATOM   1034  CB  ASN   111      47.838   4.276  10.385  0.50 29.55           C  
ATOM   1036  CG  ASN   111      48.726   4.132  11.602  0.50 31.43           C  
ATOM   1038  OD1 ASN   111      49.072   5.116  12.262  0.50 34.49           O  
ATOM   1040  ND2 ASN   111      49.124   2.894  11.894  0.50 34.01           N  
ATOM   1042  N   CYS   112      44.802   6.099   9.277  0.70 31.56           N  
ATOM   1043  CA  CYS   112      43.714   6.121   8.291  0.70 33.74           C  
ATOM   1044  C   CYS   112      44.025   6.946   7.039  0.70 35.48           C  
ATOM   1045  O   CYS   112      43.115   7.492   6.392  0.70 36.54           O  
ATOM   1046  CB  CYS   112      42.421   6.617   8.949  0.70 34.26           C  
ATOM   1047  SG  CYS   112      42.624   8.239   9.688  0.70 38.38           S  
ATOM   1048  N   SER   113      45.304   7.035   6.682  0.80 36.18           N  
ATOM   1049  CA  SER   113      45.657   7.515   5.355  0.80 37.26           C  
ATOM   1050  C   SER   113      45.138   6.506   4.323  0.80 37.37           C  
ATOM   1051  O   SER   113      45.038   5.311   4.592  0.80 38.31           O  
ATOM   1052  CB  SER   113      47.163   7.671   5.215  0.80 37.70           C  
ATOM   1053  OG  SER   113      47.763   6.406   5.045  0.80 40.92           O  
ATOM   1054  N   MET   114      44.784   7.001   3.147  1.00 36.61           N  
ATOM   1055  CA  MET   114      44.471   6.162   2.011  1.00 33.90           C  
ATOM   1056  C   MET   114      45.735   5.618   1.356  1.00 32.87           C  
ATOM   1057  O   MET   114      45.671   4.991   0.303  1.00 33.52           O  
ATOM   1058  CB  MET   114      43.673   6.968   0.992  1.00 34.29           C  
ATOM   1059  CG  MET   114      42.287   7.333   1.490  1.00 32.36           C  
ATOM   1060  SD  MET   114      41.175   5.772   1.643  0.55 31.57          SE  
ATOM   1061  CE  MET   114      41.516   4.865  -0.033  1.00 33.03           C  
ATOM   1062  N   ASP   115      46.893   5.872   1.969  1.00 30.98           N  
ATOM   1063  CA  ASP   115      48.127   5.247   1.531  1.00 29.39           C  
ATOM   1064  C   ASP   115      48.030   3.732   1.565  1.00 27.19           C  
ATOM   1065  O   ASP   115      48.696   3.061   0.786  1.00 28.38           O  
ATOM   1066  CB  ASP   115      49.284   5.647   2.457  1.00 31.04           C  
ATOM   1067  CG  ASP   115      49.683   7.106   2.301  1.00 36.35           C  
ATOM   1068  OD1 ASP   115      49.629   7.607   1.145  1.00 42.16           O  
ATOM   1069  OD2 ASP   115      50.065   7.734   3.328  1.00 40.44           O  
ATOM   1070  N   ASN   116      47.228   3.197   2.488  0.50 25.45           N  
ATOM   1072  CA  ASN   116      47.176   1.750   2.681  0.50 24.21           C  
ATOM   1074  C   ASN   116      45.799   1.164   2.389  0.50 22.98           C  
ATOM   1076  O   ASN   116      45.516   0.045   2.797  0.50 22.33           O  
ATOM   1078  CB  ASN   116      47.592   1.358   4.104  0.50 25.01           C  
ATOM   1080  CG  ASN   116      48.980   1.834   4.465  0.50 26.25           C  
ATOM   1082  OD1 ASN   116      49.848   1.970   3.602  0.50 30.22           O  
ATOM   1084  ND2 ASN   116      49.197   2.086   5.746  0.50 29.34           N  
ATOM   1086  N   SER   117      44.963   1.933   1.689  1.00 21.10           N  
ATOM   1087  CA  SER   117      43.626   1.481   1.305  1.00 20.32           C  
ATOM   1088  C   SER   117      43.373   1.845  -0.159  1.00 20.03           C  
ATOM   1089  O   SER   117      44.116   2.635  -0.762  1.00 21.17           O  
ATOM   1090  CB  SER   117      42.552   2.095   2.202  1.00 20.76           C  
ATOM   1091  OG  SER   117      42.802   1.844   3.590  1.00 22.22           O  
ATOM   1092  N   ASP   118      42.327   1.281  -0.746  1.00 18.98           N  
ATOM   1093  CA  ASP   118      41.985   1.582  -2.128  1.00 18.98           C  
ATOM   1094  C   ASP   118      40.481   1.476  -2.334  1.00 17.82           C  
ATOM   1095  O   ASP   118      39.797   0.823  -1.529  1.00 18.84           O  
ATOM   1096  CB  ASP   118      42.653   0.597  -3.081  1.00 18.47           C  
ATOM   1097  CG  ASP   118      44.134   0.915  -3.329  1.00 23.99           C  
ATOM   1098  OD1 ASP   118      44.418   1.937  -4.000  1.00 25.51           O  
ATOM   1099  OD2 ASP   118      44.999   0.142  -2.847  1.00 24.80           O  
ATOM   1100  N   PHE   119      39.976   2.113  -3.390  1.00 16.98           N  
ATOM   1101  CA  PHE   119      38.613   1.890  -3.870  1.00 17.39           C  
ATOM   1102  C   PHE   119      38.675   1.277  -5.266  1.00 17.52           C  
ATOM   1103  O   PHE   119      39.670   1.445  -5.981  1.00 17.46           O  
ATOM   1104  CB  PHE   119      37.807   3.196  -3.976  1.00 18.11           C  
ATOM   1105  CG  PHE   119      37.442   3.782  -2.642  1.00 17.20           C  
ATOM   1106  CD1 PHE   119      36.241   3.464  -2.011  1.00 17.33           C  
ATOM   1107  CD2 PHE   119      38.331   4.662  -2.005  1.00 19.04           C  
ATOM   1108  CE1 PHE   119      35.939   4.024  -0.751  1.00 20.51           C  
ATOM   1109  CE2 PHE   119      38.034   5.201  -0.745  1.00 20.22           C  
ATOM   1110  CZ  PHE   119      36.845   4.895  -0.135  1.00 20.12           C  
ATOM   1111  N   CYS   120      37.628   0.572  -5.670  1.00 17.45           N  
ATOM   1112  CA  CYS   120      37.555   0.047  -7.026  1.00 17.73           C  
ATOM   1113  C   CYS   120      36.106   0.087  -7.475  1.00 18.47           C  
ATOM   1114  O   CYS   120      35.201  -0.272  -6.689  1.00 17.83           O  
ATOM   1115  CB  CYS   120      38.089  -1.401  -7.045  1.00 18.30           C  
ATOM   1116  SG  CYS   120      38.102  -2.100  -8.702  0.85 21.04           S  
ATOM   1117  N   ASP   121      35.859   0.534  -8.706  1.00 18.02           N  
ATOM   1118  CA  ASP   121      34.503   0.578  -9.212  1.00 18.36           C  
ATOM   1119  C   ASP   121      33.919  -0.819  -9.406  1.00 19.09           C  
ATOM   1120  O   ASP   121      34.624  -1.758  -9.800  1.00 20.85           O  
ATOM   1121  CB  ASP   121      34.500   1.247 -10.587  1.00 18.48           C  
ATOM   1122  CG  ASP   121      34.724   2.753 -10.529  1.00 22.48           C  
ATOM   1123  OD1 ASP   121      34.777   3.377  -9.432  1.00 23.19           O  
ATOM   1124  OD2 ASP   121      34.794   3.308 -11.654  1.00 24.90           O  
ATOM   1125  N   LEU   122      32.619  -0.916  -9.181  1.00 18.88           N  
ATOM   1126  CA  LEU   122      31.864  -2.076  -9.555  1.00 19.10           C  
ATOM   1127  C   LEU   122      31.440  -1.902 -11.008  1.00 20.26           C  
ATOM   1128  O   LEU   122      31.216  -0.778 -11.467  1.00 21.26           O  
ATOM   1129  CB  LEU   122      30.615  -2.141  -8.682  1.00 19.71           C  
ATOM   1130  CG  LEU   122      30.854  -2.431  -7.195  1.00 18.36           C  
ATOM   1131  CD1 LEU   122      29.620  -2.013  -6.392  1.00 20.58           C  
ATOM   1132  CD2 LEU   122      31.061  -3.930  -7.010  1.00 21.72           C  
ATOM   1133  N   SER   123      31.288  -3.024 -11.710  1.00 20.30           N  
ATOM   1134  CA  SER   123      30.757  -2.964 -13.084  1.00 21.25           C  
ATOM   1135  C   SER   123      29.244  -2.686 -13.056  1.00 21.59           C  
ATOM   1136  O   SER   123      28.599  -2.828 -11.995  1.00 20.17           O  
ATOM   1137  CB  SER   123      30.982  -4.316 -13.769  1.00 21.57           C  
ATOM   1138  OG  SER   123      30.121  -5.293 -13.208  1.00 21.76           O  
ATOM   1139  N   LYS   124      28.651  -2.482 -14.240  0.50 21.41           N  
ATOM   1141  CA  LYS   124      27.189  -2.349 -14.367  0.50 22.09           C  
ATOM   1143  C   LYS   124      26.407  -3.585 -13.913  0.50 20.42           C  
ATOM   1145  O   LYS   124      25.404  -3.454 -13.193  0.50 19.79           O  
ATOM   1147  CB  LYS   124      26.775  -1.962 -15.804  0.50 22.57           C  
ATOM   1149  CG  LYS   124      25.663  -0.888 -15.824  0.50 25.93           C  
ATOM   1151  CD  LYS   124      25.184  -0.523 -17.241  0.50 25.36           C  
ATOM   1153  CE  LYS   124      26.129   0.427 -17.981  0.50 30.01           C  
ATOM   1155  NZ  LYS   124      25.505   0.962 -19.259  0.50 30.02           N  
ATOM   1157  N   GLU   125      26.825  -4.780 -14.331  0.60 19.59           N  
ATOM   1159  CA  GLU   125      26.131  -5.996 -13.881  0.60 19.69           C  
ATOM   1161  C   GLU   125      26.302  -6.092 -12.373  0.60 18.94           C  
ATOM   1163  O   GLU   125      25.366  -6.501 -11.678  0.60 18.66           O  
ATOM   1165  CB  GLU   125      26.661  -7.290 -14.526  0.60 19.99           C  
ATOM   1167  CG  GLU   125      26.151  -8.577 -13.844  0.60 20.98           C  
ATOM   1169  CD  GLU   125      26.607  -9.843 -14.539  0.60 21.63           C  
ATOM   1171  OE1 GLU   125      26.261 -10.005 -15.714  0.60 19.71           O  
ATOM   1173  OE2 GLU   125      27.260 -10.698 -13.888  0.60 27.62           O  
ATOM   1175  N   GLU   126      27.489  -5.753 -11.848  1.00 19.08           N  
ATOM   1176  CA  GLU   126      27.648  -5.938 -10.406  1.00 18.73           C  
ATOM   1177  C   GLU   126      26.741  -5.028  -9.609  1.00 18.15           C  
ATOM   1178  O   GLU   126      26.161  -5.438  -8.607  1.00 17.99           O  
ATOM   1179  CB  GLU   126      29.117  -5.727 -10.000  1.00 18.57           C  
ATOM   1180  CG  GLU   126      29.971  -6.889 -10.484  1.00 18.38           C  
ATOM   1181  CD  GLU   126      31.451  -6.622 -10.553  1.00 23.86           C  
ATOM   1182  OE1 GLU   126      31.903  -5.448 -10.410  1.00 22.43           O  
ATOM   1183  OE2 GLU   126      32.148  -7.648 -10.769  1.00 26.13           O  
ATOM   1184  N   ILE   127      26.640  -3.766 -10.046  1.00 17.91           N  
ATOM   1185  CA  ILE   127      25.729  -2.831  -9.371  1.00 17.65           C  
ATOM   1186  C   ILE   127      24.278  -3.349  -9.459  1.00 17.13           C  
ATOM   1187  O   ILE   127      23.605  -3.412  -8.428  1.00 17.30           O  
ATOM   1188  CB  ILE   127      25.860  -1.432  -9.962  1.00 18.60           C  
ATOM   1189  CG1 ILE   127      27.226  -0.907  -9.564  1.00 18.46           C  
ATOM   1190  CG2 ILE   127      24.801  -0.512  -9.437  1.00 19.31           C  
ATOM   1191  CD1 ILE   127      27.652   0.347 -10.378  1.00 20.44           C  
ATOM   1192  N   GLU   128      23.824  -3.758 -10.663  1.00 18.39           N  
ATOM   1193  CA  GLU   128      22.454  -4.230 -10.797  1.00 20.00           C  
ATOM   1194  C   GLU   128      22.223  -5.470  -9.953  1.00 18.15           C  
ATOM   1195  O   GLU   128      21.169  -5.629  -9.342  1.00 18.91           O  
ATOM   1196  CB  GLU   128      22.138  -4.598 -12.257  1.00 20.94           C  
ATOM   1197  CG  GLU   128      22.052  -3.429 -13.162  1.00 23.65           C  
ATOM   1198  CD  GLU   128      21.814  -3.828 -14.628  1.00 25.57           C  
ATOM   1199  OE1 GLU   128      21.660  -5.043 -14.953  1.00 30.78           O  
ATOM   1200  OE2 GLU   128      21.811  -2.893 -15.466  1.00 32.76           O  
ATOM   1201  N   TYR   129      23.200  -6.376  -9.937  1.00 17.26           N  
ATOM   1202  CA  TYR   129      23.116  -7.601  -9.141  1.00 17.84           C  
ATOM   1203  C   TYR   129      22.970  -7.266  -7.649  1.00 18.04           C  
ATOM   1204  O   TYR   129      22.105  -7.813  -6.920  1.00 18.35           O  
ATOM   1205  CB  TYR   129      24.391  -8.393  -9.363  1.00 18.21           C  
ATOM   1206  CG  TYR   129      24.534  -9.595  -8.483  1.00 18.38           C  
ATOM   1207  CD1 TYR   129      23.709 -10.725  -8.630  1.00 18.41           C  
ATOM   1208  CD2 TYR   129      25.523  -9.622  -7.498  1.00 20.53           C  
ATOM   1209  CE1 TYR   129      23.864 -11.827  -7.804  1.00 17.58           C  
ATOM   1210  CE2 TYR   129      25.680 -10.727  -6.675  1.00 19.51           C  
ATOM   1211  CZ  TYR   129      24.855 -11.837  -6.813  1.00 18.04           C  
ATOM   1212  OH  TYR   129      25.046 -12.968  -6.031  1.00 20.25           O  
ATOM   1213  N   ILE   130      23.838  -6.374  -7.162  1.00 16.52           N  
ATOM   1214  CA  ILE   130      23.709  -5.978  -5.770  1.00 17.09           C  
ATOM   1215  C   ILE   130      22.356  -5.330  -5.503  1.00 16.91           C  
ATOM   1216  O   ILE   130      21.727  -5.628  -4.479  1.00 18.49           O  
ATOM   1217  CB  ILE   130      24.863  -5.005  -5.382  1.00 17.07           C  
ATOM   1218  CG1 ILE   130      26.193  -5.809  -5.366  1.00 17.50           C  
ATOM   1219  CG2 ILE   130      24.540  -4.313  -4.062  1.00 18.07           C  
ATOM   1220  CD1 ILE   130      27.479  -4.888  -5.348  1.00 19.29           C  
ATOM   1221  N   GLN   131      21.902  -4.417  -6.379  1.00 16.81           N  
ATOM   1222  CA  GLN   131      20.627  -3.733  -6.147  1.00 16.26           C  
ATOM   1223  C   GLN   131      19.446  -4.743  -6.100  1.00 16.96           C  
ATOM   1224  O   GLN   131      18.583  -4.655  -5.232  1.00 17.72           O  
ATOM   1225  CB  GLN   131      20.379  -2.693  -7.226  1.00 17.36           C  
ATOM   1226  CG  GLN   131      21.329  -1.508  -7.062  1.00 17.32           C  
ATOM   1227  CD  GLN   131      21.262  -0.489  -8.196  1.00 18.14           C  
ATOM   1228  OE1 GLN   131      20.970  -0.828  -9.350  1.00 21.38           O  
ATOM   1229  NE2 GLN   131      21.621   0.769  -7.879  1.00 20.80           N  
ATOM   1230  N   THR   132      19.419  -5.674  -7.054  1.00 16.48           N  
ATOM   1231  CA  THR   132      18.346  -6.671  -7.094  1.00 16.57           C  
ATOM   1232  C   THR   132      18.269  -7.419  -5.769  1.00 17.80           C  
ATOM   1233  O   THR   132      17.198  -7.577  -5.188  1.00 18.56           O  
ATOM   1234  CB  THR   132      18.604  -7.637  -8.232  1.00 18.12           C  
ATOM   1235  OG1 THR   132      18.408  -6.933  -9.460  1.00 18.40           O  
ATOM   1236  CG2 THR   132      17.597  -8.815  -8.160  1.00 17.65           C  
ATOM   1237  N   ASN   133      19.409  -7.901  -5.303  1.00 17.31           N  
ATOM   1238  CA  ASN   133      19.415  -8.773  -4.108  1.00 17.08           C  
ATOM   1239  C   ASN   133      19.311  -7.976  -2.822  1.00 17.38           C  
ATOM   1240  O   ASN   133      18.656  -8.409  -1.867  1.00 18.85           O  
ATOM   1241  CB  ASN   133      20.651  -9.693  -4.135  1.00 17.47           C  
ATOM   1242  CG  ASN   133      20.577 -10.696  -5.293  1.00 20.14           C  
ATOM   1243  OD1 ASN   133      21.201 -10.534  -6.357  1.00 20.33           O  
ATOM   1244  ND2 ASN   133      19.772 -11.703  -5.112  1.00 16.52           N  
ATOM   1245  N   ALA   134      19.907  -6.785  -2.801  1.00 17.14           N  
ATOM   1246  CA  ALA   134      19.819  -5.949  -1.597  1.00 17.67           C  
ATOM   1247  C   ALA   134      18.425  -5.402  -1.350  1.00 17.75           C  
ATOM   1248  O   ALA   134      18.010  -5.294  -0.191  1.00 18.61           O  
ATOM   1249  CB  ALA   134      20.833  -4.785  -1.649  1.00 18.35           C  
ATOM   1250  N   ARG   135      17.690  -5.062  -2.413  0.50 17.68           N  
ATOM   1252  CA  ARG   135      16.292  -4.640  -2.250  0.50 18.19           C  
ATOM   1254  C   ARG   135      15.572  -5.671  -1.405  0.50 17.60           C  
ATOM   1256  O   ARG   135      14.915  -5.319  -0.421  0.50 17.24           O  
ATOM   1258  CB  ARG   135      15.558  -4.482  -3.598  0.50 18.84           C  
ATOM   1260  CG  ARG   135      15.634  -3.088  -4.185  0.50 20.89           C  
ATOM   1262  CD  ARG   135      14.767  -2.913  -5.452  0.50 19.82           C  
ATOM   1264  NE  ARG   135      15.253  -3.691  -6.597  0.50 21.02           N  
ATOM   1266  CZ  ARG   135      16.118  -3.257  -7.510  0.50 20.55           C  
ATOM   1268  NH1 ARG   135      16.660  -2.051  -7.414  0.50 19.77           N  
ATOM   1270  NH2 ARG   135      16.470  -4.039  -8.515  0.50 20.94           N  
ATOM   1272  N   LYS   136      15.739  -6.941  -1.769  1.00 17.30           N  
ATOM   1273  CA  LYS   136      15.013  -8.042  -1.104  1.00 16.20           C  
ATOM   1274  C   LYS   136      15.561  -8.221   0.317  1.00 16.60           C  
ATOM   1275  O   LYS   136      14.805  -8.320   1.280  1.00 16.64           O  
ATOM   1276  CB  LYS   136      15.162  -9.303  -1.914  1.00 17.03           C  
ATOM   1277  CG  LYS   136      14.430  -9.172  -3.243  1.00 20.14           C  
ATOM   1278  CD  LYS   136      14.770 -10.338  -4.113  1.00 23.30           C  
ATOM   1279  CE  LYS   136      14.162 -10.175  -5.516  1.00 25.56           C  
ATOM   1280  NZ  LYS   136      12.720 -10.573  -5.377  1.00 29.92           N  
ATOM   1281  N   LEU   137      16.893  -8.204   0.420  1.00 16.81           N  
ATOM   1282  CA  LEU   137      17.533  -8.532   1.692  1.00 16.98           C  
ATOM   1283  C   LEU   137      17.144  -7.528   2.759  1.00 17.23           C  
ATOM   1284  O   LEU   137      16.991  -7.903   3.926  1.00 17.59           O  
ATOM   1285  CB  LEU   137      19.054  -8.638   1.497  1.00 17.81           C  
ATOM   1286  CG  LEU   137      19.910  -9.022   2.716  1.00 18.22           C  
ATOM   1287  CD1 LEU   137      19.354 -10.327   3.309  1.00 18.14           C  
ATOM   1288  CD2 LEU   137      21.383  -9.126   2.302  1.00 17.26           C  
ATOM   1289  N   PHE   138      16.984  -6.245   2.373  1.00 17.07           N  
ATOM   1290  CA  PHE   138      16.586  -5.233   3.356  1.00 18.73           C  
ATOM   1291  C   PHE   138      15.282  -5.558   4.070  1.00 19.99           C  
ATOM   1292  O   PHE   138      15.090  -5.139   5.217  1.00 21.34           O  
ATOM   1293  CB  PHE   138      16.442  -3.844   2.687  1.00 18.10           C  
ATOM   1294  CG  PHE   138      17.686  -3.006   2.719  1.00 17.50           C  
ATOM   1295  CD1 PHE   138      18.139  -2.388   1.555  1.00 16.88           C  
ATOM   1296  CD2 PHE   138      18.396  -2.812   3.903  1.00 17.33           C  
ATOM   1297  CE1 PHE   138      19.283  -1.541   1.583  1.00 18.86           C  
ATOM   1298  CE2 PHE   138      19.527  -1.973   3.909  1.00 19.25           C  
ATOM   1299  CZ  PHE   138      19.952  -1.367   2.760  1.00 17.67           C  
ATOM   1300  N   GLU   139      14.439  -6.386   3.444  1.00 18.92           N  
ATOM   1301  CA  GLU   139      13.138  -6.676   3.996  1.00 19.71           C  
ATOM   1302  C   GLU   139      13.066  -8.043   4.661  1.00 17.95           C  
ATOM   1303  O   GLU   139      12.014  -8.404   5.137  1.00 18.66           O  
ATOM   1304  CB  GLU   139      12.101  -6.581   2.895  1.00 19.85           C  
ATOM   1305  CG  GLU   139      12.117  -5.275   2.063  1.00 23.35           C  
ATOM   1306  CD  GLU   139      12.058  -4.002   2.912  1.00 30.03           C  
ATOM   1307  OE1 GLU   139      11.489  -3.989   4.046  1.00 30.29           O  
ATOM   1308  OE2 GLU   139      12.582  -2.966   2.407  1.00 33.04           O  
ATOM   1309  N   LYS   140      14.176  -8.786   4.703  1.00 17.80           N  
ATOM   1310  CA  LYS   140      14.103 -10.176   5.243  1.00 19.28           C  
ATOM   1311  C   LYS   140      14.286 -10.219   6.749  1.00 21.74           C  
ATOM   1312  O   LYS   140      14.695  -9.206   7.393  1.00 21.57           O  
ATOM   1313  CB  LYS   140      15.170 -11.064   4.589  1.00 18.37           C  
ATOM   1314  CG  LYS   140      14.909 -11.354   3.112  1.00 18.79           C  
ATOM   1315  CD  LYS   140      16.003 -12.193   2.490  1.00 19.32           C  
ATOM   1316  CE  LYS   140      15.652 -12.412   0.999  1.00 21.12           C  
ATOM   1317  NZ  LYS   140      16.766 -13.100   0.285  1.00 22.33           N  
ATOM   1318  OXT LYS   140      14.000 -11.276   7.370  1.00 23.13           O  
END
