
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  181 ( 1415),  selected  181 , name 1ysq_A
# Molecule2: number of CA atoms  176 ( 1390),  selected  176 , name T0412.pdb
# PARAMETERS: 1ysq_A.T0412.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     5_A      S       1           -
LGA    L     6_A      N       2           -
LGA    N     7_A      A       3          3.209
LGA    I     8_A      L       4           #
LGA    -       -      F       5           -
LGA    -       -      S       6           -
LGA    I     9_A      S       7          3.417
LGA    H    10_A      R       8          2.907
LGA    I    11_A      D       9          3.096
LGA    A    12_A      I      10          1.337
LGA    A    13_A      L      11          1.161
LGA    P    14_A      E      12          1.426
LGA    H    15_A      V      13          1.308
LGA    L    16_A      L      14          0.790
LGA    E    17_A      Q      15          0.904
LGA    A    18_A      D      16          1.219
LGA    L    19_A      I      17          0.959
LGA    N    20_A      H      18          0.240
LGA    I    21_A      M      19          0.343
LGA    A    22_A      E      20          0.766
LGA    T    23_A      T      21          0.890
LGA    G    24_A      G      22          1.239
LGA    E    25_A      E      23          0.935
LGA    T    26_A      T      24          0.863
LGA    I    27_A      V      25          0.513
LGA    N    28_A      A      26          1.067
LGA    F    29_A      I      27          0.968
LGA    S    30_A      A      28          0.843
LGA    S    31_A      T      29          1.879
LGA    R    32_A      K      30          1.947
LGA    E    33_A      N      31          1.887
LGA    D    34_A      D      32          2.264
LGA    D    35_A      I      33          1.183
LGA    H    36_A      Y      34          1.388
LGA    A    37_A      L      35          1.755
LGA    I    38_A      Q      36          0.737
LGA    L    39_A      Y      37          0.795
LGA    I    40_A      I      38          1.385
LGA    Y    41_A      Q      39          0.570
LGA    K    42_A      I      40          0.608
LGA    L    43_A      I      41          0.752
LGA    E    44_A      E      42          1.040
LGA    P    45_A      S      43          1.286
LGA    T    46_A      V      44          2.682
LGA    T    47_A      -       -           -
LGA    G    48_A      H      45          3.002
LGA    M    49_A      A      46          3.305
LGA    L    50_A      L      47          3.205
LGA    R    51_A      R      48          1.776
LGA    T    52_A      F      49          1.352
LGA    R    53_A      H      50          2.734
LGA    A    54_A      V      51          0.894
LGA    Y    55_A      D      52          4.104
LGA    I    56_A      E      53          5.051
LGA    G    57_A      N      54           #
LGA    Q    58_A      A      55          5.200
LGA    H    59_A      I      56          4.334
LGA    M    60_A      R      57          2.912
LGA    P    61_A      P      58          1.371
LGA    L    62_A      L      59          0.452
LGA    Y    63_A      T      60          0.320
LGA    C    64_A      M      61          0.614
LGA    S    65_A      S      62          1.747
LGA    A    66_A      S      63          1.296
LGA    M    67_A      N      64          1.258
LGA    G    68_A      G      65          1.333
LGA    K    69_A      W      66          0.765
LGA    I    70_A      M      67          0.634
LGA    Y    71_A      L      68          1.068
LGA    M    72_A      M      69          0.826
LGA    A    73_A      S      70          1.147
LGA    F    74_A      T      71          1.993
LGA    G    75_A      M      72          1.361
LGA    H    76_A      N      73          0.775
LGA    P    77_A      D      74          1.260
LGA    D    78_A      K      75          1.192
LGA    Y    79_A      A      76          1.156
LGA    V    80_A      I      77          1.698
LGA    K    81_A      D      78          1.218
LGA    S    82_A      N      79          1.401
LGA    Y    83_A      T      80          1.765
LGA    W    84_A      V      81          2.795
LGA    E    85_A      R      82          2.922
LGA    S    86_A      R      83          2.778
LGA    H    87_A      A      84          3.133
LGA    Q    88_A      N      85          3.209
LGA    H    89_A      T      86          1.894
LGA    E    90_A      I      87          0.986
LGA    I    91_A      T      88          2.801
LGA    Q    92_A      Q      89          3.339
LGA    P    93_A      K      90           -
LGA    -       -      D      91           -
LGA    L    94_A      G      92           #
LGA    T    95_A      I      93           #
LGA    R    96_A      -       -           -
LGA    N    97_A      -       -           -
LGA    T    98_A      -       -           -
LGA    I    99_A      R      94           #
LGA    T   100_A      F      95          1.408
LGA    E   101_A      E      96          1.370
LGA    L   102_A      V      97          1.098
LGA    P   103_A      D      98          1.090
LGA    A   104_A      D      99          1.183
LGA    M   105_A      M     100          0.415
LGA    F   106_A      M     101          1.301
LGA    D   107_A      A     102          1.488
LGA    E   108_A      R     103          0.643
LGA    L   109_A      I     104          0.676
LGA    A   110_A      R     105          1.360
LGA    H   111_A      Q     106          1.127
LGA    I   112_A      V     107          0.347
LGA    R   113_A      R     108          0.505
LGA    E   114_A      E     109          0.376
LGA    S   115_A      Q     110          0.900
LGA    G   116_A      G     111          0.998
LGA    A   117_A      Y     112          0.402
LGA    A   118_A      A     113          0.580
LGA    M   119_A      S     114          1.100
LGA    D   120_A      A     115          2.279
LGA    R   121_A      E     116          1.746
LGA    E   122_A      H     117          0.925
LGA    E   123_A      I     118          1.552
LGA    N   124_A      P     119          1.173
LGA    E   125_A      F     120          1.297
LGA    L   126_A      V     121          1.163
LGA    G   127_A      G     122          0.669
LGA    V   128_A      G     123          0.346
LGA    S   129_A      G     124          0.779
LGA    C   130_A      T     125          0.241
LGA    I   131_A      I     126          0.070
LGA    A   132_A      C     127          0.602
LGA    V   133_A      V     128          0.353
LGA    P   134_A      L     129          0.304
LGA    V   135_A      L     130          0.769
LGA    F   136_A      P     131          2.083
LGA    D   137_A      M     132          2.477
LGA    I   138_A      -       -           -
LGA    H   139_A      -       -           -
LGA    G   140_A      -       -           -
LGA    R   141_A      -       -           -
LGA    V   142_A      T     133          5.372
LGA    P   143_A      I     134          4.793
LGA    -       -      Q     135           -
LGA    -       -      G     136           -
LGA    -       -      Q     137           -
LGA    -       -      P     138           -
LGA    Y   144_A      V     139          0.839
LGA    A   145_A      T     140          0.386
LGA    V   146_A      M     141          0.602
LGA    S   147_A      G     142          0.610
LGA    I   148_A      L     143          0.534
LGA    S   149_A      G     144          0.322
LGA    L   150_A      G     145          1.425
LGA    S   151_A      A     146          1.110
LGA    T   152_A      L     147          0.986
LGA    S   153_A      D     148          1.124
LGA    R   154_A      R     149          1.253
LGA    L   155_A      I     150          1.789
LGA    K   156_A      K     151          2.077
LGA    Q   157_A      Q     152          1.806
LGA    V   158_A      N     153          1.957
LGA    G   159_A      Y     154          2.420
LGA    E   160_A      -       -           -
LGA    K   161_A      D     155          2.415
LGA    N   162_A      R     156          2.064
LGA    L   163_A      Y     157          0.947
LGA    L   164_A      L     158          0.550
LGA    K   165_A      E     159          0.718
LGA    P   166_A      L     160          0.691
LGA    L   167_A      L     161          1.098
LGA    R   168_A      L     162          1.558
LGA    E   169_A      N     163          1.576
LGA    T   170_A      G     164          1.677
LGA    A   171_A      V     165          2.937
LGA    Q   172_A      Q     166          3.138
LGA    A   173_A      Q     167          2.395
LGA    I   174_A      L     168          3.328
LGA    S   175_A      K     169          4.405
LGA    N   176_A      K     170          2.711
LGA    E   177_A      S     171          1.506
LGA    L   178_A      D     172          2.370
LGA    G   179_A      S     173          5.211
LGA    F   180_A      -       -           -
LGA    T   181_A      F     174           #
LGA    A   188_A      H     175           -
LGA    I   189_A      Q     176           -
LGA    T   190_A      -       -           -
LGA    G   191_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  181  176    5.0    158    1.93    19.62     71.781     7.798

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.361936 * X  +  -0.681015 * Y  +  -0.636569 * Z  +  34.985367
  Y_new =  -0.750590 * X  +  -0.617859 * Y  +   0.234233 * Z  +  78.533813
  Z_new =  -0.552826 * X  +   0.393025 * Y  +  -0.734789 * Z  +  93.287323 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.650430   -0.491162  [ DEG:   151.8585    -28.1415 ]
  Theta =   0.585752    2.555840  [ DEG:    33.5611    146.4389 ]
  Phi   =  -1.121488    2.020105  [ DEG:   -64.2565    115.7435 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ysq_A                                        
REMARK     2: T0412.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ysq_A.T0412.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  181  176   5.0  158   1.93   19.62  71.781
REMARK  ---------------------------------------------------------- 
MOLECULE 1ysq_A
HEADER    GENE REGULATION                         08-FEB-05   1YSQ              
TITLE     THE CRYSTAL STRUCTURE OF TRANSCRIPTIONAL REGULATOR YAIJ               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HTH-TYPE TRANSCRIPTIONAL REGULATOR YIAJ;                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YIAJ;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    TRANSCRIPTIONAL REGULATOR, YAIJ, ICLR, STRUCTURAL GENOMICS,           
KEYWDS   2 PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, MCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.BOCHKAREV,V.V.LUNIN,A.EZERSKY,E.EVDOKIMOVA,T.SKARINA,X.XU,          
AUTHOR   2 D.BOREK,A.M.EDWARDS,A.SAVCHENKO,MIDWEST CENTER FOR                   
AUTHOR   3 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   2   14-AUG-07 1YSQ    1       AUTHOR                                   
REVDAT   1   22-MAR-05 1YSQ    0                                                
JRNL        AUTH   A.BOCHKAREV,V.V.LUNIN,A.EZERSKY,E.EVDOKIMOVA,                
JRNL        AUTH 2 T.SKARINA,X.XU,D.BOREK,A.M.EDWARDS,A.SAVCHENKO               
JRNL        TITL   STRUCTURAL STUDY OF EFFECTOR BINDING SPECIFICITY             
JRNL        TITL 2 IN ICLR TRANSCRIPTIONAL REGULATORS                           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  1YSQ A    2   190  UNP    P37671   YIAJ_ECOLI      94    282             
SEQRES   1 A  193  GLY HIS MET ALA LEU SER SER LEU ASN ILE ILE HIS ILE          
SEQRES   2 A  193  ALA ALA PRO HIS LEU GLU ALA LEU ASN ILE ALA THR GLY          
SEQRES   3 A  193  GLU THR ILE ASN PHE SER SER ARG GLU ASP ASP HIS ALA          
SEQRES   4 A  193  ILE LEU ILE TYR LYS LEU GLU PRO THR THR GLY MET LEU          
SEQRES   5 A  193  ARG THR ARG ALA TYR ILE GLY GLN HIS MET PRO LEU TYR          
SEQRES   6 A  193  CYS SER ALA MET GLY LYS ILE TYR MET ALA PHE GLY HIS          
SEQRES   7 A  193  PRO ASP TYR VAL LYS SER TYR TRP GLU SER HIS GLN HIS          
SEQRES   8 A  193  GLU ILE GLN PRO LEU THR ARG ASN THR ILE THR GLU LEU          
SEQRES   9 A  193  PRO ALA MET PHE ASP GLU LEU ALA HIS ILE ARG GLU SER          
SEQRES  10 A  193  GLY ALA ALA MET ASP ARG GLU GLU ASN GLU LEU GLY VAL          
SEQRES  11 A  193  SER CYS ILE ALA VAL PRO VAL PHE ASP ILE HIS GLY ARG          
SEQRES  12 A  193  VAL PRO TYR ALA VAL SER ILE SER LEU SER THR SER ARG          
SEQRES  13 A  193  LEU LYS GLN VAL GLY GLU LYS ASN LEU LEU LYS PRO LEU          
SEQRES  14 A  193  ARG GLU THR ALA GLN ALA ILE SER ASN GLU LEU GLY PHE          
SEQRES  15 A  193  THR VAL ARG ASP ASP LEU GLY ALA ILE THR GLY                  
HET    PO4    301       5                                                       
HET    PO4    302       5                                                       
HET    PO4    303       5                                                       
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   2  PO4    3(O4 P 3-)                                                   
FORMUL   5  HOH   *122(H2 O)                                                    
CRYST1   65.510   65.510   88.940  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   SER A   5      19.380  28.017  81.608  1.00 45.42           N  
ATOM      2  CA  SER A   5      19.709  29.401  81.138  1.00 45.28           C  
ATOM      3  C   SER A   5      18.641  30.419  81.535  1.00 45.00           C  
ATOM      4  O   SER A   5      18.916  31.620  81.603  1.00 44.70           O  
ATOM      5  CB  SER A   5      19.906  29.421  79.626  1.00 45.22           C  
ATOM      6  OG  SER A   5      20.913  28.499  79.256  1.00 46.39           O  
ATOM      7  N   LEU A   6      17.431  29.925  81.789  1.00 44.70           N  
ATOM      8  CA  LEU A   6      16.297  30.758  82.201  1.00 44.04           C  
ATOM      9  C   LEU A   6      16.601  31.612  83.432  1.00 42.73           C  
ATOM     10  O   LEU A   6      16.413  32.838  83.409  1.00 42.37           O  
ATOM     11  CB  LEU A   6      15.063  29.886  82.471  1.00 44.67           C  
ATOM     12  CG  LEU A   6      14.509  29.039  81.324  1.00 46.46           C  
ATOM     13  CD1 LEU A   6      13.574  27.957  81.882  1.00 48.07           C  
ATOM     14  CD2 LEU A   6      13.801  29.906  80.271  1.00 47.99           C  
ATOM     15  N   ASN A   7      17.045  30.952  84.504  1.00 41.04           N  
ATOM     16  CA  ASN A   7      17.368  31.626  85.758  1.00 39.53           C  
ATOM     17  C   ASN A   7      18.456  32.683  85.581  1.00 37.33           C  
ATOM     18  O   ASN A   7      18.298  33.805  86.046  1.00 36.72           O  
ATOM     19  CB  ASN A   7      17.777  30.620  86.847  1.00 40.32           C  
ATOM     20  CG  ASN A   7      16.682  29.606  87.157  1.00 43.25           C  
ATOM     21  OD1 ASN A   7      15.511  29.790  86.786  1.00 46.20           O  
ATOM     22  ND2 ASN A   7      17.058  28.519  87.843  1.00 45.88           N  
ATOM     23  N   ILE A   8      19.549  32.327  84.904  1.00 34.74           N  
ATOM     24  CA  ILE A   8      20.625  33.295  84.678  1.00 32.77           C  
ATOM     25  C   ILE A   8      20.195  34.449  83.744  1.00 32.02           C  
ATOM     26  O   ILE A   8      20.564  35.602  83.973  1.00 31.50           O  
ATOM     27  CB  ILE A   8      21.969  32.618  84.234  1.00 32.44           C  
ATOM     28  CG1 ILE A   8      23.134  33.619  84.294  1.00 31.56           C  
ATOM     29  CG2 ILE A   8      21.862  31.996  82.825  1.00 32.36           C  
ATOM     30  CD1 ILE A   8      23.546  34.035  85.703  1.00 31.65           C  
ATOM     31  N   ILE A   9      19.400  34.156  82.724  1.00 31.23           N  
ATOM     32  CA  ILE A   9      18.931  35.240  81.848  1.00 31.03           C  
ATOM     33  C   ILE A   9      18.014  36.204  82.624  1.00 31.41           C  
ATOM     34  O   ILE A   9      18.117  37.427  82.476  1.00 30.88           O  
ATOM     35  CB  ILE A   9      18.316  34.694  80.535  1.00 31.37           C  
ATOM     36  CG1 ILE A   9      19.447  34.154  79.644  1.00 30.44           C  
ATOM     37  CG2 ILE A   9      17.587  35.802  79.770  1.00 30.02           C  
ATOM     38  CD1 ILE A   9      19.008  33.139  78.603  1.00 31.42           C  
ATOM     39  N   HIS A  10      17.178  35.652  83.509  1.00 31.50           N  
ATOM     40  CA  HIS A  10      16.340  36.483  84.379  1.00 32.00           C  
ATOM     41  C   HIS A  10      17.145  37.459  85.252  1.00 31.06           C  
ATOM     42  O   HIS A  10      16.797  38.638  85.367  1.00 30.89           O  
ATOM     43  CB  HIS A  10      15.400  35.635  85.252  1.00 32.70           C  
ATOM     44  CG  HIS A  10      14.360  36.454  85.951  1.00 36.80           C  
ATOM     45  ND1 HIS A  10      13.288  37.015  85.288  1.00 39.30           N  
ATOM     46  CD2 HIS A  10      14.262  36.862  87.241  1.00 40.33           C  
ATOM     47  CE1 HIS A  10      12.561  37.712  86.145  1.00 41.95           C  
ATOM     48  NE2 HIS A  10      13.129  37.634  87.337  1.00 41.07           N  
ATOM     49  N   ILE A  11      18.210  36.956  85.862  1.00 30.10           N  
ATOM     50  CA  ILE A  11      19.156  37.778  86.610  1.00 29.13           C  
ATOM     51  C   ILE A  11      19.863  38.788  85.700  1.00 28.06           C  
ATOM     52  O   ILE A  11      19.953  39.978  86.030  1.00 27.33           O  
ATOM     53  CB  ILE A  11      20.223  36.868  87.287  1.00 29.57           C  
ATOM     54  CG1 ILE A  11      19.586  35.985  88.365  1.00 31.04           C  
ATOM     55  CG2 ILE A  11      21.421  37.710  87.855  1.00 29.69           C  
ATOM     56  CD1 ILE A  11      20.599  35.145  89.146  1.00 30.73           C  
ATOM     57  N   ALA A  12      20.382  38.307  84.568  1.00 26.68           N  
ATOM     58  CA  ALA A  12      21.298  39.111  83.757  1.00 25.97           C  
ATOM     59  C   ALA A  12      20.635  40.155  82.855  1.00 25.51           C  
ATOM     60  O   ALA A  12      21.192  41.245  82.664  1.00 25.25           O  
ATOM     61  CB  ALA A  12      22.221  38.216  82.946  1.00 25.33           C  
ATOM     62  N   ALA A  13      19.456  39.832  82.310  1.00 25.09           N  
ATOM     63  CA  ALA A  13      18.831  40.659  81.263  1.00 24.65           C  
ATOM     64  C   ALA A  13      18.745  42.180  81.528  1.00 24.56           C  
ATOM     65  O   ALA A  13      19.103  42.948  80.651  1.00 24.25           O  
ATOM     66  CB  ALA A  13      17.455  40.090  80.837  1.00 24.64           C  
ATOM     67  N   PRO A  14      18.315  42.636  82.711  1.00 25.49           N  
ATOM     68  CA  PRO A  14      18.238  44.086  82.956  1.00 25.47           C  
ATOM     69  C   PRO A  14      19.608  44.752  82.823  1.00 25.33           C  
ATOM     70  O   PRO A  14      19.723  45.888  82.340  1.00 24.77           O  
ATOM     71  CB  PRO A  14      17.778  44.178  84.415  1.00 26.17           C  
ATOM     72  CG  PRO A  14      17.206  42.862  84.742  1.00 27.17           C  
ATOM     73  CD  PRO A  14      17.923  41.858  83.901  1.00 25.48           C  
ATOM     74  N   HIS A  15      20.640  44.031  83.272  1.00 24.74           N  
ATOM     75  CA  HIS A  15      22.007  44.527  83.256  1.00 24.06           C  
ATOM     76  C   HIS A  15      22.574  44.546  81.838  1.00 22.88           C  
ATOM     77  O   HIS A  15      23.248  45.499  81.455  1.00 22.37           O  
ATOM     78  CB  HIS A  15      22.895  43.667  84.163  1.00 24.07           C  
ATOM     79  CG  HIS A  15      22.469  43.675  85.593  1.00 25.77           C  
ATOM     80  ND1 HIS A  15      22.635  44.774  86.406  1.00 27.01           N  
ATOM     81  CD2 HIS A  15      21.856  42.733  86.349  1.00 28.36           C  
ATOM     82  CE1 HIS A  15      22.162  44.501  87.610  1.00 28.48           C  
ATOM     83  NE2 HIS A  15      21.681  43.269  87.601  1.00 28.35           N  
ATOM     84  N   LEU A  16      22.313  43.486  81.075  1.00 21.92           N  
ATOM     85  CA  LEU A  16      22.778  43.422  79.695  1.00 20.98           C  
ATOM     86  C   LEU A  16      22.074  44.478  78.839  1.00 20.77           C  
ATOM     87  O   LEU A  16      22.709  45.154  78.028  1.00 19.76           O  
ATOM     88  CB  LEU A  16      22.601  42.004  79.127  1.00 20.79           C  
ATOM     89  CG  LEU A  16      23.381  40.925  79.892  1.00 21.05           C  
ATOM     90  CD1 LEU A  16      22.898  39.536  79.506  1.00 20.52           C  
ATOM     91  CD2 LEU A  16      24.876  41.057  79.657  1.00 20.80           C  
ATOM     92  N   GLU A  17      20.762  44.640  79.034  1.00 20.27           N  
ATOM     93  CA  GLU A  17      20.027  45.704  78.331  1.00 20.56           C  
ATOM     94  C   GLU A  17      20.583  47.095  78.639  1.00 20.26           C  
ATOM     95  O   GLU A  17      20.762  47.925  77.748  1.00 21.01           O  
ATOM     96  CB  GLU A  17      18.543  45.664  78.712  1.00 20.80           C  
ATOM     97  CG  GLU A  17      17.781  44.513  78.080  1.00 22.68           C  
ATOM     98  CD  GLU A  17      16.298  44.561  78.418  1.00 25.68           C  
ATOM     99  OE1 GLU A  17      15.804  45.646  78.797  1.00 29.28           O  
ATOM    100  OE2 GLU A  17      15.637  43.524  78.306  1.00 26.01           O  
ATOM    101  N   ALA A  18      20.833  47.347  79.917  1.00 20.90           N  
ATOM    102  CA  ALA A  18      21.457  48.597  80.347  1.00 20.71           C  
ATOM    103  C   ALA A  18      22.768  48.851  79.615  1.00 20.75           C  
ATOM    104  O   ALA A  18      23.027  49.967  79.163  1.00 21.15           O  
ATOM    105  CB  ALA A  18      21.684  48.586  81.870  1.00 20.74           C  
ATOM    106  N   LEU A  19      23.610  47.829  79.510  1.00 20.59           N  
ATOM    107  CA  LEU A  19      24.913  48.001  78.856  1.00 20.47           C  
ATOM    108  C   LEU A  19      24.747  48.243  77.351  1.00 20.31           C  
ATOM    109  O   LEU A  19      25.479  49.039  76.753  1.00 19.81           O  
ATOM    110  CB  LEU A  19      25.810  46.795  79.128  1.00 20.75           C  
ATOM    111  CG  LEU A  19      27.198  46.741  78.474  1.00 20.78           C  
ATOM    112  CD1 LEU A  19      28.115  47.817  79.077  1.00 22.02           C  
ATOM    113  CD2 LEU A  19      27.782  45.337  78.662  1.00 21.00           C  
ATOM    114  N   ASN A  20      23.774  47.546  76.759  1.00 20.19           N  
ATOM    115  CA  ASN A  20      23.398  47.730  75.356  1.00 20.39           C  
ATOM    116  C   ASN A  20      23.008  49.195  75.096  1.00 20.11           C  
ATOM    117  O   ASN A  20      23.487  49.813  74.142  1.00 20.69           O  
ATOM    118  CB  ASN A  20      22.266  46.742  75.026  1.00 20.32           C  
ATOM    119  CG  ASN A  20      21.702  46.892  73.612  1.00 21.44           C  
ATOM    120  OD1 ASN A  20      20.492  47.033  73.456  1.00 21.91           O  
ATOM    121  ND2 ASN A  20      22.559  46.811  72.589  1.00 19.47           N  
ATOM    122  N   ILE A  21      22.151  49.747  75.948  1.00 21.00           N  
ATOM    123  CA  ILE A  21      21.753  51.158  75.826  1.00 21.94           C  
ATOM    124  C   ILE A  21      22.923  52.113  76.047  1.00 22.00           C  
ATOM    125  O   ILE A  21      23.098  53.075  75.292  1.00 22.21           O  
ATOM    126  CB  ILE A  21      20.565  51.494  76.790  1.00 22.55           C  
ATOM    127  CG1 ILE A  21      19.328  50.626  76.484  1.00 22.65           C  
ATOM    128  CG2 ILE A  21      20.226  53.014  76.777  1.00 22.41           C  
ATOM    129  CD1 ILE A  21      18.826  50.687  75.042  1.00 25.01           C  
ATOM    130  N   ALA A  22      23.734  51.839  77.067  1.00 22.52           N  
ATOM    131  CA  ALA A  22      24.847  52.733  77.417  1.00 22.72           C  
ATOM    132  C   ALA A  22      25.909  52.813  76.321  1.00 22.81           C  
ATOM    133  O   ALA A  22      26.370  53.906  75.989  1.00 22.97           O  
ATOM    134  CB  ALA A  22      25.472  52.301  78.739  1.00 23.47           C  
ATOM    135  N   THR A  23      26.281  51.669  75.741  1.00 21.53           N  
ATOM    136  CA  THR A  23      27.316  51.639  74.705  1.00 20.67           C  
ATOM    137  C   THR A  23      26.793  51.778  73.272  1.00 21.07           C  
ATOM    138  O   THR A  23      27.558  52.134  72.369  1.00 21.06           O  
ATOM    139  CB  THR A  23      28.133  50.333  74.779  1.00 20.30           C  
ATOM    140  OG1 THR A  23      27.270  49.211  74.471  1.00 18.67           O  
ATOM    141  CG2 THR A  23      28.653  50.096  76.215  1.00 19.91           C  
ATOM    142  N   GLY A  24      25.530  51.419  73.049  1.00 20.94           N  
ATOM    143  CA  GLY A  24      24.989  51.372  71.691  1.00 19.89           C  
ATOM    144  C   GLY A  24      25.376  50.129  70.884  1.00 20.04           C  
ATOM    145  O   GLY A  24      24.973  49.971  69.730  1.00 19.70           O  
ATOM    146  N   GLU A  25      26.168  49.244  71.485  1.00 19.78           N  
ATOM    147  CA  GLU A  25      26.793  48.125  70.769  1.00 19.82           C  
ATOM    148  C   GLU A  25      26.129  46.779  71.039  1.00 18.95           C  
ATOM    149  O   GLU A  25      25.380  46.629  72.001  1.00 19.65           O  
ATOM    150  CB  GLU A  25      28.275  48.002  71.183  1.00 19.71           C  
ATOM    151  CG  GLU A  25      29.139  49.246  70.958  1.00 21.27           C  
ATOM    152  CD  GLU A  25      29.306  49.609  69.489  1.00 22.63           C  
ATOM    153  OE1 GLU A  25      28.767  48.898  68.612  1.00 21.65           O  
ATOM    154  OE2 GLU A  25      29.980  50.630  69.203  1.00 24.53           O  
ATOM    155  N   THR A  26      26.472  45.798  70.204  1.00 19.26           N  
ATOM    156  CA  THR A  26      26.097  44.385  70.385  1.00 19.01           C  
ATOM    157  C   THR A  26      26.542  43.859  71.745  1.00 19.09           C  
ATOM    158  O   THR A  26      27.741  43.977  72.087  1.00 19.10           O  
ATOM    159  CB  THR A  26      26.800  43.530  69.330  1.00 19.25           C  
ATOM    160  OG1 THR A  26      26.379  43.919  68.007  1.00 18.44           O  
ATOM    161  CG2 THR A  26      26.390  42.019  69.475  1.00 19.64           C  
ATOM    162  N   ILE A  27      25.608  43.267  72.493  1.00 18.15           N  
ATOM    163  CA  ILE A  27      25.941  42.630  73.762  1.00 18.46           C  
ATOM    164  C   ILE A  27      25.702  41.137  73.626  1.00 19.02           C  
ATOM    165  O   ILE A  27      24.620  40.721  73.223  1.00 19.03           O  
ATOM    166  CB  ILE A  27      25.107  43.221  74.951  1.00 18.62           C  
ATOM    167  CG1 ILE A  27      25.198  44.761  75.013  1.00 17.57           C  
ATOM    168  CG2 ILE A  27      25.494  42.561  76.303  1.00 18.45           C  
ATOM    169  CD1 ILE A  27      26.613  45.375  75.051  1.00 20.11           C  
ATOM    170  N   ASN A  28      26.724  40.342  73.955  1.00 19.33           N  
ATOM    171  CA  ASN A  28      26.664  38.874  73.900  1.00 19.69           C  
ATOM    172  C   ASN A  28      26.788  38.317  75.300  1.00 19.96           C  
ATOM    173  O   ASN A  28      27.557  38.837  76.120  1.00 19.12           O  
ATOM    174  CB  ASN A  28      27.845  38.305  73.091  1.00 20.10           C  
ATOM    175  CG  ASN A  28      28.041  39.010  71.763  1.00 20.92           C  
ATOM    176  OD1 ASN A  28      28.993  39.775  71.568  1.00 24.63           O  
ATOM    177  ND2 ASN A  28      27.135  38.765  70.847  1.00 18.15           N  
ATOM    178  N   PHE A  29      26.064  37.235  75.555  1.00 19.62           N  
ATOM    179  CA  PHE A  29      26.131  36.568  76.856  1.00 19.25           C  
ATOM    180  C   PHE A  29      26.146  35.069  76.612  1.00 19.37           C  
ATOM    181  O   PHE A  29      25.220  34.519  76.006  1.00 18.64           O  
ATOM    182  CB  PHE A  29      24.922  36.974  77.702  1.00 19.02           C  
ATOM    183  CG  PHE A  29      24.949  36.452  79.109  1.00 21.02           C  
ATOM    184  CD1 PHE A  29      25.967  36.815  79.990  1.00 22.91           C  
ATOM    185  CD2 PHE A  29      23.935  35.632  79.573  1.00 23.79           C  
ATOM    186  CE1 PHE A  29      25.987  36.329  81.315  1.00 24.28           C  
ATOM    187  CE2 PHE A  29      23.952  35.154  80.906  1.00 25.71           C  
ATOM    188  CZ  PHE A  29      24.981  35.502  81.762  1.00 22.35           C  
ATOM    189  N   SER A  30      27.216  34.420  77.058  1.00 19.07           N  
ATOM    190  CA  SER A  30      27.379  32.997  76.819  1.00 19.30           C  
ATOM    191  C   SER A  30      27.509  32.195  78.108  1.00 19.29           C  
ATOM    192  O   SER A  30      27.776  32.764  79.178  1.00 18.88           O  
ATOM    193  CB  SER A  30      28.605  32.747  75.931  1.00 18.98           C  
ATOM    194  OG  SER A  30      29.800  32.894  76.703  1.00 18.90           O  
ATOM    195  N   SER A  31      27.300  30.879  77.983  1.00 19.81           N  
ATOM    196  CA  SER A  31      27.672  29.906  79.006  1.00 20.23           C  
ATOM    197  C   SER A  31      28.763  29.033  78.402  1.00 20.44           C  
ATOM    198  O   SER A  31      28.978  29.036  77.181  1.00 20.99           O  
ATOM    199  CB  SER A  31      26.468  29.045  79.419  1.00 21.01           C  
ATOM    200  OG  SER A  31      25.979  28.319  78.288  1.00 23.19           O  
ATOM    201  N   ARG A  32      29.489  28.320  79.252  1.00 20.55           N  
ATOM    202  CA  ARG A  32      30.434  27.328  78.773  1.00 20.92           C  
ATOM    203  C   ARG A  32      29.786  25.956  78.682  1.00 21.68           C  
ATOM    204  O   ARG A  32      29.109  25.522  79.602  1.00 21.90           O  
ATOM    205  CB  ARG A  32      31.666  27.250  79.684  1.00 20.30           C  
ATOM    206  CG  ARG A  32      32.838  26.557  78.992  1.00 19.97           C  
ATOM    207  CD  ARG A  32      33.874  25.987  79.928  1.00 18.98           C  
ATOM    208  NE  ARG A  32      34.898  25.300  79.148  1.00 20.67           N  
ATOM    209  CZ  ARG A  32      36.178  25.207  79.488  1.00 21.99           C  
ATOM    210  NH1 ARG A  32      36.623  25.761  80.615  1.00 21.15           N  
ATOM    211  NH2 ARG A  32      37.020  24.566  78.690  1.00 20.79           N  
ATOM    212  N   GLU A  33      29.993  25.276  77.559  1.00 23.02           N  
ATOM    213  CA  GLU A  33      29.628  23.868  77.461  1.00 24.53           C  
ATOM    214  C   GLU A  33      30.853  23.095  77.004  1.00 24.23           C  
ATOM    215  O   GLU A  33      30.997  22.791  75.817  1.00 24.21           O  
ATOM    216  CB  GLU A  33      28.453  23.679  76.498  1.00 25.47           C  
ATOM    217  CG  GLU A  33      27.974  22.252  76.330  1.00 29.26           C  
ATOM    218  CD  GLU A  33      26.695  22.193  75.519  1.00 34.46           C  
ATOM    219  OE1 GLU A  33      26.754  22.286  74.265  1.00 34.77           O  
ATOM    220  OE2 GLU A  33      25.627  22.083  76.144  1.00 36.17           O  
ATOM    221  N   ASP A  34      31.756  22.818  77.948  1.00 23.80           N  
ATOM    222  CA  ASP A  34      33.004  22.097  77.638  1.00 23.73           C  
ATOM    223  C   ASP A  34      33.879  22.804  76.565  1.00 23.01           C  
ATOM    224  O   ASP A  34      34.498  23.824  76.859  1.00 22.78           O  
ATOM    225  CB  ASP A  34      32.667  20.651  77.243  1.00 24.15           C  
ATOM    226  CG  ASP A  34      33.884  19.749  77.155  1.00 25.63           C  
ATOM    227  OD1 ASP A  34      35.026  20.189  77.457  1.00 27.66           O  
ATOM    228  OD2 ASP A  34      33.776  18.567  76.761  1.00 24.97           O  
ATOM    229  N   ASP A  35      33.922  22.270  75.342  1.00 21.90           N  
ATOM    230  CA  ASP A  35      34.823  22.759  74.287  1.00 21.77           C  
ATOM    231  C   ASP A  35      34.245  23.836  73.355  1.00 21.44           C  
ATOM    232  O   ASP A  35      34.812  24.113  72.297  1.00 21.63           O  
ATOM    233  CB  ASP A  35      35.383  21.574  73.476  1.00 22.04           C  
ATOM    234  CG  ASP A  35      34.343  20.934  72.567  1.00 24.54           C  
ATOM    235  OD1 ASP A  35      33.134  21.029  72.869  1.00 25.70           O  
ATOM    236  OD2 ASP A  35      34.653  20.319  71.525  1.00 25.55           O  
ATOM    237  N   HIS A  36      33.137  24.454  73.768  1.00 21.21           N  
ATOM    238  CA  HIS A  36      32.548  25.587  73.059  1.00 22.05           C  
ATOM    239  C   HIS A  36      31.858  26.533  74.049  1.00 21.41           C  
ATOM    240  O   HIS A  36      31.488  26.127  75.156  1.00 22.10           O  
ATOM    241  CB  HIS A  36      31.570  25.124  71.953  1.00 22.17           C  
ATOM    242  CG  HIS A  36      30.597  24.088  72.412  1.00 26.64           C  
ATOM    243  ND1 HIS A  36      30.968  22.781  72.674  1.00 28.93           N  
ATOM    244  CD2 HIS A  36      29.279  24.171  72.713  1.00 28.69           C  
ATOM    245  CE1 HIS A  36      29.918  22.106  73.105  1.00 26.60           C  
ATOM    246  NE2 HIS A  36      28.881  22.922  73.126  1.00 28.70           N  
ATOM    247  N   ALA A  37      31.704  27.789  73.646  1.00 21.26           N  
ATOM    248  CA  ALA A  37      30.808  28.720  74.325  1.00 21.34           C  
ATOM    249  C   ALA A  37      29.437  28.587  73.643  1.00 22.28           C  
ATOM    250  O   ALA A  37      29.371  28.333  72.437  1.00 23.32           O  
ATOM    251  CB  ALA A  37      31.344  30.178  74.211  1.00 21.21           C  
ATOM    252  N   ILE A  38      28.356  28.708  74.413  1.00 21.98           N  
ATOM    253  CA  ILE A  38      27.011  28.755  73.832  1.00 21.24           C  
ATOM    254  C   ILE A  38      26.482  30.158  73.988  1.00 20.44           C  
ATOM    255  O   ILE A  38      26.405  30.682  75.107  1.00 19.83           O  
ATOM    256  CB  ILE A  38      26.026  27.773  74.499  1.00 21.19           C  
ATOM    257  CG1 ILE A  38      26.600  26.354  74.536  1.00 23.36           C  
ATOM    258  CG2 ILE A  38      24.656  27.794  73.734  1.00 21.87           C  
ATOM    259  CD1 ILE A  38      25.642  25.349  75.215  1.00 27.15           C  
ATOM    260  N   LEU A  39      26.093  30.762  72.869  1.00 19.99           N  
ATOM    261  CA  LEU A  39      25.472  32.082  72.921  1.00 20.04           C  
ATOM    262  C   LEU A  39      24.033  31.960  73.391  1.00 20.76           C  
ATOM    263  O   LEU A  39      23.159  31.604  72.601  1.00 21.82           O  
ATOM    264  CB  LEU A  39      25.555  32.796  71.562  1.00 19.14           C  
ATOM    265  CG  LEU A  39      25.199  34.285  71.596  1.00 18.48           C  
ATOM    266  CD1 LEU A  39      26.073  35.011  72.642  1.00 15.96           C  
ATOM    267  CD2 LEU A  39      25.403  34.909  70.224  1.00 18.07           C  
ATOM    268  N   ILE A  40      23.785  32.247  74.668  1.00 20.01           N  
ATOM    269  CA  ILE A  40      22.429  32.073  75.209  1.00 20.04           C  
ATOM    270  C   ILE A  40      21.570  33.323  75.139  1.00 19.67           C  
ATOM    271  O   ILE A  40      20.355  33.255  75.328  1.00 19.83           O  
ATOM    272  CB  ILE A  40      22.463  31.473  76.640  1.00 19.88           C  
ATOM    273  CG1 ILE A  40      23.174  32.422  77.628  1.00 19.60           C  
ATOM    274  CG2 ILE A  40      23.111  30.067  76.595  1.00 20.47           C  
ATOM    275  CD1 ILE A  40      23.071  31.981  79.100  1.00 20.58           C  
ATOM    276  N   TYR A  41      22.189  34.463  74.851  1.00 19.17           N  
ATOM    277  CA  TYR A  41      21.477  35.725  74.871  1.00 20.18           C  
ATOM    278  C   TYR A  41      22.279  36.725  74.051  1.00 19.73           C  
ATOM    279  O   TYR A  41      23.516  36.774  74.137  1.00 20.28           O  
ATOM    280  CB  TYR A  41      21.327  36.151  76.329  1.00 20.10           C  
ATOM    281  CG  TYR A  41      20.675  37.472  76.607  1.00 22.99           C  
ATOM    282  CD1 TYR A  41      19.387  37.530  77.115  1.00 25.91           C  
ATOM    283  CD2 TYR A  41      21.375  38.667  76.440  1.00 22.13           C  
ATOM    284  CE1 TYR A  41      18.791  38.748  77.423  1.00 25.44           C  
ATOM    285  CE2 TYR A  41      20.790  39.880  76.744  1.00 24.78           C  
ATOM    286  CZ  TYR A  41      19.502  39.912  77.239  1.00 25.19           C  
ATOM    287  OH  TYR A  41      18.923  41.120  77.561  1.00 27.06           O  
ATOM    288  N   LYS A  42      21.582  37.487  73.222  1.00 18.76           N  
ATOM    289  CA  LYS A  42      22.231  38.494  72.380  1.00 19.30           C  
ATOM    290  C   LYS A  42      21.323  39.712  72.165  1.00 19.52           C  
ATOM    291  O   LYS A  42      20.137  39.557  71.898  1.00 19.28           O  
ATOM    292  CB  LYS A  42      22.648  37.901  71.016  1.00 18.74           C  
ATOM    293  CG  LYS A  42      23.493  38.857  70.169  1.00 18.21           C  
ATOM    294  CD  LYS A  42      23.574  38.430  68.705  1.00 18.81           C  
ATOM    295  CE  LYS A  42      24.481  39.399  67.911  1.00 17.86           C  
ATOM    296  NZ  LYS A  42      24.298  39.273  66.394  1.00 17.98           N  
ATOM    297  N   LEU A  43      21.902  40.906  72.286  1.00 19.02           N  
ATOM    298  CA  LEU A  43      21.227  42.152  71.917  1.00 19.50           C  
ATOM    299  C   LEU A  43      21.939  42.793  70.746  1.00 19.27           C  
ATOM    300  O   LEU A  43      23.149  43.027  70.781  1.00 19.40           O  
ATOM    301  CB  LEU A  43      21.171  43.148  73.101  1.00 19.46           C  
ATOM    302  CG  LEU A  43      20.472  42.598  74.354  1.00 20.61           C  
ATOM    303  CD1 LEU A  43      20.714  43.476  75.555  1.00 20.35           C  
ATOM    304  CD2 LEU A  43      18.954  42.391  74.127  1.00 18.37           C  
ATOM    305  N   GLU A  44      21.177  43.094  69.702  1.00 19.17           N  
ATOM    306  CA  GLU A  44      21.701  43.811  68.554  1.00 19.07           C  
ATOM    307  C   GLU A  44      22.065  45.245  68.948  1.00 19.24           C  
ATOM    308  O   GLU A  44      21.542  45.747  69.939  1.00 19.43           O  
ATOM    309  CB  GLU A  44      20.655  43.802  67.425  1.00 19.21           C  
ATOM    310  CG  GLU A  44      20.413  42.425  66.799  1.00 19.29           C  
ATOM    311  CD  GLU A  44      21.680  41.787  66.212  1.00 21.73           C  
ATOM    312  OE1 GLU A  44      22.548  42.516  65.695  1.00 22.01           O  
ATOM    313  OE2 GLU A  44      21.802  40.542  66.252  1.00 21.85           O  
ATOM    314  N   PRO A  45      22.944  45.908  68.196  1.00 20.14           N  
ATOM    315  CA  PRO A  45      23.313  47.293  68.512  1.00 20.49           C  
ATOM    316  C   PRO A  45      22.110  48.248  68.376  1.00 21.34           C  
ATOM    317  O   PRO A  45      21.149  47.928  67.655  1.00 21.50           O  
ATOM    318  CB  PRO A  45      24.389  47.619  67.468  1.00 20.48           C  
ATOM    319  CG  PRO A  45      24.075  46.703  66.299  1.00 20.50           C  
ATOM    320  CD  PRO A  45      23.636  45.418  66.979  1.00 19.94           C  
ATOM    321  N   THR A  46      22.155  49.375  69.082  1.00 21.37           N  
ATOM    322  CA  THR A  46      21.147  50.420  68.896  1.00 22.48           C  
ATOM    323  C   THR A  46      21.711  51.427  67.907  1.00 23.20           C  
ATOM    324  O   THR A  46      21.397  51.370  66.724  1.00 23.67           O  
ATOM    325  CB  THR A  46      20.754  51.106  70.224  1.00 22.38           C  
ATOM    326  OG1 THR A  46      21.929  51.562  70.903  1.00 22.94           O  
ATOM    327  CG2 THR A  46      20.151  50.112  71.202  1.00 22.92           C  
ATOM    328  N   THR A  47      22.577  52.317  68.381  1.00 23.87           N  
ATOM    329  CA  THR A  47      23.186  53.315  67.506  1.00 24.45           C  
ATOM    330  C   THR A  47      24.432  52.765  66.825  1.00 24.86           C  
ATOM    331  O   THR A  47      24.864  53.298  65.797  1.00 25.12           O  
ATOM    332  CB  THR A  47      23.524  54.587  68.283  1.00 25.12           C  
ATOM    333  OG1 THR A  47      24.302  54.246  69.432  1.00 24.96           O  
ATOM    334  CG2 THR A  47      22.252  55.217  68.873  1.00 25.22           C  
ATOM    335  N   GLY A  48      24.998  51.687  67.373  1.00 24.86           N  
ATOM    336  CA  GLY A  48      26.140  51.036  66.748  1.00 24.44           C  
ATOM    337  C   GLY A  48      25.762  50.495  65.384  1.00 25.11           C  
ATOM    338  O   GLY A  48      24.625  50.059  65.174  1.00 25.67           O  
ATOM    339  N   MET A  49      26.708  50.515  64.456  1.00 24.69           N  
ATOM    340  CA  MET A  49      26.447  50.061  63.097  1.00 25.13           C  
ATOM    341  C   MET A  49      26.967  48.664  62.733  1.00 24.91           C  
ATOM    342  O   MET A  49      26.518  48.085  61.736  1.00 25.15           O  
ATOM    343  CB  MET A  49      26.957  51.102  62.100  1.00 25.12           C  
ATOM    344  CG  MET A  49      26.397  52.492  62.428  1.00 26.02           C  
ATOM    345  SD  MET A  49      24.838  52.736  61.621  1.00 21.37           S  
ATOM    346  CE  MET A  49      25.562  53.401  60.298  1.00 23.39           C  
ATOM    347  N   LEU A  50      27.880  48.114  63.535  1.00 24.40           N  
ATOM    348  CA  LEU A  50      28.385  46.780  63.263  1.00 24.25           C  
ATOM    349  C   LEU A  50      27.389  45.744  63.770  1.00 23.65           C  
ATOM    350  O   LEU A  50      27.035  45.736  64.949  1.00 22.80           O  
ATOM    351  CB  LEU A  50      29.767  46.554  63.905  1.00 24.91           C  
ATOM    352  CG  LEU A  50      30.236  45.141  63.530  1.00 27.57           C  
ATOM    353  CD1 LEU A  50      30.975  45.172  62.167  1.00 29.21           C  
ATOM    354  CD2 LEU A  50      31.024  44.472  64.610  1.00 28.70           C  
ATOM    355  N   ARG A  51      26.923  44.879  62.875  1.00 23.27           N  
ATOM    356  CA  ARG A  51      26.002  43.819  63.268  1.00 23.19           C  
ATOM    357  C   ARG A  51      26.667  42.519  62.905  1.00 23.58           C  
ATOM    358  O   ARG A  51      27.102  42.339  61.764  1.00 24.21           O  
ATOM    359  CB  ARG A  51      24.648  43.957  62.566  1.00 23.61           C  
ATOM    360  CG  ARG A  51      24.010  45.310  62.778  1.00 23.20           C  
ATOM    361  CD  ARG A  51      22.719  45.544  61.990  1.00 24.80           C  
ATOM    362  NE  ARG A  51      21.623  44.733  62.523  1.00 24.52           N  
ATOM    363  CZ  ARG A  51      20.849  45.077  63.566  1.00 25.02           C  
ATOM    364  NH1 ARG A  51      21.035  46.233  64.206  1.00 23.67           N  
ATOM    365  NH2 ARG A  51      19.876  44.260  63.959  1.00 23.84           N  
ATOM    366  N   THR A  52      26.800  41.634  63.884  1.00 23.01           N  
ATOM    367  CA  THR A  52      27.455  40.355  63.653  1.00 22.84           C  
ATOM    368  C   THR A  52      26.407  39.316  63.265  1.00 23.09           C  
ATOM    369  O   THR A  52      25.203  39.520  63.480  1.00 22.68           O  
ATOM    370  CB  THR A  52      28.192  39.880  64.909  1.00 22.73           C  
ATOM    371  OG1 THR A  52      27.231  39.434  65.892  1.00 22.12           O  
ATOM    372  CG2 THR A  52      28.962  41.056  65.574  1.00 22.30           C  
ATOM    373  N   ARG A  53      26.880  38.201  62.720  1.00 24.09           N  
ATOM    374  CA  ARG A  53      26.010  37.084  62.338  1.00 25.44           C  
ATOM    375  C   ARG A  53      25.743  36.141  63.503  1.00 24.47           C  
ATOM    376  O   ARG A  53      25.024  35.142  63.354  1.00 24.50           O  
ATOM    377  CB  ARG A  53      26.641  36.300  61.189  1.00 26.65           C  
ATOM    378  CG  ARG A  53      26.704  37.079  59.873  1.00 32.55           C  
ATOM    379  CD  ARG A  53      27.065  36.222  58.649  1.00 40.15           C  
ATOM    380  NE  ARG A  53      28.497  36.238  58.322  1.00 46.43           N  
ATOM    381  CZ  ARG A  53      29.227  37.329  58.073  1.00 49.47           C  
ATOM    382  NH1 ARG A  53      28.680  38.543  58.111  1.00 51.16           N  
ATOM    383  NH2 ARG A  53      30.517  37.201  57.779  1.00 50.95           N  
ATOM    384  N   ALA A  54      26.314  36.448  64.671  1.00 23.48           N  
ATOM    385  CA  ALA A  54      26.023  35.655  65.876  1.00 22.53           C  
ATOM    386  C   ALA A  54      24.519  35.608  66.195  1.00 21.59           C  
ATOM    387  O   ALA A  54      23.787  36.563  65.937  1.00 21.82           O  
ATOM    388  CB  ALA A  54      26.803  36.193  67.075  1.00 22.60           C  
ATOM    389  N   TYR A  55      24.077  34.494  66.778  1.00 21.09           N  
ATOM    390  CA  TYR A  55      22.665  34.264  67.075  1.00 21.15           C  
ATOM    391  C   TYR A  55      22.536  33.395  68.315  1.00 20.82           C  
ATOM    392  O   TYR A  55      23.433  32.616  68.630  1.00 20.24           O  
ATOM    393  CB  TYR A  55      21.968  33.568  65.891  1.00 20.48           C  
ATOM    394  CG  TYR A  55      22.676  32.294  65.453  1.00 20.48           C  
ATOM    395  CD1 TYR A  55      22.293  31.044  65.957  1.00 19.86           C  
ATOM    396  CD2 TYR A  55      23.713  32.342  64.524  1.00 20.04           C  
ATOM    397  CE1 TYR A  55      22.938  29.873  65.561  1.00 18.92           C  
ATOM    398  CE2 TYR A  55      24.393  31.171  64.129  1.00 19.80           C  
ATOM    399  CZ  TYR A  55      23.991  29.951  64.650  1.00 19.62           C  
ATOM    400  OH  TYR A  55      24.630  28.813  64.240  1.00 20.64           O  
ATOM    401  N   ILE A  56      21.405  33.529  68.998  1.00 20.81           N  
ATOM    402  CA  ILE A  56      21.114  32.738  70.183  1.00 21.72           C  
ATOM    403  C   ILE A  56      21.084  31.257  69.809  1.00 21.63           C  
ATOM    404  O   ILE A  56      20.412  30.855  68.848  1.00 20.70           O  
ATOM    405  CB  ILE A  56      19.787  33.212  70.851  1.00 21.40           C  
ATOM    406  CG1 ILE A  56      19.964  34.633  71.406  1.00 22.14           C  
ATOM    407  CG2 ILE A  56      19.291  32.196  71.919  1.00 21.72           C  
ATOM    408  CD1 ILE A  56      18.633  35.334  71.817  1.00 23.84           C  
ATOM    409  N   GLY A  57      21.849  30.465  70.551  1.00 21.66           N  
ATOM    410  CA  GLY A  57      21.967  29.039  70.294  1.00 21.56           C  
ATOM    411  C   GLY A  57      23.242  28.687  69.549  1.00 21.33           C  
ATOM    412  O   GLY A  57      23.602  27.511  69.444  1.00 21.51           O  
ATOM    413  N   GLN A  58      23.959  29.698  69.059  1.00 20.84           N  
ATOM    414  CA  GLN A  58      25.214  29.438  68.354  1.00 20.79           C  
ATOM    415  C   GLN A  58      26.252  28.782  69.284  1.00 20.26           C  
ATOM    416  O   GLN A  58      26.356  29.163  70.460  1.00 20.00           O  
ATOM    417  CB  GLN A  58      25.792  30.730  67.797  1.00 20.79           C  
ATOM    418  CG  GLN A  58      27.048  30.546  66.942  1.00 22.71           C  
ATOM    419  CD  GLN A  58      27.503  31.855  66.329  1.00 26.23           C  
ATOM    420  OE1 GLN A  58      27.265  32.918  66.895  1.00 24.62           O  
ATOM    421  NE2 GLN A  58      28.153  31.785  65.177  1.00 28.09           N  
ATOM    422  N   HIS A  59      27.015  27.832  68.742  1.00 19.17           N  
ATOM    423  CA  HIS A  59      28.169  27.253  69.442  1.00 19.94           C  
ATOM    424  C   HIS A  59      29.438  27.867  68.882  1.00 20.35           C  
ATOM    425  O   HIS A  59      29.708  27.797  67.688  1.00 20.69           O  
ATOM    426  CB  HIS A  59      28.223  25.737  69.284  1.00 20.81           C  
ATOM    427  CG  HIS A  59      27.115  25.008  69.982  1.00 20.94           C  
ATOM    428  ND1 HIS A  59      27.138  23.642  70.170  1.00 20.75           N  
ATOM    429  CD2 HIS A  59      25.968  25.447  70.556  1.00 21.61           C  
ATOM    430  CE1 HIS A  59      26.050  23.270  70.824  1.00 21.65           C  
ATOM    431  NE2 HIS A  59      25.330  24.348  71.083  1.00 21.07           N  
ATOM    432  N   MET A  60      30.201  28.490  69.774  1.00 19.99           N  
ATOM    433  CA  MET A  60      31.336  29.285  69.408  1.00 19.08           C  
ATOM    434  C   MET A  60      32.627  28.477  69.861  1.00 20.97           C  
ATOM    435  O   MET A  60      32.720  28.099  71.040  1.00 20.37           O  
ATOM    436  CB  MET A  60      31.061  30.725  70.013  1.00 20.41           C  
ATOM    437  CG  MET A  60      29.338  31.227  70.416  1.00  3.96           C  
ATOM    438  SD  MET A  60      29.630  32.901  70.662  1.00 35.59           S  
ATOM    439  CE  MET A  60      29.313  32.956  72.298  1.00 25.32           C  
ATOM    440  N   PRO A  61      33.579  28.123  68.960  1.00 21.35           N  
ATOM    441  CA  PRO A  61      34.782  27.373  69.407  1.00 21.81           C  
ATOM    442  C   PRO A  61      35.628  28.188  70.395  1.00 21.17           C  
ATOM    443  O   PRO A  61      35.719  29.416  70.271  1.00 21.62           O  
ATOM    444  CB  PRO A  61      35.592  27.149  68.121  1.00 22.30           C  
ATOM    445  CG  PRO A  61      34.620  27.366  66.994  1.00 22.86           C  
ATOM    446  CD  PRO A  61      33.636  28.404  67.510  1.00 21.79           C  
ATOM    447  N   LEU A  62      36.215  27.522  71.377  1.00 20.97           N  
ATOM    448  CA  LEU A  62      36.954  28.237  72.427  1.00 21.11           C  
ATOM    449  C   LEU A  62      38.116  29.085  71.902  1.00 21.47           C  
ATOM    450  O   LEU A  62      38.345  30.187  72.407  1.00 21.27           O  
ATOM    451  CB  LEU A  62      37.468  27.265  73.497  1.00 20.45           C  
ATOM    452  CG  LEU A  62      36.407  26.472  74.302  1.00 21.60           C  
ATOM    453  CD1 LEU A  62      37.095  25.627  75.369  1.00 22.61           C  
ATOM    454  CD2 LEU A  62      35.334  27.341  74.921  1.00 20.62           C  
ATOM    455  N   TYR A  63      38.836  28.575  70.896  1.00 22.20           N  
ATOM    456  CA  TYR A  63      40.120  29.166  70.486  1.00 22.86           C  
ATOM    457  C   TYR A  63      39.996  30.513  69.757  1.00 23.44           C  
ATOM    458  O   TYR A  63      40.955  31.274  69.715  1.00 22.97           O  
ATOM    459  CB  TYR A  63      40.933  28.177  69.629  1.00 22.76           C  
ATOM    460  CG  TYR A  63      40.521  28.173  68.172  1.00 22.94           C  
ATOM    461  CD1 TYR A  63      41.269  28.864  67.209  1.00 22.16           C  
ATOM    462  CD2 TYR A  63      39.367  27.498  67.762  1.00 23.42           C  
ATOM    463  CE1 TYR A  63      40.876  28.894  65.865  1.00 24.49           C  
ATOM    464  CE2 TYR A  63      38.965  27.502  66.424  1.00 25.11           C  
ATOM    465  CZ  TYR A  63      39.724  28.211  65.482  1.00 26.40           C  
ATOM    466  OH  TYR A  63      39.333  28.201  64.159  1.00 27.36           O  
ATOM    467  N   CYS A  64      38.824  30.788  69.173  1.00 23.83           N  
ATOM    468  CA  CYS A  64      38.628  31.999  68.355  1.00 24.05           C  
ATOM    469  C   CYS A  64      37.527  32.919  68.914  1.00 24.13           C  
ATOM    470  O   CYS A  64      37.165  33.907  68.287  1.00 24.86           O  
ATOM    471  CB  CYS A  64      38.348  31.620  66.878  1.00 23.69           C  
ATOM    472  SG  CYS A  64      36.916  30.537  66.685  1.00 25.70           S  
ATOM    473  N   SER A  65      37.014  32.581  70.098  1.00 24.05           N  
ATOM    474  CA  SER A  65      35.975  33.346  70.792  1.00 23.57           C  
ATOM    475  C   SER A  65      36.623  34.033  71.982  1.00 23.05           C  
ATOM    476  O   SER A  65      37.285  33.373  72.792  1.00 23.33           O  
ATOM    477  CB  SER A  65      34.857  32.410  71.273  1.00 23.33           C  
ATOM    478  OG  SER A  65      34.015  32.997  72.255  1.00 25.28           O  
ATOM    479  N   ALA A  66      36.428  35.346  72.106  1.00 22.63           N  
ATOM    480  CA  ALA A  66      36.955  36.065  73.281  1.00 21.17           C  
ATOM    481  C   ALA A  66      36.422  35.473  74.598  1.00 21.06           C  
ATOM    482  O   ALA A  66      37.190  35.232  75.543  1.00 20.20           O  
ATOM    483  CB  ALA A  66      36.668  37.574  73.187  1.00 21.81           C  
ATOM    484  N   MET A  67      35.112  35.245  74.663  1.00 20.49           N  
ATOM    485  CA  MET A  67      34.498  34.564  75.812  1.00 19.98           C  
ATOM    486  C   MET A  67      35.067  33.143  76.001  1.00 20.26           C  
ATOM    487  O   MET A  67      35.369  32.735  77.133  1.00 20.39           O  
ATOM    488  CB  MET A  67      32.972  34.548  75.670  1.00 19.40           C  
ATOM    489  CG  MET A  67      32.300  35.955  75.852  1.00 18.04           C  
ATOM    490  SD  MET A  67      30.468  35.953  75.792  1.00  4.88           S  
ATOM    491  CE  MET A  67      30.273  35.591  74.191  1.00 15.42           C  
ATOM    492  N   GLY A  68      35.239  32.409  74.895  1.00 20.09           N  
ATOM    493  CA  GLY A  68      35.837  31.074  74.936  1.00 20.23           C  
ATOM    494  C   GLY A  68      37.260  31.087  75.495  1.00 20.34           C  
ATOM    495  O   GLY A  68      37.637  30.209  76.273  1.00 19.75           O  
ATOM    496  N   LYS A  69      38.047  32.099  75.120  1.00 20.04           N  
ATOM    497  CA  LYS A  69      39.406  32.233  75.648  1.00 20.24           C  
ATOM    498  C   LYS A  69      39.391  32.506  77.153  1.00 20.54           C  
ATOM    499  O   LYS A  69      40.231  31.982  77.898  1.00 20.82           O  
ATOM    500  CB  LYS A  69      40.191  33.302  74.881  1.00 20.09           C  
ATOM    501  CG  LYS A  69      40.542  32.852  73.457  1.00 20.87           C  
ATOM    502  CD  LYS A  69      41.506  33.840  72.760  1.00 19.08           C  
ATOM    503  CE  LYS A  69      40.826  35.196  72.537  1.00 21.29           C  
ATOM    504  NZ  LYS A  69      41.679  36.171  71.792  1.00 19.84           N  
ATOM    505  N   ILE A  70      38.410  33.280  77.612  1.00 19.64           N  
ATOM    506  CA  ILE A  70      38.224  33.491  79.056  1.00 19.05           C  
ATOM    507  C   ILE A  70      37.981  32.158  79.765  1.00 19.23           C  
ATOM    508  O   ILE A  70      38.607  31.870  80.780  1.00 18.64           O  
ATOM    509  CB  ILE A  70      37.067  34.482  79.296  1.00 18.82           C  
ATOM    510  CG1 ILE A  70      37.536  35.895  78.963  1.00 19.25           C  
ATOM    511  CG2 ILE A  70      36.533  34.415  80.750  1.00 18.84           C  
ATOM    512  CD1 ILE A  70      36.411  36.880  78.844  1.00 19.94           C  
ATOM    513  N   TYR A  71      37.090  31.330  79.216  1.00 18.45           N  
ATOM    514  CA  TYR A  71      36.838  30.018  79.825  1.00 18.69           C  
ATOM    515  C   TYR A  71      38.122  29.209  79.930  1.00 19.08           C  
ATOM    516  O   TYR A  71      38.404  28.647  80.974  1.00 18.80           O  
ATOM    517  CB  TYR A  71      35.784  29.241  79.031  1.00 18.37           C  
ATOM    518  CG  TYR A  71      34.413  29.897  79.038  1.00 18.68           C  
ATOM    519  CD1 TYR A  71      33.870  30.408  80.218  1.00 18.19           C  
ATOM    520  CD2 TYR A  71      33.652  29.984  77.864  1.00 19.23           C  
ATOM    521  CE1 TYR A  71      32.592  31.003  80.240  1.00 20.50           C  
ATOM    522  CE2 TYR A  71      32.372  30.591  77.870  1.00 20.17           C  
ATOM    523  CZ  TYR A  71      31.854  31.089  79.059  1.00 19.88           C  
ATOM    524  OH  TYR A  71      30.598  31.663  79.074  1.00 19.41           O  
ATOM    525  N   MET A  72      38.911  29.159  78.855  1.00 19.14           N  
ATOM    526  CA  MET A  72      40.192  28.425  78.930  1.00 19.20           C  
ATOM    527  C   MET A  72      41.191  29.071  79.909  1.00 19.27           C  
ATOM    528  O   MET A  72      41.911  28.359  80.625  1.00 19.82           O  
ATOM    529  CB  MET A  72      40.832  28.253  77.553  1.00 19.09           C  
ATOM    530  CG  MET A  72      40.102  27.201  76.663  1.00 20.03           C  
ATOM    531  SD  MET A  72      41.006  26.594  75.180  1.00  8.59           S  
ATOM    532  CE  MET A  72      41.261  28.029  74.416  1.00 13.40           C  
ATOM    533  N   ALA A  73      41.228  30.405  79.943  1.00 19.12           N  
ATOM    534  CA  ALA A  73      42.178  31.125  80.798  1.00 20.15           C  
ATOM    535  C   ALA A  73      41.952  30.835  82.274  1.00 20.15           C  
ATOM    536  O   ALA A  73      42.900  30.831  83.060  1.00 20.62           O  
ATOM    537  CB  ALA A  73      42.111  32.633  80.533  1.00 19.47           C  
ATOM    538  N   PHE A  74      40.697  30.607  82.654  1.00 20.44           N  
ATOM    539  CA  PHE A  74      40.372  30.266  84.043  1.00 20.97           C  
ATOM    540  C   PHE A  74      40.234  28.763  84.324  1.00 21.95           C  
ATOM    541  O   PHE A  74      39.960  28.353  85.467  1.00 21.55           O  
ATOM    542  CB  PHE A  74      39.136  31.045  84.476  1.00 21.25           C  
ATOM    543  CG  PHE A  74      39.436  32.486  84.769  1.00 20.63           C  
ATOM    544  CD1 PHE A  74      39.627  32.914  86.083  1.00 19.70           C  
ATOM    545  CD2 PHE A  74      39.551  33.412  83.722  1.00 20.28           C  
ATOM    546  CE1 PHE A  74      39.923  34.266  86.363  1.00 18.24           C  
ATOM    547  CE2 PHE A  74      39.844  34.744  83.973  1.00 20.27           C  
ATOM    548  CZ  PHE A  74      40.044  35.174  85.304  1.00 18.53           C  
ATOM    549  N   GLY A  75      40.457  27.957  83.282  1.00 22.34           N  
ATOM    550  CA  GLY A  75      40.507  26.510  83.404  1.00 22.65           C  
ATOM    551  C   GLY A  75      41.909  25.985  83.710  1.00 23.41           C  
ATOM    552  O   GLY A  75      42.835  26.753  84.010  1.00 22.56           O  
ATOM    553  N   HIS A  76      42.058  24.662  83.647  1.00 23.45           N  
ATOM    554  CA  HIS A  76      43.350  24.006  83.862  1.00 24.04           C  
ATOM    555  C   HIS A  76      44.209  24.039  82.591  1.00 24.19           C  
ATOM    556  O   HIS A  76      43.666  23.889  81.491  1.00 24.14           O  
ATOM    557  CB  HIS A  76      43.120  22.564  84.309  1.00 23.36           C  
ATOM    558  CG  HIS A  76      44.296  21.963  85.003  1.00 24.10           C  
ATOM    559  ND1 HIS A  76      45.348  21.391  84.321  1.00 24.29           N  
ATOM    560  CD2 HIS A  76      44.607  21.878  86.321  1.00 25.32           C  
ATOM    561  CE1 HIS A  76      46.252  20.961  85.190  1.00 25.45           C  
ATOM    562  NE2 HIS A  76      45.822  21.236  86.410  1.00 25.98           N  
ATOM    563  N   PRO A  77      45.535  24.224  82.704  1.00 25.02           N  
ATOM    564  CA  PRO A  77      46.383  24.228  81.499  1.00 25.17           C  
ATOM    565  C   PRO A  77      46.395  22.906  80.748  1.00 25.08           C  
ATOM    566  O   PRO A  77      46.622  22.924  79.529  1.00 25.55           O  
ATOM    567  CB  PRO A  77      47.785  24.589  82.013  1.00 25.78           C  
ATOM    568  CG  PRO A  77      47.719  24.481  83.512  1.00 25.73           C  
ATOM    569  CD  PRO A  77      46.303  24.482  83.939  1.00 24.74           C  
ATOM    570  N   ASP A  78      46.149  21.785  81.433  1.00 24.79           N  
ATOM    571  CA  ASP A  78      46.079  20.491  80.747  1.00 24.83           C  
ATOM    572  C   ASP A  78      44.921  20.486  79.747  1.00 23.88           C  
ATOM    573  O   ASP A  78      44.981  19.800  78.731  1.00 24.00           O  
ATOM    574  CB  ASP A  78      45.890  19.333  81.734  1.00 25.09           C  
ATOM    575  CG  ASP A  78      47.143  19.044  82.562  1.00 26.95           C  
ATOM    576  OD1 ASP A  78      48.213  19.639  82.305  1.00 25.41           O  
ATOM    577  OD2 ASP A  78      47.130  18.233  83.513  1.00 28.03           O  
ATOM    578  N   TYR A  79      43.874  21.261  80.033  1.00 23.20           N  
ATOM    579  CA  TYR A  79      42.745  21.338  79.109  1.00 23.55           C  
ATOM    580  C   TYR A  79      43.201  21.843  77.738  1.00 23.45           C  
ATOM    581  O   TYR A  79      42.808  21.293  76.696  1.00 23.32           O  
ATOM    582  CB  TYR A  79      41.609  22.219  79.664  1.00 22.84           C  
ATOM    583  CG  TYR A  79      40.358  22.175  78.800  1.00 23.31           C  
ATOM    584  CD1 TYR A  79      39.250  21.408  79.185  1.00 23.82           C  
ATOM    585  CD2 TYR A  79      40.299  22.867  77.580  1.00 22.56           C  
ATOM    586  CE1 TYR A  79      38.106  21.344  78.379  1.00 23.43           C  
ATOM    587  CE2 TYR A  79      39.170  22.800  76.758  1.00 23.23           C  
ATOM    588  CZ  TYR A  79      38.075  22.040  77.172  1.00 24.41           C  
ATOM    589  OH  TYR A  79      36.944  21.967  76.388  1.00 22.91           O  
ATOM    590  N   VAL A  80      44.036  22.889  77.755  1.00 23.85           N  
ATOM    591  CA  VAL A  80      44.452  23.598  76.544  1.00 23.95           C  
ATOM    592  C   VAL A  80      45.326  22.691  75.673  1.00 24.56           C  
ATOM    593  O   VAL A  80      45.117  22.591  74.464  1.00 23.26           O  
ATOM    594  CB  VAL A  80      45.225  24.916  76.863  1.00 24.38           C  
ATOM    595  CG1 VAL A  80      45.419  25.764  75.608  1.00 23.96           C  
ATOM    596  CG2 VAL A  80      44.530  25.713  77.971  1.00 23.72           C  
ATOM    597  N   LYS A  81      46.287  22.027  76.307  1.00 25.49           N  
ATOM    598  CA  LYS A  81      47.103  21.017  75.629  1.00 27.15           C  
ATOM    599  C   LYS A  81      46.248  19.919  74.977  1.00 26.70           C  
ATOM    600  O   LYS A  81      46.403  19.661  73.784  1.00 27.25           O  
ATOM    601  CB  LYS A  81      48.154  20.412  76.582  1.00 28.10           C  
ATOM    602  CG  LYS A  81      49.148  19.502  75.862  1.00 31.61           C  
ATOM    603  CD  LYS A  81      50.566  19.603  76.412  1.00 37.72           C  
ATOM    604  CE  LYS A  81      51.333  18.297  76.182  1.00 41.09           C  
ATOM    605  NZ  LYS A  81      51.533  17.543  77.459  1.00 43.13           N  
ATOM    606  N   SER A  82      45.332  19.312  75.737  1.00 26.55           N  
ATOM    607  CA  SER A  82      44.485  18.237  75.201  1.00 27.04           C  
ATOM    608  C   SER A  82      43.517  18.772  74.145  1.00 26.67           C  
ATOM    609  O   SER A  82      43.224  18.090  73.172  1.00 26.75           O  
ATOM    610  CB  SER A  82      43.703  17.515  76.311  1.00 27.39           C  
ATOM    611  OG  SER A  82      44.580  17.086  77.343  1.00 30.27           O  
ATOM    612  N   TYR A  83      43.027  19.994  74.349  1.00 26.12           N  
ATOM    613  CA  TYR A  83      42.170  20.663  73.373  1.00 25.64           C  
ATOM    614  C   TYR A  83      42.898  20.789  72.038  1.00 26.13           C  
ATOM    615  O   TYR A  83      42.341  20.448  71.000  1.00 26.01           O  
ATOM    616  CB  TYR A  83      41.726  22.035  73.912  1.00 25.88           C  
ATOM    617  CG  TYR A  83      40.884  22.866  72.962  1.00 25.13           C  
ATOM    618  CD1 TYR A  83      39.491  22.800  72.990  1.00 24.21           C  
ATOM    619  CD2 TYR A  83      41.485  23.749  72.058  1.00 25.93           C  
ATOM    620  CE1 TYR A  83      38.708  23.575  72.119  1.00 23.70           C  
ATOM    621  CE2 TYR A  83      40.719  24.519  71.179  1.00 24.24           C  
ATOM    622  CZ  TYR A  83      39.341  24.440  71.220  1.00 25.36           C  
ATOM    623  OH  TYR A  83      38.598  25.225  70.360  1.00 25.10           O  
ATOM    624  N   TRP A  84      44.139  21.278  72.065  1.00 26.47           N  
ATOM    625  CA  TRP A  84      44.936  21.406  70.838  1.00 27.35           C  
ATOM    626  C   TRP A  84      45.160  20.045  70.169  1.00 28.71           C  
ATOM    627  O   TRP A  84      45.101  19.928  68.943  1.00 29.16           O  
ATOM    628  CB  TRP A  84      46.282  22.119  71.097  1.00 26.56           C  
ATOM    629  CG  TRP A  84      46.405  23.383  70.299  1.00 26.35           C  
ATOM    630  CD1 TRP A  84      47.133  23.574  69.160  1.00 26.55           C  
ATOM    631  CD2 TRP A  84      45.746  24.626  70.566  1.00 26.21           C  
ATOM    632  NE1 TRP A  84      46.972  24.861  68.697  1.00 27.00           N  
ATOM    633  CE2 TRP A  84      46.130  25.534  69.547  1.00 26.48           C  
ATOM    634  CE3 TRP A  84      44.878  25.076  71.581  1.00 26.32           C  
ATOM    635  CZ2 TRP A  84      45.670  26.859  69.500  1.00 26.37           C  
ATOM    636  CZ3 TRP A  84      44.418  26.396  71.532  1.00 24.06           C  
ATOM    637  CH2 TRP A  84      44.814  27.267  70.502  1.00 26.37           C  
ATOM    638  N   GLU A  85      45.403  19.020  70.980  1.00 29.81           N  
ATOM    639  CA  GLU A  85      45.648  17.679  70.446  1.00 31.46           C  
ATOM    640  C   GLU A  85      44.408  17.133  69.739  1.00 31.34           C  
ATOM    641  O   GLU A  85      44.503  16.566  68.638  1.00 31.75           O  
ATOM    642  CB  GLU A  85      46.110  16.735  71.556  1.00 32.11           C  
ATOM    643  CG  GLU A  85      47.577  16.911  71.915  1.00 36.48           C  
ATOM    644  CD  GLU A  85      47.943  16.346  73.280  1.00 41.47           C  
ATOM    645  OE1 GLU A  85      47.211  15.476  73.808  1.00 42.90           O  
ATOM    646  OE2 GLU A  85      48.980  16.777  73.833  1.00 43.52           O  
ATOM    647  N   SER A  86      43.247  17.355  70.355  1.00 30.87           N  
ATOM    648  CA  SER A  86      41.982  16.763  69.917  1.00 30.40           C  
ATOM    649  C   SER A  86      41.157  17.631  68.948  1.00 30.62           C  
ATOM    650  O   SER A  86      40.170  17.150  68.396  1.00 29.89           O  
ATOM    651  CB  SER A  86      41.120  16.442  71.146  1.00 30.21           C  
ATOM    652  OG  SER A  86      40.759  17.653  71.795  1.00 29.86           O  
ATOM    653  N   HIS A  87      41.541  18.894  68.761  1.00 30.30           N  
ATOM    654  CA  HIS A  87      40.811  19.811  67.869  1.00 31.45           C  
ATOM    655  C   HIS A  87      41.666  20.292  66.689  1.00 32.81           C  
ATOM    656  O   HIS A  87      41.436  21.380  66.136  1.00 32.42           O  
ATOM    657  CB  HIS A  87      40.233  21.018  68.647  1.00 30.58           C  
ATOM    658  CG  HIS A  87      39.157  20.653  69.622  1.00 29.82           C  
ATOM    659  ND1 HIS A  87      39.411  19.971  70.794  1.00 30.48           N  
ATOM    660  CD2 HIS A  87      37.822  20.875  69.600  1.00 28.35           C  
ATOM    661  CE1 HIS A  87      38.278  19.777  71.446  1.00 31.27           C  
ATOM    662  NE2 HIS A  87      37.298  20.316  70.744  1.00 30.67           N  
ATOM    663  N   GLN A  88      42.632  19.465  66.293  1.00 34.58           N  
ATOM    664  CA  GLN A  88      43.596  19.832  65.247  1.00 36.74           C  
ATOM    665  C   GLN A  88      42.917  20.257  63.952  1.00 37.37           C  
ATOM    666  O   GLN A  88      43.352  21.202  63.298  1.00 37.98           O  
ATOM    667  CB  GLN A  88      44.596  18.700  64.980  1.00 36.93           C  
ATOM    668  CG  GLN A  88      45.862  18.781  65.818  1.00 39.73           C  
ATOM    669  CD  GLN A  88      46.571  20.133  65.695  1.00 44.42           C  
ATOM    670  OE1 GLN A  88      47.276  20.381  64.709  1.00 46.33           O  
ATOM    671  NE2 GLN A  88      46.380  21.011  66.690  1.00 44.59           N  
ATOM    672  N   HIS A  89      41.826  19.583  63.614  1.00 38.35           N  
ATOM    673  CA  HIS A  89      41.096  19.869  62.390  1.00 39.16           C  
ATOM    674  C   HIS A  89      40.271  21.152  62.506  1.00 38.81           C  
ATOM    675  O   HIS A  89      40.152  21.922  61.553  1.00 39.08           O  
ATOM    676  CB  HIS A  89      40.197  18.681  62.057  1.00 40.10           C  
ATOM    677  CG  HIS A  89      39.412  18.856  60.801  1.00 42.37           C  
ATOM    678  ND1 HIS A  89      38.062  19.128  60.807  1.00 44.97           N  
ATOM    679  CD2 HIS A  89      39.787  18.809  59.499  1.00 45.45           C  
ATOM    680  CE1 HIS A  89      37.636  19.236  59.560  1.00 46.64           C  
ATOM    681  NE2 HIS A  89      38.662  19.048  58.748  1.00 45.21           N  
ATOM    682  N   GLU A  90      39.713  21.374  63.691  1.00 38.25           N  
ATOM    683  CA  GLU A  90      38.832  22.509  63.946  1.00 37.47           C  
ATOM    684  C   GLU A  90      39.589  23.829  64.144  1.00 36.11           C  
ATOM    685  O   GLU A  90      39.045  24.897  63.853  1.00 35.74           O  
ATOM    686  CB  GLU A  90      37.932  22.213  65.151  1.00 37.81           C  
ATOM    687  CG  GLU A  90      37.067  20.969  64.964  1.00 41.15           C  
ATOM    688  CD  GLU A  90      37.620  19.726  65.644  1.00 43.95           C  
ATOM    689  OE1 GLU A  90      38.733  19.270  65.291  1.00 43.51           O  
ATOM    690  OE2 GLU A  90      36.922  19.194  66.540  1.00 47.68           O  
ATOM    691  N   ILE A  91      40.827  23.759  64.641  1.00 34.88           N  
ATOM    692  CA  ILE A  91      41.649  24.966  64.816  1.00 33.50           C  
ATOM    693  C   ILE A  91      42.236  25.415  63.472  1.00 34.07           C  
ATOM    694  O   ILE A  91      43.174  24.821  62.952  1.00 34.35           O  
ATOM    695  CB  ILE A  91      42.762  24.774  65.892  1.00 33.00           C  
ATOM    696  CG1 ILE A  91      42.148  24.482  67.275  1.00 31.55           C  
ATOM    697  CG2 ILE A  91      43.678  26.008  65.954  1.00 30.69           C  
ATOM    698  CD1 ILE A  91      43.030  23.643  68.193  1.00 28.04           C  
ATOM    699  N   GLN A  92      41.674  26.481  62.923  1.00 34.63           N  
ATOM    700  CA  GLN A  92      42.008  26.926  61.572  1.00 35.26           C  
ATOM    701  C   GLN A  92      42.243  28.432  61.543  1.00 34.88           C  
ATOM    702  O   GLN A  92      41.615  29.172  62.313  1.00 34.98           O  
ATOM    703  CB  GLN A  92      40.884  26.541  60.594  1.00 35.71           C  
ATOM    704  CG  GLN A  92      40.712  25.021  60.378  1.00 37.98           C  
ATOM    705  CD  GLN A  92      41.895  24.375  59.660  1.00 40.78           C  
ATOM    706  OE1 GLN A  92      42.506  24.988  58.791  1.00 43.56           O  
ATOM    707  NE2 GLN A  92      42.214  23.137  60.027  1.00 41.74           N  
ATOM    708  N   PRO A  93      43.131  28.885  60.660  1.00 34.72           N  
ATOM    709  CA  PRO A  93      43.454  30.313  60.556  1.00 34.50           C  
ATOM    710  C   PRO A  93      42.359  31.094  59.850  1.00 34.13           C  
ATOM    711  O   PRO A  93      42.454  31.339  58.639  1.00 35.13           O  
ATOM    712  CB  PRO A  93      44.745  30.322  59.730  1.00 34.77           C  
ATOM    713  CG  PRO A  93      44.648  29.082  58.867  1.00 34.54           C  
ATOM    714  CD  PRO A  93      43.903  28.072  59.698  1.00 35.17           C  
ATOM    715  N   LEU A  94      41.348  31.504  60.606  1.00 32.74           N  
ATOM    716  CA  LEU A  94      40.222  32.253  60.055  1.00 31.59           C  
ATOM    717  C   LEU A  94      40.663  33.595  59.480  1.00 30.99           C  
ATOM    718  O   LEU A  94      40.185  34.020  58.416  1.00 31.14           O  
ATOM    719  CB  LEU A  94      39.128  32.443  61.120  1.00 31.71           C  
ATOM    720  CG  LEU A  94      38.623  31.179  61.834  1.00 31.95           C  
ATOM    721  CD1 LEU A  94      37.548  31.552  62.842  1.00 32.84           C  
ATOM    722  CD2 LEU A  94      38.106  30.125  60.858  1.00 34.29           C  
ATOM    723  N   THR A  95      41.560  34.269  60.194  1.00 29.70           N  
ATOM    724  CA  THR A  95      42.264  35.443  59.667  1.00 28.66           C  
ATOM    725  C   THR A  95      43.729  35.288  59.976  1.00 28.94           C  
ATOM    726  O   THR A  95      44.131  34.330  60.657  1.00 28.46           O  
ATOM    727  CB  THR A  95      41.764  36.772  60.312  1.00 28.22           C  
ATOM    728  OG1 THR A  95      42.155  36.818  61.694  1.00 26.41           O  
ATOM    729  CG2 THR A  95      40.260  36.849  60.328  1.00 28.19           C  
ATOM    730  N   ARG A  96      44.523  36.255  59.512  1.00 28.74           N  
ATOM    731  CA  ARG A  96      45.947  36.294  59.823  1.00 29.17           C  
ATOM    732  C   ARG A  96      46.225  36.462  61.333  1.00 28.46           C  
ATOM    733  O   ARG A  96      47.355  36.278  61.785  1.00 27.97           O  
ATOM    734  CB  ARG A  96      46.610  37.432  59.038  1.00 29.61           C  
ATOM    735  CG  ARG A  96      46.088  38.816  59.404  1.00 32.07           C  
ATOM    736  CD  ARG A  96      46.786  39.964  58.686  1.00 37.68           C  
ATOM    737  NE  ARG A  96      46.213  41.262  59.050  1.00 40.85           N  
ATOM    738  CZ  ARG A  96      45.533  42.056  58.211  1.00 44.92           C  
ATOM    739  NH1 ARG A  96      45.331  41.697  56.945  1.00 45.71           N  
ATOM    740  NH2 ARG A  96      45.048  43.220  58.638  1.00 44.85           N  
ATOM    741  N   ASN A  97      45.191  36.819  62.097  1.00 27.80           N  
ATOM    742  CA  ASN A  97      45.315  37.088  63.531  1.00 27.46           C  
ATOM    743  C   ASN A  97      44.854  35.954  64.437  1.00 26.99           C  
ATOM    744  O   ASN A  97      45.132  35.983  65.634  1.00 26.24           O  
ATOM    745  CB  ASN A  97      44.543  38.357  63.909  1.00 27.17           C  
ATOM    746  CG  ASN A  97      44.957  39.551  63.068  1.00 28.65           C  
ATOM    747  OD1 ASN A  97      46.139  39.904  63.028  1.00 28.75           O  
ATOM    748  ND2 ASN A  97      43.993  40.171  62.385  1.00 25.73           N  
ATOM    749  N   THR A  98      44.165  34.968  63.869  1.00 26.84           N  
ATOM    750  CA  THR A  98      43.640  33.844  64.649  1.00 27.14           C  
ATOM    751  C   THR A  98      44.784  33.142  65.358  1.00 27.54           C  
ATOM    752  O   THR A  98      45.853  32.950  64.769  1.00 27.35           O  
ATOM    753  CB  THR A  98      42.917  32.849  63.737  1.00 26.87           C  
ATOM    754  OG1 THR A  98      41.980  33.556  62.917  1.00 27.44           O  
ATOM    755  CG2 THR A  98      42.059  31.877  64.574  1.00 25.95           C  
ATOM    756  N   ILE A  99      44.555  32.756  66.617  1.00 27.44           N  
ATOM    757  CA  ILE A  99      45.581  32.103  67.397  1.00 27.56           C  
ATOM    758  C   ILE A  99      45.472  30.603  67.152  1.00 28.02           C  
ATOM    759  O   ILE A  99      44.544  29.950  67.650  1.00 28.28           O  
ATOM    760  CB  ILE A  99      45.454  32.454  68.904  1.00 27.70           C  
ATOM    761  CG1 ILE A  99      45.496  33.979  69.117  1.00 26.45           C  
ATOM    762  CG2 ILE A  99      46.570  31.776  69.700  1.00 27.36           C  
ATOM    763  CD1 ILE A  99      45.032  34.425  70.505  1.00 27.03           C  
ATOM    764  N   THR A 100      46.413  30.070  66.371  1.00 28.33           N  
ATOM    765  CA  THR A 100      46.399  28.655  65.975  1.00 28.99           C  
ATOM    766  C   THR A 100      47.523  27.809  66.584  1.00 29.58           C  
ATOM    767  O   THR A 100      47.483  26.575  66.487  1.00 29.07           O  
ATOM    768  CB  THR A 100      46.420  28.493  64.434  1.00 29.01           C  
ATOM    769  OG1 THR A 100      47.575  29.147  63.891  1.00 28.68           O  
ATOM    770  CG2 THR A 100      45.241  29.219  63.792  1.00 29.51           C  
ATOM    771  N   GLU A 101      48.508  28.471  67.198  1.00 30.06           N  
ATOM    772  CA  GLU A 101      49.655  27.810  67.811  1.00 30.90           C  
ATOM    773  C   GLU A 101      49.516  27.784  69.326  1.00 30.31           C  
ATOM    774  O   GLU A 101      49.190  28.802  69.955  1.00 29.99           O  
ATOM    775  CB  GLU A 101      50.968  28.514  67.425  1.00 31.59           C  
ATOM    776  CG  GLU A 101      51.120  28.796  65.935  1.00 35.93           C  
ATOM    777  CD  GLU A 101      52.345  29.657  65.614  1.00 43.22           C  
ATOM    778  OE1 GLU A 101      52.618  30.660  66.339  1.00 46.43           O  
ATOM    779  OE2 GLU A 101      53.045  29.331  64.623  1.00 45.00           O  
ATOM    780  N   LEU A 102      49.777  26.617  69.909  1.00 29.65           N  
ATOM    781  CA  LEU A 102      49.642  26.429  71.355  1.00 29.04           C  
ATOM    782  C   LEU A 102      50.477  27.378  72.234  1.00 28.26           C  
ATOM    783  O   LEU A 102      49.955  27.920  73.221  1.00 28.15           O  
ATOM    784  CB  LEU A 102      49.900  24.962  71.727  1.00 29.31           C  
ATOM    785  CG  LEU A 102      49.630  24.530  73.167  1.00 29.52           C  
ATOM    786  CD1 LEU A 102      48.199  24.928  73.589  1.00 28.58           C  
ATOM    787  CD2 LEU A 102      49.857  23.033  73.316  1.00 29.02           C  
ATOM    788  N   PRO A 103      51.770  27.558  71.939  1.00 28.04           N  
ATOM    789  CA  PRO A 103      52.581  28.481  72.752  1.00 27.14           C  
ATOM    790  C   PRO A 103      52.000  29.898  72.762  1.00 26.26           C  
ATOM    791  O   PRO A 103      51.920  30.491  73.832  1.00 25.01           O  
ATOM    792  CB  PRO A 103      53.957  28.429  72.081  1.00 27.57           C  
ATOM    793  CG  PRO A 103      53.976  27.049  71.428  1.00 28.42           C  
ATOM    794  CD  PRO A 103      52.584  26.879  70.902  1.00 27.55           C  
ATOM    795  N   ALA A 104      51.610  30.403  71.591  1.00 25.52           N  
ATOM    796  CA  ALA A 104      50.953  31.698  71.466  1.00 24.56           C  
ATOM    797  C   ALA A 104      49.662  31.744  72.283  1.00 23.88           C  
ATOM    798  O   ALA A 104      49.377  32.757  72.921  1.00 23.71           O  
ATOM    799  CB  ALA A 104      50.672  32.026  69.998  1.00 24.86           C  
ATOM    800  N   MET A 105      48.896  30.649  72.280  1.00 22.98           N  
ATOM    801  CA  MET A 105      47.661  30.633  73.056  1.00 22.18           C  
ATOM    802  C   MET A 105      47.932  30.716  74.565  1.00 22.26           C  
ATOM    803  O   MET A 105      47.251  31.460  75.284  1.00 21.38           O  
ATOM    804  CB  MET A 105      46.774  29.427  72.736  1.00 21.82           C  
ATOM    805  CG  MET A 105      45.421  29.455  73.518  1.00 19.46           C  
ATOM    806  SD  MET A 105      44.345  30.935  73.353  1.00  7.25           S  
ATOM    807  CE  MET A 105      43.573  30.538  71.811  1.00 19.90           C  
ATOM    808  N   PHE A 106      48.933  29.979  75.039  1.00 22.16           N  
ATOM    809  CA  PHE A 106      49.268  30.019  76.465  1.00 22.91           C  
ATOM    810  C   PHE A 106      49.674  31.434  76.894  1.00 23.13           C  
ATOM    811  O   PHE A 106      49.320  31.883  77.987  1.00 23.19           O  
ATOM    812  CB  PHE A 106      50.381  29.010  76.802  1.00 23.48           C  
ATOM    813  CG  PHE A 106      49.868  27.646  77.171  1.00 24.79           C  
ATOM    814  CD1 PHE A 106      48.950  27.488  78.194  1.00 26.20           C  
ATOM    815  CD2 PHE A 106      50.303  26.515  76.480  1.00 28.19           C  
ATOM    816  CE1 PHE A 106      48.478  26.219  78.535  1.00 27.89           C  
ATOM    817  CE2 PHE A 106      49.831  25.247  76.809  1.00 28.69           C  
ATOM    818  CZ  PHE A 106      48.924  25.101  77.842  1.00 27.67           C  
ATOM    819  N   ASP A 107      50.416  32.126  76.029  1.00 23.02           N  
ATOM    820  CA  ASP A 107      50.839  33.500  76.308  1.00 23.84           C  
ATOM    821  C   ASP A 107      49.612  34.385  76.441  1.00 22.80           C  
ATOM    822  O   ASP A 107      49.491  35.169  77.375  1.00 22.46           O  
ATOM    823  CB  ASP A 107      51.717  34.021  75.175  1.00 24.69           C  
ATOM    824  CG  ASP A 107      53.149  33.518  75.259  1.00 30.23           C  
ATOM    825  OD1 ASP A 107      53.527  32.887  76.284  1.00 35.00           O  
ATOM    826  OD2 ASP A 107      53.975  33.724  74.337  1.00 34.21           O  
ATOM    827  N   GLU A 108      48.699  34.236  75.484  1.00 22.06           N  
ATOM    828  CA  GLU A 108      47.430  34.959  75.499  1.00 21.45           C  
ATOM    829  C   GLU A 108      46.625  34.646  76.762  1.00 20.94           C  
ATOM    830  O   GLU A 108      46.092  35.548  77.410  1.00 20.96           O  
ATOM    831  CB  GLU A 108      46.610  34.578  74.259  1.00 22.20           C  
ATOM    832  CG  GLU A 108      45.167  35.079  74.291  1.00 22.90           C  
ATOM    833  CD  GLU A 108      44.992  36.445  73.650  1.00 27.39           C  
ATOM    834  OE1 GLU A 108      46.005  37.135  73.416  1.00 32.04           O  
ATOM    835  OE2 GLU A 108      43.832  36.846  73.372  1.00 25.94           O  
ATOM    836  N   LEU A 109      46.528  33.365  77.098  1.00 20.39           N  
ATOM    837  CA  LEU A 109      45.716  32.935  78.221  1.00 20.38           C  
ATOM    838  C   LEU A 109      46.266  33.434  79.550  1.00 19.93           C  
ATOM    839  O   LEU A 109      45.497  33.738  80.443  1.00 19.75           O  
ATOM    840  CB  LEU A 109      45.560  31.408  78.238  1.00 19.87           C  
ATOM    841  CG  LEU A 109      44.721  30.789  77.113  1.00 20.79           C  
ATOM    842  CD1 LEU A 109      44.658  29.274  77.312  1.00 20.50           C  
ATOM    843  CD2 LEU A 109      43.321  31.401  77.053  1.00 19.46           C  
ATOM    844  N   ALA A 110      47.592  33.505  79.673  1.00 20.12           N  
ATOM    845  CA  ALA A 110      48.202  34.090  80.869  1.00 20.43           C  
ATOM    846  C   ALA A 110      47.787  35.550  81.060  1.00 20.69           C  
ATOM    847  O   ALA A 110      47.440  35.938  82.161  1.00 20.61           O  
ATOM    848  CB  ALA A 110      49.720  33.952  80.815  1.00 20.25           C  
ATOM    849  N   HIS A 111      47.807  36.355  79.989  1.00 20.91           N  
ATOM    850  CA  HIS A 111      47.353  37.736  80.067  1.00 21.45           C  
ATOM    851  C   HIS A 111      45.886  37.842  80.472  1.00 20.47           C  
ATOM    852  O   HIS A 111      45.529  38.724  81.262  1.00 20.44           O  
ATOM    853  CB  HIS A 111      47.570  38.506  78.748  1.00 22.40           C  
ATOM    854  CG  HIS A 111      49.008  38.662  78.353  1.00 27.88           C  
ATOM    855  ND1 HIS A 111      49.996  39.037  79.241  1.00 33.55           N  
ATOM    856  CD2 HIS A 111      49.624  38.504  77.156  1.00 32.49           C  
ATOM    857  CE1 HIS A 111      51.155  39.098  78.612  1.00 33.56           C  
ATOM    858  NE2 HIS A 111      50.958  38.778  77.345  1.00 34.57           N  
ATOM    859  N   ILE A 112      45.025  36.999  79.888  1.00 19.38           N  
ATOM    860  CA  ILE A 112      43.596  36.998  80.257  1.00 18.75           C  
ATOM    861  C   ILE A 112      43.360  36.619  81.726  1.00 18.43           C  
ATOM    862  O   ILE A 112      42.551  37.244  82.419  1.00 18.69           O  
ATOM    863  CB  ILE A 112      42.783  36.039  79.317  1.00 18.89           C  
ATOM    864  CG1 ILE A 112      42.808  36.582  77.877  1.00 19.60           C  
ATOM    865  CG2 ILE A 112      41.345  35.912  79.802  1.00 17.47           C  
ATOM    866  CD1 ILE A 112      42.482  35.502  76.799  1.00 22.32           C  
ATOM    867  N   ARG A 113      44.047  35.572  82.183  1.00 17.90           N  
ATOM    868  CA  ARG A 113      43.912  35.100  83.569  1.00 18.24           C  
ATOM    869  C   ARG A 113      44.355  36.176  84.573  1.00 18.72           C  
ATOM    870  O   ARG A 113      43.705  36.407  85.601  1.00 18.26           O  
ATOM    871  CB  ARG A 113      44.691  33.792  83.768  1.00 17.96           C  
ATOM    872  CG  ARG A 113      44.631  33.212  85.212  1.00 16.99           C  
ATOM    873  CD  ARG A 113      43.204  32.885  85.712  1.00 16.07           C  
ATOM    874  NE  ARG A 113      43.218  32.452  87.119  1.00 19.30           N  
ATOM    875  CZ  ARG A 113      43.155  33.274  88.166  1.00 21.16           C  
ATOM    876  NH1 ARG A 113      43.053  34.582  87.975  1.00 18.62           N  
ATOM    877  NH2 ARG A 113      43.170  32.787  89.414  1.00 20.16           N  
ATOM    878  N   GLU A 114      45.436  36.869  84.240  1.00 19.42           N  
ATOM    879  CA  GLU A 114      45.944  37.941  85.094  1.00 20.04           C  
ATOM    880  C   GLU A 114      45.001  39.150  85.144  1.00 20.21           C  
ATOM    881  O   GLU A 114      44.678  39.654  86.220  1.00 20.08           O  
ATOM    882  CB  GLU A 114      47.334  38.373  84.608  1.00 20.46           C  
ATOM    883  CG  GLU A 114      48.417  37.359  84.941  1.00 21.89           C  
ATOM    884  CD  GLU A 114      49.549  37.375  83.944  1.00 24.44           C  
ATOM    885  OE1 GLU A 114      49.682  38.367  83.196  1.00 26.86           O  
ATOM    886  OE2 GLU A 114      50.302  36.386  83.914  1.00 25.61           O  
ATOM    887  N   SER A 115      44.569  39.619  83.971  1.00 20.11           N  
ATOM    888  CA  SER A 115      43.794  40.855  83.875  1.00 20.31           C  
ATOM    889  C   SER A 115      42.295  40.664  84.053  1.00 20.51           C  
ATOM    890  O   SER A 115      41.583  41.622  84.384  1.00 19.88           O  
ATOM    891  CB  SER A 115      44.037  41.532  82.514  1.00 20.49           C  
ATOM    892  OG  SER A 115      43.399  40.777  81.498  1.00 20.86           O  
ATOM    893  N   GLY A 116      41.806  39.453  83.808  1.00 20.17           N  
ATOM    894  CA  GLY A 116      40.369  39.201  83.875  1.00 20.82           C  
ATOM    895  C   GLY A 116      39.580  39.753  82.686  1.00 21.00           C  
ATOM    896  O   GLY A 116      38.389  40.073  82.809  1.00 21.85           O  
ATOM    897  N   ALA A 117      40.249  39.894  81.546  1.00 20.67           N  
ATOM    898  CA  ALA A 117      39.614  40.386  80.310  1.00 20.29           C  
ATOM    899  C   ALA A 117      40.273  39.802  79.082  1.00 19.82           C  
ATOM    900  O   ALA A 117      41.473  39.509  79.089  1.00 19.49           O  
ATOM    901  CB  ALA A 117      39.656  41.923  80.241  1.00 20.28           C  
ATOM    902  N   ALA A 118      39.492  39.660  78.012  1.00 19.35           N  
ATOM    903  CA  ALA A 118      39.992  39.165  76.749  1.00 19.61           C  
ATOM    904  C   ALA A 118      39.510  40.036  75.598  1.00 19.83           C  
ATOM    905  O   ALA A 118      38.509  40.740  75.716  1.00 20.81           O  
ATOM    906  CB  ALA A 118      39.514  37.732  76.530  1.00 18.92           C  
ATOM    907  N   MET A 119      40.211  39.955  74.477  1.00 20.77           N  
ATOM    908  CA  MET A 119      39.731  40.592  73.264  1.00 20.92           C  
ATOM    909  C   MET A 119      39.699  39.595  72.135  1.00 21.50           C  
ATOM    910  O   MET A 119      40.444  38.601  72.142  1.00 21.97           O  
ATOM    911  CB  MET A 119      40.634  41.780  72.898  1.00 20.66           C  
ATOM    912  CG  MET A 119      40.248  43.087  73.608  1.00 22.11           C  
ATOM    913  SD  MET A 119      41.183  44.513  72.903  1.00 16.82           S  
ATOM    914  CE  MET A 119      40.183  45.092  72.196  1.00 22.13           C  
ATOM    915  N   ASP A 120      38.802  39.839  71.183  1.00 21.95           N  
ATOM    916  CA  ASP A 120      38.933  39.249  69.876  1.00 21.83           C  
ATOM    917  C   ASP A 120      39.520  40.366  69.022  1.00 21.90           C  
ATOM    918  O   ASP A 120      38.841  41.347  68.725  1.00 21.99           O  
ATOM    919  CB  ASP A 120      37.574  38.785  69.348  1.00 22.26           C  
ATOM    920  CG  ASP A 120      37.598  38.486  67.852  1.00 23.22           C  
ATOM    921  OD1 ASP A 120      38.711  38.419  67.258  1.00 22.33           O  
ATOM    922  OD2 ASP A 120      36.545  38.330  67.193  1.00 24.34           O  
ATOM    923  N   ARG A 121      40.794  40.222  68.672  1.00 22.60           N  
ATOM    924  CA  ARG A 121      41.516  41.231  67.900  1.00 23.66           C  
ATOM    925  C   ARG A 121      41.502  40.808  66.441  1.00 23.66           C  
ATOM    926  O   ARG A 121      42.525  40.343  65.894  1.00 23.77           O  
ATOM    927  CB  ARG A 121      42.960  41.392  68.416  1.00 24.03           C  
ATOM    928  CG  ARG A 121      43.043  41.953  69.829  1.00 26.54           C  
ATOM    929  CD  ARG A 121      44.473  42.032  70.423  1.00 31.31           C  
ATOM    930  NE  ARG A 121      44.405  42.389  71.841  1.00 35.95           N  
ATOM    931  CZ  ARG A 121      44.301  41.508  72.844  1.00 38.62           C  
ATOM    932  NH1 ARG A 121      44.285  40.204  72.603  1.00 38.87           N  
ATOM    933  NH2 ARG A 121      44.216  41.934  74.100  1.00 40.79           N  
ATOM    934  N   GLU A 122      40.331  40.959  65.816  1.00 23.69           N  
ATOM    935  CA  GLU A 122      40.126  40.541  64.415  1.00 23.65           C  
ATOM    936  C   GLU A 122      40.586  39.099  64.134  1.00 23.86           C  
ATOM    937  O   GLU A 122      41.232  38.815  63.103  1.00 22.64           O  
ATOM    938  CB  GLU A 122      40.822  41.524  63.465  1.00 24.03           C  
ATOM    939  CG  GLU A 122      40.419  42.979  63.668  1.00 24.56           C  
ATOM    940  CD  GLU A 122      41.184  43.895  62.725  1.00 26.30           C  
ATOM    941  OE1 GLU A 122      42.245  44.400  63.127  1.00 28.46           O  
ATOM    942  OE2 GLU A 122      40.735  44.072  61.577  1.00 25.99           O  
ATOM    943  N   GLU A 123      40.260  38.198  65.061  1.00 23.39           N  
ATOM    944  CA  GLU A 123      40.615  36.783  64.945  1.00 23.60           C  
ATOM    945  C   GLU A 123      39.546  35.955  64.228  1.00 24.24           C  
ATOM    946  O   GLU A 123      39.797  34.810  63.855  1.00 25.04           O  
ATOM    947  CB  GLU A 123      40.891  36.183  66.332  1.00 23.34           C  
ATOM    948  CG  GLU A 123      42.089  36.816  67.027  1.00 22.69           C  
ATOM    949  CD  GLU A 123      42.011  36.709  68.544  1.00 22.18           C  
ATOM    950  OE1 GLU A 123      41.701  35.606  69.051  1.00 21.37           O  
ATOM    951  OE2 GLU A 123      42.231  37.741  69.210  1.00 22.10           O  
ATOM    952  N   ASN A 124      38.356  36.525  64.045  1.00 25.07           N  
ATOM    953  CA  ASN A 124      37.293  35.861  63.291  1.00 25.80           C  
ATOM    954  C   ASN A 124      37.077  36.483  61.925  1.00 26.45           C  
ATOM    955  O   ASN A 124      36.936  35.777  60.932  1.00 25.82           O  
ATOM    956  CB  ASN A 124      35.982  35.901  64.060  1.00 26.18           C  
ATOM    957  CG  ASN A 124      35.985  34.959  65.217  1.00 26.95           C  
ATOM    958  OD1 ASN A 124      35.674  33.767  65.069  1.00 27.83           O  
ATOM    959  ND2 ASN A 124      36.352  35.472  66.384  1.00 25.60           N  
ATOM    960  N   GLU A 125      37.051  37.811  61.897  1.00 27.01           N  
ATOM    961  CA  GLU A 125      36.873  38.564  60.668  1.00 27.98           C  
ATOM    962  C   GLU A 125      37.560  39.915  60.803  1.00 28.04           C  
ATOM    963  O   GLU A 125      37.440  40.590  61.838  1.00 27.46           O  
ATOM    964  CB  GLU A 125      35.383  38.753  60.362  1.00 28.50           C  
ATOM    965  CG  GLU A 125      35.113  39.591  59.126  1.00 31.42           C  
ATOM    966  CD  GLU A 125      33.642  39.859  58.898  1.00 35.06           C  
ATOM    967  OE1 GLU A 125      32.785  39.124  59.444  1.00 37.12           O  
ATOM    968  OE2 GLU A 125      33.351  40.808  58.150  1.00 38.01           O  
ATOM    969  N   LEU A 126      38.287  40.311  59.758  1.00 27.20           N  
ATOM    970  CA  LEU A 126      38.923  41.618  59.772  1.00 27.40           C  
ATOM    971  C   LEU A 126      37.844  42.663  59.918  1.00 26.75           C  
ATOM    972  O   LEU A 126      36.736  42.495  59.390  1.00 26.39           O  
ATOM    973  CB  LEU A 126      39.752  41.868  58.503  1.00 27.89           C  
ATOM    974  CG  LEU A 126      40.954  40.943  58.283  1.00 29.10           C  
ATOM    975  CD1 LEU A 126      41.701  41.372  57.016  1.00 30.90           C  
ATOM    976  CD2 LEU A 126      41.908  40.910  59.484  1.00 28.30           C  
ATOM    977  N   GLY A 127      38.161  43.718  60.667  1.00 25.63           N  
ATOM    978  CA  GLY A 127      37.206  44.783  60.926  1.00 25.43           C  
ATOM    979  C   GLY A 127      36.223  44.554  62.066  1.00 24.82           C  
ATOM    980  O   GLY A 127      35.451  45.445  62.389  1.00 24.51           O  
ATOM    981  N   VAL A 128      36.243  43.366  62.666  1.00 24.06           N  
ATOM    982  CA  VAL A 128      35.366  43.040  63.782  1.00 23.31           C  
ATOM    983  C   VAL A 128      36.245  42.717  64.992  1.00 22.86           C  
ATOM    984  O   VAL A 128      37.146  41.868  64.898  1.00 23.18           O  
ATOM    985  CB  VAL A 128      34.454  41.822  63.468  1.00 23.61           C  
ATOM    986  CG1 VAL A 128      33.567  41.449  64.678  1.00 22.57           C  
ATOM    987  CG2 VAL A 128      33.610  42.077  62.200  1.00 23.54           C  
ATOM    988  N   SER A 129      35.982  43.415  66.099  1.00 22.13           N  
ATOM    989  CA  SER A 129      36.679  43.211  67.376  1.00 22.15           C  
ATOM    990  C   SER A 129      35.681  42.947  68.495  1.00 22.31           C  
ATOM    991  O   SER A 129      34.509  43.315  68.372  1.00 22.13           O  
ATOM    992  CB  SER A 129      37.495  44.453  67.716  1.00 22.23           C  
ATOM    993  OG  SER A 129      38.487  44.662  66.725  1.00 22.05           O  
ATOM    994  N   CYS A 130      36.123  42.309  69.583  1.00 21.72           N  
ATOM    995  CA  CYS A 130      35.263  42.151  70.756  1.00 23.49           C  
ATOM    996  C   CYS A 130      36.060  42.351  72.034  1.00 21.79           C  
ATOM    997  O   CYS A 130      37.290  42.177  72.039  1.00 21.11           O  
ATOM    998  CB  CYS A 130      34.616  40.754  70.779  1.00 24.69           C  
ATOM    999  SG  CYS A 130      33.851  40.353  69.190  1.00 36.30           S  
ATOM   1000  N   ILE A 131      35.357  42.721  73.108  1.00 20.89           N  
ATOM   1001  CA  ILE A 131      35.963  42.773  74.462  1.00 19.91           C  
ATOM   1002  C   ILE A 131      35.086  41.896  75.340  1.00 19.24           C  
ATOM   1003  O   ILE A 131      33.864  42.017  75.286  1.00 18.66           O  
ATOM   1004  CB  ILE A 131      35.964  44.211  75.035  1.00 20.02           C  
ATOM   1005  CG1 ILE A 131      36.535  45.213  74.034  1.00 21.72           C  
ATOM   1006  CG2 ILE A 131      36.780  44.282  76.361  1.00 19.46           C  
ATOM   1007  CD1 ILE A 131      36.101  46.656  74.325  1.00 23.74           C  
ATOM   1008  N   ALA A 132      35.692  41.031  76.153  1.00 17.89           N  
ATOM   1009  CA  ALA A 132      34.916  40.070  76.939  1.00 17.66           C  
ATOM   1010  C   ALA A 132      35.427  40.017  78.384  1.00 17.86           C  
ATOM   1011  O   ALA A 132      36.612  40.299  78.653  1.00 18.43           O  
ATOM   1012  CB  ALA A 132      34.986  38.680  76.297  1.00 17.03           C  
ATOM   1013  N   VAL A 133      34.520  39.686  79.303  1.00 18.72           N  
ATOM   1014  CA  VAL A 133      34.840  39.517  80.719  1.00 18.51           C  
ATOM   1015  C   VAL A 133      34.149  38.263  81.293  1.00 19.01           C  
ATOM   1016  O   VAL A 133      33.104  37.841  80.800  1.00 18.53           O  
ATOM   1017  CB  VAL A 133      34.417  40.754  81.579  1.00 19.05           C  
ATOM   1018  CG1 VAL A 133      35.262  41.980  81.253  1.00 19.13           C  
ATOM   1019  CG2 VAL A 133      32.913  41.051  81.434  1.00 19.15           C  
ATOM   1020  N   PRO A 134      34.728  37.673  82.339  1.00 19.41           N  
ATOM   1021  CA  PRO A 134      34.091  36.557  83.057  1.00 19.42           C  
ATOM   1022  C   PRO A 134      32.943  37.001  83.966  1.00 20.01           C  
ATOM   1023  O   PRO A 134      32.943  38.141  84.423  1.00 20.03           O  
ATOM   1024  CB  PRO A 134      35.239  36.004  83.913  1.00 19.99           C  
ATOM   1025  CG  PRO A 134      36.127  37.229  84.180  1.00 18.73           C  
ATOM   1026  CD  PRO A 134      36.064  38.003  82.888  1.00 19.41           C  
ATOM   1027  N   VAL A 135      31.967  36.110  84.190  1.00 19.58           N  
ATOM   1028  CA  VAL A 135      30.970  36.257  85.250  1.00 20.24           C  
ATOM   1029  C   VAL A 135      31.324  35.148  86.234  1.00 21.15           C  
ATOM   1030  O   VAL A 135      31.269  33.971  85.889  1.00 21.06           O  
ATOM   1031  CB  VAL A 135      29.520  36.054  84.732  1.00 21.44           C  
ATOM   1032  CG1 VAL A 135      28.492  36.032  85.900  1.00 20.81           C  
ATOM   1033  CG2 VAL A 135      29.177  37.121  83.702  1.00 20.97           C  
ATOM   1034  N   PHE A 136      31.754  35.518  87.433  1.00 21.76           N  
ATOM   1035  CA  PHE A 136      32.235  34.516  88.383  1.00 23.11           C  
ATOM   1036  C   PHE A 136      31.082  33.940  89.203  1.00 24.24           C  
ATOM   1037  O   PHE A 136      30.148  34.671  89.554  1.00 24.19           O  
ATOM   1038  CB  PHE A 136      33.272  35.149  89.333  1.00 22.92           C  
ATOM   1039  CG  PHE A 136      34.592  35.473  88.670  1.00 22.65           C  
ATOM   1040  CD1 PHE A 136      35.492  34.455  88.343  1.00 21.42           C  
ATOM   1041  CD2 PHE A 136      34.936  36.801  88.395  1.00 22.45           C  
ATOM   1042  CE1 PHE A 136      36.730  34.751  87.733  1.00 21.61           C  
ATOM   1043  CE2 PHE A 136      36.164  37.118  87.785  1.00 22.81           C  
ATOM   1044  CZ  PHE A 136      37.065  36.072  87.453  1.00 20.96           C  
ATOM   1045  N   ASP A 137      31.148  32.652  89.525  1.00 26.10           N  
ATOM   1046  CA  ASP A 137      30.267  32.121  90.574  1.00 28.54           C  
ATOM   1047  C   ASP A 137      30.894  32.375  91.960  1.00 29.70           C  
ATOM   1048  O   ASP A 137      31.976  32.969  92.056  1.00 29.27           O  
ATOM   1049  CB  ASP A 137      29.881  30.653  90.342  1.00 28.39           C  
ATOM   1050  CG  ASP A 137      31.046  29.664  90.534  1.00 30.93           C  
ATOM   1051  OD1 ASP A 137      32.108  30.002  91.128  1.00 30.23           O  
ATOM   1052  OD2 ASP A 137      30.960  28.487  90.119  1.00 31.37           O  
ATOM   1053  N   ILE A 138      30.214  31.944  93.024  1.00 31.68           N  
ATOM   1054  CA  ILE A 138      30.690  32.192  94.393  1.00 33.38           C  
ATOM   1055  C   ILE A 138      32.072  31.588  94.664  1.00 33.91           C  
ATOM   1056  O   ILE A 138      32.790  32.056  95.550  1.00 35.06           O  
ATOM   1057  CB  ILE A 138      29.657  31.714  95.465  1.00 33.70           C  
ATOM   1058  CG1 ILE A 138      29.164  30.295  95.166  1.00 34.62           C  
ATOM   1059  CG2 ILE A 138      28.490  32.719  95.588  1.00 35.02           C  
ATOM   1060  CD1 ILE A 138      28.752  29.510  96.408  1.00 38.35           C  
ATOM   1061  N   HIS A 139      32.439  30.568  93.891  1.00 34.10           N  
ATOM   1062  CA  HIS A 139      33.705  29.856  94.076  1.00 34.54           C  
ATOM   1063  C   HIS A 139      34.812  30.316  93.132  1.00 33.02           C  
ATOM   1064  O   HIS A 139      35.855  29.684  93.051  1.00 33.34           O  
ATOM   1065  CB  HIS A 139      33.492  28.345  93.914  1.00 35.19           C  
ATOM   1066  CG  HIS A 139      32.462  27.768  94.845  1.00 38.75           C  
ATOM   1067  ND1 HIS A 139      32.484  27.978  96.210  1.00 41.64           N  
ATOM   1068  CD2 HIS A 139      31.387  26.980  94.603  1.00 40.94           C  
ATOM   1069  CE1 HIS A 139      31.467  27.343  96.767  1.00 42.26           C  
ATOM   1070  NE2 HIS A 139      30.785  26.731  95.815  1.00 42.35           N  
ATOM   1071  N   GLY A 140      34.580  31.401  92.406  1.00 31.87           N  
ATOM   1072  CA  GLY A 140      35.574  31.905  91.473  1.00 30.22           C  
ATOM   1073  C   GLY A 140      35.715  31.107  90.185  1.00 29.23           C  
ATOM   1074  O   GLY A 140      36.653  31.323  89.415  1.00 28.96           O  
ATOM   1075  N   ARG A 141      34.787  30.187  89.942  1.00 27.99           N  
ATOM   1076  CA  ARG A 141      34.704  29.539  88.637  1.00 27.12           C  
ATOM   1077  C   ARG A 141      33.981  30.491  87.681  1.00 25.30           C  
ATOM   1078  O   ARG A 141      33.410  31.487  88.122  1.00 24.63           O  
ATOM   1079  CB  ARG A 141      33.982  28.191  88.744  1.00 28.37           C  
ATOM   1080  CG  ARG A 141      34.837  27.085  89.408  1.00 31.88           C  
ATOM   1081  CD  ARG A 141      34.024  25.851  89.788  1.00 38.74           C  
ATOM   1082  NE  ARG A 141      32.868  26.239  90.609  1.00 43.87           N  
ATOM   1083  CZ  ARG A 141      31.812  25.471  90.876  1.00 46.82           C  
ATOM   1084  NH1 ARG A 141      31.725  24.228  90.400  1.00 48.90           N  
ATOM   1085  NH2 ARG A 141      30.834  25.950  91.635  1.00 48.65           N  
ATOM   1086  N   VAL A 142      34.045  30.202  86.381  1.00 23.66           N  
ATOM   1087  CA  VAL A 142      33.496  31.072  85.342  1.00 21.88           C  
ATOM   1088  C   VAL A 142      32.437  30.317  84.497  1.00 21.74           C  
ATOM   1089  O   VAL A 142      32.750  29.738  83.457  1.00 21.75           O  
ATOM   1090  CB  VAL A 142      34.627  31.627  84.422  1.00 21.83           C  
ATOM   1091  CG1 VAL A 142      34.058  32.631  83.392  1.00 21.78           C  
ATOM   1092  CG2 VAL A 142      35.755  32.282  85.260  1.00 20.24           C  
ATOM   1093  N   PRO A 143      31.205  30.267  84.980  1.00 21.66           N  
ATOM   1094  CA  PRO A 143      30.132  29.590  84.240  1.00 21.51           C  
ATOM   1095  C   PRO A 143      29.617  30.374  83.017  1.00 20.79           C  
ATOM   1096  O   PRO A 143      29.087  29.754  82.087  1.00 21.44           O  
ATOM   1097  CB  PRO A 143      29.038  29.422  85.314  1.00 21.24           C  
ATOM   1098  CG  PRO A 143      29.234  30.610  86.203  1.00 22.30           C  
ATOM   1099  CD  PRO A 143      30.745  30.750  86.299  1.00 21.70           C  
ATOM   1100  N   TYR A 144      29.780  31.700  83.019  1.00 20.44           N  
ATOM   1101  CA  TYR A 144      29.191  32.584  81.995  1.00 19.88           C  
ATOM   1102  C   TYR A 144      30.183  33.695  81.695  1.00 19.57           C  
ATOM   1103  O   TYR A 144      31.108  33.936  82.469  1.00 18.27           O  
ATOM   1104  CB  TYR A 144      27.872  33.230  82.457  1.00 19.94           C  
ATOM   1105  CG  TYR A 144      26.873  32.243  82.984  1.00 21.91           C  
ATOM   1106  CD1 TYR A 144      26.128  31.443  82.116  1.00 24.11           C  
ATOM   1107  CD2 TYR A 144      26.697  32.078  84.352  1.00 24.50           C  
ATOM   1108  CE1 TYR A 144      25.235  30.504  82.607  1.00 24.66           C  
ATOM   1109  CE2 TYR A 144      25.794  31.147  84.845  1.00 24.39           C  
ATOM   1110  CZ  TYR A 144      25.079  30.373  83.971  1.00 25.81           C  
ATOM   1111  OH  TYR A 144      24.195  29.463  84.470  1.00 28.55           O  
ATOM   1112  N   ALA A 145      29.966  34.381  80.579  1.00 19.41           N  
ATOM   1113  CA  ALA A 145      30.834  35.479  80.185  1.00 19.28           C  
ATOM   1114  C   ALA A 145      30.018  36.470  79.364  1.00 19.25           C  
ATOM   1115  O   ALA A 145      28.991  36.112  78.774  1.00 18.40           O  
ATOM   1116  CB  ALA A 145      32.033  34.941  79.382  1.00 19.68           C  
ATOM   1117  N   VAL A 146      30.477  37.715  79.331  1.00 19.22           N  
ATOM   1118  CA  VAL A 146      29.770  38.769  78.611  1.00 19.34           C  
ATOM   1119  C   VAL A 146      30.751  39.395  77.631  1.00 19.33           C  
ATOM   1120  O   VAL A 146      31.924  39.553  77.958  1.00 18.71           O  
ATOM   1121  CB  VAL A 146      29.299  39.906  79.566  1.00 19.12           C  
ATOM   1122  CG1 VAL A 146      28.436  40.956  78.823  1.00 19.76           C  
ATOM   1123  CG2 VAL A 146      28.549  39.361  80.773  1.00 20.83           C  
ATOM   1124  N   SER A 147      30.273  39.781  76.445  1.00 19.00           N  
ATOM   1125  CA  SER A 147      31.144  40.495  75.516  1.00 19.59           C  
ATOM   1126  C   SER A 147      30.444  41.617  74.768  1.00 20.17           C  
ATOM   1127  O   SER A 147      29.213  41.631  74.670  1.00 20.08           O  
ATOM   1128  CB  SER A 147      31.836  39.505  74.554  1.00 20.10           C  
ATOM   1129  OG  SER A 147      30.957  39.054  73.536  1.00 18.51           O  
ATOM   1130  N   ILE A 148      31.234  42.582  74.293  1.00 20.09           N  
ATOM   1131  CA  ILE A 148      30.741  43.647  73.423  1.00 20.39           C  
ATOM   1132  C   ILE A 148      31.398  43.462  72.063  1.00 20.83           C  
ATOM   1133  O   ILE A 148      32.624  43.341  71.994  1.00 20.87           O  
ATOM   1134  CB  ILE A 148      31.118  45.054  73.987  1.00 20.14           C  
ATOM   1135  CG1 ILE A 148      30.436  45.309  75.341  1.00 21.30           C  
ATOM   1136  CG2 ILE A 148      30.770  46.143  72.949  1.00 21.01           C  
ATOM   1137  CD1 ILE A 148      30.886  46.634  76.064  1.00 23.35           C  
ATOM   1138  N   SER A 149      30.608  43.446  70.979  1.00 20.91           N  
ATOM   1139  CA  SER A 149      31.186  43.394  69.631  1.00 20.81           C  
ATOM   1140  C   SER A 149      31.011  44.755  68.988  1.00 20.86           C  
ATOM   1141  O   SER A 149      29.978  45.409  69.177  1.00 21.61           O  
ATOM   1142  CB  SER A 149      30.503  42.342  68.728  1.00 21.69           C  
ATOM   1143  OG  SER A 149      30.296  41.094  69.378  1.00 23.40           O  
ATOM   1144  N   LEU A 150      32.015  45.169  68.218  1.00 21.04           N  
ATOM   1145  CA  LEU A 150      31.979  46.448  67.524  1.00 21.22           C  
ATOM   1146  C   LEU A 150      33.034  46.439  66.426  1.00 21.34           C  
ATOM   1147  O   LEU A 150      33.881  45.541  66.391  1.00 21.53           O  
ATOM   1148  CB  LEU A 150      32.206  47.614  68.503  1.00 20.75           C  
ATOM   1149  CG  LEU A 150      33.598  47.839  69.111  1.00 21.25           C  
ATOM   1150  CD1 LEU A 150      33.644  49.223  69.769  1.00 22.72           C  
ATOM   1151  CD2 LEU A 150      33.990  46.768  70.116  1.00 22.07           C  
ATOM   1152  N   SER A 151      32.980  47.422  65.525  1.00 21.54           N  
ATOM   1153  CA  SER A 151      33.997  47.539  64.484  1.00 21.52           C  
ATOM   1154  C   SER A 151      35.354  47.886  65.102  1.00 22.22           C  
ATOM   1155  O   SER A 151      35.444  48.657  66.074  1.00 21.34           O  
ATOM   1156  CB  SER A 151      33.616  48.598  63.433  1.00 22.01           C  
ATOM   1157  OG  SER A 151      33.567  49.888  64.022  1.00 20.55           O  
ATOM   1158  N   THR A 152      36.410  47.315  64.525  1.00 22.19           N  
ATOM   1159  CA  THR A 152      37.770  47.590  64.967  1.00 23.47           C  
ATOM   1160  C   THR A 152      38.036  49.096  64.891  1.00 23.94           C  
ATOM   1161  O   THR A 152      38.680  49.675  65.767  1.00 23.68           O  
ATOM   1162  CB  THR A 152      38.742  46.861  64.060  1.00 23.23           C  
ATOM   1163  OG1 THR A 152      38.406  45.469  64.054  1.00 23.85           O  
ATOM   1164  CG2 THR A 152      40.165  46.924  64.638  1.00 23.24           C  
ATOM   1165  N   SER A 153      37.503  49.694  63.831  1.00 25.50           N  
ATOM   1166  CA  SER A 153      37.590  51.117  63.584  1.00 27.02           C  
ATOM   1167  C   SER A 153      37.031  51.904  64.766  1.00 27.06           C  
ATOM   1168  O   SER A 153      37.687  52.828  65.277  1.00 26.86           O  
ATOM   1169  CB  SER A 153      36.809  51.448  62.320  1.00 27.47           C  
ATOM   1170  OG  SER A 153      37.209  52.707  61.858  1.00 33.48           O  
ATOM   1171  N   ARG A 154      35.822  51.541  65.205  1.00 26.50           N  
ATOM   1172  CA  ARG A 154      35.219  52.235  66.328  1.00 26.24           C  
ATOM   1173  C   ARG A 154      35.984  51.972  67.625  1.00 26.50           C  
ATOM   1174  O   ARG A 154      36.180  52.879  68.432  1.00 25.81           O  
ATOM   1175  CB  ARG A 154      33.730  51.890  66.488  1.00 26.79           C  
ATOM   1176  CG  ARG A 154      33.052  52.702  67.579  1.00 26.32           C  
ATOM   1177  CD  ARG A 154      33.069  54.204  67.313  1.00 29.28           C  
ATOM   1178  NE  ARG A 154      32.315  54.955  68.319  1.00 31.20           N  
ATOM   1179  CZ  ARG A 154      32.513  56.238  68.625  1.00 32.87           C  
ATOM   1180  NH1 ARG A 154      33.449  56.954  68.010  1.00 33.45           N  
ATOM   1181  NH2 ARG A 154      31.770  56.805  69.561  1.00 33.82           N  
ATOM   1182  N   LEU A 155      36.431  50.735  67.815  1.00 26.57           N  
ATOM   1183  CA  LEU A 155      37.169  50.396  69.033  1.00 27.54           C  
ATOM   1184  C   LEU A 155      38.445  51.246  69.184  1.00 28.20           C  
ATOM   1185  O   LEU A 155      38.786  51.703  70.285  1.00 28.45           O  
ATOM   1186  CB  LEU A 155      37.516  48.912  69.030  1.00 27.35           C  
ATOM   1187  CG  LEU A 155      38.329  48.408  70.229  1.00 27.26           C  
ATOM   1188  CD1 LEU A 155      37.589  48.678  71.529  1.00 28.22           C  
ATOM   1189  CD2 LEU A 155      38.584  46.942  70.040  1.00 29.03           C  
ATOM   1190  N   LYS A 156      39.133  51.468  68.076  1.00 28.63           N  
ATOM   1191  CA  LYS A 156      40.333  52.302  68.101  1.00 29.68           C  
ATOM   1192  C   LYS A 156      39.996  53.741  68.489  1.00 29.44           C  
ATOM   1193  O   LYS A 156      40.768  54.397  69.189  1.00 30.05           O  
ATOM   1194  CB  LYS A 156      41.067  52.225  66.767  1.00 29.93           C  
ATOM   1195  CG  LYS A 156      41.962  51.000  66.681  1.00 33.00           C  
ATOM   1196  CD  LYS A 156      42.320  50.648  65.259  1.00 36.01           C  
ATOM   1197  CE  LYS A 156      43.088  49.324  65.205  1.00 38.27           C  
ATOM   1198  NZ  LYS A 156      43.393  48.954  63.783  1.00 39.72           N  
ATOM   1199  N   GLN A 157      38.823  54.209  68.068  1.00 28.85           N  
ATOM   1200  CA  GLN A 157      38.366  55.556  68.368  1.00 29.24           C  
ATOM   1201  C   GLN A 157      37.988  55.740  69.832  1.00 29.80           C  
ATOM   1202  O   GLN A 157      38.321  56.758  70.437  1.00 29.87           O  
ATOM   1203  CB  GLN A 157      37.155  55.918  67.500  1.00 29.15           C  
ATOM   1204  CG  GLN A 157      37.451  56.085  66.027  1.00 28.45           C  
ATOM   1205  CD  GLN A 157      36.217  56.515  65.241  1.00 31.17           C  
ATOM   1206  OE1 GLN A 157      35.111  56.471  65.754  1.00 29.83           O  
ATOM   1207  NE2 GLN A 157      36.418  56.944  64.002  1.00 32.77           N  
ATOM   1208  N   VAL A 158      37.291  54.761  70.407  1.00 29.36           N  
ATOM   1209  CA  VAL A 158      36.804  54.900  71.785  1.00 30.26           C  
ATOM   1210  C   VAL A 158      37.728  54.334  72.865  1.00 30.00           C  
ATOM   1211  O   VAL A 158      37.749  54.855  73.978  1.00 31.03           O  
ATOM   1212  CB  VAL A 158      35.382  54.343  71.964  1.00 30.43           C  
ATOM   1213  CG1 VAL A 158      34.416  55.165  71.139  1.00 32.15           C  
ATOM   1214  CG2 VAL A 158      35.322  52.909  71.537  1.00 31.61           C  
ATOM   1215  N   GLY A 159      38.468  53.281  72.534  1.00 29.56           N  
ATOM   1216  CA  GLY A 159      39.426  52.666  73.436  1.00 29.46           C  
ATOM   1217  C   GLY A 159      38.876  51.448  74.180  1.00 29.12           C  
ATOM   1218  O   GLY A 159      37.707  51.462  74.624  1.00 28.39           O  
ATOM   1219  N   GLU A 160      39.711  50.420  74.336  1.00 28.56           N  
ATOM   1220  CA  GLU A 160      39.300  49.192  75.032  1.00 28.86           C  
ATOM   1221  C   GLU A 160      38.978  49.439  76.491  1.00 28.15           C  
ATOM   1222  O   GLU A 160      37.945  48.983  76.979  1.00 27.52           O  
ATOM   1223  CB  GLU A 160      40.338  48.054  74.951  1.00 29.65           C  
ATOM   1224  CG  GLU A 160      39.817  46.776  75.620  1.00 31.99           C  
ATOM   1225  CD  GLU A 160      40.865  45.835  76.204  1.00 36.60           C  
ATOM   1226  OE1 GLU A 160      42.077  46.132  76.166  1.00 38.97           O  
ATOM   1227  OE2 GLU A 160      40.465  44.760  76.703  1.00 36.97           O  
ATOM   1228  N   LYS A 161      39.874  50.136  77.189  1.00 27.95           N  
ATOM   1229  CA  LYS A 161      39.692  50.365  78.609  1.00 28.33           C  
ATOM   1230  C   LYS A 161      38.463  51.212  78.869  1.00 27.94           C  
ATOM   1231  O   LYS A 161      37.767  51.011  79.865  1.00 27.83           O  
ATOM   1232  CB  LYS A 161      40.949  50.980  79.237  1.00 29.23           C  
ATOM   1233  CG  LYS A 161      42.132  49.992  79.360  1.00 31.82           C  
ATOM   1234  CD  LYS A 161      41.774  48.721  80.159  1.00 37.34           C  
ATOM   1235  CE  LYS A 161      43.005  47.816  80.421  1.00 40.62           C  
ATOM   1236  NZ  LYS A 161      42.842  46.424  79.903  1.00 44.08           N  
ATOM   1237  N   ASN A 162      38.182  52.151  77.964  1.00 27.43           N  
ATOM   1238  CA  ASN A 162      36.994  52.980  78.084  1.00 27.31           C  
ATOM   1239  C   ASN A 162      35.715  52.140  78.096  1.00 27.33           C  
ATOM   1240  O   ASN A 162      34.828  52.379  78.917  1.00 27.38           O  
ATOM   1241  CB  ASN A 162      36.943  54.043  76.978  1.00 27.84           C  
ATOM   1242  CG  ASN A 162      37.954  55.165  77.201  1.00 29.09           C  
ATOM   1243  OD1 ASN A 162      38.354  55.442  78.335  1.00 33.76           O  
ATOM   1244  ND2 ASN A 162      38.387  55.795  76.121  1.00 27.03           N  
ATOM   1245  N   LEU A 163      35.633  51.155  77.198  1.00 25.72           N  
ATOM   1246  CA  LEU A 163      34.464  50.287  77.119  1.00 25.59           C  
ATOM   1247  C   LEU A 163      34.513  49.161  78.158  1.00 24.76           C  
ATOM   1248  O   LEU A 163      33.476  48.668  78.604  1.00 24.16           O  
ATOM   1249  CB  LEU A 163      34.345  49.697  75.711  1.00 25.95           C  
ATOM   1250  CG  LEU A 163      33.713  50.586  74.642  1.00 28.90           C  
ATOM   1251  CD1 LEU A 163      33.876  49.932  73.266  1.00 31.92           C  
ATOM   1252  CD2 LEU A 163      32.219  50.852  74.941  1.00 29.68           C  
ATOM   1253  N   LEU A 164      35.721  48.759  78.545  1.00 23.93           N  
ATOM   1254  CA  LEU A 164      35.878  47.672  79.499  1.00 23.84           C  
ATOM   1255  C   LEU A 164      35.269  48.024  80.861  1.00 23.73           C  
ATOM   1256  O   LEU A 164      34.712  47.165  81.555  1.00 23.58           O  
ATOM   1257  CB  LEU A 164      37.364  47.277  79.623  1.00 23.60           C  
ATOM   1258  CG  LEU A 164      37.782  46.184  80.599  1.00 24.58           C  
ATOM   1259  CD1 LEU A 164      37.020  44.896  80.322  1.00 22.55           C  
ATOM   1260  CD2 LEU A 164      39.283  45.935  80.469  1.00 24.97           C  
ATOM   1261  N   LYS A 165      35.355  49.295  81.236  1.00 23.34           N  
ATOM   1262  CA  LYS A 165      34.811  49.711  82.522  1.00 24.33           C  
ATOM   1263  C   LYS A 165      33.310  49.383  82.742  1.00 23.27           C  
ATOM   1264  O   LYS A 165      33.001  48.684  83.706  1.00 23.28           O  
ATOM   1265  CB  LYS A 165      35.134  51.170  82.826  1.00 24.33           C  
ATOM   1266  CG  LYS A 165      34.877  51.533  84.274  1.00 28.22           C  
ATOM   1267  CD  LYS A 165      35.247  52.971  84.524  1.00 33.97           C  
ATOM   1268  CE  LYS A 165      34.152  53.669  85.287  1.00 36.53           C  
ATOM   1269  NZ  LYS A 165      34.582  53.826  86.690  1.00 40.03           N  
ATOM   1270  N   PRO A 166      32.388  49.868  81.904  1.00 22.73           N  
ATOM   1271  CA  PRO A 166      30.968  49.501  82.063  1.00 22.38           C  
ATOM   1272  C   PRO A 166      30.720  48.011  81.814  1.00 21.99           C  
ATOM   1273  O   PRO A 166      29.834  47.422  82.429  1.00 21.85           O  
ATOM   1274  CB  PRO A 166      30.241  50.359  81.007  1.00 22.92           C  
ATOM   1275  CG  PRO A 166      31.309  50.752  80.025  1.00 22.60           C  
ATOM   1276  CD  PRO A 166      32.585  50.842  80.810  1.00 23.28           C  
ATOM   1277  N   LEU A 167      31.498  47.409  80.916  1.00 21.61           N  
ATOM   1278  CA  LEU A 167      31.366  45.974  80.627  1.00 21.31           C  
ATOM   1279  C   LEU A 167      31.666  45.171  81.891  1.00 20.93           C  
ATOM   1280  O   LEU A 167      30.915  44.258  82.266  1.00 20.45           O  
ATOM   1281  CB  LEU A 167      32.348  45.563  79.514  1.00 20.99           C  
ATOM   1282  CG  LEU A 167      32.467  44.050  79.253  1.00 21.21           C  
ATOM   1283  CD1 LEU A 167      31.126  43.412  78.886  1.00 20.34           C  
ATOM   1284  CD2 LEU A 167      33.489  43.812  78.169  1.00 21.45           C  
ATOM   1285  N   ARG A 168      32.755  45.527  82.567  1.00 21.00           N  
ATOM   1286  CA  ARG A 168      33.101  44.818  83.789  1.00 21.90           C  
ATOM   1287  C   ARG A 168      32.077  45.089  84.904  1.00 21.73           C  
ATOM   1288  O   ARG A 168      31.677  44.170  85.641  1.00 21.85           O  
ATOM   1289  CB  ARG A 168      34.518  45.147  84.241  1.00 22.34           C  
ATOM   1290  CG  ARG A 168      34.857  44.542  85.617  1.00 24.66           C  
ATOM   1291  CD  ARG A 168      36.258  44.867  86.092  1.00 27.75           C  
ATOM   1292  NE  ARG A 168      36.486  46.314  86.124  1.00 31.31           N  
ATOM   1293  CZ  ARG A 168      37.321  46.965  85.315  1.00 30.44           C  
ATOM   1294  NH1 ARG A 168      38.045  46.303  84.404  1.00 30.57           N  
ATOM   1295  NH2 ARG A 168      37.436  48.275  85.427  1.00 28.37           N  
ATOM   1296  N   GLU A 169      31.628  46.337  85.011  1.00 22.04           N  
ATOM   1297  CA  GLU A 169      30.616  46.676  86.015  1.00 22.05           C  
ATOM   1298  C   GLU A 169      29.342  45.836  85.813  1.00 22.32           C  
ATOM   1299  O   GLU A 169      28.711  45.408  86.784  1.00 21.00           O  
ATOM   1300  CB  GLU A 169      30.306  48.169  85.982  1.00 23.12           C  
ATOM   1301  CG  GLU A 169      31.412  49.014  86.605  1.00 24.77           C  
ATOM   1302  CD  GLU A 169      31.296  50.492  86.284  1.00 28.20           C  
ATOM   1303  OE1 GLU A 169      30.356  50.885  85.561  1.00 30.96           O  
ATOM   1304  OE2 GLU A 169      32.157  51.259  86.753  1.00 29.49           O  
ATOM   1305  N   THR A 170      28.988  45.620  84.545  1.00 21.72           N  
ATOM   1306  CA  THR A 170      27.851  44.780  84.174  1.00 21.86           C  
ATOM   1307  C   THR A 170      28.050  43.330  84.645  1.00 22.00           C  
ATOM   1308  O   THR A 170      27.168  42.788  85.325  1.00 21.22           O  
ATOM   1309  CB  THR A 170      27.617  44.877  82.655  1.00 21.95           C  
ATOM   1310  OG1 THR A 170      27.255  46.233  82.307  1.00 21.88           O  
ATOM   1311  CG2 THR A 170      26.423  44.021  82.206  1.00 21.35           C  
ATOM   1312  N   ALA A 171      29.201  42.720  84.308  1.00 21.84           N  
ATOM   1313  CA  ALA A 171      29.521  41.369  84.754  1.00 22.27           C  
ATOM   1314  C   ALA A 171      29.536  41.262  86.281  1.00 22.52           C  
ATOM   1315  O   ALA A 171      29.049  40.290  86.827  1.00 22.96           O  
ATOM   1316  CB  ALA A 171      30.859  40.894  84.181  1.00 22.32           C  
ATOM   1317  N   GLN A 172      30.103  42.257  86.957  1.00 23.98           N  
ATOM   1318  CA  GLN A 172      30.168  42.251  88.418  1.00 24.64           C  
ATOM   1319  C   GLN A 172      28.773  42.207  89.042  1.00 25.01           C  
ATOM   1320  O   GLN A 172      28.543  41.451  89.983  1.00 25.36           O  
ATOM   1321  CB  GLN A 172      30.920  43.479  88.935  1.00 24.81           C  
ATOM   1322  CG  GLN A 172      32.444  43.387  88.814  1.00 27.39           C  
ATOM   1323  CD  GLN A 172      33.138  44.741  89.055  1.00 29.09           C  
ATOM   1324  OE1 GLN A 172      32.537  45.810  88.861  1.00 28.15           O  
ATOM   1325  NE2 GLN A 172      34.392  44.691  89.491  1.00 29.22           N  
ATOM   1326  N   ALA A 173      27.854  43.014  88.509  1.00 25.19           N  
ATOM   1327  CA  ALA A 173      26.480  43.068  89.007  1.00 25.83           C  
ATOM   1328  C   ALA A 173      25.769  41.710  88.844  1.00 26.50           C  
ATOM   1329  O   ALA A 173      25.140  41.211  89.790  1.00 26.51           O  
ATOM   1330  CB  ALA A 173      25.701  44.179  88.309  1.00 25.65           C  
ATOM   1331  N   ILE A 174      25.895  41.118  87.653  1.00 26.32           N  
ATOM   1332  CA  ILE A 174      25.380  39.770  87.393  1.00 26.86           C  
ATOM   1333  C   ILE A 174      25.990  38.737  88.350  1.00 27.41           C  
ATOM   1334  O   ILE A 174      25.275  37.943  88.956  1.00 27.53           O  
ATOM   1335  CB  ILE A 174      25.628  39.357  85.907  1.00 26.96           C  
ATOM   1336  CG1 ILE A 174      24.912  40.330  84.951  1.00 26.35           C  
ATOM   1337  CG2 ILE A 174      25.206  37.879  85.665  1.00 25.91           C  
ATOM   1338  CD1 ILE A 174      25.334  40.213  83.467  1.00 25.60           C  
ATOM   1339  N   SER A 175      27.311  38.747  88.481  1.00 28.27           N  
ATOM   1340  CA  SER A 175      27.992  37.811  89.364  1.00 29.84           C  
ATOM   1341  C   SER A 175      27.539  37.956  90.827  1.00 31.21           C  
ATOM   1342  O   SER A 175      27.317  36.949  91.529  1.00 30.76           O  
ATOM   1343  CB  SER A 175      29.499  38.008  89.264  1.00 29.56           C  
ATOM   1344  OG  SER A 175      30.158  37.239  90.244  1.00 31.73           O  
ATOM   1345  N   ASN A 176      27.414  39.207  91.268  1.00 32.42           N  
ATOM   1346  CA  ASN A 176      27.010  39.537  92.636  1.00 34.51           C  
ATOM   1347  C   ASN A 176      25.587  39.069  92.918  1.00 35.79           C  
ATOM   1348  O   ASN A 176      25.327  38.462  93.953  1.00 36.07           O  
ATOM   1349  CB  ASN A 176      27.157  41.047  92.898  1.00 34.02           C  
ATOM   1350  CG  ASN A 176      28.609  41.471  93.066  1.00 34.80           C  
ATOM   1351  OD1 ASN A 176      29.487  40.633  93.312  1.00 34.83           O  
ATOM   1352  ND2 ASN A 176      28.874  42.778  92.933  1.00 35.47           N  
ATOM   1353  N   GLU A 177      24.682  39.336  91.980  1.00 37.72           N  
ATOM   1354  CA  GLU A 177      23.299  38.880  92.076  1.00 39.66           C  
ATOM   1355  C   GLU A 177      23.158  37.361  92.008  1.00 40.50           C  
ATOM   1356  O   GLU A 177      22.334  36.788  92.715  1.00 40.98           O  
ATOM   1357  CB  GLU A 177      22.440  39.533  90.999  1.00 39.96           C  
ATOM   1358  CG  GLU A 177      21.939  40.908  91.409  1.00 42.96           C  
ATOM   1359  CD  GLU A 177      21.247  41.657  90.285  1.00 45.48           C  
ATOM   1360  OE1 GLU A 177      21.449  42.890  90.208  1.00 48.54           O  
ATOM   1361  OE2 GLU A 177      20.503  41.027  89.495  1.00 46.70           O  
ATOM   1362  N   LEU A 178      23.954  36.710  91.166  1.00 41.33           N  
ATOM   1363  CA  LEU A 178      23.930  35.246  91.090  1.00 42.59           C  
ATOM   1364  C   LEU A 178      24.371  34.667  92.436  1.00 43.49           C  
ATOM   1365  O   LEU A 178      23.705  33.786  92.993  1.00 43.30           O  
ATOM   1366  CB  LEU A 178      24.803  34.733  89.938  1.00 41.96           C  
ATOM   1367  CG  LEU A 178      25.093  33.228  89.831  1.00 42.72           C  
ATOM   1368  CD1 LEU A 178      23.837  32.408  89.468  1.00 42.81           C  
ATOM   1369  CD2 LEU A 178      26.231  32.955  88.844  1.00 43.00           C  
ATOM   1370  N   GLY A 179      25.470  35.209  92.962  1.00 44.54           N  
ATOM   1371  CA  GLY A 179      26.010  34.835  94.259  1.00 46.02           C  
ATOM   1372  C   GLY A 179      24.992  34.882  95.381  1.00 47.29           C  
ATOM   1373  O   GLY A 179      24.919  33.951  96.183  1.00 47.34           O  
ATOM   1374  N   PHE A 180      24.207  35.958  95.429  1.00 48.44           N  
ATOM   1375  CA  PHE A 180      23.160  36.118  96.442  1.00 49.99           C  
ATOM   1376  C   PHE A 180      22.141  34.979  96.364  1.00 50.50           C  
ATOM   1377  O   PHE A 180      21.745  34.424  97.387  1.00 50.75           O  
ATOM   1378  CB  PHE A 180      22.451  37.478  96.320  1.00 50.07           C  
ATOM   1379  CG  PHE A 180      23.350  38.678  96.539  1.00 51.86           C  
ATOM   1380  CD1 PHE A 180      24.595  38.556  97.168  1.00 53.61           C  
ATOM   1381  CD2 PHE A 180      22.943  39.947  96.113  1.00 53.57           C  
ATOM   1382  CE1 PHE A 180      25.423  39.680  97.360  1.00 54.12           C  
ATOM   1383  CE2 PHE A 180      23.761  41.074  96.302  1.00 54.07           C  
ATOM   1384  CZ  PHE A 180      25.002  40.937  96.925  1.00 54.30           C  
ATOM   1385  N   THR A 181      21.730  34.623  95.150  1.00 51.33           N  
ATOM   1386  CA  THR A 181      20.776  33.531  94.961  1.00 51.94           C  
ATOM   1387  C   THR A 181      21.490  32.182  95.004  1.00 52.09           C  
ATOM   1388  O   THR A 181      21.017  31.245  95.649  1.00 52.73           O  
ATOM   1389  CB  THR A 181      19.956  33.694  93.645  1.00 51.93           C  
ATOM   1390  OG1 THR A 181      20.766  33.357  92.511  1.00 52.68           O  
ATOM   1391  CG2 THR A 181      19.581  35.159  93.399  1.00 52.34           C  
ATOM   1392  N   ALA A 188      13.012  43.003  83.273  1.00 32.55           N  
ATOM   1393  CA  ALA A 188      13.465  43.336  81.917  1.00 32.02           C  
ATOM   1394  C   ALA A 188      12.570  42.684  80.874  1.00 31.17           C  
ATOM   1395  O   ALA A 188      12.133  41.555  81.047  1.00 31.32           O  
ATOM   1396  CB  ALA A 188      14.897  42.876  81.708  1.00 31.80           C  
ATOM   1397  N   ILE A 189      12.347  43.391  79.770  1.00 31.19           N  
ATOM   1398  CA  ILE A 189      11.607  42.851  78.627  1.00 30.30           C  
ATOM   1399  C   ILE A 189      12.197  41.511  78.135  1.00 30.55           C  
ATOM   1400  O   ILE A 189      11.453  40.592  77.771  1.00 29.75           O  
ATOM   1401  CB  ILE A 189      11.542  43.923  77.500  1.00 30.33           C  
ATOM   1402  CG1 ILE A 189      10.511  45.017  77.858  1.00 29.97           C  
ATOM   1403  CG2 ILE A 189      11.243  43.290  76.120  1.00 29.19           C  
ATOM   1404  CD1 ILE A 189       9.057  44.523  77.878  1.00 28.04           C  
ATOM   1405  N   THR A 190      13.527  41.392  78.152  1.00 30.59           N  
ATOM   1406  CA  THR A 190      14.195  40.168  77.679  1.00 30.86           C  
ATOM   1407  C   THR A 190      14.537  39.174  78.784  1.00 32.43           C  
ATOM   1408  O   THR A 190      15.299  38.225  78.553  1.00 31.83           O  
ATOM   1409  CB  THR A 190      15.481  40.487  76.904  1.00 31.06           C  
ATOM   1410  OG1 THR A 190      16.380  41.205  77.765  1.00 29.22           O  
ATOM   1411  CG2 THR A 190      15.196  41.429  75.715  1.00 28.54           C  
ATOM   1412  N   GLY A 191      14.001  39.404  79.980  1.00 33.49           N  
ATOM   1413  CA  GLY A 191      14.156  38.468  81.072  1.00 35.47           C  
ATOM   1414  C   GLY A 191      13.098  37.381  80.951  1.00 37.47           C  
ATOM   1415  O   GLY A 191      12.586  36.890  81.966  1.00 39.53           O  
TER    1416      GLY A 191                                                      
END
MOLECULE T0412.pdb
ATOM      1  N   SER     1      17.559  26.951  92.213  1.00 54.32           N  
ATOM      2  CA  SER     1      16.245  27.299  92.853  1.00 53.09           C  
ATOM      3  C   SER     1      16.043  28.831  93.060  1.00 52.29           C  
ATOM      4  O   SER     1      15.077  29.281  93.761  1.00 50.93           O  
ATOM      5  CB  SER     1      16.073  26.547  94.152  1.00 52.87           C  
ATOM      6  OG  SER     1      14.779  26.777  94.666  1.00 52.80           O  
ATOM      7  N   ASN     2      16.948  29.599  92.427  1.00 50.24           N  
ATOM      8  CA  ASN     2      16.884  31.054  92.474  1.00 48.93           C  
ATOM      9  C   ASN     2      17.383  31.628  91.189  1.00 47.18           C  
ATOM     10  O   ASN     2      17.733  32.795  91.079  1.00 47.53           O  
ATOM     11  CB  ASN     2      17.619  31.623  93.683  1.00 49.45           C  
ATOM     12  CG  ASN     2      17.125  33.004  94.040  1.00 49.02           C  
ATOM     13  OD1 ASN     2      17.498  33.973  93.384  1.00 51.47           O  
ATOM     14  ND2 ASN     2      16.253  33.099  95.026  1.00 44.65           N  
ATOM     15  N   ALA     3      17.385  30.732  90.212  1.00 45.59           N  
ATOM     16  CA  ALA     3      17.756  30.926  88.865  1.00 42.81           C  
ATOM     17  C   ALA     3      17.150  32.162  88.216  1.00 42.42           C  
ATOM     18  O   ALA     3      17.817  32.797  87.411  1.00 43.10           O  
ATOM     19  CB  ALA     3      17.328  29.686  88.100  1.00 42.78           C  
ATOM     20  N   LEU     4      15.891  32.474  88.499  1.00 40.84           N  
ATOM     21  CA  LEU     4      15.175  33.549  87.776  1.00 41.08           C  
ATOM     22  C   LEU     4      15.595  34.992  88.193  1.00 41.73           C  
ATOM     23  O   LEU     4      15.795  35.891  87.336  1.00 40.99           O  
ATOM     24  CB  LEU     4      13.630  33.366  87.879  1.00 40.15           C  
ATOM     25  CG  LEU     4      13.042  32.123  87.172  1.00 39.13           C  
ATOM     26  CD1 LEU     4      11.515  32.115  87.181  1.00 37.64           C  
ATOM     27  CD2 LEU     4      13.561  32.029  85.757  1.00 33.72           C  
ATOM     28  N   PHE     5      15.747  35.183  89.503  1.00 42.10           N  
ATOM     29  CA  PHE     5      16.276  36.410  90.043  1.00 43.47           C  
ATOM     30  C   PHE     5      17.723  36.613  89.583  1.00 45.53           C  
ATOM     31  O   PHE     5      18.087  37.717  89.179  1.00 45.52           O  
ATOM     32  CB  PHE     5      16.153  36.419  91.539  1.00 41.53           C  
ATOM     33  CG  PHE     5      14.758  36.708  92.026  1.00 42.02           C  
ATOM     34  CD1 PHE     5      14.162  37.953  91.794  1.00 40.73           C  
ATOM     35  CD2 PHE     5      14.057  35.762  92.772  1.00 38.83           C  
ATOM     36  CE1 PHE     5      12.860  38.232  92.300  1.00 39.71           C  
ATOM     37  CE2 PHE     5      12.788  36.019  93.254  1.00 37.43           C  
ATOM     38  CZ  PHE     5      12.175  37.252  93.015  1.00 38.76           C  
ATOM     39  N   SER     6      18.539  35.567  89.550  1.00 47.47           N  
ATOM     40  CA  SER     6      19.873  35.786  88.935  1.00 50.67           C  
ATOM     41  C   SER     6      19.841  36.120  87.464  1.00 51.41           C  
ATOM     42  O   SER     6      20.662  36.934  87.018  1.00 52.33           O  
ATOM     43  CB  SER     6      20.860  34.630  89.193  1.00 50.07           C  
ATOM     44  OG  SER     6      20.888  34.394  90.613  1.00 55.00           O  
ATOM     45  N   SER     7      18.951  35.474  86.693  1.00 52.62           N  
ATOM     46  CA  SER     7      18.913  35.704  85.234  1.00 53.39           C  
ATOM     47  C   SER     7      18.502  37.146  85.049  1.00 53.99           C  
ATOM     48  O   SER     7      19.066  37.871  84.231  1.00 54.98           O  
ATOM     49  CB  SER     7      17.939  34.768  84.510  1.00 53.69           C  
ATOM     50  OG  SER     7      18.384  33.413  84.592  1.00 54.34           O  
ATOM     51  N   ARG     8      17.565  37.583  85.866  1.00 53.65           N  
ATOM     52  CA  ARG     8      17.066  38.939  85.755  1.00 54.53           C  
ATOM     53  C   ARG     8      18.164  39.964  86.086  1.00 54.58           C  
ATOM     54  O   ARG     8      18.327  40.920  85.341  1.00 55.96           O  
ATOM     55  CB  ARG     8      15.819  39.113  86.650  1.00 54.60           C  
ATOM     56  CG  ARG     8      15.233  40.467  86.595  1.00 56.13           C  
ATOM     57  CD  ARG     8      15.106  40.985  88.004  1.00 57.96           C  
ATOM     58  NE  ARG     8      13.696  41.145  88.342  1.00 62.03           N  
ATOM     59  CZ  ARG     8      13.204  41.195  89.577  1.00 61.99           C  
ATOM     60  NH1 ARG     8      11.897  41.360  89.749  1.00 61.14           N  
ATOM     61  NH2 ARG     8      14.011  41.073  90.627  1.00 62.55           N  
ATOM     62  N   ASP     9      18.908  39.772  87.183  1.00 54.12           N  
ATOM     63  CA  ASP     9      20.074  40.595  87.510  1.00 54.08           C  
ATOM     64  C   ASP     9      21.019  40.705  86.305  1.00 54.67           C  
ATOM     65  O   ASP     9      21.399  41.806  85.927  1.00 55.78           O  
ATOM     66  CB  ASP     9      20.870  39.989  88.667  1.00 53.61           C  
ATOM     67  CG  ASP     9      20.139  40.045  90.007  1.00 55.37           C  
ATOM     68  OD1 ASP     9      19.080  40.719  90.144  1.00 57.24           O  
ATOM     69  OD2 ASP     9      20.634  39.387  90.952  1.00 56.96           O  
ATOM     70  N   ILE    10      21.384  39.573  85.702  1.00 54.19           N  
ATOM     71  CA  ILE    10      22.284  39.552  84.544  1.00 54.42           C  
ATOM     72  C   ILE    10      21.722  40.293  83.315  1.00 55.29           C  
ATOM     73  O   ILE    10      22.394  41.116  82.712  1.00 55.62           O  
ATOM     74  CB  ILE    10      22.666  38.098  84.163  1.00 53.93           C  
ATOM     75  CG1 ILE    10      23.447  37.454  85.291  1.00 53.01           C  
ATOM     76  CG2 ILE    10      23.465  38.026  82.840  1.00 53.06           C  
ATOM     77  CD1 ILE    10      23.566  35.934  85.160  1.00 52.08           C  
ATOM     78  N   LEU    11      20.489  39.975  82.942  1.00 56.18           N  
ATOM     79  CA  LEU    11      19.816  40.679  81.877  1.00 56.38           C  
ATOM     80  C   LEU    11      19.798  42.184  82.141  1.00 57.20           C  
ATOM     81  O   LEU    11      20.038  42.959  81.229  1.00 58.40           O  
ATOM     82  CB  LEU    11      18.403  40.149  81.688  1.00 55.51           C  
ATOM     83  CG  LEU    11      17.694  40.821  80.522  1.00 55.16           C  
ATOM     84  CD1 LEU    11      18.433  40.553  79.200  1.00 52.86           C  
ATOM     85  CD2 LEU    11      16.261  40.337  80.481  1.00 49.81           C  
ATOM     86  N   GLU    12      19.507  42.620  83.360  1.00 57.38           N  
ATOM     87  CA  GLU    12      19.500  44.064  83.621  1.00 58.36           C  
ATOM     88  C   GLU    12      20.894  44.699  83.355  1.00 57.39           C  
ATOM     89  O   GLU    12      20.998  45.782  82.776  1.00 57.72           O  
ATOM     90  CB  GLU    12      19.034  44.374  85.047  1.00 57.74           C  
ATOM     91  CG  GLU    12      17.531  44.332  85.205  1.00 60.40           C  
ATOM     92  CD  GLU    12      17.043  44.331  86.701  1.00 61.88           C  
ATOM     93  OE1 GLU    12      17.873  44.459  87.671  1.00 62.94           O  
ATOM     94  OE2 GLU    12      15.796  44.191  86.887  1.00 66.26           O  
ATOM     95  N   VAL    13      21.957  44.040  83.792  1.00 55.98           N  
ATOM     96  CA  VAL    13      23.286  44.551  83.529  1.00 55.60           C  
ATOM     97  C   VAL    13      23.614  44.556  82.022  1.00 55.56           C  
ATOM     98  O   VAL    13      24.168  45.541  81.501  1.00 55.72           O  
ATOM     99  CB  VAL    13      24.357  43.769  84.292  1.00 55.14           C  
ATOM    100  CG1 VAL    13      25.722  44.167  83.806  1.00 54.07           C  
ATOM    101  CG2 VAL    13      24.239  44.064  85.750  1.00 54.66           C  
ATOM    102  N   LEU    14      23.268  43.472  81.339  1.00 55.24           N  
ATOM    103  CA  LEU    14      23.531  43.338  79.920  1.00 56.29           C  
ATOM    104  C   LEU    14      22.733  44.390  79.113  1.00 56.68           C  
ATOM    105  O   LEU    14      23.240  44.984  78.188  1.00 55.03           O  
ATOM    106  CB  LEU    14      23.190  41.918  79.489  1.00 56.15           C  
ATOM    107  CG  LEU    14      23.420  41.464  78.039  1.00 58.26           C  
ATOM    108  CD1 LEU    14      24.902  41.336  77.676  1.00 56.32           C  
ATOM    109  CD2 LEU    14      22.662  40.132  77.744  1.00 56.95           C  
ATOM    110  N   GLN    15      21.476  44.617  79.488  1.00 57.39           N  
ATOM    111  CA  GLN    15      20.712  45.698  78.920  1.00 58.53           C  
ATOM    112  C   GLN    15      21.356  47.067  79.131  1.00 58.92           C  
ATOM    113  O   GLN    15      21.273  47.906  78.234  1.00 59.03           O  
ATOM    114  CB  GLN    15      19.262  45.682  79.394  1.00 57.53           C  
ATOM    115  CG  GLN    15      18.490  44.721  78.582  1.00 60.66           C  
ATOM    116  CD  GLN    15      17.050  44.549  79.011  1.00 67.03           C  
ATOM    117  OE1 GLN    15      16.699  44.686  80.206  1.00 70.49           O  
ATOM    118  NE2 GLN    15      16.197  44.222  78.046  1.00 66.34           N  
ATOM    119  N   ASP    16      21.993  47.297  80.274  1.00 59.06           N  
ATOM    120  CA  ASP    16      22.670  48.569  80.467  1.00 61.14           C  
ATOM    121  C   ASP    16      23.854  48.786  79.522  1.00 60.80           C  
ATOM    122  O   ASP    16      24.084  49.885  79.037  1.00 62.19           O  
ATOM    123  CB  ASP    16      23.144  48.748  81.898  1.00 61.68           C  
ATOM    124  CG  ASP    16      22.232  49.623  82.672  1.00 68.11           C  
ATOM    125  OD1 ASP    16      21.178  49.073  83.077  1.00 74.84           O  
ATOM    126  OD2 ASP    16      22.526  50.864  82.858  1.00 74.19           O  
ATOM    127  N   ILE    17      24.610  47.746  79.266  1.00 59.31           N  
ATOM    128  CA  ILE    17      25.768  47.894  78.435  1.00 58.61           C  
ATOM    129  C   ILE    17      25.329  48.077  76.973  1.00 58.36           C  
ATOM    130  O   ILE    17      25.962  48.806  76.173  1.00 58.26           O  
ATOM    131  CB  ILE    17      26.776  46.737  78.709  1.00 58.41           C  
ATOM    132  CG1 ILE    17      27.396  47.016  80.102  1.00 59.02           C  
ATOM    133  CG2 ILE    17      27.855  46.699  77.673  1.00 55.26           C  
ATOM    134  CD1 ILE    17      27.730  45.783  80.928  1.00 58.25           C  
ATOM    135  N   HIS    18      24.204  47.478  76.654  1.00 57.90           N  
ATOM    136  CA  HIS    18      23.629  47.664  75.351  1.00 58.94           C  
ATOM    137  C   HIS    18      23.112  49.113  75.217  1.00 59.57           C  
ATOM    138  O   HIS    18      23.374  49.768  74.222  1.00 60.69           O  
ATOM    139  CB  HIS    18      22.526  46.645  75.090  1.00 57.67           C  
ATOM    140  CG  HIS    18      21.918  46.772  73.737  1.00 57.96           C  
ATOM    141  ND1 HIS    18      20.628  47.214  73.539  1.00 58.77           N  
ATOM    142  CD2 HIS    18      22.425  46.528  72.505  1.00 58.94           C  
ATOM    143  CE1 HIS    18      20.359  47.219  72.245  1.00 60.89           C  
ATOM    144  NE2 HIS    18      21.434  46.803  71.595  1.00 61.68           N  
ATOM    145  N   MET    19      22.406  49.635  76.201  1.00 60.21           N  
ATOM    146  CA  MET    19      21.950  51.024  76.073  1.00 61.55           C  
ATOM    147  C   MET    19      23.110  51.997  75.938  1.00 61.25           C  
ATOM    148  O   MET    19      23.060  52.863  75.066  1.00 61.91           O  
ATOM    149  CB  MET    19      21.069  51.463  77.232  1.00 62.10           C  
ATOM    150  CG  MET    19      19.700  50.779  77.275  1.00 67.35           C  
ATOM    151  SD  MET    19      18.646  50.737  75.611  0.70 78.76          SE  
ATOM    152  CE  MET    19      17.526  52.242  75.897  1.00 73.10           C  
ATOM    153  N   GLU    20      24.145  51.856  76.772  1.00 60.29           N  
ATOM    154  CA  GLU    20      25.248  52.795  76.767  1.00 60.15           C  
ATOM    155  C   GLU    20      26.152  52.649  75.538  1.00 60.05           C  
ATOM    156  O   GLU    20      26.716  53.622  75.082  1.00 61.14           O  
ATOM    157  CB  GLU    20      26.110  52.629  78.003  1.00 60.63           C  
ATOM    158  CG  GLU    20      25.379  52.438  79.286  1.00 63.50           C  
ATOM    159  CD  GLU    20      25.814  53.410  80.356  1.00 68.04           C  
ATOM    160  OE1 GLU    20      26.697  54.260  80.104  1.00 70.18           O  
ATOM    161  OE2 GLU    20      25.245  53.346  81.463  1.00 72.19           O  
ATOM    162  N   THR    21      26.292  51.453  74.989  1.00 58.97           N  
ATOM    163  CA  THR    21      27.239  51.263  73.902  1.00 58.25           C  
ATOM    164  C   THR    21      26.625  51.052  72.532  1.00 58.63           C  
ATOM    165  O   THR    21      27.294  51.276  71.547  1.00 59.56           O  
ATOM    166  CB  THR    21      28.229  50.062  74.160  1.00 57.95           C  
ATOM    167  OG1 THR    21      27.559  48.822  73.928  1.00 53.65           O  
ATOM    168  CG2 THR    21      28.813  50.091  75.593  1.00 57.31           C  
ATOM    169  N   GLY    22      25.388  50.561  72.458  1.00 59.40           N  
ATOM    170  CA  GLY    22      24.713  50.279  71.177  1.00 58.70           C  
ATOM    171  C   GLY    22      25.251  49.067  70.445  1.00 59.54           C  
ATOM    172  O   GLY    22      24.683  48.653  69.426  1.00 59.78           O  
ATOM    173  N   GLU    23      26.327  48.469  70.976  1.00 59.24           N  
ATOM    174  CA  GLU    23      26.980  47.302  70.367  1.00 58.58           C  
ATOM    175  C   GLU    23      26.200  45.998  70.555  1.00 58.88           C  
ATOM    176  O   GLU    23      25.259  45.959  71.333  1.00 58.65           O  
ATOM    177  CB  GLU    23      28.390  47.164  70.925  1.00 57.76           C  
ATOM    178  CG  GLU    23      29.214  48.414  70.770  1.00 58.46           C  
ATOM    179  CD  GLU    23      29.610  48.755  69.295  1.00 59.54           C  
ATOM    180  OE1 GLU    23      29.386  47.923  68.411  1.00 54.46           O  
ATOM    181  OE2 GLU    23      30.168  49.866  69.047  1.00 60.23           O  
ATOM    182  N   THR    24      26.562  44.942  69.806  1.00 59.29           N  
ATOM    183  CA  THR    24      26.049  43.581  70.074  1.00 59.56           C  
ATOM    184  C   THR    24      26.676  43.137  71.355  1.00 59.12           C  
ATOM    185  O   THR    24      27.906  43.220  71.551  1.00 59.04           O  
ATOM    186  CB  THR    24      26.459  42.569  68.998  1.00 59.44           C  
ATOM    187  OG1 THR    24      26.050  43.044  67.721  1.00 62.46           O  
ATOM    188  CG2 THR    24      25.755  41.242  69.199  1.00 60.40           C  
ATOM    189  N   VAL    25      25.836  42.700  72.267  1.00 58.81           N  
ATOM    190  CA  VAL    25      26.314  42.319  73.595  1.00 57.45           C  
ATOM    191  C   VAL    25      25.838  40.880  73.800  1.00 57.93           C  
ATOM    192  O   VAL    25      24.808  40.483  73.197  1.00 57.90           O  
ATOM    193  CB  VAL    25      25.819  43.293  74.708  1.00 57.29           C  
ATOM    194  CG1 VAL    25      26.282  44.692  74.424  1.00 57.65           C  
ATOM    195  CG2 VAL    25      24.329  43.310  74.816  1.00 58.67           C  
ATOM    196  N   ALA    26      26.564  40.088  74.618  1.00 57.17           N  
ATOM    197  CA  ALA    26      26.181  38.702  74.836  1.00 55.78           C  
ATOM    198  C   ALA    26      26.677  38.156  76.173  1.00 56.21           C  
ATOM    199  O   ALA    26      27.692  38.660  76.718  1.00 56.85           O  
ATOM    200  CB  ALA    26      26.707  37.843  73.700  1.00 55.84           C  
ATOM    201  N   ILE    27      25.957  37.134  76.666  1.00 54.82           N  
ATOM    202  CA  ILE    27      26.373  36.215  77.724  1.00 54.97           C  
ATOM    203  C   ILE    27      26.665  34.880  77.036  1.00 55.40           C  
ATOM    204  O   ILE    27      25.875  34.388  76.208  1.00 55.50           O  
ATOM    205  CB  ILE    27      25.204  35.998  78.727  1.00 54.89           C  
ATOM    206  CG1 ILE    27      24.675  37.364  79.201  1.00 58.42           C  
ATOM    207  CG2 ILE    27      25.620  35.224  79.941  1.00 54.79           C  
ATOM    208  CD1 ILE    27      25.763  38.300  79.861  1.00 56.11           C  
ATOM    209  N   ALA    28      27.814  34.304  77.343  1.00 56.24           N  
ATOM    210  CA  ALA    28      28.220  33.025  76.762  1.00 57.33           C  
ATOM    211  C   ALA    28      28.899  32.114  77.789  1.00 58.02           C  
ATOM    212  O   ALA    28      29.500  32.581  78.756  1.00 59.65           O  
ATOM    213  CB  ALA    28      29.165  33.270  75.595  1.00 57.05           C  
ATOM    214  N   THR    29      28.831  30.815  77.549  1.00 58.45           N  
ATOM    215  CA  THR    29      29.438  29.821  78.373  1.00 59.29           C  
ATOM    216  C   THR    29      30.122  28.796  77.461  1.00 60.09           C  
ATOM    217  O   THR    29      30.062  28.945  76.238  1.00 60.75           O  
ATOM    218  CB  THR    29      28.366  29.129  79.253  1.00 59.14           C  
ATOM    219  OG1 THR    29      29.027  28.212  80.107  1.00 62.44           O  
ATOM    220  CG2 THR    29      27.313  28.329  78.420  1.00 59.03           C  
ATOM    221  N   LYS    30      30.752  27.746  78.017  1.00 60.10           N  
ATOM    222  CA  LYS    30      31.294  26.714  77.138  1.00 60.17           C  
ATOM    223  C   LYS    30      30.503  25.423  77.045  1.00 60.24           C  
ATOM    224  O   LYS    30      29.848  24.988  77.989  1.00 60.38           O  
ATOM    225  CB  LYS    30      32.766  26.424  77.403  1.00 59.87           C  
ATOM    226  CG  LYS    30      33.091  25.799  78.698  1.00 58.67           C  
ATOM    227  CD  LYS    30      34.590  25.975  78.926  1.00 56.57           C  
ATOM    228  CE  LYS    30      34.916  25.743  80.373  1.00 62.17           C  
ATOM    229  NZ  LYS    30      34.346  24.439  80.917  1.00 61.02           N  
ATOM    230  N   ASN    31      30.566  24.829  75.867  1.00 60.09           N  
ATOM    231  CA  ASN    31      29.974  23.554  75.632  1.00 60.15           C  
ATOM    232  C   ASN    31      31.129  22.711  75.064  1.00 60.85           C  
ATOM    233  O   ASN    31      31.450  22.809  73.874  1.00 60.33           O  
ATOM    234  CB  ASN    31      28.809  23.697  74.659  1.00 59.81           C  
ATOM    235  CG  ASN    31      28.273  22.369  74.202  1.00 60.90           C  
ATOM    236  OD1 ASN    31      28.415  21.365  74.897  1.00 62.42           O  
ATOM    237  ND2 ASN    31      27.650  22.343  73.028  1.00 62.72           N  
ATOM    238  N   ASP    32      31.768  21.920  75.944  1.00 60.79           N  
ATOM    239  CA  ASP    32      32.969  21.138  75.588  1.00 60.54           C  
ATOM    240  C   ASP    32      34.075  22.119  75.089  1.00 59.98           C  
ATOM    241  O   ASP    32      34.582  22.895  75.888  1.00 61.62           O  
ATOM    242  CB  ASP    32      32.586  20.014  74.598  1.00 60.03           C  
ATOM    243  CG  ASP    32      33.770  19.211  74.127  1.00 61.08           C  
ATOM    244  OD1 ASP    32      34.747  19.094  74.899  1.00 61.78           O  
ATOM    245  OD2 ASP    32      33.727  18.690  72.982  1.00 60.46           O  
ATOM    246  N   ILE    33      34.429  22.136  73.811  1.00 58.31           N  
ATOM    247  CA  ILE    33      35.454  23.066  73.335  1.00 57.06           C  
ATOM    248  C   ILE    33      34.847  24.188  72.442  1.00 58.02           C  
ATOM    249  O   ILE    33      35.556  24.857  71.665  1.00 57.54           O  
ATOM    250  CB  ILE    33      36.537  22.325  72.532  1.00 56.55           C  
ATOM    251  CG1 ILE    33      35.932  21.627  71.325  1.00 53.36           C  
ATOM    252  CG2 ILE    33      37.325  21.324  73.397  1.00 55.34           C  
ATOM    253  CD1 ILE    33      36.969  21.338  70.290  1.00 56.07           C  
ATOM    254  N   TYR    34      33.531  24.347  72.532  1.00 58.02           N  
ATOM    255  CA  TYR    34      32.789  25.305  71.721  1.00 59.60           C  
ATOM    256  C   TYR    34      32.153  26.416  72.587  1.00 60.55           C  
ATOM    257  O   TYR    34      31.805  26.201  73.766  1.00 60.57           O  
ATOM    258  CB  TYR    34      31.702  24.615  70.881  1.00 58.70           C  
ATOM    259  CG  TYR    34      32.255  23.504  70.077  1.00 59.51           C  
ATOM    260  CD1 TYR    34      32.919  23.749  68.863  1.00 62.22           C  
ATOM    261  CD2 TYR    34      32.182  22.198  70.539  1.00 56.56           C  
ATOM    262  CE1 TYR    34      33.483  22.679  68.123  1.00 61.17           C  
ATOM    263  CE2 TYR    34      32.717  21.160  69.832  1.00 56.81           C  
ATOM    264  CZ  TYR    34      33.370  21.398  68.642  1.00 59.90           C  
ATOM    265  OH  TYR    34      33.887  20.328  67.971  1.00 62.06           O  
ATOM    266  N   LEU    35      31.982  27.581  71.980  1.00 60.82           N  
ATOM    267  CA  LEU    35      31.425  28.696  72.682  1.00 62.79           C  
ATOM    268  C   LEU    35      29.913  28.510  72.508  1.00 62.91           C  
ATOM    269  O   LEU    35      29.501  28.106  71.419  1.00 64.79           O  
ATOM    270  CB  LEU    35      31.945  30.022  72.105  1.00 62.74           C  
ATOM    271  CG  LEU    35      31.470  31.295  72.849  1.00 64.45           C  
ATOM    272  CD1 LEU    35      32.360  31.531  74.025  1.00 60.26           C  
ATOM    273  CD2 LEU    35      31.499  32.507  71.931  1.00 64.70           C  
ATOM    274  N   GLN    36      29.144  28.723  73.586  0.70 62.01           N  
ATOM    276  CA  GLN    36      27.698  28.652  73.584  0.70 61.91           C  
ATOM    278  C   GLN    36      27.186  30.009  74.064  0.70 62.05           C  
ATOM    280  O   GLN    36      27.602  30.512  75.114  0.70 60.93           O  
ATOM    282  CB  GLN    36      27.220  27.558  74.527  0.70 61.83           C  
ATOM    284  CG  GLN    36      25.819  27.041  74.247  0.70 63.49           C  
ATOM    286  CD  GLN    36      25.239  26.247  75.415  0.70 63.28           C  
ATOM    288  OE1 GLN    36      25.812  25.265  75.837  0.70 68.16           O  
ATOM    290  NE2 GLN    36      24.103  26.691  75.946  0.70 65.60           N  
ATOM    292  N   TYR    37      26.295  30.613  73.278  1.00 61.85           N  
ATOM    293  CA  TYR    37      25.624  31.862  73.670  1.00 61.15           C  
ATOM    294  C   TYR    37      24.399  31.593  74.494  1.00 59.84           C  
ATOM    295  O   TYR    37      23.619  30.759  74.123  1.00 60.44           O  
ATOM    296  CB  TYR    37      25.248  32.676  72.430  1.00 61.54           C  
ATOM    297  CG  TYR    37      26.466  33.251  71.790  1.00 62.86           C  
ATOM    298  CD1 TYR    37      27.216  34.220  72.442  1.00 60.43           C  
ATOM    299  CD2 TYR    37      26.901  32.809  70.537  1.00 65.34           C  
ATOM    300  CE1 TYR    37      28.366  34.738  71.876  1.00 60.87           C  
ATOM    301  CE2 TYR    37      28.061  33.346  69.965  1.00 62.90           C  
ATOM    302  CZ  TYR    37      28.768  34.301  70.635  1.00 63.13           C  
ATOM    303  OH  TYR    37      29.918  34.831  70.071  1.00 67.04           O  
ATOM    304  N   ILE    38      24.230  32.289  75.610  1.00 59.21           N  
ATOM    305  CA  ILE    38      23.013  32.139  76.463  1.00 58.20           C  
ATOM    306  C   ILE    38      21.998  33.234  76.094  1.00 57.77           C  
ATOM    307  O   ILE    38      20.779  33.008  76.118  1.00 58.35           O  
ATOM    308  CB  ILE    38      23.383  32.227  77.946  1.00 58.32           C  
ATOM    309  CG1 ILE    38      24.010  30.910  78.398  1.00 58.97           C  
ATOM    310  CG2 ILE    38      22.166  32.562  78.833  1.00 58.69           C  
ATOM    311  CD1 ILE    38      24.888  31.011  79.594  1.00 57.72           C  
ATOM    312  N   GLN    39      22.504  34.415  75.721  1.00 55.55           N  
ATOM    313  CA  GLN    39      21.666  35.556  75.381  1.00 54.01           C  
ATOM    314  C   GLN    39      22.493  36.510  74.615  1.00 53.04           C  
ATOM    315  O   GLN    39      23.646  36.769  74.994  1.00 54.10           O  
ATOM    316  CB  GLN    39      21.143  36.318  76.610  1.00 53.35           C  
ATOM    317  CG  GLN    39      20.273  37.518  76.256  1.00 51.78           C  
ATOM    318  CD  GLN    39      18.924  37.104  75.683  1.00 53.58           C  
ATOM    319  OE1 GLN    39      18.125  36.427  76.351  1.00 54.79           O  
ATOM    320  NE2 GLN    39      18.642  37.543  74.460  1.00 51.38           N  
ATOM    321  N   ILE    40      21.872  37.048  73.576  1.00 53.01           N  
ATOM    322  CA  ILE    40      22.460  37.999  72.648  1.00 54.32           C  
ATOM    323  C   ILE    40      21.443  39.089  72.532  1.00 54.45           C  
ATOM    324  O   ILE    40      20.241  38.802  72.387  1.00 53.13           O  
ATOM    325  CB  ILE    40      22.644  37.356  71.237  1.00 54.92           C  
ATOM    326  CG1 ILE    40      23.673  36.232  71.341  1.00 56.91           C  
ATOM    327  CG2 ILE    40      23.088  38.411  70.174  1.00 53.95           C  
ATOM    328  CD1 ILE    40      23.497  35.220  70.200  1.00 62.70           C  
ATOM    329  N   ILE    41      21.916  40.324  72.646  1.00 54.89           N  
ATOM    330  CA  ILE    41      21.146  41.479  72.242  1.00 56.47           C  
ATOM    331  C   ILE    41      21.851  42.189  71.064  1.00 57.24           C  
ATOM    332  O   ILE    41      23.010  42.600  71.162  1.00 56.09           O  
ATOM    333  CB  ILE    41      20.922  42.413  73.437  1.00 57.58           C  
ATOM    334  CG1 ILE    41      20.309  41.618  74.606  1.00 56.84           C  
ATOM    335  CG2 ILE    41      20.059  43.630  73.025  1.00 56.15           C  
ATOM    336  CD1 ILE    41      20.249  42.418  75.898  1.00 57.64           C  
ATOM    337  N   GLU    42      21.150  42.275  69.930  0.50 58.60           N  
ATOM    339  CA  GLU    42      21.737  42.779  68.677  0.50 59.91           C  
ATOM    341  C   GLU    42      21.887  44.290  68.699  0.50 59.38           C  
ATOM    343  O   GLU    42      21.031  45.008  69.225  0.50 60.09           O  
ATOM    345  CB  GLU    42      20.937  42.327  67.437  0.50 59.70           C  
ATOM    347  CG  GLU    42      21.709  42.516  66.084  0.50 61.58           C  
ATOM    349  CD  GLU    42      21.014  41.884  64.855  0.50 62.17           C  
ATOM    351  OE1 GLU    42      21.072  40.629  64.699  0.50 64.45           O  
ATOM    353  OE2 GLU    42      20.432  42.649  64.041  0.50 60.87           O  
ATOM    355  N   SER    43      23.002  44.740  68.141  1.00 59.25           N  
ATOM    356  CA  SER    43      23.355  46.133  67.959  1.00 58.50           C  
ATOM    357  C   SER    43      22.298  46.897  67.185  1.00 58.46           C  
ATOM    358  O   SER    43      21.519  46.314  66.445  1.00 59.01           O  
ATOM    359  CB  SER    43      24.674  46.202  67.167  1.00 57.90           C  
ATOM    360  OG  SER    43      25.051  47.555  66.994  1.00 59.25           O  
ATOM    361  N   VAL    44      22.286  48.217  67.359  1.00 58.06           N  
ATOM    362  CA  VAL    44      21.468  49.108  66.579  1.00 57.11           C  
ATOM    363  C   VAL    44      22.321  49.846  65.533  1.00 56.38           C  
ATOM    364  O   VAL    44      21.790  50.674  64.814  1.00 55.77           O  
ATOM    365  CB  VAL    44      20.806  50.149  67.484  1.00 57.90           C  
ATOM    366  CG1 VAL    44      19.692  49.471  68.322  1.00 59.20           C  
ATOM    367  CG2 VAL    44      21.886  50.864  68.405  1.00 56.67           C  
ATOM    368  N   HIS    45      23.625  49.575  65.457  1.00 54.20           N  
ATOM    369  CA  HIS    45      24.435  50.225  64.413  1.00 54.33           C  
ATOM    370  C   HIS    45      24.166  49.611  63.037  1.00 54.09           C  
ATOM    371  O   HIS    45      23.789  48.445  62.908  1.00 54.12           O  
ATOM    372  CB  HIS    45      25.929  50.109  64.736  1.00 53.49           C  
ATOM    373  CG  HIS    45      26.285  50.704  66.062  1.00 55.56           C  
ATOM    374  ND1 HIS    45      26.153  52.056  66.339  1.00 52.55           N  
ATOM    375  CD2 HIS    45      26.731  50.123  67.205  1.00 55.86           C  
ATOM    376  CE1 HIS    45      26.518  52.280  67.589  1.00 55.53           C  
ATOM    377  NE2 HIS    45      26.884  51.125  68.132  1.00 58.42           N  
ATOM    378  N   ALA    46      24.391  50.392  62.015  1.00 54.07           N  
ATOM    379  CA  ALA    46      24.227  49.917  60.652  1.00 55.35           C  
ATOM    380  C   ALA    46      25.188  48.734  60.377  1.00 55.86           C  
ATOM    381  O   ALA    46      24.779  47.633  59.972  1.00 55.11           O  
ATOM    382  CB  ALA    46      24.506  51.069  59.699  1.00 54.46           C  
ATOM    383  N   LEU    47      26.467  48.962  60.621  1.00 55.28           N  
ATOM    384  CA  LEU    47      27.377  47.918  60.442  1.00 56.25           C  
ATOM    385  C   LEU    47      27.511  47.148  61.767  1.00 57.03           C  
ATOM    386  O   LEU    47      28.034  47.672  62.734  1.00 57.57           O  
ATOM    387  CB  LEU    47      28.693  48.504  59.974  1.00 55.59           C  
ATOM    388  CG  LEU    47      29.831  47.494  59.835  1.00 57.97           C  
ATOM    389  CD1 LEU    47      29.449  46.359  58.803  1.00 54.62           C  
ATOM    390  CD2 LEU    47      31.099  48.273  59.426  1.00 55.91           C  
ATOM    391  N   ARG    48      27.074  45.897  61.817  1.00 58.29           N  
ATOM    392  CA  ARG    48      27.158  45.153  63.069  1.00 59.99           C  
ATOM    393  C   ARG    48      27.398  43.654  62.958  1.00 61.56           C  
ATOM    394  O   ARG    48      27.378  43.087  61.867  1.00 61.63           O  
ATOM    395  CB  ARG    48      25.875  45.345  63.836  1.00 60.62           C  
ATOM    396  CG  ARG    48      24.702  44.576  63.294  1.00 58.36           C  
ATOM    397  CD  ARG    48      23.538  45.335  63.769  1.00 62.40           C  
ATOM    398  NE  ARG    48      22.270  44.850  63.280  1.00 64.49           N  
ATOM    399  CZ  ARG    48      21.233  45.649  63.067  1.00 64.30           C  
ATOM    400  NH1 ARG    48      21.351  46.959  63.281  1.00 63.31           N  
ATOM    401  NH2 ARG    48      20.094  45.141  62.613  1.00 63.51           N  
ATOM    402  N   PHE    49      27.599  43.027  64.115  1.00 63.14           N  
ATOM    403  CA  PHE    49      27.646  41.567  64.221  1.00 65.24           C  
ATOM    404  C   PHE    49      26.239  41.014  64.215  1.00 65.96           C  
ATOM    405  O   PHE    49      25.409  41.464  65.015  1.00 66.23           O  
ATOM    406  CB  PHE    49      28.359  41.136  65.513  1.00 66.03           C  
ATOM    407  CG  PHE    49      29.859  41.075  65.381  1.00 68.58           C  
ATOM    408  CD1 PHE    49      30.680  41.662  66.330  1.00 70.90           C  
ATOM    409  CD2 PHE    49      30.452  40.445  64.290  1.00 70.05           C  
ATOM    410  CE1 PHE    49      32.091  41.589  66.235  1.00 72.91           C  
ATOM    411  CE2 PHE    49      31.845  40.399  64.170  1.00 73.92           C  
ATOM    412  CZ  PHE    49      32.672  40.974  65.173  1.00 70.09           C  
ATOM    413  N   HIS    50      25.962  40.103  63.284  1.00 66.85           N  
ATOM    414  CA  HIS    50      24.758  39.309  63.317  1.00 68.69           C  
ATOM    415  C   HIS    50      25.208  37.896  63.694  1.00 70.93           C  
ATOM    416  O   HIS    50      25.696  37.140  62.841  1.00 72.02           O  
ATOM    417  CB  HIS    50      24.075  39.262  61.959  1.00 68.34           C  
ATOM    418  CG  HIS    50      23.636  40.593  61.434  1.00 66.68           C  
ATOM    419  ND1 HIS    50      24.521  41.613  61.145  1.00 67.30           N  
ATOM    420  CD2 HIS    50      22.408  41.048  61.085  1.00 66.59           C  
ATOM    421  CE1 HIS    50      23.850  42.645  60.650  1.00 69.25           C  
ATOM    422  NE2 HIS    50      22.565  42.327  60.598  1.00 67.09           N  
ATOM    423  N   VAL    51      25.074  37.542  64.969  1.00 72.80           N  
ATOM    424  CA  VAL    51      25.490  36.225  65.440  1.00 74.54           C  
ATOM    425  C   VAL    51      24.566  35.166  64.884  1.00 76.64           C  
ATOM    426  O   VAL    51      23.370  35.197  65.174  1.00 78.19           O  
ATOM    427  CB  VAL    51      25.536  36.112  67.004  1.00 74.55           C  
ATOM    428  CG1 VAL    51      26.104  34.706  67.433  1.00 74.48           C  
ATOM    429  CG2 VAL    51      26.337  37.271  67.630  1.00 70.10           C  
ATOM    430  N   ASP    52      25.115  34.279  64.049  1.00 78.72           N  
ATOM    431  CA  ASP    52      24.439  33.061  63.575  1.00 81.20           C  
ATOM    432  C   ASP    52      24.609  31.950  64.617  1.00 82.80           C  
ATOM    433  O   ASP    52      25.737  31.513  64.892  1.00 83.06           O  
ATOM    434  CB  ASP    52      25.040  32.609  62.241  1.00 81.03           C  
ATOM    435  CG  ASP    52      24.673  31.184  61.876  1.00 83.02           C  
ATOM    436  OD1 ASP    52      23.734  30.577  62.458  1.00 84.81           O  
ATOM    437  OD2 ASP    52      25.347  30.655  60.982  1.00 84.60           O  
ATOM    438  N   GLU    53      23.492  31.484  65.176  1.00 84.68           N  
ATOM    439  CA  GLU    53      23.530  30.555  66.322  1.00 85.92           C  
ATOM    440  C   GLU    53      23.834  29.109  65.886  1.00 85.79           C  
ATOM    441  O   GLU    53      24.435  28.337  66.633  1.00 85.94           O  
ATOM    442  CB  GLU    53      22.220  30.629  67.119  1.00 86.63           C  
ATOM    443  CG  GLU    53      22.102  31.862  68.024  0.60 87.28           C  
ATOM    444  CD  GLU    53      20.726  32.513  67.933  0.60 89.75           C  
ATOM    445  OE1 GLU    53      19.709  31.792  67.794  0.60 90.02           O  
ATOM    446  OE2 GLU    53      20.658  33.760  68.016  0.60 91.66           O  
ATOM    447  N   ASN    54      23.439  28.755  64.670  1.00 85.26           N  
ATOM    448  CA  ASN    54      23.786  27.446  64.124  1.00 84.59           C  
ATOM    449  C   ASN    54      25.318  27.277  63.940  1.00 83.75           C  
ATOM    450  O   ASN    54      25.804  26.162  63.726  1.00 83.96           O  
ATOM    451  CB  ASN    54      23.039  27.208  62.800  0.60 84.69           C  
ATOM    452  CG  ASN    54      22.767  25.720  62.520  0.60 86.08           C  
ATOM    453  OD1 ASN    54      23.307  24.824  63.184  0.60 86.21           O  
ATOM    454  ND2 ASN    54      21.925  25.459  61.519  0.60 86.49           N  
ATOM    455  N   ALA    55      26.067  28.380  64.003  1.00 81.92           N  
ATOM    456  CA  ALA    55      27.524  28.342  63.826  1.00 80.70           C  
ATOM    457  C   ALA    55      28.178  27.586  64.984  1.00 79.23           C  
ATOM    458  O   ALA    55      27.803  27.762  66.133  1.00 79.82           O  
ATOM    459  CB  ALA    55      28.111  29.781  63.712  1.00 80.15           C  
ATOM    460  N   ILE    56      29.151  26.744  64.673  1.00 77.79           N  
ATOM    461  CA  ILE    56      29.908  25.989  65.678  1.00 75.90           C  
ATOM    462  C   ILE    56      31.181  26.767  65.873  1.00 74.50           C  
ATOM    463  O   ILE    56      31.910  26.976  64.913  1.00 74.29           O  
ATOM    464  CB  ILE    56      30.321  24.589  65.149  1.00 76.40           C  
ATOM    465  CG1 ILE    56      29.092  23.763  64.712  1.00 75.34           C  
ATOM    466  CG2 ILE    56      31.187  23.862  66.178  1.00 75.84           C  
ATOM    467  CD1 ILE    56      29.325  22.980  63.417  1.00 77.73           C  
ATOM    468  N   ARG    57      31.487  27.201  67.086  1.00 72.12           N  
ATOM    469  CA  ARG    57      32.693  27.987  67.183  1.00 69.90           C  
ATOM    470  C   ARG    57      33.635  27.565  68.274  1.00 66.50           C  
ATOM    471  O   ARG    57      33.315  27.693  69.445  1.00 66.81           O  
ATOM    472  CB  ARG    57      32.374  29.478  67.250  1.00 70.93           C  
ATOM    473  CG  ARG    57      31.240  29.833  68.125  1.00 76.49           C  
ATOM    474  CD  ARG    57      30.491  31.104  67.618  1.00 84.39           C  
ATOM    475  NE  ARG    57      29.043  30.863  67.752  1.00 89.80           N  
ATOM    476  CZ  ARG    57      28.082  31.417  67.016  1.00 91.00           C  
ATOM    477  NH1 ARG    57      28.343  32.318  66.062  1.00 89.27           N  
ATOM    478  NH2 ARG    57      26.837  31.055  67.262  1.00 94.92           N  
ATOM    479  N   PRO    58      34.812  27.064  67.894  1.00 63.24           N  
ATOM    480  CA  PRO    58      35.795  26.606  68.893  1.00 60.90           C  
ATOM    481  C   PRO    58      36.292  27.734  69.769  1.00 59.63           C  
ATOM    482  O   PRO    58      36.399  28.876  69.317  1.00 58.11           O  
ATOM    483  CB  PRO    58      36.936  26.041  68.045  1.00 60.40           C  
ATOM    484  CG  PRO    58      36.333  25.842  66.652  1.00 61.19           C  
ATOM    485  CD  PRO    58      35.270  26.871  66.507  1.00 62.00           C  
ATOM    486  N   LEU    59      36.609  27.414  71.019  1.00 59.37           N  
ATOM    487  CA  LEU    59      37.029  28.425  72.022  1.00 59.11           C  
ATOM    488  C   LEU    59      38.287  29.220  71.640  1.00 58.79           C  
ATOM    489  O   LEU    59      38.460  30.373  72.082  1.00 57.89           O  
ATOM    490  CB  LEU    59      37.198  27.794  73.415  1.00 58.49           C  
ATOM    491  CG  LEU    59      35.901  27.243  74.025  1.00 59.78           C  
ATOM    492  CD1 LEU    59      36.126  26.407  75.321  1.00 58.03           C  
ATOM    493  CD2 LEU    59      34.899  28.333  74.296  1.00 61.08           C  
ATOM    494  N   THR    60      39.165  28.627  70.834  1.00 58.42           N  
ATOM    495  CA  THR    60      40.355  29.358  70.385  1.00 59.36           C  
ATOM    496  C   THR    60      40.040  30.565  69.445  1.00 60.12           C  
ATOM    497  O   THR    60      40.906  31.385  69.165  1.00 60.01           O  
ATOM    498  CB  THR    60      41.361  28.430  69.673  1.00 59.36           C  
ATOM    499  OG1 THR    60      40.676  27.731  68.642  1.00 59.76           O  
ATOM    500  CG2 THR    60      42.023  27.433  70.630  1.00 56.72           C  
ATOM    501  N   MET    61      38.809  30.682  68.978  1.00 60.58           N  
ATOM    502  CA  MET    61      38.537  31.613  67.887  1.00 62.59           C  
ATOM    503  C   MET    61      37.882  32.922  68.305  1.00 62.66           C  
ATOM    504  O   MET    61      37.505  33.689  67.422  1.00 63.60           O  
ATOM    505  CB  MET    61      37.683  30.942  66.796  1.00 62.56           C  
ATOM    506  CG  MET    61      38.402  29.794  66.080  1.00 67.94           C  
ATOM    507  SD  MET    61      39.847  30.478  64.868  0.90 83.32          SE  
ATOM    508  CE  MET    61      38.659  31.285  63.505  1.00 77.45           C  
ATOM    509  N   SER    62      37.721  33.171  69.610  1.00 61.38           N  
ATOM    510  CA  SER    62      37.147  34.424  70.072  1.00 61.72           C  
ATOM    511  C   SER    62      37.695  34.811  71.425  1.00 62.10           C  
ATOM    512  O   SER    62      38.123  33.954  72.211  1.00 62.73           O  
ATOM    513  CB  SER    62      35.625  34.314  70.193  1.00 61.40           C  
ATOM    514  OG  SER    62      35.327  33.225  71.043  1.00 61.28           O  
ATOM    515  N   SER    63      37.680  36.107  71.713  1.00 62.25           N  
ATOM    516  CA  SER    63      38.120  36.572  73.022  1.00 61.90           C  
ATOM    517  C   SER    63      37.217  35.966  74.109  1.00 61.96           C  
ATOM    518  O   SER    63      37.692  35.658  75.202  1.00 62.43           O  
ATOM    519  CB  SER    63      38.114  38.099  73.078  1.00 61.78           C  
ATOM    520  OG  SER    63      36.778  38.581  72.922  1.00 63.32           O  
ATOM    521  N   ASN    64      35.928  35.765  73.825  1.00 62.05           N  
ATOM    522  CA  ASN    64      35.058  35.037  74.789  1.00 63.21           C  
ATOM    523  C   ASN    64      35.599  33.635  75.064  1.00 62.15           C  
ATOM    524  O   ASN    64      35.608  33.220  76.205  1.00 62.11           O  
ATOM    525  CB  ASN    64      33.632  34.858  74.260  1.00 65.22           C  
ATOM    526  CG  ASN    64      32.778  36.042  74.477  1.00 68.29           C  
ATOM    527  OD1 ASN    64      32.593  36.515  75.600  1.00 79.28           O  
ATOM    528  ND2 ASN    64      32.227  36.524  73.425  1.00 70.86           N  
ATOM    529  N   GLY    65      36.030  32.934  74.000  1.00 60.23           N  
ATOM    530  CA  GLY    65      36.699  31.675  74.116  1.00 60.81           C  
ATOM    531  C   GLY    65      37.903  31.664  75.057  1.00 60.68           C  
ATOM    532  O   GLY    65      37.973  30.840  75.976  1.00 60.10           O  
ATOM    533  N   TRP    66      38.835  32.588  74.856  1.00 60.85           N  
ATOM    534  CA  TRP    66      40.039  32.658  75.709  1.00 60.06           C  
ATOM    535  C   TRP    66      39.646  32.902  77.155  1.00 61.15           C  
ATOM    536  O   TRP    66      40.247  32.351  78.101  1.00 61.99           O  
ATOM    537  CB  TRP    66      40.997  33.752  75.215  1.00 59.30           C  
ATOM    538  CG  TRP    66      41.271  33.740  73.697  1.00 57.28           C  
ATOM    539  CD1 TRP    66      41.269  32.654  72.901  1.00 57.25           C  
ATOM    540  CD2 TRP    66      41.640  34.855  72.848  1.00 57.57           C  
ATOM    541  NE1 TRP    66      41.578  32.999  71.603  1.00 59.16           N  
ATOM    542  CE2 TRP    66      41.805  34.345  71.537  1.00 58.40           C  
ATOM    543  CE3 TRP    66      41.845  36.233  73.066  1.00 57.46           C  
ATOM    544  CZ2 TRP    66      42.141  35.160  70.434  1.00 58.20           C  
ATOM    545  CZ3 TRP    66      42.174  37.045  71.978  1.00 57.05           C  
ATOM    546  CH2 TRP    66      42.321  36.504  70.679  1.00 58.18           C  
ATOM    547  N   MET    67      38.620  33.721  77.354  1.00 61.67           N  
ATOM    548  CA  MET    67      38.196  34.034  78.730  1.00 61.56           C  
ATOM    549  C   MET    67      37.675  32.751  79.398  1.00 61.45           C  
ATOM    550  O   MET    67      38.030  32.471  80.533  1.00 60.34           O  
ATOM    551  CB  MET    67      37.128  35.144  78.733  1.00 62.34           C  
ATOM    552  CG  MET    67      36.847  35.786  80.055  1.00 62.83           C  
ATOM    553  SD  MET    67      38.278  37.022  80.632  0.85 76.26          SE  
ATOM    554  CE  MET    67      38.995  36.079  82.228  1.00 64.02           C  
ATOM    555  N   LEU    68      36.867  31.969  78.669  1.00 61.35           N  
ATOM    556  CA  LEU    68      36.327  30.715  79.196  1.00 61.71           C  
ATOM    557  C   LEU    68      37.367  29.609  79.436  1.00 62.43           C  
ATOM    558  O   LEU    68      37.310  28.891  80.449  1.00 62.05           O  
ATOM    559  CB  LEU    68      35.192  30.211  78.333  1.00 60.42           C  
ATOM    560  CG  LEU    68      34.014  31.190  78.339  1.00 59.67           C  
ATOM    561  CD1 LEU    68      33.203  31.009  77.111  1.00 53.38           C  
ATOM    562  CD2 LEU    68      33.125  31.045  79.587  1.00 56.87           C  
ATOM    563  N   MET    69      38.317  29.487  78.513  1.00 63.63           N  
ATOM    564  CA  MET    69      39.427  28.542  78.640  1.00 64.95           C  
ATOM    565  C   MET    69      40.298  28.887  79.821  1.00 63.85           C  
ATOM    566  O   MET    69      40.834  27.978  80.490  1.00 64.09           O  
ATOM    567  CB  MET    69      40.270  28.585  77.399  1.00 64.13           C  
ATOM    568  CG  MET    69      39.630  27.926  76.207  1.00 66.68           C  
ATOM    569  SD  MET    69      40.939  27.724  74.726  0.80 72.58          SE  
ATOM    570  CE  MET    69      40.747  29.457  73.987  1.00 62.11           C  
ATOM    571  N   SER    70      40.446  30.189  80.094  1.00 62.96           N  
ATOM    572  CA  SER    70      41.251  30.621  81.248  1.00 62.56           C  
ATOM    573  C   SER    70      40.745  30.049  82.590  1.00 61.84           C  
ATOM    574  O   SER    70      41.468  30.041  83.576  1.00 59.67           O  
ATOM    575  CB  SER    70      41.397  32.144  81.294  1.00 62.63           C  
ATOM    576  OG  SER    70      40.243  32.758  81.855  1.00 63.93           O  
ATOM    577  N   THR    71      39.523  29.517  82.591  1.00 62.19           N  
ATOM    578  CA  THR    71      38.983  28.859  83.794  1.00 63.14           C  
ATOM    579  C   THR    71      39.332  27.364  83.967  1.00 63.92           C  
ATOM    580  O   THR    71      39.199  26.839  85.071  1.00 62.99           O  
ATOM    581  CB  THR    71      37.458  29.064  83.955  1.00 62.41           C  
ATOM    582  OG1 THR    71      36.769  28.302  82.965  1.00 62.66           O  
ATOM    583  CG2 THR    71      37.098  30.522  83.810  1.00 61.93           C  
ATOM    584  N   MET    72      39.778  26.694  82.897  1.00 65.08           N  
ATOM    585  CA  MET    72      40.146  25.276  82.957  1.00 67.60           C  
ATOM    586  C   MET    72      41.548  25.007  83.593  1.00 66.23           C  
ATOM    587  O   MET    72      42.373  25.922  83.722  1.00 65.90           O  
ATOM    588  CB  MET    72      40.104  24.668  81.553  1.00 67.24           C  
ATOM    589  CG  MET    72      38.781  24.730  80.785  1.00 68.31           C  
ATOM    590  SD  MET    72      39.303  24.612  78.854  0.83 75.69          SE  
ATOM    591  CE  MET    72      37.549  24.486  78.022  1.00 70.38           C  
ATOM    592  N   ASN    73      41.822  23.756  83.975  1.00 65.62           N  
ATOM    593  CA  ASN    73      43.211  23.352  84.255  1.00 65.21           C  
ATOM    594  C   ASN    73      44.043  23.140  82.967  1.00 64.52           C  
ATOM    595  O   ASN    73      43.489  23.091  81.854  1.00 64.27           O  
ATOM    596  CB  ASN    73      43.283  22.131  85.181  1.00 65.82           C  
ATOM    597  CG  ASN    73      42.587  20.888  84.604  1.00 67.09           C  
ATOM    598  OD1 ASN    73      42.952  20.361  83.538  1.00 64.81           O  
ATOM    599  ND2 ASN    73      41.595  20.394  85.344  1.00 69.28           N  
ATOM    600  N   ASP    74      45.366  23.035  83.110  1.00 63.68           N  
ATOM    601  CA  ASP    74      46.261  23.053  81.935  1.00 63.28           C  
ATOM    602  C   ASP    74      46.104  21.827  81.067  1.00 62.96           C  
ATOM    603  O   ASP    74      46.128  21.926  79.841  1.00 62.13           O  
ATOM    604  CB  ASP    74      47.734  23.235  82.331  1.00 63.20           C  
ATOM    605  CG  ASP    74      48.018  24.603  82.948  1.00 62.80           C  
ATOM    606  OD1 ASP    74      47.344  25.614  82.582  1.00 57.50           O  
ATOM    607  OD2 ASP    74      48.943  24.654  83.805  1.00 63.27           O  
ATOM    608  N   LYS    75      45.951  20.669  81.716  1.00 63.12           N  
ATOM    609  CA  LYS    75      45.617  19.425  81.016  1.00 63.50           C  
ATOM    610  C   LYS    75      44.442  19.643  80.021  1.00 62.99           C  
ATOM    611  O   LYS    75      44.553  19.282  78.838  1.00 62.58           O  
ATOM    612  CB  LYS    75      45.302  18.311  82.018  1.00 64.00           C  
ATOM    613  CG  LYS    75      44.618  17.073  81.419  1.00 66.39           C  
ATOM    614  CD  LYS    75      45.609  16.170  80.682  1.00 68.66           C  
ATOM    615  CE  LYS    75      45.215  14.702  80.810  1.00 69.70           C  
ATOM    616  NZ  LYS    75      44.822  14.371  82.205  1.00 68.07           N  
ATOM    617  N   ALA    76      43.358  20.251  80.518  1.00 62.16           N  
ATOM    618  CA  ALA    76      42.173  20.555  79.738  1.00 61.81           C  
ATOM    619  C   ALA    76      42.404  21.654  78.702  1.00 61.74           C  
ATOM    620  O   ALA    76      41.778  21.620  77.655  1.00 62.13           O  
ATOM    621  CB  ALA    76      40.962  20.889  80.643  1.00 61.24           C  
ATOM    622  N   ILE    77      43.291  22.611  78.960  1.00 61.38           N  
ATOM    623  CA  ILE    77      43.527  23.668  77.966  1.00 61.49           C  
ATOM    624  C   ILE    77      44.270  23.122  76.741  1.00 61.52           C  
ATOM    625  O   ILE    77      43.900  23.431  75.582  1.00 61.15           O  
ATOM    626  CB  ILE    77      44.272  24.870  78.563  1.00 61.79           C  
ATOM    627  CG1 ILE    77      43.304  25.714  79.384  1.00 62.94           C  
ATOM    628  CG2 ILE    77      44.891  25.749  77.483  1.00 61.12           C  
ATOM    629  CD1 ILE    77      44.013  26.581  80.448  1.00 64.59           C  
ATOM    630  N   ASP    78      45.301  22.325  77.025  1.00 60.60           N  
ATOM    631  CA  ASP    78      46.123  21.617  76.035  1.00 60.87           C  
ATOM    632  C   ASP    78      45.265  20.716  75.162  1.00 60.02           C  
ATOM    633  O   ASP    78      45.365  20.782  73.944  1.00 60.82           O  
ATOM    634  CB  ASP    78      47.235  20.818  76.743  1.00 61.04           C  
ATOM    635  CG  ASP    78      48.164  20.069  75.768  1.00 63.40           C  
ATOM    636  OD1 ASP    78      49.198  20.665  75.346  1.00 64.85           O  
ATOM    637  OD2 ASP    78      47.897  18.863  75.476  1.00 63.02           O  
ATOM    638  N   ASN    79      44.386  19.920  75.764  1.00 58.88           N  
ATOM    639  CA  ASN    79      43.433  19.133  74.969  1.00 58.94           C  
ATOM    640  C   ASN    79      42.545  20.000  74.060  1.00 58.14           C  
ATOM    641  O   ASN    79      42.268  19.633  72.918  1.00 57.90           O  
ATOM    642  CB  ASN    79      42.566  18.223  75.848  1.00 59.09           C  
ATOM    643  CG  ASN    79      43.241  16.904  76.173  1.00 62.16           C  
ATOM    644  OD1 ASN    79      43.004  16.335  77.229  1.00 68.10           O  
ATOM    645  ND2 ASN    79      44.111  16.423  75.286  1.00 64.79           N  
ATOM    646  N   THR    80      42.128  21.144  74.586  1.00 56.98           N  
ATOM    647  CA  THR    80      41.215  22.041  73.923  1.00 56.94           C  
ATOM    648  C   THR    80      41.865  22.679  72.704  1.00 57.00           C  
ATOM    649  O   THR    80      41.270  22.741  71.660  1.00 56.26           O  
ATOM    650  CB  THR    80      40.747  23.142  74.904  1.00 56.98           C  
ATOM    651  OG1 THR    80      40.079  22.527  76.017  1.00 57.25           O  
ATOM    652  CG2 THR    80      39.822  24.144  74.210  1.00 54.70           C  
ATOM    653  N   VAL    81      43.106  23.121  72.845  1.00 57.77           N  
ATOM    654  CA  VAL    81      43.812  23.793  71.760  1.00 58.51           C  
ATOM    655  C   VAL    81      44.132  22.771  70.661  1.00 59.17           C  
ATOM    656  O   VAL    81      43.908  23.026  69.446  1.00 59.51           O  
ATOM    657  CB  VAL    81      45.077  24.485  72.298  1.00 58.47           C  
ATOM    658  CG1 VAL    81      45.956  25.012  71.173  1.00 59.77           C  
ATOM    659  CG2 VAL    81      44.667  25.627  73.229  1.00 58.29           C  
ATOM    660  N   ARG    82      44.650  21.625  71.097  1.00 58.86           N  
ATOM    661  CA  ARG    82      44.843  20.479  70.223  1.00 59.54           C  
ATOM    662  C   ARG    82      43.578  20.079  69.460  1.00 58.76           C  
ATOM    663  O   ARG    82      43.616  19.944  68.232  1.00 58.98           O  
ATOM    664  CB  ARG    82      45.336  19.280  71.016  1.00 59.66           C  
ATOM    665  CG  ARG    82      46.764  19.394  71.436  1.00 62.54           C  
ATOM    666  CD  ARG    82      47.353  18.008  71.689  1.00 68.17           C  
ATOM    667  NE  ARG    82      48.644  18.100  72.370  1.00 72.16           N  
ATOM    668  CZ  ARG    82      49.756  18.641  71.857  1.00 74.78           C  
ATOM    669  NH1 ARG    82      50.854  18.663  72.601  1.00 77.11           N  
ATOM    670  NH2 ARG    82      49.788  19.166  70.627  1.00 74.25           N  
ATOM    671  N   ARG    83      42.471  19.868  70.171  1.00 57.49           N  
ATOM    672  CA  ARG    83      41.263  19.414  69.504  1.00 56.42           C  
ATOM    673  C   ARG    83      40.747  20.521  68.593  1.00 57.09           C  
ATOM    674  O   ARG    83      40.403  20.291  67.422  1.00 57.36           O  
ATOM    675  CB  ARG    83      40.222  19.001  70.508  1.00 55.85           C  
ATOM    676  CG  ARG    83      40.414  17.634  71.086  1.00 52.71           C  
ATOM    677  CD  ARG    83      39.437  17.479  72.198  1.00 49.77           C  
ATOM    678  NE  ARG    83      38.088  17.644  71.693  1.00 50.59           N  
ATOM    679  CZ  ARG    83      36.995  17.770  72.437  1.00 51.09           C  
ATOM    680  NH1 ARG    83      35.796  17.947  71.861  1.00 52.66           N  
ATOM    681  NH2 ARG    83      37.089  17.758  73.743  1.00 48.77           N  
ATOM    682  N   ALA    84      40.759  21.740  69.114  1.00 56.57           N  
ATOM    683  CA  ALA    84      40.339  22.870  68.356  1.00 56.57           C  
ATOM    684  C   ALA    84      41.197  23.105  67.084  1.00 57.76           C  
ATOM    685  O   ALA    84      40.669  23.593  66.068  1.00 57.61           O  
ATOM    686  CB  ALA    84      40.286  24.127  69.264  1.00 55.96           C  
ATOM    687  N   ASN    85      42.490  22.782  67.118  1.00 58.24           N  
ATOM    688  CA  ASN    85      43.273  22.956  65.905  1.00 60.37           C  
ATOM    689  C   ASN    85      42.833  22.048  64.775  1.00 60.82           C  
ATOM    690  O   ASN    85      42.806  22.477  63.633  1.00 60.37           O  
ATOM    691  CB  ASN    85      44.775  22.831  66.141  1.00 60.47           C  
ATOM    692  CG  ASN    85      45.333  24.018  66.874  1.00 62.26           C  
ATOM    693  OD1 ASN    85      44.775  25.138  66.813  1.00 63.47           O  
ATOM    694  ND2 ASN    85      46.422  23.794  67.594  1.00 60.57           N  
ATOM    695  N   THR    86      42.459  20.806  65.091  1.00 61.75           N  
ATOM    696  CA  THR    86      42.035  19.873  64.035  1.00 62.30           C  
ATOM    697  C   THR    86      40.785  20.329  63.280  1.00 63.07           C  
ATOM    698  O   THR    86      40.472  19.804  62.212  1.00 63.65           O  
ATOM    699  CB  THR    86      41.828  18.456  64.559  1.00 62.23           C  
ATOM    700  OG1 THR    86      40.606  18.376  65.330  1.00 61.94           O  
ATOM    701  CG2 THR    86      43.042  18.049  65.370  1.00 60.63           C  
ATOM    702  N   ILE    87      40.077  21.290  63.854  1.00 63.43           N  
ATOM    703  CA  ILE    87      38.855  21.778  63.286  1.00 64.20           C  
ATOM    704  C   ILE    87      39.097  23.083  62.491  1.00 65.71           C  
ATOM    705  O   ILE    87      38.612  23.241  61.347  1.00 66.80           O  
ATOM    706  CB  ILE    87      37.839  22.037  64.409  1.00 64.04           C  
ATOM    707  CG1 ILE    87      37.428  20.720  65.060  1.00 64.25           C  
ATOM    708  CG2 ILE    87      36.622  22.825  63.896  1.00 61.32           C  
ATOM    709  CD1 ILE    87      36.579  20.902  66.315  1.00 64.40           C  
ATOM    710  N   THR    88      39.830  24.013  63.109  1.00 65.78           N  
ATOM    711  CA  THR    88      40.080  25.292  62.519  1.00 65.90           C  
ATOM    712  C   THR    88      41.104  25.172  61.410  1.00 67.94           C  
ATOM    713  O   THR    88      41.161  26.035  60.520  1.00 68.74           O  
ATOM    714  CB  THR    88      40.510  26.352  63.552  1.00 65.51           C  
ATOM    715  OG1 THR    88      41.762  26.000  64.153  1.00 62.03           O  
ATOM    716  CG2 THR    88      39.449  26.507  64.601  1.00 62.86           C  
ATOM    717  N   GLN    89      41.891  24.109  61.435  1.00 69.42           N  
ATOM    718  CA  GLN    89      42.896  23.928  60.401  1.00 72.17           C  
ATOM    719  C   GLN    89      42.322  23.397  59.095  1.00 73.16           C  
ATOM    720  O   GLN    89      43.009  23.403  58.065  1.00 73.16           O  
ATOM    721  CB  GLN    89      44.039  23.048  60.878  1.00 72.31           C  
ATOM    722  CG  GLN    89      43.839  21.604  60.590  1.00 74.64           C  
ATOM    723  CD  GLN    89      45.043  20.815  61.004  1.00 79.85           C  
ATOM    724  OE1 GLN    89      46.007  21.388  61.534  1.00 82.02           O  
ATOM    725  NE2 GLN    89      45.011  19.489  60.776  1.00 79.99           N  
ATOM    726  N   LYS    90      41.071  22.948  59.138  1.00 75.07           N  
ATOM    727  CA  LYS    90      40.334  22.613  57.916  1.00 76.91           C  
ATOM    728  C   LYS    90      40.078  23.899  57.120  1.00 77.20           C  
ATOM    729  O   LYS    90      39.646  23.844  55.972  1.00 77.61           O  
ATOM    730  CB  LYS    90      39.009  21.910  58.248  1.00 76.83           C  
ATOM    731  CG  LYS    90      39.163  20.447  58.696  1.00 78.58           C  
ATOM    732  CD  LYS    90      37.796  19.756  58.977  1.00 78.62           C  
ATOM    733  CE  LYS    90      37.079  20.337  60.220  1.00 80.18           C  
ATOM    734  NZ  LYS    90      36.280  19.307  60.970  1.00 78.76           N  
ATOM    735  N   ASP    91      40.348  25.045  57.747  1.00 77.44           N  
ATOM    736  CA  ASP    91      40.246  26.365  57.120  1.00 77.76           C  
ATOM    737  C   ASP    91      41.585  27.103  57.126  1.00 77.52           C  
ATOM    738  O   ASP    91      41.632  28.325  56.987  1.00 77.39           O  
ATOM    739  CB  ASP    91      39.208  27.222  57.867  1.00 78.38           C  
ATOM    740  CG  ASP    91      37.829  26.569  57.912  1.00 80.49           C  
ATOM    741  OD1 ASP    91      37.535  25.680  57.065  1.00 82.90           O  
ATOM    742  OD2 ASP    91      37.031  26.950  58.792  1.00 82.18           O  
ATOM    743  N   GLY    92      42.672  26.362  57.299  1.00 77.83           N  
ATOM    744  CA  GLY    92      44.023  26.940  57.329  1.00 78.14           C  
ATOM    745  C   GLY    92      44.409  27.771  58.555  1.00 78.53           C  
ATOM    746  O   GLY    92      45.425  28.465  58.523  1.00 79.06           O  
ATOM    747  N   ILE    93      43.619  27.708  59.627  1.00 78.12           N  
ATOM    748  CA  ILE    93      43.927  28.425  60.856  1.00 78.01           C  
ATOM    749  C   ILE    93      44.383  27.445  61.948  1.00 78.31           C  
ATOM    750  O   ILE    93      43.752  26.410  62.152  1.00 78.15           O  
ATOM    751  CB  ILE    93      42.682  29.204  61.341  1.00 78.66           C  
ATOM    752  CG1 ILE    93      42.101  30.093  60.211  1.00 78.35           C  
ATOM    753  CG2 ILE    93      42.945  29.921  62.713  1.00 76.93           C  
ATOM    754  CD1 ILE    93      43.079  31.140  59.608  1.00 81.98           C  
ATOM    755  N   ARG    94      45.467  27.756  62.653  1.00 78.39           N  
ATOM    756  CA  ARG    94      45.864  26.906  63.778  1.00 79.60           C  
ATOM    757  C   ARG    94      46.863  27.551  64.739  1.00 79.87           C  
ATOM    758  O   ARG    94      47.994  27.826  64.356  1.00 80.34           O  
ATOM    759  CB  ARG    94      46.404  25.546  63.289  1.00 79.45           C  
ATOM    760  CG  ARG    94      47.917  25.471  63.148  1.00 80.34           C  
ATOM    761  CD  ARG    94      48.417  24.130  62.626  1.00 80.98           C  
ATOM    762  NE  ARG    94      48.116  23.009  63.522  1.00 83.82           N  
ATOM    763  CZ  ARG    94      48.738  22.766  64.678  1.00 84.40           C  
ATOM    764  NH1 ARG    94      49.699  23.581  65.130  1.00 83.20           N  
ATOM    765  NH2 ARG    94      48.384  21.703  65.397  1.00 83.66           N  
ATOM    766  N   PHE    95      46.456  27.734  65.994  1.00 80.07           N  
ATOM    767  CA  PHE    95      47.285  28.366  67.031  1.00 80.20           C  
ATOM    768  C   PHE    95      48.290  27.422  67.702  1.00 80.50           C  
ATOM    769  O   PHE    95      47.963  26.281  68.021  1.00 80.42           O  
ATOM    770  CB  PHE    95      46.379  29.004  68.083  1.00 80.47           C  
ATOM    771  CG  PHE    95      45.260  29.821  67.488  1.00 80.99           C  
ATOM    772  CD1 PHE    95      45.473  31.141  67.111  1.00 81.79           C  
ATOM    773  CD2 PHE    95      44.012  29.254  67.261  1.00 80.65           C  
ATOM    774  CE1 PHE    95      44.448  31.894  66.533  1.00 83.00           C  
ATOM    775  CE2 PHE    95      42.980  29.995  66.685  1.00 82.25           C  
ATOM    776  CZ  PHE    95      43.192  31.318  66.327  1.00 82.26           C  
ATOM    777  N   GLU    96      49.522  27.882  67.905  1.00 80.58           N  
ATOM    778  CA  GLU    96      50.494  27.020  68.550  1.00 81.30           C  
ATOM    779  C   GLU    96      50.231  26.970  70.046  1.00 80.62           C  
ATOM    780  O   GLU    96      50.088  28.001  70.710  1.00 80.58           O  
ATOM    781  CB  GLU    96      51.942  27.422  68.240  1.00 82.00           C  
ATOM    782  CG  GLU    96      52.438  27.100  66.785  1.00 85.70           C  
ATOM    783  CD  GLU    96      52.380  25.603  66.391  1.00 88.37           C  
ATOM    784  OE1 GLU    96      53.160  24.794  66.957  1.00 87.64           O  
ATOM    785  OE2 GLU    96      51.555  25.257  65.500  1.00 89.69           O  
ATOM    786  N   VAL    97      50.152  25.751  70.559  1.00 80.00           N  
ATOM    787  CA  VAL    97      49.779  25.512  71.943  1.00 79.52           C  
ATOM    788  C   VAL    97      50.508  26.506  72.853  1.00 79.00           C  
ATOM    789  O   VAL    97      49.884  27.239  73.624  1.00 79.10           O  
ATOM    790  CB  VAL    97      50.003  24.009  72.319  1.00 79.44           C  
ATOM    791  CG1 VAL    97      51.460  23.558  72.020  1.00 81.14           C  
ATOM    792  CG2 VAL    97      49.593  23.714  73.766  1.00 78.94           C  
ATOM    793  N   ASP    98      51.826  26.549  72.704  1.00 78.35           N  
ATOM    794  CA  ASP    98      52.696  27.550  73.308  1.00 77.56           C  
ATOM    795  C   ASP    98      52.109  28.969  73.485  1.00 76.70           C  
ATOM    796  O   ASP    98      51.942  29.435  74.613  1.00 76.47           O  
ATOM    797  CB  ASP    98      53.966  27.631  72.460  0.60 77.75           C  
ATOM    798  CG  ASP    98      55.156  28.053  73.258  0.60 78.16           C  
ATOM    799  OD1 ASP    98      55.026  28.992  74.072  0.60 78.47           O  
ATOM    800  OD2 ASP    98      56.226  27.440  73.072  0.60 79.39           O  
ATOM    801  N   ASP    99      51.786  29.611  72.368  0.60 76.19           N  
ATOM    803  CA  ASP    99      51.334  30.997  72.340  0.60 75.94           C  
ATOM    805  C   ASP    99      49.880  31.178  72.794  0.60 75.52           C  
ATOM    807  O   ASP    99      49.511  32.196  73.385  0.60 75.43           O  
ATOM    809  CB  ASP    99      51.500  31.548  70.923  0.60 76.07           C  
ATOM    811  CG  ASP    99      52.906  31.364  70.386  0.60 76.52           C  
ATOM    813  OD1 ASP    99      53.090  31.409  69.148  0.60 77.25           O  
ATOM    815  OD2 ASP    99      53.830  31.168  71.201  0.60 77.63           O  
ATOM    817  N   MET   100      49.047  30.200  72.489  1.00 75.00           N  
ATOM    818  CA  MET   100      47.674  30.236  72.938  1.00 74.50           C  
ATOM    819  C   MET   100      47.674  30.109  74.478  1.00 73.72           C  
ATOM    820  O   MET   100      47.061  30.907  75.168  1.00 73.25           O  
ATOM    821  CB  MET   100      46.866  29.138  72.262  1.00 74.34           C  
ATOM    822  CG  MET   100      45.425  29.075  72.717  1.00 75.88           C  
ATOM    823  SD  MET   100      44.372  30.641  72.207  0.85 76.98          SE  
ATOM    824  CE  MET   100      44.151  31.437  73.926  1.00 75.18           C  
ATOM    825  N   MET   101      48.427  29.135  74.992  1.00 72.91           N  
ATOM    826  CA  MET   101      48.593  28.908  76.424  1.00 72.12           C  
ATOM    827  C   MET   101      49.163  30.128  77.135  1.00 71.11           C  
ATOM    828  O   MET   101      48.882  30.349  78.288  1.00 70.87           O  
ATOM    829  CB  MET   101      49.515  27.710  76.631  1.00 72.60           C  
ATOM    830  CG  MET   101      49.809  27.395  78.061  1.00 73.93           C  
ATOM    831  SD  MET   101      48.149  26.866  78.967  0.60 77.64          SE  
ATOM    832  CE  MET   101      48.324  24.912  78.642  1.00 75.16           C  
ATOM    833  N   ALA   102      49.978  30.897  76.422  1.00 70.44           N  
ATOM    834  CA  ALA   102      50.494  32.171  76.882  1.00 69.35           C  
ATOM    835  C   ALA   102      49.409  33.231  76.908  1.00 68.45           C  
ATOM    836  O   ALA   102      49.242  33.887  77.920  1.00 68.65           O  
ATOM    837  CB  ALA   102      51.652  32.613  76.008  1.00 69.18           C  
ATOM    838  N   ARG   103      48.670  33.396  75.810  1.00 68.30           N  
ATOM    839  CA  ARG   103      47.555  34.377  75.743  1.00 67.14           C  
ATOM    840  C   ARG   103      46.513  34.122  76.825  1.00 65.74           C  
ATOM    841  O   ARG   103      46.047  35.029  77.483  1.00 65.11           O  
ATOM    842  CB  ARG   103      46.894  34.389  74.352  1.00 67.51           C  
ATOM    843  CG  ARG   103      45.843  35.526  74.092  1.00 69.99           C  
ATOM    844  CD  ARG   103      46.368  36.997  74.358  1.00 77.43           C  
ATOM    845  NE  ARG   103      46.236  37.886  73.177  1.00 81.71           N  
ATOM    846  CZ  ARG   103      45.219  38.730  72.955  1.00 85.14           C  
ATOM    847  NH1 ARG   103      44.228  38.831  73.838  1.00 87.71           N  
ATOM    848  NH2 ARG   103      45.170  39.478  71.844  1.00 85.06           N  
ATOM    849  N   ILE   104      46.155  32.866  77.003  1.00 65.17           N  
ATOM    850  CA  ILE   104      45.250  32.469  78.072  1.00 64.96           C  
ATOM    851  C   ILE   104      45.767  32.813  79.462  1.00 64.64           C  
ATOM    852  O   ILE   104      45.010  33.294  80.291  1.00 64.83           O  
ATOM    853  CB  ILE   104      44.872  30.974  77.981  1.00 64.89           C  
ATOM    854  CG1 ILE   104      43.935  30.769  76.796  1.00 66.45           C  
ATOM    855  CG2 ILE   104      44.174  30.506  79.264  1.00 64.73           C  
ATOM    856  CD1 ILE   104      43.932  29.348  76.238  1.00 70.32           C  
ATOM    857  N   ARG   105      47.046  32.581  79.719  0.60 64.58           N  
ATOM    859  CA  ARG   105      47.571  32.898  81.044  0.60 64.64           C  
ATOM    861  C   ARG   105      47.507  34.418  81.296  0.60 65.04           C  
ATOM    863  O   ARG   105      47.146  34.856  82.401  0.60 65.11           O  
ATOM    865  CB  ARG   105      48.959  32.268  81.268  0.60 64.15           C  
ATOM    867  CG  ARG   105      49.019  30.745  80.916  0.60 62.26           C  
ATOM    869  CD  ARG   105      49.908  29.930  81.861  0.60 59.20           C  
ATOM    871  NE  ARG   105      50.733  28.913  81.192  0.60 56.19           N  
ATOM    873  CZ  ARG   105      50.648  27.599  81.405  0.60 53.93           C  
ATOM    875  NH1 ARG   105      51.453  26.771  80.766  0.60 52.55           N  
ATOM    877  NH2 ARG   105      49.757  27.107  82.249  0.60 52.59           N  
ATOM    879  N   GLN   106      47.782  35.202  80.250  1.00 65.19           N  
ATOM    880  CA  GLN   106      47.661  36.674  80.283  1.00 66.44           C  
ATOM    881  C   GLN   106      46.219  37.148  80.563  1.00 66.11           C  
ATOM    882  O   GLN   106      45.987  38.039  81.370  1.00 65.91           O  
ATOM    883  CB  GLN   106      48.139  37.258  78.936  1.00 66.21           C  
ATOM    884  CG  GLN   106      48.160  38.781  78.873  1.00 68.89           C  
ATOM    885  CD  GLN   106      48.161  39.330  77.451  1.00 69.30           C  
ATOM    886  OE1 GLN   106      47.230  39.099  76.691  1.00 78.30           O  
ATOM    887  NE2 GLN   106      49.198  40.075  77.094  1.00 73.54           N  
ATOM    888  N   VAL   107      45.251  36.538  79.892  1.00 66.18           N  
ATOM    889  CA  VAL   107      43.862  36.931  80.045  1.00 66.70           C  
ATOM    890  C   VAL   107      43.368  36.703  81.494  1.00 67.44           C  
ATOM    891  O   VAL   107      42.708  37.561  82.099  1.00 66.39           O  
ATOM    892  CB  VAL   107      43.007  36.198  79.002  1.00 66.50           C  
ATOM    893  CG1 VAL   107      41.573  35.994  79.503  1.00 66.31           C  
ATOM    894  CG2 VAL   107      43.053  36.959  77.686  1.00 64.13           C  
ATOM    895  N   ARG   108      43.711  35.531  82.025  1.00 68.65           N  
ATOM    896  CA  ARG   108      43.437  35.162  83.410  1.00 69.82           C  
ATOM    897  C   ARG   108      44.035  36.222  84.356  1.00 71.05           C  
ATOM    898  O   ARG   108      43.384  36.638  85.340  1.00 70.77           O  
ATOM    899  CB  ARG   108      43.991  33.751  83.721  1.00 69.62           C  
ATOM    900  CG  ARG   108      43.597  33.210  85.119  1.00 69.62           C  
ATOM    901  CD  ARG   108      44.401  31.981  85.533  1.00 68.90           C  
ATOM    902  NE  ARG   108      44.109  30.834  84.678  1.00 67.11           N  
ATOM    903  CZ  ARG   108      45.010  29.969  84.222  1.00 65.78           C  
ATOM    904  NH1 ARG   108      44.619  28.965  83.441  1.00 62.37           N  
ATOM    905  NH2 ARG   108      46.297  30.107  84.545  1.00 67.13           N  
ATOM    906  N   GLU   109      45.259  36.661  84.034  1.00 72.13           N  
ATOM    907  CA  GLU   109      45.939  37.716  84.794  1.00 73.60           C  
ATOM    908  C   GLU   109      45.204  39.061  84.741  1.00 73.35           C  
ATOM    909  O   GLU   109      44.693  39.530  85.763  1.00 73.58           O  
ATOM    910  CB  GLU   109      47.385  37.880  84.320  1.00 73.60           C  
ATOM    911  CG  GLU   109      48.345  38.293  85.440  1.00 74.84           C  
ATOM    912  CD  GLU   109      49.683  38.819  84.920  1.00 75.40           C  
ATOM    913  OE1 GLU   109      49.694  39.511  83.867  1.00 78.84           O  
ATOM    914  OE2 GLU   109      50.721  38.555  85.572  1.00 75.88           O  
ATOM    915  N   GLN   110      45.117  39.652  83.547  1.00 73.36           N  
ATOM    916  CA  GLN   110      44.529  40.995  83.375  1.00 72.79           C  
ATOM    917  C   GLN   110      43.013  41.152  83.647  1.00 71.55           C  
ATOM    918  O   GLN   110      42.564  42.291  83.828  1.00 71.83           O  
ATOM    919  CB  GLN   110      44.899  41.578  82.006  1.00 72.97           C  
ATOM    920  CG  GLN   110      44.154  40.900  80.880  1.00 74.32           C  
ATOM    921  CD  GLN   110      44.831  41.080  79.538  1.00 75.81           C  
ATOM    922  OE1 GLN   110      46.072  41.145  79.455  1.00 74.48           O  
ATOM    923  NE2 GLN   110      44.016  41.145  78.467  1.00 73.00           N  
ATOM    924  N   GLY   111      42.251  40.048  83.693  1.00 70.23           N  
ATOM    925  CA  GLY   111      40.821  40.054  84.127  1.00 68.74           C  
ATOM    926  C   GLY   111      39.765  40.105  83.019  1.00 68.41           C  
ATOM    927  O   GLY   111      38.535  40.009  83.267  1.00 67.72           O  
ATOM    928  N   TYR   112      40.237  40.245  81.785  1.00 67.60           N  
ATOM    929  CA  TYR   112      39.367  40.447  80.621  1.00 67.38           C  
ATOM    930  C   TYR   112      40.115  40.034  79.362  1.00 66.21           C  
ATOM    931  O   TYR   112      41.348  39.829  79.414  1.00 66.31           O  
ATOM    932  CB  TYR   112      39.012  41.939  80.477  1.00 68.34           C  
ATOM    933  CG  TYR   112      40.254  42.789  80.427  1.00 70.12           C  
ATOM    934  CD1 TYR   112      40.904  43.058  79.212  1.00 72.48           C  
ATOM    935  CD2 TYR   112      40.811  43.296  81.603  1.00 70.44           C  
ATOM    936  CE1 TYR   112      42.092  43.844  79.176  1.00 72.21           C  
ATOM    937  CE2 TYR   112      41.962  44.071  81.575  1.00 72.48           C  
ATOM    938  CZ  TYR   112      42.597  44.334  80.362  1.00 72.07           C  
ATOM    939  OH  TYR   112      43.740  45.103  80.381  1.00 73.81           O  
ATOM    940  N   ALA   113      39.396  39.973  78.232  1.00 63.62           N  
ATOM    941  CA  ALA   113      40.045  39.704  76.957  1.00 62.19           C  
ATOM    942  C   ALA   113      39.529  40.638  75.861  1.00 61.50           C  
ATOM    943  O   ALA   113      38.406  41.113  75.914  1.00 62.63           O  
ATOM    944  CB  ALA   113      39.874  38.221  76.557  1.00 61.70           C  
ATOM    945  N   SER   114      40.363  40.940  74.895  1.00 59.84           N  
ATOM    946  CA  SER   114      39.903  41.583  73.708  1.00 59.77           C  
ATOM    947  C   SER   114      40.680  41.049  72.491  1.00 59.17           C  
ATOM    948  O   SER   114      41.711  40.411  72.631  1.00 58.24           O  
ATOM    949  CB  SER   114      40.004  43.083  73.840  1.00 59.57           C  
ATOM    950  OG  SER   114      41.356  43.445  74.060  1.00 62.96           O  
ATOM    951  N   ALA   115      40.152  41.309  71.306  1.00 59.12           N  
ATOM    952  CA  ALA   115      40.660  40.719  70.093  1.00 59.65           C  
ATOM    953  C   ALA   115      40.253  41.616  68.966  1.00 60.51           C  
ATOM    954  O   ALA   115      39.161  42.214  68.986  1.00 60.26           O  
ATOM    955  CB  ALA   115      40.033  39.339  69.879  1.00 59.03           C  
ATOM    956  N   GLU   116      41.131  41.683  67.979  1.00 61.40           N  
ATOM    957  CA  GLU   116      40.941  42.411  66.748  1.00 62.48           C  
ATOM    958  C   GLU   116      40.932  41.386  65.627  1.00 61.94           C  
ATOM    959  O   GLU   116      41.831  40.534  65.562  1.00 61.71           O  
ATOM    960  CB  GLU   116      42.178  43.242  66.470  1.00 62.91           C  
ATOM    961  CG  GLU   116      42.362  44.501  67.253  1.00 64.87           C  
ATOM    962  CD  GLU   116      43.608  45.273  66.759  1.00 66.94           C  
ATOM    963  OE1 GLU   116      44.407  44.722  65.917  1.00 68.23           O  
ATOM    964  OE2 GLU   116      43.771  46.437  67.224  1.00 72.76           O  
ATOM    965  N   HIS   117      39.970  41.495  64.716  1.00 60.74           N  
ATOM    966  CA  HIS   117      39.988  40.687  63.512  1.00 60.71           C  
ATOM    967  C   HIS   117      39.903  39.218  63.820  1.00 60.41           C  
ATOM    968  O   HIS   117      40.269  38.431  62.958  1.00 60.05           O  
ATOM    969  CB  HIS   117      41.242  40.943  62.639  1.00 60.33           C  
ATOM    970  CG  HIS   117      41.425  42.375  62.226  1.00 62.23           C  
ATOM    971  ND1 HIS   117      40.464  43.092  61.535  1.00 61.62           N  
ATOM    972  CD2 HIS   117      42.476  43.214  62.375  1.00 62.71           C  
ATOM    973  CE1 HIS   117      40.911  44.310  61.292  1.00 62.55           C  
ATOM    974  NE2 HIS   117      42.131  44.410  61.787  1.00 63.71           N  
ATOM    975  N   ILE   118      39.426  38.847  65.023  1.00 60.21           N  
ATOM    976  CA  ILE   118      39.269  37.410  65.396  1.00 59.96           C  
ATOM    977  C   ILE   118      37.957  37.150  66.138  1.00 59.73           C  
ATOM    978  O   ILE   118      37.735  37.670  67.213  1.00 59.45           O  
ATOM    979  CB  ILE   118      40.476  36.841  66.252  1.00 60.60           C  
ATOM    980  CG1 ILE   118      41.818  37.029  65.538  1.00 59.99           C  
ATOM    981  CG2 ILE   118      40.294  35.302  66.526  1.00 60.37           C  
ATOM    982  CD1 ILE   118      43.051  36.832  66.477  1.00 59.96           C  
ATOM    983  N   PRO   119      37.076  36.328  65.576  1.00 59.63           N  
ATOM    984  CA  PRO   119      37.199  35.472  64.393  1.00 60.42           C  
ATOM    985  C   PRO   119      37.065  36.229  63.055  1.00 61.73           C  
ATOM    986  O   PRO   119      37.340  35.635  62.013  1.00 62.71           O  
ATOM    987  CB  PRO   119      36.018  34.497  64.547  1.00 59.89           C  
ATOM    988  CG  PRO   119      34.937  35.379  65.254  1.00 58.78           C  
ATOM    989  CD  PRO   119      35.720  36.306  66.159  1.00 59.32           C  
ATOM    990  N   PHE   120      36.657  37.504  63.051  1.00 61.12           N  
ATOM    991  CA  PHE   120      36.338  38.119  61.762  1.00 61.12           C  
ATOM    992  C   PHE   120      37.054  39.400  61.460  1.00 59.48           C  
ATOM    993  O   PHE   120      37.082  40.301  62.261  1.00 58.42           O  
ATOM    994  CB  PHE   120      34.828  38.341  61.622  1.00 62.74           C  
ATOM    995  CG  PHE   120      34.035  37.086  61.735  1.00 64.36           C  
ATOM    996  CD1 PHE   120      34.295  36.006  60.866  1.00 70.01           C  
ATOM    997  CD2 PHE   120      33.064  36.952  62.726  1.00 65.69           C  
ATOM    998  CE1 PHE   120      33.561  34.780  60.953  1.00 69.09           C  
ATOM    999  CE2 PHE   120      32.304  35.779  62.819  1.00 66.11           C  
ATOM   1000  CZ  PHE   120      32.553  34.681  61.937  1.00 66.98           C  
ATOM   1001  N   VAL   121      37.599  39.469  60.256  1.00 58.64           N  
ATOM   1002  CA  VAL   121      38.232  40.683  59.767  1.00 58.37           C  
ATOM   1003  C   VAL   121      37.274  41.873  59.847  1.00 56.99           C  
ATOM   1004  O   VAL   121      36.136  41.809  59.367  1.00 55.51           O  
ATOM   1005  CB  VAL   121      38.725  40.438  58.336  1.00 59.00           C  
ATOM   1006  CG1 VAL   121      39.244  41.673  57.723  1.00 59.59           C  
ATOM   1007  CG2 VAL   121      39.812  39.386  58.387  1.00 60.30           C  
ATOM   1008  N   GLY   122      37.746  42.924  60.514  1.00 56.40           N  
ATOM   1009  CA  GLY   122      37.050  44.197  60.644  1.00 55.08           C  
ATOM   1010  C   GLY   122      36.289  44.261  61.944  1.00 55.39           C  
ATOM   1011  O   GLY   122      35.644  45.275  62.246  1.00 54.99           O  
ATOM   1012  N   GLY   123      36.351  43.178  62.720  1.00 55.30           N  
ATOM   1013  CA  GLY   123      35.632  43.117  63.990  1.00 56.21           C  
ATOM   1014  C   GLY   123      36.539  43.368  65.186  1.00 57.60           C  
ATOM   1015  O   GLY   123      37.764  43.195  65.105  1.00 58.87           O  
ATOM   1016  N   GLY   124      35.937  43.769  66.299  1.00 57.60           N  
ATOM   1017  CA  GLY   124      36.615  43.964  67.568  1.00 56.76           C  
ATOM   1018  C   GLY   124      35.654  43.511  68.645  1.00 57.59           C  
ATOM   1019  O   GLY   124      34.438  43.674  68.502  1.00 58.68           O  
ATOM   1020  N   THR   125      36.195  42.917  69.702  1.00 57.57           N  
ATOM   1021  CA  THR   125      35.421  42.333  70.759  1.00 58.77           C  
ATOM   1022  C   THR   125      36.159  42.557  72.087  1.00 59.95           C  
ATOM   1023  O   THR   125      37.404  42.665  72.108  1.00 61.11           O  
ATOM   1024  CB  THR   125      35.226  40.815  70.555  1.00 58.50           C  
ATOM   1025  OG1 THR   125      36.504  40.198  70.631  1.00 60.10           O  
ATOM   1026  CG2 THR   125      34.581  40.477  69.179  1.00 57.20           C  
ATOM   1027  N   ILE   126      35.392  42.648  73.174  1.00 59.74           N  
ATOM   1028  CA  ILE   126      35.925  42.817  74.500  1.00 60.47           C  
ATOM   1029  C   ILE   126      35.014  42.026  75.389  1.00 60.96           C  
ATOM   1030  O   ILE   126      33.801  42.116  75.250  1.00 60.86           O  
ATOM   1031  CB  ILE   126      35.861  44.292  74.994  1.00 60.70           C  
ATOM   1032  CG1 ILE   126      36.457  45.265  73.965  1.00 60.18           C  
ATOM   1033  CG2 ILE   126      36.660  44.428  76.323  1.00 61.21           C  
ATOM   1034  CD1 ILE   126      36.173  46.739  74.252  1.00 60.30           C  
ATOM   1035  N   CYS   127      35.571  41.266  76.320  1.00 61.17           N  
ATOM   1036  CA  CYS   127      34.720  40.550  77.246  1.00 61.73           C  
ATOM   1037  C   CYS   127      35.336  40.353  78.631  1.00 60.76           C  
ATOM   1038  O   CYS   127      36.552  40.554  78.825  1.00 61.34           O  
ATOM   1039  CB  CYS   127      34.283  39.220  76.645  1.00 62.64           C  
ATOM   1040  SG  CYS   127      35.571  38.057  76.611  1.00 69.38           S  
ATOM   1041  N   VAL   128      34.479  39.997  79.585  1.00 58.72           N  
ATOM   1042  CA  VAL   128      34.880  39.777  80.954  1.00 57.06           C  
ATOM   1043  C   VAL   128      34.217  38.503  81.459  1.00 57.11           C  
ATOM   1044  O   VAL   128      33.236  38.000  80.900  1.00 56.65           O  
ATOM   1045  CB  VAL   128      34.464  40.968  81.850  1.00 57.55           C  
ATOM   1046  CG1 VAL   128      35.306  42.205  81.547  1.00 55.59           C  
ATOM   1047  CG2 VAL   128      32.963  41.291  81.663  1.00 56.91           C  
ATOM   1048  N   LEU   129      34.762  37.965  82.520  1.00 57.32           N  
ATOM   1049  CA  LEU   129      34.166  36.828  83.172  1.00 58.26           C  
ATOM   1050  C   LEU   129      33.140  37.298  84.224  1.00 58.72           C  
ATOM   1051  O   LEU   129      33.452  38.103  85.104  1.00 58.69           O  
ATOM   1052  CB  LEU   129      35.297  36.031  83.830  1.00 58.55           C  
ATOM   1053  CG  LEU   129      35.015  34.628  84.359  1.00 60.42           C  
ATOM   1054  CD1 LEU   129      34.662  33.655  83.226  1.00 57.69           C  
ATOM   1055  CD2 LEU   129      36.257  34.149  85.121  1.00 58.78           C  
ATOM   1056  N   LEU   130      31.924  36.779  84.156  1.00 59.63           N  
ATOM   1057  CA  LEU   130      30.970  37.026  85.231  1.00 61.00           C  
ATOM   1058  C   LEU   130      31.373  36.302  86.514  1.00 62.52           C  
ATOM   1059  O   LEU   130      32.068  35.286  86.451  1.00 63.24           O  
ATOM   1060  CB  LEU   130      29.555  36.661  84.806  1.00 60.61           C  
ATOM   1061  CG  LEU   130      29.064  37.484  83.618  1.00 58.70           C  
ATOM   1062  CD1 LEU   130      27.610  37.233  83.478  1.00 57.62           C  
ATOM   1063  CD2 LEU   130      29.312  38.951  83.901  1.00 58.50           C  
ATOM   1064  N   PRO   131      30.957  36.833  87.684  1.00 63.60           N  
ATOM   1065  CA  PRO   131      31.330  36.289  88.998  1.00 64.67           C  
ATOM   1066  C   PRO   131      30.677  34.948  89.331  1.00 65.20           C  
ATOM   1067  O   PRO   131      31.135  34.235  90.229  1.00 65.42           O  
ATOM   1068  CB  PRO   131      30.763  37.326  89.982  1.00 64.22           C  
ATOM   1069  CG  PRO   131      30.370  38.477  89.184  1.00 63.35           C  
ATOM   1070  CD  PRO   131      30.083  38.008  87.828  1.00 63.62           C  
ATOM   1071  N   MET   132      29.571  34.647  88.672  1.00 64.99           N  
ATOM   1072  CA  MET   132      28.877  33.427  88.993  1.00 65.15           C  
ATOM   1073  C   MET   132      28.979  32.403  87.850  1.00 64.14           C  
ATOM   1074  O   MET   132      29.414  32.717  86.758  1.00 64.03           O  
ATOM   1075  CB  MET   132      27.415  33.726  89.407  1.00 65.70           C  
ATOM   1076  CG  MET   132      26.390  33.794  88.263  1.00 67.04           C  
ATOM   1077  SD  MET   132      26.750  35.218  87.004  0.45 71.81          SE  
ATOM   1078  CE  MET   132      26.107  36.639  88.129  1.00 67.04           C  
ATOM   1079  N   THR   133      28.592  31.168  88.142  1.00 63.08           N  
ATOM   1080  CA  THR   133      28.539  30.109  87.173  1.00 61.87           C  
ATOM   1081  C   THR   133      27.079  29.821  86.836  1.00 62.29           C  
ATOM   1082  O   THR   133      26.172  30.146  87.590  1.00 62.69           O  
ATOM   1083  CB  THR   133      29.236  28.832  87.733  1.00 62.07           C  
ATOM   1084  OG1 THR   133      28.599  28.425  88.955  1.00 59.30           O  
ATOM   1085  CG2 THR   133      30.761  29.080  87.987  1.00 60.89           C  
ATOM   1086  N   ILE   134      26.850  29.216  85.690  1.00 63.11           N  
ATOM   1087  CA  ILE   134      25.523  28.799  85.289  1.00 64.44           C  
ATOM   1088  C   ILE   134      25.672  27.330  84.911  1.00 65.69           C  
ATOM   1089  O   ILE   134      26.460  26.969  84.044  1.00 66.09           O  
ATOM   1090  CB  ILE   134      24.963  29.704  84.146  1.00 64.14           C  
ATOM   1091  CG1 ILE   134      24.566  31.066  84.723  1.00 63.96           C  
ATOM   1092  CG2 ILE   134      23.773  29.071  83.433  1.00 64.15           C  
ATOM   1093  CD1 ILE   134      24.175  32.136  83.679  1.00 64.32           C  
ATOM   1094  N   GLN   135      24.961  26.482  85.641  1.00 67.44           N  
ATOM   1095  CA  GLN   135      25.018  25.030  85.464  1.00 68.27           C  
ATOM   1096  C   GLN   135      26.423  24.443  85.593  1.00 67.51           C  
ATOM   1097  O   GLN   135      26.840  23.603  84.787  1.00 67.63           O  
ATOM   1098  CB  GLN   135      24.338  24.630  84.142  1.00 69.11           C  
ATOM   1099  CG  GLN   135      22.813  24.426  84.322  1.00 72.21           C  
ATOM   1100  CD  GLN   135      22.075  24.392  83.000  1.00 75.06           C  
ATOM   1101  OE1 GLN   135      22.529  24.981  82.028  1.00 73.98           O  
ATOM   1102  NE2 GLN   135      20.923  23.708  82.961  1.00 76.23           N  
ATOM   1103  N   GLY   136      27.140  24.878  86.627  1.00 66.64           N  
ATOM   1104  CA  GLY   136      28.537  24.478  86.814  1.00 65.45           C  
ATOM   1105  C   GLY   136      29.529  25.084  85.834  1.00 64.78           C  
ATOM   1106  O   GLY   136      30.703  25.058  86.102  1.00 63.55           O  
ATOM   1107  N   GLN   137      29.053  25.633  84.708  1.00 65.31           N  
ATOM   1108  CA  GLN   137      29.912  26.263  83.691  1.00 65.72           C  
ATOM   1109  C   GLN   137      30.233  27.713  84.016  1.00 65.55           C  
ATOM   1110  O   GLN   137      29.358  28.463  84.439  1.00 65.69           O  
ATOM   1111  CB  GLN   137      29.245  26.244  82.302  1.00 66.04           C  
ATOM   1112  CG  GLN   137      29.320  24.909  81.507  1.00 68.78           C  
ATOM   1113  CD  GLN   137      30.440  23.996  82.042  1.00 73.24           C  
ATOM   1114  OE1 GLN   137      31.649  24.242  81.825  1.00 72.76           O  
ATOM   1115  NE2 GLN   137      30.031  22.931  82.759  1.00 73.95           N  
ATOM   1116  N   PRO   138      31.472  28.144  83.744  1.00 65.44           N  
ATOM   1117  CA  PRO   138      31.749  29.578  83.801  1.00 64.98           C  
ATOM   1118  C   PRO   138      31.014  30.351  82.669  1.00 64.36           C  
ATOM   1119  O   PRO   138      30.615  29.763  81.628  1.00 63.62           O  
ATOM   1120  CB  PRO   138      33.259  29.641  83.600  1.00 64.70           C  
ATOM   1121  CG  PRO   138      33.523  28.488  82.688  1.00 65.49           C  
ATOM   1122  CD  PRO   138      32.663  27.395  83.312  1.00 65.94           C  
ATOM   1123  N   VAL   139      30.836  31.652  82.906  1.00 63.46           N  
ATOM   1124  CA  VAL   139      30.024  32.527  82.076  1.00 63.27           C  
ATOM   1125  C   VAL   139      30.742  33.834  81.764  1.00 63.64           C  
ATOM   1126  O   VAL   139      31.472  34.407  82.580  1.00 63.82           O  
ATOM   1127  CB  VAL   139      28.685  32.877  82.751  1.00 63.26           C  
ATOM   1128  CG1 VAL   139      27.728  33.535  81.751  1.00 63.44           C  
ATOM   1129  CG2 VAL   139      28.037  31.626  83.319  1.00 63.48           C  
ATOM   1130  N   THR   140      30.473  34.346  80.581  1.00 63.49           N  
ATOM   1131  CA  THR   140      31.209  35.477  80.094  1.00 62.95           C  
ATOM   1132  C   THR   140      30.239  36.548  79.635  1.00 61.34           C  
ATOM   1133  O   THR   140      29.112  36.253  79.198  1.00 61.41           O  
ATOM   1134  CB  THR   140      32.197  34.962  78.979  1.00 64.09           C  
ATOM   1135  OG1 THR   140      33.315  35.835  78.864  1.00 68.35           O  
ATOM   1136  CG2 THR   140      31.527  34.750  77.625  1.00 61.92           C  
ATOM   1137  N   MET   141      30.651  37.795  79.749  1.00 59.52           N  
ATOM   1138  CA  MET   141      29.865  38.896  79.191  1.00 58.85           C  
ATOM   1139  C   MET   141      30.732  39.738  78.273  1.00 57.63           C  
ATOM   1140  O   MET   141      31.805  40.197  78.662  1.00 56.38           O  
ATOM   1141  CB  MET   141      29.254  39.781  80.295  1.00 58.22           C  
ATOM   1142  CG  MET   141      28.359  40.907  79.768  1.00 57.91           C  
ATOM   1143  SD  MET   141      27.439  41.893  81.189  0.70 63.01          SE  
ATOM   1144  CE  MET   141      29.033  42.290  82.338  1.00 57.79           C  
ATOM   1145  N   GLY   142      30.275  39.939  77.045  1.00 57.51           N  
ATOM   1146  CA  GLY   142      31.113  40.646  76.106  1.00 57.02           C  
ATOM   1147  C   GLY   142      30.376  41.500  75.131  1.00 57.66           C  
ATOM   1148  O   GLY   142      29.155  41.396  75.004  1.00 56.64           O  
ATOM   1149  N   LEU   143      31.124  42.363  74.442  1.00 58.30           N  
ATOM   1150  CA  LEU   143      30.546  43.151  73.380  1.00 58.79           C  
ATOM   1151  C   LEU   143      31.353  43.070  72.088  1.00 58.83           C  
ATOM   1152  O   LEU   143      32.559  42.905  72.119  1.00 58.80           O  
ATOM   1153  CB  LEU   143      30.325  44.594  73.858  1.00 58.35           C  
ATOM   1154  CG  LEU   143      31.521  45.419  74.287  1.00 60.18           C  
ATOM   1155  CD1 LEU   143      32.247  46.006  73.071  1.00 60.49           C  
ATOM   1156  CD2 LEU   143      31.061  46.519  75.206  1.00 59.31           C  
ATOM   1157  N   GLY   144      30.678  43.246  70.953  1.00 58.47           N  
ATOM   1158  CA  GLY   144      31.316  43.101  69.659  1.00 58.24           C  
ATOM   1159  C   GLY   144      30.811  44.138  68.683  1.00 57.94           C  
ATOM   1160  O   GLY   144      29.643  44.516  68.749  1.00 59.01           O  
ATOM   1161  N   GLY   145      31.667  44.613  67.784  1.00 56.39           N  
ATOM   1162  CA  GLY   145      31.205  45.540  66.745  1.00 55.65           C  
ATOM   1163  C   GLY   145      32.309  45.840  65.731  1.00 56.12           C  
ATOM   1164  O   GLY   145      33.329  45.104  65.659  1.00 56.23           O  
ATOM   1165  N   ALA   146      32.124  46.900  64.951  1.00 55.07           N  
ATOM   1166  CA  ALA   146      33.100  47.244  63.899  1.00 55.82           C  
ATOM   1167  C   ALA   146      34.349  47.728  64.624  1.00 56.96           C  
ATOM   1168  O   ALA   146      34.230  48.504  65.612  1.00 57.85           O  
ATOM   1169  CB  ALA   146      32.536  48.330  62.929  1.00 52.69           C  
ATOM   1170  N   LEU   147      35.522  47.281  64.155  1.00 57.64           N  
ATOM   1171  CA  LEU   147      36.793  47.504  64.859  1.00 58.41           C  
ATOM   1172  C   LEU   147      37.061  48.955  65.249  1.00 60.34           C  
ATOM   1173  O   LEU   147      37.500  49.227  66.372  1.00 61.03           O  
ATOM   1174  CB  LEU   147      37.975  46.973  64.060  1.00 58.18           C  
ATOM   1175  CG  LEU   147      39.327  46.949  64.806  1.00 58.18           C  
ATOM   1176  CD1 LEU   147      39.244  46.312  66.199  1.00 57.00           C  
ATOM   1177  CD2 LEU   147      40.342  46.197  64.003  1.00 56.44           C  
ATOM   1178  N   ASP   148      36.797  49.886  64.340  1.00 60.98           N  
ATOM   1179  CA  ASP   148      37.114  51.252  64.594  1.00 62.40           C  
ATOM   1180  C   ASP   148      36.348  51.837  65.779  1.00 62.77           C  
ATOM   1181  O   ASP   148      36.896  52.619  66.589  1.00 62.98           O  
ATOM   1182  CB  ASP   148      36.866  52.052  63.329  1.00 63.29           C  
ATOM   1183  CG  ASP   148      37.999  51.865  62.274  1.00 68.49           C  
ATOM   1184  OD1 ASP   148      39.067  51.262  62.588  1.00 73.90           O  
ATOM   1185  OD2 ASP   148      37.832  52.324  61.114  1.00 73.21           O  
ATOM   1186  N   ARG   149      35.081  51.456  65.871  1.00 62.83           N  
ATOM   1187  CA  ARG   149      34.149  51.928  66.902  1.00 62.86           C  
ATOM   1188  C   ARG   149      34.607  51.373  68.242  1.00 62.96           C  
ATOM   1189  O   ARG   149      34.489  52.006  69.274  1.00 63.58           O  
ATOM   1190  CB  ARG   149      32.755  51.373  66.561  1.00 63.17           C  
ATOM   1191  CG  ARG   149      31.541  52.118  67.062  1.00 62.50           C  
ATOM   1192  CD  ARG   149      30.276  51.705  66.243  1.00 62.20           C  
ATOM   1193  NE  ARG   149      29.948  50.271  66.331  1.00 61.59           N  
ATOM   1194  CZ  ARG   149      29.562  49.509  65.295  1.00 61.95           C  
ATOM   1195  NH1 ARG   149      29.438  50.037  64.069  1.00 61.84           N  
ATOM   1196  NH2 ARG   149      29.264  48.218  65.478  1.00 58.63           N  
ATOM   1197  N   ILE   150      35.138  50.168  68.190  1.00 62.84           N  
ATOM   1198  CA  ILE   150      35.667  49.472  69.337  1.00 62.99           C  
ATOM   1199  C   ILE   150      36.976  50.090  69.814  1.00 63.06           C  
ATOM   1200  O   ILE   150      37.093  50.383  70.996  1.00 63.45           O  
ATOM   1201  CB  ILE   150      35.841  47.972  68.975  1.00 62.89           C  
ATOM   1202  CG1 ILE   150      34.475  47.346  68.679  1.00 61.48           C  
ATOM   1203  CG2 ILE   150      36.605  47.214  70.033  1.00 63.63           C  
ATOM   1204  CD1 ILE   150      33.474  47.515  69.720  1.00 59.06           C  
ATOM   1205  N   LYS   151      37.934  50.291  68.898  1.00 63.12           N  
ATOM   1206  CA  LYS   151      39.214  50.921  69.175  1.00 63.61           C  
ATOM   1207  C   LYS   151      39.027  52.307  69.740  1.00 63.88           C  
ATOM   1208  O   LYS   151      39.786  52.735  70.630  1.00 63.74           O  
ATOM   1209  CB  LYS   151      40.053  51.086  67.903  1.00 64.07           C  
ATOM   1210  CG  LYS   151      40.913  49.913  67.566  1.00 65.79           C  
ATOM   1211  CD  LYS   151      41.621  50.162  66.241  1.00 70.75           C  
ATOM   1212  CE  LYS   151      42.944  49.392  66.164  1.00 71.73           C  
ATOM   1213  NZ  LYS   151      43.159  48.731  64.846  1.00 72.52           N  
ATOM   1214  N   GLN   152      38.044  53.040  69.233  1.00 63.75           N  
ATOM   1215  CA  GLN   152      37.961  54.403  69.698  1.00 64.40           C  
ATOM   1216  C   GLN   152      37.173  54.524  71.007  1.00 64.24           C  
ATOM   1217  O   GLN   152      37.196  55.571  71.640  1.00 64.77           O  
ATOM   1218  CB  GLN   152      37.532  55.387  68.592  1.00 64.61           C  
ATOM   1219  CG  GLN   152      36.062  55.680  68.472  1.00 66.54           C  
ATOM   1220  CD  GLN   152      35.799  57.155  68.274  1.00 69.16           C  
ATOM   1221  OE1 GLN   152      34.813  57.540  67.658  1.00 72.32           O  
ATOM   1222  NE2 GLN   152      36.667  57.994  68.821  1.00 71.10           N  
ATOM   1223  N   ASN   153      36.519  53.453  71.429  1.00 63.29           N  
ATOM   1224  CA  ASN   153      35.780  53.492  72.678  1.00 63.53           C  
ATOM   1225  C   ASN   153      36.295  52.514  73.708  1.00 63.79           C  
ATOM   1226  O   ASN   153      35.654  52.292  74.736  1.00 63.26           O  
ATOM   1227  CB  ASN   153      34.302  53.230  72.425  1.00 63.39           C  
ATOM   1228  CG  ASN   153      33.615  54.397  71.765  1.00 62.56           C  
ATOM   1229  OD1 ASN   153      33.481  55.477  72.343  1.00 61.47           O  
ATOM   1230  ND2 ASN   153      33.163  54.181  70.555  1.00 62.37           N  
ATOM   1231  N   TYR   154      37.468  51.959  73.424  1.00 64.35           N  
ATOM   1232  CA  TYR   154      38.021  50.830  74.154  1.00 64.87           C  
ATOM   1233  C   TYR   154      37.977  51.032  75.673  1.00 64.22           C  
ATOM   1234  O   TYR   154      37.372  50.243  76.398  1.00 65.11           O  
ATOM   1235  CB  TYR   154      39.449  50.536  73.666  1.00 65.57           C  
ATOM   1236  CG  TYR   154      40.047  49.273  74.243  1.00 67.42           C  
ATOM   1237  CD1 TYR   154      39.799  48.022  73.644  1.00 69.26           C  
ATOM   1238  CD2 TYR   154      40.871  49.312  75.385  1.00 67.48           C  
ATOM   1239  CE1 TYR   154      40.352  46.840  74.157  1.00 68.18           C  
ATOM   1240  CE2 TYR   154      41.416  48.131  75.928  1.00 67.78           C  
ATOM   1241  CZ  TYR   154      41.145  46.898  75.308  1.00 69.01           C  
ATOM   1242  OH  TYR   154      41.682  45.711  75.808  1.00 70.29           O  
ATOM   1243  N   ASP   155      38.599  52.082  76.167  1.00 63.00           N  
ATOM   1244  CA  ASP   155      38.617  52.284  77.612  1.00 62.08           C  
ATOM   1245  C   ASP   155      37.215  52.364  78.228  1.00 60.93           C  
ATOM   1246  O   ASP   155      36.955  51.704  79.230  1.00 61.07           O  
ATOM   1247  CB  ASP   155      39.532  53.449  78.004  1.00 62.11           C  
ATOM   1248  CG  ASP   155      41.007  53.150  77.710  1.00 63.68           C  
ATOM   1249  OD1 ASP   155      41.404  51.968  77.752  1.00 63.75           O  
ATOM   1250  OD2 ASP   155      41.782  54.096  77.444  1.00 66.92           O  
ATOM   1251  N   ARG   156      36.325  53.142  77.616  0.50 60.35           N  
ATOM   1253  CA  ARG   156      34.951  53.271  78.098  0.50 59.56           C  
ATOM   1255  C   ARG   156      34.210  51.922  78.085  0.50 59.33           C  
ATOM   1257  O   ARG   156      33.566  51.552  79.074  0.50 59.30           O  
ATOM   1259  CB  ARG   156      34.190  54.348  77.303  0.50 59.35           C  
ATOM   1261  CG  ARG   156      32.709  54.514  77.647  0.50 58.27           C  
ATOM   1263  CD  ARG   156      32.496  54.857  79.123  0.50 58.16           C  
ATOM   1265  NE  ARG   156      31.118  55.273  79.401  0.50 57.16           N  
ATOM   1267  CZ  ARG   156      30.603  55.439  80.621  0.50 53.83           C  
ATOM   1269  NH1 ARG   156      31.333  55.214  81.705  0.50 50.49           N  
ATOM   1271  NH2 ARG   156      29.342  55.825  80.748  0.50 53.96           N  
ATOM   1273  N   TYR   157      34.314  51.183  76.983  1.00 59.03           N  
ATOM   1274  CA  TYR   157      33.636  49.896  76.875  1.00 58.63           C  
ATOM   1275  C   TYR   157      34.152  48.951  77.942  1.00 58.96           C  
ATOM   1276  O   TYR   157      33.389  48.380  78.700  1.00 59.40           O  
ATOM   1277  CB  TYR   157      33.846  49.301  75.510  1.00 59.28           C  
ATOM   1278  CG  TYR   157      33.035  49.900  74.385  1.00 59.29           C  
ATOM   1279  CD1 TYR   157      32.203  51.014  74.566  1.00 57.89           C  
ATOM   1280  CD2 TYR   157      33.158  49.380  73.112  1.00 58.11           C  
ATOM   1281  CE1 TYR   157      31.473  51.549  73.483  1.00 57.38           C  
ATOM   1282  CE2 TYR   157      32.439  49.890  72.052  1.00 58.83           C  
ATOM   1283  CZ  TYR   157      31.606  50.972  72.234  1.00 59.78           C  
ATOM   1284  OH  TYR   157      30.926  51.438  71.110  1.00 62.74           O  
ATOM   1285  N   LEU   158      35.464  48.824  78.045  1.00 59.50           N  
ATOM   1286  CA  LEU   158      36.044  47.981  79.075  1.00 59.86           C  
ATOM   1287  C   LEU   158      35.524  48.348  80.462  1.00 60.16           C  
ATOM   1288  O   LEU   158      35.113  47.467  81.220  1.00 60.78           O  
ATOM   1289  CB  LEU   158      37.562  48.099  79.054  1.00 59.80           C  
ATOM   1290  CG  LEU   158      38.262  47.129  80.008  1.00 60.44           C  
ATOM   1291  CD1 LEU   158      37.858  45.663  79.707  1.00 56.36           C  
ATOM   1292  CD2 LEU   158      39.766  47.334  79.948  1.00 59.85           C  
ATOM   1293  N   GLU   159      35.562  49.641  80.781  1.00 59.61           N  
ATOM   1294  CA  GLU   159      35.161  50.153  82.078  1.00 59.73           C  
ATOM   1295  C   GLU   159      33.742  49.670  82.381  1.00 59.78           C  
ATOM   1296  O   GLU   159      33.489  49.106  83.453  1.00 59.87           O  
ATOM   1297  CB  GLU   159      35.214  51.679  82.056  1.00 59.34           C  
ATOM   1298  CG  GLU   159      35.126  52.335  83.418  1.00 61.40           C  
ATOM   1299  CD  GLU   159      34.879  53.857  83.357  0.70 60.72           C  
ATOM   1300  OE1 GLU   159      34.127  54.327  82.466  0.70 63.42           O  
ATOM   1301  OE2 GLU   159      35.421  54.578  84.219  0.70 58.79           O  
ATOM   1302  N   LEU   160      32.818  49.861  81.427  1.00 59.37           N  
ATOM   1303  CA  LEU   160      31.439  49.367  81.576  1.00 58.56           C  
ATOM   1304  C   LEU   160      31.356  47.856  81.818  1.00 58.29           C  
ATOM   1305  O   LEU   160      30.541  47.413  82.616  1.00 59.51           O  
ATOM   1306  CB  LEU   160      30.567  49.737  80.369  1.00 57.95           C  
ATOM   1307  CG  LEU   160      30.347  51.218  80.103  1.00 58.23           C  
ATOM   1308  CD1 LEU   160      29.702  51.460  78.758  1.00 55.29           C  
ATOM   1309  CD2 LEU   160      29.536  51.881  81.245  1.00 56.98           C  
ATOM   1310  N   LEU   161      32.179  47.053  81.159  1.00 56.85           N  
ATOM   1311  CA  LEU   161      32.064  45.623  81.399  1.00 56.27           C  
ATOM   1312  C   LEU   161      32.491  45.340  82.827  1.00 56.63           C  
ATOM   1313  O   LEU   161      31.767  44.702  83.568  1.00 56.98           O  
ATOM   1314  CB  LEU   161      32.873  44.788  80.391  1.00 55.23           C  
ATOM   1315  CG  LEU   161      32.396  44.835  78.945  1.00 53.59           C  
ATOM   1316  CD1 LEU   161      33.466  44.302  77.999  1.00 52.49           C  
ATOM   1317  CD2 LEU   161      31.076  44.077  78.777  1.00 50.92           C  
ATOM   1318  N   LEU   162      33.655  45.845  83.211  1.00 57.06           N  
ATOM   1319  CA  LEU   162      34.197  45.628  84.544  1.00 58.48           C  
ATOM   1320  C   LEU   162      33.282  46.096  85.667  1.00 59.61           C  
ATOM   1321  O   LEU   162      33.264  45.501  86.759  1.00 60.23           O  
ATOM   1322  CB  LEU   162      35.574  46.304  84.700  1.00 58.31           C  
ATOM   1323  CG  LEU   162      36.705  45.644  83.895  1.00 57.84           C  
ATOM   1324  CD1 LEU   162      37.997  46.389  84.102  1.00 58.59           C  
ATOM   1325  CD2 LEU   162      36.901  44.204  84.266  1.00 56.12           C  
ATOM   1326  N   ASN   163      32.542  47.169  85.410  1.00 60.54           N  
ATOM   1327  CA  ASN   163      31.690  47.749  86.439  1.00 62.01           C  
ATOM   1328  C   ASN   163      30.436  46.879  86.527  1.00 62.08           C  
ATOM   1329  O   ASN   163      29.830  46.747  87.593  1.00 61.71           O  
ATOM   1330  CB  ASN   163      31.438  49.239  86.125  1.00 62.45           C  
ATOM   1331  CG  ASN   163      30.150  49.787  86.734  1.00 65.09           C  
ATOM   1332  OD1 ASN   163      30.050  50.022  87.957  1.00 67.46           O  
ATOM   1333  ND2 ASN   163      29.168  50.061  85.862  1.00 65.90           N  
ATOM   1334  N   GLY   164      30.102  46.245  85.397  1.00 62.36           N  
ATOM   1335  CA  GLY   164      28.971  45.325  85.296  1.00 62.20           C  
ATOM   1336  C   GLY   164      29.216  44.094  86.143  1.00 62.33           C  
ATOM   1337  O   GLY   164      28.300  43.587  86.792  1.00 62.50           O  
ATOM   1338  N   VAL   165      30.462  43.636  86.155  1.00 61.66           N  
ATOM   1339  CA  VAL   165      30.900  42.586  87.044  1.00 61.93           C  
ATOM   1340  C   VAL   165      30.706  42.951  88.532  1.00 62.82           C  
ATOM   1341  O   VAL   165      30.158  42.160  89.306  1.00 63.03           O  
ATOM   1342  CB  VAL   165      32.356  42.271  86.742  1.00 61.88           C  
ATOM   1343  CG1 VAL   165      33.024  41.473  87.860  1.00 60.99           C  
ATOM   1344  CG2 VAL   165      32.431  41.557  85.416  1.00 62.26           C  
ATOM   1345  N   GLN   166      31.142  44.149  88.935  1.00 63.51           N  
ATOM   1346  CA  GLN   166      30.938  44.637  90.305  1.00 63.09           C  
ATOM   1347  C   GLN   166      29.471  44.671  90.704  1.00 63.81           C  
ATOM   1348  O   GLN   166      29.126  44.278  91.796  1.00 63.65           O  
ATOM   1349  CB  GLN   166      31.571  46.010  90.467  1.00 62.92           C  
ATOM   1350  CG  GLN   166      33.101  45.969  90.431  1.00 62.83           C  
ATOM   1351  CD  GLN   166      33.682  44.920  91.377  1.00 62.74           C  
ATOM   1352  OE1 GLN   166      34.438  44.038  90.958  1.00 62.14           O  
ATOM   1353  NE2 GLN   166      33.307  44.994  92.653  1.00 62.51           N  
ATOM   1354  N   GLN   167      28.601  45.105  89.800  1.00 64.97           N  
ATOM   1355  CA  GLN   167      27.177  45.100  90.066  1.00 66.64           C  
ATOM   1356  C   GLN   167      26.588  43.715  90.317  1.00 67.34           C  
ATOM   1357  O   GLN   167      25.554  43.602  90.948  1.00 67.90           O  
ATOM   1358  CB  GLN   167      26.417  45.751  88.924  1.00 66.61           C  
ATOM   1359  CG  GLN   167      26.627  47.230  88.784  1.00 68.71           C  
ATOM   1360  CD  GLN   167      25.849  47.782  87.591  1.00 73.66           C  
ATOM   1361  OE1 GLN   167      24.753  48.315  87.760  1.00 78.39           O  
ATOM   1362  NE2 GLN   167      26.397  47.636  86.379  1.00 73.07           N  
ATOM   1363  N   LEU   168      27.233  42.661  89.833  1.00 68.72           N  
ATOM   1364  CA  LEU   168      26.708  41.304  90.031  1.00 69.87           C  
ATOM   1365  C   LEU   168      27.356  40.466  91.131  1.00 71.95           C  
ATOM   1366  O   LEU   168      26.886  39.378  91.409  1.00 72.69           O  
ATOM   1367  CB  LEU   168      26.700  40.502  88.726  1.00 68.81           C  
ATOM   1368  CG  LEU   168      25.923  41.090  87.550  1.00 66.67           C  
ATOM   1369  CD1 LEU   168      26.472  40.555  86.247  1.00 64.39           C  
ATOM   1370  CD2 LEU   168      24.420  40.871  87.662  1.00 64.21           C  
ATOM   1371  N   LYS   169      28.415  40.929  91.769  1.00 74.46           N  
ATOM   1372  CA  LYS   169      28.913  40.198  92.949  1.00 77.56           C  
ATOM   1373  C   LYS   169      27.846  39.801  94.033  1.00 78.83           C  
ATOM   1374  O   LYS   169      28.141  38.998  94.938  1.00 79.44           O  
ATOM   1375  CB  LYS   169      30.106  40.933  93.577  1.00 77.52           C  
ATOM   1376  CG  LYS   169      31.403  40.740  92.790  1.00 78.50           C  
ATOM   1377  CD  LYS   169      32.633  41.233  93.555  1.00 78.42           C  
ATOM   1378  CE  LYS   169      33.945  40.723  92.918  1.00 80.07           C  
ATOM   1379  NZ  LYS   169      35.138  40.771  93.875  1.00 79.99           N  
ATOM   1380  N   LYS   170      26.634  40.359  93.952  0.50 79.57           N  
ATOM   1382  CA  LYS   170      25.538  39.973  94.871  0.50 80.11           C  
ATOM   1384  C   LYS   170      24.549  38.959  94.268  0.50 80.39           C  
ATOM   1386  O   LYS   170      23.591  38.551  94.934  0.50 80.15           O  
ATOM   1388  CB  LYS   170      24.781  41.207  95.387  0.50 80.17           C  
ATOM   1390  CG  LYS   170      25.323  41.807  96.689  0.50 80.36           C  
ATOM   1392  CD  LYS   170      25.130  43.323  96.702  0.50 80.64           C  
ATOM   1394  CE  LYS   170      26.132  43.993  95.748  0.50 81.04           C  
ATOM   1396  NZ  LYS   170      25.532  45.067  94.897  0.50 80.73           N  
ATOM   1398  N   SER   171      24.786  38.562  93.015  1.00 80.70           N  
ATOM   1399  CA  SER   171      23.954  37.549  92.335  1.00 81.42           C  
ATOM   1400  C   SER   171      24.465  36.097  92.432  1.00 81.92           C  
ATOM   1401  O   SER   171      25.649  35.814  92.203  1.00 82.04           O  
ATOM   1402  CB  SER   171      23.759  37.931  90.868  1.00 81.24           C  
ATOM   1403  OG  SER   171      23.207  39.226  90.791  1.00 81.58           O  
ATOM   1404  N   ASP   172      23.545  35.186  92.744  1.00 82.34           N  
ATOM   1405  CA  ASP   172      23.861  33.770  92.943  1.00 82.68           C  
ATOM   1406  C   ASP   172      24.277  33.041  91.674  1.00 82.52           C  
ATOM   1407  O   ASP   172      23.873  33.417  90.568  1.00 82.88           O  
ATOM   1408  CB  ASP   172      22.657  33.062  93.559  1.00 82.79           C  
ATOM   1409  CG  ASP   172      22.438  33.458  95.000  1.00 84.58           C  
ATOM   1410  OD1 ASP   172      23.450  33.670  95.718  1.00 85.73           O  
ATOM   1411  OD2 ASP   172      21.258  33.563  95.417  1.00 86.61           O  
ATOM   1412  N   SER   173      25.096  32.003  91.843  1.00 82.19           N  
ATOM   1413  CA  SER   173      25.301  31.003  90.800  1.00 81.94           C  
ATOM   1414  C   SER   173      24.071  30.069  90.794  1.00 81.85           C  
ATOM   1415  O   SER   173      23.403  29.904  91.826  1.00 81.43           O  
ATOM   1416  CB  SER   173      26.592  30.199  91.050  1.00 81.85           C  
ATOM   1417  OG  SER   173      27.686  31.033  91.420  1.00 81.39           O  
ATOM   1418  N   PHE   174      23.758  29.470  89.644  1.00 81.81           N  
ATOM   1419  CA  PHE   174      22.619  28.543  89.587  1.00 81.63           C  
ATOM   1420  C   PHE   174      22.810  27.343  88.654  1.00 81.91           C  
ATOM   1421  O   PHE   174      23.540  27.415  87.661  1.00 81.37           O  
ATOM   1422  CB  PHE   174      21.292  29.292  89.303  1.00 81.50           C  
ATOM   1423  CG  PHE   174      21.210  29.948  87.929  1.00 79.93           C  
ATOM   1424  CD1 PHE   174      20.686  29.252  86.839  1.00 78.93           C  
ATOM   1425  CD2 PHE   174      21.613  31.277  87.746  1.00 78.89           C  
ATOM   1426  CE1 PHE   174      20.590  29.866  85.571  1.00 79.10           C  
ATOM   1427  CE2 PHE   174      21.518  31.899  86.488  1.00 78.38           C  
ATOM   1428  CZ  PHE   174      21.009  31.192  85.402  1.00 79.22           C  
ATOM   1429  N   HIS   175      22.150  26.239  89.005  1.00 82.82           N  
ATOM   1430  CA  HIS   175      22.171  25.024  88.184  1.00 83.73           C  
ATOM   1431  C   HIS   175      20.784  24.647  87.647  1.00 83.73           C  
ATOM   1432  O   HIS   175      20.188  23.692  88.128  1.00 83.82           O  
ATOM   1433  CB  HIS   175      22.792  23.846  88.952  1.00 83.68           C  
ATOM   1434  CG  HIS   175      23.642  22.961  88.092  1.00 85.07           C  
ATOM   1435  ND1 HIS   175      25.007  22.846  88.258  1.00 86.20           N  
ATOM   1436  CD2 HIS   175      23.328  22.187  87.023  1.00 86.70           C  
ATOM   1437  CE1 HIS   175      25.491  22.015  87.347  1.00 86.84           C  
ATOM   1438  NE2 HIS   175      24.495  21.607  86.580  1.00 86.55           N  
ATOM   1439  N   GLN   176      20.311  25.384  86.631  1.00 84.15           N  
ATOM   1440  CA  GLN   176      18.948  25.260  86.075  1.00 83.95           C  
ATOM   1441  C   GLN   176      18.909  25.379  84.553  1.00 84.23           C  
ATOM   1442  O   GLN   176      17.994  24.871  83.896  1.00 84.64           O  
ATOM   1443  CB  GLN   176      18.045  26.337  86.670  1.00 83.77           C  
ATOM   1444  CG  GLN   176      16.990  25.824  87.634  1.00 83.19           C  
ATOM   1445  CD  GLN   176      17.544  25.260  88.942  1.00 82.37           C  
ATOM   1446  OE1 GLN   176      18.293  25.931  89.668  1.00 82.87           O  
ATOM   1447  NE2 GLN   176      17.149  24.024  89.261  1.00 80.86           N  
END
