
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  134 ( 2002),  selected  134 , name 1vee_A
# Molecule2: number of CA atoms  120 (  935),  selected  120 , name T0411.pdb
# PARAMETERS: 1vee_A.T0411.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S      20           -
LGA    S     2_A      N      21          5.036
LGA    S     3_A      -       -           -
LGA    G     4_A      I      22          3.763
LGA    S     5_A      Q      23          2.719
LGA    S     6_A      S      24          1.656
LGA    G     7_A      Y      25          2.941
LGA    S     8_A      S      26          0.707
LGA    A     9_A      F      27          2.658
LGA    K    10_A      E      28          2.299
LGA    N    11_A      D      29          1.019
LGA    A    12_A      M      30          2.676
LGA    Y    13_A      K      31          3.355
LGA    T    14_A      R      32          1.647
LGA    K    15_A      I      33          3.056
LGA    L    16_A      V      34          4.428
LGA    -       -      G      35           -
LGA    G    17_A      K      36          1.332
LGA    T    18_A      H      37           #
LGA    D    19_A      D      38          3.778
LGA    D    20_A      P      39          2.986
LGA    N    21_A      N      40          0.310
LGA    A    22_A      V      41          0.247
LGA    Q    23_A      V      42          1.374
LGA    L    24_A      L      43          0.927
LGA    L    25_A      V      44          1.330
LGA    D    26_A      D      45          1.342
LGA    I    27_A      V      46          0.252
LGA    R    28_A      R      47          0.491
LGA    A    29_A      E      48          1.502
LGA    T    30_A      P      49          1.991
LGA    A    31_A      S      50          2.438
LGA    D    32_A      E      51          1.192
LGA    F    33_A      Y      52          2.624
LGA    R    34_A      S      53          3.815
LGA    Q    35_A      I      54          3.299
LGA    V    36_A      V      55          3.619
LGA    G    37_A      -       -           -
LGA    S    38_A      H      56          2.132
LGA    P    39_A      I      57          1.750
LGA    N    40_A      P      58          2.113
LGA    I    41_A      -       -           -
LGA    K    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    L    44_A      -       -           -
LGA    G    45_A      -       -           -
LGA    K    46_A      -       -           -
LGA    K    47_A      A      59          2.712
LGA    A    48_A      S      60          1.944
LGA    V    49_A      I      61          1.277
LGA    S    50_A      N      62          1.091
LGA    T    51_A      V      63          1.485
LGA    V    52_A      P      64          0.881
LGA    Y    53_A      Y      65          0.587
LGA    N    54_A      R      66          3.097
LGA    G    55_A      S      67           -
LGA    E    56_A      -       -           -
LGA    D    57_A      H      68          4.144
LGA    K    58_A      P      69          3.524
LGA    P    59_A      D      70          2.878
LGA    G    60_A      A      71          3.933
LGA    F    61_A      F      72          4.845
LGA    L    62_A      A      73          3.712
LGA    K    63_A      L      74          2.603
LGA    -       -      D      75           -
LGA    -       -      P      76           -
LGA    -       -      L      77           -
LGA    -       -      E      78           -
LGA    K    64_A      F      79          2.634
LGA    L    65_A      E      80           #
LGA    S    66_A      K      81           -
LGA    -       -      Q      82           -
LGA    -       -      I      83           -
LGA    -       -      G      84           -
LGA    L    67_A      I      85           #
LGA    K    68_A      P      86          1.640
LGA    F    69_A      K      87          4.329
LGA    K    70_A      P      88           #
LGA    D    71_A      D      89          3.029
LGA    P    72_A      S      90          1.384
LGA    E    73_A      -       -           -
LGA    N    74_A      A      91          1.084
LGA    T    75_A      K      92          1.140
LGA    T    76_A      E      93          1.294
LGA    L    77_A      L      94          1.368
LGA    Y    78_A      I      95          1.333
LGA    I    79_A      F      96          1.402
LGA    L    80_A      Y      97          2.373
LGA    D    81_A      C      98          0.527
LGA    K    82_A      A      99          0.975
LGA    F    83_A      S     100          0.723
LGA    D    84_A      G     101          1.409
LGA    G    85_A      K     102          1.723
LGA    N    86_A      R     103          2.365
LGA    S    87_A      G     104          2.011
LGA    E    88_A      G     105          2.484
LGA    L    89_A      E     106          2.984
LGA    V    90_A      A     107          2.145
LGA    A    91_A      Q     108          2.099
LGA    E    92_A      K     109          3.082
LGA    L    93_A      V     110          2.326
LGA    V    94_A      A     111          1.267
LGA    A    95_A      S     112          2.008
LGA    L    96_A      S     113          2.282
LGA    N    97_A      H     114          1.198
LGA    G    98_A      G     115          1.285
LGA    F    99_A      Y     116          1.583
LGA    K   100_A      S     117          3.421
LGA    S   101_A      N     118          1.723
LGA    A   102_A      T     119          2.158
LGA    Y   103_A      S     120          2.145
LGA    A   104_A      L     121          1.581
LGA    I   105_A      Y     122          1.112
LGA    K   106_A      P     123          1.627
LGA    D   107_A      G     124          1.974
LGA    G   108_A      S     125          1.698
LGA    A   109_A      M     126          0.654
LGA    E   110_A      N     127          1.552
LGA    G   111_A      -       -           -
LGA    P   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    G   114_A      D     128          0.800
LGA    W   115_A      W     129          1.171
LGA    L   116_A      V     130          1.970
LGA    N   117_A      S     131          2.565
LGA    S   118_A      H     132          3.152
LGA    S   119_A      G     133          3.878
LGA    L   120_A      G     134          2.561
LGA    P   121_A      D     135          4.001
LGA    -       -      K     136           -
LGA    W   122_A      L     137           #
LGA    I   123_A      D     138           -
LGA    E   124_A      L     139           -
LGA    P   125_A      -       -           -
LGA    K   126_A      -       -           -
LGA    K   127_A      -       -           -
LGA    T   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    S   132_A      -       -           -
LGA    S   133_A      -       -           -
LGA    G   134_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  134  120    5.0    101    2.39    13.86     57.078     4.060

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.293512 * X  +  -0.898409 * Y  +   0.326667 * Z  +   8.200401
  Y_new =  -0.514696 * X  +   0.436477 * Y  +   0.737954 * Z  +   1.861161
  Z_new =  -0.805567 * X  +   0.048464 * Y  +  -0.590519 * Z  +   9.605511 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.059705   -0.081887  [ DEG:   175.3082     -4.6918 ]
  Theta =   0.936633    2.204960  [ DEG:    53.6651    126.3349 ]
  Phi   =  -2.089064    1.052529  [ DEG:  -119.6945     60.3055 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vee_A                                        
REMARK     2: T0411.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vee_A.T0411.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  134  120   5.0  101   2.39   13.86  57.078
REMARK  ---------------------------------------------------------- 
MOLECULE 1vee_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-MAR-04   1VEE              
TITLE     NMR STRUCTURE OF THE HYPOTHETICAL RHODANESE DOMAIN                    
TITLE    2 AT4G01050 FROM ARABIDOPSIS THALIANA                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROLINE-RICH PROTEIN FAMILY;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RHODANESE HYPOTHETICAL DOMAIN;                             
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN RAFL06-68-J04;                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARABIDOPSIS THALIANA;                           
SOURCE   3 ORGANISM_COMMON: THALE CRESS;                                        
SOURCE   4 GENE: RIKEN CDNA RAFL06-68-J04;                                      
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P030120-27;                               
SOURCE   7 OTHER_DETAILS: E.COLI CELL-FREE PROTEIN SYNTHESIS                    
KEYWDS    HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, RHODANESE DOMAIN,          
KEYWDS   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    D.PANTOJA-UCEDA,B.LOPEZ-MENDEZ,S.KOSHIBA,M.INOUE,T.KIGAWA,            
AUTHOR   2 T.TERADA,M.SHIROUZU,A.TANAKA,M.SEKI,K.SHINOZAKI,S.YOKOYAMA,          
AUTHOR   3 P.GUNTERT,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE            
AUTHOR   4 (RSGI)                                                               
REVDAT   2   15-FEB-05 1VEE    1       AUTHOR                                   
REVDAT   1   25-JAN-05 1VEE    0                                                
JRNL        AUTH   D.PANTOJA-UCEDA,B.LOPEZ-MENDEZ,S.KOSHIBA,M.INOUE,            
JRNL        AUTH 2 T.KIGAWA,T.TERADA,M.SHIROUZU,A.TANAKA,M.SEKI,                
JRNL        AUTH 3 K.SHINOZAKI,S.YOKOYAMA,P.GUNTERT                             
JRNL        TITL   SOLUTION STRUCTURE OF THE RHODANESE HOMOLOGY                 
JRNL        TITL 2 DOMAIN AT4G01050(175-295) FROM ARABIDOPSIS THALIANA          
JRNL        REF    PROTEIN SCI.                  V.  14   224 2005              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1VEE A    8   128  UNP    Q9M158   Y4105_ARATH    134    254             
SEQRES   1 A  134  GLY SER SER GLY SER SER GLY SER ALA LYS ASN ALA TYR          
SEQRES   2 A  134  THR LYS LEU GLY THR ASP ASP ASN ALA GLN LEU LEU ASP          
SEQRES   3 A  134  ILE ARG ALA THR ALA ASP PHE ARG GLN VAL GLY SER PRO          
SEQRES   4 A  134  ASN ILE LYS GLY LEU GLY LYS LYS ALA VAL SER THR VAL          
SEQRES   5 A  134  TYR ASN GLY GLU ASP LYS PRO GLY PHE LEU LYS LYS LEU          
SEQRES   6 A  134  SER LEU LYS PHE LYS ASP PRO GLU ASN THR THR LEU TYR          
SEQRES   7 A  134  ILE LEU ASP LYS PHE ASP GLY ASN SER GLU LEU VAL ALA          
SEQRES   8 A  134  GLU LEU VAL ALA LEU ASN GLY PHE LYS SER ALA TYR ALA          
SEQRES   9 A  134  ILE LYS ASP GLY ALA GLU GLY PRO ARG GLY TRP LEU ASN          
SEQRES  10 A  134  SER SER LEU PRO TRP ILE GLU PRO LYS LYS THR SER GLY          
SEQRES  11 A  134  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      20.245  21.779   5.124  1.00  0.00           N  
ATOM      2  CA  GLY A   1      20.900  20.540   4.686  1.00  0.00           C  
ATOM      3  C   GLY A   1      20.141  19.325   5.191  1.00  0.00           C  
ATOM      4  O   GLY A   1      18.952  19.423   5.501  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      20.957  20.518   3.597  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      21.903  20.524   5.104  1.00  0.00           H  
ATOM      7  H1  GLY A   1      20.024  21.817   6.099  1.00  0.00           H  
ATOM      8  N   SER A   2      20.797  18.167   5.268  1.00  0.00           N  
ATOM      9  CA  SER A   2      20.163  16.945   5.756  1.00  0.00           C  
ATOM     10  C   SER A   2      19.707  17.167   7.199  1.00  0.00           C  
ATOM     11  O   SER A   2      20.437  17.773   7.989  1.00  0.00           O  
ATOM     12  CB  SER A   2      21.149  15.786   5.633  1.00  0.00           C  
ATOM     13  OG  SER A   2      21.418  15.604   4.257  1.00  0.00           O  
ATOM     14  H   SER A   2      21.770  18.109   5.002  1.00  0.00           H  
ATOM     15  HA  SER A   2      19.286  16.733   5.141  1.00  0.00           H  
ATOM     16  HB2 SER A   2      22.073  16.032   6.159  1.00  0.00           H  
ATOM     17  HB3 SER A   2      20.713  14.878   6.051  1.00  0.00           H  
ATOM     18  HG  SER A   2      22.285  15.179   4.143  1.00  0.00           H  
ATOM     19  N   SER A   3      18.507  16.699   7.531  1.00  0.00           N  
ATOM     20  CA  SER A   3      17.903  16.834   8.842  1.00  0.00           C  
ATOM     21  C   SER A   3      17.421  15.473   9.337  1.00  0.00           C  
ATOM     22  O   SER A   3      18.019  14.921  10.263  1.00  0.00           O  
ATOM     23  CB  SER A   3      16.801  17.905   8.793  1.00  0.00           C  
ATOM     24  OG  SER A   3      15.918  17.705   7.697  1.00  0.00           O  
ATOM     25  H   SER A   3      17.957  16.204   6.834  1.00  0.00           H  
ATOM     26  HA  SER A   3      18.656  17.185   9.541  1.00  0.00           H  
ATOM     27  HB2 SER A   3      16.243  17.880   9.729  1.00  0.00           H  
ATOM     28  HB3 SER A   3      17.263  18.888   8.690  1.00  0.00           H  
ATOM     29  HG  SER A   3      16.373  17.975   6.891  1.00  0.00           H  
ATOM     30  N   GLY A   4      16.367  14.931   8.726  1.00  0.00           N  
ATOM     31  CA  GLY A   4      15.774  13.646   9.057  1.00  0.00           C  
ATOM     32  C   GLY A   4      16.736  12.517   8.707  1.00  0.00           C  
ATOM     33  O   GLY A   4      17.101  12.358   7.539  1.00  0.00           O  
ATOM     34  H   GLY A   4      15.939  15.455   7.972  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      15.526  13.622  10.119  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      14.856  13.523   8.485  1.00  0.00           H  
ATOM     37  N   SER A   5      17.176  11.761   9.716  1.00  0.00           N  
ATOM     38  CA  SER A   5      18.088  10.640   9.542  1.00  0.00           C  
ATOM     39  C   SER A   5      17.435   9.661   8.565  1.00  0.00           C  
ATOM     40  O   SER A   5      16.394   9.074   8.868  1.00  0.00           O  
ATOM     41  CB  SER A   5      18.350   9.982  10.894  1.00  0.00           C  
ATOM     42  OG  SER A   5      18.885  10.897  11.843  1.00  0.00           O  
ATOM     43  H   SER A   5      16.833  11.938  10.653  1.00  0.00           H  
ATOM     44  HA  SER A   5      19.028  11.003   9.123  1.00  0.00           H  
ATOM     45  HB2 SER A   5      17.405   9.604  11.276  1.00  0.00           H  
ATOM     46  HB3 SER A   5      19.037   9.144  10.764  1.00  0.00           H  
ATOM     47  HG  SER A   5      18.464  10.678  12.693  1.00  0.00           H  
ATOM     48  N   SER A   6      18.031   9.467   7.395  1.00  0.00           N  
ATOM     49  CA  SER A   6      17.488   8.589   6.376  1.00  0.00           C  
ATOM     50  C   SER A   6      18.592   7.914   5.574  1.00  0.00           C  
ATOM     51  O   SER A   6      19.784   8.141   5.806  1.00  0.00           O  
ATOM     52  CB  SER A   6      16.562   9.459   5.513  1.00  0.00           C  
ATOM     53  OG  SER A   6      17.188  10.657   5.088  1.00  0.00           O  
ATOM     54  H   SER A   6      18.883   9.974   7.170  1.00  0.00           H  
ATOM     55  HA  SER A   6      16.905   7.785   6.828  1.00  0.00           H  
ATOM     56  HB2 SER A   6      16.216   8.888   4.653  1.00  0.00           H  
ATOM     57  HB3 SER A   6      15.704   9.746   6.108  1.00  0.00           H  
ATOM     58  HG  SER A   6      17.044  11.329   5.791  1.00  0.00           H  
ATOM     59  N   GLY A   7      18.196   7.061   4.631  1.00  0.00           N  
ATOM     60  CA  GLY A   7      19.154   6.367   3.789  1.00  0.00           C  
ATOM     61  C   GLY A   7      18.488   5.381   2.851  1.00  0.00           C  
ATOM     62  O   GLY A   7      17.668   5.769   2.020  1.00  0.00           O  
ATOM     63  H   GLY A   7      17.204   6.916   4.495  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      19.685   7.098   3.181  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      19.876   5.854   4.421  1.00  0.00           H  
ATOM     66  N   SER A   8      18.814   4.105   3.010  1.00  0.00           N  
ATOM     67  CA  SER A   8      18.308   2.990   2.205  1.00  0.00           C  
ATOM     68  C   SER A   8      17.616   1.945   3.087  1.00  0.00           C  
ATOM     69  O   SER A   8      18.057   1.703   4.216  1.00  0.00           O  
ATOM     70  CB  SER A   8      19.453   2.365   1.403  1.00  0.00           C  
ATOM     71  OG  SER A   8      20.229   3.350   0.739  1.00  0.00           O  
ATOM     72  H   SER A   8      19.492   3.936   3.732  1.00  0.00           H  
ATOM     73  HA  SER A   8      17.589   3.362   1.477  1.00  0.00           H  
ATOM     74  HB2 SER A   8      20.097   1.794   2.075  1.00  0.00           H  
ATOM     75  HB3 SER A   8      19.025   1.686   0.665  1.00  0.00           H  
ATOM     76  HG  SER A   8      19.617   3.891   0.198  1.00  0.00           H  
ATOM     77  N   ALA A   9      16.597   1.261   2.557  1.00  0.00           N  
ATOM     78  CA  ALA A   9      15.836   0.232   3.267  1.00  0.00           C  
ATOM     79  C   ALA A   9      16.766  -0.865   3.805  1.00  0.00           C  
ATOM     80  O   ALA A   9      16.660  -1.264   4.964  1.00  0.00           O  
ATOM     81  CB  ALA A   9      14.754  -0.334   2.337  1.00  0.00           C  
ATOM     82  H   ALA A   9      16.280   1.529   1.628  1.00  0.00           H  
ATOM     83  HA  ALA A   9      15.343   0.698   4.120  1.00  0.00           H  
ATOM     84  HB1 ALA A   9      15.218  -0.868   1.513  1.00  0.00           H  
ATOM     85  HB2 ALA A   9      14.102  -1.017   2.886  1.00  0.00           H  
ATOM     86  HB3 ALA A   9      14.143   0.470   1.922  1.00  0.00           H  
ATOM     87  N   LYS A  10      17.739  -1.299   2.995  1.00  0.00           N  
ATOM     88  CA  LYS A  10      18.710  -2.331   3.371  1.00  0.00           C  
ATOM     89  C   LYS A  10      19.482  -1.940   4.630  1.00  0.00           C  
ATOM     90  O   LYS A  10      19.710  -2.784   5.499  1.00  0.00           O  
ATOM     91  CB  LYS A  10      19.678  -2.601   2.213  1.00  0.00           C  
ATOM     92  CG  LYS A  10      18.935  -3.174   0.996  1.00  0.00           C  
ATOM     93  CD  LYS A  10      19.826  -3.431  -0.223  1.00  0.00           C  
ATOM     94  CE  LYS A  10      18.908  -3.828  -1.387  1.00  0.00           C  
ATOM     95  NZ  LYS A  10      19.571  -3.766  -2.702  1.00  0.00           N  
ATOM     96  H   LYS A  10      17.764  -0.932   2.055  1.00  0.00           H  
ATOM     97  HA  LYS A  10      18.172  -3.253   3.598  1.00  0.00           H  
ATOM     98  HB2 LYS A  10      20.183  -1.676   1.933  1.00  0.00           H  
ATOM     99  HB3 LYS A  10      20.426  -3.308   2.567  1.00  0.00           H  
ATOM    100  HG2 LYS A  10      18.442  -4.104   1.284  1.00  0.00           H  
ATOM    101  HG3 LYS A  10      18.176  -2.453   0.695  1.00  0.00           H  
ATOM    102  HD2 LYS A  10      20.372  -2.521  -0.469  1.00  0.00           H  
ATOM    103  HD3 LYS A  10      20.534  -4.235  -0.007  1.00  0.00           H  
ATOM    104  HE2 LYS A  10      18.538  -4.842  -1.218  1.00  0.00           H  
ATOM    105  HE3 LYS A  10      18.056  -3.147  -1.411  1.00  0.00           H  
ATOM    106  HZ1 LYS A  10      18.922  -4.079  -3.426  1.00  0.00           H  
ATOM    107  HZ2 LYS A  10      20.366  -4.390  -2.745  1.00  0.00           H  
ATOM    108  HZ3 LYS A  10      19.849  -2.817  -2.934  1.00  0.00           H  
ATOM    109  N   ASN A  11      19.880  -0.666   4.739  1.00  0.00           N  
ATOM    110  CA  ASN A  11      20.602  -0.180   5.910  1.00  0.00           C  
ATOM    111  C   ASN A  11      19.717  -0.351   7.136  1.00  0.00           C  
ATOM    112  O   ASN A  11      20.212  -0.770   8.171  1.00  0.00           O  
ATOM    113  CB  ASN A  11      21.035   1.292   5.759  1.00  0.00           C  
ATOM    114  CG  ASN A  11      21.538   1.890   7.077  1.00  0.00           C  
ATOM    115  OD1 ASN A  11      22.734   1.886   7.352  1.00  0.00           O  
ATOM    116  ND2 ASN A  11      20.666   2.448   7.901  1.00  0.00           N  
ATOM    117  H   ASN A  11      19.660  -0.020   3.998  1.00  0.00           H  
ATOM    118  HA  ASN A  11      21.487  -0.798   6.061  1.00  0.00           H  
ATOM    119  HB2 ASN A  11      21.831   1.355   5.016  1.00  0.00           H  
ATOM    120  HB3 ASN A  11      20.205   1.897   5.408  1.00  0.00           H  
ATOM    121 HD21 ASN A  11      19.689   2.546   7.641  1.00  0.00           H  
ATOM    122 HD22 ASN A  11      20.983   2.845   8.771  1.00  0.00           H  
ATOM    123  N   ALA A  12      18.426  -0.027   7.029  1.00  0.00           N  
ATOM    124  CA  ALA A  12      17.511  -0.149   8.156  1.00  0.00           C  
ATOM    125  C   ALA A  12      17.379  -1.612   8.578  1.00  0.00           C  
ATOM    126  O   ALA A  12      17.505  -1.880   9.768  1.00  0.00           O  
ATOM    127  CB  ALA A  12      16.166   0.533   7.882  1.00  0.00           C  
ATOM    128  H   ALA A  12      18.095   0.298   6.130  1.00  0.00           H  
ATOM    129  HA  ALA A  12      17.964   0.373   9.000  1.00  0.00           H  
ATOM    130  HB1 ALA A  12      15.452   0.246   8.656  1.00  0.00           H  
ATOM    131  HB2 ALA A  12      16.282   1.622   7.936  1.00  0.00           H  
ATOM    132  HB3 ALA A  12      15.768   0.236   6.915  1.00  0.00           H  
ATOM    133  N   TYR A  13      17.175  -2.561   7.654  1.00  0.00           N  
ATOM    134  CA  TYR A  13      17.065  -3.979   8.024  1.00  0.00           C  
ATOM    135  C   TYR A  13      18.357  -4.453   8.700  1.00  0.00           C  
ATOM    136  O   TYR A  13      18.313  -5.181   9.692  1.00  0.00           O  
ATOM    137  CB  TYR A  13      16.716  -4.842   6.811  1.00  0.00           C  
ATOM    138  CG  TYR A  13      16.267  -6.250   7.179  1.00  0.00           C  
ATOM    139  CD1 TYR A  13      15.001  -6.455   7.756  1.00  0.00           C  
ATOM    140  CD2 TYR A  13      17.104  -7.356   6.947  1.00  0.00           C  
ATOM    141  CE1 TYR A  13      14.555  -7.756   8.056  1.00  0.00           C  
ATOM    142  CE2 TYR A  13      16.686  -8.660   7.280  1.00  0.00           C  
ATOM    143  CZ  TYR A  13      15.403  -8.865   7.842  1.00  0.00           C  
ATOM    144  OH  TYR A  13      14.958 -10.112   8.171  1.00  0.00           O  
ATOM    145  H   TYR A  13      17.076  -2.290   6.683  1.00  0.00           H  
ATOM    146  HA  TYR A  13      16.257  -4.083   8.746  1.00  0.00           H  
ATOM    147  HB2 TYR A  13      15.904  -4.358   6.273  1.00  0.00           H  
ATOM    148  HB3 TYR A  13      17.575  -4.892   6.140  1.00  0.00           H  
ATOM    149  HD1 TYR A  13      14.381  -5.604   7.982  1.00  0.00           H  
ATOM    150  HD2 TYR A  13      18.088  -7.188   6.534  1.00  0.00           H  
ATOM    151  HE1 TYR A  13      13.571  -7.914   8.468  1.00  0.00           H  
ATOM    152  HE2 TYR A  13      17.360  -9.489   7.120  1.00  0.00           H  
ATOM    153  HH  TYR A  13      15.648 -10.793   8.275  1.00  0.00           H  
ATOM    154  N   THR A  14      19.507  -4.011   8.189  1.00  0.00           N  
ATOM    155  CA  THR A  14      20.802  -4.355   8.753  1.00  0.00           C  
ATOM    156  C   THR A  14      20.878  -3.789  10.176  1.00  0.00           C  
ATOM    157  O   THR A  14      21.130  -4.539  11.115  1.00  0.00           O  
ATOM    158  CB  THR A  14      21.934  -3.841   7.852  1.00  0.00           C  
ATOM    159  OG1 THR A  14      21.766  -4.356   6.541  1.00  0.00           O  
ATOM    160  CG2 THR A  14      23.297  -4.288   8.390  1.00  0.00           C  
ATOM    161  H   THR A  14      19.472  -3.422   7.369  1.00  0.00           H  
ATOM    162  HA  THR A  14      20.883  -5.439   8.816  1.00  0.00           H  
ATOM    163  HB  THR A  14      21.909  -2.753   7.806  1.00  0.00           H  
ATOM    164  HG1 THR A  14      21.069  -3.837   6.103  1.00  0.00           H  
ATOM    165 HG21 THR A  14      23.334  -5.374   8.481  1.00  0.00           H  
ATOM    166 HG22 THR A  14      23.471  -3.863   9.379  1.00  0.00           H  
ATOM    167 HG23 THR A  14      24.087  -3.951   7.721  1.00  0.00           H  
ATOM    168  N   LYS A  15      20.636  -2.483  10.363  1.00  0.00           N  
ATOM    169  CA  LYS A  15      20.679  -1.849  11.676  1.00  0.00           C  
ATOM    170  C   LYS A  15      19.712  -2.532  12.633  1.00  0.00           C  
ATOM    171  O   LYS A  15      20.107  -2.826  13.747  1.00  0.00           O  
ATOM    172  CB  LYS A  15      20.482  -0.330  11.604  1.00  0.00           C  
ATOM    173  CG  LYS A  15      21.642   0.439  10.939  1.00  0.00           C  
ATOM    174  CD  LYS A  15      23.012   0.100  11.544  1.00  0.00           C  
ATOM    175  CE  LYS A  15      24.097   1.092  11.119  1.00  0.00           C  
ATOM    176  NZ  LYS A  15      24.129   2.287  11.984  1.00  0.00           N  
ATOM    177  H   LYS A  15      20.427  -1.901   9.561  1.00  0.00           H  
ATOM    178  HA  LYS A  15      21.663  -2.026  12.091  1.00  0.00           H  
ATOM    179  HB2 LYS A  15      19.548  -0.104  11.085  1.00  0.00           H  
ATOM    180  HB3 LYS A  15      20.401   0.031  12.630  1.00  0.00           H  
ATOM    181  HG2 LYS A  15      21.680   0.215   9.876  1.00  0.00           H  
ATOM    182  HG3 LYS A  15      21.445   1.506  11.042  1.00  0.00           H  
ATOM    183  HD2 LYS A  15      22.947   0.069  12.632  1.00  0.00           H  
ATOM    184  HD3 LYS A  15      23.308  -0.883  11.181  1.00  0.00           H  
ATOM    185  HE2 LYS A  15      25.072   0.603  11.172  1.00  0.00           H  
ATOM    186  HE3 LYS A  15      23.927   1.388  10.082  1.00  0.00           H  
ATOM    187  HZ1 LYS A  15      24.662   3.022  11.522  1.00  0.00           H  
ATOM    188  HZ2 LYS A  15      24.560   2.096  12.883  1.00  0.00           H  
ATOM    189  HZ3 LYS A  15      23.196   2.646  12.172  1.00  0.00           H  
ATOM    190  N   LEU A  16      18.493  -2.866  12.220  1.00  0.00           N  
ATOM    191  CA  LEU A  16      17.496  -3.558  13.045  1.00  0.00           C  
ATOM    192  C   LEU A  16      18.010  -4.929  13.515  1.00  0.00           C  
ATOM    193  O   LEU A  16      17.448  -5.475  14.467  1.00  0.00           O  
ATOM    194  CB  LEU A  16      16.262  -3.815  12.183  1.00  0.00           C  
ATOM    195  CG  LEU A  16      15.278  -2.637  12.036  1.00  0.00           C  
ATOM    196  CD1 LEU A  16      14.365  -2.821  10.818  1.00  0.00           C  
ATOM    197  CD2 LEU A  16      14.376  -2.488  13.272  1.00  0.00           C  
ATOM    198  H   LEU A  16      18.227  -2.592  11.279  1.00  0.00           H  
ATOM    199  HA  LEU A  16      17.221  -2.954  13.910  1.00  0.00           H  
ATOM    200  HB2 LEU A  16      16.682  -4.099  11.232  1.00  0.00           H  
ATOM    201  HB3 LEU A  16      15.724  -4.679  12.558  1.00  0.00           H  
ATOM    202  HG  LEU A  16      15.847  -1.723  11.891  1.00  0.00           H  
ATOM    203 HD11 LEU A  16      13.836  -3.773  10.879  1.00  0.00           H  
ATOM    204 HD12 LEU A  16      14.960  -2.792   9.909  1.00  0.00           H  
ATOM    205 HD13 LEU A  16      13.649  -2.002  10.778  1.00  0.00           H  
ATOM    206 HD21 LEU A  16      14.034  -1.454  13.341  1.00  0.00           H  
ATOM    207 HD22 LEU A  16      14.919  -2.744  14.180  1.00  0.00           H  
ATOM    208 HD23 LEU A  16      13.499  -3.126  13.194  1.00  0.00           H  
ATOM    209  N   GLY A  17      19.014  -5.504  12.842  1.00  0.00           N  
ATOM    210  CA  GLY A  17      19.628  -6.791  13.145  1.00  0.00           C  
ATOM    211  C   GLY A  17      20.843  -6.662  14.066  1.00  0.00           C  
ATOM    212  O   GLY A  17      21.324  -7.673  14.575  1.00  0.00           O  
ATOM    213  H   GLY A  17      19.431  -5.004  12.065  1.00  0.00           H  
ATOM    214  HA2 GLY A  17      18.896  -7.446  13.619  1.00  0.00           H  
ATOM    215  HA3 GLY A  17      19.951  -7.257  12.214  1.00  0.00           H  
ATOM    216  N   THR A  18      21.325  -5.450  14.335  1.00  0.00           N  
ATOM    217  CA  THR A  18      22.468  -5.212  15.216  1.00  0.00           C  
ATOM    218  C   THR A  18      22.088  -4.272  16.360  1.00  0.00           C  
ATOM    219  O   THR A  18      22.763  -4.237  17.385  1.00  0.00           O  
ATOM    220  CB  THR A  18      23.664  -4.771  14.365  1.00  0.00           C  
ATOM    221  OG1 THR A  18      24.849  -4.653  15.114  1.00  0.00           O  
ATOM    222  CG2 THR A  18      23.483  -3.464  13.598  1.00  0.00           C  
ATOM    223  H   THR A  18      20.905  -4.643  13.889  1.00  0.00           H  
ATOM    224  HA  THR A  18      22.746  -6.153  15.690  1.00  0.00           H  
ATOM    225  HB  THR A  18      23.793  -5.551  13.625  1.00  0.00           H  
ATOM    226  HG1 THR A  18      24.880  -5.409  15.739  1.00  0.00           H  
ATOM    227 HG21 THR A  18      22.687  -3.611  12.879  1.00  0.00           H  
ATOM    228 HG22 THR A  18      24.395  -3.233  13.048  1.00  0.00           H  
ATOM    229 HG23 THR A  18      23.240  -2.646  14.276  1.00  0.00           H  
ATOM    230  N   ASP A  19      20.985  -3.536  16.209  1.00  0.00           N  
ATOM    231  CA  ASP A  19      20.514  -2.626  17.241  1.00  0.00           C  
ATOM    232  C   ASP A  19      19.444  -3.390  18.009  1.00  0.00           C  
ATOM    233  O   ASP A  19      18.339  -3.640  17.511  1.00  0.00           O  
ATOM    234  CB  ASP A  19      20.023  -1.286  16.682  1.00  0.00           C  
ATOM    235  CG  ASP A  19      19.500  -0.339  17.781  1.00  0.00           C  
ATOM    236  OD1 ASP A  19      19.706  -0.632  18.982  1.00  0.00           O  
ATOM    237  OD2 ASP A  19      18.908   0.714  17.424  1.00  0.00           O  
ATOM    238  H   ASP A  19      20.470  -3.610  15.324  1.00  0.00           H  
ATOM    239  HA  ASP A  19      21.335  -2.391  17.920  1.00  0.00           H  
ATOM    240  HB2 ASP A  19      20.853  -0.798  16.169  1.00  0.00           H  
ATOM    241  HB3 ASP A  19      19.247  -1.477  15.945  1.00  0.00           H  
ATOM    242  N   ASP A  20      19.801  -3.865  19.199  1.00  0.00           N  
ATOM    243  CA  ASP A  20      18.909  -4.610  20.077  1.00  0.00           C  
ATOM    244  C   ASP A  20      17.732  -3.730  20.492  1.00  0.00           C  
ATOM    245  O   ASP A  20      16.671  -4.269  20.800  1.00  0.00           O  
ATOM    246  CB  ASP A  20      19.633  -5.130  21.325  1.00  0.00           C  
ATOM    247  CG  ASP A  20      20.502  -6.344  21.018  1.00  0.00           C  
ATOM    248  OD1 ASP A  20      19.991  -7.488  21.041  1.00  0.00           O  
ATOM    249  OD2 ASP A  20      21.716  -6.154  20.783  1.00  0.00           O  
ATOM    250  H   ASP A  20      20.723  -3.613  19.541  1.00  0.00           H  
ATOM    251  HA  ASP A  20      18.525  -5.476  19.536  1.00  0.00           H  
ATOM    252  HB2 ASP A  20      20.236  -4.335  21.766  1.00  0.00           H  
ATOM    253  HB3 ASP A  20      18.892  -5.434  22.064  1.00  0.00           H  
ATOM    254  N   ASN A  21      17.872  -2.400  20.478  1.00  0.00           N  
ATOM    255  CA  ASN A  21      16.848  -1.422  20.836  1.00  0.00           C  
ATOM    256  C   ASN A  21      16.059  -0.913  19.624  1.00  0.00           C  
ATOM    257  O   ASN A  21      15.157  -0.088  19.793  1.00  0.00           O  
ATOM    258  CB  ASN A  21      17.493  -0.234  21.551  1.00  0.00           C  
ATOM    259  CG  ASN A  21      18.153  -0.631  22.857  1.00  0.00           C  
ATOM    260  OD1 ASN A  21      19.371  -0.694  22.959  1.00  0.00           O  
ATOM    261  ND2 ASN A  21      17.369  -0.954  23.869  1.00  0.00           N  
ATOM    262  H   ASN A  21      18.773  -2.004  20.218  1.00  0.00           H  
ATOM    263  HA  ASN A  21      16.138  -1.882  21.523  1.00  0.00           H  
ATOM    264  HB2 ASN A  21      18.230   0.235  20.899  1.00  0.00           H  
ATOM    265  HB3 ASN A  21      16.718   0.495  21.766  1.00  0.00           H  
ATOM    266 HD21 ASN A  21      16.376  -0.833  23.799  1.00  0.00           H  
ATOM    267 HD22 ASN A  21      17.804  -1.105  24.780  1.00  0.00           H  
ATOM    268  N   ALA A  22      16.360  -1.378  18.407  1.00  0.00           N  
ATOM    269  CA  ALA A  22      15.640  -0.936  17.221  1.00  0.00           C  
ATOM    270  C   ALA A  22      14.320  -1.671  17.061  1.00  0.00           C  
ATOM    271  O   ALA A  22      14.216  -2.858  17.386  1.00  0.00           O  
ATOM    272  CB  ALA A  22      16.478  -1.176  15.972  1.00  0.00           C  
ATOM    273  H   ALA A  22      17.111  -2.051  18.306  1.00  0.00           H  
ATOM    274  HA  ALA A  22      15.428   0.124  17.316  1.00  0.00           H  
ATOM    275  HB1 ALA A  22      15.885  -0.961  15.088  1.00  0.00           H  
ATOM    276  HB2 ALA A  22      17.327  -0.502  15.968  1.00  0.00           H  
ATOM    277  HB3 ALA A  22      16.817  -2.210  15.941  1.00  0.00           H  
ATOM    278  N   GLN A  23      13.334  -0.984  16.488  1.00  0.00           N  
ATOM    279  CA  GLN A  23      11.998  -1.478  16.213  1.00  0.00           C  
ATOM    280  C   GLN A  23      11.479  -0.786  14.936  1.00  0.00           C  
ATOM    281  O   GLN A  23      11.925   0.313  14.599  1.00  0.00           O  
ATOM    282  CB  GLN A  23      11.075  -1.168  17.414  1.00  0.00           C  
ATOM    283  CG  GLN A  23      11.433  -1.850  18.757  1.00  0.00           C  
ATOM    284  CD  GLN A  23      11.078  -3.342  18.834  1.00  0.00           C  
ATOM    285  OE1 GLN A  23      10.161  -3.818  18.170  1.00  0.00           O  
ATOM    286  NE2 GLN A  23      11.741  -4.124  19.661  1.00  0.00           N  
ATOM    287  H   GLN A  23      13.476  -0.005  16.248  1.00  0.00           H  
ATOM    288  HA  GLN A  23      12.080  -2.549  16.028  1.00  0.00           H  
ATOM    289  HB2 GLN A  23      11.095  -0.089  17.578  1.00  0.00           H  
ATOM    290  HB3 GLN A  23      10.048  -1.424  17.151  1.00  0.00           H  
ATOM    291  HG2 GLN A  23      12.483  -1.695  18.987  1.00  0.00           H  
ATOM    292  HG3 GLN A  23      10.887  -1.345  19.551  1.00  0.00           H  
ATOM    293 HE21 GLN A  23      12.544  -3.737  20.165  1.00  0.00           H  
ATOM    294 HE22 GLN A  23      11.485  -5.081  19.824  1.00  0.00           H  
ATOM    295  N   LEU A  24      10.548  -1.421  14.219  1.00  0.00           N  
ATOM    296  CA  LEU A  24       9.927  -0.931  12.985  1.00  0.00           C  
ATOM    297  C   LEU A  24       8.514  -0.463  13.321  1.00  0.00           C  
ATOM    298  O   LEU A  24       7.754  -1.196  13.962  1.00  0.00           O  
ATOM    299  CB  LEU A  24       9.906  -2.065  11.943  1.00  0.00           C  
ATOM    300  CG  LEU A  24       9.598  -1.712  10.471  1.00  0.00           C  
ATOM    301  CD1 LEU A  24       8.177  -1.198  10.211  1.00  0.00           C  
ATOM    302  CD2 LEU A  24      10.616  -0.736   9.871  1.00  0.00           C  
ATOM    303  H   LEU A  24      10.232  -2.318  14.568  1.00  0.00           H  
ATOM    304  HA  LEU A  24      10.507  -0.095  12.597  1.00  0.00           H  
ATOM    305  HB2 LEU A  24      10.882  -2.553  11.957  1.00  0.00           H  
ATOM    306  HB3 LEU A  24       9.170  -2.797  12.270  1.00  0.00           H  
ATOM    307  HG  LEU A  24       9.692  -2.647   9.918  1.00  0.00           H  
ATOM    308 HD11 LEU A  24       7.933  -1.316   9.156  1.00  0.00           H  
ATOM    309 HD12 LEU A  24       8.091  -0.141  10.450  1.00  0.00           H  
ATOM    310 HD13 LEU A  24       7.452  -1.766  10.796  1.00  0.00           H  
ATOM    311 HD21 LEU A  24      11.628  -1.086  10.072  1.00  0.00           H  
ATOM    312 HD22 LEU A  24      10.488   0.260  10.295  1.00  0.00           H  
ATOM    313 HD23 LEU A  24      10.475  -0.684   8.794  1.00  0.00           H  
ATOM    314  N   LEU A  25       8.163   0.739  12.873  1.00  0.00           N  
ATOM    315  CA  LEU A  25       6.879   1.384  13.084  1.00  0.00           C  
ATOM    316  C   LEU A  25       6.255   1.724  11.726  1.00  0.00           C  
ATOM    317  O   LEU A  25       6.794   2.519  10.960  1.00  0.00           O  
ATOM    318  CB  LEU A  25       7.124   2.615  13.962  1.00  0.00           C  
ATOM    319  CG  LEU A  25       5.895   3.545  14.040  1.00  0.00           C  
ATOM    320  CD1 LEU A  25       4.714   2.915  14.790  1.00  0.00           C  
ATOM    321  CD2 LEU A  25       6.290   4.828  14.756  1.00  0.00           C  
ATOM    322  H   LEU A  25       8.839   1.288  12.346  1.00  0.00           H  
ATOM    323  HA  LEU A  25       6.215   0.709  13.622  1.00  0.00           H  
ATOM    324  HB2 LEU A  25       7.401   2.290  14.968  1.00  0.00           H  
ATOM    325  HB3 LEU A  25       7.992   3.141  13.551  1.00  0.00           H  
ATOM    326  HG  LEU A  25       5.561   3.822  13.042  1.00  0.00           H  
ATOM    327 HD11 LEU A  25       4.350   2.050  14.243  1.00  0.00           H  
ATOM    328 HD12 LEU A  25       3.909   3.645  14.862  1.00  0.00           H  
ATOM    329 HD13 LEU A  25       5.023   2.622  15.794  1.00  0.00           H  
ATOM    330 HD21 LEU A  25       5.419   5.473  14.873  1.00  0.00           H  
ATOM    331 HD22 LEU A  25       7.031   5.338  14.145  1.00  0.00           H  
ATOM    332 HD23 LEU A  25       6.718   4.601  15.730  1.00  0.00           H  
ATOM    333  N   ASP A  26       5.126   1.085  11.425  1.00  0.00           N  
ATOM    334  CA  ASP A  26       4.349   1.238  10.207  1.00  0.00           C  
ATOM    335  C   ASP A  26       3.406   2.431  10.351  1.00  0.00           C  
ATOM    336  O   ASP A  26       2.383   2.339  11.049  1.00  0.00           O  
ATOM    337  CB  ASP A  26       3.443   0.022   9.957  1.00  0.00           C  
ATOM    338  CG  ASP A  26       4.064  -1.216   9.337  1.00  0.00           C  
ATOM    339  OD1 ASP A  26       4.552  -1.113   8.194  1.00  0.00           O  
ATOM    340  OD2 ASP A  26       3.803  -2.324   9.860  1.00  0.00           O  
ATOM    341  H   ASP A  26       4.735   0.450  12.111  1.00  0.00           H  
ATOM    342  HA  ASP A  26       5.008   1.378   9.349  1.00  0.00           H  
ATOM    343  HB2 ASP A  26       2.949  -0.261  10.885  1.00  0.00           H  
ATOM    344  HB3 ASP A  26       2.679   0.338   9.246  1.00  0.00           H  
ATOM    345  N   ILE A  27       3.733   3.555   9.714  1.00  0.00           N  
ATOM    346  CA  ILE A  27       2.884   4.748   9.738  1.00  0.00           C  
ATOM    347  C   ILE A  27       1.892   4.733   8.565  1.00  0.00           C  
ATOM    348  O   ILE A  27       1.109   5.677   8.395  1.00  0.00           O  
ATOM    349  CB  ILE A  27       3.678   6.058   9.848  1.00  0.00           C  
ATOM    350  CG1 ILE A  27       4.580   6.350   8.634  1.00  0.00           C  
ATOM    351  CG2 ILE A  27       4.450   6.076  11.175  1.00  0.00           C  
ATOM    352  CD1 ILE A  27       5.018   7.821   8.567  1.00  0.00           C  
ATOM    353  H   ILE A  27       4.581   3.575   9.150  1.00  0.00           H  
ATOM    354  HA  ILE A  27       2.276   4.694  10.631  1.00  0.00           H  
ATOM    355  HB  ILE A  27       2.929   6.843   9.900  1.00  0.00           H  
ATOM    356 HG12 ILE A  27       5.460   5.708   8.665  1.00  0.00           H  
ATOM    357 HG13 ILE A  27       4.027   6.126   7.722  1.00  0.00           H  
ATOM    358 HG21 ILE A  27       5.266   5.352  11.152  1.00  0.00           H  
ATOM    359 HG22 ILE A  27       4.851   7.069  11.360  1.00  0.00           H  
ATOM    360 HG23 ILE A  27       3.767   5.823  11.985  1.00  0.00           H  
ATOM    361 HD11 ILE A  27       4.143   8.466   8.487  1.00  0.00           H  
ATOM    362 HD12 ILE A  27       5.585   8.094   9.456  1.00  0.00           H  
ATOM    363 HD13 ILE A  27       5.651   7.976   7.693  1.00  0.00           H  
ATOM    364  N   ARG A  28       1.917   3.649   7.776  1.00  0.00           N  
ATOM    365  CA  ARG A  28       1.062   3.426   6.621  1.00  0.00           C  
ATOM    366  C   ARG A  28      -0.401   3.497   7.008  1.00  0.00           C  
ATOM    367  O   ARG A  28      -0.763   3.450   8.189  1.00  0.00           O  
ATOM    368  CB  ARG A  28       1.282   2.040   6.002  1.00  0.00           C  
ATOM    369  CG  ARG A  28       2.733   1.784   5.572  1.00  0.00           C  
ATOM    370  CD  ARG A  28       2.901   0.420   4.903  1.00  0.00           C  
ATOM    371  NE  ARG A  28       3.000  -0.647   5.911  1.00  0.00           N  
ATOM    372  CZ  ARG A  28       2.233  -1.730   6.025  1.00  0.00           C  
ATOM    373  NH1 ARG A  28       1.318  -2.037   5.113  1.00  0.00           N  
ATOM    374  NH2 ARG A  28       2.397  -2.515   7.077  1.00  0.00           N  
ATOM    375  H   ARG A  28       2.601   2.943   8.004  1.00  0.00           H  
ATOM    376  HA  ARG A  28       1.293   4.191   5.884  1.00  0.00           H  
ATOM    377  HB2 ARG A  28       0.895   1.292   6.699  1.00  0.00           H  
ATOM    378  HB3 ARG A  28       0.672   1.963   5.105  1.00  0.00           H  
ATOM    379  HG2 ARG A  28       3.010   2.548   4.850  1.00  0.00           H  
ATOM    380  HG3 ARG A  28       3.400   1.852   6.429  1.00  0.00           H  
ATOM    381  HD2 ARG A  28       2.070   0.251   4.221  1.00  0.00           H  
ATOM    382  HD3 ARG A  28       3.814   0.427   4.308  1.00  0.00           H  
ATOM    383  HE  ARG A  28       3.751  -0.547   6.605  1.00  0.00           H  
ATOM    384 HH11 ARG A  28       1.252  -1.489   4.264  1.00  0.00           H  
ATOM    385 HH12 ARG A  28       0.872  -2.951   5.136  1.00  0.00           H  
ATOM    386 HH21 ARG A  28       3.166  -2.297   7.726  1.00  0.00           H  
ATOM    387 HH22 ARG A  28       1.753  -3.250   7.311  1.00  0.00           H  
ATOM    388  N   ALA A  29      -1.242   3.617   5.995  1.00  0.00           N  
ATOM    389  CA  ALA A  29      -2.664   3.670   6.162  1.00  0.00           C  
ATOM    390  C   ALA A  29      -3.125   2.228   6.284  1.00  0.00           C  
ATOM    391  O   ALA A  29      -2.640   1.361   5.563  1.00  0.00           O  
ATOM    392  CB  ALA A  29      -3.271   4.317   4.920  1.00  0.00           C  
ATOM    393  H   ALA A  29      -0.896   3.631   5.042  1.00  0.00           H  
ATOM    394  HA  ALA A  29      -2.928   4.243   7.050  1.00  0.00           H  
ATOM    395  HB1 ALA A  29      -4.349   4.376   5.027  1.00  0.00           H  
ATOM    396  HB2 ALA A  29      -2.869   5.320   4.800  1.00  0.00           H  
ATOM    397  HB3 ALA A  29      -3.036   3.726   4.036  1.00  0.00           H  
ATOM    398  N   THR A  30      -4.096   1.975   7.146  1.00  0.00           N  
ATOM    399  CA  THR A  30      -4.700   0.666   7.378  1.00  0.00           C  
ATOM    400  C   THR A  30      -5.098  -0.008   6.050  1.00  0.00           C  
ATOM    401  O   THR A  30      -4.986  -1.226   5.936  1.00  0.00           O  
ATOM    402  CB  THR A  30      -5.879   0.849   8.339  1.00  0.00           C  
ATOM    403  OG1 THR A  30      -5.379   1.408   9.544  1.00  0.00           O  
ATOM    404  CG2 THR A  30      -6.602  -0.463   8.630  1.00  0.00           C  
ATOM    405  H   THR A  30      -4.410   2.749   7.698  1.00  0.00           H  
ATOM    406  HA  THR A  30      -3.967   0.027   7.869  1.00  0.00           H  
ATOM    407  HB  THR A  30      -6.594   1.544   7.904  1.00  0.00           H  
ATOM    408  HG1 THR A  30      -6.125   1.471  10.175  1.00  0.00           H  
ATOM    409 HG21 THR A  30      -5.886  -1.232   8.919  1.00  0.00           H  
ATOM    410 HG22 THR A  30      -7.137  -0.803   7.742  1.00  0.00           H  
ATOM    411 HG23 THR A  30      -7.322  -0.314   9.430  1.00  0.00           H  
ATOM    412  N   ALA A  31      -5.518   0.752   5.030  1.00  0.00           N  
ATOM    413  CA  ALA A  31      -5.880   0.189   3.735  1.00  0.00           C  
ATOM    414  C   ALA A  31      -4.668  -0.504   3.099  1.00  0.00           C  
ATOM    415  O   ALA A  31      -4.833  -1.519   2.425  1.00  0.00           O  
ATOM    416  CB  ALA A  31      -6.422   1.295   2.825  1.00  0.00           C  
ATOM    417  H   ALA A  31      -5.600   1.753   5.174  1.00  0.00           H  
ATOM    418  HA  ALA A  31      -6.657  -0.564   3.885  1.00  0.00           H  
ATOM    419  HB1 ALA A  31      -7.288   1.761   3.294  1.00  0.00           H  
ATOM    420  HB2 ALA A  31      -5.652   2.051   2.653  1.00  0.00           H  
ATOM    421  HB3 ALA A  31      -6.716   0.864   1.867  1.00  0.00           H  
ATOM    422  N   ASP A  32      -3.454   0.025   3.288  1.00  0.00           N  
ATOM    423  CA  ASP A  32      -2.225  -0.554   2.752  1.00  0.00           C  
ATOM    424  C   ASP A  32      -2.038  -1.932   3.405  1.00  0.00           C  
ATOM    425  O   ASP A  32      -1.684  -2.900   2.737  1.00  0.00           O  
ATOM    426  CB  ASP A  32      -0.965   0.321   3.004  1.00  0.00           C  
ATOM    427  CG  ASP A  32      -0.994   1.750   2.435  1.00  0.00           C  
ATOM    428  OD1 ASP A  32      -1.337   1.892   1.235  1.00  0.00           O  
ATOM    429  OD2 ASP A  32      -0.666   2.730   3.153  1.00  0.00           O  
ATOM    430  H   ASP A  32      -3.363   0.859   3.858  1.00  0.00           H  
ATOM    431  HA  ASP A  32      -2.343  -0.683   1.676  1.00  0.00           H  
ATOM    432  HB2 ASP A  32      -0.734   0.331   4.062  1.00  0.00           H  
ATOM    433  HB3 ASP A  32      -0.119  -0.175   2.537  1.00  0.00           H  
ATOM    434  N   PHE A  33      -2.334  -2.079   4.702  1.00  0.00           N  
ATOM    435  CA  PHE A  33      -2.176  -3.350   5.418  1.00  0.00           C  
ATOM    436  C   PHE A  33      -2.978  -4.506   4.839  1.00  0.00           C  
ATOM    437  O   PHE A  33      -2.664  -5.667   5.116  1.00  0.00           O  
ATOM    438  CB  PHE A  33      -2.522  -3.242   6.907  1.00  0.00           C  
ATOM    439  CG  PHE A  33      -1.535  -2.454   7.726  1.00  0.00           C  
ATOM    440  CD1 PHE A  33      -1.478  -1.060   7.603  1.00  0.00           C  
ATOM    441  CD2 PHE A  33      -0.700  -3.112   8.644  1.00  0.00           C  
ATOM    442  CE1 PHE A  33      -0.627  -0.314   8.426  1.00  0.00           C  
ATOM    443  CE2 PHE A  33       0.176  -2.370   9.447  1.00  0.00           C  
ATOM    444  CZ  PHE A  33       0.186  -0.968   9.360  1.00  0.00           C  
ATOM    445  H   PHE A  33      -2.631  -1.257   5.212  1.00  0.00           H  
ATOM    446  HA  PHE A  33      -1.135  -3.611   5.343  1.00  0.00           H  
ATOM    447  HB2 PHE A  33      -3.517  -2.825   7.036  1.00  0.00           H  
ATOM    448  HB3 PHE A  33      -2.567  -4.249   7.325  1.00  0.00           H  
ATOM    449  HD1 PHE A  33      -2.114  -0.552   6.902  1.00  0.00           H  
ATOM    450  HD2 PHE A  33      -0.765  -4.183   8.769  1.00  0.00           H  
ATOM    451  HE1 PHE A  33      -0.623   0.762   8.355  1.00  0.00           H  
ATOM    452  HE2 PHE A  33       0.812  -2.878  10.151  1.00  0.00           H  
ATOM    453  HZ  PHE A  33       0.789  -0.379  10.028  1.00  0.00           H  
ATOM    454  N   ARG A  34      -4.021  -4.218   4.069  1.00  0.00           N  
ATOM    455  CA  ARG A  34      -4.877  -5.240   3.477  1.00  0.00           C  
ATOM    456  C   ARG A  34      -4.459  -5.561   2.054  1.00  0.00           C  
ATOM    457  O   ARG A  34      -4.729  -6.662   1.578  1.00  0.00           O  
ATOM    458  CB  ARG A  34      -6.321  -4.755   3.563  1.00  0.00           C  
ATOM    459  CG  ARG A  34      -6.629  -4.378   5.022  1.00  0.00           C  
ATOM    460  CD  ARG A  34      -8.116  -4.387   5.291  1.00  0.00           C  
ATOM    461  NE  ARG A  34      -8.815  -3.300   4.605  1.00  0.00           N  
ATOM    462  CZ  ARG A  34      -9.966  -3.394   3.939  1.00  0.00           C  
ATOM    463  NH1 ARG A  34     -10.482  -4.561   3.573  1.00  0.00           N  
ATOM    464  NH2 ARG A  34     -10.606  -2.279   3.648  1.00  0.00           N  
ATOM    465  H   ARG A  34      -4.215  -3.240   3.883  1.00  0.00           H  
ATOM    466  HA  ARG A  34      -4.793  -6.163   4.053  1.00  0.00           H  
ATOM    467  HB2 ARG A  34      -6.473  -3.889   2.917  1.00  0.00           H  
ATOM    468  HB3 ARG A  34      -6.973  -5.562   3.232  1.00  0.00           H  
ATOM    469  HG2 ARG A  34      -6.164  -5.101   5.696  1.00  0.00           H  
ATOM    470  HG3 ARG A  34      -6.234  -3.389   5.251  1.00  0.00           H  
ATOM    471  HD2 ARG A  34      -8.497  -5.351   4.980  1.00  0.00           H  
ATOM    472  HD3 ARG A  34      -8.258  -4.267   6.360  1.00  0.00           H  
ATOM    473  HE  ARG A  34      -8.478  -2.362   4.820  1.00  0.00           H  
ATOM    474 HH11 ARG A  34      -9.944  -5.420   3.686  1.00  0.00           H  
ATOM    475 HH12 ARG A  34     -11.360  -4.623   3.078  1.00  0.00           H  
ATOM    476 HH21 ARG A  34     -10.228  -1.396   3.982  1.00  0.00           H  
ATOM    477 HH22 ARG A  34     -11.542  -2.288   3.234  1.00  0.00           H  
ATOM    478  N   GLN A  35      -3.782  -4.610   1.423  1.00  0.00           N  
ATOM    479  CA  GLN A  35      -3.262  -4.690   0.070  1.00  0.00           C  
ATOM    480  C   GLN A  35      -1.840  -5.250   0.063  1.00  0.00           C  
ATOM    481  O   GLN A  35      -1.617  -6.363  -0.402  1.00  0.00           O  
ATOM    482  CB  GLN A  35      -3.247  -3.303  -0.586  1.00  0.00           C  
ATOM    483  CG  GLN A  35      -4.644  -2.727  -0.774  1.00  0.00           C  
ATOM    484  CD  GLN A  35      -4.565  -1.405  -1.520  1.00  0.00           C  
ATOM    485  OE1 GLN A  35      -4.363  -1.377  -2.734  1.00  0.00           O  
ATOM    486  NE2 GLN A  35      -4.696  -0.292  -0.820  1.00  0.00           N  
ATOM    487  H   GLN A  35      -3.658  -3.764   1.963  1.00  0.00           H  
ATOM    488  HA  GLN A  35      -3.898  -5.352  -0.522  1.00  0.00           H  
ATOM    489  HB2 GLN A  35      -2.665  -2.605   0.018  1.00  0.00           H  
ATOM    490  HB3 GLN A  35      -2.773  -3.396  -1.562  1.00  0.00           H  
ATOM    491  HG2 GLN A  35      -5.246  -3.425  -1.349  1.00  0.00           H  
ATOM    492  HG3 GLN A  35      -5.095  -2.581   0.202  1.00  0.00           H  
ATOM    493 HE21 GLN A  35      -4.808  -0.330   0.181  1.00  0.00           H  
ATOM    494 HE22 GLN A  35      -4.552   0.585  -1.310  1.00  0.00           H  
ATOM    495  N   VAL A  36      -0.871  -4.476   0.554  1.00  0.00           N  
ATOM    496  CA  VAL A  36       0.537  -4.843   0.588  1.00  0.00           C  
ATOM    497  C   VAL A  36       0.837  -5.826   1.718  1.00  0.00           C  
ATOM    498  O   VAL A  36       1.685  -6.696   1.548  1.00  0.00           O  
ATOM    499  CB  VAL A  36       1.404  -3.560   0.619  1.00  0.00           C  
ATOM    500  CG1 VAL A  36       1.299  -2.747   1.907  1.00  0.00           C  
ATOM    501  CG2 VAL A  36       2.875  -3.862   0.309  1.00  0.00           C  
ATOM    502  H   VAL A  36      -1.125  -3.575   0.936  1.00  0.00           H  
ATOM    503  HA  VAL A  36       0.757  -5.356  -0.350  1.00  0.00           H  
ATOM    504  HB  VAL A  36       1.031  -2.884  -0.148  1.00  0.00           H  
ATOM    505 HG11 VAL A  36       1.310  -3.387   2.783  1.00  0.00           H  
ATOM    506 HG12 VAL A  36       2.123  -2.040   1.967  1.00  0.00           H  
ATOM    507 HG13 VAL A  36       0.377  -2.178   1.851  1.00  0.00           H  
ATOM    508 HG21 VAL A  36       3.422  -2.930   0.164  1.00  0.00           H  
ATOM    509 HG22 VAL A  36       3.331  -4.423   1.123  1.00  0.00           H  
ATOM    510 HG23 VAL A  36       2.942  -4.447  -0.608  1.00  0.00           H  
ATOM    511  N   GLY A  37       0.124  -5.757   2.846  1.00  0.00           N  
ATOM    512  CA  GLY A  37       0.350  -6.648   3.980  1.00  0.00           C  
ATOM    513  C   GLY A  37       1.109  -5.919   5.078  1.00  0.00           C  
ATOM    514  O   GLY A  37       0.769  -4.787   5.421  1.00  0.00           O  
ATOM    515  H   GLY A  37      -0.557  -5.012   2.923  1.00  0.00           H  
ATOM    516  HA2 GLY A  37      -0.606  -6.995   4.367  1.00  0.00           H  
ATOM    517  HA3 GLY A  37       0.921  -7.522   3.672  1.00  0.00           H  
ATOM    518  N   SER A  38       2.081  -6.555   5.718  1.00  0.00           N  
ATOM    519  CA  SER A  38       2.865  -5.939   6.783  1.00  0.00           C  
ATOM    520  C   SER A  38       4.282  -6.488   6.760  1.00  0.00           C  
ATOM    521  O   SER A  38       4.493  -7.558   6.182  1.00  0.00           O  
ATOM    522  CB  SER A  38       2.213  -6.235   8.137  1.00  0.00           C  
ATOM    523  OG  SER A  38       0.801  -6.094   8.110  1.00  0.00           O  
ATOM    524  H   SER A  38       2.372  -7.490   5.435  1.00  0.00           H  
ATOM    525  HA  SER A  38       2.931  -4.868   6.615  1.00  0.00           H  
ATOM    526  HB2 SER A  38       2.456  -7.260   8.419  1.00  0.00           H  
ATOM    527  HB3 SER A  38       2.611  -5.557   8.889  1.00  0.00           H  
ATOM    528  HG  SER A  38       0.570  -5.643   7.283  1.00  0.00           H  
ATOM    529  N   PRO A  39       5.254  -5.825   7.403  1.00  0.00           N  
ATOM    530  CA  PRO A  39       6.592  -6.343   7.392  1.00  0.00           C  
ATOM    531  C   PRO A  39       6.662  -7.622   8.199  1.00  0.00           C  
ATOM    532  O   PRO A  39       5.819  -7.974   9.031  1.00  0.00           O  
ATOM    533  CB  PRO A  39       7.498  -5.292   7.999  1.00  0.00           C  
ATOM    534  CG  PRO A  39       6.539  -4.522   8.907  1.00  0.00           C  
ATOM    535  CD  PRO A  39       5.213  -4.573   8.139  1.00  0.00           C  
ATOM    536  HA  PRO A  39       6.923  -6.536   6.364  1.00  0.00           H  
ATOM    537  HB2 PRO A  39       8.332  -5.814   8.513  1.00  0.00           H  
ATOM    538  HB3 PRO A  39       7.829  -4.635   7.193  1.00  0.00           H  
ATOM    539  HG2 PRO A  39       6.430  -5.051   9.853  1.00  0.00           H  
ATOM    540  HG3 PRO A  39       6.862  -3.496   9.064  1.00  0.00           H  
ATOM    541  HD2 PRO A  39       4.385  -4.539   8.840  1.00  0.00           H  
ATOM    542  HD3 PRO A  39       5.155  -3.737   7.441  1.00  0.00           H  
ATOM    543  N   ASN A  40       7.757  -8.280   7.909  1.00  0.00           N  
ATOM    544  CA  ASN A  40       8.278  -9.517   8.369  1.00  0.00           C  
ATOM    545  C   ASN A  40       9.687  -9.203   8.858  1.00  0.00           C  
ATOM    546  O   ASN A  40      10.633  -9.244   8.077  1.00  0.00           O  
ATOM    547  CB  ASN A  40       8.306 -10.405   7.122  1.00  0.00           C  
ATOM    548  CG  ASN A  40       8.768 -11.805   7.314  1.00  0.00           C  
ATOM    549  OD1 ASN A  40       8.258 -12.740   6.721  1.00  0.00           O  
ATOM    550  ND2 ASN A  40       9.833 -11.927   8.046  1.00  0.00           N  
ATOM    551  H   ASN A  40       8.346  -7.836   7.214  1.00  0.00           H  
ATOM    552  HA  ASN A  40       7.667  -9.946   9.156  1.00  0.00           H  
ATOM    553  HB2 ASN A  40       7.392 -10.407   6.574  1.00  0.00           H  
ATOM    554  HB3 ASN A  40       8.988  -9.968   6.446  1.00  0.00           H  
ATOM    555 HD21 ASN A  40      10.320 -11.050   8.281  1.00  0.00           H  
ATOM    556 HD22 ASN A  40      10.265 -12.817   7.959  1.00  0.00           H  
ATOM    557  N   ILE A  41       9.859  -8.900  10.132  1.00  0.00           N  
ATOM    558  CA  ILE A  41      11.178  -8.605  10.686  1.00  0.00           C  
ATOM    559  C   ILE A  41      11.586  -9.646  11.716  1.00  0.00           C  
ATOM    560  O   ILE A  41      12.782  -9.771  11.971  1.00  0.00           O  
ATOM    561  CB  ILE A  41      11.228  -7.187  11.285  1.00  0.00           C  
ATOM    562  CG1 ILE A  41      10.114  -6.987  12.342  1.00  0.00           C  
ATOM    563  CG2 ILE A  41      11.194  -6.140  10.160  1.00  0.00           C  
ATOM    564  CD1 ILE A  41      10.083  -5.591  12.950  1.00  0.00           C  
ATOM    565  H   ILE A  41       9.043  -8.882  10.737  1.00  0.00           H  
ATOM    566  HA  ILE A  41      11.935  -8.655   9.903  1.00  0.00           H  
ATOM    567  HB  ILE A  41      12.195  -7.091  11.779  1.00  0.00           H  
ATOM    568 HG12 ILE A  41       9.136  -7.163  11.897  1.00  0.00           H  
ATOM    569 HG13 ILE A  41      10.253  -7.702  13.153  1.00  0.00           H  
ATOM    570 HG21 ILE A  41      11.409  -5.149  10.557  1.00  0.00           H  
ATOM    571 HG22 ILE A  41      11.963  -6.372   9.425  1.00  0.00           H  
ATOM    572 HG23 ILE A  41      10.222  -6.144   9.673  1.00  0.00           H  
ATOM    573 HD11 ILE A  41       9.335  -5.573  13.738  1.00  0.00           H  
ATOM    574 HD12 ILE A  41      11.055  -5.325  13.364  1.00  0.00           H  
ATOM    575 HD13 ILE A  41       9.796  -4.875  12.187  1.00  0.00           H  
ATOM    576  N   LYS A  42      10.631 -10.399  12.275  1.00  0.00           N  
ATOM    577  CA  LYS A  42      10.841 -11.420  13.310  1.00  0.00           C  
ATOM    578  C   LYS A  42      12.041 -12.336  13.094  1.00  0.00           C  
ATOM    579  O   LYS A  42      12.553 -12.821  14.104  1.00  0.00           O  
ATOM    580  CB  LYS A  42       9.584 -12.270  13.495  1.00  0.00           C  
ATOM    581  CG  LYS A  42       8.446 -11.535  14.214  1.00  0.00           C  
ATOM    582  CD  LYS A  42       7.107 -12.259  14.003  1.00  0.00           C  
ATOM    583  CE  LYS A  42       6.979 -13.552  14.812  1.00  0.00           C  
ATOM    584  NZ  LYS A  42       6.868 -13.292  16.265  1.00  0.00           N  
ATOM    585  H   LYS A  42       9.685 -10.197  11.977  1.00  0.00           H  
ATOM    586  HA  LYS A  42      11.027 -10.885  14.241  1.00  0.00           H  
ATOM    587  HB2 LYS A  42       9.267 -12.571  12.504  1.00  0.00           H  
ATOM    588  HB3 LYS A  42       9.827 -13.167  14.068  1.00  0.00           H  
ATOM    589  HG2 LYS A  42       8.671 -11.457  15.278  1.00  0.00           H  
ATOM    590  HG3 LYS A  42       8.359 -10.523  13.823  1.00  0.00           H  
ATOM    591  HD2 LYS A  42       6.296 -11.595  14.284  1.00  0.00           H  
ATOM    592  HD3 LYS A  42       6.984 -12.494  12.944  1.00  0.00           H  
ATOM    593  HE2 LYS A  42       6.083 -14.079  14.478  1.00  0.00           H  
ATOM    594  HE3 LYS A  42       7.836 -14.199  14.613  1.00  0.00           H  
ATOM    595  HZ1 LYS A  42       7.718 -12.897  16.652  1.00  0.00           H  
ATOM    596  HZ2 LYS A  42       6.716 -14.167  16.756  1.00  0.00           H  
ATOM    597  HZ3 LYS A  42       6.082 -12.687  16.486  1.00  0.00           H  
ATOM    598  N   GLY A  43      12.494 -12.565  11.854  1.00  0.00           N  
ATOM    599  CA  GLY A  43      13.656 -13.397  11.569  1.00  0.00           C  
ATOM    600  C   GLY A  43      14.861 -12.917  12.375  1.00  0.00           C  
ATOM    601  O   GLY A  43      15.738 -13.724  12.668  1.00  0.00           O  
ATOM    602  H   GLY A  43      12.051 -12.143  11.047  1.00  0.00           H  
ATOM    603  HA2 GLY A  43      13.441 -14.428  11.841  1.00  0.00           H  
ATOM    604  HA3 GLY A  43      13.890 -13.351  10.506  1.00  0.00           H  
ATOM    605  N   LEU A  44      14.919 -11.620  12.706  1.00  0.00           N  
ATOM    606  CA  LEU A  44      15.974 -11.024  13.511  1.00  0.00           C  
ATOM    607  C   LEU A  44      15.539 -11.301  14.960  1.00  0.00           C  
ATOM    608  O   LEU A  44      16.094 -12.190  15.608  1.00  0.00           O  
ATOM    609  CB  LEU A  44      16.166  -9.521  13.211  1.00  0.00           C  
ATOM    610  CG  LEU A  44      16.246  -9.132  11.720  1.00  0.00           C  
ATOM    611  CD1 LEU A  44      16.089  -7.613  11.589  1.00  0.00           C  
ATOM    612  CD2 LEU A  44      17.550  -9.599  11.073  1.00  0.00           C  
ATOM    613  H   LEU A  44      14.151 -11.025  12.419  1.00  0.00           H  
ATOM    614  HA  LEU A  44      16.914 -11.544  13.315  1.00  0.00           H  
ATOM    615  HB2 LEU A  44      15.350  -8.962  13.650  1.00  0.00           H  
ATOM    616  HB3 LEU A  44      17.075  -9.188  13.716  1.00  0.00           H  
ATOM    617  HG  LEU A  44      15.417  -9.582  11.175  1.00  0.00           H  
ATOM    618 HD11 LEU A  44      15.101  -7.318  11.944  1.00  0.00           H  
ATOM    619 HD12 LEU A  44      16.192  -7.314  10.546  1.00  0.00           H  
ATOM    620 HD13 LEU A  44      16.846  -7.110  12.183  1.00  0.00           H  
ATOM    621 HD21 LEU A  44      17.600 -10.688  11.099  1.00  0.00           H  
ATOM    622 HD22 LEU A  44      18.409  -9.194  11.607  1.00  0.00           H  
ATOM    623 HD23 LEU A  44      17.593  -9.277  10.034  1.00  0.00           H  
ATOM    624  N   GLY A  45      14.490 -10.621  15.457  1.00  0.00           N  
ATOM    625  CA  GLY A  45      13.985 -10.821  16.818  1.00  0.00           C  
ATOM    626  C   GLY A  45      13.169  -9.658  17.387  1.00  0.00           C  
ATOM    627  O   GLY A  45      13.215  -9.438  18.597  1.00  0.00           O  
ATOM    628  H   GLY A  45      14.068  -9.898  14.890  1.00  0.00           H  
ATOM    629  HA2 GLY A  45      13.361 -11.710  16.832  1.00  0.00           H  
ATOM    630  HA3 GLY A  45      14.831 -10.997  17.486  1.00  0.00           H  
ATOM    631  N   LYS A  46      12.423  -8.903  16.574  1.00  0.00           N  
ATOM    632  CA  LYS A  46      11.618  -7.741  16.984  1.00  0.00           C  
ATOM    633  C   LYS A  46      10.164  -7.899  16.503  1.00  0.00           C  
ATOM    634  O   LYS A  46       9.847  -8.892  15.841  1.00  0.00           O  
ATOM    635  CB  LYS A  46      12.259  -6.455  16.412  1.00  0.00           C  
ATOM    636  CG  LYS A  46      13.795  -6.266  16.500  1.00  0.00           C  
ATOM    637  CD  LYS A  46      14.413  -6.321  17.902  1.00  0.00           C  
ATOM    638  CE  LYS A  46      15.756  -5.575  17.996  1.00  0.00           C  
ATOM    639  NZ  LYS A  46      16.824  -6.081  17.103  1.00  0.00           N  
ATOM    640  H   LYS A  46      12.396  -9.114  15.574  1.00  0.00           H  
ATOM    641  HA  LYS A  46      11.608  -7.676  18.070  1.00  0.00           H  
ATOM    642  HB2 LYS A  46      11.970  -6.403  15.361  1.00  0.00           H  
ATOM    643  HB3 LYS A  46      11.807  -5.596  16.893  1.00  0.00           H  
ATOM    644  HG2 LYS A  46      14.302  -7.005  15.882  1.00  0.00           H  
ATOM    645  HG3 LYS A  46      14.012  -5.284  16.077  1.00  0.00           H  
ATOM    646  HD2 LYS A  46      13.722  -5.864  18.611  1.00  0.00           H  
ATOM    647  HD3 LYS A  46      14.568  -7.357  18.199  1.00  0.00           H  
ATOM    648  HE2 LYS A  46      15.593  -4.521  17.775  1.00  0.00           H  
ATOM    649  HE3 LYS A  46      16.101  -5.647  19.027  1.00  0.00           H  
ATOM    650  HZ1 LYS A  46      16.618  -5.932  16.122  1.00  0.00           H  
ATOM    651  HZ2 LYS A  46      16.984  -7.081  17.221  1.00  0.00           H  
ATOM    652  HZ3 LYS A  46      17.687  -5.567  17.261  1.00  0.00           H  
ATOM    653  N   LYS A  47       9.267  -6.952  16.826  1.00  0.00           N  
ATOM    654  CA  LYS A  47       7.849  -6.976  16.426  1.00  0.00           C  
ATOM    655  C   LYS A  47       7.438  -5.618  15.873  1.00  0.00           C  
ATOM    656  O   LYS A  47       7.786  -4.588  16.455  1.00  0.00           O  
ATOM    657  CB  LYS A  47       6.932  -7.397  17.593  1.00  0.00           C  
ATOM    658  CG  LYS A  47       6.876  -6.420  18.786  1.00  0.00           C  
ATOM    659  CD  LYS A  47       5.839  -6.739  19.875  1.00  0.00           C  
ATOM    660  CE  LYS A  47       6.246  -7.810  20.894  1.00  0.00           C  
ATOM    661  NZ  LYS A  47       6.414  -9.149  20.305  1.00  0.00           N  
ATOM    662  H   LYS A  47       9.567  -6.149  17.366  1.00  0.00           H  
ATOM    663  HA  LYS A  47       7.731  -7.720  15.636  1.00  0.00           H  
ATOM    664  HB2 LYS A  47       5.923  -7.502  17.194  1.00  0.00           H  
ATOM    665  HB3 LYS A  47       7.260  -8.372  17.937  1.00  0.00           H  
ATOM    666  HG2 LYS A  47       7.866  -6.337  19.232  1.00  0.00           H  
ATOM    667  HG3 LYS A  47       6.584  -5.447  18.406  1.00  0.00           H  
ATOM    668  HD2 LYS A  47       5.677  -5.820  20.440  1.00  0.00           H  
ATOM    669  HD3 LYS A  47       4.886  -6.997  19.416  1.00  0.00           H  
ATOM    670  HE2 LYS A  47       7.180  -7.513  21.370  1.00  0.00           H  
ATOM    671  HE3 LYS A  47       5.475  -7.863  21.660  1.00  0.00           H  
ATOM    672  HZ1 LYS A  47       6.442  -9.854  21.034  1.00  0.00           H  
ATOM    673  HZ2 LYS A  47       7.314  -9.197  19.828  1.00  0.00           H  
ATOM    674  HZ3 LYS A  47       5.665  -9.372  19.658  1.00  0.00           H  
ATOM    675  N   ALA A  48       6.742  -5.571  14.739  1.00  0.00           N  
ATOM    676  CA  ALA A  48       6.322  -4.290  14.183  1.00  0.00           C  
ATOM    677  C   ALA A  48       5.229  -3.662  15.055  1.00  0.00           C  
ATOM    678  O   ALA A  48       4.628  -4.318  15.908  1.00  0.00           O  
ATOM    679  CB  ALA A  48       5.805  -4.479  12.756  1.00  0.00           C  
ATOM    680  H   ALA A  48       6.454  -6.416  14.266  1.00  0.00           H  
ATOM    681  HA  ALA A  48       7.183  -3.620  14.151  1.00  0.00           H  
ATOM    682  HB1 ALA A  48       5.537  -3.511  12.329  1.00  0.00           H  
ATOM    683  HB2 ALA A  48       6.577  -4.943  12.143  1.00  0.00           H  
ATOM    684  HB3 ALA A  48       4.917  -5.109  12.773  1.00  0.00           H  
ATOM    685  N   VAL A  49       4.947  -2.387  14.808  1.00  0.00           N  
ATOM    686  CA  VAL A  49       3.936  -1.585  15.480  1.00  0.00           C  
ATOM    687  C   VAL A  49       3.220  -0.870  14.343  1.00  0.00           C  
ATOM    688  O   VAL A  49       3.882  -0.347  13.454  1.00  0.00           O  
ATOM    689  CB  VAL A  49       4.586  -0.602  16.475  1.00  0.00           C  
ATOM    690  CG1 VAL A  49       3.540   0.281  17.183  1.00  0.00           C  
ATOM    691  CG2 VAL A  49       5.395  -1.358  17.537  1.00  0.00           C  
ATOM    692  H   VAL A  49       5.477  -1.895  14.096  1.00  0.00           H  
ATOM    693  HA  VAL A  49       3.233  -2.231  16.006  1.00  0.00           H  
ATOM    694  HB  VAL A  49       5.273   0.050  15.934  1.00  0.00           H  
ATOM    695 HG11 VAL A  49       3.000   0.889  16.458  1.00  0.00           H  
ATOM    696 HG12 VAL A  49       2.820  -0.328  17.724  1.00  0.00           H  
ATOM    697 HG13 VAL A  49       4.028   0.962  17.881  1.00  0.00           H  
ATOM    698 HG21 VAL A  49       4.762  -2.077  18.057  1.00  0.00           H  
ATOM    699 HG22 VAL A  49       6.231  -1.877  17.070  1.00  0.00           H  
ATOM    700 HG23 VAL A  49       5.804  -0.646  18.245  1.00  0.00           H  
ATOM    701  N   SER A  50       1.896  -0.835  14.357  1.00  0.00           N  
ATOM    702  CA  SER A  50       1.076  -0.196  13.339  1.00  0.00           C  
ATOM    703  C   SER A  50       0.326   0.973  13.957  1.00  0.00           C  
ATOM    704  O   SER A  50      -0.447   0.757  14.890  1.00  0.00           O  
ATOM    705  CB  SER A  50       0.147  -1.253  12.733  1.00  0.00           C  
ATOM    706  OG  SER A  50      -0.325  -2.192  13.693  1.00  0.00           O  
ATOM    707  H   SER A  50       1.376  -1.280  15.097  1.00  0.00           H  
ATOM    708  HA  SER A  50       1.701   0.198  12.540  1.00  0.00           H  
ATOM    709  HB2 SER A  50      -0.692  -0.774  12.226  1.00  0.00           H  
ATOM    710  HB3 SER A  50       0.731  -1.807  12.004  1.00  0.00           H  
ATOM    711  HG  SER A  50      -0.196  -3.079  13.295  1.00  0.00           H  
ATOM    712  N   THR A  51       0.608   2.199  13.510  1.00  0.00           N  
ATOM    713  CA  THR A  51      -0.054   3.400  14.009  1.00  0.00           C  
ATOM    714  C   THR A  51      -0.182   4.370  12.829  1.00  0.00           C  
ATOM    715  O   THR A  51       0.833   4.895  12.384  1.00  0.00           O  
ATOM    716  CB  THR A  51       0.733   4.009  15.193  1.00  0.00           C  
ATOM    717  OG1 THR A  51       1.390   3.027  15.979  1.00  0.00           O  
ATOM    718  CG2 THR A  51      -0.197   4.782  16.126  1.00  0.00           C  
ATOM    719  H   THR A  51       1.258   2.321  12.736  1.00  0.00           H  
ATOM    720  HA  THR A  51      -1.053   3.129  14.348  1.00  0.00           H  
ATOM    721  HB  THR A  51       1.499   4.682  14.813  1.00  0.00           H  
ATOM    722  HG1 THR A  51       2.071   2.648  15.413  1.00  0.00           H  
ATOM    723 HG21 THR A  51      -0.776   5.509  15.556  1.00  0.00           H  
ATOM    724 HG22 THR A  51       0.397   5.308  16.876  1.00  0.00           H  
ATOM    725 HG23 THR A  51      -0.879   4.088  16.617  1.00  0.00           H  
ATOM    726  N   VAL A  52      -1.378   4.591  12.279  1.00  0.00           N  
ATOM    727  CA  VAL A  52      -1.567   5.492  11.142  1.00  0.00           C  
ATOM    728  C   VAL A  52      -1.251   6.934  11.553  1.00  0.00           C  
ATOM    729  O   VAL A  52      -1.967   7.528  12.368  1.00  0.00           O  
ATOM    730  CB  VAL A  52      -2.996   5.386  10.560  1.00  0.00           C  
ATOM    731  CG1 VAL A  52      -3.098   6.176   9.251  1.00  0.00           C  
ATOM    732  CG2 VAL A  52      -3.469   3.948  10.312  1.00  0.00           C  
ATOM    733  H   VAL A  52      -2.198   4.141  12.670  1.00  0.00           H  
ATOM    734  HA  VAL A  52      -0.857   5.195  10.367  1.00  0.00           H  
ATOM    735  HB  VAL A  52      -3.698   5.828  11.259  1.00  0.00           H  
ATOM    736 HG11 VAL A  52      -2.349   5.829   8.542  1.00  0.00           H  
ATOM    737 HG12 VAL A  52      -4.094   6.063   8.822  1.00  0.00           H  
ATOM    738 HG13 VAL A  52      -2.939   7.237   9.449  1.00  0.00           H  
ATOM    739 HG21 VAL A  52      -2.792   3.434   9.636  1.00  0.00           H  
ATOM    740 HG22 VAL A  52      -3.526   3.405  11.254  1.00  0.00           H  
ATOM    741 HG23 VAL A  52      -4.469   3.966   9.876  1.00  0.00           H  
ATOM    742  N   TYR A  53      -0.163   7.493  11.021  1.00  0.00           N  
ATOM    743  CA  TYR A  53       0.217   8.869  11.309  1.00  0.00           C  
ATOM    744  C   TYR A  53      -0.722   9.825  10.554  1.00  0.00           C  
ATOM    745  O   TYR A  53      -1.312   9.475   9.525  1.00  0.00           O  
ATOM    746  CB  TYR A  53       1.672   9.111  10.874  1.00  0.00           C  
ATOM    747  CG  TYR A  53       2.100  10.555  11.032  1.00  0.00           C  
ATOM    748  CD1 TYR A  53       2.339  11.070  12.317  1.00  0.00           C  
ATOM    749  CD2 TYR A  53       2.134  11.413   9.914  1.00  0.00           C  
ATOM    750  CE1 TYR A  53       2.602  12.439  12.493  1.00  0.00           C  
ATOM    751  CE2 TYR A  53       2.397  12.784  10.084  1.00  0.00           C  
ATOM    752  CZ  TYR A  53       2.631  13.304  11.377  1.00  0.00           C  
ATOM    753  OH  TYR A  53       2.863  14.632  11.558  1.00  0.00           O  
ATOM    754  H   TYR A  53       0.399   6.966  10.363  1.00  0.00           H  
ATOM    755  HA  TYR A  53       0.135   9.051  12.382  1.00  0.00           H  
ATOM    756  HB2 TYR A  53       2.334   8.485  11.472  1.00  0.00           H  
ATOM    757  HB3 TYR A  53       1.780   8.825   9.825  1.00  0.00           H  
ATOM    758  HD1 TYR A  53       2.314  10.417  13.177  1.00  0.00           H  
ATOM    759  HD2 TYR A  53       1.929  11.030   8.923  1.00  0.00           H  
ATOM    760  HE1 TYR A  53       2.786  12.824  13.481  1.00  0.00           H  
ATOM    761  HE2 TYR A  53       2.406  13.440   9.227  1.00  0.00           H  
ATOM    762  HH  TYR A  53       2.958  15.124  10.734  1.00  0.00           H  
ATOM    763  N   ASN A  54      -0.878  11.044  11.062  1.00  0.00           N  
ATOM    764  CA  ASN A  54      -1.677  12.129  10.503  1.00  0.00           C  
ATOM    765  C   ASN A  54      -1.221  13.377  11.246  1.00  0.00           C  
ATOM    766  O   ASN A  54      -1.065  13.313  12.467  1.00  0.00           O  
ATOM    767  CB  ASN A  54      -3.191  11.924  10.713  1.00  0.00           C  
ATOM    768  CG  ASN A  54      -4.031  13.029  10.064  1.00  0.00           C  
ATOM    769  OD1 ASN A  54      -3.520  14.010   9.539  1.00  0.00           O  
ATOM    770  ND2 ASN A  54      -5.341  12.911  10.095  1.00  0.00           N  
ATOM    771  H   ASN A  54      -0.375  11.294  11.907  1.00  0.00           H  
ATOM    772  HA  ASN A  54      -1.468  12.228   9.436  1.00  0.00           H  
ATOM    773  HB2 ASN A  54      -3.486  10.969  10.282  1.00  0.00           H  
ATOM    774  HB3 ASN A  54      -3.409  11.901  11.779  1.00  0.00           H  
ATOM    775 HD21 ASN A  54      -5.817  12.175  10.598  1.00  0.00           H  
ATOM    776 HD22 ASN A  54      -5.893  13.628   9.638  1.00  0.00           H  
ATOM    777  N   GLY A  55      -0.980  14.487  10.548  1.00  0.00           N  
ATOM    778  CA  GLY A  55      -0.566  15.729  11.177  1.00  0.00           C  
ATOM    779  C   GLY A  55      -1.621  16.181  12.189  1.00  0.00           C  
ATOM    780  O   GLY A  55      -1.276  16.721  13.241  1.00  0.00           O  
ATOM    781  H   GLY A  55      -1.136  14.481   9.546  1.00  0.00           H  
ATOM    782  HA2 GLY A  55       0.383  15.578  11.687  1.00  0.00           H  
ATOM    783  HA3 GLY A  55      -0.436  16.489  10.411  1.00  0.00           H  
ATOM    784  N   GLU A  56      -2.910  15.941  11.917  1.00  0.00           N  
ATOM    785  CA  GLU A  56      -3.985  16.322  12.833  1.00  0.00           C  
ATOM    786  C   GLU A  56      -3.922  15.506  14.128  1.00  0.00           C  
ATOM    787  O   GLU A  56      -4.352  15.981  15.180  1.00  0.00           O  
ATOM    788  CB  GLU A  56      -5.368  16.081  12.194  1.00  0.00           C  
ATOM    789  CG  GLU A  56      -5.669  16.952  10.970  1.00  0.00           C  
ATOM    790  CD  GLU A  56      -5.471  18.428  11.286  1.00  0.00           C  
ATOM    791  OE1 GLU A  56      -6.368  19.030  11.920  1.00  0.00           O  
ATOM    792  OE2 GLU A  56      -4.371  18.940  10.978  1.00  0.00           O  
ATOM    793  H   GLU A  56      -3.161  15.491  11.041  1.00  0.00           H  
ATOM    794  HA  GLU A  56      -3.882  17.378  13.089  1.00  0.00           H  
ATOM    795  HB2 GLU A  56      -5.456  15.032  11.911  1.00  0.00           H  
ATOM    796  HB3 GLU A  56      -6.131  16.287  12.945  1.00  0.00           H  
ATOM    797  HG2 GLU A  56      -5.017  16.660  10.146  1.00  0.00           H  
ATOM    798  HG3 GLU A  56      -6.704  16.793  10.667  1.00  0.00           H  
ATOM    799  N   ASP A  57      -3.331  14.312  14.083  1.00  0.00           N  
ATOM    800  CA  ASP A  57      -3.216  13.380  15.199  1.00  0.00           C  
ATOM    801  C   ASP A  57      -1.816  13.308  15.813  1.00  0.00           C  
ATOM    802  O   ASP A  57      -1.565  12.366  16.547  1.00  0.00           O  
ATOM    803  CB  ASP A  57      -3.676  11.994  14.702  1.00  0.00           C  
ATOM    804  CG  ASP A  57      -3.958  10.979  15.818  1.00  0.00           C  
ATOM    805  OD1 ASP A  57      -4.561  11.339  16.853  1.00  0.00           O  
ATOM    806  OD2 ASP A  57      -3.704   9.769  15.612  1.00  0.00           O  
ATOM    807  H   ASP A  57      -2.988  13.980  13.192  1.00  0.00           H  
ATOM    808  HA  ASP A  57      -3.901  13.689  15.988  1.00  0.00           H  
ATOM    809  HB2 ASP A  57      -4.594  12.113  14.122  1.00  0.00           H  
ATOM    810  HB3 ASP A  57      -2.911  11.588  14.039  1.00  0.00           H  
ATOM    811  N   LYS A  58      -0.889  14.249  15.559  1.00  0.00           N  
ATOM    812  CA  LYS A  58       0.483  14.220  16.117  1.00  0.00           C  
ATOM    813  C   LYS A  58       0.510  13.741  17.580  1.00  0.00           C  
ATOM    814  O   LYS A  58       1.095  12.691  17.856  1.00  0.00           O  
ATOM    815  CB  LYS A  58       1.228  15.567  15.940  1.00  0.00           C  
ATOM    816  CG  LYS A  58       1.854  15.731  14.551  1.00  0.00           C  
ATOM    817  CD  LYS A  58       2.833  16.910  14.408  1.00  0.00           C  
ATOM    818  CE  LYS A  58       2.230  18.323  14.400  1.00  0.00           C  
ATOM    819  NZ  LYS A  58       2.046  18.904  15.748  1.00  0.00           N  
ATOM    820  H   LYS A  58      -1.152  15.012  14.955  1.00  0.00           H  
ATOM    821  HA  LYS A  58       1.031  13.463  15.554  1.00  0.00           H  
ATOM    822  HB2 LYS A  58       0.552  16.397  16.123  1.00  0.00           H  
ATOM    823  HB3 LYS A  58       2.036  15.612  16.674  1.00  0.00           H  
ATOM    824  HG2 LYS A  58       2.422  14.828  14.339  1.00  0.00           H  
ATOM    825  HG3 LYS A  58       1.069  15.819  13.805  1.00  0.00           H  
ATOM    826  HD2 LYS A  58       3.602  16.849  15.176  1.00  0.00           H  
ATOM    827  HD3 LYS A  58       3.338  16.785  13.447  1.00  0.00           H  
ATOM    828  HE2 LYS A  58       2.936  18.961  13.867  1.00  0.00           H  
ATOM    829  HE3 LYS A  58       1.290  18.330  13.846  1.00  0.00           H  
ATOM    830  HZ1 LYS A  58       1.853  19.898  15.692  1.00  0.00           H  
ATOM    831  HZ2 LYS A  58       2.884  18.789  16.311  1.00  0.00           H  
ATOM    832  HZ3 LYS A  58       1.254  18.507  16.242  1.00  0.00           H  
ATOM    833  N   PRO A  59      -0.167  14.427  18.516  1.00  0.00           N  
ATOM    834  CA  PRO A  59      -0.205  14.048  19.924  1.00  0.00           C  
ATOM    835  C   PRO A  59      -0.883  12.689  20.153  1.00  0.00           C  
ATOM    836  O   PRO A  59      -0.361  11.850  20.893  1.00  0.00           O  
ATOM    837  CB  PRO A  59      -0.977  15.184  20.615  1.00  0.00           C  
ATOM    838  CG  PRO A  59      -1.835  15.772  19.495  1.00  0.00           C  
ATOM    839  CD  PRO A  59      -0.890  15.671  18.322  1.00  0.00           C  
ATOM    840  HA  PRO A  59       0.809  14.007  20.323  1.00  0.00           H  
ATOM    841  HB2 PRO A  59      -1.603  14.817  21.425  1.00  0.00           H  
ATOM    842  HB3 PRO A  59      -0.277  15.937  20.979  1.00  0.00           H  
ATOM    843  HG2 PRO A  59      -2.720  15.156  19.323  1.00  0.00           H  
ATOM    844  HG3 PRO A  59      -2.107  16.810  19.637  1.00  0.00           H  
ATOM    845  HD2 PRO A  59      -1.464  15.714  17.400  1.00  0.00           H  
ATOM    846  HD3 PRO A  59      -0.177  16.493  18.367  1.00  0.00           H  
ATOM    847  N   GLY A  60      -2.055  12.468  19.548  1.00  0.00           N  
ATOM    848  CA  GLY A  60      -2.822  11.237  19.691  1.00  0.00           C  
ATOM    849  C   GLY A  60      -2.113  10.016  19.118  1.00  0.00           C  
ATOM    850  O   GLY A  60      -2.383   8.891  19.537  1.00  0.00           O  
ATOM    851  H   GLY A  60      -2.440  13.182  18.947  1.00  0.00           H  
ATOM    852  HA2 GLY A  60      -2.982  11.063  20.753  1.00  0.00           H  
ATOM    853  HA3 GLY A  60      -3.785  11.364  19.202  1.00  0.00           H  
ATOM    854  N   PHE A  61      -1.186  10.213  18.193  1.00  0.00           N  
ATOM    855  CA  PHE A  61      -0.387   9.190  17.557  1.00  0.00           C  
ATOM    856  C   PHE A  61       0.787   8.879  18.487  1.00  0.00           C  
ATOM    857  O   PHE A  61       1.009   7.719  18.830  1.00  0.00           O  
ATOM    858  CB  PHE A  61       0.080   9.732  16.198  1.00  0.00           C  
ATOM    859  CG  PHE A  61       1.289   9.054  15.602  1.00  0.00           C  
ATOM    860  CD1 PHE A  61       1.140   7.887  14.837  1.00  0.00           C  
ATOM    861  CD2 PHE A  61       2.563   9.622  15.786  1.00  0.00           C  
ATOM    862  CE1 PHE A  61       2.268   7.315  14.223  1.00  0.00           C  
ATOM    863  CE2 PHE A  61       3.689   9.035  15.190  1.00  0.00           C  
ATOM    864  CZ  PHE A  61       3.538   7.888  14.395  1.00  0.00           C  
ATOM    865  H   PHE A  61      -1.024  11.166  17.886  1.00  0.00           H  
ATOM    866  HA  PHE A  61      -0.973   8.287  17.399  1.00  0.00           H  
ATOM    867  HB2 PHE A  61      -0.751   9.674  15.492  1.00  0.00           H  
ATOM    868  HB3 PHE A  61       0.337  10.783  16.299  1.00  0.00           H  
ATOM    869  HD1 PHE A  61       0.157   7.451  14.717  1.00  0.00           H  
ATOM    870  HD2 PHE A  61       2.677  10.519  16.376  1.00  0.00           H  
ATOM    871  HE1 PHE A  61       2.171   6.440  13.606  1.00  0.00           H  
ATOM    872  HE2 PHE A  61       4.671   9.465  15.330  1.00  0.00           H  
ATOM    873  HZ  PHE A  61       4.402   7.450  13.917  1.00  0.00           H  
ATOM    874  N   LEU A  62       1.493   9.922  18.942  1.00  0.00           N  
ATOM    875  CA  LEU A  62       2.660   9.840  19.817  1.00  0.00           C  
ATOM    876  C   LEU A  62       2.402   9.016  21.072  1.00  0.00           C  
ATOM    877  O   LEU A  62       3.189   8.118  21.389  1.00  0.00           O  
ATOM    878  CB  LEU A  62       3.145  11.250  20.188  1.00  0.00           C  
ATOM    879  CG  LEU A  62       4.031  11.892  19.104  1.00  0.00           C  
ATOM    880  CD1 LEU A  62       4.056  13.408  19.290  1.00  0.00           C  
ATOM    881  CD2 LEU A  62       5.462  11.339  19.163  1.00  0.00           C  
ATOM    882  H   LEU A  62       1.227  10.845  18.609  1.00  0.00           H  
ATOM    883  HA  LEU A  62       3.445   9.336  19.259  1.00  0.00           H  
ATOM    884  HB2 LEU A  62       2.277  11.880  20.384  1.00  0.00           H  
ATOM    885  HB3 LEU A  62       3.717  11.200  21.116  1.00  0.00           H  
ATOM    886  HG  LEU A  62       3.619  11.682  18.120  1.00  0.00           H  
ATOM    887 HD11 LEU A  62       4.389  13.646  20.297  1.00  0.00           H  
ATOM    888 HD12 LEU A  62       3.057  13.821  19.159  1.00  0.00           H  
ATOM    889 HD13 LEU A  62       4.720  13.867  18.561  1.00  0.00           H  
ATOM    890 HD21 LEU A  62       5.885  11.494  20.156  1.00  0.00           H  
ATOM    891 HD22 LEU A  62       6.087  11.846  18.430  1.00  0.00           H  
ATOM    892 HD23 LEU A  62       5.465  10.277  18.931  1.00  0.00           H  
ATOM    893  N   LYS A  63       1.284   9.270  21.759  1.00  0.00           N  
ATOM    894  CA  LYS A  63       0.942   8.549  22.985  1.00  0.00           C  
ATOM    895  C   LYS A  63       0.989   7.035  22.792  1.00  0.00           C  
ATOM    896  O   LYS A  63       1.558   6.338  23.629  1.00  0.00           O  
ATOM    897  CB  LYS A  63      -0.405   9.035  23.550  1.00  0.00           C  
ATOM    898  CG  LYS A  63      -1.639   8.517  22.794  1.00  0.00           C  
ATOM    899  CD  LYS A  63      -2.890   9.332  23.130  1.00  0.00           C  
ATOM    900  CE  LYS A  63      -4.114   8.863  22.335  1.00  0.00           C  
ATOM    901  NZ  LYS A  63      -5.297   9.710  22.597  1.00  0.00           N  
ATOM    902  H   LYS A  63       0.689  10.029  21.442  1.00  0.00           H  
ATOM    903  HA  LYS A  63       1.707   8.808  23.719  1.00  0.00           H  
ATOM    904  HB2 LYS A  63      -0.477   8.722  24.592  1.00  0.00           H  
ATOM    905  HB3 LYS A  63      -0.409  10.126  23.526  1.00  0.00           H  
ATOM    906  HG2 LYS A  63      -1.444   8.599  21.732  1.00  0.00           H  
ATOM    907  HG3 LYS A  63      -1.811   7.469  23.042  1.00  0.00           H  
ATOM    908  HD2 LYS A  63      -3.093   9.255  24.198  1.00  0.00           H  
ATOM    909  HD3 LYS A  63      -2.686  10.368  22.873  1.00  0.00           H  
ATOM    910  HE2 LYS A  63      -3.881   8.905  21.272  1.00  0.00           H  
ATOM    911  HE3 LYS A  63      -4.343   7.828  22.599  1.00  0.00           H  
ATOM    912  HZ1 LYS A  63      -5.073  10.695  22.493  1.00  0.00           H  
ATOM    913  HZ2 LYS A  63      -5.659   9.546  23.532  1.00  0.00           H  
ATOM    914  HZ3 LYS A  63      -6.029   9.500  21.922  1.00  0.00           H  
ATOM    915  N   LYS A  64       0.451   6.526  21.676  1.00  0.00           N  
ATOM    916  CA  LYS A  64       0.395   5.097  21.352  1.00  0.00           C  
ATOM    917  C   LYS A  64       1.760   4.424  21.306  1.00  0.00           C  
ATOM    918  O   LYS A  64       1.867   3.213  21.486  1.00  0.00           O  
ATOM    919  CB  LYS A  64      -0.440   4.854  20.090  1.00  0.00           C  
ATOM    920  CG  LYS A  64      -1.869   5.369  20.334  1.00  0.00           C  
ATOM    921  CD  LYS A  64      -2.916   4.742  19.414  1.00  0.00           C  
ATOM    922  CE  LYS A  64      -2.990   5.485  18.086  1.00  0.00           C  
ATOM    923  NZ  LYS A  64      -3.646   6.807  18.222  1.00  0.00           N  
ATOM    924  H   LYS A  64       0.011   7.173  21.038  1.00  0.00           H  
ATOM    925  HA  LYS A  64      -0.140   4.604  22.150  1.00  0.00           H  
ATOM    926  HB2 LYS A  64       0.007   5.350  19.229  1.00  0.00           H  
ATOM    927  HB3 LYS A  64      -0.464   3.783  19.899  1.00  0.00           H  
ATOM    928  HG2 LYS A  64      -2.162   5.136  21.356  1.00  0.00           H  
ATOM    929  HG3 LYS A  64      -1.867   6.452  20.210  1.00  0.00           H  
ATOM    930  HD2 LYS A  64      -2.672   3.693  19.234  1.00  0.00           H  
ATOM    931  HD3 LYS A  64      -3.892   4.777  19.902  1.00  0.00           H  
ATOM    932  HE2 LYS A  64      -1.978   5.602  17.693  1.00  0.00           H  
ATOM    933  HE3 LYS A  64      -3.560   4.874  17.386  1.00  0.00           H  
ATOM    934  HZ1 LYS A  64      -3.082   7.467  18.746  1.00  0.00           H  
ATOM    935  HZ2 LYS A  64      -4.535   6.734  18.714  1.00  0.00           H  
ATOM    936  HZ3 LYS A  64      -3.850   7.215  17.318  1.00  0.00           H  
ATOM    937  N   LEU A  65       2.819   5.195  21.104  1.00  0.00           N  
ATOM    938  CA  LEU A  65       4.176   4.690  21.053  1.00  0.00           C  
ATOM    939  C   LEU A  65       4.708   4.643  22.477  1.00  0.00           C  
ATOM    940  O   LEU A  65       5.197   3.605  22.918  1.00  0.00           O  
ATOM    941  CB  LEU A  65       5.053   5.628  20.232  1.00  0.00           C  
ATOM    942  CG  LEU A  65       4.433   6.142  18.928  1.00  0.00           C  
ATOM    943  CD1 LEU A  65       5.258   7.362  18.578  1.00  0.00           C  
ATOM    944  CD2 LEU A  65       4.413   5.054  17.856  1.00  0.00           C  
ATOM    945  H   LEU A  65       2.676   6.188  20.966  1.00  0.00           H  
ATOM    946  HA  LEU A  65       4.188   3.692  20.612  1.00  0.00           H  
ATOM    947  HB2 LEU A  65       5.282   6.487  20.859  1.00  0.00           H  
ATOM    948  HB3 LEU A  65       5.994   5.128  20.007  1.00  0.00           H  
ATOM    949  HG  LEU A  65       3.415   6.492  19.082  1.00  0.00           H  
ATOM    950 HD11 LEU A  65       6.300   7.080  18.439  1.00  0.00           H  
ATOM    951 HD12 LEU A  65       5.181   8.038  19.435  1.00  0.00           H  
ATOM    952 HD13 LEU A  65       4.856   7.837  17.688  1.00  0.00           H  
ATOM    953 HD21 LEU A  65       3.989   5.464  16.939  1.00  0.00           H  
ATOM    954 HD22 LEU A  65       3.784   4.231  18.198  1.00  0.00           H  
ATOM    955 HD23 LEU A  65       5.423   4.695  17.671  1.00  0.00           H  
ATOM    956  N   SER A  66       4.618   5.768  23.198  1.00  0.00           N  
ATOM    957  CA  SER A  66       5.076   5.890  24.577  1.00  0.00           C  
ATOM    958  C   SER A  66       4.405   4.827  25.449  1.00  0.00           C  
ATOM    959  O   SER A  66       4.988   4.364  26.428  1.00  0.00           O  
ATOM    960  CB  SER A  66       4.730   7.304  25.067  1.00  0.00           C  
ATOM    961  OG  SER A  66       5.073   7.507  26.422  1.00  0.00           O  
ATOM    962  H   SER A  66       4.198   6.589  22.777  1.00  0.00           H  
ATOM    963  HA  SER A  66       6.158   5.748  24.617  1.00  0.00           H  
ATOM    964  HB2 SER A  66       5.270   8.029  24.458  1.00  0.00           H  
ATOM    965  HB3 SER A  66       3.659   7.480  24.951  1.00  0.00           H  
ATOM    966  HG  SER A  66       4.423   7.023  26.978  1.00  0.00           H  
ATOM    967  N   LEU A  67       3.186   4.433  25.083  1.00  0.00           N  
ATOM    968  CA  LEU A  67       2.461   3.430  25.877  1.00  0.00           C  
ATOM    969  C   LEU A  67       2.815   1.991  25.520  1.00  0.00           C  
ATOM    970  O   LEU A  67       2.340   1.069  26.190  1.00  0.00           O  
ATOM    971  CB  LEU A  67       0.949   3.681  25.918  1.00  0.00           C  
ATOM    972  CG  LEU A  67       0.219   3.579  24.577  1.00  0.00           C  
ATOM    973  CD1 LEU A  67      -0.271   2.179  24.200  1.00  0.00           C  
ATOM    974  CD2 LEU A  67      -0.996   4.511  24.624  1.00  0.00           C  
ATOM    975  H   LEU A  67       2.834   4.902  24.234  1.00  0.00           H  
ATOM    976  HA  LEU A  67       2.783   3.555  26.913  1.00  0.00           H  
ATOM    977  HB2 LEU A  67       0.496   2.971  26.607  1.00  0.00           H  
ATOM    978  HB3 LEU A  67       0.811   4.681  26.336  1.00  0.00           H  
ATOM    979  HG  LEU A  67       0.906   3.903  23.808  1.00  0.00           H  
ATOM    980 HD11 LEU A  67      -0.763   2.221  23.227  1.00  0.00           H  
ATOM    981 HD12 LEU A  67      -0.975   1.821  24.947  1.00  0.00           H  
ATOM    982 HD13 LEU A  67       0.568   1.491  24.119  1.00  0.00           H  
ATOM    983 HD21 LEU A  67      -1.546   4.471  23.689  1.00  0.00           H  
ATOM    984 HD22 LEU A  67      -0.675   5.539  24.800  1.00  0.00           H  
ATOM    985 HD23 LEU A  67      -1.655   4.206  25.430  1.00  0.00           H  
ATOM    986  N   LYS A  68       3.643   1.752  24.500  1.00  0.00           N  
ATOM    987  CA  LYS A  68       4.038   0.407  24.103  1.00  0.00           C  
ATOM    988  C   LYS A  68       5.529   0.178  24.326  1.00  0.00           C  
ATOM    989  O   LYS A  68       5.928  -0.939  24.642  1.00  0.00           O  
ATOM    990  CB  LYS A  68       3.499   0.134  22.693  1.00  0.00           C  
ATOM    991  CG  LYS A  68       4.455   0.388  21.530  1.00  0.00           C  
ATOM    992  CD  LYS A  68       5.533  -0.692  21.319  1.00  0.00           C  
ATOM    993  CE  LYS A  68       5.062  -2.147  21.217  1.00  0.00           C  
ATOM    994  NZ  LYS A  68       4.975  -2.835  22.526  1.00  0.00           N  
ATOM    995  H   LYS A  68       4.023   2.519  23.955  1.00  0.00           H  
ATOM    996  HA  LYS A  68       3.549  -0.314  24.744  1.00  0.00           H  
ATOM    997  HB2 LYS A  68       3.166  -0.894  22.656  1.00  0.00           H  
ATOM    998  HB3 LYS A  68       2.610   0.744  22.529  1.00  0.00           H  
ATOM    999  HG2 LYS A  68       3.849   0.467  20.632  1.00  0.00           H  
ATOM   1000  HG3 LYS A  68       4.933   1.358  21.659  1.00  0.00           H  
ATOM   1001  HD2 LYS A  68       6.030  -0.454  20.389  1.00  0.00           H  
ATOM   1002  HD3 LYS A  68       6.279  -0.628  22.101  1.00  0.00           H  
ATOM   1003  HE2 LYS A  68       4.087  -2.179  20.728  1.00  0.00           H  
ATOM   1004  HE3 LYS A  68       5.773  -2.694  20.593  1.00  0.00           H  
ATOM   1005  HZ1 LYS A  68       4.394  -2.347  23.205  1.00  0.00           H  
ATOM   1006  HZ2 LYS A  68       5.888  -2.987  22.946  1.00  0.00           H  
ATOM   1007  HZ3 LYS A  68       4.533  -3.741  22.401  1.00  0.00           H  
ATOM   1008  N   PHE A  69       6.347   1.200  24.094  1.00  0.00           N  
ATOM   1009  CA  PHE A  69       7.792   1.171  24.259  1.00  0.00           C  
ATOM   1010  C   PHE A  69       8.096   1.557  25.701  1.00  0.00           C  
ATOM   1011  O   PHE A  69       7.720   2.652  26.116  1.00  0.00           O  
ATOM   1012  CB  PHE A  69       8.444   2.147  23.264  1.00  0.00           C  
ATOM   1013  CG  PHE A  69       8.218   1.795  21.799  1.00  0.00           C  
ATOM   1014  CD1 PHE A  69       8.696   0.583  21.265  1.00  0.00           C  
ATOM   1015  CD2 PHE A  69       7.497   2.670  20.967  1.00  0.00           C  
ATOM   1016  CE1 PHE A  69       8.475   0.272  19.909  1.00  0.00           C  
ATOM   1017  CE2 PHE A  69       7.246   2.342  19.623  1.00  0.00           C  
ATOM   1018  CZ  PHE A  69       7.758   1.153  19.081  1.00  0.00           C  
ATOM   1019  H   PHE A  69       5.920   2.078  23.835  1.00  0.00           H  
ATOM   1020  HA  PHE A  69       8.168   0.166  24.073  1.00  0.00           H  
ATOM   1021  HB2 PHE A  69       8.058   3.151  23.454  1.00  0.00           H  
ATOM   1022  HB3 PHE A  69       9.517   2.187  23.459  1.00  0.00           H  
ATOM   1023  HD1 PHE A  69       9.235  -0.115  21.891  1.00  0.00           H  
ATOM   1024  HD2 PHE A  69       7.135   3.602  21.366  1.00  0.00           H  
ATOM   1025  HE1 PHE A  69       8.815  -0.668  19.508  1.00  0.00           H  
ATOM   1026  HE2 PHE A  69       6.672   3.010  19.001  1.00  0.00           H  
ATOM   1027  HZ  PHE A  69       7.589   0.906  18.041  1.00  0.00           H  
ATOM   1028  N   LYS A  70       8.752   0.679  26.468  1.00  0.00           N  
ATOM   1029  CA  LYS A  70       9.089   0.978  27.865  1.00  0.00           C  
ATOM   1030  C   LYS A  70       9.957   2.231  27.965  1.00  0.00           C  
ATOM   1031  O   LYS A  70       9.566   3.186  28.635  1.00  0.00           O  
ATOM   1032  CB  LYS A  70       9.748  -0.213  28.597  1.00  0.00           C  
ATOM   1033  CG  LYS A  70      10.850  -0.966  27.829  1.00  0.00           C  
ATOM   1034  CD  LYS A  70      11.737  -1.834  28.727  1.00  0.00           C  
ATOM   1035  CE  LYS A  70      10.986  -2.888  29.550  1.00  0.00           C  
ATOM   1036  NZ  LYS A  70      10.352  -3.949  28.741  1.00  0.00           N  
ATOM   1037  H   LYS A  70       9.030  -0.207  26.066  1.00  0.00           H  
ATOM   1038  HA  LYS A  70       8.161   1.208  28.392  1.00  0.00           H  
ATOM   1039  HB2 LYS A  70      10.167   0.163  29.534  1.00  0.00           H  
ATOM   1040  HB3 LYS A  70       8.971  -0.931  28.855  1.00  0.00           H  
ATOM   1041  HG2 LYS A  70      10.386  -1.600  27.083  1.00  0.00           H  
ATOM   1042  HG3 LYS A  70      11.501  -0.265  27.312  1.00  0.00           H  
ATOM   1043  HD2 LYS A  70      12.496  -2.318  28.112  1.00  0.00           H  
ATOM   1044  HD3 LYS A  70      12.261  -1.183  29.427  1.00  0.00           H  
ATOM   1045  HE2 LYS A  70      11.707  -3.350  30.229  1.00  0.00           H  
ATOM   1046  HE3 LYS A  70      10.234  -2.389  30.164  1.00  0.00           H  
ATOM   1047  HZ1 LYS A  70      11.054  -4.404  28.166  1.00  0.00           H  
ATOM   1048  HZ2 LYS A  70       9.624  -3.584  28.136  1.00  0.00           H  
ATOM   1049  HZ3 LYS A  70       9.955  -4.652  29.356  1.00  0.00           H  
ATOM   1050  N   ASP A  71      11.074   2.255  27.238  1.00  0.00           N  
ATOM   1051  CA  ASP A  71      12.036   3.351  27.236  1.00  0.00           C  
ATOM   1052  C   ASP A  71      12.108   3.979  25.848  1.00  0.00           C  
ATOM   1053  O   ASP A  71      12.988   3.624  25.053  1.00  0.00           O  
ATOM   1054  CB  ASP A  71      13.420   2.858  27.680  1.00  0.00           C  
ATOM   1055  CG  ASP A  71      13.416   2.383  29.123  1.00  0.00           C  
ATOM   1056  OD1 ASP A  71      13.508   3.222  30.043  1.00  0.00           O  
ATOM   1057  OD2 ASP A  71      13.358   1.155  29.332  1.00  0.00           O  
ATOM   1058  H   ASP A  71      11.314   1.428  26.717  1.00  0.00           H  
ATOM   1059  HA  ASP A  71      11.739   4.105  27.966  1.00  0.00           H  
ATOM   1060  HB2 ASP A  71      13.747   2.041  27.032  1.00  0.00           H  
ATOM   1061  HB3 ASP A  71      14.132   3.680  27.591  1.00  0.00           H  
ATOM   1062  N   PRO A  72      11.204   4.911  25.506  1.00  0.00           N  
ATOM   1063  CA  PRO A  72      11.221   5.565  24.206  1.00  0.00           C  
ATOM   1064  C   PRO A  72      12.572   6.234  23.969  1.00  0.00           C  
ATOM   1065  O   PRO A  72      13.135   6.115  22.880  1.00  0.00           O  
ATOM   1066  CB  PRO A  72      10.081   6.585  24.228  1.00  0.00           C  
ATOM   1067  CG  PRO A  72       9.672   6.718  25.691  1.00  0.00           C  
ATOM   1068  CD  PRO A  72      10.120   5.411  26.330  1.00  0.00           C  
ATOM   1069  HA  PRO A  72      11.042   4.832  23.419  1.00  0.00           H  
ATOM   1070  HB2 PRO A  72      10.387   7.536  23.789  1.00  0.00           H  
ATOM   1071  HB3 PRO A  72       9.235   6.196  23.681  1.00  0.00           H  
ATOM   1072  HG2 PRO A  72      10.208   7.540  26.160  1.00  0.00           H  
ATOM   1073  HG3 PRO A  72       8.595   6.846  25.781  1.00  0.00           H  
ATOM   1074  HD2 PRO A  72      10.427   5.590  27.360  1.00  0.00           H  
ATOM   1075  HD3 PRO A  72       9.303   4.693  26.298  1.00  0.00           H  
ATOM   1076  N   GLU A  73      13.132   6.867  25.001  1.00  0.00           N  
ATOM   1077  CA  GLU A  73      14.412   7.561  24.953  1.00  0.00           C  
ATOM   1078  C   GLU A  73      15.620   6.659  24.682  1.00  0.00           C  
ATOM   1079  O   GLU A  73      16.748   7.141  24.622  1.00  0.00           O  
ATOM   1080  CB  GLU A  73      14.582   8.425  26.202  1.00  0.00           C  
ATOM   1081  CG  GLU A  73      14.869   7.658  27.496  1.00  0.00           C  
ATOM   1082  CD  GLU A  73      15.282   8.653  28.579  1.00  0.00           C  
ATOM   1083  OE1 GLU A  73      16.473   9.036  28.609  1.00  0.00           O  
ATOM   1084  OE2 GLU A  73      14.398   9.126  29.328  1.00  0.00           O  
ATOM   1085  H   GLU A  73      12.620   6.930  25.870  1.00  0.00           H  
ATOM   1086  HA  GLU A  73      14.369   8.239  24.106  1.00  0.00           H  
ATOM   1087  HB2 GLU A  73      15.406   9.105  26.006  1.00  0.00           H  
ATOM   1088  HB3 GLU A  73      13.682   9.026  26.342  1.00  0.00           H  
ATOM   1089  HG2 GLU A  73      13.978   7.106  27.800  1.00  0.00           H  
ATOM   1090  HG3 GLU A  73      15.683   6.948  27.341  1.00  0.00           H  
ATOM   1091  N   ASN A  74      15.423   5.350  24.531  1.00  0.00           N  
ATOM   1092  CA  ASN A  74      16.468   4.371  24.233  1.00  0.00           C  
ATOM   1093  C   ASN A  74      16.060   3.514  23.031  1.00  0.00           C  
ATOM   1094  O   ASN A  74      16.900   2.788  22.507  1.00  0.00           O  
ATOM   1095  CB  ASN A  74      16.736   3.466  25.449  1.00  0.00           C  
ATOM   1096  CG  ASN A  74      17.701   4.026  26.490  1.00  0.00           C  
ATOM   1097  OD1 ASN A  74      18.247   3.248  27.265  1.00  0.00           O  
ATOM   1098  ND2 ASN A  74      17.922   5.327  26.564  1.00  0.00           N  
ATOM   1099  H   ASN A  74      14.468   5.017  24.598  1.00  0.00           H  
ATOM   1100  HA  ASN A  74      17.397   4.877  23.966  1.00  0.00           H  
ATOM   1101  HB2 ASN A  74      15.794   3.205  25.929  1.00  0.00           H  
ATOM   1102  HB3 ASN A  74      17.182   2.536  25.088  1.00  0.00           H  
ATOM   1103 HD21 ASN A  74      17.468   5.984  25.935  1.00  0.00           H  
ATOM   1104 HD22 ASN A  74      18.508   5.707  27.307  1.00  0.00           H  
ATOM   1105  N   THR A  75      14.802   3.572  22.590  1.00  0.00           N  
ATOM   1106  CA  THR A  75      14.279   2.797  21.477  1.00  0.00           C  
ATOM   1107  C   THR A  75      14.440   3.555  20.157  1.00  0.00           C  
ATOM   1108  O   THR A  75      14.173   4.759  20.088  1.00  0.00           O  
ATOM   1109  CB  THR A  75      12.794   2.499  21.756  1.00  0.00           C  
ATOM   1110  OG1 THR A  75      12.611   1.933  23.045  1.00  0.00           O  
ATOM   1111  CG2 THR A  75      12.224   1.471  20.776  1.00  0.00           C  
ATOM   1112  H   THR A  75      14.151   4.194  23.045  1.00  0.00           H  
ATOM   1113  HA  THR A  75      14.821   1.852  21.419  1.00  0.00           H  
ATOM   1114  HB  THR A  75      12.217   3.428  21.696  1.00  0.00           H  
ATOM   1115  HG1 THR A  75      12.882   2.593  23.718  1.00  0.00           H  
ATOM   1116 HG21 THR A  75      12.389   1.788  19.749  1.00  0.00           H  
ATOM   1117 HG22 THR A  75      11.156   1.377  20.940  1.00  0.00           H  
ATOM   1118 HG23 THR A  75      12.704   0.502  20.920  1.00  0.00           H  
ATOM   1119  N   THR A  76      14.838   2.848  19.100  1.00  0.00           N  
ATOM   1120  CA  THR A  76      15.014   3.409  17.767  1.00  0.00           C  
ATOM   1121  C   THR A  76      13.763   3.017  16.962  1.00  0.00           C  
ATOM   1122  O   THR A  76      13.472   1.824  16.857  1.00  0.00           O  
ATOM   1123  CB  THR A  76      16.315   2.892  17.134  1.00  0.00           C  
ATOM   1124  OG1 THR A  76      17.388   2.847  18.069  1.00  0.00           O  
ATOM   1125  CG2 THR A  76      16.652   3.785  15.937  1.00  0.00           C  
ATOM   1126  H   THR A  76      15.041   1.863  19.217  1.00  0.00           H  
ATOM   1127  HA  THR A  76      15.081   4.490  17.852  1.00  0.00           H  
ATOM   1128  HB  THR A  76      16.150   1.886  16.768  1.00  0.00           H  
ATOM   1129  HG1 THR A  76      17.959   2.075  17.844  1.00  0.00           H  
ATOM   1130 HG21 THR A  76      17.525   3.398  15.420  1.00  0.00           H  
ATOM   1131 HG22 THR A  76      16.860   4.799  16.274  1.00  0.00           H  
ATOM   1132 HG23 THR A  76      15.813   3.801  15.235  1.00  0.00           H  
ATOM   1133  N   LEU A  77      13.025   3.978  16.391  1.00  0.00           N  
ATOM   1134  CA  LEU A  77      11.795   3.752  15.630  1.00  0.00           C  
ATOM   1135  C   LEU A  77      12.015   4.021  14.145  1.00  0.00           C  
ATOM   1136  O   LEU A  77      11.989   5.160  13.681  1.00  0.00           O  
ATOM   1137  CB  LEU A  77      10.644   4.635  16.166  1.00  0.00           C  
ATOM   1138  CG  LEU A  77       9.758   4.066  17.286  1.00  0.00           C  
ATOM   1139  CD1 LEU A  77      10.527   3.391  18.421  1.00  0.00           C  
ATOM   1140  CD2 LEU A  77       8.884   5.200  17.838  1.00  0.00           C  
ATOM   1141  H   LEU A  77      13.301   4.947  16.497  1.00  0.00           H  
ATOM   1142  HA  LEU A  77      11.483   2.712  15.736  1.00  0.00           H  
ATOM   1143  HB2 LEU A  77      11.034   5.611  16.442  1.00  0.00           H  
ATOM   1144  HB3 LEU A  77       9.955   4.820  15.354  1.00  0.00           H  
ATOM   1145  HG  LEU A  77       9.099   3.314  16.851  1.00  0.00           H  
ATOM   1146 HD11 LEU A  77       9.845   3.091  19.212  1.00  0.00           H  
ATOM   1147 HD12 LEU A  77      11.265   4.077  18.831  1.00  0.00           H  
ATOM   1148 HD13 LEU A  77      11.021   2.502  18.035  1.00  0.00           H  
ATOM   1149 HD21 LEU A  77       8.307   5.654  17.034  1.00  0.00           H  
ATOM   1150 HD22 LEU A  77       9.519   5.972  18.275  1.00  0.00           H  
ATOM   1151 HD23 LEU A  77       8.206   4.826  18.601  1.00  0.00           H  
ATOM   1152  N   TYR A  78      12.262   2.965  13.391  1.00  0.00           N  
ATOM   1153  CA  TYR A  78      12.460   3.001  11.950  1.00  0.00           C  
ATOM   1154  C   TYR A  78      11.068   3.243  11.342  1.00  0.00           C  
ATOM   1155  O   TYR A  78      10.145   2.486  11.645  1.00  0.00           O  
ATOM   1156  CB  TYR A  78      13.078   1.658  11.551  1.00  0.00           C  
ATOM   1157  CG  TYR A  78      14.543   1.532  11.973  1.00  0.00           C  
ATOM   1158  CD1 TYR A  78      14.920   1.317  13.314  1.00  0.00           C  
ATOM   1159  CD2 TYR A  78      15.553   1.750  11.021  1.00  0.00           C  
ATOM   1160  CE1 TYR A  78      16.276   1.367  13.691  1.00  0.00           C  
ATOM   1161  CE2 TYR A  78      16.910   1.789  11.384  1.00  0.00           C  
ATOM   1162  CZ  TYR A  78      17.278   1.618  12.731  1.00  0.00           C  
ATOM   1163  OH  TYR A  78      18.585   1.750  13.084  1.00  0.00           O  
ATOM   1164  H   TYR A  78      12.270   2.057  13.843  1.00  0.00           H  
ATOM   1165  HA  TYR A  78      13.133   3.813  11.677  1.00  0.00           H  
ATOM   1166  HB2 TYR A  78      12.469   0.870  12.000  1.00  0.00           H  
ATOM   1167  HB3 TYR A  78      13.006   1.551  10.468  1.00  0.00           H  
ATOM   1168  HD1 TYR A  78      14.177   1.158  14.079  1.00  0.00           H  
ATOM   1169  HD2 TYR A  78      15.287   1.972  10.009  1.00  0.00           H  
ATOM   1170  HE1 TYR A  78      16.552   1.243  14.722  1.00  0.00           H  
ATOM   1171  HE2 TYR A  78      17.671   2.015  10.652  1.00  0.00           H  
ATOM   1172  HH  TYR A  78      18.780   1.821  14.036  1.00  0.00           H  
ATOM   1173  N   ILE A  79      10.861   4.333  10.593  1.00  0.00           N  
ATOM   1174  CA  ILE A  79       9.596   4.701   9.975  1.00  0.00           C  
ATOM   1175  C   ILE A  79       9.346   3.835   8.736  1.00  0.00           C  
ATOM   1176  O   ILE A  79      10.287   3.313   8.129  1.00  0.00           O  
ATOM   1177  CB  ILE A  79       9.617   6.197   9.566  1.00  0.00           C  
ATOM   1178  CG1 ILE A  79      10.383   7.166  10.508  1.00  0.00           C  
ATOM   1179  CG2 ILE A  79       8.175   6.687   9.319  1.00  0.00           C  
ATOM   1180  CD1 ILE A  79       9.597   7.866  11.617  1.00  0.00           C  
ATOM   1181  H   ILE A  79      11.602   4.972  10.327  1.00  0.00           H  
ATOM   1182  HA  ILE A  79       8.797   4.558  10.696  1.00  0.00           H  
ATOM   1183  HB  ILE A  79      10.143   6.251   8.610  1.00  0.00           H  
ATOM   1184 HG12 ILE A  79      11.259   6.704  10.955  1.00  0.00           H  
ATOM   1185 HG13 ILE A  79      10.774   7.948   9.871  1.00  0.00           H  
ATOM   1186 HG21 ILE A  79       7.859   6.416   8.311  1.00  0.00           H  
ATOM   1187 HG22 ILE A  79       7.492   6.257  10.052  1.00  0.00           H  
ATOM   1188 HG23 ILE A  79       8.108   7.765   9.420  1.00  0.00           H  
ATOM   1189 HD11 ILE A  79       9.253   8.822  11.237  1.00  0.00           H  
ATOM   1190 HD12 ILE A  79       8.730   7.284  11.920  1.00  0.00           H  
ATOM   1191 HD13 ILE A  79      10.239   8.041  12.479  1.00  0.00           H  
ATOM   1192  N   LEU A  80       8.083   3.698   8.343  1.00  0.00           N  
ATOM   1193  CA  LEU A  80       7.693   2.950   7.169  1.00  0.00           C  
ATOM   1194  C   LEU A  80       6.342   3.465   6.691  1.00  0.00           C  
ATOM   1195  O   LEU A  80       5.337   3.297   7.384  1.00  0.00           O  
ATOM   1196  CB  LEU A  80       7.666   1.429   7.429  1.00  0.00           C  
ATOM   1197  CG  LEU A  80       7.648   0.663   6.089  1.00  0.00           C  
ATOM   1198  CD1 LEU A  80       8.056  -0.805   6.239  1.00  0.00           C  
ATOM   1199  CD2 LEU A  80       6.314   0.753   5.349  1.00  0.00           C  
ATOM   1200  H   LEU A  80       7.341   4.134   8.870  1.00  0.00           H  
ATOM   1201  HA  LEU A  80       8.438   3.148   6.394  1.00  0.00           H  
ATOM   1202  HB2 LEU A  80       8.567   1.158   7.979  1.00  0.00           H  
ATOM   1203  HB3 LEU A  80       6.807   1.154   8.040  1.00  0.00           H  
ATOM   1204  HG  LEU A  80       8.385   1.121   5.438  1.00  0.00           H  
ATOM   1205 HD11 LEU A  80       8.282  -1.201   5.244  1.00  0.00           H  
ATOM   1206 HD12 LEU A  80       7.250  -1.368   6.713  1.00  0.00           H  
ATOM   1207 HD13 LEU A  80       8.958  -0.896   6.838  1.00  0.00           H  
ATOM   1208 HD21 LEU A  80       6.401   1.534   4.587  1.00  0.00           H  
ATOM   1209 HD22 LEU A  80       5.514   0.975   6.050  1.00  0.00           H  
ATOM   1210 HD23 LEU A  80       6.072  -0.188   4.863  1.00  0.00           H  
ATOM   1211  N   ASP A  81       6.329   4.138   5.544  1.00  0.00           N  
ATOM   1212  CA  ASP A  81       5.123   4.651   4.892  1.00  0.00           C  
ATOM   1213  C   ASP A  81       5.109   4.057   3.477  1.00  0.00           C  
ATOM   1214  O   ASP A  81       6.094   3.454   3.047  1.00  0.00           O  
ATOM   1215  CB  ASP A  81       5.040   6.189   4.850  1.00  0.00           C  
ATOM   1216  CG  ASP A  81       3.679   6.652   4.301  1.00  0.00           C  
ATOM   1217  OD1 ASP A  81       2.668   5.937   4.490  1.00  0.00           O  
ATOM   1218  OD2 ASP A  81       3.587   7.697   3.619  1.00  0.00           O  
ATOM   1219  H   ASP A  81       7.200   4.236   5.029  1.00  0.00           H  
ATOM   1220  HA  ASP A  81       4.251   4.287   5.433  1.00  0.00           H  
ATOM   1221  HB2 ASP A  81       5.173   6.589   5.851  1.00  0.00           H  
ATOM   1222  HB3 ASP A  81       5.839   6.581   4.224  1.00  0.00           H  
ATOM   1223  N   LYS A  82       4.008   4.184   2.733  1.00  0.00           N  
ATOM   1224  CA  LYS A  82       3.924   3.666   1.367  1.00  0.00           C  
ATOM   1225  C   LYS A  82       5.072   4.233   0.526  1.00  0.00           C  
ATOM   1226  O   LYS A  82       5.666   3.497  -0.262  1.00  0.00           O  
ATOM   1227  CB  LYS A  82       2.531   3.933   0.761  1.00  0.00           C  
ATOM   1228  CG  LYS A  82       2.139   5.424   0.709  1.00  0.00           C  
ATOM   1229  CD  LYS A  82       0.708   5.680   0.219  1.00  0.00           C  
ATOM   1230  CE  LYS A  82      -0.320   5.047   1.163  1.00  0.00           C  
ATOM   1231  NZ  LYS A  82      -1.692   5.544   0.949  1.00  0.00           N  
ATOM   1232  H   LYS A  82       3.224   4.688   3.136  1.00  0.00           H  
ATOM   1233  HA  LYS A  82       4.064   2.587   1.410  1.00  0.00           H  
ATOM   1234  HB2 LYS A  82       2.506   3.524  -0.250  1.00  0.00           H  
ATOM   1235  HB3 LYS A  82       1.800   3.382   1.355  1.00  0.00           H  
ATOM   1236  HG2 LYS A  82       2.236   5.865   1.701  1.00  0.00           H  
ATOM   1237  HG3 LYS A  82       2.818   5.950   0.039  1.00  0.00           H  
ATOM   1238  HD2 LYS A  82       0.555   6.758   0.185  1.00  0.00           H  
ATOM   1239  HD3 LYS A  82       0.588   5.279  -0.789  1.00  0.00           H  
ATOM   1240  HE2 LYS A  82      -0.303   3.964   1.030  1.00  0.00           H  
ATOM   1241  HE3 LYS A  82      -0.035   5.259   2.187  1.00  0.00           H  
ATOM   1242  HZ1 LYS A  82      -1.923   5.522  -0.040  1.00  0.00           H  
ATOM   1243  HZ2 LYS A  82      -1.795   6.487   1.310  1.00  0.00           H  
ATOM   1244  HZ3 LYS A  82      -2.354   4.931   1.422  1.00  0.00           H  
ATOM   1245  N   PHE A  83       5.399   5.514   0.738  1.00  0.00           N  
ATOM   1246  CA  PHE A  83       6.447   6.262   0.068  1.00  0.00           C  
ATOM   1247  C   PHE A  83       7.130   7.191   1.088  1.00  0.00           C  
ATOM   1248  O   PHE A  83       7.416   6.783   2.212  1.00  0.00           O  
ATOM   1249  CB  PHE A  83       5.836   7.021  -1.108  1.00  0.00           C  
ATOM   1250  CG  PHE A  83       5.153   6.199  -2.176  1.00  0.00           C  
ATOM   1251  CD1 PHE A  83       5.829   5.141  -2.817  1.00  0.00           C  
ATOM   1252  CD2 PHE A  83       3.862   6.561  -2.600  1.00  0.00           C  
ATOM   1253  CE1 PHE A  83       5.233   4.478  -3.900  1.00  0.00           C  
ATOM   1254  CE2 PHE A  83       3.263   5.894  -3.676  1.00  0.00           C  
ATOM   1255  CZ  PHE A  83       3.958   4.869  -4.337  1.00  0.00           C  
ATOM   1256  H   PHE A  83       4.856   6.029   1.412  1.00  0.00           H  
ATOM   1257  HA  PHE A  83       7.188   5.575  -0.328  1.00  0.00           H  
ATOM   1258  HB2 PHE A  83       5.122   7.741  -0.710  1.00  0.00           H  
ATOM   1259  HB3 PHE A  83       6.646   7.557  -1.594  1.00  0.00           H  
ATOM   1260  HD1 PHE A  83       6.806   4.825  -2.484  1.00  0.00           H  
ATOM   1261  HD2 PHE A  83       3.328   7.369  -2.119  1.00  0.00           H  
ATOM   1262  HE1 PHE A  83       5.749   3.670  -4.402  1.00  0.00           H  
ATOM   1263  HE2 PHE A  83       2.273   6.187  -4.000  1.00  0.00           H  
ATOM   1264  HZ  PHE A  83       3.516   4.373  -5.185  1.00  0.00           H  
ATOM   1265  N   ASP A  84       7.481   8.417   0.693  1.00  0.00           N  
ATOM   1266  CA  ASP A  84       8.111   9.435   1.531  1.00  0.00           C  
ATOM   1267  C   ASP A  84       7.124   9.829   2.623  1.00  0.00           C  
ATOM   1268  O   ASP A  84       7.364   9.589   3.808  1.00  0.00           O  
ATOM   1269  CB  ASP A  84       8.528  10.660   0.707  1.00  0.00           C  
ATOM   1270  CG  ASP A  84       9.358  11.617   1.556  1.00  0.00           C  
ATOM   1271  OD1 ASP A  84      10.595  11.404   1.603  1.00  0.00           O  
ATOM   1272  OD2 ASP A  84       8.795  12.598   2.089  1.00  0.00           O  
ATOM   1273  H   ASP A  84       7.221   8.691  -0.237  1.00  0.00           H  
ATOM   1274  HA  ASP A  84       9.003   9.020   1.981  1.00  0.00           H  
ATOM   1275  HB2 ASP A  84       9.122  10.329  -0.145  1.00  0.00           H  
ATOM   1276  HB3 ASP A  84       7.661  11.189   0.314  1.00  0.00           H  
ATOM   1277  N   GLY A  85       5.990  10.377   2.182  1.00  0.00           N  
ATOM   1278  CA  GLY A  85       4.864  10.839   2.968  1.00  0.00           C  
ATOM   1279  C   GLY A  85       5.248  11.811   4.067  1.00  0.00           C  
ATOM   1280  O   GLY A  85       5.135  13.023   3.901  1.00  0.00           O  
ATOM   1281  H   GLY A  85       5.933  10.510   1.179  1.00  0.00           H  
ATOM   1282  HA2 GLY A  85       4.156  11.331   2.307  1.00  0.00           H  
ATOM   1283  HA3 GLY A  85       4.372   9.979   3.414  1.00  0.00           H  
ATOM   1284  N   ASN A  86       5.612  11.281   5.233  1.00  0.00           N  
ATOM   1285  CA  ASN A  86       5.997  12.068   6.403  1.00  0.00           C  
ATOM   1286  C   ASN A  86       7.176  11.430   7.142  1.00  0.00           C  
ATOM   1287  O   ASN A  86       7.489  11.867   8.241  1.00  0.00           O  
ATOM   1288  CB  ASN A  86       4.791  12.228   7.359  1.00  0.00           C  
ATOM   1289  CG  ASN A  86       3.593  12.909   6.716  1.00  0.00           C  
ATOM   1290  OD1 ASN A  86       3.435  14.122   6.779  1.00  0.00           O  
ATOM   1291  ND2 ASN A  86       2.705  12.146   6.099  1.00  0.00           N  
ATOM   1292  H   ASN A  86       5.681  10.273   5.256  1.00  0.00           H  
ATOM   1293  HA  ASN A  86       6.310  13.062   6.079  1.00  0.00           H  
ATOM   1294  HB2 ASN A  86       4.504  11.255   7.761  1.00  0.00           H  
ATOM   1295  HB3 ASN A  86       5.088  12.858   8.192  1.00  0.00           H  
ATOM   1296 HD21 ASN A  86       2.851  11.149   6.054  1.00  0.00           H  
ATOM   1297 HD22 ASN A  86       2.245  12.611   5.320  1.00  0.00           H  
ATOM   1298  N   SER A  87       7.826  10.405   6.583  1.00  0.00           N  
ATOM   1299  CA  SER A  87       8.947   9.677   7.175  1.00  0.00           C  
ATOM   1300  C   SER A  87       9.989  10.574   7.858  1.00  0.00           C  
ATOM   1301  O   SER A  87      10.280  10.344   9.028  1.00  0.00           O  
ATOM   1302  CB  SER A  87       9.515   8.707   6.134  1.00  0.00           C  
ATOM   1303  OG  SER A  87       8.472   7.887   5.627  1.00  0.00           O  
ATOM   1304  H   SER A  87       7.534  10.086   5.667  1.00  0.00           H  
ATOM   1305  HA  SER A  87       8.572   9.036   7.970  1.00  0.00           H  
ATOM   1306  HB2 SER A  87       9.978   9.260   5.316  1.00  0.00           H  
ATOM   1307  HB3 SER A  87      10.258   8.068   6.609  1.00  0.00           H  
ATOM   1308  HG  SER A  87       8.103   8.329   4.837  1.00  0.00           H  
ATOM   1309  N   GLU A  88      10.547  11.589   7.189  1.00  0.00           N  
ATOM   1310  CA  GLU A  88      11.553  12.452   7.824  1.00  0.00           C  
ATOM   1311  C   GLU A  88      10.952  13.333   8.922  1.00  0.00           C  
ATOM   1312  O   GLU A  88      11.582  13.536   9.960  1.00  0.00           O  
ATOM   1313  CB  GLU A  88      12.283  13.307   6.779  1.00  0.00           C  
ATOM   1314  CG  GLU A  88      13.240  12.438   5.957  1.00  0.00           C  
ATOM   1315  CD  GLU A  88      14.148  13.258   5.037  1.00  0.00           C  
ATOM   1316  OE1 GLU A  88      13.633  13.915   4.102  1.00  0.00           O  
ATOM   1317  OE2 GLU A  88      15.389  13.200   5.177  1.00  0.00           O  
ATOM   1318  H   GLU A  88      10.277  11.747   6.230  1.00  0.00           H  
ATOM   1319  HA  GLU A  88      12.292  11.813   8.312  1.00  0.00           H  
ATOM   1320  HB2 GLU A  88      11.556  13.793   6.129  1.00  0.00           H  
ATOM   1321  HB3 GLU A  88      12.867  14.072   7.288  1.00  0.00           H  
ATOM   1322  HG2 GLU A  88      13.858  11.860   6.644  1.00  0.00           H  
ATOM   1323  HG3 GLU A  88      12.653  11.742   5.357  1.00  0.00           H  
ATOM   1324  N   LEU A  89       9.744  13.858   8.704  1.00  0.00           N  
ATOM   1325  CA  LEU A  89       9.058  14.707   9.680  1.00  0.00           C  
ATOM   1326  C   LEU A  89       8.834  13.910  10.963  1.00  0.00           C  
ATOM   1327  O   LEU A  89       9.187  14.362  12.050  1.00  0.00           O  
ATOM   1328  CB  LEU A  89       7.746  15.250   9.073  1.00  0.00           C  
ATOM   1329  CG  LEU A  89       6.919  16.236   9.929  1.00  0.00           C  
ATOM   1330  CD1 LEU A  89       6.136  15.581  11.074  1.00  0.00           C  
ATOM   1331  CD2 LEU A  89       7.761  17.401  10.459  1.00  0.00           C  
ATOM   1332  H   LEU A  89       9.292  13.637   7.830  1.00  0.00           H  
ATOM   1333  HA  LEU A  89       9.712  15.547   9.918  1.00  0.00           H  
ATOM   1334  HB2 LEU A  89       8.004  15.767   8.147  1.00  0.00           H  
ATOM   1335  HB3 LEU A  89       7.104  14.413   8.802  1.00  0.00           H  
ATOM   1336  HG  LEU A  89       6.172  16.662   9.259  1.00  0.00           H  
ATOM   1337 HD11 LEU A  89       5.388  16.284  11.443  1.00  0.00           H  
ATOM   1338 HD12 LEU A  89       6.792  15.328  11.905  1.00  0.00           H  
ATOM   1339 HD13 LEU A  89       5.627  14.685  10.720  1.00  0.00           H  
ATOM   1340 HD21 LEU A  89       8.480  17.054  11.202  1.00  0.00           H  
ATOM   1341 HD22 LEU A  89       7.108  18.141  10.924  1.00  0.00           H  
ATOM   1342 HD23 LEU A  89       8.293  17.873   9.633  1.00  0.00           H  
ATOM   1343  N   VAL A  90       8.270  12.711  10.835  1.00  0.00           N  
ATOM   1344  CA  VAL A  90       7.984  11.811  11.942  1.00  0.00           C  
ATOM   1345  C   VAL A  90       9.295  11.355  12.599  1.00  0.00           C  
ATOM   1346  O   VAL A  90       9.314  11.119  13.809  1.00  0.00           O  
ATOM   1347  CB  VAL A  90       7.079  10.667  11.444  1.00  0.00           C  
ATOM   1348  CG1 VAL A  90       6.722   9.677  12.558  1.00  0.00           C  
ATOM   1349  CG2 VAL A  90       5.749  11.225  10.921  1.00  0.00           C  
ATOM   1350  H   VAL A  90       8.013  12.411   9.900  1.00  0.00           H  
ATOM   1351  HA  VAL A  90       7.425  12.376  12.685  1.00  0.00           H  
ATOM   1352  HB  VAL A  90       7.575  10.134  10.633  1.00  0.00           H  
ATOM   1353 HG11 VAL A  90       6.194  10.190  13.362  1.00  0.00           H  
ATOM   1354 HG12 VAL A  90       6.091   8.883  12.163  1.00  0.00           H  
ATOM   1355 HG13 VAL A  90       7.626   9.230  12.961  1.00  0.00           H  
ATOM   1356 HG21 VAL A  90       5.212  11.719  11.730  1.00  0.00           H  
ATOM   1357 HG22 VAL A  90       5.928  11.952  10.137  1.00  0.00           H  
ATOM   1358 HG23 VAL A  90       5.142  10.418  10.514  1.00  0.00           H  
ATOM   1359  N   ALA A  91      10.395  11.255  11.843  1.00  0.00           N  
ATOM   1360  CA  ALA A  91      11.682  10.858  12.409  1.00  0.00           C  
ATOM   1361  C   ALA A  91      12.143  11.943  13.393  1.00  0.00           C  
ATOM   1362  O   ALA A  91      12.709  11.626  14.439  1.00  0.00           O  
ATOM   1363  CB  ALA A  91      12.725  10.582  11.317  1.00  0.00           C  
ATOM   1364  H   ALA A  91      10.310  11.457  10.853  1.00  0.00           H  
ATOM   1365  HA  ALA A  91      11.530   9.940  12.974  1.00  0.00           H  
ATOM   1366  HB1 ALA A  91      12.918  11.483  10.738  1.00  0.00           H  
ATOM   1367  HB2 ALA A  91      13.659  10.258  11.777  1.00  0.00           H  
ATOM   1368  HB3 ALA A  91      12.374   9.789  10.658  1.00  0.00           H  
ATOM   1369  N   GLU A  92      11.907  13.220  13.075  1.00  0.00           N  
ATOM   1370  CA  GLU A  92      12.270  14.332  13.948  1.00  0.00           C  
ATOM   1371  C   GLU A  92      11.232  14.461  15.068  1.00  0.00           C  
ATOM   1372  O   GLU A  92      11.582  14.751  16.202  1.00  0.00           O  
ATOM   1373  CB  GLU A  92      12.374  15.650  13.165  1.00  0.00           C  
ATOM   1374  CG  GLU A  92      13.627  15.702  12.277  1.00  0.00           C  
ATOM   1375  CD  GLU A  92      14.004  17.149  11.963  1.00  0.00           C  
ATOM   1376  OE1 GLU A  92      14.736  17.749  12.784  1.00  0.00           O  
ATOM   1377  OE2 GLU A  92      13.574  17.696  10.917  1.00  0.00           O  
ATOM   1378  H   GLU A  92      11.435  13.419  12.200  1.00  0.00           H  
ATOM   1379  HA  GLU A  92      13.234  14.126  14.414  1.00  0.00           H  
ATOM   1380  HB2 GLU A  92      11.483  15.804  12.555  1.00  0.00           H  
ATOM   1381  HB3 GLU A  92      12.434  16.464  13.888  1.00  0.00           H  
ATOM   1382  HG2 GLU A  92      14.465  15.243  12.807  1.00  0.00           H  
ATOM   1383  HG3 GLU A  92      13.453  15.148  11.354  1.00  0.00           H  
ATOM   1384  N   LEU A  93       9.955  14.201  14.793  1.00  0.00           N  
ATOM   1385  CA  LEU A  93       8.852  14.283  15.748  1.00  0.00           C  
ATOM   1386  C   LEU A  93       9.142  13.511  17.029  1.00  0.00           C  
ATOM   1387  O   LEU A  93       9.077  14.058  18.132  1.00  0.00           O  
ATOM   1388  CB  LEU A  93       7.616  13.690  15.076  1.00  0.00           C  
ATOM   1389  CG  LEU A  93       6.309  13.766  15.887  1.00  0.00           C  
ATOM   1390  CD1 LEU A  93       5.730  15.178  15.900  1.00  0.00           C  
ATOM   1391  CD2 LEU A  93       5.275  12.807  15.284  1.00  0.00           C  
ATOM   1392  H   LEU A  93       9.741  13.972  13.827  1.00  0.00           H  
ATOM   1393  HA  LEU A  93       8.674  15.325  15.994  1.00  0.00           H  
ATOM   1394  HB2 LEU A  93       7.489  14.171  14.113  1.00  0.00           H  
ATOM   1395  HB3 LEU A  93       7.850  12.647  14.904  1.00  0.00           H  
ATOM   1396  HG  LEU A  93       6.496  13.458  16.913  1.00  0.00           H  
ATOM   1397 HD11 LEU A  93       5.553  15.521  14.879  1.00  0.00           H  
ATOM   1398 HD12 LEU A  93       6.430  15.859  16.378  1.00  0.00           H  
ATOM   1399 HD13 LEU A  93       4.797  15.198  16.463  1.00  0.00           H  
ATOM   1400 HD21 LEU A  93       5.086  13.072  14.243  1.00  0.00           H  
ATOM   1401 HD22 LEU A  93       4.343  12.865  15.846  1.00  0.00           H  
ATOM   1402 HD23 LEU A  93       5.650  11.786  15.334  1.00  0.00           H  
ATOM   1403  N   VAL A  94       9.421  12.218  16.885  1.00  0.00           N  
ATOM   1404  CA  VAL A  94       9.703  11.347  18.012  1.00  0.00           C  
ATOM   1405  C   VAL A  94      10.965  11.804  18.734  1.00  0.00           C  
ATOM   1406  O   VAL A  94      10.989  11.804  19.967  1.00  0.00           O  
ATOM   1407  CB  VAL A  94       9.789   9.883  17.540  1.00  0.00           C  
ATOM   1408  CG1 VAL A  94       8.460   9.455  16.917  1.00  0.00           C  
ATOM   1409  CG2 VAL A  94      10.926   9.594  16.551  1.00  0.00           C  
ATOM   1410  H   VAL A  94       9.463  11.828  15.948  1.00  0.00           H  
ATOM   1411  HA  VAL A  94       8.874  11.427  18.714  1.00  0.00           H  
ATOM   1412  HB  VAL A  94       9.938   9.253  18.409  1.00  0.00           H  
ATOM   1413 HG11 VAL A  94       8.312   9.947  15.955  1.00  0.00           H  
ATOM   1414 HG12 VAL A  94       8.482   8.376  16.780  1.00  0.00           H  
ATOM   1415 HG13 VAL A  94       7.633   9.702  17.583  1.00  0.00           H  
ATOM   1416 HG21 VAL A  94      10.869   8.558  16.217  1.00  0.00           H  
ATOM   1417 HG22 VAL A  94      10.866  10.255  15.690  1.00  0.00           H  
ATOM   1418 HG23 VAL A  94      11.892   9.742  17.034  1.00  0.00           H  
ATOM   1419  N   ALA A  95      11.984  12.200  17.971  1.00  0.00           N  
ATOM   1420  CA  ALA A  95      13.265  12.650  18.492  1.00  0.00           C  
ATOM   1421  C   ALA A  95      13.063  13.866  19.402  1.00  0.00           C  
ATOM   1422  O   ALA A  95      13.524  13.899  20.545  1.00  0.00           O  
ATOM   1423  CB  ALA A  95      14.178  12.950  17.302  1.00  0.00           C  
ATOM   1424  H   ALA A  95      11.854  12.173  16.963  1.00  0.00           H  
ATOM   1425  HA  ALA A  95      13.706  11.836  19.068  1.00  0.00           H  
ATOM   1426  HB1 ALA A  95      13.751  13.742  16.692  1.00  0.00           H  
ATOM   1427  HB2 ALA A  95      15.160  13.256  17.659  1.00  0.00           H  
ATOM   1428  HB3 ALA A  95      14.274  12.056  16.682  1.00  0.00           H  
ATOM   1429  N   LEU A  96      12.319  14.853  18.902  1.00  0.00           N  
ATOM   1430  CA  LEU A  96      12.005  16.087  19.616  1.00  0.00           C  
ATOM   1431  C   LEU A  96      11.187  15.758  20.865  1.00  0.00           C  
ATOM   1432  O   LEU A  96      11.427  16.348  21.921  1.00  0.00           O  
ATOM   1433  CB  LEU A  96      11.275  17.089  18.706  1.00  0.00           C  
ATOM   1434  CG  LEU A  96      12.222  18.094  18.013  1.00  0.00           C  
ATOM   1435  CD1 LEU A  96      13.215  17.444  17.048  1.00  0.00           C  
ATOM   1436  CD2 LEU A  96      11.401  19.116  17.221  1.00  0.00           C  
ATOM   1437  H   LEU A  96      11.988  14.722  17.949  1.00  0.00           H  
ATOM   1438  HA  LEU A  96      12.943  16.537  19.939  1.00  0.00           H  
ATOM   1439  HB2 LEU A  96      10.686  16.549  17.966  1.00  0.00           H  
ATOM   1440  HB3 LEU A  96      10.586  17.666  19.325  1.00  0.00           H  
ATOM   1441  HG  LEU A  96      12.785  18.627  18.781  1.00  0.00           H  
ATOM   1442 HD11 LEU A  96      13.844  16.720  17.565  1.00  0.00           H  
ATOM   1443 HD12 LEU A  96      13.859  18.212  16.619  1.00  0.00           H  
ATOM   1444 HD13 LEU A  96      12.693  16.954  16.231  1.00  0.00           H  
ATOM   1445 HD21 LEU A  96      10.815  18.632  16.442  1.00  0.00           H  
ATOM   1446 HD22 LEU A  96      12.068  19.827  16.739  1.00  0.00           H  
ATOM   1447 HD23 LEU A  96      10.755  19.675  17.894  1.00  0.00           H  
ATOM   1448  N   ASN A  97      10.265  14.790  20.777  1.00  0.00           N  
ATOM   1449  CA  ASN A  97       9.442  14.379  21.915  1.00  0.00           C  
ATOM   1450  C   ASN A  97      10.334  13.832  23.020  1.00  0.00           C  
ATOM   1451  O   ASN A  97      10.202  14.251  24.171  1.00  0.00           O  
ATOM   1452  CB  ASN A  97       8.384  13.333  21.532  1.00  0.00           C  
ATOM   1453  CG  ASN A  97       7.090  14.032  21.185  1.00  0.00           C  
ATOM   1454  OD1 ASN A  97       6.183  14.117  22.008  1.00  0.00           O  
ATOM   1455  ND2 ASN A  97       6.998  14.574  19.986  1.00  0.00           N  
ATOM   1456  H   ASN A  97      10.129  14.355  19.873  1.00  0.00           H  
ATOM   1457  HA  ASN A  97       8.929  15.259  22.305  1.00  0.00           H  
ATOM   1458  HB2 ASN A  97       8.718  12.711  20.704  1.00  0.00           H  
ATOM   1459  HB3 ASN A  97       8.191  12.682  22.387  1.00  0.00           H  
ATOM   1460 HD21 ASN A  97       7.786  14.512  19.347  1.00  0.00           H  
ATOM   1461 HD22 ASN A  97       6.253  15.223  19.759  1.00  0.00           H  
ATOM   1462  N   GLY A  98      11.244  12.922  22.684  1.00  0.00           N  
ATOM   1463  CA  GLY A  98      12.162  12.329  23.642  1.00  0.00           C  
ATOM   1464  C   GLY A  98      12.696  10.974  23.204  1.00  0.00           C  
ATOM   1465  O   GLY A  98      13.541  10.427  23.910  1.00  0.00           O  
ATOM   1466  H   GLY A  98      11.303  12.621  21.718  1.00  0.00           H  
ATOM   1467  HA2 GLY A  98      13.009  12.996  23.795  1.00  0.00           H  
ATOM   1468  HA3 GLY A  98      11.659  12.210  24.602  1.00  0.00           H  
ATOM   1469  N   PHE A  99      12.191  10.372  22.120  1.00  0.00           N  
ATOM   1470  CA  PHE A  99      12.688   9.087  21.653  1.00  0.00           C  
ATOM   1471  C   PHE A  99      14.170   9.202  21.287  1.00  0.00           C  
ATOM   1472  O   PHE A  99      14.635  10.285  20.930  1.00  0.00           O  
ATOM   1473  CB  PHE A  99      11.897   8.606  20.442  1.00  0.00           C  
ATOM   1474  CG  PHE A  99      10.593   7.902  20.754  1.00  0.00           C  
ATOM   1475  CD1 PHE A  99       9.398   8.623  20.944  1.00  0.00           C  
ATOM   1476  CD2 PHE A  99      10.585   6.497  20.838  1.00  0.00           C  
ATOM   1477  CE1 PHE A  99       8.208   7.938  21.249  1.00  0.00           C  
ATOM   1478  CE2 PHE A  99       9.395   5.812  21.124  1.00  0.00           C  
ATOM   1479  CZ  PHE A  99       8.212   6.536  21.351  1.00  0.00           C  
ATOM   1480  H   PHE A  99      11.496  10.829  21.550  1.00  0.00           H  
ATOM   1481  HA  PHE A  99      12.578   8.374  22.461  1.00  0.00           H  
ATOM   1482  HB2 PHE A  99      11.740   9.427  19.753  1.00  0.00           H  
ATOM   1483  HB3 PHE A  99      12.531   7.905  19.918  1.00  0.00           H  
ATOM   1484  HD1 PHE A  99       9.389   9.702  20.858  1.00  0.00           H  
ATOM   1485  HD2 PHE A  99      11.500   5.940  20.689  1.00  0.00           H  
ATOM   1486  HE1 PHE A  99       7.296   8.495  21.419  1.00  0.00           H  
ATOM   1487  HE2 PHE A  99       9.415   4.734  21.201  1.00  0.00           H  
ATOM   1488  HZ  PHE A  99       7.323   6.009  21.644  1.00  0.00           H  
ATOM   1489  N   LYS A 100      14.902   8.083  21.308  1.00  0.00           N  
ATOM   1490  CA  LYS A 100      16.320   8.088  21.001  1.00  0.00           C  
ATOM   1491  C   LYS A 100      16.621   8.612  19.604  1.00  0.00           C  
ATOM   1492  O   LYS A 100      17.287   9.632  19.454  1.00  0.00           O  
ATOM   1493  CB  LYS A 100      16.916   6.682  21.184  1.00  0.00           C  
ATOM   1494  CG  LYS A 100      18.425   6.632  20.903  1.00  0.00           C  
ATOM   1495  CD  LYS A 100      19.285   7.406  21.916  1.00  0.00           C  
ATOM   1496  CE  LYS A 100      19.517   8.870  21.504  1.00  0.00           C  
ATOM   1497  NZ  LYS A 100      20.197   9.642  22.558  1.00  0.00           N  
ATOM   1498  H   LYS A 100      14.490   7.205  21.600  1.00  0.00           H  
ATOM   1499  HA  LYS A 100      16.782   8.764  21.721  1.00  0.00           H  
ATOM   1500  HB2 LYS A 100      16.733   6.337  22.194  1.00  0.00           H  
ATOM   1501  HB3 LYS A 100      16.423   5.986  20.506  1.00  0.00           H  
ATOM   1502  HG2 LYS A 100      18.732   5.590  20.897  1.00  0.00           H  
ATOM   1503  HG3 LYS A 100      18.609   6.997  19.900  1.00  0.00           H  
ATOM   1504  HD2 LYS A 100      18.811   7.358  22.895  1.00  0.00           H  
ATOM   1505  HD3 LYS A 100      20.257   6.914  21.989  1.00  0.00           H  
ATOM   1506  HE2 LYS A 100      20.116   8.892  20.593  1.00  0.00           H  
ATOM   1507  HE3 LYS A 100      18.566   9.358  21.299  1.00  0.00           H  
ATOM   1508  HZ1 LYS A 100      21.064   9.192  22.833  1.00  0.00           H  
ATOM   1509  HZ2 LYS A 100      19.598   9.729  23.381  1.00  0.00           H  
ATOM   1510  HZ3 LYS A 100      20.412  10.578  22.223  1.00  0.00           H  
ATOM   1511  N   SER A 101      16.235   7.864  18.577  1.00  0.00           N  
ATOM   1512  CA  SER A 101      16.485   8.199  17.184  1.00  0.00           C  
ATOM   1513  C   SER A 101      15.489   7.450  16.305  1.00  0.00           C  
ATOM   1514  O   SER A 101      14.766   6.582  16.797  1.00  0.00           O  
ATOM   1515  CB  SER A 101      17.925   7.767  16.880  1.00  0.00           C  
ATOM   1516  OG  SER A 101      18.844   8.600  17.562  1.00  0.00           O  
ATOM   1517  H   SER A 101      15.685   7.034  18.745  1.00  0.00           H  
ATOM   1518  HA  SER A 101      16.367   9.272  17.024  1.00  0.00           H  
ATOM   1519  HB2 SER A 101      18.062   6.736  17.204  1.00  0.00           H  
ATOM   1520  HB3 SER A 101      18.122   7.812  15.818  1.00  0.00           H  
ATOM   1521  HG  SER A 101      18.318   9.184  18.150  1.00  0.00           H  
ATOM   1522  N   ALA A 102      15.434   7.752  15.014  1.00  0.00           N  
ATOM   1523  CA  ALA A 102      14.544   7.140  14.061  1.00  0.00           C  
ATOM   1524  C   ALA A 102      15.244   7.183  12.709  1.00  0.00           C  
ATOM   1525  O   ALA A 102      16.214   7.914  12.519  1.00  0.00           O  
ATOM   1526  CB  ALA A 102      13.255   7.972  14.041  1.00  0.00           C  
ATOM   1527  H   ALA A 102      16.011   8.452  14.564  1.00  0.00           H  
ATOM   1528  HA  ALA A 102      14.329   6.107  14.339  1.00  0.00           H  
ATOM   1529  HB1 ALA A 102      13.493   9.030  13.923  1.00  0.00           H  
ATOM   1530  HB2 ALA A 102      12.607   7.655  13.226  1.00  0.00           H  
ATOM   1531  HB3 ALA A 102      12.727   7.841  14.986  1.00  0.00           H  
ATOM   1532  N   TYR A 103      14.756   6.399  11.763  1.00  0.00           N  
ATOM   1533  CA  TYR A 103      15.284   6.337  10.410  1.00  0.00           C  
ATOM   1534  C   TYR A 103      14.124   6.359   9.440  1.00  0.00           C  
ATOM   1535  O   TYR A 103      13.214   5.542   9.570  1.00  0.00           O  
ATOM   1536  CB  TYR A 103      16.118   5.081  10.194  1.00  0.00           C  
ATOM   1537  CG  TYR A 103      17.536   5.227  10.689  1.00  0.00           C  
ATOM   1538  CD1 TYR A 103      17.834   4.981  12.039  1.00  0.00           C  
ATOM   1539  CD2 TYR A 103      18.541   5.676   9.811  1.00  0.00           C  
ATOM   1540  CE1 TYR A 103      19.130   5.202  12.522  1.00  0.00           C  
ATOM   1541  CE2 TYR A 103      19.844   5.891  10.286  1.00  0.00           C  
ATOM   1542  CZ  TYR A 103      20.137   5.669  11.649  1.00  0.00           C  
ATOM   1543  OH  TYR A 103      21.391   5.907  12.115  1.00  0.00           O  
ATOM   1544  H   TYR A 103      13.966   5.826  12.002  1.00  0.00           H  
ATOM   1545  HA  TYR A 103      15.922   7.195  10.221  1.00  0.00           H  
ATOM   1546  HB2 TYR A 103      15.625   4.257  10.699  1.00  0.00           H  
ATOM   1547  HB3 TYR A 103      16.143   4.859   9.127  1.00  0.00           H  
ATOM   1548  HD1 TYR A 103      17.060   4.639  12.711  1.00  0.00           H  
ATOM   1549  HD2 TYR A 103      18.320   5.884   8.774  1.00  0.00           H  
ATOM   1550  HE1 TYR A 103      19.331   5.030  13.566  1.00  0.00           H  
ATOM   1551  HE2 TYR A 103      20.603   6.255   9.611  1.00  0.00           H  
ATOM   1552  HH  TYR A 103      21.423   5.805  13.082  1.00  0.00           H  
ATOM   1553  N   ALA A 104      14.144   7.297   8.499  1.00  0.00           N  
ATOM   1554  CA  ALA A 104      13.125   7.432   7.482  1.00  0.00           C  
ATOM   1555  C   ALA A 104      13.617   6.588   6.315  1.00  0.00           C  
ATOM   1556  O   ALA A 104      14.650   6.905   5.707  1.00  0.00           O  
ATOM   1557  CB  ALA A 104      12.946   8.906   7.120  1.00  0.00           C  
ATOM   1558  H   ALA A 104      14.935   7.933   8.452  1.00  0.00           H  
ATOM   1559  HA  ALA A 104      12.173   7.040   7.843  1.00  0.00           H  
ATOM   1560  HB1 ALA A 104      12.299   9.004   6.251  1.00  0.00           H  
ATOM   1561  HB2 ALA A 104      12.513   9.431   7.971  1.00  0.00           H  
ATOM   1562  HB3 ALA A 104      13.903   9.358   6.899  1.00  0.00           H  
ATOM   1563  N   ILE A 105      12.951   5.462   6.063  1.00  0.00           N  
ATOM   1564  CA  ILE A 105      13.317   4.577   4.975  1.00  0.00           C  
ATOM   1565  C   ILE A 105      12.824   5.215   3.683  1.00  0.00           C  
ATOM   1566  O   ILE A 105      11.676   5.045   3.277  1.00  0.00           O  
ATOM   1567  CB  ILE A 105      12.838   3.126   5.208  1.00  0.00           C  
ATOM   1568  CG1 ILE A 105      13.711   2.441   6.288  1.00  0.00           C  
ATOM   1569  CG2 ILE A 105      12.964   2.275   3.931  1.00  0.00           C  
ATOM   1570  CD1 ILE A 105      13.244   2.655   7.726  1.00  0.00           C  
ATOM   1571  H   ILE A 105      12.112   5.233   6.582  1.00  0.00           H  
ATOM   1572  HA  ILE A 105      14.404   4.542   4.921  1.00  0.00           H  
ATOM   1573  HB  ILE A 105      11.792   3.148   5.512  1.00  0.00           H  
ATOM   1574 HG12 ILE A 105      13.729   1.361   6.129  1.00  0.00           H  
ATOM   1575 HG13 ILE A 105      14.738   2.792   6.194  1.00  0.00           H  
ATOM   1576 HG21 ILE A 105      12.749   1.230   4.152  1.00  0.00           H  
ATOM   1577 HG22 ILE A 105      12.248   2.602   3.177  1.00  0.00           H  
ATOM   1578 HG23 ILE A 105      13.966   2.358   3.523  1.00  0.00           H  
ATOM   1579 HD11 ILE A 105      12.511   1.890   7.987  1.00  0.00           H  
ATOM   1580 HD12 ILE A 105      14.091   2.566   8.393  1.00  0.00           H  
ATOM   1581 HD13 ILE A 105      12.805   3.638   7.854  1.00  0.00           H  
ATOM   1582  N   LYS A 106      13.727   5.989   3.079  1.00  0.00           N  
ATOM   1583  CA  LYS A 106      13.571   6.693   1.824  1.00  0.00           C  
ATOM   1584  C   LYS A 106      13.002   5.699   0.824  1.00  0.00           C  
ATOM   1585  O   LYS A 106      13.501   4.568   0.745  1.00  0.00           O  
ATOM   1586  CB  LYS A 106      14.954   7.173   1.334  1.00  0.00           C  
ATOM   1587  CG  LYS A 106      14.930   8.170   0.163  1.00  0.00           C  
ATOM   1588  CD  LYS A 106      14.471   9.591   0.515  1.00  0.00           C  
ATOM   1589  CE  LYS A 106      15.594  10.559   0.918  1.00  0.00           C  
ATOM   1590  NZ  LYS A 106      16.235  10.252   2.206  1.00  0.00           N  
ATOM   1591  H   LYS A 106      14.624   6.016   3.540  1.00  0.00           H  
ATOM   1592  HA  LYS A 106      12.878   7.518   1.988  1.00  0.00           H  
ATOM   1593  HB2 LYS A 106      15.541   7.557   2.167  1.00  0.00           H  
ATOM   1594  HB3 LYS A 106      15.482   6.297   0.964  1.00  0.00           H  
ATOM   1595  HG2 LYS A 106      15.927   8.224  -0.277  1.00  0.00           H  
ATOM   1596  HG3 LYS A 106      14.262   7.782  -0.604  1.00  0.00           H  
ATOM   1597  HD2 LYS A 106      13.996  10.012  -0.372  1.00  0.00           H  
ATOM   1598  HD3 LYS A 106      13.707   9.553   1.287  1.00  0.00           H  
ATOM   1599  HE2 LYS A 106      16.350  10.593   0.132  1.00  0.00           H  
ATOM   1600  HE3 LYS A 106      15.153  11.550   1.011  1.00  0.00           H  
ATOM   1601  HZ1 LYS A 106      15.533   9.998   2.897  1.00  0.00           H  
ATOM   1602  HZ2 LYS A 106      16.690  11.091   2.562  1.00  0.00           H  
ATOM   1603  HZ3 LYS A 106      16.933   9.529   2.093  1.00  0.00           H  
ATOM   1604  N   ASP A 107      11.984   6.170   0.111  1.00  0.00           N  
ATOM   1605  CA  ASP A 107      11.199   5.519  -0.937  1.00  0.00           C  
ATOM   1606  C   ASP A 107       9.983   4.778  -0.378  1.00  0.00           C  
ATOM   1607  O   ASP A 107       9.147   4.339  -1.173  1.00  0.00           O  
ATOM   1608  CB  ASP A 107      12.011   4.571  -1.848  1.00  0.00           C  
ATOM   1609  CG  ASP A 107      13.032   5.305  -2.705  1.00  0.00           C  
ATOM   1610  OD1 ASP A 107      14.119   5.665  -2.201  1.00  0.00           O  
ATOM   1611  OD2 ASP A 107      12.760   5.485  -3.911  1.00  0.00           O  
ATOM   1612  H   ASP A 107      11.736   7.128   0.335  1.00  0.00           H  
ATOM   1613  HA  ASP A 107      10.832   6.318  -1.577  1.00  0.00           H  
ATOM   1614  HB2 ASP A 107      12.483   3.766  -1.288  1.00  0.00           H  
ATOM   1615  HB3 ASP A 107      11.330   4.074  -2.533  1.00  0.00           H  
ATOM   1616  N   GLY A 108       9.808   4.699   0.948  1.00  0.00           N  
ATOM   1617  CA  GLY A 108       8.699   3.972   1.564  1.00  0.00           C  
ATOM   1618  C   GLY A 108       8.830   2.478   1.275  1.00  0.00           C  
ATOM   1619  O   GLY A 108       9.898   2.009   0.877  1.00  0.00           O  
ATOM   1620  H   GLY A 108      10.505   5.079   1.574  1.00  0.00           H  
ATOM   1621  HA2 GLY A 108       8.675   4.141   2.643  1.00  0.00           H  
ATOM   1622  HA3 GLY A 108       7.757   4.311   1.159  1.00  0.00           H  
ATOM   1623  N   ALA A 109       7.764   1.705   1.481  1.00  0.00           N  
ATOM   1624  CA  ALA A 109       7.782   0.267   1.228  1.00  0.00           C  
ATOM   1625  C   ALA A 109       7.397  -0.119  -0.200  1.00  0.00           C  
ATOM   1626  O   ALA A 109       7.680  -1.253  -0.580  1.00  0.00           O  
ATOM   1627  CB  ALA A 109       6.878  -0.464   2.216  1.00  0.00           C  
ATOM   1628  H   ALA A 109       6.917   2.154   1.816  1.00  0.00           H  
ATOM   1629  HA  ALA A 109       8.788  -0.103   1.403  1.00  0.00           H  
ATOM   1630  HB1 ALA A 109       7.373  -0.453   3.183  1.00  0.00           H  
ATOM   1631  HB2 ALA A 109       5.900   0.014   2.271  1.00  0.00           H  
ATOM   1632  HB3 ALA A 109       6.757  -1.505   1.914  1.00  0.00           H  
ATOM   1633  N   GLU A 110       6.817   0.791  -0.992  1.00  0.00           N  
ATOM   1634  CA  GLU A 110       6.387   0.497  -2.363  1.00  0.00           C  
ATOM   1635  C   GLU A 110       7.185   1.249  -3.433  1.00  0.00           C  
ATOM   1636  O   GLU A 110       6.958   1.037  -4.627  1.00  0.00           O  
ATOM   1637  CB  GLU A 110       4.878   0.782  -2.500  1.00  0.00           C  
ATOM   1638  CG  GLU A 110       4.034  -0.064  -1.530  1.00  0.00           C  
ATOM   1639  CD  GLU A 110       2.527   0.097  -1.749  1.00  0.00           C  
ATOM   1640  OE1 GLU A 110       2.067   0.181  -2.916  1.00  0.00           O  
ATOM   1641  OE2 GLU A 110       1.794   0.143  -0.734  1.00  0.00           O  
ATOM   1642  H   GLU A 110       6.603   1.714  -0.626  1.00  0.00           H  
ATOM   1643  HA  GLU A 110       6.529  -0.567  -2.561  1.00  0.00           H  
ATOM   1644  HB2 GLU A 110       4.686   1.840  -2.314  1.00  0.00           H  
ATOM   1645  HB3 GLU A 110       4.574   0.552  -3.522  1.00  0.00           H  
ATOM   1646  HG2 GLU A 110       4.295  -1.115  -1.642  1.00  0.00           H  
ATOM   1647  HG3 GLU A 110       4.269   0.227  -0.505  1.00  0.00           H  
ATOM   1648  N   GLY A 111       8.130   2.116  -3.052  1.00  0.00           N  
ATOM   1649  CA  GLY A 111       8.922   2.873  -4.016  1.00  0.00           C  
ATOM   1650  C   GLY A 111       9.852   1.993  -4.862  1.00  0.00           C  
ATOM   1651  O   GLY A 111       9.987   0.791  -4.604  1.00  0.00           O  
ATOM   1652  H   GLY A 111       8.294   2.274  -2.067  1.00  0.00           H  
ATOM   1653  HA2 GLY A 111       8.236   3.390  -4.685  1.00  0.00           H  
ATOM   1654  HA3 GLY A 111       9.510   3.618  -3.491  1.00  0.00           H  
ATOM   1655  N   PRO A 112      10.572   2.583  -5.835  1.00  0.00           N  
ATOM   1656  CA  PRO A 112      11.477   1.869  -6.741  1.00  0.00           C  
ATOM   1657  C   PRO A 112      12.568   1.052  -6.059  1.00  0.00           C  
ATOM   1658  O   PRO A 112      13.034   0.061  -6.625  1.00  0.00           O  
ATOM   1659  CB  PRO A 112      12.047   2.925  -7.686  1.00  0.00           C  
ATOM   1660  CG  PRO A 112      11.782   4.255  -6.992  1.00  0.00           C  
ATOM   1661  CD  PRO A 112      10.507   3.986  -6.203  1.00  0.00           C  
ATOM   1662  HA  PRO A 112      10.874   1.172  -7.322  1.00  0.00           H  
ATOM   1663  HB2 PRO A 112      13.109   2.780  -7.890  1.00  0.00           H  
ATOM   1664  HB3 PRO A 112      11.473   2.891  -8.602  1.00  0.00           H  
ATOM   1665  HG2 PRO A 112      12.602   4.477  -6.310  1.00  0.00           H  
ATOM   1666  HG3 PRO A 112      11.637   5.062  -7.707  1.00  0.00           H  
ATOM   1667  HD2 PRO A 112      10.475   4.635  -5.327  1.00  0.00           H  
ATOM   1668  HD3 PRO A 112       9.638   4.155  -6.838  1.00  0.00           H  
ATOM   1669  N   ARG A 113      12.933   1.448  -4.843  1.00  0.00           N  
ATOM   1670  CA  ARG A 113      13.926   0.814  -3.978  1.00  0.00           C  
ATOM   1671  C   ARG A 113      13.391   0.702  -2.544  1.00  0.00           C  
ATOM   1672  O   ARG A 113      14.156   0.816  -1.583  1.00  0.00           O  
ATOM   1673  CB  ARG A 113      15.261   1.559  -4.063  1.00  0.00           C  
ATOM   1674  CG  ARG A 113      15.186   3.001  -3.534  1.00  0.00           C  
ATOM   1675  CD  ARG A 113      16.567   3.517  -3.152  1.00  0.00           C  
ATOM   1676  NE  ARG A 113      17.419   3.572  -4.342  1.00  0.00           N  
ATOM   1677  CZ  ARG A 113      18.699   3.918  -4.421  1.00  0.00           C  
ATOM   1678  NH1 ARG A 113      19.392   4.243  -3.331  1.00  0.00           N  
ATOM   1679  NH2 ARG A 113      19.249   3.936  -5.625  1.00  0.00           N  
ATOM   1680  H   ARG A 113      12.467   2.284  -4.523  1.00  0.00           H  
ATOM   1681  HA  ARG A 113      14.100  -0.206  -4.331  1.00  0.00           H  
ATOM   1682  HB2 ARG A 113      15.994   0.997  -3.483  1.00  0.00           H  
ATOM   1683  HB3 ARG A 113      15.588   1.576  -5.103  1.00  0.00           H  
ATOM   1684  HG2 ARG A 113      14.747   3.646  -4.295  1.00  0.00           H  
ATOM   1685  HG3 ARG A 113      14.566   3.050  -2.643  1.00  0.00           H  
ATOM   1686  HD2 ARG A 113      16.460   4.518  -2.732  1.00  0.00           H  
ATOM   1687  HD3 ARG A 113      16.995   2.854  -2.395  1.00  0.00           H  
ATOM   1688  HE  ARG A 113      16.932   3.407  -5.223  1.00  0.00           H  
ATOM   1689 HH11 ARG A 113      18.915   4.267  -2.429  1.00  0.00           H  
ATOM   1690 HH12 ARG A 113      20.369   4.511  -3.335  1.00  0.00           H  
ATOM   1691 HH21 ARG A 113      18.653   3.724  -6.420  1.00  0.00           H  
ATOM   1692 HH22 ARG A 113      20.151   4.369  -5.808  1.00  0.00           H  
ATOM   1693  N   GLY A 114      12.071   0.604  -2.391  1.00  0.00           N  
ATOM   1694  CA  GLY A 114      11.429   0.480  -1.095  1.00  0.00           C  
ATOM   1695  C   GLY A 114      11.767  -0.857  -0.438  1.00  0.00           C  
ATOM   1696  O   GLY A 114      12.623  -1.598  -0.933  1.00  0.00           O  
ATOM   1697  H   GLY A 114      11.478   0.510  -3.202  1.00  0.00           H  
ATOM   1698  HA2 GLY A 114      11.787   1.286  -0.453  1.00  0.00           H  
ATOM   1699  HA3 GLY A 114      10.349   0.559  -1.221  1.00  0.00           H  
ATOM   1700  N   TRP A 115      11.106  -1.171   0.682  1.00  0.00           N  
ATOM   1701  CA  TRP A 115      11.318  -2.406   1.426  1.00  0.00           C  
ATOM   1702  C   TRP A 115      11.332  -3.644   0.521  1.00  0.00           C  
ATOM   1703  O   TRP A 115      12.291  -4.421   0.536  1.00  0.00           O  
ATOM   1704  CB  TRP A 115      10.243  -2.536   2.516  1.00  0.00           C  
ATOM   1705  CG  TRP A 115      10.537  -3.594   3.523  1.00  0.00           C  
ATOM   1706  CD1 TRP A 115      10.209  -4.899   3.401  1.00  0.00           C  
ATOM   1707  CD2 TRP A 115      11.204  -3.459   4.813  1.00  0.00           C  
ATOM   1708  NE1 TRP A 115      10.696  -5.602   4.475  1.00  0.00           N  
ATOM   1709  CE2 TRP A 115      11.343  -4.765   5.372  1.00  0.00           C  
ATOM   1710  CE3 TRP A 115      11.696  -2.371   5.574  1.00  0.00           C  
ATOM   1711  CZ2 TRP A 115      11.971  -4.978   6.613  1.00  0.00           C  
ATOM   1712  CZ3 TRP A 115      12.282  -2.574   6.837  1.00  0.00           C  
ATOM   1713  CH2 TRP A 115      12.418  -3.871   7.356  1.00  0.00           C  
ATOM   1714  H   TRP A 115      10.411  -0.532   1.062  1.00  0.00           H  
ATOM   1715  HA  TRP A 115      12.292  -2.330   1.907  1.00  0.00           H  
ATOM   1716  HB2 TRP A 115      10.162  -1.597   3.051  1.00  0.00           H  
ATOM   1717  HB3 TRP A 115       9.271  -2.732   2.058  1.00  0.00           H  
ATOM   1718  HD1 TRP A 115       9.626  -5.341   2.603  1.00  0.00           H  
ATOM   1719  HE1 TRP A 115      10.465  -6.604   4.560  1.00  0.00           H  
ATOM   1720  HE3 TRP A 115      11.591  -1.357   5.199  1.00  0.00           H  
ATOM   1721  HZ2 TRP A 115      12.086  -5.976   7.010  1.00  0.00           H  
ATOM   1722  HZ3 TRP A 115      12.615  -1.727   7.419  1.00  0.00           H  
ATOM   1723  HH2 TRP A 115      12.850  -4.007   8.335  1.00  0.00           H  
ATOM   1724  N   LEU A 116      10.263  -3.821  -0.256  1.00  0.00           N  
ATOM   1725  CA  LEU A 116      10.094  -4.948  -1.170  1.00  0.00           C  
ATOM   1726  C   LEU A 116      11.203  -4.948  -2.222  1.00  0.00           C  
ATOM   1727  O   LEU A 116      11.893  -5.958  -2.392  1.00  0.00           O  
ATOM   1728  CB  LEU A 116       8.705  -4.888  -1.830  1.00  0.00           C  
ATOM   1729  CG  LEU A 116       7.532  -5.177  -0.871  1.00  0.00           C  
ATOM   1730  CD1 LEU A 116       6.208  -4.750  -1.516  1.00  0.00           C  
ATOM   1731  CD2 LEU A 116       7.456  -6.662  -0.499  1.00  0.00           C  
ATOM   1732  H   LEU A 116       9.538  -3.118  -0.193  1.00  0.00           H  
ATOM   1733  HA  LEU A 116      10.180  -5.873  -0.601  1.00  0.00           H  
ATOM   1734  HB2 LEU A 116       8.577  -3.893  -2.251  1.00  0.00           H  
ATOM   1735  HB3 LEU A 116       8.669  -5.604  -2.655  1.00  0.00           H  
ATOM   1736  HG  LEU A 116       7.661  -4.595   0.042  1.00  0.00           H  
ATOM   1737 HD11 LEU A 116       6.055  -5.277  -2.460  1.00  0.00           H  
ATOM   1738 HD12 LEU A 116       6.223  -3.673  -1.691  1.00  0.00           H  
ATOM   1739 HD13 LEU A 116       5.383  -4.979  -0.841  1.00  0.00           H  
ATOM   1740 HD21 LEU A 116       6.595  -6.835   0.149  1.00  0.00           H  
ATOM   1741 HD22 LEU A 116       8.354  -6.966   0.040  1.00  0.00           H  
ATOM   1742 HD23 LEU A 116       7.353  -7.271  -1.397  1.00  0.00           H  
ATOM   1743  N   ASN A 117      11.424  -3.808  -2.884  1.00  0.00           N  
ATOM   1744  CA  ASN A 117      12.440  -3.629  -3.928  1.00  0.00           C  
ATOM   1745  C   ASN A 117      13.873  -3.527  -3.378  1.00  0.00           C  
ATOM   1746  O   ASN A 117      14.756  -2.920  -3.995  1.00  0.00           O  
ATOM   1747  CB  ASN A 117      12.081  -2.443  -4.836  1.00  0.00           C  
ATOM   1748  CG  ASN A 117      10.838  -2.700  -5.684  1.00  0.00           C  
ATOM   1749  OD1 ASN A 117      10.536  -3.832  -6.047  1.00  0.00           O  
ATOM   1750  ND2 ASN A 117      10.087  -1.667  -6.022  1.00  0.00           N  
ATOM   1751  H   ASN A 117      10.814  -3.022  -2.685  1.00  0.00           H  
ATOM   1752  HA  ASN A 117      12.419  -4.525  -4.549  1.00  0.00           H  
ATOM   1753  HB2 ASN A 117      11.957  -1.549  -4.230  1.00  0.00           H  
ATOM   1754  HB3 ASN A 117      12.905  -2.282  -5.530  1.00  0.00           H  
ATOM   1755 HD21 ASN A 117      10.264  -0.743  -5.655  1.00  0.00           H  
ATOM   1756 HD22 ASN A 117       9.228  -1.819  -6.536  1.00  0.00           H  
ATOM   1757  N   SER A 118      14.115  -4.092  -2.198  1.00  0.00           N  
ATOM   1758  CA  SER A 118      15.392  -4.137  -1.503  1.00  0.00           C  
ATOM   1759  C   SER A 118      15.727  -5.569  -1.069  1.00  0.00           C  
ATOM   1760  O   SER A 118      16.651  -5.766  -0.283  1.00  0.00           O  
ATOM   1761  CB  SER A 118      15.368  -3.169  -0.320  1.00  0.00           C  
ATOM   1762  OG  SER A 118      15.368  -1.839  -0.789  1.00  0.00           O  
ATOM   1763  H   SER A 118      13.338  -4.564  -1.753  1.00  0.00           H  
ATOM   1764  HA  SER A 118      16.176  -3.823  -2.189  1.00  0.00           H  
ATOM   1765  HB2 SER A 118      14.486  -3.341   0.292  1.00  0.00           H  
ATOM   1766  HB3 SER A 118      16.248  -3.327   0.296  1.00  0.00           H  
ATOM   1767  HG  SER A 118      14.443  -1.629  -1.020  1.00  0.00           H  
ATOM   1768  N   SER A 119      14.994  -6.566  -1.574  1.00  0.00           N  
ATOM   1769  CA  SER A 119      15.169  -7.980  -1.268  1.00  0.00           C  
ATOM   1770  C   SER A 119      14.883  -8.315   0.203  1.00  0.00           C  
ATOM   1771  O   SER A 119      15.339  -9.341   0.719  1.00  0.00           O  
ATOM   1772  CB  SER A 119      16.526  -8.480  -1.782  1.00  0.00           C  
ATOM   1773  OG  SER A 119      16.384  -9.806  -2.248  1.00  0.00           O  
ATOM   1774  H   SER A 119      14.248  -6.348  -2.222  1.00  0.00           H  
ATOM   1775  HA  SER A 119      14.415  -8.488  -1.853  1.00  0.00           H  
ATOM   1776  HB2 SER A 119      16.853  -7.862  -2.619  1.00  0.00           H  
ATOM   1777  HB3 SER A 119      17.274  -8.430  -0.989  1.00  0.00           H  
ATOM   1778  HG  SER A 119      16.744 -10.406  -1.560  1.00  0.00           H  
ATOM   1779  N   LEU A 120      14.178  -7.432   0.911  1.00  0.00           N  
ATOM   1780  CA  LEU A 120      13.845  -7.648   2.306  1.00  0.00           C  
ATOM   1781  C   LEU A 120      12.606  -8.547   2.377  1.00  0.00           C  
ATOM   1782  O   LEU A 120      11.757  -8.505   1.483  1.00  0.00           O  
ATOM   1783  CB  LEU A 120      13.605  -6.309   3.014  1.00  0.00           C  
ATOM   1784  CG  LEU A 120      14.780  -5.319   2.914  1.00  0.00           C  
ATOM   1785  CD1 LEU A 120      14.422  -4.045   3.679  1.00  0.00           C  
ATOM   1786  CD2 LEU A 120      16.087  -5.910   3.456  1.00  0.00           C  
ATOM   1787  H   LEU A 120      13.811  -6.610   0.453  1.00  0.00           H  
ATOM   1788  HA  LEU A 120      14.687  -8.148   2.783  1.00  0.00           H  
ATOM   1789  HB2 LEU A 120      12.718  -5.848   2.582  1.00  0.00           H  
ATOM   1790  HB3 LEU A 120      13.399  -6.504   4.068  1.00  0.00           H  
ATOM   1791  HG  LEU A 120      14.936  -5.044   1.872  1.00  0.00           H  
ATOM   1792 HD11 LEU A 120      13.529  -3.611   3.234  1.00  0.00           H  
ATOM   1793 HD12 LEU A 120      15.239  -3.328   3.621  1.00  0.00           H  
ATOM   1794 HD13 LEU A 120      14.205  -4.278   4.720  1.00  0.00           H  
ATOM   1795 HD21 LEU A 120      15.924  -6.345   4.440  1.00  0.00           H  
ATOM   1796 HD22 LEU A 120      16.856  -5.143   3.517  1.00  0.00           H  
ATOM   1797 HD23 LEU A 120      16.450  -6.684   2.779  1.00  0.00           H  
ATOM   1798  N   PRO A 121      12.470  -9.355   3.436  1.00  0.00           N  
ATOM   1799  CA  PRO A 121      11.327 -10.241   3.598  1.00  0.00           C  
ATOM   1800  C   PRO A 121      10.093  -9.431   3.977  1.00  0.00           C  
ATOM   1801  O   PRO A 121      10.227  -8.380   4.616  1.00  0.00           O  
ATOM   1802  CB  PRO A 121      11.704 -11.164   4.751  1.00  0.00           C  
ATOM   1803  CG  PRO A 121      12.700 -10.349   5.572  1.00  0.00           C  
ATOM   1804  CD  PRO A 121      13.400  -9.480   4.544  1.00  0.00           C  
ATOM   1805  HA  PRO A 121      11.145 -10.815   2.687  1.00  0.00           H  
ATOM   1806  HB2 PRO A 121      10.825 -11.398   5.348  1.00  0.00           H  
ATOM   1807  HB3 PRO A 121      12.181 -12.065   4.361  1.00  0.00           H  
ATOM   1808  HG2 PRO A 121      12.169  -9.700   6.261  1.00  0.00           H  
ATOM   1809  HG3 PRO A 121      13.402 -10.977   6.114  1.00  0.00           H  
ATOM   1810  HD2 PRO A 121      13.643  -8.513   4.983  1.00  0.00           H  
ATOM   1811  HD3 PRO A 121      14.305  -9.967   4.197  1.00  0.00           H  
ATOM   1812  N   TRP A 122       8.893  -9.930   3.679  1.00  0.00           N  
ATOM   1813  CA  TRP A 122       7.660  -9.234   4.013  1.00  0.00           C  
ATOM   1814  C   TRP A 122       6.500 -10.231   4.136  1.00  0.00           C  
ATOM   1815  O   TRP A 122       6.584 -11.337   3.595  1.00  0.00           O  
ATOM   1816  CB  TRP A 122       7.433  -8.172   2.929  1.00  0.00           C  
ATOM   1817  CG  TRP A 122       6.225  -7.312   3.073  1.00  0.00           C  
ATOM   1818  CD1 TRP A 122       5.000  -7.606   2.595  1.00  0.00           C  
ATOM   1819  CD2 TRP A 122       6.110  -5.991   3.668  1.00  0.00           C  
ATOM   1820  NE1 TRP A 122       4.138  -6.570   2.865  1.00  0.00           N  
ATOM   1821  CE2 TRP A 122       4.766  -5.546   3.538  1.00  0.00           C  
ATOM   1822  CE3 TRP A 122       7.009  -5.123   4.309  1.00  0.00           C  
ATOM   1823  CZ2 TRP A 122       4.344  -4.309   4.045  1.00  0.00           C  
ATOM   1824  CZ3 TRP A 122       6.606  -3.869   4.791  1.00  0.00           C  
ATOM   1825  CH2 TRP A 122       5.271  -3.457   4.664  1.00  0.00           C  
ATOM   1826  H   TRP A 122       8.792 -10.792   3.157  1.00  0.00           H  
ATOM   1827  HA  TRP A 122       7.804  -8.770   4.991  1.00  0.00           H  
ATOM   1828  HB2 TRP A 122       8.302  -7.510   2.895  1.00  0.00           H  
ATOM   1829  HB3 TRP A 122       7.374  -8.671   1.963  1.00  0.00           H  
ATOM   1830  HD1 TRP A 122       4.745  -8.506   2.057  1.00  0.00           H  
ATOM   1831  HE1 TRP A 122       3.195  -6.566   2.483  1.00  0.00           H  
ATOM   1832  HE3 TRP A 122       8.022  -5.446   4.453  1.00  0.00           H  
ATOM   1833  HZ2 TRP A 122       3.319  -4.017   3.961  1.00  0.00           H  
ATOM   1834  HZ3 TRP A 122       7.332  -3.233   5.270  1.00  0.00           H  
ATOM   1835  HH2 TRP A 122       4.971  -2.494   5.050  1.00  0.00           H  
ATOM   1836  N   ILE A 123       5.439  -9.864   4.866  1.00  0.00           N  
ATOM   1837  CA  ILE A 123       4.246 -10.689   5.101  1.00  0.00           C  
ATOM   1838  C   ILE A 123       3.055 -10.140   4.316  1.00  0.00           C  
ATOM   1839  O   ILE A 123       2.285  -9.305   4.804  1.00  0.00           O  
ATOM   1840  CB  ILE A 123       3.898 -10.882   6.601  1.00  0.00           C  
ATOM   1841  CG1 ILE A 123       5.158 -11.004   7.455  1.00  0.00           C  
ATOM   1842  CG2 ILE A 123       3.059 -12.154   6.742  1.00  0.00           C  
ATOM   1843  CD1 ILE A 123       5.036 -11.250   8.941  1.00  0.00           C  
ATOM   1844  H   ILE A 123       5.442  -8.938   5.290  1.00  0.00           H  
ATOM   1845  HA  ILE A 123       4.462 -11.682   4.711  1.00  0.00           H  
ATOM   1846  HB  ILE A 123       3.324 -10.028   6.966  1.00  0.00           H  
ATOM   1847 HG12 ILE A 123       5.817 -11.776   7.049  1.00  0.00           H  
ATOM   1848 HG13 ILE A 123       5.616 -10.025   7.404  1.00  0.00           H  
ATOM   1849 HG21 ILE A 123       2.734 -12.269   7.774  1.00  0.00           H  
ATOM   1850 HG22 ILE A 123       2.185 -12.086   6.098  1.00  0.00           H  
ATOM   1851 HG23 ILE A 123       3.670 -13.009   6.447  1.00  0.00           H  
ATOM   1852 HD11 ILE A 123       4.453 -10.441   9.373  1.00  0.00           H  
ATOM   1853 HD12 ILE A 123       4.589 -12.220   9.140  1.00  0.00           H  
ATOM   1854 HD13 ILE A 123       6.058 -11.227   9.323  1.00  0.00           H  
ATOM   1855  N   GLU A 124       2.913 -10.585   3.076  1.00  0.00           N  
ATOM   1856  CA  GLU A 124       1.828 -10.198   2.195  1.00  0.00           C  
ATOM   1857  C   GLU A 124       0.521 -10.846   2.681  1.00  0.00           C  
ATOM   1858  O   GLU A 124       0.542 -11.849   3.410  1.00  0.00           O  
ATOM   1859  CB  GLU A 124       2.156 -10.634   0.759  1.00  0.00           C  
ATOM   1860  CG  GLU A 124       3.245  -9.742   0.145  1.00  0.00           C  
ATOM   1861  CD  GLU A 124       3.172  -9.789  -1.376  1.00  0.00           C  
ATOM   1862  OE1 GLU A 124       3.478 -10.847  -1.964  1.00  0.00           O  
ATOM   1863  OE2 GLU A 124       2.723  -8.792  -1.988  1.00  0.00           O  
ATOM   1864  H   GLU A 124       3.567 -11.281   2.730  1.00  0.00           H  
ATOM   1865  HA  GLU A 124       1.705  -9.118   2.217  1.00  0.00           H  
ATOM   1866  HB2 GLU A 124       2.478 -11.677   0.744  1.00  0.00           H  
ATOM   1867  HB3 GLU A 124       1.256 -10.557   0.149  1.00  0.00           H  
ATOM   1868  HG2 GLU A 124       3.100  -8.709   0.469  1.00  0.00           H  
ATOM   1869  HG3 GLU A 124       4.227 -10.076   0.483  1.00  0.00           H  
ATOM   1870  N   PRO A 125      -0.630 -10.255   2.331  1.00  0.00           N  
ATOM   1871  CA  PRO A 125      -1.944 -10.759   2.683  1.00  0.00           C  
ATOM   1872  C   PRO A 125      -2.330 -11.885   1.710  1.00  0.00           C  
ATOM   1873  O   PRO A 125      -1.514 -12.348   0.902  1.00  0.00           O  
ATOM   1874  CB  PRO A 125      -2.861  -9.535   2.579  1.00  0.00           C  
ATOM   1875  CG  PRO A 125      -2.220  -8.687   1.484  1.00  0.00           C  
ATOM   1876  CD  PRO A 125      -0.751  -9.070   1.501  1.00  0.00           C  
ATOM   1877  HA  PRO A 125      -1.948 -11.148   3.701  1.00  0.00           H  
ATOM   1878  HB2 PRO A 125      -3.896  -9.785   2.342  1.00  0.00           H  
ATOM   1879  HB3 PRO A 125      -2.817  -8.981   3.518  1.00  0.00           H  
ATOM   1880  HG2 PRO A 125      -2.623  -8.922   0.506  1.00  0.00           H  
ATOM   1881  HG3 PRO A 125      -2.342  -7.629   1.709  1.00  0.00           H  
ATOM   1882  HD2 PRO A 125      -0.393  -9.259   0.491  1.00  0.00           H  
ATOM   1883  HD3 PRO A 125      -0.192  -8.258   1.942  1.00  0.00           H  
ATOM   1884  N   LYS A 126      -3.568 -12.371   1.810  1.00  0.00           N  
ATOM   1885  CA  LYS A 126      -4.062 -13.425   0.935  1.00  0.00           C  
ATOM   1886  C   LYS A 126      -4.206 -12.873  -0.478  1.00  0.00           C  
ATOM   1887  O   LYS A 126      -5.108 -12.090  -0.780  1.00  0.00           O  
ATOM   1888  CB  LYS A 126      -5.389 -13.996   1.435  1.00  0.00           C  
ATOM   1889  CG  LYS A 126      -5.160 -14.885   2.663  1.00  0.00           C  
ATOM   1890  CD  LYS A 126      -6.439 -15.626   3.049  1.00  0.00           C  
ATOM   1891  CE  LYS A 126      -7.430 -14.660   3.701  1.00  0.00           C  
ATOM   1892  NZ  LYS A 126      -8.807 -15.163   3.610  1.00  0.00           N  
ATOM   1893  H   LYS A 126      -4.205 -11.961   2.484  1.00  0.00           H  
ATOM   1894  HA  LYS A 126      -3.329 -14.233   0.915  1.00  0.00           H  
ATOM   1895  HB2 LYS A 126      -6.075 -13.182   1.668  1.00  0.00           H  
ATOM   1896  HB3 LYS A 126      -5.826 -14.600   0.639  1.00  0.00           H  
ATOM   1897  HG2 LYS A 126      -4.394 -15.622   2.429  1.00  0.00           H  
ATOM   1898  HG3 LYS A 126      -4.811 -14.283   3.502  1.00  0.00           H  
ATOM   1899  HD2 LYS A 126      -6.872 -16.078   2.155  1.00  0.00           H  
ATOM   1900  HD3 LYS A 126      -6.199 -16.420   3.755  1.00  0.00           H  
ATOM   1901  HE2 LYS A 126      -7.156 -14.506   4.746  1.00  0.00           H  
ATOM   1902  HE3 LYS A 126      -7.391 -13.699   3.184  1.00  0.00           H  
ATOM   1903  HZ1 LYS A 126      -8.887 -16.114   3.953  1.00  0.00           H  
ATOM   1904  HZ2 LYS A 126      -9.082 -15.168   2.631  1.00  0.00           H  
ATOM   1905  HZ3 LYS A 126      -9.441 -14.552   4.105  1.00  0.00           H  
ATOM   1906  N   LYS A 127      -3.259 -13.228  -1.338  1.00  0.00           N  
ATOM   1907  CA  LYS A 127      -3.275 -12.803  -2.728  1.00  0.00           C  
ATOM   1908  C   LYS A 127      -4.279 -13.670  -3.474  1.00  0.00           C  
ATOM   1909  O   LYS A 127      -4.625 -14.761  -3.013  1.00  0.00           O  
ATOM   1910  CB  LYS A 127      -1.871 -12.945  -3.322  1.00  0.00           C  
ATOM   1911  CG  LYS A 127      -0.962 -11.826  -2.806  1.00  0.00           C  
ATOM   1912  CD  LYS A 127       0.527 -12.166  -2.877  1.00  0.00           C  
ATOM   1913  CE  LYS A 127       1.140 -12.268  -4.282  1.00  0.00           C  
ATOM   1914  NZ  LYS A 127       0.904 -13.580  -4.931  1.00  0.00           N  
ATOM   1915  H   LYS A 127      -2.548 -13.868  -1.026  1.00  0.00           H  
ATOM   1916  HA  LYS A 127      -3.593 -11.764  -2.788  1.00  0.00           H  
ATOM   1917  HB2 LYS A 127      -1.466 -13.925  -3.063  1.00  0.00           H  
ATOM   1918  HB3 LYS A 127      -1.929 -12.857  -4.405  1.00  0.00           H  
ATOM   1919  HG2 LYS A 127      -1.162 -10.922  -3.377  1.00  0.00           H  
ATOM   1920  HG3 LYS A 127      -1.191 -11.615  -1.761  1.00  0.00           H  
ATOM   1921  HD2 LYS A 127       1.049 -11.373  -2.348  1.00  0.00           H  
ATOM   1922  HD3 LYS A 127       0.702 -13.077  -2.317  1.00  0.00           H  
ATOM   1923  HE2 LYS A 127       0.761 -11.457  -4.907  1.00  0.00           H  
ATOM   1924  HE3 LYS A 127       2.219 -12.126  -4.177  1.00  0.00           H  
ATOM   1925  HZ1 LYS A 127       1.166 -14.333  -4.305  1.00  0.00           H  
ATOM   1926  HZ2 LYS A 127       1.468 -13.684  -5.764  1.00  0.00           H  
ATOM   1927  HZ3 LYS A 127      -0.057 -13.684  -5.246  1.00  0.00           H  
ATOM   1928  N   THR A 128      -4.693 -13.209  -4.643  1.00  0.00           N  
ATOM   1929  CA  THR A 128      -5.630 -13.910  -5.499  1.00  0.00           C  
ATOM   1930  C   THR A 128      -4.989 -13.926  -6.886  1.00  0.00           C  
ATOM   1931  O   THR A 128      -4.184 -13.050  -7.224  1.00  0.00           O  
ATOM   1932  CB  THR A 128      -7.006 -13.210  -5.453  1.00  0.00           C  
ATOM   1933  OG1 THR A 128      -7.359 -12.872  -4.122  1.00  0.00           O  
ATOM   1934  CG2 THR A 128      -8.132 -14.085  -6.012  1.00  0.00           C  
ATOM   1935  H   THR A 128      -4.384 -12.313  -4.989  1.00  0.00           H  
ATOM   1936  HA  THR A 128      -5.743 -14.935  -5.146  1.00  0.00           H  
ATOM   1937  HB  THR A 128      -6.954 -12.299  -6.045  1.00  0.00           H  
ATOM   1938  HG1 THR A 128      -8.062 -12.183  -4.181  1.00  0.00           H  
ATOM   1939 HG21 THR A 128      -9.074 -13.537  -5.968  1.00  0.00           H  
ATOM   1940 HG22 THR A 128      -8.225 -14.997  -5.422  1.00  0.00           H  
ATOM   1941 HG23 THR A 128      -7.931 -14.338  -7.053  1.00  0.00           H  
ATOM   1942  N   SER A 129      -5.276 -14.959  -7.675  1.00  0.00           N  
ATOM   1943  CA  SER A 129      -4.755 -15.098  -9.023  1.00  0.00           C  
ATOM   1944  C   SER A 129      -5.505 -14.062  -9.856  1.00  0.00           C  
ATOM   1945  O   SER A 129      -6.719 -14.184 -10.034  1.00  0.00           O  
ATOM   1946  CB  SER A 129      -4.967 -16.537  -9.500  1.00  0.00           C  
ATOM   1947  OG  SER A 129      -4.307 -17.435  -8.612  1.00  0.00           O  
ATOM   1948  H   SER A 129      -5.938 -15.655  -7.352  1.00  0.00           H  
ATOM   1949  HA  SER A 129      -3.688 -14.871  -9.031  1.00  0.00           H  
ATOM   1950  HB2 SER A 129      -6.034 -16.761  -9.519  1.00  0.00           H  
ATOM   1951  HB3 SER A 129      -4.562 -16.651 -10.507  1.00  0.00           H  
ATOM   1952  HG  SER A 129      -4.952 -18.150  -8.406  1.00  0.00           H  
ATOM   1953  N   GLY A 130      -4.812 -13.018 -10.297  1.00  0.00           N  
ATOM   1954  CA  GLY A 130      -5.359 -11.927 -11.077  1.00  0.00           C  
ATOM   1955  C   GLY A 130      -4.211 -11.135 -11.696  1.00  0.00           C  
ATOM   1956  O   GLY A 130      -3.511 -10.442 -10.951  1.00  0.00           O  
ATOM   1957  H   GLY A 130      -3.812 -12.967 -10.129  1.00  0.00           H  
ATOM   1958  HA2 GLY A 130      -6.046 -12.310 -11.830  1.00  0.00           H  
ATOM   1959  HA3 GLY A 130      -5.907 -11.267 -10.407  1.00  0.00           H  
ATOM   1960  N   PRO A 131      -3.955 -11.270 -13.009  1.00  0.00           N  
ATOM   1961  CA  PRO A 131      -2.891 -10.538 -13.681  1.00  0.00           C  
ATOM   1962  C   PRO A 131      -3.321  -9.077 -13.889  1.00  0.00           C  
ATOM   1963  O   PRO A 131      -4.511  -8.753 -13.821  1.00  0.00           O  
ATOM   1964  CB  PRO A 131      -2.710 -11.271 -15.013  1.00  0.00           C  
ATOM   1965  CG  PRO A 131      -4.126 -11.735 -15.346  1.00  0.00           C  
ATOM   1966  CD  PRO A 131      -4.707 -12.068 -13.971  1.00  0.00           C  
ATOM   1967  HA  PRO A 131      -1.968 -10.578 -13.100  1.00  0.00           H  
ATOM   1968  HB2 PRO A 131      -2.294 -10.630 -15.793  1.00  0.00           H  
ATOM   1969  HB3 PRO A 131      -2.080 -12.146 -14.861  1.00  0.00           H  
ATOM   1970  HG2 PRO A 131      -4.687 -10.916 -15.797  1.00  0.00           H  
ATOM   1971  HG3 PRO A 131      -4.121 -12.606 -16.004  1.00  0.00           H  
ATOM   1972  HD2 PRO A 131      -5.768 -11.816 -13.948  1.00  0.00           H  
ATOM   1973  HD3 PRO A 131      -4.564 -13.126 -13.751  1.00  0.00           H  
ATOM   1974  N   SER A 132      -2.364  -8.206 -14.209  1.00  0.00           N  
ATOM   1975  CA  SER A 132      -2.629  -6.787 -14.437  1.00  0.00           C  
ATOM   1976  C   SER A 132      -1.710  -6.149 -15.488  1.00  0.00           C  
ATOM   1977  O   SER A 132      -1.843  -4.953 -15.759  1.00  0.00           O  
ATOM   1978  CB  SER A 132      -2.612  -6.050 -13.090  1.00  0.00           C  
ATOM   1979  OG  SER A 132      -1.471  -6.355 -12.305  1.00  0.00           O  
ATOM   1980  H   SER A 132      -1.403  -8.515 -14.248  1.00  0.00           H  
ATOM   1981  HA  SER A 132      -3.638  -6.687 -14.839  1.00  0.00           H  
ATOM   1982  HB2 SER A 132      -2.666  -4.975 -13.262  1.00  0.00           H  
ATOM   1983  HB3 SER A 132      -3.494  -6.355 -12.528  1.00  0.00           H  
ATOM   1984  HG  SER A 132      -1.545  -5.824 -11.483  1.00  0.00           H  
ATOM   1985  N   SER A 133      -0.759  -6.891 -16.065  1.00  0.00           N  
ATOM   1986  CA  SER A 133       0.132  -6.357 -17.086  1.00  0.00           C  
ATOM   1987  C   SER A 133      -0.589  -6.341 -18.449  1.00  0.00           C  
ATOM   1988  O   SER A 133      -1.786  -6.607 -18.580  1.00  0.00           O  
ATOM   1989  CB  SER A 133       1.439  -7.177 -17.114  1.00  0.00           C  
ATOM   1990  OG  SER A 133       2.505  -6.453 -17.721  1.00  0.00           O  
ATOM   1991  H   SER A 133      -0.662  -7.868 -15.828  1.00  0.00           H  
ATOM   1992  HA  SER A 133       0.384  -5.330 -16.817  1.00  0.00           H  
ATOM   1993  HB2 SER A 133       1.734  -7.404 -16.090  1.00  0.00           H  
ATOM   1994  HB3 SER A 133       1.280  -8.119 -17.641  1.00  0.00           H  
ATOM   1995  HG  SER A 133       2.613  -6.747 -18.642  1.00  0.00           H  
ATOM   1996  N   GLY A 134       0.188  -5.998 -19.464  1.00  0.00           N  
ATOM   1997  CA  GLY A 134      -0.069  -5.877 -20.882  1.00  0.00           C  
ATOM   1998  C   GLY A 134       1.291  -5.559 -21.492  1.00  0.00           C  
ATOM   1999  O   GLY A 134       1.346  -4.995 -22.594  1.00  0.00           O  
ATOM   2000  H   GLY A 134       1.161  -5.792 -19.273  1.00  0.00           H  
ATOM   2001  HA2 GLY A 134      -0.448  -6.816 -21.287  1.00  0.00           H  
ATOM   2002  HA3 GLY A 134      -0.774  -5.071 -21.080  1.00  0.00           H  
TER    2003      GLY A 134                                                      
END
MOLECULE T0411.pdb
ATOM      1  N   SER    20      23.383  16.708  14.252  0.80 17.27           N  
ATOM      2  CA  SER    20      23.666  15.746  13.160  0.80 15.92           C  
ATOM      3  C   SER    20      22.476  15.495  12.278  0.80 13.44           C  
ATOM      4  O   SER    20      21.317  15.511  12.700  0.80 15.60           O  
ATOM      5  CB  SER    20      24.215  14.417  13.698  0.80 17.48           C  
ATOM      6  OG  SER    20      23.257  13.716  14.438  0.80 22.08           O  
ATOM      7  N   ASN    21      22.790  15.226  11.033  0.80 11.57           N  
ATOM      8  CA  ASN    21      21.799  14.886  10.050  0.80 10.66           C  
ATOM      9  C   ASN    21      21.016  13.672  10.572  0.80 10.50           C  
ATOM     10  O   ASN    21      21.625  12.772  11.156  0.80 12.22           O  
ATOM     11  CB  ASN    21      22.527  14.565   8.733  0.80 10.39           C  
ATOM     12  CG  ASN    21      21.644  14.679   7.510  0.80 10.55           C  
ATOM     13  OD1 ASN    21      21.440  15.758   7.041  0.80 12.42           O  
ATOM     14  ND2 ASN    21      21.075  13.574   7.057  0.80 13.97           N  
ATOM     15  N   ILE    22      19.702  13.612  10.337  1.00 10.95           N  
ATOM     16  CA  ILE    22      18.928  12.460  10.733  1.00 11.03           C  
ATOM     17  C   ILE    22      19.511  11.260   9.987  1.00  9.32           C  
ATOM     18  O   ILE    22      19.727  11.303   8.764  1.00 10.99           O  
ATOM     19  CB  ILE    22      17.457  12.632  10.369  1.00 11.59           C  
ATOM     20  CG1 ILE    22      16.804  13.845  11.054  1.00 13.57           C  
ATOM     21  CG2 ILE    22      16.692  11.323  10.585  1.00 11.49           C  
ATOM     22  CD1 ILE    22      15.526  14.302  10.345  1.00 14.59           C  
ATOM     23  N   GLN    23      19.722  10.205  10.701  1.00 10.03           N  
ATOM     24  CA  GLN    23      20.202   9.026  10.107  1.00  7.97           C  
ATOM     25  C   GLN    23      19.164   8.505   9.136  1.00  6.39           C  
ATOM     26  O   GLN    23      17.996   8.376   9.487  1.00  8.10           O  
ATOM     27  CB  GLN    23      20.434   7.978  11.189  1.00 10.93           C  
ATOM     28  CG  GLN    23      20.924   6.641  10.664  1.00 14.01           C  
ATOM     29  CD  GLN    23      22.276   6.695   9.980  1.00 17.14           C  
ATOM     30  OE1 GLN    23      22.415   6.425   8.780  1.00 22.09           O  
ATOM     31  NE2 GLN    23      23.286   7.076  10.734  1.00 21.70           N  
ATOM     32  N   SER    24      19.580   8.181   7.926  1.00  6.02           N  
ATOM     33  CA  SER    24      18.730   7.632   6.909  0.50  5.38           C  
ATOM     35  C   SER    24      19.314   6.309   6.403  1.00  5.20           C  
ATOM     36  O   SER    24      20.540   6.139   6.354  1.00  6.34           O  
ATOM     37  CB  SER    24      18.620   8.604   5.752  0.50  6.73           C  
ATOM     39  OG  SER    24      19.903   8.982   5.331  0.50  6.31           O  
ATOM     41  N   TYR    25      18.430   5.409   5.975  1.00  4.90           N  
ATOM     42  CA  TYR    25      18.808   4.061   5.582  1.00  4.36           C  
ATOM     43  C   TYR    25      18.307   3.735   4.175  1.00  4.30           C  
ATOM     44  O   TYR    25      17.151   4.018   3.830  1.00  4.70           O  
ATOM     45  CB  TYR    25      18.244   3.055   6.559  1.00  4.48           C  
ATOM     46  CG  TYR    25      18.793   3.226   7.967  1.00  4.25           C  
ATOM     47  CD1 TYR    25      20.157   3.141   8.226  1.00  4.90           C  
ATOM     48  CD2 TYR    25      17.959   3.440   9.028  1.00  5.20           C  
ATOM     49  CE1 TYR    25      20.662   3.254   9.519  1.00  5.78           C  
ATOM     50  CE2 TYR    25      18.462   3.530  10.349  1.00  5.38           C  
ATOM     51  CZ  TYR    25      19.818   3.453  10.577  1.00  5.83           C  
ATOM     52  OH  TYR    25      20.352   3.513  11.834  1.00  7.58           O  
ATOM     53  N   SER    26      19.164   3.101   3.384  1.00  4.64           N  
ATOM     54  CA  SER    26      18.810   2.501   2.107  1.00  4.76           C  
ATOM     55  C   SER    26      18.144   1.145   2.296  1.00  4.12           C  
ATOM     56  O   SER    26      18.123   0.572   3.389  1.00  4.46           O  
ATOM     57  CB  SER    26      20.068   2.275   1.296  1.00  5.25           C  
ATOM     58  OG  SER    26      20.846   1.281   1.938  1.00  5.71           O  
ATOM     59  N   PHE    27      17.684   0.566   1.199  1.00  4.20           N  
ATOM     60  CA  PHE    27      17.183  -0.814   1.228  1.00  4.85           C  
ATOM     61  C   PHE    27      18.203  -1.781   1.840  1.00  4.15           C  
ATOM     62  O   PHE    27      17.863  -2.567   2.715  1.00  4.54           O  
ATOM     63  CB  PHE    27      16.840  -1.289  -0.187  1.00  4.65           C  
ATOM     64  CG  PHE    27      16.405  -2.720  -0.195  1.00  4.75           C  
ATOM     65  CD1 PHE    27      15.200  -3.108   0.378  1.00  5.63           C  
ATOM     66  CD2 PHE    27      17.199  -3.718  -0.775  1.00  5.22           C  
ATOM     67  CE1 PHE    27      14.812  -4.423   0.418  1.00  6.31           C  
ATOM     68  CE2 PHE    27      16.798  -5.031  -0.764  1.00  6.95           C  
ATOM     69  CZ  PHE    27      15.581  -5.385  -0.175  1.00  6.90           C  
ATOM     70  N   GLU    28      19.449  -1.741   1.365  1.00  4.46           N  
ATOM     71  CA  GLU    28      20.433  -2.657   1.884  1.00  4.55           C  
ATOM     72  C   GLU    28      20.686  -2.438   3.365  1.00  4.97           C  
ATOM     73  O   GLU    28      20.864  -3.396   4.146  1.00  5.45           O  
ATOM     74  CB  GLU    28      21.728  -2.584   1.075  1.00  5.35           C  
ATOM     75  CG  GLU    28      21.576  -3.230  -0.271  1.00  8.61           C  
ATOM     76  CD  GLU    28      21.516  -4.793  -0.207  1.00  7.80           C  
ATOM     77  OE1 GLU    28      22.246  -5.318   0.605  1.00 10.36           O  
ATOM     78  OE2 GLU    28      20.795  -5.361  -1.051  1.00 10.99           O  
ATOM     79  N   ASP    29      20.690  -1.170   3.804  1.00  4.63           N  
ATOM     80  CA  ASP    29      20.816  -0.894   5.215  1.00  5.09           C  
ATOM     81  C   ASP    29      19.659  -1.511   6.021  1.00  4.66           C  
ATOM     82  O   ASP    29      19.885  -2.069   7.101  1.00  5.52           O  
ATOM     83  CB  ASP    29      20.792   0.610   5.459  1.00  5.73           C  
ATOM     84  CG  ASP    29      21.998   1.390   4.943  1.00  5.96           C  
ATOM     85  OD1 ASP    29      23.097   0.801   4.810  1.00  9.45           O  
ATOM     86  OD2 ASP    29      21.791   2.606   4.675  1.00  6.58           O  
ATOM     87  N   MET    30      18.438  -1.378   5.486  1.00  4.52           N  
ATOM     88  CA  MET    30      17.275  -1.926   6.170  1.00  4.57           C  
ATOM     89  C   MET    30      17.290  -3.442   6.216  1.00  4.62           C  
ATOM     90  O   MET    30      16.909  -4.031   7.218  1.00  5.57           O  
ATOM     91  CB  MET    30      15.990  -1.409   5.534  1.00  4.62           C  
ATOM     92  CG  MET    30      15.744   0.062   5.760  1.00  4.73           C  
ATOM     93  SD  MET    30      15.580   0.571   7.603  0.90  5.90          SE  
ATOM     94  CE  MET    30      13.979  -0.293   7.946  1.00 10.68           C  
ATOM     95  N   LYS    31      17.771  -4.079   5.165  0.50  4.72           N  
ATOM     97  CA  LYS    31      17.941  -5.503   5.166  0.25  5.00           C  
ATOM    100  C   LYS    31      18.911  -5.892   6.320  0.50  4.65           C  
ATOM    102  O   LYS    31      18.659  -6.843   7.086  0.50  5.54           O  
ATOM    104  CB  LYS    31      18.436  -5.931   3.780  0.25  5.09           C  
ATOM    107  CG  LYS    31      18.633  -7.408   3.587  0.25  4.45           C  
ATOM    110  CD  LYS    31      19.621  -7.678   2.406  0.25  5.89           C  
ATOM    113  CE  LYS    31      18.982  -7.379   1.062  0.25  5.98           C  
ATOM    116  NZ  LYS    31      19.966  -7.513  -0.063  0.25  4.92           N  
ATOM    119  N   ARG    32      20.016  -5.189   6.457  0.80  5.55           N  
ATOM    121  CA  ARG    32      20.906  -5.475   7.551  0.80  7.17           C  
ATOM    123  C   ARG    32      20.232  -5.309   8.893  0.80  6.23           C  
ATOM    125  O   ARG    32      20.276  -6.181   9.765  0.80  7.14           O  
ATOM    127  CB  ARG    32      22.169  -4.635   7.440  0.80  8.36           C  
ATOM    129  CG  ARG    32      23.095  -5.165   6.360  0.80 11.35           C  
ATOM    131  CD  ARG    32      24.391  -4.363   6.278  0.80 15.69           C  
ATOM    133  NE  ARG    32      24.132  -3.113   5.578  0.80 22.23           N  
ATOM    135  CZ  ARG    32      24.689  -2.712   4.435  0.80 21.88           C  
ATOM    137  NH1 ARG    32      24.317  -1.537   3.898  0.80 19.62           N  
ATOM    139  NH2 ARG    32      25.626  -3.443   3.842  0.80 24.64           N  
ATOM    141  N   ILE    33      19.520  -4.204   9.045  1.00  5.62           N  
ATOM    142  CA  ILE    33      18.872  -3.915  10.333  1.00  5.84           C  
ATOM    143  C   ILE    33      17.838  -4.978  10.666  1.00  5.82           C  
ATOM    144  O   ILE    33      17.810  -5.485  11.796  1.00  6.61           O  
ATOM    145  CB  ILE    33      18.279  -2.507  10.301  1.00  6.44           C  
ATOM    146  CG1 ILE    33      19.414  -1.505  10.308  1.00  7.28           C  
ATOM    147  CG2 ILE    33      17.317  -2.274  11.453  1.00  8.16           C  
ATOM    148  CD1 ILE    33      18.996  -0.081   9.899  1.00  8.84           C  
ATOM    149  N   VAL    34      16.990  -5.341   9.707  1.00  5.88           N  
ATOM    150  CA  VAL    34      16.002  -6.368   9.967  1.00  6.66           C  
ATOM    151  C   VAL    34      16.670  -7.668  10.385  1.00  6.17           C  
ATOM    152  O   VAL    34      16.259  -8.310  11.351  1.00  7.34           O  
ATOM    153  CB  VAL    34      15.074  -6.537   8.746  1.00  7.43           C  
ATOM    154  CG1 VAL    34      14.163  -7.763   8.914  1.00  9.58           C  
ATOM    155  CG2 VAL    34      14.239  -5.264   8.563  1.00  8.70           C  
ATOM    156  N   GLY    35      17.738  -8.033   9.671  1.00  6.43           N  
ATOM    157  CA  GLY    35      18.439  -9.261   9.977  1.00  6.66           C  
ATOM    158  C   GLY    35      19.162  -9.306  11.311  1.00  6.57           C  
ATOM    159  O   GLY    35      19.486 -10.374  11.803  1.00  8.37           O  
ATOM    160  N   LYS    36      19.460  -8.140  11.881  1.00  6.29           N  
ATOM    161  CA  LYS    36      20.074  -8.045  13.201  0.25  6.74           C  
ATOM    164  C   LYS    36      19.111  -8.321  14.326  1.00  7.11           C  
ATOM    165  O   LYS    36      19.523  -8.692  15.430  1.00  8.42           O  
ATOM    166  CB  LYS    36      20.649  -6.659  13.450  0.25  7.30           C  
ATOM    169  CG  LYS    36      21.870  -6.372  12.639  0.25  7.35           C  
ATOM    172  CD  LYS    36      22.234  -4.913  12.683  0.25  7.90           C  
ATOM    175  CE  LYS    36      22.881  -4.526  14.003  0.25  6.97           C  
ATOM    178  NZ  LYS    36      23.143  -3.054  13.963  0.25  7.30           N  
ATOM    181  N   HIS    37      17.826  -8.110  14.096  1.00  7.61           N  
ATOM    182  CA  HIS    37      16.828  -8.314  15.165  1.00  8.62           C  
ATOM    183  C   HIS    37      17.270  -7.588  16.434  1.00  7.84           C  
ATOM    184  O   HIS    37      17.249  -8.164  17.524  1.00  8.43           O  
ATOM    185  CB  HIS    37      16.586  -9.818  15.436  1.00 10.04           C  
ATOM    186  CG  HIS    37      16.065 -10.524  14.232  1.00 11.70           C  
ATOM    187  ND1 HIS    37      14.752 -10.435  13.832  1.00 17.45           N  
ATOM    188  CD2 HIS    37      16.693 -11.224  13.259  1.00 12.70           C  
ATOM    189  CE1 HIS    37      14.590 -11.111  12.703  1.00 17.15           C  
ATOM    190  NE2 HIS    37      15.756 -11.604  12.337  1.00 14.42           N  
ATOM    191  N   ASP    38      17.670  -6.339  16.335  1.00  8.59           N  
ATOM    192  CA  ASP    38      18.203  -5.607  17.459  1.00  8.40           C  
ATOM    193  C   ASP    38      17.066  -5.247  18.402  1.00  8.57           C  
ATOM    194  O   ASP    38      16.109  -4.578  18.000  1.00  8.80           O  
ATOM    195  CB  ASP    38      18.850  -4.368  16.870  1.00 11.30           C  
ATOM    196  CG  ASP    38      19.619  -3.582  17.830  1.00 14.90           C  
ATOM    197  OD1 ASP    38      19.305  -3.575  19.031  1.00 13.89           O  
ATOM    198  OD2 ASP    38      20.525  -2.882  17.308  1.00 20.42           O  
ATOM    199  N   PRO    39      17.161  -5.670  19.671  1.00  9.42           N  
ATOM    200  CA  PRO    39      16.081  -5.410  20.604  1.00 10.88           C  
ATOM    201  C   PRO    39      15.866  -3.959  20.898  1.00 10.52           C  
ATOM    202  O   PRO    39      14.815  -3.569  21.460  1.00 13.03           O  
ATOM    203  CB  PRO    39      16.529  -6.159  21.854  1.00 11.33           C  
ATOM    204  CG  PRO    39      17.990  -6.224  21.786  1.00 12.34           C  
ATOM    205  CD  PRO    39      18.248  -6.420  20.316  1.00 11.01           C  
ATOM    206  N   ASN    40      16.849  -3.128  20.572  1.00  9.50           N  
ATOM    207  CA  ASN    40      16.758  -1.718  20.866  0.70  9.40           C  
ATOM    209  C   ASN    40      16.493  -0.844  19.622  1.00  8.33           C  
ATOM    210  O   ASN    40      16.728   0.358  19.653  1.00  8.99           O  
ATOM    211  CB  ASN    40      17.923  -1.351  21.740  0.70 11.15           C  
ATOM    213  CG  ASN    40      17.781  -1.941  23.175  0.70 12.91           C  
ATOM    215  OD1 ASN    40      16.695  -1.927  23.785  0.70 16.59           O  
ATOM    217  ND2 ASN    40      18.874  -2.447  23.692  0.70 19.60           N  
ATOM    219  N   VAL    41      15.951  -1.474  18.588  1.00  6.99           N  
ATOM    220  CA  VAL    41      15.496  -0.806  17.374  1.00  7.02           C  
ATOM    221  C   VAL    41      14.005  -1.096  17.203  1.00  5.94           C  
ATOM    222  O   VAL    41      13.545  -2.232  17.442  1.00  8.12           O  
ATOM    223  CB  VAL    41      16.280  -1.295  16.174  1.00  8.84           C  
ATOM    224  CG1 VAL    41      15.632  -0.818  14.857  1.00 11.68           C  
ATOM    225  CG2 VAL    41      17.745  -0.854  16.309  1.00 11.84           C  
ATOM    226  N   VAL    42      13.245  -0.066  16.842  1.00  5.37           N  
ATOM    227  CA  VAL    42      11.829  -0.165  16.581  1.00  5.48           C  
ATOM    228  C   VAL    42      11.588   0.308  15.157  1.00  4.86           C  
ATOM    229  O   VAL    42      12.012   1.394  14.793  1.00  5.55           O  
ATOM    230  CB  VAL    42      11.003   0.700  17.548  1.00  6.60           C  
ATOM    231  CG1 VAL    42       9.512   0.573  17.290  1.00  8.10           C  
ATOM    232  CG2 VAL    42      11.329   0.348  19.012  1.00  8.91           C  
ATOM    233  N   LEU    43      10.860  -0.510  14.397  0.50  4.63           N  
ATOM    235  CA  LEU    43      10.520  -0.219  12.994  0.50  4.37           C  
ATOM    237  C   LEU    43       9.110   0.354  12.991  0.50  3.98           C  
ATOM    239  O   LEU    43       8.134  -0.360  13.243  0.50  5.19           O  
ATOM    241  CB  LEU    43      10.568  -1.505  12.162  0.50  4.41           C  
ATOM    243  CG  LEU    43      11.927  -2.221  12.180  0.50  5.41           C  
ATOM    245  CD1 LEU    43      11.875  -3.496  11.343  0.50  8.93           C  
ATOM    247  CD2 LEU    43      13.037  -1.314  11.712  0.50  8.67           C  
ATOM    249  N   VAL    44       9.000   1.652  12.736  1.00  4.06           N  
ATOM    250  CA  VAL    44       7.740   2.378  12.881  1.00  4.25           C  
ATOM    251  C   VAL    44       7.147   2.669  11.506  1.00  3.95           C  
ATOM    252  O   VAL    44       7.555   3.581  10.806  1.00  4.41           O  
ATOM    253  CB  VAL    44       7.902   3.677  13.657  1.00  4.88           C  
ATOM    254  CG1 VAL    44       6.529   4.262  13.921  1.00  5.95           C  
ATOM    255  CG2 VAL    44       8.673   3.463  14.990  1.00  6.06           C  
ATOM    256  N   ASP    45       6.151   1.846  11.156  1.00  3.90           N  
ATOM    257  CA  ASP    45       5.442   1.950   9.890  1.00  3.71           C  
ATOM    258  C   ASP    45       4.191   2.777  10.142  1.00  3.91           C  
ATOM    259  O   ASP    45       3.299   2.388  10.900  1.00  4.37           O  
ATOM    260  CB  ASP    45       5.090   0.528   9.423  1.00  3.86           C  
ATOM    261  CG  ASP    45       4.448   0.448   8.065  1.00  4.16           C  
ATOM    262  OD1 ASP    45       3.766   1.386   7.622  1.00  4.52           O  
ATOM    263  OD2 ASP    45       4.619  -0.635   7.445  1.00  5.13           O  
ATOM    264  N   VAL    46       4.143   3.959   9.534  1.00  3.64           N  
ATOM    265  CA  VAL    46       3.064   4.909   9.809  1.00  3.77           C  
ATOM    266  C   VAL    46       2.029   4.957   8.685  1.00  4.00           C  
ATOM    267  O   VAL    46       1.222   5.882   8.626  1.00  4.07           O  
ATOM    268  CB  VAL    46       3.598   6.308  10.187  1.00  4.06           C  
ATOM    269  CG1 VAL    46       4.585   6.189  11.327  1.00  4.83           C  
ATOM    270  CG2 VAL    46       4.204   7.057   9.036  1.00  4.55           C  
ATOM    271  N   ARG    47       2.003   3.935   7.839  1.00  3.76           N  
ATOM    272  CA  ARG    47       0.884   3.772   6.921  1.00  3.93           C  
ATOM    273  C   ARG    47      -0.412   3.481   7.693  1.00  3.94           C  
ATOM    274  O   ARG    47      -0.403   3.207   8.893  1.00  4.15           O  
ATOM    275  CB  ARG    47       1.188   2.654   5.923  1.00  4.16           C  
ATOM    276  CG  ARG    47       2.367   2.950   5.015  1.00  4.41           C  
ATOM    277  CD  ARG    47       2.700   1.812   4.070  1.00  4.36           C  
ATOM    278  NE  ARG    47       3.029   0.614   4.852  1.00  4.91           N  
ATOM    279  CZ  ARG    47       2.867  -0.628   4.472  1.00  4.68           C  
ATOM    280  NH1 ARG    47       2.440  -0.932   3.273  1.00  6.72           N  
ATOM    281  NH2 ARG    47       3.136  -1.589   5.344  1.00  5.67           N  
ATOM    282  N   GLU    48      -1.532   3.555   6.981  1.00  4.09           N  
ATOM    283  CA  GLU    48      -2.806   3.203   7.583  1.00  4.53           C  
ATOM    284  C   GLU    48      -2.890   1.692   7.786  1.00  4.44           C  
ATOM    285  O   GLU    48      -2.183   0.927   7.132  1.00  4.87           O  
ATOM    286  CB  GLU    48      -3.978   3.702   6.752  1.00  4.95           C  
ATOM    287  CG  GLU    48      -4.072   5.230   6.741  1.00  5.30           C  
ATOM    288  CD  GLU    48      -4.203   5.796   8.148  1.00  5.46           C  
ATOM    289  OE1 GLU    48      -5.176   5.400   8.836  1.00  7.30           O  
ATOM    290  OE2 GLU    48      -3.321   6.546   8.603  1.00  5.88           O  
ATOM    291  N   PRO    49      -3.765   1.230   8.667  1.00  5.07           N  
ATOM    292  CA  PRO    49      -3.842  -0.216   8.944  1.00  5.88           C  
ATOM    293  C   PRO    49      -4.113  -1.065   7.703  1.00  5.59           C  
ATOM    294  O   PRO    49      -3.590  -2.164   7.577  1.00  6.38           O  
ATOM    295  CB  PRO    49      -4.937  -0.303  10.007  1.00  7.08           C  
ATOM    296  CG  PRO    49      -4.851   1.011  10.738  1.00  6.97           C  
ATOM    297  CD  PRO    49      -4.612   1.988   9.621  1.00  6.19           C  
ATOM    298  N   SER    50      -4.936  -0.567   6.778  1.00  6.07           N  
ATOM    299  CA  SER    50      -5.245  -1.286   5.570  1.00  6.89           C  
ATOM    300  C   SER    50      -4.005  -1.467   4.730  1.00  8.82           C  
ATOM    301  O   SER    50      -3.692  -2.647   4.387  1.00 11.66           O  
ATOM    302  CB  SER    50      -6.402  -0.583   4.864  1.00  8.18           C  
ATOM    303  OG  SER    50      -6.141   0.781   4.672  1.00  9.85           O  
ATOM    304  N   GLU    51      -3.183  -0.409   4.608  1.00  6.34           N  
ATOM    305  CA  GLU    51      -1.884  -0.514   3.894  1.00  6.38           C  
ATOM    306  C   GLU    51      -0.938  -1.517   4.559  1.00  6.84           C  
ATOM    307  O   GLU    51      -0.271  -2.363   3.937  1.00  9.87           O  
ATOM    308  CB  GLU    51      -1.187   0.833   3.816  1.00  6.45           C  
ATOM    309  CG  GLU    51      -1.825   1.884   2.936  1.00  6.93           C  
ATOM    310  CD  GLU    51      -1.213   3.265   3.116  1.00  6.09           C  
ATOM    311  OE1 GLU    51      -1.500   3.925   4.126  1.00  5.52           O  
ATOM    312  OE2 GLU    51      -0.401   3.683   2.254  1.00  7.55           O  
ATOM    313  N   TYR    52      -0.916  -1.495   5.874  0.50  6.32           N  
ATOM    315  CA  TYR    52      -0.057  -2.406   6.644  0.50  6.07           C  
ATOM    317  C   TYR    52      -0.470  -3.849   6.476  0.50  5.86           C  
ATOM    319  O   TYR    52       0.366  -4.768   6.534  0.50  7.51           O  
ATOM    321  CB  TYR    52      -0.144  -1.997   8.110  0.50  6.62           C  
ATOM    323  CG  TYR    52       0.892  -2.603   8.989  0.50  5.83           C  
ATOM    325  CD1 TYR    52       2.105  -1.968   9.173  0.50  6.83           C  
ATOM    327  CD2 TYR    52       0.642  -3.786   9.673  0.50  7.08           C  
ATOM    329  CE1 TYR    52       3.067  -2.478  10.005  0.50  5.81           C  
ATOM    331  CE2 TYR    52       1.565  -4.306  10.531  0.50  6.54           C  
ATOM    333  CZ  TYR    52       2.800  -3.670  10.674  0.50  5.84           C  
ATOM    335  OH  TYR    52       3.723  -4.245  11.535  0.50  7.40           O  
ATOM    337  N   SER    53      -1.764  -4.079   6.330  0.50  5.43           N  
ATOM    339  CA  SER    53      -2.219  -5.414   6.209  0.50  6.90           C  
ATOM    341  C   SER    53      -1.818  -5.969   4.833  0.50  6.17           C  
ATOM    343  O   SER    53      -1.635  -7.185   4.723  0.50  7.67           O  
ATOM    345  CB  SER    53      -3.697  -5.499   6.487  0.50  7.43           C  
ATOM    347  OG  SER    53      -4.418  -4.913   5.460  0.50 13.76           O  
ATOM    349  N   ILE    54      -1.678  -5.142   3.794  0.50  5.58           N  
ATOM    351  CA  ILE    54      -1.227  -5.645   2.484  0.50  5.83           C  
ATOM    353  C   ILE    54       0.166  -6.287   2.599  0.50  5.76           C  
ATOM    355  O   ILE    54       0.397  -7.379   2.078  0.50  6.45           O  
ATOM    357  CB  ILE    54      -1.212  -4.535   1.411  0.50  5.60           C  
ATOM    359  CG1 ILE    54      -2.635  -4.115   1.094  0.50  6.79           C  
ATOM    361  CG2 ILE    54      -0.463  -4.984   0.154  0.50  6.39           C  
ATOM    363  CD1 ILE    54      -2.804  -3.180   1.890  0.50  7.99           C  
ATOM    365  N   VAL    55       1.106  -5.554   3.200  0.50  5.87           N  
ATOM    367  CA  VAL    55       2.442  -6.139   3.379  0.50  7.15           C  
ATOM    369  C   VAL    55       3.172  -5.287   4.420  0.50  5.98           C  
ATOM    371  O   VAL    55       2.966  -4.089   4.462  0.50  7.84           O  
ATOM    373  CB  VAL    55       3.232  -6.295   2.008  0.50  7.51           C  
ATOM    375  CG1 VAL    55       4.737  -6.182   2.192  0.50  7.32           C  
ATOM    377  CG2 VAL    55       2.873  -7.584   1.140  0.50  6.68           C  
ATOM    379  N   HIS    56       4.011  -5.884   5.273  1.00  6.64           N  
ATOM    380  CA  HIS    56       4.737  -5.075   6.240  1.00  5.79           C  
ATOM    381  C   HIS    56       6.027  -5.801   6.574  1.00  6.24           C  
ATOM    382  O   HIS    56       6.199  -6.985   6.280  1.00  9.13           O  
ATOM    383  CB  HIS    56       3.907  -4.718   7.445  1.00  7.71           C  
ATOM    384  CG  HIS    56       3.388  -5.867   8.177  1.00  9.52           C  
ATOM    385  ND1 HIS    56       2.078  -6.258   8.044  1.00 11.75           N  
ATOM    386  CD2 HIS    56       3.958  -6.701   9.075  1.00 12.20           C  
ATOM    387  CE1 HIS    56       1.856  -7.287   8.843  1.00 15.12           C  
ATOM    388  NE2 HIS    56       2.981  -7.576   9.477  1.00 15.99           N  
ATOM    389  N   ILE    57       6.973  -5.068   7.148  1.00  6.13           N  
ATOM    390  CA  ILE    57       8.204  -5.694   7.595  1.00  6.83           C  
ATOM    391  C   ILE    57       7.907  -6.485   8.874  1.00  7.02           C  
ATOM    392  O   ILE    57       7.323  -5.947   9.816  1.00  6.76           O  
ATOM    393  CB  ILE    57       9.320  -4.677   7.801  1.00  7.12           C  
ATOM    394  CG1 ILE    57       9.588  -3.954   6.492  1.00  8.15           C  
ATOM    395  CG2 ILE    57      10.571  -5.370   8.357  1.00  8.78           C  
ATOM    396  CD1 ILE    57      10.670  -2.906   6.578  1.00  9.39           C  
ATOM    397  N   PRO    58       8.313  -7.760   8.977  1.00  9.09           N  
ATOM    398  CA  PRO    58       8.059  -8.494  10.204  1.00 10.43           C  
ATOM    399  C   PRO    58       8.647  -7.782  11.415  1.00 10.46           C  
ATOM    400  O   PRO    58       9.742  -7.269  11.374  1.00 10.73           O  
ATOM    401  CB  PRO    58       8.731  -9.853   9.936  1.00 12.37           C  
ATOM    402  CG  PRO    58       8.691 -10.013   8.501  1.00 13.37           C  
ATOM    403  CD  PRO    58       8.935  -8.605   7.965  1.00 10.81           C  
ATOM    404  N   ALA    59       7.887  -7.805  12.482  1.00 11.11           N  
ATOM    405  CA  ALA    59       8.284  -7.244  13.763  1.00 11.14           C  
ATOM    406  C   ALA    59       8.200  -5.727  13.826  1.00  9.23           C  
ATOM    407  O   ALA    59       8.397  -5.138  14.872  1.00 10.44           O  
ATOM    408  CB  ALA    59       9.698  -7.747  14.216  1.00 13.99           C  
ATOM    409  N   SER    60       7.815  -5.081  12.729  1.00  7.06           N  
ATOM    410  CA  SER    60       7.530  -3.662  12.795  1.00  6.07           C  
ATOM    411  C   SER    60       6.259  -3.429  13.583  1.00  6.01           C  
ATOM    412  O   SER    60       5.460  -4.349  13.789  1.00  8.98           O  
ATOM    413  CB  SER    60       7.393  -3.089  11.398  1.00  5.31           C  
ATOM    414  OG  SER    60       6.289  -3.649  10.675  1.00  5.74           O  
ATOM    415  N   ILE    61       6.068  -2.177  13.976  1.00  5.05           N  
ATOM    416  CA  ILE    61       4.824  -1.719  14.572  1.00  5.46           C  
ATOM    417  C   ILE    61       4.122  -0.783  13.606  1.00  5.12           C  
ATOM    418  O   ILE    61       4.739  -0.193  12.726  1.00  5.56           O  
ATOM    419  CB  ILE    61       5.039  -1.052  15.946  1.00  5.64           C  
ATOM    420  CG1 ILE    61       5.807   0.283  15.839  1.00  5.75           C  
ATOM    421  CG2 ILE    61       5.709  -2.048  16.890  1.00  7.78           C  
ATOM    422  CD1 ILE    61       5.872   1.051  17.154  1.00  6.86           C  
ATOM    423  N   ASN    62       2.803  -0.677  13.767  1.00  4.89           N  
ATOM    424  CA  ASN    62       2.000   0.213  12.928  1.00  4.46           C  
ATOM    425  C   ASN    62       1.446   1.326  13.813  1.00  4.77           C  
ATOM    426  O   ASN    62       0.697   1.089  14.746  1.00  5.91           O  
ATOM    427  CB  ASN    62       0.864  -0.577  12.297  1.00  5.06           C  
ATOM    428  CG  ASN    62       0.015   0.234  11.314  1.00  4.91           C  
ATOM    429  OD1 ASN    62      -1.194  -0.010  11.168  1.00  6.38           O  
ATOM    430  ND2 ASN    62       0.628   1.127  10.556  1.00  5.05           N  
ATOM    431  N   VAL    63       1.838   2.569  13.496  1.00  4.55           N  
ATOM    432  CA  VAL    63       1.373   3.747  14.230  1.00  4.66           C  
ATOM    433  C   VAL    63       0.883   4.753  13.178  1.00  4.33           C  
ATOM    434  O   VAL    63       1.630   5.624  12.737  1.00  4.71           O  
ATOM    435  CB  VAL    63       2.446   4.362  15.135  1.00  5.22           C  
ATOM    436  CG1 VAL    63       1.808   5.465  15.979  1.00  5.91           C  
ATOM    437  CG2 VAL    63       3.073   3.283  16.038  1.00  6.23           C  
ATOM    438  N   PRO    64      -0.344   4.573  12.704  1.00  4.83           N  
ATOM    439  CA  PRO    64      -0.790   5.313  11.517  1.00  4.78           C  
ATOM    440  C   PRO    64      -0.709   6.830  11.660  1.00  4.83           C  
ATOM    441  O   PRO    64      -1.275   7.421  12.588  1.00  6.06           O  
ATOM    442  CB  PRO    64      -2.251   4.860  11.361  1.00  5.14           C  
ATOM    443  CG  PRO    64      -2.277   3.459  11.971  1.00  5.58           C  
ATOM    444  CD  PRO    64      -1.339   3.569  13.143  1.00  5.10           C  
ATOM    445  N   TYR    65      -0.076   7.491  10.670  1.00  5.06           N  
ATOM    446  CA  TYR    65       0.092   8.927  10.739  1.00  5.19           C  
ATOM    447  C   TYR    65      -1.185   9.675  10.355  1.00  5.36           C  
ATOM    448  O   TYR    65      -1.579  10.595  11.046  1.00  7.60           O  
ATOM    449  CB  TYR    65       1.281   9.392   9.895  1.00  5.62           C  
ATOM    450  CG  TYR    65       1.492  10.869  10.029  1.00  6.04           C  
ATOM    451  CD1 TYR    65       2.015  11.401  11.191  1.00  7.21           C  
ATOM    452  CD2 TYR    65       1.139  11.743   9.009  1.00  8.62           C  
ATOM    453  CE1 TYR    65       2.153  12.796  11.360  1.00  9.84           C  
ATOM    454  CE2 TYR    65       1.266  13.094   9.180  1.00 11.40           C  
ATOM    455  CZ  TYR    65       1.774  13.607  10.349  1.00 11.36           C  
ATOM    456  OH  TYR    65       1.900  14.974  10.486  1.00 14.93           O  
ATOM    457  N   ARG    66      -1.813   9.271   9.256  1.00  5.70           N  
ATOM    458  CA  ARG    66      -3.018   9.939   8.772  1.00  5.86           C  
ATOM    459  C   ARG    66      -4.132   9.955   9.817  1.00  6.43           C  
ATOM    460  O   ARG    66      -4.778  10.980  10.033  1.00  7.67           O  
ATOM    461  CB  ARG    66      -3.515   9.278   7.485  1.00  7.66           C  
ATOM    462  CG  ARG    66      -2.882   9.831   6.219  1.00  9.54           C  
ATOM    463  CD  ARG    66      -3.332   9.054   4.992  0.80 10.84           C  
ATOM    464  NE  ARG    66      -4.733   9.306   4.668  0.80 12.36           N  
ATOM    465  CZ  ARG    66      -5.181  10.427   4.111  0.80 14.16           C  
ATOM    466  NH1 ARG    66      -4.337  11.405   3.812  0.80 15.06           N  
ATOM    467  NH2 ARG    66      -6.474  10.570   3.851  0.80 13.94           N  
ATOM    468  N   SER    67      -4.354   8.812  10.457  1.00  5.24           N  
ATOM    469  CA  SER    67      -5.410   8.673  11.435  1.00  6.08           C  
ATOM    470  C   SER    67      -4.985   8.938  12.877  1.00  5.88           C  
ATOM    471  O   SER    67      -5.865   9.124  13.718  1.00  7.16           O  
ATOM    472  CB  SER    67      -6.131   7.357  11.271  1.00  7.36           C  
ATOM    473  OG  SER    67      -5.238   6.289  11.344  1.00  7.49           O  
ATOM    474  N   HIS    68      -3.683   9.001  13.146  1.00  5.81           N  
ATOM    475  CA  HIS    68      -3.166   9.301  14.470  1.00  5.91           C  
ATOM    476  C   HIS    68      -1.916  10.180  14.349  1.00  6.23           C  
ATOM    477  O   HIS    68      -0.826   9.782  14.789  1.00  6.38           O  
ATOM    478  CB  HIS    68      -2.854   8.020  15.266  1.00  6.58           C  
ATOM    479  CG  HIS    68      -4.033   7.179  15.481  1.00  7.46           C  
ATOM    480  ND1 HIS    68      -4.919   7.414  16.510  1.00  9.92           N  
ATOM    481  CD2 HIS    68      -4.511   6.113  14.809  1.00  9.74           C  
ATOM    482  CE1 HIS    68      -5.871   6.505  16.481  1.00 11.96           C  
ATOM    483  NE2 HIS    68      -5.663   5.721  15.446  1.00 12.70           N  
ATOM    484  N   PRO    69      -2.026  11.385  13.790  1.00  6.13           N  
ATOM    485  CA  PRO    69      -0.813  12.188  13.545  1.00  7.07           C  
ATOM    486  C   PRO    69      -0.095  12.626  14.799  1.00  7.79           C  
ATOM    487  O   PRO    69       1.109  12.919  14.777  1.00  8.93           O  
ATOM    488  CB  PRO    69      -1.340  13.372  12.727  1.00  8.41           C  
ATOM    489  CG  PRO    69      -2.792  13.472  13.133  1.00  8.62           C  
ATOM    490  CD  PRO    69      -3.242  12.017  13.256  1.00  6.77           C  
ATOM    491  N   ASP    70      -0.849  12.745  15.889  1.00  7.90           N  
ATOM    492  CA  ASP    70      -0.346  13.087  17.215  1.00  8.22           C  
ATOM    493  C   ASP    70       0.132  11.927  18.035  1.00  7.09           C  
ATOM    494  O   ASP    70       0.483  12.131  19.181  1.00  7.91           O  
ATOM    495  CB  ASP    70      -1.478  13.778  18.044  1.00 10.32           C  
ATOM    496  CG  ASP    70      -2.756  12.887  18.175  1.00 12.66           C  
ATOM    497  OD1 ASP    70      -3.048  11.961  17.282  1.00 14.07           O  
ATOM    498  OD2 ASP    70      -3.526  13.205  19.139  1.00 16.93           O  
ATOM    499  N   ALA    71       0.154  10.710  17.485  1.00  6.89           N  
ATOM    500  CA  ALA    71       0.447   9.557  18.291  1.00  6.32           C  
ATOM    501  C   ALA    71       1.741   9.730  19.085  1.00  6.32           C  
ATOM    502  O   ALA    71       1.769   9.444  20.275  1.00  7.16           O  
ATOM    503  CB  ALA    71       0.578   8.305  17.425  1.00  6.74           C  
ATOM    504  N   PHE    72       2.802  10.196  18.434  1.00  6.20           N  
ATOM    505  CA  PHE    72       4.073  10.262  19.117  1.00  7.02           C  
ATOM    506  C   PHE    72       4.212  11.418  20.090  1.00  7.74           C  
ATOM    507  O   PHE    72       5.256  11.532  20.740  1.00 10.61           O  
ATOM    508  CB  PHE    72       5.243  10.170  18.140  1.00  7.43           C  
ATOM    509  CG  PHE    72       5.489   8.744  17.714  1.00  6.23           C  
ATOM    510  CD1 PHE    72       6.156   7.881  18.577  1.00  7.50           C  
ATOM    511  CD2 PHE    72       4.989   8.235  16.536  1.00  6.47           C  
ATOM    512  CE1 PHE    72       6.307   6.551  18.286  1.00  8.63           C  
ATOM    513  CE2 PHE    72       5.152   6.905  16.222  1.00  7.11           C  
ATOM    514  CZ  PHE    72       5.818   6.051  17.110  1.00  7.95           C  
ATOM    515  N   ALA    73       3.145  12.208  20.247  1.00  7.31           N  
ATOM    516  CA  ALA    73       3.045  13.231  21.275  1.00  7.83           C  
ATOM    517  C   ALA    73       2.231  12.763  22.470  1.00  8.56           C  
ATOM    518  O   ALA    73       2.118  13.492  23.459  1.00 10.70           O  
ATOM    519  CB  ALA    73       2.427  14.503  20.703  1.00  8.88           C  
ATOM    520  N   LEU    74       1.663  11.562  22.436  1.00  8.50           N  
ATOM    521  CA  LEU    74       0.816  11.092  23.525  1.00  8.80           C  
ATOM    522  C   LEU    74       1.620  10.491  24.656  1.00  9.91           C  
ATOM    523  O   LEU    74       2.640   9.858  24.443  1.00 10.83           O  
ATOM    524  CB  LEU    74      -0.150  10.018  22.995  1.00  8.41           C  
ATOM    525  CG  LEU    74      -1.070  10.473  21.874  1.00  8.90           C  
ATOM    526  CD1 LEU    74      -1.903   9.312  21.360  1.00  9.06           C  
ATOM    527  CD2 LEU    74      -1.951  11.640  22.293  1.00 11.36           C  
ATOM    528  N   ASP    75       1.115  10.654  25.867  1.00 11.38           N  
ATOM    529  CA  ASP    75       1.714   9.953  27.007  1.00 12.23           C  
ATOM    530  C   ASP    75       1.473   8.439  26.878  1.00 12.37           C  
ATOM    531  O   ASP    75       0.653   8.004  26.055  1.00 11.95           O  
ATOM    532  CB  ASP    75       1.199  10.509  28.320  1.00 13.44           C  
ATOM    533  CG  ASP    75      -0.207  10.092  28.612  1.00 14.52           C  
ATOM    534  OD1 ASP    75      -0.532   8.884  28.631  1.00 16.72           O  
ATOM    535  OD2 ASP    75      -1.035  10.981  28.899  1.00 19.77           O  
ATOM    536  N   PRO    76       2.218   7.611  27.630  1.00 12.93           N  
ATOM    537  CA  PRO    76       2.115   6.172  27.427  1.00 12.29           C  
ATOM    538  C   PRO    76       0.723   5.586  27.570  1.00 11.45           C  
ATOM    539  O   PRO    76       0.365   4.743  26.799  1.00 11.34           O  
ATOM    540  CB  PRO    76       3.095   5.570  28.451  1.00 14.68           C  
ATOM    541  CG  PRO    76       4.083   6.674  28.688  1.00 16.39           C  
ATOM    542  CD  PRO    76       3.253   7.942  28.619  1.00 14.93           C  
ATOM    543  N   LEU    77      -0.045   6.002  28.562  1.00 10.97           N  
ATOM    544  CA  LEU    77      -1.364   5.431  28.769  0.50 10.50           C  
ATOM    546  C   LEU    77      -2.304   5.801  27.614  1.00  9.42           C  
ATOM    547  O   LEU    77      -3.022   4.952  27.069  1.00 10.45           O  
ATOM    548  CB  LEU    77      -1.905   5.875  30.124  0.50 10.23           C  
ATOM    550  CG  LEU    77      -3.269   5.313  30.499  0.50 10.33           C  
ATOM    552  CD1 LEU    77      -3.195   3.841  30.874  0.50 14.10           C  
ATOM    554  CD2 LEU    77      -3.853   6.131  31.674  0.50 11.65           C  
ATOM    556  N   GLU    78      -2.276   7.058  27.222  1.00  9.30           N  
ATOM    557  CA  GLU    78      -3.131   7.528  26.153  1.00  8.89           C  
ATOM    558  C   GLU    78      -2.703   6.953  24.798  1.00  7.55           C  
ATOM    559  O   GLU    78      -3.558   6.630  23.968  1.00  8.67           O  
ATOM    560  CB  GLU    78      -3.136   9.070  26.108  1.00  9.48           C  
ATOM    561  CG  GLU    78      -4.079   9.689  25.083  1.00  9.79           C  
ATOM    562  CD  GLU    78      -5.572   9.520  25.386  1.00 10.38           C  
ATOM    563  OE1 GLU    78      -5.933   8.992  26.458  1.00 11.33           O  
ATOM    564  OE2 GLU    78      -6.367   9.941  24.556  1.00 13.54           O  
ATOM    565  N   PHE    79      -1.391   6.776  24.603  1.00  7.74           N  
ATOM    566  CA  PHE    79      -0.913   6.141  23.386  1.00  7.31           C  
ATOM    567  C   PHE    79      -1.551   4.750  23.236  1.00  7.50           C  
ATOM    568  O   PHE    79      -2.054   4.388  22.179  1.00  7.68           O  
ATOM    569  CB  PHE    79       0.607   6.044  23.434  1.00  7.67           C  
ATOM    570  CG  PHE    79       1.240   5.532  22.145  1.00  7.10           C  
ATOM    571  CD1 PHE    79       1.872   6.387  21.292  1.00  7.29           C  
ATOM    572  CD2 PHE    79       1.204   4.181  21.839  1.00  6.60           C  
ATOM    573  CE1 PHE    79       2.464   5.922  20.117  1.00  7.50           C  
ATOM    574  CE2 PHE    79       1.787   3.721  20.654  1.00  7.36           C  
ATOM    575  CZ  PHE    79       2.419   4.600  19.803  1.00  6.66           C  
ATOM    576  N   GLU    80      -1.492   3.937  24.285  0.90  8.14           N  
ATOM    578  CA  GLU    80      -2.037   2.611  24.153  0.90  8.94           C  
ATOM    580  C   GLU    80      -3.550   2.654  23.958  0.90  8.49           C  
ATOM    582  O   GLU    80      -4.090   1.869  23.167  0.90  9.26           O  
ATOM    584  CB  GLU    80      -1.626   1.736  25.323  0.90 10.94           C  
ATOM    586  CG  GLU    80      -1.923   0.274  25.125  0.90 12.87           C  
ATOM    588  CD  GLU    80      -3.316  -0.153  25.486  0.90 14.79           C  
ATOM    590  OE1 GLU    80      -4.032   0.611  26.163  0.90 15.76           O  
ATOM    592  OE2 GLU    80      -3.714  -1.266  25.086  0.90 19.69           O  
ATOM    594  N   LYS    81      -4.261   3.592  24.590  1.00  8.78           N  
ATOM    595  CA  LYS    81      -5.687   3.674  24.333  0.50  9.31           C  
ATOM    597  C   LYS    81      -5.995   4.025  22.884  1.00  8.87           C  
ATOM    598  O   LYS    81      -6.964   3.487  22.310  1.00 10.43           O  
ATOM    599  CB  LYS    81      -6.329   4.673  25.282  0.50  9.93           C  
ATOM    601  CG  LYS    81      -6.331   4.204  26.709  0.50 10.96           C  
ATOM    603  CD  LYS    81      -6.819   5.341  27.592  0.50 10.36           C  
ATOM    605  CE  LYS    81      -6.945   4.955  29.026  0.50 12.69           C  
ATOM    607  NZ  LYS    81      -7.100   6.159  29.871  0.50 14.18           N  
ATOM    609  N   GLN    82      -5.227   4.943  22.298  1.00  8.48           N  
ATOM    610  CA  GLN    82      -5.507   5.384  20.963  1.00  9.68           C  
ATOM    611  C   GLN    82      -5.016   4.414  19.894  1.00  9.17           C  
ATOM    612  O   GLN    82      -5.688   4.225  18.883  1.00 11.34           O  
ATOM    613  CB  GLN    82      -4.922   6.776  20.759  1.00  9.86           C  
ATOM    614  CG  GLN    82      -5.607   7.856  21.696  1.00 12.49           C  
ATOM    615  CD  GLN    82      -7.154   8.042  21.566  1.00 12.54           C  
ATOM    616  OE1 GLN    82      -7.666   7.875  20.483  1.00 15.24           O  
ATOM    617  NE2 GLN    82      -7.876   8.429  22.678  1.00 13.84           N  
ATOM    618  N   ILE    83      -3.822   3.860  20.083  1.00  8.72           N  
ATOM    619  CA  ILE    83      -3.164   3.062  19.059  1.00  9.26           C  
ATOM    620  C   ILE    83      -3.360   1.578  19.272  1.00  9.94           C  
ATOM    621  O   ILE    83      -3.348   0.837  18.311  1.00 13.92           O  
ATOM    622  CB  ILE    83      -1.645   3.402  19.021  1.00  9.41           C  
ATOM    623  CG1 ILE    83      -1.436   4.907  18.950  1.00  9.94           C  
ATOM    624  CG2 ILE    83      -0.943   2.713  17.844  1.00 11.05           C  
ATOM    625  CD1 ILE    83      -2.063   5.618  17.779  1.00 12.33           C  
ATOM    626  N   GLY    84      -3.539   1.147  20.507  1.00  9.29           N  
ATOM    627  CA  GLY    84      -3.753  -0.257  20.814  1.00  9.83           C  
ATOM    628  C   GLY    84      -2.526  -1.096  21.078  1.00  8.85           C  
ATOM    629  O   GLY    84      -2.663  -2.302  21.251  1.00 11.00           O  
ATOM    630  N   ILE    85      -1.352  -0.462  21.076  1.00  8.30           N  
ATOM    631  CA  ILE    85      -0.096  -1.089  21.387  1.00  8.21           C  
ATOM    632  C   ILE    85       0.649  -0.160  22.333  1.00  7.46           C  
ATOM    633  O   ILE    85       0.338   1.017  22.432  1.00  8.38           O  
ATOM    634  CB  ILE    85       0.740  -1.363  20.121  1.00  8.29           C  
ATOM    635  CG1 ILE    85       1.120  -0.054  19.416  1.00  9.73           C  
ATOM    636  CG2 ILE    85      -0.003  -2.340  19.247  1.00 10.74           C  
ATOM    637  CD1 ILE    85       2.112  -0.267  18.259  1.00  9.86           C  
ATOM    638  N   PRO    86       1.667  -0.664  23.035  1.00  8.01           N  
ATOM    639  CA  PRO    86       2.420   0.178  23.961  1.00  8.48           C  
ATOM    640  C   PRO    86       3.224   1.241  23.235  1.00  7.80           C  
ATOM    641  O   PRO    86       3.724   1.044  22.119  1.00  8.34           O  
ATOM    642  CB  PRO    86       3.371  -0.806  24.686  1.00  9.49           C  
ATOM    643  CG  PRO    86       2.688  -2.111  24.531  1.00 10.38           C  
ATOM    644  CD  PRO    86       2.083  -2.063  23.155  1.00  9.31           C  
ATOM    645  N   LYS    87       3.379   2.362  23.912  1.00  7.88           N  
ATOM    646  CA  LYS    87       4.205   3.432  23.386  0.80  7.54           C  
ATOM    648  C   LYS    87       5.662   2.981  23.347  1.00  7.42           C  
ATOM    649  O   LYS    87       6.183   2.482  24.333  1.00  9.42           O  
ATOM    650  CB  LYS    87       4.082   4.659  24.274  0.80  8.13           C  
ATOM    652  CG  LYS    87       4.787   5.864  23.700  0.80  8.63           C  
ATOM    654  CD  LYS    87       4.604   7.123  24.546  0.80  9.77           C  
ATOM    656  CE  LYS    87       5.343   8.336  23.983  0.80 10.65           C  
ATOM    658  NZ  LYS    87       5.318   9.490  24.914  0.80 11.03           N  
ATOM    660  N   PRO    88       6.331   3.144  22.204  1.00  7.30           N  
ATOM    661  CA  PRO    88       7.716   2.702  22.136  1.00  7.45           C  
ATOM    662  C   PRO    88       8.601   3.365  23.170  1.00  7.42           C  
ATOM    663  O   PRO    88       8.466   4.563  23.469  1.00  7.76           O  
ATOM    664  CB  PRO    88       8.143   3.094  20.709  1.00  7.68           C  
ATOM    665  CG  PRO    88       6.881   3.004  19.944  1.00  7.88           C  
ATOM    666  CD  PRO    88       5.839   3.552  20.883  1.00  7.34           C  
ATOM    667  N   ASP    89       9.566   2.605  23.642  1.00  7.78           N  
ATOM    668  CA  ASP    89      10.569   3.092  24.598  1.00  8.01           C  
ATOM    669  C   ASP    89      11.435   4.166  23.945  1.00  8.28           C  
ATOM    670  O   ASP    89      12.072   3.906  22.923  1.00  8.32           O  
ATOM    671  CB  ASP    89      11.394   1.859  24.977  1.00  8.92           C  
ATOM    672  CG  ASP    89      12.533   2.113  25.924  1.00 10.72           C  
ATOM    673  OD1 ASP    89      12.864   3.262  26.257  1.00 11.95           O  
ATOM    674  OD2 ASP    89      13.097   1.085  26.356  1.00 14.30           O  
ATOM    675  N   SER    90      11.500   5.358  24.568  1.00  9.48           N  
ATOM    676  CA  SER    90      12.265   6.445  23.983  1.00 10.63           C  
ATOM    677  C   SER    90      13.765   6.240  23.999  1.00  9.42           C  
ATOM    678  O   SER    90      14.475   6.999  23.351  1.00 11.63           O  
ATOM    679  CB  SER    90      11.887   7.770  24.542  1.00 12.89           C  
ATOM    680  OG  SER    90      12.243   7.774  25.888  1.00 16.17           O  
ATOM    681  N   ALA    91      14.256   5.246  24.718  1.00  8.51           N  
ATOM    682  CA  ALA    91      15.673   4.933  24.711  1.00  9.11           C  
ATOM    683  C   ALA    91      16.074   4.196  23.446  1.00  9.07           C  
ATOM    684  O   ALA    91      17.265   4.072  23.186  1.00 11.24           O  
ATOM    685  CB  ALA    91      16.038   4.059  25.935  1.00 11.22           C  
ATOM    686  N   LYS    92      15.119   3.662  22.690  1.00  7.03           N  
ATOM    687  CA  LYS    92      15.414   2.895  21.501  0.80  6.87           C  
ATOM    689  C   LYS    92      15.581   3.804  20.298  1.00  6.20           C  
ATOM    690  O   LYS    92      15.169   4.952  20.297  1.00  7.57           O  
ATOM    691  CB  LYS    92      14.282   1.913  21.255  0.80  6.68           C  
ATOM    693  CG  LYS    92      14.211   0.818  22.325  0.80  7.06           C  
ATOM    695  CD  LYS    92      13.161  -0.217  21.984  0.80  8.08           C  
ATOM    697  CE  LYS    92      12.977  -1.320  23.013  0.80  8.53           C  
ATOM    699  NZ  LYS    92      11.985  -2.316  22.548  0.80 11.35           N  
ATOM    701  N   GLU    93      16.183   3.243  19.247  1.00  5.90           N  
ATOM    702  CA  GLU    93      16.205   3.883  17.943  1.00  5.79           C  
ATOM    703  C   GLU    93      14.889   3.566  17.219  1.00  5.43           C  
ATOM    704  O   GLU    93      14.588   2.397  16.996  1.00  7.19           O  
ATOM    705  CB  GLU    93      17.352   3.361  17.083  1.00  6.18           C  
ATOM    706  CG  GLU    93      17.389   3.990  15.724  1.00  6.50           C  
ATOM    707  CD  GLU    93      18.444   3.443  14.778  1.00  6.24           C  
ATOM    708  OE1 GLU    93      19.138   2.477  15.111  1.00  9.44           O  
ATOM    709  OE2 GLU    93      18.548   3.999  13.660  1.00  8.01           O  
ATOM    710  N   LEU    94      14.129   4.590  16.868  1.00  5.30           N  
ATOM    711  CA  LEU    94      12.891   4.411  16.116  1.00  4.81           C  
ATOM    712  C   LEU    94      13.163   4.809  14.664  1.00  4.73           C  
ATOM    713  O   LEU    94      13.650   5.920  14.412  1.00  5.65           O  
ATOM    714  CB  LEU    94      11.770   5.294  16.661  1.00  5.24           C  
ATOM    715  CG  LEU    94      10.963   4.701  17.820  1.00  5.62           C  
ATOM    716  CD1 LEU    94      11.836   4.382  19.069  1.00  7.25           C  
ATOM    717  CD2 LEU    94       9.819   5.638  18.164  1.00  6.54           C  
ATOM    718  N   ILE    95      12.858   3.911  13.738  1.00  4.22           N  
ATOM    719  CA  ILE    95      13.091   4.118  12.314  1.00  4.07           C  
ATOM    720  C   ILE    95      11.732   4.295  11.644  1.00  3.87           C  
ATOM    721  O   ILE    95      10.928   3.375  11.649  1.00  4.97           O  
ATOM    722  CB  ILE    95      13.833   2.949  11.678  1.00  4.36           C  
ATOM    723  CG1 ILE    95      15.110   2.625  12.432  1.00  5.35           C  
ATOM    724  CG2 ILE    95      14.112   3.267  10.202  1.00  5.16           C  
ATOM    725  CD1 ILE    95      15.873   1.393  11.877  1.00  6.26           C  
ATOM    726  N   PHE    96      11.484   5.473  11.080  1.00  4.13           N  
ATOM    727  CA  PHE    96      10.177   5.827  10.575  1.00  4.04           C  
ATOM    728  C   PHE    96      10.083   5.688   9.061  1.00  4.15           C  
ATOM    729  O   PHE    96      11.003   6.076   8.322  1.00  4.70           O  
ATOM    730  CB  PHE    96       9.885   7.294  10.893  1.00  4.72           C  
ATOM    731  CG  PHE    96       9.654   7.529  12.339  1.00  5.07           C  
ATOM    732  CD1 PHE    96       8.369   7.496  12.872  1.00  6.51           C  
ATOM    733  CD2 PHE    96      10.724   7.742  13.206  1.00  5.56           C  
ATOM    734  CE1 PHE    96       8.177   7.695  14.230  1.00  7.88           C  
ATOM    735  CE2 PHE    96      10.517   7.917  14.571  1.00  6.93           C  
ATOM    736  CZ  PHE    96       9.247   7.863  15.061  1.00  7.62           C  
ATOM    737  N   TYR    97       8.931   5.210   8.592  1.00  3.99           N  
ATOM    738  CA  TYR    97       8.671   5.113   7.146  1.00  3.91           C  
ATOM    739  C   TYR    97       7.169   4.947   6.933  1.00  3.74           C  
ATOM    740  O   TYR    97       6.413   4.602   7.837  1.00  3.98           O  
ATOM    741  CB  TYR    97       9.448   3.952   6.517  1.00  4.23           C  
ATOM    742  CG  TYR    97       9.224   2.625   7.182  1.00  4.19           C  
ATOM    743  CD1 TYR    97       8.214   1.771   6.749  1.00  4.31           C  
ATOM    744  CD2 TYR    97      10.004   2.192   8.242  1.00  4.31           C  
ATOM    745  CE1 TYR    97       7.995   0.562   7.342  1.00  4.59           C  
ATOM    746  CE2 TYR    97       9.792   0.986   8.870  1.00  4.85           C  
ATOM    747  CZ  TYR    97       8.791   0.143   8.414  1.00  4.56           C  
ATOM    748  OH  TYR    97       8.607  -1.063   9.024  1.00  5.52           O  
ATOM    749  N   CYS    98       6.783   5.140   5.676  1.00  3.72           N  
ATOM    750  CA  CYS    98       5.397   4.924   5.250  1.00  3.59           C  
ATOM    751  C   CYS    98       5.423   4.123   3.933  1.00  3.45           C  
ATOM    752  O   CYS    98       5.981   3.034   3.901  1.00  3.84           O  
ATOM    753  CB  CYS    98       4.589   6.248   5.230  1.00  4.07           C  
ATOM    754  SG  CYS    98       5.270   7.526   4.165  1.00  4.60           S  
ATOM    755  N   ALA    99       4.783   4.671   2.880  1.00  3.83           N  
ATOM    756  CA  ALA    99       4.796   4.067   1.537  1.00  3.72           C  
ATOM    757  C   ALA    99       5.854   4.781   0.691  1.00  3.81           C  
ATOM    758  O   ALA    99       6.824   4.156   0.284  1.00  4.15           O  
ATOM    759  CB  ALA    99       3.424   4.128   0.902  1.00  5.74           C  
ATOM    760  N   SER   100       5.676   6.088   0.457  1.00  4.26           N  
ATOM    761  CA  SER   100       6.620   6.835  -0.338  1.00  4.84           C  
ATOM    762  C   SER   100       7.540   7.758   0.462  1.00  4.52           C  
ATOM    763  O   SER   100       8.467   8.328  -0.107  1.00  5.77           O  
ATOM    764  CB  SER   100       5.938   7.644  -1.446  1.00  6.55           C  
ATOM    765  OG  SER   100       5.015   8.529  -0.959  1.00  8.80           O  
ATOM    766  N   GLY   101       7.314   7.906   1.771  1.00  4.88           N  
ATOM    767  CA  GLY   101       8.192   8.612   2.672  1.00  5.06           C  
ATOM    768  C   GLY   101       7.637   9.843   3.357  1.00  4.71           C  
ATOM    769  O   GLY   101       8.158  10.230   4.392  1.00  5.18           O  
ATOM    770  N   LYS   102       6.632  10.512   2.802  1.00  5.31           N  
ATOM    771  CA  LYS   102       6.226  11.814   3.373  1.00  6.25           C  
ATOM    772  C   LYS   102       5.700  11.667   4.789  1.00  5.42           C  
ATOM    773  O   LYS   102       6.060  12.433   5.699  1.00  6.42           O  
ATOM    774  CB  LYS   102       5.200  12.508   2.515  1.00  8.24           C  
ATOM    775  CG  LYS   102       4.808  13.881   3.067  1.00 10.22           C  
ATOM    776  CD  LYS   102       3.960  14.679   2.127  0.50 10.43           C  
ATOM    777  CE  LYS   102       3.301  15.880   2.790  0.50 13.54           C  
ATOM    778  NZ  LYS   102       2.750  16.816   1.809  0.50 16.32           N  
ATOM    779  N   ARG   103       4.762  10.724   4.983  1.00  4.79           N  
ATOM    780  CA  ARG   103       4.191  10.545   6.297  1.00  4.54           C  
ATOM    781  C   ARG   103       5.241  10.072   7.294  1.00  4.28           C  
ATOM    782  O   ARG   103       5.224  10.482   8.458  1.00  5.11           O  
ATOM    783  CB  ARG   103       3.024   9.571   6.249  1.00  4.67           C  
ATOM    784  CG  ARG   103       1.852  10.087   5.414  1.00  5.46           C  
ATOM    785  CD  ARG   103       0.837   9.001   5.183  1.00  5.48           C  
ATOM    786  NE  ARG   103       1.316   7.999   4.254  1.00  5.57           N  
ATOM    787  CZ  ARG   103       0.726   6.850   3.969  1.00  5.15           C  
ATOM    788  NH1 ARG   103      -0.286   6.420   4.709  1.00  4.82           N  
ATOM    789  NH2 ARG   103       1.152   6.098   2.963  1.00  6.22           N  
ATOM    790  N   GLY   104       6.137   9.177   6.867  1.00  4.65           N  
ATOM    791  CA  GLY   104       7.238   8.775   7.731  1.00  4.55           C  
ATOM    792  C   GLY   104       8.055   9.972   8.228  1.00  4.53           C  
ATOM    793  O   GLY   104       8.400  10.055   9.396  1.00  5.29           O  
ATOM    794  N   GLY   105       8.347  10.892   7.330  1.00  4.88           N  
ATOM    795  CA  GLY   105       9.103  12.061   7.706  1.00  5.31           C  
ATOM    796  C   GLY   105       8.352  12.934   8.699  1.00  5.73           C  
ATOM    797  O   GLY   105       8.940  13.479   9.652  1.00  6.59           O  
ATOM    798  N   GLU   106       7.047  13.085   8.492  1.00  5.79           N  
ATOM    799  CA  GLU   106       6.205  13.877   9.404  0.50  5.78           C  
ATOM    801  C   GLU   106       6.175  13.251  10.786  1.00  6.15           C  
ATOM    802  O   GLU   106       6.249  13.937  11.814  1.00  6.87           O  
ATOM    803  CB  GLU   106       4.765  13.993   8.877  0.50  6.72           C  
ATOM    805  CG  GLU   106       4.634  14.891   7.660  0.50  8.74           C  
ATOM    807  CD  GLU   106       5.250  16.297   7.896  0.50 14.10           C  
ATOM    809  OE1 GLU   106       4.916  16.926   8.912  0.50 16.14           O  
ATOM    811  OE2 GLU   106       6.111  16.740   7.110  0.50 19.81           O  
ATOM    813  N   ALA   107       5.983  11.939  10.825  1.00  5.63           N  
ATOM    814  CA  ALA   107       5.923  11.239  12.109  1.00  5.97           C  
ATOM    815  C   ALA   107       7.241  11.310  12.844  1.00  5.28           C  
ATOM    816  O   ALA   107       7.269  11.486  14.078  1.00  6.07           O  
ATOM    817  CB  ALA   107       5.495   9.790  11.883  1.00  5.83           C  
ATOM    818  N   GLN   108       8.352  11.222  12.129  1.00  5.35           N  
ATOM    819  CA  GLN   108       9.671  11.355  12.746  0.70  5.95           C  
ATOM    821  C   GLN   108       9.785  12.708  13.434  1.00  6.34           C  
ATOM    822  O   GLN   108      10.346  12.803  14.531  1.00  7.57           O  
ATOM    823  CB  GLN   108      10.782  11.166  11.705  0.70  5.79           C  
ATOM    825  CG  GLN   108      12.180  11.200  12.277  0.70  6.62           C  
ATOM    827  CD  GLN   108      12.804  12.599  12.514  0.70  7.05           C  
ATOM    829  OE1 GLN   108      13.714  12.746  13.386  0.70  9.86           O  
ATOM    831  NE2 GLN   108      12.353  13.592  11.818  0.70  6.57           N  
ATOM    833  N   LYS   109       9.268  13.749  12.815  1.00  6.66           N  
ATOM    834  CA  LYS   109       9.332  15.086  13.406  1.00  7.47           C  
ATOM    835  C   LYS   109       8.516  15.163  14.677  1.00  6.95           C  
ATOM    836  O   LYS   109       8.923  15.820  15.652  1.00  8.43           O  
ATOM    837  CB  LYS   109       8.865  16.128  12.410  1.00  8.40           C  
ATOM    838  CG  LYS   109       9.899  16.414  11.334  1.00 11.98           C  
ATOM    839  CD  LYS   109       9.420  17.302  10.199  1.00 13.99           C  
ATOM    840  CE  LYS   109      10.580  17.684   9.279  0.80 14.86           C  
ATOM    841  NZ  LYS   109      10.223  18.249   7.939  0.80 18.08           N  
ATOM    842  N   VAL   110       7.334  14.526  14.696  1.00  6.46           N  
ATOM    843  CA  VAL   110       6.543  14.498  15.923  1.00  7.30           C  
ATOM    844  C   VAL   110       7.335  13.809  17.030  1.00  6.59           C  
ATOM    845  O   VAL   110       7.450  14.315  18.141  1.00  7.66           O  
ATOM    846  CB  VAL   110       5.179  13.805  15.707  1.00  6.81           C  
ATOM    847  CG1 VAL   110       4.413  13.739  17.034  1.00  7.86           C  
ATOM    848  CG2 VAL   110       4.360  14.519  14.638  1.00  8.53           C  
ATOM    849  N   ALA   111       7.878  12.634  16.736  1.00  6.25           N  
ATOM    850  CA  ALA   111       8.587  11.898  17.775  1.00  6.44           C  
ATOM    851  C   ALA   111       9.813  12.662  18.294  1.00  6.55           C  
ATOM    852  O   ALA   111      10.037  12.764  19.497  1.00  7.23           O  
ATOM    853  CB  ALA   111       9.000  10.502  17.233  1.00  6.91           C  
ATOM    854  N   SER   112      10.597  13.198  17.371  1.00  6.91           N  
ATOM    855  CA  SER   112      11.838  13.856  17.755  0.50  7.97           C  
ATOM    857  C   SER   112      11.569  15.119  18.578  1.00  8.71           C  
ATOM    858  O   SER   112      12.402  15.486  19.385  1.00 11.07           O  
ATOM    859  CB  SER   112      12.717  14.152  16.530  0.50  8.49           C  
ATOM    861  OG  SER   112      12.096  15.095  15.671  0.50  9.64           O  
ATOM    863  N   SER   113      10.403  15.745  18.391  1.00  8.30           N  
ATOM    864  CA  SER   113       9.935  16.916  19.134  0.50  9.12           C  
ATOM    866  C   SER   113       9.259  16.563  20.456  1.00  8.56           C  
ATOM    867  O   SER   113       8.882  17.467  21.204  1.00  9.94           O  
ATOM    868  CB  SER   113       8.898  17.677  18.288  0.50 10.45           C  
ATOM    870  OG  SER   113       9.490  18.283  17.156  0.50 15.37           O  
ATOM    872  N   HIS   114       9.023  15.281  20.705  1.00  7.79           N  
ATOM    873  CA  HIS   114       8.324  14.809  21.885  1.00  7.83           C  
ATOM    874  C   HIS   114       9.069  13.713  22.609  1.00  8.28           C  
ATOM    875  O   HIS   114       8.496  12.745  23.090  1.00  9.87           O  
ATOM    876  CB  HIS   114       6.869  14.400  21.562  1.00  8.35           C  
ATOM    877  CG  HIS   114       6.066  15.538  21.049  1.00  8.39           C  
ATOM    878  ND1 HIS   114       5.234  16.370  21.762  1.00 12.03           N  
ATOM    879  CD2 HIS   114       6.042  15.973  19.773  1.00  7.75           C  
ATOM    880  CE1 HIS   114       4.721  17.262  20.921  1.00 10.24           C  
ATOM    881  NE2 HIS   114       5.197  17.037  19.714  1.00 13.52           N  
ATOM    882  N   GLY   115      10.379  13.904  22.750  1.00  8.04           N  
ATOM    883  CA  GLY   115      11.136  13.101  23.678  1.00  8.92           C  
ATOM    884  C   GLY   115      11.885  11.910  23.143  1.00  8.53           C  
ATOM    885  O   GLY   115      12.534  11.202  23.936  1.00 10.87           O  
ATOM    886  N   TYR   116      11.865  11.699  21.818  1.00  7.42           N  
ATOM    887  CA  TYR   116      12.617  10.613  21.237  1.00  7.88           C  
ATOM    888  C   TYR   116      13.886  11.204  20.645  1.00  8.36           C  
ATOM    889  O   TYR   116      13.867  11.829  19.596  1.00  9.94           O  
ATOM    890  CB  TYR   116      11.822   9.904  20.128  1.00  7.27           C  
ATOM    891  CG  TYR   116      10.689   9.086  20.672  1.00  7.06           C  
ATOM    892  CD1 TYR   116      10.880   7.750  20.961  1.00  7.23           C  
ATOM    893  CD2 TYR   116       9.420   9.641  20.909  1.00  7.09           C  
ATOM    894  CE1 TYR   116       9.852   6.944  21.464  1.00  7.42           C  
ATOM    895  CE2 TYR   116       8.399   8.858  21.410  1.00  7.13           C  
ATOM    896  CZ  TYR   116       8.609   7.514  21.683  1.00  7.28           C  
ATOM    897  OH  TYR   116       7.548   6.756  22.143  1.00  8.85           O  
ATOM    898  N   SER   117      15.012  10.963  21.308  1.00  9.24           N  
ATOM    899  CA  SER   117      16.310  11.508  20.932  0.50  9.26           C  
ATOM    901  C   SER   117      17.024  10.669  19.883  1.00  9.18           C  
ATOM    902  O   SER   117      18.034  11.122  19.359  1.00 10.73           O  
ATOM    903  CB  SER   117      17.222  11.640  22.154  0.50 10.04           C  
ATOM    905  OG  SER   117      17.610  10.398  22.671  0.50 12.56           O  
ATOM    907  N   ASN   118      16.547   9.429  19.632  1.00  7.59           N  
ATOM    908  CA  ASN   118      17.230   8.515  18.705  1.00  7.19           C  
ATOM    909  C   ASN   118      16.214   8.080  17.660  1.00  6.53           C  
ATOM    910  O   ASN   118      15.453   7.130  17.866  1.00  7.15           O  
ATOM    911  CB  ASN   118      17.828   7.313  19.399  1.00  8.35           C  
ATOM    912  CG  ASN   118      18.776   6.576  18.487  1.00  9.59           C  
ATOM    913  OD1 ASN   118      18.841   6.865  17.290  1.00 12.34           O  
ATOM    914  ND2 ASN   118      19.470   5.588  18.999  1.00 12.25           N  
ATOM    915  N   THR   119      16.127   8.854  16.591  1.00  6.94           N  
ATOM    916  CA  THR   119      15.179   8.577  15.541  1.00  6.53           C  
ATOM    917  C   THR   119      15.901   8.628  14.190  1.00  6.38           C  
ATOM    918  O   THR   119      16.911   9.327  14.010  1.00  7.96           O  
ATOM    919  CB  THR   119      14.000   9.574  15.490  1.00  7.22           C  
ATOM    920  OG1 THR   119      14.473  10.889  15.205  1.00  9.42           O  
ATOM    921  CG2 THR   119      13.226   9.594  16.807  1.00  8.55           C  
ATOM    922  N   SER   120      15.368   7.863  13.253  1.00  5.51           N  
ATOM    923  CA  SER   120      15.944   7.677  11.949  1.00  5.29           C  
ATOM    924  C   SER   120      14.853   7.551  10.920  1.00  4.26           C  
ATOM    925  O   SER   120      13.678   7.376  11.252  1.00  4.97           O  
ATOM    926  CB  SER   120      16.805   6.411  11.921  1.00  6.20           C  
ATOM    927  OG  SER   120      17.765   6.453  12.944  1.00  7.62           O  
ATOM    928  N   LEU   121      15.250   7.606   9.645  1.00  4.46           N  
ATOM    929  CA  LEU   121      14.317   7.455   8.521  0.80  4.26           C  
ATOM    931  C   LEU   121      14.733   6.291   7.643  1.00  4.09           C  
ATOM    932  O   LEU   121      15.920   6.048   7.412  1.00  5.18           O  
ATOM    933  CB  LEU   121      14.326   8.671   7.606  0.80  5.48           C  
ATOM    935  CG  LEU   121      13.854   9.969   8.202  0.80  5.51           C  
ATOM    937  CD1 LEU   121      14.135  11.139   7.266  0.80  8.67           C  
ATOM    939  CD2 LEU   121      12.370   9.905   8.512  0.80  6.72           C  
ATOM    941  N   TYR   122      13.726   5.629   7.100  1.00  3.94           N  
ATOM    942  CA  TYR   122      13.872   4.763   5.921  1.00  3.85           C  
ATOM    943  C   TYR   122      13.156   5.523   4.806  1.00  3.66           C  
ATOM    944  O   TYR   122      11.966   5.342   4.588  1.00  4.17           O  
ATOM    945  CB  TYR   122      13.247   3.394   6.157  1.00  3.95           C  
ATOM    946  CG  TYR   122      13.202   2.471   4.976  1.00  3.68           C  
ATOM    947  CD1 TYR   122      12.279   1.443   4.940  1.00  4.04           C  
ATOM    948  CD2 TYR   122      14.062   2.599   3.885  1.00  4.06           C  
ATOM    949  CE1 TYR   122      12.268   0.524   3.918  1.00  4.09           C  
ATOM    950  CE2 TYR   122      14.050   1.692   2.831  1.00  3.91           C  
ATOM    951  CZ  TYR   122      13.129   0.649   2.841  1.00  4.07           C  
ATOM    952  OH  TYR   122      13.077  -0.285   1.855  1.00  4.47           O  
ATOM    953  N   PRO   123      13.849   6.463   4.142  1.00  4.14           N  
ATOM    954  CA  PRO   123      13.138   7.375   3.237  1.00  4.65           C  
ATOM    955  C   PRO   123      12.396   6.651   2.119  1.00  4.10           C  
ATOM    956  O   PRO   123      11.326   7.076   1.718  1.00  5.12           O  
ATOM    957  CB  PRO   123      14.255   8.307   2.719  1.00  6.56           C  
ATOM    958  CG  PRO   123      15.395   7.915   3.287  1.00 10.08           C  
ATOM    959  CD  PRO   123      15.273   6.827   4.251  1.00  4.12           C  
ATOM    960  N   GLY   124      13.015   5.604   1.575  1.00  4.01           N  
ATOM    961  CA  GLY   124      12.403   4.887   0.494  1.00  4.35           C  
ATOM    962  C   GLY   124      11.110   4.194   0.879  1.00  3.60           C  
ATOM    963  O   GLY   124      10.226   3.980   0.046  1.00  3.88           O  
ATOM    964  N   SER   125      11.007   3.833   2.160  1.00  3.30           N  
ATOM    965  CA  SER   125       9.769   3.381   2.742  1.00  3.33           C  
ATOM    966  C   SER   125       9.300   2.067   2.099  1.00  3.27           C  
ATOM    967  O   SER   125      10.076   1.348   1.484  1.00  3.48           O  
ATOM    968  CB  SER   125       8.736   4.510   2.729  1.00  4.01           C  
ATOM    969  OG  SER   125       9.097   5.537   3.667  1.00  4.43           O  
ATOM    970  N   MET   126       8.020   1.709   2.316  1.00  3.33           N  
ATOM    971  CA  MET   126       7.588   0.395   1.839  0.80  3.44           C  
ATOM    973  C   MET   126       7.575   0.294   0.330  1.00  3.61           C  
ATOM    974  O   MET   126       7.699  -0.811  -0.213  1.00  4.24           O  
ATOM    975  CB  MET   126       6.249   0.002   2.467  0.80  4.02           C  
ATOM    977  CG  MET   126       6.343  -0.301   3.941  0.80  4.27           C  
ATOM    979  SD  MET   126       7.499  -1.795   4.379  0.80  5.51          SE  
ATOM    981  CE  MET   126       6.491  -3.168   3.482  0.80  6.80           C  
ATOM    983  N   ASN   127       7.471   1.417  -0.400  1.00  3.55           N  
ATOM    984  CA  ASN   127       7.586   1.335  -1.845  1.00  3.71           C  
ATOM    985  C   ASN   127       8.975   0.824  -2.210  1.00  3.64           C  
ATOM    986  O   ASN   127       9.127  -0.021  -3.093  1.00  4.42           O  
ATOM    987  CB  ASN   127       7.349   2.703  -2.504  1.00  4.44           C  
ATOM    988  CG  ASN   127       5.915   3.143  -2.465  1.00  4.85           C  
ATOM    989  OD1 ASN   127       5.029   2.508  -1.890  1.00  5.85           O  
ATOM    990  ND2 ASN   127       5.677   4.330  -3.077  1.00  6.65           N  
ATOM    991  N   ASP   128       9.999   1.360  -1.545  1.00  3.44           N  
ATOM    992  CA  ASP   128      11.362   0.913  -1.764  1.00  3.90           C  
ATOM    993  C   ASP   128      11.535  -0.552  -1.367  1.00  3.51           C  
ATOM    994  O   ASP   128      12.152  -1.352  -2.094  1.00  4.13           O  
ATOM    995  CB  ASP   128      12.301   1.824  -0.996  1.00  4.05           C  
ATOM    996  CG  ASP   128      13.769   1.443  -1.119  1.00  4.04           C  
ATOM    997  OD1 ASP   128      14.484   2.115  -1.899  1.00  5.33           O  
ATOM    998  OD2 ASP   128      14.185   0.505  -0.411  1.00  4.84           O  
ATOM    999  N   TRP   129      10.978  -0.923  -0.224  1.00  3.58           N  
ATOM   1000  CA  TRP   129      11.118  -2.279   0.279  1.00  3.68           C  
ATOM   1001  C   TRP   129      10.575  -3.272  -0.747  1.00  3.61           C  
ATOM   1002  O   TRP   129      11.252  -4.235  -1.148  1.00  4.41           O  
ATOM   1003  CB  TRP   129      10.394  -2.398   1.619  1.00  4.11           C  
ATOM   1004  CG  TRP   129      10.558  -3.726   2.308  1.00  3.84           C  
ATOM   1005  CD1 TRP   129       9.614  -4.693   2.432  1.00  4.29           C  
ATOM   1006  CD2 TRP   129      11.708  -4.178   3.064  1.00  4.09           C  
ATOM   1007  NE1 TRP   129      10.093  -5.730   3.205  1.00  4.47           N  
ATOM   1008  CE2 TRP   129      11.373  -5.436   3.599  1.00  4.27           C  
ATOM   1009  CE3 TRP   129      12.972  -3.633   3.353  1.00  4.65           C  
ATOM   1010  CZ2 TRP   129      12.278  -6.175   4.380  1.00  5.21           C  
ATOM   1011  CZ3 TRP   129      13.864  -4.361   4.102  1.00  5.69           C  
ATOM   1012  CH2 TRP   129      13.501  -5.624   4.611  1.00  5.59           C  
ATOM   1013  N   VAL   130       9.339  -3.042  -1.194  1.00  3.61           N  
ATOM   1014  CA  VAL   130       8.708  -3.942  -2.145  1.00  3.83           C  
ATOM   1015  C   VAL   130       9.390  -3.851  -3.511  1.00  4.04           C  
ATOM   1016  O   VAL   130       9.563  -4.874  -4.197  1.00  4.86           O  
ATOM   1017  CB  VAL   130       7.210  -3.665  -2.222  1.00  4.37           C  
ATOM   1018  CG1 VAL   130       6.529  -4.415  -3.377  1.00  5.73           C  
ATOM   1019  CG2 VAL   130       6.574  -4.015  -0.888  1.00  5.44           C  
ATOM   1020  N   SER   131       9.816  -2.682  -3.959  1.00  4.33           N  
ATOM   1021  CA  SER   131      10.509  -2.554  -5.230  0.50  4.63           C  
ATOM   1024  C   SER   131      11.725  -3.462  -5.309  1.00  4.94           C  
ATOM   1025  O   SER   131      12.048  -3.979  -6.379  1.00  7.00           O  
ATOM   1026  CB  SER   131      10.977  -1.105  -5.462  0.50  5.09           C  
ATOM   1029  OG  SER   131       9.891  -0.247  -5.776  0.50  4.79           O  
ATOM   1032  N   HIS   132      12.434  -3.601  -4.190  1.00  4.09           N  
ATOM   1033  CA  HIS   132      13.653  -4.387  -4.120  1.00  5.00           C  
ATOM   1034  C   HIS   132      13.407  -5.825  -3.700  1.00  5.16           C  
ATOM   1035  O   HIS   132      14.366  -6.579  -3.546  1.00  6.97           O  
ATOM   1036  CB  HIS   132      14.651  -3.741  -3.159  1.00  6.29           C  
ATOM   1037  CG  HIS   132      15.173  -2.425  -3.605  1.00  7.34           C  
ATOM   1038  ND1 HIS   132      14.569  -1.247  -3.294  1.00  8.04           N  
ATOM   1039  CD2 HIS   132      16.276  -2.083  -4.305  1.00 12.11           C  
ATOM   1040  CE1 HIS   132      15.249  -0.241  -3.804  1.00 10.56           C  
ATOM   1041  NE2 HIS   132      16.280  -0.718  -4.447  1.00 13.22           N  
ATOM   1042  N   GLY   133      12.154  -6.207  -3.489  1.00  5.03           N  
ATOM   1043  CA  GLY   133      11.806  -7.578  -3.156  1.00  5.84           C  
ATOM   1044  C   GLY   133      11.894  -7.915  -1.668  1.00  5.32           C  
ATOM   1045  O   GLY   133      11.886  -9.110  -1.321  1.00  5.03           O  
ATOM   1046  N   GLY   134      11.909  -6.905  -0.802  1.00  5.00           N  
ATOM   1047  CA  GLY   134      11.989  -7.156   0.610  1.00  5.55           C  
ATOM   1048  C   GLY   134      10.906  -8.023   1.172  1.00  4.95           C  
ATOM   1049  O   GLY   134      11.122  -8.750   2.153  1.00  5.96           O  
ATOM   1050  N   ASP   135       9.725  -7.953   0.591  1.00  5.67           N  
ATOM   1051  CA  ASP   135       8.617  -8.770   1.049  1.00  6.29           C  
ATOM   1052  C   ASP   135       8.818 -10.273   0.822  1.00  5.75           C  
ATOM   1053  O   ASP   135       8.085 -11.067   1.405  1.00  7.57           O  
ATOM   1054  CB  ASP   135       7.307  -8.294   0.391  1.00  7.45           C  
ATOM   1055  CG  ASP   135       7.385  -8.341  -1.120  1.00  8.12           C  
ATOM   1056  OD1 ASP   135       8.281  -7.699  -1.702  1.00  7.76           O  
ATOM   1057  OD2 ASP   135       6.580  -9.093  -1.739  1.00 13.52           O  
ATOM   1058  N   LYS   136       9.807 -10.636  -0.010  1.00  4.79           N  
ATOM   1059  CA  LYS   136      10.115 -12.031  -0.256  0.50  4.79           C  
ATOM   1061  C   LYS   136      11.260 -12.555   0.618  1.00  5.02           C  
ATOM   1062  O   LYS   136      11.670 -13.713   0.474  1.00  5.04           O  
ATOM   1063  CB  LYS   136      10.482 -12.246  -1.718  0.50  4.93           C  
ATOM   1065  CG  LYS   136       9.422 -11.816  -2.688  0.50  4.76           C  
ATOM   1067  CD  LYS   136       8.058 -12.371  -2.399  0.50  5.14           C  
ATOM   1069  CE  LYS   136       7.081 -12.233  -3.537  0.50  6.88           C  
ATOM   1071  NZ  LYS   136       7.051 -10.800  -4.022  0.50  7.26           N  
ATOM   1073  N   LEU   137      11.803 -11.706   1.487  1.00  5.59           N  
ATOM   1074  CA  LEU   137      12.840 -12.118   2.406  1.00  5.41           C  
ATOM   1075  C   LEU   137      12.245 -12.825   3.617  1.00  6.68           C  
ATOM   1076  O   LEU   137      11.058 -12.684   3.923  1.00  8.80           O  
ATOM   1077  CB  LEU   137      13.636 -10.911   2.889  1.00  5.66           C  
ATOM   1078  CG  LEU   137      14.328 -10.125   1.761  1.00  5.65           C  
ATOM   1079  CD1 LEU   137      14.925  -8.864   2.331  1.00  7.54           C  
ATOM   1080  CD2 LEU   137      15.411 -10.949   1.085  1.00  7.87           C  
ATOM   1081  N   ASP   138      13.096 -13.562   4.315  1.00  6.41           N  
ATOM   1082  CA  ASP   138      12.745 -14.216   5.555  1.00  7.90           C  
ATOM   1083  C   ASP   138      13.943 -14.092   6.510  1.00  8.72           C  
ATOM   1084  O   ASP   138      14.589 -15.076   6.851  1.00 12.84           O  
ATOM   1085  CB  ASP   138      12.391 -15.698   5.280  1.00  9.13           C  
ATOM   1086  CG  ASP   138      11.835 -16.421   6.470  1.00 11.58           C  
ATOM   1087  OD1 ASP   138      11.324 -15.777   7.390  1.00 15.42           O  
ATOM   1088  OD2 ASP   138      11.913 -17.655   6.525  1.00 14.90           O  
ATOM   1089  N   LEU   139      14.265 -12.876   6.930  1.00 11.14           N  
ATOM   1090  CA  LEU   139      15.484 -12.587   7.712  1.00 12.59           C  
ATOM   1091  C   LEU   139      15.303 -12.694   9.201  1.00 15.51           C  
ATOM   1092  O   LEU   139      14.166 -12.670   9.679  1.00 16.67           O  
ATOM   1093  CB  LEU   139      15.978 -11.192   7.404  1.00 14.21           C  
ATOM   1094  CG  LEU   139      16.279 -10.807   5.972  1.00 15.95           C  
ATOM   1095  CD1 LEU   139      16.667  -9.342   5.909  1.00 18.14           C  
ATOM   1096  CD2 LEU   139      17.346 -11.740   5.432  1.00 19.85           C  
ATOM   1097  OXT LEU   139      16.299 -12.751   9.943  1.00 18.29           O  
END
