
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  119 ( 1798),  selected  119 , name 2cqo_A
# Molecule2: number of CA atoms  103 (  801),  selected  103 , name T0409.pdb
# PARAMETERS: 2cqo_A.T0409.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      Y       1           -
LGA    -       -      R       2           -
LGA    -       -      G       3           -
LGA    -       -      P       4           -
LGA    -       -      E       5           -
LGA    G    -6_A      A       6           #
LGA    S    -5_A      F       7          3.270
LGA    S    -4_A      L       8           #
LGA    G    -3_A      K       9           -
LGA    S    -2_A      L      10           -
LGA    S    -1_A      P      11           -
LGA    G     0_A      K      12           -
LGA    M     1_A      D      13           -
LGA    N     2_A      L      14           -
LGA    S     3_A      K      15           -
LGA    G     4_A      D      16           -
LGA    R     5_A      R      17           -
LGA    P     6_A      E      18           -
LGA    E     7_A      A      19           -
LGA    T     8_A      L      20           -
LGA    M     9_A      Q      21           -
LGA    E    10_A      D      22           -
LGA    N    11_A      I      23           -
LGA    L    12_A      M      24           -
LGA    P    13_A      Q      25           -
LGA    A    14_A      D      26           -
LGA    L    15_A      I      27           -
LGA    Y    16_A      G      28           -
LGA    -       -      N      29           -
LGA    -       -      S      30           -
LGA    T    17_A      D      31           #
LGA    I    18_A      D      32          2.615
LGA    -       -      I      33           -
LGA    F    19_A      L      34          0.319
LGA    Q    20_A      A      35          0.927
LGA    G    21_A      A      36          0.442
LGA    E    22_A      V      37          0.886
LGA    V    23_A      V      38          0.709
LGA    A    24_A      L      39          0.817
LGA    M    25_A      S      40          1.543
LGA    V    26_A      A      41          1.461
LGA    T    27_A      T      42          2.923
LGA    D    28_A      P      43          3.389
LGA    Y    29_A      G      44          1.198
LGA    G    30_A      A      45          1.784
LGA    A    31_A      V      46          0.503
LGA    F    32_A      E      47          1.068
LGA    I    33_A      A      48          1.362
LGA    K    34_A      F      49          0.897
LGA    I    35_A      R      50          0.824
LGA    P    36_A      K      51          0.652
LGA    G    37_A      N      52          2.143
LGA    C    38_A      G      53          2.382
LGA    R    39_A      E      54          3.404
LGA    K    40_A      -       -           -
LGA    Q    41_A      T      55          1.444
LGA    G    42_A      I      56          1.332
LGA    L    43_A      R      57          1.307
LGA    V    44_A      I      58          1.091
LGA    H    45_A      T      59          1.017
LGA    R    46_A      G      60          4.172
LGA    T    47_A      D      61          3.285
LGA    H    48_A      G      62          2.275
LGA    M    49_A      L      63          1.463
LGA    S    50_A      K      64          2.812
LGA    S    51_A      A      65          2.759
LGA    C    52_A      A      66           #
LGA    R    53_A      H      67           #
LGA    V    54_A      R      68           #
LGA    D    55_A      -       -           -
LGA    K    56_A      -       -           -
LGA    P    57_A      -       -           -
LGA    S    58_A      F      69           #
LGA    E    59_A      L      70          3.489
LGA    I    60_A      S      71          5.143
LGA    -       -      N      72           -
LGA    -       -      D      73           -
LGA    -       -      P      74           -
LGA    -       -      K      75           -
LGA    -       -      I      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      K      79           -
LGA    -       -      R      80           -
LGA    V    61_A      I      81          1.300
LGA    D    62_A      R      82          0.604
LGA    V    63_A      P      83          0.770
LGA    G    64_A      G      84          0.557
LGA    D    65_A      A      85          0.293
LGA    K    66_A      L      86          0.669
LGA    V    67_A      I      87          0.798
LGA    W    68_A      R      88          0.834
LGA    V    69_A      V      89          0.812
LGA    K    70_A      K      90          0.408
LGA    L    71_A      K      91          0.686
LGA    I    72_A      T      92          1.680
LGA    -       -      E      93           -
LGA    G    73_A      K      94          4.081
LGA    R    74_A      G      95          3.895
LGA    E    75_A      -       -           -
LGA    M    76_A      -       -           -
LGA    K    77_A      -       -           -
LGA    N    78_A      -       -           -
LGA    D    79_A      -       -           -
LGA    R    80_A      -       -           -
LGA    I    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    V    83_A      -       -           -
LGA    S    84_A      S      96          2.473
LGA    L    85_A      W      97          0.862
LGA    S    86_A      Q      98          0.501
LGA    M    87_A      I      99          1.668
LGA    K    88_A      -       -           -
LGA    V    89_A      -       -           -
LGA    V    90_A      V     100          2.341
LGA    N    91_A      Q     101          2.069
LGA    Q    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    T    94_A      -       -           -
LGA    G    95_A      L     102          1.308
LGA    K    96_A      P     103          3.126
LGA    D    97_A      -       -           -
LGA    L    98_A      -       -           -
LGA    D    99_A      -       -           -
LGA    P   100_A      -       -           -
LGA    N   101_A      -       -           -
LGA    N   102_A      -       -           -
LGA    V   103_A      -       -           -
LGA    I   104_A      -       -           -
LGA    I   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    S   110_A      -       -           -
LGA    S   111_A      -       -           -
LGA    G   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  119  103    5.0     58    2.06    12.07     43.341     2.685

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.899662 * X  +   0.127215 * Y  +  -0.417641 * Z  +  15.817811
  Y_new =  -0.421609 * X  +  -0.501567 * Y  +   0.755431 * Z  +  11.204471
  Z_new =  -0.113373 * X  +   0.855714 * Y  +   0.504876 * Z  +  15.665494 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.037758   -2.103835  [ DEG:    59.4592   -120.5408 ]
  Theta =   0.113617    3.027975  [ DEG:     6.5098    173.4902 ]
  Phi   =  -2.703354    0.438239  [ DEG:  -154.8908     25.1092 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cqo_A                                        
REMARK     2: T0409.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cqo_A.T0409.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  119  103   5.0   58   2.06   12.07  43.341
REMARK  ---------------------------------------------------------- 
MOLECULE 2cqo_A
HEADER    RIBOSOME                                20-MAY-05   2CQO              
TITLE     SOLUTION STRUCTURE OF THE S1 RNA BINDING DOMAIN OF HUMAN              
TITLE    2 HYPOTHETICAL PROTEIN FLJ11067                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NUCLEOLAR PROTEIN OF 40 KDA;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: S1 DOMAIN;                                                 
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN FLJ11067, PNO40, PUTATIVE S1           
COMPND   6 RNA BINDING DOMAIN PROTEIN, PS1D PROTEIN, PNN-INTERACTING            
COMPND   7 NUCLEOLAR PROTEIN;                                                   
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PS1D;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050111-18;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    S1 DOMAIN, OB-FOLD, STRUCTURAL GENOMICS, NPPSFA, NATIONAL             
KEYWDS   2 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   3 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    S.SUZUKI,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,M.SHIROUZU,                 
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   20-NOV-05 2CQO    0                                                
JRNL        AUTH   S.SUZUKI,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,                   
JRNL        AUTH 2 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   SOLUTION STRUCTURE OF THE S1 RNA BINDING DOMAIN OF           
JRNL        TITL 2 HUMAN HYPOTHETICAL PROTEIN FLJ11067                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2CQO A    1   106  UNP    73921227 NO40_HUMAN       1    106             
SEQRES   1 A  119  GLY SER SER GLY SER SER GLY MET ASN SER GLY ARG PRO          
SEQRES   2 A  119  GLU THR MET GLU ASN LEU PRO ALA LEU TYR THR ILE PHE          
SEQRES   3 A  119  GLN GLY GLU VAL ALA MET VAL THR ASP TYR GLY ALA PHE          
SEQRES   4 A  119  ILE LYS ILE PRO GLY CYS ARG LYS GLN GLY LEU VAL HIS          
SEQRES   5 A  119  ARG THR HIS MET SER SER CYS ARG VAL ASP LYS PRO SER          
SEQRES   6 A  119  GLU ILE VAL ASP VAL GLY ASP LYS VAL TRP VAL LYS LEU          
SEQRES   7 A  119  ILE GLY ARG GLU MET LYS ASN ASP ARG ILE LYS VAL SER          
SEQRES   8 A  119  LEU SER MET LYS VAL VAL ASN GLN GLY THR GLY LYS ASP          
SEQRES   9 A  119  LEU ASP PRO ASN ASN VAL ILE ILE GLU SER GLY PRO SER          
SEQRES  10 A  119  SER GLY                                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  -6      -0.356 -12.941  46.524  1.00  0.00           N  
ATOM      2  CA  GLY A  -6      -0.325 -12.392  45.181  1.00  0.00           C  
ATOM      3  C   GLY A  -6       0.057 -10.926  45.163  1.00  0.00           C  
ATOM      4  O   GLY A  -6       0.167 -10.291  46.212  1.00  0.00           O  
ATOM      5  HA2 GLY A  -6       0.390 -12.948  44.593  1.00  0.00           H  
ATOM      6  HA3 GLY A  -6      -1.304 -12.502  44.738  1.00  0.00           H  
ATOM      7  H1  GLY A  -6      -0.384 -12.338  47.297  1.00  0.00           H  
ATOM      8  N   SER A  -5       0.263 -10.385  43.966  1.00  0.00           N  
ATOM      9  CA  SER A  -5       0.640  -8.984  43.815  1.00  0.00           C  
ATOM     10  C   SER A  -5      -0.592  -8.084  43.830  1.00  0.00           C  
ATOM     11  O   SER A  -5      -1.456  -8.182  42.959  1.00  0.00           O  
ATOM     12  CB  SER A  -5       1.419  -8.781  42.514  1.00  0.00           C  
ATOM     13  OG  SER A  -5       0.576  -8.939  41.386  1.00  0.00           O  
ATOM     14  H   SER A  -5       0.158 -10.940  43.167  1.00  0.00           H  
ATOM     15  HA  SER A  -5       1.274  -8.721  44.649  1.00  0.00           H  
ATOM     16  HB2 SER A  -5       1.838  -7.787  42.499  1.00  0.00           H  
ATOM     17  HB3 SER A  -5       2.216  -9.508  42.458  1.00  0.00           H  
ATOM     18  HG  SER A  -5       0.951  -9.596  40.796  1.00  0.00           H  
ATOM     19  N   SER A  -4      -0.665  -7.206  44.825  1.00  0.00           N  
ATOM     20  CA  SER A  -4      -1.791  -6.290  44.956  1.00  0.00           C  
ATOM     21  C   SER A  -4      -1.557  -5.021  44.145  1.00  0.00           C  
ATOM     22  O   SER A  -4      -0.593  -4.292  44.374  1.00  0.00           O  
ATOM     23  CB  SER A  -4      -2.017  -5.934  46.427  1.00  0.00           C  
ATOM     24  OG  SER A  -4      -2.247  -7.097  47.204  1.00  0.00           O  
ATOM     25  H   SER A  -4       0.057  -7.177  45.489  1.00  0.00           H  
ATOM     26  HA  SER A  -4      -2.670  -6.790  44.576  1.00  0.00           H  
ATOM     27  HB2 SER A  -4      -1.147  -5.427  46.811  1.00  0.00           H  
ATOM     28  HB3 SER A  -4      -2.878  -5.285  46.510  1.00  0.00           H  
ATOM     29  HG  SER A  -4      -2.343  -6.852  48.127  1.00  0.00           H  
ATOM     30  N   GLY A  -3      -2.449  -4.761  43.193  1.00  0.00           N  
ATOM     31  CA  GLY A  -3      -2.323  -3.580  42.360  1.00  0.00           C  
ATOM     32  C   GLY A  -3      -3.327  -3.560  41.226  1.00  0.00           C  
ATOM     33  O   GLY A  -3      -3.812  -4.607  40.797  1.00  0.00           O  
ATOM     34  H   GLY A  -3      -3.199  -5.377  43.055  1.00  0.00           H  
ATOM     35  HA2 GLY A  -3      -2.468  -2.703  42.973  1.00  0.00           H  
ATOM     36  HA3 GLY A  -3      -1.326  -3.552  41.942  1.00  0.00           H  
ATOM     37  N   SER A  -2      -3.643  -2.364  40.737  1.00  0.00           N  
ATOM     38  CA  SER A  -2      -4.602  -2.211  39.650  1.00  0.00           C  
ATOM     39  C   SER A  -2      -3.959  -2.546  38.309  1.00  0.00           C  
ATOM     40  O   SER A  -2      -2.765  -2.328  38.108  1.00  0.00           O  
ATOM     41  CB  SER A  -2      -5.151  -0.783  39.622  1.00  0.00           C  
ATOM     42  OG  SER A  -2      -5.963  -0.527  40.756  1.00  0.00           O  
ATOM     43  H   SER A  -2      -3.223  -1.565  41.121  1.00  0.00           H  
ATOM     44  HA  SER A  -2      -5.417  -2.897  39.827  1.00  0.00           H  
ATOM     45  HB2 SER A  -2      -4.329  -0.084  39.620  1.00  0.00           H  
ATOM     46  HB3 SER A  -2      -5.744  -0.646  38.730  1.00  0.00           H  
ATOM     47  HG  SER A  -2      -5.407  -0.292  41.502  1.00  0.00           H  
ATOM     48  N   SER A  -1      -4.760  -3.081  37.392  1.00  0.00           N  
ATOM     49  CA  SER A  -1      -4.270  -3.450  36.070  1.00  0.00           C  
ATOM     50  C   SER A  -1      -4.745  -2.454  35.016  1.00  0.00           C  
ATOM     51  O   SER A  -1      -3.960  -1.983  34.192  1.00  0.00           O  
ATOM     52  CB  SER A  -1      -4.740  -4.859  35.704  1.00  0.00           C  
ATOM     53  OG  SER A  -1      -4.052  -5.349  34.566  1.00  0.00           O  
ATOM     54  H   SER A  -1      -5.704  -3.229  37.612  1.00  0.00           H  
ATOM     55  HA  SER A  -1      -3.192  -3.436  36.100  1.00  0.00           H  
ATOM     56  HB2 SER A  -1      -4.556  -5.525  36.533  1.00  0.00           H  
ATOM     57  HB3 SER A  -1      -5.799  -4.838  35.487  1.00  0.00           H  
ATOM     58  HG  SER A  -1      -4.554  -6.062  34.168  1.00  0.00           H  
ATOM     59  N   GLY A   0      -6.036  -2.138  35.048  1.00  0.00           N  
ATOM     60  CA  GLY A   0      -6.595  -1.201  34.090  1.00  0.00           C  
ATOM     61  C   GLY A   0      -8.018  -0.805  34.430  1.00  0.00           C  
ATOM     62  O   GLY A   0      -8.813  -1.636  34.867  1.00  0.00           O  
ATOM     63  H   GLY A   0      -6.615  -2.546  35.726  1.00  0.00           H  
ATOM     64  HA2 GLY A   0      -5.979  -0.315  34.071  1.00  0.00           H  
ATOM     65  HA3 GLY A   0      -6.584  -1.656  33.110  1.00  0.00           H  
ATOM     66  N   MET A   1      -8.339   0.470  34.230  1.00  0.00           N  
ATOM     67  CA  MET A   1      -9.676   0.974  34.520  1.00  0.00           C  
ATOM     68  C   MET A   1     -10.290   1.625  33.284  1.00  0.00           C  
ATOM     69  O   MET A   1     -11.511   1.692  33.147  1.00  0.00           O  
ATOM     70  CB  MET A   1      -9.628   1.981  35.670  1.00  0.00           C  
ATOM     71  CG  MET A   1      -8.895   3.267  35.321  1.00  0.00           C  
ATOM     72  SD  MET A   1      -9.958   4.473  34.506  1.00  0.00           S  
ATOM     73  CE  MET A   1      -8.921   5.933  34.562  1.00  0.00           C  
ATOM     74  H   MET A   1      -7.662   1.085  33.880  1.00  0.00           H  
ATOM     75  HA  MET A   1     -10.291   0.135  34.813  1.00  0.00           H  
ATOM     76  HB2 MET A   1     -10.638   2.234  35.954  1.00  0.00           H  
ATOM     77  HB3 MET A   1      -9.128   1.526  36.511  1.00  0.00           H  
ATOM     78  HG2 MET A   1      -8.510   3.705  36.230  1.00  0.00           H  
ATOM     79  HG3 MET A   1      -8.073   3.028  34.663  1.00  0.00           H  
ATOM     80  HE1 MET A   1      -8.901   6.399  33.588  1.00  0.00           H  
ATOM     81  HE2 MET A   1      -9.318   6.627  35.286  1.00  0.00           H  
ATOM     82  HE3 MET A   1      -7.917   5.649  34.846  1.00  0.00           H  
ATOM     83  N   ASN A   2      -9.435   2.103  32.386  1.00  0.00           N  
ATOM     84  CA  ASN A   2      -9.894   2.750  31.162  1.00  0.00           C  
ATOM     85  C   ASN A   2      -9.545   1.908  29.937  1.00  0.00           C  
ATOM     86  O   ASN A   2      -8.403   1.906  29.479  1.00  0.00           O  
ATOM     87  CB  ASN A   2      -9.272   4.142  31.031  1.00  0.00           C  
ATOM     88  CG  ASN A   2      -9.792   4.896  29.822  1.00  0.00           C  
ATOM     89  OD1 ASN A   2     -10.202   4.293  28.829  1.00  0.00           O  
ATOM     90  ND2 ASN A   2      -9.779   6.222  29.901  1.00  0.00           N  
ATOM     91  H   ASN A   2      -8.472   2.020  32.550  1.00  0.00           H  
ATOM     92  HA  ASN A   2     -10.968   2.848  31.221  1.00  0.00           H  
ATOM     93  HB2 ASN A   2      -9.504   4.717  31.916  1.00  0.00           H  
ATOM     94  HB3 ASN A   2      -8.202   4.044  30.940  1.00  0.00           H  
ATOM     95 HD21 ASN A   2      -9.438   6.633  30.723  1.00  0.00           H  
ATOM     96 HD22 ASN A   2     -10.109   6.734  29.134  1.00  0.00           H  
ATOM     97  N   SER A   3     -10.537   1.195  29.415  1.00  0.00           N  
ATOM     98  CA  SER A   3     -10.335   0.346  28.245  1.00  0.00           C  
ATOM     99  C   SER A   3     -10.714   1.085  26.965  1.00  0.00           C  
ATOM    100  O   SER A   3     -11.648   1.885  26.950  1.00  0.00           O  
ATOM    101  CB  SER A   3     -11.158  -0.936  28.371  1.00  0.00           C  
ATOM    102  OG  SER A   3     -12.546  -0.650  28.399  1.00  0.00           O  
ATOM    103  H   SER A   3     -11.425   1.238  29.826  1.00  0.00           H  
ATOM    104  HA  SER A   3      -9.287   0.088  28.201  1.00  0.00           H  
ATOM    105  HB2 SER A   3     -10.953  -1.578  27.526  1.00  0.00           H  
ATOM    106  HB3 SER A   3     -10.889  -1.445  29.285  1.00  0.00           H  
ATOM    107  HG  SER A   3     -12.984  -1.251  29.005  1.00  0.00           H  
ATOM    108  N   GLY A   4      -9.979   0.812  25.891  1.00  0.00           N  
ATOM    109  CA  GLY A   4     -10.252   1.457  24.621  1.00  0.00           C  
ATOM    110  C   GLY A   4     -10.111   2.965  24.695  1.00  0.00           C  
ATOM    111  O   GLY A   4     -10.614   3.598  25.623  1.00  0.00           O  
ATOM    112  H   GLY A   4      -9.244   0.166  25.963  1.00  0.00           H  
ATOM    113  HA2 GLY A   4      -9.564   1.077  23.881  1.00  0.00           H  
ATOM    114  HA3 GLY A   4     -11.260   1.216  24.318  1.00  0.00           H  
ATOM    115  N   ARG A   5      -9.421   3.541  23.715  1.00  0.00           N  
ATOM    116  CA  ARG A   5      -9.212   4.984  23.676  1.00  0.00           C  
ATOM    117  C   ARG A   5      -9.548   5.544  22.296  1.00  0.00           C  
ATOM    118  O   ARG A   5      -9.150   5.002  21.265  1.00  0.00           O  
ATOM    119  CB  ARG A   5      -7.765   5.321  24.035  1.00  0.00           C  
ATOM    120  CG  ARG A   5      -7.396   6.775  23.784  1.00  0.00           C  
ATOM    121  CD  ARG A   5      -5.891   6.958  23.673  1.00  0.00           C  
ATOM    122  NE  ARG A   5      -5.359   6.375  22.443  1.00  0.00           N  
ATOM    123  CZ  ARG A   5      -4.062   6.296  22.170  1.00  0.00           C  
ATOM    124  NH1 ARG A   5      -3.170   6.759  23.034  1.00  0.00           N  
ATOM    125  NH2 ARG A   5      -3.654   5.752  21.030  1.00  0.00           N  
ATOM    126  H   ARG A   5      -9.044   2.984  23.004  1.00  0.00           H  
ATOM    127  HA  ARG A   5      -9.869   5.435  24.404  1.00  0.00           H  
ATOM    128  HB2 ARG A   5      -7.607   5.108  25.082  1.00  0.00           H  
ATOM    129  HB3 ARG A   5      -7.106   4.700  23.446  1.00  0.00           H  
ATOM    130  HG2 ARG A   5      -7.857   7.099  22.863  1.00  0.00           H  
ATOM    131  HG3 ARG A   5      -7.764   7.375  24.602  1.00  0.00           H  
ATOM    132  HD2 ARG A   5      -5.669   8.013  23.685  1.00  0.00           H  
ATOM    133  HD3 ARG A   5      -5.421   6.481  24.520  1.00  0.00           H  
ATOM    134  HE  ARG A   5      -6.001   6.027  21.791  1.00  0.00           H  
ATOM    135 HH11 ARG A   5      -3.473   7.169  23.894  1.00  0.00           H  
ATOM    136 HH12 ARG A   5      -2.193   6.698  22.826  1.00  0.00           H  
ATOM    137 HH21 ARG A   5      -4.325   5.402  20.376  1.00  0.00           H  
ATOM    138 HH22 ARG A   5      -2.678   5.693  20.825  1.00  0.00           H  
ATOM    139  N   PRO A   6     -10.301   6.654  22.276  1.00  0.00           N  
ATOM    140  CA  PRO A   6     -10.708   7.312  21.030  1.00  0.00           C  
ATOM    141  C   PRO A   6      -9.535   7.974  20.314  1.00  0.00           C  
ATOM    142  O   PRO A   6      -8.385   7.832  20.727  1.00  0.00           O  
ATOM    143  CB  PRO A   6     -11.713   8.367  21.498  1.00  0.00           C  
ATOM    144  CG  PRO A   6     -11.337   8.648  22.911  1.00  0.00           C  
ATOM    145  CD  PRO A   6     -10.812   7.354  23.466  1.00  0.00           C  
ATOM    146  HA  PRO A   6     -11.194   6.620  20.357  1.00  0.00           H  
ATOM    147  HB2 PRO A   6     -11.627   9.249  20.881  1.00  0.00           H  
ATOM    148  HB3 PRO A   6     -12.715   7.969  21.429  1.00  0.00           H  
ATOM    149  HG2 PRO A   6     -10.571   9.409  22.942  1.00  0.00           H  
ATOM    150  HG3 PRO A   6     -12.207   8.968  23.466  1.00  0.00           H  
ATOM    151  HD2 PRO A   6     -10.017   7.542  24.173  1.00  0.00           H  
ATOM    152  HD3 PRO A   6     -11.608   6.792  23.932  1.00  0.00           H  
ATOM    153  N   GLU A   7      -9.837   8.698  19.241  1.00  0.00           N  
ATOM    154  CA  GLU A   7      -8.805   9.381  18.468  1.00  0.00           C  
ATOM    155  C   GLU A   7      -8.765  10.868  18.812  1.00  0.00           C  
ATOM    156  O   GLU A   7      -9.548  11.661  18.287  1.00  0.00           O  
ATOM    157  CB  GLU A   7      -9.055   9.200  16.969  1.00  0.00           C  
ATOM    158  CG  GLU A   7      -8.585   7.858  16.432  1.00  0.00           C  
ATOM    159  CD  GLU A   7      -9.615   6.760  16.623  1.00  0.00           C  
ATOM    160  OE1 GLU A   7     -10.686   6.835  15.986  1.00  0.00           O  
ATOM    161  OE2 GLU A   7      -9.348   5.827  17.408  1.00  0.00           O  
ATOM    162  H   GLU A   7     -10.772   8.773  18.961  1.00  0.00           H  
ATOM    163  HA  GLU A   7      -7.853   8.940  18.722  1.00  0.00           H  
ATOM    164  HB2 GLU A   7     -10.114   9.289  16.780  1.00  0.00           H  
ATOM    165  HB3 GLU A   7      -8.535   9.979  16.434  1.00  0.00           H  
ATOM    166  HG2 GLU A   7      -8.380   7.959  15.378  1.00  0.00           H  
ATOM    167  HG3 GLU A   7      -7.679   7.575  16.950  1.00  0.00           H  
ATOM    168  N   THR A   8      -7.846  11.240  19.696  1.00  0.00           N  
ATOM    169  CA  THR A   8      -7.702  12.630  20.112  1.00  0.00           C  
ATOM    170  C   THR A   8      -6.389  13.221  19.612  1.00  0.00           C  
ATOM    171  O   THR A   8      -5.524  12.501  19.114  1.00  0.00           O  
ATOM    172  CB  THR A   8      -7.764  12.767  21.645  1.00  0.00           C  
ATOM    173  OG1 THR A   8      -6.830  11.868  22.255  1.00  0.00           O  
ATOM    174  CG2 THR A   8      -9.166  12.475  22.159  1.00  0.00           C  
ATOM    175  H   THR A   8      -7.250  10.563  20.079  1.00  0.00           H  
ATOM    176  HA  THR A   8      -8.524  13.190  19.688  1.00  0.00           H  
ATOM    177  HB  THR A   8      -7.502  13.781  21.911  1.00  0.00           H  
ATOM    178  HG1 THR A   8      -5.981  12.307  22.352  1.00  0.00           H  
ATOM    179 HG21 THR A   8      -9.107  11.798  22.999  1.00  0.00           H  
ATOM    180 HG22 THR A   8      -9.750  12.023  21.372  1.00  0.00           H  
ATOM    181 HG23 THR A   8      -9.632  13.397  22.472  1.00  0.00           H  
ATOM    182  N   MET A   9      -6.247  14.535  19.749  1.00  0.00           N  
ATOM    183  CA  MET A   9      -5.037  15.223  19.313  1.00  0.00           C  
ATOM    184  C   MET A   9      -3.795  14.569  19.912  1.00  0.00           C  
ATOM    185  O   MET A   9      -2.711  14.630  19.331  1.00  0.00           O  
ATOM    186  CB  MET A   9      -5.093  16.699  19.708  1.00  0.00           C  
ATOM    187  CG  MET A   9      -4.043  17.553  19.018  1.00  0.00           C  
ATOM    188  SD  MET A   9      -4.463  17.923  17.305  1.00  0.00           S  
ATOM    189  CE  MET A   9      -5.837  19.051  17.530  1.00  0.00           C  
ATOM    190  H   MET A   9      -6.972  15.055  20.154  1.00  0.00           H  
ATOM    191  HA  MET A   9      -4.985  15.149  18.236  1.00  0.00           H  
ATOM    192  HB2 MET A   9      -6.066  17.091  19.456  1.00  0.00           H  
ATOM    193  HB3 MET A   9      -4.947  16.779  20.774  1.00  0.00           H  
ATOM    194  HG2 MET A   9      -3.941  18.483  19.557  1.00  0.00           H  
ATOM    195  HG3 MET A   9      -3.099  17.024  19.036  1.00  0.00           H  
ATOM    196  HE1 MET A   9      -5.657  19.955  16.968  1.00  0.00           H  
ATOM    197  HE2 MET A   9      -6.746  18.585  17.180  1.00  0.00           H  
ATOM    198  HE3 MET A   9      -5.935  19.293  18.579  1.00  0.00           H  
ATOM    199  N   GLU A  10      -3.962  13.947  21.075  1.00  0.00           N  
ATOM    200  CA  GLU A  10      -2.852  13.285  21.750  1.00  0.00           C  
ATOM    201  C   GLU A  10      -2.796  11.805  21.383  1.00  0.00           C  
ATOM    202  O   GLU A  10      -2.869  10.936  22.250  1.00  0.00           O  
ATOM    203  CB  GLU A  10      -2.985  13.441  23.267  1.00  0.00           C  
ATOM    204  CG  GLU A  10      -1.652  13.443  23.998  1.00  0.00           C  
ATOM    205  CD  GLU A  10      -1.812  13.327  25.501  1.00  0.00           C  
ATOM    206  OE1 GLU A  10      -2.046  12.201  25.988  1.00  0.00           O  
ATOM    207  OE2 GLU A  10      -1.701  14.361  26.190  1.00  0.00           O  
ATOM    208  H   GLU A  10      -4.850  13.933  21.487  1.00  0.00           H  
ATOM    209  HA  GLU A  10      -1.938  13.758  21.429  1.00  0.00           H  
ATOM    210  HB2 GLU A  10      -3.490  14.371  23.479  1.00  0.00           H  
ATOM    211  HB3 GLU A  10      -3.580  12.624  23.649  1.00  0.00           H  
ATOM    212  HG2 GLU A  10      -1.064  12.608  23.648  1.00  0.00           H  
ATOM    213  HG3 GLU A  10      -1.137  14.365  23.776  1.00  0.00           H  
ATOM    214  N   ASN A  11      -2.666  11.527  20.089  1.00  0.00           N  
ATOM    215  CA  ASN A  11      -2.603  10.153  19.605  1.00  0.00           C  
ATOM    216  C   ASN A  11      -1.179   9.609  19.700  1.00  0.00           C  
ATOM    217  O   ASN A  11      -0.968   8.454  20.070  1.00  0.00           O  
ATOM    218  CB  ASN A  11      -3.095  10.076  18.159  1.00  0.00           C  
ATOM    219  CG  ASN A  11      -2.600  11.237  17.317  1.00  0.00           C  
ATOM    220  OD1 ASN A  11      -1.467  11.231  16.838  1.00  0.00           O  
ATOM    221  ND2 ASN A  11      -3.451  12.239  17.133  1.00  0.00           N  
ATOM    222  H   ASN A  11      -2.614  12.264  19.445  1.00  0.00           H  
ATOM    223  HA  ASN A  11      -3.248   9.552  20.228  1.00  0.00           H  
ATOM    224  HB2 ASN A  11      -2.742   9.158  17.713  1.00  0.00           H  
ATOM    225  HB3 ASN A  11      -4.174  10.083  18.151  1.00  0.00           H  
ATOM    226 HD21 ASN A  11      -4.339  12.174  17.546  1.00  0.00           H  
ATOM    227 HD22 ASN A  11      -3.159  13.001  16.594  1.00  0.00           H  
ATOM    228  N   LEU A  12      -0.208  10.450  19.363  1.00  0.00           N  
ATOM    229  CA  LEU A  12       1.196  10.054  19.410  1.00  0.00           C  
ATOM    230  C   LEU A  12       1.524   9.368  20.732  1.00  0.00           C  
ATOM    231  O   LEU A  12       0.865   9.579  21.750  1.00  0.00           O  
ATOM    232  CB  LEU A  12       2.097  11.277  19.220  1.00  0.00           C  
ATOM    233  CG  LEU A  12       2.145  11.862  17.809  1.00  0.00           C  
ATOM    234  CD1 LEU A  12       2.658  13.293  17.842  1.00  0.00           C  
ATOM    235  CD2 LEU A  12       3.016  11.002  16.906  1.00  0.00           C  
ATOM    236  H   LEU A  12      -0.439  11.358  19.077  1.00  0.00           H  
ATOM    237  HA  LEU A  12       1.371   9.360  18.603  1.00  0.00           H  
ATOM    238  HB2 LEU A  12       1.749  12.050  19.887  1.00  0.00           H  
ATOM    239  HB3 LEU A  12       3.102  10.991  19.497  1.00  0.00           H  
ATOM    240  HG  LEU A  12       1.145  11.875  17.397  1.00  0.00           H  
ATOM    241 HD11 LEU A  12       2.260  13.798  18.709  1.00  0.00           H  
ATOM    242 HD12 LEU A  12       2.339  13.810  16.948  1.00  0.00           H  
ATOM    243 HD13 LEU A  12       3.737  13.287  17.890  1.00  0.00           H  
ATOM    244 HD21 LEU A  12       3.985  11.465  16.792  1.00  0.00           H  
ATOM    245 HD22 LEU A  12       2.548  10.910  15.935  1.00  0.00           H  
ATOM    246 HD23 LEU A  12       3.133  10.023  17.343  1.00  0.00           H  
ATOM    247  N   PRO A  13       2.568   8.525  20.718  1.00  0.00           N  
ATOM    248  CA  PRO A  13       3.010   7.792  21.908  1.00  0.00           C  
ATOM    249  C   PRO A  13       3.636   8.707  22.954  1.00  0.00           C  
ATOM    250  O   PRO A  13       3.904   9.879  22.687  1.00  0.00           O  
ATOM    251  CB  PRO A  13       4.053   6.817  21.356  1.00  0.00           C  
ATOM    252  CG  PRO A  13       4.562   7.468  20.117  1.00  0.00           C  
ATOM    253  CD  PRO A  13       3.399   8.226  19.539  1.00  0.00           C  
ATOM    254  HA  PRO A  13       2.197   7.238  22.356  1.00  0.00           H  
ATOM    255  HB2 PRO A  13       4.841   6.680  22.084  1.00  0.00           H  
ATOM    256  HB3 PRO A  13       3.586   5.867  21.141  1.00  0.00           H  
ATOM    257  HG2 PRO A  13       5.367   8.144  20.362  1.00  0.00           H  
ATOM    258  HG3 PRO A  13       4.901   6.716  19.421  1.00  0.00           H  
ATOM    259  HD2 PRO A  13       3.738   9.135  19.066  1.00  0.00           H  
ATOM    260  HD3 PRO A  13       2.859   7.610  18.835  1.00  0.00           H  
ATOM    261  N   ALA A  14       3.866   8.166  24.145  1.00  0.00           N  
ATOM    262  CA  ALA A  14       4.464   8.935  25.232  1.00  0.00           C  
ATOM    263  C   ALA A  14       5.957   9.142  24.999  1.00  0.00           C  
ATOM    264  O   ALA A  14       6.542   8.556  24.089  1.00  0.00           O  
ATOM    265  CB  ALA A  14       4.226   8.238  26.563  1.00  0.00           C  
ATOM    266  H   ALA A  14       3.630   7.228  24.297  1.00  0.00           H  
ATOM    267  HA  ALA A  14       3.977   9.898  25.265  1.00  0.00           H  
ATOM    268  HB1 ALA A  14       3.556   7.404  26.417  1.00  0.00           H  
ATOM    269  HB2 ALA A  14       5.167   7.880  26.954  1.00  0.00           H  
ATOM    270  HB3 ALA A  14       3.789   8.936  27.261  1.00  0.00           H  
ATOM    271  N   LEU A  15       6.567   9.983  25.827  1.00  0.00           N  
ATOM    272  CA  LEU A  15       7.993  10.270  25.712  1.00  0.00           C  
ATOM    273  C   LEU A  15       8.825   9.036  26.042  1.00  0.00           C  
ATOM    274  O   LEU A  15       8.502   8.284  26.963  1.00  0.00           O  
ATOM    275  CB  LEU A  15       8.377  11.422  26.642  1.00  0.00           C  
ATOM    276  CG  LEU A  15       9.768  12.022  26.427  1.00  0.00           C  
ATOM    277  CD1 LEU A  15       9.918  12.524  24.999  1.00  0.00           C  
ATOM    278  CD2 LEU A  15      10.023  13.147  27.419  1.00  0.00           C  
ATOM    279  H   LEU A  15       6.047  10.422  26.533  1.00  0.00           H  
ATOM    280  HA  LEU A  15       8.191  10.561  24.691  1.00  0.00           H  
ATOM    281  HB2 LEU A  15       7.654  12.212  26.508  1.00  0.00           H  
ATOM    282  HB3 LEU A  15       8.328  11.058  27.658  1.00  0.00           H  
ATOM    283  HG  LEU A  15      10.513  11.255  26.591  1.00  0.00           H  
ATOM    284 HD11 LEU A  15       9.880  11.688  24.318  1.00  0.00           H  
ATOM    285 HD12 LEU A  15      10.867  13.031  24.894  1.00  0.00           H  
ATOM    286 HD13 LEU A  15       9.116  13.211  24.774  1.00  0.00           H  
ATOM    287 HD21 LEU A  15      10.584  12.766  28.260  1.00  0.00           H  
ATOM    288 HD22 LEU A  15       9.079  13.541  27.766  1.00  0.00           H  
ATOM    289 HD23 LEU A  15      10.586  13.933  26.937  1.00  0.00           H  
ATOM    290  N   TYR A  16       9.898   8.833  25.285  1.00  0.00           N  
ATOM    291  CA  TYR A  16      10.778   7.689  25.498  1.00  0.00           C  
ATOM    292  C   TYR A  16      10.019   6.377  25.315  1.00  0.00           C  
ATOM    293  O   TYR A  16      10.370   5.355  25.905  1.00  0.00           O  
ATOM    294  CB  TYR A  16      11.393   7.746  26.896  1.00  0.00           C  
ATOM    295  CG  TYR A  16      12.197   9.000  27.154  1.00  0.00           C  
ATOM    296  CD1 TYR A  16      12.932   9.598  26.138  1.00  0.00           C  
ATOM    297  CD2 TYR A  16      12.221   9.585  28.413  1.00  0.00           C  
ATOM    298  CE1 TYR A  16      13.667  10.745  26.369  1.00  0.00           C  
ATOM    299  CE2 TYR A  16      12.953  10.732  28.653  1.00  0.00           C  
ATOM    300  CZ  TYR A  16      13.675  11.308  27.628  1.00  0.00           C  
ATOM    301  OH  TYR A  16      14.406  12.450  27.862  1.00  0.00           O  
ATOM    302  H   TYR A  16      10.103   9.466  24.566  1.00  0.00           H  
ATOM    303  HA  TYR A  16      11.569   7.739  24.764  1.00  0.00           H  
ATOM    304  HB2 TYR A  16      10.605   7.700  27.631  1.00  0.00           H  
ATOM    305  HB3 TYR A  16      12.050   6.897  27.027  1.00  0.00           H  
ATOM    306  HD1 TYR A  16      12.924   9.155  25.154  1.00  0.00           H  
ATOM    307  HD2 TYR A  16      11.656   9.132  29.214  1.00  0.00           H  
ATOM    308  HE1 TYR A  16      14.233  11.196  25.566  1.00  0.00           H  
ATOM    309  HE2 TYR A  16      12.960  11.174  29.639  1.00  0.00           H  
ATOM    310  HH  TYR A  16      14.751  12.786  27.032  1.00  0.00           H  
ATOM    311  N   THR A  17       8.975   6.415  24.494  1.00  0.00           N  
ATOM    312  CA  THR A  17       8.164   5.231  24.234  1.00  0.00           C  
ATOM    313  C   THR A  17       8.711   4.441  23.051  1.00  0.00           C  
ATOM    314  O   THR A  17       9.156   5.017  22.059  1.00  0.00           O  
ATOM    315  CB  THR A  17       6.696   5.606  23.952  1.00  0.00           C  
ATOM    316  OG1 THR A  17       6.097   6.154  25.130  1.00  0.00           O  
ATOM    317  CG2 THR A  17       5.906   4.390  23.493  1.00  0.00           C  
ATOM    318  H   THR A  17       8.743   7.259  24.054  1.00  0.00           H  
ATOM    319  HA  THR A  17       8.193   4.608  25.115  1.00  0.00           H  
ATOM    320  HB  THR A  17       6.675   6.349  23.168  1.00  0.00           H  
ATOM    321  HG1 THR A  17       6.549   5.815  25.907  1.00  0.00           H  
ATOM    322 HG21 THR A  17       6.051   3.580  24.193  1.00  0.00           H  
ATOM    323 HG22 THR A  17       6.250   4.086  22.517  1.00  0.00           H  
ATOM    324 HG23 THR A  17       4.858   4.640  23.445  1.00  0.00           H  
ATOM    325  N   ILE A  18       8.673   3.117  23.162  1.00  0.00           N  
ATOM    326  CA  ILE A  18       9.163   2.248  22.099  1.00  0.00           C  
ATOM    327  C   ILE A  18       8.010   1.644  21.307  1.00  0.00           C  
ATOM    328  O   ILE A  18       7.057   1.116  21.879  1.00  0.00           O  
ATOM    329  CB  ILE A  18      10.035   1.109  22.661  1.00  0.00           C  
ATOM    330  CG1 ILE A  18      11.354   1.666  23.202  1.00  0.00           C  
ATOM    331  CG2 ILE A  18      10.297   0.063  21.587  1.00  0.00           C  
ATOM    332  CD1 ILE A  18      12.208   0.629  23.895  1.00  0.00           C  
ATOM    333  H   ILE A  18       8.307   2.716  23.977  1.00  0.00           H  
ATOM    334  HA  ILE A  18       9.771   2.844  21.435  1.00  0.00           H  
ATOM    335  HB  ILE A  18       9.495   0.637  23.467  1.00  0.00           H  
ATOM    336 HG12 ILE A  18      11.926   2.076  22.385  1.00  0.00           H  
ATOM    337 HG13 ILE A  18      11.139   2.451  23.914  1.00  0.00           H  
ATOM    338 HG21 ILE A  18       9.356  -0.275  21.179  1.00  0.00           H  
ATOM    339 HG22 ILE A  18      10.894   0.498  20.801  1.00  0.00           H  
ATOM    340 HG23 ILE A  18      10.824  -0.773  22.021  1.00  0.00           H  
ATOM    341 HD11 ILE A  18      12.298  -0.245  23.265  1.00  0.00           H  
ATOM    342 HD12 ILE A  18      13.190   1.038  24.084  1.00  0.00           H  
ATOM    343 HD13 ILE A  18      11.749   0.350  24.833  1.00  0.00           H  
ATOM    344  N   PHE A  19       8.102   1.726  19.983  1.00  0.00           N  
ATOM    345  CA  PHE A  19       7.065   1.188  19.110  1.00  0.00           C  
ATOM    346  C   PHE A  19       7.656   0.746  17.773  1.00  0.00           C  
ATOM    347  O   PHE A  19       8.819   1.018  17.477  1.00  0.00           O  
ATOM    348  CB  PHE A  19       5.972   2.232  18.876  1.00  0.00           C  
ATOM    349  CG  PHE A  19       6.498   3.555  18.396  1.00  0.00           C  
ATOM    350  CD1 PHE A  19       6.969   3.699  17.102  1.00  0.00           C  
ATOM    351  CD2 PHE A  19       6.522   4.653  19.241  1.00  0.00           C  
ATOM    352  CE1 PHE A  19       7.454   4.915  16.657  1.00  0.00           C  
ATOM    353  CE2 PHE A  19       7.005   5.870  18.801  1.00  0.00           C  
ATOM    354  CZ  PHE A  19       7.473   6.002  17.507  1.00  0.00           C  
ATOM    355  H   PHE A  19       8.885   2.160  19.584  1.00  0.00           H  
ATOM    356  HA  PHE A  19       6.633   0.329  19.600  1.00  0.00           H  
ATOM    357  HB2 PHE A  19       5.283   1.860  18.133  1.00  0.00           H  
ATOM    358  HB3 PHE A  19       5.442   2.400  19.801  1.00  0.00           H  
ATOM    359  HD1 PHE A  19       6.954   2.848  16.434  1.00  0.00           H  
ATOM    360  HD2 PHE A  19       6.159   4.552  20.252  1.00  0.00           H  
ATOM    361  HE1 PHE A  19       7.818   5.013  15.645  1.00  0.00           H  
ATOM    362  HE2 PHE A  19       7.021   6.719  19.469  1.00  0.00           H  
ATOM    363  HZ  PHE A  19       7.851   6.952  17.163  1.00  0.00           H  
ATOM    364  N   GLN A  20       6.845   0.062  16.972  1.00  0.00           N  
ATOM    365  CA  GLN A  20       7.287  -0.418  15.668  1.00  0.00           C  
ATOM    366  C   GLN A  20       6.620   0.366  14.545  1.00  0.00           C  
ATOM    367  O   GLN A  20       5.394   0.424  14.456  1.00  0.00           O  
ATOM    368  CB  GLN A  20       6.978  -1.909  15.520  1.00  0.00           C  
ATOM    369  CG  GLN A  20       7.959  -2.647  14.623  1.00  0.00           C  
ATOM    370  CD  GLN A  20       7.821  -4.153  14.723  1.00  0.00           C  
ATOM    371  OE1 GLN A  20       6.755  -4.669  15.058  1.00  0.00           O  
ATOM    372  NE2 GLN A  20       8.900  -4.868  14.429  1.00  0.00           N  
ATOM    373  H   GLN A  20       5.928  -0.124  17.265  1.00  0.00           H  
ATOM    374  HA  GLN A  20       8.356  -0.273  15.606  1.00  0.00           H  
ATOM    375  HB2 GLN A  20       6.999  -2.368  16.496  1.00  0.00           H  
ATOM    376  HB3 GLN A  20       5.989  -2.019  15.100  1.00  0.00           H  
ATOM    377  HG2 GLN A  20       7.785  -2.352  13.600  1.00  0.00           H  
ATOM    378  HG3 GLN A  20       8.965  -2.374  14.909  1.00  0.00           H  
ATOM    379 HE21 GLN A  20       9.717  -4.389  14.170  1.00  0.00           H  
ATOM    380 HE22 GLN A  20       8.839  -5.844  14.485  1.00  0.00           H  
ATOM    381  N   GLY A  21       7.436   0.971  13.685  1.00  0.00           N  
ATOM    382  CA  GLY A  21       6.906   1.745  12.578  1.00  0.00           C  
ATOM    383  C   GLY A  21       7.597   1.428  11.266  1.00  0.00           C  
ATOM    384  O   GLY A  21       8.676   0.838  11.254  1.00  0.00           O  
ATOM    385  H   GLY A  21       8.405   0.891  13.805  1.00  0.00           H  
ATOM    386  HA2 GLY A  21       5.852   1.534  12.477  1.00  0.00           H  
ATOM    387  HA3 GLY A  21       7.034   2.796  12.795  1.00  0.00           H  
ATOM    388  N   GLU A  22       6.973   1.822  10.161  1.00  0.00           N  
ATOM    389  CA  GLU A  22       7.536   1.575   8.838  1.00  0.00           C  
ATOM    390  C   GLU A  22       8.047   2.869   8.213  1.00  0.00           C  
ATOM    391  O   GLU A  22       7.499   3.946   8.450  1.00  0.00           O  
ATOM    392  CB  GLU A  22       6.486   0.936   7.925  1.00  0.00           C  
ATOM    393  CG  GLU A  22       6.910   0.863   6.469  1.00  0.00           C  
ATOM    394  CD  GLU A  22       5.783   0.425   5.554  1.00  0.00           C  
ATOM    395  OE1 GLU A  22       5.447  -0.777   5.560  1.00  0.00           O  
ATOM    396  OE2 GLU A  22       5.237   1.286   4.833  1.00  0.00           O  
ATOM    397  H   GLU A  22       6.115   2.290  10.236  1.00  0.00           H  
ATOM    398  HA  GLU A  22       8.365   0.893   8.953  1.00  0.00           H  
ATOM    399  HB2 GLU A  22       6.290  -0.069   8.271  1.00  0.00           H  
ATOM    400  HB3 GLU A  22       5.575   1.512   7.986  1.00  0.00           H  
ATOM    401  HG2 GLU A  22       7.248   1.840   6.156  1.00  0.00           H  
ATOM    402  HG3 GLU A  22       7.723   0.157   6.377  1.00  0.00           H  
ATOM    403  N   VAL A  23       9.103   2.758   7.413  1.00  0.00           N  
ATOM    404  CA  VAL A  23       9.689   3.917   6.753  1.00  0.00           C  
ATOM    405  C   VAL A  23       8.811   4.398   5.604  1.00  0.00           C  
ATOM    406  O   VAL A  23       8.439   3.621   4.725  1.00  0.00           O  
ATOM    407  CB  VAL A  23      11.097   3.602   6.212  1.00  0.00           C  
ATOM    408  CG1 VAL A  23      11.543   4.675   5.228  1.00  0.00           C  
ATOM    409  CG2 VAL A  23      12.091   3.472   7.356  1.00  0.00           C  
ATOM    410  H   VAL A  23       9.496   1.872   7.263  1.00  0.00           H  
ATOM    411  HA  VAL A  23       9.776   4.708   7.483  1.00  0.00           H  
ATOM    412  HB  VAL A  23      11.057   2.660   5.688  1.00  0.00           H  
ATOM    413 HG11 VAL A  23      10.913   5.546   5.337  1.00  0.00           H  
ATOM    414 HG12 VAL A  23      12.569   4.943   5.429  1.00  0.00           H  
ATOM    415 HG13 VAL A  23      11.460   4.296   4.221  1.00  0.00           H  
ATOM    416 HG21 VAL A  23      12.864   2.771   7.082  1.00  0.00           H  
ATOM    417 HG22 VAL A  23      12.534   4.435   7.562  1.00  0.00           H  
ATOM    418 HG23 VAL A  23      11.579   3.117   8.239  1.00  0.00           H  
ATOM    419  N   ALA A  24       8.482   5.685   5.617  1.00  0.00           N  
ATOM    420  CA  ALA A  24       7.648   6.272   4.574  1.00  0.00           C  
ATOM    421  C   ALA A  24       8.462   7.196   3.675  1.00  0.00           C  
ATOM    422  O   ALA A  24       8.110   7.420   2.518  1.00  0.00           O  
ATOM    423  CB  ALA A  24       6.482   7.028   5.194  1.00  0.00           C  
ATOM    424  H   ALA A  24       8.808   6.255   6.345  1.00  0.00           H  
ATOM    425  HA  ALA A  24       7.245   5.466   3.977  1.00  0.00           H  
ATOM    426  HB1 ALA A  24       6.856   7.888   5.732  1.00  0.00           H  
ATOM    427  HB2 ALA A  24       5.810   7.355   4.414  1.00  0.00           H  
ATOM    428  HB3 ALA A  24       5.954   6.379   5.877  1.00  0.00           H  
ATOM    429  N   MET A  25       9.552   7.729   4.217  1.00  0.00           N  
ATOM    430  CA  MET A  25      10.418   8.629   3.462  1.00  0.00           C  
ATOM    431  C   MET A  25      11.874   8.462   3.880  1.00  0.00           C  
ATOM    432  O   MET A  25      12.176   8.296   5.062  1.00  0.00           O  
ATOM    433  CB  MET A  25       9.979  10.081   3.664  1.00  0.00           C  
ATOM    434  CG  MET A  25      10.615  11.050   2.680  1.00  0.00           C  
ATOM    435  SD  MET A  25       9.576  12.485   2.347  1.00  0.00           S  
ATOM    436  CE  MET A  25      10.810  13.700   1.891  1.00  0.00           C  
ATOM    437  H   MET A  25       9.782   7.513   5.145  1.00  0.00           H  
ATOM    438  HA  MET A  25      10.325   8.377   2.415  1.00  0.00           H  
ATOM    439  HB2 MET A  25       8.908  10.140   3.551  1.00  0.00           H  
ATOM    440  HB3 MET A  25      10.246  10.390   4.663  1.00  0.00           H  
ATOM    441  HG2 MET A  25      11.556  11.392   3.088  1.00  0.00           H  
ATOM    442  HG3 MET A  25      10.798  10.531   1.752  1.00  0.00           H  
ATOM    443  HE1 MET A  25      11.550  13.239   1.252  1.00  0.00           H  
ATOM    444  HE2 MET A  25      10.335  14.513   1.363  1.00  0.00           H  
ATOM    445  HE3 MET A  25      11.289  14.077   2.782  1.00  0.00           H  
ATOM    446  N   VAL A  26      12.776   8.506   2.904  1.00  0.00           N  
ATOM    447  CA  VAL A  26      14.201   8.361   3.173  1.00  0.00           C  
ATOM    448  C   VAL A  26      14.980   9.575   2.679  1.00  0.00           C  
ATOM    449  O   VAL A  26      14.900   9.945   1.506  1.00  0.00           O  
ATOM    450  CB  VAL A  26      14.771   7.094   2.508  1.00  0.00           C  
ATOM    451  CG1 VAL A  26      16.254   6.951   2.813  1.00  0.00           C  
ATOM    452  CG2 VAL A  26      14.004   5.863   2.963  1.00  0.00           C  
ATOM    453  H   VAL A  26      12.474   8.641   1.981  1.00  0.00           H  
ATOM    454  HA  VAL A  26      14.333   8.271   4.241  1.00  0.00           H  
ATOM    455  HB  VAL A  26      14.655   7.190   1.438  1.00  0.00           H  
ATOM    456 HG11 VAL A  26      16.434   7.200   3.850  1.00  0.00           H  
ATOM    457 HG12 VAL A  26      16.563   5.933   2.628  1.00  0.00           H  
ATOM    458 HG13 VAL A  26      16.818   7.621   2.180  1.00  0.00           H  
ATOM    459 HG21 VAL A  26      13.740   5.264   2.104  1.00  0.00           H  
ATOM    460 HG22 VAL A  26      14.620   5.279   3.631  1.00  0.00           H  
ATOM    461 HG23 VAL A  26      13.104   6.168   3.477  1.00  0.00           H  
ATOM    462  N   THR A  27      15.735  10.195   3.582  1.00  0.00           N  
ATOM    463  CA  THR A  27      16.529  11.368   3.240  1.00  0.00           C  
ATOM    464  C   THR A  27      17.990  11.175   3.626  1.00  0.00           C  
ATOM    465  O   THR A  27      18.318  10.319   4.449  1.00  0.00           O  
ATOM    466  CB  THR A  27      15.989  12.633   3.932  1.00  0.00           C  
ATOM    467  OG1 THR A  27      16.217  12.554   5.343  1.00  0.00           O  
ATOM    468  CG2 THR A  27      14.501  12.805   3.662  1.00  0.00           C  
ATOM    469  H   THR A  27      15.757   9.852   4.500  1.00  0.00           H  
ATOM    470  HA  THR A  27      16.464  11.513   2.171  1.00  0.00           H  
ATOM    471  HB  THR A  27      16.512  13.492   3.538  1.00  0.00           H  
ATOM    472  HG1 THR A  27      15.485  12.092   5.761  1.00  0.00           H  
ATOM    473 HG21 THR A  27      14.227  13.839   3.802  1.00  0.00           H  
ATOM    474 HG22 THR A  27      13.938  12.187   4.347  1.00  0.00           H  
ATOM    475 HG23 THR A  27      14.283  12.508   2.647  1.00  0.00           H  
ATOM    476  N   ASP A  28      18.867  11.976   3.030  1.00  0.00           N  
ATOM    477  CA  ASP A  28      20.294  11.894   3.313  1.00  0.00           C  
ATOM    478  C   ASP A  28      20.606  12.461   4.694  1.00  0.00           C  
ATOM    479  O   ASP A  28      21.766  12.521   5.103  1.00  0.00           O  
ATOM    480  CB  ASP A  28      21.091  12.646   2.247  1.00  0.00           C  
ATOM    481  CG  ASP A  28      21.208  11.866   0.952  1.00  0.00           C  
ATOM    482  OD1 ASP A  28      20.248  11.146   0.606  1.00  0.00           O  
ATOM    483  OD2 ASP A  28      22.258  11.977   0.286  1.00  0.00           O  
ATOM    484  H   ASP A  28      18.544  12.638   2.382  1.00  0.00           H  
ATOM    485  HA  ASP A  28      20.577  10.853   3.293  1.00  0.00           H  
ATOM    486  HB2 ASP A  28      20.601  13.586   2.036  1.00  0.00           H  
ATOM    487  HB3 ASP A  28      22.086  12.840   2.619  1.00  0.00           H  
ATOM    488  N   TYR A  29      19.566  12.877   5.407  1.00  0.00           N  
ATOM    489  CA  TYR A  29      19.730  13.442   6.741  1.00  0.00           C  
ATOM    490  C   TYR A  29      18.845  12.719   7.752  1.00  0.00           C  
ATOM    491  O   TYR A  29      18.720  13.143   8.900  1.00  0.00           O  
ATOM    492  CB  TYR A  29      19.393  14.935   6.729  1.00  0.00           C  
ATOM    493  CG  TYR A  29      18.047  15.248   6.116  1.00  0.00           C  
ATOM    494  CD1 TYR A  29      16.869  14.856   6.740  1.00  0.00           C  
ATOM    495  CD2 TYR A  29      17.953  15.936   4.913  1.00  0.00           C  
ATOM    496  CE1 TYR A  29      15.637  15.139   6.183  1.00  0.00           C  
ATOM    497  CE2 TYR A  29      16.726  16.226   4.348  1.00  0.00           C  
ATOM    498  CZ  TYR A  29      15.571  15.824   4.987  1.00  0.00           C  
ATOM    499  OH  TYR A  29      14.346  16.108   4.428  1.00  0.00           O  
ATOM    500  H   TYR A  29      18.666  12.803   5.026  1.00  0.00           H  
ATOM    501  HA  TYR A  29      20.763  13.320   7.029  1.00  0.00           H  
ATOM    502  HB2 TYR A  29      19.389  15.304   7.743  1.00  0.00           H  
ATOM    503  HB3 TYR A  29      20.147  15.462   6.163  1.00  0.00           H  
ATOM    504  HD1 TYR A  29      16.924  14.320   7.677  1.00  0.00           H  
ATOM    505  HD2 TYR A  29      18.860  16.249   4.415  1.00  0.00           H  
ATOM    506  HE1 TYR A  29      14.732  14.825   6.682  1.00  0.00           H  
ATOM    507  HE2 TYR A  29      16.673  16.761   3.413  1.00  0.00           H  
ATOM    508  HH  TYR A  29      14.413  16.068   3.472  1.00  0.00           H  
ATOM    509  N   GLY A  30      18.237  11.620   7.316  1.00  0.00           N  
ATOM    510  CA  GLY A  30      17.373  10.852   8.194  1.00  0.00           C  
ATOM    511  C   GLY A  30      16.271  10.135   7.442  1.00  0.00           C  
ATOM    512  O   GLY A  30      16.291  10.067   6.213  1.00  0.00           O  
ATOM    513  H   GLY A  30      18.375  11.328   6.391  1.00  0.00           H  
ATOM    514  HA2 GLY A  30      17.970  10.123   8.720  1.00  0.00           H  
ATOM    515  HA3 GLY A  30      16.925  11.522   8.914  1.00  0.00           H  
ATOM    516  N   ALA A  31      15.305   9.595   8.180  1.00  0.00           N  
ATOM    517  CA  ALA A  31      14.190   8.881   7.573  1.00  0.00           C  
ATOM    518  C   ALA A  31      12.916   9.056   8.393  1.00  0.00           C  
ATOM    519  O   ALA A  31      12.961   9.141   9.620  1.00  0.00           O  
ATOM    520  CB  ALA A  31      14.528   7.404   7.429  1.00  0.00           C  
ATOM    521  H   ALA A  31      15.345   9.682   9.155  1.00  0.00           H  
ATOM    522  HA  ALA A  31      14.031   9.286   6.586  1.00  0.00           H  
ATOM    523  HB1 ALA A  31      15.191   7.268   6.588  1.00  0.00           H  
ATOM    524  HB2 ALA A  31      15.009   7.055   8.329  1.00  0.00           H  
ATOM    525  HB3 ALA A  31      13.619   6.843   7.264  1.00  0.00           H  
ATOM    526  N   PHE A  32      11.780   9.110   7.706  1.00  0.00           N  
ATOM    527  CA  PHE A  32      10.492   9.277   8.370  1.00  0.00           C  
ATOM    528  C   PHE A  32       9.846   7.925   8.653  1.00  0.00           C  
ATOM    529  O   PHE A  32       9.841   7.037   7.801  1.00  0.00           O  
ATOM    530  CB  PHE A  32       9.557  10.131   7.508  1.00  0.00           C  
ATOM    531  CG  PHE A  32       9.970  11.572   7.424  1.00  0.00           C  
ATOM    532  CD1 PHE A  32      11.114  11.940   6.735  1.00  0.00           C  
ATOM    533  CD2 PHE A  32       9.213  12.559   8.034  1.00  0.00           C  
ATOM    534  CE1 PHE A  32      11.497  13.266   6.655  1.00  0.00           C  
ATOM    535  CE2 PHE A  32       9.590  13.887   7.957  1.00  0.00           C  
ATOM    536  CZ  PHE A  32      10.735  14.241   7.268  1.00  0.00           C  
ATOM    537  H   PHE A  32      11.808   9.036   6.729  1.00  0.00           H  
ATOM    538  HA  PHE A  32      10.666   9.784   9.306  1.00  0.00           H  
ATOM    539  HB2 PHE A  32       9.540   9.732   6.505  1.00  0.00           H  
ATOM    540  HB3 PHE A  32       8.562  10.093   7.925  1.00  0.00           H  
ATOM    541  HD1 PHE A  32      11.712  11.178   6.255  1.00  0.00           H  
ATOM    542  HD2 PHE A  32       8.320  12.285   8.574  1.00  0.00           H  
ATOM    543  HE1 PHE A  32      12.391  13.538   6.115  1.00  0.00           H  
ATOM    544  HE2 PHE A  32       8.993  14.648   8.437  1.00  0.00           H  
ATOM    545  HZ  PHE A  32      11.030  15.279   7.205  1.00  0.00           H  
ATOM    546  N   ILE A  33       9.304   7.777   9.858  1.00  0.00           N  
ATOM    547  CA  ILE A  33       8.655   6.532  10.255  1.00  0.00           C  
ATOM    548  C   ILE A  33       7.199   6.770  10.636  1.00  0.00           C  
ATOM    549  O   ILE A  33       6.866   7.772  11.268  1.00  0.00           O  
ATOM    550  CB  ILE A  33       9.384   5.871  11.439  1.00  0.00           C  
ATOM    551  CG1 ILE A  33      10.869   5.690  11.117  1.00  0.00           C  
ATOM    552  CG2 ILE A  33       8.743   4.533  11.775  1.00  0.00           C  
ATOM    553  CD1 ILE A  33      11.124   4.783   9.934  1.00  0.00           C  
ATOM    554  H   ILE A  33       9.340   8.520  10.494  1.00  0.00           H  
ATOM    555  HA  ILE A  33       8.690   5.855   9.413  1.00  0.00           H  
ATOM    556  HB  ILE A  33       9.285   6.516  12.299  1.00  0.00           H  
ATOM    557 HG12 ILE A  33      11.303   6.653  10.896  1.00  0.00           H  
ATOM    558 HG13 ILE A  33      11.366   5.265  11.977  1.00  0.00           H  
ATOM    559 HG21 ILE A  33       8.265   4.132  10.893  1.00  0.00           H  
ATOM    560 HG22 ILE A  33       9.502   3.846  12.116  1.00  0.00           H  
ATOM    561 HG23 ILE A  33       8.005   4.671  12.551  1.00  0.00           H  
ATOM    562 HD11 ILE A  33      10.187   4.376   9.582  1.00  0.00           H  
ATOM    563 HD12 ILE A  33      11.592   5.347   9.142  1.00  0.00           H  
ATOM    564 HD13 ILE A  33      11.776   3.975  10.235  1.00  0.00           H  
ATOM    565  N   LYS A  34       6.332   5.839  10.250  1.00  0.00           N  
ATOM    566  CA  LYS A  34       4.910   5.944  10.553  1.00  0.00           C  
ATOM    567  C   LYS A  34       4.564   5.161  11.816  1.00  0.00           C  
ATOM    568  O   LYS A  34       4.798   3.954  11.892  1.00  0.00           O  
ATOM    569  CB  LYS A  34       4.077   5.431   9.377  1.00  0.00           C  
ATOM    570  CG  LYS A  34       4.402   6.110   8.059  1.00  0.00           C  
ATOM    571  CD  LYS A  34       3.248   6.002   7.077  1.00  0.00           C  
ATOM    572  CE  LYS A  34       2.101   6.924   7.459  1.00  0.00           C  
ATOM    573  NZ  LYS A  34       1.133   6.255   8.373  1.00  0.00           N  
ATOM    574  H   LYS A  34       6.658   5.063   9.749  1.00  0.00           H  
ATOM    575  HA  LYS A  34       4.681   6.986  10.718  1.00  0.00           H  
ATOM    576  HB2 LYS A  34       4.251   4.370   9.264  1.00  0.00           H  
ATOM    577  HB3 LYS A  34       3.031   5.593   9.595  1.00  0.00           H  
ATOM    578  HG2 LYS A  34       4.606   7.154   8.244  1.00  0.00           H  
ATOM    579  HG3 LYS A  34       5.275   5.642   7.628  1.00  0.00           H  
ATOM    580  HD2 LYS A  34       3.599   6.272   6.092  1.00  0.00           H  
ATOM    581  HD3 LYS A  34       2.890   4.982   7.065  1.00  0.00           H  
ATOM    582  HE2 LYS A  34       2.504   7.795   7.952  1.00  0.00           H  
ATOM    583  HE3 LYS A  34       1.583   7.226   6.560  1.00  0.00           H  
ATOM    584  HZ1 LYS A  34       0.180   6.264   7.954  1.00  0.00           H  
ATOM    585  HZ2 LYS A  34       1.103   6.752   9.287  1.00  0.00           H  
ATOM    586  HZ3 LYS A  34       1.419   5.269   8.537  1.00  0.00           H  
ATOM    587  N   ILE A  35       4.005   5.854  12.802  1.00  0.00           N  
ATOM    588  CA  ILE A  35       3.626   5.222  14.060  1.00  0.00           C  
ATOM    589  C   ILE A  35       2.239   4.593  13.962  1.00  0.00           C  
ATOM    590  O   ILE A  35       1.307   5.172  13.406  1.00  0.00           O  
ATOM    591  CB  ILE A  35       3.638   6.230  15.223  1.00  0.00           C  
ATOM    592  CG1 ILE A  35       5.011   6.898  15.332  1.00  0.00           C  
ATOM    593  CG2 ILE A  35       3.277   5.537  16.529  1.00  0.00           C  
ATOM    594  CD1 ILE A  35       4.987   8.203  16.097  1.00  0.00           C  
ATOM    595  H   ILE A  35       3.844   6.812  12.681  1.00  0.00           H  
ATOM    596  HA  ILE A  35       4.346   4.446  14.273  1.00  0.00           H  
ATOM    597  HB  ILE A  35       2.893   6.984  15.025  1.00  0.00           H  
ATOM    598 HG12 ILE A  35       5.692   6.230  15.835  1.00  0.00           H  
ATOM    599 HG13 ILE A  35       5.383   7.102  14.338  1.00  0.00           H  
ATOM    600 HG21 ILE A  35       2.964   6.275  17.254  1.00  0.00           H  
ATOM    601 HG22 ILE A  35       2.470   4.841  16.355  1.00  0.00           H  
ATOM    602 HG23 ILE A  35       4.138   5.004  16.905  1.00  0.00           H  
ATOM    603 HD11 ILE A  35       4.029   8.682  15.964  1.00  0.00           H  
ATOM    604 HD12 ILE A  35       5.153   8.009  17.146  1.00  0.00           H  
ATOM    605 HD13 ILE A  35       5.768   8.852  15.725  1.00  0.00           H  
ATOM    606  N   PRO A  36       2.099   3.382  14.519  1.00  0.00           N  
ATOM    607  CA  PRO A  36       0.829   2.649  14.509  1.00  0.00           C  
ATOM    608  C   PRO A  36      -0.219   3.292  15.413  1.00  0.00           C  
ATOM    609  O   PRO A  36      -0.092   3.277  16.635  1.00  0.00           O  
ATOM    610  CB  PRO A  36       1.213   1.265  15.039  1.00  0.00           C  
ATOM    611  CG  PRO A  36       2.432   1.500  15.862  1.00  0.00           C  
ATOM    612  CD  PRO A  36       3.168   2.632  15.199  1.00  0.00           C  
ATOM    613  HA  PRO A  36       0.432   2.556  13.510  1.00  0.00           H  
ATOM    614  HB2 PRO A  36       0.404   0.867  15.635  1.00  0.00           H  
ATOM    615  HB3 PRO A  36       1.417   0.604  14.212  1.00  0.00           H  
ATOM    616  HG2 PRO A  36       2.149   1.774  16.868  1.00  0.00           H  
ATOM    617  HG3 PRO A  36       3.045   0.611  15.873  1.00  0.00           H  
ATOM    618  HD2 PRO A  36       3.659   3.247  15.939  1.00  0.00           H  
ATOM    619  HD3 PRO A  36       3.885   2.251  14.487  1.00  0.00           H  
ATOM    620  N   GLY A  37      -1.255   3.858  14.799  1.00  0.00           N  
ATOM    621  CA  GLY A  37      -2.309   4.500  15.563  1.00  0.00           C  
ATOM    622  C   GLY A  37      -1.982   5.939  15.907  1.00  0.00           C  
ATOM    623  O   GLY A  37      -2.115   6.356  17.058  1.00  0.00           O  
ATOM    624  H   GLY A  37      -1.303   3.841  13.820  1.00  0.00           H  
ATOM    625  HA2 GLY A  37      -3.222   4.475  14.988  1.00  0.00           H  
ATOM    626  HA3 GLY A  37      -2.459   3.948  16.481  1.00  0.00           H  
ATOM    627  N   CYS A  38      -1.551   6.701  14.907  1.00  0.00           N  
ATOM    628  CA  CYS A  38      -1.202   8.102  15.110  1.00  0.00           C  
ATOM    629  C   CYS A  38      -1.718   8.963  13.960  1.00  0.00           C  
ATOM    630  O   CYS A  38      -2.411   8.474  13.068  1.00  0.00           O  
ATOM    631  CB  CYS A  38       0.313   8.259  15.239  1.00  0.00           C  
ATOM    632  SG  CYS A  38       1.181   8.382  13.657  1.00  0.00           S  
ATOM    633  H   CYS A  38      -1.466   6.311  14.011  1.00  0.00           H  
ATOM    634  HA  CYS A  38      -1.669   8.431  16.026  1.00  0.00           H  
ATOM    635  HB2 CYS A  38       0.528   9.155  15.801  1.00  0.00           H  
ATOM    636  HB3 CYS A  38       0.711   7.406  15.768  1.00  0.00           H  
ATOM    637  HG  CYS A  38       2.370   8.919  13.883  1.00  0.00           H  
ATOM    638  N   ARG A  39      -1.377  10.247  13.990  1.00  0.00           N  
ATOM    639  CA  ARG A  39      -1.808  11.176  12.952  1.00  0.00           C  
ATOM    640  C   ARG A  39      -0.607  11.841  12.284  1.00  0.00           C  
ATOM    641  O   ARG A  39      -0.659  12.203  11.109  1.00  0.00           O  
ATOM    642  CB  ARG A  39      -2.731  12.243  13.544  1.00  0.00           C  
ATOM    643  CG  ARG A  39      -3.368  13.144  12.499  1.00  0.00           C  
ATOM    644  CD  ARG A  39      -4.011  14.366  13.136  1.00  0.00           C  
ATOM    645  NE  ARG A  39      -3.017  15.336  13.589  1.00  0.00           N  
ATOM    646  CZ  ARG A  39      -3.328  16.524  14.094  1.00  0.00           C  
ATOM    647  NH1 ARG A  39      -4.597  16.887  14.212  1.00  0.00           N  
ATOM    648  NH2 ARG A  39      -2.365  17.351  14.485  1.00  0.00           N  
ATOM    649  H   ARG A  39      -0.823  10.577  14.726  1.00  0.00           H  
ATOM    650  HA  ARG A  39      -2.353  10.612  12.208  1.00  0.00           H  
ATOM    651  HB2 ARG A  39      -3.520  11.754  14.096  1.00  0.00           H  
ATOM    652  HB3 ARG A  39      -2.159  12.860  14.220  1.00  0.00           H  
ATOM    653  HG2 ARG A  39      -2.607  13.472  11.807  1.00  0.00           H  
ATOM    654  HG3 ARG A  39      -4.124  12.585  11.969  1.00  0.00           H  
ATOM    655  HD2 ARG A  39      -4.655  14.838  12.409  1.00  0.00           H  
ATOM    656  HD3 ARG A  39      -4.600  14.046  13.982  1.00  0.00           H  
ATOM    657  HE  ARG A  39      -2.072  15.086  13.510  1.00  0.00           H  
ATOM    658 HH11 ARG A  39      -5.323  16.267  13.920  1.00  0.00           H  
ATOM    659 HH12 ARG A  39      -4.827  17.783  14.594  1.00  0.00           H  
ATOM    660 HH21 ARG A  39      -1.407  17.080  14.398  1.00  0.00           H  
ATOM    661 HH22 ARG A  39      -2.599  18.245  14.864  1.00  0.00           H  
ATOM    662  N   LYS A  40       0.473  11.998  13.042  1.00  0.00           N  
ATOM    663  CA  LYS A  40       1.688  12.617  12.525  1.00  0.00           C  
ATOM    664  C   LYS A  40       2.836  11.614  12.487  1.00  0.00           C  
ATOM    665  O   LYS A  40       2.817  10.608  13.195  1.00  0.00           O  
ATOM    666  CB  LYS A  40       2.076  13.821  13.387  1.00  0.00           C  
ATOM    667  CG  LYS A  40       1.240  15.060  13.113  1.00  0.00           C  
ATOM    668  CD  LYS A  40       1.860  15.920  12.025  1.00  0.00           C  
ATOM    669  CE  LYS A  40       1.430  17.374  12.153  1.00  0.00           C  
ATOM    670  NZ  LYS A  40       2.318  18.285  11.379  1.00  0.00           N  
ATOM    671  H   LYS A  40       0.452  11.687  13.972  1.00  0.00           H  
ATOM    672  HA  LYS A  40       1.486  12.954  11.520  1.00  0.00           H  
ATOM    673  HB2 LYS A  40       1.962  13.556  14.427  1.00  0.00           H  
ATOM    674  HB3 LYS A  40       3.113  14.063  13.198  1.00  0.00           H  
ATOM    675  HG2 LYS A  40       0.253  14.754  12.799  1.00  0.00           H  
ATOM    676  HG3 LYS A  40       1.168  15.640  14.022  1.00  0.00           H  
ATOM    677  HD2 LYS A  40       2.935  15.867  12.104  1.00  0.00           H  
ATOM    678  HD3 LYS A  40       1.547  15.546  11.061  1.00  0.00           H  
ATOM    679  HE2 LYS A  40       0.421  17.471  11.786  1.00  0.00           H  
ATOM    680  HE3 LYS A  40       1.462  17.654  13.196  1.00  0.00           H  
ATOM    681  HZ1 LYS A  40       1.811  19.162  11.143  1.00  0.00           H  
ATOM    682  HZ2 LYS A  40       2.620  17.825  10.497  1.00  0.00           H  
ATOM    683  HZ3 LYS A  40       3.161  18.524  11.940  1.00  0.00           H  
ATOM    684  N   GLN A  41       3.834  11.896  11.656  1.00  0.00           N  
ATOM    685  CA  GLN A  41       4.991  11.018  11.526  1.00  0.00           C  
ATOM    686  C   GLN A  41       6.235  11.664  12.130  1.00  0.00           C  
ATOM    687  O   GLN A  41       6.353  12.887  12.170  1.00  0.00           O  
ATOM    688  CB  GLN A  41       5.239  10.681  10.055  1.00  0.00           C  
ATOM    689  CG  GLN A  41       4.251   9.676   9.486  1.00  0.00           C  
ATOM    690  CD  GLN A  41       3.026  10.337   8.888  1.00  0.00           C  
ATOM    691  OE1 GLN A  41       2.280  11.030   9.579  1.00  0.00           O  
ATOM    692  NE2 GLN A  41       2.811  10.127   7.593  1.00  0.00           N  
ATOM    693  H   GLN A  41       3.792  12.713  11.117  1.00  0.00           H  
ATOM    694  HA  GLN A  41       4.777  10.107  12.063  1.00  0.00           H  
ATOM    695  HB2 GLN A  41       5.173  11.589   9.474  1.00  0.00           H  
ATOM    696  HB3 GLN A  41       6.234  10.272   9.955  1.00  0.00           H  
ATOM    697  HG2 GLN A  41       4.745   9.103   8.714  1.00  0.00           H  
ATOM    698  HG3 GLN A  41       3.935   9.014  10.278  1.00  0.00           H  
ATOM    699 HE21 GLN A  41       3.448   9.564   7.105  1.00  0.00           H  
ATOM    700 HE22 GLN A  41       2.026  10.542   7.182  1.00  0.00           H  
ATOM    701  N   GLY A  42       7.158  10.831  12.597  1.00  0.00           N  
ATOM    702  CA  GLY A  42       8.382  11.338  13.193  1.00  0.00           C  
ATOM    703  C   GLY A  42       9.577  11.197  12.273  1.00  0.00           C  
ATOM    704  O   GLY A  42       9.583  10.353  11.374  1.00  0.00           O  
ATOM    705  H   GLY A  42       7.011   9.864  12.538  1.00  0.00           H  
ATOM    706  HA2 GLY A  42       8.245  12.383  13.432  1.00  0.00           H  
ATOM    707  HA3 GLY A  42       8.576  10.794  14.105  1.00  0.00           H  
ATOM    708  N   LEU A  43      10.594  12.024  12.493  1.00  0.00           N  
ATOM    709  CA  LEU A  43      11.800  11.987  11.675  1.00  0.00           C  
ATOM    710  C   LEU A  43      12.988  11.466  12.480  1.00  0.00           C  
ATOM    711  O   LEU A  43      13.167  11.821  13.645  1.00  0.00           O  
ATOM    712  CB  LEU A  43      12.113  13.382  11.130  1.00  0.00           C  
ATOM    713  CG  LEU A  43      13.524  13.584  10.574  1.00  0.00           C  
ATOM    714  CD1 LEU A  43      13.633  12.999   9.174  1.00  0.00           C  
ATOM    715  CD2 LEU A  43      13.886  15.062  10.567  1.00  0.00           C  
ATOM    716  H   LEU A  43      10.532  12.674  13.224  1.00  0.00           H  
ATOM    717  HA  LEU A  43      11.620  11.318  10.848  1.00  0.00           H  
ATOM    718  HB2 LEU A  43      11.413  13.591  10.338  1.00  0.00           H  
ATOM    719  HB3 LEU A  43      11.968  14.089  11.935  1.00  0.00           H  
ATOM    720  HG  LEU A  43      14.232  13.068  11.207  1.00  0.00           H  
ATOM    721 HD11 LEU A  43      13.031  12.106   9.109  1.00  0.00           H  
ATOM    722 HD12 LEU A  43      14.665  12.755   8.966  1.00  0.00           H  
ATOM    723 HD13 LEU A  43      13.283  13.724   8.453  1.00  0.00           H  
ATOM    724 HD21 LEU A  43      13.449  15.544  11.428  1.00  0.00           H  
ATOM    725 HD22 LEU A  43      13.504  15.522   9.666  1.00  0.00           H  
ATOM    726 HD23 LEU A  43      14.959  15.169  10.599  1.00  0.00           H  
ATOM    727  N   VAL A  44      13.798  10.621  11.849  1.00  0.00           N  
ATOM    728  CA  VAL A  44      14.970  10.052  12.504  1.00  0.00           C  
ATOM    729  C   VAL A  44      16.257  10.547  11.854  1.00  0.00           C  
ATOM    730  O   VAL A  44      16.662  10.054  10.800  1.00  0.00           O  
ATOM    731  CB  VAL A  44      14.945   8.512  12.463  1.00  0.00           C  
ATOM    732  CG1 VAL A  44      16.254   7.944  12.990  1.00  0.00           C  
ATOM    733  CG2 VAL A  44      13.763   7.979  13.256  1.00  0.00           C  
ATOM    734  H   VAL A  44      13.604  10.374  10.921  1.00  0.00           H  
ATOM    735  HA  VAL A  44      14.958  10.364  13.538  1.00  0.00           H  
ATOM    736  HB  VAL A  44      14.831   8.202  11.435  1.00  0.00           H  
ATOM    737 HG11 VAL A  44      16.050   7.057  13.574  1.00  0.00           H  
ATOM    738 HG12 VAL A  44      16.896   7.690  12.161  1.00  0.00           H  
ATOM    739 HG13 VAL A  44      16.741   8.679  13.613  1.00  0.00           H  
ATOM    740 HG21 VAL A  44      13.595   6.944  12.996  1.00  0.00           H  
ATOM    741 HG22 VAL A  44      13.974   8.053  14.313  1.00  0.00           H  
ATOM    742 HG23 VAL A  44      12.881   8.556  13.024  1.00  0.00           H  
ATOM    743  N   HIS A  45      16.896  11.524  12.488  1.00  0.00           N  
ATOM    744  CA  HIS A  45      18.141  12.085  11.972  1.00  0.00           C  
ATOM    745  C   HIS A  45      19.131  10.980  11.622  1.00  0.00           C  
ATOM    746  O   HIS A  45      19.089   9.890  12.195  1.00  0.00           O  
ATOM    747  CB  HIS A  45      18.759  13.036  12.995  1.00  0.00           C  
ATOM    748  CG  HIS A  45      19.574  14.132  12.380  1.00  0.00           C  
ATOM    749  ND1 HIS A  45      20.850  14.447  12.798  1.00  0.00           N  
ATOM    750  CD2 HIS A  45      19.289  14.987  11.370  1.00  0.00           C  
ATOM    751  CE1 HIS A  45      21.314  15.449  12.073  1.00  0.00           C  
ATOM    752  NE2 HIS A  45      20.385  15.795  11.198  1.00  0.00           N  
ATOM    753  H   HIS A  45      16.524  11.875  13.323  1.00  0.00           H  
ATOM    754  HA  HIS A  45      17.906  12.639  11.075  1.00  0.00           H  
ATOM    755  HB2 HIS A  45      17.971  13.495  13.574  1.00  0.00           H  
ATOM    756  HB3 HIS A  45      19.403  12.474  13.656  1.00  0.00           H  
ATOM    757  HD2 HIS A  45      18.370  15.027  10.803  1.00  0.00           H  
ATOM    758  HE1 HIS A  45      22.285  15.908  12.176  1.00  0.00           H  
ATOM    759  HE2 HIS A  45      20.437  16.567  10.597  1.00  0.00           H  
ATOM    760  N   ARG A  46      20.022  11.267  10.677  1.00  0.00           N  
ATOM    761  CA  ARG A  46      21.022  10.295  10.251  1.00  0.00           C  
ATOM    762  C   ARG A  46      21.921   9.891  11.416  1.00  0.00           C  
ATOM    763  O   ARG A  46      22.394   8.756  11.486  1.00  0.00           O  
ATOM    764  CB  ARG A  46      21.870  10.872   9.116  1.00  0.00           C  
ATOM    765  CG  ARG A  46      22.654  12.113   9.509  1.00  0.00           C  
ATOM    766  CD  ARG A  46      23.575  12.568   8.390  1.00  0.00           C  
ATOM    767  NE  ARG A  46      24.230  13.836   8.702  1.00  0.00           N  
ATOM    768  CZ  ARG A  46      25.229  14.343   7.985  1.00  0.00           C  
ATOM    769  NH1 ARG A  46      25.684  13.694   6.923  1.00  0.00           N  
ATOM    770  NH2 ARG A  46      25.773  15.502   8.333  1.00  0.00           N  
ATOM    771  H   ARG A  46      20.005  12.152  10.258  1.00  0.00           H  
ATOM    772  HA  ARG A  46      20.503   9.419   9.892  1.00  0.00           H  
ATOM    773  HB2 ARG A  46      22.573  10.119   8.789  1.00  0.00           H  
ATOM    774  HB3 ARG A  46      21.221  11.128   8.292  1.00  0.00           H  
ATOM    775  HG2 ARG A  46      21.959  12.908   9.735  1.00  0.00           H  
ATOM    776  HG3 ARG A  46      23.247  11.890  10.384  1.00  0.00           H  
ATOM    777  HD2 ARG A  46      24.331  11.812   8.233  1.00  0.00           H  
ATOM    778  HD3 ARG A  46      22.993  12.686   7.488  1.00  0.00           H  
ATOM    779  HE  ARG A  46      23.910  14.332   9.482  1.00  0.00           H  
ATOM    780 HH11 ARG A  46      25.274  12.821   6.658  1.00  0.00           H  
ATOM    781 HH12 ARG A  46      26.435  14.078   6.386  1.00  0.00           H  
ATOM    782 HH21 ARG A  46      25.432  15.995   9.132  1.00  0.00           H  
ATOM    783 HH22 ARG A  46      26.524  15.883   7.794  1.00  0.00           H  
ATOM    784  N   THR A  47      22.152  10.829  12.330  1.00  0.00           N  
ATOM    785  CA  THR A  47      22.994  10.572  13.492  1.00  0.00           C  
ATOM    786  C   THR A  47      22.388   9.496  14.385  1.00  0.00           C  
ATOM    787  O   THR A  47      23.105   8.753  15.055  1.00  0.00           O  
ATOM    788  CB  THR A  47      23.210  11.850  14.323  1.00  0.00           C  
ATOM    789  OG1 THR A  47      21.952  12.349  14.790  1.00  0.00           O  
ATOM    790  CG2 THR A  47      23.911  12.920  13.500  1.00  0.00           C  
ATOM    791  H   THR A  47      21.747  11.714  12.220  1.00  0.00           H  
ATOM    792  HA  THR A  47      23.957  10.232  13.138  1.00  0.00           H  
ATOM    793  HB  THR A  47      23.831  11.609  15.174  1.00  0.00           H  
ATOM    794  HG1 THR A  47      21.909  12.265  15.746  1.00  0.00           H  
ATOM    795 HG21 THR A  47      23.174  13.555  13.030  1.00  0.00           H  
ATOM    796 HG22 THR A  47      24.517  12.449  12.739  1.00  0.00           H  
ATOM    797 HG23 THR A  47      24.541  13.515  14.144  1.00  0.00           H  
ATOM    798  N   HIS A  48      21.060   9.415  14.388  1.00  0.00           N  
ATOM    799  CA  HIS A  48      20.356   8.428  15.197  1.00  0.00           C  
ATOM    800  C   HIS A  48      20.012   7.193  14.371  1.00  0.00           C  
ATOM    801  O   HIS A  48      19.806   6.108  14.914  1.00  0.00           O  
ATOM    802  CB  HIS A  48      19.080   9.034  15.784  1.00  0.00           C  
ATOM    803  CG  HIS A  48      19.337  10.148  16.753  1.00  0.00           C  
ATOM    804  ND1 HIS A  48      19.460   9.951  18.111  1.00  0.00           N  
ATOM    805  CD2 HIS A  48      19.496  11.477  16.550  1.00  0.00           C  
ATOM    806  CE1 HIS A  48      19.682  11.111  18.703  1.00  0.00           C  
ATOM    807  NE2 HIS A  48      19.709  12.053  17.778  1.00  0.00           N  
ATOM    808  H   HIS A  48      20.543  10.035  13.832  1.00  0.00           H  
ATOM    809  HA  HIS A  48      21.009   8.135  16.006  1.00  0.00           H  
ATOM    810  HB2 HIS A  48      18.473   9.427  14.982  1.00  0.00           H  
ATOM    811  HB3 HIS A  48      18.529   8.263  16.303  1.00  0.00           H  
ATOM    812  HD2 HIS A  48      19.461  11.991  15.600  1.00  0.00           H  
ATOM    813  HE1 HIS A  48      19.819  11.263  19.764  1.00  0.00           H  
ATOM    814  HE2 HIS A  48      19.771  13.015  17.954  1.00  0.00           H  
ATOM    815  N   MET A  49      19.952   7.365  13.055  1.00  0.00           N  
ATOM    816  CA  MET A  49      19.634   6.264  12.153  1.00  0.00           C  
ATOM    817  C   MET A  49      20.517   5.055  12.441  1.00  0.00           C  
ATOM    818  O   MET A  49      20.085   3.911  12.295  1.00  0.00           O  
ATOM    819  CB  MET A  49      19.806   6.702  10.698  1.00  0.00           C  
ATOM    820  CG  MET A  49      18.581   7.390  10.121  1.00  0.00           C  
ATOM    821  SD  MET A  49      18.644   7.532   8.324  1.00  0.00           S  
ATOM    822  CE  MET A  49      17.819   6.019   7.836  1.00  0.00           C  
ATOM    823  H   MET A  49      20.126   8.253  12.680  1.00  0.00           H  
ATOM    824  HA  MET A  49      18.603   5.989  12.317  1.00  0.00           H  
ATOM    825  HB2 MET A  49      20.639   7.386  10.636  1.00  0.00           H  
ATOM    826  HB3 MET A  49      20.020   5.832  10.095  1.00  0.00           H  
ATOM    827  HG2 MET A  49      17.703   6.822  10.391  1.00  0.00           H  
ATOM    828  HG3 MET A  49      18.510   8.382  10.544  1.00  0.00           H  
ATOM    829  HE1 MET A  49      17.576   5.442   8.716  1.00  0.00           H  
ATOM    830  HE2 MET A  49      16.911   6.261   7.303  1.00  0.00           H  
ATOM    831  HE3 MET A  49      18.471   5.445   7.196  1.00  0.00           H  
ATOM    832  N   SER A  50      21.754   5.314  12.851  1.00  0.00           N  
ATOM    833  CA  SER A  50      22.698   4.245  13.154  1.00  0.00           C  
ATOM    834  C   SER A  50      23.758   4.722  14.142  1.00  0.00           C  
ATOM    835  O   SER A  50      24.375   5.770  13.952  1.00  0.00           O  
ATOM    836  CB  SER A  50      23.369   3.748  11.872  1.00  0.00           C  
ATOM    837  OG  SER A  50      23.901   2.446  12.046  1.00  0.00           O  
ATOM    838  H   SER A  50      22.040   6.246  12.948  1.00  0.00           H  
ATOM    839  HA  SER A  50      22.147   3.432  13.601  1.00  0.00           H  
ATOM    840  HB2 SER A  50      22.640   3.722  11.075  1.00  0.00           H  
ATOM    841  HB3 SER A  50      24.171   4.420  11.605  1.00  0.00           H  
ATOM    842  HG  SER A  50      23.407   1.989  12.731  1.00  0.00           H  
ATOM    843  N   SER A  51      23.965   3.945  15.201  1.00  0.00           N  
ATOM    844  CA  SER A  51      24.946   4.287  16.223  1.00  0.00           C  
ATOM    845  C   SER A  51      26.302   4.593  15.592  1.00  0.00           C  
ATOM    846  O   SER A  51      26.849   5.682  15.769  1.00  0.00           O  
ATOM    847  CB  SER A  51      25.085   3.146  17.230  1.00  0.00           C  
ATOM    848  OG  SER A  51      25.719   2.022  16.644  1.00  0.00           O  
ATOM    849  H   SER A  51      23.440   3.121  15.297  1.00  0.00           H  
ATOM    850  HA  SER A  51      24.595   5.170  16.737  1.00  0.00           H  
ATOM    851  HB2 SER A  51      25.676   3.480  18.070  1.00  0.00           H  
ATOM    852  HB3 SER A  51      24.104   2.852  17.576  1.00  0.00           H  
ATOM    853  HG  SER A  51      25.137   1.633  15.987  1.00  0.00           H  
ATOM    854  N   CYS A  52      26.838   3.624  14.859  1.00  0.00           N  
ATOM    855  CA  CYS A  52      28.130   3.786  14.201  1.00  0.00           C  
ATOM    856  C   CYS A  52      28.098   4.955  13.223  1.00  0.00           C  
ATOM    857  O   CYS A  52      27.089   5.649  13.101  1.00  0.00           O  
ATOM    858  CB  CYS A  52      28.519   2.502  13.471  1.00  0.00           C  
ATOM    859  SG  CYS A  52      27.467   2.113  12.052  1.00  0.00           S  
ATOM    860  H   CYS A  52      26.353   2.778  14.755  1.00  0.00           H  
ATOM    861  HA  CYS A  52      28.865   3.993  14.966  1.00  0.00           H  
ATOM    862  HB2 CYS A  52      29.534   2.595  13.111  1.00  0.00           H  
ATOM    863  HB3 CYS A  52      28.463   1.673  14.160  1.00  0.00           H  
ATOM    864  HG  CYS A  52      28.214   2.182  10.959  1.00  0.00           H  
ATOM    865  N   ARG A  53      29.210   5.168  12.529  1.00  0.00           N  
ATOM    866  CA  ARG A  53      29.311   6.254  11.561  1.00  0.00           C  
ATOM    867  C   ARG A  53      28.309   6.067  10.427  1.00  0.00           C  
ATOM    868  O   ARG A  53      28.187   4.979   9.864  1.00  0.00           O  
ATOM    869  CB  ARG A  53      30.731   6.332  10.994  1.00  0.00           C  
ATOM    870  CG  ARG A  53      31.698   7.103  11.877  1.00  0.00           C  
ATOM    871  CD  ARG A  53      33.141   6.719  11.591  1.00  0.00           C  
ATOM    872  NE  ARG A  53      33.471   5.399  12.124  1.00  0.00           N  
ATOM    873  CZ  ARG A  53      34.716   4.968  12.296  1.00  0.00           C  
ATOM    874  NH1 ARG A  53      35.741   5.747  11.980  1.00  0.00           N  
ATOM    875  NH2 ARG A  53      34.936   3.756  12.787  1.00  0.00           N  
ATOM    876  H   ARG A  53      29.984   4.581  12.669  1.00  0.00           H  
ATOM    877  HA  ARG A  53      29.088   7.178  12.073  1.00  0.00           H  
ATOM    878  HB2 ARG A  53      31.112   5.329  10.872  1.00  0.00           H  
ATOM    879  HB3 ARG A  53      30.693   6.815  10.029  1.00  0.00           H  
ATOM    880  HG2 ARG A  53      31.575   8.160  11.692  1.00  0.00           H  
ATOM    881  HG3 ARG A  53      31.474   6.889  12.912  1.00  0.00           H  
ATOM    882  HD2 ARG A  53      33.293   6.712  10.522  1.00  0.00           H  
ATOM    883  HD3 ARG A  53      33.791   7.454  12.043  1.00  0.00           H  
ATOM    884  HE  ARG A  53      32.730   4.808  12.364  1.00  0.00           H  
ATOM    885 HH11 ARG A  53      35.578   6.662  11.611  1.00  0.00           H  
ATOM    886 HH12 ARG A  53      36.678   5.419  12.113  1.00  0.00           H  
ATOM    887 HH21 ARG A  53      34.166   3.166  13.027  1.00  0.00           H  
ATOM    888 HH22 ARG A  53      35.873   3.431  12.917  1.00  0.00           H  
ATOM    889  N   VAL A  54      27.592   7.136  10.094  1.00  0.00           N  
ATOM    890  CA  VAL A  54      26.600   7.090   9.027  1.00  0.00           C  
ATOM    891  C   VAL A  54      27.039   7.929   7.832  1.00  0.00           C  
ATOM    892  O   VAL A  54      27.104   9.155   7.912  1.00  0.00           O  
ATOM    893  CB  VAL A  54      25.228   7.589   9.513  1.00  0.00           C  
ATOM    894  CG1 VAL A  54      24.228   7.613   8.366  1.00  0.00           C  
ATOM    895  CG2 VAL A  54      24.719   6.722  10.656  1.00  0.00           C  
ATOM    896  H   VAL A  54      27.734   7.976  10.578  1.00  0.00           H  
ATOM    897  HA  VAL A  54      26.495   6.061   8.712  1.00  0.00           H  
ATOM    898  HB  VAL A  54      25.343   8.599   9.881  1.00  0.00           H  
ATOM    899 HG11 VAL A  54      24.191   8.607   7.943  1.00  0.00           H  
ATOM    900 HG12 VAL A  54      24.535   6.908   7.607  1.00  0.00           H  
ATOM    901 HG13 VAL A  54      23.250   7.341   8.736  1.00  0.00           H  
ATOM    902 HG21 VAL A  54      25.299   5.813  10.701  1.00  0.00           H  
ATOM    903 HG22 VAL A  54      24.819   7.258  11.589  1.00  0.00           H  
ATOM    904 HG23 VAL A  54      23.680   6.480  10.490  1.00  0.00           H  
ATOM    905  N   ASP A  55      27.339   7.260   6.724  1.00  0.00           N  
ATOM    906  CA  ASP A  55      27.772   7.943   5.511  1.00  0.00           C  
ATOM    907  C   ASP A  55      26.642   7.998   4.487  1.00  0.00           C  
ATOM    908  O   ASP A  55      26.439   9.015   3.823  1.00  0.00           O  
ATOM    909  CB  ASP A  55      28.989   7.239   4.909  1.00  0.00           C  
ATOM    910  CG  ASP A  55      30.081   6.997   5.931  1.00  0.00           C  
ATOM    911  OD1 ASP A  55      30.303   7.882   6.785  1.00  0.00           O  
ATOM    912  OD2 ASP A  55      30.714   5.922   5.880  1.00  0.00           O  
ATOM    913  H   ASP A  55      27.268   6.282   6.722  1.00  0.00           H  
ATOM    914  HA  ASP A  55      28.045   8.952   5.779  1.00  0.00           H  
ATOM    915  HB2 ASP A  55      28.682   6.285   4.505  1.00  0.00           H  
ATOM    916  HB3 ASP A  55      29.392   7.849   4.114  1.00  0.00           H  
ATOM    917  N   LYS A  56      25.909   6.896   4.363  1.00  0.00           N  
ATOM    918  CA  LYS A  56      24.800   6.818   3.420  1.00  0.00           C  
ATOM    919  C   LYS A  56      23.567   6.210   4.080  1.00  0.00           C  
ATOM    920  O   LYS A  56      23.345   4.997   4.040  1.00  0.00           O  
ATOM    921  CB  LYS A  56      25.200   5.987   2.198  1.00  0.00           C  
ATOM    922  CG  LYS A  56      25.863   6.800   1.100  1.00  0.00           C  
ATOM    923  CD  LYS A  56      26.357   5.911  -0.031  1.00  0.00           C  
ATOM    924  CE  LYS A  56      27.143   6.707  -1.061  1.00  0.00           C  
ATOM    925  NZ  LYS A  56      27.356   5.933  -2.316  1.00  0.00           N  
ATOM    926  H   LYS A  56      26.120   6.117   4.919  1.00  0.00           H  
ATOM    927  HA  LYS A  56      24.564   7.821   3.100  1.00  0.00           H  
ATOM    928  HB2 LYS A  56      25.888   5.215   2.512  1.00  0.00           H  
ATOM    929  HB3 LYS A  56      24.314   5.523   1.788  1.00  0.00           H  
ATOM    930  HG2 LYS A  56      25.148   7.504   0.704  1.00  0.00           H  
ATOM    931  HG3 LYS A  56      26.705   7.333   1.520  1.00  0.00           H  
ATOM    932  HD2 LYS A  56      26.997   5.144   0.379  1.00  0.00           H  
ATOM    933  HD3 LYS A  56      25.507   5.454  -0.514  1.00  0.00           H  
ATOM    934  HE2 LYS A  56      26.598   7.609  -1.293  1.00  0.00           H  
ATOM    935  HE3 LYS A  56      28.104   6.966  -0.640  1.00  0.00           H  
ATOM    936  HZ1 LYS A  56      27.305   4.913  -2.118  1.00  0.00           H  
ATOM    937  HZ2 LYS A  56      28.291   6.150  -2.714  1.00  0.00           H  
ATOM    938  HZ3 LYS A  56      26.627   6.177  -3.013  1.00  0.00           H  
ATOM    939  N   PRO A  57      22.741   7.066   4.700  1.00  0.00           N  
ATOM    940  CA  PRO A  57      21.517   6.635   5.378  1.00  0.00           C  
ATOM    941  C   PRO A  57      20.448   6.164   4.400  1.00  0.00           C  
ATOM    942  O   PRO A  57      19.502   5.475   4.783  1.00  0.00           O  
ATOM    943  CB  PRO A  57      21.054   7.898   6.109  1.00  0.00           C  
ATOM    944  CG  PRO A  57      21.632   9.024   5.324  1.00  0.00           C  
ATOM    945  CD  PRO A  57      22.944   8.523   4.786  1.00  0.00           C  
ATOM    946  HA  PRO A  57      21.715   5.855   6.097  1.00  0.00           H  
ATOM    947  HB2 PRO A  57      19.973   7.936   6.118  1.00  0.00           H  
ATOM    948  HB3 PRO A  57      21.428   7.890   7.123  1.00  0.00           H  
ATOM    949  HG2 PRO A  57      20.970   9.285   4.513  1.00  0.00           H  
ATOM    950  HG3 PRO A  57      21.793   9.876   5.969  1.00  0.00           H  
ATOM    951  HD2 PRO A  57      23.137   8.944   3.811  1.00  0.00           H  
ATOM    952  HD3 PRO A  57      23.747   8.760   5.468  1.00  0.00           H  
ATOM    953  N   SER A  58      20.603   6.538   3.134  1.00  0.00           N  
ATOM    954  CA  SER A  58      19.648   6.156   2.101  1.00  0.00           C  
ATOM    955  C   SER A  58      19.831   4.694   1.705  1.00  0.00           C  
ATOM    956  O   SER A  58      19.061   4.153   0.914  1.00  0.00           O  
ATOM    957  CB  SER A  58      19.810   7.052   0.870  1.00  0.00           C  
ATOM    958  OG  SER A  58      21.017   6.766   0.185  1.00  0.00           O  
ATOM    959  H   SER A  58      21.377   7.088   2.891  1.00  0.00           H  
ATOM    960  HA  SER A  58      18.655   6.286   2.503  1.00  0.00           H  
ATOM    961  HB2 SER A  58      18.981   6.890   0.199  1.00  0.00           H  
ATOM    962  HB3 SER A  58      19.823   8.087   1.183  1.00  0.00           H  
ATOM    963  HG  SER A  58      21.063   7.293  -0.616  1.00  0.00           H  
ATOM    964  N   GLU A  59      20.858   4.061   2.265  1.00  0.00           N  
ATOM    965  CA  GLU A  59      21.144   2.662   1.970  1.00  0.00           C  
ATOM    966  C   GLU A  59      20.854   1.780   3.182  1.00  0.00           C  
ATOM    967  O   GLU A  59      20.743   0.560   3.063  1.00  0.00           O  
ATOM    968  CB  GLU A  59      22.604   2.495   1.542  1.00  0.00           C  
ATOM    969  CG  GLU A  59      22.876   2.948   0.117  1.00  0.00           C  
ATOM    970  CD  GLU A  59      22.283   2.010  -0.916  1.00  0.00           C  
ATOM    971  OE1 GLU A  59      22.604   0.803  -0.875  1.00  0.00           O  
ATOM    972  OE2 GLU A  59      21.500   2.482  -1.766  1.00  0.00           O  
ATOM    973  H   GLU A  59      21.438   4.546   2.888  1.00  0.00           H  
ATOM    974  HA  GLU A  59      20.504   2.356   1.157  1.00  0.00           H  
ATOM    975  HB2 GLU A  59      23.230   3.072   2.208  1.00  0.00           H  
ATOM    976  HB3 GLU A  59      22.872   1.452   1.624  1.00  0.00           H  
ATOM    977  HG2 GLU A  59      22.449   3.929  -0.023  1.00  0.00           H  
ATOM    978  HG3 GLU A  59      23.945   2.996  -0.034  1.00  0.00           H  
ATOM    979  N   ILE A  60      20.736   2.409   4.347  1.00  0.00           N  
ATOM    980  CA  ILE A  60      20.458   1.683   5.580  1.00  0.00           C  
ATOM    981  C   ILE A  60      19.010   1.206   5.624  1.00  0.00           C  
ATOM    982  O   ILE A  60      18.727   0.082   6.038  1.00  0.00           O  
ATOM    983  CB  ILE A  60      20.739   2.551   6.820  1.00  0.00           C  
ATOM    984  CG1 ILE A  60      22.170   3.092   6.778  1.00  0.00           C  
ATOM    985  CG2 ILE A  60      20.507   1.750   8.092  1.00  0.00           C  
ATOM    986  CD1 ILE A  60      22.514   3.984   7.950  1.00  0.00           C  
ATOM    987  H   ILE A  60      20.835   3.382   4.377  1.00  0.00           H  
ATOM    988  HA  ILE A  60      21.110   0.821   5.614  1.00  0.00           H  
ATOM    989  HB  ILE A  60      20.048   3.380   6.815  1.00  0.00           H  
ATOM    990 HG12 ILE A  60      22.862   2.263   6.779  1.00  0.00           H  
ATOM    991 HG13 ILE A  60      22.304   3.664   5.873  1.00  0.00           H  
ATOM    992 HG21 ILE A  60      19.718   1.031   7.926  1.00  0.00           H  
ATOM    993 HG22 ILE A  60      21.415   1.232   8.362  1.00  0.00           H  
ATOM    994 HG23 ILE A  60      20.222   2.417   8.891  1.00  0.00           H  
ATOM    995 HD11 ILE A  60      23.389   3.599   8.452  1.00  0.00           H  
ATOM    996 HD12 ILE A  60      22.713   4.984   7.596  1.00  0.00           H  
ATOM    997 HD13 ILE A  60      21.684   4.006   8.641  1.00  0.00           H  
ATOM    998  N   VAL A  61      18.096   2.070   5.194  1.00  0.00           N  
ATOM    999  CA  VAL A  61      16.676   1.737   5.181  1.00  0.00           C  
ATOM   1000  C   VAL A  61      16.035   2.116   3.850  1.00  0.00           C  
ATOM   1001  O   VAL A  61      16.650   2.788   3.023  1.00  0.00           O  
ATOM   1002  CB  VAL A  61      15.923   2.446   6.322  1.00  0.00           C  
ATOM   1003  CG1 VAL A  61      16.577   2.145   7.661  1.00  0.00           C  
ATOM   1004  CG2 VAL A  61      15.869   3.946   6.071  1.00  0.00           C  
ATOM   1005  H   VAL A  61      18.383   2.952   4.876  1.00  0.00           H  
ATOM   1006  HA  VAL A  61      16.583   0.670   5.323  1.00  0.00           H  
ATOM   1007  HB  VAL A  61      14.911   2.069   6.346  1.00  0.00           H  
ATOM   1008 HG11 VAL A  61      16.127   2.760   8.427  1.00  0.00           H  
ATOM   1009 HG12 VAL A  61      16.433   1.103   7.906  1.00  0.00           H  
ATOM   1010 HG13 VAL A  61      17.634   2.360   7.603  1.00  0.00           H  
ATOM   1011 HG21 VAL A  61      15.100   4.161   5.344  1.00  0.00           H  
ATOM   1012 HG22 VAL A  61      15.642   4.457   6.996  1.00  0.00           H  
ATOM   1013 HG23 VAL A  61      16.823   4.284   5.698  1.00  0.00           H  
ATOM   1014  N   ASP A  62      14.796   1.680   3.652  1.00  0.00           N  
ATOM   1015  CA  ASP A  62      14.069   1.974   2.422  1.00  0.00           C  
ATOM   1016  C   ASP A  62      12.564   1.858   2.639  1.00  0.00           C  
ATOM   1017  O   ASP A  62      12.091   0.931   3.297  1.00  0.00           O  
ATOM   1018  CB  ASP A  62      14.512   1.027   1.305  1.00  0.00           C  
ATOM   1019  CG  ASP A  62      16.000   0.745   1.339  1.00  0.00           C  
ATOM   1020  OD1 ASP A  62      16.436  -0.032   2.215  1.00  0.00           O  
ATOM   1021  OD2 ASP A  62      16.729   1.300   0.491  1.00  0.00           O  
ATOM   1022  H   ASP A  62      14.359   1.148   4.350  1.00  0.00           H  
ATOM   1023  HA  ASP A  62      14.301   2.989   2.136  1.00  0.00           H  
ATOM   1024  HB2 ASP A  62      13.984   0.092   1.407  1.00  0.00           H  
ATOM   1025  HB3 ASP A  62      14.269   1.472   0.350  1.00  0.00           H  
ATOM   1026  N   VAL A  63      11.816   2.804   2.083  1.00  0.00           N  
ATOM   1027  CA  VAL A  63      10.364   2.808   2.215  1.00  0.00           C  
ATOM   1028  C   VAL A  63       9.800   1.395   2.130  1.00  0.00           C  
ATOM   1029  O   VAL A  63      10.062   0.668   1.173  1.00  0.00           O  
ATOM   1030  CB  VAL A  63       9.703   3.678   1.129  1.00  0.00           C  
ATOM   1031  CG1 VAL A  63       8.188   3.627   1.252  1.00  0.00           C  
ATOM   1032  CG2 VAL A  63      10.205   5.112   1.217  1.00  0.00           C  
ATOM   1033  H   VAL A  63      12.251   3.517   1.569  1.00  0.00           H  
ATOM   1034  HA  VAL A  63      10.118   3.227   3.180  1.00  0.00           H  
ATOM   1035  HB  VAL A  63       9.978   3.282   0.163  1.00  0.00           H  
ATOM   1036 HG11 VAL A  63       7.742   3.859   0.296  1.00  0.00           H  
ATOM   1037 HG12 VAL A  63       7.885   2.639   1.561  1.00  0.00           H  
ATOM   1038 HG13 VAL A  63       7.862   4.351   1.985  1.00  0.00           H  
ATOM   1039 HG21 VAL A  63      10.174   5.440   2.245  1.00  0.00           H  
ATOM   1040 HG22 VAL A  63      11.222   5.161   0.855  1.00  0.00           H  
ATOM   1041 HG23 VAL A  63       9.578   5.752   0.615  1.00  0.00           H  
ATOM   1042  N   GLY A  64       9.024   1.011   3.139  1.00  0.00           N  
ATOM   1043  CA  GLY A  64       8.436  -0.316   3.159  1.00  0.00           C  
ATOM   1044  C   GLY A  64       9.021  -1.193   4.247  1.00  0.00           C  
ATOM   1045  O   GLY A  64       8.432  -2.209   4.618  1.00  0.00           O  
ATOM   1046  H   GLY A  64       8.851   1.633   3.876  1.00  0.00           H  
ATOM   1047  HA2 GLY A  64       7.371  -0.223   3.319  1.00  0.00           H  
ATOM   1048  HA3 GLY A  64       8.605  -0.786   2.202  1.00  0.00           H  
ATOM   1049  N   ASP A  65      10.183  -0.803   4.759  1.00  0.00           N  
ATOM   1050  CA  ASP A  65      10.849  -1.562   5.810  1.00  0.00           C  
ATOM   1051  C   ASP A  65      10.349  -1.139   7.188  1.00  0.00           C  
ATOM   1052  O   ASP A  65      10.193   0.050   7.465  1.00  0.00           O  
ATOM   1053  CB  ASP A  65      12.365  -1.372   5.725  1.00  0.00           C  
ATOM   1054  CG  ASP A  65      12.962  -2.030   4.497  1.00  0.00           C  
ATOM   1055  OD1 ASP A  65      12.328  -2.959   3.954  1.00  0.00           O  
ATOM   1056  OD2 ASP A  65      14.065  -1.618   4.081  1.00  0.00           O  
ATOM   1057  H   ASP A  65      10.603   0.016   4.422  1.00  0.00           H  
ATOM   1058  HA  ASP A  65      10.618  -2.607   5.662  1.00  0.00           H  
ATOM   1059  HB2 ASP A  65      12.586  -0.315   5.687  1.00  0.00           H  
ATOM   1060  HB3 ASP A  65      12.825  -1.801   6.604  1.00  0.00           H  
ATOM   1061  N   LYS A  66      10.094  -2.119   8.047  1.00  0.00           N  
ATOM   1062  CA  LYS A  66       9.610  -1.850   9.395  1.00  0.00           C  
ATOM   1063  C   LYS A  66      10.730  -2.010  10.418  1.00  0.00           C  
ATOM   1064  O   LYS A  66      11.456  -3.004  10.407  1.00  0.00           O  
ATOM   1065  CB  LYS A  66       8.451  -2.789   9.741  1.00  0.00           C  
ATOM   1066  CG  LYS A  66       8.023  -2.717  11.196  1.00  0.00           C  
ATOM   1067  CD  LYS A  66       7.004  -3.793  11.531  1.00  0.00           C  
ATOM   1068  CE  LYS A  66       5.662  -3.516  10.872  1.00  0.00           C  
ATOM   1069  NZ  LYS A  66       4.817  -2.608  11.696  1.00  0.00           N  
ATOM   1070  H   LYS A  66      10.236  -3.049   7.767  1.00  0.00           H  
ATOM   1071  HA  LYS A  66       9.255  -0.831   9.423  1.00  0.00           H  
ATOM   1072  HB2 LYS A  66       7.602  -2.536   9.123  1.00  0.00           H  
ATOM   1073  HB3 LYS A  66       8.751  -3.806   9.526  1.00  0.00           H  
ATOM   1074  HG2 LYS A  66       8.891  -2.850  11.824  1.00  0.00           H  
ATOM   1075  HG3 LYS A  66       7.585  -1.747  11.384  1.00  0.00           H  
ATOM   1076  HD2 LYS A  66       7.373  -4.747  11.184  1.00  0.00           H  
ATOM   1077  HD3 LYS A  66       6.869  -3.826  12.604  1.00  0.00           H  
ATOM   1078  HE2 LYS A  66       5.835  -3.057   9.911  1.00  0.00           H  
ATOM   1079  HE3 LYS A  66       5.143  -4.453  10.735  1.00  0.00           H  
ATOM   1080  HZ1 LYS A  66       4.124  -3.162  12.240  1.00  0.00           H  
ATOM   1081  HZ2 LYS A  66       4.306  -1.942  11.084  1.00  0.00           H  
ATOM   1082  HZ3 LYS A  66       5.410  -2.069  12.359  1.00  0.00           H  
ATOM   1083  N   VAL A  67      10.864  -1.026  11.301  1.00  0.00           N  
ATOM   1084  CA  VAL A  67      11.896  -1.059  12.333  1.00  0.00           C  
ATOM   1085  C   VAL A  67      11.367  -0.512  13.653  1.00  0.00           C  
ATOM   1086  O   VAL A  67      10.276   0.054  13.711  1.00  0.00           O  
ATOM   1087  CB  VAL A  67      13.135  -0.250  11.911  1.00  0.00           C  
ATOM   1088  CG1 VAL A  67      13.814  -0.896  10.714  1.00  0.00           C  
ATOM   1089  CG2 VAL A  67      12.753   1.190  11.605  1.00  0.00           C  
ATOM   1090  H   VAL A  67      10.255  -0.260  11.258  1.00  0.00           H  
ATOM   1091  HA  VAL A  67      12.194  -2.089  12.474  1.00  0.00           H  
ATOM   1092  HB  VAL A  67      13.834  -0.247  12.734  1.00  0.00           H  
ATOM   1093 HG11 VAL A  67      13.148  -0.865   9.864  1.00  0.00           H  
ATOM   1094 HG12 VAL A  67      14.722  -0.360  10.481  1.00  0.00           H  
ATOM   1095 HG13 VAL A  67      14.052  -1.924  10.946  1.00  0.00           H  
ATOM   1096 HG21 VAL A  67      12.665   1.319  10.536  1.00  0.00           H  
ATOM   1097 HG22 VAL A  67      11.806   1.419  12.074  1.00  0.00           H  
ATOM   1098 HG23 VAL A  67      13.514   1.855  11.986  1.00  0.00           H  
ATOM   1099  N   TRP A  68      12.150  -0.682  14.712  1.00  0.00           N  
ATOM   1100  CA  TRP A  68      11.763  -0.205  16.035  1.00  0.00           C  
ATOM   1101  C   TRP A  68      12.424   1.134  16.344  1.00  0.00           C  
ATOM   1102  O   TRP A  68      13.629   1.302  16.153  1.00  0.00           O  
ATOM   1103  CB  TRP A  68      12.139  -1.233  17.102  1.00  0.00           C  
ATOM   1104  CG  TRP A  68      11.313  -2.482  17.041  1.00  0.00           C  
ATOM   1105  CD1 TRP A  68      11.653  -3.661  16.443  1.00  0.00           C  
ATOM   1106  CD2 TRP A  68      10.009  -2.674  17.599  1.00  0.00           C  
ATOM   1107  NE1 TRP A  68      10.639  -4.574  16.594  1.00  0.00           N  
ATOM   1108  CE2 TRP A  68       9.619  -3.994  17.301  1.00  0.00           C  
ATOM   1109  CE3 TRP A  68       9.133  -1.861  18.324  1.00  0.00           C  
ATOM   1110  CZ2 TRP A  68       8.392  -4.517  17.702  1.00  0.00           C  
ATOM   1111  CZ3 TRP A  68       7.916  -2.381  18.721  1.00  0.00           C  
ATOM   1112  CH2 TRP A  68       7.555  -3.698  18.410  1.00  0.00           C  
ATOM   1113  H   TRP A  68      13.010  -1.140  14.602  1.00  0.00           H  
ATOM   1114  HA  TRP A  68      10.691  -0.072  16.037  1.00  0.00           H  
ATOM   1115  HB2 TRP A  68      13.175  -1.512  16.976  1.00  0.00           H  
ATOM   1116  HB3 TRP A  68      12.007  -0.791  18.079  1.00  0.00           H  
ATOM   1117  HD1 TRP A  68      12.585  -3.834  15.926  1.00  0.00           H  
ATOM   1118  HE1 TRP A  68      10.645  -5.494  16.252  1.00  0.00           H  
ATOM   1119  HE3 TRP A  68       9.395  -0.843  18.575  1.00  0.00           H  
ATOM   1120  HZ2 TRP A  68       8.099  -5.529  17.471  1.00  0.00           H  
ATOM   1121  HZ3 TRP A  68       7.227  -1.766  19.281  1.00  0.00           H  
ATOM   1122  HH2 TRP A  68       6.593  -4.062  18.739  1.00  0.00           H  
ATOM   1123  N   VAL A  69      11.629   2.085  16.825  1.00  0.00           N  
ATOM   1124  CA  VAL A  69      12.137   3.409  17.163  1.00  0.00           C  
ATOM   1125  C   VAL A  69      11.651   3.849  18.539  1.00  0.00           C  
ATOM   1126  O   VAL A  69      10.645   3.351  19.044  1.00  0.00           O  
ATOM   1127  CB  VAL A  69      11.710   4.457  16.120  1.00  0.00           C  
ATOM   1128  CG1 VAL A  69      12.236   4.087  14.742  1.00  0.00           C  
ATOM   1129  CG2 VAL A  69      10.196   4.602  16.100  1.00  0.00           C  
ATOM   1130  H   VAL A  69      10.677   1.892  16.956  1.00  0.00           H  
ATOM   1131  HA  VAL A  69      13.216   3.360  17.172  1.00  0.00           H  
ATOM   1132  HB  VAL A  69      12.137   5.410  16.399  1.00  0.00           H  
ATOM   1133 HG11 VAL A  69      11.482   4.303  13.999  1.00  0.00           H  
ATOM   1134 HG12 VAL A  69      13.128   4.658  14.530  1.00  0.00           H  
ATOM   1135 HG13 VAL A  69      12.471   3.032  14.719  1.00  0.00           H  
ATOM   1136 HG21 VAL A  69       9.821   4.317  15.129  1.00  0.00           H  
ATOM   1137 HG22 VAL A  69       9.762   3.963  16.856  1.00  0.00           H  
ATOM   1138 HG23 VAL A  69       9.929   5.629  16.302  1.00  0.00           H  
ATOM   1139  N   LYS A  70      12.373   4.788  19.142  1.00  0.00           N  
ATOM   1140  CA  LYS A  70      12.015   5.299  20.461  1.00  0.00           C  
ATOM   1141  C   LYS A  70      11.977   6.823  20.460  1.00  0.00           C  
ATOM   1142  O   LYS A  70      12.932   7.479  20.040  1.00  0.00           O  
ATOM   1143  CB  LYS A  70      13.012   4.803  21.510  1.00  0.00           C  
ATOM   1144  CG  LYS A  70      12.840   5.457  22.870  1.00  0.00           C  
ATOM   1145  CD  LYS A  70      14.142   5.471  23.652  1.00  0.00           C  
ATOM   1146  CE  LYS A  70      15.023   6.642  23.246  1.00  0.00           C  
ATOM   1147  NZ  LYS A  70      14.754   7.852  24.069  1.00  0.00           N  
ATOM   1148  H   LYS A  70      13.165   5.147  18.690  1.00  0.00           H  
ATOM   1149  HA  LYS A  70      11.032   4.926  20.707  1.00  0.00           H  
ATOM   1150  HB2 LYS A  70      12.893   3.737  21.628  1.00  0.00           H  
ATOM   1151  HB3 LYS A  70      14.016   5.007  21.162  1.00  0.00           H  
ATOM   1152  HG2 LYS A  70      12.505   6.474  22.732  1.00  0.00           H  
ATOM   1153  HG3 LYS A  70      12.098   4.906  23.433  1.00  0.00           H  
ATOM   1154  HD2 LYS A  70      13.920   5.552  24.706  1.00  0.00           H  
ATOM   1155  HD3 LYS A  70      14.674   4.548  23.465  1.00  0.00           H  
ATOM   1156  HE2 LYS A  70      16.057   6.357  23.368  1.00  0.00           H  
ATOM   1157  HE3 LYS A  70      14.834   6.874  22.208  1.00  0.00           H  
ATOM   1158  HZ1 LYS A  70      14.009   7.650  24.768  1.00  0.00           H  
ATOM   1159  HZ2 LYS A  70      14.440   8.636  23.461  1.00  0.00           H  
ATOM   1160  HZ3 LYS A  70      15.616   8.142  24.572  1.00  0.00           H  
ATOM   1161  N   LEU A  71      10.870   7.384  20.936  1.00  0.00           N  
ATOM   1162  CA  LEU A  71      10.708   8.831  20.993  1.00  0.00           C  
ATOM   1163  C   LEU A  71      11.764   9.463  21.893  1.00  0.00           C  
ATOM   1164  O   LEU A  71      11.937   9.057  23.043  1.00  0.00           O  
ATOM   1165  CB  LEU A  71       9.310   9.189  21.500  1.00  0.00           C  
ATOM   1166  CG  LEU A  71       8.887  10.649  21.334  1.00  0.00           C  
ATOM   1167  CD1 LEU A  71       8.423  10.912  19.910  1.00  0.00           C  
ATOM   1168  CD2 LEU A  71       7.791  11.004  22.329  1.00  0.00           C  
ATOM   1169  H   LEU A  71      10.142   6.809  21.257  1.00  0.00           H  
ATOM   1170  HA  LEU A  71      10.827   9.218  19.991  1.00  0.00           H  
ATOM   1171  HB2 LEU A  71       8.598   8.577  20.968  1.00  0.00           H  
ATOM   1172  HB3 LEU A  71       9.271   8.950  22.554  1.00  0.00           H  
ATOM   1173  HG  LEU A  71       9.738  11.287  21.530  1.00  0.00           H  
ATOM   1174 HD11 LEU A  71       8.825  11.853  19.567  1.00  0.00           H  
ATOM   1175 HD12 LEU A  71       7.344  10.951  19.885  1.00  0.00           H  
ATOM   1176 HD13 LEU A  71       8.768  10.116  19.266  1.00  0.00           H  
ATOM   1177 HD21 LEU A  71       6.951  11.431  21.800  1.00  0.00           H  
ATOM   1178 HD22 LEU A  71       8.172  11.723  23.042  1.00  0.00           H  
ATOM   1179 HD23 LEU A  71       7.476  10.113  22.849  1.00  0.00           H  
ATOM   1180  N   ILE A  72      12.466  10.459  21.363  1.00  0.00           N  
ATOM   1181  CA  ILE A  72      13.503  11.148  22.120  1.00  0.00           C  
ATOM   1182  C   ILE A  72      13.079  12.573  22.464  1.00  0.00           C  
ATOM   1183  O   ILE A  72      13.549  13.152  23.442  1.00  0.00           O  
ATOM   1184  CB  ILE A  72      14.832  11.195  21.342  1.00  0.00           C  
ATOM   1185  CG1 ILE A  72      14.711  12.132  20.140  1.00  0.00           C  
ATOM   1186  CG2 ILE A  72      15.232   9.797  20.893  1.00  0.00           C  
ATOM   1187  CD1 ILE A  72      15.913  12.095  19.221  1.00  0.00           C  
ATOM   1188  H   ILE A  72      12.282  10.738  20.443  1.00  0.00           H  
ATOM   1189  HA  ILE A  72      13.666  10.602  23.038  1.00  0.00           H  
ATOM   1190  HB  ILE A  72      15.598  11.567  22.005  1.00  0.00           H  
ATOM   1191 HG12 ILE A  72      13.844  11.858  19.561  1.00  0.00           H  
ATOM   1192 HG13 ILE A  72      14.596  13.147  20.495  1.00  0.00           H  
ATOM   1193 HG21 ILE A  72      14.822   9.068  21.578  1.00  0.00           H  
ATOM   1194 HG22 ILE A  72      14.845   9.615  19.902  1.00  0.00           H  
ATOM   1195 HG23 ILE A  72      16.308   9.716  20.882  1.00  0.00           H  
ATOM   1196 HD11 ILE A  72      15.709  11.439  18.389  1.00  0.00           H  
ATOM   1197 HD12 ILE A  72      16.120  13.090  18.856  1.00  0.00           H  
ATOM   1198 HD13 ILE A  72      16.771  11.728  19.767  1.00  0.00           H  
ATOM   1199  N   GLY A  73      12.185  13.130  21.652  1.00  0.00           N  
ATOM   1200  CA  GLY A  73      11.711  14.481  21.888  1.00  0.00           C  
ATOM   1201  C   GLY A  73      10.463  14.805  21.090  1.00  0.00           C  
ATOM   1202  O   GLY A  73      10.481  14.774  19.860  1.00  0.00           O  
ATOM   1203  H   GLY A  73      11.845  12.620  20.887  1.00  0.00           H  
ATOM   1204  HA2 GLY A  73      11.493  14.596  22.939  1.00  0.00           H  
ATOM   1205  HA3 GLY A  73      12.490  15.176  21.614  1.00  0.00           H  
ATOM   1206  N   ARG A  74       9.378  15.113  21.791  1.00  0.00           N  
ATOM   1207  CA  ARG A  74       8.115  15.441  21.140  1.00  0.00           C  
ATOM   1208  C   ARG A  74       7.654  16.846  21.520  1.00  0.00           C  
ATOM   1209  O   ARG A  74       7.527  17.168  22.702  1.00  0.00           O  
ATOM   1210  CB  ARG A  74       7.041  14.421  21.520  1.00  0.00           C  
ATOM   1211  CG  ARG A  74       6.881  14.235  23.020  1.00  0.00           C  
ATOM   1212  CD  ARG A  74       5.599  13.490  23.355  1.00  0.00           C  
ATOM   1213  NE  ARG A  74       4.413  14.210  22.903  1.00  0.00           N  
ATOM   1214  CZ  ARG A  74       3.177  13.737  23.020  1.00  0.00           C  
ATOM   1215  NH1 ARG A  74       2.966  12.551  23.573  1.00  0.00           N  
ATOM   1216  NH2 ARG A  74       2.147  14.453  22.583  1.00  0.00           N  
ATOM   1217  H   ARG A  74       9.427  15.122  22.769  1.00  0.00           H  
ATOM   1218  HA  ARG A  74       8.272  15.405  20.072  1.00  0.00           H  
ATOM   1219  HB2 ARG A  74       6.093  14.746  21.118  1.00  0.00           H  
ATOM   1220  HB3 ARG A  74       7.299  13.466  21.087  1.00  0.00           H  
ATOM   1221  HG2 ARG A  74       7.721  13.670  23.396  1.00  0.00           H  
ATOM   1222  HG3 ARG A  74       6.857  15.206  23.493  1.00  0.00           H  
ATOM   1223  HD2 ARG A  74       5.625  12.522  22.877  1.00  0.00           H  
ATOM   1224  HD3 ARG A  74       5.543  13.360  24.427  1.00  0.00           H  
ATOM   1225  HE  ARG A  74       4.545  15.090  22.491  1.00  0.00           H  
ATOM   1226 HH11 ARG A  74       3.740  12.011  23.903  1.00  0.00           H  
ATOM   1227 HH12 ARG A  74       2.033  12.198  23.661  1.00  0.00           H  
ATOM   1228 HH21 ARG A  74       2.300  15.348  22.167  1.00  0.00           H  
ATOM   1229 HH22 ARG A  74       1.217  14.096  22.672  1.00  0.00           H  
ATOM   1230  N   GLU A  75       7.409  17.676  20.513  1.00  0.00           N  
ATOM   1231  CA  GLU A  75       6.965  19.045  20.742  1.00  0.00           C  
ATOM   1232  C   GLU A  75       5.749  19.375  19.880  1.00  0.00           C  
ATOM   1233  O   GLU A  75       5.788  19.244  18.658  1.00  0.00           O  
ATOM   1234  CB  GLU A  75       8.098  20.030  20.442  1.00  0.00           C  
ATOM   1235  CG  GLU A  75       9.009  20.289  21.630  1.00  0.00           C  
ATOM   1236  CD  GLU A  75      10.300  20.981  21.235  1.00  0.00           C  
ATOM   1237  OE1 GLU A  75      11.280  20.273  20.925  1.00  0.00           O  
ATOM   1238  OE2 GLU A  75      10.329  22.230  21.237  1.00  0.00           O  
ATOM   1239  H   GLU A  75       7.530  17.360  19.592  1.00  0.00           H  
ATOM   1240  HA  GLU A  75       6.689  19.134  21.782  1.00  0.00           H  
ATOM   1241  HB2 GLU A  75       8.697  19.636  19.634  1.00  0.00           H  
ATOM   1242  HB3 GLU A  75       7.668  20.971  20.132  1.00  0.00           H  
ATOM   1243  HG2 GLU A  75       8.486  20.914  22.339  1.00  0.00           H  
ATOM   1244  HG3 GLU A  75       9.251  19.345  22.094  1.00  0.00           H  
ATOM   1245  N   MET A  76       4.671  19.803  20.529  1.00  0.00           N  
ATOM   1246  CA  MET A  76       3.444  20.153  19.823  1.00  0.00           C  
ATOM   1247  C   MET A  76       3.114  21.631  20.004  1.00  0.00           C  
ATOM   1248  O   MET A  76       2.815  22.081  21.111  1.00  0.00           O  
ATOM   1249  CB  MET A  76       2.281  19.294  20.322  1.00  0.00           C  
ATOM   1250  CG  MET A  76       0.915  19.832  19.929  1.00  0.00           C  
ATOM   1251  SD  MET A  76       0.239  20.977  21.147  1.00  0.00           S  
ATOM   1252  CE  MET A  76      -1.130  21.678  20.231  1.00  0.00           C  
ATOM   1253  H   MET A  76       4.701  19.888  21.505  1.00  0.00           H  
ATOM   1254  HA  MET A  76       3.599  19.957  18.773  1.00  0.00           H  
ATOM   1255  HB2 MET A  76       2.383  18.299  19.917  1.00  0.00           H  
ATOM   1256  HB3 MET A  76       2.324  19.241  21.400  1.00  0.00           H  
ATOM   1257  HG2 MET A  76       1.004  20.346  18.983  1.00  0.00           H  
ATOM   1258  HG3 MET A  76       0.234  19.001  19.820  1.00  0.00           H  
ATOM   1259  HE1 MET A  76      -1.215  21.182  19.276  1.00  0.00           H  
ATOM   1260  HE2 MET A  76      -2.045  21.541  20.790  1.00  0.00           H  
ATOM   1261  HE3 MET A  76      -0.956  22.732  20.075  1.00  0.00           H  
ATOM   1262  N   LYS A  77       3.172  22.384  18.910  1.00  0.00           N  
ATOM   1263  CA  LYS A  77       2.877  23.811  18.947  1.00  0.00           C  
ATOM   1264  C   LYS A  77       1.673  24.142  18.074  1.00  0.00           C  
ATOM   1265  O   LYS A  77       1.456  23.518  17.036  1.00  0.00           O  
ATOM   1266  CB  LYS A  77       4.094  24.615  18.483  1.00  0.00           C  
ATOM   1267  CG  LYS A  77       4.072  26.067  18.931  1.00  0.00           C  
ATOM   1268  CD  LYS A  77       4.439  26.202  20.399  1.00  0.00           C  
ATOM   1269  CE  LYS A  77       5.946  26.143  20.605  1.00  0.00           C  
ATOM   1270  NZ  LYS A  77       6.350  26.723  21.915  1.00  0.00           N  
ATOM   1271  H   LYS A  77       3.416  21.968  18.057  1.00  0.00           H  
ATOM   1272  HA  LYS A  77       2.650  24.078  19.969  1.00  0.00           H  
ATOM   1273  HB2 LYS A  77       4.988  24.153  18.875  1.00  0.00           H  
ATOM   1274  HB3 LYS A  77       4.133  24.596  17.402  1.00  0.00           H  
ATOM   1275  HG2 LYS A  77       4.781  26.627  18.340  1.00  0.00           H  
ATOM   1276  HG3 LYS A  77       3.079  26.465  18.780  1.00  0.00           H  
ATOM   1277  HD2 LYS A  77       4.075  27.149  20.768  1.00  0.00           H  
ATOM   1278  HD3 LYS A  77       3.978  25.395  20.952  1.00  0.00           H  
ATOM   1279  HE2 LYS A  77       6.263  25.113  20.564  1.00  0.00           H  
ATOM   1280  HE3 LYS A  77       6.425  26.698  19.812  1.00  0.00           H  
ATOM   1281  HZ1 LYS A  77       5.576  27.299  22.305  1.00  0.00           H  
ATOM   1282  HZ2 LYS A  77       7.188  27.328  21.796  1.00  0.00           H  
ATOM   1283  HZ3 LYS A  77       6.576  25.964  22.588  1.00  0.00           H  
ATOM   1284  N   ASN A  78       0.891  25.129  18.501  1.00  0.00           N  
ATOM   1285  CA  ASN A  78      -0.293  25.544  17.755  1.00  0.00           C  
ATOM   1286  C   ASN A  78       0.083  26.006  16.350  1.00  0.00           C  
ATOM   1287  O   ASN A  78      -0.779  26.154  15.484  1.00  0.00           O  
ATOM   1288  CB  ASN A  78      -1.021  26.665  18.497  1.00  0.00           C  
ATOM   1289  CG  ASN A  78      -1.106  26.413  19.989  1.00  0.00           C  
ATOM   1290  OD1 ASN A  78      -1.193  25.268  20.433  1.00  0.00           O  
ATOM   1291  ND2 ASN A  78      -1.081  27.484  20.774  1.00  0.00           N  
ATOM   1292  H   ASN A  78       1.113  25.589  19.336  1.00  0.00           H  
ATOM   1293  HA  ASN A  78      -0.949  24.691  17.677  1.00  0.00           H  
ATOM   1294  HB2 ASN A  78      -0.493  27.595  18.338  1.00  0.00           H  
ATOM   1295  HB3 ASN A  78      -2.024  26.755  18.108  1.00  0.00           H  
ATOM   1296 HD21 ASN A  78      -1.009  28.366  20.351  1.00  0.00           H  
ATOM   1297 HD22 ASN A  78      -1.133  27.349  21.743  1.00  0.00           H  
ATOM   1298  N   ASP A  79       1.373  26.232  16.135  1.00  0.00           N  
ATOM   1299  CA  ASP A  79       1.865  26.676  14.835  1.00  0.00           C  
ATOM   1300  C   ASP A  79       2.403  25.502  14.025  1.00  0.00           C  
ATOM   1301  O   ASP A  79       2.363  25.511  12.796  1.00  0.00           O  
ATOM   1302  CB  ASP A  79       2.957  27.733  15.013  1.00  0.00           C  
ATOM   1303  CG  ASP A  79       3.406  28.329  13.693  1.00  0.00           C  
ATOM   1304  OD1 ASP A  79       2.761  29.290  13.227  1.00  0.00           O  
ATOM   1305  OD2 ASP A  79       4.402  27.832  13.126  1.00  0.00           O  
ATOM   1306  H   ASP A  79       2.012  26.096  16.866  1.00  0.00           H  
ATOM   1307  HA  ASP A  79       1.036  27.116  14.301  1.00  0.00           H  
ATOM   1308  HB2 ASP A  79       2.580  28.530  15.636  1.00  0.00           H  
ATOM   1309  HB3 ASP A  79       3.811  27.280  15.493  1.00  0.00           H  
ATOM   1310  N   ARG A  80       2.906  24.489  14.726  1.00  0.00           N  
ATOM   1311  CA  ARG A  80       3.455  23.306  14.072  1.00  0.00           C  
ATOM   1312  C   ARG A  80       3.861  22.257  15.102  1.00  0.00           C  
ATOM   1313  O   ARG A  80       4.113  22.578  16.263  1.00  0.00           O  
ATOM   1314  CB  ARG A  80       4.661  23.687  13.212  1.00  0.00           C  
ATOM   1315  CG  ARG A  80       5.882  24.093  14.019  1.00  0.00           C  
ATOM   1316  CD  ARG A  80       7.069  24.400  13.121  1.00  0.00           C  
ATOM   1317  NE  ARG A  80       7.501  23.227  12.364  1.00  0.00           N  
ATOM   1318  CZ  ARG A  80       6.960  22.858  11.209  1.00  0.00           C  
ATOM   1319  NH1 ARG A  80       5.973  23.567  10.678  1.00  0.00           N  
ATOM   1320  NH2 ARG A  80       7.408  21.777  10.581  1.00  0.00           N  
ATOM   1321  H   ARG A  80       2.910  24.540  15.704  1.00  0.00           H  
ATOM   1322  HA  ARG A  80       2.686  22.893  13.437  1.00  0.00           H  
ATOM   1323  HB2 ARG A  80       4.929  22.842  12.594  1.00  0.00           H  
ATOM   1324  HB3 ARG A  80       4.386  24.515  12.575  1.00  0.00           H  
ATOM   1325  HG2 ARG A  80       5.644  24.976  14.596  1.00  0.00           H  
ATOM   1326  HG3 ARG A  80       6.146  23.286  14.687  1.00  0.00           H  
ATOM   1327  HD2 ARG A  80       6.787  25.178  12.428  1.00  0.00           H  
ATOM   1328  HD3 ARG A  80       7.890  24.743  13.734  1.00  0.00           H  
ATOM   1329  HE  ARG A  80       8.229  22.689  12.739  1.00  0.00           H  
ATOM   1330 HH11 ARG A  80       5.634  24.381  11.149  1.00  0.00           H  
ATOM   1331 HH12 ARG A  80       5.569  23.287   9.807  1.00  0.00           H  
ATOM   1332 HH21 ARG A  80       8.151  21.240  10.978  1.00  0.00           H  
ATOM   1333 HH22 ARG A  80       7.000  21.501   9.712  1.00  0.00           H  
ATOM   1334  N   ILE A  81       3.922  21.003  14.667  1.00  0.00           N  
ATOM   1335  CA  ILE A  81       4.299  19.906  15.551  1.00  0.00           C  
ATOM   1336  C   ILE A  81       5.593  19.248  15.088  1.00  0.00           C  
ATOM   1337  O   ILE A  81       5.745  18.905  13.915  1.00  0.00           O  
ATOM   1338  CB  ILE A  81       3.191  18.838  15.626  1.00  0.00           C  
ATOM   1339  CG1 ILE A  81       1.867  19.474  16.055  1.00  0.00           C  
ATOM   1340  CG2 ILE A  81       3.589  17.729  16.588  1.00  0.00           C  
ATOM   1341  CD1 ILE A  81       0.682  18.544  15.928  1.00  0.00           C  
ATOM   1342  H   ILE A  81       3.710  20.811  13.731  1.00  0.00           H  
ATOM   1343  HA  ILE A  81       4.447  20.312  16.540  1.00  0.00           H  
ATOM   1344  HB  ILE A  81       3.073  18.405  14.644  1.00  0.00           H  
ATOM   1345 HG12 ILE A  81       1.940  19.779  17.087  1.00  0.00           H  
ATOM   1346 HG13 ILE A  81       1.678  20.343  15.440  1.00  0.00           H  
ATOM   1347 HG21 ILE A  81       4.485  18.019  17.120  1.00  0.00           H  
ATOM   1348 HG22 ILE A  81       2.790  17.563  17.294  1.00  0.00           H  
ATOM   1349 HG23 ILE A  81       3.777  16.821  16.035  1.00  0.00           H  
ATOM   1350 HD11 ILE A  81       0.822  17.896  15.076  1.00  0.00           H  
ATOM   1351 HD12 ILE A  81       0.592  17.950  16.824  1.00  0.00           H  
ATOM   1352 HD13 ILE A  81      -0.219  19.126  15.790  1.00  0.00           H  
ATOM   1353  N   LYS A  82       6.526  19.070  16.019  1.00  0.00           N  
ATOM   1354  CA  LYS A  82       7.809  18.451  15.709  1.00  0.00           C  
ATOM   1355  C   LYS A  82       7.991  17.156  16.495  1.00  0.00           C  
ATOM   1356  O   LYS A  82       7.821  17.129  17.714  1.00  0.00           O  
ATOM   1357  CB  LYS A  82       8.954  19.415  16.021  1.00  0.00           C  
ATOM   1358  CG  LYS A  82      10.210  19.154  15.207  1.00  0.00           C  
ATOM   1359  CD  LYS A  82      11.395  19.942  15.741  1.00  0.00           C  
ATOM   1360  CE  LYS A  82      11.262  21.425  15.432  1.00  0.00           C  
ATOM   1361  NZ  LYS A  82      12.087  22.259  16.349  1.00  0.00           N  
ATOM   1362  H   LYS A  82       6.347  19.365  16.937  1.00  0.00           H  
ATOM   1363  HA  LYS A  82       7.821  18.222  14.653  1.00  0.00           H  
ATOM   1364  HB2 LYS A  82       8.624  20.424  15.823  1.00  0.00           H  
ATOM   1365  HB3 LYS A  82       9.207  19.329  17.069  1.00  0.00           H  
ATOM   1366  HG2 LYS A  82      10.444  18.101  15.251  1.00  0.00           H  
ATOM   1367  HG3 LYS A  82      10.029  19.443  14.181  1.00  0.00           H  
ATOM   1368  HD2 LYS A  82      11.450  19.812  16.811  1.00  0.00           H  
ATOM   1369  HD3 LYS A  82      12.299  19.567  15.283  1.00  0.00           H  
ATOM   1370  HE2 LYS A  82      11.581  21.599  14.416  1.00  0.00           H  
ATOM   1371  HE3 LYS A  82      10.226  21.710  15.535  1.00  0.00           H  
ATOM   1372  HZ1 LYS A  82      12.774  22.819  15.803  1.00  0.00           H  
ATOM   1373  HZ2 LYS A  82      12.606  21.652  17.015  1.00  0.00           H  
ATOM   1374  HZ3 LYS A  82      11.480  22.907  16.889  1.00  0.00           H  
ATOM   1375  N   VAL A  83       8.338  16.084  15.790  1.00  0.00           N  
ATOM   1376  CA  VAL A  83       8.547  14.788  16.423  1.00  0.00           C  
ATOM   1377  C   VAL A  83       9.904  14.204  16.046  1.00  0.00           C  
ATOM   1378  O   VAL A  83      10.243  14.105  14.867  1.00  0.00           O  
ATOM   1379  CB  VAL A  83       7.442  13.788  16.029  1.00  0.00           C  
ATOM   1380  CG1 VAL A  83       7.697  12.432  16.670  1.00  0.00           C  
ATOM   1381  CG2 VAL A  83       6.074  14.325  16.421  1.00  0.00           C  
ATOM   1382  H   VAL A  83       8.458  16.168  14.821  1.00  0.00           H  
ATOM   1383  HA  VAL A  83       8.509  14.928  17.493  1.00  0.00           H  
ATOM   1384  HB  VAL A  83       7.463  13.664  14.956  1.00  0.00           H  
ATOM   1385 HG11 VAL A  83       8.407  11.879  16.072  1.00  0.00           H  
ATOM   1386 HG12 VAL A  83       8.094  12.572  17.664  1.00  0.00           H  
ATOM   1387 HG13 VAL A  83       6.768  11.881  16.726  1.00  0.00           H  
ATOM   1388 HG21 VAL A  83       5.341  13.536  16.331  1.00  0.00           H  
ATOM   1389 HG22 VAL A  83       6.103  14.674  17.443  1.00  0.00           H  
ATOM   1390 HG23 VAL A  83       5.807  15.142  15.769  1.00  0.00           H  
ATOM   1391  N   SER A  84      10.675  13.817  17.057  1.00  0.00           N  
ATOM   1392  CA  SER A  84      11.998  13.246  16.831  1.00  0.00           C  
ATOM   1393  C   SER A  84      12.055  11.800  17.317  1.00  0.00           C  
ATOM   1394  O   SER A  84      11.695  11.500  18.457  1.00  0.00           O  
ATOM   1395  CB  SER A  84      13.064  14.077  17.547  1.00  0.00           C  
ATOM   1396  OG  SER A  84      13.465  15.183  16.755  1.00  0.00           O  
ATOM   1397  H   SER A  84      10.349  13.921  17.974  1.00  0.00           H  
ATOM   1398  HA  SER A  84      12.192  13.264  15.770  1.00  0.00           H  
ATOM   1399  HB2 SER A  84      12.666  14.444  18.481  1.00  0.00           H  
ATOM   1400  HB3 SER A  84      13.928  13.457  17.743  1.00  0.00           H  
ATOM   1401  HG  SER A  84      14.249  14.951  16.254  1.00  0.00           H  
ATOM   1402  N   LEU A  85      12.508  10.907  16.443  1.00  0.00           N  
ATOM   1403  CA  LEU A  85      12.612   9.491  16.781  1.00  0.00           C  
ATOM   1404  C   LEU A  85      14.050   9.004  16.646  1.00  0.00           C  
ATOM   1405  O   LEU A  85      14.827   9.542  15.858  1.00  0.00           O  
ATOM   1406  CB  LEU A  85      11.694   8.664  15.881  1.00  0.00           C  
ATOM   1407  CG  LEU A  85      10.229   9.097  15.835  1.00  0.00           C  
ATOM   1408  CD1 LEU A  85       9.441   8.218  14.877  1.00  0.00           C  
ATOM   1409  CD2 LEU A  85       9.617   9.055  17.228  1.00  0.00           C  
ATOM   1410  H   LEU A  85      12.779  11.206  15.551  1.00  0.00           H  
ATOM   1411  HA  LEU A  85      12.300   9.371  17.808  1.00  0.00           H  
ATOM   1412  HB2 LEU A  85      12.084   8.712  14.876  1.00  0.00           H  
ATOM   1413  HB3 LEU A  85      11.726   7.641  16.229  1.00  0.00           H  
ATOM   1414  HG  LEU A  85      10.172  10.115  15.475  1.00  0.00           H  
ATOM   1415 HD11 LEU A  85       9.538   8.603  13.873  1.00  0.00           H  
ATOM   1416 HD12 LEU A  85       8.400   8.217  15.163  1.00  0.00           H  
ATOM   1417 HD13 LEU A  85       9.825   7.210  14.915  1.00  0.00           H  
ATOM   1418 HD21 LEU A  85      10.156   9.727  17.878  1.00  0.00           H  
ATOM   1419 HD22 LEU A  85       9.678   8.049  17.617  1.00  0.00           H  
ATOM   1420 HD23 LEU A  85       8.582   9.359  17.174  1.00  0.00           H  
ATOM   1421  N   SER A  86      14.400   7.981  17.420  1.00  0.00           N  
ATOM   1422  CA  SER A  86      15.745   7.422  17.387  1.00  0.00           C  
ATOM   1423  C   SER A  86      15.702   5.915  17.146  1.00  0.00           C  
ATOM   1424  O   SER A  86      14.752   5.239  17.540  1.00  0.00           O  
ATOM   1425  CB  SER A  86      16.475   7.718  18.699  1.00  0.00           C  
ATOM   1426  OG  SER A  86      17.162   8.956  18.632  1.00  0.00           O  
ATOM   1427  H   SER A  86      13.735   7.595  18.028  1.00  0.00           H  
ATOM   1428  HA  SER A  86      16.279   7.889  16.574  1.00  0.00           H  
ATOM   1429  HB2 SER A  86      15.758   7.761  19.505  1.00  0.00           H  
ATOM   1430  HB3 SER A  86      17.190   6.933  18.894  1.00  0.00           H  
ATOM   1431  HG  SER A  86      16.555   9.671  18.839  1.00  0.00           H  
ATOM   1432  N   MET A  87      16.739   5.397  16.495  1.00  0.00           N  
ATOM   1433  CA  MET A  87      16.820   3.971  16.202  1.00  0.00           C  
ATOM   1434  C   MET A  87      18.104   3.373  16.767  1.00  0.00           C  
ATOM   1435  O   MET A  87      18.150   2.192  17.116  1.00  0.00           O  
ATOM   1436  CB  MET A  87      16.755   3.735  14.693  1.00  0.00           C  
ATOM   1437  CG  MET A  87      15.431   4.146  14.068  1.00  0.00           C  
ATOM   1438  SD  MET A  87      15.522   4.287  12.273  1.00  0.00           S  
ATOM   1439  CE  MET A  87      15.896   2.594  11.819  1.00  0.00           C  
ATOM   1440  H   MET A  87      17.467   5.986  16.206  1.00  0.00           H  
ATOM   1441  HA  MET A  87      15.975   3.488  16.669  1.00  0.00           H  
ATOM   1442  HB2 MET A  87      17.543   4.300  14.217  1.00  0.00           H  
ATOM   1443  HB3 MET A  87      16.909   2.685  14.497  1.00  0.00           H  
ATOM   1444  HG2 MET A  87      14.685   3.407  14.319  1.00  0.00           H  
ATOM   1445  HG3 MET A  87      15.139   5.101  14.477  1.00  0.00           H  
ATOM   1446  HE1 MET A  87      16.965   2.475  11.728  1.00  0.00           H  
ATOM   1447  HE2 MET A  87      15.522   1.927  12.582  1.00  0.00           H  
ATOM   1448  HE3 MET A  87      15.425   2.364  10.875  1.00  0.00           H  
ATOM   1449  N   LYS A  88      19.145   4.192  16.854  1.00  0.00           N  
ATOM   1450  CA  LYS A  88      20.432   3.744  17.378  1.00  0.00           C  
ATOM   1451  C   LYS A  88      20.311   3.342  18.844  1.00  0.00           C  
ATOM   1452  O   LYS A  88      21.229   2.755  19.414  1.00  0.00           O  
ATOM   1453  CB  LYS A  88      21.480   4.849  17.226  1.00  0.00           C  
ATOM   1454  CG  LYS A  88      21.251   6.035  18.145  1.00  0.00           C  
ATOM   1455  CD  LYS A  88      22.471   6.939  18.204  1.00  0.00           C  
ATOM   1456  CE  LYS A  88      22.169   8.237  18.936  1.00  0.00           C  
ATOM   1457  NZ  LYS A  88      21.500   7.993  20.245  1.00  0.00           N  
ATOM   1458  H   LYS A  88      19.048   5.122  16.559  1.00  0.00           H  
ATOM   1459  HA  LYS A  88      20.741   2.885  16.805  1.00  0.00           H  
ATOM   1460  HB2 LYS A  88      22.454   4.436  17.440  1.00  0.00           H  
ATOM   1461  HB3 LYS A  88      21.465   5.204  16.204  1.00  0.00           H  
ATOM   1462  HG2 LYS A  88      20.410   6.606  17.780  1.00  0.00           H  
ATOM   1463  HG3 LYS A  88      21.036   5.672  19.140  1.00  0.00           H  
ATOM   1464  HD2 LYS A  88      23.267   6.423  18.722  1.00  0.00           H  
ATOM   1465  HD3 LYS A  88      22.787   7.169  17.196  1.00  0.00           H  
ATOM   1466  HE2 LYS A  88      23.097   8.761  19.110  1.00  0.00           H  
ATOM   1467  HE3 LYS A  88      21.523   8.843  18.318  1.00  0.00           H  
ATOM   1468  HZ1 LYS A  88      20.468   7.945  20.114  1.00  0.00           H  
ATOM   1469  HZ2 LYS A  88      21.717   8.765  20.906  1.00  0.00           H  
ATOM   1470  HZ3 LYS A  88      21.830   7.096  20.654  1.00  0.00           H  
ATOM   1471  N   VAL A  89      19.171   3.661  19.449  1.00  0.00           N  
ATOM   1472  CA  VAL A  89      18.930   3.329  20.849  1.00  0.00           C  
ATOM   1473  C   VAL A  89      17.845   2.266  20.983  1.00  0.00           C  
ATOM   1474  O   VAL A  89      17.328   2.025  22.073  1.00  0.00           O  
ATOM   1475  CB  VAL A  89      18.516   4.574  21.656  1.00  0.00           C  
ATOM   1476  CG1 VAL A  89      19.670   5.560  21.745  1.00  0.00           C  
ATOM   1477  CG2 VAL A  89      17.291   5.229  21.036  1.00  0.00           C  
ATOM   1478  H   VAL A  89      18.475   4.129  18.941  1.00  0.00           H  
ATOM   1479  HA  VAL A  89      19.850   2.946  21.264  1.00  0.00           H  
ATOM   1480  HB  VAL A  89      18.261   4.260  22.658  1.00  0.00           H  
ATOM   1481 HG11 VAL A  89      19.770   6.082  20.805  1.00  0.00           H  
ATOM   1482 HG12 VAL A  89      19.476   6.272  22.534  1.00  0.00           H  
ATOM   1483 HG13 VAL A  89      20.584   5.027  21.959  1.00  0.00           H  
ATOM   1484 HG21 VAL A  89      16.987   4.669  20.165  1.00  0.00           H  
ATOM   1485 HG22 VAL A  89      16.484   5.242  21.755  1.00  0.00           H  
ATOM   1486 HG23 VAL A  89      17.530   6.241  20.747  1.00  0.00           H  
ATOM   1487  N   VAL A  90      17.503   1.634  19.865  1.00  0.00           N  
ATOM   1488  CA  VAL A  90      16.480   0.595  19.858  1.00  0.00           C  
ATOM   1489  C   VAL A  90      16.897  -0.580  18.979  1.00  0.00           C  
ATOM   1490  O   VAL A  90      17.319  -0.396  17.837  1.00  0.00           O  
ATOM   1491  CB  VAL A  90      15.129   1.141  19.357  1.00  0.00           C  
ATOM   1492  CG1 VAL A  90      14.063   0.056  19.407  1.00  0.00           C  
ATOM   1493  CG2 VAL A  90      14.709   2.351  20.177  1.00  0.00           C  
ATOM   1494  H   VAL A  90      17.950   1.871  19.025  1.00  0.00           H  
ATOM   1495  HA  VAL A  90      16.350   0.246  20.870  1.00  0.00           H  
ATOM   1496  HB  VAL A  90      15.247   1.452  18.330  1.00  0.00           H  
ATOM   1497 HG11 VAL A  90      14.293  -0.707  18.679  1.00  0.00           H  
ATOM   1498 HG12 VAL A  90      14.040  -0.382  20.394  1.00  0.00           H  
ATOM   1499 HG13 VAL A  90      13.099   0.488  19.183  1.00  0.00           H  
ATOM   1500 HG21 VAL A  90      13.721   2.666  19.872  1.00  0.00           H  
ATOM   1501 HG22 VAL A  90      14.695   2.091  21.225  1.00  0.00           H  
ATOM   1502 HG23 VAL A  90      15.409   3.157  20.017  1.00  0.00           H  
ATOM   1503  N   ASN A  91      16.775  -1.788  19.519  1.00  0.00           N  
ATOM   1504  CA  ASN A  91      17.138  -2.993  18.785  1.00  0.00           C  
ATOM   1505  C   ASN A  91      16.265  -3.160  17.545  1.00  0.00           C  
ATOM   1506  O   ASN A  91      15.252  -2.480  17.393  1.00  0.00           O  
ATOM   1507  CB  ASN A  91      17.005  -4.224  19.685  1.00  0.00           C  
ATOM   1508  CG  ASN A  91      17.852  -5.387  19.203  1.00  0.00           C  
ATOM   1509  OD1 ASN A  91      17.330  -6.380  18.695  1.00  0.00           O  
ATOM   1510  ND2 ASN A  91      19.165  -5.269  19.362  1.00  0.00           N  
ATOM   1511  H   ASN A  91      16.431  -1.870  20.434  1.00  0.00           H  
ATOM   1512  HA  ASN A  91      18.169  -2.895  18.475  1.00  0.00           H  
ATOM   1513  HB2 ASN A  91      17.320  -3.966  20.686  1.00  0.00           H  
ATOM   1514  HB3 ASN A  91      15.973  -4.537  19.707  1.00  0.00           H  
ATOM   1515 HD21 ASN A  91      19.509  -4.450  19.774  1.00  0.00           H  
ATOM   1516 HD22 ASN A  91      19.735  -6.006  19.059  1.00  0.00           H  
ATOM   1517  N   GLN A  92      16.667  -4.072  16.663  1.00  0.00           N  
ATOM   1518  CA  GLN A  92      15.920  -4.326  15.438  1.00  0.00           C  
ATOM   1519  C   GLN A  92      15.417  -5.766  15.397  1.00  0.00           C  
ATOM   1520  O   GLN A  92      14.589  -6.122  14.558  1.00  0.00           O  
ATOM   1521  CB  GLN A  92      16.795  -4.044  14.215  1.00  0.00           C  
ATOM   1522  CG  GLN A  92      17.363  -2.635  14.185  1.00  0.00           C  
ATOM   1523  CD  GLN A  92      16.304  -1.574  14.408  1.00  0.00           C  
ATOM   1524  OE1 GLN A  92      15.196  -1.666  13.879  1.00  0.00           O  
ATOM   1525  NE2 GLN A  92      16.639  -0.559  15.196  1.00  0.00           N  
ATOM   1526  H   GLN A  92      17.482  -4.582  16.841  1.00  0.00           H  
ATOM   1527  HA  GLN A  92      15.071  -3.661  15.421  1.00  0.00           H  
ATOM   1528  HB2 GLN A  92      17.619  -4.742  14.208  1.00  0.00           H  
ATOM   1529  HB3 GLN A  92      16.203  -4.189  13.322  1.00  0.00           H  
ATOM   1530  HG2 GLN A  92      18.110  -2.545  14.960  1.00  0.00           H  
ATOM   1531  HG3 GLN A  92      17.823  -2.467  13.223  1.00  0.00           H  
ATOM   1532 HE21 GLN A  92      17.541  -0.552  15.582  1.00  0.00           H  
ATOM   1533 HE22 GLN A  92      15.974   0.141  15.357  1.00  0.00           H  
ATOM   1534  N   GLY A  93      15.924  -6.592  16.308  1.00  0.00           N  
ATOM   1535  CA  GLY A  93      15.514  -7.982  16.358  1.00  0.00           C  
ATOM   1536  C   GLY A  93      14.336  -8.207  17.284  1.00  0.00           C  
ATOM   1537  O   GLY A  93      13.487  -9.062  17.027  1.00  0.00           O  
ATOM   1538  H   GLY A  93      16.580  -6.251  16.951  1.00  0.00           H  
ATOM   1539  HA2 GLY A  93      15.243  -8.303  15.363  1.00  0.00           H  
ATOM   1540  HA3 GLY A  93      16.347  -8.578  16.702  1.00  0.00           H  
ATOM   1541  N   THR A  94      14.282  -7.439  18.368  1.00  0.00           N  
ATOM   1542  CA  THR A  94      13.200  -7.560  19.337  1.00  0.00           C  
ATOM   1543  C   THR A  94      12.527  -6.213  19.581  1.00  0.00           C  
ATOM   1544  O   THR A  94      11.328  -6.147  19.847  1.00  0.00           O  
ATOM   1545  CB  THR A  94      13.710  -8.117  20.679  1.00  0.00           C  
ATOM   1546  OG1 THR A  94      14.198  -7.050  21.500  1.00  0.00           O  
ATOM   1547  CG2 THR A  94      14.814  -9.139  20.458  1.00  0.00           C  
ATOM   1548  H   THR A  94      14.986  -6.775  18.517  1.00  0.00           H  
ATOM   1549  HA  THR A  94      12.471  -8.250  18.939  1.00  0.00           H  
ATOM   1550  HB  THR A  94      12.886  -8.602  21.186  1.00  0.00           H  
ATOM   1551  HG1 THR A  94      13.458  -6.588  21.899  1.00  0.00           H  
ATOM   1552 HG21 THR A  94      14.387 -10.051  20.067  1.00  0.00           H  
ATOM   1553 HG22 THR A  94      15.307  -9.345  21.395  1.00  0.00           H  
ATOM   1554 HG23 THR A  94      15.530  -8.746  19.752  1.00  0.00           H  
ATOM   1555  N   GLY A  95      13.308  -5.142  19.489  1.00  0.00           N  
ATOM   1556  CA  GLY A  95      12.769  -3.811  19.703  1.00  0.00           C  
ATOM   1557  C   GLY A  95      12.887  -3.362  21.145  1.00  0.00           C  
ATOM   1558  O   GLY A  95      12.237  -2.402  21.560  1.00  0.00           O  
ATOM   1559  H   GLY A  95      14.257  -5.255  19.274  1.00  0.00           H  
ATOM   1560  HA2 GLY A  95      13.304  -3.114  19.075  1.00  0.00           H  
ATOM   1561  HA3 GLY A  95      11.727  -3.808  19.420  1.00  0.00           H  
ATOM   1562  N   LYS A  96      13.717  -4.059  21.915  1.00  0.00           N  
ATOM   1563  CA  LYS A  96      13.917  -3.728  23.320  1.00  0.00           C  
ATOM   1564  C   LYS A  96      14.804  -2.496  23.468  1.00  0.00           C  
ATOM   1565  O   LYS A  96      15.715  -2.277  22.669  1.00  0.00           O  
ATOM   1566  CB  LYS A  96      14.545  -4.913  24.059  1.00  0.00           C  
ATOM   1567  CG  LYS A  96      14.249  -4.925  25.549  1.00  0.00           C  
ATOM   1568  CD  LYS A  96      14.637  -6.250  26.184  1.00  0.00           C  
ATOM   1569  CE  LYS A  96      13.636  -7.344  25.843  1.00  0.00           C  
ATOM   1570  NZ  LYS A  96      13.618  -8.419  26.874  1.00  0.00           N  
ATOM   1571  H   LYS A  96      14.206  -4.814  21.527  1.00  0.00           H  
ATOM   1572  HA  LYS A  96      12.951  -3.515  23.752  1.00  0.00           H  
ATOM   1573  HB2 LYS A  96      14.166  -5.829  23.632  1.00  0.00           H  
ATOM   1574  HB3 LYS A  96      15.616  -4.878  23.927  1.00  0.00           H  
ATOM   1575  HG2 LYS A  96      14.809  -4.133  26.025  1.00  0.00           H  
ATOM   1576  HG3 LYS A  96      13.191  -4.759  25.698  1.00  0.00           H  
ATOM   1577  HD2 LYS A  96      15.610  -6.542  25.820  1.00  0.00           H  
ATOM   1578  HD3 LYS A  96      14.672  -6.128  27.257  1.00  0.00           H  
ATOM   1579  HE2 LYS A  96      12.652  -6.905  25.776  1.00  0.00           H  
ATOM   1580  HE3 LYS A  96      13.904  -7.776  24.891  1.00  0.00           H  
ATOM   1581  HZ1 LYS A  96      14.576  -8.571  27.249  1.00  0.00           H  
ATOM   1582  HZ2 LYS A  96      13.275  -9.308  26.458  1.00  0.00           H  
ATOM   1583  HZ3 LYS A  96      12.989  -8.151  27.659  1.00  0.00           H  
ATOM   1584  N   ASP A  97      14.532  -1.696  24.493  1.00  0.00           N  
ATOM   1585  CA  ASP A  97      15.306  -0.488  24.747  1.00  0.00           C  
ATOM   1586  C   ASP A  97      16.777  -0.823  24.979  1.00  0.00           C  
ATOM   1587  O   ASP A  97      17.105  -1.722  25.754  1.00  0.00           O  
ATOM   1588  CB  ASP A  97      14.744   0.259  25.957  1.00  0.00           C  
ATOM   1589  CG  ASP A  97      15.232   1.693  26.031  1.00  0.00           C  
ATOM   1590  OD1 ASP A  97      16.332   1.973  25.511  1.00  0.00           O  
ATOM   1591  OD2 ASP A  97      14.513   2.535  26.607  1.00  0.00           O  
ATOM   1592  H   ASP A  97      13.792  -1.925  25.094  1.00  0.00           H  
ATOM   1593  HA  ASP A  97      15.227   0.146  23.877  1.00  0.00           H  
ATOM   1594  HB2 ASP A  97      13.665   0.269  25.898  1.00  0.00           H  
ATOM   1595  HB3 ASP A  97      15.047  -0.251  26.860  1.00  0.00           H  
ATOM   1596  N   LEU A  98      17.658  -0.095  24.301  1.00  0.00           N  
ATOM   1597  CA  LEU A  98      19.094  -0.316  24.431  1.00  0.00           C  
ATOM   1598  C   LEU A  98      19.748   0.812  25.222  1.00  0.00           C  
ATOM   1599  O   LEU A  98      20.863   0.666  25.725  1.00  0.00           O  
ATOM   1600  CB  LEU A  98      19.740  -0.427  23.049  1.00  0.00           C  
ATOM   1601  CG  LEU A  98      19.166  -1.501  22.124  1.00  0.00           C  
ATOM   1602  CD1 LEU A  98      19.783  -1.396  20.738  1.00  0.00           C  
ATOM   1603  CD2 LEU A  98      19.395  -2.887  22.709  1.00  0.00           C  
ATOM   1604  H   LEU A  98      17.337   0.607  23.698  1.00  0.00           H  
ATOM   1605  HA  LEU A  98      19.240  -1.245  24.964  1.00  0.00           H  
ATOM   1606  HB2 LEU A  98      19.631   0.526  22.555  1.00  0.00           H  
ATOM   1607  HB3 LEU A  98      20.791  -0.639  23.192  1.00  0.00           H  
ATOM   1608  HG  LEU A  98      18.100  -1.350  22.026  1.00  0.00           H  
ATOM   1609 HD11 LEU A  98      20.142  -2.366  20.430  1.00  0.00           H  
ATOM   1610 HD12 LEU A  98      20.607  -0.699  20.762  1.00  0.00           H  
ATOM   1611 HD13 LEU A  98      19.038  -1.049  20.038  1.00  0.00           H  
ATOM   1612 HD21 LEU A  98      18.505  -3.484  22.577  1.00  0.00           H  
ATOM   1613 HD22 LEU A  98      19.619  -2.800  23.763  1.00  0.00           H  
ATOM   1614 HD23 LEU A  98      20.225  -3.358  22.203  1.00  0.00           H  
ATOM   1615  N   ASP A  99      19.048   1.935  25.330  1.00  0.00           N  
ATOM   1616  CA  ASP A  99      19.560   3.088  26.063  1.00  0.00           C  
ATOM   1617  C   ASP A  99      18.517   3.612  27.047  1.00  0.00           C  
ATOM   1618  O   ASP A  99      17.875   4.637  26.820  1.00  0.00           O  
ATOM   1619  CB  ASP A  99      19.965   4.198  25.092  1.00  0.00           C  
ATOM   1620  CG  ASP A  99      20.662   5.351  25.788  1.00  0.00           C  
ATOM   1621  OD1 ASP A  99      21.708   5.112  26.428  1.00  0.00           O  
ATOM   1622  OD2 ASP A  99      20.162   6.489  25.694  1.00  0.00           O  
ATOM   1623  H   ASP A  99      18.165   1.991  24.906  1.00  0.00           H  
ATOM   1624  HA  ASP A  99      20.431   2.769  26.615  1.00  0.00           H  
ATOM   1625  HB2 ASP A  99      20.637   3.791  24.351  1.00  0.00           H  
ATOM   1626  HB3 ASP A  99      19.082   4.578  24.601  1.00  0.00           H  
ATOM   1627  N   PRO A 100      18.347   2.893  28.166  1.00  0.00           N  
ATOM   1628  CA  PRO A 100      17.384   3.265  29.207  1.00  0.00           C  
ATOM   1629  C   PRO A 100      17.804   4.521  29.963  1.00  0.00           C  
ATOM   1630  O   PRO A 100      17.089   4.994  30.844  1.00  0.00           O  
ATOM   1631  CB  PRO A 100      17.386   2.054  30.142  1.00  0.00           C  
ATOM   1632  CG  PRO A 100      18.721   1.423  29.942  1.00  0.00           C  
ATOM   1633  CD  PRO A 100      19.079   1.660  28.502  1.00  0.00           C  
ATOM   1634  HA  PRO A 100      16.393   3.406  28.799  1.00  0.00           H  
ATOM   1635  HB2 PRO A 100      17.252   2.384  31.163  1.00  0.00           H  
ATOM   1636  HB3 PRO A 100      16.586   1.380  29.867  1.00  0.00           H  
ATOM   1637  HG2 PRO A 100      19.447   1.888  30.591  1.00  0.00           H  
ATOM   1638  HG3 PRO A 100      18.659   0.363  30.143  1.00  0.00           H  
ATOM   1639  HD2 PRO A 100      20.144   1.804  28.396  1.00  0.00           H  
ATOM   1640  HD3 PRO A 100      18.746   0.835  27.889  1.00  0.00           H  
ATOM   1641  N   ASN A 101      18.968   5.057  29.608  1.00  0.00           N  
ATOM   1642  CA  ASN A 101      19.484   6.259  30.253  1.00  0.00           C  
ATOM   1643  C   ASN A 101      18.987   7.515  29.542  1.00  0.00           C  
ATOM   1644  O   ASN A 101      18.625   8.501  30.181  1.00  0.00           O  
ATOM   1645  CB  ASN A 101      21.013   6.240  30.270  1.00  0.00           C  
ATOM   1646  CG  ASN A 101      21.568   5.068  31.056  1.00  0.00           C  
ATOM   1647  OD1 ASN A 101      20.873   4.475  31.882  1.00  0.00           O  
ATOM   1648  ND2 ASN A 101      22.826   4.728  30.801  1.00  0.00           N  
ATOM   1649  H   ASN A 101      19.493   4.634  28.897  1.00  0.00           H  
ATOM   1650  HA  ASN A 101      19.121   6.270  31.271  1.00  0.00           H  
ATOM   1651  HB2 ASN A 101      21.376   6.170  29.254  1.00  0.00           H  
ATOM   1652  HB3 ASN A 101      21.374   7.153  30.716  1.00  0.00           H  
ATOM   1653 HD21 ASN A 101      23.318   5.244  30.131  1.00  0.00           H  
ATOM   1654 HD22 ASN A 101      23.209   3.973  31.295  1.00  0.00           H  
ATOM   1655  N   ASN A 102      18.973   7.467  28.213  1.00  0.00           N  
ATOM   1656  CA  ASN A 102      18.521   8.601  27.413  1.00  0.00           C  
ATOM   1657  C   ASN A 102      19.440   9.804  27.608  1.00  0.00           C  
ATOM   1658  O   ASN A 102      18.976  10.936  27.752  1.00  0.00           O  
ATOM   1659  CB  ASN A 102      17.086   8.975  27.787  1.00  0.00           C  
ATOM   1660  CG  ASN A 102      16.209   7.757  28.003  1.00  0.00           C  
ATOM   1661  OD1 ASN A 102      15.840   7.065  27.051  1.00  0.00           O  
ATOM   1662  ND2 ASN A 102      15.868   7.488  29.257  1.00  0.00           N  
ATOM   1663  H   ASN A 102      19.275   6.653  27.760  1.00  0.00           H  
ATOM   1664  HA  ASN A 102      18.550   8.306  26.375  1.00  0.00           H  
ATOM   1665  HB2 ASN A 102      17.096   9.552  28.699  1.00  0.00           H  
ATOM   1666  HB3 ASN A 102      16.656   9.569  26.993  1.00  0.00           H  
ATOM   1667 HD21 ASN A 102      16.197   8.082  29.964  1.00  0.00           H  
ATOM   1668 HD22 ASN A 102      15.303   6.706  29.425  1.00  0.00           H  
ATOM   1669  N   VAL A 103      20.745   9.552  27.609  1.00  0.00           N  
ATOM   1670  CA  VAL A 103      21.728  10.614  27.784  1.00  0.00           C  
ATOM   1671  C   VAL A 103      22.362  11.000  26.452  1.00  0.00           C  
ATOM   1672  O   VAL A 103      22.641  12.173  26.204  1.00  0.00           O  
ATOM   1673  CB  VAL A 103      22.839  10.195  28.766  1.00  0.00           C  
ATOM   1674  CG1 VAL A 103      23.819  11.337  28.984  1.00  0.00           C  
ATOM   1675  CG2 VAL A 103      22.237   9.738  30.086  1.00  0.00           C  
ATOM   1676  H   VAL A 103      21.053   8.630  27.489  1.00  0.00           H  
ATOM   1677  HA  VAL A 103      21.221  11.474  28.193  1.00  0.00           H  
ATOM   1678  HB  VAL A 103      23.378   9.364  28.333  1.00  0.00           H  
ATOM   1679 HG11 VAL A 103      24.821  10.944  29.044  1.00  0.00           H  
ATOM   1680 HG12 VAL A 103      23.752  12.031  28.158  1.00  0.00           H  
ATOM   1681 HG13 VAL A 103      23.577  11.848  29.903  1.00  0.00           H  
ATOM   1682 HG21 VAL A 103      22.611   8.756  30.331  1.00  0.00           H  
ATOM   1683 HG22 VAL A 103      22.513  10.432  30.867  1.00  0.00           H  
ATOM   1684 HG23 VAL A 103      21.161   9.704  30.000  1.00  0.00           H  
ATOM   1685  N   ILE A 104      22.584  10.006  25.598  1.00  0.00           N  
ATOM   1686  CA  ILE A 104      23.183  10.244  24.291  1.00  0.00           C  
ATOM   1687  C   ILE A 104      22.307  11.159  23.442  1.00  0.00           C  
ATOM   1688  O   ILE A 104      22.807  12.055  22.762  1.00  0.00           O  
ATOM   1689  CB  ILE A 104      23.415   8.924  23.530  1.00  0.00           C  
ATOM   1690  CG1 ILE A 104      24.327   7.998  24.338  1.00  0.00           C  
ATOM   1691  CG2 ILE A 104      24.011   9.201  22.158  1.00  0.00           C  
ATOM   1692  CD1 ILE A 104      23.587   7.155  25.353  1.00  0.00           C  
ATOM   1693  H   ILE A 104      22.339   9.093  25.854  1.00  0.00           H  
ATOM   1694  HA  ILE A 104      24.141  10.719  24.445  1.00  0.00           H  
ATOM   1695  HB  ILE A 104      22.459   8.443  23.391  1.00  0.00           H  
ATOM   1696 HG12 ILE A 104      24.840   7.330  23.663  1.00  0.00           H  
ATOM   1697 HG13 ILE A 104      25.054   8.595  24.867  1.00  0.00           H  
ATOM   1698 HG21 ILE A 104      24.005   8.293  21.573  1.00  0.00           H  
ATOM   1699 HG22 ILE A 104      23.423   9.955  21.658  1.00  0.00           H  
ATOM   1700 HG23 ILE A 104      25.026   9.549  22.271  1.00  0.00           H  
ATOM   1701 HD11 ILE A 104      23.833   7.492  26.349  1.00  0.00           H  
ATOM   1702 HD12 ILE A 104      22.525   7.249  25.192  1.00  0.00           H  
ATOM   1703 HD13 ILE A 104      23.880   6.120  25.242  1.00  0.00           H  
ATOM   1704  N   ILE A 105      20.999  10.930  23.491  1.00  0.00           N  
ATOM   1705  CA  ILE A 105      20.054  11.735  22.729  1.00  0.00           C  
ATOM   1706  C   ILE A 105      20.179  13.213  23.086  1.00  0.00           C  
ATOM   1707  O   ILE A 105      19.758  14.083  22.324  1.00  0.00           O  
ATOM   1708  CB  ILE A 105      18.604  11.281  22.972  1.00  0.00           C  
ATOM   1709  CG1 ILE A 105      18.213  11.509  24.432  1.00  0.00           C  
ATOM   1710  CG2 ILE A 105      18.436   9.816  22.595  1.00  0.00           C  
ATOM   1711  CD1 ILE A 105      17.674  12.895  24.706  1.00  0.00           C  
ATOM   1712  H   ILE A 105      20.663  10.200  24.052  1.00  0.00           H  
ATOM   1713  HA  ILE A 105      20.280  11.610  21.680  1.00  0.00           H  
ATOM   1714  HB  ILE A 105      17.956  11.867  22.337  1.00  0.00           H  
ATOM   1715 HG12 ILE A 105      17.451  10.797  24.711  1.00  0.00           H  
ATOM   1716 HG13 ILE A 105      19.082  11.361  25.058  1.00  0.00           H  
ATOM   1717 HG21 ILE A 105      18.294   9.733  21.528  1.00  0.00           H  
ATOM   1718 HG22 ILE A 105      19.321   9.269  22.884  1.00  0.00           H  
ATOM   1719 HG23 ILE A 105      17.578   9.409  23.106  1.00  0.00           H  
ATOM   1720 HD11 ILE A 105      17.114  12.891  25.629  1.00  0.00           H  
ATOM   1721 HD12 ILE A 105      18.495  13.593  24.784  1.00  0.00           H  
ATOM   1722 HD13 ILE A 105      17.024  13.195  23.895  1.00  0.00           H  
ATOM   1723  N   GLU A 106      20.762  13.488  24.248  1.00  0.00           N  
ATOM   1724  CA  GLU A 106      20.944  14.860  24.705  1.00  0.00           C  
ATOM   1725  C   GLU A 106      22.314  15.394  24.295  1.00  0.00           C  
ATOM   1726  O   GLU A 106      23.346  14.824  24.649  1.00  0.00           O  
ATOM   1727  CB  GLU A 106      20.788  14.940  26.226  1.00  0.00           C  
ATOM   1728  CG  GLU A 106      21.004  16.335  26.788  1.00  0.00           C  
ATOM   1729  CD  GLU A 106      20.223  16.578  28.064  1.00  0.00           C  
ATOM   1730  OE1 GLU A 106      20.522  15.913  29.078  1.00  0.00           O  
ATOM   1731  OE2 GLU A 106      19.312  17.432  28.049  1.00  0.00           O  
ATOM   1732  H   GLU A 106      21.078  12.750  24.811  1.00  0.00           H  
ATOM   1733  HA  GLU A 106      20.181  15.468  24.242  1.00  0.00           H  
ATOM   1734  HB2 GLU A 106      19.791  14.617  26.491  1.00  0.00           H  
ATOM   1735  HB3 GLU A 106      21.506  14.275  26.684  1.00  0.00           H  
ATOM   1736  HG2 GLU A 106      22.056  16.466  26.997  1.00  0.00           H  
ATOM   1737  HG3 GLU A 106      20.692  17.058  26.049  1.00  0.00           H  
ATOM   1738  N   SER A 107      22.313  16.492  23.545  1.00  0.00           N  
ATOM   1739  CA  SER A 107      23.555  17.101  23.083  1.00  0.00           C  
ATOM   1740  C   SER A 107      24.491  17.385  24.254  1.00  0.00           C  
ATOM   1741  O   SER A 107      24.422  18.445  24.875  1.00  0.00           O  
ATOM   1742  CB  SER A 107      23.260  18.397  22.325  1.00  0.00           C  
ATOM   1743  OG  SER A 107      23.005  18.140  20.955  1.00  0.00           O  
ATOM   1744  H   SER A 107      21.458  16.901  23.296  1.00  0.00           H  
ATOM   1745  HA  SER A 107      24.036  16.404  22.412  1.00  0.00           H  
ATOM   1746  HB2 SER A 107      22.395  18.875  22.757  1.00  0.00           H  
ATOM   1747  HB3 SER A 107      24.111  19.057  22.403  1.00  0.00           H  
ATOM   1748  HG  SER A 107      22.227  18.628  20.676  1.00  0.00           H  
ATOM   1749  N   GLY A 108      25.365  16.429  24.550  1.00  0.00           N  
ATOM   1750  CA  GLY A 108      26.302  16.593  25.646  1.00  0.00           C  
ATOM   1751  C   GLY A 108      27.746  16.589  25.181  1.00  0.00           C  
ATOM   1752  O   GLY A 108      28.063  16.139  24.080  1.00  0.00           O  
ATOM   1753  H   GLY A 108      25.374  15.604  24.021  1.00  0.00           H  
ATOM   1754  HA2 GLY A 108      26.098  17.531  26.142  1.00  0.00           H  
ATOM   1755  HA3 GLY A 108      26.160  15.787  26.351  1.00  0.00           H  
ATOM   1756  N   PRO A 109      28.647  17.100  26.031  1.00  0.00           N  
ATOM   1757  CA  PRO A 109      30.078  17.165  25.723  1.00  0.00           C  
ATOM   1758  C   PRO A 109      30.731  15.787  25.706  1.00  0.00           C  
ATOM   1759  O   PRO A 109      30.381  14.914  26.500  1.00  0.00           O  
ATOM   1760  CB  PRO A 109      30.649  18.014  26.863  1.00  0.00           C  
ATOM   1761  CG  PRO A 109      29.694  17.824  27.989  1.00  0.00           C  
ATOM   1762  CD  PRO A 109      28.339  17.654  27.361  1.00  0.00           C  
ATOM   1763  HA  PRO A 109      30.259  17.659  24.779  1.00  0.00           H  
ATOM   1764  HB2 PRO A 109      31.637  17.659  27.118  1.00  0.00           H  
ATOM   1765  HB3 PRO A 109      30.699  19.047  26.556  1.00  0.00           H  
ATOM   1766  HG2 PRO A 109      29.960  16.942  28.552  1.00  0.00           H  
ATOM   1767  HG3 PRO A 109      29.703  18.695  28.628  1.00  0.00           H  
ATOM   1768  HD2 PRO A 109      27.740  16.963  27.937  1.00  0.00           H  
ATOM   1769  HD3 PRO A 109      27.840  18.609  27.274  1.00  0.00           H  
ATOM   1770  N   SER A 110      31.682  15.600  24.796  1.00  0.00           N  
ATOM   1771  CA  SER A 110      32.382  14.326  24.674  1.00  0.00           C  
ATOM   1772  C   SER A 110      33.680  14.493  23.889  1.00  0.00           C  
ATOM   1773  O   SER A 110      33.902  15.517  23.247  1.00  0.00           O  
ATOM   1774  CB  SER A 110      31.487  13.293  23.987  1.00  0.00           C  
ATOM   1775  OG  SER A 110      31.960  11.975  24.216  1.00  0.00           O  
ATOM   1776  H   SER A 110      31.917  16.334  24.191  1.00  0.00           H  
ATOM   1777  HA  SER A 110      32.618  13.980  25.669  1.00  0.00           H  
ATOM   1778  HB2 SER A 110      30.483  13.374  24.376  1.00  0.00           H  
ATOM   1779  HB3 SER A 110      31.477  13.479  22.923  1.00  0.00           H  
ATOM   1780  HG  SER A 110      31.213  11.377  24.298  1.00  0.00           H  
ATOM   1781  N   SER A 111      34.535  13.475  23.948  1.00  0.00           N  
ATOM   1782  CA  SER A 111      35.813  13.510  23.248  1.00  0.00           C  
ATOM   1783  C   SER A 111      35.673  12.944  21.838  1.00  0.00           C  
ATOM   1784  O   SER A 111      34.740  12.198  21.544  1.00  0.00           O  
ATOM   1785  CB  SER A 111      36.865  12.717  24.025  1.00  0.00           C  
ATOM   1786  OG  SER A 111      38.109  12.719  23.346  1.00  0.00           O  
ATOM   1787  H   SER A 111      34.300  12.685  24.478  1.00  0.00           H  
ATOM   1788  HA  SER A 111      36.126  14.540  23.180  1.00  0.00           H  
ATOM   1789  HB2 SER A 111      37.000  13.163  25.000  1.00  0.00           H  
ATOM   1790  HB3 SER A 111      36.532  11.696  24.139  1.00  0.00           H  
ATOM   1791  HG  SER A 111      38.813  12.510  23.966  1.00  0.00           H  
ATOM   1792  N   GLY A 112      36.612  13.305  20.967  1.00  0.00           N  
ATOM   1793  CA  GLY A 112      36.576  12.826  19.597  1.00  0.00           C  
ATOM   1794  C   GLY A 112      35.171  12.793  19.030  1.00  0.00           C  
ATOM   1795  O   GLY A 112      34.682  13.795  18.509  1.00  0.00           O  
ATOM   1796  H   GLY A 112      37.333  13.901  21.257  1.00  0.00           H  
ATOM   1797  HA2 GLY A 112      37.187  13.473  18.985  1.00  0.00           H  
ATOM   1798  HA3 GLY A 112      36.988  11.827  19.568  1.00  0.00           H  
TER    1799      GLY A 112                                                      
END
MOLECULE T0409.pdb
ATOM     14  N   TYR     1     -12.138  -6.437  34.342  1.00 26.71           N  
ATOM     15  CA  TYR     1     -10.769  -6.327  34.864  1.00 25.90           C  
ATOM     16  C   TYR     1     -10.498  -7.542  35.724  1.00 24.98           C  
ATOM     17  O   TYR     1     -11.355  -7.916  36.501  1.00 26.34           O  
ATOM     18  CB  TYR     1     -10.618  -5.047  35.686  1.00 24.63           C  
ATOM     19  CG  TYR     1      -9.168  -4.728  36.029  1.00 22.28           C  
ATOM     20  CD1 TYR     1      -8.285  -4.357  35.005  1.00 22.31           C  
ATOM     21  CD2 TYR     1      -8.664  -4.878  37.313  1.00 23.91           C  
ATOM     22  CE1 TYR     1      -6.951  -4.068  35.280  1.00 18.52           C  
ATOM     23  CE2 TYR     1      -7.324  -4.598  37.613  1.00 21.53           C  
ATOM     24  CZ  TYR     1      -6.480  -4.192  36.581  1.00 19.19           C  
ATOM     25  OH  TYR     1      -5.185  -3.925  36.888  1.00 18.14           O  
ATOM     26  N   ARG     2      -9.329  -8.164  35.541  1.00 24.27           N  
ATOM     27  CA  ARG     2      -8.922  -9.381  36.228  1.00 24.78           C  
ATOM     28  C   ARG     2      -7.920  -9.194  37.353  1.00 24.52           C  
ATOM     29  O   ARG     2      -7.621 -10.122  38.085  1.00 27.44           O  
ATOM     30  CB  ARG     2      -8.346 -10.374  35.215  1.00 23.92           C  
ATOM     31  CG  ARG     2      -9.347 -10.845  34.134  1.00 25.70           C  
ATOM     32  CD  ARG     2      -8.657 -11.765  33.135  1.00 25.52           C  
ATOM     33  NE  ARG     2      -7.696 -11.068  32.290  1.00 27.24           N  
ATOM     34  CZ  ARG     2      -8.028 -10.316  31.245  1.00 25.99           C  
ATOM     35  NH1 ARG     2      -7.092  -9.705  30.558  1.00 26.10           N  
ATOM     36  NH2 ARG     2      -9.305 -10.178  30.888  1.00 30.15           N  
ATOM     37  N   GLY     3      -7.404  -7.992  37.483  1.00 23.54           N  
ATOM     38  CA  GLY     3      -6.475  -7.700  38.540  1.00 21.96           C  
ATOM     39  C   GLY     3      -5.048  -7.714  38.006  1.00 20.01           C  
ATOM     40  O   GLY     3      -4.763  -8.208  36.927  1.00 19.98           O  
ATOM     41  N   PRO     4      -4.121  -7.183  38.794  1.00 18.75           N  
ATOM     42  CA  PRO     4      -2.718  -7.124  38.362  1.00 17.90           C  
ATOM     43  C   PRO     4      -2.069  -8.474  38.133  1.00 17.43           C  
ATOM     44  O   PRO     4      -2.332  -9.438  38.886  1.00 17.86           O  
ATOM     45  CB  PRO     4      -1.998  -6.462  39.555  1.00 17.83           C  
ATOM     46  CG  PRO     4      -3.078  -5.804  40.295  1.00 17.56           C  
ATOM     47  CD  PRO     4      -4.293  -6.604  40.137  1.00 20.04           C  
ATOM     48  N   GLU     5      -1.198  -8.523  37.136  1.00 16.41           N  
ATOM     49  CA  GLU     5      -0.494  -9.734  36.776  1.00 16.74           C  
ATOM     50  C   GLU     5       0.555 -10.210  37.794  1.00 15.28           C  
ATOM     51  O   GLU     5       0.894 -11.399  37.821  1.00 14.56           O  
ATOM     52  CB  GLU     5       0.179  -9.574  35.415  1.00 18.28           C  
ATOM     53  CG  GLU     5       1.357  -8.668  35.384  1.00 18.86           C  
ATOM     54  CD  GLU     5       1.641  -8.109  33.976  1.00 21.65           C  
ATOM     55  OE1 GLU     5       0.838  -7.287  33.462  1.00 19.17           O  
ATOM     56  OE2 GLU     5       2.690  -8.452  33.404  1.00 20.12           O  
ATOM     57  N   ALA     6       1.090  -9.262  38.551  1.00 14.75           N  
ATOM     58  CA  ALA     6       2.230  -9.503  39.408  1.00 12.91           C  
ATOM     59  C   ALA     6       2.286  -8.383  40.423  1.00 13.86           C  
ATOM     60  O   ALA     6       1.662  -7.340  40.252  1.00 14.07           O  
ATOM     61  CB  ALA     6       3.557  -9.555  38.607  1.00 14.41           C  
ATOM     62  N   PHE     7       3.056  -8.616  41.463  1.00 12.90           N  
ATOM     63  CA  PHE     7       3.312  -7.619  42.514  1.00 12.74           C  
ATOM     64  C   PHE     7       4.803  -7.561  42.789  1.00 14.31           C  
ATOM     65  O   PHE     7       5.426  -8.577  43.064  1.00 16.10           O  
ATOM     66  CB  PHE     7       2.558  -7.975  43.774  1.00 12.84           C  
ATOM     67  CG  PHE     7       1.061  -7.980  43.588  1.00 13.25           C  
ATOM     68  CD1 PHE     7       0.432  -9.083  43.089  1.00 12.42           C  
ATOM     69  CD2 PHE     7       0.284  -6.851  43.907  1.00 13.57           C  
ATOM     70  CE1 PHE     7      -0.949  -9.101  42.892  1.00 15.56           C  
ATOM     71  CE2 PHE     7      -1.084  -6.875  43.732  1.00 14.79           C  
ATOM     72  CZ  PHE     7      -1.682  -7.984  43.198  1.00 14.93           C  
ATOM     73  N   LEU     8       5.379  -6.378  42.730  1.00 13.78           N  
ATOM     74  CA  LEU     8       6.799  -6.166  43.031  1.00 14.87           C  
ATOM     75  C   LEU     8       6.959  -5.587  44.431  1.00 17.18           C  
ATOM     76  O   LEU     8       6.012  -5.033  45.021  1.00 18.46           O  
ATOM     77  CB  LEU     8       7.409  -5.253  41.997  1.00 14.89           C  
ATOM     78  CG  LEU     8       7.096  -5.514  40.532  1.00 15.32           C  
ATOM     79  CD1 LEU     8       7.647  -4.518  39.513  1.00 16.20           C  
ATOM     80  CD2 LEU     8       7.592  -6.945  40.214  1.00 16.59           C  
ATOM     81  N   LYS     9       8.127  -5.818  45.005  1.00 17.65           N  
ATOM     82  CA  LYS     9       8.421  -5.348  46.361  1.00 19.07           C  
ATOM     83  C   LYS     9       9.052  -3.955  46.263  1.00 17.92           C  
ATOM     84  O   LYS     9      10.150  -3.798  45.727  1.00 18.25           O  
ATOM     85  CB  LYS     9       9.373  -6.314  47.042  1.00 19.67           C  
ATOM     86  CG  LYS     9       9.591  -5.980  48.493  1.00 23.14           C  
ATOM     87  CD  LYS     9      10.639  -6.886  49.072  1.00 24.83           C  
ATOM     88  CE  LYS     9      10.121  -8.265  49.428  1.00 32.25           C  
ATOM     89  NZ  LYS     9      10.917  -8.817  50.575  1.00 34.79           N  
ATOM     90  N   LEU    10       8.369  -2.926  46.749  1.00 18.72           N  
ATOM     91  CA  LEU    10       8.826  -1.580  46.551  1.00 18.81           C  
ATOM     92  C   LEU    10       9.942  -1.228  47.554  1.00 19.68           C  
ATOM     93  O   LEU    10      10.009  -1.815  48.647  1.00 20.89           O  
ATOM     94  CB  LEU    10       7.717  -0.560  46.770  1.00 20.05           C  
ATOM     95  CG  LEU    10       6.533  -0.547  45.822  1.00 19.19           C  
ATOM     96  CD1 LEU    10       5.473   0.394  46.436  1.00 24.82           C  
ATOM     97  CD2 LEU    10       6.945  -0.115  44.440  1.00 21.53           C  
ATOM     98  N   PRO    11      10.774  -0.268  47.163  1.00 20.13           N  
ATOM     99  CA  PRO    11      11.661   0.375  48.167  1.00 21.78           C  
ATOM    100  C   PRO    11      10.838   1.323  49.071  1.00 22.52           C  
ATOM    101  O   PRO    11       9.740   1.732  48.679  1.00 23.44           O  
ATOM    102  CB  PRO    11      12.607   1.193  47.285  1.00 20.85           C  
ATOM    103  CG  PRO    11      11.779   1.545  46.072  1.00 22.93           C  
ATOM    104  CD  PRO    11      10.970   0.307  45.828  1.00 19.70           C  
ATOM    105  N   LYS    12      11.406   1.739  50.229  1.00 25.61           N  
ATOM    106  CA  LYS    12      10.808   2.820  51.069  1.00 26.86           C  
ATOM    107  C   LYS    12      10.655   4.134  50.323  1.00 28.24           C  
ATOM    108  O   LYS    12       9.621   4.815  50.414  1.00 30.07           O  
ATOM    109  CB  LYS    12      11.725   3.141  52.244  1.00 27.78           C  
ATOM    110  CG  LYS    12      11.297   2.660  53.597  1.00 29.19           C  
ATOM    111  CD  LYS    12      12.113   3.300  54.688  1.00 28.24           C  
ATOM    112  CE  LYS    12      11.543   4.613  55.215  1.00 28.46           C  
ATOM    113  NZ  LYS    12      12.177   4.939  56.553  1.00 29.49           N  
ATOM    114  N   ASP    13      11.716   4.525  49.615  1.00 29.01           N  
ATOM    115  CA  ASP    13      11.746   5.788  48.876  1.00 29.32           C  
ATOM    116  C   ASP    13      11.132   5.663  47.484  1.00 30.39           C  
ATOM    117  O   ASP    13      11.712   5.127  46.535  1.00 29.19           O  
ATOM    118  CB  ASP    13      13.189   6.371  48.893  1.00 29.16           C  
ATOM    119  CG  ASP    13      13.347   7.664  48.082  1.00 30.92           C  
ATOM    120  OD1 ASP    13      12.344   8.274  47.628  1.00 34.61           O  
ATOM    121  OD2 ASP    13      14.529   8.080  47.888  1.00 32.69           O  
ATOM    122  N   LEU    14       9.920   6.195  47.363  1.00 30.90           N  
ATOM    123  CA  LEU    14       9.172   6.157  46.124  1.00 30.71           C  
ATOM    124  C   LEU    14       9.608   7.149  45.049  1.00 30.84           C  
ATOM    125  O   LEU    14       9.020   7.178  43.964  1.00 31.55           O  
ATOM    126  CB  LEU    14       7.678   6.329  46.424  1.00 30.89           C  
ATOM    127  CG  LEU    14       7.124   5.332  47.440  1.00 30.54           C  
ATOM    128  CD1 LEU    14       5.711   5.725  47.765  1.00 33.63           C  
ATOM    129  CD2 LEU    14       7.169   3.889  46.924  1.00 35.44           C  
ATOM    130  N   LYS    15      10.614   7.983  45.348  1.00 30.72           N  
ATOM    131  CA  LYS    15      11.255   8.810  44.324  1.00 30.73           C  
ATOM    132  C   LYS    15      12.623   8.265  43.901  1.00 29.76           C  
ATOM    133  O   LYS    15      13.272   8.865  43.053  1.00 30.87           O  
ATOM    134  CB  LYS    15      11.408  10.266  44.806  1.00 32.76           C  
ATOM    135  CG  LYS    15      10.232  11.196  44.418  1.00 35.47           C  
ATOM    136  CD  LYS    15       9.079  11.039  45.367  1.00 37.91           C  
ATOM    137  CE  LYS    15       9.288  11.906  46.603  1.00 39.30           C  
ATOM    138  NZ  LYS    15       8.302  11.581  47.681  1.00 39.71           N  
ATOM    139  N   ASP    16      13.046   7.133  44.481  1.00 27.99           N  
ATOM    140  CA  ASP    16      14.328   6.493  44.094  1.00 26.78           C  
ATOM    141  C   ASP    16      14.118   5.763  42.782  1.00 25.11           C  
ATOM    142  O   ASP    16      13.741   4.600  42.764  1.00 24.88           O  
ATOM    143  CB  ASP    16      14.802   5.533  45.171  1.00 25.55           C  
ATOM    144  CG  ASP    16      16.217   4.970  44.893  1.00 26.06           C  
ATOM    145  OD1 ASP    16      16.650   5.014  43.729  1.00 25.61           O  
ATOM    146  OD2 ASP    16      16.861   4.472  45.830  1.00 25.02           O  
ATOM    147  N   ARG    17      14.360   6.449  41.680  1.00 25.11           N  
ATOM    148  CA  ARG    17      14.118   5.904  40.359  1.00 24.25           C  
ATOM    149  C   ARG    17      14.973   4.689  40.041  1.00 23.79           C  
ATOM    150  O   ARG    17      14.497   3.729  39.431  1.00 22.80           O  
ATOM    151  CB  ARG    17      14.276   6.978  39.293  1.00 26.64           C  
ATOM    152  CG  ARG    17      13.323   8.136  39.528  1.00 30.06           C  
ATOM    153  CD  ARG    17      12.985   8.820  38.245  1.00 37.41           C  
ATOM    154  NE  ARG    17      14.129   9.542  37.706  1.00 40.97           N  
ATOM    155  CZ  ARG    17      14.150  10.097  36.499  1.00 43.91           C  
ATOM    156  NH1 ARG    17      13.094   9.997  35.685  1.00 45.45           N  
ATOM    157  NH2 ARG    17      15.241  10.749  36.096  1.00 45.78           N  
ATOM    158  N   GLU    18      16.227   4.705  40.494  1.00 22.85           N  
ATOM    159  CA  GLU    18      17.123   3.549  40.277  1.00 22.70           C  
ATOM    160  C   GLU    18      16.572   2.269  40.913  1.00 20.63           C  
ATOM    161  O   GLU    18      16.555   1.211  40.278  1.00 19.78           O  
ATOM    162  CB  GLU    18      18.500   3.848  40.866  1.00 23.30           C  
ATOM    163  CG  GLU    18      19.549   2.754  40.681  1.00 24.01           C  
ATOM    164  CD  GLU    18      20.941   3.182  41.148  1.00 26.13           C  
ATOM    165  OE1 GLU    18      21.200   3.135  42.381  1.00 31.97           O  
ATOM    166  OE2 GLU    18      21.761   3.558  40.278  1.00 30.80           O  
ATOM    167  N   ALA    19      16.146   2.364  42.159  1.00 18.69           N  
ATOM    168  CA  ALA    19      15.569   1.237  42.865  1.00 18.72           C  
ATOM    169  C   ALA    19      14.286   0.741  42.184  1.00 18.42           C  
ATOM    170  O   ALA    19      14.079  -0.477  42.073  1.00 18.40           O  
ATOM    171  CB  ALA    19      15.248   1.627  44.285  1.00 19.53           C  
ATOM    172  N   LEU    20      13.438   1.683  41.764  1.00 18.86           N  
ATOM    173  CA  LEU    20      12.198   1.346  41.088  1.00 18.10           C  
ATOM    174  C   LEU    20      12.479   0.694  39.747  1.00 18.59           C  
ATOM    175  O   LEU    20      11.826  -0.289  39.383  1.00 18.02           O  
ATOM    176  CB  LEU    20      11.269   2.570  40.902  1.00 19.62           C  
ATOM    177  CG  LEU    20      10.779   3.123  42.243  1.00 19.47           C  
ATOM    178  CD1 LEU    20      10.171   4.490  42.063  1.00 25.48           C  
ATOM    179  CD2 LEU    20       9.776   2.141  42.919  1.00 20.59           C  
ATOM    180  N   GLN    21      13.439   1.212  38.971  1.00 17.08           N  
ATOM    181  CA  GLN    21      13.818   0.563  37.701  0.60 17.52           C  
ATOM    183  C   GLN    21      14.339  -0.838  37.961  1.00 17.89           C  
ATOM    184  O   GLN    21      14.076  -1.788  37.220  1.00 17.69           O  
ATOM    185  CB  GLN    21      14.943   1.338  36.986  0.60 18.21           C  
ATOM    187  CG  GLN    21      14.503   2.626  36.329  0.60 18.89           C  
ATOM    189  CD  GLN    21      13.515   2.472  35.158  0.60 20.48           C  
ATOM    191  OE1 GLN    21      13.254   1.364  34.619  0.60 23.97           O  
ATOM    193  NE2 GLN    21      12.980   3.610  34.738  0.60 22.78           N  
ATOM    195  N   ASP    22      15.104  -0.995  39.034  1.00 16.55           N  
ATOM    196  CA  ASP    22      15.680  -2.315  39.349  1.00 17.02           C  
ATOM    197  C   ASP    22      14.611  -3.356  39.634  1.00 16.63           C  
ATOM    198  O   ASP    22      14.714  -4.505  39.156  1.00 16.75           O  
ATOM    199  CB  ASP    22      16.632  -2.228  40.544  1.00 17.24           C  
ATOM    200  CG  ASP    22      18.015  -1.694  40.162  1.00 19.16           C  
ATOM    201  OD1 ASP    22      18.327  -1.439  38.960  1.00 22.10           O  
ATOM    202  OD2 ASP    22      18.789  -1.547  41.118  1.00 23.09           O  
ATOM    203  N   ILE    23      13.551  -2.982  40.363  1.00 15.22           N  
ATOM    204  CA  ILE    23      12.501  -4.017  40.667  1.00 15.44           C  
ATOM    205  C   ILE    23      11.696  -4.359  39.393  1.00 15.80           C  
ATOM    206  O   ILE    23      11.130  -5.448  39.328  1.00 16.91           O  
ATOM    207  CB  ILE    23      11.538  -3.666  41.812  1.00 14.93           C  
ATOM    208  CG1 ILE    23      10.715  -2.400  41.496  1.00 16.08           C  
ATOM    209  CG2 ILE    23      12.349  -3.420  43.109  1.00 16.92           C  
ATOM    210  CD1 ILE    23       9.662  -2.083  42.539  1.00 18.45           C  
ATOM    211  N   MET    24      11.693  -3.454  38.407  1.00 16.35           N  
ATOM    212  CA  MET    24      11.001  -3.635  37.136  1.00 16.51           C  
ATOM    213  C   MET    24      11.870  -4.256  36.047  1.00 16.28           C  
ATOM    214  O   MET    24      11.426  -4.374  34.907  1.00 16.01           O  
ATOM    215  CB  MET    24      10.471  -2.276  36.650  1.00 16.46           C  
ATOM    216  CG  MET    24       9.476  -1.622  37.540  1.00 17.64           C  
ATOM    217  SD  MET    24       8.685  -0.053  36.632  0.80 26.05          SE  
ATOM    218  CE  MET    24       7.421  -0.860  35.445  1.00 24.41           C  
ATOM    219  N   GLN    25      13.092  -4.631  36.388  1.00 16.67           N  
ATOM    220  CA  GLN    25      14.070  -4.998  35.365  1.00 17.43           C  
ATOM    221  C   GLN    25      13.592  -6.036  34.353  1.00 16.67           C  
ATOM    222  O   GLN    25      14.004  -5.969  33.198  1.00 17.33           O  
ATOM    223  CB  GLN    25      15.374  -5.433  36.005  1.00 18.09           C  
ATOM    224  CG  GLN    25      15.329  -6.698  36.777  1.00 20.57           C  
ATOM    225  CD  GLN    25      16.656  -7.030  37.461  1.00 24.40           C  
ATOM    226  OE1 GLN    25      17.683  -6.382  37.193  1.00 30.15           O  
ATOM    227  NE2 GLN    25      16.631  -8.020  38.370  1.00 29.33           N  
ATOM    228  N   ASP    26      12.790  -7.013  34.797  1.00 15.34           N  
ATOM    229  CA  ASP    26      12.390  -8.124  33.918  1.00 15.72           C  
ATOM    230  C   ASP    26      11.142  -7.834  33.073  1.00 16.03           C  
ATOM    231  O   ASP    26      10.876  -8.602  32.131  1.00 16.34           O  
ATOM    232  CB  ASP    26      12.120  -9.391  34.723  1.00 15.05           C  
ATOM    233  CG  ASP    26      13.409 -10.027  35.326  1.00 18.38           C  
ATOM    234  OD1 ASP    26      14.527  -9.715  34.833  1.00 21.09           O  
ATOM    235  OD2 ASP    26      13.261 -10.859  36.262  1.00 21.86           O  
ATOM    236  N   ILE    27      10.434  -6.762  33.392  1.00 16.05           N  
ATOM    237  CA  ILE    27       9.093  -6.467  32.882  0.60 17.18           C  
ATOM    239  C   ILE    27       9.116  -5.228  31.989  1.00 17.24           C  
ATOM    240  O   ILE    27       9.908  -4.318  32.214  1.00 16.86           O  
ATOM    241  CB  ILE    27       8.122  -6.210  34.080  0.60 17.87           C  
ATOM    243  CG1 ILE    27       8.158  -7.384  35.052  0.60 18.38           C  
ATOM    245  CG2 ILE    27       6.684  -5.914  33.601  0.60 18.73           C  
ATOM    247  CD1 ILE    27       7.986  -8.690  34.409  0.60 20.09           C  
ATOM    249  N   GLY    28       8.241  -5.184  31.003  1.00 17.82           N  
ATOM    250  CA  GLY    28       8.066  -3.945  30.257  1.00 18.09           C  
ATOM    251  C   GLY    28       9.221  -3.577  29.353  1.00 18.07           C  
ATOM    252  O   GLY    28       9.365  -2.424  28.950  1.00 18.91           O  
ATOM    253  N   ASN    29      10.036  -4.547  28.983  1.00 18.26           N  
ATOM    254  CA  ASN    29      11.290  -4.211  28.309  1.00 18.83           C  
ATOM    255  C   ASN    29      11.112  -3.765  26.859  1.00 19.92           C  
ATOM    256  O   ASN    29      12.054  -3.163  26.287  1.00 23.13           O  
ATOM    257  CB  ASN    29      12.315  -5.308  28.491  1.00 19.12           C  
ATOM    258  CG  ASN    29      12.920  -5.252  29.901  1.00 18.82           C  
ATOM    259  OD1 ASN    29      13.210  -4.141  30.417  1.00 20.59           O  
ATOM    260  ND2 ASN    29      13.068  -6.410  30.534  1.00 20.14           N  
ATOM    261  N   SER    30       9.940  -3.996  26.289  1.00 19.51           N  
ATOM    262  CA  SER    30       9.638  -3.436  24.946  1.00 19.62           C  
ATOM    263  C   SER    30       8.833  -2.162  25.064  1.00 19.59           C  
ATOM    264  O   SER    30       8.467  -1.576  24.052  1.00 20.08           O  
ATOM    265  CB  SER    30       8.915  -4.467  24.077  1.00 20.71           C  
ATOM    266  OG  SER    30       7.714  -4.851  24.696  1.00 25.23           O  
ATOM    267  N   ASP    31       8.554  -1.688  26.286  1.00 19.24           N  
ATOM    268  CA  ASP    31       7.719  -0.480  26.428  1.00 19.48           C  
ATOM    269  C   ASP    31       8.399   0.728  25.751  1.00 19.11           C  
ATOM    270  O   ASP    31       9.607   0.921  25.855  1.00 18.28           O  
ATOM    271  CB  ASP    31       7.472  -0.170  27.903  1.00 19.32           C  
ATOM    272  CG  ASP    31       6.382  -1.059  28.540  1.00 20.97           C  
ATOM    273  OD1 ASP    31       5.838  -1.957  27.861  1.00 20.12           O  
ATOM    274  OD2 ASP    31       6.130  -0.786  29.749  1.00 20.60           O  
ATOM    275  N   ASP    32       7.573   1.496  25.059  1.00 19.06           N  
ATOM    276  CA  ASP    32       7.966   2.731  24.373  1.00 20.14           C  
ATOM    277  C   ASP    32       8.776   2.490  23.102  1.00 19.79           C  
ATOM    278  O   ASP    32       9.198   3.461  22.447  1.00 19.91           O  
ATOM    279  CB  ASP    32       8.712   3.674  25.293  1.00 20.73           C  
ATOM    280  CG  ASP    32       7.963   3.948  26.635  1.00 23.39           C  
ATOM    281  OD1 ASP    32       6.803   4.403  26.542  1.00 25.24           O  
ATOM    282  OD2 ASP    32       8.564   3.719  27.723  1.00 25.94           O  
ATOM    283  N   ILE    33       8.996   1.235  22.770  1.00 19.89           N  
ATOM    284  CA  ILE    33       9.673   0.832  21.522  1.00 20.20           C  
ATOM    285  C   ILE    33       8.565   0.449  20.573  1.00 20.72           C  
ATOM    286  O   ILE    33       7.960  -0.632  20.700  1.00 22.37           O  
ATOM    287  CB  ILE    33      10.677  -0.334  21.711  1.00 19.45           C  
ATOM    288  CG1 ILE    33      11.758   0.114  22.689  1.00 21.44           C  
ATOM    289  CG2 ILE    33      11.304  -0.710  20.329  1.00 20.56           C  
ATOM    290  CD1 ILE    33      12.772  -0.956  23.051  1.00 22.94           C  
ATOM    291  N   LEU    34       8.299   1.342  19.626  1.00 19.25           N  
ATOM    292  CA  LEU    34       7.087   1.314  18.818  1.00 17.77           C  
ATOM    293  C   LEU    34       7.338   0.882  17.390  1.00 18.40           C  
ATOM    294  O   LEU    34       8.388   1.119  16.839  1.00 18.47           O  
ATOM    295  CB  LEU    34       6.469   2.701  18.781  1.00 18.47           C  
ATOM    296  CG  LEU    34       6.267   3.371  20.125  1.00 19.72           C  
ATOM    297  CD1 LEU    34       5.545   4.684  19.944  1.00 22.67           C  
ATOM    298  CD2 LEU    34       5.548   2.434  21.132  1.00 21.13           C  
ATOM    299  N   ALA    35       6.348   0.240  16.797  1.00 18.57           N  
ATOM    300  CA  ALA    35       6.435  -0.175  15.394  1.00 17.19           C  
ATOM    301  C   ALA    35       6.217   1.030  14.494  1.00 17.33           C  
ATOM    302  O   ALA    35       5.387   1.913  14.741  1.00 18.24           O  
ATOM    303  CB  ALA    35       5.390  -1.293  15.057  1.00 19.13           C  
ATOM    304  N   ALA    36       6.928   1.044  13.360  1.00 17.01           N  
ATOM    305  CA  ALA    36       6.674   2.049  12.357  1.00 15.71           C  
ATOM    306  C   ALA    36       7.034   1.462  10.990  1.00 16.78           C  
ATOM    307  O   ALA    36       7.901   0.604  10.879  1.00 18.10           O  
ATOM    308  CB  ALA    36       7.457   3.343  12.596  1.00 17.58           C  
ATOM    309  N   VAL    37       6.370   1.955   9.975  1.00 15.62           N  
ATOM    310  CA  VAL    37       6.682   1.549   8.602  0.50 15.71           C  
ATOM    312  C   VAL    37       7.312   2.714   7.873  1.00 14.23           C  
ATOM    313  O   VAL    37       6.779   3.823   7.872  1.00 15.68           O  
ATOM    314  CB  VAL    37       5.451   1.037   7.797  0.50 15.29           C  
ATOM    316  CG1 VAL    37       4.346   2.086   7.714  0.50 16.13           C  
ATOM    318  CG2 VAL    37       5.858   0.619   6.389  0.50 16.06           C  
ATOM    320  N   VAL    38       8.435   2.456   7.238  1.00 14.86           N  
ATOM    321  CA  VAL    38       9.172   3.493   6.517  1.00 14.41           C  
ATOM    322  C   VAL    38       8.438   3.924   5.239  1.00 15.45           C  
ATOM    323  O   VAL    38       7.986   3.077   4.449  1.00 14.72           O  
ATOM    324  CB  VAL    38      10.630   3.065   6.225  1.00 15.18           C  
ATOM    325  CG1 VAL    38      11.345   4.116   5.259  1.00 14.75           C  
ATOM    326  CG2 VAL    38      11.387   2.893   7.574  1.00 15.41           C  
ATOM    327  N   LEU    39       8.293   5.236   5.093  1.00 14.89           N  
ATOM    328  CA  LEU    39       7.728   5.844   3.883  1.00 15.30           C  
ATOM    329  C   LEU    39       8.802   6.367   2.923  1.00 16.16           C  
ATOM    330  O   LEU    39       8.618   6.337   1.717  1.00 17.32           O  
ATOM    331  CB  LEU    39       6.793   7.008   4.266  1.00 16.91           C  
ATOM    332  CG  LEU    39       5.696   6.599   5.252  1.00 17.60           C  
ATOM    333  CD1 LEU    39       4.796   7.809   5.545  1.00 21.11           C  
ATOM    334  CD2 LEU    39       4.876   5.379   4.818  1.00 20.56           C  
ATOM    335  N   SER    40       9.878   6.946   3.451  1.00 16.45           N  
ATOM    336  CA  SER    40      10.967   7.414   2.684  1.00 16.91           C  
ATOM    337  C   SER    40      12.241   7.291   3.490  1.00 16.85           C  
ATOM    338  O   SER    40      12.195   7.364   4.707  1.00 15.68           O  
ATOM    339  CB  SER    40      10.726   8.848   2.271  1.00 18.60           C  
ATOM    340  OG  SER    40      10.878   9.725   3.348  1.00 19.69           O  
ATOM    341  N   ALA    41      13.376   7.151   2.802  1.00 16.13           N  
ATOM    342  CA  ALA    41      14.666   7.013   3.492  1.00 16.24           C  
ATOM    343  C   ALA    41      15.808   7.516   2.678  1.00 17.06           C  
ATOM    344  O   ALA    41      15.937   7.212   1.489  1.00 17.44           O  
ATOM    345  CB  ALA    41      14.932   5.590   3.873  1.00 16.02           C  
ATOM    346  N   THR    42      16.603   8.346   3.317  1.00 17.62           N  
ATOM    347  CA  THR    42      17.909   8.824   2.826  1.00 18.26           C  
ATOM    348  C   THR    42      18.903   8.767   3.996  1.00 18.56           C  
ATOM    349  O   THR    42      18.496   8.630   5.155  1.00 16.63           O  
ATOM    350  CB  THR    42      17.820  10.268   2.317  1.00 18.38           C  
ATOM    351  OG1 THR    42      17.681  11.157   3.433  1.00 21.26           O  
ATOM    352  CG2 THR    42      16.634  10.457   1.330  1.00 21.04           C  
ATOM    353  N   PRO    43      20.207   8.983   3.741  1.00 18.87           N  
ATOM    354  CA  PRO    43      21.125   9.006   4.879  1.00 18.55           C  
ATOM    355  C   PRO    43      20.851  10.148   5.880  1.00 18.56           C  
ATOM    356  O   PRO    43      21.326  10.095   7.044  1.00 20.67           O  
ATOM    357  CB  PRO    43      22.499   9.197   4.201  1.00 19.88           C  
ATOM    358  CG  PRO    43      22.329   8.653   2.885  1.00 19.28           C  
ATOM    359  CD  PRO    43      20.938   9.070   2.467  1.00 20.45           C  
ATOM    360  N   GLY    44      20.139  11.170   5.431  1.00 16.96           N  
ATOM    361  CA  GLY    44      19.835  12.346   6.269  1.00 17.33           C  
ATOM    362  C   GLY    44      18.471  12.343   6.932  1.00 16.12           C  
ATOM    363  O   GLY    44      18.259  13.110   7.843  1.00 16.70           O  
ATOM    364  N   ALA    45      17.521  11.522   6.465  1.00 15.44           N  
ATOM    365  CA  ALA    45      16.194  11.546   7.049  1.00 16.18           C  
ATOM    366  C   ALA    45      15.409  10.293   6.680  1.00 16.57           C  
ATOM    367  O   ALA    45      15.433   9.862   5.536  1.00 16.49           O  
ATOM    368  CB  ALA    45      15.445  12.726   6.525  1.00 16.54           C  
ATOM    369  N   VAL    46      14.702   9.747   7.648  1.00 16.15           N  
ATOM    370  CA  VAL    46      13.752   8.676   7.432  1.00 15.46           C  
ATOM    371  C   VAL    46      12.395   9.193   7.901  1.00 16.21           C  
ATOM    372  O   VAL    46      12.272   9.685   9.044  1.00 15.82           O  
ATOM    373  CB  VAL    46      14.173   7.440   8.255  1.00 14.79           C  
ATOM    374  CG1 VAL    46      13.059   6.405   8.283  1.00 16.16           C  
ATOM    375  CG2 VAL    46      15.520   6.906   7.736  1.00 15.90           C  
ATOM    376  N   GLU    47      11.375   9.063   7.045  1.00 16.26           N  
ATOM    377  CA  GLU    47       9.987   9.338   7.431  1.00 17.37           C  
ATOM    378  C   GLU    47       9.318   7.985   7.648  1.00 17.25           C  
ATOM    379  O   GLU    47       9.447   7.094   6.805  1.00 16.35           O  
ATOM    380  CB  GLU    47       9.240  10.078   6.308  1.00 18.76           C  
ATOM    381  CG  GLU    47       9.768  11.459   6.058  1.00 22.56           C  
ATOM    382  CD  GLU    47       8.728  12.493   5.613  1.00 27.08           C  
ATOM    383  OE1 GLU    47       7.596  12.140   5.191  1.00 32.70           O  
ATOM    384  OE2 GLU    47       9.093  13.699   5.695  1.00 39.15           O  
ATOM    385  N   ALA    48       8.608   7.831   8.751  1.00 15.79           N  
ATOM    386  CA  ALA    48       7.954   6.581   9.088  1.00 16.62           C  
ATOM    387  C   ALA    48       6.568   6.823   9.690  1.00 16.84           C  
ATOM    388  O   ALA    48       6.358   7.839  10.370  1.00 19.46           O  
ATOM    389  CB  ALA    48       8.843   5.735  10.026  1.00 17.11           C  
ATOM    390  N   PHE    49       5.635   5.922   9.429  1.00 16.37           N  
ATOM    391  CA  PHE    49       4.267   5.991   9.929  1.00 17.59           C  
ATOM    392  C   PHE    49       4.122   5.056  11.129  1.00 18.32           C  
ATOM    393  O   PHE    49       4.501   3.899  11.058  1.00 17.79           O  
ATOM    394  CB  PHE    49       3.296   5.544   8.820  1.00 17.85           C  
ATOM    395  CG  PHE    49       1.842   5.641   9.191  1.00 18.30           C  
ATOM    396  CD1 PHE    49       1.144   6.802   8.933  1.00 21.76           C  
ATOM    397  CD2 PHE    49       1.164   4.553   9.695  1.00 20.75           C  
ATOM    398  CE1 PHE    49      -0.227   6.916   9.249  1.00 20.36           C  
ATOM    399  CE2 PHE    49      -0.206   4.656  10.047  1.00 19.72           C  
ATOM    400  CZ  PHE    49      -0.881   5.839   9.796  1.00 22.60           C  
ATOM    401  N   ARG    50       3.636   5.563  12.253  1.00 19.08           N  
ATOM    402  CA  ARG    50       3.464   4.703  13.441  1.00 20.23           C  
ATOM    403  C   ARG    50       1.972   4.382  13.686  1.00 21.07           C  
ATOM    404  O   ARG    50       1.117   4.995  13.106  1.00 20.64           O  
ATOM    405  CB  ARG    50       4.134   5.305  14.688  1.00 22.94           C  
ATOM    406  CG  ARG    50       3.763   6.662  15.046  1.00 23.31           C  
ATOM    407  CD  ARG    50       4.729   7.128  16.134  1.00 22.13           C  
ATOM    408  NE  ARG    50       4.369   8.344  16.762  1.00 24.32           N  
ATOM    409  CZ  ARG    50       3.791   8.440  17.969  1.00 23.15           C  
ATOM    410  NH1 ARG    50       3.443   7.362  18.655  1.00 26.13           N  
ATOM    411  NH2 ARG    50       3.534   9.622  18.479  1.00 24.48           N  
ATOM    412  N   LYS    51       1.701   3.437  14.570  1.00 21.95           N  
ATOM    413  CA  LYS    51       0.329   2.957  14.793  1.00 22.96           C  
ATOM    414  C   LYS    51      -0.644   4.022  15.207  1.00 23.88           C  
ATOM    415  O   LYS    51      -1.836   3.907  14.899  1.00 27.15           O  
ATOM    416  CB  LYS    51       0.344   1.884  15.880  1.00 24.30           C  
ATOM    417  CG  LYS    51       0.928   0.570  15.440  1.00 26.87           C  
ATOM    418  CD  LYS    51      -0.058  -0.226  14.582  1.00 29.44           C  
ATOM    419  CE  LYS    51      -1.205  -0.890  15.358  1.00 30.13           C  
ATOM    420  NZ  LYS    51      -1.944  -1.954  14.526  1.00 28.19           N  
ATOM    421  N   ASN    52      -0.193   5.045  15.923  1.00 23.72           N  
ATOM    422  CA  ASN    52      -1.125   6.100  16.359  1.00 24.26           C  
ATOM    423  C   ASN    52      -1.538   7.030  15.207  1.00 24.17           C  
ATOM    424  O   ASN    52      -2.323   7.978  15.409  1.00 25.42           O  
ATOM    425  CB  ASN    52      -0.554   6.871  17.558  1.00 25.03           C  
ATOM    426  CG  ASN    52       0.317   8.020  17.160  1.00 24.42           C  
ATOM    427  OD1 ASN    52       0.962   7.983  16.114  1.00 25.79           O  
ATOM    428  ND2 ASN    52       0.299   9.079  17.951  1.00 26.65           N  
ATOM    429  N   GLY    53      -1.017   6.768  14.005  1.00 23.35           N  
ATOM    430  CA  GLY    53      -1.366   7.494  12.812  1.00 23.25           C  
ATOM    431  C   GLY    53      -0.460   8.670  12.473  1.00 22.61           C  
ATOM    432  O   GLY    53      -0.703   9.373  11.499  1.00 24.10           O  
ATOM    433  N   GLU    54       0.538   8.935  13.311  1.00 22.55           N  
ATOM    434  CA  GLU    54       1.405  10.054  13.034  0.50 22.38           C  
ATOM    436  C   GLU    54       2.587   9.612  12.165  1.00 21.93           C  
ATOM    437  O   GLU    54       3.020   8.453  12.207  1.00 20.56           O  
ATOM    438  CB  GLU    54       1.816  10.735  14.347  0.50 22.86           C  
ATOM    440  CG  GLU    54       0.597  11.429  14.982  0.50 23.21           C  
ATOM    442  CD  GLU    54       0.817  12.068  16.340  0.50 25.13           C  
ATOM    444  OE1 GLU    54       1.708  11.658  17.107  0.50 26.68           O  
ATOM    446  OE2 GLU    54       0.037  12.995  16.648  0.50 28.52           O  
ATOM    448  N   THR    55       3.045  10.538  11.335  1.00 21.52           N  
ATOM    449  CA  THR    55       4.233  10.331  10.508  1.00 21.28           C  
ATOM    450  C   THR    55       5.336  11.097  11.229  1.00 21.26           C  
ATOM    451  O   THR    55       5.202  12.280  11.575  1.00 24.07           O  
ATOM    452  CB  THR    55       4.059  10.775   9.067  1.00 22.75           C  
ATOM    453  OG1 THR    55       3.020   9.997   8.430  1.00 23.47           O  
ATOM    454  CG2 THR    55       5.373  10.586   8.283  1.00 23.69           C  
ATOM    455  N   ILE    56       6.388  10.377  11.530  1.00 18.81           N  
ATOM    456  CA  ILE    56       7.560  10.946  12.221  1.00 17.71           C  
ATOM    457  C   ILE    56       8.734  11.049  11.242  1.00 16.62           C  
ATOM    458  O   ILE    56       8.769  10.351  10.240  1.00 15.72           O  
ATOM    459  CB  ILE    56       7.998  10.101  13.463  1.00 16.48           C  
ATOM    460  CG1 ILE    56       8.324   8.643  13.102  1.00 18.49           C  
ATOM    461  CG2 ILE    56       6.891  10.128  14.560  1.00 20.69           C  
ATOM    462  CD1 ILE    56       8.915   7.805  14.252  1.00 18.71           C  
ATOM    463  N   ARG    57       9.641  11.970  11.557  1.00 17.01           N  
ATOM    464  CA  ARG    57      10.857  12.170  10.790  1.00 16.90           C  
ATOM    465  C   ARG    57      12.059  11.961  11.712  1.00 18.52           C  
ATOM    466  O   ARG    57      12.203  12.700  12.712  1.00 18.30           O  
ATOM    467  CB  ARG    57      10.877  13.578  10.175  1.00 18.21           C  
ATOM    468  CG  ARG    57      11.843  13.767   9.044  1.00 22.16           C  
ATOM    469  CD  ARG    57      11.482  15.091   8.275  1.00 22.79           C  
ATOM    470  NE  ARG    57      12.260  15.266   7.076  1.00 30.28           N  
ATOM    471  CZ  ARG    57      13.426  15.885   7.007  1.00 29.98           C  
ATOM    472  NH1 ARG    57      14.012  16.421   8.094  1.00 33.28           N  
ATOM    473  NH2 ARG    57      14.032  15.957   5.829  1.00 32.68           N  
ATOM    474  N   ILE    58      12.936  11.028  11.349  1.00 15.91           N  
ATOM    475  CA  ILE    58      14.128  10.653  12.155  1.00 15.94           C  
ATOM    476  C   ILE    58      15.335  11.194  11.407  1.00 16.27           C  
ATOM    477  O   ILE    58      15.485  10.933  10.213  1.00 14.90           O  
ATOM    478  CB  ILE    58      14.242   9.140  12.377  1.00 16.25           C  
ATOM    479  CG1 ILE    58      12.926   8.623  13.001  1.00 20.10           C  
ATOM    480  CG2 ILE    58      15.455   8.775  13.294  1.00 16.57           C  
ATOM    481  CD1 ILE    58      12.483   7.265  12.468  1.00 23.93           C  
ATOM    482  N   THR    59      16.197  11.910  12.141  1.00 14.89           N  
ATOM    483  CA  THR    59      17.358  12.593  11.568  1.00 14.15           C  
ATOM    484  C   THR    59      18.504  12.573  12.586  1.00 14.35           C  
ATOM    485  O   THR    59      18.307  12.162  13.715  1.00 14.11           O  
ATOM    486  CB  THR    59      17.069  14.081  11.229  1.00 14.81           C  
ATOM    487  OG1 THR    59      16.779  14.818  12.442  1.00 13.82           O  
ATOM    488  CG2 THR    59      15.872  14.174  10.256  1.00 14.18           C  
ATOM    489  N   GLY    60      19.662  13.078  12.202  1.00 13.00           N  
ATOM    490  CA  GLY    60      20.785  13.294  13.142  1.00 14.55           C  
ATOM    491  C   GLY    60      21.076  12.078  14.032  1.00 15.23           C  
ATOM    492  O   GLY    60      21.268  10.956  13.557  1.00 15.55           O  
ATOM    493  N   ASP    61      21.107  12.333  15.323  1.00 14.66           N  
ATOM    494  CA  ASP    61      21.464  11.288  16.310  1.00 15.90           C  
ATOM    495  C   ASP    61      20.544  10.072  16.200  1.00 16.16           C  
ATOM    496  O   ASP    61      20.988   8.929  16.399  1.00 16.88           O  
ATOM    497  CB  ASP    61      21.390  11.842  17.714  1.00 16.78           C  
ATOM    498  CG  ASP    61      22.453  12.862  18.020  1.00 19.80           C  
ATOM    499  OD1 ASP    61      23.417  13.063  17.234  1.00 23.93           O  
ATOM    500  OD2 ASP    61      22.320  13.459  19.136  1.00 27.40           O  
ATOM    501  N   GLY    62      19.269  10.299  15.862  1.00 13.92           N  
ATOM    502  CA  GLY    62      18.296   9.222  15.746  1.00 15.21           C  
ATOM    503  C   GLY    62      18.607   8.184  14.692  1.00 15.36           C  
ATOM    504  O   GLY    62      18.053   7.093  14.739  1.00 16.47           O  
ATOM    505  N   LEU    63      19.447   8.530  13.705  1.00 15.12           N  
ATOM    506  CA  LEU    63      19.813   7.633  12.637  1.00 14.66           C  
ATOM    507  C   LEU    63      21.161   6.929  12.860  1.00 16.62           C  
ATOM    508  O   LEU    63      21.553   6.092  12.067  1.00 17.65           O  
ATOM    509  CB  LEU    63      19.895   8.412  11.307  1.00 14.91           C  
ATOM    510  CG  LEU    63      18.610   9.028  10.816  1.00 14.93           C  
ATOM    511  CD1 LEU    63      18.872   9.730   9.475  1.00 16.30           C  
ATOM    512  CD2 LEU    63      17.484   7.995  10.686  1.00 15.68           C  
ATOM    513  N   LYS    64      21.879   7.292  13.912  1.00 15.36           N  
ATOM    514  CA  LYS    64      23.251   6.825  14.127  0.50 17.84           C  
ATOM    516  C   LYS    64      23.350   5.313  14.202  1.00 17.93           C  
ATOM    517  O   LYS    64      24.201   4.683  13.539  1.00 18.87           O  
ATOM    518  CB  LYS    64      23.803   7.419  15.421  0.50 18.24           C  
ATOM    520  CG  LYS    64      24.118   8.919  15.346  0.50 18.90           C  
ATOM    522  CD  LYS    64      24.682   9.481  16.677  0.50 21.52           C  
ATOM    524  CE  LYS    64      26.140   9.169  16.864  0.50 25.23           C  
ATOM    526  NZ  LYS    64      26.990   9.892  15.880  0.50 27.58           N  
ATOM    528  N   ALA    65      22.489   4.723  15.032  1.00 19.45           N  
ATOM    529  CA  ALA    65      22.573   3.266  15.255  1.00 19.45           C  
ATOM    530  C   ALA    65      22.318   2.519  13.970  1.00 20.13           C  
ATOM    531  O   ALA    65      22.956   1.506  13.706  1.00 21.80           O  
ATOM    532  CB  ALA    65      21.609   2.832  16.300  1.00 20.20           C  
ATOM    533  N   ALA    66      21.444   3.053  13.127  1.00 19.24           N  
ATOM    534  CA  ALA    66      21.020   2.427  11.875  1.00 20.12           C  
ATOM    535  C   ALA    66      21.899   2.739  10.641  1.00 20.14           C  
ATOM    536  O   ALA    66      21.545   2.431   9.497  1.00 19.93           O  
ATOM    537  CB  ALA    66      19.537   2.784  11.608  1.00 19.17           C  
ATOM    538  N   HIS    67      23.032   3.414  10.876  1.00 20.96           N  
ATOM    539  CA  HIS    67      23.874   3.973   9.798  1.00 22.50           C  
ATOM    540  C   HIS    67      24.131   3.057   8.595  1.00 22.69           C  
ATOM    541  O   HIS    67      23.989   3.483   7.437  1.00 23.41           O  
ATOM    542  CB  HIS    67      25.197   4.541  10.372  1.00 23.45           C  
ATOM    543  CG  HIS    67      26.126   3.542  11.028  1.00 26.82           C  
ATOM    544  ND1 HIS    67      25.899   2.978  12.266  1.00 32.13           N  
ATOM    545  CD2 HIS    67      27.348   3.080  10.635  1.00 30.02           C  
ATOM    546  CE1 HIS    67      26.898   2.169  12.582  1.00 33.51           C  
ATOM    547  NE2 HIS    67      27.792   2.218  11.610  1.00 33.86           N  
ATOM    548  N   ARG    68      24.408   1.803   8.879  1.00 23.67           N  
ATOM    549  CA  ARG    68      24.853   0.871   7.842  1.00 25.02           C  
ATOM    550  C   ARG    68      23.705   0.512   6.938  1.00 22.30           C  
ATOM    551  O   ARG    68      23.901   0.185   5.787  1.00 22.56           O  
ATOM    552  CB  ARG    68      25.434  -0.344   8.498  1.00 24.82           C  
ATOM    553  CG  ARG    68      26.707   0.042   9.249  1.00 30.85           C  
ATOM    554  CD  ARG    68      27.251  -1.030  10.152  1.00 31.45           C  
ATOM    555  NE  ARG    68      27.030  -2.400   9.701  1.00 37.79           N  
ATOM    556  CZ  ARG    68      27.584  -2.962   8.632  1.00 38.95           C  
ATOM    557  NH1 ARG    68      28.387  -2.272   7.823  1.00 41.74           N  
ATOM    558  NH2 ARG    68      27.322  -4.240   8.369  1.00 39.77           N  
ATOM    559  N   PHE    69      22.504   0.595   7.497  1.00 19.79           N  
ATOM    560  CA  PHE    69      21.286   0.350   6.733  1.00 19.43           C  
ATOM    561  C   PHE    69      20.734   1.541   5.979  1.00 19.65           C  
ATOM    562  O   PHE    69      19.701   1.423   5.340  1.00 19.12           O  
ATOM    563  CB  PHE    69      20.253  -0.281   7.668  1.00 18.19           C  
ATOM    564  CG  PHE    69      20.676  -1.645   8.125  1.00 18.08           C  
ATOM    565  CD1 PHE    69      21.572  -1.808   9.173  1.00 20.24           C  
ATOM    566  CD2 PHE    69      20.239  -2.769   7.441  1.00 18.30           C  
ATOM    567  CE1 PHE    69      21.988  -3.089   9.532  1.00 18.89           C  
ATOM    568  CE2 PHE    69      20.661  -4.045   7.806  1.00 20.19           C  
ATOM    569  CZ  PHE    69      21.524  -4.186   8.845  1.00 19.83           C  
ATOM    570  N   LEU    70      21.457   2.669   6.005  1.00 20.27           N  
ATOM    571  CA  LEU    70      21.095   3.866   5.245  1.00 22.90           C  
ATOM    572  C   LEU    70      22.208   4.335   4.308  1.00 25.29           C  
ATOM    573  O   LEU    70      22.002   5.257   3.520  1.00 26.73           O  
ATOM    574  CB  LEU    70      20.781   5.012   6.233  1.00 23.31           C  
ATOM    575  CG  LEU    70      19.562   4.755   7.119  1.00 21.31           C  
ATOM    576  CD1 LEU    70      19.661   5.653   8.378  1.00 24.18           C  
ATOM    577  CD2 LEU    70      18.328   5.018   6.305  1.00 20.23           C  
ATOM    578  N   SER    71      23.353   3.653   4.356  1.00 26.45           N  
ATOM    579  CA  SER    71      24.587   4.095   3.688  1.00 27.55           C  
ATOM    580  C   SER    71      24.781   3.559   2.280  1.00 28.74           C  
ATOM    581  O   SER    71      25.758   3.970   1.601  1.00 29.80           O  
ATOM    582  CB  SER    71      25.772   3.565   4.472  1.00 28.48           C  
ATOM    583  OG  SER    71      25.814   2.132   4.350  1.00 29.58           O  
ATOM    584  N   ASN    72      23.919   2.637   1.840  1.00 27.09           N  
ATOM    585  CA  ASN    72      24.109   1.939   0.546  0.50 27.05           C  
ATOM    587  C   ASN    72      25.380   1.091   0.533  1.00 26.48           C  
ATOM    588  O   ASN    72      25.998   0.890  -0.495  1.00 25.99           O  
ATOM    589  CB  ASN    72      24.106   2.893  -0.675  0.50 27.83           C  
ATOM    591  CG  ASN    72      22.703   3.159  -1.234  0.50 28.59           C  
ATOM    593  OD1 ASN    72      21.791   2.300  -1.198  0.50 32.27           O  
ATOM    595  ND2 ASN    72      22.528   4.359  -1.773  0.50 29.54           N  
ATOM    597  N   ASP    73      25.749   0.542   1.686  1.00 25.43           N  
ATOM    598  CA  ASP    73      26.875  -0.421   1.798  1.00 24.74           C  
ATOM    599  C   ASP    73      26.488  -1.639   0.942  1.00 23.75           C  
ATOM    600  O   ASP    73      25.420  -2.208   1.157  1.00 20.54           O  
ATOM    601  CB  ASP    73      27.027  -0.835   3.265  1.00 25.17           C  
ATOM    602  CG  ASP    73      28.020  -1.980   3.495  1.00 26.12           C  
ATOM    603  OD1 ASP    73      28.691  -2.475   2.569  1.00 30.99           O  
ATOM    604  OD2 ASP    73      28.101  -2.401   4.667  1.00 35.81           O  
ATOM    605  N   PRO    74      27.323  -2.022  -0.030  1.00 23.57           N  
ATOM    606  CA  PRO    74      26.905  -3.122  -0.921  1.00 24.30           C  
ATOM    607  C   PRO    74      26.670  -4.459  -0.231  1.00 24.84           C  
ATOM    608  O   PRO    74      25.870  -5.256  -0.709  1.00 26.45           O  
ATOM    609  CB  PRO    74      28.062  -3.203  -1.942  1.00 23.95           C  
ATOM    610  CG  PRO    74      28.658  -1.821  -1.905  1.00 24.58           C  
ATOM    611  CD  PRO    74      28.629  -1.482  -0.450  1.00 24.00           C  
ATOM    612  N   LYS    75      27.332  -4.708   0.891  1.00 25.11           N  
ATOM    613  CA  LYS    75      27.130  -5.948   1.623  1.00 26.59           C  
ATOM    614  C   LYS    75      25.736  -6.045   2.221  1.00 25.93           C  
ATOM    615  O   LYS    75      25.200  -7.135   2.361  1.00 27.46           O  
ATOM    616  CB  LYS    75      28.133  -6.079   2.757  1.00 27.40           C  
ATOM    617  CG  LYS    75      29.571  -6.266   2.291  1.00 30.20           C  
ATOM    618  CD  LYS    75      30.541  -6.071   3.457  1.00 30.42           C  
ATOM    619  CE  LYS    75      31.984  -6.045   2.995  1.00 33.03           C  
ATOM    620  NZ  LYS    75      32.892  -6.078   4.194  1.00 35.70           N  
ATOM    621  N   ILE    76      25.166  -4.913   2.601  1.00 23.73           N  
ATOM    622  CA  ILE    76      23.809  -4.916   3.141  1.00 23.46           C  
ATOM    623  C   ILE    76      22.796  -5.053   1.994  1.00 22.14           C  
ATOM    624  O   ILE    76      21.798  -5.755   2.127  1.00 20.70           O  
ATOM    625  CB  ILE    76      23.584  -3.686   4.022  1.00 24.00           C  
ATOM    626  CG1 ILE    76      24.357  -3.908   5.328  1.00 27.47           C  
ATOM    627  CG2 ILE    76      22.078  -3.476   4.336  1.00 23.08           C  
ATOM    628  CD1 ILE    76      24.772  -2.697   5.964  1.00 30.61           C  
ATOM    629  N   GLY    77      23.054  -4.389   0.872  1.00 21.67           N  
ATOM    630  CA  GLY    77      22.162  -4.511  -0.299  1.00 23.17           C  
ATOM    631  C   GLY    77      20.722  -4.151   0.019  1.00 23.16           C  
ATOM    632  O   GLY    77      20.499  -3.202   0.757  1.00 21.68           O  
ATOM    633  N   GLU    78      19.732  -4.918  -0.484  1.00 23.84           N  
ATOM    634  CA  GLU    78      18.312  -4.590  -0.222  1.00 24.68           C  
ATOM    635  C   GLU    78      17.813  -4.974   1.181  1.00 24.33           C  
ATOM    636  O   GLU    78      16.629  -4.789   1.473  1.00 25.22           O  
ATOM    637  CB  GLU    78      17.364  -5.168  -1.302  1.00 26.64           C  
ATOM    638  CG  GLU    78      17.418  -4.480  -2.675  1.00 29.65           C  
ATOM    639  CD  GLU    78      16.578  -3.175  -2.782  1.00 33.89           C  
ATOM    640  OE1 GLU    78      15.333  -3.239  -3.075  1.00 31.41           O  
ATOM    641  OE2 GLU    78      17.177  -2.079  -2.589  1.00 40.88           O  
ATOM    642  N   LYS    79      18.700  -5.410   2.079  1.00 22.93           N  
ATOM    643  CA  LYS    79      18.361  -5.427   3.493  1.00 23.03           C  
ATOM    644  C   LYS    79      18.274  -4.017   4.070  1.00 20.63           C  
ATOM    645  O   LYS    79      17.859  -3.837   5.206  1.00 20.01           O  
ATOM    646  CB  LYS    79      19.393  -6.225   4.292  1.00 23.69           C  
ATOM    647  CG  LYS    79      19.299  -7.709   3.999  1.00 26.92           C  
ATOM    648  CD  LYS    79      20.379  -8.489   4.748  1.00 28.53           C  
ATOM    649  CE  LYS    79      20.377  -9.959   4.320  1.00 31.81           C  
ATOM    650  NZ  LYS    79      21.343 -10.239   3.217  1.00 34.09           N  
ATOM    651  N   ARG    80      18.704  -3.024   3.298  1.00 21.12           N  
ATOM    652  CA  ARG    80      18.705  -1.639   3.757  1.00 20.87           C  
ATOM    653  C   ARG    80      17.293  -1.138   4.068  1.00 19.89           C  
ATOM    654  O   ARG    80      16.315  -1.671   3.561  1.00 20.87           O  
ATOM    655  CB  ARG    80      19.366  -0.719   2.751  1.00 21.02           C  
ATOM    656  CG  ARG    80      18.562  -0.475   1.551  1.00 22.63           C  
ATOM    657  CD  ARG    80      19.314   0.371   0.508  1.00 25.39           C  
ATOM    658  NE  ARG    80      18.437   0.440  -0.642  1.00 29.73           N  
ATOM    659  CZ  ARG    80      17.483   1.357  -0.864  1.00 32.12           C  
ATOM    660  NH1 ARG    80      17.229   2.386  -0.014  1.00 34.12           N  
ATOM    661  NH2 ARG    80      16.751   1.230  -1.965  1.00 29.96           N  
ATOM    662  N   ILE    81      17.237  -0.105   4.874  1.00 18.86           N  
ATOM    663  CA  ILE    81      15.997   0.629   5.137  1.00 18.98           C  
ATOM    664  C   ILE    81      15.544   1.319   3.844  1.00 19.21           C  
ATOM    665  O   ILE    81      16.338   2.004   3.173  1.00 21.40           O  
ATOM    666  CB  ILE    81      16.197   1.625   6.256  1.00 19.16           C  
ATOM    667  CG1 ILE    81      16.408   0.857   7.574  1.00 18.53           C  
ATOM    668  CG2 ILE    81      15.006   2.601   6.364  1.00 19.73           C  
ATOM    669  CD1 ILE    81      17.055   1.628   8.701  1.00 20.65           C  
ATOM    670  N   ARG    82      14.274   1.128   3.504  1.00 18.22           N  
ATOM    671  CA  ARG    82      13.688   1.557   2.209  0.50 17.65           C  
ATOM    673  C   ARG    82      12.182   1.643   2.425  1.00 17.73           C  
ATOM    674  O   ARG    82      11.660   1.090   3.399  1.00 16.98           O  
ATOM    675  CB  ARG    82      14.008   0.561   1.075  0.50 18.23           C  
ATOM    677  CG  ARG    82      13.015  -0.649   0.888  0.50 16.80           C  
ATOM    679  CD  ARG    82      13.220  -1.403  -0.465  0.50 17.15           C  
ATOM    681  NE  ARG    82      12.162  -2.396  -0.723  0.50 17.23           N  
ATOM    683  CZ  ARG    82      12.274  -3.709  -0.531  0.50 15.45           C  
ATOM    685  NH1 ARG    82      13.430  -4.257  -0.164  0.50 15.77           N  
ATOM    687  NH2 ARG    82      11.228  -4.497  -0.780  0.50 15.69           N  
ATOM    689  N   PRO    83      11.445   2.300   1.510  1.00 17.33           N  
ATOM    690  CA  PRO    83      10.002   2.307   1.757  1.00 16.91           C  
ATOM    691  C   PRO    83       9.361   0.934   1.945  1.00 16.61           C  
ATOM    692  O   PRO    83       9.564   0.019   1.119  1.00 17.77           O  
ATOM    693  CB  PRO    83       9.439   3.036   0.539  1.00 17.58           C  
ATOM    694  CG  PRO    83      10.548   3.837   0.051  1.00 16.41           C  
ATOM    695  CD  PRO    83      11.804   3.087   0.325  1.00 17.89           C  
ATOM    696  N   GLY    84       8.588   0.809   3.007  1.00 14.86           N  
ATOM    697  CA  GLY    84       7.959  -0.434   3.420  1.00 15.67           C  
ATOM    698  C   GLY    84       8.674  -1.152   4.541  1.00 15.52           C  
ATOM    699  O   GLY    84       8.121  -2.067   5.126  1.00 17.23           O  
ATOM    700  N   ALA    85       9.898  -0.737   4.843  1.00 15.34           N  
ATOM    701  CA  ALA    85      10.636  -1.389   5.913  1.00 15.80           C  
ATOM    702  C   ALA    85       9.875  -1.233   7.211  1.00 15.88           C  
ATOM    703  O   ALA    85       9.489  -0.137   7.570  1.00 16.97           O  
ATOM    704  CB  ALA    85      12.004  -0.790   6.026  1.00 15.08           C  
ATOM    705  N   LEU    86       9.720  -2.344   7.924  1.00 18.25           N  
ATOM    706  CA  LEU    86       9.190  -2.359   9.282  1.00 17.93           C  
ATOM    707  C   LEU    86      10.353  -2.152  10.253  1.00 18.43           C  
ATOM    708  O   LEU    86      11.299  -2.955  10.332  1.00 18.46           O  
ATOM    709  CB  LEU    86       8.472  -3.697   9.575  1.00 18.48           C  
ATOM    710  CG  LEU    86       7.905  -3.859  10.985  1.00 20.15           C  
ATOM    711  CD1 LEU    86       6.882  -2.777  11.316  1.00 23.23           C  
ATOM    712  CD2 LEU    86       7.327  -5.271  11.129  1.00 20.48           C  
ATOM    713  N   ILE    87      10.281  -1.045  10.979  1.00 17.40           N  
ATOM    714  CA  ILE    87      11.304  -0.664  11.971  1.00 17.79           C  
ATOM    715  C   ILE    87      10.691  -0.466  13.315  1.00 16.97           C  
ATOM    716  O   ILE    87       9.466  -0.472  13.474  1.00 18.03           O  
ATOM    717  CB  ILE    87      12.079   0.611  11.522  1.00 16.69           C  
ATOM    718  CG1 ILE    87      11.141   1.799  11.307  1.00 17.19           C  
ATOM    719  CG2 ILE    87      12.872   0.270  10.190  1.00 18.98           C  
ATOM    720  CD1 ILE    87      11.823   3.133  11.188  1.00 18.86           C  
ATOM    721  N   ARG    88      11.546  -0.259  14.292  1.00 16.37           N  
ATOM    722  CA  ARG    88      11.104   0.101  15.626  1.00 15.89           C  
ATOM    723  C   ARG    88      11.725   1.441  15.956  1.00 16.06           C  
ATOM    724  O   ARG    88      12.890   1.704  15.645  1.00 15.92           O  
ATOM    725  CB  ARG    88      11.551  -0.950  16.656  1.00 16.91           C  
ATOM    726  CG  ARG    88      11.052  -2.363  16.313  1.00 19.48           C  
ATOM    727  CD  ARG    88       9.563  -2.596  16.597  1.00 22.43           C  
ATOM    728  NE  ARG    88       9.195  -3.877  16.014  1.00 25.15           N  
ATOM    729  CZ  ARG    88       8.005  -4.465  16.140  1.00 24.03           C  
ATOM    730  NH1 ARG    88       7.064  -3.921  16.884  1.00 22.87           N  
ATOM    731  NH2 ARG    88       7.794  -5.626  15.506  1.00 26.11           N  
ATOM    732  N   VAL    89      10.947   2.244  16.646  1.00 16.11           N  
ATOM    733  CA  VAL    89      11.362   3.602  17.021  1.00 15.28           C  
ATOM    734  C   VAL    89      11.067   3.919  18.472  1.00 16.66           C  
ATOM    735  O   VAL    89      10.122   3.363  19.062  1.00 17.18           O  
ATOM    736  CB  VAL    89      10.672   4.637  16.105  1.00 15.17           C  
ATOM    737  CG1 VAL    89      11.089   4.396  14.673  1.00 16.98           C  
ATOM    738  CG2 VAL    89       9.155   4.521  16.206  1.00 17.06           C  
ATOM    739  N   LYS    90      11.848   4.847  19.017  1.00 16.96           N  
ATOM    740  CA  LYS    90      11.616   5.305  20.380  1.00 17.78           C  
ATOM    741  C   LYS    90      11.880   6.822  20.433  1.00 18.76           C  
ATOM    742  O   LYS    90      12.876   7.285  19.874  1.00 18.51           O  
ATOM    743  CB  LYS    90      12.577   4.566  21.301  1.00 18.95           C  
ATOM    744  CG  LYS    90      12.395   4.805  22.797  1.00 19.52           C  
ATOM    745  CD  LYS    90      13.376   3.969  23.591  1.00 22.77           C  
ATOM    746  CE  LYS    90      13.408   4.296  25.059  1.00 29.12           C  
ATOM    747  NZ  LYS    90      12.162   4.691  25.679  1.00 35.66           N  
ATOM    748  N   LYS    91      11.107   7.510  21.260  1.00 18.93           N  
ATOM    749  CA  LYS    91      11.228   8.949  21.424  1.00 19.03           C  
ATOM    750  C   LYS    91      12.187   9.212  22.587  1.00 19.84           C  
ATOM    751  O   LYS    91      11.983   8.683  23.701  1.00 20.14           O  
ATOM    752  CB  LYS    91       9.854   9.552  21.671  1.00 19.81           C  
ATOM    753  CG  LYS    91       9.830  11.072  21.577  1.00 20.93           C  
ATOM    754  CD  LYS    91       8.439  11.593  21.854  1.00 23.85           C  
ATOM    755  CE  LYS    91       8.249  13.016  21.413  1.00 30.64           C  
ATOM    756  NZ  LYS    91       6.944  13.499  21.917  1.00 34.58           N  
ATOM    757  N   THR    92      13.230   9.996  22.360  1.00 19.44           N  
ATOM    758  CA  THR    92      14.153  10.312  23.424  1.00 19.60           C  
ATOM    759  C   THR    92      13.562  11.349  24.389  1.00 18.84           C  
ATOM    760  O   THR    92      12.549  11.999  24.103  1.00 18.25           O  
ATOM    761  CB  THR    92      15.444  10.856  22.895  1.00 19.73           C  
ATOM    762  OG1 THR    92      15.176  12.183  22.388  1.00 21.01           O  
ATOM    763  CG2 THR    92      16.053   9.941  21.791  1.00 19.35           C  
ATOM    764  N   GLU    93      14.205  11.539  25.548  0.50 20.13           N  
ATOM    766  CA  GLU    93      13.705  12.522  26.511  0.50 20.76           C  
ATOM    768  C   GLU    93      13.826  13.956  25.987  0.50 19.67           C  
ATOM    770  O   GLU    93      13.197  14.874  26.521  0.50 19.80           O  
ATOM    772  CB  GLU    93      14.469  12.430  27.835  0.50 21.32           C  
ATOM    774  CG  GLU    93      14.239  11.166  28.623  0.50 23.98           C  
ATOM    776  CD  GLU    93      15.125  11.081  29.854  0.50 24.53           C  
ATOM    778  OE1 GLU    93      15.518   9.957  30.231  0.50 30.98           O  
ATOM    780  OE2 GLU    93      15.430  12.143  30.451  0.50 29.16           O  
ATOM    782  N   LYS    94      14.686  14.166  25.000  1.00 19.01           N  
ATOM    783  CA  LYS    94      14.783  15.473  24.385  1.00 18.39           C  
ATOM    784  C   LYS    94      13.725  15.668  23.293  1.00 16.81           C  
ATOM    785  O   LYS    94      13.533  16.802  22.866  1.00 18.00           O  
ATOM    786  CB  LYS    94      16.183  15.730  23.832  1.00 19.18           C  
ATOM    787  CG  LYS    94      17.248  15.787  24.880  1.00 21.72           C  
ATOM    788  CD  LYS    94      18.600  15.805  24.281  1.00 23.57           C  
ATOM    789  CE  LYS    94      19.662  15.916  25.368  1.00 26.08           C  
ATOM    790  NZ  LYS    94      21.041  15.663  24.797  1.00 29.86           N  
ATOM    791  N   GLY    95      13.022  14.605  22.914  1.00 16.22           N  
ATOM    792  CA  GLY    95      11.841  14.750  22.040  1.00 16.18           C  
ATOM    793  C   GLY    95      11.987  14.255  20.618  1.00 16.84           C  
ATOM    794  O   GLY    95      11.006  14.237  19.886  1.00 17.83           O  
ATOM    795  N   SER    96      13.182  13.851  20.222  1.00 16.29           N  
ATOM    796  CA  SER    96      13.410  13.388  18.856  1.00 15.32           C  
ATOM    797  C   SER    96      13.264  11.874  18.837  1.00 16.22           C  
ATOM    798  O   SER    96      13.576  11.174  19.825  1.00 15.94           O  
ATOM    799  CB  SER    96      14.825  13.781  18.368  1.00 15.41           C  
ATOM    800  OG  SER    96      15.042  15.172  18.223  1.00 17.04           O  
ATOM    801  N   TRP    97      12.799  11.328  17.709  1.00 15.27           N  
ATOM    802  CA  TRP    97      12.673   9.906  17.534  1.00 15.15           C  
ATOM    803  C   TRP    97      13.984   9.306  17.090  1.00 15.23           C  
ATOM    804  O   TRP    97      14.751   9.940  16.370  1.00 15.34           O  
ATOM    805  CB  TRP    97      11.574   9.586  16.500  1.00 16.75           C  
ATOM    806  CG  TRP    97      10.188   9.910  17.049  1.00 17.02           C  
ATOM    807  CD1 TRP    97       9.539  11.094  16.962  1.00 19.56           C  
ATOM    808  CD2 TRP    97       9.317   9.038  17.788  1.00 17.19           C  
ATOM    809  NE1 TRP    97       8.330  11.038  17.621  1.00 18.92           N  
ATOM    810  CE2 TRP    97       8.159   9.773  18.106  1.00 19.29           C  
ATOM    811  CE3 TRP    97       9.412   7.721  18.226  1.00 18.37           C  
ATOM    812  CZ2 TRP    97       7.109   9.234  18.854  1.00 20.16           C  
ATOM    813  CZ3 TRP    97       8.337   7.178  18.931  1.00 17.75           C  
ATOM    814  CH2 TRP    97       7.222   7.945  19.254  1.00 19.63           C  
ATOM    815  N   GLN    98      14.221   8.054  17.494  1.00 15.53           N  
ATOM    816  CA  GLN    98      15.374   7.289  17.078  0.50 15.84           C  
ATOM    818  C   GLN    98      14.962   5.908  16.599  1.00 15.82           C  
ATOM    819  O   GLN    98      13.994   5.322  17.111  1.00 16.55           O  
ATOM    820  CB  GLN    98      16.352   7.171  18.259  0.50 16.46           C  
ATOM    822  CG  GLN    98      15.755   6.389  19.416  0.50 17.45           C  
ATOM    824  CD  GLN    98      16.493   6.471  20.731  0.50 18.58           C  
ATOM    826  OE1 GLN    98      15.872   6.257  21.781  0.50 19.21           O  
ATOM    828  NE2 GLN    98      17.791   6.726  20.694  0.50 20.26           N  
ATOM    830  N   ILE    99      15.703   5.374  15.626  1.00 15.21           N  
ATOM    831  CA  ILE    99      15.526   3.998  15.150  1.00 15.51           C  
ATOM    832  C   ILE    99      16.314   3.078  16.081  1.00 16.61           C  
ATOM    833  O   ILE    99      17.548   3.215  16.279  1.00 16.58           O  
ATOM    834  CB  ILE    99      15.998   3.819  13.727  1.00 16.25           C  
ATOM    835  CG1 ILE    99      15.225   4.730  12.764  1.00 16.91           C  
ATOM    836  CG2 ILE    99      15.907   2.332  13.370  1.00 18.24           C  
ATOM    837  CD1 ILE    99      15.645   4.639  11.292  1.00 16.52           C  
ATOM    838  N   VAL   100      15.562   2.173  16.680  1.00 17.39           N  
ATOM    839  CA  VAL   100      16.095   1.202  17.630  1.00 18.63           C  
ATOM    840  C   VAL   100      15.672  -0.230  17.234  1.00 19.15           C  
ATOM    841  O   VAL   100      15.194  -0.468  16.147  1.00 17.97           O  
ATOM    842  CB  VAL   100      15.581   1.541  19.043  1.00 18.73           C  
ATOM    843  CG1 VAL   100      16.085   2.916  19.465  1.00 18.33           C  
ATOM    844  CG2 VAL   100      14.053   1.456  19.153  1.00 21.54           C  
ATOM    845  N   GLN   101      15.841  -1.182  18.141  1.00 21.54           N  
ATOM    846  CA  GLN   101      15.350  -2.538  17.848  1.00 22.47           C  
ATOM    847  C   GLN   101      14.877  -3.189  19.126  1.00 23.43           C  
ATOM    848  O   GLN   101      15.243  -2.736  20.207  1.00 23.82           O  
ATOM    849  CB  GLN   101      16.395  -3.345  17.139  1.00 23.76           C  
ATOM    850  CG  GLN   101      17.643  -3.604  17.930  1.00 23.42           C  
ATOM    851  CD  GLN   101      18.756  -4.193  17.109  1.00 24.69           C  
ATOM    852  OE1 GLN   101      18.587  -4.586  15.951  1.00 25.77           O  
ATOM    853  NE2 GLN   101      19.941  -4.248  17.713  1.00 30.47           N  
ATOM    854  N   LEU   102      14.003  -4.177  19.000  1.00 25.80           N  
ATOM    855  CA  LEU   102      13.433  -4.833  20.175  1.00 29.29           C  
ATOM    856  C   LEU   102      14.548  -5.593  20.875  1.00 30.90           C  
ATOM    857  O   LEU   102      15.441  -6.127  20.212  1.00 30.78           O  
ATOM    858  CB  LEU   102      12.266  -5.755  19.791  1.00 29.31           C  
ATOM    859  CG  LEU   102      10.972  -5.020  19.413  1.00 30.58           C  
ATOM    860  CD1 LEU   102       9.988  -5.946  18.738  1.00 31.16           C  
ATOM    861  CD2 LEU   102      10.360  -4.260  20.587  1.00 31.70           C  
ATOM    862  N   PRO   103      14.502  -5.653  22.228  1.00 32.79           N  
ATOM    863  CA  PRO   103      15.587  -6.344  22.947  1.00 33.77           C  
ATOM    864  C   PRO   103      15.589  -7.835  22.604  1.00 35.69           C  
ATOM    865  O   PRO   103      14.522  -8.422  22.400  1.00 36.77           O  
ATOM    866  CB  PRO   103      15.235  -6.128  24.423  1.00 34.74           C  
ATOM    867  CG  PRO   103      13.758  -5.776  24.444  1.00 34.13           C  
ATOM    868  CD  PRO   103      13.465  -5.114  23.135  1.00 33.44           C  
ATOM    869  OXT PRO   103      16.642  -8.473  22.459  1.00 37.09           O  
END
