
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 (  978),  selected  124 , name 2msp_F
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 2msp_F.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     3_F      -       -           -
LGA    V     4_F      -       -           -
LGA    P     5_F      E     267           #
LGA    -       -      D     268           -
LGA    -       -      L     269           -
LGA    P     6_F      L     270          4.920
LGA    -       -      R     271           -
LGA    -       -      P     272           -
LGA    -       -      F     273           -
LGA    G     7_F      F     274          3.608
LGA    D     8_F      E     275          3.328
LGA    -       -      K     276           -
LGA    -       -      C     277           -
LGA    I     9_F      V     278          1.445
LGA    N    10_F      K     279          1.700
LGA    T    11_F      I     280          0.817
LGA    Q    12_F      E     281          1.327
LGA    P    13_F      E     282          1.998
LGA    G    14_F      V     283           -
LGA    S    15_F      -       -           -
LGA    K    16_F      -       -           -
LGA    I    17_F      S     284           #
LGA    V    18_F      R     285          5.476
LGA    F    19_F      N     286          4.917
LGA    N    20_F      E     287          4.586
LGA    A    21_F      -       -           -
LGA    P    22_F      -       -           -
LGA    Y    23_F      -       -           -
LGA    D    24_F      -       -           -
LGA    D    25_F      -       -           -
LGA    K    26_F      -       -           -
LGA    H    27_F      Q     288          1.547
LGA    T    28_F      G     289          4.259
LGA    Y    29_F      V     290          2.878
LGA    H    30_F      T     291          1.493
LGA    I    31_F      L     292          1.682
LGA    K    32_F      S     293          1.567
LGA    I    33_F      I     294          1.744
LGA    T    34_F      T     295          1.749
LGA    N    35_F      N     296          1.431
LGA    A    36_F      V     297          2.703
LGA    G    37_F      T     298          3.245
LGA    G    38_F      D     299          3.049
LGA    R    39_F      L     300          1.304
LGA    R    40_F      V     301          1.089
LGA    I    41_F      L     302          1.225
LGA    G    42_F      K     303          0.401
LGA    W    43_F      L     304          0.984
LGA    A    44_F      K     305          2.465
LGA    I    45_F      K     306          3.305
LGA    K    46_F      T     307          4.385
LGA    T    47_F      A     308           #
LGA    T    48_F      H     309          3.613
LGA    N    49_F      D     310          2.018
LGA    M    50_F      T     311          0.410
LGA    R    51_F      L     312          3.530
LGA    R    52_F      -       -           -
LGA    L    53_F      L     313          2.179
LGA    G    54_F      V     314          1.005
LGA    V    55_F      Y     315          1.325
LGA    D    56_F      F     316          3.297
LGA    P    57_F      -       -           -
LGA    P    58_F      R     317          2.383
LGA    S    59_F      D     318          1.594
LGA    G    60_F      M     319          1.388
LGA    V    61_F      T     320          1.315
LGA    L    62_F      L     321          1.654
LGA    D    63_F      K     322          1.864
LGA    P    64_F      P     323          1.496
LGA    S    65_F      H     324          1.360
LGA    E    66_F      T     325          1.662
LGA    K    67_F      R     326          2.519
LGA    V    68_F      Y     327          1.732
LGA    L    69_F      T     328          1.741
LGA    M    70_F      V     329          1.821
LGA    A    71_F      R     330          1.590
LGA    V    72_F      I     331          1.354
LGA    S    73_F      G     332          1.260
LGA    C    74_F      F     333          1.699
LGA    D    75_F      K     334          2.464
LGA    T    76_F      Q     335          3.439
LGA    F    77_F      G     336          3.221
LGA    N    78_F      I     337           #
LGA    A    79_F      -       -           -
LGA    A    80_F      -       -           -
LGA    T    81_F      -       -           -
LGA    E    82_F      -       -           -
LGA    D    83_F      -       -           -
LGA    L    84_F      K     338           #
LGA    N    85_F      -       -           -
LGA    N    86_F      -       -           -
LGA    D    87_F      G     339          4.952
LGA    R    88_F      G     340          2.287
LGA    I    89_F      D     341          2.418
LGA    -       -      V     342           -
LGA    C    90_F      N     343          1.951
LGA    I    91_F      F     344          3.816
LGA    E    92_F      E     345          2.850
LGA    W    93_F      V     346          1.611
LGA    T    94_F      T     347          4.036
LGA    N    95_F      N     348          3.007
LGA    T    96_F      F     349           #
LGA    P    97_F      -       -           -
LGA    D    98_F      -       -           -
LGA    G    99_F      -       -           -
LGA    A   100_F      -       -           -
LGA    A   101_F      -       -           -
LGA    K   102_F      -       -           -
LGA    Q   103_F      -       -           -
LGA    F   104_F      -       -           -
LGA    R   105_F      -       -           -
LGA    R   106_F      -       -           -
LGA    E   107_F      -       -           -
LGA    W   108_F      -       -           -
LGA    F   109_F      I     350           #
LGA    Q   110_F      V     351           -
LGA    G   111_F      A     352           #
LGA    D   112_F      P     353          1.815
LGA    G   113_F      D     354           #
LGA    M   114_F      K     355           #
LGA    -       -      G     356           -
LGA    V   115_F      L     357          1.259
LGA    R   116_F      K     358          4.752
LGA    R   117_F      Y     359          1.730
LGA    K   118_F      T     360          3.295
LGA    N   119_F      I     361          2.561
LGA    L   120_F      S     362          1.673
LGA    P   121_F      L     363          2.898
LGA    I   122_F      -       -           -
LGA    E   123_F      -       -           -
LGA    Y   124_F      -       -           -
LGA    N   125_F      -       -           -
LGA    L   126_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124   97    5.0     76    2.62    11.84     54.966     2.790

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.234356 * X  +  -0.456438 * Y  +  -0.858337 * Z  + 103.569710
  Y_new =   0.859884 * X  +  -0.314565 * Y  +   0.402055 * Z  +  42.661583
  Z_new =  -0.453516 * X  +  -0.832294 * Y  +   0.318764 * Z  +  34.131443 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.205036    1.936557  [ DEG:   -69.0434    110.9566 ]
  Theta =   0.470706    2.670886  [ DEG:    26.9695    153.0305 ]
  Phi   =   1.304715   -1.836877  [ DEG:    74.7547   -105.2453 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2msp_F                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2msp_F.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124   97   5.0   76   2.62   11.84  54.966
REMARK  ---------------------------------------------------------- 
MOLECULE 2msp_F
HEADER    CELL MOTILITY PROTEIN                   19-DEC-97   2MSP              
TITLE     MAJOR SPERM PROTEIN, BETA ISOFORM, ENGINEERED C59S/T90C               
TITLE    2 MUTANT, PUTATIVE SUBFILAMENT STRUCTURE, PH 8.5                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MAJOR SPERM PROTEIN;                                       
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 SYNONYM: MSP;                                                        
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES;                                                       
COMPND   7 OTHER_DETAILS: BETA ISOFORM                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ASCARIS SUUM;                                   
SOURCE   3 ORGANISM_COMMON: PIG ROUNDWORM;                                      
SOURCE   4 STRAIN: BL21 (DE3);                                                  
SOURCE   5 CELL_LINE: BL21;                                                     
SOURCE   6 CELL: SPERM CELL;                                                    
SOURCE   7 GENE: BETA MSP C59S/T90C;                                            
SOURCE   8 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET11D;                                   
SOURCE  11 EXPRESSION_SYSTEM_GENE: BETA MSP C59S/T90C                           
KEYWDS    CYTOSKELETAL PROTEIN, NEMATODE SPERM CELL MOTILITY PROTEIN,           
KEYWDS   2 FILAMENTOUS PROTEIN STRUCTURE                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.L.BULLOCK,A.J.MCCOY,M.STEWART                                       
REVDAT   2   01-APR-03 2MSP    1       JRNL                                     
REVDAT   1   15-APR-98 2MSP    0                                                
JRNL        AUTH   T.L.BULLOCK,A.J.MCCOY,H.M.KENT,T.M.ROBERTS,                  
JRNL        AUTH 2 M.STEWART                                                    
JRNL        TITL   STRUCTURAL BASIS FOR AMOEBOID MOTILITY IN NEMATODE           
JRNL        TITL 2 SPERM.                                                       
JRNL        REF    NAT.STRUCT.BIOL.              V.   5   184 1998              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 3.30 ANGSTROMS.                                          
DBREF  2MSP A    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP B    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP C    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP D    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP E    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP F    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP G    1   126  UNP    P27440   MSP2_ASCSU       1    126             
DBREF  2MSP H    1   126  UNP    P27440   MSP2_ASCSU       1    126             
SEQRES   1 A  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 A  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 A  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 A  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 A  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 A  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 A  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 A  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 A  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 A  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 B  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 B  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 B  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 B  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 B  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 B  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 B  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 B  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 B  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 B  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 C  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 C  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 C  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 C  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 C  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 C  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 C  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 C  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 C  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 C  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 D  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 D  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 D  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 D  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 D  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 D  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 D  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 D  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 D  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 D  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 E  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 E  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 E  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 E  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 E  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 E  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 E  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 E  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 E  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 E  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 F  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 F  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 F  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 F  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 F  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 F  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 F  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 F  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 F  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 F  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 G  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 G  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 G  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 G  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 G  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 G  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 G  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 G  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 G  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 G  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
SEQRES   1 H  126  ALA GLN SER VAL PRO PRO GLY ASP ILE ASN THR GLN PRO          
SEQRES   2 H  126  GLY SER LYS ILE VAL PHE ASN ALA PRO TYR ASP ASP LYS          
SEQRES   3 H  126  HIS THR TYR HIS ILE LYS ILE THR ASN ALA GLY GLY ARG          
SEQRES   4 H  126  ARG ILE GLY TRP ALA ILE LYS THR THR ASN MET ARG ARG          
SEQRES   5 H  126  LEU GLY VAL ASP PRO PRO SER GLY VAL LEU ASP PRO SER          
SEQRES   6 H  126  GLU LYS VAL LEU MET ALA VAL SER CYS ASP THR PHE ASN          
SEQRES   7 H  126  ALA ALA THR GLU ASP LEU ASN ASN ASP ARG ILE CYS ILE          
SEQRES   8 H  126  GLU TRP THR ASN THR PRO ASP GLY ALA ALA LYS GLN PHE          
SEQRES   9 H  126  ARG ARG GLU TRP PHE GLN GLY ASP GLY MET VAL ARG ARG          
SEQRES  10 H  126  LYS ASN LEU PRO ILE GLU TYR ASN LEU                          
CRYST1   79.660   79.660  463.790  90.00  90.00  90.00 P 41 21 2    64          
ATOM   4896  N   SER F   3      43.020  45.415  24.006  1.00100.00           N  
ATOM   4897  CA  SER F   3      43.044  45.284  25.470  1.00100.00           C  
ATOM   4898  C   SER F   3      41.846  44.459  26.010  1.00100.00           C  
ATOM   4899  O   SER F   3      41.620  43.308  25.591  1.00100.00           O  
ATOM   4900  CB  SER F   3      43.240  46.643  26.211  1.00100.00           C  
ATOM   4901  OG  SER F   3      42.338  47.650  25.740  1.00100.00           O  
ATOM   4902  N   VAL F   4      41.105  45.051  26.977  1.00 93.63           N  
ATOM   4903  CA  VAL F   4      39.919  44.429  27.567  1.00 90.99           C  
ATOM   4904  C   VAL F   4      38.714  45.282  27.316  1.00 90.11           C  
ATOM   4905  O   VAL F   4      38.778  46.513  27.451  1.00 91.22           O  
ATOM   4906  CB  VAL F   4      40.058  44.136  29.050  1.00 96.91           C  
ATOM   4907  CG1 VAL F   4      41.476  43.692  29.362  1.00 99.24           C  
ATOM   4908  CG2 VAL F   4      39.709  45.376  29.855  1.00 97.13           C  
ATOM   4909  N   PRO F   5      37.630  44.617  26.924  1.00 77.88           N  
ATOM   4910  CA  PRO F   5      36.403  45.250  26.592  1.00 75.43           C  
ATOM   4911  C   PRO F   5      36.045  46.203  27.686  1.00 83.05           C  
ATOM   4912  O   PRO F   5      36.310  45.930  28.864  1.00 81.68           O  
ATOM   4913  CB  PRO F   5      35.380  44.143  26.537  1.00 74.71           C  
ATOM   4914  CG  PRO F   5      35.951  43.015  27.375  1.00 77.90           C  
ATOM   4915  CD  PRO F   5      37.401  43.358  27.646  1.00 74.97           C  
ATOM   4916  N   PRO F   6      35.529  47.342  27.289  1.00 80.75           N  
ATOM   4917  CA  PRO F   6      35.219  48.389  28.208  1.00 81.81           C  
ATOM   4918  C   PRO F   6      33.950  48.105  28.996  1.00 96.40           C  
ATOM   4919  O   PRO F   6      33.146  47.243  28.620  1.00 97.48           O  
ATOM   4920  CB  PRO F   6      35.068  49.650  27.368  1.00 80.87           C  
ATOM   4921  CG  PRO F   6      35.188  49.246  25.913  1.00 83.18           C  
ATOM   4922  CD  PRO F   6      35.360  47.752  25.888  1.00 79.92           C  
ATOM   4923  N   GLY F   7      33.777  48.843  30.101  1.00 95.49           N  
ATOM   4924  CA  GLY F   7      32.591  48.684  30.934  1.00 94.81           C  
ATOM   4925  C   GLY F   7      31.409  49.473  30.374  1.00 92.68           C  
ATOM   4926  O   GLY F   7      31.563  50.295  29.450  1.00 94.45           O  
ATOM   4927  N   ASP F   8      30.215  49.227  30.905  1.00 78.14           N  
ATOM   4928  CA  ASP F   8      29.094  49.958  30.405  1.00 70.45           C  
ATOM   4929  C   ASP F   8      28.909  51.258  31.091  1.00 56.40           C  
ATOM   4930  O   ASP F   8      29.473  51.549  32.155  1.00 47.78           O  
ATOM   4931  CB  ASP F   8      27.784  49.180  30.309  1.00 71.40           C  
ATOM   4932  CG  ASP F   8      27.814  47.950  31.128  1.00 95.37           C  
ATOM   4933  OD1 ASP F   8      28.452  47.862  32.169  1.00100.00           O  
ATOM   4934  OD2 ASP F   8      27.105  46.982  30.598  1.00100.00           O  
ATOM   4935  N   ILE F   9      28.152  52.071  30.427  1.00 45.68           N  
ATOM   4936  CA  ILE F   9      27.803  53.332  30.950  1.00 40.53           C  
ATOM   4937  C   ILE F   9      26.344  53.410  31.071  1.00 60.28           C  
ATOM   4938  O   ILE F   9      25.613  52.634  30.411  1.00 60.41           O  
ATOM   4939  CB  ILE F   9      28.239  54.461  30.114  1.00 35.97           C  
ATOM   4940  CG1 ILE F   9      28.212  54.075  28.672  1.00 33.38           C  
ATOM   4941  CG2 ILE F   9      29.601  54.887  30.564  1.00 31.71           C  
ATOM   4942  CD1 ILE F   9      28.042  55.286  27.807  1.00 37.32           C  
ATOM   4943  N   ASN F  10      25.919  54.372  31.895  1.00 62.38           N  
ATOM   4944  CA  ASN F  10      24.525  54.599  32.138  1.00 59.42           C  
ATOM   4945  C   ASN F  10      24.038  55.962  31.700  1.00 51.08           C  
ATOM   4946  O   ASN F  10      24.704  57.024  31.921  1.00 48.34           O  
ATOM   4947  CB  ASN F  10      24.144  54.280  33.568  1.00 59.71           C  
ATOM   4948  CG  ASN F  10      23.903  52.798  33.727  1.00100.00           C  
ATOM   4949  OD1 ASN F  10      23.461  52.124  32.779  1.00100.00           O  
ATOM   4950  ND2 ASN F  10      24.258  52.270  34.901  1.00 87.99           N  
ATOM   4951  N   THR F  11      22.862  55.943  31.064  1.00 36.35           N  
ATOM   4952  CA  THR F  11      22.331  57.171  30.627  1.00 37.75           C  
ATOM   4953  C   THR F  11      20.948  57.513  31.096  1.00 52.96           C  
ATOM   4954  O   THR F  11      20.038  56.659  31.212  1.00 58.57           O  
ATOM   4955  CB  THR F  11      22.416  57.397  29.157  1.00 30.17           C  
ATOM   4956  OG1 THR F  11      22.144  56.202  28.452  1.00  9.60           O  
ATOM   4957  CG2 THR F  11      23.757  58.002  28.855  1.00 37.37           C  
ATOM   4958  N   GLN F  12      20.776  58.824  31.208  1.00 37.65           N  
ATOM   4959  CA  GLN F  12      19.563  59.435  31.521  1.00 29.84           C  
ATOM   4960  C   GLN F  12      19.341  60.579  30.514  1.00 28.30           C  
ATOM   4961  O   GLN F  12      20.095  61.571  30.496  1.00 27.21           O  
ATOM   4962  CB  GLN F  12      19.598  59.924  32.979  1.00 28.57           C  
ATOM   4963  CG  GLN F  12      19.597  58.747  33.982  1.00 48.23           C  
ATOM   4964  CD  GLN F  12      19.291  59.151  35.424  1.00 87.80           C  
ATOM   4965  OE1 GLN F  12      19.207  60.340  35.756  1.00 75.52           O  
ATOM   4966  NE2 GLN F  12      19.161  58.156  36.290  1.00100.00           N  
ATOM   4967  N   PRO F  13      18.348  60.430  29.630  1.00 17.86           N  
ATOM   4968  CA  PRO F  13      17.487  59.262  29.526  1.00 21.17           C  
ATOM   4969  C   PRO F  13      18.312  58.082  29.157  1.00 37.03           C  
ATOM   4970  O   PRO F  13      19.468  58.215  28.862  1.00 41.04           O  
ATOM   4971  CB  PRO F  13      16.582  59.518  28.308  1.00 23.10           C  
ATOM   4972  CG  PRO F  13      17.009  60.857  27.697  1.00 25.51           C  
ATOM   4973  CD  PRO F  13      18.031  61.481  28.649  1.00 15.69           C  
ATOM   4974  N   GLY F  14      17.691  56.949  29.013  1.00 36.81           N  
ATOM   4975  CA  GLY F  14      18.457  55.817  28.606  1.00 34.45           C  
ATOM   4976  C   GLY F  14      17.884  55.111  27.391  1.00 37.55           C  
ATOM   4977  O   GLY F  14      17.950  53.904  27.317  1.00 46.96           O  
ATOM   4978  N   SER F  15      17.339  55.825  26.425  1.00 18.82           N  
ATOM   4979  CA  SER F  15      16.783  55.108  25.298  1.00 14.94           C  
ATOM   4980  C   SER F  15      16.484  55.973  24.164  1.00 24.65           C  
ATOM   4981  O   SER F  15      16.495  55.526  23.012  1.00 30.14           O  
ATOM   4982  CB  SER F  15      15.549  54.353  25.666  1.00 30.80           C  
ATOM   4983  OG  SER F  15      15.874  53.011  25.904  1.00 76.34           O  
ATOM   4984  N   LYS F  16      16.107  57.190  24.486  1.00 18.66           N  
ATOM   4985  CA  LYS F  16      15.841  58.176  23.488  1.00 13.29           C  
ATOM   4986  C   LYS F  16      15.818  59.514  24.111  1.00 14.22           C  
ATOM   4987  O   LYS F  16      16.044  59.717  25.327  1.00 14.90           O  
ATOM   4988  CB  LYS F  16      14.572  57.925  22.739  1.00  8.99           C  
ATOM   4989  CG  LYS F  16      13.403  57.608  23.661  1.00 54.52           C  
ATOM   4990  CD  LYS F  16      12.047  57.898  23.019  1.00 78.74           C  
ATOM   4991  CE  LYS F  16      10.937  56.983  23.516  1.00 86.87           C  
ATOM   4992  NZ  LYS F  16       9.879  56.768  22.519  1.00 83.02           N  
ATOM   4993  N   ILE F  17      15.493  60.448  23.339  1.00  2.57           N  
ATOM   4994  CA  ILE F  17      15.451  61.720  23.923  1.00  1.78           C  
ATOM   4995  C   ILE F  17      14.438  62.534  23.146  1.00 19.89           C  
ATOM   4996  O   ILE F  17      14.410  62.473  21.883  1.00 19.11           O  
ATOM   4997  CB  ILE F  17      16.818  62.234  23.901  1.00  3.60           C  
ATOM   4998  CG1 ILE F  17      16.930  63.456  24.725  1.00  1.18           C  
ATOM   4999  CG2 ILE F  17      17.149  62.532  22.445  1.00 20.01           C  
ATOM   5000  CD1 ILE F  17      16.722  64.715  23.912  1.00 27.80           C  
ATOM   5001  N   VAL F  18      13.474  63.164  23.874  1.00 19.46           N  
ATOM   5002  CA  VAL F  18      12.440  63.821  23.141  1.00 17.04           C  
ATOM   5003  C   VAL F  18      12.507  65.269  23.074  1.00 15.96           C  
ATOM   5004  O   VAL F  18      12.730  65.930  24.066  1.00 13.28           O  
ATOM   5005  CB  VAL F  18      11.088  63.407  23.489  1.00 22.31           C  
ATOM   5006  CG1 VAL F  18      10.238  63.822  22.335  1.00 21.21           C  
ATOM   5007  CG2 VAL F  18      11.027  61.897  23.652  1.00 22.47           C  
ATOM   5008  N   PHE F  19      12.271  65.766  21.897  1.00 19.75           N  
ATOM   5009  CA  PHE F  19      12.243  67.168  21.746  1.00 33.78           C  
ATOM   5010  C   PHE F  19      10.847  67.559  21.491  1.00 47.47           C  
ATOM   5011  O   PHE F  19      10.249  67.077  20.541  1.00 53.55           O  
ATOM   5012  CB  PHE F  19      13.146  67.691  20.637  1.00 43.38           C  
ATOM   5013  CG  PHE F  19      14.616  67.557  20.928  1.00 54.35           C  
ATOM   5014  CD1 PHE F  19      15.172  66.305  21.150  1.00 63.17           C  
ATOM   5015  CD2 PHE F  19      15.460  68.661  20.892  1.00 63.90           C  
ATOM   5016  CE1 PHE F  19      16.532  66.145  21.360  1.00 65.22           C  
ATOM   5017  CE2 PHE F  19      16.822  68.524  21.128  1.00 69.64           C  
ATOM   5018  CZ  PHE F  19      17.351  67.261  21.378  1.00 67.72           C  
ATOM   5019  N   ASN F  20      10.313  68.395  22.381  1.00 37.35           N  
ATOM   5020  CA  ASN F  20       8.966  68.839  22.295  1.00 32.17           C  
ATOM   5021  C   ASN F  20       8.927  70.164  21.545  1.00 40.09           C  
ATOM   5022  O   ASN F  20       9.791  71.022  21.774  1.00 50.33           O  
ATOM   5023  CB  ASN F  20       8.405  69.060  23.721  1.00 18.46           C  
ATOM   5024  CG  ASN F  20       8.395  67.844  24.684  1.00 30.58           C  
ATOM   5025  OD1 ASN F  20       7.583  66.862  24.567  1.00  8.67           O  
ATOM   5026  ND2 ASN F  20       9.146  68.014  25.772  1.00  1.00           N  
ATOM   5027  N   ALA F  21       7.925  70.351  20.677  1.00 21.94           N  
ATOM   5028  CA  ALA F  21       7.752  71.644  20.032  1.00 18.84           C  
ATOM   5029  C   ALA F  21       7.314  72.665  21.083  1.00 28.95           C  
ATOM   5030  O   ALA F  21       7.107  72.347  22.248  1.00 37.18           O  
ATOM   5031  CB  ALA F  21       6.737  71.549  18.929  1.00 18.38           C  
ATOM   5032  N   PRO F  22       7.218  73.891  20.725  1.00 25.80           N  
ATOM   5033  CA  PRO F  22       7.467  74.383  19.415  1.00 30.74           C  
ATOM   5034  C   PRO F  22       8.966  74.596  19.220  1.00 41.58           C  
ATOM   5035  O   PRO F  22       9.743  74.872  20.172  1.00 41.71           O  
ATOM   5036  CB  PRO F  22       6.844  75.762  19.423  1.00 32.11           C  
ATOM   5037  CG  PRO F  22       6.975  76.243  20.863  1.00 32.06           C  
ATOM   5038  CD  PRO F  22       7.153  74.985  21.713  1.00 24.30           C  
ATOM   5039  N   TYR F  23       9.342  74.559  17.962  1.00 35.79           N  
ATOM   5040  CA  TYR F  23      10.702  74.697  17.565  1.00 32.61           C  
ATOM   5041  C   TYR F  23      10.976  76.063  17.061  1.00 40.95           C  
ATOM   5042  O   TYR F  23      11.305  76.247  15.878  1.00 45.53           O  
ATOM   5043  CB  TYR F  23      11.039  73.626  16.507  1.00 26.07           C  
ATOM   5044  CG  TYR F  23      10.721  72.250  17.013  1.00 10.03           C  
ATOM   5045  CD1 TYR F  23      11.146  71.861  18.285  1.00 13.06           C  
ATOM   5046  CD2 TYR F  23       9.968  71.355  16.259  1.00  1.96           C  
ATOM   5047  CE1 TYR F  23      10.843  70.602  18.799  1.00 13.48           C  
ATOM   5048  CE2 TYR F  23       9.658  70.086  16.740  1.00  1.00           C  
ATOM   5049  CZ  TYR F  23      10.108  69.716  18.013  1.00  9.89           C  
ATOM   5050  OH  TYR F  23       9.825  68.485  18.510  1.00  7.55           O  
ATOM   5051  N   ASP F  24      10.792  77.029  17.948  1.00 34.48           N  
ATOM   5052  CA  ASP F  24      11.063  78.382  17.531  1.00 36.48           C  
ATOM   5053  C   ASP F  24      12.003  79.062  18.441  1.00 44.85           C  
ATOM   5054  O   ASP F  24      12.097  80.282  18.509  1.00 46.20           O  
ATOM   5055  CB  ASP F  24       9.868  79.274  17.045  1.00 39.46           C  
ATOM   5056  CG  ASP F  24       8.513  78.920  17.590  1.00 80.78           C  
ATOM   5057  OD1 ASP F  24       8.183  79.164  18.747  1.00 83.72           O  
ATOM   5058  OD2 ASP F  24       7.695  78.458  16.661  1.00100.00           O  
ATOM   5059  N   ASP F  25      12.753  78.247  19.126  1.00 47.39           N  
ATOM   5060  CA  ASP F  25      13.733  78.749  20.026  1.00 50.00           C  
ATOM   5061  C   ASP F  25      14.738  77.703  20.381  1.00 55.79           C  
ATOM   5062  O   ASP F  25      14.426  76.502  20.426  1.00 61.04           O  
ATOM   5063  CB  ASP F  25      13.086  79.354  21.267  1.00 55.39           C  
ATOM   5064  CG  ASP F  25      13.441  80.804  21.432  1.00 95.85           C  
ATOM   5065  OD1 ASP F  25      14.497  81.289  21.010  1.00100.00           O  
ATOM   5066  OD2 ASP F  25      12.485  81.491  22.047  1.00100.00           O  
ATOM   5067  N   LYS F  26      15.972  78.141  20.562  1.00 49.51           N  
ATOM   5068  CA  LYS F  26      16.996  77.205  20.904  1.00 49.13           C  
ATOM   5069  C   LYS F  26      16.676  76.509  22.201  1.00 55.27           C  
ATOM   5070  O   LYS F  26      16.712  77.102  23.254  1.00 54.23           O  
ATOM   5071  CB  LYS F  26      18.407  77.796  20.924  1.00 49.36           C  
ATOM   5072  CG  LYS F  26      19.342  77.025  21.841  0.00 55.92           C  
ATOM   5073  CD  LYS F  26      20.653  77.734  22.111  0.00 58.64           C  
ATOM   5074  CE  LYS F  26      21.838  76.782  22.149  0.00 65.13           C  
ATOM   5075  NZ  LYS F  26      23.111  77.450  22.416  0.00 73.77           N  
ATOM   5076  N   HIS F  27      16.335  75.249  22.130  1.00 58.10           N  
ATOM   5077  CA  HIS F  27      16.062  74.523  23.329  1.00 63.69           C  
ATOM   5078  C   HIS F  27      17.292  73.765  23.807  1.00 53.99           C  
ATOM   5079  O   HIS F  27      18.087  73.292  23.011  1.00 57.51           O  
ATOM   5080  CB  HIS F  27      14.816  73.631  23.232  1.00 72.66           C  
ATOM   5081  CG  HIS F  27      14.223  73.366  24.589  1.00 83.91           C  
ATOM   5082  ND1 HIS F  27      13.499  74.344  25.272  1.00 90.36           N  
ATOM   5083  CD2 HIS F  27      14.300  72.251  25.398  1.00 90.25           C  
ATOM   5084  CE1 HIS F  27      13.139  73.805  26.451  1.00 92.04           C  
ATOM   5085  NE2 HIS F  27      13.605  72.552  26.556  1.00 91.89           N  
ATOM   5086  N   THR F  28      17.449  73.643  25.107  1.00 36.73           N  
ATOM   5087  CA  THR F  28      18.612  72.976  25.635  1.00 32.07           C  
ATOM   5088  C   THR F  28      18.318  71.817  26.547  1.00 36.56           C  
ATOM   5089  O   THR F  28      18.091  72.009  27.732  1.00 38.92           O  
ATOM   5090  CB  THR F  28      19.442  73.961  26.403  1.00 29.84           C  
ATOM   5091  OG1 THR F  28      19.993  74.904  25.529  1.00 39.69           O  
ATOM   5092  CG2 THR F  28      20.526  73.215  27.146  1.00 22.27           C  
ATOM   5093  N   TYR F  29      18.418  70.605  26.043  1.00 32.16           N  
ATOM   5094  CA  TYR F  29      18.192  69.481  26.920  1.00 36.56           C  
ATOM   5095  C   TYR F  29      19.467  68.979  27.547  1.00 41.32           C  
ATOM   5096  O   TYR F  29      20.523  69.442  27.232  1.00 41.03           O  
ATOM   5097  CB  TYR F  29      17.528  68.350  26.211  1.00 42.20           C  
ATOM   5098  CG  TYR F  29      16.235  68.715  25.549  1.00 48.41           C  
ATOM   5099  CD1 TYR F  29      16.229  69.440  24.365  1.00 50.43           C  
ATOM   5100  CD2 TYR F  29      15.020  68.257  26.060  1.00 48.52           C  
ATOM   5101  CE1 TYR F  29      15.029  69.712  23.707  1.00 53.66           C  
ATOM   5102  CE2 TYR F  29      13.813  68.521  25.412  1.00 48.90           C  
ATOM   5103  CZ  TYR F  29      13.824  69.257  24.233  1.00 62.42           C  
ATOM   5104  OH  TYR F  29      12.639  69.538  23.587  1.00 67.87           O  
ATOM   5105  N   HIS F  30      19.354  68.013  28.462  1.00 38.89           N  
ATOM   5106  CA  HIS F  30      20.541  67.464  29.148  1.00 38.04           C  
ATOM   5107  C   HIS F  30      20.641  65.945  29.122  1.00 43.06           C  
ATOM   5108  O   HIS F  30      19.647  65.239  29.010  1.00 52.47           O  
ATOM   5109  CB  HIS F  30      20.554  67.882  30.605  1.00 39.19           C  
ATOM   5110  CG  HIS F  30      20.831  69.305  30.744  1.00 47.40           C  
ATOM   5111  ND1 HIS F  30      20.365  70.215  29.821  1.00 52.85           N  
ATOM   5112  CD2 HIS F  30      21.542  69.972  31.693  1.00 55.97           C  
ATOM   5113  CE1 HIS F  30      20.803  71.410  30.210  1.00 57.19           C  
ATOM   5114  NE2 HIS F  30      21.522  71.301  31.336  1.00 58.07           N  
ATOM   5115  N   ILE F  31      21.851  65.434  29.341  1.00 27.17           N  
ATOM   5116  CA  ILE F  31      22.075  64.001  29.483  1.00 19.67           C  
ATOM   5117  C   ILE F  31      23.042  63.678  30.566  1.00 31.39           C  
ATOM   5118  O   ILE F  31      24.077  64.347  30.746  1.00 37.06           O  
ATOM   5119  CB  ILE F  31      22.541  63.313  28.287  1.00 18.03           C  
ATOM   5120  CG1 ILE F  31      21.771  63.745  27.076  1.00 21.06           C  
ATOM   5121  CG2 ILE F  31      22.324  61.845  28.554  1.00 12.14           C  
ATOM   5122  CD1 ILE F  31      22.084  62.864  25.865  1.00 24.53           C  
ATOM   5123  N   LYS F  32      22.759  62.607  31.236  1.00 24.71           N  
ATOM   5124  CA  LYS F  32      23.609  62.154  32.286  1.00 26.63           C  
ATOM   5125  C   LYS F  32      24.336  60.932  31.855  1.00 42.67           C  
ATOM   5126  O   LYS F  32      23.709  59.883  31.590  1.00 47.24           O  
ATOM   5127  CB  LYS F  32      22.862  61.819  33.559  1.00 29.11           C  
ATOM   5128  CG  LYS F  32      23.523  62.342  34.830  1.00 40.39           C  
ATOM   5129  CD  LYS F  32      23.091  61.599  36.107  1.00 45.83           C  
ATOM   5130  CE  LYS F  32      22.480  62.509  37.151  0.00 48.62           C  
ATOM   5131  NZ  LYS F  32      21.450  61.840  37.955  0.00 55.70           N  
ATOM   5132  N   ILE F  33      25.666  61.050  31.807  1.00 36.02           N  
ATOM   5133  CA  ILE F  33      26.495  59.904  31.520  1.00 28.92           C  
ATOM   5134  C   ILE F  33      27.133  59.376  32.777  1.00 29.23           C  
ATOM   5135  O   ILE F  33      27.663  60.129  33.617  1.00 29.02           O  
ATOM   5136  CB  ILE F  33      27.474  60.069  30.411  1.00 28.20           C  
ATOM   5137  CG1 ILE F  33      26.767  60.637  29.200  1.00 25.62           C  
ATOM   5138  CG2 ILE F  33      27.938  58.684  30.065  1.00 32.25           C  
ATOM   5139  CD1 ILE F  33      27.594  61.671  28.436  1.00 31.08           C  
ATOM   5140  N   THR F  34      27.032  58.099  32.953  1.00 25.15           N  
ATOM   5141  CA  THR F  34      27.586  57.573  34.142  1.00 30.00           C  
ATOM   5142  C   THR F  34      28.459  56.374  33.936  1.00 44.58           C  
ATOM   5143  O   THR F  34      28.096  55.395  33.258  1.00 48.08           O  
ATOM   5144  CB  THR F  34      26.568  57.401  35.250  1.00 50.50           C  
ATOM   5145  OG1 THR F  34      26.887  58.278  36.307  1.00 43.96           O  
ATOM   5146  CG2 THR F  34      26.572  55.969  35.735  1.00 43.15           C  
ATOM   5147  N   ASN F  35      29.650  56.447  34.514  1.00 43.33           N  
ATOM   5148  CA  ASN F  35      30.592  55.371  34.337  1.00 42.80           C  
ATOM   5149  C   ASN F  35      30.303  54.170  35.206  1.00 34.86           C  
ATOM   5150  O   ASN F  35      30.750  54.099  36.341  1.00 30.59           O  
ATOM   5151  CB  ASN F  35      32.021  55.849  34.544  1.00 49.38           C  
ATOM   5152  CG  ASN F  35      33.021  54.794  34.158  1.00 68.62           C  
ATOM   5153  OD1 ASN F  35      32.654  53.631  33.854  1.00 29.54           O  
ATOM   5154  ND2 ASN F  35      34.288  55.189  34.172  1.00 82.41           N  
ATOM   5155  N   ALA F  36      29.615  53.203  34.640  1.00 26.89           N  
ATOM   5156  CA  ALA F  36      29.296  52.023  35.391  1.00 32.52           C  
ATOM   5157  C   ALA F  36      30.454  51.125  35.545  1.00 62.83           C  
ATOM   5158  O   ALA F  36      30.389  50.148  36.298  1.00 61.09           O  
ATOM   5159  CB  ALA F  36      28.275  51.227  34.655  1.00 33.12           C  
ATOM   5160  N   GLY F  37      31.461  51.377  34.721  1.00 74.81           N  
ATOM   5161  CA  GLY F  37      32.621  50.514  34.630  1.00 81.15           C  
ATOM   5162  C   GLY F  37      33.516  50.491  35.858  1.00 92.68           C  
ATOM   5163  O   GLY F  37      33.302  51.249  36.817  1.00 92.24           O  
ATOM   5164  N   GLY F  38      34.566  49.612  35.776  1.00 89.49           N  
ATOM   5165  CA  GLY F  38      35.578  49.429  36.820  1.00 85.70           C  
ATOM   5166  C   GLY F  38      36.836  50.279  36.599  1.00 77.59           C  
ATOM   5167  O   GLY F  38      37.548  50.627  37.538  1.00 76.01           O  
ATOM   5168  N   ARG F  39      37.062  50.661  35.376  1.00 65.00           N  
ATOM   5169  CA  ARG F  39      38.225  51.443  35.061  1.00 63.13           C  
ATOM   5170  C   ARG F  39      37.851  52.792  34.505  1.00 57.42           C  
ATOM   5171  O   ARG F  39      36.725  53.003  34.138  1.00 55.31           O  
ATOM   5172  CB  ARG F  39      39.097  50.704  34.042  1.00 69.44           C  
ATOM   5173  CG  ARG F  39      39.379  49.247  34.370  0.00 78.26           C  
ATOM   5174  CD  ARG F  39      40.151  48.567  33.252  0.00 87.87           C  
ATOM   5175  NE  ARG F  39      40.760  47.304  33.637  0.00 89.81           N  
ATOM   5176  CZ  ARG F  39      41.663  46.670  32.903  0.00100.00           C  
ATOM   5177  NH1 ARG F  39      42.091  47.159  31.740  0.00 88.70           N  
ATOM   5178  NH2 ARG F  39      42.159  45.517  33.338  0.00 88.11           N  
ATOM   5179  N   ARG F  40      38.837  53.674  34.378  1.00 51.08           N  
ATOM   5180  CA  ARG F  40      38.584  54.952  33.761  1.00 50.67           C  
ATOM   5181  C   ARG F  40      38.050  54.758  32.337  1.00 56.25           C  
ATOM   5182  O   ARG F  40      38.140  53.666  31.780  1.00 61.90           O  
ATOM   5183  CB  ARG F  40      39.847  55.753  33.678  1.00 52.98           C  
ATOM   5184  CG  ARG F  40      39.788  56.982  34.535  1.00 74.19           C  
ATOM   5185  CD  ARG F  40      40.881  57.964  34.194  1.00 81.64           C  
ATOM   5186  NE  ARG F  40      41.576  58.444  35.376  1.00 83.75           N  
ATOM   5187  CZ  ARG F  40      42.497  59.402  35.346  1.00100.00           C  
ATOM   5188  NH1 ARG F  40      42.865  59.991  34.193  1.00100.00           N  
ATOM   5189  NH2 ARG F  40      43.073  59.781  36.498  1.00100.00           N  
ATOM   5190  N   ILE F  41      37.531  55.818  31.733  1.00 40.45           N  
ATOM   5191  CA  ILE F  41      37.073  55.729  30.365  1.00 34.99           C  
ATOM   5192  C   ILE F  41      37.173  57.050  29.668  1.00 24.23           C  
ATOM   5193  O   ILE F  41      37.233  58.165  30.284  1.00 16.61           O  
ATOM   5194  CB  ILE F  41      35.668  55.130  30.174  1.00 42.14           C  
ATOM   5195  CG1 ILE F  41      34.586  56.054  30.718  1.00 49.90           C  
ATOM   5196  CG2 ILE F  41      35.525  53.763  30.816  1.00 41.04           C  
ATOM   5197  CD1 ILE F  41      33.251  55.918  29.983  0.00 59.75           C  
ATOM   5198  N   GLY F  42      37.156  56.935  28.385  1.00 16.74           N  
ATOM   5199  CA  GLY F  42      37.213  58.089  27.548  1.00 18.48           C  
ATOM   5200  C   GLY F  42      36.046  58.011  26.670  1.00 29.55           C  
ATOM   5201  O   GLY F  42      35.730  56.923  26.122  1.00 26.95           O  
ATOM   5202  N   TRP F  43      35.314  59.105  26.600  1.00 28.22           N  
ATOM   5203  CA  TRP F  43      34.121  59.078  25.816  1.00 22.73           C  
ATOM   5204  C   TRP F  43      34.017  60.271  24.972  1.00 13.40           C  
ATOM   5205  O   TRP F  43      34.507  61.409  25.336  1.00  1.00           O  
ATOM   5206  CB  TRP F  43      32.852  58.973  26.680  1.00 20.82           C  
ATOM   5207  CG  TRP F  43      32.712  60.167  27.580  1.00 24.68           C  
ATOM   5208  CD1 TRP F  43      33.164  60.253  28.855  1.00 29.95           C  
ATOM   5209  CD2 TRP F  43      32.183  61.483  27.274  1.00 22.97           C  
ATOM   5210  NE1 TRP F  43      32.953  61.524  29.366  1.00 27.94           N  
ATOM   5211  CE2 TRP F  43      32.384  62.291  28.424  1.00 24.21           C  
ATOM   5212  CE3 TRP F  43      31.572  62.037  26.164  1.00 22.83           C  
ATOM   5213  CZ2 TRP F  43      32.001  63.607  28.480  1.00 18.41           C  
ATOM   5214  CZ3 TRP F  43      31.213  63.361  26.203  1.00 22.40           C  
ATOM   5215  CH2 TRP F  43      31.427  64.141  27.357  1.00 21.70           C  
ATOM   5216  N   ALA F  44      33.361  60.036  23.854  1.00  7.48           N  
ATOM   5217  CA  ALA F  44      33.055  61.113  22.995  1.00 14.05           C  
ATOM   5218  C   ALA F  44      31.813  60.972  22.197  1.00 40.16           C  
ATOM   5219  O   ALA F  44      31.353  59.829  21.965  1.00 43.46           O  
ATOM   5220  CB  ALA F  44      34.155  61.997  22.507  1.00 14.23           C  
ATOM   5221  N   ILE F  45      31.202  62.150  21.889  1.00 41.87           N  
ATOM   5222  CA  ILE F  45      29.897  62.243  21.287  1.00 45.06           C  
ATOM   5223  C   ILE F  45      29.871  62.617  19.857  1.00 53.35           C  
ATOM   5224  O   ILE F  45      30.536  63.539  19.435  1.00 62.53           O  
ATOM   5225  CB  ILE F  45      29.085  63.257  22.031  1.00 52.73           C  
ATOM   5226  CG1 ILE F  45      28.730  62.729  23.400  1.00 54.82           C  
ATOM   5227  CG2 ILE F  45      27.825  63.544  21.241  1.00 59.73           C  
ATOM   5228  CD1 ILE F  45      28.007  61.385  23.321  1.00 76.57           C  
ATOM   5229  N   LYS F  46      28.972  61.993  19.145  1.00 50.13           N  
ATOM   5230  CA  LYS F  46      28.758  62.323  17.747  1.00 55.26           C  
ATOM   5231  C   LYS F  46      27.252  62.429  17.442  1.00 67.65           C  
ATOM   5232  O   LYS F  46      26.441  61.579  17.880  1.00 71.48           O  
ATOM   5233  CB  LYS F  46      29.456  61.340  16.813  1.00 60.72           C  
ATOM   5234  CG  LYS F  46      30.005  61.996  15.552  1.00 96.48           C  
ATOM   5235  CD  LYS F  46      30.387  60.994  14.465  0.00 99.96           C  
ATOM   5236  CE  LYS F  46      29.186  60.459  13.692  0.00100.00           C  
ATOM   5237  NZ  LYS F  46      29.552  59.782  12.435  0.00100.00           N  
ATOM   5238  N   THR F  47      26.867  63.495  16.725  1.00 58.93           N  
ATOM   5239  CA  THR F  47      25.468  63.696  16.371  1.00 55.53           C  
ATOM   5240  C   THR F  47      25.264  63.452  14.918  1.00 59.66           C  
ATOM   5241  O   THR F  47      26.190  63.100  14.221  1.00 65.53           O  
ATOM   5242  CB  THR F  47      25.009  65.093  16.706  1.00 45.92           C  
ATOM   5243  OG1 THR F  47      25.313  65.943  15.622  1.00 40.64           O  
ATOM   5244  CG2 THR F  47      25.741  65.566  17.946  1.00 40.86           C  
ATOM   5245  N   THR F  48      24.073  63.681  14.450  1.00 50.91           N  
ATOM   5246  CA  THR F  48      23.794  63.474  13.065  1.00 52.83           C  
ATOM   5247  C   THR F  48      23.462  64.745  12.357  1.00 65.58           C  
ATOM   5248  O   THR F  48      23.105  64.744  11.179  1.00 72.14           O  
ATOM   5249  CB  THR F  48      22.648  62.516  12.889  1.00 61.79           C  
ATOM   5250  OG1 THR F  48      22.776  61.489  13.834  1.00 52.38           O  
ATOM   5251  CG2 THR F  48      22.647  61.975  11.463  1.00 67.83           C  
ATOM   5252  N   ASN F  49      23.520  65.817  13.086  1.00 60.64           N  
ATOM   5253  CA  ASN F  49      23.171  67.066  12.516  1.00 61.97           C  
ATOM   5254  C   ASN F  49      23.952  68.159  13.118  1.00 72.04           C  
ATOM   5255  O   ASN F  49      23.471  68.862  14.006  1.00 73.05           O  
ATOM   5256  CB  ASN F  49      21.694  67.340  12.691  1.00 60.17           C  
ATOM   5257  CG  ASN F  49      21.149  68.097  11.536  1.00 82.30           C  
ATOM   5258  OD1 ASN F  49      21.729  69.124  11.139  1.00 97.58           O  
ATOM   5259  ND2 ASN F  49      20.071  67.560  10.944  1.00 59.84           N  
ATOM   5260  N   MET F  50      25.183  68.274  12.665  1.00 72.96           N  
ATOM   5261  CA  MET F  50      26.066  69.289  13.167  1.00 73.19           C  
ATOM   5262  C   MET F  50      25.405  70.630  13.033  1.00 77.18           C  
ATOM   5263  O   MET F  50      25.653  71.544  13.840  1.00 78.32           O  
ATOM   5264  CB  MET F  50      27.423  69.286  12.430  0.00 75.50           C  
ATOM   5265  CG  MET F  50      27.878  67.894  12.023  0.00 80.04           C  
ATOM   5266  SD  MET F  50      29.188  67.246  13.085  0.00 84.34           S  
ATOM   5267  CE  MET F  50      29.964  68.791  13.623  0.00 80.61           C  
ATOM   5268  N   ARG F  51      24.534  70.736  12.004  1.00 72.26           N  
ATOM   5269  CA  ARG F  51      23.826  71.973  11.723  1.00 71.18           C  
ATOM   5270  C   ARG F  51      22.814  72.345  12.807  1.00 73.72           C  
ATOM   5271  O   ARG F  51      22.821  73.469  13.314  1.00 75.76           O  
ATOM   5272  CB  ARG F  51      23.211  72.018  10.322  1.00 65.48           C  
ATOM   5273  CG  ARG F  51      24.260  71.869   9.221  0.00 70.27           C  
ATOM   5274  CD  ARG F  51      23.763  72.315   7.850  0.00 73.49           C  
ATOM   5275  NE  ARG F  51      24.764  72.156   6.797  0.00 83.15           N  
ATOM   5276  CZ  ARG F  51      24.519  72.331   5.500  0.00 96.70           C  
ATOM   5277  NH1 ARG F  51      23.314  72.674   5.048  0.00 85.65           N  
ATOM   5278  NH2 ARG F  51      25.506  72.153   4.628  0.00 85.06           N  
ATOM   5279  N   ARG F  52      21.972  71.367  13.176  1.00 63.03           N  
ATOM   5280  CA  ARG F  52      20.869  71.542  14.124  1.00 56.04           C  
ATOM   5281  C   ARG F  52      21.240  71.331  15.593  1.00 47.05           C  
ATOM   5282  O   ARG F  52      20.974  72.175  16.455  1.00 45.20           O  
ATOM   5283  CB  ARG F  52      19.758  70.600  13.728  1.00 46.21           C  
ATOM   5284  CG  ARG F  52      18.415  70.932  14.309  1.00 32.86           C  
ATOM   5285  CD  ARG F  52      17.399  69.847  13.979  1.00  6.88           C  
ATOM   5286  NE  ARG F  52      16.987  69.890  12.573  1.00 19.08           N  
ATOM   5287  CZ  ARG F  52      16.453  68.838  11.951  1.00 49.22           C  
ATOM   5288  NH1 ARG F  52      16.283  67.673  12.587  1.00 21.94           N  
ATOM   5289  NH2 ARG F  52      16.070  68.945  10.670  1.00 51.65           N  
ATOM   5290  N   LEU F  53      21.837  70.188  15.882  1.00 35.15           N  
ATOM   5291  CA  LEU F  53      22.165  69.872  17.252  1.00 33.29           C  
ATOM   5292  C   LEU F  53      23.513  70.369  17.659  1.00 46.46           C  
ATOM   5293  O   LEU F  53      24.298  70.793  16.836  1.00 51.64           O  
ATOM   5294  CB  LEU F  53      22.034  68.401  17.532  1.00 30.62           C  
ATOM   5295  CG  LEU F  53      20.925  67.804  16.723  1.00 35.93           C  
ATOM   5296  CD1 LEU F  53      20.577  66.443  17.295  1.00 36.23           C  
ATOM   5297  CD2 LEU F  53      19.692  68.712  16.786  1.00 41.29           C  
ATOM   5298  N   GLY F  54      23.777  70.293  18.941  1.00 41.20           N  
ATOM   5299  CA  GLY F  54      25.023  70.734  19.471  1.00 40.90           C  
ATOM   5300  C   GLY F  54      25.297  70.120  20.821  1.00 50.49           C  
ATOM   5301  O   GLY F  54      24.402  69.935  21.636  1.00 53.58           O  
ATOM   5302  N   VAL F  55      26.541  69.788  21.066  1.00 46.78           N  
ATOM   5303  CA  VAL F  55      26.877  69.214  22.322  1.00 44.94           C  
ATOM   5304  C   VAL F  55      27.936  69.953  23.037  1.00 46.46           C  
ATOM   5305  O   VAL F  55      28.667  70.758  22.464  1.00 53.23           O  
ATOM   5306  CB  VAL F  55      27.202  67.752  22.242  1.00 47.90           C  
ATOM   5307  CG1 VAL F  55      27.021  67.140  23.634  1.00 47.18           C  
ATOM   5308  CG2 VAL F  55      26.267  67.090  21.239  1.00 46.50           C  
ATOM   5309  N   ASP F  56      28.018  69.667  24.287  1.00 33.93           N  
ATOM   5310  CA  ASP F  56      28.976  70.253  25.109  1.00 34.99           C  
ATOM   5311  C   ASP F  56      28.781  69.777  26.499  1.00 47.99           C  
ATOM   5312  O   ASP F  56      27.703  69.919  27.051  1.00 51.66           O  
ATOM   5313  CB  ASP F  56      28.947  71.774  25.056  1.00 35.86           C  
ATOM   5314  CG  ASP F  56      29.772  72.388  26.157  1.00 80.30           C  
ATOM   5315  OD1 ASP F  56      30.667  71.805  26.757  1.00 85.67           O  
ATOM   5316  OD2 ASP F  56      29.444  73.629  26.385  1.00100.00           O  
ATOM   5317  N   PRO F  57      29.843  69.212  27.089  1.00 42.63           N  
ATOM   5318  CA  PRO F  57      31.130  69.008  26.435  1.00 37.68           C  
ATOM   5319  C   PRO F  57      31.049  67.800  25.523  1.00 40.11           C  
ATOM   5320  O   PRO F  57      30.301  66.859  25.800  1.00 39.64           O  
ATOM   5321  CB  PRO F  57      32.072  68.666  27.539  1.00 37.90           C  
ATOM   5322  CG  PRO F  57      31.223  68.165  28.696  1.00 42.81           C  
ATOM   5323  CD  PRO F  57      29.829  68.670  28.456  1.00 39.89           C  
ATOM   5324  N   PRO F  58      31.851  67.806  24.466  1.00 33.35           N  
ATOM   5325  CA  PRO F  58      31.787  66.777  23.444  1.00 33.87           C  
ATOM   5326  C   PRO F  58      32.533  65.514  23.753  1.00 48.14           C  
ATOM   5327  O   PRO F  58      32.386  64.506  23.021  1.00 50.18           O  
ATOM   5328  CB  PRO F  58      32.345  67.375  22.176  1.00 31.26           C  
ATOM   5329  CG  PRO F  58      32.716  68.805  22.504  1.00 35.30           C  
ATOM   5330  CD  PRO F  58      32.494  69.023  23.995  1.00 30.99           C  
ATOM   5331  N   SER F  59      33.338  65.547  24.814  1.00 42.87           N  
ATOM   5332  CA  SER F  59      34.145  64.395  25.118  1.00 36.99           C  
ATOM   5333  C   SER F  59      34.765  64.520  26.459  1.00 34.55           C  
ATOM   5334  O   SER F  59      35.088  65.640  26.912  1.00 30.09           O  
ATOM   5335  CB  SER F  59      35.259  64.364  24.136  1.00 36.70           C  
ATOM   5336  OG  SER F  59      35.858  65.658  24.133  1.00 56.12           O  
ATOM   5337  N   GLY F  60      35.043  63.390  27.067  1.00 31.02           N  
ATOM   5338  CA  GLY F  60      35.685  63.487  28.335  1.00 33.56           C  
ATOM   5339  C   GLY F  60      36.154  62.178  28.877  1.00 42.60           C  
ATOM   5340  O   GLY F  60      36.059  61.102  28.240  1.00 45.69           O  
ATOM   5341  N   VAL F  61      36.649  62.299  30.088  1.00 41.27           N  
ATOM   5342  CA  VAL F  61      37.149  61.206  30.837  1.00 46.25           C  
ATOM   5343  C   VAL F  61      36.380  61.055  32.089  1.00 42.24           C  
ATOM   5344  O   VAL F  61      36.123  62.029  32.800  1.00 46.29           O  
ATOM   5345  CB  VAL F  61      38.579  61.451  31.196  1.00 61.32           C  
ATOM   5346  CG1 VAL F  61      39.191  60.155  31.723  1.00 64.07           C  
ATOM   5347  CG2 VAL F  61      39.331  61.983  29.973  1.00 62.67           C  
ATOM   5348  N   LEU F  62      36.056  59.839  32.406  1.00 28.40           N  
ATOM   5349  CA  LEU F  62      35.292  59.603  33.605  1.00 30.96           C  
ATOM   5350  C   LEU F  62      35.878  58.518  34.337  1.00 35.60           C  
ATOM   5351  O   LEU F  62      36.072  57.454  33.745  1.00 37.53           O  
ATOM   5352  CB  LEU F  62      33.862  59.124  33.270  1.00 32.71           C  
ATOM   5353  CG  LEU F  62      32.804  60.210  33.092  1.00 37.44           C  
ATOM   5354  CD1 LEU F  62      33.266  61.318  32.115  1.00 33.47           C  
ATOM   5355  CD2 LEU F  62      31.544  59.542  32.566  1.00 45.10           C  
ATOM   5356  N   ASP F  63      36.098  58.729  35.642  1.00 36.85           N  
ATOM   5357  CA  ASP F  63      36.592  57.655  36.497  1.00 43.57           C  
ATOM   5358  C   ASP F  63      35.477  56.672  36.645  1.00 60.18           C  
ATOM   5359  O   ASP F  63      34.462  56.793  35.994  1.00 61.76           O  
ATOM   5360  CB  ASP F  63      37.054  58.148  37.885  1.00 46.71           C  
ATOM   5361  CG  ASP F  63      38.462  58.735  37.913  1.00 83.41           C  
ATOM   5362  OD1 ASP F  63      39.468  58.054  37.992  1.00 91.54           O  
ATOM   5363  OD2 ASP F  63      38.485  60.054  37.960  1.00 85.07           O  
ATOM   5364  N   PRO F  64      35.621  55.705  37.471  1.00 69.23           N  
ATOM   5365  CA  PRO F  64      34.513  54.821  37.604  1.00 72.88           C  
ATOM   5366  C   PRO F  64      33.526  55.427  38.573  1.00 77.52           C  
ATOM   5367  O   PRO F  64      33.921  56.141  39.518  1.00 71.90           O  
ATOM   5368  CB  PRO F  64      35.037  53.508  38.167  1.00 75.00           C  
ATOM   5369  CG  PRO F  64      36.487  53.748  38.546  1.00 80.30           C  
ATOM   5370  CD  PRO F  64      36.833  55.169  38.126  1.00 73.37           C  
ATOM   5371  N   SER F  65      32.242  55.151  38.337  1.00 74.69           N  
ATOM   5372  CA  SER F  65      31.202  55.637  39.204  1.00 74.26           C  
ATOM   5373  C   SER F  65      31.084  57.150  39.146  1.00 73.48           C  
ATOM   5374  O   SER F  65      30.272  57.745  39.815  1.00 77.05           O  
ATOM   5375  CB  SER F  65      31.370  55.121  40.647  1.00 79.87           C  
ATOM   5376  OG  SER F  65      31.021  53.738  40.724  1.00100.00           O  
ATOM   5377  N   GLU F  66      31.927  57.763  38.349  1.00 66.60           N  
ATOM   5378  CA  GLU F  66      31.885  59.191  38.157  1.00 66.34           C  
ATOM   5379  C   GLU F  66      30.788  59.463  37.139  1.00 62.77           C  
ATOM   5380  O   GLU F  66      30.356  58.531  36.439  1.00 60.20           O  
ATOM   5381  CB  GLU F  66      33.266  59.686  37.660  1.00 69.46           C  
ATOM   5382  CG  GLU F  66      33.521  61.199  37.811  1.00 87.19           C  
ATOM   5383  CD  GLU F  66      34.803  61.669  37.115  1.00100.00           C  
ATOM   5384  OE1 GLU F  66      35.441  60.989  36.278  1.00 57.75           O  
ATOM   5385  OE2 GLU F  66      35.131  62.909  37.450  1.00100.00           O  
ATOM   5386  N   LYS F  67      30.293  60.706  37.072  1.00 53.81           N  
ATOM   5387  CA  LYS F  67      29.205  61.016  36.124  1.00 49.70           C  
ATOM   5388  C   LYS F  67      29.287  62.397  35.539  1.00 57.53           C  
ATOM   5389  O   LYS F  67      29.853  63.326  36.121  1.00 61.43           O  
ATOM   5390  CB  LYS F  67      27.850  60.832  36.725  1.00 44.78           C  
ATOM   5391  CG  LYS F  67      27.790  61.334  38.155  1.00 78.29           C  
ATOM   5392  CD  LYS F  67      26.381  61.741  38.584  0.00 82.65           C  
ATOM   5393  CE  LYS F  67      25.892  63.021  37.924  0.00 95.09           C  
ATOM   5394  NZ  LYS F  67      26.271  64.234  38.665  0.00100.00           N  
ATOM   5395  N   VAL F  68      28.662  62.555  34.412  1.00 53.81           N  
ATOM   5396  CA  VAL F  68      28.683  63.830  33.810  1.00 56.39           C  
ATOM   5397  C   VAL F  68      27.387  64.223  33.183  1.00 58.79           C  
ATOM   5398  O   VAL F  68      26.557  63.393  32.766  1.00 59.98           O  
ATOM   5399  CB  VAL F  68      29.779  63.936  32.843  1.00 65.82           C  
ATOM   5400  CG1 VAL F  68      29.410  63.106  31.617  1.00 66.44           C  
ATOM   5401  CG2 VAL F  68      29.962  65.401  32.476  1.00 67.84           C  
ATOM   5402  N   LEU F  69      27.237  65.519  33.070  1.00 49.58           N  
ATOM   5403  CA  LEU F  69      26.056  66.092  32.560  1.00 48.17           C  
ATOM   5404  C   LEU F  69      26.282  66.867  31.312  1.00 39.29           C  
ATOM   5405  O   LEU F  69      26.738  68.009  31.354  1.00 44.33           O  
ATOM   5406  CB  LEU F  69      25.461  67.009  33.613  1.00 50.73           C  
ATOM   5407  CG  LEU F  69      23.963  67.042  33.531  1.00 58.61           C  
ATOM   5408  CD1 LEU F  69      23.382  65.917  34.388  1.00 59.36           C  
ATOM   5409  CD2 LEU F  69      23.478  68.397  34.016  1.00 69.95           C  
ATOM   5410  N   MET F  70      25.925  66.320  30.188  1.00 24.38           N  
ATOM   5411  CA  MET F  70      26.136  67.138  29.052  1.00 29.31           C  
ATOM   5412  C   MET F  70      24.916  67.699  28.478  1.00 39.74           C  
ATOM   5413  O   MET F  70      23.858  67.095  28.509  1.00 53.38           O  
ATOM   5414  CB  MET F  70      27.044  66.585  27.987  1.00 36.55           C  
ATOM   5415  CG  MET F  70      26.299  66.221  26.734  1.00 43.95           C  
ATOM   5416  SD  MET F  70      26.386  64.465  26.522  1.00 51.75           S  
ATOM   5417  CE  MET F  70      26.674  64.406  24.724  1.00 46.55           C  
ATOM   5418  N   ALA F  71      25.083  68.827  27.860  1.00 22.42           N  
ATOM   5419  CA  ALA F  71      23.990  69.560  27.308  1.00 19.57           C  
ATOM   5420  C   ALA F  71      23.786  69.505  25.793  1.00 20.18           C  
ATOM   5421  O   ALA F  71      24.583  70.011  25.021  1.00 24.71           O  
ATOM   5422  CB  ALA F  71      24.148  70.986  27.740  1.00 21.99           C  
ATOM   5423  N   VAL F  72      22.624  69.033  25.384  1.00 14.45           N  
ATOM   5424  CA  VAL F  72      22.245  69.048  23.991  1.00 13.55           C  
ATOM   5425  C   VAL F  72      21.412  70.254  23.625  1.00 27.90           C  
ATOM   5426  O   VAL F  72      20.477  70.622  24.330  1.00 36.55           O  
ATOM   5427  CB  VAL F  72      21.482  67.864  23.629  1.00 16.05           C  
ATOM   5428  CG1 VAL F  72      21.398  67.841  22.123  1.00 16.89           C  
ATOM   5429  CG2 VAL F  72      22.191  66.644  24.168  1.00 17.36           C  
ATOM   5430  N   SER F  73      21.717  70.809  22.471  1.00 21.92           N  
ATOM   5431  CA  SER F  73      21.027  71.959  21.968  1.00 25.98           C  
ATOM   5432  C   SER F  73      20.300  71.659  20.721  1.00 42.07           C  
ATOM   5433  O   SER F  73      20.646  70.744  19.982  1.00 45.88           O  
ATOM   5434  CB  SER F  73      21.934  73.111  21.726  1.00 34.43           C  
ATOM   5435  OG  SER F  73      22.996  73.017  22.642  1.00 81.38           O  
ATOM   5436  N   CYS F  74      19.300  72.456  20.483  1.00 39.18           N  
ATOM   5437  CA  CYS F  74      18.523  72.312  19.324  1.00 35.65           C  
ATOM   5438  C   CYS F  74      18.135  73.650  18.774  1.00 38.50           C  
ATOM   5439  O   CYS F  74      17.485  74.422  19.416  1.00 36.31           O  
ATOM   5440  CB  CYS F  74      17.314  71.441  19.572  1.00 35.08           C  
ATOM   5441  SG  CYS F  74      16.491  71.149  18.000  1.00 40.98           S  
ATOM   5442  N   ASP F  75      18.601  73.966  17.609  1.00 40.59           N  
ATOM   5443  CA  ASP F  75      18.271  75.244  17.057  1.00 38.86           C  
ATOM   5444  C   ASP F  75      16.912  75.206  16.486  1.00 33.05           C  
ATOM   5445  O   ASP F  75      16.289  74.131  16.317  1.00 26.48           O  
ATOM   5446  CB  ASP F  75      19.279  75.746  16.003  1.00 43.18           C  
ATOM   5447  CG  ASP F  75      19.489  77.239  16.043  1.00 79.72           C  
ATOM   5448  OD1 ASP F  75      19.664  77.859  17.087  1.00 81.76           O  
ATOM   5449  OD2 ASP F  75      19.478  77.794  14.843  1.00100.00           O  
ATOM   5450  N   THR F  76      16.455  76.376  16.171  1.00 31.80           N  
ATOM   5451  CA  THR F  76      15.192  76.537  15.555  1.00 33.88           C  
ATOM   5452  C   THR F  76      15.186  75.855  14.209  1.00 35.91           C  
ATOM   5453  O   THR F  76      16.227  75.663  13.601  1.00 42.42           O  
ATOM   5454  CB  THR F  76      14.925  78.022  15.357  1.00 50.54           C  
ATOM   5455  OG1 THR F  76      15.067  78.344  13.977  1.00 68.48           O  
ATOM   5456  CG2 THR F  76      15.942  78.809  16.182  1.00 38.83           C  
ATOM   5457  N   PHE F  77      14.011  75.556  13.725  1.00 25.62           N  
ATOM   5458  CA  PHE F  77      13.885  74.988  12.415  1.00 24.56           C  
ATOM   5459  C   PHE F  77      12.477  74.928  11.897  1.00 43.31           C  
ATOM   5460  O   PHE F  77      11.626  75.689  12.318  1.00 58.78           O  
ATOM   5461  CB  PHE F  77      14.567  73.697  12.286  1.00 17.69           C  
ATOM   5462  CG  PHE F  77      13.964  72.651  13.105  1.00  6.80           C  
ATOM   5463  CD1 PHE F  77      14.378  72.474  14.427  1.00  1.00           C  
ATOM   5464  CD2 PHE F  77      13.085  71.733  12.524  1.00  2.78           C  
ATOM   5465  CE1 PHE F  77      13.921  71.374  15.161  1.00  1.01           C  
ATOM   5466  CE2 PHE F  77      12.613  70.627  13.241  1.00  1.28           C  
ATOM   5467  CZ  PHE F  77      13.039  70.465  14.567  1.00  1.76           C  
ATOM   5468  N   ASN F  78      12.221  74.063  10.961  1.00 29.76           N  
ATOM   5469  CA  ASN F  78      10.899  74.035  10.394  1.00 29.97           C  
ATOM   5470  C   ASN F  78      10.351  72.628  10.234  1.00 38.06           C  
ATOM   5471  O   ASN F  78      10.272  72.103   9.104  1.00 37.99           O  
ATOM   5472  CB  ASN F  78      10.864  74.820   9.068  1.00 16.99           C  
ATOM   5473  CG  ASN F  78       9.477  74.945   8.488  1.00 84.09           C  
ATOM   5474  OD1 ASN F  78       8.601  74.059   8.651  1.00 97.03           O  
ATOM   5475  ND2 ASN F  78       9.258  76.060   7.814  1.00 82.59           N  
ATOM   5476  N   ALA F  79       9.926  72.054  11.361  1.00 30.64           N  
ATOM   5477  CA  ALA F  79       9.398  70.698  11.414  1.00 28.62           C  
ATOM   5478  C   ALA F  79       8.495  70.301  10.223  1.00 29.74           C  
ATOM   5479  O   ALA F  79       8.244  69.114   9.941  1.00 38.60           O  
ATOM   5480  CB  ALA F  79       8.730  70.436  12.755  1.00 27.80           C  
ATOM   5481  N   ALA F  80       8.041  71.248   9.482  1.00 18.15           N  
ATOM   5482  CA  ALA F  80       7.250  70.811   8.371  1.00 25.19           C  
ATOM   5483  C   ALA F  80       7.997  70.760   7.056  1.00 35.44           C  
ATOM   5484  O   ALA F  80       7.409  70.769   5.992  1.00 31.42           O  
ATOM   5485  CB  ALA F  80       5.945  71.552   8.280  1.00 29.46           C  
ATOM   5486  N   THR F  81       9.291  70.660   7.133  1.00 40.33           N  
ATOM   5487  CA  THR F  81      10.115  70.583   5.937  1.00 40.61           C  
ATOM   5488  C   THR F  81      11.492  70.038   6.244  1.00 34.50           C  
ATOM   5489  O   THR F  81      12.414  70.575   5.759  1.00 38.66           O  
ATOM   5490  CB  THR F  81      10.381  71.983   5.342  1.00 49.34           C  
ATOM   5491  OG1 THR F  81      11.295  72.681   6.198  1.00 39.83           O  
ATOM   5492  CG2 THR F  81       9.107  72.786   5.178  1.00 50.97           C  
ATOM   5493  N   GLU F  82      11.613  69.050   7.072  1.00 19.00           N  
ATOM   5494  CA  GLU F  82      12.934  68.610   7.450  1.00 22.63           C  
ATOM   5495  C   GLU F  82      12.798  67.298   8.017  1.00 47.79           C  
ATOM   5496  O   GLU F  82      11.818  66.998   8.664  1.00 55.49           O  
ATOM   5497  CB  GLU F  82      13.658  69.534   8.482  1.00 23.90           C  
ATOM   5498  CG  GLU F  82      13.741  71.074   8.097  1.00 21.45           C  
ATOM   5499  CD  GLU F  82      14.937  71.825   8.706  1.00 85.67           C  
ATOM   5500  OE1 GLU F  82      15.896  71.281   9.252  1.00100.00           O  
ATOM   5501  OE2 GLU F  82      14.820  73.145   8.570  1.00 90.71           O  
ATOM   5502  N   ASP F  83      13.683  66.470   7.685  1.00 52.98           N  
ATOM   5503  CA  ASP F  83      13.549  65.144   8.152  1.00 57.11           C  
ATOM   5504  C   ASP F  83      13.613  65.116   9.649  1.00 56.60           C  
ATOM   5505  O   ASP F  83      14.308  65.950  10.250  1.00 58.41           O  
ATOM   5506  CB  ASP F  83      14.530  64.143   7.510  1.00 64.34           C  
ATOM   5507  CG  ASP F  83      14.137  62.712   7.803  1.00 98.72           C  
ATOM   5508  OD1 ASP F  83      14.324  62.165   8.888  1.00100.00           O  
ATOM   5509  OD2 ASP F  83      13.520  62.139   6.790  1.00100.00           O  
ATOM   5510  N   LEU F  84      12.850  64.208  10.251  1.00 46.55           N  
ATOM   5511  CA  LEU F  84      12.849  64.128  11.674  1.00 48.19           C  
ATOM   5512  C   LEU F  84      12.959  62.727  12.175  1.00 58.63           C  
ATOM   5513  O   LEU F  84      12.842  62.478  13.370  1.00 60.79           O  
ATOM   5514  CB  LEU F  84      11.630  64.847  12.303  1.00 50.32           C  
ATOM   5515  CG  LEU F  84      11.009  65.937  11.420  1.00 55.60           C  
ATOM   5516  CD1 LEU F  84       9.608  65.545  11.005  1.00 54.12           C  
ATOM   5517  CD2 LEU F  84      10.958  67.259  12.187  1.00 54.54           C  
ATOM   5518  N   ASN F  85      13.173  61.803  11.265  1.00 62.72           N  
ATOM   5519  CA  ASN F  85      13.253  60.402  11.653  1.00 65.25           C  
ATOM   5520  C   ASN F  85      14.663  59.926  11.719  1.00 71.26           C  
ATOM   5521  O   ASN F  85      14.942  58.812  12.189  1.00 73.62           O  
ATOM   5522  CB  ASN F  85      12.459  59.526  10.699  1.00 63.48           C  
ATOM   5523  CG  ASN F  85      11.349  60.308  10.047  1.00100.00           C  
ATOM   5524  OD1 ASN F  85      10.182  59.860  10.032  1.00100.00           O  
ATOM   5525  ND2 ASN F  85      11.684  61.521   9.558  1.00100.00           N  
ATOM   5526  N   ASN F  86      15.556  60.779  11.246  1.00 64.77           N  
ATOM   5527  CA  ASN F  86      16.925  60.393  11.177  1.00 63.16           C  
ATOM   5528  C   ASN F  86      17.911  61.153  12.030  1.00 61.81           C  
ATOM   5529  O   ASN F  86      19.055  61.290  11.661  1.00 67.16           O  
ATOM   5530  CB  ASN F  86      17.387  60.258   9.732  1.00 68.20           C  
ATOM   5531  CG  ASN F  86      16.698  59.092   9.048  1.00100.00           C  
ATOM   5532  OD1 ASN F  86      16.642  57.962   9.603  1.00100.00           O  
ATOM   5533  ND2 ASN F  86      16.115  59.363   7.870  1.00100.00           N  
ATOM   5534  N   ASP F  87      17.521  61.611  13.180  1.00 48.67           N  
ATOM   5535  CA  ASP F  87      18.509  62.230  14.008  1.00 42.12           C  
ATOM   5536  C   ASP F  87      18.909  61.280  15.105  1.00 39.27           C  
ATOM   5537  O   ASP F  87      18.134  60.376  15.442  1.00 44.38           O  
ATOM   5538  CB  ASP F  87      18.185  63.647  14.442  1.00 41.73           C  
ATOM   5539  CG  ASP F  87      18.188  64.571  13.255  1.00 50.32           C  
ATOM   5540  OD1 ASP F  87      18.019  63.962  12.110  1.00 48.57           O  
ATOM   5541  OD2 ASP F  87      18.369  65.758  13.345  1.00 56.02           O  
ATOM   5542  N   ARG F  88      20.169  61.360  15.542  1.00 18.53           N  
ATOM   5543  CA  ARG F  88      20.681  60.387  16.508  1.00 11.47           C  
ATOM   5544  C   ARG F  88      21.763  60.955  17.362  1.00  6.77           C  
ATOM   5545  O   ARG F  88      22.457  61.944  17.002  1.00  3.09           O  
ATOM   5546  CB  ARG F  88      21.266  59.210  15.747  1.00 18.48           C  
ATOM   5547  CG  ARG F  88      20.878  57.846  16.284  1.00 49.40           C  
ATOM   5548  CD  ARG F  88      21.091  56.720  15.281  0.00 55.04           C  
ATOM   5549  NE  ARG F  88      21.596  57.188  13.996  0.00 57.72           N  
ATOM   5550  CZ  ARG F  88      20.857  57.280  12.897  0.00 67.06           C  
ATOM   5551  NH1 ARG F  88      19.568  56.947  12.880  0.00 52.06           N  
ATOM   5552  NH2 ARG F  88      21.423  57.720  11.777  0.00 51.41           N  
ATOM   5553  N   ILE F  89      21.969  60.329  18.486  1.00  7.10           N  
ATOM   5554  CA  ILE F  89      23.050  60.795  19.303  1.00 13.99           C  
ATOM   5555  C   ILE F  89      24.006  59.687  19.605  1.00 42.30           C  
ATOM   5556  O   ILE F  89      23.597  58.595  20.059  1.00 50.63           O  
ATOM   5557  CB  ILE F  89      22.664  61.618  20.461  1.00 11.72           C  
ATOM   5558  CG1 ILE F  89      22.904  63.048  20.085  1.00 11.03           C  
ATOM   5559  CG2 ILE F  89      23.532  61.256  21.658  1.00 12.09           C  
ATOM   5560  CD1 ILE F  89      22.708  63.961  21.267  1.00 40.13           C  
ATOM   5561  N   CYS F  90      25.270  59.912  19.259  1.00 39.93           N  
ATOM   5562  CA  CYS F  90      26.206  58.859  19.403  1.00 43.66           C  
ATOM   5563  C   CYS F  90      27.224  58.956  20.477  1.00 29.93           C  
ATOM   5564  O   CYS F  90      28.011  59.899  20.537  1.00 27.99           O  
ATOM   5565  CB  CYS F  90      26.769  58.341  18.121  1.00 48.23           C  
ATOM   5566  SG  CYS F  90      27.277  56.658  18.386  1.00 57.29           S  
ATOM   5567  N   ILE F  91      27.249  57.908  21.275  1.00 21.49           N  
ATOM   5568  CA  ILE F  91      28.160  57.835  22.363  1.00 24.87           C  
ATOM   5569  C   ILE F  91      29.190  56.723  22.191  1.00 42.22           C  
ATOM   5570  O   ILE F  91      28.835  55.529  22.149  1.00 50.46           O  
ATOM   5571  CB  ILE F  91      27.444  57.654  23.669  1.00 27.24           C  
ATOM   5572  CG1 ILE F  91      26.580  58.847  23.971  1.00 29.73           C  
ATOM   5573  CG2 ILE F  91      28.484  57.528  24.769  1.00 28.79           C  
ATOM   5574  CD1 ILE F  91      26.610  59.190  25.461  1.00 44.67           C  
ATOM   5575  N   GLU F  92      30.476  57.136  22.135  1.00 30.37           N  
ATOM   5576  CA  GLU F  92      31.599  56.243  21.994  1.00 22.46           C  
ATOM   5577  C   GLU F  92      32.492  56.331  23.197  1.00 20.07           C  
ATOM   5578  O   GLU F  92      32.873  57.469  23.673  1.00  8.75           O  
ATOM   5579  CB  GLU F  92      32.424  56.611  20.753  1.00 22.01           C  
ATOM   5580  CG  GLU F  92      32.074  55.792  19.490  1.00 36.39           C  
ATOM   5581  CD  GLU F  92      32.681  56.374  18.225  1.00 74.18           C  
ATOM   5582  OE1 GLU F  92      33.105  57.525  18.162  1.00 44.93           O  
ATOM   5583  OE2 GLU F  92      32.706  55.503  17.225  1.00 64.74           O  
ATOM   5584  N   TRP F  93      32.874  55.173  23.676  1.00 21.91           N  
ATOM   5585  CA  TRP F  93      33.794  55.189  24.747  1.00 26.67           C  
ATOM   5586  C   TRP F  93      34.667  54.002  24.733  1.00 45.34           C  
ATOM   5587  O   TRP F  93      34.326  52.957  24.135  1.00 43.56           O  
ATOM   5588  CB  TRP F  93      33.139  55.376  26.119  1.00 24.23           C  
ATOM   5589  CG  TRP F  93      32.354  54.180  26.576  1.00 25.66           C  
ATOM   5590  CD1 TRP F  93      32.653  53.355  27.623  1.00 28.62           C  
ATOM   5591  CD2 TRP F  93      31.128  53.705  26.025  1.00 27.14           C  
ATOM   5592  NE1 TRP F  93      31.693  52.366  27.741  1.00 29.84           N  
ATOM   5593  CE2 TRP F  93      30.737  52.562  26.787  1.00 33.46           C  
ATOM   5594  CE3 TRP F  93      30.290  54.165  25.006  1.00 29.41           C  
ATOM   5595  CZ2 TRP F  93      29.534  51.893  26.552  1.00 33.44           C  
ATOM   5596  CZ3 TRP F  93      29.107  53.482  24.761  1.00 32.98           C  
ATOM   5597  CH2 TRP F  93      28.751  52.343  25.509  1.00 33.65           C  
ATOM   5598  N   THR F  94      35.791  54.179  25.422  1.00 48.99           N  
ATOM   5599  CA  THR F  94      36.755  53.128  25.623  1.00 48.45           C  
ATOM   5600  C   THR F  94      37.533  53.344  26.892  1.00 48.48           C  
ATOM   5601  O   THR F  94      37.506  54.456  27.466  1.00 48.97           O  
ATOM   5602  CB  THR F  94      37.707  53.002  24.480  1.00 50.36           C  
ATOM   5603  OG1 THR F  94      38.644  52.005  24.848  1.00 42.50           O  
ATOM   5604  CG2 THR F  94      38.389  54.350  24.294  1.00 40.89           C  
ATOM   5605  N   ASN F  95      38.231  52.287  27.341  1.00 36.68           N  
ATOM   5606  CA  ASN F  95      39.012  52.405  28.565  1.00 37.54           C  
ATOM   5607  C   ASN F  95      40.241  53.269  28.356  1.00 48.09           C  
ATOM   5608  O   ASN F  95      40.606  53.531  27.236  1.00 52.79           O  
ATOM   5609  CB  ASN F  95      39.414  51.046  29.142  1.00 26.17           C  
ATOM   5610  CG  ASN F  95      38.275  50.057  29.304  1.00 78.40           C  
ATOM   5611  OD1 ASN F  95      37.806  49.465  28.321  1.00 91.10           O  
ATOM   5612  ND2 ASN F  95      37.917  49.781  30.563  1.00 80.01           N  
ATOM   5613  N   THR F  96      40.890  53.724  29.415  1.00 46.61           N  
ATOM   5614  CA  THR F  96      42.075  54.519  29.183  1.00 54.48           C  
ATOM   5615  C   THR F  96      43.354  53.775  29.513  1.00 85.19           C  
ATOM   5616  O   THR F  96      43.411  52.982  30.453  1.00 91.94           O  
ATOM   5617  CB  THR F  96      42.100  55.870  29.894  1.00 51.22           C  
ATOM   5618  OG1 THR F  96      41.367  55.824  31.105  1.00 44.77           O  
ATOM   5619  CG2 THR F  96      41.687  57.033  28.959  1.00 30.50           C  
ATOM   5620  N   PRO F  97      44.377  54.079  28.746  1.00 88.38           N  
ATOM   5621  CA  PRO F  97      45.709  53.561  28.899  1.00 89.73           C  
ATOM   5622  C   PRO F  97      46.182  53.573  30.358  1.00 96.83           C  
ATOM   5623  O   PRO F  97      46.061  54.583  31.070  1.00 94.35           O  
ATOM   5624  CB  PRO F  97      46.594  54.476  28.061  1.00 91.53           C  
ATOM   5625  CG  PRO F  97      45.678  55.438  27.308  1.00 94.78           C  
ATOM   5626  CD  PRO F  97      44.267  55.090  27.684  1.00 90.04           C  
ATOM   5627  N   ASP F  98      46.748  52.420  30.761  1.00 98.38           N  
ATOM   5628  CA  ASP F  98      47.227  52.142  32.116  1.00 97.93           C  
ATOM   5629  C   ASP F  98      47.653  53.321  32.992  1.00100.00           C  
ATOM   5630  O   ASP F  98      47.463  53.282  34.209  1.00100.00           O  
ATOM   5631  CB  ASP F  98      48.089  50.872  32.259  1.00 98.41           C  
ATOM   5632  CG  ASP F  98      47.322  49.629  31.884  0.00100.00           C  
ATOM   5633  OD1 ASP F  98      46.106  49.587  31.839  0.00100.00           O  
ATOM   5634  OD2 ASP F  98      48.100  48.614  31.602  0.00100.00           O  
ATOM   5635  N   GLY F  99      48.217  54.364  32.415  1.00 93.40           N  
ATOM   5636  CA  GLY F  99      48.597  55.510  33.227  1.00 93.09           C  
ATOM   5637  C   GLY F  99      48.236  56.770  32.509  1.00100.00           C  
ATOM   5638  O   GLY F  99      49.073  57.379  31.853  1.00100.00           O  
ATOM   5639  N   ALA F 100      46.966  57.133  32.569  1.00 96.96           N  
ATOM   5640  CA  ALA F 100      46.526  58.257  31.798  1.00 96.75           C  
ATOM   5641  C   ALA F 100      46.238  59.508  32.571  1.00100.00           C  
ATOM   5642  O   ALA F 100      45.956  59.490  33.770  1.00100.00           O  
ATOM   5643  CB  ALA F 100      45.369  57.877  30.888  1.00 96.82           C  
ATOM   5644  N   ALA F 101      46.299  60.595  31.838  1.00 99.53           N  
ATOM   5645  CA  ALA F 101      46.010  61.890  32.365  1.00 99.60           C  
ATOM   5646  C   ALA F 101      44.601  62.299  32.026  1.00100.00           C  
ATOM   5647  O   ALA F 101      44.129  62.120  30.884  1.00100.00           O  
ATOM   5648  CB  ALA F 101      46.983  62.912  31.808  1.00100.00           C  
ATOM   5649  N   LYS F 102      43.941  62.883  33.021  1.00 93.31           N  
ATOM   5650  CA  LYS F 102      42.611  63.346  32.814  1.00 92.58           C  
ATOM   5651  C   LYS F 102      42.569  64.464  31.795  1.00 95.82           C  
ATOM   5652  O   LYS F 102      42.661  65.632  32.129  1.00 99.99           O  
ATOM   5653  CB  LYS F 102      41.923  63.729  34.097  1.00 96.44           C  
ATOM   5654  CG  LYS F 102      40.857  62.728  34.477  1.00100.00           C  
ATOM   5655  CD  LYS F 102      40.517  62.758  35.950  1.00100.00           C  
ATOM   5656  CE  LYS F 102      39.030  62.901  36.197  1.00100.00           C  
ATOM   5657  NZ  LYS F 102      38.719  63.162  37.604  1.00100.00           N  
ATOM   5658  N   GLN F 103      42.465  64.065  30.551  1.00 85.81           N  
ATOM   5659  CA  GLN F 103      42.342  64.948  29.419  1.00 84.12           C  
ATOM   5660  C   GLN F 103      42.116  64.085  28.227  1.00 76.32           C  
ATOM   5661  O   GLN F 103      42.857  63.158  27.967  1.00 72.29           O  
ATOM   5662  CB  GLN F 103      43.523  65.944  29.231  1.00 86.31           C  
ATOM   5663  CG  GLN F 103      43.169  67.148  28.330  0.00 89.79           C  
ATOM   5664  CD  GLN F 103      44.382  67.940  27.868  0.00 99.78           C  
ATOM   5665  OE1 GLN F 103      45.496  67.404  27.763  0.00 92.84           O  
ATOM   5666  NE2 GLN F 103      44.170  69.223  27.582  0.00 85.44           N  
ATOM   5667  N   PHE F 104      41.018  64.274  27.593  0.00 70.18           N  
ATOM   5668  CA  PHE F 104      40.706  63.418  26.504  1.00 68.00           C  
ATOM   5669  C   PHE F 104      41.747  63.459  25.395  1.00 78.57           C  
ATOM   5670  O   PHE F 104      42.157  64.552  24.965  1.00 84.76           O  
ATOM   5671  CB  PHE F 104      39.348  63.752  25.956  1.00 65.17           C  
ATOM   5672  CG  PHE F 104      38.941  62.813  24.899  1.00 58.99           C  
ATOM   5673  CD1 PHE F 104      38.523  61.527  25.228  1.00 59.96           C  
ATOM   5674  CD2 PHE F 104      38.953  63.199  23.562  1.00 54.82           C  
ATOM   5675  CE1 PHE F 104      38.103  60.626  24.253  1.00 59.30           C  
ATOM   5676  CE2 PHE F 104      38.537  62.314  22.570  1.00 57.71           C  
ATOM   5677  CZ  PHE F 104      38.115  61.027  22.918  1.00 57.99           C  
ATOM   5678  N   ARG F 105      42.136  62.246  24.900  1.00 64.15           N  
ATOM   5679  CA  ARG F 105      43.110  62.102  23.820  1.00 54.88           C  
ATOM   5680  C   ARG F 105      42.585  61.234  22.682  1.00 37.35           C  
ATOM   5681  O   ARG F 105      42.534  59.994  22.818  1.00 28.76           O  
ATOM   5682  CB  ARG F 105      44.458  61.649  24.341  1.00 53.47           C  
ATOM   5683  CG  ARG F 105      45.287  62.842  24.812  0.00 59.60           C  
ATOM   5684  CD  ARG F 105      46.741  62.498  25.065  0.00 65.24           C  
ATOM   5685  NE  ARG F 105      47.656  63.320  24.288  0.00 75.76           N  
ATOM   5686  CZ  ARG F 105      48.530  62.825  23.421  0.00 96.23           C  
ATOM   5687  NH1 ARG F 105      48.623  61.522  23.176  0.00 83.50           N  
ATOM   5688  NH2 ARG F 105      49.324  63.663  22.760  0.00 82.58           N  
ATOM   5689  N   ARG F 106      42.174  61.933  21.563  1.00 32.56           N  
ATOM   5690  CA  ARG F 106      41.550  61.305  20.375  1.00 37.23           C  
ATOM   5691  C   ARG F 106      42.158  59.981  20.017  1.00 53.12           C  
ATOM   5692  O   ARG F 106      41.494  59.026  19.615  1.00 49.10           O  
ATOM   5693  CB  ARG F 106      41.496  62.207  19.129  1.00 34.96           C  
ATOM   5694  CG  ARG F 106      41.930  61.479  17.843  0.00 46.40           C  
ATOM   5695  CD  ARG F 106      40.765  61.095  16.927  0.00 60.96           C  
ATOM   5696  NE  ARG F 106      40.993  61.448  15.525  0.00 73.77           N  
ATOM   5697  CZ  ARG F 106      40.019  61.722  14.658  0.00 86.58           C  
ATOM   5698  NH1 ARG F 106      38.736  61.694  15.010  0.00 72.42           N  
ATOM   5699  NH2 ARG F 106      40.336  62.033  13.405  0.00 71.83           N  
ATOM   5700  N   GLU F 107      43.447  59.976  20.130  1.00 64.82           N  
ATOM   5701  CA  GLU F 107      44.273  58.859  19.806  1.00 66.37           C  
ATOM   5702  C   GLU F 107      43.742  57.568  20.346  1.00 59.83           C  
ATOM   5703  O   GLU F 107      43.687  56.592  19.613  1.00 52.85           O  
ATOM   5704  CB  GLU F 107      45.699  59.121  20.293  1.00 68.85           C  
ATOM   5705  CG  GLU F 107      46.323  60.368  19.605  1.00 84.49           C  
ATOM   5706  CD  GLU F 107      46.216  61.654  20.412  1.00100.00           C  
ATOM   5707  OE1 GLU F 107      46.866  61.589  21.559  1.00100.00           O  
ATOM   5708  OE2 GLU F 107      45.617  62.659  20.023  1.00100.00           O  
ATOM   5709  N   TRP F 108      43.348  57.606  21.616  1.00 54.81           N  
ATOM   5710  CA  TRP F 108      42.839  56.474  22.306  1.00 55.94           C  
ATOM   5711  C   TRP F 108      41.925  55.635  21.443  1.00 58.77           C  
ATOM   5712  O   TRP F 108      41.863  54.413  21.562  1.00 55.68           O  
ATOM   5713  CB  TRP F 108      42.085  56.942  23.510  1.00 57.60           C  
ATOM   5714  CG  TRP F 108      42.948  57.534  24.528  1.00 62.61           C  
ATOM   5715  CD1 TRP F 108      44.162  57.126  24.823  1.00 67.27           C  
ATOM   5716  CD2 TRP F 108      42.626  58.566  25.463  1.00 64.66           C  
ATOM   5717  NE1 TRP F 108      44.656  57.848  25.874  1.00 70.30           N  
ATOM   5718  CE2 TRP F 108      43.728  58.732  26.291  1.00 71.34           C  
ATOM   5719  CE3 TRP F 108      41.520  59.340  25.692  1.00 66.75           C  
ATOM   5720  CZ2 TRP F 108      43.756  59.645  27.332  1.00 70.19           C  
ATOM   5721  CZ3 TRP F 108      41.537  60.244  26.725  1.00 69.24           C  
ATOM   5722  CH2 TRP F 108      42.645  60.398  27.534  1.00 69.85           C  
ATOM   5723  N   PHE F 109      41.250  56.295  20.524  1.00 57.42           N  
ATOM   5724  CA  PHE F 109      40.312  55.611  19.674  1.00 60.65           C  
ATOM   5725  C   PHE F 109      40.980  55.012  18.511  1.00 63.91           C  
ATOM   5726  O   PHE F 109      40.742  53.845  18.197  1.00 57.78           O  
ATOM   5727  CB  PHE F 109      39.109  56.500  19.256  1.00 65.98           C  
ATOM   5728  CG  PHE F 109      38.181  56.756  20.428  1.00 66.95           C  
ATOM   5729  CD1 PHE F 109      38.568  57.623  21.452  1.00 69.71           C  
ATOM   5730  CD2 PHE F 109      36.980  56.071  20.564  1.00 63.09           C  
ATOM   5731  CE1 PHE F 109      37.779  57.833  22.584  1.00 67.12           C  
ATOM   5732  CE2 PHE F 109      36.179  56.254  21.691  1.00 64.38           C  
ATOM   5733  CZ  PHE F 109      36.586  57.130  22.699  1.00 63.17           C  
ATOM   5734  N   GLN F 110      41.839  55.848  17.902  1.00 68.05           N  
ATOM   5735  CA  GLN F 110      42.647  55.521  16.719  1.00 68.86           C  
ATOM   5736  C   GLN F 110      43.480  54.232  16.879  1.00 69.50           C  
ATOM   5737  O   GLN F 110      43.581  53.429  15.958  1.00 69.16           O  
ATOM   5738  CB  GLN F 110      43.578  56.715  16.383  1.00 69.71           C  
ATOM   5739  CG  GLN F 110      42.931  57.774  15.484  1.00 54.90           C  
ATOM   5740  CD  GLN F 110      43.689  59.086  15.482  0.00 85.67           C  
ATOM   5741  OE1 GLN F 110      44.094  59.595  16.532  0.00 82.71           O  
ATOM   5742  NE2 GLN F 110      43.906  59.635  14.288  0.00 79.55           N  
ATOM   5743  N   GLY F 111      44.004  54.006  18.071  1.00 61.69           N  
ATOM   5744  CA  GLY F 111      44.877  52.874  18.371  1.00 58.68           C  
ATOM   5745  C   GLY F 111      44.364  51.444  18.124  1.00 57.44           C  
ATOM   5746  O   GLY F 111      43.447  51.184  17.355  1.00 59.24           O  
ATOM   5747  N   ASP F 112      45.088  50.510  18.756  1.00 56.01           N  
ATOM   5748  CA  ASP F 112      44.817  49.088  18.709  1.00 58.11           C  
ATOM   5749  C   ASP F 112      44.061  48.802  19.997  1.00 67.64           C  
ATOM   5750  O   ASP F 112      44.580  49.092  21.079  1.00 63.82           O  
ATOM   5751  CB  ASP F 112      46.175  48.248  18.640  1.00 60.91           C  
ATOM   5752  CG  ASP F 112      46.524  47.551  17.291  1.00 64.74           C  
ATOM   5753  OD1 ASP F 112      46.244  48.000  16.180  1.00 62.47           O  
ATOM   5754  OD2 ASP F 112      47.163  46.423  17.435  1.00 65.15           O  
ATOM   5755  N   GLY F 113      42.784  48.355  19.863  1.00 70.11           N  
ATOM   5756  CA  GLY F 113      41.910  48.067  21.043  1.00 67.80           C  
ATOM   5757  C   GLY F 113      40.416  47.901  20.680  1.00 65.01           C  
ATOM   5758  O   GLY F 113      40.036  47.509  19.558  1.00 59.55           O  
ATOM   5759  N   MET F 114      39.567  48.109  21.710  1.00 59.03           N  
ATOM   5760  CA  MET F 114      38.106  47.999  21.641  1.00 53.79           C  
ATOM   5761  C   MET F 114      37.401  49.333  21.843  1.00 49.81           C  
ATOM   5762  O   MET F 114      37.810  50.159  22.671  1.00 44.07           O  
ATOM   5763  CB  MET F 114      37.586  47.001  22.652  1.00 56.35           C  
ATOM   5764  CG  MET F 114      36.947  45.812  21.981  1.00 62.41           C  
ATOM   5765  SD  MET F 114      36.977  44.366  23.056  1.00 68.56           S  
ATOM   5766  CE  MET F 114      38.226  44.938  24.228  1.00 64.65           C  
ATOM   5767  N   VAL F 115      36.312  49.515  21.098  1.00 46.18           N  
ATOM   5768  CA  VAL F 115      35.511  50.721  21.222  1.00 46.96           C  
ATOM   5769  C   VAL F 115      34.020  50.391  21.327  1.00 55.09           C  
ATOM   5770  O   VAL F 115      33.516  49.595  20.518  1.00 58.39           O  
ATOM   5771  CB  VAL F 115      35.831  51.721  20.143  1.00 48.96           C  
ATOM   5772  CG1 VAL F 115      34.585  52.094  19.391  1.00 47.66           C  
ATOM   5773  CG2 VAL F 115      36.389  52.949  20.817  1.00 49.21           C  
ATOM   5774  N   ARG F 116      33.342  50.962  22.382  1.00 46.36           N  
ATOM   5775  CA  ARG F 116      31.898  50.731  22.661  1.00 44.55           C  
ATOM   5776  C   ARG F 116      31.053  51.863  22.144  1.00 47.81           C  
ATOM   5777  O   ARG F 116      31.466  53.072  22.214  1.00 45.63           O  
ATOM   5778  CB  ARG F 116      31.645  50.636  24.156  1.00 38.07           C  
ATOM   5779  CG  ARG F 116      30.903  49.405  24.688  1.00 50.63           C  
ATOM   5780  CD  ARG F 116      31.065  49.367  26.227  1.00 77.28           C  
ATOM   5781  NE  ARG F 116      30.390  48.304  26.973  1.00 84.21           N  
ATOM   5782  CZ  ARG F 116      29.263  47.709  26.628  1.00 91.64           C  
ATOM   5783  NH1 ARG F 116      28.609  48.018  25.498  1.00 82.92           N  
ATOM   5784  NH2 ARG F 116      28.786  46.768  27.442  1.00 56.67           N  
ATOM   5785  N   ARG F 117      29.848  51.478  21.720  1.00 44.33           N  
ATOM   5786  CA  ARG F 117      28.879  52.406  21.187  1.00 47.25           C  
ATOM   5787  C   ARG F 117      27.475  52.328  21.851  1.00 53.66           C  
ATOM   5788  O   ARG F 117      26.958  51.247  22.244  1.00 54.44           O  
ATOM   5789  CB  ARG F 117      28.790  52.313  19.644  1.00 47.73           C  
ATOM   5790  CG  ARG F 117      30.010  52.878  18.886  1.00 61.69           C  
ATOM   5791  CD  ARG F 117      29.961  52.682  17.360  1.00 87.70           C  
ATOM   5792  NE  ARG F 117      31.255  52.266  16.779  1.00 98.72           N  
ATOM   5793  CZ  ARG F 117      31.826  52.766  15.664  1.00100.00           C  
ATOM   5794  NH1 ARG F 117      31.262  53.743  14.919  1.00100.00           N  
ATOM   5795  NH2 ARG F 117      33.016  52.299  15.283  1.00100.00           N  
ATOM   5796  N   LYS F 118      26.863  53.536  21.982  1.00 43.89           N  
ATOM   5797  CA  LYS F 118      25.490  53.665  22.412  1.00 37.25           C  
ATOM   5798  C   LYS F 118      24.784  54.737  21.666  1.00 33.41           C  
ATOM   5799  O   LYS F 118      25.287  55.865  21.549  1.00 34.06           O  
ATOM   5800  CB  LYS F 118      25.261  53.823  23.867  1.00 34.52           C  
ATOM   5801  CG  LYS F 118      23.820  53.521  24.198  1.00 25.46           C  
ATOM   5802  CD  LYS F 118      23.514  53.581  25.692  1.00 52.37           C  
ATOM   5803  CE  LYS F 118      22.051  53.236  25.990  1.00 80.78           C  
ATOM   5804  NZ  LYS F 118      21.670  53.381  27.411  1.00 64.86           N  
ATOM   5805  N   ASN F 119      23.611  54.399  21.193  1.00 28.62           N  
ATOM   5806  CA  ASN F 119      22.798  55.334  20.448  1.00 31.16           C  
ATOM   5807  C   ASN F 119      21.533  55.895  21.217  1.00 35.47           C  
ATOM   5808  O   ASN F 119      20.721  55.158  21.814  1.00 38.78           O  
ATOM   5809  CB  ASN F 119      22.384  54.731  19.124  1.00 35.75           C  
ATOM   5810  CG  ASN F 119      23.516  54.615  18.158  1.00 62.55           C  
ATOM   5811  OD1 ASN F 119      24.018  55.635  17.628  1.00 26.88           O  
ATOM   5812  ND2 ASN F 119      23.856  53.371  17.857  1.00 99.36           N  
ATOM   5813  N   LEU F 120      21.390  57.208  21.145  1.00 17.85           N  
ATOM   5814  CA  LEU F 120      20.285  57.935  21.660  1.00  9.93           C  
ATOM   5815  C   LEU F 120      19.632  58.609  20.495  1.00 20.42           C  
ATOM   5816  O   LEU F 120      20.197  59.518  19.869  1.00 21.92           O  
ATOM   5817  CB  LEU F 120      20.759  58.944  22.655  1.00  5.05           C  
ATOM   5818  CG  LEU F 120      21.065  58.216  23.902  1.00 12.83           C  
ATOM   5819  CD1 LEU F 120      21.202  59.164  25.112  1.00 18.85           C  
ATOM   5820  CD2 LEU F 120      19.964  57.196  24.122  1.00 11.09           C  
ATOM   5821  N   PRO F 121      18.505  58.091  20.113  1.00 10.54           N  
ATOM   5822  CA  PRO F 121      17.813  58.665  18.993  1.00  6.65           C  
ATOM   5823  C   PRO F 121      16.955  59.841  19.467  1.00 22.39           C  
ATOM   5824  O   PRO F 121      16.431  59.896  20.648  1.00 18.16           O  
ATOM   5825  CB  PRO F 121      16.922  57.572  18.411  1.00  4.35           C  
ATOM   5826  CG  PRO F 121      16.994  56.381  19.399  1.00  8.18           C  
ATOM   5827  CD  PRO F 121      17.990  56.746  20.484  1.00  4.48           C  
ATOM   5828  N   ILE F 122      16.849  60.796  18.586  1.00 21.96           N  
ATOM   5829  CA  ILE F 122      16.089  61.976  18.839  1.00 18.68           C  
ATOM   5830  C   ILE F 122      14.699  61.763  18.307  1.00 28.49           C  
ATOM   5831  O   ILE F 122      14.530  61.384  17.129  1.00 24.75           O  
ATOM   5832  CB  ILE F 122      16.729  63.155  18.097  1.00 21.79           C  
ATOM   5833  CG1 ILE F 122      17.863  63.758  18.903  1.00 16.54           C  
ATOM   5834  CG2 ILE F 122      15.690  64.217  17.743  1.00 32.35           C  
ATOM   5835  CD1 ILE F 122      18.571  62.716  19.726  1.00 29.86           C  
ATOM   5836  N   GLU F 123      13.693  62.006  19.188  1.00 29.09           N  
ATOM   5837  CA  GLU F 123      12.260  61.955  18.823  1.00 27.14           C  
ATOM   5838  C   GLU F 123      11.665  63.343  18.815  1.00 26.87           C  
ATOM   5839  O   GLU F 123      11.692  64.057  19.854  1.00 24.99           O  
ATOM   5840  CB  GLU F 123      11.467  61.087  19.763  1.00 29.53           C  
ATOM   5841  CG  GLU F 123      10.487  60.188  18.998  1.00 50.19           C  
ATOM   5842  CD  GLU F 123       9.767  59.212  19.890  1.00 98.96           C  
ATOM   5843  OE1 GLU F 123       8.869  59.541  20.664  1.00100.00           O  
ATOM   5844  OE2 GLU F 123      10.218  57.983  19.759  1.00 96.80           O  
ATOM   5845  N   TYR F 124      11.191  63.754  17.641  1.00 21.10           N  
ATOM   5846  CA  TYR F 124      10.607  65.063  17.512  1.00 29.04           C  
ATOM   5847  C   TYR F 124       9.099  65.025  17.819  1.00 49.58           C  
ATOM   5848  O   TYR F 124       8.331  64.294  17.181  1.00 55.38           O  
ATOM   5849  CB  TYR F 124      10.881  65.699  16.146  1.00 31.10           C  
ATOM   5850  CG  TYR F 124      12.318  66.063  15.912  1.00 33.18           C  
ATOM   5851  CD1 TYR F 124      12.907  67.144  16.562  1.00 36.34           C  
ATOM   5852  CD2 TYR F 124      13.081  65.361  14.993  1.00 37.61           C  
ATOM   5853  CE1 TYR F 124      14.235  67.494  16.333  1.00 38.29           C  
ATOM   5854  CE2 TYR F 124      14.412  65.695  14.747  1.00 42.34           C  
ATOM   5855  CZ  TYR F 124      14.991  66.776  15.416  1.00 43.16           C  
ATOM   5856  OH  TYR F 124      16.298  67.146  15.173  1.00 28.40           O  
ATOM   5857  N   ASN F 125       8.673  65.803  18.827  1.00 49.90           N  
ATOM   5858  CA  ASN F 125       7.267  65.859  19.272  1.00 46.36           C  
ATOM   5859  C   ASN F 125       6.577  67.104  18.814  1.00 44.87           C  
ATOM   5860  O   ASN F 125       6.901  68.219  19.291  1.00 47.92           O  
ATOM   5861  CB  ASN F 125       7.166  65.824  20.782  1.00 39.02           C  
ATOM   5862  CG  ASN F 125       5.768  65.563  21.215  1.00 33.19           C  
ATOM   5863  OD1 ASN F 125       4.947  65.049  20.427  1.00 34.05           O  
ATOM   5864  ND2 ASN F 125       5.496  65.894  22.479  1.00 30.70           N  
ATOM   5865  N   LEU F 126       5.579  66.914  17.965  1.00 30.80           N  
ATOM   5866  CA  LEU F 126       4.880  68.027  17.394  1.00 35.66           C  
ATOM   5867  C   LEU F 126       3.621  68.452  18.105  1.00 59.27           C  
ATOM   5868  O   LEU F 126       3.253  69.633  17.924  1.00 66.00           O  
ATOM   5869  CB  LEU F 126       4.638  67.796  15.913  1.00 34.31           C  
ATOM   5870  CG  LEU F 126       5.899  67.390  15.177  1.00 28.72           C  
ATOM   5871  CD1 LEU F 126       5.592  67.319  13.686  1.00 21.41           C  
ATOM   5872  CD2 LEU F 126       7.025  68.412  15.441  1.00 31.36           C  
ATOM   5873  OXT LEU F 126       2.980  67.586  18.754  1.00 80.21           O  
TER    5874      LEU F 126                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
