
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 2276),  selected  147 , name 2cri_A
# Molecule2: number of CA atoms   97 (  771),  selected   97 , name T0407_267_363.pdb
# PARAMETERS: 2cri_A.T0407_267_363.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E     267           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    K    10_A      D     268           #
LGA    -       -      L     269           -
LGA    -       -      L     270           -
LGA    H    11_A      R     271          3.221
LGA    E    12_A      P     272          3.116
LGA    Q    13_A      F     273          3.290
LGA    I    14_A      F     274          2.611
LGA    -       -      E     275           -
LGA    -       -      K     276           -
LGA    L    15_A      C     277          3.336
LGA    V    16_A      V     278          1.089
LGA    L    17_A      K     279          4.370
LGA    D    18_A      I     280          0.821
LGA    P    19_A      E     281          2.366
LGA    P    20_A      -       -           -
LGA    S    21_A      -       -           -
LGA    D    22_A      -       -           -
LGA    L    23_A      -       -           -
LGA    K    24_A      E     282          5.425
LGA    -       -      V     283           -
LGA    F    25_A      S     284          6.459
LGA    K    26_A      R     285          2.313
LGA    G    27_A      N     286          2.701
LGA    P    28_A      E     287          2.693
LGA    F    29_A      -       -           -
LGA    T    30_A      -       -           -
LGA    D    31_A      -       -           -
LGA    V    32_A      -       -           -
LGA    V    33_A      Q     288          0.987
LGA    T    34_A      G     289           #
LGA    T    35_A      V     290          2.130
LGA    N    36_A      T     291          2.075
LGA    L    37_A      L     292          2.381
LGA    K    38_A      S     293          1.939
LGA    L    39_A      I     294          1.930
LGA    Q    40_A      T     295          1.662
LGA    N    41_A      N     296          1.394
LGA    P    42_A      V     297          2.394
LGA    S    43_A      T     298          2.381
LGA    D    44_A      D     299          0.878
LGA    R    45_A      L     300          2.663
LGA    K    46_A      V     301          1.916
LGA    V    47_A      L     302          1.792
LGA    C    48_A      K     303          0.501
LGA    F    49_A      L     304          1.025
LGA    K    50_A      K     305          1.809
LGA    V    51_A      K     306          3.189
LGA    K    52_A      T     307          3.664
LGA    T    53_A      A     308           #
LGA    T    54_A      H     309          3.105
LGA    A    55_A      D     310          0.799
LGA    P    56_A      T     311          2.139
LGA    R    57_A      -       -           -
LGA    R    58_A      L     312          0.489
LGA    Y    59_A      L     313          1.772
LGA    C    60_A      V     314          1.707
LGA    V    61_A      Y     315          1.120
LGA    R    62_A      F     316          3.259
LGA    P    63_A      -       -           -
LGA    N    64_A      R     317          2.089
LGA    S    65_A      D     318          1.117
LGA    G    66_A      M     319          2.199
LGA    I    67_A      T     320          1.374
LGA    I    68_A      L     321          1.080
LGA    D    69_A      K     322          0.955
LGA    P    70_A      P     323          1.052
LGA    G    71_A      H     324          1.263
LGA    S    72_A      T     325          1.008
LGA    I    73_A      R     326          1.566
LGA    V    74_A      Y     327          1.576
LGA    T    75_A      T     328          1.597
LGA    V    76_A      V     329          1.908
LGA    S    77_A      R     330          2.154
LGA    V    78_A      I     331          1.457
LGA    M    79_A      G     332          1.449
LGA    L    80_A      F     333          1.237
LGA    Q    81_A      K     334          1.097
LGA    P    82_A      Q     335          3.049
LGA    F    83_A      G     336          1.654
LGA    D    84_A      I     337           #
LGA    Y    85_A      K     338          6.011
LGA    D    86_A      -       -           -
LGA    P    87_A      -       -           -
LGA    N    88_A      -       -           -
LGA    E    89_A      -       -           -
LGA    K    90_A      -       -           -
LGA    S    91_A      -       -           -
LGA    K    92_A      -       -           -
LGA    H    93_A      G     339           #
LGA    -       -      G     340           -
LGA    K    94_A      D     341          2.629
LGA    F    95_A      V     342          2.905
LGA    M    96_A      N     343          2.988
LGA    V    97_A      F     344          3.516
LGA    Q    98_A      E     345          2.502
LGA    T    99_A      V     346          1.887
LGA    -       -      T     347           -
LGA    I   100_A      N     348          2.792
LGA    F   101_A      F     349          5.062
LGA    A   102_A      -       -           -
LGA    P   103_A      -       -           -
LGA    P   104_A      -       -           -
LGA    N   105_A      -       -           -
LGA    I   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    M   109_A      -       -           -
LGA    E   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    V   112_A      -       -           -
LGA    W   113_A      I     350           #
LGA    K   114_A      V     351           -
LGA    -       -      A     352           -
LGA    E   115_A      P     353          6.513
LGA    A   116_A      D     354          2.736
LGA    K   117_A      K     355          1.738
LGA    P   118_A      -       -           -
LGA    D   119_A      -       -           -
LGA    E   120_A      -       -           -
LGA    L   121_A      G     356          2.227
LGA    M   122_A      L     357          2.329
LGA    D   123_A      K     358          3.250
LGA    S   124_A      Y     359          3.184
LGA    K   125_A      T     360          3.759
LGA    L   126_A      I     361          2.750
LGA    R   127_A      S     362          1.624
LGA    C   128_A      L     363          0.874
LGA    V   129_A      -       -           -
LGA    F   130_A      -       -           -
LGA    E   131_A      -       -           -
LGA    M   132_A      -       -           -
LGA    P   133_A      -       -           -
LGA    N   134_A      -       -           -
LGA    E   135_A      -       -           -
LGA    N   136_A      -       -           -
LGA    D   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    L   139_A      -       -           -
LGA    N   140_A      -       -           -
LGA    D   141_A      -       -           -
LGA    S   142_A      -       -           -
LGA    G   143_A      -       -           -
LGA    P   144_A      -       -           -
LGA    S   145_A      -       -           -
LGA    S   146_A      -       -           -
LGA    G   147_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147   97    5.0     81    2.63    12.35     58.692     2.969

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.019302 * X  +  -0.901287 * Y  +   0.432791 * Z  +  30.718737
  Y_new =  -0.939992 * X  +   0.131126 * Y  +   0.314993 * Z  +  60.700260
  Z_new =  -0.340649 * X  +  -0.412901 * Y  +  -0.844672 * Z  +  20.816101 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.686921    0.454671  [ DEG:  -153.9492     26.0508 ]
  Theta =   0.347608    2.793985  [ DEG:    19.9164    160.0836 ]
  Phi   =  -1.550264    1.591328  [ DEG:   -88.8236     91.1764 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cri_A                                        
REMARK     2: T0407_267_363.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cri_A.T0407_267_363.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147   97   5.0   81   2.63   12.35  58.692
REMARK  ---------------------------------------------------------- 
MOLECULE 2cri_A
HEADER    TRANSPORT PROTEIN                       20-MAY-05   2CRI              
TITLE     SOLUTION STRUCTURE OF THE MSP DOMAIN OF MOUSE VAMP-                   
TITLE    2 ASSOCIATED PROTEINA                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: VESICLE-ASSOCIATED MEMBRANE PROTEIN-ASSOCIATED             
COMPND   3 PROTEIN A;                                                           
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: MSP (RESIDUES 1-147);                                      
COMPND   6 SYNONYM: VAMP- ASSOCIATED PROTEIN A, VAMP-A, VAP-A, 33 KDA           
COMPND   7 VAMP-ASSOCIATED PROTEIN, VAP-33;                                     
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: VAPA, VAP33;                                                   
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040329-04;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    VAP-A, VAP-33, BETA SANDWITCH FOLD, STRUCTURAL GENOMICS,              
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.ENDO,F.HAYASHI,M.YOSHIDA,S.YOKOYAMA,RIKEN STRUCTURAL                
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   20-NOV-05 2CRI    0                                                
JRNL        AUTH   H.ENDO,F.HAYASHI,M.YOSHIDA,S.YOKOYAMA                        
JRNL        TITL   SOLUTION STRUCTURE OF THE MSP DOMAIN OF MOUSE                
JRNL        TITL 2 VAMP-ASSOCIATED PROTEINA                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2CRI A    8   141  UNP    Q9WV55   VAPA_MOUSE       1    134             
SEQRES   1 A  147  GLY SER SER GLY SER SER GLY MET ALA LYS HIS GLU GLN          
SEQRES   2 A  147  ILE LEU VAL LEU ASP PRO PRO SER ASP LEU LYS PHE LYS          
SEQRES   3 A  147  GLY PRO PHE THR ASP VAL VAL THR THR ASN LEU LYS LEU          
SEQRES   4 A  147  GLN ASN PRO SER ASP ARG LYS VAL CYS PHE LYS VAL LYS          
SEQRES   5 A  147  THR THR ALA PRO ARG ARG TYR CYS VAL ARG PRO ASN SER          
SEQRES   6 A  147  GLY ILE ILE ASP PRO GLY SER ILE VAL THR VAL SER VAL          
SEQRES   7 A  147  MET LEU GLN PRO PHE ASP TYR ASP PRO ASN GLU LYS SER          
SEQRES   8 A  147  LYS HIS LYS PHE MET VAL GLN THR ILE PHE ALA PRO PRO          
SEQRES   9 A  147  ASN ILE SER ASP MET GLU ALA VAL TRP LYS GLU ALA LYS          
SEQRES  10 A  147  PRO ASP GLU LEU MET ASP SER LYS LEU ARG CYS VAL PHE          
SEQRES  11 A  147  GLU MET PRO ASN GLU ASN ASP LYS LEU ASN ASP SER GLY          
SEQRES  12 A  147  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      11.373  54.659  35.853  1.00  0.00           N  
ATOM      2  CA  GLY A   1      12.129  53.661  35.119  1.00  0.00           C  
ATOM      3  C   GLY A   1      11.774  52.247  35.531  1.00  0.00           C  
ATOM      4  O   GLY A   1      11.346  52.010  36.660  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      11.930  53.778  34.064  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      13.182  53.821  35.297  1.00  0.00           H  
ATOM      7  H1  GLY A   1      10.483  54.440  36.199  1.00  0.00           H  
ATOM      8  N   SER A   2      11.951  51.302  34.612  1.00  0.00           N  
ATOM      9  CA  SER A   2      11.641  49.903  34.884  1.00  0.00           C  
ATOM     10  C   SER A   2      12.520  48.979  34.047  1.00  0.00           C  
ATOM     11  O   SER A   2      12.479  49.011  32.817  1.00  0.00           O  
ATOM     12  CB  SER A   2      10.165  49.621  34.596  1.00  0.00           C  
ATOM     13  OG  SER A   2       9.727  48.457  35.275  1.00  0.00           O  
ATOM     14  H   SER A   2      12.297  51.553  33.730  1.00  0.00           H  
ATOM     15  HA  SER A   2      11.837  49.717  35.930  1.00  0.00           H  
ATOM     16  HB2 SER A   2       9.570  50.460  34.924  1.00  0.00           H  
ATOM     17  HB3 SER A   2      10.030  49.476  33.534  1.00  0.00           H  
ATOM     18  HG  SER A   2       8.828  48.587  35.585  1.00  0.00           H  
ATOM     19  N   SER A   3      13.317  48.157  34.724  1.00  0.00           N  
ATOM     20  CA  SER A   3      14.210  47.226  34.043  1.00  0.00           C  
ATOM     21  C   SER A   3      13.454  46.418  32.993  1.00  0.00           C  
ATOM     22  O   SER A   3      12.456  45.765  33.294  1.00  0.00           O  
ATOM     23  CB  SER A   3      14.864  46.283  35.055  1.00  0.00           C  
ATOM     24  OG  SER A   3      15.897  46.939  35.769  1.00  0.00           O  
ATOM     25  H   SER A   3      13.305  48.179  35.704  1.00  0.00           H  
ATOM     26  HA  SER A   3      14.979  47.804  33.553  1.00  0.00           H  
ATOM     27  HB2 SER A   3      14.119  45.939  35.757  1.00  0.00           H  
ATOM     28  HB3 SER A   3      15.284  45.436  34.532  1.00  0.00           H  
ATOM     29  HG  SER A   3      16.601  46.314  35.959  1.00  0.00           H  
ATOM     30  N   GLY A   4      13.938  46.469  31.755  1.00  0.00           N  
ATOM     31  CA  GLY A   4      13.298  45.739  30.677  1.00  0.00           C  
ATOM     32  C   GLY A   4      14.092  45.794  29.387  1.00  0.00           C  
ATOM     33  O   GLY A   4      14.188  46.845  28.755  1.00  0.00           O  
ATOM     34  H   GLY A   4      14.737  47.007  31.573  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      13.183  44.707  30.974  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      12.320  46.162  30.502  1.00  0.00           H  
ATOM     37  N   SER A   5      14.662  44.659  28.997  1.00  0.00           N  
ATOM     38  CA  SER A   5      15.458  44.583  27.777  1.00  0.00           C  
ATOM     39  C   SER A   5      14.646  43.976  26.637  1.00  0.00           C  
ATOM     40  O   SER A   5      13.916  43.004  26.829  1.00  0.00           O  
ATOM     41  CB  SER A   5      16.721  43.756  28.016  1.00  0.00           C  
ATOM     42  OG  SER A   5      17.340  43.403  26.791  1.00  0.00           O  
ATOM     43  H   SER A   5      14.549  43.854  29.544  1.00  0.00           H  
ATOM     44  HA  SER A   5      15.742  45.588  27.504  1.00  0.00           H  
ATOM     45  HB2 SER A   5      17.419  44.330  28.605  1.00  0.00           H  
ATOM     46  HB3 SER A   5      16.460  42.851  28.548  1.00  0.00           H  
ATOM     47  HG  SER A   5      17.379  44.173  26.219  1.00  0.00           H  
ATOM     48  N   SER A   6      14.780  44.557  25.448  1.00  0.00           N  
ATOM     49  CA  SER A   6      14.057  44.076  24.277  1.00  0.00           C  
ATOM     50  C   SER A   6      15.011  43.428  23.278  1.00  0.00           C  
ATOM     51  O   SER A   6      15.547  44.095  22.393  1.00  0.00           O  
ATOM     52  CB  SER A   6      13.304  45.227  23.609  1.00  0.00           C  
ATOM     53  OG  SER A   6      14.182  46.291  23.285  1.00  0.00           O  
ATOM     54  H   SER A   6      15.377  45.329  25.358  1.00  0.00           H  
ATOM     55  HA  SER A   6      13.344  43.335  24.608  1.00  0.00           H  
ATOM     56  HB2 SER A   6      12.839  44.872  22.701  1.00  0.00           H  
ATOM     57  HB3 SER A   6      12.543  45.595  24.282  1.00  0.00           H  
ATOM     58  HG  SER A   6      13.707  46.956  22.780  1.00  0.00           H  
ATOM     59  N   GLY A   7      15.218  42.123  23.425  1.00  0.00           N  
ATOM     60  CA  GLY A   7      16.107  41.407  22.530  1.00  0.00           C  
ATOM     61  C   GLY A   7      17.522  41.319  23.066  1.00  0.00           C  
ATOM     62  O   GLY A   7      17.963  42.189  23.817  1.00  0.00           O  
ATOM     63  H   GLY A   7      14.763  41.643  24.150  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      15.725  40.407  22.386  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      16.126  41.916  21.578  1.00  0.00           H  
ATOM     66  N   MET A   8      18.235  40.266  22.681  1.00  0.00           N  
ATOM     67  CA  MET A   8      19.608  40.067  23.128  1.00  0.00           C  
ATOM     68  C   MET A   8      20.587  40.242  21.972  1.00  0.00           C  
ATOM     69  O   MET A   8      20.487  39.561  20.952  1.00  0.00           O  
ATOM     70  CB  MET A   8      19.771  38.676  23.743  1.00  0.00           C  
ATOM     71  CG  MET A   8      19.489  38.635  25.236  1.00  0.00           C  
ATOM     72  SD  MET A   8      20.879  39.220  26.224  1.00  0.00           S  
ATOM     73  CE  MET A   8      20.089  39.460  27.813  1.00  0.00           C  
ATOM     74  H   MET A   8      17.828  39.606  22.081  1.00  0.00           H  
ATOM     75  HA  MET A   8      19.822  40.811  23.881  1.00  0.00           H  
ATOM     76  HB2 MET A   8      19.093  37.996  23.251  1.00  0.00           H  
ATOM     77  HB3 MET A   8      20.785  38.340  23.582  1.00  0.00           H  
ATOM     78  HG2 MET A   8      18.631  39.258  25.444  1.00  0.00           H  
ATOM     79  HG3 MET A   8      19.267  37.616  25.518  1.00  0.00           H  
ATOM     80  HE1 MET A   8      19.659  40.449  27.856  1.00  0.00           H  
ATOM     81  HE2 MET A   8      19.310  38.723  27.943  1.00  0.00           H  
ATOM     82  HE3 MET A   8      20.822  39.351  28.599  1.00  0.00           H  
ATOM     83  N   ALA A   9      21.534  41.160  22.137  1.00  0.00           N  
ATOM     84  CA  ALA A   9      22.532  41.424  21.109  1.00  0.00           C  
ATOM     85  C   ALA A   9      23.941  41.401  21.691  1.00  0.00           C  
ATOM     86  O   ALA A   9      24.121  41.286  22.903  1.00  0.00           O  
ATOM     87  CB  ALA A   9      22.258  42.761  20.437  1.00  0.00           C  
ATOM     88  H   ALA A   9      21.562  41.672  22.973  1.00  0.00           H  
ATOM     89  HA  ALA A   9      22.451  40.649  20.359  1.00  0.00           H  
ATOM     90  HB1 ALA A   9      22.073  43.511  21.192  1.00  0.00           H  
ATOM     91  HB2 ALA A   9      23.114  43.049  19.845  1.00  0.00           H  
ATOM     92  HB3 ALA A   9      21.391  42.672  19.798  1.00  0.00           H  
ATOM     93  N   LYS A  10      24.939  41.512  20.820  1.00  0.00           N  
ATOM     94  CA  LYS A  10      26.332  41.505  21.247  1.00  0.00           C  
ATOM     95  C   LYS A  10      26.885  42.925  21.324  1.00  0.00           C  
ATOM     96  O   LYS A  10      27.003  43.611  20.308  1.00  0.00           O  
ATOM     97  CB  LYS A  10      27.178  40.669  20.284  1.00  0.00           C  
ATOM     98  CG  LYS A  10      27.152  39.180  20.587  1.00  0.00           C  
ATOM     99  CD  LYS A  10      25.869  38.534  20.093  1.00  0.00           C  
ATOM    100  CE  LYS A  10      25.972  38.138  18.628  1.00  0.00           C  
ATOM    101  NZ  LYS A  10      24.702  37.549  18.122  1.00  0.00           N  
ATOM    102  H   LYS A  10      24.731  41.601  19.865  1.00  0.00           H  
ATOM    103  HA  LYS A  10      26.376  41.061  22.230  1.00  0.00           H  
ATOM    104  HB2 LYS A  10      26.810  40.817  19.280  1.00  0.00           H  
ATOM    105  HB3 LYS A  10      28.203  41.007  20.337  1.00  0.00           H  
ATOM    106  HG2 LYS A  10      27.992  38.708  20.099  1.00  0.00           H  
ATOM    107  HG3 LYS A  10      27.228  39.039  21.657  1.00  0.00           H  
ATOM    108  HD2 LYS A  10      25.673  37.648  20.680  1.00  0.00           H  
ATOM    109  HD3 LYS A  10      25.054  39.234  20.212  1.00  0.00           H  
ATOM    110  HE2 LYS A  10      26.207  39.017  18.048  1.00  0.00           H  
ATOM    111  HE3 LYS A  10      26.765  37.413  18.520  1.00  0.00           H  
ATOM    112  HZ1 LYS A  10      24.260  38.189  17.433  1.00  0.00           H  
ATOM    113  HZ2 LYS A  10      24.041  37.395  18.910  1.00  0.00           H  
ATOM    114  HZ3 LYS A  10      24.890  36.636  17.659  1.00  0.00           H  
ATOM    115  N   HIS A  11      27.224  43.359  22.534  1.00  0.00           N  
ATOM    116  CA  HIS A  11      27.765  44.697  22.742  1.00  0.00           C  
ATOM    117  C   HIS A  11      28.627  44.743  24.001  1.00  0.00           C  
ATOM    118  O   HIS A  11      28.155  44.444  25.097  1.00  0.00           O  
ATOM    119  CB  HIS A  11      26.634  45.719  22.846  1.00  0.00           C  
ATOM    120  CG  HIS A  11      25.886  45.655  24.143  1.00  0.00           C  
ATOM    121  ND1 HIS A  11      25.404  44.479  24.677  1.00  0.00           N  
ATOM    122  CD2 HIS A  11      25.542  46.632  25.015  1.00  0.00           C  
ATOM    123  CE1 HIS A  11      24.793  44.734  25.820  1.00  0.00           C  
ATOM    124  NE2 HIS A  11      24.863  46.034  26.049  1.00  0.00           N  
ATOM    125  H   HIS A  11      27.106  42.765  23.304  1.00  0.00           H  
ATOM    126  HA  HIS A  11      28.382  44.940  21.890  1.00  0.00           H  
ATOM    127  HB2 HIS A  11      27.045  46.712  22.749  1.00  0.00           H  
ATOM    128  HB3 HIS A  11      25.926  45.546  22.047  1.00  0.00           H  
ATOM    129  HD1 HIS A  11      25.494  43.590  24.277  1.00  0.00           H  
ATOM    130  HD2 HIS A  11      25.760  47.686  24.916  1.00  0.00           H  
ATOM    131  HE1 HIS A  11      24.318  44.006  26.460  1.00  0.00           H  
ATOM    132  HE2 HIS A  11      24.418  46.501  26.785  1.00  0.00           H  
ATOM    133  N   GLU A  12      29.890  45.120  23.834  1.00  0.00           N  
ATOM    134  CA  GLU A  12      30.817  45.205  24.957  1.00  0.00           C  
ATOM    135  C   GLU A  12      31.023  46.655  25.384  1.00  0.00           C  
ATOM    136  O   GLU A  12      31.799  47.389  24.772  1.00  0.00           O  
ATOM    137  CB  GLU A  12      32.160  44.575  24.587  1.00  0.00           C  
ATOM    138  CG  GLU A  12      33.008  44.199  25.791  1.00  0.00           C  
ATOM    139  CD  GLU A  12      32.491  42.966  26.506  1.00  0.00           C  
ATOM    140  OE1 GLU A  12      32.521  41.873  25.902  1.00  0.00           O  
ATOM    141  OE2 GLU A  12      32.056  43.093  27.669  1.00  0.00           O  
ATOM    142  H   GLU A  12      30.207  45.347  22.935  1.00  0.00           H  
ATOM    143  HA  GLU A  12      30.388  44.657  25.783  1.00  0.00           H  
ATOM    144  HB2 GLU A  12      31.979  43.681  24.007  1.00  0.00           H  
ATOM    145  HB3 GLU A  12      32.719  45.276  23.985  1.00  0.00           H  
ATOM    146  HG2 GLU A  12      34.018  44.005  25.458  1.00  0.00           H  
ATOM    147  HG3 GLU A  12      33.012  45.026  26.486  1.00  0.00           H  
ATOM    148  N   GLN A  13      30.323  47.061  26.439  1.00  0.00           N  
ATOM    149  CA  GLN A  13      30.429  48.423  26.948  1.00  0.00           C  
ATOM    150  C   GLN A  13      30.764  48.425  28.435  1.00  0.00           C  
ATOM    151  O   GLN A  13      30.322  47.550  29.182  1.00  0.00           O  
ATOM    152  CB  GLN A  13      29.123  49.183  26.706  1.00  0.00           C  
ATOM    153  CG  GLN A  13      29.024  50.485  27.484  1.00  0.00           C  
ATOM    154  CD  GLN A  13      28.134  51.505  26.802  1.00  0.00           C  
ATOM    155  OE1 GLN A  13      26.908  51.427  26.881  1.00  0.00           O  
ATOM    156  NE2 GLN A  13      28.748  52.471  26.130  1.00  0.00           N  
ATOM    157  H   GLN A  13      29.722  46.429  26.885  1.00  0.00           H  
ATOM    158  HA  GLN A  13      31.226  48.916  26.412  1.00  0.00           H  
ATOM    159  HB2 GLN A  13      29.043  49.411  25.653  1.00  0.00           H  
ATOM    160  HB3 GLN A  13      28.295  48.552  26.993  1.00  0.00           H  
ATOM    161  HG2 GLN A  13      28.619  50.274  28.463  1.00  0.00           H  
ATOM    162  HG3 GLN A  13      30.014  50.904  27.587  1.00  0.00           H  
ATOM    163 HE21 GLN A  13      29.728  52.470  26.109  1.00  0.00           H  
ATOM    164 HE22 GLN A  13      28.197  53.144  25.679  1.00  0.00           H  
ATOM    165  N   ILE A  14      31.545  49.412  28.860  1.00  0.00           N  
ATOM    166  CA  ILE A  14      31.938  49.526  30.260  1.00  0.00           C  
ATOM    167  C   ILE A  14      31.214  50.684  30.940  1.00  0.00           C  
ATOM    168  O   ILE A  14      30.902  50.622  32.130  1.00  0.00           O  
ATOM    169  CB  ILE A  14      33.457  49.730  30.403  1.00  0.00           C  
ATOM    170  CG1 ILE A  14      33.860  49.705  31.879  1.00  0.00           C  
ATOM    171  CG2 ILE A  14      33.879  51.040  29.756  1.00  0.00           C  
ATOM    172  CD1 ILE A  14      33.565  48.388  32.562  1.00  0.00           C  
ATOM    173  H   ILE A  14      31.865  50.079  28.218  1.00  0.00           H  
ATOM    174  HA  ILE A  14      31.669  48.606  30.757  1.00  0.00           H  
ATOM    175  HB  ILE A  14      33.956  48.924  29.887  1.00  0.00           H  
ATOM    176 HG12 ILE A  14      34.920  49.890  31.960  1.00  0.00           H  
ATOM    177 HG13 ILE A  14      33.322  50.480  32.404  1.00  0.00           H  
ATOM    178 HG21 ILE A  14      33.664  51.005  28.698  1.00  0.00           H  
ATOM    179 HG22 ILE A  14      33.334  51.856  30.206  1.00  0.00           H  
ATOM    180 HG23 ILE A  14      34.939  51.190  29.902  1.00  0.00           H  
ATOM    181 HD11 ILE A  14      34.403  48.109  33.185  1.00  0.00           H  
ATOM    182 HD12 ILE A  14      32.681  48.488  33.173  1.00  0.00           H  
ATOM    183 HD13 ILE A  14      33.403  47.623  31.816  1.00  0.00           H  
ATOM    184  N   LEU A  15      30.949  51.739  30.177  1.00  0.00           N  
ATOM    185  CA  LEU A  15      30.261  52.911  30.706  1.00  0.00           C  
ATOM    186  C   LEU A  15      28.751  52.781  30.530  1.00  0.00           C  
ATOM    187  O   LEU A  15      28.261  52.567  29.421  1.00  0.00           O  
ATOM    188  CB  LEU A  15      30.759  54.178  30.008  1.00  0.00           C  
ATOM    189  CG  LEU A  15      32.017  54.818  30.597  1.00  0.00           C  
ATOM    190  CD1 LEU A  15      32.231  56.207  30.016  1.00  0.00           C  
ATOM    191  CD2 LEU A  15      31.921  54.881  32.115  1.00  0.00           C  
ATOM    192  H   LEU A  15      31.222  51.730  29.237  1.00  0.00           H  
ATOM    193  HA  LEU A  15      30.483  52.979  31.760  1.00  0.00           H  
ATOM    194  HB2 LEU A  15      30.967  53.928  28.978  1.00  0.00           H  
ATOM    195  HB3 LEU A  15      29.965  54.910  30.046  1.00  0.00           H  
ATOM    196  HG  LEU A  15      32.875  54.213  30.340  1.00  0.00           H  
ATOM    197 HD11 LEU A  15      31.284  56.612  29.693  1.00  0.00           H  
ATOM    198 HD12 LEU A  15      32.902  56.144  29.173  1.00  0.00           H  
ATOM    199 HD13 LEU A  15      32.660  56.850  30.771  1.00  0.00           H  
ATOM    200 HD21 LEU A  15      32.538  55.689  32.480  1.00  0.00           H  
ATOM    201 HD22 LEU A  15      32.264  53.948  32.536  1.00  0.00           H  
ATOM    202 HD23 LEU A  15      30.895  55.054  32.404  1.00  0.00           H  
ATOM    203  N   VAL A  16      28.018  52.915  31.631  1.00  0.00           N  
ATOM    204  CA  VAL A  16      26.564  52.816  31.598  1.00  0.00           C  
ATOM    205  C   VAL A  16      25.929  54.161  31.267  1.00  0.00           C  
ATOM    206  O   VAL A  16      25.871  55.058  32.110  1.00  0.00           O  
ATOM    207  CB  VAL A  16      26.005  52.314  32.943  1.00  0.00           C  
ATOM    208  CG1 VAL A  16      24.502  52.098  32.850  1.00  0.00           C  
ATOM    209  CG2 VAL A  16      26.711  51.036  33.369  1.00  0.00           C  
ATOM    210  H   VAL A  16      28.467  53.085  32.485  1.00  0.00           H  
ATOM    211  HA  VAL A  16      26.295  52.103  30.832  1.00  0.00           H  
ATOM    212  HB  VAL A  16      26.192  53.070  33.691  1.00  0.00           H  
ATOM    213 HG11 VAL A  16      23.990  52.987  33.188  1.00  0.00           H  
ATOM    214 HG12 VAL A  16      24.231  51.892  31.825  1.00  0.00           H  
ATOM    215 HG13 VAL A  16      24.220  51.262  33.472  1.00  0.00           H  
ATOM    216 HG21 VAL A  16      26.356  50.212  32.767  1.00  0.00           H  
ATOM    217 HG22 VAL A  16      27.777  51.149  33.232  1.00  0.00           H  
ATOM    218 HG23 VAL A  16      26.501  50.837  34.410  1.00  0.00           H  
ATOM    219  N   LEU A  17      25.452  54.296  30.034  1.00  0.00           N  
ATOM    220  CA  LEU A  17      24.819  55.534  29.589  1.00  0.00           C  
ATOM    221  C   LEU A  17      23.473  55.735  30.279  1.00  0.00           C  
ATOM    222  O   LEU A  17      22.777  54.771  30.596  1.00  0.00           O  
ATOM    223  CB  LEU A  17      24.630  55.516  28.072  1.00  0.00           C  
ATOM    224  CG  LEU A  17      25.806  56.035  27.243  1.00  0.00           C  
ATOM    225  CD1 LEU A  17      26.864  54.954  27.082  1.00  0.00           C  
ATOM    226  CD2 LEU A  17      25.326  56.521  25.883  1.00  0.00           C  
ATOM    227  H   LEU A  17      25.527  53.547  29.407  1.00  0.00           H  
ATOM    228  HA  LEU A  17      25.472  56.352  29.854  1.00  0.00           H  
ATOM    229  HB2 LEU A  17      24.440  54.496  27.775  1.00  0.00           H  
ATOM    230  HB3 LEU A  17      23.767  56.124  27.840  1.00  0.00           H  
ATOM    231  HG  LEU A  17      26.259  56.871  27.757  1.00  0.00           H  
ATOM    232 HD11 LEU A  17      26.392  54.033  26.772  1.00  0.00           H  
ATOM    233 HD12 LEU A  17      27.369  54.801  28.024  1.00  0.00           H  
ATOM    234 HD13 LEU A  17      27.580  55.260  26.334  1.00  0.00           H  
ATOM    235 HD21 LEU A  17      24.904  55.694  25.334  1.00  0.00           H  
ATOM    236 HD22 LEU A  17      26.161  56.931  25.333  1.00  0.00           H  
ATOM    237 HD23 LEU A  17      24.575  57.285  26.019  1.00  0.00           H  
ATOM    238  N   ASP A  18      23.113  56.994  30.505  1.00  0.00           N  
ATOM    239  CA  ASP A  18      21.849  57.322  31.154  1.00  0.00           C  
ATOM    240  C   ASP A  18      21.229  58.570  30.534  1.00  0.00           C  
ATOM    241  O   ASP A  18      21.811  59.655  30.547  1.00  0.00           O  
ATOM    242  CB  ASP A  18      22.061  57.533  32.654  1.00  0.00           C  
ATOM    243  CG  ASP A  18      22.121  56.226  33.420  1.00  0.00           C  
ATOM    244  OD1 ASP A  18      21.050  55.710  33.797  1.00  0.00           O  
ATOM    245  OD2 ASP A  18      23.242  55.721  33.643  1.00  0.00           O  
ATOM    246  H   ASP A  18      23.712  57.719  30.228  1.00  0.00           H  
ATOM    247  HA  ASP A  18      21.176  56.490  31.008  1.00  0.00           H  
ATOM    248  HB2 ASP A  18      22.990  58.064  32.808  1.00  0.00           H  
ATOM    249  HB3 ASP A  18      21.245  58.123  33.046  1.00  0.00           H  
ATOM    250  N   PRO A  19      20.019  58.415  29.976  1.00  0.00           N  
ATOM    251  CA  PRO A  19      19.316  57.128  29.953  1.00  0.00           C  
ATOM    252  C   PRO A  19      19.982  56.120  29.024  1.00  0.00           C  
ATOM    253  O   PRO A  19      20.397  56.446  27.911  1.00  0.00           O  
ATOM    254  CB  PRO A  19      17.923  57.494  29.436  1.00  0.00           C  
ATOM    255  CG  PRO A  19      18.128  58.739  28.644  1.00  0.00           C  
ATOM    256  CD  PRO A  19      19.244  59.484  29.324  1.00  0.00           C  
ATOM    257  HA  PRO A  19      19.235  56.704  30.943  1.00  0.00           H  
ATOM    258  HB2 PRO A  19      17.543  56.691  28.820  1.00  0.00           H  
ATOM    259  HB3 PRO A  19      17.257  57.662  30.269  1.00  0.00           H  
ATOM    260  HG2 PRO A  19      18.406  58.489  27.632  1.00  0.00           H  
ATOM    261  HG3 PRO A  19      17.224  59.331  28.650  1.00  0.00           H  
ATOM    262  HD2 PRO A  19      19.846  60.007  28.597  1.00  0.00           H  
ATOM    263  HD3 PRO A  19      18.847  60.172  30.055  1.00  0.00           H  
ATOM    264  N   PRO A  20      20.089  54.866  29.487  1.00  0.00           N  
ATOM    265  CA  PRO A  20      20.703  53.785  28.712  1.00  0.00           C  
ATOM    266  C   PRO A  20      19.853  53.374  27.514  1.00  0.00           C  
ATOM    267  O   PRO A  20      20.377  52.946  26.486  1.00  0.00           O  
ATOM    268  CB  PRO A  20      20.799  52.636  29.719  1.00  0.00           C  
ATOM    269  CG  PRO A  20      19.721  52.910  30.709  1.00  0.00           C  
ATOM    270  CD  PRO A  20      19.616  54.408  30.805  1.00  0.00           C  
ATOM    271  HA  PRO A  20      21.694  54.053  28.373  1.00  0.00           H  
ATOM    272  HB2 PRO A  20      20.640  51.695  29.210  1.00  0.00           H  
ATOM    273  HB3 PRO A  20      21.773  52.641  30.184  1.00  0.00           H  
ATOM    274  HG2 PRO A  20      18.788  52.491  30.364  1.00  0.00           H  
ATOM    275  HG3 PRO A  20      19.989  52.493  31.669  1.00  0.00           H  
ATOM    276  HD2 PRO A  20      18.592  54.705  30.972  1.00  0.00           H  
ATOM    277  HD3 PRO A  20      20.254  54.781  31.593  1.00  0.00           H  
ATOM    278  N   SER A  21      18.538  53.509  27.654  1.00  0.00           N  
ATOM    279  CA  SER A  21      17.614  53.149  26.585  1.00  0.00           C  
ATOM    280  C   SER A  21      17.604  54.214  25.494  1.00  0.00           C  
ATOM    281  O   SER A  21      18.172  54.023  24.418  1.00  0.00           O  
ATOM    282  CB  SER A  21      16.202  52.961  27.144  1.00  0.00           C  
ATOM    283  OG  SER A  21      16.089  51.733  27.842  1.00  0.00           O  
ATOM    284  H   SER A  21      18.180  53.856  28.499  1.00  0.00           H  
ATOM    285  HA  SER A  21      17.950  52.216  26.158  1.00  0.00           H  
ATOM    286  HB2 SER A  21      15.976  53.769  27.822  1.00  0.00           H  
ATOM    287  HB3 SER A  21      15.492  52.966  26.329  1.00  0.00           H  
ATOM    288  HG  SER A  21      15.684  51.888  28.699  1.00  0.00           H  
ATOM    289  N   ASP A  22      16.955  55.337  25.779  1.00  0.00           N  
ATOM    290  CA  ASP A  22      16.870  56.436  24.823  1.00  0.00           C  
ATOM    291  C   ASP A  22      16.947  57.783  25.535  1.00  0.00           C  
ATOM    292  O   ASP A  22      16.490  57.925  26.670  1.00  0.00           O  
ATOM    293  CB  ASP A  22      15.572  56.343  24.020  1.00  0.00           C  
ATOM    294  CG  ASP A  22      14.410  55.840  24.854  1.00  0.00           C  
ATOM    295  OD1 ASP A  22      14.454  54.672  25.290  1.00  0.00           O  
ATOM    296  OD2 ASP A  22      13.457  56.617  25.071  1.00  0.00           O  
ATOM    297  H   ASP A  22      16.521  55.431  26.653  1.00  0.00           H  
ATOM    298  HA  ASP A  22      17.708  56.352  24.147  1.00  0.00           H  
ATOM    299  HB2 ASP A  22      15.321  57.322  23.640  1.00  0.00           H  
ATOM    300  HB3 ASP A  22      15.717  55.665  23.191  1.00  0.00           H  
ATOM    301  N   LEU A  23      17.529  58.770  24.862  1.00  0.00           N  
ATOM    302  CA  LEU A  23      17.667  60.106  25.430  1.00  0.00           C  
ATOM    303  C   LEU A  23      16.539  61.017  24.959  1.00  0.00           C  
ATOM    304  O   LEU A  23      16.511  61.443  23.804  1.00  0.00           O  
ATOM    305  CB  LEU A  23      19.020  60.708  25.044  1.00  0.00           C  
ATOM    306  CG  LEU A  23      19.204  62.195  25.348  1.00  0.00           C  
ATOM    307  CD1 LEU A  23      19.358  62.420  26.844  1.00  0.00           C  
ATOM    308  CD2 LEU A  23      20.405  62.748  24.597  1.00  0.00           C  
ATOM    309  H   LEU A  23      17.874  58.596  23.962  1.00  0.00           H  
ATOM    310  HA  LEU A  23      17.617  60.015  26.505  1.00  0.00           H  
ATOM    311  HB2 LEU A  23      19.787  60.165  25.574  1.00  0.00           H  
ATOM    312  HB3 LEU A  23      19.152  60.568  23.981  1.00  0.00           H  
ATOM    313  HG  LEU A  23      18.326  62.734  25.019  1.00  0.00           H  
ATOM    314 HD11 LEU A  23      20.329  62.845  27.046  1.00  0.00           H  
ATOM    315 HD12 LEU A  23      19.265  61.475  27.361  1.00  0.00           H  
ATOM    316 HD13 LEU A  23      18.589  63.095  27.189  1.00  0.00           H  
ATOM    317 HD21 LEU A  23      20.567  62.169  23.700  1.00  0.00           H  
ATOM    318 HD22 LEU A  23      21.282  62.690  25.227  1.00  0.00           H  
ATOM    319 HD23 LEU A  23      20.221  63.779  24.331  1.00  0.00           H  
ATOM    320  N   LYS A  24      15.611  61.316  25.861  1.00  0.00           N  
ATOM    321  CA  LYS A  24      14.481  62.179  25.540  1.00  0.00           C  
ATOM    322  C   LYS A  24      14.931  63.627  25.378  1.00  0.00           C  
ATOM    323  O   LYS A  24      15.944  64.040  25.946  1.00  0.00           O  
ATOM    324  CB  LYS A  24      13.414  62.087  26.634  1.00  0.00           C  
ATOM    325  CG  LYS A  24      12.386  60.996  26.389  1.00  0.00           C  
ATOM    326  CD  LYS A  24      11.514  60.767  27.612  1.00  0.00           C  
ATOM    327  CE  LYS A  24      10.623  59.547  27.440  1.00  0.00           C  
ATOM    328  NZ  LYS A  24      10.023  59.111  28.732  1.00  0.00           N  
ATOM    329  H   LYS A  24      15.687  60.946  26.766  1.00  0.00           H  
ATOM    330  HA  LYS A  24      14.058  61.840  24.607  1.00  0.00           H  
ATOM    331  HB2 LYS A  24      13.900  61.889  27.578  1.00  0.00           H  
ATOM    332  HB3 LYS A  24      12.896  63.033  26.697  1.00  0.00           H  
ATOM    333  HG2 LYS A  24      11.757  61.286  25.561  1.00  0.00           H  
ATOM    334  HG3 LYS A  24      12.900  60.076  26.147  1.00  0.00           H  
ATOM    335  HD2 LYS A  24      12.148  60.617  28.473  1.00  0.00           H  
ATOM    336  HD3 LYS A  24      10.892  61.637  27.768  1.00  0.00           H  
ATOM    337  HE2 LYS A  24       9.830  59.790  26.749  1.00  0.00           H  
ATOM    338  HE3 LYS A  24      11.215  58.738  27.037  1.00  0.00           H  
ATOM    339  HZ1 LYS A  24      10.564  58.315  29.126  1.00  0.00           H  
ATOM    340  HZ2 LYS A  24       9.039  58.806  28.586  1.00  0.00           H  
ATOM    341  HZ3 LYS A  24      10.034  59.896  29.414  1.00  0.00           H  
ATOM    342  N   PHE A  25      14.174  64.395  24.602  1.00  0.00           N  
ATOM    343  CA  PHE A  25      14.496  65.798  24.365  1.00  0.00           C  
ATOM    344  C   PHE A  25      13.282  66.686  24.621  1.00  0.00           C  
ATOM    345  O   PHE A  25      12.256  66.563  23.951  1.00  0.00           O  
ATOM    346  CB  PHE A  25      14.994  65.995  22.932  1.00  0.00           C  
ATOM    347  CG  PHE A  25      16.449  65.668  22.752  1.00  0.00           C  
ATOM    348  CD1 PHE A  25      16.872  64.352  22.666  1.00  0.00           C  
ATOM    349  CD2 PHE A  25      17.394  66.679  22.668  1.00  0.00           C  
ATOM    350  CE1 PHE A  25      18.210  64.050  22.501  1.00  0.00           C  
ATOM    351  CE2 PHE A  25      18.733  66.382  22.503  1.00  0.00           C  
ATOM    352  CZ  PHE A  25      19.142  65.066  22.419  1.00  0.00           C  
ATOM    353  H   PHE A  25      13.379  64.009  24.177  1.00  0.00           H  
ATOM    354  HA  PHE A  25      15.282  66.076  25.051  1.00  0.00           H  
ATOM    355  HB2 PHE A  25      14.427  65.355  22.272  1.00  0.00           H  
ATOM    356  HB3 PHE A  25      14.845  67.024  22.645  1.00  0.00           H  
ATOM    357  HD1 PHE A  25      16.145  63.556  22.730  1.00  0.00           H  
ATOM    358  HD2 PHE A  25      17.074  67.710  22.734  1.00  0.00           H  
ATOM    359  HE1 PHE A  25      18.528  63.020  22.435  1.00  0.00           H  
ATOM    360  HE2 PHE A  25      19.459  67.180  22.439  1.00  0.00           H  
ATOM    361  HZ  PHE A  25      20.188  64.833  22.290  1.00  0.00           H  
ATOM    362  N   LYS A  26      13.405  67.580  25.596  1.00  0.00           N  
ATOM    363  CA  LYS A  26      12.319  68.490  25.941  1.00  0.00           C  
ATOM    364  C   LYS A  26      12.293  69.689  25.000  1.00  0.00           C  
ATOM    365  O   LYS A  26      13.240  70.473  24.952  1.00  0.00           O  
ATOM    366  CB  LYS A  26      12.466  68.966  27.388  1.00  0.00           C  
ATOM    367  CG  LYS A  26      11.151  69.361  28.036  1.00  0.00           C  
ATOM    368  CD  LYS A  26      10.827  70.826  27.794  1.00  0.00           C  
ATOM    369  CE  LYS A  26       9.890  71.372  28.861  1.00  0.00           C  
ATOM    370  NZ  LYS A  26      10.606  71.649  30.137  1.00  0.00           N  
ATOM    371  H   LYS A  26      14.248  67.630  26.095  1.00  0.00           H  
ATOM    372  HA  LYS A  26      11.390  67.950  25.843  1.00  0.00           H  
ATOM    373  HB2 LYS A  26      12.909  68.173  27.973  1.00  0.00           H  
ATOM    374  HB3 LYS A  26      13.124  69.824  27.407  1.00  0.00           H  
ATOM    375  HG2 LYS A  26      10.359  68.755  27.620  1.00  0.00           H  
ATOM    376  HG3 LYS A  26      11.218  69.187  29.100  1.00  0.00           H  
ATOM    377  HD2 LYS A  26      11.744  71.396  27.809  1.00  0.00           H  
ATOM    378  HD3 LYS A  26      10.354  70.926  26.827  1.00  0.00           H  
ATOM    379  HE2 LYS A  26       9.451  72.289  28.499  1.00  0.00           H  
ATOM    380  HE3 LYS A  26       9.112  70.647  29.044  1.00  0.00           H  
ATOM    381  HZ1 LYS A  26      11.613  71.411  30.041  1.00  0.00           H  
ATOM    382  HZ2 LYS A  26      10.199  71.079  30.906  1.00  0.00           H  
ATOM    383  HZ3 LYS A  26      10.521  72.655  30.385  1.00  0.00           H  
ATOM    384  N   GLY A  27      11.202  69.826  24.252  1.00  0.00           N  
ATOM    385  CA  GLY A  27      11.075  70.934  23.322  1.00  0.00           C  
ATOM    386  C   GLY A  27      11.060  72.278  24.022  1.00  0.00           C  
ATOM    387  O   GLY A  27      11.499  72.412  25.164  1.00  0.00           O  
ATOM    388  H   GLY A  27      10.480  69.169  24.332  1.00  0.00           H  
ATOM    389  HA2 GLY A  27      11.904  70.907  22.631  1.00  0.00           H  
ATOM    390  HA3 GLY A  27      10.154  70.818  22.768  1.00  0.00           H  
ATOM    391  N   PRO A  28      10.547  73.305  23.328  1.00  0.00           N  
ATOM    392  CA  PRO A  28      10.024  73.157  21.966  1.00  0.00           C  
ATOM    393  C   PRO A  28      11.125  72.890  20.946  1.00  0.00           C  
ATOM    394  O   PRO A  28      12.298  72.768  21.303  1.00  0.00           O  
ATOM    395  CB  PRO A  28       9.359  74.508  21.693  1.00  0.00           C  
ATOM    396  CG  PRO A  28      10.069  75.467  22.585  1.00  0.00           C  
ATOM    397  CD  PRO A  28      10.440  74.689  23.817  1.00  0.00           C  
ATOM    398  HA  PRO A  28       9.284  72.371  21.909  1.00  0.00           H  
ATOM    399  HB2 PRO A  28       9.482  74.770  20.651  1.00  0.00           H  
ATOM    400  HB3 PRO A  28       8.307  74.451  21.934  1.00  0.00           H  
ATOM    401  HG2 PRO A  28      10.955  75.837  22.093  1.00  0.00           H  
ATOM    402  HG3 PRO A  28       9.411  76.285  22.842  1.00  0.00           H  
ATOM    403  HD2 PRO A  28      11.385  75.033  24.210  1.00  0.00           H  
ATOM    404  HD3 PRO A  28       9.666  74.774  24.565  1.00  0.00           H  
ATOM    405  N   PHE A  29      10.741  72.800  19.677  1.00  0.00           N  
ATOM    406  CA  PHE A  29      11.697  72.547  18.605  1.00  0.00           C  
ATOM    407  C   PHE A  29      11.987  73.824  17.822  1.00  0.00           C  
ATOM    408  O   PHE A  29      12.977  73.910  17.095  1.00  0.00           O  
ATOM    409  CB  PHE A  29      11.164  71.466  17.662  1.00  0.00           C  
ATOM    410  CG  PHE A  29      10.849  70.170  18.353  1.00  0.00           C  
ATOM    411  CD1 PHE A  29      11.668  69.691  19.363  1.00  0.00           C  
ATOM    412  CD2 PHE A  29       9.734  69.432  17.993  1.00  0.00           C  
ATOM    413  CE1 PHE A  29      11.381  68.499  19.999  1.00  0.00           C  
ATOM    414  CE2 PHE A  29       9.442  68.238  18.627  1.00  0.00           C  
ATOM    415  CZ  PHE A  29      10.266  67.772  19.632  1.00  0.00           C  
ATOM    416  H   PHE A  29       9.792  72.906  19.456  1.00  0.00           H  
ATOM    417  HA  PHE A  29      12.614  72.200  19.055  1.00  0.00           H  
ATOM    418  HB2 PHE A  29      10.258  71.821  17.196  1.00  0.00           H  
ATOM    419  HB3 PHE A  29      11.903  71.267  16.901  1.00  0.00           H  
ATOM    420  HD1 PHE A  29      12.540  70.259  19.653  1.00  0.00           H  
ATOM    421  HD2 PHE A  29       9.089  69.795  17.206  1.00  0.00           H  
ATOM    422  HE1 PHE A  29      12.026  68.137  20.786  1.00  0.00           H  
ATOM    423  HE2 PHE A  29       8.569  67.672  18.336  1.00  0.00           H  
ATOM    424  HZ  PHE A  29      10.039  66.840  20.127  1.00  0.00           H  
ATOM    425  N   THR A  30      11.115  74.816  17.975  1.00  0.00           N  
ATOM    426  CA  THR A  30      11.274  76.087  17.282  1.00  0.00           C  
ATOM    427  C   THR A  30      12.233  77.006  18.031  1.00  0.00           C  
ATOM    428  O   THR A  30      12.362  78.185  17.702  1.00  0.00           O  
ATOM    429  CB  THR A  30       9.923  76.806  17.108  1.00  0.00           C  
ATOM    430  OG1 THR A  30      10.105  78.019  16.369  1.00  0.00           O  
ATOM    431  CG2 THR A  30       9.299  77.118  18.460  1.00  0.00           C  
ATOM    432  H   THR A  30      10.346  74.687  18.568  1.00  0.00           H  
ATOM    433  HA  THR A  30      11.679  75.884  16.300  1.00  0.00           H  
ATOM    434  HB  THR A  30       9.254  76.157  16.561  1.00  0.00           H  
ATOM    435  HG1 THR A  30      10.676  77.853  15.616  1.00  0.00           H  
ATOM    436 HG21 THR A  30       8.430  76.495  18.609  1.00  0.00           H  
ATOM    437 HG22 THR A  30       9.006  78.157  18.490  1.00  0.00           H  
ATOM    438 HG23 THR A  30      10.018  76.925  19.241  1.00  0.00           H  
ATOM    439  N   ASP A  31      12.903  76.458  19.038  1.00  0.00           N  
ATOM    440  CA  ASP A  31      13.853  77.228  19.833  1.00  0.00           C  
ATOM    441  C   ASP A  31      14.969  76.334  20.363  1.00  0.00           C  
ATOM    442  O   ASP A  31      14.881  75.107  20.296  1.00  0.00           O  
ATOM    443  CB  ASP A  31      13.137  77.915  20.997  1.00  0.00           C  
ATOM    444  CG  ASP A  31      13.871  79.150  21.481  1.00  0.00           C  
ATOM    445  OD1 ASP A  31      14.143  80.041  20.651  1.00  0.00           O  
ATOM    446  OD2 ASP A  31      14.174  79.224  22.691  1.00  0.00           O  
ATOM    447  H   ASP A  31      12.757  75.512  19.252  1.00  0.00           H  
ATOM    448  HA  ASP A  31      14.286  77.983  19.194  1.00  0.00           H  
ATOM    449  HB2 ASP A  31      12.147  78.209  20.679  1.00  0.00           H  
ATOM    450  HB3 ASP A  31      13.054  77.220  21.821  1.00  0.00           H  
ATOM    451  N   VAL A  32      16.020  76.956  20.890  1.00  0.00           N  
ATOM    452  CA  VAL A  32      17.153  76.217  21.431  1.00  0.00           C  
ATOM    453  C   VAL A  32      16.700  75.203  22.476  1.00  0.00           C  
ATOM    454  O   VAL A  32      15.954  75.536  23.397  1.00  0.00           O  
ATOM    455  CB  VAL A  32      18.189  77.163  22.066  1.00  0.00           C  
ATOM    456  CG1 VAL A  32      19.278  76.370  22.771  1.00  0.00           C  
ATOM    457  CG2 VAL A  32      18.786  78.082  21.012  1.00  0.00           C  
ATOM    458  H   VAL A  32      16.031  77.935  20.916  1.00  0.00           H  
ATOM    459  HA  VAL A  32      17.629  75.691  20.617  1.00  0.00           H  
ATOM    460  HB  VAL A  32      17.686  77.774  22.802  1.00  0.00           H  
ATOM    461 HG11 VAL A  32      20.247  76.747  22.476  1.00  0.00           H  
ATOM    462 HG12 VAL A  32      19.162  76.469  23.840  1.00  0.00           H  
ATOM    463 HG13 VAL A  32      19.199  75.328  22.495  1.00  0.00           H  
ATOM    464 HG21 VAL A  32      18.038  78.309  20.266  1.00  0.00           H  
ATOM    465 HG22 VAL A  32      19.118  79.000  21.478  1.00  0.00           H  
ATOM    466 HG23 VAL A  32      19.627  77.594  20.542  1.00  0.00           H  
ATOM    467  N   VAL A  33      17.158  73.964  22.328  1.00  0.00           N  
ATOM    468  CA  VAL A  33      16.800  72.901  23.260  1.00  0.00           C  
ATOM    469  C   VAL A  33      17.952  72.595  24.212  1.00  0.00           C  
ATOM    470  O   VAL A  33      19.107  72.923  23.934  1.00  0.00           O  
ATOM    471  CB  VAL A  33      16.408  71.611  22.516  1.00  0.00           C  
ATOM    472  CG1 VAL A  33      15.793  70.606  23.478  1.00  0.00           C  
ATOM    473  CG2 VAL A  33      15.451  71.924  21.376  1.00  0.00           C  
ATOM    474  H   VAL A  33      17.750  73.760  21.575  1.00  0.00           H  
ATOM    475  HA  VAL A  33      15.949  73.234  23.836  1.00  0.00           H  
ATOM    476  HB  VAL A  33      17.302  71.174  22.098  1.00  0.00           H  
ATOM    477 HG11 VAL A  33      15.302  71.132  24.284  1.00  0.00           H  
ATOM    478 HG12 VAL A  33      15.072  69.998  22.951  1.00  0.00           H  
ATOM    479 HG13 VAL A  33      16.570  69.974  23.883  1.00  0.00           H  
ATOM    480 HG21 VAL A  33      15.960  72.524  20.635  1.00  0.00           H  
ATOM    481 HG22 VAL A  33      15.115  71.003  20.924  1.00  0.00           H  
ATOM    482 HG23 VAL A  33      14.601  72.469  21.758  1.00  0.00           H  
ATOM    483  N   THR A  34      17.631  71.964  25.337  1.00  0.00           N  
ATOM    484  CA  THR A  34      18.637  71.614  26.331  1.00  0.00           C  
ATOM    485  C   THR A  34      18.376  70.231  26.916  1.00  0.00           C  
ATOM    486  O   THR A  34      17.398  70.024  27.635  1.00  0.00           O  
ATOM    487  CB  THR A  34      18.677  72.644  27.476  1.00  0.00           C  
ATOM    488  OG1 THR A  34      18.734  73.971  26.941  1.00  0.00           O  
ATOM    489  CG2 THR A  34      19.879  72.403  28.379  1.00  0.00           C  
ATOM    490  H   THR A  34      16.694  71.730  25.502  1.00  0.00           H  
ATOM    491  HA  THR A  34      19.601  71.613  25.844  1.00  0.00           H  
ATOM    492  HB  THR A  34      17.777  72.539  28.065  1.00  0.00           H  
ATOM    493  HG1 THR A  34      17.979  74.117  26.366  1.00  0.00           H  
ATOM    494 HG21 THR A  34      20.290  73.352  28.690  1.00  0.00           H  
ATOM    495 HG22 THR A  34      20.629  71.845  27.838  1.00  0.00           H  
ATOM    496 HG23 THR A  34      19.570  71.843  29.247  1.00  0.00           H  
ATOM    497  N   THR A  35      19.256  69.286  26.604  1.00  0.00           N  
ATOM    498  CA  THR A  35      19.120  67.921  27.097  1.00  0.00           C  
ATOM    499  C   THR A  35      20.398  67.456  27.785  1.00  0.00           C  
ATOM    500  O   THR A  35      21.472  67.454  27.185  1.00  0.00           O  
ATOM    501  CB  THR A  35      18.778  66.943  25.957  1.00  0.00           C  
ATOM    502  OG1 THR A  35      17.424  67.136  25.535  1.00  0.00           O  
ATOM    503  CG2 THR A  35      18.975  65.502  26.404  1.00  0.00           C  
ATOM    504  H   THR A  35      20.015  69.513  26.026  1.00  0.00           H  
ATOM    505  HA  THR A  35      18.311  67.905  27.812  1.00  0.00           H  
ATOM    506  HB  THR A  35      19.438  67.139  25.124  1.00  0.00           H  
ATOM    507  HG1 THR A  35      16.854  67.191  26.306  1.00  0.00           H  
ATOM    508 HG21 THR A  35      18.460  65.341  27.339  1.00  0.00           H  
ATOM    509 HG22 THR A  35      20.029  65.306  26.533  1.00  0.00           H  
ATOM    510 HG23 THR A  35      18.575  64.836  25.654  1.00  0.00           H  
ATOM    511  N   ASN A  36      20.275  67.060  29.048  1.00  0.00           N  
ATOM    512  CA  ASN A  36      21.421  66.591  29.818  1.00  0.00           C  
ATOM    513  C   ASN A  36      21.561  65.075  29.716  1.00  0.00           C  
ATOM    514  O   ASN A  36      20.603  64.335  29.948  1.00  0.00           O  
ATOM    515  CB  ASN A  36      21.280  67.004  31.284  1.00  0.00           C  
ATOM    516  CG  ASN A  36      21.598  68.471  31.504  1.00  0.00           C  
ATOM    517  OD1 ASN A  36      22.726  68.829  31.848  1.00  0.00           O  
ATOM    518  ND2 ASN A  36      20.604  69.329  31.305  1.00  0.00           N  
ATOM    519  H   ASN A  36      19.392  67.084  29.472  1.00  0.00           H  
ATOM    520  HA  ASN A  36      22.306  67.051  29.406  1.00  0.00           H  
ATOM    521  HB2 ASN A  36      20.265  66.824  31.607  1.00  0.00           H  
ATOM    522  HB3 ASN A  36      21.956  66.414  31.885  1.00  0.00           H  
ATOM    523 HD21 ASN A  36      19.732  68.972  31.033  1.00  0.00           H  
ATOM    524 HD22 ASN A  36      20.782  70.282  31.440  1.00  0.00           H  
ATOM    525  N   LEU A  37      22.760  64.619  29.371  1.00  0.00           N  
ATOM    526  CA  LEU A  37      23.026  63.191  29.239  1.00  0.00           C  
ATOM    527  C   LEU A  37      23.903  62.693  30.384  1.00  0.00           C  
ATOM    528  O   LEU A  37      25.066  63.078  30.503  1.00  0.00           O  
ATOM    529  CB  LEU A  37      23.705  62.900  27.900  1.00  0.00           C  
ATOM    530  CG  LEU A  37      23.422  61.527  27.288  1.00  0.00           C  
ATOM    531  CD1 LEU A  37      24.142  61.376  25.958  1.00  0.00           C  
ATOM    532  CD2 LEU A  37      23.832  60.421  28.248  1.00  0.00           C  
ATOM    533  H   LEU A  37      23.484  65.257  29.199  1.00  0.00           H  
ATOM    534  HA  LEU A  37      22.080  62.673  29.274  1.00  0.00           H  
ATOM    535  HB2 LEU A  37      23.379  63.650  27.195  1.00  0.00           H  
ATOM    536  HB3 LEU A  37      24.772  62.984  28.045  1.00  0.00           H  
ATOM    537  HG  LEU A  37      22.360  61.435  27.104  1.00  0.00           H  
ATOM    538 HD11 LEU A  37      24.220  62.341  25.479  1.00  0.00           H  
ATOM    539 HD12 LEU A  37      23.588  60.703  25.322  1.00  0.00           H  
ATOM    540 HD13 LEU A  37      25.132  60.978  26.128  1.00  0.00           H  
ATOM    541 HD21 LEU A  37      24.441  60.837  29.037  1.00  0.00           H  
ATOM    542 HD22 LEU A  37      24.400  59.672  27.713  1.00  0.00           H  
ATOM    543 HD23 LEU A  37      22.949  59.968  28.673  1.00  0.00           H  
ATOM    544  N   LYS A  38      23.337  61.834  31.225  1.00  0.00           N  
ATOM    545  CA  LYS A  38      24.066  61.279  32.359  1.00  0.00           C  
ATOM    546  C   LYS A  38      24.875  60.056  31.940  1.00  0.00           C  
ATOM    547  O   LYS A  38      24.362  59.158  31.273  1.00  0.00           O  
ATOM    548  CB  LYS A  38      23.095  60.901  33.480  1.00  0.00           C  
ATOM    549  CG  LYS A  38      22.753  62.057  34.404  1.00  0.00           C  
ATOM    550  CD  LYS A  38      21.563  61.730  35.290  1.00  0.00           C  
ATOM    551  CE  LYS A  38      21.531  62.610  36.530  1.00  0.00           C  
ATOM    552  NZ  LYS A  38      20.157  62.728  37.092  1.00  0.00           N  
ATOM    553  H   LYS A  38      22.404  61.565  31.078  1.00  0.00           H  
ATOM    554  HA  LYS A  38      24.743  62.039  32.721  1.00  0.00           H  
ATOM    555  HB2 LYS A  38      22.178  60.537  33.039  1.00  0.00           H  
ATOM    556  HB3 LYS A  38      23.537  60.113  34.072  1.00  0.00           H  
ATOM    557  HG2 LYS A  38      23.606  62.270  35.031  1.00  0.00           H  
ATOM    558  HG3 LYS A  38      22.517  62.926  33.807  1.00  0.00           H  
ATOM    559  HD2 LYS A  38      20.653  61.886  34.728  1.00  0.00           H  
ATOM    560  HD3 LYS A  38      21.626  60.695  35.596  1.00  0.00           H  
ATOM    561  HE2 LYS A  38      22.180  62.181  37.277  1.00  0.00           H  
ATOM    562  HE3 LYS A  38      21.887  63.595  36.265  1.00  0.00           H  
ATOM    563  HZ1 LYS A  38      20.037  63.654  37.551  1.00  0.00           H  
ATOM    564  HZ2 LYS A  38      19.995  61.981  37.797  1.00  0.00           H  
ATOM    565  HZ3 LYS A  38      19.451  62.634  36.334  1.00  0.00           H  
ATOM    566  N   LEU A  39      26.144  60.030  32.335  1.00  0.00           N  
ATOM    567  CA  LEU A  39      27.025  58.916  32.002  1.00  0.00           C  
ATOM    568  C   LEU A  39      27.622  58.298  33.263  1.00  0.00           C  
ATOM    569  O   LEU A  39      28.520  58.871  33.880  1.00  0.00           O  
ATOM    570  CB  LEU A  39      28.145  59.386  31.072  1.00  0.00           C  
ATOM    571  CG  LEU A  39      27.702  59.950  29.721  1.00  0.00           C  
ATOM    572  CD1 LEU A  39      28.806  60.797  29.108  1.00  0.00           C  
ATOM    573  CD2 LEU A  39      27.305  58.822  28.778  1.00  0.00           C  
ATOM    574  H   LEU A  39      26.496  60.775  32.864  1.00  0.00           H  
ATOM    575  HA  LEU A  39      26.436  58.167  31.493  1.00  0.00           H  
ATOM    576  HB2 LEU A  39      28.699  60.157  31.585  1.00  0.00           H  
ATOM    577  HB3 LEU A  39      28.794  58.543  30.883  1.00  0.00           H  
ATOM    578  HG  LEU A  39      26.838  60.583  29.868  1.00  0.00           H  
ATOM    579 HD11 LEU A  39      28.456  61.231  28.184  1.00  0.00           H  
ATOM    580 HD12 LEU A  39      29.668  60.176  28.909  1.00  0.00           H  
ATOM    581 HD13 LEU A  39      29.081  61.583  29.796  1.00  0.00           H  
ATOM    582 HD21 LEU A  39      27.048  59.235  27.813  1.00  0.00           H  
ATOM    583 HD22 LEU A  39      26.454  58.296  29.184  1.00  0.00           H  
ATOM    584 HD23 LEU A  39      28.133  58.138  28.667  1.00  0.00           H  
ATOM    585  N   GLN A  40      27.119  57.126  33.637  1.00  0.00           N  
ATOM    586  CA  GLN A  40      27.604  56.430  34.822  1.00  0.00           C  
ATOM    587  C   GLN A  40      28.799  55.545  34.483  1.00  0.00           C  
ATOM    588  O   GLN A  40      28.867  54.964  33.401  1.00  0.00           O  
ATOM    589  CB  GLN A  40      26.487  55.585  35.436  1.00  0.00           C  
ATOM    590  CG  GLN A  40      26.804  55.081  36.835  1.00  0.00           C  
ATOM    591  CD  GLN A  40      25.668  54.279  37.438  1.00  0.00           C  
ATOM    592  OE1 GLN A  40      25.327  53.201  36.951  1.00  0.00           O  
ATOM    593  NE2 GLN A  40      25.075  54.803  38.504  1.00  0.00           N  
ATOM    594  H   GLN A  40      26.405  56.721  33.103  1.00  0.00           H  
ATOM    595  HA  GLN A  40      27.916  57.175  35.539  1.00  0.00           H  
ATOM    596  HB2 GLN A  40      25.588  56.181  35.488  1.00  0.00           H  
ATOM    597  HB3 GLN A  40      26.307  54.731  34.802  1.00  0.00           H  
ATOM    598  HG2 GLN A  40      27.681  54.452  36.787  1.00  0.00           H  
ATOM    599  HG3 GLN A  40      27.006  55.929  37.473  1.00  0.00           H  
ATOM    600 HE21 GLN A  40      25.399  55.667  38.836  1.00  0.00           H  
ATOM    601 HE22 GLN A  40      24.337  54.306  38.914  1.00  0.00           H  
ATOM    602  N   ASN A  41      29.741  55.446  35.417  1.00  0.00           N  
ATOM    603  CA  ASN A  41      30.934  54.633  35.216  1.00  0.00           C  
ATOM    604  C   ASN A  41      31.081  53.600  36.329  1.00  0.00           C  
ATOM    605  O   ASN A  41      31.564  53.894  37.422  1.00  0.00           O  
ATOM    606  CB  ASN A  41      32.179  55.521  35.161  1.00  0.00           C  
ATOM    607  CG  ASN A  41      33.444  54.727  34.903  1.00  0.00           C  
ATOM    608  OD1 ASN A  41      33.391  53.535  34.597  1.00  0.00           O  
ATOM    609  ND2 ASN A  41      34.591  55.384  35.027  1.00  0.00           N  
ATOM    610  H   ASN A  41      29.630  55.933  36.260  1.00  0.00           H  
ATOM    611  HA  ASN A  41      30.828  54.117  34.273  1.00  0.00           H  
ATOM    612  HB2 ASN A  41      32.062  56.243  34.365  1.00  0.00           H  
ATOM    613  HB3 ASN A  41      32.286  56.040  36.102  1.00  0.00           H  
ATOM    614 HD21 ASN A  41      34.557  56.332  35.274  1.00  0.00           H  
ATOM    615 HD22 ASN A  41      35.425  54.895  34.866  1.00  0.00           H  
ATOM    616  N   PRO A  42      30.657  52.360  36.046  1.00  0.00           N  
ATOM    617  CA  PRO A  42      30.732  51.258  37.009  1.00  0.00           C  
ATOM    618  C   PRO A  42      32.167  50.812  37.269  1.00  0.00           C  
ATOM    619  O   PRO A  42      32.490  50.330  38.354  1.00  0.00           O  
ATOM    620  CB  PRO A  42      29.939  50.138  36.329  1.00  0.00           C  
ATOM    621  CG  PRO A  42      30.030  50.439  34.873  1.00  0.00           C  
ATOM    622  CD  PRO A  42      30.071  51.938  34.762  1.00  0.00           C  
ATOM    623  HA  PRO A  42      30.260  51.517  37.946  1.00  0.00           H  
ATOM    624  HB2 PRO A  42      30.387  49.183  36.566  1.00  0.00           H  
ATOM    625  HB3 PRO A  42      28.916  50.157  36.673  1.00  0.00           H  
ATOM    626  HG2 PRO A  42      30.932  50.008  34.466  1.00  0.00           H  
ATOM    627  HG3 PRO A  42      29.162  50.048  34.363  1.00  0.00           H  
ATOM    628  HD2 PRO A  42      30.696  52.238  33.935  1.00  0.00           H  
ATOM    629  HD3 PRO A  42      29.072  52.335  34.645  1.00  0.00           H  
ATOM    630  N   SER A  43      33.024  50.977  36.267  1.00  0.00           N  
ATOM    631  CA  SER A  43      34.424  50.589  36.386  1.00  0.00           C  
ATOM    632  C   SER A  43      35.123  51.401  37.472  1.00  0.00           C  
ATOM    633  O   SER A  43      34.589  52.401  37.955  1.00  0.00           O  
ATOM    634  CB  SER A  43      35.143  50.778  35.049  1.00  0.00           C  
ATOM    635  OG  SER A  43      35.685  52.083  34.942  1.00  0.00           O  
ATOM    636  H   SER A  43      32.706  51.367  35.425  1.00  0.00           H  
ATOM    637  HA  SER A  43      34.456  49.544  36.658  1.00  0.00           H  
ATOM    638  HB2 SER A  43      35.946  50.061  34.971  1.00  0.00           H  
ATOM    639  HB3 SER A  43      34.443  50.624  34.241  1.00  0.00           H  
ATOM    640  HG  SER A  43      35.253  52.551  34.225  1.00  0.00           H  
ATOM    641  N   ASP A  44      36.318  50.965  37.851  1.00  0.00           N  
ATOM    642  CA  ASP A  44      37.092  51.652  38.880  1.00  0.00           C  
ATOM    643  C   ASP A  44      38.348  52.281  38.285  1.00  0.00           C  
ATOM    644  O   ASP A  44      39.347  52.473  38.980  1.00  0.00           O  
ATOM    645  CB  ASP A  44      37.474  50.679  39.996  1.00  0.00           C  
ATOM    646  CG  ASP A  44      36.265  50.164  40.754  1.00  0.00           C  
ATOM    647  OD1 ASP A  44      35.576  50.983  41.397  1.00  0.00           O  
ATOM    648  OD2 ASP A  44      36.009  48.942  40.704  1.00  0.00           O  
ATOM    649  H   ASP A  44      36.691  50.163  37.429  1.00  0.00           H  
ATOM    650  HA  ASP A  44      36.473  52.434  39.293  1.00  0.00           H  
ATOM    651  HB2 ASP A  44      37.992  49.833  39.566  1.00  0.00           H  
ATOM    652  HB3 ASP A  44      38.127  51.180  40.694  1.00  0.00           H  
ATOM    653  N   ARG A  45      38.290  52.601  36.997  1.00  0.00           N  
ATOM    654  CA  ARG A  45      39.424  53.207  36.309  1.00  0.00           C  
ATOM    655  C   ARG A  45      38.954  54.265  35.314  1.00  0.00           C  
ATOM    656  O   ARG A  45      37.871  54.153  34.737  1.00  0.00           O  
ATOM    657  CB  ARG A  45      40.239  52.135  35.582  1.00  0.00           C  
ATOM    658  CG  ARG A  45      39.385  51.090  34.883  1.00  0.00           C  
ATOM    659  CD  ARG A  45      40.113  49.760  34.772  1.00  0.00           C  
ATOM    660  NE  ARG A  45      39.887  48.914  35.941  1.00  0.00           N  
ATOM    661  CZ  ARG A  45      40.525  47.768  36.153  1.00  0.00           C  
ATOM    662  NH1 ARG A  45      41.424  47.335  35.279  1.00  0.00           N  
ATOM    663  NH2 ARG A  45      40.266  47.054  37.241  1.00  0.00           N  
ATOM    664  H   ARG A  45      37.466  52.424  36.496  1.00  0.00           H  
ATOM    665  HA  ARG A  45      40.049  53.680  37.052  1.00  0.00           H  
ATOM    666  HB2 ARG A  45      40.861  52.615  34.840  1.00  0.00           H  
ATOM    667  HB3 ARG A  45      40.870  51.633  36.299  1.00  0.00           H  
ATOM    668  HG2 ARG A  45      38.476  50.944  35.449  1.00  0.00           H  
ATOM    669  HG3 ARG A  45      39.141  51.442  33.892  1.00  0.00           H  
ATOM    670  HD2 ARG A  45      39.758  49.243  33.892  1.00  0.00           H  
ATOM    671  HD3 ARG A  45      41.171  49.951  34.676  1.00  0.00           H  
ATOM    672  HE  ARG A  45      39.228  49.215  36.599  1.00  0.00           H  
ATOM    673 HH11 ARG A  45      41.623  47.871  34.459  1.00  0.00           H  
ATOM    674 HH12 ARG A  45      41.905  46.472  35.441  1.00  0.00           H  
ATOM    675 HH21 ARG A  45      39.590  47.377  37.901  1.00  0.00           H  
ATOM    676 HH22 ARG A  45      40.747  46.191  37.399  1.00  0.00           H  
ATOM    677  N   LYS A  46      39.774  55.292  35.119  1.00  0.00           N  
ATOM    678  CA  LYS A  46      39.444  56.371  34.196  1.00  0.00           C  
ATOM    679  C   LYS A  46      39.025  55.815  32.838  1.00  0.00           C  
ATOM    680  O   LYS A  46      39.516  54.773  32.404  1.00  0.00           O  
ATOM    681  CB  LYS A  46      40.641  57.310  34.027  1.00  0.00           C  
ATOM    682  CG  LYS A  46      40.825  58.275  35.186  1.00  0.00           C  
ATOM    683  CD  LYS A  46      41.949  59.261  34.916  1.00  0.00           C  
ATOM    684  CE  LYS A  46      42.237  60.123  36.136  1.00  0.00           C  
ATOM    685  NZ  LYS A  46      43.585  60.750  36.065  1.00  0.00           N  
ATOM    686  H   LYS A  46      40.623  55.326  35.609  1.00  0.00           H  
ATOM    687  HA  LYS A  46      38.618  56.926  34.614  1.00  0.00           H  
ATOM    688  HB2 LYS A  46      41.538  56.716  33.934  1.00  0.00           H  
ATOM    689  HB3 LYS A  46      40.506  57.887  33.124  1.00  0.00           H  
ATOM    690  HG2 LYS A  46      39.907  58.823  35.335  1.00  0.00           H  
ATOM    691  HG3 LYS A  46      41.059  57.710  36.078  1.00  0.00           H  
ATOM    692  HD2 LYS A  46      42.843  58.714  34.658  1.00  0.00           H  
ATOM    693  HD3 LYS A  46      41.664  59.901  34.093  1.00  0.00           H  
ATOM    694  HE2 LYS A  46      41.491  60.902  36.194  1.00  0.00           H  
ATOM    695  HE3 LYS A  46      42.183  59.504  37.019  1.00  0.00           H  
ATOM    696  HZ1 LYS A  46      43.870  60.875  35.073  1.00  0.00           H  
ATOM    697  HZ2 LYS A  46      44.286  60.146  36.541  1.00  0.00           H  
ATOM    698  HZ3 LYS A  46      43.573  61.680  36.530  1.00  0.00           H  
ATOM    699  N   VAL A  47      38.117  56.518  32.170  1.00  0.00           N  
ATOM    700  CA  VAL A  47      37.633  56.097  30.861  1.00  0.00           C  
ATOM    701  C   VAL A  47      37.318  57.299  29.978  1.00  0.00           C  
ATOM    702  O   VAL A  47      36.667  58.249  30.414  1.00  0.00           O  
ATOM    703  CB  VAL A  47      36.374  55.218  30.983  1.00  0.00           C  
ATOM    704  CG1 VAL A  47      35.919  54.743  29.612  1.00  0.00           C  
ATOM    705  CG2 VAL A  47      36.635  54.038  31.906  1.00  0.00           C  
ATOM    706  H   VAL A  47      37.762  57.341  32.568  1.00  0.00           H  
ATOM    707  HA  VAL A  47      38.411  55.512  30.391  1.00  0.00           H  
ATOM    708  HB  VAL A  47      35.583  55.816  31.413  1.00  0.00           H  
ATOM    709 HG11 VAL A  47      36.577  53.959  29.267  1.00  0.00           H  
ATOM    710 HG12 VAL A  47      34.910  54.365  29.678  1.00  0.00           H  
ATOM    711 HG13 VAL A  47      35.950  55.569  28.916  1.00  0.00           H  
ATOM    712 HG21 VAL A  47      37.661  53.716  31.796  1.00  0.00           H  
ATOM    713 HG22 VAL A  47      36.459  54.335  32.930  1.00  0.00           H  
ATOM    714 HG23 VAL A  47      35.973  53.225  31.648  1.00  0.00           H  
ATOM    715  N   CYS A  48      37.782  57.250  28.734  1.00  0.00           N  
ATOM    716  CA  CYS A  48      37.550  58.337  27.789  1.00  0.00           C  
ATOM    717  C   CYS A  48      36.308  58.067  26.946  1.00  0.00           C  
ATOM    718  O   CYS A  48      36.058  56.934  26.535  1.00  0.00           O  
ATOM    719  CB  CYS A  48      38.767  58.520  26.881  1.00  0.00           C  
ATOM    720  SG  CYS A  48      40.341  58.605  27.766  1.00  0.00           S  
ATOM    721  H   CYS A  48      38.294  56.467  28.445  1.00  0.00           H  
ATOM    722  HA  CYS A  48      37.395  59.242  28.356  1.00  0.00           H  
ATOM    723  HB2 CYS A  48      38.822  57.688  26.194  1.00  0.00           H  
ATOM    724  HB3 CYS A  48      38.654  59.435  26.320  1.00  0.00           H  
ATOM    725  HG  CYS A  48      40.827  57.376  27.856  1.00  0.00           H  
ATOM    726  N   PHE A  49      35.531  59.116  26.694  1.00  0.00           N  
ATOM    727  CA  PHE A  49      34.312  58.992  25.902  1.00  0.00           C  
ATOM    728  C   PHE A  49      34.289  60.022  24.777  1.00  0.00           C  
ATOM    729  O   PHE A  49      34.606  61.194  24.985  1.00  0.00           O  
ATOM    730  CB  PHE A  49      33.081  59.164  26.793  1.00  0.00           C  
ATOM    731  CG  PHE A  49      32.941  60.547  27.364  1.00  0.00           C  
ATOM    732  CD1 PHE A  49      32.422  61.577  26.596  1.00  0.00           C  
ATOM    733  CD2 PHE A  49      33.329  60.815  28.666  1.00  0.00           C  
ATOM    734  CE1 PHE A  49      32.292  62.850  27.118  1.00  0.00           C  
ATOM    735  CE2 PHE A  49      33.201  62.087  29.193  1.00  0.00           C  
ATOM    736  CZ  PHE A  49      32.683  63.105  28.418  1.00  0.00           C  
ATOM    737  H   PHE A  49      35.783  59.994  27.050  1.00  0.00           H  
ATOM    738  HA  PHE A  49      34.299  58.003  25.470  1.00  0.00           H  
ATOM    739  HB2 PHE A  49      32.195  58.953  26.214  1.00  0.00           H  
ATOM    740  HB3 PHE A  49      33.141  58.468  27.617  1.00  0.00           H  
ATOM    741  HD1 PHE A  49      32.117  61.379  25.579  1.00  0.00           H  
ATOM    742  HD2 PHE A  49      33.735  60.020  29.273  1.00  0.00           H  
ATOM    743  HE1 PHE A  49      31.887  63.644  26.508  1.00  0.00           H  
ATOM    744  HE2 PHE A  49      33.507  62.283  30.210  1.00  0.00           H  
ATOM    745  HZ  PHE A  49      32.581  64.099  28.827  1.00  0.00           H  
ATOM    746  N   LYS A  50      33.909  59.577  23.584  1.00  0.00           N  
ATOM    747  CA  LYS A  50      33.841  60.459  22.424  1.00  0.00           C  
ATOM    748  C   LYS A  50      32.410  60.576  21.912  1.00  0.00           C  
ATOM    749  O   LYS A  50      31.868  59.634  21.333  1.00  0.00           O  
ATOM    750  CB  LYS A  50      34.752  59.939  21.310  1.00  0.00           C  
ATOM    751  CG  LYS A  50      36.164  60.498  21.366  1.00  0.00           C  
ATOM    752  CD  LYS A  50      36.293  61.771  20.547  1.00  0.00           C  
ATOM    753  CE  LYS A  50      35.870  62.993  21.347  1.00  0.00           C  
ATOM    754  NZ  LYS A  50      36.158  64.259  20.618  1.00  0.00           N  
ATOM    755  H   LYS A  50      33.667  58.632  23.481  1.00  0.00           H  
ATOM    756  HA  LYS A  50      34.183  61.436  22.730  1.00  0.00           H  
ATOM    757  HB2 LYS A  50      34.810  58.863  21.380  1.00  0.00           H  
ATOM    758  HB3 LYS A  50      34.321  60.206  20.355  1.00  0.00           H  
ATOM    759  HG2 LYS A  50      36.413  60.716  22.395  1.00  0.00           H  
ATOM    760  HG3 LYS A  50      36.850  59.758  20.978  1.00  0.00           H  
ATOM    761  HD2 LYS A  50      37.323  61.891  20.246  1.00  0.00           H  
ATOM    762  HD3 LYS A  50      35.667  61.689  19.670  1.00  0.00           H  
ATOM    763  HE2 LYS A  50      34.810  62.932  21.539  1.00  0.00           H  
ATOM    764  HE3 LYS A  50      36.405  62.998  22.285  1.00  0.00           H  
ATOM    765  HZ1 LYS A  50      35.606  65.040  21.027  1.00  0.00           H  
ATOM    766  HZ2 LYS A  50      35.904  64.160  19.615  1.00  0.00           H  
ATOM    767  HZ3 LYS A  50      37.169  64.490  20.688  1.00  0.00           H  
ATOM    768  N   VAL A  51      31.801  61.738  22.130  1.00  0.00           N  
ATOM    769  CA  VAL A  51      30.433  61.980  21.688  1.00  0.00           C  
ATOM    770  C   VAL A  51      30.378  62.234  20.185  1.00  0.00           C  
ATOM    771  O   VAL A  51      30.961  63.196  19.685  1.00  0.00           O  
ATOM    772  CB  VAL A  51      29.809  63.179  22.424  1.00  0.00           C  
ATOM    773  CG1 VAL A  51      28.338  63.320  22.064  1.00  0.00           C  
ATOM    774  CG2 VAL A  51      29.986  63.032  23.928  1.00  0.00           C  
ATOM    775  H   VAL A  51      32.285  62.451  22.597  1.00  0.00           H  
ATOM    776  HA  VAL A  51      29.849  61.100  21.916  1.00  0.00           H  
ATOM    777  HB  VAL A  51      30.322  64.076  22.110  1.00  0.00           H  
ATOM    778 HG11 VAL A  51      27.930  62.348  21.830  1.00  0.00           H  
ATOM    779 HG12 VAL A  51      27.801  63.746  22.898  1.00  0.00           H  
ATOM    780 HG13 VAL A  51      28.239  63.968  21.205  1.00  0.00           H  
ATOM    781 HG21 VAL A  51      29.081  63.345  24.429  1.00  0.00           H  
ATOM    782 HG22 VAL A  51      30.190  61.997  24.167  1.00  0.00           H  
ATOM    783 HG23 VAL A  51      30.811  63.646  24.256  1.00  0.00           H  
ATOM    784  N   LYS A  52      29.671  61.364  19.470  1.00  0.00           N  
ATOM    785  CA  LYS A  52      29.536  61.495  18.024  1.00  0.00           C  
ATOM    786  C   LYS A  52      28.108  61.192  17.581  1.00  0.00           C  
ATOM    787  O   LYS A  52      27.544  60.156  17.934  1.00  0.00           O  
ATOM    788  CB  LYS A  52      30.512  60.555  17.314  1.00  0.00           C  
ATOM    789  CG  LYS A  52      31.946  60.685  17.799  1.00  0.00           C  
ATOM    790  CD  LYS A  52      32.920  60.006  16.850  1.00  0.00           C  
ATOM    791  CE  LYS A  52      33.381  60.954  15.753  1.00  0.00           C  
ATOM    792  NZ  LYS A  52      34.585  61.730  16.162  1.00  0.00           N  
ATOM    793  H   LYS A  52      29.229  60.618  19.926  1.00  0.00           H  
ATOM    794  HA  LYS A  52      29.775  62.514  17.759  1.00  0.00           H  
ATOM    795  HB2 LYS A  52      30.191  59.535  17.473  1.00  0.00           H  
ATOM    796  HB3 LYS A  52      30.492  60.767  16.254  1.00  0.00           H  
ATOM    797  HG2 LYS A  52      32.199  61.732  17.868  1.00  0.00           H  
ATOM    798  HG3 LYS A  52      32.029  60.228  18.774  1.00  0.00           H  
ATOM    799  HD2 LYS A  52      33.781  59.674  17.409  1.00  0.00           H  
ATOM    800  HD3 LYS A  52      32.432  59.154  16.396  1.00  0.00           H  
ATOM    801  HE2 LYS A  52      33.618  60.375  14.873  1.00  0.00           H  
ATOM    802  HE3 LYS A  52      32.579  61.641  15.528  1.00  0.00           H  
ATOM    803  HZ1 LYS A  52      34.481  62.060  17.142  1.00  0.00           H  
ATOM    804  HZ2 LYS A  52      34.704  62.555  15.541  1.00  0.00           H  
ATOM    805  HZ3 LYS A  52      35.434  61.133  16.095  1.00  0.00           H  
ATOM    806  N   THR A  53      27.529  62.102  16.805  1.00  0.00           N  
ATOM    807  CA  THR A  53      26.167  61.933  16.314  1.00  0.00           C  
ATOM    808  C   THR A  53      26.105  62.090  14.799  1.00  0.00           C  
ATOM    809  O   THR A  53      27.049  62.577  14.176  1.00  0.00           O  
ATOM    810  CB  THR A  53      25.206  62.945  16.964  1.00  0.00           C  
ATOM    811  OG1 THR A  53      23.852  62.622  16.624  1.00  0.00           O  
ATOM    812  CG2 THR A  53      25.523  64.362  16.510  1.00  0.00           C  
ATOM    813  H   THR A  53      28.030  62.907  16.558  1.00  0.00           H  
ATOM    814  HA  THR A  53      25.840  60.937  16.576  1.00  0.00           H  
ATOM    815  HB  THR A  53      25.322  62.892  18.037  1.00  0.00           H  
ATOM    816  HG1 THR A  53      23.275  63.344  16.886  1.00  0.00           H  
ATOM    817 HG21 THR A  53      26.120  64.856  17.262  1.00  0.00           H  
ATOM    818 HG22 THR A  53      24.603  64.908  16.365  1.00  0.00           H  
ATOM    819 HG23 THR A  53      26.071  64.327  15.581  1.00  0.00           H  
ATOM    820  N   THR A  54      24.987  61.675  14.211  1.00  0.00           N  
ATOM    821  CA  THR A  54      24.803  61.771  12.768  1.00  0.00           C  
ATOM    822  C   THR A  54      24.437  63.192  12.353  1.00  0.00           C  
ATOM    823  O   THR A  54      24.477  63.533  11.170  1.00  0.00           O  
ATOM    824  CB  THR A  54      23.706  60.806  12.277  1.00  0.00           C  
ATOM    825  OG1 THR A  54      22.637  60.755  13.228  1.00  0.00           O  
ATOM    826  CG2 THR A  54      24.270  59.410  12.064  1.00  0.00           C  
ATOM    827  H   THR A  54      24.272  61.296  14.761  1.00  0.00           H  
ATOM    828  HA  THR A  54      25.734  61.496  12.294  1.00  0.00           H  
ATOM    829  HB  THR A  54      23.322  61.172  11.335  1.00  0.00           H  
ATOM    830  HG1 THR A  54      22.176  61.598  13.238  1.00  0.00           H  
ATOM    831 HG21 THR A  54      23.532  58.675  12.352  1.00  0.00           H  
ATOM    832 HG22 THR A  54      25.157  59.284  12.667  1.00  0.00           H  
ATOM    833 HG23 THR A  54      24.521  59.278  11.023  1.00  0.00           H  
ATOM    834  N   ALA A  55      24.083  64.017  13.332  1.00  0.00           N  
ATOM    835  CA  ALA A  55      23.713  65.401  13.068  1.00  0.00           C  
ATOM    836  C   ALA A  55      24.528  66.361  13.928  1.00  0.00           C  
ATOM    837  O   ALA A  55      24.003  67.044  14.807  1.00  0.00           O  
ATOM    838  CB  ALA A  55      22.225  65.606  13.313  1.00  0.00           C  
ATOM    839  H   ALA A  55      24.070  63.686  14.255  1.00  0.00           H  
ATOM    840  HA  ALA A  55      23.913  65.608  12.026  1.00  0.00           H  
ATOM    841  HB1 ALA A  55      21.978  66.649  13.176  1.00  0.00           H  
ATOM    842  HB2 ALA A  55      21.660  65.009  12.612  1.00  0.00           H  
ATOM    843  HB3 ALA A  55      21.981  65.307  14.321  1.00  0.00           H  
ATOM    844  N   PRO A  56      25.843  66.414  13.670  1.00  0.00           N  
ATOM    845  CA  PRO A  56      26.760  67.287  14.410  1.00  0.00           C  
ATOM    846  C   PRO A  56      26.539  68.762  14.093  1.00  0.00           C  
ATOM    847  O   PRO A  56      27.118  69.638  14.735  1.00  0.00           O  
ATOM    848  CB  PRO A  56      28.143  66.839  13.930  1.00  0.00           C  
ATOM    849  CG  PRO A  56      27.903  66.254  12.581  1.00  0.00           C  
ATOM    850  CD  PRO A  56      26.537  65.627  12.637  1.00  0.00           C  
ATOM    851  HA  PRO A  56      26.680  67.133  15.476  1.00  0.00           H  
ATOM    852  HB2 PRO A  56      28.804  67.693  13.879  1.00  0.00           H  
ATOM    853  HB3 PRO A  56      28.545  66.105  14.612  1.00  0.00           H  
ATOM    854  HG2 PRO A  56      27.928  67.032  11.834  1.00  0.00           H  
ATOM    855  HG3 PRO A  56      28.651  65.503  12.368  1.00  0.00           H  
ATOM    856  HD2 PRO A  56      26.040  65.720  11.683  1.00  0.00           H  
ATOM    857  HD3 PRO A  56      26.609  64.590  12.927  1.00  0.00           H  
ATOM    858  N   ARG A  57      25.695  69.029  13.101  1.00  0.00           N  
ATOM    859  CA  ARG A  57      25.399  70.398  12.700  1.00  0.00           C  
ATOM    860  C   ARG A  57      24.220  70.955  13.495  1.00  0.00           C  
ATOM    861  O   ARG A  57      24.148  72.155  13.757  1.00  0.00           O  
ATOM    862  CB  ARG A  57      25.090  70.458  11.202  1.00  0.00           C  
ATOM    863  CG  ARG A  57      25.294  71.836  10.593  1.00  0.00           C  
ATOM    864  CD  ARG A  57      24.538  71.981   9.281  1.00  0.00           C  
ATOM    865  NE  ARG A  57      23.135  71.595   9.411  1.00  0.00           N  
ATOM    866  CZ  ARG A  57      22.331  71.386   8.374  1.00  0.00           C  
ATOM    867  NH1 ARG A  57      22.789  71.524   7.138  1.00  0.00           N  
ATOM    868  NH2 ARG A  57      21.067  71.037   8.573  1.00  0.00           N  
ATOM    869  H   ARG A  57      25.263  68.288  12.627  1.00  0.00           H  
ATOM    870  HA  ARG A  57      26.271  71.001  12.903  1.00  0.00           H  
ATOM    871  HB2 ARG A  57      25.736  69.762  10.687  1.00  0.00           H  
ATOM    872  HB3 ARG A  57      24.063  70.167  11.047  1.00  0.00           H  
ATOM    873  HG2 ARG A  57      24.935  72.582  11.286  1.00  0.00           H  
ATOM    874  HG3 ARG A  57      26.346  71.987  10.411  1.00  0.00           H  
ATOM    875  HD2 ARG A  57      24.589  73.012   8.963  1.00  0.00           H  
ATOM    876  HD3 ARG A  57      25.008  71.352   8.539  1.00  0.00           H  
ATOM    877  HE  ARG A  57      22.777  71.487  10.316  1.00  0.00           H  
ATOM    878 HH11 ARG A  57      23.742  71.786   6.984  1.00  0.00           H  
ATOM    879 HH12 ARG A  57      22.183  71.364   6.358  1.00  0.00           H  
ATOM    880 HH21 ARG A  57      20.719  70.931   9.505  1.00  0.00           H  
ATOM    881 HH22 ARG A  57      20.463  70.879   7.793  1.00  0.00           H  
ATOM    882  N   ARG A  58      23.301  70.075  13.873  1.00  0.00           N  
ATOM    883  CA  ARG A  58      22.125  70.477  14.636  1.00  0.00           C  
ATOM    884  C   ARG A  58      22.218  69.986  16.078  1.00  0.00           C  
ATOM    885  O   ARG A  58      21.201  69.808  16.750  1.00  0.00           O  
ATOM    886  CB  ARG A  58      20.854  69.933  13.980  1.00  0.00           C  
ATOM    887  CG  ARG A  58      20.533  70.581  12.644  1.00  0.00           C  
ATOM    888  CD  ARG A  58      19.262  70.008  12.037  1.00  0.00           C  
ATOM    889  NE  ARG A  58      19.529  68.821  11.229  1.00  0.00           N  
ATOM    890  CZ  ARG A  58      18.576  68.020  10.764  1.00  0.00           C  
ATOM    891  NH1 ARG A  58      17.302  68.277  11.026  1.00  0.00           N  
ATOM    892  NH2 ARG A  58      18.898  66.959  10.035  1.00  0.00           N  
ATOM    893  H   ARG A  58      23.414  69.131  13.634  1.00  0.00           H  
ATOM    894  HA  ARG A  58      22.085  71.556  14.638  1.00  0.00           H  
ATOM    895  HB2 ARG A  58      20.971  68.872  13.822  1.00  0.00           H  
ATOM    896  HB3 ARG A  58      20.021  70.101  14.646  1.00  0.00           H  
ATOM    897  HG2 ARG A  58      20.401  71.643  12.791  1.00  0.00           H  
ATOM    898  HG3 ARG A  58      21.355  70.409  11.965  1.00  0.00           H  
ATOM    899  HD2 ARG A  58      18.586  69.743  12.836  1.00  0.00           H  
ATOM    900  HD3 ARG A  58      18.805  70.762  11.414  1.00  0.00           H  
ATOM    901  HE  ARG A  58      20.463  68.612  11.024  1.00  0.00           H  
ATOM    902 HH11 ARG A  58      17.056  69.076  11.574  1.00  0.00           H  
ATOM    903 HH12 ARG A  58      16.587  67.673  10.674  1.00  0.00           H  
ATOM    904 HH21 ARG A  58      19.857  66.762   9.836  1.00  0.00           H  
ATOM    905 HH22 ARG A  58      18.181  66.356   9.686  1.00  0.00           H  
ATOM    906  N   TYR A  59      23.441  69.767  16.545  1.00  0.00           N  
ATOM    907  CA  TYR A  59      23.666  69.292  17.905  1.00  0.00           C  
ATOM    908  C   TYR A  59      24.915  69.931  18.505  1.00  0.00           C  
ATOM    909  O   TYR A  59      25.974  69.958  17.879  1.00  0.00           O  
ATOM    910  CB  TYR A  59      23.802  67.768  17.920  1.00  0.00           C  
ATOM    911  CG  TYR A  59      22.476  67.043  17.942  1.00  0.00           C  
ATOM    912  CD1 TYR A  59      21.676  66.982  16.808  1.00  0.00           C  
ATOM    913  CD2 TYR A  59      22.023  66.418  19.098  1.00  0.00           C  
ATOM    914  CE1 TYR A  59      20.463  66.321  16.823  1.00  0.00           C  
ATOM    915  CE2 TYR A  59      20.812  65.752  19.122  1.00  0.00           C  
ATOM    916  CZ  TYR A  59      20.036  65.707  17.982  1.00  0.00           C  
ATOM    917  OH  TYR A  59      18.829  65.047  18.002  1.00  0.00           O  
ATOM    918  H   TYR A  59      24.212  69.926  15.961  1.00  0.00           H  
ATOM    919  HA  TYR A  59      22.810  69.573  18.500  1.00  0.00           H  
ATOM    920  HB2 TYR A  59      24.338  67.453  17.039  1.00  0.00           H  
ATOM    921  HB3 TYR A  59      24.358  67.472  18.798  1.00  0.00           H  
ATOM    922  HD1 TYR A  59      22.013  67.464  15.902  1.00  0.00           H  
ATOM    923  HD2 TYR A  59      22.633  66.456  19.988  1.00  0.00           H  
ATOM    924  HE1 TYR A  59      19.856  66.285  15.931  1.00  0.00           H  
ATOM    925  HE2 TYR A  59      20.477  65.273  20.029  1.00  0.00           H  
ATOM    926  HH  TYR A  59      18.752  64.497  17.220  1.00  0.00           H  
ATOM    927  N   CYS A  60      24.782  70.445  19.723  1.00  0.00           N  
ATOM    928  CA  CYS A  60      25.898  71.084  20.411  1.00  0.00           C  
ATOM    929  C   CYS A  60      26.169  70.411  21.751  1.00  0.00           C  
ATOM    930  O   CYS A  60      25.554  70.746  22.763  1.00  0.00           O  
ATOM    931  CB  CYS A  60      25.609  72.571  20.623  1.00  0.00           C  
ATOM    932  SG  CYS A  60      27.071  73.558  21.016  1.00  0.00           S  
ATOM    933  H   CYS A  60      23.911  70.393  20.172  1.00  0.00           H  
ATOM    934  HA  CYS A  60      26.773  70.982  19.786  1.00  0.00           H  
ATOM    935  HB2 CYS A  60      25.172  72.976  19.722  1.00  0.00           H  
ATOM    936  HB3 CYS A  60      24.907  72.681  21.436  1.00  0.00           H  
ATOM    937  HG  CYS A  60      26.661  74.739  21.454  1.00  0.00           H  
ATOM    938  N   VAL A  61      27.094  69.455  21.751  1.00  0.00           N  
ATOM    939  CA  VAL A  61      27.447  68.732  22.967  1.00  0.00           C  
ATOM    940  C   VAL A  61      28.656  69.362  23.649  1.00  0.00           C  
ATOM    941  O   VAL A  61      29.661  69.659  23.003  1.00  0.00           O  
ATOM    942  CB  VAL A  61      27.752  67.252  22.672  1.00  0.00           C  
ATOM    943  CG1 VAL A  61      28.187  66.533  23.940  1.00  0.00           C  
ATOM    944  CG2 VAL A  61      26.539  66.572  22.054  1.00  0.00           C  
ATOM    945  H   VAL A  61      27.550  69.232  20.913  1.00  0.00           H  
ATOM    946  HA  VAL A  61      26.603  68.778  23.640  1.00  0.00           H  
ATOM    947  HB  VAL A  61      28.564  67.207  21.962  1.00  0.00           H  
ATOM    948 HG11 VAL A  61      27.371  66.526  24.648  1.00  0.00           H  
ATOM    949 HG12 VAL A  61      28.467  65.517  23.700  1.00  0.00           H  
ATOM    950 HG13 VAL A  61      29.032  67.048  24.372  1.00  0.00           H  
ATOM    951 HG21 VAL A  61      26.425  66.901  21.032  1.00  0.00           H  
ATOM    952 HG22 VAL A  61      26.677  65.501  22.073  1.00  0.00           H  
ATOM    953 HG23 VAL A  61      25.655  66.831  22.617  1.00  0.00           H  
ATOM    954  N   ARG A  62      28.552  69.564  24.959  1.00  0.00           N  
ATOM    955  CA  ARG A  62      29.637  70.160  25.729  1.00  0.00           C  
ATOM    956  C   ARG A  62      29.583  69.706  27.185  1.00  0.00           C  
ATOM    957  O   ARG A  62      28.581  69.882  27.878  1.00  0.00           O  
ATOM    958  CB  ARG A  62      29.564  71.687  25.656  1.00  0.00           C  
ATOM    959  CG  ARG A  62      30.915  72.368  25.805  1.00  0.00           C  
ATOM    960  CD  ARG A  62      30.768  73.877  25.914  1.00  0.00           C  
ATOM    961  NE  ARG A  62      32.058  74.559  25.854  1.00  0.00           N  
ATOM    962  CZ  ARG A  62      32.723  74.774  24.725  1.00  0.00           C  
ATOM    963  NH1 ARG A  62      32.223  74.365  23.568  1.00  0.00           N  
ATOM    964  NH2 ARG A  62      33.893  75.402  24.752  1.00  0.00           N  
ATOM    965  H   ARG A  62      27.725  69.308  25.417  1.00  0.00           H  
ATOM    966  HA  ARG A  62      30.570  69.831  25.296  1.00  0.00           H  
ATOM    967  HB2 ARG A  62      29.146  71.971  24.701  1.00  0.00           H  
ATOM    968  HB3 ARG A  62      28.918  72.042  26.443  1.00  0.00           H  
ATOM    969  HG2 ARG A  62      31.398  71.999  26.698  1.00  0.00           H  
ATOM    970  HG3 ARG A  62      31.522  72.135  24.942  1.00  0.00           H  
ATOM    971  HD2 ARG A  62      30.149  74.226  25.100  1.00  0.00           H  
ATOM    972  HD3 ARG A  62      30.290  74.112  26.854  1.00  0.00           H  
ATOM    973  HE  ARG A  62      32.447  74.870  26.698  1.00  0.00           H  
ATOM    974 HH11 ARG A  62      31.342  73.893  23.544  1.00  0.00           H  
ATOM    975 HH12 ARG A  62      32.724  74.530  22.719  1.00  0.00           H  
ATOM    976 HH21 ARG A  62      34.273  75.713  25.622  1.00  0.00           H  
ATOM    977 HH22 ARG A  62      34.393  75.563  23.901  1.00  0.00           H  
ATOM    978  N   PRO A  63      30.685  69.108  27.660  1.00  0.00           N  
ATOM    979  CA  PRO A  63      31.883  68.892  26.843  1.00  0.00           C  
ATOM    980  C   PRO A  63      31.664  67.845  25.757  1.00  0.00           C  
ATOM    981  O   PRO A  63      30.905  66.894  25.942  1.00  0.00           O  
ATOM    982  CB  PRO A  63      32.920  68.403  27.857  1.00  0.00           C  
ATOM    983  CG  PRO A  63      32.118  67.795  28.956  1.00  0.00           C  
ATOM    984  CD  PRO A  63      30.847  68.595  29.030  1.00  0.00           C  
ATOM    985  HA  PRO A  63      32.225  69.812  26.391  1.00  0.00           H  
ATOM    986  HB2 PRO A  63      33.567  67.673  27.389  1.00  0.00           H  
ATOM    987  HB3 PRO A  63      33.506  69.238  28.210  1.00  0.00           H  
ATOM    988  HG2 PRO A  63      31.900  66.764  28.725  1.00  0.00           H  
ATOM    989  HG3 PRO A  63      32.659  67.867  29.887  1.00  0.00           H  
ATOM    990  HD2 PRO A  63      30.017  67.960  29.305  1.00  0.00           H  
ATOM    991  HD3 PRO A  63      30.952  69.407  29.735  1.00  0.00           H  
ATOM    992  N   ASN A  64      32.333  68.025  24.622  1.00  0.00           N  
ATOM    993  CA  ASN A  64      32.211  67.095  23.506  1.00  0.00           C  
ATOM    994  C   ASN A  64      33.056  65.847  23.743  1.00  0.00           C  
ATOM    995  O   ASN A  64      33.031  64.908  22.947  1.00  0.00           O  
ATOM    996  CB  ASN A  64      32.636  67.773  22.202  1.00  0.00           C  
ATOM    997  CG  ASN A  64      33.960  68.501  22.334  1.00  0.00           C  
ATOM    998  OD1 ASN A  64      35.006  67.881  22.519  1.00  0.00           O  
ATOM    999  ND2 ASN A  64      33.919  69.825  22.238  1.00  0.00           N  
ATOM   1000  H   ASN A  64      32.924  68.803  24.534  1.00  0.00           H  
ATOM   1001  HA  ASN A  64      31.174  66.805  23.429  1.00  0.00           H  
ATOM   1002  HB2 ASN A  64      32.735  67.023  21.430  1.00  0.00           H  
ATOM   1003  HB3 ASN A  64      31.881  68.487  21.911  1.00  0.00           H  
ATOM   1004 HD21 ASN A  64      33.049  70.251  22.090  1.00  0.00           H  
ATOM   1005 HD22 ASN A  64      34.760  70.321  22.319  1.00  0.00           H  
ATOM   1006  N   SER A  65      33.802  65.845  24.843  1.00  0.00           N  
ATOM   1007  CA  SER A  65      34.656  64.713  25.184  1.00  0.00           C  
ATOM   1008  C   SER A  65      35.264  64.889  26.573  1.00  0.00           C  
ATOM   1009  O   SER A  65      35.107  65.935  27.202  1.00  0.00           O  
ATOM   1010  CB  SER A  65      35.769  64.556  24.146  1.00  0.00           C  
ATOM   1011  OG  SER A  65      36.667  65.652  24.190  1.00  0.00           O  
ATOM   1012  H   SER A  65      33.778  66.623  25.439  1.00  0.00           H  
ATOM   1013  HA  SER A  65      34.045  63.823  25.181  1.00  0.00           H  
ATOM   1014  HB2 SER A  65      36.317  63.649  24.344  1.00  0.00           H  
ATOM   1015  HB3 SER A  65      35.332  64.505  23.159  1.00  0.00           H  
ATOM   1016  HG  SER A  65      37.548  65.354  23.953  1.00  0.00           H  
ATOM   1017  N   GLY A  66      35.957  63.857  27.044  1.00  0.00           N  
ATOM   1018  CA  GLY A  66      36.577  63.917  28.355  1.00  0.00           C  
ATOM   1019  C   GLY A  66      36.637  62.562  29.031  1.00  0.00           C  
ATOM   1020  O   GLY A  66      36.275  61.548  28.433  1.00  0.00           O  
ATOM   1021  H   GLY A  66      36.048  63.049  26.498  1.00  0.00           H  
ATOM   1022  HA2 GLY A  66      37.581  64.301  28.250  1.00  0.00           H  
ATOM   1023  HA3 GLY A  66      36.009  64.592  28.979  1.00  0.00           H  
ATOM   1024  N   ILE A  67      37.096  62.543  30.277  1.00  0.00           N  
ATOM   1025  CA  ILE A  67      37.203  61.301  31.033  1.00  0.00           C  
ATOM   1026  C   ILE A  67      36.273  61.312  32.241  1.00  0.00           C  
ATOM   1027  O   ILE A  67      36.210  62.294  32.980  1.00  0.00           O  
ATOM   1028  CB  ILE A  67      38.647  61.056  31.512  1.00  0.00           C  
ATOM   1029  CG1 ILE A  67      39.629  61.235  30.353  1.00  0.00           C  
ATOM   1030  CG2 ILE A  67      38.775  59.665  32.114  1.00  0.00           C  
ATOM   1031  CD1 ILE A  67      41.070  61.358  30.795  1.00  0.00           C  
ATOM   1032  H   ILE A  67      37.369  63.384  30.699  1.00  0.00           H  
ATOM   1033  HA  ILE A  67      36.919  60.488  30.380  1.00  0.00           H  
ATOM   1034  HB  ILE A  67      38.874  61.778  32.281  1.00  0.00           H  
ATOM   1035 HG12 ILE A  67      39.557  60.383  29.694  1.00  0.00           H  
ATOM   1036 HG13 ILE A  67      39.370  62.130  29.806  1.00  0.00           H  
ATOM   1037 HG21 ILE A  67      39.414  59.707  32.984  1.00  0.00           H  
ATOM   1038 HG22 ILE A  67      37.799  59.307  32.402  1.00  0.00           H  
ATOM   1039 HG23 ILE A  67      39.205  58.996  31.385  1.00  0.00           H  
ATOM   1040 HD11 ILE A  67      41.527  62.204  30.302  1.00  0.00           H  
ATOM   1041 HD12 ILE A  67      41.107  61.501  31.865  1.00  0.00           H  
ATOM   1042 HD13 ILE A  67      41.605  60.457  30.533  1.00  0.00           H  
ATOM   1043  N   ILE A  68      35.554  60.212  32.437  1.00  0.00           N  
ATOM   1044  CA  ILE A  68      34.629  60.093  33.557  1.00  0.00           C  
ATOM   1045  C   ILE A  68      35.262  59.324  34.712  1.00  0.00           C  
ATOM   1046  O   ILE A  68      35.454  58.110  34.632  1.00  0.00           O  
ATOM   1047  CB  ILE A  68      33.325  59.389  33.139  1.00  0.00           C  
ATOM   1048  CG1 ILE A  68      32.645  60.160  32.006  1.00  0.00           C  
ATOM   1049  CG2 ILE A  68      32.391  59.255  34.332  1.00  0.00           C  
ATOM   1050  CD1 ILE A  68      31.494  59.411  31.371  1.00  0.00           C  
ATOM   1051  H   ILE A  68      35.648  59.462  31.814  1.00  0.00           H  
ATOM   1052  HA  ILE A  68      34.385  61.090  33.894  1.00  0.00           H  
ATOM   1053  HB  ILE A  68      33.573  58.398  32.792  1.00  0.00           H  
ATOM   1054 HG12 ILE A  68      32.260  61.091  32.392  1.00  0.00           H  
ATOM   1055 HG13 ILE A  68      33.372  60.369  31.234  1.00  0.00           H  
ATOM   1056 HG21 ILE A  68      31.371  59.409  34.009  1.00  0.00           H  
ATOM   1057 HG22 ILE A  68      32.487  58.265  34.754  1.00  0.00           H  
ATOM   1058 HG23 ILE A  68      32.648  59.992  35.077  1.00  0.00           H  
ATOM   1059 HD11 ILE A  68      31.871  58.764  30.593  1.00  0.00           H  
ATOM   1060 HD12 ILE A  68      30.991  58.819  32.122  1.00  0.00           H  
ATOM   1061 HD13 ILE A  68      30.797  60.118  30.944  1.00  0.00           H  
ATOM   1062  N   ASP A  69      35.580  60.037  35.786  1.00  0.00           N  
ATOM   1063  CA  ASP A  69      36.188  59.420  36.961  1.00  0.00           C  
ATOM   1064  C   ASP A  69      35.525  58.083  37.277  1.00  0.00           C  
ATOM   1065  O   ASP A  69      34.353  57.857  36.978  1.00  0.00           O  
ATOM   1066  CB  ASP A  69      36.081  60.355  38.167  1.00  0.00           C  
ATOM   1067  CG  ASP A  69      36.812  61.664  37.952  1.00  0.00           C  
ATOM   1068  OD1 ASP A  69      36.693  62.236  36.849  1.00  0.00           O  
ATOM   1069  OD2 ASP A  69      37.507  62.116  38.887  1.00  0.00           O  
ATOM   1070  H   ASP A  69      35.402  61.000  35.792  1.00  0.00           H  
ATOM   1071  HA  ASP A  69      37.231  59.248  36.742  1.00  0.00           H  
ATOM   1072  HB2 ASP A  69      35.038  60.573  38.353  1.00  0.00           H  
ATOM   1073  HB3 ASP A  69      36.502  59.864  39.032  1.00  0.00           H  
ATOM   1074  N   PRO A  70      36.294  57.172  37.894  1.00  0.00           N  
ATOM   1075  CA  PRO A  70      35.802  55.842  38.264  1.00  0.00           C  
ATOM   1076  C   PRO A  70      34.783  55.894  39.396  1.00  0.00           C  
ATOM   1077  O   PRO A  70      35.068  56.404  40.478  1.00  0.00           O  
ATOM   1078  CB  PRO A  70      37.068  55.110  38.717  1.00  0.00           C  
ATOM   1079  CG  PRO A  70      37.992  56.191  39.161  1.00  0.00           C  
ATOM   1080  CD  PRO A  70      37.701  57.373  38.280  1.00  0.00           C  
ATOM   1081  HA  PRO A  70      35.371  55.329  37.416  1.00  0.00           H  
ATOM   1082  HB2 PRO A  70      36.827  54.436  39.527  1.00  0.00           H  
ATOM   1083  HB3 PRO A  70      37.482  54.553  37.890  1.00  0.00           H  
ATOM   1084  HG2 PRO A  70      37.799  56.436  40.194  1.00  0.00           H  
ATOM   1085  HG3 PRO A  70      39.016  55.873  39.034  1.00  0.00           H  
ATOM   1086  HD2 PRO A  70      37.822  58.294  38.832  1.00  0.00           H  
ATOM   1087  HD3 PRO A  70      38.343  57.364  37.411  1.00  0.00           H  
ATOM   1088  N   GLY A  71      33.592  55.362  39.139  1.00  0.00           N  
ATOM   1089  CA  GLY A  71      32.548  55.358  40.148  1.00  0.00           C  
ATOM   1090  C   GLY A  71      31.890  56.714  40.307  1.00  0.00           C  
ATOM   1091  O   GLY A  71      31.586  57.137  41.422  1.00  0.00           O  
ATOM   1092  H   GLY A  71      33.420  54.968  38.258  1.00  0.00           H  
ATOM   1093  HA2 GLY A  71      31.796  54.635  39.869  1.00  0.00           H  
ATOM   1094  HA3 GLY A  71      32.979  55.067  41.095  1.00  0.00           H  
ATOM   1095  N   SER A  72      31.671  57.398  39.188  1.00  0.00           N  
ATOM   1096  CA  SER A  72      31.050  58.717  39.209  1.00  0.00           C  
ATOM   1097  C   SER A  72      30.169  58.922  37.980  1.00  0.00           C  
ATOM   1098  O   SER A  72      30.253  58.168  37.010  1.00  0.00           O  
ATOM   1099  CB  SER A  72      32.122  59.808  39.269  1.00  0.00           C  
ATOM   1100  OG  SER A  72      32.826  59.763  40.498  1.00  0.00           O  
ATOM   1101  H   SER A  72      31.936  57.007  38.329  1.00  0.00           H  
ATOM   1102  HA  SER A  72      30.434  58.781  40.094  1.00  0.00           H  
ATOM   1103  HB2 SER A  72      32.823  59.665  38.461  1.00  0.00           H  
ATOM   1104  HB3 SER A  72      31.652  60.776  39.172  1.00  0.00           H  
ATOM   1105  HG  SER A  72      33.618  59.232  40.395  1.00  0.00           H  
ATOM   1106  N   ILE A  73      29.325  59.947  38.030  1.00  0.00           N  
ATOM   1107  CA  ILE A  73      28.428  60.252  36.921  1.00  0.00           C  
ATOM   1108  C   ILE A  73      28.688  61.652  36.374  1.00  0.00           C  
ATOM   1109  O   ILE A  73      28.902  62.597  37.133  1.00  0.00           O  
ATOM   1110  CB  ILE A  73      26.952  60.145  37.345  1.00  0.00           C  
ATOM   1111  CG1 ILE A  73      26.643  58.730  37.840  1.00  0.00           C  
ATOM   1112  CG2 ILE A  73      26.040  60.518  36.186  1.00  0.00           C  
ATOM   1113  CD1 ILE A  73      25.365  58.638  38.644  1.00  0.00           C  
ATOM   1114  H   ILE A  73      29.305  60.511  38.830  1.00  0.00           H  
ATOM   1115  HA  ILE A  73      28.611  59.531  36.138  1.00  0.00           H  
ATOM   1116  HB  ILE A  73      26.779  60.845  38.147  1.00  0.00           H  
ATOM   1117 HG12 ILE A  73      26.548  58.072  36.992  1.00  0.00           H  
ATOM   1118 HG13 ILE A  73      27.455  58.391  38.467  1.00  0.00           H  
ATOM   1119 HG21 ILE A  73      26.002  59.701  35.480  1.00  0.00           H  
ATOM   1120 HG22 ILE A  73      25.046  60.715  36.559  1.00  0.00           H  
ATOM   1121 HG23 ILE A  73      26.423  61.400  35.695  1.00  0.00           H  
ATOM   1122 HD11 ILE A  73      24.800  59.552  38.530  1.00  0.00           H  
ATOM   1123 HD12 ILE A  73      24.776  57.805  38.291  1.00  0.00           H  
ATOM   1124 HD13 ILE A  73      25.605  58.492  39.688  1.00  0.00           H  
ATOM   1125  N   VAL A  74      28.667  61.776  35.050  1.00  0.00           N  
ATOM   1126  CA  VAL A  74      28.897  63.061  34.400  1.00  0.00           C  
ATOM   1127  C   VAL A  74      27.649  63.536  33.665  1.00  0.00           C  
ATOM   1128  O   VAL A  74      26.946  62.744  33.036  1.00  0.00           O  
ATOM   1129  CB  VAL A  74      30.069  62.984  33.403  1.00  0.00           C  
ATOM   1130  CG1 VAL A  74      30.072  64.198  32.487  1.00  0.00           C  
ATOM   1131  CG2 VAL A  74      31.391  62.863  34.146  1.00  0.00           C  
ATOM   1132  H   VAL A  74      28.491  60.987  34.498  1.00  0.00           H  
ATOM   1133  HA  VAL A  74      29.149  63.782  35.164  1.00  0.00           H  
ATOM   1134  HB  VAL A  74      29.940  62.101  32.795  1.00  0.00           H  
ATOM   1135 HG11 VAL A  74      30.897  64.124  31.794  1.00  0.00           H  
ATOM   1136 HG12 VAL A  74      29.142  64.237  31.938  1.00  0.00           H  
ATOM   1137 HG13 VAL A  74      30.179  65.095  33.078  1.00  0.00           H  
ATOM   1138 HG21 VAL A  74      31.452  61.894  34.618  1.00  0.00           H  
ATOM   1139 HG22 VAL A  74      32.209  62.974  33.447  1.00  0.00           H  
ATOM   1140 HG23 VAL A  74      31.455  63.636  34.898  1.00  0.00           H  
ATOM   1141  N   THR A  75      27.379  64.836  33.745  1.00  0.00           N  
ATOM   1142  CA  THR A  75      26.216  65.417  33.088  1.00  0.00           C  
ATOM   1143  C   THR A  75      26.627  66.254  31.882  1.00  0.00           C  
ATOM   1144  O   THR A  75      27.076  67.391  32.028  1.00  0.00           O  
ATOM   1145  CB  THR A  75      25.404  66.297  34.057  1.00  0.00           C  
ATOM   1146  OG1 THR A  75      25.251  65.628  35.314  1.00  0.00           O  
ATOM   1147  CG2 THR A  75      24.035  66.618  33.478  1.00  0.00           C  
ATOM   1148  H   THR A  75      27.977  65.415  34.261  1.00  0.00           H  
ATOM   1149  HA  THR A  75      25.582  64.607  32.753  1.00  0.00           H  
ATOM   1150  HB  THR A  75      25.940  67.223  34.213  1.00  0.00           H  
ATOM   1151  HG1 THR A  75      25.286  66.272  36.025  1.00  0.00           H  
ATOM   1152 HG21 THR A  75      23.757  67.626  33.748  1.00  0.00           H  
ATOM   1153 HG22 THR A  75      23.306  65.925  33.871  1.00  0.00           H  
ATOM   1154 HG23 THR A  75      24.070  66.532  32.403  1.00  0.00           H  
ATOM   1155  N   VAL A  76      26.469  65.686  30.691  1.00  0.00           N  
ATOM   1156  CA  VAL A  76      26.822  66.381  29.460  1.00  0.00           C  
ATOM   1157  C   VAL A  76      25.658  67.226  28.952  1.00  0.00           C  
ATOM   1158  O   VAL A  76      24.503  66.804  29.004  1.00  0.00           O  
ATOM   1159  CB  VAL A  76      27.242  65.392  28.357  1.00  0.00           C  
ATOM   1160  CG1 VAL A  76      27.485  66.124  27.046  1.00  0.00           C  
ATOM   1161  CG2 VAL A  76      28.482  64.618  28.781  1.00  0.00           C  
ATOM   1162  H   VAL A  76      26.105  64.778  30.639  1.00  0.00           H  
ATOM   1163  HA  VAL A  76      27.660  67.030  29.670  1.00  0.00           H  
ATOM   1164  HB  VAL A  76      26.437  64.687  28.207  1.00  0.00           H  
ATOM   1165 HG11 VAL A  76      26.588  66.089  26.443  1.00  0.00           H  
ATOM   1166 HG12 VAL A  76      27.743  67.153  27.250  1.00  0.00           H  
ATOM   1167 HG13 VAL A  76      28.294  65.649  26.512  1.00  0.00           H  
ATOM   1168 HG21 VAL A  76      29.186  64.592  27.963  1.00  0.00           H  
ATOM   1169 HG22 VAL A  76      28.937  65.104  29.632  1.00  0.00           H  
ATOM   1170 HG23 VAL A  76      28.202  63.611  29.050  1.00  0.00           H  
ATOM   1171  N   SER A  77      25.971  68.420  28.460  1.00  0.00           N  
ATOM   1172  CA  SER A  77      24.951  69.326  27.945  1.00  0.00           C  
ATOM   1173  C   SER A  77      24.814  69.187  26.432  1.00  0.00           C  
ATOM   1174  O   SER A  77      25.708  69.569  25.679  1.00  0.00           O  
ATOM   1175  CB  SER A  77      25.294  70.772  28.307  1.00  0.00           C  
ATOM   1176  OG  SER A  77      25.392  70.938  29.711  1.00  0.00           O  
ATOM   1177  H   SER A  77      26.911  68.700  28.445  1.00  0.00           H  
ATOM   1178  HA  SER A  77      24.010  69.062  28.406  1.00  0.00           H  
ATOM   1179  HB2 SER A  77      26.239  71.038  27.859  1.00  0.00           H  
ATOM   1180  HB3 SER A  77      24.520  71.427  27.932  1.00  0.00           H  
ATOM   1181  HG  SER A  77      24.720  71.556  30.008  1.00  0.00           H  
ATOM   1182  N   VAL A  78      23.686  68.636  25.994  1.00  0.00           N  
ATOM   1183  CA  VAL A  78      23.430  68.446  24.572  1.00  0.00           C  
ATOM   1184  C   VAL A  78      22.342  69.394  24.079  1.00  0.00           C  
ATOM   1185  O   VAL A  78      21.154  69.081  24.148  1.00  0.00           O  
ATOM   1186  CB  VAL A  78      23.010  66.996  24.266  1.00  0.00           C  
ATOM   1187  CG1 VAL A  78      22.845  66.793  22.768  1.00  0.00           C  
ATOM   1188  CG2 VAL A  78      24.024  66.017  24.836  1.00  0.00           C  
ATOM   1189  H   VAL A  78      23.011  68.351  26.644  1.00  0.00           H  
ATOM   1190  HA  VAL A  78      24.345  68.654  24.037  1.00  0.00           H  
ATOM   1191  HB  VAL A  78      22.056  66.812  24.738  1.00  0.00           H  
ATOM   1192 HG11 VAL A  78      23.734  66.330  22.367  1.00  0.00           H  
ATOM   1193 HG12 VAL A  78      21.992  66.158  22.582  1.00  0.00           H  
ATOM   1194 HG13 VAL A  78      22.691  67.750  22.289  1.00  0.00           H  
ATOM   1195 HG21 VAL A  78      24.743  65.759  24.073  1.00  0.00           H  
ATOM   1196 HG22 VAL A  78      24.535  66.472  25.672  1.00  0.00           H  
ATOM   1197 HG23 VAL A  78      23.515  65.124  25.169  1.00  0.00           H  
ATOM   1198  N   MET A  79      22.757  70.553  23.580  1.00  0.00           N  
ATOM   1199  CA  MET A  79      21.817  71.547  23.072  1.00  0.00           C  
ATOM   1200  C   MET A  79      21.434  71.244  21.628  1.00  0.00           C  
ATOM   1201  O   MET A  79      22.297  71.017  20.780  1.00  0.00           O  
ATOM   1202  CB  MET A  79      22.422  72.949  23.169  1.00  0.00           C  
ATOM   1203  CG  MET A  79      22.346  73.549  24.563  1.00  0.00           C  
ATOM   1204  SD  MET A  79      23.633  74.777  24.862  1.00  0.00           S  
ATOM   1205  CE  MET A  79      25.094  73.742  24.863  1.00  0.00           C  
ATOM   1206  H   MET A  79      23.718  70.746  23.551  1.00  0.00           H  
ATOM   1207  HA  MET A  79      20.929  71.505  23.685  1.00  0.00           H  
ATOM   1208  HB2 MET A  79      23.461  72.900  22.878  1.00  0.00           H  
ATOM   1209  HB3 MET A  79      21.897  73.602  22.489  1.00  0.00           H  
ATOM   1210  HG2 MET A  79      21.383  74.023  24.685  1.00  0.00           H  
ATOM   1211  HG3 MET A  79      22.449  72.756  25.288  1.00  0.00           H  
ATOM   1212  HE1 MET A  79      25.610  73.846  23.920  1.00  0.00           H  
ATOM   1213  HE2 MET A  79      25.748  74.045  25.667  1.00  0.00           H  
ATOM   1214  HE3 MET A  79      24.804  72.711  25.003  1.00  0.00           H  
ATOM   1215  N   LEU A  80      20.133  71.240  21.354  1.00  0.00           N  
ATOM   1216  CA  LEU A  80      19.635  70.964  20.011  1.00  0.00           C  
ATOM   1217  C   LEU A  80      19.196  72.251  19.319  1.00  0.00           C  
ATOM   1218  O   LEU A  80      18.279  72.931  19.776  1.00  0.00           O  
ATOM   1219  CB  LEU A  80      18.465  69.980  20.071  1.00  0.00           C  
ATOM   1220  CG  LEU A  80      18.293  69.068  18.858  1.00  0.00           C  
ATOM   1221  CD1 LEU A  80      17.049  68.206  19.009  1.00  0.00           C  
ATOM   1222  CD2 LEU A  80      18.222  69.889  17.578  1.00  0.00           C  
ATOM   1223  H   LEU A  80      19.493  71.428  22.072  1.00  0.00           H  
ATOM   1224  HA  LEU A  80      20.440  70.521  19.444  1.00  0.00           H  
ATOM   1225  HB2 LEU A  80      18.605  69.354  20.939  1.00  0.00           H  
ATOM   1226  HB3 LEU A  80      17.557  70.555  20.187  1.00  0.00           H  
ATOM   1227  HG  LEU A  80      19.148  68.409  18.786  1.00  0.00           H  
ATOM   1228 HD11 LEU A  80      16.394  68.647  19.745  1.00  0.00           H  
ATOM   1229 HD12 LEU A  80      17.334  67.215  19.329  1.00  0.00           H  
ATOM   1230 HD13 LEU A  80      16.536  68.145  18.061  1.00  0.00           H  
ATOM   1231 HD21 LEU A  80      19.129  70.465  17.471  1.00  0.00           H  
ATOM   1232 HD22 LEU A  80      17.374  70.558  17.626  1.00  0.00           H  
ATOM   1233 HD23 LEU A  80      18.113  69.228  16.732  1.00  0.00           H  
ATOM   1234  N   GLN A  81      19.857  72.576  18.213  1.00  0.00           N  
ATOM   1235  CA  GLN A  81      19.533  73.780  17.455  1.00  0.00           C  
ATOM   1236  C   GLN A  81      18.086  73.750  16.976  1.00  0.00           C  
ATOM   1237  O   GLN A  81      17.548  72.702  16.617  1.00  0.00           O  
ATOM   1238  CB  GLN A  81      20.477  73.926  16.261  1.00  0.00           C  
ATOM   1239  CG  GLN A  81      21.747  74.699  16.579  1.00  0.00           C  
ATOM   1240  CD  GLN A  81      22.202  74.509  18.012  1.00  0.00           C  
ATOM   1241  OE1 GLN A  81      22.913  73.555  18.329  1.00  0.00           O  
ATOM   1242  NE2 GLN A  81      21.792  75.419  18.889  1.00  0.00           N  
ATOM   1243  H   GLN A  81      20.579  71.993  17.898  1.00  0.00           H  
ATOM   1244  HA  GLN A  81      19.664  74.628  18.111  1.00  0.00           H  
ATOM   1245  HB2 GLN A  81      20.756  72.942  15.915  1.00  0.00           H  
ATOM   1246  HB3 GLN A  81      19.957  74.442  15.467  1.00  0.00           H  
ATOM   1247  HG2 GLN A  81      22.533  74.360  15.921  1.00  0.00           H  
ATOM   1248  HG3 GLN A  81      21.565  75.750  16.409  1.00  0.00           H  
ATOM   1249 HE21 GLN A  81      21.227  76.151  18.564  1.00  0.00           H  
ATOM   1250 HE22 GLN A  81      22.071  75.320  19.822  1.00  0.00           H  
ATOM   1251  N   PRO A  82      17.440  74.924  16.969  1.00  0.00           N  
ATOM   1252  CA  PRO A  82      16.046  75.058  16.534  1.00  0.00           C  
ATOM   1253  C   PRO A  82      15.883  74.848  15.033  1.00  0.00           C  
ATOM   1254  O   PRO A  82      16.463  75.577  14.227  1.00  0.00           O  
ATOM   1255  CB  PRO A  82      15.692  76.498  16.914  1.00  0.00           C  
ATOM   1256  CG  PRO A  82      16.997  77.218  16.926  1.00  0.00           C  
ATOM   1257  CD  PRO A  82      18.019  76.213  17.383  1.00  0.00           C  
ATOM   1258  HA  PRO A  82      15.398  74.375  17.064  1.00  0.00           H  
ATOM   1259  HB2 PRO A  82      15.019  76.912  16.177  1.00  0.00           H  
ATOM   1260  HB3 PRO A  82      15.225  76.513  17.886  1.00  0.00           H  
ATOM   1261  HG2 PRO A  82      17.233  77.567  15.933  1.00  0.00           H  
ATOM   1262  HG3 PRO A  82      16.952  78.046  17.618  1.00  0.00           H  
ATOM   1263  HD2 PRO A  82      18.964  76.387  16.890  1.00  0.00           H  
ATOM   1264  HD3 PRO A  82      18.137  76.255  18.456  1.00  0.00           H  
ATOM   1265  N   PHE A  83      15.092  73.847  14.662  1.00  0.00           N  
ATOM   1266  CA  PHE A  83      14.854  73.541  13.256  1.00  0.00           C  
ATOM   1267  C   PHE A  83      13.400  73.138  13.025  1.00  0.00           C  
ATOM   1268  O   PHE A  83      12.671  72.837  13.971  1.00  0.00           O  
ATOM   1269  CB  PHE A  83      15.785  72.419  12.792  1.00  0.00           C  
ATOM   1270  CG  PHE A  83      15.386  71.061  13.297  1.00  0.00           C  
ATOM   1271  CD1 PHE A  83      15.745  70.648  14.570  1.00  0.00           C  
ATOM   1272  CD2 PHE A  83      14.653  70.198  12.499  1.00  0.00           C  
ATOM   1273  CE1 PHE A  83      15.380  69.399  15.036  1.00  0.00           C  
ATOM   1274  CE2 PHE A  83      14.284  68.949  12.959  1.00  0.00           C  
ATOM   1275  CZ  PHE A  83      14.647  68.549  14.231  1.00  0.00           C  
ATOM   1276  H   PHE A  83      14.657  73.301  15.351  1.00  0.00           H  
ATOM   1277  HA  PHE A  83      15.064  74.431  12.684  1.00  0.00           H  
ATOM   1278  HB2 PHE A  83      15.785  72.384  11.713  1.00  0.00           H  
ATOM   1279  HB3 PHE A  83      16.786  72.623  13.142  1.00  0.00           H  
ATOM   1280  HD1 PHE A  83      16.317  71.312  15.201  1.00  0.00           H  
ATOM   1281  HD2 PHE A  83      14.367  70.511  11.503  1.00  0.00           H  
ATOM   1282  HE1 PHE A  83      15.665  69.089  16.030  1.00  0.00           H  
ATOM   1283  HE2 PHE A  83      13.712  68.287  12.327  1.00  0.00           H  
ATOM   1284  HZ  PHE A  83      14.361  67.573  14.593  1.00  0.00           H  
ATOM   1285  N   ASP A  84      12.986  73.137  11.764  1.00  0.00           N  
ATOM   1286  CA  ASP A  84      11.620  72.771  11.407  1.00  0.00           C  
ATOM   1287  C   ASP A  84      11.375  71.285  11.648  1.00  0.00           C  
ATOM   1288  O   ASP A  84      11.687  70.449  10.800  1.00  0.00           O  
ATOM   1289  CB  ASP A  84      11.342  73.116   9.943  1.00  0.00           C  
ATOM   1290  CG  ASP A  84      11.493  74.598   9.659  1.00  0.00           C  
ATOM   1291  OD1 ASP A  84      10.567  75.363   9.996  1.00  0.00           O  
ATOM   1292  OD2 ASP A  84      12.537  74.991   9.097  1.00  0.00           O  
ATOM   1293  H   ASP A  84      13.614  73.387  11.054  1.00  0.00           H  
ATOM   1294  HA  ASP A  84      10.950  73.339  12.035  1.00  0.00           H  
ATOM   1295  HB2 ASP A  84      12.035  72.576   9.315  1.00  0.00           H  
ATOM   1296  HB3 ASP A  84      10.333  72.820   9.696  1.00  0.00           H  
ATOM   1297  N   TYR A  85      10.815  70.964  12.809  1.00  0.00           N  
ATOM   1298  CA  TYR A  85      10.531  69.578  13.164  1.00  0.00           C  
ATOM   1299  C   TYR A  85       9.218  69.115  12.540  1.00  0.00           C  
ATOM   1300  O   TYR A  85       8.237  69.857  12.507  1.00  0.00           O  
ATOM   1301  CB  TYR A  85      10.470  69.421  14.684  1.00  0.00           C  
ATOM   1302  CG  TYR A  85       9.706  68.196  15.136  1.00  0.00           C  
ATOM   1303  CD1 TYR A  85       8.319  68.160  15.077  1.00  0.00           C  
ATOM   1304  CD2 TYR A  85      10.371  67.079  15.622  1.00  0.00           C  
ATOM   1305  CE1 TYR A  85       7.616  67.044  15.489  1.00  0.00           C  
ATOM   1306  CE2 TYR A  85       9.677  65.958  16.036  1.00  0.00           C  
ATOM   1307  CZ  TYR A  85       8.300  65.945  15.967  1.00  0.00           C  
ATOM   1308  OH  TYR A  85       7.604  64.831  16.379  1.00  0.00           O  
ATOM   1309  H   TYR A  85      10.588  71.675  13.445  1.00  0.00           H  
ATOM   1310  HA  TYR A  85      11.334  68.967  12.780  1.00  0.00           H  
ATOM   1311  HB2 TYR A  85      11.474  69.345  15.072  1.00  0.00           H  
ATOM   1312  HB3 TYR A  85       9.989  70.289  15.110  1.00  0.00           H  
ATOM   1313  HD1 TYR A  85       7.785  69.021  14.702  1.00  0.00           H  
ATOM   1314  HD2 TYR A  85      11.450  67.092  15.676  1.00  0.00           H  
ATOM   1315  HE1 TYR A  85       6.537  67.033  15.435  1.00  0.00           H  
ATOM   1316  HE2 TYR A  85      10.212  65.098  16.411  1.00  0.00           H  
ATOM   1317  HH  TYR A  85       7.807  64.095  15.798  1.00  0.00           H  
ATOM   1318  N   ASP A  86       9.209  67.881  12.048  1.00  0.00           N  
ATOM   1319  CA  ASP A  86       8.016  67.316  11.426  1.00  0.00           C  
ATOM   1320  C   ASP A  86       7.421  66.213  12.296  1.00  0.00           C  
ATOM   1321  O   ASP A  86       8.133  65.389  12.870  1.00  0.00           O  
ATOM   1322  CB  ASP A  86       8.351  66.763  10.039  1.00  0.00           C  
ATOM   1323  CG  ASP A  86       7.170  66.828   9.090  1.00  0.00           C  
ATOM   1324  OD1 ASP A  86       6.303  65.932   9.161  1.00  0.00           O  
ATOM   1325  OD2 ASP A  86       7.114  67.773   8.276  1.00  0.00           O  
ATOM   1326  H   ASP A  86      10.022  67.337  12.103  1.00  0.00           H  
ATOM   1327  HA  ASP A  86       7.289  68.107  11.322  1.00  0.00           H  
ATOM   1328  HB2 ASP A  86       9.161  67.340   9.616  1.00  0.00           H  
ATOM   1329  HB3 ASP A  86       8.659  65.733  10.134  1.00  0.00           H  
ATOM   1330  N   PRO A  87       6.084  66.195  12.397  1.00  0.00           N  
ATOM   1331  CA  PRO A  87       5.363  65.200  13.196  1.00  0.00           C  
ATOM   1332  C   PRO A  87       5.432  63.805  12.583  1.00  0.00           C  
ATOM   1333  O   PRO A  87       5.265  62.803  13.276  1.00  0.00           O  
ATOM   1334  CB  PRO A  87       3.922  65.715  13.190  1.00  0.00           C  
ATOM   1335  CG  PRO A  87       3.816  66.530  11.948  1.00  0.00           C  
ATOM   1336  CD  PRO A  87       5.172  67.147  11.740  1.00  0.00           C  
ATOM   1337  HA  PRO A  87       5.730  65.164  14.211  1.00  0.00           H  
ATOM   1338  HB2 PRO A  87       3.238  64.879  13.175  1.00  0.00           H  
ATOM   1339  HB3 PRO A  87       3.747  66.314  14.070  1.00  0.00           H  
ATOM   1340  HG2 PRO A  87       3.562  65.895  11.113  1.00  0.00           H  
ATOM   1341  HG3 PRO A  87       3.070  67.301  12.077  1.00  0.00           H  
ATOM   1342  HD2 PRO A  87       5.393  67.228  10.686  1.00  0.00           H  
ATOM   1343  HD3 PRO A  87       5.222  68.117  12.213  1.00  0.00           H  
ATOM   1344  N   ASN A  88       5.680  63.749  11.278  1.00  0.00           N  
ATOM   1345  CA  ASN A  88       5.771  62.476  10.571  1.00  0.00           C  
ATOM   1346  C   ASN A  88       7.216  62.169  10.188  1.00  0.00           C  
ATOM   1347  O   ASN A  88       7.478  61.595   9.132  1.00  0.00           O  
ATOM   1348  CB  ASN A  88       4.894  62.500   9.318  1.00  0.00           C  
ATOM   1349  CG  ASN A  88       4.918  63.847   8.622  1.00  0.00           C  
ATOM   1350  OD1 ASN A  88       4.158  64.752   8.968  1.00  0.00           O  
ATOM   1351  ND2 ASN A  88       5.794  63.985   7.633  1.00  0.00           N  
ATOM   1352  H   ASN A  88       5.804  64.583  10.778  1.00  0.00           H  
ATOM   1353  HA  ASN A  88       5.415  61.703  11.236  1.00  0.00           H  
ATOM   1354  HB2 ASN A  88       5.246  61.751   8.625  1.00  0.00           H  
ATOM   1355  HB3 ASN A  88       3.874  62.277   9.596  1.00  0.00           H  
ATOM   1356 HD21 ASN A  88       6.367  63.222   7.412  1.00  0.00           H  
ATOM   1357 HD22 ASN A  88       5.832  64.846   7.166  1.00  0.00           H  
ATOM   1358  N   GLU A  89       8.147  62.555  11.054  1.00  0.00           N  
ATOM   1359  CA  GLU A  89       9.565  62.321  10.805  1.00  0.00           C  
ATOM   1360  C   GLU A  89       9.892  60.833  10.885  1.00  0.00           C  
ATOM   1361  O   GLU A  89       9.232  60.077  11.596  1.00  0.00           O  
ATOM   1362  CB  GLU A  89      10.417  63.097  11.812  1.00  0.00           C  
ATOM   1363  CG  GLU A  89      10.835  64.473  11.324  1.00  0.00           C  
ATOM   1364  CD  GLU A  89      11.232  64.476   9.860  1.00  0.00           C  
ATOM   1365  OE1 GLU A  89      12.423  64.242   9.567  1.00  0.00           O  
ATOM   1366  OE2 GLU A  89      10.350  64.714   9.007  1.00  0.00           O  
ATOM   1367  H   GLU A  89       7.875  63.009  11.879  1.00  0.00           H  
ATOM   1368  HA  GLU A  89       9.790  62.675   9.811  1.00  0.00           H  
ATOM   1369  HB2 GLU A  89       9.853  63.218  12.726  1.00  0.00           H  
ATOM   1370  HB3 GLU A  89      11.309  62.526  12.024  1.00  0.00           H  
ATOM   1371  HG2 GLU A  89      10.010  65.156  11.458  1.00  0.00           H  
ATOM   1372  HG3 GLU A  89      11.678  64.809  11.910  1.00  0.00           H  
ATOM   1373  N   LYS A  90      10.918  60.419  10.148  1.00  0.00           N  
ATOM   1374  CA  LYS A  90      11.336  59.022  10.134  1.00  0.00           C  
ATOM   1375  C   LYS A  90      12.441  58.775  11.156  1.00  0.00           C  
ATOM   1376  O   LYS A  90      13.175  59.691  11.525  1.00  0.00           O  
ATOM   1377  CB  LYS A  90      11.821  58.628   8.736  1.00  0.00           C  
ATOM   1378  CG  LYS A  90      10.702  58.204   7.801  1.00  0.00           C  
ATOM   1379  CD  LYS A  90      10.128  56.853   8.195  1.00  0.00           C  
ATOM   1380  CE  LYS A  90      10.944  55.709   7.614  1.00  0.00           C  
ATOM   1381  NZ  LYS A  90      10.479  55.333   6.251  1.00  0.00           N  
ATOM   1382  H   LYS A  90      11.407  61.070   9.601  1.00  0.00           H  
ATOM   1383  HA  LYS A  90      10.481  58.418  10.392  1.00  0.00           H  
ATOM   1384  HB2 LYS A  90      12.331  59.471   8.295  1.00  0.00           H  
ATOM   1385  HB3 LYS A  90      12.516  57.806   8.829  1.00  0.00           H  
ATOM   1386  HG2 LYS A  90       9.915  58.942   7.839  1.00  0.00           H  
ATOM   1387  HG3 LYS A  90      11.091  58.140   6.795  1.00  0.00           H  
ATOM   1388  HD2 LYS A  90      10.130  56.772   9.272  1.00  0.00           H  
ATOM   1389  HD3 LYS A  90       9.114  56.783   7.829  1.00  0.00           H  
ATOM   1390  HE2 LYS A  90      11.978  56.014   7.561  1.00  0.00           H  
ATOM   1391  HE3 LYS A  90      10.853  54.852   8.265  1.00  0.00           H  
ATOM   1392  HZ1 LYS A  90       9.455  55.150   6.260  1.00  0.00           H  
ATOM   1393  HZ2 LYS A  90      10.970  54.474   5.930  1.00  0.00           H  
ATOM   1394  HZ3 LYS A  90      10.677  56.104   5.580  1.00  0.00           H  
ATOM   1395  N   SER A  91      12.554  57.529  11.607  1.00  0.00           N  
ATOM   1396  CA  SER A  91      13.568  57.162  12.589  1.00  0.00           C  
ATOM   1397  C   SER A  91      14.931  56.992  11.924  1.00  0.00           C  
ATOM   1398  O   SER A  91      15.449  55.880  11.819  1.00  0.00           O  
ATOM   1399  CB  SER A  91      13.172  55.869  13.303  1.00  0.00           C  
ATOM   1400  OG  SER A  91      11.992  56.049  14.067  1.00  0.00           O  
ATOM   1401  H   SER A  91      11.939  56.843  11.274  1.00  0.00           H  
ATOM   1402  HA  SER A  91      13.632  57.959  13.315  1.00  0.00           H  
ATOM   1403  HB2 SER A  91      12.998  55.094  12.571  1.00  0.00           H  
ATOM   1404  HB3 SER A  91      13.971  55.566  13.964  1.00  0.00           H  
ATOM   1405  HG  SER A  91      11.590  55.195  14.242  1.00  0.00           H  
ATOM   1406  N   LYS A  92      15.506  58.103  11.475  1.00  0.00           N  
ATOM   1407  CA  LYS A  92      16.809  58.079  10.821  1.00  0.00           C  
ATOM   1408  C   LYS A  92      17.912  58.490  11.791  1.00  0.00           C  
ATOM   1409  O   LYS A  92      18.791  57.692  12.122  1.00  0.00           O  
ATOM   1410  CB  LYS A  92      16.810  59.012   9.608  1.00  0.00           C  
ATOM   1411  CG  LYS A  92      15.934  58.525   8.466  1.00  0.00           C  
ATOM   1412  CD  LYS A  92      16.669  57.527   7.587  1.00  0.00           C  
ATOM   1413  CE  LYS A  92      17.423  58.223   6.464  1.00  0.00           C  
ATOM   1414  NZ  LYS A  92      18.235  57.264   5.665  1.00  0.00           N  
ATOM   1415  H   LYS A  92      15.043  58.960  11.588  1.00  0.00           H  
ATOM   1416  HA  LYS A  92      16.996  57.069  10.489  1.00  0.00           H  
ATOM   1417  HB2 LYS A  92      16.456  59.984   9.916  1.00  0.00           H  
ATOM   1418  HB3 LYS A  92      17.823  59.106   9.242  1.00  0.00           H  
ATOM   1419  HG2 LYS A  92      15.056  58.049   8.876  1.00  0.00           H  
ATOM   1420  HG3 LYS A  92      15.639  59.373   7.864  1.00  0.00           H  
ATOM   1421  HD2 LYS A  92      17.374  56.977   8.192  1.00  0.00           H  
ATOM   1422  HD3 LYS A  92      15.951  56.843   7.156  1.00  0.00           H  
ATOM   1423  HE2 LYS A  92      16.711  58.708   5.815  1.00  0.00           H  
ATOM   1424  HE3 LYS A  92      18.079  58.964   6.896  1.00  0.00           H  
ATOM   1425  HZ1 LYS A  92      19.131  57.061   6.152  1.00  0.00           H  
ATOM   1426  HZ2 LYS A  92      18.447  57.668   4.730  1.00  0.00           H  
ATOM   1427  HZ3 LYS A  92      17.714  56.374   5.536  1.00  0.00           H  
ATOM   1428  N   HIS A  93      17.860  59.737  12.247  1.00  0.00           N  
ATOM   1429  CA  HIS A  93      18.854  60.252  13.181  1.00  0.00           C  
ATOM   1430  C   HIS A  93      19.253  59.184  14.195  1.00  0.00           C  
ATOM   1431  O   HIS A  93      18.446  58.329  14.562  1.00  0.00           O  
ATOM   1432  CB  HIS A  93      18.312  61.483  13.908  1.00  0.00           C  
ATOM   1433  CG  HIS A  93      18.525  62.764  13.160  1.00  0.00           C  
ATOM   1434  ND1 HIS A  93      17.779  63.123  12.057  1.00  0.00           N  
ATOM   1435  CD2 HIS A  93      19.404  63.772  13.363  1.00  0.00           C  
ATOM   1436  CE1 HIS A  93      18.191  64.296  11.614  1.00  0.00           C  
ATOM   1437  NE2 HIS A  93      19.176  64.712  12.388  1.00  0.00           N  
ATOM   1438  H   HIS A  93      17.136  60.326  11.947  1.00  0.00           H  
ATOM   1439  HA  HIS A  93      19.727  60.537  12.613  1.00  0.00           H  
ATOM   1440  HB2 HIS A  93      17.250  61.362  14.064  1.00  0.00           H  
ATOM   1441  HB3 HIS A  93      18.803  61.573  14.867  1.00  0.00           H  
ATOM   1442  HD1 HIS A  93      17.055  62.595  11.659  1.00  0.00           H  
ATOM   1443  HD2 HIS A  93      20.147  63.827  14.146  1.00  0.00           H  
ATOM   1444  HE1 HIS A  93      17.791  64.827  10.761  1.00  0.00           H  
ATOM   1445  HE2 HIS A  93      19.719  65.512  12.231  1.00  0.00           H  
ATOM   1446  N   LYS A  94      20.503  59.236  14.641  1.00  0.00           N  
ATOM   1447  CA  LYS A  94      21.010  58.272  15.611  1.00  0.00           C  
ATOM   1448  C   LYS A  94      22.141  58.877  16.437  1.00  0.00           C  
ATOM   1449  O   LYS A  94      22.851  59.770  15.977  1.00  0.00           O  
ATOM   1450  CB  LYS A  94      21.503  57.010  14.899  1.00  0.00           C  
ATOM   1451  CG  LYS A  94      21.628  55.805  15.814  1.00  0.00           C  
ATOM   1452  CD  LYS A  94      22.642  54.805  15.284  1.00  0.00           C  
ATOM   1453  CE  LYS A  94      22.051  53.947  14.176  1.00  0.00           C  
ATOM   1454  NZ  LYS A  94      21.136  52.902  14.712  1.00  0.00           N  
ATOM   1455  H   LYS A  94      21.100  59.940  14.310  1.00  0.00           H  
ATOM   1456  HA  LYS A  94      20.198  58.008  16.272  1.00  0.00           H  
ATOM   1457  HB2 LYS A  94      20.811  56.765  14.107  1.00  0.00           H  
ATOM   1458  HB3 LYS A  94      22.474  57.211  14.468  1.00  0.00           H  
ATOM   1459  HG2 LYS A  94      21.944  56.138  16.792  1.00  0.00           H  
ATOM   1460  HG3 LYS A  94      20.665  55.321  15.890  1.00  0.00           H  
ATOM   1461  HD2 LYS A  94      23.493  55.342  14.893  1.00  0.00           H  
ATOM   1462  HD3 LYS A  94      22.959  54.164  16.094  1.00  0.00           H  
ATOM   1463  HE2 LYS A  94      21.500  54.582  13.500  1.00  0.00           H  
ATOM   1464  HE3 LYS A  94      22.859  53.467  13.642  1.00  0.00           H  
ATOM   1465  HZ1 LYS A  94      20.649  52.418  13.931  1.00  0.00           H  
ATOM   1466  HZ2 LYS A  94      20.425  53.335  15.335  1.00  0.00           H  
ATOM   1467  HZ3 LYS A  94      21.676  52.198  15.257  1.00  0.00           H  
ATOM   1468  N   PHE A  95      22.303  58.383  17.661  1.00  0.00           N  
ATOM   1469  CA  PHE A  95      23.348  58.874  18.551  1.00  0.00           C  
ATOM   1470  C   PHE A  95      24.258  57.735  19.002  1.00  0.00           C  
ATOM   1471  O   PHE A  95      23.835  56.842  19.737  1.00  0.00           O  
ATOM   1472  CB  PHE A  95      22.729  59.561  19.770  1.00  0.00           C  
ATOM   1473  CG  PHE A  95      23.617  60.602  20.388  1.00  0.00           C  
ATOM   1474  CD1 PHE A  95      23.685  61.879  19.854  1.00  0.00           C  
ATOM   1475  CD2 PHE A  95      24.384  60.304  21.503  1.00  0.00           C  
ATOM   1476  CE1 PHE A  95      24.502  62.838  20.420  1.00  0.00           C  
ATOM   1477  CE2 PHE A  95      25.202  61.261  22.074  1.00  0.00           C  
ATOM   1478  CZ  PHE A  95      25.261  62.530  21.533  1.00  0.00           C  
ATOM   1479  H   PHE A  95      21.705  57.671  17.972  1.00  0.00           H  
ATOM   1480  HA  PHE A  95      23.937  59.594  18.004  1.00  0.00           H  
ATOM   1481  HB2 PHE A  95      21.809  60.043  19.474  1.00  0.00           H  
ATOM   1482  HB3 PHE A  95      22.514  58.817  20.522  1.00  0.00           H  
ATOM   1483  HD1 PHE A  95      23.091  62.123  18.986  1.00  0.00           H  
ATOM   1484  HD2 PHE A  95      24.339  59.311  21.928  1.00  0.00           H  
ATOM   1485  HE1 PHE A  95      24.546  63.831  19.995  1.00  0.00           H  
ATOM   1486  HE2 PHE A  95      25.795  61.015  22.944  1.00  0.00           H  
ATOM   1487  HZ  PHE A  95      25.901  63.278  21.976  1.00  0.00           H  
ATOM   1488  N   MET A  96      25.509  57.773  18.558  1.00  0.00           N  
ATOM   1489  CA  MET A  96      26.479  56.745  18.916  1.00  0.00           C  
ATOM   1490  C   MET A  96      27.554  57.311  19.839  1.00  0.00           C  
ATOM   1491  O   MET A  96      28.280  58.235  19.472  1.00  0.00           O  
ATOM   1492  CB  MET A  96      27.126  56.163  17.657  1.00  0.00           C  
ATOM   1493  CG  MET A  96      26.139  55.472  16.731  1.00  0.00           C  
ATOM   1494  SD  MET A  96      26.812  55.191  15.083  1.00  0.00           S  
ATOM   1495  CE  MET A  96      26.093  56.564  14.185  1.00  0.00           C  
ATOM   1496  H   MET A  96      25.788  58.510  17.975  1.00  0.00           H  
ATOM   1497  HA  MET A  96      25.952  55.959  19.435  1.00  0.00           H  
ATOM   1498  HB2 MET A  96      27.603  56.962  17.109  1.00  0.00           H  
ATOM   1499  HB3 MET A  96      27.875  55.442  17.952  1.00  0.00           H  
ATOM   1500  HG2 MET A  96      25.869  54.518  17.161  1.00  0.00           H  
ATOM   1501  HG3 MET A  96      25.255  56.087  16.646  1.00  0.00           H  
ATOM   1502  HE1 MET A  96      25.358  57.054  14.806  1.00  0.00           H  
ATOM   1503  HE2 MET A  96      26.868  57.267  13.921  1.00  0.00           H  
ATOM   1504  HE3 MET A  96      25.617  56.196  13.287  1.00  0.00           H  
ATOM   1505  N   VAL A  97      27.652  56.749  21.040  1.00  0.00           N  
ATOM   1506  CA  VAL A  97      28.639  57.196  22.015  1.00  0.00           C  
ATOM   1507  C   VAL A  97      29.787  56.198  22.133  1.00  0.00           C  
ATOM   1508  O   VAL A  97      29.566  55.010  22.362  1.00  0.00           O  
ATOM   1509  CB  VAL A  97      28.004  57.397  23.404  1.00  0.00           C  
ATOM   1510  CG1 VAL A  97      29.068  57.755  24.431  1.00  0.00           C  
ATOM   1511  CG2 VAL A  97      26.925  58.468  23.346  1.00  0.00           C  
ATOM   1512  H   VAL A  97      27.046  56.015  21.275  1.00  0.00           H  
ATOM   1513  HA  VAL A  97      29.032  58.145  21.681  1.00  0.00           H  
ATOM   1514  HB  VAL A  97      27.543  56.468  23.705  1.00  0.00           H  
ATOM   1515 HG11 VAL A  97      29.917  57.098  24.315  1.00  0.00           H  
ATOM   1516 HG12 VAL A  97      29.381  58.779  24.284  1.00  0.00           H  
ATOM   1517 HG13 VAL A  97      28.661  57.643  25.425  1.00  0.00           H  
ATOM   1518 HG21 VAL A  97      26.665  58.771  24.349  1.00  0.00           H  
ATOM   1519 HG22 VAL A  97      27.295  59.323  22.798  1.00  0.00           H  
ATOM   1520 HG23 VAL A  97      26.052  58.074  22.850  1.00  0.00           H  
ATOM   1521  N   GLN A  98      31.011  56.693  21.975  1.00  0.00           N  
ATOM   1522  CA  GLN A  98      32.192  55.843  22.064  1.00  0.00           C  
ATOM   1523  C   GLN A  98      32.837  55.950  23.442  1.00  0.00           C  
ATOM   1524  O   GLN A  98      32.913  57.033  24.023  1.00  0.00           O  
ATOM   1525  CB  GLN A  98      33.205  56.230  20.984  1.00  0.00           C  
ATOM   1526  CG  GLN A  98      34.077  55.071  20.526  1.00  0.00           C  
ATOM   1527  CD  GLN A  98      34.678  55.300  19.153  1.00  0.00           C  
ATOM   1528  OE1 GLN A  98      35.248  56.357  18.881  1.00  0.00           O  
ATOM   1529  NE2 GLN A  98      34.554  54.309  18.280  1.00  0.00           N  
ATOM   1530  H   GLN A  98      31.120  57.649  21.795  1.00  0.00           H  
ATOM   1531  HA  GLN A  98      31.881  54.823  21.903  1.00  0.00           H  
ATOM   1532  HB2 GLN A  98      32.671  56.610  20.127  1.00  0.00           H  
ATOM   1533  HB3 GLN A  98      33.849  57.005  21.371  1.00  0.00           H  
ATOM   1534  HG2 GLN A  98      34.881  54.940  21.236  1.00  0.00           H  
ATOM   1535  HG3 GLN A  98      33.476  54.175  20.495  1.00  0.00           H  
ATOM   1536 HE21 GLN A  98      34.085  53.495  18.566  1.00  0.00           H  
ATOM   1537 HE22 GLN A  98      34.932  54.429  17.384  1.00  0.00           H  
ATOM   1538  N   THR A  99      33.299  54.817  23.962  1.00  0.00           N  
ATOM   1539  CA  THR A  99      33.935  54.782  25.273  1.00  0.00           C  
ATOM   1540  C   THR A  99      35.106  53.806  25.290  1.00  0.00           C  
ATOM   1541  O   THR A  99      35.026  52.716  24.722  1.00  0.00           O  
ATOM   1542  CB  THR A  99      32.934  54.384  26.373  1.00  0.00           C  
ATOM   1543  OG1 THR A  99      32.315  53.134  26.044  1.00  0.00           O  
ATOM   1544  CG2 THR A  99      31.866  55.453  26.547  1.00  0.00           C  
ATOM   1545  H   THR A  99      33.209  53.985  23.452  1.00  0.00           H  
ATOM   1546  HA  THR A  99      34.303  55.774  25.493  1.00  0.00           H  
ATOM   1547  HB  THR A  99      33.469  54.276  27.306  1.00  0.00           H  
ATOM   1548  HG1 THR A  99      32.948  52.574  25.588  1.00  0.00           H  
ATOM   1549 HG21 THR A  99      31.128  55.114  27.258  1.00  0.00           H  
ATOM   1550 HG22 THR A  99      31.390  55.644  25.597  1.00  0.00           H  
ATOM   1551 HG23 THR A  99      32.323  56.361  26.909  1.00  0.00           H  
ATOM   1552  N   ILE A 100      36.192  54.203  25.946  1.00  0.00           N  
ATOM   1553  CA  ILE A 100      37.378  53.361  26.037  1.00  0.00           C  
ATOM   1554  C   ILE A 100      38.229  53.739  27.245  1.00  0.00           C  
ATOM   1555  O   ILE A 100      38.440  54.921  27.523  1.00  0.00           O  
ATOM   1556  CB  ILE A 100      38.239  53.461  24.765  1.00  0.00           C  
ATOM   1557  CG1 ILE A 100      39.601  52.799  24.991  1.00  0.00           C  
ATOM   1558  CG2 ILE A 100      38.413  54.916  24.356  1.00  0.00           C  
ATOM   1559  CD1 ILE A 100      40.551  52.961  23.825  1.00  0.00           C  
ATOM   1560  H   ILE A 100      36.194  55.081  26.378  1.00  0.00           H  
ATOM   1561  HA  ILE A 100      37.052  52.336  26.148  1.00  0.00           H  
ATOM   1562  HB  ILE A 100      37.725  52.947  23.968  1.00  0.00           H  
ATOM   1563 HG12 ILE A 100      40.066  53.235  25.861  1.00  0.00           H  
ATOM   1564 HG13 ILE A 100      39.455  51.741  25.157  1.00  0.00           H  
ATOM   1565 HG21 ILE A 100      39.368  55.277  24.709  1.00  0.00           H  
ATOM   1566 HG22 ILE A 100      38.375  54.994  23.280  1.00  0.00           H  
ATOM   1567 HG23 ILE A 100      37.622  55.508  24.789  1.00  0.00           H  
ATOM   1568 HD11 ILE A 100      41.568  52.991  24.190  1.00  0.00           H  
ATOM   1569 HD12 ILE A 100      40.436  52.128  23.148  1.00  0.00           H  
ATOM   1570 HD13 ILE A 100      40.330  53.881  23.304  1.00  0.00           H  
ATOM   1571  N   PHE A 101      38.717  52.730  27.959  1.00  0.00           N  
ATOM   1572  CA  PHE A 101      39.546  52.957  29.137  1.00  0.00           C  
ATOM   1573  C   PHE A 101      40.708  53.891  28.811  1.00  0.00           C  
ATOM   1574  O   PHE A 101      41.117  54.012  27.657  1.00  0.00           O  
ATOM   1575  CB  PHE A 101      40.080  51.628  29.674  1.00  0.00           C  
ATOM   1576  CG  PHE A 101      39.009  50.598  29.896  1.00  0.00           C  
ATOM   1577  CD1 PHE A 101      38.580  49.791  28.855  1.00  0.00           C  
ATOM   1578  CD2 PHE A 101      38.433  50.438  31.145  1.00  0.00           C  
ATOM   1579  CE1 PHE A 101      37.595  48.842  29.056  1.00  0.00           C  
ATOM   1580  CE2 PHE A 101      37.448  49.489  31.353  1.00  0.00           C  
ATOM   1581  CZ  PHE A 101      37.028  48.692  30.306  1.00  0.00           C  
ATOM   1582  H   PHE A 101      38.514  51.811  27.687  1.00  0.00           H  
ATOM   1583  HA  PHE A 101      38.928  53.419  29.891  1.00  0.00           H  
ATOM   1584  HB2 PHE A 101      40.789  51.221  28.969  1.00  0.00           H  
ATOM   1585  HB3 PHE A 101      40.575  51.803  30.618  1.00  0.00           H  
ATOM   1586  HD1 PHE A 101      39.023  49.908  27.876  1.00  0.00           H  
ATOM   1587  HD2 PHE A 101      38.759  51.061  31.964  1.00  0.00           H  
ATOM   1588  HE1 PHE A 101      37.270  48.219  28.236  1.00  0.00           H  
ATOM   1589  HE2 PHE A 101      37.006  49.374  32.331  1.00  0.00           H  
ATOM   1590  HZ  PHE A 101      36.259  47.950  30.466  1.00  0.00           H  
ATOM   1591  N   ALA A 102      41.235  54.550  29.838  1.00  0.00           N  
ATOM   1592  CA  ALA A 102      42.351  55.471  29.664  1.00  0.00           C  
ATOM   1593  C   ALA A 102      43.643  54.881  30.218  1.00  0.00           C  
ATOM   1594  O   ALA A 102      43.655  54.217  31.255  1.00  0.00           O  
ATOM   1595  CB  ALA A 102      42.045  56.802  30.335  1.00  0.00           C  
ATOM   1596  H   ALA A 102      40.866  54.411  30.735  1.00  0.00           H  
ATOM   1597  HA  ALA A 102      42.474  55.650  28.605  1.00  0.00           H  
ATOM   1598  HB1 ALA A 102      42.756  57.544  29.999  1.00  0.00           H  
ATOM   1599  HB2 ALA A 102      41.047  57.116  30.074  1.00  0.00           H  
ATOM   1600  HB3 ALA A 102      42.121  56.690  31.406  1.00  0.00           H  
ATOM   1601  N   PRO A 103      44.757  55.126  29.513  1.00  0.00           N  
ATOM   1602  CA  PRO A 103      46.075  54.627  29.916  1.00  0.00           C  
ATOM   1603  C   PRO A 103      46.599  55.320  31.169  1.00  0.00           C  
ATOM   1604  O   PRO A 103      46.062  56.333  31.617  1.00  0.00           O  
ATOM   1605  CB  PRO A 103      46.963  54.956  28.712  1.00  0.00           C  
ATOM   1606  CG  PRO A 103      46.291  56.109  28.051  1.00  0.00           C  
ATOM   1607  CD  PRO A 103      44.815  55.910  28.267  1.00  0.00           C  
ATOM   1608  HA  PRO A 103      46.063  53.559  30.076  1.00  0.00           H  
ATOM   1609  HB2 PRO A 103      47.954  55.218  29.054  1.00  0.00           H  
ATOM   1610  HB3 PRO A 103      47.016  54.101  28.056  1.00  0.00           H  
ATOM   1611  HG2 PRO A 103      46.614  57.033  28.505  1.00  0.00           H  
ATOM   1612  HG3 PRO A 103      46.517  56.109  26.995  1.00  0.00           H  
ATOM   1613  HD2 PRO A 103      44.320  56.861  28.387  1.00  0.00           H  
ATOM   1614  HD3 PRO A 103      44.385  55.357  27.445  1.00  0.00           H  
ATOM   1615  N   PRO A 104      47.672  54.764  31.750  1.00  0.00           N  
ATOM   1616  CA  PRO A 104      48.292  55.313  32.959  1.00  0.00           C  
ATOM   1617  C   PRO A 104      48.999  56.638  32.697  1.00  0.00           C  
ATOM   1618  O   PRO A 104      49.176  57.449  33.605  1.00  0.00           O  
ATOM   1619  CB  PRO A 104      49.306  54.237  33.357  1.00  0.00           C  
ATOM   1620  CG  PRO A 104      49.626  53.527  32.087  1.00  0.00           C  
ATOM   1621  CD  PRO A 104      48.364  53.555  31.269  1.00  0.00           C  
ATOM   1622  HA  PRO A 104      47.571  55.442  33.751  1.00  0.00           H  
ATOM   1623  HB2 PRO A 104      50.184  54.705  33.782  1.00  0.00           H  
ATOM   1624  HB3 PRO A 104      48.861  53.570  34.081  1.00  0.00           H  
ATOM   1625  HG2 PRO A 104      50.420  54.042  31.570  1.00  0.00           H  
ATOM   1626  HG3 PRO A 104      49.912  52.508  32.299  1.00  0.00           H  
ATOM   1627  HD2 PRO A 104      48.599  53.638  30.218  1.00  0.00           H  
ATOM   1628  HD3 PRO A 104      47.772  52.673  31.458  1.00  0.00           H  
ATOM   1629  N   ASN A 105      49.401  56.853  31.448  1.00  0.00           N  
ATOM   1630  CA  ASN A 105      50.089  58.081  31.067  1.00  0.00           C  
ATOM   1631  C   ASN A 105      49.230  58.915  30.121  1.00  0.00           C  
ATOM   1632  O   ASN A 105      49.744  59.729  29.353  1.00  0.00           O  
ATOM   1633  CB  ASN A 105      51.428  57.755  30.404  1.00  0.00           C  
ATOM   1634  CG  ASN A 105      51.327  56.592  29.436  1.00  0.00           C  
ATOM   1635  OD1 ASN A 105      51.695  55.464  29.764  1.00  0.00           O  
ATOM   1636  ND2 ASN A 105      50.825  56.862  28.237  1.00  0.00           N  
ATOM   1637  H   ASN A 105      49.231  56.169  30.767  1.00  0.00           H  
ATOM   1638  HA  ASN A 105      50.271  58.652  31.966  1.00  0.00           H  
ATOM   1639  HB2 ASN A 105      51.774  58.623  29.859  1.00  0.00           H  
ATOM   1640  HB3 ASN A 105      52.150  57.504  31.166  1.00  0.00           H  
ATOM   1641 HD21 ASN A 105      50.552  57.784  28.045  1.00  0.00           H  
ATOM   1642 HD22 ASN A 105      50.748  56.128  27.592  1.00  0.00           H  
ATOM   1643  N   ILE A 106      47.919  58.707  30.183  1.00  0.00           N  
ATOM   1644  CA  ILE A 106      46.989  59.439  29.333  1.00  0.00           C  
ATOM   1645  C   ILE A 106      47.290  60.934  29.349  1.00  0.00           C  
ATOM   1646  O   ILE A 106      46.867  61.654  30.254  1.00  0.00           O  
ATOM   1647  CB  ILE A 106      45.529  59.217  29.773  1.00  0.00           C  
ATOM   1648  CG1 ILE A 106      44.589  60.124  28.976  1.00  0.00           C  
ATOM   1649  CG2 ILE A 106      45.382  59.472  31.265  1.00  0.00           C  
ATOM   1650  CD1 ILE A 106      44.496  59.758  27.511  1.00  0.00           C  
ATOM   1651  H   ILE A 106      47.569  58.045  30.816  1.00  0.00           H  
ATOM   1652  HA  ILE A 106      47.099  59.072  28.324  1.00  0.00           H  
ATOM   1653  HB  ILE A 106      45.273  58.186  29.582  1.00  0.00           H  
ATOM   1654 HG12 ILE A 106      43.598  60.063  29.396  1.00  0.00           H  
ATOM   1655 HG13 ILE A 106      44.942  61.142  29.042  1.00  0.00           H  
ATOM   1656 HG21 ILE A 106      46.237  60.026  31.623  1.00  0.00           H  
ATOM   1657 HG22 ILE A 106      44.483  60.045  31.445  1.00  0.00           H  
ATOM   1658 HG23 ILE A 106      45.318  58.530  31.788  1.00  0.00           H  
ATOM   1659 HD11 ILE A 106      45.397  59.246  27.209  1.00  0.00           H  
ATOM   1660 HD12 ILE A 106      43.645  59.112  27.355  1.00  0.00           H  
ATOM   1661 HD13 ILE A 106      44.379  60.657  26.923  1.00  0.00           H  
ATOM   1662  N   SER A 107      48.024  61.395  28.342  1.00  0.00           N  
ATOM   1663  CA  SER A 107      48.384  62.805  28.241  1.00  0.00           C  
ATOM   1664  C   SER A 107      47.677  63.463  27.059  1.00  0.00           C  
ATOM   1665  O   SER A 107      46.948  64.441  27.225  1.00  0.00           O  
ATOM   1666  CB  SER A 107      49.899  62.956  28.092  1.00  0.00           C  
ATOM   1667  OG  SER A 107      50.569  62.573  29.281  1.00  0.00           O  
ATOM   1668  H   SER A 107      48.332  60.772  27.651  1.00  0.00           H  
ATOM   1669  HA  SER A 107      48.069  63.294  29.151  1.00  0.00           H  
ATOM   1670  HB2 SER A 107      50.243  62.332  27.283  1.00  0.00           H  
ATOM   1671  HB3 SER A 107      50.135  63.988  27.877  1.00  0.00           H  
ATOM   1672  HG  SER A 107      50.011  62.764  30.039  1.00  0.00           H  
ATOM   1673  N   ASP A 108      47.900  62.919  25.868  1.00  0.00           N  
ATOM   1674  CA  ASP A 108      47.284  63.451  24.658  1.00  0.00           C  
ATOM   1675  C   ASP A 108      46.104  62.589  24.224  1.00  0.00           C  
ATOM   1676  O   ASP A 108      46.273  61.424  23.864  1.00  0.00           O  
ATOM   1677  CB  ASP A 108      48.314  63.534  23.531  1.00  0.00           C  
ATOM   1678  CG  ASP A 108      47.975  64.606  22.513  1.00  0.00           C  
ATOM   1679  OD1 ASP A 108      47.289  65.581  22.885  1.00  0.00           O  
ATOM   1680  OD2 ASP A 108      48.395  64.468  21.345  1.00  0.00           O  
ATOM   1681  H   ASP A 108      48.492  62.141  25.801  1.00  0.00           H  
ATOM   1682  HA  ASP A 108      46.926  64.445  24.878  1.00  0.00           H  
ATOM   1683  HB2 ASP A 108      49.283  63.759  23.952  1.00  0.00           H  
ATOM   1684  HB3 ASP A 108      48.360  62.582  23.023  1.00  0.00           H  
ATOM   1685  N   MET A 109      44.908  63.168  24.259  1.00  0.00           N  
ATOM   1686  CA  MET A 109      43.700  62.452  23.869  1.00  0.00           C  
ATOM   1687  C   MET A 109      43.697  62.166  22.371  1.00  0.00           C  
ATOM   1688  O   MET A 109      43.469  61.033  21.947  1.00  0.00           O  
ATOM   1689  CB  MET A 109      42.458  63.259  24.249  1.00  0.00           C  
ATOM   1690  CG  MET A 109      42.443  63.705  25.701  1.00  0.00           C  
ATOM   1691  SD  MET A 109      42.127  62.344  26.842  1.00  0.00           S  
ATOM   1692  CE  MET A 109      40.451  61.904  26.389  1.00  0.00           C  
ATOM   1693  H   MET A 109      44.836  64.100  24.555  1.00  0.00           H  
ATOM   1694  HA  MET A 109      43.685  61.512  24.403  1.00  0.00           H  
ATOM   1695  HB2 MET A 109      42.410  64.139  23.624  1.00  0.00           H  
ATOM   1696  HB3 MET A 109      41.581  62.654  24.072  1.00  0.00           H  
ATOM   1697  HG2 MET A 109      43.401  64.140  25.942  1.00  0.00           H  
ATOM   1698  HG3 MET A 109      41.670  64.448  25.828  1.00  0.00           H  
ATOM   1699  HE1 MET A 109      39.979  61.387  27.212  1.00  0.00           H  
ATOM   1700  HE2 MET A 109      39.893  62.800  26.160  1.00  0.00           H  
ATOM   1701  HE3 MET A 109      40.471  61.260  25.522  1.00  0.00           H  
ATOM   1702  N   GLU A 110      43.952  63.200  21.576  1.00  0.00           N  
ATOM   1703  CA  GLU A 110      43.977  63.058  20.125  1.00  0.00           C  
ATOM   1704  C   GLU A 110      44.843  61.873  19.708  1.00  0.00           C  
ATOM   1705  O   GLU A 110      44.606  61.250  18.675  1.00  0.00           O  
ATOM   1706  CB  GLU A 110      44.501  64.340  19.474  1.00  0.00           C  
ATOM   1707  CG  GLU A 110      45.933  64.675  19.856  1.00  0.00           C  
ATOM   1708  CD  GLU A 110      46.407  65.981  19.250  1.00  0.00           C  
ATOM   1709  OE1 GLU A 110      45.974  67.049  19.732  1.00  0.00           O  
ATOM   1710  OE2 GLU A 110      47.212  65.937  18.296  1.00  0.00           O  
ATOM   1711  H   GLU A 110      44.126  64.078  21.974  1.00  0.00           H  
ATOM   1712  HA  GLU A 110      42.965  62.884  19.791  1.00  0.00           H  
ATOM   1713  HB2 GLU A 110      44.452  64.231  18.401  1.00  0.00           H  
ATOM   1714  HB3 GLU A 110      43.870  65.164  19.771  1.00  0.00           H  
ATOM   1715  HG2 GLU A 110      45.998  64.749  20.930  1.00  0.00           H  
ATOM   1716  HG3 GLU A 110      46.579  63.880  19.511  1.00  0.00           H  
ATOM   1717  N   ALA A 111      45.849  61.569  20.522  1.00  0.00           N  
ATOM   1718  CA  ALA A 111      46.751  60.458  20.240  1.00  0.00           C  
ATOM   1719  C   ALA A 111      46.115  59.125  20.622  1.00  0.00           C  
ATOM   1720  O   ALA A 111      46.313  58.115  19.947  1.00  0.00           O  
ATOM   1721  CB  ALA A 111      48.068  60.647  20.976  1.00  0.00           C  
ATOM   1722  H   ALA A 111      45.987  62.103  21.331  1.00  0.00           H  
ATOM   1723  HA  ALA A 111      46.955  60.456  19.179  1.00  0.00           H  
ATOM   1724  HB1 ALA A 111      48.882  60.326  20.343  1.00  0.00           H  
ATOM   1725  HB2 ALA A 111      48.194  61.690  21.224  1.00  0.00           H  
ATOM   1726  HB3 ALA A 111      48.062  60.060  21.882  1.00  0.00           H  
ATOM   1727  N   VAL A 112      45.352  59.130  21.710  1.00  0.00           N  
ATOM   1728  CA  VAL A 112      44.688  57.920  22.183  1.00  0.00           C  
ATOM   1729  C   VAL A 112      43.615  57.464  21.202  1.00  0.00           C  
ATOM   1730  O   VAL A 112      43.683  56.360  20.661  1.00  0.00           O  
ATOM   1731  CB  VAL A 112      44.044  58.138  23.566  1.00  0.00           C  
ATOM   1732  CG1 VAL A 112      43.406  56.851  24.067  1.00  0.00           C  
ATOM   1733  CG2 VAL A 112      45.075  58.653  24.559  1.00  0.00           C  
ATOM   1734  H   VAL A 112      45.232  59.966  22.207  1.00  0.00           H  
ATOM   1735  HA  VAL A 112      45.433  57.144  22.275  1.00  0.00           H  
ATOM   1736  HB  VAL A 112      43.268  58.883  23.466  1.00  0.00           H  
ATOM   1737 HG11 VAL A 112      43.709  56.029  23.433  1.00  0.00           H  
ATOM   1738 HG12 VAL A 112      43.724  56.661  25.081  1.00  0.00           H  
ATOM   1739 HG13 VAL A 112      42.331  56.948  24.038  1.00  0.00           H  
ATOM   1740 HG21 VAL A 112      45.045  59.731  24.581  1.00  0.00           H  
ATOM   1741 HG22 VAL A 112      44.853  58.265  25.542  1.00  0.00           H  
ATOM   1742 HG23 VAL A 112      46.059  58.325  24.258  1.00  0.00           H  
ATOM   1743  N   TRP A 113      42.625  58.319  20.975  1.00  0.00           N  
ATOM   1744  CA  TRP A 113      41.537  58.004  20.057  1.00  0.00           C  
ATOM   1745  C   TRP A 113      42.078  57.587  18.694  1.00  0.00           C  
ATOM   1746  O   TRP A 113      41.466  56.783  17.991  1.00  0.00           O  
ATOM   1747  CB  TRP A 113      40.605  59.207  19.904  1.00  0.00           C  
ATOM   1748  CG  TRP A 113      39.856  59.542  21.158  1.00  0.00           C  
ATOM   1749  CD1 TRP A 113      39.967  60.683  21.899  1.00  0.00           C  
ATOM   1750  CD2 TRP A 113      38.881  58.727  21.816  1.00  0.00           C  
ATOM   1751  NE1 TRP A 113      39.121  60.626  22.980  1.00  0.00           N  
ATOM   1752  CE2 TRP A 113      38.442  59.436  22.951  1.00  0.00           C  
ATOM   1753  CE3 TRP A 113      38.333  57.467  21.556  1.00  0.00           C  
ATOM   1754  CZ2 TRP A 113      37.483  58.926  23.823  1.00  0.00           C  
ATOM   1755  CZ3 TRP A 113      37.383  56.962  22.423  1.00  0.00           C  
ATOM   1756  CH2 TRP A 113      36.965  57.691  23.544  1.00  0.00           C  
ATOM   1757  H   TRP A 113      42.625  59.185  21.436  1.00  0.00           H  
ATOM   1758  HA  TRP A 113      40.979  57.180  20.477  1.00  0.00           H  
ATOM   1759  HB2 TRP A 113      41.188  60.072  19.623  1.00  0.00           H  
ATOM   1760  HB3 TRP A 113      39.883  58.998  19.128  1.00  0.00           H  
ATOM   1761  HD1 TRP A 113      40.630  61.501  21.661  1.00  0.00           H  
ATOM   1762  HE1 TRP A 113      39.018  61.325  23.659  1.00  0.00           H  
ATOM   1763  HE3 TRP A 113      38.642  56.890  20.698  1.00  0.00           H  
ATOM   1764  HZ2 TRP A 113      37.151  59.476  24.691  1.00  0.00           H  
ATOM   1765  HZ3 TRP A 113      36.950  55.990  22.239  1.00  0.00           H  
ATOM   1766  HH2 TRP A 113      36.220  57.258  24.195  1.00  0.00           H  
ATOM   1767  N   LYS A 114      43.230  58.137  18.326  1.00  0.00           N  
ATOM   1768  CA  LYS A 114      43.855  57.822  17.047  1.00  0.00           C  
ATOM   1769  C   LYS A 114      44.446  56.416  17.062  1.00  0.00           C  
ATOM   1770  O   LYS A 114      44.117  55.586  16.215  1.00  0.00           O  
ATOM   1771  CB  LYS A 114      44.949  58.843  16.725  1.00  0.00           C  
ATOM   1772  CG  LYS A 114      44.439  60.070  15.990  1.00  0.00           C  
ATOM   1773  CD  LYS A 114      45.579  60.980  15.566  1.00  0.00           C  
ATOM   1774  CE  LYS A 114      46.296  60.441  14.336  1.00  0.00           C  
ATOM   1775  NZ  LYS A 114      45.624  60.862  13.076  1.00  0.00           N  
ATOM   1776  H   LYS A 114      43.671  58.772  18.930  1.00  0.00           H  
ATOM   1777  HA  LYS A 114      43.094  57.871  16.284  1.00  0.00           H  
ATOM   1778  HB2 LYS A 114      45.406  59.166  17.650  1.00  0.00           H  
ATOM   1779  HB3 LYS A 114      45.699  58.367  16.111  1.00  0.00           H  
ATOM   1780  HG2 LYS A 114      43.900  59.753  15.110  1.00  0.00           H  
ATOM   1781  HG3 LYS A 114      43.775  60.620  16.642  1.00  0.00           H  
ATOM   1782  HD2 LYS A 114      45.183  61.958  15.337  1.00  0.00           H  
ATOM   1783  HD3 LYS A 114      46.288  61.058  16.379  1.00  0.00           H  
ATOM   1784  HE2 LYS A 114      47.309  60.810  14.337  1.00  0.00           H  
ATOM   1785  HE3 LYS A 114      46.305  59.362  14.386  1.00  0.00           H  
ATOM   1786  HZ1 LYS A 114      44.636  60.541  13.073  1.00  0.00           H  
ATOM   1787  HZ2 LYS A 114      46.114  60.449  12.256  1.00  0.00           H  
ATOM   1788  HZ3 LYS A 114      45.642  61.898  12.991  1.00  0.00           H  
ATOM   1789  N   GLU A 115      45.317  56.156  18.032  1.00  0.00           N  
ATOM   1790  CA  GLU A 115      45.952  54.849  18.157  1.00  0.00           C  
ATOM   1791  C   GLU A 115      44.909  53.754  18.357  1.00  0.00           C  
ATOM   1792  O   GLU A 115      45.050  52.645  17.842  1.00  0.00           O  
ATOM   1793  CB  GLU A 115      46.941  54.846  19.324  1.00  0.00           C  
ATOM   1794  CG  GLU A 115      48.168  55.709  19.085  1.00  0.00           C  
ATOM   1795  CD  GLU A 115      49.268  55.453  20.096  1.00  0.00           C  
ATOM   1796  OE1 GLU A 115      48.964  55.423  21.308  1.00  0.00           O  
ATOM   1797  OE2 GLU A 115      50.432  55.281  19.678  1.00  0.00           O  
ATOM   1798  H   GLU A 115      45.539  56.858  18.678  1.00  0.00           H  
ATOM   1799  HA  GLU A 115      46.490  54.652  17.242  1.00  0.00           H  
ATOM   1800  HB2 GLU A 115      46.437  55.210  20.208  1.00  0.00           H  
ATOM   1801  HB3 GLU A 115      47.268  53.833  19.501  1.00  0.00           H  
ATOM   1802  HG2 GLU A 115      48.553  55.499  18.098  1.00  0.00           H  
ATOM   1803  HG3 GLU A 115      47.880  56.748  19.144  1.00  0.00           H  
ATOM   1804  N   ALA A 116      43.861  54.074  19.109  1.00  0.00           N  
ATOM   1805  CA  ALA A 116      42.792  53.119  19.378  1.00  0.00           C  
ATOM   1806  C   ALA A 116      42.254  52.520  18.083  1.00  0.00           C  
ATOM   1807  O   ALA A 116      41.936  53.241  17.138  1.00  0.00           O  
ATOM   1808  CB  ALA A 116      41.671  53.787  20.158  1.00  0.00           C  
ATOM   1809  H   ALA A 116      43.804  54.974  19.492  1.00  0.00           H  
ATOM   1810  HA  ALA A 116      43.199  52.326  19.988  1.00  0.00           H  
ATOM   1811  HB1 ALA A 116      41.046  54.350  19.480  1.00  0.00           H  
ATOM   1812  HB2 ALA A 116      41.077  53.033  20.653  1.00  0.00           H  
ATOM   1813  HB3 ALA A 116      42.093  54.454  20.895  1.00  0.00           H  
ATOM   1814  N   LYS A 117      42.155  51.195  18.045  1.00  0.00           N  
ATOM   1815  CA  LYS A 117      41.655  50.497  16.867  1.00  0.00           C  
ATOM   1816  C   LYS A 117      40.141  50.329  16.937  1.00  0.00           C  
ATOM   1817  O   LYS A 117      39.546  50.284  18.013  1.00  0.00           O  
ATOM   1818  CB  LYS A 117      42.326  49.129  16.736  1.00  0.00           C  
ATOM   1819  CG  LYS A 117      43.719  49.188  16.134  1.00  0.00           C  
ATOM   1820  CD  LYS A 117      43.672  49.524  14.652  1.00  0.00           C  
ATOM   1821  CE  LYS A 117      45.069  49.698  14.076  1.00  0.00           C  
ATOM   1822  NZ  LYS A 117      45.032  50.238  12.689  1.00  0.00           N  
ATOM   1823  H   LYS A 117      42.425  50.674  18.831  1.00  0.00           H  
ATOM   1824  HA  LYS A 117      41.900  51.093  16.000  1.00  0.00           H  
ATOM   1825  HB2 LYS A 117      42.399  48.681  17.717  1.00  0.00           H  
ATOM   1826  HB3 LYS A 117      41.712  48.499  16.108  1.00  0.00           H  
ATOM   1827  HG2 LYS A 117      44.290  49.948  16.646  1.00  0.00           H  
ATOM   1828  HG3 LYS A 117      44.198  48.228  16.260  1.00  0.00           H  
ATOM   1829  HD2 LYS A 117      43.175  48.724  14.127  1.00  0.00           H  
ATOM   1830  HD3 LYS A 117      43.119  50.445  14.518  1.00  0.00           H  
ATOM   1831  HE2 LYS A 117      45.621  50.380  14.704  1.00  0.00           H  
ATOM   1832  HE3 LYS A 117      45.562  48.737  14.067  1.00  0.00           H  
ATOM   1833  HZ1 LYS A 117      45.927  50.724  12.472  1.00  0.00           H  
ATOM   1834  HZ2 LYS A 117      44.252  50.917  12.589  1.00  0.00           H  
ATOM   1835  HZ3 LYS A 117      44.896  49.465  12.008  1.00  0.00           H  
ATOM   1836  N   PRO A 118      39.501  50.231  15.762  1.00  0.00           N  
ATOM   1837  CA  PRO A 118      38.048  50.064  15.663  1.00  0.00           C  
ATOM   1838  C   PRO A 118      37.589  48.689  16.140  1.00  0.00           C  
ATOM   1839  O   PRO A 118      36.392  48.405  16.184  1.00  0.00           O  
ATOM   1840  CB  PRO A 118      37.772  50.231  14.167  1.00  0.00           C  
ATOM   1841  CG  PRO A 118      39.050  49.852  13.501  1.00  0.00           C  
ATOM   1842  CD  PRO A 118      40.146  50.276  14.439  1.00  0.00           C  
ATOM   1843  HA  PRO A 118      37.522  50.828  16.216  1.00  0.00           H  
ATOM   1844  HB2 PRO A 118      36.963  49.577  13.872  1.00  0.00           H  
ATOM   1845  HB3 PRO A 118      37.507  51.257  13.958  1.00  0.00           H  
ATOM   1846  HG2 PRO A 118      39.081  48.784  13.346  1.00  0.00           H  
ATOM   1847  HG3 PRO A 118      39.141  50.372  12.559  1.00  0.00           H  
ATOM   1848  HD2 PRO A 118      40.973  49.583  14.390  1.00  0.00           H  
ATOM   1849  HD3 PRO A 118      40.476  51.277  14.205  1.00  0.00           H  
ATOM   1850  N   ASP A 119      38.548  47.841  16.494  1.00  0.00           N  
ATOM   1851  CA  ASP A 119      38.242  46.496  16.968  1.00  0.00           C  
ATOM   1852  C   ASP A 119      38.260  46.441  18.492  1.00  0.00           C  
ATOM   1853  O   ASP A 119      37.834  45.454  19.092  1.00  0.00           O  
ATOM   1854  CB  ASP A 119      39.243  45.490  16.397  1.00  0.00           C  
ATOM   1855  CG  ASP A 119      38.948  45.135  14.954  1.00  0.00           C  
ATOM   1856  OD1 ASP A 119      37.890  44.523  14.699  1.00  0.00           O  
ATOM   1857  OD2 ASP A 119      39.774  45.469  14.079  1.00  0.00           O  
ATOM   1858  H   ASP A 119      39.484  48.126  16.435  1.00  0.00           H  
ATOM   1859  HA  ASP A 119      37.252  46.240  16.622  1.00  0.00           H  
ATOM   1860  HB2 ASP A 119      40.237  45.914  16.448  1.00  0.00           H  
ATOM   1861  HB3 ASP A 119      39.210  44.586  16.986  1.00  0.00           H  
ATOM   1862  N   GLU A 120      38.756  47.507  19.113  1.00  0.00           N  
ATOM   1863  CA  GLU A 120      38.830  47.577  20.567  1.00  0.00           C  
ATOM   1864  C   GLU A 120      37.920  48.677  21.107  1.00  0.00           C  
ATOM   1865  O   GLU A 120      37.454  48.611  22.245  1.00  0.00           O  
ATOM   1866  CB  GLU A 120      40.272  47.829  21.015  1.00  0.00           C  
ATOM   1867  CG  GLU A 120      41.253  46.774  20.530  1.00  0.00           C  
ATOM   1868  CD  GLU A 120      42.472  46.657  21.423  1.00  0.00           C  
ATOM   1869  OE1 GLU A 120      42.329  46.845  22.650  1.00  0.00           O  
ATOM   1870  OE2 GLU A 120      43.569  46.377  20.896  1.00  0.00           O  
ATOM   1871  H   GLU A 120      39.080  48.262  18.581  1.00  0.00           H  
ATOM   1872  HA  GLU A 120      38.501  46.628  20.963  1.00  0.00           H  
ATOM   1873  HB2 GLU A 120      40.591  48.789  20.638  1.00  0.00           H  
ATOM   1874  HB3 GLU A 120      40.303  47.849  22.094  1.00  0.00           H  
ATOM   1875  HG2 GLU A 120      40.750  45.818  20.504  1.00  0.00           H  
ATOM   1876  HG3 GLU A 120      41.578  47.035  19.533  1.00  0.00           H  
ATOM   1877  N   LEU A 121      37.671  49.687  20.281  1.00  0.00           N  
ATOM   1878  CA  LEU A 121      36.816  50.803  20.673  1.00  0.00           C  
ATOM   1879  C   LEU A 121      35.383  50.335  20.908  1.00  0.00           C  
ATOM   1880  O   LEU A 121      34.772  49.718  20.037  1.00  0.00           O  
ATOM   1881  CB  LEU A 121      36.840  51.892  19.598  1.00  0.00           C  
ATOM   1882  CG  LEU A 121      38.009  52.875  19.664  1.00  0.00           C  
ATOM   1883  CD1 LEU A 121      37.944  53.860  18.508  1.00  0.00           C  
ATOM   1884  CD2 LEU A 121      38.011  53.611  20.996  1.00  0.00           C  
ATOM   1885  H   LEU A 121      38.069  49.684  19.386  1.00  0.00           H  
ATOM   1886  HA  LEU A 121      37.205  51.210  21.595  1.00  0.00           H  
ATOM   1887  HB2 LEU A 121      36.871  51.405  18.636  1.00  0.00           H  
ATOM   1888  HB3 LEU A 121      35.923  52.458  19.683  1.00  0.00           H  
ATOM   1889  HG  LEU A 121      38.937  52.326  19.584  1.00  0.00           H  
ATOM   1890 HD11 LEU A 121      38.859  54.429  18.468  1.00  0.00           H  
ATOM   1891 HD12 LEU A 121      37.109  54.530  18.652  1.00  0.00           H  
ATOM   1892 HD13 LEU A 121      37.815  53.319  17.582  1.00  0.00           H  
ATOM   1893 HD21 LEU A 121      38.322  52.937  21.780  1.00  0.00           H  
ATOM   1894 HD22 LEU A 121      37.016  53.975  21.208  1.00  0.00           H  
ATOM   1895 HD23 LEU A 121      38.696  54.445  20.945  1.00  0.00           H  
ATOM   1896  N   MET A 122      34.855  50.635  22.090  1.00  0.00           N  
ATOM   1897  CA  MET A 122      33.492  50.248  22.438  1.00  0.00           C  
ATOM   1898  C   MET A 122      32.514  51.379  22.141  1.00  0.00           C  
ATOM   1899  O   MET A 122      32.762  52.534  22.486  1.00  0.00           O  
ATOM   1900  CB  MET A 122      33.411  49.862  23.916  1.00  0.00           C  
ATOM   1901  CG  MET A 122      34.413  48.794  24.321  1.00  0.00           C  
ATOM   1902  SD  MET A 122      36.027  49.479  24.743  1.00  0.00           S  
ATOM   1903  CE  MET A 122      35.706  50.115  26.386  1.00  0.00           C  
ATOM   1904  H   MET A 122      35.393  51.129  22.744  1.00  0.00           H  
ATOM   1905  HA  MET A 122      33.228  49.391  21.837  1.00  0.00           H  
ATOM   1906  HB2 MET A 122      33.592  50.742  24.515  1.00  0.00           H  
ATOM   1907  HB3 MET A 122      32.419  49.491  24.125  1.00  0.00           H  
ATOM   1908  HG2 MET A 122      34.028  48.264  25.180  1.00  0.00           H  
ATOM   1909  HG3 MET A 122      34.533  48.103  23.500  1.00  0.00           H  
ATOM   1910  HE1 MET A 122      35.253  51.092  26.312  1.00  0.00           H  
ATOM   1911  HE2 MET A 122      35.036  49.446  26.905  1.00  0.00           H  
ATOM   1912  HE3 MET A 122      36.637  50.189  26.931  1.00  0.00           H  
ATOM   1913  N   ASP A 123      31.401  51.039  21.499  1.00  0.00           N  
ATOM   1914  CA  ASP A 123      30.384  52.027  21.156  1.00  0.00           C  
ATOM   1915  C   ASP A 123      29.010  51.585  21.650  1.00  0.00           C  
ATOM   1916  O   ASP A 123      28.827  50.441  22.067  1.00  0.00           O  
ATOM   1917  CB  ASP A 123      30.349  52.250  19.643  1.00  0.00           C  
ATOM   1918  CG  ASP A 123      31.725  52.509  19.064  1.00  0.00           C  
ATOM   1919  OD1 ASP A 123      32.548  51.570  19.046  1.00  0.00           O  
ATOM   1920  OD2 ASP A 123      31.981  53.652  18.629  1.00  0.00           O  
ATOM   1921  H   ASP A 123      31.260  50.102  21.250  1.00  0.00           H  
ATOM   1922  HA  ASP A 123      30.646  52.955  21.642  1.00  0.00           H  
ATOM   1923  HB2 ASP A 123      29.938  51.373  19.166  1.00  0.00           H  
ATOM   1924  HB3 ASP A 123      29.720  53.101  19.427  1.00  0.00           H  
ATOM   1925  N   SER A 124      28.047  52.499  21.600  1.00  0.00           N  
ATOM   1926  CA  SER A 124      26.690  52.207  22.046  1.00  0.00           C  
ATOM   1927  C   SER A 124      25.662  52.835  21.111  1.00  0.00           C  
ATOM   1928  O   SER A 124      25.791  53.995  20.717  1.00  0.00           O  
ATOM   1929  CB  SER A 124      26.477  52.717  23.473  1.00  0.00           C  
ATOM   1930  OG  SER A 124      25.321  52.142  24.054  1.00  0.00           O  
ATOM   1931  H   SER A 124      28.255  53.394  21.257  1.00  0.00           H  
ATOM   1932  HA  SER A 124      26.562  51.134  22.035  1.00  0.00           H  
ATOM   1933  HB2 SER A 124      27.335  52.460  24.076  1.00  0.00           H  
ATOM   1934  HB3 SER A 124      26.361  53.791  23.453  1.00  0.00           H  
ATOM   1935  HG  SER A 124      24.648  52.025  23.379  1.00  0.00           H  
ATOM   1936  N   LYS A 125      24.641  52.061  20.758  1.00  0.00           N  
ATOM   1937  CA  LYS A 125      23.589  52.540  19.870  1.00  0.00           C  
ATOM   1938  C   LYS A 125      22.459  53.189  20.664  1.00  0.00           C  
ATOM   1939  O   LYS A 125      21.732  52.513  21.393  1.00  0.00           O  
ATOM   1940  CB  LYS A 125      23.038  51.387  19.029  1.00  0.00           C  
ATOM   1941  CG  LYS A 125      23.783  51.177  17.722  1.00  0.00           C  
ATOM   1942  CD  LYS A 125      23.276  49.951  16.981  1.00  0.00           C  
ATOM   1943  CE  LYS A 125      24.015  48.693  17.414  1.00  0.00           C  
ATOM   1944  NZ  LYS A 125      25.477  48.791  17.148  1.00  0.00           N  
ATOM   1945  H   LYS A 125      24.593  51.145  21.105  1.00  0.00           H  
ATOM   1946  HA  LYS A 125      24.020  53.280  19.212  1.00  0.00           H  
ATOM   1947  HB2 LYS A 125      23.101  50.475  19.605  1.00  0.00           H  
ATOM   1948  HB3 LYS A 125      22.001  51.587  18.800  1.00  0.00           H  
ATOM   1949  HG2 LYS A 125      23.643  52.046  17.096  1.00  0.00           H  
ATOM   1950  HG3 LYS A 125      24.835  51.049  17.934  1.00  0.00           H  
ATOM   1951  HD2 LYS A 125      22.224  49.825  17.190  1.00  0.00           H  
ATOM   1952  HD3 LYS A 125      23.421  50.096  15.920  1.00  0.00           H  
ATOM   1953  HE2 LYS A 125      23.859  48.546  18.472  1.00  0.00           H  
ATOM   1954  HE3 LYS A 125      23.614  47.851  16.870  1.00  0.00           H  
ATOM   1955  HZ1 LYS A 125      25.654  49.448  16.362  1.00  0.00           H  
ATOM   1956  HZ2 LYS A 125      25.858  47.857  16.897  1.00  0.00           H  
ATOM   1957  HZ3 LYS A 125      25.972  49.139  17.995  1.00  0.00           H  
ATOM   1958  N   LEU A 126      22.317  54.502  20.518  1.00  0.00           N  
ATOM   1959  CA  LEU A 126      21.274  55.241  21.220  1.00  0.00           C  
ATOM   1960  C   LEU A 126      20.458  56.087  20.249  1.00  0.00           C  
ATOM   1961  O   LEU A 126      20.970  56.543  19.226  1.00  0.00           O  
ATOM   1962  CB  LEU A 126      21.892  56.133  22.297  1.00  0.00           C  
ATOM   1963  CG  LEU A 126      20.943  56.617  23.396  1.00  0.00           C  
ATOM   1964  CD1 LEU A 126      21.728  57.157  24.581  1.00  0.00           C  
ATOM   1965  CD2 LEU A 126      19.996  57.677  22.853  1.00  0.00           C  
ATOM   1966  H   LEU A 126      22.926  54.985  19.923  1.00  0.00           H  
ATOM   1967  HA  LEU A 126      20.619  54.524  21.691  1.00  0.00           H  
ATOM   1968  HB2 LEU A 126      22.688  55.578  22.771  1.00  0.00           H  
ATOM   1969  HB3 LEU A 126      22.304  57.004  21.808  1.00  0.00           H  
ATOM   1970  HG  LEU A 126      20.349  55.782  23.742  1.00  0.00           H  
ATOM   1971 HD11 LEU A 126      21.171  56.986  25.489  1.00  0.00           H  
ATOM   1972 HD12 LEU A 126      21.891  58.217  24.451  1.00  0.00           H  
ATOM   1973 HD13 LEU A 126      22.681  56.651  24.641  1.00  0.00           H  
ATOM   1974 HD21 LEU A 126      20.265  57.911  21.833  1.00  0.00           H  
ATOM   1975 HD22 LEU A 126      20.069  58.569  23.458  1.00  0.00           H  
ATOM   1976 HD23 LEU A 126      18.983  57.303  22.882  1.00  0.00           H  
ATOM   1977  N   ARG A 127      19.188  56.297  20.577  1.00  0.00           N  
ATOM   1978  CA  ARG A 127      18.301  57.089  19.734  1.00  0.00           C  
ATOM   1979  C   ARG A 127      17.772  58.304  20.493  1.00  0.00           C  
ATOM   1980  O   ARG A 127      17.391  58.202  21.660  1.00  0.00           O  
ATOM   1981  CB  ARG A 127      17.132  56.235  19.240  1.00  0.00           C  
ATOM   1982  CG  ARG A 127      16.541  55.333  20.312  1.00  0.00           C  
ATOM   1983  CD  ARG A 127      17.275  54.004  20.389  1.00  0.00           C  
ATOM   1984  NE  ARG A 127      17.102  53.212  19.174  1.00  0.00           N  
ATOM   1985  CZ  ARG A 127      15.957  52.635  18.830  1.00  0.00           C  
ATOM   1986  NH1 ARG A 127      14.888  52.760  19.605  1.00  0.00           N  
ATOM   1987  NH2 ARG A 127      15.878  51.930  17.709  1.00  0.00           N  
ATOM   1988  H   ARG A 127      18.837  55.907  21.406  1.00  0.00           H  
ATOM   1989  HA  ARG A 127      18.870  57.432  18.883  1.00  0.00           H  
ATOM   1990  HB2 ARG A 127      16.351  56.888  18.880  1.00  0.00           H  
ATOM   1991  HB3 ARG A 127      17.475  55.613  18.427  1.00  0.00           H  
ATOM   1992  HG2 ARG A 127      16.616  55.830  21.269  1.00  0.00           H  
ATOM   1993  HG3 ARG A 127      15.502  55.149  20.081  1.00  0.00           H  
ATOM   1994  HD2 ARG A 127      18.327  54.197  20.535  1.00  0.00           H  
ATOM   1995  HD3 ARG A 127      16.892  53.445  21.230  1.00  0.00           H  
ATOM   1996  HE  ARG A 127      17.879  53.107  18.587  1.00  0.00           H  
ATOM   1997 HH11 ARG A 127      14.944  53.291  20.450  1.00  0.00           H  
ATOM   1998 HH12 ARG A 127      14.027  52.325  19.344  1.00  0.00           H  
ATOM   1999 HH21 ARG A 127      16.681  51.833  17.121  1.00  0.00           H  
ATOM   2000 HH22 ARG A 127      15.015  51.495  17.450  1.00  0.00           H  
ATOM   2001  N   CYS A 128      17.752  59.450  19.823  1.00  0.00           N  
ATOM   2002  CA  CYS A 128      17.272  60.685  20.434  1.00  0.00           C  
ATOM   2003  C   CYS A 128      15.794  60.905  20.126  1.00  0.00           C  
ATOM   2004  O   CYS A 128      15.401  61.018  18.965  1.00  0.00           O  
ATOM   2005  CB  CYS A 128      18.091  61.877  19.937  1.00  0.00           C  
ATOM   2006  SG  CYS A 128      19.818  61.860  20.471  1.00  0.00           S  
ATOM   2007  H   CYS A 128      18.069  59.469  18.895  1.00  0.00           H  
ATOM   2008  HA  CYS A 128      17.395  60.595  21.502  1.00  0.00           H  
ATOM   2009  HB2 CYS A 128      18.083  61.885  18.857  1.00  0.00           H  
ATOM   2010  HB3 CYS A 128      17.642  62.789  20.300  1.00  0.00           H  
ATOM   2011  HG  CYS A 128      20.254  63.110  20.484  1.00  0.00           H  
ATOM   2012  N   VAL A 129      14.979  60.960  21.175  1.00  0.00           N  
ATOM   2013  CA  VAL A 129      13.544  61.165  21.016  1.00  0.00           C  
ATOM   2014  C   VAL A 129      13.163  62.616  21.287  1.00  0.00           C  
ATOM   2015  O   VAL A 129      13.440  63.153  22.360  1.00  0.00           O  
ATOM   2016  CB  VAL A 129      12.739  60.251  21.960  1.00  0.00           C  
ATOM   2017  CG1 VAL A 129      11.257  60.309  21.624  1.00  0.00           C  
ATOM   2018  CG2 VAL A 129      13.255  58.822  21.884  1.00  0.00           C  
ATOM   2019  H   VAL A 129      15.351  60.862  22.076  1.00  0.00           H  
ATOM   2020  HA  VAL A 129      13.281  60.917  19.999  1.00  0.00           H  
ATOM   2021  HB  VAL A 129      12.871  60.606  22.972  1.00  0.00           H  
ATOM   2022 HG11 VAL A 129      10.923  61.335  21.650  1.00  0.00           H  
ATOM   2023 HG12 VAL A 129      11.095  59.901  20.636  1.00  0.00           H  
ATOM   2024 HG13 VAL A 129      10.701  59.731  22.348  1.00  0.00           H  
ATOM   2025 HG21 VAL A 129      13.066  58.423  20.899  1.00  0.00           H  
ATOM   2026 HG22 VAL A 129      14.319  58.811  22.078  1.00  0.00           H  
ATOM   2027 HG23 VAL A 129      12.750  58.216  22.621  1.00  0.00           H  
ATOM   2028  N   PHE A 130      12.525  63.246  20.307  1.00  0.00           N  
ATOM   2029  CA  PHE A 130      12.106  64.637  20.438  1.00  0.00           C  
ATOM   2030  C   PHE A 130      10.703  64.729  21.030  1.00  0.00           C  
ATOM   2031  O   PHE A 130       9.728  64.305  20.411  1.00  0.00           O  
ATOM   2032  CB  PHE A 130      12.142  65.334  19.077  1.00  0.00           C  
ATOM   2033  CG  PHE A 130      13.339  64.967  18.247  1.00  0.00           C  
ATOM   2034  CD1 PHE A 130      13.332  63.823  17.464  1.00  0.00           C  
ATOM   2035  CD2 PHE A 130      14.472  65.765  18.249  1.00  0.00           C  
ATOM   2036  CE1 PHE A 130      14.433  63.482  16.702  1.00  0.00           C  
ATOM   2037  CE2 PHE A 130      15.576  65.429  17.488  1.00  0.00           C  
ATOM   2038  CZ  PHE A 130      15.556  64.287  16.712  1.00  0.00           C  
ATOM   2039  H   PHE A 130      12.331  62.765  19.474  1.00  0.00           H  
ATOM   2040  HA  PHE A 130      12.797  65.130  21.104  1.00  0.00           H  
ATOM   2041  HB2 PHE A 130      11.258  65.065  18.519  1.00  0.00           H  
ATOM   2042  HB3 PHE A 130      12.157  66.403  19.228  1.00  0.00           H  
ATOM   2043  HD1 PHE A 130      12.455  63.193  17.455  1.00  0.00           H  
ATOM   2044  HD2 PHE A 130      14.489  66.659  18.857  1.00  0.00           H  
ATOM   2045  HE1 PHE A 130      14.414  62.589  16.095  1.00  0.00           H  
ATOM   2046  HE2 PHE A 130      16.452  66.061  17.499  1.00  0.00           H  
ATOM   2047  HZ  PHE A 130      16.417  64.022  16.117  1.00  0.00           H  
ATOM   2048  N   GLU A 131      10.610  65.284  22.235  1.00  0.00           N  
ATOM   2049  CA  GLU A 131       9.327  65.429  22.912  1.00  0.00           C  
ATOM   2050  C   GLU A 131       8.858  66.882  22.884  1.00  0.00           C  
ATOM   2051  O   GLU A 131       9.624  67.784  22.550  1.00  0.00           O  
ATOM   2052  CB  GLU A 131       9.431  64.942  24.359  1.00  0.00           C  
ATOM   2053  CG  GLU A 131       9.239  63.442  24.512  1.00  0.00           C  
ATOM   2054  CD  GLU A 131       7.924  62.960  23.933  1.00  0.00           C  
ATOM   2055  OE1 GLU A 131       6.866  63.279  24.515  1.00  0.00           O  
ATOM   2056  OE2 GLU A 131       7.953  62.264  22.896  1.00  0.00           O  
ATOM   2057  H   GLU A 131      11.424  65.602  22.679  1.00  0.00           H  
ATOM   2058  HA  GLU A 131       8.605  64.821  22.389  1.00  0.00           H  
ATOM   2059  HB2 GLU A 131      10.406  65.202  24.745  1.00  0.00           H  
ATOM   2060  HB3 GLU A 131       8.675  65.442  24.948  1.00  0.00           H  
ATOM   2061  HG2 GLU A 131      10.046  62.937  24.004  1.00  0.00           H  
ATOM   2062  HG3 GLU A 131       9.265  63.195  25.562  1.00  0.00           H  
ATOM   2063  N   MET A 132       7.596  67.097  23.239  1.00  0.00           N  
ATOM   2064  CA  MET A 132       7.025  68.438  23.256  1.00  0.00           C  
ATOM   2065  C   MET A 132       6.816  68.923  24.687  1.00  0.00           C  
ATOM   2066  O   MET A 132       6.529  68.143  25.596  1.00  0.00           O  
ATOM   2067  CB  MET A 132       5.697  68.461  22.499  1.00  0.00           C  
ATOM   2068  CG  MET A 132       5.855  68.656  21.000  1.00  0.00           C  
ATOM   2069  SD  MET A 132       5.983  70.394  20.536  1.00  0.00           S  
ATOM   2070  CE  MET A 132       7.523  70.387  19.621  1.00  0.00           C  
ATOM   2071  H   MET A 132       7.034  66.335  23.496  1.00  0.00           H  
ATOM   2072  HA  MET A 132       7.721  69.100  22.762  1.00  0.00           H  
ATOM   2073  HB2 MET A 132       5.185  67.525  22.666  1.00  0.00           H  
ATOM   2074  HB3 MET A 132       5.090  69.267  22.883  1.00  0.00           H  
ATOM   2075  HG2 MET A 132       6.749  68.145  20.675  1.00  0.00           H  
ATOM   2076  HG3 MET A 132       4.997  68.226  20.502  1.00  0.00           H  
ATOM   2077  HE1 MET A 132       8.333  70.119  20.283  1.00  0.00           H  
ATOM   2078  HE2 MET A 132       7.461  69.668  18.818  1.00  0.00           H  
ATOM   2079  HE3 MET A 132       7.702  71.372  19.212  1.00  0.00           H  
ATOM   2080  N   PRO A 133       6.963  70.240  24.895  1.00  0.00           N  
ATOM   2081  CA  PRO A 133       6.794  70.856  26.214  1.00  0.00           C  
ATOM   2082  C   PRO A 133       5.341  70.845  26.678  1.00  0.00           C  
ATOM   2083  O   PRO A 133       5.061  70.915  27.874  1.00  0.00           O  
ATOM   2084  CB  PRO A 133       7.276  72.293  25.999  1.00  0.00           C  
ATOM   2085  CG  PRO A 133       7.073  72.546  24.544  1.00  0.00           C  
ATOM   2086  CD  PRO A 133       7.304  71.228  23.858  1.00  0.00           C  
ATOM   2087  HA  PRO A 133       7.411  70.376  26.959  1.00  0.00           H  
ATOM   2088  HB2 PRO A 133       6.687  72.968  26.603  1.00  0.00           H  
ATOM   2089  HB3 PRO A 133       8.318  72.372  26.271  1.00  0.00           H  
ATOM   2090  HG2 PRO A 133       6.065  72.889  24.368  1.00  0.00           H  
ATOM   2091  HG3 PRO A 133       7.786  73.279  24.196  1.00  0.00           H  
ATOM   2092  HD2 PRO A 133       6.653  71.129  23.002  1.00  0.00           H  
ATOM   2093  HD3 PRO A 133       8.338  71.133  23.562  1.00  0.00           H  
ATOM   2094  N   ASN A 134       4.422  70.758  25.723  1.00  0.00           N  
ATOM   2095  CA  ASN A 134       2.997  70.737  26.034  1.00  0.00           C  
ATOM   2096  C   ASN A 134       2.680  69.660  27.066  1.00  0.00           C  
ATOM   2097  O   ASN A 134       2.342  68.529  26.714  1.00  0.00           O  
ATOM   2098  CB  ASN A 134       2.178  70.498  24.763  1.00  0.00           C  
ATOM   2099  CG  ASN A 134       1.924  71.778  23.991  1.00  0.00           C  
ATOM   2100  OD1 ASN A 134       2.723  72.173  23.142  1.00  0.00           O  
ATOM   2101  ND2 ASN A 134       0.805  72.432  24.282  1.00  0.00           N  
ATOM   2102  H   ASN A 134       4.706  70.705  24.787  1.00  0.00           H  
ATOM   2103  HA  ASN A 134       2.734  71.701  26.445  1.00  0.00           H  
ATOM   2104  HB2 ASN A 134       2.715  69.814  24.121  1.00  0.00           H  
ATOM   2105  HB3 ASN A 134       1.227  70.064  25.031  1.00  0.00           H  
ATOM   2106 HD21 ASN A 134       0.216  72.058  24.970  1.00  0.00           H  
ATOM   2107 HD22 ASN A 134       0.616  73.262  23.796  1.00  0.00           H  
ATOM   2108  N   GLU A 135       2.792  70.018  28.341  1.00  0.00           N  
ATOM   2109  CA  GLU A 135       2.517  69.080  29.425  1.00  0.00           C  
ATOM   2110  C   GLU A 135       1.015  68.893  29.615  1.00  0.00           C  
ATOM   2111  O   GLU A 135       0.211  69.638  29.058  1.00  0.00           O  
ATOM   2112  CB  GLU A 135       3.151  69.572  30.727  1.00  0.00           C  
ATOM   2113  CG  GLU A 135       2.465  70.796  31.313  1.00  0.00           C  
ATOM   2114  CD  GLU A 135       2.820  72.072  30.576  1.00  0.00           C  
ATOM   2115  OE1 GLU A 135       2.180  72.356  29.542  1.00  0.00           O  
ATOM   2116  OE2 GLU A 135       3.737  72.786  31.031  1.00  0.00           O  
ATOM   2117  H   GLU A 135       3.066  70.933  28.559  1.00  0.00           H  
ATOM   2118  HA  GLU A 135       2.955  68.129  29.159  1.00  0.00           H  
ATOM   2119  HB2 GLU A 135       3.108  68.777  31.458  1.00  0.00           H  
ATOM   2120  HB3 GLU A 135       4.185  69.821  30.540  1.00  0.00           H  
ATOM   2121  HG2 GLU A 135       1.397  70.654  31.260  1.00  0.00           H  
ATOM   2122  HG3 GLU A 135       2.764  70.899  32.346  1.00  0.00           H  
ATOM   2123  N   ASN A 136       0.645  67.891  30.406  1.00  0.00           N  
ATOM   2124  CA  ASN A 136      -0.760  67.605  30.670  1.00  0.00           C  
ATOM   2125  C   ASN A 136      -1.104  67.870  32.133  1.00  0.00           C  
ATOM   2126  O   ASN A 136      -2.129  68.480  32.439  1.00  0.00           O  
ATOM   2127  CB  ASN A 136      -1.081  66.152  30.314  1.00  0.00           C  
ATOM   2128  CG  ASN A 136      -2.524  65.968  29.884  1.00  0.00           C  
ATOM   2129  OD1 ASN A 136      -3.123  66.858  29.281  1.00  0.00           O  
ATOM   2130  ND2 ASN A 136      -3.089  64.806  30.194  1.00  0.00           N  
ATOM   2131  H   ASN A 136       1.333  67.331  30.822  1.00  0.00           H  
ATOM   2132  HA  ASN A 136      -1.354  68.258  30.049  1.00  0.00           H  
ATOM   2133  HB2 ASN A 136      -0.442  65.837  29.503  1.00  0.00           H  
ATOM   2134  HB3 ASN A 136      -0.898  65.527  31.175  1.00  0.00           H  
ATOM   2135 HD21 ASN A 136      -2.553  64.143  30.677  1.00  0.00           H  
ATOM   2136 HD22 ASN A 136      -4.022  64.660  29.928  1.00  0.00           H  
ATOM   2137  N   ASP A 137      -0.241  67.407  33.031  1.00  0.00           N  
ATOM   2138  CA  ASP A 137      -0.452  67.596  34.461  1.00  0.00           C  
ATOM   2139  C   ASP A 137       0.876  67.797  35.185  1.00  0.00           C  
ATOM   2140  O   ASP A 137       1.729  66.910  35.198  1.00  0.00           O  
ATOM   2141  CB  ASP A 137      -1.192  66.394  35.052  1.00  0.00           C  
ATOM   2142  CG  ASP A 137      -2.363  65.957  34.195  1.00  0.00           C  
ATOM   2143  OD1 ASP A 137      -2.129  65.285  33.168  1.00  0.00           O  
ATOM   2144  OD2 ASP A 137      -3.514  66.284  34.552  1.00  0.00           O  
ATOM   2145  H   ASP A 137       0.557  66.928  32.724  1.00  0.00           H  
ATOM   2146  HA  ASP A 137      -1.058  68.479  34.594  1.00  0.00           H  
ATOM   2147  HB2 ASP A 137      -0.505  65.565  35.140  1.00  0.00           H  
ATOM   2148  HB3 ASP A 137      -1.563  66.654  36.032  1.00  0.00           H  
ATOM   2149  N   LYS A 138       1.045  68.971  35.785  1.00  0.00           N  
ATOM   2150  CA  LYS A 138       2.267  69.291  36.511  1.00  0.00           C  
ATOM   2151  C   LYS A 138       2.766  68.083  37.297  1.00  0.00           C  
ATOM   2152  O   LYS A 138       1.973  67.329  37.864  1.00  0.00           O  
ATOM   2153  CB  LYS A 138       2.029  70.467  37.460  1.00  0.00           C  
ATOM   2154  CG  LYS A 138       3.267  71.312  37.704  1.00  0.00           C  
ATOM   2155  CD  LYS A 138       3.016  72.379  38.757  1.00  0.00           C  
ATOM   2156  CE  LYS A 138       2.288  73.580  38.171  1.00  0.00           C  
ATOM   2157  NZ  LYS A 138       2.049  74.636  39.193  1.00  0.00           N  
ATOM   2158  H   LYS A 138       0.327  69.638  35.739  1.00  0.00           H  
ATOM   2159  HA  LYS A 138       3.019  69.570  35.787  1.00  0.00           H  
ATOM   2160  HB2 LYS A 138       1.261  71.102  37.042  1.00  0.00           H  
ATOM   2161  HB3 LYS A 138       1.687  70.083  38.411  1.00  0.00           H  
ATOM   2162  HG2 LYS A 138       4.069  70.673  38.041  1.00  0.00           H  
ATOM   2163  HG3 LYS A 138       3.551  71.793  36.779  1.00  0.00           H  
ATOM   2164  HD2 LYS A 138       2.411  71.958  39.547  1.00  0.00           H  
ATOM   2165  HD3 LYS A 138       3.963  72.705  39.160  1.00  0.00           H  
ATOM   2166  HE2 LYS A 138       2.886  73.993  37.373  1.00  0.00           H  
ATOM   2167  HE3 LYS A 138       1.338  73.252  37.777  1.00  0.00           H  
ATOM   2168  HZ1 LYS A 138       2.613  74.441  40.047  1.00  0.00           H  
ATOM   2169  HZ2 LYS A 138       1.043  74.660  39.455  1.00  0.00           H  
ATOM   2170  HZ3 LYS A 138       2.321  75.566  38.816  1.00  0.00           H  
ATOM   2171  N   LEU A 139       4.081  67.905  37.328  1.00  0.00           N  
ATOM   2172  CA  LEU A 139       4.686  66.788  38.046  1.00  0.00           C  
ATOM   2173  C   LEU A 139       5.691  67.285  39.081  1.00  0.00           C  
ATOM   2174  O   LEU A 139       6.554  68.107  38.776  1.00  0.00           O  
ATOM   2175  CB  LEU A 139       5.374  65.837  37.065  1.00  0.00           C  
ATOM   2176  CG  LEU A 139       6.026  64.596  37.679  1.00  0.00           C  
ATOM   2177  CD1 LEU A 139       6.025  63.446  36.683  1.00  0.00           C  
ATOM   2178  CD2 LEU A 139       7.443  64.909  38.134  1.00  0.00           C  
ATOM   2179  H   LEU A 139       4.662  68.538  36.857  1.00  0.00           H  
ATOM   2180  HA  LEU A 139       3.897  66.257  38.557  1.00  0.00           H  
ATOM   2181  HB2 LEU A 139       4.634  65.504  36.354  1.00  0.00           H  
ATOM   2182  HB3 LEU A 139       6.142  66.395  36.549  1.00  0.00           H  
ATOM   2183  HG  LEU A 139       5.455  64.289  38.544  1.00  0.00           H  
ATOM   2184 HD11 LEU A 139       5.237  63.596  35.960  1.00  0.00           H  
ATOM   2185 HD12 LEU A 139       5.860  62.517  37.208  1.00  0.00           H  
ATOM   2186 HD13 LEU A 139       6.978  63.409  36.175  1.00  0.00           H  
ATOM   2187 HD21 LEU A 139       8.147  64.388  37.503  1.00  0.00           H  
ATOM   2188 HD22 LEU A 139       7.571  64.588  39.158  1.00  0.00           H  
ATOM   2189 HD23 LEU A 139       7.617  65.973  38.066  1.00  0.00           H  
ATOM   2190  N   ASN A 140       5.574  66.779  40.304  1.00  0.00           N  
ATOM   2191  CA  ASN A 140       6.474  67.171  41.382  1.00  0.00           C  
ATOM   2192  C   ASN A 140       7.159  65.951  41.990  1.00  0.00           C  
ATOM   2193  O   ASN A 140       8.340  65.995  42.332  1.00  0.00           O  
ATOM   2194  CB  ASN A 140       5.705  67.930  42.465  1.00  0.00           C  
ATOM   2195  CG  ASN A 140       6.626  68.656  43.427  1.00  0.00           C  
ATOM   2196  OD1 ASN A 140       6.658  68.355  44.620  1.00  0.00           O  
ATOM   2197  ND2 ASN A 140       7.381  69.618  42.911  1.00  0.00           N  
ATOM   2198  H   ASN A 140       4.866  66.126  40.486  1.00  0.00           H  
ATOM   2199  HA  ASN A 140       7.227  67.821  40.965  1.00  0.00           H  
ATOM   2200  HB2 ASN A 140       5.059  68.660  41.996  1.00  0.00           H  
ATOM   2201  HB3 ASN A 140       5.104  67.233  43.028  1.00  0.00           H  
ATOM   2202 HD21 ASN A 140       7.302  69.804  41.951  1.00  0.00           H  
ATOM   2203 HD22 ASN A 140       7.986  70.104  43.510  1.00  0.00           H  
ATOM   2204  N   ASP A 141       6.408  64.862  42.121  1.00  0.00           N  
ATOM   2205  CA  ASP A 141       6.942  63.628  42.686  1.00  0.00           C  
ATOM   2206  C   ASP A 141       6.089  62.431  42.281  1.00  0.00           C  
ATOM   2207  O   ASP A 141       4.948  62.588  41.844  1.00  0.00           O  
ATOM   2208  CB  ASP A 141       7.012  63.728  44.211  1.00  0.00           C  
ATOM   2209  CG  ASP A 141       8.094  62.845  44.800  1.00  0.00           C  
ATOM   2210  OD1 ASP A 141       9.286  63.176  44.632  1.00  0.00           O  
ATOM   2211  OD2 ASP A 141       7.748  61.822  45.428  1.00  0.00           O  
ATOM   2212  H   ASP A 141       5.472  64.889  41.830  1.00  0.00           H  
ATOM   2213  HA  ASP A 141       7.940  63.491  42.297  1.00  0.00           H  
ATOM   2214  HB2 ASP A 141       7.218  64.752  44.488  1.00  0.00           H  
ATOM   2215  HB3 ASP A 141       6.061  63.431  44.628  1.00  0.00           H  
ATOM   2216  N   SER A 142       6.648  61.234  42.429  1.00  0.00           N  
ATOM   2217  CA  SER A 142       5.940  60.010  42.074  1.00  0.00           C  
ATOM   2218  C   SER A 142       5.237  59.416  43.291  1.00  0.00           C  
ATOM   2219  O   SER A 142       5.145  58.198  43.435  1.00  0.00           O  
ATOM   2220  CB  SER A 142       6.911  58.987  41.482  1.00  0.00           C  
ATOM   2221  OG  SER A 142       7.272  59.334  40.157  1.00  0.00           O  
ATOM   2222  H   SER A 142       7.560  61.174  42.782  1.00  0.00           H  
ATOM   2223  HA  SER A 142       5.197  60.260  41.330  1.00  0.00           H  
ATOM   2224  HB2 SER A 142       7.804  58.950  42.088  1.00  0.00           H  
ATOM   2225  HB3 SER A 142       6.442  58.014  41.472  1.00  0.00           H  
ATOM   2226  HG  SER A 142       7.012  58.630  39.558  1.00  0.00           H  
ATOM   2227  N   GLY A 143       4.743  60.288  44.165  1.00  0.00           N  
ATOM   2228  CA  GLY A 143       4.055  59.833  45.358  1.00  0.00           C  
ATOM   2229  C   GLY A 143       3.540  60.980  46.204  1.00  0.00           C  
ATOM   2230  O   GLY A 143       2.457  61.517  45.968  1.00  0.00           O  
ATOM   2231  H   GLY A 143       4.846  61.249  43.997  1.00  0.00           H  
ATOM   2232  HA2 GLY A 143       3.221  59.212  45.067  1.00  0.00           H  
ATOM   2233  HA3 GLY A 143       4.740  59.243  45.952  1.00  0.00           H  
ATOM   2234  N   PRO A 144       4.325  61.373  47.218  1.00  0.00           N  
ATOM   2235  CA  PRO A 144       3.962  62.468  48.123  1.00  0.00           C  
ATOM   2236  C   PRO A 144       4.005  63.827  47.435  1.00  0.00           C  
ATOM   2237  O   PRO A 144       4.608  63.977  46.372  1.00  0.00           O  
ATOM   2238  CB  PRO A 144       5.027  62.389  49.220  1.00  0.00           C  
ATOM   2239  CG  PRO A 144       6.196  61.740  48.566  1.00  0.00           C  
ATOM   2240  CD  PRO A 144       5.628  60.778  47.560  1.00  0.00           C  
ATOM   2241  HA  PRO A 144       2.984  62.315  48.557  1.00  0.00           H  
ATOM   2242  HB2 PRO A 144       5.266  63.385  49.564  1.00  0.00           H  
ATOM   2243  HB3 PRO A 144       4.657  61.797  50.044  1.00  0.00           H  
ATOM   2244  HG2 PRO A 144       6.802  62.486  48.072  1.00  0.00           H  
ATOM   2245  HG3 PRO A 144       6.781  61.209  49.303  1.00  0.00           H  
ATOM   2246  HD2 PRO A 144       6.266  60.722  46.690  1.00  0.00           H  
ATOM   2247  HD3 PRO A 144       5.502  59.801  48.001  1.00  0.00           H  
ATOM   2248  N   SER A 145       3.361  64.816  48.047  1.00  0.00           N  
ATOM   2249  CA  SER A 145       3.323  66.163  47.492  1.00  0.00           C  
ATOM   2250  C   SER A 145       4.477  67.005  48.028  1.00  0.00           C  
ATOM   2251  O   SER A 145       5.085  67.784  47.294  1.00  0.00           O  
ATOM   2252  CB  SER A 145       1.990  66.837  47.821  1.00  0.00           C  
ATOM   2253  OG  SER A 145       0.898  66.048  47.383  1.00  0.00           O  
ATOM   2254  H   SER A 145       2.898  64.634  48.893  1.00  0.00           H  
ATOM   2255  HA  SER A 145       3.420  66.083  46.419  1.00  0.00           H  
ATOM   2256  HB2 SER A 145       1.913  66.975  48.889  1.00  0.00           H  
ATOM   2257  HB3 SER A 145       1.944  67.798  47.330  1.00  0.00           H  
ATOM   2258  HG  SER A 145       1.153  65.555  46.599  1.00  0.00           H  
ATOM   2259  N   SER A 146       4.773  66.842  49.313  1.00  0.00           N  
ATOM   2260  CA  SER A 146       5.851  67.589  49.951  1.00  0.00           C  
ATOM   2261  C   SER A 146       7.106  67.577  49.083  1.00  0.00           C  
ATOM   2262  O   SER A 146       7.283  66.700  48.240  1.00  0.00           O  
ATOM   2263  CB  SER A 146       6.164  67.000  51.327  1.00  0.00           C  
ATOM   2264  OG  SER A 146       6.396  65.605  51.245  1.00  0.00           O  
ATOM   2265  H   SER A 146       4.251  66.206  49.847  1.00  0.00           H  
ATOM   2266  HA  SER A 146       5.521  68.609  50.072  1.00  0.00           H  
ATOM   2267  HB2 SER A 146       7.045  67.477  51.728  1.00  0.00           H  
ATOM   2268  HB3 SER A 146       5.327  67.175  51.989  1.00  0.00           H  
ATOM   2269  HG  SER A 146       7.330  65.444  51.092  1.00  0.00           H  
ATOM   2270  N   GLY A 147       7.976  68.560  49.299  1.00  0.00           N  
ATOM   2271  CA  GLY A 147       9.203  68.646  48.530  1.00  0.00           C  
ATOM   2272  C   GLY A 147       8.948  68.769  47.041  1.00  0.00           C  
ATOM   2273  O   GLY A 147       9.876  68.972  46.259  1.00  0.00           O  
ATOM   2274  H   GLY A 147       7.781  69.232  49.985  1.00  0.00           H  
ATOM   2275  HA2 GLY A 147       9.763  69.508  48.860  1.00  0.00           H  
ATOM   2276  HA3 GLY A 147       9.791  67.758  48.710  1.00  0.00           H  
TER    2277      GLY A 147                                                      
END
MOLECULE T0407_267_363.pdb
ATOM   3929  N   GLU   267      35.106  43.509  19.828  1.00 31.65           N  
ATOM   3930  CA  GLU   267      33.972  44.417  19.938  1.00 31.32           C  
ATOM   3932  CB  GLU   267      33.672  45.047  18.585  1.00 32.33           C  
ATOM   3935  CG  GLU   267      32.483  45.980  18.615  1.00 40.25           C  
ATOM   3938  CD  GLU   267      32.239  46.598  17.266  1.00 47.69           C  
ATOM   3939  OE1 GLU   267      33.043  46.322  16.365  1.00 52.85           O  
ATOM   3940  OE2 GLU   267      31.263  47.360  17.100  1.00 60.16           O  
ATOM   3941  C   GLU   267      32.712  43.771  20.485  1.00 29.94           C  
ATOM   3942  O   GLU   267      31.910  44.457  21.136  1.00 34.10           O  
ATOM   3944  N   ASP   268      32.551  42.463  20.232  1.00 29.24           N  
ATOM   3945  CA  ASP   268      31.314  41.755  20.634  1.00 27.90           C  
ATOM   3947  CB  ASP   268      31.042  40.462  19.875  1.00 28.44           C  
ATOM   3950  CG  ASP   268      32.071  39.384  20.101  1.00 31.91           C  
ATOM   3951  OD1 ASP   268      33.178  39.682  20.549  1.00 35.98           O  
ATOM   3952  OD2 ASP   268      31.764  38.211  19.788  1.00 41.42           O  
ATOM   3953  C   ASP   268      31.247  41.543  22.137  1.00 26.18           C  
ATOM   3954  O   ASP   268      30.226  41.162  22.668  1.00 28.17           O  
ATOM   3956  N   LEU   269      32.330  41.894  22.800  1.00 28.08           N  
ATOM   3957  CA  LEU   269      32.415  41.809  24.273  1.00 28.53           C  
ATOM   3959  CB  LEU   269      33.661  41.039  24.709  1.00 30.14           C  
ATOM   3962  CG  LEU   269      33.655  39.539  24.500  1.00 31.24           C  
ATOM   3964  CD1 LEU   269      34.975  38.967  24.901  1.00 28.75           C  
ATOM   3968  CD2 LEU   269      32.497  38.940  25.301  1.00 28.30           C  
ATOM   3972  C   LEU   269      32.471  43.201  24.869  1.00 30.39           C  
ATOM   3973  O   LEU   269      31.824  43.512  25.867  1.00 30.90           O  
ATOM   3975  N   LEU   270      33.258  44.043  24.220  1.00 32.16           N  
ATOM   3976  CA  LEU   270      33.473  45.407  24.706  1.00 31.69           C  
ATOM   3978  CB  LEU   270      34.680  46.083  24.017  1.00 32.01           C  
ATOM   3981  CG  LEU   270      36.001  46.144  24.828  1.00 35.55           C  
ATOM   3983  CD1 LEU   270      36.356  44.889  25.580  1.00 32.25           C  
ATOM   3987  CD2 LEU   270      37.164  46.598  23.914  1.00 38.91           C  
ATOM   3991  C   LEU   270      32.179  46.216  24.615  1.00 31.38           C  
ATOM   3992  O   LEU   270      31.882  47.040  25.487  1.00 30.61           O  
ATOM   3994  N   ARG   271      31.372  45.968  23.586  0.50 30.87           N  
ATOM   3996  CA  ARG   271      30.138  46.758  23.449  0.50 29.77           C  
ATOM   4000  CB  ARG   271      29.465  46.578  22.083  0.50 31.00           C  
ATOM   4006  CG  ARG   271      28.066  47.168  22.064  0.50 32.86           C  
ATOM   4012  CD  ARG   271      27.555  47.435  20.659  0.50 44.02           C  
ATOM   4018  NE  ARG   271      28.173  48.631  20.102  0.50 51.04           N  
ATOM   4022  CZ  ARG   271      29.245  48.609  19.318  0.50 57.68           C  
ATOM   4024  NH1 ARG   271      29.797  47.445  18.986  0.50 61.07           N  
ATOM   4030  NH2 ARG   271      29.753  49.743  18.855  0.50 59.35           N  
ATOM   4036  C   ARG   271      29.134  46.517  24.593  0.50 29.48           C  
ATOM   4038  O   ARG   271      28.626  47.473  25.164  0.50 28.90           O  
ATOM   4042  N   PRO   272      28.796  45.250  24.883  1.00 29.04           N  
ATOM   4043  CA  PRO   272      27.891  45.013  26.010  1.00 27.61           C  
ATOM   4045  CB  PRO   272      27.594  43.489  25.942  1.00 27.59           C  
ATOM   4048  CG  PRO   272      28.564  42.901  24.936  1.00 29.76           C  
ATOM   4051  CD  PRO   272      29.076  44.029  24.087  1.00 29.38           C  
ATOM   4054  C   PRO   272      28.499  45.362  27.370  1.00 29.14           C  
ATOM   4055  O   PRO   272      27.766  45.675  28.338  1.00 31.16           O  
ATOM   4056  N   PHE   273      29.821  45.321  27.436  1.00 28.81           N  
ATOM   4057  CA  PHE   273      30.555  45.624  28.672  1.00 30.80           C  
ATOM   4059  CB  PHE   273      32.038  45.199  28.589  1.00 35.77           C  
ATOM   4062  CG  PHE   273      32.741  45.218  29.957  1.00 36.54           C  
ATOM   4063  CD1 PHE   273      32.498  44.233  30.886  1.00 37.89           C  
ATOM   4065  CE1 PHE   273      33.109  44.280  32.135  1.00 32.79           C  
ATOM   4067  CZ  PHE   273      33.953  45.325  32.452  1.00 26.74           C  
ATOM   4069  CE2 PHE   273      34.192  46.288  31.567  1.00 32.48           C  
ATOM   4071  CD2 PHE   273      33.603  46.246  30.311  1.00 30.47           C  
ATOM   4073  C   PHE   273      30.437  47.120  28.985  1.00 30.91           C  
ATOM   4074  O   PHE   273      30.124  47.553  30.110  1.00 29.97           O  
ATOM   4076  N   PHE   274      30.639  47.924  27.959  1.00 32.20           N  
ATOM   4077  CA  PHE   274      30.464  49.395  28.108  1.00 32.17           C  
ATOM   4079  CB  PHE   274      30.742  50.130  26.807  1.00 32.97           C  
ATOM   4082  CG  PHE   274      30.585  51.605  26.923  1.00 35.23           C  
ATOM   4083  CD1 PHE   274      31.465  52.343  27.673  1.00 34.76           C  
ATOM   4085  CE1 PHE   274      31.327  53.700  27.783  1.00 43.25           C  
ATOM   4087  CZ  PHE   274      30.311  54.337  27.122  1.00 33.63           C  
ATOM   4089  CE2 PHE   274      29.430  53.609  26.372  1.00 31.49           C  
ATOM   4091  CD2 PHE   274      29.581  52.259  26.255  1.00 36.84           C  
ATOM   4093  C   PHE   274      29.060  49.751  28.557  1.00 29.92           C  
ATOM   4094  O   PHE   274      28.854  50.596  29.408  1.00 28.68           O  
ATOM   4096  N   GLU   275      28.117  49.028  27.985  1.00 32.00           N  
ATOM   4097  CA  GLU   275      26.682  49.233  28.229  1.00 34.89           C  
ATOM   4099  CB  GLU   275      25.850  48.316  27.320  1.00 36.17           C  
ATOM   4102  CG  GLU   275      24.362  48.538  27.400  1.00 43.51           C  
ATOM   4105  CD  GLU   275      23.715  48.066  28.726  1.00 56.32           C  
ATOM   4106  OE1 GLU   275      24.010  46.938  29.225  1.00 53.96           O  
ATOM   4107  OE2 GLU   275      22.852  48.814  29.243  1.00 55.98           O  
ATOM   4108  C   GLU   275      26.369  49.038  29.701  1.00 33.63           C  
ATOM   4109  O   GLU   275      25.600  49.775  30.306  1.00 33.04           O  
ATOM   4111  N   LYS   276      27.103  48.112  30.289  1.00 34.27           N  
ATOM   4112  CA  LYS   276      26.973  47.761  31.687  1.00 29.67           C  
ATOM   4114  CB  LYS   276      27.495  46.349  31.931  1.00 30.35           C  
ATOM   4117  CG  LYS   276      26.616  45.238  31.352  1.00 32.80           C  
ATOM   4120  CD  LYS   276      25.365  45.033  32.203  1.00 28.34           C  
ATOM   4123  CE  LYS   276      24.552  43.859  31.744  1.00 38.61           C  
ATOM   4126  NZ  LYS   276      23.505  43.576  32.732  1.00 39.42           N  
ATOM   4130  C   LYS   276      27.745  48.726  32.587  1.00 32.79           C  
ATOM   4131  O   LYS   276      27.485  48.813  33.802  1.00 32.46           O  
ATOM   4133  N   CYS   277      28.662  49.473  31.990  1.00 31.12           N  
ATOM   4134  CA  CYS   277      29.512  50.399  32.769  1.00 32.25           C  
ATOM   4136  CB  CYS   277      30.829  50.679  32.051  1.00 31.23           C  
ATOM   4139  SG  CYS   277      31.972  49.348  31.960  1.00 30.22           S  
ATOM   4141  C   CYS   277      28.856  51.741  33.039  1.00 32.20           C  
ATOM   4142  O   CYS   277      29.220  52.465  33.962  1.00 34.40           O  
ATOM   4144  N   VAL   278      27.889  52.057  32.213  1.00 34.07           N  
ATOM   4145  CA  VAL   278      27.221  53.363  32.272  1.00 35.57           C  
ATOM   4147  CB  VAL   278      27.509  54.259  30.998  1.00 31.23           C  
ATOM   4149  CG1 VAL   278      28.967  54.699  30.958  1.00 36.63           C  
ATOM   4153  CG2 VAL   278      27.116  53.548  29.704  1.00 27.42           C  
ATOM   4157  C   VAL   278      25.736  53.232  32.430  1.00 37.72           C  
ATOM   4158  O   VAL   278      25.088  52.476  31.744  1.00 39.36           O  
ATOM   4160  N   LYS   279      25.222  54.011  33.356  1.00 40.86           N  
ATOM   4161  CA  LYS   279      23.788  54.128  33.596  1.00 42.06           C  
ATOM   4163  CB  LYS   279      23.502  53.984  35.084  1.00 42.17           C  
ATOM   4166  CG  LYS   279      22.076  54.240  35.488  1.00 50.12           C  
ATOM   4169  CD  LYS   279      21.855  53.842  36.945  1.00 57.32           C  
ATOM   4172  CE  LYS   279      22.893  54.491  37.867  1.00 67.30           C  
ATOM   4175  NZ  LYS   279      22.855  53.978  39.275  1.00 69.85           N  
ATOM   4179  C   LYS   279      23.318  55.475  33.055  1.00 41.19           C  
ATOM   4180  O   LYS   279      23.558  56.511  33.641  1.00 42.63           O  
ATOM   4182  N   ILE   280      22.688  55.414  31.895  1.00 39.31           N  
ATOM   4183  CA  ILE   280      22.171  56.567  31.154  1.00 39.14           C  
ATOM   4185  CB  ILE   280      22.364  56.410  29.612  1.00 37.71           C  
ATOM   4187  CG1 ILE   280      23.785  55.990  29.267  1.00 36.78           C  
ATOM   4190  CD1 ILE   280      23.993  55.741  27.735  1.00 29.37           C  
ATOM   4194  CG2 ILE   280      22.016  57.707  28.884  1.00 37.22           C  
ATOM   4198  C   ILE   280      20.692  56.754  31.344  1.00 38.23           C  
ATOM   4199  O   ILE   280      19.904  55.857  31.132  1.00 36.16           O  
ATOM   4201  N   GLU   281      20.334  57.965  31.725  1.00 41.00           N  
ATOM   4202  CA  GLU   281      18.938  58.345  31.947  1.00 40.06           C  
ATOM   4204  CB  GLU   281      18.633  58.425  33.443  1.00 40.78           C  
ATOM   4207  CG  GLU   281      19.238  57.292  34.275  1.00 51.98           C  
ATOM   4210  CD  GLU   281      19.170  57.574  35.777  1.00 62.66           C  
ATOM   4211  OE1 GLU   281      18.288  58.357  36.205  1.00 72.64           O  
ATOM   4212  OE2 GLU   281      20.008  57.029  36.530  1.00 70.04           O  
ATOM   4213  C   GLU   281      18.634  59.695  31.331  1.00 38.18           C  
ATOM   4214  O   GLU   281      19.456  60.624  31.340  1.00 33.71           O  
ATOM   4216  N   GLU   282      17.431  59.786  30.797  1.00 37.63           N  
ATOM   4217  CA  GLU   282      16.932  61.042  30.245  1.00 38.03           C  
ATOM   4219  CB  GLU   282      15.986  60.812  29.077  1.00 36.59           C  
ATOM   4222  CG  GLU   282      15.320  62.084  28.558  1.00 42.57           C  
ATOM   4225  CD  GLU   282      14.721  61.898  27.182  1.00 40.02           C  
ATOM   4226  OE1 GLU   282      15.141  60.929  26.516  1.00 46.25           O  
ATOM   4227  OE2 GLU   282      13.871  62.725  26.762  1.00 35.87           O  
ATOM   4228  C   GLU   282      16.272  61.740  31.416  1.00 38.50           C  
ATOM   4229  O   GLU   282      15.352  61.209  32.028  1.00 38.56           O  
ATOM   4231  N   VAL   283      16.795  62.908  31.760  1.00 39.42           N  
ATOM   4232  CA  VAL   283      16.311  63.651  32.915  1.00 40.18           C  
ATOM   4234  CB  VAL   283      17.419  64.490  33.541  1.00 38.57           C  
ATOM   4236  CG1 VAL   283      16.830  65.365  34.661  1.00 42.99           C  
ATOM   4240  CG2 VAL   283      18.518  63.634  34.043  1.00 37.15           C  
ATOM   4244  C   VAL   283      15.254  64.652  32.501  1.00 42.88           C  
ATOM   4245  O   VAL   283      14.350  65.021  33.238  1.00 43.57           O  
ATOM   4247  N   SER   284      15.365  65.066  31.268  1.00 42.76           N  
ATOM   4248  CA  SER   284      14.536  66.124  30.816  1.00 42.79           C  
ATOM   4250  CB  SER   284      15.009  67.376  31.552  1.00 42.77           C  
ATOM   4253  OG  SER   284      14.680  68.523  30.837  1.00 52.73           O  
ATOM   4255  C   SER   284      14.651  66.298  29.325  1.00 41.96           C  
ATOM   4256  O   SER   284      15.619  65.890  28.683  1.00 42.59           O  
ATOM   4258  N   ARG   285      13.614  66.882  28.774  1.00 41.57           N  
ATOM   4259  CA  ARG   285      13.569  67.142  27.345  1.00 41.55           C  
ATOM   4261  CB  ARG   285      13.019  65.924  26.598  1.00 42.70           C  
ATOM   4264  CG  ARG   285      12.909  66.075  25.085  1.00 39.88           C  
ATOM   4267  CD  ARG   285      12.405  64.762  24.443  1.00 37.65           C  
ATOM   4270  NE  ARG   285      13.308  63.612  24.636  1.00 38.10           N  
ATOM   4272  CZ  ARG   285      13.951  62.970  23.660  1.00 33.94           C  
ATOM   4273  NH1 ARG   285      13.804  63.326  22.395  1.00 40.42           N  
ATOM   4276  NH2 ARG   285      14.738  61.951  23.947  1.00 42.12           N  
ATOM   4279  C   ARG   285      12.701  68.329  27.062  1.00 40.71           C  
ATOM   4280  O   ARG   285      11.699  68.545  27.731  1.00 37.53           O  
ATOM   4282  N   ASN   286      13.171  69.149  26.135  1.00 40.56           N  
ATOM   4283  CA  ASN   286      12.353  70.228  25.594  1.00 41.84           C  
ATOM   4285  CB  ASN   286      12.412  71.532  26.387  1.00 40.45           C  
ATOM   4288  CG  ASN   286      13.766  72.165  26.379  1.00 43.97           C  
ATOM   4289  OD1 ASN   286      14.456  72.195  25.363  1.00 40.76           O  
ATOM   4290  ND2 ASN   286      14.152  72.712  27.518  1.00 42.42           N  
ATOM   4293  C   ASN   286      12.724  70.442  24.147  1.00 42.23           C  
ATOM   4294  O   ASN   286      13.420  69.623  23.544  1.00 44.07           O  
ATOM   4296  N   GLU   287      12.272  71.567  23.633  1.00 40.92           N  
ATOM   4297  CA  GLU   287      12.388  71.890  22.204  1.00 41.51           C  
ATOM   4299  CB  GLU   287      11.471  73.077  21.821  1.00 39.13           C  
ATOM   4306  C   GLU   287      13.815  72.222  21.884  1.00 41.77           C  
ATOM   4307  O   GLU   287      14.263  72.133  20.732  1.00 42.02           O  
ATOM   4309  N   GLN   288      14.519  72.582  22.946  1.00 42.19           N  
ATOM   4310  CA  GLN   288      15.909  73.055  22.865  1.00 42.85           C  
ATOM   4312  CB  GLN   288      16.200  74.172  23.889  1.00 44.48           C  
ATOM   4315  CG  GLN   288      15.629  75.542  23.459  1.00 50.61           C  
ATOM   4318  CD  GLN   288      14.133  75.686  23.708  1.00 56.56           C  
ATOM   4319  OE1 GLN   288      13.344  75.895  22.778  1.00 57.71           O  
ATOM   4320  NE2 GLN   288      13.736  75.563  24.972  1.00 61.73           N  
ATOM   4323  C   GLN   288      16.919  71.918  22.994  1.00 39.61           C  
ATOM   4324  O   GLN   288      18.098  72.101  22.721  1.00 39.41           O  
ATOM   4326  N   GLY   289      16.409  70.752  23.352  1.00 36.80           N  
ATOM   4327  CA  GLY   289      17.223  69.562  23.502  1.00 36.69           C  
ATOM   4330  C   GLY   289      16.878  68.663  24.669  1.00 36.94           C  
ATOM   4331  O   GLY   289      15.797  68.734  25.248  1.00 36.88           O  
ATOM   4333  N   VAL   290      17.825  67.796  24.988  1.00 34.63           N  
ATOM   4334  CA  VAL   290      17.656  66.793  26.039  1.00 34.60           C  
ATOM   4336  CB  VAL   290      17.707  65.332  25.479  1.00 36.77           C  
ATOM   4338  CG1 VAL   290      17.672  64.277  26.643  1.00 37.32           C  
ATOM   4342  CG2 VAL   290      16.617  65.075  24.475  1.00 38.25           C  
ATOM   4346  C   VAL   290      18.777  66.878  27.053  1.00 34.26           C  
ATOM   4347  O   VAL   290      19.935  67.126  26.707  1.00 35.31           O  
ATOM   4349  N   THR   291      18.426  66.616  28.297  1.00 31.06           N  
ATOM   4350  CA  THR   291      19.400  66.522  29.349  1.00 30.07           C  
ATOM   4352  CB  THR   291      19.089  67.382  30.527  1.00 29.37           C  
ATOM   4354  OG1 THR   291      18.999  68.740  30.111  1.00 38.57           O  
ATOM   4356  CG2 THR   291      20.209  67.268  31.566  1.00 38.10           C  
ATOM   4360  C   THR   291      19.440  65.068  29.819  1.00 31.94           C  
ATOM   4361  O   THR   291      18.428  64.489  30.230  1.00 28.85           O  
ATOM   4363  N   LEU   292      20.631  64.484  29.745  1.00 29.81           N  
ATOM   4364  CA  LEU   292      20.827  63.087  30.144  1.00 30.56           C  
ATOM   4366  CB  LEU   292      21.658  62.355  29.105  1.00 28.59           C  
ATOM   4369  CG  LEU   292      21.067  62.181  27.713  1.00 34.33           C  
ATOM   4371  CD1 LEU   292      22.136  61.547  26.837  1.00 30.66           C  
ATOM   4375  CD2 LEU   292      19.804  61.292  27.769  1.00 32.92           C  
ATOM   4379  C   LEU   292      21.612  63.033  31.412  1.00 30.12           C  
ATOM   4380  O   LEU   292      22.339  63.964  31.739  1.00 35.12           O  
ATOM   4382  N   SER   293      21.465  61.974  32.167  1.00 31.35           N  
ATOM   4383  CA  SER   293      22.424  61.800  33.249  1.00 34.70           C  
ATOM   4385  CB  SER   293      21.806  61.799  34.633  1.00 33.52           C  
ATOM   4388  OG  SER   293      21.600  60.513  35.100  1.00 41.13           O  
ATOM   4390  C   SER   293      23.148  60.495  32.904  1.00 34.05           C  
ATOM   4391  O   SER   293      22.531  59.523  32.476  1.00 35.74           O  
ATOM   4393  N   ILE   294      24.468  60.542  32.974  1.00 32.50           N  
ATOM   4394  CA  ILE   294      25.285  59.410  32.674  1.00 33.01           C  
ATOM   4396  CB  ILE   294      26.166  59.645  31.444  1.00 35.38           C  
ATOM   4398  CG1 ILE   294      25.325  60.111  30.255  1.00 36.25           C  
ATOM   4401  CD1 ILE   294      26.158  60.548  29.087  1.00 32.36           C  
ATOM   4405  CG2 ILE   294      26.979  58.382  31.111  1.00 28.47           C  
ATOM   4409  C   ILE   294      26.170  59.156  33.851  1.00 33.19           C  
ATOM   4410  O   ILE   294      27.008  59.985  34.183  1.00 37.78           O  
ATOM   4412  N   THR   295      25.930  58.022  34.493  1.00 34.16           N  
ATOM   4413  CA  THR   295      26.693  57.550  35.646  1.00 31.16           C  
ATOM   4415  CB  THR   295      25.776  57.127  36.832  1.00 33.24           C  
ATOM   4417  OG1 THR   295      24.863  58.189  37.147  1.00 28.71           O  
ATOM   4419  CG2 THR   295      26.628  56.715  38.117  1.00 17.51           C  
ATOM   4423  C   THR   295      27.626  56.370  35.265  1.00 32.96           C  
ATOM   4424  O   THR   295      27.240  55.407  34.564  1.00 34.46           O  
ATOM   4426  N   ASN   296      28.875  56.523  35.697  1.00 29.44           N  
ATOM   4427  CA  ASN   296      29.908  55.501  35.587  1.00 29.28           C  
ATOM   4429  CB  ASN   296      31.306  56.102  35.382  1.00 29.38           C  
ATOM   4432  CG  ASN   296      32.419  55.044  35.305  1.00 33.50           C  
ATOM   4433  OD1 ASN   296      32.192  53.858  35.483  1.00 40.88           O  
ATOM   4434  ND2 ASN   296      33.622  55.489  35.005  1.00 31.77           N  
ATOM   4437  C   ASN   296      29.848  54.772  36.917  1.00 28.33           C  
ATOM   4438  O   ASN   296      30.228  55.331  37.956  1.00 25.21           O  
ATOM   4440  N   VAL   297      29.314  53.555  36.854  1.00 28.65           N  
ATOM   4441  CA  VAL   297      29.094  52.694  38.002  1.00 31.53           C  
ATOM   4443  CB  VAL   297      27.766  51.846  37.840  1.00 33.10           C  
ATOM   4445  CG1 VAL   297      26.570  52.737  37.470  1.00 33.14           C  
ATOM   4449  CG2 VAL   297      27.906  50.729  36.794  1.00 32.44           C  
ATOM   4453  C   VAL   297      30.272  51.757  38.213  1.00 34.15           C  
ATOM   4454  O   VAL   297      30.137  50.729  38.836  1.00 38.97           O  
ATOM   4456  N   THR   298      31.432  52.104  37.679  1.00 35.22           N  
ATOM   4457  CA  THR   298      32.613  51.227  37.795  1.00 30.77           C  
ATOM   4459  CB  THR   298      32.958  50.597  36.422  1.00 32.77           C  
ATOM   4461  OG1 THR   298      33.720  51.515  35.633  1.00 32.94           O  
ATOM   4463  CG2 THR   298      31.687  50.209  35.678  1.00 28.04           C  
ATOM   4467  C   THR   298      33.863  51.923  38.322  1.00 28.25           C  
ATOM   4468  O   THR   298      33.874  53.111  38.587  1.00 28.24           O  
ATOM   4470  N   ASP   299      34.910  51.127  38.460  1.00 26.07           N  
ATOM   4471  CA  ASP   299      36.217  51.581  38.883  1.00 24.38           C  
ATOM   4473  CB  ASP   299      37.035  50.438  39.488  1.00 28.18           C  
ATOM   4476  CG  ASP   299      36.618  50.120  40.915  1.00 32.18           C  
ATOM   4477  OD1 ASP   299      35.878  50.929  41.501  1.00 29.03           O  
ATOM   4478  OD2 ASP   299      37.052  49.083  41.431  1.00 31.30           O  
ATOM   4479  C   ASP   299      37.017  52.048  37.702  1.00 28.53           C  
ATOM   4480  O   ASP   299      38.117  52.537  37.861  1.00 31.91           O  
ATOM   4482  N   LEU   300      36.473  51.850  36.513  1.00 27.77           N  
ATOM   4483  CA  LEU   300      37.185  52.200  35.275  1.00 31.76           C  
ATOM   4485  CB  LEU   300      36.777  51.263  34.158  1.00 30.71           C  
ATOM   4488  CG  LEU   300      36.742  49.734  34.383  1.00 39.01           C  
ATOM   4490  CD1 LEU   300      36.131  49.056  33.119  1.00 41.46           C  
ATOM   4494  CD2 LEU   300      38.085  49.173  34.711  1.00 26.53           C  
ATOM   4498  C   LEU   300      36.871  53.605  34.826  1.00 32.03           C  
ATOM   4499  O   LEU   300      35.750  54.051  34.926  1.00 38.09           O  
ATOM   4501  N   VAL   301      37.888  54.303  34.365  1.00 33.30           N  
ATOM   4502  CA  VAL   301      37.729  55.626  33.776  1.00 33.44           C  
ATOM   4504  CB  VAL   301      39.036  56.556  33.867  1.00 31.21           C  
ATOM   4506  CG1 VAL   301      40.144  56.010  33.092  1.00 34.62           C  
ATOM   4510  CG2 VAL   301      38.743  57.976  33.358  1.00 26.74           C  
ATOM   4514  C   VAL   301      37.289  55.339  32.344  1.00 35.34           C  
ATOM   4515  O   VAL   301      37.746  54.379  31.721  1.00 32.91           O  
ATOM   4517  N   LEU   302      36.378  56.164  31.845  1.00 35.20           N  
ATOM   4518  CA  LEU   302      35.889  56.032  30.455  1.00 34.59           C  
ATOM   4520  CB  LEU   302      34.397  55.647  30.410  1.00 32.88           C  
ATOM   4523  CG  LEU   302      33.978  54.440  31.245  1.00 31.07           C  
ATOM   4525  CD1 LEU   302      32.520  54.412  31.316  1.00 26.09           C  
ATOM   4529  CD2 LEU   302      34.511  53.107  30.698  1.00 21.84           C  
ATOM   4533  C   LEU   302      36.111  57.326  29.683  1.00 33.93           C  
ATOM   4534  O   LEU   302      35.719  58.401  30.118  1.00 31.55           O  
ATOM   4536  N   LYS   303      36.739  57.212  28.520  1.00 29.97           N  
ATOM   4537  CA  LYS   303      37.054  58.395  27.752  1.00 31.54           C  
ATOM   4539  CB  LYS   303      38.553  58.452  27.537  1.00 34.46           C  
ATOM   4542  CG  LYS   303      39.341  58.544  28.863  1.00 38.68           C  
ATOM   4545  CD  LYS   303      40.826  58.640  28.585  1.00 49.81           C  
ATOM   4548  CE  LYS   303      41.653  58.748  29.860  1.00 61.43           C  
ATOM   4551  NZ  LYS   303      41.495  60.083  30.529  1.00 65.02           N  
ATOM   4555  C   LYS   303      36.296  58.401  26.455  1.00 33.89           C  
ATOM   4556  O   LYS   303      36.420  57.485  25.667  1.00 33.35           O  
ATOM   4558  N   LEU   304      35.481  59.446  26.285  1.00 34.67           N  
ATOM   4559  CA  LEU   304      34.587  59.610  25.132  1.00 34.85           C  
ATOM   4561  CB  LEU   304      33.146  59.874  25.601  1.00 34.30           C  
ATOM   4564  CG  LEU   304      32.641  59.051  26.818  1.00 40.57           C  
ATOM   4566  CD1 LEU   304      31.184  59.401  27.176  1.00 25.76           C  
ATOM   4570  CD2 LEU   304      32.821  57.532  26.591  1.00 34.97           C  
ATOM   4574  C   LEU   304      35.043  60.724  24.219  1.00 34.43           C  
ATOM   4575  O   LEU   304      35.516  61.758  24.644  1.00 33.19           O  
ATOM   4577  N   LYS   305      34.894  60.488  22.930  0.50 33.13           N  
ATOM   4579  CA  LYS   305      35.255  61.482  21.946  0.50 32.56           C  
ATOM   4583  CB  LYS   305      36.665  61.240  21.409  0.50 33.90           C  
ATOM   4589  CG  LYS   305      37.169  62.325  20.461  0.50 30.45           C  
ATOM   4595  CD  LYS   305      38.584  62.046  19.974  0.50 30.84           C  
ATOM   4601  CE  LYS   305      39.634  62.266  21.064  0.50 33.97           C  
ATOM   4607  NZ  LYS   305      39.769  63.700  21.470  0.50 33.46           N  
ATOM   4615  C   LYS   305      34.238  61.442  20.838  0.50 31.59           C  
ATOM   4617  O   LYS   305      33.954  60.394  20.271  0.50 30.74           O  
ATOM   4621  N   LYS   306      33.675  62.615  20.576  1.00 31.09           N  
ATOM   4622  CA  LYS   306      32.653  62.803  19.551  1.00 28.56           C  
ATOM   4624  CB  LYS   306      32.134  64.259  19.512  1.00 28.79           C  
ATOM   4627  CG  LYS   306      30.993  64.493  18.534  1.00 32.54           C  
ATOM   4630  CD  LYS   306      30.273  65.803  18.743  1.00 27.21           C  
ATOM   4633  CE  LYS   306      31.173  66.997  18.696  1.00 28.95           C  
ATOM   4636  NZ  LYS   306      30.391  68.187  19.182  1.00 24.83           N  
ATOM   4640  C   LYS   306      33.193  62.394  18.175  1.00 29.60           C  
ATOM   4641  O   LYS   306      34.275  62.775  17.768  1.00 28.25           O  
ATOM   4643  N   THR   307      32.391  61.590  17.493  1.00 28.70           N  
ATOM   4644  CA  THR   307      32.674  61.145  16.165  1.00 28.74           C  
ATOM   4646  CB  THR   307      32.589  59.625  16.067  1.00 28.79           C  
ATOM   4648  OG1 THR   307      31.302  59.212  16.490  1.00 29.20           O  
ATOM   4650  CG2 THR   307      33.640  58.940  16.955  1.00 26.33           C  
ATOM   4654  C   THR   307      31.659  61.768  15.245  1.00 31.56           C  
ATOM   4655  O   THR   307      30.882  62.647  15.636  1.00 34.18           O  
ATOM   4657  N   ALA   308      31.649  61.294  14.012  1.00 32.19           N  
ATOM   4658  CA  ALA   308      30.744  61.855  12.996  1.00 30.00           C  
ATOM   4660  CB  ALA   308      30.912  61.127  11.657  1.00 30.46           C  
ATOM   4664  C   ALA   308      29.298  61.880  13.444  1.00 29.36           C  
ATOM   4665  O   ALA   308      28.725  60.881  13.877  1.00 31.36           O  
ATOM   4667  N   HIS   309      28.692  63.050  13.298  1.00 32.58           N  
ATOM   4668  CA  HIS   309      27.333  63.269  13.765  1.00 31.90           C  
ATOM   4670  CB  HIS   309      27.392  63.687  15.236  1.00 34.35           C  
ATOM   4673  CG  HIS   309      28.085  65.001  15.435  1.00 32.23           C  
ATOM   4674  ND1 HIS   309      29.456  65.139  15.358  1.00 32.47           N  
ATOM   4676  CE1 HIS   309      29.779  66.407  15.531  1.00 29.35           C  
ATOM   4678  NE2 HIS   309      28.666  67.105  15.681  1.00 29.55           N  
ATOM   4680  CD2 HIS   309      27.591  66.249  15.617  1.00 21.28           C  
ATOM   4682  C   HIS   309      26.569  64.348  13.003  1.00 34.48           C  
ATOM   4683  O   HIS   309      27.092  65.028  12.143  1.00 33.26           O  
ATOM   4685  N   ASP   310      25.289  64.458  13.326  1.00 36.01           N  
ATOM   4686  CA  ASP   310      24.444  65.521  12.770  1.00 36.70           C  
ATOM   4688  CB  ASP   310      22.961  65.243  12.982  1.00 38.38           C  
ATOM   4691  CG  ASP   310      22.058  66.374  12.458  1.00 39.26           C  
ATOM   4692  OD1 ASP   310      22.580  67.431  12.056  1.00 43.09           O  
ATOM   4693  OD2 ASP   310      20.816  66.207  12.482  1.00 42.88           O  
ATOM   4694  C   ASP   310      24.871  66.777  13.491  1.00 35.90           C  
ATOM   4695  O   ASP   310      24.770  66.896  14.706  1.00 34.03           O  
ATOM   4697  N   THR   311      25.351  67.725  12.722  1.00 37.82           N  
ATOM   4698  CA  THR   311      25.939  68.926  13.307  1.00 38.05           C  
ATOM   4700  CB  THR   311      26.704  69.707  12.239  1.00 37.45           C  
ATOM   4702  OG1 THR   311      27.616  70.571  12.885  1.00 46.07           O  
ATOM   4704  CG2 THR   311      25.768  70.503  11.363  1.00 41.38           C  
ATOM   4708  C   THR   311      24.885  69.788  14.027  1.00 35.73           C  
ATOM   4709  O   THR   311      25.215  70.666  14.784  1.00 35.64           O  
ATOM   4711  N   LEU   312      23.614  69.463  13.828  1.00 37.29           N  
ATOM   4712  CA  LEU   312      22.480  70.192  14.458  1.00 35.36           C  
ATOM   4714  CB  LEU   312      21.223  70.078  13.613  1.00 35.68           C  
ATOM   4717  CG  LEU   312      21.359  70.766  12.246  1.00 37.56           C  
ATOM   4719  CD1 LEU   312      20.147  70.507  11.375  1.00 34.80           C  
ATOM   4723  CD2 LEU   312      21.585  72.253  12.435  1.00 27.64           C  
ATOM   4727  C   LEU   312      22.235  69.606  15.837  1.00 34.24           C  
ATOM   4728  O   LEU   312      21.463  70.118  16.635  1.00 33.19           O  
ATOM   4730  N   LEU   313      22.924  68.504  16.091  1.00 34.47           N  
ATOM   4731  CA  LEU   313      22.855  67.809  17.376  1.00 34.91           C  
ATOM   4733  CB  LEU   313      22.773  66.297  17.198  1.00 33.86           C  
ATOM   4736  CG  LEU   313      22.220  65.502  18.390  1.00 40.50           C  
ATOM   4738  CD1 LEU   313      20.732  65.810  18.644  1.00 35.52           C  
ATOM   4742  CD2 LEU   313      22.413  63.990  18.178  1.00 43.20           C  
ATOM   4746  C   LEU   313      24.113  68.231  18.093  1.00 33.35           C  
ATOM   4747  O   LEU   313      25.210  67.763  17.799  1.00 34.85           O  
ATOM   4749  N   VAL   314      23.932  69.133  19.037  1.00 33.27           N  
ATOM   4750  CA  VAL   314      25.041  69.767  19.744  1.00 33.97           C  
ATOM   4752  CB  VAL   314      24.742  71.281  19.995  1.00 36.31           C  
ATOM   4754  CG1 VAL   314      25.966  71.988  20.664  1.00 28.16           C  
ATOM   4758  CG2 VAL   314      24.326  71.992  18.675  1.00 30.71           C  
ATOM   4762  C   VAL   314      25.403  69.118  21.057  1.00 35.87           C  
ATOM   4763  O   VAL   314      24.645  69.168  22.011  1.00 35.66           O  
ATOM   4765  N   TYR   315      26.580  68.492  21.089  1.00 33.73           N  
ATOM   4766  CA  TYR   315      27.059  67.901  22.325  1.00 32.56           C  
ATOM   4768  CB  TYR   315      26.555  66.442  22.488  1.00 33.21           C  
ATOM   4771  CG  TYR   315      26.916  65.499  21.362  1.00 32.27           C  
ATOM   4772  CD1 TYR   315      26.304  65.598  20.123  1.00 30.68           C  
ATOM   4774  CE1 TYR   315      26.631  64.728  19.079  1.00 30.00           C  
ATOM   4776  CZ  TYR   315      27.608  63.760  19.270  1.00 28.31           C  
ATOM   4777  OH  TYR   315      27.944  62.882  18.251  1.00 28.32           O  
ATOM   4779  CE2 TYR   315      28.248  63.642  20.504  1.00 26.77           C  
ATOM   4781  CD2 TYR   315      27.886  64.506  21.544  1.00 34.84           C  
ATOM   4783  C   TYR   315      28.584  67.996  22.471  1.00 33.24           C  
ATOM   4784  O   TYR   315      29.327  68.509  21.595  1.00 31.28           O  
ATOM   4786  N   PHE   316      29.019  67.487  23.609  1.00 28.84           N  
ATOM   4787  CA  PHE   316      30.438  67.512  24.006  1.00 29.10           C  
ATOM   4789  CB  PHE   316      30.714  66.579  25.186  1.00 26.17           C  
ATOM   4792  CG  PHE   316      30.536  65.108  24.887  1.00 30.84           C  
ATOM   4793  CD1 PHE   316      31.548  64.365  24.264  1.00 28.40           C  
ATOM   4795  CE1 PHE   316      31.398  63.019  24.037  1.00 33.60           C  
ATOM   4797  CZ  PHE   316      30.243  62.356  24.491  1.00 35.62           C  
ATOM   4799  CE2 PHE   316      29.270  63.056  25.160  1.00 32.00           C  
ATOM   4801  CD2 PHE   316      29.406  64.429  25.345  1.00 35.53           C  
ATOM   4803  C   PHE   316      31.354  67.137  22.879  1.00 30.66           C  
ATOM   4804  O   PHE   316      30.924  66.502  21.924  1.00 31.27           O  
ATOM   4806  N   ARG   317      32.621  67.564  22.977  1.00 32.64           N  
ATOM   4807  CA  ARG   317      33.585  67.188  21.935  1.00 32.97           C  
ATOM   4809  CB  ARG   317      34.573  68.278  21.539  1.00 30.16           C  
ATOM   4812  CG  ARG   317      34.771  68.101  20.025  1.00 46.46           C  
ATOM   4815  CD  ARG   317      35.753  68.969  19.341  1.00 42.32           C  
ATOM   4818  NE  ARG   317      35.505  70.395  19.440  1.00 28.54           N  
ATOM   4820  CZ  ARG   317      36.464  71.236  19.102  1.00 37.46           C  
ATOM   4821  NH1 ARG   317      37.594  70.703  18.647  1.00 38.81           N  
ATOM   4824  NH2 ARG   317      36.326  72.560  19.186  1.00 37.21           N  
ATOM   4827  C   ARG   317      34.347  65.986  22.418  1.00 31.41           C  
ATOM   4828  O   ARG   317      34.666  65.070  21.654  1.00 32.43           O  
ATOM   4830  N   ASP   318      34.649  66.076  23.704  1.00 28.68           N  
ATOM   4831  CA  ASP   318      35.403  65.115  24.456  1.00 29.79           C  
ATOM   4833  CB  ASP   318      36.867  65.514  24.533  1.00 31.15           C  
ATOM   4836  CG  ASP   318      37.649  65.183  23.287  1.00 40.25           C  
ATOM   4837  OD1 ASP   318      38.074  64.000  23.130  1.00 46.09           O  
ATOM   4838  OD2 ASP   318      37.899  66.132  22.508  1.00 37.69           O  
ATOM   4839  C   ASP   318      34.866  65.125  25.855  1.00 33.03           C  
ATOM   4840  O   ASP   318      34.444  66.141  26.354  1.00 35.27           O  
ATOM   4842  N   MET   319      34.933  63.985  26.503  1.00 33.36           N  
ATOM   4843  CA  MET   319      34.435  63.859  27.862  1.00 35.31           C  
ATOM   4845  CB  MET   319      32.934  63.718  27.745  1.00 36.80           C  
ATOM   4848  CG  MET   319      32.222  63.694  28.998  1.00 43.98           C  
ATOM   4851  SD  MET   319      30.286  63.486  28.763  0.75 44.65          SE  
ATOM   4852  CE  MET   319      30.098  63.497  30.769  1.00 38.14           C  
ATOM   4856  C   MET   319      35.029  62.643  28.563  1.00 33.65           C  
ATOM   4857  O   MET   319      35.160  61.582  27.986  1.00 36.67           O  
ATOM   4859  N   THR   320      35.429  62.839  29.797  1.00 32.15           N  
ATOM   4860  CA  THR   320      35.986  61.774  30.606  1.00 32.77           C  
ATOM   4862  CB  THR   320      37.349  62.143  31.118  1.00 35.54           C  
ATOM   4864  OG1 THR   320      38.246  62.239  30.011  1.00 40.01           O  
ATOM   4866  CG2 THR   320      37.867  61.099  32.131  1.00 36.00           C  
ATOM   4870  C   THR   320      35.085  61.469  31.794  1.00 32.50           C  
ATOM   4871  O   THR   320      34.749  62.333  32.580  1.00 36.36           O  
ATOM   4873  N   LEU   321      34.638  60.228  31.870  1.00 31.03           N  
ATOM   4874  CA  LEU   321      33.777  59.789  32.968  1.00 31.97           C  
ATOM   4876  CB  LEU   321      32.657  58.876  32.457  1.00 32.24           C  
ATOM   4879  CG  LEU   321      31.532  59.385  31.552  1.00 39.99           C  
ATOM   4881  CD1 LEU   321      32.003  59.950  30.226  1.00 42.92           C  
ATOM   4885  CD2 LEU   321      30.662  58.200  31.294  1.00 41.77           C  
ATOM   4889  C   LEU   321      34.614  59.089  34.031  1.00 28.26           C  
ATOM   4890  O   LEU   321      35.075  57.963  33.858  1.00 29.26           O  
ATOM   4892  N   LYS   322      34.819  59.785  35.129  1.00 29.09           N  
ATOM   4893  CA  LYS   322      35.589  59.207  36.248  1.00 31.93           C  
ATOM   4895  CB  LYS   322      36.090  60.249  37.271  1.00 29.75           C  
ATOM   4898  CG  LYS   322      37.144  61.207  36.723  1.00 37.49           C  
ATOM   4901  CD  LYS   322      37.585  62.173  37.772  1.00 47.15           C  
ATOM   4904  CE  LYS   322      38.480  63.301  37.215  1.00 56.48           C  
ATOM   4907  NZ  LYS   322      39.834  62.853  36.767  1.00 63.44           N  
ATOM   4911  C   LYS   322      34.786  58.142  36.933  1.00 30.21           C  
ATOM   4912  O   LYS   322      33.560  58.131  36.852  1.00 29.75           O  
ATOM   4914  N   PRO   323      35.483  57.209  37.587  1.00 32.36           N  
ATOM   4915  CA  PRO   323      34.790  56.128  38.277  1.00 33.82           C  
ATOM   4917  CB  PRO   323      35.918  55.377  38.975  1.00 33.13           C  
ATOM   4920  CG  PRO   323      37.112  55.669  38.176  1.00 32.98           C  
ATOM   4923  CD  PRO   323      36.946  57.060  37.659  1.00 31.71           C  
ATOM   4926  C   PRO   323      33.824  56.626  39.317  1.00 33.57           C  
ATOM   4927  O   PRO   323      34.105  57.600  40.011  1.00 31.77           O  
ATOM   4928  N   HIS   324      32.672  55.968  39.347  1.00 31.45           N  
ATOM   4929  CA  HIS   324      31.631  56.199  40.365  1.00 31.53           C  
ATOM   4931  CB  HIS   324      32.145  55.707  41.724  1.00 29.54           C  
ATOM   4934  CG  HIS   324      32.654  54.306  41.677  1.00 28.06           C  
ATOM   4935  ND1 HIS   324      31.826  53.223  41.484  1.00 27.70           N  
ATOM   4937  CE1 HIS   324      32.549  52.117  41.455  1.00 25.12           C  
ATOM   4939  NE2 HIS   324      33.822  52.444  41.619  1.00 26.00           N  
ATOM   4941  CD2 HIS   324      33.910  53.805  41.786  1.00 31.51           C  
ATOM   4943  C   HIS   324      31.155  57.626  40.459  1.00 30.17           C  
ATOM   4944  O   HIS   324      30.896  58.162  41.537  1.00 33.39           O  
ATOM   4946  N   THR   325      30.994  58.216  39.290  1.00 31.35           N  
ATOM   4947  CA  THR   325      30.615  59.624  39.137  1.00 29.05           C  
ATOM   4949  CB  THR   325      31.862  60.462  38.685  1.00 28.83           C  
ATOM   4951  OG1 THR   325      32.928  60.286  39.632  1.00 32.32           O  
ATOM   4953  CG2 THR   325      31.564  61.972  38.503  1.00 24.51           C  
ATOM   4957  C   THR   325      29.448  59.768  38.159  1.00 31.28           C  
ATOM   4958  O   THR   325      29.356  59.109  37.104  1.00 26.72           O  
ATOM   4960  N   ARG   326      28.535  60.637  38.574  1.00 35.04           N  
ATOM   4961  CA  ARG   326      27.339  60.938  37.813  1.00 34.26           C  
ATOM   4963  CB  ARG   326      26.125  61.023  38.726  1.00 36.02           C  
ATOM   4966  CG  ARG   326      24.814  61.338  38.023  1.00 39.48           C  
ATOM   4969  CD  ARG   326      23.673  61.598  39.009  1.00 51.60           C  
ATOM   4972  NE  ARG   326      23.910  62.757  39.885  1.00 65.38           N  
ATOM   4974  CZ  ARG   326      24.267  62.683  41.169  1.00 68.64           C  
ATOM   4975  NH1 ARG   326      24.410  61.495  41.744  1.00 70.93           N  
ATOM   4978  NH2 ARG   326      24.467  63.794  41.882  1.00 67.29           N  
ATOM   4981  C   ARG   326      27.573  62.251  37.119  1.00 33.95           C  
ATOM   4982  O   ARG   326      27.980  63.226  37.742  1.00 33.95           O  
ATOM   4984  N   TYR   327      27.351  62.213  35.812  1.00 33.68           N  
ATOM   4985  CA  TYR   327      27.443  63.368  34.927  1.00 33.22           C  
ATOM   4987  CB  TYR   327      28.423  63.068  33.777  1.00 32.10           C  
ATOM   4990  CG  TYR   327      29.818  62.881  34.293  1.00 32.88           C  
ATOM   4991  CD1 TYR   327      30.666  63.973  34.455  1.00 32.72           C  
ATOM   4993  CE1 TYR   327      31.972  63.808  34.956  1.00 31.77           C  
ATOM   4995  CZ  TYR   327      32.400  62.550  35.360  1.00 24.75           C  
ATOM   4996  OH  TYR   327      33.681  62.397  35.841  1.00 31.53           O  
ATOM   4998  CE2 TYR   327      31.572  61.459  35.229  1.00 25.95           C  
ATOM   5000  CD2 TYR   327      30.284  61.621  34.675  1.00 27.54           C  
ATOM   5002  C   TYR   327      26.090  63.787  34.355  1.00 33.94           C  
ATOM   5003  O   TYR   327      25.250  62.953  34.016  1.00 32.76           O  
ATOM   5005  N   THR   328      25.906  65.103  34.268  1.00 34.31           N  
ATOM   5006  CA  THR   328      24.746  65.709  33.641  1.00 35.49           C  
ATOM   5008  CB  THR   328      24.214  66.893  34.410  1.00 36.23           C  
ATOM   5010  OG1 THR   328      23.902  66.485  35.735  1.00 43.91           O  
ATOM   5012  CG2 THR   328      22.931  67.415  33.752  1.00 43.18           C  
ATOM   5016  C   THR   328      25.206  66.204  32.303  1.00 36.20           C  
ATOM   5017  O   THR   328      26.086  67.026  32.216  1.00 37.22           O  
ATOM   5019  N   VAL   329      24.605  65.682  31.260  1.00 37.93           N  
ATOM   5020  CA  VAL   329      25.006  65.981  29.887  1.00 37.40           C  
ATOM   5022  CB  VAL   329      25.548  64.670  29.209  1.00 39.50           C  
ATOM   5024  CG1 VAL   329      26.176  64.935  27.847  1.00 33.15           C  
ATOM   5028  CG2 VAL   329      26.534  63.984  30.133  1.00 36.41           C  
ATOM   5032  C   VAL   329      23.846  66.502  29.086  1.00 37.79           C  
ATOM   5033  O   VAL   329      22.767  65.915  29.049  1.00 41.30           O  
ATOM   5035  N   ARG   330      24.088  67.630  28.445  1.00 37.30           N  
ATOM   5036  CA  ARG   330      23.090  68.289  27.627  1.00 34.80           C  
ATOM   5038  CB  ARG   330      23.032  69.779  27.970  1.00 36.27           C  
ATOM   5041  CG  ARG   330      21.966  70.611  27.199  1.00 36.35           C  
ATOM   5044  CD  ARG   330      20.508  70.296  27.600  1.00 36.31           C  
ATOM   5047  NE  ARG   330      19.533  71.093  26.829  1.00 36.53           N  
ATOM   5049  CZ  ARG   330      18.218  70.909  26.852  1.00 36.78           C  
ATOM   5050  NH1 ARG   330      17.687  69.920  27.554  1.00 45.77           N  
ATOM   5053  NH2 ARG   330      17.440  71.670  26.106  1.00 41.03           N  
ATOM   5056  C   ARG   330      23.362  68.120  26.146  1.00 34.79           C  
ATOM   5057  O   ARG   330      24.474  68.222  25.663  1.00 34.53           O  
ATOM   5059  N   ILE   331      22.293  67.816  25.437  0.50 35.02           N  
ATOM   5061  CA  ILE   331      22.328  67.696  23.985  0.50 34.68           C  
ATOM   5065  CB  ILE   331      21.891  66.300  23.459  0.50 33.01           C  
ATOM   5069  CG1 ILE   331      22.887  65.198  23.848  0.50 32.23           C  
ATOM   5075  CD1 ILE   331      22.718  64.614  25.235  0.50 27.37           C  
ATOM   5083  CG2 ILE   331      21.740  66.321  21.933  0.50 31.44           C  
ATOM   5091  C   ILE   331      21.391  68.755  23.431  0.50 34.60           C  
ATOM   5093  O   ILE   331      20.197  68.744  23.698  0.50 35.71           O  
ATOM   5097  N   GLY   332      21.946  69.695  22.687  1.00 32.92           N  
ATOM   5098  CA  GLY   332      21.146  70.711  22.097  1.00 33.59           C  
ATOM   5101  C   GLY   332      20.611  70.293  20.752  1.00 37.39           C  
ATOM   5102  O   GLY   332      21.213  69.497  20.016  1.00 37.58           O  
ATOM   5104  N   PHE   333      19.442  70.844  20.458  1.00 37.34           N  
ATOM   5105  CA  PHE   333      18.763  70.635  19.198  1.00 37.57           C  
ATOM   5107  CB  PHE   333      17.295  70.224  19.380  1.00 37.87           C  
ATOM   5110  CG  PHE   333      17.091  68.894  20.058  1.00 34.49           C  
ATOM   5111  CD1 PHE   333      18.000  67.863  19.901  1.00 31.77           C  
ATOM   5113  CE1 PHE   333      17.803  66.636  20.501  1.00 34.24           C  
ATOM   5115  CZ  PHE   333      16.664  66.395  21.231  1.00 43.84           C  
ATOM   5117  CE2 PHE   333      15.709  67.393  21.348  1.00 41.35           C  
ATOM   5119  CD2 PHE   333      15.930  68.642  20.753  1.00 41.27           C  
ATOM   5121  C   PHE   333      18.794  71.941  18.452  1.00 38.22           C  
ATOM   5122  O   PHE   333      18.212  72.918  18.889  1.00 38.17           O  
ATOM   5124  N   LYS   334      19.494  71.970  17.335  1.00 39.91           N  
ATOM   5125  CA  LYS   334      19.533  73.195  16.527  1.00 40.46           C  
ATOM   5127  CB  LYS   334      20.924  73.522  15.971  1.00 39.30           C  
ATOM   5130  CG  LYS   334      21.955  74.050  16.975  1.00 35.15           C  
ATOM   5133  CD  LYS   334      23.316  74.247  16.260  1.00 34.79           C  
ATOM   5138  C   LYS   334      18.552  73.085  15.393  1.00 40.31           C  
ATOM   5139  O   LYS   334      18.153  72.004  14.991  1.00 41.44           O  
ATOM   5141  N   GLN   335      18.253  74.251  14.845  1.00 41.42           N  
ATOM   5142  CA  GLN   335      17.252  74.406  13.811  1.00 40.88           C  
ATOM   5144  CB  GLN   335      17.780  73.995  12.442  1.00 39.96           C  
ATOM   5147  CG  GLN   335      18.914  74.925  11.989  1.00 42.53           C  
ATOM   5150  CD  GLN   335      19.298  74.747  10.543  1.00 41.41           C  
ATOM   5153  C   GLN   335      16.032  73.601  14.269  1.00 43.11           C  
ATOM   5154  O   GLN   335      15.651  73.661  15.447  1.00 46.27           O  
ATOM   5156  N   GLY   336      15.419  72.821  13.406  1.00 40.23           N  
ATOM   5157  CA  GLY   336      14.231  72.147  13.892  1.00 41.98           C  
ATOM   5160  C   GLY   336      14.339  70.723  14.393  1.00 43.69           C  
ATOM   5161  O   GLY   336      13.315  70.076  14.633  1.00 45.56           O  
ATOM   5163  N   ILE   337      15.556  70.239  14.600  1.00 42.52           N  
ATOM   5164  CA  ILE   337      15.717  68.812  14.942  1.00 42.13           C  
ATOM   5166  CB  ILE   337      17.195  68.319  14.894  1.00 41.26           C  
ATOM   5168  CG1 ILE   337      18.025  68.869  16.036  1.00 41.90           C  
ATOM   5171  CD1 ILE   337      19.272  68.013  16.233  1.00 43.40           C  
ATOM   5175  CG2 ILE   337      17.820  68.661  13.528  1.00 40.41           C  
ATOM   5179  C   ILE   337      14.995  68.443  16.238  1.00 39.48           C  
ATOM   5180  O   ILE   337      14.846  69.268  17.127  1.00 40.19           O  
ATOM   5182  N   LYS   338      14.513  67.199  16.271  1.00 38.20           N  
ATOM   5183  CA  LYS   338      13.695  66.673  17.368  1.00 38.66           C  
ATOM   5185  CB  LYS   338      12.344  66.218  16.826  1.00 37.66           C  
ATOM   5192  C   LYS   338      14.380  65.527  18.101  1.00 40.00           C  
ATOM   5193  O   LYS   338      13.981  65.090  19.182  1.00 41.64           O  
ATOM   5195  N   GLY   339      15.446  65.065  17.489  1.00 39.23           N  
ATOM   5196  CA  GLY   339      16.255  63.992  18.050  1.00 37.91           C  
ATOM   5199  C   GLY   339      17.425  63.672  17.177  1.00 37.24           C  
ATOM   5200  O   GLY   339      17.784  64.437  16.285  1.00 39.36           O  
ATOM   5202  N   GLY   340      18.012  62.513  17.416  1.00 38.21           N  
ATOM   5203  CA  GLY   340      19.194  62.118  16.657  1.00 35.20           C  
ATOM   5206  C   GLY   340      20.135  61.236  17.404  1.00 34.58           C  
ATOM   5207  O   GLY   340      19.919  60.859  18.567  1.00 33.84           O  
ATOM   5209  N   ASP   341      21.187  60.906  16.681  1.00 34.08           N  
ATOM   5210  CA  ASP   341      22.240  59.995  17.170  1.00 33.45           C  
ATOM   5212  CB  ASP   341      22.736  59.075  16.044  1.00 33.36           C  
ATOM   5215  CG  ASP   341      21.716  57.995  15.636  1.00 37.70           C  
ATOM   5216  OD1 ASP   341      20.853  57.618  16.451  1.00 36.36           O  
ATOM   5217  OD2 ASP   341      21.785  57.528  14.470  1.00 44.63           O  
ATOM   5218  C   ASP   341      23.429  60.741  17.743  1.00 34.12           C  
ATOM   5219  O   ASP   341      24.177  61.445  17.015  1.00 32.56           O  
ATOM   5221  N   VAL   342      23.578  60.573  19.055  1.00 31.37           N  
ATOM   5222  CA  VAL   342      24.708  61.107  19.816  1.00 31.02           C  
ATOM   5224  CB  VAL   342      24.338  61.341  21.301  1.00 33.20           C  
ATOM   5226  CG1 VAL   342      25.553  61.723  22.082  1.00 27.69           C  
ATOM   5230  CG2 VAL   342      23.213  62.398  21.410  1.00 27.11           C  
ATOM   5234  C   VAL   342      25.838  60.094  19.675  1.00 31.68           C  
ATOM   5235  O   VAL   342      25.914  59.101  20.385  1.00 29.50           O  
ATOM   5237  N   ASN   343      26.699  60.342  18.704  1.00 33.39           N  
ATOM   5238  CA  ASN   343      27.762  59.384  18.350  1.00 34.71           C  
ATOM   5240  CB  ASN   343      27.915  59.286  16.834  1.00 31.29           C  
ATOM   5243  CG  ASN   343      26.647  58.929  16.152  1.00 35.78           C  
ATOM   5244  OD1 ASN   343      25.833  58.188  16.692  1.00 34.55           O  
ATOM   5245  ND2 ASN   343      26.457  59.458  14.947  1.00 32.48           N  
ATOM   5248  C   ASN   343      29.105  59.754  18.899  1.00 33.59           C  
ATOM   5249  O   ASN   343      29.560  60.893  18.741  1.00 32.45           O  
ATOM   5251  N   PHE   344      29.719  58.765  19.524  1.00 33.32           N  
ATOM   5252  CA  PHE   344      31.056  58.908  20.121  1.00 32.41           C  
ATOM   5254  CB  PHE   344      30.983  59.487  21.533  1.00 32.28           C  
ATOM   5257  CG  PHE   344      30.158  58.676  22.482  1.00 31.36           C  
ATOM   5258  CD1 PHE   344      30.709  57.618  23.164  1.00 28.60           C  
ATOM   5260  CE1 PHE   344      29.959  56.883  24.052  1.00 36.81           C  
ATOM   5262  CZ  PHE   344      28.617  57.199  24.268  1.00 34.98           C  
ATOM   5264  CE2 PHE   344      28.054  58.255  23.591  1.00 36.26           C  
ATOM   5266  CD2 PHE   344      28.831  59.000  22.709  1.00 32.85           C  
ATOM   5268  C   PHE   344      31.844  57.601  20.182  1.00 31.33           C  
ATOM   5269  O   PHE   344      31.318  56.495  19.986  1.00 31.72           O  
ATOM   5271  N   GLU   345      33.118  57.761  20.490  1.00 29.25           N  
ATOM   5272  CA  GLU   345      34.039  56.646  20.578  1.00 30.15           C  
ATOM   5274  CB  GLU   345      35.228  56.845  19.650  1.00 31.69           C  
ATOM   5277  CG  GLU   345      36.412  55.964  20.010  1.00 40.56           C  
ATOM   5280  CD  GLU   345      37.522  55.989  18.966  1.00 44.99           C  
ATOM   5281  OE1 GLU   345      37.310  56.578  17.894  1.00 51.59           O  
ATOM   5282  OE2 GLU   345      38.607  55.406  19.204  1.00 46.36           O  
ATOM   5283  C   GLU   345      34.531  56.528  21.983  1.00 30.61           C  
ATOM   5284  O   GLU   345      34.819  57.524  22.635  1.00 29.96           O  
ATOM   5286  N   VAL   346      34.584  55.293  22.462  1.00 31.47           N  
ATOM   5287  CA  VAL   346      35.090  55.031  23.802  1.00 30.35           C  
ATOM   5289  CB  VAL   346      34.385  53.902  24.482  1.00 29.36           C  
ATOM   5291  CG1 VAL   346      34.838  53.869  25.861  1.00 24.88           C  
ATOM   5295  CG2 VAL   346      32.873  54.135  24.437  1.00 22.65           C  
ATOM   5299  C   VAL   346      36.539  54.731  23.543  1.00 30.72           C  
ATOM   5300  O   VAL   346      36.911  53.612  23.244  1.00 32.57           O  
ATOM   5302  N   THR   347      37.345  55.778  23.645  1.00 30.04           N  
ATOM   5303  CA  THR   347      38.718  55.704  23.215  1.00 29.79           C  
ATOM   5305  CB  THR   347      39.399  57.111  23.144  1.00 31.11           C  
ATOM   5307  OG1 THR   347      39.351  57.720  24.423  1.00 29.12           O  
ATOM   5309  CG2 THR   347      38.709  58.019  22.111  1.00 20.80           C  
ATOM   5313  C   THR   347      39.572  54.751  24.023  1.00 31.03           C  
ATOM   5314  O   THR   347      40.536  54.266  23.480  1.00 29.43           O  
ATOM   5316  N   ASN   348      39.290  54.506  25.311  1.00 32.55           N  
ATOM   5317  CA  ASN   348      40.161  53.580  26.047  1.00 31.33           C  
ATOM   5319  CB  ASN   348      40.411  54.038  27.475  1.00 33.41           C  
ATOM   5322  CG  ASN   348      39.143  54.251  28.290  1.00 37.13           C  
ATOM   5323  OD1 ASN   348      38.152  54.770  27.788  1.00 27.91           O  
ATOM   5324  ND2 ASN   348      39.202  53.899  29.579  1.00 34.66           N  
ATOM   5327  C   ASN   348      39.671  52.099  25.930  1.00 31.23           C  
ATOM   5328  O   ASN   348      40.256  51.169  26.459  1.00 32.66           O  
ATOM   5330  N   PHE   349      38.624  51.900  25.152  1.00 30.07           N  
ATOM   5331  CA  PHE   349      38.074  50.561  24.928  1.00 27.95           C  
ATOM   5333  CB  PHE   349      36.572  50.568  25.055  1.00 29.04           C  
ATOM   5336  CG  PHE   349      36.063  50.311  26.472  1.00 27.21           C  
ATOM   5337  CD1 PHE   349      36.697  50.841  27.574  1.00 25.03           C  
ATOM   5339  CE1 PHE   349      36.209  50.630  28.848  1.00 27.62           C  
ATOM   5341  CZ  PHE   349      35.042  49.880  29.032  1.00 28.85           C  
ATOM   5343  CE2 PHE   349      34.388  49.375  27.962  1.00 26.28           C  
ATOM   5345  CD2 PHE   349      34.885  49.606  26.666  1.00 35.20           C  
ATOM   5347  C   PHE   349      38.512  50.154  23.543  1.00 31.20           C  
ATOM   5348  O   PHE   349      37.843  50.447  22.571  1.00 27.04           O  
ATOM   5350  N   ILE   350      39.640  49.439  23.491  0.60 33.91           N  
ATOM   5352  CA  ILE   350      40.307  49.060  22.217  0.60 36.10           C  
ATOM   5356  CB  ILE   350      41.850  48.950  22.371  0.60 35.46           C  
ATOM   5360  CG1 ILE   350      42.450  50.259  22.885  0.60 40.42           C  
ATOM   5366  CD1 ILE   350      42.104  50.574  24.294  0.60 42.79           C  
ATOM   5374  CG2 ILE   350      42.488  48.581  21.066  0.60 33.41           C  
ATOM   5382  C   ILE   350      39.788  47.757  21.666  0.60 34.46           C  
ATOM   5384  O   ILE   350      39.928  46.702  22.276  0.60 35.87           O  
ATOM   5388  N   VAL   351      39.160  47.874  20.507  1.00 32.86           N  
ATOM   5389  CA  VAL   351      38.558  46.741  19.833  1.00 30.73           C  
ATOM   5391  CB  VAL   351      37.153  47.078  19.312  1.00 33.01           C  
ATOM   5393  CG1 VAL   351      36.291  47.462  20.461  1.00 29.58           C  
ATOM   5397  CG2 VAL   351      37.174  48.196  18.243  1.00 26.98           C  
ATOM   5401  C   VAL   351      39.462  46.241  18.687  1.00 32.67           C  
ATOM   5402  O   VAL   351      39.304  45.124  18.163  1.00 32.78           O  
ATOM   5404  N   ALA   352      40.441  47.069  18.395  1.00 29.34           N  
ATOM   5405  CA  ALA   352      41.451  46.821  17.340  1.00 32.67           C  
ATOM   5407  CB  ALA   352      40.853  46.865  15.878  1.00 29.91           C  
ATOM   5411  C   ALA   352      42.549  47.850  17.502  1.00 32.80           C  
ATOM   5412  O   ALA   352      42.382  48.823  18.234  1.00 34.80           O  
ATOM   5414  N   PRO   353      43.707  47.604  16.880  1.00 34.03           N  
ATOM   5415  CA  PRO   353      44.789  48.551  16.976  1.00 34.51           C  
ATOM   5417  CB  PRO   353      45.816  47.944  16.016  1.00 34.20           C  
ATOM   5420  CG  PRO   353      45.597  46.489  16.114  1.00 32.06           C  
ATOM   5423  CD  PRO   353      44.096  46.430  16.077  1.00 33.29           C  
ATOM   5426  C   PRO   353      44.373  49.959  16.521  1.00 36.29           C  
ATOM   5427  O   PRO   353      43.920  50.154  15.395  1.00 37.15           O  
ATOM   5428  N   ASP   354      44.540  50.910  17.420  1.00 35.22           N  
ATOM   5429  CA  ASP   354      44.199  52.306  17.177  1.00 36.32           C  
ATOM   5431  CB  ASP   354      45.013  52.889  16.008  1.00 36.07           C  
ATOM   5434  CG  ASP   354      46.504  52.685  16.176  1.00 42.23           C  
ATOM   5435  OD1 ASP   354      47.050  53.116  17.217  1.00 53.36           O  
ATOM   5436  OD2 ASP   354      47.128  52.093  15.260  1.00 48.92           O  
ATOM   5437  C   ASP   354      42.722  52.515  16.877  1.00 36.44           C  
ATOM   5438  O   ASP   354      42.358  53.505  16.252  1.00 39.73           O  
ATOM   5440  N   LYS   355      41.888  51.555  17.242  1.00 34.06           N  
ATOM   5441  CA  LYS   355      40.427  51.707  17.090  1.00 34.94           C  
ATOM   5443  CB  LYS   355      39.863  50.719  16.059  1.00 37.23           C  
ATOM   5446  CG  LYS   355      40.130  51.142  14.617  1.00 44.35           C  
ATOM   5449  CD  LYS   355      39.752  50.082  13.538  1.00 54.88           C  
ATOM   5452  CE  LYS   355      38.235  49.680  13.413  1.00 60.13           C  
ATOM   5455  NZ  LYS   355      37.714  48.554  14.306  1.00 64.82           N  
ATOM   5459  C   LYS   355      39.734  51.531  18.414  1.00 34.19           C  
ATOM   5460  O   LYS   355      39.906  50.530  19.081  1.00 35.71           O  
ATOM   5462  N   GLY   356      38.949  52.525  18.796  1.00 34.87           N  
ATOM   5463  CA  GLY   356      38.130  52.488  20.045  1.00 31.43           C  
ATOM   5466  C   GLY   356      36.705  52.049  19.717  1.00 32.10           C  
ATOM   5467  O   GLY   356      36.302  52.066  18.549  1.00 31.40           O  
ATOM   5469  N   LEU   357      35.963  51.617  20.742  1.00 27.91           N  
ATOM   5470  CA  LEU   357      34.538  51.222  20.599  1.00 30.37           C  
ATOM   5472  CB  LEU   357      33.988  50.733  21.933  1.00 29.58           C  
ATOM   5475  CG  LEU   357      32.525  50.373  22.019  1.00 33.52           C  
ATOM   5477  CD1 LEU   357      32.275  49.121  21.129  1.00 21.58           C  
ATOM   5481  CD2 LEU   357      32.143  50.136  23.459  1.00 26.09           C  
ATOM   5485  C   LEU   357      33.694  52.395  20.143  1.00 31.87           C  
ATOM   5486  O   LEU   357      33.797  53.474  20.676  1.00 28.90           O  
ATOM   5488  N   LYS   358      32.917  52.184  19.103  1.00 32.88           N  
ATOM   5489  CA  LYS   358      32.015  53.194  18.599  1.00 33.34           C  
ATOM   5491  CB  LYS   358      31.818  53.097  17.078  1.00 35.17           C  
ATOM   5494  CG  LYS   358      33.110  53.260  16.287  1.00 38.84           C  
ATOM   5497  CD  LYS   358      33.830  54.569  16.686  1.00 53.18           C  
ATOM   5500  CE  LYS   358      35.307  54.635  16.197  1.00 57.07           C  
ATOM   5503  NZ  LYS   358      36.198  53.538  16.796  1.00 54.27           N  
ATOM   5507  C   LYS   358      30.692  52.980  19.283  1.00 32.29           C  
ATOM   5508  O   LYS   358      30.252  51.851  19.461  1.00 35.01           O  
ATOM   5510  N   TYR   359      30.024  54.060  19.634  1.00 29.37           N  
ATOM   5511  CA  TYR   359      28.777  53.925  20.364  1.00 31.29           C  
ATOM   5513  CB  TYR   359      29.062  53.933  21.872  1.00 30.44           C  
ATOM   5516  CG  TYR   359      28.057  53.207  22.752  1.00 33.80           C  
ATOM   5517  CD1 TYR   359      28.200  51.838  23.020  1.00 40.19           C  
ATOM   5519  CE1 TYR   359      27.301  51.156  23.819  1.00 44.66           C  
ATOM   5521  CZ  TYR   359      26.228  51.836  24.376  1.00 53.90           C  
ATOM   5522  OH  TYR   359      25.323  51.148  25.179  1.00 58.98           O  
ATOM   5524  CE2 TYR   359      26.058  53.192  24.132  1.00 44.61           C  
ATOM   5526  CD2 TYR   359      26.977  53.870  23.312  1.00 42.10           C  
ATOM   5528  C   TYR   359      27.866  55.054  19.999  1.00 33.01           C  
ATOM   5529  O   TYR   359      28.321  56.116  19.598  1.00 38.11           O  
ATOM   5531  N   THR   360      26.579  54.785  20.111  1.00 33.46           N  
ATOM   5532  CA  THR   360      25.526  55.762  19.870  1.00 34.63           C  
ATOM   5534  CB  THR   360      24.783  55.467  18.562  1.00 34.09           C  
ATOM   5536  OG1 THR   360      25.694  55.597  17.474  1.00 31.44           O  
ATOM   5538  CG2 THR   360      23.640  56.435  18.333  1.00 35.03           C  
ATOM   5542  C   THR   360      24.513  55.776  20.984  1.00 37.43           C  
ATOM   5543  O   THR   360      24.214  54.760  21.585  1.00 38.06           O  
ATOM   5545  N   ILE   361      24.077  56.977  21.313  1.00 40.00           N  
ATOM   5546  CA  ILE   361      22.949  57.182  22.213  1.00 39.09           C  
ATOM   5548  CB  ILE   361      23.261  58.082  23.429  1.00 38.60           C  
ATOM   5550  CG1 ILE   361      24.133  57.352  24.444  1.00 38.39           C  
ATOM   5553  CD1 ILE   361      24.704  58.289  25.552  1.00 35.29           C  
ATOM   5557  CG2 ILE   361      22.007  58.486  24.127  1.00 36.08           C  
ATOM   5561  C   ILE   361      21.945  57.835  21.283  1.00 39.27           C  
ATOM   5562  O   ILE   361      22.180  58.945  20.807  1.00 37.78           O  
ATOM   5564  N   SER   362      20.867  57.118  20.970  1.00 40.56           N  
ATOM   5565  CA  SER   362      19.787  57.639  20.090  1.00 42.38           C  
ATOM   5567  CB  SER   362      19.138  56.523  19.278  1.00 41.79           C  
ATOM   5570  OG  SER   362      20.117  55.932  18.450  1.00 50.38           O  
ATOM   5572  C   SER   362      18.735  58.361  20.893  1.00 42.19           C  
ATOM   5573  O   SER   362      18.121  57.815  21.810  1.00 40.71           O  
ATOM   5575  N   LEU   363      18.568  59.621  20.535  1.00 43.83           N  
ATOM   5576  CA  LEU   363      17.639  60.523  21.211  1.00 43.43           C  
ATOM   5578  CB  LEU   363      18.350  61.819  21.595  1.00 42.93           C  
ATOM   5581  CG  LEU   363      19.318  61.691  22.757  1.00 44.55           C  
ATOM   5583  CD1 LEU   363      19.752  63.075  23.237  1.00 51.11           C  
ATOM   5587  CD2 LEU   363      18.652  60.886  23.891  1.00 40.89           C  
ATOM   5591  C   LEU   363      16.431  60.867  20.360  1.00 45.12           C  
ATOM   5592  O   LEU   363      16.364  60.632  19.139  1.00 43.82           O  
ATOM   5594  OXT LEU   363      15.497  61.441  20.925  1.00 48.03           O  
END
