
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  710),  selected   90 , name 3ce8_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 3ce8_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    X     1_A      K       3          6.636
LGA    S     2_A      R       4          1.027
LGA    T     3_A      -       -           -
LGA    E     4_A      A       5          1.422
LGA    Q     5_A      N       6          1.095
LGA    L     6_A      K       7          0.628
LGA    L     7_A      L       8          0.927
LGA    V     8_A      V       9          1.128
LGA    L     9_A      I      10          1.247
LGA    I    10_A      V      11          0.963
LGA    A    11_A      T      12          0.911
LGA    Q    12_A      E      13          0.426
LGA    N    13_A      K      14          1.348
LGA    D    14_A      V      15          1.600
LGA    I    15_A      L      16          1.549
LGA    K    16_A      L      17          1.694
LGA    D    17_A      K      18          1.605
LGA    D    18_A      K      19          1.172
LGA    I    19_A      V      20          0.690
LGA    V    20_A      A      21          1.327
LGA    D    21_A      K      22          1.682
LGA    T    22_A      I      23          1.272
LGA    L    23_A      I      24          1.481
LGA    I    24_A      E      25          1.827
LGA    E    25_A      E      26          1.190
LGA    L    26_A      A      27          1.452
LGA    E    27_A      G      28          1.833
LGA    F    28_A      -       -           -
LGA    L    29_A      A      29          0.821
LGA    S    30_A      T      30          0.231
LGA    G    31_A      G      31          0.894
LGA    F    32_A      Y      32          0.638
LGA    S    33_A      T      33          1.089
LGA    L    34_A      V      34          0.356
LGA    G    35_A      V      35          0.718
LGA    N    36_A      D      36          0.574
LGA    I    37_A      T      37          1.122
LGA    C    38_A      G      38          1.280
LGA    G    39_A      G      39          1.391
LGA    F    40_A      -       -           -
LGA    S    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    E    54_A      -       -           -
LGA    G    55_A      -       -           -
LGA    Y    56_A      -       -           -
LGA    R    57_A      -       -           -
LGA    E    58_A      S      58          2.047
LGA    F    59_A      N      59          0.824
LGA    C    60_A      V      60          0.512
LGA    K    61_A      K      61          0.828
LGA    F    62_A      F      62          0.657
LGA    E    63_A      E      63          0.603
LGA    I    64_A      V      64          0.940
LGA    X    65_A      L      65          1.039
LGA    H    66_A      T      66          0.463
LGA    P    67_A      E      67          2.485
LGA    A    68_A      N      68          3.152
LGA    -       -      R      69           -
LGA    A    69_A      E      70          3.292
LGA    Q    70_A      M      71          2.051
LGA    Q    71_A      A      72          2.501
LGA    A    72_A      E      73          2.143
LGA    A    73_A      K      74          1.311
LGA    L    74_A      I      75          1.728
LGA    L    75_A      A      76          1.266
LGA    T    76_A      D      77          1.159
LGA    A    77_A      Q      78          1.517
LGA    L    78_A      V      79          1.427
LGA    A    79_A      A      80          1.509
LGA    L    80_A      I      81          3.086
LGA    V    81_A      K      82          3.271
LGA    C    82_A      F      83          1.609
LGA    -       -      F      84           -
LGA    K    83_A      T      85          3.713
LGA    H    84_A      D      86          1.303
LGA    N    85_A      Y      87          0.848
LGA    P    86_A      A      88          2.867
LGA    C    87_A      G      89          1.157
LGA    R    88_A      I      90          1.129
LGA    Y    89_A      I      91          2.168
LGA    W    90_A      Y      92          1.890
LGA    I    91_A      I      93          0.880
LGA    X    92_A      C      94          0.756
LGA    P    93_A      E      95          0.716
LGA    I    94_A      A      96          0.954
LGA    Y    95_A      E      97          1.340
LGA    Q    96_A      V      98          1.804
LGA    N    97_A      L      99          3.940
LGA    G    98_A      Y     100          2.784
LGA    T    99_A      G     101          2.509
LGA    L   100_A      -       -           -
LGA    S   101_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90   83    5.0     79    1.80    12.66     86.726     4.154

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.656654 * X  +  -0.747092 * Y  +   0.103246 * Z  + -69.927132
  Y_new =   0.750860 * X  +   0.660452 * Y  +   0.003519 * Z  + -11.149175
  Z_new =  -0.070818 * X  +   0.075212 * Y  +   0.994650 * Z  + -70.060638 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.075473   -3.066119  [ DEG:     4.3243   -175.6757 ]
  Theta =   0.070878    3.070715  [ DEG:     4.0610    175.9390 ]
  Phi   =   0.852230   -2.289363  [ DEG:    48.8292   -131.1708 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3ce8_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3ce8_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90   83   5.0   79   1.80   12.66  86.726
REMARK  ---------------------------------------------------------- 
MOLECULE 3ce8_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-FEB-08   3CE8              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE PII-LIKE NITROGEN REGULATORY            
TITLE    2 PROTEIN (YP_001048502.1) FROM SHEWANELLA BALTICA OS155 AT            
TITLE    3 2.40 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PII-LIKE NITROGEN REGULATORY PROTEIN;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHEWANELLA BALTICA OS155;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: OS155;                                                       
SOURCE   5 ATCC: BAA-1091;                                                      
SOURCE   6 GENE: YP_001048502.1, SBAL_0098;                                     
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_001048502.1, PUTATIVE PII-LIKE NITROGEN REGULATORY                 
KEYWDS   2 PROTEIN, STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL            
KEYWDS   3 GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2,                 
KEYWDS   4 STRUCTURAL GENOMICS, UNKNOWN FUNCTION                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   11-MAR-08 3CE8    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE PII-LIKE NITROGEN              
JRNL        TITL 2 REGULATORY PROTEIN (YP_001048502.1) FROM                     
JRNL        TITL 3 SHEWANELLA BALTICA OS155 AT 2.40 A RESOLUTION                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  3CE8 A    1   101  UNP    A3CYS0   A3CYS0_SHEB5     1    101             
SEQRES   1 A  120  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  120  ASN LEU TYR PHE GLN GLY MSE SER THR GLU GLN LEU LEU          
SEQRES   3 A  120  VAL LEU ILE ALA GLN ASN ASP ILE LYS ASP ASP ILE VAL          
SEQRES   4 A  120  ASP THR LEU ILE GLU LEU GLU PHE LEU SER GLY PHE SER          
SEQRES   5 A  120  LEU GLY ASN ILE CYS GLY PHE SER ARG GLU HIS SER HIS          
SEQRES   6 A  120  PHE ASN ILE LYS GLU GLN VAL GLU GLY TYR ARG GLU PHE          
SEQRES   7 A  120  CYS LYS PHE GLU ILE MSE HIS PRO ALA ALA GLN GLN ALA          
SEQRES   8 A  120  ALA LEU LEU THR ALA LEU ALA LEU VAL CYS LYS HIS ASN          
SEQRES   9 A  120  PRO CYS ARG TYR TRP ILE MSE PRO ILE TYR GLN ASN GLY          
SEQRES  10 A  120  THR LEU SER                                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  65      13                                                       
HET    MSE  A  92       8                                                       
HET    PO4  A 102       5                                                       
HET    PO4  A 103       5                                                       
HET    EDO  A 104       4                                                       
HET    EDO  A 105       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     PO4 PHOSPHATE ION                                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  PO4    2(O4 P 3-)                                                   
FORMUL   4  EDO    2(C2 H6 O2)                                                  
FORMUL   6  HOH   *9(H2 O)                                                      
CRYST1   71.285   71.285   71.285  90.00  90.00  90.00 P 21 3       12          
HETATM    1  N   MSE A   1     -44.662   8.996  -3.018  1.00 51.33           N  
HETATM    2  CA  MSE A   1     -45.353   9.043  -4.355  1.00 51.93           C  
HETATM    3  C   MSE A   1     -45.301   7.685  -5.108  1.00 52.06           C  
HETATM    4  O   MSE A   1     -44.718   6.711  -4.609  1.00 55.25           O  
HETATM    5  CB  MSE A   1     -44.793  10.179  -5.236  1.00 52.30           C  
HETATM    6  CG  MSE A   1     -45.814  10.741  -6.253  1.00 51.24           C  
HETATM    7 SE   MSE A   1     -47.310  11.876  -5.470  0.75 55.28          SE  
HETATM    8  CE  MSE A   1     -46.332  13.543  -4.984  1.00 57.44           C  
ATOM      9  N   SER A   2     -45.874   7.657  -6.319  1.00 49.24           N  
ATOM     10  CA  SER A   2     -46.064   6.395  -7.136  1.00 46.01           C  
ATOM     11  C   SER A   2     -45.346   6.270  -8.512  1.00 44.11           C  
ATOM     12  O   SER A   2     -45.008   7.267  -9.201  1.00 45.46           O  
ATOM     13  CB  SER A   2     -47.585   6.179  -7.343  1.00 45.58           C  
ATOM     14  OG  SER A   2     -47.940   4.886  -7.814  1.00 38.84           O  
ATOM     15  N   THR A   3     -45.108   5.012  -8.885  1.00 39.67           N  
ATOM     16  CA  THR A   3     -44.506   4.680 -10.182  1.00 35.47           C  
ATOM     17  C   THR A   3     -45.619   4.681 -11.243  1.00 31.17           C  
ATOM     18  O   THR A   3     -45.354   4.614 -12.430  1.00 28.42           O  
ATOM     19  CB  THR A   3     -43.800   3.334 -10.166  1.00 35.58           C  
ATOM     20  OG1 THR A   3     -44.740   2.321  -9.775  1.00 34.45           O  
ATOM     21  CG2 THR A   3     -42.577   3.370  -9.212  1.00 37.20           C  
ATOM     22  N   GLU A   4     -46.861   4.758 -10.766  1.00 28.57           N  
ATOM     23  CA  GLU A   4     -48.063   4.901 -11.634  1.00 27.49           C  
ATOM     24  C   GLU A   4     -48.385   6.363 -11.743  1.00 25.72           C  
ATOM     25  O   GLU A   4     -48.259   7.145 -10.792  1.00 26.06           O  
ATOM     26  CB  GLU A   4     -49.321   4.194 -11.120  1.00 27.13           C  
ATOM     27  CG  GLU A   4     -49.261   2.685 -11.180  1.00 32.02           C  
ATOM     28  CD  GLU A   4     -49.300   2.126 -12.589  1.00 31.04           C  
ATOM     29  OE1 GLU A   4     -50.150   2.567 -13.390  1.00 37.88           O  
ATOM     30  OE2 GLU A   4     -48.502   1.212 -12.877  1.00 35.24           O  
ATOM     31  N   GLN A   5     -48.796   6.731 -12.934  1.00 23.64           N  
ATOM     32  CA  GLN A   5     -49.161   8.109 -13.197  1.00 23.08           C  
ATOM     33  C   GLN A   5     -50.291   8.125 -14.221  1.00 21.99           C  
ATOM     34  O   GLN A   5     -50.505   7.154 -14.926  1.00 21.08           O  
ATOM     35  CB  GLN A   5     -47.933   8.906 -13.630  1.00 23.65           C  
ATOM     36  CG  GLN A   5     -47.245   8.344 -14.831  1.00 26.80           C  
ATOM     37  CD  GLN A   5     -46.015   9.141 -15.229  1.00 31.01           C  
ATOM     38  OE1 GLN A   5     -45.339   9.730 -14.368  1.00 21.90           O  
ATOM     39  NE2 GLN A   5     -45.706   9.151 -16.558  1.00 26.52           N  
ATOM     40  N   LEU A   6     -51.032   9.217 -14.245  1.00 20.78           N  
ATOM     41  CA  LEU A   6     -52.197   9.343 -15.110  1.00 21.00           C  
ATOM     42  C   LEU A   6     -51.960  10.235 -16.323  1.00 20.45           C  
ATOM     43  O   LEU A   6     -51.615  11.378 -16.176  1.00 24.40           O  
ATOM     44  CB  LEU A   6     -53.366   9.913 -14.275  1.00 21.16           C  
ATOM     45  CG  LEU A   6     -54.754   9.915 -14.900  1.00 18.98           C  
ATOM     46  CD1 LEU A   6     -55.211   8.464 -15.035  1.00 15.42           C  
ATOM     47  CD2 LEU A   6     -55.757  10.793 -14.091  1.00 16.88           C  
ATOM     48  N   LEU A   7     -52.112   9.698 -17.516  1.00 19.70           N  
ATOM     49  CA  LEU A   7     -52.048  10.534 -18.718  1.00 20.81           C  
ATOM     50  C   LEU A   7     -53.434  10.992 -19.057  1.00 20.97           C  
ATOM     51  O   LEU A   7     -54.357  10.190 -19.133  1.00 21.91           O  
ATOM     52  CB  LEU A   7     -51.493   9.777 -19.930  1.00 21.84           C  
ATOM     53  CG  LEU A   7     -51.550  10.496 -21.280  1.00 21.42           C  
ATOM     54  CD1 LEU A   7     -50.629  11.713 -21.346  1.00 15.43           C  
ATOM     55  CD2 LEU A   7     -51.136   9.472 -22.298  1.00 21.64           C  
ATOM     56  N   VAL A   8     -53.577  12.300 -19.167  1.00 21.20           N  
ATOM     57  CA  VAL A   8     -54.847  12.915 -19.593  1.00 21.05           C  
ATOM     58  C   VAL A   8     -54.575  13.550 -20.933  1.00 21.63           C  
ATOM     59  O   VAL A   8     -53.618  14.316 -21.121  1.00 20.77           O  
ATOM     60  CB  VAL A   8     -55.393  13.987 -18.641  1.00 20.40           C  
ATOM     61  CG1 VAL A   8     -56.672  14.581 -19.241  1.00 13.26           C  
ATOM     62  CG2 VAL A   8     -55.633  13.382 -17.254  1.00 17.37           C  
ATOM     63  N   LEU A   9     -55.437  13.188 -21.862  1.00 22.92           N  
ATOM     64  CA  LEU A   9     -55.302  13.545 -23.289  1.00 22.32           C  
ATOM     65  C   LEU A   9     -56.616  14.073 -23.840  1.00 21.50           C  
ATOM     66  O   LEU A   9     -57.645  13.420 -23.715  1.00 21.57           O  
ATOM     67  CB  LEU A   9     -54.862  12.272 -24.036  1.00 21.68           C  
ATOM     68  CG  LEU A   9     -54.787  12.275 -25.555  1.00 27.92           C  
ATOM     69  CD1 LEU A   9     -53.676  13.186 -26.079  1.00 31.88           C  
ATOM     70  CD2 LEU A   9     -54.572  10.841 -25.995  1.00 29.61           C  
ATOM     71  N   ILE A  10     -56.573  15.287 -24.388  1.00 21.15           N  
ATOM     72  CA  ILE A  10     -57.759  15.941 -24.964  1.00 20.87           C  
ATOM     73  C   ILE A  10     -57.653  15.812 -26.472  1.00 22.33           C  
ATOM     74  O   ILE A  10     -56.957  16.578 -27.131  1.00 22.99           O  
ATOM     75  CB  ILE A  10     -57.888  17.423 -24.533  1.00 20.96           C  
ATOM     76  CG1 ILE A  10     -57.814  17.529 -23.007  1.00 21.08           C  
ATOM     77  CG2 ILE A  10     -59.171  18.032 -25.029  1.00 13.39           C  
ATOM     78  CD1 ILE A  10     -58.714  16.548 -22.310  1.00 25.23           C  
ATOM     79  N   ALA A  11     -58.378  14.816 -26.974  1.00 22.95           N  
ATOM     80  CA  ALA A  11     -58.374  14.379 -28.364  1.00 22.46           C  
ATOM     81  C   ALA A  11     -59.589  14.816 -29.127  1.00 25.35           C  
ATOM     82  O   ALA A  11     -60.714  14.895 -28.624  1.00 27.79           O  
ATOM     83  CB  ALA A  11     -58.265  12.855 -28.422  1.00 21.03           C  
ATOM     84  N   GLN A  12     -59.356  15.049 -30.398  1.00 26.49           N  
ATOM     85  CA  GLN A  12     -60.436  15.480 -31.282  1.00 27.83           C  
ATOM     86  C   GLN A  12     -61.268  14.254 -31.567  1.00 26.39           C  
ATOM     87  O   GLN A  12     -60.769  13.148 -31.561  1.00 25.71           O  
ATOM     88  CB  GLN A  12     -59.872  16.120 -32.542  1.00 28.93           C  
ATOM     89  CG  GLN A  12     -58.609  16.946 -32.238  1.00 36.75           C  
ATOM     90  CD  GLN A  12     -58.270  17.914 -33.330  1.00 45.08           C  
ATOM     91  OE1 GLN A  12     -59.144  18.639 -33.814  1.00 45.13           O  
ATOM     92  NE2 GLN A  12     -56.987  17.967 -33.708  1.00 49.93           N  
ATOM     93  N   ASN A  13     -62.554  14.464 -31.766  1.00 27.41           N  
ATOM     94  CA  ASN A  13     -63.503  13.348 -31.938  1.00 28.70           C  
ATOM     95  C   ASN A  13     -63.210  12.418 -33.103  1.00 28.33           C  
ATOM     96  O   ASN A  13     -63.569  11.247 -33.062  1.00 28.66           O  
ATOM     97  CB  ASN A  13     -64.964  13.837 -31.986  1.00 29.81           C  
ATOM     98  CG  ASN A  13     -65.485  14.264 -30.597  1.00 34.49           C  
ATOM     99  OD1 ASN A  13     -65.034  13.763 -29.556  1.00 39.27           O  
ATOM    100  ND2 ASN A  13     -66.452  15.175 -30.585  1.00 40.13           N  
ATOM    101  N   ASP A  14     -62.501  12.922 -34.102  1.00 27.64           N  
ATOM    102  CA  ASP A  14     -62.199  12.126 -35.307  1.00 27.42           C  
ATOM    103  C   ASP A  14     -61.082  11.070 -35.132  1.00 26.54           C  
ATOM    104  O   ASP A  14     -61.109  10.013 -35.777  1.00 26.50           O  
ATOM    105  CB  ASP A  14     -61.973  13.016 -36.547  1.00 27.76           C  
ATOM    106  CG  ASP A  14     -60.840  14.005 -36.378  1.00 30.55           C  
ATOM    107  OD1 ASP A  14     -60.056  13.866 -35.412  1.00 37.11           O  
ATOM    108  OD2 ASP A  14     -60.735  14.922 -37.223  1.00 31.60           O  
ATOM    109  N   ILE A  15     -60.135  11.332 -34.242  1.00 25.17           N  
ATOM    110  CA  ILE A  15     -59.015  10.377 -34.021  1.00 24.05           C  
ATOM    111  C   ILE A  15     -59.279   9.535 -32.789  1.00 23.25           C  
ATOM    112  O   ILE A  15     -58.417   8.798 -32.320  1.00 22.99           O  
ATOM    113  CB  ILE A  15     -57.608  11.032 -33.885  1.00 23.67           C  
ATOM    114  CG1 ILE A  15     -57.589  12.041 -32.729  1.00 24.42           C  
ATOM    115  CG2 ILE A  15     -57.176  11.642 -35.189  1.00 22.44           C  
ATOM    116  CD1 ILE A  15     -56.192  12.535 -32.330  1.00 23.67           C  
ATOM    117  N   LYS A  16     -60.505   9.647 -32.307  1.00 23.76           N  
ATOM    118  CA  LYS A  16     -60.969   8.947 -31.090  1.00 24.92           C  
ATOM    119  C   LYS A  16     -60.785   7.423 -31.173  1.00 24.97           C  
ATOM    120  O   LYS A  16     -60.230   6.776 -30.269  1.00 24.29           O  
ATOM    121  CB  LYS A  16     -62.448   9.319 -30.803  1.00 26.32           C  
ATOM    122  CG  LYS A  16     -63.155   8.487 -29.713  1.00 30.48           C  
ATOM    123  CD  LYS A  16     -64.458   9.147 -29.160  1.00 33.16           C  
ATOM    124  CE  LYS A  16     -65.620   9.191 -30.155  1.00 34.65           C  
ATOM    125  NZ  LYS A  16     -66.810   9.914 -29.595  1.00 33.88           N  
ATOM    126  N   ASP A  17     -61.205   6.874 -32.301  1.00 25.20           N  
ATOM    127  CA  ASP A  17     -61.166   5.424 -32.516  1.00 26.26           C  
ATOM    128  C   ASP A  17     -59.740   4.958 -32.705  1.00 26.09           C  
ATOM    129  O   ASP A  17     -59.353   3.879 -32.263  1.00 26.81           O  
ATOM    130  CB  ASP A  17     -61.974   5.007 -33.748  1.00 27.09           C  
ATOM    131  CG  ASP A  17     -63.455   5.355 -33.642  1.00 32.70           C  
ATOM    132  OD1 ASP A  17     -63.784   6.316 -32.916  1.00 35.92           O  
ATOM    133  OD2 ASP A  17     -64.286   4.679 -34.317  1.00 43.78           O  
ATOM    134  N   ASP A  18     -58.964   5.806 -33.359  1.00 25.15           N  
ATOM    135  CA  ASP A  18     -57.565   5.497 -33.677  1.00 23.97           C  
ATOM    136  C   ASP A  18     -56.787   5.456 -32.372  1.00 23.15           C  
ATOM    137  O   ASP A  18     -55.860   4.664 -32.198  1.00 23.49           O  
ATOM    138  CB  ASP A  18     -56.973   6.536 -34.632  1.00 24.14           C  
ATOM    139  CG  ASP A  18     -57.680   6.556 -35.977  1.00 25.98           C  
ATOM    140  OD1 ASP A  18     -57.779   5.488 -36.612  1.00 33.70           O  
ATOM    141  OD2 ASP A  18     -58.150   7.631 -36.400  1.00 28.21           O  
ATOM    142  N   ILE A  19     -57.212   6.293 -31.438  1.00 21.37           N  
ATOM    143  CA  ILE A  19     -56.541   6.352 -30.155  1.00 20.89           C  
ATOM    144  C   ILE A  19     -56.909   5.097 -29.367  1.00 21.45           C  
ATOM    145  O   ILE A  19     -56.078   4.482 -28.702  1.00 23.67           O  
ATOM    146  CB  ILE A  19     -56.883   7.606 -29.334  1.00 20.62           C  
ATOM    147  CG1 ILE A  19     -56.204   8.841 -29.916  1.00 22.06           C  
ATOM    148  CG2 ILE A  19     -56.393   7.460 -27.884  1.00 19.22           C  
ATOM    149  CD1 ILE A  19     -56.507  10.125 -29.156  1.00 16.27           C  
ATOM    150  N   VAL A  20     -58.168   4.715 -29.455  1.00 20.55           N  
ATOM    151  CA  VAL A  20     -58.650   3.550 -28.711  1.00 19.34           C  
ATOM    152  C   VAL A  20     -57.896   2.327 -29.197  1.00 20.82           C  
ATOM    153  O   VAL A  20     -57.473   1.483 -28.419  1.00 22.17           O  
ATOM    154  CB  VAL A  20     -60.178   3.385 -28.866  1.00 19.15           C  
ATOM    155  CG1 VAL A  20     -60.657   1.948 -28.505  1.00 15.69           C  
ATOM    156  CG2 VAL A  20     -60.868   4.442 -28.037  1.00 15.48           C  
ATOM    157  N   ASP A  21     -57.679   2.297 -30.497  1.00 20.69           N  
ATOM    158  CA  ASP A  21     -57.021   1.176 -31.148  1.00 21.26           C  
ATOM    159  C   ASP A  21     -55.596   1.029 -30.701  1.00 21.51           C  
ATOM    160  O   ASP A  21     -55.077  -0.072 -30.553  1.00 22.86           O  
ATOM    161  CB  ASP A  21     -57.032   1.341 -32.669  1.00 22.45           C  
ATOM    162  CG  ASP A  21     -58.409   1.067 -33.285  1.00 26.41           C  
ATOM    163  OD1 ASP A  21     -59.298   0.542 -32.583  1.00 29.00           O  
ATOM    164  OD2 ASP A  21     -58.597   1.366 -34.480  1.00 26.45           O  
ATOM    165  N   THR A  22     -54.970   2.162 -30.454  1.00 21.85           N  
ATOM    166  CA  THR A  22     -53.563   2.178 -30.070  1.00 20.77           C  
ATOM    167  C   THR A  22     -53.420   1.667 -28.663  1.00 21.54           C  
ATOM    168  O   THR A  22     -52.555   0.846 -28.362  1.00 22.29           O  
ATOM    169  CB  THR A  22     -52.991   3.585 -30.109  1.00 19.88           C  
ATOM    170  OG1 THR A  22     -52.844   3.986 -31.472  1.00 26.63           O  
ATOM    171  CG2 THR A  22     -51.637   3.643 -29.416  1.00 18.14           C  
ATOM    172  N   LEU A  23     -54.338   2.129 -27.823  1.00 21.00           N  
ATOM    173  CA  LEU A  23     -54.275   1.878 -26.394  1.00 20.64           C  
ATOM    174  C   LEU A  23     -54.527   0.433 -26.099  1.00 22.15           C  
ATOM    175  O   LEU A  23     -53.845  -0.166 -25.266  1.00 21.66           O  
ATOM    176  CB  LEU A  23     -55.289   2.746 -25.631  1.00 20.22           C  
ATOM    177  CG  LEU A  23     -55.042   4.251 -25.697  1.00 17.05           C  
ATOM    178  CD1 LEU A  23     -56.209   5.047 -25.183  1.00 18.42           C  
ATOM    179  CD2 LEU A  23     -53.748   4.578 -24.928  1.00 15.10           C  
ATOM    180  N   ILE A  24     -55.501  -0.135 -26.806  1.00 24.90           N  
ATOM    181  CA  ILE A  24     -55.925  -1.530 -26.532  1.00 25.72           C  
ATOM    182  C   ILE A  24     -54.802  -2.481 -26.872  1.00 25.97           C  
ATOM    183  O   ILE A  24     -54.787  -3.631 -26.418  1.00 27.38           O  
ATOM    184  CB  ILE A  24     -57.240  -2.013 -27.276  1.00 26.26           C  
ATOM    185  CG1 ILE A  24     -57.065  -1.931 -28.787  1.00 27.69           C  
ATOM    186  CG2 ILE A  24     -58.486  -1.251 -26.820  1.00 23.83           C  
ATOM    187  CD1 ILE A  24     -58.173  -2.591 -29.545  1.00 29.37           C  
ATOM    188  N   GLU A  25     -53.829  -1.971 -27.609  1.00 24.29           N  
ATOM    189  CA  GLU A  25     -52.763  -2.826 -28.127  1.00 24.22           C  
ATOM    190  C   GLU A  25     -51.509  -2.773 -27.250  1.00 22.53           C  
ATOM    191  O   GLU A  25     -50.587  -3.574 -27.359  1.00 21.18           O  
ATOM    192  CB  GLU A  25     -52.470  -2.405 -29.561  1.00 25.22           C  
ATOM    193  CG  GLU A  25     -52.144  -3.555 -30.412  1.00 34.62           C  
ATOM    194  CD  GLU A  25     -53.295  -4.581 -30.417  1.00 43.12           C  
ATOM    195  OE1 GLU A  25     -54.427  -4.213 -30.826  1.00 48.00           O  
ATOM    196  OE2 GLU A  25     -53.069  -5.755 -30.016  1.00 47.41           O  
ATOM    197  N   LEU A  26     -51.513  -1.804 -26.360  1.00 22.11           N  
ATOM    198  CA  LEU A  26     -50.407  -1.576 -25.429  1.00 22.05           C  
ATOM    199  C   LEU A  26     -50.580  -2.482 -24.191  1.00 24.17           C  
ATOM    200  O   LEU A  26     -51.510  -2.306 -23.379  1.00 26.93           O  
ATOM    201  CB  LEU A  26     -50.302  -0.089 -25.065  1.00 20.36           C  
ATOM    202  CG  LEU A  26     -49.881   0.857 -26.209  1.00 19.55           C  
ATOM    203  CD1 LEU A  26     -49.993   2.347 -25.839  1.00 12.85           C  
ATOM    204  CD2 LEU A  26     -48.458   0.527 -26.700  1.00 12.91           C  
ATOM    205  N   GLU A  27     -49.673  -3.461 -24.090  1.00 24.95           N  
ATOM    206  CA  GLU A  27     -49.654  -4.501 -23.008  1.00 25.57           C  
ATOM    207  C   GLU A  27     -49.445  -4.031 -21.588  1.00 25.08           C  
ATOM    208  O   GLU A  27     -49.771  -4.714 -20.634  1.00 25.99           O  
ATOM    209  CB  GLU A  27     -48.595  -5.597 -23.254  1.00 25.35           C  
ATOM    210  CG  GLU A  27     -49.116  -6.767 -24.042  1.00 30.87           C  
ATOM    211  CD  GLU A  27     -48.027  -7.792 -24.323  1.00 39.76           C  
ATOM    212  OE1 GLU A  27     -46.838  -7.392 -24.451  1.00 45.73           O  
ATOM    213  OE2 GLU A  27     -48.360  -8.994 -24.451  1.00 43.00           O  
ATOM    214  N   PHE A  28     -48.872  -2.869 -21.451  1.00 25.49           N  
ATOM    215  CA  PHE A  28     -48.530  -2.365 -20.129  1.00 25.88           C  
ATOM    216  C   PHE A  28     -49.696  -1.599 -19.556  1.00 26.37           C  
ATOM    217  O   PHE A  28     -49.624  -1.132 -18.440  1.00 27.01           O  
ATOM    218  CB  PHE A  28     -47.235  -1.528 -20.152  1.00 26.23           C  
ATOM    219  CG  PHE A  28     -47.242  -0.392 -21.157  1.00 25.72           C  
ATOM    220  CD1 PHE A  28     -47.898   0.797 -20.879  1.00 23.70           C  
ATOM    221  CD2 PHE A  28     -46.577  -0.526 -22.375  1.00 25.91           C  
ATOM    222  CE1 PHE A  28     -47.903   1.822 -21.800  1.00 26.66           C  
ATOM    223  CE2 PHE A  28     -46.572   0.501 -23.301  1.00 25.59           C  
ATOM    224  CZ  PHE A  28     -47.239   1.674 -23.022  1.00 23.57           C  
ATOM    225  N   LEU A  29     -50.762  -1.491 -20.344  1.00 27.46           N  
ATOM    226  CA  LEU A  29     -52.014  -0.800 -19.929  1.00 28.53           C  
ATOM    227  C   LEU A  29     -53.062  -1.854 -19.502  1.00 31.25           C  
ATOM    228  O   LEU A  29     -53.294  -2.842 -20.203  1.00 31.76           O  
ATOM    229  CB  LEU A  29     -52.598   0.071 -21.044  1.00 27.22           C  
ATOM    230  CG  LEU A  29     -51.798   1.244 -21.609  1.00 27.82           C  
ATOM    231  CD1 LEU A  29     -52.610   1.922 -22.716  1.00 22.33           C  
ATOM    232  CD2 LEU A  29     -51.424   2.201 -20.524  1.00 20.28           C  
ATOM    233  N   SER A  30     -53.700  -1.624 -18.359  1.00 33.90           N  
ATOM    234  CA  SER A  30     -54.665  -2.599 -17.784  1.00 36.46           C  
ATOM    235  C   SER A  30     -56.097  -2.200 -18.107  1.00 36.32           C  
ATOM    236  O   SER A  30     -57.039  -2.981 -17.936  1.00 39.61           O  
ATOM    237  CB  SER A  30     -54.485  -2.714 -16.258  1.00 36.66           C  
ATOM    238  OG  SER A  30     -54.579  -1.414 -15.644  1.00 44.85           O  
ATOM    239  N   GLY A  31     -56.213  -0.990 -18.621  1.00 34.12           N  
ATOM    240  CA  GLY A  31     -57.492  -0.384 -18.975  1.00 31.84           C  
ATOM    241  C   GLY A  31     -57.343   1.126 -19.029  1.00 30.90           C  
ATOM    242  O   GLY A  31     -56.314   1.669 -18.648  1.00 30.55           O  
ATOM    243  N   PHE A  32     -58.363   1.786 -19.570  1.00 29.68           N  
ATOM    244  CA  PHE A  32     -58.440   3.280 -19.658  1.00 26.90           C  
ATOM    245  C   PHE A  32     -59.864   3.759 -19.685  1.00 25.35           C  
ATOM    246  O   PHE A  32     -60.787   2.976 -19.852  1.00 23.52           O  
ATOM    247  CB  PHE A  32     -57.712   3.854 -20.875  1.00 26.33           C  
ATOM    248  CG  PHE A  32     -58.203   3.316 -22.195  1.00 27.75           C  
ATOM    249  CD1 PHE A  32     -57.728   2.112 -22.688  1.00 25.90           C  
ATOM    250  CD2 PHE A  32     -59.145   4.015 -22.939  1.00 27.80           C  
ATOM    251  CE1 PHE A  32     -58.200   1.612 -23.881  1.00 27.22           C  
ATOM    252  CE2 PHE A  32     -59.615   3.516 -24.140  1.00 29.24           C  
ATOM    253  CZ  PHE A  32     -59.140   2.321 -24.614  1.00 27.88           C  
ATOM    254  N   SER A  33     -60.018   5.063 -19.529  1.00 24.60           N  
ATOM    255  CA  SER A  33     -61.352   5.653 -19.552  1.00 23.72           C  
ATOM    256  C   SER A  33     -61.425   6.803 -20.506  1.00 23.65           C  
ATOM    257  O   SER A  33     -60.432   7.415 -20.862  1.00 25.95           O  
ATOM    258  CB  SER A  33     -61.784   6.156 -18.178  1.00 23.59           C  
ATOM    259  OG  SER A  33     -61.366   7.494 -17.952  1.00 30.54           O  
ATOM    260  N   LEU A  34     -62.635   7.090 -20.930  1.00 23.81           N  
ATOM    261  CA  LEU A  34     -62.856   8.223 -21.829  1.00 24.10           C  
ATOM    262  C   LEU A  34     -64.213   8.861 -21.660  1.00 22.91           C  
ATOM    263  O   LEU A  34     -65.211   8.212 -21.453  1.00 21.66           O  
ATOM    264  CB  LEU A  34     -62.648   7.816 -23.280  1.00 25.01           C  
ATOM    265  CG  LEU A  34     -63.667   6.970 -23.985  1.00 24.49           C  
ATOM    266  CD1 LEU A  34     -64.731   7.906 -24.482  1.00 31.50           C  
ATOM    267  CD2 LEU A  34     -63.006   6.277 -25.150  1.00 30.27           C  
ATOM    268  N   GLY A  35     -64.198  10.173 -21.694  1.00 22.60           N  
ATOM    269  CA  GLY A  35     -65.417  10.937 -21.576  1.00 22.66           C  
ATOM    270  C   GLY A  35     -65.442  12.161 -22.456  1.00 23.23           C  
ATOM    271  O   GLY A  35     -64.418  12.650 -22.904  1.00 25.47           O  
ATOM    272  N   ASN A  36     -66.637  12.646 -22.698  1.00 23.23           N  
ATOM    273  CA  ASN A  36     -66.842  13.868 -23.473  1.00 24.01           C  
ATOM    274  C   ASN A  36     -66.648  15.115 -22.625  1.00 24.17           C  
ATOM    275  O   ASN A  36     -67.148  15.207 -21.516  1.00 24.91           O  
ATOM    276  CB  ASN A  36     -68.247  13.889 -24.096  1.00 23.59           C  
ATOM    277  CG  ASN A  36     -68.357  12.982 -25.323  1.00 26.88           C  
ATOM    278  OD1 ASN A  36     -67.355  12.689 -26.021  1.00 26.37           O  
ATOM    279  ND2 ASN A  36     -69.582  12.556 -25.612  1.00 28.06           N  
ATOM    280  N   ILE A  37     -65.869  16.052 -23.145  1.00 24.15           N  
ATOM    281  CA  ILE A  37     -65.707  17.377 -22.512  1.00 24.00           C  
ATOM    282  C   ILE A  37     -65.756  18.494 -23.565  1.00 23.98           C  
ATOM    283  O   ILE A  37     -65.543  18.289 -24.754  1.00 23.51           O  
ATOM    284  CB  ILE A  37     -64.433  17.538 -21.575  1.00 24.00           C  
ATOM    285  CG1 ILE A  37     -63.133  17.262 -22.336  1.00 26.43           C  
ATOM    286  CG2 ILE A  37     -64.556  16.707 -20.252  1.00 23.56           C  
ATOM    287  CD1 ILE A  37     -62.785  18.353 -23.294  1.00 25.74           C  
ATOM    288  N   CYS A  38     -66.098  19.675 -23.087  1.00 23.60           N  
ATOM    289  CA  CYS A  38     -66.098  20.875 -23.895  1.00 24.15           C  
ATOM    290  C   CYS A  38     -64.772  21.638 -23.684  1.00 25.03           C  
ATOM    291  O   CYS A  38     -64.350  21.885 -22.552  1.00 26.13           O  
ATOM    292  CB  CYS A  38     -67.276  21.713 -23.488  1.00 24.05           C  
ATOM    293  SG  CYS A  38     -67.569  22.909 -24.647  1.00 34.39           S  
ATOM    294  N   GLY A  39     -64.091  21.972 -24.771  1.00 24.80           N  
ATOM    295  CA  GLY A  39     -62.766  22.598 -24.681  1.00 24.01           C  
ATOM    296  C   GLY A  39     -62.584  23.911 -25.391  1.00 24.97           C  
ATOM    297  O   GLY A  39     -62.968  24.090 -26.543  1.00 25.45           O  
ATOM    298  N   PHE A  40     -61.997  24.848 -24.664  1.00 25.14           N  
ATOM    299  CA  PHE A  40     -61.662  26.157 -25.212  1.00 24.82           C  
ATOM    300  C   PHE A  40     -60.172  26.255 -25.475  1.00 27.22           C  
ATOM    301  O   PHE A  40     -59.345  25.446 -24.993  1.00 26.77           O  
ATOM    302  CB  PHE A  40     -62.092  27.286 -24.293  1.00 23.87           C  
ATOM    303  CG  PHE A  40     -63.578  27.378 -24.102  1.00 19.56           C  
ATOM    304  CD1 PHE A  40     -64.271  26.403 -23.408  1.00 20.37           C  
ATOM    305  CD2 PHE A  40     -64.277  28.450 -24.587  1.00 18.34           C  
ATOM    306  CE1 PHE A  40     -65.628  26.500 -23.236  1.00 17.42           C  
ATOM    307  CE2 PHE A  40     -65.638  28.543 -24.414  1.00 17.27           C  
ATOM    308  CZ  PHE A  40     -66.307  27.567 -23.735  1.00 15.66           C  
ATOM    309  N   SER A  41     -59.858  27.271 -26.264  1.00 30.41           N  
ATOM    310  CA  SER A  41     -58.468  27.549 -26.687  1.00 33.59           C  
ATOM    311  C   SER A  41     -58.314  28.740 -27.630  1.00 35.62           C  
ATOM    312  O   SER A  41     -59.303  29.297 -28.091  1.00 36.42           O  
ATOM    313  CB  SER A  41     -57.882  26.314 -27.357  1.00 34.41           C  
ATOM    314  OG  SER A  41     -58.724  25.904 -28.420  1.00 37.45           O  
ATOM    315  N   ARG A  42     -57.067  29.127 -27.908  1.00 37.86           N  
ATOM    316  CA  ARG A  42     -56.785  30.273 -28.806  1.00 39.31           C  
ATOM    317  C   ARG A  42     -56.017  29.931 -30.091  1.00 39.31           C  
ATOM    318  O   ARG A  42     -56.243  30.573 -31.129  1.00 39.62           O  
ATOM    319  CB  ARG A  42     -56.083  31.401 -28.026  1.00 39.57           C  
ATOM    320  CG  ARG A  42     -55.445  30.911 -26.726  1.00 42.86           C  
ATOM    321  CD  ARG A  42     -55.032  32.065 -25.787  1.00 45.47           C  
ATOM    322  NE  ARG A  42     -56.063  33.099 -25.624  1.00 49.69           N  
ATOM    323  CZ  ARG A  42     -56.012  34.065 -24.706  1.00 53.11           C  
ATOM    324  NH1 ARG A  42     -55.019  34.090 -23.837  1.00 54.41           N  
ATOM    325  NH2 ARG A  42     -56.963  34.991 -24.632  1.00 52.56           N  
ATOM    326  N   GLU A  54     -60.193  33.605 -28.845  1.00 42.38           N  
ATOM    327  CA  GLU A  54     -60.539  32.225 -28.497  1.00 42.81           C  
ATOM    328  C   GLU A  54     -61.715  31.645 -29.272  1.00 42.73           C  
ATOM    329  O   GLU A  54     -62.661  32.331 -29.676  1.00 42.35           O  
ATOM    330  CB  GLU A  54     -60.798  32.034 -26.982  1.00 42.73           C  
ATOM    331  CG  GLU A  54     -59.541  31.836 -26.144  1.00 42.75           C  
ATOM    332  CD  GLU A  54     -59.783  30.858 -25.017  1.00 43.87           C  
ATOM    333  OE1 GLU A  54     -60.941  30.413 -24.931  1.00 47.61           O  
ATOM    334  OE2 GLU A  54     -58.844  30.506 -24.252  1.00 40.29           O  
ATOM    335  N   GLY A  55     -61.587  30.338 -29.455  1.00 42.68           N  
ATOM    336  CA  GLY A  55     -62.584  29.483 -30.101  1.00 42.47           C  
ATOM    337  C   GLY A  55     -62.763  28.203 -29.304  1.00 42.62           C  
ATOM    338  O   GLY A  55     -61.829  27.724 -28.648  1.00 43.07           O  
ATOM    339  N   TYR A  56     -63.957  27.632 -29.372  1.00 42.61           N  
ATOM    340  CA  TYR A  56     -64.267  26.437 -28.576  1.00 42.53           C  
ATOM    341  C   TYR A  56     -64.979  25.310 -29.323  1.00 41.52           C  
ATOM    342  O   TYR A  56     -65.491  25.472 -30.435  1.00 42.60           O  
ATOM    343  CB  TYR A  56     -65.147  26.835 -27.402  1.00 43.22           C  
ATOM    344  CG  TYR A  56     -66.596  26.890 -27.790  1.00 45.47           C  
ATOM    345  CD1 TYR A  56     -67.297  25.715 -28.009  1.00 46.15           C  
ATOM    346  CD2 TYR A  56     -67.255  28.113 -27.958  1.00 48.77           C  
ATOM    347  CE1 TYR A  56     -68.626  25.755 -28.369  1.00 48.26           C  
ATOM    348  CE2 TYR A  56     -68.571  28.172 -28.319  1.00 49.99           C  
ATOM    349  CZ  TYR A  56     -69.261  26.999 -28.525  1.00 52.10           C  
ATOM    350  OH  TYR A  56     -70.590  27.095 -28.893  1.00 54.32           O  
ATOM    351  N   ARG A  57     -65.072  24.188 -28.633  1.00 39.26           N  
ATOM    352  CA  ARG A  57     -65.608  22.955 -29.212  1.00 38.39           C  
ATOM    353  C   ARG A  57     -65.618  21.739 -28.283  1.00 36.28           C  
ATOM    354  O   ARG A  57     -65.224  21.802 -27.128  1.00 36.47           O  
ATOM    355  CB  ARG A  57     -64.825  22.625 -30.496  1.00 40.01           C  
ATOM    356  CG  ARG A  57     -64.567  21.120 -30.796  1.00 46.70           C  
ATOM    357  CD  ARG A  57     -64.197  20.789 -32.296  1.00 54.04           C  
ATOM    358  NE  ARG A  57     -62.887  21.283 -32.758  1.00 59.53           N  
ATOM    359  CZ  ARG A  57     -62.209  22.307 -32.230  1.00 63.28           C  
ATOM    360  NH1 ARG A  57     -62.712  23.031 -31.233  1.00 65.64           N  
ATOM    361  NH2 ARG A  57     -61.027  22.643 -32.733  1.00 63.28           N  
ATOM    362  N   GLU A  58     -66.038  20.616 -28.844  1.00 34.12           N  
ATOM    363  CA  GLU A  58     -66.208  19.350 -28.112  1.00 32.47           C  
ATOM    364  C   GLU A  58     -65.148  18.302 -28.427  1.00 29.60           C  
ATOM    365  O   GLU A  58     -64.850  17.989 -29.579  1.00 28.76           O  
ATOM    366  CB  GLU A  58     -67.597  18.755 -28.401  1.00 33.48           C  
ATOM    367  CG  GLU A  58     -67.974  17.538 -27.546  1.00 40.92           C  
ATOM    368  CD  GLU A  58     -68.567  17.932 -26.180  1.00 50.47           C  
ATOM    369  OE1 GLU A  58     -69.094  19.065 -26.065  1.00 58.44           O  
ATOM    370  OE2 GLU A  58     -68.533  17.111 -25.230  1.00 53.04           O  
ATOM    371  N   PHE A  59     -64.596  17.755 -27.356  1.00 27.76           N  
ATOM    372  CA  PHE A  59     -63.541  16.741 -27.441  1.00 26.48           C  
ATOM    373  C   PHE A  59     -63.808  15.516 -26.614  1.00 24.62           C  
ATOM    374  O   PHE A  59     -64.706  15.413 -25.790  1.00 22.91           O  
ATOM    375  CB  PHE A  59     -62.177  17.276 -26.956  1.00 26.92           C  
ATOM    376  CG  PHE A  59     -61.745  18.558 -27.604  1.00 25.83           C  
ATOM    377  CD1 PHE A  59     -62.198  19.775 -27.126  1.00 26.61           C  
ATOM    378  CD2 PHE A  59     -60.860  18.552 -28.653  1.00 27.77           C  
ATOM    379  CE1 PHE A  59     -61.803  20.960 -27.698  1.00 23.70           C  
ATOM    380  CE2 PHE A  59     -60.458  19.740 -29.239  1.00 26.30           C  
ATOM    381  CZ  PHE A  59     -60.931  20.938 -28.756  1.00 23.74           C  
ATOM    382  N   CYS A  60     -62.895  14.613 -26.816  1.00 24.89           N  
ATOM    383  CA  CYS A  60     -62.902  13.362 -26.130  1.00 26.50           C  
ATOM    384  C   CYS A  60     -61.736  13.379 -25.160  1.00 24.70           C  
ATOM    385  O   CYS A  60     -60.605  13.625 -25.534  1.00 25.50           O  
ATOM    386  CB  CYS A  60     -62.788  12.229 -27.151  1.00 28.42           C  
ATOM    387  SG  CYS A  60     -62.849  10.570 -26.425  1.00 45.02           S  
ATOM    388  N   LYS A  61     -62.042  13.141 -23.898  1.00 22.82           N  
ATOM    389  CA  LYS A  61     -61.045  13.132 -22.850  1.00 22.25           C  
ATOM    390  C   LYS A  61     -60.803  11.723 -22.351  1.00 22.10           C  
ATOM    391  O   LYS A  61     -61.669  11.046 -21.751  1.00 20.96           O  
ATOM    392  CB  LYS A  61     -61.462  14.053 -21.700  1.00 21.66           C  
ATOM    393  CG  LYS A  61     -60.510  14.148 -20.497  1.00 20.04           C  
ATOM    394  CD  LYS A  61     -61.253  14.828 -19.329  1.00 24.29           C  
ATOM    395  CE  LYS A  61     -60.491  14.960 -18.036  1.00 28.61           C  
ATOM    396  NZ  LYS A  61     -61.372  15.469 -16.927  1.00 31.53           N  
ATOM    397  N   PHE A  62     -59.568  11.334 -22.623  1.00 21.81           N  
ATOM    398  CA  PHE A  62     -59.017  10.046 -22.255  1.00 22.19           C  
ATOM    399  C   PHE A  62     -58.197  10.190 -21.001  1.00 21.85           C  
ATOM    400  O   PHE A  62     -57.475  11.165 -20.818  1.00 23.44           O  
ATOM    401  CB  PHE A  62     -58.056   9.516 -23.337  1.00 22.82           C  
ATOM    402  CG  PHE A  62     -58.737   9.009 -24.611  1.00 25.61           C  
ATOM    403  CD1 PHE A  62     -59.012   9.866 -25.663  1.00 25.11           C  
ATOM    404  CD2 PHE A  62     -59.049   7.662 -24.762  1.00 23.84           C  
ATOM    405  CE1 PHE A  62     -59.605   9.390 -26.809  1.00 26.09           C  
ATOM    406  CE2 PHE A  62     -59.658   7.195 -25.903  1.00 23.65           C  
ATOM    407  CZ  PHE A  62     -59.929   8.047 -26.927  1.00 22.88           C  
ATOM    408  N   GLU A  63     -58.328   9.199 -20.142  1.00 20.47           N  
ATOM    409  CA  GLU A  63     -57.499   9.088 -18.946  1.00 20.93           C  
ATOM    410  C   GLU A  63     -56.914   7.692 -18.922  1.00 20.81           C  
ATOM    411  O   GLU A  63     -57.641   6.686 -18.960  1.00 20.41           O  
ATOM    412  CB  GLU A  63     -58.286   9.400 -17.676  1.00 22.26           C  
ATOM    413  CG  GLU A  63     -58.701  10.853 -17.612  1.00 22.04           C  
ATOM    414  CD  GLU A  63     -59.242  11.292 -16.266  1.00 29.61           C  
ATOM    415  OE1 GLU A  63     -59.407  10.483 -15.329  1.00 37.80           O  
ATOM    416  OE2 GLU A  63     -59.478  12.493 -16.140  1.00 34.62           O  
ATOM    417  N   ILE A  64     -55.584   7.677 -18.898  1.00 21.15           N  
ATOM    418  CA  ILE A  64     -54.782   6.467 -19.010  1.00 21.32           C  
ATOM    419  C   ILE A  64     -53.703   6.306 -17.943  1.00 22.59           C  
ATOM    420  O   ILE A  64     -52.647   6.930 -17.948  1.00 24.33           O  
ATOM    421  CB  ILE A  64     -54.102   6.429 -20.398  1.00 21.54           C  
ATOM    422  CG1 ILE A  64     -55.149   6.705 -21.482  1.00 21.17           C  
ATOM    423  CG2 ILE A  64     -53.351   5.097 -20.651  1.00 21.63           C  
ATOM    424  CD1 ILE A  64     -54.566   7.432 -22.621  1.00 16.03           C  
HETATM  425  N   MSE A  65     -54.034   5.442 -17.013  1.00 22.51           N  
HETATM  426  CA  MSE A  65     -53.139   5.067 -15.934  0.50 21.87           C  
HETATM  428  C   MSE A  65     -52.097   4.159 -16.565  1.00 22.75           C  
HETATM  429  O   MSE A  65     -52.421   3.246 -17.339  1.00 24.08           O  
HETATM  430  CB  MSE A  65     -53.869   4.328 -14.803  0.50 21.10           C  
HETATM  432  CG  MSE A  65     -52.981   4.052 -13.609  0.50 19.91           C  
HETATM  434 SE   MSE A  65     -52.690   5.672 -12.615  0.38 17.60          SE  
HETATM  436  CE  MSE A  65     -54.543   6.129 -12.280  0.50 24.51           C  
ATOM    438  N   HIS A  66     -50.846   4.438 -16.239  1.00 22.89           N  
ATOM    439  CA  HIS A  66     -49.728   3.699 -16.768  1.00 21.94           C  
ATOM    440  C   HIS A  66     -48.496   3.850 -15.893  1.00 21.88           C  
ATOM    441  O   HIS A  66     -48.366   4.832 -15.169  1.00 22.48           O  
ATOM    442  CB  HIS A  66     -49.393   4.242 -18.163  1.00 23.63           C  
ATOM    443  CG  HIS A  66     -48.915   5.668 -18.155  1.00 22.46           C  
ATOM    444  ND1 HIS A  66     -49.779   6.747 -18.043  1.00 19.28           N  
ATOM    445  CD2 HIS A  66     -47.666   6.190 -18.227  1.00 17.90           C  
ATOM    446  CE1 HIS A  66     -49.074   7.870 -18.031  1.00 22.83           C  
ATOM    447  NE2 HIS A  66     -47.791   7.562 -18.134  1.00 18.43           N  
ATOM    448  N   PRO A  67     -47.588   2.871 -15.960  1.00 20.91           N  
ATOM    449  CA  PRO A  67     -46.338   3.006 -15.249  1.00 20.93           C  
ATOM    450  C   PRO A  67     -45.447   4.105 -15.842  1.00 21.48           C  
ATOM    451  O   PRO A  67     -45.289   4.233 -17.060  1.00 21.37           O  
ATOM    452  CB  PRO A  67     -45.667   1.633 -15.421  1.00 22.21           C  
ATOM    453  CG  PRO A  67     -46.621   0.755 -16.205  1.00 22.59           C  
ATOM    454  CD  PRO A  67     -47.654   1.658 -16.800  1.00 21.80           C  
ATOM    455  N   ALA A  68     -44.857   4.871 -14.945  1.00 20.85           N  
ATOM    456  CA  ALA A  68     -43.984   5.974 -15.304  1.00 20.48           C  
ATOM    457  C   ALA A  68     -42.888   5.500 -16.240  1.00 19.58           C  
ATOM    458  O   ALA A  68     -42.432   6.225 -17.123  1.00 19.68           O  
ATOM    459  CB  ALA A  68     -43.370   6.629 -14.019  1.00 20.30           C  
ATOM    460  N   ALA A  69     -42.526   4.243 -16.075  1.00 19.82           N  
ATOM    461  CA  ALA A  69     -41.416   3.633 -16.841  1.00 19.50           C  
ATOM    462  C   ALA A  69     -41.732   3.470 -18.331  1.00 20.53           C  
ATOM    463  O   ALA A  69     -40.836   3.318 -19.155  1.00 20.21           O  
ATOM    464  CB  ALA A  69     -41.053   2.273 -16.269  1.00 17.81           C  
ATOM    465  N   GLN A  70     -43.024   3.524 -18.641  1.00 21.21           N  
ATOM    466  CA  GLN A  70     -43.555   3.266 -19.983  1.00 21.06           C  
ATOM    467  C   GLN A  70     -44.164   4.539 -20.582  1.00 20.68           C  
ATOM    468  O   GLN A  70     -44.864   4.518 -21.594  1.00 20.65           O  
ATOM    469  CB  GLN A  70     -44.653   2.229 -19.883  1.00 21.85           C  
ATOM    470  CG  GLN A  70     -44.272   0.984 -19.133  1.00 24.68           C  
ATOM    471  CD  GLN A  70     -43.456   0.045 -19.952  1.00 26.99           C  
ATOM    472  OE1 GLN A  70     -43.344   0.206 -21.166  1.00 31.02           O  
ATOM    473  NE2 GLN A  70     -42.882  -0.962 -19.298  1.00 31.96           N  
ATOM    474  N   GLN A  71     -43.861   5.642 -19.933  1.00 20.20           N  
ATOM    475  CA  GLN A  71     -44.346   6.945 -20.360  1.00 22.15           C  
ATOM    476  C   GLN A  71     -43.983   7.274 -21.819  1.00 21.49           C  
ATOM    477  O   GLN A  71     -44.836   7.709 -22.598  1.00 22.41           O  
ATOM    478  CB  GLN A  71     -43.805   8.054 -19.443  1.00 22.61           C  
ATOM    479  CG  GLN A  71     -44.438   9.421 -19.709  1.00 27.71           C  
ATOM    480  CD  GLN A  71     -43.756  10.537 -18.944  1.00 31.71           C  
ATOM    481  OE1 GLN A  71     -43.983  10.721 -17.749  1.00 35.31           O  
ATOM    482  NE2 GLN A  71     -42.922  11.306 -19.647  1.00 37.88           N  
ATOM    483  N   ALA A  72     -42.725   7.050 -22.174  1.00 20.35           N  
ATOM    484  CA  ALA A  72     -42.217   7.348 -23.524  1.00 19.84           C  
ATOM    485  C   ALA A  72     -42.956   6.488 -24.511  1.00 21.20           C  
ATOM    486  O   ALA A  72     -43.483   6.959 -25.517  1.00 23.41           O  
ATOM    487  CB  ALA A  72     -40.781   7.034 -23.649  1.00 18.28           C  
ATOM    488  N   ALA A  73     -42.955   5.199 -24.211  1.00 20.59           N  
ATOM    489  CA  ALA A  73     -43.616   4.207 -25.071  1.00 19.40           C  
ATOM    490  C   ALA A  73     -45.045   4.650 -25.364  1.00 19.94           C  
ATOM    491  O   ALA A  73     -45.501   4.584 -26.515  1.00 22.80           O  
ATOM    492  CB  ALA A  73     -43.608   2.816 -24.423  1.00 17.20           C  
ATOM    493  N   LEU A  74     -45.700   5.172 -24.330  1.00 18.15           N  
ATOM    494  CA  LEU A  74     -47.123   5.557 -24.418  1.00 18.19           C  
ATOM    495  C   LEU A  74     -47.312   6.819 -25.238  1.00 18.68           C  
ATOM    496  O   LEU A  74     -48.169   6.883 -26.113  1.00 20.74           O  
ATOM    497  CB  LEU A  74     -47.737   5.751 -23.027  1.00 17.45           C  
ATOM    498  CG  LEU A  74     -49.198   6.248 -22.919  1.00 18.26           C  
ATOM    499  CD1 LEU A  74     -50.198   5.360 -23.634  1.00 16.43           C  
ATOM    500  CD2 LEU A  74     -49.583   6.410 -21.463  1.00 14.47           C  
ATOM    501  N   LEU A  75     -46.447   7.791 -25.008  1.00 17.57           N  
ATOM    502  CA  LEU A  75     -46.600   9.081 -25.665  1.00 18.17           C  
ATOM    503  C   LEU A  75     -46.162   9.034 -27.129  1.00 19.26           C  
ATOM    504  O   LEU A  75     -46.769   9.684 -28.000  1.00 21.32           O  
ATOM    505  CB  LEU A  75     -45.858  10.187 -24.910  1.00 18.42           C  
ATOM    506  CG  LEU A  75     -46.339  10.610 -23.506  1.00 17.56           C  
ATOM    507  CD1 LEU A  75     -45.385  11.671 -22.932  1.00 11.23           C  
ATOM    508  CD2 LEU A  75     -47.733  11.137 -23.535  1.00 19.45           C  
ATOM    509  N   THR A  76     -45.107   8.276 -27.403  1.00 18.80           N  
ATOM    510  CA  THR A  76     -44.607   8.133 -28.782  1.00 17.11           C  
ATOM    511  C   THR A  76     -45.639   7.359 -29.623  1.00 17.05           C  
ATOM    512  O   THR A  76     -45.831   7.633 -30.797  1.00 19.06           O  
ATOM    513  CB  THR A  76     -43.233   7.428 -28.852  1.00 16.68           C  
ATOM    514  OG1 THR A  76     -43.306   6.199 -28.137  1.00 15.42           O  
ATOM    515  CG2 THR A  76     -42.156   8.265 -28.242  1.00 13.37           C  
ATOM    516  N   ALA A  77     -46.319   6.414 -28.985  1.00 17.10           N  
ATOM    517  CA  ALA A  77     -47.350   5.578 -29.661  1.00 16.60           C  
ATOM    518  C   ALA A  77     -48.539   6.444 -30.026  1.00 16.84           C  
ATOM    519  O   ALA A  77     -49.117   6.354 -31.115  1.00 18.86           O  
ATOM    520  CB  ALA A  77     -47.795   4.431 -28.773  1.00 14.78           C  
ATOM    521  N   LEU A  78     -48.914   7.298 -29.081  1.00 17.77           N  
ATOM    522  CA  LEU A  78     -50.061   8.217 -29.292  1.00 16.22           C  
ATOM    523  C   LEU A  78     -49.676   9.338 -30.259  1.00 14.43           C  
ATOM    524  O   LEU A  78     -50.466   9.760 -31.088  1.00 14.22           O  
ATOM    525  CB  LEU A  78     -50.556   8.781 -27.983  1.00 15.31           C  
ATOM    526  CG  LEU A  78     -51.211   7.741 -27.065  1.00 17.13           C  
ATOM    527  CD1 LEU A  78     -51.319   8.350 -25.696  1.00 13.54           C  
ATOM    528  CD2 LEU A  78     -52.569   7.244 -27.588  1.00 14.37           C  
ATOM    529  N   ALA A  79     -48.415   9.722 -30.208  1.00 13.31           N  
ATOM    530  CA  ALA A  79     -47.924  10.814 -31.042  1.00 14.64           C  
ATOM    531  C   ALA A  79     -48.098  10.457 -32.493  1.00 17.72           C  
ATOM    532  O   ALA A  79     -48.162  11.344 -33.368  1.00 19.58           O  
ATOM    533  CB  ALA A  79     -46.480  11.128 -30.751  1.00 13.05           C  
ATOM    534  N   LEU A  80     -48.223   9.155 -32.746  1.00 18.44           N  
ATOM    535  CA  LEU A  80     -48.362   8.670 -34.129  1.00 18.71           C  
ATOM    536  C   LEU A  80     -49.753   8.909 -34.641  1.00 19.80           C  
ATOM    537  O   LEU A  80     -49.938   9.284 -35.803  1.00 18.79           O  
ATOM    538  CB  LEU A  80     -48.097   7.168 -34.261  1.00 18.52           C  
ATOM    539  CG  LEU A  80     -46.735   6.574 -34.556  1.00 16.70           C  
ATOM    540  CD1 LEU A  80     -46.829   5.063 -34.289  1.00 15.40           C  
ATOM    541  CD2 LEU A  80     -46.345   6.859 -35.966  1.00 10.59           C  
ATOM    542  N   VAL A  81     -50.729   8.665 -33.768  1.00 21.76           N  
ATOM    543  CA  VAL A  81     -52.151   8.747 -34.181  1.00 23.28           C  
ATOM    544  C   VAL A  81     -52.564  10.196 -34.365  1.00 23.11           C  
ATOM    545  O   VAL A  81     -53.527  10.500 -35.080  1.00 23.59           O  
ATOM    546  CB  VAL A  81     -53.118   8.030 -33.205  1.00 23.34           C  
ATOM    547  CG1 VAL A  81     -52.718   6.563 -33.040  1.00 25.97           C  
ATOM    548  CG2 VAL A  81     -53.124   8.695 -31.879  1.00 25.57           C  
ATOM    549  N   CYS A  82     -51.767  11.072 -33.760  1.00 22.52           N  
ATOM    550  CA  CYS A  82     -52.023  12.528 -33.766  1.00 22.70           C  
ATOM    551  C   CYS A  82     -51.219  13.242 -34.793  1.00 22.88           C  
ATOM    552  O   CYS A  82     -51.162  14.463 -34.782  1.00 21.90           O  
ATOM    553  CB  CYS A  82     -51.618  13.156 -32.456  1.00 22.19           C  
ATOM    554  SG  CYS A  82     -52.493  12.486 -31.088  1.00 24.92           S  
ATOM    555  N   LYS A  83     -50.570  12.448 -35.638  1.00 23.56           N  
ATOM    556  CA  LYS A  83     -49.671  12.949 -36.703  1.00 23.56           C  
ATOM    557  C   LYS A  83     -50.248  14.244 -37.246  1.00 23.69           C  
ATOM    558  O   LYS A  83     -49.551  15.251 -37.360  1.00 23.86           O  
ATOM    559  CB  LYS A  83     -49.477  11.896 -37.851  1.00 22.93           C  
ATOM    560  CG  LYS A  83     -48.342  12.141 -38.872  1.00 20.35           C  
ATOM    561  CD  LYS A  83     -48.290  11.017 -39.997  1.00 16.75           C  
ATOM    562  N   HIS A  84     -51.551  14.226 -37.499  1.00 23.82           N  
ATOM    563  CA  HIS A  84     -52.185  15.343 -38.185  1.00 25.25           C  
ATOM    564  C   HIS A  84     -53.245  16.080 -37.371  1.00 24.65           C  
ATOM    565  O   HIS A  84     -53.844  17.049 -37.861  1.00 25.14           O  
ATOM    566  CB  HIS A  84     -52.790  14.858 -39.527  1.00 26.94           C  
ATOM    567  CG  HIS A  84     -51.786  14.314 -40.511  1.00 30.83           C  
ATOM    568  ND1 HIS A  84     -51.099  15.118 -41.401  1.00 32.46           N  
ATOM    569  CD2 HIS A  84     -51.393  13.042 -40.773  1.00 33.84           C  
ATOM    570  CE1 HIS A  84     -50.307  14.366 -42.148  1.00 33.47           C  
ATOM    571  NE2 HIS A  84     -50.466  13.103 -41.787  1.00 34.85           N  
ATOM    572  N   ASN A  85     -53.469  15.610 -36.144  1.00 23.52           N  
ATOM    573  CA  ASN A  85     -54.463  16.185 -35.213  1.00 21.85           C  
ATOM    574  C   ASN A  85     -53.890  16.406 -33.838  1.00 20.41           C  
ATOM    575  O   ASN A  85     -54.022  15.550 -32.989  1.00 19.79           O  
ATOM    576  CB  ASN A  85     -55.654  15.252 -35.022  1.00 22.23           C  
ATOM    577  CG  ASN A  85     -56.410  15.016 -36.277  1.00 25.91           C  
ATOM    578  OD1 ASN A  85     -55.955  14.279 -37.159  1.00 27.27           O  
ATOM    579  ND2 ASN A  85     -57.603  15.601 -36.362  1.00 29.31           N  
ATOM    580  N   PRO A  86     -53.275  17.561 -33.606  1.00 19.80           N  
ATOM    581  CA  PRO A  86     -52.678  17.780 -32.308  1.00 19.43           C  
ATOM    582  C   PRO A  86     -53.622  17.637 -31.155  1.00 19.83           C  
ATOM    583  O   PRO A  86     -54.783  18.017 -31.225  1.00 19.51           O  
ATOM    584  CB  PRO A  86     -52.129  19.192 -32.401  1.00 20.61           C  
ATOM    585  CG  PRO A  86     -51.860  19.386 -33.908  1.00 21.21           C  
ATOM    586  CD  PRO A  86     -52.929  18.607 -34.590  1.00 19.87           C  
ATOM    587  N   CYS A  87     -53.074  17.034 -30.114  1.00 21.20           N  
ATOM    588  CA  CYS A  87     -53.783  16.764 -28.867  1.00 23.97           C  
ATOM    589  C   CYS A  87     -53.084  17.241 -27.627  1.00 23.27           C  
ATOM    590  O   CYS A  87     -51.943  16.903 -27.366  1.00 24.98           O  
ATOM    591  CB  CYS A  87     -54.058  15.271 -28.725  1.00 23.61           C  
ATOM    592  SG  CYS A  87     -55.232  14.802 -30.034  1.00 40.87           S  
ATOM    593  N   ARG A  88     -53.795  18.039 -26.857  1.00 22.26           N  
ATOM    594  CA  ARG A  88     -53.261  18.486 -25.586  1.00 21.58           C  
ATOM    595  C   ARG A  88     -53.194  17.336 -24.629  1.00 19.88           C  
ATOM    596  O   ARG A  88     -54.005  16.421 -24.673  1.00 18.89           O  
ATOM    597  CB  ARG A  88     -54.063  19.616 -24.964  1.00 22.64           C  
ATOM    598  CG  ARG A  88     -53.472  20.959 -25.297  1.00 33.37           C  
ATOM    599  CD  ARG A  88     -53.958  22.030 -24.319  1.00 48.23           C  
ATOM    600  NE  ARG A  88     -52.892  22.976 -24.005  1.00 55.08           N  
ATOM    601  CZ  ARG A  88     -52.004  22.760 -23.035  1.00 59.99           C  
ATOM    602  NH1 ARG A  88     -52.069  21.629 -22.310  1.00 54.74           N  
ATOM    603  NH2 ARG A  88     -51.049  23.664 -22.804  1.00 59.42           N  
ATOM    604  N   TYR A  89     -52.175  17.362 -23.791  1.00 18.12           N  
ATOM    605  CA  TYR A  89     -52.083  16.342 -22.759  1.00 18.23           C  
ATOM    606  C   TYR A  89     -51.370  16.835 -21.536  1.00 18.40           C  
ATOM    607  O   TYR A  89     -50.692  17.857 -21.541  1.00 18.11           O  
ATOM    608  CB  TYR A  89     -51.350  15.098 -23.257  1.00 18.63           C  
ATOM    609  CG  TYR A  89     -49.845  15.273 -23.285  1.00 17.81           C  
ATOM    610  CD1 TYR A  89     -49.230  15.934 -24.314  1.00 24.68           C  
ATOM    611  CD2 TYR A  89     -49.051  14.791 -22.268  1.00 23.01           C  
ATOM    612  CE1 TYR A  89     -47.840  16.117 -24.346  1.00 25.14           C  
ATOM    613  CE2 TYR A  89     -47.667  14.966 -22.282  1.00 23.98           C  
ATOM    614  CZ  TYR A  89     -47.065  15.629 -23.321  1.00 25.67           C  
ATOM    615  OH  TYR A  89     -45.692  15.814 -23.352  1.00 25.56           O  
ATOM    616  N   TRP A  90     -51.606  16.094 -20.476  1.00 18.56           N  
ATOM    617  CA  TRP A  90     -50.906  16.295 -19.218  1.00 18.73           C  
ATOM    618  C   TRP A  90     -50.834  15.008 -18.427  1.00 18.31           C  
ATOM    619  O   TRP A  90     -51.562  14.084 -18.676  1.00 19.05           O  
ATOM    620  CB  TRP A  90     -51.413  17.488 -18.403  1.00 19.49           C  
ATOM    621  CG  TRP A  90     -52.804  17.433 -18.023  1.00 21.96           C  
ATOM    622  CD1 TRP A  90     -53.327  16.939 -16.866  1.00 21.11           C  
ATOM    623  CD2 TRP A  90     -53.904  17.930 -18.790  1.00 27.95           C  
ATOM    624  NE1 TRP A  90     -54.720  17.075 -16.875  1.00 20.01           N  
ATOM    625  CE2 TRP A  90     -55.094  17.667 -18.048  1.00 24.74           C  
ATOM    626  CE3 TRP A  90     -54.007  18.554 -20.045  1.00 26.24           C  
ATOM    627  CZ2 TRP A  90     -56.354  18.005 -18.513  1.00 23.08           C  
ATOM    628  CZ3 TRP A  90     -55.280  18.897 -20.513  1.00 26.13           C  
ATOM    629  CH2 TRP A  90     -56.435  18.619 -19.739  1.00 24.93           C  
ATOM    630  N   ILE A  91     -49.824  14.940 -17.567  1.00 18.84           N  
ATOM    631  CA  ILE A  91     -49.519  13.742 -16.768  1.00 19.28           C  
ATOM    632  C   ILE A  91     -49.515  14.155 -15.334  1.00 20.03           C  
ATOM    633  O   ILE A  91     -48.917  15.162 -14.953  1.00 19.28           O  
ATOM    634  CB  ILE A  91     -48.128  13.105 -17.135  1.00 20.21           C  
ATOM    635  CG1 ILE A  91     -48.060  12.770 -18.650  1.00 18.76           C  
ATOM    636  CG2 ILE A  91     -47.898  11.876 -16.285  1.00 19.18           C  
ATOM    637  CD1 ILE A  91     -46.803  12.094 -19.087  1.00 21.70           C  
HETATM  638  N   MSE A  92     -50.247  13.396 -14.541  1.00 22.20           N  
HETATM  639  CA  MSE A  92     -50.418  13.722 -13.127  1.00 22.96           C  
HETATM  640  C   MSE A  92     -49.980  12.588 -12.269  1.00 23.32           C  
HETATM  641  O   MSE A  92     -50.089  11.433 -12.653  1.00 23.69           O  
HETATM  642  CB  MSE A  92     -51.879  13.988 -12.826  1.00 23.41           C  
HETATM  643  CG  MSE A  92     -52.487  14.866 -13.882  1.00 26.80           C  
HETATM  644 SE   MSE A  92     -54.285  15.399 -13.522  0.75 22.90          SE  
HETATM  645  CE  MSE A  92     -53.901  16.542 -12.048  1.00  5.80           C  
ATOM    646  N   PRO A  93     -49.491  12.920 -11.091  1.00 23.80           N  
ATOM    647  CA  PRO A  93     -49.080  11.884 -10.206  1.00 24.87           C  
ATOM    648  C   PRO A  93     -50.249  11.262  -9.500  1.00 26.05           C  
ATOM    649  O   PRO A  93     -51.299  11.905  -9.272  1.00 27.28           O  
ATOM    650  CB  PRO A  93     -48.194  12.621  -9.211  1.00 25.28           C  
ATOM    651  CG  PRO A  93     -48.730  13.989  -9.182  1.00 25.08           C  
ATOM    652  CD  PRO A  93     -49.307  14.261 -10.521  1.00 23.27           C  
ATOM    653  N   ILE A  94     -50.029   9.984  -9.202  1.00 26.61           N  
ATOM    654  CA  ILE A  94     -50.939   9.095  -8.463  1.00 25.31           C  
ATOM    655  C   ILE A  94     -50.235   8.614  -7.218  1.00 24.66           C  
ATOM    656  O   ILE A  94     -49.142   8.088  -7.302  1.00 24.49           O  
ATOM    657  CB  ILE A  94     -51.260   7.832  -9.248  1.00 24.77           C  
ATOM    658  CG1 ILE A  94     -52.077   8.176 -10.480  1.00 26.11           C  
ATOM    659  CG2 ILE A  94     -51.995   6.839  -8.352  1.00 27.07           C  
ATOM    660  CD1 ILE A  94     -53.085   9.232 -10.203  1.00 36.11           C  
ATOM    661  N   TYR A  95     -50.859   8.772  -6.067  1.00 24.44           N  
ATOM    662  CA  TYR A  95     -50.219   8.311  -4.828  1.00 25.10           C  
ATOM    663  C   TYR A  95     -50.381   6.822  -4.732  1.00 24.07           C  
ATOM    664  O   TYR A  95     -49.515   6.079  -4.318  1.00 22.56           O  
ATOM    665  CB  TYR A  95     -50.916   8.808  -3.591  1.00 25.50           C  
ATOM    666  CG  TYR A  95     -50.509  10.144  -3.070  1.00 31.20           C  
ATOM    667  CD1 TYR A  95     -49.228  10.639  -3.262  1.00 34.22           C  
ATOM    668  CD2 TYR A  95     -51.364  10.842  -2.232  1.00 39.05           C  
ATOM    669  CE1 TYR A  95     -48.839  11.869  -2.688  1.00 34.89           C  
ATOM    670  CE2 TYR A  95     -51.000  12.046  -1.653  1.00 43.91           C  
ATOM    671  CZ  TYR A  95     -49.745  12.555  -1.864  1.00 43.49           C  
ATOM    672  OH  TYR A  95     -49.476  13.775  -1.245  1.00 53.45           O  
ATOM    673  N   GLN A  96     -51.575   6.420  -5.102  1.00 23.78           N  
ATOM    674  CA  GLN A  96     -51.969   5.039  -5.008  1.00 22.68           C  
ATOM    675  C   GLN A  96     -53.090   4.632  -5.929  1.00 21.88           C  
ATOM    676  O   GLN A  96     -53.939   5.422  -6.294  1.00 21.59           O  
ATOM    677  CB  GLN A  96     -52.389   4.795  -3.580  1.00 22.90           C  
ATOM    678  CG  GLN A  96     -52.863   3.412  -3.319  1.00 27.54           C  
ATOM    679  CD  GLN A  96     -53.228   3.261  -1.866  1.00 30.15           C  
ATOM    680  OE1 GLN A  96     -52.624   3.916  -1.022  1.00 38.43           O  
ATOM    681  NE2 GLN A  96     -54.220   2.418  -1.558  1.00 25.39           N  
ATOM    682  N   ASN A  97     -53.059   3.380  -6.345  1.00 22.59           N  
ATOM    683  CA  ASN A  97     -54.155   2.854  -7.158  1.00 23.59           C  
ATOM    684  C   ASN A  97     -54.395   1.365  -6.986  1.00 22.97           C  
ATOM    685  O   ASN A  97     -53.566   0.634  -6.440  1.00 24.62           O  
ATOM    686  CB  ASN A  97     -54.047   3.240  -8.625  1.00 24.23           C  
ATOM    687  CG  ASN A  97     -53.353   2.232  -9.429  1.00 29.30           C  
ATOM    688  OD1 ASN A  97     -53.694   2.024 -10.600  1.00 39.85           O  
ATOM    689  ND2 ASN A  97     -52.389   1.573  -8.828  1.00 23.85           N  
ATOM    690  N   GLY A  98     -55.574   0.941  -7.411  1.00 20.60           N  
ATOM    691  CA  GLY A  98     -55.967  -0.453  -7.210  1.00 16.97           C  
ATOM    692  C   GLY A  98     -57.404  -0.788  -7.451  1.00 13.63           C  
ATOM    693  O   GLY A  98     -58.103  -0.160  -8.224  1.00 13.21           O  
ATOM    694  N   THR A  99     -57.835  -1.802  -6.746  1.00 12.36           N  
ATOM    695  CA  THR A  99     -59.189  -2.283  -6.901  1.00 10.94           C  
ATOM    696  C   THR A  99     -59.764  -2.723  -5.595  1.00 10.52           C  
ATOM    697  O   THR A  99     -59.202  -3.558  -4.886  1.00 13.47           O  
ATOM    698  CB  THR A  99     -59.256  -3.435  -7.911  1.00 10.67           C  
ATOM    699  OG1 THR A  99     -58.721  -3.006  -9.178  1.00  5.73           O  
ATOM    700  CG2 THR A  99     -60.679  -3.885  -8.092  1.00 11.31           C  
ATOM    701  N   LEU A 100     -60.897  -2.110  -5.305  1.00  8.93           N  
ATOM    702  CA  LEU A 100     -61.653  -2.341  -4.102  1.00  9.02           C  
ATOM    703  C   LEU A 100     -62.615  -3.482  -4.321  1.00  8.81           C  
ATOM    704  O   LEU A 100     -63.231  -3.593  -5.358  1.00  8.32           O  
ATOM    705  CB  LEU A 100     -62.446  -1.094  -3.703  1.00 10.02           C  
ATOM    706  CG  LEU A 100     -61.653   0.131  -3.266  1.00 11.14           C  
ATOM    707  CD1 LEU A 100     -62.606   1.227  -2.841  1.00 12.71           C  
ATOM    708  CD2 LEU A 100     -60.782  -0.275  -2.108  1.00 12.25           C  
ATOM    709  N   SER A 101     -62.733  -4.324  -3.314  1.00  8.36           N  
ATOM    710  CA  SER A 101     -63.610  -5.485  -3.386  1.00  9.22           C  
ATOM    711  C   SER A 101     -63.747  -6.087  -2.015  1.00 10.73           C  
ATOM    712  O   SER A 101     -64.520  -7.011  -1.705  1.00 12.69           O  
ATOM    713  CB  SER A 101     -63.053  -6.513  -4.374  1.00  9.30           C  
ATOM    714  OG  SER A 101     -61.627  -6.532  -4.382  1.00 12.40           O  
ATOM    715  OXT SER A 101     -63.035  -5.611  -1.146  1.00 11.91           O  
TER     716      SER A 101                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
