
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  742),  selected   99 , name 3bzq_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 3bzq_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -1_A      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    H     0_A      R       4          4.001
LGA    M     1_A      A       5          0.632
LGA    K     2_A      N       6          0.579
LGA    L     3_A      K       7          0.310
LGA    I     4_A      L       8          0.631
LGA    T     5_A      V       9          0.735
LGA    A     6_A      I      10          0.736
LGA    I     7_A      V      11          0.627
LGA    V     8_A      T      12          0.239
LGA    K     9_A      E      13          0.430
LGA    P    10_A      K      14          0.518
LGA    F    11_A      V      15          0.676
LGA    T    12_A      L      16          0.682
LGA    L    13_A      L      17          0.928
LGA    D    14_A      K      18          0.917
LGA    D    15_A      K      19          0.888
LGA    V    16_A      V      20          0.677
LGA    K    17_A      A      21          0.954
LGA    T    18_A      K      22          0.999
LGA    S    19_A      I      23          1.092
LGA    L    20_A      I      24          1.379
LGA    E    21_A      E      25          1.316
LGA    D    22_A      E      26          1.482
LGA    A    23_A      A      27          1.826
LGA    G    24_A      G      28          1.413
LGA    V    25_A      A      29          1.221
LGA    L    26_A      T      30          2.474
LGA    G    27_A      G      31          0.856
LGA    M    28_A      Y      32          1.254
LGA    T    29_A      T      33          1.223
LGA    V    30_A      V      34          0.748
LGA    S    31_A      V      35          0.344
LGA    E    32_A      D      36          0.906
LGA    I    33_A      T      37          0.621
LGA    Q    34_A      G      38          0.999
LGA    G    35_A      G      39          2.001
LGA    Y    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    R    38_A      -       -           -
LGA    D    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    V    56_A      -       -           -
LGA    P    57_A      S      58          0.723
LGA    K    58_A      N      59          0.377
LGA    V    59_A      V      60          0.382
LGA    R    60_A      K      61          0.510
LGA    I    61_A      F      62          0.619
LGA    E    62_A      E      63          0.725
LGA    V    63_A      V      64          0.421
LGA    V    64_A      L      65          0.286
LGA    V    65_A      T      66          0.473
LGA    D    66_A      E      67          2.367
LGA    D    67_A      N      68          2.712
LGA    -       -      R      69           -
LGA    S    68_A      E      70          3.494
LGA    I    69_A      M      71          1.810
LGA    V    70_A      A      72          1.883
LGA    D    71_A      E      73          1.432
LGA    K    72_A      K      74          1.136
LGA    V    73_A      I      75          1.847
LGA    V    74_A      A      76          1.479
LGA    D    75_A      D      77          1.058
LGA    S    76_A      Q      78          1.865
LGA    I    77_A      V      79          2.517
LGA    V    78_A      A      80          1.901
LGA    R    79_A      I      81          3.004
LGA    A    80_A      K      82          4.092
LGA    A    81_A      F      83          3.582
LGA    R    82_A      F      84          2.237
LGA    T    83_A      T      85          4.544
LGA    G    84_A      D      86          2.452
LGA    K    85_A      Y      87          4.780
LGA    I    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    D    88_A      A      88          0.566
LGA    G    89_A      G      89          1.312
LGA    K    90_A      I      90          0.362
LGA    V    91_A      I      91          0.531
LGA    W    92_A      Y      92          0.535
LGA    V    93_A      I      93          0.205
LGA    S    94_A      C      94          0.450
LGA    P    95_A      E      95          0.168
LGA    V    96_A      A      96          0.729
LGA    D    97_A      E      97          1.392
LGA    T    98_A      V      98          1.946
LGA    I    99_A      L      99          3.643
LGA    V   100_A      Y     100          1.092
LGA    R   101_A      G     101          1.772
LGA    V   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    R   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    H   109_A      -       -           -
LGA    D   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    L   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99   83    5.0     79    1.72    20.25     87.566     4.342

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.428279 * X  +   0.225886 * Y  +  -0.874959 * Z  + -60.157913
  Y_new =   0.505740 * X  +   0.862326 * Y  +  -0.024927 * Z  +  15.370283
  Z_new =   0.748869 * X  +  -0.453177 * Y  +  -0.483556 * Z  + -14.518046 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.388613    0.752980  [ DEG:  -136.8575     43.1425 ]
  Theta =  -0.846353   -2.295239  [ DEG:   -48.4925   -131.5075 ]
  Phi   =   2.273451   -0.868142  [ DEG:   130.2591    -49.7409 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bzq_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bzq_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99   83   5.0   79   1.72   20.25  87.566
REMARK  ---------------------------------------------------------- 
MOLECULE 3bzq_A
HEADER    SIGNALING PROTEIN/TRANSCRIPTION         18-JAN-08   3BZQ              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF NITROGEN REGULATORY              
TITLE    2 PROTEIN (RV2919C) OF MYCOBACTERIUM TUBERCULOSIS                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITROGEN REGULATORY PROTEIN P-II;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 STRAIN: H37RV;                                                       
SOURCE   4 GENE: GLNB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B                                    
KEYWDS    P-II, GLNB, GLNK, MYCOBACTERIUM TUBERCULOSIS, SIGNAL                  
KEYWDS   2 TRANSDUCTORY PROTEIN, NUCLEOTIDE-BINDING, TRANSCRIPTION,             
KEYWDS   3 TRANSCRIPTION REGULATION, SIGNAL TRANSDUCTION, NITROGEN              
KEYWDS   4 REGULATORY, SIGNALING PROTEIN/TRANSCRIPTION COMPLEX,                 
KEYWDS   5 STRUCTURAL GENOMICS, TB STRUCTURAL GENOMICS CONSORTIUM,              
KEYWDS   6 TBSGC                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.C.M.REDDY,S.K.PALANINATHAN,N.D.SHETTY,J.L.OWEN,                     
AUTHOR   2 J.C.SACCHETTINI,TB STRUCTURAL GENOMICS CONSORTIUM (TBSGC)            
REVDAT   1   01-APR-08 3BZQ    0                                                
JRNL        AUTH   M.C.M.REDDY,S.K.PALANINATHAN,N.D.SHETTY,J.L.OWEN,            
JRNL        AUTH 2 J.C.SACCHETTINI                                              
JRNL        TITL   CRYSTAL STRUCTURE OF NITROGEN REGULATORY PROTEIN             
JRNL        TITL 2 FROM MYCOBACTERIUM TUBERCULOSIS                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.40 ANGSTROMS.                                          
DBREF  3BZQ A    1   112  UNP    P64249   GLNB_MYCTU       1    112             
SEQRES   1 A  114  GLY HIS MET LYS LEU ILE THR ALA ILE VAL LYS PRO PHE          
SEQRES   2 A  114  THR LEU ASP ASP VAL LYS THR SER LEU GLU ASP ALA GLY          
SEQRES   3 A  114  VAL LEU GLY MET THR VAL SER GLU ILE GLN GLY TYR GLY          
SEQRES   4 A  114  ARG GLN LYS GLY HIS THR GLU VAL TYR ARG GLY ALA GLU          
SEQRES   5 A  114  TYR SER VAL ASP PHE VAL PRO LYS VAL ARG ILE GLU VAL          
SEQRES   6 A  114  VAL VAL ASP ASP SER ILE VAL ASP LYS VAL VAL ASP SER          
SEQRES   7 A  114  ILE VAL ARG ALA ALA ARG THR GLY LYS ILE GLY ASP GLY          
SEQRES   8 A  114  LYS VAL TRP VAL SER PRO VAL ASP THR ILE VAL ARG VAL          
SEQRES   9 A  114  ARG THR GLY GLU ARG GLY HIS ASP ALA LEU                      
FORMUL   2  HOH   *136(H2 O)                                                    
CRYST1   77.149   77.149   51.840  90.00  90.00 120.00 H 3           9          
ATOM      1  N   GLY A  -1     -46.428   6.628  -6.244  1.00 20.63           N  
ATOM      2  CA  GLY A  -1     -44.937   6.656  -6.197  1.00 20.22           C  
ATOM      3  C   GLY A  -1     -44.351   6.657  -7.594  1.00 19.91           C  
ATOM      4  O   GLY A  -1     -43.831   7.673  -8.063  1.00 20.71           O  
ATOM      5  N   HIS A   0     -44.434   5.505  -8.254  1.00 19.01           N  
ATOM      6  CA  HIS A   0     -44.007   5.364  -9.639  1.00 17.92           C  
ATOM      7  C   HIS A   0     -45.197   5.465 -10.599  1.00 16.88           C  
ATOM      8  O   HIS A   0     -45.038   5.322 -11.809  1.00 17.36           O  
ATOM      9  CB  HIS A   0     -43.273   4.041  -9.828  1.00 18.27           C  
ATOM     10  N   MET A   1     -46.383   5.726 -10.055  1.00 15.23           N  
ATOM     11  CA  MET A   1     -47.611   5.738 -10.845  1.00 13.81           C  
ATOM     12  C   MET A   1     -47.894   7.096 -11.457  1.00 11.91           C  
ATOM     13  O   MET A   1     -47.699   8.124 -10.814  1.00 10.83           O  
ATOM     14  CB  MET A   1     -48.797   5.318  -9.979  1.00 14.39           C  
ATOM     15  CG  MET A   1     -48.656   3.943  -9.344  1.00 17.05           C  
ATOM     16  SD  MET A   1     -48.340   2.644 -10.549  1.00 22.59           S  
ATOM     17  CE  MET A   1     -49.569   3.050 -11.770  1.00 22.16           C  
ATOM     18  N   LYS A   2     -48.368   7.088 -12.702  1.00 10.43           N  
ATOM     19  CA  LYS A   2     -48.675   8.320 -13.425  1.00  9.57           C  
ATOM     20  C   LYS A   2     -50.030   8.243 -14.104  1.00  8.92           C  
ATOM     21  O   LYS A   2     -50.427   7.188 -14.599  1.00  8.99           O  
ATOM     22  CB  LYS A   2     -47.610   8.601 -14.489  1.00  9.84           C  
ATOM     23  CG  LYS A   2     -46.177   8.747 -13.967  1.00 10.21           C  
ATOM     24  CD  LYS A   2     -45.999   9.975 -13.082  1.00 10.45           C  
ATOM     25  CE  LYS A   2     -44.589  10.037 -12.509  1.00 12.76           C  
ATOM     26  NZ  LYS A   2     -44.471  11.174 -11.555  1.00 13.53           N  
ATOM     27  N   LEU A   3     -50.729   9.374 -14.122  1.00  7.85           N  
ATOM     28  CA  LEU A   3     -51.929   9.548 -14.937  1.00  7.54           C  
ATOM     29  C   LEU A   3     -51.540  10.234 -16.236  1.00  7.50           C  
ATOM     30  O   LEU A   3     -50.837  11.250 -16.223  1.00  7.60           O  
ATOM     31  CB  LEU A   3     -52.960  10.402 -14.193  1.00  7.44           C  
ATOM     32  CG  LEU A   3     -54.264  10.751 -14.918  1.00  7.27           C  
ATOM     33  CD1 LEU A   3     -55.141   9.521 -15.080  1.00  8.96           C  
ATOM     34  CD2 LEU A   3     -54.995  11.820 -14.141  1.00  7.14           C  
ATOM     35  N   ILE A   4     -51.973   9.659 -17.352  1.00  7.43           N  
ATOM     36  CA  ILE A   4     -51.852  10.306 -18.650  1.00  7.71           C  
ATOM     37  C   ILE A   4     -53.237  10.802 -19.036  1.00  7.37           C  
ATOM     38  O   ILE A   4     -54.196  10.025 -19.040  1.00  7.62           O  
ATOM     39  CB  ILE A   4     -51.310   9.349 -19.732  1.00  7.99           C  
ATOM     40  CG1 ILE A   4     -49.911   8.870 -19.355  1.00  9.00           C  
ATOM     41  CG2 ILE A   4     -51.278  10.042 -21.089  1.00  8.83           C  
ATOM     42  CD1 ILE A   4     -49.402   7.748 -20.210  1.00 11.28           C  
ATOM     43  N   THR A   5     -53.337  12.098 -19.320  1.00  7.61           N  
ATOM     44  CA  THR A   5     -54.567  12.706 -19.804  1.00  8.04           C  
ATOM     45  C   THR A   5     -54.335  13.219 -21.220  1.00  8.10           C  
ATOM     46  O   THR A   5     -53.435  14.023 -21.453  1.00  8.30           O  
ATOM     47  CB  THR A   5     -55.013  13.873 -18.905  1.00  8.15           C  
ATOM     48  OG1 THR A   5     -55.036  13.443 -17.538  1.00  7.94           O  
ATOM     49  CG2 THR A   5     -56.409  14.341 -19.290  1.00  8.70           C  
ATOM     50  N   ALA A   6     -55.145  12.742 -22.158  1.00  7.81           N  
ATOM     51  CA  ALA A   6     -55.052  13.165 -23.549  1.00  7.99           C  
ATOM     52  C   ALA A   6     -56.353  13.832 -23.964  1.00  8.09           C  
ATOM     53  O   ALA A   6     -57.427  13.242 -23.839  1.00  8.08           O  
ATOM     54  CB  ALA A   6     -54.755  11.978 -24.447  1.00  8.13           C  
ATOM     55  N   ILE A   7     -56.253  15.073 -24.431  1.00  8.36           N  
ATOM     56  CA  ILE A   7     -57.392  15.791 -24.993  1.00  9.04           C  
ATOM     57  C   ILE A   7     -57.185  15.782 -26.500  1.00  9.03           C  
ATOM     58  O   ILE A   7     -56.256  16.416 -27.001  1.00  9.78           O  
ATOM     59  CB  ILE A   7     -57.485  17.253 -24.480  1.00  9.33           C  
ATOM     60  CG1 ILE A   7     -57.303  17.342 -22.953  1.00 10.54           C  
ATOM     61  CG2 ILE A   7     -58.794  17.903 -24.942  1.00 10.16           C  
ATOM     62  CD1 ILE A   7     -58.252  16.492 -22.128  1.00 11.76           C  
ATOM     63  N   VAL A   8     -58.026  15.033 -27.209  1.00  9.21           N  
ATOM     64  CA  VAL A   8     -57.815  14.770 -28.635  1.00  9.88           C  
ATOM     65  C   VAL A   8     -59.136  14.828 -29.399  1.00 10.02           C  
ATOM     66  O   VAL A   8     -60.207  14.838 -28.798  1.00 10.13           O  
ATOM     67  CB  VAL A   8     -57.095  13.404 -28.865  1.00  9.86           C  
ATOM     68  CG1 VAL A   8     -55.708  13.404 -28.217  1.00 10.61           C  
ATOM     69  CG2 VAL A   8     -57.932  12.246 -28.341  1.00 10.01           C  
ATOM     70  N   LYS A   9     -59.052  14.870 -30.727  1.00 10.32           N  
ATOM     71  CA  LYS A   9     -60.252  14.923 -31.565  1.00 10.80           C  
ATOM     72  C   LYS A   9     -61.038  13.613 -31.457  1.00 10.99           C  
ATOM     73  O   LYS A   9     -60.440  12.542 -31.356  1.00 10.56           O  
ATOM     74  CB  LYS A   9     -59.882  15.250 -33.015  1.00 10.94           C  
ATOM     75  CG  LYS A   9     -59.490  16.711 -33.193  1.00 12.01           C  
ATOM     76  CD  LYS A   9     -58.757  16.996 -34.499  1.00 13.80           C  
ATOM     77  CE  LYS A   9     -58.485  18.487 -34.626  1.00 14.56           C  
ATOM     78  NZ  LYS A   9     -57.416  18.818 -35.608  1.00 14.31           N  
ATOM     79  N   PRO A  10     -62.384  13.691 -31.439  1.00 11.46           N  
ATOM     80  CA  PRO A  10     -63.187  12.494 -31.166  1.00 12.04           C  
ATOM     81  C   PRO A  10     -62.967  11.347 -32.148  1.00 12.39           C  
ATOM     82  O   PRO A  10     -63.036  10.185 -31.750  1.00 12.75           O  
ATOM     83  CB  PRO A  10     -64.628  13.008 -31.248  1.00 12.08           C  
ATOM     84  CG  PRO A  10     -64.521  14.468 -30.975  1.00 12.19           C  
ATOM     85  CD  PRO A  10     -63.236  14.879 -31.629  1.00 11.71           C  
ATOM     86  N   PHE A  11     -62.689  11.668 -33.409  1.00 12.64           N  
ATOM     87  CA  PHE A  11     -62.497  10.632 -34.426  1.00 12.88           C  
ATOM     88  C   PHE A  11     -61.184   9.851 -34.283  1.00 13.09           C  
ATOM     89  O   PHE A  11     -60.969   8.866 -34.989  1.00 13.62           O  
ATOM     90  CB  PHE A  11     -62.648  11.206 -35.842  1.00 13.19           C  
ATOM     91  CG  PHE A  11     -61.720  12.350 -36.153  1.00 13.21           C  
ATOM     92  CD1 PHE A  11     -62.180  13.663 -36.107  1.00 13.76           C  
ATOM     93  CD2 PHE A  11     -60.394  12.116 -36.519  1.00 13.99           C  
ATOM     94  CE1 PHE A  11     -61.327  14.726 -36.402  1.00 13.99           C  
ATOM     95  CE2 PHE A  11     -59.537  13.171 -36.812  1.00 14.36           C  
ATOM     96  CZ  PHE A  11     -60.005  14.475 -36.754  1.00 14.08           C  
ATOM     97  N   THR A  12     -60.319  10.277 -33.364  1.00 12.63           N  
ATOM     98  CA  THR A  12     -59.053   9.578 -33.128  1.00 12.63           C  
ATOM     99  C   THR A  12     -59.167   8.514 -32.036  1.00 12.57           C  
ATOM    100  O   THR A  12     -58.213   7.768 -31.795  1.00 12.15           O  
ATOM    101  CB  THR A  12     -57.897  10.551 -32.772  1.00 12.39           C  
ATOM    102  OG1 THR A  12     -58.090  11.085 -31.457  1.00 12.09           O  
ATOM    103  CG2 THR A  12     -57.801  11.685 -33.784  1.00 12.84           C  
ATOM    104  N   LEU A  13     -60.335   8.436 -31.396  1.00 13.02           N  
ATOM    105  CA  LEU A  13     -60.543   7.541 -30.250  1.00 13.64           C  
ATOM    106  C   LEU A  13     -60.189   6.085 -30.541  1.00 13.88           C  
ATOM    107  O   LEU A  13     -59.445   5.469 -29.779  1.00 13.66           O  
ATOM    108  CB  LEU A  13     -61.976   7.651 -29.709  1.00 13.89           C  
ATOM    109  CG  LEU A  13     -62.396   6.750 -28.537  1.00 13.82           C  
ATOM    110  CD1 LEU A  13     -61.490   6.917 -27.323  1.00 15.71           C  
ATOM    111  CD2 LEU A  13     -63.849   7.004 -28.162  1.00 14.52           C  
ATOM    112  N   ASP A  14     -60.724   5.537 -31.633  1.00 14.38           N  
ATOM    113  CA  ASP A  14     -60.460   4.145 -31.999  1.00 15.13           C  
ATOM    114  C   ASP A  14     -58.968   3.892 -32.192  1.00 14.67           C  
ATOM    115  O   ASP A  14     -58.443   2.882 -31.727  1.00 14.69           O  
ATOM    116  CB  ASP A  14     -61.222   3.752 -33.269  1.00 15.78           C  
ATOM    117  CG  ASP A  14     -62.732   3.714 -33.075  1.00 18.18           C  
ATOM    118  OD1 ASP A  14     -63.451   3.758 -34.095  1.00 21.28           O  
ATOM    119  OD2 ASP A  14     -63.206   3.637 -31.919  1.00 21.44           O  
ATOM    120  N   ASP A  15     -58.290   4.818 -32.868  1.00 14.50           N  
ATOM    121  CA  ASP A  15     -56.853   4.702 -33.104  1.00 14.64           C  
ATOM    122  C   ASP A  15     -56.045   4.735 -31.806  1.00 14.24           C  
ATOM    123  O   ASP A  15     -55.107   3.954 -31.637  1.00 14.07           O  
ATOM    124  CB  ASP A  15     -56.367   5.791 -34.066  1.00 15.13           C  
ATOM    125  CG  ASP A  15     -56.829   5.562 -35.500  1.00 16.91           C  
ATOM    126  OD1 ASP A  15     -57.426   4.504 -35.796  1.00 18.90           O  
ATOM    127  OD2 ASP A  15     -56.590   6.457 -36.333  1.00 19.54           O  
ATOM    128  N   VAL A  16     -56.413   5.630 -30.894  1.00 13.79           N  
ATOM    129  CA  VAL A  16     -55.743   5.721 -29.597  1.00 13.68           C  
ATOM    130  C   VAL A  16     -55.996   4.456 -28.772  1.00 14.03           C  
ATOM    131  O   VAL A  16     -55.061   3.887 -28.206  1.00 13.64           O  
ATOM    132  CB  VAL A  16     -56.170   6.985 -28.810  1.00 13.37           C  
ATOM    133  CG1 VAL A  16     -55.605   6.964 -27.391  1.00 13.08           C  
ATOM    134  CG2 VAL A  16     -55.714   8.248 -29.531  1.00 13.12           C  
ATOM    135  N   LYS A  17     -57.255   4.018 -28.734  1.00 14.54           N  
ATOM    136  CA  LYS A  17     -57.662   2.804 -28.024  1.00 15.65           C  
ATOM    137  C   LYS A  17     -56.896   1.586 -28.538  1.00 16.13           C  
ATOM    138  O   LYS A  17     -56.375   0.797 -27.746  1.00 16.33           O  
ATOM    139  CB  LYS A  17     -59.172   2.590 -28.166  1.00 15.79           C  
ATOM    140  CG  LYS A  17     -59.739   1.419 -27.372  1.00 16.64           C  
ATOM    141  CD  LYS A  17     -61.259   1.438 -27.409  1.00 18.47           C  
ATOM    142  CE  LYS A  17     -61.869   0.296 -26.611  1.00 19.89           C  
ATOM    143  NZ  LYS A  17     -61.677  -1.025 -27.272  1.00 20.87           N  
ATOM    144  N   THR A  18     -56.822   1.451 -29.862  1.00 16.67           N  
ATOM    145  CA  THR A  18     -56.090   0.354 -30.495  1.00 17.53           C  
ATOM    146  C   THR A  18     -54.612   0.381 -30.102  1.00 17.57           C  
ATOM    147  O   THR A  18     -54.050  -0.650 -29.732  1.00 17.91           O  
ATOM    148  CB  THR A  18     -56.260   0.370 -32.037  1.00 17.44           C  
ATOM    149  OG1 THR A  18     -57.651   0.253 -32.360  1.00 18.82           O  
ATOM    150  CG2 THR A  18     -55.500  -0.783 -32.695  1.00 17.88           C  
ATOM    151  N   SER A  19     -54.000   1.563 -30.169  1.00 17.81           N  
ATOM    152  CA  SER A  19     -52.597   1.746 -29.795  1.00 18.11           C  
ATOM    153  C   SER A  19     -52.320   1.374 -28.336  1.00 18.06           C  
ATOM    154  O   SER A  19     -51.291   0.764 -28.031  1.00 18.42           O  
ATOM    155  CB  SER A  19     -52.152   3.183 -30.065  1.00 18.20           C  
ATOM    156  OG  SER A  19     -52.115   3.446 -31.458  1.00 19.53           O  
ATOM    157  N   LEU A  20     -53.238   1.741 -27.445  1.00 17.95           N  
ATOM    158  CA  LEU A  20     -53.118   1.404 -26.028  1.00 17.94           C  
ATOM    159  C   LEU A  20     -53.279  -0.097 -25.797  1.00 18.31           C  
ATOM    160  O   LEU A  20     -52.448  -0.717 -25.130  1.00 18.17           O  
ATOM    161  CB  LEU A  20     -54.138   2.183 -25.191  1.00 17.50           C  
ATOM    162  CG  LEU A  20     -53.986   3.705 -25.065  1.00 16.94           C  
ATOM    163  CD1 LEU A  20     -55.194   4.303 -24.360  1.00 16.72           C  
ATOM    164  CD2 LEU A  20     -52.706   4.083 -24.339  1.00 16.97           C  
ATOM    165  N   GLU A  21     -54.340  -0.676 -26.359  1.00 18.82           N  
ATOM    166  CA  GLU A  21     -54.632  -2.102 -26.181  1.00 19.48           C  
ATOM    167  C   GLU A  21     -53.563  -3.016 -26.779  1.00 19.66           C  
ATOM    168  O   GLU A  21     -53.227  -4.045 -26.186  1.00 19.69           O  
ATOM    169  CB  GLU A  21     -56.014  -2.451 -26.737  1.00 19.37           C  
ATOM    170  CG  GLU A  21     -57.161  -1.927 -25.886  1.00 19.85           C  
ATOM    171  CD  GLU A  21     -58.522  -2.138 -26.521  1.00 19.98           C  
ATOM    172  OE1 GLU A  21     -59.529  -1.909 -25.821  1.00 20.76           O  
ATOM    173  OE2 GLU A  21     -58.594  -2.523 -27.708  1.00 21.63           O  
ATOM    174  N   ASP A  22     -53.029  -2.636 -27.941  1.00 19.99           N  
ATOM    175  CA  ASP A  22     -51.941  -3.385 -28.581  1.00 20.30           C  
ATOM    176  C   ASP A  22     -50.679  -3.411 -27.727  1.00 20.23           C  
ATOM    177  O   ASP A  22     -49.908  -4.368 -27.781  1.00 20.51           O  
ATOM    178  CB  ASP A  22     -51.609  -2.809 -29.961  1.00 20.69           C  
ATOM    179  CG  ASP A  22     -52.635  -3.180 -31.019  1.00 21.46           C  
ATOM    180  OD1 ASP A  22     -52.527  -2.650 -32.144  1.00 22.83           O  
ATOM    181  OD2 ASP A  22     -53.544  -3.990 -30.736  1.00 22.36           O  
ATOM    182  N   ALA A  23     -50.477  -2.351 -26.946  1.00 19.80           N  
ATOM    183  CA  ALA A  23     -49.322  -2.237 -26.059  1.00 19.47           C  
ATOM    184  C   ALA A  23     -49.627  -2.735 -24.643  1.00 19.14           C  
ATOM    185  O   ALA A  23     -48.840  -2.514 -23.720  1.00 19.30           O  
ATOM    186  CB  ALA A  23     -48.821  -0.797 -26.027  1.00 19.41           C  
ATOM    187  N   GLY A  24     -50.769  -3.400 -24.478  1.00 18.95           N  
ATOM    188  CA  GLY A  24     -51.171  -3.951 -23.186  1.00 18.60           C  
ATOM    189  C   GLY A  24     -51.453  -2.911 -22.115  1.00 18.39           C  
ATOM    190  O   GLY A  24     -51.344  -3.201 -20.923  1.00 18.41           O  
ATOM    191  N   VAL A  25     -51.814  -1.702 -22.543  1.00 18.10           N  
ATOM    192  CA  VAL A  25     -52.195  -0.628 -21.625  1.00 18.14           C  
ATOM    193  C   VAL A  25     -53.703  -0.670 -21.436  1.00 17.90           C  
ATOM    194  O   VAL A  25     -54.467  -0.265 -22.319  1.00 17.96           O  
ATOM    195  CB  VAL A  25     -51.747   0.766 -22.133  1.00 18.08           C  
ATOM    196  CG1 VAL A  25     -52.151   1.861 -21.144  1.00 18.64           C  
ATOM    197  CG2 VAL A  25     -50.241   0.787 -22.376  1.00 18.29           C  
ATOM    198  N   LEU A  26     -54.119  -1.170 -20.277  1.00 17.71           N  
ATOM    199  CA  LEU A  26     -55.526  -1.406 -20.000  1.00 17.59           C  
ATOM    200  C   LEU A  26     -56.129  -0.311 -19.126  1.00 17.04           C  
ATOM    201  O   LEU A  26     -55.410   0.516 -18.552  1.00 16.91           O  
ATOM    202  CB  LEU A  26     -55.711  -2.780 -19.337  1.00 17.99           C  
ATOM    203  CG  LEU A  26     -55.327  -4.032 -20.140  1.00 19.28           C  
ATOM    204  CD1 LEU A  26     -55.377  -5.267 -19.251  1.00 20.18           C  
ATOM    205  CD2 LEU A  26     -56.220  -4.214 -21.364  1.00 20.50           C  
ATOM    206  N   GLY A  27     -57.457  -0.303 -19.058  1.00 16.38           N  
ATOM    207  CA  GLY A  27     -58.186   0.544 -18.124  1.00 15.92           C  
ATOM    208  C   GLY A  27     -58.501   1.953 -18.582  1.00 15.53           C  
ATOM    209  O   GLY A  27     -58.869   2.794 -17.759  1.00 15.44           O  
ATOM    210  N   MET A  28     -58.385   2.223 -19.882  1.00 14.88           N  
ATOM    211  CA  MET A  28     -58.661   3.570 -20.387  1.00 14.88           C  
ATOM    212  C   MET A  28     -60.101   3.998 -20.125  1.00 13.55           C  
ATOM    213  O   MET A  28     -61.025   3.178 -20.135  1.00 13.16           O  
ATOM    214  CB  MET A  28     -58.293   3.733 -21.872  1.00 14.73           C  
ATOM    215  CG  MET A  28     -59.288   3.171 -22.881  1.00 15.92           C  
ATOM    216  SD  MET A  28     -59.148   3.964 -24.503  1.00 17.84           S  
ATOM    217  CE  MET A  28     -59.997   5.497 -24.187  1.00 19.08           C  
ATOM    218  N   THR A  29     -60.269   5.284 -19.845  1.00 12.50           N  
ATOM    219  CA  THR A  29     -61.594   5.878 -19.763  1.00 12.26           C  
ATOM    220  C   THR A  29     -61.676   7.018 -20.767  1.00 12.09           C  
ATOM    221  O   THR A  29     -60.646   7.546 -21.211  1.00 12.11           O  
ATOM    222  CB  THR A  29     -61.906   6.417 -18.361  1.00 12.36           C  
ATOM    223  OG1 THR A  29     -60.946   7.418 -18.014  1.00 12.68           O  
ATOM    224  CG2 THR A  29     -61.893   5.296 -17.314  1.00 12.45           C  
ATOM    225  N   VAL A  30     -62.900   7.379 -21.136  1.00 11.51           N  
ATOM    226  CA  VAL A  30     -63.147   8.475 -22.070  1.00 11.74           C  
ATOM    227  C   VAL A  30     -64.273   9.351 -21.540  1.00 11.01           C  
ATOM    228  O   VAL A  30     -65.301   8.845 -21.069  1.00 10.78           O  
ATOM    229  CB  VAL A  30     -63.526   7.973 -23.490  1.00 12.04           C  
ATOM    230  CG1 VAL A  30     -63.414   9.101 -24.514  1.00 12.75           C  
ATOM    231  CG2 VAL A  30     -62.673   6.797 -23.903  1.00 14.44           C  
ATOM    232  N   SER A  31     -64.074  10.661 -21.644  1.00 10.80           N  
ATOM    233  CA  SER A  31     -65.062  11.657 -21.240  1.00 10.97           C  
ATOM    234  C   SER A  31     -65.206  12.697 -22.346  1.00 10.97           C  
ATOM    235  O   SER A  31     -64.278  12.907 -23.127  1.00 10.16           O  
ATOM    236  CB  SER A  31     -64.623  12.354 -19.939  1.00 11.29           C  
ATOM    237  OG  SER A  31     -64.196  11.424 -18.956  1.00 13.66           O  
ATOM    238  N   GLU A  32     -66.362  13.353 -22.400  1.00 11.14           N  
ATOM    239  CA  GLU A  32     -66.589  14.455 -23.331  1.00 11.98           C  
ATOM    240  C   GLU A  32     -65.947  15.731 -22.802  1.00 11.67           C  
ATOM    241  O   GLU A  32     -65.922  15.974 -21.594  1.00 11.59           O  
ATOM    242  CB  GLU A  32     -68.087  14.703 -23.547  1.00 12.40           C  
ATOM    243  CG  GLU A  32     -68.922  13.468 -23.901  1.00 15.09           C  
ATOM    244  CD  GLU A  32     -68.722  12.961 -25.323  1.00 18.09           C  
ATOM    245  OE1 GLU A  32     -67.784  13.406 -26.019  1.00 19.86           O  
ATOM    246  OE2 GLU A  32     -69.518  12.095 -25.747  1.00 21.10           O  
ATOM    247  N   ILE A  33     -65.444  16.551 -23.717  1.00 11.38           N  
ATOM    248  CA  ILE A  33     -64.771  17.798 -23.364  1.00 12.09           C  
ATOM    249  C   ILE A  33     -64.835  18.752 -24.558  1.00 12.46           C  
ATOM    250  O   ILE A  33     -65.027  18.317 -25.696  1.00 12.48           O  
ATOM    251  CB  ILE A  33     -63.304  17.521 -22.892  1.00 11.87           C  
ATOM    252  CG1 ILE A  33     -62.682  18.740 -22.202  1.00 12.17           C  
ATOM    253  CG2 ILE A  33     -62.437  17.001 -24.037  1.00 12.45           C  
ATOM    254  CD1 ILE A  33     -61.457  18.394 -21.368  1.00 12.30           C  
ATOM    255  N   GLN A  34     -64.708  20.045 -24.288  1.00 13.20           N  
ATOM    256  CA  GLN A  34     -64.671  21.061 -25.337  1.00 14.49           C  
ATOM    257  C   GLN A  34     -63.349  21.811 -25.273  1.00 14.63           C  
ATOM    258  O   GLN A  34     -62.909  22.209 -24.194  1.00 14.24           O  
ATOM    259  CB  GLN A  34     -65.830  22.046 -25.169  1.00 14.41           C  
ATOM    260  CG  GLN A  34     -67.218  21.414 -25.247  1.00 16.14           C  
ATOM    261  CD  GLN A  34     -68.327  22.362 -24.822  1.00 16.54           C  
ATOM    262  OE1 GLN A  34     -68.199  23.582 -24.936  1.00 19.94           O  
ATOM    263  NE2 GLN A  34     -69.424  21.800 -24.329  1.00 19.52           N  
ATOM    264  N   GLY A  35     -62.714  21.996 -26.427  1.00 15.14           N  
ATOM    265  CA  GLY A  35     -61.454  22.734 -26.504  1.00 16.17           C  
ATOM    266  C   GLY A  35     -61.374  23.573 -27.763  1.00 16.96           C  
ATOM    267  O   GLY A  35     -62.242  23.477 -28.631  1.00 16.87           O  
ATOM    268  N   TYR A  36     -60.326  24.389 -27.869  1.00 17.85           N  
ATOM    269  CA  TYR A  36     -60.145  25.272 -29.026  1.00 18.80           C  
ATOM    270  C   TYR A  36     -59.957  24.494 -30.328  1.00 19.28           C  
ATOM    271  O   TYR A  36     -59.209  23.516 -30.382  1.00 19.16           O  
ATOM    272  CB  TYR A  36     -58.946  26.200 -28.823  1.00 19.13           C  
ATOM    273  CG  TYR A  36     -59.135  27.295 -27.797  1.00 19.63           C  
ATOM    274  CD1 TYR A  36     -59.667  28.535 -28.157  1.00 19.91           C  
ATOM    275  CD2 TYR A  36     -58.753  27.103 -26.470  1.00 19.99           C  
ATOM    276  CE1 TYR A  36     -59.829  29.551 -27.213  1.00 20.04           C  
ATOM    277  CE2 TYR A  36     -58.906  28.108 -25.524  1.00 20.00           C  
ATOM    278  CZ  TYR A  36     -59.445  29.327 -25.897  1.00 19.71           C  
ATOM    279  OH  TYR A  36     -59.593  30.318 -24.952  1.00 19.77           O  
ATOM    280  N   GLY A  37     -60.638  24.947 -31.375  1.00 20.06           N  
ATOM    281  CA  GLY A  37     -60.526  24.337 -32.697  1.00 21.19           C  
ATOM    282  C   GLY A  37     -61.282  25.101 -33.765  1.00 21.85           C  
ATOM    283  O   GLY A  37     -61.912  26.124 -33.482  1.00 22.27           O  
ATOM    284  N   ARG A  38     -61.218  24.594 -34.994  1.00 22.44           N  
ATOM    285  CA  ARG A  38     -61.884  25.222 -36.134  1.00 22.90           C  
ATOM    286  C   ARG A  38     -63.202  24.528 -36.460  1.00 23.15           C  
ATOM    287  O   ARG A  38     -64.277  25.074 -36.207  1.00 23.68           O  
ATOM    288  CB  ARG A  38     -60.968  25.225 -37.348  1.00 22.92           C  
ATOM    289  N   ASP A  54     -63.112  29.948 -29.895  1.00 22.85           N  
ATOM    290  CA  ASP A  54     -64.259  29.112 -30.231  1.00 22.61           C  
ATOM    291  C   ASP A  54     -63.938  27.633 -30.038  1.00 21.98           C  
ATOM    292  O   ASP A  54     -62.848  27.167 -30.389  1.00 21.96           O  
ATOM    293  CB  ASP A  54     -64.725  29.373 -31.666  1.00 23.23           C  
ATOM    294  CG  ASP A  54     -66.053  28.702 -31.978  1.00 23.96           C  
ATOM    295  OD1 ASP A  54     -66.109  27.923 -32.953  1.00 26.21           O  
ATOM    296  OD2 ASP A  54     -67.036  28.943 -31.241  1.00 25.99           O  
ATOM    297  N   PHE A  55     -64.903  26.902 -29.488  1.00 21.20           N  
ATOM    298  CA  PHE A  55     -64.683  25.517 -29.082  1.00 20.27           C  
ATOM    299  C   PHE A  55     -65.225  24.480 -30.063  1.00 19.47           C  
ATOM    300  O   PHE A  55     -66.203  24.720 -30.781  1.00 19.58           O  
ATOM    301  CB  PHE A  55     -65.267  25.258 -27.686  1.00 20.44           C  
ATOM    302  CG  PHE A  55     -64.622  26.065 -26.585  1.00 20.81           C  
ATOM    303  CD1 PHE A  55     -63.258  26.357 -26.606  1.00 21.27           C  
ATOM    304  CD2 PHE A  55     -65.381  26.509 -25.506  1.00 21.66           C  
ATOM    305  CE1 PHE A  55     -62.670  27.096 -25.582  1.00 21.30           C  
ATOM    306  CE2 PHE A  55     -64.802  27.246 -24.479  1.00 21.55           C  
ATOM    307  CZ  PHE A  55     -63.443  27.537 -24.516  1.00 20.97           C  
ATOM    308  N   VAL A  56     -64.566  23.326 -30.074  1.00 18.28           N  
ATOM    309  CA  VAL A  56     -65.033  22.150 -30.798  1.00 17.02           C  
ATOM    310  C   VAL A  56     -65.096  20.970 -29.825  1.00 15.97           C  
ATOM    311  O   VAL A  56     -64.391  20.971 -28.805  1.00 15.22           O  
ATOM    312  CB  VAL A  56     -64.127  21.800 -32.019  1.00 17.25           C  
ATOM    313  CG1 VAL A  56     -64.162  22.917 -33.063  1.00 17.56           C  
ATOM    314  CG2 VAL A  56     -62.692  21.494 -31.591  1.00 17.44           C  
ATOM    315  N   PRO A  57     -65.951  19.970 -30.114  1.00 14.98           N  
ATOM    316  CA  PRO A  57     -65.974  18.765 -29.291  1.00 14.30           C  
ATOM    317  C   PRO A  57     -64.654  18.009 -29.367  1.00 13.32           C  
ATOM    318  O   PRO A  57     -64.072  17.863 -30.443  1.00 13.11           O  
ATOM    319  CB  PRO A  57     -67.096  17.923 -29.916  1.00 14.44           C  
ATOM    320  CG  PRO A  57     -67.909  18.880 -30.717  1.00 15.49           C  
ATOM    321  CD  PRO A  57     -66.951  19.913 -31.199  1.00 15.24           C  
ATOM    322  N   LYS A  58     -64.182  17.560 -28.214  1.00 12.22           N  
ATOM    323  CA  LYS A  58     -63.011  16.703 -28.129  1.00 11.36           C  
ATOM    324  C   LYS A  58     -63.320  15.578 -27.148  1.00 10.54           C  
ATOM    325  O   LYS A  58     -64.412  15.527 -26.574  1.00 10.28           O  
ATOM    326  CB  LYS A  58     -61.773  17.505 -27.701  1.00 11.38           C  
ATOM    327  CG  LYS A  58     -61.387  18.582 -28.708  1.00 12.00           C  
ATOM    328  CD  LYS A  58     -60.059  19.230 -28.410  1.00 13.02           C  
ATOM    329  CE  LYS A  58     -59.895  20.472 -29.266  1.00 13.45           C  
ATOM    330  NZ  LYS A  58     -58.527  21.040 -29.173  1.00 14.14           N  
ATOM    331  N   VAL A  59     -62.371  14.668 -26.966  1.00  9.63           N  
ATOM    332  CA  VAL A  59     -62.510  13.636 -25.945  1.00  9.75           C  
ATOM    333  C   VAL A  59     -61.326  13.685 -24.991  1.00  9.18           C  
ATOM    334  O   VAL A  59     -60.214  14.062 -25.379  1.00  9.50           O  
ATOM    335  CB  VAL A  59     -62.701  12.209 -26.538  1.00  9.86           C  
ATOM    336  CG1 VAL A  59     -64.025  12.105 -27.299  1.00 10.78           C  
ATOM    337  CG2 VAL A  59     -61.522  11.800 -27.414  1.00 10.18           C  
ATOM    338  N   ARG A  60     -61.595  13.329 -23.739  1.00  8.71           N  
ATOM    339  CA  ARG A  60     -60.593  13.253 -22.692  1.00  8.53           C  
ATOM    340  C   ARG A  60     -60.332  11.781 -22.405  1.00  8.18           C  
ATOM    341  O   ARG A  60     -61.194  11.098 -21.852  1.00  8.60           O  
ATOM    342  CB  ARG A  60     -61.115  13.935 -21.429  1.00  8.46           C  
ATOM    343  CG  ARG A  60     -60.151  13.927 -20.253  1.00  9.12           C  
ATOM    344  CD  ARG A  60     -60.888  14.081 -18.929  1.00  8.77           C  
ATOM    345  NE  ARG A  60     -59.982  14.580 -17.899  1.00 10.52           N  
ATOM    346  CZ  ARG A  60     -59.802  15.867 -17.620  1.00 10.71           C  
ATOM    347  NH1 ARG A  60     -60.492  16.799 -18.268  1.00 11.54           N  
ATOM    348  NH2 ARG A  60     -58.939  16.219 -16.682  1.00 10.90           N  
ATOM    349  N   ILE A  61     -59.147  11.307 -22.781  1.00  7.94           N  
ATOM    350  CA  ILE A  61     -58.752   9.914 -22.591  1.00  8.39           C  
ATOM    351  C   ILE A  61     -57.762   9.849 -21.429  1.00  8.04           C  
ATOM    352  O   ILE A  61     -56.786  10.599 -21.406  1.00  8.22           O  
ATOM    353  CB  ILE A  61     -58.121   9.344 -23.884  1.00  8.48           C  
ATOM    354  CG1 ILE A  61     -59.156   9.335 -25.019  1.00  9.11           C  
ATOM    355  CG2 ILE A  61     -57.541   7.947 -23.646  1.00  9.20           C  
ATOM    356  CD1 ILE A  61     -58.582   9.061 -26.402  1.00  9.44           C  
ATOM    357  N   GLU A  62     -58.019   8.962 -20.469  1.00  7.76           N  
ATOM    358  CA  GLU A  62     -57.163   8.827 -19.289  1.00  7.95           C  
ATOM    359  C   GLU A  62     -56.744   7.387 -19.072  1.00  7.90           C  
ATOM    360  O   GLU A  62     -57.562   6.473 -19.190  1.00  7.95           O  
ATOM    361  CB  GLU A  62     -57.885   9.329 -18.038  1.00  8.12           C  
ATOM    362  CG  GLU A  62     -58.064  10.840 -18.005  1.00  8.40           C  
ATOM    363  CD  GLU A  62     -59.111  11.301 -17.007  1.00 10.56           C  
ATOM    364  OE1 GLU A  62     -58.807  12.212 -16.210  1.00 10.20           O  
ATOM    365  OE2 GLU A  62     -60.239  10.767 -17.019  1.00 11.39           O  
ATOM    366  N   VAL A  63     -55.461   7.195 -18.775  1.00  8.17           N  
ATOM    367  CA  VAL A  63     -54.939   5.907 -18.324  1.00  8.81           C  
ATOM    368  C   VAL A  63     -53.970   6.131 -17.177  1.00  8.79           C  
ATOM    369  O   VAL A  63     -53.301   7.160 -17.114  1.00  8.79           O  
ATOM    370  CB  VAL A  63     -54.201   5.111 -19.444  1.00  9.08           C  
ATOM    371  CG1 VAL A  63     -55.169   4.583 -20.476  1.00  9.96           C  
ATOM    372  CG2 VAL A  63     -53.106   5.937 -20.105  1.00  9.61           C  
ATOM    373  N   VAL A  64     -53.911   5.162 -16.272  1.00  9.11           N  
ATOM    374  CA  VAL A  64     -52.915   5.146 -15.207  1.00  9.64           C  
ATOM    375  C   VAL A  64     -51.880   4.072 -15.531  1.00  9.87           C  
ATOM    376  O   VAL A  64     -52.225   2.919 -15.796  1.00 10.51           O  
ATOM    377  CB  VAL A  64     -53.560   4.902 -13.821  1.00  9.54           C  
ATOM    378  CG1 VAL A  64     -52.503   4.830 -12.727  1.00 10.69           C  
ATOM    379  CG2 VAL A  64     -54.570   5.999 -13.500  1.00 10.60           C  
ATOM    380  N   VAL A  65     -50.613   4.469 -15.545  1.00  9.88           N  
ATOM    381  CA  VAL A  65     -49.523   3.566 -15.914  1.00 10.55           C  
ATOM    382  C   VAL A  65     -48.354   3.715 -14.951  1.00 10.78           C  
ATOM    383  O   VAL A  65     -48.237   4.717 -14.244  1.00 10.78           O  
ATOM    384  CB  VAL A  65     -49.012   3.812 -17.376  1.00 10.58           C  
ATOM    385  CG1 VAL A  65     -50.107   3.532 -18.404  1.00 11.52           C  
ATOM    386  CG2 VAL A  65     -48.449   5.228 -17.550  1.00 11.55           C  
ATOM    387  N   ASP A  66     -47.497   2.702 -14.927  1.00 11.18           N  
ATOM    388  CA  ASP A  66     -46.219   2.787 -14.239  1.00 11.57           C  
ATOM    389  C   ASP A  66     -45.314   3.730 -15.021  1.00 11.86           C  
ATOM    390  O   ASP A  66     -45.413   3.812 -16.245  1.00 11.59           O  
ATOM    391  CB  ASP A  66     -45.593   1.397 -14.155  1.00 11.83           C  
ATOM    392  CG  ASP A  66     -44.297   1.386 -13.381  1.00 12.41           C  
ATOM    393  OD1 ASP A  66     -44.342   1.482 -12.139  1.00 14.73           O  
ATOM    394  OD2 ASP A  66     -43.233   1.283 -14.024  1.00 12.95           O  
ATOM    395  N   ASP A  67     -44.434   4.447 -14.323  1.00 12.41           N  
ATOM    396  CA  ASP A  67     -43.572   5.423 -14.998  1.00 13.23           C  
ATOM    397  C   ASP A  67     -42.576   4.801 -15.991  1.00 13.55           C  
ATOM    398  O   ASP A  67     -42.007   5.511 -16.820  1.00 13.98           O  
ATOM    399  CB  ASP A  67     -42.895   6.392 -14.007  1.00 14.05           C  
ATOM    400  CG  ASP A  67     -41.954   5.702 -13.029  1.00 15.23           C  
ATOM    401  OD1 ASP A  67     -41.699   4.487 -13.155  1.00 17.84           O  
ATOM    402  OD2 ASP A  67     -41.459   6.400 -12.120  1.00 17.50           O  
ATOM    403  N   SER A  68     -42.398   3.480 -15.926  1.00 13.46           N  
ATOM    404  CA  SER A  68     -41.546   2.762 -16.881  1.00 13.53           C  
ATOM    405  C   SER A  68     -42.017   2.905 -18.327  1.00 13.51           C  
ATOM    406  O   SER A  68     -41.203   2.899 -19.257  1.00 14.11           O  
ATOM    407  CB  SER A  68     -41.435   1.277 -16.515  1.00 13.34           C  
ATOM    408  OG  SER A  68     -42.684   0.608 -16.586  1.00 14.11           O  
ATOM    409  N   ILE A  69     -43.327   3.029 -18.515  1.00 13.14           N  
ATOM    410  CA  ILE A  69     -43.897   3.106 -19.859  1.00 12.93           C  
ATOM    411  C   ILE A  69     -44.517   4.461 -20.201  1.00 12.79           C  
ATOM    412  O   ILE A  69     -44.990   4.646 -21.318  1.00 12.45           O  
ATOM    413  CB  ILE A  69     -44.927   1.969 -20.133  1.00 12.76           C  
ATOM    414  CG1 ILE A  69     -46.151   2.083 -19.213  1.00 13.10           C  
ATOM    415  CG2 ILE A  69     -44.264   0.600 -20.008  1.00 13.09           C  
ATOM    416  CD1 ILE A  69     -47.303   1.157 -19.598  1.00 12.92           C  
ATOM    417  N   VAL A  70     -44.493   5.406 -19.264  1.00 13.04           N  
ATOM    418  CA  VAL A  70     -45.205   6.676 -19.458  1.00 13.66           C  
ATOM    419  C   VAL A  70     -44.770   7.415 -20.736  1.00 13.97           C  
ATOM    420  O   VAL A  70     -45.621   7.865 -21.505  1.00 13.57           O  
ATOM    421  CB  VAL A  70     -45.203   7.576 -18.169  1.00 13.73           C  
ATOM    422  CG1 VAL A  70     -43.835   8.207 -17.905  1.00 14.63           C  
ATOM    423  CG2 VAL A  70     -46.298   8.634 -18.244  1.00 14.38           C  
ATOM    424  N   ASP A  71     -43.463   7.492 -20.983  1.00 14.71           N  
ATOM    425  CA  ASP A  71     -42.940   8.178 -22.168  1.00 15.43           C  
ATOM    426  C   ASP A  71     -43.432   7.571 -23.475  1.00 15.16           C  
ATOM    427  O   ASP A  71     -43.894   8.295 -24.363  1.00 15.28           O  
ATOM    428  CB  ASP A  71     -41.408   8.205 -22.162  1.00 16.34           C  
ATOM    429  CG  ASP A  71     -40.840   9.238 -21.208  1.00 18.31           C  
ATOM    430  OD1 ASP A  71     -41.612  10.043 -20.642  1.00 20.37           O  
ATOM    431  OD2 ASP A  71     -39.603   9.245 -21.028  1.00 21.16           O  
ATOM    432  N   LYS A  72     -43.336   6.251 -23.599  1.00 14.84           N  
ATOM    433  CA  LYS A  72     -43.754   5.603 -24.839  1.00 14.75           C  
ATOM    434  C   LYS A  72     -45.271   5.589 -25.023  1.00 13.94           C  
ATOM    435  O   LYS A  72     -45.754   5.665 -26.151  1.00 13.84           O  
ATOM    436  CB  LYS A  72     -43.139   4.207 -25.006  1.00 15.56           C  
ATOM    437  CG  LYS A  72     -43.628   3.156 -24.048  1.00 17.08           C  
ATOM    438  CD  LYS A  72     -43.006   1.817 -24.388  1.00 20.03           C  
ATOM    439  CE  LYS A  72     -42.757   1.004 -23.139  1.00 21.10           C  
ATOM    440  NZ  LYS A  72     -41.671   1.608 -22.315  1.00 22.27           N  
ATOM    441  N   VAL A  73     -46.019   5.506 -23.924  1.00 12.86           N  
ATOM    442  CA  VAL A  73     -47.476   5.590 -24.005  1.00 12.08           C  
ATOM    443  C   VAL A  73     -47.909   6.985 -24.481  1.00 11.55           C  
ATOM    444  O   VAL A  73     -48.744   7.105 -25.382  1.00 10.99           O  
ATOM    445  CB  VAL A  73     -48.170   5.181 -22.678  1.00 11.93           C  
ATOM    446  CG1 VAL A  73     -49.673   5.378 -22.778  1.00 12.37           C  
ATOM    447  CG2 VAL A  73     -47.865   3.723 -22.345  1.00 12.59           C  
ATOM    448  N   VAL A  74     -47.307   8.030 -23.911  1.00 11.13           N  
ATOM    449  CA  VAL A  74     -47.575   9.403 -24.359  1.00 11.23           C  
ATOM    450  C   VAL A  74     -47.278   9.534 -25.855  1.00 11.61           C  
ATOM    451  O   VAL A  74     -48.112  10.021 -26.620  1.00 11.42           O  
ATOM    452  CB  VAL A  74     -46.782  10.453 -23.536  1.00 10.79           C  
ATOM    453  CG1 VAL A  74     -46.800  11.822 -24.220  1.00 10.80           C  
ATOM    454  CG2 VAL A  74     -47.348  10.563 -22.126  1.00 11.28           C  
ATOM    455  N   ASP A  75     -46.100   9.071 -26.271  1.00 12.20           N  
ATOM    456  CA  ASP A  75     -45.713   9.135 -27.679  1.00 13.17           C  
ATOM    457  C   ASP A  75     -46.669   8.361 -28.588  1.00 12.99           C  
ATOM    458  O   ASP A  75     -46.984   8.821 -29.687  1.00 13.35           O  
ATOM    459  CB  ASP A  75     -44.272   8.653 -27.874  1.00 13.84           C  
ATOM    460  CG  ASP A  75     -43.243   9.611 -27.287  1.00 16.11           C  
ATOM    461  OD1 ASP A  75     -42.058   9.219 -27.210  1.00 19.27           O  
ATOM    462  OD2 ASP A  75     -43.605  10.746 -26.903  1.00 19.16           O  
ATOM    463  N   SER A  76     -47.144   7.204 -28.127  1.00 12.81           N  
ATOM    464  CA  SER A  76     -48.088   6.401 -28.907  1.00 12.82           C  
ATOM    465  C   SER A  76     -49.433   7.111 -29.071  1.00 12.17           C  
ATOM    466  O   SER A  76     -50.019   7.098 -30.152  1.00 11.67           O  
ATOM    467  CB  SER A  76     -48.269   5.002 -28.302  1.00 13.15           C  
ATOM    468  OG  SER A  76     -49.092   5.019 -27.150  1.00 16.25           O  
ATOM    469  N   ILE A  77     -49.912   7.744 -28.003  1.00 11.43           N  
ATOM    470  CA  ILE A  77     -51.150   8.522 -28.075  1.00 11.49           C  
ATOM    471  C   ILE A  77     -50.991   9.699 -29.040  1.00 11.60           C  
ATOM    472  O   ILE A  77     -51.833   9.893 -29.917  1.00 11.38           O  
ATOM    473  CB  ILE A  77     -51.621   9.010 -26.682  1.00 11.16           C  
ATOM    474  CG1 ILE A  77     -51.946   7.817 -25.775  1.00 11.22           C  
ATOM    475  CG2 ILE A  77     -52.835   9.928 -26.815  1.00 11.32           C  
ATOM    476  CD1 ILE A  77     -52.124   8.189 -24.308  1.00 11.44           C  
ATOM    477  N   VAL A  78     -49.904  10.454 -28.884  1.00 11.93           N  
ATOM    478  CA  VAL A  78     -49.618  11.606 -29.743  1.00 12.71           C  
ATOM    479  C   VAL A  78     -49.591  11.199 -31.220  1.00 13.09           C  
ATOM    480  O   VAL A  78     -50.234  11.841 -32.053  1.00 13.40           O  
ATOM    481  CB  VAL A  78     -48.302  12.315 -29.326  1.00 12.69           C  
ATOM    482  CG1 VAL A  78     -47.865  13.330 -30.376  1.00 13.46           C  
ATOM    483  CG2 VAL A  78     -48.469  13.002 -27.980  1.00 12.94           C  
ATOM    484  N   ARG A  79     -48.871  10.122 -31.537  1.00 13.44           N  
ATOM    485  CA  ARG A  79     -48.778   9.634 -32.914  1.00 14.03           C  
ATOM    486  C   ARG A  79     -50.132   9.228 -33.478  1.00 13.72           C  
ATOM    487  O   ARG A  79     -50.422   9.498 -34.645  1.00 14.09           O  
ATOM    488  CB  ARG A  79     -47.808   8.456 -33.029  1.00 14.37           C  
ATOM    489  CG  ARG A  79     -46.337   8.821 -32.930  1.00 16.69           C  
ATOM    490  CD  ARG A  79     -45.442   7.677 -33.416  1.00 19.90           C  
ATOM    491  NE  ARG A  79     -46.015   6.354 -33.153  1.00 22.27           N  
ATOM    492  CZ  ARG A  79     -45.853   5.657 -32.030  1.00 23.13           C  
ATOM    493  NH1 ARG A  79     -46.429   4.468 -31.907  1.00 24.26           N  
ATOM    494  NH2 ARG A  79     -45.124   6.137 -31.029  1.00 23.70           N  
ATOM    495  N   ALA A  80     -50.953   8.580 -32.653  1.00 12.93           N  
ATOM    496  CA  ALA A  80     -52.265   8.093 -33.078  1.00 12.51           C  
ATOM    497  C   ALA A  80     -53.302   9.206 -33.236  1.00 12.28           C  
ATOM    498  O   ALA A  80     -54.240   9.076 -34.025  1.00 12.65           O  
ATOM    499  CB  ALA A  80     -52.777   7.027 -32.117  1.00 12.58           C  
ATOM    500  N   ALA A  81     -53.126  10.294 -32.487  1.00 11.63           N  
ATOM    501  CA  ALA A  81     -54.101  11.387 -32.466  1.00 11.58           C  
ATOM    502  C   ALA A  81     -53.753  12.556 -33.388  1.00 11.49           C  
ATOM    503  O   ALA A  81     -54.600  13.410 -33.654  1.00 11.67           O  
ATOM    504  CB  ALA A  81     -54.304  11.883 -31.042  1.00 11.48           C  
ATOM    505  N   ARG A  82     -52.515  12.594 -33.871  1.00 11.42           N  
ATOM    506  CA  ARG A  82     -52.050  13.694 -34.716  1.00 11.92           C  
ATOM    507  C   ARG A  82     -52.733  13.694 -36.080  1.00 12.11           C  
ATOM    508  O   ARG A  82     -52.910  12.637 -36.691  1.00 12.22           O  
ATOM    509  CB  ARG A  82     -50.537  13.617 -34.895  1.00 12.06           C  
ATOM    510  CG  ARG A  82     -49.956  14.721 -35.774  1.00 12.35           C  
ATOM    511  CD  ARG A  82     -48.443  14.653 -35.789  1.00 13.17           C  
ATOM    512  NE  ARG A  82     -47.887  15.074 -34.505  1.00 14.00           N  
ATOM    513  CZ  ARG A  82     -46.787  14.577 -33.949  1.00 15.23           C  
ATOM    514  NH1 ARG A  82     -46.383  15.044 -32.780  1.00 15.17           N  
ATOM    515  NH2 ARG A  82     -46.093  13.613 -34.544  1.00 17.06           N  
ATOM    516  N   THR A  83     -53.133  14.881 -36.536  1.00 12.43           N  
ATOM    517  CA  THR A  83     -53.606  15.071 -37.913  1.00 13.09           C  
ATOM    518  C   THR A  83     -52.778  16.136 -38.626  1.00 13.61           C  
ATOM    519  O   THR A  83     -52.815  16.240 -39.855  1.00 13.87           O  
ATOM    520  CB  THR A  83     -55.104  15.479 -37.993  1.00 13.14           C  
ATOM    521  OG1 THR A  83     -55.268  16.834 -37.553  1.00 12.96           O  
ATOM    522  CG2 THR A  83     -55.989  14.555 -37.163  1.00 13.55           C  
ATOM    523  N   GLY A  84     -52.041  16.930 -37.851  1.00 13.88           N  
ATOM    524  CA  GLY A  84     -51.265  18.046 -38.384  1.00 14.66           C  
ATOM    525  C   GLY A  84     -52.063  19.337 -38.457  1.00 15.22           C  
ATOM    526  O   GLY A  84     -51.532  20.371 -38.855  1.00 15.49           O  
ATOM    527  N   LYS A  85     -53.333  19.278 -38.060  1.00 15.69           N  
ATOM    528  CA  LYS A  85     -54.226  20.432 -38.116  1.00 16.39           C  
ATOM    529  C   LYS A  85     -54.427  21.058 -36.739  1.00 16.30           C  
ATOM    530  O   LYS A  85     -54.233  20.403 -35.708  1.00 16.31           O  
ATOM    531  CB  LYS A  85     -55.582  20.034 -38.707  1.00 16.26           C  
ATOM    532  CG  LYS A  85     -55.524  19.560 -40.161  1.00 16.99           C  
ATOM    533  CD  LYS A  85     -56.849  18.953 -40.614  1.00 17.68           C  
ATOM    534  CE  LYS A  85     -57.898  20.023 -40.891  1.00 19.62           C  
ATOM    535  NZ  LYS A  85     -59.200  19.433 -41.312  1.00 21.07           N  
ATOM    536  N   ILE A  86     -54.818  22.328 -36.734  1.00 16.32           N  
ATOM    537  CA  ILE A  86     -55.136  23.040 -35.502  1.00 16.47           C  
ATOM    538  C   ILE A  86     -56.215  22.295 -34.714  1.00 15.72           C  
ATOM    539  O   ILE A  86     -57.148  21.722 -35.289  1.00 15.82           O  
ATOM    540  CB  ILE A  86     -55.556  24.518 -35.781  1.00 16.71           C  
ATOM    541  CG1 ILE A  86     -55.365  25.393 -34.537  1.00 17.77           C  
ATOM    542  CG2 ILE A  86     -56.985  24.610 -36.324  1.00 17.31           C  
ATOM    543  CD1 ILE A  86     -53.918  25.736 -34.229  1.00 19.07           C  
ATOM    544  N   GLY A  87     -56.057  22.281 -33.394  1.00 15.24           N  
ATOM    545  CA  GLY A  87     -57.030  21.653 -32.514  1.00 14.28           C  
ATOM    546  C   GLY A  87     -56.748  20.202 -32.172  1.00 13.37           C  
ATOM    547  O   GLY A  87     -57.566  19.562 -31.516  1.00 13.31           O  
ATOM    548  N   ASP A  88     -55.600  19.684 -32.614  1.00 12.19           N  
ATOM    549  CA  ASP A  88     -55.197  18.293 -32.357  1.00 11.52           C  
ATOM    550  C   ASP A  88     -55.133  17.930 -30.871  1.00 11.07           C  
ATOM    551  O   ASP A  88     -55.215  16.756 -30.510  1.00 10.75           O  
ATOM    552  CB  ASP A  88     -53.841  17.995 -33.002  1.00 11.40           C  
ATOM    553  CG  ASP A  88     -53.955  17.503 -34.436  1.00 11.17           C  
ATOM    554  OD1 ASP A  88     -55.079  17.427 -34.983  1.00 11.97           O  
ATOM    555  OD2 ASP A  88     -52.894  17.182 -35.007  1.00 11.06           O  
ATOM    556  N   GLY A  89     -54.956  18.934 -30.020  1.00 10.64           N  
ATOM    557  CA  GLY A  89     -55.046  18.732 -28.582  1.00 10.34           C  
ATOM    558  C   GLY A  89     -53.717  18.654 -27.861  1.00 10.40           C  
ATOM    559  O   GLY A  89     -52.688  19.117 -28.359  1.00  9.82           O  
ATOM    560  N   LYS A  90     -53.755  18.051 -26.676  1.00 10.33           N  
ATOM    561  CA  LYS A  90     -52.625  18.025 -25.754  1.00 10.98           C  
ATOM    562  C   LYS A  90     -52.622  16.712 -24.984  1.00 10.04           C  
ATOM    563  O   LYS A  90     -53.676  16.112 -24.769  1.00  9.47           O  
ATOM    564  CB  LYS A  90     -52.722  19.201 -24.766  1.00 11.11           C  
ATOM    565  CG  LYS A  90     -53.968  19.170 -23.859  1.00 12.81           C  
ATOM    566  CD  LYS A  90     -54.019  20.333 -22.872  1.00 13.24           C  
ATOM    567  CE  LYS A  90     -54.744  21.531 -23.463  1.00 15.86           C  
ATOM    568  NZ  LYS A  90     -54.785  22.669 -22.507  1.00 16.63           N  
ATOM    569  N   VAL A  91     -51.438  16.273 -24.574  1.00  9.72           N  
ATOM    570  CA  VAL A  91     -51.307  15.121 -23.686  1.00  9.52           C  
ATOM    571  C   VAL A  91     -50.421  15.530 -22.523  1.00  9.44           C  
ATOM    572  O   VAL A  91     -49.320  16.039 -22.738  1.00  9.81           O  
ATOM    573  CB  VAL A  91     -50.691  13.894 -24.398  1.00  9.32           C  
ATOM    574  CG1 VAL A  91     -50.653  12.693 -23.463  1.00  9.90           C  
ATOM    575  CG2 VAL A  91     -51.475  13.543 -25.660  1.00 10.05           C  
ATOM    576  N   TRP A  92     -50.894  15.324 -21.298  1.00  8.85           N  
ATOM    577  CA  TRP A  92     -50.079  15.644 -20.129  1.00  8.85           C  
ATOM    578  C   TRP A  92     -50.011  14.503 -19.121  1.00  8.36           C  
ATOM    579  O   TRP A  92     -50.847  13.590 -19.129  1.00  8.29           O  
ATOM    580  CB  TRP A  92     -50.487  16.987 -19.496  1.00  9.67           C  
ATOM    581  CG  TRP A  92     -51.683  16.975 -18.585  1.00  9.40           C  
ATOM    582  CD1 TRP A  92     -51.701  16.642 -17.254  1.00  9.75           C  
ATOM    583  CD2 TRP A  92     -53.025  17.362 -18.914  1.00  9.93           C  
ATOM    584  NE1 TRP A  92     -52.972  16.777 -16.746  1.00  9.97           N  
ATOM    585  CE2 TRP A  92     -53.802  17.219 -17.743  1.00 10.22           C  
ATOM    586  CE3 TRP A  92     -53.651  17.806 -20.090  1.00 11.54           C  
ATOM    587  CZ2 TRP A  92     -55.170  17.504 -17.710  1.00 11.20           C  
ATOM    588  CZ3 TRP A  92     -55.013  18.087 -20.053  1.00 11.66           C  
ATOM    589  CH2 TRP A  92     -55.753  17.936 -18.871  1.00 11.48           C  
ATOM    590  N   VAL A  93     -48.984  14.559 -18.279  1.00  8.28           N  
ATOM    591  CA  VAL A  93     -48.704  13.530 -17.286  1.00  8.02           C  
ATOM    592  C   VAL A  93     -48.729  14.155 -15.901  1.00  7.65           C  
ATOM    593  O   VAL A  93     -48.188  15.239 -15.696  1.00  8.11           O  
ATOM    594  CB  VAL A  93     -47.326  12.875 -17.540  1.00  8.00           C  
ATOM    595  CG1 VAL A  93     -47.004  11.824 -16.478  1.00  9.15           C  
ATOM    596  CG2 VAL A  93     -47.278  12.262 -18.934  1.00  8.37           C  
ATOM    597  N   SER A  94     -49.361  13.472 -14.951  1.00  7.47           N  
ATOM    598  CA  SER A  94     -49.412  13.948 -13.577  1.00  7.47           C  
ATOM    599  C   SER A  94     -49.248  12.783 -12.602  1.00  7.81           C  
ATOM    600  O   SER A  94     -49.536  11.638 -12.945  1.00  7.61           O  
ATOM    601  CB  SER A  94     -50.707  14.718 -13.322  1.00  7.42           C  
ATOM    602  OG  SER A  94     -51.845  13.925 -13.627  1.00  7.91           O  
ATOM    603  N   PRO A  95     -48.738  13.064 -11.393  1.00  7.72           N  
ATOM    604  CA  PRO A  95     -48.489  11.992 -10.423  1.00  8.06           C  
ATOM    605  C   PRO A  95     -49.749  11.353  -9.836  1.00  7.80           C  
ATOM    606  O   PRO A  95     -50.756  12.040  -9.600  1.00  7.95           O  
ATOM    607  CB  PRO A  95     -47.680  12.693  -9.325  1.00  8.45           C  
ATOM    608  CG  PRO A  95     -48.013  14.111  -9.446  1.00  8.67           C  
ATOM    609  CD  PRO A  95     -48.287  14.377 -10.892  1.00  7.61           C  
ATOM    610  N   VAL A  96     -49.678  10.042  -9.604  1.00  8.04           N  
ATOM    611  CA  VAL A  96     -50.716   9.303  -8.895  1.00  8.64           C  
ATOM    612  C   VAL A  96     -50.076   8.704  -7.645  1.00  9.06           C  
ATOM    613  O   VAL A  96     -49.140   7.906  -7.746  1.00  9.54           O  
ATOM    614  CB  VAL A  96     -51.341   8.201  -9.792  1.00  8.58           C  
ATOM    615  CG1 VAL A  96     -52.202   7.241  -8.973  1.00  8.90           C  
ATOM    616  CG2 VAL A  96     -52.159   8.827 -10.922  1.00  8.61           C  
ATOM    617  N   ASP A  97     -50.568   9.100  -6.472  1.00  8.94           N  
ATOM    618  CA  ASP A  97     -50.013   8.612  -5.206  1.00 10.03           C  
ATOM    619  C   ASP A  97     -50.354   7.154  -4.960  1.00 10.46           C  
ATOM    620  O   ASP A  97     -49.488   6.363  -4.578  1.00 10.54           O  
ATOM    621  CB  ASP A  97     -50.515   9.445  -4.024  1.00 10.43           C  
ATOM    622  CG  ASP A  97     -50.000  10.872  -4.036  1.00 11.67           C  
ATOM    623  OD1 ASP A  97     -50.602  11.706  -3.333  1.00 15.11           O  
ATOM    624  OD2 ASP A  97     -49.008  11.166  -4.734  1.00 13.21           O  
ATOM    625  N   THR A  98     -51.622   6.810  -5.164  1.00 10.70           N  
ATOM    626  CA  THR A  98     -52.113   5.461  -4.910  1.00 12.00           C  
ATOM    627  C   THR A  98     -53.279   5.185  -5.840  1.00 11.53           C  
ATOM    628  O   THR A  98     -53.968   6.110  -6.281  1.00 10.72           O  
ATOM    629  CB  THR A  98     -52.603   5.281  -3.455  1.00 12.83           C  
ATOM    630  OG1 THR A  98     -53.591   6.269  -3.169  1.00 14.84           O  
ATOM    631  CG2 THR A  98     -51.464   5.403  -2.448  1.00 14.32           C  
ATOM    632  N   ILE A  99     -53.495   3.909  -6.132  1.00 12.00           N  
ATOM    633  CA  ILE A  99     -54.631   3.479  -6.935  1.00 12.36           C  
ATOM    634  C   ILE A  99     -55.171   2.160  -6.407  1.00 12.35           C  
ATOM    635  O   ILE A  99     -54.403   1.286  -6.005  1.00 12.22           O  
ATOM    636  CB  ILE A  99     -54.281   3.401  -8.444  1.00 12.47           C  
ATOM    637  CG1 ILE A  99     -55.526   3.034  -9.262  1.00 13.26           C  
ATOM    638  CG2 ILE A  99     -53.092   2.446  -8.701  1.00 12.97           C  
ATOM    639  CD1 ILE A  99     -55.465   3.466 -10.700  1.00 13.82           C  
ATOM    640  N   VAL A 100     -56.495   2.043  -6.384  1.00 11.96           N  
ATOM    641  CA  VAL A 100     -57.174   0.840  -5.912  1.00 11.95           C  
ATOM    642  C   VAL A 100     -58.164   0.369  -6.973  1.00 11.58           C  
ATOM    643  O   VAL A 100     -58.952   1.161  -7.487  1.00 11.66           O  
ATOM    644  CB  VAL A 100     -57.935   1.083  -4.574  1.00 12.26           C  
ATOM    645  CG1 VAL A 100     -58.523  -0.219  -4.043  1.00 12.24           C  
ATOM    646  CG2 VAL A 100     -57.026   1.714  -3.526  1.00 13.82           C  
ATOM    647  N   ARG A 101     -58.115  -0.920  -7.304  1.00 11.40           N  
ATOM    648  CA  ARG A 101     -59.132  -1.536  -8.149  1.00 11.53           C  
ATOM    649  C   ARG A 101     -60.346  -1.866  -7.278  1.00 11.00           C  
ATOM    650  O   ARG A 101     -60.233  -2.646  -6.331  1.00 11.27           O  
ATOM    651  CB  ARG A 101     -58.585  -2.807  -8.807  1.00 11.54           C  
ATOM    652  CG  ARG A 101     -59.431  -3.309  -9.973  1.00 12.54           C  
ATOM    653  CD  ARG A 101     -59.046  -4.720 -10.428  1.00 12.76           C  
ATOM    654  NE  ARG A 101     -57.625  -4.870 -10.752  1.00 15.11           N  
ATOM    655  CZ  ARG A 101     -57.065  -4.531 -11.912  1.00 15.55           C  
ATOM    656  NH1 ARG A 101     -57.790  -3.998 -12.889  1.00 17.37           N  
ATOM    657  NH2 ARG A 101     -55.765  -4.721 -12.094  1.00 16.83           N  
ATOM    658  N   VAL A 102     -61.498  -1.279  -7.599  1.00 10.93           N  
ATOM    659  CA  VAL A 102     -62.681  -1.393  -6.731  1.00 11.09           C  
ATOM    660  C   VAL A 102     -63.123  -2.840  -6.481  1.00 11.64           C  
ATOM    661  O   VAL A 102     -63.346  -3.228  -5.333  1.00 11.98           O  
ATOM    662  CB  VAL A 102     -63.874  -0.543  -7.248  1.00 10.61           C  
ATOM    663  CG1 VAL A 102     -65.140  -0.805  -6.426  1.00 10.66           C  
ATOM    664  CG2 VAL A 102     -63.524   0.950  -7.227  1.00 10.07           C  
ATOM    665  N   ARG A 103     -63.231  -3.628  -7.550  1.00 12.09           N  
ATOM    666  CA  ARG A 103     -63.763  -4.990  -7.446  1.00 13.09           C  
ATOM    667  C   ARG A 103     -63.011  -5.847  -6.425  1.00 13.02           C  
ATOM    668  O   ARG A 103     -63.628  -6.541  -5.614  1.00 13.38           O  
ATOM    669  CB  ARG A 103     -63.761  -5.674  -8.815  1.00 12.99           C  
ATOM    670  CG  ARG A 103     -64.379  -7.067  -8.797  1.00 14.30           C  
ATOM    671  CD  ARG A 103     -64.371  -7.733 -10.163  1.00 14.80           C  
ATOM    672  NE  ARG A 103     -63.028  -7.999 -10.680  1.00 19.29           N  
ATOM    673  CZ  ARG A 103     -62.306  -9.083 -10.405  1.00 20.81           C  
ATOM    674  NH1 ARG A 103     -62.774 -10.026  -9.594  1.00 21.61           N  
ATOM    675  NH2 ARG A 103     -61.099  -9.219 -10.938  1.00 22.65           N  
ATOM    676  N   THR A 104     -61.684  -5.773  -6.460  1.00 13.23           N  
ATOM    677  CA  THR A 104     -60.827  -6.690  -5.712  1.00 13.28           C  
ATOM    678  C   THR A 104     -60.164  -6.055  -4.492  1.00 13.37           C  
ATOM    679  O   THR A 104     -59.748  -6.754  -3.570  1.00 14.09           O  
ATOM    680  CB  THR A 104     -59.706  -7.229  -6.610  1.00 13.20           C  
ATOM    681  OG1 THR A 104     -58.980  -6.119  -7.157  1.00 12.71           O  
ATOM    682  CG2 THR A 104     -60.271  -8.071  -7.745  1.00 14.03           C  
ATOM    683  N   GLY A 105     -60.042  -4.730  -4.497  1.00 13.07           N  
ATOM    684  CA  GLY A 105     -59.279  -4.032  -3.468  1.00 13.10           C  
ATOM    685  C   GLY A 105     -57.776  -4.070  -3.703  1.00 13.16           C  
ATOM    686  O   GLY A 105     -56.999  -3.655  -2.841  1.00 13.48           O  
ATOM    687  N   GLU A 106     -57.368  -4.572  -4.870  1.00 13.02           N  
ATOM    688  CA  GLU A 106     -55.962  -4.563  -5.271  1.00 13.17           C  
ATOM    689  C   GLU A 106     -55.437  -3.135  -5.316  1.00 13.19           C  
ATOM    690  O   GLU A 106     -56.158  -2.215  -5.705  1.00 12.53           O  
ATOM    691  CB  GLU A 106     -55.792  -5.205  -6.643  1.00 13.12           C  
ATOM    692  CG  GLU A 106     -55.847  -6.722  -6.645  1.00 14.12           C  
ATOM    693  CD  GLU A 106     -56.016  -7.289  -8.039  1.00 15.38           C  
ATOM    694  OE1 GLU A 106     -55.192  -8.145  -8.428  1.00 17.06           O  
ATOM    695  OE2 GLU A 106     -56.960  -6.882  -8.750  1.00 15.51           O  
ATOM    696  N   ARG A 107     -54.182  -2.957  -4.918  1.00 13.49           N  
ATOM    697  CA  ARG A 107     -53.567  -1.634  -4.854  1.00 14.32           C  
ATOM    698  C   ARG A 107     -52.303  -1.586  -5.692  1.00 14.25           C  
ATOM    699  O   ARG A 107     -51.740  -2.626  -6.035  1.00 14.15           O  
ATOM    700  CB  ARG A 107     -53.226  -1.275  -3.405  1.00 14.77           C  
ATOM    701  CG  ARG A 107     -54.410  -1.269  -2.453  1.00 16.75           C  
ATOM    702  CD  ARG A 107     -53.946  -1.036  -1.022  1.00 19.60           C  
ATOM    703  NE  ARG A 107     -55.059  -1.007  -0.075  1.00 22.53           N  
ATOM    704  CZ  ARG A 107     -55.755   0.082   0.241  1.00 23.60           C  
ATOM    705  NH1 ARG A 107     -56.751   0.001   1.114  1.00 24.76           N  
ATOM    706  NH2 ARG A 107     -55.463   1.254  -0.315  1.00 24.42           N  
ATOM    707  N   GLY A 108     -51.853  -0.373  -6.009  1.00 14.23           N  
ATOM    708  CA  GLY A 108     -50.575  -0.175  -6.696  1.00 14.79           C  
ATOM    709  C   GLY A 108     -50.504  -0.903  -8.019  1.00 15.27           C  
ATOM    710  O   GLY A 108     -51.437  -0.834  -8.818  1.00 14.98           O  
ATOM    711  N   HIS A 109     -49.409  -1.630  -8.235  1.00 15.70           N  
ATOM    712  CA  HIS A 109     -49.198  -2.322  -9.507  1.00 16.37           C  
ATOM    713  C   HIS A 109     -50.218  -3.434  -9.772  1.00 16.14           C  
ATOM    714  O   HIS A 109     -50.473  -3.786 -10.923  1.00 16.62           O  
ATOM    715  CB  HIS A 109     -47.750  -2.824  -9.641  1.00 16.84           C  
ATOM    716  CG  HIS A 109     -47.477  -4.127  -8.952  1.00 18.56           C  
ATOM    717  ND1 HIS A 109     -47.058  -4.205  -7.640  1.00 20.61           N  
ATOM    718  CD2 HIS A 109     -47.535  -5.402  -9.404  1.00 20.06           C  
ATOM    719  CE1 HIS A 109     -46.884  -5.473  -7.310  1.00 20.68           C  
ATOM    720  NE2 HIS A 109     -47.167  -6.220  -8.362  1.00 20.95           N  
ATOM    721  N   ASP A 110     -50.815  -3.963  -8.706  1.00 15.71           N  
ATOM    722  CA  ASP A 110     -51.863  -4.980  -8.823  1.00 15.82           C  
ATOM    723  C   ASP A 110     -53.177  -4.409  -9.357  1.00 15.44           C  
ATOM    724  O   ASP A 110     -54.034  -5.153  -9.835  1.00 15.52           O  
ATOM    725  CB  ASP A 110     -52.118  -5.653  -7.470  1.00 15.81           C  
ATOM    726  CG  ASP A 110     -50.914  -6.416  -6.956  1.00 17.18           C  
ATOM    727  OD1 ASP A 110     -50.239  -7.090  -7.761  1.00 18.99           O  
ATOM    728  OD2 ASP A 110     -50.649  -6.353  -5.737  1.00 17.38           O  
ATOM    729  N   ALA A 111     -53.326  -3.088  -9.269  1.00 15.47           N  
ATOM    730  CA  ALA A 111     -54.551  -2.412  -9.680  1.00 15.69           C  
ATOM    731  C   ALA A 111     -54.475  -1.871 -11.106  1.00 16.04           C  
ATOM    732  O   ALA A 111     -55.469  -1.379 -11.639  1.00 16.14           O  
ATOM    733  CB  ALA A 111     -54.879  -1.288  -8.704  1.00 15.47           C  
ATOM    734  N   LEU A 112     -53.295  -1.978 -11.714  1.00 16.50           N  
ATOM    735  CA  LEU A 112     -53.031  -1.404 -13.035  1.00 17.11           C  
ATOM    736  C   LEU A 112     -53.725  -2.136 -14.174  1.00 17.36           C  
ATOM    737  O   LEU A 112     -53.905  -3.354 -14.129  1.00 17.63           O  
ATOM    738  CB  LEU A 112     -51.526  -1.358 -13.304  1.00 17.29           C  
ATOM    739  CG  LEU A 112     -50.757  -0.251 -12.590  1.00 17.47           C  
ATOM    740  CD1 LEU A 112     -49.262  -0.387 -12.835  1.00 18.41           C  
ATOM    741  CD2 LEU A 112     -51.269   1.105 -13.055  1.00 18.28           C  
ATOM    742  OXT LEU A 112     -54.101  -1.513 -15.170  1.00 17.59           O  
TER     743      LEU A 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
