
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  788),  selected  103 , name 2j9d_B
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2j9d_B.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    G    -1_B      K       3          4.952
LGA    S     0_B      R       4          2.891
LGA    M     1_B      A       5          0.353
LGA    K     2_B      N       6          1.116
LGA    K     3_B      K       7          0.462
LGA    V     4_B      L       8          0.493
LGA    E     5_B      V       9          0.604
LGA    A     6_B      I      10          0.665
LGA    I     7_B      V      11          0.435
LGA    I     8_B      T      12          0.560
LGA    R     9_B      E      13          0.922
LGA    P    10_B      K      14          0.735
LGA    E    11_B      V      15          0.765
LGA    K    12_B      L      16          0.778
LGA    L    13_B      L      17          1.074
LGA    E    14_B      K      18          0.633
LGA    I    15_B      K      19          0.936
LGA    V    16_B      V      20          1.189
LGA    K    17_B      A      21          0.920
LGA    K    18_B      K      22          1.000
LGA    A    19_B      I      23          1.938
LGA    L    20_B      I      24          1.842
LGA    S    21_B      E      25          1.241
LGA    D    22_B      E      26          1.692
LGA    A    23_B      A      27          2.112
LGA    G    24_B      G      28          1.254
LGA    Y    25_B      A      29          1.444
LGA    V    26_B      T      30          4.088
LGA    G    27_B      G      31          0.327
LGA    M    28_B      Y      32          0.549
LGA    T    29_B      T      33          0.320
LGA    V    30_B      V      34          0.359
LGA    S    31_B      V      35          0.086
LGA    E    32_B      D      36          0.133
LGA    V    33_B      T      37          0.176
LGA    K    34_B      G      38          0.620
LGA    G    35_B      G      39          1.660
LGA    R    36_B      -       -           -
LGA    G    37_B      -       -           -
LGA    V    38_B      -       -           -
LGA    Q    39_B      -       -           -
LGA    V    53_B      -       -           -
LGA    D    54_B      -       -           -
LGA    L    55_B      -       -           -
LGA    I    56_B      -       -           -
LGA    P    57_B      S      58          0.728
LGA    K    58_B      N      59          0.260
LGA    V    59_B      V      60          0.256
LGA    K    60_B      K      61          0.175
LGA    I    61_B      F      62          0.370
LGA    E    62_B      E      63          0.374
LGA    L    63_B      V      64          0.199
LGA    V    64_B      L      65          0.507
LGA    V    65_B      T      66          1.005
LGA    K    66_B      E      67          2.570
LGA    E    67_B      N      68          3.360
LGA    E    68_B      R      69          2.731
LGA    D    69_B      E      70          3.047
LGA    -       -      M      71           -
LGA    V    70_B      A      72          1.908
LGA    D    71_B      E      73          1.392
LGA    N    72_B      K      74          1.247
LGA    V    73_B      I      75          2.083
LGA    I    74_B      A      76          1.234
LGA    D    75_B      D      77          1.366
LGA    I    76_B      Q      78          2.267
LGA    I    77_B      V      79          2.238
LGA    C    78_B      A      80          1.504
LGA    E    79_B      I      81          3.094
LGA    N    80_B      K      82          3.745
LGA    A    81_B      F      83          3.395
LGA    R    82_B      F      84          2.483
LGA    T    83_B      -       -           -
LGA    G    84_B      T      85          2.060
LGA    N    85_B      D      86          3.717
LGA    P    86_B      Y      87          6.103
LGA    G    87_B      A      88          2.291
LGA    D    88_B      -       -           -
LGA    G    89_B      G      89          0.514
LGA    K    90_B      I      90          0.257
LGA    I    91_B      I      91          0.871
LGA    F    92_B      Y      92          1.504
LGA    V    93_B      I      93          0.626
LGA    I    94_B      C      94          0.580
LGA    P    95_B      E      95          0.753
LGA    V    96_B      A      96          0.333
LGA    E    97_B      E      97          1.680
LGA    R    98_B      V      98          2.412
LGA    V    99_B      L      99          3.374
LGA    V   100_B      Y     100          0.670
LGA    R   101_B      G     101          2.241
LGA    V   102_B      -       -           -
LGA    R   103_B      -       -           -
LGA    T   104_B      -       -           -
LGA    K   105_B      -       -           -
LGA    E   106_B      -       -           -
LGA    E   107_B      -       -           -
LGA    G   108_B      -       -           -
LGA    K   109_B      -       -           -
LGA    E   110_B      -       -           -
LGA    A   111_B      -       -           -
LGA    L   112_B      -       -           -
LGA    L   113_B      -       -           -
LGA    E   114_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103   83    5.0     80    1.87    21.25     87.402     4.054

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.571341 * X  +  -0.342360 * Y  +   0.745895 * Z  + -72.708473
  Y_new =   0.467845 * X  +   0.882574 * Y  +   0.046735 * Z  + -112.494576
  Z_new =  -0.674308 * X  +   0.322262 * Y  +   0.664422 * Z  + -43.930836 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.451597   -2.689996  [ DEG:    25.8746   -154.1254 ]
  Theta =   0.740027    2.401566  [ DEG:    42.4004    137.5996 ]
  Phi   =   0.686132   -2.455460  [ DEG:    39.3125   -140.6875 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2j9d_B                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2j9d_B.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103   83   5.0   80   1.87   21.25  87.402
REMARK  ---------------------------------------------------------- 
MOLECULE 2j9d_B
HEADER    MEMBRANE TRANSPORT                      07-NOV-06   2J9D              
TITLE     STRUCTURE OF GLNK1 WITH BOUND EFFECTORS INDICATES                     
TITLE    2 REGULATORY MECHANISM FOR AMMONIA UPTAKE                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL NITROGEN REGULATORY PII-LIKE                  
COMPND   3 PROTEIN MJ0059;                                                      
COMPND   4 CHAIN: A, B, C, D, F, G, H, I, J, K, L;                              
COMPND   5 SYNONYM: GLNK1;                                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: HYPOTHETICAL NITROGEN REGULATORY PII-LIKE                  
COMPND   9 PROTEIN MJ0059;                                                      
COMPND  10 CHAIN: E;                                                            
COMPND  11 SYNONYM: GLNK1;                                                      
COMPND  12 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOCOCCUS JANNASCHII;                       
SOURCE   3 STRAIN: AMJFT37;                                                     
SOURCE   4 ATCC: 625482;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-DE3;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: PLASMID;                                   
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28-D2;                                 
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: METHANOCOCCUS JANNASCHII;                       
SOURCE  11 STRAIN: AMJFT37;                                                     
SOURCE  12 ATCC: 625482;                                                        
SOURCE  13 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: BL21-DE3;                                  
SOURCE  15 EXPRESSION_SYSTEM_VECTOR: PLASMID;                                   
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PET28-D2                                  
KEYWDS    EM SINGLE PARTICLE, NITROGEN METABOLISM, SIGNALLING,                  
KEYWDS   2 TRANSCRIPTION, MEMBRANE TRANSPORT, HYPOTHETICAL PROTEIN,             
KEYWDS   3 TRANSCRIPTION REGULATION                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    O.YILDIZ,C.KALTHOFF,S.RAUNSER,W.KUEHLBRANDT                           
REVDAT   1   16-JAN-07 2J9D    0                                                
JRNL        AUTH   O.YILDIZ,C.KALTHOFF,S.RAUNSER,W.KUEHLBRANDT                  
JRNL        TITL   STRUCTURE OF GLNK1 WITH BOUND EFFECTORS INDICATES            
JRNL        TITL 2 REGULATORY MECHANISM FOR AMMONIA UPTAKE                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2J9D A   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D A    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D A  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D B   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D B    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D B  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D C   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D C    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D C  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D D   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D D    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D D  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D E   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D E    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D E  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D F   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D F    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D F  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D G   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D G    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D G  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D H   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D H    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D H  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D I   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D I    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D I  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D J   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D J    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D J  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D K   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D K    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D K  113   115  PDB    2J9D     2J9D           113    115             
DBREF  2J9D L   -1     0  PDB    2J9D     2J9D            -1      0             
DBREF  2J9D L    1   112  UNP    Q60381   Y059_METJA       1    112             
DBREF  2J9D L  113   115  PDB    2J9D     2J9D           113    115             
SEQRES   1 A  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 A  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 A  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 A  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 A  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 A  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 A  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 A  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 A  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 A  119  HIS HIS                                                      
SEQRES   1 B  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 B  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 B  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 B  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 B  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 B  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 B  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 B  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 B  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 B  119  HIS HIS                                                      
SEQRES   1 C  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 C  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 C  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 C  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 C  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 C  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 C  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 C  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 C  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 C  119  HIS HIS                                                      
SEQRES   1 D  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 D  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 D  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 D  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 D  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 D  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 D  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 D  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 D  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 D  119  HIS HIS                                                      
SEQRES   1 E  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 E  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 E  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 E  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 E  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 E  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 E  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 E  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 E  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU GLU GLU HIS          
SEQRES  10 E  119  HIS HIS                                                      
SEQRES   1 F  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 F  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 F  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 F  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 F  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 F  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 F  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 F  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 F  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 F  119  HIS HIS                                                      
SEQRES   1 G  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 G  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 G  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 G  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 G  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 G  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 G  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 G  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 G  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 G  119  HIS HIS                                                      
SEQRES   1 H  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 H  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 H  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 H  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 H  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 H  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 H  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 H  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 H  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 H  119  HIS HIS                                                      
SEQRES   1 I  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 I  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 I  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 I  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 I  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 I  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 I  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 I  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 I  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 I  119  HIS HIS                                                      
SEQRES   1 J  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 J  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 J  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 J  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 J  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 J  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 J  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 J  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 J  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 J  119  HIS HIS                                                      
SEQRES   1 K  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 K  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 K  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 K  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 K  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 K  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 K  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 K  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 K  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 K  119  HIS HIS                                                      
SEQRES   1 L  119  GLY SER MET LYS LYS VAL GLU ALA ILE ILE ARG PRO GLU          
SEQRES   2 L  119  LYS LEU GLU ILE VAL LYS LYS ALA LEU SER ASP ALA GLY          
SEQRES   3 L  119  TYR VAL GLY MET THR VAL SER GLU VAL LYS GLY ARG GLY          
SEQRES   4 L  119  VAL GLN GLY GLY ILE VAL GLU ARG TYR ARG GLY ARG GLU          
SEQRES   5 L  119  TYR ILE VAL ASP LEU ILE PRO LYS VAL LYS ILE GLU LEU          
SEQRES   6 L  119  VAL VAL LYS GLU GLU ASP VAL ASP ASN VAL ILE ASP ILE          
SEQRES   7 L  119  ILE CYS GLU ASN ALA ARG THR GLY ASN PRO GLY ASP GLY          
SEQRES   8 L  119  LYS ILE PHE VAL ILE PRO VAL GLU ARG VAL VAL ARG VAL          
SEQRES   9 L  119  ARG THR LYS GLU GLU GLY LYS GLU ALA LEU LEU GLU HIS          
SEQRES  10 L  119  HIS HIS                                                      
HET    ACT  A1116       4                                                       
HET    ACT  A1117       4                                                       
HET    ACT  E1116       4                                                       
HET    ACT  H1113       4                                                       
HET     CL  J1114       1                                                       
HET    ACT  J1116       4                                                       
HET    ADP  B1115      27                                                       
HET    AMP  E1115      23                                                       
HET    ADP  I1115      27                                                       
HET    ADP  J1115      27                                                       
HET    ADP  L1114      27                                                       
HETNAM     ACT ACETATE ION                                                      
HETNAM      CL CHLORIDE ION                                                     
HETNAM     ADP ADENOSINE-5'-DIPHOSPHATE                                         
HETNAM     AMP ADENOSINE MONOPHOSPHATE                                          
FORMUL  13  ACT    5(C2 H3 O2 1-)                                               
FORMUL  17   CL    CL 1-                                                        
FORMUL  19  ADP    4(C10 H15 N5 O10 P2)                                         
FORMUL  20  AMP    C10 H14 N5 O7 P                                              
FORMUL  24  HOH   *694(H2 O)                                                    
CRYST1   96.600  107.030  134.340  90.00  90.00  90.00 P 21 21 21   44          
ATOM    781  N   GLY B  -1     -44.382   1.662  -6.005  1.00 49.75           N  
ATOM    782  CA  GLY B  -1     -43.657   2.534  -6.986  1.00 47.20           C  
ATOM    783  C   GLY B  -1     -44.376   3.857  -7.222  1.00 46.97           C  
ATOM    784  O   GLY B  -1     -45.342   4.180  -6.516  1.00 50.61           O  
ATOM    785  N   SER B   0     -43.916   4.617  -8.218  1.00 41.35           N  
ATOM    786  CA  SER B   0     -44.564   5.874  -8.607  1.00 38.70           C  
ATOM    787  C   SER B   0     -45.608   5.575  -9.684  1.00 34.91           C  
ATOM    788  O   SER B   0     -45.314   4.836 -10.632  1.00 31.63           O  
ATOM    789  CB  SER B   0     -43.512   6.871  -9.105  1.00 38.48           C  
ATOM    790  OG  SER B   0     -43.826   8.198  -8.715  1.00 46.46           O  
ATOM    791  N   MET B   1     -46.834   6.093  -9.499  1.00 33.18           N  
ATOM    792  CA  MET B   1     -47.926   6.019 -10.495  1.00 31.83           C  
ATOM    793  C   MET B   1     -48.257   7.412 -11.072  1.00 29.63           C  
ATOM    794  O   MET B   1     -48.155   8.435 -10.390  1.00 27.86           O  
ATOM    795  CB  MET B   1     -49.203   5.459  -9.885  1.00 34.55           C  
ATOM    796  CG  MET B   1     -49.102   4.048  -9.256  1.00 36.57           C  
ATOM    797  SD  MET B   1     -48.831   2.845 -10.541  1.00 43.57           S  
ATOM    798  CE  MET B   1     -47.135   2.376 -10.171  1.00 40.56           C  
ATOM    799  N   LYS B   2     -48.627   7.438 -12.343  1.00 26.07           N  
ATOM    800  CA  LYS B   2     -48.901   8.674 -13.030  1.00 26.09           C  
ATOM    801  C   LYS B   2     -50.167   8.537 -13.832  1.00 25.39           C  
ATOM    802  O   LYS B   2     -50.432   7.467 -14.409  1.00 25.26           O  
ATOM    803  CB  LYS B   2     -47.763   8.986 -13.988  1.00 24.44           C  
ATOM    804  CG  LYS B   2     -46.397   9.083 -13.318  1.00 25.99           C  
ATOM    805  CD  LYS B   2     -46.270  10.286 -12.370  1.00 25.36           C  
ATOM    806  CE  LYS B   2     -44.933  10.222 -11.635  1.00 25.31           C  
ATOM    807  NZ  LYS B   2     -44.737  11.316 -10.662  1.00 27.37           N  
ATOM    808  N   LYS B   3     -50.930   9.626 -13.897  1.00 24.58           N  
ATOM    809  CA  LYS B   3     -52.057   9.703 -14.818  1.00 25.27           C  
ATOM    810  C   LYS B   3     -51.651  10.439 -16.096  1.00 24.94           C  
ATOM    811  O   LYS B   3     -51.176  11.575 -16.070  1.00 24.00           O  
ATOM    812  CB  LYS B   3     -53.264  10.366 -14.189  1.00 24.66           C  
ATOM    813  CG  LYS B   3     -54.481  10.343 -15.082  1.00 27.17           C  
ATOM    814  CD  LYS B   3     -55.519  11.376 -14.681  1.00 28.01           C  
ATOM    815  CE  LYS B   3     -56.298  10.990 -13.413  1.00 31.02           C  
ATOM    816  NZ  LYS B   3     -57.609  11.723 -13.375  1.00 28.46           N  
ATOM    817  N   VAL B   4     -51.848   9.766 -17.220  1.00 24.87           N  
ATOM    818  CA  VAL B   4     -51.646  10.362 -18.539  1.00 23.76           C  
ATOM    819  C   VAL B   4     -53.035  10.749 -19.019  1.00 23.98           C  
ATOM    820  O   VAL B   4     -53.910   9.874 -19.172  1.00 22.77           O  
ATOM    821  CB  VAL B   4     -50.987   9.373 -19.513  1.00 23.68           C  
ATOM    822  CG1 VAL B   4     -50.857   9.958 -20.947  1.00 24.14           C  
ATOM    823  CG2 VAL B   4     -49.596   8.921 -19.017  1.00 24.04           C  
ATOM    824  N   GLU B   5     -53.245  12.053 -19.212  1.00 23.37           N  
ATOM    825  CA  GLU B   5     -54.475  12.582 -19.783  1.00 25.69           C  
ATOM    826  C   GLU B   5     -54.181  13.113 -21.168  1.00 25.16           C  
ATOM    827  O   GLU B   5     -53.280  13.954 -21.313  1.00 25.32           O  
ATOM    828  CB  GLU B   5     -55.009  13.753 -18.971  1.00 26.27           C  
ATOM    829  CG  GLU B   5     -55.288  13.524 -17.531  1.00 31.19           C  
ATOM    830  CD  GLU B   5     -55.965  14.743 -16.884  1.00 34.10           C  
ATOM    831  OE1 GLU B   5     -55.859  15.885 -17.428  1.00 33.57           O  
ATOM    832  OE2 GLU B   5     -56.604  14.555 -15.834  1.00 35.01           O  
ATOM    833  N   ALA B   6     -54.941  12.667 -22.160  1.00 23.58           N  
ATOM    834  CA  ALA B   6     -54.836  13.169 -23.511  1.00 24.96           C  
ATOM    835  C   ALA B   6     -56.178  13.744 -23.972  1.00 24.56           C  
ATOM    836  O   ALA B   6     -57.221  13.112 -23.829  1.00 24.91           O  
ATOM    837  CB  ALA B   6     -54.398  12.062 -24.442  1.00 22.84           C  
ATOM    838  N   ILE B   7     -56.143  14.944 -24.518  1.00 24.53           N  
ATOM    839  CA  ILE B   7     -57.326  15.558 -25.124  1.00 25.84           C  
ATOM    840  C   ILE B   7     -57.095  15.528 -26.618  1.00 26.78           C  
ATOM    841  O   ILE B   7     -56.176  16.181 -27.100  1.00 26.71           O  
ATOM    842  CB  ILE B   7     -57.496  17.019 -24.687  1.00 26.17           C  
ATOM    843  CG1 ILE B   7     -57.423  17.161 -23.153  1.00 28.78           C  
ATOM    844  CG2 ILE B   7     -58.777  17.657 -25.343  1.00 25.76           C  
ATOM    845  CD1 ILE B   7     -58.618  16.706 -22.419  1.00 32.99           C  
ATOM    846  N   ILE B   8     -57.883  14.733 -27.332  1.00 26.14           N  
ATOM    847  CA  ILE B   8     -57.647  14.466 -28.741  1.00 27.38           C  
ATOM    848  C   ILE B   8     -58.934  14.646 -29.567  1.00 28.21           C  
ATOM    849  O   ILE B   8     -60.037  14.829 -29.013  1.00 26.68           O  
ATOM    850  CB  ILE B   8     -57.047  13.030 -28.951  1.00 28.44           C  
ATOM    851  CG1 ILE B   8     -58.018  11.953 -28.467  1.00 29.31           C  
ATOM    852  CG2 ILE B   8     -55.679  12.889 -28.226  1.00 28.34           C  
ATOM    853  CD1 ILE B   8     -57.731  10.569 -29.034  1.00 28.63           C  
ATOM    854  N   ARG B   9     -58.778  14.565 -30.882  1.00 28.04           N  
ATOM    855  CA  ARG B   9     -59.907  14.634 -31.791  1.00 28.11           C  
ATOM    856  C   ARG B   9     -60.794  13.403 -31.603  1.00 26.80           C  
ATOM    857  O   ARG B   9     -60.283  12.289 -31.518  1.00 25.59           O  
ATOM    858  CB  ARG B   9     -59.423  14.698 -33.230  1.00 27.66           C  
ATOM    859  CG  ARG B   9     -58.512  15.864 -33.566  1.00 25.82           C  
ATOM    860  CD  ARG B   9     -58.038  15.724 -34.996  1.00 26.87           C  
ATOM    861  NE  ARG B   9     -57.027  16.710 -35.372  1.00 27.67           N  
ATOM    862  CZ  ARG B   9     -57.275  17.933 -35.838  1.00 30.60           C  
ATOM    863  NH1 ARG B   9     -58.519  18.374 -35.986  1.00 27.90           N  
ATOM    864  NH2 ARG B   9     -56.271  18.724 -36.163  1.00 30.94           N  
ATOM    865  N   PRO B  10     -62.117  13.598 -31.522  1.00 26.56           N  
ATOM    866  CA  PRO B  10     -63.009  12.455 -31.298  1.00 28.93           C  
ATOM    867  C   PRO B  10     -62.908  11.320 -32.318  1.00 29.46           C  
ATOM    868  O   PRO B  10     -63.090  10.162 -31.922  1.00 29.50           O  
ATOM    869  CB  PRO B  10     -64.406  13.097 -31.287  1.00 27.58           C  
ATOM    870  CG  PRO B  10     -64.178  14.509 -31.010  1.00 26.92           C  
ATOM    871  CD  PRO B  10     -62.858  14.861 -31.572  1.00 24.78           C  
ATOM    872  N   GLU B  11     -62.609  11.645 -33.578  1.00 30.59           N  
ATOM    873  CA  GLU B  11     -62.470  10.641 -34.638  1.00 32.37           C  
ATOM    874  C   GLU B  11     -61.174   9.817 -34.507  1.00 33.80           C  
ATOM    875  O   GLU B  11     -60.988   8.866 -35.245  1.00 34.93           O  
ATOM    876  CB  GLU B  11     -62.621  11.308 -36.020  1.00 31.31           C  
ATOM    877  CG  GLU B  11     -61.581  12.355 -36.395  1.00 32.34           C  
ATOM    878  CD  GLU B  11     -61.917  13.796 -35.937  1.00 35.56           C  
ATOM    879  OE1 GLU B  11     -62.589  14.025 -34.904  1.00 30.90           O  
ATOM    880  OE2 GLU B  11     -61.460  14.719 -36.618  1.00 37.25           O  
ATOM    881  N   LYS B  12     -60.291  10.206 -33.580  1.00 32.71           N  
ATOM    882  CA  LYS B  12     -59.041   9.494 -33.327  1.00 31.66           C  
ATOM    883  C   LYS B  12     -59.104   8.530 -32.156  1.00 30.80           C  
ATOM    884  O   LYS B  12     -58.139   7.808 -31.912  1.00 30.52           O  
ATOM    885  CB  LYS B  12     -57.918  10.513 -33.096  1.00 30.56           C  
ATOM    886  CG  LYS B  12     -57.482  11.209 -34.370  1.00 32.56           C  
ATOM    887  CD  LYS B  12     -56.901  10.204 -35.357  1.00 34.91           C  
ATOM    888  CE  LYS B  12     -56.102  10.855 -36.453  1.00 37.59           C  
ATOM    889  NZ  LYS B  12     -55.331   9.819 -37.171  1.00 38.82           N  
ATOM    890  N   LEU B  13     -60.235   8.507 -31.451  1.00 30.02           N  
ATOM    891  CA  LEU B  13     -60.378   7.660 -30.264  1.00 30.89           C  
ATOM    892  C   LEU B  13     -60.159   6.169 -30.594  1.00 31.51           C  
ATOM    893  O   LEU B  13     -59.410   5.491 -29.905  1.00 29.41           O  
ATOM    894  CB  LEU B  13     -61.738   7.849 -29.573  1.00 28.54           C  
ATOM    895  CG  LEU B  13     -62.139   6.866 -28.463  1.00 30.20           C  
ATOM    896  CD1 LEU B  13     -61.153   6.893 -27.295  1.00 27.67           C  
ATOM    897  CD2 LEU B  13     -63.571   7.114 -27.988  1.00 28.63           C  
ATOM    898  N   GLU B  14     -60.819   5.677 -31.629  1.00 32.38           N  
ATOM    899  CA  GLU B  14     -60.777   4.256 -31.935  1.00 33.68           C  
ATOM    900  C   GLU B  14     -59.358   3.773 -32.229  1.00 32.02           C  
ATOM    901  O   GLU B  14     -58.932   2.787 -31.678  1.00 31.75           O  
ATOM    902  CB  GLU B  14     -61.694   3.974 -33.131  1.00 36.76           C  
ATOM    903  CG  GLU B  14     -61.495   2.647 -33.812  1.00 41.11           C  
ATOM    904  CD  GLU B  14     -62.042   1.464 -33.049  1.00 48.79           C  
ATOM    905  OE1 GLU B  14     -61.970   1.429 -31.796  1.00 54.26           O  
ATOM    906  OE2 GLU B  14     -62.547   0.546 -33.732  1.00 55.35           O  
ATOM    907  N   ILE B  15     -58.631   4.501 -33.078  1.00 31.99           N  
ATOM    908  CA  ILE B  15     -57.263   4.124 -33.437  1.00 32.77           C  
ATOM    909  C   ILE B  15     -56.321   4.220 -32.244  1.00 32.17           C  
ATOM    910  O   ILE B  15     -55.485   3.340 -32.036  1.00 31.24           O  
ATOM    911  CB  ILE B  15     -56.722   4.912 -34.693  1.00 33.45           C  
ATOM    912  CG1 ILE B  15     -55.393   4.356 -35.206  1.00 35.57           C  
ATOM    913  CG2 ILE B  15     -56.513   6.378 -34.400  1.00 32.99           C  
ATOM    914  CD1 ILE B  15     -55.182   2.879 -35.053  1.00 38.85           C  
ATOM    915  N   VAL B  16     -56.451   5.287 -31.454  1.00 31.54           N  
ATOM    916  CA  VAL B  16     -55.618   5.452 -30.281  1.00 31.18           C  
ATOM    917  C   VAL B  16     -55.882   4.343 -29.255  1.00 30.37           C  
ATOM    918  O   VAL B  16     -54.940   3.776 -28.702  1.00 30.30           O  
ATOM    919  CB  VAL B  16     -55.778   6.861 -29.645  1.00 30.17           C  
ATOM    920  CG1 VAL B  16     -55.114   6.913 -28.278  1.00 25.21           C  
ATOM    921  CG2 VAL B  16     -55.188   7.928 -30.577  1.00 27.24           C  
ATOM    922  N   LYS B  17     -57.146   4.043 -29.002  1.00 31.67           N  
ATOM    923  CA  LYS B  17     -57.491   3.024 -28.012  1.00 34.29           C  
ATOM    924  C   LYS B  17     -57.022   1.610 -28.465  1.00 34.26           C  
ATOM    925  O   LYS B  17     -56.546   0.816 -27.663  1.00 32.03           O  
ATOM    926  CB  LYS B  17     -58.962   3.108 -27.573  1.00 34.48           C  
ATOM    927  CG  LYS B  17     -59.909   2.127 -28.146  1.00 39.26           C  
ATOM    928  CD  LYS B  17     -61.190   2.086 -27.345  1.00 38.50           C  
ATOM    929  CE  LYS B  17     -62.413   1.994 -28.232  1.00 43.56           C  
ATOM    930  NZ  LYS B  17     -62.502   0.718 -28.967  1.00 44.61           N  
ATOM    931  N   LYS B  18     -57.100   1.345 -29.757  1.00 35.20           N  
ATOM    932  CA  LYS B  18     -56.575   0.095 -30.342  1.00 36.11           C  
ATOM    933  C   LYS B  18     -55.054  -0.035 -30.165  1.00 34.75           C  
ATOM    934  O   LYS B  18     -54.545  -1.030 -29.671  1.00 34.96           O  
ATOM    935  CB  LYS B  18     -56.841   0.108 -31.842  1.00 38.16           C  
ATOM    936  CG  LYS B  18     -57.398  -1.132 -32.417  1.00 42.11           C  
ATOM    937  CD  LYS B  18     -58.888  -1.015 -32.522  1.00 46.44           C  
ATOM    938  CE  LYS B  18     -59.383  -1.458 -33.886  1.00 48.65           C  
ATOM    939  NZ  LYS B  18     -59.094  -0.462 -34.983  1.00 49.32           N  
ATOM    940  N   ALA B  19     -54.344   1.012 -30.562  1.00 34.12           N  
ATOM    941  CA  ALA B  19     -52.899   1.057 -30.406  1.00 33.68           C  
ATOM    942  C   ALA B  19     -52.487   0.881 -28.937  1.00 34.14           C  
ATOM    943  O   ALA B  19     -51.545   0.146 -28.631  1.00 33.03           O  
ATOM    944  CB  ALA B  19     -52.349   2.336 -30.970  1.00 31.40           C  
ATOM    945  N   LEU B  20     -53.195   1.546 -28.031  1.00 33.69           N  
ATOM    946  CA  LEU B  20     -52.908   1.415 -26.601  1.00 32.96           C  
ATOM    947  C   LEU B  20     -53.141  -0.015 -26.133  1.00 33.57           C  
ATOM    948  O   LEU B  20     -52.333  -0.575 -25.400  1.00 33.74           O  
ATOM    949  CB  LEU B  20     -53.764   2.389 -25.778  1.00 30.95           C  
ATOM    950  CG  LEU B  20     -53.262   3.837 -25.840  1.00 27.74           C  
ATOM    951  CD1 LEU B  20     -54.332   4.784 -25.346  1.00 25.99           C  
ATOM    952  CD2 LEU B  20     -51.911   4.038 -25.096  1.00 24.60           C  
ATOM    953  N   SER B  21     -54.258  -0.584 -26.558  1.00 34.71           N  
ATOM    954  CA  SER B  21     -54.631  -1.949 -26.207  1.00 37.37           C  
ATOM    955  C   SER B  21     -53.598  -2.983 -26.712  1.00 38.40           C  
ATOM    956  O   SER B  21     -53.209  -3.902 -25.979  1.00 38.50           O  
ATOM    957  CB  SER B  21     -56.002  -2.266 -26.801  1.00 36.19           C  
ATOM    958  OG  SER B  21     -56.220  -3.654 -26.833  1.00 44.62           O  
ATOM    959  N   ASP B  22     -53.169  -2.802 -27.960  1.00 38.60           N  
ATOM    960  CA  ASP B  22     -52.147  -3.653 -28.579  1.00 39.71           C  
ATOM    961  C   ASP B  22     -50.825  -3.620 -27.817  1.00 40.00           C  
ATOM    962  O   ASP B  22     -50.103  -4.603 -27.793  1.00 40.90           O  
ATOM    963  CB  ASP B  22     -51.911  -3.222 -30.053  1.00 40.12           C  
ATOM    964  CG  ASP B  22     -50.647  -3.851 -30.686  1.00 43.64           C  
ATOM    965  OD1 ASP B  22     -49.584  -3.176 -30.681  1.00 44.64           O  
ATOM    966  OD2 ASP B  22     -50.705  -4.999 -31.222  1.00 45.85           O  
ATOM    967  N   ALA B  23     -50.515  -2.495 -27.187  1.00 39.11           N  
ATOM    968  CA  ALA B  23     -49.293  -2.370 -26.395  1.00 38.19           C  
ATOM    969  C   ALA B  23     -49.490  -2.802 -24.943  1.00 37.20           C  
ATOM    970  O   ALA B  23     -48.586  -2.688 -24.155  1.00 38.28           O  
ATOM    971  CB  ALA B  23     -48.748  -0.947 -26.453  1.00 37.46           C  
ATOM    972  N   GLY B  24     -50.666  -3.290 -24.593  1.00 37.30           N  
ATOM    973  CA  GLY B  24     -50.922  -3.810 -23.260  1.00 37.90           C  
ATOM    974  C   GLY B  24     -51.576  -2.840 -22.286  1.00 38.13           C  
ATOM    975  O   GLY B  24     -51.726  -3.165 -21.125  1.00 38.43           O  
ATOM    976  N   TYR B  25     -51.961  -1.653 -22.753  1.00 37.99           N  
ATOM    977  CA  TYR B  25     -52.633  -0.663 -21.896  1.00 37.62           C  
ATOM    978  C   TYR B  25     -54.123  -0.696 -22.166  1.00 38.84           C  
ATOM    979  O   TYR B  25     -54.627   0.034 -23.030  1.00 40.13           O  
ATOM    980  CB  TYR B  25     -52.051   0.734 -22.127  1.00 34.35           C  
ATOM    981  CG  TYR B  25     -50.528   0.792 -22.043  1.00 33.84           C  
ATOM    982  CD1 TYR B  25     -49.758   0.902 -23.192  1.00 33.74           C  
ATOM    983  CD2 TYR B  25     -49.866   0.752 -20.825  1.00 33.68           C  
ATOM    984  CE1 TYR B  25     -48.378   0.957 -23.135  1.00 33.61           C  
ATOM    985  CE2 TYR B  25     -48.475   0.814 -20.759  1.00 32.59           C  
ATOM    986  CZ  TYR B  25     -47.739   0.902 -21.924  1.00 33.54           C  
ATOM    987  OH  TYR B  25     -46.352   0.950 -21.896  1.00 33.11           O  
ATOM    988  N   VAL B  26     -54.828  -1.539 -21.411  1.00 39.84           N  
ATOM    989  CA  VAL B  26     -56.258  -1.782 -21.628  1.00 40.44           C  
ATOM    990  C   VAL B  26     -57.151  -0.942 -20.700  1.00 40.52           C  
ATOM    991  O   VAL B  26     -58.254  -0.589 -21.081  1.00 42.34           O  
ATOM    992  CB  VAL B  26     -56.625  -3.285 -21.500  1.00 41.43           C  
ATOM    993  CG1 VAL B  26     -57.997  -3.546 -22.127  1.00 43.78           C  
ATOM    994  CG2 VAL B  26     -55.579  -4.176 -22.177  1.00 43.10           C  
ATOM    995  N   GLY B  27     -56.664  -0.605 -19.510  1.00 39.42           N  
ATOM    996  CA  GLY B  27     -57.425   0.199 -18.567  1.00 39.11           C  
ATOM    997  C   GLY B  27     -57.351   1.666 -18.969  1.00 39.71           C  
ATOM    998  O   GLY B  27     -56.288   2.270 -18.916  1.00 44.47           O  
ATOM    999  N   MET B  28     -58.465   2.220 -19.428  1.00 37.63           N  
ATOM   1000  CA  MET B  28     -58.557   3.648 -19.692  1.00 36.48           C  
ATOM   1001  C   MET B  28     -59.947   4.151 -19.418  1.00 32.79           C  
ATOM   1002  O   MET B  28     -60.909   3.402 -19.506  1.00 30.48           O  
ATOM   1003  CB  MET B  28     -58.174   3.977 -21.130  1.00 36.33           C  
ATOM   1004  CG  MET B  28     -59.011   3.330 -22.193  1.00 40.38           C  
ATOM   1005  SD  MET B  28     -58.350   3.698 -23.846  1.00 46.83           S  
ATOM   1006  CE  MET B  28     -59.360   5.045 -24.404  1.00 44.65           C  
ATOM   1007  N   THR B  29     -60.038   5.434 -19.087  1.00 30.07           N  
ATOM   1008  CA  THR B  29     -61.325   6.101 -18.912  1.00 30.57           C  
ATOM   1009  C   THR B  29     -61.456   7.151 -20.003  1.00 29.19           C  
ATOM   1010  O   THR B  29     -60.494   7.864 -20.319  1.00 28.20           O  
ATOM   1011  CB  THR B  29     -61.444   6.711 -17.521  1.00 29.28           C  
ATOM   1012  OG1 THR B  29     -61.386   5.656 -16.553  1.00 33.18           O  
ATOM   1013  CG2 THR B  29     -62.748   7.430 -17.359  1.00 31.64           C  
ATOM   1014  N   VAL B  30     -62.641   7.219 -20.603  1.00 26.99           N  
ATOM   1015  CA  VAL B  30     -62.885   8.099 -21.731  1.00 27.09           C  
ATOM   1016  C   VAL B  30     -64.079   9.042 -21.449  1.00 26.83           C  
ATOM   1017  O   VAL B  30     -65.144   8.569 -21.068  1.00 25.64           O  
ATOM   1018  CB  VAL B  30     -63.150   7.244 -22.971  1.00 28.41           C  
ATOM   1019  CG1 VAL B  30     -63.394   8.124 -24.194  1.00 26.60           C  
ATOM   1020  CG2 VAL B  30     -61.981   6.245 -23.193  1.00 25.79           C  
ATOM   1021  N   SER B  31     -63.886  10.357 -21.625  1.00 22.73           N  
ATOM   1022  CA  SER B  31     -64.943  11.349 -21.419  1.00 24.48           C  
ATOM   1023  C   SER B  31     -65.085  12.241 -22.621  1.00 24.82           C  
ATOM   1024  O   SER B  31     -64.117  12.473 -23.342  1.00 18.80           O  
ATOM   1025  CB  SER B  31     -64.623  12.294 -20.254  1.00 24.19           C  
ATOM   1026  OG  SER B  31     -64.038  11.645 -19.159  1.00 31.77           O  
ATOM   1027  N   GLU B  32     -66.291  12.769 -22.796  1.00 25.03           N  
ATOM   1028  CA  GLU B  32     -66.574  13.742 -23.816  1.00 26.57           C  
ATOM   1029  C   GLU B  32     -66.346  15.104 -23.203  1.00 26.69           C  
ATOM   1030  O   GLU B  32     -66.862  15.417 -22.129  1.00 22.41           O  
ATOM   1031  CB  GLU B  32     -68.027  13.646 -24.255  1.00 26.54           C  
ATOM   1032  CG  GLU B  32     -68.406  12.337 -24.857  1.00 27.71           C  
ATOM   1033  CD  GLU B  32     -69.841  12.346 -25.372  1.00 29.14           C  
ATOM   1034  OE1 GLU B  32     -70.355  13.417 -25.805  1.00 31.63           O  
ATOM   1035  OE2 GLU B  32     -70.447  11.267 -25.384  1.00 34.80           O  
ATOM   1036  N   VAL B  33     -65.546  15.907 -23.872  1.00 27.74           N  
ATOM   1037  CA  VAL B  33     -65.299  17.251 -23.418  1.00 27.78           C  
ATOM   1038  C   VAL B  33     -65.417  18.213 -24.606  1.00 28.16           C  
ATOM   1039  O   VAL B  33     -65.747  17.821 -25.722  1.00 26.55           O  
ATOM   1040  CB  VAL B  33     -63.904  17.370 -22.680  1.00 27.16           C  
ATOM   1041  CG1 VAL B  33     -63.755  16.295 -21.563  1.00 24.66           C  
ATOM   1042  CG2 VAL B  33     -62.685  17.282 -23.664  1.00 23.83           C  
ATOM   1043  N   LYS B  34     -65.213  19.485 -24.324  1.00 29.03           N  
ATOM   1044  CA  LYS B  34     -65.120  20.510 -25.360  1.00 30.90           C  
ATOM   1045  C   LYS B  34     -63.834  21.306 -25.182  1.00 31.37           C  
ATOM   1046  O   LYS B  34     -63.428  21.596 -24.052  1.00 30.00           O  
ATOM   1047  CB  LYS B  34     -66.311  21.448 -25.231  1.00 30.71           C  
ATOM   1048  CG  LYS B  34     -67.652  20.743 -25.332  1.00 31.62           C  
ATOM   1049  CD  LYS B  34     -68.772  21.725 -25.551  1.00 35.01           C  
ATOM   1050  CE  LYS B  34     -70.115  21.037 -25.800  1.00 40.05           C  
ATOM   1051  NZ  LYS B  34     -70.092  19.879 -26.755  1.00 39.68           N  
ATOM   1052  N   GLY B  35     -63.209  21.663 -26.310  1.00 29.27           N  
ATOM   1053  CA  GLY B  35     -62.022  22.487 -26.354  1.00 31.96           C  
ATOM   1054  C   GLY B  35     -62.129  23.500 -27.486  1.00 33.23           C  
ATOM   1055  O   GLY B  35     -63.047  23.460 -28.302  1.00 28.49           O  
ATOM   1056  N   ARG B  36     -61.188  24.426 -27.526  1.00 36.61           N  
ATOM   1057  CA  ARG B  36     -61.228  25.483 -28.519  1.00 39.61           C  
ATOM   1058  C   ARG B  36     -61.007  24.925 -29.911  1.00 38.30           C  
ATOM   1059  O   ARG B  36     -60.300  23.933 -30.092  1.00 33.25           O  
ATOM   1060  CB  ARG B  36     -60.199  26.576 -28.205  1.00 42.89           C  
ATOM   1061  CG  ARG B  36     -58.755  26.093 -28.121  1.00 50.23           C  
ATOM   1062  CD  ARG B  36     -57.919  26.486 -29.326  1.00 55.15           C  
ATOM   1063  NE  ARG B  36     -57.822  27.935 -29.508  1.00 57.11           N  
ATOM   1064  CZ  ARG B  36     -56.879  28.551 -30.229  1.00 58.78           C  
ATOM   1065  NH1 ARG B  36     -56.896  29.870 -30.333  1.00 59.59           N  
ATOM   1066  NH2 ARG B  36     -55.912  27.866 -30.840  1.00 60.16           N  
ATOM   1067  N   GLY B  37     -61.659  25.545 -30.885  1.00 39.17           N  
ATOM   1068  CA  GLY B  37     -61.435  25.221 -32.291  1.00 44.79           C  
ATOM   1069  C   GLY B  37     -60.126  25.822 -32.758  1.00 46.71           C  
ATOM   1070  O   GLY B  37     -59.472  26.543 -32.019  1.00 47.93           O  
ATOM   1071  N   VAL B  38     -59.758  25.554 -34.003  1.00 52.51           N  
ATOM   1072  CA  VAL B  38     -58.487  26.047 -34.565  1.00 53.91           C  
ATOM   1073  C   VAL B  38     -58.453  27.569 -34.846  1.00 57.11           C  
ATOM   1074  O   VAL B  38     -57.409  28.217 -34.686  1.00 59.23           O  
ATOM   1075  CB  VAL B  38     -58.138  25.285 -35.863  1.00 54.41           C  
ATOM   1076  CG1 VAL B  38     -59.110  25.651 -36.989  1.00 55.87           C  
ATOM   1077  CG2 VAL B  38     -56.721  25.593 -36.272  1.00 55.37           C  
ATOM   1078  N   GLN B  39     -59.578  28.134 -35.282  1.00 58.98           N  
ATOM   1079  CA  GLN B  39     -59.675  29.581 -35.548  1.00 59.65           C  
ATOM   1080  C   GLN B  39     -58.853  30.005 -36.770  1.00 61.74           C  
ATOM   1081  O   GLN B  39     -59.249  29.768 -37.916  1.00 63.42           O  
ATOM   1082  CB  GLN B  39     -59.251  30.390 -34.307  1.00 60.61           C  
ATOM   1083  N   VAL B  53     -67.201  32.785 -30.118  1.00 51.49           N  
ATOM   1084  CA  VAL B  53     -66.625  31.624 -30.805  1.00 52.17           C  
ATOM   1085  C   VAL B  53     -66.775  30.310 -29.992  1.00 51.38           C  
ATOM   1086  O   VAL B  53     -66.114  30.126 -28.963  1.00 51.49           O  
ATOM   1087  CB  VAL B  53     -65.132  31.893 -31.146  1.00 53.62           C  
ATOM   1088  CG1 VAL B  53     -64.447  32.654 -30.005  1.00 53.80           C  
ATOM   1089  CG2 VAL B  53     -64.391  30.588 -31.477  1.00 53.26           C  
ATOM   1090  N   ASP B  54     -67.628  29.403 -30.475  1.00 49.74           N  
ATOM   1091  CA  ASP B  54     -67.943  28.163 -29.759  1.00 47.14           C  
ATOM   1092  C   ASP B  54     -66.752  27.212 -29.597  1.00 45.68           C  
ATOM   1093  O   ASP B  54     -65.877  27.117 -30.464  1.00 45.74           O  
ATOM   1094  CB  ASP B  54     -69.047  27.361 -30.468  1.00 51.27           C  
ATOM   1095  CG  ASP B  54     -70.422  27.992 -30.356  1.00 55.34           C  
ATOM   1096  OD1 ASP B  54     -70.891  28.550 -31.376  1.00 61.63           O  
ATOM   1097  OD2 ASP B  54     -71.042  27.899 -29.269  1.00 58.30           O  
ATOM   1098  N   LEU B  55     -66.760  26.503 -28.475  1.00 39.45           N  
ATOM   1099  CA  LEU B  55     -65.898  25.351 -28.247  1.00 34.39           C  
ATOM   1100  C   LEU B  55     -66.435  24.176 -29.048  1.00 30.50           C  
ATOM   1101  O   LEU B  55     -67.626  24.126 -29.312  1.00 30.24           O  
ATOM   1102  CB  LEU B  55     -65.924  24.979 -26.766  1.00 29.83           C  
ATOM   1103  CG  LEU B  55     -65.360  26.015 -25.769  1.00 29.99           C  
ATOM   1104  CD1 LEU B  55     -65.575  25.520 -24.356  1.00 34.60           C  
ATOM   1105  CD2 LEU B  55     -63.861  26.290 -26.018  1.00 23.63           C  
ATOM   1106  N   ILE B  56     -65.570  23.204 -29.345  1.00 27.49           N  
ATOM   1107  CA  ILE B  56     -65.938  22.037 -30.146  1.00 26.98           C  
ATOM   1108  C   ILE B  56     -65.679  20.738 -29.379  1.00 26.76           C  
ATOM   1109  O   ILE B  56     -64.913  20.716 -28.410  1.00 21.31           O  
ATOM   1110  CB  ILE B  56     -65.172  22.024 -31.481  1.00 24.02           C  
ATOM   1111  CG1 ILE B  56     -63.654  21.978 -31.243  1.00 28.84           C  
ATOM   1112  CG2 ILE B  56     -65.531  23.276 -32.311  1.00 27.63           C  
ATOM   1113  CD1 ILE B  56     -62.809  21.676 -32.514  1.00 20.55           C  
ATOM   1114  N   PRO B  57     -66.311  19.648 -29.823  1.00 32.19           N  
ATOM   1115  CA  PRO B  57     -66.126  18.377 -29.161  1.00 30.68           C  
ATOM   1116  C   PRO B  57     -64.722  17.801 -29.292  1.00 29.93           C  
ATOM   1117  O   PRO B  57     -64.114  17.826 -30.378  1.00 27.65           O  
ATOM   1118  CB  PRO B  57     -67.155  17.452 -29.823  1.00 30.56           C  
ATOM   1119  CG  PRO B  57     -67.963  18.274 -30.672  1.00 31.33           C  
ATOM   1120  CD  PRO B  57     -67.240  19.528 -30.955  1.00 31.51           C  
ATOM   1121  N   LYS B  58     -64.237  17.305 -28.154  1.00 27.37           N  
ATOM   1122  CA  LYS B  58     -62.978  16.559 -28.058  1.00 27.98           C  
ATOM   1123  C   LYS B  58     -63.207  15.365 -27.136  1.00 26.71           C  
ATOM   1124  O   LYS B  58     -64.234  15.267 -26.468  1.00 24.25           O  
ATOM   1125  CB  LYS B  58     -61.852  17.435 -27.495  1.00 29.43           C  
ATOM   1126  CG  LYS B  58     -61.530  18.701 -28.296  1.00 31.42           C  
ATOM   1127  CD  LYS B  58     -60.927  18.373 -29.649  1.00 33.10           C  
ATOM   1128  CE  LYS B  58     -60.318  19.625 -30.346  1.00 37.93           C  
ATOM   1129  NZ  LYS B  58     -59.753  19.386 -31.729  1.00 30.97           N  
ATOM   1130  N   VAL B  59     -62.260  14.437 -27.142  1.00 26.04           N  
ATOM   1131  CA  VAL B  59     -62.305  13.295 -26.240  1.00 27.30           C  
ATOM   1132  C   VAL B  59     -61.133  13.379 -25.271  1.00 26.87           C  
ATOM   1133  O   VAL B  59     -59.982  13.646 -25.668  1.00 25.19           O  
ATOM   1134  CB  VAL B  59     -62.222  11.939 -26.980  1.00 27.04           C  
ATOM   1135  CG1 VAL B  59     -63.582  11.501 -27.432  1.00 32.19           C  
ATOM   1136  CG2 VAL B  59     -61.638  10.891 -26.072  1.00 30.22           C  
ATOM   1137  N   LYS B  60     -61.428  13.124 -24.002  1.00 26.64           N  
ATOM   1138  CA  LYS B  60     -60.390  13.012 -22.977  1.00 27.64           C  
ATOM   1139  C   LYS B  60     -60.163  11.547 -22.647  1.00 27.16           C  
ATOM   1140  O   LYS B  60     -61.083  10.851 -22.232  1.00 26.81           O  
ATOM   1141  CB  LYS B  60     -60.753  13.747 -21.683  1.00 27.15           C  
ATOM   1142  CG  LYS B  60     -59.610  13.724 -20.614  1.00 28.59           C  
ATOM   1143  CD  LYS B  60     -60.081  13.977 -19.174  1.00 31.39           C  
ATOM   1144  CE  LYS B  60     -60.116  15.430 -18.789  1.00 34.02           C  
ATOM   1145  NZ  LYS B  60     -60.740  15.607 -17.425  1.00 34.21           N  
ATOM   1146  N   ILE B  61     -58.935  11.087 -22.844  1.00 26.49           N  
ATOM   1147  CA  ILE B  61     -58.549   9.758 -22.433  1.00 27.88           C  
ATOM   1148  C   ILE B  61     -57.668   9.877 -21.204  1.00 27.11           C  
ATOM   1149  O   ILE B  61     -56.730  10.674 -21.187  1.00 27.45           O  
ATOM   1150  CB  ILE B  61     -57.786   8.983 -23.533  1.00 29.76           C  
ATOM   1151  CG1 ILE B  61     -58.673   8.752 -24.754  1.00 29.28           C  
ATOM   1152  CG2 ILE B  61     -57.311   7.641 -22.964  1.00 30.28           C  
ATOM   1153  CD1 ILE B  61     -57.909   8.189 -25.985  1.00 31.33           C  
ATOM   1154  N   GLU B  62     -57.995   9.122 -20.164  1.00 26.29           N  
ATOM   1155  CA  GLU B  62     -57.209   9.095 -18.930  1.00 27.99           C  
ATOM   1156  C   GLU B  62     -56.711   7.665 -18.687  1.00 27.79           C  
ATOM   1157  O   GLU B  62     -57.511   6.726 -18.657  1.00 26.93           O  
ATOM   1158  CB  GLU B  62     -58.028   9.512 -17.725  1.00 25.57           C  
ATOM   1159  CG  GLU B  62     -58.638  10.878 -17.781  1.00 31.64           C  
ATOM   1160  CD  GLU B  62     -59.694  11.083 -16.702  1.00 32.48           C  
ATOM   1161  OE1 GLU B  62     -60.855  10.686 -16.921  1.00 38.64           O  
ATOM   1162  OE2 GLU B  62     -59.374  11.672 -15.646  1.00 41.28           O  
ATOM   1163  N   LEU B  63     -55.403   7.517 -18.522  1.00 27.41           N  
ATOM   1164  CA  LEU B  63     -54.791   6.233 -18.203  1.00 28.57           C  
ATOM   1165  C   LEU B  63     -53.819   6.401 -17.066  1.00 26.81           C  
ATOM   1166  O   LEU B  63     -52.900   7.240 -17.163  1.00 27.46           O  
ATOM   1167  CB  LEU B  63     -53.946   5.711 -19.352  1.00 29.35           C  
ATOM   1168  CG  LEU B  63     -54.470   5.302 -20.697  1.00 34.69           C  
ATOM   1169  CD1 LEU B  63     -54.434   6.482 -21.642  1.00 36.29           C  
ATOM   1170  CD2 LEU B  63     -53.564   4.170 -21.188  1.00 34.19           C  
ATOM   1171  N   VAL B  64     -53.971   5.583 -16.032  1.00 24.78           N  
ATOM   1172  CA  VAL B  64     -53.042   5.562 -14.917  1.00 25.45           C  
ATOM   1173  C   VAL B  64     -52.087   4.409 -15.101  1.00 26.84           C  
ATOM   1174  O   VAL B  64     -52.491   3.257 -15.244  1.00 26.45           O  
ATOM   1175  CB  VAL B  64     -53.758   5.442 -13.578  1.00 24.78           C  
ATOM   1176  CG1 VAL B  64     -52.749   5.405 -12.443  1.00 20.87           C  
ATOM   1177  CG2 VAL B  64     -54.738   6.601 -13.440  1.00 22.63           C  
ATOM   1178  N   VAL B  65     -50.801   4.733 -15.128  1.00 26.58           N  
ATOM   1179  CA  VAL B  65     -49.782   3.748 -15.398  1.00 26.97           C  
ATOM   1180  C   VAL B  65     -48.620   3.925 -14.456  1.00 28.13           C  
ATOM   1181  O   VAL B  65     -48.489   4.959 -13.789  1.00 26.56           O  
ATOM   1182  CB  VAL B  65     -49.237   3.862 -16.846  1.00 28.83           C  
ATOM   1183  CG1 VAL B  65     -50.289   3.436 -17.864  1.00 22.76           C  
ATOM   1184  CG2 VAL B  65     -48.673   5.268 -17.100  1.00 25.21           C  
ATOM   1185  N   LYS B  66     -47.766   2.905 -14.427  1.00 28.40           N  
ATOM   1186  CA  LYS B  66     -46.448   3.000 -13.811  1.00 29.80           C  
ATOM   1187  C   LYS B  66     -45.656   4.126 -14.442  1.00 28.55           C  
ATOM   1188  O   LYS B  66     -45.688   4.300 -15.670  1.00 26.98           O  
ATOM   1189  CB  LYS B  66     -45.658   1.699 -14.052  1.00 31.85           C  
ATOM   1190  CG  LYS B  66     -46.059   0.542 -13.168  1.00 37.04           C  
ATOM   1191  CD  LYS B  66     -45.221  -0.718 -13.461  1.00 36.15           C  
ATOM   1192  CE  LYS B  66     -45.797  -1.525 -14.610  1.00 43.54           C  
ATOM   1193  NZ  LYS B  66     -44.784  -2.398 -15.300  1.00 47.17           N  
ATOM   1194  N   GLU B  67     -44.895   4.863 -13.635  1.00 29.03           N  
ATOM   1195  CA  GLU B  67     -44.085   5.963 -14.171  1.00 30.51           C  
ATOM   1196  C   GLU B  67     -43.190   5.521 -15.331  1.00 30.47           C  
ATOM   1197  O   GLU B  67     -43.055   6.248 -16.296  1.00 28.20           O  
ATOM   1198  CB  GLU B  67     -43.274   6.689 -13.090  1.00 31.78           C  
ATOM   1199  CG  GLU B  67     -42.223   7.650 -13.675  1.00 34.36           C  
ATOM   1200  CD  GLU B  67     -41.627   8.617 -12.665  1.00 35.87           C  
ATOM   1201  OE1 GLU B  67     -41.397   9.796 -13.048  1.00 41.09           O  
ATOM   1202  OE2 GLU B  67     -41.385   8.207 -11.520  1.00 41.14           O  
ATOM   1203  N   GLU B  68     -42.631   4.308 -15.263  1.00 32.10           N  
ATOM   1204  CA  GLU B  68     -41.736   3.792 -16.320  1.00 34.28           C  
ATOM   1205  C   GLU B  68     -42.431   3.624 -17.687  1.00 33.26           C  
ATOM   1206  O   GLU B  68     -41.770   3.557 -18.716  1.00 34.17           O  
ATOM   1207  CB  GLU B  68     -41.094   2.472 -15.858  1.00 34.87           C  
ATOM   1208  CG  GLU B  68     -42.045   1.317 -15.874  1.00 38.65           C  
ATOM   1209  CD  GLU B  68     -41.652   0.185 -14.937  1.00 42.19           C  
ATOM   1210  OE1 GLU B  68     -41.452   0.445 -13.729  1.00 49.09           O  
ATOM   1211  OE2 GLU B  68     -41.575  -0.978 -15.413  1.00 51.62           O  
ATOM   1212  N   ASP B  69     -43.759   3.543 -17.690  1.00 32.26           N  
ATOM   1213  CA  ASP B  69     -44.529   3.370 -18.913  1.00 31.52           C  
ATOM   1214  C   ASP B  69     -45.017   4.676 -19.570  1.00 30.07           C  
ATOM   1215  O   ASP B  69     -45.533   4.657 -20.671  1.00 29.40           O  
ATOM   1216  CB  ASP B  69     -45.716   2.462 -18.618  1.00 31.74           C  
ATOM   1217  CG  ASP B  69     -45.289   1.012 -18.337  1.00 35.58           C  
ATOM   1218  OD1 ASP B  69     -44.316   0.534 -18.952  1.00 38.15           O  
ATOM   1219  OD2 ASP B  69     -45.936   0.359 -17.497  1.00 39.06           O  
ATOM   1220  N   VAL B  70     -44.825   5.800 -18.899  1.00 30.05           N  
ATOM   1221  CA  VAL B  70     -45.345   7.100 -19.372  1.00 28.94           C  
ATOM   1222  C   VAL B  70     -44.807   7.460 -20.761  1.00 29.09           C  
ATOM   1223  O   VAL B  70     -45.583   7.787 -21.650  1.00 28.49           O  
ATOM   1224  CB  VAL B  70     -45.083   8.249 -18.344  1.00 29.46           C  
ATOM   1225  CG1 VAL B  70     -45.320   9.645 -18.967  1.00 24.25           C  
ATOM   1226  CG2 VAL B  70     -45.944   8.062 -17.073  1.00 25.30           C  
ATOM   1227  N   ASP B  71     -43.491   7.360 -20.969  1.00 29.03           N  
ATOM   1228  CA  ASP B  71     -42.906   7.713 -22.279  1.00 30.03           C  
ATOM   1229  C   ASP B  71     -43.509   6.918 -23.415  1.00 29.77           C  
ATOM   1230  O   ASP B  71     -43.832   7.467 -24.471  1.00 30.57           O  
ATOM   1231  CB  ASP B  71     -41.392   7.498 -22.290  1.00 33.10           C  
ATOM   1232  CG  ASP B  71     -40.638   8.605 -21.584  1.00 37.51           C  
ATOM   1233  OD1 ASP B  71     -41.228   9.668 -21.295  1.00 39.71           O  
ATOM   1234  OD2 ASP B  71     -39.434   8.401 -21.319  1.00 43.35           O  
ATOM   1235  N   ASN B  72     -43.663   5.620 -23.189  1.00 30.29           N  
ATOM   1236  CA  ASN B  72     -44.262   4.730 -24.182  1.00 30.35           C  
ATOM   1237  C   ASN B  72     -45.726   5.096 -24.482  1.00 29.78           C  
ATOM   1238  O   ASN B  72     -46.128   5.171 -25.634  1.00 30.54           O  
ATOM   1239  CB  ASN B  72     -44.147   3.296 -23.676  1.00 31.85           C  
ATOM   1240  CG  ASN B  72     -44.581   2.271 -24.683  1.00 32.37           C  
ATOM   1241  OD1 ASN B  72     -44.285   2.376 -25.863  1.00 35.19           O  
ATOM   1242  ND2 ASN B  72     -45.239   1.222 -24.199  1.00 35.60           N  
ATOM   1243  N   VAL B  73     -46.500   5.328 -23.438  1.00 28.86           N  
ATOM   1244  CA  VAL B  73     -47.919   5.715 -23.591  1.00 27.79           C  
ATOM   1245  C   VAL B  73     -48.024   7.013 -24.404  1.00 26.73           C  
ATOM   1246  O   VAL B  73     -48.809   7.098 -25.345  1.00 27.33           O  
ATOM   1247  CB  VAL B  73     -48.599   5.873 -22.234  1.00 27.70           C  
ATOM   1248  CG1 VAL B  73     -49.991   6.582 -22.372  1.00 27.25           C  
ATOM   1249  CG2 VAL B  73     -48.722   4.483 -21.518  1.00 24.50           C  
ATOM   1250  N   ILE B  74     -47.202   7.994 -24.055  1.00 26.63           N  
ATOM   1251  CA  ILE B  74     -47.174   9.272 -24.772  1.00 27.86           C  
ATOM   1252  C   ILE B  74     -46.794   9.083 -26.243  1.00 29.56           C  
ATOM   1253  O   ILE B  74     -47.410   9.689 -27.118  1.00 29.35           O  
ATOM   1254  CB  ILE B  74     -46.212  10.275 -24.098  1.00 28.66           C  
ATOM   1255  CG1 ILE B  74     -46.788  10.764 -22.750  1.00 28.65           C  
ATOM   1256  CG2 ILE B  74     -45.905  11.447 -25.004  1.00 24.62           C  
ATOM   1257  CD1 ILE B  74     -45.787  11.669 -22.025  1.00 29.07           C  
ATOM   1258  N   ASP B  75     -45.788   8.251 -26.512  1.00 29.48           N  
ATOM   1259  CA  ASP B  75     -45.367   7.974 -27.905  1.00 31.12           C  
ATOM   1260  C   ASP B  75     -46.506   7.382 -28.726  1.00 29.79           C  
ATOM   1261  O   ASP B  75     -46.772   7.839 -29.835  1.00 30.79           O  
ATOM   1262  CB  ASP B  75     -44.173   7.010 -27.967  1.00 31.99           C  
ATOM   1263  CG  ASP B  75     -42.864   7.623 -27.467  1.00 37.62           C  
ATOM   1264  OD1 ASP B  75     -42.776   8.854 -27.293  1.00 34.94           O  
ATOM   1265  OD2 ASP B  75     -41.903   6.837 -27.241  1.00 41.15           O  
ATOM   1266  N   ILE B  76     -47.170   6.374 -28.164  1.00 29.13           N  
ATOM   1267  CA  ILE B  76     -48.289   5.703 -28.831  1.00 29.36           C  
ATOM   1268  C   ILE B  76     -49.434   6.694 -29.134  1.00 30.72           C  
ATOM   1269  O   ILE B  76     -49.964   6.738 -30.259  1.00 29.57           O  
ATOM   1270  CB  ILE B  76     -48.804   4.508 -27.991  1.00 29.24           C  
ATOM   1271  CG1 ILE B  76     -47.735   3.403 -27.894  1.00 31.46           C  
ATOM   1272  CG2 ILE B  76     -50.081   3.926 -28.568  1.00 25.73           C  
ATOM   1273  CD1 ILE B  76     -48.067   2.355 -26.861  1.00 27.94           C  
ATOM   1274  N   ILE B  77     -49.788   7.502 -28.141  1.00 29.31           N  
ATOM   1275  CA  ILE B  77     -50.874   8.463 -28.310  1.00 29.08           C  
ATOM   1276  C   ILE B  77     -50.528   9.485 -29.391  1.00 28.97           C  
ATOM   1277  O   ILE B  77     -51.315   9.740 -30.285  1.00 28.40           O  
ATOM   1278  CB  ILE B  77     -51.233   9.164 -26.976  1.00 27.49           C  
ATOM   1279  CG1 ILE B  77     -51.860   8.150 -26.007  1.00 27.61           C  
ATOM   1280  CG2 ILE B  77     -52.202  10.322 -27.226  1.00 26.36           C  
ATOM   1281  CD1 ILE B  77     -51.950   8.618 -24.569  1.00 26.19           C  
ATOM   1282  N   CYS B  78     -49.333  10.049 -29.316  1.00 30.15           N  
ATOM   1283  CA  CYS B  78     -48.914  11.051 -30.293  1.00 31.65           C  
ATOM   1284  C   CYS B  78     -48.920  10.486 -31.706  1.00 32.79           C  
ATOM   1285  O   CYS B  78     -49.443  11.113 -32.620  1.00 33.37           O  
ATOM   1286  CB  CYS B  78     -47.538  11.627 -29.937  1.00 29.81           C  
ATOM   1287  SG  CYS B  78     -47.557  12.746 -28.512  1.00 29.28           S  
ATOM   1288  N   GLU B  79     -48.345   9.308 -31.879  1.00 33.16           N  
ATOM   1289  CA  GLU B  79     -48.257   8.683 -33.203  1.00 34.71           C  
ATOM   1290  C   GLU B  79     -49.631   8.457 -33.833  1.00 33.74           C  
ATOM   1291  O   GLU B  79     -49.849   8.712 -35.014  1.00 32.36           O  
ATOM   1292  CB  GLU B  79     -47.526   7.344 -33.110  1.00 33.82           C  
ATOM   1293  CG  GLU B  79     -46.953   6.895 -34.425  1.00 39.95           C  
ATOM   1294  CD  GLU B  79     -45.858   5.858 -34.245  0.50 41.43           C  
ATOM   1295  OE1 GLU B  79     -46.174   4.709 -33.884  0.50 47.87           O  
ATOM   1296  OE2 GLU B  79     -44.678   6.204 -34.461  0.50 49.71           O  
ATOM   1297  N   ASN B  80     -50.564   7.979 -33.020  1.00 32.75           N  
ATOM   1298  CA  ASN B  80     -51.886   7.589 -33.500  1.00 32.23           C  
ATOM   1299  C   ASN B  80     -52.946   8.674 -33.481  1.00 31.59           C  
ATOM   1300  O   ASN B  80     -53.912   8.568 -34.216  1.00 30.83           O  
ATOM   1301  CB  ASN B  80     -52.359   6.384 -32.710  1.00 30.17           C  
ATOM   1302  CG  ASN B  80     -51.518   5.169 -33.001  1.00 31.24           C  
ATOM   1303  OD1 ASN B  80     -50.600   4.829 -32.244  1.00 33.65           O  
ATOM   1304  ND2 ASN B  80     -51.768   4.556 -34.142  1.00 27.59           N  
ATOM   1305  N   ALA B  81     -52.745   9.722 -32.678  1.00 31.34           N  
ATOM   1306  CA  ALA B  81     -53.707  10.837 -32.585  1.00 30.90           C  
ATOM   1307  C   ALA B  81     -53.403  11.987 -33.531  1.00 30.55           C  
ATOM   1308  O   ALA B  81     -54.297  12.787 -33.825  1.00 28.48           O  
ATOM   1309  CB  ALA B  81     -53.797  11.360 -31.134  1.00 28.86           C  
ATOM   1310  N   ARG B  82     -52.154  12.086 -33.985  1.00 31.36           N  
ATOM   1311  CA  ARG B  82     -51.727  13.197 -34.824  1.00 33.68           C  
ATOM   1312  C   ARG B  82     -52.329  13.146 -36.218  1.00 33.65           C  
ATOM   1313  O   ARG B  82     -52.593  12.076 -36.741  1.00 31.60           O  
ATOM   1314  CB  ARG B  82     -50.204  13.182 -34.981  1.00 32.99           C  
ATOM   1315  CG  ARG B  82     -49.646  11.941 -35.729  1.00 34.20           C  
ATOM   1316  CD  ARG B  82     -48.115  11.985 -35.793  1.00 35.48           C  
ATOM   1317  NE  ARG B  82     -47.682  13.370 -35.935  1.00 36.18           N  
ATOM   1318  CZ  ARG B  82     -47.781  14.087 -37.052  1.00 39.62           C  
ATOM   1319  NH1 ARG B  82     -48.281  13.543 -38.145  1.00 39.43           N  
ATOM   1320  NH2 ARG B  82     -47.393  15.354 -37.069  1.00 36.41           N  
ATOM   1321  N   THR B  83     -52.522  14.322 -36.802  1.00 35.57           N  
ATOM   1322  CA  THR B  83     -52.908  14.471 -38.204  1.00 35.76           C  
ATOM   1323  C   THR B  83     -52.007  15.451 -38.955  1.00 37.73           C  
ATOM   1324  O   THR B  83     -52.041  15.481 -40.174  1.00 38.95           O  
ATOM   1325  CB  THR B  83     -54.341  14.997 -38.362  1.00 34.11           C  
ATOM   1326  OG1 THR B  83     -54.389  16.349 -37.895  1.00 31.46           O  
ATOM   1327  CG2 THR B  83     -55.328  14.142 -37.607  1.00 33.36           C  
ATOM   1328  N   GLY B  84     -51.242  16.270 -38.246  1.00 37.40           N  
ATOM   1329  CA  GLY B  84     -50.432  17.295 -38.896  1.00 38.53           C  
ATOM   1330  C   GLY B  84     -51.093  18.651 -38.996  1.00 39.72           C  
ATOM   1331  O   GLY B  84     -50.450  19.606 -39.426  1.00 41.32           O  
ATOM   1332  N   ASN B  85     -52.356  18.744 -38.573  1.00 40.66           N  
ATOM   1333  CA  ASN B  85     -53.090  20.005 -38.565  1.00 39.96           C  
ATOM   1334  C   ASN B  85     -53.253  20.484 -37.127  1.00 39.95           C  
ATOM   1335  O   ASN B  85     -53.331  19.661 -36.233  1.00 39.76           O  
ATOM   1336  CB  ASN B  85     -54.443  19.815 -39.287  1.00 40.19           C  
ATOM   1337  CG  ASN B  85     -54.284  19.331 -40.750  1.00 43.36           C  
ATOM   1338  OD1 ASN B  85     -53.464  19.849 -41.507  1.00 46.73           O  
ATOM   1339  ND2 ASN B  85     -55.071  18.333 -41.138  1.00 43.80           N  
ATOM   1340  N   PRO B  86     -53.261  21.811 -36.905  1.00 40.86           N  
ATOM   1341  CA  PRO B  86     -53.610  22.427 -35.613  1.00 40.02           C  
ATOM   1342  C   PRO B  86     -54.888  21.817 -35.036  1.00 38.64           C  
ATOM   1343  O   PRO B  86     -55.834  21.592 -35.789  1.00 38.11           O  
ATOM   1344  CB  PRO B  86     -53.828  23.896 -35.983  1.00 40.85           C  
ATOM   1345  CG  PRO B  86     -53.032  24.118 -37.236  1.00 43.52           C  
ATOM   1346  CD  PRO B  86     -52.935  22.813 -37.945  1.00 41.73           C  
ATOM   1347  N   GLY B  87     -54.894  21.556 -33.730  1.00 37.06           N  
ATOM   1348  CA  GLY B  87     -56.017  20.938 -33.054  1.00 35.51           C  
ATOM   1349  C   GLY B  87     -55.870  19.459 -32.800  1.00 33.56           C  
ATOM   1350  O   GLY B  87     -56.843  18.801 -32.462  1.00 35.06           O  
ATOM   1351  N   ASP B  88     -54.660  18.929 -32.937  1.00 31.32           N  
ATOM   1352  CA  ASP B  88     -54.402  17.502 -32.657  1.00 30.62           C  
ATOM   1353  C   ASP B  88     -54.462  17.174 -31.162  1.00 30.17           C  
ATOM   1354  O   ASP B  88     -54.643  16.011 -30.788  1.00 28.57           O  
ATOM   1355  CB  ASP B  88     -53.057  17.022 -33.242  1.00 29.35           C  
ATOM   1356  CG  ASP B  88     -53.110  16.710 -34.751  1.00 31.41           C  
ATOM   1357  OD1 ASP B  88     -54.191  16.631 -35.365  1.00 28.39           O  
ATOM   1358  OD2 ASP B  88     -52.027  16.485 -35.342  1.00 28.97           O  
ATOM   1359  N   GLY B  89     -54.269  18.187 -30.316  1.00 29.10           N  
ATOM   1360  CA  GLY B  89     -54.468  18.043 -28.879  1.00 29.32           C  
ATOM   1361  C   GLY B  89     -53.200  18.094 -28.061  1.00 29.16           C  
ATOM   1362  O   GLY B  89     -52.104  18.403 -28.576  1.00 25.86           O  
ATOM   1363  N   LYS B  90     -53.368  17.781 -26.776  1.00 28.02           N  
ATOM   1364  CA  LYS B  90     -52.312  17.878 -25.792  1.00 29.01           C  
ATOM   1365  C   LYS B  90     -52.427  16.745 -24.806  1.00 27.38           C  
ATOM   1366  O   LYS B  90     -53.518  16.179 -24.629  1.00 25.69           O  
ATOM   1367  CB  LYS B  90     -52.387  19.231 -25.084  1.00 32.29           C  
ATOM   1368  CG  LYS B  90     -52.017  20.378 -26.024  1.00 37.00           C  
ATOM   1369  CD  LYS B  90     -51.928  21.737 -25.351  1.00 38.51           C  
ATOM   1370  CE  LYS B  90     -51.476  22.848 -26.361  1.00 41.45           C  
ATOM   1371  NZ  LYS B  90     -51.987  22.670 -27.766  1.00 44.18           N  
ATOM   1372  N   ILE B  91     -51.290  16.419 -24.193  1.00 25.10           N  
ATOM   1373  CA  ILE B  91     -51.181  15.371 -23.176  1.00 25.08           C  
ATOM   1374  C   ILE B  91     -50.609  16.000 -21.913  1.00 25.18           C  
ATOM   1375  O   ILE B  91     -49.667  16.788 -21.995  1.00 24.21           O  
ATOM   1376  CB  ILE B  91     -50.233  14.275 -23.636  1.00 24.82           C  
ATOM   1377  CG1 ILE B  91     -50.770  13.604 -24.897  1.00 24.56           C  
ATOM   1378  CG2 ILE B  91     -49.951  13.297 -22.507  1.00 23.23           C  
ATOM   1379  CD1 ILE B  91     -49.846  12.626 -25.498  1.00 25.95           C  
ATOM   1380  N   PHE B  92     -51.189  15.651 -20.768  1.00 22.64           N  
ATOM   1381  CA  PHE B  92     -50.700  16.061 -19.459  1.00 23.83           C  
ATOM   1382  C   PHE B  92     -50.377  14.833 -18.625  1.00 23.32           C  
ATOM   1383  O   PHE B  92     -51.090  13.805 -18.666  1.00 22.97           O  
ATOM   1384  CB  PHE B  92     -51.743  16.890 -18.699  1.00 24.06           C  
ATOM   1385  CG  PHE B  92     -52.373  17.938 -19.526  1.00 27.43           C  
ATOM   1386  CD1 PHE B  92     -51.589  18.921 -20.128  1.00 25.63           C  
ATOM   1387  CD2 PHE B  92     -53.743  17.974 -19.703  1.00 29.14           C  
ATOM   1388  CE1 PHE B  92     -52.156  19.900 -20.886  1.00 26.99           C  
ATOM   1389  CE2 PHE B  92     -54.312  18.962 -20.492  1.00 31.02           C  
ATOM   1390  CZ  PHE B  92     -53.515  19.923 -21.077  1.00 30.48           C  
ATOM   1391  N   VAL B  93     -49.328  14.959 -17.832  1.00 22.68           N  
ATOM   1392  CA  VAL B  93     -48.991  13.936 -16.854  1.00 22.30           C  
ATOM   1393  C   VAL B  93     -49.182  14.497 -15.459  1.00 23.36           C  
ATOM   1394  O   VAL B  93     -48.603  15.503 -15.098  1.00 22.96           O  
ATOM   1395  CB  VAL B  93     -47.555  13.420 -16.998  1.00 23.92           C  
ATOM   1396  CG1 VAL B  93     -47.327  12.924 -18.429  1.00 20.79           C  
ATOM   1397  CG2 VAL B  93     -47.286  12.287 -15.995  1.00 23.93           C  
ATOM   1398  N   ILE B  94     -49.978  13.794 -14.673  1.00 22.86           N  
ATOM   1399  CA  ILE B  94     -50.372  14.201 -13.353  1.00 23.59           C  
ATOM   1400  C   ILE B  94     -49.986  13.126 -12.330  1.00 23.25           C  
ATOM   1401  O   ILE B  94     -50.231  11.954 -12.549  1.00 22.08           O  
ATOM   1402  CB  ILE B  94     -51.905  14.410 -13.374  1.00 24.01           C  
ATOM   1403  CG1 ILE B  94     -52.237  15.652 -14.207  1.00 25.65           C  
ATOM   1404  CG2 ILE B  94     -52.499  14.483 -11.943  1.00 21.70           C  
ATOM   1405  CD1 ILE B  94     -53.527  15.540 -14.917  1.00 27.35           C  
ATOM   1406  N   PRO B  95     -49.364  13.520 -11.200  1.00 24.15           N  
ATOM   1407  CA  PRO B  95     -49.044  12.505 -10.197  1.00 23.48           C  
ATOM   1408  C   PRO B  95     -50.263  11.834  -9.583  1.00 23.39           C  
ATOM   1409  O   PRO B  95     -51.257  12.494  -9.281  1.00 22.87           O  
ATOM   1410  CB  PRO B  95     -48.332  13.298  -9.112  1.00 25.77           C  
ATOM   1411  CG  PRO B  95     -48.819  14.693  -9.298  1.00 25.92           C  
ATOM   1412  CD  PRO B  95     -48.921  14.850 -10.768  1.00 23.67           C  
ATOM   1413  N   VAL B  96     -50.185  10.521  -9.400  1.00 22.89           N  
ATOM   1414  CA  VAL B  96     -51.203   9.800  -8.630  1.00 23.37           C  
ATOM   1415  C   VAL B  96     -50.496   9.189  -7.417  1.00 24.92           C  
ATOM   1416  O   VAL B  96     -49.524   8.444  -7.558  1.00 26.72           O  
ATOM   1417  CB  VAL B  96     -51.924   8.755  -9.482  1.00 25.56           C  
ATOM   1418  CG1 VAL B  96     -52.880   7.925  -8.659  1.00 21.76           C  
ATOM   1419  CG2 VAL B  96     -52.679   9.400 -10.675  1.00 21.26           C  
ATOM   1420  N   GLU B  97     -50.965   9.530  -6.226  1.00 24.95           N  
ATOM   1421  CA  GLU B  97     -50.284   9.108  -4.994  1.00 27.37           C  
ATOM   1422  C   GLU B  97     -50.774   7.733  -4.502  1.00 27.60           C  
ATOM   1423  O   GLU B  97     -50.088   7.044  -3.759  1.00 28.67           O  
ATOM   1424  CB  GLU B  97     -50.466  10.183  -3.921  1.00 27.19           C  
ATOM   1425  CG  GLU B  97     -49.534  11.397  -4.156  1.00 30.69           C  
ATOM   1426  CD  GLU B  97     -49.823  12.585  -3.240  1.00 30.62           C  
ATOM   1427  OE1 GLU B  97     -48.969  13.502  -3.206  1.00 35.41           O  
ATOM   1428  OE2 GLU B  97     -50.899  12.623  -2.574  1.00 30.86           O  
ATOM   1429  N   ARG B  98     -51.961   7.342  -4.946  1.00 27.77           N  
ATOM   1430  CA  ARG B  98     -52.559   6.067  -4.537  1.00 28.47           C  
ATOM   1431  C   ARG B  98     -53.541   5.559  -5.539  1.00 26.26           C  
ATOM   1432  O   ARG B  98     -54.348   6.329  -6.052  1.00 22.90           O  
ATOM   1433  CB  ARG B  98     -53.355   6.229  -3.251  1.00 28.94           C  
ATOM   1434  CG  ARG B  98     -52.571   6.223  -1.995  1.00 36.01           C  
ATOM   1435  CD  ARG B  98     -53.488   6.387  -0.772  1.00 35.62           C  
ATOM   1436  NE  ARG B  98     -54.113   5.138  -0.344  1.00 41.16           N  
ATOM   1437  CZ  ARG B  98     -54.837   5.012   0.779  1.00 41.73           C  
ATOM   1438  NH1 ARG B  98     -55.046   6.050   1.567  1.00 40.07           N  
ATOM   1439  NH2 ARG B  98     -55.363   3.842   1.107  1.00 43.86           N  
ATOM   1440  N   VAL B  99     -53.504   4.260  -5.789  1.00 26.20           N  
ATOM   1441  CA  VAL B  99     -54.479   3.575  -6.648  1.00 27.16           C  
ATOM   1442  C   VAL B  99     -55.051   2.401  -5.858  1.00 28.66           C  
ATOM   1443  O   VAL B  99     -54.277   1.615  -5.292  1.00 27.26           O  
ATOM   1444  CB  VAL B  99     -53.826   3.009  -7.941  1.00 29.72           C  
ATOM   1445  CG1 VAL B  99     -54.868   2.403  -8.869  1.00 27.88           C  
ATOM   1446  CG2 VAL B  99     -53.044   4.083  -8.669  1.00 31.49           C  
ATOM   1447  N   VAL B 100     -56.385   2.301  -5.814  1.00 27.79           N  
ATOM   1448  CA  VAL B 100     -57.098   1.235  -5.069  1.00 29.08           C  
ATOM   1449  C   VAL B 100     -58.114   0.552  -5.982  1.00 30.00           C  
ATOM   1450  O   VAL B 100     -58.937   1.224  -6.621  1.00 28.55           O  
ATOM   1451  CB  VAL B 100     -57.884   1.772  -3.838  1.00 28.58           C  
ATOM   1452  CG1 VAL B 100     -58.465   0.619  -3.020  1.00 31.70           C  
ATOM   1453  CG2 VAL B 100     -56.988   2.627  -2.943  1.00 28.85           C  
ATOM   1454  N   ARG B 101     -58.039  -0.769  -6.089  1.00 30.50           N  
ATOM   1455  CA  ARG B 101     -59.059  -1.554  -6.782  1.00 33.59           C  
ATOM   1456  C   ARG B 101     -60.277  -1.741  -5.888  1.00 34.47           C  
ATOM   1457  O   ARG B 101     -60.148  -2.187  -4.751  1.00 35.49           O  
ATOM   1458  CB  ARG B 101     -58.505  -2.922  -7.167  1.00 34.78           C  
ATOM   1459  CG  ARG B 101     -59.515  -3.884  -7.780  1.00 35.41           C  
ATOM   1460  CD  ARG B 101     -58.795  -5.101  -8.320  1.00 40.05           C  
ATOM   1461  NE  ARG B 101     -58.257  -4.835  -9.655  1.00 47.50           N  
ATOM   1462  CZ  ARG B 101     -57.168  -5.397 -10.170  1.00 48.33           C  
ATOM   1463  NH1 ARG B 101     -56.439  -6.266  -9.481  1.00 48.26           N  
ATOM   1464  NH2 ARG B 101     -56.784  -5.055 -11.389  1.00 50.80           N  
ATOM   1465  N   VAL B 102     -61.453  -1.420  -6.413  1.00 36.32           N  
ATOM   1466  CA  VAL B 102     -62.675  -1.378  -5.604  1.00 36.65           C  
ATOM   1467  C   VAL B 102     -63.003  -2.757  -5.034  1.00 38.42           C  
ATOM   1468  O   VAL B 102     -63.131  -2.908  -3.825  1.00 36.54           O  
ATOM   1469  CB  VAL B 102     -63.879  -0.770  -6.400  1.00 35.27           C  
ATOM   1470  CG1 VAL B 102     -65.212  -1.109  -5.761  1.00 34.65           C  
ATOM   1471  CG2 VAL B 102     -63.727   0.768  -6.507  1.00 33.96           C  
ATOM   1472  N   ARG B 103     -63.061  -3.766  -5.891  1.00 41.78           N  
ATOM   1473  CA  ARG B 103     -63.569  -5.079  -5.470  1.00 43.94           C  
ATOM   1474  C   ARG B 103     -62.696  -5.888  -4.525  1.00 45.28           C  
ATOM   1475  O   ARG B 103     -63.227  -6.756  -3.817  1.00 45.78           O  
ATOM   1476  CB  ARG B 103     -63.962  -5.932  -6.672  1.00 45.25           C  
ATOM   1477  CG  ARG B 103     -62.863  -6.348  -7.594  1.00 46.84           C  
ATOM   1478  CD  ARG B 103     -63.481  -6.900  -8.855  1.00 49.43           C  
ATOM   1479  NE  ARG B 103     -62.530  -6.890  -9.955  1.00 54.75           N  
ATOM   1480  CZ  ARG B 103     -61.594  -7.810 -10.149  1.00 55.36           C  
ATOM   1481  NH1 ARG B 103     -61.478  -8.847  -9.324  1.00 58.12           N  
ATOM   1482  NH2 ARG B 103     -60.770  -7.690 -11.185  1.00 57.03           N  
ATOM   1483  N   THR B 104     -61.390  -5.605  -4.500  1.00 44.26           N  
ATOM   1484  CA  THR B 104     -60.449  -6.297  -3.616  1.00 45.24           C  
ATOM   1485  C   THR B 104     -59.742  -5.382  -2.625  1.00 46.54           C  
ATOM   1486  O   THR B 104     -59.047  -5.874  -1.736  1.00 45.87           O  
ATOM   1487  CB  THR B 104     -59.339  -6.992  -4.429  1.00 45.99           C  
ATOM   1488  OG1 THR B 104     -58.558  -5.994  -5.095  1.00 43.46           O  
ATOM   1489  CG2 THR B 104     -59.932  -7.962  -5.463  1.00 42.69           C  
ATOM   1490  N   LYS B 105     -59.886  -4.065  -2.777  1.00 45.43           N  
ATOM   1491  CA  LYS B 105     -59.138  -3.090  -1.964  1.00 45.65           C  
ATOM   1492  C   LYS B 105     -57.599  -3.169  -2.119  1.00 43.70           C  
ATOM   1493  O   LYS B 105     -56.862  -2.489  -1.395  1.00 42.76           O  
ATOM   1494  CB  LYS B 105     -59.550  -3.180  -0.491  1.00 45.82           C  
ATOM   1495  CG  LYS B 105     -60.987  -2.777  -0.237  1.00 47.33           C  
ATOM   1496  CD  LYS B 105     -61.104  -1.450   0.529  1.00 49.23           C  
ATOM   1497  CE  LYS B 105     -60.663  -1.589   1.978  1.00 51.76           C  
ATOM   1498  NZ  LYS B 105     -61.354  -0.636   2.915  1.00 48.93           N  
ATOM   1499  N   GLU B 106     -57.133  -3.966  -3.084  1.00 44.49           N  
ATOM   1500  CA  GLU B 106     -55.728  -3.991  -3.490  1.00 47.70           C  
ATOM   1501  C   GLU B 106     -55.238  -2.604  -3.878  1.00 46.81           C  
ATOM   1502  O   GLU B 106     -56.019  -1.771  -4.321  1.00 44.52           O  
ATOM   1503  CB  GLU B 106     -55.533  -4.908  -4.700  1.00 47.21           C  
ATOM   1504  CG  GLU B 106     -55.296  -6.357  -4.357  1.00 52.83           C  
ATOM   1505  CD  GLU B 106     -55.509  -7.299  -5.546  1.00 52.66           C  
ATOM   1506  OE1 GLU B 106     -54.780  -8.311  -5.639  1.00 61.39           O  
ATOM   1507  OE2 GLU B 106     -56.408  -7.039  -6.381  1.00 58.60           O  
ATOM   1508  N   GLU B 107     -53.930  -2.387  -3.750  1.00 49.63           N  
ATOM   1509  CA  GLU B 107     -53.312  -1.085  -4.025  1.00 49.44           C  
ATOM   1510  C   GLU B 107     -52.002  -1.186  -4.798  1.00 50.46           C  
ATOM   1511  O   GLU B 107     -51.450  -2.272  -4.964  1.00 52.91           O  
ATOM   1512  CB  GLU B 107     -53.065  -0.343  -2.719  1.00 49.82           C  
ATOM   1513  CG  GLU B 107     -54.331   0.039  -2.008  1.00 48.88           C  
ATOM   1514  CD  GLU B 107     -54.081   0.930  -0.821  1.00 50.49           C  
ATOM   1515  OE1 GLU B 107     -53.160   1.768  -0.887  1.00 51.25           O  
ATOM   1516  OE2 GLU B 107     -54.812   0.793   0.182  1.00 51.11           O  
ATOM   1517  N   GLY B 108     -51.511  -0.044  -5.272  1.00 50.53           N  
ATOM   1518  CA  GLY B 108     -50.284   0.005  -6.062  1.00 50.78           C  
ATOM   1519  C   GLY B 108     -50.504  -0.638  -7.418  1.00 50.65           C  
ATOM   1520  O   GLY B 108     -51.638  -0.718  -7.889  1.00 50.50           O  
ATOM   1521  N   LYS B 109     -49.423  -1.129  -8.022  1.00 51.12           N  
ATOM   1522  CA  LYS B 109     -49.465  -1.722  -9.367  1.00 52.14           C  
ATOM   1523  C   LYS B 109     -50.374  -2.925  -9.461  1.00 52.06           C  
ATOM   1524  O   LYS B 109     -50.925  -3.198 -10.527  1.00 55.01           O  
ATOM   1525  CB  LYS B 109     -48.058  -2.117  -9.853  1.00 53.63           C  
ATOM   1526  CG  LYS B 109     -47.405  -3.284  -9.109  1.00 55.76           C  
ATOM   1527  CD  LYS B 109     -45.937  -3.488  -9.536  1.00 55.32           C  
ATOM   1528  CE  LYS B 109     -45.766  -4.607 -10.572  1.00 56.18           C  
ATOM   1529  NZ  LYS B 109     -45.602  -5.955  -9.933  1.00 55.38           N  
ATOM   1530  N   GLU B 110     -50.534  -3.642  -8.357  1.00 50.67           N  
ATOM   1531  CA  GLU B 110     -51.437  -4.793  -8.310  1.00 50.67           C  
ATOM   1532  C   GLU B 110     -52.835  -4.380  -8.718  1.00 48.45           C  
ATOM   1533  O   GLU B 110     -53.507  -5.097  -9.448  1.00 47.22           O  
ATOM   1534  CB  GLU B 110     -51.468  -5.413  -6.907  1.00 52.62           C  
ATOM   1535  CG  GLU B 110     -50.157  -6.096  -6.475  1.00 56.91           C  
ATOM   1536  CD  GLU B 110     -49.018  -5.110  -6.224  1.00 59.87           C  
ATOM   1537  OE1 GLU B 110     -47.891  -5.351  -6.728  1.00 65.24           O  
ATOM   1538  OE2 GLU B 110     -49.257  -4.085  -5.544  1.00 58.50           O  
ATOM   1539  N   ALA B 111     -53.254  -3.204  -8.253  1.00 48.99           N  
ATOM   1540  CA  ALA B 111     -54.580  -2.643  -8.546  1.00 49.78           C  
ATOM   1541  C   ALA B 111     -54.827  -2.375 -10.033  1.00 49.51           C  
ATOM   1542  O   ALA B 111     -55.969  -2.298 -10.451  1.00 50.16           O  
ATOM   1543  CB  ALA B 111     -54.798  -1.363  -7.742  1.00 46.98           C  
ATOM   1544  N   LEU B 112     -53.758  -2.248 -10.815  1.00 50.82           N  
ATOM   1545  CA  LEU B 112     -53.846  -1.991 -12.253  1.00 54.03           C  
ATOM   1546  C   LEU B 112     -54.043  -3.257 -13.109  1.00 55.62           C  
ATOM   1547  O   LEU B 112     -54.668  -3.192 -14.169  1.00 54.56           O  
ATOM   1548  CB  LEU B 112     -52.579  -1.253 -12.727  1.00 53.29           C  
ATOM   1549  CG  LEU B 112     -52.190   0.042 -11.987  1.00 51.45           C  
ATOM   1550  CD1 LEU B 112     -50.764   0.491 -12.354  1.00 51.22           C  
ATOM   1551  CD2 LEU B 112     -53.206   1.162 -12.230  1.00 46.41           C  
ATOM   1552  N   LEU B 113     -53.529  -4.401 -12.652  1.00 58.85           N  
ATOM   1553  CA  LEU B 113     -53.374  -5.583 -13.521  1.00 62.00           C  
ATOM   1554  C   LEU B 113     -54.619  -6.494 -13.555  1.00 65.18           C  
ATOM   1555  O   LEU B 113     -55.697  -6.041 -13.936  1.00 67.81           O  
ATOM   1556  CB  LEU B 113     -52.101  -6.360 -13.140  1.00 62.20           C  
ATOM   1557  CG  LEU B 113     -50.729  -5.727 -13.434  1.00 63.86           C  
ATOM   1558  CD1 LEU B 113     -50.809  -4.310 -14.006  1.00 64.23           C  
ATOM   1559  CD2 LEU B 113     -49.849  -5.755 -12.184  1.00 62.89           C  
ATOM   1560  N   GLU B 114     -54.478  -7.760 -13.156  1.00 66.85           N  
ATOM   1561  CA  GLU B 114     -55.488  -8.804 -13.417  1.00 66.50           C  
ATOM   1562  C   GLU B 114     -55.940  -8.834 -14.875  1.00 66.25           C  
ATOM   1563  O   GLU B 114     -56.165  -9.903 -15.439  0.50 65.64           O  
ATOM   1564  CB  GLU B 114     -56.697  -8.668 -12.483  1.00 67.37           C  
ATOM   1565  CG  GLU B 114     -57.797  -9.718 -12.749  1.00 67.89           C  
ATOM   1566  CD  GLU B 114     -58.418 -10.305 -11.491  1.00 68.42           C  
ATOM   1567  OE1 GLU B 114     -58.960 -11.436 -11.575  1.00 67.80           O  
ATOM   1568  OE2 GLU B 114     -58.363  -9.645 -10.426  1.00 69.74           O  
TER    1569      GLU B 114                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
