
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  757),  selected   99 , name 2gw8_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2gw8_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    P     0_A      R       4          2.918
LGA    M     1_A      A       5          0.467
LGA    K     2_A      N       6          0.939
LGA    K     3_A      K       7          0.433
LGA    I     4_A      L       8          1.018
LGA    E     5_A      V       9          1.131
LGA    A     6_A      I      10          0.816
LGA    I     7_A      V      11          0.614
LGA    V     8_A      T      12          0.533
LGA    K     9_A      E      13          0.427
LGA    P    10_A      K      14          0.351
LGA    F    11_A      V      15          0.923
LGA    K    12_A      L      16          0.192
LGA    L    13_A      L      17          0.798
LGA    D    14_A      K      18          0.671
LGA    D    15_A      K      19          0.637
LGA    V    16_A      V      20          0.820
LGA    R    17_A      A      21          1.245
LGA    E    18_A      K      22          1.184
LGA    A    19_A      I      23          1.732
LGA    L    20_A      I      24          2.109
LGA    T    21_A      E      25          1.844
LGA    E    22_A      E      26          1.815
LGA    I    23_A      A      27          2.088
LGA    G    24_A      G      28          1.199
LGA    I    25_A      A      29          1.609
LGA    T    26_A      T      30          4.409
LGA    G    27_A      G      31          0.897
LGA    M    28_A      Y      32          0.803
LGA    T    29_A      T      33          0.673
LGA    V    30_A      V      34          0.784
LGA    S    31_A      V      35          0.656
LGA    E    32_A      D      36          0.834
LGA    V    33_A      T      37          0.856
LGA    K    34_A      G      38          0.395
LGA    G    35_A      G      39          1.394
LGA    F    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    R    38_A      -       -           -
LGA    V    53_A      -       -           -
LGA    D    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    L    56_A      -       -           -
LGA    P    57_A      S      58          0.984
LGA    K    58_A      N      59          0.495
LGA    I    59_A      V      60          0.627
LGA    K    60_A      K      61          0.636
LGA    I    61_A      F      62          0.602
LGA    E    62_A      E      63          0.715
LGA    L    63_A      V      64          0.850
LGA    V    64_A      L      65          0.757
LGA    L    65_A      T      66          1.343
LGA    A    66_A      E      67          2.175
LGA    D    67_A      N      68          2.828
LGA    D    68_A      R      69          3.035
LGA    -       -      E      70           -
LGA    A    69_A      M      71          1.910
LGA    V    70_A      A      72          1.503
LGA    E    71_A      E      73          1.385
LGA    R    72_A      K      74          0.938
LGA    A    73_A      I      75          1.704
LGA    I    74_A      A      76          1.156
LGA    D    75_A      D      77          1.110
LGA    V    76_A      Q      78          1.721
LGA    I    77_A      V      79          1.858
LGA    V    78_A      A      80          1.272
LGA    E    79_A      I      81          2.998
LGA    V    80_A      K      82          3.200
LGA    A    81_A      F      83          2.146
LGA    R    82_A      F      84          1.702
LGA    S    83_A      T      85          2.518
LGA    G    84_A      D      86          4.422
LGA    K    85_A      -       -           -
LGA    I    86_A      Y      87          6.365
LGA    G    87_A      A      88          2.276
LGA    D    88_A      -       -           -
LGA    G    89_A      G      89          0.265
LGA    K    90_A      I      90          0.354
LGA    I    91_A      I      91          0.725
LGA    F    92_A      Y      92          1.384
LGA    V    93_A      I      93          0.484
LGA    L    94_A      C      94          0.308
LGA    P    95_A      E      95          0.427
LGA    V    96_A      A      96          0.770
LGA    E    97_A      E      97          1.907
LGA    E    98_A      V      98          2.374
LGA    A    99_A      L      99          4.267
LGA    I   100_A      Y     100          1.505
LGA    R   101_A      G     101          1.214
LGA    I   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    R   107_A      -       -           -
LGA    S   108_A      -       -           -
LGA    D   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    V   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99   83    5.0     79    1.78    21.52     87.445     4.192

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.407263 * X  +   0.236977 * Y  +  -0.882031 * Z  + -45.561703
  Y_new =   0.593933 * X  +   0.802373 * Y  +  -0.058664 * Z  + -16.542564
  Z_new =   0.693816 * X  +  -0.547759 * Y  +  -0.467525 * Z  + -22.356079 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.277333    0.864260  [ DEG:  -130.4816     49.5184 ]
  Theta =  -0.766774   -2.374819  [ DEG:   -43.9329   -136.0671 ]
  Phi   =   2.171865   -0.969728  [ DEG:   124.4387    -55.5613 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gw8_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gw8_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99   83   5.0   79   1.78   21.52  87.445
REMARK  ---------------------------------------------------------- 
MOLECULE 2gw8_A
HEADER    SIGNALING PROTEIN                       04-MAY-06   2GW8              
TITLE     STRUCTURE OF THE PII SIGNAL TRANSDUCTION PROTEIN OF                   
TITLE    2 NEISSERIA MENINGITIDIS AT 1.85 RESOLUTION                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PII SIGNAL TRANSDUCTION PROTEIN;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MC58;                                                        
SOURCE   5 GENE: NMB1955;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B834;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDEST17                                   
KEYWDS    PII, SIGNAL TRANSDUCTION, TRANSCRIPTIONAL REGULATION,                 
KEYWDS   2 NEISSERIA, STRUCTURAL GENOMICS, OXFORD PROTEIN PRODUCTION            
KEYWDS   3 FACILITY, OPPF                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.E.NICHOLS,S.SAINSBURY,N.S.BERROW,D.ALDERTON,D.K.STAMMERS,           
AUTHOR   2 R.J.OWENS,OXFORD PROTEIN PRODUCTION FACILITY (OPPF)                  
REVDAT   2   08-AUG-06 2GW8    1       AUTHOR                                   
REVDAT   1   13-JUN-06 2GW8    0                                                
JRNL        AUTH   C.E.NICHOLS,S.SAINSBURY,N.S.BERROW,D.ALDERTON,               
JRNL        AUTH 2 N.J.SAUNDERS,D.K.STAMMERS,R.J.OWENS                          
JRNL        TITL   STRUCTURE OF THE P(II) SIGNAL TRANSDUCTION PROTEIN           
JRNL        TITL 2 OF NEISSERIA MENINGITIDIS AT 1.85 A RESOLUTION.              
JRNL        REF    ACTA CRYSTALLOGR.,SECT.F      V.  62   494 2006              
JRNL        REFN                DK ESSN 1744-3091                               
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  2GW8 A    1   112  UNP    Q8KUI8   Q8KUI8_NEIME     1    112             
SEQRES   1 A  114  GLY PRO MET LYS LYS ILE GLU ALA ILE VAL LYS PRO PHE          
SEQRES   2 A  114  LYS LEU ASP ASP VAL ARG GLU ALA LEU THR GLU ILE GLY          
SEQRES   3 A  114  ILE THR GLY MET THR VAL SER GLU VAL LYS GLY PHE GLY          
SEQRES   4 A  114  ARG GLN LYS GLY HIS THR GLU ILE TYR ARG GLY ALA GLU          
SEQRES   5 A  114  TYR ALA VAL ASP PHE LEU PRO LYS ILE LYS ILE GLU LEU          
SEQRES   6 A  114  VAL LEU ALA ASP ASP ALA VAL GLU ARG ALA ILE ASP VAL          
SEQRES   7 A  114  ILE VAL GLU VAL ALA ARG SER GLY LYS ILE GLY ASP GLY          
SEQRES   8 A  114  LYS ILE PHE VAL LEU PRO VAL GLU GLU ALA ILE ARG ILE          
SEQRES   9 A  114  ARG THR GLY GLU ARG SER ASP ALA ALA VAL                      
FORMUL   2  HOH   *134(H2 O)                                                    
CRYST1   61.141   61.141   48.074  90.00  90.00 120.00 P 63          6          
ATOM      1  N   PRO A   0     -44.132   3.635  -8.462  1.00 30.87           N  
ATOM      2  CA  PRO A   0     -44.757   4.985  -8.587  1.00 27.37           C  
ATOM      3  C   PRO A   0     -45.666   5.028  -9.809  1.00 26.39           C  
ATOM      4  O   PRO A   0     -45.302   4.570 -10.897  1.00 24.80           O  
ATOM      5  CB  PRO A   0     -43.684   6.057  -8.694  1.00 37.87           C  
ATOM      6  N   MET A   1     -46.851   5.595  -9.622  1.00 20.24           N  
ATOM      7  CA  MET A   1     -47.838   5.687 -10.687  1.00 19.30           C  
ATOM      8  C   MET A   1     -47.968   7.109 -11.216  1.00 14.72           C  
ATOM      9  O   MET A   1     -47.601   8.072 -10.539  1.00 15.11           O  
ATOM     10  CB  MET A   1     -49.195   5.223 -10.163  1.00 17.80           C  
ATOM     11  CG  MET A   1     -49.179   3.855  -9.492  1.00 25.19           C  
ATOM     12  SD  MET A   1     -48.703   2.545 -10.624  1.00 26.03           S  
ATOM     13  CE  MET A   1     -50.208   2.331 -11.525  1.00 23.22           C  
ATOM     14  N   LYS A   2     -48.503   7.227 -12.429  1.00 13.61           N  
ATOM     15  CA  LYS A   2     -48.717   8.525 -13.059  1.00 13.38           C  
ATOM     16  C   LYS A   2     -50.075   8.521 -13.753  1.00 12.55           C  
ATOM     17  O   LYS A   2     -50.626   7.464 -14.054  1.00 12.09           O  
ATOM     18  CB  LYS A   2     -47.630   8.811 -14.107  1.00 10.88           C  
ATOM     19  CG  LYS A   2     -46.192   8.767 -13.596  1.00 13.78           C  
ATOM     20  CD  LYS A   2     -45.926   9.841 -12.559  1.00 14.53           C  
ATOM     21  CE  LYS A   2     -44.472   9.787 -12.091  1.00 16.19           C  
ATOM     22  NZ  LYS A   2     -44.242  10.689 -10.940  1.00 21.24           N  
ATOM     23  N   LYS A   3     -50.614   9.707 -13.997  1.00 11.65           N  
ATOM     24  CA  LYS A   3     -51.881   9.821 -14.696  1.00 10.67           C  
ATOM     25  C   LYS A   3     -51.638  10.520 -16.022  1.00  9.65           C  
ATOM     26  O   LYS A   3     -50.905  11.508 -16.084  1.00 10.84           O  
ATOM     27  CB  LYS A   3     -52.895  10.645 -13.898  1.00 12.42           C  
ATOM     28  CG  LYS A   3     -54.219  10.787 -14.639  1.00 20.02           C  
ATOM     29  CD  LYS A   3     -55.243  11.567 -13.849  1.00 24.60           C  
ATOM     30  CE  LYS A   3     -56.605  11.398 -14.480  1.00 22.85           C  
ATOM     31  NZ  LYS A   3     -57.618  12.273 -13.862  1.00 20.65           N  
ATOM     32  N   ILE A   4     -52.233   9.987 -17.082  1.00 12.09           N  
ATOM     33  CA  ILE A   4     -52.124  10.598 -18.403  1.00 11.30           C  
ATOM     34  C   ILE A   4     -53.515  11.114 -18.782  1.00 10.66           C  
ATOM     35  O   ILE A   4     -54.503  10.393 -18.658  1.00 13.82           O  
ATOM     36  CB  ILE A   4     -51.671   9.581 -19.495  1.00 11.12           C  
ATOM     37  CG1 ILE A   4     -50.181   9.270 -19.346  1.00 15.70           C  
ATOM     38  CG2 ILE A   4     -51.943  10.151 -20.889  1.00 13.81           C  
ATOM     39  CD1 ILE A   4     -49.686   8.189 -20.294  1.00 17.17           C  
ATOM     40  N   GLU A   5     -53.585  12.374 -19.202  1.00 10.72           N  
ATOM     41  CA  GLU A   5     -54.830  12.981 -19.656  1.00 12.31           C  
ATOM     42  C   GLU A   5     -54.559  13.384 -21.102  1.00 14.22           C  
ATOM     43  O   GLU A   5     -53.639  14.160 -21.371  1.00 15.50           O  
ATOM     44  CB  GLU A   5     -55.188  14.229 -18.832  1.00  7.95           C  
ATOM     45  CG  GLU A   5     -55.578  13.947 -17.387  1.00 16.32           C  
ATOM     46  CD  GLU A   5     -56.076  15.185 -16.654  1.00 18.55           C  
ATOM     47  OE1 GLU A   5     -56.558  15.049 -15.511  1.00 26.38           O  
ATOM     48  OE2 GLU A   5     -55.987  16.295 -17.216  1.00 22.21           O  
ATOM     49  N   ALA A   6     -55.341  12.841 -22.028  1.00 10.41           N  
ATOM     50  CA  ALA A   6     -55.171  13.144 -23.448  1.00 12.43           C  
ATOM     51  C   ALA A   6     -56.443  13.761 -24.032  1.00 12.81           C  
ATOM     52  O   ALA A   6     -57.503  13.137 -24.006  1.00 15.63           O  
ATOM     53  CB  ALA A   6     -54.807  11.867 -24.216  1.00 14.03           C  
ATOM     54  N   ILE A   7     -56.339  14.983 -24.550  1.00 11.71           N  
ATOM     55  CA  ILE A   7     -57.491  15.659 -25.151  1.00  9.41           C  
ATOM     56  C   ILE A   7     -57.321  15.548 -26.664  1.00 11.19           C  
ATOM     57  O   ILE A   7     -56.395  16.130 -27.230  1.00 13.33           O  
ATOM     58  CB  ILE A   7     -57.540  17.150 -24.781  1.00 13.96           C  
ATOM     59  CG1 ILE A   7     -57.490  17.326 -23.259  1.00 17.12           C  
ATOM     60  CG2 ILE A   7     -58.806  17.782 -25.353  1.00 16.22           C  
ATOM     61  CD1 ILE A   7     -58.620  16.645 -22.509  1.00 18.35           C  
ATOM     62  N   VAL A   8     -58.207  14.800 -27.310  1.00 12.48           N  
ATOM     63  CA  VAL A   8     -58.117  14.591 -28.752  1.00 14.61           C  
ATOM     64  C   VAL A   8     -59.480  14.672 -29.428  1.00 14.72           C  
ATOM     65  O   VAL A   8     -60.517  14.713 -28.757  1.00 14.57           O  
ATOM     66  CB  VAL A   8     -57.483  13.203 -29.071  1.00 10.98           C  
ATOM     67  CG1 VAL A   8     -56.089  13.101 -28.453  1.00 15.24           C  
ATOM     68  CG2 VAL A   8     -58.367  12.090 -28.536  1.00 12.71           C  
ATOM     69  N   LYS A   9     -59.476  14.715 -30.760  1.00 14.45           N  
ATOM     70  CA  LYS A   9     -60.723  14.766 -31.526  1.00 15.38           C  
ATOM     71  C   LYS A   9     -61.531  13.503 -31.224  1.00 15.35           C  
ATOM     72  O   LYS A   9     -60.969  12.425 -31.046  1.00 16.84           O  
ATOM     73  CB  LYS A   9     -60.418  14.853 -33.024  1.00 16.36           C  
ATOM     74  CG  LYS A   9     -59.642  16.098 -33.416  1.00 21.59           C  
ATOM     75  CD  LYS A   9     -59.013  15.938 -34.789  1.00 29.50           C  
ATOM     76  CE  LYS A   9     -58.046  17.076 -35.075  1.00 37.12           C  
ATOM     77  NZ  LYS A   9     -57.212  16.802 -36.277  1.00 45.10           N  
ATOM     78  N   PRO A  10     -62.867  13.623 -31.180  1.00 15.46           N  
ATOM     79  CA  PRO A  10     -63.778  12.510 -30.892  1.00 19.21           C  
ATOM     80  C   PRO A  10     -63.598  11.263 -31.743  1.00 21.67           C  
ATOM     81  O   PRO A  10     -63.647  10.143 -31.228  1.00 19.94           O  
ATOM     82  CB  PRO A  10     -65.157  13.137 -31.082  1.00 16.45           C  
ATOM     83  CG  PRO A  10     -64.928  14.563 -30.719  1.00 18.30           C  
ATOM     84  CD  PRO A  10     -63.626  14.861 -31.425  1.00 14.61           C  
ATOM     85  N   PHE A  11     -63.390  11.457 -33.041  1.00 20.44           N  
ATOM     86  CA  PHE A  11     -63.232  10.335 -33.953  1.00 21.04           C  
ATOM     87  C   PHE A  11     -61.866   9.658 -33.941  1.00 23.30           C  
ATOM     88  O   PHE A  11     -61.574   8.853 -34.819  1.00 23.13           O  
ATOM     89  CB  PHE A  11     -63.585  10.755 -35.390  1.00 20.30           C  
ATOM     90  CG  PHE A  11     -63.024  12.093 -35.804  1.00 19.30           C  
ATOM     91  CD1 PHE A  11     -63.760  13.261 -35.608  1.00 24.40           C  
ATOM     92  CD2 PHE A  11     -61.776  12.185 -36.412  1.00 25.59           C  
ATOM     93  CE1 PHE A  11     -63.263  14.502 -36.019  1.00 26.11           C  
ATOM     94  CE2 PHE A  11     -61.269  13.419 -36.825  1.00 23.58           C  
ATOM     95  CZ  PHE A  11     -62.015  14.580 -36.629  1.00 26.18           C  
ATOM     96  N   LYS A  12     -61.034   9.968 -32.949  1.00 19.46           N  
ATOM     97  CA  LYS A  12     -59.713   9.350 -32.859  1.00 19.37           C  
ATOM     98  C   LYS A  12     -59.666   8.283 -31.765  1.00 19.47           C  
ATOM     99  O   LYS A  12     -58.650   7.606 -31.596  1.00 20.58           O  
ATOM    100  CB  LYS A  12     -58.639  10.408 -32.576  1.00 22.52           C  
ATOM    101  CG  LYS A  12     -58.511  11.479 -33.651  1.00 31.33           C  
ATOM    102  CD  LYS A  12     -58.103  10.892 -34.998  1.00 33.00           C  
ATOM    103  CE  LYS A  12     -56.691  10.333 -34.961  1.00 37.38           C  
ATOM    104  NZ  LYS A  12     -56.260   9.846 -36.301  1.00 46.81           N  
ATOM    105  N   LEU A  13     -60.770   8.128 -31.039  1.00 19.03           N  
ATOM    106  CA  LEU A  13     -60.858   7.162 -29.941  1.00 18.30           C  
ATOM    107  C   LEU A  13     -60.437   5.742 -30.323  1.00 23.04           C  
ATOM    108  O   LEU A  13     -59.556   5.161 -29.691  1.00 21.66           O  
ATOM    109  CB  LEU A  13     -62.286   7.116 -29.381  1.00 20.60           C  
ATOM    110  CG  LEU A  13     -62.480   6.967 -27.866  1.00 27.65           C  
ATOM    111  CD1 LEU A  13     -63.858   6.380 -27.593  1.00 26.40           C  
ATOM    112  CD2 LEU A  13     -61.418   6.078 -27.266  1.00 21.49           C  
ATOM    113  N   ASP A  14     -61.076   5.173 -31.344  1.00 22.10           N  
ATOM    114  CA  ASP A  14     -60.746   3.813 -31.770  1.00 25.02           C  
ATOM    115  C   ASP A  14     -59.259   3.618 -32.029  1.00 19.44           C  
ATOM    116  O   ASP A  14     -58.639   2.700 -31.483  1.00 20.94           O  
ATOM    117  CB  ASP A  14     -61.525   3.426 -33.034  1.00 25.19           C  
ATOM    118  CG  ASP A  14     -62.976   3.092 -32.747  1.00 35.62           C  
ATOM    119  OD1 ASP A  14     -63.266   2.594 -31.638  1.00 37.19           O  
ATOM    120  OD2 ASP A  14     -63.826   3.307 -33.637  1.00 39.11           O  
ATOM    121  N   ASP A  15     -58.690   4.482 -32.865  1.00 19.39           N  
ATOM    122  CA  ASP A  15     -57.272   4.402 -33.207  1.00 19.92           C  
ATOM    123  C   ASP A  15     -56.369   4.453 -31.983  1.00 19.40           C  
ATOM    124  O   ASP A  15     -55.412   3.687 -31.884  1.00 17.20           O  
ATOM    125  CB  ASP A  15     -56.887   5.529 -34.174  1.00 21.86           C  
ATOM    126  CG  ASP A  15     -57.352   5.262 -35.598  1.00 33.95           C  
ATOM    127  OD1 ASP A  15     -57.230   6.173 -36.446  1.00 39.50           O  
ATOM    128  OD2 ASP A  15     -57.832   4.143 -35.874  1.00 31.73           O  
ATOM    129  N   VAL A  16     -56.664   5.358 -31.054  1.00 17.46           N  
ATOM    130  CA  VAL A  16     -55.858   5.474 -29.840  1.00 17.87           C  
ATOM    131  C   VAL A  16     -55.983   4.210 -28.997  1.00 17.61           C  
ATOM    132  O   VAL A  16     -54.983   3.665 -28.530  1.00 15.91           O  
ATOM    133  CB  VAL A  16     -56.285   6.700 -28.980  1.00 14.42           C  
ATOM    134  CG1 VAL A  16     -55.592   6.657 -27.620  1.00 21.10           C  
ATOM    135  CG2 VAL A  16     -55.926   7.988 -29.700  1.00 12.97           C  
ATOM    136  N   ARG A  17     -57.212   3.742 -28.807  1.00 22.61           N  
ATOM    137  CA  ARG A  17     -57.451   2.540 -28.016  1.00 25.48           C  
ATOM    138  C   ARG A  17     -56.679   1.327 -28.524  1.00 28.03           C  
ATOM    139  O   ARG A  17     -56.008   0.638 -27.755  1.00 27.49           O  
ATOM    140  CB  ARG A  17     -58.936   2.181 -28.016  1.00 30.44           C  
ATOM    141  CG  ARG A  17     -59.823   3.026 -27.133  1.00 43.77           C  
ATOM    142  CD  ARG A  17     -61.236   2.465 -27.187  1.00 48.11           C  
ATOM    143  NE  ARG A  17     -61.268   1.073 -26.741  1.00 48.15           N  
ATOM    144  CZ  ARG A  17     -62.150   0.170 -27.157  1.00 49.82           C  
ATOM    145  NH1 ARG A  17     -63.081   0.504 -28.040  1.00 48.74           N  
ATOM    146  NH2 ARG A  17     -62.104  -1.067 -26.683  1.00 49.03           N  
ATOM    147  N   GLU A  18     -56.790   1.052 -29.818  1.00 27.18           N  
ATOM    148  CA  GLU A  18     -56.108  -0.106 -30.373  1.00 26.75           C  
ATOM    149  C   GLU A  18     -54.597   0.049 -30.296  1.00 24.35           C  
ATOM    150  O   GLU A  18     -53.888  -0.923 -30.046  1.00 23.00           O  
ATOM    151  CB  GLU A  18     -56.537  -0.358 -31.825  1.00 31.61           C  
ATOM    152  CG  GLU A  18     -55.940   0.584 -32.853  1.00 40.37           C  
ATOM    153  CD  GLU A  18     -56.049   0.037 -34.272  1.00 46.41           C  
ATOM    154  OE1 GLU A  18     -55.591   0.717 -35.214  1.00 45.62           O  
ATOM    155  OE2 GLU A  18     -56.593  -1.074 -34.447  1.00 45.19           O  
ATOM    156  N   ALA A  19     -54.103   1.267 -30.504  1.00 19.85           N  
ATOM    157  CA  ALA A  19     -52.663   1.507 -30.446  1.00 22.77           C  
ATOM    158  C   ALA A  19     -52.133   1.210 -29.048  1.00 20.46           C  
ATOM    159  O   ALA A  19     -51.064   0.616 -28.893  1.00 18.54           O  
ATOM    160  CB  ALA A  19     -52.351   2.944 -30.835  1.00 24.25           C  
ATOM    161  N   LEU A  20     -52.876   1.624 -28.026  1.00 16.27           N  
ATOM    162  CA  LEU A  20     -52.457   1.369 -26.653  1.00 17.51           C  
ATOM    163  C   LEU A  20     -52.594  -0.119 -26.328  1.00 21.00           C  
ATOM    164  O   LEU A  20     -51.737  -0.699 -25.667  1.00 21.05           O  
ATOM    165  CB  LEU A  20     -53.289   2.207 -25.674  1.00 19.97           C  
ATOM    166  CG  LEU A  20     -52.993   3.712 -25.715  1.00 21.68           C  
ATOM    167  CD1 LEU A  20     -54.047   4.481 -24.921  1.00 21.23           C  
ATOM    168  CD2 LEU A  20     -51.589   3.967 -25.173  1.00 22.33           C  
ATOM    169  N   THR A  21     -53.666  -0.740 -26.805  1.00 22.33           N  
ATOM    170  CA  THR A  21     -53.878  -2.163 -26.553  1.00 25.72           C  
ATOM    171  C   THR A  21     -52.717  -2.978 -27.117  1.00 24.31           C  
ATOM    172  O   THR A  21     -52.323  -3.991 -26.539  1.00 21.21           O  
ATOM    173  CB  THR A  21     -55.185  -2.664 -27.197  1.00 27.59           C  
ATOM    174  OG1 THR A  21     -56.299  -1.977 -26.611  1.00 31.45           O  
ATOM    175  CG2 THR A  21     -55.349  -4.166 -26.970  1.00 33.75           C  
ATOM    176  N   GLU A  22     -52.165  -2.528 -28.240  1.00 22.46           N  
ATOM    177  CA  GLU A  22     -51.044  -3.223 -28.870  1.00 26.64           C  
ATOM    178  C   GLU A  22     -49.793  -3.247 -27.997  1.00 27.61           C  
ATOM    179  O   GLU A  22     -48.964  -4.147 -28.124  1.00 29.45           O  
ATOM    180  CB  GLU A  22     -50.711  -2.586 -30.222  1.00 31.18           C  
ATOM    181  CG  GLU A  22     -51.697  -2.917 -31.323  1.00 40.12           C  
ATOM    182  CD  GLU A  22     -51.264  -2.376 -32.675  1.00 52.58           C  
ATOM    183  OE1 GLU A  22     -50.108  -2.633 -33.078  1.00 57.27           O  
ATOM    184  OE2 GLU A  22     -52.082  -1.702 -33.337  1.00 57.14           O  
ATOM    185  N   ILE A  23     -49.649  -2.265 -27.112  1.00 25.32           N  
ATOM    186  CA  ILE A  23     -48.485  -2.228 -26.235  1.00 23.87           C  
ATOM    187  C   ILE A  23     -48.810  -2.643 -24.798  1.00 23.12           C  
ATOM    188  O   ILE A  23     -48.046  -2.358 -23.874  1.00 24.43           O  
ATOM    189  CB  ILE A  23     -47.825  -0.832 -26.227  1.00 25.63           C  
ATOM    190  CG1 ILE A  23     -48.839   0.228 -25.793  1.00 24.60           C  
ATOM    191  CG2 ILE A  23     -47.273  -0.519 -27.608  1.00 25.98           C  
ATOM    192  CD1 ILE A  23     -48.240   1.610 -25.629  1.00 30.01           C  
ATOM    193  N   GLY A  24     -49.947  -3.308 -24.618  1.00 24.24           N  
ATOM    194  CA  GLY A  24     -50.331  -3.794 -23.298  1.00 29.64           C  
ATOM    195  C   GLY A  24     -51.103  -2.888 -22.350  1.00 31.29           C  
ATOM    196  O   GLY A  24     -51.208  -3.192 -21.161  1.00 32.29           O  
ATOM    197  N   ILE A  25     -51.653  -1.791 -22.858  1.00 29.40           N  
ATOM    198  CA  ILE A  25     -52.411  -0.862 -22.023  1.00 30.48           C  
ATOM    199  C   ILE A  25     -53.877  -0.891 -22.459  1.00 30.09           C  
ATOM    200  O   ILE A  25     -54.189  -0.574 -23.608  1.00 27.94           O  
ATOM    201  CB  ILE A  25     -51.843   0.572 -22.161  1.00 29.06           C  
ATOM    202  CG1 ILE A  25     -50.354   0.566 -21.800  1.00 29.30           C  
ATOM    203  CG2 ILE A  25     -52.608   1.538 -21.271  1.00 26.98           C  
ATOM    204  CD1 ILE A  25     -49.671   1.915 -21.930  1.00 33.75           C  
ATOM    205  N   THR A  26     -54.780  -1.268 -21.551  1.00 30.10           N  
ATOM    206  CA  THR A  26     -56.198  -1.357 -21.913  1.00 33.58           C  
ATOM    207  C   THR A  26     -57.230  -0.572 -21.094  1.00 35.57           C  
ATOM    208  O   THR A  26     -58.188  -0.038 -21.659  1.00 40.09           O  
ATOM    209  CB  THR A  26     -56.657  -2.829 -21.945  1.00 35.11           C  
ATOM    210  OG1 THR A  26     -56.531  -3.403 -20.638  1.00 39.45           O  
ATOM    211  CG2 THR A  26     -55.809  -3.624 -22.930  1.00 32.02           C  
ATOM    212  N   GLY A  27     -57.049  -0.504 -19.779  1.00 30.47           N  
ATOM    213  CA  GLY A  27     -58.004   0.207 -18.944  1.00 26.74           C  
ATOM    214  C   GLY A  27     -57.952   1.724 -19.030  1.00 29.36           C  
ATOM    215  O   GLY A  27     -56.952   2.343 -18.659  1.00 25.47           O  
ATOM    216  N   MET A  28     -59.039   2.326 -19.507  1.00 19.79           N  
ATOM    217  CA  MET A  28     -59.116   3.777 -19.636  1.00 20.87           C  
ATOM    218  C   MET A  28     -60.525   4.297 -19.378  1.00 17.46           C  
ATOM    219  O   MET A  28     -61.507   3.556 -19.450  1.00 18.64           O  
ATOM    220  CB  MET A  28     -58.682   4.227 -21.037  1.00 22.56           C  
ATOM    221  CG  MET A  28     -59.671   3.881 -22.145  1.00 20.40           C  
ATOM    222  SD  MET A  28     -59.323   4.672 -23.742  1.00 29.22           S  
ATOM    223  CE  MET A  28     -57.793   3.860 -24.175  1.00 33.72           C  
ATOM    224  N   THR A  29     -60.603   5.590 -19.094  1.00 15.10           N  
ATOM    225  CA  THR A  29     -61.862   6.273 -18.841  1.00 14.76           C  
ATOM    226  C   THR A  29     -61.984   7.325 -19.940  1.00 14.63           C  
ATOM    227  O   THR A  29     -60.990   7.937 -20.313  1.00 13.37           O  
ATOM    228  CB  THR A  29     -61.825   6.981 -17.467  1.00 22.13           C  
ATOM    229  OG1 THR A  29     -61.680   6.002 -16.427  1.00 28.86           O  
ATOM    230  CG2 THR A  29     -63.084   7.758 -17.241  1.00 25.95           C  
ATOM    231  N   VAL A  30     -63.187   7.532 -20.465  1.00 14.79           N  
ATOM    232  CA  VAL A  30     -63.382   8.525 -21.522  1.00 12.49           C  
ATOM    233  C   VAL A  30     -64.550   9.461 -21.220  1.00 17.32           C  
ATOM    234  O   VAL A  30     -65.631   9.011 -20.838  1.00 14.73           O  
ATOM    235  CB  VAL A  30     -63.646   7.842 -22.886  1.00 17.36           C  
ATOM    236  CG1 VAL A  30     -63.817   8.900 -23.983  1.00 20.09           C  
ATOM    237  CG2 VAL A  30     -62.496   6.882 -23.218  1.00 16.64           C  
ATOM    238  N   SER A  31     -64.342  10.763 -21.387  1.00 14.24           N  
ATOM    239  CA  SER A  31     -65.421  11.709 -21.142  1.00 15.89           C  
ATOM    240  C   SER A  31     -65.523  12.740 -22.260  1.00 15.23           C  
ATOM    241  O   SER A  31     -64.540  13.039 -22.946  1.00 12.54           O  
ATOM    242  CB  SER A  31     -65.244  12.400 -19.786  1.00 24.43           C  
ATOM    243  OG  SER A  31     -64.023  13.096 -19.725  1.00 26.72           O  
ATOM    244  N   GLU A  32     -66.731  13.261 -22.448  1.00 12.78           N  
ATOM    245  CA  GLU A  32     -66.993  14.252 -23.484  1.00 17.18           C  
ATOM    246  C   GLU A  32     -66.795  15.645 -22.907  1.00 15.46           C  
ATOM    247  O   GLU A  32     -67.328  15.964 -21.843  1.00 17.66           O  
ATOM    248  CB  GLU A  32     -68.431  14.113 -23.991  1.00 22.68           C  
ATOM    249  CG  GLU A  32     -68.874  12.678 -24.241  1.00 34.06           C  
ATOM    250  CD  GLU A  32     -68.011  11.960 -25.265  1.00 47.72           C  
ATOM    251  OE1 GLU A  32     -67.859  12.487 -26.388  1.00 50.06           O  
ATOM    252  OE2 GLU A  32     -67.494  10.865 -24.947  1.00 49.05           O  
ATOM    253  N   VAL A  33     -66.016  16.470 -23.599  1.00 15.55           N  
ATOM    254  CA  VAL A  33     -65.763  17.830 -23.139  1.00 11.72           C  
ATOM    255  C   VAL A  33     -65.804  18.798 -24.318  1.00 16.72           C  
ATOM    256  O   VAL A  33     -65.845  18.387 -25.478  1.00 14.67           O  
ATOM    257  CB  VAL A  33     -64.372  17.964 -22.444  1.00 15.45           C  
ATOM    258  CG1 VAL A  33     -64.234  16.932 -21.323  1.00 19.38           C  
ATOM    259  CG2 VAL A  33     -63.246  17.799 -23.474  1.00 19.30           C  
ATOM    260  N   LYS A  34     -65.817  20.089 -24.012  1.00 15.04           N  
ATOM    261  CA  LYS A  34     -65.817  21.109 -25.053  1.00 20.79           C  
ATOM    262  C   LYS A  34     -64.432  21.738 -25.041  1.00 17.92           C  
ATOM    263  O   LYS A  34     -63.911  22.081 -23.979  1.00 13.15           O  
ATOM    264  CB  LYS A  34     -66.875  22.177 -24.769  1.00 19.09           C  
ATOM    265  CG  LYS A  34     -68.293  21.636 -24.674  1.00 30.89           C  
ATOM    266  CD  LYS A  34     -69.311  22.760 -24.517  1.00 41.38           C  
ATOM    267  CE  LYS A  34     -70.689  22.213 -24.171  1.00 49.61           C  
ATOM    268  NZ  LYS A  34     -71.156  21.195 -25.154  1.00 56.77           N  
ATOM    269  N   GLY A  35     -63.822  21.867 -26.213  1.00 14.62           N  
ATOM    270  CA  GLY A  35     -62.504  22.466 -26.277  1.00 14.46           C  
ATOM    271  C   GLY A  35     -62.517  23.860 -26.878  1.00 21.73           C  
ATOM    272  O   GLY A  35     -63.025  24.048 -27.985  1.00 20.90           O  
ATOM    273  N   PHE A  36     -61.981  24.831 -26.138  1.00 21.35           N  
ATOM    274  CA  PHE A  36     -61.886  26.221 -26.596  1.00 28.60           C  
ATOM    275  C   PHE A  36     -60.408  26.540 -26.813  1.00 36.66           C  
ATOM    276  O   PHE A  36     -59.536  25.871 -26.260  1.00 34.31           O  
ATOM    277  CB  PHE A  36     -62.412  27.207 -25.544  1.00 29.26           C  
ATOM    278  CG  PHE A  36     -63.871  27.065 -25.224  1.00 25.89           C  
ATOM    279  CD1 PHE A  36     -64.328  26.022 -24.428  1.00 26.67           C  
ATOM    280  CD2 PHE A  36     -64.784  28.015 -25.674  1.00 31.18           C  
ATOM    281  CE1 PHE A  36     -65.673  25.929 -24.078  1.00 25.30           C  
ATOM    282  CE2 PHE A  36     -66.130  27.932 -25.330  1.00 26.40           C  
ATOM    283  CZ  PHE A  36     -66.576  26.888 -24.530  1.00 32.53           C  
ATOM    284  N   GLY A  37     -60.123  27.572 -27.603  1.00 46.15           N  
ATOM    285  CA  GLY A  37     -58.738  27.949 -27.826  1.00 53.28           C  
ATOM    286  C   GLY A  37     -58.327  28.176 -29.265  1.00 58.14           C  
ATOM    287  O   GLY A  37     -58.559  29.245 -29.828  1.00 59.24           O  
ATOM    288  N   ARG A  38     -57.698  27.166 -29.857  1.00 62.14           N  
ATOM    289  CA  ARG A  38     -57.237  27.235 -31.237  1.00 63.56           C  
ATOM    290  C   ARG A  38     -58.370  26.970 -32.219  1.00 64.28           C  
ATOM    291  O   ARG A  38     -58.140  26.488 -33.329  1.00 65.13           O  
ATOM    292  CB  ARG A  38     -56.111  26.221 -31.461  1.00 66.69           C  
ATOM    293  CG  ARG A  38     -56.442  24.821 -30.967  1.00 67.76           C  
ATOM    294  CD  ARG A  38     -55.362  23.823 -31.347  1.00 70.87           C  
ATOM    295  NE  ARG A  38     -54.042  24.216 -30.862  1.00 71.99           N  
ATOM    296  CZ  ARG A  38     -52.938  23.500 -31.054  1.00 72.00           C  
ATOM    297  NH1 ARG A  38     -53.000  22.356 -31.721  1.00 70.57           N  
ATOM    298  NH2 ARG A  38     -51.774  23.927 -30.585  1.00 72.59           N  
ATOM    299  N   VAL A  53     -69.517  28.947 -33.502  1.00 66.91           N  
ATOM    300  CA  VAL A  53     -69.323  29.006 -32.057  1.00 64.83           C  
ATOM    301  C   VAL A  53     -67.828  29.077 -31.730  1.00 61.99           C  
ATOM    302  O   VAL A  53     -66.989  29.041 -32.631  1.00 62.00           O  
ATOM    303  CB  VAL A  53     -69.967  27.775 -31.369  1.00 64.07           C  
ATOM    304  CG1 VAL A  53     -69.208  26.514 -31.739  1.00 64.97           C  
ATOM    305  CG2 VAL A  53     -70.010  27.977 -29.862  1.00 63.26           C  
ATOM    306  N   ASP A  54     -67.499  29.178 -30.447  1.00 58.11           N  
ATOM    307  CA  ASP A  54     -66.106  29.280 -30.017  1.00 51.99           C  
ATOM    308  C   ASP A  54     -65.496  27.970 -29.521  1.00 44.74           C  
ATOM    309  O   ASP A  54     -64.409  27.984 -28.940  1.00 45.25           O  
ATOM    310  CB  ASP A  54     -65.976  30.324 -28.902  1.00 55.69           C  
ATOM    311  CG  ASP A  54     -66.478  31.693 -29.315  1.00 62.34           C  
ATOM    312  OD1 ASP A  54     -65.934  32.263 -30.285  1.00 63.32           O  
ATOM    313  OD2 ASP A  54     -67.416  32.202 -28.665  1.00 67.42           O  
ATOM    314  N   PHE A  55     -66.170  26.845 -29.746  1.00 35.62           N  
ATOM    315  CA  PHE A  55     -65.647  25.563 -29.269  1.00 29.07           C  
ATOM    316  C   PHE A  55     -65.990  24.379 -30.164  1.00 23.19           C  
ATOM    317  O   PHE A  55     -66.899  24.446 -30.988  1.00 25.59           O  
ATOM    318  CB  PHE A  55     -66.182  25.278 -27.863  1.00 27.90           C  
ATOM    319  CG  PHE A  55     -67.637  24.908 -27.836  1.00 29.92           C  
ATOM    320  CD1 PHE A  55     -68.051  23.622 -28.178  1.00 30.12           C  
ATOM    321  CD2 PHE A  55     -68.601  25.854 -27.506  1.00 36.39           C  
ATOM    322  CE1 PHE A  55     -69.401  23.288 -28.194  1.00 30.61           C  
ATOM    323  CE2 PHE A  55     -69.957  25.525 -27.521  1.00 35.37           C  
ATOM    324  CZ  PHE A  55     -70.353  24.240 -27.866  1.00 32.10           C  
ATOM    325  N   LEU A  56     -65.256  23.285 -29.975  1.00 19.72           N  
ATOM    326  CA  LEU A  56     -65.473  22.055 -30.721  1.00 16.29           C  
ATOM    327  C   LEU A  56     -65.472  20.892 -29.745  1.00 15.46           C  
ATOM    328  O   LEU A  56     -64.723  20.895 -28.768  1.00 16.62           O  
ATOM    329  CB  LEU A  56     -64.365  21.839 -31.755  1.00 17.78           C  
ATOM    330  CG  LEU A  56     -64.414  22.743 -32.989  1.00 23.68           C  
ATOM    331  CD1 LEU A  56     -63.224  22.457 -33.880  1.00 24.08           C  
ATOM    332  CD2 LEU A  56     -65.710  22.502 -33.740  1.00 26.56           C  
ATOM    333  N   PRO A  57     -66.325  19.885 -29.985  1.00 14.82           N  
ATOM    334  CA  PRO A  57     -66.382  18.723 -29.094  1.00 15.69           C  
ATOM    335  C   PRO A  57     -65.073  17.936 -29.125  1.00 16.21           C  
ATOM    336  O   PRO A  57     -64.483  17.731 -30.186  1.00 13.47           O  
ATOM    337  CB  PRO A  57     -67.559  17.923 -29.649  1.00 17.42           C  
ATOM    338  CG  PRO A  57     -67.511  18.236 -31.111  1.00 18.61           C  
ATOM    339  CD  PRO A  57     -67.273  19.733 -31.102  1.00 18.66           C  
ATOM    340  N   LYS A  58     -64.612  17.516 -27.951  1.00 15.41           N  
ATOM    341  CA  LYS A  58     -63.378  16.741 -27.841  1.00 13.78           C  
ATOM    342  C   LYS A  58     -63.660  15.603 -26.866  1.00 11.61           C  
ATOM    343  O   LYS A  58     -64.731  15.544 -26.262  1.00 12.94           O  
ATOM    344  CB  LYS A  58     -62.238  17.596 -27.253  1.00 14.77           C  
ATOM    345  CG  LYS A  58     -61.923  18.893 -27.982  1.00 15.42           C  
ATOM    346  CD  LYS A  58     -61.210  18.656 -29.306  1.00 16.86           C  
ATOM    347  CE  LYS A  58     -60.784  19.977 -29.937  1.00 23.67           C  
ATOM    348  NZ  LYS A  58     -60.031  19.774 -31.211  1.00 23.24           N  
ATOM    349  N   ILE A  59     -62.711  14.687 -26.725  1.00 14.17           N  
ATOM    350  CA  ILE A  59     -62.866  13.619 -25.748  1.00  9.73           C  
ATOM    351  C   ILE A  59     -61.623  13.638 -24.876  1.00 10.88           C  
ATOM    352  O   ILE A  59     -60.521  13.901 -25.352  1.00 12.77           O  
ATOM    353  CB  ILE A  59     -63.004  12.214 -26.383  1.00 19.57           C  
ATOM    354  CG1 ILE A  59     -61.782  11.890 -27.235  1.00 18.98           C  
ATOM    355  CG2 ILE A  59     -64.302  12.131 -27.183  1.00 17.93           C  
ATOM    356  CD1 ILE A  59     -61.725  10.436 -27.683  1.00 18.09           C  
ATOM    357  N   LYS A  60     -61.803  13.392 -23.590  1.00 11.73           N  
ATOM    358  CA  LYS A  60     -60.674  13.358 -22.677  1.00  8.91           C  
ATOM    359  C   LYS A  60     -60.463  11.915 -22.268  1.00 14.10           C  
ATOM    360  O   LYS A  60     -61.332  11.309 -21.638  1.00 13.20           O  
ATOM    361  CB  LYS A  60     -60.942  14.205 -21.430  1.00 10.08           C  
ATOM    362  CG  LYS A  60     -59.825  14.108 -20.385  1.00 12.95           C  
ATOM    363  CD  LYS A  60     -59.961  15.170 -19.290  1.00 17.91           C  
ATOM    364  CE  LYS A  60     -61.256  15.039 -18.525  1.00 26.87           C  
ATOM    365  NZ  LYS A  60     -61.331  16.006 -17.386  1.00 25.68           N  
ATOM    366  N   ILE A  61     -59.313  11.371 -22.653  1.00 10.43           N  
ATOM    367  CA  ILE A  61     -58.937  10.002 -22.338  1.00 11.72           C  
ATOM    368  C   ILE A  61     -58.058  10.027 -21.088  1.00 13.65           C  
ATOM    369  O   ILE A  61     -57.084  10.781 -21.015  1.00 10.80           O  
ATOM    370  CB  ILE A  61     -58.151   9.366 -23.517  1.00 14.05           C  
ATOM    371  CG1 ILE A  61     -59.037   9.320 -24.767  1.00 14.09           C  
ATOM    372  CG2 ILE A  61     -57.715   7.957 -23.162  1.00 16.29           C  
ATOM    373  CD1 ILE A  61     -58.297   8.908 -26.042  1.00 17.58           C  
ATOM    374  N   GLU A  62     -58.410   9.205 -20.104  1.00  9.10           N  
ATOM    375  CA  GLU A  62     -57.659   9.148 -18.859  1.00 11.51           C  
ATOM    376  C   GLU A  62     -57.174   7.746 -18.512  1.00 14.81           C  
ATOM    377  O   GLU A  62     -57.936   6.784 -18.578  1.00 14.10           O  
ATOM    378  CB  GLU A  62     -58.526   9.667 -17.703  1.00 16.05           C  
ATOM    379  CG  GLU A  62     -58.933  11.126 -17.831  1.00 19.30           C  
ATOM    380  CD  GLU A  62     -59.837  11.578 -16.694  1.00 26.95           C  
ATOM    381  OE1 GLU A  62     -61.051  11.288 -16.736  1.00 27.87           O  
ATOM    382  OE2 GLU A  62     -59.333  12.219 -15.749  1.00 30.63           O  
ATOM    383  N   LEU A  63     -55.902   7.639 -18.144  1.00 13.67           N  
ATOM    384  CA  LEU A  63     -55.338   6.362 -17.733  1.00 16.25           C  
ATOM    385  C   LEU A  63     -54.319   6.562 -16.624  1.00 12.48           C  
ATOM    386  O   LEU A  63     -53.661   7.594 -16.556  1.00 11.73           O  
ATOM    387  CB  LEU A  63     -54.680   5.638 -18.911  1.00 26.50           C  
ATOM    388  CG  LEU A  63     -53.869   6.435 -19.930  1.00 29.82           C  
ATOM    389  CD1 LEU A  63     -52.883   5.518 -20.626  1.00 38.08           C  
ATOM    390  CD2 LEU A  63     -54.812   7.071 -20.943  1.00 32.28           C  
ATOM    391  N   VAL A  64     -54.215   5.574 -15.740  1.00  9.80           N  
ATOM    392  CA  VAL A  64     -53.256   5.610 -14.650  1.00 10.71           C  
ATOM    393  C   VAL A  64     -52.398   4.355 -14.811  1.00 13.15           C  
ATOM    394  O   VAL A  64     -52.913   3.233 -14.853  1.00 15.08           O  
ATOM    395  CB  VAL A  64     -53.967   5.628 -13.281  1.00 12.43           C  
ATOM    396  CG1 VAL A  64     -52.946   5.512 -12.154  1.00 12.76           C  
ATOM    397  CG2 VAL A  64     -54.766   6.942 -13.140  1.00  9.16           C  
ATOM    398  N   LEU A  65     -51.088   4.552 -14.908  1.00 15.52           N  
ATOM    399  CA  LEU A  65     -50.172   3.441 -15.122  1.00 15.94           C  
ATOM    400  C   LEU A  65     -48.815   3.655 -14.471  1.00 15.68           C  
ATOM    401  O   LEU A  65     -48.519   4.737 -13.972  1.00 12.94           O  
ATOM    402  CB  LEU A  65     -49.982   3.230 -16.626  1.00 15.80           C  
ATOM    403  CG  LEU A  65     -49.278   4.317 -17.454  1.00 20.05           C  
ATOM    404  CD1 LEU A  65     -49.281   3.899 -18.912  1.00 19.17           C  
ATOM    405  CD2 LEU A  65     -49.976   5.667 -17.305  1.00 19.29           C  
ATOM    406  N   ALA A  66     -47.987   2.614 -14.500  1.00 14.90           N  
ATOM    407  CA  ALA A  66     -46.649   2.670 -13.918  1.00 17.37           C  
ATOM    408  C   ALA A  66     -45.787   3.711 -14.627  1.00 18.56           C  
ATOM    409  O   ALA A  66     -45.826   3.836 -15.857  1.00 16.68           O  
ATOM    410  CB  ALA A  66     -45.990   1.294 -13.992  1.00 20.96           C  
ATOM    411  N   ASP A  67     -44.999   4.449 -13.855  1.00 16.79           N  
ATOM    412  CA  ASP A  67     -44.160   5.495 -14.428  1.00 23.21           C  
ATOM    413  C   ASP A  67     -43.285   5.029 -15.590  1.00 22.62           C  
ATOM    414  O   ASP A  67     -43.054   5.782 -16.532  1.00 19.25           O  
ATOM    415  CB  ASP A  67     -43.293   6.150 -13.345  1.00 25.91           C  
ATOM    416  CG  ASP A  67     -42.515   5.144 -12.524  1.00 40.33           C  
ATOM    417  OD1 ASP A  67     -42.028   4.149 -13.097  1.00 37.86           O  
ATOM    418  OD2 ASP A  67     -42.378   5.359 -11.302  1.00 46.89           O  
ATOM    419  N   ASP A  68     -42.816   3.788 -15.541  1.00 21.44           N  
ATOM    420  CA  ASP A  68     -41.962   3.270 -16.607  1.00 28.13           C  
ATOM    421  C   ASP A  68     -42.703   3.019 -17.926  1.00 25.55           C  
ATOM    422  O   ASP A  68     -42.073   2.794 -18.957  1.00 24.06           O  
ATOM    423  CB  ASP A  68     -41.282   1.976 -16.156  1.00 34.73           C  
ATOM    424  CG  ASP A  68     -42.276   0.907 -15.752  1.00 46.28           C  
ATOM    425  OD1 ASP A  68     -42.901   1.043 -14.681  1.00 56.33           O  
ATOM    426  OD2 ASP A  68     -42.445  -0.071 -16.510  1.00 54.32           O  
ATOM    427  N   ALA A  69     -44.033   3.050 -17.893  1.00 18.87           N  
ATOM    428  CA  ALA A  69     -44.839   2.821 -19.093  1.00 18.09           C  
ATOM    429  C   ALA A  69     -45.315   4.116 -19.754  1.00 16.25           C  
ATOM    430  O   ALA A  69     -45.823   4.098 -20.878  1.00 19.07           O  
ATOM    431  CB  ALA A  69     -46.051   1.953 -18.751  1.00 16.42           C  
ATOM    432  N   VAL A  70     -45.146   5.232 -19.059  1.00 14.04           N  
ATOM    433  CA  VAL A  70     -45.584   6.535 -19.556  1.00 13.94           C  
ATOM    434  C   VAL A  70     -44.994   6.997 -20.890  1.00 14.46           C  
ATOM    435  O   VAL A  70     -45.732   7.448 -21.766  1.00 13.92           O  
ATOM    436  CB  VAL A  70     -45.334   7.630 -18.495  1.00 12.44           C  
ATOM    437  CG1 VAL A  70     -45.596   9.024 -19.085  1.00 18.05           C  
ATOM    438  CG2 VAL A  70     -46.245   7.394 -17.296  1.00 17.40           C  
ATOM    439  N   GLU A  71     -43.678   6.889 -21.049  1.00 13.58           N  
ATOM    440  CA  GLU A  71     -43.025   7.327 -22.284  1.00 14.54           C  
ATOM    441  C   GLU A  71     -43.552   6.642 -23.543  1.00 13.61           C  
ATOM    442  O   GLU A  71     -43.858   7.307 -24.536  1.00 16.72           O  
ATOM    443  CB  GLU A  71     -41.505   7.122 -22.188  1.00 19.54           C  
ATOM    444  CG  GLU A  71     -40.739   7.655 -23.398  1.00 15.68           C  
ATOM    445  CD  GLU A  71     -39.223   7.509 -23.258  1.00 18.91           C  
ATOM    446  OE1 GLU A  71     -38.492   7.932 -24.181  1.00 22.33           O  
ATOM    447  OE2 GLU A  71     -38.766   6.968 -22.231  1.00 19.36           O  
ATOM    448  N   ARG A  72     -43.645   5.315 -23.514  1.00 13.87           N  
ATOM    449  CA  ARG A  72     -44.143   4.568 -24.669  1.00 12.92           C  
ATOM    450  C   ARG A  72     -45.606   4.910 -24.942  1.00 14.33           C  
ATOM    451  O   ARG A  72     -46.012   5.048 -26.095  1.00 14.76           O  
ATOM    452  CB  ARG A  72     -44.006   3.058 -24.437  1.00 17.59           C  
ATOM    453  CG  ARG A  72     -42.585   2.540 -24.489  1.00 39.79           C  
ATOM    454  CD  ARG A  72     -42.437   1.476 -25.567  1.00 49.29           C  
ATOM    455  NE  ARG A  72     -41.060   1.005 -25.688  1.00 56.22           N  
ATOM    456  CZ  ARG A  72     -40.622   0.236 -26.678  1.00 60.28           C  
ATOM    457  NH1 ARG A  72     -41.452  -0.148 -27.638  1.00 60.72           N  
ATOM    458  NH2 ARG A  72     -39.351  -0.148 -26.712  1.00 63.63           N  
ATOM    459  N   ALA A  73     -46.398   5.048 -23.882  1.00 13.16           N  
ATOM    460  CA  ALA A  73     -47.809   5.377 -24.047  1.00 12.59           C  
ATOM    461  C   ALA A  73     -47.948   6.735 -24.741  1.00 11.50           C  
ATOM    462  O   ALA A  73     -48.716   6.872 -25.686  1.00 15.58           O  
ATOM    463  CB  ALA A  73     -48.508   5.393 -22.694  1.00 12.82           C  
ATOM    464  N   ILE A  74     -47.205   7.734 -24.270  1.00 13.19           N  
ATOM    465  CA  ILE A  74     -47.245   9.063 -24.892  1.00 16.31           C  
ATOM    466  C   ILE A  74     -46.867   8.977 -26.378  1.00 15.96           C  
ATOM    467  O   ILE A  74     -47.566   9.520 -27.239  1.00 13.55           O  
ATOM    468  CB  ILE A  74     -46.264  10.044 -24.195  1.00 18.20           C  
ATOM    469  CG1 ILE A  74     -46.773  10.379 -22.791  1.00 19.82           C  
ATOM    470  CG2 ILE A  74     -46.106  11.316 -25.029  1.00 17.65           C  
ATOM    471  CD1 ILE A  74     -45.791  11.195 -21.952  1.00 17.10           C  
ATOM    472  N   ASP A  75     -45.762   8.298 -26.678  1.00 16.40           N  
ATOM    473  CA  ASP A  75     -45.306   8.172 -28.065  1.00 15.75           C  
ATOM    474  C   ASP A  75     -46.353   7.558 -28.994  1.00 17.78           C  
ATOM    475  O   ASP A  75     -46.532   8.009 -30.129  1.00 17.96           O  
ATOM    476  CB  ASP A  75     -44.009   7.350 -28.144  1.00 15.97           C  
ATOM    477  CG  ASP A  75     -42.820   8.064 -27.512  1.00 23.58           C  
ATOM    478  OD1 ASP A  75     -42.869   9.305 -27.375  1.00 20.05           O  
ATOM    479  OD2 ASP A  75     -41.827   7.382 -27.167  1.00 23.75           O  
ATOM    480  N   VAL A  76     -47.046   6.528 -28.518  1.00 18.52           N  
ATOM    481  CA  VAL A  76     -48.072   5.876 -29.320  1.00 17.99           C  
ATOM    482  C   VAL A  76     -49.281   6.789 -29.558  1.00 19.56           C  
ATOM    483  O   VAL A  76     -49.867   6.785 -30.642  1.00 20.64           O  
ATOM    484  CB  VAL A  76     -48.528   4.555 -28.653  1.00 23.71           C  
ATOM    485  CG1 VAL A  76     -49.852   4.098 -29.224  1.00 28.48           C  
ATOM    486  CG2 VAL A  76     -47.475   3.480 -28.880  1.00 24.73           C  
ATOM    487  N   ILE A  77     -49.655   7.568 -28.549  1.00 16.81           N  
ATOM    488  CA  ILE A  77     -50.787   8.477 -28.690  1.00 17.06           C  
ATOM    489  C   ILE A  77     -50.443   9.568 -29.709  1.00 15.92           C  
ATOM    490  O   ILE A  77     -51.262   9.910 -30.564  1.00 16.41           O  
ATOM    491  CB  ILE A  77     -51.156   9.124 -27.330  1.00 14.46           C  
ATOM    492  CG1 ILE A  77     -51.680   8.050 -26.370  1.00 14.57           C  
ATOM    493  CG2 ILE A  77     -52.211  10.211 -27.534  1.00 16.59           C  
ATOM    494  CD1 ILE A  77     -51.862   8.543 -24.945  1.00 13.47           C  
ATOM    495  N   VAL A  78     -49.226  10.094 -29.626  1.00 16.74           N  
ATOM    496  CA  VAL A  78     -48.777  11.131 -30.551  1.00 20.14           C  
ATOM    497  C   VAL A  78     -48.718  10.584 -31.976  1.00 20.89           C  
ATOM    498  O   VAL A  78     -49.051  11.277 -32.940  1.00 23.93           O  
ATOM    499  CB  VAL A  78     -47.372  11.661 -30.161  1.00 21.45           C  
ATOM    500  CG1 VAL A  78     -46.848  12.609 -31.238  1.00 24.47           C  
ATOM    501  CG2 VAL A  78     -47.436  12.386 -28.822  1.00 21.44           C  
ATOM    502  N   GLU A  79     -48.299   9.329 -32.101  1.00 24.42           N  
ATOM    503  CA  GLU A  79     -48.169   8.680 -33.398  1.00 28.57           C  
ATOM    504  C   GLU A  79     -49.491   8.601 -34.157  1.00 30.07           C  
ATOM    505  O   GLU A  79     -49.544   8.885 -35.354  1.00 29.41           O  
ATOM    506  CB  GLU A  79     -47.604   7.271 -33.218  1.00 36.66           C  
ATOM    507  CG  GLU A  79     -47.100   6.638 -34.501  1.00 48.30           C  
ATOM    508  CD  GLU A  79     -45.844   7.309 -35.021  1.00 58.34           C  
ATOM    509  OE1 GLU A  79     -44.816   7.280 -34.309  1.00 66.60           O  
ATOM    510  OE2 GLU A  79     -45.884   7.868 -36.137  1.00 63.13           O  
ATOM    511  N   VAL A  80     -50.560   8.217 -33.466  1.00 23.68           N  
ATOM    512  CA  VAL A  80     -51.855   8.100 -34.122  1.00 25.71           C  
ATOM    513  C   VAL A  80     -52.619   9.417 -34.255  1.00 27.71           C  
ATOM    514  O   VAL A  80     -53.465   9.551 -35.139  1.00 29.96           O  
ATOM    515  CB  VAL A  80     -52.762   7.063 -33.408  1.00 28.22           C  
ATOM    516  CG1 VAL A  80     -52.107   5.688 -33.440  1.00 30.76           C  
ATOM    517  CG2 VAL A  80     -53.031   7.491 -31.977  1.00 29.15           C  
ATOM    518  N   ALA A  81     -52.315  10.388 -33.396  1.00 26.53           N  
ATOM    519  CA  ALA A  81     -53.010  11.675 -33.425  1.00 29.62           C  
ATOM    520  C   ALA A  81     -52.288  12.822 -34.147  1.00 29.80           C  
ATOM    521  O   ALA A  81     -52.937  13.730 -34.661  1.00 37.34           O  
ATOM    522  CB  ALA A  81     -53.353  12.104 -31.995  1.00 29.88           C  
ATOM    523  N   ARG A  82     -50.960  12.794 -34.183  1.00 33.12           N  
ATOM    524  CA  ARG A  82     -50.211  13.860 -34.849  1.00 35.12           C  
ATOM    525  C   ARG A  82     -50.453  13.862 -36.355  1.00 41.99           C  
ATOM    526  O   ARG A  82     -50.249  12.849 -37.022  1.00 37.16           O  
ATOM    527  CB  ARG A  82     -48.710  13.715 -34.581  1.00 40.16           C  
ATOM    528  CG  ARG A  82     -47.841  14.708 -35.350  1.00 39.93           C  
ATOM    529  CD  ARG A  82     -46.360  14.542 -35.020  1.00 43.90           C  
ATOM    530  NE  ARG A  82     -46.041  14.975 -33.661  1.00 42.01           N  
ATOM    531  CZ  ARG A  82     -44.826  14.928 -33.122  1.00 43.36           C  
ATOM    532  NH1 ARG A  82     -43.800  14.463 -33.823  1.00 45.19           N  
ATOM    533  NH2 ARG A  82     -44.630  15.351 -31.881  1.00 43.85           N  
ATOM    534  N   SER A  83     -50.886  15.006 -36.880  1.00 47.55           N  
ATOM    535  CA  SER A  83     -51.144  15.148 -38.312  1.00 51.85           C  
ATOM    536  C   SER A  83     -50.327  16.305 -38.885  1.00 55.74           C  
ATOM    537  O   SER A  83     -50.164  16.418 -40.101  1.00 58.67           O  
ATOM    538  CB  SER A  83     -52.633  15.395 -38.572  1.00 47.95           C  
ATOM    539  OG  SER A  83     -53.034  16.671 -38.106  1.00 46.79           O  
ATOM    540  N   GLY A  84     -49.822  17.163 -38.002  1.00 57.14           N  
ATOM    541  CA  GLY A  84     -49.021  18.294 -38.439  1.00 57.46           C  
ATOM    542  C   GLY A  84     -49.749  19.627 -38.470  1.00 59.66           C  
ATOM    543  O   GLY A  84     -49.115  20.671 -38.633  1.00 59.90           O  
ATOM    544  N   LYS A  85     -51.072  19.604 -38.319  1.00 60.26           N  
ATOM    545  CA  LYS A  85     -51.861  20.835 -38.336  1.00 58.75           C  
ATOM    546  C   LYS A  85     -52.697  21.052 -37.076  1.00 56.44           C  
ATOM    547  O   LYS A  85     -53.015  20.110 -36.352  1.00 55.18           O  
ATOM    548  CB  LYS A  85     -52.774  20.868 -39.564  1.00 62.11           C  
ATOM    549  CG  LYS A  85     -52.055  21.144 -40.882  1.00 65.86           C  
ATOM    550  CD  LYS A  85     -51.104  20.021 -41.286  1.00 67.34           C  
ATOM    551  CE  LYS A  85     -51.844  18.727 -41.611  1.00 70.04           C  
ATOM    552  NZ  LYS A  85     -52.533  18.142 -40.426  1.00 73.56           N  
ATOM    553  N   ILE A  86     -53.044  22.313 -36.840  1.00 54.28           N  
ATOM    554  CA  ILE A  86     -53.826  22.747 -35.682  1.00 49.22           C  
ATOM    555  C   ILE A  86     -54.918  21.786 -35.205  1.00 46.80           C  
ATOM    556  O   ILE A  86     -55.614  21.164 -36.011  1.00 45.20           O  
ATOM    557  CB  ILE A  86     -54.488  24.128 -35.954  1.00 50.67           C  
ATOM    558  CG1 ILE A  86     -53.415  25.184 -36.243  1.00 55.51           C  
ATOM    559  CG2 ILE A  86     -55.317  24.559 -34.755  1.00 51.48           C  
ATOM    560  CD1 ILE A  86     -52.725  25.033 -37.591  1.00 57.48           C  
ATOM    561  N   GLY A  87     -55.051  21.675 -33.885  1.00 41.20           N  
ATOM    562  CA  GLY A  87     -56.071  20.822 -33.299  1.00 37.71           C  
ATOM    563  C   GLY A  87     -55.739  19.358 -33.058  1.00 35.65           C  
ATOM    564  O   GLY A  87     -56.639  18.579 -32.750  1.00 35.89           O  
ATOM    565  N   ASP A  88     -54.473  18.967 -33.187  1.00 32.86           N  
ATOM    566  CA  ASP A  88     -54.102  17.568 -32.965  1.00 30.13           C  
ATOM    567  C   ASP A  88     -54.342  17.106 -31.530  1.00 28.79           C  
ATOM    568  O   ASP A  88     -54.432  15.906 -31.271  1.00 32.22           O  
ATOM    569  CB  ASP A  88     -52.633  17.322 -33.331  1.00 31.84           C  
ATOM    570  CG  ASP A  88     -52.431  17.111 -34.816  1.00 35.73           C  
ATOM    571  OD1 ASP A  88     -53.395  16.684 -35.483  1.00 39.45           O  
ATOM    572  OD2 ASP A  88     -51.310  17.351 -35.314  1.00 32.81           O  
ATOM    573  N   GLY A  89     -54.438  18.051 -30.600  1.00 22.11           N  
ATOM    574  CA  GLY A  89     -54.674  17.682 -29.214  1.00 20.72           C  
ATOM    575  C   GLY A  89     -53.562  18.011 -28.232  1.00 18.68           C  
ATOM    576  O   GLY A  89     -52.548  18.633 -28.584  1.00 16.55           O  
ATOM    577  N   LYS A  90     -53.755  17.576 -26.989  1.00 16.39           N  
ATOM    578  CA  LYS A  90     -52.801  17.831 -25.915  1.00 15.19           C  
ATOM    579  C   LYS A  90     -52.686  16.629 -24.992  1.00 11.55           C  
ATOM    580  O   LYS A  90     -53.636  15.872 -24.822  1.00 12.32           O  
ATOM    581  CB  LYS A  90     -53.253  19.047 -25.092  1.00 15.05           C  
ATOM    582  CG  LYS A  90     -53.542  20.290 -25.921  1.00 26.38           C  
ATOM    583  CD  LYS A  90     -54.297  21.338 -25.112  1.00 26.74           C  
ATOM    584  CE  LYS A  90     -54.737  22.500 -25.990  1.00 36.92           C  
ATOM    585  NZ  LYS A  90     -55.568  23.478 -25.236  1.00 42.56           N  
ATOM    586  N   ILE A  91     -51.518  16.469 -24.384  1.00 10.41           N  
ATOM    587  CA  ILE A  91     -51.283  15.361 -23.461  1.00 14.50           C  
ATOM    588  C   ILE A  91     -50.667  15.906 -22.172  1.00 11.35           C  
ATOM    589  O   ILE A  91     -49.670  16.628 -22.217  1.00 11.73           O  
ATOM    590  CB  ILE A  91     -50.294  14.327 -24.048  1.00 15.82           C  
ATOM    591  CG1 ILE A  91     -50.769  13.845 -25.423  1.00 23.62           C  
ATOM    592  CG2 ILE A  91     -50.149  13.144 -23.076  1.00 15.07           C  
ATOM    593  CD1 ILE A  91     -52.031  13.043 -25.395  1.00 38.65           C  
ATOM    594  N   PHE A  92     -51.264  15.566 -21.031  1.00 13.21           N  
ATOM    595  CA  PHE A  92     -50.745  16.012 -19.736  1.00 12.24           C  
ATOM    596  C   PHE A  92     -50.404  14.817 -18.849  1.00 15.90           C  
ATOM    597  O   PHE A  92     -51.091  13.800 -18.889  1.00 14.13           O  
ATOM    598  CB  PHE A  92     -51.787  16.870 -19.008  1.00 10.52           C  
ATOM    599  CG  PHE A  92     -52.368  17.964 -19.853  1.00 10.81           C  
ATOM    600  CD1 PHE A  92     -51.546  18.941 -20.406  1.00 16.03           C  
ATOM    601  CD2 PHE A  92     -53.738  18.021 -20.095  1.00 11.84           C  
ATOM    602  CE1 PHE A  92     -52.081  19.968 -21.188  1.00 15.94           C  
ATOM    603  CE2 PHE A  92     -54.285  19.050 -20.879  1.00 16.80           C  
ATOM    604  CZ  PHE A  92     -53.454  20.019 -21.424  1.00 14.77           C  
ATOM    605  N   VAL A  93     -49.334  14.936 -18.063  1.00  9.62           N  
ATOM    606  CA  VAL A  93     -48.957  13.871 -17.139  1.00 15.00           C  
ATOM    607  C   VAL A  93     -48.942  14.447 -15.720  1.00 12.82           C  
ATOM    608  O   VAL A  93     -48.298  15.458 -15.464  1.00 13.24           O  
ATOM    609  CB  VAL A  93     -47.560  13.294 -17.458  1.00 17.44           C  
ATOM    610  CG1 VAL A  93     -47.197  12.229 -16.428  1.00 12.89           C  
ATOM    611  CG2 VAL A  93     -47.549  12.691 -18.860  1.00 11.74           C  
ATOM    612  N   LEU A  94     -49.668  13.808 -14.807  1.00 13.26           N  
ATOM    613  CA  LEU A  94     -49.716  14.263 -13.421  1.00 13.23           C  
ATOM    614  C   LEU A  94     -49.329  13.132 -12.475  1.00 10.28           C  
ATOM    615  O   LEU A  94     -49.567  11.955 -12.759  1.00 11.01           O  
ATOM    616  CB  LEU A  94     -51.117  14.769 -13.054  1.00  9.13           C  
ATOM    617  CG  LEU A  94     -51.721  15.898 -13.893  1.00 11.83           C  
ATOM    618  CD1 LEU A  94     -52.452  15.315 -15.090  1.00 12.73           C  
ATOM    619  CD2 LEU A  94     -52.693  16.706 -13.033  1.00 16.93           C  
ATOM    620  N   PRO A  95     -48.717  13.479 -11.337  1.00 11.42           N  
ATOM    621  CA  PRO A  95     -48.306  12.470 -10.360  1.00 11.87           C  
ATOM    622  C   PRO A  95     -49.501  11.877  -9.619  1.00 14.35           C  
ATOM    623  O   PRO A  95     -50.486  12.567  -9.354  1.00  9.87           O  
ATOM    624  CB  PRO A  95     -47.366  13.249  -9.443  1.00 14.40           C  
ATOM    625  CG  PRO A  95     -47.963  14.630  -9.458  1.00 18.17           C  
ATOM    626  CD  PRO A  95     -48.310  14.833 -10.910  1.00 13.15           C  
ATOM    627  N   VAL A  96     -49.414  10.582  -9.324  1.00 12.05           N  
ATOM    628  CA  VAL A  96     -50.453   9.864  -8.593  1.00 12.72           C  
ATOM    629  C   VAL A  96     -49.789   9.243  -7.361  1.00 17.00           C  
ATOM    630  O   VAL A  96     -48.799   8.523  -7.479  1.00 14.90           O  
ATOM    631  CB  VAL A  96     -51.091   8.752  -9.465  1.00 15.90           C  
ATOM    632  CG1 VAL A  96     -51.963   7.836  -8.605  1.00 15.96           C  
ATOM    633  CG2 VAL A  96     -51.946   9.388 -10.578  1.00 17.75           C  
ATOM    634  N   GLU A  97     -50.332   9.528  -6.181  1.00 14.42           N  
ATOM    635  CA  GLU A  97     -49.773   9.005  -4.937  1.00 16.09           C  
ATOM    636  C   GLU A  97     -50.318   7.632  -4.555  1.00 21.35           C  
ATOM    637  O   GLU A  97     -49.660   6.868  -3.840  1.00 18.47           O  
ATOM    638  CB  GLU A  97     -50.025   9.990  -3.794  1.00 16.93           C  
ATOM    639  CG  GLU A  97     -49.290  11.306  -3.956  1.00 22.44           C  
ATOM    640  CD  GLU A  97     -49.553  12.277  -2.813  1.00 25.93           C  
ATOM    641  OE1 GLU A  97     -50.167  11.865  -1.806  1.00 28.00           O  
ATOM    642  OE2 GLU A  97     -49.138  13.450  -2.920  1.00 31.67           O  
ATOM    643  N   GLU A  98     -51.522   7.325  -5.019  1.00 17.35           N  
ATOM    644  CA  GLU A  98     -52.145   6.042  -4.726  1.00 20.67           C  
ATOM    645  C   GLU A  98     -53.026   5.635  -5.902  1.00 18.27           C  
ATOM    646  O   GLU A  98     -53.759   6.461  -6.437  1.00 15.11           O  
ATOM    647  CB  GLU A  98     -53.008   6.156  -3.465  1.00 26.30           C  
ATOM    648  CG  GLU A  98     -52.719   5.108  -2.408  1.00 40.06           C  
ATOM    649  CD  GLU A  98     -51.348   5.270  -1.782  1.00 36.38           C  
ATOM    650  OE1 GLU A  98     -51.130   6.274  -1.067  1.00 42.14           O  
ATOM    651  OE2 GLU A  98     -50.488   4.395  -2.005  1.00 40.16           O  
ATOM    652  N   ALA A  99     -52.934   4.369  -6.310  1.00 15.61           N  
ATOM    653  CA  ALA A  99     -53.750   3.831  -7.405  1.00 14.81           C  
ATOM    654  C   ALA A  99     -54.280   2.517  -6.847  1.00 17.43           C  
ATOM    655  O   ALA A  99     -53.542   1.539  -6.746  1.00 17.09           O  
ATOM    656  CB  ALA A  99     -52.898   3.583  -8.637  1.00 18.67           C  
ATOM    657  N   ILE A 100     -55.561   2.499  -6.497  1.00 13.51           N  
ATOM    658  CA  ILE A 100     -56.166   1.332  -5.866  1.00 17.14           C  
ATOM    659  C   ILE A 100     -57.270   0.627  -6.631  1.00 18.60           C  
ATOM    660  O   ILE A 100     -58.211   1.255  -7.110  1.00 15.00           O  
ATOM    661  CB  ILE A 100     -56.747   1.731  -4.492  1.00 14.90           C  
ATOM    662  CG1 ILE A 100     -55.673   2.429  -3.658  1.00 16.79           C  
ATOM    663  CG2 ILE A 100     -57.270   0.499  -3.756  1.00 21.77           C  
ATOM    664  CD1 ILE A 100     -56.229   3.223  -2.486  1.00 19.53           C  
ATOM    665  N   ARG A 101     -57.147  -0.692  -6.723  1.00 17.39           N  
ATOM    666  CA  ARG A 101     -58.155  -1.521  -7.366  1.00 21.27           C  
ATOM    667  C   ARG A 101     -59.103  -1.883  -6.217  1.00 25.27           C  
ATOM    668  O   ARG A 101     -58.755  -2.670  -5.337  1.00 25.46           O  
ATOM    669  CB  ARG A 101     -57.497  -2.773  -7.939  1.00 22.89           C  
ATOM    670  CG  ARG A 101     -58.425  -3.714  -8.669  1.00 40.55           C  
ATOM    671  CD  ARG A 101     -57.644  -4.934  -9.121  1.00 49.74           C  
ATOM    672  NE  ARG A 101     -58.493  -5.983  -9.670  1.00 55.38           N  
ATOM    673  CZ  ARG A 101     -58.065  -7.213  -9.934  1.00 55.32           C  
ATOM    674  NH1 ARG A 101     -56.800  -7.535  -9.695  1.00 53.26           N  
ATOM    675  NH2 ARG A 101     -58.895  -8.120 -10.432  1.00 57.15           N  
ATOM    676  N   ILE A 102     -60.291  -1.289  -6.220  1.00 21.96           N  
ATOM    677  CA  ILE A 102     -61.273  -1.511  -5.162  1.00 26.40           C  
ATOM    678  C   ILE A 102     -61.501  -2.970  -4.760  1.00 30.60           C  
ATOM    679  O   ILE A 102     -61.691  -3.266  -3.581  1.00 29.25           O  
ATOM    680  CB  ILE A 102     -62.630  -0.857  -5.534  1.00 21.53           C  
ATOM    681  CG1 ILE A 102     -62.483   0.669  -5.511  1.00 19.94           C  
ATOM    682  CG2 ILE A 102     -63.716  -1.294  -4.560  1.00 25.72           C  
ATOM    683  CD1 ILE A 102     -63.750   1.425  -5.873  1.00 21.28           C  
ATOM    684  N   ARG A 103     -61.465  -3.879  -5.728  1.00 32.48           N  
ATOM    685  CA  ARG A 103     -61.697  -5.293  -5.446  1.00 36.69           C  
ATOM    686  C   ARG A 103     -60.775  -5.933  -4.409  1.00 39.14           C  
ATOM    687  O   ARG A 103     -61.252  -6.580  -3.475  1.00 38.81           O  
ATOM    688  CB  ARG A 103     -61.606  -6.117  -6.726  1.00 38.70           C  
ATOM    689  CG  ARG A 103     -62.219  -7.501  -6.582  1.00 46.50           C  
ATOM    690  CD  ARG A 103     -61.520  -8.550  -7.432  1.00 55.73           C  
ATOM    691  NE  ARG A 103     -61.102  -8.062  -8.747  1.00 66.83           N  
ATOM    692  CZ  ARG A 103     -61.863  -7.346  -9.569  1.00 72.04           C  
ATOM    693  NH1 ARG A 103     -63.097  -7.013  -9.219  1.00 69.66           N  
ATOM    694  NH2 ARG A 103     -61.390  -6.972 -10.750  1.00 73.86           N  
ATOM    695  N   THR A 104     -59.466  -5.760  -4.573  1.00 39.80           N  
ATOM    696  CA  THR A 104     -58.496  -6.370  -3.658  1.00 41.57           C  
ATOM    697  C   THR A 104     -57.581  -5.419  -2.891  1.00 41.35           C  
ATOM    698  O   THR A 104     -56.922  -5.828  -1.931  1.00 39.19           O  
ATOM    699  CB  THR A 104     -57.590  -7.356  -4.414  1.00 41.01           C  
ATOM    700  OG1 THR A 104     -56.907  -6.660  -5.463  1.00 45.75           O  
ATOM    701  CG2 THR A 104     -58.409  -8.485  -5.017  1.00 43.85           C  
ATOM    702  N   GLY A 105     -57.529  -4.159  -3.305  1.00 39.91           N  
ATOM    703  CA  GLY A 105     -56.658  -3.215  -2.630  1.00 33.89           C  
ATOM    704  C   GLY A 105     -55.304  -3.208  -3.308  1.00 35.74           C  
ATOM    705  O   GLY A 105     -54.385  -2.499  -2.892  1.00 33.47           O  
ATOM    706  N   GLU A 106     -55.175  -4.022  -4.352  1.00 33.06           N  
ATOM    707  CA  GLU A 106     -53.936  -4.099  -5.115  1.00 34.13           C  
ATOM    708  C   GLU A 106     -53.837  -2.818  -5.934  1.00 33.49           C  
ATOM    709  O   GLU A 106     -54.805  -2.059  -6.020  1.00 30.05           O  
ATOM    710  CB  GLU A 106     -53.961  -5.314  -6.047  1.00 41.58           C  
ATOM    711  CG  GLU A 106     -54.044  -6.651  -5.326  1.00 50.62           C  
ATOM    712  CD  GLU A 106     -54.159  -7.824  -6.283  1.00 58.80           C  
ATOM    713  OE1 GLU A 106     -54.185  -8.981  -5.809  1.00 60.70           O  
ATOM    714  OE2 GLU A 106     -54.224  -7.589  -7.509  1.00 58.93           O  
ATOM    715  N   ARG A 107     -52.677  -2.575  -6.537  1.00 32.49           N  
ATOM    716  CA  ARG A 107     -52.493  -1.366  -7.333  1.00 35.58           C  
ATOM    717  C   ARG A 107     -53.238  -1.437  -8.664  1.00 36.28           C  
ATOM    718  O   ARG A 107     -53.309  -2.494  -9.299  1.00 37.23           O  
ATOM    719  CB  ARG A 107     -51.007  -1.116  -7.607  1.00 43.98           C  
ATOM    720  CG  ARG A 107     -50.379  -2.111  -8.560  1.00 48.98           C  
ATOM    721  CD  ARG A 107     -49.117  -1.544  -9.187  1.00 50.38           C  
ATOM    722  NE  ARG A 107     -48.085  -1.244  -8.201  1.00 47.65           N  
ATOM    723  CZ  ARG A 107     -46.872  -0.794  -8.509  1.00 55.20           C  
ATOM    724  NH1 ARG A 107     -45.992  -0.547  -7.549  1.00 54.85           N  
ATOM    725  NH2 ARG A 107     -46.538  -0.592  -9.777  1.00 54.86           N  
ATOM    726  N   SER A 108     -53.797  -0.300  -9.071  1.00 29.28           N  
ATOM    727  CA  SER A 108     -54.527  -0.199 -10.329  1.00 23.34           C  
ATOM    728  C   SER A 108     -53.549   0.314 -11.373  1.00 25.87           C  
ATOM    729  O   SER A 108     -53.294   1.515 -11.458  1.00 28.22           O  
ATOM    730  CB  SER A 108     -55.694   0.780 -10.191  1.00 24.65           C  
ATOM    731  OG  SER A 108     -56.397   0.900 -11.413  1.00 25.23           O  
ATOM    732  N   ASP A 109     -53.004  -0.606 -12.159  1.00 24.40           N  
ATOM    733  CA  ASP A 109     -52.022  -0.268 -13.187  1.00 27.68           C  
ATOM    734  C   ASP A 109     -52.513  -0.651 -14.584  1.00 29.44           C  
ATOM    735  O   ASP A 109     -52.707  -1.830 -14.880  1.00 28.55           O  
ATOM    736  CB  ASP A 109     -50.712  -0.994 -12.866  1.00 29.05           C  
ATOM    737  CG  ASP A 109     -49.563  -0.560 -13.746  1.00 33.45           C  
ATOM    738  OD1 ASP A 109     -49.781   0.213 -14.706  1.00 30.41           O  
ATOM    739  OD2 ASP A 109     -48.428  -1.007 -13.474  1.00 29.94           O  
ATOM    740  N   ALA A 110     -52.713   0.343 -15.444  1.00 28.38           N  
ATOM    741  CA  ALA A 110     -53.183   0.085 -16.806  1.00 25.78           C  
ATOM    742  C   ALA A 110     -52.165  -0.732 -17.592  1.00 28.04           C  
ATOM    743  O   ALA A 110     -52.524  -1.493 -18.492  1.00 28.47           O  
ATOM    744  CB  ALA A 110     -53.465   1.399 -17.525  1.00 27.65           C  
ATOM    745  N   ALA A 111     -50.890  -0.572 -17.250  1.00 27.15           N  
ATOM    746  CA  ALA A 111     -49.824  -1.305 -17.929  1.00 35.70           C  
ATOM    747  C   ALA A 111     -49.639  -2.669 -17.279  1.00 42.31           C  
ATOM    748  O   ALA A 111     -48.810  -3.463 -17.723  1.00 46.69           O  
ATOM    749  CB  ALA A 111     -48.519  -0.517 -17.870  1.00 34.91           C  
ATOM    750  N   VAL A 112     -50.423  -2.918 -16.230  1.00 48.30           N  
ATOM    751  CA  VAL A 112     -50.408  -4.170 -15.464  1.00 52.46           C  
ATOM    752  C   VAL A 112     -49.034  -4.729 -15.094  1.00 55.16           C  
ATOM    753  O   VAL A 112     -48.993  -5.578 -14.180  1.00 57.07           O  
ATOM    754  CB  VAL A 112     -51.220  -5.284 -16.180  1.00 48.01           C  
ATOM    755  CG1 VAL A 112     -52.672  -4.862 -16.311  1.00 42.37           C  
ATOM    756  CG2 VAL A 112     -50.629  -5.583 -17.544  1.00 47.62           C  
ATOM    757  OXT VAL A 112     -48.024  -4.330 -15.708  1.00 58.15           O  
TER     758      VAL A 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
