
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  740),  selected   95 , name 2eg1_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2eg1_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_A      A       5          1.201
LGA    K     2_A      N       6          0.518
LGA    K     3_A      K       7          0.252
LGA    I     4_A      L       8          0.653
LGA    E     5_A      V       9          0.923
LGA    A     6_A      I      10          0.836
LGA    I     7_A      V      11          0.420
LGA    I     8_A      T      12          0.547
LGA    K     9_A      E      13          0.571
LGA    P    10_A      K      14          0.781
LGA    F    11_A      V      15          0.556
LGA    K    12_A      L      16          0.702
LGA    L    13_A      L      17          0.781
LGA    D    14_A      K      18          0.670
LGA    E    15_A      K      19          0.688
LGA    V    16_A      V      20          0.783
LGA    K    17_A      A      21          0.686
LGA    D    18_A      K      22          0.940
LGA    A    19_A      I      23          1.566
LGA    L    20_A      I      24          1.517
LGA    V    21_A      E      25          1.163
LGA    E    22_A      E      26          1.298
LGA    I    23_A      A      27          1.534
LGA    G    24_A      G      28          1.068
LGA    I    25_A      A      29          1.300
LGA    G    26_A      T      30          1.690
LGA    G    27_A      G      31          0.767
LGA    M    28_A      Y      32          0.761
LGA    T    29_A      T      33          0.364
LGA    V    30_A      V      34          0.415
LGA    T    31_A      V      35          0.225
LGA    E    32_A      D      36          0.330
LGA    V    33_A      T      37          0.339
LGA    K    34_A      G      38          0.603
LGA    G    35_A      G      39          1.269
LGA    F    36_A      -       -           -
LGA    D    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    L    56_A      -       -           -
LGA    P    57_A      S      58          0.785
LGA    K    58_A      N      59          0.392
LGA    V    59_A      V      60          0.235
LGA    K    60_A      K      61          0.242
LGA    I    61_A      F      62          0.373
LGA    E    62_A      E      63          0.441
LGA    V    63_A      V      64          0.268
LGA    V    64_A      L      65          0.342
LGA    V    65_A      T      66          0.584
LGA    R    66_A      E      67          2.223
LGA    D    67_A      N      68          2.672
LGA    -       -      R      69           -
LGA    E    68_A      E      70          3.267
LGA    D    69_A      M      71          1.854
LGA    V    70_A      A      72          1.815
LGA    E    71_A      E      73          1.221
LGA    K    72_A      K      74          0.821
LGA    V    73_A      I      75          1.700
LGA    V    74_A      A      76          1.214
LGA    E    75_A      D      77          0.937
LGA    T    76_A      Q      78          1.913
LGA    I    77_A      V      79          2.072
LGA    V    78_A      A      80          1.226
LGA    K    79_A      I      81          2.779
LGA    T    80_A      K      82          3.652
LGA    A    81_A      F      83          3.351
LGA    Q    82_A      F      84          2.031
LGA    T    83_A      T      85          4.033
LGA    G    84_A      D      86          2.948
LGA    R    85_A      Y      87          4.909
LGA    V    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    D    88_A      A      88          0.816
LGA    G    89_A      G      89          1.128
LGA    K    90_A      I      90          0.350
LGA    I    91_A      I      91          0.950
LGA    F    92_A      Y      92          1.473
LGA    I    93_A      I      93          0.499
LGA    I    94_A      C      94          0.169
LGA    P    95_A      E      95          0.315
LGA    V    96_A      A      96          0.877
LGA    E    97_A      E      97          1.848
LGA    D    98_A      V      98          2.014
LGA    V    99_A      L      99          4.138
LGA    I   100_A      Y     100          1.155
LGA    R   101_A      G     101          1.366
LGA    I   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    R   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    Q   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    I   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   83    5.0     78    1.59    26.92     87.497     4.621

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.719442 * X  +  -0.105911 * Y  +  -0.686429 * Z  + -37.893150
  Y_new =   0.693826 * X  +  -0.064411 * Y  +  -0.717256 * Z  +  16.371960
  Z_new =   0.031752 * X  +  -0.992287 * Y  +   0.119824 * Z  +  -2.153597 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.450623    1.690970  [ DEG:   -83.1146     96.8854 ]
  Theta =  -0.031757   -3.109835  [ DEG:    -1.8196   -178.1804 ]
  Phi   =   2.374318   -0.767274  [ DEG:   136.0384    -43.9616 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eg1_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eg1_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   83   5.0   78   1.59   26.92  87.497
REMARK  ---------------------------------------------------------- 
MOLECULE 2eg1_A
HEADER    SIGNALING PROTEIN                       27-FEB-07   2EG1              
TITLE     THE CRYSTAL STRUCTURE OF PII PROTEIN                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITROGEN REGULATORY PROTEIN P-II;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GLNB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS(DE3)-RIL;                   
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-21A                                   
KEYWDS    NITROGEN REGULATORY PROTEIN, STRUCTURAL GENOMICS, NPPSFA,             
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI, SIGNALING PROTEIN                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.SAKAI,A.SHINKAI,Y.KITAMURA,S.KURAMITSU,S.YOKOYAMA,RIKEN             
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   04-MAR-08 2EG1    0                                                
JRNL        AUTH   H.SAKAI,A.SHINKAI,Y.KITAMURA,S.KURAMITSU,S.YOKOYAMA          
JRNL        TITL   THE CRYSTAL STRUCTURE OF PII PROTEIN                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2EG1 A    1   112  UNP    O66513   GLNB_AQUAE       1    112             
SEQRES   1 A  112  MET LYS LYS ILE GLU ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 A  112  ASP GLU VAL LYS ASP ALA LEU VAL GLU ILE GLY ILE GLY          
SEQRES   3 A  112  GLY MET THR VAL THR GLU VAL LYS GLY PHE GLY GLN GLN          
SEQRES   4 A  112  LYS GLY HIS THR GLU ILE TYR ARG GLY THR GLU TYR VAL          
SEQRES   5 A  112  ILE ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 A  112  ARG ASP GLU ASP VAL GLU LYS VAL VAL GLU THR ILE VAL          
SEQRES   7 A  112  LYS THR ALA GLN THR GLY ARG VAL GLY ASP GLY LYS ILE          
SEQRES   8 A  112  PHE ILE ILE PRO VAL GLU ASP VAL ILE ARG ILE ARG THR          
SEQRES   9 A  112  GLY GLU ARG GLY GLU GLN ALA ILE                              
HET    SO4  A 501       5                                                       
HET    SO4  A 502       5                                                       
HET     CL  A 601       1                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      CL CHLORIDE ION                                                     
FORMUL   2  SO4    2(O4 S 2-)                                                   
FORMUL   4   CL    CL 1-                                                        
FORMUL   5  HOH   *82(H2 O)                                                     
CRYST1   81.041   81.041   81.041  90.10  90.10  90.10 I 2 3        24          
ATOM      1  N   MET A   1     -46.074   5.669 -10.297  1.00 18.19           N  
ATOM      2  CA  MET A   1     -47.183   5.635 -11.311  1.00 20.89           C  
ATOM      3  C   MET A   1     -47.543   7.059 -11.741  1.00 18.90           C  
ATOM      4  O   MET A   1     -47.359   8.009 -10.974  1.00 18.18           O  
ATOM      5  CB  MET A   1     -48.414   4.961 -10.691  1.00 25.44           C  
ATOM      6  CG  MET A   1     -48.180   3.484 -10.368  1.00 35.95           C  
ATOM      7  SD  MET A   1     -49.445   2.789  -9.296  1.00 45.83           S  
ATOM      8  CE  MET A   1     -48.949   3.436  -7.676  1.00 44.93           C  
ATOM      9  N   LYS A   2     -48.050   7.206 -12.962  1.00 16.33           N  
ATOM     10  CA  LYS A   2     -48.438   8.532 -13.454  1.00 15.81           C  
ATOM     11  C   LYS A   2     -49.790   8.470 -14.157  1.00 16.86           C  
ATOM     12  O   LYS A   2     -50.120   7.483 -14.815  1.00 15.88           O  
ATOM     13  CB  LYS A   2     -47.438   9.086 -14.485  1.00 15.71           C  
ATOM     14  CG  LYS A   2     -45.970   9.130 -14.044  1.00 20.14           C  
ATOM     15  CD  LYS A   2     -45.713  10.130 -12.928  1.00 21.74           C  
ATOM     16  CE  LYS A   2     -44.277   9.937 -12.375  1.00 22.83           C  
ATOM     17  NZ  LYS A   2     -44.003  10.807 -11.201  1.00 24.10           N  
ATOM     18  N   LYS A   3     -50.549   9.552 -14.036  1.00 15.91           N  
ATOM     19  CA  LYS A   3     -51.815   9.655 -14.747  1.00 15.00           C  
ATOM     20  C   LYS A   3     -51.458  10.347 -16.054  1.00 15.06           C  
ATOM     21  O   LYS A   3     -50.658  11.296 -16.073  1.00 14.52           O  
ATOM     22  CB  LYS A   3     -52.817  10.522 -13.956  1.00 14.84           C  
ATOM     23  CG  LYS A   3     -54.005  11.063 -14.796  1.00 15.73           C  
ATOM     24  CD  LYS A   3     -55.003  11.827 -13.901  1.00 13.39           C  
ATOM     25  CE  LYS A   3     -56.085  12.513 -14.737  1.00 15.41           C  
ATOM     26  NZ  LYS A   3     -57.180  13.163 -13.910  1.00 13.57           N  
ATOM     27  N   ILE A   4     -51.999   9.843 -17.154  1.00 13.99           N  
ATOM     28  CA  ILE A   4     -51.770  10.456 -18.450  1.00 13.60           C  
ATOM     29  C   ILE A   4     -53.157  10.908 -18.908  1.00 14.99           C  
ATOM     30  O   ILE A   4     -54.055  10.078 -19.060  1.00 14.79           O  
ATOM     31  CB  ILE A   4     -51.168   9.448 -19.434  1.00 14.75           C  
ATOM     32  CG1 ILE A   4     -49.794   8.994 -18.907  1.00 14.71           C  
ATOM     33  CG2 ILE A   4     -51.015  10.106 -20.819  1.00 14.60           C  
ATOM     34  CD1 ILE A   4     -49.118   7.909 -19.747  1.00 17.25           C  
ATOM     35  N   GLU A   5     -53.317  12.217 -19.100  1.00 11.24           N  
ATOM     36  CA  GLU A   5     -54.607  12.804 -19.510  1.00 13.74           C  
ATOM     37  C   GLU A   5     -54.394  13.375 -20.900  1.00 13.41           C  
ATOM     38  O   GLU A   5     -53.638  14.340 -21.071  1.00 14.63           O  
ATOM     39  CB  GLU A   5     -55.013  13.926 -18.536  1.00 15.59           C  
ATOM     40  CG  GLU A   5     -56.314  14.665 -18.927  1.00 14.58           C  
ATOM     41  CD  GLU A   5     -56.700  15.792 -17.963  1.00 17.67           C  
ATOM     42  OE1 GLU A   5     -56.072  15.936 -16.895  1.00 14.66           O  
ATOM     43  OE2 GLU A   5     -57.651  16.545 -18.281  1.00 17.08           O  
ATOM     44  N   ALA A   6     -55.055  12.784 -21.891  1.00 13.05           N  
ATOM     45  CA  ALA A   6     -54.898  13.228 -23.269  1.00 14.42           C  
ATOM     46  C   ALA A   6     -56.231  13.758 -23.779  1.00 16.50           C  
ATOM     47  O   ALA A   6     -57.265  13.141 -23.540  1.00 14.65           O  
ATOM     48  CB  ALA A   6     -54.428  12.052 -24.148  1.00 16.95           C  
ATOM     49  N   ILE A   7     -56.197  14.908 -24.444  1.00 14.43           N  
ATOM     50  CA  ILE A   7     -57.417  15.505 -25.008  1.00 13.71           C  
ATOM     51  C   ILE A   7     -57.210  15.417 -26.522  1.00 15.79           C  
ATOM     52  O   ILE A   7     -56.284  16.037 -27.055  1.00 16.41           O  
ATOM     53  CB  ILE A   7     -57.556  16.983 -24.587  1.00 14.78           C  
ATOM     54  CG1 ILE A   7     -57.412  17.121 -23.061  1.00 18.68           C  
ATOM     55  CG2 ILE A   7     -58.912  17.541 -25.076  1.00 16.47           C  
ATOM     56  CD1 ILE A   7     -58.395  16.279 -22.259  1.00 18.95           C  
ATOM     57  N   ILE A   8     -58.070  14.671 -27.216  1.00 15.73           N  
ATOM     58  CA  ILE A   8     -57.893  14.468 -28.655  1.00 16.30           C  
ATOM     59  C   ILE A   8     -59.146  14.771 -29.469  1.00 15.30           C  
ATOM     60  O   ILE A   8     -60.224  14.955 -28.918  1.00 14.53           O  
ATOM     61  CB  ILE A   8     -57.517  12.999 -28.931  1.00 16.78           C  
ATOM     62  CG1 ILE A   8     -58.687  12.083 -28.523  1.00 13.86           C  
ATOM     63  CG2 ILE A   8     -56.257  12.634 -28.140  1.00 17.16           C  
ATOM     64  CD1 ILE A   8     -58.467  10.579 -28.843  1.00 17.36           C  
ATOM     65  N   LYS A   9     -58.987  14.809 -30.790  1.00 16.51           N  
ATOM     66  CA  LYS A   9     -60.126  15.031 -31.671  1.00 17.08           C  
ATOM     67  C   LYS A   9     -60.995  13.772 -31.621  1.00 13.64           C  
ATOM     68  O   LYS A   9     -60.508  12.655 -31.606  1.00 16.29           O  
ATOM     69  CB  LYS A   9     -59.637  15.335 -33.094  1.00 19.00           C  
ATOM     70  CG  LYS A   9     -58.983  16.715 -33.189  1.00 21.70           C  
ATOM     71  CD  LYS A   9     -58.329  16.999 -34.549  1.00 24.50           C  
ATOM     72  CE  LYS A   9     -58.004  18.499 -34.658  1.00 26.53           C  
ATOM     73  NZ  LYS A   9     -56.970  18.800 -35.703  1.00 29.89           N  
ATOM     74  N   PRO A  10     -62.320  13.947 -31.583  1.00 17.05           N  
ATOM     75  CA  PRO A  10     -63.281  12.841 -31.510  1.00 18.32           C  
ATOM     76  C   PRO A  10     -63.087  11.695 -32.491  1.00 19.41           C  
ATOM     77  O   PRO A  10     -63.136  10.530 -32.102  1.00 18.09           O  
ATOM     78  CB  PRO A  10     -64.630  13.536 -31.713  1.00 19.41           C  
ATOM     79  CG  PRO A  10     -64.382  14.899 -31.156  1.00 20.66           C  
ATOM     80  CD  PRO A  10     -63.013  15.242 -31.684  1.00 18.40           C  
ATOM     81  N   PHE A  11     -62.844  12.019 -33.753  1.00 20.75           N  
ATOM     82  CA  PHE A  11     -62.710  10.958 -34.747  1.00 23.59           C  
ATOM     83  C   PHE A  11     -61.463  10.092 -34.571  1.00 24.31           C  
ATOM     84  O   PHE A  11     -61.348   9.040 -35.200  1.00 25.19           O  
ATOM     85  CB  PHE A  11     -62.759  11.529 -36.169  1.00 25.90           C  
ATOM     86  CG  PHE A  11     -61.546  12.344 -36.558  1.00 27.81           C  
ATOM     87  CD1 PHE A  11     -61.511  13.714 -36.345  1.00 29.30           C  
ATOM     88  CD2 PHE A  11     -60.462  11.740 -37.183  1.00 30.59           C  
ATOM     89  CE1 PHE A  11     -60.414  14.470 -36.753  1.00 29.66           C  
ATOM     90  CE2 PHE A  11     -59.361  12.492 -37.590  1.00 29.46           C  
ATOM     91  CZ  PHE A  11     -59.344  13.858 -37.371  1.00 27.54           C  
ATOM     92  N   LYS A  12     -60.535  10.529 -33.722  1.00 21.60           N  
ATOM     93  CA  LYS A  12     -59.319   9.759 -33.461  1.00 21.10           C  
ATOM     94  C   LYS A  12     -59.480   8.746 -32.311  1.00 21.40           C  
ATOM     95  O   LYS A  12     -58.580   7.941 -32.065  1.00 19.28           O  
ATOM     96  CB  LYS A  12     -58.151  10.697 -33.122  1.00 22.78           C  
ATOM     97  CG  LYS A  12     -57.544  11.435 -34.317  1.00 19.83           C  
ATOM     98  CD  LYS A  12     -56.917  10.422 -35.265  1.00 26.50           C  
ATOM     99  CE  LYS A  12     -55.920  11.071 -36.217  1.00 27.74           C  
ATOM    100  NZ  LYS A  12     -55.161  10.019 -36.969  1.00 28.69           N  
ATOM    101  N   LEU A  13     -60.618   8.760 -31.620  1.00 18.26           N  
ATOM    102  CA  LEU A  13     -60.815   7.859 -30.482  1.00 17.02           C  
ATOM    103  C   LEU A  13     -60.616   6.365 -30.757  1.00 19.75           C  
ATOM    104  O   LEU A  13     -59.891   5.687 -30.027  1.00 19.20           O  
ATOM    105  CB  LEU A  13     -62.195   8.080 -29.857  1.00 20.56           C  
ATOM    106  CG  LEU A  13     -62.568   7.117 -28.723  1.00 21.65           C  
ATOM    107  CD1 LEU A  13     -61.525   7.199 -27.607  1.00 21.66           C  
ATOM    108  CD2 LEU A  13     -63.976   7.459 -28.191  1.00 23.62           C  
ATOM    109  N   ASP A  14     -61.249   5.839 -31.801  1.00 22.57           N  
ATOM    110  CA  ASP A  14     -61.086   4.417 -32.103  1.00 24.17           C  
ATOM    111  C   ASP A  14     -59.619   4.068 -32.356  1.00 21.63           C  
ATOM    112  O   ASP A  14     -59.113   3.089 -31.816  1.00 22.86           O  
ATOM    113  CB  ASP A  14     -61.903   4.013 -33.326  1.00 28.31           C  
ATOM    114  CG  ASP A  14     -63.389   4.055 -33.075  1.00 35.51           C  
ATOM    115  OD1 ASP A  14     -63.812   3.875 -31.914  1.00 35.93           O  
ATOM    116  OD2 ASP A  14     -64.134   4.246 -34.058  1.00 40.82           O  
ATOM    117  N   GLU A  15     -58.950   4.866 -33.180  1.00 20.97           N  
ATOM    118  CA  GLU A  15     -57.537   4.628 -33.501  1.00 24.43           C  
ATOM    119  C   GLU A  15     -56.644   4.670 -32.269  1.00 23.24           C  
ATOM    120  O   GLU A  15     -55.787   3.802 -32.085  1.00 19.72           O  
ATOM    121  CB  GLU A  15     -57.016   5.664 -34.489  1.00 27.40           C  
ATOM    122  CG  GLU A  15     -57.519   5.536 -35.898  1.00 37.43           C  
ATOM    123  CD  GLU A  15     -57.065   6.706 -36.746  1.00 39.75           C  
ATOM    124  OE1 GLU A  15     -55.846   7.002 -36.745  1.00 41.02           O  
ATOM    125  OE2 GLU A  15     -57.926   7.332 -37.401  1.00 43.44           O  
ATOM    126  N   VAL A  16     -56.838   5.687 -31.431  1.00 19.47           N  
ATOM    127  CA  VAL A  16     -56.019   5.809 -30.227  1.00 20.05           C  
ATOM    128  C   VAL A  16     -56.308   4.695 -29.229  1.00 19.36           C  
ATOM    129  O   VAL A  16     -55.386   4.162 -28.620  1.00 18.95           O  
ATOM    130  CB  VAL A  16     -56.211   7.188 -29.544  1.00 18.31           C  
ATOM    131  CG1 VAL A  16     -55.468   7.218 -28.217  1.00 20.61           C  
ATOM    132  CG2 VAL A  16     -55.690   8.286 -30.459  1.00 21.79           C  
ATOM    133  N   LYS A  17     -57.584   4.351 -29.053  1.00 16.95           N  
ATOM    134  CA  LYS A  17     -57.982   3.283 -28.147  1.00 19.36           C  
ATOM    135  C   LYS A  17     -57.321   1.968 -28.591  1.00 18.86           C  
ATOM    136  O   LYS A  17     -56.753   1.247 -27.777  1.00 18.34           O  
ATOM    137  CB  LYS A  17     -59.505   3.095 -28.167  1.00 19.82           C  
ATOM    138  CG  LYS A  17     -59.992   1.995 -27.248  1.00 28.92           C  
ATOM    139  CD  LYS A  17     -60.872   0.990 -27.989  1.00 37.63           C  
ATOM    140  CE  LYS A  17     -62.152   1.619 -28.523  1.00 41.81           C  
ATOM    141  NZ  LYS A  17     -63.005   0.627 -29.277  1.00 43.35           N  
ATOM    142  N   ASP A  18     -57.398   1.671 -29.886  1.00 20.24           N  
ATOM    143  CA  ASP A  18     -56.799   0.433 -30.410  1.00 23.28           C  
ATOM    144  C   ASP A  18     -55.280   0.397 -30.226  1.00 22.13           C  
ATOM    145  O   ASP A  18     -54.704  -0.633 -29.867  1.00 23.58           O  
ATOM    146  CB  ASP A  18     -57.132   0.272 -31.888  1.00 23.99           C  
ATOM    147  CG  ASP A  18     -58.593  -0.067 -32.123  1.00 30.54           C  
ATOM    148  OD1 ASP A  18     -59.248  -0.565 -31.179  1.00 31.18           O  
ATOM    149  OD2 ASP A  18     -59.078   0.152 -33.255  1.00 29.85           O  
ATOM    150  N   ALA A  19     -54.635   1.523 -30.477  1.00 21.41           N  
ATOM    151  CA  ALA A  19     -53.180   1.620 -30.332  1.00 22.67           C  
ATOM    152  C   ALA A  19     -52.748   1.381 -28.877  1.00 23.41           C  
ATOM    153  O   ALA A  19     -51.741   0.700 -28.608  1.00 21.28           O  
ATOM    154  CB  ALA A  19     -52.715   3.001 -30.796  1.00 23.32           C  
ATOM    155  N   LEU A  20     -53.505   1.943 -27.933  1.00 20.33           N  
ATOM    156  CA  LEU A  20     -53.182   1.793 -26.528  1.00 20.49           C  
ATOM    157  C   LEU A  20     -53.365   0.340 -26.109  1.00 22.68           C  
ATOM    158  O   LEU A  20     -52.540  -0.209 -25.368  1.00 24.07           O  
ATOM    159  CB  LEU A  20     -54.044   2.739 -25.665  1.00 20.14           C  
ATOM    160  CG  LEU A  20     -53.706   4.235 -25.816  1.00 20.81           C  
ATOM    161  CD1 LEU A  20     -54.692   5.100 -25.018  1.00 22.98           C  
ATOM    162  CD2 LEU A  20     -52.277   4.494 -25.308  1.00 23.59           C  
ATOM    163  N   VAL A  21     -54.428  -0.293 -26.595  1.00 22.43           N  
ATOM    164  CA  VAL A  21     -54.663  -1.690 -26.267  1.00 24.40           C  
ATOM    165  C   VAL A  21     -53.488  -2.490 -26.837  1.00 24.20           C  
ATOM    166  O   VAL A  21     -52.993  -3.418 -26.192  1.00 26.85           O  
ATOM    167  CB  VAL A  21     -55.993  -2.208 -26.892  1.00 27.23           C  
ATOM    168  CG1 VAL A  21     -56.077  -3.725 -26.756  1.00 27.47           C  
ATOM    169  CG2 VAL A  21     -57.192  -1.562 -26.178  1.00 24.13           C  
ATOM    170  N   GLU A  22     -53.051  -2.118 -28.039  1.00 23.96           N  
ATOM    171  CA  GLU A  22     -51.929  -2.792 -28.710  1.00 27.40           C  
ATOM    172  C   GLU A  22     -50.651  -2.767 -27.882  1.00 26.39           C  
ATOM    173  O   GLU A  22     -49.911  -3.761 -27.843  1.00 23.59           O  
ATOM    174  CB  GLU A  22     -51.599  -2.137 -30.042  1.00 31.53           C  
ATOM    175  CG  GLU A  22     -52.506  -2.445 -31.193  1.00 39.41           C  
ATOM    176  CD  GLU A  22     -51.862  -2.053 -32.499  1.00 45.02           C  
ATOM    177  OE1 GLU A  22     -51.342  -0.918 -32.585  1.00 46.10           O  
ATOM    178  OE2 GLU A  22     -51.871  -2.876 -33.442  1.00 51.26           O  
ATOM    179  N   ILE A  23     -50.360  -1.623 -27.257  1.00 23.04           N  
ATOM    180  CA  ILE A  23     -49.159  -1.527 -26.440  1.00 21.89           C  
ATOM    181  C   ILE A  23     -49.351  -2.022 -25.008  1.00 22.95           C  
ATOM    182  O   ILE A  23     -48.493  -1.838 -24.145  1.00 25.01           O  
ATOM    183  CB  ILE A  23     -48.553  -0.099 -26.449  1.00 22.80           C  
ATOM    184  CG1 ILE A  23     -49.539   0.925 -25.878  1.00 20.62           C  
ATOM    185  CG2 ILE A  23     -48.139   0.260 -27.863  1.00 21.96           C  
ATOM    186  CD1 ILE A  23     -48.883   2.278 -25.644  1.00 24.97           C  
ATOM    187  N   GLY A  24     -50.482  -2.665 -24.758  1.00 23.98           N  
ATOM    188  CA  GLY A  24     -50.709  -3.252 -23.446  1.00 26.16           C  
ATOM    189  C   GLY A  24     -51.477  -2.526 -22.366  1.00 26.79           C  
ATOM    190  O   GLY A  24     -51.491  -2.989 -21.227  1.00 23.87           O  
ATOM    191  N   ILE A  25     -52.108  -1.405 -22.699  1.00 25.97           N  
ATOM    192  CA  ILE A  25     -52.889  -0.657 -21.706  1.00 29.26           C  
ATOM    193  C   ILE A  25     -54.100  -1.486 -21.287  1.00 30.99           C  
ATOM    194  O   ILE A  25     -54.907  -1.872 -22.132  1.00 33.35           O  
ATOM    195  CB  ILE A  25     -53.371   0.684 -22.290  1.00 31.03           C  
ATOM    196  CG1 ILE A  25     -52.200   1.662 -22.340  1.00 32.51           C  
ATOM    197  CG2 ILE A  25     -54.516   1.251 -21.453  1.00 32.53           C  
ATOM    198  CD1 ILE A  25     -51.701   2.109 -20.974  1.00 32.94           C  
ATOM    199  N   GLY A  26     -54.224  -1.740 -19.986  1.00 31.51           N  
ATOM    200  CA  GLY A  26     -55.314  -2.558 -19.476  1.00 33.28           C  
ATOM    201  C   GLY A  26     -56.669  -1.895 -19.287  1.00 35.94           C  
ATOM    202  O   GLY A  26     -57.706  -2.566 -19.381  1.00 37.60           O  
ATOM    203  N   GLY A  27     -56.681  -0.592 -19.014  1.00 32.58           N  
ATOM    204  CA  GLY A  27     -57.949   0.087 -18.823  1.00 30.34           C  
ATOM    205  C   GLY A  27     -57.823   1.564 -19.127  1.00 29.20           C  
ATOM    206  O   GLY A  27     -56.723   2.127 -19.055  1.00 25.31           O  
ATOM    207  N   MET A  28     -58.934   2.187 -19.503  1.00 22.25           N  
ATOM    208  CA  MET A  28     -58.913   3.616 -19.780  1.00 20.11           C  
ATOM    209  C   MET A  28     -60.278   4.226 -19.506  1.00 18.01           C  
ATOM    210  O   MET A  28     -61.302   3.546 -19.598  1.00 19.52           O  
ATOM    211  CB  MET A  28     -58.492   3.898 -21.219  1.00 26.05           C  
ATOM    212  CG  MET A  28     -59.403   3.358 -22.285  1.00 29.82           C  
ATOM    213  SD  MET A  28     -58.744   3.738 -23.926  1.00 32.19           S  
ATOM    214  CE  MET A  28     -57.370   2.609 -23.971  1.00 30.04           C  
ATOM    215  N   THR A  29     -60.278   5.513 -19.182  1.00 16.81           N  
ATOM    216  CA  THR A  29     -61.509   6.249 -18.879  1.00 13.65           C  
ATOM    217  C   THR A  29     -61.626   7.348 -19.929  1.00 16.04           C  
ATOM    218  O   THR A  29     -60.691   8.143 -20.125  1.00 15.64           O  
ATOM    219  CB  THR A  29     -61.422   6.859 -17.475  1.00 16.95           C  
ATOM    220  OG1 THR A  29     -61.214   5.804 -16.528  1.00 18.28           O  
ATOM    221  CG2 THR A  29     -62.704   7.593 -17.110  1.00 17.84           C  
ATOM    222  N   VAL A  30     -62.787   7.404 -20.574  1.00 14.30           N  
ATOM    223  CA  VAL A  30     -63.033   8.340 -21.662  1.00 12.31           C  
ATOM    224  C   VAL A  30     -64.175   9.276 -21.316  1.00 12.26           C  
ATOM    225  O   VAL A  30     -65.198   8.832 -20.804  1.00 15.30           O  
ATOM    226  CB  VAL A  30     -63.397   7.524 -22.931  1.00 17.93           C  
ATOM    227  CG1 VAL A  30     -63.773   8.442 -24.075  1.00 20.12           C  
ATOM    228  CG2 VAL A  30     -62.210   6.623 -23.300  1.00 21.98           C  
ATOM    229  N   THR A  31     -63.999  10.564 -21.594  1.00 12.73           N  
ATOM    230  CA  THR A  31     -65.022  11.555 -21.298  1.00 13.53           C  
ATOM    231  C   THR A  31     -65.231  12.462 -22.511  1.00 13.39           C  
ATOM    232  O   THR A  31     -64.275  12.821 -23.207  1.00 14.01           O  
ATOM    233  CB  THR A  31     -64.607  12.489 -20.104  1.00 14.21           C  
ATOM    234  OG1 THR A  31     -64.136  11.701 -19.003  1.00 15.20           O  
ATOM    235  CG2 THR A  31     -65.802  13.322 -19.625  1.00 14.13           C  
ATOM    236  N   GLU A  32     -66.485  12.801 -22.782  1.00 11.82           N  
ATOM    237  CA  GLU A  32     -66.791  13.733 -23.871  1.00 14.96           C  
ATOM    238  C   GLU A  32     -66.588  15.115 -23.263  1.00 14.39           C  
ATOM    239  O   GLU A  32     -67.142  15.421 -22.201  1.00 14.08           O  
ATOM    240  CB  GLU A  32     -68.253  13.561 -24.336  1.00 18.84           C  
ATOM    241  CG  GLU A  32     -68.435  12.265 -25.107  1.00 22.88           C  
ATOM    242  CD  GLU A  32     -69.891  11.954 -25.440  1.00 30.66           C  
ATOM    243  OE1 GLU A  32     -70.761  12.832 -25.256  1.00 34.53           O  
ATOM    244  OE2 GLU A  32     -70.151  10.823 -25.896  1.00 34.60           O  
ATOM    245  N   VAL A  33     -65.786  15.943 -23.921  1.00 12.90           N  
ATOM    246  CA  VAL A  33     -65.484  17.280 -23.401  1.00 13.48           C  
ATOM    247  C   VAL A  33     -65.511  18.268 -24.570  1.00 15.74           C  
ATOM    248  O   VAL A  33     -65.865  17.891 -25.695  1.00 13.93           O  
ATOM    249  CB  VAL A  33     -64.062  17.303 -22.700  1.00 13.48           C  
ATOM    250  CG1 VAL A  33     -63.985  16.223 -21.601  1.00 13.79           C  
ATOM    251  CG2 VAL A  33     -62.948  17.057 -23.735  1.00 17.67           C  
ATOM    252  N   LYS A  34     -65.181  19.529 -24.307  1.00 15.98           N  
ATOM    253  CA  LYS A  34     -65.132  20.533 -25.366  1.00 18.55           C  
ATOM    254  C   LYS A  34     -63.873  21.344 -25.128  1.00 20.09           C  
ATOM    255  O   LYS A  34     -63.376  21.431 -23.998  1.00 19.11           O  
ATOM    256  CB  LYS A  34     -66.345  21.473 -25.308  1.00 20.93           C  
ATOM    257  CG  LYS A  34     -67.692  20.794 -25.373  1.00 32.22           C  
ATOM    258  CD  LYS A  34     -68.823  21.821 -25.235  1.00 35.47           C  
ATOM    259  CE  LYS A  34     -68.656  22.672 -23.976  1.00 42.72           C  
ATOM    260  NZ  LYS A  34     -69.779  23.635 -23.733  1.00 46.28           N  
ATOM    261  N   GLY A  35     -63.334  21.942 -26.177  1.00 18.59           N  
ATOM    262  CA  GLY A  35     -62.143  22.746 -25.960  1.00 23.88           C  
ATOM    263  C   GLY A  35     -61.780  23.632 -27.126  1.00 31.30           C  
ATOM    264  O   GLY A  35     -62.569  23.796 -28.053  1.00 28.49           O  
ATOM    265  N   PHE A  36     -60.588  24.221 -27.044  1.00 34.95           N  
ATOM    266  CA  PHE A  36     -60.034  25.086 -28.079  1.00 40.67           C  
ATOM    267  C   PHE A  36     -58.562  25.340 -27.760  1.00 43.60           C  
ATOM    268  O   PHE A  36     -57.827  25.929 -28.558  1.00 47.69           O  
ATOM    269  CB  PHE A  36     -60.802  26.412 -28.165  1.00 42.58           C  
ATOM    270  CG  PHE A  36     -60.590  27.332 -26.992  1.00 42.89           C  
ATOM    271  CD1 PHE A  36     -59.386  28.020 -26.829  1.00 43.88           C  
ATOM    272  CD2 PHE A  36     -61.608  27.545 -26.073  1.00 44.03           C  
ATOM    273  CE1 PHE A  36     -59.200  28.905 -25.766  1.00 43.98           C  
ATOM    274  CE2 PHE A  36     -61.436  28.431 -25.003  1.00 46.35           C  
ATOM    275  CZ  PHE A  36     -60.229  29.113 -24.852  1.00 45.45           C  
ATOM    276  N   ASP A  54     -64.972  29.762 -29.541  1.00 43.27           N  
ATOM    277  CA  ASP A  54     -65.745  28.581 -29.924  1.00 43.65           C  
ATOM    278  C   ASP A  54     -65.242  27.292 -29.272  1.00 40.52           C  
ATOM    279  O   ASP A  54     -64.050  26.982 -29.322  1.00 41.45           O  
ATOM    280  CB  ASP A  54     -65.728  28.390 -31.450  1.00 46.99           C  
ATOM    281  CG  ASP A  54     -66.759  29.252 -32.170  1.00 51.53           C  
ATOM    282  OD1 ASP A  54     -67.932  29.272 -31.736  1.00 53.69           O  
ATOM    283  OD2 ASP A  54     -66.399  29.898 -33.183  1.00 53.23           O  
ATOM    284  N   PHE A  55     -66.160  26.544 -28.666  1.00 37.06           N  
ATOM    285  CA  PHE A  55     -65.826  25.272 -28.039  1.00 33.51           C  
ATOM    286  C   PHE A  55     -66.134  24.138 -29.014  1.00 30.34           C  
ATOM    287  O   PHE A  55     -67.268  23.977 -29.452  1.00 33.33           O  
ATOM    288  CB  PHE A  55     -66.637  25.058 -26.756  1.00 34.89           C  
ATOM    289  CG  PHE A  55     -66.142  25.850 -25.586  1.00 33.04           C  
ATOM    290  CD1 PHE A  55     -67.008  26.689 -24.880  1.00 33.55           C  
ATOM    291  CD2 PHE A  55     -64.815  25.760 -25.184  1.00 30.79           C  
ATOM    292  CE1 PHE A  55     -66.553  27.428 -23.797  1.00 31.49           C  
ATOM    293  CE2 PHE A  55     -64.349  26.497 -24.098  1.00 33.22           C  
ATOM    294  CZ  PHE A  55     -65.221  27.332 -23.405  1.00 31.61           C  
ATOM    295  N   LEU A  56     -65.117  23.363 -29.352  1.00 24.61           N  
ATOM    296  CA  LEU A  56     -65.287  22.237 -30.262  1.00 21.35           C  
ATOM    297  C   LEU A  56     -65.282  20.941 -29.441  1.00 19.41           C  
ATOM    298  O   LEU A  56     -64.639  20.861 -28.383  1.00 18.36           O  
ATOM    299  CB  LEU A  56     -64.142  22.228 -31.273  1.00 23.72           C  
ATOM    300  CG  LEU A  56     -64.099  23.466 -32.190  1.00 27.26           C  
ATOM    301  CD1 LEU A  56     -62.845  23.451 -33.054  1.00 29.22           C  
ATOM    302  CD2 LEU A  56     -65.341  23.477 -33.077  1.00 30.22           C  
ATOM    303  N   PRO A  57     -66.017  19.922 -29.892  1.00 17.15           N  
ATOM    304  CA  PRO A  57     -66.048  18.652 -29.158  1.00 14.24           C  
ATOM    305  C   PRO A  57     -64.681  17.971 -29.220  1.00 14.89           C  
ATOM    306  O   PRO A  57     -64.025  17.964 -30.258  1.00 15.40           O  
ATOM    307  CB  PRO A  57     -67.122  17.849 -29.895  1.00 18.46           C  
ATOM    308  CG  PRO A  57     -66.983  18.370 -31.323  1.00 19.86           C  
ATOM    309  CD  PRO A  57     -66.888  19.864 -31.081  1.00 19.00           C  
ATOM    310  N   LYS A  58     -64.249  17.432 -28.082  1.00 16.22           N  
ATOM    311  CA  LYS A  58     -62.991  16.713 -27.987  1.00 15.53           C  
ATOM    312  C   LYS A  58     -63.283  15.488 -27.124  1.00 16.68           C  
ATOM    313  O   LYS A  58     -64.387  15.331 -26.595  1.00 13.87           O  
ATOM    314  CB  LYS A  58     -61.943  17.561 -27.277  1.00 19.22           C  
ATOM    315  CG  LYS A  58     -61.746  18.945 -27.864  1.00 23.74           C  
ATOM    316  CD  LYS A  58     -60.958  18.906 -29.143  1.00 23.84           C  
ATOM    317  CE  LYS A  58     -60.575  20.331 -29.525  1.00 31.17           C  
ATOM    318  NZ  LYS A  58     -59.691  20.408 -30.702  1.00 29.72           N  
ATOM    319  N   VAL A  59     -62.299  14.609 -26.989  1.00 13.92           N  
ATOM    320  CA  VAL A  59     -62.490  13.451 -26.140  1.00 13.46           C  
ATOM    321  C   VAL A  59     -61.280  13.367 -25.237  1.00 15.20           C  
ATOM    322  O   VAL A  59     -60.132  13.510 -25.696  1.00 13.76           O  
ATOM    323  CB  VAL A  59     -62.592  12.121 -26.937  1.00 18.29           C  
ATOM    324  CG1 VAL A  59     -62.540  10.948 -25.970  1.00 20.67           C  
ATOM    325  CG2 VAL A  59     -63.901  12.081 -27.756  1.00 16.42           C  
ATOM    326  N   LYS A  60     -61.544  13.156 -23.954  1.00 13.20           N  
ATOM    327  CA  LYS A  60     -60.467  12.999 -22.978  1.00 11.84           C  
ATOM    328  C   LYS A  60     -60.265  11.521 -22.725  1.00 14.73           C  
ATOM    329  O   LYS A  60     -61.240  10.772 -22.555  1.00 11.95           O  
ATOM    330  CB  LYS A  60     -60.820  13.674 -21.638  1.00 14.41           C  
ATOM    331  CG  LYS A  60     -59.801  13.333 -20.522  1.00 12.90           C  
ATOM    332  CD  LYS A  60     -60.235  13.848 -19.132  1.00 15.28           C  
ATOM    333  CE  LYS A  60     -60.290  15.367 -19.091  1.00 14.20           C  
ATOM    334  NZ  LYS A  60     -60.470  15.830 -17.677  1.00 13.80           N  
ATOM    335  N   ILE A  61     -59.003  11.099 -22.718  1.00 13.06           N  
ATOM    336  CA  ILE A  61     -58.657   9.723 -22.410  1.00 13.87           C  
ATOM    337  C   ILE A  61     -57.720   9.794 -21.205  1.00 14.49           C  
ATOM    338  O   ILE A  61     -56.766  10.591 -21.185  1.00 15.59           O  
ATOM    339  CB  ILE A  61     -57.888   9.032 -23.550  1.00 17.35           C  
ATOM    340  CG1 ILE A  61     -58.782   8.877 -24.783  1.00 19.17           C  
ATOM    341  CG2 ILE A  61     -57.379   7.658 -23.069  1.00 19.24           C  
ATOM    342  CD1 ILE A  61     -58.018   8.433 -26.030  1.00 23.85           C  
ATOM    343  N   GLU A  62     -58.003   8.984 -20.198  1.00 13.55           N  
ATOM    344  CA  GLU A  62     -57.140   8.923 -19.016  1.00 12.47           C  
ATOM    345  C   GLU A  62     -56.696   7.487 -18.799  1.00 14.78           C  
ATOM    346  O   GLU A  62     -57.506   6.553 -18.864  1.00 14.63           O  
ATOM    347  CB  GLU A  62     -57.879   9.343 -17.739  1.00 12.50           C  
ATOM    348  CG  GLU A  62     -58.260  10.791 -17.632  1.00 13.02           C  
ATOM    349  CD  GLU A  62     -59.184  10.965 -16.466  1.00 13.99           C  
ATOM    350  OE1 GLU A  62     -60.418  10.976 -16.684  1.00 13.83           O  
ATOM    351  OE2 GLU A  62     -58.676  11.027 -15.327  1.00 14.14           O  
ATOM    352  N   VAL A  63     -55.400   7.314 -18.554  1.00 15.46           N  
ATOM    353  CA  VAL A  63     -54.866   6.014 -18.198  1.00 16.44           C  
ATOM    354  C   VAL A  63     -53.875   6.281 -17.075  1.00 14.37           C  
ATOM    355  O   VAL A  63     -53.363   7.397 -16.945  1.00 14.32           O  
ATOM    356  CB  VAL A  63     -54.150   5.296 -19.385  1.00 18.19           C  
ATOM    357  CG1 VAL A  63     -55.173   4.969 -20.473  1.00 19.10           C  
ATOM    358  CG2 VAL A  63     -53.020   6.159 -19.949  1.00 20.36           C  
ATOM    359  N   VAL A  64     -53.655   5.287 -16.227  1.00 15.36           N  
ATOM    360  CA  VAL A  64     -52.668   5.428 -15.167  1.00 15.93           C  
ATOM    361  C   VAL A  64     -51.737   4.246 -15.383  1.00 16.85           C  
ATOM    362  O   VAL A  64     -52.184   3.085 -15.463  1.00 16.33           O  
ATOM    363  CB  VAL A  64     -53.308   5.401 -13.778  1.00 18.63           C  
ATOM    364  CG1 VAL A  64     -52.216   5.419 -12.703  1.00 21.39           C  
ATOM    365  CG2 VAL A  64     -54.193   6.639 -13.608  1.00 18.86           C  
ATOM    366  N   VAL A  65     -50.446   4.538 -15.509  1.00 16.92           N  
ATOM    367  CA  VAL A  65     -49.473   3.492 -15.807  1.00 16.67           C  
ATOM    368  C   VAL A  65     -48.208   3.597 -14.972  1.00 17.10           C  
ATOM    369  O   VAL A  65     -47.982   4.588 -14.285  1.00 18.25           O  
ATOM    370  CB  VAL A  65     -49.059   3.559 -17.302  1.00 18.30           C  
ATOM    371  CG1 VAL A  65     -50.295   3.558 -18.211  1.00 15.97           C  
ATOM    372  CG2 VAL A  65     -48.263   4.828 -17.556  1.00 17.87           C  
ATOM    373  N   ARG A  66     -47.384   2.555 -15.032  1.00 16.66           N  
ATOM    374  CA  ARG A  66     -46.120   2.554 -14.307  1.00 18.06           C  
ATOM    375  C   ARG A  66     -45.201   3.619 -14.901  1.00 18.76           C  
ATOM    376  O   ARG A  66     -45.273   3.934 -16.095  1.00 17.20           O  
ATOM    377  CB  ARG A  66     -45.430   1.185 -14.432  1.00 19.39           C  
ATOM    378  CG  ARG A  66     -46.246  -0.006 -13.989  1.00 26.88           C  
ATOM    379  CD  ARG A  66     -45.530  -1.321 -14.375  1.00 28.71           C  
ATOM    380  NE  ARG A  66     -46.222  -2.482 -13.828  1.00 35.50           N  
ATOM    381  CZ  ARG A  66     -47.452  -2.857 -14.170  1.00 39.01           C  
ATOM    382  NH1 ARG A  66     -48.135  -2.164 -15.078  1.00 42.09           N  
ATOM    383  NH2 ARG A  66     -48.016  -3.905 -13.583  1.00 38.46           N  
ATOM    384  N   ASP A  67     -44.317   4.167 -14.072  1.00 19.37           N  
ATOM    385  CA  ASP A  67     -43.415   5.214 -14.542  1.00 20.69           C  
ATOM    386  C   ASP A  67     -42.657   4.825 -15.802  1.00 20.99           C  
ATOM    387  O   ASP A  67     -42.535   5.627 -16.719  1.00 21.26           O  
ATOM    388  CB  ASP A  67     -42.396   5.582 -13.466  1.00 20.71           C  
ATOM    389  CG  ASP A  67     -43.025   6.249 -12.265  1.00 25.36           C  
ATOM    390  OD1 ASP A  67     -42.287   6.543 -11.303  1.00 23.92           O  
ATOM    391  OD2 ASP A  67     -44.249   6.480 -12.278  1.00 24.89           O  
ATOM    392  N   GLU A  68     -42.153   3.595 -15.848  1.00 20.56           N  
ATOM    393  CA  GLU A  68     -41.374   3.140 -16.998  1.00 23.74           C  
ATOM    394  C   GLU A  68     -42.164   2.991 -18.297  1.00 23.95           C  
ATOM    395  O   GLU A  68     -41.580   2.774 -19.364  1.00 23.74           O  
ATOM    396  CB  GLU A  68     -40.703   1.798 -16.686  1.00 23.33           C  
ATOM    397  CG  GLU A  68     -41.685   0.737 -16.266  1.00 28.64           C  
ATOM    398  CD  GLU A  68     -41.766   0.585 -14.749  1.00 34.59           C  
ATOM    399  OE1 GLU A  68     -41.864   1.611 -14.012  1.00 32.84           O  
ATOM    400  OE2 GLU A  68     -41.731  -0.579 -14.303  1.00 38.76           O  
ATOM    401  N   ASP A  69     -43.486   3.082 -18.211  1.00 20.71           N  
ATOM    402  CA  ASP A  69     -44.314   2.942 -19.392  1.00 19.92           C  
ATOM    403  C   ASP A  69     -44.890   4.259 -19.914  1.00 19.33           C  
ATOM    404  O   ASP A  69     -45.545   4.263 -20.951  1.00 17.76           O  
ATOM    405  CB  ASP A  69     -45.471   1.985 -19.119  1.00 21.24           C  
ATOM    406  CG  ASP A  69     -45.008   0.560 -18.882  1.00 26.03           C  
ATOM    407  OD1 ASP A  69     -44.003   0.135 -19.498  1.00 26.72           O  
ATOM    408  OD2 ASP A  69     -45.661  -0.142 -18.089  1.00 25.66           O  
ATOM    409  N   VAL A  70     -44.642   5.359 -19.211  1.00 17.52           N  
ATOM    410  CA  VAL A  70     -45.189   6.656 -19.622  1.00 19.53           C  
ATOM    411  C   VAL A  70     -44.798   7.103 -21.029  1.00 18.78           C  
ATOM    412  O   VAL A  70     -45.654   7.433 -21.853  1.00 16.65           O  
ATOM    413  CB  VAL A  70     -44.800   7.757 -18.616  1.00 21.54           C  
ATOM    414  CG1 VAL A  70     -45.218   9.137 -19.157  1.00 22.30           C  
ATOM    415  CG2 VAL A  70     -45.483   7.473 -17.266  1.00 19.62           C  
ATOM    416  N   GLU A  71     -43.501   7.109 -21.311  1.00 19.25           N  
ATOM    417  CA  GLU A  71     -43.021   7.534 -22.619  1.00 18.93           C  
ATOM    418  C   GLU A  71     -43.611   6.744 -23.791  1.00 19.39           C  
ATOM    419  O   GLU A  71     -43.999   7.335 -24.804  1.00 20.13           O  
ATOM    420  CB  GLU A  71     -41.483   7.470 -22.652  1.00 20.42           C  
ATOM    421  CG  GLU A  71     -40.840   8.666 -21.972  1.00 26.52           C  
ATOM    422  CD  GLU A  71     -41.346   9.990 -22.535  1.00 28.03           C  
ATOM    423  OE1 GLU A  71     -41.580  10.056 -23.757  1.00 26.40           O  
ATOM    424  OE2 GLU A  71     -41.496  10.962 -21.755  1.00 33.13           O  
ATOM    425  N   LYS A  72     -43.681   5.419 -23.667  1.00 19.65           N  
ATOM    426  CA  LYS A  72     -44.246   4.606 -24.738  1.00 19.45           C  
ATOM    427  C   LYS A  72     -45.715   5.009 -24.957  1.00 18.92           C  
ATOM    428  O   LYS A  72     -46.193   5.049 -26.077  1.00 18.96           O  
ATOM    429  CB  LYS A  72     -44.174   3.116 -24.382  1.00 23.11           C  
ATOM    430  CG  LYS A  72     -44.669   2.204 -25.478  1.00 30.91           C  
ATOM    431  CD  LYS A  72     -43.720   2.206 -26.666  1.00 36.01           C  
ATOM    432  CE  LYS A  72     -44.232   1.296 -27.778  1.00 40.39           C  
ATOM    433  NZ  LYS A  72     -44.592  -0.051 -27.247  1.00 42.46           N  
ATOM    434  N   VAL A  73     -46.430   5.295 -23.876  1.00 18.64           N  
ATOM    435  CA  VAL A  73     -47.829   5.693 -24.011  1.00 17.00           C  
ATOM    436  C   VAL A  73     -47.954   7.054 -24.678  1.00 18.28           C  
ATOM    437  O   VAL A  73     -48.789   7.242 -25.565  1.00 18.96           O  
ATOM    438  CB  VAL A  73     -48.532   5.728 -22.646  1.00 17.98           C  
ATOM    439  CG1 VAL A  73     -49.929   6.407 -22.777  1.00 18.29           C  
ATOM    440  CG2 VAL A  73     -48.646   4.291 -22.099  1.00 17.37           C  
ATOM    441  N   VAL A  74     -47.136   8.001 -24.235  1.00 16.01           N  
ATOM    442  CA  VAL A  74     -47.153   9.355 -24.796  1.00 19.09           C  
ATOM    443  C   VAL A  74     -46.840   9.278 -26.292  1.00 20.03           C  
ATOM    444  O   VAL A  74     -47.547   9.862 -27.109  1.00 18.84           O  
ATOM    445  CB  VAL A  74     -46.105  10.266 -24.085  1.00 19.21           C  
ATOM    446  CG1 VAL A  74     -45.844  11.544 -24.900  1.00 20.39           C  
ATOM    447  CG2 VAL A  74     -46.593  10.624 -22.680  1.00 20.21           C  
ATOM    448  N   GLU A  75     -45.788   8.543 -26.651  1.00 18.56           N  
ATOM    449  CA  GLU A  75     -45.405   8.410 -28.059  1.00 21.04           C  
ATOM    450  C   GLU A  75     -46.523   7.806 -28.890  1.00 20.11           C  
ATOM    451  O   GLU A  75     -46.786   8.251 -30.010  1.00 21.85           O  
ATOM    452  CB  GLU A  75     -44.161   7.524 -28.190  1.00 24.28           C  
ATOM    453  CG  GLU A  75     -42.873   8.205 -27.785  1.00 31.35           C  
ATOM    454  CD  GLU A  75     -41.700   7.233 -27.780  1.00 32.21           C  
ATOM    455  OE1 GLU A  75     -41.663   6.349 -28.659  1.00 39.45           O  
ATOM    456  OE2 GLU A  75     -40.822   7.351 -26.905  1.00 36.37           O  
ATOM    457  N   THR A  76     -47.168   6.784 -28.342  1.00 19.57           N  
ATOM    458  CA  THR A  76     -48.259   6.110 -29.044  1.00 21.09           C  
ATOM    459  C   THR A  76     -49.439   7.059 -29.281  1.00 20.62           C  
ATOM    460  O   THR A  76     -50.018   7.098 -30.370  1.00 19.97           O  
ATOM    461  CB  THR A  76     -48.712   4.859 -28.258  1.00 23.43           C  
ATOM    462  OG1 THR A  76     -47.629   3.916 -28.196  1.00 23.64           O  
ATOM    463  CG2 THR A  76     -49.926   4.194 -28.919  1.00 23.58           C  
ATOM    464  N   ILE A  77     -49.799   7.838 -28.270  1.00 20.31           N  
ATOM    465  CA  ILE A  77     -50.901   8.784 -28.429  1.00 18.49           C  
ATOM    466  C   ILE A  77     -50.556   9.879 -29.444  1.00 19.83           C  
ATOM    467  O   ILE A  77     -51.362  10.207 -30.314  1.00 20.82           O  
ATOM    468  CB  ILE A  77     -51.269   9.421 -27.058  1.00 18.04           C  
ATOM    469  CG1 ILE A  77     -51.731   8.296 -26.123  1.00 18.96           C  
ATOM    470  CG2 ILE A  77     -52.350  10.531 -27.232  1.00 18.42           C  
ATOM    471  CD1 ILE A  77     -52.070   8.735 -24.719  1.00 19.16           C  
ATOM    472  N   VAL A  78     -49.358  10.446 -29.338  1.00 18.07           N  
ATOM    473  CA  VAL A  78     -48.957  11.489 -30.271  1.00 21.38           C  
ATOM    474  C   VAL A  78     -49.001  10.967 -31.713  1.00 22.82           C  
ATOM    475  O   VAL A  78     -49.563  11.609 -32.598  1.00 21.29           O  
ATOM    476  CB  VAL A  78     -47.521  12.006 -29.972  1.00 20.99           C  
ATOM    477  CG1 VAL A  78     -47.086  12.976 -31.069  1.00 22.71           C  
ATOM    478  CG2 VAL A  78     -47.470  12.701 -28.592  1.00 19.85           C  
ATOM    479  N   LYS A  79     -48.413   9.798 -31.941  1.00 23.47           N  
ATOM    480  CA  LYS A  79     -48.372   9.237 -33.285  1.00 26.69           C  
ATOM    481  C   LYS A  79     -49.730   8.900 -33.857  1.00 25.87           C  
ATOM    482  O   LYS A  79     -49.967   9.103 -35.041  1.00 25.53           O  
ATOM    483  CB  LYS A  79     -47.502   7.980 -33.320  1.00 29.52           C  
ATOM    484  CG  LYS A  79     -46.049   8.244 -32.971  1.00 37.30           C  
ATOM    485  CD  LYS A  79     -45.216   6.965 -33.021  1.00 43.34           C  
ATOM    486  CE  LYS A  79     -43.767   7.264 -32.646  1.00 46.72           C  
ATOM    487  NZ  LYS A  79     -42.909   6.054 -32.671  1.00 51.01           N  
ATOM    488  N   THR A  80     -50.625   8.398 -33.013  1.00 23.66           N  
ATOM    489  CA  THR A  80     -51.951   7.998 -33.472  1.00 26.02           C  
ATOM    490  C   THR A  80     -52.981   9.126 -33.540  1.00 25.02           C  
ATOM    491  O   THR A  80     -53.867   9.102 -34.401  1.00 27.14           O  
ATOM    492  CB  THR A  80     -52.504   6.860 -32.576  1.00 26.65           C  
ATOM    493  OG1 THR A  80     -51.551   5.787 -32.526  1.00 34.08           O  
ATOM    494  CG2 THR A  80     -53.788   6.307 -33.145  1.00 25.97           C  
ATOM    495  N   ALA A  81     -52.864  10.109 -32.648  1.00 21.00           N  
ATOM    496  CA  ALA A  81     -53.821  11.223 -32.589  1.00 22.60           C  
ATOM    497  C   ALA A  81     -53.482  12.442 -33.427  1.00 23.88           C  
ATOM    498  O   ALA A  81     -54.339  13.279 -33.687  1.00 24.34           O  
ATOM    499  CB  ALA A  81     -54.020  11.663 -31.118  1.00 20.15           C  
ATOM    500  N   GLN A  82     -52.226  12.548 -33.830  1.00 23.96           N  
ATOM    501  CA  GLN A  82     -51.744  13.681 -34.608  1.00 27.75           C  
ATOM    502  C   GLN A  82     -52.362  13.746 -36.008  1.00 27.49           C  
ATOM    503  O   GLN A  82     -52.647  12.715 -36.612  1.00 30.99           O  
ATOM    504  CB  GLN A  82     -50.226  13.546 -34.726  1.00 28.94           C  
ATOM    505  CG  GLN A  82     -49.476  14.729 -35.252  1.00 37.65           C  
ATOM    506  CD  GLN A  82     -47.982  14.466 -35.227  1.00 40.11           C  
ATOM    507  OE1 GLN A  82     -47.451  13.759 -36.083  1.00 44.50           O  
ATOM    508  NE2 GLN A  82     -47.303  15.010 -34.226  1.00 42.56           N  
ATOM    509  N   THR A  83     -52.591  14.954 -36.502  1.00 29.09           N  
ATOM    510  CA  THR A  83     -53.087  15.143 -37.870  1.00 31.99           C  
ATOM    511  C   THR A  83     -52.198  16.224 -38.477  1.00 33.69           C  
ATOM    512  O   THR A  83     -52.093  16.349 -39.696  1.00 36.09           O  
ATOM    513  CB  THR A  83     -54.562  15.621 -37.943  1.00 28.12           C  
ATOM    514  OG1 THR A  83     -54.675  16.935 -37.392  1.00 28.91           O  
ATOM    515  CG2 THR A  83     -55.480  14.668 -37.208  1.00 29.84           C  
ATOM    516  N   GLY A  84     -51.561  16.998 -37.605  1.00 35.23           N  
ATOM    517  CA  GLY A  84     -50.683  18.068 -38.038  1.00 36.91           C  
ATOM    518  C   GLY A  84     -51.419  19.388 -38.105  1.00 37.33           C  
ATOM    519  O   GLY A  84     -50.811  20.441 -38.308  1.00 38.76           O  
ATOM    520  N   ARG A  85     -52.736  19.320 -37.920  1.00 36.54           N  
ATOM    521  CA  ARG A  85     -53.608  20.489 -37.969  1.00 36.88           C  
ATOM    522  C   ARG A  85     -53.852  21.041 -36.569  1.00 36.33           C  
ATOM    523  O   ARG A  85     -53.712  20.325 -35.579  1.00 33.84           O  
ATOM    524  CB  ARG A  85     -54.960  20.106 -38.580  1.00 40.20           C  
ATOM    525  CG  ARG A  85     -54.902  19.498 -39.974  1.00 43.42           C  
ATOM    526  CD  ARG A  85     -54.608  20.552 -41.028  1.00 49.40           C  
ATOM    527  NE  ARG A  85     -54.763  20.028 -42.386  1.00 54.64           N  
ATOM    528  CZ  ARG A  85     -54.040  19.037 -42.901  1.00 56.51           C  
ATOM    529  NH1 ARG A  85     -53.098  18.446 -42.175  1.00 58.71           N  
ATOM    530  NH2 ARG A  85     -54.260  18.633 -44.148  1.00 56.25           N  
ATOM    531  N   VAL A  86     -54.249  22.306 -36.497  1.00 33.87           N  
ATOM    532  CA  VAL A  86     -54.518  22.958 -35.220  1.00 34.39           C  
ATOM    533  C   VAL A  86     -55.674  22.293 -34.474  1.00 32.83           C  
ATOM    534  O   VAL A  86     -56.651  21.853 -35.082  1.00 32.26           O  
ATOM    535  CB  VAL A  86     -54.852  24.445 -35.417  1.00 35.40           C  
ATOM    536  CG1 VAL A  86     -55.206  25.086 -34.077  1.00 36.02           C  
ATOM    537  CG2 VAL A  86     -53.666  25.157 -36.052  1.00 38.08           C  
ATOM    538  N   GLY A  87     -55.545  22.222 -33.154  1.00 28.62           N  
ATOM    539  CA  GLY A  87     -56.582  21.615 -32.335  1.00 28.13           C  
ATOM    540  C   GLY A  87     -56.376  20.135 -32.057  1.00 26.37           C  
ATOM    541  O   GLY A  87     -57.276  19.490 -31.504  1.00 25.68           O  
ATOM    542  N   ASP A  88     -55.218  19.588 -32.440  1.00 22.58           N  
ATOM    543  CA  ASP A  88     -54.939  18.167 -32.223  1.00 21.86           C  
ATOM    544  C   ASP A  88     -54.995  17.811 -30.735  1.00 19.90           C  
ATOM    545  O   ASP A  88     -55.186  16.657 -30.385  1.00 20.52           O  
ATOM    546  CB  ASP A  88     -53.565  17.775 -32.780  1.00 21.30           C  
ATOM    547  CG  ASP A  88     -53.608  17.403 -34.263  1.00 26.33           C  
ATOM    548  OD1 ASP A  88     -54.715  17.390 -34.866  1.00 25.62           O  
ATOM    549  OD2 ASP A  88     -52.531  17.103 -34.820  1.00 23.22           O  
ATOM    550  N   GLY A  89     -54.807  18.798 -29.869  1.00 20.12           N  
ATOM    551  CA  GLY A  89     -54.876  18.514 -28.443  1.00 19.78           C  
ATOM    552  C   GLY A  89     -53.565  18.422 -27.682  1.00 19.63           C  
ATOM    553  O   GLY A  89     -52.486  18.688 -28.221  1.00 17.84           O  
ATOM    554  N   LYS A  90     -53.663  18.009 -26.418  1.00 17.67           N  
ATOM    555  CA  LYS A  90     -52.491  17.936 -25.562  1.00 17.06           C  
ATOM    556  C   LYS A  90     -52.521  16.724 -24.646  1.00 13.92           C  
ATOM    557  O   LYS A  90     -53.546  16.061 -24.504  1.00 13.96           O  
ATOM    558  CB  LYS A  90     -52.406  19.201 -24.701  1.00 20.89           C  
ATOM    559  CG  LYS A  90     -52.462  20.544 -25.478  1.00 24.35           C  
ATOM    560  CD  LYS A  90     -51.901  21.662 -24.619  1.00 30.38           C  
ATOM    561  CE  LYS A  90     -52.190  23.045 -25.182  1.00 30.97           C  
ATOM    562  NZ  LYS A  90     -51.791  23.166 -26.598  1.00 32.13           N  
ATOM    563  N   ILE A  91     -51.383  16.453 -24.022  1.00 13.48           N  
ATOM    564  CA  ILE A  91     -51.245  15.343 -23.094  1.00 12.81           C  
ATOM    565  C   ILE A  91     -50.604  15.890 -21.824  1.00 14.39           C  
ATOM    566  O   ILE A  91     -49.611  16.601 -21.895  1.00 15.91           O  
ATOM    567  CB  ILE A  91     -50.315  14.242 -23.655  1.00 13.60           C  
ATOM    568  CG1 ILE A  91     -50.870  13.700 -24.986  1.00 15.21           C  
ATOM    569  CG2 ILE A  91     -50.149  13.144 -22.618  1.00 14.17           C  
ATOM    570  CD1 ILE A  91     -49.936  12.708 -25.680  1.00 14.77           C  
ATOM    571  N   PHE A  92     -51.184  15.575 -20.666  1.00 14.04           N  
ATOM    572  CA  PHE A  92     -50.625  16.033 -19.401  1.00 14.59           C  
ATOM    573  C   PHE A  92     -50.158  14.801 -18.625  1.00 15.83           C  
ATOM    574  O   PHE A  92     -50.847  13.783 -18.607  1.00 15.35           O  
ATOM    575  CB  PHE A  92     -51.677  16.769 -18.537  1.00 15.61           C  
ATOM    576  CG  PHE A  92     -52.481  17.823 -19.279  1.00 17.99           C  
ATOM    577  CD1 PHE A  92     -51.872  18.716 -20.147  1.00 14.98           C  
ATOM    578  CD2 PHE A  92     -53.852  17.947 -19.046  1.00 19.09           C  
ATOM    579  CE1 PHE A  92     -52.622  19.733 -20.783  1.00 21.81           C  
ATOM    580  CE2 PHE A  92     -54.602  18.956 -19.671  1.00 20.39           C  
ATOM    581  CZ  PHE A  92     -53.992  19.844 -20.535  1.00 19.06           C  
ATOM    582  N   ILE A  93     -48.985  14.889 -17.993  1.00 15.25           N  
ATOM    583  CA  ILE A  93     -48.469  13.793 -17.186  1.00 14.62           C  
ATOM    584  C   ILE A  93     -48.590  14.340 -15.775  1.00 12.67           C  
ATOM    585  O   ILE A  93     -48.000  15.366 -15.444  1.00 14.95           O  
ATOM    586  CB  ILE A  93     -46.981  13.489 -17.500  1.00 16.29           C  
ATOM    587  CG1 ILE A  93     -46.821  13.182 -18.990  1.00 18.26           C  
ATOM    588  CG2 ILE A  93     -46.509  12.332 -16.641  1.00 19.14           C  
ATOM    589  CD1 ILE A  93     -47.676  12.000 -19.511  1.00 21.48           C  
ATOM    590  N   ILE A  94     -49.377  13.650 -14.961  1.00 14.48           N  
ATOM    591  CA  ILE A  94     -49.704  14.071 -13.591  1.00 14.89           C  
ATOM    592  C   ILE A  94     -49.299  12.977 -12.607  1.00 14.36           C  
ATOM    593  O   ILE A  94     -49.601  11.815 -12.819  1.00 15.91           O  
ATOM    594  CB  ILE A  94     -51.257  14.320 -13.520  1.00 16.19           C  
ATOM    595  CG1 ILE A  94     -51.622  15.528 -14.393  1.00 16.86           C  
ATOM    596  CG2 ILE A  94     -51.742  14.546 -12.092  1.00 13.74           C  
ATOM    597  CD1 ILE A  94     -53.111  15.574 -14.792  1.00 17.81           C  
ATOM    598  N   PRO A  95     -48.598  13.331 -11.519  1.00 14.20           N  
ATOM    599  CA  PRO A  95     -48.216  12.278 -10.572  1.00 16.41           C  
ATOM    600  C   PRO A  95     -49.417  11.654  -9.859  1.00 15.40           C  
ATOM    601  O   PRO A  95     -50.407  12.323  -9.566  1.00 14.60           O  
ATOM    602  CB  PRO A  95     -47.298  13.011  -9.583  1.00 17.17           C  
ATOM    603  CG  PRO A  95     -47.836  14.394  -9.587  1.00 19.28           C  
ATOM    604  CD  PRO A  95     -48.112  14.647 -11.069  1.00 16.51           C  
ATOM    605  N   VAL A  96     -49.309  10.361  -9.606  1.00 13.02           N  
ATOM    606  CA  VAL A  96     -50.317   9.596  -8.881  1.00 14.25           C  
ATOM    607  C   VAL A  96     -49.570   8.938  -7.720  1.00 17.03           C  
ATOM    608  O   VAL A  96     -48.572   8.254  -7.933  1.00 21.23           O  
ATOM    609  CB  VAL A  96     -50.954   8.535  -9.809  1.00 15.58           C  
ATOM    610  CG1 VAL A  96     -51.734   7.507  -9.013  1.00 17.15           C  
ATOM    611  CG2 VAL A  96     -51.901   9.257 -10.792  1.00 13.13           C  
ATOM    612  N   GLU A  97     -50.022   9.184  -6.500  1.00 18.81           N  
ATOM    613  CA  GLU A  97     -49.376   8.596  -5.330  1.00 19.83           C  
ATOM    614  C   GLU A  97     -49.828   7.170  -5.050  1.00 20.85           C  
ATOM    615  O   GLU A  97     -49.122   6.396  -4.397  1.00 20.25           O  
ATOM    616  CB  GLU A  97     -49.567   9.538  -4.142  1.00 21.54           C  
ATOM    617  CG  GLU A  97     -48.749  10.808  -4.422  1.00 25.57           C  
ATOM    618  CD  GLU A  97     -48.916  11.899  -3.401  1.00 30.01           C  
ATOM    619  OE1 GLU A  97     -49.675  11.712  -2.428  1.00 33.47           O  
ATOM    620  OE2 GLU A  97     -48.276  12.950  -3.589  1.00 32.49           O  
ATOM    621  N   ASP A  98     -51.001   6.810  -5.553  1.00 18.02           N  
ATOM    622  CA  ASP A  98     -51.476   5.438  -5.422  1.00 18.07           C  
ATOM    623  C   ASP A  98     -52.708   5.207  -6.264  1.00 17.89           C  
ATOM    624  O   ASP A  98     -53.408   6.153  -6.620  1.00 14.60           O  
ATOM    625  CB  ASP A  98     -51.795   5.055  -3.980  1.00 21.95           C  
ATOM    626  CG  ASP A  98     -51.715   3.534  -3.763  1.00 27.54           C  
ATOM    627  OD1 ASP A  98     -51.095   2.838  -4.605  1.00 29.46           O  
ATOM    628  OD2 ASP A  98     -52.253   3.047  -2.756  1.00 33.59           O  
ATOM    629  N   VAL A  99     -52.926   3.935  -6.588  1.00 18.30           N  
ATOM    630  CA  VAL A  99     -54.069   3.476  -7.370  1.00 18.56           C  
ATOM    631  C   VAL A  99     -54.633   2.287  -6.592  1.00 18.17           C  
ATOM    632  O   VAL A  99     -53.877   1.465  -6.045  1.00 18.73           O  
ATOM    633  CB  VAL A  99     -53.617   3.013  -8.775  1.00 19.24           C  
ATOM    634  CG1 VAL A  99     -54.804   2.533  -9.597  1.00 18.10           C  
ATOM    635  CG2 VAL A  99     -52.921   4.162  -9.483  1.00 25.22           C  
ATOM    636  N   ILE A 100     -55.952   2.205  -6.523  1.00 17.13           N  
ATOM    637  CA  ILE A 100     -56.601   1.109  -5.811  1.00 16.41           C  
ATOM    638  C   ILE A 100     -57.627   0.468  -6.735  1.00 17.87           C  
ATOM    639  O   ILE A 100     -58.403   1.163  -7.398  1.00 18.37           O  
ATOM    640  CB  ILE A 100     -57.319   1.609  -4.518  1.00 16.48           C  
ATOM    641  CG1 ILE A 100     -56.309   2.273  -3.580  1.00 18.34           C  
ATOM    642  CG2 ILE A 100     -58.025   0.444  -3.808  1.00 17.11           C  
ATOM    643  CD1 ILE A 100     -56.218   3.789  -3.776  1.00 20.78           C  
ATOM    644  N   ARG A 101     -57.596  -0.861  -6.821  1.00 17.82           N  
ATOM    645  CA  ARG A 101     -58.554  -1.583  -7.646  1.00 18.62           C  
ATOM    646  C   ARG A 101     -59.758  -1.851  -6.748  1.00 19.05           C  
ATOM    647  O   ARG A 101     -59.650  -2.550  -5.736  1.00 19.01           O  
ATOM    648  CB  ARG A 101     -57.956  -2.897  -8.157  1.00 19.22           C  
ATOM    649  CG  ARG A 101     -58.827  -3.579  -9.213  1.00 23.39           C  
ATOM    650  CD  ARG A 101     -58.337  -4.980  -9.543  1.00 23.97           C  
ATOM    651  NE  ARG A 101     -56.975  -5.006 -10.073  1.00 25.96           N  
ATOM    652  CZ  ARG A 101     -56.626  -4.636 -11.301  1.00 29.64           C  
ATOM    653  NH1 ARG A 101     -57.539  -4.190 -12.162  1.00 31.52           N  
ATOM    654  NH2 ARG A 101     -55.357  -4.750 -11.681  1.00 32.28           N  
ATOM    655  N   ILE A 102     -60.905  -1.273  -7.101  1.00 15.47           N  
ATOM    656  CA  ILE A 102     -62.096  -1.420  -6.285  1.00 16.32           C  
ATOM    657  C   ILE A 102     -62.555  -2.864  -6.076  1.00 17.93           C  
ATOM    658  O   ILE A 102     -62.965  -3.241  -4.975  1.00 21.30           O  
ATOM    659  CB  ILE A 102     -63.270  -0.585  -6.887  1.00 18.33           C  
ATOM    660  CG1 ILE A 102     -62.883   0.902  -6.877  1.00 16.21           C  
ATOM    661  CG2 ILE A 102     -64.570  -0.840  -6.095  1.00 21.06           C  
ATOM    662  CD1 ILE A 102     -63.944   1.822  -7.487  1.00 14.59           C  
ATOM    663  N   ARG A 103     -62.471  -3.674  -7.118  1.00 19.24           N  
ATOM    664  CA  ARG A 103     -62.917  -5.061  -7.023  1.00 23.07           C  
ATOM    665  C   ARG A 103     -62.209  -5.900  -5.961  1.00 25.11           C  
ATOM    666  O   ARG A 103     -62.828  -6.723  -5.273  1.00 23.03           O  
ATOM    667  CB  ARG A 103     -62.738  -5.751  -8.384  1.00 25.69           C  
ATOM    668  CG  ARG A 103     -63.243  -7.197  -8.436  1.00 32.55           C  
ATOM    669  CD  ARG A 103     -62.933  -7.840  -9.783  1.00 33.09           C  
ATOM    670  NE  ARG A 103     -61.493  -7.892 -10.021  1.00 39.80           N  
ATOM    671  CZ  ARG A 103     -60.923  -8.425 -11.094  1.00 43.04           C  
ATOM    672  NH1 ARG A 103     -61.670  -8.967 -12.050  1.00 49.42           N  
ATOM    673  NH2 ARG A 103     -59.606  -8.411 -11.222  1.00 45.65           N  
ATOM    674  N   THR A 104     -60.915  -5.662  -5.804  1.00 24.57           N  
ATOM    675  CA  THR A 104     -60.094  -6.461  -4.906  1.00 24.15           C  
ATOM    676  C   THR A 104     -59.405  -5.748  -3.756  1.00 23.05           C  
ATOM    677  O   THR A 104     -58.958  -6.397  -2.802  1.00 23.94           O  
ATOM    678  CB  THR A 104     -58.976  -7.129  -5.715  1.00 23.50           C  
ATOM    679  OG1 THR A 104     -58.160  -6.103  -6.290  1.00 23.66           O  
ATOM    680  CG2 THR A 104     -59.538  -7.976  -6.849  1.00 26.81           C  
ATOM    681  N   GLY A 105     -59.274  -4.428  -3.847  1.00 19.97           N  
ATOM    682  CA  GLY A 105     -58.554  -3.718  -2.803  1.00 20.01           C  
ATOM    683  C   GLY A 105     -57.046  -3.724  -3.077  1.00 18.31           C  
ATOM    684  O   GLY A 105     -56.266  -3.206  -2.263  1.00 21.37           O  
ATOM    685  N   GLU A 106     -56.626  -4.299  -4.207  1.00 18.90           N  
ATOM    686  CA  GLU A 106     -55.206  -4.317  -4.586  1.00 19.56           C  
ATOM    687  C   GLU A 106     -54.792  -2.871  -4.832  1.00 20.19           C  
ATOM    688  O   GLU A 106     -55.628  -2.047  -5.225  1.00 18.59           O  
ATOM    689  CB  GLU A 106     -54.977  -5.095  -5.891  1.00 22.36           C  
ATOM    690  CG  GLU A 106     -55.242  -6.588  -5.824  1.00 25.55           C  
ATOM    691  CD  GLU A 106     -55.269  -7.212  -7.203  1.00 30.74           C  
ATOM    692  OE1 GLU A 106     -54.340  -7.973  -7.539  1.00 27.31           O  
ATOM    693  OE2 GLU A 106     -56.221  -6.924  -7.965  1.00 26.80           O  
ATOM    694  N   ARG A 107     -53.518  -2.563  -4.585  1.00 17.59           N  
ATOM    695  CA  ARG A 107     -52.995  -1.220  -4.799  1.00 18.54           C  
ATOM    696  C   ARG A 107     -51.713  -1.239  -5.633  1.00 19.18           C  
ATOM    697  O   ARG A 107     -51.173  -2.302  -5.952  1.00 21.16           O  
ATOM    698  CB  ARG A 107     -52.709  -0.536  -3.458  1.00 19.10           C  
ATOM    699  CG  ARG A 107     -53.896  -0.510  -2.535  1.00 18.67           C  
ATOM    700  CD  ARG A 107     -53.735   0.614  -1.534  1.00 20.38           C  
ATOM    701  NE  ARG A 107     -54.805   0.594  -0.556  1.00 22.29           N  
ATOM    702  CZ  ARG A 107     -55.049   1.593   0.278  1.00 22.94           C  
ATOM    703  NH1 ARG A 107     -54.298   2.680   0.225  1.00 23.82           N  
ATOM    704  NH2 ARG A 107     -56.021   1.490   1.172  1.00 24.48           N  
ATOM    705  N   GLY A 108     -51.220  -0.059  -5.980  1.00 21.50           N  
ATOM    706  CA  GLY A 108     -49.990   0.024  -6.756  1.00 22.69           C  
ATOM    707  C   GLY A 108     -49.933  -0.795  -8.033  1.00 25.58           C  
ATOM    708  O   GLY A 108     -50.903  -0.863  -8.798  1.00 22.79           O  
ATOM    709  N   GLU A 109     -48.780  -1.416  -8.278  1.00 25.69           N  
ATOM    710  CA  GLU A 109     -48.583  -2.229  -9.482  1.00 29.73           C  
ATOM    711  C   GLU A 109     -49.656  -3.292  -9.634  1.00 29.40           C  
ATOM    712  O   GLU A 109     -49.985  -3.698 -10.744  1.00 31.69           O  
ATOM    713  CB  GLU A 109     -47.224  -2.948  -9.458  1.00 36.23           C  
ATOM    714  CG  GLU A 109     -45.997  -2.058  -9.497  1.00 41.26           C  
ATOM    715  CD  GLU A 109     -45.873  -1.175  -8.274  1.00 44.43           C  
ATOM    716  OE1 GLU A 109     -46.485  -1.507  -7.233  1.00 43.69           O  
ATOM    717  OE2 GLU A 109     -45.152  -0.154  -8.357  1.00 45.65           O  
ATOM    718  N   GLN A 110     -50.193  -3.755  -8.514  1.00 27.73           N  
ATOM    719  CA  GLN A 110     -51.211  -4.788  -8.559  1.00 27.12           C  
ATOM    720  C   GLN A 110     -52.579  -4.265  -8.986  1.00 26.19           C  
ATOM    721  O   GLN A 110     -53.448  -5.047  -9.375  1.00 26.88           O  
ATOM    722  CB  GLN A 110     -51.321  -5.459  -7.188  1.00 28.40           C  
ATOM    723  CG  GLN A 110     -49.979  -5.984  -6.679  1.00 33.81           C  
ATOM    724  CD  GLN A 110     -49.297  -6.875  -7.693  1.00 37.17           C  
ATOM    725  OE1 GLN A 110     -48.163  -6.614  -8.105  1.00 36.89           O  
ATOM    726  NE2 GLN A 110     -49.982  -7.937  -8.104  1.00 37.48           N  
ATOM    727  N   ALA A 111     -52.762  -2.948  -8.927  1.00 25.92           N  
ATOM    728  CA  ALA A 111     -54.049  -2.335  -9.269  1.00 25.19           C  
ATOM    729  C   ALA A 111     -54.146  -1.828 -10.705  1.00 29.78           C  
ATOM    730  O   ALA A 111     -55.233  -1.488 -11.177  1.00 29.93           O  
ATOM    731  CB  ALA A 111     -54.355  -1.195  -8.299  1.00 22.12           C  
ATOM    732  N   ILE A 112     -53.010  -1.764 -11.383  1.00 33.16           N  
ATOM    733  CA  ILE A 112     -52.964  -1.307 -12.766  1.00 40.48           C  
ATOM    734  C   ILE A 112     -53.297  -2.471 -13.690  1.00 41.66           C  
ATOM    735  O   ILE A 112     -54.046  -2.250 -14.657  1.00 45.04           O  
ATOM    736  CB  ILE A 112     -51.571  -0.763 -13.121  1.00 41.11           C  
ATOM    737  CG1 ILE A 112     -51.276   0.472 -12.271  1.00 43.60           C  
ATOM    738  CG2 ILE A 112     -51.505  -0.424 -14.605  1.00 46.54           C  
ATOM    739  CD1 ILE A 112     -49.927   1.085 -12.542  1.00 46.50           C  
ATOM    740  OXT ILE A 112     -52.794  -3.587 -13.437  1.00 46.16           O  
TER     741      ILE A 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
