
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  799),  selected   99 , name 2dcl_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2dcl_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     2_A      -       -           -
LGA    E     3_A      M       1          1.692
LGA    V     4_A      S       2          2.099
LGA    E     5_A      -       -           -
LGA    H     6_A      K       3          1.761
LGA    W     7_A      R       4          1.772
LGA    N     8_A      -       -           -
LGA    T     9_A      A       5          0.721
LGA    L    10_A      N       6          0.690
LGA    R    11_A      K       7          0.577
LGA    L    12_A      L       8          0.612
LGA    R    13_A      V       9          0.648
LGA    I    14_A      I      10          0.510
LGA    Y    15_A      V      11          0.608
LGA    I    16_A      T      12          0.634
LGA    G    17_A      E      13          1.275
LGA    E    18_A      K      14          1.438
LGA    N    19_A      V      15          3.365
LGA    D    20_A      -       -           -
LGA    K    21_A      -       -           -
LGA    W    22_A      -       -           -
LGA    E    23_A      -       -           -
LGA    G    24_A      -       -           -
LGA    R    25_A      -       -           -
LGA    P    26_A      -       -           -
LGA    L    27_A      L      16          1.225
LGA    Y    28_A      L      17          1.630
LGA    K    29_A      K      18          0.860
LGA    V    30_A      K      19          0.911
LGA    I    31_A      V      20          1.214
LGA    V    32_A      A      21          0.841
LGA    E    33_A      K      22          1.229
LGA    K    34_A      I      23          1.874
LGA    L    35_A      I      24          1.421
LGA    R    36_A      E      25          1.187
LGA    E    37_A      E      26          1.977
LGA    M    38_A      A      27          2.111
LGA    G    39_A      G      28          1.227
LGA    I    40_A      A      29          1.015
LGA    A    41_A      T      30          2.298
LGA    G    42_A      G      31          1.190
LGA    A    43_A      Y      32          0.742
LGA    T    44_A      T      33          0.617
LGA    V    45_A      V      34          0.465
LGA    Y    46_A      V      35          0.475
LGA    R    47_A      D      36          0.270
LGA    G    48_A      T      37          1.670
LGA    I    49_A      -       -           -
LGA    Y    50_A      G      38          2.234
LGA    G    51_A      G      39          1.040
LGA    F    52_A      -       -           -
LGA    G    53_A      -       -           -
LGA    T    68_A      -       -           -
LGA    D    69_A      S      58          2.663
LGA    L    70_A      N      59          3.850
LGA    P    71_A      -       -           -
LGA    I    72_A      V      60          0.515
LGA    I    73_A      K      61          0.458
LGA    V    74_A      F      62          0.885
LGA    E    75_A      E      63          0.883
LGA    V    76_A      V      64          0.617
LGA    V    77_A      L      65          0.649
LGA    D    78_A      T      66          1.176
LGA    R    79_A      E      67          2.617
LGA    G    80_A      N      68          3.414
LGA    -       -      R      69           -
LGA    H    81_A      E      70          2.259
LGA    N    82_A      M      71          1.175
LGA    I    83_A      A      72          0.577
LGA    E    84_A      E      73          1.146
LGA    K    85_A      K      74          1.625
LGA    V    86_A      I      75          1.111
LGA    V    87_A      A      76          1.460
LGA    N    88_A      D      77          1.701
LGA    V    89_A      Q      78          1.275
LGA    I    90_A      V      79          1.266
LGA    K    91_A      A      80          1.410
LGA    P    92_A      I      81          1.316
LGA    M    93_A      K      82          2.502
LGA    I    94_A      F      83          3.092
LGA    K    95_A      F      84          2.008
LGA    -       -      T      85           -
LGA    -       -      D      86           -
LGA    -       -      Y      87           -
LGA    D    96_A      A      88          2.221
LGA    G    97_A      G      89          1.210
LGA    M    98_A      I      90          0.695
LGA    I    99_A      I      91          0.684
LGA    T   100_A      Y      92          1.010
LGA    V   101_A      I      93          0.705
LGA    E   102_A      C      94          1.446
LGA    P   103_A      E      95          0.648
LGA    T   104_A      A      96          0.644
LGA    I   105_A      E      97          0.606
LGA    V   106_A      V      98          0.655
LGA    L   107_A      L      99          0.615
LGA    W   108_A      Y     100          0.773
LGA    V   109_A      G     101          1.288
LGA    G   110_A      -       -           -
LGA    T   111_A      -       -           -
LGA    Q   112_A      -       -           -
LGA    E   113_A      -       -           -
LGA    E   114_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99   83    5.0     79    1.51    22.78     88.449     4.913

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.074903 * X  +   0.104508 * Y  +  -0.991699 * Z  + -70.039146
  Y_new =   0.444819 * X  +   0.893570 * Y  +   0.060570 * Z  +  39.170204
  Z_new =   0.892483 * X  +  -0.436589 * Y  +  -0.113419 * Z  + -39.745018 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.824961    1.316631  [ DEG:  -104.5626     75.4374 ]
  Theta =  -1.102820   -2.038772  [ DEG:   -63.1869   -116.8131 ]
  Phi   =   1.737622   -1.403971  [ DEG:    99.5584    -80.4416 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dcl_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dcl_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99   83   5.0   79   1.51   22.78  88.449
REMARK  ---------------------------------------------------------- 
MOLECULE 2dcl_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   08-JAN-06   2DCL              
TITLE     STRUCTURE OF PH1503 PROTEIN FROM PYROCOCCUS HORIKOSHII OT3            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL UPF0166 PROTEIN PH1503;                       
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: PH1503;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    HEXAMER, X-RAY DIFFRACTION, STRUCTURAL GENOMICS, NPPSFA,              
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI                                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.BAGAUTDINOV,N.KUNISHIMA,RIKEN STRUCTURAL                            
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   08-JUL-06 2DCL    0                                                
JRNL        AUTH   B.BAGAUTDINOV,N.KUNISHIMA                                    
JRNL        TITL   CRYSTAL STRUCTURE OF PH1503 PROTEIN FROM                     
JRNL        TITL 2 PYROCOCCUS HORIKOSHII OT3                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.28 ANGSTROMS.                                          
DBREF  2DCL A    1   127  UNP    O59172   Y1503_PYRHO      1    127             
DBREF  2DCL B    1   127  UNP    O59172   Y1503_PYRHO      1    127             
DBREF  2DCL C    1   127  UNP    O59172   Y1503_PYRHO      1    127             
SEQRES   1 A  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 A  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 A  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 A  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 A  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 A  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 A  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 A  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 A  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 A  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
SEQRES   1 B  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 B  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 B  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 B  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 B  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 B  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 B  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 B  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 B  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 B  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
SEQRES   1 C  127  MET VAL GLU VAL GLU HIS TRP ASN THR LEU ARG LEU ARG          
SEQRES   2 C  127  ILE TYR ILE GLY GLU ASN ASP LYS TRP GLU GLY ARG PRO          
SEQRES   3 C  127  LEU TYR LYS VAL ILE VAL GLU LYS LEU ARG GLU MET GLY          
SEQRES   4 C  127  ILE ALA GLY ALA THR VAL TYR ARG GLY ILE TYR GLY PHE          
SEQRES   5 C  127  GLY LYS LYS SER ARG VAL HIS SER SER ASP VAL ILE ARG          
SEQRES   6 C  127  LEU SER THR ASP LEU PRO ILE ILE VAL GLU VAL VAL ASP          
SEQRES   7 C  127  ARG GLY HIS ASN ILE GLU LYS VAL VAL ASN VAL ILE LYS          
SEQRES   8 C  127  PRO MET ILE LYS ASP GLY MET ILE THR VAL GLU PRO THR          
SEQRES   9 C  127  ILE VAL LEU TRP VAL GLY THR GLN GLU GLU ILE LYS LYS          
SEQRES  10 C  127  PHE GLU GLU ASP ALA ILE ALA GLU ARG GLN                      
HET    AMP    901      23                                                       
HET    AMP    902      23                                                       
HET    AMP    903      23                                                       
HETNAM     AMP ADENOSINE MONOPHOSPHATE                                          
FORMUL   4  AMP    3(C10 H14 N5 O7 P)                                           
FORMUL   7  HOH   *123(H2 O)                                                    
CRYST1  107.562   59.647   66.738  90.00 122.47  90.00 C 1 2 1      12          
ATOM      1  N   VAL A   2     -49.600   1.638   6.181  1.00 51.82           N  
ATOM      2  CA  VAL A   2     -50.802   1.423   5.331  1.00 53.21           C  
ATOM      3  C   VAL A   2     -50.388   0.815   3.988  1.00 53.41           C  
ATOM      4  O   VAL A   2     -49.201   0.675   3.712  1.00 55.12           O  
ATOM      5  CB  VAL A   2     -51.575   2.759   5.117  1.00 51.31           C  
ATOM      6  CG1 VAL A   2     -51.709   3.474   6.447  1.00 51.24           C  
ATOM      7  CG2 VAL A   2     -50.858   3.654   4.116  1.00 51.09           C  
ATOM      8  N   GLU A   3     -51.368   0.458   3.163  1.00 54.04           N  
ATOM      9  CA  GLU A   3     -51.105  -0.170   1.873  1.00 56.55           C  
ATOM     10  C   GLU A   3     -51.614   0.611   0.673  1.00 55.68           C  
ATOM     11  O   GLU A   3     -52.689   1.212   0.711  1.00 57.29           O  
ATOM     12  CB  GLU A   3     -51.732  -1.568   1.833  1.00 59.36           C  
ATOM     13  CG  GLU A   3     -51.099  -2.589   2.778  1.00 63.89           C  
ATOM     14  CD  GLU A   3     -52.032  -3.756   3.076  1.00 66.90           C  
ATOM     15  OE1 GLU A   3     -52.584  -4.335   2.114  1.00 68.18           O  
ATOM     16  OE2 GLU A   3     -52.216  -4.094   4.267  1.00 68.12           O  
ATOM     17  N   VAL A   4     -50.834   0.579  -0.403  1.00 53.49           N  
ATOM     18  CA  VAL A   4     -51.195   1.249  -1.644  1.00 51.32           C  
ATOM     19  C   VAL A   4     -50.815   0.295  -2.767  1.00 51.54           C  
ATOM     20  O   VAL A   4     -50.176  -0.721  -2.515  1.00 50.91           O  
ATOM     21  CB  VAL A   4     -50.432   2.580  -1.810  1.00 50.15           C  
ATOM     22  CG1 VAL A   4     -50.601   3.417  -0.565  1.00 47.04           C  
ATOM     23  CG2 VAL A   4     -48.953   2.326  -2.091  1.00 49.07           C  
ATOM     24  N   GLU A   5     -51.224   0.595  -3.994  1.00 52.64           N  
ATOM     25  CA  GLU A   5     -50.883  -0.264  -5.122  1.00 54.72           C  
ATOM     26  C   GLU A   5     -49.566   0.179  -5.736  1.00 54.45           C  
ATOM     27  O   GLU A   5     -48.704  -0.655  -6.021  1.00 54.83           O  
ATOM     28  CB  GLU A   5     -51.979  -0.236  -6.183  1.00 56.24           C  
ATOM     29  CG  GLU A   5     -53.196  -1.081  -5.843  1.00 63.25           C  
ATOM     30  CD  GLU A   5     -52.868  -2.560  -5.717  1.00 66.95           C  
ATOM     31  OE1 GLU A   5     -52.108  -3.078  -6.571  1.00 69.14           O  
ATOM     32  OE2 GLU A   5     -53.377  -3.208  -4.777  1.00 67.13           O  
ATOM     33  N   HIS A   6     -49.421   1.492  -5.929  1.00 52.34           N  
ATOM     34  CA  HIS A   6     -48.213   2.080  -6.500  1.00 50.32           C  
ATOM     35  C   HIS A   6     -48.061   3.555  -6.141  1.00 49.61           C  
ATOM     36  O   HIS A   6     -49.035   4.305  -6.137  1.00 47.93           O  
ATOM     37  CB  HIS A   6     -48.223   1.999  -8.031  1.00 51.81           C  
ATOM     38  CG  HIS A   6     -48.345   0.613  -8.578  1.00 53.69           C  
ATOM     39  ND1 HIS A   6     -49.457   0.184  -9.269  1.00 54.07           N  
ATOM     40  CD2 HIS A   6     -47.477  -0.426  -8.578  1.00 54.72           C  
ATOM     41  CE1 HIS A   6     -49.269  -1.059  -9.672  1.00 55.03           C  
ATOM     42  NE2 HIS A   6     -48.074  -1.452  -9.266  1.00 55.52           N  
ATOM     43  N   TRP A   7     -46.832   3.970  -5.861  1.00 48.97           N  
ATOM     44  CA  TRP A   7     -46.548   5.369  -5.568  1.00 48.18           C  
ATOM     45  C   TRP A   7     -45.652   5.919  -6.675  1.00 48.80           C  
ATOM     46  O   TRP A   7     -45.087   6.996  -6.549  1.00 48.88           O  
ATOM     47  CB  TRP A   7     -45.835   5.519  -4.224  1.00 46.64           C  
ATOM     48  CG  TRP A   7     -44.781   4.470  -3.916  1.00 50.15           C  
ATOM     49  CD1 TRP A   7     -44.963   3.302  -3.221  1.00 49.37           C  
ATOM     50  CD2 TRP A   7     -43.382   4.529  -4.232  1.00 48.09           C  
ATOM     51  NE1 TRP A   7     -43.769   2.644  -3.076  1.00 48.95           N  
ATOM     52  CE2 TRP A   7     -42.781   3.369  -3.684  1.00 49.91           C  
ATOM     53  CE3 TRP A   7     -42.577   5.445  -4.919  1.00 45.96           C  
ATOM     54  CZ2 TRP A   7     -41.405   3.105  -3.802  1.00 50.50           C  
ATOM     55  CZ3 TRP A   7     -41.206   5.182  -5.037  1.00 47.66           C  
ATOM     56  CH2 TRP A   7     -40.636   4.023  -4.480  1.00 47.99           C  
ATOM     57  N   ASN A   8     -45.546   5.165  -7.766  1.00 50.09           N  
ATOM     58  CA  ASN A   8     -44.678   5.512  -8.889  1.00 51.75           C  
ATOM     59  C   ASN A   8     -45.464   5.720 -10.188  1.00 50.70           C  
ATOM     60  O   ASN A   8     -44.892   5.816 -11.273  1.00 52.16           O  
ATOM     61  CB  ASN A   8     -43.701   4.367  -9.098  1.00 55.94           C  
ATOM     62  CG  ASN A   8     -44.398   3.114  -9.586  1.00 59.17           C  
ATOM     63  OD1 ASN A   8     -44.904   2.315  -8.795  1.00 63.39           O  
ATOM     64  ND2 ASN A   8     -44.391   2.912 -10.897  1.00 62.06           N  
ATOM     65  N   THR A   9     -46.776   5.775 -10.071  1.00 47.33           N  
ATOM     66  CA  THR A   9     -47.639   5.931 -11.220  1.00 44.64           C  
ATOM     67  C   THR A   9     -47.802   7.368 -11.700  1.00 42.21           C  
ATOM     68  O   THR A   9     -47.538   8.320 -10.977  1.00 42.49           O  
ATOM     69  CB  THR A   9     -49.028   5.343 -10.903  1.00 44.28           C  
ATOM     70  OG1 THR A   9     -49.306   5.529  -9.511  1.00 41.96           O  
ATOM     71  CG2 THR A   9     -49.068   3.853 -11.224  1.00 44.78           C  
ATOM     72  N   LEU A  10     -48.240   7.504 -12.942  1.00 42.22           N  
ATOM     73  CA  LEU A  10     -48.480   8.805 -13.551  1.00 42.91           C  
ATOM     74  C   LEU A  10     -49.837   8.730 -14.232  1.00 40.04           C  
ATOM     75  O   LEU A  10     -50.266   7.663 -14.645  1.00 39.16           O  
ATOM     76  CB  LEU A  10     -47.434   9.122 -14.631  1.00 44.73           C  
ATOM     77  CG  LEU A  10     -45.943   9.287 -14.339  1.00 45.92           C  
ATOM     78  CD1 LEU A  10     -45.214   9.296 -15.676  1.00 50.10           C  
ATOM     79  CD2 LEU A  10     -45.667  10.580 -13.585  1.00 46.49           C  
ATOM     80  N   ARG A  11     -50.490   9.878 -14.359  1.00 40.28           N  
ATOM     81  CA  ARG A  11     -51.779   9.987 -15.025  1.00 38.36           C  
ATOM     82  C   ARG A  11     -51.519  10.646 -16.383  1.00 36.52           C  
ATOM     83  O   ARG A  11     -51.037  11.769 -16.448  1.00 35.39           O  
ATOM     84  CB  ARG A  11     -52.714  10.861 -14.184  1.00 38.36           C  
ATOM     85  CG  ARG A  11     -53.955  11.372 -14.906  1.00 39.37           C  
ATOM     86  CD  ARG A  11     -54.944  11.971 -13.903  1.00 38.03           C  
ATOM     87  NE  ARG A  11     -55.723  10.926 -13.228  1.00 36.32           N  
ATOM     88  CZ  ARG A  11     -55.562  10.538 -11.967  1.00 29.26           C  
ATOM     89  NH1 ARG A  11     -54.646  11.091 -11.191  1.00 30.67           N  
ATOM     90  NH2 ARG A  11     -56.352   9.606 -11.470  1.00 30.22           N  
ATOM     91  N   LEU A  12     -51.822   9.938 -17.459  1.00 35.82           N  
ATOM     92  CA  LEU A  12     -51.617  10.463 -18.801  1.00 40.57           C  
ATOM     93  C   LEU A  12     -52.965  10.968 -19.320  1.00 41.15           C  
ATOM     94  O   LEU A  12     -53.966  10.261 -19.221  1.00 41.10           O  
ATOM     95  CB  LEU A  12     -51.069   9.355 -19.730  1.00 40.01           C  
ATOM     96  CG  LEU A  12     -50.839   9.661 -21.217  1.00 42.68           C  
ATOM     97  CD1 LEU A  12     -49.776  10.756 -21.320  1.00 42.98           C  
ATOM     98  CD2 LEU A  12     -50.412   8.445 -22.011  1.00 44.21           C  
ATOM     99  N   ARG A  13     -53.002  12.183 -19.857  1.00 41.86           N  
ATOM    100  CA  ARG A  13     -54.256  12.708 -20.397  1.00 45.51           C  
ATOM    101  C   ARG A  13     -54.092  13.188 -21.828  1.00 45.93           C  
ATOM    102  O   ARG A  13     -53.328  14.106 -22.123  1.00 44.55           O  
ATOM    103  CB  ARG A  13     -54.836  13.834 -19.512  1.00 48.10           C  
ATOM    104  CG  ARG A  13     -55.667  13.316 -18.315  1.00 48.68           C  
ATOM    105  CD  ARG A  13     -56.209  14.419 -17.422  1.00 49.74           C  
ATOM    106  NE  ARG A  13     -55.366  14.642 -16.250  1.00 54.52           N  
ATOM    107  CZ  ARG A  13     -55.758  15.287 -15.151  1.00 55.79           C  
ATOM    108  NH1 ARG A  13     -56.986  15.784 -15.063  1.00 54.78           N  
ATOM    109  NH2 ARG A  13     -54.925  15.427 -14.133  1.00 56.42           N  
ATOM    110  N   ILE A  14     -54.843  12.544 -22.705  1.00 46.66           N  
ATOM    111  CA  ILE A  14     -54.821  12.830 -24.117  1.00 47.54           C  
ATOM    112  C   ILE A  14     -56.092  13.573 -24.525  1.00 49.02           C  
ATOM    113  O   ILE A  14     -57.193  13.014 -24.490  1.00 49.54           O  
ATOM    114  CB  ILE A  14     -54.712  11.508 -24.897  1.00 47.74           C  
ATOM    115  CG1 ILE A  14     -53.546  10.693 -24.323  1.00 44.80           C  
ATOM    116  CG2 ILE A  14     -54.541  11.785 -26.390  1.00 46.35           C  
ATOM    117  CD1 ILE A  14     -53.623   9.210 -24.601  1.00 45.06           C  
ATOM    118  N   TYR A  15     -55.920  14.831 -24.917  1.00 47.82           N  
ATOM    119  CA  TYR A  15     -57.017  15.676 -25.346  1.00 49.23           C  
ATOM    120  C   TYR A  15     -57.073  15.752 -26.864  1.00 51.28           C  
ATOM    121  O   TYR A  15     -56.156  16.267 -27.494  1.00 54.64           O  
ATOM    122  CB  TYR A  15     -56.833  17.089 -24.802  1.00 47.54           C  
ATOM    123  CG  TYR A  15     -56.840  17.195 -23.300  1.00 47.89           C  
ATOM    124  CD1 TYR A  15     -55.839  16.609 -22.533  1.00 46.72           C  
ATOM    125  CD2 TYR A  15     -57.841  17.907 -22.641  1.00 48.19           C  
ATOM    126  CE1 TYR A  15     -55.834  16.737 -21.150  1.00 47.21           C  
ATOM    127  CE2 TYR A  15     -57.844  18.038 -21.256  1.00 45.37           C  
ATOM    128  CZ  TYR A  15     -56.843  17.457 -20.520  1.00 45.33           C  
ATOM    129  OH  TYR A  15     -56.843  17.611 -19.157  1.00 45.57           O  
ATOM    130  N   ILE A  16     -58.150  15.255 -27.452  1.00 52.87           N  
ATOM    131  CA  ILE A  16     -58.310  15.290 -28.895  1.00 54.22           C  
ATOM    132  C   ILE A  16     -59.699  15.787 -29.272  1.00 56.39           C  
ATOM    133  O   ILE A  16     -60.425  16.350 -28.445  1.00 57.10           O  
ATOM    134  CB  ILE A  16     -58.093  13.897 -29.518  1.00 54.52           C  
ATOM    135  CG1 ILE A  16     -58.886  12.849 -28.738  1.00 55.51           C  
ATOM    136  CG2 ILE A  16     -56.604  13.570 -29.553  1.00 56.15           C  
ATOM    137  CD1 ILE A  16     -58.786  11.448 -29.303  1.00 57.04           C  
ATOM    138  N   GLY A  17     -60.060  15.583 -30.532  1.00 57.98           N  
ATOM    139  CA  GLY A  17     -61.354  16.013 -31.011  1.00 57.87           C  
ATOM    140  C   GLY A  17     -62.190  14.801 -31.362  1.00 58.46           C  
ATOM    141  O   GLY A  17     -61.712  13.880 -32.024  1.00 58.77           O  
ATOM    142  N   GLU A  18     -63.436  14.806 -30.901  1.00 59.43           N  
ATOM    143  CA  GLU A  18     -64.379  13.726 -31.149  1.00 62.92           C  
ATOM    144  C   GLU A  18     -64.389  13.361 -32.635  1.00 64.96           C  
ATOM    145  O   GLU A  18     -64.546  12.197 -33.003  1.00 64.52           O  
ATOM    146  CB  GLU A  18     -65.795  14.150 -30.679  1.00 62.41           C  
ATOM    147  CG  GLU A  18     -66.901  13.086 -30.813  1.00 64.17           C  
ATOM    148  CD  GLU A  18     -68.270  13.503 -30.291  1.00 64.67           C  
ATOM    149  OE1 GLU A  18     -68.597  14.702 -30.272  1.00 65.86           O  
ATOM    150  OE2 GLU A  18     -69.032  12.591 -29.925  1.00 66.71           O  
ATOM    151  N   ASN A  19     -64.198  14.367 -33.481  1.00 68.25           N  
ATOM    152  CA  ASN A  19     -64.214  14.172 -34.925  1.00 71.79           C  
ATOM    153  C   ASN A  19     -62.855  13.846 -35.544  1.00 72.83           C  
ATOM    154  O   ASN A  19     -62.775  13.515 -36.731  1.00 72.35           O  
ATOM    155  CB  ASN A  19     -64.826  15.401 -35.589  1.00 74.04           C  
ATOM    156  CG  ASN A  19     -66.227  15.682 -35.072  1.00 77.06           C  
ATOM    157  OD1 ASN A  19     -67.160  14.948 -35.394  1.00 78.59           O  
ATOM    158  ND2 ASN A  19     -66.385  16.720 -34.270  1.00 77.34           N  
ATOM    159  N   ASP A  20     -61.790  13.939 -34.749  1.00 74.03           N  
ATOM    160  CA  ASP A  20     -60.453  13.621 -35.234  1.00 75.96           C  
ATOM    161  C   ASP A  20     -60.463  12.174 -35.701  1.00 77.88           C  
ATOM    162  O   ASP A  20     -61.011  11.291 -35.034  1.00 77.71           O  
ATOM    163  CB  ASP A  20     -59.414  13.808 -34.130  1.00 75.70           C  
ATOM    164  CG  ASP A  20     -59.274  15.254 -33.705  1.00 75.01           C  
ATOM    165  OD1 ASP A  20     -59.788  16.142 -34.422  1.00 75.98           O  
ATOM    166  OD2 ASP A  20     -58.642  15.508 -32.660  1.00 73.26           O  
ATOM    167  N   LYS A  21     -59.843  11.936 -36.848  1.00 80.15           N  
ATOM    168  CA  LYS A  21     -59.824  10.611 -37.440  1.00 82.08           C  
ATOM    169  C   LYS A  21     -58.403  10.117 -37.730  1.00 82.81           C  
ATOM    170  O   LYS A  21     -57.452  10.895 -37.733  1.00 81.97           O  
ATOM    171  CB  LYS A  21     -60.674  10.651 -38.723  1.00 83.58           C  
ATOM    172  CG  LYS A  21     -61.412  12.002 -38.905  1.00 84.81           C  
ATOM    173  CD  LYS A  21     -62.598  11.941 -39.867  1.00 86.56           C  
ATOM    174  CE  LYS A  21     -62.228  12.073 -41.322  1.00 87.54           C  
ATOM    175  NZ  LYS A  21     -63.108  11.325 -42.241  1.00 88.06           N  
ATOM    176  N   TRP A  22     -58.266   8.812 -37.950  1.00 84.57           N  
ATOM    177  CA  TRP A  22     -56.970   8.214 -38.258  1.00 86.59           C  
ATOM    178  C   TRP A  22     -57.169   7.034 -39.196  1.00 87.27           C  
ATOM    179  O   TRP A  22     -57.813   6.044 -38.838  1.00 86.81           O  
ATOM    180  CB  TRP A  22     -56.265   7.750 -36.984  1.00 87.59           C  
ATOM    181  CG  TRP A  22     -54.901   7.208 -37.247  1.00 88.63           C  
ATOM    182  CD1 TRP A  22     -54.534   5.894 -37.304  1.00 89.01           C  
ATOM    183  CD2 TRP A  22     -53.717   7.967 -37.510  1.00 88.82           C  
ATOM    184  NE1 TRP A  22     -53.192   5.788 -37.584  1.00 88.77           N  
ATOM    185  CE2 TRP A  22     -52.667   7.047 -37.716  1.00 89.42           C  
ATOM    186  CE3 TRP A  22     -53.442   9.341 -37.593  1.00 89.29           C  
ATOM    187  CZ2 TRP A  22     -51.356   7.454 -37.999  1.00 90.02           C  
ATOM    188  CZ3 TRP A  22     -52.139   9.746 -37.874  1.00 89.87           C  
ATOM    189  CH2 TRP A  22     -51.112   8.802 -38.072  1.00 90.38           C  
ATOM    190  N   GLU A  23     -56.610   7.149 -40.398  1.00 88.18           N  
ATOM    191  CA  GLU A  23     -56.741   6.114 -41.415  1.00 89.00           C  
ATOM    192  C   GLU A  23     -58.210   5.780 -41.656  1.00 88.80           C  
ATOM    193  O   GLU A  23     -58.538   4.677 -42.091  1.00 89.37           O  
ATOM    194  CB  GLU A  23     -55.984   4.849 -41.009  1.00 89.80           C  
ATOM    195  CG  GLU A  23     -54.474   4.946 -41.165  1.00 91.23           C  
ATOM    196  CD  GLU A  23     -53.783   3.612 -40.942  1.00 91.97           C  
ATOM    197  OE1 GLU A  23     -54.123   2.637 -41.650  1.00 91.62           O  
ATOM    198  OE2 GLU A  23     -52.899   3.539 -40.061  1.00 92.60           O  
ATOM    199  N   GLY A  24     -59.086   6.739 -41.360  1.00 88.19           N  
ATOM    200  CA  GLY A  24     -60.510   6.536 -41.564  1.00 86.93           C  
ATOM    201  C   GLY A  24     -61.355   6.313 -40.320  1.00 86.21           C  
ATOM    202  O   GLY A  24     -62.582   6.410 -40.391  1.00 86.16           O  
ATOM    203  N   ARG A  25     -60.716   6.016 -39.187  1.00 84.62           N  
ATOM    204  CA  ARG A  25     -61.432   5.772 -37.929  1.00 82.65           C  
ATOM    205  C   ARG A  25     -61.284   6.898 -36.906  1.00 79.72           C  
ATOM    206  O   ARG A  25     -60.474   7.805 -37.085  1.00 80.44           O  
ATOM    207  CB  ARG A  25     -60.962   4.450 -37.302  1.00 84.85           C  
ATOM    208  CG  ARG A  25     -61.490   3.217 -38.018  1.00 87.23           C  
ATOM    209  CD  ARG A  25     -61.223   1.907 -37.266  1.00 89.35           C  
ATOM    210  NE  ARG A  25     -62.376   1.033 -37.450  1.00 91.98           N  
ATOM    211  CZ  ARG A  25     -62.633  -0.088 -36.783  1.00 92.64           C  
ATOM    212  NH1 ARG A  25     -61.805  -0.533 -35.845  1.00 93.01           N  
ATOM    213  NH2 ARG A  25     -63.772  -0.750 -37.047  1.00 92.42           N  
ATOM    214  N   PRO A  26     -62.092   6.865 -35.829  1.00 77.17           N  
ATOM    215  CA  PRO A  26     -62.043   7.883 -34.773  1.00 74.39           C  
ATOM    216  C   PRO A  26     -60.729   7.776 -34.010  1.00 71.71           C  
ATOM    217  O   PRO A  26     -60.392   6.718 -33.483  1.00 69.29           O  
ATOM    218  CB  PRO A  26     -63.243   7.531 -33.895  1.00 75.74           C  
ATOM    219  CG  PRO A  26     -64.195   6.906 -34.856  1.00 75.91           C  
ATOM    220  CD  PRO A  26     -63.283   6.014 -35.664  1.00 76.72           C  
ATOM    221  N   LEU A  27     -59.996   8.880 -33.948  1.00 71.15           N  
ATOM    222  CA  LEU A  27     -58.707   8.912 -33.274  1.00 69.89           C  
ATOM    223  C   LEU A  27     -58.719   8.338 -31.858  1.00 68.12           C  
ATOM    224  O   LEU A  27     -57.739   7.737 -31.432  1.00 67.49           O  
ATOM    225  CB  LEU A  27     -58.174  10.346 -33.235  1.00 71.15           C  
ATOM    226  CG  LEU A  27     -56.781  10.580 -32.637  1.00 71.85           C  
ATOM    227  CD1 LEU A  27     -55.761   9.853 -33.491  1.00 72.70           C  
ATOM    228  CD2 LEU A  27     -56.450  12.055 -32.577  1.00 72.89           C  
ATOM    229  N   TYR A  28     -59.811   8.510 -31.117  1.00 66.69           N  
ATOM    230  CA  TYR A  28     -59.827   7.988 -29.757  1.00 64.89           C  
ATOM    231  C   TYR A  28     -60.034   6.482 -29.726  1.00 64.44           C  
ATOM    232  O   TYR A  28     -59.446   5.788 -28.897  1.00 63.27           O  
ATOM    233  CB  TYR A  28     -60.868   8.720 -28.896  1.00 65.15           C  
ATOM    234  CG  TYR A  28     -62.321   8.437 -29.203  1.00 64.51           C  
ATOM    235  CD1 TYR A  28     -63.009   7.405 -28.556  1.00 63.11           C  
ATOM    236  CD2 TYR A  28     -63.022   9.227 -30.116  1.00 64.80           C  
ATOM    237  CE1 TYR A  28     -64.360   7.170 -28.810  1.00 63.36           C  
ATOM    238  CE2 TYR A  28     -64.367   9.001 -30.377  1.00 64.55           C  
ATOM    239  CZ  TYR A  28     -65.031   7.975 -29.724  1.00 64.84           C  
ATOM    240  OH  TYR A  28     -66.362   7.755 -29.998  1.00 65.66           O  
ATOM    241  N   LYS A  29     -60.856   5.971 -30.636  1.00 64.93           N  
ATOM    242  CA  LYS A  29     -61.093   4.537 -30.708  1.00 64.85           C  
ATOM    243  C   LYS A  29     -59.798   3.831 -31.112  1.00 64.80           C  
ATOM    244  O   LYS A  29     -59.513   2.731 -30.634  1.00 64.10           O  
ATOM    245  CB  LYS A  29     -62.195   4.221 -31.726  1.00 65.05           C  
ATOM    246  CG  LYS A  29     -63.595   4.679 -31.321  1.00 67.03           C  
ATOM    247  CD  LYS A  29     -64.624   4.317 -32.390  1.00 67.47           C  
ATOM    248  CE  LYS A  29     -66.007   4.858 -32.056  1.00 67.84           C  
ATOM    249  NZ  LYS A  29     -66.904   4.871 -33.243  1.00 68.65           N  
ATOM    250  N   VAL A  30     -59.013   4.464 -31.986  1.00 65.29           N  
ATOM    251  CA  VAL A  30     -57.753   3.871 -32.444  1.00 65.49           C  
ATOM    252  C   VAL A  30     -56.726   3.853 -31.317  1.00 65.07           C  
ATOM    253  O   VAL A  30     -56.030   2.857 -31.111  1.00 64.64           O  
ATOM    254  CB  VAL A  30     -57.154   4.635 -33.673  1.00 65.37           C  
ATOM    255  CG1 VAL A  30     -56.764   6.046 -33.298  1.00 64.73           C  
ATOM    256  CG2 VAL A  30     -55.925   3.876 -34.188  1.00 65.14           C  
ATOM    257  N   ILE A  31     -56.644   4.955 -30.580  1.00 63.98           N  
ATOM    258  CA  ILE A  31     -55.713   5.045 -29.466  1.00 62.88           C  
ATOM    259  C   ILE A  31     -56.022   3.980 -28.424  1.00 63.10           C  
ATOM    260  O   ILE A  31     -55.142   3.225 -28.016  1.00 61.85           O  
ATOM    261  CB  ILE A  31     -55.789   6.424 -28.801  1.00 62.48           C  
ATOM    262  CG1 ILE A  31     -55.175   7.474 -29.727  1.00 62.04           C  
ATOM    263  CG2 ILE A  31     -55.094   6.388 -27.454  1.00 62.97           C  
ATOM    264  CD1 ILE A  31     -55.149   8.859 -29.145  1.00 61.29           C  
ATOM    265  N   VAL A  32     -57.279   3.919 -27.997  1.00 63.26           N  
ATOM    266  CA  VAL A  32     -57.680   2.939 -26.997  1.00 65.25           C  
ATOM    267  C   VAL A  32     -57.339   1.522 -27.443  1.00 65.84           C  
ATOM    268  O   VAL A  32     -56.930   0.690 -26.631  1.00 65.05           O  
ATOM    269  CB  VAL A  32     -59.188   3.035 -26.692  1.00 65.16           C  
ATOM    270  CG1 VAL A  32     -59.609   1.897 -25.776  1.00 64.05           C  
ATOM    271  CG2 VAL A  32     -59.492   4.374 -26.034  1.00 64.48           C  
ATOM    272  N   GLU A  33     -57.516   1.252 -28.734  1.00 67.88           N  
ATOM    273  CA  GLU A  33     -57.212  -0.059 -29.298  1.00 69.54           C  
ATOM    274  C   GLU A  33     -55.732  -0.316 -29.034  1.00 68.84           C  
ATOM    275  O   GLU A  33     -55.350  -1.344 -28.472  1.00 68.47           O  
ATOM    276  CB  GLU A  33     -57.490  -0.052 -30.804  1.00 71.97           C  
ATOM    277  CG  GLU A  33     -57.861  -1.409 -31.386  1.00 76.15           C  
ATOM    278  CD  GLU A  33     -58.267  -1.331 -32.852  1.00 79.51           C  
ATOM    279  OE1 GLU A  33     -59.148  -0.508 -33.193  1.00 81.18           O  
ATOM    280  OE2 GLU A  33     -57.710  -2.101 -33.666  1.00 80.55           O  
ATOM    281  N   LYS A  34     -54.905   0.642 -29.435  1.00 69.22           N  
ATOM    282  CA  LYS A  34     -53.466   0.560 -29.232  1.00 70.19           C  
ATOM    283  C   LYS A  34     -53.175   0.243 -27.765  1.00 70.77           C  
ATOM    284  O   LYS A  34     -52.599  -0.802 -27.452  1.00 70.98           O  
ATOM    285  CB  LYS A  34     -52.814   1.891 -29.610  1.00 70.86           C  
ATOM    286  CG  LYS A  34     -52.984   2.287 -31.073  1.00 73.04           C  
ATOM    287  CD  LYS A  34     -52.490   1.176 -31.987  1.00 74.51           C  
ATOM    288  CE  LYS A  34     -52.344   1.594 -33.437  1.00 76.19           C  
ATOM    289  NZ  LYS A  34     -52.208   0.396 -34.299  1.00 78.59           N  
ATOM    290  N   LEU A  35     -53.595   1.149 -26.882  1.00 70.19           N  
ATOM    291  CA  LEU A  35     -53.399   1.015 -25.442  1.00 70.11           C  
ATOM    292  C   LEU A  35     -53.754  -0.374 -24.929  1.00 71.34           C  
ATOM    293  O   LEU A  35     -53.112  -0.892 -24.015  1.00 71.65           O  
ATOM    294  CB  LEU A  35     -54.260   2.036 -24.697  1.00 68.40           C  
ATOM    295  CG  LEU A  35     -54.102   3.525 -25.012  1.00 67.33           C  
ATOM    296  CD1 LEU A  35     -55.260   4.293 -24.381  1.00 66.63           C  
ATOM    297  CD2 LEU A  35     -52.770   4.037 -24.495  1.00 65.81           C  
ATOM    298  N   ARG A  36     -54.780  -0.974 -25.519  1.00 72.27           N  
ATOM    299  CA  ARG A  36     -55.227  -2.290 -25.093  1.00 74.69           C  
ATOM    300  C   ARG A  36     -54.328  -3.396 -25.633  1.00 75.75           C  
ATOM    301  O   ARG A  36     -54.201  -4.463 -25.031  1.00 75.57           O  
ATOM    302  CB  ARG A  36     -56.674  -2.508 -25.546  1.00 75.90           C  
ATOM    303  CG  ARG A  36     -57.547  -3.226 -24.526  1.00 77.75           C  
ATOM    304  CD  ARG A  36     -59.020  -2.934 -24.771  1.00 79.66           C  
ATOM    305  NE  ARG A  36     -59.477  -3.432 -26.065  1.00 82.45           N  
ATOM    306  CZ  ARG A  36     -60.216  -2.731 -26.919  1.00 84.27           C  
ATOM    307  NH1 ARG A  36     -60.586  -1.491 -26.618  1.00 85.10           N  
ATOM    308  NH2 ARG A  36     -60.590  -3.270 -28.072  1.00 84.82           N  
ATOM    309  N   GLU A  37     -53.688  -3.136 -26.766  1.00 76.37           N  
ATOM    310  CA  GLU A  37     -52.813  -4.135 -27.359  1.00 78.31           C  
ATOM    311  C   GLU A  37     -51.367  -3.999 -26.863  1.00 77.80           C  
ATOM    312  O   GLU A  37     -50.554  -4.908 -27.032  1.00 77.92           O  
ATOM    313  CB  GLU A  37     -52.903  -4.054 -28.889  1.00 80.35           C  
ATOM    314  CG  GLU A  37     -54.331  -4.287 -29.393  1.00 83.04           C  
ATOM    315  CD  GLU A  37     -54.492  -4.293 -30.892  1.00 85.13           C  
ATOM    316  OE1 GLU A  37     -53.941  -3.359 -31.523  1.00 85.74           O  
ATOM    317  OE2 GLU A  37     -55.159  -5.181 -31.453  1.00 85.26           O  
ATOM    318  N   MET A  38     -51.048  -2.860 -26.252  1.00 76.56           N  
ATOM    319  CA  MET A  38     -49.709  -2.636 -25.704  1.00 74.84           C  
ATOM    320  C   MET A  38     -49.681  -3.132 -24.262  1.00 73.84           C  
ATOM    321  O   MET A  38     -48.650  -3.077 -23.594  1.00 74.15           O  
ATOM    322  CB  MET A  38     -49.353  -1.149 -25.733  1.00 74.02           C  
ATOM    323  CG  MET A  38     -49.024  -0.609 -27.102  1.00 74.74           C  
ATOM    324  SD  MET A  38     -48.923   1.321 -27.114  1.00 75.96           S  
ATOM    325  CE  MET A  38     -47.096   1.577 -26.536  1.00 76.82           C  
ATOM    326  N   GLY A  39     -50.831  -3.604 -23.784  1.00 73.32           N  
ATOM    327  CA  GLY A  39     -50.934  -4.108 -22.424  1.00 70.97           C  
ATOM    328  C   GLY A  39     -50.951  -3.058 -21.320  1.00 69.08           C  
ATOM    329  O   GLY A  39     -50.449  -3.313 -20.226  1.00 68.28           O  
ATOM    330  N   ILE A  40     -51.528  -1.888 -21.593  1.00 67.30           N  
ATOM    331  CA  ILE A  40     -51.599  -0.822 -20.592  1.00 65.61           C  
ATOM    332  C   ILE A  40     -52.583  -1.161 -19.470  1.00 63.90           C  
ATOM    333  O   ILE A  40     -53.581  -1.851 -19.691  1.00 63.43           O  
ATOM    334  CB  ILE A  40     -51.986   0.535 -21.245  1.00 66.01           C  
ATOM    335  CG1 ILE A  40     -50.775   1.118 -21.978  1.00 65.68           C  
ATOM    336  CG2 ILE A  40     -52.449   1.531 -20.194  1.00 66.40           C  
ATOM    337  CD1 ILE A  40     -50.402   0.374 -23.219  1.00 65.59           C  
ATOM    338  N   ALA A  41     -52.283  -0.675 -18.266  1.00 61.94           N  
ATOM    339  CA  ALA A  41     -53.109  -0.930 -17.081  1.00 60.83           C  
ATOM    340  C   ALA A  41     -54.597  -0.771 -17.358  1.00 58.81           C  
ATOM    341  O   ALA A  41     -55.399  -1.645 -17.022  1.00 60.76           O  
ATOM    342  CB  ALA A  41     -52.683  -0.006 -15.932  1.00 58.97           C  
ATOM    343  N   GLY A  42     -54.960   0.344 -17.974  1.00 56.92           N  
ATOM    344  CA  GLY A  42     -56.351   0.600 -18.290  1.00 55.34           C  
ATOM    345  C   GLY A  42     -56.498   1.991 -18.857  1.00 53.72           C  
ATOM    346  O   GLY A  42     -55.507   2.702 -19.034  1.00 54.60           O  
ATOM    347  N   ALA A  43     -57.731   2.387 -19.141  1.00 51.61           N  
ATOM    348  CA  ALA A  43     -57.985   3.709 -19.689  1.00 49.74           C  
ATOM    349  C   ALA A  43     -59.424   4.132 -19.429  1.00 48.16           C  
ATOM    350  O   ALA A  43     -60.309   3.296 -19.273  1.00 48.09           O  
ATOM    351  CB  ALA A  43     -57.708   3.717 -21.180  1.00 49.01           C  
ATOM    352  N   THR A  44     -59.652   5.443 -19.376  1.00 47.12           N  
ATOM    353  CA  THR A  44     -60.997   5.982 -19.170  1.00 45.97           C  
ATOM    354  C   THR A  44     -61.142   7.132 -20.167  1.00 44.45           C  
ATOM    355  O   THR A  44     -60.305   8.030 -20.204  1.00 43.51           O  
ATOM    356  CB  THR A  44     -61.228   6.436 -17.700  1.00 44.69           C  
ATOM    357  OG1 THR A  44     -61.189   5.308 -16.827  1.00 45.58           O  
ATOM    358  CG2 THR A  44     -62.547   7.155 -17.517  1.00 42.45           C  
ATOM    359  N   VAL A  45     -62.200   7.099 -20.980  1.00 44.84           N  
ATOM    360  CA  VAL A  45     -62.436   8.161 -21.958  1.00 47.08           C  
ATOM    361  C   VAL A  45     -63.609   9.057 -21.571  1.00 47.25           C  
ATOM    362  O   VAL A  45     -64.675   8.569 -21.198  1.00 47.00           O  
ATOM    363  CB  VAL A  45     -62.725   7.589 -23.373  1.00 47.45           C  
ATOM    364  CG1 VAL A  45     -62.943   8.726 -24.358  1.00 46.82           C  
ATOM    365  CG2 VAL A  45     -61.574   6.711 -23.842  1.00 50.57           C  
ATOM    366  N   TYR A  46     -63.397  10.365 -21.683  1.00 48.25           N  
ATOM    367  CA  TYR A  46     -64.422  11.348 -21.369  1.00 50.66           C  
ATOM    368  C   TYR A  46     -64.741  12.186 -22.585  1.00 52.04           C  
ATOM    369  O   TYR A  46     -63.907  12.355 -23.474  1.00 53.66           O  
ATOM    370  CB  TYR A  46     -63.965  12.329 -20.293  1.00 49.89           C  
ATOM    371  CG  TYR A  46     -63.441  11.751 -19.012  1.00 50.45           C  
ATOM    372  CD1 TYR A  46     -62.161  11.193 -18.944  1.00 48.64           C  
ATOM    373  CD2 TYR A  46     -64.182  11.858 -17.833  1.00 49.10           C  
ATOM    374  CE1 TYR A  46     -61.626  10.773 -17.730  1.00 48.25           C  
ATOM    375  CE2 TYR A  46     -63.662  11.441 -16.617  1.00 49.55           C  
ATOM    376  CZ  TYR A  46     -62.382  10.907 -16.569  1.00 50.45           C  
ATOM    377  OH  TYR A  46     -61.845  10.567 -15.352  1.00 49.59           O  
ATOM    378  N   ARG A  47     -65.940  12.747 -22.597  1.00 52.11           N  
ATOM    379  CA  ARG A  47     -66.361  13.601 -23.685  1.00 52.74           C  
ATOM    380  C   ARG A  47     -66.880  14.879 -23.032  1.00 52.77           C  
ATOM    381  O   ARG A  47     -67.866  14.848 -22.303  1.00 52.67           O  
ATOM    382  CB  ARG A  47     -67.457  12.917 -24.487  1.00 54.70           C  
ATOM    383  CG  ARG A  47     -67.883  13.694 -25.707  1.00 57.91           C  
ATOM    384  CD  ARG A  47     -69.151  13.057 -26.253  1.00 60.51           C  
ATOM    385  NE  ARG A  47     -68.905  11.921 -27.141  1.00 65.56           N  
ATOM    386  CZ  ARG A  47     -69.801  10.962 -27.356  1.00 67.26           C  
ATOM    387  NH1 ARG A  47     -70.953  11.045 -26.710  1.00 68.96           N  
ATOM    388  NH2 ARG A  47     -69.599   9.968 -28.235  1.00 69.34           N  
ATOM    389  N   GLY A  48     -66.186  15.992 -23.253  1.00 52.18           N  
ATOM    390  CA  GLY A  48     -66.609  17.245 -22.664  1.00 50.64           C  
ATOM    391  C   GLY A  48     -67.848  17.725 -23.384  1.00 50.50           C  
ATOM    392  O   GLY A  48     -68.290  17.092 -24.343  1.00 49.16           O  
ATOM    393  N   ILE A  49     -68.419  18.831 -22.924  1.00 50.46           N  
ATOM    394  CA  ILE A  49     -69.609  19.367 -23.572  1.00 51.06           C  
ATOM    395  C   ILE A  49     -69.151  20.473 -24.513  1.00 51.61           C  
ATOM    396  O   ILE A  49     -69.824  20.808 -25.481  1.00 52.31           O  
ATOM    397  CB  ILE A  49     -70.629  19.921 -22.540  1.00 49.66           C  
ATOM    398  CG1 ILE A  49     -69.967  20.975 -21.655  1.00 48.36           C  
ATOM    399  CG2 ILE A  49     -71.176  18.785 -21.692  1.00 46.76           C  
ATOM    400  CD1 ILE A  49     -70.931  21.698 -20.746  1.00 50.32           C  
ATOM    401  N   TYR A  50     -67.980  21.023 -24.226  1.00 52.88           N  
ATOM    402  CA  TYR A  50     -67.417  22.074 -25.057  1.00 54.52           C  
ATOM    403  C   TYR A  50     -65.933  22.213 -24.793  1.00 54.74           C  
ATOM    404  O   TYR A  50     -65.453  21.946 -23.691  1.00 55.51           O  
ATOM    405  CB  TYR A  50     -68.085  23.425 -24.779  1.00 55.84           C  
ATOM    406  CG  TYR A  50     -67.415  24.587 -25.496  1.00 57.83           C  
ATOM    407  CD1 TYR A  50     -67.575  24.774 -26.872  1.00 60.06           C  
ATOM    408  CD2 TYR A  50     -66.587  25.471 -24.810  1.00 58.52           C  
ATOM    409  CE1 TYR A  50     -66.924  25.807 -27.540  1.00 58.77           C  
ATOM    410  CE2 TYR A  50     -65.935  26.505 -25.467  1.00 58.96           C  
ATOM    411  CZ  TYR A  50     -66.104  26.667 -26.828  1.00 60.35           C  
ATOM    412  OH  TYR A  50     -65.439  27.684 -27.478  1.00 62.66           O  
ATOM    413  N   GLY A  51     -65.216  22.647 -25.818  1.00 55.41           N  
ATOM    414  CA  GLY A  51     -63.792  22.855 -25.686  1.00 56.13           C  
ATOM    415  C   GLY A  51     -63.239  23.697 -26.822  1.00 56.67           C  
ATOM    416  O   GLY A  51     -63.836  23.784 -27.897  1.00 54.14           O  
ATOM    417  N   PHE A  52     -62.104  24.339 -26.570  1.00 57.21           N  
ATOM    418  CA  PHE A  52     -61.431  25.142 -27.580  1.00 59.42           C  
ATOM    419  C   PHE A  52     -59.945  25.092 -27.253  1.00 61.37           C  
ATOM    420  O   PHE A  52     -59.554  25.231 -26.090  1.00 62.93           O  
ATOM    421  CB  PHE A  52     -61.974  26.587 -27.593  1.00 58.22           C  
ATOM    422  CG  PHE A  52     -61.394  27.493 -26.540  1.00 56.65           C  
ATOM    423  CD1 PHE A  52     -60.133  28.059 -26.704  1.00 56.85           C  
ATOM    424  CD2 PHE A  52     -62.113  27.786 -25.388  1.00 56.52           C  
ATOM    425  CE1 PHE A  52     -59.599  28.923 -25.738  1.00 57.98           C  
ATOM    426  CE2 PHE A  52     -61.593  28.650 -24.410  1.00 56.82           C  
ATOM    427  CZ  PHE A  52     -60.327  29.213 -24.584  1.00 57.42           C  
ATOM    428  N   GLY A  53     -59.124  24.853 -28.271  1.00 63.65           N  
ATOM    429  CA  GLY A  53     -57.688  24.773 -28.062  1.00 64.43           C  
ATOM    430  C   GLY A  53     -56.901  25.625 -29.036  1.00 65.52           C  
ATOM    431  O   GLY A  53     -57.181  26.814 -29.202  1.00 66.70           O  
ATOM    432  N   THR A  68     -70.843  20.987 -33.731  1.00 85.76           N  
ATOM    433  CA  THR A  68     -69.433  21.269 -33.508  1.00 85.57           C  
ATOM    434  C   THR A  68     -68.681  20.085 -32.889  1.00 84.30           C  
ATOM    435  O   THR A  68     -69.236  19.041 -32.550  1.00 84.51           O  
ATOM    436  CB  THR A  68     -69.308  22.507 -32.612  1.00 86.98           C  
ATOM    437  OG1 THR A  68     -70.078  23.567 -33.184  1.00 88.78           O  
ATOM    438  CG2 THR A  68     -67.842  22.950 -32.537  1.00 87.65           C  
ATOM    439  N   ASP A  69     -67.353  20.290 -32.798  1.00 81.98           N  
ATOM    440  CA  ASP A  69     -66.419  19.293 -32.275  1.00 79.30           C  
ATOM    441  C   ASP A  69     -66.523  19.162 -30.752  1.00 75.64           C  
ATOM    442  O   ASP A  69     -66.456  20.138 -30.016  1.00 76.44           O  
ATOM    443  CB  ASP A  69     -65.028  19.832 -32.629  1.00 81.00           C  
ATOM    444  CG  ASP A  69     -64.070  18.721 -33.036  1.00 82.98           C  
ATOM    445  OD1 ASP A  69     -64.486  17.564 -33.034  1.00 83.16           O  
ATOM    446  OD2 ASP A  69     -62.920  19.028 -33.342  1.00 83.94           O  
ATOM    447  N   LEU A  70     -66.724  17.912 -30.271  1.00 70.15           N  
ATOM    448  CA  LEU A  70     -66.686  17.660 -28.822  1.00 63.69           C  
ATOM    449  C   LEU A  70     -65.307  17.136 -28.397  1.00 58.97           C  
ATOM    450  O   LEU A  70     -64.748  16.221 -28.991  1.00 57.59           O  
ATOM    451  CB  LEU A  70     -67.718  16.570 -28.522  1.00 63.20           C  
ATOM    452  CG  LEU A  70     -69.160  17.077 -28.477  1.00 63.07           C  
ATOM    453  CD1 LEU A  70     -70.080  16.098 -27.748  1.00 61.51           C  
ATOM    454  CD2 LEU A  70     -69.303  18.422 -27.767  1.00 61.38           C  
ATOM    455  N   PRO A  71     -64.742  17.746 -27.336  1.00 55.45           N  
ATOM    456  CA  PRO A  71     -63.439  17.329 -26.838  1.00 53.88           C  
ATOM    457  C   PRO A  71     -63.501  15.905 -26.316  1.00 52.74           C  
ATOM    458  O   PRO A  71     -64.452  15.503 -25.659  1.00 52.29           O  
ATOM    459  CB  PRO A  71     -63.042  18.255 -25.702  1.00 53.39           C  
ATOM    460  CG  PRO A  71     -64.270  19.075 -25.306  1.00 54.33           C  
ATOM    461  CD  PRO A  71     -65.272  18.828 -26.526  1.00 55.21           C  
ATOM    462  N   ILE A  72     -62.473  15.134 -26.628  1.00 52.32           N  
ATOM    463  CA  ILE A  72     -62.409  13.764 -26.164  1.00 50.86           C  
ATOM    464  C   ILE A  72     -61.107  13.629 -25.401  1.00 50.57           C  
ATOM    465  O   ILE A  72     -60.038  13.978 -25.899  1.00 51.68           O  
ATOM    466  CB  ILE A  72     -62.467  12.806 -27.359  1.00 50.92           C  
ATOM    467  CG1 ILE A  72     -63.875  12.821 -27.960  1.00 52.99           C  
ATOM    468  CG2 ILE A  72     -62.054  11.416 -26.933  1.00 51.89           C  
ATOM    469  CD1 ILE A  72     -64.670  11.515 -27.791  1.00 54.55           C  
ATOM    470  N   ILE A  73     -61.208  13.124 -24.180  1.00 49.41           N  
ATOM    471  CA  ILE A  73     -60.043  12.975 -23.323  1.00 46.91           C  
ATOM    472  C   ILE A  73     -59.856  11.497 -22.921  1.00 47.75           C  
ATOM    473  O   ILE A  73     -60.711  10.920 -22.265  1.00 47.62           O  
ATOM    474  CB  ILE A  73     -60.214  13.815 -22.014  1.00 46.77           C  
ATOM    475  CG1 ILE A  73     -60.329  15.308 -22.338  1.00 45.22           C  
ATOM    476  CG2 ILE A  73     -59.060  13.568 -21.069  1.00 43.35           C  
ATOM    477  CD1 ILE A  73     -61.680  15.705 -22.890  1.00 45.24           C  
ATOM    478  N   VAL A  74     -58.741  10.892 -23.344  1.00 47.50           N  
ATOM    479  CA  VAL A  74     -58.474   9.516 -22.943  1.00 46.03           C  
ATOM    480  C   VAL A  74     -57.516   9.676 -21.783  1.00 45.55           C  
ATOM    481  O   VAL A  74     -56.488  10.354 -21.904  1.00 46.17           O  
ATOM    482  CB  VAL A  74     -57.706   8.603 -23.914  1.00 47.41           C  
ATOM    483  CG1 VAL A  74     -57.504   7.225 -23.291  1.00 47.02           C  
ATOM    484  CG2 VAL A  74     -58.381   8.513 -25.249  1.00 48.61           C  
ATOM    485  N   GLU A  75     -57.841   9.020 -20.677  1.00 42.83           N  
ATOM    486  CA  GLU A  75     -57.013   9.104 -19.512  1.00 39.31           C  
ATOM    487  C   GLU A  75     -56.407   7.743 -19.241  1.00 39.37           C  
ATOM    488  O   GLU A  75     -57.088   6.725 -19.341  1.00 41.11           O  
ATOM    489  CB  GLU A  75     -57.847   9.554 -18.329  1.00 38.29           C  
ATOM    490  CG  GLU A  75     -57.099   9.557 -17.037  1.00 37.94           C  
ATOM    491  CD  GLU A  75     -57.948  10.003 -15.881  1.00 39.40           C  
ATOM    492  OE1 GLU A  75     -58.924   9.298 -15.558  1.00 41.07           O  
ATOM    493  OE2 GLU A  75     -57.632  11.058 -15.297  1.00 39.18           O  
ATOM    494  N   VAL A  76     -55.132   7.732 -18.880  1.00 38.40           N  
ATOM    495  CA  VAL A  76     -54.430   6.493 -18.602  1.00 38.17           C  
ATOM    496  C   VAL A  76     -53.547   6.648 -17.376  1.00 37.76           C  
ATOM    497  O   VAL A  76     -52.761   7.586 -17.289  1.00 37.79           O  
ATOM    498  CB  VAL A  76     -53.549   6.099 -19.815  1.00 39.37           C  
ATOM    499  CG1 VAL A  76     -52.748   4.835 -19.498  1.00 40.81           C  
ATOM    500  CG2 VAL A  76     -54.423   5.905 -21.056  1.00 33.06           C  
ATOM    501  N   VAL A  77     -53.694   5.735 -16.422  1.00 38.86           N  
ATOM    502  CA  VAL A  77     -52.881   5.749 -15.200  1.00 40.77           C  
ATOM    503  C   VAL A  77     -52.037   4.466 -15.230  1.00 43.45           C  
ATOM    504  O   VAL A  77     -52.574   3.367 -15.338  1.00 43.59           O  
ATOM    505  CB  VAL A  77     -53.767   5.761 -13.941  1.00 38.17           C  
ATOM    506  CG1 VAL A  77     -52.903   5.751 -12.708  1.00 35.85           C  
ATOM    507  CG2 VAL A  77     -54.652   6.988 -13.949  1.00 36.87           C  
ATOM    508  N   ASP A  78     -50.721   4.599 -15.133  1.00 46.08           N  
ATOM    509  CA  ASP A  78     -49.884   3.405 -15.210  1.00 49.77           C  
ATOM    510  C   ASP A  78     -48.448   3.794 -14.858  1.00 51.70           C  
ATOM    511  O   ASP A  78     -48.159   4.959 -14.580  1.00 50.69           O  
ATOM    512  CB  ASP A  78     -49.953   2.916 -16.679  1.00 50.29           C  
ATOM    513  CG  ASP A  78     -49.771   1.415 -16.854  1.00 52.10           C  
ATOM    514  OD1 ASP A  78     -48.995   0.816 -16.085  1.00 55.25           O  
ATOM    515  OD2 ASP A  78     -50.367   0.844 -17.792  1.00 52.07           O  
ATOM    516  N   ARG A  79     -47.546   2.821 -14.895  1.00 55.85           N  
ATOM    517  CA  ARG A  79     -46.145   3.098 -14.609  1.00 58.47           C  
ATOM    518  C   ARG A  79     -45.687   4.151 -15.581  1.00 58.53           C  
ATOM    519  O   ARG A  79     -46.009   4.074 -16.761  1.00 57.73           O  
ATOM    520  CB  ARG A  79     -45.346   1.837 -14.801  1.00 62.89           C  
ATOM    521  CG  ARG A  79     -45.869   0.736 -13.911  1.00 68.73           C  
ATOM    522  CD  ARG A  79     -45.346  -0.637 -14.342  1.00 72.87           C  
ATOM    523  NE  ARG A  79     -45.420  -1.582 -13.247  1.00 76.50           N  
ATOM    524  CZ  ARG A  79     -44.885  -1.361 -12.058  1.00 79.16           C  
ATOM    525  NH1 ARG A  79     -44.236  -0.227 -11.781  1.00 80.29           N  
ATOM    526  NH2 ARG A  79     -45.012  -2.305 -11.145  1.00 80.34           N  
ATOM    527  N   GLY A  80     -44.940   5.134 -15.098  1.00 59.84           N  
ATOM    528  CA  GLY A  80     -44.495   6.195 -15.983  1.00 61.26           C  
ATOM    529  C   GLY A  80     -43.703   5.645 -17.147  1.00 62.22           C  
ATOM    530  O   GLY A  80     -43.414   6.328 -18.137  1.00 62.85           O  
ATOM    531  N   HIS A  81     -43.386   4.368 -17.026  1.00 60.75           N  
ATOM    532  CA  HIS A  81     -42.584   3.666 -17.996  1.00 59.32           C  
ATOM    533  C   HIS A  81     -43.408   3.051 -19.136  1.00 59.69           C  
ATOM    534  O   HIS A  81     -42.880   2.733 -20.205  1.00 60.22           O  
ATOM    535  CB  HIS A  81     -41.759   2.675 -17.189  1.00 56.15           C  
ATOM    536  CG  HIS A  81     -41.281   3.264 -15.887  1.00 52.64           C  
ATOM    537  ND1 HIS A  81     -40.621   4.471 -15.823  1.00 50.73           N  
ATOM    538  CD2 HIS A  81     -41.442   2.856 -14.606  1.00 48.63           C  
ATOM    539  CE1 HIS A  81     -40.397   4.784 -14.558  1.00 46.91           C  
ATOM    540  NE2 HIS A  81     -40.884   3.822 -13.801  1.00 45.10           N  
ATOM    541  N   ASN A  82     -44.710   2.910 -18.906  1.00 58.60           N  
ATOM    542  CA  ASN A  82     -45.627   2.418 -19.926  1.00 56.34           C  
ATOM    543  C   ASN A  82     -46.171   3.698 -20.572  1.00 54.94           C  
ATOM    544  O   ASN A  82     -46.321   3.787 -21.794  1.00 52.74           O  
ATOM    545  CB  ASN A  82     -46.782   1.629 -19.295  1.00 57.77           C  
ATOM    546  CG  ASN A  82     -46.409   0.183 -18.962  1.00 59.71           C  
ATOM    547  OD1 ASN A  82     -45.237  -0.145 -18.790  1.00 61.13           O  
ATOM    548  ND2 ASN A  82     -47.418  -0.680 -18.850  1.00 58.96           N  
ATOM    549  N   ILE A  83     -46.447   4.698 -19.735  1.00 53.26           N  
ATOM    550  CA  ILE A  83     -46.969   5.972 -20.216  1.00 55.29           C  
ATOM    551  C   ILE A  83     -46.080   6.532 -21.322  1.00 57.40           C  
ATOM    552  O   ILE A  83     -46.576   6.986 -22.350  1.00 58.80           O  
ATOM    553  CB  ILE A  83     -47.087   7.031 -19.065  1.00 52.62           C  
ATOM    554  CG1 ILE A  83     -48.358   6.796 -18.253  1.00 51.35           C  
ATOM    555  CG2 ILE A  83     -47.138   8.440 -19.635  1.00 49.20           C  
ATOM    556  CD1 ILE A  83     -48.453   5.440 -17.649  1.00 51.35           C  
ATOM    557  N   GLU A  84     -44.768   6.513 -21.113  1.00 61.32           N  
ATOM    558  CA  GLU A  84     -43.860   7.026 -22.129  1.00 63.44           C  
ATOM    559  C   GLU A  84     -43.866   6.142 -23.368  1.00 63.33           C  
ATOM    560  O   GLU A  84     -43.760   6.627 -24.495  1.00 63.25           O  
ATOM    561  CB  GLU A  84     -42.460   7.157 -21.561  1.00 64.61           C  
ATOM    562  CG  GLU A  84     -42.049   8.605 -21.334  1.00 70.49           C  
ATOM    563  CD  GLU A  84     -42.815   9.394 -20.291  1.00 73.05           C  
ATOM    564  OE1 GLU A  84     -43.034   8.837 -19.197  1.00 74.94           O  
ATOM    565  OE2 GLU A  84     -43.152  10.565 -20.531  1.00 74.43           O  
ATOM    566  N   LYS A  85     -44.005   4.841 -23.164  1.00 63.72           N  
ATOM    567  CA  LYS A  85     -44.069   3.920 -24.285  1.00 65.15           C  
ATOM    568  C   LYS A  85     -45.301   4.337 -25.100  1.00 65.91           C  
ATOM    569  O   LYS A  85     -45.287   4.342 -26.336  1.00 66.32           O  
ATOM    570  CB  LYS A  85     -44.218   2.485 -23.758  1.00 67.26           C  
ATOM    571  CG  LYS A  85     -44.307   1.385 -24.810  1.00 69.46           C  
ATOM    572  CD  LYS A  85     -44.450   0.036 -24.103  1.00 71.78           C  
ATOM    573  CE  LYS A  85     -43.243  -0.324 -23.264  1.00 72.97           C  
ATOM    574  NZ  LYS A  85     -43.443  -1.421 -22.304  1.00 72.50           N  
ATOM    575  N   VAL A  86     -46.358   4.721 -24.387  1.00 65.99           N  
ATOM    576  CA  VAL A  86     -47.609   5.153 -25.010  1.00 64.90           C  
ATOM    577  C   VAL A  86     -47.476   6.503 -25.705  1.00 64.49           C  
ATOM    578  O   VAL A  86     -48.033   6.709 -26.779  1.00 63.56           O  
ATOM    579  CB  VAL A  86     -48.746   5.250 -23.963  1.00 64.89           C  
ATOM    580  CG1 VAL A  86     -49.877   6.112 -24.493  1.00 64.54           C  
ATOM    581  CG2 VAL A  86     -49.273   3.860 -23.640  1.00 63.53           C  
ATOM    582  N   VAL A  87     -46.746   7.421 -25.077  1.00 65.48           N  
ATOM    583  CA  VAL A  87     -46.540   8.756 -25.627  1.00 67.40           C  
ATOM    584  C   VAL A  87     -45.893   8.691 -27.005  1.00 68.69           C  
ATOM    585  O   VAL A  87     -46.374   9.307 -27.956  1.00 68.87           O  
ATOM    586  CB  VAL A  87     -45.636   9.608 -24.707  1.00 67.68           C  
ATOM    587  CG1 VAL A  87     -45.363  10.971 -25.344  1.00 65.95           C  
ATOM    588  CG2 VAL A  87     -46.295   9.780 -23.354  1.00 67.14           C  
ATOM    589  N   ASN A  88     -44.798   7.943 -27.101  1.00 70.02           N  
ATOM    590  CA  ASN A  88     -44.085   7.802 -28.362  1.00 72.02           C  
ATOM    591  C   ASN A  88     -45.017   7.390 -29.501  1.00 72.59           C  
ATOM    592  O   ASN A  88     -45.099   8.071 -30.528  1.00 73.33           O  
ATOM    593  CB  ASN A  88     -42.955   6.769 -28.224  1.00 72.12           C  
ATOM    594  CG  ASN A  88     -41.922   7.162 -27.175  1.00 72.51           C  
ATOM    595  OD1 ASN A  88     -41.517   8.324 -27.090  1.00 72.48           O  
ATOM    596  ND2 ASN A  88     -41.482   6.189 -26.378  1.00 70.91           N  
ATOM    597  N   VAL A  89     -45.732   6.287 -29.299  1.00 73.17           N  
ATOM    598  CA  VAL A  89     -46.644   5.746 -30.303  1.00 73.96           C  
ATOM    599  C   VAL A  89     -47.856   6.600 -30.660  1.00 74.67           C  
ATOM    600  O   VAL A  89     -48.566   6.282 -31.612  1.00 74.87           O  
ATOM    601  CB  VAL A  89     -47.183   4.374 -29.875  1.00 74.45           C  
ATOM    602  CG1 VAL A  89     -46.064   3.539 -29.281  1.00 76.22           C  
ATOM    603  CG2 VAL A  89     -48.320   4.548 -28.884  1.00 75.76           C  
ATOM    604  N   ILE A  90     -48.100   7.671 -29.909  1.00 75.42           N  
ATOM    605  CA  ILE A  90     -49.259   8.524 -30.171  1.00 75.86           C  
ATOM    606  C   ILE A  90     -48.904   9.959 -30.569  1.00 75.94           C  
ATOM    607  O   ILE A  90     -49.691  10.631 -31.231  1.00 76.20           O  
ATOM    608  CB  ILE A  90     -50.190   8.566 -28.933  1.00 76.68           C  
ATOM    609  CG1 ILE A  90     -50.504   7.143 -28.473  1.00 77.00           C  
ATOM    610  CG2 ILE A  90     -51.495   9.270 -29.273  1.00 76.99           C  
ATOM    611  CD1 ILE A  90     -51.330   7.082 -27.213  1.00 78.80           C  
ATOM    612  N   LYS A  91     -47.724  10.422 -30.166  1.00 76.29           N  
ATOM    613  CA  LYS A  91     -47.277  11.781 -30.479  1.00 77.78           C  
ATOM    614  C   LYS A  91     -47.489  12.139 -31.957  1.00 79.10           C  
ATOM    615  O   LYS A  91     -47.848  13.271 -32.280  1.00 78.74           O  
ATOM    616  CB  LYS A  91     -45.796  11.949 -30.120  1.00 77.87           C  
ATOM    617  CG  LYS A  91     -45.494  13.002 -29.069  1.00 76.32           C  
ATOM    618  CD  LYS A  91     -44.017  13.011 -28.768  1.00 76.39           C  
ATOM    619  CE  LYS A  91     -43.608  14.003 -27.710  1.00 77.99           C  
ATOM    620  NZ  LYS A  91     -42.342  13.495 -27.140  1.00 77.93           N  
ATOM    621  N   PRO A  92     -47.253  11.182 -32.875  1.00 80.37           N  
ATOM    622  CA  PRO A  92     -47.437  11.453 -34.307  1.00 81.93           C  
ATOM    623  C   PRO A  92     -48.899  11.456 -34.760  1.00 82.98           C  
ATOM    624  O   PRO A  92     -49.286  12.244 -35.623  1.00 83.27           O  
ATOM    625  CB  PRO A  92     -46.639  10.333 -34.968  1.00 82.06           C  
ATOM    626  CG  PRO A  92     -46.844   9.197 -34.018  1.00 81.36           C  
ATOM    627  CD  PRO A  92     -46.618   9.866 -32.680  1.00 80.51           C  
ATOM    628  N   MET A  93     -49.701  10.566 -34.175  1.00 83.98           N  
ATOM    629  CA  MET A  93     -51.121  10.446 -34.512  1.00 84.28           C  
ATOM    630  C   MET A  93     -51.921  11.688 -34.137  1.00 84.05           C  
ATOM    631  O   MET A  93     -52.964  11.963 -34.726  1.00 83.68           O  
ATOM    632  CB  MET A  93     -51.741   9.244 -33.795  1.00 84.64           C  
ATOM    633  CG  MET A  93     -51.024   7.930 -34.008  1.00 84.82           C  
ATOM    634  SD  MET A  93     -51.887   6.508 -33.031  1.00 86.28           S  
ATOM    635  CE  MET A  93     -52.775   5.619 -34.489  1.00 86.69           C  
ATOM    636  N   ILE A  94     -51.430  12.422 -33.148  1.00 84.58           N  
ATOM    637  CA  ILE A  94     -52.099  13.625 -32.676  1.00 85.54           C  
ATOM    638  C   ILE A  94     -51.591  14.874 -33.402  1.00 86.07           C  
ATOM    639  O   ILE A  94     -50.776  15.627 -32.865  1.00 85.85           O  
ATOM    640  CB  ILE A  94     -51.890  13.795 -31.158  1.00 85.38           C  
ATOM    641  CG1 ILE A  94     -52.374  12.533 -30.439  1.00 85.52           C  
ATOM    642  CG2 ILE A  94     -52.633  15.029 -30.665  1.00 86.25           C  
ATOM    643  CD1 ILE A  94     -52.214  12.574 -28.932  1.00 85.22           C  
ATOM    644  N   LYS A  95     -52.077  15.088 -34.618  1.00 86.76           N  
ATOM    645  CA  LYS A  95     -51.667  16.231 -35.409  1.00 87.41           C  
ATOM    646  C   LYS A  95     -51.889  17.538 -34.691  1.00 87.35           C  
ATOM    647  O   LYS A  95     -51.106  18.488 -34.825  1.00 88.65           O  
ATOM    648  CB  LYS A  95     -52.437  16.257 -36.720  1.00 87.78           C  
ATOM    649  CG  LYS A  95     -52.375  14.916 -37.402  1.00 89.68           C  
ATOM    650  CD  LYS A  95     -53.185  14.930 -38.663  1.00 91.00           C  
ATOM    651  CE  LYS A  95     -53.269  16.304 -39.298  1.00 90.88           C  
ATOM    652  NZ  LYS A  95     -53.883  16.084 -40.610  1.00 91.57           N  
ATOM    653  N   ASP A  96     -52.959  17.609 -33.915  1.00 86.00           N  
ATOM    654  CA  ASP A  96     -53.234  18.850 -33.193  1.00 83.99           C  
ATOM    655  C   ASP A  96     -54.153  18.446 -32.052  1.00 81.10           C  
ATOM    656  O   ASP A  96     -55.136  17.725 -32.235  1.00 81.13           O  
ATOM    657  CB  ASP A  96     -53.808  19.918 -34.142  1.00 86.54           C  
ATOM    658  CG  ASP A  96     -53.430  21.367 -33.748  1.00 89.36           C  
ATOM    659  OD1 ASP A  96     -52.946  22.152 -34.565  1.00 90.45           O  
ATOM    660  OD2 ASP A  96     -53.641  21.706 -32.552  1.00 91.05           O  
ATOM    661  N   GLY A  97     -53.766  18.874 -30.854  1.00 77.46           N  
ATOM    662  CA  GLY A  97     -54.486  18.582 -29.625  1.00 71.95           C  
ATOM    663  C   GLY A  97     -53.542  18.853 -28.463  1.00 67.73           C  
ATOM    664  O   GLY A  97     -52.815  19.849 -28.475  1.00 68.43           O  
ATOM    665  N   MET A  98     -53.545  17.978 -27.461  1.00 62.69           N  
ATOM    666  CA  MET A  98     -52.675  18.157 -26.300  1.00 56.96           C  
ATOM    667  C   MET A  98     -52.515  16.896 -25.460  1.00 55.35           C  
ATOM    668  O   MET A  98     -53.451  16.110 -25.311  1.00 53.40           O  
ATOM    669  CB  MET A  98     -53.205  19.282 -25.410  1.00 53.74           C  
ATOM    670  CG  MET A  98     -52.402  19.502 -24.139  1.00 51.70           C  
ATOM    671  SD  MET A  98     -53.152  20.901 -23.029  1.00 41.77           S  
ATOM    672  CE  MET A  98     -51.560  21.778 -22.456  1.00 49.01           C  
ATOM    673  N   ILE A  99     -51.311  16.714 -24.919  1.00 52.90           N  
ATOM    674  CA  ILE A  99     -50.998  15.580 -24.064  1.00 50.21           C  
ATOM    675  C   ILE A  99     -50.426  16.121 -22.757  1.00 48.28           C  
ATOM    676  O   ILE A  99     -49.588  17.026 -22.747  1.00 46.41           O  
ATOM    677  CB  ILE A  99     -49.974  14.641 -24.709  1.00 51.41           C  
ATOM    678  CG1 ILE A  99     -50.616  13.878 -25.862  1.00 52.89           C  
ATOM    679  CG2 ILE A  99     -49.437  13.668 -23.677  1.00 52.60           C  
ATOM    680  CD1 ILE A  99     -49.668  12.921 -26.574  1.00 53.91           C  
ATOM    681  N   THR A 100     -50.885  15.543 -21.652  1.00 44.67           N  
ATOM    682  CA  THR A 100     -50.434  15.992 -20.347  1.00 42.43           C  
ATOM    683  C   THR A 100     -50.116  14.808 -19.457  1.00 40.77           C  
ATOM    684  O   THR A 100     -50.624  13.706 -19.666  1.00 40.86           O  
ATOM    685  CB  THR A 100     -51.479  16.890 -19.681  1.00 43.62           C  
ATOM    686  OG1 THR A 100     -51.774  18.017 -20.515  1.00 46.17           O  
ATOM    687  CG2 THR A 100     -50.973  17.380 -18.361  1.00 45.22           C  
ATOM    688  N   VAL A 101     -49.284  15.040 -18.452  1.00 39.46           N  
ATOM    689  CA  VAL A 101     -48.918  13.988 -17.533  1.00 38.98           C  
ATOM    690  C   VAL A 101     -48.500  14.584 -16.192  1.00 38.61           C  
ATOM    691  O   VAL A 101     -47.904  15.656 -16.133  1.00 39.98           O  
ATOM    692  CB  VAL A 101     -47.748  13.131 -18.088  1.00 41.21           C  
ATOM    693  CG1 VAL A 101     -46.419  13.916 -17.998  1.00 37.83           C  
ATOM    694  CG2 VAL A 101     -47.645  11.831 -17.310  1.00 40.21           C  
ATOM    695  N   GLU A 102     -48.861  13.904 -15.113  1.00 38.29           N  
ATOM    696  CA  GLU A 102     -48.467  14.335 -13.788  1.00 40.21           C  
ATOM    697  C   GLU A 102     -48.608  13.152 -12.843  1.00 39.60           C  
ATOM    698  O   GLU A 102     -49.372  12.213 -13.106  1.00 40.27           O  
ATOM    699  CB  GLU A 102     -49.283  15.560 -13.301  1.00 43.31           C  
ATOM    700  CG  GLU A 102     -50.731  15.336 -12.851  1.00 44.97           C  
ATOM    701  CD  GLU A 102     -51.727  15.247 -13.994  1.00 47.81           C  
ATOM    702  OE1 GLU A 102     -51.665  16.073 -14.933  1.00 47.76           O  
ATOM    703  OE2 GLU A 102     -52.594  14.345 -13.937  1.00 52.24           O  
ATOM    704  N   PRO A 103     -47.847  13.164 -11.743  1.00 40.52           N  
ATOM    705  CA  PRO A 103     -47.881  12.085 -10.756  1.00 42.07           C  
ATOM    706  C   PRO A 103     -49.228  11.874 -10.083  1.00 42.78           C  
ATOM    707  O   PRO A 103     -50.049  12.784  -9.992  1.00 43.43           O  
ATOM    708  CB  PRO A 103     -46.826  12.509  -9.735  1.00 40.59           C  
ATOM    709  CG  PRO A 103     -45.888  13.352 -10.540  1.00 43.09           C  
ATOM    710  CD  PRO A 103     -46.834  14.168 -11.378  1.00 39.73           C  
ATOM    711  N   THR A 104     -49.431  10.653  -9.617  1.00 43.98           N  
ATOM    712  CA  THR A 104     -50.622  10.275  -8.885  1.00 44.66           C  
ATOM    713  C   THR A 104     -50.301   8.956  -8.187  1.00 44.75           C  
ATOM    714  O   THR A 104     -49.448   8.184  -8.644  1.00 47.63           O  
ATOM    715  CB  THR A 104     -51.854  10.084  -9.792  1.00 45.24           C  
ATOM    716  OG1 THR A 104     -53.018   9.952  -8.963  1.00 46.07           O  
ATOM    717  CG2 THR A 104     -51.715   8.816 -10.650  1.00 44.09           C  
ATOM    718  N   ILE A 105     -50.972   8.718  -7.071  1.00 43.54           N  
ATOM    719  CA  ILE A 105     -50.783   7.508  -6.293  1.00 41.55           C  
ATOM    720  C   ILE A 105     -52.000   6.615  -6.470  1.00 42.20           C  
ATOM    721  O   ILE A 105     -53.131   7.065  -6.296  1.00 42.15           O  
ATOM    722  CB  ILE A 105     -50.636   7.843  -4.800  1.00 41.36           C  
ATOM    723  CG1 ILE A 105     -49.445   8.768  -4.599  1.00 39.77           C  
ATOM    724  CG2 ILE A 105     -50.477   6.569  -3.974  1.00 41.92           C  
ATOM    725  CD1 ILE A 105     -49.268   9.210  -3.169  1.00 42.97           C  
ATOM    726  N   VAL A 106     -51.774   5.358  -6.845  1.00 40.87           N  
ATOM    727  CA  VAL A 106     -52.870   4.407  -7.002  1.00 41.17           C  
ATOM    728  C   VAL A 106     -52.991   3.738  -5.636  1.00 43.09           C  
ATOM    729  O   VAL A 106     -52.094   3.021  -5.208  1.00 43.82           O  
ATOM    730  CB  VAL A 106     -52.558   3.361  -8.076  1.00 39.31           C  
ATOM    731  CG1 VAL A 106     -53.682   2.354  -8.158  1.00 35.79           C  
ATOM    732  CG2 VAL A 106     -52.348   4.061  -9.425  1.00 35.83           C  
ATOM    733  N   LEU A 107     -54.090   4.004  -4.938  1.00 44.44           N  
ATOM    734  CA  LEU A 107     -54.278   3.457  -3.605  1.00 45.01           C  
ATOM    735  C   LEU A 107     -54.904   2.081  -3.568  1.00 46.06           C  
ATOM    736  O   LEU A 107     -54.708   1.344  -2.608  1.00 48.91           O  
ATOM    737  CB  LEU A 107     -55.142   4.396  -2.764  1.00 43.51           C  
ATOM    738  CG  LEU A 107     -54.650   5.821  -2.519  1.00 42.39           C  
ATOM    739  CD1 LEU A 107     -55.769   6.615  -1.852  1.00 42.02           C  
ATOM    740  CD2 LEU A 107     -53.400   5.810  -1.656  1.00 39.87           C  
ATOM    741  N   TRP A 108     -55.646   1.718  -4.603  1.00 48.19           N  
ATOM    742  CA  TRP A 108     -56.310   0.436  -4.589  1.00 51.75           C  
ATOM    743  C   TRP A 108     -56.848   0.009  -5.942  1.00 52.32           C  
ATOM    744  O   TRP A 108     -56.930   0.808  -6.871  1.00 52.47           O  
ATOM    745  CB  TRP A 108     -57.464   0.495  -3.586  1.00 55.90           C  
ATOM    746  CG  TRP A 108     -57.590  -0.722  -2.749  1.00 62.02           C  
ATOM    747  CD1 TRP A 108     -56.627  -1.262  -1.945  1.00 63.69           C  
ATOM    748  CD2 TRP A 108     -58.746  -1.543  -2.603  1.00 63.36           C  
ATOM    749  NE1 TRP A 108     -57.115  -2.372  -1.300  1.00 65.89           N  
ATOM    750  CE2 TRP A 108     -58.416  -2.569  -1.685  1.00 66.08           C  
ATOM    751  CE3 TRP A 108     -60.032  -1.515  -3.150  1.00 65.13           C  
ATOM    752  CZ2 TRP A 108     -59.328  -3.562  -1.305  1.00 65.47           C  
ATOM    753  CZ3 TRP A 108     -60.939  -2.501  -2.772  1.00 66.03           C  
ATOM    754  CH2 TRP A 108     -60.581  -3.509  -1.857  1.00 65.58           C  
ATOM    755  N   VAL A 109     -57.223  -1.264  -6.027  1.00 53.58           N  
ATOM    756  CA  VAL A 109     -57.791  -1.838  -7.236  1.00 57.14           C  
ATOM    757  C   VAL A 109     -58.968  -2.739  -6.854  1.00 60.11           C  
ATOM    758  O   VAL A 109     -59.964  -2.824  -7.577  1.00 60.73           O  
ATOM    759  CB  VAL A 109     -56.724  -2.632  -8.045  1.00 56.84           C  
ATOM    760  CG1 VAL A 109     -57.370  -3.826  -8.740  1.00 58.17           C  
ATOM    761  CG2 VAL A 109     -56.083  -1.719  -9.093  1.00 53.15           C  
ATOM    762  N   GLY A 110     -58.858  -3.396  -5.705  1.00 63.36           N  
ATOM    763  CA  GLY A 110     -59.946  -4.250  -5.251  1.00 67.33           C  
ATOM    764  C   GLY A 110     -60.023  -5.597  -5.944  1.00 70.90           C  
ATOM    765  O   GLY A 110     -60.885  -5.839  -6.781  1.00 70.69           O  
ATOM    766  N   THR A 111     -59.098  -6.466  -5.566  1.00 74.51           N  
ATOM    767  CA  THR A 111     -58.987  -7.788  -6.117  1.00 78.63           C  
ATOM    768  C   THR A 111     -59.270  -8.734  -4.941  1.00 81.80           C  
ATOM    769  O   THR A 111     -59.944  -9.763  -5.091  1.00 82.21           O  
ATOM    770  CB  THR A 111     -57.556  -7.936  -6.735  1.00 78.00           C  
ATOM    771  OG1 THR A 111     -57.546  -8.875  -7.812  1.00 79.68           O  
ATOM    772  CG2 THR A 111     -56.534  -8.311  -5.691  1.00 77.03           C  
ATOM    773  N   GLN A 112     -58.763  -8.361  -3.766  1.00 85.84           N  
ATOM    774  CA  GLN A 112     -58.936  -9.138  -2.539  1.00 89.67           C  
ATOM    775  C   GLN A 112     -59.350  -8.293  -1.338  1.00 91.20           C  
ATOM    776  O   GLN A 112     -58.639  -7.374  -0.928  1.00 90.16           O  
ATOM    777  CB  GLN A 112     -57.647  -9.864  -2.165  1.00 89.46           C  
ATOM    778  CG  GLN A 112     -57.050 -10.721  -3.245  1.00 90.99           C  
ATOM    779  CD  GLN A 112     -55.665 -11.194  -2.870  1.00 92.03           C  
ATOM    780  OE1 GLN A 112     -54.970 -11.814  -3.672  1.00 93.19           O  
ATOM    781  NE2 GLN A 112     -55.252 -10.902  -1.638  1.00 92.69           N  
ATOM    782  N   GLU A 113     -60.488  -8.652  -0.758  1.00 93.58           N  
ATOM    783  CA  GLU A 113     -61.033  -7.957   0.402  1.00 95.94           C  
ATOM    784  C   GLU A 113     -60.612  -8.567   1.732  1.00 97.07           C  
ATOM    785  O   GLU A 113     -60.687  -9.781   1.905  1.00 97.46           O  
ATOM    786  CB  GLU A 113     -62.551  -8.004   0.380  1.00 97.30           C  
ATOM    787  CG  GLU A 113     -63.253  -6.944  -0.407  1.00 99.02           C  
ATOM    788  CD  GLU A 113     -64.554  -6.681   0.279  1.00100.33           C  
ATOM    789  OE1 GLU A 113     -64.579  -6.215   1.423  1.00100.45           O  
ATOM    790  OE2 GLU A 113     -65.587  -6.972  -0.365  1.00101.85           O  
ATOM    791  N   GLU A 114     -60.181  -7.726   2.670  1.00 98.13           N  
ATOM    792  CA  GLU A 114     -59.806  -8.173   4.016  1.00 99.06           C  
ATOM    793  C   GLU A 114     -59.641  -6.980   4.953  1.00 99.67           C  
ATOM    794  O   GLU A 114     -59.721  -5.829   4.474  1.00 99.76           O  
ATOM    795  CB  GLU A 114     -58.495  -8.968   4.030  1.00 98.72           C  
ATOM    796  CG  GLU A 114     -57.969  -9.498   2.708  1.00 99.20           C  
ATOM    797  CD  GLU A 114     -56.455  -9.606   2.732  1.00 99.78           C  
ATOM    798  OE1 GLU A 114     -55.914 -10.674   2.374  1.00100.34           O  
ATOM    799  OE2 GLU A 114     -55.806  -8.609   3.118  1.00 99.89           O  
TER     800      GLU A 114                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
