
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  715),  selected   95 , name 1ul3_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 1ul3_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_A      A       5          1.363
LGA    K     2_A      N       6          0.431
LGA    K     3_A      K       7          0.462
LGA    V     4_A      L       8          0.709
LGA    E     5_A      V       9          0.877
LGA    A     6_A      I      10          0.729
LGA    I     7_A      V      11          0.530
LGA    I     8_A      T      12          0.661
LGA    R     9_A      E      13          0.457
LGA    P    10_A      K      14          0.436
LGA    F    11_A      V      15          0.476
LGA    K    12_A      L      16          0.480
LGA    L    13_A      L      17          0.791
LGA    D    14_A      K      18          0.976
LGA    E    15_A      K      19          0.898
LGA    V    16_A      V      20          0.653
LGA    K    17_A      A      21          1.253
LGA    I    18_A      K      22          1.335
LGA    A    19_A      I      23          1.198
LGA    L    20_A      I      24          1.447
LGA    V    21_A      E      25          1.648
LGA    N    22_A      E      26          1.481
LGA    A    23_A      A      27          1.096
LGA    G    24_A      G      28          0.880
LGA    I    25_A      A      29          1.261
LGA    V    26_A      T      30          2.360
LGA    G    27_A      G      31          1.251
LGA    M    28_A      Y      32          0.869
LGA    T    29_A      T      33          0.711
LGA    V    30_A      V      34          0.664
LGA    S    31_A      V      35          0.515
LGA    E    32_A      D      36          0.660
LGA    V    33_A      T      37          0.547
LGA    R    34_A      G      38          0.797
LGA    G    35_A      G      39          2.103
LGA    F    36_A      -       -           -
LGA    E    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    L    56_A      -       -           -
LGA    Q    57_A      S      58          0.952
LGA    K    58_A      N      59          0.470
LGA    L    59_A      V      60          0.320
LGA    K    60_A      K      61          0.625
LGA    I    61_A      F      62          0.511
LGA    E    62_A      E      63          0.591
LGA    I    63_A      V      64          0.508
LGA    V    64_A      L      65          0.460
LGA    V    65_A      T      66          0.344
LGA    D    66_A      E      67          2.269
LGA    E    67_A      N      68          2.592
LGA    -       -      R      69           -
LGA    G    68_A      E      70          3.065
LGA    Q    69_A      M      71          1.529
LGA    V    70_A      A      72          1.807
LGA    D    71_A      E      73          1.537
LGA    M    72_A      K      74          1.050
LGA    V    73_A      I      75          1.731
LGA    V    74_A      A      76          1.190
LGA    D    75_A      D      77          0.881
LGA    K    76_A      Q      78          1.705
LGA    L    77_A      V      79          2.318
LGA    V    78_A      A      80          1.509
LGA    S    79_A      I      81          3.129
LGA    A    80_A      K      82          4.186
LGA    A    81_A      F      83          3.654
LGA    R    82_A      F      84          2.175
LGA    T    83_A      T      85          4.176
LGA    G    84_A      D      86          2.826
LGA    E    85_A      Y      87          5.107
LGA    I    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    D    88_A      A      88          0.697
LGA    G    89_A      G      89          1.170
LGA    K    90_A      I      90          0.538
LGA    I    91_A      I      91          1.040
LGA    F    92_A      Y      92          1.720
LGA    I    93_A      I      93          0.577
LGA    S    94_A      C      94          0.763
LGA    P    95_A      E      95          0.303
LGA    V    96_A      A      96          0.813
LGA    D    97_A      E      97          1.504
LGA    S    98_A      V      98          1.706
LGA    V    99_A      L      99          4.077
LGA    V   100_A      Y     100          0.805
LGA    R   101_A      G     101          2.061
LGA    I   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    K   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    T   109_A      -       -           -
LGA    E   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    I   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   83    5.0     78    1.68    20.51     86.715     4.393

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.449437 * X  +  -0.833999 * Y  +   0.320080 * Z  +  32.512794
  Y_new =  -0.032566 * X  +   0.342773 * Y  +   0.938854 * Z  + -18.108540
  Z_new =  -0.892718 * X  +  -0.432379 * Y  +   0.126895 * Z  +  -3.779398 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.285331    1.856262  [ DEG:   -73.6440    106.3560 ]
  Theta =   1.103342    2.038251  [ DEG:    63.2168    116.7832 ]
  Phi   =  -0.072332    3.069260  [ DEG:    -4.1443    175.8557 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ul3_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ul3_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   83   5.0   78   1.68   20.51  86.715
REMARK  ---------------------------------------------------------- 
MOLECULE 1ul3_A
HEADER    SIGNALING PROTEIN                       09-SEP-03   1UL3              
TITLE     CRYSTAL STRUCTURE OF PII FROM SYNECHOCYSTIS SP. PCC 6803              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITROGEN REGULATORY PROTEIN P-II;                          
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PII SIGNAL TRANSDUCING PROTEIN;                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SYNECHOCYSTIS SP.;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GLNB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMAB11                                    
KEYWDS    NITROGEN REGULATION, CYANOBACTERIA                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.XU,P.D.CARR,P.CLANCY,M.GARCIA-DOMINGUEZ,K.FORCHHAMMER,              
AUTHOR   2 F.FLORENCIO,N.TANDEAU DE MARSAC,S.G.VASUDEVAN,D.L.OLLIS              
REVDAT   1   16-DEC-03 1UL3    0                                                
JRNL        AUTH   Y.XU,P.D.CARR,P.CLANCY,M.GARCIA-DOMINGUEZ,                   
JRNL        AUTH 2 K.FORCHHAMMER,F.FLORENCIO,S.G.VASUDEVAN,                     
JRNL        AUTH 3 N.TANDEAU DE MARSAC,D.L.OLLIS                                
JRNL        TITL   THE STRUCTURES OF THE PII PROTEINS FROM THE                  
JRNL        TITL 2 CYANOBACTERIA SYNECHOCOCCUS SP. PCC 7942 AND                 
JRNL        TITL 3 SYNECHOCYSTIS SP. PCC 6803.                                  
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  59  2183 2003              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1UL3 A    1   112  UNP    Q55247   GLNB_SYNY3       1    112             
DBREF  1UL3 B    1   112  UNP    Q55247   GLNB_SYNY3       1    112             
DBREF  1UL3 C    1   112  UNP    Q55247   GLNB_SYNY3       1    112             
DBREF  1UL3 D    1   112  UNP    Q55247   GLNB_SYNY3       1    112             
SEQRES   1 A  112  MET LYS LYS VAL GLU ALA ILE ILE ARG PRO PHE LYS LEU          
SEQRES   2 A  112  ASP GLU VAL LYS ILE ALA LEU VAL ASN ALA GLY ILE VAL          
SEQRES   3 A  112  GLY MET THR VAL SER GLU VAL ARG GLY PHE GLY ARG GLN          
SEQRES   4 A  112  LYS GLY GLN THR GLU ARG TYR ARG GLY SER GLU TYR THR          
SEQRES   5 A  112  VAL GLU PHE LEU GLN LYS LEU LYS ILE GLU ILE VAL VAL          
SEQRES   6 A  112  ASP GLU GLY GLN VAL ASP MET VAL VAL ASP LYS LEU VAL          
SEQRES   7 A  112  SER ALA ALA ARG THR GLY GLU ILE GLY ASP GLY LYS ILE          
SEQRES   8 A  112  PHE ILE SER PRO VAL ASP SER VAL VAL ARG ILE ARG THR          
SEQRES   9 A  112  GLY GLU LYS ASP THR GLU ALA ILE                              
SEQRES   1 B  112  MET LYS LYS VAL GLU ALA ILE ILE ARG PRO PHE LYS LEU          
SEQRES   2 B  112  ASP GLU VAL LYS ILE ALA LEU VAL ASN ALA GLY ILE VAL          
SEQRES   3 B  112  GLY MET THR VAL SER GLU VAL ARG GLY PHE GLY ARG GLN          
SEQRES   4 B  112  LYS GLY GLN THR GLU ARG TYR ARG GLY SER GLU TYR THR          
SEQRES   5 B  112  VAL GLU PHE LEU GLN LYS LEU LYS ILE GLU ILE VAL VAL          
SEQRES   6 B  112  ASP GLU GLY GLN VAL ASP MET VAL VAL ASP LYS LEU VAL          
SEQRES   7 B  112  SER ALA ALA ARG THR GLY GLU ILE GLY ASP GLY LYS ILE          
SEQRES   8 B  112  PHE ILE SER PRO VAL ASP SER VAL VAL ARG ILE ARG THR          
SEQRES   9 B  112  GLY GLU LYS ASP THR GLU ALA ILE                              
SEQRES   1 C  112  MET LYS LYS VAL GLU ALA ILE ILE ARG PRO PHE LYS LEU          
SEQRES   2 C  112  ASP GLU VAL LYS ILE ALA LEU VAL ASN ALA GLY ILE VAL          
SEQRES   3 C  112  GLY MET THR VAL SER GLU VAL ARG GLY PHE GLY ARG GLN          
SEQRES   4 C  112  LYS GLY GLN THR GLU ARG TYR ARG GLY SER GLU TYR THR          
SEQRES   5 C  112  VAL GLU PHE LEU GLN LYS LEU LYS ILE GLU ILE VAL VAL          
SEQRES   6 C  112  ASP GLU GLY GLN VAL ASP MET VAL VAL ASP LYS LEU VAL          
SEQRES   7 C  112  SER ALA ALA ARG THR GLY GLU ILE GLY ASP GLY LYS ILE          
SEQRES   8 C  112  PHE ILE SER PRO VAL ASP SER VAL VAL ARG ILE ARG THR          
SEQRES   9 C  112  GLY GLU LYS ASP THR GLU ALA ILE                              
SEQRES   1 D  112  MET LYS LYS VAL GLU ALA ILE ILE ARG PRO PHE LYS LEU          
SEQRES   2 D  112  ASP GLU VAL LYS ILE ALA LEU VAL ASN ALA GLY ILE VAL          
SEQRES   3 D  112  GLY MET THR VAL SER GLU VAL ARG GLY PHE GLY ARG GLN          
SEQRES   4 D  112  LYS GLY GLN THR GLU ARG TYR ARG GLY SER GLU TYR THR          
SEQRES   5 D  112  VAL GLU PHE LEU GLN LYS LEU LYS ILE GLU ILE VAL VAL          
SEQRES   6 D  112  ASP GLU GLY GLN VAL ASP MET VAL VAL ASP LYS LEU VAL          
SEQRES   7 D  112  SER ALA ALA ARG THR GLY GLU ILE GLY ASP GLY LYS ILE          
SEQRES   8 D  112  PHE ILE SER PRO VAL ASP SER VAL VAL ARG ILE ARG THR          
SEQRES   9 D  112  GLY GLU LYS ASP THR GLU ALA ILE                              
HET     CA    601       1                                                       
HET     CA    602       1                                                       
HET    GOL    500       6                                                       
HET    GOL    501       6                                                       
HETNAM      CA CALCIUM ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   5   CA    2(CA 2+)                                                     
FORMUL   7  GOL    2(C3 H8 O3)                                                  
FORMUL   9  HOH   *212(H2 O)                                                    
CRYST1  129.569  129.569   74.329  90.00  90.00 120.00 H 3          36          
ATOM      1  N   MET A   1     -45.596   5.984 -10.988  1.00 28.27           N  
ATOM      2  CA  MET A   1     -47.016   5.864 -11.444  1.00 27.30           C  
ATOM      3  C   MET A   1     -47.491   7.246 -11.899  1.00 25.32           C  
ATOM      4  O   MET A   1     -47.514   8.188 -11.110  1.00 20.69           O  
ATOM      5  CB  MET A   1     -47.878   5.349 -10.296  1.00 28.27           C  
ATOM      6  CG  MET A   1     -49.246   4.851 -10.708  1.00 33.63           C  
ATOM      7  SD  MET A   1     -49.756   3.403  -9.735  1.00 37.35           S  
ATOM      8  CE  MET A   1     -49.407   3.941  -8.143  1.00 36.72           C  
ATOM      9  N   LYS A   2     -47.886   7.348 -13.163  1.00 23.95           N  
ATOM     10  CA  LYS A   2     -48.318   8.623 -13.723  1.00 23.37           C  
ATOM     11  C   LYS A   2     -49.689   8.607 -14.380  1.00 21.65           C  
ATOM     12  O   LYS A   2     -50.116   7.604 -14.962  1.00 23.24           O  
ATOM     13  CB  LYS A   2     -47.288   9.118 -14.747  1.00 23.16           C  
ATOM     14  CG  LYS A   2     -45.881   9.378 -14.187  1.00 24.34           C  
ATOM     15  CD  LYS A   2     -45.830  10.671 -13.393  1.00 25.10           C  
ATOM     16  CE  LYS A   2     -44.414  11.024 -12.937  1.00 25.82           C  
ATOM     17  NZ  LYS A   2     -44.039  10.343 -11.687  1.00 28.14           N  
ATOM     18  N   LYS A   3     -50.386   9.727 -14.236  1.00 20.04           N  
ATOM     19  CA  LYS A   3     -51.697   9.926 -14.836  1.00 19.78           C  
ATOM     20  C   LYS A   3     -51.439  10.533 -16.206  1.00 17.59           C  
ATOM     21  O   LYS A   3     -50.662  11.485 -16.335  1.00 18.17           O  
ATOM     22  CB  LYS A   3     -52.519  10.911 -14.001  1.00 21.53           C  
ATOM     23  CG  LYS A   3     -53.839  11.313 -14.616  1.00 24.10           C  
ATOM     24  CD  LYS A   3     -54.811  10.152 -14.610  1.00 31.34           C  
ATOM     25  CE  LYS A   3     -56.228  10.637 -14.406  1.00 32.07           C  
ATOM     26  NZ  LYS A   3     -56.362  11.516 -13.209  1.00 32.72           N  
ATOM     27  N   VAL A   4     -52.014   9.928 -17.239  1.00 16.99           N  
ATOM     28  CA  VAL A   4     -51.863  10.444 -18.591  1.00 17.25           C  
ATOM     29  C   VAL A   4     -53.252  10.866 -19.049  1.00 16.25           C  
ATOM     30  O   VAL A   4     -54.169  10.046 -19.156  1.00 18.24           O  
ATOM     31  CB  VAL A   4     -51.272   9.387 -19.553  1.00 16.60           C  
ATOM     32  CG1 VAL A   4     -51.272   9.919 -20.990  1.00 19.63           C  
ATOM     33  CG2 VAL A   4     -49.832   9.055 -19.137  1.00 18.27           C  
ATOM     34  N   GLU A   5     -53.410  12.163 -19.253  1.00 14.15           N  
ATOM     35  CA  GLU A   5     -54.681  12.733 -19.675  1.00 14.47           C  
ATOM     36  C   GLU A   5     -54.526  13.274 -21.081  1.00 15.45           C  
ATOM     37  O   GLU A   5     -53.777  14.228 -21.301  1.00 14.44           O  
ATOM     38  CB  GLU A   5     -55.061  13.863 -18.716  1.00 14.83           C  
ATOM     39  CG  GLU A   5     -56.399  14.495 -18.998  1.00 19.03           C  
ATOM     40  CD  GLU A   5     -56.599  15.789 -18.240  1.00 20.26           C  
ATOM     41  OE1 GLU A   5     -55.771  16.126 -17.368  1.00 21.71           O  
ATOM     42  OE2 GLU A   5     -57.582  16.486 -18.544  1.00 21.87           O  
ATOM     43  N   ALA A   6     -55.197  12.636 -22.034  1.00 14.79           N  
ATOM     44  CA  ALA A   6     -55.123  13.053 -23.429  1.00 15.89           C  
ATOM     45  C   ALA A   6     -56.425  13.671 -23.912  1.00 15.23           C  
ATOM     46  O   ALA A   6     -57.496  13.080 -23.769  1.00 19.52           O  
ATOM     47  CB  ALA A   6     -54.736  11.864 -24.316  1.00 14.82           C  
ATOM     48  N   ILE A   7     -56.329  14.881 -24.444  1.00 14.48           N  
ATOM     49  CA  ILE A   7     -57.486  15.602 -24.967  1.00 14.78           C  
ATOM     50  C   ILE A   7     -57.309  15.487 -26.472  1.00 16.15           C  
ATOM     51  O   ILE A   7     -56.394  16.082 -27.049  1.00 15.63           O  
ATOM     52  CB  ILE A   7     -57.462  17.075 -24.532  1.00 15.64           C  
ATOM     53  CG1 ILE A   7     -57.241  17.178 -23.010  1.00 19.18           C  
ATOM     54  CG2 ILE A   7     -58.752  17.764 -24.932  1.00 15.67           C  
ATOM     55  CD1 ILE A   7     -58.251  16.419 -22.170  1.00 17.80           C  
ATOM     56  N   ILE A   8     -58.170  14.693 -27.100  1.00 16.30           N  
ATOM     57  CA  ILE A   8     -58.053  14.416 -28.529  1.00 15.83           C  
ATOM     58  C   ILE A   8     -59.297  14.688 -29.364  1.00 17.03           C  
ATOM     59  O   ILE A   8     -60.404  14.838 -28.828  1.00 15.77           O  
ATOM     60  CB  ILE A   8     -57.684  12.922 -28.744  1.00 17.96           C  
ATOM     61  CG1 ILE A   8     -58.824  12.014 -28.254  1.00 17.54           C  
ATOM     62  CG2 ILE A   8     -56.401  12.584 -28.002  1.00 19.36           C  
ATOM     63  CD1 ILE A   8     -58.595  10.514 -28.491  1.00 15.97           C  
ATOM     64  N   ARG A   9     -59.110  14.742 -30.687  1.00 16.12           N  
ATOM     65  CA  ARG A   9     -60.238  14.940 -31.598  1.00 15.59           C  
ATOM     66  C   ARG A   9     -61.084  13.678 -31.419  1.00 14.74           C  
ATOM     67  O   ARG A   9     -60.545  12.580 -31.331  1.00 16.52           O  
ATOM     68  CB  ARG A   9     -59.750  15.083 -33.044  1.00 16.59           C  
ATOM     69  CG  ARG A   9     -58.894  16.322 -33.279  1.00 17.92           C  
ATOM     70  CD  ARG A   9     -58.455  16.439 -34.735  1.00 21.57           C  
ATOM     71  NE  ARG A   9     -57.489  17.518 -34.943  1.00 20.86           N  
ATOM     72  CZ  ARG A   9     -57.807  18.769 -35.271  1.00 22.86           C  
ATOM     73  NH1 ARG A   9     -59.074  19.123 -35.425  1.00 21.60           N  
ATOM     74  NH2 ARG A   9     -56.849  19.666 -35.467  1.00 24.76           N  
ATOM     75  N   PRO A  10     -62.419  13.817 -31.366  1.00 13.81           N  
ATOM     76  CA  PRO A  10     -63.317  12.671 -31.180  1.00 15.02           C  
ATOM     77  C   PRO A  10     -63.102  11.498 -32.138  1.00 17.28           C  
ATOM     78  O   PRO A  10     -63.105  10.337 -31.715  1.00 18.24           O  
ATOM     79  CB  PRO A  10     -64.709  13.291 -31.350  1.00 16.19           C  
ATOM     80  CG  PRO A  10     -64.516  14.702 -30.923  1.00 14.58           C  
ATOM     81  CD  PRO A  10     -63.187  15.057 -31.557  1.00 14.79           C  
ATOM     82  N   PHE A  11     -62.885  11.798 -33.414  1.00 19.09           N  
ATOM     83  CA  PHE A  11     -62.687  10.745 -34.404  1.00 20.76           C  
ATOM     84  C   PHE A  11     -61.378   9.976 -34.267  1.00 21.54           C  
ATOM     85  O   PHE A  11     -61.126   9.050 -35.029  1.00 21.43           O  
ATOM     86  CB  PHE A  11     -62.865  11.280 -35.831  1.00 22.13           C  
ATOM     87  CG  PHE A  11     -62.006  12.469 -36.160  1.00 22.74           C  
ATOM     88  CD1 PHE A  11     -60.659  12.313 -36.477  1.00 22.45           C  
ATOM     89  CD2 PHE A  11     -62.562  13.741 -36.217  1.00 25.44           C  
ATOM     90  CE1 PHE A  11     -59.881  13.406 -36.837  1.00 24.88           C  
ATOM     91  CE2 PHE A  11     -61.792  14.843 -36.575  1.00 26.28           C  
ATOM     92  CZ  PHE A  11     -60.453  14.673 -36.894  1.00 25.26           C  
ATOM     93  N   LYS A  12     -60.542  10.365 -33.308  1.00 20.37           N  
ATOM     94  CA  LYS A  12     -59.274   9.676 -33.082  1.00 19.78           C  
ATOM     95  C   LYS A  12     -59.365   8.589 -32.012  1.00 19.96           C  
ATOM     96  O   LYS A  12     -58.393   7.873 -31.779  1.00 20.70           O  
ATOM     97  CB  LYS A  12     -58.169  10.671 -32.704  1.00 22.12           C  
ATOM     98  CG  LYS A  12     -57.638  11.517 -33.858  1.00 21.64           C  
ATOM     99  CD  LYS A  12     -57.017  10.646 -34.946  1.00 22.53           C  
ATOM    100  CE  LYS A  12     -56.400  11.482 -36.066  1.00 25.61           C  
ATOM    101  NZ  LYS A  12     -55.716  10.625 -37.091  1.00 26.58           N  
ATOM    102  N   LEU A  13     -60.533   8.447 -31.386  1.00 21.16           N  
ATOM    103  CA  LEU A  13     -60.742   7.464 -30.320  1.00 21.75           C  
ATOM    104  C   LEU A  13     -60.345   6.051 -30.717  1.00 21.18           C  
ATOM    105  O   LEU A  13     -59.556   5.416 -30.021  1.00 20.31           O  
ATOM    106  CB  LEU A  13     -62.210   7.443 -29.874  1.00 23.34           C  
ATOM    107  CG  LEU A  13     -62.572   7.137 -28.408  1.00 28.22           C  
ATOM    108  CD1 LEU A  13     -63.919   6.438 -28.376  1.00 26.44           C  
ATOM    109  CD2 LEU A  13     -61.530   6.302 -27.678  1.00 29.41           C  
ATOM    110  N   ASP A  14     -60.916   5.544 -31.809  1.00 20.95           N  
ATOM    111  CA  ASP A  14     -60.600   4.185 -32.241  1.00 22.74           C  
ATOM    112  C   ASP A  14     -59.113   3.928 -32.463  1.00 20.66           C  
ATOM    113  O   ASP A  14     -58.582   2.919 -31.999  1.00 20.83           O  
ATOM    114  CB  ASP A  14     -61.437   3.757 -33.458  1.00 27.19           C  
ATOM    115  CG  ASP A  14     -61.470   4.801 -34.578  1.00 33.99           C  
ATOM    116  OD1 ASP A  14     -60.629   5.730 -34.617  1.00 34.13           O  
ATOM    117  OD2 ASP A  14     -62.362   4.675 -35.443  1.00 36.29           O  
ATOM    118  N   GLU A  15     -58.438   4.854 -33.139  0.50 20.80           N  
ATOM    120  CA  GLU A  15     -57.005   4.733 -33.403  0.50 22.97           C  
ATOM    122  C   GLU A  15     -56.221   4.698 -32.106  0.50 22.99           C  
ATOM    124  O   GLU A  15     -55.283   3.912 -31.947  0.50 22.91           O  
ATOM    126  CB  GLU A  15     -56.526   5.923 -34.236  0.50 24.63           C  
ATOM    128  CG  GLU A  15     -57.074   5.931 -35.641  0.50 29.23           C  
ATOM    130  CD  GLU A  15     -57.690   7.253 -36.050  0.50 30.30           C  
ATOM    132  OE1 GLU A  15     -58.757   7.607 -35.517  0.50 32.57           O  
ATOM    134  OE2 GLU A  15     -57.121   7.941 -36.921  0.50 32.38           O  
ATOM    136  N   VAL A  16     -56.639   5.539 -31.169  1.00 21.94           N  
ATOM    137  CA  VAL A  16     -55.972   5.641 -29.880  1.00 22.47           C  
ATOM    138  C   VAL A  16     -56.222   4.367 -29.082  1.00 22.99           C  
ATOM    139  O   VAL A  16     -55.300   3.807 -28.493  1.00 24.48           O  
ATOM    140  CB  VAL A  16     -56.467   6.886 -29.113  1.00 21.04           C  
ATOM    141  CG1 VAL A  16     -56.018   6.843 -27.654  1.00 22.00           C  
ATOM    142  CG2 VAL A  16     -55.949   8.142 -29.811  1.00 20.97           C  
ATOM    143  N   LYS A  17     -57.459   3.879 -29.118  1.00 25.17           N  
ATOM    144  CA  LYS A  17     -57.808   2.654 -28.412  1.00 26.59           C  
ATOM    145  C   LYS A  17     -56.919   1.511 -28.915  1.00 27.51           C  
ATOM    146  O   LYS A  17     -56.324   0.780 -28.122  1.00 26.35           O  
ATOM    147  CB  LYS A  17     -59.289   2.317 -28.629  1.00 30.29           C  
ATOM    148  CG  LYS A  17     -59.760   1.082 -27.862  1.00 33.09           C  
ATOM    149  CD  LYS A  17     -61.232   0.788 -28.102  1.00 37.75           C  
ATOM    150  CE  LYS A  17     -61.489   0.411 -29.552  1.00 39.75           C  
ATOM    151  NZ  LYS A  17     -62.942   0.211 -29.844  1.00 42.77           N  
ATOM    152  N   ILE A  18     -56.782   1.407 -30.235  1.00 26.72           N  
ATOM    153  CA  ILE A  18     -55.962   0.364 -30.838  1.00 28.36           C  
ATOM    154  C   ILE A  18     -54.506   0.523 -30.409  1.00 27.62           C  
ATOM    155  O   ILE A  18     -53.880  -0.445 -29.982  1.00 27.98           O  
ATOM    156  CB  ILE A  18     -56.072   0.378 -32.380  1.00 30.14           C  
ATOM    157  CG1 ILE A  18     -57.495   0.006 -32.801  1.00 31.63           C  
ATOM    158  CG2 ILE A  18     -55.058  -0.591 -33.006  1.00 32.92           C  
ATOM    159  CD1 ILE A  18     -57.727   0.021 -34.298  1.00 33.74           C  
ATOM    160  N   ALA A  19     -54.003   1.756 -30.455  1.00 26.80           N  
ATOM    161  CA  ALA A  19     -52.626   2.047 -30.070  1.00 28.55           C  
ATOM    162  C   ALA A  19     -52.356   1.598 -28.636  1.00 30.33           C  
ATOM    163  O   ALA A  19     -51.371   0.910 -28.374  1.00 29.90           O  
ATOM    164  CB  ALA A  19     -52.346   3.541 -30.215  1.00 29.57           C  
ATOM    165  N   LEU A  20     -53.259   1.957 -27.722  1.00 31.03           N  
ATOM    166  CA  LEU A  20     -53.128   1.597 -26.311  1.00 31.26           C  
ATOM    167  C   LEU A  20     -53.237   0.096 -26.069  1.00 32.81           C  
ATOM    168  O   LEU A  20     -52.486  -0.444 -25.256  1.00 32.02           O  
ATOM    169  CB  LEU A  20     -54.164   2.335 -25.462  1.00 29.59           C  
ATOM    170  CG  LEU A  20     -54.077   3.864 -25.443  1.00 29.95           C  
ATOM    171  CD1 LEU A  20     -55.219   4.428 -24.611  1.00 30.24           C  
ATOM    172  CD2 LEU A  20     -52.737   4.310 -24.885  1.00 28.81           C  
ATOM    173  N   VAL A  21     -54.172  -0.565 -26.760  1.00 34.89           N  
ATOM    174  CA  VAL A  21     -54.356  -2.009 -26.608  1.00 38.45           C  
ATOM    175  C   VAL A  21     -53.070  -2.767 -26.920  1.00 40.38           C  
ATOM    176  O   VAL A  21     -52.538  -3.466 -26.044  1.00 40.84           O  
ATOM    177  CB  VAL A  21     -55.536  -2.564 -27.444  1.00 38.78           C  
ATOM    178  CG1 VAL A  21     -55.530  -4.091 -27.439  1.00 39.64           C  
ATOM    179  CG2 VAL A  21     -56.866  -2.078 -26.882  1.00 39.56           C  
ATOM    180  N   ASN A  22     -52.556  -2.630 -28.141  1.00 42.69           N  
ATOM    181  CA  ASN A  22     -51.314  -3.329 -28.492  1.00 45.49           C  
ATOM    182  C   ASN A  22     -50.078  -2.769 -27.784  1.00 45.07           C  
ATOM    183  O   ASN A  22     -48.966  -3.186 -28.042  1.00 46.17           O  
ATOM    184  CB  ASN A  22     -51.058  -3.375 -30.010  1.00 48.20           C  
ATOM    185  CG  ASN A  22     -52.183  -2.773 -30.833  1.00 51.45           C  
ATOM    186  OD1 ASN A  22     -53.310  -3.279 -30.852  1.00 53.32           O  
ATOM    187  ND2 ASN A  22     -51.879  -1.673 -31.515  1.00 51.71           N  
ATOM    188  N   ALA A  23     -50.288  -1.797 -26.907  1.00 45.11           N  
ATOM    189  CA  ALA A  23     -49.203  -1.198 -26.139  1.00 43.30           C  
ATOM    190  C   ALA A  23     -49.214  -1.787 -24.732  1.00 42.70           C  
ATOM    191  O   ALA A  23     -48.401  -1.422 -23.884  1.00 42.33           O  
ATOM    192  CB  ALA A  23     -49.326   0.314 -26.097  1.00 44.14           C  
ATOM    193  N   GLY A  24     -50.155  -2.697 -24.494  1.00 40.88           N  
ATOM    194  CA  GLY A  24     -50.267  -3.350 -23.204  1.00 40.39           C  
ATOM    195  C   GLY A  24     -51.027  -2.542 -22.172  1.00 39.74           C  
ATOM    196  O   GLY A  24     -50.919  -2.817 -20.976  1.00 39.05           O  
ATOM    197  N   ILE A  25     -51.767  -1.531 -22.620  1.00 38.21           N  
ATOM    198  CA  ILE A  25     -52.539  -0.701 -21.707  1.00 38.23           C  
ATOM    199  C   ILE A  25     -53.925  -1.295 -21.570  1.00 38.18           C  
ATOM    200  O   ILE A  25     -54.640  -1.463 -22.562  1.00 38.73           O  
ATOM    201  CB  ILE A  25     -52.653   0.766 -22.199  1.00 38.66           C  
ATOM    202  CG1 ILE A  25     -51.258   1.378 -22.339  1.00 39.34           C  
ATOM    203  CG2 ILE A  25     -53.508   1.583 -21.236  1.00 38.71           C  
ATOM    204  CD1 ILE A  25     -50.380   1.203 -21.116  1.00 38.84           C  
ATOM    205  N   VAL A  26     -54.280  -1.663 -20.345  1.00 38.49           N  
ATOM    206  CA  VAL A  26     -55.590  -2.235 -20.082  1.00 39.50           C  
ATOM    207  C   VAL A  26     -56.410  -1.273 -19.239  1.00 38.71           C  
ATOM    208  O   VAL A  26     -56.033  -0.921 -18.122  1.00 40.68           O  
ATOM    209  CB  VAL A  26     -55.484  -3.617 -19.373  1.00 39.82           C  
ATOM    210  CG1 VAL A  26     -54.800  -4.623 -20.294  1.00 40.43           C  
ATOM    211  CG2 VAL A  26     -54.720  -3.511 -18.065  1.00 40.66           C  
ATOM    212  N   GLY A  27     -57.514  -0.809 -19.805  1.00 37.39           N  
ATOM    213  CA  GLY A  27     -58.372   0.105 -19.087  1.00 35.88           C  
ATOM    214  C   GLY A  27     -58.064   1.567 -19.339  1.00 34.19           C  
ATOM    215  O   GLY A  27     -56.907   1.994 -19.359  1.00 35.03           O  
ATOM    216  N   MET A  28     -59.123   2.327 -19.581  1.00 31.64           N  
ATOM    217  CA  MET A  28     -59.031   3.759 -19.822  1.00 28.46           C  
ATOM    218  C   MET A  28     -60.427   4.303 -19.595  1.00 26.84           C  
ATOM    219  O   MET A  28     -61.410   3.558 -19.661  1.00 25.22           O  
ATOM    220  CB  MET A  28     -58.588   4.060 -21.263  1.00 28.60           C  
ATOM    221  CG  MET A  28     -59.656   3.836 -22.334  1.00 30.41           C  
ATOM    222  SD  MET A  28     -59.151   4.301 -24.021  1.00 33.79           S  
ATOM    223  CE  MET A  28     -58.492   2.728 -24.613  1.00 37.64           C  
ATOM    224  N   THR A  29     -60.511   5.586 -19.270  1.00 24.01           N  
ATOM    225  CA  THR A  29     -61.801   6.230 -19.066  1.00 23.77           C  
ATOM    226  C   THR A  29     -61.888   7.338 -20.100  1.00 22.03           C  
ATOM    227  O   THR A  29     -60.906   8.048 -20.354  1.00 19.47           O  
ATOM    228  CB  THR A  29     -61.967   6.803 -17.637  1.00 25.45           C  
ATOM    229  OG1 THR A  29     -60.895   7.705 -17.348  1.00 31.24           O  
ATOM    230  CG2 THR A  29     -61.971   5.683 -16.615  1.00 29.48           C  
ATOM    231  N   VAL A  30     -63.048   7.457 -20.729  1.00 18.97           N  
ATOM    232  CA  VAL A  30     -63.242   8.456 -21.768  1.00 19.15           C  
ATOM    233  C   VAL A  30     -64.438   9.331 -21.464  1.00 20.99           C  
ATOM    234  O   VAL A  30     -65.493   8.842 -21.054  1.00 18.79           O  
ATOM    235  CB  VAL A  30     -63.485   7.788 -23.147  1.00 21.87           C  
ATOM    236  CG1 VAL A  30     -63.704   8.854 -24.215  1.00 23.24           C  
ATOM    237  CG2 VAL A  30     -62.318   6.885 -23.519  1.00 23.36           C  
ATOM    238  N   SER A  31     -64.278  10.629 -21.687  1.00 20.32           N  
ATOM    239  CA  SER A  31     -65.369  11.556 -21.450  1.00 20.53           C  
ATOM    240  C   SER A  31     -65.366  12.651 -22.498  1.00 21.72           C  
ATOM    241  O   SER A  31     -64.345  12.922 -23.136  1.00 19.69           O  
ATOM    242  CB  SER A  31     -65.285  12.154 -20.042  1.00 20.51           C  
ATOM    243  OG  SER A  31     -64.069  12.842 -19.844  1.00 22.82           O  
ATOM    244  N   GLU A  32     -66.532  13.253 -22.692  1.00 21.33           N  
ATOM    245  CA  GLU A  32     -66.691  14.326 -23.657  1.00 23.72           C  
ATOM    246  C   GLU A  32     -66.355  15.650 -22.993  1.00 23.22           C  
ATOM    247  O   GLU A  32     -66.785  15.912 -21.869  1.00 23.34           O  
ATOM    248  CB  GLU A  32     -68.129  14.353 -24.180  1.00 27.07           C  
ATOM    249  CG  GLU A  32     -68.531  13.093 -24.937  1.00 34.89           C  
ATOM    250  CD  GLU A  32     -70.030  12.984 -25.163  1.00 39.71           C  
ATOM    251  OE1 GLU A  32     -70.658  13.980 -25.586  1.00 42.85           O  
ATOM    252  OE2 GLU A  32     -70.581  11.891 -24.915  1.00 43.10           O  
ATOM    253  N   VAL A  33     -65.562  16.466 -23.681  1.00 20.74           N  
ATOM    254  CA  VAL A  33     -65.172  17.776 -23.171  1.00 18.97           C  
ATOM    255  C   VAL A  33     -65.147  18.748 -24.344  1.00 20.45           C  
ATOM    256  O   VAL A  33     -65.319  18.353 -25.501  1.00 20.69           O  
ATOM    257  CB  VAL A  33     -63.745  17.776 -22.522  1.00 18.94           C  
ATOM    258  CG1 VAL A  33     -63.668  16.787 -21.350  1.00 18.04           C  
ATOM    259  CG2 VAL A  33     -62.665  17.480 -23.567  1.00 18.25           C  
ATOM    260  N   ARG A  34     -64.943  20.022 -24.034  1.00 19.55           N  
ATOM    261  CA  ARG A  34     -64.841  21.052 -25.054  1.00 21.02           C  
ATOM    262  C   ARG A  34     -63.458  21.660 -24.902  1.00 21.02           C  
ATOM    263  O   ARG A  34     -63.034  21.972 -23.786  1.00 18.30           O  
ATOM    264  CB  ARG A  34     -65.911  22.128 -24.859  1.00 23.94           C  
ATOM    265  CG  ARG A  34     -67.311  21.683 -25.245  1.00 28.11           C  
ATOM    266  CD  ARG A  34     -68.342  22.773 -24.987  1.00 30.44           C  
ATOM    267  NE  ARG A  34     -68.653  22.916 -23.566  1.00 34.11           N  
ATOM    268  CZ  ARG A  34     -69.316  23.942 -23.042  1.00 35.34           C  
ATOM    269  NH1 ARG A  34     -69.742  24.928 -23.823  1.00 35.17           N  
ATOM    270  NH2 ARG A  34     -69.567  23.977 -21.739  1.00 35.48           N  
ATOM    271  N   GLY A  35     -62.724  21.724 -26.007  1.00 20.77           N  
ATOM    272  CA  GLY A  35     -61.401  22.314 -25.989  1.00 23.90           C  
ATOM    273  C   GLY A  35     -61.500  23.703 -26.591  1.00 26.66           C  
ATOM    274  O   GLY A  35     -61.929  23.860 -27.737  1.00 25.92           O  
ATOM    275  N   PHE A  36     -61.183  24.719 -25.800  1.00 28.68           N  
ATOM    276  CA  PHE A  36     -61.229  26.093 -26.283  1.00 32.56           C  
ATOM    277  C   PHE A  36     -59.835  26.482 -26.730  1.00 34.79           C  
ATOM    278  O   PHE A  36     -59.704  26.901 -27.897  1.00 36.93           O  
ATOM    279  CB  PHE A  36     -61.727  27.050 -25.192  1.00 32.52           C  
ATOM    280  CG  PHE A  36     -63.227  27.051 -25.019  1.00 32.47           C  
ATOM    281  CD1 PHE A  36     -63.872  25.998 -24.378  1.00 33.02           C  
ATOM    282  CD2 PHE A  36     -63.990  28.120 -25.482  1.00 32.86           C  
ATOM    283  CE1 PHE A  36     -65.258  26.006 -24.202  1.00 33.89           C  
ATOM    284  CE2 PHE A  36     -65.378  28.141 -25.312  1.00 34.13           C  
ATOM    285  CZ  PHE A  36     -66.013  27.083 -24.669  1.00 33.32           C  
ATOM    286  N   GLU A  54     -62.422  29.091 -30.490  1.00 61.70           N  
ATOM    287  CA  GLU A  54     -63.445  28.910 -29.419  1.00 61.28           C  
ATOM    288  C   GLU A  54     -63.706  27.423 -29.150  1.00 59.59           C  
ATOM    289  O   GLU A  54     -62.801  26.600 -29.303  1.00 61.02           O  
ATOM    290  CB  GLU A  54     -64.743  29.666 -29.775  1.00 62.64           C  
ATOM    291  CG  GLU A  54     -65.695  28.991 -30.777  1.00 64.56           C  
ATOM    292  CD  GLU A  54     -65.150  28.878 -32.191  1.00 65.70           C  
ATOM    293  OE1 GLU A  54     -64.115  29.503 -32.506  1.00 66.78           O  
ATOM    294  OE2 GLU A  54     -65.778  28.163 -32.999  1.00 66.74           O  
ATOM    295  N   PHE A  55     -64.931  27.082 -28.753  1.00 57.62           N  
ATOM    296  CA  PHE A  55     -65.298  25.700 -28.445  1.00 53.98           C  
ATOM    297  C   PHE A  55     -65.199  24.706 -29.610  1.00 50.50           C  
ATOM    298  O   PHE A  55     -65.588  25.003 -30.742  1.00 50.20           O  
ATOM    299  CB  PHE A  55     -66.675  25.685 -27.738  1.00 56.28           C  
ATOM    300  CG  PHE A  55     -67.711  24.782 -28.366  1.00 58.65           C  
ATOM    301  CD1 PHE A  55     -67.588  23.398 -28.303  1.00 58.92           C  
ATOM    302  CD2 PHE A  55     -68.853  25.323 -28.958  1.00 60.37           C  
ATOM    303  CE1 PHE A  55     -68.576  22.566 -28.829  1.00 60.50           C  
ATOM    304  CE2 PHE A  55     -69.849  24.495 -29.488  1.00 61.62           C  
ATOM    305  CZ  PHE A  55     -69.712  23.113 -29.417  1.00 61.56           C  
ATOM    306  N   LEU A  56     -64.647  23.531 -29.307  1.00 45.15           N  
ATOM    307  CA  LEU A  56     -64.471  22.442 -30.266  1.00 38.57           C  
ATOM    308  C   LEU A  56     -64.637  21.148 -29.463  1.00 34.97           C  
ATOM    309  O   LEU A  56     -63.997  20.987 -28.420  1.00 31.94           O  
ATOM    310  CB  LEU A  56     -63.063  22.505 -30.865  1.00 39.63           C  
ATOM    311  CG  LEU A  56     -62.828  22.030 -32.302  1.00 40.05           C  
ATOM    312  CD1 LEU A  56     -63.666  22.858 -33.264  1.00 40.76           C  
ATOM    313  CD2 LEU A  56     -61.354  22.161 -32.663  1.00 41.44           C  
ATOM    314  N   GLN A  57     -65.514  20.251 -29.913  1.00 30.11           N  
ATOM    315  CA  GLN A  57     -65.738  18.991 -29.202  1.00 27.72           C  
ATOM    316  C   GLN A  57     -64.491  18.111 -29.207  1.00 24.31           C  
ATOM    317  O   GLN A  57     -63.866  17.897 -30.243  1.00 21.94           O  
ATOM    318  CB  GLN A  57     -66.917  18.216 -29.797  1.00 31.02           C  
ATOM    319  CG  GLN A  57     -68.280  18.902 -29.639  1.00 35.98           C  
ATOM    320  CD  GLN A  57     -68.750  19.007 -28.190  1.00 38.90           C  
ATOM    321  OE1 GLN A  57     -69.371  19.997 -27.802  1.00 40.92           O  
ATOM    322  NE2 GLN A  57     -68.479  17.975 -27.394  1.00 39.43           N  
ATOM    323  N   LYS A  58     -64.138  17.608 -28.033  1.00 21.83           N  
ATOM    324  CA  LYS A  58     -62.966  16.754 -27.873  1.00 18.89           C  
ATOM    325  C   LYS A  58     -63.315  15.605 -26.946  1.00 15.32           C  
ATOM    326  O   LYS A  58     -64.388  15.579 -26.353  1.00 16.30           O  
ATOM    327  CB  LYS A  58     -61.809  17.554 -27.245  1.00 19.41           C  
ATOM    328  CG  LYS A  58     -61.092  18.549 -28.152  1.00 22.25           C  
ATOM    329  CD  LYS A  58     -59.937  17.893 -28.882  1.00 23.87           C  
ATOM    330  CE  LYS A  58     -59.035  18.912 -29.566  1.00 24.00           C  
ATOM    331  NZ  LYS A  58     -59.775  19.742 -30.562  1.00 23.68           N  
ATOM    332  N   LEU A  59     -62.404  14.648 -26.830  1.00 15.89           N  
ATOM    333  CA  LEU A  59     -62.594  13.524 -25.929  1.00 16.87           C  
ATOM    334  C   LEU A  59     -61.427  13.517 -24.960  1.00 17.94           C  
ATOM    335  O   LEU A  59     -60.278  13.733 -25.350  1.00 19.73           O  
ATOM    336  CB  LEU A  59     -62.634  12.195 -26.688  1.00 19.08           C  
ATOM    337  CG  LEU A  59     -63.895  11.936 -27.514  1.00 19.35           C  
ATOM    338  CD1 LEU A  59     -63.823  10.551 -28.110  1.00 18.88           C  
ATOM    339  CD2 LEU A  59     -65.147  12.062 -26.632  1.00 18.44           C  
ATOM    340  N   LYS A  60     -61.736  13.316 -23.691  1.00 16.67           N  
ATOM    341  CA  LYS A  60     -60.723  13.269 -22.666  1.00 17.53           C  
ATOM    342  C   LYS A  60     -60.478  11.814 -22.316  1.00 18.19           C  
ATOM    343  O   LYS A  60     -61.395  11.102 -21.903  1.00 16.98           O  
ATOM    344  CB  LYS A  60     -61.205  14.047 -21.444  1.00 18.09           C  
ATOM    345  CG  LYS A  60     -60.309  13.981 -20.223  1.00 23.83           C  
ATOM    346  CD  LYS A  60     -60.848  14.938 -19.164  1.00 22.40           C  
ATOM    347  CE  LYS A  60     -60.045  14.865 -17.895  1.00 29.14           C  
ATOM    348  NZ  LYS A  60     -60.604  15.770 -16.853  1.00 27.87           N  
ATOM    349  N   ILE A  61     -59.250  11.363 -22.534  1.00 16.97           N  
ATOM    350  CA  ILE A  61     -58.882   9.987 -22.224  1.00 19.95           C  
ATOM    351  C   ILE A  61     -57.952   9.986 -21.028  1.00 20.77           C  
ATOM    352  O   ILE A  61     -56.922  10.657 -21.034  1.00 19.88           O  
ATOM    353  CB  ILE A  61     -58.186   9.297 -23.425  1.00 20.72           C  
ATOM    354  CG1 ILE A  61     -59.194   9.143 -24.572  1.00 22.53           C  
ATOM    355  CG2 ILE A  61     -57.599   7.943 -22.999  1.00 22.84           C  
ATOM    356  CD1 ILE A  61     -58.713   8.296 -25.711  1.00 29.24           C  
ATOM    357  N   GLU A  62     -58.338   9.245 -19.993  0.50 21.36           N  
ATOM    359  CA  GLU A  62     -57.556   9.145 -18.766  0.50 23.51           C  
ATOM    361  C   GLU A  62     -57.035   7.724 -18.559  0.50 23.48           C  
ATOM    363  O   GLU A  62     -57.813   6.770 -18.598  0.50 23.51           O  
ATOM    365  CB  GLU A  62     -58.426   9.518 -17.561  0.50 24.87           C  
ATOM    367  CG  GLU A  62     -59.061  10.901 -17.617  0.50 30.49           C  
ATOM    369  CD  GLU A  62     -58.285  11.930 -16.825  0.50 32.38           C  
ATOM    371  OE1 GLU A  62     -57.083  12.105 -17.099  0.50 34.93           O  
ATOM    373  OE2 GLU A  62     -58.871  12.561 -15.922  0.50 34.11           O  
ATOM    375  N   ILE A  63     -55.724   7.586 -18.359  1.00 22.60           N  
ATOM    376  CA  ILE A  63     -55.115   6.279 -18.104  1.00 23.90           C  
ATOM    377  C   ILE A  63     -54.046   6.489 -17.047  1.00 23.63           C  
ATOM    378  O   ILE A  63     -53.499   7.580 -16.914  1.00 23.50           O  
ATOM    379  CB  ILE A  63     -54.455   5.618 -19.345  1.00 25.22           C  
ATOM    380  CG1 ILE A  63     -53.340   6.495 -19.907  1.00 28.84           C  
ATOM    381  CG2 ILE A  63     -55.482   5.301 -20.400  1.00 28.06           C  
ATOM    382  CD1 ILE A  63     -52.617   5.860 -21.074  1.00 30.87           C  
ATOM    383  N   VAL A  64     -53.791   5.459 -16.257  1.00 24.92           N  
ATOM    384  CA  VAL A  64     -52.768   5.542 -15.226  1.00 26.39           C  
ATOM    385  C   VAL A  64     -51.821   4.398 -15.515  1.00 29.80           C  
ATOM    386  O   VAL A  64     -52.222   3.233 -15.508  1.00 30.80           O  
ATOM    387  CB  VAL A  64     -53.379   5.450 -13.812  1.00 26.39           C  
ATOM    388  CG1 VAL A  64     -52.285   5.352 -12.756  1.00 26.04           C  
ATOM    389  CG2 VAL A  64     -54.246   6.686 -13.543  1.00 24.36           C  
ATOM    390  N   VAL A  65     -50.583   4.754 -15.851  1.00 31.12           N  
ATOM    391  CA  VAL A  65     -49.564   3.776 -16.195  1.00 33.18           C  
ATOM    392  C   VAL A  65     -48.324   3.853 -15.306  1.00 35.07           C  
ATOM    393  O   VAL A  65     -48.130   4.817 -14.557  1.00 34.72           O  
ATOM    394  CB  VAL A  65     -49.122   3.952 -17.655  1.00 33.56           C  
ATOM    395  CG1 VAL A  65     -50.333   3.861 -18.584  1.00 36.35           C  
ATOM    396  CG2 VAL A  65     -48.404   5.282 -17.836  1.00 29.13           C  
ATOM    397  N   ASP A  66     -47.488   2.824 -15.402  1.00 34.88           N  
ATOM    398  CA  ASP A  66     -46.250   2.756 -14.636  1.00 35.10           C  
ATOM    399  C   ASP A  66     -45.235   3.731 -15.226  1.00 34.39           C  
ATOM    400  O   ASP A  66     -45.270   4.017 -16.422  1.00 33.24           O  
ATOM    401  CB  ASP A  66     -45.683   1.335 -14.688  1.00 37.20           C  
ATOM    402  CG  ASP A  66     -46.610   0.315 -14.057  1.00 39.25           C  
ATOM    403  OD1 ASP A  66     -47.111   0.569 -12.937  1.00 40.27           O  
ATOM    404  OD2 ASP A  66     -46.832  -0.743 -14.682  1.00 41.54           O  
ATOM    405  N   GLU A  67     -44.326   4.230 -14.392  1.00 34.13           N  
ATOM    406  CA  GLU A  67     -43.303   5.169 -14.847  1.00 37.14           C  
ATOM    407  C   GLU A  67     -42.574   4.713 -16.106  1.00 36.54           C  
ATOM    408  O   GLU A  67     -42.367   5.504 -17.025  1.00 36.95           O  
ATOM    409  CB  GLU A  67     -42.281   5.443 -13.740  1.00 39.39           C  
ATOM    410  CG  GLU A  67     -42.704   6.503 -12.733  1.00 45.06           C  
ATOM    411  CD  GLU A  67     -41.634   6.744 -11.680  1.00 47.65           C  
ATOM    412  OE1 GLU A  67     -41.897   6.468 -10.487  1.00 48.20           O  
ATOM    413  OE2 GLU A  67     -40.527   7.201 -12.046  1.00 49.77           O  
ATOM    414  N   GLY A  68     -42.210   3.434 -16.151  1.00 36.25           N  
ATOM    415  CA  GLY A  68     -41.502   2.893 -17.300  1.00 36.25           C  
ATOM    416  C   GLY A  68     -42.322   2.756 -18.572  1.00 36.39           C  
ATOM    417  O   GLY A  68     -41.779   2.402 -19.616  1.00 38.34           O  
ATOM    418  N   GLN A  69     -43.620   3.033 -18.494  1.00 36.47           N  
ATOM    419  CA  GLN A  69     -44.506   2.936 -19.654  1.00 35.29           C  
ATOM    420  C   GLN A  69     -44.888   4.302 -20.219  1.00 34.31           C  
ATOM    421  O   GLN A  69     -45.311   4.403 -21.370  1.00 33.39           O  
ATOM    422  CB  GLN A  69     -45.800   2.212 -19.283  1.00 36.64           C  
ATOM    423  CG  GLN A  69     -45.641   0.802 -18.773  1.00 39.76           C  
ATOM    424  CD  GLN A  69     -46.977   0.200 -18.400  1.00 41.45           C  
ATOM    425  OE1 GLN A  69     -47.620   0.631 -17.436  1.00 42.44           O  
ATOM    426  NE2 GLN A  69     -47.418  -0.783 -19.173  1.00 41.39           N  
ATOM    427  N   VAL A  70     -44.754   5.343 -19.402  1.00 32.47           N  
ATOM    428  CA  VAL A  70     -45.125   6.700 -19.801  1.00 31.63           C  
ATOM    429  C   VAL A  70     -44.605   7.166 -21.155  1.00 31.38           C  
ATOM    430  O   VAL A  70     -45.399   7.443 -22.054  1.00 28.72           O  
ATOM    431  CB  VAL A  70     -44.744   7.735 -18.717  1.00 32.53           C  
ATOM    432  CG1 VAL A  70     -45.189   9.136 -19.142  1.00 31.10           C  
ATOM    433  CG2 VAL A  70     -45.398   7.360 -17.393  1.00 31.90           C  
ATOM    434  N   ASP A  71     -43.284   7.240 -21.300  1.00 30.80           N  
ATOM    435  CA  ASP A  71     -42.675   7.689 -22.550  1.00 33.95           C  
ATOM    436  C   ASP A  71     -43.187   6.938 -23.771  1.00 33.16           C  
ATOM    437  O   ASP A  71     -43.473   7.541 -24.806  1.00 33.44           O  
ATOM    438  CB  ASP A  71     -41.148   7.587 -22.474  1.00 35.30           C  
ATOM    439  CG  ASP A  71     -40.518   8.731 -21.691  1.00 37.80           C  
ATOM    440  OD1 ASP A  71     -41.234   9.447 -20.957  1.00 40.33           O  
ATOM    441  OD2 ASP A  71     -39.292   8.919 -21.812  1.00 40.80           O  
ATOM    442  N   MET A  72     -43.328   5.624 -23.628  1.00 33.41           N  
ATOM    443  CA  MET A  72     -43.806   4.769 -24.706  1.00 33.48           C  
ATOM    444  C   MET A  72     -45.272   5.067 -25.018  1.00 31.84           C  
ATOM    445  O   MET A  72     -45.635   5.286 -26.172  1.00 31.01           O  
ATOM    446  CB  MET A  72     -43.606   3.296 -24.314  1.00 36.07           C  
ATOM    447  CG  MET A  72     -44.034   2.266 -25.349  1.00 37.83           C  
ATOM    448  SD  MET A  72     -45.765   1.784 -25.201  1.00 41.67           S  
ATOM    449  CE  MET A  72     -45.726   0.764 -23.721  1.00 40.16           C  
ATOM    450  N   VAL A  73     -46.102   5.116 -23.979  1.00 30.79           N  
ATOM    451  CA  VAL A  73     -47.529   5.388 -24.137  1.00 29.40           C  
ATOM    452  C   VAL A  73     -47.803   6.762 -24.750  1.00 27.63           C  
ATOM    453  O   VAL A  73     -48.678   6.898 -25.604  1.00 27.50           O  
ATOM    454  CB  VAL A  73     -48.282   5.242 -22.798  1.00 29.26           C  
ATOM    455  CG1 VAL A  73     -49.727   5.703 -22.939  1.00 30.09           C  
ATOM    456  CG2 VAL A  73     -48.242   3.791 -22.348  1.00 30.54           C  
ATOM    457  N   VAL A  74     -47.044   7.769 -24.328  1.00 26.41           N  
ATOM    458  CA  VAL A  74     -47.204   9.117 -24.852  1.00 25.94           C  
ATOM    459  C   VAL A  74     -46.855   9.136 -26.337  1.00 26.28           C  
ATOM    460  O   VAL A  74     -47.594   9.702 -27.147  1.00 25.33           O  
ATOM    461  CB  VAL A  74     -46.335  10.137 -24.069  1.00 26.29           C  
ATOM    462  CG1 VAL A  74     -46.326  11.486 -24.769  1.00 27.33           C  
ATOM    463  CG2 VAL A  74     -46.881  10.304 -22.667  1.00 25.70           C  
ATOM    464  N   ASP A  75     -45.752   8.486 -26.696  1.00 26.42           N  
ATOM    465  CA  ASP A  75     -45.327   8.429 -28.094  1.00 27.51           C  
ATOM    466  C   ASP A  75     -46.425   7.824 -28.966  1.00 26.01           C  
ATOM    467  O   ASP A  75     -46.798   8.399 -29.989  1.00 26.61           O  
ATOM    468  CB  ASP A  75     -44.030   7.620 -28.240  1.00 30.28           C  
ATOM    469  CG  ASP A  75     -42.801   8.381 -27.753  1.00 32.41           C  
ATOM    470  OD1 ASP A  75     -42.835   9.632 -27.681  1.00 32.41           O  
ATOM    471  OD2 ASP A  75     -41.787   7.718 -27.454  1.00 35.18           O  
ATOM    472  N   LYS A  76     -46.964   6.689 -28.523  1.00 25.15           N  
ATOM    473  CA  LYS A  76     -48.029   5.988 -29.240  1.00 25.35           C  
ATOM    474  C   LYS A  76     -49.289   6.837 -29.326  1.00 25.73           C  
ATOM    475  O   LYS A  76     -49.976   6.836 -30.351  1.00 24.19           O  
ATOM    476  CB  LYS A  76     -48.334   4.651 -28.571  1.00 26.39           C  
ATOM    477  N   LEU A  77     -49.588   7.562 -28.248  1.00 24.21           N  
ATOM    478  CA  LEU A  77     -50.755   8.438 -28.209  1.00 23.43           C  
ATOM    479  C   LEU A  77     -50.632   9.559 -29.226  1.00 22.75           C  
ATOM    480  O   LEU A  77     -51.582   9.853 -29.945  1.00 23.62           O  
ATOM    481  CB  LEU A  77     -50.935   9.038 -26.811  1.00 22.76           C  
ATOM    482  CG  LEU A  77     -51.772   8.203 -25.845  1.00 23.04           C  
ATOM    483  CD1 LEU A  77     -51.690   8.776 -24.445  1.00 20.43           C  
ATOM    484  CD2 LEU A  77     -53.205   8.175 -26.323  1.00 24.71           C  
ATOM    485  N   VAL A  78     -49.459  10.187 -29.275  1.00 23.18           N  
ATOM    486  CA  VAL A  78     -49.210  11.283 -30.207  1.00 23.25           C  
ATOM    487  C   VAL A  78     -49.298  10.810 -31.658  1.00 23.66           C  
ATOM    488  O   VAL A  78     -49.908  11.476 -32.498  1.00 25.10           O  
ATOM    489  CB  VAL A  78     -47.832  11.943 -29.952  1.00 23.03           C  
ATOM    490  CG1 VAL A  78     -47.462  12.877 -31.098  1.00 22.37           C  
ATOM    491  CG2 VAL A  78     -47.862  12.723 -28.638  1.00 22.41           C  
ATOM    492  N   SER A  79     -48.690   9.662 -31.945  1.00 24.96           N  
ATOM    493  CA  SER A  79     -48.711   9.084 -33.292  1.00 26.62           C  
ATOM    494  C   SER A  79     -50.140   8.783 -33.723  1.00 25.25           C  
ATOM    495  O   SER A  79     -50.512   8.994 -34.874  1.00 25.41           O  
ATOM    496  CB  SER A  79     -47.896   7.789 -33.331  1.00 28.15           C  
ATOM    497  OG  SER A  79     -46.513   8.049 -33.162  1.00 35.36           O  
ATOM    498  N   ALA A  80     -50.942   8.299 -32.782  1.00 24.72           N  
ATOM    499  CA  ALA A  80     -52.330   7.962 -33.064  1.00 23.99           C  
ATOM    500  C   ALA A  80     -53.261   9.160 -33.234  1.00 23.75           C  
ATOM    501  O   ALA A  80     -54.048   9.194 -34.177  1.00 24.28           O  
ATOM    502  CB  ALA A  80     -52.869   7.034 -31.986  1.00 25.95           C  
ATOM    503  N   ALA A  81     -53.164  10.139 -32.334  1.00 21.77           N  
ATOM    504  CA  ALA A  81     -54.042  11.316 -32.345  1.00 20.23           C  
ATOM    505  C   ALA A  81     -53.707  12.494 -33.256  1.00 21.38           C  
ATOM    506  O   ALA A  81     -54.577  13.324 -33.538  1.00 20.57           O  
ATOM    507  CB  ALA A  81     -54.232  11.822 -30.921  1.00 18.46           C  
ATOM    508  N   ARG A  82     -52.457  12.592 -33.694  1.00 23.88           N  
ATOM    509  CA  ARG A  82     -52.035  13.699 -34.549  1.00 28.72           C  
ATOM    510  C   ARG A  82     -52.560  13.695 -35.987  1.00 30.22           C  
ATOM    511  O   ARG A  82     -52.777  12.640 -36.590  1.00 30.95           O  
ATOM    512  CB  ARG A  82     -50.503  13.803 -34.571  1.00 32.06           C  
ATOM    513  CG  ARG A  82     -49.970  14.817 -35.580  1.00 38.95           C  
ATOM    514  CD  ARG A  82     -48.513  15.153 -35.362  1.00 44.39           C  
ATOM    515  NE  ARG A  82     -47.631  14.005 -35.527  1.00 48.22           N  
ATOM    516  CZ  ARG A  82     -46.360  13.987 -35.140  1.00 51.42           C  
ATOM    517  NH1 ARG A  82     -45.820  15.056 -34.564  1.00 53.13           N  
ATOM    518  NH2 ARG A  82     -45.623  12.901 -35.329  1.00 53.69           N  
ATOM    519  N   THR A  83     -52.782  14.900 -36.508  1.00 30.07           N  
ATOM    520  CA  THR A  83     -53.227  15.109 -37.884  1.00 31.23           C  
ATOM    521  C   THR A  83     -52.292  16.152 -38.495  1.00 34.07           C  
ATOM    522  O   THR A  83     -52.131  16.222 -39.712  1.00 36.46           O  
ATOM    523  CB  THR A  83     -54.664  15.666 -37.979  1.00 29.75           C  
ATOM    524  OG1 THR A  83     -54.681  17.024 -37.529  1.00 24.85           O  
ATOM    525  CG2 THR A  83     -55.633  14.836 -37.151  1.00 26.82           C  
ATOM    526  N   GLY A  84     -51.689  16.969 -37.634  1.00 35.29           N  
ATOM    527  CA  GLY A  84     -50.780  18.006 -38.090  1.00 36.45           C  
ATOM    528  C   GLY A  84     -51.436  19.371 -38.152  1.00 37.21           C  
ATOM    529  O   GLY A  84     -50.757  20.389 -38.312  1.00 38.18           O  
ATOM    530  N   GLU A  85     -52.761  19.391 -38.040  1.00 37.14           N  
ATOM    531  CA  GLU A  85     -53.523  20.634 -38.076  1.00 37.08           C  
ATOM    532  C   GLU A  85     -53.694  21.198 -36.671  1.00 36.15           C  
ATOM    533  O   GLU A  85     -53.707  20.451 -35.686  1.00 34.19           O  
ATOM    534  CB  GLU A  85     -54.906  20.399 -38.691  1.00 40.60           C  
ATOM    535  CG  GLU A  85     -54.897  19.894 -40.129  1.00 45.62           C  
ATOM    536  CD  GLU A  85     -54.432  20.947 -41.116  1.00 49.06           C  
ATOM    537  OE1 GLU A  85     -53.205  21.064 -41.329  1.00 49.65           O  
ATOM    538  OE2 GLU A  85     -55.297  21.658 -41.678  1.00 51.07           O  
ATOM    539  N   ILE A  86     -53.828  22.518 -36.584  1.00 33.30           N  
ATOM    540  CA  ILE A  86     -54.020  23.187 -35.303  1.00 32.41           C  
ATOM    541  C   ILE A  86     -55.293  22.644 -34.646  1.00 30.37           C  
ATOM    542  O   ILE A  86     -56.315  22.464 -35.314  1.00 29.32           O  
ATOM    543  CB  ILE A  86     -54.116  24.720 -35.497  1.00 33.83           C  
ATOM    544  CG1 ILE A  86     -52.748  25.272 -35.914  1.00 35.49           C  
ATOM    545  CG2 ILE A  86     -54.614  25.399 -34.229  1.00 33.83           C  
ATOM    546  CD1 ILE A  86     -52.747  26.751 -36.243  1.00 39.33           C  
ATOM    547  N   GLY A  87     -55.200  22.322 -33.357  1.00 27.76           N  
ATOM    548  CA  GLY A  87     -56.347  21.795 -32.636  1.00 25.19           C  
ATOM    549  C   GLY A  87     -56.322  20.295 -32.394  1.00 22.84           C  
ATOM    550  O   GLY A  87     -57.353  19.701 -32.085  1.00 22.80           O  
ATOM    551  N   ASP A  88     -55.152  19.679 -32.550  1.00 22.75           N  
ATOM    552  CA  ASP A  88     -54.992  18.240 -32.337  1.00 21.39           C  
ATOM    553  C   ASP A  88     -55.121  17.834 -30.872  1.00 19.72           C  
ATOM    554  O   ASP A  88     -55.298  16.657 -30.562  1.00 18.56           O  
ATOM    555  CB  ASP A  88     -53.640  17.775 -32.873  1.00 22.61           C  
ATOM    556  CG  ASP A  88     -53.679  17.449 -34.352  1.00 21.93           C  
ATOM    557  OD1 ASP A  88     -54.771  17.472 -34.946  1.00 18.34           O  
ATOM    558  OD2 ASP A  88     -52.613  17.145 -34.917  1.00 22.66           O  
ATOM    559  N   GLY A  89     -54.987  18.808 -29.979  1.00 20.08           N  
ATOM    560  CA  GLY A  89     -55.100  18.534 -28.557  1.00 19.13           C  
ATOM    561  C   GLY A  89     -53.810  18.534 -27.762  1.00 18.42           C  
ATOM    562  O   GLY A  89     -52.737  18.878 -28.271  1.00 16.76           O  
ATOM    563  N   LYS A  90     -53.925  18.077 -26.517  1.00 17.04           N  
ATOM    564  CA  LYS A  90     -52.826  18.037 -25.571  1.00 19.25           C  
ATOM    565  C   LYS A  90     -52.852  16.761 -24.741  1.00 19.18           C  
ATOM    566  O   LYS A  90     -53.874  16.070 -24.657  1.00 15.32           O  
ATOM    567  CB  LYS A  90     -52.959  19.205 -24.584  1.00 22.28           C  
ATOM    568  CG  LYS A  90     -52.990  20.580 -25.193  1.00 27.82           C  
ATOM    569  CD  LYS A  90     -51.595  21.073 -25.496  1.00 30.93           C  
ATOM    570  CE  LYS A  90     -51.636  22.491 -26.035  1.00 32.56           C  
ATOM    571  NZ  LYS A  90     -52.314  23.395 -25.075  1.00 35.68           N  
ATOM    572  N   ILE A  91     -51.709  16.469 -24.127  1.00 18.41           N  
ATOM    573  CA  ILE A  91     -51.563  15.336 -23.221  1.00 14.98           C  
ATOM    574  C   ILE A  91     -50.878  15.890 -21.973  1.00 17.22           C  
ATOM    575  O   ILE A  91     -49.805  16.504 -22.057  1.00 16.37           O  
ATOM    576  CB  ILE A  91     -50.676  14.214 -23.784  1.00 16.58           C  
ATOM    577  CG1 ILE A  91     -51.253  13.680 -25.104  1.00 18.11           C  
ATOM    578  CG2 ILE A  91     -50.590  13.080 -22.772  1.00 13.66           C  
ATOM    579  CD1 ILE A  91     -50.438  12.561 -25.714  1.00 17.58           C  
ATOM    580  N   PHE A  92     -51.530  15.726 -20.831  1.00 14.66           N  
ATOM    581  CA  PHE A  92     -50.981  16.180 -19.558  1.00 15.02           C  
ATOM    582  C   PHE A  92     -50.541  14.952 -18.773  1.00 16.29           C  
ATOM    583  O   PHE A  92     -51.269  13.958 -18.714  1.00 17.06           O  
ATOM    584  CB  PHE A  92     -52.033  16.957 -18.766  1.00 17.80           C  
ATOM    585  CG  PHE A  92     -52.543  18.180 -19.471  1.00 16.80           C  
ATOM    586  CD1 PHE A  92     -51.665  19.086 -20.050  1.00 18.06           C  
ATOM    587  CD2 PHE A  92     -53.903  18.434 -19.546  1.00 24.10           C  
ATOM    588  CE1 PHE A  92     -52.132  20.230 -20.682  1.00 20.26           C  
ATOM    589  CE2 PHE A  92     -54.383  19.586 -20.183  1.00 22.82           C  
ATOM    590  CZ  PHE A  92     -53.486  20.478 -20.753  1.00 21.92           C  
ATOM    591  N   ILE A  93     -49.312  14.986 -18.267  1.00 13.77           N  
ATOM    592  CA  ILE A  93     -48.762  13.884 -17.477  1.00 15.60           C  
ATOM    593  C   ILE A  93     -48.582  14.382 -16.041  1.00 14.74           C  
ATOM    594  O   ILE A  93     -47.890  15.370 -15.812  1.00 16.47           O  
ATOM    595  CB  ILE A  93     -47.401  13.432 -18.037  1.00 13.16           C  
ATOM    596  CG1 ILE A  93     -47.557  13.044 -19.517  1.00 16.43           C  
ATOM    597  CG2 ILE A  93     -46.864  12.237 -17.225  1.00 15.12           C  
ATOM    598  CD1 ILE A  93     -46.241  12.814 -20.245  1.00 21.14           C  
ATOM    599  N   SER A  94     -49.209  13.709 -15.079  1.00 15.03           N  
ATOM    600  CA  SER A  94     -49.111  14.117 -13.671  1.00 13.93           C  
ATOM    601  C   SER A  94     -48.883  12.939 -12.731  1.00 15.05           C  
ATOM    602  O   SER A  94     -49.125  11.787 -13.091  1.00 15.32           O  
ATOM    603  CB  SER A  94     -50.375  14.883 -13.261  1.00 15.58           C  
ATOM    604  OG  SER A  94     -51.536  14.094 -13.488  1.00 18.20           O  
ATOM    605  N   PRO A  95     -48.421  13.211 -11.501  1.00 16.59           N  
ATOM    606  CA  PRO A  95     -48.186  12.113 -10.561  1.00 16.28           C  
ATOM    607  C   PRO A  95     -49.449  11.513  -9.953  1.00 16.84           C  
ATOM    608  O   PRO A  95     -50.465  12.192  -9.769  1.00 16.74           O  
ATOM    609  CB  PRO A  95     -47.312  12.764  -9.486  1.00 17.90           C  
ATOM    610  CG  PRO A  95     -47.805  14.166  -9.467  1.00 19.37           C  
ATOM    611  CD  PRO A  95     -47.983  14.497 -10.935  1.00 16.49           C  
ATOM    612  N   VAL A  96     -49.368  10.221  -9.670  1.00 15.63           N  
ATOM    613  CA  VAL A  96     -50.447   9.478  -9.033  1.00 19.16           C  
ATOM    614  C   VAL A  96     -49.747   8.728  -7.907  1.00 21.00           C  
ATOM    615  O   VAL A  96     -48.769   8.013  -8.141  1.00 20.63           O  
ATOM    616  CB  VAL A  96     -51.131   8.491 -10.011  1.00 18.71           C  
ATOM    617  CG1 VAL A  96     -52.023   7.504  -9.254  1.00 18.34           C  
ATOM    618  CG2 VAL A  96     -51.978   9.262 -11.005  1.00 19.31           C  
ATOM    619  N   ASP A  97     -50.197   8.956  -6.679  1.00 20.40           N  
ATOM    620  CA  ASP A  97     -49.592   8.312  -5.518  1.00 22.53           C  
ATOM    621  C   ASP A  97     -49.917   6.839  -5.449  1.00 24.11           C  
ATOM    622  O   ASP A  97     -49.032   6.014  -5.224  1.00 25.29           O  
ATOM    623  CB  ASP A  97     -50.026   9.008  -4.232  1.00 24.01           C  
ATOM    624  CG  ASP A  97     -49.596  10.459  -4.192  1.00 27.38           C  
ATOM    625  OD1 ASP A  97     -48.412  10.742  -4.460  1.00 29.17           O  
ATOM    626  OD2 ASP A  97     -50.446  11.323  -3.916  1.00 31.17           O  
ATOM    627  N   SER A  98     -51.187   6.508  -5.650  1.00 23.48           N  
ATOM    628  CA  SER A  98     -51.606   5.119  -5.611  1.00 25.25           C  
ATOM    629  C   SER A  98     -52.886   4.856  -6.390  1.00 26.37           C  
ATOM    630  O   SER A  98     -53.576   5.785  -6.821  1.00 24.81           O  
ATOM    631  CB  SER A  98     -51.758   4.653  -4.161  1.00 25.76           C  
ATOM    632  OG  SER A  98     -52.665   5.473  -3.450  1.00 26.50           O  
ATOM    633  N   VAL A  99     -53.147   3.576  -6.628  1.00 24.82           N  
ATOM    634  CA  VAL A  99     -54.332   3.132  -7.345  1.00 25.59           C  
ATOM    635  C   VAL A  99     -54.959   2.075  -6.453  1.00 26.17           C  
ATOM    636  O   VAL A  99     -54.264   1.189  -5.956  1.00 26.17           O  
ATOM    637  CB  VAL A  99     -53.967   2.497  -8.706  1.00 25.05           C  
ATOM    638  CG1 VAL A  99     -55.216   1.951  -9.397  1.00 26.53           C  
ATOM    639  CG2 VAL A  99     -53.275   3.519  -9.603  1.00 26.67           C  
ATOM    640  N   VAL A 100     -56.256   2.198  -6.199  1.00 27.36           N  
ATOM    641  CA  VAL A 100     -56.949   1.241  -5.348  1.00 29.97           C  
ATOM    642  C   VAL A 100     -58.034   0.516  -6.129  1.00 32.65           C  
ATOM    643  O   VAL A 100     -58.936   1.147  -6.685  1.00 33.75           O  
ATOM    644  CB  VAL A 100     -57.576   1.932  -4.112  1.00 29.53           C  
ATOM    645  CG1 VAL A 100     -58.312   0.918  -3.247  1.00 31.88           C  
ATOM    646  CG2 VAL A 100     -56.507   2.638  -3.301  1.00 29.79           C  
ATOM    647  N   ARG A 101     -57.914  -0.807  -6.211  1.00 33.94           N  
ATOM    648  CA  ARG A 101     -58.899  -1.627  -6.904  1.00 34.36           C  
ATOM    649  C   ARG A 101     -60.101  -1.709  -5.965  1.00 35.18           C  
ATOM    650  O   ARG A 101     -59.969  -2.115  -4.806  1.00 36.68           O  
ATOM    651  CB  ARG A 101     -58.331  -3.017  -7.185  1.00 35.90           C  
ATOM    652  N   ILE A 102     -61.258  -1.265  -6.444  1.00 34.23           N  
ATOM    653  CA  ILE A 102     -62.466  -1.264  -5.624  1.00 34.84           C  
ATOM    654  C   ILE A 102     -62.921  -2.644  -5.154  1.00 36.17           C  
ATOM    655  O   ILE A 102     -63.176  -2.841  -3.968  1.00 37.18           O  
ATOM    656  CB  ILE A 102     -63.625  -0.511  -6.333  1.00 32.89           C  
ATOM    657  CG1 ILE A 102     -63.292   0.987  -6.400  1.00 29.51           C  
ATOM    658  CG2 ILE A 102     -64.955  -0.732  -5.595  1.00 32.75           C  
ATOM    659  CD1 ILE A 102     -64.339   1.827  -7.097  1.00 26.56           C  
ATOM    660  N   ARG A 103     -62.967  -3.603  -6.071  1.00 38.05           N  
ATOM    661  CA  ARG A 103     -63.400  -4.958  -5.750  1.00 42.00           C  
ATOM    662  C   ARG A 103     -62.661  -5.608  -4.578  1.00 43.09           C  
ATOM    663  O   ARG A 103     -63.276  -5.960  -3.567  1.00 43.68           O  
ATOM    664  CB  ARG A 103     -63.292  -5.845  -6.988  1.00 43.78           C  
ATOM    665  CG  ARG A 103     -63.957  -7.202  -6.839  1.00 48.25           C  
ATOM    666  CD  ARG A 103     -64.089  -7.902  -8.183  1.00 51.18           C  
ATOM    667  NE  ARG A 103     -62.803  -8.330  -8.724  1.00 55.44           N  
ATOM    668  CZ  ARG A 103     -62.281  -9.540  -8.544  1.00 57.86           C  
ATOM    669  NH1 ARG A 103     -62.934 -10.453  -7.833  1.00 59.25           N  
ATOM    670  NH2 ARG A 103     -61.104  -9.841  -9.080  1.00 59.08           N  
ATOM    671  N   THR A 104     -61.340  -5.718  -4.696  1.00 43.47           N  
ATOM    672  CA  THR A 104     -60.523  -6.346  -3.662  1.00 43.45           C  
ATOM    673  C   THR A 104     -60.021  -5.409  -2.566  1.00 42.54           C  
ATOM    674  O   THR A 104     -59.743  -5.849  -1.449  1.00 42.80           O  
ATOM    675  CB  THR A 104     -59.318  -7.075  -4.288  1.00 44.54           C  
ATOM    676  OG1 THR A 104     -58.434  -6.117  -4.890  1.00 47.49           O  
ATOM    677  CG2 THR A 104     -59.791  -8.049  -5.364  1.00 45.95           C  
ATOM    678  N   GLY A 105     -59.921  -4.120  -2.876  1.00 40.99           N  
ATOM    679  CA  GLY A 105     -59.428  -3.159  -1.902  1.00 38.55           C  
ATOM    680  C   GLY A 105     -57.910  -3.078  -1.935  1.00 37.17           C  
ATOM    681  O   GLY A 105     -57.288  -2.426  -1.091  1.00 37.62           O  
ATOM    682  N   GLU A 106     -57.311  -3.745  -2.916  1.00 36.89           N  
ATOM    683  CA  GLU A 106     -55.861  -3.761  -3.064  1.00 36.27           C  
ATOM    684  C   GLU A 106     -55.321  -2.400  -3.487  1.00 35.57           C  
ATOM    685  O   GLU A 106     -55.721  -1.857  -4.518  1.00 35.93           O  
ATOM    686  CB  GLU A 106     -55.447  -4.824  -4.066  1.00 36.19           C  
ATOM    687  N   LYS A 107     -54.435  -1.849  -2.663  1.00 34.21           N  
ATOM    688  CA  LYS A 107     -53.811  -0.561  -2.930  1.00 33.26           C  
ATOM    689  C   LYS A 107     -52.464  -0.796  -3.611  1.00 32.83           C  
ATOM    690  O   LYS A 107     -51.604  -1.511  -3.090  1.00 30.46           O  
ATOM    691  CB  LYS A 107     -53.629   0.210  -1.622  1.00 35.35           C  
ATOM    692  CG  LYS A 107     -53.111   1.630  -1.788  1.00 39.89           C  
ATOM    693  CD  LYS A 107     -53.161   2.373  -0.464  1.00 42.94           C  
ATOM    694  CE  LYS A 107     -52.731   3.813  -0.618  1.00 43.77           C  
ATOM    695  NZ  LYS A 107     -52.942   4.603   0.627  1.00 44.81           N  
ATOM    696  N   ASP A 108     -52.297  -0.217  -4.794  1.00 30.61           N  
ATOM    697  CA  ASP A 108     -51.064  -0.375  -5.549  1.00 30.58           C  
ATOM    698  C   ASP A 108     -50.279   0.921  -5.597  1.00 29.44           C  
ATOM    699  O   ASP A 108     -50.824   1.971  -5.939  1.00 23.70           O  
ATOM    700  CB  ASP A 108     -51.379  -0.836  -6.970  1.00 34.51           C  
ATOM    701  CG  ASP A 108     -52.277  -2.060  -6.996  1.00 38.49           C  
ATOM    702  OD1 ASP A 108     -52.044  -2.982  -6.181  1.00 39.41           O  
ATOM    703  OD2 ASP A 108     -53.223  -2.088  -7.816  1.00 40.23           O  
ATOM    704  N   THR A 109     -49.011   0.843  -5.211  1.00 29.48           N  
ATOM    705  CA  THR A 109     -48.130   1.998  -5.227  1.00 32.52           C  
ATOM    706  C   THR A 109     -46.925   1.655  -6.075  1.00 35.69           C  
ATOM    707  O   THR A 109     -46.474   0.508  -6.106  1.00 35.23           O  
ATOM    708  CB  THR A 109     -47.679   2.427  -3.816  1.00 33.44           C  
ATOM    709  OG1 THR A 109     -46.964   1.357  -3.184  1.00 35.28           O  
ATOM    710  CG2 THR A 109     -48.886   2.805  -2.966  1.00 30.27           C  
ATOM    711  N   GLU A 110     -46.414   2.659  -6.768  1.00 39.10           N  
ATOM    712  CA  GLU A 110     -45.282   2.473  -7.647  1.00 44.35           C  
ATOM    713  C   GLU A 110     -44.278   3.594  -7.458  1.00 47.79           C  
ATOM    714  O   GLU A 110     -44.624   4.770  -7.570  1.00 49.99           O  
ATOM    715  CB  GLU A 110     -45.778   2.475  -9.083  1.00 45.11           C  
ATOM    716  CG  GLU A 110     -45.195   1.388  -9.929  1.00 47.15           C  
ATOM    717  CD  GLU A 110     -44.617   1.896 -11.230  1.00 48.57           C  
ATOM    718  OE1 GLU A 110     -44.665   3.122 -11.485  1.00 48.73           O  
ATOM    719  OE2 GLU A 110     -44.102   1.057 -11.999  1.00 50.85           O  
ATOM    720  N   ALA A 111     -43.030   3.228  -7.188  1.00 50.51           N  
ATOM    721  CA  ALA A 111     -41.986   4.223  -6.989  1.00 53.15           C  
ATOM    722  C   ALA A 111     -40.631   3.730  -7.474  1.00 55.12           C  
ATOM    723  O   ALA A 111     -40.487   2.585  -7.907  1.00 55.05           O  
ATOM    724  CB  ALA A 111     -41.905   4.610  -5.518  1.00 53.97           C  
ATOM    725  N   ILE A 112     -39.652   4.629  -7.439  1.00 56.90           N  
ATOM    726  CA  ILE A 112     -38.286   4.326  -7.843  1.00 58.05           C  
ATOM    727  C   ILE A 112     -37.360   5.081  -6.893  1.00 58.71           C  
ATOM    728  O   ILE A 112     -36.545   4.418  -6.221  1.00 58.95           O  
ATOM    729  CB  ILE A 112     -37.996   4.753  -9.313  1.00 58.10           C  
ATOM    730  CG1 ILE A 112     -38.883   3.965 -10.283  1.00 57.71           C  
ATOM    731  CG2 ILE A 112     -36.523   4.524  -9.652  1.00 58.51           C  
ATOM    732  CD1 ILE A 112     -38.581   4.206 -11.750  1.00 57.17           C  
ATOM    733  OXT ILE A 112     -37.499   6.322  -6.798  1.00 59.93           O  
TER     734      ILE A 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
