
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 (  755),  selected   99 , name 1hwu_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 1hwu_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_A      A       5          0.664
LGA    K     2_A      N       6          0.396
LGA    Q     3_A      K       7          0.283
LGA    V     4_A      L       8          0.385
LGA    T     5_A      V       9          0.454
LGA    A     6_A      I      10          0.926
LGA    I     7_A      V      11          0.720
LGA    I     8_A      T      12          0.536
LGA    K     9_A      E      13          0.376
LGA    P    10_A      K      14          0.347
LGA    F    11_A      V      15          0.896
LGA    K    12_A      L      16          0.430
LGA    L    13_A      L      17          0.863
LGA    D    14_A      K      18          0.673
LGA    E    15_A      K      19          0.720
LGA    V    16_A      V      20          0.833
LGA    R    17_A      A      21          1.128
LGA    E    18_A      K      22          1.005
LGA    S    19_A      I      23          1.581
LGA    L    20_A      I      24          1.932
LGA    A    21_A      E      25          1.883
LGA    E    22_A      E      26          1.877
LGA    V    23_A      A      27          1.556
LGA    G    24_A      G      28          0.893
LGA    V    25_A      A      29          1.569
LGA    T    26_A      T      30          4.058
LGA    G    27_A      G      31          1.041
LGA    L    28_A      Y      32          1.400
LGA    T    29_A      T      33          0.404
LGA    V    30_A      V      34          0.711
LGA    T    31_A      V      35          0.538
LGA    E    32_A      D      36          0.530
LGA    V    33_A      T      37          0.660
LGA    K    34_A      G      38          0.281
LGA    G    35_A      G      39          1.109
LGA    F    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    Y    51_A      -       -           -
LGA    V    52_A      -       -           -
LGA    V    53_A      -       -           -
LGA    D    54_A      -       -           -
LGA    F    55_A      -       -           -
LGA    L    56_A      -       -           -
LGA    P    57_A      S      58          0.556
LGA    K    58_A      N      59          0.541
LGA    V    59_A      V      60          0.526
LGA    K    60_A      K      61          0.577
LGA    I    61_A      F      62          0.589
LGA    E    62_A      E      63          0.471
LGA    V    63_A      V      64          0.557
LGA    V    64_A      L      65          0.450
LGA    V    65_A      T      66          0.719
LGA    D    66_A      E      67          2.014
LGA    D    67_A      N      68          2.535
LGA    K    68_A      R      69          3.256
LGA    V    69_A      E      70          3.253
LGA    -       -      M      71           -
LGA    V    70_A      A      72          1.756
LGA    E    71_A      E      73          1.528
LGA    Q    72_A      K      74          0.935
LGA    A    73_A      I      75          2.028
LGA    V    74_A      A      76          1.318
LGA    D    75_A      D      77          1.722
LGA    A    76_A      Q      78          2.424
LGA    I    77_A      V      79          2.227
LGA    I    78_A      A      80          1.753
LGA    K    79_A      I      81          3.755
LGA    A    80_A      K      82          4.171
LGA    A    81_A      F      83          2.833
LGA    R    82_A      F      84          2.237
LGA    T    83_A      -       -           -
LGA    G    84_A      T      85          1.620
LGA    K    85_A      D      86          3.902
LGA    I    86_A      Y      87          6.118
LGA    G    87_A      -       -           -
LGA    D    88_A      A      88          1.468
LGA    G    89_A      G      89          0.530
LGA    K    90_A      I      90          0.336
LGA    I    91_A      I      91          0.503
LGA    F    92_A      Y      92          0.998
LGA    V    93_A      I      93          0.350
LGA    Q    94_A      C      94          0.540
LGA    E    95_A      E      95          0.311
LGA    V    96_A      A      96          0.691
LGA    E    97_A      E      97          1.896
LGA    Q    98_A      V      98          2.392
LGA    V    99_A      L      99          3.613
LGA    I   100_A      Y     100          0.782
LGA    R   101_A      G     101          1.524
LGA    I   102_A      -       -           -
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    T   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    D   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    V   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99   83    5.0     78    1.77    24.36     86.604     4.178

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.556073 * X  +   0.338401 * Y  +   0.759123 * Z  + -103.964348
  Y_new =   0.824393 * X  +  -0.108486 * Y  +  -0.555525 * Z  +  15.120155
  Z_new =  -0.105636 * X  +   0.934728 * Y  +  -0.339301 * Z  + -39.522461 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.919000   -1.222592  [ DEG:   109.9506    -70.0494 ]
  Theta =   0.105833    3.035759  [ DEG:     6.0638    173.9362 ]
  Phi   =   0.977373   -2.164220  [ DEG:    55.9994   -124.0006 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1hwu_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1hwu_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99   83   5.0   78   1.77   24.36  86.604
REMARK  ---------------------------------------------------------- 
MOLECULE 1hwu_A
HEADER    SIGNALING PROTEIN                       10-JAN-01   1HWU              
TITLE     STRUCTURE OF PII PROTEIN FROM HERBASPIRILLUM SEROPEDICAE              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PII PROTEIN;                                               
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HERBASPIRILLUM SEROPEDICAE;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GLNB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: RB9065(LAMBDA)DE3;                         
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28B+                                   
KEYWDS    HERBASPIRILLUM SEROPEDICAE PII, BETA-ALPHA-BETA MOTIF,                
KEYWDS   2 SIGNAL TRANSDUCTION PROTEIN                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.M.BENELLI,M.BUCK,I.POLIKARPOV,E.M.DE SOUZA,L.M.CRUZ,                
AUTHOR   2 F.O.PEDROSA                                                          
REVDAT   1   17-JUN-03 1HWU    0                                                
JRNL        AUTH   E.MACHADO BENELLI,M.BUCK,I.POLIKARPOV,                       
JRNL        AUTH 2 E.MALTEMPI DE SOUZA,L.M.CRUZ,F.O.PEDROSA                     
JRNL        TITL   HERBASPIRILLUM SEROPEDICAE SIGNAL TRANSDUCTION               
JRNL        TITL 2 PROTEIN PII IS STRUCTURALLY SIMILAR TO THE ENTERIC           
JRNL        TITL 3 GLNK.                                                        
JRNL        REF    EUR.J.BIOCHEM.                V. 269  3296 2002              
JRNL        REFN   ASTM EJBCAI  IX ISSN 0014-2956                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1HWU A    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU B    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU C    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU D    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU E    1   112  UNP    P94852   P94852_HERSE     1    112             
DBREF  1HWU F    1   112  UNP    P94852   P94852_HERSE     1    112             
SEQRES   1 A  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 A  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 A  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 A  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 A  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 A  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 A  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 A  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 A  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 B  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 B  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 B  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 B  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 B  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 B  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 B  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 B  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 B  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 C  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 C  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 C  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 C  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 C  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 C  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 C  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 C  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 C  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 D  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 D  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 D  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 D  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 D  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 D  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 D  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 D  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 D  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 E  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 E  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 E  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 E  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 E  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 E  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 E  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 E  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 E  112  GLY GLU THR GLY PRO ASP ALA VAL                              
SEQRES   1 F  112  MET LYS GLN VAL THR ALA ILE ILE LYS PRO PHE LYS LEU          
SEQRES   2 F  112  ASP GLU VAL ARG GLU SER LEU ALA GLU VAL GLY VAL THR          
SEQRES   3 F  112  GLY LEU THR VAL THR GLU VAL LYS GLY PHE GLY ARG GLN          
SEQRES   4 F  112  LYS GLY HIS THR GLU LEU TYR ARG GLY ALA GLU TYR VAL          
SEQRES   5 F  112  VAL ASP PHE LEU PRO LYS VAL LYS ILE GLU VAL VAL VAL          
SEQRES   6 F  112  ASP ASP LYS VAL VAL GLU GLN ALA VAL ASP ALA ILE ILE          
SEQRES   7 F  112  LYS ALA ALA ARG THR GLY LYS ILE GLY ASP GLY LYS ILE          
SEQRES   8 F  112  PHE VAL GLN GLU VAL GLU GLN VAL ILE ARG ILE ARG THR          
SEQRES   9 F  112  GLY GLU THR GLY PRO ASP ALA VAL                              
FORMUL   7  HOH   *118(H2 O)                                                    
CRYST1   78.410   82.320  100.950  90.00  90.00  90.00 P 21 21 21   24          
ATOM      1  N   MET A   1     -46.531   5.892  -9.980  1.00 43.54           N  
ATOM      2  CA  MET A   1     -47.599   5.806 -11.007  1.00 42.21           C  
ATOM      3  C   MET A   1     -47.928   7.192 -11.557  1.00 39.93           C  
ATOM      4  O   MET A   1     -47.742   8.180 -10.892  1.00 40.22           O  
ATOM      5  CB  MET A   1     -48.878   5.076 -10.577  1.00 43.51           C  
ATOM      6  CG  MET A   1     -48.554   3.568 -10.413  1.00 46.88           C  
ATOM      7  SD  MET A   1     -48.905   3.148  -8.688  1.00 67.32           S  
ATOM      8  CE  MET A   1     -48.334   4.538  -7.743  1.00 62.64           C  
ATOM      9  N   LYS A   2     -48.177   7.194 -12.859  1.00 39.65           N  
ATOM     10  CA  LYS A   2     -48.473   8.431 -13.567  1.00 40.83           C  
ATOM     11  C   LYS A   2     -49.915   8.354 -14.114  1.00 38.53           C  
ATOM     12  O   LYS A   2     -50.293   7.309 -14.648  1.00 37.58           O  
ATOM     13  CB  LYS A   2     -47.476   8.601 -14.701  1.00 47.94           C  
ATOM     14  CG  LYS A   2     -45.965   8.708 -14.337  1.00 41.15           C  
ATOM     15  CD  LYS A   2     -45.753   9.827 -13.281  1.00 40.47           C  
ATOM     16  CE  LYS A   2     -44.226   9.858 -12.977  1.00 40.87           C  
ATOM     17  NZ  LYS A   2     -43.891  10.878 -11.979  1.00 40.28           N  
ATOM     18  N   GLN A   3     -50.638   9.477 -14.060  1.00 33.48           N  
ATOM     19  CA  GLN A   3     -51.939   9.512 -14.797  1.00 33.61           C  
ATOM     20  C   GLN A   3     -51.559  10.102 -16.154  1.00 30.24           C  
ATOM     21  O   GLN A   3     -50.891  11.141 -16.174  1.00 31.24           O  
ATOM     22  CB  GLN A   3     -52.863  10.522 -14.093  1.00 28.51           C  
ATOM     23  CG  GLN A   3     -54.131  10.779 -14.962  1.00 43.86           C  
ATOM     24  CD  GLN A   3     -55.167  11.475 -14.070  1.00 34.13           C  
ATOM     25  OE1 GLN A   3     -56.145  10.824 -13.770  1.00 51.70           O  
ATOM     26  NE2 GLN A   3     -54.827  12.683 -13.654  1.00 44.07           N  
ATOM     27  N   VAL A   4     -51.890   9.501 -17.289  1.00 33.53           N  
ATOM     28  CA  VAL A   4     -51.663  10.153 -18.575  1.00 33.30           C  
ATOM     29  C   VAL A   4     -53.040  10.679 -19.060  1.00 32.04           C  
ATOM     30  O   VAL A   4     -53.944   9.877 -19.287  1.00 31.08           O  
ATOM     31  CB  VAL A   4     -50.991   9.218 -19.573  1.00 37.97           C  
ATOM     32  CG1 VAL A   4     -50.739   9.919 -20.896  1.00 37.58           C  
ATOM     33  CG2 VAL A   4     -49.608   8.834 -19.048  1.00 32.81           C  
ATOM     34  N   THR A   5     -53.150  11.991 -19.333  1.00 27.26           N  
ATOM     35  CA  THR A   5     -54.369  12.518 -19.939  1.00 31.96           C  
ATOM     36  C   THR A   5     -54.122  12.977 -21.372  1.00 32.35           C  
ATOM     37  O   THR A   5     -53.134  13.711 -21.585  1.00 31.94           O  
ATOM     38  CB  THR A   5     -54.844  13.741 -19.068  1.00 32.43           C  
ATOM     39  OG1 THR A   5     -55.017  13.106 -17.811  1.00 32.20           O  
ATOM     40  CG2 THR A   5     -56.226  14.195 -19.612  1.00 26.11           C  
ATOM     41  N   ALA A   6     -55.076  12.799 -22.261  1.00 30.94           N  
ATOM     42  CA  ALA A   6     -54.978  13.421 -23.581  1.00 27.61           C  
ATOM     43  C   ALA A   6     -56.375  13.970 -23.977  1.00 28.97           C  
ATOM     44  O   ALA A   6     -57.386  13.306 -23.732  1.00 27.66           O  
ATOM     45  CB  ALA A   6     -54.553  12.446 -24.662  1.00 21.88           C  
ATOM     46  N   ILE A   7     -56.368  15.056 -24.697  1.00 24.72           N  
ATOM     47  CA  ILE A   7     -57.588  15.696 -25.201  1.00 28.06           C  
ATOM     48  C   ILE A   7     -57.431  15.656 -26.708  1.00 28.85           C  
ATOM     49  O   ILE A   7     -56.409  16.178 -27.196  1.00 29.45           O  
ATOM     50  CB  ILE A   7     -57.697  17.167 -24.761  1.00 32.00           C  
ATOM     51  CG1 ILE A   7     -57.837  17.048 -23.199  1.00 40.81           C  
ATOM     52  CG2 ILE A   7     -58.960  17.836 -25.346  1.00 29.42           C  
ATOM     53  CD1 ILE A   7     -56.920  18.062 -22.578  1.00 49.10           C  
ATOM     54  N   ILE A   8     -58.228  14.781 -27.315  1.00 23.25           N  
ATOM     55  CA  ILE A   8     -58.055  14.548 -28.761  1.00 24.86           C  
ATOM     56  C   ILE A   8     -59.385  14.759 -29.463  1.00 31.36           C  
ATOM     57  O   ILE A   8     -60.481  14.925 -28.846  1.00 25.64           O  
ATOM     58  CB  ILE A   8     -57.581  13.071 -28.926  1.00 29.78           C  
ATOM     59  CG1 ILE A   8     -58.692  12.189 -28.452  1.00 30.81           C  
ATOM     60  CG2 ILE A   8     -56.190  12.854 -28.284  1.00 28.67           C  
ATOM     61  CD1 ILE A   8     -58.629  10.694 -28.722  1.00 29.37           C  
ATOM     62  N   LYS A   9     -59.297  14.746 -30.790  1.00 25.86           N  
ATOM     63  CA  LYS A   9     -60.491  14.851 -31.586  1.00 28.42           C  
ATOM     64  C   LYS A   9     -61.237  13.526 -31.398  1.00 27.14           C  
ATOM     65  O   LYS A   9     -60.643  12.461 -31.235  1.00 30.83           O  
ATOM     66  CB  LYS A   9     -60.192  15.119 -33.075  1.00 31.92           C  
ATOM     67  CG  LYS A   9     -59.683  16.502 -33.383  1.00 30.48           C  
ATOM     68  CD  LYS A   9     -58.901  16.529 -34.678  1.00 33.87           C  
ATOM     69  CE  LYS A   9     -59.437  17.589 -35.624  1.00 41.31           C  
ATOM     70  NZ  LYS A   9     -58.882  17.452 -37.000  1.00 36.98           N  
ATOM     71  N   PRO A  10     -62.579  13.647 -31.405  1.00 26.26           N  
ATOM     72  CA  PRO A  10     -63.520  12.556 -31.105  1.00 29.14           C  
ATOM     73  C   PRO A  10     -63.311  11.248 -31.878  1.00 27.12           C  
ATOM     74  O   PRO A  10     -63.281  10.160 -31.309  1.00 26.84           O  
ATOM     75  CB  PRO A  10     -64.854  13.198 -31.219  1.00 29.75           C  
ATOM     76  CG  PRO A  10     -64.566  14.529 -30.661  1.00 28.60           C  
ATOM     77  CD  PRO A  10     -63.125  14.866 -30.865  1.00 25.49           C  
ATOM     78  N   PHE A  11     -63.179  11.402 -33.182  1.00 27.05           N  
ATOM     79  CA  PHE A  11     -63.068  10.278 -34.091  1.00 31.58           C  
ATOM     80  C   PHE A  11     -61.693   9.624 -34.106  1.00 33.48           C  
ATOM     81  O   PHE A  11     -61.469   8.665 -34.858  1.00 32.94           O  
ATOM     82  CB  PHE A  11     -63.586  10.730 -35.490  1.00 32.18           C  
ATOM     83  CG  PHE A  11     -65.059  11.012 -35.533  1.00 26.07           C  
ATOM     84  CD1 PHE A  11     -65.589  12.095 -36.239  1.00 32.95           C  
ATOM     85  CD2 PHE A  11     -65.953  10.192 -34.848  1.00 32.15           C  
ATOM     86  CE1 PHE A  11     -66.946  12.307 -36.258  1.00 38.80           C  
ATOM     87  CE2 PHE A  11     -67.291  10.394 -34.858  1.00 39.09           C  
ATOM     88  CZ  PHE A  11     -67.816  11.455 -35.570  1.00 25.49           C  
ATOM     89  N   LYS A  12     -60.744  10.134 -33.315  1.00 27.50           N  
ATOM     90  CA  LYS A  12     -59.402   9.497 -33.225  1.00 30.19           C  
ATOM     91  C   LYS A  12     -59.392   8.541 -32.027  1.00 31.77           C  
ATOM     92  O   LYS A  12     -58.361   7.956 -31.720  1.00 27.54           O  
ATOM     93  CB  LYS A  12     -58.287  10.540 -33.062  1.00 29.12           C  
ATOM     94  CG  LYS A  12     -57.619  10.972 -34.363  1.00 21.39           C  
ATOM     95  CD  LYS A  12     -56.877   9.837 -35.056  1.00 28.76           C  
ATOM     96  CE  LYS A  12     -56.352  10.235 -36.428  1.00 23.70           C  
ATOM     97  NZ  LYS A  12     -57.451  10.636 -37.350  1.00 32.85           N  
ATOM     98  N   LEU A  13     -60.532   8.427 -31.353  1.00 27.61           N  
ATOM     99  CA  LEU A  13     -60.582   7.572 -30.153  1.00 27.22           C  
ATOM    100  C   LEU A  13     -60.165   6.129 -30.436  1.00 25.44           C  
ATOM    101  O   LEU A  13     -59.200   5.647 -29.837  1.00 25.25           O  
ATOM    102  CB  LEU A  13     -62.003   7.644 -29.515  1.00 27.94           C  
ATOM    103  CG  LEU A  13     -62.215   7.104 -28.079  1.00 41.34           C  
ATOM    104  CD1 LEU A  13     -63.693   6.872 -27.805  1.00 29.00           C  
ATOM    105  CD2 LEU A  13     -61.413   5.824 -27.875  1.00 39.61           C  
ATOM    106  N   ASP A  14     -60.862   5.453 -31.321  1.00 24.69           N  
ATOM    107  CA  ASP A  14     -60.596   4.042 -31.691  1.00 33.95           C  
ATOM    108  C   ASP A  14     -59.123   3.739 -32.026  1.00 30.54           C  
ATOM    109  O   ASP A  14     -58.586   2.711 -31.608  1.00 31.03           O  
ATOM    110  CB  ASP A  14     -61.548   3.616 -32.809  1.00 40.11           C  
ATOM    111  CG  ASP A  14     -62.940   3.414 -32.272  1.00 29.94           C  
ATOM    112  OD1 ASP A  14     -63.078   2.846 -31.162  1.00 44.77           O  
ATOM    113  OD2 ASP A  14     -63.906   3.821 -32.956  1.00 45.37           O  
ATOM    114  N   GLU A  15     -58.473   4.634 -32.755  1.00 33.19           N  
ATOM    115  CA  GLU A  15     -57.073   4.462 -33.105  1.00 35.81           C  
ATOM    116  C   GLU A  15     -56.186   4.592 -31.906  1.00 35.68           C  
ATOM    117  O   GLU A  15     -55.311   3.757 -31.683  1.00 37.64           O  
ATOM    118  CB  GLU A  15     -56.673   5.451 -34.158  1.00 35.87           C  
ATOM    119  CG  GLU A  15     -56.858   4.887 -35.545  1.00 44.48           C  
ATOM    120  CD  GLU A  15     -56.052   5.699 -36.525  1.00 45.42           C  
ATOM    121  OE1 GLU A  15     -56.630   6.577 -37.196  1.00 45.80           O  
ATOM    122  OE2 GLU A  15     -54.827   5.473 -36.635  1.00 54.47           O  
ATOM    123  N   VAL A  16     -56.416   5.626 -31.116  1.00 28.83           N  
ATOM    124  CA  VAL A  16     -55.627   5.779 -29.926  1.00 29.30           C  
ATOM    125  C   VAL A  16     -55.747   4.580 -29.038  1.00 31.33           C  
ATOM    126  O   VAL A  16     -54.737   4.060 -28.567  1.00 30.75           O  
ATOM    127  CB  VAL A  16     -56.089   7.035 -29.095  1.00 24.95           C  
ATOM    128  CG1 VAL A  16     -55.265   7.158 -27.837  1.00 27.18           C  
ATOM    129  CG2 VAL A  16     -55.962   8.302 -29.930  1.00 26.12           C  
ATOM    130  N   ARG A  17     -56.985   4.147 -28.786  1.00 28.52           N  
ATOM    131  CA  ARG A  17     -57.224   2.967 -27.975  1.00 33.68           C  
ATOM    132  C   ARG A  17     -56.431   1.785 -28.506  1.00 31.90           C  
ATOM    133  O   ARG A  17     -55.667   1.152 -27.774  1.00 36.63           O  
ATOM    134  CB  ARG A  17     -58.708   2.657 -27.932  1.00 31.86           C  
ATOM    135  CG  ARG A  17     -59.038   1.398 -27.188  1.00 36.46           C  
ATOM    136  CD  ARG A  17     -60.323   0.765 -27.712  1.00 38.83           C  
ATOM    137  NE  ARG A  17     -60.663  -0.340 -26.839  1.00 48.59           N  
ATOM    138  CZ  ARG A  17     -61.727  -1.157 -26.918  1.00 45.86           C  
ATOM    139  NH1 ARG A  17     -62.636  -0.995 -27.882  1.00 43.68           N  
ATOM    140  NH2 ARG A  17     -61.870  -2.149 -26.029  1.00 52.33           N  
ATOM    141  N   GLU A  18     -56.588   1.483 -29.820  1.00 30.59           N  
ATOM    142  CA  GLU A  18     -55.828   0.340 -30.353  1.00 42.31           C  
ATOM    143  C   GLU A  18     -54.306   0.533 -30.236  1.00 41.69           C  
ATOM    144  O   GLU A  18     -53.596  -0.378 -29.787  1.00 43.47           O  
ATOM    145  CB  GLU A  18     -56.268   0.128 -31.796  1.00 37.60           C  
ATOM    146  CG  GLU A  18     -57.530  -0.709 -31.934  1.00 68.92           C  
ATOM    147  CD  GLU A  18     -57.493  -1.985 -31.098  1.00 79.38           C  
ATOM    148  OE1 GLU A  18     -56.818  -2.960 -31.527  1.00 87.63           O  
ATOM    149  OE2 GLU A  18     -58.134  -1.993 -30.020  1.00 83.40           O  
ATOM    150  N   SER A  19     -53.796   1.732 -30.454  1.00 35.95           N  
ATOM    151  CA  SER A  19     -52.344   1.936 -30.355  1.00 40.26           C  
ATOM    152  C   SER A  19     -51.836   1.770 -28.945  1.00 41.28           C  
ATOM    153  O   SER A  19     -50.781   1.151 -28.734  1.00 37.90           O  
ATOM    154  CB  SER A  19     -52.002   3.285 -30.986  1.00 28.51           C  
ATOM    155  OG  SER A  19     -50.753   3.776 -30.569  1.00 57.49           O  
ATOM    156  N   LEU A  20     -52.558   2.237 -27.912  1.00 35.33           N  
ATOM    157  CA  LEU A  20     -52.230   1.986 -26.516  1.00 34.35           C  
ATOM    158  C   LEU A  20     -52.156   0.480 -26.189  1.00 38.56           C  
ATOM    159  O   LEU A  20     -51.345  -0.015 -25.380  1.00 33.58           O  
ATOM    160  CB  LEU A  20     -53.299   2.630 -25.592  1.00 30.31           C  
ATOM    161  CG  LEU A  20     -53.017   3.938 -24.874  1.00 37.94           C  
ATOM    162  CD1 LEU A  20     -51.588   4.449 -24.819  1.00 27.48           C  
ATOM    163  CD2 LEU A  20     -54.015   5.085 -25.147  1.00 39.62           C  
ATOM    164  N   ALA A  21     -53.165  -0.256 -26.658  1.00 35.76           N  
ATOM    165  CA  ALA A  21     -53.325  -1.669 -26.397  1.00 45.89           C  
ATOM    166  C   ALA A  21     -52.159  -2.518 -26.985  1.00 46.16           C  
ATOM    167  O   ALA A  21     -51.632  -3.380 -26.280  1.00 46.01           O  
ATOM    168  CB  ALA A  21     -54.604  -2.233 -26.970  1.00 48.52           C  
ATOM    169  N   GLU A  22     -51.554  -1.980 -28.025  1.00 47.09           N  
ATOM    170  CA  GLU A  22     -50.375  -2.586 -28.602  1.00 57.45           C  
ATOM    171  C   GLU A  22     -49.195  -2.448 -27.624  1.00 52.42           C  
ATOM    172  O   GLU A  22     -48.242  -3.227 -27.756  1.00 53.64           O  
ATOM    173  CB  GLU A  22     -49.925  -1.990 -29.905  1.00 65.09           C  
ATOM    174  CG  GLU A  22     -50.633  -2.222 -31.214  1.00 88.33           C  
ATOM    175  CD  GLU A  22     -50.219  -1.086 -32.160  1.00100.14           C  
ATOM    176  OE1 GLU A  22     -51.069  -0.595 -32.934  1.00107.10           O  
ATOM    177  OE2 GLU A  22     -49.029  -0.688 -32.098  1.00109.11           O  
ATOM    178  N   VAL A  23     -49.166  -1.395 -26.846  1.00 45.44           N  
ATOM    179  CA  VAL A  23     -48.077  -1.219 -25.899  1.00 42.53           C  
ATOM    180  C   VAL A  23     -48.487  -1.715 -24.520  1.00 42.30           C  
ATOM    181  O   VAL A  23     -47.696  -1.508 -23.593  1.00 44.92           O  
ATOM    182  CB  VAL A  23     -47.409   0.144 -25.769  1.00 52.68           C  
ATOM    183  CG1 VAL A  23     -46.637   0.482 -27.047  1.00 47.29           C  
ATOM    184  CG2 VAL A  23     -48.379   1.273 -25.416  1.00 46.40           C  
ATOM    185  N   GLY A  24     -49.565  -2.493 -24.459  1.00 40.04           N  
ATOM    186  CA  GLY A  24     -50.034  -3.097 -23.203  1.00 44.27           C  
ATOM    187  C   GLY A  24     -50.894  -2.242 -22.286  1.00 45.47           C  
ATOM    188  O   GLY A  24     -51.000  -2.489 -21.063  1.00 46.77           O  
ATOM    189  N   VAL A  25     -51.317  -1.083 -22.786  1.00 44.42           N  
ATOM    190  CA  VAL A  25     -52.060  -0.142 -21.920  1.00 44.95           C  
ATOM    191  C   VAL A  25     -53.550  -0.204 -22.200  1.00 39.17           C  
ATOM    192  O   VAL A  25     -53.966   0.175 -23.297  1.00 42.18           O  
ATOM    193  CB  VAL A  25     -51.601   1.312 -22.140  1.00 38.96           C  
ATOM    194  CG1 VAL A  25     -52.444   2.243 -21.239  1.00 51.00           C  
ATOM    195  CG2 VAL A  25     -50.129   1.415 -21.767  1.00 45.22           C  
ATOM    196  N   THR A  26     -54.345  -0.621 -21.225  1.00 37.04           N  
ATOM    197  CA  THR A  26     -55.800  -0.657 -21.393  1.00 40.10           C  
ATOM    198  C   THR A  26     -56.362   0.008 -20.108  1.00 40.61           C  
ATOM    199  O   THR A  26     -55.590   0.430 -19.233  1.00 42.36           O  
ATOM    200  CB  THR A  26     -56.331  -2.096 -21.540  1.00 44.63           C  
ATOM    201  OG1 THR A  26     -55.799  -2.801 -20.398  1.00 49.52           O  
ATOM    202  CG2 THR A  26     -55.863  -2.872 -22.750  1.00 50.71           C  
ATOM    203  N   GLY A  27     -57.644   0.106 -19.899  1.00 39.86           N  
ATOM    204  CA  GLY A  27     -58.240   0.646 -18.680  1.00 40.09           C  
ATOM    205  C   GLY A  27     -58.504   2.148 -18.862  1.00 37.06           C  
ATOM    206  O   GLY A  27     -58.232   2.917 -17.950  1.00 37.02           O  
ATOM    207  N   LEU A  28     -58.701   2.557 -20.116  1.00 32.13           N  
ATOM    208  CA  LEU A  28     -58.969   3.930 -20.435  1.00 31.44           C  
ATOM    209  C   LEU A  28     -60.304   4.342 -19.782  1.00 28.71           C  
ATOM    210  O   LEU A  28     -61.302   3.673 -19.938  1.00 30.26           O  
ATOM    211  CB  LEU A  28     -59.192   4.213 -21.933  1.00 31.70           C  
ATOM    212  CG  LEU A  28     -58.224   3.829 -23.029  1.00 44.33           C  
ATOM    213  CD1 LEU A  28     -58.374   4.565 -24.381  1.00 39.00           C  
ATOM    214  CD2 LEU A  28     -56.806   3.984 -22.550  1.00 51.76           C  
ATOM    215  N   THR A  29     -60.279   5.568 -19.281  1.00 30.48           N  
ATOM    216  CA  THR A  29     -61.526   6.302 -18.925  1.00 30.06           C  
ATOM    217  C   THR A  29     -61.805   7.375 -20.009  1.00 25.65           C  
ATOM    218  O   THR A  29     -60.890   8.146 -20.334  1.00 25.50           O  
ATOM    219  CB  THR A  29     -61.418   6.937 -17.543  1.00 28.37           C  
ATOM    220  OG1 THR A  29     -61.559   5.930 -16.543  1.00 31.52           O  
ATOM    221  CG2 THR A  29     -62.485   8.001 -17.389  1.00 38.35           C  
ATOM    222  N   VAL A  30     -62.995   7.471 -20.554  1.00 23.03           N  
ATOM    223  CA  VAL A  30     -63.331   8.423 -21.604  1.00 23.96           C  
ATOM    224  C   VAL A  30     -64.395   9.419 -21.133  1.00 25.24           C  
ATOM    225  O   VAL A  30     -65.430   9.006 -20.620  1.00 24.27           O  
ATOM    226  CB  VAL A  30     -63.871   7.690 -22.840  1.00 21.88           C  
ATOM    227  CG1 VAL A  30     -64.282   8.689 -23.918  1.00 23.68           C  
ATOM    228  CG2 VAL A  30     -62.828   6.723 -23.376  1.00 26.70           C  
ATOM    229  N   THR A  31     -64.133  10.703 -21.329  1.00 24.32           N  
ATOM    230  CA  THR A  31     -65.084  11.754 -21.016  1.00 27.63           C  
ATOM    231  C   THR A  31     -65.333  12.661 -22.231  1.00 28.02           C  
ATOM    232  O   THR A  31     -64.381  13.067 -22.892  1.00 22.52           O  
ATOM    233  CB  THR A  31     -64.547  12.711 -19.928  1.00 24.32           C  
ATOM    234  OG1 THR A  31     -64.073  11.953 -18.798  1.00 23.60           O  
ATOM    235  CG2 THR A  31     -65.644  13.660 -19.477  1.00 23.11           C  
ATOM    236  N   GLU A  32     -66.577  12.957 -22.526  1.00 21.39           N  
ATOM    237  CA  GLU A  32     -66.885  13.909 -23.609  1.00 26.94           C  
ATOM    238  C   GLU A  32     -66.678  15.323 -23.035  1.00 24.56           C  
ATOM    239  O   GLU A  32     -67.214  15.622 -21.974  1.00 24.88           O  
ATOM    240  CB  GLU A  32     -68.328  13.753 -24.090  1.00 30.63           C  
ATOM    241  CG  GLU A  32     -68.498  12.510 -24.943  1.00 38.15           C  
ATOM    242  CD  GLU A  32     -69.899  12.395 -25.486  1.00 43.43           C  
ATOM    243  OE1 GLU A  32     -70.395  13.404 -26.042  1.00 40.99           O  
ATOM    244  OE2 GLU A  32     -70.512  11.314 -25.368  1.00 43.47           O  
ATOM    245  N   VAL A  33     -65.921  16.215 -23.690  1.00 22.72           N  
ATOM    246  CA  VAL A  33     -65.692  17.569 -23.177  1.00 24.10           C  
ATOM    247  C   VAL A  33     -65.811  18.569 -24.328  1.00 23.35           C  
ATOM    248  O   VAL A  33     -65.863  18.155 -25.490  1.00 23.76           O  
ATOM    249  CB  VAL A  33     -64.262  17.737 -22.578  1.00 28.75           C  
ATOM    250  CG1 VAL A  33     -64.065  16.834 -21.380  1.00 26.01           C  
ATOM    251  CG2 VAL A  33     -63.208  17.452 -23.629  1.00 27.03           C  
ATOM    252  N   LYS A  34     -65.816  19.877 -24.018  1.00 21.14           N  
ATOM    253  CA  LYS A  34     -65.821  20.947 -25.076  1.00 22.39           C  
ATOM    254  C   LYS A  34     -64.461  21.657 -25.067  1.00 27.02           C  
ATOM    255  O   LYS A  34     -63.807  21.725 -24.016  1.00 28.99           O  
ATOM    256  CB  LYS A  34     -66.913  22.034 -24.835  1.00 28.05           C  
ATOM    257  CG  LYS A  34     -68.342  21.498 -24.768  1.00 31.15           C  
ATOM    258  CD  LYS A  34     -68.674  20.588 -25.947  1.00 39.05           C  
ATOM    259  CE  LYS A  34     -70.167  20.339 -26.091  1.00 37.60           C  
ATOM    260  NZ  LYS A  34     -70.501  19.717 -27.408  1.00 36.68           N  
ATOM    261  N   GLY A  35     -64.038  22.123 -26.247  1.00 21.25           N  
ATOM    262  CA  GLY A  35     -62.835  22.886 -26.472  1.00 26.94           C  
ATOM    263  C   GLY A  35     -63.323  24.120 -27.224  1.00 29.12           C  
ATOM    264  O   GLY A  35     -64.496  24.175 -27.610  1.00 30.67           O  
ATOM    265  N   PHE A  36     -62.480  25.103 -27.444  1.00 28.59           N  
ATOM    266  CA  PHE A  36     -62.886  26.304 -28.162  1.00 31.03           C  
ATOM    267  C   PHE A  36     -62.071  26.536 -29.411  1.00 36.58           C  
ATOM    268  O   PHE A  36     -60.842  26.495 -29.302  1.00 35.37           O  
ATOM    269  CB  PHE A  36     -62.679  27.561 -27.252  1.00 30.01           C  
ATOM    270  CG  PHE A  36     -63.732  27.444 -26.162  1.00 33.46           C  
ATOM    271  CD1 PHE A  36     -63.406  27.171 -24.861  1.00 38.23           C  
ATOM    272  CD2 PHE A  36     -65.079  27.549 -26.500  1.00 34.14           C  
ATOM    273  CE1 PHE A  36     -64.389  27.053 -23.901  1.00 41.95           C  
ATOM    274  CE2 PHE A  36     -66.057  27.435 -25.554  1.00 35.56           C  
ATOM    275  CZ  PHE A  36     -65.713  27.181 -24.239  1.00 36.83           C  
ATOM    276  N   GLY A  37     -62.748  26.812 -30.524  1.00 33.07           N  
ATOM    277  CA  GLY A  37     -62.015  27.015 -31.773  1.00 35.54           C  
ATOM    278  C   GLY A  37     -61.860  28.536 -31.958  1.00 41.97           C  
ATOM    279  O   GLY A  37     -61.232  28.979 -32.882  1.00 45.83           O  
ATOM    280  N   TYR A  51     -67.618  30.864 -41.678  1.00 45.33           N  
ATOM    281  CA  TYR A  51     -67.834  30.892 -40.190  1.00 40.12           C  
ATOM    282  C   TYR A  51     -66.867  30.022 -39.390  1.00 31.02           C  
ATOM    283  O   TYR A  51     -66.826  28.808 -39.568  1.00 32.64           O  
ATOM    284  CB  TYR A  51     -69.271  30.529 -39.891  1.00 37.83           C  
ATOM    285  CG  TYR A  51     -69.844  30.527 -38.513  1.00 36.90           C  
ATOM    286  CD1 TYR A  51     -70.618  31.585 -38.032  1.00 36.53           C  
ATOM    287  CD2 TYR A  51     -69.664  29.398 -37.708  1.00 36.10           C  
ATOM    288  CE1 TYR A  51     -71.165  31.523 -36.749  1.00 40.18           C  
ATOM    289  CE2 TYR A  51     -70.192  29.326 -36.438  1.00 37.87           C  
ATOM    290  CZ  TYR A  51     -70.933  30.405 -35.975  1.00 37.46           C  
ATOM    291  OH  TYR A  51     -71.446  30.330 -34.727  1.00 40.24           O  
ATOM    292  N   VAL A  52     -66.244  30.640 -38.415  1.00 32.84           N  
ATOM    293  CA  VAL A  52     -65.303  29.894 -37.570  1.00 35.39           C  
ATOM    294  C   VAL A  52     -66.051  29.283 -36.407  1.00 33.11           C  
ATOM    295  O   VAL A  52     -66.483  30.058 -35.560  1.00 33.39           O  
ATOM    296  CB  VAL A  52     -64.199  30.861 -37.106  1.00 39.66           C  
ATOM    297  CG1 VAL A  52     -63.247  30.149 -36.127  1.00 38.99           C  
ATOM    298  CG2 VAL A  52     -63.379  31.297 -38.325  1.00 43.39           C  
ATOM    299  N   VAL A  53     -66.163  27.972 -36.310  1.00 32.50           N  
ATOM    300  CA  VAL A  53     -66.848  27.355 -35.186  1.00 30.30           C  
ATOM    301  C   VAL A  53     -66.103  27.642 -33.876  1.00 34.51           C  
ATOM    302  O   VAL A  53     -64.877  27.662 -33.853  1.00 30.78           O  
ATOM    303  CB  VAL A  53     -66.980  25.850 -35.434  1.00 33.53           C  
ATOM    304  CG1 VAL A  53     -67.522  25.153 -34.192  1.00 35.95           C  
ATOM    305  CG2 VAL A  53     -67.862  25.574 -36.643  1.00 29.73           C  
ATOM    306  N   ASP A  54     -66.854  27.863 -32.787  1.00 25.98           N  
ATOM    307  CA  ASP A  54     -66.287  28.116 -31.429  1.00 27.72           C  
ATOM    308  C   ASP A  54     -66.385  26.897 -30.537  1.00 28.64           C  
ATOM    309  O   ASP A  54     -65.388  26.247 -30.277  1.00 28.24           O  
ATOM    310  CB  ASP A  54     -66.963  29.330 -30.770  1.00 32.05           C  
ATOM    311  CG  ASP A  54     -66.090  29.888 -29.677  1.00 39.52           C  
ATOM    312  OD1 ASP A  54     -64.867  29.593 -29.677  1.00 37.59           O  
ATOM    313  OD2 ASP A  54     -66.620  30.621 -28.814  1.00 34.32           O  
ATOM    314  N   PHE A  55     -67.583  26.513 -30.068  1.00 23.56           N  
ATOM    315  CA  PHE A  55     -67.745  25.320 -29.218  1.00 28.62           C  
ATOM    316  C   PHE A  55     -67.429  24.013 -30.017  1.00 25.48           C  
ATOM    317  O   PHE A  55     -68.093  23.739 -31.010  1.00 25.09           O  
ATOM    318  CB  PHE A  55     -69.171  25.278 -28.660  1.00 26.21           C  
ATOM    319  CG  PHE A  55     -69.389  26.204 -27.520  1.00 31.72           C  
ATOM    320  CD1 PHE A  55     -69.437  27.568 -27.719  1.00 34.91           C  
ATOM    321  CD2 PHE A  55     -69.541  25.689 -26.251  1.00 33.19           C  
ATOM    322  CE1 PHE A  55     -69.610  28.393 -26.650  1.00 43.43           C  
ATOM    323  CE2 PHE A  55     -69.727  26.517 -25.161  1.00 33.03           C  
ATOM    324  CZ  PHE A  55     -69.752  27.876 -25.377  1.00 28.64           C  
ATOM    325  N   LEU A  56     -66.446  23.209 -29.592  1.00 24.43           N  
ATOM    326  CA  LEU A  56     -66.045  21.996 -30.367  1.00 25.26           C  
ATOM    327  C   LEU A  56     -66.042  20.694 -29.549  1.00 24.55           C  
ATOM    328  O   LEU A  56     -65.691  20.681 -28.377  1.00 26.13           O  
ATOM    329  CB  LEU A  56     -64.651  22.207 -30.989  1.00 29.60           C  
ATOM    330  CG  LEU A  56     -64.537  23.355 -32.011  1.00 38.33           C  
ATOM    331  CD1 LEU A  56     -63.074  23.626 -32.366  1.00 39.96           C  
ATOM    332  CD2 LEU A  56     -65.355  23.029 -33.252  1.00 39.58           C  
ATOM    333  N   PRO A  57     -66.435  19.623 -30.214  1.00 22.07           N  
ATOM    334  CA  PRO A  57     -66.382  18.308 -29.567  1.00 26.27           C  
ATOM    335  C   PRO A  57     -64.998  17.855 -29.190  1.00 28.66           C  
ATOM    336  O   PRO A  57     -64.100  17.915 -30.030  1.00 21.55           O  
ATOM    337  CB  PRO A  57     -67.061  17.391 -30.543  1.00 24.53           C  
ATOM    338  CG  PRO A  57     -68.138  18.269 -31.061  1.00 25.85           C  
ATOM    339  CD  PRO A  57     -67.756  19.707 -30.855  1.00 20.40           C  
ATOM    340  N   LYS A  58     -64.762  17.357 -28.020  1.00 27.11           N  
ATOM    341  CA  LYS A  58     -63.457  16.757 -27.861  1.00 27.04           C  
ATOM    342  C   LYS A  58     -63.691  15.579 -26.989  1.00 28.40           C  
ATOM    343  O   LYS A  58     -64.779  15.351 -26.483  1.00 22.85           O  
ATOM    344  CB  LYS A  58     -62.415  17.674 -27.207  1.00 24.54           C  
ATOM    345  CG  LYS A  58     -62.123  18.939 -28.007  1.00 30.19           C  
ATOM    346  CD  LYS A  58     -61.091  18.691 -29.097  1.00 42.60           C  
ATOM    347  CE  LYS A  58     -60.885  19.926 -29.951  1.00 52.92           C  
ATOM    348  NZ  LYS A  58     -60.231  19.607 -31.250  1.00 43.85           N  
ATOM    349  N   VAL A  59     -62.651  14.832 -26.823  1.00 22.96           N  
ATOM    350  CA  VAL A  59     -62.742  13.682 -26.008  1.00 24.93           C  
ATOM    351  C   VAL A  59     -61.535  13.673 -25.116  1.00 30.10           C  
ATOM    352  O   VAL A  59     -60.421  13.902 -25.572  1.00 29.34           O  
ATOM    353  CB  VAL A  59     -62.902  12.415 -26.867  1.00 35.78           C  
ATOM    354  CG1 VAL A  59     -62.144  11.252 -26.235  1.00 38.18           C  
ATOM    355  CG2 VAL A  59     -64.363  12.076 -27.050  1.00 27.27           C  
ATOM    356  N   LYS A  60     -61.761  13.422 -23.855  1.00 24.82           N  
ATOM    357  CA  LYS A  60     -60.618  13.391 -22.935  1.00 28.70           C  
ATOM    358  C   LYS A  60     -60.459  11.876 -22.629  1.00 28.41           C  
ATOM    359  O   LYS A  60     -61.457  11.182 -22.306  1.00 26.64           O  
ATOM    360  CB  LYS A  60     -60.887  14.070 -21.626  1.00 29.87           C  
ATOM    361  CG  LYS A  60     -59.732  14.008 -20.621  1.00 34.06           C  
ATOM    362  CD  LYS A  60     -60.232  14.440 -19.273  1.00 33.61           C  
ATOM    363  CE  LYS A  60     -59.987  15.937 -19.097  1.00 43.87           C  
ATOM    364  NZ  LYS A  60     -60.261  16.129 -17.622  1.00 46.28           N  
ATOM    365  N   ILE A  61     -59.211  11.489 -22.705  1.00 23.83           N  
ATOM    366  CA  ILE A  61     -58.846  10.120 -22.263  1.00 27.87           C  
ATOM    367  C   ILE A  61     -57.918  10.154 -21.100  1.00 23.09           C  
ATOM    368  O   ILE A  61     -56.986  10.958 -21.030  1.00 28.66           O  
ATOM    369  CB  ILE A  61     -58.149   9.308 -23.379  1.00 39.50           C  
ATOM    370  CG1 ILE A  61     -59.166   9.089 -24.524  1.00 35.60           C  
ATOM    371  CG2 ILE A  61     -57.726   7.936 -22.874  1.00 44.47           C  
ATOM    372  CD1 ILE A  61     -58.261   8.829 -25.755  1.00 52.22           C  
ATOM    373  N   GLU A  62     -58.106   9.239 -20.144  1.00 28.75           N  
ATOM    374  CA  GLU A  62     -57.285   9.235 -18.955  1.00 27.18           C  
ATOM    375  C   GLU A  62     -56.897   7.788 -18.594  1.00 29.23           C  
ATOM    376  O   GLU A  62     -57.708   6.858 -18.719  1.00 27.40           O  
ATOM    377  CB  GLU A  62     -57.944   9.807 -17.703  1.00 26.54           C  
ATOM    378  CG  GLU A  62     -58.274  11.318 -17.787  1.00 31.60           C  
ATOM    379  CD  GLU A  62     -59.264  11.626 -16.659  1.00 40.97           C  
ATOM    380  OE1 GLU A  62     -60.289  10.919 -16.558  1.00 33.62           O  
ATOM    381  OE2 GLU A  62     -58.985  12.532 -15.856  1.00 40.83           O  
ATOM    382  N   VAL A  63     -55.616   7.569 -18.340  1.00 29.94           N  
ATOM    383  CA  VAL A  63     -55.126   6.220 -17.905  1.00 35.98           C  
ATOM    384  C   VAL A  63     -54.004   6.414 -16.863  1.00 36.13           C  
ATOM    385  O   VAL A  63     -53.200   7.320 -16.931  1.00 34.79           O  
ATOM    386  CB  VAL A  63     -54.438   5.358 -18.973  1.00 40.35           C  
ATOM    387  CG1 VAL A  63     -55.348   5.031 -20.113  1.00 53.83           C  
ATOM    388  CG2 VAL A  63     -53.260   6.155 -19.628  1.00 39.73           C  
ATOM    389  N   VAL A  64     -53.959   5.544 -15.885  1.00 39.61           N  
ATOM    390  CA  VAL A  64     -52.938   5.543 -14.854  1.00 40.42           C  
ATOM    391  C   VAL A  64     -52.058   4.330 -15.163  1.00 35.33           C  
ATOM    392  O   VAL A  64     -52.517   3.223 -15.415  1.00 33.49           O  
ATOM    393  CB  VAL A  64     -53.633   5.464 -13.495  1.00 43.82           C  
ATOM    394  CG1 VAL A  64     -52.637   5.262 -12.374  1.00 39.26           C  
ATOM    395  CG2 VAL A  64     -54.462   6.746 -13.250  1.00 39.09           C  
ATOM    396  N   VAL A  65     -50.793   4.579 -15.313  1.00 36.19           N  
ATOM    397  CA  VAL A  65     -49.781   3.602 -15.662  1.00 42.21           C  
ATOM    398  C   VAL A  65     -48.610   3.612 -14.663  1.00 40.57           C  
ATOM    399  O   VAL A  65     -48.278   4.599 -14.011  1.00 32.97           O  
ATOM    400  CB  VAL A  65     -49.206   3.815 -17.077  1.00 48.70           C  
ATOM    401  CG1 VAL A  65     -50.263   3.540 -18.151  1.00 53.90           C  
ATOM    402  CG2 VAL A  65     -48.652   5.223 -17.243  1.00 50.13           C  
ATOM    403  N   ASP A  66     -47.921   2.453 -14.676  1.00 46.13           N  
ATOM    404  CA  ASP A  66     -46.643   2.455 -13.886  1.00 44.85           C  
ATOM    405  C   ASP A  66     -45.687   3.473 -14.433  1.00 39.52           C  
ATOM    406  O   ASP A  66     -45.587   3.663 -15.681  1.00 42.34           O  
ATOM    407  CB  ASP A  66     -46.028   1.038 -14.080  1.00 58.73           C  
ATOM    408  CG  ASP A  66     -44.843   1.009 -13.091  1.00 67.80           C  
ATOM    409  OD1 ASP A  66     -43.786   0.569 -13.558  1.00 64.26           O  
ATOM    410  OD2 ASP A  66     -45.097   1.468 -11.941  1.00 67.77           O  
ATOM    411  N   ASP A  67     -44.793   4.054 -13.712  1.00 43.11           N  
ATOM    412  CA  ASP A  67     -43.810   5.020 -14.192  1.00 48.89           C  
ATOM    413  C   ASP A  67     -43.031   4.683 -15.440  1.00 48.40           C  
ATOM    414  O   ASP A  67     -42.776   5.545 -16.302  1.00 47.17           O  
ATOM    415  CB  ASP A  67     -42.857   5.313 -13.018  1.00 57.18           C  
ATOM    416  CG  ASP A  67     -43.515   6.131 -11.927  1.00 65.31           C  
ATOM    417  OD1 ASP A  67     -44.752   6.334 -11.906  1.00 62.82           O  
ATOM    418  OD2 ASP A  67     -42.771   6.599 -11.027  1.00 56.70           O  
ATOM    419  N   LYS A  68     -42.584   3.458 -15.632  1.00 49.47           N  
ATOM    420  CA  LYS A  68     -41.744   3.108 -16.776  1.00 51.69           C  
ATOM    421  C   LYS A  68     -42.511   2.965 -18.084  1.00 56.44           C  
ATOM    422  O   LYS A  68     -41.852   2.731 -19.096  1.00 59.61           O  
ATOM    423  CB  LYS A  68     -41.075   1.753 -16.562  1.00 60.48           C  
ATOM    424  CG  LYS A  68     -40.665   1.331 -15.171  1.00 73.29           C  
ATOM    425  CD  LYS A  68     -41.017  -0.149 -14.999  1.00 83.03           C  
ATOM    426  CE  LYS A  68     -40.555  -0.785 -13.708  1.00 82.14           C  
ATOM    427  NZ  LYS A  68     -41.346  -0.413 -12.508  1.00 85.25           N  
ATOM    428  N   VAL A  69     -43.840   2.963 -18.116  1.00 52.02           N  
ATOM    429  CA  VAL A  69     -44.648   2.759 -19.298  1.00 48.61           C  
ATOM    430  C   VAL A  69     -45.035   4.089 -19.936  1.00 45.69           C  
ATOM    431  O   VAL A  69     -45.501   4.165 -21.062  1.00 45.57           O  
ATOM    432  CB  VAL A  69     -45.948   2.046 -18.845  1.00 55.09           C  
ATOM    433  CG1 VAL A  69     -46.956   1.819 -19.951  1.00 43.79           C  
ATOM    434  CG2 VAL A  69     -45.578   0.706 -18.209  1.00 51.80           C  
ATOM    435  N   VAL A  70     -44.864   5.165 -19.196  1.00 43.36           N  
ATOM    436  CA  VAL A  70     -45.251   6.500 -19.613  1.00 44.51           C  
ATOM    437  C   VAL A  70     -44.771   6.905 -20.986  1.00 46.65           C  
ATOM    438  O   VAL A  70     -45.497   7.588 -21.723  1.00 38.28           O  
ATOM    439  CB  VAL A  70     -44.765   7.582 -18.625  1.00 49.69           C  
ATOM    440  CG1 VAL A  70     -45.262   8.967 -19.016  1.00 46.62           C  
ATOM    441  CG2 VAL A  70     -45.255   7.269 -17.225  1.00 56.67           C  
ATOM    442  N   GLU A  71     -43.435   6.772 -21.177  1.00 44.69           N  
ATOM    443  CA  GLU A  71     -42.880   7.147 -22.469  1.00 45.17           C  
ATOM    444  C   GLU A  71     -43.560   6.404 -23.610  1.00 37.74           C  
ATOM    445  O   GLU A  71     -43.855   7.043 -24.616  1.00 42.72           O  
ATOM    446  CB  GLU A  71     -41.368   6.912 -22.596  1.00 58.08           C  
ATOM    447  CG  GLU A  71     -40.483   8.141 -22.396  1.00 74.88           C  
ATOM    448  CD  GLU A  71     -39.029   7.706 -22.199  1.00 85.89           C  
ATOM    449  OE1 GLU A  71     -38.495   6.976 -23.063  1.00 84.26           O  
ATOM    450  OE2 GLU A  71     -38.427   8.087 -21.169  1.00 90.74           O  
ATOM    451  N   GLN A  72     -43.734   5.106 -23.588  1.00 36.49           N  
ATOM    452  CA  GLN A  72     -44.332   4.395 -24.716  1.00 38.70           C  
ATOM    453  C   GLN A  72     -45.864   4.614 -24.798  1.00 38.90           C  
ATOM    454  O   GLN A  72     -46.406   4.599 -25.909  1.00 38.40           O  
ATOM    455  CB  GLN A  72     -44.011   2.901 -24.710  1.00 42.69           C  
ATOM    456  CG  GLN A  72     -44.871   2.034 -23.796  1.00 65.30           C  
ATOM    457  CD  GLN A  72     -44.038   0.989 -23.053  1.00 79.34           C  
ATOM    458  OE1 GLN A  72     -42.804   1.125 -22.948  1.00 75.99           O  
ATOM    459  NE2 GLN A  72     -44.700  -0.050 -22.533  1.00 76.84           N  
ATOM    460  N   ALA A  73     -46.481   4.973 -23.673  1.00 40.73           N  
ATOM    461  CA  ALA A  73     -47.917   5.321 -23.686  1.00 39.43           C  
ATOM    462  C   ALA A  73     -48.087   6.626 -24.423  1.00 34.68           C  
ATOM    463  O   ALA A  73     -48.897   6.780 -25.332  1.00 39.06           O  
ATOM    464  CB  ALA A  73     -48.413   5.378 -22.225  1.00 31.93           C  
ATOM    465  N   VAL A  74     -47.256   7.620 -24.095  1.00 35.97           N  
ATOM    466  CA  VAL A  74     -47.235   8.894 -24.780  1.00 37.31           C  
ATOM    467  C   VAL A  74     -46.875   8.751 -26.243  1.00 43.33           C  
ATOM    468  O   VAL A  74     -47.516   9.344 -27.144  1.00 41.52           O  
ATOM    469  CB  VAL A  74     -46.278   9.839 -24.051  1.00 44.90           C  
ATOM    470  CG1 VAL A  74     -45.998  11.110 -24.826  1.00 44.58           C  
ATOM    471  CG2 VAL A  74     -46.888  10.114 -22.670  1.00 52.51           C  
ATOM    472  N   ASP A  75     -45.871   7.900 -26.510  1.00 39.65           N  
ATOM    473  CA  ASP A  75     -45.493   7.614 -27.876  1.00 39.54           C  
ATOM    474  C   ASP A  75     -46.655   7.090 -28.683  1.00 33.57           C  
ATOM    475  O   ASP A  75     -46.922   7.554 -29.815  1.00 34.35           O  
ATOM    476  CB  ASP A  75     -44.316   6.594 -27.922  1.00 54.32           C  
ATOM    477  CG  ASP A  75     -43.801   6.416 -29.338  1.00 65.65           C  
ATOM    478  OD1 ASP A  75     -43.621   7.448 -30.038  1.00 73.88           O  
ATOM    479  OD2 ASP A  75     -43.572   5.279 -29.805  1.00 72.08           O  
ATOM    480  N   ALA A  76     -47.332   6.082 -28.128  1.00 30.06           N  
ATOM    481  CA  ALA A  76     -48.468   5.507 -28.865  1.00 35.42           C  
ATOM    482  C   ALA A  76     -49.630   6.495 -29.088  1.00 33.99           C  
ATOM    483  O   ALA A  76     -50.292   6.418 -30.123  1.00 31.90           O  
ATOM    484  CB  ALA A  76     -48.928   4.277 -28.044  1.00 34.05           C  
ATOM    485  N   ILE A  77     -49.858   7.428 -28.150  1.00 31.10           N  
ATOM    486  CA  ILE A  77     -51.001   8.351 -28.388  1.00 39.61           C  
ATOM    487  C   ILE A  77     -50.611   9.269 -29.546  1.00 35.06           C  
ATOM    488  O   ILE A  77     -51.405   9.526 -30.471  1.00 31.60           O  
ATOM    489  CB  ILE A  77     -51.421   9.184 -27.164  1.00 33.56           C  
ATOM    490  CG1 ILE A  77     -51.965   8.265 -26.087  1.00 33.14           C  
ATOM    491  CG2 ILE A  77     -52.414  10.316 -27.528  1.00 36.17           C  
ATOM    492  CD1 ILE A  77     -51.853   8.748 -24.631  1.00 25.60           C  
ATOM    493  N   ILE A  78     -49.357   9.737 -29.529  1.00 37.31           N  
ATOM    494  CA  ILE A  78     -48.883  10.606 -30.594  1.00 36.00           C  
ATOM    495  C   ILE A  78     -48.982   9.928 -31.946  1.00 35.10           C  
ATOM    496  O   ILE A  78     -49.534  10.532 -32.877  1.00 34.49           O  
ATOM    497  CB  ILE A  78     -47.433  11.084 -30.570  1.00 51.13           C  
ATOM    498  CG1 ILE A  78     -47.100  11.558 -29.166  1.00 48.92           C  
ATOM    499  CG2 ILE A  78     -47.185  12.145 -31.660  1.00 38.93           C  
ATOM    500  CD1 ILE A  78     -47.110  12.977 -28.802  1.00 45.42           C  
ATOM    501  N   LYS A  79     -48.561   8.671 -31.967  1.00 36.18           N  
ATOM    502  CA  LYS A  79     -48.570   8.038 -33.296  1.00 37.04           C  
ATOM    503  C   LYS A  79     -49.988   8.012 -33.856  1.00 35.50           C  
ATOM    504  O   LYS A  79     -50.109   8.062 -35.054  1.00 35.79           O  
ATOM    505  CB  LYS A  79     -47.968   6.639 -33.255  1.00 47.86           C  
ATOM    506  CG  LYS A  79     -46.463   6.750 -32.990  1.00 73.18           C  
ATOM    507  CD  LYS A  79     -45.651   5.495 -33.175  1.00 77.98           C  
ATOM    508  CE  LYS A  79     -46.038   4.286 -32.364  1.00 81.16           C  
ATOM    509  NZ  LYS A  79     -47.091   3.454 -33.015  1.00 90.83           N  
ATOM    510  N   ALA A  80     -50.967   7.531 -33.114  1.00 37.38           N  
ATOM    511  CA  ALA A  80     -52.353   7.401 -33.491  1.00 35.27           C  
ATOM    512  C   ALA A  80     -53.079   8.732 -33.750  1.00 35.06           C  
ATOM    513  O   ALA A  80     -53.755   8.892 -34.776  1.00 34.11           O  
ATOM    514  CB  ALA A  80     -53.049   6.665 -32.328  1.00 32.33           C  
ATOM    515  N   ALA A  81     -52.839   9.787 -32.993  1.00 30.88           N  
ATOM    516  CA  ALA A  81     -53.645  11.002 -33.209  1.00 33.03           C  
ATOM    517  C   ALA A  81     -53.030  12.055 -34.081  1.00 38.54           C  
ATOM    518  O   ALA A  81     -53.814  12.863 -34.600  1.00 38.81           O  
ATOM    519  CB  ALA A  81     -53.944  11.553 -31.794  1.00 29.26           C  
ATOM    520  N   ARG A  82     -51.698  12.157 -34.267  1.00 37.92           N  
ATOM    521  CA  ARG A  82     -51.106  13.295 -34.937  1.00 34.73           C  
ATOM    522  C   ARG A  82     -51.532  13.403 -36.391  1.00 33.95           C  
ATOM    523  O   ARG A  82     -51.435  12.388 -37.093  1.00 31.47           O  
ATOM    524  CB  ARG A  82     -49.570  13.198 -34.844  1.00 28.42           C  
ATOM    525  CG  ARG A  82     -48.851  14.222 -35.732  1.00 38.24           C  
ATOM    526  CD  ARG A  82     -47.347  14.062 -35.573  1.00 46.44           C  
ATOM    527  NE  ARG A  82     -46.892  14.626 -34.304  1.00 46.82           N  
ATOM    528  CZ  ARG A  82     -45.665  14.456 -33.811  1.00 54.95           C  
ATOM    529  NH1 ARG A  82     -44.715  13.747 -34.413  1.00 54.36           N  
ATOM    530  NH2 ARG A  82     -45.384  15.022 -32.649  1.00 47.67           N  
ATOM    531  N   THR A  83     -51.994  14.562 -36.874  1.00 34.69           N  
ATOM    532  CA  THR A  83     -52.264  14.748 -38.289  1.00 37.57           C  
ATOM    533  C   THR A  83     -51.363  15.880 -38.855  1.00 45.30           C  
ATOM    534  O   THR A  83     -51.297  16.175 -40.056  1.00 42.47           O  
ATOM    535  CB  THR A  83     -53.661  15.180 -38.701  1.00 35.55           C  
ATOM    536  OG1 THR A  83     -53.959  16.419 -38.000  1.00 28.23           O  
ATOM    537  CG2 THR A  83     -54.655  14.100 -38.399  1.00 35.35           C  
ATOM    538  N   GLY A  84     -50.816  16.649 -37.925  1.00 40.44           N  
ATOM    539  CA  GLY A  84     -49.943  17.751 -38.263  1.00 41.01           C  
ATOM    540  C   GLY A  84     -50.791  18.990 -38.426  1.00 44.60           C  
ATOM    541  O   GLY A  84     -50.227  20.018 -38.793  1.00 43.98           O  
ATOM    542  N   LYS A  85     -52.099  18.937 -38.105  1.00 44.06           N  
ATOM    543  CA  LYS A  85     -52.904  20.162 -38.143  1.00 42.23           C  
ATOM    544  C   LYS A  85     -53.376  20.649 -36.783  1.00 40.12           C  
ATOM    545  O   LYS A  85     -53.392  19.926 -35.789  1.00 33.64           O  
ATOM    546  CB  LYS A  85     -54.141  19.948 -39.021  1.00 53.44           C  
ATOM    547  CG  LYS A  85     -53.912  19.200 -40.316  1.00 58.20           C  
ATOM    548  CD  LYS A  85     -53.452  20.003 -41.517  1.00 71.37           C  
ATOM    549  CE  LYS A  85     -52.224  19.399 -42.189  1.00 78.36           C  
ATOM    550  NZ  LYS A  85     -52.047  19.700 -43.635  1.00 80.12           N  
ATOM    551  N   ILE A  86     -53.662  21.962 -36.714  1.00 40.34           N  
ATOM    552  CA  ILE A  86     -54.184  22.566 -35.488  1.00 40.46           C  
ATOM    553  C   ILE A  86     -55.435  21.836 -35.037  1.00 36.04           C  
ATOM    554  O   ILE A  86     -56.251  21.316 -35.788  1.00 35.27           O  
ATOM    555  CB  ILE A  86     -54.493  24.039 -35.805  1.00 47.66           C  
ATOM    556  CG1 ILE A  86     -55.102  24.783 -34.631  1.00 52.29           C  
ATOM    557  CG2 ILE A  86     -55.483  24.072 -36.973  1.00 56.51           C  
ATOM    558  CD1 ILE A  86     -55.124  26.292 -34.850  1.00 61.09           C  
ATOM    559  N   GLY A  87     -55.549  21.508 -33.776  1.00 35.05           N  
ATOM    560  CA  GLY A  87     -56.715  20.739 -33.303  1.00 37.01           C  
ATOM    561  C   GLY A  87     -56.328  19.316 -32.945  1.00 34.94           C  
ATOM    562  O   GLY A  87     -57.135  18.753 -32.208  1.00 33.04           O  
ATOM    563  N   ASP A  88     -55.052  18.905 -33.136  1.00 29.94           N  
ATOM    564  CA  ASP A  88     -54.757  17.510 -32.798  1.00 26.39           C  
ATOM    565  C   ASP A  88     -54.768  17.262 -31.310  1.00 27.67           C  
ATOM    566  O   ASP A  88     -54.954  16.113 -30.868  1.00 33.37           O  
ATOM    567  CB  ASP A  88     -53.418  17.033 -33.356  1.00 36.91           C  
ATOM    568  CG  ASP A  88     -53.335  16.694 -34.832  1.00 35.90           C  
ATOM    569  OD1 ASP A  88     -54.319  16.401 -35.493  1.00 30.28           O  
ATOM    570  OD2 ASP A  88     -52.190  16.712 -35.359  1.00 42.44           O  
ATOM    571  N   GLY A  89     -54.568  18.313 -30.483  1.00 25.82           N  
ATOM    572  CA  GLY A  89     -54.743  18.068 -29.072  1.00 24.26           C  
ATOM    573  C   GLY A  89     -53.434  18.110 -28.295  1.00 33.11           C  
ATOM    574  O   GLY A  89     -52.365  18.457 -28.806  1.00 34.09           O  
ATOM    575  N   LYS A  90     -53.570  17.690 -27.026  1.00 28.66           N  
ATOM    576  CA  LYS A  90     -52.430  17.768 -26.137  1.00 31.60           C  
ATOM    577  C   LYS A  90     -52.439  16.608 -25.151  1.00 33.55           C  
ATOM    578  O   LYS A  90     -53.496  16.062 -24.897  1.00 30.42           O  
ATOM    579  CB  LYS A  90     -52.485  18.985 -25.241  1.00 35.30           C  
ATOM    580  CG  LYS A  90     -51.765  20.184 -25.877  1.00 58.32           C  
ATOM    581  CD  LYS A  90     -52.023  21.408 -25.005  1.00 61.16           C  
ATOM    582  CE  LYS A  90     -51.784  22.681 -25.813  1.00 64.83           C  
ATOM    583  NZ  LYS A  90     -52.432  23.830 -25.111  1.00 77.46           N  
ATOM    584  N   ILE A  91     -51.288  16.283 -24.621  1.00 26.54           N  
ATOM    585  CA  ILE A  91     -51.180  15.241 -23.636  1.00 25.34           C  
ATOM    586  C   ILE A  91     -50.582  15.850 -22.358  1.00 33.64           C  
ATOM    587  O   ILE A  91     -49.683  16.706 -22.435  1.00 31.21           O  
ATOM    588  CB  ILE A  91     -50.236  14.111 -24.141  1.00 31.80           C  
ATOM    589  CG1 ILE A  91     -50.723  13.538 -25.485  1.00 34.34           C  
ATOM    590  CG2 ILE A  91     -50.114  13.011 -23.090  1.00 30.19           C  
ATOM    591  CD1 ILE A  91     -49.626  12.907 -26.317  1.00 36.86           C  
ATOM    592  N   PHE A  92     -51.064  15.428 -21.193  1.00 37.00           N  
ATOM    593  CA  PHE A  92     -50.428  15.894 -19.954  1.00 38.31           C  
ATOM    594  C   PHE A  92     -50.085  14.711 -19.064  1.00 34.08           C  
ATOM    595  O   PHE A  92     -50.755  13.694 -19.149  1.00 38.47           O  
ATOM    596  CB  PHE A  92     -51.291  16.780 -19.097  1.00 42.38           C  
ATOM    597  CG  PHE A  92     -52.175  17.735 -19.809  1.00 51.28           C  
ATOM    598  CD1 PHE A  92     -51.677  18.851 -20.462  1.00 59.83           C  
ATOM    599  CD2 PHE A  92     -53.546  17.519 -19.799  1.00 55.38           C  
ATOM    600  CE1 PHE A  92     -52.542  19.727 -21.094  1.00 57.97           C  
ATOM    601  CE2 PHE A  92     -54.402  18.389 -20.419  1.00 64.07           C  
ATOM    602  CZ  PHE A  92     -53.903  19.498 -21.080  1.00 62.50           C  
ATOM    603  N   VAL A  93     -49.071  14.814 -18.215  1.00 33.09           N  
ATOM    604  CA  VAL A  93     -48.791  13.699 -17.347  1.00 32.76           C  
ATOM    605  C   VAL A  93     -48.555  14.212 -15.922  1.00 31.29           C  
ATOM    606  O   VAL A  93     -47.716  15.064 -15.685  1.00 33.45           O  
ATOM    607  CB  VAL A  93     -47.628  12.841 -17.879  1.00 38.51           C  
ATOM    608  CG1 VAL A  93     -46.856  13.582 -18.958  1.00 36.69           C  
ATOM    609  CG2 VAL A  93     -46.714  12.440 -16.738  1.00 33.74           C  
ATOM    610  N   GLN A  94     -49.351  13.638 -14.993  1.00 33.12           N  
ATOM    611  CA  GLN A  94     -49.317  13.998 -13.576  1.00 32.98           C  
ATOM    612  C   GLN A  94     -48.960  12.838 -12.688  1.00 35.22           C  
ATOM    613  O   GLN A  94     -49.100  11.669 -13.050  1.00 32.58           O  
ATOM    614  CB  GLN A  94     -50.693  14.491 -13.112  1.00 38.97           C  
ATOM    615  CG  GLN A  94     -51.194  15.766 -13.768  1.00 47.68           C  
ATOM    616  CD  GLN A  94     -52.667  16.077 -13.501  1.00 48.81           C  
ATOM    617  OE1 GLN A  94     -53.554  15.492 -14.114  1.00 53.26           O  
ATOM    618  NE2 GLN A  94     -53.146  16.951 -12.624  1.00 43.62           N  
ATOM    619  N   GLU A  95     -48.505  13.176 -11.499  1.00 38.71           N  
ATOM    620  CA  GLU A  95     -48.180  12.177 -10.531  1.00 34.09           C  
ATOM    621  C   GLU A  95     -49.427  11.666  -9.819  1.00 34.60           C  
ATOM    622  O   GLU A  95     -50.320  12.463  -9.499  1.00 37.77           O  
ATOM    623  CB  GLU A  95     -47.186  12.779  -9.535  1.00 38.22           C  
ATOM    624  CG  GLU A  95     -46.903  11.932  -8.297  1.00 50.16           C  
ATOM    625  CD  GLU A  95     -46.002  10.762  -8.582  1.00 56.36           C  
ATOM    626  OE1 GLU A  95     -46.081   9.739  -7.866  1.00 58.89           O  
ATOM    627  OE2 GLU A  95     -45.192  10.861  -9.538  1.00 53.01           O  
ATOM    628  N   VAL A  96     -49.495  10.385  -9.554  1.00 29.47           N  
ATOM    629  CA  VAL A  96     -50.497   9.820  -8.697  1.00 33.18           C  
ATOM    630  C   VAL A  96     -49.827   9.247  -7.448  1.00 38.83           C  
ATOM    631  O   VAL A  96     -49.204   8.196  -7.641  1.00 40.22           O  
ATOM    632  CB  VAL A  96     -51.188   8.677  -9.478  1.00 32.90           C  
ATOM    633  CG1 VAL A  96     -52.120   7.874  -8.605  1.00 33.94           C  
ATOM    634  CG2 VAL A  96     -51.915   9.301 -10.673  1.00 43.20           C  
ATOM    635  N   GLU A  97     -50.242   9.655  -6.269  1.00 35.57           N  
ATOM    636  CA  GLU A  97     -49.735   9.032  -5.060  1.00 44.29           C  
ATOM    637  C   GLU A  97     -50.234   7.632  -4.789  1.00 40.78           C  
ATOM    638  O   GLU A  97     -49.379   6.881  -4.317  1.00 42.88           O  
ATOM    639  CB  GLU A  97     -50.059   9.800  -3.784  1.00 39.48           C  
ATOM    640  CG  GLU A  97     -49.651  11.238  -3.726  1.00 56.99           C  
ATOM    641  CD  GLU A  97     -50.177  11.858  -2.429  1.00 63.20           C  
ATOM    642  OE1 GLU A  97     -49.985  13.079  -2.292  1.00 70.09           O  
ATOM    643  OE2 GLU A  97     -50.752  11.189  -1.538  1.00 67.88           O  
ATOM    644  N   GLN A  98     -51.501   7.278  -4.977  1.00 40.06           N  
ATOM    645  CA  GLN A  98     -51.872   5.873  -4.732  1.00 40.21           C  
ATOM    646  C   GLN A  98     -52.950   5.339  -5.631  1.00 39.06           C  
ATOM    647  O   GLN A  98     -53.745   6.119  -6.137  1.00 33.58           O  
ATOM    648  CB  GLN A  98     -52.303   5.694  -3.249  1.00 46.03           C  
ATOM    649  CG  GLN A  98     -52.506   4.219  -2.928  1.00 59.10           C  
ATOM    650  CD  GLN A  98     -51.256   3.364  -3.105  1.00 60.68           C  
ATOM    651  OE1 GLN A  98     -50.795   3.010  -4.201  1.00 56.65           O  
ATOM    652  NE2 GLN A  98     -50.680   3.004  -1.964  1.00 66.21           N  
ATOM    653  N   VAL A  99     -53.065   4.072  -5.936  1.00 39.15           N  
ATOM    654  CA  VAL A  99     -54.037   3.466  -6.828  1.00 41.30           C  
ATOM    655  C   VAL A  99     -54.496   2.209  -6.067  1.00 43.47           C  
ATOM    656  O   VAL A  99     -53.675   1.574  -5.390  1.00 39.36           O  
ATOM    657  CB  VAL A  99     -53.527   2.981  -8.201  1.00 49.29           C  
ATOM    658  CG1 VAL A  99     -54.649   2.660  -9.201  1.00 36.11           C  
ATOM    659  CG2 VAL A  99     -52.604   4.029  -8.789  1.00 42.53           C  
ATOM    660  N   ILE A 100     -55.798   2.018  -5.983  1.00 36.72           N  
ATOM    661  CA  ILE A 100     -56.455   0.991  -5.245  1.00 37.52           C  
ATOM    662  C   ILE A 100     -57.421   0.387  -6.242  1.00 38.83           C  
ATOM    663  O   ILE A 100     -58.185   1.093  -6.936  1.00 39.33           O  
ATOM    664  CB  ILE A 100     -57.060   1.493  -3.911  1.00 40.25           C  
ATOM    665  CG1 ILE A 100     -56.182   2.185  -2.904  1.00 44.65           C  
ATOM    666  CG2 ILE A 100     -57.673   0.320  -3.086  1.00 40.44           C  
ATOM    667  CD1 ILE A 100     -56.050   3.672  -2.813  1.00 34.82           C  
ATOM    668  N   ARG A 101     -57.476  -0.926  -6.372  1.00 34.35           N  
ATOM    669  CA  ARG A 101     -58.372  -1.690  -7.200  1.00 39.68           C  
ATOM    670  C   ARG A 101     -59.526  -2.192  -6.329  1.00 43.09           C  
ATOM    671  O   ARG A 101     -59.436  -2.779  -5.238  1.00 41.05           O  
ATOM    672  CB  ARG A 101     -57.588  -2.769  -7.961  1.00 46.24           C  
ATOM    673  CG  ARG A 101     -58.319  -3.980  -8.508  1.00 59.53           C  
ATOM    674  CD  ARG A 101     -57.349  -4.939  -9.228  1.00 63.53           C  
ATOM    675  NE  ARG A 101     -57.217  -4.765 -10.667  1.00 58.24           N  
ATOM    676  CZ  ARG A 101     -56.095  -4.605 -11.366  1.00 68.52           C  
ATOM    677  NH1 ARG A 101     -54.898  -4.591 -10.786  1.00 71.35           N  
ATOM    678  NH2 ARG A 101     -56.128  -4.444 -12.684  1.00 71.83           N  
ATOM    679  N   ILE A 102     -60.713  -1.658  -6.674  1.00 42.99           N  
ATOM    680  CA  ILE A 102     -61.870  -1.837  -5.761  1.00 40.63           C  
ATOM    681  C   ILE A 102     -62.181  -3.298  -5.469  1.00 38.42           C  
ATOM    682  O   ILE A 102     -62.309  -3.727  -4.326  1.00 37.96           O  
ATOM    683  CB  ILE A 102     -63.064  -1.009  -6.238  1.00 28.55           C  
ATOM    684  CG1 ILE A 102     -62.739   0.503  -5.997  1.00 28.70           C  
ATOM    685  CG2 ILE A 102     -64.308  -1.371  -5.417  1.00 29.03           C  
ATOM    686  CD1 ILE A 102     -63.808   1.390  -6.641  1.00 33.36           C  
ATOM    687  N   ARG A 103     -62.343  -4.117  -6.478  1.00 36.47           N  
ATOM    688  CA  ARG A 103     -62.646  -5.514  -6.332  1.00 41.57           C  
ATOM    689  C   ARG A 103     -61.743  -6.276  -5.374  1.00 48.88           C  
ATOM    690  O   ARG A 103     -62.288  -6.981  -4.536  1.00 47.57           O  
ATOM    691  CB  ARG A 103     -62.631  -6.169  -7.706  1.00 43.58           C  
ATOM    692  CG  ARG A 103     -62.977  -7.647  -7.624  1.00 52.05           C  
ATOM    693  CD  ARG A 103     -62.990  -8.341  -8.989  1.00 56.71           C  
ATOM    694  NE  ARG A 103     -62.961  -9.781  -8.649  1.00 72.03           N  
ATOM    695  CZ  ARG A 103     -61.762 -10.365  -8.546  1.00 71.36           C  
ATOM    696  NH1 ARG A 103     -60.674  -9.634  -8.785  1.00 82.73           N  
ATOM    697  NH2 ARG A 103     -61.694 -11.640  -8.227  1.00 70.41           N  
ATOM    698  N   THR A 104     -60.439  -6.087  -5.316  1.00 53.19           N  
ATOM    699  CA  THR A 104     -59.608  -6.931  -4.466  1.00 56.39           C  
ATOM    700  C   THR A 104     -58.996  -6.198  -3.297  1.00 62.07           C  
ATOM    701  O   THR A 104     -58.953  -6.653  -2.148  1.00 62.91           O  
ATOM    702  CB  THR A 104     -58.506  -7.531  -5.356  1.00 58.99           C  
ATOM    703  OG1 THR A 104     -57.920  -6.510  -6.165  1.00 55.76           O  
ATOM    704  CG2 THR A 104     -59.104  -8.560  -6.297  1.00 52.91           C  
ATOM    705  N   GLY A 105     -58.573  -4.962  -3.545  1.00 61.17           N  
ATOM    706  CA  GLY A 105     -57.871  -4.167  -2.531  1.00 57.36           C  
ATOM    707  C   GLY A 105     -56.379  -4.099  -2.919  1.00 55.13           C  
ATOM    708  O   GLY A 105     -55.609  -3.537  -2.145  1.00 55.16           O  
ATOM    709  N   GLU A 106     -56.005  -4.596  -4.097  1.00 54.77           N  
ATOM    710  CA  GLU A 106     -54.599  -4.427  -4.491  1.00 58.34           C  
ATOM    711  C   GLU A 106     -54.275  -2.938  -4.676  1.00 61.58           C  
ATOM    712  O   GLU A 106     -55.029  -2.092  -5.186  1.00 54.84           O  
ATOM    713  CB  GLU A 106     -54.246  -5.165  -5.755  1.00 67.48           C  
ATOM    714  CG  GLU A 106     -54.447  -6.684  -5.776  1.00 72.49           C  
ATOM    715  CD  GLU A 106     -54.369  -7.078  -7.249  1.00 79.02           C  
ATOM    716  OE1 GLU A 106     -55.430  -7.380  -7.830  1.00 80.65           O  
ATOM    717  OE2 GLU A 106     -53.252  -7.049  -7.811  1.00 84.67           O  
ATOM    718  N   THR A 107     -53.133  -2.555  -4.122  1.00 61.77           N  
ATOM    719  CA  THR A 107     -52.683  -1.169  -4.164  1.00 62.28           C  
ATOM    720  C   THR A 107     -51.411  -1.147  -5.021  1.00 68.89           C  
ATOM    721  O   THR A 107     -50.895  -2.206  -5.425  1.00 67.75           O  
ATOM    722  CB  THR A 107     -52.428  -0.617  -2.778  1.00 58.69           C  
ATOM    723  OG1 THR A 107     -51.409  -1.434  -2.179  1.00 71.20           O  
ATOM    724  CG2 THR A 107     -53.617  -0.636  -1.831  1.00 65.07           C  
ATOM    725  N   GLY A 108     -50.991   0.061  -5.380  1.00 71.64           N  
ATOM    726  CA  GLY A 108     -49.818   0.279  -6.187  1.00 74.99           C  
ATOM    727  C   GLY A 108     -49.767  -0.376  -7.546  1.00 79.15           C  
ATOM    728  O   GLY A 108     -50.711  -0.453  -8.335  1.00 75.26           O  
ATOM    729  N   PRO A 109     -48.580  -0.913  -7.873  1.00 84.35           N  
ATOM    730  CA  PRO A 109     -48.287  -1.481  -9.184  1.00 86.95           C  
ATOM    731  C   PRO A 109     -48.996  -2.791  -9.452  1.00 88.73           C  
ATOM    732  O   PRO A 109     -49.272  -3.189 -10.584  1.00 88.66           O  
ATOM    733  CB  PRO A 109     -46.774  -1.538  -9.238  1.00 88.83           C  
ATOM    734  CG  PRO A 109     -46.272  -0.750  -8.073  1.00 87.98           C  
ATOM    735  CD  PRO A 109     -47.348  -0.883  -7.030  1.00 85.83           C  
ATOM    736  N   ASP A 110     -49.506  -3.426  -8.402  1.00 90.60           N  
ATOM    737  CA  ASP A 110     -50.392  -4.574  -8.481  1.00 90.31           C  
ATOM    738  C   ASP A 110     -51.784  -4.089  -8.933  1.00 86.91           C  
ATOM    739  O   ASP A 110     -52.534  -4.829  -9.569  1.00 85.97           O  
ATOM    740  CB  ASP A 110     -50.472  -5.289  -7.139  1.00101.17           C  
ATOM    741  CG  ASP A 110     -49.244  -5.369  -6.263  1.00107.26           C  
ATOM    742  OD1 ASP A 110     -49.315  -5.930  -5.135  1.00108.76           O  
ATOM    743  OD2 ASP A 110     -48.158  -4.880  -6.641  1.00108.94           O  
ATOM    744  N   ALA A 111     -52.117  -2.821  -8.660  1.00 81.18           N  
ATOM    745  CA  ALA A 111     -53.395  -2.222  -8.965  1.00 76.92           C  
ATOM    746  C   ALA A 111     -53.464  -1.626 -10.361  1.00 77.71           C  
ATOM    747  O   ALA A 111     -54.577  -1.364 -10.823  1.00 76.44           O  
ATOM    748  CB  ALA A 111     -53.792  -1.118  -7.976  1.00 51.53           C  
ATOM    749  N   VAL A 112     -52.334  -1.493 -11.042  1.00 81.04           N  
ATOM    750  CA  VAL A 112     -52.396  -0.923 -12.392  1.00 85.47           C  
ATOM    751  C   VAL A 112     -52.622  -1.984 -13.449  1.00 86.99           C  
ATOM    752  O   VAL A 112     -53.199  -1.684 -14.517  1.00 88.00           O  
ATOM    753  CB  VAL A 112     -51.122  -0.109 -12.664  1.00 93.15           C  
ATOM    754  CG1 VAL A 112     -51.121   0.498 -14.056  1.00 92.24           C  
ATOM    755  CG2 VAL A 112     -50.967   0.970 -11.587  1.00 97.01           C  
TER     756      VAL A 112                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
