
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  971),  selected  126 , name 2rd5_D
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2rd5_D.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     5_D      M       1           -
LGA    Y     6_D      S       2           -
LGA    I     7_D      K       3           -
LGA    P     8_D      -       -           -
LGA    D     9_D      -       -           -
LGA    S    10_D      -       -           -
LGA    K    11_D      R       4          2.534
LGA    F    12_D      A       5          0.532
LGA    Y    13_D      N       6          1.126
LGA    K    14_D      K       7          0.541
LGA    V    15_D      L       8          0.726
LGA    E    16_D      V       9          0.927
LGA    A    17_D      I      10          1.150
LGA    I    18_D      V      11          0.821
LGA    V    19_D      T      12          0.143
LGA    R    20_D      E      13          0.564
LGA    P    21_D      K      14          0.390
LGA    W    22_D      V      15          0.562
LGA    R    23_D      L      16          0.510
LGA    I    24_D      L      17          1.132
LGA    Q    25_D      K      18          0.384
LGA    Q    26_D      K      19          0.701
LGA    V    27_D      V      20          1.201
LGA    S    28_D      A      21          1.073
LGA    S    29_D      K      22          0.990
LGA    A    30_D      I      23          1.987
LGA    L    31_D      I      24          2.057
LGA    L    32_D      E      25          1.568
LGA    K    33_D      E      26          1.621
LGA    I    34_D      A      27          2.124
LGA    G    35_D      G      28          1.009
LGA    I    36_D      A      29          1.567
LGA    R    37_D      T      30          3.007
LGA    G    38_D      G      31          0.673
LGA    V    39_D      Y      32          1.181
LGA    T    40_D      T      33          0.796
LGA    V    41_D      V      34          0.492
LGA    S    42_D      V      35          0.400
LGA    D    43_D      D      36          0.393
LGA    V    44_D      T      37          0.372
LGA    R    45_D      G      38          0.390
LGA    G    46_D      G      39          0.987
LGA    F    47_D      -       -           -
LGA    G    48_D      -       -           -
LGA    A    49_D      -       -           -
LGA    Q    50_D      -       -           -
LGA    G    51_D      -       -           -
LGA    G    52_D      -       -           -
LGA    S    53_D      -       -           -
LGA    T    54_D      -       -           -
LGA    E    55_D      -       -           -
LGA    R    56_D      -       -           -
LGA    H    57_D      -       -           -
LGA    G    58_D      -       -           -
LGA    G    59_D      -       -           -
LGA    S    60_D      -       -           -
LGA    E    61_D      -       -           -
LGA    F    62_D      -       -           -
LGA    S    63_D      -       -           -
LGA    E    64_D      -       -           -
LGA    D    65_D      -       -           -
LGA    K    66_D      -       -           -
LGA    F    67_D      -       -           -
LGA    V    68_D      -       -           -
LGA    A    69_D      S      58          1.266
LGA    K    70_D      N      59          0.763
LGA    V    71_D      V      60          0.542
LGA    K    72_D      K      61          0.549
LGA    M    73_D      F      62          0.660
LGA    E    74_D      E      63          0.416
LGA    I    75_D      V      64          0.549
LGA    V    76_D      L      65          0.576
LGA    V    77_D      T      66          1.027
LGA    K    78_D      E      67          2.742
LGA    K    79_D      N      68          3.270
LGA    D    80_D      R      69          2.834
LGA    Q    81_D      E      70          2.906
LGA    -       -      M      71           -
LGA    V    82_D      A      72          1.853
LGA    E    83_D      E      73          1.051
LGA    S    84_D      K      74          1.017
LGA    V    85_D      I      75          2.007
LGA    I    86_D      A      76          1.165
LGA    N    87_D      D      77          1.147
LGA    T    88_D      Q      78          2.308
LGA    I    89_D      V      79          2.270
LGA    I    90_D      A      80          1.451
LGA    E    91_D      I      81          3.455
LGA    G    92_D      K      82          4.307
LGA    A    93_D      F      83          3.284
LGA    R    94_D      F      84          2.307
LGA    T    95_D      T      85          4.218
LGA    G    96_D      D      86          2.734
LGA    E    97_D      Y      87          5.000
LGA    I    98_D      -       -           -
LGA    G    99_D      -       -           -
LGA    D   100_D      A      88          1.061
LGA    G   101_D      G      89          0.633
LGA    K   102_D      I      90          1.027
LGA    I   103_D      I      91          1.364
LGA    F   104_D      Y      92          1.866
LGA    V   105_D      I      93          0.869
LGA    L   106_D      C      94          0.393
LGA    P   107_D      E      95          0.371
LGA    V   108_D      A      96          0.432
LGA    S   109_D      E      97          1.207
LGA    D   110_D      V      98          1.577
LGA    V   111_D      L      99          4.069
LGA    I   112_D      Y     100          1.025
LGA    R   113_D      G     101          2.123
LGA    V   114_D      -       -           -
LGA    R   115_D      -       -           -
LGA    T   116_D      -       -           -
LGA    G   117_D      -       -           -
LGA    E   118_D      -       -           -
LGA    R   119_D      -       -           -
LGA    G   120_D      -       -           -
LGA    E   121_D      -       -           -
LGA    K   122_D      -       -           -
LGA    A   123_D      -       -           -
LGA    E   124_D      -       -           -
LGA    K   125_D      -       -           -
LGA    M   126_D      -       -           -
LGA    T   127_D      -       -           -
LGA    G   128_D      -       -           -
LGA    D   129_D      -       -           -
LGA    M   130_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126   83    5.0     79    1.78    18.99     86.610     4.208

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.093843 * X  +  -0.588706 * Y  +  -0.802882 * Z  +   6.183896
  Y_new =   0.129647 * X  +  -0.806800 * Y  +   0.576425 * Z  +  19.498884
  Z_new =  -0.987109 * X  +  -0.049997 * Y  +   0.152037 * Z  +  25.350109 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.317711    2.823882  [ DEG:   -18.2035    161.7965 ]
  Theta =   1.410059    1.731534  [ DEG:    80.7904     99.2096 ]
  Phi   =   2.197343   -0.944250  [ DEG:   125.8985    -54.1015 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rd5_D                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rd5_D.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126   83   5.0   79   1.78   18.99  86.610
REMARK  ---------------------------------------------------------- 
MOLECULE 2rd5_D
HEADER    PROTEIN BINDING                         21-SEP-07   2RD5              
TITLE     STRUCTURAL BASIS FOR THE REGULATION OF N-ACETYLGLUTAMATE              
TITLE    2 KINASE BY PII IN ARABIDOPSIS THALIANA                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLGLUTAMATE KINASE-LIKE PROTEIN;                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.7.2.8;                                                         
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: PII PROTEIN;                                               
COMPND   8 CHAIN: C, D;                                                         
COMPND   9 SYNONYM: P II NITROGEN SENSING PROTEIN GLB I, AT4G01900;             
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARABIDOPSIS THALIANA;                           
SOURCE   3 ORGANISM_COMMON: MOUSE-EAR CRESS;                                    
SOURCE   4 GENE: T8H10.160;                                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: ROSETTA-GAMI PLYSRARE;                     
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-3A;                                   
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: ARABIDOPSIS THALIANA;                           
SOURCE  11 ORGANISM_COMMON: MOUSE-EAR CRESS;                                    
SOURCE  12 GENE: AT4G01900, T7B11.16;                                           
SOURCE  13 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: ROSETTA-GAMI PLYSRARE;                     
SOURCE  15 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PET-3A                                    
KEYWDS    PROTEIN-PROTEIN COMPLEX, REGULATION OF ARGININE                       
KEYWDS   2 BIOSYNTHESIS, NITROGEN METABOLISM, KINASE, TRANSFERASE,              
KEYWDS   3 TRANSCRIPTION, TRANSCRIPTION REGULATION, PROTEIN BINDING             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.MIZUNO,G.B.G.MOORHEAD,K.K.S.NG                                      
REVDAT   2   18-DEC-07 2RD5    1       JRNL                                     
REVDAT   1   02-OCT-07 2RD5    0                                                
JRNL        AUTH   Y.MIZUNO,G.B.MOORHEAD,K.K.NG                                 
JRNL        TITL   STRUCTURAL BASIS FOR THE REGULATION OF                       
JRNL        TITL 2 N-ACETYLGLUTAMATE KINASE BY PII IN ARABIDOPSIS               
JRNL        TITL 3 THALIANA.                                                    
JRNL        REF    J.BIOL.CHEM.                  V. 282 35733 2007              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.51 ANGSTROMS.                                          
DBREF  2RD5 A    1   297  UNP    Q9SCL7   Q9SCL7_ARATH    51    347             
DBREF  2RD5 B    1   297  UNP    Q9SCL7   Q9SCL7_ARATH    51    347             
DBREF  2RD5 C    1   134  UNP    Q9ZST4   Q9ZST4_ARATH    63    196             
DBREF  2RD5 D    1   134  UNP    Q9ZST4   Q9ZST4_ARATH    63    196             
SEQRES   1 A  298  MET THR VAL SER THR PRO PRO SER ILE ALA THR GLY ASN          
SEQRES   2 A  298  ALA PRO SER PRO ASP TYR ARG VAL GLU ILE LEU SER GLU          
SEQRES   3 A  298  SER LEU PRO PHE ILE GLN LYS PHE ARG GLY LYS THR ILE          
SEQRES   4 A  298  VAL VAL LYS TYR GLY GLY ALA ALA MET THR SER PRO GLU          
SEQRES   5 A  298  LEU LYS SER SER VAL VAL SER ASP LEU VAL LEU LEU ALA          
SEQRES   6 A  298  CYS VAL GLY LEU ARG PRO ILE LEU VAL HIS GLY GLY GLY          
SEQRES   7 A  298  PRO ASP ILE ASN ARG TYR LEU LYS GLN LEU ASN ILE PRO          
SEQRES   8 A  298  ALA GLU PHE ARG ASP GLY LEU ARG VAL THR ASP ALA THR          
SEQRES   9 A  298  THR MET GLU ILE VAL SER MET VAL LEU VAL GLY LYS VAL          
SEQRES  10 A  298  ASN LYS ASN LEU VAL SER LEU ILE ASN ALA ALA GLY ALA          
SEQRES  11 A  298  THR ALA VAL GLY LEU SER GLY HIS ASP GLY ARG LEU LEU          
SEQRES  12 A  298  THR ALA ARG PRO VAL PRO ASN SER ALA GLN LEU GLY PHE          
SEQRES  13 A  298  VAL GLY GLU VAL ALA ARG VAL ASP PRO SER VAL LEU ARG          
SEQRES  14 A  298  PRO LEU VAL ASP TYR GLY TYR ILE PRO VAL ILE ALA SER          
SEQRES  15 A  298  VAL ALA ALA ASP ASP SER GLY GLN ALA TYR ASN ILE ASN          
SEQRES  16 A  298  ALA ASP THR VAL ALA GLY GLU LEU ALA ALA ALA LEU GLY          
SEQRES  17 A  298  ALA GLU LYS LEU ILE LEU LEU THR ASP VAL ALA GLY ILE          
SEQRES  18 A  298  LEU GLU ASN LYS GLU ASP PRO SER SER LEU ILE LYS GLU          
SEQRES  19 A  298  ILE ASP ILE LYS GLY VAL LYS LYS MET ILE GLU ASP GLY          
SEQRES  20 A  298  LYS VAL ALA GLY GLY MET ILE PRO LYS VAL LYS CYS CYS          
SEQRES  21 A  298  ILE ARG SER LEU ALA GLN GLY VAL LYS THR ALA SER ILE          
SEQRES  22 A  298  ILE ASP GLY ARG ARG GLN HIS SER LEU LEU HIS GLU ILE          
SEQRES  23 A  298  MET SER ASP GLU GLY ALA GLY THR MET ILE THR GLY              
SEQRES   1 B  298  MET THR VAL SER THR PRO PRO SER ILE ALA THR GLY ASN          
SEQRES   2 B  298  ALA PRO SER PRO ASP TYR ARG VAL GLU ILE LEU SER GLU          
SEQRES   3 B  298  SER LEU PRO PHE ILE GLN LYS PHE ARG GLY LYS THR ILE          
SEQRES   4 B  298  VAL VAL LYS TYR GLY GLY ALA ALA MET THR SER PRO GLU          
SEQRES   5 B  298  LEU LYS SER SER VAL VAL SER ASP LEU VAL LEU LEU ALA          
SEQRES   6 B  298  CYS VAL GLY LEU ARG PRO ILE LEU VAL HIS GLY GLY GLY          
SEQRES   7 B  298  PRO ASP ILE ASN ARG TYR LEU LYS GLN LEU ASN ILE PRO          
SEQRES   8 B  298  ALA GLU PHE ARG ASP GLY LEU ARG VAL THR ASP ALA THR          
SEQRES   9 B  298  THR MET GLU ILE VAL SER MET VAL LEU VAL GLY LYS VAL          
SEQRES  10 B  298  ASN LYS ASN LEU VAL SER LEU ILE ASN ALA ALA GLY ALA          
SEQRES  11 B  298  THR ALA VAL GLY LEU SER GLY HIS ASP GLY ARG LEU LEU          
SEQRES  12 B  298  THR ALA ARG PRO VAL PRO ASN SER ALA GLN LEU GLY PHE          
SEQRES  13 B  298  VAL GLY GLU VAL ALA ARG VAL ASP PRO SER VAL LEU ARG          
SEQRES  14 B  298  PRO LEU VAL ASP TYR GLY TYR ILE PRO VAL ILE ALA SER          
SEQRES  15 B  298  VAL ALA ALA ASP ASP SER GLY GLN ALA TYR ASN ILE ASN          
SEQRES  16 B  298  ALA ASP THR VAL ALA GLY GLU LEU ALA ALA ALA LEU GLY          
SEQRES  17 B  298  ALA GLU LYS LEU ILE LEU LEU THR ASP VAL ALA GLY ILE          
SEQRES  18 B  298  LEU GLU ASN LYS GLU ASP PRO SER SER LEU ILE LYS GLU          
SEQRES  19 B  298  ILE ASP ILE LYS GLY VAL LYS LYS MET ILE GLU ASP GLY          
SEQRES  20 B  298  LYS VAL ALA GLY GLY MET ILE PRO LYS VAL LYS CYS CYS          
SEQRES  21 B  298  ILE ARG SER LEU ALA GLN GLY VAL LYS THR ALA SER ILE          
SEQRES  22 B  298  ILE ASP GLY ARG ARG GLN HIS SER LEU LEU HIS GLU ILE          
SEQRES  23 B  298  MET SER ASP GLU GLY ALA GLY THR MET ILE THR GLY              
SEQRES   1 C  135  MET GLN ILE SER SER ASP TYR ILE PRO ASP SER LYS PHE          
SEQRES   2 C  135  TYR LYS VAL GLU ALA ILE VAL ARG PRO TRP ARG ILE GLN          
SEQRES   3 C  135  GLN VAL SER SER ALA LEU LEU LYS ILE GLY ILE ARG GLY          
SEQRES   4 C  135  VAL THR VAL SER ASP VAL ARG GLY PHE GLY ALA GLN GLY          
SEQRES   5 C  135  GLY SER THR GLU ARG HIS GLY GLY SER GLU PHE SER GLU          
SEQRES   6 C  135  ASP LYS PHE VAL ALA LYS VAL LYS MET GLU ILE VAL VAL          
SEQRES   7 C  135  LYS LYS ASP GLN VAL GLU SER VAL ILE ASN THR ILE ILE          
SEQRES   8 C  135  GLU GLY ALA ARG THR GLY GLU ILE GLY ASP GLY LYS ILE          
SEQRES   9 C  135  PHE VAL LEU PRO VAL SER ASP VAL ILE ARG VAL ARG THR          
SEQRES  10 C  135  GLY GLU ARG GLY GLU LYS ALA GLU LYS MET THR GLY ASP          
SEQRES  11 C  135  MET LEU SER PRO SER                                          
SEQRES   1 D  135  MET GLN ILE SER SER ASP TYR ILE PRO ASP SER LYS PHE          
SEQRES   2 D  135  TYR LYS VAL GLU ALA ILE VAL ARG PRO TRP ARG ILE GLN          
SEQRES   3 D  135  GLN VAL SER SER ALA LEU LEU LYS ILE GLY ILE ARG GLY          
SEQRES   4 D  135  VAL THR VAL SER ASP VAL ARG GLY PHE GLY ALA GLN GLY          
SEQRES   5 D  135  GLY SER THR GLU ARG HIS GLY GLY SER GLU PHE SER GLU          
SEQRES   6 D  135  ASP LYS PHE VAL ALA LYS VAL LYS MET GLU ILE VAL VAL          
SEQRES   7 D  135  LYS LYS ASP GLN VAL GLU SER VAL ILE ASN THR ILE ILE          
SEQRES   8 D  135  GLU GLY ALA ARG THR GLY GLU ILE GLY ASP GLY LYS ILE          
SEQRES   9 D  135  PHE VAL LEU PRO VAL SER ASP VAL ILE ARG VAL ARG THR          
SEQRES  10 D  135  GLY GLU ARG GLY GLU LYS ALA GLU LYS MET THR GLY ASP          
SEQRES  11 D  135  MET LEU SER PRO SER                                          
HET     MG  B2002       1                                                       
HET     MG  C1001       1                                                       
HET     MG  D1001       1                                                       
HET    ARG  A1000      12                                                       
HET    ADP  A2000      27                                                       
HET    NLG  A2001      13                                                       
HET    ARG  B1000      12                                                       
HET    ADP  B2000      27                                                       
HET    NLG  B2001      13                                                       
HET    ATP  C1000      31                                                       
HET    ATP  D1000      31                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     ARG ARGININE                                                         
HETNAM     ADP ADENOSINE-5'-DIPHOSPHATE                                         
HETNAM     NLG N-ACETYL-L-GLUTAMATE                                             
HETNAM     ATP ADENOSINE-5'-TRIPHOSPHATE                                        
FORMUL   5   MG    3(MG 2+)                                                     
FORMUL   8  ARG    2(C6 H15 N4 O2 1+)                                           
FORMUL   9  ADP    2(C10 H15 N5 O10 P2)                                         
FORMUL  10  NLG    2(C7 H11 N O5)                                               
FORMUL  14  ATP    2(C10 H16 N5 O13 P3)                                         
FORMUL  16  HOH   *64(H2 O)                                                     
CRYST1  171.133  171.133  171.133  90.00  90.00  90.00 P 21 3       24          
ATOM   5128  N   ASP D   5     -36.104  12.907 -14.743  1.00 87.91           N  
ATOM   5129  CA  ASP D   5     -37.332  12.403 -14.060  1.00 89.47           C  
ATOM   5130  C   ASP D   5     -38.432  13.455 -14.011  1.00 87.99           C  
ATOM   5131  O   ASP D   5     -38.152  14.656 -14.041  1.00 88.66           O  
ATOM   5132  CB  ASP D   5     -37.000  11.943 -12.638  1.00 89.81           C  
ATOM   5133  CG  ASP D   5     -36.323  10.586 -12.606  1.00 92.76           C  
ATOM   5134  OD1 ASP D   5     -36.899   9.617 -13.151  1.00 93.20           O  
ATOM   5135  OD2 ASP D   5     -35.220  10.487 -12.024  1.00 91.86           O  
ATOM   5136  N   TYR D   6     -39.679  12.996 -13.936  1.00 86.52           N  
ATOM   5137  CA  TYR D   6     -40.824  13.886 -13.755  1.00 85.52           C  
ATOM   5138  C   TYR D   6     -40.733  14.498 -12.359  1.00 84.23           C  
ATOM   5139  O   TYR D   6     -40.607  13.776 -11.366  1.00 82.99           O  
ATOM   5140  CB  TYR D   6     -42.140  13.133 -13.989  1.00 85.93           C  
ATOM   5141  CG  TYR D   6     -42.236  12.550 -15.387  1.00 87.40           C  
ATOM   5142  CD1 TYR D   6     -42.698  13.322 -16.458  1.00 88.64           C  
ATOM   5143  CD2 TYR D   6     -41.839  11.236 -15.645  1.00 88.10           C  
ATOM   5144  CE1 TYR D   6     -42.773  12.793 -17.753  1.00 88.68           C  
ATOM   5145  CE2 TYR D   6     -41.906  10.700 -16.932  1.00 88.78           C  
ATOM   5146  CZ  TYR D   6     -42.373  11.482 -17.980  1.00 90.63           C  
ATOM   5147  OH  TYR D   6     -42.440  10.950 -19.252  1.00 90.43           O  
ATOM   5148  N   ILE D   7     -40.770  15.830 -12.304  1.00 83.53           N  
ATOM   5149  CA  ILE D   7     -40.309  16.583 -11.122  1.00 83.17           C  
ATOM   5150  C   ILE D   7     -41.049  16.273  -9.809  1.00 81.02           C  
ATOM   5151  O   ILE D   7     -40.387  16.004  -8.795  1.00 83.93           O  
ATOM   5152  CB  ILE D   7     -40.162  18.121 -11.398  1.00 84.30           C  
ATOM   5153  CG1 ILE D   7     -38.919  18.407 -12.264  1.00 86.21           C  
ATOM   5154  CG2 ILE D   7     -40.143  18.939 -10.094  1.00 83.04           C  
ATOM   5155  CD1 ILE D   7     -37.555  18.044 -11.628  1.00 88.85           C  
ATOM   5156  N   PRO D   8     -42.402  16.317  -9.804  1.00 75.25           N  
ATOM   5157  CA  PRO D   8     -43.032  15.681  -8.647  1.00 71.86           C  
ATOM   5158  C   PRO D   8     -42.922  14.169  -8.823  1.00 70.82           C  
ATOM   5159  O   PRO D   8     -43.586  13.589  -9.686  1.00 71.74           O  
ATOM   5160  CB  PRO D   8     -44.487  16.168  -8.701  1.00 69.58           C  
ATOM   5161  CG  PRO D   8     -44.534  17.203  -9.792  1.00 70.97           C  
ATOM   5162  CD  PRO D   8     -43.395  16.913 -10.711  1.00 71.98           C  
ATOM   5163  N   ASP D   9     -42.042  13.555  -8.038  1.00 71.27           N  
ATOM   5164  CA  ASP D   9     -41.731  12.131  -8.160  1.00 70.25           C  
ATOM   5165  C   ASP D   9     -42.854  11.293  -7.572  1.00 69.04           C  
ATOM   5166  O   ASP D   9     -43.421  11.644  -6.534  1.00 68.71           O  
ATOM   5167  CB  ASP D   9     -40.398  11.803  -7.469  1.00 70.65           C  
ATOM   5168  CG  ASP D   9     -39.876  10.412  -7.818  1.00 72.21           C  
ATOM   5169  OD1 ASP D   9     -40.055   9.966  -8.974  1.00 70.55           O  
ATOM   5170  OD2 ASP D   9     -39.275   9.764  -6.932  1.00 74.43           O  
ATOM   5171  N   SER D  10     -43.170  10.189  -8.243  1.00 67.58           N  
ATOM   5172  CA  SER D  10     -44.297   9.348  -7.859  1.00 66.51           C  
ATOM   5173  C   SER D  10     -44.188   7.957  -8.470  1.00 64.48           C  
ATOM   5174  O   SER D  10     -43.539   7.772  -9.497  1.00 63.42           O  
ATOM   5175  CB  SER D  10     -45.610  10.010  -8.288  1.00 67.39           C  
ATOM   5176  OG  SER D  10     -46.728   9.333  -7.747  1.00 71.40           O  
ATOM   5177  N   LYS D  11     -44.832   6.986  -7.833  1.00 65.46           N  
ATOM   5178  CA  LYS D  11     -44.856   5.610  -8.329  1.00 68.32           C  
ATOM   5179  C   LYS D  11     -45.744   5.462  -9.575  1.00 68.98           C  
ATOM   5180  O   LYS D  11     -45.479   4.615 -10.434  1.00 68.95           O  
ATOM   5181  CB  LYS D  11     -45.314   4.660  -7.216  1.00 70.51           C  
ATOM   5182  CG  LYS D  11     -44.917   3.207  -7.421  1.00 74.78           C  
ATOM   5183  CD  LYS D  11     -44.753   2.492  -6.088  1.00 84.48           C  
ATOM   5184  CE  LYS D  11     -43.951   1.208  -6.256  1.00 88.38           C  
ATOM   5185  NZ  LYS D  11     -43.334   0.762  -4.980  1.00 87.23           N  
ATOM   5186  N   PHE D  12     -46.786   6.294  -9.663  1.00 67.39           N  
ATOM   5187  CA  PHE D  12     -47.723   6.280 -10.788  1.00 66.20           C  
ATOM   5188  C   PHE D  12     -47.949   7.684 -11.336  1.00 67.40           C  
ATOM   5189  O   PHE D  12     -47.782   8.678 -10.620  1.00 69.28           O  
ATOM   5190  CB  PHE D  12     -49.074   5.687 -10.367  1.00 65.68           C  
ATOM   5191  CG  PHE D  12     -48.971   4.355  -9.688  1.00 66.05           C  
ATOM   5192  CD1 PHE D  12     -48.803   3.190 -10.432  1.00 67.92           C  
ATOM   5193  CD2 PHE D  12     -49.038   4.262  -8.301  1.00 63.84           C  
ATOM   5194  CE1 PHE D  12     -48.699   1.952  -9.804  1.00 69.76           C  
ATOM   5195  CE2 PHE D  12     -48.940   3.029  -7.663  1.00 65.83           C  
ATOM   5196  CZ  PHE D  12     -48.769   1.871  -8.416  1.00 66.17           C  
ATOM   5197  N   TYR D  13     -48.323   7.759 -12.608  1.00 65.55           N  
ATOM   5198  CA  TYR D  13     -48.755   9.017 -13.209  1.00 65.37           C  
ATOM   5199  C   TYR D  13     -50.013   8.799 -14.025  1.00 64.89           C  
ATOM   5200  O   TYR D  13     -50.215   7.711 -14.577  1.00 63.76           O  
ATOM   5201  CB  TYR D  13     -47.665   9.616 -14.098  1.00 62.55           C  
ATOM   5202  CG  TYR D  13     -46.463  10.101 -13.333  1.00 64.33           C  
ATOM   5203  CD1 TYR D  13     -46.414  11.400 -12.828  1.00 59.99           C  
ATOM   5204  CD2 TYR D  13     -45.368   9.261 -13.110  1.00 60.76           C  
ATOM   5205  CE1 TYR D  13     -45.310  11.852 -12.120  1.00 59.94           C  
ATOM   5206  CE2 TYR D  13     -44.256   9.705 -12.403  1.00 59.61           C  
ATOM   5207  CZ  TYR D  13     -44.234  10.999 -11.910  1.00 61.37           C  
ATOM   5208  OH  TYR D  13     -43.139  11.441 -11.205  1.00 61.31           O  
ATOM   5209  N   LYS D  14     -50.859   9.826 -14.074  1.00 64.02           N  
ATOM   5210  CA  LYS D  14     -52.000   9.848 -14.983  1.00 66.15           C  
ATOM   5211  C   LYS D  14     -51.629  10.637 -16.237  1.00 67.57           C  
ATOM   5212  O   LYS D  14     -51.219  11.802 -16.149  1.00 69.32           O  
ATOM   5213  CB  LYS D  14     -53.227  10.475 -14.319  1.00 65.13           C  
ATOM   5214  CG  LYS D  14     -54.426  10.580 -15.249  1.00 65.28           C  
ATOM   5215  CD  LYS D  14     -55.352  11.721 -14.879  1.00 65.70           C  
ATOM   5216  CE  LYS D  14     -56.444  11.287 -13.926  1.00 63.23           C  
ATOM   5217  NZ  LYS D  14     -57.352  12.444 -13.639  1.00 63.29           N  
ATOM   5218  N   VAL D  15     -51.755   9.986 -17.392  1.00 67.83           N  
ATOM   5219  CA  VAL D  15     -51.608  10.648 -18.684  1.00 65.43           C  
ATOM   5220  C   VAL D  15     -52.987  11.116 -19.135  1.00 67.85           C  
ATOM   5221  O   VAL D  15     -53.891  10.307 -19.355  1.00 66.84           O  
ATOM   5222  CB  VAL D  15     -50.976   9.715 -19.739  1.00 66.13           C  
ATOM   5223  CG1 VAL D  15     -50.900  10.404 -21.095  1.00 62.33           C  
ATOM   5224  CG2 VAL D  15     -49.582   9.266 -19.295  1.00 63.58           C  
ATOM   5225  N   GLU D  16     -53.143  12.431 -19.247  1.00 68.88           N  
ATOM   5226  CA  GLU D  16     -54.418  13.047 -19.595  1.00 68.99           C  
ATOM   5227  C   GLU D  16     -54.296  13.709 -20.965  1.00 67.51           C  
ATOM   5228  O   GLU D  16     -53.570  14.690 -21.124  1.00 70.13           O  
ATOM   5229  CB  GLU D  16     -54.804  14.067 -18.522  1.00 68.14           C  
ATOM   5230  CG  GLU D  16     -56.225  14.583 -18.609  1.00 71.31           C  
ATOM   5231  CD  GLU D  16     -56.580  15.547 -17.479  1.00 74.75           C  
ATOM   5232  OE1 GLU D  16     -55.885  15.553 -16.441  1.00 74.37           O  
ATOM   5233  OE2 GLU D  16     -57.566  16.301 -17.630  1.00 85.59           O  
ATOM   5234  N   ALA D  17     -54.993  13.154 -21.952  1.00 65.10           N  
ATOM   5235  CA  ALA D  17     -54.889  13.619 -23.328  1.00 62.43           C  
ATOM   5236  C   ALA D  17     -56.224  14.144 -23.834  1.00 62.48           C  
ATOM   5237  O   ALA D  17     -57.219  13.429 -23.841  1.00 64.58           O  
ATOM   5238  CB  ALA D  17     -54.388  12.494 -24.223  1.00 61.31           C  
ATOM   5239  N   ILE D  18     -56.246  15.403 -24.248  1.00 63.68           N  
ATOM   5240  CA  ILE D  18     -57.436  15.984 -24.855  1.00 62.77           C  
ATOM   5241  C   ILE D  18     -57.190  15.977 -26.359  1.00 63.59           C  
ATOM   5242  O   ILE D  18     -56.278  16.652 -26.831  1.00 66.51           O  
ATOM   5243  CB  ILE D  18     -57.677  17.429 -24.367  1.00 61.64           C  
ATOM   5244  CG1 ILE D  18     -57.334  17.587 -22.873  1.00 60.90           C  
ATOM   5245  CG2 ILE D  18     -59.089  17.885 -24.704  1.00 60.81           C  
ATOM   5246  CD1 ILE D  18     -58.376  17.083 -21.908  1.00 69.09           C  
ATOM   5247  N   VAL D  19     -57.971  15.192 -27.101  1.00 62.53           N  
ATOM   5248  CA  VAL D  19     -57.741  15.000 -28.540  1.00 60.91           C  
ATOM   5249  C   VAL D  19     -59.041  15.076 -29.349  1.00 61.93           C  
ATOM   5250  O   VAL D  19     -60.120  15.285 -28.785  1.00 61.14           O  
ATOM   5251  CB  VAL D  19     -57.015  13.646 -28.845  1.00 62.53           C  
ATOM   5252  CG1 VAL D  19     -55.637  13.595 -28.194  1.00 58.11           C  
ATOM   5253  CG2 VAL D  19     -57.861  12.458 -28.398  1.00 61.95           C  
ATOM   5254  N   ARG D  20     -58.926  14.912 -30.668  1.00 59.90           N  
ATOM   5255  CA  ARG D  20     -60.086  14.878 -31.552  1.00 61.19           C  
ATOM   5256  C   ARG D  20     -60.910  13.618 -31.270  1.00 60.66           C  
ATOM   5257  O   ARG D  20     -60.343  12.542 -31.052  1.00 59.11           O  
ATOM   5258  CB  ARG D  20     -59.657  14.910 -33.024  1.00 59.23           C  
ATOM   5259  CG  ARG D  20     -58.916  16.164 -33.450  1.00 61.83           C  
ATOM   5260  CD  ARG D  20     -58.255  15.974 -34.822  1.00 64.62           C  
ATOM   5261  NE  ARG D  20     -57.244  16.996 -35.098  1.00 67.51           N  
ATOM   5262  CZ  ARG D  20     -57.528  18.242 -35.468  1.00 66.19           C  
ATOM   5263  NH1 ARG D  20     -58.791  18.620 -35.604  1.00 55.28           N  
ATOM   5264  NH2 ARG D  20     -56.552  19.114 -35.692  1.00 61.96           N  
ATOM   5265  N   PRO D  21     -62.247  13.752 -31.255  1.00 60.41           N  
ATOM   5266  CA  PRO D  21     -63.137  12.623 -30.951  1.00 61.87           C  
ATOM   5267  C   PRO D  21     -63.051  11.434 -31.909  1.00 63.08           C  
ATOM   5268  O   PRO D  21     -63.251  10.297 -31.483  1.00 66.62           O  
ATOM   5269  CB  PRO D  21     -64.538  13.251 -30.992  1.00 59.21           C  
ATOM   5270  CG  PRO D  21     -64.304  14.719 -30.770  1.00 61.07           C  
ATOM   5271  CD  PRO D  21     -63.003  14.998 -31.471  1.00 60.48           C  
ATOM   5272  N   TRP D  22     -62.748  11.675 -33.179  1.00 65.62           N  
ATOM   5273  CA  TRP D  22     -62.801  10.598 -34.174  1.00 68.14           C  
ATOM   5274  C   TRP D  22     -61.535   9.747 -34.191  1.00 68.27           C  
ATOM   5275  O   TRP D  22     -61.425   8.801 -34.973  1.00 68.01           O  
ATOM   5276  CB  TRP D  22     -63.100  11.149 -35.573  1.00 69.62           C  
ATOM   5277  CG  TRP D  22     -62.476  12.462 -35.811  1.00 71.47           C  
ATOM   5278  CD1 TRP D  22     -61.250  12.700 -36.354  1.00 72.34           C  
ATOM   5279  CD2 TRP D  22     -63.037  13.742 -35.492  1.00 77.19           C  
ATOM   5280  NE1 TRP D  22     -61.011  14.055 -36.401  1.00 77.33           N  
ATOM   5281  CE2 TRP D  22     -62.092  14.719 -35.877  1.00 76.47           C  
ATOM   5282  CE3 TRP D  22     -64.253  14.161 -34.921  1.00 78.14           C  
ATOM   5283  CZ2 TRP D  22     -62.317  16.095 -35.707  1.00 73.32           C  
ATOM   5284  CZ3 TRP D  22     -64.480  15.523 -34.756  1.00 74.22           C  
ATOM   5285  CH2 TRP D  22     -63.510  16.474 -35.146  1.00 73.32           C  
ATOM   5286  N   ARG D  23     -60.597  10.083 -33.314  1.00 68.89           N  
ATOM   5287  CA  ARG D  23     -59.323   9.381 -33.224  1.00 70.62           C  
ATOM   5288  C   ARG D  23     -59.250   8.384 -32.058  1.00 69.75           C  
ATOM   5289  O   ARG D  23     -58.299   7.613 -31.954  1.00 70.51           O  
ATOM   5290  CB  ARG D  23     -58.181  10.400 -33.135  1.00 71.26           C  
ATOM   5291  CG  ARG D  23     -57.845  11.089 -34.458  1.00 74.45           C  
ATOM   5292  CD  ARG D  23     -57.360  10.083 -35.503  1.00 79.39           C  
ATOM   5293  NE  ARG D  23     -56.387  10.659 -36.427  1.00 83.62           N  
ATOM   5294  CZ  ARG D  23     -55.657   9.955 -37.291  1.00 88.29           C  
ATOM   5295  NH1 ARG D  23     -55.789   8.636 -37.366  1.00 92.10           N  
ATOM   5296  NH2 ARG D  23     -54.791  10.571 -38.087  1.00 90.99           N  
ATOM   5297  N   ILE D  24     -60.266   8.403 -31.199  1.00 69.35           N  
ATOM   5298  CA  ILE D  24     -60.293   7.599 -29.974  1.00 68.41           C  
ATOM   5299  C   ILE D  24     -60.156   6.092 -30.206  1.00 67.94           C  
ATOM   5300  O   ILE D  24     -59.410   5.419 -29.490  1.00 69.56           O  
ATOM   5301  CB  ILE D  24     -61.557   7.916 -29.121  1.00 68.82           C  
ATOM   5302  CG1 ILE D  24     -61.503   9.360 -28.607  1.00 69.13           C  
ATOM   5303  CG2 ILE D  24     -61.713   6.939 -27.954  1.00 66.25           C  
ATOM   5304  CD1 ILE D  24     -60.190   9.739 -27.923  1.00 74.25           C  
ATOM   5305  N   GLN D  25     -60.870   5.572 -31.198  1.00 67.46           N  
ATOM   5306  CA  GLN D  25     -60.839   4.148 -31.516  1.00 70.82           C  
ATOM   5307  C   GLN D  25     -59.419   3.703 -31.887  1.00 70.21           C  
ATOM   5308  O   GLN D  25     -58.946   2.677 -31.393  1.00 71.10           O  
ATOM   5309  CB  GLN D  25     -61.823   3.840 -32.650  1.00 70.33           C  
ATOM   5310  CG  GLN D  25     -62.127   2.358 -32.874  1.00 76.46           C  
ATOM   5311  CD  GLN D  25     -63.205   2.125 -33.949  1.00 80.00           C  
ATOM   5312  OE1 GLN D  25     -63.084   1.219 -34.775  1.00 85.71           O  
ATOM   5313  NE2 GLN D  25     -64.258   2.943 -33.933  1.00 82.42           N  
ATOM   5314  N   GLN D  26     -58.750   4.488 -32.735  1.00 70.31           N  
ATOM   5315  CA  GLN D  26     -57.391   4.181 -33.204  1.00 72.08           C  
ATOM   5316  C   GLN D  26     -56.342   4.241 -32.088  1.00 70.05           C  
ATOM   5317  O   GLN D  26     -55.480   3.361 -31.997  1.00 68.36           O  
ATOM   5318  CB  GLN D  26     -56.985   5.092 -34.372  1.00 69.78           C  
ATOM   5319  CG  GLN D  26     -57.387   4.569 -35.751  1.00 76.53           C  
ATOM   5320  CD  GLN D  26     -57.397   5.657 -36.832  1.00 80.14           C  
ATOM   5321  OE1 GLN D  26     -57.996   6.725 -36.658  1.00 84.59           O  
ATOM   5322  NE2 GLN D  26     -56.744   5.378 -37.958  1.00 84.70           N  
ATOM   5323  N   VAL D  27     -56.417   5.278 -31.252  1.00 67.28           N  
ATOM   5324  CA  VAL D  27     -55.490   5.424 -30.125  1.00 66.78           C  
ATOM   5325  C   VAL D  27     -55.704   4.282 -29.125  1.00 65.81           C  
ATOM   5326  O   VAL D  27     -54.742   3.684 -28.654  1.00 64.84           O  
ATOM   5327  CB  VAL D  27     -55.609   6.817 -29.425  1.00 66.64           C  
ATOM   5328  CG1 VAL D  27     -54.695   6.902 -28.215  1.00 63.53           C  
ATOM   5329  CG2 VAL D  27     -55.277   7.939 -30.394  1.00 65.78           C  
ATOM   5330  N   SER D  28     -56.967   3.972 -28.833  1.00 65.92           N  
ATOM   5331  CA  SER D  28     -57.310   2.888 -27.914  1.00 66.38           C  
ATOM   5332  C   SER D  28     -56.794   1.541 -28.403  1.00 65.25           C  
ATOM   5333  O   SER D  28     -56.296   0.737 -27.618  1.00 67.23           O  
ATOM   5334  CB  SER D  28     -58.817   2.820 -27.697  1.00 65.48           C  
ATOM   5335  OG  SER D  28     -59.264   3.983 -27.035  1.00 68.69           O  
ATOM   5336  N   SER D  29     -56.918   1.312 -29.705  1.00 64.46           N  
ATOM   5337  CA  SER D  29     -56.474   0.081 -30.333  1.00 63.66           C  
ATOM   5338  C   SER D  29     -54.955  -0.062 -30.223  1.00 63.93           C  
ATOM   5339  O   SER D  29     -54.442  -1.134 -29.883  1.00 62.92           O  
ATOM   5340  CB  SER D  29     -56.904   0.076 -31.799  1.00 62.44           C  
ATOM   5341  OG  SER D  29     -56.655  -1.179 -32.397  1.00 70.96           O  
ATOM   5342  N   ALA D  30     -54.251   1.034 -30.497  1.00 63.98           N  
ATOM   5343  CA  ALA D  30     -52.794   1.069 -30.474  1.00 63.81           C  
ATOM   5344  C   ALA D  30     -52.235   0.925 -29.054  1.00 64.09           C  
ATOM   5345  O   ALA D  30     -51.190   0.300 -28.853  1.00 64.06           O  
ATOM   5346  CB  ALA D  30     -52.291   2.351 -31.130  1.00 62.51           C  
ATOM   5347  N   LEU D  31     -52.934   1.506 -28.080  1.00 63.60           N  
ATOM   5348  CA  LEU D  31     -52.565   1.387 -26.671  1.00 63.58           C  
ATOM   5349  C   LEU D  31     -52.714  -0.050 -26.186  1.00 64.49           C  
ATOM   5350  O   LEU D  31     -51.895  -0.547 -25.412  1.00 64.48           O  
ATOM   5351  CB  LEU D  31     -53.429   2.314 -25.815  1.00 62.40           C  
ATOM   5352  CG  LEU D  31     -53.051   3.795 -25.766  1.00 61.28           C  
ATOM   5353  CD1 LEU D  31     -54.208   4.601 -25.181  1.00 59.21           C  
ATOM   5354  CD2 LEU D  31     -51.759   4.016 -24.970  1.00 56.22           C  
ATOM   5355  N   LEU D  32     -53.768  -0.708 -26.653  1.00 64.68           N  
ATOM   5356  CA  LEU D  32     -54.039  -2.094 -26.321  1.00 66.13           C  
ATOM   5357  C   LEU D  32     -52.887  -2.983 -26.809  1.00 66.46           C  
ATOM   5358  O   LEU D  32     -52.496  -3.926 -26.125  1.00 64.08           O  
ATOM   5359  CB  LEU D  32     -55.381  -2.501 -26.942  1.00 67.91           C  
ATOM   5360  CG  LEU D  32     -56.286  -3.636 -26.429  1.00 70.14           C  
ATOM   5361  CD1 LEU D  32     -56.576  -4.665 -27.528  1.00 70.41           C  
ATOM   5362  CD2 LEU D  32     -55.769  -4.296 -25.150  1.00 71.40           C  
ATOM   5363  N   LYS D  33     -52.327  -2.639 -27.969  1.00 67.10           N  
ATOM   5364  CA  LYS D  33     -51.247  -3.405 -28.589  1.00 69.81           C  
ATOM   5365  C   LYS D  33     -49.943  -3.420 -27.784  1.00 69.13           C  
ATOM   5366  O   LYS D  33     -49.230  -4.423 -27.786  1.00 65.32           O  
ATOM   5367  CB  LYS D  33     -50.984  -2.924 -30.020  1.00 70.20           C  
ATOM   5368  CG  LYS D  33     -51.921  -3.527 -31.057  1.00 74.46           C  
ATOM   5369  CD  LYS D  33     -51.506  -3.148 -32.479  1.00 75.50           C  
ATOM   5370  CE  LYS D  33     -52.470  -3.712 -33.525  1.00 82.19           C  
ATOM   5371  NZ  LYS D  33     -53.815  -3.059 -33.498  1.00 81.31           N  
ATOM   5372  N   ILE D  34     -49.640  -2.313 -27.104  1.00 68.46           N  
ATOM   5373  CA  ILE D  34     -48.433  -2.225 -26.269  1.00 66.19           C  
ATOM   5374  C   ILE D  34     -48.687  -2.562 -24.793  1.00 65.16           C  
ATOM   5375  O   ILE D  34     -47.831  -2.329 -23.938  1.00 66.49           O  
ATOM   5376  CB  ILE D  34     -47.716  -0.849 -26.396  1.00 66.43           C  
ATOM   5377  CG1 ILE D  34     -48.676   0.302 -26.065  1.00 68.47           C  
ATOM   5378  CG2 ILE D  34     -47.091  -0.701 -27.784  1.00 65.44           C  
ATOM   5379  CD1 ILE D  34     -48.008   1.527 -25.475  1.00 71.25           C  
ATOM   5380  N   GLY D  35     -49.863  -3.107 -24.501  1.00 64.24           N  
ATOM   5381  CA  GLY D  35     -50.169  -3.601 -23.163  1.00 63.43           C  
ATOM   5382  C   GLY D  35     -50.842  -2.614 -22.229  1.00 64.72           C  
ATOM   5383  O   GLY D  35     -50.875  -2.832 -21.017  1.00 66.58           O  
ATOM   5384  N   ILE D  36     -51.372  -1.525 -22.777  1.00 64.22           N  
ATOM   5385  CA  ILE D  36     -52.129  -0.568 -21.974  1.00 63.30           C  
ATOM   5386  C   ILE D  36     -53.591  -0.995 -22.010  1.00 62.90           C  
ATOM   5387  O   ILE D  36     -54.255  -0.896 -23.050  1.00 61.61           O  
ATOM   5388  CB  ILE D  36     -51.947   0.894 -22.473  1.00 65.20           C  
ATOM   5389  CG1 ILE D  36     -50.460   1.293 -22.512  1.00 66.74           C  
ATOM   5390  CG2 ILE D  36     -52.766   1.861 -21.626  1.00 64.55           C  
ATOM   5391  CD1 ILE D  36     -49.681   1.053 -21.209  1.00 67.13           C  
ATOM   5392  N   ARG D  37     -54.082  -1.486 -20.876  1.00 62.14           N  
ATOM   5393  CA  ARG D  37     -55.374  -2.177 -20.839  1.00 63.42           C  
ATOM   5394  C   ARG D  37     -56.428  -1.492 -19.957  1.00 64.00           C  
ATOM   5395  O   ARG D  37     -57.566  -1.970 -19.854  1.00 66.08           O  
ATOM   5396  CB  ARG D  37     -55.186  -3.658 -20.465  1.00 61.51           C  
ATOM   5397  CG  ARG D  37     -54.114  -4.370 -21.308  1.00 67.83           C  
ATOM   5398  CD  ARG D  37     -53.927  -5.854 -20.964  1.00 65.84           C  
ATOM   5399  NE  ARG D  37     -55.004  -6.685 -21.505  1.00 76.36           N  
ATOM   5400  CZ  ARG D  37     -55.085  -7.111 -22.765  1.00 74.25           C  
ATOM   5401  NH1 ARG D  37     -54.148  -6.799 -23.653  1.00 78.93           N  
ATOM   5402  NH2 ARG D  37     -56.114  -7.856 -23.137  1.00 75.46           N  
ATOM   5403  N   GLY D  38     -56.047  -0.369 -19.345  1.00 62.79           N  
ATOM   5404  CA  GLY D  38     -56.970   0.473 -18.580  1.00 62.43           C  
ATOM   5405  C   GLY D  38     -57.011   1.896 -19.115  1.00 64.24           C  
ATOM   5406  O   GLY D  38     -56.014   2.620 -19.049  1.00 66.23           O  
ATOM   5407  N   VAL D  39     -58.169   2.296 -19.641  1.00 61.20           N  
ATOM   5408  CA  VAL D  39     -58.345   3.582 -20.318  1.00 59.34           C  
ATOM   5409  C   VAL D  39     -59.717   4.169 -19.981  1.00 59.83           C  
ATOM   5410  O   VAL D  39     -60.723   3.457 -19.995  1.00 60.82           O  
ATOM   5411  CB  VAL D  39     -58.215   3.425 -21.876  1.00 60.98           C  
ATOM   5412  CG1 VAL D  39     -58.497   4.735 -22.601  1.00 56.31           C  
ATOM   5413  CG2 VAL D  39     -56.832   2.906 -22.266  1.00 62.57           C  
ATOM   5414  N   THR D  40     -59.756   5.464 -19.678  1.00 59.72           N  
ATOM   5415  CA  THR D  40     -61.016   6.165 -19.437  1.00 59.13           C  
ATOM   5416  C   THR D  40     -61.138   7.346 -20.402  1.00 60.89           C  
ATOM   5417  O   THR D  40     -60.186   8.108 -20.578  1.00 65.42           O  
ATOM   5418  CB  THR D  40     -61.113   6.666 -17.976  1.00 59.15           C  
ATOM   5419  OG1 THR D  40     -60.954   5.563 -17.077  1.00 59.22           O  
ATOM   5420  CG2 THR D  40     -62.466   7.337 -17.707  1.00 58.30           C  
ATOM   5421  N   VAL D  41     -62.302   7.491 -21.027  1.00 58.94           N  
ATOM   5422  CA  VAL D  41     -62.564   8.617 -21.917  1.00 59.90           C  
ATOM   5423  C   VAL D  41     -63.862   9.316 -21.526  1.00 62.43           C  
ATOM   5424  O   VAL D  41     -64.754   8.704 -20.929  1.00 61.39           O  
ATOM   5425  CB  VAL D  41     -62.597   8.215 -23.441  1.00 60.36           C  
ATOM   5426  CG1 VAL D  41     -61.268   7.626 -23.894  1.00 58.16           C  
ATOM   5427  CG2 VAL D  41     -63.730   7.254 -23.745  1.00 57.42           C  
ATOM   5428  N   SER D  42     -63.952  10.602 -21.860  1.00 63.99           N  
ATOM   5429  CA  SER D  42     -65.165  11.391 -21.648  1.00 65.77           C  
ATOM   5430  C   SER D  42     -65.251  12.531 -22.654  1.00 66.37           C  
ATOM   5431  O   SER D  42     -64.228  13.010 -23.150  1.00 69.59           O  
ATOM   5432  CB  SER D  42     -65.226  11.939 -20.219  1.00 65.70           C  
ATOM   5433  OG  SER D  42     -64.017  12.580 -19.858  1.00 70.41           O  
ATOM   5434  N   ASP D  43     -66.475  12.952 -22.958  1.00 68.04           N  
ATOM   5435  CA  ASP D  43     -66.708  14.058 -23.882  1.00 68.98           C  
ATOM   5436  C   ASP D  43     -66.462  15.389 -23.189  1.00 68.81           C  
ATOM   5437  O   ASP D  43     -66.975  15.632 -22.092  1.00 70.90           O  
ATOM   5438  CB  ASP D  43     -68.130  14.005 -24.445  1.00 67.99           C  
ATOM   5439  CG  ASP D  43     -68.379  12.764 -25.296  1.00 69.56           C  
ATOM   5440  OD1 ASP D  43     -67.516  12.410 -26.125  1.00 71.39           O  
ATOM   5441  OD2 ASP D  43     -69.441  12.135 -25.131  1.00 78.50           O  
ATOM   5442  N   VAL D  44     -65.661  16.238 -23.827  1.00 65.77           N  
ATOM   5443  CA  VAL D  44     -65.380  17.575 -23.312  1.00 64.28           C  
ATOM   5444  C   VAL D  44     -65.481  18.634 -24.407  1.00 64.43           C  
ATOM   5445  O   VAL D  44     -65.575  18.317 -25.597  1.00 64.45           O  
ATOM   5446  CB  VAL D  44     -63.978  17.672 -22.628  1.00 64.17           C  
ATOM   5447  CG1 VAL D  44     -63.899  16.774 -21.393  1.00 64.82           C  
ATOM   5448  CG2 VAL D  44     -62.858  17.347 -23.608  1.00 56.04           C  
ATOM   5449  N   ARG D  45     -65.462  19.893 -23.986  1.00 65.06           N  
ATOM   5450  CA  ARG D  45     -65.338  21.027 -24.896  1.00 65.38           C  
ATOM   5451  C   ARG D  45     -64.079  21.791 -24.507  1.00 64.41           C  
ATOM   5452  O   ARG D  45     -63.697  21.817 -23.334  1.00 63.45           O  
ATOM   5453  CB  ARG D  45     -66.550  21.954 -24.781  1.00 66.25           C  
ATOM   5454  CG  ARG D  45     -67.878  21.388 -25.281  1.00 71.95           C  
ATOM   5455  CD  ARG D  45     -69.035  22.223 -24.730  1.00 80.94           C  
ATOM   5456  NE  ARG D  45     -69.389  21.807 -23.371  1.00 88.24           N  
ATOM   5457  CZ  ARG D  45     -69.781  22.625 -22.397  1.00 88.25           C  
ATOM   5458  NH1 ARG D  45     -69.864  23.938 -22.604  1.00 88.14           N  
ATOM   5459  NH2 ARG D  45     -70.076  22.126 -21.205  1.00 85.18           N  
ATOM   5460  N   GLY D  46     -63.433  22.414 -25.482  1.00 63.08           N  
ATOM   5461  CA  GLY D  46     -62.247  23.196 -25.190  1.00 60.16           C  
ATOM   5462  C   GLY D  46     -61.870  24.192 -26.257  1.00 61.67           C  
ATOM   5463  O   GLY D  46     -62.426  24.178 -27.360  1.00 64.57           O  
ATOM   5464  N   PHE D  47     -60.946  25.081 -25.907  1.00 59.69           N  
ATOM   5465  CA  PHE D  47     -60.221  25.859 -26.897  1.00 60.29           C  
ATOM   5466  C   PHE D  47     -58.728  25.927 -26.574  1.00 62.12           C  
ATOM   5467  O   PHE D  47     -58.324  26.019 -25.409  1.00 63.77           O  
ATOM   5468  CB  PHE D  47     -60.839  27.252 -27.135  1.00 61.33           C  
ATOM   5469  CG  PHE D  47     -60.874  28.152 -25.915  1.00 61.13           C  
ATOM   5470  CD1 PHE D  47     -59.761  28.905 -25.551  1.00 55.96           C  
ATOM   5471  CD2 PHE D  47     -62.041  28.281 -25.163  1.00 56.80           C  
ATOM   5472  CE1 PHE D  47     -59.797  29.747 -24.436  1.00 56.82           C  
ATOM   5473  CE2 PHE D  47     -62.089  29.118 -24.049  1.00 56.74           C  
ATOM   5474  CZ  PHE D  47     -60.963  29.854 -23.684  1.00 56.93           C  
ATOM   5475  N   GLY D  48     -57.919  25.823 -27.624  1.00 61.88           N  
ATOM   5476  CA  GLY D  48     -56.488  26.067 -27.550  1.00 60.25           C  
ATOM   5477  C   GLY D  48     -56.135  27.064 -28.633  1.00 61.67           C  
ATOM   5478  O   GLY D  48     -55.790  26.686 -29.758  1.00 61.47           O  
ATOM   5479  N   ALA D  49     -56.226  28.342 -28.275  1.00 61.62           N  
ATOM   5480  CA  ALA D  49     -56.077  29.435 -29.214  1.00 62.43           C  
ATOM   5481  C   ALA D  49     -54.696  30.073 -29.166  1.00 63.96           C  
ATOM   5482  O   ALA D  49     -54.466  31.024 -28.417  1.00 64.17           O  
ATOM   5483  CB  ALA D  49     -57.152  30.479 -28.960  1.00 61.47           C  
ATOM   5484  N   GLN D  50     -53.776  29.542 -29.964  1.00 67.64           N  
ATOM   5485  CA  GLN D  50     -52.470  30.174 -30.160  1.00 69.12           C  
ATOM   5486  C   GLN D  50     -52.628  31.387 -31.067  1.00 69.92           C  
ATOM   5487  O   GLN D  50     -53.520  31.412 -31.919  1.00 68.00           O  
ATOM   5488  CB  GLN D  50     -51.485  29.202 -30.800  1.00 68.46           C  
ATOM   5489  CG  GLN D  50     -51.180  27.970 -29.971  1.00 71.93           C  
ATOM   5490  CD  GLN D  50     -49.738  27.514 -30.131  1.00 74.12           C  
ATOM   5491  OE1 GLN D  50     -48.803  28.241 -29.787  1.00 72.19           O  
ATOM   5492  NE2 GLN D  50     -49.554  26.306 -30.648  1.00 71.86           N  
ATOM   5493  N   GLY D  51     -51.767  32.386 -30.869  1.00 70.83           N  
ATOM   5494  CA  GLY D  51     -51.681  33.567 -31.740  1.00 74.09           C  
ATOM   5495  C   GLY D  51     -52.957  33.997 -32.439  1.00 76.62           C  
ATOM   5496  O   GLY D  51     -53.982  34.240 -31.794  1.00 79.06           O  
ATOM   5497  N   GLY D  52     -52.888  34.099 -33.765  1.00 77.26           N  
ATOM   5498  CA  GLY D  52     -54.061  34.412 -34.578  1.00 76.92           C  
ATOM   5499  C   GLY D  52     -54.739  33.157 -35.100  1.00 77.15           C  
ATOM   5500  O   GLY D  52     -55.784  33.238 -35.750  1.00 80.68           O  
ATOM   5501  N   SER D  53     -54.152  32.000 -34.787  1.00 74.03           N  
ATOM   5502  CA  SER D  53     -54.570  30.697 -35.324  1.00 71.72           C  
ATOM   5503  C   SER D  53     -56.083  30.464 -35.364  1.00 70.88           C  
ATOM   5504  O   SER D  53     -56.816  30.859 -34.454  1.00 67.67           O  
ATOM   5505  CB  SER D  53     -53.896  29.554 -34.552  1.00 71.48           C  
ATOM   5506  OG  SER D  53     -54.567  29.284 -33.327  1.00 72.16           O  
ATOM   5507  N   THR D  54     -56.526  29.812 -36.433  1.00 69.57           N  
ATOM   5508  CA  THR D  54     -57.910  29.408 -36.587  1.00 68.60           C  
ATOM   5509  C   THR D  54     -57.978  27.889 -36.727  1.00 68.46           C  
ATOM   5510  O   THR D  54     -57.208  27.288 -37.480  1.00 69.66           O  
ATOM   5511  CB  THR D  54     -58.558  30.081 -37.808  1.00 68.49           C  
ATOM   5512  OG1 THR D  54     -58.282  31.487 -37.780  1.00 73.93           O  
ATOM   5513  CG2 THR D  54     -60.058  29.884 -37.795  1.00 69.92           C  
ATOM   5514  N   GLU D  55     -58.905  27.287 -35.989  1.00 65.35           N  
ATOM   5515  CA  GLU D  55     -59.100  25.844 -35.963  1.00 63.12           C  
ATOM   5516  C   GLU D  55     -60.356  25.457 -36.753  1.00 62.36           C  
ATOM   5517  O   GLU D  55     -61.372  26.160 -36.695  1.00 58.79           O  
ATOM   5518  CB  GLU D  55     -59.249  25.395 -34.509  1.00 61.65           C  
ATOM   5519  CG  GLU D  55     -59.341  23.896 -34.296  1.00 60.73           C  
ATOM   5520  CD  GLU D  55     -59.513  23.526 -32.829  1.00 62.49           C  
ATOM   5521  OE1 GLU D  55     -59.248  24.379 -31.956  1.00 58.89           O  
ATOM   5522  OE2 GLU D  55     -59.915  22.378 -32.551  1.00 58.22           O  
ATOM   5523  N   ARG D  56     -60.290  24.334 -37.467  1.00 60.65           N  
ATOM   5524  CA  ARG D  56     -61.445  23.837 -38.218  1.00 60.50           C  
ATOM   5525  C   ARG D  56     -62.134  22.669 -37.513  1.00 60.54           C  
ATOM   5526  O   ARG D  56     -61.489  21.694 -37.133  1.00 63.02           O  
ATOM   5527  CB  ARG D  56     -61.054  23.459 -39.658  1.00 59.23           C  
ATOM   5528  CG  ARG D  56     -60.381  24.595 -40.443  1.00 60.16           C  
ATOM   5529  CD  ARG D  56     -60.487  24.406 -41.957  1.00 57.89           C  
ATOM   5530  NE  ARG D  56     -61.855  24.609 -42.421  1.00 54.12           N  
ATOM   5531  CZ  ARG D  56     -62.345  25.769 -42.855  1.00 56.44           C  
ATOM   5532  NH1 ARG D  56     -61.582  26.856 -42.909  1.00 50.18           N  
ATOM   5533  NH2 ARG D  56     -63.612  25.840 -43.243  1.00 53.57           N  
ATOM   5534  N   HIS D  57     -63.445  22.785 -37.326  1.00 61.03           N  
ATOM   5535  CA  HIS D  57     -64.263  21.690 -36.797  1.00 61.31           C  
ATOM   5536  C   HIS D  57     -65.641  21.754 -37.441  1.00 59.05           C  
ATOM   5537  O   HIS D  57     -66.254  22.819 -37.488  1.00 61.11           O  
ATOM   5538  CB  HIS D  57     -64.373  21.770 -35.271  1.00 61.45           C  
ATOM   5539  CG  HIS D  57     -65.251  20.714 -34.669  1.00 68.64           C  
ATOM   5540  ND1 HIS D  57     -64.747  19.568 -34.091  1.00 68.84           N  
ATOM   5541  CD2 HIS D  57     -66.600  20.632 -34.554  1.00 68.98           C  
ATOM   5542  CE1 HIS D  57     -65.748  18.825 -33.649  1.00 66.66           C  
ATOM   5543  NE2 HIS D  57     -66.882  19.444 -33.924  1.00 66.60           N  
ATOM   5544  N   GLY D  58     -66.111  20.618 -37.951  1.00 58.64           N  
ATOM   5545  CA  GLY D  58     -67.406  20.546 -38.631  1.00 58.68           C  
ATOM   5546  C   GLY D  58     -67.498  21.483 -39.827  1.00 60.40           C  
ATOM   5547  O   GLY D  58     -68.569  22.020 -40.128  1.00 59.88           O  
ATOM   5548  N   GLY D  59     -66.366  21.681 -40.501  1.00 59.72           N  
ATOM   5549  CA  GLY D  59     -66.287  22.579 -41.652  1.00 60.32           C  
ATOM   5550  C   GLY D  59     -66.285  24.054 -41.284  1.00 59.27           C  
ATOM   5551  O   GLY D  59     -66.254  24.912 -42.166  1.00 57.98           O  
ATOM   5552  N   SER D  60     -66.314  24.350 -39.985  1.00 57.94           N  
ATOM   5553  CA  SER D  60     -66.393  25.730 -39.507  1.00 58.07           C  
ATOM   5554  C   SER D  60     -65.116  26.202 -38.818  1.00 56.44           C  
ATOM   5555  O   SER D  60     -64.282  25.394 -38.411  1.00 59.14           O  
ATOM   5556  CB  SER D  60     -67.598  25.897 -38.578  1.00 57.80           C  
ATOM   5557  OG  SER D  60     -68.804  25.703 -39.296  1.00 53.69           O  
ATOM   5558  N   GLU D  61     -64.981  27.516 -38.678  1.00 57.07           N  
ATOM   5559  CA  GLU D  61     -63.785  28.120 -38.096  1.00 57.90           C  
ATOM   5560  C   GLU D  61     -63.998  28.525 -36.643  1.00 58.26           C  
ATOM   5561  O   GLU D  61     -65.033  29.088 -36.288  1.00 59.29           O  
ATOM   5562  CB  GLU D  61     -63.340  29.332 -38.915  1.00 56.09           C  
ATOM   5563  CG  GLU D  61     -62.779  28.985 -40.281  1.00 58.77           C  
ATOM   5564  CD  GLU D  61     -62.148  30.173 -40.997  1.00 60.73           C  
ATOM   5565  OE1 GLU D  61     -62.542  31.335 -40.738  1.00 57.34           O  
ATOM   5566  OE2 GLU D  61     -61.255  29.935 -41.834  1.00 63.10           O  
ATOM   5567  N   PHE D  62     -62.996  28.244 -35.814  1.00 59.14           N  
ATOM   5568  CA  PHE D  62     -63.050  28.539 -34.392  1.00 59.79           C  
ATOM   5569  C   PHE D  62     -61.816  29.332 -33.968  1.00 60.06           C  
ATOM   5570  O   PHE D  62     -60.684  28.873 -34.118  1.00 60.52           O  
ATOM   5571  CB  PHE D  62     -63.199  27.238 -33.587  1.00 59.61           C  
ATOM   5572  CG  PHE D  62     -64.509  26.516 -33.834  1.00 64.03           C  
ATOM   5573  CD1 PHE D  62     -64.691  25.726 -34.973  1.00 60.51           C  
ATOM   5574  CD2 PHE D  62     -65.565  26.633 -32.930  1.00 64.27           C  
ATOM   5575  CE1 PHE D  62     -65.906  25.078 -35.212  1.00 61.25           C  
ATOM   5576  CE2 PHE D  62     -66.788  25.980 -33.157  1.00 65.30           C  
ATOM   5577  CZ  PHE D  62     -66.957  25.202 -34.299  1.00 62.95           C  
ATOM   5578  N   SER D  63     -62.040  30.542 -33.470  1.00 61.70           N  
ATOM   5579  CA  SER D  63     -60.950  31.391 -32.997  1.00 65.19           C  
ATOM   5580  C   SER D  63     -61.133  31.677 -31.523  1.00 65.13           C  
ATOM   5581  O   SER D  63     -62.259  31.744 -31.029  1.00 66.89           O  
ATOM   5582  CB  SER D  63     -60.895  32.716 -33.769  1.00 63.75           C  
ATOM   5583  OG  SER D  63     -60.773  32.493 -35.158  1.00 69.52           O  
ATOM   5584  N   GLU D  64     -60.012  31.859 -30.841  1.00 66.54           N  
ATOM   5585  CA  GLU D  64     -59.966  32.187 -29.416  1.00 70.01           C  
ATOM   5586  C   GLU D  64     -61.036  31.563 -28.522  1.00 70.44           C  
ATOM   5587  O   GLU D  64     -61.019  30.362 -28.269  1.00 73.00           O  
ATOM   5588  CB  GLU D  64     -59.868  33.705 -29.193  1.00 72.19           C  
ATOM   5589  CG  GLU D  64     -60.522  34.593 -30.238  1.00 70.36           C  
ATOM   5590  CD  GLU D  64     -59.811  35.932 -30.367  1.00 82.14           C  
ATOM   5591  OE1 GLU D  64     -58.621  36.022 -29.978  1.00 81.57           O  
ATOM   5592  OE2 GLU D  64     -60.439  36.894 -30.858  1.00 84.11           O  
ATOM   5593  N   ASP D  65     -61.958  32.407 -28.074  1.00 72.65           N  
ATOM   5594  CA  ASP D  65     -62.984  32.109 -27.076  1.00 72.99           C  
ATOM   5595  C   ASP D  65     -63.963  30.959 -27.408  1.00 71.71           C  
ATOM   5596  O   ASP D  65     -64.617  30.423 -26.511  1.00 70.57           O  
ATOM   5597  CB  ASP D  65     -63.781  33.408 -26.843  1.00 74.69           C  
ATOM   5598  CG  ASP D  65     -64.204  33.590 -25.408  1.00 77.11           C  
ATOM   5599  OD1 ASP D  65     -63.573  32.981 -24.519  1.00 84.47           O  
ATOM   5600  OD2 ASP D  65     -65.166  34.349 -25.167  1.00 80.36           O  
ATOM   5601  N   LYS D  66     -64.066  30.584 -28.684  1.00 70.54           N  
ATOM   5602  CA  LYS D  66     -65.119  29.659 -29.143  1.00 73.00           C  
ATOM   5603  C   LYS D  66     -64.807  28.166 -28.911  1.00 68.54           C  
ATOM   5604  O   LYS D  66     -63.796  27.645 -29.392  1.00 69.57           O  
ATOM   5605  CB  LYS D  66     -65.465  29.935 -30.611  1.00 71.73           C  
ATOM   5606  CG  LYS D  66     -66.886  29.538 -31.009  1.00 80.72           C  
ATOM   5607  CD  LYS D  66     -67.183  29.906 -32.466  1.00 79.67           C  
ATOM   5608  CE  LYS D  66     -68.443  29.221 -32.985  1.00 86.05           C  
ATOM   5609  NZ  LYS D  66     -69.689  29.722 -32.334  1.00 90.25           N  
ATOM   5610  N   PHE D  67     -65.687  27.488 -28.177  1.00 65.68           N  
ATOM   5611  CA  PHE D  67     -65.472  26.085 -27.781  1.00 64.17           C  
ATOM   5612  C   PHE D  67     -65.642  25.049 -28.899  1.00 62.88           C  
ATOM   5613  O   PHE D  67     -66.523  25.177 -29.753  1.00 64.32           O  
ATOM   5614  CB  PHE D  67     -66.340  25.722 -26.575  1.00 61.49           C  
ATOM   5615  CG  PHE D  67     -65.805  26.239 -25.270  1.00 62.56           C  
ATOM   5616  CD1 PHE D  67     -64.775  25.567 -24.608  1.00 55.20           C  
ATOM   5617  CD2 PHE D  67     -66.325  27.403 -24.701  1.00 60.30           C  
ATOM   5618  CE1 PHE D  67     -64.269  26.036 -23.399  1.00 51.70           C  
ATOM   5619  CE2 PHE D  67     -65.827  27.884 -23.485  1.00 59.64           C  
ATOM   5620  CZ  PHE D  67     -64.794  27.198 -22.835  1.00 57.30           C  
ATOM   5621  N   VAL D  68     -64.787  24.025 -28.866  1.00 60.95           N  
ATOM   5622  CA  VAL D  68     -64.759  22.947 -29.859  1.00 59.90           C  
ATOM   5623  C   VAL D  68     -64.853  21.608 -29.130  1.00 59.26           C  
ATOM   5624  O   VAL D  68     -64.191  21.416 -28.105  1.00 61.27           O  
ATOM   5625  CB  VAL D  68     -63.423  22.949 -30.664  1.00 63.72           C  
ATOM   5626  CG1 VAL D  68     -63.418  21.867 -31.755  1.00 61.62           C  
ATOM   5627  CG2 VAL D  68     -63.113  24.332 -31.257  1.00 63.95           C  
ATOM   5628  N   ALA D  69     -65.658  20.687 -29.659  1.00 57.17           N  
ATOM   5629  CA  ALA D  69     -65.771  19.326 -29.103  1.00 59.38           C  
ATOM   5630  C   ALA D  69     -64.446  18.556 -29.135  1.00 58.66           C  
ATOM   5631  O   ALA D  69     -63.732  18.574 -30.135  1.00 60.87           O  
ATOM   5632  CB  ALA D  69     -66.867  18.528 -29.818  1.00 52.88           C  
ATOM   5633  N   LYS D  70     -64.129  17.895 -28.026  1.00 58.60           N  
ATOM   5634  CA  LYS D  70     -62.926  17.075 -27.908  1.00 60.93           C  
ATOM   5635  C   LYS D  70     -63.261  15.845 -27.079  1.00 60.47           C  
ATOM   5636  O   LYS D  70     -64.354  15.755 -26.520  1.00 61.23           O  
ATOM   5637  CB  LYS D  70     -61.803  17.853 -27.203  1.00 62.38           C  
ATOM   5638  CG  LYS D  70     -61.404  19.186 -27.840  1.00 63.21           C  
ATOM   5639  CD  LYS D  70     -60.471  19.001 -29.024  1.00 60.04           C  
ATOM   5640  CE  LYS D  70     -60.430  20.270 -29.869  1.00 63.07           C  
ATOM   5641  NZ  LYS D  70     -59.727  20.079 -31.168  1.00 62.54           N  
ATOM   5642  N   VAL D  71     -62.328  14.898 -26.998  1.00 60.60           N  
ATOM   5643  CA  VAL D  71     -62.429  13.815 -26.017  1.00 62.32           C  
ATOM   5644  C   VAL D  71     -61.203  13.776 -25.099  1.00 62.85           C  
ATOM   5645  O   VAL D  71     -60.068  13.916 -25.553  1.00 65.22           O  
ATOM   5646  CB  VAL D  71     -62.677  12.434 -26.672  1.00 64.20           C  
ATOM   5647  CG1 VAL D  71     -62.534  11.315 -25.643  1.00 61.08           C  
ATOM   5648  CG2 VAL D  71     -64.066  12.380 -27.307  1.00 55.72           C  
ATOM   5649  N   LYS D  72     -61.455  13.600 -23.807  1.00 64.97           N  
ATOM   5650  CA  LYS D  72     -60.397  13.473 -22.806  1.00 65.26           C  
ATOM   5651  C   LYS D  72     -60.112  12.005 -22.514  1.00 63.81           C  
ATOM   5652  O   LYS D  72     -61.009  11.263 -22.117  1.00 65.01           O  
ATOM   5653  CB  LYS D  72     -60.810  14.211 -21.533  1.00 66.62           C  
ATOM   5654  CG  LYS D  72     -59.859  14.115 -20.351  1.00 69.67           C  
ATOM   5655  CD  LYS D  72     -60.202  15.217 -19.364  1.00 75.79           C  
ATOM   5656  CE  LYS D  72     -60.376  14.697 -17.961  1.00 83.19           C  
ATOM   5657  NZ  LYS D  72     -61.152  15.667 -17.135  1.00 85.13           N  
ATOM   5658  N   MET D  73     -58.867  11.594 -22.739  1.00 63.42           N  
ATOM   5659  CA  MET D  73     -58.407  10.244 -22.409  1.00 65.67           C  
ATOM   5660  C   MET D  73     -57.623  10.301 -21.116  1.00 63.82           C  
ATOM   5661  O   MET D  73     -56.790  11.190 -20.936  1.00 62.42           O  
ATOM   5662  CB  MET D  73     -57.491   9.682 -23.497  1.00 65.13           C  
ATOM   5663  CG  MET D  73     -58.063   9.708 -24.897  1.00 71.47           C  
ATOM   5664  SD  MET D  73     -57.037   8.783 -26.047  1.00 74.75           S  
ATOM   5665  CE  MET D  73     -57.578   7.098 -25.735  1.00 73.46           C  
ATOM   5666  N   GLU D  74     -57.895   9.356 -20.218  1.00 61.49           N  
ATOM   5667  CA  GLU D  74     -57.145   9.249 -18.970  1.00 62.99           C  
ATOM   5668  C   GLU D  74     -56.589   7.834 -18.835  1.00 63.26           C  
ATOM   5669  O   GLU D  74     -57.345   6.853 -18.854  1.00 62.31           O  
ATOM   5670  CB  GLU D  74     -58.003   9.627 -17.753  1.00 59.81           C  
ATOM   5671  CG  GLU D  74     -58.622  11.023 -17.820  1.00 64.53           C  
ATOM   5672  CD  GLU D  74     -59.611  11.293 -16.695  1.00 65.42           C  
ATOM   5673  OE1 GLU D  74     -59.176  11.432 -15.536  1.00 71.75           O  
ATOM   5674  OE2 GLU D  74     -60.826  11.376 -16.968  1.00 67.91           O  
ATOM   5675  N   ILE D  75     -55.264   7.746 -18.719  1.00 61.77           N  
ATOM   5676  CA  ILE D  75     -54.561   6.477 -18.566  1.00 60.85           C  
ATOM   5677  C   ILE D  75     -53.620   6.569 -17.365  1.00 62.36           C  
ATOM   5678  O   ILE D  75     -52.744   7.438 -17.309  1.00 61.58           O  
ATOM   5679  CB  ILE D  75     -53.753   6.087 -19.836  1.00 60.28           C  
ATOM   5680  CG1 ILE D  75     -54.631   6.071 -21.092  1.00 62.63           C  
ATOM   5681  CG2 ILE D  75     -53.112   4.731 -19.666  1.00 60.10           C  
ATOM   5682  CD1 ILE D  75     -54.540   7.339 -21.930  1.00 58.62           C  
ATOM   5683  N   VAL D  76     -53.818   5.678 -16.400  1.00 62.81           N  
ATOM   5684  CA  VAL D  76     -52.977   5.627 -15.213  1.00 62.16           C  
ATOM   5685  C   VAL D  76     -52.022   4.442 -15.324  1.00 63.92           C  
ATOM   5686  O   VAL D  76     -52.459   3.309 -15.545  1.00 63.29           O  
ATOM   5687  CB  VAL D  76     -53.829   5.538 -13.930  1.00 61.76           C  
ATOM   5688  CG1 VAL D  76     -52.950   5.350 -12.697  1.00 59.33           C  
ATOM   5689  CG2 VAL D  76     -54.682   6.789 -13.787  1.00 62.84           C  
ATOM   5690  N   VAL D  77     -50.723   4.720 -15.183  1.00 63.13           N  
ATOM   5691  CA  VAL D  77     -49.667   3.717 -15.360  1.00 63.37           C  
ATOM   5692  C   VAL D  77     -48.477   3.931 -14.413  1.00 66.18           C  
ATOM   5693  O   VAL D  77     -48.361   4.980 -13.767  1.00 66.72           O  
ATOM   5694  CB  VAL D  77     -49.113   3.701 -16.819  1.00 61.96           C  
ATOM   5695  CG1 VAL D  77     -50.144   3.146 -17.812  1.00 61.20           C  
ATOM   5696  CG2 VAL D  77     -48.613   5.084 -17.233  1.00 57.36           C  
ATOM   5697  N   LYS D  78     -47.591   2.935 -14.352  1.00 66.63           N  
ATOM   5698  CA  LYS D  78     -46.309   3.069 -13.661  1.00 68.82           C  
ATOM   5699  C   LYS D  78     -45.445   4.114 -14.361  1.00 68.60           C  
ATOM   5700  O   LYS D  78     -45.581   4.341 -15.567  1.00 68.46           O  
ATOM   5701  CB  LYS D  78     -45.559   1.726 -13.602  1.00 69.84           C  
ATOM   5702  CG  LYS D  78     -46.021   0.776 -12.502  1.00 72.77           C  
ATOM   5703  CD  LYS D  78     -44.905  -0.191 -12.080  1.00 87.58           C  
ATOM   5704  CE  LYS D  78     -45.023  -1.575 -12.731  1.00 92.43           C  
ATOM   5705  NZ  LYS D  78     -44.845  -1.571 -14.215  1.00 96.39           N  
ATOM   5706  N   LYS D  79     -44.563   4.744 -13.589  1.00 68.10           N  
ATOM   5707  CA  LYS D  79     -43.627   5.759 -14.076  1.00 70.59           C  
ATOM   5708  C   LYS D  79     -42.921   5.373 -15.384  1.00 70.47           C  
ATOM   5709  O   LYS D  79     -42.820   6.190 -16.303  1.00 69.46           O  
ATOM   5710  CB  LYS D  79     -42.587   6.045 -12.984  1.00 71.09           C  
ATOM   5711  CG  LYS D  79     -41.677   7.241 -13.231  1.00 73.00           C  
ATOM   5712  CD  LYS D  79     -40.565   7.279 -12.190  1.00 76.04           C  
ATOM   5713  CE  LYS D  79     -39.920   8.651 -12.117  1.00 84.46           C  
ATOM   5714  NZ  LYS D  79     -38.796   8.677 -11.136  1.00 88.59           N  
ATOM   5715  N   ASP D  80     -42.446   4.130 -15.462  1.00 71.75           N  
ATOM   5716  CA  ASP D  80     -41.615   3.685 -16.587  1.00 73.79           C  
ATOM   5717  C   ASP D  80     -42.340   3.580 -17.930  1.00 72.53           C  
ATOM   5718  O   ASP D  80     -41.721   3.738 -18.978  1.00 71.79           O  
ATOM   5719  CB  ASP D  80     -40.854   2.387 -16.262  1.00 75.78           C  
ATOM   5720  CG  ASP D  80     -41.619   1.474 -15.317  1.00 83.08           C  
ATOM   5721  OD1 ASP D  80     -41.687   1.789 -14.105  1.00 86.48           O  
ATOM   5722  OD2 ASP D  80     -42.136   0.437 -15.785  1.00 87.03           O  
ATOM   5723  N   GLN D  81     -43.648   3.331 -17.904  1.00 72.15           N  
ATOM   5724  CA  GLN D  81     -44.404   3.198 -19.154  1.00 72.11           C  
ATOM   5725  C   GLN D  81     -45.073   4.488 -19.645  1.00 67.73           C  
ATOM   5726  O   GLN D  81     -45.754   4.479 -20.669  1.00 65.01           O  
ATOM   5727  CB  GLN D  81     -45.395   2.023 -19.104  1.00 72.42           C  
ATOM   5728  CG  GLN D  81     -46.101   1.813 -17.772  1.00 78.26           C  
ATOM   5729  CD  GLN D  81     -46.802   0.462 -17.680  1.00 78.78           C  
ATOM   5730  OE1 GLN D  81     -46.448  -0.490 -18.382  1.00 86.31           O  
ATOM   5731  NE2 GLN D  81     -47.799   0.373 -16.807  1.00 83.07           N  
ATOM   5732  N   VAL D  82     -44.835   5.593 -18.938  1.00 66.02           N  
ATOM   5733  CA  VAL D  82     -45.409   6.904 -19.290  1.00 64.86           C  
ATOM   5734  C   VAL D  82     -45.022   7.388 -20.698  1.00 64.96           C  
ATOM   5735  O   VAL D  82     -45.874   7.873 -21.443  1.00 65.77           O  
ATOM   5736  CB  VAL D  82     -45.082   7.977 -18.210  1.00 64.03           C  
ATOM   5737  CG1 VAL D  82     -45.361   9.392 -18.708  1.00 61.41           C  
ATOM   5738  CG2 VAL D  82     -45.883   7.710 -16.951  1.00 65.59           C  
ATOM   5739  N   GLU D  83     -43.749   7.240 -21.058  1.00 64.89           N  
ATOM   5740  CA  GLU D  83     -43.252   7.666 -22.371  1.00 65.71           C  
ATOM   5741  C   GLU D  83     -43.888   6.921 -23.539  1.00 63.42           C  
ATOM   5742  O   GLU D  83     -44.141   7.511 -24.588  1.00 63.56           O  
ATOM   5743  CB  GLU D  83     -41.726   7.534 -22.444  1.00 66.65           C  
ATOM   5744  CG  GLU D  83     -40.973   8.771 -21.969  1.00 75.61           C  
ATOM   5745  CD  GLU D  83     -41.288  10.015 -22.793  1.00 81.44           C  
ATOM   5746  OE1 GLU D  83     -41.204   9.958 -24.042  1.00 80.21           O  
ATOM   5747  OE2 GLU D  83     -41.614  11.056 -22.182  1.00 84.36           O  
ATOM   5748  N   SER D  84     -44.127   5.625 -23.353  1.00 62.96           N  
ATOM   5749  CA  SER D  84     -44.742   4.777 -24.371  1.00 64.08           C  
ATOM   5750  C   SER D  84     -46.193   5.178 -24.619  1.00 63.81           C  
ATOM   5751  O   SER D  84     -46.682   5.097 -25.747  1.00 63.29           O  
ATOM   5752  CB  SER D  84     -44.681   3.308 -23.953  1.00 62.00           C  
ATOM   5753  OG  SER D  84     -43.360   2.946 -23.595  1.00 72.70           O  
ATOM   5754  N   VAL D  85     -46.871   5.603 -23.555  1.00 62.69           N  
ATOM   5755  CA  VAL D  85     -48.262   6.033 -23.652  1.00 63.73           C  
ATOM   5756  C   VAL D  85     -48.346   7.334 -24.447  1.00 64.76           C  
ATOM   5757  O   VAL D  85     -49.105   7.424 -25.419  1.00 66.44           O  
ATOM   5758  CB  VAL D  85     -48.908   6.186 -22.258  1.00 63.17           C  
ATOM   5759  CG1 VAL D  85     -50.325   6.734 -22.374  1.00 59.80           C  
ATOM   5760  CG2 VAL D  85     -48.906   4.848 -21.524  1.00 58.47           C  
ATOM   5761  N   ILE D  86     -47.544   8.319 -24.039  1.00 63.93           N  
ATOM   5762  CA  ILE D  86     -47.472   9.617 -24.708  1.00 63.41           C  
ATOM   5763  C   ILE D  86     -47.214   9.436 -26.205  1.00 63.87           C  
ATOM   5764  O   ILE D  86     -47.985   9.929 -27.032  1.00 64.88           O  
ATOM   5765  CB  ILE D  86     -46.395  10.532 -24.059  1.00 63.80           C  
ATOM   5766  CG1 ILE D  86     -46.797  10.900 -22.625  1.00 64.19           C  
ATOM   5767  CG2 ILE D  86     -46.174  11.798 -24.886  1.00 63.10           C  
ATOM   5768  CD1 ILE D  86     -45.676  11.525 -21.797  1.00 64.94           C  
ATOM   5769  N   ASN D  87     -46.149   8.705 -26.540  1.00 62.80           N  
ATOM   5770  CA  ASN D  87     -45.777   8.455 -27.931  1.00 62.71           C  
ATOM   5771  C   ASN D  87     -46.870   7.747 -28.736  1.00 62.54           C  
ATOM   5772  O   ASN D  87     -47.171   8.150 -29.858  1.00 64.66           O  
ATOM   5773  CB  ASN D  87     -44.446   7.690 -28.021  1.00 63.25           C  
ATOM   5774  CG  ASN D  87     -43.240   8.556 -27.655  1.00 65.93           C  
ATOM   5775  OD1 ASN D  87     -42.252   8.063 -27.107  1.00 68.10           O  
ATOM   5776  ND2 ASN D  87     -43.318   9.849 -27.958  1.00 65.02           N  
ATOM   5777  N   THR D  88     -47.466   6.709 -28.153  1.00 61.02           N  
ATOM   5778  CA  THR D  88     -48.555   5.974 -28.796  1.00 62.51           C  
ATOM   5779  C   THR D  88     -49.767   6.873 -29.090  1.00 63.95           C  
ATOM   5780  O   THR D  88     -50.347   6.788 -30.175  1.00 64.32           O  
ATOM   5781  CB  THR D  88     -48.973   4.736 -27.966  1.00 61.88           C  
ATOM   5782  OG1 THR D  88     -47.856   3.850 -27.843  1.00 61.50           O  
ATOM   5783  CG2 THR D  88     -50.121   3.988 -28.621  1.00 58.87           C  
ATOM   5784  N   ILE D  89     -50.134   7.728 -28.130  1.00 65.67           N  
ATOM   5785  CA  ILE D  89     -51.208   8.715 -28.326  1.00 64.19           C  
ATOM   5786  C   ILE D  89     -50.873   9.672 -29.468  1.00 64.54           C  
ATOM   5787  O   ILE D  89     -51.701   9.894 -30.350  1.00 65.19           O  
ATOM   5788  CB  ILE D  89     -51.517   9.526 -27.034  1.00 65.53           C  
ATOM   5789  CG1 ILE D  89     -52.035   8.597 -25.928  1.00 64.42           C  
ATOM   5790  CG2 ILE D  89     -52.527  10.648 -27.327  1.00 59.06           C  
ATOM   5791  CD1 ILE D  89     -52.200   9.260 -24.574  1.00 64.34           C  
ATOM   5792  N   ILE D  90     -49.659  10.223 -29.461  1.00 64.80           N  
ATOM   5793  CA  ILE D  90     -49.239  11.164 -30.507  1.00 64.61           C  
ATOM   5794  C   ILE D  90     -49.330  10.550 -31.909  1.00 65.42           C  
ATOM   5795  O   ILE D  90     -49.921  11.151 -32.802  1.00 66.61           O  
ATOM   5796  CB  ILE D  90     -47.833  11.758 -30.247  1.00 63.29           C  
ATOM   5797  CG1 ILE D  90     -47.858  12.648 -29.000  1.00 62.74           C  
ATOM   5798  CG2 ILE D  90     -47.347  12.556 -31.461  1.00 60.33           C  
ATOM   5799  CD1 ILE D  90     -46.484  12.938 -28.404  1.00 58.55           C  
ATOM   5800  N   GLU D  91     -48.773   9.353 -32.090  1.00 66.77           N  
ATOM   5801  CA  GLU D  91     -48.825   8.673 -33.390  1.00 69.39           C  
ATOM   5802  C   GLU D  91     -50.264   8.417 -33.858  1.00 67.72           C  
ATOM   5803  O   GLU D  91     -50.583   8.604 -35.034  1.00 66.78           O  
ATOM   5804  CB  GLU D  91     -48.027   7.362 -33.372  1.00 70.13           C  
ATOM   5805  CG  GLU D  91     -46.508   7.526 -33.188  1.00 82.81           C  
ATOM   5806  CD  GLU D  91     -45.805   8.243 -34.349  1.00 91.40           C  
ATOM   5807  OE1 GLU D  91     -46.355   8.293 -35.475  1.00 94.63           O  
ATOM   5808  OE2 GLU D  91     -44.683   8.752 -34.126  1.00 89.09           O  
ATOM   5809  N   GLY D  92     -51.124   8.008 -32.928  1.00 65.95           N  
ATOM   5810  CA  GLY D  92     -52.507   7.682 -33.243  1.00 64.88           C  
ATOM   5811  C   GLY D  92     -53.415   8.880 -33.468  1.00 65.04           C  
ATOM   5812  O   GLY D  92     -54.389   8.787 -34.219  1.00 65.68           O  
ATOM   5813  N   ALA D  93     -53.100  10.002 -32.823  1.00 63.02           N  
ATOM   5814  CA  ALA D  93     -53.991  11.168 -32.823  1.00 63.08           C  
ATOM   5815  C   ALA D  93     -53.601  12.301 -33.778  1.00 62.09           C  
ATOM   5816  O   ALA D  93     -54.465  13.078 -34.192  1.00 61.76           O  
ATOM   5817  CB  ALA D  93     -54.171  11.702 -31.403  1.00 60.76           C  
ATOM   5818  N   ARG D  94     -52.315  12.394 -34.117  1.00 62.10           N  
ATOM   5819  CA  ARG D  94     -51.792  13.503 -34.925  1.00 61.97           C  
ATOM   5820  C   ARG D  94     -52.304  13.501 -36.365  1.00 62.71           C  
ATOM   5821  O   ARG D  94     -52.294  12.465 -37.037  1.00 62.79           O  
ATOM   5822  CB  ARG D  94     -50.262  13.511 -34.895  1.00 61.87           C  
ATOM   5823  CG  ARG D  94     -49.597  14.487 -35.861  1.00 66.81           C  
ATOM   5824  CD  ARG D  94     -48.363  15.132 -35.247  1.00 66.33           C  
ATOM   5825  NE  ARG D  94     -47.209  14.242 -35.200  1.00 72.23           N  
ATOM   5826  CZ  ARG D  94     -46.155  14.407 -34.398  1.00 77.27           C  
ATOM   5827  NH1 ARG D  94     -46.098  15.423 -33.541  1.00 78.01           N  
ATOM   5828  NH2 ARG D  94     -45.155  13.540 -34.440  1.00 74.56           N  
ATOM   5829  N   THR D  95     -52.760  14.671 -36.817  1.00 61.48           N  
ATOM   5830  CA  THR D  95     -53.117  14.902 -38.216  1.00 59.53           C  
ATOM   5831  C   THR D  95     -52.147  15.883 -38.859  1.00 60.68           C  
ATOM   5832  O   THR D  95     -51.959  15.873 -40.078  1.00 61.44           O  
ATOM   5833  CB  THR D  95     -54.545  15.483 -38.374  1.00 61.73           C  
ATOM   5834  OG1 THR D  95     -54.593  16.814 -37.836  1.00 61.95           O  
ATOM   5835  CG2 THR D  95     -55.589  14.597 -37.686  1.00 55.86           C  
ATOM   5836  N   GLY D  96     -51.538  16.733 -38.033  1.00 60.63           N  
ATOM   5837  CA  GLY D  96     -50.701  17.827 -38.516  1.00 59.43           C  
ATOM   5838  C   GLY D  96     -51.433  19.162 -38.574  1.00 61.46           C  
ATOM   5839  O   GLY D  96     -50.828  20.189 -38.894  1.00 63.06           O  
ATOM   5840  N   GLU D  97     -52.732  19.150 -38.269  1.00 58.86           N  
ATOM   5841  CA  GLU D  97     -53.539  20.369 -38.279  1.00 58.37           C  
ATOM   5842  C   GLU D  97     -53.668  20.980 -36.888  1.00 58.53           C  
ATOM   5843  O   GLU D  97     -53.613  20.270 -35.879  1.00 55.96           O  
ATOM   5844  CB  GLU D  97     -54.940  20.104 -38.862  1.00 58.62           C  
ATOM   5845  CG  GLU D  97     -54.954  19.644 -40.319  1.00 56.38           C  
ATOM   5846  CD  GLU D  97     -54.364  20.672 -41.272  1.00 59.92           C  
ATOM   5847  OE1 GLU D  97     -54.878  21.807 -41.328  1.00 59.80           O  
ATOM   5848  OE2 GLU D  97     -53.381  20.342 -41.967  1.00 62.98           O  
ATOM   5849  N   ILE D  98     -53.832  22.303 -36.860  1.00 59.48           N  
ATOM   5850  CA  ILE D  98     -54.139  23.064 -35.649  1.00 60.59           C  
ATOM   5851  C   ILE D  98     -55.283  22.400 -34.888  1.00 62.36           C  
ATOM   5852  O   ILE D  98     -56.316  22.064 -35.483  1.00 60.92           O  
ATOM   5853  CB  ILE D  98     -54.523  24.535 -36.003  1.00 62.88           C  
ATOM   5854  CG1 ILE D  98     -53.324  25.292 -36.597  1.00 66.08           C  
ATOM   5855  CG2 ILE D  98     -55.104  25.278 -34.802  1.00 64.42           C  
ATOM   5856  CD1 ILE D  98     -52.077  25.330 -35.711  1.00 67.56           C  
ATOM   5857  N   GLY D  99     -55.088  22.189 -33.584  1.00 62.16           N  
ATOM   5858  CA  GLY D  99     -56.131  21.606 -32.742  1.00 60.44           C  
ATOM   5859  C   GLY D  99     -55.999  20.109 -32.513  1.00 62.48           C  
ATOM   5860  O   GLY D  99     -56.971  19.454 -32.129  1.00 63.82           O  
ATOM   5861  N   ASP D 100     -54.798  19.574 -32.733  1.00 60.91           N  
ATOM   5862  CA  ASP D 100     -54.534  18.140 -32.577  1.00 60.95           C  
ATOM   5863  C   ASP D 100     -54.591  17.646 -31.129  1.00 61.39           C  
ATOM   5864  O   ASP D 100     -54.811  16.460 -30.891  1.00 62.19           O  
ATOM   5865  CB  ASP D 100     -53.183  17.759 -33.200  1.00 61.29           C  
ATOM   5866  CG  ASP D 100     -53.299  17.312 -34.656  1.00 62.45           C  
ATOM   5867  OD1 ASP D 100     -54.418  17.003 -35.124  1.00 61.62           O  
ATOM   5868  OD2 ASP D 100     -52.250  17.256 -35.333  1.00 67.31           O  
ATOM   5869  N   GLY D 101     -54.380  18.538 -30.163  1.00 61.29           N  
ATOM   5870  CA  GLY D 101     -54.484  18.142 -28.765  1.00 60.20           C  
ATOM   5871  C   GLY D 101     -53.352  18.501 -27.825  1.00 63.04           C  
ATOM   5872  O   GLY D 101     -52.233  18.823 -28.243  1.00 63.26           O  
ATOM   5873  N   LYS D 102     -53.670  18.445 -26.537  1.00 63.65           N  
ATOM   5874  CA  LYS D 102     -52.710  18.636 -25.469  1.00 62.89           C  
ATOM   5875  C   LYS D 102     -52.696  17.418 -24.565  1.00 62.13           C  
ATOM   5876  O   LYS D 102     -53.746  16.839 -24.266  1.00 61.67           O  
ATOM   5877  CB  LYS D 102     -53.090  19.852 -24.627  1.00 65.03           C  
ATOM   5878  CG  LYS D 102     -52.542  21.172 -25.107  1.00 65.92           C  
ATOM   5879  CD  LYS D 102     -51.030  21.243 -25.047  1.00 56.72           C  
ATOM   5880  CE  LYS D 102     -50.559  22.669 -24.872  1.00 62.77           C  
ATOM   5881  NZ  LYS D 102     -51.520  23.716 -25.311  1.00 59.16           N  
ATOM   5882  N   ILE D 103     -51.505  17.051 -24.111  1.00 61.20           N  
ATOM   5883  CA  ILE D 103     -51.352  15.985 -23.132  1.00 60.72           C  
ATOM   5884  C   ILE D 103     -50.795  16.555 -21.829  1.00 62.68           C  
ATOM   5885  O   ILE D 103     -49.881  17.390 -21.841  1.00 63.76           O  
ATOM   5886  CB  ILE D 103     -50.455  14.841 -23.667  1.00 60.29           C  
ATOM   5887  CG1 ILE D 103     -51.084  14.208 -24.916  1.00 58.50           C  
ATOM   5888  CG2 ILE D 103     -50.236  13.782 -22.598  1.00 57.11           C  
ATOM   5889  CD1 ILE D 103     -50.123  13.383 -25.754  1.00 56.51           C  
ATOM   5890  N   PHE D 104     -51.369  16.119 -20.711  1.00 64.61           N  
ATOM   5891  CA  PHE D 104     -50.861  16.466 -19.388  1.00 63.83           C  
ATOM   5892  C   PHE D 104     -50.445  15.207 -18.641  1.00 65.22           C  
ATOM   5893  O   PHE D 104     -51.046  14.143 -18.818  1.00 64.99           O  
ATOM   5894  CB  PHE D 104     -51.918  17.217 -18.576  1.00 64.78           C  
ATOM   5895  CG  PHE D 104     -52.581  18.337 -19.324  1.00 66.24           C  
ATOM   5896  CD1 PHE D 104     -51.825  19.372 -19.880  1.00 64.03           C  
ATOM   5897  CD2 PHE D 104     -53.963  18.370 -19.459  1.00 62.94           C  
ATOM   5898  CE1 PHE D 104     -52.439  20.406 -20.574  1.00 64.82           C  
ATOM   5899  CE2 PHE D 104     -54.588  19.406 -20.147  1.00 67.21           C  
ATOM   5900  CZ  PHE D 104     -53.826  20.426 -20.709  1.00 65.33           C  
ATOM   5901  N   VAL D 105     -49.412  15.339 -17.811  1.00 65.42           N  
ATOM   5902  CA  VAL D 105     -48.947  14.251 -16.956  1.00 66.15           C  
ATOM   5903  C   VAL D 105     -49.066  14.692 -15.498  1.00 66.22           C  
ATOM   5904  O   VAL D 105     -48.484  15.710 -15.105  1.00 67.84           O  
ATOM   5905  CB  VAL D 105     -47.474  13.865 -17.272  1.00 67.12           C  
ATOM   5906  CG1 VAL D 105     -47.028  12.678 -16.423  1.00 67.14           C  
ATOM   5907  CG2 VAL D 105     -47.295  13.556 -18.756  1.00 65.28           C  
ATOM   5908  N   LEU D 106     -49.827  13.934 -14.706  1.00 64.15           N  
ATOM   5909  CA  LEU D 106     -50.040  14.253 -13.288  1.00 62.68           C  
ATOM   5910  C   LEU D 106     -49.630  13.090 -12.388  1.00 61.22           C  
ATOM   5911  O   LEU D 106     -49.878  11.936 -12.729  1.00 61.46           O  
ATOM   5912  CB  LEU D 106     -51.505  14.606 -13.005  1.00 61.39           C  
ATOM   5913  CG  LEU D 106     -52.192  15.768 -13.725  1.00 63.76           C  
ATOM   5914  CD1 LEU D 106     -52.789  15.313 -15.045  1.00 58.84           C  
ATOM   5915  CD2 LEU D 106     -53.288  16.338 -12.844  1.00 65.04           C  
ATOM   5916  N   PRO D 107     -49.005  13.388 -11.232  1.00 61.40           N  
ATOM   5917  CA  PRO D 107     -48.651  12.334 -10.272  1.00 61.22           C  
ATOM   5918  C   PRO D 107     -49.879  11.677  -9.636  1.00 61.72           C  
ATOM   5919  O   PRO D 107     -50.857  12.356  -9.318  1.00 63.37           O  
ATOM   5920  CB  PRO D 107     -47.832  13.077  -9.213  1.00 60.55           C  
ATOM   5921  CG  PRO D 107     -48.264  14.499  -9.325  1.00 62.59           C  
ATOM   5922  CD  PRO D 107     -48.581  14.724 -10.768  1.00 60.14           C  
ATOM   5923  N   VAL D 108     -49.823  10.357  -9.488  1.00 61.53           N  
ATOM   5924  CA  VAL D 108     -50.863   9.587  -8.817  1.00 61.39           C  
ATOM   5925  C   VAL D 108     -50.211   8.831  -7.663  1.00 62.90           C  
ATOM   5926  O   VAL D 108     -49.237   8.096  -7.868  1.00 63.95           O  
ATOM   5927  CB  VAL D 108     -51.570   8.609  -9.791  1.00 61.00           C  
ATOM   5928  CG1 VAL D 108     -52.537   7.701  -9.050  1.00 59.60           C  
ATOM   5929  CG2 VAL D 108     -52.308   9.379 -10.874  1.00 59.44           C  
ATOM   5930  N   SER D 109     -50.744   9.023  -6.455  1.00 62.58           N  
ATOM   5931  CA  SER D 109     -50.139   8.465  -5.239  1.00 62.04           C  
ATOM   5932  C   SER D 109     -50.516   7.015  -4.963  1.00 61.20           C  
ATOM   5933  O   SER D 109     -49.792   6.324  -4.256  1.00 59.52           O  
ATOM   5934  CB  SER D 109     -50.500   9.312  -4.021  1.00 62.49           C  
ATOM   5935  OG  SER D 109     -50.125  10.660  -4.217  1.00 68.78           O  
ATOM   5936  N   ASP D 110     -51.651   6.563  -5.496  1.00 60.60           N  
ATOM   5937  CA  ASP D 110     -52.102   5.188  -5.264  1.00 61.29           C  
ATOM   5938  C   ASP D 110     -53.162   4.728  -6.269  1.00 60.88           C  
ATOM   5939  O   ASP D 110     -53.858   5.544  -6.876  1.00 60.73           O  
ATOM   5940  CB  ASP D 110     -52.627   5.023  -3.826  1.00 62.31           C  
ATOM   5941  CG  ASP D 110     -52.436   3.603  -3.279  1.00 67.69           C  
ATOM   5942  OD1 ASP D 110     -51.821   2.753  -3.967  1.00 66.76           O  
ATOM   5943  OD2 ASP D 110     -52.900   3.336  -2.146  1.00 71.96           O  
ATOM   5944  N   VAL D 111     -53.263   3.412  -6.435  1.00 60.31           N  
ATOM   5945  CA  VAL D 111     -54.256   2.782  -7.296  1.00 59.83           C  
ATOM   5946  C   VAL D 111     -54.922   1.646  -6.514  1.00 62.40           C  
ATOM   5947  O   VAL D 111     -54.240   0.880  -5.834  1.00 62.07           O  
ATOM   5948  CB  VAL D 111     -53.619   2.231  -8.594  1.00 59.40           C  
ATOM   5949  CG1 VAL D 111     -54.684   1.614  -9.517  1.00 57.95           C  
ATOM   5950  CG2 VAL D 111     -52.848   3.329  -9.325  1.00 56.62           C  
ATOM   5951  N   ILE D 112     -56.252   1.556  -6.597  1.00 63.20           N  
ATOM   5952  CA  ILE D 112     -57.009   0.526  -5.880  1.00 63.04           C  
ATOM   5953  C   ILE D 112     -58.069  -0.113  -6.784  1.00 62.32           C  
ATOM   5954  O   ILE D 112     -58.869   0.593  -7.404  1.00 62.93           O  
ATOM   5955  CB  ILE D 112     -57.710   1.086  -4.599  1.00 64.37           C  
ATOM   5956  CG1 ILE D 112     -56.739   1.875  -3.710  1.00 63.98           C  
ATOM   5957  CG2 ILE D 112     -58.363  -0.039  -3.795  1.00 64.44           C  
ATOM   5958  CD1 ILE D 112     -56.792   3.383  -3.905  1.00 67.05           C  
ATOM   5959  N   ARG D 113     -58.064  -1.445  -6.846  1.00 59.66           N  
ATOM   5960  CA  ARG D 113     -59.097  -2.215  -7.552  1.00 58.91           C  
ATOM   5961  C   ARG D 113     -60.276  -2.500  -6.612  1.00 57.17           C  
ATOM   5962  O   ARG D 113     -60.107  -3.115  -5.561  1.00 59.32           O  
ATOM   5963  CB  ARG D 113     -58.506  -3.521  -8.108  1.00 56.73           C  
ATOM   5964  CG  ARG D 113     -59.499  -4.449  -8.802  1.00 56.31           C  
ATOM   5965  CD  ARG D 113     -58.804  -5.600  -9.544  1.00 57.06           C  
ATOM   5966  NE  ARG D 113     -58.025  -5.130 -10.692  1.00 57.24           N  
ATOM   5967  CZ  ARG D 113     -56.701  -5.219 -10.817  1.00 61.96           C  
ATOM   5968  NH1 ARG D 113     -55.957  -5.791  -9.876  1.00 55.08           N  
ATOM   5969  NH2 ARG D 113     -56.115  -4.747 -11.911  1.00 61.69           N  
ATOM   5970  N   VAL D 114     -61.463  -2.046  -6.999  1.00 55.94           N  
ATOM   5971  CA  VAL D 114     -62.659  -2.164  -6.158  1.00 55.33           C  
ATOM   5972  C   VAL D 114     -63.050  -3.611  -5.829  1.00 57.13           C  
ATOM   5973  O   VAL D 114     -63.391  -3.921  -4.682  1.00 59.33           O  
ATOM   5974  CB  VAL D 114     -63.862  -1.402  -6.778  1.00 54.54           C  
ATOM   5975  CG1 VAL D 114     -65.131  -1.634  -5.972  1.00 58.17           C  
ATOM   5976  CG2 VAL D 114     -63.564   0.091  -6.859  1.00 49.33           C  
ATOM   5977  N   ARG D 115     -62.988  -4.489  -6.828  1.00 58.21           N  
ATOM   5978  CA  ARG D 115     -63.430  -5.877  -6.684  1.00 57.81           C  
ATOM   5979  C   ARG D 115     -62.640  -6.675  -5.645  1.00 60.01           C  
ATOM   5980  O   ARG D 115     -63.210  -7.495  -4.924  1.00 61.22           O  
ATOM   5981  CB  ARG D 115     -63.378  -6.591  -8.037  1.00 56.89           C  
ATOM   5982  CG  ARG D 115     -63.857  -8.038  -8.006  1.00 60.54           C  
ATOM   5983  CD  ARG D 115     -63.887  -8.641  -9.392  1.00 60.79           C  
ATOM   5984  NE  ARG D 115     -62.608  -8.486 -10.082  1.00 58.99           N  
ATOM   5985  CZ  ARG D 115     -61.625  -9.383 -10.061  1.00 58.84           C  
ATOM   5986  NH1 ARG D 115     -61.755 -10.517  -9.378  1.00 56.24           N  
ATOM   5987  NH2 ARG D 115     -60.504  -9.140 -10.726  1.00 52.11           N  
ATOM   5988  N   THR D 116     -61.336  -6.426  -5.575  1.00 61.21           N  
ATOM   5989  CA  THR D 116     -60.432  -7.227  -4.749  1.00 60.98           C  
ATOM   5990  C   THR D 116     -59.895  -6.462  -3.539  1.00 62.47           C  
ATOM   5991  O   THR D 116     -59.715  -7.036  -2.467  1.00 62.25           O  
ATOM   5992  CB  THR D 116     -59.235  -7.743  -5.575  1.00 61.59           C  
ATOM   5993  OG1 THR D 116     -58.557  -6.630  -6.173  1.00 59.53           O  
ATOM   5994  CG2 THR D 116     -59.704  -8.696  -6.675  1.00 57.71           C  
ATOM   5995  N   GLY D 117     -59.639  -5.169  -3.716  1.00 63.41           N  
ATOM   5996  CA  GLY D 117     -59.059  -4.351  -2.655  1.00 65.50           C  
ATOM   5997  C   GLY D 117     -57.555  -4.236  -2.793  1.00 66.88           C  
ATOM   5998  O   GLY D 117     -56.887  -3.647  -1.939  1.00 68.42           O  
ATOM   5999  N   GLU D 118     -57.024  -4.811  -3.873  1.00 67.01           N  
ATOM   6000  CA  GLU D 118     -55.606  -4.730  -4.195  1.00 68.10           C  
ATOM   6001  C   GLU D 118     -55.180  -3.268  -4.314  1.00 68.89           C  
ATOM   6002  O   GLU D 118     -55.852  -2.473  -4.973  1.00 69.94           O  
ATOM   6003  CB  GLU D 118     -55.317  -5.468  -5.504  1.00 68.09           C  
ATOM   6004  CG  GLU D 118     -55.468  -6.984  -5.427  1.00 68.13           C  
ATOM   6005  CD  GLU D 118     -55.518  -7.645  -6.799  1.00 71.00           C  
ATOM   6006  OE1 GLU D 118     -56.420  -7.312  -7.607  1.00 72.33           O  
ATOM   6007  OE2 GLU D 118     -54.654  -8.508  -7.069  1.00 73.28           O  
ATOM   6008  N   ARG D 119     -54.077  -2.928  -3.656  1.00 68.99           N  
ATOM   6009  CA  ARG D 119     -53.530  -1.574  -3.663  1.00 70.21           C  
ATOM   6010  C   ARG D 119     -52.263  -1.539  -4.512  1.00 71.26           C  
ATOM   6011  O   ARG D 119     -51.671  -2.582  -4.797  1.00 70.87           O  
ATOM   6012  CB  ARG D 119     -53.169  -1.133  -2.239  1.00 71.96           C  
ATOM   6013  CG  ARG D 119     -54.303  -1.144  -1.214  1.00 75.18           C  
ATOM   6014  CD  ARG D 119     -55.038   0.180  -1.203  1.00 77.49           C  
ATOM   6015  NE  ARG D 119     -55.489   0.587   0.131  1.00 80.62           N  
ATOM   6016  CZ  ARG D 119     -56.675   0.288   0.660  1.00 82.09           C  
ATOM   6017  NH1 ARG D 119     -57.557  -0.445  -0.013  1.00 81.71           N  
ATOM   6018  NH2 ARG D 119     -56.981   0.724   1.874  1.00 81.15           N  
ATOM   6019  N   GLY D 120     -51.851  -0.337  -4.908  1.00 72.42           N  
ATOM   6020  CA  GLY D 120     -50.557  -0.123  -5.561  1.00 73.99           C  
ATOM   6021  C   GLY D 120     -50.290  -0.938  -6.813  1.00 75.18           C  
ATOM   6022  O   GLY D 120     -51.142  -1.028  -7.699  1.00 73.30           O  
ATOM   6023  N   GLU D 121     -49.102  -1.541  -6.872  1.00 76.93           N  
ATOM   6024  CA  GLU D 121     -48.613  -2.232  -8.074  1.00 79.59           C  
ATOM   6025  C   GLU D 121     -49.509  -3.380  -8.548  1.00 78.83           C  
ATOM   6026  O   GLU D 121     -49.691  -3.574  -9.755  1.00 77.04           O  
ATOM   6027  CB  GLU D 121     -47.176  -2.733  -7.872  1.00 80.25           C  
ATOM   6028  CG  GLU D 121     -46.154  -1.626  -7.610  1.00 87.14           C  
ATOM   6029  CD  GLU D 121     -44.726  -2.060  -7.900  1.00 90.65           C  
ATOM   6030  OE1 GLU D 121     -44.366  -2.178  -9.093  1.00 93.76           O  
ATOM   6031  OE2 GLU D 121     -43.961  -2.271  -6.935  1.00 88.24           O  
ATOM   6032  N   LYS D 122     -50.055  -4.132  -7.595  1.00 78.37           N  
ATOM   6033  CA  LYS D 122     -50.972  -5.230  -7.891  1.00 78.85           C  
ATOM   6034  C   LYS D 122     -52.260  -4.724  -8.546  1.00 77.58           C  
ATOM   6035  O   LYS D 122     -52.776  -5.351  -9.471  1.00 78.25           O  
ATOM   6036  CB  LYS D 122     -51.273  -6.041  -6.624  1.00 78.51           C  
ATOM   6037  CG  LYS D 122     -50.109  -6.920  -6.174  1.00 82.45           C  
ATOM   6038  CD  LYS D 122     -50.371  -7.611  -4.842  1.00 82.34           C  
ATOM   6039  CE  LYS D 122     -49.139  -8.394  -4.398  1.00 88.13           C  
ATOM   6040  NZ  LYS D 122     -49.280  -8.982  -3.037  1.00 87.84           N  
ATOM   6041  N   ALA D 123     -52.752  -3.579  -8.076  1.00 76.38           N  
ATOM   6042  CA  ALA D 123     -53.967  -2.966  -8.617  1.00 75.94           C  
ATOM   6043  C   ALA D 123     -53.757  -2.372 -10.009  1.00 77.01           C  
ATOM   6044  O   ALA D 123     -54.685  -2.343 -10.819  1.00 76.49           O  
ATOM   6045  CB  ALA D 123     -54.494  -1.909  -7.670  1.00 74.82           C  
ATOM   6046  N   GLU D 124     -52.542  -1.898 -10.279  1.00 76.53           N  
ATOM   6047  CA  GLU D 124     -52.215  -1.316 -11.576  1.00 77.81           C  
ATOM   6048  C   GLU D 124     -51.973  -2.399 -12.632  1.00 78.49           C  
ATOM   6049  O   GLU D 124     -52.255  -2.188 -13.816  1.00 80.12           O  
ATOM   6050  CB  GLU D 124     -51.009  -0.377 -11.455  1.00 78.16           C  
ATOM   6051  CG  GLU D 124     -50.670   0.420 -12.717  1.00 79.72           C  
ATOM   6052  CD  GLU D 124     -49.707  -0.303 -13.663  1.00 81.61           C  
ATOM   6053  OE1 GLU D 124     -49.071  -1.304 -13.259  1.00 84.04           O  
ATOM   6054  OE2 GLU D 124     -49.585   0.138 -14.823  1.00 84.82           O  
ATOM   6055  N   LYS D 125     -51.465  -3.552 -12.199  1.00 78.31           N  
ATOM   6056  CA  LYS D 125     -51.130  -4.640 -13.115  1.00 80.60           C  
ATOM   6057  C   LYS D 125     -52.377  -5.319 -13.690  1.00 80.67           C  
ATOM   6058  O   LYS D 125     -53.301  -5.679 -12.958  1.00 80.50           O  
ATOM   6059  CB  LYS D 125     -50.214  -5.674 -12.440  1.00 79.14           C  
ATOM   6060  CG  LYS D 125     -49.497  -6.584 -13.430  1.00 80.07           C  
ATOM   6061  CD  LYS D 125     -48.663  -7.648 -12.739  1.00 84.67           C  
ATOM   6062  CE  LYS D 125     -47.907  -8.498 -13.758  1.00 88.43           C  
ATOM   6063  NZ  LYS D 125     -46.843  -9.324 -13.117  1.00 87.54           N  
ATOM   6064  N   MET D 126     -52.383  -5.476 -15.011  1.00 82.19           N  
ATOM   6065  CA  MET D 126     -53.444  -6.181 -15.723  1.00 84.95           C  
ATOM   6066  C   MET D 126     -52.824  -7.449 -16.300  1.00 88.14           C  
ATOM   6067  O   MET D 126     -51.827  -7.372 -17.016  1.00 88.46           O  
ATOM   6068  CB  MET D 126     -54.017  -5.299 -16.839  1.00 83.28           C  
ATOM   6069  CG  MET D 126     -54.281  -3.844 -16.435  1.00 78.46           C  
ATOM   6070  SD  MET D 126     -55.690  -3.629 -15.318  1.00 72.27           S  
ATOM   6071  CE  MET D 126     -57.045  -3.590 -16.488  1.00 74.13           C  
ATOM   6072  N   THR D 127     -53.406  -8.607 -15.984  1.00 93.53           N  
ATOM   6073  CA  THR D 127     -52.782  -9.909 -16.292  1.00 98.34           C  
ATOM   6074  C   THR D 127     -52.707 -10.271 -17.788  1.00101.63           C  
ATOM   6075  O   THR D 127     -53.226 -11.309 -18.211  1.00101.67           O  
ATOM   6076  CB  THR D 127     -53.426 -11.073 -15.484  1.00 98.88           C  
ATOM   6077  OG1 THR D 127     -54.854 -10.982 -15.555  1.00 97.04           O  
ATOM   6078  CG2 THR D 127     -52.977 -11.039 -14.017  1.00100.00           C  
ATOM   6079  N   GLY D 128     -52.039  -9.423 -18.571  1.00105.40           N  
ATOM   6080  CA  GLY D 128     -51.825  -9.661 -20.002  1.00109.29           C  
ATOM   6081  C   GLY D 128     -51.116  -8.519 -20.718  1.00112.41           C  
ATOM   6082  O   GLY D 128     -51.513  -8.135 -21.821  1.00112.88           O  
ATOM   6083  N   ASP D 129     -50.061  -7.988 -20.094  1.00115.52           N  
ATOM   6084  CA  ASP D 129     -49.318  -6.837 -20.635  1.00117.77           C  
ATOM   6085  C   ASP D 129     -47.801  -7.057 -20.828  1.00119.88           C  
ATOM   6086  O   ASP D 129     -46.999  -6.792 -19.925  1.00119.85           O  
ATOM   6087  CB  ASP D 129     -49.598  -5.554 -19.817  1.00116.71           C  
ATOM   6088  CG  ASP D 129     -49.506  -5.762 -18.297  1.00115.97           C  
ATOM   6089  OD1 ASP D 129     -48.978  -6.801 -17.837  1.00114.63           O  
ATOM   6090  OD2 ASP D 129     -49.970  -4.868 -17.555  1.00110.70           O  
ATOM   6091  N   MET D 130     -47.424  -7.545 -22.012  1.00122.10           N  
ATOM   6092  CA  MET D 130     -46.015  -7.628 -22.418  1.00123.96           C  
ATOM   6093  C   MET D 130     -45.841  -7.457 -23.932  1.00123.97           C  
ATOM   6094  O   MET D 130     -46.563  -6.687 -24.571  1.00123.88           O  
ATOM   6095  CB  MET D 130     -45.352  -8.929 -21.929  1.00124.09           C  
ATOM   6096  CG  MET D 130     -45.676 -10.187 -22.738  1.00125.23           C  
ATOM   6097  SD  MET D 130     -44.580 -11.579 -22.356  1.00126.18           S  
ATOM   6098  CE  MET D 130     -43.061 -11.103 -23.189  1.00125.04           C  
TER    6099      MET D 130                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
