
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  153 ( 1166),  selected  153 , name 2iab_A
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2iab_A.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    P     5_A      -       -           -
LGA    A     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    K    10_A      E       4          2.325
LGA    Q    11_A      -       -           -
LGA    R    12_A      L       5          3.929
LGA    I    13_A      E       6          2.880
LGA    Q    14_A      D       7          1.122
LGA    D    15_A      K       8          1.990
LGA    T    16_A      I       9          1.575
LGA    L    17_A      L      10          0.538
LGA    N    18_A      A      11          1.467
LGA    R    19_A      I      12          1.592
LGA    L    20_A      L      13          1.013
LGA    E    21_A      E      14          2.294
LGA    L    22_A      Q      15          2.663
LGA    D    23_A      H      16          1.469
LGA    V    24_A      Q      17          1.446
LGA    D    25_A      V      18          1.541
LGA    A    26_A      G      19          1.616
LGA    W    27_A      V      20          0.683
LGA    V    28_A      L      21          0.612
LGA    S    29_A      T      22          0.468
LGA    T    30_A      S      23          0.506
LGA    A    31_A      V      24          0.742
LGA    G    32_A      Q      25          0.645
LGA    A    33_A      G      26          2.823
LGA    D    34_A      -       -           -
LGA    G    35_A      D      27          1.373
LGA    G    36_A      -       -           -
LGA    A    37_A      F      28          0.924
LGA    P    38_A      P      29          1.089
LGA    Y    39_A      H      30          0.500
LGA    L    40_A      A      31          0.893
LGA    V    41_A      R      32          0.811
LGA    P    42_A      Y      33          1.280
LGA    L    43_A      M      34          1.596
LGA    S    44_A      T      35          1.163
LGA    Y    45_A      F      36          1.633
LGA    L    46_A      L      37          1.443
LGA    W    47_A      H      38          0.533
LGA    D    48_A      D      39          0.456
LGA    G    49_A      G      40          0.492
LGA    E    50_A      L      41          3.689
LGA    T    51_A      T      42          1.320
LGA    F    52_A      L      43          1.039
LGA    L    53_A      Y      44          1.195
LGA    V    54_A      T      45          1.250
LGA    A    55_A      P      46          1.781
LGA    T    56_A      S      47          1.028
LGA    P    57_A      G      48          1.498
LGA    A    58_A      K      49          2.319
LGA    A    59_A      E      50          2.133
LGA    S    60_A      L      51          1.747
LGA    P    61_A      P      52          1.963
LGA    T    62_A      K      53          1.005
LGA    G    63_A      T      54          0.892
LGA    R    64_A      E      55          1.131
LGA    N    65_A      E      56          0.831
LGA    L    66_A      V      57          0.553
LGA    S    67_A      R      58          0.747
LGA    E    68_A      R      59          0.583
LGA    T    69_A      N      60          0.503
LGA    G    70_A      P      61          0.924
LGA    R    71_A      H      62          1.155
LGA    V    72_A      V      63          0.780
LGA    R    73_A      C      64          0.763
LGA    L    74_A      V      65          0.623
LGA    G    75_A      L      66          0.712
LGA    I    76_A      I      67          0.367
LGA    G    77_A      G      68          0.812
LGA    P    78_A      Y      69          2.448
LGA    T    79_A      D      70          3.263
LGA    -       -      S      71           -
LGA    -       -      P      72           -
LGA    R    80_A      G      73          3.474
LGA    -       -      S      74           -
LGA    D    81_A      A      75          2.273
LGA    L    82_A      F      76          1.246
LGA    V    83_A      L      77          0.739
LGA    L    84_A      E      78          0.832
LGA    V    85_A      I      79          0.368
LGA    E    86_A      N      80          0.310
LGA    G    87_A      G      81          0.342
LGA    T    88_A      L      82          0.310
LGA    A    89_A      A      83          1.044
LGA    L    90_A      S      84          1.387
LGA    P    91_A      L      85          1.211
LGA    L    92_A      E      86          2.520
LGA    E    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    A    95_A      E      87           #
LGA    G    96_A      D      88          3.805
LGA    L    97_A      E      89          2.273
LGA    P    98_A      S      90          3.627
LGA    D    99_A      -       -           -
LGA    G   100_A      I      91          5.270
LGA    V   101_A      K      92          5.240
LGA    G   102_A      E      93          2.304
LGA    D   103_A      R      94          2.086
LGA    T   104_A      I      95          4.499
LGA    F   105_A      W      96          5.099
LGA    A   106_A      E      97          2.961
LGA    E   107_A      N      98          1.831
LGA    K   108_A      -       -           -
LGA    T   109_A      I      99          3.250
LGA    G   110_A      S     100          3.632
LGA    F   111_A      K     101           #
LGA    -       -      D     102           -
LGA    -       -      W     103           -
LGA    D   112_A      F     104           #
LGA    P   113_A      Q     105           -
LGA    -       -      G     106           -
LGA    R   114_A      E     107           #
LGA    R   115_A      D     108          1.890
LGA    L   116_A      S     109          2.521
LGA    T   117_A      P     110          4.972
LGA    T   118_A      S     111          3.712
LGA    S   119_A      -       -           -
LGA    Y   120_A      F     112          3.002
LGA    L   121_A      V     113          2.432
LGA    Y   122_A      V     114          1.280
LGA    F   123_A      I     115          1.628
LGA    R   124_A      K     116          1.252
LGA    I   125_A      I     117          0.917
LGA    S   126_A      V     118          0.568
LGA    P   127_A      P     119          0.222
LGA    R   128_A      E     120          0.257
LGA    R   129_A      Q     121          0.424
LGA    V   130_A      I     122          0.464
LGA    Q   131_A      R     123          0.755
LGA    A   132_A      I     124          0.833
LGA    W   133_A      L     125          2.344
LGA    R   134_A      N     126          2.577
LGA    E   135_A      -       -           -
LGA    A   136_A      -       -           -
LGA    N   137_A      -       -           -
LGA    E   138_A      S     127          3.963
LGA    L   139_A      -       -           -
LGA    S   140_A      -       -           -
LGA    G   141_A      -       -           -
LGA    R   142_A      -       -           -
LGA    E   143_A      -       -           -
LGA    L   144_A      -       -           -
LGA    X   145_A      -       -           -
LGA    R   146_A      -       -           -
LGA    D   147_A      -       -           -
LGA    G   148_A      -       -           -
LGA    E   149_A      -       -           -
LGA    W   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    V   152_A      -       -           -
LGA    T   153_A      -       -           -
LGA    D   154_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  153  124    5.0    113    2.04    14.16     73.713     5.271

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.141875 * X  +  -0.255205 * Y  +   0.956422 * Z  + -68.833351
  Y_new =   0.478291 * X  +  -0.863598 * Y  +  -0.159487 * Z  +  38.124374
  Z_new =   0.866666 * X  +   0.434820 * Y  +   0.244585 * Z  + -32.544765 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.058410   -2.083183  [ DEG:    60.6424   -119.3576 ]
  Theta =  -1.048480   -2.093113  [ DEG:   -60.0735   -119.9265 ]
  Phi   =   1.859157   -1.282435  [ DEG:   106.5219    -73.4781 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2iab_A                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2iab_A.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  153  124   5.0  113   2.04   14.16  73.713
REMARK  ---------------------------------------------------------- 
MOLECULE 2iab_A
HEADER    UNKNOWN FUNCTION                        07-SEP-06   2IAB              
TITLE     CRYSTAL STRUCTURE OF A PROTEIN WITH FMN-BINDING SPLIT                 
TITLE    2 BARREL FOLD (NP_828636.1) FROM STREPTOMYCES AVERMITILIS AT           
TITLE    3 2.00 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES AVERMITILIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_828636.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_828636.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   19-SEP-06 2IAB    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_828636.1) FROM STREPTOMYCES AVERMITILIS AT               
JRNL        TITL 3 2.00 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2IAB A    1   154  UNP    Q825J7   Q825J7_STRAW     1    154             
DBREF  2IAB B    1   154  UNP    Q825J7   Q825J7_STRAW     1    154             
SEQRES   1 A  155  GLY MSE THR THR PRO PRO ALA ARG THR ALA LYS GLN ARG          
SEQRES   2 A  155  ILE GLN ASP THR LEU ASN ARG LEU GLU LEU ASP VAL ASP          
SEQRES   3 A  155  ALA TRP VAL SER THR ALA GLY ALA ASP GLY GLY ALA PRO          
SEQRES   4 A  155  TYR LEU VAL PRO LEU SER TYR LEU TRP ASP GLY GLU THR          
SEQRES   5 A  155  PHE LEU VAL ALA THR PRO ALA ALA SER PRO THR GLY ARG          
SEQRES   6 A  155  ASN LEU SER GLU THR GLY ARG VAL ARG LEU GLY ILE GLY          
SEQRES   7 A  155  PRO THR ARG ASP LEU VAL LEU VAL GLU GLY THR ALA LEU          
SEQRES   8 A  155  PRO LEU GLU PRO ALA GLY LEU PRO ASP GLY VAL GLY ASP          
SEQRES   9 A  155  THR PHE ALA GLU LYS THR GLY PHE ASP PRO ARG ARG LEU          
SEQRES  10 A  155  THR THR SER TYR LEU TYR PHE ARG ILE SER PRO ARG ARG          
SEQRES  11 A  155  VAL GLN ALA TRP ARG GLU ALA ASN GLU LEU SER GLY ARG          
SEQRES  12 A  155  GLU LEU MSE ARG ASP GLY GLU TRP LEU VAL THR ASP              
SEQRES   1 B  155  GLY MSE THR THR PRO PRO ALA ARG THR ALA LYS GLN ARG          
SEQRES   2 B  155  ILE GLN ASP THR LEU ASN ARG LEU GLU LEU ASP VAL ASP          
SEQRES   3 B  155  ALA TRP VAL SER THR ALA GLY ALA ASP GLY GLY ALA PRO          
SEQRES   4 B  155  TYR LEU VAL PRO LEU SER TYR LEU TRP ASP GLY GLU THR          
SEQRES   5 B  155  PHE LEU VAL ALA THR PRO ALA ALA SER PRO THR GLY ARG          
SEQRES   6 B  155  ASN LEU SER GLU THR GLY ARG VAL ARG LEU GLY ILE GLY          
SEQRES   7 B  155  PRO THR ARG ASP LEU VAL LEU VAL GLU GLY THR ALA LEU          
SEQRES   8 B  155  PRO LEU GLU PRO ALA GLY LEU PRO ASP GLY VAL GLY ASP          
SEQRES   9 B  155  THR PHE ALA GLU LYS THR GLY PHE ASP PRO ARG ARG LEU          
SEQRES  10 B  155  THR THR SER TYR LEU TYR PHE ARG ILE SER PRO ARG ARG          
SEQRES  11 B  155  VAL GLN ALA TRP ARG GLU ALA ASN GLU LEU SER GLY ARG          
SEQRES  12 B  155  GLU LEU MSE ARG ASP GLY GLU TRP LEU VAL THR ASP              
HET    MSE  A 145       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B 145       8                                                       
HET    IPA      1       4                                                       
HET    IPA      2       4                                                       
HET    IPA      3       4                                                       
HET    IPA      4       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     IPA ISOPROPYL ALCOHOL                                                
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   3  IPA    4(C3 H8 O)                                                   
FORMUL   7  HOH   *234(H2 O)                                                    
CRYST1   87.890   87.890  151.580  90.00  90.00 120.00 P 65 2 2     24          
ATOM      1  N   THR A   2      -1.639  -8.673  25.683  1.00 58.67           N  
ATOM      2  CA  THR A   2      -1.270  -9.102  24.302  1.00 57.31           C  
ATOM      3  C   THR A   2      -1.651  -8.008  23.282  1.00 57.06           C  
ATOM      4  O   THR A   2      -2.377  -7.053  23.610  1.00 57.07           O  
ATOM      5  CB  THR A   2      -1.900 -10.504  23.946  1.00 56.04           C  
ATOM      6  N   THR A   3      -1.124  -8.134  22.060  1.00 57.17           N  
ATOM      7  CA  THR A   3      -1.515  -7.274  20.932  1.00 55.96           C  
ATOM      8  C   THR A   3      -2.979  -7.585  20.535  1.00 55.08           C  
ATOM      9  O   THR A   3      -3.258  -8.648  19.967  1.00 55.50           O  
ATOM     10  N   PRO A   4      -3.916  -6.673  20.850  1.00 53.30           N  
ATOM     11  CA  PRO A   4      -5.302  -6.901  20.444  1.00 53.45           C  
ATOM     12  C   PRO A   4      -5.470  -6.805  18.925  1.00 52.13           C  
ATOM     13  O   PRO A   4      -4.722  -6.033  18.276  1.00 52.02           O  
ATOM     14  CB  PRO A   4      -6.069  -5.728  21.094  1.00 53.00           C  
ATOM     15  CG  PRO A   4      -5.117  -5.126  22.097  1.00 57.64           C  
ATOM     16  CD  PRO A   4      -3.758  -5.381  21.539  1.00 54.54           C  
ATOM     17  N   PRO A   5      -6.475  -7.523  18.362  1.00 49.60           N  
ATOM     18  CA  PRO A   5      -6.736  -7.427  16.917  1.00 48.60           C  
ATOM     19  C   PRO A   5      -6.929  -5.963  16.464  1.00 46.62           C  
ATOM     20  O   PRO A   5      -7.350  -5.114  17.271  1.00 45.60           O  
ATOM     21  CB  PRO A   5      -8.023  -8.247  16.731  1.00 48.40           C  
ATOM     22  CG  PRO A   5      -8.644  -8.256  18.102  1.00 49.62           C  
ATOM     23  CD  PRO A   5      -7.456  -8.407  19.010  1.00 49.23           C  
ATOM     24  N   ALA A   6      -6.574  -5.690  15.205  1.00 45.74           N  
ATOM     25  CA  ALA A   6      -6.700  -4.370  14.602  1.00 45.34           C  
ATOM     26  C   ALA A   6      -8.128  -3.864  14.770  1.00 47.44           C  
ATOM     27  O   ALA A   6      -9.099  -4.606  14.501  1.00 46.02           O  
ATOM     28  CB  ALA A   6      -6.341  -4.407  13.105  1.00 45.41           C  
ATOM     29  N   ARG A   7      -8.249  -2.603  15.198  1.00 44.98           N  
ATOM     30  CA  ARG A   7      -9.560  -1.972  15.314  1.00 45.41           C  
ATOM     31  C   ARG A   7     -10.126  -1.653  13.921  1.00 45.49           C  
ATOM     32  O   ARG A   7      -9.360  -1.254  12.989  1.00 41.41           O  
ATOM     33  CB  ARG A   7      -9.475  -0.654  16.119  1.00 46.05           C  
ATOM     34  CG  ARG A   7      -9.028  -0.781  17.575  1.00 43.73           C  
ATOM     35  CD  ARG A   7      -8.677   0.589  18.146  1.00 43.27           C  
ATOM     36  NE  ARG A   7      -7.495   1.187  17.496  1.00 44.41           N  
ATOM     37  CZ  ARG A   7      -7.090   2.449  17.632  1.00 41.91           C  
ATOM     38  NH1 ARG A   7      -7.736   3.292  18.431  1.00 38.46           N  
ATOM     39  NH2 ARG A   7      -5.992   2.862  16.991  1.00 39.52           N  
ATOM     40  N   THR A   8     -11.459  -1.817  13.803  1.00 44.30           N  
ATOM     41  CA  THR A   8     -12.233  -1.269  12.660  1.00 44.91           C  
ATOM     42  C   THR A   8     -12.184   0.271  12.558  1.00 43.28           C  
ATOM     43  O   THR A   8     -11.889   0.984  13.532  1.00 42.10           O  
ATOM     44  CB  THR A   8     -13.748  -1.648  12.705  1.00 45.23           C  
ATOM     45  OG1 THR A   8     -14.461  -0.734  13.558  1.00 48.81           O  
ATOM     46  CG2 THR A   8     -13.939  -3.070  13.156  1.00 48.18           C  
ATOM     47  N   ALA A   9     -12.521   0.767  11.374  1.00 41.79           N  
ATOM     48  CA  ALA A   9     -12.544   2.216  11.084  1.00 39.08           C  
ATOM     49  C   ALA A   9     -13.520   3.017  11.974  1.00 35.44           C  
ATOM     50  O   ALA A   9     -13.147   4.052  12.514  1.00 36.75           O  
ATOM     51  CB  ALA A   9     -12.876   2.449   9.591  1.00 41.49           C  
ATOM     52  N   LYS A  10     -14.748   2.541  12.121  1.00 38.21           N  
ATOM     53  CA  LYS A  10     -15.713   3.143  13.055  1.00 40.86           C  
ATOM     54  C   LYS A  10     -15.172   3.196  14.507  1.00 39.79           C  
ATOM     55  O   LYS A  10     -15.255   4.221  15.158  1.00 36.97           O  
ATOM     56  CB  LYS A  10     -17.054   2.421  12.989  1.00 40.57           C  
ATOM     57  CG  LYS A  10     -18.240   3.196  13.583  1.00 44.91           C  
ATOM     58  CD  LYS A  10     -19.535   2.382  13.438  1.00 49.10           C  
ATOM     59  CE  LYS A  10     -20.647   2.895  14.345  1.00 53.22           C  
ATOM     60  N   GLN A  11     -14.586   2.113  14.997  0.50 41.45           N  
ATOM     62  CA  GLN A  11     -14.076   2.106  16.382  0.50 40.26           C  
ATOM     64  C   GLN A  11     -12.793   2.935  16.509  0.50 38.26           C  
ATOM     66  O   GLN A  11     -12.576   3.586  17.547  0.50 33.33           O  
ATOM     68  CB  GLN A  11     -13.842   0.674  16.903  0.50 40.86           C  
ATOM     70  CG  GLN A  11     -14.411   0.374  18.320  0.50 43.07           C  
ATOM     72  CD  GLN A  11     -13.600   0.955  19.474  0.50 44.21           C  
ATOM     74  OE1 GLN A  11     -12.556   0.412  19.878  0.50 49.24           O  
ATOM     76  NE2 GLN A  11     -14.102   2.049  20.039  0.50 33.14           N  
ATOM     78  N   ARG A  12     -11.942   2.920  15.476  1.00 35.94           N  
ATOM     79  CA  ARG A  12     -10.784   3.793  15.461  1.00 37.77           C  
ATOM     80  C   ARG A  12     -11.189   5.244  15.493  1.00 31.06           C  
ATOM     81  O   ARG A  12     -10.509   6.079  16.108  1.00 34.55           O  
ATOM     82  CB  ARG A  12      -9.850   3.556  14.240  1.00 38.22           C  
ATOM     83  CG  ARG A  12      -8.977   2.323  14.369  1.00 49.86           C  
ATOM     84  CD  ARG A  12      -7.755   2.355  13.436  1.00 43.96           C  
ATOM     85  NE  ARG A  12      -7.535   1.021  12.844  1.00 42.28           N  
ATOM     86  CZ  ARG A  12      -6.424   0.672  12.225  1.00 41.34           C  
ATOM     87  NH1 ARG A  12      -5.432   1.560  12.093  1.00 41.19           N  
ATOM     88  NH2 ARG A  12      -6.296  -0.543  11.723  1.00 41.02           N  
ATOM     89  N   ILE A  13     -12.251   5.587  14.788  1.00 31.74           N  
ATOM     90  CA  ILE A  13     -12.635   6.971  14.731  1.00 30.19           C  
ATOM     91  C   ILE A  13     -13.124   7.417  16.116  1.00 31.97           C  
ATOM     92  O   ILE A  13     -12.726   8.487  16.606  1.00 29.25           O  
ATOM     93  CB  ILE A  13     -13.642   7.262  13.627  1.00 31.49           C  
ATOM     94  CG1 ILE A  13     -12.923   7.275  12.258  1.00 33.95           C  
ATOM     95  CG2 ILE A  13     -14.243   8.672  13.824  1.00 32.18           C  
ATOM     96  CD1 ILE A  13     -13.859   7.156  11.079  1.00 36.05           C  
ATOM     97  N   GLN A  14     -14.011   6.614  16.718  1.00 31.71           N  
ATOM     98  CA  GLN A  14     -14.491   6.909  18.067  1.00 33.78           C  
ATOM     99  C   GLN A  14     -13.348   6.995  19.074  1.00 31.12           C  
ATOM    100  O   GLN A  14     -13.337   7.910  19.873  1.00 29.80           O  
ATOM    101  CB  GLN A  14     -15.510   5.880  18.556  1.00 32.29           C  
ATOM    102  CG  GLN A  14     -16.225   6.385  19.838  1.00 45.52           C  
ATOM    103  CD  GLN A  14     -16.735   7.851  19.730  1.00 55.15           C  
ATOM    104  OE1 GLN A  14     -17.601   8.156  18.876  1.00 50.61           O  
ATOM    105  NE2 GLN A  14     -16.175   8.771  20.587  1.00 40.71           N  
ATOM    106  N   ASP A  15     -12.404   6.064  19.021  1.00 29.73           N  
ATOM    107  CA  ASP A  15     -11.213   6.085  19.888  1.00 30.84           C  
ATOM    108  C   ASP A  15     -10.360   7.334  19.624  1.00 29.90           C  
ATOM    109  O   ASP A  15      -9.830   7.972  20.555  1.00 31.19           O  
ATOM    110  CB  ASP A  15     -10.283   4.901  19.653  1.00 31.37           C  
ATOM    111  CG  ASP A  15     -10.824   3.590  20.154  1.00 40.83           C  
ATOM    112  OD1 ASP A  15     -11.854   3.554  20.839  1.00 37.26           O  
ATOM    113  OD2 ASP A  15     -10.192   2.575  19.813  1.00 40.05           O  
ATOM    114  N   THR A  16     -10.212   7.679  18.361  1.00 28.71           N  
ATOM    115  CA  THR A  16      -9.447   8.877  17.990  1.00 28.07           C  
ATOM    116  C   THR A  16     -10.103  10.153  18.527  1.00 29.22           C  
ATOM    117  O   THR A  16      -9.442  11.007  19.103  1.00 29.40           O  
ATOM    118  CB  THR A  16      -9.236   8.943  16.463  1.00 28.83           C  
ATOM    119  OG1 THR A  16      -8.483   7.776  16.042  1.00 33.59           O  
ATOM    120  CG2 THR A  16      -8.557  10.214  16.045  1.00 34.67           C  
ATOM    121  N   LEU A  17     -11.408  10.273  18.342  1.00 29.59           N  
ATOM    122  CA  LEU A  17     -12.154  11.380  18.902  1.00 29.68           C  
ATOM    123  C   LEU A  17     -11.991  11.444  20.421  1.00 32.45           C  
ATOM    124  O   LEU A  17     -11.846  12.517  20.981  1.00 33.37           O  
ATOM    125  CB  LEU A  17     -13.647  11.259  18.544  1.00 30.22           C  
ATOM    126  CG  LEU A  17     -14.005  11.460  17.067  1.00 32.62           C  
ATOM    127  CD1 LEU A  17     -15.488  11.245  16.903  1.00 36.68           C  
ATOM    128  CD2 LEU A  17     -13.557  12.833  16.607  1.00 35.70           C  
ATOM    129  N   ASN A  18     -12.057  10.315  21.106  1.00 31.61           N  
ATOM    130  CA  ASN A  18     -11.845  10.334  22.579  1.00 31.64           C  
ATOM    131  C   ASN A  18     -10.423  10.852  22.943  1.00 29.22           C  
ATOM    132  O   ASN A  18     -10.239  11.556  23.912  1.00 30.87           O  
ATOM    133  CB  ASN A  18     -12.035   8.938  23.196  1.00 29.88           C  
ATOM    134  CG  ASN A  18     -13.495   8.390  23.081  1.00 38.56           C  
ATOM    135  OD1 ASN A  18     -14.456   9.132  22.829  1.00 38.84           O  
ATOM    136  ND2 ASN A  18     -13.636   7.084  23.271  1.00 29.90           N  
ATOM    137  N   ARG A  19      -9.423  10.438  22.176  1.00 30.63           N  
ATOM    138  CA  ARG A  19      -8.039  10.835  22.404  1.00 31.11           C  
ATOM    139  C   ARG A  19      -7.917  12.345  22.185  1.00 29.11           C  
ATOM    140  O   ARG A  19      -7.324  13.041  23.009  1.00 29.72           O  
ATOM    141  CB  ARG A  19      -7.101  10.040  21.486  1.00 27.79           C  
ATOM    142  CG  ARG A  19      -5.605  10.522  21.403  1.00 30.19           C  
ATOM    143  CD  ARG A  19      -4.898  10.355  22.696  1.00 29.33           C  
ATOM    144  NE  ARG A  19      -4.711   8.958  23.014  1.00 27.89           N  
ATOM    145  CZ  ARG A  19      -4.388   8.490  24.204  1.00 30.92           C  
ATOM    146  NH1 ARG A  19      -4.243   9.283  25.234  1.00 31.66           N  
ATOM    147  NH2 ARG A  19      -4.205   7.192  24.366  1.00 32.33           N  
ATOM    148  N   LEU A  20      -8.548  12.855  21.118  1.00 32.22           N  
ATOM    149  CA  LEU A  20      -8.495  14.289  20.816  1.00 28.50           C  
ATOM    150  C   LEU A  20      -9.146  15.101  21.927  1.00 30.94           C  
ATOM    151  O   LEU A  20      -8.654  16.186  22.241  1.00 32.79           O  
ATOM    152  CB  LEU A  20      -9.094  14.612  19.442  1.00 30.56           C  
ATOM    153  CG  LEU A  20      -8.397  13.959  18.202  1.00 26.68           C  
ATOM    154  CD1 LEU A  20      -9.029  14.410  16.937  1.00 32.45           C  
ATOM    155  CD2 LEU A  20      -6.891  14.287  18.191  1.00 29.31           C  
ATOM    156  N   GLU A  21     -10.228  14.592  22.521  1.00 29.05           N  
ATOM    157  CA  GLU A  21     -10.936  15.263  23.586  1.00 30.89           C  
ATOM    158  C   GLU A  21     -10.133  15.182  24.878  1.00 33.20           C  
ATOM    159  O   GLU A  21     -10.196  16.075  25.715  1.00 36.24           O  
ATOM    160  CB  GLU A  21     -12.322  14.648  23.830  1.00 31.21           C  
ATOM    161  CG  GLU A  21     -13.340  14.895  22.662  1.00 36.52           C  
ATOM    162  CD  GLU A  21     -13.900  16.364  22.540  1.00 45.24           C  
ATOM    163  OE1 GLU A  21     -13.548  17.214  23.377  1.00 38.72           O  
ATOM    164  OE2 GLU A  21     -14.698  16.672  21.576  1.00 39.97           O  
ATOM    165  N   LEU A  22      -9.353  14.114  25.036  1.00 32.37           N  
ATOM    166  CA  LEU A  22      -8.616  13.913  26.278  1.00 31.91           C  
ATOM    167  C   LEU A  22      -7.249  14.622  26.384  1.00 32.55           C  
ATOM    168  O   LEU A  22      -6.962  15.256  27.364  1.00 34.60           O  
ATOM    169  CB  LEU A  22      -8.422  12.422  26.491  1.00 35.10           C  
ATOM    170  CG  LEU A  22      -7.801  11.977  27.819  1.00 33.86           C  
ATOM    171  CD1 LEU A  22      -8.727  12.237  28.980  1.00 34.40           C  
ATOM    172  CD2 LEU A  22      -7.465  10.508  27.773  1.00 35.80           C  
ATOM    173  N   ASP A  23      -6.395  14.469  25.388  1.00 27.44           N  
ATOM    174  CA  ASP A  23      -5.035  14.963  25.476  1.00 28.79           C  
ATOM    175  C   ASP A  23      -5.008  16.508  25.473  1.00 32.25           C  
ATOM    176  O   ASP A  23      -5.902  17.169  24.955  1.00 33.08           O  
ATOM    177  CB  ASP A  23      -4.170  14.368  24.368  1.00 27.27           C  
ATOM    178  CG  ASP A  23      -3.664  12.970  24.716  1.00 31.84           C  
ATOM    179  OD1 ASP A  23      -4.340  12.264  25.502  1.00 34.78           O  
ATOM    180  OD2 ASP A  23      -2.593  12.584  24.211  1.00 39.52           O  
ATOM    181  N   VAL A  24      -4.018  17.045  26.127  1.00 31.24           N  
ATOM    182  CA  VAL A  24      -3.851  18.477  26.248  1.00 34.14           C  
ATOM    183  C   VAL A  24      -2.867  19.031  25.235  1.00 31.61           C  
ATOM    184  O   VAL A  24      -3.019  20.192  24.782  1.00 30.73           O  
ATOM    185  CB  VAL A  24      -3.354  18.835  27.678  1.00 35.15           C  
ATOM    186  CG1 VAL A  24      -3.248  20.357  27.845  1.00 43.12           C  
ATOM    187  CG2 VAL A  24      -4.311  18.301  28.694  1.00 44.03           C  
ATOM    188  N   ASP A  25      -1.829  18.246  24.955  1.00 28.16           N  
ATOM    189  CA  ASP A  25      -0.716  18.677  24.117  1.00 30.37           C  
ATOM    190  C   ASP A  25      -0.643  17.903  22.785  1.00 30.60           C  
ATOM    191  O   ASP A  25      -1.023  16.719  22.690  1.00 32.50           O  
ATOM    192  CB  ASP A  25       0.632  18.491  24.815  1.00 29.57           C  
ATOM    193  CG  ASP A  25       0.708  19.156  26.158  1.00 39.33           C  
ATOM    194  OD1 ASP A  25       0.200  20.281  26.330  1.00 33.94           O  
ATOM    195  OD2 ASP A  25       1.255  18.513  27.074  1.00 34.52           O  
ATOM    196  N   ALA A  26      -0.096  18.599  21.793  1.00 30.82           N  
ATOM    197  CA  ALA A  26       0.290  18.071  20.491  1.00 31.13           C  
ATOM    198  C   ALA A  26       1.680  18.497  20.109  1.00 32.41           C  
ATOM    199  O   ALA A  26       2.121  19.636  20.369  1.00 32.07           O  
ATOM    200  CB  ALA A  26      -0.619  18.561  19.421  1.00 28.82           C  
ATOM    201  N   TRP A  27       2.346  17.598  19.404  1.00 31.86           N  
ATOM    202  CA  TRP A  27       3.586  17.943  18.725  1.00 30.80           C  
ATOM    203  C   TRP A  27       3.189  18.702  17.450  1.00 31.29           C  
ATOM    204  O   TRP A  27       2.466  18.202  16.606  1.00 31.84           O  
ATOM    205  CB  TRP A  27       4.414  16.694  18.385  1.00 29.78           C  
ATOM    206  CG  TRP A  27       5.057  16.003  19.559  1.00 27.91           C  
ATOM    207  CD1 TRP A  27       4.517  14.999  20.303  1.00 33.43           C  
ATOM    208  CD2 TRP A  27       6.339  16.286  20.148  1.00 31.82           C  
ATOM    209  NE1 TRP A  27       5.381  14.630  21.299  1.00 36.32           N  
ATOM    210  CE2 TRP A  27       6.497  15.416  21.236  1.00 32.55           C  
ATOM    211  CE3 TRP A  27       7.351  17.228  19.882  1.00 30.57           C  
ATOM    212  CZ2 TRP A  27       7.638  15.411  22.030  1.00 31.53           C  
ATOM    213  CZ3 TRP A  27       8.496  17.229  20.669  1.00 28.61           C  
ATOM    214  CH2 TRP A  27       8.633  16.310  21.737  1.00 28.81           C  
ATOM    215  N   VAL A  28       3.679  19.920  17.306  1.00 29.44           N  
ATOM    216  CA  VAL A  28       3.242  20.810  16.233  1.00 30.19           C  
ATOM    217  C   VAL A  28       4.413  20.957  15.274  1.00 31.07           C  
ATOM    218  O   VAL A  28       5.463  21.546  15.604  1.00 29.72           O  
ATOM    219  CB  VAL A  28       2.800  22.144  16.769  1.00 30.45           C  
ATOM    220  CG1 VAL A  28       2.411  23.073  15.661  1.00 34.38           C  
ATOM    221  CG2 VAL A  28       1.614  21.926  17.742  1.00 33.67           C  
ATOM    222  N   SER A  29       4.208  20.420  14.067  1.00 29.77           N  
ATOM    223  CA  SER A  29       5.217  20.402  13.063  1.00 29.64           C  
ATOM    224  C   SER A  29       4.891  21.394  11.940  1.00 29.75           C  
ATOM    225  O   SER A  29       3.814  21.347  11.281  1.00 29.99           O  
ATOM    226  CB  SER A  29       5.301  18.984  12.501  1.00 33.17           C  
ATOM    227  OG  SER A  29       6.383  18.842  11.631  1.00 37.84           O  
ATOM    228  N   THR A  30       5.851  22.259  11.684  1.00 29.28           N  
ATOM    229  CA  THR A  30       5.734  23.352  10.701  1.00 28.65           C  
ATOM    230  C   THR A  30       7.012  23.445   9.889  1.00 30.51           C  
ATOM    231  O   THR A  30       8.013  22.743  10.155  1.00 26.52           O  
ATOM    232  CB  THR A  30       5.385  24.762  11.347  1.00 28.77           C  
ATOM    233  OG1 THR A  30       6.430  25.207  12.243  1.00 30.23           O  
ATOM    234  CG2 THR A  30       4.048  24.727  12.082  1.00 30.31           C  
ATOM    235  N   ALA A  31       6.973  24.313   8.863  1.00 30.54           N  
ATOM    236  CA  ALA A  31       8.093  24.521   7.974  1.00 29.91           C  
ATOM    237  C   ALA A  31       8.143  25.991   7.562  1.00 30.53           C  
ATOM    238  O   ALA A  31       7.102  26.614   7.387  1.00 30.16           O  
ATOM    239  CB  ALA A  31       7.963  23.641   6.756  1.00 34.22           C  
ATOM    240  N   GLY A  32       9.346  26.539   7.462  1.00 29.19           N  
ATOM    241  CA  GLY A  32       9.532  27.894   6.890  1.00 31.54           C  
ATOM    242  C   GLY A  32       9.153  27.959   5.420  1.00 35.20           C  
ATOM    243  O   GLY A  32       9.148  26.941   4.688  1.00 34.42           O  
ATOM    244  N   ALA A  33       8.875  29.187   4.989  1.00 40.99           N  
ATOM    245  CA  ALA A  33       8.405  29.494   3.653  1.00 42.05           C  
ATOM    246  C   ALA A  33       9.488  29.256   2.632  1.00 41.40           C  
ATOM    247  O   ALA A  33       9.165  28.932   1.499  1.00 41.99           O  
ATOM    248  CB  ALA A  33       7.904  30.939   3.575  1.00 45.62           C  
ATOM    249  N   ASP A  34      10.747  29.340   3.058  1.00 41.41           N  
ATOM    250  CA  ASP A  34      11.873  29.224   2.156  1.00 46.81           C  
ATOM    251  C   ASP A  34      12.533  27.828   1.987  1.00 48.22           C  
ATOM    252  O   ASP A  34      13.521  27.701   1.290  1.00 51.82           O  
ATOM    253  CB  ASP A  34      12.917  30.302   2.511  1.00 49.28           C  
ATOM    254  CG  ASP A  34      12.345  31.748   2.406  1.00 58.75           C  
ATOM    255  OD1 ASP A  34      11.648  32.075   1.406  1.00 55.78           O  
ATOM    256  OD2 ASP A  34      12.591  32.560   3.335  1.00 66.10           O  
ATOM    257  N   GLY A  35      12.008  26.769   2.579  1.00 47.06           N  
ATOM    258  CA  GLY A  35      12.398  25.422   2.133  1.00 46.28           C  
ATOM    259  C   GLY A  35      13.513  24.781   2.927  1.00 44.80           C  
ATOM    260  O   GLY A  35      14.436  25.454   3.379  1.00 46.94           O  
ATOM    261  N   GLY A  36      13.424  23.466   3.080  1.00 43.21           N  
ATOM    262  CA  GLY A  36      14.250  22.720   4.041  1.00 39.85           C  
ATOM    263  C   GLY A  36      14.444  23.366   5.408  1.00 36.70           C  
ATOM    264  O   GLY A  36      15.547  23.360   5.926  1.00 39.02           O  
ATOM    265  N   ALA A  37      13.384  23.912   6.001  1.00 32.08           N  
ATOM    266  CA  ALA A  37      13.467  24.498   7.339  1.00 30.02           C  
ATOM    267  C   ALA A  37      12.364  23.949   8.279  1.00 28.36           C  
ATOM    268  O   ALA A  37      11.397  24.671   8.657  1.00 28.34           O  
ATOM    269  CB  ALA A  37      13.378  26.029   7.240  1.00 31.32           C  
ATOM    270  N   PRO A  38      12.542  22.704   8.758  1.00 28.87           N  
ATOM    271  CA  PRO A  38      11.549  22.132   9.674  1.00 28.93           C  
ATOM    272  C   PRO A  38      11.571  22.769  11.067  1.00 26.44           C  
ATOM    273  O   PRO A  38      12.602  23.242  11.528  1.00 27.82           O  
ATOM    274  CB  PRO A  38      11.975  20.649   9.748  1.00 30.81           C  
ATOM    275  CG  PRO A  38      13.454  20.703   9.529  1.00 26.49           C  
ATOM    276  CD  PRO A  38      13.648  21.763   8.489  1.00 29.70           C  
ATOM    277  N   TYR A  39      10.440  22.728  11.748  1.00 28.26           N  
ATOM    278  CA  TYR A  39      10.362  23.174  13.127  1.00 29.19           C  
ATOM    279  C   TYR A  39       9.359  22.277  13.843  1.00 31.01           C  
ATOM    280  O   TYR A  39       8.313  21.950  13.271  1.00 31.10           O  
ATOM    281  CB  TYR A  39       9.944  24.663  13.183  1.00 30.64           C  
ATOM    282  CG  TYR A  39      10.231  25.281  14.518  1.00 31.95           C  
ATOM    283  CD1 TYR A  39      11.510  25.783  14.844  1.00 26.89           C  
ATOM    284  CD2 TYR A  39       9.272  25.307  15.473  1.00 31.23           C  
ATOM    285  CE1 TYR A  39      11.771  26.304  16.128  1.00 30.26           C  
ATOM    286  CE2 TYR A  39       9.515  25.831  16.736  1.00 35.51           C  
ATOM    287  CZ  TYR A  39      10.746  26.307  17.062  1.00 34.05           C  
ATOM    288  OH  TYR A  39      10.933  26.826  18.320  1.00 34.47           O  
ATOM    289  N   LEU A  40       9.701  21.884  15.074  1.00 29.98           N  
ATOM    290  CA  LEU A  40       8.885  21.030  15.884  1.00 30.94           C  
ATOM    291  C   LEU A  40       8.908  21.478  17.325  1.00 30.37           C  
ATOM    292  O   LEU A  40       9.987  21.701  17.914  1.00 28.14           O  
ATOM    293  CB  LEU A  40       9.401  19.596  15.755  1.00 29.95           C  
ATOM    294  CG  LEU A  40       8.636  18.520  16.521  1.00 26.98           C  
ATOM    295  CD1 LEU A  40       7.298  18.328  15.922  1.00 27.32           C  
ATOM    296  CD2 LEU A  40       9.439  17.229  16.464  1.00 30.88           C  
ATOM    297  N   VAL A  41       7.714  21.596  17.910  1.00 30.56           N  
ATOM    298  CA  VAL A  41       7.570  21.922  19.334  1.00 30.86           C  
ATOM    299  C   VAL A  41       6.193  21.436  19.812  1.00 30.59           C  
ATOM    300  O   VAL A  41       5.246  21.434  19.031  1.00 29.41           O  
ATOM    301  CB  VAL A  41       7.803  23.478  19.598  1.00 32.33           C  
ATOM    302  CG1 VAL A  41       6.676  24.313  18.963  1.00 34.05           C  
ATOM    303  CG2 VAL A  41       7.831  23.781  21.034  1.00 37.00           C  
ATOM    304  N   PRO A  42       6.073  20.975  21.066  1.00 29.92           N  
ATOM    305  CA  PRO A  42       4.699  20.758  21.593  1.00 30.12           C  
ATOM    306  C   PRO A  42       3.975  22.014  22.013  1.00 28.95           C  
ATOM    307  O   PRO A  42       4.553  22.885  22.635  1.00 34.73           O  
ATOM    308  CB  PRO A  42       4.899  19.834  22.794  1.00 31.87           C  
ATOM    309  CG  PRO A  42       6.295  19.550  22.869  1.00 32.85           C  
ATOM    310  CD  PRO A  42       7.069  20.580  22.068  1.00 32.27           C  
ATOM    311  N   LEU A  43       2.710  22.112  21.661  1.00 30.32           N  
ATOM    312  CA  LEU A  43       1.869  23.162  22.187  1.00 31.51           C  
ATOM    313  C   LEU A  43       0.596  22.493  22.710  1.00 28.59           C  
ATOM    314  O   LEU A  43       0.200  21.391  22.282  1.00 32.11           O  
ATOM    315  CB  LEU A  43       1.493  24.153  21.069  1.00 35.47           C  
ATOM    316  CG  LEU A  43       2.655  24.910  20.355  1.00 34.95           C  
ATOM    317  CD1 LEU A  43       2.028  25.651  19.197  1.00 42.54           C  
ATOM    318  CD2 LEU A  43       3.390  25.837  21.234  1.00 43.22           C  
ATOM    319  N   SER A  44      -0.091  23.215  23.552  1.00 28.80           N  
ATOM    320  CA  SER A  44      -1.420  22.860  24.018  1.00 29.87           C  
ATOM    321  C   SER A  44      -2.473  23.138  22.950  1.00 32.70           C  
ATOM    322  O   SER A  44      -2.299  24.021  22.143  1.00 32.62           O  
ATOM    323  CB  SER A  44      -1.687  23.598  25.304  1.00 33.62           C  
ATOM    324  OG  SER A  44      -0.826  23.090  26.313  1.00 34.39           O  
ATOM    325  N   TYR A  45      -3.576  22.382  22.964  1.00 28.72           N  
ATOM    326  CA  TYR A  45      -4.614  22.564  22.000  1.00 30.32           C  
ATOM    327  C   TYR A  45      -5.977  22.368  22.621  1.00 31.27           C  
ATOM    328  O   TYR A  45      -6.129  21.768  23.671  1.00 30.14           O  
ATOM    329  CB  TYR A  45      -4.429  21.634  20.802  1.00 29.07           C  
ATOM    330  CG  TYR A  45      -4.780  20.194  21.101  1.00 31.62           C  
ATOM    331  CD1 TYR A  45      -6.096  19.723  20.978  1.00 32.00           C  
ATOM    332  CD2 TYR A  45      -3.784  19.284  21.485  1.00 31.96           C  
ATOM    333  CE1 TYR A  45      -6.429  18.386  21.291  1.00 32.88           C  
ATOM    334  CE2 TYR A  45      -4.121  17.939  21.792  1.00 29.91           C  
ATOM    335  CZ  TYR A  45      -5.444  17.518  21.697  1.00 33.19           C  
ATOM    336  OH  TYR A  45      -5.757  16.207  21.999  1.00 30.59           O  
ATOM    337  N   LEU A  46      -6.953  22.928  21.944  1.00 31.72           N  
ATOM    338  CA  LEU A  46      -8.361  22.632  22.187  1.00 32.31           C  
ATOM    339  C   LEU A  46      -8.958  22.053  20.932  1.00 33.03           C  
ATOM    340  O   LEU A  46      -8.877  22.665  19.859  1.00 30.88           O  
ATOM    341  CB  LEU A  46      -9.108  23.858  22.560  1.00 28.75           C  
ATOM    342  CG  LEU A  46     -10.630  23.729  22.661  1.00 36.37           C  
ATOM    343  CD1 LEU A  46     -11.063  22.893  23.892  1.00 31.94           C  
ATOM    344  CD2 LEU A  46     -11.260  25.138  22.695  1.00 35.79           C  
ATOM    345  N   TRP A  47      -9.576  20.884  21.077  1.00 31.05           N  
ATOM    346  CA  TRP A  47     -10.368  20.273  20.016  1.00 32.37           C  
ATOM    347  C   TRP A  47     -11.866  20.365  20.343  1.00 32.81           C  
ATOM    348  O   TRP A  47     -12.289  19.991  21.438  1.00 30.45           O  
ATOM    349  CB  TRP A  47      -9.969  18.803  19.859  1.00 31.80           C  
ATOM    350  CG  TRP A  47     -10.889  17.898  19.031  1.00 28.07           C  
ATOM    351  CD1 TRP A  47     -11.757  16.937  19.534  1.00 28.06           C  
ATOM    352  CD2 TRP A  47     -10.970  17.799  17.623  1.00 28.03           C  
ATOM    353  NE1 TRP A  47     -12.390  16.301  18.504  1.00 29.36           N  
ATOM    354  CE2 TRP A  47     -11.898  16.768  17.321  1.00 26.56           C  
ATOM    355  CE3 TRP A  47     -10.367  18.478  16.566  1.00 27.76           C  
ATOM    356  CZ2 TRP A  47     -12.249  16.451  16.026  1.00 27.67           C  
ATOM    357  CZ3 TRP A  47     -10.702  18.123  15.282  1.00 31.14           C  
ATOM    358  CH2 TRP A  47     -11.642  17.128  15.018  1.00 32.27           C  
ATOM    359  N   ASP A  48     -12.654  20.823  19.378  1.00 32.72           N  
ATOM    360  CA  ASP A  48     -14.100  20.966  19.586  1.00 33.76           C  
ATOM    361  C   ASP A  48     -14.994  19.969  18.829  1.00 32.77           C  
ATOM    362  O   ASP A  48     -16.224  20.181  18.719  1.00 29.02           O  
ATOM    363  CB  ASP A  48     -14.538  22.417  19.263  1.00 34.90           C  
ATOM    364  CG  ASP A  48     -14.531  22.710  17.782  1.00 38.42           C  
ATOM    365  OD1 ASP A  48     -14.085  21.845  16.975  1.00 31.23           O  
ATOM    366  OD2 ASP A  48     -15.041  23.781  17.416  1.00 33.63           O  
ATOM    367  N   GLY A  49     -14.394  18.920  18.259  1.00 27.84           N  
ATOM    368  CA  GLY A  49     -15.145  18.006  17.403  1.00 31.25           C  
ATOM    369  C   GLY A  49     -15.004  18.283  15.925  1.00 31.40           C  
ATOM    370  O   GLY A  49     -15.452  17.479  15.079  1.00 30.12           O  
ATOM    371  N   GLU A  50     -14.433  19.440  15.576  1.00 28.71           N  
ATOM    372  CA  GLU A  50     -14.359  19.873  14.193  1.00 29.48           C  
ATOM    373  C   GLU A  50     -13.003  20.472  13.811  1.00 29.36           C  
ATOM    374  O   GLU A  50     -12.431  20.136  12.784  1.00 31.42           O  
ATOM    375  CB  GLU A  50     -15.506  20.886  13.970  1.00 32.31           C  
ATOM    376  CG  GLU A  50     -15.602  21.331  12.596  1.00 36.52           C  
ATOM    377  CD  GLU A  50     -16.740  22.328  12.338  1.00 40.16           C  
ATOM    378  OE1 GLU A  50     -16.870  23.321  13.055  1.00 36.31           O  
ATOM    379  OE2 GLU A  50     -17.471  22.101  11.379  1.00 43.74           O  
ATOM    380  N   THR A  51     -12.509  21.377  14.635  1.00 30.35           N  
ATOM    381  CA  THR A  51     -11.211  22.029  14.461  1.00 29.24           C  
ATOM    382  C   THR A  51     -10.399  21.998  15.766  1.00 30.57           C  
ATOM    383  O   THR A  51     -10.914  21.764  16.874  1.00 34.08           O  
ATOM    384  CB  THR A  51     -11.364  23.529  14.037  1.00 29.80           C  
ATOM    385  OG1 THR A  51     -12.041  24.227  15.063  1.00 29.20           O  
ATOM    386  CG2 THR A  51     -12.114  23.694  12.773  1.00 30.92           C  
ATOM    387  N   PHE A  52      -9.101  22.211  15.609  1.00 31.17           N  
ATOM    388  CA  PHE A  52      -8.164  22.422  16.672  1.00 29.17           C  
ATOM    389  C   PHE A  52      -7.896  23.928  16.761  1.00 32.79           C  
ATOM    390  O   PHE A  52      -7.912  24.663  15.771  1.00 29.92           O  
ATOM    391  CB  PHE A  52      -6.803  21.780  16.409  1.00 31.22           C  
ATOM    392  CG  PHE A  52      -6.831  20.297  16.282  1.00 28.84           C  
ATOM    393  CD1 PHE A  52      -7.138  19.696  15.094  1.00 28.76           C  
ATOM    394  CD2 PHE A  52      -6.528  19.507  17.373  1.00 33.08           C  
ATOM    395  CE1 PHE A  52      -7.127  18.256  14.982  1.00 26.94           C  
ATOM    396  CE2 PHE A  52      -6.528  18.115  17.290  1.00 33.70           C  
ATOM    397  CZ  PHE A  52      -6.835  17.490  16.086  1.00 28.86           C  
ATOM    398  N   LEU A  53      -7.641  24.356  17.982  1.00 29.66           N  
ATOM    399  CA  LEU A  53      -7.224  25.678  18.284  1.00 29.90           C  
ATOM    400  C   LEU A  53      -5.966  25.625  19.132  1.00 30.99           C  
ATOM    401  O   LEU A  53      -5.905  24.939  20.160  1.00 27.80           O  
ATOM    402  CB  LEU A  53      -8.325  26.408  19.029  1.00 29.68           C  
ATOM    403  CG  LEU A  53      -8.132  27.922  19.172  1.00 30.80           C  
ATOM    404  CD1 LEU A  53      -8.270  28.586  17.841  1.00 30.40           C  
ATOM    405  CD2 LEU A  53      -9.160  28.492  20.114  1.00 32.98           C  
ATOM    406  N   VAL A  54      -4.948  26.334  18.669  1.00 29.19           N  
ATOM    407  CA  VAL A  54      -3.655  26.451  19.389  1.00 31.35           C  
ATOM    408  C   VAL A  54      -3.390  27.953  19.545  1.00 33.73           C  
ATOM    409  O   VAL A  54      -4.020  28.759  18.888  1.00 31.85           O  
ATOM    410  CB  VAL A  54      -2.478  25.768  18.629  1.00 29.96           C  
ATOM    411  CG1 VAL A  54      -2.751  24.260  18.498  1.00 30.20           C  
ATOM    412  CG2 VAL A  54      -2.200  26.420  17.256  1.00 35.93           C  
ATOM    413  N   ALA A  55      -2.500  28.333  20.440  1.00 30.90           N  
ATOM    414  CA  ALA A  55      -2.145  29.726  20.542  1.00 31.37           C  
ATOM    415  C   ALA A  55      -0.617  29.813  20.723  1.00 31.54           C  
ATOM    416  O   ALA A  55      -0.042  29.047  21.496  1.00 32.46           O  
ATOM    417  CB  ALA A  55      -2.874  30.344  21.713  1.00 31.29           C  
ATOM    418  N   THR A  56       0.006  30.785  20.058  1.00 31.52           N  
ATOM    419  CA  THR A  56       1.431  31.037  20.201  1.00 33.13           C  
ATOM    420  C   THR A  56       1.724  32.526  19.933  1.00 32.14           C  
ATOM    421  O   THR A  56       0.931  33.187  19.262  1.00 30.72           O  
ATOM    422  CB  THR A  56       2.219  30.064  19.233  1.00 35.09           C  
ATOM    423  OG1 THR A  56       3.622  30.142  19.491  1.00 34.35           O  
ATOM    424  CG2 THR A  56       1.995  30.437  17.783  1.00 36.62           C  
ATOM    425  N   PRO A  57       2.843  33.079  20.494  1.00 32.37           N  
ATOM    426  CA  PRO A  57       3.180  34.409  20.101  1.00 32.99           C  
ATOM    427  C   PRO A  57       3.237  34.526  18.588  1.00 31.38           C  
ATOM    428  O   PRO A  57       3.727  33.633  17.893  1.00 28.78           O  
ATOM    429  CB  PRO A  57       4.541  34.647  20.778  1.00 36.88           C  
ATOM    430  CG  PRO A  57       4.463  33.818  22.032  1.00 36.57           C  
ATOM    431  CD  PRO A  57       3.741  32.577  21.564  1.00 32.75           C  
ATOM    432  N   ALA A  58       2.677  35.597  18.055  1.00 31.43           N  
ATOM    433  CA  ALA A  58       2.724  35.823  16.602  1.00 32.61           C  
ATOM    434  C   ALA A  58       4.146  35.701  16.074  1.00 35.64           C  
ATOM    435  O   ALA A  58       4.376  35.236  14.934  1.00 35.45           O  
ATOM    436  CB  ALA A  58       2.171  37.228  16.265  1.00 31.84           C  
ATOM    437  N   ALA A  59       5.108  36.146  16.894  1.00 34.71           N  
ATOM    438  CA  ALA A  59       6.512  36.214  16.484  1.00 34.07           C  
ATOM    439  C   ALA A  59       7.325  34.931  16.682  1.00 32.52           C  
ATOM    440  O   ALA A  59       8.489  34.900  16.315  1.00 33.21           O  
ATOM    441  CB  ALA A  59       7.186  37.372  17.195  1.00 34.60           C  
ATOM    442  N   SER A  60       6.729  33.893  17.277  1.00 30.93           N  
ATOM    443  CA  SER A  60       7.443  32.620  17.536  1.00 31.83           C  
ATOM    444  C   SER A  60       7.673  31.919  16.188  1.00 30.96           C  
ATOM    445  O   SER A  60       6.970  32.204  15.233  1.00 30.20           O  
ATOM    446  CB  SER A  60       6.641  31.708  18.436  1.00 31.11           C  
ATOM    447  OG  SER A  60       5.488  31.253  17.729  1.00 29.60           O  
ATOM    448  N   PRO A  61       8.654  31.033  16.099  1.00 30.27           N  
ATOM    449  CA  PRO A  61       8.837  30.298  14.834  1.00 29.80           C  
ATOM    450  C   PRO A  61       7.580  29.590  14.358  1.00 31.00           C  
ATOM    451  O   PRO A  61       7.291  29.572  13.155  1.00 27.32           O  
ATOM    452  CB  PRO A  61       9.917  29.298  15.169  1.00 29.31           C  
ATOM    453  CG  PRO A  61      10.727  30.005  16.262  1.00 33.59           C  
ATOM    454  CD  PRO A  61       9.684  30.669  17.104  1.00 29.97           C  
ATOM    455  N   THR A  62       6.831  29.014  15.296  1.00 30.77           N  
ATOM    456  CA  THR A  62       5.568  28.360  14.974  1.00 30.06           C  
ATOM    457  C   THR A  62       4.577  29.341  14.464  1.00 29.51           C  
ATOM    458  O   THR A  62       3.978  29.119  13.398  1.00 31.46           O  
ATOM    459  CB  THR A  62       5.007  27.561  16.183  1.00 31.43           C  
ATOM    460  OG1 THR A  62       5.917  26.496  16.504  1.00 29.76           O  
ATOM    461  CG2 THR A  62       3.638  26.971  15.841  1.00 32.76           C  
ATOM    462  N   GLY A  63       4.401  30.457  15.184  1.00 31.19           N  
ATOM    463  CA  GLY A  63       3.470  31.498  14.746  1.00 29.44           C  
ATOM    464  C   GLY A  63       3.769  32.054  13.355  1.00 29.86           C  
ATOM    465  O   GLY A  63       2.877  32.258  12.556  1.00 30.60           O  
ATOM    466  N   ARG A  64       5.037  32.309  13.086  1.00 30.78           N  
ATOM    467  CA  ARG A  64       5.477  32.799  11.786  1.00 33.00           C  
ATOM    468  C   ARG A  64       5.272  31.771  10.692  1.00 30.48           C  
ATOM    469  O   ARG A  64       4.825  32.112   9.610  1.00 30.96           O  
ATOM    470  CB  ARG A  64       6.939  33.266  11.841  1.00 33.88           C  
ATOM    471  CG  ARG A  64       7.093  34.470  12.792  1.00 34.60           C  
ATOM    472  CD  ARG A  64       8.495  35.114  12.798  1.00 35.03           C  
ATOM    473  NE  ARG A  64       9.435  34.399  13.633  1.00 38.75           N  
ATOM    474  CZ  ARG A  64      10.326  33.522  13.189  1.00 45.56           C  
ATOM    475  NH1 ARG A  64      10.449  33.270  11.880  1.00 43.27           N  
ATOM    476  NH2 ARG A  64      11.144  32.939  14.062  1.00 33.75           N  
ATOM    477  N   ASN A  65       5.597  30.516  10.954  1.00 30.21           N  
ATOM    478  CA  ASN A  65       5.384  29.473   9.935  1.00 31.46           C  
ATOM    479  C   ASN A  65       3.904  29.288   9.659  1.00 29.59           C  
ATOM    480  O   ASN A  65       3.509  29.192   8.495  1.00 31.25           O  
ATOM    481  CB  ASN A  65       6.046  28.128  10.279  1.00 28.22           C  
ATOM    482  CG  ASN A  65       7.553  28.213  10.317  1.00 32.45           C  
ATOM    483  OD1 ASN A  65       8.107  29.178   9.871  1.00 29.60           O  
ATOM    484  ND2 ASN A  65       8.211  27.205  10.874  1.00 29.04           N  
ATOM    485  N   LEU A  66       3.080  29.298  10.706  1.00 27.90           N  
ATOM    486  CA  LEU A  66       1.662  29.171  10.525  1.00 28.71           C  
ATOM    487  C   LEU A  66       1.041  30.333   9.698  1.00 32.02           C  
ATOM    488  O   LEU A  66       0.255  30.105   8.784  1.00 31.55           O  
ATOM    489  CB  LEU A  66       0.926  28.970  11.855  1.00 28.68           C  
ATOM    490  CG  LEU A  66       1.195  27.601  12.511  1.00 28.23           C  
ATOM    491  CD1 LEU A  66       0.533  27.503  13.882  1.00 30.56           C  
ATOM    492  CD2 LEU A  66       0.764  26.464  11.598  1.00 28.08           C  
ATOM    493  N   SER A  67       1.433  31.550  10.030  1.00 30.60           N  
ATOM    494  CA  SER A  67       0.975  32.746   9.347  1.00 31.32           C  
ATOM    495  C   SER A  67       1.382  32.759   7.914  1.00 31.99           C  
ATOM    496  O   SER A  67       0.585  33.153   7.044  1.00 32.65           O  
ATOM    497  CB  SER A  67       1.556  34.008   9.996  1.00 32.45           C  
ATOM    498  OG  SER A  67       0.951  34.201  11.248  1.00 30.87           O  
ATOM    499  N   GLU A  68       2.621  32.363   7.646  1.00 32.22           N  
ATOM    500  CA  GLU A  68       3.193  32.526   6.309  1.00 33.03           C  
ATOM    501  C   GLU A  68       2.806  31.390   5.421  1.00 32.61           C  
ATOM    502  O   GLU A  68       2.630  31.595   4.241  1.00 32.79           O  
ATOM    503  CB  GLU A  68       4.721  32.633   6.368  1.00 32.71           C  
ATOM    504  CG  GLU A  68       5.231  33.867   7.129  1.00 45.59           C  
ATOM    505  N   THR A  69       2.642  30.183   5.967  1.00 32.10           N  
ATOM    506  CA  THR A  69       2.441  28.996   5.109  1.00 35.87           C  
ATOM    507  C   THR A  69       1.044  28.391   5.252  1.00 34.09           C  
ATOM    508  O   THR A  69       0.590  27.698   4.387  1.00 35.85           O  
ATOM    509  CB  THR A  69       3.541  27.890   5.387  1.00 34.75           C  
ATOM    510  OG1 THR A  69       3.250  27.185   6.611  1.00 34.02           O  
ATOM    511  CG2 THR A  69       4.931  28.491   5.489  1.00 42.62           C  
ATOM    512  N   GLY A  70       0.390  28.592   6.390  1.00 29.87           N  
ATOM    513  CA  GLY A  70      -0.861  27.976   6.651  1.00 31.52           C  
ATOM    514  C   GLY A  70      -0.894  26.448   6.721  1.00 31.92           C  
ATOM    515  O   GLY A  70      -1.957  25.874   6.681  1.00 33.24           O  
ATOM    516  N   ARG A  71       0.239  25.775   6.830  1.00 29.89           N  
ATOM    517  CA  ARG A  71       0.222  24.303   6.835  1.00 30.99           C  
ATOM    518  C   ARG A  71       0.817  23.804   8.129  1.00 30.35           C  
ATOM    519  O   ARG A  71       1.737  24.430   8.655  1.00 29.74           O  
ATOM    520  CB  ARG A  71       1.013  23.761   5.652  1.00 31.24           C  
ATOM    521  CG  ARG A  71       0.327  24.029   4.309  1.00 38.64           C  
ATOM    522  CD  ARG A  71       1.226  23.582   3.196  1.00 43.41           C  
ATOM    523  NE  ARG A  71       0.635  23.792   1.858  1.00 51.96           N  
ATOM    524  N   VAL A  72       0.302  22.677   8.620  1.00 30.99           N  
ATOM    525  CA  VAL A  72       0.679  22.152   9.944  1.00 29.63           C  
ATOM    526  C   VAL A  72       0.450  20.652   9.966  1.00 29.51           C  
ATOM    527  O   VAL A  72      -0.483  20.144   9.347  1.00 29.36           O  
ATOM    528  CB  VAL A  72      -0.048  22.881  11.099  1.00 29.09           C  
ATOM    529  CG1 VAL A  72      -1.537  22.652  11.089  1.00 32.47           C  
ATOM    530  CG2 VAL A  72       0.538  22.560  12.429  1.00 31.97           C  
ATOM    531  N   ARG A  73       1.307  19.963  10.717  1.00 28.47           N  
ATOM    532  CA  ARG A  73       1.070  18.588  11.098  1.00 30.61           C  
ATOM    533  C   ARG A  73       1.067  18.481  12.645  1.00 29.07           C  
ATOM    534  O   ARG A  73       1.845  19.154  13.346  1.00 32.53           O  
ATOM    535  CB  ARG A  73       2.126  17.645  10.510  1.00 30.49           C  
ATOM    536  CG  ARG A  73       2.435  17.814   9.057  1.00 36.04           C  
ATOM    537  CD  ARG A  73       1.283  17.337   8.266  1.00 40.80           C  
ATOM    538  NE  ARG A  73       1.490  17.538   6.826  1.00 45.57           N  
ATOM    539  CZ  ARG A  73       1.774  16.577   5.949  1.00 38.56           C  
ATOM    540  NH1 ARG A  73       1.875  15.327   6.304  1.00 47.44           N  
ATOM    541  NH2 ARG A  73       1.903  16.874   4.673  1.00 45.62           N  
ATOM    542  N   LEU A  74       0.158  17.683  13.148  1.00 29.45           N  
ATOM    543  CA  LEU A  74       0.006  17.413  14.602  1.00 29.56           C  
ATOM    544  C   LEU A  74       0.234  15.940  14.895  1.00 29.18           C  
ATOM    545  O   LEU A  74      -0.354  15.080  14.242  1.00 33.39           O  
ATOM    546  CB  LEU A  74      -1.382  17.828  15.107  1.00 30.47           C  
ATOM    547  CG  LEU A  74      -1.903  19.242  14.776  1.00 33.24           C  
ATOM    548  CD1 LEU A  74      -3.357  19.369  15.275  1.00 34.83           C  
ATOM    549  CD2 LEU A  74      -1.017  20.260  15.416  1.00 34.57           C  
ATOM    550  N   GLY A  75       1.115  15.669  15.864  1.00 27.50           N  
ATOM    551  CA  GLY A  75       1.377  14.334  16.429  1.00 30.07           C  
ATOM    552  C   GLY A  75       0.802  14.295  17.836  1.00 27.80           C  
ATOM    553  O   GLY A  75       1.221  15.064  18.711  1.00 29.18           O  
ATOM    554  N   ILE A  76      -0.205  13.456  18.030  1.00 29.48           N  
ATOM    555  CA  ILE A  76      -0.949  13.393  19.285  1.00 27.66           C  
ATOM    556  C   ILE A  76      -0.980  11.960  19.766  1.00 32.69           C  
ATOM    557  O   ILE A  76      -1.130  10.994  18.997  1.00 32.05           O  
ATOM    558  CB  ILE A  76      -2.394  13.912  19.148  1.00 26.71           C  
ATOM    559  CG1 ILE A  76      -2.341  15.423  18.849  1.00 29.78           C  
ATOM    560  CG2 ILE A  76      -3.196  13.633  20.431  1.00 29.65           C  
ATOM    561  CD1 ILE A  76      -3.642  15.995  18.358  1.00 34.22           C  
ATOM    562  N   GLY A  77      -0.773  11.841  21.062  1.00 30.67           N  
ATOM    563  CA  GLY A  77      -0.948  10.603  21.759  1.00 29.39           C  
ATOM    564  C   GLY A  77       0.326   9.970  22.226  1.00 33.14           C  
ATOM    565  O   GLY A  77       1.424  10.363  21.788  1.00 32.45           O  
ATOM    566  N   PRO A  78       0.189   8.980  23.127  1.00 34.64           N  
ATOM    567  CA  PRO A  78       1.298   8.353  23.755  1.00 37.48           C  
ATOM    568  C   PRO A  78       1.848   7.320  22.834  1.00 37.00           C  
ATOM    569  O   PRO A  78       1.351   7.126  21.679  1.00 37.71           O  
ATOM    570  CB  PRO A  78       0.660   7.678  24.990  1.00 39.27           C  
ATOM    571  CG  PRO A  78      -0.607   7.189  24.477  1.00 39.67           C  
ATOM    572  CD  PRO A  78      -1.081   8.361  23.580  1.00 35.86           C  
ATOM    573  N   THR A  79       2.884   6.671  23.341  1.00 39.79           N  
ATOM    574  CA  THR A  79       3.672   5.713  22.579  1.00 40.62           C  
ATOM    575  C   THR A  79       2.770   4.612  21.986  1.00 42.30           C  
ATOM    576  O   THR A  79       1.986   3.961  22.729  1.00 42.09           O  
ATOM    577  CB  THR A  79       4.725   5.029  23.479  1.00 39.59           C  
ATOM    578  OG1 THR A  79       5.584   6.026  24.076  1.00 45.18           O  
ATOM    579  CG2 THR A  79       5.528   4.024  22.663  1.00 44.04           C  
ATOM    580  N   ARG A  80       2.867   4.412  20.668  1.00 38.35           N  
ATOM    581  CA  ARG A  80       2.156   3.307  20.026  1.00 43.82           C  
ATOM    582  C   ARG A  80       0.632   3.373  20.230  1.00 42.05           C  
ATOM    583  O   ARG A  80      -0.028   2.343  20.186  1.00 39.11           O  
ATOM    584  CB  ARG A  80       2.680   1.923  20.504  1.00 47.96           C  
ATOM    585  CG  ARG A  80       4.161   1.576  20.161  1.00 49.16           C  
ATOM    586  CD  ARG A  80       4.382   1.220  18.692  1.00 50.74           C  
ATOM    587  NE  ARG A  80       5.804   1.319  18.319  1.00 51.31           N  
ATOM    588  CZ  ARG A  80       6.683   0.309  18.298  1.00 51.63           C  
ATOM    589  NH1 ARG A  80       6.318  -0.936  18.614  1.00 56.27           N  
ATOM    590  NH2 ARG A  80       7.951   0.543  17.940  1.00 43.07           N  
ATOM    591  N   ASP A  81       0.105   4.582  20.453  1.00 33.65           N  
ATOM    592  CA  ASP A  81      -1.306   4.891  20.301  1.00 36.00           C  
ATOM    593  C   ASP A  81      -1.433   6.325  19.746  1.00 33.17           C  
ATOM    594  O   ASP A  81      -1.821   7.290  20.412  1.00 37.67           O  
ATOM    595  CB  ASP A  81      -2.043   4.702  21.616  1.00 39.64           C  
ATOM    596  CG  ASP A  81      -3.542   4.761  21.446  1.00 45.53           C  
ATOM    597  OD1 ASP A  81      -4.043   4.812  20.269  1.00 36.94           O  
ATOM    598  OD2 ASP A  81      -4.221   4.791  22.495  1.00 54.41           O  
ATOM    599  N   LEU A  82      -1.027   6.462  18.500  1.00 33.39           N  
ATOM    600  CA  LEU A  82      -0.792   7.773  17.912  1.00 32.33           C  
ATOM    601  C   LEU A  82      -1.906   8.179  17.014  1.00 30.71           C  
ATOM    602  O   LEU A  82      -2.614   7.312  16.406  1.00 31.78           O  
ATOM    603  CB  LEU A  82       0.536   7.779  17.121  1.00 35.38           C  
ATOM    604  CG  LEU A  82       1.824   7.435  17.893  1.00 37.01           C  
ATOM    605  CD1 LEU A  82       2.961   7.268  16.910  1.00 41.91           C  
ATOM    606  CD2 LEU A  82       2.228   8.388  18.985  1.00 42.71           C  
ATOM    607  N   VAL A  83      -2.074   9.500  16.949  1.00 31.65           N  
ATOM    608  CA  VAL A  83      -2.901  10.174  15.983  1.00 30.47           C  
ATOM    609  C   VAL A  83      -2.047  11.246  15.245  1.00 32.04           C  
ATOM    610  O   VAL A  83      -1.334  12.051  15.856  1.00 30.59           O  
ATOM    611  CB  VAL A  83      -4.102  10.841  16.666  1.00 32.53           C  
ATOM    612  CG1 VAL A  83      -5.001  11.454  15.621  1.00 31.51           C  
ATOM    613  CG2 VAL A  83      -4.880   9.839  17.523  1.00 32.44           C  
ATOM    614  N   LEU A  84      -2.080  11.179  13.923  1.00 28.93           N  
ATOM    615  CA  LEU A  84      -1.341  12.073  13.072  1.00 28.73           C  
ATOM    616  C   LEU A  84      -2.305  12.866  12.192  1.00 28.56           C  
ATOM    617  O   LEU A  84      -3.085  12.288  11.430  1.00 30.18           O  
ATOM    618  CB  LEU A  84      -0.356  11.245  12.237  1.00 28.02           C  
ATOM    619  CG  LEU A  84       0.579  11.997  11.293  1.00 34.78           C  
ATOM    620  CD1 LEU A  84       1.470  13.024  11.976  1.00 42.06           C  
ATOM    621  CD2 LEU A  84       1.417  10.925  10.614  1.00 39.92           C  
ATOM    622  N   VAL A  85      -2.258  14.189  12.322  1.00 30.86           N  
ATOM    623  CA  VAL A  85      -3.189  15.067  11.641  1.00 30.93           C  
ATOM    624  C   VAL A  85      -2.440  15.950  10.641  1.00 32.65           C  
ATOM    625  O   VAL A  85      -1.410  16.541  10.980  1.00 31.36           O  
ATOM    626  CB  VAL A  85      -3.975  15.943  12.647  1.00 33.25           C  
ATOM    627  CG1 VAL A  85      -5.002  16.805  11.925  1.00 30.06           C  
ATOM    628  CG2 VAL A  85      -4.643  15.105  13.728  1.00 29.10           C  
ATOM    629  N   GLU A  86      -2.956  16.043   9.408  1.00 31.06           N  
ATOM    630  CA  GLU A  86      -2.502  17.062   8.460  0.50 32.38           C  
ATOM    632  C   GLU A  86      -3.608  18.085   8.345  1.00 32.26           C  
ATOM    633  O   GLU A  86      -4.791  17.740   8.102  1.00 28.66           O  
ATOM    634  CB  GLU A  86      -2.225  16.521   7.053  0.50 31.58           C  
ATOM    636  CG  GLU A  86      -1.439  15.227   6.978  0.50 33.54           C  
ATOM    638  CD  GLU A  86      -1.055  14.892   5.538  0.50 36.14           C  
ATOM    640  OE1 GLU A  86      -0.851  15.833   4.746  0.50 51.58           O  
ATOM    642  OE2 GLU A  86      -0.934  13.706   5.203  0.50 45.31           O  
ATOM    644  N   GLY A  87      -3.227  19.351   8.458  1.00 32.79           N  
ATOM    645  CA  GLY A  87      -4.220  20.431   8.482  1.00 32.48           C  
ATOM    646  C   GLY A  87      -3.751  21.752   7.902  1.00 28.54           C  
ATOM    647  O   GLY A  87      -2.566  21.980   7.629  1.00 30.62           O  
ATOM    648  N   THR A  88      -4.709  22.649   7.732  1.00 29.32           N  
ATOM    649  CA  THR A  88      -4.453  23.991   7.264  1.00 31.05           C  
ATOM    650  C   THR A  88      -4.838  24.907   8.431  1.00 31.54           C  
ATOM    651  O   THR A  88      -5.770  24.590   9.185  1.00 35.97           O  
ATOM    652  CB  THR A  88      -5.307  24.331   6.002  1.00 33.82           C  
ATOM    653  OG1 THR A  88      -6.675  24.098   6.278  1.00 36.96           O  
ATOM    654  CG2 THR A  88      -4.865  23.514   4.796  1.00 36.73           C  
ATOM    655  N   ALA A  89      -4.102  25.999   8.596  1.00 28.68           N  
ATOM    656  CA  ALA A  89      -4.230  26.874   9.736  1.00 28.76           C  
ATOM    657  C   ALA A  89      -4.514  28.323   9.352  1.00 29.79           C  
ATOM    658  O   ALA A  89      -3.878  28.860   8.434  1.00 33.34           O  
ATOM    659  CB  ALA A  89      -2.933  26.779  10.554  1.00 30.90           C  
ATOM    660  N   LEU A  90      -5.442  28.960  10.067  1.00 30.15           N  
ATOM    661  CA  LEU A  90      -5.763  30.369   9.889  1.00 30.14           C  
ATOM    662  C   LEU A  90      -5.701  31.105  11.216  1.00 31.56           C  
ATOM    663  O   LEU A  90      -6.060  30.548  12.270  1.00 30.99           O  
ATOM    664  CB  LEU A  90      -7.134  30.559   9.216  1.00 32.69           C  
ATOM    665  CG  LEU A  90      -7.181  30.072   7.769  1.00 31.13           C  
ATOM    666  CD1 LEU A  90      -8.663  30.077   7.266  1.00 38.00           C  
ATOM    667  CD2 LEU A  90      -6.298  30.891   6.867  1.00 39.30           C  
ATOM    668  N   PRO A  91      -5.224  32.357  11.192  1.00 31.48           N  
ATOM    669  CA  PRO A  91      -5.035  33.087  12.454  1.00 30.54           C  
ATOM    670  C   PRO A  91      -6.322  33.738  12.979  1.00 31.90           C  
ATOM    671  O   PRO A  91      -7.155  34.167  12.209  1.00 31.62           O  
ATOM    672  CB  PRO A  91      -4.032  34.183  12.053  1.00 32.01           C  
ATOM    673  CG  PRO A  91      -4.405  34.486  10.571  1.00 36.49           C  
ATOM    674  CD  PRO A  91      -4.799  33.135  10.006  1.00 34.37           C  
ATOM    675  N   LEU A  92      -6.460  33.833  14.291  1.00 34.77           N  
ATOM    676  CA  LEU A  92      -7.544  34.606  14.925  1.00 34.31           C  
ATOM    677  C   LEU A  92      -6.846  35.466  15.964  1.00 33.43           C  
ATOM    678  O   LEU A  92      -6.052  34.968  16.790  1.00 30.25           O  
ATOM    679  CB  LEU A  92      -8.582  33.676  15.582  1.00 33.80           C  
ATOM    680  CG  LEU A  92      -9.369  32.764  14.650  1.00 38.22           C  
ATOM    681  CD1 LEU A  92     -10.064  31.674  15.412  1.00 36.14           C  
ATOM    682  CD2 LEU A  92     -10.364  33.591  13.814  1.00 40.10           C  
ATOM    683  N   GLU A  93      -7.096  36.764  15.914  1.00 30.58           N  
ATOM    684  CA  GLU A  93      -6.674  37.648  16.967  1.00 32.70           C  
ATOM    685  C   GLU A  93      -7.453  37.344  18.257  1.00 34.61           C  
ATOM    686  O   GLU A  93      -8.632  37.012  18.200  1.00 34.41           O  
ATOM    687  CB  GLU A  93      -6.966  39.098  16.596  1.00 36.89           C  
ATOM    688  CG  GLU A  93      -6.363  39.568  15.270  1.00 44.85           C  
ATOM    689  CD  GLU A  93      -4.913  39.944  15.392  1.00 52.55           C  
ATOM    690  OE1 GLU A  93      -4.430  40.121  16.539  1.00 62.89           O  
ATOM    691  OE2 GLU A  93      -4.252  40.053  14.343  1.00 60.43           O  
ATOM    692  N   PRO A  94      -6.803  37.487  19.422  1.00 35.72           N  
ATOM    693  CA  PRO A  94      -7.437  37.310  20.731  1.00 38.90           C  
ATOM    694  C   PRO A  94      -8.746  38.078  20.899  1.00 45.12           C  
ATOM    695  O   PRO A  94      -9.681  37.522  21.442  1.00 46.04           O  
ATOM    696  CB  PRO A  94      -6.369  37.797  21.688  1.00 39.16           C  
ATOM    697  CG  PRO A  94      -5.096  37.367  21.016  1.00 39.04           C  
ATOM    698  CD  PRO A  94      -5.360  37.744  19.577  1.00 38.17           C  
ATOM    699  N   ALA A  95      -8.834  39.297  20.369  1.00 48.12           N  
ATOM    700  CA  ALA A  95     -10.099  40.034  20.365  1.00 49.14           C  
ATOM    701  C   ALA A  95     -11.124  39.578  19.314  1.00 50.09           C  
ATOM    702  O   ALA A  95     -12.242  40.077  19.313  1.00 55.91           O  
ATOM    703  CB  ALA A  95      -9.836  41.532  20.231  1.00 51.03           C  
ATOM    704  N   GLY A  96     -10.780  38.652  18.429  1.00 47.43           N  
ATOM    705  CA  GLY A  96     -11.690  38.217  17.371  1.00 43.93           C  
ATOM    706  C   GLY A  96     -12.088  36.761  17.466  1.00 44.08           C  
ATOM    707  O   GLY A  96     -12.400  36.115  16.456  1.00 45.58           O  
ATOM    708  N   LEU A  97     -12.036  36.199  18.676  1.00 43.15           N  
ATOM    709  CA  LEU A  97     -12.457  34.791  18.875  1.00 39.83           C  
ATOM    710  C   LEU A  97     -13.965  34.734  18.865  1.00 37.35           C  
ATOM    711  O   LEU A  97     -14.587  35.671  19.271  1.00 29.89           O  
ATOM    712  CB  LEU A  97     -12.003  34.251  20.230  1.00 39.96           C  
ATOM    713  CG  LEU A  97     -10.506  34.032  20.378  1.00 39.23           C  
ATOM    714  CD1 LEU A  97     -10.218  33.629  21.815  1.00 43.77           C  
ATOM    715  CD2 LEU A  97     -10.086  32.941  19.419  1.00 37.84           C  
ATOM    716  N   PRO A  98     -14.547  33.638  18.393  1.00 35.64           N  
ATOM    717  CA  PRO A  98     -16.011  33.509  18.592  1.00 35.17           C  
ATOM    718  C   PRO A  98     -16.382  33.538  20.084  1.00 33.26           C  
ATOM    719  O   PRO A  98     -15.554  33.188  20.939  1.00 36.21           O  
ATOM    720  CB  PRO A  98     -16.333  32.104  18.048  1.00 33.79           C  
ATOM    721  CG  PRO A  98     -15.146  31.682  17.217  1.00 41.99           C  
ATOM    722  CD  PRO A  98     -13.949  32.517  17.649  1.00 36.73           C  
ATOM    723  N   ASP A  99     -17.614  33.899  20.380  1.00 32.96           N  
ATOM    724  CA  ASP A  99     -18.117  33.899  21.747  1.00 31.32           C  
ATOM    725  C   ASP A  99     -17.827  32.588  22.454  1.00 29.96           C  
ATOM    726  O   ASP A  99     -18.062  31.497  21.923  1.00 31.44           O  
ATOM    727  CB  ASP A  99     -19.627  34.193  21.764  1.00 31.00           C  
ATOM    728  CG  ASP A  99     -19.971  35.574  21.196  1.00 35.49           C  
ATOM    729  OD1 ASP A  99     -19.072  36.419  21.111  1.00 31.81           O  
ATOM    730  OD2 ASP A  99     -21.146  35.843  20.838  1.00 34.20           O  
ATOM    731  N   GLY A 100     -17.236  32.679  23.634  1.00 31.38           N  
ATOM    732  CA  GLY A 100     -17.093  31.506  24.496  1.00 33.41           C  
ATOM    733  C   GLY A 100     -15.806  30.709  24.257  1.00 32.21           C  
ATOM    734  O   GLY A 100     -15.342  29.974  25.129  1.00 33.42           O  
ATOM    735  N   VAL A 101     -15.186  30.880  23.103  1.00 31.70           N  
ATOM    736  CA  VAL A 101     -14.038  30.075  22.769  1.00 30.67           C  
ATOM    737  C   VAL A 101     -12.772  30.349  23.610  1.00 31.75           C  
ATOM    738  O   VAL A 101     -12.051  29.398  23.980  1.00 31.92           O  
ATOM    739  CB  VAL A 101     -13.715  30.194  21.253  1.00 32.95           C  
ATOM    740  CG1 VAL A 101     -12.393  29.564  20.972  1.00 32.88           C  
ATOM    741  CG2 VAL A 101     -14.870  29.549  20.410  1.00 35.27           C  
ATOM    742  N   GLY A 102     -12.502  31.615  23.902  1.00 30.71           N  
ATOM    743  CA  GLY A 102     -11.344  31.988  24.704  1.00 33.28           C  
ATOM    744  C   GLY A 102     -11.411  31.348  26.094  1.00 32.91           C  
ATOM    745  O   GLY A 102     -10.411  30.787  26.577  1.00 32.36           O  
ATOM    746  N   ASP A 103     -12.591  31.415  26.714  1.00 30.24           N  
ATOM    747  CA  ASP A 103     -12.831  30.772  27.998  1.00 31.56           C  
ATOM    748  C   ASP A 103     -12.620  29.258  27.949  1.00 32.70           C  
ATOM    749  O   ASP A 103     -11.945  28.693  28.820  1.00 34.62           O  
ATOM    750  CB  ASP A 103     -14.243  31.028  28.527  1.00 35.37           C  
ATOM    751  CG  ASP A 103     -14.447  32.449  29.037  1.00 44.56           C  
ATOM    752  OD1 ASP A 103     -13.473  33.221  29.159  1.00 37.45           O  
ATOM    753  OD2 ASP A 103     -15.618  32.782  29.356  1.00 46.33           O  
ATOM    754  N   THR A 104     -13.159  28.608  26.932  1.00 33.38           N  
ATOM    755  CA  THR A 104     -13.005  27.181  26.780  1.00 33.98           C  
ATOM    756  C   THR A 104     -11.525  26.828  26.615  1.00 33.80           C  
ATOM    757  O   THR A 104     -11.044  25.858  27.230  1.00 34.10           O  
ATOM    758  CB  THR A 104     -13.856  26.625  25.634  1.00 34.36           C  
ATOM    759  OG1 THR A 104     -15.224  27.034  25.835  1.00 34.03           O  
ATOM    760  CG2 THR A 104     -13.813  25.069  25.610  1.00 34.77           C  
ATOM    761  N   PHE A 105     -10.817  27.584  25.771  1.00 32.99           N  
ATOM    762  CA  PHE A 105      -9.426  27.350  25.529  1.00 31.56           C  
ATOM    763  C   PHE A 105      -8.629  27.449  26.857  1.00 34.52           C  
ATOM    764  O   PHE A 105      -7.775  26.560  27.136  1.00 34.51           O  
ATOM    765  CB  PHE A 105      -8.839  28.354  24.527  1.00 32.23           C  
ATOM    766  CG  PHE A 105      -7.382  28.132  24.234  1.00 32.33           C  
ATOM    767  CD1 PHE A 105      -6.997  27.272  23.242  1.00 30.99           C  
ATOM    768  CD2 PHE A 105      -6.402  28.843  24.924  1.00 35.88           C  
ATOM    769  CE1 PHE A 105      -5.633  27.089  22.938  1.00 37.72           C  
ATOM    770  CE2 PHE A 105      -5.058  28.680  24.636  1.00 33.90           C  
ATOM    771  CZ  PHE A 105      -4.676  27.792  23.656  1.00 30.47           C  
ATOM    772  N   ALA A 106      -8.857  28.533  27.599  1.00 35.99           N  
ATOM    773  CA  ALA A 106      -8.173  28.781  28.881  1.00 36.94           C  
ATOM    774  C   ALA A 106      -8.419  27.678  29.891  1.00 40.16           C  
ATOM    775  O   ALA A 106      -7.484  27.307  30.611  1.00 38.97           O  
ATOM    776  CB  ALA A 106      -8.552  30.111  29.471  1.00 36.99           C  
ATOM    777  N   GLU A 107      -9.650  27.147  29.936  1.00 38.12           N  
ATOM    778  CA  GLU A 107      -9.999  26.055  30.844  1.00 43.40           C  
ATOM    779  C   GLU A 107      -9.327  24.769  30.443  1.00 44.28           C  
ATOM    780  O   GLU A 107      -8.939  24.004  31.306  1.00 43.37           O  
ATOM    781  CB  GLU A 107     -11.515  25.768  30.887  1.00 43.56           C  
ATOM    782  CG  GLU A 107     -12.365  26.818  31.576  1.00 51.91           C  
ATOM    783  CD  GLU A 107     -13.878  26.818  31.143  1.00 53.28           C  
ATOM    784  OE1 GLU A 107     -14.369  25.924  30.356  1.00 55.85           O  
ATOM    785  OE2 GLU A 107     -14.559  27.781  31.577  1.00 65.49           O  
ATOM    786  N   LYS A 108      -9.229  24.481  29.144  1.00 37.47           N  
ATOM    787  CA  LYS A 108      -8.569  23.288  28.703  1.00 39.00           C  
ATOM    788  C   LYS A 108      -7.035  23.308  28.923  1.00 40.43           C  
ATOM    789  O   LYS A 108      -6.446  22.260  29.259  1.00 39.76           O  
ATOM    790  CB  LYS A 108      -8.886  23.005  27.229  1.00 37.88           C  
ATOM    791  CG  LYS A 108      -8.147  21.864  26.564  1.00 40.76           C  
ATOM    792  CD  LYS A 108      -8.660  20.478  26.928  1.00 44.76           C  
ATOM    793  CE  LYS A 108      -7.730  19.358  26.343  1.00 47.77           C  
ATOM    794  NZ  LYS A 108      -7.280  19.502  24.823  1.00 32.65           N  
ATOM    795  N   THR A 109      -6.397  24.456  28.694  1.00 39.45           N  
ATOM    796  CA  THR A 109      -4.952  24.502  28.572  1.00 37.93           C  
ATOM    797  C   THR A 109      -4.258  25.105  29.766  1.00 40.39           C  
ATOM    798  O   THR A 109      -3.073  24.950  29.898  1.00 42.17           O  
ATOM    799  CB  THR A 109      -4.472  25.338  27.349  1.00 37.69           C  
ATOM    800  OG1 THR A 109      -4.797  26.722  27.540  1.00 37.77           O  
ATOM    801  CG2 THR A 109      -5.061  24.784  25.996  1.00 36.16           C  
ATOM    802  N   GLY A 110      -4.960  25.893  30.568  1.00 42.84           N  
ATOM    803  CA  GLY A 110      -4.327  26.585  31.662  1.00 41.24           C  
ATOM    804  C   GLY A 110      -3.739  27.919  31.381  1.00 43.44           C  
ATOM    805  O   GLY A 110      -3.146  28.503  32.257  1.00 45.96           O  
ATOM    806  N   PHE A 111      -3.874  28.444  30.180  1.00 43.03           N  
ATOM    807  CA  PHE A 111      -3.396  29.805  29.960  1.00 41.79           C  
ATOM    808  C   PHE A 111      -4.334  30.562  29.048  1.00 39.60           C  
ATOM    809  O   PHE A 111      -5.096  29.954  28.311  1.00 42.59           O  
ATOM    810  CB  PHE A 111      -1.924  29.854  29.491  1.00 45.76           C  
ATOM    811  CG  PHE A 111      -1.704  29.416  28.073  1.00 42.61           C  
ATOM    812  CD1 PHE A 111      -1.715  28.076  27.738  1.00 49.68           C  
ATOM    813  CD2 PHE A 111      -1.460  30.347  27.096  1.00 43.58           C  
ATOM    814  CE1 PHE A 111      -1.490  27.676  26.409  1.00 46.65           C  
ATOM    815  CE2 PHE A 111      -1.247  29.966  25.789  1.00 46.05           C  
ATOM    816  CZ  PHE A 111      -1.264  28.630  25.447  1.00 43.26           C  
ATOM    817  N   ASP A 112      -4.312  31.881  29.165  1.00 37.79           N  
ATOM    818  CA  ASP A 112      -5.241  32.738  28.488  1.00 40.72           C  
ATOM    819  C   ASP A 112      -4.501  33.894  27.797  1.00 43.68           C  
ATOM    820  O   ASP A 112      -4.217  34.928  28.416  1.00 45.51           O  
ATOM    821  CB  ASP A 112      -6.285  33.230  29.476  1.00 40.92           C  
ATOM    822  CG  ASP A 112      -7.390  33.998  28.827  1.00 44.92           C  
ATOM    823  OD1 ASP A 112      -7.347  34.229  27.599  1.00 42.92           O  
ATOM    824  OD2 ASP A 112      -8.320  34.377  29.572  1.00 36.89           O  
ATOM    825  N   PRO A 113      -4.182  33.714  26.497  1.00 43.74           N  
ATOM    826  CA  PRO A 113      -3.558  34.739  25.628  1.00 46.27           C  
ATOM    827  C   PRO A 113      -4.180  36.118  25.664  1.00 46.67           C  
ATOM    828  O   PRO A 113      -3.456  37.112  25.531  1.00 48.82           O  
ATOM    829  CB  PRO A 113      -3.708  34.124  24.219  1.00 45.32           C  
ATOM    830  CG  PRO A 113      -3.594  32.669  24.489  1.00 41.46           C  
ATOM    831  CD  PRO A 113      -4.357  32.438  25.762  1.00 41.64           C  
ATOM    832  N   ARG A 114      -5.496  36.182  25.853  1.00 46.20           N  
ATOM    833  CA  ARG A 114      -6.202  37.443  25.971  1.00 43.98           C  
ATOM    834  C   ARG A 114      -5.664  38.310  27.131  1.00 45.83           C  
ATOM    835  O   ARG A 114      -5.692  39.525  27.044  1.00 49.76           O  
ATOM    836  CB  ARG A 114      -7.720  37.218  26.148  1.00 42.74           C  
ATOM    837  CG  ARG A 114      -8.375  36.296  25.143  1.00 45.75           C  
ATOM    838  CD  ARG A 114      -9.805  35.962  25.506  1.00 43.00           C  
ATOM    839  NE  ARG A 114      -9.859  35.081  26.656  1.00 45.81           N  
ATOM    840  CZ  ARG A 114     -10.977  34.691  27.244  1.00 37.33           C  
ATOM    841  NH1 ARG A 114     -12.176  35.044  26.773  1.00 39.33           N  
ATOM    842  NH2 ARG A 114     -10.898  33.925  28.303  1.00 44.01           N  
ATOM    843  N   ARG A 115      -5.155  37.676  28.179  1.00 47.35           N  
ATOM    844  CA  ARG A 115      -4.649  38.358  29.372  1.00 49.99           C  
ATOM    845  C   ARG A 115      -3.114  38.537  29.410  1.00 51.70           C  
ATOM    846  O   ARG A 115      -2.576  38.864  30.455  1.00 52.99           O  
ATOM    847  CB  ARG A 115      -5.062  37.550  30.621  1.00 49.73           C  
ATOM    848  CG  ARG A 115      -6.587  37.366  30.804  1.00 54.22           C  
ATOM    849  N   LEU A 116      -2.401  38.290  28.309  1.00 49.93           N  
ATOM    850  CA  LEU A 116      -0.943  38.357  28.334  1.00 48.37           C  
ATOM    851  C   LEU A 116      -0.479  39.548  27.533  1.00 47.86           C  
ATOM    852  O   LEU A 116      -1.115  39.934  26.561  1.00 49.52           O  
ATOM    853  CB  LEU A 116      -0.316  37.063  27.785  1.00 47.11           C  
ATOM    854  CG  LEU A 116      -0.648  35.799  28.552  1.00 45.79           C  
ATOM    855  CD1 LEU A 116      -0.156  34.529  27.817  1.00 49.31           C  
ATOM    856  CD2 LEU A 116      -0.118  35.836  29.956  1.00 48.38           C  
ATOM    857  N   THR A 117       0.657  40.110  27.917  1.00 46.56           N  
ATOM    858  CA  THR A 117       1.170  41.323  27.277  1.00 48.00           C  
ATOM    859  C   THR A 117       1.793  41.017  25.929  1.00 44.85           C  
ATOM    860  O   THR A 117       1.614  41.772  24.969  1.00 45.34           O  
ATOM    861  CB  THR A 117       2.198  42.056  28.192  1.00 49.00           C  
ATOM    862  OG1 THR A 117       3.044  41.093  28.819  1.00 55.39           O  
ATOM    863  CG2 THR A 117       1.480  42.794  29.266  1.00 48.38           C  
ATOM    864  N   THR A 118       2.510  39.909  25.857  1.00 44.73           N  
ATOM    865  CA  THR A 118       3.067  39.439  24.594  1.00 42.68           C  
ATOM    866  C   THR A 118       1.930  39.286  23.577  1.00 40.88           C  
ATOM    867  O   THR A 118       0.849  38.783  23.908  1.00 37.28           O  
ATOM    868  CB  THR A 118       3.766  38.105  24.759  1.00 45.23           C  
ATOM    869  OG1 THR A 118       4.901  38.271  25.617  1.00 44.90           O  
ATOM    870  CG2 THR A 118       4.212  37.518  23.377  1.00 45.77           C  
ATOM    871  N   SER A 119       2.181  39.710  22.353  1.00 36.79           N  
ATOM    872  CA  SER A 119       1.186  39.598  21.291  1.00 38.41           C  
ATOM    873  C   SER A 119       1.052  38.119  20.750  1.00 37.35           C  
ATOM    874  O   SER A 119       1.969  37.579  20.113  1.00 31.83           O  
ATOM    875  CB  SER A 119       1.521  40.621  20.215  1.00 39.67           C  
ATOM    876  OG  SER A 119       0.719  40.405  19.085  1.00 49.72           O  
ATOM    877  N   TYR A 120      -0.059  37.467  21.110  1.00 34.93           N  
ATOM    878  CA  TYR A 120      -0.392  36.110  20.685  1.00 34.33           C  
ATOM    879  C   TYR A 120      -1.329  36.109  19.494  1.00 35.22           C  
ATOM    880  O   TYR A 120      -2.164  37.007  19.330  1.00 32.91           O  
ATOM    881  CB  TYR A 120      -1.093  35.311  21.811  1.00 36.42           C  
ATOM    882  CG  TYR A 120      -0.172  34.644  22.797  1.00 33.29           C  
ATOM    883  CD1 TYR A 120       0.583  35.413  23.690  1.00 39.48           C  
ATOM    884  CD2 TYR A 120      -0.005  33.268  22.812  1.00 37.13           C  
ATOM    885  CE1 TYR A 120       1.470  34.821  24.578  1.00 41.56           C  
ATOM    886  CE2 TYR A 120       0.863  32.665  23.683  1.00 41.00           C  
ATOM    887  CZ  TYR A 120       1.601  33.457  24.574  1.00 42.27           C  
ATOM    888  OH  TYR A 120       2.437  32.851  25.448  1.00 44.84           O  
ATOM    889  N   LEU A 121      -1.188  35.085  18.663  1.00 31.97           N  
ATOM    890  CA  LEU A 121      -2.245  34.677  17.756  1.00 29.91           C  
ATOM    891  C   LEU A 121      -2.789  33.282  18.168  1.00 29.78           C  
ATOM    892  O   LEU A 121      -2.035  32.422  18.606  1.00 29.72           O  
ATOM    893  CB  LEU A 121      -1.721  34.621  16.330  1.00 29.93           C  
ATOM    894  CG  LEU A 121      -1.488  35.953  15.622  1.00 27.39           C  
ATOM    895  CD1 LEU A 121      -0.651  35.693  14.274  1.00 27.25           C  
ATOM    896  CD2 LEU A 121      -2.815  36.676  15.422  1.00 34.28           C  
ATOM    897  N   TYR A 122      -4.088  33.091  17.993  1.00 29.21           N  
ATOM    898  CA  TYR A 122      -4.659  31.757  17.969  1.00 31.88           C  
ATOM    899  C   TYR A 122      -4.650  31.295  16.512  1.00 32.21           C  
ATOM    900  O   TYR A 122      -4.714  32.112  15.602  1.00 34.46           O  
ATOM    901  CB  TYR A 122      -6.088  31.776  18.484  1.00 31.32           C  
ATOM    902  CG  TYR A 122      -6.277  32.147  19.956  1.00 33.27           C  
ATOM    903  CD1 TYR A 122      -6.227  33.461  20.369  1.00 30.90           C  
ATOM    904  CD2 TYR A 122      -6.533  31.165  20.925  1.00 30.47           C  
ATOM    905  CE1 TYR A 122      -6.493  33.815  21.700  1.00 36.76           C  
ATOM    906  CE2 TYR A 122      -6.774  31.518  22.259  1.00 30.73           C  
ATOM    907  CZ  TYR A 122      -6.751  32.849  22.632  1.00 33.16           C  
ATOM    908  OH  TYR A 122      -6.989  33.212  23.947  1.00 34.99           O  
ATOM    909  N   PHE A 123      -4.451  30.015  16.285  1.00 30.88           N  
ATOM    910  CA  PHE A 123      -4.635  29.446  14.994  1.00 27.52           C  
ATOM    911  C   PHE A 123      -5.671  28.352  15.069  1.00 29.40           C  
ATOM    912  O   PHE A 123      -5.560  27.455  15.903  1.00 28.27           O  
ATOM    913  CB  PHE A 123      -3.333  28.889  14.444  1.00 29.80           C  
ATOM    914  CG  PHE A 123      -2.318  29.947  14.138  1.00 30.29           C  
ATOM    915  CD1 PHE A 123      -1.438  30.369  15.114  1.00 30.75           C  
ATOM    916  CD2 PHE A 123      -2.279  30.541  12.900  1.00 33.31           C  
ATOM    917  CE1 PHE A 123      -0.515  31.364  14.825  1.00 34.98           C  
ATOM    918  CE2 PHE A 123      -1.382  31.547  12.628  1.00 34.16           C  
ATOM    919  CZ  PHE A 123      -0.486  31.920  13.591  1.00 30.14           C  
ATOM    920  N   ARG A 124      -6.646  28.426  14.176  1.00 27.60           N  
ATOM    921  CA  ARG A 124      -7.685  27.425  14.044  1.00 30.24           C  
ATOM    922  C   ARG A 124      -7.271  26.506  12.926  1.00 28.24           C  
ATOM    923  O   ARG A 124      -6.972  26.962  11.803  1.00 28.16           O  
ATOM    924  CB  ARG A 124      -9.018  28.081  13.734  1.00 32.03           C  
ATOM    925  CG  ARG A 124     -10.190  27.076  13.566  1.00 27.80           C  
ATOM    926  CD  ARG A 124     -11.574  27.704  13.800  1.00 36.12           C  
ATOM    927  NE  ARG A 124     -11.773  28.779  12.859  1.00 37.40           N  
ATOM    928  CZ  ARG A 124     -12.640  29.797  12.980  1.00 40.91           C  
ATOM    929  NH1 ARG A 124     -13.460  29.911  13.995  1.00 39.02           N  
ATOM    930  NH2 ARG A 124     -12.689  30.699  12.033  1.00 35.98           N  
ATOM    931  N   ILE A 125      -7.145  25.225  13.254  1.00 28.73           N  
ATOM    932  CA  ILE A 125      -6.591  24.227  12.323  1.00 27.28           C  
ATOM    933  C   ILE A 125      -7.712  23.314  11.914  1.00 27.78           C  
ATOM    934  O   ILE A 125      -8.380  22.652  12.763  1.00 31.57           O  
ATOM    935  CB  ILE A 125      -5.437  23.440  12.976  1.00 29.69           C  
ATOM    936  CG1 ILE A 125      -4.270  24.391  13.264  1.00 33.59           C  
ATOM    937  CG2 ILE A 125      -5.017  22.268  12.091  1.00 30.18           C  
ATOM    938  CD1 ILE A 125      -3.353  23.941  14.382  1.00 33.81           C  
ATOM    939  N   SER A 126      -7.916  23.297  10.611  1.00 31.13           N  
ATOM    940  CA  SER A 126      -8.915  22.479   9.963  1.00 29.01           C  
ATOM    941  C   SER A 126      -8.259  21.203   9.476  1.00 28.92           C  
ATOM    942  O   SER A 126      -7.391  21.256   8.643  1.00 30.54           O  
ATOM    943  CB  SER A 126      -9.523  23.256   8.803  1.00 33.72           C  
ATOM    944  OG  SER A 126     -10.167  24.413   9.315  1.00 34.67           O  
ATOM    945  N   PRO A 127      -8.640  20.057  10.045  1.00 30.58           N  
ATOM    946  CA  PRO A 127      -8.000  18.812   9.618  1.00 33.00           C  
ATOM    947  C   PRO A 127      -8.378  18.389   8.219  1.00 30.95           C  
ATOM    948  O   PRO A 127      -9.507  18.562   7.804  1.00 29.50           O  
ATOM    949  CB  PRO A 127      -8.515  17.770  10.621  1.00 33.17           C  
ATOM    950  CG  PRO A 127      -9.514  18.404  11.427  1.00 37.37           C  
ATOM    951  CD  PRO A 127      -9.631  19.850  11.105  1.00 33.06           C  
ATOM    952  N   ARG A 128      -7.425  17.881   7.462  1.00 29.88           N  
ATOM    953  CA  ARG A 128      -7.696  17.415   6.125  1.00 30.75           C  
ATOM    954  C   ARG A 128      -7.473  15.889   6.051  1.00 33.29           C  
ATOM    955  O   ARG A 128      -8.163  15.184   5.338  1.00 32.57           O  
ATOM    956  CB  ARG A 128      -6.763  18.111   5.121  1.00 30.81           C  
ATOM    957  CG  ARG A 128      -6.959  19.618   5.063  1.00 40.91           C  
ATOM    958  CD  ARG A 128      -8.335  19.957   4.586  1.00 46.23           C  
ATOM    959  NE  ARG A 128      -8.563  19.432   3.241  1.00 49.40           N  
ATOM    960  CZ  ARG A 128      -9.746  19.373   2.625  1.00 49.24           C  
ATOM    961  NH1 ARG A 128     -10.842  19.796   3.220  1.00 41.11           N  
ATOM    962  NH2 ARG A 128      -9.812  18.894   1.394  1.00 42.35           N  
ATOM    963  N   ARG A 129      -6.454  15.422   6.750  1.00 29.67           N  
ATOM    964  CA  ARG A 129      -6.111  14.006   6.799  1.00 30.51           C  
ATOM    965  C   ARG A 129      -5.783  13.632   8.233  1.00 30.22           C  
ATOM    966  O   ARG A 129      -5.126  14.393   8.959  1.00 31.58           O  
ATOM    967  CB  ARG A 129      -4.906  13.749   5.908  1.00 30.93           C  
ATOM    968  CG  ARG A 129      -4.647  12.343   5.640  1.00 39.52           C  
ATOM    969  CD  ARG A 129      -3.428  12.197   4.732  1.00 51.47           C  
ATOM    970  NE  ARG A 129      -3.163  10.783   4.489  1.00 58.04           N  
ATOM    971  CZ  ARG A 129      -1.991  10.279   4.115  1.00 59.79           C  
ATOM    972  NH1 ARG A 129      -0.908  11.047   3.985  1.00 54.42           N  
ATOM    973  NH2 ARG A 129      -1.895   8.984   3.893  1.00 60.59           N  
ATOM    974  N   VAL A 130      -6.244  12.464   8.628  1.00 29.89           N  
ATOM    975  CA  VAL A 130      -5.954  11.873   9.933  1.00 29.31           C  
ATOM    976  C   VAL A 130      -5.582  10.405   9.782  1.00 31.69           C  
ATOM    977  O   VAL A 130      -6.264   9.604   9.081  1.00 30.53           O  
ATOM    978  CB  VAL A 130      -7.159  11.944  10.872  1.00 29.13           C  
ATOM    979  CG1 VAL A 130      -6.838  11.293  12.253  1.00 31.71           C  
ATOM    980  CG2 VAL A 130      -7.664  13.401  11.018  1.00 28.46           C  
ATOM    981  N   GLN A 131      -4.488  10.047  10.429  1.00 31.53           N  
ATOM    982  CA  GLN A 131      -4.094   8.666  10.525  1.00 32.61           C  
ATOM    983  C   GLN A 131      -3.975   8.302  12.000  1.00 35.31           C  
ATOM    984  O   GLN A 131      -3.595   9.146  12.829  1.00 35.34           O  
ATOM    985  CB  GLN A 131      -2.804   8.447   9.777  1.00 34.22           C  
ATOM    986  CG  GLN A 131      -2.934   8.745   8.270  1.00 38.75           C  
ATOM    987  CD  GLN A 131      -1.585   8.740   7.654  1.00 56.39           C  
ATOM    988  OE1 GLN A 131      -1.117   7.694   7.236  1.00 51.19           O  
ATOM    989  NE2 GLN A 131      -0.900   9.896   7.674  1.00 57.28           N  
ATOM    990  N   ALA A 132      -4.352   7.069  12.330  1.00 31.81           N  
ATOM    991  CA  ALA A 132      -4.325   6.597  13.740  1.00 30.85           C  
ATOM    992  C   ALA A 132      -3.943   5.185  13.783  1.00 36.36           C  
ATOM    993  O   ALA A 132      -4.551   4.364  13.080  1.00 38.35           O  
ATOM    994  CB  ALA A 132      -5.671   6.770  14.391  1.00 34.05           C  
ATOM    995  N   TRP A 133      -2.922   4.863  14.541  1.00 37.21           N  
ATOM    996  CA  TRP A 133      -2.632   3.450  14.738  1.00 42.98           C  
ATOM    997  C   TRP A 133      -1.859   3.134  16.010  1.00 41.45           C  
ATOM    998  O   TRP A 133      -1.220   3.997  16.605  1.00 39.00           O  
ATOM    999  CB  TRP A 133      -1.868   2.902  13.522  1.00 43.42           C  
ATOM   1000  CG  TRP A 133      -0.436   3.429  13.290  1.00 45.59           C  
ATOM   1001  CD1 TRP A 133       0.730   2.743  13.514  1.00 49.38           C  
ATOM   1002  CD2 TRP A 133      -0.040   4.706  12.746  1.00 51.93           C  
ATOM   1003  NE1 TRP A 133       1.814   3.516  13.149  1.00 45.99           N  
ATOM   1004  CE2 TRP A 133       1.375   4.715  12.674  1.00 45.91           C  
ATOM   1005  CE3 TRP A 133      -0.740   5.832  12.291  1.00 51.72           C  
ATOM   1006  CZ2 TRP A 133       2.096   5.798  12.162  1.00 44.31           C  
ATOM   1007  CZ3 TRP A 133      -0.009   6.932  11.812  1.00 52.62           C  
ATOM   1008  CH2 TRP A 133       1.395   6.890  11.735  1.00 48.41           C  
ATOM   1009  N   ARG A 134      -1.927   1.864  16.379  1.00 45.42           N  
ATOM   1010  CA  ARG A 134      -1.281   1.324  17.572  1.00 46.29           C  
ATOM   1011  C   ARG A 134      -0.089   0.468  17.142  1.00 46.45           C  
ATOM   1012  O   ARG A 134       0.966   0.994  16.847  1.00 44.26           O  
ATOM   1013  CB  ARG A 134      -2.299   0.556  18.430  1.00 45.15           C  
ATOM   1014  CG  ARG A 134      -3.399   1.456  18.852  1.00 47.67           C  
ATOM   1015  CD  ARG A 134      -4.407   0.874  19.844  1.00 42.44           C  
ATOM   1016  NE  ARG A 134      -5.153   2.008  20.421  1.00 41.77           N  
ATOM   1017  CZ  ARG A 134      -6.229   1.927  21.207  1.00 53.20           C  
ATOM   1018  NH1 ARG A 134      -6.736   0.746  21.527  1.00 57.11           N  
ATOM   1019  NH2 ARG A 134      -6.778   3.055  21.691  1.00 42.43           N  
ATOM   1020  N   GLU A 135      -0.223  -0.839  17.083  1.00 48.20           N  
ATOM   1021  CA  GLU A 135       0.970  -1.628  16.774  1.00 52.06           C  
ATOM   1022  C   GLU A 135       1.038  -1.785  15.272  1.00 51.16           C  
ATOM   1023  O   GLU A 135       0.213  -1.210  14.555  1.00 48.67           O  
ATOM   1024  CB  GLU A 135       0.958  -2.967  17.526  1.00 54.16           C  
ATOM   1025  CG  GLU A 135       1.119  -2.809  19.064  1.00 60.60           C  
ATOM   1026  CD  GLU A 135       2.494  -2.256  19.503  1.00 69.43           C  
ATOM   1027  OE1 GLU A 135       3.488  -2.460  18.766  1.00 68.38           O  
ATOM   1028  OE2 GLU A 135       2.574  -1.623  20.593  1.00 66.54           O  
ATOM   1029  N   ALA A 136       2.030  -2.547  14.807  1.00 48.07           N  
ATOM   1030  CA  ALA A 136       2.254  -2.766  13.381  1.00 46.95           C  
ATOM   1031  C   ALA A 136       1.020  -3.325  12.675  1.00 45.27           C  
ATOM   1032  O   ALA A 136       0.777  -2.977  11.512  1.00 44.57           O  
ATOM   1033  CB  ALA A 136       3.461  -3.699  13.160  1.00 49.64           C  
ATOM   1034  N   ASN A 137       0.245  -4.171  13.377  1.00 43.97           N  
ATOM   1035  CA  ASN A 137      -0.990  -4.762  12.818  1.00 43.69           C  
ATOM   1036  C   ASN A 137      -2.052  -3.750  12.397  1.00 40.82           C  
ATOM   1037  O   ASN A 137      -3.012  -4.121  11.730  1.00 40.57           O  
ATOM   1038  CB  ASN A 137      -1.622  -5.825  13.773  1.00 46.40           C  
ATOM   1039  CG  ASN A 137      -2.267  -5.211  15.023  1.00 50.72           C  
ATOM   1040  OD1 ASN A 137      -1.854  -4.142  15.496  1.00 46.39           O  
ATOM   1041  ND2 ASN A 137      -3.268  -5.903  15.571  1.00 46.53           N  
ATOM   1042  N   GLU A 138      -1.908  -2.497  12.836  1.00 41.40           N  
ATOM   1043  CA  GLU A 138      -2.851  -1.432  12.493  1.00 42.79           C  
ATOM   1044  C   GLU A 138      -2.300  -0.455  11.461  1.00 41.91           C  
ATOM   1045  O   GLU A 138      -2.965   0.523  11.131  1.00 39.88           O  
ATOM   1046  CB  GLU A 138      -3.254  -0.650  13.747  1.00 42.38           C  
ATOM   1047  CG  GLU A 138      -4.186  -1.418  14.637  1.00 42.84           C  
ATOM   1048  CD  GLU A 138      -4.891  -0.524  15.617  1.00 46.87           C  
ATOM   1049  OE1 GLU A 138      -4.415   0.638  15.847  1.00 39.03           O  
ATOM   1050  OE2 GLU A 138      -5.926  -0.997  16.149  1.00 40.50           O  
ATOM   1051  N   LEU A 139      -1.103  -0.711  10.932  1.00 42.41           N  
ATOM   1052  CA  LEU A 139      -0.621   0.059   9.786  1.00 42.30           C  
ATOM   1053  C   LEU A 139      -1.666  -0.012   8.674  1.00 40.62           C  
ATOM   1054  O   LEU A 139      -2.066   1.017   8.142  1.00 43.09           O  
ATOM   1055  CB  LEU A 139       0.757  -0.431   9.314  1.00 43.98           C  
ATOM   1056  CG  LEU A 139       1.872   0.034  10.272  1.00 46.92           C  
ATOM   1057  CD1 LEU A 139       3.162  -0.767  10.105  1.00 49.42           C  
ATOM   1058  CD2 LEU A 139       2.127   1.539  10.104  1.00 47.51           C  
ATOM   1059  N   SER A 140      -2.135  -1.221   8.384  1.00 35.33           N  
ATOM   1060  CA  SER A 140      -3.309  -1.443   7.549  1.00 37.16           C  
ATOM   1061  C   SER A 140      -4.526  -0.821   8.194  1.00 37.55           C  
ATOM   1062  O   SER A 140      -4.844  -1.142   9.356  1.00 40.57           O  
ATOM   1063  CB  SER A 140      -3.568  -2.954   7.388  1.00 36.35           C  
ATOM   1064  OG  SER A 140      -4.798  -3.233   6.738  1.00 35.49           O  
ATOM   1065  N   GLY A 141      -5.193   0.068   7.466  1.00 34.96           N  
ATOM   1066  CA  GLY A 141      -6.422   0.699   7.949  1.00 36.64           C  
ATOM   1067  C   GLY A 141      -6.191   1.940   8.803  1.00 37.86           C  
ATOM   1068  O   GLY A 141      -7.109   2.433   9.482  1.00 36.76           O  
ATOM   1069  N   ARG A 142      -4.965   2.463   8.758  1.00 37.79           N  
ATOM   1070  CA  ARG A 142      -4.591   3.587   9.605  1.00 31.87           C  
ATOM   1071  C   ARG A 142      -5.189   4.918   9.146  1.00 33.28           C  
ATOM   1072  O   ARG A 142      -5.371   5.778   9.968  1.00 30.15           O  
ATOM   1073  CB  ARG A 142      -3.080   3.702   9.749  1.00 33.89           C  
ATOM   1074  CG  ARG A 142      -2.361   4.179   8.508  1.00 39.30           C  
ATOM   1075  CD  ARG A 142      -0.892   4.361   8.845  1.00 49.01           C  
ATOM   1076  NE  ARG A 142      -0.065   4.766   7.707  1.00 50.80           N  
ATOM   1077  CZ  ARG A 142       0.441   3.944   6.777  1.00 59.08           C  
ATOM   1078  NH1 ARG A 142       0.205   2.635   6.782  1.00 59.55           N  
ATOM   1079  NH2 ARG A 142       1.197   4.448   5.813  1.00 58.67           N  
ATOM   1080  N   GLU A 143      -5.574   5.072   7.872  1.00 33.99           N  
ATOM   1081  CA  GLU A 143      -6.156   6.358   7.416  1.00 33.31           C  
ATOM   1082  C   GLU A 143      -7.639   6.499   7.727  1.00 28.33           C  
ATOM   1083  O   GLU A 143      -8.466   5.697   7.271  1.00 27.45           O  
ATOM   1084  CB  GLU A 143      -5.947   6.590   5.918  1.00 35.16           C  
ATOM   1085  CG  GLU A 143      -6.244   8.062   5.509  1.00 36.89           C  
ATOM   1086  CD  GLU A 143      -5.973   8.333   4.013  1.00 39.49           C  
ATOM   1087  OE1 GLU A 143      -6.823   8.043   3.153  1.00 41.96           O  
ATOM   1088  OE2 GLU A 143      -4.885   8.840   3.702  1.00 44.79           O  
ATOM   1089  N   LEU A 144      -8.000   7.549   8.472  1.00 28.76           N  
ATOM   1090  CA  LEU A 144      -9.337   7.684   9.023  1.00 28.66           C  
ATOM   1091  C   LEU A 144     -10.100   8.862   8.465  1.00 28.81           C  
ATOM   1092  O   LEU A 144     -11.322   8.896   8.576  1.00 29.01           O  
ATOM   1093  CB  LEU A 144      -9.279   7.829  10.543  1.00 32.28           C  
ATOM   1094  CG  LEU A 144      -8.661   6.670  11.334  1.00 37.68           C  
ATOM   1095  CD1 LEU A 144      -8.695   6.984  12.817  1.00 40.39           C  
ATOM   1096  CD2 LEU A 144      -9.329   5.348  11.040  1.00 35.12           C  
HETATM 1097  N   MSE A 145      -9.361   9.851   7.952  1.00 28.63           N  
HETATM 1098  CA  MSE A 145      -9.894  11.005   7.259  1.00 27.52           C  
HETATM 1099  C   MSE A 145      -9.027  11.315   6.069  1.00 29.45           C  
HETATM 1100  O   MSE A 145      -7.771  11.268   6.118  1.00 28.81           O  
HETATM 1101  CB  MSE A 145      -9.901  12.260   8.186  1.00 28.53           C  
HETATM 1102  CG  MSE A 145     -10.357  13.491   7.460  1.00 28.24           C  
HETATM 1103 SE   MSE A 145     -10.195  15.129   8.536  0.75 31.92          SE  
HETATM 1104  CE  MSE A 145     -11.390  14.682   9.812  1.00 35.76           C  
ATOM   1105  N   ARG A 146      -9.702  11.653   4.992  1.00 29.18           N  
ATOM   1106  CA  ARG A 146      -9.071  12.095   3.792  1.00 33.00           C  
ATOM   1107  C   ARG A 146      -9.918  13.191   3.229  1.00 33.29           C  
ATOM   1108  O   ARG A 146     -11.162  13.088   3.255  1.00 32.82           O  
ATOM   1109  CB  ARG A 146      -9.007  10.913   2.825  1.00 35.35           C  
ATOM   1110  CG  ARG A 146      -8.170  11.127   1.629  1.00 39.22           C  
ATOM   1111  CD  ARG A 146      -8.151   9.834   0.835  1.00 45.07           C  
ATOM   1112  NE  ARG A 146      -7.200   9.952  -0.228  1.00 49.77           N  
ATOM   1113  CZ  ARG A 146      -6.877   8.974  -1.062  1.00 52.91           C  
ATOM   1114  NH1 ARG A 146      -7.444   7.788  -0.958  1.00 34.76           N  
ATOM   1115  NH2 ARG A 146      -5.969   9.204  -1.995  1.00 54.83           N  
ATOM   1116  N   ASP A 147      -9.257  14.207   2.673  1.00 33.70           N  
ATOM   1117  CA  ASP A 147      -9.910  15.401   2.097  1.00 36.53           C  
ATOM   1118  C   ASP A 147     -10.945  16.016   3.014  1.00 38.60           C  
ATOM   1119  O   ASP A 147     -11.991  16.481   2.560  1.00 35.97           O  
ATOM   1120  CB  ASP A 147     -10.557  15.107   0.735  1.00 42.99           C  
ATOM   1121  CG  ASP A 147      -9.591  14.448  -0.253  1.00 39.92           C  
ATOM   1122  OD1 ASP A 147      -8.383  14.783  -0.261  1.00 49.96           O  
ATOM   1123  OD2 ASP A 147     -10.039  13.573  -1.016  1.00 54.01           O  
ATOM   1124  N   GLY A 148     -10.654  16.001   4.314  1.00 31.15           N  
ATOM   1125  CA  GLY A 148     -11.460  16.709   5.261  1.00 35.38           C  
ATOM   1126  C   GLY A 148     -12.677  15.971   5.734  1.00 33.14           C  
ATOM   1127  O   GLY A 148     -13.422  16.489   6.533  1.00 31.37           O  
ATOM   1128  N   GLU A 149     -12.830  14.729   5.332  1.00 34.94           N  
ATOM   1129  CA  GLU A 149     -14.036  13.918   5.682  1.00 34.29           C  
ATOM   1130  C   GLU A 149     -13.613  12.652   6.380  1.00 32.20           C  
ATOM   1131  O   GLU A 149     -12.746  11.938   5.872  1.00 27.95           O  
ATOM   1132  CB  GLU A 149     -14.804  13.522   4.413  1.00 38.31           C  
ATOM   1133  CG  GLU A 149     -15.294  14.669   3.563  1.00 42.09           C  
ATOM   1134  CD  GLU A 149     -16.285  15.551   4.285  1.00 46.72           C  
ATOM   1135  OE1 GLU A 149     -16.897  15.100   5.290  1.00 44.43           O  
ATOM   1136  OE2 GLU A 149     -16.416  16.708   3.835  1.00 58.54           O  
ATOM   1137  N   TRP A 150     -14.214  12.348   7.527  1.00 30.02           N  
ATOM   1138  CA  TRP A 150     -13.994  11.067   8.172  1.00 31.89           C  
ATOM   1139  C   TRP A 150     -14.455   9.938   7.218  1.00 29.94           C  
ATOM   1140  O   TRP A 150     -15.466  10.094   6.511  1.00 28.88           O  
ATOM   1141  CB  TRP A 150     -14.777  10.975   9.488  1.00 31.25           C  
ATOM   1142  CG  TRP A 150     -14.277  11.921  10.544  1.00 31.75           C  
ATOM   1143  CD1 TRP A 150     -14.875  13.101  10.949  1.00 30.34           C  
ATOM   1144  CD2 TRP A 150     -13.087  11.788  11.333  1.00 28.75           C  
ATOM   1145  NE1 TRP A 150     -14.148  13.677  11.917  1.00 37.53           N  
ATOM   1146  CE2 TRP A 150     -13.045  12.910  12.197  1.00 31.51           C  
ATOM   1147  CE3 TRP A 150     -12.073  10.832  11.422  1.00 31.74           C  
ATOM   1148  CZ2 TRP A 150     -12.022  13.120  13.101  1.00 32.96           C  
ATOM   1149  CZ3 TRP A 150     -11.034  11.045  12.329  1.00 31.33           C  
ATOM   1150  CH2 TRP A 150     -11.017  12.194  13.161  1.00 33.14           C  
ATOM   1151  N   LEU A 151     -13.708   8.835   7.183  1.00 30.48           N  
ATOM   1152  CA  LEU A 151     -13.987   7.745   6.239  1.00 29.41           C  
ATOM   1153  C   LEU A 151     -14.954   6.765   6.838  1.00 33.02           C  
ATOM   1154  O   LEU A 151     -14.730   6.197   7.926  1.00 35.04           O  
ATOM   1155  CB  LEU A 151     -12.678   7.087   5.812  1.00 33.31           C  
ATOM   1156  CG  LEU A 151     -11.668   8.077   5.151  1.00 29.69           C  
ATOM   1157  CD1 LEU A 151     -10.333   7.425   4.815  1.00 38.70           C  
ATOM   1158  CD2 LEU A 151     -12.311   8.644   3.871  1.00 38.74           C  
ATOM   1159  N   VAL A 152     -16.068   6.610   6.139  1.00 29.37           N  
ATOM   1160  CA  VAL A 152     -17.151   5.719   6.540  1.00 28.11           C  
ATOM   1161  C   VAL A 152     -17.250   4.694   5.433  1.00 29.14           C  
ATOM   1162  O   VAL A 152     -17.242   5.036   4.232  1.00 29.60           O  
ATOM   1163  CB  VAL A 152     -18.440   6.535   6.732  1.00 25.79           C  
ATOM   1164  CG1 VAL A 152     -19.643   5.596   6.941  1.00 32.37           C  
ATOM   1165  CG2 VAL A 152     -18.282   7.526   7.892  1.00 36.11           C  
ATOM   1166  N   THR A 153     -17.266   3.419   5.812  1.00 27.80           N  
ATOM   1167  CA  THR A 153     -17.379   2.348   4.875  1.00 28.19           C  
ATOM   1168  C   THR A 153     -18.615   2.437   3.957  1.00 24.25           C  
ATOM   1169  O   THR A 153     -19.703   2.694   4.428  1.00 23.97           O  
ATOM   1170  CB  THR A 153     -17.371   1.022   5.625  1.00 29.26           C  
ATOM   1171  OG1 THR A 153     -16.138   0.929   6.350  1.00 44.07           O  
ATOM   1172  CG2 THR A 153     -17.460  -0.073   4.689  1.00 28.83           C  
ATOM   1173  N   ASP A 154     -18.414   2.186   2.658  1.00 21.47           N  
ATOM   1174  CA  ASP A 154     -19.473   2.271   1.650  1.00 21.48           C  
ATOM   1175  C   ASP A 154     -20.484   1.164   1.782  1.00 24.82           C  
ATOM   1176  O   ASP A 154     -20.089   0.063   2.212  1.00 30.21           O  
ATOM   1177  CB  ASP A 154     -18.914   2.237   0.240  1.00 21.00           C  
ATOM   1178  CG  ASP A 154     -17.841   3.295  -0.004  1.00 27.13           C  
ATOM   1179  OD1 ASP A 154     -16.672   3.022   0.330  1.00 29.90           O  
ATOM   1180  OD2 ASP A 154     -18.177   4.387  -0.501  1.00 23.25           O  
ATOM   1181  OXT ASP A 154     -21.671   1.309   1.383  1.00 23.69           O  
TER    1182      ASP A 154                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
