
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1087),  selected  138 , name 2hq9_B
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2hq9_B.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      E       4           -
LGA    L     2_B      -       -           -
LGA    V     3_B      -       -           -
LGA    R     4_B      -       -           -
LGA    T     5_B      -       -           -
LGA    L     6_B      -       -           -
LGA    S     7_B      L       5          2.988
LGA    A     8_B      E       6          3.674
LGA    L     9_B      D       7          2.693
LGA    E    10_B      K       8          1.011
LGA    C    11_B      I       9          1.656
LGA    T    12_B      L      10          2.194
LGA    K    13_B      A      11          1.486
LGA    V    14_B      I      12          0.519
LGA    L    15_B      L      13          1.465
LGA    T    16_B      E      14          2.481
LGA    A    17_B      Q      15          2.093
LGA    N    18_B      H      16          1.103
LGA    R    19_B      Q      17          0.611
LGA    V    20_B      V      18          0.730
LGA    G    21_B      G      19          0.745
LGA    R    22_B      V      20          0.577
LGA    L    23_B      L      21          0.363
LGA    A    24_B      T      22          0.595
LGA    C    25_B      S      23          0.691
LGA    A    26_B      V      24          0.862
LGA    K    27_B      Q      25          2.571
LGA    D    28_B      G      26          2.530
LGA    G    29_B      D      27          2.508
LGA    Q    30_B      F      28          1.436
LGA    P    31_B      P      29          0.698
LGA    Y    32_B      H      30          0.654
LGA    V    33_B      A      31          0.728
LGA    V    34_B      R      32          0.586
LGA    P    35_B      Y      33          0.919
LGA    L    36_B      M      34          1.203
LGA    Y    37_B      T      35          0.514
LGA    Y    38_B      F      36          1.245
LGA    A    39_B      L      37          0.574
LGA    Y    40_B      H      38          0.627
LGA    S    41_B      D      39          0.251
LGA    D    42_B      G      40          3.243
LGA    A    43_B      L      41          2.315
LGA    H    44_B      T      42          1.177
LGA    L    45_B      L      43          0.806
LGA    Y    46_B      Y      44          1.132
LGA    A    47_B      T      45          1.733
LGA    F    48_B      P      46          1.238
LGA    S    49_B      S      47          0.763
LGA    X    50_B      G      48          1.795
LGA    P    51_B      K      49          3.480
LGA    -       -      E      50           -
LGA    G    52_B      L      51          1.662
LGA    K    53_B      P      52          1.349
LGA    K    54_B      K      53          1.184
LGA    I    55_B      T      54          1.018
LGA    E    56_B      E      55          0.972
LGA    W    57_B      E      56          1.109
LGA    X    58_B      V      57          0.909
LGA    R    59_B      R      58          0.410
LGA    A    60_B      R      59          0.360
LGA    N    61_B      N      60          0.448
LGA    P    62_B      P      61          0.453
LGA    R    63_B      H      62          0.456
LGA    V    64_B      V      63          0.349
LGA    S    65_B      C      64          0.442
LGA    V    66_B      V      65          0.488
LGA    Q    67_B      L      66          0.514
LGA    V    68_B      I      67          0.353
LGA    D    69_B      G      68          1.317
LGA    E    70_B      Y      69          4.141
LGA    H    71_B      D      70          3.283
LGA    G    72_B      S      71           #
LGA    Q    73_B      P      72           -
LGA    G    74_B      -       -           -
LGA    R    75_B      -       -           -
LGA    G    76_B      G      73          2.758
LGA    W    77_B      S      74          1.008
LGA    K    78_B      A      75          1.908
LGA    S    79_B      F      76          1.102
LGA    V    80_B      L      77          0.383
LGA    V    81_B      E      78          0.735
LGA    V    82_B      I      79          0.603
LGA    D    83_B      N      80          0.578
LGA    G    84_B      G      81          0.790
LGA    R    85_B      L      82          0.679
LGA    Y    86_B      A      83          0.773
LGA    E    87_B      S      84          1.419
LGA    E    88_B      L      85          0.443
LGA    L    89_B      E      86          1.658
LGA    P    90_B      E      87          3.449
LGA    D    91_B      -       -           -
LGA    L    92_B      -       -           -
LGA    I    93_B      -       -           -
LGA    G    94_B      -       -           -
LGA    H    95_B      D      88          1.403
LGA    K    96_B      E      89          2.195
LGA    L    97_B      S      90          1.808
LGA    Q    98_B      I      91          0.923
LGA    R    99_B      K      92          1.568
LGA    D   100_B      E      93          2.139
LGA    H   101_B      R      94          1.816
LGA    A   102_B      I      95          1.258
LGA    W   103_B      W      96          1.642
LGA    S   104_B      E      97          2.070
LGA    V   105_B      N      98          1.865
LGA    L   106_B      I      99          1.676
LGA    S   107_B      S     100          1.741
LGA    -       -      K     101           -
LGA    K   108_B      D     102          4.483
LGA    H   109_B      -       -           -
LGA    T   110_B      -       -           -
LGA    D   111_B      W     103           #
LGA    W   112_B      F     104           -
LGA    W   113_B      Q     105           -
LGA    E   114_B      G     106           -
LGA    P   115_B      E     107           -
LGA    G   116_B      D     108           -
LGA    A   117_B      -       -           -
LGA    L   118_B      -       -           -
LGA    S   128_B      S     109          3.468
LGA    A   129_B      P     110          2.154
LGA    P   130_B      S     111          1.082
LGA    H   131_B      F     112          1.091
LGA    V   132_B      V     113          1.706
LGA    F   133_B      V     114          1.683
LGA    F   134_B      I     115          2.112
LGA    R   135_B      K     116          0.757
LGA    I   136_B      I     117          0.720
LGA    L   137_B      V     118          0.839
LGA    I   138_B      P     119          1.371
LGA    E   139_B      E     120          1.519
LGA    Q   140_B      Q     121          0.846
LGA    V   141_B      I     122          0.428
LGA    S   142_B      R     123          0.568
LGA    G   143_B      I     124          0.763
LGA    R   144_B      L     125          1.851
LGA    E   145_B      N     126          3.102
LGA    A   146_B      S     127          5.528
LGA    S   147_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  124    5.0    113    1.74    21.24     83.839     6.154

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.072472 * X  +  -0.948097 * Y  +  -0.309614 * Z  +  53.710869
  Y_new =  -0.594195 * X  +  -0.290368 * Y  +   0.750079 * Z  +  33.538544
  Z_new =  -0.801050 * X  +   0.129611 * Y  +  -0.584398 * Z  +  50.838707 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.923340   -0.218252  [ DEG:   167.4951    -12.5049 ]
  Theta =   0.929046    2.212546  [ DEG:    53.2304    126.7696 ]
  Phi   =  -1.449429    1.692164  [ DEG:   -83.0461     96.9539 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hq9_B                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hq9_B.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  124   5.0  113   1.74   21.24  83.839
REMARK  ---------------------------------------------------------- 
MOLECULE 2hq9_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-JUL-06   2HQ9              
TITLE     CRYSTAL STRUCTURE OF A FAD-BINDING PROTEIN (NP_107146.1)              
TITLE    2 FROM MESORHIZOBIUM LOTI AT 1.95 A RESOLUTION                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MLL6688 PROTEIN;                                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RHIZOBIUM LOTI;                                 
SOURCE   3 ORGANISM_COMMON: MESORHIZOBIUM LOTI;                                 
SOURCE   4 GENE: NP_107146.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_107146.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2HQ9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_107146.1) FROM MESORHIZOBIUM LOTI AT 1.95 A              
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2HQ9 A    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
DBREF  2HQ9 B    1   148  UNP    Q988L5   Q988L5_RHILO     1    148             
SEQRES   1 A  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 A  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 A  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 A  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 A  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 A  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 A  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 A  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 A  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 A  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 A  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 A  149  GLY ARG GLU ALA SER GLU                                      
SEQRES   1 B  149  GLY MSE LEU VAL ARG THR LEU SER ALA LEU GLU CYS THR          
SEQRES   2 B  149  LYS VAL LEU THR ALA ASN ARG VAL GLY ARG LEU ALA CYS          
SEQRES   3 B  149  ALA LYS ASP GLY GLN PRO TYR VAL VAL PRO LEU TYR TYR          
SEQRES   4 B  149  ALA TYR SER ASP ALA HIS LEU TYR ALA PHE SER MSE PRO          
SEQRES   5 B  149  GLY LYS LYS ILE GLU TRP MSE ARG ALA ASN PRO ARG VAL          
SEQRES   6 B  149  SER VAL GLN VAL ASP GLU HIS GLY GLN GLY ARG GLY TRP          
SEQRES   7 B  149  LYS SER VAL VAL VAL ASP GLY ARG TYR GLU GLU LEU PRO          
SEQRES   8 B  149  ASP LEU ILE GLY HIS LYS LEU GLN ARG ASP HIS ALA TRP          
SEQRES   9 B  149  SER VAL LEU SER LYS HIS THR ASP TRP TRP GLU PRO GLY          
SEQRES  10 B  149  ALA LEU LYS PRO VAL THR PRO PRO THR ALA ASP SER ALA          
SEQRES  11 B  149  PRO HIS VAL PHE PHE ARG ILE LEU ILE GLU GLN VAL SER          
SEQRES  12 B  149  GLY ARG GLU ALA SER GLU                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  58       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  58       8                                                       
HET     CL      1       1                                                       
HET    FAD  A 200      53                                                       
HET    FAD  B 200      53                                                       
HET    EDO      2       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   6  EDO    C2 H6 O2                                                     
FORMUL   7  HOH   *178(H2 O)                                                    
CRYST1   47.852   74.895   84.626  90.00  90.00  90.00 P 21 21 21    8          
HETATM 1091  N   MSE B   1       4.330  -6.824  18.368  1.00 46.39           N  
HETATM 1092  CA  MSE B   1       3.185  -5.869  18.484  1.00 46.28           C  
HETATM 1093  C   MSE B   1       2.218  -5.990  17.309  1.00 44.25           C  
HETATM 1094  O   MSE B   1       2.601  -5.723  16.150  1.00 44.80           O  
HETATM 1095  CB  MSE B   1       3.695  -4.414  18.553  1.00 47.65           C  
HETATM 1096  CG  MSE B   1       4.629  -4.141  19.737  1.00 50.54           C  
HETATM 1097 SE   MSE B   1       3.716  -4.010  21.444  0.75 56.80          SE  
HETATM 1098  CE  MSE B   1       5.215  -4.521  22.709  1.00 54.20           C  
ATOM   1099  N   LEU B   2       0.976  -6.377  17.602  1.00 41.23           N  
ATOM   1100  CA  LEU B   2      -0.117  -6.114  16.675  1.00 39.08           C  
ATOM   1101  C   LEU B   2      -0.092  -4.605  16.471  1.00 37.07           C  
ATOM   1102  O   LEU B   2      -0.277  -3.882  17.425  1.00 36.38           O  
ATOM   1103  CB  LEU B   2      -1.474  -6.532  17.250  1.00 38.77           C  
ATOM   1104  N   VAL B   3       0.194  -4.152  15.254  1.00 34.89           N  
ATOM   1105  CA  VAL B   3      -0.039  -2.757  14.866  1.00 33.94           C  
ATOM   1106  C   VAL B   3      -1.173  -2.685  13.842  1.00 32.88           C  
ATOM   1107  O   VAL B   3      -1.214  -3.442  12.876  1.00 32.69           O  
ATOM   1108  CB  VAL B   3       1.241  -2.104  14.291  1.00 34.20           C  
ATOM   1109  CG1 VAL B   3       0.998  -0.668  13.877  1.00 32.37           C  
ATOM   1110  CG2 VAL B   3       2.397  -2.197  15.313  1.00 34.67           C  
ATOM   1111  N   ARG B   4      -2.096  -1.763  14.051  1.00 31.81           N  
ATOM   1112  CA  ARG B   4      -3.252  -1.629  13.174  1.00 31.24           C  
ATOM   1113  C   ARG B   4      -3.620  -0.163  13.057  1.00 29.75           C  
ATOM   1114  O   ARG B   4      -3.272   0.632  13.926  1.00 26.62           O  
ATOM   1115  CB  ARG B   4      -4.429  -2.390  13.754  1.00 32.33           C  
ATOM   1116  CG  ARG B   4      -4.425  -2.409  15.269  1.00 36.25           C  
ATOM   1117  CD  ARG B   4      -5.650  -3.119  15.830  1.00 40.75           C  
ATOM   1118  NE  ARG B   4      -6.855  -2.282  15.778  1.00 42.12           N  
ATOM   1119  CZ  ARG B   4      -7.069  -1.209  16.545  1.00 43.89           C  
ATOM   1120  NH1 ARG B   4      -6.147  -0.809  17.425  1.00 44.50           N  
ATOM   1121  NH2 ARG B   4      -8.207  -0.519  16.427  1.00 41.40           N  
ATOM   1122  N   THR B   5      -4.348   0.162  11.997  1.00 28.02           N  
ATOM   1123  CA  THR B   5      -4.792   1.507  11.796  1.00 28.34           C  
ATOM   1124  C   THR B   5      -6.086   1.738  12.565  1.00 27.71           C  
ATOM   1125  O   THR B   5      -6.848   0.822  12.772  1.00 26.56           O  
ATOM   1126  CB  THR B   5      -5.039   1.832  10.317  1.00 28.16           C  
ATOM   1127  OG1 THR B   5      -6.222   1.167   9.885  1.00 30.93           O  
ATOM   1128  CG2 THR B   5      -3.857   1.419   9.455  1.00 28.73           C  
ATOM   1129  N   LEU B   6      -6.348   2.994  12.927  1.00 26.54           N  
ATOM   1130  CA  LEU B   6      -7.455   3.310  13.778  1.00 26.65           C  
ATOM   1131  C   LEU B   6      -8.573   3.811  12.890  1.00 27.22           C  
ATOM   1132  O   LEU B   6      -8.336   4.378  11.842  1.00 28.41           O  
ATOM   1133  CB  LEU B   6      -7.093   4.414  14.791  1.00 26.12           C  
ATOM   1134  CG  LEU B   6      -6.113   4.114  15.918  1.00 25.83           C  
ATOM   1135  CD1 LEU B   6      -5.860   5.352  16.778  1.00 25.14           C  
ATOM   1136  CD2 LEU B   6      -6.585   2.981  16.781  1.00 25.72           C  
ATOM   1137  N   SER B   7      -9.791   3.649  13.340  1.00 27.89           N  
ATOM   1138  CA  SER B   7     -10.950   4.138  12.587  1.00 28.49           C  
ATOM   1139  C   SER B   7     -10.978   5.643  12.733  1.00 28.98           C  
ATOM   1140  O   SER B   7     -10.322   6.197  13.628  1.00 29.04           O  
ATOM   1141  CB  SER B   7     -12.210   3.547  13.185  1.00 28.35           C  
ATOM   1142  OG  SER B   7     -12.333   3.984  14.520  1.00 28.20           O  
ATOM   1143  N   ALA B   8     -11.751   6.326  11.895  1.00 29.28           N  
ATOM   1144  CA  ALA B   8     -11.915   7.761  12.066  1.00 29.28           C  
ATOM   1145  C   ALA B   8     -12.401   8.125  13.482  1.00 29.42           C  
ATOM   1146  O   ALA B   8     -11.918   9.065  14.093  1.00 29.91           O  
ATOM   1147  CB  ALA B   8     -12.870   8.311  11.019  1.00 30.11           C  
ATOM   1148  N   LEU B   9     -13.336   7.362  14.020  1.00 29.51           N  
ATOM   1149  CA  LEU B   9     -13.883   7.657  15.349  1.00 29.19           C  
ATOM   1150  C   LEU B   9     -12.839   7.397  16.474  1.00 29.36           C  
ATOM   1151  O   LEU B   9     -12.773   8.121  17.476  1.00 28.40           O  
ATOM   1152  CB  LEU B   9     -15.172   6.847  15.533  1.00 30.49           C  
ATOM   1153  CG  LEU B   9     -16.269   7.067  14.440  1.00 32.24           C  
ATOM   1154  CD1 LEU B   9     -17.433   6.135  14.624  1.00 33.09           C  
ATOM   1155  CD2 LEU B   9     -16.772   8.510  14.380  1.00 33.74           C  
ATOM   1156  N   GLU B  10     -11.979   6.391  16.286  1.00 28.95           N  
ATOM   1157  CA  GLU B  10     -10.905   6.129  17.258  1.00 29.37           C  
ATOM   1158  C   GLU B  10      -9.905   7.304  17.278  1.00 27.75           C  
ATOM   1159  O   GLU B  10      -9.381   7.666  18.321  1.00 27.20           O  
ATOM   1160  CB  GLU B  10     -10.183   4.814  16.942  1.00 29.03           C  
ATOM   1161  CG  GLU B  10     -11.038   3.555  17.189  1.00 31.79           C  
ATOM   1162  CD  GLU B  10     -10.293   2.253  16.897  1.00 32.67           C  
ATOM   1163  OE1 GLU B  10      -9.936   2.014  15.714  1.00 36.93           O  
ATOM   1164  OE2 GLU B  10     -10.088   1.459  17.849  1.00 38.87           O  
ATOM   1165  N   CYS B  11      -9.650   7.889  16.117  1.00 27.75           N  
ATOM   1166  CA  CYS B  11      -8.724   9.010  16.012  1.00 27.32           C  
ATOM   1167  C   CYS B  11      -9.237  10.209  16.799  1.00 27.17           C  
ATOM   1168  O   CYS B  11      -8.537  10.775  17.638  1.00 26.87           O  
ATOM   1169  CB  CYS B  11      -8.461   9.383  14.556  1.00 27.52           C  
ATOM   1170  SG  CYS B  11      -7.587   8.179  13.597  1.00 27.17           S  
ATOM   1171  N   THR B  12     -10.493  10.543  16.578  1.00 26.62           N  
ATOM   1172  CA  THR B  12     -11.166  11.557  17.375  1.00 27.12           C  
ATOM   1173  C   THR B  12     -11.046  11.352  18.886  1.00 25.75           C  
ATOM   1174  O   THR B  12     -10.780  12.313  19.600  1.00 24.52           O  
ATOM   1175  CB  THR B  12     -12.632  11.722  16.938  1.00 27.68           C  
ATOM   1176  OG1 THR B  12     -12.638  12.006  15.529  1.00 30.86           O  
ATOM   1177  CG2 THR B  12     -13.296  12.876  17.680  1.00 29.66           C  
ATOM   1178  N   LYS B  13     -11.178  10.122  19.368  1.00 24.87           N  
ATOM   1179  CA  LYS B  13     -11.072   9.834  20.816  1.00 24.99           C  
ATOM   1180  C   LYS B  13      -9.702  10.122  21.387  1.00 24.66           C  
ATOM   1181  O   LYS B  13      -9.571  10.566  22.515  1.00 24.48           O  
ATOM   1182  CB  LYS B  13     -11.374   8.349  21.136  1.00 24.41           C  
ATOM   1183  CG  LYS B  13     -12.826   8.027  21.318  1.00 25.95           C  
ATOM   1184  N   VAL B  14      -8.669   9.816  20.614  1.00 25.13           N  
ATOM   1185  CA  VAL B  14      -7.310  10.109  21.025  1.00 25.06           C  
ATOM   1186  C   VAL B  14      -7.137  11.637  21.083  1.00 24.49           C  
ATOM   1187  O   VAL B  14      -6.671  12.139  22.063  1.00 25.12           O  
ATOM   1188  CB  VAL B  14      -6.268   9.424  20.069  1.00 24.88           C  
ATOM   1189  CG1 VAL B  14      -4.882   9.927  20.327  1.00 26.19           C  
ATOM   1190  CG2 VAL B  14      -6.313   7.917  20.212  1.00 23.62           C  
ATOM   1191  N   LEU B  15      -7.538  12.361  20.049  1.00 26.01           N  
ATOM   1192  CA  LEU B  15      -7.385  13.824  20.030  1.00 26.97           C  
ATOM   1193  C   LEU B  15      -8.144  14.506  21.160  1.00 28.75           C  
ATOM   1194  O   LEU B  15      -7.648  15.423  21.803  1.00 29.26           O  
ATOM   1195  CB  LEU B  15      -7.872  14.408  18.717  1.00 25.97           C  
ATOM   1196  CG  LEU B  15      -7.081  14.055  17.490  1.00 25.29           C  
ATOM   1197  CD1 LEU B  15      -7.813  14.595  16.312  1.00 28.02           C  
ATOM   1198  CD2 LEU B  15      -5.698  14.658  17.550  1.00 24.05           C  
ATOM   1199  N   THR B  16      -9.350  14.018  21.406  1.00 30.46           N  
ATOM   1200  CA  THR B  16     -10.227  14.592  22.402  1.00 32.35           C  
ATOM   1201  C   THR B  16      -9.620  14.430  23.784  1.00 33.21           C  
ATOM   1202  O   THR B  16      -9.628  15.367  24.590  1.00 34.22           O  
ATOM   1203  CB  THR B  16     -11.601  13.895  22.327  1.00 32.75           C  
ATOM   1204  OG1 THR B  16     -12.248  14.217  21.073  1.00 33.36           O  
ATOM   1205  CG2 THR B  16     -12.476  14.295  23.477  1.00 34.11           C  
ATOM   1206  N   ALA B  17      -9.064  13.247  24.035  1.00 32.90           N  
ATOM   1207  CA  ALA B  17      -8.553  12.860  25.339  1.00 32.15           C  
ATOM   1208  C   ALA B  17      -7.228  13.482  25.723  1.00 31.49           C  
ATOM   1209  O   ALA B  17      -6.891  13.519  26.901  1.00 31.46           O  
ATOM   1210  CB  ALA B  17      -8.420  11.318  25.424  1.00 32.69           C  
ATOM   1211  N   ASN B  18      -6.451  13.946  24.750  1.00 30.36           N  
ATOM   1212  CA  ASN B  18      -5.135  14.445  25.044  1.00 29.25           C  
ATOM   1213  C   ASN B  18      -5.059  15.965  24.912  1.00 28.07           C  
ATOM   1214  O   ASN B  18      -5.974  16.612  24.403  1.00 27.52           O  
ATOM   1215  CB  ASN B  18      -4.123  13.711  24.160  1.00 29.49           C  
ATOM   1216  CG  ASN B  18      -3.942  12.286  24.581  1.00 30.04           C  
ATOM   1217  OD1 ASN B  18      -3.284  12.015  25.582  1.00 30.15           O  
ATOM   1218  ND2 ASN B  18      -4.590  11.360  23.874  1.00 28.20           N  
ATOM   1219  N   ARG B  19      -3.976  16.510  25.423  1.00 28.41           N  
ATOM   1220  CA  ARG B  19      -3.755  17.973  25.542  1.00 28.87           C  
ATOM   1221  C   ARG B  19      -2.438  18.478  24.972  1.00 27.98           C  
ATOM   1222  O   ARG B  19      -2.200  19.638  24.958  1.00 26.27           O  
ATOM   1223  CB  ARG B  19      -3.783  18.389  27.017  1.00 30.01           C  
ATOM   1224  CG  ARG B  19      -2.689  17.778  27.902  1.00 31.49           C  
ATOM   1225  N   VAL B  20      -1.554  17.581  24.595  1.00 27.14           N  
ATOM   1226  CA  VAL B  20      -0.280  17.965  24.070  1.00 28.37           C  
ATOM   1227  C   VAL B  20      -0.048  17.233  22.764  1.00 27.21           C  
ATOM   1228  O   VAL B  20      -0.407  16.065  22.594  1.00 27.47           O  
ATOM   1229  CB  VAL B  20       0.877  17.744  25.085  1.00 29.41           C  
ATOM   1230  CG1 VAL B  20       1.127  16.303  25.324  1.00 31.08           C  
ATOM   1231  CG2 VAL B  20       2.179  18.418  24.575  1.00 33.49           C  
ATOM   1232  N   GLY B  21       0.499  17.968  21.817  1.00 25.37           N  
ATOM   1233  CA  GLY B  21       0.868  17.405  20.563  1.00 25.95           C  
ATOM   1234  C   GLY B  21       2.190  18.018  20.130  1.00 24.94           C  
ATOM   1235  O   GLY B  21       2.721  18.887  20.831  1.00 25.82           O  
ATOM   1236  N   ARG B  22       2.706  17.545  18.999  1.00 23.41           N  
ATOM   1237  CA  ARG B  22       3.812  18.174  18.316  1.00 23.42           C  
ATOM   1238  C   ARG B  22       3.287  18.766  17.022  1.00 23.27           C  
ATOM   1239  O   ARG B  22       2.620  18.103  16.228  1.00 25.73           O  
ATOM   1240  CB  ARG B  22       4.974  17.209  18.068  1.00 22.99           C  
ATOM   1241  CG  ARG B  22       5.958  17.154  19.211  1.00 25.30           C  
ATOM   1242  CD  ARG B  22       5.358  16.440  20.345  1.00 27.71           C  
ATOM   1243  NE  ARG B  22       6.276  16.278  21.476  1.00 28.39           N  
ATOM   1244  CZ  ARG B  22       5.956  15.610  22.580  1.00 31.60           C  
ATOM   1245  NH1 ARG B  22       4.754  15.062  22.710  1.00 30.08           N  
ATOM   1246  NH2 ARG B  22       6.841  15.486  23.563  1.00 34.30           N  
ATOM   1247  N   LEU B  23       3.569  20.030  16.819  1.00 23.05           N  
ATOM   1248  CA  LEU B  23       3.114  20.768  15.667  1.00 23.63           C  
ATOM   1249  C   LEU B  23       4.277  21.024  14.732  1.00 23.87           C  
ATOM   1250  O   LEU B  23       5.290  21.583  15.149  1.00 24.54           O  
ATOM   1251  CB  LEU B  23       2.589  22.109  16.143  1.00 24.81           C  
ATOM   1252  CG  LEU B  23       2.273  23.142  15.048  1.00 27.36           C  
ATOM   1253  CD1 LEU B  23       1.070  22.752  14.304  1.00 26.05           C  
ATOM   1254  CD2 LEU B  23       2.067  24.454  15.785  1.00 32.63           C  
ATOM   1255  N   ALA B  24       4.103  20.658  13.469  1.00 22.96           N  
ATOM   1256  CA  ALA B  24       5.084  20.904  12.463  1.00 23.23           C  
ATOM   1257  C   ALA B  24       4.585  21.871  11.409  1.00 23.75           C  
ATOM   1258  O   ALA B  24       3.473  21.739  10.922  1.00 23.89           O  
ATOM   1259  CB  ALA B  24       5.450  19.613  11.805  1.00 23.07           C  
ATOM   1260  N   CYS B  25       5.457  22.803  11.032  1.00 24.60           N  
ATOM   1261  CA  CYS B  25       5.232  23.741   9.965  1.00 23.41           C  
ATOM   1262  C   CYS B  25       6.472  23.686   9.066  1.00 23.30           C  
ATOM   1263  O   CYS B  25       7.435  22.932   9.343  1.00 22.67           O  
ATOM   1264  CB  CYS B  25       5.000  25.135  10.500  1.00 23.94           C  
ATOM   1265  SG  CYS B  25       6.302  25.854  11.554  1.00 27.21           S  
ATOM   1266  N   ALA B  26       6.442  24.443   7.981  1.00 21.97           N  
ATOM   1267  CA  ALA B  26       7.576  24.435   7.046  1.00 22.60           C  
ATOM   1268  C   ALA B  26       7.751  25.750   6.319  1.00 22.65           C  
ATOM   1269  O   ALA B  26       6.785  26.508   6.128  1.00 23.80           O  
ATOM   1270  CB  ALA B  26       7.397  23.293   6.014  1.00 22.42           C  
ATOM   1271  N   LYS B  27       8.987  26.000   5.899  1.00 23.45           N  
ATOM   1272  CA  LYS B  27       9.327  27.130   5.042  1.00 22.99           C  
ATOM   1273  C   LYS B  27      10.437  26.714   4.112  1.00 23.66           C  
ATOM   1274  O   LYS B  27      11.502  26.260   4.565  1.00 22.40           O  
ATOM   1275  CB  LYS B  27       9.834  28.303   5.852  1.00 23.32           C  
ATOM   1276  CG  LYS B  27      10.145  29.546   5.027  1.00 26.59           C  
ATOM   1277  CD  LYS B  27      10.906  30.550   5.882  1.00 33.83           C  
ATOM   1278  CE  LYS B  27      10.335  31.924   5.783  1.00 39.78           C  
ATOM   1279  NZ  LYS B  27       8.962  31.923   6.381  1.00 41.00           N  
ATOM   1280  N   ASP B  28      10.197  26.929   2.823  1.00 24.65           N  
ATOM   1281  CA  ASP B  28      11.150  26.594   1.751  1.00 26.63           C  
ATOM   1282  C   ASP B  28      11.684  25.156   1.905  1.00 26.68           C  
ATOM   1283  O   ASP B  28      12.882  24.909   1.777  1.00 28.90           O  
ATOM   1284  CB  ASP B  28      12.283  27.626   1.694  1.00 27.98           C  
ATOM   1285  CG  ASP B  28      11.749  29.049   1.434  1.00 31.49           C  
ATOM   1286  OD1 ASP B  28      10.689  29.155   0.775  1.00 36.26           O  
ATOM   1287  OD2 ASP B  28      12.351  30.045   1.908  1.00 35.87           O  
ATOM   1288  N   GLY B  29      10.795  24.216   2.213  1.00 25.71           N  
ATOM   1289  CA  GLY B  29      11.187  22.802   2.285  1.00 25.14           C  
ATOM   1290  C   GLY B  29      11.760  22.374   3.624  1.00 24.38           C  
ATOM   1291  O   GLY B  29      11.992  21.180   3.835  1.00 24.21           O  
ATOM   1292  N   GLN B  30      11.989  23.337   4.532  1.00 23.01           N  
ATOM   1293  CA  GLN B  30      12.560  23.049   5.846  1.00 22.43           C  
ATOM   1294  C   GLN B  30      11.428  22.933   6.823  1.00 22.50           C  
ATOM   1295  O   GLN B  30      10.678  23.907   6.994  1.00 21.99           O  
ATOM   1296  CB  GLN B  30      13.470  24.172   6.319  1.00 22.67           C  
ATOM   1297  CG  GLN B  30      14.029  24.001   7.707  1.00 21.13           C  
ATOM   1298  CD  GLN B  30      14.856  22.757   7.838  1.00 22.57           C  
ATOM   1299  OE1 GLN B  30      15.778  22.526   7.054  1.00 23.79           O  
ATOM   1300  NE2 GLN B  30      14.509  21.924   8.782  1.00 19.52           N  
ATOM   1301  N   PRO B  31      11.276  21.757   7.456  1.00 21.78           N  
ATOM   1302  CA  PRO B  31      10.336  21.653   8.567  1.00 20.94           C  
ATOM   1303  C   PRO B  31      10.823  22.238   9.894  1.00 21.60           C  
ATOM   1304  O   PRO B  31      12.039  22.432  10.130  1.00 20.20           O  
ATOM   1305  CB  PRO B  31      10.116  20.125   8.687  1.00 21.39           C  
ATOM   1306  CG  PRO B  31      10.755  19.524   7.438  1.00 22.02           C  
ATOM   1307  CD  PRO B  31      11.881  20.452   7.168  1.00 21.94           C  
ATOM   1308  N   TYR B  32       9.849  22.483  10.766  1.00 22.08           N  
ATOM   1309  CA  TYR B  32      10.094  22.946  12.098  1.00 23.10           C  
ATOM   1310  C   TYR B  32       9.020  22.383  13.003  1.00 22.42           C  
ATOM   1311  O   TYR B  32       7.858  22.473  12.680  1.00 23.31           O  
ATOM   1312  CB  TYR B  32      10.107  24.464  12.067  1.00 22.59           C  
ATOM   1313  CG  TYR B  32      10.231  25.136  13.381  1.00 22.96           C  
ATOM   1314  CD1 TYR B  32      11.257  24.820  14.262  1.00 23.68           C  
ATOM   1315  CD2 TYR B  32       9.323  26.081  13.773  1.00 22.31           C  
ATOM   1316  CE1 TYR B  32      11.347  25.473  15.501  1.00 24.18           C  
ATOM   1317  CE2 TYR B  32       9.421  26.742  15.019  1.00 22.64           C  
ATOM   1318  CZ  TYR B  32      10.413  26.450  15.851  1.00 24.27           C  
ATOM   1319  OH  TYR B  32      10.517  27.161  17.029  1.00 24.77           O  
ATOM   1320  N   VAL B  33       9.424  21.661  14.048  1.00 23.11           N  
ATOM   1321  CA  VAL B  33       8.473  20.990  14.912  1.00 23.23           C  
ATOM   1322  C   VAL B  33       8.699  21.334  16.376  1.00 22.86           C  
ATOM   1323  O   VAL B  33       9.811  21.297  16.844  1.00 22.66           O  
ATOM   1324  CB  VAL B  33       8.453  19.456  14.646  1.00 24.20           C  
ATOM   1325  CG1 VAL B  33       9.794  18.831  14.785  1.00 24.19           C  
ATOM   1326  CG2 VAL B  33       7.421  18.769  15.518  1.00 24.50           C  
ATOM   1327  N   VAL B  34       7.623  21.702  17.083  1.00 22.23           N  
ATOM   1328  CA  VAL B  34       7.698  22.032  18.505  1.00 23.14           C  
ATOM   1329  C   VAL B  34       6.492  21.468  19.258  1.00 22.81           C  
ATOM   1330  O   VAL B  34       5.464  21.228  18.658  1.00 22.17           O  
ATOM   1331  CB  VAL B  34       7.736  23.565  18.740  1.00 24.24           C  
ATOM   1332  CG1 VAL B  34       9.008  24.142  18.179  1.00 25.68           C  
ATOM   1333  CG2 VAL B  34       6.507  24.232  18.114  1.00 26.23           C  
ATOM   1334  N   PRO B  35       6.626  21.272  20.567  1.00 23.35           N  
ATOM   1335  CA  PRO B  35       5.479  20.830  21.327  1.00 25.11           C  
ATOM   1336  C   PRO B  35       4.471  21.972  21.566  1.00 25.86           C  
ATOM   1337  O   PRO B  35       4.859  23.142  21.736  1.00 27.41           O  
ATOM   1338  CB  PRO B  35       6.089  20.336  22.628  1.00 25.28           C  
ATOM   1339  CG  PRO B  35       7.412  21.036  22.766  1.00 25.07           C  
ATOM   1340  CD  PRO B  35       7.849  21.420  21.396  1.00 24.72           C  
ATOM   1341  N   LEU B  36       3.205  21.602  21.686  1.00 26.13           N  
ATOM   1342  CA  LEU B  36       2.137  22.568  21.848  1.00 26.68           C  
ATOM   1343  C   LEU B  36       0.992  21.983  22.645  1.00 25.57           C  
ATOM   1344  O   LEU B  36       0.621  20.834  22.429  1.00 24.47           O  
ATOM   1345  CB  LEU B  36       1.631  22.956  20.482  1.00 27.35           C  
ATOM   1346  CG  LEU B  36       0.647  24.119  20.394  1.00 31.66           C  
ATOM   1347  CD1 LEU B  36       1.397  25.425  20.107  1.00 33.59           C  
ATOM   1348  CD2 LEU B  36      -0.351  23.804  19.308  1.00 34.07           C  
ATOM   1349  N   TYR B  37       0.433  22.775  23.559  1.00 24.92           N  
ATOM   1350  CA  TYR B  37      -0.777  22.373  24.262  1.00 24.34           C  
ATOM   1351  C   TYR B  37      -1.950  22.766  23.400  1.00 24.32           C  
ATOM   1352  O   TYR B  37      -1.962  23.883  22.836  1.00 24.01           O  
ATOM   1353  CB  TYR B  37      -0.874  23.083  25.588  1.00 26.36           C  
ATOM   1354  CG  TYR B  37       0.017  22.561  26.651  1.00 27.45           C  
ATOM   1355  CD1 TYR B  37       0.020  21.214  26.982  1.00 30.76           C  
ATOM   1356  CD2 TYR B  37       0.804  23.423  27.393  1.00 31.27           C  
ATOM   1357  CE1 TYR B  37       0.843  20.720  27.991  1.00 33.05           C  
ATOM   1358  CE2 TYR B  37       1.611  22.955  28.419  1.00 30.79           C  
ATOM   1359  CZ  TYR B  37       1.620  21.608  28.716  1.00 31.10           C  
ATOM   1360  OH  TYR B  37       2.430  21.137  29.706  1.00 33.11           O  
ATOM   1361  N   TYR B  38      -2.950  21.893  23.277  1.00 22.39           N  
ATOM   1362  CA  TYR B  38      -4.132  22.240  22.478  1.00 22.49           C  
ATOM   1363  C   TYR B  38      -5.407  21.833  23.200  1.00 23.10           C  
ATOM   1364  O   TYR B  38      -5.377  21.027  24.154  1.00 23.46           O  
ATOM   1365  CB  TYR B  38      -4.063  21.568  21.079  1.00 22.84           C  
ATOM   1366  CG  TYR B  38      -4.288  20.091  21.187  1.00 20.71           C  
ATOM   1367  CD1 TYR B  38      -3.228  19.213  21.432  1.00 23.53           C  
ATOM   1368  CD2 TYR B  38      -5.569  19.561  21.117  1.00 25.09           C  
ATOM   1369  CE1 TYR B  38      -3.446  17.857  21.584  1.00 22.80           C  
ATOM   1370  CE2 TYR B  38      -5.793  18.168  21.302  1.00 22.22           C  
ATOM   1371  CZ  TYR B  38      -4.740  17.352  21.528  1.00 23.35           C  
ATOM   1372  OH  TYR B  38      -5.012  16.025  21.696  1.00 23.75           O  
ATOM   1373  N   ALA B  39      -6.523  22.365  22.737  1.00 23.15           N  
ATOM   1374  CA  ALA B  39      -7.849  21.900  23.203  1.00 24.46           C  
ATOM   1375  C   ALA B  39      -8.652  21.530  21.959  1.00 24.59           C  
ATOM   1376  O   ALA B  39      -8.730  22.321  21.057  1.00 24.59           O  
ATOM   1377  CB  ALA B  39      -8.578  23.024  23.988  1.00 24.03           C  
ATOM   1378  N   TYR B  40      -9.189  20.313  21.904  1.00 25.00           N  
ATOM   1379  CA  TYR B  40     -10.004  19.867  20.778  1.00 25.65           C  
ATOM   1380  C   TYR B  40     -11.459  20.385  20.858  1.00 26.10           C  
ATOM   1381  O   TYR B  40     -12.117  20.269  21.898  1.00 24.55           O  
ATOM   1382  CB  TYR B  40     -10.033  18.324  20.727  1.00 26.69           C  
ATOM   1383  CG  TYR B  40     -10.963  17.818  19.677  1.00 27.10           C  
ATOM   1384  CD1 TYR B  40     -10.526  17.666  18.365  1.00 31.74           C  
ATOM   1385  CD2 TYR B  40     -12.284  17.551  19.965  1.00 28.64           C  
ATOM   1386  CE1 TYR B  40     -11.395  17.277  17.375  1.00 31.25           C  
ATOM   1387  CE2 TYR B  40     -13.173  17.157  18.985  1.00 28.69           C  
ATOM   1388  CZ  TYR B  40     -12.721  17.023  17.697  1.00 30.32           C  
ATOM   1389  OH  TYR B  40     -13.592  16.634  16.721  1.00 31.27           O  
ATOM   1390  N   SER B  41     -11.975  20.890  19.738  1.00 25.52           N  
ATOM   1391  CA  SER B  41     -13.424  21.101  19.581  1.00 27.13           C  
ATOM   1392  C   SER B  41     -13.777  21.242  18.117  1.00 27.03           C  
ATOM   1393  O   SER B  41     -13.069  21.912  17.379  1.00 26.15           O  
ATOM   1394  CB  SER B  41     -13.913  22.359  20.302  1.00 26.84           C  
ATOM   1395  OG  SER B  41     -15.325  22.429  20.242  1.00 28.52           O  
ATOM   1396  N   ASP B  42     -14.863  20.612  17.718  1.00 27.80           N  
ATOM   1397  CA  ASP B  42     -15.500  20.884  16.423  1.00 30.11           C  
ATOM   1398  C   ASP B  42     -14.502  20.674  15.250  1.00 30.16           C  
ATOM   1399  O   ASP B  42     -14.464  21.485  14.353  1.00 31.29           O  
ATOM   1400  CB  ASP B  42     -16.229  22.299  16.376  1.00 30.85           C  
ATOM   1401  CG  ASP B  42     -15.298  23.581  16.748  1.00 36.94           C  
ATOM   1402  OD1 ASP B  42     -14.490  24.079  15.905  1.00 43.15           O  
ATOM   1403  OD2 ASP B  42     -15.442  24.163  17.876  1.00 41.40           O  
ATOM   1404  N   ALA B  43     -13.696  19.605  15.304  1.00 29.51           N  
ATOM   1405  CA  ALA B  43     -12.687  19.259  14.261  1.00 29.20           C  
ATOM   1406  C   ALA B  43     -11.618  20.325  14.083  1.00 28.73           C  
ATOM   1407  O   ALA B  43     -11.053  20.503  12.992  1.00 29.33           O  
ATOM   1408  CB  ALA B  43     -13.345  18.960  12.942  1.00 30.46           C  
ATOM   1409  N   HIS B  44     -11.341  21.012  15.185  1.00 26.16           N  
ATOM   1410  CA  HIS B  44     -10.249  21.922  15.282  1.00 25.98           C  
ATOM   1411  C   HIS B  44      -9.465  21.643  16.542  1.00 23.85           C  
ATOM   1412  O   HIS B  44     -10.028  21.249  17.583  1.00 22.28           O  
ATOM   1413  CB  HIS B  44     -10.750  23.345  15.362  1.00 26.69           C  
ATOM   1414  CG  HIS B  44     -11.523  23.799  14.165  1.00 29.32           C  
ATOM   1415  ND1 HIS B  44     -12.896  23.768  14.122  1.00 33.69           N  
ATOM   1416  CD2 HIS B  44     -11.118  24.377  13.005  1.00 33.61           C  
ATOM   1417  CE1 HIS B  44     -13.311  24.265  12.966  1.00 35.54           C  
ATOM   1418  NE2 HIS B  44     -12.251  24.660  12.280  1.00 35.82           N  
ATOM   1419  N   LEU B  45      -8.189  21.943  16.467  1.00 22.36           N  
ATOM   1420  CA  LEU B  45      -7.323  22.032  17.632  1.00 22.99           C  
ATOM   1421  C   LEU B  45      -6.997  23.486  17.953  1.00 23.69           C  
ATOM   1422  O   LEU B  45      -6.368  24.164  17.157  1.00 24.47           O  
ATOM   1423  CB  LEU B  45      -6.025  21.286  17.358  1.00 21.08           C  
ATOM   1424  CG  LEU B  45      -6.178  19.906  16.766  1.00 24.26           C  
ATOM   1425  CD1 LEU B  45      -4.834  19.260  16.532  1.00 24.82           C  
ATOM   1426  CD2 LEU B  45      -7.006  18.989  17.629  1.00 21.67           C  
ATOM   1427  N   TYR B  46      -7.413  23.961  19.122  1.00 24.62           N  
ATOM   1428  CA  TYR B  46      -7.220  25.357  19.532  1.00 23.88           C  
ATOM   1429  C   TYR B  46      -6.007  25.486  20.420  1.00 23.68           C  
ATOM   1430  O   TYR B  46      -5.689  24.597  21.238  1.00 24.96           O  
ATOM   1431  CB  TYR B  46      -8.478  25.894  20.287  1.00 24.25           C  
ATOM   1432  CG  TYR B  46      -9.717  26.049  19.432  1.00 24.65           C  
ATOM   1433  CD1 TYR B  46     -10.550  24.969  19.145  1.00 24.71           C  
ATOM   1434  CD2 TYR B  46     -10.057  27.285  18.892  1.00 25.90           C  
ATOM   1435  CE1 TYR B  46     -11.658  25.135  18.350  1.00 26.96           C  
ATOM   1436  CE2 TYR B  46     -11.174  27.434  18.096  1.00 25.52           C  
ATOM   1437  CZ  TYR B  46     -11.956  26.398  17.842  1.00 24.80           C  
ATOM   1438  OH  TYR B  46     -13.065  26.628  17.020  1.00 27.16           O  
ATOM   1439  N   ALA B  47      -5.304  26.599  20.268  1.00 23.60           N  
ATOM   1440  CA  ALA B  47      -4.097  26.825  21.004  1.00 23.10           C  
ATOM   1441  C   ALA B  47      -3.765  28.315  21.048  1.00 23.63           C  
ATOM   1442  O   ALA B  47      -4.355  29.135  20.318  1.00 23.80           O  
ATOM   1443  CB  ALA B  47      -2.912  25.959  20.425  1.00 22.40           C  
ATOM   1444  N   PHE B  48      -2.865  28.654  21.962  1.00 23.57           N  
ATOM   1445  CA  PHE B  48      -2.344  30.007  22.136  1.00 24.18           C  
ATOM   1446  C   PHE B  48      -0.856  29.948  21.925  1.00 25.56           C  
ATOM   1447  O   PHE B  48      -0.236  28.918  22.212  1.00 24.37           O  
ATOM   1448  CB  PHE B  48      -2.656  30.559  23.543  1.00 23.98           C  
ATOM   1449  CG  PHE B  48      -4.084  30.941  23.723  1.00 24.43           C  
ATOM   1450  CD1 PHE B  48      -5.017  30.002  24.135  1.00 25.13           C  
ATOM   1451  CD2 PHE B  48      -4.513  32.231  23.442  1.00 27.13           C  
ATOM   1452  CE1 PHE B  48      -6.355  30.334  24.225  1.00 26.41           C  
ATOM   1453  CE2 PHE B  48      -5.840  32.547  23.541  1.00 27.50           C  
ATOM   1454  CZ  PHE B  48      -6.754  31.603  23.953  1.00 23.62           C  
ATOM   1455  N   SER B  49      -0.289  31.038  21.418  1.00 25.73           N  
ATOM   1456  CA  SER B  49       1.158  31.177  21.295  1.00 27.00           C  
ATOM   1457  C   SER B  49       1.569  32.633  21.560  1.00 27.37           C  
ATOM   1458  O   SER B  49       0.785  33.557  21.363  1.00 28.52           O  
ATOM   1459  CB  SER B  49       1.616  30.748  19.883  1.00 26.98           C  
ATOM   1460  OG  SER B  49       3.021  30.903  19.723  1.00 28.66           O  
HETATM 1461  N   MSE B  50       2.796  32.839  21.997  1.00 27.66           N  
HETATM 1462  CA  MSE B  50       3.391  34.173  21.906  1.00 28.40           C  
HETATM 1463  C   MSE B  50       3.920  34.339  20.476  1.00 27.82           C  
HETATM 1464  O   MSE B  50       4.092  33.344  19.744  1.00 27.40           O  
HETATM 1465  CB  MSE B  50       4.489  34.343  22.957  1.00 29.11           C  
HETATM 1466  CG  MSE B  50       3.970  34.316  24.416  1.00 33.06           C  
HETATM 1467 SE   MSE B  50       2.690  35.754  24.736  0.75 41.83          SE  
HETATM 1468  CE  MSE B  50       3.909  37.198  24.726  1.00 40.95           C  
ATOM   1469  N   PRO B  51       4.150  35.583  20.042  1.00 28.22           N  
ATOM   1470  CA  PRO B  51       4.779  35.789  18.740  1.00 28.18           C  
ATOM   1471  C   PRO B  51       6.070  35.028  18.614  1.00 27.90           C  
ATOM   1472  O   PRO B  51       6.777  34.848  19.609  1.00 28.26           O  
ATOM   1473  CB  PRO B  51       5.104  37.276  18.739  1.00 28.66           C  
ATOM   1474  CG  PRO B  51       4.116  37.865  19.672  1.00 30.26           C  
ATOM   1475  CD  PRO B  51       3.877  36.854  20.733  1.00 28.43           C  
ATOM   1476  N   GLY B  52       6.425  34.629  17.396  1.00 27.52           N  
ATOM   1477  CA  GLY B  52       7.669  33.872  17.192  1.00 25.83           C  
ATOM   1478  C   GLY B  52       7.724  33.089  15.905  1.00 25.63           C  
ATOM   1479  O   GLY B  52       6.830  33.194  15.076  1.00 25.15           O  
ATOM   1480  N   LYS B  53       8.771  32.283  15.756  1.00 24.44           N  
ATOM   1481  CA  LYS B  53       9.022  31.515  14.526  1.00 24.50           C  
ATOM   1482  C   LYS B  53       7.848  30.719  14.031  1.00 23.85           C  
ATOM   1483  O   LYS B  53       7.439  30.882  12.883  1.00 23.54           O  
ATOM   1484  CB  LYS B  53      10.244  30.585  14.730  1.00 24.44           C  
ATOM   1485  CG  LYS B  53      10.837  30.004  13.482  1.00 24.89           C  
ATOM   1486  CD  LYS B  53      12.072  29.141  13.745  1.00 24.32           C  
ATOM   1487  CE  LYS B  53      12.380  28.227  12.588  1.00 27.61           C  
ATOM   1488  NZ  LYS B  53      13.728  27.611  12.736  1.00 26.61           N  
ATOM   1489  N   LYS B  54       7.284  29.858  14.854  1.00 22.01           N  
ATOM   1490  CA  LYS B  54       6.192  29.020  14.342  1.00 22.11           C  
ATOM   1491  C   LYS B  54       4.993  29.844  13.851  1.00 22.20           C  
ATOM   1492  O   LYS B  54       4.410  29.513  12.840  1.00 20.99           O  
ATOM   1493  CB  LYS B  54       5.717  27.999  15.332  1.00 22.40           C  
ATOM   1494  CG  LYS B  54       5.148  28.533  16.585  1.00 24.70           C  
ATOM   1495  CD  LYS B  54       4.809  27.410  17.558  1.00 27.53           C  
ATOM   1496  CE  LYS B  54       4.074  27.908  18.745  1.00 27.99           C  
ATOM   1497  NZ  LYS B  54       4.764  29.116  19.407  1.00 29.75           N  
ATOM   1498  N   ILE B  55       4.647  30.897  14.551  1.00 22.20           N  
ATOM   1499  CA  ILE B  55       3.584  31.780  14.082  1.00 23.45           C  
ATOM   1500  C   ILE B  55       3.986  32.449  12.766  1.00 23.86           C  
ATOM   1501  O   ILE B  55       3.178  32.521  11.828  1.00 25.45           O  
ATOM   1502  CB  ILE B  55       3.218  32.811  15.153  1.00 23.59           C  
ATOM   1503  CG1 ILE B  55       2.636  32.103  16.386  1.00 23.69           C  
ATOM   1504  CG2 ILE B  55       2.211  33.812  14.636  1.00 22.77           C  
ATOM   1505  CD1 ILE B  55       1.389  31.230  16.085  1.00 24.56           C  
ATOM   1506  N   GLU B  56       5.200  32.977  12.677  1.00 23.95           N  
ATOM   1507  CA  GLU B  56       5.614  33.584  11.413  1.00 24.79           C  
ATOM   1508  C   GLU B  56       5.552  32.595  10.224  1.00 24.28           C  
ATOM   1509  O   GLU B  56       5.062  32.926   9.130  1.00 24.60           O  
ATOM   1510  CB  GLU B  56       7.004  34.183  11.520  1.00 25.30           C  
ATOM   1511  CG  GLU B  56       7.099  35.393  12.409  1.00 26.13           C  
ATOM   1512  CD  GLU B  56       6.095  36.475  12.013  1.00 28.97           C  
ATOM   1513  OE1 GLU B  56       6.401  37.222  11.066  1.00 28.71           O  
ATOM   1514  OE2 GLU B  56       5.015  36.553  12.649  1.00 30.98           O  
ATOM   1515  N   TRP B  57       6.044  31.386  10.436  1.00 24.42           N  
ATOM   1516  CA  TRP B  57       6.059  30.366   9.390  1.00 24.41           C  
ATOM   1517  C   TRP B  57       4.663  29.894   8.993  1.00 25.21           C  
ATOM   1518  O   TRP B  57       4.404  29.633   7.800  1.00 26.32           O  
ATOM   1519  CB  TRP B  57       6.935  29.195   9.831  1.00 24.18           C  
ATOM   1520  CG  TRP B  57       8.403  29.450   9.703  1.00 24.75           C  
ATOM   1521  CD1 TRP B  57       9.055  30.650   9.734  1.00 22.93           C  
ATOM   1522  CD2 TRP B  57       9.396  28.452   9.500  1.00 22.33           C  
ATOM   1523  NE1 TRP B  57      10.402  30.453   9.556  1.00 24.57           N  
ATOM   1524  CE2 TRP B  57      10.628  29.106   9.396  1.00 24.68           C  
ATOM   1525  CE3 TRP B  57       9.343  27.057   9.342  1.00 22.03           C  
ATOM   1526  CZ2 TRP B  57      11.806  28.417   9.186  1.00 24.04           C  
ATOM   1527  CZ3 TRP B  57      10.490  26.384   9.148  1.00 23.40           C  
ATOM   1528  CH2 TRP B  57      11.713  27.044   9.085  1.00 23.16           C  
HETATM 1529  N   MSE B  58       3.749  29.796   9.953  1.00 24.31           N  
HETATM 1530  CA  MSE B  58       2.375  29.373   9.627  1.00 23.63           C  
HETATM 1531  C   MSE B  58       1.534  30.475   8.982  1.00 23.64           C  
HETATM 1532  O   MSE B  58       0.656  30.196   8.177  1.00 21.50           O  
HETATM 1533  CB  MSE B  58       1.681  28.833  10.893  1.00 24.12           C  
HETATM 1534  CG  MSE B  58       2.332  27.576  11.375  1.00 23.83           C  
HETATM 1535 SE   MSE B  58       1.391  26.680  12.818  0.75 21.77          SE  
HETATM 1536  CE  MSE B  58       1.648  28.071  14.180  1.00 28.17           C  
ATOM   1537  N   ARG B  59       1.845  31.732   9.311  1.00 23.42           N  
ATOM   1538  CA  ARG B  59       1.247  32.875   8.668  1.00 23.54           C  
ATOM   1539  C   ARG B  59       1.614  32.844   7.206  1.00 23.69           C  
ATOM   1540  O   ARG B  59       0.768  33.118   6.359  1.00 25.18           O  
ATOM   1541  CB  ARG B  59       1.690  34.207   9.319  1.00 23.01           C  
ATOM   1542  CG  ARG B  59       0.895  34.608  10.602  1.00 22.17           C  
ATOM   1543  CD  ARG B  59       1.585  35.749  11.313  1.00 23.09           C  
ATOM   1544  NE  ARG B  59       0.794  36.095  12.475  1.00 23.33           N  
ATOM   1545  CZ  ARG B  59       1.184  36.864  13.472  1.00 23.10           C  
ATOM   1546  NH1 ARG B  59       2.392  37.420  13.470  1.00 21.39           N  
ATOM   1547  NH2 ARG B  59       0.323  37.079  14.491  1.00 22.06           N  
ATOM   1548  N   ALA B  60       2.858  32.535   6.891  1.00 23.31           N  
ATOM   1549  CA  ALA B  60       3.270  32.455   5.478  1.00 23.81           C  
ATOM   1550  C   ALA B  60       2.861  31.148   4.718  1.00 23.89           C  
ATOM   1551  O   ALA B  60       2.606  31.177   3.498  1.00 22.59           O  
ATOM   1552  CB  ALA B  60       4.769  32.697   5.357  1.00 24.68           C  
ATOM   1553  N   ASN B  61       2.835  30.026   5.416  1.00 23.96           N  
ATOM   1554  CA  ASN B  61       2.467  28.718   4.877  1.00 24.75           C  
ATOM   1555  C   ASN B  61       1.548  28.032   5.881  1.00 23.76           C  
ATOM   1556  O   ASN B  61       2.019  27.474   6.841  1.00 23.92           O  
ATOM   1557  CB  ASN B  61       3.701  27.803   4.667  1.00 25.13           C  
ATOM   1558  CG  ASN B  61       3.311  26.374   4.217  1.00 27.45           C  
ATOM   1559  OD1 ASN B  61       2.147  26.144   3.795  1.00 24.65           O  
ATOM   1560  ND2 ASN B  61       4.290  25.412   4.272  1.00 23.16           N  
ATOM   1561  N   PRO B  62       0.236  28.065   5.663  1.00 23.12           N  
ATOM   1562  CA  PRO B  62      -0.603  27.484   6.683  1.00 24.13           C  
ATOM   1563  C   PRO B  62      -0.727  25.955   6.673  1.00 22.77           C  
ATOM   1564  O   PRO B  62      -1.464  25.447   7.476  1.00 21.89           O  
ATOM   1565  CB  PRO B  62      -1.951  28.181   6.471  1.00 23.36           C  
ATOM   1566  CG  PRO B  62      -1.972  28.446   5.052  1.00 25.85           C  
ATOM   1567  CD  PRO B  62      -0.557  28.626   4.562  1.00 25.44           C  
ATOM   1568  N   ARG B  63       0.024  25.212   5.838  1.00 21.90           N  
ATOM   1569  CA  ARG B  63       0.010  23.747   5.911  0.50 21.69           C  
ATOM   1571  C   ARG B  63       0.782  23.259   7.137  1.00 21.53           C  
ATOM   1572  O   ARG B  63       1.941  23.628   7.332  1.00 22.53           O  
ATOM   1573  CB  ARG B  63       0.615  23.129   4.632  0.50 22.00           C  
ATOM   1575  CG  ARG B  63       0.008  23.605   3.333  0.50 21.76           C  
ATOM   1577  CD  ARG B  63       0.840  23.103   2.159  0.50 22.19           C  
ATOM   1579  NE  ARG B  63       0.338  23.460   0.837  0.50 22.59           N  
ATOM   1581  CZ  ARG B  63       0.376  24.684   0.305  0.50 23.49           C  
ATOM   1583  NH1 ARG B  63       0.832  25.720   1.012  0.50 24.91           N  
ATOM   1585  NH2 ARG B  63      -0.095  24.880  -0.917  0.50 22.97           N  
ATOM   1587  N   VAL B  64       0.145  22.417   7.965  1.00 20.55           N  
ATOM   1588  CA  VAL B  64       0.794  21.867   9.106  1.00 23.05           C  
ATOM   1589  C   VAL B  64       0.492  20.377   9.260  1.00 21.68           C  
ATOM   1590  O   VAL B  64      -0.409  19.836   8.647  1.00 22.37           O  
ATOM   1591  CB  VAL B  64       0.361  22.587  10.443  1.00 23.09           C  
ATOM   1592  CG1 VAL B  64       0.639  24.084  10.331  1.00 24.13           C  
ATOM   1593  CG2 VAL B  64      -1.091  22.313  10.786  1.00 25.15           C  
ATOM   1594  N   SER B  65       1.234  19.762  10.156  1.00 23.10           N  
ATOM   1595  CA  SER B  65       0.929  18.411  10.628  1.00 23.90           C  
ATOM   1596  C   SER B  65       1.036  18.438  12.147  1.00 24.28           C  
ATOM   1597  O   SER B  65       1.891  19.165  12.717  1.00 24.90           O  
ATOM   1598  CB  SER B  65       1.893  17.405   9.996  1.00 24.06           C  
ATOM   1599  OG  SER B  65       1.717  16.094  10.506  1.00 25.21           O  
ATOM   1600  N   VAL B  66       0.151  17.687  12.817  1.00 23.68           N  
ATOM   1601  CA  VAL B  66       0.172  17.555  14.282  1.00 23.15           C  
ATOM   1602  C   VAL B  66       0.125  16.092  14.673  1.00 22.69           C  
ATOM   1603  O   VAL B  66      -0.669  15.344  14.146  1.00 21.72           O  
ATOM   1604  CB  VAL B  66      -1.046  18.283  14.938  1.00 23.26           C  
ATOM   1605  CG1 VAL B  66      -0.958  18.237  16.438  1.00 25.14           C  
ATOM   1606  CG2 VAL B  66      -1.106  19.724  14.533  1.00 24.57           C  
ATOM   1607  N   GLN B  67       0.978  15.697  15.599  1.00 22.12           N  
ATOM   1608  CA  GLN B  67       1.035  14.347  16.085  1.00 22.60           C  
ATOM   1609  C   GLN B  67       0.732  14.276  17.583  1.00 21.78           C  
ATOM   1610  O   GLN B  67       1.274  15.055  18.387  1.00 20.00           O  
ATOM   1611  CB  GLN B  67       2.416  13.739  15.789  1.00 23.38           C  
ATOM   1612  CG  GLN B  67       2.462  12.255  16.072  1.00 23.82           C  
ATOM   1613  CD  GLN B  67       2.925  11.954  17.512  1.00 23.88           C  
ATOM   1614  OE1 GLN B  67       3.648  12.757  18.139  1.00 21.87           O  
ATOM   1615  NE2 GLN B  67       2.520  10.792  18.030  1.00 21.61           N  
ATOM   1616  N   VAL B  68      -0.143  13.337  17.956  1.00 22.49           N  
ATOM   1617  CA  VAL B  68      -0.635  13.225  19.315  1.00 21.21           C  
ATOM   1618  C   VAL B  68      -0.594  11.764  19.648  1.00 21.73           C  
ATOM   1619  O   VAL B  68      -0.960  10.944  18.833  1.00 21.53           O  
ATOM   1620  CB  VAL B  68      -2.085  13.754  19.419  1.00 21.16           C  
ATOM   1621  CG1 VAL B  68      -2.681  13.552  20.813  1.00 21.77           C  
ATOM   1622  CG2 VAL B  68      -2.139  15.242  19.007  1.00 20.42           C  
ATOM   1623  N   ASP B  69      -0.138  11.414  20.840  1.00 22.49           N  
ATOM   1624  CA  ASP B  69      -0.194  10.020  21.237  1.00 24.55           C  
ATOM   1625  C   ASP B  69      -0.437   9.803  22.706  1.00 25.87           C  
ATOM   1626  O   ASP B  69      -0.359  10.724  23.497  1.00 25.04           O  
ATOM   1627  CB  ASP B  69       1.059   9.250  20.780  1.00 24.99           C  
ATOM   1628  CG  ASP B  69       2.339   9.855  21.307  1.00 29.53           C  
ATOM   1629  OD1 ASP B  69       2.454  10.010  22.542  1.00 32.48           O  
ATOM   1630  OD2 ASP B  69       3.221  10.184  20.474  1.00 35.29           O  
ATOM   1631  N   GLU B  70      -0.714   8.555  23.071  1.00 27.22           N  
ATOM   1632  CA  GLU B  70      -0.948   8.221  24.441  1.00 30.39           C  
ATOM   1633  C   GLU B  70      -0.469   6.802  24.671  1.00 32.51           C  
ATOM   1634  O   GLU B  70      -0.359   6.013  23.744  1.00 30.69           O  
ATOM   1635  CB  GLU B  70      -2.443   8.362  24.783  1.00 30.08           C  
ATOM   1636  CG  GLU B  70      -3.338   7.427  23.953  1.00 30.63           C  
ATOM   1637  CD  GLU B  70      -4.830   7.533  24.269  1.00 31.59           C  
ATOM   1638  OE1 GLU B  70      -5.356   8.647  24.570  1.00 30.40           O  
ATOM   1639  OE2 GLU B  70      -5.502   6.474  24.168  1.00 32.76           O  
ATOM   1640  N   HIS B  71      -0.155   6.502  25.923  1.00 36.88           N  
ATOM   1641  CA  HIS B  71       0.074   5.117  26.333  1.00 39.91           C  
ATOM   1642  C   HIS B  71      -1.216   4.316  26.412  1.00 41.30           C  
ATOM   1643  O   HIS B  71      -2.305   4.845  26.664  1.00 40.92           O  
ATOM   1644  CB  HIS B  71       0.745   5.050  27.704  1.00 41.44           C  
ATOM   1645  CG  HIS B  71       2.169   5.493  27.679  1.00 45.16           C  
ATOM   1646  ND1 HIS B  71       2.629   6.571  28.408  1.00 49.35           N  
ATOM   1647  CD2 HIS B  71       3.231   5.031  26.976  1.00 49.49           C  
ATOM   1648  CE1 HIS B  71       3.917   6.745  28.167  1.00 50.23           C  
ATOM   1649  NE2 HIS B  71       4.308   5.822  27.303  1.00 50.73           N  
ATOM   1650  N   GLY B  72      -1.063   3.018  26.197  1.00 42.98           N  
ATOM   1651  CA  GLY B  72      -2.066   2.076  26.594  1.00 44.16           C  
ATOM   1652  C   GLY B  72      -1.423   1.170  27.620  1.00 45.33           C  
ATOM   1653  O   GLY B  72      -0.704   1.619  28.531  1.00 46.16           O  
ATOM   1654  N   GLN B  73      -1.631  -0.122  27.397  1.00 46.14           N  
ATOM   1655  CA  GLN B  73      -1.366  -1.185  28.347  1.00 46.21           C  
ATOM   1656  C   GLN B  73       0.018  -1.712  28.033  1.00 45.42           C  
ATOM   1657  O   GLN B  73       0.394  -1.792  26.864  1.00 45.57           O  
ATOM   1658  CB  GLN B  73      -2.411  -2.305  28.170  1.00 46.88           C  
ATOM   1659  CG  GLN B  73      -2.633  -2.753  26.678  1.00 49.54           C  
ATOM   1660  CD  GLN B  73      -3.321  -1.683  25.814  1.00 51.62           C  
ATOM   1661  OE1 GLN B  73      -4.384  -1.176  26.180  1.00 54.74           O  
ATOM   1662  NE2 GLN B  73      -2.698  -1.318  24.685  1.00 53.62           N  
ATOM   1663  N   GLY B  74       0.771  -2.078  29.065  1.00 44.46           N  
ATOM   1664  CA  GLY B  74       2.155  -2.500  28.891  1.00 43.59           C  
ATOM   1665  C   GLY B  74       2.922  -1.507  28.029  1.00 42.90           C  
ATOM   1666  O   GLY B  74       2.951  -0.316  28.329  1.00 42.68           O  
ATOM   1667  N   ARG B  75       3.529  -2.001  26.951  1.00 41.82           N  
ATOM   1668  CA  ARG B  75       4.253  -1.158  26.003  1.00 40.99           C  
ATOM   1669  C   ARG B  75       3.333  -0.610  24.891  1.00 39.44           C  
ATOM   1670  O   ARG B  75       3.818  -0.011  23.921  1.00 40.05           O  
ATOM   1671  CB  ARG B  75       5.431  -1.958  25.392  1.00 41.59           C  
ATOM   1672  N   GLY B  76       2.019  -0.818  25.033  1.00 37.39           N  
ATOM   1673  CA  GLY B  76       1.023  -0.324  24.073  1.00 36.22           C  
ATOM   1674  C   GLY B  76       1.002   1.194  23.900  1.00 34.57           C  
ATOM   1675  O   GLY B  76       1.495   1.941  24.762  1.00 34.33           O  
ATOM   1676  N   TRP B  77       0.437   1.641  22.773  1.00 32.70           N  
ATOM   1677  CA  TRP B  77       0.244   3.057  22.495  1.00 30.66           C  
ATOM   1678  C   TRP B  77      -0.742   3.286  21.337  1.00 28.89           C  
ATOM   1679  O   TRP B  77      -1.065   2.361  20.571  1.00 27.59           O  
ATOM   1680  CB  TRP B  77       1.564   3.747  22.169  1.00 31.50           C  
ATOM   1681  CG  TRP B  77       2.352   3.107  21.093  1.00 31.56           C  
ATOM   1682  CD1 TRP B  77       3.399   2.242  21.268  1.00 33.25           C  
ATOM   1683  CD2 TRP B  77       2.210   3.280  19.662  1.00 32.62           C  
ATOM   1684  NE1 TRP B  77       3.903   1.845  20.036  1.00 33.54           N  
ATOM   1685  CE2 TRP B  77       3.192   2.470  19.040  1.00 33.31           C  
ATOM   1686  CE3 TRP B  77       1.331   4.017  18.841  1.00 31.41           C  
ATOM   1687  CZ2 TRP B  77       3.320   2.382  17.642  1.00 32.59           C  
ATOM   1688  CZ3 TRP B  77       1.469   3.931  17.462  1.00 31.69           C  
ATOM   1689  CH2 TRP B  77       2.449   3.112  16.874  1.00 31.54           C  
ATOM   1690  N   LYS B  78      -1.235   4.512  21.264  1.00 25.99           N  
ATOM   1691  CA  LYS B  78      -2.108   4.957  20.201  1.00 25.33           C  
ATOM   1692  C   LYS B  78      -1.546   6.286  19.757  1.00 24.47           C  
ATOM   1693  O   LYS B  78      -1.136   7.109  20.604  1.00 22.86           O  
ATOM   1694  CB  LYS B  78      -3.533   5.170  20.672  1.00 25.48           C  
ATOM   1695  CG  LYS B  78      -4.271   3.917  21.000  1.00 27.96           C  
ATOM   1696  CD  LYS B  78      -5.760   4.206  21.188  1.00 30.07           C  
ATOM   1697  CE  LYS B  78      -6.413   3.202  22.057  1.00 31.90           C  
ATOM   1698  NZ  LYS B  78      -6.634   1.945  21.319  1.00 34.49           N  
ATOM   1699  N   SER B  79      -1.470   6.491  18.447  1.00 24.47           N  
ATOM   1700  CA  SER B  79      -0.933   7.749  17.899  1.00 24.02           C  
ATOM   1701  C   SER B  79      -1.849   8.208  16.780  1.00 25.25           C  
ATOM   1702  O   SER B  79      -2.316   7.353  15.996  1.00 25.50           O  
ATOM   1703  CB  SER B  79       0.455   7.483  17.309  1.00 24.34           C  
ATOM   1704  OG  SER B  79       0.971   8.622  16.613  1.00 23.11           O  
ATOM   1705  N   VAL B  80      -2.022   9.530  16.667  1.00 24.77           N  
ATOM   1706  CA  VAL B  80      -2.799  10.166  15.606  1.00 24.22           C  
ATOM   1707  C   VAL B  80      -1.916  11.176  14.877  1.00 23.92           C  
ATOM   1708  O   VAL B  80      -1.123  11.906  15.517  1.00 23.19           O  
ATOM   1709  CB  VAL B  80      -4.081  10.832  16.219  1.00 24.92           C  
ATOM   1710  CG1 VAL B  80      -4.775  11.766  15.239  1.00 25.80           C  
ATOM   1711  CG2 VAL B  80      -5.040   9.734  16.618  1.00 24.62           C  
ATOM   1712  N   VAL B  81      -2.035  11.215  13.551  1.00 22.37           N  
ATOM   1713  CA  VAL B  81      -1.430  12.279  12.772  1.00 23.14           C  
ATOM   1714  C   VAL B  81      -2.510  13.059  12.064  1.00 23.14           C  
ATOM   1715  O   VAL B  81      -3.377  12.477  11.386  1.00 23.11           O  
ATOM   1716  CB  VAL B  81      -0.312  11.796  11.823  1.00 23.59           C  
ATOM   1717  CG1 VAL B  81       0.221  12.958  10.991  1.00 23.62           C  
ATOM   1718  CG2 VAL B  81       0.808  11.168  12.636  1.00 27.07           C  
ATOM   1719  N   VAL B  82      -2.473  14.375  12.269  1.00 25.61           N  
ATOM   1720  CA  VAL B  82      -3.445  15.301  11.657  1.00 26.69           C  
ATOM   1721  C   VAL B  82      -2.743  16.103  10.587  1.00 27.09           C  
ATOM   1722  O   VAL B  82      -1.684  16.678  10.832  1.00 26.42           O  
ATOM   1723  CB  VAL B  82      -3.996  16.285  12.676  1.00 27.63           C  
ATOM   1724  CG1 VAL B  82      -4.533  17.586  11.981  1.00 29.91           C  
ATOM   1725  CG2 VAL B  82      -5.074  15.619  13.517  1.00 27.65           C  
ATOM   1726  N   ASP B  83      -3.356  16.187   9.414  1.00 26.77           N  
ATOM   1727  CA  ASP B  83      -2.878  17.100   8.427  1.00 27.20           C  
ATOM   1728  C   ASP B  83      -3.852  18.222   8.351  1.00 26.17           C  
ATOM   1729  O   ASP B  83      -5.068  18.054   8.193  1.00 25.30           O  
ATOM   1730  CB  ASP B  83      -2.563  16.386   7.140  1.00 28.63           C  
ATOM   1731  CG  ASP B  83      -1.447  15.303   7.354  1.00 34.25           C  
ATOM   1732  OD1 ASP B  83      -0.394  15.544   8.079  1.00 40.10           O  
ATOM   1733  OD2 ASP B  83      -1.641  14.195   6.827  1.00 40.71           O  
ATOM   1734  N   GLY B  84      -3.308  19.392   8.565  1.00 26.44           N  
ATOM   1735  CA  GLY B  84      -4.115  20.523   8.943  1.00 26.02           C  
ATOM   1736  C   GLY B  84      -3.798  21.822   8.238  1.00 25.33           C  
ATOM   1737  O   GLY B  84      -2.809  21.948   7.472  1.00 22.06           O  
ATOM   1738  N   ARG B  85      -4.641  22.784   8.569  1.00 24.23           N  
ATOM   1739  CA  ARG B  85      -4.468  24.140   8.136  1.00 25.97           C  
ATOM   1740  C   ARG B  85      -4.494  25.087   9.344  1.00 25.59           C  
ATOM   1741  O   ARG B  85      -5.428  25.053  10.166  1.00 25.01           O  
ATOM   1742  CB  ARG B  85      -5.580  24.467   7.137  1.00 26.89           C  
ATOM   1743  CG  ARG B  85      -5.818  25.923   7.021  1.00 28.81           C  
ATOM   1744  CD  ARG B  85      -7.019  26.352   6.122  1.00 29.81           C  
ATOM   1745  NE  ARG B  85      -7.706  25.306   5.353  1.00 32.24           N  
ATOM   1746  CZ  ARG B  85      -8.601  25.611   4.408  1.00 31.41           C  
ATOM   1747  NH1 ARG B  85      -8.851  26.886   4.156  1.00 34.01           N  
ATOM   1748  NH2 ARG B  85      -9.223  24.678   3.712  1.00 30.74           N  
ATOM   1749  N   TYR B  86      -3.441  25.883   9.498  1.00 25.47           N  
ATOM   1750  CA  TYR B  86      -3.428  26.988  10.491  1.00 24.65           C  
ATOM   1751  C   TYR B  86      -4.469  28.076  10.181  1.00 26.02           C  
ATOM   1752  O   TYR B  86      -4.504  28.567   9.047  1.00 25.23           O  
ATOM   1753  CB  TYR B  86      -2.073  27.635  10.435  1.00 24.87           C  
ATOM   1754  CG  TYR B  86      -1.882  28.906  11.294  1.00 24.21           C  
ATOM   1755  CD1 TYR B  86      -1.663  28.823  12.656  1.00 25.90           C  
ATOM   1756  CD2 TYR B  86      -1.852  30.166  10.706  1.00 24.59           C  
ATOM   1757  CE1 TYR B  86      -1.449  29.973  13.430  1.00 25.31           C  
ATOM   1758  CE2 TYR B  86      -1.619  31.331  11.477  1.00 23.62           C  
ATOM   1759  CZ  TYR B  86      -1.427  31.215  12.832  1.00 25.37           C  
ATOM   1760  OH  TYR B  86      -1.208  32.324  13.618  1.00 25.13           O  
ATOM   1761  N   GLU B  87      -5.299  28.456  11.161  1.00 25.57           N  
ATOM   1762  CA  GLU B  87      -6.190  29.622  11.012  1.00 27.84           C  
ATOM   1763  C   GLU B  87      -6.016  30.496  12.205  1.00 26.83           C  
ATOM   1764  O   GLU B  87      -6.347  30.094  13.310  1.00 26.44           O  
ATOM   1765  CB  GLU B  87      -7.643  29.205  10.958  1.00 29.41           C  
ATOM   1766  CG  GLU B  87      -7.911  28.153   9.879  1.00 35.08           C  
ATOM   1767  CD  GLU B  87      -9.209  27.384  10.077  1.00 44.19           C  
ATOM   1768  OE1 GLU B  87     -10.108  27.905  10.771  1.00 47.92           O  
ATOM   1769  OE2 GLU B  87      -9.324  26.261   9.519  1.00 51.77           O  
ATOM   1770  N   GLU B  88      -5.445  31.677  12.008  1.00 26.91           N  
ATOM   1771  CA  GLU B  88      -5.286  32.626  13.134  1.00 25.83           C  
ATOM   1772  C   GLU B  88      -6.657  33.146  13.514  1.00 26.25           C  
ATOM   1773  O   GLU B  88      -7.520  33.280  12.651  1.00 26.57           O  
ATOM   1774  CB  GLU B  88      -4.385  33.778  12.739  1.00 27.20           C  
ATOM   1775  CG  GLU B  88      -3.961  34.643  13.931  1.00 26.61           C  
ATOM   1776  CD  GLU B  88      -2.669  35.374  13.727  1.00 29.02           C  
ATOM   1777  OE1 GLU B  88      -1.793  34.875  12.989  1.00 26.98           O  
ATOM   1778  OE2 GLU B  88      -2.510  36.445  14.350  1.00 27.71           O  
ATOM   1779  N   LEU B  89      -6.880  33.391  14.794  1.00 25.87           N  
ATOM   1780  CA  LEU B  89      -8.154  33.899  15.246  1.00 26.57           C  
ATOM   1781  C   LEU B  89      -7.944  35.290  15.841  1.00 25.83           C  
ATOM   1782  O   LEU B  89      -7.742  35.407  17.041  1.00 26.78           O  
ATOM   1783  CB  LEU B  89      -8.763  32.935  16.247  1.00 26.21           C  
ATOM   1784  CG  LEU B  89      -9.005  31.513  15.701  1.00 27.06           C  
ATOM   1785  CD1 LEU B  89      -9.183  30.525  16.885  1.00 29.68           C  
ATOM   1786  CD2 LEU B  89     -10.126  31.405  14.707  1.00 28.47           C  
ATOM   1787  N   PRO B  90      -8.040  36.354  15.013  1.00 24.94           N  
ATOM   1788  CA  PRO B  90      -7.749  37.673  15.523  1.00 25.09           C  
ATOM   1789  C   PRO B  90      -8.631  38.061  16.676  1.00 23.43           C  
ATOM   1790  O   PRO B  90      -9.762  37.552  16.767  1.00 21.46           O  
ATOM   1791  CB  PRO B  90      -8.047  38.595  14.335  1.00 25.65           C  
ATOM   1792  CG  PRO B  90      -7.958  37.768  13.198  1.00 26.97           C  
ATOM   1793  CD  PRO B  90      -8.471  36.427  13.613  1.00 26.72           C  
ATOM   1794  N   ASP B  91      -8.134  38.978  17.515  1.00 22.44           N  
ATOM   1795  CA  ASP B  91      -8.833  39.400  18.701  1.00 23.18           C  
ATOM   1796  C   ASP B  91      -9.975  40.374  18.378  1.00 22.88           C  
ATOM   1797  O   ASP B  91      -9.953  41.543  18.747  1.00 21.27           O  
ATOM   1798  CB  ASP B  91      -7.890  40.019  19.736  1.00 22.85           C  
ATOM   1799  CG  ASP B  91      -8.531  40.136  21.108  1.00 27.26           C  
ATOM   1800  OD1 ASP B  91      -9.688  39.686  21.330  1.00 28.92           O  
ATOM   1801  OD2 ASP B  91      -7.857  40.674  21.986  1.00 28.34           O  
ATOM   1802  N   LEU B  92     -10.989  39.829  17.722  1.00 23.30           N  
ATOM   1803  CA  LEU B  92     -12.171  40.570  17.302  1.00 23.98           C  
ATOM   1804  C   LEU B  92     -13.350  39.896  17.970  1.00 23.61           C  
ATOM   1805  O   LEU B  92     -13.274  38.735  18.366  1.00 23.13           O  
ATOM   1806  CB  LEU B  92     -12.349  40.513  15.780  1.00 23.94           C  
ATOM   1807  CG  LEU B  92     -11.147  40.974  14.951  1.00 27.81           C  
ATOM   1808  CD1 LEU B  92     -11.360  40.508  13.525  1.00 31.01           C  
ATOM   1809  CD2 LEU B  92     -10.964  42.477  15.034  1.00 29.49           C  
ATOM   1810  N   ILE B  93     -14.445  40.613  18.063  1.00 24.49           N  
ATOM   1811  CA  ILE B  93     -15.594  40.159  18.854  1.00 26.12           C  
ATOM   1812  C   ILE B  93     -16.180  38.835  18.364  1.00 26.66           C  
ATOM   1813  O   ILE B  93     -16.669  38.028  19.174  1.00 26.16           O  
ATOM   1814  CB  ILE B  93     -16.675  41.282  18.987  1.00 27.03           C  
ATOM   1815  CG1 ILE B  93     -17.760  40.926  20.024  1.00 28.27           C  
ATOM   1816  CG2 ILE B  93     -17.282  41.605  17.617  1.00 30.09           C  
ATOM   1817  CD1 ILE B  93     -17.234  40.725  21.474  1.00 30.15           C  
ATOM   1818  N   GLY B  94     -16.054  38.573  17.064  1.00 28.28           N  
ATOM   1819  CA  GLY B  94     -16.554  37.333  16.482  1.00 29.18           C  
ATOM   1820  C   GLY B  94     -15.825  36.091  16.974  1.00 30.07           C  
ATOM   1821  O   GLY B  94     -16.347  34.969  16.822  1.00 30.98           O  
ATOM   1822  N   HIS B  95     -14.615  36.271  17.524  1.00 28.19           N  
ATOM   1823  CA  HIS B  95     -13.815  35.163  18.078  1.00 26.77           C  
ATOM   1824  C   HIS B  95     -13.664  35.223  19.598  1.00 25.63           C  
ATOM   1825  O   HIS B  95     -12.992  34.388  20.187  1.00 25.54           O  
ATOM   1826  CB  HIS B  95     -12.415  35.125  17.432  1.00 26.82           C  
ATOM   1827  CG  HIS B  95     -12.438  34.936  15.954  1.00 29.35           C  
ATOM   1828  ND1 HIS B  95     -13.039  33.849  15.353  1.00 31.07           N  
ATOM   1829  CD2 HIS B  95     -11.943  35.700  14.947  1.00 31.36           C  
ATOM   1830  CE1 HIS B  95     -12.882  33.938  14.040  1.00 32.91           C  
ATOM   1831  NE2 HIS B  95     -12.219  35.049  13.770  1.00 32.15           N  
ATOM   1832  N   LYS B  96     -14.369  36.146  20.255  1.00 26.33           N  
ATOM   1833  CA  LYS B  96     -14.170  36.390  21.666  1.00 26.30           C  
ATOM   1834  C   LYS B  96     -14.629  35.197  22.514  1.00 26.54           C  
ATOM   1835  O   LYS B  96     -13.919  34.765  23.426  1.00 25.56           O  
ATOM   1836  CB  LYS B  96     -14.886  37.657  22.091  1.00 27.19           C  
ATOM   1837  CG  LYS B  96     -14.771  37.956  23.576  1.00 29.25           C  
ATOM   1838  CD  LYS B  96     -13.342  37.943  24.061  1.00 33.24           C  
ATOM   1839  CE  LYS B  96     -13.173  38.717  25.378  1.00 35.05           C  
ATOM   1840  NZ  LYS B  96     -11.741  38.636  25.832  1.00 37.61           N  
ATOM   1841  N   LEU B  97     -15.770  34.622  22.156  1.00 26.11           N  
ATOM   1842  CA  LEU B  97     -16.297  33.516  22.926  1.00 26.76           C  
ATOM   1843  C   LEU B  97     -15.370  32.300  22.755  1.00 25.80           C  
ATOM   1844  O   LEU B  97     -15.049  31.645  23.732  1.00 25.13           O  
ATOM   1845  CB  LEU B  97     -17.747  33.245  22.531  1.00 26.73           C  
ATOM   1846  CG  LEU B  97     -18.400  32.037  23.202  1.00 30.08           C  
ATOM   1847  CD1 LEU B  97     -18.577  32.314  24.702  1.00 30.70           C  
ATOM   1848  CD2 LEU B  97     -19.711  31.724  22.491  1.00 29.18           C  
ATOM   1849  N   GLN B  98     -14.919  32.039  21.526  1.00 25.90           N  
ATOM   1850  CA  GLN B  98     -13.925  30.980  21.249  1.00 26.26           C  
ATOM   1851  C   GLN B  98     -12.691  31.220  22.076  1.00 24.89           C  
ATOM   1852  O   GLN B  98     -12.162  30.316  22.722  1.00 25.09           O  
ATOM   1853  CB  GLN B  98     -13.495  30.987  19.781  1.00 26.72           C  
ATOM   1854  CG  GLN B  98     -14.592  30.558  18.827  1.00 31.69           C  
ATOM   1855  CD  GLN B  98     -14.260  30.851  17.400  1.00 36.32           C  
ATOM   1856  OE1 GLN B  98     -13.760  31.921  17.073  1.00 40.42           O  
ATOM   1857  NE2 GLN B  98     -14.571  29.909  16.522  1.00 40.14           N  
ATOM   1858  N   ARG B  99     -12.242  32.469  22.086  1.00 24.47           N  
ATOM   1859  CA  ARG B  99     -11.039  32.849  22.839  1.00 23.50           C  
ATOM   1860  C   ARG B  99     -11.219  32.627  24.332  1.00 23.81           C  
ATOM   1861  O   ARG B  99     -10.364  32.017  24.994  1.00 22.19           O  
ATOM   1862  CB  ARG B  99     -10.671  34.310  22.579  1.00 23.54           C  
ATOM   1863  CG  ARG B  99      -9.264  34.663  23.039  1.00 24.05           C  
ATOM   1864  CD  ARG B  99      -8.976  36.103  22.837  1.00 26.12           C  
ATOM   1865  NE  ARG B  99      -7.555  36.380  23.001  1.00 27.80           N  
ATOM   1866  CZ  ARG B  99      -6.674  36.567  22.009  1.00 28.58           C  
ATOM   1867  NH1 ARG B  99      -7.026  36.564  20.740  1.00 27.13           N  
ATOM   1868  NH2 ARG B  99      -5.403  36.800  22.313  1.00 32.10           N  
ATOM   1869  N   ASP B 100     -12.323  33.134  24.868  1.00 23.93           N  
ATOM   1870  CA  ASP B 100     -12.599  32.967  26.298  1.00 24.51           C  
ATOM   1871  C   ASP B 100     -12.686  31.501  26.704  1.00 24.26           C  
ATOM   1872  O   ASP B 100     -12.052  31.073  27.676  1.00 23.36           O  
ATOM   1873  CB  ASP B 100     -13.872  33.708  26.691  1.00 25.09           C  
ATOM   1874  CG  ASP B 100     -13.718  35.231  26.646  1.00 28.04           C  
ATOM   1875  OD1 ASP B 100     -12.561  35.771  26.565  1.00 31.70           O  
ATOM   1876  OD2 ASP B 100     -14.784  35.870  26.649  1.00 29.09           O  
ATOM   1877  N   HIS B 101     -13.441  30.722  25.931  1.00 24.61           N  
ATOM   1878  CA  HIS B 101     -13.548  29.277  26.178  1.00 25.03           C  
ATOM   1879  C   HIS B 101     -12.213  28.575  26.155  1.00 24.69           C  
ATOM   1880  O   HIS B 101     -11.874  27.863  27.095  1.00 24.61           O  
ATOM   1881  CB  HIS B 101     -14.414  28.603  25.115  1.00 25.40           C  
ATOM   1882  CG  HIS B 101     -15.866  28.924  25.227  1.00 26.45           C  
ATOM   1883  ND1 HIS B 101     -16.747  28.716  24.193  1.00 27.61           N  
ATOM   1884  CD2 HIS B 101     -16.601  29.395  26.264  1.00 27.79           C  
ATOM   1885  CE1 HIS B 101     -17.964  29.067  24.583  1.00 28.85           C  
ATOM   1886  NE2 HIS B 101     -17.899  29.481  25.835  1.00 26.72           N  
ATOM   1887  N   ALA B 102     -11.465  28.779  25.082  1.00 24.65           N  
ATOM   1888  CA  ALA B 102     -10.129  28.151  24.932  1.00 25.14           C  
ATOM   1889  C   ALA B 102      -9.187  28.552  26.058  1.00 24.99           C  
ATOM   1890  O   ALA B 102      -8.441  27.719  26.571  1.00 23.88           O  
ATOM   1891  CB  ALA B 102      -9.487  28.486  23.591  1.00 25.77           C  
ATOM   1892  N   TRP B 103      -9.207  29.835  26.418  1.00 25.09           N  
ATOM   1893  CA  TRP B 103      -8.262  30.356  27.402  1.00 25.35           C  
ATOM   1894  C   TRP B 103      -8.540  29.741  28.774  1.00 25.71           C  
ATOM   1895  O   TRP B 103      -7.608  29.452  29.541  1.00 25.59           O  
ATOM   1896  CB  TRP B 103      -8.358  31.873  27.488  1.00 25.61           C  
ATOM   1897  CG  TRP B 103      -7.446  32.425  28.494  1.00 25.44           C  
ATOM   1898  CD1 TRP B 103      -7.778  32.964  29.725  1.00 27.85           C  
ATOM   1899  CD2 TRP B 103      -6.036  32.430  28.424  1.00 25.23           C  
ATOM   1900  NE1 TRP B 103      -6.650  33.333  30.385  1.00 26.17           N  
ATOM   1901  CE2 TRP B 103      -5.562  33.021  29.611  1.00 26.24           C  
ATOM   1902  CE3 TRP B 103      -5.111  32.021  27.444  1.00 27.08           C  
ATOM   1903  CZ2 TRP B 103      -4.190  33.222  29.852  1.00 27.97           C  
ATOM   1904  CZ3 TRP B 103      -3.746  32.223  27.677  1.00 28.00           C  
ATOM   1905  CH2 TRP B 103      -3.300  32.796  28.882  1.00 26.12           C  
ATOM   1906  N   SER B 104      -9.814  29.550  29.084  1.00 25.62           N  
ATOM   1907  CA  SER B 104     -10.183  28.999  30.386  0.50 26.52           C  
ATOM   1909  C   SER B 104      -9.679  27.566  30.515  1.00 26.85           C  
ATOM   1910  O   SER B 104      -9.245  27.169  31.583  1.00 27.73           O  
ATOM   1911  CB  SER B 104     -11.693  29.119  30.668  0.50 26.32           C  
ATOM   1913  OG  SER B 104     -12.488  28.277  29.856  0.50 27.03           O  
ATOM   1915  N   VAL B 105      -9.684  26.810  29.409  1.00 28.73           N  
ATOM   1916  CA  VAL B 105      -9.183  25.424  29.412  1.00 29.59           C  
ATOM   1917  C   VAL B 105      -7.655  25.380  29.386  1.00 29.54           C  
ATOM   1918  O   VAL B 105      -7.037  24.557  30.060  1.00 29.18           O  
ATOM   1919  CB  VAL B 105      -9.761  24.633  28.238  1.00 29.82           C  
ATOM   1920  CG1 VAL B 105      -8.996  23.343  28.022  1.00 32.46           C  
ATOM   1921  CG2 VAL B 105     -11.226  24.378  28.476  1.00 30.23           C  
ATOM   1922  N   LEU B 106      -7.047  26.284  28.640  1.00 29.88           N  
ATOM   1923  CA  LEU B 106      -5.605  26.271  28.443  1.00 31.15           C  
ATOM   1924  C   LEU B 106      -4.825  27.190  29.376  1.00 33.12           C  
ATOM   1925  O   LEU B 106      -3.591  27.181  29.368  1.00 33.88           O  
ATOM   1926  CB  LEU B 106      -5.290  26.629  26.990  1.00 30.91           C  
ATOM   1927  CG  LEU B 106      -5.681  25.570  25.957  1.00 29.44           C  
ATOM   1928  CD1 LEU B 106      -5.648  26.193  24.578  1.00 28.44           C  
ATOM   1929  CD2 LEU B 106      -4.784  24.321  26.022  1.00 30.82           C  
ATOM   1930  N   SER B 107      -5.540  27.996  30.160  1.00 34.62           N  
ATOM   1931  CA  SER B 107      -4.921  29.040  30.982  1.00 36.41           C  
ATOM   1932  C   SER B 107      -3.908  28.463  31.938  1.00 37.57           C  
ATOM   1933  O   SER B 107      -2.798  28.985  32.036  1.00 38.48           O  
ATOM   1934  CB  SER B 107      -5.982  29.779  31.781  1.00 35.67           C  
ATOM   1935  OG  SER B 107      -5.406  30.404  32.900  1.00 39.86           O  
ATOM   1936  N   LYS B 108      -4.307  27.408  32.649  1.00 38.68           N  
ATOM   1937  CA  LYS B 108      -3.424  26.656  33.541  1.00 40.68           C  
ATOM   1938  C   LYS B 108      -2.159  26.137  32.824  1.00 41.16           C  
ATOM   1939  O   LYS B 108      -1.027  26.340  33.297  1.00 40.70           O  
ATOM   1940  CB  LYS B 108      -4.202  25.462  34.132  1.00 41.20           C  
ATOM   1941  CG  LYS B 108      -3.514  24.758  35.322  1.00 43.48           C  
ATOM   1942  CD  LYS B 108      -3.610  23.208  35.227  1.00 44.45           C  
ATOM   1943  CE  LYS B 108      -3.275  22.503  36.566  1.00 44.83           C  
ATOM   1944  NZ  LYS B 108      -2.949  21.039  36.380  1.00 45.30           N  
ATOM   1945  N   HIS B 109      -2.384  25.472  31.687  1.00 41.95           N  
ATOM   1946  CA  HIS B 109      -1.312  24.854  30.884  1.00 42.49           C  
ATOM   1947  C   HIS B 109      -0.375  25.909  30.360  1.00 41.62           C  
ATOM   1948  O   HIS B 109       0.836  25.699  30.333  1.00 41.57           O  
ATOM   1949  CB  HIS B 109      -1.896  24.018  29.724  1.00 43.15           C  
ATOM   1950  CG  HIS B 109      -2.652  22.819  30.192  1.00 46.82           C  
ATOM   1951  ND1 HIS B 109      -2.037  21.614  30.466  1.00 51.88           N  
ATOM   1952  CD2 HIS B 109      -3.958  22.657  30.516  1.00 49.36           C  
ATOM   1953  CE1 HIS B 109      -2.934  20.756  30.920  1.00 51.37           C  
ATOM   1954  NE2 HIS B 109      -4.109  21.362  30.957  1.00 50.44           N  
ATOM   1955  N   THR B 110      -0.948  27.046  29.961  1.00 41.30           N  
ATOM   1956  CA  THR B 110      -0.187  28.194  29.451  1.00 41.28           C  
ATOM   1957  C   THR B 110       0.806  28.688  30.496  1.00 41.40           C  
ATOM   1958  O   THR B 110       1.881  29.174  30.160  1.00 41.05           O  
ATOM   1959  CB  THR B 110      -1.117  29.362  29.002  1.00 41.21           C  
ATOM   1960  OG1 THR B 110      -1.979  28.914  27.943  1.00 40.04           O  
ATOM   1961  CG2 THR B 110      -0.299  30.570  28.536  1.00 41.28           C  
ATOM   1962  N   ASP B 111       0.470  28.511  31.766  1.00 41.58           N  
ATOM   1963  CA  ASP B 111       1.411  28.881  32.814  1.00 42.31           C  
ATOM   1964  C   ASP B 111       2.639  27.998  32.817  1.00 42.03           C  
ATOM   1965  O   ASP B 111       3.608  28.347  33.478  1.00 41.71           O  
ATOM   1966  CB  ASP B 111       0.751  28.865  34.200  1.00 42.51           C  
ATOM   1967  CG  ASP B 111      -0.231  29.995  34.374  1.00 44.23           C  
ATOM   1968  OD1 ASP B 111       0.015  31.087  33.795  1.00 45.73           O  
ATOM   1969  OD2 ASP B 111      -1.245  29.796  35.072  1.00 45.73           O  
ATOM   1970  N   TRP B 112       2.603  26.872  32.094  1.00 41.87           N  
ATOM   1971  CA  TRP B 112       3.734  25.940  32.056  1.00 41.63           C  
ATOM   1972  C   TRP B 112       4.716  26.137  30.883  1.00 40.92           C  
ATOM   1973  O   TRP B 112       5.741  25.455  30.846  1.00 40.68           O  
ATOM   1974  CB  TRP B 112       3.261  24.484  32.116  1.00 42.21           C  
ATOM   1975  CG  TRP B 112       2.311  24.203  33.244  1.00 43.02           C  
ATOM   1976  CD1 TRP B 112       2.176  24.899  34.420  1.00 43.70           C  
ATOM   1977  CD2 TRP B 112       1.358  23.143  33.300  1.00 44.52           C  
ATOM   1978  NE1 TRP B 112       1.186  24.345  35.191  1.00 43.63           N  
ATOM   1979  CE2 TRP B 112       0.669  23.262  34.527  1.00 44.09           C  
ATOM   1980  CE3 TRP B 112       0.998  22.113  32.416  1.00 44.33           C  
ATOM   1981  CZ2 TRP B 112      -0.340  22.367  34.909  1.00 44.33           C  
ATOM   1982  CZ3 TRP B 112      -0.010  21.229  32.788  1.00 43.35           C  
ATOM   1983  CH2 TRP B 112      -0.669  21.364  34.022  1.00 44.07           C  
ATOM   1984  N   TRP B 113       4.439  27.069  29.964  1.00 39.34           N  
ATOM   1985  CA  TRP B 113       5.424  27.430  28.919  1.00 38.50           C  
ATOM   1986  C   TRP B 113       5.636  28.927  28.733  1.00 38.02           C  
ATOM   1987  O   TRP B 113       6.692  29.333  28.259  1.00 36.71           O  
ATOM   1988  CB  TRP B 113       5.039  26.818  27.549  1.00 37.50           C  
ATOM   1989  CG  TRP B 113       3.664  27.202  27.086  1.00 37.36           C  
ATOM   1990  CD1 TRP B 113       2.517  26.483  27.252  1.00 36.72           C  
ATOM   1991  CD2 TRP B 113       3.288  28.392  26.366  1.00 36.12           C  
ATOM   1992  NE1 TRP B 113       1.456  27.140  26.689  1.00 36.44           N  
ATOM   1993  CE2 TRP B 113       1.894  28.320  26.147  1.00 37.10           C  
ATOM   1994  CE3 TRP B 113       3.999  29.500  25.875  1.00 36.76           C  
ATOM   1995  CZ2 TRP B 113       1.190  29.319  25.466  1.00 36.24           C  
ATOM   1996  CZ3 TRP B 113       3.302  30.494  25.205  1.00 37.02           C  
ATOM   1997  CH2 TRP B 113       1.908  30.408  25.025  1.00 36.95           C  
ATOM   1998  N   GLU B 114       4.612  29.730  29.043  1.00 38.35           N  
ATOM   1999  CA  GLU B 114       4.659  31.184  28.811  1.00 39.07           C  
ATOM   2000  C   GLU B 114       5.805  31.859  29.598  1.00 39.21           C  
ATOM   2001  O   GLU B 114       5.806  31.826  30.831  1.00 38.57           O  
ATOM   2002  CB  GLU B 114       3.312  31.804  29.206  1.00 39.48           C  
ATOM   2003  CG  GLU B 114       3.161  33.291  28.933  1.00 41.57           C  
ATOM   2004  CD  GLU B 114       1.993  33.862  29.731  1.00 46.27           C  
ATOM   2005  OE1 GLU B 114       0.827  33.760  29.269  1.00 47.00           O  
ATOM   2006  OE2 GLU B 114       2.246  34.370  30.852  1.00 49.40           O  
ATOM   2007  N   PRO B 115       6.766  32.490  28.891  1.00 39.27           N  
ATOM   2008  CA  PRO B 115       7.850  33.145  29.628  1.00 40.06           C  
ATOM   2009  C   PRO B 115       7.354  34.381  30.388  1.00 40.59           C  
ATOM   2010  O   PRO B 115       6.635  35.231  29.832  1.00 39.93           O  
ATOM   2011  CB  PRO B 115       8.859  33.533  28.534  1.00 39.84           C  
ATOM   2012  CG  PRO B 115       8.372  32.846  27.273  1.00 40.13           C  
ATOM   2013  CD  PRO B 115       6.918  32.653  27.433  1.00 39.95           C  
ATOM   2014  N   GLY B 116       7.715  34.459  31.659  1.00 41.81           N  
ATOM   2015  CA  GLY B 116       7.390  35.638  32.471  1.00 42.86           C  
ATOM   2016  C   GLY B 116       8.187  36.849  32.029  1.00 43.55           C  
ATOM   2017  O   GLY B 116       9.199  36.703  31.337  1.00 43.78           O  
ATOM   2018  N   ALA B 117       7.718  38.040  32.418  1.00 44.40           N  
ATOM   2019  CA  ALA B 117       8.486  39.284  32.244  1.00 44.85           C  
ATOM   2020  C   ALA B 117       9.742  39.226  33.124  1.00 45.28           C  
ATOM   2021  O   ALA B 117       9.666  38.798  34.271  1.00 45.06           O  
ATOM   2022  CB  ALA B 117       7.625  40.521  32.568  1.00 44.74           C  
ATOM   2023  N   LEU B 118      10.883  39.633  32.555  1.00 46.07           N  
ATOM   2024  CA  LEU B 118      12.224  39.490  33.166  1.00 46.30           C  
ATOM   2025  C   LEU B 118      12.444  38.171  33.942  1.00 46.48           C  
ATOM   2026  O   LEU B 118      12.096  37.077  33.476  1.00 47.05           O  
ATOM   2027  CB  LEU B 118      12.541  40.686  34.076  1.00 46.35           C  
ATOM   2028  CG  LEU B 118      12.895  42.062  33.506  1.00 46.46           C  
ATOM   2029  CD1 LEU B 118      11.643  42.783  32.984  1.00 47.32           C  
ATOM   2030  CD2 LEU B 118      13.608  42.921  34.566  1.00 46.32           C  
ATOM   2031  N   SER B 128      -4.584  36.625  27.866  1.00 60.42           N  
ATOM   2032  CA  SER B 128      -4.629  36.335  26.429  1.00 58.84           C  
ATOM   2033  C   SER B 128      -4.722  37.635  25.583  1.00 60.98           C  
ATOM   2034  O   SER B 128      -5.484  37.708  24.631  1.00 64.55           O  
ATOM   2035  CB  SER B 128      -5.786  35.369  26.123  1.00 57.75           C  
ATOM   2036  OG  SER B 128      -7.058  35.932  26.438  1.00 48.80           O  
ATOM   2037  N   ALA B 129      -3.975  38.674  25.945  1.00 59.48           N  
ATOM   2038  CA  ALA B 129      -3.959  39.885  25.140  1.00 58.51           C  
ATOM   2039  C   ALA B 129      -2.816  39.859  24.107  1.00 58.40           C  
ATOM   2040  O   ALA B 129      -3.104  39.882  22.916  1.00 61.09           O  
ATOM   2041  CB  ALA B 129      -3.918  41.148  26.016  1.00 58.73           C  
ATOM   2042  N   PRO B 130      -1.522  39.757  24.537  1.00 55.36           N  
ATOM   2043  CA  PRO B 130      -0.448  39.763  23.505  1.00 50.87           C  
ATOM   2044  C   PRO B 130      -0.282  38.373  22.885  1.00 45.59           C  
ATOM   2045  O   PRO B 130       0.648  38.141  22.109  1.00 45.54           O  
ATOM   2046  CB  PRO B 130       0.804  40.121  24.297  1.00 50.94           C  
ATOM   2047  CG  PRO B 130       0.553  39.502  25.673  1.00 55.12           C  
ATOM   2048  CD  PRO B 130      -0.972  39.549  25.895  1.00 56.34           C  
ATOM   2049  N   HIS B 131      -1.180  37.479  23.266  1.00 39.87           N  
ATOM   2050  CA  HIS B 131      -1.177  36.140  22.755  1.00 37.52           C  
ATOM   2051  C   HIS B 131      -1.767  36.099  21.378  1.00 34.37           C  
ATOM   2052  O   HIS B 131      -2.726  36.802  21.062  1.00 32.09           O  
ATOM   2053  CB  HIS B 131      -1.991  35.225  23.647  1.00 38.32           C  
ATOM   2054  CG  HIS B 131      -1.329  34.932  24.941  1.00 40.49           C  
ATOM   2055  ND1 HIS B 131      -0.457  33.874  25.092  1.00 43.40           N  
ATOM   2056  CD2 HIS B 131      -1.359  35.581  26.125  1.00 41.64           C  
ATOM   2057  CE1 HIS B 131       0.006  33.874  26.330  1.00 45.61           C  
ATOM   2058  NE2 HIS B 131      -0.530  34.898  26.977  1.00 43.65           N  
ATOM   2059  N   VAL B 132      -1.200  35.212  20.579  1.00 31.17           N  
ATOM   2060  CA  VAL B 132      -1.811  34.839  19.333  1.00 29.68           C  
ATOM   2061  C   VAL B 132      -2.674  33.614  19.622  1.00 28.05           C  
ATOM   2062  O   VAL B 132      -2.183  32.589  20.108  1.00 27.12           O  
ATOM   2063  CB  VAL B 132      -0.756  34.493  18.273  1.00 28.37           C  
ATOM   2064  CG1 VAL B 132      -1.450  34.045  17.005  1.00 29.42           C  
ATOM   2065  CG2 VAL B 132       0.145  35.651  18.041  1.00 29.73           C  
ATOM   2066  N   PHE B 133      -3.963  33.736  19.345  1.00 26.32           N  
ATOM   2067  CA  PHE B 133      -4.905  32.623  19.449  1.00 24.97           C  
ATOM   2068  C   PHE B 133      -5.098  32.062  18.044  1.00 24.68           C  
ATOM   2069  O   PHE B 133      -5.198  32.823  17.075  1.00 23.08           O  
ATOM   2070  CB  PHE B 133      -6.233  33.183  19.969  1.00 24.57           C  
ATOM   2071  CG  PHE B 133      -7.334  32.182  20.107  1.00 24.44           C  
ATOM   2072  CD1 PHE B 133      -7.103  30.913  20.569  1.00 21.72           C  
ATOM   2073  CD2 PHE B 133      -8.641  32.560  19.824  1.00 24.91           C  
ATOM   2074  CE1 PHE B 133      -8.127  30.045  20.705  1.00 24.50           C  
ATOM   2075  CE2 PHE B 133      -9.668  31.696  19.962  1.00 23.53           C  
ATOM   2076  CZ  PHE B 133      -9.423  30.443  20.418  1.00 24.82           C  
ATOM   2077  N   PHE B 134      -5.140  30.742  17.920  1.00 23.20           N  
ATOM   2078  CA  PHE B 134      -5.278  30.134  16.606  1.00 23.97           C  
ATOM   2079  C   PHE B 134      -5.874  28.763  16.729  1.00 23.50           C  
ATOM   2080  O   PHE B 134      -5.920  28.173  17.837  1.00 24.28           O  
ATOM   2081  CB  PHE B 134      -3.935  30.090  15.851  1.00 23.31           C  
ATOM   2082  CG  PHE B 134      -2.915  29.116  16.414  1.00 23.33           C  
ATOM   2083  CD1 PHE B 134      -2.048  29.508  17.412  1.00 23.93           C  
ATOM   2084  CD2 PHE B 134      -2.817  27.808  15.952  1.00 25.15           C  
ATOM   2085  CE1 PHE B 134      -1.114  28.606  17.938  1.00 24.28           C  
ATOM   2086  CE2 PHE B 134      -1.846  26.921  16.461  1.00 26.21           C  
ATOM   2087  CZ  PHE B 134      -1.020  27.308  17.449  1.00 23.57           C  
ATOM   2088  N   ARG B 135      -6.305  28.254  15.584  1.00 25.28           N  
ATOM   2089  CA  ARG B 135      -6.710  26.859  15.483  1.00 26.04           C  
ATOM   2090  C   ARG B 135      -6.089  26.162  14.282  1.00 25.81           C  
ATOM   2091  O   ARG B 135      -5.805  26.768  13.245  1.00 25.97           O  
ATOM   2092  CB  ARG B 135      -8.226  26.693  15.470  1.00 25.78           C  
ATOM   2093  CG  ARG B 135      -8.967  27.371  14.365  1.00 25.38           C  
ATOM   2094  CD  ARG B 135     -10.484  27.362  14.605  1.00 26.99           C  
ATOM   2095  NE  ARG B 135     -11.139  27.854  13.400  1.00 27.42           N  
ATOM   2096  CZ  ARG B 135     -12.442  28.108  13.262  1.00 32.13           C  
ATOM   2097  NH1 ARG B 135     -13.297  27.948  14.249  1.00 31.52           N  
ATOM   2098  NH2 ARG B 135     -12.900  28.564  12.110  1.00 31.29           N  
ATOM   2099  N   ILE B 136      -5.910  24.861  14.440  1.00 25.29           N  
ATOM   2100  CA  ILE B 136      -5.610  23.962  13.365  1.00 24.25           C  
ATOM   2101  C   ILE B 136      -6.883  23.235  12.938  1.00 25.03           C  
ATOM   2102  O   ILE B 136      -7.467  22.456  13.711  1.00 23.91           O  
ATOM   2103  CB  ILE B 136      -4.551  22.926  13.798  1.00 24.42           C  
ATOM   2104  CG1 ILE B 136      -3.278  23.597  14.314  1.00 24.93           C  
ATOM   2105  CG2 ILE B 136      -4.234  22.017  12.672  1.00 23.41           C  
ATOM   2106  CD1 ILE B 136      -2.639  24.678  13.452  1.00 24.59           C  
ATOM   2107  N   LEU B 137      -7.336  23.512  11.722  1.00 25.20           N  
ATOM   2108  CA  LEU B 137      -8.434  22.750  11.124  1.00 26.69           C  
ATOM   2109  C   LEU B 137      -7.940  21.400  10.682  1.00 24.45           C  
ATOM   2110  O   LEU B 137      -6.918  21.302   9.991  1.00 24.62           O  
ATOM   2111  CB  LEU B 137      -8.995  23.502   9.945  1.00 27.01           C  
ATOM   2112  CG  LEU B 137     -10.018  22.764   9.106  1.00 32.06           C  
ATOM   2113  CD1 LEU B 137     -11.213  22.128   9.891  1.00 33.93           C  
ATOM   2114  CD2 LEU B 137     -10.544  23.783   8.106  1.00 36.32           C  
ATOM   2115  N   ILE B 138      -8.613  20.355  11.153  1.00 24.55           N  
ATOM   2116  CA  ILE B 138      -8.228  18.982  10.873  1.00 24.96           C  
ATOM   2117  C   ILE B 138      -8.803  18.631   9.505  1.00 25.87           C  
ATOM   2118  O   ILE B 138     -10.004  18.514   9.348  1.00 26.25           O  
ATOM   2119  CB  ILE B 138      -8.774  18.015  11.974  1.00 23.88           C  
ATOM   2120  CG1 ILE B 138      -8.172  18.385  13.324  1.00 25.66           C  
ATOM   2121  CG2 ILE B 138      -8.470  16.533  11.623  1.00 25.99           C  
ATOM   2122  CD1 ILE B 138      -8.828  17.748  14.534  1.00 25.36           C  
ATOM   2123  N   GLU B 139      -7.947  18.481   8.494  1.00 26.08           N  
ATOM   2124  CA  GLU B 139      -8.427  18.148   7.168  1.00 26.49           C  
ATOM   2125  C   GLU B 139      -8.312  16.658   6.880  1.00 27.01           C  
ATOM   2126  O   GLU B 139      -9.238  16.056   6.347  1.00 27.70           O  
ATOM   2127  CB  GLU B 139      -7.699  18.987   6.122  1.00 26.32           C  
ATOM   2128  CG  GLU B 139      -7.934  20.476   6.381  1.00 27.49           C  
ATOM   2129  CD  GLU B 139      -7.607  21.377   5.237  1.00 29.13           C  
ATOM   2130  OE1 GLU B 139      -6.933  20.930   4.288  1.00 27.63           O  
ATOM   2131  OE2 GLU B 139      -8.038  22.542   5.308  1.00 28.86           O  
ATOM   2132  N   GLN B 140      -7.173  16.069   7.189  1.00 27.07           N  
ATOM   2133  CA  GLN B 140      -6.992  14.609   7.074  1.00 26.84           C  
ATOM   2134  C   GLN B 140      -6.500  14.134   8.436  1.00 26.51           C  
ATOM   2135  O   GLN B 140      -5.825  14.877   9.176  1.00 25.97           O  
ATOM   2136  CB  GLN B 140      -5.939  14.229   6.014  1.00 27.13           C  
ATOM   2137  CG  GLN B 140      -5.985  15.070   4.729  1.00 30.96           C  
ATOM   2138  CD  GLN B 140      -7.250  14.821   3.905  1.00 35.12           C  
ATOM   2139  OE1 GLN B 140      -7.859  13.751   4.034  1.00 36.73           O  
ATOM   2140  NE2 GLN B 140      -7.642  15.794   3.039  1.00 30.93           N  
ATOM   2141  N   VAL B 141      -6.871  12.924   8.805  1.00 26.56           N  
ATOM   2142  CA  VAL B 141      -6.433  12.349  10.088  1.00 27.08           C  
ATOM   2143  C   VAL B 141      -6.260  10.855   9.904  1.00 26.48           C  
ATOM   2144  O   VAL B 141      -7.051  10.219   9.211  1.00 25.69           O  
ATOM   2145  CB  VAL B 141      -7.403  12.686  11.265  1.00 27.89           C  
ATOM   2146  CG1 VAL B 141      -8.725  12.125  11.065  1.00 29.67           C  
ATOM   2147  CG2 VAL B 141      -6.852  12.160  12.630  1.00 27.50           C  
ATOM   2148  N   SER B 142      -5.184  10.323  10.471  1.00 26.47           N  
ATOM   2149  CA  SER B 142      -4.893   8.908  10.493  1.00 27.07           C  
ATOM   2150  C   SER B 142      -4.447   8.533  11.898  1.00 26.56           C  
ATOM   2151  O   SER B 142      -4.015   9.389  12.670  1.00 25.30           O  
ATOM   2152  CB  SER B 142      -3.782   8.550   9.509  1.00 27.75           C  
ATOM   2153  OG  SER B 142      -2.574   9.190   9.935  1.00 31.92           O  
ATOM   2154  N   GLY B 143      -4.576   7.250  12.215  1.00 25.29           N  
ATOM   2155  CA  GLY B 143      -4.266   6.737  13.548  1.00 25.86           C  
ATOM   2156  C   GLY B 143      -3.625   5.361  13.458  1.00 25.69           C  
ATOM   2157  O   GLY B 143      -3.878   4.610  12.518  1.00 26.02           O  
ATOM   2158  N   ARG B 144      -2.787   5.049  14.444  1.00 25.77           N  
ATOM   2159  CA  ARG B 144      -2.162   3.754  14.591  1.00 26.62           C  
ATOM   2160  C   ARG B 144      -2.232   3.317  16.039  1.00 26.63           C  
ATOM   2161  O   ARG B 144      -2.115   4.134  16.928  1.00 24.57           O  
ATOM   2162  CB  ARG B 144      -0.667   3.789  14.253  1.00 27.65           C  
ATOM   2163  CG  ARG B 144      -0.307   4.077  12.816  1.00 31.23           C  
ATOM   2164  CD  ARG B 144      -0.522   2.862  11.974  1.00 34.16           C  
ATOM   2165  NE  ARG B 144      -0.307   3.109  10.544  1.00 36.40           N  
ATOM   2166  CZ  ARG B 144       0.831   2.887   9.892  1.00 38.33           C  
ATOM   2167  NH1 ARG B 144       1.906   2.401  10.507  1.00 40.51           N  
ATOM   2168  NH2 ARG B 144       0.883   3.116   8.592  1.00 39.30           N  
ATOM   2169  N   GLU B 145      -2.362   2.018  16.277  1.00 25.72           N  
ATOM   2170  CA  GLU B 145      -2.223   1.489  17.625  1.00 27.21           C  
ATOM   2171  C   GLU B 145      -1.298   0.276  17.607  1.00 27.50           C  
ATOM   2172  O   GLU B 145      -1.422  -0.550  16.737  1.00 26.96           O  
ATOM   2173  CB  GLU B 145      -3.566   1.049  18.194  1.00 27.92           C  
ATOM   2174  CG  GLU B 145      -3.428   0.430  19.588  1.00 32.23           C  
ATOM   2175  CD  GLU B 145      -4.633  -0.309  20.040  1.00 37.60           C  
ATOM   2176  OE1 GLU B 145      -5.667   0.348  20.238  1.00 40.58           O  
ATOM   2177  OE2 GLU B 145      -4.556  -1.565  20.193  1.00 44.09           O  
ATOM   2178  N   ALA B 146      -0.372   0.219  18.553  1.00 28.31           N  
ATOM   2179  CA  ALA B 146       0.413  -0.968  18.872  1.00 29.73           C  
ATOM   2180  C   ALA B 146      -0.176  -1.641  20.103  1.00 30.62           C  
ATOM   2181  O   ALA B 146      -0.348  -0.991  21.140  1.00 30.95           O  
ATOM   2182  CB  ALA B 146       1.862  -0.584  19.169  1.00 29.89           C  
ATOM   2183  N   SER B 147      -0.493  -2.921  19.984  1.00 31.84           N  
ATOM   2184  CA  SER B 147      -0.826  -3.789  21.138  1.00 32.99           C  
ATOM   2185  C   SER B 147       0.364  -4.692  21.466  1.00 33.33           C  
ATOM   2186  O   SER B 147       0.249  -5.624  22.265  1.00 34.32           O  
ATOM   2187  CB  SER B 147      -2.031  -4.681  20.823  1.00 33.33           C  
ATOM   2188  OG  SER B 147      -3.074  -3.932  20.226  1.00 35.46           O  
TER    2189      SER B 147                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
