
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 ( 1076),  selected  132 , name 2pag_A
# Molecule2: number of CA atoms  132 ( 1062),  selected  132 , name T0401.pdb
# PARAMETERS: 2pag_A.T0401.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     1_A      M       1           -
LGA    E     2_A      E       2           -
LGA    E     3_A      V       3           -
LGA    V     4_A      I       4           -
LGA    I     5_A      E       5           -
LGA    E     6_A      -       -           -
LGA    Q     7_A      -       -           -
LGA    L     8_A      S       6           #
LGA    R     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    A    11_A      K       7          2.925
LGA    N    12_A      W       8          3.395
LGA    E    13_A      Y       9          3.572
LGA    P    14_A      K      10           -
LGA    V    15_A      -       -           -
LGA    P    16_A      -       -           -
LGA    V    17_A      -       -           -
LGA    P    18_A      -       -           -
LGA    L    19_A      K      11          3.323
LGA    E    20_A      D      12          2.991
LGA    L    21_A      G      13          1.404
LGA    P    22_A      A      14          0.795
LGA    D    23_A      S      15          1.997
LGA    E    24_A      S      16          1.376
LGA    D    25_A      A      17          1.293
LGA    Q    26_A      S      18          1.216
LGA    L    27_A      I      19          0.397
LGA    V    28_A      D      20          0.328
LGA    E    29_A      D      21          0.614
LGA    I    30_A      V      22          1.389
LGA    E    31_A      E      23          1.447
LGA    E    32_A      K      24          1.601
LGA    Q    33_A      L      25          2.316
LGA    L    34_A      L      26          2.926
LGA    F    35_A      N      27          2.942
LGA    I    36_A      T      28          2.818
LGA    N    37_A      T      29          1.808
LGA    I    38_A      L      30          0.776
LGA    P    39_A      P      31          1.544
LGA    F    40_A      K      32          1.472
LGA    V    41_A      Q      33          1.683
LGA    F    42_A      Y      34          1.649
LGA    K    43_A      K      35          1.314
LGA    E    44_A      S      36          1.388
LGA    F    45_A      F      37          1.823
LGA    L    46_A      L      38          1.445
LGA    L    47_A      L      39          1.320
LGA    T    48_A      W      40          2.013
LGA    V    49_A      S      41          3.120
LGA    S    50_A      N      42          3.171
LGA    D    51_A      G      43          4.615
LGA    V    52_A      G      44          3.824
LGA    V    53_A      E      45          3.144
LGA    Y    54_A      G      46          1.343
LGA    G    55_A      K      47          2.309
LGA    -       -      L      48           -
LGA    -       -      G      49           -
LGA    -       -      D      50           -
LGA    -       -      N      51           -
LGA    S    56_A      Y      52          2.575
LGA    L    57_A      I      53          1.925
LGA    E    58_A      Y      54          0.815
LGA    P    59_A      I      55          0.961
LGA    V    60_A      W      56          1.946
LGA    T    61_A      A      57          1.258
LGA    V    62_A      I      58          1.689
LGA    T    63_A      E      59          4.677
LGA    D    64_A      -       -           -
LGA    P    65_A      -       -           -
LGA    Q    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    H    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    Y    70_A      D      60          1.608
LGA    L    71_A      V      61          0.693
LGA    P    72_A      I      62          1.201
LGA    E    73_A      A      63          1.081
LGA    V    74_A      Y      64          1.559
LGA    C    75_A      N      65          1.656
LGA    A    76_A      H      66          1.120
LGA    T    77_A      D      67          2.270
LGA    A    78_A      Y      68          3.374
LGA    W    79_A      G      69          3.372
LGA    -       -      I      70           -
LGA    D    80_A      Q      71          5.668
LGA    L    81_A      K      72          5.581
LGA    G    82_A      Y      73          1.332
LGA    V    83_A      L      74          2.771
LGA    P    84_A      Q      75          1.643
LGA    R    85_A      K      76          1.583
LGA    E    86_A      E      77          0.726
LGA    L    87_A      Y      78          0.802
LGA    I    88_A      W      79          1.509
LGA    P    89_A      A      80          1.180
LGA    I    90_A      F      81          2.008
LGA    C    91_A      G      82          1.452
LGA    Q    92_A      M      83          2.143
LGA    D    93_A      D      84          2.914
LGA    G    94_A      G      85          2.914
LGA    E    95_A      D      86          3.725
LGA    D    96_A      I      87          3.406
LGA    Y    97_A      G      88          1.883
LGA    Y    98_A      Y      89          1.537
LGA    C    99_A      I      90          1.086
LGA    V   100_A      L      91          1.009
LGA    E   101_A      H      92          1.240
LGA    E   102_A      L      93          2.143
LGA    -       -      S      94           -
LGA    D   103_A      D      95          1.557
LGA    G   104_A      N      96          0.711
LGA    T   105_A      S      97          0.756
LGA    V   106_A      I      98          0.585
LGA    L   107_A      Y      99          1.395
LGA    L   108_A      R     100          1.689
LGA    W   109_A      V     101          2.615
LGA    S   110_A      D     102          3.217
LGA    -       -      L     103           -
LGA    -       -      G     104           -
LGA    -       -      D     105           -
LGA    A   111_A      L     106          2.727
LGA    L   115_A      D     107          2.480
LGA    -       -      I     108           -
LGA    -       -      T     109           -
LGA    V   116_A      S     110          3.477
LGA    T   117_A      I     111          3.255
LGA    E   118_A      K     112          3.952
LGA    E   119_A      Y     113          3.216
LGA    S   120_A      I     114          2.059
LGA    W   121_A      A     115          0.433
LGA    E   122_A      P     116          1.459
LGA    S   123_A      S     117          0.892
LGA    V   124_A      F     118          0.408
LGA    W   125_A      D     119          0.843
LGA    H   126_A      D     120          1.570
LGA    W   127_A      F     121          1.350
LGA    A   128_A      L     122          1.682
LGA    R   129_A      G     123          2.251
LGA    D   130_A      K     124          2.108
LGA    V   131_A      A     125          2.898
LGA    W   132_A      -       -           -
LGA    L   133_A      I     126          4.677
LGA    E   134_A      Y     127           #
LGA    -       -      L     128           -
LGA    S   135_A      N     129           #
LGA    -       -      F     130           -
LGA    -       -      N     131           -
LGA    -       -      K     132           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  132    5.0    108    2.32    12.04     58.172     4.471

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.015942 * X  +   0.899108 * Y  +  -0.437437 * Z  +  45.825573
  Y_new =   0.978108 * X  +   0.104808 * Y  +   0.179776 * Z  +  20.857990
  Z_new =   0.207485 * X  +  -0.424994 * Y  +  -0.881096 * Z  +  54.849026 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.692167    0.449426  [ DEG:  -154.2498     25.7502 ]
  Theta =  -0.209004   -2.932589  [ DEG:   -11.9750   -168.0250 ]
  Phi   =   1.587094   -1.554499  [ DEG:    90.9338    -89.0662 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pag_A                                        
REMARK     2: T0401.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pag_A.T0401.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  132   5.0  108   2.32   12.04  58.172
REMARK  ---------------------------------------------------------- 
MOLECULE 2pag_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   27-MAR-07   2PAG              
TITLE     CRYSTAL STRUCTURE OF PROTEIN PSPTO_5518 FROM PSEUDOMONAS              
TITLE    2 SYRINGAE PV. TOMATO                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS SYRINGAE PV. TOMATO;                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DC3000;                                                      
SOURCE   5 GENE: PSPTO5518;                                                     
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    NYSGX, TARGET 10412I, NOVEL FOLD, STRUCTURAL GENOMICS, PSI-           
KEYWDS   2 2, PROTEIN STRUCTURE INITIATIVE, NEW YORK STRUCTURAL                 
KEYWDS   3 GENOMIX RESEARCH CONSORTIUM, NYSGXRC                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.A.FEDOROV,U.RAMAGOPAL,R.TORO,E.V.FEDOROV,J.M.SAUDER,                
AUTHOR   2 S.K.BURLEY,S.C.ALMO,NEW YORK STRUCTURAL GENOMIX RESEARCH             
AUTHOR   3 CONSORTIUM (NYSGXRC)                                                 
REVDAT   1   03-APR-07 2PAG    0                                                
JRNL        AUTH   A.A.FEDOROV,U.RAMAGOPAL,R.TORO,E.V.FEDOROV,                  
JRNL        AUTH 2 J.M.SAUDER,S.K.BURLEY,S.C.ALMO                               
JRNL        TITL   CRYSTAL STRUCTURE OF CONSERVED HYPOTHETICAL                  
JRNL        TITL 2 PROTEIN FROM PSEUDOMONAS SYRINGAE PV. TOMATO.                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2PAG A    2   135  UNP    Q87TZ9   Q87TZ9_PSESM     2    135             
SEQRES   1 A  135  LEU GLU GLU VAL ILE GLU GLN LEU ARG GLU ALA ASN GLU          
SEQRES   2 A  135  PRO VAL PRO VAL PRO LEU GLU LEU PRO ASP GLU ASP GLN          
SEQRES   3 A  135  LEU VAL GLU ILE GLU GLU GLN LEU PHE ILE ASN ILE PRO          
SEQRES   4 A  135  PHE VAL PHE LYS GLU PHE LEU LEU THR VAL SER ASP VAL          
SEQRES   5 A  135  VAL TYR GLY SER LEU GLU PRO VAL THR VAL THR ASP PRO          
SEQRES   6 A  135  GLN SER HIS THR TYR LEU PRO GLU VAL CYS ALA THR ALA          
SEQRES   7 A  135  TRP ASP LEU GLY VAL PRO ARG GLU LEU ILE PRO ILE CYS          
SEQRES   8 A  135  GLN ASP GLY GLU ASP TYR TYR CYS VAL GLU GLU ASP GLY          
SEQRES   9 A  135  THR VAL LEU LEU TRP SER ALA GLU GLU GLU LEU VAL THR          
SEQRES  10 A  135  GLU GLU SER TRP GLU SER VAL TRP HIS TRP ALA ARG ASP          
SEQRES  11 A  135  VAL TRP LEU GLU SER                                          
HET     CA    201       1                                                       
HET     CA    202       1                                                       
HETNAM      CA CALCIUM ION                                                      
FORMUL   2   CA    2(CA 2+)                                                     
FORMUL   4  HOH   *133(H2 O)                                                    
CRYST1   47.424   47.424  122.518  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   LEU A   1      44.878  24.969  14.251  1.00 21.96           N  
ATOM      2  CA  LEU A   1      44.484  26.176  15.032  1.00 20.25           C  
ATOM      3  C   LEU A   1      44.964  26.066  16.471  1.00 21.36           C  
ATOM      4  O   LEU A   1      45.599  26.981  16.995  1.00 18.04           O  
ATOM      5  CB  LEU A   1      42.960  26.353  15.018  1.00 21.28           C  
ATOM      6  CG  LEU A   1      42.396  27.441  15.936  1.00 19.95           C  
ATOM      7  CD1 LEU A   1      42.973  28.790  15.550  1.00 21.39           C  
ATOM      8  CD2 LEU A   1      40.879  27.467  15.838  1.00 21.23           C  
ATOM      9  N   GLU A   2      44.657  24.943  17.110  1.00 21.68           N  
ATOM     10  CA  GLU A   2      45.065  24.736  18.492  1.00 22.51           C  
ATOM     11  C   GLU A   2      46.586  24.865  18.554  1.00 21.03           C  
ATOM     12  O   GLU A   2      47.142  25.448  19.489  1.00 19.63           O  
ATOM     13  CB  GLU A   2      44.627  23.347  18.957  1.00 27.04           C  
ATOM     14  CG  GLU A   2      44.680  23.144  20.461  1.00 33.12           C  
ATOM     15  CD  GLU A   2      44.240  21.748  20.875  1.00 36.38           C  
ATOM     16  OE1 GLU A   2      43.162  21.303  20.420  1.00 36.89           O  
ATOM     17  OE2 GLU A   2      44.970  21.102  21.660  1.00 38.49           O  
ATOM     18  N   GLU A   3      47.242  24.328  17.534  1.00 20.38           N  
ATOM     19  CA  GLU A   3      48.698  24.362  17.412  1.00 21.55           C  
ATOM     20  C   GLU A   3      49.268  25.774  17.452  1.00 20.03           C  
ATOM     21  O   GLU A   3      50.150  26.082  18.255  1.00 18.17           O  
ATOM     22  CB  GLU A   3      49.121  23.715  16.092  1.00 24.67           C  
ATOM     23  CG  GLU A   3      48.909  22.218  16.011  1.00 31.44           C  
ATOM     24  CD  GLU A   3      50.006  21.450  16.708  1.00 34.16           C  
ATOM     25  OE1 GLU A   3      50.100  21.538  17.951  1.00 36.92           O  
ATOM     26  OE2 GLU A   3      50.782  20.766  16.005  1.00 33.28           O  
ATOM     27  N   VAL A   4      48.781  26.622  16.550  1.00 17.61           N  
ATOM     28  CA  VAL A   4      49.254  27.996  16.453  1.00 17.03           C  
ATOM     29  C   VAL A   4      48.973  28.785  17.728  1.00 15.95           C  
ATOM     30  O   VAL A   4      49.828  29.537  18.203  1.00 15.13           O  
ATOM     31  CB  VAL A   4      48.612  28.705  15.236  1.00 16.35           C  
ATOM     32  CG1 VAL A   4      49.153  30.120  15.099  1.00 19.30           C  
ATOM     33  CG2 VAL A   4      48.898  27.906  13.973  1.00 19.66           C  
ATOM     34  N   ILE A   5      47.784  28.603  18.297  1.00 14.57           N  
ATOM     35  CA  ILE A   5      47.439  29.320  19.516  1.00 14.04           C  
ATOM     36  C   ILE A   5      48.424  28.936  20.614  1.00 15.56           C  
ATOM     37  O   ILE A   5      48.973  29.805  21.294  1.00 15.83           O  
ATOM     38  CB  ILE A   5      45.992  29.016  19.970  1.00 14.87           C  
ATOM     39  CG1 ILE A   5      45.008  29.626  18.966  1.00 16.26           C  
ATOM     40  CG2 ILE A   5      45.755  29.580  21.372  1.00 14.07           C  
ATOM     41  CD1 ILE A   5      43.562  29.326  19.260  1.00 16.66           C  
ATOM     42  N   GLU A   6      48.667  27.637  20.767  1.00 14.65           N  
ATOM     43  CA  GLU A   6      49.610  27.158  21.781  1.00 15.12           C  
ATOM     44  C   GLU A   6      50.997  27.763  21.577  1.00 16.27           C  
ATOM     45  O   GLU A   6      51.642  28.194  22.537  1.00 16.49           O  
ATOM     46  CB  GLU A   6      49.704  25.623  21.740  1.00 13.47           C  
ATOM     47  CG  GLU A   6      50.842  25.021  22.584  1.00 15.24           C  
ATOM     48  CD  GLU A   6      50.927  23.494  22.485  1.00 16.77           C  
ATOM     49  OE1 GLU A   6      50.570  22.928  21.431  1.00 18.95           O  
ATOM     50  OE2 GLU A   6      51.367  22.856  23.459  1.00 13.65           O  
ATOM     51  N   GLN A   7      51.445  27.801  20.324  1.00 16.45           N  
ATOM     52  CA  GLN A   7      52.752  28.344  19.989  1.00 17.24           C  
ATOM     53  C   GLN A   7      52.871  29.789  20.467  1.00 15.89           C  
ATOM     54  O   GLN A   7      53.869  30.174  21.073  1.00 17.17           O  
ATOM     55  CB  GLN A   7      52.972  28.280  18.475  1.00 19.59           C  
ATOM     56  CG  GLN A   7      54.425  28.404  18.048  1.00 24.75           C  
ATOM     57  CD  GLN A   7      54.588  28.432  16.537  1.00 29.43           C  
ATOM     58  OE1 GLN A   7      53.894  27.714  15.814  1.00 31.45           O  
ATOM     59  NE2 GLN A   7      55.513  29.256  16.056  1.00 30.57           N  
ATOM     60  N   LEU A   8      51.852  30.593  20.193  1.00 15.74           N  
ATOM     61  CA  LEU A   8      51.876  31.988  20.614  1.00 14.79           C  
ATOM     62  C   LEU A   8      51.816  32.137  22.130  1.00 15.78           C  
ATOM     63  O   LEU A   8      52.605  32.880  22.721  1.00 15.60           O  
ATOM     64  CB  LEU A   8      50.713  32.757  19.980  1.00 16.02           C  
ATOM     65  CG  LEU A   8      50.915  33.273  18.557  1.00 17.99           C  
ATOM     66  CD1 LEU A   8      49.593  33.809  18.033  1.00 18.85           C  
ATOM     67  CD2 LEU A   8      51.989  34.358  18.549  1.00 18.85           C  
ATOM     68  N   ARG A   9      50.889  31.420  22.757  1.00 14.72           N  
ATOM     69  CA  ARG A   9      50.718  31.497  24.203  1.00 16.44           C  
ATOM     70  C   ARG A   9      51.987  31.118  24.952  1.00 15.55           C  
ATOM     71  O   ARG A   9      52.372  31.786  25.908  1.00 16.53           O  
ATOM     72  CB  ARG A   9      49.583  30.576  24.654  1.00 19.37           C  
ATOM     73  CG  ARG A   9      48.253  30.811  23.960  1.00 24.73           C  
ATOM     74  CD  ARG A   9      47.668  32.151  24.301  1.00 28.93           C  
ATOM     75  NE  ARG A   9      47.618  32.388  25.742  1.00 31.03           N  
ATOM     76  CZ  ARG A   9      46.910  33.363  26.304  1.00 31.37           C  
ATOM     77  NH1 ARG A   9      46.189  34.177  25.544  1.00 30.93           N  
ATOM     78  NH2 ARG A   9      46.940  33.542  27.619  1.00 30.76           N  
ATOM     79  N   GLU A  10      52.635  30.045  24.516  1.00 14.90           N  
ATOM     80  CA  GLU A  10      53.848  29.584  25.176  1.00 16.75           C  
ATOM     81  C   GLU A  10      55.077  30.437  24.854  1.00 17.56           C  
ATOM     82  O   GLU A  10      56.081  30.387  25.572  1.00 22.50           O  
ATOM     83  CB  GLU A  10      54.079  28.105  24.831  1.00 15.15           C  
ATOM     84  CG  GLU A  10      53.003  27.208  25.437  1.00 15.44           C  
ATOM     85  CD  GLU A  10      53.219  25.718  25.206  1.00 14.76           C  
ATOM     86  OE1 GLU A  10      54.290  25.322  24.702  1.00 16.58           O  
ATOM     87  OE2 GLU A  10      52.295  24.944  25.544  1.00 11.64           O  
ATOM     88  N   ALA A  11      54.994  31.236  23.793  1.00 18.30           N  
ATOM     89  CA  ALA A  11      56.113  32.094  23.418  1.00 18.54           C  
ATOM     90  C   ALA A  11      55.958  33.479  24.031  1.00 18.50           C  
ATOM     91  O   ALA A  11      56.854  34.323  23.907  1.00 17.92           O  
ATOM     92  CB  ALA A  11      56.206  32.208  21.901  1.00 18.52           C  
ATOM     93  N   ASN A  12      54.823  33.705  24.694  1.00 17.75           N  
ATOM     94  CA  ASN A  12      54.535  34.997  25.316  1.00 17.90           C  
ATOM     95  C   ASN A  12      55.681  35.507  26.173  1.00 18.71           C  
ATOM     96  O   ASN A  12      56.183  34.796  27.047  1.00 17.63           O  
ATOM     97  CB  ASN A  12      53.278  34.926  26.183  1.00 17.96           C  
ATOM     98  CG  ASN A  12      52.978  36.249  26.863  1.00 20.29           C  
ATOM     99  OD1 ASN A  12      52.679  37.240  26.201  1.00 15.57           O  
ATOM    100  ND2 ASN A  12      53.076  36.274  28.192  1.00 22.20           N  
ATOM    101  N   GLU A  13      56.073  36.753  25.933  1.00 17.09           N  
ATOM    102  CA  GLU A  13      57.174  37.361  26.668  1.00 18.49           C  
ATOM    103  C   GLU A  13      56.697  38.188  27.856  1.00 19.40           C  
ATOM    104  O   GLU A  13      55.769  38.994  27.745  1.00 20.11           O  
ATOM    105  CB  GLU A  13      57.989  38.242  25.723  1.00 17.59           C  
ATOM    106  CG  GLU A  13      58.408  37.549  24.438  1.00 19.71           C  
ATOM    107  CD  GLU A  13      59.053  38.503  23.453  1.00 20.05           C  
ATOM    108  OE1 GLU A  13      58.869  39.730  23.609  1.00 22.85           O  
ATOM    109  OE2 GLU A  13      59.729  38.033  22.517  1.00 21.93           O  
ATOM    110  N   PRO A  14      57.336  38.009  29.018  1.00 19.66           N  
ATOM    111  CA  PRO A  14      56.924  38.775  30.191  1.00 20.66           C  
ATOM    112  C   PRO A  14      57.149  40.272  30.024  1.00 20.61           C  
ATOM    113  O   PRO A  14      58.131  40.702  29.410  1.00 20.21           O  
ATOM    114  CB  PRO A  14      57.776  38.177  31.311  1.00 22.82           C  
ATOM    115  CG  PRO A  14      59.006  37.715  30.597  1.00 22.58           C  
ATOM    116  CD  PRO A  14      58.438  37.087  29.349  1.00 20.92           C  
ATOM    117  N   VAL A  15      56.215  41.055  30.558  1.00 20.54           N  
ATOM    118  CA  VAL A  15      56.287  42.513  30.520  1.00 20.95           C  
ATOM    119  C   VAL A  15      55.858  43.017  31.896  1.00 21.41           C  
ATOM    120  O   VAL A  15      55.265  42.269  32.675  1.00 21.49           O  
ATOM    121  CB  VAL A  15      55.358  43.116  29.431  1.00 20.36           C  
ATOM    122  CG1 VAL A  15      55.895  42.781  28.047  1.00 18.43           C  
ATOM    123  CG2 VAL A  15      53.941  42.600  29.597  1.00 19.26           C  
ATOM    124  N   PRO A  16      56.161  44.286  32.221  1.00 21.85           N  
ATOM    125  CA  PRO A  16      55.793  44.854  33.524  1.00 22.88           C  
ATOM    126  C   PRO A  16      54.308  44.725  33.842  1.00 22.62           C  
ATOM    127  O   PRO A  16      53.932  44.228  34.905  1.00 23.50           O  
ATOM    128  CB  PRO A  16      56.234  46.311  33.399  1.00 23.13           C  
ATOM    129  CG  PRO A  16      57.415  46.217  32.485  1.00 22.60           C  
ATOM    130  CD  PRO A  16      56.902  45.275  31.417  1.00 23.46           C  
ATOM    131  N   VAL A  17      53.471  45.185  32.916  1.00 21.68           N  
ATOM    132  CA  VAL A  17      52.029  45.120  33.084  1.00 21.75           C  
ATOM    133  C   VAL A  17      51.473  44.198  32.009  1.00 20.19           C  
ATOM    134  O   VAL A  17      51.394  44.573  30.842  1.00 20.70           O  
ATOM    135  CB  VAL A  17      51.374  46.509  32.930  1.00 21.85           C  
ATOM    136  CG1 VAL A  17      49.877  46.402  33.147  1.00 23.85           C  
ATOM    137  CG2 VAL A  17      51.984  47.487  33.920  1.00 24.84           C  
ATOM    138  N   PRO A  18      51.105  42.967  32.389  1.00 20.10           N  
ATOM    139  CA  PRO A  18      50.557  42.001  31.435  1.00 19.17           C  
ATOM    140  C   PRO A  18      49.339  42.540  30.692  1.00 17.35           C  
ATOM    141  O   PRO A  18      48.526  43.285  31.251  1.00 17.09           O  
ATOM    142  CB  PRO A  18      50.207  40.809  32.325  1.00 21.36           C  
ATOM    143  CG  PRO A  18      51.262  40.881  33.389  1.00 21.67           C  
ATOM    144  CD  PRO A  18      51.268  42.354  33.717  1.00 21.11           C  
ATOM    145  N   LEU A  19      49.219  42.167  29.423  1.00 16.00           N  
ATOM    146  CA  LEU A  19      48.083  42.594  28.620  1.00 16.43           C  
ATOM    147  C   LEU A  19      46.872  41.745  29.001  1.00 16.42           C  
ATOM    148  O   LEU A  19      47.019  40.594  29.429  1.00 19.58           O  
ATOM    149  CB  LEU A  19      48.384  42.400  27.138  1.00 13.91           C  
ATOM    150  CG  LEU A  19      49.601  43.108  26.556  1.00 14.32           C  
ATOM    151  CD1 LEU A  19      49.676  42.805  25.065  1.00 16.17           C  
ATOM    152  CD2 LEU A  19      49.493  44.604  26.784  1.00 15.83           C  
ATOM    153  N   GLU A  20      45.680  42.311  28.839  1.00 16.66           N  
ATOM    154  CA  GLU A  20      44.451  41.601  29.164  1.00 18.99           C  
ATOM    155  C   GLU A  20      43.782  41.049  27.920  1.00 18.95           C  
ATOM    156  O   GLU A  20      43.866  41.640  26.845  1.00 18.42           O  
ATOM    157  CB  GLU A  20      43.478  42.528  29.890  1.00 20.66           C  
ATOM    158  CG  GLU A  20      44.018  43.086  31.195  1.00 25.72           C  
ATOM    159  CD  GLU A  20      42.998  43.928  31.932  1.00 29.26           C  
ATOM    160  OE1 GLU A  20      42.423  44.848  31.307  1.00 32.22           O  
ATOM    161  OE2 GLU A  20      42.775  43.675  33.138  1.00 33.02           O  
ATOM    162  N   LEU A  21      43.129  39.904  28.076  1.00 18.78           N  
ATOM    163  CA  LEU A  21      42.422  39.268  26.974  1.00 17.20           C  
ATOM    164  C   LEU A  21      40.964  39.725  27.078  1.00 16.79           C  
ATOM    165  O   LEU A  21      40.371  39.688  28.155  1.00 15.97           O  
ATOM    166  CB  LEU A  21      42.523  37.744  27.110  1.00 18.79           C  
ATOM    167  CG  LEU A  21      42.129  36.891  25.908  1.00 19.55           C  
ATOM    168  CD1 LEU A  21      43.060  37.200  24.737  1.00 19.30           C  
ATOM    169  CD2 LEU A  21      42.209  35.416  26.284  1.00 19.75           C  
ATOM    170  N   PRO A  22      40.371  40.173  25.960  1.00 14.29           N  
ATOM    171  CA  PRO A  22      38.981  40.633  25.972  1.00 15.47           C  
ATOM    172  C   PRO A  22      37.965  39.501  25.956  1.00 15.74           C  
ATOM    173  O   PRO A  22      38.296  38.361  25.641  1.00 15.24           O  
ATOM    174  CB  PRO A  22      38.892  41.462  24.698  1.00 14.91           C  
ATOM    175  CG  PRO A  22      39.741  40.647  23.752  1.00 14.24           C  
ATOM    176  CD  PRO A  22      40.960  40.315  24.614  1.00 15.40           C  
ATOM    177  N   ASP A  23      36.730  39.826  26.323  1.00 18.17           N  
ATOM    178  CA  ASP A  23      35.650  38.854  26.280  1.00 19.61           C  
ATOM    179  C   ASP A  23      34.774  39.281  25.111  1.00 20.75           C  
ATOM    180  O   ASP A  23      34.975  40.354  24.532  1.00 19.44           O  
ATOM    181  CB  ASP A  23      34.841  38.844  27.582  1.00 23.01           C  
ATOM    182  CG  ASP A  23      34.413  40.225  28.023  1.00 25.69           C  
ATOM    183  OD1 ASP A  23      33.894  40.996  27.188  1.00 25.06           O  
ATOM    184  OD2 ASP A  23      34.585  40.534  29.224  1.00 31.41           O  
ATOM    185  N   GLU A  24      33.804  38.453  24.759  1.00 20.99           N  
ATOM    186  CA  GLU A  24      32.938  38.763  23.637  1.00 22.07           C  
ATOM    187  C   GLU A  24      32.223  40.110  23.734  1.00 20.83           C  
ATOM    188  O   GLU A  24      32.096  40.808  22.728  1.00 19.22           O  
ATOM    189  CB  GLU A  24      31.946  37.618  23.428  1.00 25.05           C  
ATOM    190  CG  GLU A  24      32.637  36.346  22.956  1.00 30.25           C  
ATOM    191  CD  GLU A  24      31.682  35.201  22.713  1.00 34.68           C  
ATOM    192  OE1 GLU A  24      31.101  34.692  23.697  1.00 36.28           O  
ATOM    193  OE2 GLU A  24      31.512  34.814  21.538  1.00 36.77           O  
ATOM    194  N   ASP A  25      31.780  40.492  24.930  1.00 21.28           N  
ATOM    195  CA  ASP A  25      31.093  41.771  25.102  1.00 22.15           C  
ATOM    196  C   ASP A  25      32.000  42.946  24.753  1.00 20.81           C  
ATOM    197  O   ASP A  25      31.554  43.931  24.160  1.00 20.94           O  
ATOM    198  CB  ASP A  25      30.594  41.934  26.540  1.00 24.38           C  
ATOM    199  CG  ASP A  25      29.502  40.948  26.895  1.00 27.27           C  
ATOM    200  OD1 ASP A  25      28.456  40.943  26.212  1.00 28.51           O  
ATOM    201  OD2 ASP A  25      29.691  40.176  27.861  1.00 31.49           O  
ATOM    202  N   GLN A  26      33.271  42.846  25.130  1.00 20.47           N  
ATOM    203  CA  GLN A  26      34.221  43.910  24.837  1.00 19.53           C  
ATOM    204  C   GLN A  26      34.412  44.044  23.331  1.00 19.09           C  
ATOM    205  O   GLN A  26      34.526  45.155  22.816  1.00 19.95           O  
ATOM    206  CB  GLN A  26      35.560  43.644  25.540  1.00 20.46           C  
ATOM    207  CG  GLN A  26      35.532  43.979  27.031  1.00 21.48           C  
ATOM    208  CD  GLN A  26      36.799  43.576  27.766  1.00 22.68           C  
ATOM    209  OE1 GLN A  26      37.131  42.393  27.855  1.00 23.87           O  
ATOM    210  NE2 GLN A  26      37.512  44.561  28.308  1.00 24.28           N  
ATOM    211  N   LEU A  27      34.443  42.921  22.618  1.00 18.83           N  
ATOM    212  CA  LEU A  27      34.602  42.986  21.170  1.00 18.36           C  
ATOM    213  C   LEU A  27      33.374  43.618  20.524  1.00 19.49           C  
ATOM    214  O   LEU A  27      33.496  44.385  19.569  1.00 18.89           O  
ATOM    215  CB  LEU A  27      34.857  41.601  20.580  1.00 21.53           C  
ATOM    216  CG  LEU A  27      36.321  41.157  20.661  1.00 23.78           C  
ATOM    217  CD1 LEU A  27      36.739  40.984  22.104  1.00 27.30           C  
ATOM    218  CD2 LEU A  27      36.497  39.859  19.901  1.00 25.80           C  
ATOM    219  N   VAL A  28      32.189  43.301  21.039  1.00 18.31           N  
ATOM    220  CA  VAL A  28      30.978  43.894  20.484  1.00 17.64           C  
ATOM    221  C   VAL A  28      31.058  45.411  20.647  1.00 18.46           C  
ATOM    222  O   VAL A  28      30.710  46.153  19.730  1.00 18.66           O  
ATOM    223  CB  VAL A  28      29.701  43.358  21.176  1.00 19.22           C  
ATOM    224  CG1 VAL A  28      28.489  44.191  20.762  1.00 20.14           C  
ATOM    225  CG2 VAL A  28      29.476  41.905  20.784  1.00 18.04           C  
ATOM    226  N   GLU A  29      31.532  45.875  21.804  1.00 17.71           N  
ATOM    227  CA  GLU A  29      31.658  47.317  22.044  1.00 19.01           C  
ATOM    228  C   GLU A  29      32.552  47.979  20.999  1.00 18.41           C  
ATOM    229  O   GLU A  29      32.226  49.049  20.477  1.00 17.05           O  
ATOM    230  CB  GLU A  29      32.246  47.603  23.432  1.00 24.46           C  
ATOM    231  CG  GLU A  29      31.340  47.267  24.602  1.00 30.76           C  
ATOM    232  CD  GLU A  29      31.875  47.819  25.915  1.00 34.56           C  
ATOM    233  OE1 GLU A  29      33.041  47.525  26.260  1.00 36.05           O  
ATOM    234  OE2 GLU A  29      31.128  48.547  26.605  1.00 37.28           O  
ATOM    235  N   ILE A  30      33.684  47.349  20.703  1.00 16.43           N  
ATOM    236  CA  ILE A  30      34.612  47.886  19.713  1.00 15.43           C  
ATOM    237  C   ILE A  30      33.959  47.936  18.330  1.00 15.54           C  
ATOM    238  O   ILE A  30      34.079  48.931  17.613  1.00 14.53           O  
ATOM    239  CB  ILE A  30      35.890  47.030  19.623  1.00 16.11           C  
ATOM    240  CG1 ILE A  30      36.636  47.063  20.957  1.00 17.88           C  
ATOM    241  CG2 ILE A  30      36.776  47.524  18.484  1.00 16.35           C  
ATOM    242  CD1 ILE A  30      37.168  48.433  21.346  1.00 16.87           C  
ATOM    243  N   GLU A  31      33.271  46.864  17.956  1.00 14.77           N  
ATOM    244  CA  GLU A  31      32.605  46.819  16.657  1.00 16.45           C  
ATOM    245  C   GLU A  31      31.628  47.979  16.531  1.00 16.81           C  
ATOM    246  O   GLU A  31      31.608  48.688  15.526  1.00 18.86           O  
ATOM    247  CB  GLU A  31      31.833  45.511  16.486  1.00 18.62           C  
ATOM    248  CG  GLU A  31      32.707  44.283  16.382  1.00 20.09           C  
ATOM    249  CD  GLU A  31      31.911  43.032  16.083  1.00 22.72           C  
ATOM    250  OE1 GLU A  31      31.066  42.646  16.922  1.00 23.42           O  
ATOM    251  OE2 GLU A  31      32.130  42.433  15.007  1.00 22.62           O  
ATOM    252  N   GLU A  32      30.814  48.168  17.559  1.00 16.31           N  
ATOM    253  CA  GLU A  32      29.828  49.238  17.538  1.00 17.94           C  
ATOM    254  C   GLU A  32      30.475  50.614  17.464  1.00 15.87           C  
ATOM    255  O   GLU A  32      29.985  51.497  16.761  1.00 15.15           O  
ATOM    256  CB  GLU A  32      28.925  49.129  18.765  1.00 19.94           C  
ATOM    257  CG  GLU A  32      28.239  47.777  18.868  1.00 23.28           C  
ATOM    258  CD  GLU A  32      27.327  47.673  20.073  1.00 28.19           C  
ATOM    259  OE1 GLU A  32      27.756  48.069  21.180  1.00 29.19           O  
ATOM    260  OE2 GLU A  32      26.187  47.184  19.914  1.00 30.99           O  
ATOM    261  N   GLN A  33      31.576  50.799  18.185  1.00 16.13           N  
ATOM    262  CA  GLN A  33      32.287  52.074  18.179  1.00 18.55           C  
ATOM    263  C   GLN A  33      32.798  52.439  16.797  1.00 18.83           C  
ATOM    264  O   GLN A  33      32.832  53.617  16.428  1.00 20.39           O  
ATOM    265  CB  GLN A  33      33.495  52.019  19.100  1.00 19.20           C  
ATOM    266  CG  GLN A  33      33.208  52.095  20.560  1.00 24.12           C  
ATOM    267  CD  GLN A  33      34.483  51.947  21.356  1.00 24.76           C  
ATOM    268  OE1 GLN A  33      35.467  52.663  21.124  1.00 25.42           O  
ATOM    269  NE2 GLN A  33      34.482  51.013  22.297  1.00 26.93           N  
ATOM    270  N   LEU A  34      33.222  51.426  16.045  1.00 17.46           N  
ATOM    271  CA  LEU A  34      33.762  51.641  14.707  1.00 17.61           C  
ATOM    272  C   LEU A  34      32.725  51.402  13.618  1.00 17.77           C  
ATOM    273  O   LEU A  34      33.001  51.574  12.429  1.00 16.22           O  
ATOM    274  CB  LEU A  34      34.969  50.727  14.496  1.00 19.21           C  
ATOM    275  CG  LEU A  34      36.171  51.041  15.392  1.00 19.39           C  
ATOM    276  CD1 LEU A  34      37.115  49.854  15.420  1.00 20.96           C  
ATOM    277  CD2 LEU A  34      36.887  52.278  14.879  1.00 20.31           C  
ATOM    278  N   PHE A  35      31.527  51.009  14.041  1.00 17.05           N  
ATOM    279  CA  PHE A  35      30.421  50.719  13.137  1.00 18.60           C  
ATOM    280  C   PHE A  35      30.873  49.772  12.036  1.00 20.39           C  
ATOM    281  O   PHE A  35      30.664  50.019  10.849  1.00 20.73           O  
ATOM    282  CB  PHE A  35      29.859  52.000  12.517  1.00 16.44           C  
ATOM    283  CG  PHE A  35      28.381  51.924  12.239  1.00 16.74           C  
ATOM    284  CD1 PHE A  35      27.467  51.938  13.289  1.00 16.89           C  
ATOM    285  CD2 PHE A  35      27.904  51.789  10.940  1.00 18.09           C  
ATOM    286  CE1 PHE A  35      26.101  51.813  13.053  1.00 17.29           C  
ATOM    287  CE2 PHE A  35      26.537  51.663  10.689  1.00 19.57           C  
ATOM    288  CZ  PHE A  35      25.629  51.675  11.746  1.00 17.35           C  
ATOM    289  N   ILE A  36      31.499  48.679  12.449  1.00 21.72           N  
ATOM    290  CA  ILE A  36      31.996  47.688  11.514  1.00 23.56           C  
ATOM    291  C   ILE A  36      31.802  46.314  12.132  1.00 24.42           C  
ATOM    292  O   ILE A  36      31.568  46.184  13.334  1.00 24.66           O  
ATOM    293  CB  ILE A  36      33.501  47.905  11.235  1.00 26.39           C  
ATOM    294  CG1 ILE A  36      33.945  47.059  10.038  1.00 28.38           C  
ATOM    295  CG2 ILE A  36      34.311  47.529  12.468  1.00 26.81           C  
ATOM    296  CD1 ILE A  36      33.313  47.467   8.727  1.00 29.64           C  
ATOM    297  N   ASN A  37      31.881  45.286  11.301  1.00 23.31           N  
ATOM    298  CA  ASN A  37      31.743  43.926  11.785  1.00 23.37           C  
ATOM    299  C   ASN A  37      33.138  43.331  11.676  1.00 21.35           C  
ATOM    300  O   ASN A  37      33.727  43.332  10.596  1.00 21.35           O  
ATOM    301  CB  ASN A  37      30.759  43.152  10.905  1.00 28.20           C  
ATOM    302  CG  ASN A  37      30.357  41.821  11.506  1.00 31.82           C  
ATOM    303  OD1 ASN A  37      31.167  40.899  11.608  1.00 33.66           O  
ATOM    304  ND2 ASN A  37      29.099  41.718  11.918  1.00 35.30           N  
ATOM    305  N   ILE A  38      33.685  42.856  12.792  1.00 16.62           N  
ATOM    306  CA  ILE A  38      35.016  42.251  12.768  1.00 16.52           C  
ATOM    307  C   ILE A  38      34.869  40.825  12.245  1.00 15.87           C  
ATOM    308  O   ILE A  38      34.064  40.055  12.765  1.00 15.60           O  
ATOM    309  CB  ILE A  38      35.646  42.210  14.179  1.00 15.60           C  
ATOM    310  CG1 ILE A  38      35.819  43.633  14.710  1.00 17.32           C  
ATOM    311  CG2 ILE A  38      36.993  41.488  14.128  1.00 16.02           C  
ATOM    312  CD1 ILE A  38      36.235  43.702  16.158  1.00 19.07           C  
ATOM    313  N   PRO A  39      35.633  40.461  11.196  1.00 15.58           N  
ATOM    314  CA  PRO A  39      35.557  39.111  10.624  1.00 15.75           C  
ATOM    315  C   PRO A  39      35.702  38.059  11.723  1.00 14.85           C  
ATOM    316  O   PRO A  39      36.464  38.259  12.668  1.00 13.64           O  
ATOM    317  CB  PRO A  39      36.725  39.096   9.636  1.00 17.42           C  
ATOM    318  CG  PRO A  39      36.794  40.517   9.182  1.00 18.96           C  
ATOM    319  CD  PRO A  39      36.641  41.271  10.491  1.00 16.62           C  
ATOM    320  N   PHE A  40      34.977  36.948  11.594  1.00 13.87           N  
ATOM    321  CA  PHE A  40      35.007  35.881  12.595  1.00 13.71           C  
ATOM    322  C   PHE A  40      36.385  35.415  13.039  1.00 13.65           C  
ATOM    323  O   PHE A  40      36.671  35.403  14.232  1.00 13.57           O  
ATOM    324  CB  PHE A  40      34.224  34.641  12.130  1.00 15.27           C  
ATOM    325  CG  PHE A  40      34.196  33.532  13.163  1.00 15.63           C  
ATOM    326  CD1 PHE A  40      33.208  33.501  14.144  1.00 17.39           C  
ATOM    327  CD2 PHE A  40      35.219  32.588  13.222  1.00 17.14           C  
ATOM    328  CE1 PHE A  40      33.243  32.556  15.169  1.00 18.45           C  
ATOM    329  CE2 PHE A  40      35.264  31.637  14.247  1.00 17.08           C  
ATOM    330  CZ  PHE A  40      34.273  31.625  15.222  1.00 17.38           C  
ATOM    331  N   VAL A  41      37.239  35.008  12.100  1.00 13.50           N  
ATOM    332  CA  VAL A  41      38.558  34.519  12.488  1.00 12.49           C  
ATOM    333  C   VAL A  41      39.387  35.601  13.173  1.00 13.52           C  
ATOM    334  O   VAL A  41      40.118  35.315  14.112  1.00 11.56           O  
ATOM    335  CB  VAL A  41      39.319  33.911  11.290  1.00 13.95           C  
ATOM    336  CG1 VAL A  41      40.685  33.416  11.728  1.00 13.41           C  
ATOM    337  CG2 VAL A  41      38.527  32.737  10.727  1.00 15.15           C  
ATOM    338  N   PHE A  42      39.263  36.844  12.712  1.00 12.81           N  
ATOM    339  CA  PHE A  42      39.967  37.963  13.334  1.00 11.76           C  
ATOM    340  C   PHE A  42      39.449  38.098  14.780  1.00 11.93           C  
ATOM    341  O   PHE A  42      40.225  38.300  15.714  1.00 11.96           O  
ATOM    342  CB  PHE A  42      39.687  39.237  12.520  1.00 12.72           C  
ATOM    343  CG  PHE A  42      40.511  40.437  12.918  1.00 14.66           C  
ATOM    344  CD1 PHE A  42      41.416  40.391  13.972  1.00 16.12           C  
ATOM    345  CD2 PHE A  42      40.364  41.629  12.215  1.00 15.54           C  
ATOM    346  CE1 PHE A  42      42.164  41.524  14.320  1.00 15.93           C  
ATOM    347  CE2 PHE A  42      41.097  42.758  12.548  1.00 14.75           C  
ATOM    348  CZ  PHE A  42      42.003  42.708  13.605  1.00 15.79           C  
ATOM    349  N   LYS A  43      38.137  37.967  14.962  1.00 12.99           N  
ATOM    350  CA  LYS A  43      37.547  38.059  16.294  1.00 13.35           C  
ATOM    351  C   LYS A  43      38.092  36.935  17.172  1.00 13.22           C  
ATOM    352  O   LYS A  43      38.354  37.128  18.357  1.00 12.59           O  
ATOM    353  CB  LYS A  43      36.027  37.960  16.184  1.00 16.61           C  
ATOM    354  CG  LYS A  43      35.282  38.237  17.466  1.00 23.63           C  
ATOM    355  CD  LYS A  43      33.841  38.642  17.173  1.00 25.53           C  
ATOM    356  CE  LYS A  43      33.108  37.579  16.361  1.00 30.44           C  
ATOM    357  NZ  LYS A  43      31.707  37.985  16.052  1.00 31.33           N  
ATOM    358  N   GLU A  44      38.255  35.757  16.579  1.00 12.59           N  
ATOM    359  CA  GLU A  44      38.784  34.599  17.288  1.00 12.91           C  
ATOM    360  C   GLU A  44      40.209  34.895  17.751  1.00 12.84           C  
ATOM    361  O   GLU A  44      40.591  34.573  18.873  1.00 12.07           O  
ATOM    362  CB  GLU A  44      38.758  33.385  16.361  1.00 10.90           C  
ATOM    363  CG  GLU A  44      39.231  32.097  16.983  1.00 14.13           C  
ATOM    364  CD  GLU A  44      39.047  30.942  16.034  1.00 17.47           C  
ATOM    365  OE1 GLU A  44      39.634  30.991  14.934  1.00 17.93           O  
ATOM    366  OE2 GLU A  44      38.306  29.997  16.384  1.00 19.65           O  
ATOM    367  N   PHE A  45      40.989  35.523  16.877  1.00 12.19           N  
ATOM    368  CA  PHE A  45      42.358  35.898  17.196  1.00 11.18           C  
ATOM    369  C   PHE A  45      42.342  36.848  18.405  1.00 10.69           C  
ATOM    370  O   PHE A  45      43.057  36.650  19.391  1.00  9.92           O  
ATOM    371  CB  PHE A  45      42.965  36.590  15.970  1.00 10.77           C  
ATOM    372  CG  PHE A  45      44.282  37.259  16.222  1.00 12.84           C  
ATOM    373  CD1 PHE A  45      45.478  36.579  15.998  1.00 11.85           C  
ATOM    374  CD2 PHE A  45      44.331  38.588  16.631  1.00 12.67           C  
ATOM    375  CE1 PHE A  45      46.705  37.215  16.171  1.00 14.28           C  
ATOM    376  CE2 PHE A  45      45.560  39.241  16.809  1.00 11.89           C  
ATOM    377  CZ  PHE A  45      46.747  38.549  16.577  1.00 12.37           C  
ATOM    378  N   LEU A  46      41.513  37.879  18.338  1.00 10.25           N  
ATOM    379  CA  LEU A  46      41.437  38.827  19.443  1.00 11.60           C  
ATOM    380  C   LEU A  46      41.013  38.173  20.762  1.00 12.62           C  
ATOM    381  O   LEU A  46      41.517  38.523  21.833  1.00 12.86           O  
ATOM    382  CB  LEU A  46      40.472  39.956  19.091  1.00 13.45           C  
ATOM    383  CG  LEU A  46      40.918  40.857  17.935  1.00 12.16           C  
ATOM    384  CD1 LEU A  46      39.810  41.840  17.600  1.00 16.17           C  
ATOM    385  CD2 LEU A  46      42.197  41.599  18.316  1.00 15.07           C  
ATOM    386  N   LEU A  47      40.101  37.211  20.685  1.00 11.53           N  
ATOM    387  CA  LEU A  47      39.606  36.543  21.887  1.00 11.94           C  
ATOM    388  C   LEU A  47      40.528  35.473  22.453  1.00 12.91           C  
ATOM    389  O   LEU A  47      40.332  35.028  23.586  1.00 14.52           O  
ATOM    390  CB  LEU A  47      38.234  35.920  21.605  1.00 13.18           C  
ATOM    391  CG  LEU A  47      37.085  36.889  21.329  1.00 14.29           C  
ATOM    392  CD1 LEU A  47      35.923  36.155  20.673  1.00 15.14           C  
ATOM    393  CD2 LEU A  47      36.650  37.549  22.636  1.00 16.44           C  
ATOM    394  N   THR A  48      41.537  35.071  21.685  1.00 12.48           N  
ATOM    395  CA  THR A  48      42.437  34.011  22.126  1.00 13.23           C  
ATOM    396  C   THR A  48      43.912  34.347  22.312  1.00 15.12           C  
ATOM    397  O   THR A  48      44.586  33.714  23.126  1.00 15.00           O  
ATOM    398  CB  THR A  48      42.362  32.814  21.164  1.00 16.47           C  
ATOM    399  OG1 THR A  48      42.820  33.206  19.862  1.00 16.61           O  
ATOM    400  CG2 THR A  48      40.943  32.336  21.049  1.00 15.02           C  
ATOM    401  N   VAL A  49      44.427  35.322  21.570  1.00 12.48           N  
ATOM    402  CA  VAL A  49      45.845  35.648  21.691  1.00 12.34           C  
ATOM    403  C   VAL A  49      46.230  37.128  21.739  1.00 12.06           C  
ATOM    404  O   VAL A  49      47.417  37.447  21.712  1.00 12.97           O  
ATOM    405  CB  VAL A  49      46.658  34.974  20.551  1.00 12.39           C  
ATOM    406  CG1 VAL A  49      46.490  33.464  20.619  1.00 12.35           C  
ATOM    407  CG2 VAL A  49      46.202  35.474  19.192  1.00 13.12           C  
ATOM    408  N   SER A  50      45.253  38.033  21.837  1.00 11.84           N  
ATOM    409  CA  SER A  50      45.597  39.455  21.854  1.00 11.70           C  
ATOM    410  C   SER A  50      46.258  39.937  23.147  1.00 12.82           C  
ATOM    411  O   SER A  50      46.546  41.131  23.292  1.00 14.79           O  
ATOM    412  CB  SER A  50      44.383  40.339  21.500  1.00 12.03           C  
ATOM    413  OG  SER A  50      43.360  40.326  22.480  1.00 12.12           O  
ATOM    414  N   ASP A  51      46.501  39.020  24.083  1.00 14.56           N  
ATOM    415  CA  ASP A  51      47.189  39.384  25.321  1.00 16.04           C  
ATOM    416  C   ASP A  51      48.649  38.943  25.212  1.00 16.59           C  
ATOM    417  O   ASP A  51      49.432  39.082  26.157  1.00 18.00           O  
ATOM    418  CB  ASP A  51      46.522  38.718  26.532  1.00 18.66           C  
ATOM    419  CG  ASP A  51      46.584  37.203  26.481  1.00 18.90           C  
ATOM    420  OD1 ASP A  51      46.542  36.639  25.369  1.00 18.78           O  
ATOM    421  OD2 ASP A  51      46.653  36.569  27.562  1.00 22.61           O  
ATOM    422  N   VAL A  52      49.015  38.430  24.044  1.00 13.18           N  
ATOM    423  CA  VAL A  52      50.368  37.951  23.801  1.00 13.68           C  
ATOM    424  C   VAL A  52      51.364  39.014  23.335  1.00 13.76           C  
ATOM    425  O   VAL A  52      51.048  39.900  22.519  1.00 14.27           O  
ATOM    426  CB  VAL A  52      50.358  36.784  22.770  1.00 13.81           C  
ATOM    427  CG1 VAL A  52      51.779  36.393  22.396  1.00 13.24           C  
ATOM    428  CG2 VAL A  52      49.620  35.587  23.359  1.00 14.64           C  
ATOM    429  N   VAL A  53      52.570  38.923  23.889  1.00 13.59           N  
ATOM    430  CA  VAL A  53      53.672  39.813  23.555  1.00 14.31           C  
ATOM    431  C   VAL A  53      54.748  38.918  22.948  1.00 14.49           C  
ATOM    432  O   VAL A  53      55.188  37.957  23.587  1.00 14.80           O  
ATOM    433  CB  VAL A  53      54.222  40.503  24.820  1.00 14.26           C  
ATOM    434  CG1 VAL A  53      55.379  41.414  24.458  1.00 14.53           C  
ATOM    435  CG2 VAL A  53      53.108  41.286  25.507  1.00 16.55           C  
ATOM    436  N   TYR A  54      55.150  39.208  21.711  1.00 14.02           N  
ATOM    437  CA  TYR A  54      56.172  38.405  21.043  1.00 14.35           C  
ATOM    438  C   TYR A  54      56.827  39.069  19.834  1.00 15.49           C  
ATOM    439  O   TYR A  54      56.172  39.767  19.056  1.00 15.81           O  
ATOM    440  CB  TYR A  54      55.595  37.072  20.562  1.00 16.78           C  
ATOM    441  CG  TYR A  54      56.628  36.236  19.838  1.00 19.08           C  
ATOM    442  CD1 TYR A  54      57.525  35.441  20.549  1.00 19.99           C  
ATOM    443  CD2 TYR A  54      56.765  36.306  18.452  1.00 19.20           C  
ATOM    444  CE1 TYR A  54      58.537  34.743  19.900  1.00 22.26           C  
ATOM    445  CE2 TYR A  54      57.775  35.613  17.793  1.00 22.35           C  
ATOM    446  CZ  TYR A  54      58.658  34.834  18.524  1.00 23.07           C  
ATOM    447  OH  TYR A  54      59.667  34.152  17.884  1.00 23.84           O  
ATOM    448  N   GLY A  55      58.123  38.821  19.685  1.00 17.67           N  
ATOM    449  CA  GLY A  55      58.865  39.334  18.548  1.00 16.63           C  
ATOM    450  C   GLY A  55      58.968  40.833  18.376  1.00 17.36           C  
ATOM    451  O   GLY A  55      59.010  41.585  19.352  1.00 18.51           O  
ATOM    452  N   SER A  56      59.005  41.259  17.115  1.00 19.23           N  
ATOM    453  CA  SER A  56      59.140  42.671  16.767  1.00 19.44           C  
ATOM    454  C   SER A  56      57.856  43.323  16.267  1.00 19.89           C  
ATOM    455  O   SER A  56      57.896  44.422  15.712  1.00 19.73           O  
ATOM    456  CB  SER A  56      60.224  42.844  15.698  1.00 20.18           C  
ATOM    457  OG  SER A  56      59.867  42.176  14.496  1.00 21.84           O  
ATOM    458  N   LEU A  57      56.727  42.643  16.440  1.00 17.26           N  
ATOM    459  CA  LEU A  57      55.437  43.180  16.012  1.00 15.32           C  
ATOM    460  C   LEU A  57      54.465  43.189  17.181  1.00 14.99           C  
ATOM    461  O   LEU A  57      54.450  42.269  17.993  1.00 14.95           O  
ATOM    462  CB  LEU A  57      54.855  42.344  14.868  1.00 13.18           C  
ATOM    463  CG  LEU A  57      55.569  42.449  13.515  1.00 12.42           C  
ATOM    464  CD1 LEU A  57      55.010  41.425  12.555  1.00 13.93           C  
ATOM    465  CD2 LEU A  57      55.403  43.845  12.951  1.00 15.28           C  
ATOM    466  N   GLU A  58      53.666  44.249  17.268  1.00 15.02           N  
ATOM    467  CA  GLU A  58      52.675  44.377  18.325  1.00 13.58           C  
ATOM    468  C   GLU A  58      51.307  44.526  17.669  1.00 14.88           C  
ATOM    469  O   GLU A  58      50.896  45.625  17.290  1.00 15.36           O  
ATOM    470  CB  GLU A  58      52.959  45.603  19.185  1.00 18.13           C  
ATOM    471  CG  GLU A  58      54.238  45.537  19.979  1.00 21.99           C  
ATOM    472  CD  GLU A  58      54.448  46.798  20.791  1.00 26.01           C  
ATOM    473  OE1 GLU A  58      54.814  47.828  20.194  1.00 28.60           O  
ATOM    474  OE2 GLU A  58      54.225  46.762  22.019  1.00 30.29           O  
ATOM    475  N   PRO A  59      50.580  43.413  17.523  1.00 13.13           N  
ATOM    476  CA  PRO A  59      49.261  43.481  16.899  1.00 12.79           C  
ATOM    477  C   PRO A  59      48.255  44.308  17.700  1.00 11.82           C  
ATOM    478  O   PRO A  59      48.489  44.667  18.859  1.00 11.39           O  
ATOM    479  CB  PRO A  59      48.851  42.010  16.793  1.00 13.80           C  
ATOM    480  CG  PRO A  59      50.164  41.276  16.804  1.00 12.67           C  
ATOM    481  CD  PRO A  59      50.929  42.024  17.849  1.00 12.13           C  
ATOM    482  N   VAL A  60      47.126  44.602  17.071  1.00 10.70           N  
ATOM    483  CA  VAL A  60      46.098  45.394  17.721  1.00 10.00           C  
ATOM    484  C   VAL A  60      45.471  44.709  18.929  1.00  9.87           C  
ATOM    485  O   VAL A  60      45.445  43.469  19.042  1.00 10.82           O  
ATOM    486  CB  VAL A  60      44.977  45.790  16.734  1.00  9.63           C  
ATOM    487  CG1 VAL A  60      45.553  46.638  15.603  1.00 13.28           C  
ATOM    488  CG2 VAL A  60      44.291  44.549  16.184  1.00 11.33           C  
ATOM    489  N   THR A  61      44.989  45.546  19.842  1.00 11.43           N  
ATOM    490  CA  THR A  61      44.352  45.105  21.074  1.00 11.58           C  
ATOM    491  C   THR A  61      43.069  45.907  21.283  1.00 11.96           C  
ATOM    492  O   THR A  61      42.834  46.906  20.605  1.00 12.15           O  
ATOM    493  CB  THR A  61      45.283  45.329  22.279  1.00 13.05           C  
ATOM    494  OG1 THR A  61      45.657  46.715  22.352  1.00 12.45           O  
ATOM    495  CG2 THR A  61      46.531  44.471  22.144  1.00 12.95           C  
ATOM    496  N   VAL A  62      42.239  45.475  22.225  1.00 13.26           N  
ATOM    497  CA  VAL A  62      40.994  46.187  22.475  1.00 13.91           C  
ATOM    498  C   VAL A  62      40.670  46.413  23.947  1.00 15.28           C  
ATOM    499  O   VAL A  62      39.603  46.937  24.264  1.00 17.72           O  
ATOM    500  CB  VAL A  62      39.792  45.437  21.849  1.00 14.52           C  
ATOM    501  CG1 VAL A  62      39.999  45.264  20.352  1.00 15.32           C  
ATOM    502  CG2 VAL A  62      39.613  44.082  22.525  1.00 15.14           C  
ATOM    503  N   THR A  63      41.590  46.052  24.838  1.00 16.63           N  
ATOM    504  CA  THR A  63      41.344  46.167  26.278  1.00 16.20           C  
ATOM    505  C   THR A  63      41.949  47.364  27.006  1.00 17.28           C  
ATOM    506  O   THR A  63      41.608  47.623  28.165  1.00 19.04           O  
ATOM    507  CB  THR A  63      41.804  44.888  27.009  1.00 17.04           C  
ATOM    508  OG1 THR A  63      43.214  44.714  26.817  1.00 17.27           O  
ATOM    509  CG2 THR A  63      41.063  43.661  26.466  1.00 15.82           C  
ATOM    510  N   ASP A  64      42.850  48.086  26.351  1.00 15.11           N  
ATOM    511  CA  ASP A  64      43.469  49.258  26.973  1.00 17.25           C  
ATOM    512  C   ASP A  64      43.365  50.474  26.051  1.00 17.92           C  
ATOM    513  O   ASP A  64      44.184  50.663  25.155  1.00 15.64           O  
ATOM    514  CB  ASP A  64      44.940  48.968  27.303  1.00 17.22           C  
ATOM    515  CG  ASP A  64      45.674  50.186  27.846  1.00 20.51           C  
ATOM    516  OD1 ASP A  64      45.006  51.181  28.195  1.00 18.91           O  
ATOM    517  OD2 ASP A  64      46.925  50.143  27.930  1.00 20.18           O  
ATOM    518  N   PRO A  65      42.349  51.322  26.265  1.00 19.76           N  
ATOM    519  CA  PRO A  65      42.162  52.515  25.433  1.00 20.27           C  
ATOM    520  C   PRO A  65      43.344  53.486  25.388  1.00 19.66           C  
ATOM    521  O   PRO A  65      43.385  54.376  24.536  1.00 21.07           O  
ATOM    522  CB  PRO A  65      40.897  53.153  26.017  1.00 24.14           C  
ATOM    523  CG  PRO A  65      40.892  52.669  27.446  1.00 28.21           C  
ATOM    524  CD  PRO A  65      41.308  51.233  27.304  1.00 23.15           C  
ATOM    525  N   GLN A  66      44.304  53.317  26.293  1.00 18.17           N  
ATOM    526  CA  GLN A  66      45.467  54.199  26.319  1.00 19.27           C  
ATOM    527  C   GLN A  66      46.656  53.609  25.575  1.00 17.20           C  
ATOM    528  O   GLN A  66      47.689  54.263  25.421  1.00 16.36           O  
ATOM    529  CB  GLN A  66      45.868  54.501  27.767  1.00 21.80           C  
ATOM    530  CG  GLN A  66      44.838  55.309  28.538  1.00 27.43           C  
ATOM    531  CD  GLN A  66      44.656  56.705  27.975  1.00 31.44           C  
ATOM    532  OE1 GLN A  66      44.245  56.878  26.825  1.00 34.61           O  
ATOM    533  NE2 GLN A  66      44.966  57.712  28.784  1.00 34.62           N  
ATOM    534  N   SER A  67      46.507  52.376  25.102  1.00 16.18           N  
ATOM    535  CA  SER A  67      47.574  51.700  24.377  1.00 15.74           C  
ATOM    536  C   SER A  67      47.746  52.180  22.937  1.00 14.89           C  
ATOM    537  O   SER A  67      46.769  52.550  22.278  1.00 15.43           O  
ATOM    538  CB  SER A  67      47.306  50.194  24.354  1.00 16.79           C  
ATOM    539  OG  SER A  67      48.177  49.543  23.446  1.00 18.50           O  
ATOM    540  N   HIS A  68      48.985  52.159  22.444  1.00 14.98           N  
ATOM    541  CA  HIS A  68      49.237  52.565  21.067  1.00 15.35           C  
ATOM    542  C   HIS A  68      48.755  51.509  20.075  1.00 14.52           C  
ATOM    543  O   HIS A  68      48.819  51.718  18.865  1.00 14.94           O  
ATOM    544  CB  HIS A  68      50.725  52.866  20.823  1.00 16.92           C  
ATOM    545  CG  HIS A  68      51.630  51.689  21.010  1.00 19.25           C  
ATOM    546  ND1 HIS A  68      51.995  51.221  22.253  1.00 19.18           N  
ATOM    547  CD2 HIS A  68      52.253  50.893  20.108  1.00 20.63           C  
ATOM    548  CE1 HIS A  68      52.805  50.187  22.110  1.00 23.42           C  
ATOM    549  NE2 HIS A  68      52.977  49.967  20.818  1.00 20.94           N  
ATOM    550  N   THR A  69      48.273  50.378  20.584  1.00 12.68           N  
ATOM    551  CA  THR A  69      47.755  49.333  19.711  1.00 12.78           C  
ATOM    552  C   THR A  69      46.234  49.229  19.814  1.00 12.58           C  
ATOM    553  O   THR A  69      45.622  48.361  19.192  1.00 11.57           O  
ATOM    554  CB  THR A  69      48.356  47.944  20.028  1.00 12.18           C  
ATOM    555  OG1 THR A  69      48.081  47.588  21.391  1.00 13.39           O  
ATOM    556  CG2 THR A  69      49.862  47.950  19.790  1.00 13.26           C  
ATOM    557  N   TYR A  70      45.628  50.115  20.599  1.00 12.17           N  
ATOM    558  CA  TYR A  70      44.174  50.133  20.779  1.00 12.41           C  
ATOM    559  C   TYR A  70      43.495  50.227  19.410  1.00 12.70           C  
ATOM    560  O   TYR A  70      43.620  51.230  18.710  1.00 12.67           O  
ATOM    561  CB  TYR A  70      43.789  51.321  21.666  1.00 13.98           C  
ATOM    562  CG  TYR A  70      42.340  51.345  22.076  1.00 14.39           C  
ATOM    563  CD1 TYR A  70      41.744  50.232  22.667  1.00 14.84           C  
ATOM    564  CD2 TYR A  70      41.563  52.484  21.884  1.00 15.03           C  
ATOM    565  CE1 TYR A  70      40.401  50.256  23.059  1.00 15.42           C  
ATOM    566  CE2 TYR A  70      40.223  52.518  22.269  1.00 15.05           C  
ATOM    567  CZ  TYR A  70      39.650  51.405  22.855  1.00 16.01           C  
ATOM    568  OH  TYR A  70      38.329  51.457  23.247  1.00 20.34           O  
ATOM    569  N   LEU A  71      42.743  49.189  19.045  1.00 11.81           N  
ATOM    570  CA  LEU A  71      42.114  49.128  17.726  1.00 10.96           C  
ATOM    571  C   LEU A  71      41.404  50.376  17.200  1.00 11.75           C  
ATOM    572  O   LEU A  71      41.641  50.783  16.059  1.00 12.15           O  
ATOM    573  CB  LEU A  71      41.171  47.918  17.642  1.00 10.64           C  
ATOM    574  CG  LEU A  71      40.634  47.548  16.252  1.00  9.96           C  
ATOM    575  CD1 LEU A  71      41.784  47.441  15.240  1.00 11.44           C  
ATOM    576  CD2 LEU A  71      39.886  46.222  16.337  1.00 13.44           C  
ATOM    577  N   PRO A  72      40.528  51.001  18.004  1.00 12.36           N  
ATOM    578  CA  PRO A  72      39.854  52.195  17.482  1.00 13.46           C  
ATOM    579  C   PRO A  72      40.826  53.305  17.090  1.00 13.04           C  
ATOM    580  O   PRO A  72      40.614  53.990  16.087  1.00 12.92           O  
ATOM    581  CB  PRO A  72      38.929  52.596  18.627  1.00 13.81           C  
ATOM    582  CG  PRO A  72      38.593  51.272  19.255  1.00 12.73           C  
ATOM    583  CD  PRO A  72      39.954  50.603  19.301  1.00 12.91           C  
ATOM    584  N   GLU A  73      41.882  53.490  17.881  1.00 13.08           N  
ATOM    585  CA  GLU A  73      42.873  54.518  17.572  1.00 14.75           C  
ATOM    586  C   GLU A  73      43.729  54.118  16.370  1.00 14.43           C  
ATOM    587  O   GLU A  73      44.073  54.963  15.545  1.00 13.54           O  
ATOM    588  CB  GLU A  73      43.776  54.795  18.782  1.00 17.89           C  
ATOM    589  CG  GLU A  73      43.067  55.401  19.992  1.00 23.31           C  
ATOM    590  CD  GLU A  73      42.737  56.883  19.835  1.00 26.06           C  
ATOM    591  OE1 GLU A  73      42.164  57.460  20.787  1.00 29.62           O  
ATOM    592  OE2 GLU A  73      43.048  57.476  18.778  1.00 27.25           O  
ATOM    593  N   VAL A  74      44.085  52.839  16.275  1.00 12.93           N  
ATOM    594  CA  VAL A  74      44.881  52.366  15.148  1.00 11.75           C  
ATOM    595  C   VAL A  74      44.076  52.523  13.846  1.00 12.43           C  
ATOM    596  O   VAL A  74      44.621  52.893  12.807  1.00 13.88           O  
ATOM    597  CB  VAL A  74      45.302  50.875  15.335  1.00 12.09           C  
ATOM    598  CG1 VAL A  74      46.001  50.364  14.095  1.00 12.60           C  
ATOM    599  CG2 VAL A  74      46.241  50.745  16.529  1.00 10.60           C  
ATOM    600  N   CYS A  75      42.775  52.245  13.907  1.00 12.52           N  
ATOM    601  CA  CYS A  75      41.917  52.374  12.732  1.00 11.75           C  
ATOM    602  C   CYS A  75      41.858  53.824  12.274  1.00 11.78           C  
ATOM    603  O   CYS A  75      42.027  54.120  11.091  1.00 12.58           O  
ATOM    604  CB  CYS A  75      40.498  51.890  13.035  1.00 12.10           C  
ATOM    605  SG  CYS A  75      40.313  50.098  13.070  1.00 13.74           S  
ATOM    606  N   ALA A  76      41.608  54.725  13.217  1.00 13.40           N  
ATOM    607  CA  ALA A  76      41.529  56.147  12.906  1.00 13.34           C  
ATOM    608  C   ALA A  76      42.804  56.619  12.217  1.00 15.04           C  
ATOM    609  O   ALA A  76      42.749  57.314  11.202  1.00 14.99           O  
ATOM    610  CB  ALA A  76      41.298  56.939  14.167  1.00 15.38           C  
ATOM    611  N   THR A  77      43.949  56.234  12.768  1.00 13.97           N  
ATOM    612  CA  THR A  77      45.242  56.621  12.209  1.00 15.88           C  
ATOM    613  C   THR A  77      45.453  56.032  10.819  1.00 15.59           C  
ATOM    614  O   THR A  77      45.860  56.733   9.894  1.00 16.13           O  
ATOM    615  CB  THR A  77      46.399  56.171  13.116  1.00 17.67           C  
ATOM    616  OG1 THR A  77      46.296  56.824  14.391  1.00 20.06           O  
ATOM    617  CG2 THR A  77      47.738  56.509  12.474  1.00 19.97           C  
ATOM    618  N   ALA A  78      45.167  54.744  10.671  1.00 14.68           N  
ATOM    619  CA  ALA A  78      45.347  54.066   9.392  1.00 16.10           C  
ATOM    620  C   ALA A  78      44.401  54.582   8.309  1.00 17.09           C  
ATOM    621  O   ALA A  78      44.822  54.845   7.182  1.00 16.24           O  
ATOM    622  CB  ALA A  78      45.163  52.550   9.576  1.00 15.26           C  
ATOM    623  N   TRP A  79      43.124  54.730   8.646  1.00 16.79           N  
ATOM    624  CA  TRP A  79      42.158  55.206   7.669  1.00 16.77           C  
ATOM    625  C   TRP A  79      42.464  56.642   7.256  1.00 19.75           C  
ATOM    626  O   TRP A  79      42.275  57.007   6.097  1.00 20.98           O  
ATOM    627  CB  TRP A  79      40.733  55.079   8.222  1.00 14.79           C  
ATOM    628  CG  TRP A  79      40.303  53.651   8.392  1.00 14.56           C  
ATOM    629  CD1 TRP A  79      40.700  52.580   7.642  1.00 13.64           C  
ATOM    630  CD2 TRP A  79      39.365  53.146   9.347  1.00 14.29           C  
ATOM    631  NE1 TRP A  79      40.063  51.435   8.071  1.00 13.41           N  
ATOM    632  CE2 TRP A  79      39.238  51.754   9.116  1.00 14.07           C  
ATOM    633  CE3 TRP A  79      38.617  53.730  10.376  1.00 14.69           C  
ATOM    634  CZ2 TRP A  79      38.389  50.941   9.879  1.00 14.69           C  
ATOM    635  CZ3 TRP A  79      37.774  52.922  11.134  1.00 14.70           C  
ATOM    636  CH2 TRP A  79      37.667  51.541  10.881  1.00 14.63           C  
ATOM    637  N   ASP A  80      42.940  57.455   8.195  1.00 19.41           N  
ATOM    638  CA  ASP A  80      43.284  58.834   7.865  1.00 22.48           C  
ATOM    639  C   ASP A  80      44.536  58.863   6.999  1.00 23.56           C  
ATOM    640  O   ASP A  80      44.717  59.778   6.192  1.00 24.78           O  
ATOM    641  CB  ASP A  80      43.526  59.674   9.129  1.00 23.45           C  
ATOM    642  CG  ASP A  80      42.255  60.306   9.670  1.00 26.77           C  
ATOM    643  OD1 ASP A  80      41.314  60.533   8.877  1.00 29.25           O  
ATOM    644  OD2 ASP A  80      42.203  60.594  10.886  1.00 28.49           O  
ATOM    645  N   LEU A  81      45.397  57.859   7.167  1.00 23.14           N  
ATOM    646  CA  LEU A  81      46.638  57.774   6.404  1.00 25.04           C  
ATOM    647  C   LEU A  81      46.408  57.253   4.986  1.00 24.07           C  
ATOM    648  O   LEU A  81      47.280  57.387   4.125  1.00 26.02           O  
ATOM    649  CB  LEU A  81      47.646  56.876   7.132  1.00 26.55           C  
ATOM    650  CG  LEU A  81      49.063  56.802   6.557  1.00 28.33           C  
ATOM    651  CD1 LEU A  81      49.709  58.180   6.629  1.00 29.16           C  
ATOM    652  CD2 LEU A  81      49.896  55.790   7.332  1.00 29.96           C  
ATOM    653  N   GLY A  82      45.242  56.658   4.741  1.00 23.07           N  
ATOM    654  CA  GLY A  82      44.951  56.150   3.410  1.00 21.52           C  
ATOM    655  C   GLY A  82      44.437  54.721   3.309  1.00 19.81           C  
ATOM    656  O   GLY A  82      43.995  54.289   2.244  1.00 19.09           O  
ATOM    657  N   VAL A  83      44.495  53.970   4.399  1.00 17.96           N  
ATOM    658  CA  VAL A  83      44.007  52.597   4.363  1.00 17.30           C  
ATOM    659  C   VAL A  83      42.506  52.602   4.094  1.00 16.60           C  
ATOM    660  O   VAL A  83      41.753  53.317   4.757  1.00 17.71           O  
ATOM    661  CB  VAL A  83      44.262  51.872   5.702  1.00 16.27           C  
ATOM    662  CG1 VAL A  83      43.641  50.480   5.669  1.00 16.89           C  
ATOM    663  CG2 VAL A  83      45.754  51.775   5.958  1.00 18.42           C  
ATOM    664  N   PRO A  84      42.050  51.823   3.098  1.00 17.18           N  
ATOM    665  CA  PRO A  84      40.619  51.767   2.783  1.00 17.37           C  
ATOM    666  C   PRO A  84      39.798  51.459   4.040  1.00 18.30           C  
ATOM    667  O   PRO A  84      40.158  50.572   4.809  1.00 17.41           O  
ATOM    668  CB  PRO A  84      40.543  50.640   1.755  1.00 18.87           C  
ATOM    669  CG  PRO A  84      41.852  50.767   1.036  1.00 16.72           C  
ATOM    670  CD  PRO A  84      42.832  50.997   2.157  1.00 17.70           C  
ATOM    671  N   ARG A  85      38.705  52.195   4.246  1.00 17.02           N  
ATOM    672  CA  ARG A  85      37.839  52.005   5.415  1.00 18.01           C  
ATOM    673  C   ARG A  85      37.329  50.573   5.571  1.00 17.24           C  
ATOM    674  O   ARG A  85      37.059  50.118   6.684  1.00 17.99           O  
ATOM    675  CB  ARG A  85      36.640  52.956   5.333  1.00 18.32           C  
ATOM    676  CG  ARG A  85      35.622  52.821   6.471  1.00 24.38           C  
ATOM    677  CD  ARG A  85      36.195  53.290   7.799  1.00 27.78           C  
ATOM    678  NE  ARG A  85      35.157  53.770   8.711  1.00 28.95           N  
ATOM    679  CZ  ARG A  85      34.403  52.996   9.484  1.00 32.59           C  
ATOM    680  NH1 ARG A  85      34.559  51.681   9.473  1.00 32.32           N  
ATOM    681  NH2 ARG A  85      33.491  53.544  10.275  1.00 31.97           N  
ATOM    682  N   GLU A  86      37.190  49.873   4.451  1.00 16.79           N  
ATOM    683  CA  GLU A  86      36.702  48.498   4.440  1.00 18.59           C  
ATOM    684  C   GLU A  86      37.695  47.489   5.023  1.00 17.49           C  
ATOM    685  O   GLU A  86      37.338  46.338   5.287  1.00 20.74           O  
ATOM    686  CB  GLU A  86      36.354  48.096   3.005  1.00 21.89           C  
ATOM    687  CG  GLU A  86      37.548  48.101   2.067  1.00 29.35           C  
ATOM    688  CD  GLU A  86      37.154  47.998   0.610  1.00 33.18           C  
ATOM    689  OE1 GLU A  86      36.410  47.057   0.256  1.00 36.37           O  
ATOM    690  OE2 GLU A  86      37.593  48.858  -0.185  1.00 35.15           O  
ATOM    691  N   LEU A  87      38.936  47.921   5.214  1.00 15.22           N  
ATOM    692  CA  LEU A  87      39.987  47.064   5.761  1.00 14.32           C  
ATOM    693  C   LEU A  87      40.233  47.417   7.222  1.00 13.50           C  
ATOM    694  O   LEU A  87      40.381  48.594   7.564  1.00 15.64           O  
ATOM    695  CB  LEU A  87      41.288  47.253   4.969  1.00 13.84           C  
ATOM    696  CG  LEU A  87      41.249  46.969   3.465  1.00 14.33           C  
ATOM    697  CD1 LEU A  87      42.659  47.127   2.881  1.00 14.94           C  
ATOM    698  CD2 LEU A  87      40.719  45.553   3.223  1.00 17.47           C  
ATOM    699  N   ILE A  88      40.282  46.401   8.082  1.00 11.46           N  
ATOM    700  CA  ILE A  88      40.528  46.626   9.506  1.00 12.13           C  
ATOM    701  C   ILE A  88      41.950  46.214   9.864  1.00 11.44           C  
ATOM    702  O   ILE A  88      42.320  45.048   9.727  1.00 11.33           O  
ATOM    703  CB  ILE A  88      39.573  45.806  10.394  1.00 10.70           C  
ATOM    704  CG1 ILE A  88      38.121  46.115  10.036  1.00 14.02           C  
ATOM    705  CG2 ILE A  88      39.834  46.130  11.864  1.00 13.12           C  
ATOM    706  CD1 ILE A  88      37.121  45.206  10.732  1.00 14.84           C  
ATOM    707  N   PRO A  89      42.764  47.161  10.349  1.00 10.74           N  
ATOM    708  CA  PRO A  89      44.142  46.809  10.705  1.00 12.29           C  
ATOM    709  C   PRO A  89      44.255  45.737  11.773  1.00 13.24           C  
ATOM    710  O   PRO A  89      43.495  45.727  12.737  1.00 13.56           O  
ATOM    711  CB  PRO A  89      44.724  48.132  11.193  1.00 13.03           C  
ATOM    712  CG  PRO A  89      43.961  49.142  10.407  1.00 13.69           C  
ATOM    713  CD  PRO A  89      42.549  48.615  10.451  1.00 11.83           C  
ATOM    714  N   ILE A  90      45.200  44.820  11.586  1.00 12.92           N  
ATOM    715  CA  ILE A  90      45.444  43.802  12.590  1.00 12.30           C  
ATOM    716  C   ILE A  90      46.819  44.094  13.185  1.00 13.09           C  
ATOM    717  O   ILE A  90      47.096  43.740  14.323  1.00 11.44           O  
ATOM    718  CB  ILE A  90      45.381  42.349  12.015  1.00 10.98           C  
ATOM    719  CG1 ILE A  90      45.726  41.359  13.130  1.00 12.43           C  
ATOM    720  CG2 ILE A  90      46.358  42.170  10.837  1.00 13.07           C  
ATOM    721  CD1 ILE A  90      45.478  39.903  12.773  1.00 12.99           C  
ATOM    722  N   CYS A  91      47.683  44.765  12.426  1.00 12.97           N  
ATOM    723  CA  CYS A  91      48.996  45.075  12.971  1.00 13.03           C  
ATOM    724  C   CYS A  91      49.748  46.160  12.225  1.00 14.32           C  
ATOM    725  O   CYS A  91      49.946  46.080  11.017  1.00 13.89           O  
ATOM    726  CB  CYS A  91      49.856  43.808  13.023  1.00 13.65           C  
ATOM    727  SG  CYS A  91      51.457  44.021  13.843  1.00 15.49           S  
ATOM    728  N   GLN A  92      50.167  47.180  12.966  1.00 14.98           N  
ATOM    729  CA  GLN A  92      50.941  48.267  12.382  1.00 16.78           C  
ATOM    730  C   GLN A  92      52.397  47.808  12.238  1.00 17.44           C  
ATOM    731  O   GLN A  92      52.893  47.015  13.042  1.00 16.73           O  
ATOM    732  CB  GLN A  92      50.882  49.490  13.297  1.00 17.47           C  
ATOM    733  CG  GLN A  92      51.517  50.738  12.702  1.00 17.16           C  
ATOM    734  CD  GLN A  92      51.576  51.885  13.691  1.00 20.87           C  
ATOM    735  OE1 GLN A  92      50.754  51.973  14.608  1.00 19.54           O  
ATOM    736  NE2 GLN A  92      52.545  52.786  13.500  1.00 21.40           N  
ATOM    737  N   ASP A  93      53.076  48.285  11.202  1.00 18.18           N  
ATOM    738  CA  ASP A  93      54.485  47.949  10.993  1.00 20.04           C  
ATOM    739  C   ASP A  93      55.114  49.198  10.397  1.00 20.80           C  
ATOM    740  O   ASP A  93      55.208  49.335   9.180  1.00 21.88           O  
ATOM    741  CB  ASP A  93      54.642  46.763  10.036  1.00 22.62           C  
ATOM    742  CG  ASP A  93      56.089  46.290   9.918  1.00 26.14           C  
ATOM    743  OD1 ASP A  93      56.918  46.669  10.778  1.00 25.94           O  
ATOM    744  OD2 ASP A  93      56.396  45.526   8.973  1.00 27.33           O  
ATOM    745  N   GLY A  94      55.527  50.110  11.270  1.00 22.04           N  
ATOM    746  CA  GLY A  94      56.100  51.361  10.808  1.00 21.80           C  
ATOM    747  C   GLY A  94      54.951  52.204  10.286  1.00 21.36           C  
ATOM    748  O   GLY A  94      54.014  52.513  11.029  1.00 21.16           O  
ATOM    749  N   GLU A  95      55.014  52.575   9.010  1.00 20.75           N  
ATOM    750  CA  GLU A  95      53.957  53.360   8.387  1.00 20.68           C  
ATOM    751  C   GLU A  95      53.061  52.448   7.552  1.00 19.19           C  
ATOM    752  O   GLU A  95      52.122  52.911   6.905  1.00 20.95           O  
ATOM    753  CB  GLU A  95      54.548  54.460   7.495  1.00 22.18           C  
ATOM    754  CG  GLU A  95      55.699  54.007   6.622  1.00 25.09           C  
ATOM    755  CD  GLU A  95      56.037  55.007   5.527  1.00 26.05           C  
ATOM    756  OE1 GLU A  95      55.746  56.210   5.703  1.00 27.02           O  
ATOM    757  OE2 GLU A  95      56.601  54.587   4.495  1.00 29.18           O  
ATOM    758  N   ASP A  96      53.355  51.150   7.569  1.00 17.56           N  
ATOM    759  CA  ASP A  96      52.552  50.188   6.823  1.00 17.87           C  
ATOM    760  C   ASP A  96      51.594  49.493   7.772  1.00 15.08           C  
ATOM    761  O   ASP A  96      51.765  49.546   8.989  1.00 15.69           O  
ATOM    762  CB  ASP A  96      53.433  49.145   6.134  1.00 18.86           C  
ATOM    763  CG  ASP A  96      54.303  49.736   5.040  1.00 22.57           C  
ATOM    764  OD1 ASP A  96      53.975  50.829   4.522  1.00 23.62           O  
ATOM    765  OD2 ASP A  96      55.309  49.088   4.689  1.00 24.83           O  
ATOM    766  N   TYR A  97      50.591  48.825   7.214  1.00 13.67           N  
ATOM    767  CA  TYR A  97      49.598  48.140   8.040  1.00 12.71           C  
ATOM    768  C   TYR A  97      49.136  46.811   7.479  1.00 13.28           C  
ATOM    769  O   TYR A  97      48.774  46.717   6.310  1.00 13.20           O  
ATOM    770  CB  TYR A  97      48.339  48.999   8.191  1.00 13.02           C  
ATOM    771  CG  TYR A  97      48.494  50.237   9.028  1.00 12.90           C  
ATOM    772  CD1 TYR A  97      48.283  50.202  10.403  1.00 13.34           C  
ATOM    773  CD2 TYR A  97      48.850  51.449   8.442  1.00 14.87           C  
ATOM    774  CE1 TYR A  97      48.417  51.341  11.179  1.00 15.45           C  
ATOM    775  CE2 TYR A  97      48.991  52.597   9.208  1.00 15.17           C  
ATOM    776  CZ  TYR A  97      48.773  52.536  10.575  1.00 14.99           C  
ATOM    777  OH  TYR A  97      48.909  53.663  11.345  1.00 15.33           O  
ATOM    778  N   TYR A  98      49.144  45.785   8.322  1.00 13.14           N  
ATOM    779  CA  TYR A  98      48.606  44.494   7.911  1.00 11.51           C  
ATOM    780  C   TYR A  98      47.132  44.708   8.251  1.00 12.68           C  
ATOM    781  O   TYR A  98      46.799  45.087   9.375  1.00 12.03           O  
ATOM    782  CB  TYR A  98      49.214  43.366   8.749  1.00 12.15           C  
ATOM    783  CG  TYR A  98      50.660  43.076   8.406  1.00 13.52           C  
ATOM    784  CD1 TYR A  98      50.991  42.325   7.280  1.00 15.21           C  
ATOM    785  CD2 TYR A  98      51.695  43.546   9.212  1.00 14.56           C  
ATOM    786  CE1 TYR A  98      52.323  42.042   6.959  1.00 14.22           C  
ATOM    787  CE2 TYR A  98      53.037  43.269   8.899  1.00 14.80           C  
ATOM    788  CZ  TYR A  98      53.335  42.515   7.774  1.00 15.12           C  
ATOM    789  OH  TYR A  98      54.647  42.222   7.477  1.00 18.19           O  
ATOM    790  N   CYS A  99      46.257  44.520   7.266  1.00 12.92           N  
ATOM    791  CA  CYS A  99      44.823  44.736   7.459  1.00 13.63           C  
ATOM    792  C   CYS A  99      44.017  43.540   7.015  1.00 13.26           C  
ATOM    793  O   CYS A  99      44.455  42.767   6.162  1.00 11.70           O  
ATOM    794  CB  CYS A  99      44.359  45.951   6.660  1.00 15.57           C  
ATOM    795  SG  CYS A  99      45.334  47.445   6.914  1.00 20.75           S  
ATOM    796  N   VAL A 100      42.809  43.426   7.555  1.00 11.28           N  
ATOM    797  CA  VAL A 100      41.946  42.300   7.248  1.00 11.31           C  
ATOM    798  C   VAL A 100      40.708  42.679   6.446  1.00 12.88           C  
ATOM    799  O   VAL A 100      39.981  43.623   6.791  1.00 11.72           O  
ATOM    800  CB  VAL A 100      41.514  41.606   8.543  1.00  9.66           C  
ATOM    801  CG1 VAL A 100      40.848  40.278   8.234  1.00 11.30           C  
ATOM    802  CG2 VAL A 100      42.735  41.396   9.434  1.00 12.67           C  
ATOM    803  N   GLU A 101      40.488  41.935   5.364  1.00 13.63           N  
ATOM    804  CA  GLU A 101      39.338  42.136   4.494  1.00 14.87           C  
ATOM    805  C   GLU A 101      38.108  41.582   5.196  1.00 15.57           C  
ATOM    806  O   GLU A 101      38.217  40.850   6.187  1.00 15.12           O  
ATOM    807  CB  GLU A 101      39.513  41.384   3.173  1.00 15.24           C  
ATOM    808  CG  GLU A 101      40.620  41.864   2.272  1.00 15.50           C  
ATOM    809  CD  GLU A 101      40.447  41.320   0.866  1.00 18.48           C  
ATOM    810  OE1 GLU A 101      40.125  40.118   0.730  1.00 13.48           O  
ATOM    811  OE2 GLU A 101      40.628  42.090  -0.101  1.00 20.12           O  
ATOM    812  N   GLU A 102      36.933  41.920   4.672  1.00 17.64           N  
ATOM    813  CA  GLU A 102      35.689  41.449   5.260  1.00 17.99           C  
ATOM    814  C   GLU A 102      35.603  39.926   5.258  1.00 17.17           C  
ATOM    815  O   GLU A 102      35.015  39.338   6.172  1.00 18.86           O  
ATOM    816  CB  GLU A 102      34.507  42.076   4.516  1.00 22.22           C  
ATOM    817  CG  GLU A 102      34.614  43.598   4.468  1.00 28.34           C  
ATOM    818  CD  GLU A 102      33.438  44.268   3.786  1.00 32.44           C  
ATOM    819  OE1 GLU A 102      32.309  44.179   4.320  1.00 34.47           O  
ATOM    820  OE2 GLU A 102      33.647  44.886   2.716  1.00 34.01           O  
ATOM    821  N   ASP A 103      36.205  39.283   4.255  1.00 14.47           N  
ATOM    822  CA  ASP A 103      36.183  37.828   4.184  1.00 14.40           C  
ATOM    823  C   ASP A 103      37.350  37.158   4.900  1.00 13.62           C  
ATOM    824  O   ASP A 103      37.534  35.944   4.800  1.00 13.17           O  
ATOM    825  CB  ASP A 103      36.097  37.328   2.725  1.00 14.05           C  
ATOM    826  CG  ASP A 103      37.305  37.715   1.873  1.00 14.12           C  
ATOM    827  OD1 ASP A 103      38.384  38.016   2.417  1.00 11.72           O  
ATOM    828  OD2 ASP A 103      37.166  37.686   0.632  1.00 12.66           O  
ATOM    829  N   GLY A 104      38.137  37.950   5.622  1.00 11.93           N  
ATOM    830  CA  GLY A 104      39.239  37.384   6.379  1.00 11.80           C  
ATOM    831  C   GLY A 104      40.639  37.426   5.807  1.00 11.62           C  
ATOM    832  O   GLY A 104      41.597  37.176   6.546  1.00 11.66           O  
ATOM    833  N   THR A 105      40.784  37.725   4.518  1.00 11.81           N  
ATOM    834  CA  THR A 105      42.115  37.778   3.926  1.00 11.45           C  
ATOM    835  C   THR A 105      42.926  38.894   4.581  1.00 11.09           C  
ATOM    836  O   THR A 105      42.392  39.965   4.858  1.00 10.94           O  
ATOM    837  CB  THR A 105      42.045  38.050   2.406  1.00 12.68           C  
ATOM    838  OG1 THR A 105      41.174  37.098   1.786  1.00 11.77           O  
ATOM    839  CG2 THR A 105      43.442  37.947   1.777  1.00 14.42           C  
ATOM    840  N   VAL A 106      44.204  38.629   4.845  1.00 10.55           N  
ATOM    841  CA  VAL A 106      45.083  39.636   5.440  1.00 11.32           C  
ATOM    842  C   VAL A 106      45.929  40.219   4.320  1.00 12.85           C  
ATOM    843  O   VAL A 106      46.521  39.483   3.527  1.00 13.10           O  
ATOM    844  CB  VAL A 106      46.023  39.036   6.503  1.00 12.85           C  
ATOM    845  CG1 VAL A 106      46.912  40.138   7.076  1.00 13.20           C  
ATOM    846  CG2 VAL A 106      45.202  38.396   7.617  1.00 12.95           C  
ATOM    847  N   LEU A 107      45.981  41.544   4.258  1.00 12.21           N  
ATOM    848  CA  LEU A 107      46.744  42.226   3.225  1.00 14.20           C  
ATOM    849  C   LEU A 107      47.746  43.151   3.875  1.00 13.72           C  
ATOM    850  O   LEU A 107      47.664  43.437   5.066  1.00 14.99           O  
ATOM    851  CB  LEU A 107      45.817  43.072   2.350  1.00 13.39           C  
ATOM    852  CG  LEU A 107      44.554  42.437   1.773  1.00 13.95           C  
ATOM    853  CD1 LEU A 107      43.737  43.489   1.032  1.00 14.76           C  
ATOM    854  CD2 LEU A 107      44.936  41.308   0.833  1.00 15.90           C  
ATOM    855  N   LEU A 108      48.694  43.627   3.081  1.00 14.97           N  
ATOM    856  CA  LEU A 108      49.671  44.568   3.593  1.00 13.92           C  
ATOM    857  C   LEU A 108      49.469  45.856   2.814  1.00 15.68           C  
ATOM    858  O   LEU A 108      49.556  45.861   1.586  1.00 15.81           O  
ATOM    859  CB  LEU A 108      51.089  44.044   3.387  1.00 15.16           C  
ATOM    860  CG  LEU A 108      52.190  45.016   3.814  1.00 16.58           C  
ATOM    861  CD1 LEU A 108      52.081  45.341   5.301  1.00 17.18           C  
ATOM    862  CD2 LEU A 108      53.534  44.388   3.483  1.00 18.32           C  
ATOM    863  N   TRP A 109      49.173  46.940   3.524  1.00 15.58           N  
ATOM    864  CA  TRP A 109      48.967  48.225   2.876  1.00 19.03           C  
ATOM    865  C   TRP A 109      50.227  49.057   3.056  1.00 19.97           C  
ATOM    866  O   TRP A 109      50.649  49.320   4.182  1.00 21.99           O  
ATOM    867  CB  TRP A 109      47.777  48.945   3.500  1.00 17.89           C  
ATOM    868  CG  TRP A 109      47.418  50.232   2.821  1.00 21.26           C  
ATOM    869  CD1 TRP A 109      46.582  50.392   1.753  1.00 20.46           C  
ATOM    870  CD2 TRP A 109      47.874  51.539   3.178  1.00 22.66           C  
ATOM    871  NE1 TRP A 109      46.482  51.727   1.427  1.00 23.65           N  
ATOM    872  CE2 TRP A 109      47.268  52.452   2.286  1.00 23.24           C  
ATOM    873  CE3 TRP A 109      48.737  52.030   4.170  1.00 25.58           C  
ATOM    874  CZ2 TRP A 109      47.496  53.832   2.354  1.00 26.09           C  
ATOM    875  CZ3 TRP A 109      48.963  53.406   4.240  1.00 27.92           C  
ATOM    876  CH2 TRP A 109      48.344  54.290   3.337  1.00 26.79           C  
ATOM    877  N   SER A 110      50.826  49.463   1.940  1.00 22.65           N  
ATOM    878  CA  SER A 110      52.046  50.262   1.957  1.00 23.35           C  
ATOM    879  C   SER A 110      51.742  51.758   1.926  1.00 25.70           C  
ATOM    880  O   SER A 110      50.991  52.221   1.070  1.00 25.80           O  
ATOM    881  CB  SER A 110      52.917  49.897   0.757  1.00 25.55           C  
ATOM    882  OG  SER A 110      54.027  50.774   0.652  1.00 28.34           O  
ATOM    883  N   ALA A 111      52.340  52.506   2.853  1.00 25.07           N  
ATOM    884  CA  ALA A 111      52.144  53.951   2.936  1.00 26.53           C  
ATOM    885  C   ALA A 111      52.537  54.637   1.629  1.00 26.90           C  
ATOM    886  O   ALA A 111      53.558  54.305   1.025  1.00 28.99           O  
ATOM    887  CB  ALA A 111      52.967  54.520   4.086  1.00 25.66           C  
ATOM    888  N   LEU A 115      49.306  52.087  -1.314  1.00 32.19           N  
ATOM    889  CA  LEU A 115      48.302  51.118  -1.726  1.00 30.66           C  
ATOM    890  C   LEU A 115      48.674  49.729  -1.210  1.00 29.12           C  
ATOM    891  O   LEU A 115      49.737  49.542  -0.617  1.00 26.88           O  
ATOM    892  CB  LEU A 115      48.190  51.096  -3.254  1.00 33.57           C  
ATOM    893  CG  LEU A 115      47.034  50.303  -3.875  1.00 35.58           C  
ATOM    894  CD1 LEU A 115      45.701  50.889  -3.419  1.00 35.68           C  
ATOM    895  CD2 LEU A 115      47.143  50.346  -5.394  1.00 36.96           C  
ATOM    896  N   VAL A 116      47.791  48.762  -1.432  1.00 28.70           N  
ATOM    897  CA  VAL A 116      48.035  47.394  -0.993  1.00 29.45           C  
ATOM    898  C   VAL A 116      49.094  46.745  -1.874  1.00 29.76           C  
ATOM    899  O   VAL A 116      49.122  46.965  -3.088  1.00 31.37           O  
ATOM    900  CB  VAL A 116      46.744  46.550  -1.055  1.00 29.77           C  
ATOM    901  CG1 VAL A 116      47.025  45.129  -0.590  1.00 30.40           C  
ATOM    902  CG2 VAL A 116      45.669  47.187  -0.192  1.00 30.85           C  
ATOM    903  N   THR A 117      49.969  45.953  -1.263  1.00 28.54           N  
ATOM    904  CA  THR A 117      51.023  45.275  -2.007  1.00 29.23           C  
ATOM    905  C   THR A 117      50.491  44.017  -2.690  1.00 29.76           C  
ATOM    906  O   THR A 117      49.279  43.788  -2.754  1.00 28.89           O  
ATOM    907  CB  THR A 117      52.189  44.882  -1.089  1.00 30.78           C  
ATOM    908  OG1 THR A 117      51.758  43.860  -0.181  1.00 32.76           O  
ATOM    909  CG2 THR A 117      52.672  46.089  -0.299  1.00 29.12           C  
ATOM    910  N   GLU A 118      51.403  43.192  -3.190  1.00 29.91           N  
ATOM    911  CA  GLU A 118      51.020  41.967  -3.873  1.00 30.26           C  
ATOM    912  C   GLU A 118      50.962  40.761  -2.935  1.00 30.44           C  
ATOM    913  O   GLU A 118      50.429  39.716  -3.302  1.00 31.15           O  
ATOM    914  CB  GLU A 118      51.992  41.685  -5.028  1.00 31.73           C  
ATOM    915  CG  GLU A 118      53.367  41.134  -4.628  1.00 31.92           C  
ATOM    916  CD  GLU A 118      54.128  42.018  -3.653  1.00 32.82           C  
ATOM    917  OE1 GLU A 118      54.123  43.255  -3.826  1.00 30.99           O  
ATOM    918  OE2 GLU A 118      54.752  41.467  -2.718  1.00 34.24           O  
ATOM    919  N   GLU A 119      51.493  40.912  -1.725  1.00 29.64           N  
ATOM    920  CA  GLU A 119      51.508  39.817  -0.761  1.00 29.81           C  
ATOM    921  C   GLU A 119      50.302  39.787   0.173  1.00 27.59           C  
ATOM    922  O   GLU A 119      49.844  40.827   0.654  1.00 29.83           O  
ATOM    923  CB  GLU A 119      52.795  39.868   0.060  1.00 31.39           C  
ATOM    924  CG  GLU A 119      53.010  41.164   0.819  1.00 34.76           C  
ATOM    925  CD  GLU A 119      54.418  41.275   1.363  1.00 36.83           C  
ATOM    926  OE1 GLU A 119      54.878  40.319   2.024  1.00 37.49           O  
ATOM    927  OE2 GLU A 119      55.067  42.318   1.130  1.00 39.06           O  
ATOM    928  N   SER A 120      49.795  38.584   0.426  1.00 25.19           N  
ATOM    929  CA  SER A 120      48.645  38.410   1.306  1.00 23.05           C  
ATOM    930  C   SER A 120      48.674  37.053   2.001  1.00 21.30           C  
ATOM    931  O   SER A 120      49.436  36.160   1.622  1.00 20.88           O  
ATOM    932  CB  SER A 120      47.343  38.550   0.515  1.00 22.74           C  
ATOM    933  OG  SER A 120      47.198  37.508  -0.437  1.00 23.19           O  
ATOM    934  N   TRP A 121      47.832  36.910   3.018  1.00 17.07           N  
ATOM    935  CA  TRP A 121      47.735  35.681   3.795  1.00 16.05           C  
ATOM    936  C   TRP A 121      46.278  35.237   3.820  1.00 15.27           C  
ATOM    937  O   TRP A 121      45.373  36.063   3.961  1.00 14.62           O  
ATOM    938  CB  TRP A 121      48.256  35.935   5.211  1.00 15.52           C  
ATOM    939  CG  TRP A 121      49.710  36.294   5.211  1.00 15.17           C  
ATOM    940  CD1 TRP A 121      50.766  35.448   5.408  1.00 17.34           C  
ATOM    941  CD2 TRP A 121      50.274  37.573   4.900  1.00 15.98           C  
ATOM    942  NE1 TRP A 121      51.955  36.122   5.234  1.00 16.34           N  
ATOM    943  CE2 TRP A 121      51.681  37.428   4.921  1.00 17.59           C  
ATOM    944  CE3 TRP A 121      49.729  38.829   4.602  1.00 14.05           C  
ATOM    945  CZ2 TRP A 121      52.550  38.496   4.654  1.00 16.13           C  
ATOM    946  CZ3 TRP A 121      50.597  39.893   4.336  1.00 17.89           C  
ATOM    947  CH2 TRP A 121      51.991  39.714   4.364  1.00 17.41           C  
ATOM    948  N   GLU A 122      46.054  33.934   3.678  1.00 15.08           N  
ATOM    949  CA  GLU A 122      44.703  33.383   3.632  1.00 16.21           C  
ATOM    950  C   GLU A 122      43.823  33.667   4.837  1.00 14.16           C  
ATOM    951  O   GLU A 122      42.602  33.709   4.709  1.00 17.13           O  
ATOM    952  CB  GLU A 122      44.747  31.868   3.408  1.00 17.80           C  
ATOM    953  CG  GLU A 122      45.269  31.423   2.046  1.00 23.85           C  
ATOM    954  CD  GLU A 122      46.716  31.800   1.810  1.00 27.84           C  
ATOM    955  OE1 GLU A 122      47.513  31.760   2.773  1.00 29.15           O  
ATOM    956  OE2 GLU A 122      47.060  32.120   0.647  1.00 32.69           O  
ATOM    957  N   SER A 123      44.439  33.843   6.001  1.00 14.00           N  
ATOM    958  CA  SER A 123      43.698  34.115   7.229  1.00 12.80           C  
ATOM    959  C   SER A 123      44.602  34.776   8.252  1.00 12.72           C  
ATOM    960  O   SER A 123      45.832  34.809   8.094  1.00 10.83           O  
ATOM    961  CB  SER A 123      43.157  32.816   7.834  1.00 13.66           C  
ATOM    962  OG  SER A 123      44.194  32.108   8.501  1.00 13.00           O  
ATOM    963  N   VAL A 124      43.983  35.297   9.310  1.00 12.31           N  
ATOM    964  CA  VAL A 124      44.728  35.941  10.379  1.00 12.23           C  
ATOM    965  C   VAL A 124      45.653  34.925  11.044  1.00 13.05           C  
ATOM    966  O   VAL A 124      46.715  35.280  11.557  1.00 11.92           O  
ATOM    967  CB  VAL A 124      43.771  36.536  11.430  1.00 13.92           C  
ATOM    968  CG1 VAL A 124      44.522  36.862  12.697  1.00 17.52           C  
ATOM    969  CG2 VAL A 124      43.100  37.780  10.865  1.00 11.30           C  
ATOM    970  N   TRP A 125      45.252  33.656  11.035  1.00 12.87           N  
ATOM    971  CA  TRP A 125      46.090  32.630  11.636  1.00 12.61           C  
ATOM    972  C   TRP A 125      47.316  32.334  10.762  1.00 12.18           C  
ATOM    973  O   TRP A 125      48.387  32.007  11.282  1.00 12.73           O  
ATOM    974  CB  TRP A 125      45.265  31.372  11.913  1.00 12.86           C  
ATOM    975  CG  TRP A 125      44.293  31.588  13.050  1.00 11.70           C  
ATOM    976  CD1 TRP A 125      42.933  31.464  13.009  1.00 13.52           C  
ATOM    977  CD2 TRP A 125      44.616  31.996  14.390  1.00 12.80           C  
ATOM    978  NE1 TRP A 125      42.388  31.771  14.235  1.00 12.74           N  
ATOM    979  CE2 TRP A 125      43.401  32.102  15.101  1.00 13.38           C  
ATOM    980  CE3 TRP A 125      45.814  32.283  15.055  1.00 12.50           C  
ATOM    981  CZ2 TRP A 125      43.350  32.481  16.449  1.00 12.94           C  
ATOM    982  CZ3 TRP A 125      45.765  32.662  16.396  1.00 13.60           C  
ATOM    983  CH2 TRP A 125      44.537  32.756  17.076  1.00 13.72           C  
ATOM    984  N   HIS A 126      47.175  32.456   9.443  1.00 13.12           N  
ATOM    985  CA  HIS A 126      48.322  32.254   8.553  1.00 13.82           C  
ATOM    986  C   HIS A 126      49.297  33.388   8.830  1.00 15.01           C  
ATOM    987  O   HIS A 126      50.514  33.195   8.875  1.00 15.23           O  
ATOM    988  CB  HIS A 126      47.911  32.322   7.081  1.00 15.91           C  
ATOM    989  CG  HIS A 126      47.230  31.092   6.583  1.00 17.67           C  
ATOM    990  ND1 HIS A 126      45.909  30.808   6.855  1.00 16.38           N  
ATOM    991  CD2 HIS A 126      47.690  30.064   5.829  1.00 17.81           C  
ATOM    992  CE1 HIS A 126      45.583  29.660   6.289  1.00 17.73           C  
ATOM    993  NE2 HIS A 126      46.646  29.189   5.659  1.00 17.87           N  
ATOM    994  N   TRP A 127      48.747  34.582   9.008  1.00 14.34           N  
ATOM    995  CA  TRP A 127      49.563  35.750   9.295  1.00 13.30           C  
ATOM    996  C   TRP A 127      50.268  35.592  10.645  1.00 13.69           C  
ATOM    997  O   TRP A 127      51.448  35.911  10.778  1.00 13.54           O  
ATOM    998  CB  TRP A 127      48.692  37.007   9.321  1.00 11.77           C  
ATOM    999  CG  TRP A 127      49.467  38.238   9.658  1.00 12.35           C  
ATOM   1000  CD1 TRP A 127      50.224  38.994   8.807  1.00 11.37           C  
ATOM   1001  CD2 TRP A 127      49.651  38.797  10.963  1.00 13.02           C  
ATOM   1002  NE1 TRP A 127      50.876  39.986   9.506  1.00 13.00           N  
ATOM   1003  CE2 TRP A 127      50.539  39.888  10.831  1.00 12.58           C  
ATOM   1004  CE3 TRP A 127      49.155  38.480  12.236  1.00 14.26           C  
ATOM   1005  CZ2 TRP A 127      50.942  40.662  11.925  1.00 14.82           C  
ATOM   1006  CZ3 TRP A 127      49.557  39.247  13.320  1.00 15.44           C  
ATOM   1007  CH2 TRP A 127      50.443  40.327  13.157  1.00 15.17           C  
ATOM   1008  N   ALA A 128      49.544  35.099  11.646  1.00 12.51           N  
ATOM   1009  CA  ALA A 128      50.123  34.919  12.970  1.00 13.45           C  
ATOM   1010  C   ALA A 128      51.264  33.906  12.941  1.00 15.86           C  
ATOM   1011  O   ALA A 128      52.303  34.103  13.576  1.00 15.18           O  
ATOM   1012  CB  ALA A 128      49.050  34.466  13.946  1.00 14.56           C  
ATOM   1013  N   ARG A 129      51.062  32.829  12.190  1.00 16.32           N  
ATOM   1014  CA  ARG A 129      52.046  31.762  12.086  1.00 19.23           C  
ATOM   1015  C   ARG A 129      53.228  32.107  11.197  1.00 20.33           C  
ATOM   1016  O   ARG A 129      54.379  31.875  11.567  1.00 20.81           O  
ATOM   1017  CB  ARG A 129      51.384  30.496  11.542  1.00 21.03           C  
ATOM   1018  CG  ARG A 129      52.316  29.297  11.449  1.00 22.14           C  
ATOM   1019  CD  ARG A 129      51.669  28.173  10.671  1.00 23.86           C  
ATOM   1020  NE  ARG A 129      51.533  28.510   9.259  1.00 24.41           N  
ATOM   1021  CZ  ARG A 129      50.703  27.894   8.424  1.00 26.33           C  
ATOM   1022  NH1 ARG A 129      49.934  26.907   8.865  1.00 26.97           N  
ATOM   1023  NH2 ARG A 129      50.641  28.265   7.153  1.00 25.96           N  
ATOM   1024  N   ASP A 130      52.940  32.678  10.033  1.00 18.96           N  
ATOM   1025  CA  ASP A 130      53.983  32.986   9.069  1.00 19.94           C  
ATOM   1026  C   ASP A 130      54.632  34.364   9.153  1.00 18.91           C  
ATOM   1027  O   ASP A 130      55.685  34.590   8.556  1.00 20.31           O  
ATOM   1028  CB  ASP A 130      53.450  32.722   7.659  1.00 22.15           C  
ATOM   1029  CG  ASP A 130      52.888  31.309   7.510  1.00 25.38           C  
ATOM   1030  OD1 ASP A 130      53.394  30.390   8.196  1.00 27.38           O  
ATOM   1031  OD2 ASP A 130      51.951  31.107   6.706  1.00 30.31           O  
ATOM   1032  N   VAL A 131      54.020  35.283   9.891  1.00 16.86           N  
ATOM   1033  CA  VAL A 131      54.591  36.617  10.029  1.00 16.16           C  
ATOM   1034  C   VAL A 131      54.926  36.972  11.476  1.00 15.99           C  
ATOM   1035  O   VAL A 131      56.079  37.250  11.803  1.00 17.46           O  
ATOM   1036  CB  VAL A 131      53.650  37.700   9.453  1.00 15.73           C  
ATOM   1037  CG1 VAL A 131      54.261  39.085   9.665  1.00 14.57           C  
ATOM   1038  CG2 VAL A 131      53.415  37.447   7.968  1.00 15.59           C  
ATOM   1039  N   TRP A 132      53.927  36.957  12.348  1.00 14.16           N  
ATOM   1040  CA  TRP A 132      54.165  37.309  13.744  1.00 14.00           C  
ATOM   1041  C   TRP A 132      55.155  36.361  14.432  1.00 14.29           C  
ATOM   1042  O   TRP A 132      56.153  36.808  15.000  1.00 15.53           O  
ATOM   1043  CB  TRP A 132      52.830  37.349  14.506  1.00 13.82           C  
ATOM   1044  CG  TRP A 132      52.923  37.976  15.879  1.00 12.73           C  
ATOM   1045  CD1 TRP A 132      53.980  38.676  16.399  1.00 12.93           C  
ATOM   1046  CD2 TRP A 132      51.908  37.976  16.891  1.00 11.70           C  
ATOM   1047  NE1 TRP A 132      53.682  39.109  17.669  1.00 13.51           N  
ATOM   1048  CE2 TRP A 132      52.418  38.694  17.998  1.00 11.50           C  
ATOM   1049  CE3 TRP A 132      50.616  37.439  16.968  1.00 12.53           C  
ATOM   1050  CZ2 TRP A 132      51.677  38.888  19.171  1.00 11.45           C  
ATOM   1051  CZ3 TRP A 132      49.882  37.631  18.131  1.00 13.52           C  
ATOM   1052  CH2 TRP A 132      50.414  38.350  19.217  1.00 11.38           C  
ATOM   1053  N   LEU A 133      54.898  35.058  14.348  1.00 15.54           N  
ATOM   1054  CA  LEU A 133      55.768  34.064  14.978  1.00 16.85           C  
ATOM   1055  C   LEU A 133      57.127  33.941  14.296  1.00 19.73           C  
ATOM   1056  O   LEU A 133      58.026  33.268  14.808  1.00 19.84           O  
ATOM   1057  CB  LEU A 133      55.076  32.701  15.003  1.00 16.93           C  
ATOM   1058  CG  LEU A 133      54.045  32.540  16.122  1.00 16.93           C  
ATOM   1059  CD1 LEU A 133      53.204  31.287  15.890  1.00 17.76           C  
ATOM   1060  CD2 LEU A 133      54.766  32.465  17.459  1.00 18.33           C  
ATOM   1061  N   GLU A 134      57.274  34.584  13.144  1.00 20.68           N  
ATOM   1062  CA  GLU A 134      58.540  34.554  12.416  1.00 22.85           C  
ATOM   1063  C   GLU A 134      59.320  35.851  12.610  1.00 23.84           C  
ATOM   1064  O   GLU A 134      60.377  36.042  12.010  1.00 24.94           O  
ATOM   1065  CB  GLU A 134      58.298  34.325  10.925  1.00 23.80           C  
ATOM   1066  CG  GLU A 134      57.891  32.909  10.563  1.00 26.25           C  
ATOM   1067  CD  GLU A 134      58.917  31.878  11.006  1.00 29.29           C  
ATOM   1068  OE1 GLU A 134      60.125  32.096  10.774  1.00 29.83           O  
ATOM   1069  OE2 GLU A 134      58.517  30.847  11.582  1.00 30.89           O  
ATOM   1070  N   SER A 135      58.800  36.744  13.449  1.00 24.53           N  
ATOM   1071  CA  SER A 135      59.465  38.015  13.708  1.00 25.76           C  
ATOM   1072  C   SER A 135      60.488  37.887  14.839  1.00 28.11           C  
ATOM   1073  O   SER A 135      61.306  38.818  14.993  1.00 31.34           O  
ATOM   1074  CB  SER A 135      58.439  39.110  14.045  1.00 25.51           C  
ATOM   1075  OG  SER A 135      57.832  38.904  15.310  1.00 22.77           O  
ATOM   1076  OXT SER A 135      60.455  36.862  15.559  1.00 27.82           O  
TER    1077      SER A 135                                                      
END
MOLECULE T0401.pdb
ATOM      5  N   MET     1      69.878  20.217  11.426  0.50 20.64           N  
ATOM      7  CA  MET     1      68.747  20.624  12.283  0.50 20.35           C  
ATOM      9  C   MET     1      68.999  21.974  12.914  0.50 18.46           C  
ATOM     11  O   MET     1      70.121  22.244  13.366  0.50 18.85           O  
ATOM     13  CB  MET     1      68.515  19.607  13.387  0.50 19.34           C  
ATOM     15  CG  MET     1      67.104  19.585  13.941  0.50 18.81           C  
ATOM     17  SD  MET     1      67.132  19.022  15.781  0.37 16.26          SE  
ATOM     19  CE  MET     1      67.646  20.870  16.265  0.50 17.14           C  
ATOM     21  N   GLU     2      67.946  22.802  12.954  0.50 17.06           N  
ATOM     23  CA  GLU     2      68.010  24.175  13.480  0.50 15.64           C  
ATOM     25  C   GLU     2      66.826  24.465  14.391  0.50 13.92           C  
ATOM     27  O   GLU     2      65.687  24.195  14.045  0.50 13.09           O  
ATOM     29  CB  GLU     2      67.981  25.190  12.309  0.50 16.73           C  
ATOM     31  CG  GLU     2      68.085  26.658  12.706  0.50 17.79           C  
ATOM     33  CD  GLU     2      67.895  27.616  11.547  0.50 19.73           C  
ATOM     35  OE1 GLU     2      67.648  27.132  10.405  0.50 20.85           O  
ATOM     37  OE2 GLU     2      67.939  28.848  11.807  0.50 22.68           O  
ATOM     39  N   VAL     3      67.080  25.094  15.539  1.00 12.23           N  
ATOM     40  CA  VAL     3      66.026  25.376  16.481  1.00 13.56           C  
ATOM     41  C   VAL     3      65.361  26.692  16.082  1.00 12.40           C  
ATOM     42  O   VAL     3      66.032  27.745  16.061  1.00 16.27           O  
ATOM     43  CB  VAL     3      66.529  25.431  17.946  1.00 13.90           C  
ATOM     44  CG1 VAL     3      65.344  25.753  18.834  1.00 14.87           C  
ATOM     45  CG2 VAL     3      67.202  24.123  18.328  1.00 14.37           C  
ATOM     46  N   ILE     4      64.073  26.663  15.736  1.00 12.65           N  
ATOM     47  CA  ILE     4      63.358  27.857  15.350  1.00 13.50           C  
ATOM     48  C   ILE     4      62.461  28.181  16.515  1.00 15.47           C  
ATOM     49  O   ILE     4      61.506  27.456  16.841  1.00 15.38           O  
ATOM     50  CB  ILE     4      62.549  27.635  14.046  1.00 14.09           C  
ATOM     51  CG1 ILE     4      63.443  27.091  12.952  1.00 15.02           C  
ATOM     52  CG2 ILE     4      61.837  28.887  13.632  1.00 15.59           C  
ATOM     53  CD1 ILE     4      64.508  28.046  12.454  1.00 16.96           C  
ATOM     54  N   GLU     5      62.618  29.353  17.062  0.50 19.47           N  
ATOM     56  CA  GLU     5      61.590  29.677  17.942  0.50 21.45           C  
ATOM     58  C   GLU     5      60.666  30.747  17.550  0.50 18.78           C  
ATOM     60  O   GLU     5      60.695  31.430  16.496  0.50 20.10           O  
ATOM     62  CB  GLU     5      62.019  29.767  19.388  0.50 23.79           C  
ATOM     64  CG  GLU     5      63.414  30.091  19.683  0.50 25.36           C  
ATOM     66  CD  GLU     5      63.510  30.504  21.113  0.50 27.34           C  
ATOM     68  OE1 GLU     5      62.512  31.075  21.595  0.50 28.37           O  
ATOM     70  OE2 GLU     5      64.546  30.248  21.766  0.50 30.40           O  
ATOM     72  N   SER     6      59.737  30.836  18.439  0.50 16.20           N  
ATOM     74  CA  SER     6      58.858  31.880  18.362  0.50 14.41           C  
ATOM     76  C   SER     6      58.359  32.083  19.765  0.50 13.57           C  
ATOM     78  O   SER     6      58.312  31.162  20.600  0.50 11.15           O  
ATOM     80  CB  SER     6      57.767  31.492  17.420  0.50 11.23           C  
ATOM     82  OG  SER     6      58.328  31.261  16.081  0.50 12.61           O  
ATOM     84  N   LYS     7      57.976  33.317  20.026  0.50 13.18           N  
ATOM     86  CA  LYS     7      57.412  33.645  21.305  0.50 15.34           C  
ATOM     88  C   LYS     7      56.355  34.664  21.091  0.50 14.65           C  
ATOM     90  O   LYS     7      56.470  35.571  20.260  0.50 14.62           O  
ATOM     92  CB  LYS     7      58.442  34.141  22.330  0.50 17.49           C  
ATOM     94  CG  LYS     7      59.205  32.973  22.977  0.50 19.63           C  
ATOM     96  CD  LYS     7      60.060  33.425  24.115  0.50 19.77           C  
ATOM     98  CE  LYS     7      61.126  32.427  24.422  0.50 21.57           C  
ATOM    100  NZ  LYS     7      61.930  32.902  25.548  0.50 21.10           N  
ATOM    102  N   TRP     8      55.296  34.472  21.841  1.00 13.40           N  
ATOM    103  CA  TRP     8      54.200  35.451  21.968  1.00 13.23           C  
ATOM    104  C   TRP     8      54.114  35.867  23.417  1.00 13.71           C  
ATOM    105  O   TRP     8      54.038  35.027  24.300  1.00 13.17           O  
ATOM    106  CB  TRP     8      52.823  34.938  21.454  1.00 14.03           C  
ATOM    107  CG  TRP     8      51.855  36.026  21.384  1.00 14.89           C  
ATOM    108  CD1 TRP     8      50.865  36.293  22.268  1.00 16.25           C  
ATOM    109  CD2 TRP     8      51.799  37.026  20.398  1.00 14.06           C  
ATOM    110  NE1 TRP     8      50.226  37.435  21.934  1.00 14.87           N  
ATOM    111  CE2 TRP     8      50.777  37.925  20.797  1.00 14.28           C  
ATOM    112  CE3 TRP     8      52.558  37.307  19.272  1.00 15.98           C  
ATOM    113  CZ2 TRP     8      50.443  39.038  20.056  1.00 17.27           C  
ATOM    114  CZ3 TRP     8      52.207  38.475  18.530  1.00 16.70           C  
ATOM    115  CH2 TRP     8      51.163  39.270  18.930  1.00 17.14           C  
ATOM    116  N   TYR     9      54.185  37.158  23.677  1.00 12.68           N  
ATOM    117  CA  TYR     9      54.031  37.735  25.012  1.00 12.92           C  
ATOM    118  C   TYR     9      52.546  38.041  25.132  1.00 13.27           C  
ATOM    119  O   TYR     9      52.011  39.078  24.695  1.00 13.80           O  
ATOM    120  CB  TYR     9      54.945  38.953  25.145  1.00 12.99           C  
ATOM    121  CG  TYR     9      56.404  38.563  24.976  1.00 13.02           C  
ATOM    122  CD1 TYR     9      57.075  37.944  25.987  1.00 14.17           C  
ATOM    123  CD2 TYR     9      57.066  38.742  23.774  1.00 13.43           C  
ATOM    124  CE1 TYR     9      58.403  37.540  25.838  1.00 15.82           C  
ATOM    125  CE2 TYR     9      58.355  38.286  23.598  1.00 15.03           C  
ATOM    126  CZ  TYR     9      59.026  37.719  24.618  1.00 16.88           C  
ATOM    127  OH  TYR     9      60.378  37.329  24.492  1.00 17.83           O  
ATOM    128  N   LYS    10      51.868  37.076  25.702  1.00 14.03           N  
ATOM    129  CA  LYS    10      50.410  37.003  25.738  1.00 12.97           C  
ATOM    130  C   LYS    10      49.841  37.911  26.831  1.00 13.24           C  
ATOM    131  O   LYS    10      50.349  37.901  27.966  1.00 14.66           O  
ATOM    132  CB  LYS    10      49.991  35.554  26.010  1.00 13.81           C  
ATOM    133  CG  LYS    10      48.497  35.295  26.085  1.00 14.74           C  
ATOM    134  CD  LYS    10      48.135  34.054  26.920  1.00 12.17           C  
ATOM    135  CE  LYS    10      46.662  33.898  27.123  1.00 13.89           C  
ATOM    136  NZ  LYS    10      46.119  35.035  27.926  1.00 14.34           N  
ATOM    137  N   LYS    11      48.804  38.675  26.492  1.00 13.23           N  
ATOM    138  CA  LYS    11      48.060  39.479  27.463  1.00 14.14           C  
ATOM    139  C   LYS    11      46.795  38.722  27.831  1.00 14.15           C  
ATOM    140  O   LYS    11      46.363  37.785  27.156  1.00 14.12           O  
ATOM    141  CB  LYS    11      47.701  40.823  26.883  1.00 16.02           C  
ATOM    142  CG  LYS    11      48.927  41.669  26.563  1.00 16.25           C  
ATOM    143  CD  LYS    11      48.557  43.063  26.158  1.00 18.00           C  
ATOM    144  CE  LYS    11      49.745  43.978  25.912  1.00 20.65           C  
ATOM    145  NZ  LYS    11      50.356  44.569  27.159  1.00 23.94           N  
ATOM    146  N   ASP    12      46.150  39.181  28.900  1.00 14.18           N  
ATOM    147  CA  ASP    12      44.864  38.640  29.239  1.00 14.02           C  
ATOM    148  C   ASP    12      43.949  38.817  28.024  1.00 13.20           C  
ATOM    149  O   ASP    12      44.030  39.794  27.264  1.00 15.13           O  
ATOM    150  CB  ASP    12      44.249  39.411  30.414  1.00 16.15           C  
ATOM    151  CG  ASP    12      44.917  39.140  31.723  1.00 20.13           C  
ATOM    152  OD1 ASP    12      45.683  38.181  31.868  1.00 23.09           O  
ATOM    153  OD2 ASP    12      44.616  39.915  32.649  1.00 23.74           O  
ATOM    154  N   GLY    13      43.067  37.857  27.851  1.00 14.78           N  
ATOM    155  CA  GLY    13      42.089  37.917  26.788  1.00 13.60           C  
ATOM    156  C   GLY    13      41.142  39.071  26.903  1.00 14.37           C  
ATOM    157  O   GLY    13      40.819  39.582  27.973  1.00 15.53           O  
ATOM    158  N   ALA    14      40.693  39.483  25.723  1.00 14.37           N  
ATOM    159  CA  ALA    14      39.671  40.517  25.596  1.00 15.32           C  
ATOM    160  C   ALA    14      38.296  40.059  26.110  1.00 15.83           C  
ATOM    161  O   ALA    14      37.909  38.926  25.913  1.00 17.13           O  
ATOM    162  CB  ALA    14      39.534  40.951  24.109  1.00 16.01           C  
ATOM    163  N   SER    15      37.569  40.954  26.761  1.00 17.55           N  
ATOM    164  CA  SER    15      36.177  40.615  27.061  1.00 19.89           C  
ATOM    165  C   SER    15      35.402  40.545  25.761  1.00 20.41           C  
ATOM    166  O   SER    15      35.640  41.303  24.829  1.00 19.21           O  
ATOM    167  CB  SER    15      35.543  41.625  27.988  1.00 20.96           C  
ATOM    168  OG  SER    15      35.465  42.891  27.380  1.00 22.14           O  
ATOM    169  N   SER    16      34.440  39.637  25.702  1.00 21.90           N  
ATOM    170  CA  SER    16      33.592  39.576  24.534  1.00 23.16           C  
ATOM    171  C   SER    16      32.875  40.906  24.374  1.00 21.48           C  
ATOM    172  O   SER    16      32.622  41.346  23.260  1.00 22.62           O  
ATOM    173  CB  SER    16      32.571  38.441  24.628  1.00 24.86           C  
ATOM    174  OG  SER    16      31.740  38.671  25.731  1.00 28.38           O  
ATOM    175  N   ALA    17      32.540  41.550  25.485  1.00 21.21           N  
ATOM    176  CA  ALA    17      31.811  42.801  25.412  1.00 20.81           C  
ATOM    177  C   ALA    17      32.619  43.872  24.720  1.00 19.61           C  
ATOM    178  O   ALA    17      32.088  44.699  23.984  1.00 21.07           O  
ATOM    179  CB  ALA    17      31.393  43.281  26.820  1.00 22.27           C  
ATOM    180  N   SER    18      33.926  43.844  24.957  1.00 19.56           N  
ATOM    181  CA  SER    18      34.820  44.884  24.425  1.00 18.84           C  
ATOM    182  C   SER    18      34.906  44.730  22.891  1.00 18.43           C  
ATOM    183  O   SER    18      34.984  45.696  22.165  1.00 17.34           O  
ATOM    184  CB  SER    18      36.211  44.836  25.091  1.00 20.97           C  
ATOM    185  OG  SER    18      36.925  43.637  24.809  1.00 22.52           O  
ATOM    186  N   ILE    19      34.804  43.490  22.430  1.00 17.37           N  
ATOM    187  CA  ILE    19      34.880  43.205  20.991  1.00 16.63           C  
ATOM    188  C   ILE    19      33.559  43.629  20.374  1.00 18.32           C  
ATOM    189  O   ILE    19      33.498  44.249  19.331  1.00 17.31           O  
ATOM    190  CB  ILE    19      35.170  41.720  20.707  1.00 17.51           C  
ATOM    191  CG1 ILE    19      36.592  41.382  21.181  1.00 17.59           C  
ATOM    192  CG2 ILE    19      34.974  41.388  19.208  1.00 17.96           C  
ATOM    193  CD1 ILE    19      36.953  39.917  21.206  1.00 16.97           C  
ATOM    194  N   ASP    20      32.490  43.311  21.072  0.50 18.44           N  
ATOM    196  CA  ASP    20      31.169  43.652  20.596  0.50 19.42           C  
ATOM    198  C   ASP    20      31.012  45.169  20.501  0.50 19.05           C  
ATOM    200  O   ASP    20      30.356  45.679  19.597  0.50 19.79           O  
ATOM    202  CB  ASP    20      30.136  43.053  21.546  0.50 19.36           C  
ATOM    204  CG  ASP    20      28.729  43.365  21.140  0.50 20.14           C  
ATOM    206  OD1 ASP    20      28.359  43.148  19.961  0.50 20.78           O  
ATOM    208  OD2 ASP    20      27.996  43.830  22.022  0.50 20.76           O  
ATOM    210  N   ASP    21      31.627  45.881  21.437  1.00 18.85           N  
ATOM    211  CA  ASP    21      31.553  47.349  21.440  1.00 20.24           C  
ATOM    212  C   ASP    21      32.152  47.912  20.166  1.00 18.48           C  
ATOM    213  O   ASP    21      31.683  48.889  19.615  1.00 19.16           O  
ATOM    214  CB  ASP    21      32.309  47.953  22.615  1.00 23.37           C  
ATOM    215  CG  ASP    21      31.610  47.730  23.925  1.00 26.84           C  
ATOM    216  OD1 ASP    21      30.395  47.394  23.906  1.00 26.89           O  
ATOM    217  OD2 ASP    21      32.290  47.872  24.970  1.00 31.11           O  
ATOM    218  N   VAL    22      33.251  47.292  19.717  1.00 17.85           N  
ATOM    219  CA  VAL    22      33.913  47.775  18.517  1.00 17.18           C  
ATOM    220  C   VAL    22      33.100  47.436  17.281  1.00 16.87           C  
ATOM    221  O   VAL    22      32.931  48.273  16.383  1.00 18.02           O  
ATOM    222  CB  VAL    22      35.381  47.245  18.398  1.00 16.49           C  
ATOM    223  CG1 VAL    22      35.893  47.445  16.958  1.00 17.01           C  
ATOM    224  CG2 VAL    22      36.245  47.974  19.400  1.00 17.96           C  
ATOM    225  N   GLU    23      32.529  46.239  17.256  1.00 17.11           N  
ATOM    226  CA  GLU    23      31.677  45.836  16.139  1.00 16.74           C  
ATOM    227  C   GLU    23      30.473  46.773  16.032  1.00 17.60           C  
ATOM    228  O   GLU    23      30.056  47.141  14.946  1.00 19.01           O  
ATOM    229  CB  GLU    23      31.207  44.400  16.299  1.00 15.72           C  
ATOM    230  CG  GLU    23      32.351  43.390  16.055  1.00 16.61           C  
ATOM    231  CD  GLU    23      31.908  41.950  15.974  1.00 17.83           C  
ATOM    232  OE1 GLU    23      30.958  41.574  16.706  1.00 22.54           O  
ATOM    233  OE2 GLU    23      32.504  41.161  15.175  1.00 17.51           O  
ATOM    234  N   LYS    24      29.946  47.167  17.178  1.00 18.75           N  
ATOM    235  CA  LYS    24      28.793  48.070  17.179  1.00 20.49           C  
ATOM    236  C   LYS    24      29.187  49.411  16.605  1.00 21.65           C  
ATOM    237  O   LYS    24      28.470  49.994  15.783  1.00 22.63           O  
ATOM    238  CB  LYS    24      28.236  48.230  18.580  1.00 21.20           C  
ATOM    239  CG  LYS    24      27.547  46.950  19.044  1.00 23.03           C  
ATOM    240  CD  LYS    24      26.850  47.069  20.419  1.00 24.02           C  
ATOM    241  N   LEU    25      30.337  49.906  17.043  1.00 22.09           N  
ATOM    242  CA  LEU    25      30.845  51.205  16.589  1.00 22.64           C  
ATOM    243  C   LEU    25      31.147  51.189  15.093  1.00 25.01           C  
ATOM    244  O   LEU    25      31.017  52.203  14.420  1.00 25.62           O  
ATOM    245  CB  LEU    25      32.093  51.656  17.368  1.00 22.16           C  
ATOM    246  CG  LEU    25      31.843  52.160  18.792  1.00 22.05           C  
ATOM    247  CD1 LEU    25      33.142  52.363  19.599  1.00 21.67           C  
ATOM    248  CD2 LEU    25      31.032  53.457  18.765  1.00 22.46           C  
ATOM    249  N   LEU    26      31.557  50.039  14.579  1.00 27.41           N  
ATOM    250  CA  LEU    26      31.954  49.935  13.164  1.00 28.29           C  
ATOM    251  C   LEU    26      30.758  49.527  12.318  1.00 28.13           C  
ATOM    252  O   LEU    26      30.792  49.567  11.095  1.00 28.04           O  
ATOM    253  CB  LEU    26      33.093  48.936  12.973  1.00 29.91           C  
ATOM    254  CG  LEU    26      34.444  49.314  13.586  1.00 30.85           C  
ATOM    255  CD1 LEU    26      35.450  48.311  13.090  1.00 31.72           C  
ATOM    256  CD2 LEU    26      34.884  50.734  13.253  1.00 30.97           C  
ATOM    257  N   ASN    27      29.705  49.135  13.007  1.00 27.64           N  
ATOM    258  CA  ASN    27      28.519  48.616  12.353  1.00 28.44           C  
ATOM    259  C   ASN    27      28.876  47.532  11.359  1.00 27.96           C  
ATOM    260  O   ASN    27      28.378  47.487  10.242  1.00 27.16           O  
ATOM    261  CB  ASN    27      27.766  49.727  11.626  1.00 30.43           C  
ATOM    262  CG  ASN    27      26.347  49.299  11.248  1.00 33.40           C  
ATOM    263  OD1 ASN    27      25.752  48.446  11.921  1.00 35.36           O  
ATOM    264  ND2 ASN    27      25.802  49.874  10.166  1.00 34.40           N  
ATOM    265  N   THR    28      29.749  46.646  11.801  1.00 27.17           N  
ATOM    266  CA  THR    28      30.230  45.563  10.963  1.00 28.19           C  
ATOM    267  C   THR    28      30.715  44.440  11.863  1.00 26.67           C  
ATOM    268  O   THR    28      30.941  44.660  13.042  1.00 26.14           O  
ATOM    269  CB  THR    28      31.427  46.070  10.110  1.00 30.96           C  
ATOM    270  OG1 THR    28      31.737  45.138   9.070  1.00 33.90           O  
ATOM    271  CG2 THR    28      32.665  46.254  10.957  1.00 32.59           C  
ATOM    272  N   THR    29      30.906  43.250  11.308  1.00 24.61           N  
ATOM    273  CA  THR    29      31.494  42.163  12.099  1.00 24.20           C  
ATOM    274  C   THR    29      32.959  42.030  11.753  1.00 22.35           C  
ATOM    275  O   THR    29      33.373  42.211  10.593  1.00 22.68           O  
ATOM    276  CB  THR    29      30.746  40.817  11.925  1.00 26.42           C  
ATOM    277  OG1 THR    29      30.898  40.342  10.588  1.00 28.49           O  
ATOM    278  CG2 THR    29      29.260  41.009  12.201  1.00 25.49           C  
ATOM    279  N   LEU    30      33.734  41.776  12.788  1.00 18.67           N  
ATOM    280  CA  LEU    30      35.159  41.509  12.594  1.00 17.07           C  
ATOM    281  C   LEU    30      35.395  40.059  12.170  1.00 15.19           C  
ATOM    282  O   LEU    30      34.566  39.202  12.426  1.00 17.25           O  
ATOM    283  CB  LEU    30      35.940  41.810  13.860  1.00 16.65           C  
ATOM    284  CG  LEU    30      35.960  43.283  14.236  1.00 18.77           C  
ATOM    285  CD1 LEU    30      36.429  43.370  15.673  1.00 17.74           C  
ATOM    286  CD2 LEU    30      36.850  44.109  13.307  1.00 19.27           C  
ATOM    287  N   PRO    31      36.526  39.778  11.507  1.00 15.05           N  
ATOM    288  CA  PRO    31      36.810  38.390  11.165  1.00 15.14           C  
ATOM    289  C   PRO    31      36.874  37.479  12.382  1.00 15.60           C  
ATOM    290  O   PRO    31      37.424  37.833  13.418  1.00 15.81           O  
ATOM    291  CB  PRO    31      38.144  38.469  10.422  1.00 15.41           C  
ATOM    292  CG  PRO    31      38.196  39.852   9.868  1.00 15.95           C  
ATOM    293  CD  PRO    31      37.564  40.681  10.980  1.00 15.44           C  
ATOM    294  N   LYS    32      36.298  36.296  12.237  0.50 14.85           N  
ATOM    296  CA  LYS    32      36.165  35.375  13.349  0.50 14.70           C  
ATOM    298  C   LYS    32      37.490  34.960  13.955  0.50 13.64           C  
ATOM    300  O   LYS    32      37.604  34.830  15.178  0.50 14.64           O  
ATOM    302  CB  LYS    32      35.412  34.125  12.910  0.50 15.49           C  
ATOM    304  CG  LYS    32      33.928  34.342  12.642  0.50 16.15           C  
ATOM    306  N   GLN    33      38.493  34.715  13.109  1.00 12.93           N  
ATOM    307  CA  GLN    33      39.774  34.237  13.617  1.00 11.96           C  
ATOM    308  C   GLN    33      40.496  35.326  14.414  1.00 13.11           C  
ATOM    309  O   GLN    33      41.218  35.067  15.392  1.00 14.13           O  
ATOM    310  CB  GLN    33      40.699  33.712  12.511  1.00 12.42           C  
ATOM    311  CG  GLN    33      40.147  32.463  11.896  1.00 12.07           C  
ATOM    312  CD  GLN    33      41.041  31.828  10.899  1.00 13.06           C  
ATOM    313  OE1 GLN    33      42.040  32.404  10.540  1.00 13.23           O  
ATOM    314  NE2 GLN    33      40.660  30.643  10.380  1.00 13.48           N  
ATOM    315  N   TYR    34      40.340  36.546  13.951  1.00 13.18           N  
ATOM    316  CA  TYR    34      40.908  37.705  14.664  1.00 13.74           C  
ATOM    317  C   TYR    34      40.273  37.820  16.038  1.00 14.20           C  
ATOM    318  O   TYR    34      40.950  38.019  17.038  1.00 13.60           O  
ATOM    319  CB  TYR    34      40.678  38.978  13.831  1.00 13.17           C  
ATOM    320  CG  TYR    34      41.046  40.289  14.475  1.00 12.98           C  
ATOM    321  CD1 TYR    34      42.333  40.517  14.933  1.00 14.07           C  
ATOM    322  CD2 TYR    34      40.114  41.314  14.576  1.00 13.26           C  
ATOM    323  CE1 TYR    34      42.673  41.690  15.525  1.00 14.11           C  
ATOM    324  CE2 TYR    34      40.442  42.504  15.133  1.00 13.82           C  
ATOM    325  CZ  TYR    34      41.729  42.712  15.576  1.00 13.46           C  
ATOM    326  OH  TYR    34      42.008  43.944  16.149  1.00 14.03           O  
ATOM    327  N   LYS    35      38.948  37.698  16.096  1.00 13.90           N  
ATOM    328  CA  LYS    35      38.232  37.746  17.370  1.00 14.57           C  
ATOM    329  C   LYS    35      38.668  36.610  18.306  1.00 13.49           C  
ATOM    330  O   LYS    35      38.836  36.793  19.492  1.00 14.35           O  
ATOM    331  CB  LYS    35      36.734  37.737  17.184  1.00 15.39           C  
ATOM    332  CG  LYS    35      36.241  39.026  16.567  1.00 15.92           C  
ATOM    333  CD  LYS    35      34.708  39.115  16.569  1.00 17.11           C  
ATOM    334  CE  LYS    35      34.078  38.218  15.518  1.00 17.77           C  
ATOM    335  NZ  LYS    35      32.587  38.445  15.435  1.00 18.85           N  
ATOM    336  N   SER    36      38.838  35.427  17.748  0.50 12.88           N  
ATOM    338  CA  SER    36      39.240  34.278  18.559  0.50 11.79           C  
ATOM    340  C   SER    36      40.601  34.564  19.178  0.50 13.48           C  
ATOM    342  O   SER    36      40.851  34.241  20.331  0.50 13.85           O  
ATOM    344  CB  SER    36      39.268  33.005  17.726  0.50 12.74           C  
ATOM    346  OG  SER    36      37.949  32.658  17.342  0.50 10.52           O  
ATOM    348  N   PHE    37      41.476  35.187  18.406  1.00 13.33           N  
ATOM    349  CA  PHE    37      42.855  35.496  18.903  1.00 12.77           C  
ATOM    350  C   PHE    37      42.748  36.533  20.016  1.00 13.96           C  
ATOM    351  O   PHE    37      43.329  36.354  21.091  1.00 13.88           O  
ATOM    352  CB  PHE    37      43.766  35.990  17.787  1.00 12.87           C  
ATOM    353  CG  PHE    37      45.160  36.232  18.241  1.00 13.96           C  
ATOM    354  CD1 PHE    37      46.036  35.184  18.323  1.00 13.93           C  
ATOM    355  CD2 PHE    37      45.571  37.494  18.687  1.00 15.62           C  
ATOM    356  CE1 PHE    37      47.339  35.383  18.756  1.00 14.92           C  
ATOM    357  CE2 PHE    37      46.913  37.688  19.105  1.00 14.64           C  
ATOM    358  CZ  PHE    37      47.756  36.627  19.153  1.00 15.32           C  
ATOM    359  N   LEU    38      41.933  37.555  19.785  1.00 13.18           N  
ATOM    360  CA  LEU    38      41.755  38.598  20.834  1.00 13.90           C  
ATOM    361  C   LEU    38      41.190  38.043  22.133  1.00 13.70           C  
ATOM    362  O   LEU    38      41.524  38.524  23.222  1.00 14.54           O  
ATOM    363  CB  LEU    38      40.889  39.736  20.340  1.00 13.21           C  
ATOM    364  CG  LEU    38      41.407  40.632  19.242  1.00 13.08           C  
ATOM    365  CD1 LEU    38      40.335  41.582  18.730  1.00 15.33           C  
ATOM    366  CD2 LEU    38      42.611  41.439  19.692  1.00 14.76           C  
ATOM    367  N   LEU    39      40.272  37.095  22.014  1.00 14.31           N  
ATOM    368  CA  LEU    39      39.689  36.449  23.201  1.00 13.53           C  
ATOM    369  C   LEU    39      40.736  35.706  24.008  1.00 14.10           C  
ATOM    370  O   LEU    39      40.575  35.479  25.221  1.00 13.88           O  
ATOM    371  CB  LEU    39      38.530  35.486  22.828  1.00 14.74           C  
ATOM    372  CG  LEU    39      37.285  36.213  22.346  1.00 14.83           C  
ATOM    373  CD1 LEU    39      36.340  35.189  21.686  1.00 15.63           C  
ATOM    374  CD2 LEU    39      36.575  36.951  23.486  1.00 14.60           C  
ATOM    375  N   TRP    40      41.817  35.331  23.322  1.00 13.93           N  
ATOM    376  CA  TRP    40      42.950  34.662  23.961  1.00 13.17           C  
ATOM    377  C   TRP    40      43.964  35.651  24.505  1.00 14.76           C  
ATOM    378  O   TRP    40      44.440  35.525  25.633  1.00 14.49           O  
ATOM    379  CB  TRP    40      43.586  33.691  22.982  1.00 12.79           C  
ATOM    380  CG  TRP    40      44.805  32.988  23.490  1.00 12.62           C  
ATOM    381  CD1 TRP    40      44.841  31.964  24.388  1.00 13.92           C  
ATOM    382  CD2 TRP    40      46.159  33.217  23.079  1.00 12.44           C  
ATOM    383  NE1 TRP    40      46.135  31.564  24.583  1.00 13.71           N  
ATOM    384  CE2 TRP    40      46.971  32.335  23.830  1.00 12.03           C  
ATOM    385  CE3 TRP    40      46.759  34.103  22.195  1.00 13.37           C  
ATOM    386  CZ2 TRP    40      48.328  32.266  23.681  1.00 12.34           C  
ATOM    387  CZ3 TRP    40      48.142  34.042  22.055  1.00 13.05           C  
ATOM    388  CH2 TRP    40      48.903  33.118  22.773  1.00 14.08           C  
ATOM    389  N   SER    41      44.304  36.622  23.679  1.00 14.01           N  
ATOM    390  CA  SER    41      45.302  37.652  24.019  1.00 14.04           C  
ATOM    391  C   SER    41      44.819  38.977  23.475  1.00 14.15           C  
ATOM    392  O   SER    41      44.762  39.158  22.282  1.00 14.07           O  
ATOM    393  CB  SER    41      46.676  37.315  23.436  1.00 13.97           C  
ATOM    394  OG  SER    41      47.664  38.308  23.748  1.00 14.01           O  
ATOM    395  N   ASN    42      44.497  39.927  24.357  1.00 12.89           N  
ATOM    396  CA  ASN    42      43.956  41.213  23.922  1.00 13.07           C  
ATOM    397  C   ASN    42      45.082  42.138  23.479  1.00 13.78           C  
ATOM    398  O   ASN    42      45.496  43.072  24.168  1.00 14.91           O  
ATOM    399  CB  ASN    42      43.123  41.859  25.028  1.00 13.69           C  
ATOM    400  CG  ASN    42      42.426  43.091  24.543  1.00 14.44           C  
ATOM    401  OD1 ASN    42      42.354  43.333  23.359  1.00 13.82           O  
ATOM    402  ND2 ASN    42      41.972  43.910  25.469  1.00 14.33           N  
ATOM    403  N   GLY    43      45.614  41.819  22.316  0.50 14.40           N  
ATOM    405  CA  GLY    43      46.841  42.423  21.865  0.50 13.29           C  
ATOM    407  C   GLY    43      47.997  41.689  22.496  0.50 13.62           C  
ATOM    409  O   GLY    43      47.836  40.714  23.190  0.50 13.14           O  
ATOM    411  N   GLY    44      49.154  42.293  22.381  1.00 16.08           N  
ATOM    412  CA  GLY    44      50.406  41.635  22.779  1.00 14.64           C  
ATOM    413  C   GLY    44      51.365  41.810  21.642  1.00 13.90           C  
ATOM    414  O   GLY    44      51.105  42.491  20.666  1.00 14.57           O  
ATOM    415  N   GLU    45      52.516  41.191  21.795  1.00 11.93           N  
ATOM    416  CA  GLU    45      53.553  41.273  20.773  1.00 13.06           C  
ATOM    417  C   GLU    45      54.364  40.031  20.832  1.00 11.82           C  
ATOM    418  O   GLU    45      54.375  39.309  21.846  1.00 12.43           O  
ATOM    419  CB  GLU    45      54.412  42.516  20.925  1.00 13.91           C  
ATOM    420  CG  GLU    45      55.544  42.455  21.872  1.00 14.41           C  
ATOM    421  CD  GLU    45      55.216  42.292  23.341  1.00 15.53           C  
ATOM    422  OE1 GLU    45      54.118  42.693  23.765  1.00 16.79           O  
ATOM    423  OE2 GLU    45      56.118  41.839  24.105  1.00 15.15           O  
ATOM    424  N   GLY    46      55.089  39.776  19.765  1.00 11.93           N  
ATOM    425  CA  GLY    46      55.928  38.587  19.735  1.00 13.17           C  
ATOM    426  C   GLY    46      56.876  38.580  18.572  1.00 11.53           C  
ATOM    427  O   GLY    46      56.964  39.544  17.789  1.00 12.14           O  
ATOM    428  N   LYS    47      57.710  37.553  18.566  1.00 12.63           N  
ATOM    429  CA  LYS    47      58.633  37.310  17.463  1.00 13.89           C  
ATOM    430  C   LYS    47      58.286  35.917  16.947  1.00 13.38           C  
ATOM    431  O   LYS    47      58.562  34.940  17.633  1.00 13.18           O  
ATOM    432  CB  LYS    47      60.067  37.426  17.940  1.00 13.94           C  
ATOM    433  CG  LYS    47      61.085  37.363  16.794  1.00 14.02           C  
ATOM    434  CD  LYS    47      62.512  37.238  17.256  1.00 16.09           C  
ATOM    435  CE  LYS    47      63.407  37.362  16.048  1.00 18.59           C  
ATOM    436  NZ  LYS    47      64.846  37.400  16.455  1.00 20.34           N  
ATOM    437  N   LEU    48      57.651  35.864  15.784  1.00 13.16           N  
ATOM    438  CA  LEU    48      57.183  34.609  15.173  1.00 12.79           C  
ATOM    439  C   LEU    48      58.141  34.351  14.033  1.00 14.27           C  
ATOM    440  O   LEU    48      58.172  35.130  13.096  1.00 13.31           O  
ATOM    441  CB  LEU    48      55.715  34.727  14.748  1.00 14.42           C  
ATOM    442  CG  LEU    48      54.709  35.030  15.858  1.00 16.75           C  
ATOM    443  CD1 LEU    48      53.288  34.973  15.278  1.00 18.48           C  
ATOM    444  CD2 LEU    48      54.814  34.053  17.029  1.00 19.65           C  
ATOM    445  N   GLY    49      58.953  33.310  14.176  1.00 14.02           N  
ATOM    446  CA  GLY    49      60.055  33.186  13.248  1.00 13.43           C  
ATOM    447  C   GLY    49      60.914  34.423  13.272  1.00 14.95           C  
ATOM    448  O   GLY    49      61.401  34.835  14.310  1.00 15.04           O  
ATOM    449  N   ASP    50      61.162  34.979  12.104  1.00 14.39           N  
ATOM    450  CA  ASP    50      61.976  36.182  11.967  1.00 15.94           C  
ATOM    451  C   ASP    50      61.164  37.455  12.064  1.00 15.36           C  
ATOM    452  O   ASP    50      61.738  38.536  11.928  1.00 15.39           O  
ATOM    453  CB  ASP    50      62.697  36.196  10.621  1.00 17.21           C  
ATOM    454  CG  ASP    50      63.717  35.088  10.474  1.00 20.73           C  
ATOM    455  OD1 ASP    50      64.297  34.641  11.471  1.00 21.99           O  
ATOM    456  OD2 ASP    50      63.925  34.716   9.309  1.00 26.03           O  
ATOM    457  N   ASN    51      59.869  37.318  12.300  1.00 13.01           N  
ATOM    458  CA  ASN    51      58.941  38.443  12.229  1.00 12.00           C  
ATOM    459  C   ASN    51      58.531  39.036  13.565  1.00 12.08           C  
ATOM    460  O   ASN    51      57.975  38.337  14.399  1.00 12.85           O  
ATOM    461  CB  ASN    51      57.645  38.014  11.517  1.00 12.04           C  
ATOM    462  CG  ASN    51      57.897  37.399  10.183  1.00 12.76           C  
ATOM    463  OD1 ASN    51      58.248  38.116   9.248  1.00 13.35           O  
ATOM    464  ND2 ASN    51      57.633  36.080  10.048  1.00 13.58           N  
ATOM    465  N   TYR    52      58.875  40.295  13.813  1.00 11.68           N  
ATOM    466  CA  TYR    52      58.347  41.034  14.945  1.00 12.17           C  
ATOM    467  C   TYR    52      56.983  41.550  14.620  1.00 12.37           C  
ATOM    468  O   TYR    52      56.764  42.161  13.585  1.00 12.81           O  
ATOM    469  CB  TYR    52      59.263  42.189  15.330  1.00 12.33           C  
ATOM    470  CG  TYR    52      60.596  41.732  15.869  1.00 12.95           C  
ATOM    471  CD1 TYR    52      60.681  41.260  17.141  1.00 13.75           C  
ATOM    472  CD2 TYR    52      61.763  41.751  15.091  1.00 14.38           C  
ATOM    473  CE1 TYR    52      61.884  40.796  17.638  1.00 12.24           C  
ATOM    474  CE2 TYR    52      62.949  41.274  15.589  1.00 15.35           C  
ATOM    475  CZ  TYR    52      62.998  40.802  16.856  1.00 12.72           C  
ATOM    476  OH  TYR    52      64.185  40.325  17.428  1.00 15.46           O  
ATOM    477  N   ILE    53      56.032  41.228  15.475  1.00 13.24           N  
ATOM    478  CA  ILE    53      54.656  41.594  15.249  1.00 14.29           C  
ATOM    479  C   ILE    53      54.093  42.174  16.555  1.00 13.70           C  
ATOM    480  O   ILE    53      54.211  41.561  17.596  1.00 13.82           O  
ATOM    481  CB  ILE    53      53.822  40.363  14.843  1.00 14.96           C  
ATOM    482  CG1 ILE    53      54.344  39.789  13.516  1.00 15.53           C  
ATOM    483  CG2 ILE    53      52.329  40.716  14.683  1.00 17.77           C  
ATOM    484  CD1 ILE    53      53.851  38.296  13.238  1.00 17.66           C  
ATOM    485  N   TYR    54      53.488  43.360  16.487  1.00 12.74           N  
ATOM    486  CA  TYR    54      52.908  44.050  17.616  1.00 11.92           C  
ATOM    487  C   TYR    54      51.395  44.207  17.284  1.00 11.84           C  
ATOM    488  O   TYR    54      51.038  44.892  16.301  1.00 14.15           O  
ATOM    489  CB  TYR    54      53.599  45.415  17.835  1.00 12.36           C  
ATOM    490  CG  TYR    54      55.109  45.343  17.895  1.00 12.82           C  
ATOM    491  CD1 TYR    54      55.867  45.331  16.723  1.00 13.43           C  
ATOM    492  CD2 TYR    54      55.780  45.344  19.109  1.00 14.98           C  
ATOM    493  CE1 TYR    54      57.274  45.265  16.742  1.00 14.40           C  
ATOM    494  CE2 TYR    54      57.159  45.296  19.141  1.00 13.05           C  
ATOM    495  CZ  TYR    54      57.924  45.243  17.954  1.00 14.98           C  
ATOM    496  OH  TYR    54      59.321  45.217  17.989  1.00 16.28           O  
ATOM    497  N   ILE    55      50.524  43.570  18.068  1.00 13.02           N  
ATOM    498  CA  ILE    55      49.072  43.579  17.836  1.00 12.45           C  
ATOM    499  C   ILE    55      48.399  44.448  18.908  1.00 12.54           C  
ATOM    500  O   ILE    55      48.754  44.383  20.079  1.00 14.17           O  
ATOM    501  CB  ILE    55      48.526  42.160  17.806  1.00 13.86           C  
ATOM    502  CG1 ILE    55      49.109  41.429  16.598  1.00 14.55           C  
ATOM    503  CG2 ILE    55      47.007  42.130  17.711  1.00 14.87           C  
ATOM    504  CD1 ILE    55      48.703  39.926  16.436  1.00 17.09           C  
ATOM    505  N   TRP    56      47.474  45.287  18.483  1.00 11.97           N  
ATOM    506  CA  TRP    56      46.757  46.231  19.350  1.00 13.39           C  
ATOM    507  C   TRP    56      45.644  45.582  20.142  1.00 13.32           C  
ATOM    508  O   TRP    56      44.959  44.693  19.690  1.00 13.12           O  
ATOM    509  CB  TRP    56      46.240  47.372  18.480  1.00 13.03           C  
ATOM    510  CG  TRP    56      47.324  48.036  17.702  1.00 12.97           C  
ATOM    511  CD1 TRP    56      48.636  48.251  18.093  1.00 13.60           C  
ATOM    512  CD2 TRP    56      47.199  48.610  16.413  1.00 12.16           C  
ATOM    513  NE1 TRP    56      49.313  48.914  17.102  1.00 13.48           N  
ATOM    514  CE2 TRP    56      48.470  49.104  16.053  1.00 10.97           C  
ATOM    515  CE3 TRP    56      46.152  48.732  15.507  1.00 13.79           C  
ATOM    516  CZ2 TRP    56      48.695  49.747  14.861  1.00 12.74           C  
ATOM    517  CZ3 TRP    56      46.385  49.340  14.312  1.00 12.96           C  
ATOM    518  CH2 TRP    56      47.650  49.847  14.001  1.00 12.70           C  
ATOM    519  N   ALA    57      45.461  46.087  21.348  1.00 11.92           N  
ATOM    520  CA  ALA    57      44.280  45.764  22.143  1.00 13.05           C  
ATOM    521  C   ALA    57      43.045  46.299  21.427  1.00 13.19           C  
ATOM    522  O   ALA    57      43.049  47.332  20.758  1.00 13.62           O  
ATOM    523  CB  ALA    57      44.363  46.402  23.488  1.00 14.60           C  
ATOM    524  N   ILE    58      41.938  45.576  21.579  1.00 13.88           N  
ATOM    525  CA  ILE    58      40.726  45.897  20.832  1.00 14.96           C  
ATOM    526  C   ILE    58      40.225  47.308  21.132  1.00 14.48           C  
ATOM    527  O   ILE    58      39.722  47.993  20.249  1.00 15.35           O  
ATOM    528  CB  ILE    58      39.617  44.822  21.033  1.00 15.65           C  
ATOM    529  CG1 ILE    58      38.439  45.000  20.036  1.00 16.26           C  
ATOM    530  CG2 ILE    58      39.138  44.795  22.484  1.00 16.59           C  
ATOM    531  CD1 ILE    58      38.858  45.073  18.617  1.00 17.21           C  
ATOM    532  N   GLU    59      40.433  47.732  22.375  0.50 14.11           N  
ATOM    534  CA  GLU    59      39.980  49.049  22.856  0.50 14.34           C  
ATOM    536  C   GLU    59      40.746  50.190  22.199  0.50 14.33           C  
ATOM    538  O   GLU    59      40.326  51.351  22.280  0.50 14.86           O  
ATOM    540  CB  GLU    59      40.148  49.145  24.383  0.50 14.29           C  
ATOM    542  CG  GLU    59      39.267  48.187  25.188  0.50 14.32           C  
ATOM    544  CD  GLU    59      39.868  46.826  25.453  0.50 14.14           C  
ATOM    546  OE1 GLU    59      40.973  46.559  24.927  0.50 13.02           O  
ATOM    548  OE2 GLU    59      39.214  46.020  26.190  0.50 14.20           O  
ATOM    550  N   ASP    60      41.859  49.847  21.540  1.00 13.35           N  
ATOM    551  CA  ASP    60      42.749  50.864  20.922  1.00 13.03           C  
ATOM    552  C   ASP    60      42.671  50.887  19.394  1.00 14.02           C  
ATOM    553  O   ASP    60      43.188  51.781  18.748  1.00 14.35           O  
ATOM    554  CB  ASP    60      44.217  50.664  21.327  1.00 15.18           C  
ATOM    555  CG  ASP    60      44.482  50.885  22.813  1.00 15.09           C  
ATOM    556  OD1 ASP    60      43.672  51.539  23.467  1.00 17.40           O  
ATOM    557  OD2 ASP    60      45.512  50.346  23.298  1.00 16.27           O  
ATOM    558  N   VAL    61      42.033  49.888  18.803  1.00 12.93           N  
ATOM    559  CA  VAL    61      42.069  49.711  17.354  1.00 12.83           C  
ATOM    560  C   VAL    61      41.463  50.868  16.589  1.00 12.87           C  
ATOM    561  O   VAL    61      41.999  51.329  15.614  1.00 15.70           O  
ATOM    562  CB  VAL    61      41.391  48.357  16.921  1.00 13.95           C  
ATOM    563  CG1 VAL    61      41.092  48.289  15.424  1.00 17.70           C  
ATOM    564  CG2 VAL    61      42.320  47.199  17.355  1.00 14.34           C  
ATOM    565  N   ILE    62      40.323  51.383  17.056  1.00 12.72           N  
ATOM    566  CA  ILE    62      39.707  52.505  16.331  1.00 14.31           C  
ATOM    567  C   ILE    62      40.612  53.750  16.358  1.00 13.02           C  
ATOM    568  O   ILE    62      40.824  54.389  15.330  1.00 14.03           O  
ATOM    569  CB  ILE    62      38.297  52.810  16.888  1.00 14.62           C  
ATOM    570  CG1 ILE    62      37.354  51.623  16.639  1.00 16.27           C  
ATOM    571  CG2 ILE    62      37.700  54.130  16.316  1.00 16.73           C  
ATOM    572  CD1 ILE    62      35.964  51.770  17.265  1.00 18.13           C  
ATOM    573  N   ALA    63      41.176  54.066  17.515  1.00 13.53           N  
ATOM    574  CA  ALA    63      42.056  55.223  17.636  1.00 13.80           C  
ATOM    575  C   ALA    63      43.314  55.086  16.801  1.00 14.43           C  
ATOM    576  O   ALA    63      43.774  56.040  16.168  1.00 13.77           O  
ATOM    577  CB  ALA    63      42.447  55.470  19.101  1.00 14.27           C  
ATOM    578  N   TYR    64      43.922  53.903  16.781  1.00 14.24           N  
ATOM    579  CA  TYR    64      45.092  53.700  15.927  1.00 13.92           C  
ATOM    580  C   TYR    64      44.750  53.860  14.456  1.00 13.92           C  
ATOM    581  O   TYR    64      45.527  54.408  13.708  1.00 12.86           O  
ATOM    582  CB  TYR    64      45.735  52.336  16.128  1.00 12.46           C  
ATOM    583  CG  TYR    64      46.682  52.178  17.306  1.00 12.09           C  
ATOM    584  CD1 TYR    64      47.813  52.942  17.436  1.00 12.23           C  
ATOM    585  CD2 TYR    64      46.383  51.308  18.338  1.00 13.39           C  
ATOM    586  CE1 TYR    64      48.673  52.760  18.482  1.00 12.20           C  
ATOM    587  CE2 TYR    64      47.210  51.152  19.408  1.00 13.36           C  
ATOM    588  CZ  TYR    64      48.365  51.897  19.495  1.00 12.01           C  
ATOM    589  OH  TYR    64      49.262  51.746  20.551  1.00 15.59           O  
ATOM    590  N   ASN    65      43.648  53.266  14.045  1.00 13.19           N  
ATOM    591  CA  ASN    65      43.232  53.376  12.623  1.00 13.32           C  
ATOM    592  C   ASN    65      43.016  54.832  12.238  1.00 13.29           C  
ATOM    593  O   ASN    65      43.389  55.264  11.135  1.00 14.41           O  
ATOM    594  CB  ASN    65      42.002  52.538  12.312  1.00 12.09           C  
ATOM    595  CG  ASN    65      42.369  51.111  12.021  1.00 13.49           C  
ATOM    596  OD1 ASN    65      42.543  50.751  10.852  1.00 13.13           O  
ATOM    597  ND2 ASN    65      42.567  50.293  13.058  1.00 13.51           N  
ATOM    598  N   HIS    66      42.434  55.604  13.157  1.00 14.30           N  
ATOM    599  CA  HIS    66      42.223  57.025  12.874  1.00 14.15           C  
ATOM    600  C   HIS    66      43.562  57.752  12.787  1.00 14.82           C  
ATOM    601  O   HIS    66      43.815  58.570  11.921  1.00 16.07           O  
ATOM    602  CB  HIS    66      41.353  57.675  13.944  1.00 16.52           C  
ATOM    603  CG  HIS    66      41.268  59.167  13.810  1.00 21.64           C  
ATOM    604  ND1 HIS    66      40.545  59.785  12.807  1.00 24.68           N  
ATOM    605  CD2 HIS    66      41.857  60.162  14.515  1.00 23.98           C  
ATOM    606  CE1 HIS    66      40.670  61.096  12.923  1.00 25.26           C  
ATOM    607  NE2 HIS    66      41.450  61.353  13.959  1.00 26.19           N  
ATOM    608  N   ASP    67      44.470  57.452  13.725  1.00 14.48           N  
ATOM    609  CA  ASP    67      45.723  58.196  13.770  1.00 14.19           C  
ATOM    610  C   ASP    67      46.588  57.903  12.521  1.00 14.23           C  
ATOM    611  O   ASP    67      47.265  58.782  11.994  1.00 15.60           O  
ATOM    612  CB  ASP    67      46.550  57.807  15.017  1.00 15.84           C  
ATOM    613  CG  ASP    67      47.853  58.591  15.110  1.00 17.86           C  
ATOM    614  OD1 ASP    67      47.738  59.772  15.410  1.00 20.95           O  
ATOM    615  OD2 ASP    67      48.911  57.989  14.815  1.00 21.77           O  
ATOM    616  N   TYR    68      46.567  56.662  12.028  1.00 13.87           N  
ATOM    617  CA  TYR    68      47.413  56.280  10.879  1.00 14.26           C  
ATOM    618  C   TYR    68      46.727  56.581   9.547  1.00 15.70           C  
ATOM    619  O   TYR    68      47.359  56.492   8.488  1.00 18.34           O  
ATOM    620  CB  TYR    68      47.799  54.788  10.928  1.00 14.94           C  
ATOM    621  CG  TYR    68      48.798  54.418  11.983  1.00 14.50           C  
ATOM    622  CD1 TYR    68      50.092  54.897  11.931  1.00 13.72           C  
ATOM    623  CD2 TYR    68      48.470  53.558  13.033  1.00 14.46           C  
ATOM    624  CE1 TYR    68      51.017  54.567  12.909  1.00 14.37           C  
ATOM    625  CE2 TYR    68      49.418  53.187  13.973  1.00 14.23           C  
ATOM    626  CZ  TYR    68      50.692  53.685  13.895  1.00 13.88           C  
ATOM    627  OH  TYR    68      51.638  53.350  14.865  1.00 15.52           O  
ATOM    628  N   GLY    69      45.455  56.929   9.634  1.00 14.54           N  
ATOM    629  CA  GLY    69      44.685  57.302   8.440  1.00 14.39           C  
ATOM    630  C   GLY    69      44.376  56.124   7.551  1.00 15.46           C  
ATOM    631  O   GLY    69      44.293  56.226   6.325  1.00 15.37           O  
ATOM    632  N   ILE    70      44.128  54.986   8.151  1.00 15.21           N  
ATOM    633  CA  ILE    70      44.030  53.754   7.358  1.00 14.89           C  
ATOM    634  C   ILE    70      42.842  53.815   6.400  1.00 15.33           C  
ATOM    635  O   ILE    70      42.962  53.513   5.216  1.00 17.04           O  
ATOM    636  CB  ILE    70      43.889  52.515   8.256  1.00 14.94           C  
ATOM    637  CG1 ILE    70      45.113  52.404   9.174  1.00 15.34           C  
ATOM    638  CG2 ILE    70      43.692  51.205   7.439  1.00 15.18           C  
ATOM    639  CD1 ILE    70      46.430  52.220   8.477  1.00 16.11           C  
ATOM    640  N   GLN    71      41.706  54.230   6.923  1.00 16.99           N  
ATOM    641  CA  GLN    71      40.459  54.244   6.111  1.00 18.78           C  
ATOM    642  C   GLN    71      40.486  55.417   5.139  1.00 20.28           C  
ATOM    643  O   GLN    71      39.962  55.333   4.028  1.00 21.20           O  
ATOM    644  CB  GLN    71      39.208  54.275   7.000  1.00 18.50           C  
ATOM    645  CG  GLN    71      38.971  52.982   7.740  1.00 18.76           C  
ATOM    646  CD  GLN    71      39.963  52.782   8.855  1.00 17.48           C  
ATOM    647  OE1 GLN    71      40.253  53.716   9.621  1.00 17.97           O  
ATOM    648  NE2 GLN    71      40.536  51.573   8.924  1.00 15.26           N  
ATOM    649  N   LYS    72      41.144  56.476   5.556  1.00 20.12           N  
ATOM    650  CA  LYS    72      41.321  57.655   4.713  1.00 23.17           C  
ATOM    651  C   LYS    72      42.074  57.325   3.451  1.00 22.99           C  
ATOM    652  O   LYS    72      41.691  57.733   2.352  1.00 23.94           O  
ATOM    653  CB  LYS    72      42.086  58.727   5.464  1.00 25.09           C  
ATOM    654  CG  LYS    72      42.606  59.847   4.599  1.00 28.00           C  
ATOM    655  CD  LYS    72      42.954  61.055   5.459  1.00 29.55           C  
ATOM    656  CE  LYS    72      44.139  60.821   6.363  1.00 32.58           C  
ATOM    657  N   TYR    73      43.124  56.526   3.590  1.00 23.38           N  
ATOM    658  CA  TYR    73      44.015  56.262   2.469  1.00 24.65           C  
ATOM    659  C   TYR    73      43.688  54.976   1.764  1.00 24.45           C  
ATOM    660  O   TYR    73      43.912  54.849   0.568  1.00 27.45           O  
ATOM    661  CB  TYR    73      45.476  56.261   2.898  1.00 26.82           C  
ATOM    662  CG  TYR    73      45.985  57.640   3.191  1.00 28.85           C  
ATOM    663  CD1 TYR    73      46.319  58.496   2.158  1.00 31.18           C  
ATOM    664  CD2 TYR    73      46.088  58.098   4.476  1.00 29.73           C  
ATOM    665  CE1 TYR    73      46.762  59.758   2.405  1.00 31.52           C  
ATOM    666  CE2 TYR    73      46.542  59.365   4.743  1.00 31.36           C  
ATOM    667  CZ  TYR    73      46.877  60.196   3.696  1.00 32.04           C  
ATOM    668  OH  TYR    73      47.322  61.482   3.938  1.00 35.12           O  
ATOM    669  N   LEU    74      43.096  54.032   2.468  1.00 21.80           N  
ATOM    670  CA  LEU    74      42.838  52.740   1.855  1.00 23.02           C  
ATOM    671  C   LEU    74      41.426  52.800   1.472  1.00 25.70           C  
ATOM    672  O   LEU    74      41.075  53.555   0.571  1.00 29.21           O  
ATOM    673  CB  LEU    74      43.102  51.571   2.809  1.00 20.13           C  
ATOM    674  CG  LEU    74      44.614  51.512   3.039  1.00 20.37           C  
ATOM    675  CD1 LEU    74      44.965  50.269   3.827  1.00 18.22           C  
ATOM    676  CD2 LEU    74      45.388  51.546   1.729  1.00 21.97           C  
ATOM    677  N   GLN    75      40.632  52.032   2.191  1.00 28.08           N  
ATOM    678  CA  GLN    75      39.160  51.990   2.062  1.00 30.09           C  
ATOM    679  C   GLN    75      38.503  51.658   3.404  1.00 28.18           C  
ATOM    680  O   GLN    75      39.139  51.086   4.266  1.00 24.35           O  
ATOM    681  CB  GLN    75      38.764  50.908   1.054  1.00 33.00           C  
ATOM    682  CG  GLN    75      39.225  51.177  -0.381  1.00 35.71           C  
ATOM    683  CD  GLN    75      38.896  50.033  -1.350  1.00 37.86           C  
ATOM    684  OE1 GLN    75      38.359  48.978  -0.955  1.00 40.04           O  
ATOM    685  NE2 GLN    75      39.217  50.239  -2.630  1.00 39.24           N  
ATOM    686  N   LYS    76      37.225  51.971   3.556  1.00 24.98           N  
ATOM    687  CA  LYS    76      36.462  51.578   4.763  1.00 24.70           C  
ATOM    688  C   LYS    76      36.501  50.068   5.115  1.00 23.66           C  
ATOM    689  O   LYS    76      36.207  49.663   6.242  1.00 23.96           O  
ATOM    690  CB  LYS    76      34.993  51.998   4.639  1.00 25.98           C  
ATOM    691  CG  LYS    76      34.217  51.327   3.498  1.00 28.05           C  
ATOM    692  N   GLU    77      36.849  49.253   4.143  1.00 21.56           N  
ATOM    693  CA  GLU    77      36.788  47.789   4.306  1.00 20.93           C  
ATOM    694  C   GLU    77      38.085  47.236   4.915  1.00 19.17           C  
ATOM    695  O   GLU    77      38.172  46.065   5.289  1.00 19.66           O  
ATOM    696  CB  GLU    77      36.499  47.086   2.989  1.00 23.00           C  
ATOM    697  CG  GLU    77      35.138  47.492   2.406  1.00 25.27           C  
ATOM    698  CD  GLU    77      35.177  48.856   1.718  1.00 26.67           C  
ATOM    699  N   TYR    78      39.078  48.097   5.018  1.00 15.81           N  
ATOM    700  CA  TYR    78      40.422  47.674   5.475  1.00 14.75           C  
ATOM    701  C   TYR    78      40.672  48.268   6.843  1.00 14.03           C  
ATOM    702  O   TYR    78      40.432  49.444   7.055  1.00 15.21           O  
ATOM    703  CB  TYR    78      41.510  48.121   4.504  1.00 15.66           C  
ATOM    704  CG  TYR    78      41.492  47.428   3.181  1.00 16.77           C  
ATOM    705  CD1 TYR    78      42.167  46.224   2.976  1.00 16.46           C  
ATOM    706  CD2 TYR    78      40.832  48.013   2.099  1.00 18.20           C  
ATOM    707  CE1 TYR    78      42.135  45.610   1.718  1.00 18.57           C  
ATOM    708  CE2 TYR    78      40.801  47.402   0.874  1.00 19.09           C  
ATOM    709  CZ  TYR    78      41.445  46.214   0.695  1.00 20.19           C  
ATOM    710  OH  TYR    78      41.433  45.620  -0.550  1.00 21.48           O  
ATOM    711  N   TRP    79      41.085  47.427   7.779  1.00 14.24           N  
ATOM    712  CA  TRP    79      41.330  47.856   9.162  1.00 14.90           C  
ATOM    713  C   TRP    79      42.663  47.284   9.656  1.00 13.67           C  
ATOM    714  O   TRP    79      42.918  46.072   9.574  1.00 13.57           O  
ATOM    715  CB  TRP    79      40.192  47.426  10.092  1.00 15.97           C  
ATOM    716  CG  TRP    79      39.047  48.297   9.885  1.00 20.29           C  
ATOM    717  CD1 TRP    79      38.158  48.237   8.837  1.00 21.65           C  
ATOM    718  CD2 TRP    79      38.697  49.444  10.644  1.00 19.81           C  
ATOM    719  NE1 TRP    79      37.265  49.272   8.916  1.00 22.36           N  
ATOM    720  CE2 TRP    79      37.577  50.033  10.012  1.00 21.34           C  
ATOM    721  CE3 TRP    79      39.217  50.038  11.781  1.00 22.98           C  
ATOM    722  CZ2 TRP    79      36.977  51.182  10.500  1.00 23.25           C  
ATOM    723  CZ3 TRP    79      38.631  51.171  12.257  1.00 21.43           C  
ATOM    724  CH2 TRP    79      37.518  51.726  11.626  1.00 22.97           C  
ATOM    725  N   ALA    80      43.514  48.177  10.159  1.00 12.88           N  
ATOM    726  CA  ALA    80      44.795  47.791  10.744  1.00 13.90           C  
ATOM    727  C   ALA    80      44.561  47.183  12.108  1.00 14.62           C  
ATOM    728  O   ALA    80      43.734  47.650  12.906  1.00 13.50           O  
ATOM    729  CB  ALA    80      45.753  48.994  10.862  1.00 14.14           C  
ATOM    730  N   PHE    81      45.332  46.146  12.393  1.00 13.18           N  
ATOM    731  CA  PHE    81      45.242  45.470  13.690  1.00 14.00           C  
ATOM    732  C   PHE    81      46.560  45.401  14.414  1.00 12.92           C  
ATOM    733  O   PHE    81      46.609  44.973  15.584  1.00 12.79           O  
ATOM    734  CB  PHE    81      44.654  44.055  13.555  1.00 13.57           C  
ATOM    735  CG  PHE    81      45.452  43.105  12.716  1.00 12.90           C  
ATOM    736  CD1 PHE    81      46.494  42.372  13.279  1.00 12.80           C  
ATOM    737  CD2 PHE    81      45.196  42.929  11.359  1.00 11.64           C  
ATOM    738  CE1 PHE    81      47.230  41.463  12.511  1.00 13.35           C  
ATOM    739  CE2 PHE    81      45.942  42.037  10.591  1.00 12.86           C  
ATOM    740  CZ  PHE    81      46.962  41.325  11.183  1.00 13.86           C  
ATOM    741  N   GLY    82      47.629  45.821  13.728  1.00 12.34           N  
ATOM    742  CA  GLY    82      48.975  45.711  14.276  1.00 13.00           C  
ATOM    743  C   GLY    82      50.000  46.286  13.341  1.00 12.99           C  
ATOM    744  O   GLY    82      49.642  46.830  12.275  1.00 12.70           O  
ATOM    745  N   MET    83      51.252  46.150  13.733  1.00 12.37           N  
ATOM    746  CA  MET    83      52.329  46.749  12.984  1.00 12.15           C  
ATOM    747  C   MET    83      53.674  46.136  13.313  1.00 12.25           C  
ATOM    748  O   MET    83      53.811  45.341  14.259  1.00 12.42           O  
ATOM    749  CB  MET    83      52.327  48.280  13.220  1.00 14.54           C  
ATOM    750  CG  MET    83      52.444  48.713  14.702  1.00 13.99           C  
ATOM    751  SD  MET    83      54.199  48.615  15.534  0.75 10.31          SE  
ATOM    752  CE  MET    83      54.804  50.446  15.091  1.00 12.69           C  
ATOM    753  N   ASP    84      54.658  46.556  12.527  1.00 12.24           N  
ATOM    754  CA  ASP    84      56.069  46.336  12.832  1.00 12.92           C  
ATOM    755  C   ASP    84      56.866  47.537  12.309  1.00 11.99           C  
ATOM    756  O   ASP    84      57.257  47.602  11.137  1.00 13.20           O  
ATOM    757  CB  ASP    84      56.556  45.044  12.148  1.00 13.82           C  
ATOM    758  CG  ASP    84      58.075  44.879  12.288  1.00 15.39           C  
ATOM    759  OD1 ASP    84      58.621  45.464  13.262  1.00 17.77           O  
ATOM    760  OD2 ASP    84      58.660  44.134  11.430  1.00 16.66           O  
ATOM    761  N   GLY    85      57.017  48.545  13.156  1.00 13.45           N  
ATOM    762  CA  GLY    85      57.643  49.792  12.717  1.00 13.26           C  
ATOM    763  C   GLY    85      56.868  50.465  11.595  1.00 13.04           C  
ATOM    764  O   GLY    85      55.701  50.786  11.745  1.00 15.28           O  
ATOM    765  N   ASP    86      57.545  50.673  10.480  1.00 14.37           N  
ATOM    766  CA  ASP    86      56.925  51.309   9.313  1.00 15.15           C  
ATOM    767  C   ASP    86      55.765  50.445   8.728  1.00 15.51           C  
ATOM    768  O   ASP    86      54.910  50.980   8.018  1.00 16.68           O  
ATOM    769  CB  ASP    86      57.913  51.441   8.129  1.00 17.30           C  
ATOM    770  CG  ASP    86      59.073  52.402   8.355  1.00 20.31           C  
ATOM    771  OD1 ASP    86      59.053  53.231   9.272  1.00 19.77           O  
ATOM    772  OD2 ASP    86      60.014  52.330   7.509  1.00 23.29           O  
ATOM    773  N   ILE    87      55.762  49.144   9.018  1.00 14.59           N  
ATOM    774  CA  ILE    87      54.841  48.209   8.386  1.00 14.92           C  
ATOM    775  C   ILE    87      53.561  48.094   9.192  1.00 14.12           C  
ATOM    776  O   ILE    87      53.569  47.911  10.401  1.00 14.93           O  
ATOM    777  CB  ILE    87      55.452  46.796   8.300  1.00 17.47           C  
ATOM    778  CG1 ILE    87      56.706  46.819   7.435  1.00 20.20           C  
ATOM    779  CG2 ILE    87      54.407  45.754   7.780  1.00 17.03           C  
ATOM    780  CD1 ILE    87      56.433  47.278   6.020  1.00 21.26           C  
ATOM    781  N   GLY    88      52.448  48.185   8.493  1.00 14.34           N  
ATOM    782  CA  GLY    88      51.156  47.971   9.083  1.00 12.60           C  
ATOM    783  C   GLY    88      50.607  46.640   8.626  1.00 12.24           C  
ATOM    784  O   GLY    88      50.789  46.245   7.463  1.00 15.41           O  
ATOM    785  N   TYR    89      49.976  45.941   9.565  1.00 12.32           N  
ATOM    786  CA  TYR    89      49.246  44.701   9.293  1.00 13.27           C  
ATOM    787  C   TYR    89      47.744  45.010   9.310  1.00 13.39           C  
ATOM    788  O   TYR    89      47.201  45.556  10.300  1.00 13.85           O  
ATOM    789  CB  TYR    89      49.604  43.627  10.326  1.00 13.94           C  
ATOM    790  CG  TYR    89      50.995  43.072  10.072  1.00 14.57           C  
ATOM    791  CD1 TYR    89      51.252  42.289   9.001  1.00 15.65           C  
ATOM    792  CD2 TYR    89      52.033  43.349  10.912  1.00 14.90           C  
ATOM    793  CE1 TYR    89      52.495  41.773   8.752  1.00 17.67           C  
ATOM    794  CE2 TYR    89      53.290  42.868  10.676  1.00 15.10           C  
ATOM    795  CZ  TYR    89      53.522  42.069   9.598  1.00 17.26           C  
ATOM    796  OH  TYR    89      54.763  41.544   9.261  1.00 18.50           O  
ATOM    797  N   ILE    90      47.119  44.676   8.184  1.00 13.53           N  
ATOM    798  CA  ILE    90      45.763  45.079   7.883  1.00 14.26           C  
ATOM    799  C   ILE    90      44.902  43.852   7.569  1.00 14.29           C  
ATOM    800  O   ILE    90      45.368  42.899   6.950  1.00 14.48           O  
ATOM    801  CB  ILE    90      45.733  45.954   6.581  1.00 17.02           C  
ATOM    802  CG1 ILE    90      46.848  47.024   6.623  1.00 18.09           C  
ATOM    803  CG2 ILE    90      44.319  46.496   6.295  1.00 20.45           C  
ATOM    804  CD1 ILE    90      46.690  48.025   7.628  1.00 18.12           C  
ATOM    805  N   LEU    91      43.651  43.916   7.994  1.00 13.78           N  
ATOM    806  CA  LEU    91      42.653  42.924   7.606  1.00 15.09           C  
ATOM    807  C   LEU    91      41.597  43.537   6.702  1.00 14.58           C  
ATOM    808  O   LEU    91      41.311  44.731   6.779  1.00 14.60           O  
ATOM    809  CB  LEU    91      42.056  42.170   8.804  1.00 17.78           C  
ATOM    810  CG  LEU    91      41.432  42.931   9.958  1.00 19.58           C  
ATOM    811  CD1 LEU    91      40.013  43.360   9.553  1.00 21.82           C  
ATOM    812  CD2 LEU    91      41.418  41.993  11.190  1.00 21.39           C  
ATOM    813  N   HIS    92      41.059  42.688   5.830  1.00 15.91           N  
ATOM    814  CA  HIS    92      40.001  43.093   4.921  1.00 18.37           C  
ATOM    815  C   HIS    92      38.733  42.496   5.476  1.00 20.56           C  
ATOM    816  O   HIS    92      38.619  41.283   5.582  1.00 21.11           O  
ATOM    817  CB  HIS    92      40.277  42.553   3.524  1.00 19.75           C  
ATOM    818  CG  HIS    92      39.485  43.218   2.445  1.00 22.74           C  
ATOM    819  ND1 HIS    92      39.530  42.778   1.138  1.00 25.07           N  
ATOM    820  CD2 HIS    92      38.625  44.263   2.468  1.00 24.03           C  
ATOM    821  CE1 HIS    92      38.732  43.532   0.400  1.00 25.78           C  
ATOM    822  NE2 HIS    92      38.158  44.427   1.184  1.00 24.97           N  
ATOM    823  N   LEU    93      37.790  43.351   5.838  1.00 20.20           N  
ATOM    824  CA  LEU    93      36.588  42.906   6.548  1.00 23.31           C  
ATOM    825  C   LEU    93      35.732  42.020   5.651  1.00 25.27           C  
ATOM    826  O   LEU    93      34.971  41.187   6.120  1.00 28.16           O  
ATOM    827  CB  LEU    93      35.751  44.105   7.009  1.00 24.14           C  
ATOM    828  CG  LEU    93      36.358  45.015   8.079  1.00 24.43           C  
ATOM    829  CD1 LEU    93      35.541  46.287   8.209  1.00 23.96           C  
ATOM    830  CD2 LEU    93      36.405  44.287   9.404  1.00 25.79           C  
ATOM    831  N   SER    94      35.908  42.148   4.354  1.00 25.33           N  
ATOM    832  CA  SER    94      34.942  41.529   3.431  1.00 27.11           C  
ATOM    833  C   SER    94      35.309  40.092   3.146  1.00 26.32           C  
ATOM    834  O   SER    94      34.474  39.292   2.745  1.00 27.05           O  
ATOM    835  CB  SER    94      34.859  42.308   2.118  1.00 27.82           C  
ATOM    836  OG  SER    94      36.120  42.307   1.471  1.00 31.26           O  
ATOM    837  N   ASP    95      36.566  39.763   3.316  1.00 21.34           N  
ATOM    838  CA  ASP    95      36.989  38.426   2.993  1.00 21.12           C  
ATOM    839  C   ASP    95      38.003  37.838   3.970  1.00 18.07           C  
ATOM    840  O   ASP    95      38.477  36.741   3.783  1.00 17.29           O  
ATOM    841  CB  ASP    95      37.495  38.304   1.558  1.00 22.73           C  
ATOM    842  CG  ASP    95      38.861  38.886   1.368  1.00 24.69           C  
ATOM    843  OD1 ASP    95      39.375  39.515   2.306  1.00 21.81           O  
ATOM    844  OD2 ASP    95      39.446  38.694   0.275  1.00 27.73           O  
ATOM    845  N   ASN    96      38.251  38.544   5.056  1.00 15.03           N  
ATOM    846  CA  ASN    96      39.095  38.036   6.136  1.00 17.06           C  
ATOM    847  C   ASN    96      40.581  38.035   5.878  1.00 16.42           C  
ATOM    848  O   ASN    96      41.316  37.613   6.719  1.00 15.51           O  
ATOM    849  CB  ASN    96      38.681  36.622   6.518  1.00 19.24           C  
ATOM    850  CG  ASN    96      37.212  36.550   6.898  1.00 22.15           C  
ATOM    851  OD1 ASN    96      36.728  37.361   7.691  1.00 24.30           O  
ATOM    852  ND2 ASN    96      36.476  35.619   6.264  1.00 24.59           N  
ATOM    853  N   SER    97      40.991  38.432   4.689  1.00 14.18           N  
ATOM    854  CA  SER    97      42.412  38.375   4.283  1.00 14.22           C  
ATOM    855  C   SER    97      43.251  39.396   5.027  1.00 14.75           C  
ATOM    856  O   SER    97      42.780  40.374   5.598  1.00 14.50           O  
ATOM    857  CB  SER    97      42.596  38.530   2.784  1.00 16.20           C  
ATOM    858  OG  SER    97      41.895  39.620   2.272  1.00 20.89           O  
ATOM    859  N   ILE    98      44.539  39.106   4.979  1.00 12.67           N  
ATOM    860  CA  ILE    98      45.563  39.864   5.683  1.00 12.12           C  
ATOM    861  C   ILE    98      46.589  40.435   4.719  1.00 13.25           C  
ATOM    862  O   ILE    98      47.048  39.757   3.769  1.00 13.34           O  
ATOM    863  CB  ILE    98      46.326  38.967   6.680  1.00 13.32           C  
ATOM    864  CG1 ILE    98      45.380  38.182   7.599  1.00 14.12           C  
ATOM    865  CG2 ILE    98      47.388  39.811   7.462  1.00 13.13           C  
ATOM    866  CD1 ILE    98      44.503  39.024   8.525  1.00 14.95           C  
ATOM    867  N   TYR    99      46.919  41.703   4.958  1.00 13.42           N  
ATOM    868  CA  TYR    99      47.808  42.480   4.089  1.00 13.97           C  
ATOM    869  C   TYR    99      48.863  43.207   4.900  1.00 13.41           C  
ATOM    870  O   TYR    99      48.709  43.470   6.073  1.00 15.23           O  
ATOM    871  CB  TYR    99      47.025  43.578   3.348  1.00 15.03           C  
ATOM    872  CG  TYR    99      46.022  43.051   2.366  1.00 17.06           C  
ATOM    873  CD1 TYR    99      44.783  42.582   2.777  1.00 18.09           C  
ATOM    874  CD2 TYR    99      46.342  42.980   1.025  1.00 16.78           C  
ATOM    875  CE1 TYR    99      43.873  42.048   1.813  1.00 20.42           C  
ATOM    876  CE2 TYR    99      45.455  42.448   0.080  1.00 20.89           C  
ATOM    877  CZ  TYR    99      44.241  41.991   0.498  1.00 20.78           C  
ATOM    878  OH  TYR    99      43.418  41.485  -0.508  1.00 25.81           O  
ATOM    879  N   ARG   100      49.922  43.533   4.171  0.50 15.79           N  
ATOM    881  CA  ARG   100      50.988  44.396   4.636  0.50 17.43           C  
ATOM    883  C   ARG   100      50.959  45.706   3.907  0.50 16.46           C  
ATOM    885  O   ARG   100      50.747  45.729   2.689  0.50 16.77           O  
ATOM    887  CB  ARG   100      52.307  43.759   4.277  0.50 21.27           C  
ATOM    889  CG  ARG   100      53.050  43.271   5.393  0.50 23.13           C  
ATOM    891  CD  ARG   100      54.457  43.103   4.983  0.50 24.89           C  
ATOM    893  NE  ARG   100      55.180  42.630   6.125  0.50 26.33           N  
ATOM    895  CZ  ARG   100      56.452  42.876   6.359  0.50 26.81           C  
ATOM    897  NH1 ARG   100      57.177  43.578   5.509  0.50 27.35           N  
ATOM    899  NH2 ARG   100      56.966  42.392   7.462  0.50 28.32           N  
ATOM    901  N   VAL   101      51.221  46.781   4.629  1.00 13.70           N  
ATOM    902  CA  VAL   101      51.321  48.105   4.008  1.00 14.38           C  
ATOM    903  C   VAL   101      52.467  48.878   4.658  1.00 15.62           C  
ATOM    904  O   VAL   101      52.937  48.533   5.728  1.00 17.43           O  
ATOM    905  CB  VAL   101      50.031  48.884   4.154  1.00 15.49           C  
ATOM    906  CG1 VAL   101      48.863  48.101   3.600  1.00 19.20           C  
ATOM    907  CG2 VAL   101      49.793  49.214   5.623  1.00 15.81           C  
ATOM    908  N   ASP   102      52.948  49.884   3.953  1.00 16.37           N  
ATOM    909  CA  ASP   102      53.849  50.873   4.550  1.00 17.05           C  
ATOM    910  C   ASP   102      53.019  52.008   5.095  1.00 16.88           C  
ATOM    911  O   ASP   102      52.359  52.723   4.361  1.00 16.57           O  
ATOM    912  CB  ASP   102      54.805  51.393   3.473  1.00 18.89           C  
ATOM    913  CG  ASP   102      55.873  52.359   4.020  1.00 22.02           C  
ATOM    914  OD1 ASP   102      55.708  52.970   5.083  1.00 21.84           O  
ATOM    915  OD2 ASP   102      56.898  52.536   3.309  1.00 26.31           O  
ATOM    916  N   LEU   103      53.024  52.152   6.414  1.00 15.71           N  
ATOM    917  CA  LEU   103      52.181  53.132   7.097  1.00 14.82           C  
ATOM    918  C   LEU   103      52.554  54.565   6.680  1.00 18.31           C  
ATOM    919  O   LEU   103      51.781  55.502   6.817  1.00 20.39           O  
ATOM    920  CB  LEU   103      52.271  52.981   8.620  1.00 15.18           C  
ATOM    921  CG  LEU   103      51.612  51.726   9.137  1.00 14.90           C  
ATOM    922  CD1 LEU   103      52.112  51.401  10.543  1.00 15.17           C  
ATOM    923  CD2 LEU   103      50.079  51.821   9.111  1.00 15.00           C  
ATOM    924  N   GLY   104      53.744  54.675   6.143  1.00 19.41           N  
ATOM    925  CA  GLY   104      54.278  55.981   5.716  1.00 20.56           C  
ATOM    926  C   GLY   104      54.043  56.267   4.255  1.00 23.21           C  
ATOM    927  O   GLY   104      54.415  57.340   3.752  1.00 25.31           O  
ATOM    928  N   ASP   105      53.414  55.323   3.582  1.00 22.53           N  
ATOM    929  CA  ASP   105      53.092  55.471   2.164  1.00 23.99           C  
ATOM    930  C   ASP   105      51.895  54.623   1.802  1.00 21.57           C  
ATOM    931  O   ASP   105      51.990  53.689   1.026  1.00 22.71           O  
ATOM    932  CB  ASP   105      54.288  55.099   1.308  1.00 26.82           C  
ATOM    933  CG  ASP   105      54.148  55.572  -0.142  1.00 29.77           C  
ATOM    934  OD1 ASP   105      53.162  56.280  -0.487  1.00 30.35           O  
ATOM    935  OD2 ASP   105      55.048  55.228  -0.941  1.00 34.81           O  
ATOM    936  N   LEU   106      50.780  54.958   2.430  1.00 20.46           N  
ATOM    937  CA  LEU   106      49.518  54.246   2.261  1.00 19.43           C  
ATOM    938  C   LEU   106      48.895  54.530   0.903  1.00 21.14           C  
ATOM    939  O   LEU   106      48.742  55.683   0.503  1.00 21.70           O  
ATOM    940  CB  LEU   106      48.523  54.635   3.365  1.00 19.87           C  
ATOM    941  CG  LEU   106      48.833  54.138   4.779  1.00 18.45           C  
ATOM    942  CD1 LEU   106      47.882  54.765   5.784  1.00 17.63           C  
ATOM    943  CD2 LEU   106      48.758  52.606   4.876  1.00 16.83           C  
ATOM    944  N   ASP   107      48.554  53.448   0.226  1.00 23.66           N  
ATOM    945  CA  ASP   107      47.977  53.501  -1.118  1.00 25.61           C  
ATOM    946  C   ASP   107      47.304  52.210  -1.481  1.00 25.40           C  
ATOM    947  O   ASP   107      47.883  51.140  -1.368  1.00 22.71           O  
ATOM    948  CB  ASP   107      49.070  53.757  -2.125  1.00 28.26           C  
ATOM    949  CG  ASP   107      48.543  53.804  -3.552  1.00 31.73           C  
ATOM    950  OD1 ASP   107      47.354  53.454  -3.807  1.00 33.82           O  
ATOM    951  OD2 ASP   107      49.347  54.203  -4.416  1.00 35.93           O  
ATOM    952  N   ILE   108      46.057  52.319  -1.883  1.00 25.63           N  
ATOM    953  CA  ILE   108      45.273  51.140  -2.113  1.00 26.42           C  
ATOM    954  C   ILE   108      46.000  50.246  -3.107  1.00 26.59           C  
ATOM    955  O   ILE   108      45.876  49.030  -3.062  1.00 26.34           O  
ATOM    956  CB  ILE   108      43.837  51.443  -2.585  1.00 27.37           C  
ATOM    957  CG1 ILE   108      43.039  50.150  -2.523  1.00 27.91           C  
ATOM    958  CG2 ILE   108      43.837  52.054  -3.993  1.00 27.36           C  
ATOM    959  CD1 ILE   108      42.913  49.603  -1.088  1.00 27.78           C  
ATOM    960  N   THR   109      46.808  50.856  -3.968  1.00 27.43           N  
ATOM    961  CA  THR   109      47.373  50.117  -5.109  1.00 27.73           C  
ATOM    962  C   THR   109      48.603  49.333  -4.720  1.00 28.82           C  
ATOM    963  O   THR   109      49.129  48.537  -5.503  1.00 30.21           O  
ATOM    964  CB  THR   109      47.736  51.039  -6.308  1.00 28.25           C  
ATOM    965  OG1 THR   109      48.724  51.991  -5.903  1.00 28.98           O  
ATOM    966  CG2 THR   109      46.506  51.744  -6.825  1.00 28.26           C  
ATOM    967  N   SER   110      49.046  49.540  -3.495  1.00 27.73           N  
ATOM    968  CA  SER   110      50.325  48.983  -3.072  1.00 28.14           C  
ATOM    969  C   SER   110      50.212  48.098  -1.820  1.00 26.41           C  
ATOM    970  O   SER   110      51.220  47.697  -1.212  1.00 28.84           O  
ATOM    971  CB  SER   110      51.333  50.102  -2.841  1.00 29.24           C  
ATOM    972  OG  SER   110      51.022  50.806  -1.668  1.00 32.50           O  
ATOM    973  N   ILE   111      48.983  47.823  -1.430  1.00 22.71           N  
ATOM    974  CA  ILE   111      48.755  46.888  -0.319  1.00 19.80           C  
ATOM    975  C   ILE   111      49.272  45.530  -0.794  1.00 18.34           C  
ATOM    976  O   ILE   111      49.162  45.173  -1.991  1.00 19.49           O  
ATOM    977  CB  ILE   111      47.277  46.827   0.115  1.00 21.69           C  
ATOM    978  CG1 ILE   111      46.387  46.226  -0.958  1.00 22.53           C  
ATOM    979  CG2 ILE   111      46.781  48.216   0.484  1.00 21.47           C  
ATOM    980  CD1 ILE   111      44.917  46.049  -0.490  1.00 24.50           C  
ATOM    981  N   LYS   112      49.883  44.772   0.104  1.00 16.45           N  
ATOM    982  CA  LYS   112      50.456  43.482  -0.266  1.00 16.46           C  
ATOM    983  C   LYS   112      49.776  42.345   0.474  1.00 15.59           C  
ATOM    984  O   LYS   112      49.815  42.261   1.709  1.00 14.81           O  
ATOM    985  CB  LYS   112      51.952  43.471   0.049  1.00 16.89           C  
ATOM    986  CG  LYS   112      52.644  42.134  -0.052  1.00 21.44           C  
ATOM    987  N   TYR   113      49.214  41.431  -0.286  1.00 15.76           N  
ATOM    988  CA  TYR   113      48.498  40.289   0.268  1.00 15.84           C  
ATOM    989  C   TYR   113      49.466  39.333   0.862  1.00 17.11           C  
ATOM    990  O   TYR   113      50.470  38.987   0.220  1.00 19.34           O  
ATOM    991  CB  TYR   113      47.721  39.596  -0.869  1.00 16.72           C  
ATOM    992  CG  TYR   113      46.957  38.371  -0.478  1.00 16.58           C  
ATOM    993  CD1 TYR   113      45.646  38.465  -0.083  1.00 18.50           C  
ATOM    994  CD2 TYR   113      47.540  37.127  -0.521  1.00 20.50           C  
ATOM    995  CE1 TYR   113      44.906  37.325   0.260  1.00 20.54           C  
ATOM    996  CE2 TYR   113      46.826  35.984  -0.179  1.00 20.08           C  
ATOM    997  CZ  TYR   113      45.506  36.092   0.193  1.00 19.95           C  
ATOM    998  OH  TYR   113      44.778  34.951   0.488  1.00 21.02           O  
ATOM    999  N   ILE   114      49.211  38.908   2.101  1.00 14.91           N  
ATOM   1000  CA  ILE   114      50.067  37.914   2.709  1.00 15.14           C  
ATOM   1001  C   ILE   114      49.374  36.629   3.106  1.00 15.07           C  
ATOM   1002  O   ILE   114      50.011  35.589   3.110  1.00 16.67           O  
ATOM   1003  CB  ILE   114      50.982  38.473   3.807  1.00 18.92           C  
ATOM   1004  CG1 ILE   114      50.192  38.995   4.945  1.00 19.29           C  
ATOM   1005  CG2 ILE   114      51.935  39.580   3.236  1.00 20.71           C  
ATOM   1006  CD1 ILE   114      51.104  39.293   6.152  1.00 20.35           C  
ATOM   1007  N   ALA   115      48.089  36.664   3.395  1.00 12.61           N  
ATOM   1008  CA  ALA   115      47.369  35.463   3.874  1.00 13.72           C  
ATOM   1009  C   ALA   115      45.872  35.540   3.734  1.00 12.42           C  
ATOM   1010  O   ALA   115      45.332  36.643   3.806  1.00 12.21           O  
ATOM   1011  CB  ALA   115      47.693  35.209   5.354  1.00 14.38           C  
ATOM   1012  N   PRO   116      45.202  34.380   3.673  1.00 13.38           N  
ATOM   1013  CA  PRO   116      43.748  34.480   3.513  1.00 12.78           C  
ATOM   1014  C   PRO   116      42.983  34.653   4.817  1.00 14.66           C  
ATOM   1015  O   PRO   116      41.750  34.874   4.803  1.00 14.03           O  
ATOM   1016  CB  PRO   116      43.378  33.149   2.841  1.00 13.83           C  
ATOM   1017  CG  PRO   116      44.505  32.206   3.275  1.00 14.51           C  
ATOM   1018  CD  PRO   116      45.728  33.061   3.258  1.00 14.06           C  
ATOM   1019  N   SER   117      43.678  34.529   5.923  1.00 13.51           N  
ATOM   1020  CA  SER   117      43.054  34.731   7.202  1.00 13.13           C  
ATOM   1021  C   SER   117      44.093  34.943   8.258  1.00 12.28           C  
ATOM   1022  O   SER   117      45.281  34.736   8.032  1.00 12.70           O  
ATOM   1023  CB  SER   117      42.237  33.516   7.620  1.00 13.93           C  
ATOM   1024  OG  SER   117      43.064  32.433   8.006  1.00 16.27           O  
ATOM   1025  N   PHE   118      43.603  35.357   9.411  1.00 12.72           N  
ATOM   1026  CA  PHE   118      44.474  35.668  10.544  1.00 13.46           C  
ATOM   1027  C   PHE   118      45.303  34.452  11.041  1.00 11.38           C  
ATOM   1028  O   PHE   118      46.518  34.582  11.247  1.00 13.25           O  
ATOM   1029  CB  PHE   118      43.644  36.232  11.691  1.00 12.91           C  
ATOM   1030  CG  PHE   118      44.438  36.715  12.834  1.00 14.57           C  
ATOM   1031  CD1 PHE   118      44.871  38.011  12.870  1.00 16.44           C  
ATOM   1032  CD2 PHE   118      44.776  35.860  13.844  1.00 16.13           C  
ATOM   1033  CE1 PHE   118      45.633  38.440  13.959  1.00 16.75           C  
ATOM   1034  CE2 PHE   118      45.517  36.284  14.882  1.00 18.97           C  
ATOM   1035  CZ  PHE   118      45.950  37.579  14.910  1.00 16.60           C  
ATOM   1036  N   ASP   119      44.656  33.292  11.195  1.00 12.63           N  
ATOM   1037  CA  ASP   119      45.410  32.143  11.737  1.00 12.07           C  
ATOM   1038  C   ASP   119      46.447  31.709  10.697  1.00 12.96           C  
ATOM   1039  O   ASP   119      47.501  31.233  11.054  1.00 13.89           O  
ATOM   1040  CB  ASP   119      44.480  30.991  12.061  1.00 12.61           C  
ATOM   1041  CG  ASP   119      43.592  31.296  13.245  1.00 13.78           C  
ATOM   1042  OD1 ASP   119      43.953  32.179  14.081  1.00 13.29           O  
ATOM   1043  OD2 ASP   119      42.536  30.637  13.385  1.00 13.75           O  
ATOM   1044  N   ASP   120      46.077  31.801   9.432  1.00 13.02           N  
ATOM   1045  CA  ASP   120      46.991  31.451   8.330  1.00 12.19           C  
ATOM   1046  C   ASP   120      48.234  32.342   8.384  1.00 12.87           C  
ATOM   1047  O   ASP   120      49.377  31.892   8.284  1.00 12.82           O  
ATOM   1048  CB  ASP   120      46.193  31.494   7.019  1.00 12.13           C  
ATOM   1049  CG  ASP   120      47.000  31.173   5.805  1.00 14.18           C  
ATOM   1050  OD1 ASP   120      48.024  31.840   5.585  1.00 14.22           O  
ATOM   1051  OD2 ASP   120      46.611  30.239   5.066  1.00 14.57           O  
ATOM   1052  N   PHE   121      47.979  33.628   8.564  1.00 11.85           N  
ATOM   1053  CA  PHE   121      49.067  34.618   8.753  1.00 12.52           C  
ATOM   1054  C   PHE   121      49.991  34.211   9.900  1.00 13.09           C  
ATOM   1055  O   PHE   121      51.196  34.219   9.771  1.00 13.02           O  
ATOM   1056  CB  PHE   121      48.414  36.019   9.019  1.00 11.96           C  
ATOM   1057  CG  PHE   121      49.234  37.010   9.749  1.00 13.69           C  
ATOM   1058  CD1 PHE   121      50.303  37.611   9.147  1.00 16.52           C  
ATOM   1059  CD2 PHE   121      48.854  37.425  10.970  1.00 15.33           C  
ATOM   1060  CE1 PHE   121      51.044  38.601   9.859  1.00 18.35           C  
ATOM   1061  CE2 PHE   121      49.548  38.394  11.647  1.00 15.37           C  
ATOM   1062  CZ  PHE   121      50.635  38.963  11.093  1.00 16.66           C  
ATOM   1063  N   LEU   122      49.414  33.842  11.033  1.00 13.07           N  
ATOM   1064  CA  LEU   122      50.230  33.436  12.183  1.00 14.92           C  
ATOM   1065  C   LEU   122      51.073  32.217  11.904  1.00 14.02           C  
ATOM   1066  O   LEU   122      52.213  32.117  12.389  1.00 14.98           O  
ATOM   1067  CB  LEU   122      49.362  33.189  13.426  1.00 15.96           C  
ATOM   1068  CG  LEU   122      48.656  34.331  14.099  1.00 18.57           C  
ATOM   1069  CD1 LEU   122      47.912  33.746  15.307  1.00 20.81           C  
ATOM   1070  CD2 LEU   122      49.620  35.408  14.545  1.00 18.65           C  
ATOM   1071  N   GLY   123      50.516  31.273  11.160  1.00 13.22           N  
ATOM   1072  CA  GLY   123      51.263  30.066  10.832  1.00 13.38           C  
ATOM   1073  C   GLY   123      52.386  30.335   9.874  1.00 13.00           C  
ATOM   1074  O   GLY   123      53.501  29.839  10.046  1.00 13.85           O  
ATOM   1075  N   LYS   124      52.101  31.074   8.799  1.00 12.66           N  
ATOM   1076  CA  LYS   124      53.115  31.484   7.873  1.00 12.93           C  
ATOM   1077  C   LYS   124      54.316  32.131   8.589  1.00 12.96           C  
ATOM   1078  O   LYS   124      55.450  31.942   8.193  1.00 13.64           O  
ATOM   1079  CB  LYS   124      52.570  32.435   6.793  1.00 13.03           C  
ATOM   1080  CG  LYS   124      51.687  31.781   5.720  1.00 13.83           C  
ATOM   1081  CD  LYS   124      51.191  32.849   4.747  1.00 14.16           C  
ATOM   1082  CE  LYS   124      50.666  32.281   3.454  1.00 15.21           C  
ATOM   1083  NZ  LYS   124      49.719  31.139   3.594  1.00 13.48           N  
ATOM   1084  N   ALA   125      54.002  32.909   9.612  1.00 13.34           N  
ATOM   1085  CA  ALA   125      55.032  33.759  10.211  1.00 13.33           C  
ATOM   1086  C   ALA   125      56.161  32.910  10.779  1.00 14.98           C  
ATOM   1087  O   ALA   125      57.313  33.354  10.849  1.00 14.76           O  
ATOM   1088  CB  ALA   125      54.457  34.623  11.321  1.00 14.82           C  
ATOM   1089  N   ILE   126      55.826  31.684  11.144  0.50 15.10           N  
ATOM   1091  CA  ILE   126      56.793  30.794  11.796  0.50 17.55           C  
ATOM   1093  C   ILE   126      57.917  30.403  10.881  0.50 17.28           C  
ATOM   1095  O   ILE   126      59.003  30.054  11.365  0.50 18.27           O  
ATOM   1097  CB  ILE   126      56.185  29.476  12.274  0.50 20.25           C  
ATOM   1099  CG1 ILE   126      54.975  29.729  13.162  0.50 20.62           C  
ATOM   1101  CG2 ILE   126      57.269  28.647  12.960  0.50 20.51           C  
ATOM   1103  CD1 ILE   126      55.209  30.553  14.453  0.50 20.46           C  
ATOM   1105  N   TYR   127      57.648  30.396   9.568  1.00 15.10           N  
ATOM   1106  CA  TYR   127      58.620  29.914   8.559  1.00 15.73           C  
ATOM   1107  C   TYR   127      58.881  30.752   7.353  1.00 15.62           C  
ATOM   1108  O   TYR   127      59.726  30.447   6.499  1.00 18.12           O  
ATOM   1109  CB  TYR   127      58.315  28.451   8.159  1.00 16.00           C  
ATOM   1110  CG  TYR   127      57.110  28.171   7.262  1.00 14.25           C  
ATOM   1111  CD1 TYR   127      55.820  28.140   7.767  1.00 12.89           C  
ATOM   1112  CD2 TYR   127      57.306  27.804   5.950  1.00 13.77           C  
ATOM   1113  CE1 TYR   127      54.755  27.801   6.940  1.00 12.96           C  
ATOM   1114  CE2 TYR   127      56.277  27.489   5.128  1.00 12.92           C  
ATOM   1115  CZ  TYR   127      54.977  27.511   5.621  1.00 11.49           C  
ATOM   1116  OH  TYR   127      53.913  27.111   4.788  1.00 13.65           O  
ATOM   1117  N   LEU   128      58.189  31.878   7.309  0.25 14.76           N  
ATOM   1120  CA  LEU   128      58.286  32.817   6.201  0.25 14.73           C  
ATOM   1123  C   LEU   128      58.536  34.237   6.694  0.25 15.22           C  
ATOM   1126  O   LEU   128      57.719  34.819   7.418  0.25 13.97           O  
ATOM   1129  CB  LEU   128      57.015  32.742   5.344  0.25 14.41           C  
ATOM   1132  CG  LEU   128      56.664  31.328   4.856  0.25 13.82           C  
ATOM   1135  CD1 LEU   128      55.231  31.242   4.431  0.25 13.25           C  
ATOM   1138  CD2 LEU   128      57.582  30.925   3.717  0.25 11.90           C  
ATOM   1141  N   ASN   129      59.652  34.810   6.254  1.00 16.48           N  
ATOM   1142  CA  ASN   129      60.028  36.158   6.677  1.00 17.66           C  
ATOM   1143  C   ASN   129      59.318  37.138   5.777  1.00 19.40           C  
ATOM   1144  O   ASN   129      59.649  37.226   4.587  1.00 21.64           O  
ATOM   1145  CB  ASN   129      61.551  36.381   6.555  1.00 22.17           C  
ATOM   1146  CG  ASN   129      62.007  37.759   7.094  1.00 23.19           C  
ATOM   1147  OD1 ASN   129      61.259  38.713   7.146  1.00 25.79           O  
ATOM   1148  ND2 ASN   129      63.229  37.809   7.601  1.00 28.66           N  
ATOM   1149  N   PHE   130      58.364  37.871   6.331  1.00 16.80           N  
ATOM   1150  CA  PHE   130      57.497  38.716   5.544  1.00 18.33           C  
ATOM   1151  C   PHE   130      58.246  39.910   4.936  1.00 20.00           C  
ATOM   1152  O   PHE   130      57.724  40.540   4.016  1.00 23.45           O  
ATOM   1153  CB  PHE   130      56.301  39.209   6.350  1.00 17.03           C  
ATOM   1154  CG  PHE   130      55.387  38.117   6.845  1.00 17.97           C  
ATOM   1155  CD1 PHE   130      54.892  37.154   5.970  1.00 18.85           C  
ATOM   1156  CD2 PHE   130      54.926  38.115   8.129  1.00 18.34           C  
ATOM   1157  CE1 PHE   130      54.012  36.155   6.450  1.00 18.88           C  
ATOM   1158  CE2 PHE   130      54.023  37.142   8.597  1.00 17.83           C  
ATOM   1159  CZ  PHE   130      53.591  36.168   7.764  1.00 18.69           C  
ATOM   1160  N   ASN   131      59.437  40.213   5.448  1.00 21.83           N  
ATOM   1161  CA  ASN   131      60.279  41.348   4.943  1.00 26.42           C  
ATOM   1162  C   ASN   131      60.975  40.821   3.735  1.00 30.27           C  
ATOM   1163  O   ASN   131      61.703  41.510   3.041  1.00 32.69           O  
ATOM   1164  CB  ASN   131      61.300  41.826   5.962  1.00 27.83           C  
ATOM   1165  CG  ASN   131      60.729  42.875   6.892  1.00 31.08           C  
ATOM   1166  OD1 ASN   131      59.798  43.614   6.512  1.00 34.44           O  
ATOM   1167  ND2 ASN   131      61.312  43.004   8.089  1.00 32.86           N  
ATOM   1168  N   LYS   132      60.623  39.570   3.486  1.00 34.59           N  
ATOM   1169  CA  LYS   132      61.140  38.715   2.422  1.00 37.58           C  
ATOM   1170  C   LYS   132      62.659  38.724   2.348  1.00 38.58           C  
ATOM   1171  O   LYS   132      63.311  37.995   3.118  1.00 39.86           O  
ATOM   1172  CB  LYS   132      60.464  39.014   1.102  1.00 38.71           C  
ATOM   1173  CG  LYS   132      59.585  37.866   0.720  1.00 39.74           C  
ATOM   1174  CD  LYS   132      58.437  37.669   1.688  1.00 40.25           C  
ATOM   1175  CE  LYS   132      57.147  37.240   0.963  1.00 40.65           C  
END
