
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  174 ( 1345),  selected  174 , name 2g0b_G
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2g0b_G.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    K     5_G      I       3          2.116
LGA    V     6_G      N       4          0.990
LGA    A     7_G      I       5          0.555
LGA    R     8_G      I       6          0.772
LGA    I     9_G      E       7          0.273
LGA    -       -      Y       8           -
LGA    A    12_G      N       9          2.682
LGA    P    13_G      R      10          0.932
LGA    N    14_G      S      11          1.607
LGA    E    15_G      Y      12          1.643
LGA    R    16_G      K      13          3.442
LGA    D    17_G      E      14          2.976
LGA    A    18_G      E      15          1.941
LGA    A    19_G      L      16          1.944
LGA    R    20_G      I      17          1.958
LGA    R    21_G      E      18          1.905
LGA    I    22_G      F      19          0.870
LGA    V    23_G      I      20          0.518
LGA    R    24_G      L      21          1.206
LGA    T    25_G      S      22          0.925
LGA    T    26_G      I      23          0.688
LGA    Y    27_G      Q      24          0.757
LGA    E    28_G      K      25          1.262
LGA    A    29_G      N      26          1.800
LGA    -       -      E      27           -
LGA    Q    30_G      F      28          1.018
LGA    G    31_G      N      29          1.385
LGA    Y    32_G      I      30          1.881
LGA    -       -      K      31           -
LGA    A    33_G      I      32          0.688
LGA    I    34_G      D      33          2.290
LGA    D    35_G      R      34          3.660
LGA    E    36_G      D      35          3.745
LGA    -       -      D      36           -
LGA    -       -      Q      37           -
LGA    S    37_G      P      38          2.942
LGA    F    38_G      D      39          2.932
LGA    A    39_G      L      40          2.130
LGA    T    40_G      E      41           #
LGA    F    41_G      N      42           #
LGA    L    42_G      I      43          2.952
LGA    E    43_G      E      44          3.777
LGA    G    44_G      H      45          2.211
LGA    -       -      N      46           -
LGA    -       -      Y      47           -
LGA    -       -      L      48           -
LGA    P    45_G      N      49          2.237
LGA    S    46_G      S      50          1.749
LGA    -       -      G      51           -
LGA    A    47_G      G      52          3.470
LGA    T    48_G      Q      53          2.181
LGA    T    49_G      F      54          1.050
LGA    F    50_G      W      55          0.478
LGA    G    51_G      L      56          0.445
LGA    L    52_G      A      57          1.023
LGA    F    53_G      I      58          1.260
LGA    N    54_G      N      59          0.994
LGA    G    55_G      N      60          1.374
LGA    E    56_G      H      61          3.341
LGA    V    57_G      Q      62          2.761
LGA    -       -      N      63           -
LGA    L    58_G      I      64          1.794
LGA    Y    59_G      V      65          1.726
LGA    G    60_G      G      66          1.256
LGA    T    61_G      T      67          1.029
LGA    I    62_G      I      68          0.951
LGA    S    63_G      G      69          0.933
LGA    I    64_G      L      70          0.867
LGA    I    65_G      I      71          0.826
LGA    N    66_G      R      72          0.859
LGA    D    67_G      L      73          1.388
LGA    G    68_G      D      74          5.341
LGA    A    69_G      -       -           -
LGA    Q    70_G      -       -           -
LGA    G    71_G      -       -           -
LGA    L    72_G      -       -           -
LGA    P    73_G      -       -           -
LGA    M    74_G      -       -           -
LGA    D    75_G      -       -           -
LGA    S    76_G      -       -           -
LGA    I    77_G      -       -           -
LGA    Y    78_G      -       -           -
LGA    A    79_G      -       -           -
LGA    V    80_G      -       -           -
LGA    E    81_G      -       -           -
LGA    L    82_G      -       -           -
LGA    A    83_G      -       -           -
LGA    A    84_G      -       -           -
LGA    W    85_G      -       -           -
LGA    R    86_G      -       -           -
LGA    G    87_G      -       -           -
LGA    E    88_G      -       -           -
LGA    G    89_G      -       -           -
LGA    K    90_G      N      75          3.089
LGA    K    91_G      N      76          0.441
LGA    L    92_G      M      77          0.743
LGA    A    93_G      S      78          0.761
LGA    E    94_G      A      79          0.740
LGA    V    95_G      L      80          0.977
LGA    V    96_G      K      81          0.248
LGA    Q    97_G      K      82          0.690
LGA    F    98_G      M      83          1.260
LGA    A    99_G      F      84          1.642
LGA    M   100_G      V      85          2.070
LGA    D   101_G      D      86          2.041
LGA    E   106_G      K      87           -
LGA    A   107_G      -       -           -
LGA    V   108_G      -       -           -
LGA    A   109_G      -       -           -
LGA    G   110_G      -       -           -
LGA    K   112_G      G      88          3.993
LGA    P   113_G      Y      89          1.978
LGA    -       -      R      90           -
LGA    S   114_G      N      91          1.832
LGA    P   115_G      L      92          4.018
LGA    F   116_G      K      93          0.879
LGA    E   117_G      I      94          1.521
LGA    A   118_G      G      95          1.383
LGA    A   119_G      K      96          1.429
LGA    S   120_G      K      97          1.424
LGA    L   121_G      L      98          0.648
LGA    F   122_G      L      99          0.992
LGA    T   123_G      D     100          1.209
LGA    M   124_G      K     101          0.822
LGA    V   125_G      V     102          0.699
LGA    L   126_G      I     103          0.704
LGA    T   127_G      M     104          0.816
LGA    Y   128_G      T     105          0.802
LGA    A   129_G      C     106          0.877
LGA    L   130_G      K     107          0.640
LGA    E   131_G      E     108          0.544
LGA    T   132_G      Q     109          0.726
LGA    H   133_G      N     110          0.664
LGA    I   134_G      I     111          0.731
LGA    D   135_G      D     112          0.612
LGA    Y   136_G      G     113          1.056
LGA    L   137_G      I     114          0.669
LGA    C   138_G      Y     115          0.815
LGA    I   139_G      L     116          1.047
LGA    S   140_G      G     117          0.960
LGA    I   141_G      T     118          1.450
LGA    N   142_G      I     119          1.606
LGA    P   143_G      D     120          2.238
LGA    -       -      K     121           -
LGA    -       -      F     122           -
LGA    K   144_G      I     123          2.453
LGA    -       -      S     124           -
LGA    H   145_G      A     125          3.113
LGA    D   146_G      Q     126          2.723
LGA    T   147_G      Y     127          3.487
LGA    F   148_G      F     128          3.195
LGA    Y   149_G      Y     129          1.594
LGA    S   150_G      S     130          1.991
LGA    L   151_G      N     131          2.589
LGA    L   152_G      N     132          1.907
LGA    G   153_G      G     133          1.899
LGA    F   154_G      F     134          1.036
LGA    T   155_G      R     135          1.745
LGA    Q   156_G      E     136          2.107
LGA    I   157_G      I     137          2.584
LGA    G   158_G      K     138          1.798
LGA    A   159_G      R     139          4.079
LGA    L   160_G      G     140           #
LGA    K   161_G      D     141           -
LGA    H   162_G      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    Y   163_G      K     148           #
LGA    G   164_G      L     149          4.847
LGA    T   165_G      D     150          4.239
LGA    V   166_G      -       -           -
LGA    N   167_G      -       -           -
LGA    A   168_G      V     151          3.087
LGA    P   169_G      D     152          4.304
LGA    A   170_G      N     153          1.880
LGA    I   171_G      R     154          1.244
LGA    A   172_G      F     155          1.410
LGA    R   173_G      Y     156          0.711
LGA    A   174_G      Y     157          0.692
LGA    L   175_G      R     158          0.695
LGA    Y   176_G      N     159          0.748
LGA    V   177_G      L     160          0.808
LGA    P   178_G      K     161          2.323
LGA    E   179_G      -       -           -
LGA    W   180_G      -       -           -
LGA    R   181_G      -       -           -
LGA    S   182_G      -       -           -
LGA    Q   183_G      -       -           -
LGA    T   184_G      -       -           -
LGA    L   185_G      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  174  160    5.0    133    2.00    14.29     67.804     6.340

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.728463 * X  +   0.480488 * Y  +   0.488336 * Z  + -108.377228
  Y_new =   0.439992 * X  +   0.218238 * Y  +  -0.871079 * Z  +  17.194420
  Z_new =  -0.525117 * X  +   0.849413 * Y  +  -0.052433 * Z  +  19.781944 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.632446   -1.509146  [ DEG:    93.5323    -86.4677 ]
  Theta =   0.552853    2.588740  [ DEG:    31.6761    148.3239 ]
  Phi   =   0.543356   -2.598237  [ DEG:    31.1320   -148.8680 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2g0b_G                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2g0b_G.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  174  160   5.0  133   2.00   14.29  67.804
REMARK  ---------------------------------------------------------- 
MOLECULE 2g0b_G
HEADER    TRANSFERASE                             11-FEB-06   2G0B              
TITLE     THE STRUCTURE OF FEEM, AN N-ACYL AMINO ACID SYNTHASE FROM             
TITLE    2 UNCULTURED SOIL MICROBES                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FEEM;                                                      
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 EC: 2.3.1.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: UNCULTURED BACTERIUM;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: FEEM;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET42                                     
KEYWDS    N-ACYL TRANSFERASE, ENVIRONMENTAL DNA, PROTEIN-PRODUCT                
KEYWDS   2 COMPLEX, ANTIBIOTIC SYNTHASE                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.M.VAN WAGONER,J.CLARDY                                              
REVDAT   1   26-SEP-06 2G0B    0                                                
JRNL        AUTH   R.M.VAN WAGONER,J.CLARDY                                     
JRNL        TITL   FEEM, AN N-ACYL AMINO ACID SYNTHASE FROM AN                  
JRNL        TITL 2 UNCULTURED SOIL MICROBE: STRUCTURE, MECHANISM, AND           
JRNL        TITL 3 ACYL CARRIER PROTEIN BINDING.                                
JRNL        REF    STRUCTURE                     V.  14  1425 2006              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 3.00 ANGSTROMS.                                          
DBREF  2G0B A    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B B    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B C    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B D    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B E    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B F    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B G    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
DBREF  2G0B H    1   196  UNP    Q8KNZ7   Q8KNZ7_9BACT     1    196             
SEQRES   1 A  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 A  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 A  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 A  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 A  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 A  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 A  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 A  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 A  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 A  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 A  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 A  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 A  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 A  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 A  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 A  198  ARG SER HIS                                                  
SEQRES   1 B  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 B  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 B  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 B  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 B  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 B  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 B  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 B  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 B  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 B  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 B  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 B  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 B  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 B  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 B  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 B  198  ARG SER HIS                                                  
SEQRES   1 C  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 C  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 C  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 C  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 C  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 C  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 C  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 C  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 C  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 C  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 C  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 C  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 C  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 C  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 C  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 C  198  ARG SER HIS                                                  
SEQRES   1 D  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 D  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 D  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 D  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 D  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 D  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 D  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 D  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 D  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 D  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 D  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 D  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 D  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 D  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 D  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 D  198  ARG SER HIS                                                  
SEQRES   1 E  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 E  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 E  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 E  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 E  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 E  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 E  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 E  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 E  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 E  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 E  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 E  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 E  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 E  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 E  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 E  198  ARG SER HIS                                                  
SEQRES   1 F  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 F  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 F  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 F  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 F  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 F  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 F  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 F  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 F  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 F  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 F  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 F  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 F  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 F  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 F  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 F  198  ARG SER HIS                                                  
SEQRES   1 G  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 G  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 G  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 G  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 G  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 G  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 G  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 G  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 G  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 G  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 G  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 G  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 G  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 G  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 G  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 G  198  ARG SER HIS                                                  
SEQRES   1 H  198  GLY SER MET THR PRO ARG LYS VAL ALA ARG ILE LEU VAL          
SEQRES   2 H  198  ALA PRO ASN GLU ARG ASP ALA ALA ARG ARG ILE VAL ARG          
SEQRES   3 H  198  THR THR TYR GLU ALA GLN GLY TYR ALA ILE ASP GLU SER          
SEQRES   4 H  198  PHE ALA THR PHE LEU GLU GLY PRO SER ALA THR THR PHE          
SEQRES   5 H  198  GLY LEU PHE ASN GLY GLU VAL LEU TYR GLY THR ILE SER          
SEQRES   6 H  198  ILE ILE ASN ASP GLY ALA GLN GLY LEU PRO MET ASP SER          
SEQRES   7 H  198  ILE TYR ALA VAL GLU LEU ALA ALA TRP ARG GLY GLU GLY          
SEQRES   8 H  198  LYS LYS LEU ALA GLU VAL VAL GLN PHE ALA MET ASP HIS          
SEQRES   9 H  198  THR LEU TYR GLU ALA VAL ALA GLY ALA LYS PRO SER PRO          
SEQRES  10 H  198  PHE GLU ALA ALA SER LEU PHE THR MET VAL LEU THR TYR          
SEQRES  11 H  198  ALA LEU GLU THR HIS ILE ASP TYR LEU CYS ILE SER ILE          
SEQRES  12 H  198  ASN PRO LYS HIS ASP THR PHE TYR SER LEU LEU GLY PHE          
SEQRES  13 H  198  THR GLN ILE GLY ALA LEU LYS HIS TYR GLY THR VAL ASN          
SEQRES  14 H  198  ALA PRO ALA ILE ALA ARG ALA LEU TYR VAL PRO GLU TRP          
SEQRES  15 H  198  ARG SER GLN THR LEU LEU ALA GLN PHE MET ASP ALA GLU          
SEQRES  16 H  198  ARG SER HIS                                                  
HET    NLT    400      26                                                       
HET    NLT    401      26                                                       
HET    NLT    402      26                                                       
HET    NLT    403      26                                                       
HET    NLT    404      26                                                       
HET    NLT    405      26                                                       
HET    NLT    406      26                                                       
HET    NLT    407      26                                                       
HETNAM     NLT N-DODECANOYL-L-TYROSINE                                          
HETSYN     NLT (S)-N-(DODECANOYL)-2-AMINO-3-(4-HYDROXYPHENYL)-                  
HETSYN   2 NLT  PROPANOIC ACID, N-LAURYL-L-TYROSINE, N-LAUROYL-L-               
HETSYN   3 NLT  TYROSINE                                                        
FORMUL   9  NLT    8(C21 H33 N O4)                                              
FORMUL  17  HOH   *9(H2 O)                                                      
CRYST1  182.832  182.832  287.429  90.00  90.00  90.00 I 41 2 2    128          
ATOM   8616  N   LYS G   5     -30.328  44.100  39.888  1.00 40.26           N  
ATOM   8617  CA  LYS G   5     -29.067  43.294  39.850  1.00 40.25           C  
ATOM   8618  C   LYS G   5     -27.837  44.171  40.097  1.00 40.25           C  
ATOM   8619  O   LYS G   5     -27.631  45.174  39.407  1.00 40.21           O  
ATOM   8620  CB  LYS G   5     -28.935  42.553  38.511  1.00 40.20           C  
ATOM   8621  CG  LYS G   5     -30.068  41.576  38.221  1.00 40.26           C  
ATOM   8622  CD  LYS G   5     -29.543  40.196  37.846  1.00 40.37           C  
ATOM   8623  CE  LYS G   5     -30.483  39.093  38.324  1.00 40.48           C  
ATOM   8624  NZ  LYS G   5     -31.768  39.061  37.547  1.00 40.62           N  
ATOM   8625  N   VAL G   6     -27.031  43.792  41.092  1.00 40.27           N  
ATOM   8626  CA  VAL G   6     -25.826  44.553  41.438  1.00 40.25           C  
ATOM   8627  C   VAL G   6     -24.594  43.688  41.591  1.00 40.22           C  
ATOM   8628  O   VAL G   6     -24.600  42.701  42.330  1.00 40.26           O  
ATOM   8629  CB  VAL G   6     -25.998  45.401  42.737  1.00 40.24           C  
ATOM   8630  CG1 VAL G   6     -26.426  46.808  42.397  1.00 40.31           C  
ATOM   8631  CG2 VAL G   6     -26.987  44.758  43.688  1.00 40.23           C  
ATOM   8632  N   ALA G   7     -23.540  44.063  40.870  1.00 40.21           N  
ATOM   8633  CA  ALA G   7     -22.215  43.494  41.070  1.00 40.20           C  
ATOM   8634  C   ALA G   7     -21.411  44.474  41.922  1.00 40.21           C  
ATOM   8635  O   ALA G   7     -21.225  45.639  41.539  1.00 40.22           O  
ATOM   8636  CB  ALA G   7     -21.532  43.246  39.741  1.00 40.21           C  
ATOM   8637  N   ARG G   8     -20.956  44.010  43.084  1.00 40.15           N  
ATOM   8638  CA  ARG G   8     -20.374  44.897  44.089  1.00 40.18           C  
ATOM   8639  C   ARG G   8     -19.079  44.342  44.665  1.00 40.13           C  
ATOM   8640  O   ARG G   8     -18.509  43.414  44.118  1.00 40.12           O  
ATOM   8641  CB  ARG G   8     -21.394  45.156  45.214  1.00 40.22           C  
ATOM   8642  CG  ARG G   8     -21.645  46.628  45.521  1.00 40.10           C  
ATOM   8643  CD  ARG G   8     -22.016  46.904  46.962  1.00 40.23           C  
ATOM   8644  NE  ARG G   8     -23.238  46.204  47.356  1.00 40.34           N  
ATOM   8645  CZ  ARG G   8     -23.299  45.264  48.296  1.00 40.37           C  
ATOM   8646  NH1 ARG G   8     -22.208  44.899  48.952  1.00 40.28           N  
ATOM   8647  NH2 ARG G   8     -24.457  44.687  48.582  1.00 40.49           N  
ATOM   8648  N   ILE G   9     -18.630  44.919  45.781  1.00 40.17           N  
ATOM   8649  CA  ILE G   9     -17.387  44.505  46.431  1.00 40.20           C  
ATOM   8650  C   ILE G   9     -17.637  43.778  47.763  1.00 40.14           C  
ATOM   8651  O   ILE G   9     -18.367  44.266  48.624  1.00 40.07           O  
ATOM   8652  CB  ILE G   9     -16.436  45.725  46.620  1.00 40.23           C  
ATOM   8653  CG1 ILE G   9     -15.779  46.090  45.280  1.00 40.19           C  
ATOM   8654  CG2 ILE G   9     -15.377  45.440  47.710  1.00 40.26           C  
ATOM   8655  CD1 ILE G   9     -15.002  47.402  45.303  1.00 40.27           C  
ATOM   8656  N   ALA G  12     -18.395  44.726  54.202  1.00 40.53           N  
ATOM   8657  CA  ALA G  12     -18.922  44.130  55.422  1.00 40.56           C  
ATOM   8658  C   ALA G  12     -18.457  42.680  55.563  1.00 40.59           C  
ATOM   8659  O   ALA G  12     -18.405  41.944  54.567  1.00 40.58           O  
ATOM   8660  CB  ALA G  12     -20.450  44.209  55.437  1.00 40.54           C  
ATOM   8661  N   PRO G  13     -18.095  42.280  56.791  1.00 40.64           N  
ATOM   8662  CA  PRO G  13     -17.661  40.899  57.075  1.00 40.66           C  
ATOM   8663  C   PRO G  13     -18.771  39.863  56.849  1.00 40.66           C  
ATOM   8664  O   PRO G  13     -18.490  38.770  56.342  1.00 40.65           O  
ATOM   8665  CB  PRO G  13     -17.285  40.948  58.564  1.00 40.67           C  
ATOM   8666  CG  PRO G  13     -17.068  42.396  58.861  1.00 40.69           C  
ATOM   8667  CD  PRO G  13     -18.035  43.135  57.996  1.00 40.62           C  
ATOM   8668  N   ASN G  14     -20.009  40.222  57.210  1.00 40.62           N  
ATOM   8669  CA  ASN G  14     -21.181  39.340  57.080  1.00 40.55           C  
ATOM   8670  C   ASN G  14     -21.571  39.043  55.630  1.00 40.51           C  
ATOM   8671  O   ASN G  14     -22.163  37.996  55.336  1.00 40.48           O  
ATOM   8672  CB  ASN G  14     -22.373  39.944  57.815  1.00 40.52           C  
ATOM   8673  CG  ASN G  14     -22.605  41.389  57.443  1.00 40.52           C  
ATOM   8674  OD1 ASN G  14     -21.906  42.283  57.917  1.00 40.56           O  
ATOM   8675  ND2 ASN G  14     -23.572  41.626  56.566  1.00 40.48           N  
ATOM   8676  N   GLU G  15     -21.264  39.982  54.735  1.00 40.48           N  
ATOM   8677  CA  GLU G  15     -21.474  39.794  53.304  1.00 40.45           C  
ATOM   8678  C   GLU G  15     -20.376  38.911  52.726  1.00 40.41           C  
ATOM   8679  O   GLU G  15     -20.610  38.144  51.788  1.00 40.36           O  
ATOM   8680  CB  GLU G  15     -21.502  41.143  52.587  1.00 40.47           C  
ATOM   8681  CG  GLU G  15     -22.903  41.717  52.403  1.00 40.51           C  
ATOM   8682  CD  GLU G  15     -22.911  43.231  52.286  1.00 40.58           C  
ATOM   8683  OE1 GLU G  15     -21.860  43.817  51.935  1.00 40.68           O  
ATOM   8684  OE2 GLU G  15     -23.972  43.837  52.543  1.00 40.44           O  
ATOM   8685  N   ARG G  16     -19.178  39.019  53.298  1.00 40.41           N  
ATOM   8686  CA  ARG G  16     -18.062  38.160  52.924  1.00 40.43           C  
ATOM   8687  C   ARG G  16     -18.255  36.757  53.487  1.00 40.40           C  
ATOM   8688  O   ARG G  16     -17.732  35.785  52.940  1.00 40.39           O  
ATOM   8689  CB  ARG G  16     -16.739  38.750  53.407  1.00 40.43           C  
ATOM   8690  CG  ARG G  16     -15.819  39.193  52.277  1.00 40.57           C  
ATOM   8691  CD  ARG G  16     -14.741  40.175  52.703  1.00 40.76           C  
ATOM   8692  NE  ARG G  16     -15.282  41.515  52.947  1.00 40.78           N  
ATOM   8693  CZ  ARG G  16     -15.003  42.256  54.015  1.00 40.81           C  
ATOM   8694  NH1 ARG G  16     -14.187  41.799  54.957  1.00 40.87           N  
ATOM   8695  NH2 ARG G  16     -15.541  43.460  54.145  1.00 40.80           N  
ATOM   8696  N   ASP G  17     -19.007  36.668  54.587  1.00 40.36           N  
ATOM   8697  CA  ASP G  17     -19.385  35.388  55.181  1.00 40.38           C  
ATOM   8698  C   ASP G  17     -20.360  34.649  54.273  1.00 40.35           C  
ATOM   8699  O   ASP G  17     -20.278  33.428  54.120  1.00 40.32           O  
ATOM   8700  CB  ASP G  17     -20.023  35.599  56.558  1.00 40.40           C  
ATOM   8701  CG  ASP G  17     -18.996  35.838  57.651  1.00 40.49           C  
ATOM   8702  OD1 ASP G  17     -17.791  35.576  57.420  1.00 40.58           O  
ATOM   8703  OD2 ASP G  17     -19.307  36.285  58.779  1.00 40.48           O  
ATOM   8704  N   ALA G  18     -21.281  35.402  53.674  1.00 40.36           N  
ATOM   8705  CA  ALA G  18     -22.237  34.847  52.723  1.00 40.36           C  
ATOM   8706  C   ALA G  18     -21.545  34.426  51.416  1.00 40.30           C  
ATOM   8707  O   ALA G  18     -21.973  33.475  50.759  1.00 40.28           O  
ATOM   8708  CB  ALA G  18     -23.357  35.847  52.448  1.00 40.31           C  
ATOM   8709  N   ALA G  19     -20.465  35.128  51.067  1.00 40.23           N  
ATOM   8710  CA  ALA G  19     -19.654  34.783  49.904  1.00 40.24           C  
ATOM   8711  C   ALA G  19     -18.971  33.438  50.105  1.00 40.26           C  
ATOM   8712  O   ALA G  19     -18.977  32.593  49.216  1.00 40.21           O  
ATOM   8713  CB  ALA G  19     -18.626  35.868  49.638  1.00 40.26           C  
ATOM   8714  N   ARG G  20     -18.416  33.240  51.299  1.00 40.34           N  
ATOM   8715  CA  ARG G  20     -17.763  31.985  51.666  1.00 40.35           C  
ATOM   8716  C   ARG G  20     -18.762  30.838  51.855  1.00 40.32           C  
ATOM   8717  O   ARG G  20     -18.401  29.670  51.720  1.00 40.25           O  
ATOM   8718  CB  ARG G  20     -16.936  32.170  52.937  1.00 40.38           C  
ATOM   8719  CG  ARG G  20     -15.440  31.987  52.742  1.00 40.45           C  
ATOM   8720  CD  ARG G  20     -14.649  32.037  54.034  1.00 40.71           C  
ATOM   8721  NE  ARG G  20     -14.333  33.410  54.432  1.00 40.85           N  
ATOM   8722  CZ  ARG G  20     -14.854  34.033  55.493  1.00 40.87           C  
ATOM   8723  NH1 ARG G  20     -15.734  33.416  56.278  1.00 40.81           N  
ATOM   8724  NH2 ARG G  20     -14.493  35.280  55.766  1.00 40.93           N  
ATOM   8725  N   ARG G  21     -20.010  31.185  52.180  1.00 40.35           N  
ATOM   8726  CA  ARG G  21     -21.086  30.201  52.322  1.00 40.37           C  
ATOM   8727  C   ARG G  21     -21.474  29.593  50.974  1.00 40.39           C  
ATOM   8728  O   ARG G  21     -21.778  28.400  50.889  1.00 40.43           O  
ATOM   8729  CB  ARG G  21     -22.312  30.830  52.992  1.00 40.37           C  
ATOM   8730  CG  ARG G  21     -22.321  30.687  54.497  1.00 40.38           C  
ATOM   8731  CD  ARG G  21     -23.626  31.088  55.163  1.00 40.42           C  
ATOM   8732  NE  ARG G  21     -23.490  31.083  56.621  1.00 40.71           N  
ATOM   8733  CZ  ARG G  21     -24.424  30.655  57.474  1.00 40.81           C  
ATOM   8734  NH1 ARG G  21     -25.589  30.200  57.025  1.00 40.81           N  
ATOM   8735  NH2 ARG G  21     -24.191  30.686  58.781  1.00 40.74           N  
ATOM   8736  N   ILE G  22     -21.463  30.420  49.926  1.00 40.36           N  
ATOM   8737  CA  ILE G  22     -21.728  29.953  48.565  1.00 40.36           C  
ATOM   8738  C   ILE G  22     -20.562  29.088  48.066  1.00 40.36           C  
ATOM   8739  O   ILE G  22     -20.778  28.043  47.447  1.00 40.37           O  
ATOM   8740  CB  ILE G  22     -22.003  31.156  47.606  1.00 40.35           C  
ATOM   8741  CG1 ILE G  22     -23.268  31.901  48.035  1.00 40.39           C  
ATOM   8742  CG2 ILE G  22     -22.149  30.687  46.151  1.00 40.31           C  
ATOM   8743  CD1 ILE G  22     -23.267  33.362  47.679  1.00 40.39           C  
ATOM   8744  N   VAL G  23     -19.334  29.517  48.375  1.00 40.34           N  
ATOM   8745  CA  VAL G  23     -18.126  28.751  48.050  1.00 40.32           C  
ATOM   8746  C   VAL G  23     -18.157  27.365  48.722  1.00 40.34           C  
ATOM   8747  O   VAL G  23     -17.940  26.346  48.063  1.00 40.24           O  
ATOM   8748  CB  VAL G  23     -16.831  29.522  48.461  1.00 40.31           C  
ATOM   8749  CG1 VAL G  23     -15.594  28.652  48.279  1.00 40.39           C  
ATOM   8750  CG2 VAL G  23     -16.690  30.802  47.662  1.00 40.33           C  
ATOM   8751  N   ARG G  24     -18.479  27.351  50.021  1.00 40.40           N  
ATOM   8752  CA  ARG G  24     -18.583  26.121  50.824  1.00 40.43           C  
ATOM   8753  C   ARG G  24     -19.573  25.106  50.238  1.00 40.46           C  
ATOM   8754  O   ARG G  24     -19.227  23.938  50.047  1.00 40.40           O  
ATOM   8755  CB  ARG G  24     -19.016  26.465  52.252  1.00 40.47           C  
ATOM   8756  CG  ARG G  24     -18.061  26.015  53.342  1.00 40.54           C  
ATOM   8757  CD  ARG G  24     -18.423  26.555  54.716  1.00 40.52           C  
ATOM   8758  NE  ARG G  24     -17.278  27.179  55.373  1.00 40.75           N  
ATOM   8759  CZ  ARG G  24     -17.054  27.149  56.689  1.00 40.88           C  
ATOM   8760  NH1 ARG G  24     -17.901  26.523  57.502  1.00 40.72           N  
ATOM   8761  NH2 ARG G  24     -15.981  27.743  57.192  1.00 40.81           N  
ATOM   8762  N   THR G  25     -20.797  25.572  49.958  1.00 40.48           N  
ATOM   8763  CA  THR G  25     -21.892  24.718  49.475  1.00 40.47           C  
ATOM   8764  C   THR G  25     -21.655  24.199  48.048  1.00 40.44           C  
ATOM   8765  O   THR G  25     -21.997  23.058  47.733  1.00 40.41           O  
ATOM   8766  CB  THR G  25     -23.257  25.471  49.586  1.00 40.50           C  
ATOM   8767  OG1 THR G  25     -23.465  25.897  50.938  1.00 40.51           O  
ATOM   8768  CG2 THR G  25     -24.437  24.526  49.341  1.00 40.46           C  
ATOM   8769  N   THR G  26     -21.053  25.034  47.203  1.00 40.45           N  
ATOM   8770  CA  THR G  26     -20.714  24.643  45.829  1.00 40.52           C  
ATOM   8771  C   THR G  26     -19.604  23.587  45.811  1.00 40.52           C  
ATOM   8772  O   THR G  26     -19.691  22.591  45.080  1.00 40.51           O  
ATOM   8773  CB  THR G  26     -20.305  25.892  44.994  1.00 40.54           C  
ATOM   8774  OG1 THR G  26     -21.460  26.707  44.754  1.00 40.59           O  
ATOM   8775  CG2 THR G  26     -19.854  25.500  43.582  1.00 40.61           C  
ATOM   8776  N   TYR G  27     -18.586  23.793  46.645  1.00 40.54           N  
ATOM   8777  CA  TYR G  27     -17.433  22.891  46.705  1.00 40.55           C  
ATOM   8778  C   TYR G  27     -17.777  21.576  47.418  1.00 40.54           C  
ATOM   8779  O   TYR G  27     -17.186  20.538  47.123  1.00 40.54           O  
ATOM   8780  CB  TYR G  27     -16.226  23.577  47.380  1.00 40.58           C  
ATOM   8781  CG  TYR G  27     -15.483  24.596  46.502  1.00 40.68           C  
ATOM   8782  CD1 TYR G  27     -16.167  25.365  45.538  1.00 40.82           C  
ATOM   8783  CD2 TYR G  27     -14.105  24.802  46.647  1.00 40.50           C  
ATOM   8784  CE1 TYR G  27     -15.501  26.297  44.747  1.00 40.86           C  
ATOM   8785  CE2 TYR G  27     -13.425  25.738  45.853  1.00 40.54           C  
ATOM   8786  CZ  TYR G  27     -14.136  26.480  44.904  1.00 40.88           C  
ATOM   8787  OH  TYR G  27     -13.498  27.405  44.113  1.00 41.06           O  
ATOM   8788  N   GLU G  28     -18.743  21.626  48.340  1.00 40.50           N  
ATOM   8789  CA  GLU G  28     -19.214  20.421  49.033  1.00 40.48           C  
ATOM   8790  C   GLU G  28     -20.110  19.563  48.134  1.00 40.45           C  
ATOM   8791  O   GLU G  28     -20.174  18.340  48.296  1.00 40.43           O  
ATOM   8792  CB  GLU G  28     -19.954  20.785  50.322  1.00 40.50           C  
ATOM   8793  CG  GLU G  28     -19.183  20.455  51.596  1.00 40.63           C  
ATOM   8794  CD  GLU G  28     -19.830  21.040  52.840  1.00 40.71           C  
ATOM   8795  OE1 GLU G  28     -20.931  20.575  53.218  1.00 40.62           O  
ATOM   8796  OE2 GLU G  28     -19.237  21.961  53.440  1.00 40.75           O  
ATOM   8797  N   ALA G  29     -20.795  20.213  47.189  1.00 40.43           N  
ATOM   8798  CA  ALA G  29     -21.681  19.524  46.248  1.00 40.41           C  
ATOM   8799  C   ALA G  29     -20.910  18.849  45.112  1.00 40.40           C  
ATOM   8800  O   ALA G  29     -21.414  17.922  44.476  1.00 40.38           O  
ATOM   8801  CB  ALA G  29     -22.712  20.487  45.687  1.00 40.42           C  
ATOM   8802  N   GLN G  30     -19.694  19.330  44.858  1.00 40.43           N  
ATOM   8803  CA  GLN G  30     -18.833  18.750  43.832  1.00 40.44           C  
ATOM   8804  C   GLN G  30     -17.765  17.830  44.434  1.00 40.46           C  
ATOM   8805  O   GLN G  30     -17.114  17.066  43.714  1.00 40.51           O  
ATOM   8806  CB  GLN G  30     -18.182  19.847  42.992  1.00 40.42           C  
ATOM   8807  CG  GLN G  30     -18.967  20.212  41.739  1.00 40.49           C  
ATOM   8808  CD  GLN G  30     -18.655  21.611  41.249  1.00 40.62           C  
ATOM   8809  OE1 GLN G  30     -17.558  21.873  40.758  1.00 40.64           O  
ATOM   8810  NE2 GLN G  30     -19.613  22.514  41.391  1.00 40.66           N  
ATOM   8811  N   GLY G  31     -17.586  17.913  45.753  1.00 40.45           N  
ATOM   8812  CA  GLY G  31     -16.664  17.039  46.464  1.00 40.45           C  
ATOM   8813  C   GLY G  31     -15.297  17.633  46.769  1.00 40.43           C  
ATOM   8814  O   GLY G  31     -14.369  16.901  47.123  1.00 40.49           O  
ATOM   8815  N   TYR G  32     -15.170  18.954  46.641  1.00 40.39           N  
ATOM   8816  CA  TYR G  32     -13.907  19.635  46.938  1.00 40.35           C  
ATOM   8817  C   TYR G  32     -13.771  19.923  48.433  1.00 40.35           C  
ATOM   8818  O   TYR G  32     -14.752  20.258  49.104  1.00 40.31           O  
ATOM   8819  CB  TYR G  32     -13.782  20.958  46.162  1.00 40.32           C  
ATOM   8820  CG  TYR G  32     -14.082  20.901  44.673  1.00 40.29           C  
ATOM   8821  CD1 TYR G  32     -14.620  22.011  44.023  1.00 40.39           C  
ATOM   8822  CD2 TYR G  32     -13.793  19.763  43.909  1.00 40.23           C  
ATOM   8823  CE1 TYR G  32     -14.895  21.989  42.660  1.00 40.44           C  
ATOM   8824  CE2 TYR G  32     -14.066  19.727  42.542  1.00 40.30           C  
ATOM   8825  CZ  TYR G  32     -14.619  20.848  41.924  1.00 40.46           C  
ATOM   8826  OH  TYR G  32     -14.896  20.835  40.575  1.00 40.48           O  
ATOM   8827  N   ALA G  33     -12.544  19.806  48.937  1.00 40.37           N  
ATOM   8828  CA  ALA G  33     -12.238  20.138  50.326  1.00 40.40           C  
ATOM   8829  C   ALA G  33     -12.044  21.647  50.498  1.00 40.43           C  
ATOM   8830  O   ALA G  33     -11.566  22.331  49.591  1.00 40.46           O  
ATOM   8831  CB  ALA G  33     -10.998  19.382  50.794  1.00 40.37           C  
ATOM   8832  N   ILE G  34     -12.436  22.157  51.659  1.00 40.46           N  
ATOM   8833  CA  ILE G  34     -12.319  23.582  51.961  1.00 40.52           C  
ATOM   8834  C   ILE G  34     -11.409  23.793  53.161  1.00 40.62           C  
ATOM   8835  O   ILE G  34     -11.700  23.304  54.263  1.00 40.68           O  
ATOM   8836  CB  ILE G  34     -13.714  24.191  52.273  1.00 40.52           C  
ATOM   8837  CG1 ILE G  34     -14.747  23.799  51.211  1.00 40.57           C  
ATOM   8838  CG2 ILE G  34     -13.621  25.704  52.424  1.00 40.52           C  
ATOM   8839  CD1 ILE G  34     -15.852  22.902  51.741  1.00 40.62           C  
ATOM   8840  N   ASP G  35     -10.308  24.513  52.965  1.00 40.65           N  
ATOM   8841  CA  ASP G  35      -9.476  24.907  54.105  1.00 40.65           C  
ATOM   8842  C   ASP G  35      -9.346  26.428  54.245  1.00 40.62           C  
ATOM   8843  O   ASP G  35      -9.596  27.179  53.292  1.00 40.56           O  
ATOM   8844  CB  ASP G  35      -8.108  24.176  54.125  1.00 40.65           C  
ATOM   8845  CG  ASP G  35      -7.163  24.636  53.024  1.00 40.71           C  
ATOM   8846  OD1 ASP G  35      -7.615  25.295  52.066  1.00 40.78           O  
ATOM   8847  OD2 ASP G  35      -5.942  24.363  53.035  1.00 40.74           O  
ATOM   8848  N   GLU G  36      -8.959  26.866  55.438  1.00 40.62           N  
ATOM   8849  CA  GLU G  36      -8.991  28.282  55.801  1.00 40.61           C  
ATOM   8850  C   GLU G  36      -7.863  29.122  55.199  1.00 40.59           C  
ATOM   8851  O   GLU G  36      -7.840  30.345  55.377  1.00 40.58           O  
ATOM   8852  CB  GLU G  36      -9.012  28.441  57.321  1.00 40.62           C  
ATOM   8853  CG  GLU G  36     -10.273  27.915  57.986  1.00 40.62           C  
ATOM   8854  CD  GLU G  36     -10.026  27.436  59.405  1.00 40.79           C  
ATOM   8855  OE1 GLU G  36      -8.843  27.287  59.793  1.00 40.79           O  
ATOM   8856  OE2 GLU G  36     -11.014  27.210  60.135  1.00 40.92           O  
ATOM   8857  N   SER G  37      -6.934  28.470  54.490  1.00 40.59           N  
ATOM   8858  CA  SER G  37      -5.808  29.162  53.844  1.00 40.57           C  
ATOM   8859  C   SER G  37      -6.287  30.176  52.800  1.00 40.60           C  
ATOM   8860  O   SER G  37      -5.637  31.202  52.580  1.00 40.65           O  
ATOM   8861  CB  SER G  37      -4.833  28.159  53.216  1.00 40.53           C  
ATOM   8862  OG  SER G  37      -5.435  27.448  52.150  1.00 40.43           O  
ATOM   8863  N   PHE G  38      -7.431  29.879  52.175  1.00 40.59           N  
ATOM   8864  CA  PHE G  38      -8.080  30.794  51.239  1.00 40.59           C  
ATOM   8865  C   PHE G  38      -8.575  32.039  51.967  1.00 40.57           C  
ATOM   8866  O   PHE G  38      -8.374  33.162  51.499  1.00 40.57           O  
ATOM   8867  CB  PHE G  38      -9.264  30.104  50.546  1.00 40.60           C  
ATOM   8868  CG  PHE G  38      -8.890  29.336  49.303  1.00 40.57           C  
ATOM   8869  CD1 PHE G  38      -9.268  28.000  49.158  1.00 40.59           C  
ATOM   8870  CD2 PHE G  38      -8.187  29.949  48.265  1.00 40.43           C  
ATOM   8871  CE1 PHE G  38      -8.940  27.283  48.005  1.00 40.54           C  
ATOM   8872  CE2 PHE G  38      -7.847  29.234  47.115  1.00 40.43           C  
ATOM   8873  CZ  PHE G  38      -8.231  27.902  46.983  1.00 40.51           C  
ATOM   8874  N   ALA G  39      -9.202  31.825  53.127  1.00 40.50           N  
ATOM   8875  CA  ALA G  39      -9.782  32.909  53.922  1.00 40.49           C  
ATOM   8876  C   ALA G  39      -8.724  33.839  54.523  1.00 40.49           C  
ATOM   8877  O   ALA G  39      -8.992  35.023  54.748  1.00 40.50           O  
ATOM   8878  CB  ALA G  39     -10.683  32.344  55.012  1.00 40.48           C  
ATOM   8879  N   THR G  40      -7.530  33.296  54.785  1.00 40.47           N  
ATOM   8880  CA  THR G  40      -6.401  34.087  55.293  1.00 40.48           C  
ATOM   8881  C   THR G  40      -5.952  35.090  54.238  1.00 40.44           C  
ATOM   8882  O   THR G  40      -5.658  36.251  54.551  1.00 40.43           O  
ATOM   8883  CB  THR G  40      -5.210  33.161  55.695  1.00 40.49           C  
ATOM   8884  OG1 THR G  40      -5.668  32.147  56.597  1.00 40.55           O  
ATOM   8885  CG2 THR G  40      -4.178  33.926  56.531  1.00 40.37           C  
ATOM   8886  N   PHE G  41      -5.921  34.631  52.987  1.00 40.40           N  
ATOM   8887  CA  PHE G  41      -5.548  35.461  51.852  1.00 40.39           C  
ATOM   8888  C   PHE G  41      -6.544  36.594  51.631  1.00 40.40           C  
ATOM   8889  O   PHE G  41      -6.148  37.735  51.384  1.00 40.39           O  
ATOM   8890  CB  PHE G  41      -5.461  34.609  50.587  1.00 40.39           C  
ATOM   8891  CG  PHE G  41      -4.098  34.034  50.330  1.00 40.39           C  
ATOM   8892  CD1 PHE G  41      -3.924  32.656  50.215  1.00 40.30           C  
ATOM   8893  CD2 PHE G  41      -2.987  34.868  50.171  1.00 40.40           C  
ATOM   8894  CE1 PHE G  41      -2.670  32.115  49.968  1.00 40.39           C  
ATOM   8895  CE2 PHE G  41      -1.725  34.334  49.925  1.00 40.38           C  
ATOM   8896  CZ  PHE G  41      -1.566  32.955  49.822  1.00 40.43           C  
ATOM   8897  N   LEU G  42      -7.836  36.272  51.749  1.00 40.41           N  
ATOM   8898  CA  LEU G  42      -8.920  37.225  51.476  1.00 40.43           C  
ATOM   8899  C   LEU G  42      -9.022  38.358  52.511  1.00 40.46           C  
ATOM   8900  O   LEU G  42      -9.411  39.479  52.171  1.00 40.51           O  
ATOM   8901  CB  LEU G  42     -10.267  36.494  51.328  1.00 40.43           C  
ATOM   8902  CG  LEU G  42     -10.429  35.524  50.140  1.00 40.37           C  
ATOM   8903  CD1 LEU G  42     -11.869  35.042  50.012  1.00 40.31           C  
ATOM   8904  CD2 LEU G  42      -9.951  36.144  48.831  1.00 40.23           C  
ATOM   8905  N   GLU G  43      -8.647  38.064  53.758  1.00 40.48           N  
ATOM   8906  CA  GLU G  43      -8.643  39.065  54.833  1.00 40.47           C  
ATOM   8907  C   GLU G  43      -7.443  40.022  54.736  1.00 40.47           C  
ATOM   8908  O   GLU G  43      -7.424  41.072  55.388  1.00 40.46           O  
ATOM   8909  CB  GLU G  43      -8.640  38.381  56.202  1.00 40.46           C  
ATOM   8910  CG  GLU G  43      -9.946  37.695  56.574  1.00 40.54           C  
ATOM   8911  CD  GLU G  43      -9.977  37.228  58.028  1.00 40.72           C  
ATOM   8912  OE1 GLU G  43      -8.902  37.156  58.671  1.00 40.62           O  
ATOM   8913  OE2 GLU G  43     -11.082  36.930  58.528  1.00 40.81           O  
ATOM   8914  N   GLY G  44      -6.446  39.646  53.927  1.00 40.44           N  
ATOM   8915  CA  GLY G  44      -5.225  40.425  53.767  1.00 40.44           C  
ATOM   8916  C   GLY G  44      -5.378  41.696  52.935  1.00 40.46           C  
ATOM   8917  O   GLY G  44      -6.467  41.983  52.426  1.00 40.50           O  
ATOM   8918  N   PRO G  45      -4.282  42.453  52.796  1.00 40.46           N  
ATOM   8919  CA  PRO G  45      -4.295  43.742  52.085  1.00 40.47           C  
ATOM   8920  C   PRO G  45      -4.395  43.626  50.564  1.00 40.49           C  
ATOM   8921  O   PRO G  45      -4.931  44.532  49.922  1.00 40.54           O  
ATOM   8922  CB  PRO G  45      -2.937  44.362  52.461  1.00 40.42           C  
ATOM   8923  CG  PRO G  45      -2.430  43.525  53.592  1.00 40.48           C  
ATOM   8924  CD  PRO G  45      -2.948  42.147  53.343  1.00 40.46           C  
ATOM   8925  N   SER G  46      -3.887  42.534  50.000  1.00 40.50           N  
ATOM   8926  CA  SER G  46      -3.779  42.404  48.545  1.00 40.49           C  
ATOM   8927  C   SER G  46      -5.027  41.826  47.859  1.00 40.50           C  
ATOM   8928  O   SER G  46      -5.101  41.799  46.628  1.00 40.58           O  
ATOM   8929  CB  SER G  46      -2.536  41.587  48.171  1.00 40.46           C  
ATOM   8930  OG  SER G  46      -2.561  40.309  48.782  1.00 40.48           O  
ATOM   8931  N   ALA G  47      -6.010  41.391  48.646  1.00 40.47           N  
ATOM   8932  CA  ALA G  47      -7.188  40.719  48.083  1.00 40.45           C  
ATOM   8933  C   ALA G  47      -8.457  41.575  48.033  1.00 40.49           C  
ATOM   8934  O   ALA G  47      -8.698  42.416  48.905  1.00 40.58           O  
ATOM   8935  CB  ALA G  47      -7.455  39.423  48.807  1.00 40.42           C  
ATOM   8936  N   THR G  48      -9.264  41.334  47.001  1.00 40.45           N  
ATOM   8937  CA  THR G  48     -10.541  42.010  46.815  1.00 40.42           C  
ATOM   8938  C   THR G  48     -11.588  40.973  46.418  1.00 40.41           C  
ATOM   8939  O   THR G  48     -11.322  40.106  45.579  1.00 40.40           O  
ATOM   8940  CB  THR G  48     -10.420  43.096  45.711  1.00 40.42           C  
ATOM   8941  OG1 THR G  48      -9.354  43.998  46.033  1.00 40.42           O  
ATOM   8942  CG2 THR G  48     -11.653  44.004  45.695  1.00 40.41           C  
ATOM   8943  N   THR G  49     -12.766  41.055  47.033  1.00 40.35           N  
ATOM   8944  CA  THR G  49     -13.859  40.135  46.730  1.00 40.32           C  
ATOM   8945  C   THR G  49     -15.005  40.851  46.010  1.00 40.31           C  
ATOM   8946  O   THR G  49     -15.254  42.033  46.237  1.00 40.30           O  
ATOM   8947  CB  THR G  49     -14.364  39.462  48.019  1.00 40.30           C  
ATOM   8948  OG1 THR G  49     -13.244  39.001  48.780  1.00 40.53           O  
ATOM   8949  CG2 THR G  49     -15.119  38.171  47.705  1.00 40.25           C  
ATOM   8950  N   PHE G  50     -15.678  40.125  45.122  1.00 40.28           N  
ATOM   8951  CA  PHE G  50     -16.838  40.639  44.408  1.00 40.23           C  
ATOM   8952  C   PHE G  50     -18.024  39.698  44.584  1.00 40.18           C  
ATOM   8953  O   PHE G  50     -17.845  38.500  44.813  1.00 40.12           O  
ATOM   8954  CB  PHE G  50     -16.525  40.805  42.913  1.00 40.29           C  
ATOM   8955  CG  PHE G  50     -15.356  41.712  42.627  1.00 40.34           C  
ATOM   8956  CD1 PHE G  50     -15.391  43.060  42.987  1.00 40.34           C  
ATOM   8957  CD2 PHE G  50     -14.225  41.223  41.982  1.00 40.32           C  
ATOM   8958  CE1 PHE G  50     -14.312  43.903  42.714  1.00 40.37           C  
ATOM   8959  CE2 PHE G  50     -13.142  42.060  41.708  1.00 40.33           C  
ATOM   8960  CZ  PHE G  50     -13.187  43.400  42.078  1.00 40.34           C  
ATOM   8961  N   GLY G  51     -19.234  40.244  44.467  1.00 40.17           N  
ATOM   8962  CA  GLY G  51     -20.447  39.458  44.600  1.00 40.14           C  
ATOM   8963  C   GLY G  51     -21.602  39.954  43.747  1.00 40.19           C  
ATOM   8964  O   GLY G  51     -21.625  41.118  43.337  1.00 40.15           O  
ATOM   8965  N   LEU G  52     -22.557  39.059  43.472  1.00 40.25           N  
ATOM   8966  CA  LEU G  52     -23.775  39.403  42.718  1.00 40.27           C  
ATOM   8967  C   LEU G  52     -24.999  39.338  43.611  1.00 40.32           C  
ATOM   8968  O   LEU G  52     -25.203  38.356  44.328  1.00 40.39           O  
ATOM   8969  CB  LEU G  52     -23.990  38.448  41.542  1.00 40.25           C  
ATOM   8970  CG  LEU G  52     -22.914  38.250  40.485  1.00 40.16           C  
ATOM   8971  CD1 LEU G  52     -23.184  36.964  39.745  1.00 40.07           C  
ATOM   8972  CD2 LEU G  52     -22.856  39.422  39.521  1.00 40.14           C  
ATOM   8973  N   PHE G  53     -25.838  40.361  43.537  1.00 40.34           N  
ATOM   8974  CA  PHE G  53     -27.034  40.413  44.360  1.00 40.39           C  
ATOM   8975  C   PHE G  53     -28.302  40.499  43.508  1.00 40.44           C  
ATOM   8976  O   PHE G  53     -28.370  41.287  42.559  1.00 40.43           O  
ATOM   8977  CB  PHE G  53     -26.971  41.593  45.343  1.00 40.42           C  
ATOM   8978  CG  PHE G  53     -25.849  41.500  46.354  1.00 40.42           C  
ATOM   8979  CD1 PHE G  53     -24.555  41.923  46.033  1.00 40.36           C  
ATOM   8980  CD2 PHE G  53     -26.097  41.032  47.643  1.00 40.31           C  
ATOM   8981  CE1 PHE G  53     -23.526  41.849  46.970  1.00 40.25           C  
ATOM   8982  CE2 PHE G  53     -25.072  40.960  48.587  1.00 40.27           C  
ATOM   8983  CZ  PHE G  53     -23.788  41.372  48.250  1.00 40.18           C  
ATOM   8984  N   ASN G  54     -29.291  39.665  43.844  1.00 40.49           N  
ATOM   8985  CA  ASN G  54     -30.612  39.707  43.219  1.00 40.50           C  
ATOM   8986  C   ASN G  54     -31.318  40.994  43.631  1.00 40.51           C  
ATOM   8987  O   ASN G  54     -31.487  41.904  42.822  1.00 40.53           O  
ATOM   8988  CB  ASN G  54     -31.437  38.477  43.628  1.00 40.52           C  
ATOM   8989  CG  ASN G  54     -32.479  38.096  42.588  1.00 40.61           C  
ATOM   8990  OD1 ASN G  54     -32.229  37.267  41.713  1.00 40.69           O  
ATOM   8991  ND2 ASN G  54     -33.657  38.693  42.690  1.00 40.74           N  
ATOM   8992  N   GLY G  55     -31.716  41.063  44.897  1.00 40.51           N  
ATOM   8993  CA  GLY G  55     -32.138  42.310  45.504  1.00 40.52           C  
ATOM   8994  C   GLY G  55     -31.060  42.691  46.492  1.00 40.55           C  
ATOM   8995  O   GLY G  55     -30.264  43.607  46.257  1.00 40.53           O  
ATOM   8996  N   GLU G  56     -31.026  41.955  47.596  1.00 40.55           N  
ATOM   8997  CA  GLU G  56     -29.943  42.034  48.560  1.00 40.54           C  
ATOM   8998  C   GLU G  56     -29.427  40.619  48.817  1.00 40.51           C  
ATOM   8999  O   GLU G  56     -28.598  40.395  49.706  1.00 40.53           O  
ATOM   9000  CB  GLU G  56     -30.432  42.658  49.863  1.00 40.57           C  
ATOM   9001  CG  GLU G  56     -30.774  44.136  49.764  1.00 40.62           C  
ATOM   9002  CD  GLU G  56     -31.573  44.620  50.953  1.00 40.79           C  
ATOM   9003  OE1 GLU G  56     -31.107  44.439  52.101  1.00 40.86           O  
ATOM   9004  OE2 GLU G  56     -32.670  45.173  50.743  1.00 40.87           O  
ATOM   9005  N   VAL G  57     -29.927  39.669  48.021  1.00 40.45           N  
ATOM   9006  CA  VAL G  57     -29.601  38.250  48.179  1.00 40.39           C  
ATOM   9007  C   VAL G  57     -28.361  37.870  47.373  1.00 40.37           C  
ATOM   9008  O   VAL G  57     -28.384  37.869  46.142  1.00 40.40           O  
ATOM   9009  CB  VAL G  57     -30.803  37.340  47.777  1.00 40.37           C  
ATOM   9010  CG1 VAL G  57     -30.438  35.852  47.904  1.00 40.28           C  
ATOM   9011  CG2 VAL G  57     -32.029  37.670  48.625  1.00 40.30           C  
ATOM   9012  N   LEU G  58     -27.281  37.553  48.081  1.00 40.35           N  
ATOM   9013  CA  LEU G  58     -26.034  37.157  47.444  1.00 40.32           C  
ATOM   9014  C   LEU G  58     -26.126  35.716  46.946  1.00 40.30           C  
ATOM   9015  O   LEU G  58     -26.401  34.801  47.726  1.00 40.33           O  
ATOM   9016  CB  LEU G  58     -24.866  37.315  48.424  1.00 40.32           C  
ATOM   9017  CG  LEU G  58     -23.440  37.107  47.894  1.00 40.47           C  
ATOM   9018  CD1 LEU G  58     -23.101  38.104  46.806  1.00 40.61           C  
ATOM   9019  CD2 LEU G  58     -22.427  37.186  49.017  1.00 40.28           C  
ATOM   9020  N   TYR G  59     -25.913  35.520  45.644  1.00 40.27           N  
ATOM   9021  CA  TYR G  59     -25.973  34.181  45.047  1.00 40.24           C  
ATOM   9022  C   TYR G  59     -24.673  33.749  44.360  1.00 40.23           C  
ATOM   9023  O   TYR G  59     -24.375  32.556  44.289  1.00 40.22           O  
ATOM   9024  CB  TYR G  59     -27.184  34.034  44.096  1.00 40.27           C  
ATOM   9025  CG  TYR G  59     -27.251  35.041  42.946  1.00 40.39           C  
ATOM   9026  CD1 TYR G  59     -26.701  34.744  41.695  1.00 40.41           C  
ATOM   9027  CD2 TYR G  59     -27.916  36.264  43.095  1.00 40.37           C  
ATOM   9028  CE1 TYR G  59     -26.775  35.660  40.633  1.00 40.30           C  
ATOM   9029  CE2 TYR G  59     -27.994  37.180  42.042  1.00 40.30           C  
ATOM   9030  CZ  TYR G  59     -27.423  36.873  40.821  1.00 40.29           C  
ATOM   9031  OH  TYR G  59     -27.504  37.780  39.794  1.00 40.33           O  
ATOM   9032  N   GLY G  60     -23.894  34.720  43.885  1.00 40.23           N  
ATOM   9033  CA  GLY G  60     -22.641  34.433  43.197  1.00 40.28           C  
ATOM   9034  C   GLY G  60     -21.480  35.260  43.721  1.00 40.28           C  
ATOM   9035  O   GLY G  60     -21.680  36.392  44.177  1.00 40.31           O  
ATOM   9036  N   THR G  61     -20.267  34.697  43.664  1.00 40.21           N  
ATOM   9037  CA  THR G  61     -19.070  35.396  44.151  1.00 40.22           C  
ATOM   9038  C   THR G  61     -17.774  35.047  43.404  1.00 40.25           C  
ATOM   9039  O   THR G  61     -17.609  33.937  42.889  1.00 40.25           O  
ATOM   9040  CB  THR G  61     -18.891  35.200  45.690  1.00 40.23           C  
ATOM   9041  OG1 THR G  61     -17.819  36.048  46.158  1.00 40.31           O  
ATOM   9042  CG2 THR G  61     -18.397  33.783  46.013  1.00 40.27           C  
ATOM   9043  N   ILE G  62     -16.872  36.026  43.341  1.00 40.27           N  
ATOM   9044  CA  ILE G  62     -15.542  35.854  42.758  1.00 40.24           C  
ATOM   9045  C   ILE G  62     -14.550  36.787  43.465  1.00 40.28           C  
ATOM   9046  O   ILE G  62     -14.912  37.884  43.897  1.00 40.29           O  
ATOM   9047  CB  ILE G  62     -15.564  36.090  41.207  1.00 40.22           C  
ATOM   9048  CG1 ILE G  62     -14.467  35.271  40.522  1.00 40.10           C  
ATOM   9049  CG2 ILE G  62     -15.440  37.580  40.856  1.00 40.21           C  
ATOM   9050  CD1 ILE G  62     -14.744  34.966  39.076  1.00 39.93           C  
ATOM   9051  N   SER G  63     -13.315  36.328  43.618  1.00 40.32           N  
ATOM   9052  CA  SER G  63     -12.303  37.094  44.340  1.00 40.35           C  
ATOM   9053  C   SER G  63     -10.990  37.139  43.578  1.00 40.38           C  
ATOM   9054  O   SER G  63     -10.686  36.243  42.793  1.00 40.37           O  
ATOM   9055  CB  SER G  63     -12.080  36.504  45.739  1.00 40.35           C  
ATOM   9056  OG  SER G  63     -13.239  35.836  46.219  1.00 40.33           O  
ATOM   9057  N   ILE G  64     -10.230  38.214  43.777  1.00 40.40           N  
ATOM   9058  CA  ILE G  64      -8.900  38.334  43.177  1.00 40.45           C  
ATOM   9059  C   ILE G  64      -7.836  38.670  44.233  1.00 40.47           C  
ATOM   9060  O   ILE G  64      -8.118  39.379  45.201  1.00 40.58           O  
ATOM   9061  CB  ILE G  64      -8.893  39.357  41.979  1.00 40.45           C  
ATOM   9062  CG1 ILE G  64      -8.082  40.607  42.302  1.00 40.48           C  
ATOM   9063  CG2 ILE G  64     -10.305  39.748  41.565  1.00 40.59           C  
ATOM   9064  CD1 ILE G  64      -7.045  40.900  41.280  1.00 40.80           C  
ATOM   9065  N   ILE G  65      -6.641  38.093  44.084  1.00 40.46           N  
ATOM   9066  CA  ILE G  65      -5.526  38.371  45.000  1.00 40.41           C  
ATOM   9067  C   ILE G  65      -4.304  38.870  44.245  1.00 40.36           C  
ATOM   9068  O   ILE G  65      -3.806  38.194  43.350  1.00 40.32           O  
ATOM   9069  CB  ILE G  65      -5.145  37.115  45.828  1.00 40.39           C  
ATOM   9070  CG1 ILE G  65      -6.369  36.512  46.513  1.00 40.42           C  
ATOM   9071  CG2 ILE G  65      -4.072  37.465  46.868  1.00 40.34           C  
ATOM   9072  CD1 ILE G  65      -6.161  35.089  46.976  1.00 40.48           C  
ATOM   9073  N   ASN G  66      -3.821  40.051  44.623  1.00 40.36           N  
ATOM   9074  CA  ASN G  66      -2.610  40.617  44.042  1.00 40.43           C  
ATOM   9075  C   ASN G  66      -1.364  39.916  44.561  1.00 40.47           C  
ATOM   9076  O   ASN G  66      -1.340  39.453  45.702  1.00 40.54           O  
ATOM   9077  CB  ASN G  66      -2.524  42.113  44.339  1.00 40.40           C  
ATOM   9078  CG  ASN G  66      -3.107  42.960  43.231  1.00 40.49           C  
ATOM   9079  OD1 ASN G  66      -4.175  43.547  43.382  1.00 40.79           O  
ATOM   9080  ND2 ASN G  66      -2.410  43.023  42.106  1.00 40.52           N  
ATOM   9081  N   ASP G  67      -0.334  39.830  43.714  1.00 40.52           N  
ATOM   9082  CA  ASP G  67       0.937  39.205  44.095  1.00 40.54           C  
ATOM   9083  C   ASP G  67       1.739  40.124  45.025  1.00 40.55           C  
ATOM   9084  O   ASP G  67       2.491  40.994  44.567  1.00 40.56           O  
ATOM   9085  CB  ASP G  67       1.757  38.836  42.847  1.00 40.54           C  
ATOM   9086  CG  ASP G  67       3.063  38.125  43.188  1.00 40.55           C  
ATOM   9087  OD1 ASP G  67       3.127  37.445  44.238  1.00 40.56           O  
ATOM   9088  OD2 ASP G  67       4.076  38.187  42.459  1.00 40.52           O  
ATOM   9089  N   GLY G  68       1.574  39.915  46.330  1.00 40.53           N  
ATOM   9090  CA  GLY G  68       2.204  40.761  47.324  1.00 40.50           C  
ATOM   9091  C   GLY G  68       3.210  40.034  48.183  1.00 40.50           C  
ATOM   9092  O   GLY G  68       4.034  39.263  47.682  1.00 40.48           O  
ATOM   9093  N   ALA G  69       3.137  40.282  49.487  1.00 40.53           N  
ATOM   9094  CA  ALA G  69       4.079  39.712  50.445  1.00 40.54           C  
ATOM   9095  C   ALA G  69       3.770  38.250  50.770  1.00 40.55           C  
ATOM   9096  O   ALA G  69       4.664  37.488  51.139  1.00 40.59           O  
ATOM   9097  CB  ALA G  69       4.102  40.547  51.720  1.00 40.52           C  
ATOM   9098  N   GLN G  70       2.504  37.865  50.626  1.00 40.53           N  
ATOM   9099  CA  GLN G  70       2.072  36.512  50.970  1.00 40.50           C  
ATOM   9100  C   GLN G  70       1.967  35.606  49.743  1.00 40.46           C  
ATOM   9101  O   GLN G  70       1.618  34.428  49.857  1.00 40.46           O  
ATOM   9102  CB  GLN G  70       0.743  36.545  51.739  1.00 40.49           C  
ATOM   9103  CG  GLN G  70       0.770  37.418  52.997  1.00 40.63           C  
ATOM   9104  CD  GLN G  70       0.968  36.604  54.277  1.00 40.82           C  
ATOM   9105  OE1 GLN G  70      -0.004  36.112  54.865  1.00 40.87           O  
ATOM   9106  NE2 GLN G  70       2.222  36.478  54.720  1.00 40.66           N  
ATOM   9107  N   GLY G  71       2.281  36.163  48.575  1.00 40.40           N  
ATOM   9108  CA  GLY G  71       2.264  35.410  47.332  1.00 40.38           C  
ATOM   9109  C   GLY G  71       0.869  35.047  46.862  1.00 40.36           C  
ATOM   9110  O   GLY G  71      -0.096  35.771  47.122  1.00 40.40           O  
ATOM   9111  N   LEU G  72       0.767  33.913  46.174  1.00 40.33           N  
ATOM   9112  CA  LEU G  72      -0.502  33.445  45.622  1.00 40.32           C  
ATOM   9113  C   LEU G  72      -0.830  32.041  46.137  1.00 40.31           C  
ATOM   9114  O   LEU G  72       0.073  31.295  46.500  1.00 40.34           O  
ATOM   9115  CB  LEU G  72      -0.446  33.436  44.079  1.00 40.31           C  
ATOM   9116  CG  LEU G  72      -0.047  34.710  43.317  1.00 40.28           C  
ATOM   9117  CD1 LEU G  72       0.004  34.433  41.825  1.00 40.28           C  
ATOM   9118  CD2 LEU G  72      -0.991  35.867  43.608  1.00 40.29           C  
ATOM   9119  N   PRO G  73      -2.126  31.697  46.201  1.00 40.33           N  
ATOM   9120  CA  PRO G  73      -2.564  30.308  46.450  1.00 40.33           C  
ATOM   9121  C   PRO G  73      -1.964  29.289  45.466  1.00 40.33           C  
ATOM   9122  O   PRO G  73      -1.946  28.091  45.759  1.00 40.31           O  
ATOM   9123  CB  PRO G  73      -4.076  30.379  46.234  1.00 40.35           C  
ATOM   9124  CG  PRO G  73      -4.440  31.782  46.517  1.00 40.34           C  
ATOM   9125  CD  PRO G  73      -3.269  32.630  46.147  1.00 40.32           C  
ATOM   9126  N   MET G  74      -1.497  29.773  44.315  1.00 40.34           N  
ATOM   9127  CA  MET G  74      -0.881  28.934  43.294  1.00 40.36           C  
ATOM   9128  C   MET G  74       0.524  28.473  43.676  1.00 40.42           C  
ATOM   9129  O   MET G  74       0.996  27.447  43.186  1.00 40.52           O  
ATOM   9130  CB  MET G  74      -0.812  29.691  41.977  1.00 40.34           C  
ATOM   9131  CG  MET G  74      -1.884  29.329  41.007  1.00 40.17           C  
ATOM   9132  SD  MET G  74      -2.021  30.569  39.771  1.00 39.26           S  
ATOM   9133  CE  MET G  74      -2.039  29.607  38.369  1.00 39.66           C  
ATOM   9134  N   ASP G  75       1.184  29.232  44.553  1.00 40.40           N  
ATOM   9135  CA  ASP G  75       2.567  28.955  44.958  1.00 40.37           C  
ATOM   9136  C   ASP G  75       2.749  27.593  45.621  1.00 40.41           C  
ATOM   9137  O   ASP G  75       3.866  27.064  45.673  1.00 40.52           O  
ATOM   9138  CB  ASP G  75       3.084  30.049  45.895  1.00 40.38           C  
ATOM   9139  CG  ASP G  75       3.125  31.416  45.238  1.00 40.33           C  
ATOM   9140  OD1 ASP G  75       2.519  31.588  44.161  1.00 40.40           O  
ATOM   9141  OD2 ASP G  75       3.736  32.384  45.734  1.00 40.34           O  
ATOM   9142  N   SER G  76       1.652  27.027  46.125  1.00 40.39           N  
ATOM   9143  CA  SER G  76       1.691  25.714  46.759  1.00 40.46           C  
ATOM   9144  C   SER G  76       1.856  24.572  45.742  1.00 40.45           C  
ATOM   9145  O   SER G  76       2.186  23.446  46.119  1.00 40.54           O  
ATOM   9146  CB  SER G  76       0.466  25.497  47.673  1.00 40.47           C  
ATOM   9147  OG  SER G  76      -0.644  24.966  46.971  1.00 40.49           O  
ATOM   9148  N   ILE G  77       1.663  24.879  44.457  1.00 40.38           N  
ATOM   9149  CA  ILE G  77       1.826  23.886  43.394  1.00 40.41           C  
ATOM   9150  C   ILE G  77       2.567  24.441  42.151  1.00 40.33           C  
ATOM   9151  O   ILE G  77       3.474  23.790  41.620  1.00 40.33           O  
ATOM   9152  CB  ILE G  77       0.441  23.238  43.030  1.00 40.46           C  
ATOM   9153  CG1 ILE G  77       0.173  22.029  43.925  1.00 40.70           C  
ATOM   9154  CG2 ILE G  77       0.398  22.778  41.603  1.00 40.52           C  
ATOM   9155  CD1 ILE G  77      -0.911  22.251  44.943  1.00 41.17           C  
ATOM   9156  N   TYR G  78       2.211  25.656  41.731  1.00 40.26           N  
ATOM   9157  CA  TYR G  78       2.781  26.258  40.517  1.00 40.20           C  
ATOM   9158  C   TYR G  78       3.775  27.386  40.822  1.00 40.22           C  
ATOM   9159  O   TYR G  78       3.719  28.458  40.210  1.00 40.21           O  
ATOM   9160  CB  TYR G  78       1.660  26.768  39.594  1.00 40.14           C  
ATOM   9161  CG  TYR G  78       0.670  25.705  39.188  1.00 39.95           C  
ATOM   9162  CD1 TYR G  78      -0.636  25.717  39.673  1.00 39.68           C  
ATOM   9163  CD2 TYR G  78       1.039  24.680  38.324  1.00 39.96           C  
ATOM   9164  CE1 TYR G  78      -1.544  24.736  39.304  1.00 39.61           C  
ATOM   9165  CE2 TYR G  78       0.142  23.698  37.953  1.00 39.82           C  
ATOM   9166  CZ  TYR G  78      -1.143  23.729  38.441  1.00 39.59           C  
ATOM   9167  OH  TYR G  78      -2.022  22.748  38.068  1.00 39.64           O  
ATOM   9168  N   ALA G  79       4.699  27.130  41.747  1.00 40.22           N  
ATOM   9169  CA  ALA G  79       5.670  28.138  42.170  1.00 40.25           C  
ATOM   9170  C   ALA G  79       6.728  28.407  41.103  1.00 40.29           C  
ATOM   9171  O   ALA G  79       7.052  29.562  40.821  1.00 40.28           O  
ATOM   9172  CB  ALA G  79       6.324  27.732  43.482  1.00 40.27           C  
ATOM   9173  N   VAL G  80       7.252  27.337  40.506  1.00 40.33           N  
ATOM   9174  CA  VAL G  80       8.300  27.459  39.489  1.00 40.37           C  
ATOM   9175  C   VAL G  80       7.747  27.919  38.132  1.00 40.36           C  
ATOM   9176  O   VAL G  80       8.463  28.524  37.330  1.00 40.40           O  
ATOM   9177  CB  VAL G  80       9.141  26.148  39.340  1.00 40.34           C  
ATOM   9178  CG1 VAL G  80      10.065  25.974  40.517  1.00 40.42           C  
ATOM   9179  CG2 VAL G  80       8.253  24.927  39.173  1.00 40.41           C  
ATOM   9180  N   GLU G  81       6.461  27.665  37.907  1.00 40.33           N  
ATOM   9181  CA  GLU G  81       5.796  28.078  36.678  1.00 40.29           C  
ATOM   9182  C   GLU G  81       5.509  29.580  36.665  1.00 40.26           C  
ATOM   9183  O   GLU G  81       5.349  30.178  35.602  1.00 40.26           O  
ATOM   9184  CB  GLU G  81       4.508  27.285  36.488  1.00 40.30           C  
ATOM   9185  CG  GLU G  81       4.734  25.879  35.951  1.00 40.45           C  
ATOM   9186  CD  GLU G  81       4.782  24.813  37.043  1.00 40.62           C  
ATOM   9187  OE1 GLU G  81       5.129  25.134  38.202  1.00 40.44           O  
ATOM   9188  OE2 GLU G  81       4.481  23.645  36.731  1.00 40.77           O  
ATOM   9189  N   LEU G  82       5.459  30.182  37.852  1.00 40.23           N  
ATOM   9190  CA  LEU G  82       5.255  31.622  37.985  1.00 40.25           C  
ATOM   9191  C   LEU G  82       6.569  32.366  38.221  1.00 40.28           C  
ATOM   9192  O   LEU G  82       6.628  33.594  38.089  1.00 40.26           O  
ATOM   9193  CB  LEU G  82       4.275  31.924  39.126  1.00 40.25           C  
ATOM   9194  CG  LEU G  82       2.823  31.453  38.980  1.00 40.22           C  
ATOM   9195  CD1 LEU G  82       2.064  31.656  40.281  1.00 40.21           C  
ATOM   9196  CD2 LEU G  82       2.118  32.154  37.826  1.00 40.08           C  
ATOM   9197  N   ALA G  83       7.622  31.612  38.551  1.00 40.36           N  
ATOM   9198  CA  ALA G  83       8.925  32.181  38.923  1.00 40.35           C  
ATOM   9199  C   ALA G  83       9.640  32.918  37.787  1.00 40.36           C  
ATOM   9200  O   ALA G  83      10.431  33.829  38.038  1.00 40.36           O  
ATOM   9201  CB  ALA G  83       9.822  31.102  39.497  1.00 40.40           C  
ATOM   9202  N   ALA G  84       9.361  32.513  36.545  1.00 40.38           N  
ATOM   9203  CA  ALA G  84       9.958  33.143  35.363  1.00 40.41           C  
ATOM   9204  C   ALA G  84       9.425  34.562  35.126  1.00 40.43           C  
ATOM   9205  O   ALA G  84      10.163  35.446  34.678  1.00 40.46           O  
ATOM   9206  CB  ALA G  84       9.732  32.278  34.133  1.00 40.43           C  
ATOM   9207  N   TRP G  85       8.146  34.769  35.437  1.00 40.40           N  
ATOM   9208  CA  TRP G  85       7.511  36.076  35.291  1.00 40.36           C  
ATOM   9209  C   TRP G  85       7.941  37.033  36.392  1.00 40.37           C  
ATOM   9210  O   TRP G  85       8.171  38.220  36.140  1.00 40.40           O  
ATOM   9211  CB  TRP G  85       5.996  35.930  35.307  1.00 40.33           C  
ATOM   9212  CG  TRP G  85       5.401  35.630  33.974  1.00 40.35           C  
ATOM   9213  CD1 TRP G  85       5.901  35.976  32.748  1.00 40.36           C  
ATOM   9214  CD2 TRP G  85       4.180  34.935  33.724  1.00 40.35           C  
ATOM   9215  NE1 TRP G  85       5.063  35.533  31.754  1.00 40.34           N  
ATOM   9216  CE2 TRP G  85       3.998  34.888  32.326  1.00 40.35           C  
ATOM   9217  CE3 TRP G  85       3.209  34.339  34.544  1.00 40.43           C  
ATOM   9218  CZ2 TRP G  85       2.894  34.276  31.735  1.00 40.36           C  
ATOM   9219  CZ3 TRP G  85       2.110  33.731  33.948  1.00 40.39           C  
ATOM   9220  CH2 TRP G  85       1.966  33.706  32.560  1.00 40.31           C  
ATOM   9221  N   ARG G  86       8.050  36.507  37.615  1.00 40.37           N  
ATOM   9222  CA  ARG G  86       8.428  37.302  38.785  1.00 40.37           C  
ATOM   9223  C   ARG G  86       9.871  37.791  38.705  1.00 40.41           C  
ATOM   9224  O   ARG G  86      10.206  38.833  39.268  1.00 40.50           O  
ATOM   9225  CB  ARG G  86       8.207  36.505  40.075  1.00 40.33           C  
ATOM   9226  CG  ARG G  86       6.757  36.467  40.538  1.00 40.30           C  
ATOM   9227  CD  ARG G  86       6.558  35.892  41.929  1.00 40.30           C  
ATOM   9228  NE  ARG G  86       5.823  34.628  41.892  1.00 40.29           N  
ATOM   9229  CZ  ARG G  86       4.860  34.288  42.742  1.00 40.27           C  
ATOM   9230  NH1 ARG G  86       4.497  35.113  43.714  1.00 40.34           N  
ATOM   9231  NH2 ARG G  86       4.258  33.115  42.620  1.00 40.30           N  
ATOM   9232  N   GLY G  87      10.711  37.040  37.990  1.00 40.43           N  
ATOM   9233  CA  GLY G  87      12.107  37.400  37.787  1.00 40.53           C  
ATOM   9234  C   GLY G  87      12.292  38.657  36.951  1.00 40.60           C  
ATOM   9235  O   GLY G  87      13.248  39.413  37.157  1.00 40.64           O  
ATOM   9236  N   GLU G  88      11.379  38.884  36.009  1.00 40.65           N  
ATOM   9237  CA  GLU G  88      11.398  40.096  35.191  1.00 40.70           C  
ATOM   9238  C   GLU G  88      10.837  41.278  35.965  1.00 40.72           C  
ATOM   9239  O   GLU G  88      11.197  42.430  35.709  1.00 40.77           O  
ATOM   9240  CB  GLU G  88      10.579  39.896  33.923  1.00 40.71           C  
ATOM   9241  CG  GLU G  88      11.255  39.048  32.867  1.00 40.74           C  
ATOM   9242  CD  GLU G  88      10.285  38.597  31.800  1.00 40.81           C  
ATOM   9243  OE1 GLU G  88       9.823  39.456  31.018  1.00 40.83           O  
ATOM   9244  OE2 GLU G  88       9.973  37.387  31.753  1.00 40.91           O  
ATOM   9245  N   GLY G  89       9.958  40.984  36.917  1.00 40.70           N  
ATOM   9246  CA  GLY G  89       9.266  42.013  37.664  1.00 40.72           C  
ATOM   9247  C   GLY G  89       7.968  42.352  36.970  1.00 40.73           C  
ATOM   9248  O   GLY G  89       7.789  43.466  36.470  1.00 40.78           O  
ATOM   9249  N   LYS G  90       7.069  41.376  36.917  1.00 40.67           N  
ATOM   9250  CA  LYS G  90       5.778  41.549  36.263  1.00 40.62           C  
ATOM   9251  C   LYS G  90       4.650  41.478  37.280  1.00 40.56           C  
ATOM   9252  O   LYS G  90       4.721  40.709  38.238  1.00 40.62           O  
ATOM   9253  CB  LYS G  90       5.583  40.490  35.171  1.00 40.63           C  
ATOM   9254  CG  LYS G  90       6.655  40.509  34.077  1.00 40.64           C  
ATOM   9255  CD  LYS G  90       6.538  41.752  33.191  1.00 40.71           C  
ATOM   9256  CE  LYS G  90       6.601  41.391  31.717  1.00 40.73           C  
ATOM   9257  NZ  LYS G  90       5.411  40.599  31.291  1.00 40.79           N  
ATOM   9258  N   LYS G  91       3.617  42.291  37.077  1.00 40.44           N  
ATOM   9259  CA  LYS G  91       2.488  42.329  37.999  1.00 40.38           C  
ATOM   9260  C   LYS G  91       1.540  41.157  37.764  1.00 40.35           C  
ATOM   9261  O   LYS G  91       0.958  41.020  36.690  1.00 40.37           O  
ATOM   9262  CB  LYS G  91       1.740  43.661  37.894  1.00 40.37           C  
ATOM   9263  CG  LYS G  91       1.399  44.279  39.242  1.00 40.33           C  
ATOM   9264  CD  LYS G  91       0.237  45.248  39.133  1.00 40.28           C  
ATOM   9265  CE  LYS G  91      -0.496  45.378  40.454  1.00 40.36           C  
ATOM   9266  NZ  LYS G  91      -0.532  46.786  40.937  1.00 40.46           N  
ATOM   9267  N   LEU G  92       1.403  40.308  38.778  1.00 40.33           N  
ATOM   9268  CA  LEU G  92       0.537  39.140  38.687  1.00 40.32           C  
ATOM   9269  C   LEU G  92      -0.633  39.218  39.661  1.00 40.34           C  
ATOM   9270  O   LEU G  92      -0.607  39.978  40.640  1.00 40.30           O  
ATOM   9271  CB  LEU G  92       1.332  37.849  38.931  1.00 40.35           C  
ATOM   9272  CG  LEU G  92       2.664  37.645  38.200  1.00 40.42           C  
ATOM   9273  CD1 LEU G  92       3.353  36.382  38.701  1.00 40.32           C  
ATOM   9274  CD2 LEU G  92       2.471  37.593  36.684  1.00 40.41           C  
ATOM   9275  N   ALA G  93      -1.658  38.425  39.374  1.00 40.34           N  
ATOM   9276  CA  ALA G  93      -2.840  38.322  40.212  1.00 40.34           C  
ATOM   9277  C   ALA G  93      -3.502  36.982  39.960  1.00 40.37           C  
ATOM   9278  O   ALA G  93      -3.351  36.400  38.884  1.00 40.40           O  
ATOM   9279  CB  ALA G  93      -3.809  39.454  39.913  1.00 40.34           C  
ATOM   9280  N   GLU G  94      -4.233  36.488  40.951  1.00 40.38           N  
ATOM   9281  CA  GLU G  94      -4.929  35.220  40.816  1.00 40.42           C  
ATOM   9282  C   GLU G  94      -6.415  35.402  41.073  1.00 40.37           C  
ATOM   9283  O   GLU G  94      -6.810  35.902  42.122  1.00 40.47           O  
ATOM   9284  CB  GLU G  94      -4.330  34.174  41.772  1.00 40.44           C  
ATOM   9285  CG  GLU G  94      -5.209  32.951  42.017  1.00 40.67           C  
ATOM   9286  CD  GLU G  94      -4.411  31.673  42.225  1.00 41.04           C  
ATOM   9287  OE1 GLU G  94      -4.821  30.628  41.681  1.00 41.34           O  
ATOM   9288  OE2 GLU G  94      -3.383  31.705  42.935  1.00 40.97           O  
ATOM   9289  N   VAL G  95      -7.234  35.031  40.093  1.00 40.34           N  
ATOM   9290  CA  VAL G  95      -8.682  35.012  40.287  1.00 40.37           C  
ATOM   9291  C   VAL G  95      -9.063  33.690  40.941  1.00 40.38           C  
ATOM   9292  O   VAL G  95      -8.634  32.616  40.504  1.00 40.37           O  
ATOM   9293  CB  VAL G  95      -9.468  35.234  38.976  1.00 40.34           C  
ATOM   9294  CG1 VAL G  95     -10.854  35.761  39.273  1.00 40.36           C  
ATOM   9295  CG2 VAL G  95      -8.732  36.192  38.068  1.00 40.36           C  
ATOM   9296  N   VAL G  96      -9.882  33.783  41.985  1.00 40.39           N  
ATOM   9297  CA  VAL G  96     -10.016  32.713  42.963  1.00 40.39           C  
ATOM   9298  C   VAL G  96     -11.412  32.735  43.635  1.00 40.45           C  
ATOM   9299  O   VAL G  96     -12.047  33.792  43.719  1.00 40.45           O  
ATOM   9300  CB  VAL G  96      -8.842  32.822  44.020  1.00 40.34           C  
ATOM   9301  CG1 VAL G  96      -8.671  34.251  44.489  1.00 40.25           C  
ATOM   9302  CG2 VAL G  96      -9.039  31.916  45.185  1.00 40.37           C  
ATOM   9303  N   GLN G  97     -11.881  31.554  44.068  1.00 40.47           N  
ATOM   9304  CA  GLN G  97     -13.183  31.375  44.755  1.00 40.44           C  
ATOM   9305  C   GLN G  97     -14.383  31.812  43.896  1.00 40.43           C  
ATOM   9306  O   GLN G  97     -15.167  32.688  44.287  1.00 40.44           O  
ATOM   9307  CB  GLN G  97     -13.208  32.048  46.149  1.00 40.45           C  
ATOM   9308  CG  GLN G  97     -12.036  31.677  47.078  1.00 40.53           C  
ATOM   9309  CD  GLN G  97     -12.265  30.390  47.860  1.00 40.54           C  
ATOM   9310  OE1 GLN G  97     -12.789  30.422  48.973  1.00 40.62           O  
ATOM   9311  NE2 GLN G  97     -11.849  29.263  47.291  1.00 40.32           N  
ATOM   9312  N   PHE G  98     -14.498  31.205  42.720  1.00 40.39           N  
ATOM   9313  CA  PHE G  98     -15.617  31.460  41.827  1.00 40.37           C  
ATOM   9314  C   PHE G  98     -16.705  30.423  42.071  1.00 40.34           C  
ATOM   9315  O   PHE G  98     -16.511  29.231  41.827  1.00 40.37           O  
ATOM   9316  CB  PHE G  98     -15.154  31.452  40.356  1.00 40.43           C  
ATOM   9317  CG  PHE G  98     -16.289  31.445  39.348  1.00 40.34           C  
ATOM   9318  CD1 PHE G  98     -17.326  32.378  39.425  1.00 40.10           C  
ATOM   9319  CD2 PHE G  98     -16.306  30.509  38.313  1.00 40.29           C  
ATOM   9320  CE1 PHE G  98     -18.365  32.361  38.508  1.00 40.19           C  
ATOM   9321  CE2 PHE G  98     -17.336  30.490  37.390  1.00 40.30           C  
ATOM   9322  CZ  PHE G  98     -18.371  31.419  37.486  1.00 40.27           C  
ATOM   9323  N   ALA G  99     -17.846  30.890  42.566  1.00 40.33           N  
ATOM   9324  CA  ALA G  99     -18.964  30.011  42.896  1.00 40.33           C  
ATOM   9325  C   ALA G  99     -20.309  30.699  42.696  1.00 40.32           C  
ATOM   9326  O   ALA G  99     -20.448  31.905  42.932  1.00 40.27           O  
ATOM   9327  CB  ALA G  99     -18.838  29.500  44.331  1.00 40.33           C  
ATOM   9328  N   MET G 100     -21.294  29.918  42.259  1.00 40.31           N  
ATOM   9329  CA  MET G 100     -22.660  30.401  42.090  1.00 40.35           C  
ATOM   9330  C   MET G 100     -23.647  29.462  42.789  1.00 40.33           C  
ATOM   9331  O   MET G 100     -23.334  28.294  43.036  1.00 40.33           O  
ATOM   9332  CB  MET G 100     -23.003  30.520  40.600  1.00 40.35           C  
ATOM   9333  CG  MET G 100     -22.244  31.628  39.870  1.00 40.36           C  
ATOM   9334  SD  MET G 100     -23.225  32.474  38.622  1.00 40.36           S  
ATOM   9335  CE  MET G 100     -24.765  32.659  39.462  1.00 40.16           C  
ATOM   9336  N   ASP G 101     -24.829  29.981  43.117  1.00 40.34           N  
ATOM   9337  CA  ASP G 101     -25.879  29.178  43.742  1.00 40.27           C  
ATOM   9338  C   ASP G 101     -27.162  29.206  42.924  1.00 40.21           C  
ATOM   9339  O   ASP G 101     -27.853  30.219  42.877  1.00 40.17           O  
ATOM   9340  CB  ASP G 101     -26.150  29.659  45.168  1.00 40.27           C  
ATOM   9341  CG  ASP G 101     -26.605  28.538  46.086  1.00 40.33           C  
ATOM   9342  OD1 ASP G 101     -26.899  27.428  45.585  1.00 40.25           O  
ATOM   9343  OD2 ASP G 101     -26.699  28.673  47.323  1.00 40.48           O  
ATOM   9344  N   GLU G 106     -32.800  31.019  42.506  1.00 40.27           N  
ATOM   9345  CA  GLU G 106     -33.971  30.293  42.027  1.00 40.30           C  
ATOM   9346  C   GLU G 106     -35.232  30.705  42.789  1.00 40.33           C  
ATOM   9347  O   GLU G 106     -36.289  30.931  42.183  1.00 40.39           O  
ATOM   9348  CB  GLU G 106     -33.745  28.775  42.134  1.00 40.31           C  
ATOM   9349  CG  GLU G 106     -34.939  27.907  41.726  1.00 40.40           C  
ATOM   9350  CD  GLU G 106     -35.349  28.090  40.273  1.00 40.58           C  
ATOM   9351  OE1 GLU G 106     -34.464  28.095  39.393  1.00 40.69           O  
ATOM   9352  OE2 GLU G 106     -36.564  28.223  40.010  1.00 40.69           O  
ATOM   9353  N   ALA G 107     -35.117  30.807  44.112  1.00 40.33           N  
ATOM   9354  CA  ALA G 107     -36.242  31.199  44.964  1.00 40.33           C  
ATOM   9355  C   ALA G 107     -36.551  32.693  44.852  1.00 40.36           C  
ATOM   9356  O   ALA G 107     -37.699  33.114  45.030  1.00 40.35           O  
ATOM   9357  CB  ALA G 107     -35.972  30.816  46.410  1.00 40.30           C  
ATOM   9358  N   VAL G 108     -35.524  33.484  44.542  1.00 40.42           N  
ATOM   9359  CA  VAL G 108     -35.659  34.941  44.433  1.00 40.47           C  
ATOM   9360  C   VAL G 108     -36.167  35.416  43.060  1.00 40.51           C  
ATOM   9361  O   VAL G 108     -36.876  36.420  42.973  1.00 40.54           O  
ATOM   9362  CB  VAL G 108     -34.337  35.673  44.782  1.00 40.48           C  
ATOM   9363  CG1 VAL G 108     -34.262  35.927  46.265  1.00 40.45           C  
ATOM   9364  CG2 VAL G 108     -33.112  34.873  44.299  1.00 40.38           C  
ATOM   9365  N   ALA G 109     -35.789  34.701  42.001  1.00 40.55           N  
ATOM   9366  CA  ALA G 109     -36.225  35.033  40.641  1.00 40.54           C  
ATOM   9367  C   ALA G 109     -36.459  33.766  39.813  1.00 40.55           C  
ATOM   9368  O   ALA G 109     -35.547  33.280  39.133  1.00 40.58           O  
ATOM   9369  CB  ALA G 109     -35.204  35.947  39.958  1.00 40.55           C  
ATOM   9370  N   GLY G 110     -37.685  33.242  39.878  1.00 40.55           N  
ATOM   9371  CA  GLY G 110     -38.043  31.995  39.216  1.00 40.55           C  
ATOM   9372  C   GLY G 110     -37.959  32.044  37.698  1.00 40.59           C  
ATOM   9373  O   GLY G 110     -38.636  32.844  37.049  1.00 40.64           O  
ATOM   9374  N   LYS G 112     -33.944  30.140  37.144  1.00 40.56           N  
ATOM   9375  CA  LYS G 112     -32.645  29.520  36.893  1.00 40.63           C  
ATOM   9376  C   LYS G 112     -31.649  30.519  36.286  1.00 40.62           C  
ATOM   9377  O   LYS G 112     -31.979  31.218  35.322  1.00 40.67           O  
ATOM   9378  CB  LYS G 112     -32.804  28.303  35.974  1.00 40.63           C  
ATOM   9379  CG  LYS G 112     -32.774  26.966  36.703  1.00 40.71           C  
ATOM   9380  CD  LYS G 112     -31.670  26.073  36.170  1.00 40.82           C  
ATOM   9381  CE  LYS G 112     -30.429  26.151  37.043  1.00 40.90           C  
ATOM   9382  NZ  LYS G 112     -29.211  25.724  36.303  1.00 40.89           N  
ATOM   9383  N   PRO G 113     -30.437  30.587  36.862  1.00 40.64           N  
ATOM   9384  CA  PRO G 113     -29.369  31.485  36.378  1.00 40.65           C  
ATOM   9385  C   PRO G 113     -29.015  31.333  34.890  1.00 40.65           C  
ATOM   9386  O   PRO G 113     -29.157  30.249  34.312  1.00 40.68           O  
ATOM   9387  CB  PRO G 113     -28.158  31.084  37.237  1.00 40.62           C  
ATOM   9388  CG  PRO G 113     -28.748  30.531  38.484  1.00 40.61           C  
ATOM   9389  CD  PRO G 113     -30.019  29.835  38.067  1.00 40.63           C  
ATOM   9390  N   SER G 114     -28.569  32.435  34.290  1.00 40.64           N  
ATOM   9391  CA  SER G 114     -28.081  32.447  32.912  1.00 40.62           C  
ATOM   9392  C   SER G 114     -26.540  32.491  32.920  1.00 40.62           C  
ATOM   9393  O   SER G 114     -25.936  32.789  33.959  1.00 40.63           O  
ATOM   9394  CB  SER G 114     -28.655  33.656  32.150  1.00 40.56           C  
ATOM   9395  OG  SER G 114     -29.421  34.496  33.000  1.00 40.63           O  
ATOM   9396  N   PRO G 115     -25.900  32.149  31.789  1.00 40.59           N  
ATOM   9397  CA  PRO G 115     -24.448  32.347  31.633  1.00 40.56           C  
ATOM   9398  C   PRO G 115     -24.013  33.815  31.772  1.00 40.50           C  
ATOM   9399  O   PRO G 115     -22.844  34.077  32.040  1.00 40.57           O  
ATOM   9400  CB  PRO G 115     -24.181  31.849  30.207  1.00 40.57           C  
ATOM   9401  CG  PRO G 115     -25.279  30.890  29.936  1.00 40.56           C  
ATOM   9402  CD  PRO G 115     -26.482  31.445  30.625  1.00 40.60           C  
ATOM   9403  N   PHE G 116     -24.949  34.745  31.611  1.00 40.47           N  
ATOM   9404  CA  PHE G 116     -24.658  36.170  31.737  1.00 40.49           C  
ATOM   9405  C   PHE G 116     -24.358  36.594  33.169  1.00 40.49           C  
ATOM   9406  O   PHE G 116     -23.709  37.620  33.394  1.00 40.54           O  
ATOM   9407  CB  PHE G 116     -25.813  36.995  31.187  1.00 40.47           C  
ATOM   9408  CG  PHE G 116     -25.937  36.938  29.698  1.00 40.54           C  
ATOM   9409  CD1 PHE G 116     -24.814  37.100  28.883  1.00 40.45           C  
ATOM   9410  CD2 PHE G 116     -27.178  36.721  29.098  1.00 40.65           C  
ATOM   9411  CE1 PHE G 116     -24.928  37.048  27.504  1.00 40.61           C  
ATOM   9412  CE2 PHE G 116     -27.302  36.672  27.716  1.00 40.57           C  
ATOM   9413  CZ  PHE G 116     -26.178  36.835  26.918  1.00 40.65           C  
ATOM   9414  N   GLU G 117     -24.845  35.813  34.131  1.00 40.44           N  
ATOM   9415  CA  GLU G 117     -24.585  36.080  35.538  1.00 40.40           C  
ATOM   9416  C   GLU G 117     -23.093  35.992  35.817  1.00 40.39           C  
ATOM   9417  O   GLU G 117     -22.518  36.885  36.445  1.00 40.44           O  
ATOM   9418  CB  GLU G 117     -25.370  35.112  36.433  1.00 40.44           C  
ATOM   9419  CG  GLU G 117     -26.879  35.116  36.195  1.00 40.56           C  
ATOM   9420  CD  GLU G 117     -27.607  36.246  36.916  1.00 40.92           C  
ATOM   9421  OE1 GLU G 117     -26.947  37.207  37.375  1.00 41.11           O  
ATOM   9422  OE2 GLU G 117     -28.852  36.171  37.027  1.00 40.91           O  
ATOM   9423  N   ALA G 118     -22.464  34.939  35.289  1.00 40.32           N  
ATOM   9424  CA  ALA G 118     -21.017  34.758  35.364  1.00 40.22           C  
ATOM   9425  C   ALA G 118     -20.272  35.919  34.706  1.00 40.21           C  
ATOM   9426  O   ALA G 118     -19.303  36.430  35.257  1.00 40.22           O  
ATOM   9427  CB  ALA G 118     -20.620  33.438  34.714  1.00 40.17           C  
ATOM   9428  N   ALA G 119     -20.771  36.358  33.552  1.00 40.28           N  
ATOM   9429  CA  ALA G 119     -20.130  37.413  32.762  1.00 40.34           C  
ATOM   9430  C   ALA G 119     -20.046  38.775  33.474  1.00 40.37           C  
ATOM   9431  O   ALA G 119     -19.099  39.533  33.252  1.00 40.39           O  
ATOM   9432  CB  ALA G 119     -20.816  37.553  31.410  1.00 40.29           C  
ATOM   9433  N   SER G 120     -21.031  39.069  34.328  1.00 40.41           N  
ATOM   9434  CA  SER G 120     -21.039  40.318  35.100  1.00 40.41           C  
ATOM   9435  C   SER G 120     -19.871  40.361  36.079  1.00 40.41           C  
ATOM   9436  O   SER G 120     -19.283  41.423  36.312  1.00 40.45           O  
ATOM   9437  CB  SER G 120     -22.358  40.486  35.852  1.00 40.37           C  
ATOM   9438  OG  SER G 120     -23.463  40.221  35.010  1.00 40.45           O  
ATOM   9439  N   LEU G 121     -19.530  39.198  36.631  1.00 40.38           N  
ATOM   9440  CA  LEU G 121     -18.404  39.073  37.549  1.00 40.38           C  
ATOM   9441  C   LEU G 121     -17.070  39.185  36.816  1.00 40.43           C  
ATOM   9442  O   LEU G 121     -16.164  39.883  37.278  1.00 40.49           O  
ATOM   9443  CB  LEU G 121     -18.468  37.744  38.313  1.00 40.34           C  
ATOM   9444  CG  LEU G 121     -19.426  37.649  39.500  1.00 40.24           C  
ATOM   9445  CD1 LEU G 121     -19.459  36.233  40.055  1.00 40.14           C  
ATOM   9446  CD2 LEU G 121     -19.080  38.656  40.595  1.00 40.15           C  
ATOM   9447  N   PHE G 122     -16.965  38.511  35.662  1.00 40.43           N  
ATOM   9448  CA  PHE G 122     -15.722  38.480  34.869  1.00 40.36           C  
ATOM   9449  C   PHE G 122     -15.347  39.883  34.405  1.00 40.39           C  
ATOM   9450  O   PHE G 122     -14.164  40.210  34.288  1.00 40.39           O  
ATOM   9451  CB  PHE G 122     -15.866  37.558  33.645  1.00 40.33           C  
ATOM   9452  CG  PHE G 122     -15.988  36.082  33.979  1.00 40.22           C  
ATOM   9453  CD1 PHE G 122     -16.349  35.170  32.989  1.00 40.15           C  
ATOM   9454  CD2 PHE G 122     -15.749  35.604  35.267  1.00 40.12           C  
ATOM   9455  CE1 PHE G 122     -16.467  33.814  33.273  1.00 40.14           C  
ATOM   9456  CE2 PHE G 122     -15.865  34.249  35.556  1.00 40.18           C  
ATOM   9457  CZ  PHE G 122     -16.225  33.353  34.556  1.00 40.14           C  
ATOM   9458  N   THR G 123     -16.375  40.695  34.131  1.00 40.44           N  
ATOM   9459  CA  THR G 123     -16.219  42.097  33.758  1.00 40.45           C  
ATOM   9460  C   THR G 123     -15.524  42.870  34.865  1.00 40.45           C  
ATOM   9461  O   THR G 123     -14.522  43.543  34.620  1.00 40.43           O  
ATOM   9462  CB  THR G 123     -17.596  42.724  33.474  1.00 40.46           C  
ATOM   9463  OG1 THR G 123     -18.229  42.015  32.405  1.00 40.64           O  
ATOM   9464  CG2 THR G 123     -17.446  44.145  32.923  1.00 40.48           C  
ATOM   9465  N   MET G 124     -16.056  42.748  36.089  1.00 40.41           N  
ATOM   9466  CA  MET G 124     -15.494  43.407  37.270  1.00 40.36           C  
ATOM   9467  C   MET G 124     -14.012  43.092  37.413  1.00 40.34           C  
ATOM   9468  O   MET G 124     -13.199  43.992  37.620  1.00 40.36           O  
ATOM   9469  CB  MET G 124     -16.239  42.976  38.542  1.00 40.35           C  
ATOM   9470  CG  MET G 124     -17.689  43.438  38.623  1.00 40.34           C  
ATOM   9471  SD  MET G 124     -17.861  45.134  39.202  1.00 40.08           S  
ATOM   9472  CE  MET G 124     -17.839  44.903  40.912  1.00 39.99           C  
ATOM   9473  N   VAL G 125     -13.673  41.809  37.258  1.00 40.30           N  
ATOM   9474  CA  VAL G 125     -12.296  41.332  37.377  1.00 40.30           C  
ATOM   9475  C   VAL G 125     -11.401  41.982  36.323  1.00 40.37           C  
ATOM   9476  O   VAL G 125     -10.351  42.543  36.652  1.00 40.38           O  
ATOM   9477  CB  VAL G 125     -12.216  39.773  37.253  1.00 40.27           C  
ATOM   9478  CG1 VAL G 125     -10.779  39.294  37.307  1.00 40.21           C  
ATOM   9479  CG2 VAL G 125     -13.034  39.101  38.345  1.00 40.23           C  
ATOM   9480  N   LEU G 126     -11.854  41.939  35.068  1.00 40.42           N  
ATOM   9481  CA  LEU G 126     -11.099  42.469  33.932  1.00 40.40           C  
ATOM   9482  C   LEU G 126     -10.924  43.992  33.996  1.00 40.42           C  
ATOM   9483  O   LEU G 126      -9.849  44.510  33.667  1.00 40.38           O  
ATOM   9484  CB  LEU G 126     -11.768  42.057  32.611  1.00 40.42           C  
ATOM   9485  CG  LEU G 126     -11.043  42.354  31.293  1.00 40.36           C  
ATOM   9486  CD1 LEU G 126      -9.938  41.334  31.023  1.00 40.27           C  
ATOM   9487  CD2 LEU G 126     -12.037  42.394  30.141  1.00 40.26           C  
ATOM   9488  N   THR G 127     -11.973  44.698  34.435  1.00 40.45           N  
ATOM   9489  CA  THR G 127     -11.919  46.159  34.574  1.00 40.48           C  
ATOM   9490  C   THR G 127     -10.977  46.568  35.702  1.00 40.46           C  
ATOM   9491  O   THR G 127     -10.307  47.601  35.615  1.00 40.51           O  
ATOM   9492  CB  THR G 127     -13.328  46.771  34.798  1.00 40.48           C  
ATOM   9493  OG1 THR G 127     -14.329  45.915  34.235  1.00 40.54           O  
ATOM   9494  CG2 THR G 127     -13.481  48.051  33.990  1.00 40.43           C  
ATOM   9495  N   TYR G 128     -10.924  45.746  36.752  1.00 40.40           N  
ATOM   9496  CA  TYR G 128      -9.974  45.943  37.841  1.00 40.39           C  
ATOM   9497  C   TYR G 128      -8.557  45.688  37.341  1.00 40.38           C  
ATOM   9498  O   TYR G 128      -7.657  46.490  37.588  1.00 40.40           O  
ATOM   9499  CB  TYR G 128     -10.300  45.016  39.026  1.00 40.38           C  
ATOM   9500  CG  TYR G 128      -9.344  45.139  40.211  1.00 40.48           C  
ATOM   9501  CD1 TYR G 128      -9.574  46.070  41.229  1.00 40.49           C  
ATOM   9502  CD2 TYR G 128      -8.217  44.309  40.321  1.00 40.53           C  
ATOM   9503  CE1 TYR G 128      -8.695  46.181  42.322  1.00 40.54           C  
ATOM   9504  CE2 TYR G 128      -7.335  44.419  41.400  1.00 40.49           C  
ATOM   9505  CZ  TYR G 128      -7.579  45.348  42.394  1.00 40.51           C  
ATOM   9506  OH  TYR G 128      -6.707  45.442  43.453  1.00 40.50           O  
ATOM   9507  N   ALA G 129      -8.379  44.580  36.615  1.00 40.37           N  
ATOM   9508  CA  ALA G 129      -7.067  44.156  36.115  1.00 40.35           C  
ATOM   9509  C   ALA G 129      -6.436  45.171  35.167  1.00 40.38           C  
ATOM   9510  O   ALA G 129      -5.211  45.333  35.151  1.00 40.41           O  
ATOM   9511  CB  ALA G 129      -7.168  42.798  35.445  1.00 40.33           C  
ATOM   9512  N   LEU G 130      -7.276  45.856  34.391  1.00 40.38           N  
ATOM   9513  CA  LEU G 130      -6.813  46.877  33.457  1.00 40.40           C  
ATOM   9514  C   LEU G 130      -6.400  48.163  34.180  1.00 40.41           C  
ATOM   9515  O   LEU G 130      -5.434  48.824  33.784  1.00 40.41           O  
ATOM   9516  CB  LEU G 130      -7.894  47.180  32.413  1.00 40.41           C  
ATOM   9517  CG  LEU G 130      -8.050  46.189  31.251  1.00 40.36           C  
ATOM   9518  CD1 LEU G 130      -9.470  46.231  30.694  1.00 40.29           C  
ATOM   9519  CD2 LEU G 130      -7.025  46.460  30.147  1.00 40.34           C  
ATOM   9520  N   GLU G 131      -7.130  48.503  35.241  1.00 40.43           N  
ATOM   9521  CA  GLU G 131      -6.860  49.718  36.014  1.00 40.48           C  
ATOM   9522  C   GLU G 131      -5.649  49.564  36.938  1.00 40.47           C  
ATOM   9523  O   GLU G 131      -4.871  50.505  37.115  1.00 40.49           O  
ATOM   9524  CB  GLU G 131      -8.094  50.127  36.815  1.00 40.48           C  
ATOM   9525  CG  GLU G 131      -9.188  50.769  35.970  1.00 40.68           C  
ATOM   9526  CD  GLU G 131     -10.071  51.717  36.766  1.00 41.03           C  
ATOM   9527  OE1 GLU G 131     -10.185  51.546  38.003  1.00 41.11           O  
ATOM   9528  OE2 GLU G 131     -10.655  52.635  36.152  1.00 41.14           O  
ATOM   9529  N   THR G 132      -5.485  48.364  37.499  1.00 40.45           N  
ATOM   9530  CA  THR G 132      -4.359  48.057  38.385  1.00 40.41           C  
ATOM   9531  C   THR G 132      -3.067  47.821  37.593  1.00 40.38           C  
ATOM   9532  O   THR G 132      -1.985  47.703  38.180  1.00 40.40           O  
ATOM   9533  CB  THR G 132      -4.683  46.816  39.263  1.00 40.42           C  
ATOM   9534  OG1 THR G 132      -6.078  46.803  39.580  1.00 40.43           O  
ATOM   9535  CG2 THR G 132      -4.023  46.927  40.637  1.00 40.49           C  
ATOM   9536  N   HIS G 133      -3.196  47.773  36.261  1.00 40.36           N  
ATOM   9537  CA  HIS G 133      -2.085  47.480  35.330  1.00 40.36           C  
ATOM   9538  C   HIS G 133      -1.495  46.083  35.553  1.00 40.32           C  
ATOM   9539  O   HIS G 133      -0.273  45.904  35.576  1.00 40.28           O  
ATOM   9540  CB  HIS G 133      -0.983  48.563  35.382  1.00 40.38           C  
ATOM   9541  CG  HIS G 133      -1.443  49.927  34.966  1.00 40.46           C  
ATOM   9542  ND1 HIS G 133      -2.645  50.149  34.324  1.00 40.59           N  
ATOM   9543  CD2 HIS G 133      -0.858  51.141  35.098  1.00 40.49           C  
ATOM   9544  CE1 HIS G 133      -2.781  51.441  34.084  1.00 40.61           C  
ATOM   9545  NE2 HIS G 133      -1.710  52.064  34.542  1.00 40.66           N  
ATOM   9546  N   ILE G 134      -2.379  45.105  35.732  1.00 40.32           N  
ATOM   9547  CA  ILE G 134      -1.976  43.717  35.910  1.00 40.34           C  
ATOM   9548  C   ILE G 134      -1.541  43.133  34.564  1.00 40.36           C  
ATOM   9549  O   ILE G 134      -2.218  43.320  33.547  1.00 40.37           O  
ATOM   9550  CB  ILE G 134      -3.135  42.891  36.565  1.00 40.34           C  
ATOM   9551  CG1 ILE G 134      -3.150  43.111  38.082  1.00 40.40           C  
ATOM   9552  CG2 ILE G 134      -3.013  41.391  36.246  1.00 40.38           C  
ATOM   9553  CD1 ILE G 134      -4.524  43.010  38.720  1.00 40.49           C  
ATOM   9554  N   ASP G 135      -0.378  42.484  34.554  1.00 40.34           N  
ATOM   9555  CA  ASP G 135       0.150  41.869  33.346  1.00 40.30           C  
ATOM   9556  C   ASP G 135      -0.538  40.544  33.064  1.00 40.30           C  
ATOM   9557  O   ASP G 135      -1.095  40.344  31.983  1.00 40.32           O  
ATOM   9558  CB  ASP G 135       1.662  41.673  33.460  1.00 40.28           C  
ATOM   9559  CG  ASP G 135       2.406  42.981  33.639  1.00 40.36           C  
ATOM   9560  OD1 ASP G 135       1.886  44.030  33.201  1.00 40.51           O  
ATOM   9561  OD2 ASP G 135       3.515  43.059  34.202  1.00 40.42           O  
ATOM   9562  N   TYR G 136      -0.524  39.651  34.047  1.00 40.27           N  
ATOM   9563  CA  TYR G 136      -1.115  38.334  33.875  1.00 40.28           C  
ATOM   9564  C   TYR G 136      -2.146  37.989  34.946  1.00 40.26           C  
ATOM   9565  O   TYR G 136      -1.888  38.125  36.146  1.00 40.21           O  
ATOM   9566  CB  TYR G 136      -0.026  37.260  33.804  1.00 40.33           C  
ATOM   9567  CG  TYR G 136       0.716  37.243  32.487  1.00 40.43           C  
ATOM   9568  CD1 TYR G 136       1.961  37.857  32.357  1.00 40.51           C  
ATOM   9569  CD2 TYR G 136       0.164  36.627  31.361  1.00 40.52           C  
ATOM   9570  CE1 TYR G 136       2.639  37.856  31.138  1.00 40.49           C  
ATOM   9571  CE2 TYR G 136       0.833  36.618  30.143  1.00 40.34           C  
ATOM   9572  CZ  TYR G 136       2.066  37.232  30.038  1.00 40.52           C  
ATOM   9573  OH  TYR G 136       2.726  37.220  28.831  1.00 40.79           O  
ATOM   9574  N   LEU G 137      -3.320  37.561  34.492  1.00 40.25           N  
ATOM   9575  CA  LEU G 137      -4.361  37.060  35.371  1.00 40.25           C  
ATOM   9576  C   LEU G 137      -4.275  35.543  35.439  1.00 40.27           C  
ATOM   9577  O   LEU G 137      -4.678  34.845  34.510  1.00 40.24           O  
ATOM   9578  CB  LEU G 137      -5.744  37.485  34.871  1.00 40.25           C  
ATOM   9579  CG  LEU G 137      -6.353  38.779  35.416  1.00 40.25           C  
ATOM   9580  CD1 LEU G 137      -7.787  38.884  34.988  1.00 40.17           C  
ATOM   9581  CD2 LEU G 137      -6.248  38.880  36.925  1.00 40.24           C  
ATOM   9582  N   CYS G 138      -3.751  35.040  36.548  1.00 40.30           N  
ATOM   9583  CA  CYS G 138      -3.518  33.613  36.715  1.00 40.39           C  
ATOM   9584  C   CYS G 138      -4.751  32.872  37.235  1.00 40.37           C  
ATOM   9585  O   CYS G 138      -5.546  33.422  37.990  1.00 40.35           O  
ATOM   9586  CB  CYS G 138      -2.317  33.382  37.617  1.00 40.39           C  
ATOM   9587  SG  CYS G 138      -0.864  34.325  37.111  1.00 40.61           S  
ATOM   9588  N   ILE G 139      -4.886  31.615  36.823  1.00 40.39           N  
ATOM   9589  CA  ILE G 139      -6.108  30.849  37.023  1.00 40.43           C  
ATOM   9590  C   ILE G 139      -5.800  29.398  37.377  1.00 40.48           C  
ATOM   9591  O   ILE G 139      -4.945  28.771  36.759  1.00 40.51           O  
ATOM   9592  CB  ILE G 139      -6.992  30.926  35.715  1.00 40.50           C  
ATOM   9593  CG1 ILE G 139      -7.820  32.199  35.699  1.00 40.48           C  
ATOM   9594  CG2 ILE G 139      -7.913  29.716  35.561  1.00 40.50           C  
ATOM   9595  CD1 ILE G 139      -8.551  32.436  36.945  1.00 40.69           C  
ATOM   9596  N   SER G 140      -6.485  28.880  38.389  1.00 40.50           N  
ATOM   9597  CA  SER G 140      -6.428  27.459  38.708  1.00 40.58           C  
ATOM   9598  C   SER G 140      -7.843  26.910  38.656  1.00 40.51           C  
ATOM   9599  O   SER G 140      -8.728  27.421  39.329  1.00 40.58           O  
ATOM   9600  CB  SER G 140      -5.823  27.250  40.089  1.00 40.67           C  
ATOM   9601  OG  SER G 140      -6.264  28.259  40.981  1.00 41.00           O  
ATOM   9602  N   ILE G 141      -8.060  25.887  37.833  1.00 40.46           N  
ATOM   9603  CA  ILE G 141      -9.418  25.388  37.559  1.00 40.38           C  
ATOM   9604  C   ILE G 141      -9.499  23.868  37.486  1.00 40.37           C  
ATOM   9605  O   ILE G 141      -8.499  23.200  37.224  1.00 40.42           O  
ATOM   9606  CB  ILE G 141      -9.953  25.984  36.231  1.00 40.34           C  
ATOM   9607  CG1 ILE G 141      -8.842  26.063  35.179  1.00 40.33           C  
ATOM   9608  CG2 ILE G 141     -10.563  27.335  36.466  1.00 40.45           C  
ATOM   9609  CD1 ILE G 141      -9.301  25.752  33.772  1.00 40.31           C  
ATOM   9610  N   ASN G 142     -10.695  23.328  37.726  1.00 40.33           N  
ATOM   9611  CA  ASN G 142     -10.957  21.913  37.478  1.00 40.35           C  
ATOM   9612  C   ASN G 142     -10.948  21.660  35.973  1.00 40.36           C  
ATOM   9613  O   ASN G 142     -11.564  22.414  35.220  1.00 40.34           O  
ATOM   9614  CB  ASN G 142     -12.311  21.491  38.066  1.00 40.34           C  
ATOM   9615  CG  ASN G 142     -12.369  19.994  38.412  1.00 40.27           C  
ATOM   9616  OD1 ASN G 142     -12.378  19.621  39.571  1.00 40.22           O  
ATOM   9617  ND2 ASN G 142     -12.432  19.148  37.397  1.00 40.32           N  
ATOM   9618  N   PRO G 143     -10.232  20.617  35.537  1.00 40.37           N  
ATOM   9619  CA  PRO G 143     -10.139  20.258  34.108  1.00 40.39           C  
ATOM   9620  C   PRO G 143     -11.482  20.013  33.375  1.00 40.40           C  
ATOM   9621  O   PRO G 143     -11.468  19.797  32.159  1.00 40.35           O  
ATOM   9622  CB  PRO G 143      -9.311  18.973  34.130  1.00 40.36           C  
ATOM   9623  CG  PRO G 143      -8.534  19.047  35.368  1.00 40.26           C  
ATOM   9624  CD  PRO G 143      -9.383  19.747  36.374  1.00 40.28           C  
ATOM   9625  N   LYS G 144     -12.600  20.009  34.105  1.00 40.42           N  
ATOM   9626  CA  LYS G 144     -13.929  19.960  33.487  1.00 40.51           C  
ATOM   9627  C   LYS G 144     -14.308  21.342  32.932  1.00 40.51           C  
ATOM   9628  O   LYS G 144     -15.122  21.454  32.013  1.00 40.48           O  
ATOM   9629  CB  LYS G 144     -14.987  19.463  34.488  1.00 40.51           C  
ATOM   9630  CG  LYS G 144     -15.140  20.332  35.735  1.00 40.55           C  
ATOM   9631  CD  LYS G 144     -15.922  19.632  36.828  1.00 40.57           C  
ATOM   9632  CE  LYS G 144     -16.597  20.650  37.737  1.00 40.70           C  
ATOM   9633  NZ  LYS G 144     -17.875  20.141  38.332  1.00 40.91           N  
ATOM   9634  N   HIS G 145     -13.695  22.380  33.504  1.00 40.52           N  
ATOM   9635  CA  HIS G 145     -13.858  23.754  33.055  1.00 40.53           C  
ATOM   9636  C   HIS G 145     -12.768  24.137  32.034  1.00 40.50           C  
ATOM   9637  O   HIS G 145     -12.814  25.218  31.449  1.00 40.50           O  
ATOM   9638  CB  HIS G 145     -13.781  24.705  34.256  1.00 40.51           C  
ATOM   9639  CG  HIS G 145     -15.038  24.771  35.068  1.00 40.69           C  
ATOM   9640  ND1 HIS G 145     -15.446  23.746  35.893  1.00 40.77           N  
ATOM   9641  CD2 HIS G 145     -15.959  25.755  35.207  1.00 40.88           C  
ATOM   9642  CE1 HIS G 145     -16.575  24.088  36.492  1.00 40.87           C  
ATOM   9643  NE2 HIS G 145     -16.907  25.304  36.093  1.00 40.80           N  
ATOM   9644  N   ASP G 146     -11.801  23.237  31.825  1.00 40.51           N  
ATOM   9645  CA  ASP G 146     -10.619  23.509  30.978  1.00 40.57           C  
ATOM   9646  C   ASP G 146     -10.964  23.934  29.546  1.00 40.54           C  
ATOM   9647  O   ASP G 146     -10.388  24.892  29.021  1.00 40.59           O  
ATOM   9648  CB  ASP G 146      -9.663  22.301  30.975  1.00 40.58           C  
ATOM   9649  CG  ASP G 146      -8.398  22.548  30.160  1.00 40.72           C  
ATOM   9650  OD1 ASP G 146      -8.320  22.049  29.017  1.00 41.10           O  
ATOM   9651  OD2 ASP G 146      -7.426  23.216  30.582  1.00 40.63           O  
ATOM   9652  N   THR G 147     -11.925  23.249  28.934  1.00 40.47           N  
ATOM   9653  CA  THR G 147     -12.335  23.572  27.569  1.00 40.46           C  
ATOM   9654  C   THR G 147     -13.033  24.946  27.444  1.00 40.42           C  
ATOM   9655  O   THR G 147     -13.059  25.531  26.365  1.00 40.47           O  
ATOM   9656  CB  THR G 147     -13.201  22.428  26.957  1.00 40.49           C  
ATOM   9657  OG1 THR G 147     -13.410  22.678  25.564  1.00 40.57           O  
ATOM   9658  CG2 THR G 147     -14.633  22.420  27.541  1.00 40.64           C  
ATOM   9659  N   PHE G 148     -13.563  25.457  28.558  1.00 40.37           N  
ATOM   9660  CA  PHE G 148     -14.235  26.755  28.573  1.00 40.27           C  
ATOM   9661  C   PHE G 148     -13.236  27.901  28.631  1.00 40.25           C  
ATOM   9662  O   PHE G 148     -13.324  28.850  27.854  1.00 40.24           O  
ATOM   9663  CB  PHE G 148     -15.216  26.858  29.757  1.00 40.25           C  
ATOM   9664  CG  PHE G 148     -15.702  28.270  30.028  1.00 40.20           C  
ATOM   9665  CD1 PHE G 148     -16.736  28.822  29.274  1.00 40.15           C  
ATOM   9666  CD2 PHE G 148     -15.124  29.045  31.039  1.00 40.20           C  
ATOM   9667  CE1 PHE G 148     -17.180  30.124  29.513  1.00 40.14           C  
ATOM   9668  CE2 PHE G 148     -15.559  30.348  31.280  1.00 40.23           C  
ATOM   9669  CZ  PHE G 148     -16.591  30.886  30.516  1.00 40.17           C  
ATOM   9670  N   TYR G 149     -12.308  27.822  29.578  1.00 40.25           N  
ATOM   9671  CA  TYR G 149     -11.371  28.912  29.826  1.00 40.29           C  
ATOM   9672  C   TYR G 149     -10.323  29.049  28.725  1.00 40.33           C  
ATOM   9673  O   TYR G 149      -9.749  30.121  28.543  1.00 40.35           O  
ATOM   9674  CB  TYR G 149     -10.714  28.761  31.197  1.00 40.27           C  
ATOM   9675  CG  TYR G 149     -11.661  29.007  32.353  1.00 40.24           C  
ATOM   9676  CD1 TYR G 149     -12.320  27.950  32.978  1.00 40.25           C  
ATOM   9677  CD2 TYR G 149     -11.899  30.294  32.820  1.00 40.31           C  
ATOM   9678  CE1 TYR G 149     -13.197  28.170  34.038  1.00 40.19           C  
ATOM   9679  CE2 TYR G 149     -12.776  30.522  33.880  1.00 40.42           C  
ATOM   9680  CZ  TYR G 149     -13.415  29.452  34.488  1.00 40.46           C  
ATOM   9681  OH  TYR G 149     -14.289  29.667  35.536  1.00 40.89           O  
ATOM   9682  N   SER G 150     -10.099  27.970  27.973  1.00 40.35           N  
ATOM   9683  CA  SER G 150      -9.211  28.017  26.813  1.00 40.43           C  
ATOM   9684  C   SER G 150      -9.864  28.766  25.649  1.00 40.38           C  
ATOM   9685  O   SER G 150      -9.173  29.327  24.802  1.00 40.44           O  
ATOM   9686  CB  SER G 150      -8.769  26.609  26.386  1.00 40.44           C  
ATOM   9687  OG  SER G 150      -9.851  25.857  25.873  1.00 40.63           O  
ATOM   9688  N   LEU G 151     -11.196  28.775  25.621  1.00 40.37           N  
ATOM   9689  CA  LEU G 151     -11.938  29.585  24.659  1.00 40.39           C  
ATOM   9690  C   LEU G 151     -11.938  31.048  25.086  1.00 40.37           C  
ATOM   9691  O   LEU G 151     -11.983  31.947  24.245  1.00 40.40           O  
ATOM   9692  CB  LEU G 151     -13.381  29.089  24.515  1.00 40.42           C  
ATOM   9693  CG  LEU G 151     -13.655  27.745  23.830  1.00 40.48           C  
ATOM   9694  CD1 LEU G 151     -15.156  27.529  23.695  1.00 40.40           C  
ATOM   9695  CD2 LEU G 151     -12.979  27.651  22.470  1.00 40.47           C  
ATOM   9696  N   LEU G 152     -11.878  31.278  26.399  1.00 40.32           N  
ATOM   9697  CA  LEU G 152     -11.871  32.631  26.953  1.00 40.32           C  
ATOM   9698  C   LEU G 152     -10.573  33.375  26.651  1.00 40.32           C  
ATOM   9699  O   LEU G 152     -10.539  34.606  26.673  1.00 40.35           O  
ATOM   9700  CB  LEU G 152     -12.126  32.600  28.464  1.00 40.31           C  
ATOM   9701  CG  LEU G 152     -13.524  33.003  28.954  1.00 40.35           C  
ATOM   9702  CD1 LEU G 152     -13.468  33.409  30.420  1.00 40.50           C  
ATOM   9703  CD2 LEU G 152     -14.123  34.132  28.113  1.00 40.26           C  
ATOM   9704  N   GLY G 153      -9.507  32.620  26.383  1.00 40.32           N  
ATOM   9705  CA  GLY G 153      -8.229  33.197  26.003  1.00 40.33           C  
ATOM   9706  C   GLY G 153      -7.094  32.878  26.951  1.00 40.28           C  
ATOM   9707  O   GLY G 153      -6.006  33.460  26.857  1.00 40.25           O  
ATOM   9708  N   PHE G 154      -7.343  31.940  27.858  1.00 40.28           N  
ATOM   9709  CA  PHE G 154      -6.365  31.569  28.870  1.00 40.23           C  
ATOM   9710  C   PHE G 154      -5.420  30.473  28.374  1.00 40.19           C  
ATOM   9711  O   PHE G 154      -5.818  29.312  28.221  1.00 40.17           O  
ATOM   9712  CB  PHE G 154      -7.065  31.143  30.164  1.00 40.17           C  
ATOM   9713  CG  PHE G 154      -7.690  32.285  30.922  1.00 40.29           C  
ATOM   9714  CD1 PHE G 154      -8.975  32.740  30.602  1.00 40.31           C  
ATOM   9715  CD2 PHE G 154      -7.006  32.901  31.968  1.00 40.29           C  
ATOM   9716  CE1 PHE G 154      -9.553  33.797  31.304  1.00 40.22           C  
ATOM   9717  CE2 PHE G 154      -7.584  33.959  32.676  1.00 40.14           C  
ATOM   9718  CZ  PHE G 154      -8.853  34.405  32.344  1.00 40.13           C  
ATOM   9719  N   THR G 155      -4.176  30.866  28.101  1.00 40.14           N  
ATOM   9720  CA  THR G 155      -3.117  29.936  27.718  1.00 40.08           C  
ATOM   9721  C   THR G 155      -2.679  29.131  28.938  1.00 40.04           C  
ATOM   9722  O   THR G 155      -2.547  29.679  30.031  1.00 39.94           O  
ATOM   9723  CB  THR G 155      -1.905  30.715  27.143  1.00 40.10           C  
ATOM   9724  OG1 THR G 155      -2.352  31.647  26.151  1.00 40.00           O  
ATOM   9725  CG2 THR G 155      -0.979  29.786  26.360  1.00 40.23           C  
ATOM   9726  N   GLN G 156      -2.473  27.829  28.741  1.00 40.05           N  
ATOM   9727  CA  GLN G 156      -1.974  26.943  29.796  1.00 40.02           C  
ATOM   9728  C   GLN G 156      -0.529  27.271  30.159  1.00 40.05           C  
ATOM   9729  O   GLN G 156       0.352  27.293  29.293  1.00 40.06           O  
ATOM   9730  CB  GLN G 156      -2.074  25.487  29.361  1.00 39.96           C  
ATOM   9731  CG  GLN G 156      -2.397  24.532  30.487  1.00 40.00           C  
ATOM   9732  CD  GLN G 156      -2.230  23.077  30.088  1.00 40.12           C  
ATOM   9733  OE1 GLN G 156      -2.329  22.732  28.908  1.00 40.30           O  
ATOM   9734  NE2 GLN G 156      -1.972  22.220  31.068  1.00 40.02           N  
ATOM   9735  N   ILE G 157      -0.296  27.531  31.442  1.00 40.04           N  
ATOM   9736  CA  ILE G 157       1.032  27.889  31.934  1.00 40.06           C  
ATOM   9737  C   ILE G 157       1.551  26.879  32.961  1.00 40.11           C  
ATOM   9738  O   ILE G 157       2.657  27.026  33.491  1.00 40.09           O  
ATOM   9739  CB  ILE G 157       1.031  29.320  32.532  1.00 40.07           C  
ATOM   9740  CG1 ILE G 157      -0.036  29.460  33.627  1.00 40.01           C  
ATOM   9741  CG2 ILE G 157       0.846  30.362  31.434  1.00 40.08           C  
ATOM   9742  CD1 ILE G 157       0.420  30.270  34.822  1.00 39.99           C  
ATOM   9743  N   GLY G 158       0.743  25.858  33.234  1.00 40.12           N  
ATOM   9744  CA  GLY G 158       1.097  24.823  34.183  1.00 40.18           C  
ATOM   9745  C   GLY G 158       0.334  23.549  33.909  1.00 40.23           C  
ATOM   9746  O   GLY G 158      -0.864  23.586  33.619  1.00 40.21           O  
ATOM   9747  N   ALA G 159       1.030  22.414  34.018  1.00 40.30           N  
ATOM   9748  CA  ALA G 159       0.441  21.102  33.734  1.00 40.30           C  
ATOM   9749  C   ALA G 159      -0.585  20.700  34.789  1.00 40.31           C  
ATOM   9750  O   ALA G 159      -0.723  21.363  35.821  1.00 40.35           O  
ATOM   9751  CB  ALA G 159       1.532  20.047  33.618  1.00 40.32           C  
ATOM   9752  N   LEU G 160      -1.316  19.627  34.516  1.00 40.28           N  
ATOM   9753  CA  LEU G 160      -2.315  19.141  35.451  1.00 40.28           C  
ATOM   9754  C   LEU G 160      -1.653  18.597  36.711  1.00 40.30           C  
ATOM   9755  O   LEU G 160      -0.822  17.699  36.650  1.00 40.33           O  
ATOM   9756  CB  LEU G 160      -3.185  18.071  34.795  1.00 40.28           C  
ATOM   9757  CG  LEU G 160      -4.246  17.343  35.626  1.00 40.27           C  
ATOM   9758  CD1 LEU G 160      -5.039  18.288  36.486  1.00 40.25           C  
ATOM   9759  CD2 LEU G 160      -5.159  16.631  34.702  1.00 40.43           C  
ATOM   9760  N   LYS G 161      -2.012  19.173  37.851  1.00 40.27           N  
ATOM   9761  CA  LYS G 161      -1.473  18.735  39.129  1.00 40.24           C  
ATOM   9762  C   LYS G 161      -2.578  18.655  40.169  1.00 40.26           C  
ATOM   9763  O   LYS G 161      -3.554  19.404  40.107  1.00 40.32           O  
ATOM   9764  CB  LYS G 161      -0.362  19.679  39.592  1.00 40.21           C  
ATOM   9765  CG  LYS G 161       0.934  19.557  38.790  1.00 40.22           C  
ATOM   9766  CD  LYS G 161       2.044  20.383  39.386  1.00 40.37           C  
ATOM   9767  CE  LYS G 161       2.800  21.139  38.317  1.00 40.45           C  
ATOM   9768  NZ  LYS G 161       3.476  22.334  38.881  1.00 40.46           N  
ATOM   9769  N   HIS G 162      -2.427  17.734  41.115  1.00 40.26           N  
ATOM   9770  CA  HIS G 162      -3.410  17.539  42.178  1.00 40.26           C  
ATOM   9771  C   HIS G 162      -3.302  18.638  43.248  1.00 40.29           C  
ATOM   9772  O   HIS G 162      -2.367  18.652  44.051  1.00 40.37           O  
ATOM   9773  CB  HIS G 162      -3.240  16.139  42.792  1.00 40.26           C  
ATOM   9774  CG  HIS G 162      -4.013  15.926  44.057  1.00 40.26           C  
ATOM   9775  ND1 HIS G 162      -5.386  16.035  44.121  1.00 40.35           N  
ATOM   9776  CD2 HIS G 162      -3.604  15.583  45.302  1.00 40.36           C  
ATOM   9777  CE1 HIS G 162      -5.787  15.783  45.353  1.00 40.40           C  
ATOM   9778  NE2 HIS G 162      -4.726  15.506  46.090  1.00 40.22           N  
ATOM   9779  N   TYR G 163      -4.241  19.584  43.204  1.00 40.36           N  
ATOM   9780  CA  TYR G 163      -4.354  20.652  44.203  1.00 40.45           C  
ATOM   9781  C   TYR G 163      -4.786  20.020  45.505  1.00 40.49           C  
ATOM   9782  O   TYR G 163      -5.835  19.385  45.565  1.00 40.56           O  
ATOM   9783  CB  TYR G 163      -5.427  21.654  43.757  1.00 40.56           C  
ATOM   9784  CG  TYR G 163      -5.200  23.113  44.131  1.00 40.76           C  
ATOM   9785  CD1 TYR G 163      -4.024  23.777  43.775  1.00 40.93           C  
ATOM   9786  CD2 TYR G 163      -6.207  23.849  44.764  1.00 40.93           C  
ATOM   9787  CE1 TYR G 163      -3.835  25.132  44.088  1.00 41.01           C  
ATOM   9788  CE2 TYR G 163      -6.030  25.202  45.072  1.00 40.94           C  
ATOM   9789  CZ  TYR G 163      -4.845  25.834  44.734  1.00 40.85           C  
ATOM   9790  OH  TYR G 163      -4.669  27.166  45.042  1.00 40.81           O  
ATOM   9791  N   GLY G 164      -3.970  20.170  46.543  1.00 40.52           N  
ATOM   9792  CA  GLY G 164      -4.278  19.588  47.840  1.00 40.50           C  
ATOM   9793  C   GLY G 164      -5.000  20.540  48.773  1.00 40.51           C  
ATOM   9794  O   GLY G 164      -5.549  20.132  49.800  1.00 40.58           O  
ATOM   9795  N   THR G 165      -4.977  21.819  48.414  1.00 40.52           N  
ATOM   9796  CA  THR G 165      -5.736  22.858  49.098  1.00 40.58           C  
ATOM   9797  C   THR G 165      -7.251  22.608  48.910  1.00 40.59           C  
ATOM   9798  O   THR G 165      -8.066  22.927  49.786  1.00 40.60           O  
ATOM   9799  CB  THR G 165      -5.317  24.249  48.525  1.00 40.61           C  
ATOM   9800  OG1 THR G 165      -3.958  24.526  48.888  1.00 40.73           O  
ATOM   9801  CG2 THR G 165      -6.087  25.388  49.169  1.00 40.54           C  
ATOM   9802  N   VAL G 166      -7.599  21.976  47.793  1.00 40.54           N  
ATOM   9803  CA  VAL G 166      -8.985  21.727  47.442  1.00 40.45           C  
ATOM   9804  C   VAL G 166      -9.314  20.218  47.271  1.00 40.39           C  
ATOM   9805  O   VAL G 166     -10.483  19.840  47.156  1.00 40.34           O  
ATOM   9806  CB  VAL G 166      -9.382  22.578  46.191  1.00 40.49           C  
ATOM   9807  CG1 VAL G 166      -9.300  21.767  44.894  1.00 40.44           C  
ATOM   9808  CG2 VAL G 166     -10.743  23.203  46.381  1.00 40.61           C  
ATOM   9809  N   ASN G 167      -8.270  19.377  47.318  1.00 40.38           N  
ATOM   9810  CA  ASN G 167      -8.374  17.910  47.120  1.00 40.37           C  
ATOM   9811  C   ASN G 167      -8.989  17.487  45.773  1.00 40.37           C  
ATOM   9812  O   ASN G 167      -9.833  16.590  45.715  1.00 40.41           O  
ATOM   9813  CB  ASN G 167      -9.081  17.224  48.306  1.00 40.35           C  
ATOM   9814  CG  ASN G 167      -8.619  15.786  48.517  1.00 40.46           C  
ATOM   9815  OD1 ASN G 167      -8.032  15.167  47.625  1.00 40.50           O  
ATOM   9816  ND2 ASN G 167      -8.892  15.245  49.700  1.00 40.65           N  
ATOM   9817  N   ALA G 168      -8.530  18.126  44.697  1.00 40.38           N  
ATOM   9818  CA  ALA G 168      -9.038  17.870  43.344  1.00 40.40           C  
ATOM   9819  C   ALA G 168      -7.969  18.233  42.302  1.00 40.38           C  
ATOM   9820  O   ALA G 168      -7.035  18.975  42.617  1.00 40.38           O  
ATOM   9821  CB  ALA G 168     -10.331  18.674  43.101  1.00 40.37           C  
ATOM   9822  N   PRO G 169      -8.081  17.691  41.076  1.00 40.33           N  
ATOM   9823  CA  PRO G 169      -7.163  18.051  39.985  1.00 40.29           C  
ATOM   9824  C   PRO G 169      -7.202  19.552  39.676  1.00 40.34           C  
ATOM   9825  O   PRO G 169      -8.250  20.179  39.858  1.00 40.44           O  
ATOM   9826  CB  PRO G 169      -7.715  17.259  38.794  1.00 40.24           C  
ATOM   9827  CG  PRO G 169      -8.440  16.128  39.391  1.00 40.25           C  
ATOM   9828  CD  PRO G 169      -9.045  16.652  40.652  1.00 40.30           C  
ATOM   9829  N   ALA G 170      -6.076  20.116  39.235  1.00 40.33           N  
ATOM   9830  CA  ALA G 170      -6.008  21.544  38.888  1.00 40.32           C  
ATOM   9831  C   ALA G 170      -5.119  21.831  37.676  1.00 40.28           C  
ATOM   9832  O   ALA G 170      -4.034  21.258  37.537  1.00 40.32           O  
ATOM   9833  CB  ALA G 170      -5.554  22.369  40.086  1.00 40.33           C  
ATOM   9834  N   ILE G 171      -5.583  22.739  36.818  1.00 40.19           N  
ATOM   9835  CA  ILE G 171      -4.817  23.186  35.659  1.00 40.16           C  
ATOM   9836  C   ILE G 171      -4.542  24.687  35.764  1.00 40.13           C  
ATOM   9837  O   ILE G 171      -5.449  25.469  36.043  1.00 40.16           O  
ATOM   9838  CB  ILE G 171      -5.572  22.855  34.350  1.00 40.14           C  
ATOM   9839  CG1 ILE G 171      -5.510  21.353  34.070  1.00 40.25           C  
ATOM   9840  CG2 ILE G 171      -5.005  23.645  33.169  1.00 40.13           C  
ATOM   9841  CD1 ILE G 171      -6.255  20.919  32.816  1.00 40.54           C  
ATOM   9842  N   ALA G 172      -3.283  25.072  35.570  1.00 40.09           N  
ATOM   9843  CA  ALA G 172      -2.895  26.474  35.624  1.00 40.07           C  
ATOM   9844  C   ALA G 172      -3.005  27.139  34.260  1.00 40.11           C  
ATOM   9845  O   ALA G 172      -2.511  26.616  33.256  1.00 40.10           O  
ATOM   9846  CB  ALA G 172      -1.506  26.615  36.165  1.00 40.09           C  
ATOM   9847  N   ARG G 173      -3.685  28.283  34.230  1.00 40.14           N  
ATOM   9848  CA  ARG G 173      -3.867  29.067  33.011  1.00 40.12           C  
ATOM   9849  C   ARG G 173      -3.650  30.553  33.313  1.00 40.13           C  
ATOM   9850  O   ARG G 173      -3.795  30.983  34.453  1.00 40.17           O  
ATOM   9851  CB  ARG G 173      -5.268  28.847  32.423  1.00 40.10           C  
ATOM   9852  CG  ARG G 173      -5.741  27.388  32.390  1.00 40.03           C  
ATOM   9853  CD  ARG G 173      -6.527  27.014  31.165  1.00 40.04           C  
ATOM   9854  NE  ARG G 173      -5.670  26.847  29.997  1.00 40.20           N  
ATOM   9855  CZ  ARG G 173      -5.918  26.006  29.004  1.00 40.44           C  
ATOM   9856  NH1 ARG G 173      -6.997  25.248  29.034  1.00 40.71           N  
ATOM   9857  NH2 ARG G 173      -5.093  25.926  27.973  1.00 40.72           N  
ATOM   9858  N   ALA G 174      -3.286  31.331  32.294  1.00 40.12           N  
ATOM   9859  CA  ALA G 174      -3.062  32.769  32.472  1.00 40.11           C  
ATOM   9860  C   ALA G 174      -3.538  33.581  31.276  1.00 40.14           C  
ATOM   9861  O   ALA G 174      -3.644  33.061  30.169  1.00 40.18           O  
ATOM   9862  CB  ALA G 174      -1.607  33.050  32.755  1.00 40.08           C  
ATOM   9863  N   LEU G 175      -3.823  34.861  31.509  1.00 40.16           N  
ATOM   9864  CA  LEU G 175      -4.248  35.762  30.444  1.00 40.16           C  
ATOM   9865  C   LEU G 175      -3.481  37.071  30.476  1.00 40.17           C  
ATOM   9866  O   LEU G 175      -3.441  37.754  31.500  1.00 40.13           O  
ATOM   9867  CB  LEU G 175      -5.752  36.035  30.533  1.00 40.18           C  
ATOM   9868  CG  LEU G 175      -6.384  37.055  29.579  1.00 40.17           C  
ATOM   9869  CD1 LEU G 175      -6.229  36.633  28.127  1.00 40.29           C  
ATOM   9870  CD2 LEU G 175      -7.840  37.248  29.920  1.00 40.15           C  
ATOM   9871  N   TYR G 176      -2.873  37.415  29.346  1.00 40.22           N  
ATOM   9872  CA  TYR G 176      -2.204  38.695  29.208  1.00 40.27           C  
ATOM   9873  C   TYR G 176      -3.245  39.793  29.058  1.00 40.26           C  
ATOM   9874  O   TYR G 176      -3.832  39.972  27.989  1.00 40.23           O  
ATOM   9875  CB  TYR G 176      -1.243  38.687  28.022  1.00 40.28           C  
ATOM   9876  CG  TYR G 176      -0.311  39.874  27.978  1.00 40.38           C  
ATOM   9877  CD1 TYR G 176       0.469  40.216  29.084  1.00 40.41           C  
ATOM   9878  CD2 TYR G 176      -0.204  40.655  26.829  1.00 40.50           C  
ATOM   9879  CE1 TYR G 176       1.327  41.304  29.047  1.00 40.51           C  
ATOM   9880  CE2 TYR G 176       0.654  41.743  26.780  1.00 40.47           C  
ATOM   9881  CZ  TYR G 176       1.416  42.061  27.890  1.00 40.53           C  
ATOM   9882  OH  TYR G 176       2.258  43.140  27.846  1.00 40.70           O  
ATOM   9883  N   VAL G 177      -3.480  40.504  30.156  1.00 40.24           N  
ATOM   9884  CA  VAL G 177      -4.505  41.546  30.232  1.00 40.24           C  
ATOM   9885  C   VAL G 177      -4.383  42.710  29.191  1.00 40.29           C  
ATOM   9886  O   VAL G 177      -5.389  43.068  28.570  1.00 40.30           O  
ATOM   9887  CB  VAL G 177      -4.690  42.065  31.700  1.00 40.24           C  
ATOM   9888  CG1 VAL G 177      -5.596  43.284  31.760  1.00 40.26           C  
ATOM   9889  CG2 VAL G 177      -5.235  40.965  32.578  1.00 40.29           C  
ATOM   9890  N   PRO G 178      -3.176  43.285  28.993  1.00 40.30           N  
ATOM   9891  CA  PRO G 178      -2.997  44.364  28.003  1.00 40.35           C  
ATOM   9892  C   PRO G 178      -3.516  44.044  26.589  1.00 40.39           C  
ATOM   9893  O   PRO G 178      -4.029  44.941  25.915  1.00 40.42           O  
ATOM   9894  CB  PRO G 178      -1.481  44.562  27.984  1.00 40.34           C  
ATOM   9895  CG  PRO G 178      -1.059  44.196  29.345  1.00 40.31           C  
ATOM   9896  CD  PRO G 178      -1.913  43.024  29.721  1.00 40.29           C  
ATOM   9897  N   GLU G 179      -3.377  42.795  26.152  1.00 40.42           N  
ATOM   9898  CA  GLU G 179      -3.893  42.374  24.847  1.00 40.49           C  
ATOM   9899  C   GLU G 179      -4.867  41.212  25.008  1.00 40.48           C  
ATOM   9900  O   GLU G 179      -4.715  40.164  24.368  1.00 40.52           O  
ATOM   9901  CB  GLU G 179      -2.749  41.985  23.903  1.00 40.54           C  
ATOM   9902  CG  GLU G 179      -1.508  42.855  24.021  1.00 40.68           C  
ATOM   9903  CD  GLU G 179      -0.419  42.444  23.059  1.00 40.86           C  
ATOM   9904  OE1 GLU G 179       0.118  41.322  23.204  1.00 40.95           O  
ATOM   9905  OE2 GLU G 179      -0.098  43.246  22.160  1.00 40.91           O  
ATOM   9906  N   TRP G 180      -5.870  41.413  25.860  1.00 40.47           N  
ATOM   9907  CA  TRP G 180      -6.862  40.381  26.188  1.00 40.50           C  
ATOM   9908  C   TRP G 180      -7.815  40.087  25.024  1.00 40.54           C  
ATOM   9909  O   TRP G 180      -8.429  39.017  24.966  1.00 40.54           O  
ATOM   9910  CB  TRP G 180      -7.670  40.801  27.422  1.00 40.46           C  
ATOM   9911  CG  TRP G 180      -8.555  41.985  27.170  1.00 40.50           C  
ATOM   9912  CD1 TRP G 180      -8.187  43.303  27.164  1.00 40.54           C  
ATOM   9913  CD2 TRP G 180      -9.947  41.959  26.848  1.00 40.57           C  
ATOM   9914  NE1 TRP G 180      -9.269  44.099  26.869  1.00 40.60           N  
ATOM   9915  CE2 TRP G 180     -10.364  43.301  26.669  1.00 40.64           C  
ATOM   9916  CE3 TRP G 180     -10.896  40.934  26.693  1.00 40.57           C  
ATOM   9917  CZ2 TRP G 180     -11.686  43.646  26.350  1.00 40.71           C  
ATOM   9918  CZ3 TRP G 180     -12.208  41.277  26.375  1.00 40.69           C  
ATOM   9919  CH2 TRP G 180     -12.589  42.624  26.207  1.00 40.77           C  
ATOM   9920  N   ARG G 181      -7.940  41.053  24.117  1.00 40.60           N  
ATOM   9921  CA  ARG G 181      -8.855  40.956  22.984  1.00 40.63           C  
ATOM   9922  C   ARG G 181      -8.290  40.085  21.861  1.00 40.65           C  
ATOM   9923  O   ARG G 181      -9.023  39.314  21.235  1.00 40.69           O  
ATOM   9924  CB  ARG G 181      -9.190  42.350  22.452  1.00 40.59           C  
ATOM   9925  CG  ARG G 181      -8.713  43.496  23.342  1.00 40.63           C  
ATOM   9926  CD  ARG G 181      -9.490  44.790  23.158  1.00 40.76           C  
ATOM   9927  NE  ARG G 181      -9.444  45.261  21.773  1.00 40.76           N  
ATOM   9928  CZ  ARG G 181     -10.423  45.932  21.175  1.00 40.83           C  
ATOM   9929  NH1 ARG G 181     -11.537  46.226  21.838  1.00 40.91           N  
ATOM   9930  NH2 ARG G 181     -10.288  46.316  19.913  1.00 40.78           N  
ATOM   9931  N   SER G 182      -6.982  40.195  21.622  1.00 40.62           N  
ATOM   9932  CA  SER G 182      -6.324  39.432  20.559  1.00 40.62           C  
ATOM   9933  C   SER G 182      -6.001  37.993  20.987  1.00 40.63           C  
ATOM   9934  O   SER G 182      -5.334  37.254  20.259  1.00 40.65           O  
ATOM   9935  CB  SER G 182      -5.054  40.157  20.074  1.00 40.62           C  
ATOM   9936  OG  SER G 182      -3.960  39.945  20.954  1.00 40.60           O  
ATOM   9937  N   GLN G 183      -6.491  37.604  22.161  1.00 40.64           N  
ATOM   9938  CA  GLN G 183      -6.232  36.280  22.710  1.00 40.67           C  
ATOM   9939  C   GLN G 183      -7.491  35.423  22.772  1.00 40.70           C  
ATOM   9940  O   GLN G 183      -7.418  34.229  23.056  1.00 40.72           O  
ATOM   9941  CB  GLN G 183      -5.623  36.400  24.103  1.00 40.60           C  
ATOM   9942  CG  GLN G 183      -4.177  35.956  24.181  1.00 40.82           C  
ATOM   9943  CD  GLN G 183      -3.518  36.382  25.478  1.00 41.21           C  
ATOM   9944  OE1 GLN G 183      -3.236  37.562  25.672  1.00 41.45           O  
ATOM   9945  NE2 GLN G 183      -3.283  35.424  26.376  1.00 41.09           N  
ATOM   9946  N   THR G 184      -8.641  36.029  22.479  1.00 40.76           N  
ATOM   9947  CA  THR G 184      -9.927  35.341  22.620  1.00 40.79           C  
ATOM   9948  C   THR G 184     -10.657  35.083  21.287  1.00 40.83           C  
ATOM   9949  O   THR G 184     -10.435  35.786  20.291  1.00 40.83           O  
ATOM   9950  CB  THR G 184     -10.845  36.088  23.647  1.00 40.76           C  
ATOM   9951  OG1 THR G 184     -11.939  35.243  24.017  1.00 40.81           O  
ATOM   9952  CG2 THR G 184     -11.533  37.310  23.012  1.00 40.67           C  
ATOM   9953  N   LEU G 185     -11.509  34.055  21.283  1.00 40.88           N  
ATOM   9954  CA  LEU G 185     -12.297  33.696  20.106  1.00 40.91           C  
ATOM   9955  C   LEU G 185     -13.653  34.387  20.131  1.00 40.87           C  
ATOM   9956  O   LEU G 185     -13.733  35.606  20.264  1.00 40.86           O  
ATOM   9957  CB  LEU G 185     -12.476  32.174  20.018  1.00 40.90           C  
ATOM   9958  CG  LEU G 185     -11.478  31.430  19.121  1.00 41.00           C  
ATOM   9959  CD1 LEU G 185     -11.147  30.042  19.682  1.00 40.81           C  
ATOM   9960  CD2 LEU G 185     -12.005  31.331  17.678  1.00 41.00           C  
TER    9961      LEU G 185                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
