
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  164 ( 1351),  selected  164 , name 1ygh_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1ygh_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K    99_A      A       2          3.120
LGA    I   100_A      I       3          1.865
LGA    E   101_A      N       4          1.588
LGA    F   102_A      I       5          1.391
LGA    R   103_A      I       6          1.831
LGA    V   104_A      E       7          2.482
LGA    V   105_A      Y       8          2.709
LGA    N   106_A      -       -           -
LGA    N   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    N   109_A      -       -           -
LGA    T   110_A      -       -           -
LGA    K   111_A      -       -           -
LGA    E   112_A      -       -           -
LGA    N   113_A      N       9          0.982
LGA    M   114_A      R      10          1.632
LGA    M   115_A      S      11          2.475
LGA    V   116_A      Y      12          2.742
LGA    L   117_A      K      13          3.853
LGA    T   118_A      E      14          3.153
LGA    G   119_A      E      15          2.534
LGA    L   120_A      L      16          2.592
LGA    K   121_A      I      17          2.166
LGA    N   122_A      E      18          1.813
LGA    I   123_A      F      19          1.952
LGA    F   124_A      I      20          1.420
LGA    Q   125_A      L      21          0.504
LGA    K   126_A      S      22          1.034
LGA    Q   127_A      I      23          1.454
LGA    L   128_A      Q      24          1.255
LGA    P   129_A      K      25          1.267
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    -       -      N      29           -
LGA    -       -      I      30           -
LGA    K   130_A      K      31          1.976
LGA    M   131_A      I      32          0.895
LGA    P   132_A      D      33          1.437
LGA    K   133_A      R      34          2.350
LGA    E   134_A      D      35          2.575
LGA    Y   135_A      D      36          2.272
LGA    I   136_A      Q      37          2.833
LGA    A   137_A      -       -           -
LGA    R   138_A      P      38          1.772
LGA    L   139_A      D      39          1.480
LGA    V   140_A      L      40          1.969
LGA    Y   141_A      E      41          2.822
LGA    D   142_A      N      42          3.208
LGA    -       -      I      43           -
LGA    -       -      E      44           -
LGA    R   143_A      H      45          1.201
LGA    S   144_A      N      46          2.073
LGA    H   145_A      Y      47          1.914
LGA    -       -      L      48           -
LGA    -       -      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    L   146_A      Q      53          3.483
LGA    S   147_A      F      54          1.348
LGA    M   148_A      W      55          1.232
LGA    A   149_A      L      56          0.983
LGA    V   150_A      A      57          0.657
LGA    I   151_A      I      58          1.535
LGA    R   152_A      N      59          1.916
LGA    K   153_A      N      60          3.366
LGA    P   154_A      H      61          4.400
LGA    L   155_A      Q      62          2.069
LGA    T   156_A      N      63          1.308
LGA    V   157_A      I      64          0.874
LGA    V   158_A      V      65          0.559
LGA    G   159_A      G      66          0.591
LGA    G   160_A      T      67          0.882
LGA    I   161_A      I      68          0.985
LGA    T   162_A      G      69          2.198
LGA    Y   163_A      L      70          2.368
LGA    R   164_A      I      71          1.409
LGA    P   165_A      R      72          1.536
LGA    F   166_A      L      73          2.429
LGA    D   167_A      -       -           -
LGA    K   168_A      D      74          4.514
LGA    R   169_A      N      75          1.832
LGA    E   170_A      N      76          1.194
LGA    F   171_A      M      77          1.448
LGA    A   172_A      S      78          1.315
LGA    E   173_A      A      79          1.057
LGA    I   174_A      L      80          1.319
LGA    V   175_A      K      81          2.205
LGA    F   176_A      K      82          1.405
LGA    C   177_A      M      83          0.864
LGA    A   178_A      F      84          0.584
LGA    I   179_A      V      85          0.220
LGA    S   180_A      D      86          0.729
LGA    S   181_A      K      87          0.924
LGA    T   182_A      G      88          2.145
LGA    E   183_A      Y      89          1.765
LGA    Q   184_A      R      90          2.730
LGA    V   185_A      N      91          3.496
LGA    R   186_A      L      92          2.345
LGA    G   187_A      K      93          0.831
LGA    Y   188_A      I      94          0.967
LGA    G   189_A      G      95          1.302
LGA    A   190_A      K      96          1.342
LGA    H   191_A      K      97          1.431
LGA    L   192_A      L      98          1.283
LGA    M   193_A      L      99          0.841
LGA    N   194_A      D     100          1.226
LGA    H   195_A      K     101          1.541
LGA    L   196_A      V     102          1.367
LGA    K   197_A      I     103          0.772
LGA    D   198_A      M     104          0.921
LGA    Y   199_A      T     105          1.699
LGA    V   200_A      C     106          1.991
LGA    R   201_A      K     107          1.478
LGA    N   202_A      E     108          1.780
LGA    T   203_A      Q     109          3.868
LGA    S   204_A      -       -           -
LGA    N   205_A      N     110          2.637
LGA    I   206_A      I     111          1.608
LGA    K   207_A      D     112          2.065
LGA    Y   208_A      G     113          0.928
LGA    F   209_A      I     114          0.901
LGA    L   210_A      Y     115          0.717
LGA    T   211_A      L     116          0.902
LGA    Y   212_A      G     117          1.020
LGA    A   213_A      T     118          1.298
LGA    D   214_A      I     119          1.161
LGA    N   215_A      D     120          0.950
LGA    Y   216_A      K     121          3.671
LGA    -       -      F     122           -
LGA    -       -      I     123           -
LGA    -       -      S     124           -
LGA    A   217_A      A     125          2.532
LGA    I   218_A      Q     126          1.695
LGA    G   219_A      Y     127          1.804
LGA    Y   220_A      F     128          1.729
LGA    F   221_A      Y     129          1.235
LGA    K   222_A      S     130          1.081
LGA    K   223_A      N     131          1.770
LGA    Q   224_A      N     132          1.639
LGA    G   225_A      G     133          1.369
LGA    F   226_A      F     134          0.873
LGA    T   227_A      R     135          0.943
LGA    K   228_A      E     136          0.748
LGA    E   229_A      I     137          3.456
LGA    I   230_A      K     138          6.228
LGA    T   231_A      R     139           -
LGA    L   232_A      G     140           -
LGA    D   233_A      D     141           #
LGA    K   234_A      L     142          5.273
LGA    S   235_A      -       -           -
LGA    I   236_A      -       -           -
LGA    W   237_A      -       -           -
LGA    M   238_A      P     143          2.924
LGA    G   239_A      S     144          2.555
LGA    Y   240_A      S     145          1.186
LGA    I   241_A      F     146          1.783
LGA    K   242_A      P     147          3.483
LGA    -       -      K     148           -
LGA    D   243_A      L     149          3.360
LGA    Y   244_A      D     150          1.383
LGA    E   245_A      V     151          1.186
LGA    G   246_A      D     152          3.649
LGA    G   247_A      N     153          1.736
LGA    T   248_A      R     154          1.058
LGA    L   249_A      F     155          1.395
LGA    M   250_A      Y     156          0.678
LGA    Q   251_A      Y     157          0.553
LGA    C   252_A      R     158          0.765
LGA    S   253_A      N     159          0.754
LGA    M   254_A      L     160          1.082
LGA    L   255_A      K     161          3.362
LGA    P   256_A      -       -           -
LGA    R   257_A      -       -           -
LGA    I   258_A      -       -           -
LGA    R   259_A      -       -           -
LGA    Y   260_A      -       -           -
LGA    L   261_A      -       -           -
LGA    D   262_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  164  160    5.0    141    2.07    10.64     72.884     6.506

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.691648 * X  +  -0.226386 * Y  +   0.685837 * Z  + -14.671210
  Y_new =   0.100448 * X  +  -0.970527 * Y  +  -0.219060 * Z  +  35.327011
  Z_new =   0.715215 * X  +  -0.082621 * Y  +   0.694003 * Z  +  37.263245 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.118493    3.023100  [ DEG:    -6.7891    173.2109 ]
  Theta =  -0.796932   -2.344660  [ DEG:   -45.6609   -134.3391 ]
  Phi   =   2.997371   -0.144222  [ DEG:   171.7367     -8.2633 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ygh_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ygh_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  164  160   5.0  141   2.07   10.64  72.884
REMARK  ---------------------------------------------------------- 
MOLECULE 1ygh_A
HEADER    GENE REGULATION                         27-MAY-99   1YGH              
TITLE     HAT DOMAIN OF GCN5 FROM SACCHAROMYCES CEREVISIAE                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (TRANSCRIPTIONAL ACTIVATOR GCN5);                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: HISTONE ACETYLTRANSFERASE DOMAIN;                          
COMPND   5 SYNONYM: ADA4;                                                       
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 CELLULAR_LOCATION: NUCLEAR;                                          
SOURCE   5 GENE: GCN5;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: BACTERIAL PLASMID;                    
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PRSET;                                    
SOURCE  10 EXPRESSION_SYSTEM_GENE: GCN5                                         
KEYWDS    TRANSCRIPTIONAL REGULATION, HISTONE ACETYLATION, N-                   
KEYWDS   2 ACETYLTRANSFERASE, GCN5 RELATED N-ACETYLTRANSFERASE FAMILY           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.C.TRIEVEL,J.R.ROJAS,D.E.STERNER,R.VENKATARAMANI,L.WANG,             
AUTHOR   2 J.ZHOU,C.D.ALLIS,S.L.BERGER,R.MARMORSTEIN                            
REVDAT   2   01-APR-03 1YGH    1       JRNL                                     
REVDAT   1   02-AUG-99 1YGH    0                                                
JRNL        AUTH   R.C.TRIEVEL,J.R.ROJAS,D.E.STERNER,                           
JRNL        AUTH 2 R.N.VENKATARAMANI,L.WANG,J.ZHOU,C.D.ALLIS,                   
JRNL        AUTH 3 S.L.BERGER,R.MARMORSTEIN                                     
JRNL        TITL   CRYSTAL STRUCTURE AND MECHANISM OF HISTONE                   
JRNL        TITL 2 ACETYLATION OF THE YEAST GCN5 TRANSCRIPTIONAL                
JRNL        TITL 3 COACTIVATOR.                                                 
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V.  96  8931 1999              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1YGH A   99   262  UNP    Q03330   GCN5_YEAST      99    262             
DBREF  1YGH B   99   262  UNP    Q03330   GCN5_YEAST      99    262             
SEQRES   1 A  164  LYS ILE GLU PHE ARG VAL VAL ASN ASN ASP ASN THR LYS          
SEQRES   2 A  164  GLU ASN MET MET VAL LEU THR GLY LEU LYS ASN ILE PHE          
SEQRES   3 A  164  GLN LYS GLN LEU PRO LYS MET PRO LYS GLU TYR ILE ALA          
SEQRES   4 A  164  ARG LEU VAL TYR ASP ARG SER HIS LEU SER MET ALA VAL          
SEQRES   5 A  164  ILE ARG LYS PRO LEU THR VAL VAL GLY GLY ILE THR TYR          
SEQRES   6 A  164  ARG PRO PHE ASP LYS ARG GLU PHE ALA GLU ILE VAL PHE          
SEQRES   7 A  164  CYS ALA ILE SER SER THR GLU GLN VAL ARG GLY TYR GLY          
SEQRES   8 A  164  ALA HIS LEU MET ASN HIS LEU LYS ASP TYR VAL ARG ASN          
SEQRES   9 A  164  THR SER ASN ILE LYS TYR PHE LEU THR TYR ALA ASP ASN          
SEQRES  10 A  164  TYR ALA ILE GLY TYR PHE LYS LYS GLN GLY PHE THR LYS          
SEQRES  11 A  164  GLU ILE THR LEU ASP LYS SER ILE TRP MET GLY TYR ILE          
SEQRES  12 A  164  LYS ASP TYR GLU GLY GLY THR LEU MET GLN CYS SER MET          
SEQRES  13 A  164  LEU PRO ARG ILE ARG TYR LEU ASP                              
SEQRES   1 B  164  LYS ILE GLU PHE ARG VAL VAL ASN ASN ASP ASN THR LYS          
SEQRES   2 B  164  GLU ASN MET MET VAL LEU THR GLY LEU LYS ASN ILE PHE          
SEQRES   3 B  164  GLN LYS GLN LEU PRO LYS MET PRO LYS GLU TYR ILE ALA          
SEQRES   4 B  164  ARG LEU VAL TYR ASP ARG SER HIS LEU SER MET ALA VAL          
SEQRES   5 B  164  ILE ARG LYS PRO LEU THR VAL VAL GLY GLY ILE THR TYR          
SEQRES   6 B  164  ARG PRO PHE ASP LYS ARG GLU PHE ALA GLU ILE VAL PHE          
SEQRES   7 B  164  CYS ALA ILE SER SER THR GLU GLN VAL ARG GLY TYR GLY          
SEQRES   8 B  164  ALA HIS LEU MET ASN HIS LEU LYS ASP TYR VAL ARG ASN          
SEQRES   9 B  164  THR SER ASN ILE LYS TYR PHE LEU THR TYR ALA ASP ASN          
SEQRES  10 B  164  TYR ALA ILE GLY TYR PHE LYS LYS GLN GLY PHE THR LYS          
SEQRES  11 B  164  GLU ILE THR LEU ASP LYS SER ILE TRP MET GLY TYR ILE          
SEQRES  12 B  164  LYS ASP TYR GLU GLY GLY THR LEU MET GLN CYS SER MET          
SEQRES  13 B  164  LEU PRO ARG ILE ARG TYR LEU ASP                              
HET    GOL    600       6                                                       
HET    GOL    601       6                                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   3  GOL    2(C3 H8 O3)                                                  
FORMUL   5  HOH   *216(H2 O)                                                    
CRYST1   40.040   66.510   80.190  90.00  97.71  90.00 P 1 21 1      4          
ATOM      1  N   LYS A  99     -30.284  46.047  38.860  1.00 32.63           N  
ATOM      2  CA  LYS A  99     -30.660  45.055  39.906  1.00 32.20           C  
ATOM      3  C   LYS A  99     -29.464  44.199  40.322  1.00 31.06           C  
ATOM      4  O   LYS A  99     -29.363  43.792  41.482  1.00 31.79           O  
ATOM      5  CB  LYS A  99     -31.795  44.154  39.402  1.00 33.76           C  
ATOM      6  CG  LYS A  99     -31.804  43.926  37.896  1.00 35.59           C  
ATOM      7  CD  LYS A  99     -31.503  42.471  37.543  1.00 37.08           C  
ATOM      8  CE  LYS A  99     -32.679  41.553  37.856  1.00 38.25           C  
ATOM      9  NZ  LYS A  99     -32.329  40.533  38.891  1.00 39.31           N  
ATOM     10  N   ILE A 100     -28.561  43.930  39.379  1.00 28.32           N  
ATOM     11  CA  ILE A 100     -27.369  43.127  39.658  1.00 25.75           C  
ATOM     12  C   ILE A 100     -26.124  44.009  39.749  1.00 24.26           C  
ATOM     13  O   ILE A 100     -25.800  44.740  38.813  1.00 23.93           O  
ATOM     14  CB  ILE A 100     -27.142  42.047  38.564  1.00 26.01           C  
ATOM     15  CG1 ILE A 100     -28.284  41.026  38.595  1.00 26.27           C  
ATOM     16  CG2 ILE A 100     -25.794  41.352  38.775  1.00 25.06           C  
ATOM     17  CD1 ILE A 100     -28.293  40.127  39.824  1.00 26.09           C  
ATOM     18  N   GLU A 101     -25.429  43.926  40.878  1.00 22.60           N  
ATOM     19  CA  GLU A 101     -24.226  44.714  41.119  1.00 20.89           C  
ATOM     20  C   GLU A 101     -22.996  43.819  41.255  1.00 19.98           C  
ATOM     21  O   GLU A 101     -23.091  42.690  41.729  1.00 18.65           O  
ATOM     22  CB  GLU A 101     -24.400  45.541  42.399  1.00 21.13           C  
ATOM     23  CG  GLU A 101     -23.130  46.212  42.917  1.00 22.60           C  
ATOM     24  CD  GLU A 101     -23.185  46.512  44.411  1.00 23.86           C  
ATOM     25  OE1 GLU A 101     -24.219  46.212  45.051  1.00 24.09           O  
ATOM     26  OE2 GLU A 101     -22.192  47.047  44.948  1.00 24.38           O  
ATOM     27  N   PHE A 102     -21.848  44.328  40.820  1.00 18.39           N  
ATOM     28  CA  PHE A 102     -20.584  43.604  40.918  1.00 17.82           C  
ATOM     29  C   PHE A 102     -19.748  44.414  41.894  1.00 17.96           C  
ATOM     30  O   PHE A 102     -19.258  45.493  41.559  1.00 18.88           O  
ATOM     31  CB  PHE A 102     -19.906  43.525  39.552  1.00 15.86           C  
ATOM     32  CG  PHE A 102     -20.695  42.751  38.540  1.00 14.86           C  
ATOM     33  CD1 PHE A 102     -21.710  43.365  37.817  1.00 15.01           C  
ATOM     34  CD2 PHE A 102     -20.442  41.397  38.328  1.00 13.77           C  
ATOM     35  CE1 PHE A 102     -22.470  42.641  36.894  1.00 16.00           C  
ATOM     36  CE2 PHE A 102     -21.190  40.666  37.415  1.00 13.25           C  
ATOM     37  CZ  PHE A 102     -22.208  41.286  36.693  1.00 14.93           C  
ATOM     38  N   ARG A 103     -19.601  43.891  43.105  1.00 16.82           N  
ATOM     39  CA  ARG A 103     -18.878  44.590  44.152  1.00 16.39           C  
ATOM     40  C   ARG A 103     -17.640  43.875  44.681  1.00 15.29           C  
ATOM     41  O   ARG A 103     -17.656  42.669  44.949  1.00 14.61           O  
ATOM     42  CB  ARG A 103     -19.841  44.872  45.316  1.00 17.45           C  
ATOM     43  CG  ARG A 103     -19.182  45.476  46.547  1.00 19.86           C  
ATOM     44  CD  ARG A 103     -20.078  45.382  47.784  1.00 21.90           C  
ATOM     45  NE  ARG A 103     -21.479  45.680  47.499  1.00 23.68           N  
ATOM     46  CZ  ARG A 103     -22.433  45.708  48.426  1.00 25.45           C  
ATOM     47  NH1 ARG A 103     -22.129  45.457  49.694  1.00 25.14           N  
ATOM     48  NH2 ARG A 103     -23.691  45.986  48.090  1.00 24.96           N  
ATOM     49  N   VAL A 104     -16.562  44.633  44.839  1.00 13.84           N  
ATOM     50  CA  VAL A 104     -15.330  44.076  45.369  1.00 13.54           C  
ATOM     51  C   VAL A 104     -15.310  44.323  46.875  1.00 14.15           C  
ATOM     52  O   VAL A 104     -15.520  45.445  47.334  1.00 14.29           O  
ATOM     53  CB  VAL A 104     -14.087  44.734  44.727  1.00 11.93           C  
ATOM     54  CG1 VAL A 104     -12.821  44.216  45.390  1.00 11.50           C  
ATOM     55  CG2 VAL A 104     -14.063  44.438  43.244  1.00 12.43           C  
ATOM     56  N   VAL A 105     -15.072  43.266  47.642  1.00 14.02           N  
ATOM     57  CA  VAL A 105     -15.024  43.367  49.094  1.00 14.95           C  
ATOM     58  C   VAL A 105     -13.850  42.551  49.595  1.00 16.28           C  
ATOM     59  O   VAL A 105     -13.237  41.805  48.838  1.00 15.17           O  
ATOM     60  CB  VAL A 105     -16.315  42.811  49.756  1.00 14.74           C  
ATOM     61  CG1 VAL A 105     -17.549  43.526  49.199  1.00 14.38           C  
ATOM     62  CG2 VAL A 105     -16.414  41.307  49.523  1.00 14.32           C  
ATOM     63  N   ASN A 106     -13.535  42.713  50.873  1.00 17.62           N  
ATOM     64  CA  ASN A 106     -12.457  41.972  51.514  1.00 18.62           C  
ATOM     65  C   ASN A 106     -12.737  42.094  52.997  1.00 18.93           C  
ATOM     66  O   ASN A 106     -13.570  42.907  53.400  1.00 18.70           O  
ATOM     67  CB  ASN A 106     -11.081  42.554  51.155  1.00 20.04           C  
ATOM     68  CG  ASN A 106     -10.722  43.781  51.975  1.00 21.45           C  
ATOM     69  OD1 ASN A 106     -11.437  44.783  51.961  1.00 22.94           O  
ATOM     70  ND2 ASN A 106      -9.601  43.709  52.691  1.00 22.43           N  
ATOM     71  N   ASN A 107     -12.066  41.280  53.802  1.00 18.28           N  
ATOM     72  CA  ASN A 107     -12.278  41.300  55.239  1.00 19.64           C  
ATOM     73  C   ASN A 107     -11.601  42.496  55.907  1.00 20.29           C  
ATOM     74  O   ASN A 107     -10.452  42.412  56.341  1.00 20.73           O  
ATOM     75  CB  ASN A 107     -11.777  39.990  55.854  1.00 19.41           C  
ATOM     76  CG  ASN A 107     -12.134  39.859  57.321  1.00 20.32           C  
ATOM     77  OD1 ASN A 107     -12.691  40.780  57.924  1.00 20.22           O  
ATOM     78  ND2 ASN A 107     -11.810  38.713  57.908  1.00 18.25           N  
ATOM     79  N   ASP A 108     -12.325  43.611  55.970  1.00 21.14           N  
ATOM     80  CA  ASP A 108     -11.826  44.831  56.597  1.00 23.25           C  
ATOM     81  C   ASP A 108     -12.601  45.064  57.897  1.00 24.72           C  
ATOM     82  O   ASP A 108     -12.799  46.199  58.335  1.00 24.17           O  
ATOM     83  CB  ASP A 108     -12.015  46.026  55.664  1.00 23.34           C  
ATOM     84  CG  ASP A 108     -13.468  46.346  55.427  1.00 23.57           C  
ATOM     85  OD1 ASP A 108     -14.315  45.450  55.626  1.00 24.18           O  
ATOM     86  OD2 ASP A 108     -13.769  47.490  55.041  1.00 25.00           O  
ATOM     87  N   ASN A 109     -13.059  43.972  58.493  1.00 26.08           N  
ATOM     88  CA  ASN A 109     -13.790  44.020  59.747  1.00 27.28           C  
ATOM     89  C   ASN A 109     -15.117  44.780  59.759  1.00 26.69           C  
ATOM     90  O   ASN A 109     -15.515  45.302  60.802  1.00 27.94           O  
ATOM     91  CB  ASN A 109     -12.887  44.577  60.846  1.00 28.71           C  
ATOM     92  CG  ASN A 109     -12.434  43.514  61.810  1.00 31.30           C  
ATOM     93  OD1 ASN A 109     -11.631  42.643  61.459  1.00 32.84           O  
ATOM     94  ND2 ASN A 109     -12.946  43.568  63.035  1.00 32.07           N  
ATOM     95  N   THR A 110     -15.798  44.868  58.621  1.00 24.98           N  
ATOM     96  CA  THR A 110     -17.099  45.530  58.611  1.00 23.45           C  
ATOM     97  C   THR A 110     -18.146  44.451  58.359  1.00 22.36           C  
ATOM     98  O   THR A 110     -17.907  43.512  57.597  1.00 20.44           O  
ATOM     99  CB  THR A 110     -17.205  46.645  57.540  1.00 23.38           C  
ATOM    100  OG1 THR A 110     -17.228  46.071  56.227  1.00 25.19           O  
ATOM    101  CG2 THR A 110     -16.035  47.613  57.671  1.00 23.03           C  
ATOM    102  N   LYS A 111     -19.290  44.579  59.026  1.00 20.79           N  
ATOM    103  CA  LYS A 111     -20.377  43.609  58.919  1.00 20.34           C  
ATOM    104  C   LYS A 111     -20.892  43.333  57.509  1.00 19.55           C  
ATOM    105  O   LYS A 111     -21.087  42.178  57.132  1.00 18.82           O  
ATOM    106  CB  LYS A 111     -21.546  44.044  59.807  1.00 21.03           C  
ATOM    107  CG  LYS A 111     -21.224  44.098  61.297  1.00 21.13           C  
ATOM    108  CD  LYS A 111     -22.486  44.376  62.107  1.00 21.96           C  
ATOM    109  CE  LYS A 111     -22.196  44.434  63.597  1.00 23.82           C  
ATOM    110  NZ  LYS A 111     -21.437  45.659  63.986  1.00 22.09           N  
ATOM    111  N   GLU A 112     -21.129  44.385  56.734  1.00 18.75           N  
ATOM    112  CA  GLU A 112     -21.630  44.221  55.376  1.00 19.25           C  
ATOM    113  C   GLU A 112     -20.670  43.394  54.515  1.00 17.95           C  
ATOM    114  O   GLU A 112     -21.096  42.516  53.763  1.00 16.76           O  
ATOM    115  CB  GLU A 112     -21.862  45.595  54.739  1.00 22.11           C  
ATOM    116  CG  GLU A 112     -22.234  45.541  53.264  1.00 27.07           C  
ATOM    117  CD  GLU A 112     -23.576  46.183  52.970  1.00 29.49           C  
ATOM    118  OE1 GLU A 112     -24.430  46.229  53.883  1.00 32.31           O  
ATOM    119  OE2 GLU A 112     -23.779  46.640  51.822  1.00 30.51           O  
ATOM    120  N   ASN A 113     -19.376  43.677  54.633  1.00 16.49           N  
ATOM    121  CA  ASN A 113     -18.356  42.955  53.876  1.00 15.69           C  
ATOM    122  C   ASN A 113     -18.305  41.485  54.303  1.00 15.42           C  
ATOM    123  O   ASN A 113     -18.167  40.587  53.473  1.00 13.92           O  
ATOM    124  CB  ASN A 113     -16.985  43.595  54.099  1.00 15.00           C  
ATOM    125  CG  ASN A 113     -16.675  44.677  53.091  1.00 15.38           C  
ATOM    126  OD1 ASN A 113     -17.541  45.101  52.324  1.00 17.09           O  
ATOM    127  ND2 ASN A 113     -15.432  45.130  53.084  1.00 16.41           N  
ATOM    128  N   MET A 114     -18.403  41.251  55.607  1.00 15.23           N  
ATOM    129  CA  MET A 114     -18.379  39.900  56.140  1.00 16.48           C  
ATOM    130  C   MET A 114     -19.601  39.116  55.654  1.00 16.15           C  
ATOM    131  O   MET A 114     -19.516  37.913  55.391  1.00 16.29           O  
ATOM    132  CB  MET A 114     -18.353  39.945  57.666  1.00 19.29           C  
ATOM    133  CG  MET A 114     -18.056  38.611  58.316  1.00 24.17           C  
ATOM    134  SD  MET A 114     -16.559  37.855  57.654  1.00 29.10           S  
ATOM    135  CE  MET A 114     -15.404  39.211  57.762  1.00 23.84           C  
ATOM    136  N   MET A 115     -20.734  39.804  55.540  1.00 14.81           N  
ATOM    137  CA  MET A 115     -21.967  39.187  55.066  1.00 15.52           C  
ATOM    138  C   MET A 115     -21.799  38.688  53.629  1.00 14.43           C  
ATOM    139  O   MET A 115     -22.242  37.592  53.284  1.00 14.49           O  
ATOM    140  CB  MET A 115     -23.118  40.196  55.109  1.00 16.44           C  
ATOM    141  CG  MET A 115     -23.732  40.393  56.478  1.00 19.75           C  
ATOM    142  SD  MET A 115     -25.033  41.627  56.423  1.00 24.27           S  
ATOM    143  CE  MET A 115     -26.411  40.663  55.794  1.00 22.28           C  
ATOM    144  N   VAL A 116     -21.174  39.510  52.788  1.00 12.90           N  
ATOM    145  CA  VAL A 116     -20.952  39.146  51.391  1.00 11.60           C  
ATOM    146  C   VAL A 116     -19.925  38.018  51.309  1.00 10.91           C  
ATOM    147  O   VAL A 116     -20.134  37.028  50.610  1.00 11.10           O  
ATOM    148  CB  VAL A 116     -20.440  40.350  50.569  1.00 11.93           C  
ATOM    149  CG1 VAL A 116     -20.204  39.930  49.112  1.00  9.44           C  
ATOM    150  CG2 VAL A 116     -21.445  41.495  50.646  1.00 10.69           C  
ATOM    151  N   LEU A 117     -18.821  38.173  52.031  1.00 10.35           N  
ATOM    152  CA  LEU A 117     -17.771  37.162  52.039  1.00 10.98           C  
ATOM    153  C   LEU A 117     -18.330  35.803  52.463  1.00 11.64           C  
ATOM    154  O   LEU A 117     -17.986  34.771  51.885  1.00 11.10           O  
ATOM    155  CB  LEU A 117     -16.650  37.578  52.992  1.00 10.03           C  
ATOM    156  CG  LEU A 117     -15.776  38.753  52.538  1.00  9.69           C  
ATOM    157  CD1 LEU A 117     -14.730  39.035  53.597  1.00  9.23           C  
ATOM    158  CD2 LEU A 117     -15.118  38.426  51.197  1.00  8.95           C  
ATOM    159  N   THR A 118     -19.195  35.815  53.472  1.00 11.78           N  
ATOM    160  CA  THR A 118     -19.794  34.587  53.977  1.00 11.79           C  
ATOM    161  C   THR A 118     -20.739  33.943  52.964  1.00 10.74           C  
ATOM    162  O   THR A 118     -20.702  32.723  52.774  1.00 11.62           O  
ATOM    163  CB  THR A 118     -20.533  34.847  55.309  1.00 11.55           C  
ATOM    164  OG1 THR A 118     -19.570  35.186  56.309  1.00 10.99           O  
ATOM    165  CG2 THR A 118     -21.292  33.604  55.764  1.00 12.71           C  
ATOM    166  N   GLY A 119     -21.576  34.747  52.314  1.00  9.33           N  
ATOM    167  CA  GLY A 119     -22.486  34.201  51.322  1.00  9.78           C  
ATOM    168  C   GLY A 119     -21.692  33.579  50.181  1.00 11.39           C  
ATOM    169  O   GLY A 119     -22.065  32.543  49.627  1.00 11.41           O  
ATOM    170  N   LEU A 120     -20.579  34.219  49.830  1.00 10.56           N  
ATOM    171  CA  LEU A 120     -19.718  33.730  48.760  1.00 10.83           C  
ATOM    172  C   LEU A 120     -19.039  32.423  49.173  1.00  9.62           C  
ATOM    173  O   LEU A 120     -19.027  31.448  48.419  1.00 10.89           O  
ATOM    174  CB  LEU A 120     -18.663  34.786  48.421  1.00 10.93           C  
ATOM    175  CG  LEU A 120     -17.969  34.585  47.077  1.00 12.46           C  
ATOM    176  CD1 LEU A 120     -19.020  34.430  45.962  1.00 10.35           C  
ATOM    177  CD2 LEU A 120     -17.046  35.770  46.809  1.00 12.08           C  
ATOM    178  N   LYS A 121     -18.482  32.411  50.377  1.00  9.16           N  
ATOM    179  CA  LYS A 121     -17.803  31.237  50.907  1.00 10.06           C  
ATOM    180  C   LYS A 121     -18.718  30.016  50.865  1.00 11.00           C  
ATOM    181  O   LYS A 121     -18.282  28.909  50.534  1.00  9.84           O  
ATOM    182  CB  LYS A 121     -17.359  31.494  52.351  1.00 10.60           C  
ATOM    183  CG  LYS A 121     -17.035  30.238  53.143  1.00 11.35           C  
ATOM    184  CD  LYS A 121     -16.824  30.545  54.619  1.00 12.33           C  
ATOM    185  CE  LYS A 121     -18.149  30.726  55.360  1.00 13.87           C  
ATOM    186  NZ  LYS A 121     -18.820  29.433  55.643  1.00 15.55           N  
ATOM    187  N   ASN A 122     -19.987  30.223  51.204  1.00  9.82           N  
ATOM    188  CA  ASN A 122     -20.954  29.135  51.208  1.00 10.08           C  
ATOM    189  C   ASN A 122     -21.147  28.555  49.799  1.00 10.53           C  
ATOM    190  O   ASN A 122     -21.316  27.343  49.637  1.00 10.44           O  
ATOM    191  CB  ASN A 122     -22.288  29.624  51.790  1.00  9.49           C  
ATOM    192  CG  ASN A 122     -22.215  29.861  53.293  1.00  9.97           C  
ATOM    193  OD1 ASN A 122     -21.360  29.302  53.984  1.00  9.79           O  
ATOM    194  ND2 ASN A 122     -23.115  30.696  53.806  1.00 11.73           N  
ATOM    195  N   ILE A 123     -21.111  29.411  48.779  1.00 10.25           N  
ATOM    196  CA  ILE A 123     -21.260  28.926  47.410  1.00 10.72           C  
ATOM    197  C   ILE A 123     -20.043  28.063  47.060  1.00 10.47           C  
ATOM    198  O   ILE A 123     -20.192  26.940  46.578  1.00  9.15           O  
ATOM    199  CB  ILE A 123     -21.370  30.085  46.393  1.00 10.45           C  
ATOM    200  CG1 ILE A 123     -22.629  30.914  46.686  1.00  9.97           C  
ATOM    201  CG2 ILE A 123     -21.403  29.524  44.971  1.00  9.09           C  
ATOM    202  CD1 ILE A 123     -22.896  32.015  45.699  1.00  8.59           C  
ATOM    203  N   PHE A 124     -18.846  28.583  47.333  1.00 10.03           N  
ATOM    204  CA  PHE A 124     -17.606  27.853  47.045  1.00 10.17           C  
ATOM    205  C   PHE A 124     -17.556  26.516  47.785  1.00  9.83           C  
ATOM    206  O   PHE A 124     -17.154  25.498  47.218  1.00  9.80           O  
ATOM    207  CB  PHE A 124     -16.376  28.668  47.460  1.00  8.30           C  
ATOM    208  CG  PHE A 124     -16.228  29.977  46.741  1.00  8.39           C  
ATOM    209  CD1 PHE A 124     -16.732  30.154  45.459  1.00  7.52           C  
ATOM    210  CD2 PHE A 124     -15.540  31.026  47.345  1.00  8.92           C  
ATOM    211  CE1 PHE A 124     -16.547  31.366  44.782  1.00  8.54           C  
ATOM    212  CE2 PHE A 124     -15.349  32.239  46.679  1.00  8.78           C  
ATOM    213  CZ  PHE A 124     -15.852  32.408  45.397  1.00  7.18           C  
ATOM    214  N   GLN A 125     -17.947  26.524  49.056  1.00  8.95           N  
ATOM    215  CA  GLN A 125     -17.926  25.304  49.855  1.00  9.80           C  
ATOM    216  C   GLN A 125     -18.883  24.253  49.302  1.00  9.85           C  
ATOM    217  O   GLN A 125     -18.592  23.055  49.328  1.00 10.13           O  
ATOM    218  CB  GLN A 125     -18.273  25.619  51.313  1.00 10.06           C  
ATOM    219  CG  GLN A 125     -17.123  26.250  52.084  1.00 11.07           C  
ATOM    220  CD  GLN A 125     -17.530  26.694  53.480  1.00 11.55           C  
ATOM    221  OE1 GLN A 125     -18.709  26.910  53.747  1.00 12.27           O  
ATOM    222  NE2 GLN A 125     -16.550  26.831  54.374  1.00  8.86           N  
ATOM    223  N   LYS A 126     -20.020  24.702  48.794  1.00  9.85           N  
ATOM    224  CA  LYS A 126     -20.997  23.783  48.234  1.00 11.41           C  
ATOM    225  C   LYS A 126     -20.537  23.242  46.871  1.00 12.86           C  
ATOM    226  O   LYS A 126     -20.790  22.080  46.537  1.00 12.91           O  
ATOM    227  CB  LYS A 126     -22.346  24.492  48.084  1.00 12.21           C  
ATOM    228  CG  LYS A 126     -23.380  23.710  47.295  1.00 14.70           C  
ATOM    229  CD  LYS A 126     -24.745  24.372  47.357  1.00 15.24           C  
ATOM    230  CE  LYS A 126     -25.842  23.401  46.941  1.00 17.96           C  
ATOM    231  NZ  LYS A 126     -27.203  24.010  47.076  1.00 19.24           N  
ATOM    232  N   GLN A 127     -19.850  24.083  46.100  1.00 11.33           N  
ATOM    233  CA  GLN A 127     -19.388  23.713  44.764  1.00 10.44           C  
ATOM    234  C   GLN A 127     -18.063  22.964  44.721  1.00 10.87           C  
ATOM    235  O   GLN A 127     -17.751  22.301  43.724  1.00 10.70           O  
ATOM    236  CB  GLN A 127     -19.296  24.964  43.885  1.00  9.79           C  
ATOM    237  CG  GLN A 127     -20.646  25.597  43.593  1.00  8.83           C  
ATOM    238  CD  GLN A 127     -20.720  26.218  42.214  1.00  9.29           C  
ATOM    239  OE1 GLN A 127     -19.834  26.021  41.383  1.00 10.71           O  
ATOM    240  NE2 GLN A 127     -21.783  26.974  41.963  1.00 10.54           N  
ATOM    241  N   LEU A 128     -17.286  23.073  45.793  1.00 11.00           N  
ATOM    242  CA  LEU A 128     -15.988  22.395  45.892  1.00 12.10           C  
ATOM    243  C   LEU A 128     -15.969  21.579  47.188  1.00 11.75           C  
ATOM    244  O   LEU A 128     -15.099  21.758  48.038  1.00 12.27           O  
ATOM    245  CB  LEU A 128     -14.864  23.440  45.889  1.00 10.79           C  
ATOM    246  CG  LEU A 128     -14.825  24.344  44.650  1.00 10.72           C  
ATOM    247  CD1 LEU A 128     -13.886  25.538  44.881  1.00  9.59           C  
ATOM    248  CD2 LEU A 128     -14.356  23.522  43.452  1.00  9.77           C  
ATOM    249  N   PRO A 129     -16.922  20.639  47.331  1.00 13.31           N  
ATOM    250  CA  PRO A 129     -17.051  19.788  48.518  1.00 14.56           C  
ATOM    251  C   PRO A 129     -15.831  18.948  48.891  1.00 16.56           C  
ATOM    252  O   PRO A 129     -15.605  18.677  50.070  1.00 16.85           O  
ATOM    253  CB  PRO A 129     -18.273  18.920  48.206  1.00 15.13           C  
ATOM    254  CG  PRO A 129     -18.368  18.913  46.715  1.00 14.19           C  
ATOM    255  CD  PRO A 129     -17.918  20.283  46.300  1.00 13.52           C  
ATOM    256  N   LYS A 130     -15.052  18.543  47.890  1.00 17.30           N  
ATOM    257  CA  LYS A 130     -13.863  17.729  48.127  1.00 18.96           C  
ATOM    258  C   LYS A 130     -12.696  18.536  48.690  1.00 19.06           C  
ATOM    259  O   LYS A 130     -11.668  17.969  49.060  1.00 19.07           O  
ATOM    260  CB  LYS A 130     -13.432  17.028  46.835  1.00 20.06           C  
ATOM    261  CG  LYS A 130     -14.288  15.819  46.474  1.00 21.58           C  
ATOM    262  CD  LYS A 130     -14.283  15.568  44.974  1.00 23.12           C  
ATOM    263  CE  LYS A 130     -14.639  14.125  44.639  1.00 24.40           C  
ATOM    264  NZ  LYS A 130     -14.399  13.799  43.193  1.00 26.72           N  
ATOM    265  N   MET A 131     -12.849  19.856  48.749  1.00 17.91           N  
ATOM    266  CA  MET A 131     -11.802  20.712  49.305  1.00 17.64           C  
ATOM    267  C   MET A 131     -12.104  20.902  50.783  1.00 16.27           C  
ATOM    268  O   MET A 131     -13.263  20.886  51.184  1.00 16.86           O  
ATOM    269  CB  MET A 131     -11.802  22.084  48.630  1.00 18.20           C  
ATOM    270  CG  MET A 131     -11.099  22.122  47.294  1.00 20.47           C  
ATOM    271  SD  MET A 131     -10.947  23.813  46.699  1.00 22.49           S  
ATOM    272  CE  MET A 131      -9.646  24.405  47.752  1.00 21.61           C  
ATOM    273  N   PRO A 132     -11.068  21.078  51.617  1.00 15.55           N  
ATOM    274  CA  PRO A 132     -11.352  21.271  53.045  1.00 15.24           C  
ATOM    275  C   PRO A 132     -12.155  22.567  53.203  1.00 15.44           C  
ATOM    276  O   PRO A 132     -11.690  23.631  52.804  1.00 15.33           O  
ATOM    277  CB  PRO A 132      -9.965  21.369  53.683  1.00 14.30           C  
ATOM    278  CG  PRO A 132      -9.013  20.815  52.654  1.00 13.21           C  
ATOM    279  CD  PRO A 132      -9.625  21.117  51.326  1.00 14.29           C  
ATOM    280  N   LYS A 133     -13.354  22.491  53.773  1.00 16.80           N  
ATOM    281  CA  LYS A 133     -14.174  23.690  53.917  1.00 18.33           C  
ATOM    282  C   LYS A 133     -13.534  24.794  54.762  1.00 17.13           C  
ATOM    283  O   LYS A 133     -13.738  25.977  54.487  1.00 16.27           O  
ATOM    284  CB  LYS A 133     -15.570  23.337  54.458  1.00 21.26           C  
ATOM    285  CG  LYS A 133     -15.596  22.755  55.855  1.00 27.70           C  
ATOM    286  CD  LYS A 133     -17.021  22.377  56.267  1.00 31.90           C  
ATOM    287  CE  LYS A 133     -17.594  23.366  57.285  1.00 35.02           C  
ATOM    288  NZ  LYS A 133     -18.659  24.249  56.707  1.00 37.98           N  
ATOM    289  N   GLU A 134     -12.751  24.426  55.771  1.00 16.96           N  
ATOM    290  CA  GLU A 134     -12.102  25.428  56.616  1.00 17.99           C  
ATOM    291  C   GLU A 134     -10.999  26.147  55.851  1.00 16.62           C  
ATOM    292  O   GLU A 134     -10.687  27.300  56.135  1.00 15.92           O  
ATOM    293  CB  GLU A 134     -11.524  24.779  57.874  1.00 21.97           C  
ATOM    294  CG  GLU A 134     -12.559  24.052  58.725  1.00 28.73           C  
ATOM    295  CD  GLU A 134     -13.762  24.924  59.080  1.00 33.99           C  
ATOM    296  OE1 GLU A 134     -13.572  26.136  59.347  1.00 36.09           O  
ATOM    297  OE2 GLU A 134     -14.900  24.396  59.094  1.00 35.72           O  
ATOM    298  N   TYR A 135     -10.410  25.459  54.880  1.00 15.75           N  
ATOM    299  CA  TYR A 135      -9.359  26.049  54.059  1.00 14.89           C  
ATOM    300  C   TYR A 135     -10.000  27.127  53.177  1.00 13.60           C  
ATOM    301  O   TYR A 135      -9.481  28.238  53.060  1.00 13.57           O  
ATOM    302  CB  TYR A 135      -8.703  24.970  53.197  1.00 15.78           C  
ATOM    303  CG  TYR A 135      -7.709  25.501  52.191  1.00 17.29           C  
ATOM    304  CD1 TYR A 135      -6.498  26.061  52.603  1.00 19.31           C  
ATOM    305  CD2 TYR A 135      -7.976  25.437  50.823  1.00 17.83           C  
ATOM    306  CE1 TYR A 135      -5.574  26.545  51.669  1.00 21.11           C  
ATOM    307  CE2 TYR A 135      -7.066  25.917  49.884  1.00 20.03           C  
ATOM    308  CZ  TYR A 135      -5.868  26.470  50.311  1.00 21.01           C  
ATOM    309  OH  TYR A 135      -4.976  26.957  49.382  1.00 24.19           O  
ATOM    310  N   ILE A 136     -11.132  26.792  52.562  1.00 11.93           N  
ATOM    311  CA  ILE A 136     -11.856  27.737  51.720  1.00 12.46           C  
ATOM    312  C   ILE A 136     -12.217  28.984  52.540  1.00 12.81           C  
ATOM    313  O   ILE A 136     -11.994  30.111  52.104  1.00 12.48           O  
ATOM    314  CB  ILE A 136     -13.159  27.101  51.160  1.00 11.70           C  
ATOM    315  CG1 ILE A 136     -12.808  25.976  50.189  1.00 10.77           C  
ATOM    316  CG2 ILE A 136     -14.021  28.163  50.460  1.00 11.61           C  
ATOM    317  CD1 ILE A 136     -14.021  25.280  49.613  1.00 10.05           C  
ATOM    318  N   ALA A 137     -12.771  28.772  53.731  1.00 12.87           N  
ATOM    319  CA  ALA A 137     -13.151  29.873  54.615  1.00 12.98           C  
ATOM    320  C   ALA A 137     -11.963  30.792  54.938  1.00 13.20           C  
ATOM    321  O   ALA A 137     -12.066  32.012  54.825  1.00 12.64           O  
ATOM    322  CB  ALA A 137     -13.739  29.315  55.909  1.00 12.88           C  
ATOM    323  N   ARG A 138     -10.842  30.199  55.342  1.00 13.90           N  
ATOM    324  CA  ARG A 138      -9.642  30.958  55.685  1.00 15.05           C  
ATOM    325  C   ARG A 138      -9.187  31.885  54.558  1.00 14.22           C  
ATOM    326  O   ARG A 138      -8.868  33.048  54.799  1.00 13.78           O  
ATOM    327  CB  ARG A 138      -8.509  29.995  56.056  1.00 17.04           C  
ATOM    328  CG  ARG A 138      -7.108  30.611  56.042  1.00 21.62           C  
ATOM    329  CD  ARG A 138      -6.079  29.659  56.662  1.00 23.93           C  
ATOM    330  NE  ARG A 138      -6.732  28.734  57.584  1.00 26.87           N  
ATOM    331  CZ  ARG A 138      -6.773  27.412  57.432  1.00 27.60           C  
ATOM    332  NH1 ARG A 138      -6.194  26.829  56.389  1.00 28.51           N  
ATOM    333  NH2 ARG A 138      -7.423  26.674  58.319  1.00 29.03           N  
ATOM    334  N   LEU A 139      -9.165  31.372  53.330  1.00 14.08           N  
ATOM    335  CA  LEU A 139      -8.739  32.170  52.179  1.00 13.36           C  
ATOM    336  C   LEU A 139      -9.698  33.324  51.882  1.00 12.32           C  
ATOM    337  O   LEU A 139      -9.267  34.459  51.680  1.00 11.87           O  
ATOM    338  CB  LEU A 139      -8.599  31.282  50.936  1.00 13.31           C  
ATOM    339  CG  LEU A 139      -7.517  30.195  50.971  1.00 13.51           C  
ATOM    340  CD1 LEU A 139      -7.255  29.682  49.563  1.00 13.93           C  
ATOM    341  CD2 LEU A 139      -6.248  30.741  51.568  1.00 14.58           C  
ATOM    342  N   VAL A 140     -10.994  33.032  51.853  1.00 11.47           N  
ATOM    343  CA  VAL A 140     -12.005  34.054  51.583  1.00 11.80           C  
ATOM    344  C   VAL A 140     -11.981  35.172  52.639  1.00 11.80           C  
ATOM    345  O   VAL A 140     -12.131  36.348  52.313  1.00 12.40           O  
ATOM    346  CB  VAL A 140     -13.427  33.425  51.535  1.00 10.91           C  
ATOM    347  CG1 VAL A 140     -14.488  34.515  51.421  1.00 10.53           C  
ATOM    348  CG2 VAL A 140     -13.528  32.466  50.352  1.00 10.89           C  
ATOM    349  N   TYR A 141     -11.775  34.801  53.899  1.00 12.69           N  
ATOM    350  CA  TYR A 141     -11.749  35.774  54.991  1.00 14.50           C  
ATOM    351  C   TYR A 141     -10.387  36.453  55.193  1.00 15.39           C  
ATOM    352  O   TYR A 141     -10.263  37.377  56.000  1.00 14.53           O  
ATOM    353  CB  TYR A 141     -12.178  35.097  56.300  1.00 13.30           C  
ATOM    354  CG  TYR A 141     -13.619  34.638  56.332  1.00 13.05           C  
ATOM    355  CD1 TYR A 141     -14.646  35.438  55.826  1.00 13.97           C  
ATOM    356  CD2 TYR A 141     -13.965  33.417  56.912  1.00 13.95           C  
ATOM    357  CE1 TYR A 141     -15.989  35.031  55.907  1.00 13.78           C  
ATOM    358  CE2 TYR A 141     -15.297  33.005  56.999  1.00 13.51           C  
ATOM    359  CZ  TYR A 141     -16.304  33.814  56.499  1.00 13.70           C  
ATOM    360  OH  TYR A 141     -17.621  33.410  56.609  1.00 13.01           O  
ATOM    361  N   ASP A 142      -9.367  35.988  54.475  1.00 16.40           N  
ATOM    362  CA  ASP A 142      -8.033  36.572  54.587  1.00 18.26           C  
ATOM    363  C   ASP A 142      -8.071  37.981  53.992  1.00 18.84           C  
ATOM    364  O   ASP A 142      -8.571  38.178  52.889  1.00 18.32           O  
ATOM    365  CB  ASP A 142      -7.013  35.702  53.843  1.00 18.66           C  
ATOM    366  CG  ASP A 142      -5.631  36.324  53.814  1.00 19.21           C  
ATOM    367  OD1 ASP A 142      -4.989  36.412  54.880  1.00 19.42           O  
ATOM    368  OD2 ASP A 142      -5.190  36.732  52.723  1.00 20.12           O  
ATOM    369  N   ARG A 143      -7.545  38.963  54.715  1.00 20.76           N  
ATOM    370  CA  ARG A 143      -7.582  40.336  54.215  1.00 22.84           C  
ATOM    371  C   ARG A 143      -6.795  40.577  52.928  1.00 21.78           C  
ATOM    372  O   ARG A 143      -7.143  41.469  52.154  1.00 21.48           O  
ATOM    373  CB  ARG A 143      -7.111  41.318  55.292  1.00 25.80           C  
ATOM    374  CG  ARG A 143      -7.638  42.734  55.079  1.00 30.71           C  
ATOM    375  CD  ARG A 143      -7.542  43.564  56.349  1.00 34.98           C  
ATOM    376  NE  ARG A 143      -6.328  43.248  57.096  1.00 40.41           N  
ATOM    377  CZ  ARG A 143      -5.153  43.852  56.917  1.00 42.68           C  
ATOM    378  NH1 ARG A 143      -5.025  44.815  56.009  1.00 43.95           N  
ATOM    379  NH2 ARG A 143      -4.102  43.487  57.644  1.00 44.12           N  
ATOM    380  N   SER A 144      -5.744  39.790  52.698  1.00 20.56           N  
ATOM    381  CA  SER A 144      -4.927  39.937  51.493  1.00 19.93           C  
ATOM    382  C   SER A 144      -5.671  39.452  50.259  1.00 18.38           C  
ATOM    383  O   SER A 144      -5.255  39.724  49.130  1.00 17.57           O  
ATOM    384  CB  SER A 144      -3.627  39.147  51.625  1.00 20.44           C  
ATOM    385  OG  SER A 144      -2.697  39.839  52.435  1.00 24.41           O  
ATOM    386  N   HIS A 145      -6.759  38.719  50.480  1.00 16.39           N  
ATOM    387  CA  HIS A 145      -7.570  38.196  49.390  1.00 15.27           C  
ATOM    388  C   HIS A 145      -8.775  39.096  49.164  1.00 15.52           C  
ATOM    389  O   HIS A 145      -9.454  39.482  50.111  1.00 16.41           O  
ATOM    390  CB  HIS A 145      -8.052  36.780  49.715  1.00 14.97           C  
ATOM    391  CG  HIS A 145      -6.982  35.738  49.607  1.00 14.28           C  
ATOM    392  ND1 HIS A 145      -5.952  35.629  50.518  1.00 13.92           N  
ATOM    393  CD2 HIS A 145      -6.772  34.769  48.684  1.00 13.25           C  
ATOM    394  CE1 HIS A 145      -5.154  34.637  50.162  1.00 13.46           C  
ATOM    395  NE2 HIS A 145      -5.629  34.100  49.053  1.00 14.32           N  
ATOM    396  N   LEU A 146      -9.031  39.439  47.906  1.00 13.68           N  
ATOM    397  CA  LEU A 146     -10.168  40.281  47.565  1.00 13.88           C  
ATOM    398  C   LEU A 146     -11.216  39.420  46.870  1.00 14.07           C  
ATOM    399  O   LEU A 146     -10.888  38.394  46.269  1.00 12.86           O  
ATOM    400  CB  LEU A 146      -9.733  41.411  46.633  1.00 15.76           C  
ATOM    401  CG  LEU A 146      -8.608  42.324  47.131  1.00 16.49           C  
ATOM    402  CD1 LEU A 146      -8.308  43.381  46.070  1.00 16.33           C  
ATOM    403  CD2 LEU A 146      -9.016  42.979  48.439  1.00 17.47           C  
ATOM    404  N   SER A 147     -12.475  39.836  46.941  1.00 12.70           N  
ATOM    405  CA  SER A 147     -13.551  39.081  46.313  1.00 12.21           C  
ATOM    406  C   SER A 147     -14.514  39.966  45.536  1.00 12.28           C  
ATOM    407  O   SER A 147     -15.010  40.963  46.059  1.00 12.31           O  
ATOM    408  CB  SER A 147     -14.362  38.311  47.368  1.00 12.64           C  
ATOM    409  OG  SER A 147     -13.654  37.197  47.881  1.00 13.80           O  
ATOM    410  N   MET A 148     -14.757  39.615  44.278  1.00 11.44           N  
ATOM    411  CA  MET A 148     -15.730  40.348  43.490  1.00 10.91           C  
ATOM    412  C   MET A 148     -16.976  39.479  43.581  1.00 11.80           C  
ATOM    413  O   MET A 148     -16.967  38.323  43.157  1.00 11.61           O  
ATOM    414  CB  MET A 148     -15.333  40.477  42.023  1.00 10.12           C  
ATOM    415  CG  MET A 148     -16.519  40.935  41.176  1.00 11.21           C  
ATOM    416  SD  MET A 148     -16.188  41.800  39.652  1.00 15.14           S  
ATOM    417  CE  MET A 148     -15.225  43.241  40.221  1.00 13.06           C  
ATOM    418  N   ALA A 149     -18.041  40.027  44.145  1.00 11.02           N  
ATOM    419  CA  ALA A 149     -19.272  39.275  44.287  1.00 11.54           C  
ATOM    420  C   ALA A 149     -20.352  39.821  43.368  1.00 11.32           C  
ATOM    421  O   ALA A 149     -20.413  41.029  43.115  1.00 10.80           O  
ATOM    422  CB  ALA A 149     -19.752  39.326  45.752  1.00 11.85           C  
ATOM    423  N   VAL A 150     -21.185  38.921  42.852  1.00 12.07           N  
ATOM    424  CA  VAL A 150     -22.310  39.311  42.009  1.00 12.76           C  
ATOM    425  C   VAL A 150     -23.434  39.396  43.033  1.00 14.34           C  
ATOM    426  O   VAL A 150     -23.744  38.413  43.705  1.00 13.20           O  
ATOM    427  CB  VAL A 150     -22.656  38.239  40.946  1.00 13.22           C  
ATOM    428  CG1 VAL A 150     -23.813  38.723  40.077  1.00 11.81           C  
ATOM    429  CG2 VAL A 150     -21.434  37.945  40.077  1.00 12.05           C  
ATOM    430  N   ILE A 151     -24.015  40.582  43.174  1.00 15.59           N  
ATOM    431  CA  ILE A 151     -25.070  40.801  44.156  1.00 17.15           C  
ATOM    432  C   ILE A 151     -26.391  41.259  43.551  1.00 19.07           C  
ATOM    433  O   ILE A 151     -26.428  42.107  42.653  1.00 18.76           O  
ATOM    434  CB  ILE A 151     -24.644  41.863  45.199  1.00 16.60           C  
ATOM    435  CG1 ILE A 151     -23.366  41.424  45.903  1.00 16.08           C  
ATOM    436  CG2 ILE A 151     -25.752  42.074  46.219  1.00 16.86           C  
ATOM    437  CD1 ILE A 151     -22.695  42.541  46.663  1.00 16.61           C  
ATOM    438  N   ARG A 152     -27.474  40.681  44.056  1.00 21.09           N  
ATOM    439  CA  ARG A 152     -28.821  41.032  43.629  1.00 23.69           C  
ATOM    440  C   ARG A 152     -29.404  41.742  44.852  1.00 24.05           C  
ATOM    441  O   ARG A 152     -29.367  41.202  45.953  1.00 22.17           O  
ATOM    442  CB  ARG A 152     -29.608  39.760  43.290  1.00 24.99           C  
ATOM    443  CG  ARG A 152     -31.090  39.819  43.602  1.00 28.05           C  
ATOM    444  CD  ARG A 152     -31.947  39.614  42.355  1.00 29.05           C  
ATOM    445  NE  ARG A 152     -31.357  38.678  41.398  1.00 30.70           N  
ATOM    446  CZ  ARG A 152     -31.125  37.390  41.644  1.00 31.01           C  
ATOM    447  NH1 ARG A 152     -31.430  36.862  42.825  1.00 31.66           N  
ATOM    448  NH2 ARG A 152     -30.593  36.626  40.699  1.00 32.20           N  
ATOM    449  N   LYS A 153     -29.900  42.962  44.665  1.00 26.92           N  
ATOM    450  CA  LYS A 153     -30.458  43.733  45.774  1.00 29.74           C  
ATOM    451  C   LYS A 153     -31.461  42.913  46.569  1.00 30.62           C  
ATOM    452  O   LYS A 153     -32.213  42.123  46.003  1.00 31.86           O  
ATOM    453  CB  LYS A 153     -31.131  45.005  45.257  1.00 31.81           C  
ATOM    454  CG  LYS A 153     -30.343  46.273  45.546  1.00 35.54           C  
ATOM    455  CD  LYS A 153     -31.249  47.394  46.046  1.00 38.59           C  
ATOM    456  CE  LYS A 153     -30.802  48.752  45.509  1.00 40.48           C  
ATOM    457  NZ  LYS A 153     -31.785  49.342  44.544  1.00 41.65           N  
ATOM    458  N   PRO A 154     -31.486  43.086  47.897  1.00 31.29           N  
ATOM    459  CA  PRO A 154     -30.635  43.999  48.669  1.00 31.16           C  
ATOM    460  C   PRO A 154     -29.178  43.536  48.784  1.00 30.78           C  
ATOM    461  O   PRO A 154     -28.256  44.247  48.367  1.00 31.05           O  
ATOM    462  CB  PRO A 154     -31.324  44.061  50.027  1.00 31.38           C  
ATOM    463  CG  PRO A 154     -32.008  42.733  50.150  1.00 31.41           C  
ATOM    464  CD  PRO A 154     -32.417  42.336  48.761  1.00 31.14           C  
ATOM    465  N   LEU A 155     -28.976  42.351  49.357  1.00 29.05           N  
ATOM    466  CA  LEU A 155     -27.633  41.800  49.517  1.00 27.53           C  
ATOM    467  C   LEU A 155     -27.627  40.283  49.311  1.00 26.29           C  
ATOM    468  O   LEU A 155     -27.188  39.526  50.176  1.00 26.69           O  
ATOM    469  CB  LEU A 155     -27.082  42.143  50.909  1.00 27.62           C  
ATOM    470  CG  LEU A 155     -25.564  42.274  51.081  1.00 27.85           C  
ATOM    471  CD1 LEU A 155     -25.250  43.159  52.276  1.00 28.04           C  
ATOM    472  CD2 LEU A 155     -24.954  40.902  51.290  1.00 27.95           C  
ATOM    473  N   THR A 156     -28.123  39.842  48.162  1.00 24.10           N  
ATOM    474  CA  THR A 156     -28.157  38.419  47.850  1.00 22.27           C  
ATOM    475  C   THR A 156     -26.980  38.069  46.938  1.00 19.55           C  
ATOM    476  O   THR A 156     -26.922  38.509  45.790  1.00 17.89           O  
ATOM    477  CB  THR A 156     -29.469  38.037  47.143  1.00 23.60           C  
ATOM    478  OG1 THR A 156     -30.578  38.379  47.979  1.00 25.11           O  
ATOM    479  CG2 THR A 156     -29.502  36.538  46.850  1.00 23.56           C  
ATOM    480  N   VAL A 157     -26.047  37.280  47.463  1.00 17.01           N  
ATOM    481  CA  VAL A 157     -24.874  36.867  46.707  1.00 15.41           C  
ATOM    482  C   VAL A 157     -25.233  35.726  45.753  1.00 15.26           C  
ATOM    483  O   VAL A 157     -25.600  34.634  46.188  1.00 14.77           O  
ATOM    484  CB  VAL A 157     -23.759  36.395  47.650  1.00 15.11           C  
ATOM    485  CG1 VAL A 157     -22.516  36.044  46.847  1.00 15.10           C  
ATOM    486  CG2 VAL A 157     -23.455  37.474  48.678  1.00 15.65           C  
ATOM    487  N   VAL A 158     -25.130  35.979  44.452  1.00 14.96           N  
ATOM    488  CA  VAL A 158     -25.449  34.958  43.462  1.00 15.40           C  
ATOM    489  C   VAL A 158     -24.210  34.300  42.840  1.00 14.60           C  
ATOM    490  O   VAL A 158     -24.328  33.379  42.043  1.00 15.08           O  
ATOM    491  CB  VAL A 158     -26.359  35.527  42.336  1.00 16.80           C  
ATOM    492  CG1 VAL A 158     -27.310  36.569  42.910  1.00 18.36           C  
ATOM    493  CG2 VAL A 158     -25.529  36.122  41.224  1.00 17.25           C  
ATOM    494  N   GLY A 159     -23.027  34.766  43.220  1.00 13.58           N  
ATOM    495  CA  GLY A 159     -21.804  34.196  42.684  1.00 12.37           C  
ATOM    496  C   GLY A 159     -20.643  35.141  42.906  1.00 12.34           C  
ATOM    497  O   GLY A 159     -20.832  36.245  43.436  1.00 11.16           O  
ATOM    498  N   GLY A 160     -19.442  34.724  42.506  1.00 11.34           N  
ATOM    499  CA  GLY A 160     -18.287  35.581  42.682  1.00 10.91           C  
ATOM    500  C   GLY A 160     -16.939  34.924  42.458  1.00 11.68           C  
ATOM    501  O   GLY A 160     -16.840  33.731  42.146  1.00 10.23           O  
ATOM    502  N   ILE A 161     -15.893  35.728  42.616  1.00 10.11           N  
ATOM    503  CA  ILE A 161     -14.519  35.273  42.452  1.00 10.30           C  
ATOM    504  C   ILE A 161     -13.670  35.809  43.597  1.00 10.04           C  
ATOM    505  O   ILE A 161     -13.738  36.994  43.927  1.00  9.83           O  
ATOM    506  CB  ILE A 161     -13.901  35.793  41.118  1.00 10.08           C  
ATOM    507  CG1 ILE A 161     -14.478  35.017  39.934  1.00 10.04           C  
ATOM    508  CG2 ILE A 161     -12.371  35.667  41.156  1.00  9.19           C  
ATOM    509  CD1 ILE A 161     -14.187  35.667  38.578  1.00 11.69           C  
ATOM    510  N   THR A 162     -12.889  34.933  44.215  1.00 10.02           N  
ATOM    511  CA  THR A 162     -11.987  35.345  45.277  1.00  9.31           C  
ATOM    512  C   THR A 162     -10.602  35.253  44.630  1.00 10.03           C  
ATOM    513  O   THR A 162     -10.243  34.230  44.043  1.00  8.19           O  
ATOM    514  CB  THR A 162     -12.058  34.409  46.495  1.00  8.35           C  
ATOM    515  OG1 THR A 162     -13.289  34.626  47.191  1.00  9.13           O  
ATOM    516  CG2 THR A 162     -10.902  34.681  47.445  1.00  8.20           C  
ATOM    517  N   TYR A 163      -9.839  36.334  44.709  1.00  9.96           N  
ATOM    518  CA  TYR A 163      -8.514  36.341  44.105  1.00 11.08           C  
ATOM    519  C   TYR A 163      -7.455  36.947  45.019  1.00 11.36           C  
ATOM    520  O   TYR A 163      -7.764  37.667  45.971  1.00 11.53           O  
ATOM    521  CB  TYR A 163      -8.559  37.085  42.763  1.00 10.95           C  
ATOM    522  CG  TYR A 163      -8.878  38.562  42.869  1.00 12.95           C  
ATOM    523  CD1 TYR A 163     -10.179  38.998  43.135  1.00 12.76           C  
ATOM    524  CD2 TYR A 163      -7.885  39.523  42.688  1.00 12.94           C  
ATOM    525  CE1 TYR A 163     -10.481  40.351  43.216  1.00 13.48           C  
ATOM    526  CE2 TYR A 163      -8.177  40.878  42.766  1.00 14.03           C  
ATOM    527  CZ  TYR A 163      -9.479  41.286  43.029  1.00 14.74           C  
ATOM    528  OH  TYR A 163      -9.784  42.629  43.085  1.00 16.80           O  
ATOM    529  N   ARG A 164      -6.200  36.632  44.736  1.00 10.94           N  
ATOM    530  CA  ARG A 164      -5.092  37.150  45.520  1.00 12.51           C  
ATOM    531  C   ARG A 164      -4.219  37.978  44.576  1.00 13.60           C  
ATOM    532  O   ARG A 164      -3.507  37.433  43.724  1.00 12.88           O  
ATOM    533  CB  ARG A 164      -4.286  35.995  46.119  1.00 13.89           C  
ATOM    534  CG  ARG A 164      -3.650  36.294  47.469  1.00 16.00           C  
ATOM    535  CD  ARG A 164      -2.683  37.459  47.393  1.00 17.51           C  
ATOM    536  NE  ARG A 164      -1.816  37.523  48.565  1.00 19.80           N  
ATOM    537  CZ  ARG A 164      -0.939  38.497  48.794  1.00 21.62           C  
ATOM    538  NH1 ARG A 164      -0.809  39.497  47.930  1.00 22.36           N  
ATOM    539  NH2 ARG A 164      -0.190  38.473  49.889  1.00 22.67           N  
ATOM    540  N   PRO A 165      -4.279  39.311  44.701  1.00 14.55           N  
ATOM    541  CA  PRO A 165      -3.462  40.150  43.818  1.00 13.70           C  
ATOM    542  C   PRO A 165      -2.021  40.333  44.301  1.00 14.23           C  
ATOM    543  O   PRO A 165      -1.754  40.448  45.501  1.00 13.05           O  
ATOM    544  CB  PRO A 165      -4.228  41.469  43.781  1.00 13.91           C  
ATOM    545  CG  PRO A 165      -4.887  41.543  45.151  1.00 14.53           C  
ATOM    546  CD  PRO A 165      -5.097  40.114  45.633  1.00 13.92           C  
ATOM    547  N   PHE A 166      -1.097  40.331  43.347  1.00 14.75           N  
ATOM    548  CA  PHE A 166       0.319  40.536  43.624  1.00 15.97           C  
ATOM    549  C   PHE A 166       0.663  41.703  42.713  1.00 17.16           C  
ATOM    550  O   PHE A 166       1.348  41.538  41.708  1.00 17.01           O  
ATOM    551  CB  PHE A 166       1.127  39.291  43.249  1.00 14.98           C  
ATOM    552  CG  PHE A 166       0.794  38.081  44.080  1.00 15.52           C  
ATOM    553  CD1 PHE A 166       1.314  37.934  45.362  1.00 16.27           C  
ATOM    554  CD2 PHE A 166      -0.059  37.094  43.591  1.00 14.91           C  
ATOM    555  CE1 PHE A 166       0.987  36.818  46.149  1.00 16.76           C  
ATOM    556  CE2 PHE A 166      -0.391  35.976  44.369  1.00 14.72           C  
ATOM    557  CZ  PHE A 166       0.132  35.840  45.647  1.00 15.61           C  
ATOM    558  N   ASP A 167       0.158  42.881  43.074  1.00 18.41           N  
ATOM    559  CA  ASP A 167       0.343  44.098  42.281  1.00 20.13           C  
ATOM    560  C   ASP A 167       1.764  44.350  41.783  1.00 20.29           C  
ATOM    561  O   ASP A 167       1.954  44.728  40.627  1.00 20.20           O  
ATOM    562  CB  ASP A 167      -0.159  45.324  43.064  1.00 20.58           C  
ATOM    563  CG  ASP A 167      -0.565  46.487  42.152  1.00 20.91           C  
ATOM    564  OD1 ASP A 167      -1.495  46.329  41.334  1.00 21.66           O  
ATOM    565  OD2 ASP A 167       0.049  47.567  42.251  1.00 23.79           O  
ATOM    566  N   LYS A 168       2.754  44.138  42.642  1.00 21.27           N  
ATOM    567  CA  LYS A 168       4.147  44.365  42.264  1.00 22.80           C  
ATOM    568  C   LYS A 168       4.623  43.414  41.169  1.00 21.97           C  
ATOM    569  O   LYS A 168       5.487  43.769  40.367  1.00 22.10           O  
ATOM    570  CB  LYS A 168       5.057  44.227  43.492  1.00 25.32           C  
ATOM    571  CG  LYS A 168       4.467  44.809  44.771  1.00 30.10           C  
ATOM    572  CD  LYS A 168       5.433  45.758  45.470  1.00 33.22           C  
ATOM    573  CE  LYS A 168       4.793  47.127  45.729  1.00 35.79           C  
ATOM    574  NZ  LYS A 168       3.458  47.034  46.409  1.00 37.42           N  
ATOM    575  N   ARG A 169       4.053  42.212  41.131  1.00 19.85           N  
ATOM    576  CA  ARG A 169       4.445  41.217  40.141  1.00 17.76           C  
ATOM    577  C   ARG A 169       3.510  41.211  38.936  1.00 16.01           C  
ATOM    578  O   ARG A 169       3.639  40.386  38.027  1.00 15.80           O  
ATOM    579  CB  ARG A 169       4.502  39.841  40.805  1.00 18.68           C  
ATOM    580  CG  ARG A 169       5.263  39.865  42.126  1.00 19.65           C  
ATOM    581  CD  ARG A 169       5.530  38.477  42.664  1.00 22.15           C  
ATOM    582  NE  ARG A 169       6.565  37.796  41.894  1.00 27.15           N  
ATOM    583  CZ  ARG A 169       7.864  37.831  42.186  1.00 28.73           C  
ATOM    584  NH1 ARG A 169       8.292  38.516  43.238  1.00 30.91           N  
ATOM    585  NH2 ARG A 169       8.737  37.185  41.420  1.00 29.66           N  
ATOM    586  N   GLU A 170       2.569  42.147  38.947  1.00 14.19           N  
ATOM    587  CA  GLU A 170       1.600  42.327  37.870  1.00 13.97           C  
ATOM    588  C   GLU A 170       0.651  41.171  37.564  1.00 12.39           C  
ATOM    589  O   GLU A 170       0.182  41.037  36.438  1.00 12.26           O  
ATOM    590  CB  GLU A 170       2.327  42.717  36.587  1.00 16.27           C  
ATOM    591  CG  GLU A 170       3.131  44.004  36.680  1.00 18.01           C  
ATOM    592  CD  GLU A 170       3.809  44.329  35.360  1.00 20.10           C  
ATOM    593  OE1 GLU A 170       4.635  43.515  34.894  1.00 21.68           O  
ATOM    594  OE2 GLU A 170       3.510  45.388  34.779  1.00 22.30           O  
ATOM    595  N   PHE A 171       0.364  40.338  38.555  1.00 11.05           N  
ATOM    596  CA  PHE A 171      -0.560  39.228  38.342  1.00 11.90           C  
ATOM    597  C   PHE A 171      -1.369  38.923  39.603  1.00 11.31           C  
ATOM    598  O   PHE A 171      -1.021  39.339  40.707  1.00 11.88           O  
ATOM    599  CB  PHE A 171       0.195  37.967  37.877  1.00 10.46           C  
ATOM    600  CG  PHE A 171       0.715  37.106  39.003  1.00 10.02           C  
ATOM    601  CD1 PHE A 171       1.972  37.337  39.547  1.00  8.68           C  
ATOM    602  CD2 PHE A 171      -0.052  36.052  39.512  1.00 11.00           C  
ATOM    603  CE1 PHE A 171       2.458  36.539  40.575  1.00 10.03           C  
ATOM    604  CE2 PHE A 171       0.429  35.246  40.546  1.00  9.45           C  
ATOM    605  CZ  PHE A 171       1.682  35.489  41.077  1.00 10.02           C  
ATOM    606  N   ALA A 172      -2.460  38.198  39.420  1.00 10.31           N  
ATOM    607  CA  ALA A 172      -3.305  37.822  40.533  1.00 10.49           C  
ATOM    608  C   ALA A 172      -3.677  36.364  40.361  1.00  9.59           C  
ATOM    609  O   ALA A 172      -3.821  35.877  39.238  1.00  7.64           O  
ATOM    610  CB  ALA A 172      -4.575  38.688  40.554  1.00  9.35           C  
ATOM    611  N   GLU A 173      -3.807  35.666  41.481  1.00 11.05           N  
ATOM    612  CA  GLU A 173      -4.220  34.273  41.452  1.00 11.63           C  
ATOM    613  C   GLU A 173      -5.723  34.250  41.643  1.00 11.46           C  
ATOM    614  O   GLU A 173      -6.239  34.867  42.571  1.00 11.61           O  
ATOM    615  CB  GLU A 173      -3.592  33.474  42.592  1.00 13.41           C  
ATOM    616  CG  GLU A 173      -4.191  32.069  42.698  1.00 17.93           C  
ATOM    617  CD  GLU A 173      -3.667  31.255  43.863  1.00 21.01           C  
ATOM    618  OE1 GLU A 173      -3.252  31.844  44.886  1.00 22.46           O  
ATOM    619  OE2 GLU A 173      -3.685  30.010  43.742  1.00 24.68           O  
ATOM    620  N   ILE A 174      -6.434  33.573  40.752  1.00 10.35           N  
ATOM    621  CA  ILE A 174      -7.871  33.457  40.930  1.00 11.24           C  
ATOM    622  C   ILE A 174      -8.016  32.162  41.733  1.00 11.88           C  
ATOM    623  O   ILE A 174      -7.787  31.061  41.224  1.00 11.73           O  
ATOM    624  CB  ILE A 174      -8.614  33.393  39.577  1.00 11.31           C  
ATOM    625  CG1 ILE A 174      -8.721  34.813  38.999  1.00 11.31           C  
ATOM    626  CG2 ILE A 174     -10.019  32.792  39.765  1.00 11.15           C  
ATOM    627  CD1 ILE A 174      -9.195  34.878  37.574  1.00 13.02           C  
ATOM    628  N   VAL A 175      -8.349  32.318  43.011  1.00 11.42           N  
ATOM    629  CA  VAL A 175      -8.487  31.196  43.937  1.00 11.02           C  
ATOM    630  C   VAL A 175      -9.808  30.427  43.818  1.00 11.23           C  
ATOM    631  O   VAL A 175      -9.812  29.196  43.745  1.00 10.88           O  
ATOM    632  CB  VAL A 175      -8.322  31.684  45.401  1.00 11.34           C  
ATOM    633  CG1 VAL A 175      -8.215  30.508  46.341  1.00 13.46           C  
ATOM    634  CG2 VAL A 175      -7.091  32.556  45.523  1.00 12.36           C  
ATOM    635  N   PHE A 176     -10.925  31.146  43.806  1.00  9.51           N  
ATOM    636  CA  PHE A 176     -12.236  30.504  43.720  1.00  9.54           C  
ATOM    637  C   PHE A 176     -13.118  31.279  42.754  1.00  8.94           C  
ATOM    638  O   PHE A 176     -13.033  32.506  42.670  1.00  8.46           O  
ATOM    639  CB  PHE A 176     -12.929  30.467  45.096  1.00  8.19           C  
ATOM    640  CG  PHE A 176     -12.148  29.756  46.175  1.00  9.21           C  
ATOM    641  CD1 PHE A 176     -11.751  28.426  46.019  1.00  9.72           C  
ATOM    642  CD2 PHE A 176     -11.816  30.415  47.356  1.00  8.83           C  
ATOM    643  CE1 PHE A 176     -11.036  27.767  47.026  1.00  9.51           C  
ATOM    644  CE2 PHE A 176     -11.100  29.764  48.371  1.00  9.83           C  
ATOM    645  CZ  PHE A 176     -10.711  28.438  48.202  1.00  9.91           C  
ATOM    646  N   CYS A 177     -13.958  30.554  42.026  1.00  8.03           N  
ATOM    647  CA  CYS A 177     -14.873  31.156  41.077  1.00  9.11           C  
ATOM    648  C   CYS A 177     -16.100  30.262  40.976  1.00  9.51           C  
ATOM    649  O   CYS A 177     -15.969  29.048  40.842  1.00  9.86           O  
ATOM    650  CB  CYS A 177     -14.212  31.283  39.697  1.00  9.34           C  
ATOM    651  SG  CYS A 177     -15.229  32.106  38.450  1.00 12.24           S  
ATOM    652  N   ALA A 178     -17.289  30.858  41.046  1.00  9.41           N  
ATOM    653  CA  ALA A 178     -18.523  30.091  40.943  1.00 10.36           C  
ATOM    654  C   ALA A 178     -19.761  30.971  40.883  1.00 10.60           C  
ATOM    655  O   ALA A 178     -19.761  32.094  41.377  1.00 10.67           O  
ATOM    656  CB  ALA A 178     -18.643  29.133  42.122  1.00 10.71           C  
ATOM    657  N   ILE A 179     -20.805  30.451  40.247  1.00 10.87           N  
ATOM    658  CA  ILE A 179     -22.089  31.134  40.164  1.00 10.61           C  
ATOM    659  C   ILE A 179     -23.051  30.184  40.890  1.00 11.52           C  
ATOM    660  O   ILE A 179     -23.013  28.969  40.672  1.00 11.60           O  
ATOM    661  CB  ILE A 179     -22.562  31.313  38.712  1.00 10.25           C  
ATOM    662  CG1 ILE A 179     -21.616  32.255  37.951  1.00  9.73           C  
ATOM    663  CG2 ILE A 179     -23.982  31.872  38.705  1.00 10.79           C  
ATOM    664  CD1 ILE A 179     -21.556  33.669  38.515  1.00  9.27           C  
ATOM    665  N   SER A 180     -23.890  30.718  41.770  1.00 10.98           N  
ATOM    666  CA  SER A 180     -24.817  29.867  42.505  1.00 12.42           C  
ATOM    667  C   SER A 180     -25.582  28.955  41.550  1.00 11.41           C  
ATOM    668  O   SER A 180     -26.078  29.402  40.523  1.00 11.71           O  
ATOM    669  CB  SER A 180     -25.806  30.718  43.307  1.00 13.08           C  
ATOM    670  OG  SER A 180     -26.774  29.884  43.917  1.00 15.59           O  
ATOM    671  N   SER A 181     -25.671  27.672  41.887  1.00 13.32           N  
ATOM    672  CA  SER A 181     -26.384  26.721  41.037  1.00 14.31           C  
ATOM    673  C   SER A 181     -27.877  27.031  40.946  1.00 15.41           C  
ATOM    674  O   SER A 181     -28.580  26.468  40.114  1.00 15.75           O  
ATOM    675  CB  SER A 181     -26.182  25.291  41.541  1.00 13.94           C  
ATOM    676  OG  SER A 181     -26.715  25.124  42.841  1.00 16.39           O  
ATOM    677  N   THR A 182     -28.366  27.925  41.799  1.00 16.99           N  
ATOM    678  CA  THR A 182     -29.778  28.296  41.758  1.00 18.76           C  
ATOM    679  C   THR A 182     -29.938  29.627  41.040  1.00 19.26           C  
ATOM    680  O   THR A 182     -30.996  30.257  41.094  1.00 19.36           O  
ATOM    681  CB  THR A 182     -30.391  28.401  43.171  1.00 19.04           C  
ATOM    682  OG1 THR A 182     -29.583  29.250  43.992  1.00 21.16           O  
ATOM    683  CG2 THR A 182     -30.475  27.024  43.802  1.00 19.54           C  
ATOM    684  N   GLU A 183     -28.874  30.040  40.357  1.00 19.17           N  
ATOM    685  CA  GLU A 183     -28.867  31.291  39.603  1.00 19.30           C  
ATOM    686  C   GLU A 183     -28.277  31.010  38.237  1.00 18.81           C  
ATOM    687  O   GLU A 183     -27.292  31.621  37.828  1.00 18.76           O  
ATOM    688  CB  GLU A 183     -28.023  32.331  40.331  1.00 20.44           C  
ATOM    689  CG  GLU A 183     -28.617  32.774  41.646  1.00 20.68           C  
ATOM    690  CD  GLU A 183     -29.825  33.667  41.450  1.00 21.99           C  
ATOM    691  OE1 GLU A 183     -30.076  34.085  40.296  1.00 20.78           O  
ATOM    692  OE2 GLU A 183     -30.519  33.948  42.452  1.00 22.54           O  
ATOM    693  N   GLN A 184     -28.894  30.075  37.530  1.00 18.74           N  
ATOM    694  CA  GLN A 184     -28.419  29.672  36.222  1.00 19.07           C  
ATOM    695  C   GLN A 184     -28.884  30.558  35.071  1.00 21.48           C  
ATOM    696  O   GLN A 184     -29.065  30.087  33.948  1.00 21.02           O  
ATOM    697  CB  GLN A 184     -28.812  28.216  35.980  1.00 17.54           C  
ATOM    698  CG  GLN A 184     -28.304  27.283  37.074  1.00 15.36           C  
ATOM    699  CD  GLN A 184     -28.434  25.810  36.718  1.00 15.31           C  
ATOM    700  OE1 GLN A 184     -28.642  25.450  35.558  1.00 14.64           O  
ATOM    701  NE2 GLN A 184     -28.309  24.951  37.720  1.00 14.38           N  
ATOM    702  N   VAL A 185     -29.062  31.848  35.346  1.00 23.68           N  
ATOM    703  CA  VAL A 185     -29.472  32.778  34.302  1.00 25.51           C  
ATOM    704  C   VAL A 185     -28.257  33.027  33.412  1.00 26.50           C  
ATOM    705  O   VAL A 185     -27.167  33.337  33.899  1.00 26.39           O  
ATOM    706  CB  VAL A 185     -29.981  34.125  34.890  1.00 25.96           C  
ATOM    707  CG1 VAL A 185     -30.052  34.039  36.413  1.00 26.88           C  
ATOM    708  CG2 VAL A 185     -29.083  35.272  34.449  1.00 26.82           C  
ATOM    709  N   ARG A 186     -28.447  32.870  32.108  1.00 27.69           N  
ATOM    710  CA  ARG A 186     -27.367  33.064  31.149  1.00 29.50           C  
ATOM    711  C   ARG A 186     -26.628  34.395  31.322  1.00 27.80           C  
ATOM    712  O   ARG A 186     -27.246  35.446  31.540  1.00 27.71           O  
ATOM    713  CB  ARG A 186     -27.920  32.975  29.724  1.00 33.59           C  
ATOM    714  CG  ARG A 186     -26.850  33.048  28.643  1.00 40.06           C  
ATOM    715  CD  ARG A 186     -26.907  31.839  27.718  1.00 45.07           C  
ATOM    716  NE  ARG A 186     -27.416  32.189  26.393  1.00 49.94           N  
ATOM    717  CZ  ARG A 186     -28.655  32.610  26.152  1.00 52.21           C  
ATOM    718  NH1 ARG A 186     -29.527  32.737  27.146  1.00 53.24           N  
ATOM    719  NH2 ARG A 186     -29.027  32.905  24.912  1.00 53.87           N  
ATOM    720  N   GLY A 187     -25.300  34.337  31.241  1.00 25.05           N  
ATOM    721  CA  GLY A 187     -24.504  35.545  31.345  1.00 21.31           C  
ATOM    722  C   GLY A 187     -23.746  35.862  32.617  1.00 18.52           C  
ATOM    723  O   GLY A 187     -22.717  36.517  32.544  1.00 17.74           O  
ATOM    724  N   TYR A 188     -24.226  35.406  33.770  1.00 16.48           N  
ATOM    725  CA  TYR A 188     -23.570  35.715  35.040  1.00 15.92           C  
ATOM    726  C   TYR A 188     -22.075  35.384  35.105  1.00 15.08           C  
ATOM    727  O   TYR A 188     -21.270  36.225  35.523  1.00 13.46           O  
ATOM    728  CB  TYR A 188     -24.292  35.016  36.202  1.00 18.68           C  
ATOM    729  CG  TYR A 188     -25.605  35.661  36.621  1.00 21.69           C  
ATOM    730  CD1 TYR A 188     -26.048  36.852  36.037  1.00 23.20           C  
ATOM    731  CD2 TYR A 188     -26.408  35.073  37.601  1.00 22.10           C  
ATOM    732  CE1 TYR A 188     -27.256  37.440  36.419  1.00 24.78           C  
ATOM    733  CE2 TYR A 188     -27.617  35.652  37.991  1.00 23.85           C  
ATOM    734  CZ  TYR A 188     -28.035  36.834  37.397  1.00 25.73           C  
ATOM    735  OH  TYR A 188     -29.230  37.406  37.777  1.00 26.83           O  
ATOM    736  N   GLY A 189     -21.711  34.168  34.703  1.00 13.20           N  
ATOM    737  CA  GLY A 189     -20.316  33.761  34.739  1.00 11.46           C  
ATOM    738  C   GLY A 189     -19.433  34.644  33.882  1.00 10.43           C  
ATOM    739  O   GLY A 189     -18.371  35.087  34.322  1.00  9.66           O  
ATOM    740  N   ALA A 190     -19.874  34.901  32.657  1.00 10.65           N  
ATOM    741  CA  ALA A 190     -19.120  35.732  31.731  1.00 10.89           C  
ATOM    742  C   ALA A 190     -19.062  37.186  32.197  1.00 11.83           C  
ATOM    743  O   ALA A 190     -18.001  37.806  32.174  1.00 12.23           O  
ATOM    744  CB  ALA A 190     -19.730  35.649  30.351  1.00 10.18           C  
ATOM    745  N   HIS A 191     -20.194  37.732  32.630  1.00 12.14           N  
ATOM    746  CA  HIS A 191     -20.218  39.122  33.086  1.00 12.73           C  
ATOM    747  C   HIS A 191     -19.370  39.323  34.331  1.00 11.65           C  
ATOM    748  O   HIS A 191     -18.751  40.372  34.509  1.00 12.30           O  
ATOM    749  CB  HIS A 191     -21.654  39.572  33.351  1.00 14.13           C  
ATOM    750  CG  HIS A 191     -22.490  39.640  32.117  1.00 15.73           C  
ATOM    751  ND1 HIS A 191     -23.862  39.525  32.139  1.00 18.02           N  
ATOM    752  CD2 HIS A 191     -22.145  39.772  30.814  1.00 17.97           C  
ATOM    753  CE1 HIS A 191     -24.326  39.580  30.903  1.00 18.71           C  
ATOM    754  NE2 HIS A 191     -23.304  39.729  30.080  1.00 18.91           N  
ATOM    755  N   LEU A 192     -19.342  38.314  35.194  1.00 11.14           N  
ATOM    756  CA  LEU A 192     -18.553  38.388  36.410  1.00 10.32           C  
ATOM    757  C   LEU A 192     -17.074  38.503  36.048  1.00  9.73           C  
ATOM    758  O   LEU A 192     -16.359  39.331  36.604  1.00  8.82           O  
ATOM    759  CB  LEU A 192     -18.785  37.146  37.273  1.00  9.90           C  
ATOM    760  CG  LEU A 192     -17.762  36.818  38.363  1.00 10.76           C  
ATOM    761  CD1 LEU A 192     -17.678  37.949  39.376  1.00  9.92           C  
ATOM    762  CD2 LEU A 192     -18.170  35.512  39.044  1.00 10.22           C  
ATOM    763  N   MET A 193     -16.615  37.679  35.111  1.00  9.68           N  
ATOM    764  CA  MET A 193     -15.211  37.730  34.721  1.00 10.60           C  
ATOM    765  C   MET A 193     -14.907  39.036  34.013  1.00 10.27           C  
ATOM    766  O   MET A 193     -13.850  39.633  34.224  1.00 10.10           O  
ATOM    767  CB  MET A 193     -14.845  36.551  33.810  1.00  9.34           C  
ATOM    768  CG  MET A 193     -13.334  36.425  33.541  1.00  8.44           C  
ATOM    769  SD  MET A 193     -12.317  36.259  35.020  1.00 10.84           S  
ATOM    770  CE  MET A 193     -12.565  34.496  35.428  1.00  8.07           C  
ATOM    771  N   ASN A 194     -15.837  39.477  33.175  1.00 10.39           N  
ATOM    772  CA  ASN A 194     -15.658  40.719  32.431  1.00 11.74           C  
ATOM    773  C   ASN A 194     -15.481  41.890  33.401  1.00 12.17           C  
ATOM    774  O   ASN A 194     -14.587  42.732  33.237  1.00 10.52           O  
ATOM    775  CB  ASN A 194     -16.868  40.968  31.520  1.00 13.01           C  
ATOM    776  CG  ASN A 194     -16.884  40.052  30.300  1.00 13.73           C  
ATOM    777  OD1 ASN A 194     -15.887  39.402  29.978  1.00 15.09           O  
ATOM    778  ND2 ASN A 194     -18.019  40.001  29.621  1.00 13.79           N  
ATOM    779  N   HIS A 195     -16.330  41.933  34.420  1.00 11.38           N  
ATOM    780  CA  HIS A 195     -16.253  42.996  35.407  1.00 11.44           C  
ATOM    781  C   HIS A 195     -14.960  42.945  36.207  1.00 10.45           C  
ATOM    782  O   HIS A 195     -14.388  43.986  36.517  1.00 10.39           O  
ATOM    783  CB  HIS A 195     -17.462  42.939  36.345  1.00 11.47           C  
ATOM    784  CG  HIS A 195     -18.686  43.579  35.768  1.00 13.04           C  
ATOM    785  ND1 HIS A 195     -19.059  44.874  36.062  1.00 13.91           N  
ATOM    786  CD2 HIS A 195     -19.579  43.127  34.857  1.00 11.75           C  
ATOM    787  CE1 HIS A 195     -20.130  45.190  35.355  1.00 13.39           C  
ATOM    788  NE2 HIS A 195     -20.465  44.148  34.615  1.00 12.83           N  
ATOM    789  N   LEU A 196     -14.492  41.746  36.545  1.00  9.04           N  
ATOM    790  CA  LEU A 196     -13.254  41.622  37.305  1.00  9.59           C  
ATOM    791  C   LEU A 196     -12.064  42.107  36.476  1.00  9.73           C  
ATOM    792  O   LEU A 196     -11.168  42.769  37.001  1.00 11.03           O  
ATOM    793  CB  LEU A 196     -13.012  40.169  37.747  1.00  8.66           C  
ATOM    794  CG  LEU A 196     -11.705  39.955  38.524  1.00  8.37           C  
ATOM    795  CD1 LEU A 196     -11.700  40.832  39.780  1.00  9.08           C  
ATOM    796  CD2 LEU A 196     -11.548  38.484  38.894  1.00  9.20           C  
ATOM    797  N   LYS A 197     -12.050  41.772  35.190  1.00  9.63           N  
ATOM    798  CA  LYS A 197     -10.958  42.194  34.311  1.00  9.90           C  
ATOM    799  C   LYS A 197     -10.935  43.732  34.225  1.00 10.49           C  
ATOM    800  O   LYS A 197      -9.884  44.371  34.354  1.00  9.06           O  
ATOM    801  CB  LYS A 197     -11.152  41.587  32.921  1.00  8.21           C  
ATOM    802  CG  LYS A 197     -10.691  40.142  32.804  1.00  7.46           C  
ATOM    803  CD  LYS A 197     -11.152  39.540  31.488  1.00  6.94           C  
ATOM    804  CE  LYS A 197     -10.772  38.074  31.381  1.00  5.54           C  
ATOM    805  NZ  LYS A 197     -11.253  37.513  30.101  1.00  8.94           N  
ATOM    806  N   ASP A 198     -12.108  44.318  34.022  1.00 11.94           N  
ATOM    807  CA  ASP A 198     -12.231  45.766  33.933  1.00 12.08           C  
ATOM    808  C   ASP A 198     -11.802  46.413  35.244  1.00 11.71           C  
ATOM    809  O   ASP A 198     -11.148  47.453  35.246  1.00 11.76           O  
ATOM    810  CB  ASP A 198     -13.676  46.148  33.624  1.00 14.84           C  
ATOM    811  CG  ASP A 198     -13.848  47.638  33.385  1.00 17.89           C  
ATOM    812  OD1 ASP A 198     -13.341  48.134  32.360  1.00 20.58           O  
ATOM    813  OD2 ASP A 198     -14.491  48.310  34.216  1.00 20.16           O  
ATOM    814  N   TYR A 199     -12.169  45.793  36.362  1.00 11.47           N  
ATOM    815  CA  TYR A 199     -11.822  46.321  37.673  1.00 10.76           C  
ATOM    816  C   TYR A 199     -10.319  46.321  37.928  1.00 11.28           C  
ATOM    817  O   TYR A 199      -9.750  47.364  38.260  1.00 12.09           O  
ATOM    818  CB  TYR A 199     -12.530  45.526  38.780  1.00 10.75           C  
ATOM    819  CG  TYR A 199     -12.289  46.069  40.174  1.00 10.95           C  
ATOM    820  CD1 TYR A 199     -13.029  47.149  40.666  1.00 11.18           C  
ATOM    821  CD2 TYR A 199     -11.311  45.511  41.000  1.00 11.36           C  
ATOM    822  CE1 TYR A 199     -12.798  47.657  41.948  1.00 12.35           C  
ATOM    823  CE2 TYR A 199     -11.072  46.012  42.281  1.00 12.46           C  
ATOM    824  CZ  TYR A 199     -11.818  47.083  42.746  1.00 13.25           C  
ATOM    825  OH  TYR A 199     -11.574  47.577  44.008  1.00 15.37           O  
ATOM    826  N   VAL A 200      -9.664  45.170  37.770  1.00 11.17           N  
ATOM    827  CA  VAL A 200      -8.223  45.107  38.018  1.00 11.09           C  
ATOM    828  C   VAL A 200      -7.431  46.012  37.075  1.00 11.41           C  
ATOM    829  O   VAL A 200      -6.456  46.642  37.487  1.00 12.46           O  
ATOM    830  CB  VAL A 200      -7.666  43.652  37.923  1.00 11.40           C  
ATOM    831  CG1 VAL A 200      -8.368  42.763  38.933  1.00 11.57           C  
ATOM    832  CG2 VAL A 200      -7.837  43.101  36.534  1.00 12.33           C  
ATOM    833  N   ARG A 201      -7.864  46.094  35.821  1.00 10.81           N  
ATOM    834  CA  ARG A 201      -7.191  46.921  34.825  1.00 11.64           C  
ATOM    835  C   ARG A 201      -7.333  48.424  35.113  1.00 12.43           C  
ATOM    836  O   ARG A 201      -6.550  49.238  34.618  1.00 11.99           O  
ATOM    837  CB  ARG A 201      -7.755  46.600  33.434  1.00 12.84           C  
ATOM    838  CG  ARG A 201      -7.009  47.272  32.291  1.00 15.77           C  
ATOM    839  CD  ARG A 201      -7.272  46.601  30.948  1.00 16.53           C  
ATOM    840  NE  ARG A 201      -6.630  47.360  29.882  1.00 17.67           N  
ATOM    841  CZ  ARG A 201      -7.114  47.492  28.655  1.00 18.74           C  
ATOM    842  NH1 ARG A 201      -8.255  46.907  28.328  1.00 20.86           N  
ATOM    843  NH2 ARG A 201      -6.465  48.223  27.758  1.00 19.20           N  
ATOM    844  N   ASN A 202      -8.321  48.787  35.927  1.00 12.38           N  
ATOM    845  CA  ASN A 202      -8.577  50.187  36.239  1.00 12.65           C  
ATOM    846  C   ASN A 202      -8.251  50.618  37.667  1.00 11.72           C  
ATOM    847  O   ASN A 202      -8.370  51.799  37.998  1.00 12.21           O  
ATOM    848  CB  ASN A 202     -10.041  50.516  35.924  1.00 11.74           C  
ATOM    849  CG  ASN A 202     -10.269  50.793  34.448  1.00 12.95           C  
ATOM    850  OD1 ASN A 202      -9.976  51.885  33.958  1.00 11.41           O  
ATOM    851  ND2 ASN A 202     -10.791  49.800  33.729  1.00 12.30           N  
ATOM    852  N   THR A 203      -7.821  49.675  38.501  1.00 11.11           N  
ATOM    853  CA  THR A 203      -7.501  49.974  39.897  1.00 11.42           C  
ATOM    854  C   THR A 203      -6.182  49.376  40.338  1.00 11.18           C  
ATOM    855  O   THR A 203      -5.806  49.490  41.505  1.00 11.47           O  
ATOM    856  CB  THR A 203      -8.574  49.413  40.854  1.00 12.52           C  
ATOM    857  OG1 THR A 203      -8.540  47.980  40.807  1.00 13.11           O  
ATOM    858  CG2 THR A 203      -9.963  49.906  40.463  1.00 12.56           C  
ATOM    859  N   SER A 204      -5.482  48.730  39.416  1.00 11.04           N  
ATOM    860  CA  SER A 204      -4.215  48.092  39.756  1.00 10.97           C  
ATOM    861  C   SER A 204      -3.302  47.906  38.546  1.00 10.22           C  
ATOM    862  O   SER A 204      -3.650  48.263  37.417  1.00  9.34           O  
ATOM    863  CB  SER A 204      -4.481  46.721  40.383  1.00 10.56           C  
ATOM    864  OG  SER A 204      -4.812  45.782  39.372  1.00 11.16           O  
ATOM    865  N   ASN A 205      -2.134  47.330  38.804  1.00 11.72           N  
ATOM    866  CA  ASN A 205      -1.152  47.067  37.761  1.00 13.21           C  
ATOM    867  C   ASN A 205      -1.179  45.592  37.372  1.00 14.53           C  
ATOM    868  O   ASN A 205      -0.245  45.089  36.753  1.00 15.15           O  
ATOM    869  CB  ASN A 205       0.244  47.465  38.246  1.00 14.00           C  
ATOM    870  CG  ASN A 205       0.382  48.970  38.439  1.00 13.37           C  
ATOM    871  OD1 ASN A 205      -0.083  49.761  37.614  1.00 13.44           O  
ATOM    872  ND2 ASN A 205       1.015  49.368  39.528  1.00 12.37           N  
ATOM    873  N   ILE A 206      -2.262  44.912  37.743  1.00 14.95           N  
ATOM    874  CA  ILE A 206      -2.451  43.497  37.423  1.00 15.40           C  
ATOM    875  C   ILE A 206      -2.759  43.370  35.928  1.00 15.33           C  
ATOM    876  O   ILE A 206      -3.695  43.998  35.425  1.00 15.74           O  
ATOM    877  CB  ILE A 206      -3.640  42.887  38.228  1.00 15.90           C  
ATOM    878  CG1 ILE A 206      -3.305  42.834  39.724  1.00 15.50           C  
ATOM    879  CG2 ILE A 206      -3.973  41.492  37.698  1.00 14.31           C  
ATOM    880  CD1 ILE A 206      -1.932  42.321  40.038  1.00 18.68           C  
ATOM    881  N   LYS A 207      -1.981  42.547  35.227  1.00 14.27           N  
ATOM    882  CA  LYS A 207      -2.159  42.343  33.792  1.00 15.00           C  
ATOM    883  C   LYS A 207      -2.338  40.866  33.435  1.00 14.19           C  
ATOM    884  O   LYS A 207      -2.545  40.526  32.270  1.00 14.89           O  
ATOM    885  CB  LYS A 207      -0.934  42.877  33.049  1.00 16.85           C  
ATOM    886  CG  LYS A 207      -1.159  44.144  32.265  1.00 19.72           C  
ATOM    887  CD  LYS A 207      -0.024  44.372  31.271  1.00 21.95           C  
ATOM    888  CE  LYS A 207       1.333  44.293  31.947  1.00 24.01           C  
ATOM    889  NZ  LYS A 207       2.424  44.690  31.016  1.00 26.42           N  
ATOM    890  N   TYR A 208      -2.240  39.994  34.435  1.00 13.07           N  
ATOM    891  CA  TYR A 208      -2.365  38.552  34.224  1.00 12.61           C  
ATOM    892  C   TYR A 208      -3.131  37.850  35.330  1.00 11.60           C  
ATOM    893  O   TYR A 208      -3.043  38.224  36.501  1.00 10.14           O  
ATOM    894  CB  TYR A 208      -0.987  37.881  34.176  1.00 14.72           C  
ATOM    895  CG  TYR A 208      -0.025  38.404  33.138  1.00 16.02           C  
ATOM    896  CD1 TYR A 208       0.851  39.449  33.434  1.00 16.83           C  
ATOM    897  CD2 TYR A 208       0.033  37.830  31.868  1.00 17.30           C  
ATOM    898  CE1 TYR A 208       1.762  39.911  32.489  1.00 17.78           C  
ATOM    899  CE2 TYR A 208       0.941  38.282  30.915  1.00 17.81           C  
ATOM    900  CZ  TYR A 208       1.801  39.322  31.230  1.00 18.86           C  
ATOM    901  OH  TYR A 208       2.699  39.770  30.286  1.00 20.06           O  
ATOM    902  N   PHE A 209      -3.860  36.809  34.947  1.00 11.02           N  
ATOM    903  CA  PHE A 209      -4.585  35.979  35.904  1.00 11.54           C  
ATOM    904  C   PHE A 209      -4.000  34.573  35.786  1.00 12.04           C  
ATOM    905  O   PHE A 209      -3.744  34.095  34.674  1.00 12.43           O  
ATOM    906  CB  PHE A 209      -6.069  35.885  35.560  1.00 11.23           C  
ATOM    907  CG  PHE A 209      -6.879  37.057  36.009  1.00 11.06           C  
ATOM    908  CD1 PHE A 209      -6.596  37.704  37.206  1.00 11.93           C  
ATOM    909  CD2 PHE A 209      -7.941  37.509  35.233  1.00 10.55           C  
ATOM    910  CE1 PHE A 209      -7.364  38.786  37.622  1.00 12.48           C  
ATOM    911  CE2 PHE A 209      -8.712  38.589  35.643  1.00 11.10           C  
ATOM    912  CZ  PHE A 209      -8.422  39.226  36.837  1.00 10.49           C  
ATOM    913  N   LEU A 210      -3.777  33.929  36.927  1.00 11.30           N  
ATOM    914  CA  LEU A 210      -3.288  32.554  36.964  1.00 11.45           C  
ATOM    915  C   LEU A 210      -4.229  31.805  37.909  1.00 11.52           C  
ATOM    916  O   LEU A 210      -4.644  32.339  38.943  1.00 11.13           O  
ATOM    917  CB  LEU A 210      -1.852  32.480  37.503  1.00 10.68           C  
ATOM    918  CG  LEU A 210      -0.674  32.756  36.555  1.00  9.68           C  
ATOM    919  CD1 LEU A 210       0.617  32.546  37.329  1.00  7.97           C  
ATOM    920  CD2 LEU A 210      -0.725  31.842  35.342  1.00  7.77           C  
ATOM    921  N   THR A 211      -4.583  30.578  37.551  1.00 11.65           N  
ATOM    922  CA  THR A 211      -5.469  29.785  38.394  1.00 11.11           C  
ATOM    923  C   THR A 211      -5.235  28.298  38.179  1.00 11.23           C  
ATOM    924  O   THR A 211      -4.944  27.863  37.068  1.00  9.72           O  
ATOM    925  CB  THR A 211      -6.975  30.105  38.106  1.00 11.12           C  
ATOM    926  OG1 THR A 211      -7.799  29.506  39.116  1.00  9.53           O  
ATOM    927  CG2 THR A 211      -7.400  29.582  36.729  1.00  8.84           C  
ATOM    928  N   TYR A 212      -5.329  27.534  39.260  1.00 11.41           N  
ATOM    929  CA  TYR A 212      -5.196  26.090  39.183  1.00 11.37           C  
ATOM    930  C   TYR A 212      -6.650  25.647  39.116  1.00 12.04           C  
ATOM    931  O   TYR A 212      -7.285  25.382  40.137  1.00 12.78           O  
ATOM    932  CB  TYR A 212      -4.509  25.539  40.428  1.00 11.65           C  
ATOM    933  CG  TYR A 212      -2.998  25.648  40.375  1.00 14.16           C  
ATOM    934  CD1 TYR A 212      -2.247  24.826  39.531  1.00 14.05           C  
ATOM    935  CD2 TYR A 212      -2.320  26.584  41.159  1.00 14.40           C  
ATOM    936  CE1 TYR A 212      -0.859  24.934  39.467  1.00 16.01           C  
ATOM    937  CE2 TYR A 212      -0.936  26.701  41.106  1.00 15.36           C  
ATOM    938  CZ  TYR A 212      -0.212  25.875  40.258  1.00 17.10           C  
ATOM    939  OH  TYR A 212       1.157  25.987  40.210  1.00 18.83           O  
ATOM    940  N   ALA A 213      -7.173  25.604  37.895  1.00 11.60           N  
ATOM    941  CA  ALA A 213      -8.565  25.237  37.641  1.00 11.24           C  
ATOM    942  C   ALA A 213      -8.924  23.802  37.992  1.00 12.40           C  
ATOM    943  O   ALA A 213      -8.158  22.875  37.717  1.00 12.11           O  
ATOM    944  CB  ALA A 213      -8.906  25.494  36.179  1.00  8.99           C  
ATOM    945  N   ASP A 214     -10.090  23.623  38.610  1.00 11.96           N  
ATOM    946  CA  ASP A 214     -10.549  22.280  38.923  1.00 12.50           C  
ATOM    947  C   ASP A 214     -11.084  21.765  37.588  1.00 12.31           C  
ATOM    948  O   ASP A 214     -11.429  22.558  36.704  1.00 11.84           O  
ATOM    949  CB  ASP A 214     -11.646  22.295  40.009  1.00 11.94           C  
ATOM    950  CG  ASP A 214     -12.814  23.202  39.666  1.00 11.70           C  
ATOM    951  OD1 ASP A 214     -12.678  24.439  39.792  1.00 10.46           O  
ATOM    952  OD2 ASP A 214     -13.876  22.669  39.279  1.00 11.63           O  
ATOM    953  N   ASN A 215     -11.137  20.449  37.427  1.00 12.67           N  
ATOM    954  CA  ASN A 215     -11.597  19.851  36.179  1.00 13.28           C  
ATOM    955  C   ASN A 215     -12.857  20.462  35.577  1.00 12.46           C  
ATOM    956  O   ASN A 215     -12.917  20.724  34.374  1.00 12.84           O  
ATOM    957  CB  ASN A 215     -11.815  18.349  36.378  1.00 16.96           C  
ATOM    958  CG  ASN A 215     -10.512  17.592  36.561  1.00 21.66           C  
ATOM    959  OD1 ASN A 215     -10.458  16.588  37.278  1.00 24.38           O  
ATOM    960  ND2 ASN A 215      -9.452  18.069  35.915  1.00 22.09           N  
ATOM    961  N   TYR A 216     -13.863  20.698  36.411  1.00 12.14           N  
ATOM    962  CA  TYR A 216     -15.132  21.237  35.926  1.00 11.55           C  
ATOM    963  C   TYR A 216     -15.175  22.726  35.602  1.00 12.15           C  
ATOM    964  O   TYR A 216     -16.196  23.222  35.123  1.00 13.64           O  
ATOM    965  CB  TYR A 216     -16.242  20.884  36.917  1.00 11.14           C  
ATOM    966  CG  TYR A 216     -16.464  19.394  37.004  1.00 11.27           C  
ATOM    967  CD1 TYR A 216     -16.948  18.678  35.906  1.00 12.04           C  
ATOM    968  CD2 TYR A 216     -16.138  18.688  38.159  1.00 11.15           C  
ATOM    969  CE1 TYR A 216     -17.095  17.295  35.963  1.00 13.05           C  
ATOM    970  CE2 TYR A 216     -16.283  17.307  38.224  1.00 12.30           C  
ATOM    971  CZ  TYR A 216     -16.759  16.620  37.123  1.00 13.12           C  
ATOM    972  OH  TYR A 216     -16.900  15.252  37.191  1.00 15.98           O  
ATOM    973  N   ALA A 217     -14.076  23.437  35.843  1.00 12.08           N  
ATOM    974  CA  ALA A 217     -14.033  24.870  35.555  1.00 11.27           C  
ATOM    975  C   ALA A 217     -13.199  25.183  34.316  1.00 11.41           C  
ATOM    976  O   ALA A 217     -13.249  26.296  33.791  1.00 11.10           O  
ATOM    977  CB  ALA A 217     -13.481  25.628  36.762  1.00  9.91           C  
ATOM    978  N   ILE A 218     -12.439  24.202  33.838  1.00 11.05           N  
ATOM    979  CA  ILE A 218     -11.588  24.410  32.672  1.00 11.34           C  
ATOM    980  C   ILE A 218     -12.334  24.983  31.470  1.00 11.18           C  
ATOM    981  O   ILE A 218     -11.866  25.941  30.843  1.00 10.18           O  
ATOM    982  CB  ILE A 218     -10.879  23.094  32.265  1.00 12.24           C  
ATOM    983  CG1 ILE A 218      -9.814  22.748  33.310  1.00 12.96           C  
ATOM    984  CG2 ILE A 218     -10.222  23.241  30.890  1.00 11.58           C  
ATOM    985  CD1 ILE A 218      -9.311  21.320  33.218  1.00 15.05           C  
ATOM    986  N   GLY A 219     -13.494  24.407  31.157  1.00 10.31           N  
ATOM    987  CA  GLY A 219     -14.271  24.872  30.022  1.00  9.75           C  
ATOM    988  C   GLY A 219     -14.711  26.318  30.150  1.00 11.12           C  
ATOM    989  O   GLY A 219     -14.672  27.082  29.181  1.00 11.32           O  
ATOM    990  N   TYR A 220     -15.138  26.698  31.350  1.00 10.16           N  
ATOM    991  CA  TYR A 220     -15.574  28.064  31.599  1.00  9.88           C  
ATOM    992  C   TYR A 220     -14.387  29.007  31.427  1.00 10.08           C  
ATOM    993  O   TYR A 220     -14.483  30.014  30.732  1.00 10.97           O  
ATOM    994  CB  TYR A 220     -16.137  28.188  33.022  1.00 10.18           C  
ATOM    995  CG  TYR A 220     -16.191  29.608  33.546  1.00  9.55           C  
ATOM    996  CD1 TYR A 220     -17.238  30.463  33.194  1.00 10.91           C  
ATOM    997  CD2 TYR A 220     -15.183  30.101  34.376  1.00 10.11           C  
ATOM    998  CE1 TYR A 220     -17.280  31.779  33.656  1.00 10.08           C  
ATOM    999  CE2 TYR A 220     -15.215  31.421  34.845  1.00 11.30           C  
ATOM   1000  CZ  TYR A 220     -16.267  32.249  34.478  1.00 11.15           C  
ATOM   1001  OH  TYR A 220     -16.296  33.548  34.927  1.00 12.38           O  
ATOM   1002  N   PHE A 221     -13.265  28.670  32.050  1.00  9.52           N  
ATOM   1003  CA  PHE A 221     -12.080  29.516  31.967  1.00 10.57           C  
ATOM   1004  C   PHE A 221     -11.612  29.701  30.529  1.00 10.61           C  
ATOM   1005  O   PHE A 221     -11.248  30.806  30.139  1.00 11.88           O  
ATOM   1006  CB  PHE A 221     -10.958  28.948  32.835  1.00 10.00           C  
ATOM   1007  CG  PHE A 221     -11.078  29.322  34.285  1.00  9.32           C  
ATOM   1008  CD1 PHE A 221     -11.064  30.661  34.674  1.00 10.04           C  
ATOM   1009  CD2 PHE A 221     -11.210  28.341  35.262  1.00  8.96           C  
ATOM   1010  CE1 PHE A 221     -11.183  31.018  36.027  1.00  9.53           C  
ATOM   1011  CE2 PHE A 221     -11.329  28.683  36.612  1.00  9.68           C  
ATOM   1012  CZ  PHE A 221     -11.314  30.028  36.995  1.00  8.11           C  
ATOM   1013  N   LYS A 222     -11.632  28.635  29.736  1.00 11.62           N  
ATOM   1014  CA  LYS A 222     -11.224  28.743  28.336  1.00 12.32           C  
ATOM   1015  C   LYS A 222     -12.116  29.758  27.623  1.00 12.81           C  
ATOM   1016  O   LYS A 222     -11.652  30.558  26.809  1.00 11.93           O  
ATOM   1017  CB  LYS A 222     -11.339  27.389  27.639  1.00 12.76           C  
ATOM   1018  CG  LYS A 222     -10.189  26.451  27.936  1.00 16.14           C  
ATOM   1019  CD  LYS A 222     -10.367  25.138  27.184  1.00 20.29           C  
ATOM   1020  CE  LYS A 222      -9.025  24.511  26.828  1.00 22.70           C  
ATOM   1021  NZ  LYS A 222      -9.176  23.336  25.914  1.00 26.04           N  
ATOM   1022  N   LYS A 223     -13.407  29.705  27.937  1.00 13.24           N  
ATOM   1023  CA  LYS A 223     -14.389  30.608  27.361  1.00 14.27           C  
ATOM   1024  C   LYS A 223     -14.078  32.052  27.740  1.00 13.48           C  
ATOM   1025  O   LYS A 223     -14.425  32.972  27.003  1.00 13.29           O  
ATOM   1026  CB  LYS A 223     -15.784  30.240  27.858  1.00 16.33           C  
ATOM   1027  CG  LYS A 223     -16.770  29.936  26.763  1.00 21.62           C  
ATOM   1028  CD  LYS A 223     -17.221  28.486  26.824  1.00 25.32           C  
ATOM   1029  CE  LYS A 223     -18.278  28.272  27.899  1.00 27.07           C  
ATOM   1030  NZ  LYS A 223     -19.620  27.996  27.314  1.00 28.95           N  
ATOM   1031  N   GLN A 224     -13.433  32.243  28.892  1.00 13.23           N  
ATOM   1032  CA  GLN A 224     -13.064  33.577  29.368  1.00 12.93           C  
ATOM   1033  C   GLN A 224     -11.644  33.962  28.939  1.00 13.31           C  
ATOM   1034  O   GLN A 224     -11.041  34.884  29.493  1.00 12.42           O  
ATOM   1035  CB  GLN A 224     -13.185  33.662  30.897  1.00 13.05           C  
ATOM   1036  CG  GLN A 224     -14.584  33.339  31.458  1.00 13.13           C  
ATOM   1037  CD  GLN A 224     -15.732  33.799  30.561  1.00 14.27           C  
ATOM   1038  OE1 GLN A 224     -16.539  32.988  30.109  1.00 17.46           O  
ATOM   1039  NE2 GLN A 224     -15.813  35.098  30.309  1.00 12.11           N  
ATOM   1040  N   GLY A 225     -11.110  33.241  27.958  1.00 13.54           N  
ATOM   1041  CA  GLY A 225      -9.791  33.557  27.440  1.00 13.41           C  
ATOM   1042  C   GLY A 225      -8.581  33.056  28.198  1.00 13.11           C  
ATOM   1043  O   GLY A 225      -7.491  33.591  28.015  1.00 13.76           O  
ATOM   1044  N   PHE A 226      -8.756  32.049  29.046  1.00 11.58           N  
ATOM   1045  CA  PHE A 226      -7.638  31.484  29.794  1.00 10.77           C  
ATOM   1046  C   PHE A 226      -7.091  30.330  28.955  1.00 11.06           C  
ATOM   1047  O   PHE A 226      -7.835  29.697  28.200  1.00 11.24           O  
ATOM   1048  CB  PHE A 226      -8.097  30.933  31.148  1.00  9.14           C  
ATOM   1049  CG  PHE A 226      -8.397  31.992  32.179  1.00  8.74           C  
ATOM   1050  CD1 PHE A 226      -9.425  32.909  31.978  1.00  8.49           C  
ATOM   1051  CD2 PHE A 226      -7.684  32.034  33.381  1.00  9.23           C  
ATOM   1052  CE1 PHE A 226      -9.750  33.852  32.960  1.00  8.92           C  
ATOM   1053  CE2 PHE A 226      -7.998  32.971  34.372  1.00  8.73           C  
ATOM   1054  CZ  PHE A 226      -9.035  33.879  34.157  1.00  8.14           C  
ATOM   1055  N   THR A 227      -5.799  30.049  29.093  1.00 10.68           N  
ATOM   1056  CA  THR A 227      -5.180  28.966  28.333  1.00 10.18           C  
ATOM   1057  C   THR A 227      -4.312  28.117  29.233  1.00  9.87           C  
ATOM   1058  O   THR A 227      -3.798  28.595  30.242  1.00 10.36           O  
ATOM   1059  CB  THR A 227      -4.285  29.506  27.181  1.00 10.56           C  
ATOM   1060  OG1 THR A 227      -3.582  28.418  26.567  1.00  9.43           O  
ATOM   1061  CG2 THR A 227      -3.269  30.507  27.716  1.00  9.44           C  
ATOM   1062  N   LYS A 228      -4.162  26.848  28.868  1.00 10.57           N  
ATOM   1063  CA  LYS A 228      -3.324  25.931  29.624  1.00 11.17           C  
ATOM   1064  C   LYS A 228      -1.843  26.205  29.299  1.00 11.56           C  
ATOM   1065  O   LYS A 228      -0.949  25.785  30.035  1.00 10.84           O  
ATOM   1066  CB  LYS A 228      -3.670  24.482  29.266  1.00 12.34           C  
ATOM   1067  CG  LYS A 228      -5.105  24.062  29.581  1.00 13.92           C  
ATOM   1068  CD  LYS A 228      -5.247  22.537  29.520  1.00 15.65           C  
ATOM   1069  CE  LYS A 228      -6.701  22.104  29.472  1.00 18.51           C  
ATOM   1070  NZ  LYS A 228      -7.114  21.662  28.106  1.00 21.88           N  
ATOM   1071  N   GLU A 229      -1.586  26.906  28.194  1.00 11.62           N  
ATOM   1072  CA  GLU A 229      -0.208  27.214  27.816  1.00 12.40           C  
ATOM   1073  C   GLU A 229       0.288  28.383  28.646  1.00 11.83           C  
ATOM   1074  O   GLU A 229      -0.035  29.533  28.370  1.00 13.45           O  
ATOM   1075  CB  GLU A 229      -0.106  27.557  26.327  1.00 13.54           C  
ATOM   1076  CG  GLU A 229       1.338  27.744  25.869  1.00 16.36           C  
ATOM   1077  CD  GLU A 229       1.472  27.954  24.367  1.00 19.74           C  
ATOM   1078  OE1 GLU A 229       0.495  28.400  23.730  1.00 23.86           O  
ATOM   1079  OE2 GLU A 229       2.560  27.672  23.823  1.00 18.37           O  
ATOM   1080  N   ILE A 230       1.075  28.078  29.668  1.00 11.99           N  
ATOM   1081  CA  ILE A 230       1.600  29.101  30.558  1.00 12.14           C  
ATOM   1082  C   ILE A 230       2.808  29.790  29.931  1.00 13.67           C  
ATOM   1083  O   ILE A 230       3.804  29.142  29.621  1.00 12.67           O  
ATOM   1084  CB  ILE A 230       2.003  28.481  31.913  1.00 11.76           C  
ATOM   1085  CG1 ILE A 230       0.876  27.567  32.424  1.00 10.68           C  
ATOM   1086  CG2 ILE A 230       2.324  29.578  32.923  1.00 11.67           C  
ATOM   1087  CD1 ILE A 230      -0.485  28.234  32.508  1.00 10.42           C  
ATOM   1088  N   THR A 231       2.708  31.104  29.743  1.00 14.74           N  
ATOM   1089  CA  THR A 231       3.789  31.883  29.149  1.00 16.05           C  
ATOM   1090  C   THR A 231       4.399  32.871  30.143  1.00 17.46           C  
ATOM   1091  O   THR A 231       5.404  33.523  29.857  1.00 17.54           O  
ATOM   1092  CB  THR A 231       3.295  32.638  27.912  1.00 15.45           C  
ATOM   1093  OG1 THR A 231       2.151  33.429  28.259  1.00 14.78           O  
ATOM   1094  CG2 THR A 231       2.916  31.654  26.812  1.00 15.10           C  
ATOM   1095  N   LEU A 232       3.781  32.983  31.313  1.00 19.29           N  
ATOM   1096  CA  LEU A 232       4.286  33.855  32.362  1.00 21.33           C  
ATOM   1097  C   LEU A 232       5.442  33.084  33.001  1.00 23.32           C  
ATOM   1098  O   LEU A 232       5.249  31.985  33.530  1.00 22.31           O  
ATOM   1099  CB  LEU A 232       3.182  34.126  33.391  1.00 19.86           C  
ATOM   1100  CG  LEU A 232       3.299  35.360  34.285  1.00 20.52           C  
ATOM   1101  CD1 LEU A 232       3.602  36.601  33.447  1.00 19.74           C  
ATOM   1102  CD2 LEU A 232       1.997  35.534  35.059  1.00 19.84           C  
ATOM   1103  N   ASP A 233       6.646  33.647  32.944  1.00 26.06           N  
ATOM   1104  CA  ASP A 233       7.806  32.966  33.502  1.00 28.47           C  
ATOM   1105  C   ASP A 233       7.607  32.495  34.940  1.00 28.23           C  
ATOM   1106  O   ASP A 233       7.119  33.241  35.794  1.00 28.10           O  
ATOM   1107  CB  ASP A 233       9.048  33.855  33.425  1.00 32.45           C  
ATOM   1108  CG  ASP A 233      10.313  33.105  33.806  1.00 36.43           C  
ATOM   1109  OD1 ASP A 233      10.827  32.329  32.967  1.00 40.21           O  
ATOM   1110  OD2 ASP A 233      10.785  33.278  34.948  1.00 39.74           O  
ATOM   1111  N   LYS A 234       8.008  31.254  35.197  1.00 27.85           N  
ATOM   1112  CA  LYS A 234       7.878  30.640  36.514  1.00 28.19           C  
ATOM   1113  C   LYS A 234       8.476  31.452  37.654  1.00 27.02           C  
ATOM   1114  O   LYS A 234       8.028  31.343  38.788  1.00 26.66           O  
ATOM   1115  CB  LYS A 234       8.513  29.244  36.511  1.00 30.56           C  
ATOM   1116  CG  LYS A 234       9.689  29.094  35.550  1.00 34.35           C  
ATOM   1117  CD  LYS A 234      10.656  28.014  36.015  1.00 36.78           C  
ATOM   1118  CE  LYS A 234      11.225  27.230  34.835  1.00 39.19           C  
ATOM   1119  NZ  LYS A 234      10.266  26.205  34.323  1.00 39.44           N  
ATOM   1120  N   SER A 235       9.487  32.263  37.368  1.00 26.42           N  
ATOM   1121  CA  SER A 235      10.110  33.062  38.422  1.00 25.28           C  
ATOM   1122  C   SER A 235       9.136  34.088  38.994  1.00 23.85           C  
ATOM   1123  O   SER A 235       9.236  34.470  40.158  1.00 24.10           O  
ATOM   1124  CB  SER A 235      11.358  33.774  37.888  1.00 25.62           C  
ATOM   1125  OG  SER A 235      11.022  34.716  36.883  1.00 26.44           O  
ATOM   1126  N   ILE A 236       8.186  34.517  38.173  1.00 22.73           N  
ATOM   1127  CA  ILE A 236       7.201  35.506  38.595  1.00 22.12           C  
ATOM   1128  C   ILE A 236       6.183  34.974  39.607  1.00 21.98           C  
ATOM   1129  O   ILE A 236       5.896  35.628  40.613  1.00 20.87           O  
ATOM   1130  CB  ILE A 236       6.420  36.057  37.384  1.00 22.10           C  
ATOM   1131  CG1 ILE A 236       7.373  36.801  36.446  1.00 21.70           C  
ATOM   1132  CG2 ILE A 236       5.304  36.982  37.855  1.00 22.76           C  
ATOM   1133  CD1 ILE A 236       6.951  36.754  34.992  1.00 23.12           C  
ATOM   1134  N   TRP A 237       5.650  33.784  39.347  1.00 20.78           N  
ATOM   1135  CA  TRP A 237       4.622  33.211  40.210  1.00 19.97           C  
ATOM   1136  C   TRP A 237       5.013  32.034  41.093  1.00 20.97           C  
ATOM   1137  O   TRP A 237       4.346  31.773  42.093  1.00 18.98           O  
ATOM   1138  CB  TRP A 237       3.422  32.807  39.357  1.00 17.44           C  
ATOM   1139  CG  TRP A 237       3.800  31.969  38.171  1.00 16.65           C  
ATOM   1140  CD1 TRP A 237       4.112  32.416  36.918  1.00 15.81           C  
ATOM   1141  CD2 TRP A 237       3.892  30.537  38.122  1.00 15.90           C  
ATOM   1142  NE1 TRP A 237       4.388  31.350  36.090  1.00 15.59           N  
ATOM   1143  CE2 TRP A 237       4.262  30.186  36.804  1.00 14.83           C  
ATOM   1144  CE3 TRP A 237       3.698  29.517  39.066  1.00 16.17           C  
ATOM   1145  CZ2 TRP A 237       4.441  28.856  36.401  1.00 15.12           C  
ATOM   1146  CZ3 TRP A 237       3.877  28.191  38.665  1.00 15.76           C  
ATOM   1147  CH2 TRP A 237       4.245  27.877  37.342  1.00 14.92           C  
ATOM   1148  N   MET A 238       6.074  31.317  40.734  1.00 22.85           N  
ATOM   1149  CA  MET A 238       6.491  30.164  41.528  1.00 25.60           C  
ATOM   1150  C   MET A 238       6.694  30.527  42.987  1.00 24.96           C  
ATOM   1151  O   MET A 238       7.387  31.493  43.304  1.00 25.36           O  
ATOM   1152  CB  MET A 238       7.775  29.554  40.971  1.00 29.30           C  
ATOM   1153  CG  MET A 238       7.534  28.651  39.780  1.00 34.46           C  
ATOM   1154  SD  MET A 238       7.925  26.927  40.107  1.00 41.32           S  
ATOM   1155  CE  MET A 238       8.174  26.337  38.408  1.00 39.73           C  
ATOM   1156  N   GLY A 239       6.079  29.745  43.869  1.00 23.98           N  
ATOM   1157  CA  GLY A 239       6.195  29.999  45.292  1.00 23.85           C  
ATOM   1158  C   GLY A 239       5.122  30.939  45.813  1.00 23.83           C  
ATOM   1159  O   GLY A 239       4.802  30.924  47.005  1.00 24.48           O  
ATOM   1160  N   TYR A 240       4.562  31.754  44.924  1.00 23.33           N  
ATOM   1161  CA  TYR A 240       3.527  32.711  45.305  1.00 23.31           C  
ATOM   1162  C   TYR A 240       2.131  32.131  45.207  1.00 22.43           C  
ATOM   1163  O   TYR A 240       1.198  32.654  45.811  1.00 23.08           O  
ATOM   1164  CB  TYR A 240       3.617  33.959  44.436  1.00 24.94           C  
ATOM   1165  CG  TYR A 240       4.870  34.743  44.688  1.00 27.36           C  
ATOM   1166  CD1 TYR A 240       6.042  34.464  43.986  1.00 27.48           C  
ATOM   1167  CD2 TYR A 240       4.898  35.753  45.648  1.00 28.17           C  
ATOM   1168  CE1 TYR A 240       7.213  35.169  44.236  1.00 29.40           C  
ATOM   1169  CE2 TYR A 240       6.064  36.465  45.907  1.00 29.43           C  
ATOM   1170  CZ  TYR A 240       7.215  36.169  45.200  1.00 30.05           C  
ATOM   1171  OH  TYR A 240       8.369  36.873  45.456  1.00 31.93           O  
ATOM   1172  N   ILE A 241       1.983  31.065  44.426  1.00 21.02           N  
ATOM   1173  CA  ILE A 241       0.694  30.406  44.285  1.00 20.11           C  
ATOM   1174  C   ILE A 241       0.893  28.923  44.594  1.00 20.68           C  
ATOM   1175  O   ILE A 241       1.955  28.365  44.315  1.00 19.95           O  
ATOM   1176  CB  ILE A 241       0.105  30.603  42.870  1.00 18.79           C  
ATOM   1177  CG1 ILE A 241       1.046  30.036  41.805  1.00 18.36           C  
ATOM   1178  CG2 ILE A 241      -0.130  32.084  42.614  1.00 18.99           C  
ATOM   1179  CD1 ILE A 241       0.423  29.984  40.417  1.00 16.27           C  
ATOM   1180  N   LYS A 242      -0.119  28.296  45.191  1.00 20.75           N  
ATOM   1181  CA  LYS A 242      -0.036  26.888  45.567  1.00 20.93           C  
ATOM   1182  C   LYS A 242      -1.072  26.045  44.846  1.00 19.90           C  
ATOM   1183  O   LYS A 242      -2.068  26.567  44.363  1.00 20.45           O  
ATOM   1184  CB  LYS A 242      -0.227  26.744  47.079  1.00 22.14           C  
ATOM   1185  CG  LYS A 242       0.881  27.371  47.913  1.00 22.37           C  
ATOM   1186  CD  LYS A 242       2.211  26.709  47.633  1.00 23.36           C  
ATOM   1187  CE  LYS A 242       3.363  27.623  47.998  1.00 25.29           C  
ATOM   1188  NZ  LYS A 242       3.493  27.769  49.470  1.00 27.30           N  
ATOM   1189  N   ASP A 243      -0.834  24.739  44.778  1.00 19.55           N  
ATOM   1190  CA  ASP A 243      -1.743  23.818  44.098  1.00 20.14           C  
ATOM   1191  C   ASP A 243      -1.952  22.553  44.923  1.00 20.30           C  
ATOM   1192  O   ASP A 243      -1.459  21.486  44.570  1.00 21.04           O  
ATOM   1193  CB  ASP A 243      -1.166  23.452  42.728  1.00 21.05           C  
ATOM   1194  CG  ASP A 243      -2.048  22.488  41.951  1.00 22.78           C  
ATOM   1195  OD1 ASP A 243      -3.281  22.473  42.166  1.00 21.21           O  
ATOM   1196  OD2 ASP A 243      -1.496  21.743  41.111  1.00 24.46           O  
ATOM   1197  N   TYR A 244      -2.690  22.668  46.019  1.00 20.11           N  
ATOM   1198  CA  TYR A 244      -2.931  21.520  46.882  1.00 20.81           C  
ATOM   1199  C   TYR A 244      -3.959  20.536  46.333  1.00 20.84           C  
ATOM   1200  O   TYR A 244      -3.973  19.366  46.722  1.00 21.83           O  
ATOM   1201  CB  TYR A 244      -3.360  21.996  48.273  1.00 20.52           C  
ATOM   1202  CG  TYR A 244      -2.342  22.898  48.935  1.00 22.14           C  
ATOM   1203  CD1 TYR A 244      -1.111  22.395  49.364  1.00 23.05           C  
ATOM   1204  CD2 TYR A 244      -2.599  24.257  49.119  1.00 22.66           C  
ATOM   1205  CE1 TYR A 244      -0.164  23.220  49.956  1.00 23.90           C  
ATOM   1206  CE2 TYR A 244      -1.658  25.094  49.712  1.00 23.90           C  
ATOM   1207  CZ  TYR A 244      -0.443  24.569  50.128  1.00 24.59           C  
ATOM   1208  OH  TYR A 244       0.485  25.388  50.728  1.00 25.38           O  
ATOM   1209  N   GLU A 245      -4.810  20.995  45.423  1.00 20.67           N  
ATOM   1210  CA  GLU A 245      -5.839  20.126  44.858  1.00 21.41           C  
ATOM   1211  C   GLU A 245      -5.444  19.449  43.548  1.00 21.00           C  
ATOM   1212  O   GLU A 245      -6.228  18.697  42.977  1.00 22.97           O  
ATOM   1213  CB  GLU A 245      -7.133  20.917  44.647  1.00 21.06           C  
ATOM   1214  CG  GLU A 245      -7.847  21.293  45.939  1.00 21.41           C  
ATOM   1215  CD  GLU A 245      -8.315  20.081  46.728  1.00 22.11           C  
ATOM   1216  OE1 GLU A 245      -8.713  19.073  46.106  1.00 23.62           O  
ATOM   1217  OE2 GLU A 245      -8.291  20.140  47.974  1.00 21.76           O  
ATOM   1218  N   GLY A 246      -4.234  19.711  43.070  1.00 19.94           N  
ATOM   1219  CA  GLY A 246      -3.802  19.106  41.824  1.00 18.77           C  
ATOM   1220  C   GLY A 246      -4.679  19.505  40.649  1.00 18.50           C  
ATOM   1221  O   GLY A 246      -5.159  18.650  39.905  1.00 19.99           O  
ATOM   1222  N   GLY A 247      -4.883  20.808  40.475  1.00 16.47           N  
ATOM   1223  CA  GLY A 247      -5.708  21.288  39.382  1.00 14.63           C  
ATOM   1224  C   GLY A 247      -4.884  21.528  38.135  1.00 14.59           C  
ATOM   1225  O   GLY A 247      -3.751  21.058  38.037  1.00 15.29           O  
ATOM   1226  N   THR A 248      -5.452  22.262  37.184  1.00 12.38           N  
ATOM   1227  CA  THR A 248      -4.783  22.565  35.925  1.00 10.50           C  
ATOM   1228  C   THR A 248      -4.450  24.049  35.849  1.00 10.20           C  
ATOM   1229  O   THR A 248      -5.346  24.879  35.758  1.00  9.19           O  
ATOM   1230  CB  THR A 248      -5.693  22.204  34.748  1.00  9.61           C  
ATOM   1231  OG1 THR A 248      -5.980  20.805  34.799  1.00  9.85           O  
ATOM   1232  CG2 THR A 248      -5.030  22.547  33.411  1.00  9.86           C  
ATOM   1233  N   LEU A 249      -3.165  24.384  35.888  1.00  9.93           N  
ATOM   1234  CA  LEU A 249      -2.768  25.785  35.807  1.00  9.91           C  
ATOM   1235  C   LEU A 249      -3.214  26.374  34.471  1.00  9.88           C  
ATOM   1236  O   LEU A 249      -2.990  25.783  33.414  1.00  9.05           O  
ATOM   1237  CB  LEU A 249      -1.247  25.929  35.963  1.00 10.20           C  
ATOM   1238  CG  LEU A 249      -0.707  27.364  36.048  1.00 10.42           C  
ATOM   1239  CD1 LEU A 249      -1.336  28.084  37.244  1.00  9.09           C  
ATOM   1240  CD2 LEU A 249       0.808  27.335  36.186  1.00 10.51           C  
ATOM   1241  N   MET A 250      -3.872  27.531  34.531  1.00  9.76           N  
ATOM   1242  CA  MET A 250      -4.347  28.224  33.334  1.00 10.48           C  
ATOM   1243  C   MET A 250      -4.022  29.705  33.478  1.00 11.52           C  
ATOM   1244  O   MET A 250      -4.021  30.246  34.588  1.00 11.30           O  
ATOM   1245  CB  MET A 250      -5.854  28.031  33.164  1.00  9.70           C  
ATOM   1246  CG  MET A 250      -6.240  26.591  32.874  1.00 10.71           C  
ATOM   1247  SD  MET A 250      -7.984  26.390  32.608  1.00 10.97           S  
ATOM   1248  CE  MET A 250      -8.118  26.962  30.955  1.00 10.50           C  
ATOM   1249  N   GLN A 251      -3.756  30.363  32.356  1.00 10.50           N  
ATOM   1250  CA  GLN A 251      -3.391  31.769  32.391  1.00 10.43           C  
ATOM   1251  C   GLN A 251      -4.223  32.657  31.484  1.00 10.41           C  
ATOM   1252  O   GLN A 251      -4.696  32.231  30.427  1.00 10.66           O  
ATOM   1253  CB  GLN A 251      -1.910  31.910  32.012  1.00 11.24           C  
ATOM   1254  CG  GLN A 251      -1.450  33.325  31.680  1.00 10.04           C  
ATOM   1255  CD  GLN A 251      -0.005  33.372  31.210  1.00 11.10           C  
ATOM   1256  OE1 GLN A 251       0.795  32.488  31.532  1.00 11.63           O  
ATOM   1257  NE2 GLN A 251       0.339  34.408  30.443  1.00  9.86           N  
ATOM   1258  N   CYS A 252      -4.422  33.896  31.921  1.00 10.45           N  
ATOM   1259  CA  CYS A 252      -5.121  34.877  31.111  1.00 10.78           C  
ATOM   1260  C   CYS A 252      -4.213  36.103  31.074  1.00 10.48           C  
ATOM   1261  O   CYS A 252      -3.778  36.596  32.111  1.00 10.37           O  
ATOM   1262  CB  CYS A 252      -6.480  35.258  31.697  1.00 10.75           C  
ATOM   1263  SG  CYS A 252      -7.429  36.291  30.556  1.00 13.04           S  
ATOM   1264  N   SER A 253      -3.911  36.573  29.875  1.00 10.17           N  
ATOM   1265  CA  SER A 253      -3.053  37.735  29.717  1.00 11.36           C  
ATOM   1266  C   SER A 253      -3.916  38.898  29.247  1.00 11.87           C  
ATOM   1267  O   SER A 253      -4.530  38.832  28.183  1.00 12.81           O  
ATOM   1268  CB  SER A 253      -1.959  37.409  28.702  1.00 11.09           C  
ATOM   1269  OG  SER A 253      -1.324  36.190  29.065  1.00 10.44           O  
ATOM   1270  N   MET A 254      -3.980  39.958  30.046  1.00 13.21           N  
ATOM   1271  CA  MET A 254      -4.810  41.113  29.696  1.00 14.65           C  
ATOM   1272  C   MET A 254      -3.991  42.341  29.294  1.00 15.29           C  
ATOM   1273  O   MET A 254      -2.767  42.355  29.433  1.00 14.42           O  
ATOM   1274  CB  MET A 254      -5.731  41.468  30.870  1.00 14.82           C  
ATOM   1275  CG  MET A 254      -6.686  40.346  31.263  1.00 16.81           C  
ATOM   1276  SD  MET A 254      -6.018  39.285  32.555  1.00 19.97           S  
ATOM   1277  CE  MET A 254      -6.176  40.402  33.996  1.00 16.91           C  
ATOM   1278  N   LEU A 255      -4.683  43.367  28.800  1.00 15.15           N  
ATOM   1279  CA  LEU A 255      -4.041  44.605  28.367  1.00 15.79           C  
ATOM   1280  C   LEU A 255      -3.600  45.457  29.560  1.00 16.34           C  
ATOM   1281  O   LEU A 255      -4.065  45.252  30.683  1.00 17.00           O  
ATOM   1282  CB  LEU A 255      -4.998  45.378  27.469  1.00 16.25           C  
ATOM   1283  CG  LEU A 255      -5.363  44.545  26.241  1.00 16.83           C  
ATOM   1284  CD1 LEU A 255      -6.573  45.127  25.548  1.00 17.94           C  
ATOM   1285  CD2 LEU A 255      -4.169  44.500  25.306  1.00 17.08           C  
ATOM   1286  N   PRO A 256      -2.701  46.430  29.327  1.00 15.80           N  
ATOM   1287  CA  PRO A 256      -2.201  47.293  30.405  1.00 14.49           C  
ATOM   1288  C   PRO A 256      -3.231  48.194  31.086  1.00 11.99           C  
ATOM   1289  O   PRO A 256      -4.336  48.412  30.579  1.00 11.17           O  
ATOM   1290  CB  PRO A 256      -1.088  48.109  29.739  1.00 14.67           C  
ATOM   1291  CG  PRO A 256      -0.845  47.464  28.416  1.00 15.55           C  
ATOM   1292  CD  PRO A 256      -2.117  46.800  28.025  1.00 16.09           C  
ATOM   1293  N   ARG A 257      -2.826  48.717  32.238  1.00 11.96           N  
ATOM   1294  CA  ARG A 257      -3.655  49.597  33.054  1.00 11.85           C  
ATOM   1295  C   ARG A 257      -4.319  50.736  32.286  1.00 12.36           C  
ATOM   1296  O   ARG A 257      -3.738  51.325  31.366  1.00 11.86           O  
ATOM   1297  CB  ARG A 257      -2.824  50.178  34.199  1.00 12.75           C  
ATOM   1298  CG  ARG A 257      -3.625  51.061  35.147  1.00 11.28           C  
ATOM   1299  CD  ARG A 257      -2.891  51.273  36.441  1.00 11.77           C  
ATOM   1300  NE  ARG A 257      -3.752  51.869  37.457  1.00 10.94           N  
ATOM   1301  CZ  ARG A 257      -3.575  51.723  38.765  1.00 12.46           C  
ATOM   1302  NH1 ARG A 257      -2.563  51.001  39.224  1.00 11.50           N  
ATOM   1303  NH2 ARG A 257      -4.416  52.300  39.618  1.00 13.08           N  
ATOM   1304  N   ILE A 258      -5.550  51.042  32.684  1.00 10.54           N  
ATOM   1305  CA  ILE A 258      -6.326  52.098  32.062  1.00 10.84           C  
ATOM   1306  C   ILE A 258      -6.360  53.303  33.001  1.00 11.52           C  
ATOM   1307  O   ILE A 258      -5.534  54.209  32.874  1.00 11.32           O  
ATOM   1308  CB  ILE A 258      -7.752  51.600  31.748  1.00  9.71           C  
ATOM   1309  CG1 ILE A 258      -7.667  50.511  30.674  1.00 10.39           C  
ATOM   1310  CG2 ILE A 258      -8.630  52.751  31.260  1.00  9.68           C  
ATOM   1311  CD1 ILE A 258      -9.007  50.027  30.165  1.00 12.66           C  
ATOM   1312  N   ARG A 259      -7.277  53.305  33.964  1.00 10.22           N  
ATOM   1313  CA  ARG A 259      -7.367  54.429  34.890  1.00  9.71           C  
ATOM   1314  C   ARG A 259      -6.246  54.480  35.922  1.00  9.99           C  
ATOM   1315  O   ARG A 259      -5.803  53.444  36.440  1.00  8.72           O  
ATOM   1316  CB  ARG A 259      -8.709  54.405  35.648  1.00  9.68           C  
ATOM   1317  CG  ARG A 259      -9.184  55.781  36.163  1.00  8.75           C  
ATOM   1318  CD  ARG A 259      -9.803  56.568  35.019  1.00  8.50           C  
ATOM   1319  NE  ARG A 259     -10.605  57.723  35.423  1.00  9.23           N  
ATOM   1320  CZ  ARG A 259     -10.135  58.965  35.499  1.00 10.07           C  
ATOM   1321  NH1 ARG A 259      -8.861  59.213  35.201  1.00  9.63           N  
ATOM   1322  NH2 ARG A 259     -10.945  59.969  35.823  1.00  8.68           N  
ATOM   1323  N   TYR A 260      -5.779  55.695  36.199  1.00  7.99           N  
ATOM   1324  CA  TYR A 260      -4.783  55.924  37.236  1.00  9.48           C  
ATOM   1325  C   TYR A 260      -4.878  57.361  37.749  1.00  9.52           C  
ATOM   1326  O   TYR A 260      -4.784  58.314  36.969  1.00  9.88           O  
ATOM   1327  CB  TYR A 260      -3.341  55.664  36.774  1.00  8.85           C  
ATOM   1328  CG  TYR A 260      -2.376  55.933  37.914  1.00  9.33           C  
ATOM   1329  CD1 TYR A 260      -2.345  55.093  39.027  1.00  9.16           C  
ATOM   1330  CD2 TYR A 260      -1.610  57.102  37.952  1.00  9.88           C  
ATOM   1331  CE1 TYR A 260      -1.592  55.411  40.156  1.00 10.35           C  
ATOM   1332  CE2 TYR A 260      -0.851  57.431  39.081  1.00 10.10           C  
ATOM   1333  CZ  TYR A 260      -0.855  56.583  40.177  1.00 10.33           C  
ATOM   1334  OH  TYR A 260      -0.168  56.921  41.314  1.00 12.74           O  
ATOM   1335  N   LEU A 261      -5.071  57.504  39.059  1.00  9.30           N  
ATOM   1336  CA  LEU A 261      -5.163  58.812  39.699  1.00  9.89           C  
ATOM   1337  C   LEU A 261      -4.259  58.796  40.929  1.00 10.66           C  
ATOM   1338  O   LEU A 261      -3.395  59.658  41.085  1.00 11.32           O  
ATOM   1339  CB  LEU A 261      -6.615  59.122  40.082  1.00  9.76           C  
ATOM   1340  CG  LEU A 261      -7.514  59.470  38.888  1.00 10.80           C  
ATOM   1341  CD1 LEU A 261      -8.972  59.229  39.233  1.00 10.56           C  
ATOM   1342  CD2 LEU A 261      -7.291  60.928  38.486  1.00 11.21           C  
ATOM   1343  N   ASP A 262      -4.447  57.808  41.800  1.00 12.08           N  
ATOM   1344  CA  ASP A 262      -3.604  57.677  42.984  1.00 13.07           C  
ATOM   1345  C   ASP A 262      -3.554  56.242  43.514  1.00 13.77           C  
ATOM   1346  O   ASP A 262      -3.951  55.322  42.772  1.00 14.43           O  
ATOM   1347  CB  ASP A 262      -4.041  58.652  44.092  1.00 13.95           C  
ATOM   1348  CG  ASP A 262      -5.398  58.317  44.693  1.00 16.12           C  
ATOM   1349  OD1 ASP A 262      -6.067  57.359  44.252  1.00 17.92           O  
ATOM   1350  OD2 ASP A 262      -5.803  59.034  45.629  1.00 17.58           O  
ATOM   1351  OXT ASP A 262      -3.103  56.048  44.656  1.00 14.40           O  
TER    1352      ASP A 262                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
