
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  166 ( 1331),  selected  166 , name 2ob0_C
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2ob0_C.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     4_C      -       -           -
LGA    R     5_C      A       2          1.101
LGA    I     6_C      I       3          1.275
LGA    E     7_C      N       4          0.846
LGA    L     8_C      I       5          1.253
LGA    G     9_C      I       6          1.817
LGA    D    10_C      E       7          2.379
LGA    V    11_C      Y       8          1.602
LGA    T    12_C      N       9          1.741
LGA    P    13_C      R      10          1.941
LGA    H    14_C      S      11          1.325
LGA    N    15_C      Y      12          1.352
LGA    I    16_C      K      13          1.176
LGA    K    17_C      E      14          1.283
LGA    Q    18_C      E      15          1.064
LGA    L    19_C      L      16          0.921
LGA    K    20_C      I      17          0.732
LGA    R    21_C      E      18          1.046
LGA    L    22_C      F      19          0.800
LGA    N    23_C      I      20          1.093
LGA    Q    24_C      L      21          0.775
LGA    V    25_C      S      22          1.086
LGA    I    26_C      I      23          1.986
LGA    F    27_C      Q      24          2.464
LGA    -       -      K      25           -
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    -       -      N      29           -
LGA    P    28_C      I      30          3.135
LGA    -       -      K      31           -
LGA    V    29_C      I      32          2.604
LGA    S    30_C      D      33          2.756
LGA    -       -      R      34           -
LGA    -       -      D      35           -
LGA    Y    31_C      D      36          3.932
LGA    N    32_C      Q      37          3.404
LGA    D    33_C      P      38          3.238
LGA    K    34_C      D      39          3.913
LGA    F    35_C      L      40          3.400
LGA    Y    36_C      E      41          2.422
LGA    K    37_C      N      42          1.513
LGA    D    38_C      I      43          4.069
LGA    V    39_C      E      44          3.943
LGA    L    40_C      H      45          4.795
LGA    E    41_C      N      46          5.496
LGA    V    42_C      Y      47          2.939
LGA    G    43_C      L      48          3.102
LGA    E    44_C      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    L    45_C      Q      53          0.537
LGA    A    46_C      F      54          0.401
LGA    K    47_C      W      55          1.544
LGA    L    48_C      L      56          1.554
LGA    A    49_C      A      57          1.169
LGA    Y    50_C      I      58          1.133
LGA    F    51_C      N      59          2.653
LGA    N    52_C      N      60          2.903
LGA    D    53_C      H      61          2.983
LGA    -       -      Q      62           -
LGA    I    54_C      N      63          2.821
LGA    A    55_C      I      64          1.679
LGA    V    56_C      V      65          1.525
LGA    G    57_C      G      66          1.777
LGA    A    58_C      T      67          1.143
LGA    V    59_C      I      68          1.023
LGA    C    60_C      G      69          1.685
LGA    C    61_C      L      70          1.662
LGA    R    62_C      I      71          0.892
LGA    V    63_C      R      72          0.876
LGA    D    64_C      L      73          1.477
LGA    H    65_C      D      74          2.222
LGA    S    66_C      -       -           -
LGA    Q    67_C      -       -           -
LGA    N    68_C      -       -           -
LGA    Q    69_C      N      75          3.070
LGA    K    70_C      N      76          2.183
LGA    R    71_C      M      77          1.351
LGA    L    72_C      S      78          1.496
LGA    Y    73_C      A      79          0.451
LGA    I    74_C      L      80          0.904
LGA    X    75_C      K      81          1.537
LGA    T    76_C      K      82          0.955
LGA    L    77_C      M      83          0.667
LGA    G    78_C      F      84          0.810
LGA    C    79_C      V      85          1.233
LGA    L    80_C      D      86          1.661
LGA    A    81_C      K      87          1.396
LGA    P    82_C      G      88          1.786
LGA    Y    83_C      Y      89          1.178
LGA    R    84_C      R      90          0.707
LGA    R    85_C      N      91          1.921
LGA    L    86_C      L      92          0.929
LGA    G    87_C      K      93          0.877
LGA    I    88_C      I      94          0.818
LGA    G    89_C      G      95          0.412
LGA    T    90_C      K      96          0.680
LGA    K    91_C      K      97          0.954
LGA    X    92_C      L      98          0.650
LGA    L    93_C      L      99          0.386
LGA    N    94_C      D     100          0.470
LGA    H    95_C      K     101          0.651
LGA    V    96_C      V     102          0.447
LGA    L    97_C      I     103          0.236
LGA    N    98_C      M     104          0.514
LGA    I    99_C      T     105          0.754
LGA    C   100_C      C     106          0.730
LGA    E   101_C      K     107          0.796
LGA    K   102_C      E     108          0.882
LGA    D   103_C      Q     109          1.178
LGA    G   104_C      N     110          1.138
LGA    T   105_C      I     111          3.477
LGA    F   106_C      -       -           -
LGA    D   107_C      D     112          2.416
LGA    N   108_C      G     113          1.034
LGA    I   109_C      I     114          0.530
LGA    Y   110_C      Y     115          1.675
LGA    L   111_C      L     116          0.943
LGA    H   112_C      G     117          1.098
LGA    V   113_C      T     118          1.905
LGA    Q   114_C      I     119          1.002
LGA    I   115_C      D     120          2.180
LGA    S   116_C      K     121          3.436
LGA    N   117_C      F     122          2.675
LGA    E   118_C      I     123          2.577
LGA    S   119_C      S     124          0.686
LGA    A   120_C      A     125          0.730
LGA    I   121_C      Q     126          1.184
LGA    D   122_C      Y     127          0.904
LGA    F   123_C      F     128          0.697
LGA    Y   124_C      Y     129          0.903
LGA    R   125_C      S     130          1.051
LGA    K   126_C      N     131          1.014
LGA    F   127_C      N     132          0.883
LGA    G   128_C      G     133          1.191
LGA    F   129_C      F     134          0.708
LGA    E   130_C      R     135          0.634
LGA    I   131_C      E     136          0.471
LGA    I   132_C      I     137          1.487
LGA    E   133_C      K     138          1.597
LGA    T   134_C      -       -           -
LGA    K   135_C      R     139          3.812
LGA    K   136_C      G     140           -
LGA    N   137_C      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    Y   138_C      L     149           #
LGA    Y   139_C      D     150          3.500
LGA    K   140_C      V     151          4.958
LGA    R   141_C      -       -           -
LGA    I   142_C      -       -           -
LGA    E   143_C      -       -           -
LGA    P   144_C      -       -           -
LGA    A   145_C      -       -           -
LGA    D   146_C      D     152           #
LGA    A   147_C      N     153          1.476
LGA    H   148_C      R     154          1.406
LGA    V   149_C      F     155          0.928
LGA    L   150_C      Y     156          1.205
LGA    Q   151_C      Y     157          0.789
LGA    K   152_C      R     158          0.505
LGA    N   153_C      N     159          0.838
LGA    L   154_C      L     160          1.642
LGA    K   155_C      K     161          2.339
LGA    V   156_C      -       -           -
LGA    P   157_C      -       -           -
LGA    S   158_C      -       -           -
LGA    G   159_C      -       -           -
LGA    Q   160_C      -       -           -
LGA    N   161_C      -       -           -
LGA    A   162_C      -       -           -
LGA    D   163_C      -       -           -
LGA    V   164_C      -       -           -
LGA    Q   165_C      -       -           -
LGA    K   166_C      -       -           -
LGA    T   167_C      -       -           -
LGA    D   168_C      -       -           -
LGA    N   169_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  166  160    5.0    136    1.92    22.79     74.190     6.717

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.375995 * X  +  -0.224706 * Y  +   0.898963 * Z  + 161.235092
  Y_new =  -0.315365 * X  +  -0.881204 * Y  +  -0.352170 * Z  + 347.592957
  Z_new =   0.871305 * X  +  -0.415916 * Y  +   0.260464 * Z  + 175.564026 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.011304    2.130288  [ DEG:   -57.9435    122.0565 ]
  Theta =  -1.057855   -2.083737  [ DEG:   -60.6106   -119.3894 ]
  Phi   =  -2.443667    0.697926  [ DEG:  -140.0118     39.9882 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ob0_C                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ob0_C.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  166  160   5.0  136   1.92   22.79  74.190
REMARK  ---------------------------------------------------------- 
MOLECULE 2ob0_C
HEADER    TRANSFERASE                             18-DEC-06   2OB0              
TITLE     HUMAN MAK3 HOMOLOG IN COMPLEX WITH ACETYL-COA                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HUMAN MAK3 HOMOLOG;                                        
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: N-ACETYLTRANSFERASE 13;                                     
COMPND   5 EC: 2.3.1.88;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: NAT13;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28-LIC                                 
KEYWDS    ACETYLTRANSFERASE, STRUCTURAL GENOMICS CONSORTIUM, SGC                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.R.WALKER,S.SCHUETZ,T.ANTOSHENKO,H.WU,G.BERNSTEIN,                   
AUTHOR   2 P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,          
AUTHOR   3 A.BOCHKAREV,A.N.PLOTNIKOV,STRUCTURAL GENOMICS CONSORTIUM             
AUTHOR   4 (SGC)                                                                
REVDAT   1   26-DEC-06 2OB0    0                                                
JRNL        AUTH   A.SCHUETZ,J.R.WALKER,T.ANTOSHENKO,H.WU,G.BERNSTEIN,          
JRNL        AUTH 2 P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,C.H.ARROWSMITH,              
JRNL        AUTH 3 A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV                        
JRNL        TITL   STRUCTURE OF HUMAN MAK3 HOMOLOG                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2OB0 A    2   169  UNP    Q9GZZ1   Q9GZZ1_HUMAN     2    169             
DBREF  2OB0 B    2   169  UNP    Q9GZZ1   Q9GZZ1_HUMAN     2    169             
DBREF  2OB0 C    2   169  UNP    Q9GZZ1   Q9GZZ1_HUMAN     2    169             
SEQRES   1 A  170  GLY SER LYS GLY SER ARG ILE GLU LEU GLY ASP VAL THR          
SEQRES   2 A  170  PRO HIS ASN ILE LYS GLN LEU LYS ARG LEU ASN GLN VAL          
SEQRES   3 A  170  ILE PHE PRO VAL SER TYR ASN ASP LYS PHE TYR LYS ASP          
SEQRES   4 A  170  VAL LEU GLU VAL GLY GLU LEU ALA LYS LEU ALA TYR PHE          
SEQRES   5 A  170  ASN ASP ILE ALA VAL GLY ALA VAL CYS CYS ARG VAL ASP          
SEQRES   6 A  170  HIS SER GLN ASN GLN LYS ARG LEU TYR ILE MSE THR LEU          
SEQRES   7 A  170  GLY CYS LEU ALA PRO TYR ARG ARG LEU GLY ILE GLY THR          
SEQRES   8 A  170  LYS MSE LEU ASN HIS VAL LEU ASN ILE CYS GLU LYS ASP          
SEQRES   9 A  170  GLY THR PHE ASP ASN ILE TYR LEU HIS VAL GLN ILE SER          
SEQRES  10 A  170  ASN GLU SER ALA ILE ASP PHE TYR ARG LYS PHE GLY PHE          
SEQRES  11 A  170  GLU ILE ILE GLU THR LYS LYS ASN TYR TYR LYS ARG ILE          
SEQRES  12 A  170  GLU PRO ALA ASP ALA HIS VAL LEU GLN LYS ASN LEU LYS          
SEQRES  13 A  170  VAL PRO SER GLY GLN ASN ALA ASP VAL GLN LYS THR ASP          
SEQRES  14 A  170  ASN                                                          
SEQRES   1 B  170  GLY SER LYS GLY SER ARG ILE GLU LEU GLY ASP VAL THR          
SEQRES   2 B  170  PRO HIS ASN ILE LYS GLN LEU LYS ARG LEU ASN GLN VAL          
SEQRES   3 B  170  ILE PHE PRO VAL SER TYR ASN ASP LYS PHE TYR LYS ASP          
SEQRES   4 B  170  VAL LEU GLU VAL GLY GLU LEU ALA LYS LEU ALA TYR PHE          
SEQRES   5 B  170  ASN ASP ILE ALA VAL GLY ALA VAL CYS CYS ARG VAL ASP          
SEQRES   6 B  170  HIS SER GLN ASN GLN LYS ARG LEU TYR ILE MSE THR LEU          
SEQRES   7 B  170  GLY CYS LEU ALA PRO TYR ARG ARG LEU GLY ILE GLY THR          
SEQRES   8 B  170  LYS MSE LEU ASN HIS VAL LEU ASN ILE CYS GLU LYS ASP          
SEQRES   9 B  170  GLY THR PHE ASP ASN ILE TYR LEU HIS VAL GLN ILE SER          
SEQRES  10 B  170  ASN GLU SER ALA ILE ASP PHE TYR ARG LYS PHE GLY PHE          
SEQRES  11 B  170  GLU ILE ILE GLU THR LYS LYS ASN TYR TYR LYS ARG ILE          
SEQRES  12 B  170  GLU PRO ALA ASP ALA HIS VAL LEU GLN LYS ASN LEU LYS          
SEQRES  13 B  170  VAL PRO SER GLY GLN ASN ALA ASP VAL GLN LYS THR ASP          
SEQRES  14 B  170  ASN                                                          
SEQRES   1 C  170  GLY SER LYS GLY SER ARG ILE GLU LEU GLY ASP VAL THR          
SEQRES   2 C  170  PRO HIS ASN ILE LYS GLN LEU LYS ARG LEU ASN GLN VAL          
SEQRES   3 C  170  ILE PHE PRO VAL SER TYR ASN ASP LYS PHE TYR LYS ASP          
SEQRES   4 C  170  VAL LEU GLU VAL GLY GLU LEU ALA LYS LEU ALA TYR PHE          
SEQRES   5 C  170  ASN ASP ILE ALA VAL GLY ALA VAL CYS CYS ARG VAL ASP          
SEQRES   6 C  170  HIS SER GLN ASN GLN LYS ARG LEU TYR ILE MSE THR LEU          
SEQRES   7 C  170  GLY CYS LEU ALA PRO TYR ARG ARG LEU GLY ILE GLY THR          
SEQRES   8 C  170  LYS MSE LEU ASN HIS VAL LEU ASN ILE CYS GLU LYS ASP          
SEQRES   9 C  170  GLY THR PHE ASP ASN ILE TYR LEU HIS VAL GLN ILE SER          
SEQRES  10 C  170  ASN GLU SER ALA ILE ASP PHE TYR ARG LYS PHE GLY PHE          
SEQRES  11 C  170  GLU ILE ILE GLU THR LYS LYS ASN TYR TYR LYS ARG ILE          
SEQRES  12 C  170  GLU PRO ALA ASP ALA HIS VAL LEU GLN LYS ASN LEU LYS          
SEQRES  13 C  170  VAL PRO SER GLY GLN ASN ALA ASP VAL GLN LYS THR ASP          
SEQRES  14 C  170  ASN                                                          
HET    MSE  A  75       8                                                       
HET    MSE  A  92       8                                                       
HET    MSE  B  75       8                                                       
HET    MSE  B  92       8                                                       
HET    MSE  C  75       8                                                       
HET    MSE  C  92       8                                                       
HET    ACO  A 201      51                                                       
HET    ACO  B 201      51                                                       
HET    ACO  C 201      51                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   4  ACO    3(C23 H38 N7 O17 P3 S)                                       
FORMUL   7  HOH   *331(H2 O)                                                    
CRYST1   47.523  103.324   67.328  90.00 106.79  90.00 P 1 21 1      6          
ATOM   2500  N   SER C   4     -35.186  40.552  36.155  1.00 71.95           N  
ATOM   2501  CA  SER C   4     -33.903  39.950  36.659  1.00 67.44           C  
ATOM   2502  C   SER C   4     -32.721  40.928  36.669  1.00 63.31           C  
ATOM   2503  O   SER C   4     -32.386  41.522  35.646  1.00 66.78           O  
ATOM   2504  CB  SER C   4     -33.564  38.678  35.875  1.00 68.43           C  
ATOM   2505  OG  SER C   4     -34.710  37.829  35.813  1.00 74.78           O  
ATOM   2506  N   ARG C   5     -32.131  41.120  37.843  1.00 55.32           N  
ATOM   2507  CA  ARG C   5     -31.049  42.086  38.045  1.00 52.37           C  
ATOM   2508  C   ARG C   5     -29.851  41.340  38.607  1.00 44.97           C  
ATOM   2509  O   ARG C   5     -29.958  40.676  39.642  1.00 45.08           O  
ATOM   2510  CB  ARG C   5     -31.442  43.181  39.049  1.00 52.09           C  
ATOM   2511  CG  ARG C   5     -32.820  43.780  38.868  1.00 63.39           C  
ATOM   2512  CD  ARG C   5     -33.224  44.660  40.056  1.00 66.79           C  
ATOM   2513  NE  ARG C   5     -33.473  43.908  41.292  1.00 71.35           N  
ATOM   2514  CZ  ARG C   5     -34.531  43.126  41.512  1.00 76.29           C  
ATOM   2515  NH1 ARG C   5     -35.455  42.944  40.571  1.00 79.90           N  
ATOM   2516  NH2 ARG C   5     -34.662  42.504  42.678  1.00 77.70           N  
ATOM   2517  N   ILE C   6     -28.715  41.442  37.924  1.00 41.04           N  
ATOM   2518  CA  ILE C   6     -27.474  40.879  38.446  1.00 39.77           C  
ATOM   2519  C   ILE C   6     -26.611  42.041  38.942  1.00 38.98           C  
ATOM   2520  O   ILE C   6     -26.383  43.001  38.202  1.00 42.39           O  
ATOM   2521  CB  ILE C   6     -26.754  40.006  37.374  1.00 41.26           C  
ATOM   2522  CG1 ILE C   6     -27.650  38.812  37.008  1.00 44.71           C  
ATOM   2523  CG2 ILE C   6     -25.382  39.528  37.882  1.00 40.88           C  
ATOM   2524  CD1 ILE C   6     -27.433  38.279  35.602  1.00 52.87           C  
ATOM   2525  N   GLU C   7     -26.150  41.961  40.187  1.00 38.17           N  
ATOM   2526  CA  GLU C   7     -25.388  43.056  40.811  1.00 40.56           C  
ATOM   2527  C   GLU C   7     -24.205  42.470  41.556  1.00 36.58           C  
ATOM   2528  O   GLU C   7     -24.279  41.342  41.977  1.00 32.98           O  
ATOM   2529  CB  GLU C   7     -26.270  43.806  41.809  1.00 41.76           C  
ATOM   2530  CG  GLU C   7     -27.396  44.643  41.182  1.00 51.01           C  
ATOM   2531  CD  GLU C   7     -28.401  45.141  42.221  1.00 56.49           C  
ATOM   2532  OE1 GLU C   7     -28.703  44.380  43.171  1.00 64.82           O  
ATOM   2533  OE2 GLU C   7     -28.895  46.286  42.092  1.00 66.33           O  
ATOM   2534  N   LEU C   8     -23.104  43.218  41.680  1.00 36.43           N  
ATOM   2535  CA  LEU C   8     -21.982  42.805  42.554  1.00 33.55           C  
ATOM   2536  C   LEU C   8     -22.027  43.697  43.802  1.00 34.51           C  
ATOM   2537  O   LEU C   8     -22.467  44.838  43.712  1.00 37.75           O  
ATOM   2538  CB  LEU C   8     -20.626  42.952  41.834  1.00 35.68           C  
ATOM   2539  CG  LEU C   8     -20.416  42.239  40.485  1.00 36.98           C  
ATOM   2540  CD1 LEU C   8     -19.006  42.401  39.964  1.00 36.63           C  
ATOM   2541  CD2 LEU C   8     -20.757  40.771  40.610  1.00 35.62           C  
ATOM   2542  N   GLY C   9     -21.624  43.166  44.964  1.00 33.21           N  
ATOM   2543  CA  GLY C   9     -21.510  43.978  46.184  1.00 34.56           C  
ATOM   2544  C   GLY C   9     -20.230  43.655  46.927  1.00 36.64           C  
ATOM   2545  O   GLY C   9     -19.585  42.639  46.636  1.00 34.07           O  
ATOM   2546  N   ASP C  10     -19.891  44.487  47.911  1.00 38.49           N  
ATOM   2547  CA  ASP C  10     -18.675  44.313  48.692  1.00 41.45           C  
ATOM   2548  C   ASP C  10     -18.788  43.155  49.666  1.00 39.82           C  
ATOM   2549  O   ASP C  10     -19.889  42.836  50.152  1.00 40.22           O  
ATOM   2550  CB  ASP C  10     -18.349  45.593  49.484  1.00 45.89           C  
ATOM   2551  CG  ASP C  10     -17.971  46.770  48.587  1.00 54.59           C  
ATOM   2552  OD1 ASP C  10     -17.690  46.579  47.380  1.00 56.58           O  
ATOM   2553  OD2 ASP C  10     -17.956  47.918  49.089  1.00 66.34           O  
ATOM   2554  N   VAL C  11     -17.637  42.552  49.971  1.00 38.33           N  
ATOM   2555  CA  VAL C  11     -17.540  41.582  51.060  1.00 39.61           C  
ATOM   2556  C   VAL C  11     -17.193  42.352  52.332  1.00 45.12           C  
ATOM   2557  O   VAL C  11     -16.258  43.149  52.340  1.00 46.12           O  
ATOM   2558  CB  VAL C  11     -16.474  40.495  50.773  1.00 37.62           C  
ATOM   2559  CG1 VAL C  11     -16.459  39.419  51.936  1.00 34.63           C  
ATOM   2560  CG2 VAL C  11     -16.777  39.820  49.442  1.00 35.15           C  
ATOM   2561  N   THR C  12     -17.945  42.114  53.402  1.00 44.43           N  
ATOM   2562  CA  THR C  12     -17.773  42.883  54.629  1.00 46.82           C  
ATOM   2563  C   THR C  12     -17.774  41.957  55.838  1.00 47.31           C  
ATOM   2564  O   THR C  12     -18.131  40.788  55.712  1.00 44.80           O  
ATOM   2565  CB  THR C  12     -18.922  43.913  54.800  1.00 51.18           C  
ATOM   2566  OG1 THR C  12     -20.161  43.217  54.982  1.00 56.07           O  
ATOM   2567  CG2 THR C  12     -19.036  44.827  53.569  1.00 50.42           C  
ATOM   2568  N   PRO C  13     -17.389  42.471  57.024  1.00 49.20           N  
ATOM   2569  CA  PRO C  13     -17.588  41.647  58.214  1.00 51.40           C  
ATOM   2570  C   PRO C  13     -19.038  41.151  58.334  1.00 52.17           C  
ATOM   2571  O   PRO C  13     -19.273  40.066  58.866  1.00 54.61           O  
ATOM   2572  CB  PRO C  13     -17.233  42.608  59.356  1.00 57.25           C  
ATOM   2573  CG  PRO C  13     -16.240  43.540  58.739  1.00 55.14           C  
ATOM   2574  CD  PRO C  13     -16.754  43.764  57.352  1.00 51.14           C  
ATOM   2575  N   HIS C  14     -19.991  41.920  57.813  1.00 50.79           N  
ATOM   2576  CA  HIS C  14     -21.408  41.570  57.934  1.00 54.25           C  
ATOM   2577  C   HIS C  14     -21.746  40.331  57.098  1.00 52.03           C  
ATOM   2578  O   HIS C  14     -22.534  39.491  57.506  1.00 52.59           O  
ATOM   2579  CB  HIS C  14     -22.293  42.763  57.543  1.00 58.03           C  
ATOM   2580  CG  HIS C  14     -23.746  42.581  57.866  1.00 66.94           C  
ATOM   2581  ND1 HIS C  14     -24.288  42.928  59.085  1.00 76.88           N  
ATOM   2582  CD2 HIS C  14     -24.772  42.104  57.120  1.00 70.83           C  
ATOM   2583  CE1 HIS C  14     -25.584  42.663  59.081  1.00 82.02           C  
ATOM   2584  NE2 HIS C  14     -25.902  42.162  57.899  1.00 78.67           N  
ATOM   2585  N   ASN C  15     -21.134  40.190  55.934  1.00 46.04           N  
ATOM   2586  CA  ASN C  15     -21.526  39.086  55.069  1.00 46.24           C  
ATOM   2587  C   ASN C  15     -20.431  38.046  54.771  1.00 46.46           C  
ATOM   2588  O   ASN C  15     -20.631  37.167  53.929  1.00 43.67           O  
ATOM   2589  CB  ASN C  15     -22.076  39.634  53.756  1.00 45.95           C  
ATOM   2590  CG  ASN C  15     -21.057  40.483  53.009  1.00 46.06           C  
ATOM   2591  OD1 ASN C  15     -19.855  40.257  53.116  1.00 44.08           O  
ATOM   2592  ND2 ASN C  15     -21.538  41.449  52.231  1.00 45.41           N  
ATOM   2593  N   ILE C  16     -19.285  38.145  55.450  1.00 47.74           N  
ATOM   2594  CA  ILE C  16     -18.191  37.192  55.254  1.00 43.65           C  
ATOM   2595  C   ILE C  16     -18.643  35.747  55.513  1.00 45.14           C  
ATOM   2596  O   ILE C  16     -18.213  34.818  54.814  1.00 44.60           O  
ATOM   2597  CB  ILE C  16     -16.941  37.542  56.125  1.00 45.31           C  
ATOM   2598  CG1 ILE C  16     -15.722  36.701  55.705  1.00 44.98           C  
ATOM   2599  CG2 ILE C  16     -17.231  37.344  57.626  1.00 47.62           C  
ATOM   2600  CD1 ILE C  16     -15.171  37.044  54.340  1.00 45.40           C  
ATOM   2601  N   LYS C  17     -19.511  35.553  56.505  1.00 47.55           N  
ATOM   2602  CA  LYS C  17     -20.001  34.211  56.810  1.00 49.40           C  
ATOM   2603  C   LYS C  17     -20.836  33.643  55.657  1.00 44.78           C  
ATOM   2604  O   LYS C  17     -20.761  32.448  55.361  1.00 45.03           O  
ATOM   2605  CB  LYS C  17     -20.806  34.189  58.105  1.00 52.77           C  
ATOM   2606  CG  LYS C  17     -19.979  34.372  59.405  1.00 61.08           C  
ATOM   2607  N   GLN C  18     -21.635  34.504  55.024  1.00 44.67           N  
ATOM   2608  CA  GLN C  18     -22.343  34.168  53.778  1.00 43.00           C  
ATOM   2609  C   GLN C  18     -21.411  33.792  52.627  1.00 41.51           C  
ATOM   2610  O   GLN C  18     -21.672  32.841  51.876  1.00 38.78           O  
ATOM   2611  CB  GLN C  18     -23.201  35.344  53.345  1.00 43.71           C  
ATOM   2612  CG  GLN C  18     -24.138  35.041  52.196  1.00 44.46           C  
ATOM   2613  CD  GLN C  18     -25.213  36.086  52.060  1.00 55.37           C  
ATOM   2614  OE1 GLN C  18     -24.952  37.294  52.181  1.00 55.79           O  
ATOM   2615  NE2 GLN C  18     -26.440  35.635  51.813  1.00 57.76           N  
ATOM   2616  N   LEU C  19     -20.367  34.591  52.433  1.00 39.25           N  
ATOM   2617  CA  LEU C  19     -19.359  34.244  51.455  1.00 36.83           C  
ATOM   2618  C   LEU C  19     -18.864  32.835  51.712  1.00 38.32           C  
ATOM   2619  O   LEU C  19     -18.824  32.042  50.796  1.00 35.85           O  
ATOM   2620  CB  LEU C  19     -18.185  35.208  51.508  1.00 37.68           C  
ATOM   2621  CG  LEU C  19     -17.064  34.824  50.546  1.00 37.31           C  
ATOM   2622  CD1 LEU C  19     -17.535  35.151  49.148  1.00 43.44           C  
ATOM   2623  CD2 LEU C  19     -15.848  35.632  50.932  1.00 44.58           C  
ATOM   2624  N   LYS C  20     -18.475  32.526  52.948  1.00 40.42           N  
ATOM   2625  CA  LYS C  20     -17.990  31.172  53.261  1.00 42.11           C  
ATOM   2626  C   LYS C  20     -19.049  30.114  52.955  1.00 40.89           C  
ATOM   2627  O   LYS C  20     -18.723  29.073  52.390  1.00 40.83           O  
ATOM   2628  CB  LYS C  20     -17.533  31.031  54.731  1.00 44.14           C  
ATOM   2629  CG  LYS C  20     -17.024  29.616  55.068  1.00 47.95           C  
ATOM   2630  CD  LYS C  20     -16.104  29.568  56.294  1.00 49.49           C  
ATOM   2631  CE  LYS C  20     -15.571  28.142  56.505  1.00 53.62           C  
ATOM   2632  NZ  LYS C  20     -14.881  27.964  57.810  1.00 57.59           N  
ATOM   2633  N   ARG C  21     -20.304  30.362  53.328  1.00 41.52           N  
ATOM   2634  CA  ARG C  21     -21.368  29.399  53.013  1.00 40.91           C  
ATOM   2635  C   ARG C  21     -21.506  29.132  51.523  1.00 40.20           C  
ATOM   2636  O   ARG C  21     -21.720  27.997  51.122  1.00 42.16           O  
ATOM   2637  CB  ARG C  21     -22.726  29.830  53.562  1.00 44.36           C  
ATOM   2638  CG  ARG C  21     -22.805  29.757  55.053  1.00 47.63           C  
ATOM   2639  CD  ARG C  21     -24.262  29.859  55.555  1.00 55.68           C  
ATOM   2640  NE  ARG C  21     -24.829  31.187  55.297  1.00 59.06           N  
ATOM   2641  CZ  ARG C  21     -24.798  32.206  56.154  1.00 62.34           C  
ATOM   2642  NH1 ARG C  21     -24.245  32.064  57.359  1.00 69.16           N  
ATOM   2643  NH2 ARG C  21     -25.347  33.364  55.817  1.00 59.41           N  
ATOM   2644  N   LEU C  22     -21.400  30.179  50.711  1.00 38.72           N  
ATOM   2645  CA  LEU C  22     -21.455  30.026  49.269  1.00 37.60           C  
ATOM   2646  C   LEU C  22     -20.235  29.253  48.767  1.00 36.83           C  
ATOM   2647  O   LEU C  22     -20.367  28.343  47.959  1.00 34.70           O  
ATOM   2648  CB  LEU C  22     -21.525  31.405  48.582  1.00 38.72           C  
ATOM   2649  CG  LEU C  22     -22.859  32.158  48.660  1.00 38.39           C  
ATOM   2650  CD1 LEU C  22     -22.628  33.641  48.325  1.00 38.75           C  
ATOM   2651  CD2 LEU C  22     -23.888  31.546  47.706  1.00 42.38           C  
ATOM   2652  N   ASN C  23     -19.051  29.603  49.262  1.00 35.99           N  
ATOM   2653  CA  ASN C  23     -17.817  28.933  48.820  1.00 36.83           C  
ATOM   2654  C   ASN C  23     -17.847  27.434  49.113  1.00 38.20           C  
ATOM   2655  O   ASN C  23     -17.398  26.623  48.310  1.00 37.39           O  
ATOM   2656  CB  ASN C  23     -16.578  29.562  49.480  1.00 38.04           C  
ATOM   2657  CG  ASN C  23     -16.073  30.821  48.750  1.00 40.70           C  
ATOM   2658  OD1 ASN C  23     -15.158  31.509  49.240  1.00 47.46           O  
ATOM   2659  ND2 ASN C  23     -16.656  31.130  47.600  1.00 37.15           N  
ATOM   2660  N   GLN C  24     -18.384  27.078  50.276  1.00 38.93           N  
ATOM   2661  CA  GLN C  24     -18.393  25.692  50.739  1.00 42.11           C  
ATOM   2662  C   GLN C  24     -19.341  24.856  49.900  1.00 41.93           C  
ATOM   2663  O   GLN C  24     -19.176  23.643  49.789  1.00 42.48           O  
ATOM   2664  CB  GLN C  24     -18.822  25.631  52.198  1.00 44.31           C  
ATOM   2665  CG  GLN C  24     -17.805  26.227  53.195  1.00 50.39           C  
ATOM   2666  CD  GLN C  24     -16.599  25.323  53.464  1.00 60.53           C  
ATOM   2667  OE1 GLN C  24     -16.710  24.086  53.446  1.00 67.00           O  
ATOM   2668  NE2 GLN C  24     -15.446  25.937  53.753  1.00 53.59           N  
ATOM   2669  N   VAL C  25     -20.364  25.497  49.339  1.00 40.04           N  
ATOM   2670  CA  VAL C  25     -21.270  24.787  48.434  1.00 41.69           C  
ATOM   2671  C   VAL C  25     -20.709  24.693  47.011  1.00 39.62           C  
ATOM   2672  O   VAL C  25     -20.859  23.658  46.347  1.00 40.23           O  
ATOM   2673  CB  VAL C  25     -22.668  25.435  48.401  1.00 41.84           C  
ATOM   2674  CG1 VAL C  25     -23.487  24.884  47.232  1.00 43.48           C  
ATOM   2675  CG2 VAL C  25     -23.379  25.175  49.722  1.00 43.95           C  
ATOM   2676  N   ILE C  26     -20.088  25.773  46.538  1.00 37.11           N  
ATOM   2677  CA  ILE C  26     -19.711  25.897  45.133  1.00 36.98           C  
ATOM   2678  C   ILE C  26     -18.388  25.191  44.799  1.00 39.28           C  
ATOM   2679  O   ILE C  26     -18.263  24.594  43.741  1.00 37.31           O  
ATOM   2680  CB  ILE C  26     -19.655  27.383  44.681  1.00 35.47           C  
ATOM   2681  CG1 ILE C  26     -21.046  28.032  44.695  1.00 34.01           C  
ATOM   2682  CG2 ILE C  26     -19.098  27.505  43.280  1.00 37.69           C  
ATOM   2683  CD1 ILE C  26     -21.011  29.566  44.875  1.00 35.41           C  
ATOM   2684  N   PHE C  27     -17.422  25.231  45.715  1.00 39.25           N  
ATOM   2685  CA  PHE C  27     -16.075  24.745  45.430  1.00 40.89           C  
ATOM   2686  C   PHE C  27     -15.770  23.479  46.241  1.00 43.97           C  
ATOM   2687  O   PHE C  27     -16.193  23.377  47.393  1.00 44.36           O  
ATOM   2688  CB  PHE C  27     -15.032  25.846  45.696  1.00 38.94           C  
ATOM   2689  CG  PHE C  27     -15.273  27.088  44.886  1.00 39.05           C  
ATOM   2690  CD1 PHE C  27     -14.907  27.144  43.548  1.00 41.43           C  
ATOM   2691  CD2 PHE C  27     -15.931  28.168  45.450  1.00 40.37           C  
ATOM   2692  CE1 PHE C  27     -15.177  28.292  42.788  1.00 38.85           C  
ATOM   2693  CE2 PHE C  27     -16.213  29.298  44.725  1.00 38.08           C  
ATOM   2694  CZ  PHE C  27     -15.845  29.365  43.381  1.00 40.70           C  
ATOM   2695  N   PRO C  28     -15.053  22.509  45.642  1.00 48.06           N  
ATOM   2696  CA  PRO C  28     -14.820  21.205  46.291  1.00 52.26           C  
ATOM   2697  C   PRO C  28     -13.716  21.190  47.336  1.00 53.61           C  
ATOM   2698  O   PRO C  28     -13.420  20.130  47.884  1.00 56.96           O  
ATOM   2699  CB  PRO C  28     -14.411  20.311  45.117  1.00 56.53           C  
ATOM   2700  CG  PRO C  28     -13.693  21.255  44.197  1.00 55.39           C  
ATOM   2701  CD  PRO C  28     -14.460  22.554  44.290  1.00 50.22           C  
ATOM   2702  N   VAL C  29     -13.101  22.339  47.596  1.00 51.74           N  
ATOM   2703  CA  VAL C  29     -12.096  22.472  48.660  1.00 53.49           C  
ATOM   2704  C   VAL C  29     -12.491  23.542  49.695  1.00 51.92           C  
ATOM   2705  O   VAL C  29     -13.063  24.575  49.345  1.00 52.27           O  
ATOM   2706  CB  VAL C  29     -10.689  22.801  48.109  1.00 53.42           C  
ATOM   2707  CG1 VAL C  29     -10.115  21.625  47.305  1.00 55.73           C  
ATOM   2708  CG2 VAL C  29     -10.708  24.075  47.294  1.00 54.04           C  
ATOM   2709  N   SER C  30     -12.174  23.288  50.963  1.00 52.38           N  
ATOM   2710  CA  SER C  30     -12.452  24.234  52.035  1.00 50.77           C  
ATOM   2711  C   SER C  30     -11.224  25.099  52.291  1.00 49.73           C  
ATOM   2712  O   SER C  30     -10.109  24.586  52.457  1.00 51.72           O  
ATOM   2713  CB  SER C  30     -12.855  23.499  53.319  1.00 55.07           C  
ATOM   2714  OG  SER C  30     -13.916  22.591  53.061  1.00 61.63           O  
ATOM   2715  N   TYR C  31     -11.438  26.406  52.348  1.00 44.17           N  
ATOM   2716  CA  TYR C  31     -10.360  27.353  52.591  1.00 43.00           C  
ATOM   2717  C   TYR C  31     -10.231  27.671  54.066  1.00 42.26           C  
ATOM   2718  O   TYR C  31     -11.227  27.682  54.795  1.00 42.17           O  
ATOM   2719  CB  TYR C  31     -10.568  28.615  51.747  1.00 42.44           C  
ATOM   2720  CG  TYR C  31     -10.555  28.297  50.263  1.00 43.94           C  
ATOM   2721  CD1 TYR C  31      -9.353  28.086  49.595  1.00 43.12           C  
ATOM   2722  CD2 TYR C  31     -11.744  28.145  49.547  1.00 44.25           C  
ATOM   2723  CE1 TYR C  31      -9.325  27.766  48.255  1.00 42.96           C  
ATOM   2724  CE2 TYR C  31     -11.724  27.808  48.187  1.00 46.05           C  
ATOM   2725  CZ  TYR C  31     -10.500  27.622  47.558  1.00 45.08           C  
ATOM   2726  OH  TYR C  31     -10.428  27.299  46.221  1.00 46.32           O  
ATOM   2727  N   ASN C  32      -9.000  27.942  54.490  1.00 43.02           N  
ATOM   2728  CA  ASN C  32      -8.691  28.202  55.884  1.00 43.28           C  
ATOM   2729  C   ASN C  32      -9.154  29.574  56.326  1.00 43.34           C  
ATOM   2730  O   ASN C  32      -9.594  30.375  55.511  1.00 40.03           O  
ATOM   2731  CB  ASN C  32      -7.203  27.948  56.212  1.00 45.11           C  
ATOM   2732  CG  ASN C  32      -6.227  28.878  55.483  1.00 45.92           C  
ATOM   2733  OD1 ASN C  32      -6.606  29.865  54.863  1.00 46.66           O  
ATOM   2734  ND2 ASN C  32      -4.932  28.556  55.591  1.00 44.26           N  
ATOM   2735  N   ASP C  33      -9.076  29.847  57.625  1.00 43.05           N  
ATOM   2736  CA  ASP C  33      -9.564  31.123  58.134  1.00 46.63           C  
ATOM   2737  C   ASP C  33      -8.773  32.305  57.597  1.00 44.78           C  
ATOM   2738  O   ASP C  33      -9.325  33.402  57.435  1.00 45.96           O  
ATOM   2739  CB  ASP C  33      -9.577  31.126  59.661  1.00 49.55           C  
ATOM   2740  CG  ASP C  33     -10.669  30.226  60.232  1.00 59.21           C  
ATOM   2741  OD1 ASP C  33     -11.481  29.685  59.441  1.00 61.69           O  
ATOM   2742  OD2 ASP C  33     -10.722  30.056  61.473  1.00 65.95           O  
ATOM   2743  N   LYS C  34      -7.498  32.087  57.282  1.00 43.24           N  
ATOM   2744  CA  LYS C  34      -6.685  33.171  56.719  1.00 43.13           C  
ATOM   2745  C   LYS C  34      -7.207  33.602  55.353  1.00 44.26           C  
ATOM   2746  O   LYS C  34      -7.107  34.779  54.988  1.00 44.56           O  
ATOM   2747  CB  LYS C  34      -5.217  32.777  56.637  1.00 43.66           C  
ATOM   2748  CG  LYS C  34      -4.286  33.920  56.197  1.00 49.31           C  
ATOM   2749  CD  LYS C  34      -2.841  33.493  56.181  1.00 50.54           C  
ATOM   2750  CE  LYS C  34      -1.903  34.676  55.983  1.00 52.99           C  
ATOM   2751  NZ  LYS C  34      -1.920  35.178  54.573  1.00 50.17           N  
ATOM   2752  N   PHE C  35      -7.756  32.659  54.583  1.00 41.58           N  
ATOM   2753  CA  PHE C  35      -8.402  33.026  53.308  1.00 40.57           C  
ATOM   2754  C   PHE C  35      -9.457  34.100  53.573  1.00 39.08           C  
ATOM   2755  O   PHE C  35      -9.466  35.121  52.916  1.00 41.34           O  
ATOM   2756  CB  PHE C  35      -9.019  31.780  52.640  1.00 39.93           C  
ATOM   2757  CG  PHE C  35      -9.814  32.065  51.380  1.00 41.60           C  
ATOM   2758  CD1 PHE C  35      -9.231  31.901  50.136  1.00 41.70           C  
ATOM   2759  CD2 PHE C  35     -11.146  32.469  51.449  1.00 40.94           C  
ATOM   2760  CE1 PHE C  35      -9.963  32.137  48.973  1.00 44.09           C  
ATOM   2761  CE2 PHE C  35     -11.894  32.718  50.283  1.00 43.79           C  
ATOM   2762  CZ  PHE C  35     -11.293  32.559  49.051  1.00 43.57           C  
ATOM   2763  N   TYR C  36     -10.321  33.881  54.566  1.00 40.43           N  
ATOM   2764  CA  TYR C  36     -11.418  34.819  54.830  1.00 41.14           C  
ATOM   2765  C   TYR C  36     -10.959  36.120  55.463  1.00 43.94           C  
ATOM   2766  O   TYR C  36     -11.467  37.178  55.107  1.00 45.09           O  
ATOM   2767  CB  TYR C  36     -12.574  34.134  55.578  1.00 40.75           C  
ATOM   2768  CG  TYR C  36     -13.142  33.059  54.712  1.00 40.60           C  
ATOM   2769  CD1 TYR C  36     -13.908  33.405  53.584  1.00 42.03           C  
ATOM   2770  CD2 TYR C  36     -12.833  31.709  54.918  1.00 38.56           C  
ATOM   2771  CE1 TYR C  36     -14.409  32.459  52.731  1.00 38.16           C  
ATOM   2772  CE2 TYR C  36     -13.344  30.717  54.038  1.00 37.92           C  
ATOM   2773  CZ  TYR C  36     -14.133  31.119  52.945  1.00 40.72           C  
ATOM   2774  OH  TYR C  36     -14.649  30.214  52.027  1.00 39.19           O  
ATOM   2775  N   LYS C  37      -9.985  36.042  56.372  1.00 45.00           N  
ATOM   2776  CA  LYS C  37      -9.297  37.231  56.895  1.00 47.09           C  
ATOM   2777  C   LYS C  37      -8.777  38.109  55.759  1.00 45.91           C  
ATOM   2778  O   LYS C  37      -9.032  39.315  55.741  1.00 47.16           O  
ATOM   2779  CB  LYS C  37      -8.128  36.817  57.805  1.00 48.10           C  
ATOM   2780  CG  LYS C  37      -7.300  37.980  58.331  1.00 52.78           C  
ATOM   2781  CD  LYS C  37      -6.058  37.476  59.066  1.00 58.31           C  
ATOM   2782  CE  LYS C  37      -5.288  38.598  59.716  1.00 66.71           C  
ATOM   2783  NZ  LYS C  37      -5.903  38.960  61.014  1.00 78.21           N  
ATOM   2784  N   ASP C  38      -8.068  37.498  54.808  1.00 45.29           N  
ATOM   2785  CA  ASP C  38      -7.393  38.239  53.751  1.00 46.76           C  
ATOM   2786  C   ASP C  38      -8.343  38.851  52.692  1.00 44.66           C  
ATOM   2787  O   ASP C  38      -8.052  39.932  52.167  1.00 42.89           O  
ATOM   2788  CB  ASP C  38      -6.307  37.391  53.078  1.00 48.78           C  
ATOM   2789  CG  ASP C  38      -5.105  37.116  53.988  1.00 57.25           C  
ATOM   2790  OD1 ASP C  38      -4.977  37.710  55.097  1.00 59.37           O  
ATOM   2791  OD2 ASP C  38      -4.264  36.291  53.576  1.00 62.80           O  
ATOM   2792  N   VAL C  39      -9.464  38.192  52.391  1.00 43.69           N  
ATOM   2793  CA  VAL C  39     -10.444  38.789  51.455  1.00 41.96           C  
ATOM   2794  C   VAL C  39     -11.083  40.055  52.011  1.00 44.27           C  
ATOM   2795  O   VAL C  39     -11.493  40.934  51.256  1.00 44.64           O  
ATOM   2796  CB  VAL C  39     -11.569  37.827  50.967  1.00 43.33           C  
ATOM   2797  CG1 VAL C  39     -11.007  36.506  50.462  1.00 46.73           C  
ATOM   2798  CG2 VAL C  39     -12.587  37.615  52.014  1.00 49.26           C  
ATOM   2799  N   LEU C  40     -11.179  40.141  53.333  1.00 44.66           N  
ATOM   2800  CA  LEU C  40     -11.709  41.340  53.998  1.00 49.63           C  
ATOM   2801  C   LEU C  40     -10.792  42.549  53.841  1.00 50.80           C  
ATOM   2802  O   LEU C  40     -11.187  43.673  54.137  1.00 54.01           O  
ATOM   2803  CB  LEU C  40     -11.945  41.062  55.476  1.00 50.46           C  
ATOM   2804  CG  LEU C  40     -13.185  40.213  55.738  1.00 54.30           C  
ATOM   2805  CD1 LEU C  40     -13.327  39.946  57.217  1.00 56.09           C  
ATOM   2806  CD2 LEU C  40     -14.404  40.938  55.198  1.00 55.14           C  
ATOM   2807  N   GLU C  41      -9.574  42.313  53.355  1.00 50.55           N  
ATOM   2808  CA  GLU C  41      -8.583  43.371  53.235  1.00 52.72           C  
ATOM   2809  C   GLU C  41      -8.146  43.609  51.794  1.00 50.92           C  
ATOM   2810  O   GLU C  41      -7.274  44.434  51.547  1.00 53.53           O  
ATOM   2811  CB  GLU C  41      -7.362  43.042  54.104  1.00 55.90           C  
ATOM   2812  CG  GLU C  41      -7.658  42.981  55.597  1.00 64.92           C  
ATOM   2813  CD  GLU C  41      -7.981  44.350  56.176  1.00 75.46           C  
ATOM   2814  OE1 GLU C  41      -7.066  45.206  56.239  1.00 82.23           O  
ATOM   2815  OE2 GLU C  41      -9.148  44.573  56.576  1.00 78.55           O  
ATOM   2816  N   VAL C  42      -8.749  42.899  50.844  1.00 46.60           N  
ATOM   2817  CA  VAL C  42      -8.295  42.956  49.452  1.00 46.05           C  
ATOM   2818  C   VAL C  42      -9.119  43.932  48.576  1.00 45.76           C  
ATOM   2819  O   VAL C  42      -8.876  44.058  47.370  1.00 46.79           O  
ATOM   2820  CB  VAL C  42      -8.200  41.529  48.851  1.00 42.10           C  
ATOM   2821  CG1 VAL C  42      -9.568  41.013  48.403  1.00 41.23           C  
ATOM   2822  CG2 VAL C  42      -7.202  41.496  47.720  1.00 46.85           C  
ATOM   2823  N   GLY C  43     -10.069  44.640  49.191  1.00 46.17           N  
ATOM   2824  CA  GLY C  43     -10.864  45.655  48.484  1.00 45.83           C  
ATOM   2825  C   GLY C  43     -11.696  45.084  47.346  1.00 42.08           C  
ATOM   2826  O   GLY C  43     -12.310  44.024  47.499  1.00 39.48           O  
ATOM   2827  N   GLU C  44     -11.695  45.781  46.210  1.00 40.31           N  
ATOM   2828  CA  GLU C  44     -12.515  45.430  45.044  1.00 39.86           C  
ATOM   2829  C   GLU C  44     -12.189  44.076  44.418  1.00 37.13           C  
ATOM   2830  O   GLU C  44     -12.985  43.541  43.622  1.00 36.26           O  
ATOM   2831  CB  GLU C  44     -12.466  46.540  44.001  1.00 41.05           C  
ATOM   2832  CG  GLU C  44     -13.168  47.843  44.429  1.00 49.12           C  
ATOM   2833  CD  GLU C  44     -14.702  47.818  44.259  1.00 58.03           C  
ATOM   2834  OE1 GLU C  44     -15.243  46.980  43.505  1.00 58.96           O  
ATOM   2835  OE2 GLU C  44     -15.380  48.665  44.876  1.00 59.47           O  
ATOM   2836  N   LEU C  45     -11.068  43.471  44.831  1.00 37.57           N  
ATOM   2837  CA  LEU C  45     -10.701  42.129  44.316  1.00 35.90           C  
ATOM   2838  C   LEU C  45     -11.518  40.992  44.910  1.00 35.91           C  
ATOM   2839  O   LEU C  45     -11.299  39.833  44.555  1.00 36.62           O  
ATOM   2840  CB  LEU C  45      -9.210  41.846  44.498  1.00 36.73           C  
ATOM   2841  CG  LEU C  45      -8.266  42.640  43.616  1.00 44.71           C  
ATOM   2842  CD1 LEU C  45      -6.880  42.131  43.929  1.00 44.64           C  
ATOM   2843  CD2 LEU C  45      -8.641  42.418  42.157  1.00 43.12           C  
ATOM   2844  N   ALA C  46     -12.453  41.311  45.810  1.00 38.22           N  
ATOM   2845  CA  ALA C  46     -13.441  40.319  46.234  1.00 37.09           C  
ATOM   2846  C   ALA C  46     -14.830  40.922  46.182  1.00 34.67           C  
ATOM   2847  O   ALA C  46     -15.036  42.017  46.697  1.00 34.24           O  
ATOM   2848  CB  ALA C  46     -13.144  39.799  47.650  1.00 37.75           C  
ATOM   2849  N   LYS C  47     -15.779  40.193  45.594  1.00 32.37           N  
ATOM   2850  CA  LYS C  47     -17.157  40.639  45.520  1.00 31.39           C  
ATOM   2851  C   LYS C  47     -18.121  39.463  45.694  1.00 31.16           C  
ATOM   2852  O   LYS C  47     -17.796  38.341  45.252  1.00 32.62           O  
ATOM   2853  CB  LYS C  47     -17.459  41.202  44.140  1.00 31.87           C  
ATOM   2854  CG  LYS C  47     -16.603  42.386  43.710  1.00 31.46           C  
ATOM   2855  CD  LYS C  47     -16.737  43.578  44.638  1.00 41.67           C  
ATOM   2856  CE  LYS C  47     -17.752  44.542  44.117  1.00 43.72           C  
ATOM   2857  NZ  LYS C  47     -17.532  45.888  44.744  1.00 48.74           N  
ATOM   2858  N   LEU C  48     -19.312  39.756  46.231  1.00 31.39           N  
ATOM   2859  CA  LEU C  48     -20.457  38.837  46.180  1.00 31.82           C  
ATOM   2860  C   LEU C  48     -21.285  39.187  44.961  1.00 32.82           C  
ATOM   2861  O   LEU C  48     -21.386  40.353  44.606  1.00 33.26           O  
ATOM   2862  CB  LEU C  48     -21.322  38.971  47.449  1.00 32.71           C  
ATOM   2863  CG  LEU C  48     -20.632  38.299  48.632  1.00 39.25           C  
ATOM   2864  CD1 LEU C  48     -21.051  38.977  49.907  1.00 41.20           C  
ATOM   2865  CD2 LEU C  48     -20.985  36.831  48.658  1.00 46.24           C  
ATOM   2866  N   ALA C  49     -21.855  38.182  44.309  1.00 31.61           N  
ATOM   2867  CA  ALA C  49     -22.751  38.399  43.190  1.00 31.07           C  
ATOM   2868  C   ALA C  49     -24.182  38.118  43.629  1.00 34.72           C  
ATOM   2869  O   ALA C  49     -24.462  37.115  44.328  1.00 35.38           O  
ATOM   2870  CB  ALA C  49     -22.399  37.482  42.027  1.00 31.46           C  
ATOM   2871  N   TYR C  50     -25.083  38.998  43.205  1.00 34.27           N  
ATOM   2872  CA  TYR C  50     -26.498  38.894  43.561  1.00 34.57           C  
ATOM   2873  C   TYR C  50     -27.367  38.747  42.329  1.00 36.33           C  
ATOM   2874  O   TYR C  50     -27.116  39.365  41.290  1.00 34.36           O  
ATOM   2875  CB  TYR C  50     -26.951  40.131  44.348  1.00 35.44           C  
ATOM   2876  CG  TYR C  50     -26.206  40.314  45.626  1.00 35.98           C  
ATOM   2877  CD1 TYR C  50     -26.735  39.841  46.855  1.00 36.65           C  
ATOM   2878  CD2 TYR C  50     -24.960  40.976  45.640  1.00 35.75           C  
ATOM   2879  CE1 TYR C  50     -26.020  40.015  48.040  1.00 40.64           C  
ATOM   2880  CE2 TYR C  50     -24.245  41.141  46.823  1.00 40.57           C  
ATOM   2881  CZ  TYR C  50     -24.771  40.659  48.010  1.00 39.66           C  
ATOM   2882  OH  TYR C  50     -24.045  40.836  49.172  1.00 42.53           O  
ATOM   2883  N   PHE C  51     -28.383  37.911  42.461  1.00 34.24           N  
ATOM   2884  CA  PHE C  51     -29.382  37.767  41.418  1.00 34.97           C  
ATOM   2885  C   PHE C  51     -30.711  38.135  42.056  1.00 36.02           C  
ATOM   2886  O   PHE C  51     -31.171  37.450  42.986  1.00 33.75           O  
ATOM   2887  CB  PHE C  51     -29.419  36.326  40.928  1.00 36.07           C  
ATOM   2888  CG  PHE C  51     -30.493  36.076  39.912  1.00 40.12           C  
ATOM   2889  CD1 PHE C  51     -30.242  36.299  38.564  1.00 40.41           C  
ATOM   2890  CD2 PHE C  51     -31.767  35.690  40.307  1.00 39.75           C  
ATOM   2891  CE1 PHE C  51     -31.272  36.084  37.612  1.00 41.20           C  
ATOM   2892  CE2 PHE C  51     -32.791  35.481  39.370  1.00 44.25           C  
ATOM   2893  CZ  PHE C  51     -32.529  35.690  38.016  1.00 39.98           C  
ATOM   2894  N   ASN C  52     -31.333  39.212  41.582  1.00 36.46           N  
ATOM   2895  CA  ASN C  52     -32.540  39.746  42.228  1.00 39.14           C  
ATOM   2896  C   ASN C  52     -32.409  39.825  43.738  1.00 40.88           C  
ATOM   2897  O   ASN C  52     -33.314  39.391  44.470  1.00 40.56           O  
ATOM   2898  CB  ASN C  52     -33.808  38.952  41.857  1.00 41.01           C  
ATOM   2899  CG  ASN C  52     -34.155  39.067  40.403  1.00 45.46           C  
ATOM   2900  OD1 ASN C  52     -33.611  39.915  39.710  1.00 47.47           O  
ATOM   2901  ND2 ASN C  52     -35.069  38.207  39.921  1.00 47.14           N  
ATOM   2902  N   ASP C  53     -31.262  40.342  44.189  1.00 41.49           N  
ATOM   2903  CA  ASP C  53     -31.011  40.628  45.604  1.00 42.50           C  
ATOM   2904  C   ASP C  53     -30.670  39.395  46.451  1.00 42.01           C  
ATOM   2905  O   ASP C  53     -30.507  39.509  47.657  1.00 43.10           O  
ATOM   2906  CB  ASP C  53     -32.194  41.408  46.219  1.00 47.24           C  
ATOM   2907  CG  ASP C  53     -32.489  42.713  45.483  1.00 54.18           C  
ATOM   2908  OD1 ASP C  53     -31.532  43.460  45.165  1.00 61.95           O  
ATOM   2909  OD2 ASP C  53     -33.675  43.002  45.219  1.00 62.24           O  
ATOM   2910  N   ILE C  54     -30.537  38.226  45.813  1.00 38.99           N  
ATOM   2911  CA  ILE C  54     -30.151  36.987  46.495  1.00 34.86           C  
ATOM   2912  C   ILE C  54     -28.677  36.746  46.237  1.00 33.72           C  
ATOM   2913  O   ILE C  54     -28.246  36.814  45.096  1.00 32.33           O  
ATOM   2914  CB  ILE C  54     -30.948  35.774  45.933  1.00 34.90           C  
ATOM   2915  CG1 ILE C  54     -32.449  35.985  46.142  1.00 38.84           C  
ATOM   2916  CG2 ILE C  54     -30.492  34.455  46.607  1.00 34.83           C  
ATOM   2917  CD1 ILE C  54     -33.275  35.311  45.057  1.00 41.53           C  
ATOM   2918  N   ALA C  55     -27.892  36.466  47.274  1.00 33.76           N  
ATOM   2919  CA  ALA C  55     -26.459  36.201  47.075  1.00 33.64           C  
ATOM   2920  C   ALA C  55     -26.293  34.805  46.490  1.00 33.69           C  
ATOM   2921  O   ALA C  55     -26.730  33.808  47.093  1.00 35.57           O  
ATOM   2922  CB  ALA C  55     -25.685  36.350  48.366  1.00 36.43           C  
ATOM   2923  N   VAL C  56     -25.714  34.723  45.293  1.00 31.64           N  
ATOM   2924  CA  VAL C  56     -25.623  33.443  44.595  1.00 31.55           C  
ATOM   2925  C   VAL C  56     -24.228  33.141  44.062  1.00 33.24           C  
ATOM   2926  O   VAL C  56     -24.022  32.119  43.433  1.00 32.44           O  
ATOM   2927  CB  VAL C  56     -26.614  33.338  43.411  1.00 33.27           C  
ATOM   2928  CG1 VAL C  56     -28.046  33.486  43.910  1.00 32.52           C  
ATOM   2929  CG2 VAL C  56     -26.300  34.380  42.311  1.00 33.31           C  
ATOM   2930  N   GLY C  57     -23.284  34.029  44.279  1.00 31.75           N  
ATOM   2931  CA  GLY C  57     -21.941  33.727  43.813  1.00 32.84           C  
ATOM   2932  C   GLY C  57     -20.936  34.655  44.418  1.00 32.96           C  
ATOM   2933  O   GLY C  57     -21.279  35.576  45.183  1.00 30.81           O  
ATOM   2934  N   ALA C  58     -19.666  34.426  44.089  1.00 29.32           N  
ATOM   2935  CA  ALA C  58     -18.631  35.332  44.599  1.00 31.04           C  
ATOM   2936  C   ALA C  58     -17.386  35.161  43.761  1.00 32.52           C  
ATOM   2937  O   ALA C  58     -17.182  34.104  43.162  1.00 32.97           O  
ATOM   2938  CB  ALA C  58     -18.333  35.086  46.090  1.00 33.89           C  
ATOM   2939  N   VAL C  59     -16.580  36.213  43.731  1.00 30.72           N  
ATOM   2940  CA  VAL C  59     -15.250  36.182  43.117  1.00 31.90           C  
ATOM   2941  C   VAL C  59     -14.260  36.708  44.167  1.00 33.08           C  
ATOM   2942  O   VAL C  59     -14.521  37.721  44.825  1.00 33.90           O  
ATOM   2943  CB  VAL C  59     -15.221  36.982  41.804  1.00 33.46           C  
ATOM   2944  CG1 VAL C  59     -15.761  38.413  41.989  1.00 36.59           C  
ATOM   2945  CG2 VAL C  59     -13.800  37.039  41.221  1.00 34.73           C  
ATOM   2946  N   CYS C  60     -13.168  35.982  44.393  1.00 33.23           N  
ATOM   2947  CA  CYS C  60     -12.129  36.417  45.323  1.00 33.34           C  
ATOM   2948  C   CYS C  60     -10.782  36.217  44.634  1.00 34.40           C  
ATOM   2949  O   CYS C  60     -10.446  35.094  44.206  1.00 32.69           O  
ATOM   2950  CB  CYS C  60     -12.150  35.556  46.584  1.00 34.96           C  
ATOM   2951  SG  CYS C  60     -13.734  35.448  47.490  1.00 43.83           S  
ATOM   2952  N   CYS C  61      -9.986  37.286  44.604  1.00 34.71           N  
ATOM   2953  CA  CYS C  61      -8.684  37.284  43.983  1.00 33.26           C  
ATOM   2954  C   CYS C  61      -7.574  37.710  44.967  1.00 36.73           C  
ATOM   2955  O   CYS C  61      -7.854  38.223  46.077  1.00 32.23           O  
ATOM   2956  CB  CYS C  61      -8.674  38.201  42.761  1.00 35.58           C  
ATOM   2957  SG  CYS C  61      -9.994  37.900  41.583  1.00 41.26           S  
ATOM   2958  N   ARG C  62      -6.332  37.423  44.573  1.00 33.12           N  
ATOM   2959  CA  ARG C  62      -5.087  37.743  45.320  1.00 40.56           C  
ATOM   2960  C   ARG C  62      -4.095  38.272  44.318  1.00 39.59           C  
ATOM   2961  O   ARG C  62      -4.017  37.756  43.196  1.00 38.82           O  
ATOM   2962  CB  ARG C  62      -4.380  36.469  45.820  1.00 42.47           C  
ATOM   2963  CG  ARG C  62      -4.641  36.016  47.193  1.00 52.84           C  
ATOM   2964  CD  ARG C  62      -3.998  34.633  47.423  1.00 48.40           C  
ATOM   2965  NE  ARG C  62      -2.675  34.571  46.857  1.00 56.00           N  
ATOM   2966  CZ  ARG C  62      -2.014  33.461  46.563  1.00 56.14           C  
ATOM   2967  NH1 ARG C  62      -2.530  32.257  46.777  1.00 60.52           N  
ATOM   2968  NH2 ARG C  62      -0.815  33.568  46.046  1.00 57.67           N  
ATOM   2969  N   VAL C  63      -3.263  39.230  44.724  1.00 39.19           N  
ATOM   2970  CA  VAL C  63      -2.102  39.583  43.897  1.00 41.49           C  
ATOM   2971  C   VAL C  63      -0.994  38.574  44.177  1.00 42.52           C  
ATOM   2972  O   VAL C  63      -0.647  38.324  45.331  1.00 45.60           O  
ATOM   2973  CB  VAL C  63      -1.582  41.024  44.164  1.00 42.08           C  
ATOM   2974  CG1 VAL C  63      -0.281  41.262  43.380  1.00 44.61           C  
ATOM   2975  CG2 VAL C  63      -2.616  42.041  43.776  1.00 44.02           C  
ATOM   2976  N   ASP C  64      -0.425  38.021  43.116  1.00 43.57           N  
ATOM   2977  CA  ASP C  64       0.605  37.004  43.235  1.00 46.83           C  
ATOM   2978  C   ASP C  64       1.889  37.425  42.540  1.00 48.87           C  
ATOM   2979  O   ASP C  64       1.916  37.704  41.345  1.00 48.64           O  
ATOM   2980  CB  ASP C  64       0.093  35.658  42.691  1.00 47.47           C  
ATOM   2981  CG  ASP C  64       1.179  34.604  42.633  1.00 56.92           C  
ATOM   2982  OD1 ASP C  64       1.862  34.385  43.666  1.00 62.18           O  
ATOM   2983  OD2 ASP C  64       1.367  34.004  41.552  1.00 61.33           O  
ATOM   2984  N   HIS C  65       2.969  37.501  43.299  1.00 51.44           N  
ATOM   2985  CA  HIS C  65       4.279  37.707  42.684  1.00 54.47           C  
ATOM   2986  C   HIS C  65       4.986  36.367  42.605  1.00 57.66           C  
ATOM   2987  O   HIS C  65       5.463  35.835  43.613  1.00 60.53           O  
ATOM   2988  CB  HIS C  65       5.108  38.712  43.477  1.00 56.10           C  
ATOM   2989  CG  HIS C  65       4.572  40.105  43.420  1.00 55.05           C  
ATOM   2990  ND1 HIS C  65       3.501  40.518  44.181  1.00 51.44           N  
ATOM   2991  CD2 HIS C  65       4.955  41.180  42.690  1.00 56.39           C  
ATOM   2992  CE1 HIS C  65       3.248  41.789  43.925  1.00 52.59           C  
ATOM   2993  NE2 HIS C  65       4.112  42.211  43.020  1.00 56.32           N  
ATOM   2994  N   SER C  66       5.005  35.795  41.409  1.00 58.90           N  
ATOM   2995  CA  SER C  66       5.722  34.553  41.178  1.00 62.40           C  
ATOM   2996  C   SER C  66       6.290  34.604  39.780  1.00 64.04           C  
ATOM   2997  O   SER C  66       5.846  35.411  38.966  1.00 63.39           O  
ATOM   2998  CB  SER C  66       4.818  33.324  41.384  1.00 62.44           C  
ATOM   2999  OG  SER C  66       3.775  33.250  40.428  1.00 61.05           O  
ATOM   3000  N   GLN C  67       7.280  33.751  39.516  1.00 67.33           N  
ATOM   3001  CA  GLN C  67       8.002  33.703  38.237  1.00 69.56           C  
ATOM   3002  C   GLN C  67       8.401  35.066  37.660  1.00 68.39           C  
ATOM   3003  O   GLN C  67       8.303  35.298  36.456  1.00 68.57           O  
ATOM   3004  CB  GLN C  67       7.284  32.810  37.202  1.00 70.40           C  
ATOM   3005  CG  GLN C  67       5.831  33.133  36.929  1.00 68.57           C  
ATOM   3006  CD  GLN C  67       5.085  32.006  36.251  1.00 69.71           C  
ATOM   3007  OE1 GLN C  67       5.232  30.835  36.605  1.00 74.57           O  
ATOM   3008  NE2 GLN C  67       4.253  32.360  35.285  1.00 69.58           N  
ATOM   3009  N   ASN C  68       8.859  35.955  38.543  1.00 67.80           N  
ATOM   3010  CA  ASN C  68       9.336  37.294  38.167  1.00 67.16           C  
ATOM   3011  C   ASN C  68       8.259  38.186  37.521  1.00 63.70           C  
ATOM   3012  O   ASN C  68       8.566  39.147  36.810  1.00 63.57           O  
ATOM   3013  CB  ASN C  68      10.589  37.195  37.279  1.00 72.09           C  
ATOM   3014  CG  ASN C  68      11.442  38.451  37.326  1.00 76.70           C  
ATOM   3015  OD1 ASN C  68      11.325  39.268  38.245  1.00 80.39           O  
ATOM   3016  ND2 ASN C  68      12.313  38.611  36.331  1.00 80.22           N  
ATOM   3017  N   GLN C  69       6.996  37.858  37.787  1.00 58.76           N  
ATOM   3018  CA  GLN C  69       5.864  38.614  37.251  1.00 55.49           C  
ATOM   3019  C   GLN C  69       4.955  39.057  38.379  1.00 51.44           C  
ATOM   3020  O   GLN C  69       5.006  38.508  39.473  1.00 51.07           O  
ATOM   3021  CB  GLN C  69       5.040  37.758  36.281  1.00 55.49           C  
ATOM   3022  CG  GLN C  69       5.725  37.423  34.983  1.00 57.17           C  
ATOM   3023  CD  GLN C  69       5.038  36.292  34.219  1.00 57.21           C  
ATOM   3024  OE1 GLN C  69       4.225  35.555  34.767  1.00 54.64           O  
ATOM   3025  NE2 GLN C  69       5.393  36.136  32.952  1.00 60.62           N  
ATOM   3026  N   LYS C  70       4.134  40.063  38.092  1.00 43.05           N  
ATOM   3027  CA  LYS C  70       3.034  40.459  38.941  1.00 40.68           C  
ATOM   3028  C   LYS C  70       1.765  39.902  38.331  1.00 39.27           C  
ATOM   3029  O   LYS C  70       1.398  40.246  37.203  1.00 38.38           O  
ATOM   3030  CB  LYS C  70       2.951  41.980  39.047  1.00 42.73           C  
ATOM   3031  CG  LYS C  70       1.841  42.442  39.978  1.00 41.94           C  
ATOM   3032  CD  LYS C  70       1.921  43.920  40.309  1.00 46.10           C  
ATOM   3033  CE  LYS C  70       0.665  44.298  41.090  1.00 48.61           C  
ATOM   3034  NZ  LYS C  70       0.594  45.765  41.319  1.00 55.40           N  
ATOM   3035  N   ARG C  71       1.078  39.033  39.058  1.00 37.54           N  
ATOM   3036  CA  ARG C  71      -0.024  38.323  38.440  1.00 35.16           C  
ATOM   3037  C   ARG C  71      -1.263  38.478  39.294  1.00 34.83           C  
ATOM   3038  O   ARG C  71      -1.146  38.686  40.517  1.00 37.70           O  
ATOM   3039  CB  ARG C  71       0.321  36.847  38.297  1.00 35.59           C  
ATOM   3040  CG  ARG C  71       1.778  36.550  37.810  1.00 36.48           C  
ATOM   3041  CD  ARG C  71       2.092  35.067  37.970  1.00 37.07           C  
ATOM   3042  NE  ARG C  71       1.361  34.228  37.023  1.00 39.09           N  
ATOM   3043  CZ  ARG C  71       1.394  32.891  37.024  1.00 43.55           C  
ATOM   3044  NH1 ARG C  71       2.105  32.240  37.946  1.00 45.37           N  
ATOM   3045  NH2 ARG C  71       0.724  32.192  36.104  1.00 42.09           N  
ATOM   3046  N   LEU C  72      -2.432  38.426  38.650  1.00 32.93           N  
ATOM   3047  CA  LEU C  72      -3.696  38.370  39.400  1.00 31.07           C  
ATOM   3048  C   LEU C  72      -4.130  36.946  39.456  1.00 32.22           C  
ATOM   3049  O   LEU C  72      -4.369  36.330  38.423  1.00 33.15           O  
ATOM   3050  CB  LEU C  72      -4.796  39.220  38.759  1.00 30.97           C  
ATOM   3051  CG  LEU C  72      -6.054  39.367  39.634  1.00 37.42           C  
ATOM   3052  CD1 LEU C  72      -5.755  40.207  40.903  1.00 39.40           C  
ATOM   3053  CD2 LEU C  72      -7.107  40.049  38.866  1.00 45.18           C  
ATOM   3054  N   TYR C  73      -4.263  36.408  40.667  1.00 30.32           N  
ATOM   3055  CA  TYR C  73      -4.673  35.032  40.808  1.00 29.98           C  
ATOM   3056  C   TYR C  73      -6.137  35.004  41.219  1.00 31.06           C  
ATOM   3057  O   TYR C  73      -6.488  35.568  42.242  1.00 31.03           O  
ATOM   3058  CB  TYR C  73      -3.778  34.339  41.871  1.00 33.59           C  
ATOM   3059  CG  TYR C  73      -4.165  32.890  42.169  1.00 34.88           C  
ATOM   3060  CD1 TYR C  73      -4.304  31.952  41.139  1.00 35.74           C  
ATOM   3061  CD2 TYR C  73      -4.378  32.469  43.465  1.00 40.02           C  
ATOM   3062  CE1 TYR C  73      -4.653  30.619  41.406  1.00 37.14           C  
ATOM   3063  CE2 TYR C  73      -4.744  31.144  43.735  1.00 38.95           C  
ATOM   3064  CZ  TYR C  73      -4.872  30.240  42.704  1.00 38.22           C  
ATOM   3065  OH  TYR C  73      -5.218  28.939  43.011  1.00 40.54           O  
ATOM   3066  N   ILE C  74      -6.984  34.345  40.432  1.00 31.02           N  
ATOM   3067  CA  ILE C  74      -8.393  34.213  40.791  1.00 31.24           C  
ATOM   3068  C   ILE C  74      -8.487  32.978  41.649  1.00 34.16           C  
ATOM   3069  O   ILE C  74      -8.296  31.850  41.157  1.00 33.32           O  
ATOM   3070  CB  ILE C  74      -9.282  34.039  39.529  1.00 31.02           C  
ATOM   3071  CG1 ILE C  74      -9.059  35.197  38.553  1.00 30.77           C  
ATOM   3072  CG2 ILE C  74     -10.736  33.898  39.929  1.00 32.88           C  
ATOM   3073  CD1 ILE C  74      -9.882  35.087  37.274  1.00 31.65           C  
HETATM 3074  N   MSE C  75      -8.729  33.186  42.940  1.00 32.40           N  
HETATM 3075  CA  MSE C  75      -8.714  32.079  43.874  1.00 35.05           C  
HETATM 3076  C   MSE C  75     -10.001  31.296  43.726  1.00 35.56           C  
HETATM 3077  O   MSE C  75     -10.002  30.057  43.751  1.00 36.65           O  
HETATM 3078  CB  MSE C  75      -8.551  32.601  45.297  1.00 35.87           C  
HETATM 3079  CG  MSE C  75      -7.262  33.341  45.529  1.00 34.74           C  
HETATM 3080 SE   MSE C  75      -7.184  33.916  47.397  1.00 49.55          SE  
HETATM 3081  CE  MSE C  75      -8.701  35.151  47.381  1.00 39.44           C  
ATOM   3082  N   THR C  76     -11.100  32.025  43.560  1.00 36.25           N  
ATOM   3083  CA  THR C  76     -12.446  31.447  43.475  1.00 34.76           C  
ATOM   3084  C   THR C  76     -13.282  32.422  42.652  1.00 32.75           C  
ATOM   3085  O   THR C  76     -13.260  33.646  42.889  1.00 33.30           O  
ATOM   3086  CB  THR C  76     -13.131  31.321  44.859  1.00 39.96           C  
ATOM   3087  OG1 THR C  76     -13.081  32.577  45.557  1.00 43.42           O  
ATOM   3088  CG2 THR C  76     -12.492  30.223  45.740  1.00 43.63           C  
ATOM   3089  N   LEU C  77     -13.968  31.889  41.659  1.00 31.72           N  
ATOM   3090  CA  LEU C  77     -14.996  32.638  40.936  1.00 29.45           C  
ATOM   3091  C   LEU C  77     -16.072  31.642  40.582  1.00 30.77           C  
ATOM   3092  O   LEU C  77     -15.810  30.655  39.871  1.00 32.64           O  
ATOM   3093  CB  LEU C  77     -14.425  33.223  39.652  1.00 30.36           C  
ATOM   3094  CG  LEU C  77     -15.276  34.172  38.780  1.00 32.06           C  
ATOM   3095  CD1 LEU C  77     -14.395  35.088  37.949  1.00 31.88           C  
ATOM   3096  CD2 LEU C  77     -16.233  33.427  37.842  1.00 30.73           C  
ATOM   3097  N   GLY C  78     -17.287  31.883  41.041  1.00 30.25           N  
ATOM   3098  CA  GLY C  78     -18.336  30.912  40.754  1.00 29.10           C  
ATOM   3099  C   GLY C  78     -19.680  31.279  41.315  1.00 31.20           C  
ATOM   3100  O   GLY C  78     -19.793  32.211  42.108  1.00 30.63           O  
ATOM   3101  N   CYS C  79     -20.707  30.563  40.872  1.00 31.58           N  
ATOM   3102  CA  CYS C  79     -22.023  30.757  41.430  1.00 33.69           C  
ATOM   3103  C   CYS C  79     -22.762  29.430  41.606  1.00 32.94           C  
ATOM   3104  O   CYS C  79     -22.363  28.388  41.069  1.00 32.20           O  
ATOM   3105  CB  CYS C  79     -22.826  31.793  40.613  1.00 38.12           C  
ATOM   3106  SG  CYS C  79     -23.397  31.253  39.001  1.00 48.08           S  
ATOM   3107  N   LEU C  80     -23.822  29.482  42.388  1.00 30.68           N  
ATOM   3108  CA  LEU C  80     -24.643  28.297  42.657  1.00 32.94           C  
ATOM   3109  C   LEU C  80     -25.193  27.723  41.377  1.00 32.56           C  
ATOM   3110  O   LEU C  80     -25.574  28.461  40.477  1.00 34.44           O  
ATOM   3111  CB  LEU C  80     -25.799  28.655  43.576  1.00 32.11           C  
ATOM   3112  CG  LEU C  80     -25.460  29.185  44.973  1.00 40.82           C  
ATOM   3113  CD1 LEU C  80     -26.737  29.770  45.573  1.00 41.89           C  
ATOM   3114  CD2 LEU C  80     -24.854  28.082  45.860  1.00 40.50           C  
ATOM   3115  N   ALA C  81     -25.204  26.393  41.286  1.00 33.91           N  
ATOM   3116  CA  ALA C  81     -25.550  25.683  40.049  1.00 36.56           C  
ATOM   3117  C   ALA C  81     -26.842  26.192  39.371  1.00 38.26           C  
ATOM   3118  O   ALA C  81     -26.862  26.411  38.147  1.00 35.07           O  
ATOM   3119  CB  ALA C  81     -25.614  24.158  40.311  1.00 40.43           C  
ATOM   3120  N   PRO C  82     -27.927  26.407  40.156  1.00 37.09           N  
ATOM   3121  CA  PRO C  82     -29.166  26.838  39.489  1.00 37.74           C  
ATOM   3122  C   PRO C  82     -29.153  28.221  38.804  1.00 36.21           C  
ATOM   3123  O   PRO C  82     -30.069  28.521  38.044  1.00 37.92           O  
ATOM   3124  CB  PRO C  82     -30.219  26.814  40.620  1.00 38.16           C  
ATOM   3125  CG  PRO C  82     -29.541  26.239  41.810  1.00 41.90           C  
ATOM   3126  CD  PRO C  82     -28.090  26.290  41.619  1.00 39.65           C  
ATOM   3127  N   TYR C  83     -28.131  29.044  39.056  1.00 33.56           N  
ATOM   3128  CA  TYR C  83     -28.061  30.407  38.547  1.00 33.18           C  
ATOM   3129  C   TYR C  83     -26.969  30.541  37.499  1.00 35.04           C  
ATOM   3130  O   TYR C  83     -26.614  31.654  37.076  1.00 36.88           O  
ATOM   3131  CB  TYR C  83     -27.777  31.396  39.675  1.00 35.19           C  
ATOM   3132  CG  TYR C  83     -28.903  31.421  40.659  1.00 33.47           C  
ATOM   3133  CD1 TYR C  83     -30.042  32.205  40.425  1.00 35.59           C  
ATOM   3134  CD2 TYR C  83     -28.887  30.591  41.786  1.00 38.90           C  
ATOM   3135  CE1 TYR C  83     -31.120  32.186  41.319  1.00 37.07           C  
ATOM   3136  CE2 TYR C  83     -29.960  30.568  42.671  1.00 36.16           C  
ATOM   3137  CZ  TYR C  83     -31.065  31.381  42.441  1.00 40.06           C  
ATOM   3138  OH  TYR C  83     -32.142  31.377  43.313  1.00 38.81           O  
ATOM   3139  N   ARG C  84     -26.432  29.407  37.071  1.00 34.45           N  
ATOM   3140  CA  ARG C  84     -25.423  29.451  35.995  1.00 32.00           C  
ATOM   3141  C   ARG C  84     -26.036  29.703  34.624  1.00 34.68           C  
ATOM   3142  O   ARG C  84     -27.232  29.499  34.405  1.00 35.59           O  
ATOM   3143  CB  ARG C  84     -24.591  28.175  35.997  1.00 33.57           C  
ATOM   3144  CG  ARG C  84     -23.686  28.083  37.214  1.00 33.77           C  
ATOM   3145  CD  ARG C  84     -22.925  26.780  37.310  1.00 35.82           C  
ATOM   3146  NE  ARG C  84     -22.384  26.712  38.669  1.00 33.37           N  
ATOM   3147  CZ  ARG C  84     -21.898  25.616  39.227  1.00 36.64           C  
ATOM   3148  NH1 ARG C  84     -21.809  24.478  38.530  1.00 33.99           N  
ATOM   3149  NH2 ARG C  84     -21.491  25.659  40.476  1.00 36.27           N  
ATOM   3150  N   ARG C  85     -25.180  30.151  33.703  1.00 32.07           N  
ATOM   3151  CA  ARG C  85     -25.542  30.506  32.315  1.00 36.25           C  
ATOM   3152  C   ARG C  85     -26.553  31.653  32.282  1.00 36.31           C  
ATOM   3153  O   ARG C  85     -27.444  31.661  31.421  1.00 37.70           O  
ATOM   3154  CB  ARG C  85     -26.095  29.305  31.505  1.00 38.97           C  
ATOM   3155  CG  ARG C  85     -25.254  28.046  31.445  1.00 45.56           C  
ATOM   3156  CD  ARG C  85     -24.014  28.198  30.566  1.00 56.05           C  
ATOM   3157  NE  ARG C  85     -24.093  27.591  29.226  1.00 63.00           N  
ATOM   3158  CZ  ARG C  85     -23.970  28.300  28.114  1.00 61.02           C  
ATOM   3159  NH1 ARG C  85     -23.803  29.609  28.200  1.00 62.18           N  
ATOM   3160  NH2 ARG C  85     -24.013  27.725  26.931  1.00 64.94           N  
ATOM   3161  N   LEU C  86     -26.422  32.600  33.215  1.00 33.62           N  
ATOM   3162  CA  LEU C  86     -27.252  33.821  33.272  1.00 33.39           C  
ATOM   3163  C   LEU C  86     -26.383  35.075  33.144  1.00 34.26           C  
ATOM   3164  O   LEU C  86     -26.892  36.189  33.208  1.00 36.12           O  
ATOM   3165  CB  LEU C  86     -28.073  33.918  34.578  1.00 33.13           C  
ATOM   3166  CG  LEU C  86     -29.120  32.809  34.752  1.00 36.53           C  
ATOM   3167  CD1 LEU C  86     -29.662  32.801  36.165  1.00 39.38           C  
ATOM   3168  CD2 LEU C  86     -30.222  32.921  33.732  1.00 41.08           C  
ATOM   3169  N   GLY C  87     -25.096  34.881  32.924  1.00 33.74           N  
ATOM   3170  CA  GLY C  87     -24.147  36.004  32.748  1.00 31.98           C  
ATOM   3171  C   GLY C  87     -23.497  36.482  34.041  1.00 32.07           C  
ATOM   3172  O   GLY C  87     -22.816  37.502  34.047  1.00 32.11           O  
ATOM   3173  N   ILE C  88     -23.677  35.734  35.126  1.00 31.84           N  
ATOM   3174  CA  ILE C  88     -23.081  36.103  36.420  1.00 31.03           C  
ATOM   3175  C   ILE C  88     -21.555  35.967  36.394  1.00 30.90           C  
ATOM   3176  O   ILE C  88     -20.841  36.902  36.780  1.00 30.73           O  
ATOM   3177  CB  ILE C  88     -23.746  35.344  37.602  1.00 32.89           C  
ATOM   3178  CG1 ILE C  88     -25.237  35.706  37.680  1.00 34.43           C  
ATOM   3179  CG2 ILE C  88     -23.072  35.673  38.955  1.00 33.04           C  
ATOM   3180  CD1 ILE C  88     -26.035  34.869  38.632  1.00 36.78           C  
ATOM   3181  N   GLY C  89     -21.065  34.843  35.868  1.00 28.56           N  
ATOM   3182  CA  GLY C  89     -19.616  34.623  35.766  1.00 27.35           C  
ATOM   3183  C   GLY C  89     -19.014  35.702  34.893  1.00 27.85           C  
ATOM   3184  O   GLY C  89     -17.953  36.215  35.195  1.00 28.62           O  
ATOM   3185  N   THR C  90     -19.715  36.054  33.820  1.00 29.96           N  
ATOM   3186  CA  THR C  90     -19.235  37.113  32.890  1.00 29.83           C  
ATOM   3187  C   THR C  90     -19.093  38.442  33.647  1.00 31.79           C  
ATOM   3188  O   THR C  90     -18.091  39.126  33.516  1.00 31.42           O  
ATOM   3189  CB  THR C  90     -20.165  37.250  31.656  1.00 33.41           C  
ATOM   3190  OG1 THR C  90     -20.036  36.076  30.826  1.00 31.35           O  
ATOM   3191  CG2 THR C  90     -19.797  38.478  30.814  1.00 33.76           C  
ATOM   3192  N   LYS C  91     -20.094  38.804  34.431  1.00 27.74           N  
ATOM   3193  CA  LYS C  91     -20.075  40.087  35.163  1.00 30.09           C  
ATOM   3194  C   LYS C  91     -18.915  40.082  36.194  1.00 30.64           C  
ATOM   3195  O   LYS C  91     -18.214  41.094  36.392  1.00 29.38           O  
ATOM   3196  CB  LYS C  91     -21.417  40.296  35.879  1.00 34.31           C  
ATOM   3197  CG  LYS C  91     -21.585  41.721  36.495  1.00 39.15           C  
ATOM   3198  CD  LYS C  91     -23.032  42.110  36.641  1.00 49.48           C  
ATOM   3199  CE  LYS C  91     -23.178  43.546  37.118  1.00 55.85           C  
ATOM   3200  NZ  LYS C  91     -23.148  44.536  36.013  1.00 64.61           N  
HETATM 3201  N   MSE C  92     -18.728  38.954  36.873  1.00 27.97           N  
HETATM 3202  CA  MSE C  92     -17.637  38.827  37.857  1.00 30.86           C  
HETATM 3203  C   MSE C  92     -16.275  38.899  37.188  1.00 32.20           C  
HETATM 3204  O   MSE C  92     -15.356  39.603  37.657  1.00 33.06           O  
HETATM 3205  CB  MSE C  92     -17.748  37.519  38.661  1.00 30.52           C  
HETATM 3206  CG  MSE C  92     -18.961  37.542  39.610  1.00 33.72           C  
HETATM 3207 SE   MSE C  92     -18.958  35.962  40.762  1.00 45.86          SE  
HETATM 3208  CE  MSE C  92     -19.447  34.535  39.509  1.00 37.51           C  
ATOM   3209  N   LEU C  93     -16.119  38.164  36.094  1.00 29.29           N  
ATOM   3210  CA  LEU C  93     -14.814  38.176  35.408  1.00 26.27           C  
ATOM   3211  C   LEU C  93     -14.513  39.544  34.776  1.00 30.47           C  
ATOM   3212  O   LEU C  93     -13.394  40.050  34.898  1.00 30.70           O  
ATOM   3213  CB  LEU C  93     -14.714  37.029  34.403  1.00 27.57           C  
ATOM   3214  CG  LEU C  93     -13.415  36.872  33.605  1.00 33.45           C  
ATOM   3215  CD1 LEU C  93     -12.151  36.815  34.515  1.00 35.52           C  
ATOM   3216  CD2 LEU C  93     -13.462  35.660  32.704  1.00 34.67           C  
ATOM   3217  N   ASN C  94     -15.494  40.158  34.121  1.00 28.94           N  
ATOM   3218  CA  ASN C  94     -15.295  41.507  33.609  1.00 29.15           C  
ATOM   3219  C   ASN C  94     -14.893  42.517  34.687  1.00 31.54           C  
ATOM   3220  O   ASN C  94     -14.084  43.426  34.431  1.00 31.77           O  
ATOM   3221  CB  ASN C  94     -16.542  41.970  32.874  1.00 31.01           C  
ATOM   3222  CG  ASN C  94     -16.643  41.378  31.479  1.00 38.95           C  
ATOM   3223  OD1 ASN C  94     -15.641  40.983  30.892  1.00 42.00           O  
ATOM   3224  ND2 ASN C  94     -17.846  41.308  30.951  1.00 40.30           N  
ATOM   3225  N   HIS C  95     -15.461  42.374  35.884  1.00 29.20           N  
ATOM   3226  CA  HIS C  95     -15.085  43.231  37.016  1.00 32.81           C  
ATOM   3227  C   HIS C  95     -13.583  43.155  37.282  1.00 32.89           C  
ATOM   3228  O   HIS C  95     -12.923  44.184  37.439  1.00 32.72           O  
ATOM   3229  CB  HIS C  95     -15.872  42.833  38.265  1.00 33.94           C  
ATOM   3230  CG  HIS C  95     -15.462  43.564  39.515  1.00 35.78           C  
ATOM   3231  ND1 HIS C  95     -15.946  44.811  39.840  1.00 38.87           N  
ATOM   3232  CD2 HIS C  95     -14.637  43.205  40.529  1.00 36.47           C  
ATOM   3233  CE1 HIS C  95     -15.417  45.204  40.986  1.00 43.89           C  
ATOM   3234  NE2 HIS C  95     -14.610  44.250  41.421  1.00 40.80           N  
ATOM   3235  N   VAL C  96     -13.058  41.932  37.335  1.00 30.61           N  
ATOM   3236  CA  VAL C  96     -11.646  41.689  37.633  1.00 31.91           C  
ATOM   3237  C   VAL C  96     -10.773  42.194  36.476  1.00 32.62           C  
ATOM   3238  O   VAL C  96      -9.722  42.798  36.708  1.00 33.00           O  
ATOM   3239  CB  VAL C  96     -11.414  40.187  37.895  1.00 35.67           C  
ATOM   3240  CG1 VAL C  96      -9.937  39.910  37.994  1.00 42.25           C  
ATOM   3241  CG2 VAL C  96     -12.130  39.770  39.156  1.00 39.51           C  
ATOM   3242  N   LEU C  97     -11.195  41.966  35.234  1.00 33.01           N  
ATOM   3243  CA  LEU C  97     -10.397  42.415  34.099  1.00 32.03           C  
ATOM   3244  C   LEU C  97     -10.300  43.926  34.088  1.00 33.20           C  
ATOM   3245  O   LEU C  97      -9.263  44.488  33.718  1.00 32.59           O  
ATOM   3246  CB  LEU C  97     -10.940  41.905  32.762  1.00 32.88           C  
ATOM   3247  CG  LEU C  97     -10.872  40.379  32.635  1.00 35.05           C  
ATOM   3248  CD1 LEU C  97     -11.647  39.953  31.416  1.00 40.02           C  
ATOM   3249  CD2 LEU C  97      -9.421  39.899  32.626  1.00 41.11           C  
ATOM   3250  N   ASN C  98     -11.390  44.591  34.453  1.00 29.93           N  
ATOM   3251  CA  ASN C  98     -11.399  46.050  34.445  1.00 34.04           C  
ATOM   3252  C   ASN C  98     -10.471  46.580  35.531  1.00 34.88           C  
ATOM   3253  O   ASN C  98      -9.764  47.546  35.320  1.00 34.58           O  
ATOM   3254  CB  ASN C  98     -12.819  46.575  34.676  1.00 37.50           C  
ATOM   3255  CG  ASN C  98     -12.844  48.077  34.898  1.00 46.41           C  
ATOM   3256  OD1 ASN C  98     -13.162  48.546  35.996  1.00 50.77           O  
ATOM   3257  ND2 ASN C  98     -12.477  48.836  33.873  1.00 42.92           N  
ATOM   3258  N   ILE C  99     -10.461  45.943  36.701  1.00 30.55           N  
ATOM   3259  CA  ILE C  99      -9.508  46.359  37.752  1.00 33.52           C  
ATOM   3260  C   ILE C  99      -8.082  46.276  37.237  1.00 34.64           C  
ATOM   3261  O   ILE C  99      -7.292  47.217  37.417  1.00 36.99           O  
ATOM   3262  CB  ILE C  99      -9.642  45.493  39.013  1.00 35.26           C  
ATOM   3263  CG1 ILE C  99     -10.998  45.740  39.630  1.00 37.59           C  
ATOM   3264  CG2 ILE C  99      -8.514  45.810  40.021  1.00 38.05           C  
ATOM   3265  CD1 ILE C  99     -11.269  44.787  40.780  1.00 38.21           C  
ATOM   3266  N   CYS C 100      -7.765  45.183  36.548  1.00 33.79           N  
ATOM   3267  CA  CYS C 100      -6.426  45.003  36.004  1.00 34.80           C  
ATOM   3268  C   CYS C 100      -6.099  46.044  34.945  1.00 36.36           C  
ATOM   3269  O   CYS C 100      -4.985  46.594  34.923  1.00 36.88           O  
ATOM   3270  CB  CYS C 100      -6.256  43.592  35.407  1.00 37.07           C  
ATOM   3271  SG  CYS C 100      -6.324  42.305  36.667  1.00 43.99           S  
ATOM   3272  N   GLU C 101      -7.049  46.319  34.058  1.00 34.87           N  
ATOM   3273  CA  GLU C 101      -6.805  47.304  32.990  1.00 39.33           C  
ATOM   3274  C   GLU C 101      -6.526  48.715  33.565  1.00 37.89           C  
ATOM   3275  O   GLU C 101      -5.623  49.427  33.093  1.00 38.74           O  
ATOM   3276  CB  GLU C 101      -8.002  47.351  32.050  1.00 41.76           C  
ATOM   3277  CG  GLU C 101      -7.800  48.249  30.831  1.00 55.99           C  
ATOM   3278  CD  GLU C 101      -9.040  49.092  30.505  1.00 70.27           C  
ATOM   3279  OE1 GLU C 101      -9.733  49.526  31.457  1.00 72.57           O  
ATOM   3280  OE2 GLU C 101      -9.314  49.334  29.300  1.00 76.44           O  
ATOM   3281  N   LYS C 102      -7.287  49.111  34.587  1.00 36.28           N  
ATOM   3282  CA  LYS C 102      -7.100  50.435  35.195  1.00 38.66           C  
ATOM   3283  C   LYS C 102      -5.784  50.562  35.983  1.00 39.34           C  
ATOM   3284  O   LYS C 102      -5.234  51.656  36.128  1.00 39.53           O  
ATOM   3285  CB  LYS C 102      -8.291  50.782  36.105  1.00 40.25           C  
ATOM   3286  CG  LYS C 102      -9.649  50.926  35.384  1.00 39.82           C  
ATOM   3287  CD  LYS C 102      -9.658  52.138  34.444  1.00 50.56           C  
ATOM   3288  CE  LYS C 102     -11.019  52.292  33.744  1.00 53.34           C  
ATOM   3289  NZ  LYS C 102     -12.141  51.779  34.611  1.00 61.55           N  
ATOM   3290  N   ASP C 103      -5.342  49.451  36.562  1.00 38.91           N  
ATOM   3291  CA  ASP C 103      -4.116  49.399  37.363  1.00 40.00           C  
ATOM   3292  C   ASP C 103      -2.920  49.400  36.423  1.00 40.75           C  
ATOM   3293  O   ASP C 103      -1.989  50.206  36.565  1.00 42.38           O  
ATOM   3294  CB  ASP C 103      -4.165  48.148  38.261  1.00 41.87           C  
ATOM   3295  CG  ASP C 103      -2.879  47.894  39.015  1.00 47.96           C  
ATOM   3296  OD1 ASP C 103      -1.819  47.719  38.361  1.00 54.20           O  
ATOM   3297  OD2 ASP C 103      -2.920  47.850  40.266  1.00 51.82           O  
ATOM   3298  N   GLY C 104      -2.961  48.513  35.440  1.00 38.88           N  
ATOM   3299  CA  GLY C 104      -1.944  48.508  34.368  1.00 38.38           C  
ATOM   3300  C   GLY C 104      -0.613  47.850  34.701  1.00 40.86           C  
ATOM   3301  O   GLY C 104       0.310  47.869  33.876  1.00 43.57           O  
ATOM   3302  N   THR C 105      -0.496  47.248  35.883  1.00 39.42           N  
ATOM   3303  CA  THR C 105       0.795  46.710  36.339  1.00 42.62           C  
ATOM   3304  C   THR C 105       0.858  45.175  36.320  1.00 41.17           C  
ATOM   3305  O   THR C 105       1.895  44.591  36.625  1.00 41.14           O  
ATOM   3306  CB  THR C 105       1.179  47.231  37.745  1.00 43.45           C  
ATOM   3307  OG1 THR C 105       0.252  46.726  38.717  1.00 50.52           O  
ATOM   3308  CG2 THR C 105       1.170  48.753  37.788  1.00 48.77           C  
ATOM   3309  N   PHE C 106      -0.233  44.523  35.921  1.00 38.86           N  
ATOM   3310  CA  PHE C 106      -0.287  43.065  35.885  1.00 37.20           C  
ATOM   3311  C   PHE C 106       0.263  42.460  34.597  1.00 38.25           C  
ATOM   3312  O   PHE C 106      -0.038  42.926  33.501  1.00 39.00           O  
ATOM   3313  CB  PHE C 106      -1.714  42.580  36.116  1.00 36.62           C  
ATOM   3314  CG  PHE C 106      -2.212  42.849  37.505  1.00 38.02           C  
ATOM   3315  CD1 PHE C 106      -1.869  41.996  38.562  1.00 38.92           C  
ATOM   3316  CD2 PHE C 106      -3.013  43.956  37.765  1.00 41.88           C  
ATOM   3317  CE1 PHE C 106      -2.329  42.255  39.856  1.00 39.08           C  
ATOM   3318  CE2 PHE C 106      -3.472  44.219  39.045  1.00 38.13           C  
ATOM   3319  CZ  PHE C 106      -3.129  43.367  40.094  1.00 40.76           C  
ATOM   3320  N   ASP C 107       1.062  41.410  34.736  1.00 37.46           N  
ATOM   3321  CA  ASP C 107       1.557  40.710  33.559  1.00 38.49           C  
ATOM   3322  C   ASP C 107       0.497  39.738  33.043  1.00 36.27           C  
ATOM   3323  O   ASP C 107       0.338  39.571  31.850  1.00 35.63           O  
ATOM   3324  CB  ASP C 107       2.876  40.019  33.873  1.00 40.77           C  
ATOM   3325  CG  ASP C 107       3.972  41.015  34.203  1.00 49.59           C  
ATOM   3326  OD1 ASP C 107       4.267  41.857  33.328  1.00 58.84           O  
ATOM   3327  OD2 ASP C 107       4.524  40.979  35.324  1.00 56.23           O  
ATOM   3328  N   ASN C 108      -0.255  39.137  33.940  1.00 33.27           N  
ATOM   3329  CA  ASN C 108      -1.260  38.191  33.526  1.00 32.07           C  
ATOM   3330  C   ASN C 108      -2.250  37.904  34.627  1.00 34.56           C  
ATOM   3331  O   ASN C 108      -2.032  38.279  35.794  1.00 33.90           O  
ATOM   3332  CB  ASN C 108      -0.635  36.869  33.005  1.00 33.50           C  
ATOM   3333  CG  ASN C 108       0.267  36.197  34.021  1.00 34.75           C  
ATOM   3334  OD1 ASN C 108      -0.200  35.654  35.026  1.00 36.81           O  
ATOM   3335  ND2 ASN C 108       1.575  36.185  33.734  1.00 38.61           N  
ATOM   3336  N   ILE C 109      -3.322  37.216  34.246  1.00 33.02           N  
ATOM   3337  CA  ILE C 109      -4.332  36.739  35.179  1.00 30.44           C  
ATOM   3338  C   ILE C 109      -4.490  35.221  35.023  1.00 29.69           C  
ATOM   3339  O   ILE C 109      -4.496  34.710  33.907  1.00 31.73           O  
ATOM   3340  CB  ILE C 109      -5.688  37.490  34.969  1.00 31.63           C  
ATOM   3341  CG1 ILE C 109      -6.775  36.976  35.910  1.00 32.06           C  
ATOM   3342  CG2 ILE C 109      -6.209  37.360  33.553  1.00 38.01           C  
ATOM   3343  CD1 ILE C 109      -7.999  37.929  35.947  1.00 38.45           C  
ATOM   3344  N   TYR C 110      -4.598  34.491  36.134  1.00 31.63           N  
ATOM   3345  CA  TYR C 110      -4.636  33.039  36.023  1.00 30.03           C  
ATOM   3346  C   TYR C 110      -5.437  32.397  37.145  1.00 29.67           C  
ATOM   3347  O   TYR C 110      -5.767  33.048  38.154  1.00 30.24           O  
ATOM   3348  CB  TYR C 110      -3.212  32.452  35.939  1.00 32.49           C  
ATOM   3349  CG  TYR C 110      -2.483  32.368  37.279  1.00 32.12           C  
ATOM   3350  CD1 TYR C 110      -2.337  31.144  37.927  1.00 35.86           C  
ATOM   3351  CD2 TYR C 110      -1.949  33.505  37.889  1.00 35.66           C  
ATOM   3352  CE1 TYR C 110      -1.663  31.032  39.141  1.00 38.23           C  
ATOM   3353  CE2 TYR C 110      -1.273  33.415  39.126  1.00 35.93           C  
ATOM   3354  CZ  TYR C 110      -1.145  32.163  39.739  1.00 39.97           C  
ATOM   3355  OH  TYR C 110      -0.491  32.021  40.948  1.00 42.76           O  
ATOM   3356  N   LEU C 111      -5.761  31.122  36.945  1.00 29.83           N  
ATOM   3357  CA  LEU C 111      -6.433  30.325  37.973  1.00 31.63           C  
ATOM   3358  C   LEU C 111      -6.194  28.854  37.697  1.00 32.41           C  
ATOM   3359  O   LEU C 111      -5.663  28.494  36.638  1.00 33.17           O  
ATOM   3360  CB  LEU C 111      -7.950  30.609  38.009  1.00 32.11           C  
ATOM   3361  CG  LEU C 111      -8.742  30.026  36.821  1.00 36.97           C  
ATOM   3362  CD1 LEU C 111     -10.136  29.615  37.244  1.00 37.87           C  
ATOM   3363  CD2 LEU C 111      -8.747  30.995  35.663  1.00 36.67           C  
ATOM   3364  N   HIS C 112      -6.597  28.002  38.639  1.00 31.84           N  
ATOM   3365  CA  HIS C 112      -6.531  26.558  38.466  1.00 33.77           C  
ATOM   3366  C   HIS C 112      -7.931  26.007  38.211  1.00 35.03           C  
ATOM   3367  O   HIS C 112      -8.894  26.435  38.836  1.00 32.48           O  
ATOM   3368  CB  HIS C 112      -5.895  25.874  39.686  1.00 36.07           C  
ATOM   3369  CG  HIS C 112      -4.518  26.367  39.997  1.00 36.79           C  
ATOM   3370  ND1 HIS C 112      -3.400  25.919  39.331  1.00 46.88           N  
ATOM   3371  CD2 HIS C 112      -4.079  27.277  40.893  1.00 36.21           C  
ATOM   3372  CE1 HIS C 112      -2.330  26.533  39.801  1.00 42.87           C  
ATOM   3373  NE2 HIS C 112      -2.716  27.373  40.744  1.00 43.08           N  
ATOM   3374  N   VAL C 113      -8.042  25.078  37.270  1.00 32.29           N  
ATOM   3375  CA  VAL C 113      -9.332  24.444  36.983  1.00 34.12           C  
ATOM   3376  C   VAL C 113      -9.153  22.908  36.990  1.00 35.37           C  
ATOM   3377  O   VAL C 113      -8.358  22.376  36.217  1.00 36.88           O  
ATOM   3378  CB  VAL C 113      -9.927  24.915  35.594  1.00 35.05           C  
ATOM   3379  CG1 VAL C 113     -11.194  24.172  35.255  1.00 33.39           C  
ATOM   3380  CG2 VAL C 113     -10.235  26.419  35.595  1.00 36.03           C  
ATOM   3381  N   GLN C 114      -9.918  22.211  37.823  1.00 36.08           N  
ATOM   3382  CA  GLN C 114      -9.903  20.741  37.850  1.00 35.86           C  
ATOM   3383  C   GLN C 114     -10.140  20.198  36.434  1.00 37.86           C  
ATOM   3384  O   GLN C 114     -10.992  20.728  35.695  1.00 38.63           O  
ATOM   3385  CB  GLN C 114     -10.955  20.242  38.829  1.00 38.56           C  
ATOM   3386  CG  GLN C 114     -10.876  18.764  39.093  1.00 40.57           C  
ATOM   3387  CD  GLN C 114     -11.838  18.337  40.180  1.00 44.45           C  
ATOM   3388  OE1 GLN C 114     -12.842  19.008  40.435  1.00 46.52           O  
ATOM   3389  NE2 GLN C 114     -11.526  17.227  40.843  1.00 50.57           N  
ATOM   3390  N   ILE C 115      -9.359  19.196  36.018  1.00 39.05           N  
ATOM   3391  CA  ILE C 115      -9.375  18.802  34.592  1.00 40.68           C  
ATOM   3392  C   ILE C 115     -10.736  18.278  34.100  1.00 43.76           C  
ATOM   3393  O   ILE C 115     -11.021  18.295  32.873  1.00 45.82           O  
ATOM   3394  CB  ILE C 115      -8.204  17.854  34.188  1.00 41.74           C  
ATOM   3395  CG1 ILE C 115      -8.269  16.512  34.922  1.00 40.82           C  
ATOM   3396  CG2 ILE C 115      -6.855  18.543  34.405  1.00 39.23           C  
ATOM   3397  CD1 ILE C 115      -7.313  15.478  34.359  1.00 43.84           C  
ATOM   3398  N   SER C 116     -11.585  17.882  35.047  1.00 40.49           N  
ATOM   3399  CA  SER C 116     -12.919  17.363  34.737  1.00 44.74           C  
ATOM   3400  C   SER C 116     -13.974  18.453  34.488  1.00 43.02           C  
ATOM   3401  O   SER C 116     -15.096  18.170  34.045  1.00 42.37           O  
ATOM   3402  CB  SER C 116     -13.392  16.450  35.876  1.00 45.74           C  
ATOM   3403  OG  SER C 116     -13.378  17.152  37.107  1.00 48.42           O  
ATOM   3404  N   ASN C 117     -13.611  19.701  34.784  1.00 41.77           N  
ATOM   3405  CA  ASN C 117     -14.554  20.799  34.774  1.00 39.45           C  
ATOM   3406  C   ASN C 117     -14.715  21.390  33.376  1.00 38.79           C  
ATOM   3407  O   ASN C 117     -14.201  22.477  33.086  1.00 35.51           O  
ATOM   3408  CB  ASN C 117     -14.077  21.880  35.769  1.00 39.30           C  
ATOM   3409  CG  ASN C 117     -15.199  22.770  36.258  1.00 41.84           C  
ATOM   3410  OD1 ASN C 117     -16.161  23.037  35.539  1.00 39.97           O  
ATOM   3411  ND2 ASN C 117     -15.077  23.243  37.498  1.00 42.25           N  
ATOM   3412  N   GLU C 118     -15.438  20.678  32.515  1.00 40.84           N  
ATOM   3413  CA  GLU C 118     -15.617  21.094  31.122  1.00 42.13           C  
ATOM   3414  C   GLU C 118     -16.293  22.461  31.020  1.00 40.94           C  
ATOM   3415  O   GLU C 118     -15.939  23.273  30.156  1.00 38.26           O  
ATOM   3416  CB  GLU C 118     -16.417  20.027  30.342  1.00 46.62           C  
ATOM   3417  CG  GLU C 118     -16.230  18.584  30.852  1.00 60.82           C  
ATOM   3418  CD  GLU C 118     -14.857  17.928  30.545  1.00 70.24           C  
ATOM   3419  OE1 GLU C 118     -13.794  18.526  30.874  1.00 69.83           O  
ATOM   3420  OE2 GLU C 118     -14.851  16.782  29.994  1.00 74.98           O  
ATOM   3421  N   SER C 119     -17.249  22.741  31.908  1.00 39.52           N  
ATOM   3422  CA  SER C 119     -17.938  24.027  31.812  1.00 38.59           C  
ATOM   3423  C   SER C 119     -17.045  25.209  32.162  1.00 36.90           C  
ATOM   3424  O   SER C 119     -17.125  26.259  31.525  1.00 35.61           O  
ATOM   3425  CB  SER C 119     -19.247  24.029  32.605  1.00 45.17           C  
ATOM   3426  OG  SER C 119     -19.005  24.019  33.991  1.00 49.80           O  
ATOM   3427  N   ALA C 120     -16.159  25.057  33.143  1.00 35.19           N  
ATOM   3428  CA  ALA C 120     -15.224  26.139  33.460  1.00 32.32           C  
ATOM   3429  C   ALA C 120     -14.173  26.292  32.345  1.00 33.55           C  
ATOM   3430  O   ALA C 120     -13.811  27.407  31.947  1.00 32.67           O  
ATOM   3431  CB  ALA C 120     -14.562  25.916  34.822  1.00 31.09           C  
ATOM   3432  N   ILE C 121     -13.687  25.181  31.807  1.00 33.07           N  
ATOM   3433  CA  ILE C 121     -12.705  25.282  30.735  1.00 32.35           C  
ATOM   3434  C   ILE C 121     -13.352  26.055  29.587  1.00 32.20           C  
ATOM   3435  O   ILE C 121     -12.748  27.017  29.085  1.00 34.90           O  
ATOM   3436  CB  ILE C 121     -12.204  23.891  30.264  1.00 35.89           C  
ATOM   3437  CG1 ILE C 121     -11.376  23.191  31.368  1.00 37.55           C  
ATOM   3438  CG2 ILE C 121     -11.350  24.015  29.030  1.00 37.27           C  
ATOM   3439  CD1 ILE C 121     -11.146  21.674  31.147  1.00 40.89           C  
ATOM   3440  N   ASP C 122     -14.578  25.688  29.187  1.00 32.77           N  
ATOM   3441  CA  ASP C 122     -15.289  26.397  28.085  1.00 34.77           C  
ATOM   3442  C   ASP C 122     -15.432  27.925  28.340  1.00 33.61           C  
ATOM   3443  O   ASP C 122     -15.169  28.766  27.453  1.00 34.03           O  
ATOM   3444  CB  ASP C 122     -16.676  25.794  27.857  1.00 38.00           C  
ATOM   3445  CG  ASP C 122     -16.635  24.409  27.202  1.00 49.01           C  
ATOM   3446  OD1 ASP C 122     -15.551  23.915  26.807  1.00 50.41           O  
ATOM   3447  OD2 ASP C 122     -17.725  23.798  27.081  1.00 56.83           O  
ATOM   3448  N   PHE C 123     -15.811  28.253  29.565  1.00 31.63           N  
ATOM   3449  CA  PHE C 123     -16.055  29.630  30.000  1.00 30.40           C  
ATOM   3450  C   PHE C 123     -14.769  30.442  29.886  1.00 31.99           C  
ATOM   3451  O   PHE C 123     -14.748  31.506  29.251  1.00 33.21           O  
ATOM   3452  CB  PHE C 123     -16.572  29.636  31.448  1.00 28.06           C  
ATOM   3453  CG  PHE C 123     -16.654  31.037  32.067  1.00 30.19           C  
ATOM   3454  CD1 PHE C 123     -17.656  31.934  31.665  1.00 33.60           C  
ATOM   3455  CD2 PHE C 123     -15.731  31.430  33.050  1.00 29.73           C  
ATOM   3456  CE1 PHE C 123     -17.726  33.235  32.219  1.00 32.03           C  
ATOM   3457  CE2 PHE C 123     -15.808  32.733  33.613  1.00 29.76           C  
ATOM   3458  CZ  PHE C 123     -16.791  33.609  33.173  1.00 29.34           C  
ATOM   3459  N   TYR C 124     -13.673  29.923  30.436  1.00 30.41           N  
ATOM   3460  CA  TYR C 124     -12.408  30.679  30.422  1.00 29.75           C  
ATOM   3461  C   TYR C 124     -11.785  30.744  29.036  1.00 30.65           C  
ATOM   3462  O   TYR C 124     -11.224  31.789  28.634  1.00 29.78           O  
ATOM   3463  CB  TYR C 124     -11.424  30.167  31.488  1.00 28.33           C  
ATOM   3464  CG  TYR C 124     -11.818  30.594  32.869  1.00 29.59           C  
ATOM   3465  CD1 TYR C 124     -11.629  31.921  33.298  1.00 29.13           C  
ATOM   3466  CD2 TYR C 124     -12.432  29.703  33.736  1.00 27.36           C  
ATOM   3467  CE1 TYR C 124     -12.033  32.332  34.573  1.00 33.20           C  
ATOM   3468  CE2 TYR C 124     -12.860  30.116  35.039  1.00 31.14           C  
ATOM   3469  CZ  TYR C 124     -12.655  31.425  35.432  1.00 34.19           C  
ATOM   3470  OH  TYR C 124     -13.051  31.851  36.688  1.00 34.28           O  
ATOM   3471  N   ARG C 125     -11.903  29.665  28.259  1.00 29.35           N  
ATOM   3472  CA  ARG C 125     -11.373  29.753  26.882  1.00 31.12           C  
ATOM   3473  C   ARG C 125     -12.150  30.778  26.064  1.00 31.95           C  
ATOM   3474  O   ARG C 125     -11.594  31.445  25.175  1.00 35.68           O  
ATOM   3475  CB  ARG C 125     -11.393  28.371  26.205  1.00 31.84           C  
ATOM   3476  CG  ARG C 125     -10.298  27.412  26.715  1.00 32.67           C  
ATOM   3477  CD  ARG C 125     -10.198  26.147  25.836  1.00 34.29           C  
ATOM   3478  NE  ARG C 125      -9.826  26.471  24.456  1.00 32.91           N  
ATOM   3479  CZ  ARG C 125      -9.979  25.642  23.431  1.00 33.07           C  
ATOM   3480  NH1 ARG C 125     -10.484  24.427  23.622  1.00 32.53           N  
ATOM   3481  NH2 ARG C 125      -9.617  26.018  22.217  1.00 35.89           N  
ATOM   3482  N   LYS C 126     -13.444  30.926  26.340  1.00 31.78           N  
ATOM   3483  CA  LYS C 126     -14.256  31.926  25.628  1.00 36.98           C  
ATOM   3484  C   LYS C 126     -13.723  33.344  25.874  1.00 37.81           C  
ATOM   3485  O   LYS C 126     -13.845  34.221  25.024  1.00 40.05           O  
ATOM   3486  CB  LYS C 126     -15.727  31.838  26.049  1.00 42.09           C  
ATOM   3487  CG  LYS C 126     -16.700  32.720  25.222  1.00 52.47           C  
ATOM   3488  CD  LYS C 126     -17.066  32.073  23.880  1.00 60.45           C  
ATOM   3489  CE  LYS C 126     -18.205  32.844  23.177  1.00 65.44           C  
ATOM   3490  NZ  LYS C 126     -18.554  32.263  21.844  1.00 72.04           N  
ATOM   3491  N   PHE C 127     -13.151  33.564  27.055  1.00 35.16           N  
ATOM   3492  CA  PHE C 127     -12.628  34.871  27.430  1.00 39.34           C  
ATOM   3493  C   PHE C 127     -11.154  35.085  27.085  1.00 38.97           C  
ATOM   3494  O   PHE C 127     -10.545  36.072  27.540  1.00 43.20           O  
ATOM   3495  CB  PHE C 127     -12.808  35.088  28.941  1.00 40.71           C  
ATOM   3496  CG  PHE C 127     -14.108  35.685  29.320  1.00 43.88           C  
ATOM   3497  CD1 PHE C 127     -15.257  34.901  29.383  1.00 46.25           C  
ATOM   3498  CD2 PHE C 127     -14.192  37.042  29.635  1.00 50.23           C  
ATOM   3499  CE1 PHE C 127     -16.473  35.456  29.738  1.00 53.13           C  
ATOM   3500  CE2 PHE C 127     -15.415  37.616  30.021  1.00 56.52           C  
ATOM   3501  CZ  PHE C 127     -16.557  36.817  30.061  1.00 58.09           C  
ATOM   3502  N   GLY C 128     -10.567  34.193  26.296  1.00 35.61           N  
ATOM   3503  CA  GLY C 128      -9.189  34.378  25.881  1.00 37.02           C  
ATOM   3504  C   GLY C 128      -8.142  33.851  26.846  1.00 38.08           C  
ATOM   3505  O   GLY C 128      -6.968  34.190  26.724  1.00 37.82           O  
ATOM   3506  N   PHE C 129      -8.557  33.044  27.817  1.00 31.96           N  
ATOM   3507  CA  PHE C 129      -7.604  32.334  28.658  1.00 30.97           C  
ATOM   3508  C   PHE C 129      -7.150  31.092  27.926  1.00 34.32           C  
ATOM   3509  O   PHE C 129      -7.913  30.500  27.161  1.00 35.57           O  
ATOM   3510  CB  PHE C 129      -8.225  31.863  29.968  1.00 29.52           C  
ATOM   3511  CG  PHE C 129      -8.448  32.954  30.970  1.00 29.81           C  
ATOM   3512  CD1 PHE C 129      -7.752  32.969  32.171  1.00 32.07           C  
ATOM   3513  CD2 PHE C 129      -9.392  33.948  30.723  1.00 27.64           C  
ATOM   3514  CE1 PHE C 129      -7.966  33.992  33.103  1.00 34.57           C  
ATOM   3515  CE2 PHE C 129      -9.616  34.969  31.632  1.00 30.14           C  
ATOM   3516  CZ  PHE C 129      -8.909  34.990  32.841  1.00 33.43           C  
ATOM   3517  N   GLU C 130      -5.907  30.687  28.153  1.00 35.19           N  
ATOM   3518  CA  GLU C 130      -5.425  29.477  27.509  1.00 42.23           C  
ATOM   3519  C   GLU C 130      -4.881  28.547  28.566  1.00 42.86           C  
ATOM   3520  O   GLU C 130      -4.437  29.004  29.603  1.00 39.13           O  
ATOM   3521  CB  GLU C 130      -4.389  29.802  26.422  1.00 45.79           C  
ATOM   3522  CG  GLU C 130      -3.144  30.506  26.871  1.00 56.10           C  
ATOM   3523  CD  GLU C 130      -2.117  30.689  25.744  1.00 64.62           C  
ATOM   3524  OE1 GLU C 130      -2.430  30.335  24.577  1.00 75.58           O  
ATOM   3525  OE2 GLU C 130      -0.988  31.175  26.023  1.00 73.29           O  
ATOM   3526  N   ILE C 131      -4.978  27.238  28.328  1.00 32.88           N  
ATOM   3527  CA  ILE C 131      -4.373  26.263  29.226  1.00 31.83           C  
ATOM   3528  C   ILE C 131      -2.891  26.278  28.933  1.00 35.73           C  
ATOM   3529  O   ILE C 131      -2.467  25.950  27.818  1.00 36.53           O  
ATOM   3530  CB  ILE C 131      -4.914  24.827  29.009  1.00 35.46           C  
ATOM   3531  CG1 ILE C 131      -6.438  24.775  29.222  1.00 33.30           C  
ATOM   3532  CG2 ILE C 131      -4.181  23.851  29.965  1.00 38.53           C  
ATOM   3533  CD1 ILE C 131      -7.090  23.518  28.617  1.00 35.87           C  
ATOM   3534  N   ILE C 132      -2.093  26.660  29.920  1.00 34.91           N  
ATOM   3535  CA  ILE C 132      -0.631  26.700  29.725  1.00 39.63           C  
ATOM   3536  C   ILE C 132       0.167  25.578  30.421  1.00 39.86           C  
ATOM   3537  O   ILE C 132       1.365  25.410  30.174  1.00 41.76           O  
ATOM   3538  CB  ILE C 132      -0.071  28.059  30.175  1.00 41.84           C  
ATOM   3539  CG1 ILE C 132      -0.406  28.299  31.651  1.00 40.60           C  
ATOM   3540  CG2 ILE C 132      -0.623  29.178  29.308  1.00 41.52           C  
ATOM   3541  CD1 ILE C 132       0.367  29.418  32.289  1.00 45.47           C  
ATOM   3542  N   GLU C 133      -0.481  24.844  31.315  1.00 39.85           N  
ATOM   3543  CA  GLU C 133       0.194  23.806  32.102  1.00 45.27           C  
ATOM   3544  C   GLU C 133      -0.894  22.947  32.705  1.00 43.68           C  
ATOM   3545  O   GLU C 133      -2.019  23.418  32.906  1.00 41.97           O  
ATOM   3546  CB  GLU C 133       1.029  24.437  33.234  1.00 48.47           C  
ATOM   3547  CG  GLU C 133       1.718  23.414  34.152  1.00 56.20           C  
ATOM   3548  CD  GLU C 133       2.474  24.026  35.343  1.00 60.94           C  
ATOM   3549  OE1 GLU C 133       2.277  25.231  35.639  1.00 67.39           O  
ATOM   3550  OE2 GLU C 133       3.266  23.287  35.989  1.00 67.40           O  
ATOM   3551  N   THR C 134      -0.574  21.699  33.018  1.00 42.14           N  
ATOM   3552  CA  THR C 134      -1.500  20.908  33.792  1.00 43.27           C  
ATOM   3553  C   THR C 134      -0.745  20.382  35.001  1.00 46.40           C  
ATOM   3554  O   THR C 134       0.250  19.681  34.847  1.00 48.31           O  
ATOM   3555  CB  THR C 134      -2.090  19.767  32.961  1.00 43.88           C  
ATOM   3556  OG1 THR C 134      -2.818  20.326  31.858  1.00 43.98           O  
ATOM   3557  CG2 THR C 134      -3.022  18.948  33.816  1.00 47.21           C  
ATOM   3558  N   LYS C 135      -1.219  20.736  36.196  1.00 45.03           N  
ATOM   3559  CA  LYS C 135      -0.524  20.391  37.428  1.00 48.39           C  
ATOM   3560  C   LYS C 135      -1.053  19.074  37.949  1.00 49.89           C  
ATOM   3561  O   LYS C 135      -2.235  18.959  38.291  1.00 46.79           O  
ATOM   3562  CB  LYS C 135      -0.713  21.471  38.504  1.00 49.31           C  
ATOM   3563  CG  LYS C 135      -0.099  22.817  38.186  1.00 54.28           C  
ATOM   3564  CD  LYS C 135       0.277  23.522  39.491  1.00 64.70           C  
ATOM   3565  CE  LYS C 135       0.587  25.002  39.302  1.00 67.89           C  
ATOM   3566  NZ  LYS C 135       1.797  25.276  38.464  1.00 73.17           N  
ATOM   3567  N   LYS C 136      -0.172  18.084  37.998  1.00 53.15           N  
ATOM   3568  CA  LYS C 136      -0.525  16.761  38.480  1.00 56.24           C  
ATOM   3569  C   LYS C 136      -0.615  16.761  39.993  1.00 58.14           C  
ATOM   3570  O   LYS C 136       0.210  17.383  40.677  1.00 58.68           O  
ATOM   3571  CB  LYS C 136       0.490  15.722  37.996  1.00 62.50           C  
ATOM   3572  CG  LYS C 136       0.406  15.440  36.500  1.00 65.58           C  
ATOM   3573  N   ASN C 137      -1.632  16.073  40.509  1.00 56.80           N  
ATOM   3574  CA  ASN C 137      -1.845  15.954  41.952  1.00 58.59           C  
ATOM   3575  C   ASN C 137      -1.934  17.286  42.683  1.00 56.17           C  
ATOM   3576  O   ASN C 137      -1.444  17.427  43.805  1.00 58.72           O  
ATOM   3577  CB  ASN C 137      -0.780  15.052  42.577  1.00 64.90           C  
ATOM   3578  CG  ASN C 137      -0.897  13.623  42.101  1.00 72.52           C  
ATOM   3579  OD1 ASN C 137      -0.031  13.123  41.377  1.00 78.29           O  
ATOM   3580  ND2 ASN C 137      -1.991  12.961  42.478  1.00 75.41           N  
ATOM   3581  N   TYR C 138      -2.569  18.255  42.034  1.00 52.34           N  
ATOM   3582  CA  TYR C 138      -2.831  19.562  42.621  1.00 50.28           C  
ATOM   3583  C   TYR C 138      -3.848  19.442  43.774  1.00 52.29           C  
ATOM   3584  O   TYR C 138      -3.668  20.047  44.825  1.00 53.18           O  
ATOM   3585  CB  TYR C 138      -3.308  20.546  41.537  1.00 48.00           C  
ATOM   3586  CG  TYR C 138      -3.676  21.917  42.069  1.00 44.69           C  
ATOM   3587  CD1 TYR C 138      -2.696  22.866  42.355  1.00 48.89           C  
ATOM   3588  CD2 TYR C 138      -4.999  22.255  42.296  1.00 44.16           C  
ATOM   3589  CE1 TYR C 138      -3.034  24.127  42.844  1.00 49.97           C  
ATOM   3590  CE2 TYR C 138      -5.351  23.503  42.774  1.00 44.18           C  
ATOM   3591  CZ  TYR C 138      -4.367  24.436  43.049  1.00 50.00           C  
ATOM   3592  OH  TYR C 138      -4.728  25.673  43.544  1.00 52.82           O  
ATOM   3593  N   TYR C 139      -4.902  18.648  43.580  1.00 52.79           N  
ATOM   3594  CA  TYR C 139      -5.888  18.413  44.641  1.00 54.80           C  
ATOM   3595  C   TYR C 139      -5.531  17.210  45.502  1.00 59.73           C  
ATOM   3596  O   TYR C 139      -5.327  16.104  44.996  1.00 61.42           O  
ATOM   3597  CB  TYR C 139      -7.296  18.257  44.075  1.00 53.73           C  
ATOM   3598  CG  TYR C 139      -7.732  19.454  43.296  1.00 50.95           C  
ATOM   3599  CD1 TYR C 139      -8.115  20.630  43.945  1.00 52.02           C  
ATOM   3600  CD2 TYR C 139      -7.740  19.430  41.900  1.00 48.18           C  
ATOM   3601  CE1 TYR C 139      -8.508  21.737  43.220  1.00 50.46           C  
ATOM   3602  CE2 TYR C 139      -8.135  20.529  41.169  1.00 48.39           C  
ATOM   3603  CZ  TYR C 139      -8.510  21.690  41.839  1.00 50.10           C  
ATOM   3604  OH  TYR C 139      -8.897  22.800  41.130  1.00 46.62           O  
ATOM   3605  N   LYS C 140      -5.472  17.443  46.809  1.00 68.33           N  
ATOM   3606  CA  LYS C 140      -4.995  16.432  47.752  1.00 75.75           C  
ATOM   3607  C   LYS C 140      -6.046  15.386  48.123  1.00 78.28           C  
ATOM   3608  O   LYS C 140      -5.708  14.195  48.247  1.00 83.19           O  
ATOM   3609  CB  LYS C 140      -4.455  17.105  49.011  1.00 81.63           C  
ATOM   3610  CG  LYS C 140      -3.282  18.039  48.767  1.00 84.84           C  
ATOM   3611  CD  LYS C 140      -2.820  18.653  50.076  1.00 95.08           C  
ATOM   3612  CE  LYS C 140      -1.716  19.677  49.866  1.00100.18           C  
ATOM   3613  NZ  LYS C 140      -1.339  20.328  51.155  1.00110.93           N  
ATOM   3614  N   ARG C 141      -7.310  15.813  48.285  1.00 77.34           N  
ATOM   3615  CA  ARG C 141      -8.347  14.930  48.847  1.00 82.50           C  
ATOM   3616  C   ARG C 141      -9.496  14.492  47.898  1.00 81.08           C  
ATOM   3617  O   ARG C 141     -10.412  13.761  48.320  1.00 84.38           O  
ATOM   3618  CB  ARG C 141      -8.912  15.545  50.150  1.00 87.40           C  
ATOM   3619  N   ILE C 142      -9.442  14.923  46.628  1.00 73.93           N  
ATOM   3620  CA  ILE C 142     -10.505  14.634  45.645  1.00 73.44           C  
ATOM   3621  C   ILE C 142      -9.963  14.055  44.317  1.00 71.64           C  
ATOM   3622  O   ILE C 142      -8.719  14.011  44.083  1.00 72.50           O  
ATOM   3623  CB  ILE C 142     -11.385  15.908  45.356  1.00 70.37           C  
ATOM   3624  CG1 ILE C 142     -10.508  17.103  44.982  1.00 68.60           C  
ATOM   3625  CG2 ILE C 142     -12.263  16.257  46.561  1.00 74.53           C  
ATOM   3626  CD1 ILE C 142     -11.225  18.172  44.143  1.00 66.90           C  
ATOM   3627  N   GLU C 143     -10.900  13.631  43.429  1.00 71.11           N  
ATOM   3628  CA  GLU C 143     -10.557  13.072  42.106  1.00 69.86           C  
ATOM   3629  C   GLU C 143     -11.435  13.646  40.981  1.00 65.06           C  
ATOM   3630  O   GLU C 143     -12.632  13.849  41.192  1.00 66.90           O  
ATOM   3631  CB  GLU C 143     -10.706  11.542  42.117  1.00 78.26           C  
ATOM   3632  CG  GLU C 143     -10.054  10.826  43.307  1.00 89.03           C  
ATOM   3633  CD  GLU C 143      -8.602  10.450  43.059  1.00 94.50           C  
ATOM   3634  OE1 GLU C 143      -7.785  11.342  42.725  1.00 89.70           O  
ATOM   3635  OE2 GLU C 143      -8.278   9.249  43.218  1.00104.58           O  
ATOM   3636  N   PRO C 144     -10.854  13.898  39.777  1.00 59.51           N  
ATOM   3637  CA  PRO C 144      -9.429  13.860  39.387  1.00 57.12           C  
ATOM   3638  C   PRO C 144      -8.581  14.851  40.173  1.00 53.76           C  
ATOM   3639  O   PRO C 144      -9.030  15.950  40.459  1.00 55.24           O  
ATOM   3640  CB  PRO C 144      -9.446  14.246  37.897  1.00 55.03           C  
ATOM   3641  CG  PRO C 144     -10.788  14.805  37.642  1.00 52.33           C  
ATOM   3642  CD  PRO C 144     -11.721  14.173  38.617  1.00 58.43           C  
ATOM   3643  N   ALA C 145      -7.353  14.461  40.500  1.00 54.67           N  
ATOM   3644  CA  ALA C 145      -6.453  15.303  41.304  1.00 50.99           C  
ATOM   3645  C   ALA C 145      -5.755  16.409  40.502  1.00 46.00           C  
ATOM   3646  O   ALA C 145      -5.172  17.318  41.079  1.00 50.63           O  
ATOM   3647  CB  ALA C 145      -5.411  14.429  42.008  1.00 55.05           C  
ATOM   3648  N   ASP C 146      -5.807  16.338  39.178  1.00 58.79           N  
ATOM   3649  CA  ASP C 146      -5.046  17.272  38.357  1.00 52.12           C  
ATOM   3650  C   ASP C 146      -5.816  18.557  38.061  1.00 45.53           C  
ATOM   3651  O   ASP C 146      -7.037  18.537  37.989  1.00 43.53           O  
ATOM   3652  CB  ASP C 146      -4.641  16.613  37.045  1.00 51.64           C  
ATOM   3653  CG  ASP C 146      -4.101  15.203  37.244  1.00 62.22           C  
ATOM   3654  OD1 ASP C 146      -3.374  14.951  38.247  1.00 67.20           O  
ATOM   3655  OD2 ASP C 146      -4.424  14.342  36.398  1.00 66.09           O  
ATOM   3656  N   ALA C 147      -5.086  19.656  37.871  1.00 42.60           N  
ATOM   3657  CA  ALA C 147      -5.681  20.957  37.538  1.00 39.13           C  
ATOM   3658  C   ALA C 147      -4.960  21.633  36.392  1.00 36.92           C  
ATOM   3659  O   ALA C 147      -3.732  21.695  36.377  1.00 38.43           O  
ATOM   3660  CB  ALA C 147      -5.659  21.869  38.742  1.00 41.33           C  
ATOM   3661  N   HIS C 148      -5.727  22.166  35.450  1.00 34.29           N  
ATOM   3662  CA  HIS C 148      -5.155  23.006  34.405  1.00 34.20           C  
ATOM   3663  C   HIS C 148      -4.803  24.357  34.993  1.00 33.65           C  
ATOM   3664  O   HIS C 148      -5.507  24.839  35.895  1.00 35.46           O  
ATOM   3665  CB  HIS C 148      -6.170  23.211  33.278  1.00 33.82           C  
ATOM   3666  CG  HIS C 148      -6.493  21.973  32.508  1.00 37.00           C  
ATOM   3667  ND1 HIS C 148      -5.525  21.142  31.982  1.00 38.87           N  
ATOM   3668  CD2 HIS C 148      -7.683  21.443  32.140  1.00 38.71           C  
ATOM   3669  CE1 HIS C 148      -6.107  20.139  31.347  1.00 44.12           C  
ATOM   3670  NE2 HIS C 148      -7.416  20.303  31.420  1.00 42.85           N  
ATOM   3671  N   VAL C 149      -3.739  24.981  34.491  1.00 31.60           N  
ATOM   3672  CA  VAL C 149      -3.525  26.418  34.733  1.00 33.00           C  
ATOM   3673  C   VAL C 149      -4.051  27.158  33.495  1.00 31.15           C  
ATOM   3674  O   VAL C 149      -3.606  26.906  32.373  1.00 34.88           O  
ATOM   3675  CB  VAL C 149      -2.042  26.794  34.890  1.00 35.27           C  
ATOM   3676  CG1 VAL C 149      -1.903  28.320  35.150  1.00 35.02           C  
ATOM   3677  CG2 VAL C 149      -1.357  25.974  35.987  1.00 42.09           C  
ATOM   3678  N   LEU C 150      -5.020  28.041  33.725  1.00 31.69           N  
ATOM   3679  CA  LEU C 150      -5.661  28.825  32.681  1.00 30.14           C  
ATOM   3680  C   LEU C 150      -5.125  30.219  32.864  1.00 31.96           C  
ATOM   3681  O   LEU C 150      -5.211  30.750  33.958  1.00 31.91           O  
ATOM   3682  CB  LEU C 150      -7.181  28.783  32.862  1.00 33.18           C  
ATOM   3683  CG  LEU C 150      -7.585  27.595  31.974  1.00 38.43           C  
ATOM   3684  CD1 LEU C 150      -7.812  26.348  32.790  1.00 38.38           C  
ATOM   3685  CD2 LEU C 150      -8.689  27.892  31.070  1.00 44.01           C  
ATOM   3686  N   GLN C 151      -4.559  30.796  31.812  1.00 29.02           N  
ATOM   3687  CA  GLN C 151      -3.929  32.112  31.961  1.00 31.05           C  
ATOM   3688  C   GLN C 151      -4.284  33.038  30.809  1.00 32.01           C  
ATOM   3689  O   GLN C 151      -4.355  32.615  29.661  1.00 32.21           O  
ATOM   3690  CB  GLN C 151      -2.406  31.940  32.020  1.00 32.38           C  
ATOM   3691  CG  GLN C 151      -1.641  33.269  32.215  1.00 35.42           C  
ATOM   3692  CD  GLN C 151      -0.165  33.037  32.424  1.00 38.51           C  
ATOM   3693  OE1 GLN C 151       0.241  32.436  33.419  1.00 40.46           O  
ATOM   3694  NE2 GLN C 151       0.644  33.498  31.493  1.00 40.69           N  
ATOM   3695  N   LYS C 152      -4.528  34.308  31.119  1.00 31.87           N  
ATOM   3696  CA  LYS C 152      -4.709  35.311  30.090  1.00 33.46           C  
ATOM   3697  C   LYS C 152      -3.589  36.317  30.231  1.00 35.49           C  
ATOM   3698  O   LYS C 152      -3.391  36.885  31.302  1.00 31.04           O  
ATOM   3699  CB  LYS C 152      -6.054  36.032  30.248  1.00 35.52           C  
ATOM   3700  CG  LYS C 152      -6.363  36.998  29.109  1.00 37.80           C  
ATOM   3701  CD  LYS C 152      -7.742  37.643  29.222  1.00 44.02           C  
ATOM   3702  CE  LYS C 152      -7.982  38.512  27.982  1.00 45.79           C  
ATOM   3703  NZ  LYS C 152      -8.642  39.760  28.381  1.00 56.36           N  
ATOM   3704  N   ASN C 153      -2.845  36.546  29.145  1.00 35.49           N  
ATOM   3705  CA  ASN C 153      -1.783  37.534  29.169  1.00 39.73           C  
ATOM   3706  C   ASN C 153      -2.326  38.946  29.071  1.00 43.27           C  
ATOM   3707  O   ASN C 153      -3.256  39.215  28.309  1.00 44.71           O  
ATOM   3708  CB  ASN C 153      -0.800  37.292  28.013  1.00 45.65           C  
ATOM   3709  CG  ASN C 153       0.072  36.083  28.233  1.00 50.39           C  
ATOM   3710  OD1 ASN C 153       0.190  35.588  29.352  1.00 53.26           O  
ATOM   3711  ND2 ASN C 153       0.707  35.599  27.155  1.00 55.24           N  
ATOM   3712  N   LEU C 154      -1.751  39.849  29.860  1.00 44.04           N  
ATOM   3713  CA  LEU C 154      -2.207  41.229  29.887  1.00 48.73           C  
ATOM   3714  C   LEU C 154      -1.143  42.172  29.301  1.00 56.08           C  
ATOM   3715  O   LEU C 154      -1.443  43.315  28.976  1.00 57.96           O  
ATOM   3716  CB  LEU C 154      -2.647  41.630  31.308  1.00 44.72           C  
ATOM   3717  CG  LEU C 154      -3.794  40.812  31.906  1.00 44.95           C  
ATOM   3718  CD1 LEU C 154      -4.085  41.173  33.390  1.00 46.64           C  
ATOM   3719  CD2 LEU C 154      -5.046  40.957  31.035  1.00 45.85           C  
ATOM   3720  N   LYS C 155       0.089  41.674  29.164  1.00 53.20           N  
ATOM   3721  CA  LYS C 155       1.193  42.404  28.517  1.00 57.76           C  
ATOM   3722  C   LYS C 155       1.945  41.556  27.482  1.00 62.71           C  
ATOM   3723  O   LYS C 155       1.815  40.333  27.458  1.00 66.74           O  
ATOM   3724  CB  LYS C 155       2.186  42.916  29.557  1.00 58.42           C  
ATOM   3725  CG  LYS C 155       1.702  44.128  30.315  1.00 62.34           C  
ATOM   3726  CD  LYS C 155       2.774  44.601  31.285  1.00 68.69           C  
ATOM   3727  CE  LYS C 155       2.209  45.545  32.333  1.00 72.01           C  
ATOM   3728  NZ  LYS C 155       3.233  45.811  33.369  1.00 80.38           N  
ATOM   3729  N   VAL C 156       2.733  42.224  26.635  1.00 65.46           N  
ATOM   3730  CA  VAL C 156       3.589  41.568  25.631  1.00 71.04           C  
ATOM   3731  C   VAL C 156       4.728  40.732  26.257  1.00 75.05           C  
ATOM   3732  O   VAL C 156       5.111  40.967  27.406  1.00 74.29           O  
ATOM   3733  CB  VAL C 156       4.192  42.610  24.616  1.00 71.01           C  
ATOM   3734  CG1 VAL C 156       3.082  43.293  23.796  1.00 73.82           C  
ATOM   3735  CG2 VAL C 156       5.090  43.639  25.322  1.00 67.63           C  
ATOM   3736  N   PRO C 157       5.274  39.755  25.496  1.00 81.78           N  
ATOM   3737  CA  PRO C 157       6.381  38.900  25.949  1.00 88.90           C  
ATOM   3738  C   PRO C 157       7.537  39.626  26.658  1.00 88.78           C  
ATOM   3739  O   PRO C 157       7.897  40.755  26.291  1.00 83.18           O  
ATOM   3740  CB  PRO C 157       6.883  38.274  24.641  1.00 94.37           C  
ATOM   3741  CG  PRO C 157       5.658  38.161  23.810  1.00 94.46           C  
ATOM   3742  CD  PRO C 157       4.839  39.391  24.131  1.00 85.18           C  
ATOM   3743  N   SER C 158       8.108  38.961  27.661  1.00 96.35           N  
ATOM   3744  CA  SER C 158       9.231  39.491  28.434  1.00100.11           C  
ATOM   3745  C   SER C 158      10.461  39.675  27.550  1.00101.12           C  
ATOM   3746  O   SER C 158      10.905  38.729  26.893  1.00107.66           O  
ATOM   3747  CB  SER C 158       9.563  38.544  29.586  1.00111.66           C  
ATOM   3748  OG  SER C 158       8.381  37.984  30.136  1.00114.14           O  
ATOM   3749  N   GLY C 159      10.998  40.894  27.530  1.00 96.38           N  
ATOM   3750  CA  GLY C 159      12.183  41.213  26.728  1.00 96.09           C  
ATOM   3751  C   GLY C 159      11.890  41.874  25.390  1.00 88.55           C  
ATOM   3752  O   GLY C 159      12.800  42.442  24.763  1.00 86.38           O  
ATOM   3753  N   GLN C 160      10.629  41.794  24.950  1.00 84.43           N  
ATOM   3754  CA  GLN C 160      10.193  42.406  23.688  1.00 80.24           C  
ATOM   3755  C   GLN C 160      10.301  43.930  23.773  1.00 75.13           C  
ATOM   3756  O   GLN C 160       9.546  44.583  24.505  1.00 73.44           O  
ATOM   3757  CB  GLN C 160       8.769  41.969  23.309  1.00 80.40           C  
ATOM   3758  CG  GLN C 160       8.371  42.336  21.874  1.00 81.32           C  
ATOM   3759  CD  GLN C 160       7.040  41.738  21.444  1.00 85.16           C  
ATOM   3760  OE1 GLN C 160       6.859  40.516  21.446  1.00 91.97           O  
ATOM   3761  NE2 GLN C 160       6.105  42.599  21.057  1.00 84.70           N  
ATOM   3762  N   ASN C 161      11.249  44.481  23.017  1.00 72.39           N  
ATOM   3763  CA  ASN C 161      11.645  45.879  23.150  1.00 69.23           C  
ATOM   3764  C   ASN C 161      12.248  46.415  21.841  1.00 67.02           C  
ATOM   3765  O   ASN C 161      13.390  46.099  21.484  1.00 67.38           O  
ATOM   3766  CB  ASN C 161      12.617  46.034  24.333  1.00 72.53           C  
ATOM   3767  CG  ASN C 161      13.091  47.469  24.543  1.00 74.55           C  
ATOM   3768  OD1 ASN C 161      12.627  48.405  23.890  1.00 72.88           O  
ATOM   3769  ND2 ASN C 161      14.032  47.641  25.466  1.00 78.00           N  
ATOM   3770  N   ALA C 162      11.453  47.226  21.138  1.00 65.39           N  
ATOM   3771  CA  ALA C 162      11.860  47.884  19.900  1.00 64.69           C  
ATOM   3772  C   ALA C 162      13.188  48.647  20.015  1.00 64.90           C  
ATOM   3773  O   ALA C 162      13.947  48.750  19.045  1.00 67.07           O  
ATOM   3774  CB  ALA C 162      10.751  48.822  19.437  1.00 67.66           C  
ATOM   3775  N   ASP C 163      13.472  49.170  21.202  1.00 74.40           N  
ATOM   3776  CA  ASP C 163      14.626  50.047  21.396  1.00 75.05           C  
ATOM   3777  C   ASP C 163      16.006  49.373  21.327  1.00 70.05           C  
ATOM   3778  O   ASP C 163      17.027  50.060  21.192  1.00 72.81           O  
ATOM   3779  CB  ASP C 163      14.466  50.850  22.690  1.00 83.29           C  
ATOM   3780  CG  ASP C 163      13.274  51.798  22.645  1.00 91.80           C  
ATOM   3781  OD1 ASP C 163      12.984  52.360  21.560  1.00 92.98           O  
ATOM   3782  OD2 ASP C 163      12.628  51.979  23.704  1.00100.44           O  
ATOM   3783  N   VAL C 164      16.028  48.041  21.401  1.00 62.55           N  
ATOM   3784  CA  VAL C 164      17.277  47.286  21.274  1.00 62.15           C  
ATOM   3785  C   VAL C 164      17.245  46.332  20.072  1.00 57.97           C  
ATOM   3786  O   VAL C 164      18.143  45.498  19.914  1.00 59.24           O  
ATOM   3787  CB  VAL C 164      17.650  46.517  22.584  1.00 66.24           C  
ATOM   3788  CG1 VAL C 164      17.908  47.480  23.717  1.00 73.04           C  
ATOM   3789  CG2 VAL C 164      16.567  45.503  22.978  1.00 63.85           C  
ATOM   3790  N   GLN C 165      16.213  46.470  19.229  1.00 52.94           N  
ATOM   3791  CA  GLN C 165      16.067  45.631  18.043  1.00 50.28           C  
ATOM   3792  C   GLN C 165      16.897  46.163  16.876  1.00 51.60           C  
ATOM   3793  O   GLN C 165      17.357  47.314  16.877  1.00 54.44           O  
ATOM   3794  CB  GLN C 165      14.583  45.469  17.629  1.00 47.01           C  
ATOM   3795  CG  GLN C 165      13.828  44.492  18.518  1.00 49.83           C  
ATOM   3796  CD  GLN C 165      12.371  44.346  18.149  1.00 51.52           C  
ATOM   3797  OE1 GLN C 165      11.833  45.141  17.401  1.00 47.34           O  
ATOM   3798  NE2 GLN C 165      11.718  43.318  18.687  1.00 56.42           N  
ATOM   3799  N   LYS C 166      17.060  45.299  15.880  1.00 53.19           N  
ATOM   3800  CA  LYS C 166      17.751  45.603  14.643  1.00 54.31           C  
ATOM   3801  C   LYS C 166      16.750  45.568  13.474  1.00 50.62           C  
ATOM   3802  O   LYS C 166      15.768  44.821  13.514  1.00 48.59           O  
ATOM   3803  CB  LYS C 166      18.888  44.589  14.451  1.00 60.29           C  
ATOM   3804  CG  LYS C 166      19.806  44.869  13.284  1.00 66.06           C  
ATOM   3805  CD  LYS C 166      21.015  43.951  13.297  1.00 76.02           C  
ATOM   3806  CE  LYS C 166      21.566  43.800  11.886  1.00 84.08           C  
ATOM   3807  NZ  LYS C 166      22.870  43.078  11.885  1.00 98.72           N  
ATOM   3808  N   THR C 167      16.998  46.388  12.451  1.00 50.51           N  
ATOM   3809  CA  THR C 167      16.143  46.418  11.242  1.00 48.36           C  
ATOM   3810  C   THR C 167      16.131  45.044  10.559  1.00 49.29           C  
ATOM   3811  O   THR C 167      17.192  44.464  10.300  1.00 51.04           O  
ATOM   3812  CB  THR C 167      16.630  47.485  10.232  1.00 52.58           C  
ATOM   3813  OG1 THR C 167      16.771  48.752  10.895  1.00 54.64           O  
ATOM   3814  CG2 THR C 167      15.668  47.632   9.062  1.00 49.24           C  
ATOM   3815  N   ASP C 168      14.928  44.540  10.274  1.00 48.23           N  
ATOM   3816  CA  ASP C 168      14.750  43.219   9.663  1.00 52.03           C  
ATOM   3817  C   ASP C 168      13.513  43.224   8.782  1.00 52.80           C  
ATOM   3818  O   ASP C 168      12.388  43.015   9.272  1.00 54.55           O  
ATOM   3819  CB  ASP C 168      14.601  42.143  10.753  1.00 56.38           C  
ATOM   3820  CG  ASP C 168      14.441  40.730  10.189  1.00 66.60           C  
ATOM   3821  OD1 ASP C 168      14.725  40.497   8.989  1.00 69.54           O  
ATOM   3822  OD2 ASP C 168      14.038  39.835  10.970  1.00 74.68           O  
ATOM   3823  N   ASN C 169      13.716  43.446   7.486  1.00 51.94           N  
ATOM   3824  CA  ASN C 169      12.599  43.506   6.535  1.00 54.68           C  
ATOM   3825  C   ASN C 169      13.107  43.660   5.107  1.00 58.86           C  
ATOM   3826  O   ASN C 169      14.294  43.955   4.914  1.00 60.17           O  
ATOM   3827  CB  ASN C 169      11.640  44.652   6.895  1.00 51.16           C  
ATOM   3828  CG  ASN C 169      12.332  45.998   6.942  1.00 51.31           C  
ATOM   3829  OD1 ASN C 169      12.834  46.465   5.935  1.00 46.08           O  
ATOM   3830  ND2 ASN C 169      12.363  46.624   8.118  1.00 48.51           N  
TER    3831      ASN C 169                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
