
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  159 ( 1336),  selected  159 , name 2fia_B
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2fia_B.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    M     1_B      I       3          2.897
LGA    K     2_B      N       4          1.875
LGA    I     3_B      I       5          1.691
LGA    R     4_B      I       6          2.224
LGA    V     5_B      E       7          2.001
LGA    A     6_B      Y       8          0.971
LGA    D     7_B      N       9          0.976
LGA    E     8_B      R      10          1.084
LGA    K     9_B      S      11          1.498
LGA    E    10_B      Y      12          1.631
LGA    L    11_B      K      13          1.175
LGA    P    12_B      E      14          1.774
LGA    M    13_B      E      15          1.514
LGA    I    14_B      L      16          1.252
LGA    L    15_B      I      17          2.202
LGA    Q    16_B      E      18          2.361
LGA    F    17_B      F      19          1.196
LGA    L    18_B      I      20          1.817
LGA    T    19_B      L      21          3.293
LGA    E    20_B      S      22          2.673
LGA    V    21_B      I      23          1.267
LGA    K    22_B      Q      24          2.504
LGA    A    23_B      K      25          4.385
LGA    Y    24_B      N      26          4.984
LGA    M    25_B      E      27          3.342
LGA    D    26_B      F      28          2.741
LGA    V    27_B      N      29          6.091
LGA    V    28_B      -       -           -
LGA    G    29_B      -       -           -
LGA    I    30_B      -       -           -
LGA    T    31_B      -       -           -
LGA    Q    32_B      I      30          3.997
LGA    W    33_B      K      31          5.316
LGA    T    34_B      I      32          1.247
LGA    K    35_B      D      33          2.141
LGA    D    36_B      R      34          3.278
LGA    Y    37_B      D      35          5.744
LGA    P    38_B      D      36          5.584
LGA    S    39_B      Q      37          3.986
LGA    Q    40_B      -       -           -
LGA    G    41_B      P      38          2.988
LGA    D    42_B      D      39          2.270
LGA    I    43_B      L      40          0.918
LGA    Q    44_B      E      41          2.235
LGA    E    45_B      N      42          2.918
LGA    D    46_B      I      43          2.309
LGA    I    47_B      E      44          2.546
LGA    T    48_B      H      45          2.276
LGA    K    49_B      N      46          3.437
LGA    K    50_B      Y      47          4.309
LGA    R    51_B      L      48          3.417
LGA    -       -      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    -       -      Q      53           -
LGA    L    52_B      F      54          2.608
LGA    Y    53_B      W      55          1.889
LGA    L    54_B      L      56          1.008
LGA    L    55_B      A      57          1.125
LGA    V    56_B      I      58          1.763
LGA    H    57_B      N      59          3.424
LGA    -       -      N      60           -
LGA    E    58_B      H      61          5.354
LGA    E    59_B      Q      62          2.877
LGA    M    60_B      N      63          0.954
LGA    I    61_B      I      64          0.520
LGA    F    62_B      V      65          1.027
LGA    S    63_B      G      66          0.655
LGA    M    64_B      T      67          0.782
LGA    A    65_B      I      68          1.728
LGA    T    66_B      G      69          1.539
LGA    F    67_B      L      70          0.897
LGA    C    68_B      I      71          1.106
LGA    M    69_B      R      72          1.931
LGA    E    70_B      L      73          4.343
LGA    Q    71_B      -       -           -
LGA    E    72_B      D      74           #
LGA    Q    73_B      N      75          2.955
LGA    D    74_B      N      76          1.678
LGA    F    75_B      M      77          1.451
LGA    V    76_B      S      78          1.564
LGA    W    77_B      A      79          0.931
LGA    L    78_B      L      80          0.349
LGA    K    79_B      K      81          1.101
LGA    R    80_B      K      82          1.761
LGA    F    81_B      M      83          1.327
LGA    A    82_B      F      84          1.127
LGA    T    83_B      V      85          1.078
LGA    S    84_B      D      86          1.305
LGA    P    85_B      K      87          1.194
LGA    N    86_B      G      88          1.325
LGA    Y    87_B      Y      89          0.976
LGA    I    88_B      R      90          1.146
LGA    A    89_B      N      91          1.997
LGA    K    90_B      L      92          1.582
LGA    G    91_B      K      93          2.337
LGA    Y    92_B      I      94          0.954
LGA    G    93_B      G      95          1.422
LGA    S    94_B      K      96          1.508
LGA    L    95_B      K      97          1.037
LGA    L    96_B      L      98          0.508
LGA    F    97_B      L      99          0.982
LGA    H    98_B      D     100          1.207
LGA    E    99_B      K     101          0.940
LGA    L   100_B      V     102          0.593
LGA    E   101_B      I     103          0.933
LGA    K   102_B      M     104          1.125
LGA    R   103_B      T     105          0.842
LGA    A   104_B      C     106          0.567
LGA    V   105_B      K     107          1.539
LGA    W   106_B      E     108          1.939
LGA    E   107_B      Q     109          1.321
LGA    G   108_B      N     110          1.076
LGA    R   109_B      I     111          1.426
LGA    R   110_B      D     112          1.406
LGA    K   111_B      G     113          0.876
LGA    M   112_B      I     114          0.826
LGA    Y   113_B      Y     115          0.733
LGA    A   114_B      L     116          1.025
LGA    Q   115_B      G     117          1.241
LGA    T   116_B      T     118          0.795
LGA    N   117_B      I     119          1.235
LGA    H   118_B      D     120          2.512
LGA    T   119_B      K     121          2.531
LGA    N   120_B      F     122          2.166
LGA    H   121_B      I     123          1.937
LGA    R   122_B      S     124          1.023
LGA    M   123_B      A     125          1.397
LGA    I   124_B      Q     126          1.227
LGA    R   125_B      Y     127          0.789
LGA    F   126_B      F     128          0.998
LGA    F   127_B      Y     129          1.008
LGA    E   128_B      S     130          0.694
LGA    S   129_B      N     131          0.699
LGA    K   130_B      N     132          0.669
LGA    G   131_B      G     133          1.389
LGA    F   132_B      F     134          0.853
LGA    T   133_B      R     135          0.897
LGA    K   134_B      E     136          0.909
LGA    I   135_B      I     137          1.115
LGA    H   136_B      K     138          0.477
LGA    E   137_B      R     139          3.756
LGA    S   138_B      G     140           #
LGA    -       -      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    L   139_B      L     149           #
LGA    Q   140_B      D     150          2.323
LGA    M   141_B      -       -           -
LGA    N   142_B      -       -           -
LGA    R   143_B      V     151          3.855
LGA    L   144_B      -       -           -
LGA    D   145_B      -       -           -
LGA    F   146_B      -       -           -
LGA    G   147_B      -       -           -
LGA    S   148_B      D     152           #
LGA    F   149_B      N     153          0.961
LGA    Y   150_B      R     154          1.386
LGA    L   151_B      F     155          1.385
LGA    Y   152_B      Y     156          0.543
LGA    V   153_B      Y     157          0.502
LGA    K   154_B      R     158          0.715
LGA    E   155_B      N     159          0.969
LGA    L   156_B      L     160          0.879
LGA    E   157_B      K     161          3.281
LGA    N   158_B      -       -           -
LGA    Q   159_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  159  160    5.0    141    2.19    12.77     68.599     6.170

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.427648 * X  +   0.596897 * Y  +  -0.678845 * Z  + -63.520561
  Y_new =  -0.862149 * X  +   0.495047 * Y  +  -0.107836 * Z  +   7.824886
  Z_new =   0.271693 * X  +   0.631381 * Y  +   0.726320 * Z  + -20.470478 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.715586   -2.426007  [ DEG:    41.0001   -138.9999 ]
  Theta =  -0.275152   -2.866440  [ DEG:   -15.7651   -164.2349 ]
  Phi   =  -1.110333    2.031259  [ DEG:   -63.6174    116.3826 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fia_B                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fia_B.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  159  160   5.0  141   2.19   12.77  68.599
REMARK  ---------------------------------------------------------- 
MOLECULE 2fia_B
HEADER    TRANSFERASE                             28-DEC-05   2FIA              
TITLE     THE CRYSTAL STRUCTURE OF THE ACETYLTRANSFERASE FROM                   
TITLE    2 ENTEROCOCCUS FAECALIS                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: V583;                                                        
SOURCE   5 GENE: GI:29343911;                                                   
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    ACETYLTRANSFERASE, STRUCTURAL GENOMICS , PSI, PROTEIN                 
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,M.ZHOU,S.MOY,F.COLLART,A.JOACHIMIAK,MIDWEST CENTER            
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   14-FEB-06 2FIA    0                                                
JRNL        AUTH   R.ZHANG,M.ZHOU,S.MOY,F.COLLART,A.JOACHIMIAK                  
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE ACETYLTRANSFERASE               
JRNL        TITL 2 FROM ENTEROCOCCUS FAECALIS                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2FIA A    1   162  GB     29343911 AAO81671         1    162             
DBREF  2FIA B    1   162  GB     29343911 AAO81671         1    162             
SEQRES   1 A  162  MET LYS ILE ARG VAL ALA ASP GLU LYS GLU LEU PRO MET          
SEQRES   2 A  162  ILE LEU GLN PHE LEU THR GLU VAL LYS ALA TYR MET ASP          
SEQRES   3 A  162  VAL VAL GLY ILE THR GLN TRP THR LYS ASP TYR PRO SER          
SEQRES   4 A  162  GLN GLY ASP ILE GLN GLU ASP ILE THR LYS LYS ARG LEU          
SEQRES   5 A  162  TYR LEU LEU VAL HIS GLU GLU MET ILE PHE SER MET ALA          
SEQRES   6 A  162  THR PHE CYS MET GLU GLN GLU GLN ASP PHE VAL TRP LEU          
SEQRES   7 A  162  LYS ARG PHE ALA THR SER PRO ASN TYR ILE ALA LYS GLY          
SEQRES   8 A  162  TYR GLY SER LEU LEU PHE HIS GLU LEU GLU LYS ARG ALA          
SEQRES   9 A  162  VAL TRP GLU GLY ARG ARG LYS MET TYR ALA GLN THR ASN          
SEQRES  10 A  162  HIS THR ASN HIS ARG MET ILE ARG PHE PHE GLU SER LYS          
SEQRES  11 A  162  GLY PHE THR LYS ILE HIS GLU SER LEU GLN MET ASN ARG          
SEQRES  12 A  162  LEU ASP PHE GLY SER PHE TYR LEU TYR VAL LYS GLU LEU          
SEQRES  13 A  162  GLU ASN GLN SER ILE VAL                                      
SEQRES   1 B  162  MET LYS ILE ARG VAL ALA ASP GLU LYS GLU LEU PRO MET          
SEQRES   2 B  162  ILE LEU GLN PHE LEU THR GLU VAL LYS ALA TYR MET ASP          
SEQRES   3 B  162  VAL VAL GLY ILE THR GLN TRP THR LYS ASP TYR PRO SER          
SEQRES   4 B  162  GLN GLY ASP ILE GLN GLU ASP ILE THR LYS LYS ARG LEU          
SEQRES   5 B  162  TYR LEU LEU VAL HIS GLU GLU MET ILE PHE SER MET ALA          
SEQRES   6 B  162  THR PHE CYS MET GLU GLN GLU GLN ASP PHE VAL TRP LEU          
SEQRES   7 B  162  LYS ARG PHE ALA THR SER PRO ASN TYR ILE ALA LYS GLY          
SEQRES   8 B  162  TYR GLY SER LEU LEU PHE HIS GLU LEU GLU LYS ARG ALA          
SEQRES   9 B  162  VAL TRP GLU GLY ARG ARG LYS MET TYR ALA GLN THR ASN          
SEQRES  10 B  162  HIS THR ASN HIS ARG MET ILE ARG PHE PHE GLU SER LYS          
SEQRES  11 B  162  GLY PHE THR LYS ILE HIS GLU SER LEU GLN MET ASN ARG          
SEQRES  12 B  162  LEU ASP PHE GLY SER PHE TYR LEU TYR VAL LYS GLU LEU          
SEQRES  13 B  162  GLU ASN GLN SER ILE VAL                                      
FORMUL   3  HOH   *160(H2 O)                                                    
CRYST1  122.679   79.658   83.871  90.00 130.54  90.00 C 1 2 1       8          
ATOM   1321  N   MET B   1     -27.074  42.369  42.098  1.00 81.13           N  
ATOM   1322  CA  MET B   1     -26.335  43.032  40.997  1.00 80.94           C  
ATOM   1323  C   MET B   1     -26.339  44.494  41.409  1.00 81.01           C  
ATOM   1324  O   MET B   1     -27.413  45.105  41.416  1.00 81.27           O  
ATOM   1325  CB  MET B   1     -27.039  42.829  39.638  1.00 80.71           C  
ATOM   1326  CG  MET B   1     -27.909  41.561  39.497  1.00 79.48           C  
ATOM   1327  SD  MET B   1     -27.016  40.059  39.108  1.00 76.44           S  
ATOM   1328  CE  MET B   1     -26.909  40.288  37.339  1.00 76.67           C  
ATOM   1329  N   LYS B   2     -25.176  45.084  41.706  1.00 80.87           N  
ATOM   1330  CA  LYS B   2     -23.885  44.701  41.128  1.00 80.70           C  
ATOM   1331  C   LYS B   2     -22.777  44.208  42.097  1.00 80.54           C  
ATOM   1332  O   LYS B   2     -23.054  43.605  43.145  1.00 80.33           O  
ATOM   1333  CB  LYS B   2     -23.385  45.878  40.283  1.00 80.82           C  
ATOM   1334  N   ILE B   3     -21.528  44.503  41.719  1.00 80.36           N  
ATOM   1335  CA  ILE B   3     -20.336  43.784  42.159  1.00 80.28           C  
ATOM   1336  C   ILE B   3     -19.479  44.642  43.059  1.00 80.12           C  
ATOM   1337  O   ILE B   3     -19.117  45.746  42.684  1.00 80.33           O  
ATOM   1338  CB  ILE B   3     -19.457  43.433  40.936  1.00 80.30           C  
ATOM   1339  CG1 ILE B   3     -20.243  42.591  39.924  1.00 80.24           C  
ATOM   1340  CG2 ILE B   3     -18.189  42.701  41.362  1.00 80.39           C  
ATOM   1341  CD1 ILE B   3     -19.798  42.785  38.492  1.00 80.13           C  
ATOM   1342  N   ARG B   4     -19.103  44.120  44.217  1.00 79.98           N  
ATOM   1343  CA  ARG B   4     -18.398  44.917  45.207  1.00 80.04           C  
ATOM   1344  C   ARG B   4     -17.595  44.034  46.127  1.00 80.45           C  
ATOM   1345  O   ARG B   4     -17.892  42.852  46.260  1.00 80.32           O  
ATOM   1346  CB  ARG B   4     -19.402  45.691  46.047  1.00 79.70           C  
ATOM   1347  CG  ARG B   4     -20.394  44.799  46.780  1.00 79.40           C  
ATOM   1348  CD  ARG B   4     -21.261  45.567  47.743  1.00 78.83           C  
ATOM   1349  NE  ARG B   4     -22.265  44.707  48.368  1.00 78.22           N  
ATOM   1350  CZ  ARG B   4     -22.032  43.836  49.353  1.00 77.12           C  
ATOM   1351  NH1 ARG B   4     -23.035  43.117  49.832  1.00 77.56           N  
ATOM   1352  NH2 ARG B   4     -20.815  43.667  49.854  1.00 75.91           N  
ATOM   1353  N   VAL B   5     -16.605  44.624  46.792  1.00 81.13           N  
ATOM   1354  CA  VAL B   5     -15.789  43.889  47.754  1.00 81.80           C  
ATOM   1355  C   VAL B   5     -16.740  43.376  48.824  1.00 82.34           C  
ATOM   1356  O   VAL B   5     -17.745  44.011  49.100  1.00 82.27           O  
ATOM   1357  CB  VAL B   5     -14.667  44.762  48.392  1.00 81.72           C  
ATOM   1358  CG1 VAL B   5     -13.744  43.903  49.248  1.00 81.78           C  
ATOM   1359  CG2 VAL B   5     -13.845  45.493  47.325  1.00 81.71           C  
ATOM   1360  N   ALA B   6     -16.457  42.212  49.392  1.00 83.27           N  
ATOM   1361  CA  ALA B   6     -17.319  41.657  50.433  1.00 84.08           C  
ATOM   1362  C   ALA B   6     -17.030  42.326  51.762  1.00 84.82           C  
ATOM   1363  O   ALA B   6     -15.877  42.606  52.087  1.00 84.65           O  
ATOM   1364  CB  ALA B   6     -17.122  40.157  50.563  1.00 84.02           C  
ATOM   1365  N   ASP B   7     -18.091  42.578  52.521  1.00 85.98           N  
ATOM   1366  CA  ASP B   7     -17.982  43.032  53.905  1.00 86.58           C  
ATOM   1367  C   ASP B   7     -17.759  41.815  54.790  1.00 87.21           C  
ATOM   1368  O   ASP B   7     -18.116  40.706  54.419  1.00 87.65           O  
ATOM   1369  CB  ASP B   7     -19.262  43.768  54.333  1.00 86.71           C  
ATOM   1370  CG  ASP B   7     -19.064  44.604  55.581  1.00 86.77           C  
ATOM   1371  OD1 ASP B   7     -19.936  44.557  56.481  1.00 88.02           O  
ATOM   1372  OD2 ASP B   7     -18.028  45.301  55.664  1.00 87.08           O  
ATOM   1373  N   GLU B   8     -17.178  42.011  55.964  1.00 87.79           N  
ATOM   1374  CA  GLU B   8     -16.998  40.894  56.876  1.00 88.24           C  
ATOM   1375  C   GLU B   8     -18.309  40.520  57.555  1.00 88.54           C  
ATOM   1376  O   GLU B   8     -18.367  39.490  58.234  1.00 88.41           O  
ATOM   1377  CB  GLU B   8     -15.914  41.187  57.917  1.00 88.36           C  
ATOM   1378  CG  GLU B   8     -16.278  42.227  58.967  1.00 88.76           C  
ATOM   1379  CD  GLU B   8     -15.079  42.638  59.811  1.00 88.87           C  
ATOM   1380  OE1 GLU B   8     -15.076  42.350  61.032  1.00 89.24           O  
ATOM   1381  OE2 GLU B   8     -14.137  43.241  59.249  1.00 89.42           O  
ATOM   1382  N   LYS B   9     -19.364  41.325  57.362  1.00 88.82           N  
ATOM   1383  CA  LYS B   9     -20.638  41.020  58.018  1.00 89.03           C  
ATOM   1384  C   LYS B   9     -21.098  39.597  57.737  1.00 88.89           C  
ATOM   1385  O   LYS B   9     -21.800  39.011  58.557  1.00 88.83           O  
ATOM   1386  CB  LYS B   9     -21.687  42.143  57.940  1.00 89.40           C  
ATOM   1387  CG  LYS B   9     -21.517  43.158  59.125  1.00 90.02           C  
ATOM   1388  CD  LYS B   9     -20.864  42.478  60.389  1.00 90.66           C  
ATOM   1389  CE  LYS B   9     -21.239  43.086  61.742  1.00 90.62           C  
ATOM   1390  NZ  LYS B   9     -20.992  42.086  62.842  1.00 90.66           N  
ATOM   1391  N   GLU B  10     -20.786  39.047  56.567  1.00 88.59           N  
ATOM   1392  CA  GLU B  10     -21.710  38.768  55.485  1.00 88.14           C  
ATOM   1393  C   GLU B  10     -21.304  37.295  55.430  1.00 88.01           C  
ATOM   1394  O   GLU B  10     -21.847  36.500  54.672  1.00 88.04           O  
ATOM   1395  CB  GLU B  10     -21.364  39.355  54.133  1.00 88.05           C  
ATOM   1396  CG  GLU B  10     -21.335  40.826  54.030  1.00 87.93           C  
ATOM   1397  CD  GLU B  10     -21.417  41.249  52.580  1.00 87.86           C  
ATOM   1398  OE1 GLU B  10     -22.498  41.094  51.990  1.00 87.28           O  
ATOM   1399  OE2 GLU B  10     -20.406  41.713  52.022  1.00 88.04           O  
ATOM   1400  N   LEU B  11     -20.318  36.968  56.272  1.00 87.67           N  
ATOM   1401  CA  LEU B  11     -19.519  35.769  56.193  1.00 87.50           C  
ATOM   1402  C   LEU B  11     -20.381  34.532  56.269  1.00 87.36           C  
ATOM   1403  O   LEU B  11     -20.212  33.624  55.465  1.00 87.48           O  
ATOM   1404  CB  LEU B  11     -18.466  35.774  57.312  1.00 87.45           C  
ATOM   1405  CG  LEU B  11     -17.835  34.449  57.745  1.00 87.52           C  
ATOM   1406  CD1 LEU B  11     -16.365  34.651  58.060  1.00 87.55           C  
ATOM   1407  CD2 LEU B  11     -18.567  33.834  58.947  1.00 87.53           C  
ATOM   1408  N   PRO B  12     -21.325  34.492  57.221  1.00 87.10           N  
ATOM   1409  CA  PRO B  12     -22.128  33.276  57.310  1.00 86.69           C  
ATOM   1410  C   PRO B  12     -22.967  33.084  56.050  1.00 86.24           C  
ATOM   1411  O   PRO B  12     -23.285  31.956  55.681  1.00 86.22           O  
ATOM   1412  CB  PRO B  12     -23.014  33.523  58.539  1.00 86.82           C  
ATOM   1413  CG  PRO B  12     -22.378  34.664  59.263  1.00 86.96           C  
ATOM   1414  CD  PRO B  12     -21.738  35.493  58.220  1.00 87.06           C  
ATOM   1415  N   MET B  13     -23.297  34.190  55.395  1.00 85.60           N  
ATOM   1416  CA  MET B  13     -24.015  34.160  54.141  1.00 85.15           C  
ATOM   1417  C   MET B  13     -23.133  33.539  53.052  1.00 84.51           C  
ATOM   1418  O   MET B  13     -23.559  32.614  52.355  1.00 84.62           O  
ATOM   1419  CB  MET B  13     -24.410  35.582  53.767  1.00 85.26           C  
ATOM   1420  CG  MET B  13     -25.589  35.725  52.845  1.00 85.67           C  
ATOM   1421  SD  MET B  13     -25.417  37.283  51.955  1.00 86.10           S  
ATOM   1422  CE  MET B  13     -24.978  38.434  53.279  1.00 86.41           C  
ATOM   1423  N   ILE B  14     -21.903  34.034  52.918  1.00 83.52           N  
ATOM   1424  CA  ILE B  14     -20.982  33.513  51.907  1.00 82.68           C  
ATOM   1425  C   ILE B  14     -20.525  32.106  52.290  1.00 81.68           C  
ATOM   1426  O   ILE B  14     -20.331  31.251  51.432  1.00 81.56           O  
ATOM   1427  CB  ILE B  14     -19.755  34.457  51.643  1.00 82.69           C  
ATOM   1428  CG1 ILE B  14     -18.762  34.434  52.797  1.00 83.01           C  
ATOM   1429  CG2 ILE B  14     -20.204  35.892  51.357  1.00 82.67           C  
ATOM   1430  CD1 ILE B  14     -17.867  35.682  52.877  1.00 83.20           C  
ATOM   1431  N   LEU B  15     -20.380  31.860  53.584  1.00 80.58           N  
ATOM   1432  CA  LEU B  15     -20.033  30.534  54.071  1.00 79.87           C  
ATOM   1433  C   LEU B  15     -21.139  29.530  53.696  1.00 78.95           C  
ATOM   1434  O   LEU B  15     -20.863  28.355  53.467  1.00 78.72           O  
ATOM   1435  CB  LEU B  15     -19.813  30.567  55.586  1.00 79.87           C  
ATOM   1436  CG  LEU B  15     -18.682  29.728  56.178  1.00 80.36           C  
ATOM   1437  CD1 LEU B  15     -17.328  30.182  55.658  1.00 80.53           C  
ATOM   1438  CD2 LEU B  15     -18.707  29.812  57.708  1.00 80.30           C  
ATOM   1439  N   GLN B  16     -22.385  29.999  53.623  1.00 77.93           N  
ATOM   1440  CA  GLN B  16     -23.495  29.164  53.151  1.00 77.02           C  
ATOM   1441  C   GLN B  16     -23.252  28.879  51.682  1.00 75.92           C  
ATOM   1442  O   GLN B  16     -23.096  27.730  51.277  1.00 75.84           O  
ATOM   1443  CB  GLN B  16     -24.860  29.868  53.323  1.00 77.25           C  
ATOM   1444  CG  GLN B  16     -25.973  29.023  53.973  1.00 78.11           C  
ATOM   1445  CD  GLN B  16     -26.010  27.564  53.513  1.00 79.41           C  
ATOM   1446  OE1 GLN B  16     -25.848  26.648  54.326  1.00 80.25           O  
ATOM   1447  NE2 GLN B  16     -26.218  27.345  52.216  1.00 79.72           N  
ATOM   1448  N   PHE B  17     -23.195  29.961  50.909  1.00 74.61           N  
ATOM   1449  CA  PHE B  17     -22.941  29.932  49.470  1.00 73.79           C  
ATOM   1450  C   PHE B  17     -21.945  28.873  49.049  1.00 72.77           C  
ATOM   1451  O   PHE B  17     -22.229  28.107  48.137  1.00 72.80           O  
ATOM   1452  CB  PHE B  17     -22.434  31.301  48.998  1.00 73.37           C  
ATOM   1453  CG  PHE B  17     -22.097  31.366  47.529  1.00 74.06           C  
ATOM   1454  CD1 PHE B  17     -23.027  31.832  46.607  1.00 69.13           C  
ATOM   1455  CD2 PHE B  17     -20.835  30.997  47.074  1.00 76.50           C  
ATOM   1456  CE1 PHE B  17     -22.710  31.914  45.251  1.00 70.64           C  
ATOM   1457  CE2 PHE B  17     -20.516  31.073  45.724  1.00 75.01           C  
ATOM   1458  CZ  PHE B  17     -21.457  31.534  44.813  1.00 73.40           C  
ATOM   1459  N   LEU B  18     -20.773  28.822  49.671  1.00 71.47           N  
ATOM   1460  CA  LEU B  18     -19.800  27.860  49.189  1.00 70.79           C  
ATOM   1461  C   LEU B  18     -20.057  26.436  49.687  1.00 69.86           C  
ATOM   1462  O   LEU B  18     -19.460  25.493  49.178  1.00 69.85           O  
ATOM   1463  CB  LEU B  18     -18.335  28.319  49.355  1.00 70.91           C  
ATOM   1464  CG  LEU B  18     -17.774  28.966  50.608  1.00 71.09           C  
ATOM   1465  CD1 LEU B  18     -18.039  28.096  51.783  1.00 71.70           C  
ATOM   1466  CD2 LEU B  18     -16.289  29.171  50.424  1.00 70.82           C  
ATOM   1467  N   THR B  19     -20.964  26.264  50.643  1.00 68.78           N  
ATOM   1468  CA  THR B  19     -21.425  24.914  50.989  1.00 68.05           C  
ATOM   1469  C   THR B  19     -22.356  24.362  49.901  1.00 66.94           C  
ATOM   1470  O   THR B  19     -22.323  23.170  49.599  1.00 66.23           O  
ATOM   1471  CB  THR B  19     -22.085  24.873  52.379  1.00 68.14           C  
ATOM   1472  OG1 THR B  19     -21.063  25.003  53.373  1.00 68.60           O  
ATOM   1473  CG2 THR B  19     -22.813  23.556  52.617  1.00 68.33           C  
ATOM   1474  N   GLU B  20     -23.161  25.240  49.309  1.00 66.05           N  
ATOM   1475  CA  GLU B  20     -24.037  24.865  48.198  1.00 65.67           C  
ATOM   1476  C   GLU B  20     -23.241  24.572  46.935  1.00 64.63           C  
ATOM   1477  O   GLU B  20     -23.534  23.607  46.222  1.00 64.89           O  
ATOM   1478  CB  GLU B  20     -25.080  25.953  47.927  1.00 65.80           C  
ATOM   1479  CG  GLU B  20     -26.127  26.059  49.052  1.00 67.14           C  
ATOM   1480  CD  GLU B  20     -26.920  27.370  49.038  1.00 67.82           C  
ATOM   1481  OE1 GLU B  20     -27.106  27.958  47.937  1.00 70.54           O  
ATOM   1482  OE2 GLU B  20     -27.361  27.804  50.135  1.00 69.72           O  
ATOM   1483  N   VAL B  21     -22.230  25.396  46.672  1.00 63.19           N  
ATOM   1484  CA  VAL B  21     -21.342  25.198  45.528  1.00 61.90           C  
ATOM   1485  C   VAL B  21     -20.541  23.910  45.718  1.00 60.68           C  
ATOM   1486  O   VAL B  21     -20.299  23.196  44.765  1.00 60.43           O  
ATOM   1487  CB  VAL B  21     -20.406  26.443  45.297  1.00 61.70           C  
ATOM   1488  CG1 VAL B  21     -19.251  26.119  44.362  1.00 61.32           C  
ATOM   1489  CG2 VAL B  21     -21.205  27.618  44.745  1.00 61.12           C  
ATOM   1490  N   LYS B  22     -20.150  23.602  46.944  1.00 59.69           N  
ATOM   1491  CA  LYS B  22     -19.406  22.376  47.203  1.00 59.16           C  
ATOM   1492  C   LYS B  22     -20.270  21.140  47.037  1.00 58.32           C  
ATOM   1493  O   LYS B  22     -19.762  20.070  46.725  1.00 58.18           O  
ATOM   1494  CB  LYS B  22     -18.797  22.380  48.604  1.00 59.26           C  
ATOM   1495  CG  LYS B  22     -17.494  23.162  48.712  1.00 59.72           C  
ATOM   1496  CD  LYS B  22     -16.952  23.118  50.124  1.00 59.53           C  
ATOM   1497  CE  LYS B  22     -16.074  24.311  50.431  1.00 59.81           C  
ATOM   1498  NZ  LYS B  22     -15.462  24.193  51.780  1.00 60.45           N  
ATOM   1499  N   ALA B  23     -21.570  21.285  47.265  1.00 57.54           N  
ATOM   1500  CA  ALA B  23     -22.494  20.178  47.111  1.00 56.94           C  
ATOM   1501  C   ALA B  23     -22.673  19.883  45.620  1.00 56.46           C  
ATOM   1502  O   ALA B  23     -22.512  18.743  45.188  1.00 56.28           O  
ATOM   1503  CB  ALA B  23     -23.809  20.512  47.755  1.00 56.75           C  
ATOM   1504  N   TYR B  24     -22.991  20.921  44.846  1.00 55.83           N  
ATOM   1505  CA  TYR B  24     -23.065  20.842  43.385  1.00 55.28           C  
ATOM   1506  C   TYR B  24     -21.822  20.192  42.793  1.00 54.71           C  
ATOM   1507  O   TYR B  24     -21.906  19.207  42.060  1.00 54.72           O  
ATOM   1508  CB  TYR B  24     -23.229  22.246  42.819  1.00 55.73           C  
ATOM   1509  CG  TYR B  24     -23.022  22.365  41.332  1.00 56.08           C  
ATOM   1510  CD1 TYR B  24     -24.060  22.113  40.441  1.00 56.45           C  
ATOM   1511  CD2 TYR B  24     -21.800  22.763  40.814  1.00 56.47           C  
ATOM   1512  CE1 TYR B  24     -23.884  22.240  39.067  1.00 56.27           C  
ATOM   1513  CE2 TYR B  24     -21.609  22.889  39.444  1.00 56.66           C  
ATOM   1514  CZ  TYR B  24     -22.655  22.628  38.576  1.00 56.63           C  
ATOM   1515  OH  TYR B  24     -22.461  22.761  37.216  1.00 56.63           O  
ATOM   1516  N   MET B  25     -20.672  20.767  43.123  1.00 54.18           N  
ATOM   1517  CA  MET B  25     -19.361  20.241  42.735  1.00 53.23           C  
ATOM   1518  C   MET B  25     -19.356  18.728  42.958  1.00 53.63           C  
ATOM   1519  O   MET B  25     -18.954  17.953  42.089  1.00 53.65           O  
ATOM   1520  CB  MET B  25     -18.273  20.905  43.595  1.00 53.16           C  
ATOM   1521  CG  MET B  25     -16.997  21.353  42.884  1.00 51.92           C  
ATOM   1522  SD  MET B  25     -16.180  22.725  43.745  1.00 48.38           S  
ATOM   1523  CE  MET B  25     -17.188  24.012  43.123  1.00 47.51           C  
ATOM   1524  N   ASP B  26     -19.845  18.323  44.123  1.00 53.95           N  
ATOM   1525  CA  ASP B  26     -19.850  16.919  44.522  1.00 53.79           C  
ATOM   1526  C   ASP B  26     -20.733  16.001  43.643  1.00 53.64           C  
ATOM   1527  O   ASP B  26     -20.246  14.998  43.126  1.00 53.60           O  
ATOM   1528  CB  ASP B  26     -20.267  16.805  45.989  1.00 54.12           C  
ATOM   1529  CG  ASP B  26     -20.018  15.441  46.556  1.00 55.42           C  
ATOM   1530  OD1 ASP B  26     -19.165  14.721  46.004  1.00 58.41           O  
ATOM   1531  OD2 ASP B  26     -20.685  15.069  47.555  1.00 59.52           O  
ATOM   1532  N   VAL B  27     -22.008  16.333  43.450  1.00 53.18           N  
ATOM   1533  CA  VAL B  27     -22.873  15.404  42.734  1.00 53.08           C  
ATOM   1534  C   VAL B  27     -22.424  15.267  41.271  1.00 52.84           C  
ATOM   1535  O   VAL B  27     -22.433  14.162  40.715  1.00 52.92           O  
ATOM   1536  CB  VAL B  27     -24.424  15.703  42.843  1.00 53.33           C  
ATOM   1537  CG1 VAL B  27     -24.777  16.518  44.087  1.00 53.05           C  
ATOM   1538  CG2 VAL B  27     -24.975  16.351  41.582  1.00 53.66           C  
ATOM   1539  N   VAL B  28     -22.005  16.372  40.660  1.00 52.22           N  
ATOM   1540  CA  VAL B  28     -21.619  16.340  39.254  1.00 51.72           C  
ATOM   1541  C   VAL B  28     -20.289  15.621  39.028  1.00 51.10           C  
ATOM   1542  O   VAL B  28     -19.957  15.278  37.903  1.00 50.84           O  
ATOM   1543  CB  VAL B  28     -21.553  17.743  38.630  1.00 51.97           C  
ATOM   1544  CG1 VAL B  28     -22.886  18.464  38.795  1.00 51.83           C  
ATOM   1545  CG2 VAL B  28     -20.389  18.564  39.228  1.00 52.63           C  
ATOM   1546  N   GLY B  29     -19.534  15.397  40.096  1.00 50.68           N  
ATOM   1547  CA  GLY B  29     -18.277  14.646  40.014  1.00 50.47           C  
ATOM   1548  C   GLY B  29     -17.030  15.497  39.797  1.00 49.87           C  
ATOM   1549  O   GLY B  29     -15.999  14.996  39.336  1.00 48.62           O  
ATOM   1550  N   ILE B  30     -17.131  16.788  40.131  1.00 49.82           N  
ATOM   1551  CA  ILE B  30     -15.958  17.670  40.193  1.00 49.92           C  
ATOM   1552  C   ILE B  30     -15.231  17.432  41.515  1.00 49.92           C  
ATOM   1553  O   ILE B  30     -15.823  17.541  42.579  1.00 50.06           O  
ATOM   1554  CB  ILE B  30     -16.346  19.153  40.049  1.00 49.61           C  
ATOM   1555  CG1 ILE B  30     -16.793  19.427  38.609  1.00 49.44           C  
ATOM   1556  CG2 ILE B  30     -15.168  20.060  40.400  1.00 49.60           C  
ATOM   1557  CD1 ILE B  30     -17.539  20.731  38.402  1.00 49.51           C  
ATOM   1558  N   THR B  31     -13.954  17.087  41.432  1.00 50.29           N  
ATOM   1559  CA  THR B  31     -13.110  16.885  42.607  1.00 50.90           C  
ATOM   1560  C   THR B  31     -12.147  18.064  42.744  1.00 51.31           C  
ATOM   1561  O   THR B  31     -11.075  18.059  42.145  1.00 51.50           O  
ATOM   1562  CB  THR B  31     -12.301  15.564  42.478  1.00 50.83           C  
ATOM   1563  OG1 THR B  31     -11.491  15.590  41.294  1.00 50.93           O  
ATOM   1564  CG2 THR B  31     -13.234  14.391  42.387  1.00 50.38           C  
ATOM   1565  N   GLN B  32     -12.529  19.081  43.507  1.00 51.93           N  
ATOM   1566  CA  GLN B  32     -11.747  20.315  43.547  1.00 52.76           C  
ATOM   1567  C   GLN B  32     -11.687  20.938  44.933  1.00 53.65           C  
ATOM   1568  O   GLN B  32     -10.614  21.172  45.466  1.00 53.66           O  
ATOM   1569  CB  GLN B  32     -12.313  21.318  42.547  1.00 52.67           C  
ATOM   1570  CG  GLN B  32     -11.380  22.472  42.229  1.00 52.14           C  
ATOM   1571  CD  GLN B  32     -11.824  23.280  41.027  1.00 52.04           C  
ATOM   1572  OE1 GLN B  32     -11.990  22.742  39.936  1.00 51.39           O  
ATOM   1573  NE2 GLN B  32     -11.984  24.584  41.212  1.00 51.28           N  
ATOM   1574  N   TRP B  33     -12.845  21.205  45.514  1.00 55.04           N  
ATOM   1575  CA  TRP B  33     -12.914  21.767  46.849  1.00 56.21           C  
ATOM   1576  C   TRP B  33     -13.089  20.701  47.907  1.00 57.84           C  
ATOM   1577  O   TRP B  33     -13.347  19.548  47.609  1.00 58.50           O  
ATOM   1578  CB  TRP B  33     -14.000  22.845  46.911  1.00 55.29           C  
ATOM   1579  CG  TRP B  33     -13.565  24.075  46.176  1.00 54.42           C  
ATOM   1580  CD1 TRP B  33     -12.336  24.296  45.612  1.00 57.41           C  
ATOM   1581  CD2 TRP B  33     -14.315  25.269  45.963  1.00 53.24           C  
ATOM   1582  NE1 TRP B  33     -12.289  25.535  45.056  1.00 54.44           N  
ATOM   1583  CE2 TRP B  33     -13.490  26.158  45.254  1.00 53.89           C  
ATOM   1584  CE3 TRP B  33     -15.601  25.675  46.299  1.00 55.79           C  
ATOM   1585  CZ2 TRP B  33     -13.908  27.431  44.874  1.00 54.79           C  
ATOM   1586  CZ3 TRP B  33     -16.017  26.940  45.918  1.00 54.11           C  
ATOM   1587  CH2 TRP B  33     -15.172  27.799  45.216  1.00 53.94           C  
ATOM   1588  N   THR B  34     -12.888  21.115  49.147  1.00 60.20           N  
ATOM   1589  CA  THR B  34     -12.849  20.246  50.315  1.00 61.38           C  
ATOM   1590  C   THR B  34     -13.704  20.941  51.359  1.00 62.89           C  
ATOM   1591  O   THR B  34     -14.191  22.041  51.118  1.00 62.61           O  
ATOM   1592  CB  THR B  34     -11.389  20.100  50.800  1.00 61.32           C  
ATOM   1593  OG1 THR B  34     -10.568  19.706  49.693  1.00 60.66           O  
ATOM   1594  CG2 THR B  34     -11.246  19.045  51.892  1.00 61.12           C  
ATOM   1595  N   LYS B  35     -13.940  20.301  52.496  1.00 64.97           N  
ATOM   1596  CA  LYS B  35     -14.515  21.020  53.642  1.00 66.52           C  
ATOM   1597  C   LYS B  35     -13.507  22.082  54.136  1.00 67.41           C  
ATOM   1598  O   LYS B  35     -13.890  23.174  54.539  1.00 67.68           O  
ATOM   1599  CB  LYS B  35     -14.925  20.051  54.763  1.00 66.76           C  
ATOM   1600  CG  LYS B  35     -13.764  19.225  55.351  1.00 67.98           C  
ATOM   1601  CD  LYS B  35     -14.237  18.116  56.315  1.00 68.39           C  
ATOM   1602  CE  LYS B  35     -14.938  18.686  57.570  1.00 70.04           C  
ATOM   1603  NZ  LYS B  35     -14.107  19.683  58.319  1.00 70.39           N  
ATOM   1604  N   ASP B  36     -12.221  21.769  54.043  1.00 68.47           N  
ATOM   1605  CA  ASP B  36     -11.160  22.650  54.530  1.00 69.23           C  
ATOM   1606  C   ASP B  36     -10.629  23.636  53.486  1.00 69.94           C  
ATOM   1607  O   ASP B  36      -9.731  24.427  53.794  1.00 70.15           O  
ATOM   1608  CB  ASP B  36     -10.000  21.803  55.054  1.00 69.63           C  
ATOM   1609  CG  ASP B  36     -10.449  20.788  56.093  1.00 70.92           C  
ATOM   1610  OD1 ASP B  36     -11.307  21.134  56.941  1.00 71.54           O  
ATOM   1611  OD2 ASP B  36      -9.959  19.638  56.046  1.00 73.20           O  
ATOM   1612  N   TYR B  37     -11.160  23.596  52.262  1.00 70.42           N  
ATOM   1613  CA  TYR B  37     -10.753  24.561  51.239  1.00 70.33           C  
ATOM   1614  C   TYR B  37     -11.826  24.814  50.175  1.00 70.59           C  
ATOM   1615  O   TYR B  37     -12.223  23.898  49.477  1.00 70.21           O  
ATOM   1616  CB  TYR B  37      -9.447  24.138  50.557  1.00 70.51           C  
ATOM   1617  CG  TYR B  37      -8.977  25.200  49.594  1.00 70.57           C  
ATOM   1618  CD1 TYR B  37      -9.323  25.143  48.252  1.00 70.85           C  
ATOM   1619  CD2 TYR B  37      -8.236  26.297  50.038  1.00 70.52           C  
ATOM   1620  CE1 TYR B  37      -8.934  26.129  47.374  1.00 71.03           C  
ATOM   1621  CE2 TYR B  37      -7.837  27.288  49.160  1.00 70.25           C  
ATOM   1622  CZ  TYR B  37      -8.192  27.194  47.830  1.00 70.54           C  
ATOM   1623  OH  TYR B  37      -7.816  28.159  46.937  1.00 70.37           O  
ATOM   1624  N   PRO B  38     -12.289  26.064  50.043  1.00 71.10           N  
ATOM   1625  CA  PRO B  38     -12.051  27.193  50.933  1.00 71.76           C  
ATOM   1626  C   PRO B  38     -12.670  26.968  52.304  1.00 72.13           C  
ATOM   1627  O   PRO B  38     -13.819  26.551  52.391  1.00 72.26           O  
ATOM   1628  CB  PRO B  38     -12.751  28.355  50.226  1.00 71.57           C  
ATOM   1629  CG  PRO B  38     -12.889  27.928  48.819  1.00 71.35           C  
ATOM   1630  CD  PRO B  38     -13.080  26.458  48.872  1.00 71.07           C  
ATOM   1631  N   SER B  39     -11.895  27.218  53.354  1.00 72.62           N  
ATOM   1632  CA  SER B  39     -12.402  27.182  54.717  1.00 73.07           C  
ATOM   1633  C   SER B  39     -12.700  28.610  55.161  1.00 73.51           C  
ATOM   1634  O   SER B  39     -12.507  29.561  54.400  1.00 73.45           O  
ATOM   1635  CB  SER B  39     -11.392  26.515  55.656  1.00 73.12           C  
ATOM   1636  OG  SER B  39     -10.136  27.176  55.612  1.00 73.61           O  
ATOM   1637  N   GLN B  40     -13.191  28.743  56.392  1.00 74.10           N  
ATOM   1638  CA  GLN B  40     -13.518  30.041  56.991  1.00 74.09           C  
ATOM   1639  C   GLN B  40     -12.299  30.963  57.026  1.00 74.08           C  
ATOM   1640  O   GLN B  40     -12.380  32.130  56.630  1.00 73.87           O  
ATOM   1641  CB  GLN B  40     -14.043  29.824  58.412  1.00 74.28           C  
ATOM   1642  CG  GLN B  40     -14.782  31.016  59.018  1.00 74.67           C  
ATOM   1643  CD  GLN B  40     -15.471  30.662  60.337  1.00 74.86           C  
ATOM   1644  OE1 GLN B  40     -16.684  30.846  60.493  1.00 75.75           O  
ATOM   1645  NE2 GLN B  40     -14.699  30.132  61.280  1.00 75.16           N  
ATOM   1646  N   GLY B  41     -11.172  30.422  57.491  1.00 74.09           N  
ATOM   1647  CA  GLY B  41      -9.911  31.171  57.557  1.00 74.09           C  
ATOM   1648  C   GLY B  41      -9.530  31.805  56.231  1.00 74.05           C  
ATOM   1649  O   GLY B  41      -9.226  33.001  56.161  1.00 73.91           O  
ATOM   1650  N   ASP B  42      -9.568  30.992  55.179  1.00 74.03           N  
ATOM   1651  CA  ASP B  42      -9.314  31.459  53.818  1.00 73.91           C  
ATOM   1652  C   ASP B  42     -10.189  32.665  53.472  1.00 73.79           C  
ATOM   1653  O   ASP B  42      -9.720  33.624  52.864  1.00 73.68           O  
ATOM   1654  CB  ASP B  42      -9.566  30.333  52.807  1.00 73.83           C  
ATOM   1655  CG  ASP B  42      -8.665  29.131  53.026  1.00 73.92           C  
ATOM   1656  OD1 ASP B  42      -7.436  29.267  52.874  1.00 74.30           O  
ATOM   1657  OD2 ASP B  42      -9.187  28.046  53.349  1.00 73.98           O  
ATOM   1658  N   ILE B  43     -11.454  32.617  53.871  1.00 73.80           N  
ATOM   1659  CA  ILE B  43     -12.398  33.679  53.544  1.00 73.90           C  
ATOM   1660  C   ILE B  43     -12.104  34.961  54.332  1.00 73.90           C  
ATOM   1661  O   ILE B  43     -12.029  36.046  53.748  1.00 73.73           O  
ATOM   1662  CB  ILE B  43     -13.863  33.210  53.773  1.00 73.96           C  
ATOM   1663  CG1 ILE B  43     -14.227  32.090  52.790  1.00 74.23           C  
ATOM   1664  CG2 ILE B  43     -14.849  34.357  53.609  1.00 73.82           C  
ATOM   1665  CD1 ILE B  43     -14.471  32.561  51.348  1.00 74.29           C  
ATOM   1666  N   GLN B  44     -11.945  34.835  55.649  1.00 73.91           N  
ATOM   1667  CA  GLN B  44     -11.619  35.985  56.511  1.00 73.93           C  
ATOM   1668  C   GLN B  44     -10.369  36.687  55.993  1.00 73.63           C  
ATOM   1669  O   GLN B  44     -10.399  37.878  55.664  1.00 73.40           O  
ATOM   1670  CB  GLN B  44     -11.396  35.542  57.969  1.00 74.11           C  
ATOM   1671  CG  GLN B  44     -12.669  35.447  58.833  1.00 74.32           C  
ATOM   1672  CD  GLN B  44     -12.523  34.473  60.012  1.00 74.59           C  
ATOM   1673  OE1 GLN B  44     -13.517  34.042  60.603  1.00 75.83           O  
ATOM   1674  NE2 GLN B  44     -11.281  34.110  60.343  1.00 74.90           N  
ATOM   1675  N   GLU B  45      -9.281  35.927  55.901  1.00 73.32           N  
ATOM   1676  CA  GLU B  45      -8.036  36.447  55.372  1.00 73.31           C  
ATOM   1677  C   GLU B  45      -8.282  37.236  54.097  1.00 73.28           C  
ATOM   1678  O   GLU B  45      -7.704  38.298  53.914  1.00 73.66           O  
ATOM   1679  CB  GLU B  45      -7.046  35.321  55.095  1.00 73.17           C  
ATOM   1680  CG  GLU B  45      -5.639  35.814  54.758  1.00 73.42           C  
ATOM   1681  CD  GLU B  45      -4.787  34.764  54.052  1.00 73.57           C  
ATOM   1682  OE1 GLU B  45      -3.694  35.119  53.567  1.00 73.31           O  
ATOM   1683  OE2 GLU B  45      -5.205  33.588  53.971  1.00 74.61           O  
ATOM   1684  N   ASP B  46      -9.140  36.727  53.218  1.00 73.11           N  
ATOM   1685  CA  ASP B  46      -9.401  37.404  51.955  1.00 73.06           C  
ATOM   1686  C   ASP B  46     -10.145  38.716  52.179  1.00 72.90           C  
ATOM   1687  O   ASP B  46      -9.864  39.705  51.508  1.00 72.56           O  
ATOM   1688  CB  ASP B  46     -10.164  36.496  50.968  1.00 73.12           C  
ATOM   1689  CG  ASP B  46      -9.266  35.430  50.311  1.00 73.07           C  
ATOM   1690  OD1 ASP B  46      -8.027  35.582  50.298  1.00 72.77           O  
ATOM   1691  OD2 ASP B  46      -9.807  34.427  49.798  1.00 72.68           O  
ATOM   1692  N   ILE B  47     -11.081  38.739  53.122  1.00 73.04           N  
ATOM   1693  CA  ILE B  47     -11.835  39.976  53.382  1.00 73.17           C  
ATOM   1694  C   ILE B  47     -10.927  41.017  54.037  1.00 73.18           C  
ATOM   1695  O   ILE B  47     -10.892  42.173  53.603  1.00 72.97           O  
ATOM   1696  CB  ILE B  47     -13.076  39.760  54.252  1.00 73.18           C  
ATOM   1697  CG1 ILE B  47     -14.026  38.767  53.589  1.00 73.30           C  
ATOM   1698  CG2 ILE B  47     -13.821  41.079  54.446  1.00 73.13           C  
ATOM   1699  CD1 ILE B  47     -14.936  38.082  54.560  1.00 73.38           C  
ATOM   1700  N   THR B  48     -10.198  40.586  55.070  1.00 73.07           N  
ATOM   1701  CA  THR B  48      -9.118  41.376  55.664  1.00 72.93           C  
ATOM   1702  C   THR B  48      -8.295  42.074  54.584  1.00 72.78           C  
ATOM   1703  O   THR B  48      -8.126  43.291  54.618  1.00 72.85           O  
ATOM   1704  CB  THR B  48      -8.185  40.487  56.529  1.00 73.06           C  
ATOM   1705  OG1 THR B  48      -8.894  40.056  57.699  1.00 73.38           O  
ATOM   1706  CG2 THR B  48      -6.905  41.231  56.943  1.00 72.90           C  
ATOM   1707  N   LYS B  49      -7.812  41.307  53.613  1.00 72.40           N  
ATOM   1708  CA  LYS B  49      -6.948  41.851  52.573  1.00 72.18           C  
ATOM   1709  C   LYS B  49      -7.713  42.499  51.406  1.00 71.99           C  
ATOM   1710  O   LYS B  49      -7.122  42.775  50.362  1.00 72.01           O  
ATOM   1711  CB  LYS B  49      -6.002  40.766  52.072  1.00 72.07           C  
ATOM   1712  CG  LYS B  49      -5.172  40.130  53.174  1.00 72.04           C  
ATOM   1713  CD  LYS B  49      -4.179  39.147  52.598  1.00 72.25           C  
ATOM   1714  CE  LYS B  49      -3.277  38.582  53.671  1.00 72.29           C  
ATOM   1715  NZ  LYS B  49      -2.171  37.782  53.088  1.00 72.30           N  
ATOM   1716  N   LYS B  50      -9.014  42.740  51.583  1.00 71.82           N  
ATOM   1717  CA  LYS B  50      -9.815  43.551  50.649  1.00 71.85           C  
ATOM   1718  C   LYS B  50      -9.751  42.996  49.209  1.00 71.57           C  
ATOM   1719  O   LYS B  50      -9.413  43.688  48.244  1.00 71.78           O  
ATOM   1720  CB  LYS B  50      -9.378  45.020  50.736  1.00 72.08           C  
ATOM   1721  CG  LYS B  50     -10.533  46.041  50.699  1.00 72.75           C  
ATOM   1722  CD  LYS B  50     -10.226  47.285  51.576  1.00 72.67           C  
ATOM   1723  CE  LYS B  50     -11.301  48.377  51.437  1.00 72.97           C  
ATOM   1724  NZ  LYS B  50     -11.262  49.075  50.106  1.00 72.82           N  
ATOM   1725  N   ARG B  51     -10.158  41.739  49.099  1.00 71.03           N  
ATOM   1726  CA  ARG B  51      -9.710  40.829  48.048  1.00 70.45           C  
ATOM   1727  C   ARG B  51     -10.854  39.947  47.497  1.00 70.09           C  
ATOM   1728  O   ARG B  51     -10.798  39.491  46.365  1.00 69.75           O  
ATOM   1729  CB  ARG B  51      -8.682  39.947  48.722  1.00 70.22           C  
ATOM   1730  CG  ARG B  51      -7.627  39.297  47.910  1.00 69.93           C  
ATOM   1731  CD  ARG B  51      -6.966  38.339  48.881  1.00 69.98           C  
ATOM   1732  NE  ARG B  51      -5.701  37.787  48.445  1.00 69.74           N  
ATOM   1733  CZ  ARG B  51      -4.981  36.935  49.172  1.00 70.16           C  
ATOM   1734  NH1 ARG B  51      -5.400  36.551  50.376  1.00 69.84           N  
ATOM   1735  NH2 ARG B  51      -3.830  36.467  48.695  1.00 70.90           N  
ATOM   1736  N   LEU B  52     -11.869  39.711  48.325  1.00 69.73           N  
ATOM   1737  CA  LEU B  52     -13.002  38.875  48.001  1.00 69.83           C  
ATOM   1738  C   LEU B  52     -14.128  39.734  47.418  1.00 69.82           C  
ATOM   1739  O   LEU B  52     -14.775  40.485  48.136  1.00 69.76           O  
ATOM   1740  CB  LEU B  52     -13.468  38.163  49.280  1.00 69.58           C  
ATOM   1741  CG  LEU B  52     -14.231  36.839  49.182  1.00 69.57           C  
ATOM   1742  CD1 LEU B  52     -14.939  36.566  50.486  1.00 69.08           C  
ATOM   1743  CD2 LEU B  52     -15.234  36.831  48.045  1.00 69.83           C  
ATOM   1744  N   TYR B  53     -14.366  39.611  46.117  1.00 70.09           N  
ATOM   1745  CA  TYR B  53     -15.411  40.370  45.434  1.00 70.59           C  
ATOM   1746  C   TYR B  53     -16.665  39.527  45.221  1.00 71.05           C  
ATOM   1747  O   TYR B  53     -16.569  38.329  44.997  1.00 71.08           O  
ATOM   1748  CB  TYR B  53     -14.897  40.861  44.088  1.00 70.53           C  
ATOM   1749  CG  TYR B  53     -13.868  41.954  44.195  1.00 70.43           C  
ATOM   1750  CD1 TYR B  53     -12.583  41.683  44.652  1.00 70.94           C  
ATOM   1751  CD2 TYR B  53     -14.176  43.263  43.839  1.00 70.44           C  
ATOM   1752  CE1 TYR B  53     -11.629  42.691  44.756  1.00 71.00           C  
ATOM   1753  CE2 TYR B  53     -13.234  44.272  43.928  1.00 70.52           C  
ATOM   1754  CZ  TYR B  53     -11.965  43.982  44.390  1.00 70.76           C  
ATOM   1755  OH  TYR B  53     -11.031  44.984  44.483  1.00 70.79           O  
ATOM   1756  N   LEU B  54     -17.833  40.168  45.271  1.00 71.72           N  
ATOM   1757  CA  LEU B  54     -19.127  39.489  45.196  1.00 72.28           C  
ATOM   1758  C   LEU B  54     -20.018  40.074  44.114  1.00 73.15           C  
ATOM   1759  O   LEU B  54     -20.041  41.285  43.913  1.00 73.14           O  
ATOM   1760  CB  LEU B  54     -19.862  39.623  46.524  1.00 72.01           C  
ATOM   1761  CG  LEU B  54     -19.779  38.474  47.522  1.00 71.74           C  
ATOM   1762  CD1 LEU B  54     -18.375  37.991  47.698  1.00 71.52           C  
ATOM   1763  CD2 LEU B  54     -20.338  38.930  48.851  1.00 71.92           C  
ATOM   1764  N   LEU B  55     -20.743  39.202  43.418  1.00 74.23           N  
ATOM   1765  CA  LEU B  55     -21.905  39.606  42.645  1.00 74.91           C  
ATOM   1766  C   LEU B  55     -23.055  39.335  43.596  1.00 75.91           C  
ATOM   1767  O   LEU B  55     -23.261  38.190  44.010  1.00 75.92           O  
ATOM   1768  CB  LEU B  55     -22.045  38.784  41.367  1.00 74.82           C  
ATOM   1769  CG  LEU B  55     -22.554  39.519  40.126  1.00 74.35           C  
ATOM   1770  CD1 LEU B  55     -23.063  38.517  39.103  1.00 74.51           C  
ATOM   1771  CD2 LEU B  55     -23.634  40.515  40.449  1.00 74.14           C  
ATOM   1772  N   VAL B  56     -23.784  40.386  43.967  1.00 76.79           N  
ATOM   1773  CA  VAL B  56     -24.665  40.324  45.138  1.00 76.73           C  
ATOM   1774  C   VAL B  56     -25.898  41.214  45.002  1.00 76.51           C  
ATOM   1775  O   VAL B  56     -25.859  42.222  44.286  1.00 76.55           O  
ATOM   1776  CB  VAL B  56     -23.872  40.713  46.410  1.00 77.82           C  
ATOM   1777  CG1 VAL B  56     -23.587  42.215  46.435  1.00 78.68           C  
ATOM   1778  CG2 VAL B  56     -24.587  40.253  47.671  1.00 78.45           C  
ATOM   1779  N   HIS B  57     -26.984  40.831  45.687  1.00 75.26           N  
ATOM   1780  CA  HIS B  57     -28.254  41.584  45.650  1.00 73.15           C  
ATOM   1781  C   HIS B  57     -29.233  41.313  46.814  1.00 67.51           C  
ATOM   1782  O   HIS B  57     -30.174  40.520  46.671  1.00 67.58           O  
ATOM   1783  CB  HIS B  57     -29.013  41.283  44.345  1.00 74.67           C  
ATOM   1784  CG  HIS B  57     -30.069  42.296  44.005  1.00 77.40           C  
ATOM   1785  ND1 HIS B  57     -30.420  43.327  44.855  1.00 80.43           N  
ATOM   1786  CD2 HIS B  57     -30.869  42.416  42.917  1.00 80.78           C  
ATOM   1787  CE1 HIS B  57     -31.373  44.052  44.295  1.00 81.84           C  
ATOM   1788  NE2 HIS B  57     -31.665  43.520  43.120  1.00 82.24           N  
ATOM   1789  N   GLU B  58     -29.012  41.885  47.991  1.00 61.91           N  
ATOM   1790  CA  GLU B  58     -27.701  42.131  48.559  1.00 58.88           C  
ATOM   1791  C   GLU B  58     -28.047  41.999  50.023  1.00 63.29           C  
ATOM   1792  O   GLU B  58     -27.708  42.893  50.807  1.00 63.56           O  
ATOM   1793  CB  GLU B  58     -27.187  43.582  48.229  1.00 56.87           C  
ATOM   1794  N   GLU B  59     -28.599  40.857  50.450  1.00 69.99           N  
ATOM   1795  CA  GLU B  59     -27.897  39.581  50.480  1.00 77.23           C  
ATOM   1796  C   GLU B  59     -28.294  38.361  49.621  1.00 79.02           C  
ATOM   1797  O   GLU B  59     -28.494  37.270  50.169  1.00 79.62           O  
ATOM   1798  CB  GLU B  59     -27.976  39.138  51.960  1.00 77.76           C  
ATOM   1799  CG  GLU B  59     -29.289  38.390  52.357  1.00 80.48           C  
ATOM   1800  CD  GLU B  59     -29.658  38.499  53.837  1.00 80.67           C  
ATOM   1801  OE1 GLU B  59     -29.127  39.378  54.558  1.00 83.07           O  
ATOM   1802  OE2 GLU B  59     -30.506  37.687  54.278  1.00 83.57           O  
ATOM   1803  N   MET B  60     -28.343  38.483  48.298  1.00 81.50           N  
ATOM   1804  CA  MET B  60     -28.365  37.260  47.478  1.00 82.11           C  
ATOM   1805  C   MET B  60     -27.121  37.187  46.584  1.00 82.41           C  
ATOM   1806  O   MET B  60     -27.058  37.829  45.522  1.00 82.69           O  
ATOM   1807  CB  MET B  60     -29.679  37.097  46.690  1.00 83.87           C  
ATOM   1808  CG  MET B  60     -30.281  35.673  46.836  1.00 85.63           C  
ATOM   1809  SD  MET B  60     -29.532  34.408  45.755  1.00 88.56           S  
ATOM   1810  CE  MET B  60     -29.453  32.985  46.861  1.00 87.64           C  
ATOM   1811  N   ILE B  61     -26.143  36.396  47.038  1.00 81.41           N  
ATOM   1812  CA  ILE B  61     -24.849  36.256  46.366  1.00 80.41           C  
ATOM   1813  C   ILE B  61     -24.954  35.308  45.192  1.00 79.28           C  
ATOM   1814  O   ILE B  61     -25.088  34.104  45.376  1.00 78.93           O  
ATOM   1815  CB  ILE B  61     -23.773  35.657  47.288  1.00 80.68           C  
ATOM   1816  CG1 ILE B  61     -23.649  36.441  48.590  1.00 80.64           C  
ATOM   1817  CG2 ILE B  61     -22.425  35.613  46.573  1.00 81.20           C  
ATOM   1818  CD1 ILE B  61     -23.233  35.561  49.733  1.00 80.61           C  
ATOM   1819  N   PHE B  62     -24.859  35.848  43.987  1.00 78.04           N  
ATOM   1820  CA  PHE B  62     -24.919  35.026  42.786  1.00 76.84           C  
ATOM   1821  C   PHE B  62     -23.566  34.366  42.510  1.00 75.42           C  
ATOM   1822  O   PHE B  62     -23.508  33.210  42.094  1.00 75.36           O  
ATOM   1823  CB  PHE B  62     -25.372  35.858  41.580  1.00 77.59           C  
ATOM   1824  CG  PHE B  62     -26.623  36.674  41.838  1.00 78.50           C  
ATOM   1825  CD1 PHE B  62     -27.781  36.061  42.297  1.00 75.41           C  
ATOM   1826  CD2 PHE B  62     -26.636  38.055  41.635  1.00 80.18           C  
ATOM   1827  CE1 PHE B  62     -28.920  36.799  42.550  1.00 77.48           C  
ATOM   1828  CE2 PHE B  62     -27.780  38.797  41.884  1.00 79.21           C  
ATOM   1829  CZ  PHE B  62     -28.918  38.170  42.341  1.00 78.60           C  
ATOM   1830  N   SER B  63     -22.485  35.098  42.757  1.00 73.46           N  
ATOM   1831  CA  SER B  63     -21.148  34.632  42.421  1.00 71.92           C  
ATOM   1832  C   SER B  63     -20.097  35.347  43.253  1.00 70.45           C  
ATOM   1833  O   SER B  63     -20.334  36.429  43.777  1.00 70.42           O  
ATOM   1834  CB  SER B  63     -20.885  34.867  40.931  1.00 71.84           C  
ATOM   1835  OG  SER B  63     -19.669  34.272  40.514  1.00 71.58           O  
ATOM   1836  N   MET B  64     -18.929  34.736  43.373  1.00 68.91           N  
ATOM   1837  CA  MET B  64     -17.864  35.287  44.184  1.00 67.82           C  
ATOM   1838  C   MET B  64     -16.503  34.880  43.641  1.00 66.96           C  
ATOM   1839  O   MET B  64     -16.377  33.898  42.931  1.00 66.90           O  
ATOM   1840  CB  MET B  64     -18.027  34.837  45.635  1.00 67.45           C  
ATOM   1841  CG  MET B  64     -17.339  33.554  46.001  1.00 67.31           C  
ATOM   1842  SD  MET B  64     -17.732  33.084  47.682  1.00 66.89           S  
ATOM   1843  CE  MET B  64     -16.159  32.457  48.239  1.00 66.81           C  
ATOM   1844  N   ALA B  65     -15.484  35.651  43.986  1.00 66.25           N  
ATOM   1845  CA  ALA B  65     -14.126  35.385  43.537  1.00 65.69           C  
ATOM   1846  C   ALA B  65     -13.170  36.204  44.373  1.00 65.05           C  
ATOM   1847  O   ALA B  65     -13.522  37.281  44.820  1.00 65.02           O  
ATOM   1848  CB  ALA B  65     -13.980  35.761  42.090  1.00 65.61           C  
ATOM   1849  N   THR B  66     -11.971  35.696  44.607  1.00 64.52           N  
ATOM   1850  CA  THR B  66     -10.946  36.522  45.195  1.00 64.42           C  
ATOM   1851  C   THR B  66      -9.927  36.868  44.127  1.00 63.97           C  
ATOM   1852  O   THR B  66      -9.512  36.026  43.346  1.00 63.08           O  
ATOM   1853  CB  THR B  66     -10.309  35.888  46.432  1.00 64.27           C  
ATOM   1854  OG1 THR B  66      -9.412  34.854  46.044  1.00 65.19           O  
ATOM   1855  CG2 THR B  66     -11.377  35.326  47.335  1.00 63.97           C  
ATOM   1856  N   PHE B  67      -9.554  38.141  44.117  1.00 64.26           N  
ATOM   1857  CA  PHE B  67      -8.804  38.768  43.048  1.00 64.60           C  
ATOM   1858  C   PHE B  67      -7.541  39.278  43.722  1.00 64.78           C  
ATOM   1859  O   PHE B  67      -7.620  40.098  44.619  1.00 64.74           O  
ATOM   1860  CB  PHE B  67      -9.687  39.890  42.482  1.00 64.63           C  
ATOM   1861  CG  PHE B  67      -9.029  40.780  41.460  1.00 64.52           C  
ATOM   1862  CD1 PHE B  67      -9.095  40.477  40.110  1.00 61.79           C  
ATOM   1863  CD2 PHE B  67      -8.406  41.969  41.851  1.00 65.79           C  
ATOM   1864  CE1 PHE B  67      -8.519  41.316  39.164  1.00 62.98           C  
ATOM   1865  CE2 PHE B  67      -7.812  42.818  40.907  1.00 65.69           C  
ATOM   1866  CZ  PHE B  67      -7.875  42.488  39.562  1.00 65.10           C  
ATOM   1867  N   CYS B  68      -6.390  38.749  43.315  1.00 65.45           N  
ATOM   1868  CA  CYS B  68      -5.105  39.047  43.954  1.00 66.17           C  
ATOM   1869  C   CYS B  68      -4.261  40.019  43.175  1.00 67.13           C  
ATOM   1870  O   CYS B  68      -3.913  39.751  42.031  1.00 67.22           O  
ATOM   1871  CB  CYS B  68      -4.278  37.785  44.094  1.00 65.68           C  
ATOM   1872  SG  CYS B  68      -5.050  36.593  45.105  1.00 63.76           S  
ATOM   1873  N   MET B  69      -3.924  41.136  43.814  1.00 68.54           N  
ATOM   1874  CA  MET B  69      -2.895  42.050  43.336  1.00 69.58           C  
ATOM   1875  C   MET B  69      -1.880  42.227  44.442  1.00 70.17           C  
ATOM   1876  O   MET B  69      -2.208  42.721  45.516  1.00 70.31           O  
ATOM   1877  CB  MET B  69      -3.492  43.405  42.989  1.00 69.61           C  
ATOM   1878  CG  MET B  69      -3.978  43.502  41.565  1.00 70.54           C  
ATOM   1879  SD  MET B  69      -4.486  45.176  41.132  1.00 71.66           S  
ATOM   1880  CE  MET B  69      -5.602  45.535  42.506  1.00 72.14           C  
ATOM   1881  N   GLU B  70      -0.658  41.784  44.191  1.00 71.06           N  
ATOM   1882  CA  GLU B  70       0.456  42.116  45.062  1.00 71.73           C  
ATOM   1883  C   GLU B  70       1.160  43.358  44.516  1.00 72.10           C  
ATOM   1884  O   GLU B  70       1.418  43.475  43.310  1.00 72.05           O  
ATOM   1885  CB  GLU B  70       1.467  40.964  45.159  1.00 72.32           C  
ATOM   1886  CG  GLU B  70       0.891  39.609  45.541  1.00 74.05           C  
ATOM   1887  CD  GLU B  70       0.076  39.643  46.819  1.00 76.59           C  
ATOM   1888  OE1 GLU B  70      -0.973  38.957  46.867  1.00 78.59           O  
ATOM   1889  OE2 GLU B  70       0.476  40.356  47.767  1.00 78.08           O  
ATOM   1890  N   GLN B  71       1.449  44.290  45.420  1.00 72.23           N  
ATOM   1891  CA  GLN B  71       2.419  45.358  45.183  1.00 72.12           C  
ATOM   1892  C   GLN B  71       3.547  44.960  44.207  1.00 71.73           C  
ATOM   1893  O   GLN B  71       4.240  43.955  44.416  1.00 71.76           O  
ATOM   1894  CB  GLN B  71       3.020  45.803  46.534  1.00 72.95           C  
ATOM   1895  CG  GLN B  71       4.008  44.795  47.239  1.00 74.90           C  
ATOM   1896  CD  GLN B  71       3.541  43.317  47.254  1.00 77.12           C  
ATOM   1897  OE1 GLN B  71       2.480  42.974  47.820  1.00 78.31           O  
ATOM   1898  NE2 GLN B  71       4.352  42.435  46.641  1.00 77.37           N  
ATOM   1899  N   GLU B  72       3.702  45.739  43.133  1.00 70.90           N  
ATOM   1900  CA  GLU B  72       4.853  45.623  42.207  1.00 70.10           C  
ATOM   1901  C   GLU B  72       4.938  44.316  41.392  1.00 68.80           C  
ATOM   1902  O   GLU B  72       6.009  43.972  40.882  1.00 68.60           O  
ATOM   1903  CB  GLU B  72       6.198  45.876  42.950  1.00 71.09           C  
ATOM   1904  CG  GLU B  72       6.566  47.365  43.167  1.00 72.98           C  
ATOM   1905  CD  GLU B  72       6.921  48.099  41.863  1.00 75.68           C  
ATOM   1906  OE1 GLU B  72       8.039  47.889  41.329  1.00 77.55           O  
ATOM   1907  OE2 GLU B  72       6.080  48.897  41.378  1.00 77.47           O  
ATOM   1908  N   GLN B  73       3.822  43.602  41.256  1.00 67.07           N  
ATOM   1909  CA  GLN B  73       3.754  42.479  40.324  1.00 65.50           C  
ATOM   1910  C   GLN B  73       2.999  42.926  39.067  1.00 63.74           C  
ATOM   1911  O   GLN B  73       2.111  43.767  39.132  1.00 63.13           O  
ATOM   1912  CB  GLN B  73       3.055  41.261  40.950  1.00 65.76           C  
ATOM   1913  CG  GLN B  73       3.628  40.731  42.269  1.00 66.16           C  
ATOM   1914  CD  GLN B  73       4.865  39.856  42.110  1.00 66.75           C  
ATOM   1915  OE1 GLN B  73       5.734  40.106  41.265  1.00 68.04           O  
ATOM   1916  NE2 GLN B  73       4.956  38.829  42.937  1.00 66.28           N  
ATOM   1917  N   ASP B  74       3.354  42.340  37.932  1.00 61.95           N  
ATOM   1918  CA  ASP B  74       2.677  42.598  36.668  1.00 60.64           C  
ATOM   1919  C   ASP B  74       1.389  41.802  36.459  1.00 59.05           C  
ATOM   1920  O   ASP B  74       0.683  42.033  35.475  1.00 59.16           O  
ATOM   1921  CB  ASP B  74       3.618  42.278  35.505  1.00 61.16           C  
ATOM   1922  CG  ASP B  74       4.757  43.279  35.381  1.00 62.93           C  
ATOM   1923  OD1 ASP B  74       4.775  44.280  36.149  1.00 65.45           O  
ATOM   1924  OD2 ASP B  74       5.639  43.065  34.512  1.00 64.35           O  
ATOM   1925  N   PHE B  75       1.070  40.875  37.358  1.00 56.81           N  
ATOM   1926  CA  PHE B  75      -0.048  39.960  37.127  1.00 55.35           C  
ATOM   1927  C   PHE B  75      -1.051  39.979  38.251  1.00 53.16           C  
ATOM   1928  O   PHE B  75      -0.806  40.524  39.328  1.00 53.20           O  
ATOM   1929  CB  PHE B  75       0.462  38.537  36.941  1.00 54.82           C  
ATOM   1930  CG  PHE B  75       1.266  38.035  38.091  1.00 53.38           C  
ATOM   1931  CD1 PHE B  75       0.646  37.478  39.196  1.00 49.55           C  
ATOM   1932  CD2 PHE B  75       2.640  38.127  38.077  1.00 53.92           C  
ATOM   1933  CE1 PHE B  75       1.382  37.020  40.264  1.00 52.07           C  
ATOM   1934  CE2 PHE B  75       3.388  37.675  39.150  1.00 54.79           C  
ATOM   1935  CZ  PHE B  75       2.759  37.117  40.242  1.00 54.40           C  
ATOM   1936  N   VAL B  76      -2.198  39.376  37.983  1.00 51.21           N  
ATOM   1937  CA  VAL B  76      -3.181  39.121  39.020  1.00 49.47           C  
ATOM   1938  C   VAL B  76      -3.556  37.658  39.020  1.00 48.27           C  
ATOM   1939  O   VAL B  76      -3.381  36.958  38.031  1.00 47.43           O  
ATOM   1940  CB  VAL B  76      -4.420  39.988  38.859  1.00 49.64           C  
ATOM   1941  CG1 VAL B  76      -4.001  41.432  38.776  1.00 50.09           C  
ATOM   1942  CG2 VAL B  76      -5.202  39.603  37.627  1.00 49.87           C  
ATOM   1943  N   TRP B  77      -4.043  37.204  40.159  1.00 46.93           N  
ATOM   1944  CA  TRP B  77      -4.411  35.816  40.326  1.00 46.48           C  
ATOM   1945  C   TRP B  77      -5.880  35.753  40.635  1.00 46.74           C  
ATOM   1946  O   TRP B  77      -6.333  36.346  41.611  1.00 46.64           O  
ATOM   1947  CB  TRP B  77      -3.630  35.166  41.463  1.00 47.72           C  
ATOM   1948  CG  TRP B  77      -2.707  34.092  41.030  1.00 50.29           C  
ATOM   1949  CD1 TRP B  77      -1.361  34.195  40.877  1.00 49.62           C  
ATOM   1950  CD2 TRP B  77      -3.046  32.732  40.733  1.00 41.31           C  
ATOM   1951  NE1 TRP B  77      -0.835  32.985  40.488  1.00 49.47           N  
ATOM   1952  CE2 TRP B  77      -1.846  32.069  40.392  1.00 39.17           C  
ATOM   1953  CE3 TRP B  77      -4.250  32.011  40.715  1.00 39.41           C  
ATOM   1954  CZ2 TRP B  77      -1.811  30.724  40.020  1.00 42.71           C  
ATOM   1955  CZ3 TRP B  77      -4.221  30.673  40.354  1.00 34.66           C  
ATOM   1956  CH2 TRP B  77      -3.006  30.041  40.009  1.00 35.85           C  
ATOM   1957  N   LEU B  78      -6.618  35.042  39.791  1.00 47.68           N  
ATOM   1958  CA  LEU B  78      -8.011  34.743  40.060  1.00 48.22           C  
ATOM   1959  C   LEU B  78      -8.033  33.454  40.873  1.00 48.44           C  
ATOM   1960  O   LEU B  78      -7.423  32.470  40.495  1.00 48.31           O  
ATOM   1961  CB  LEU B  78      -8.780  34.599  38.751  1.00 48.17           C  
ATOM   1962  CG  LEU B  78     -10.295  34.519  38.915  1.00 48.32           C  
ATOM   1963  CD1 LEU B  78     -10.857  35.837  39.427  1.00 48.57           C  
ATOM   1964  CD2 LEU B  78     -10.943  34.113  37.589  1.00 48.57           C  
ATOM   1965  N   LYS B  79      -8.702  33.479  42.014  1.00 49.28           N  
ATOM   1966  CA  LYS B  79      -8.731  32.322  42.908  1.00 50.16           C  
ATOM   1967  C   LYS B  79     -10.114  32.159  43.530  1.00 50.54           C  
ATOM   1968  O   LYS B  79     -10.814  33.141  43.766  1.00 50.14           O  
ATOM   1969  CB  LYS B  79      -7.681  32.462  44.022  1.00 50.30           C  
ATOM   1970  CG  LYS B  79      -6.242  32.182  43.596  1.00 50.41           C  
ATOM   1971  CD  LYS B  79      -5.283  32.350  44.785  1.00 50.60           C  
ATOM   1972  CE  LYS B  79      -3.805  32.142  44.400  1.00 51.71           C  
ATOM   1973  NZ  LYS B  79      -3.455  30.690  44.091  1.00 53.44           N  
ATOM   1974  N   ARG B  80     -10.491  30.912  43.793  1.00 51.29           N  
ATOM   1975  CA  ARG B  80     -11.723  30.607  44.517  1.00 52.08           C  
ATOM   1976  C   ARG B  80     -12.915  31.295  43.876  1.00 52.10           C  
ATOM   1977  O   ARG B  80     -13.726  31.929  44.538  1.00 51.80           O  
ATOM   1978  CB  ARG B  80     -11.570  30.977  45.991  1.00 52.23           C  
ATOM   1979  CG  ARG B  80     -10.402  30.222  46.659  1.00 53.13           C  
ATOM   1980  CD  ARG B  80     -10.198  30.629  48.125  1.00 53.78           C  
ATOM   1981  NE  ARG B  80      -9.376  31.834  48.234  1.00 54.94           N  
ATOM   1982  CZ  ARG B  80      -8.040  31.841  48.269  1.00 55.19           C  
ATOM   1983  NH1 ARG B  80      -7.346  30.714  48.209  1.00 54.76           N  
ATOM   1984  NH2 ARG B  80      -7.389  32.995  48.359  1.00 55.63           N  
ATOM   1985  N   PHE B  81     -12.990  31.142  42.558  1.00 52.79           N  
ATOM   1986  CA  PHE B  81     -14.066  31.683  41.731  1.00 53.39           C  
ATOM   1987  C   PHE B  81     -15.229  30.686  41.731  1.00 54.39           C  
ATOM   1988  O   PHE B  81     -15.038  29.514  41.446  1.00 54.46           O  
ATOM   1989  CB  PHE B  81     -13.500  31.902  40.322  1.00 52.91           C  
ATOM   1990  CG  PHE B  81     -14.464  32.465  39.326  1.00 52.70           C  
ATOM   1991  CD1 PHE B  81     -14.279  32.198  37.976  1.00 54.96           C  
ATOM   1992  CD2 PHE B  81     -15.536  33.254  39.703  1.00 50.43           C  
ATOM   1993  CE1 PHE B  81     -15.134  32.705  37.027  1.00 55.28           C  
ATOM   1994  CE2 PHE B  81     -16.401  33.761  38.753  1.00 51.00           C  
ATOM   1995  CZ  PHE B  81     -16.194  33.487  37.412  1.00 52.43           C  
ATOM   1996  N   ALA B  82     -16.429  31.136  42.074  1.00 55.55           N  
ATOM   1997  CA  ALA B  82     -17.577  30.237  42.114  1.00 56.70           C  
ATOM   1998  C   ALA B  82     -18.838  30.993  41.808  1.00 57.80           C  
ATOM   1999  O   ALA B  82     -19.010  32.097  42.279  1.00 58.25           O  
ATOM   2000  CB  ALA B  82     -17.691  29.593  43.480  1.00 56.63           C  
ATOM   2001  N   THR B  83     -19.712  30.396  41.011  1.00 59.28           N  
ATOM   2002  CA  THR B  83     -21.042  30.933  40.741  1.00 60.21           C  
ATOM   2003  C   THR B  83     -22.010  29.906  41.301  1.00 61.43           C  
ATOM   2004  O   THR B  83     -21.751  28.709  41.203  1.00 61.58           O  
ATOM   2005  CB  THR B  83     -21.263  31.108  39.232  1.00 60.10           C  
ATOM   2006  OG1 THR B  83     -20.194  31.886  38.686  1.00 60.13           O  
ATOM   2007  CG2 THR B  83     -22.587  31.795  38.934  1.00 59.88           C  
ATOM   2008  N   SER B  84     -23.109  30.344  41.905  1.00 62.98           N  
ATOM   2009  CA  SER B  84     -24.046  29.381  42.492  1.00 64.13           C  
ATOM   2010  C   SER B  84     -24.696  28.629  41.340  1.00 65.26           C  
ATOM   2011  O   SER B  84     -24.907  29.207  40.269  1.00 65.52           O  
ATOM   2012  CB  SER B  84     -25.103  30.049  43.379  1.00 64.24           C  
ATOM   2013  OG  SER B  84     -26.324  30.208  42.683  1.00 64.61           O  
ATOM   2014  N   PRO B  85     -25.031  27.348  41.557  1.00 66.59           N  
ATOM   2015  CA  PRO B  85     -25.464  26.481  40.448  1.00 67.30           C  
ATOM   2016  C   PRO B  85     -26.720  27.035  39.786  1.00 68.13           C  
ATOM   2017  O   PRO B  85     -26.895  26.949  38.563  1.00 67.61           O  
ATOM   2018  CB  PRO B  85     -25.755  25.142  41.138  1.00 67.41           C  
ATOM   2019  CG  PRO B  85     -25.976  25.483  42.604  1.00 67.33           C  
ATOM   2020  CD  PRO B  85     -25.087  26.664  42.867  1.00 66.87           C  
ATOM   2021  N   ASN B  86     -27.562  27.615  40.639  1.00 69.25           N  
ATOM   2022  CA  ASN B  86     -28.790  28.288  40.266  1.00 70.09           C  
ATOM   2023  C   ASN B  86     -28.631  29.365  39.187  1.00 70.61           C  
ATOM   2024  O   ASN B  86     -29.517  29.536  38.347  1.00 70.52           O  
ATOM   2025  CB  ASN B  86     -29.373  28.918  41.531  1.00 70.67           C  
ATOM   2026  CG  ASN B  86     -30.832  29.249  41.392  1.00 72.62           C  
ATOM   2027  OD1 ASN B  86     -31.677  28.662  42.073  1.00 75.11           O  
ATOM   2028  ND2 ASN B  86     -31.148  30.182  40.495  1.00 74.63           N  
ATOM   2029  N   TYR B  87     -27.510  30.087  39.212  1.00 71.23           N  
ATOM   2030  CA  TYR B  87     -27.313  31.250  38.335  1.00 71.51           C  
ATOM   2031  C   TYR B  87     -26.248  31.047  37.249  1.00 71.63           C  
ATOM   2032  O   TYR B  87     -25.927  31.979  36.498  1.00 71.66           O  
ATOM   2033  CB  TYR B  87     -27.015  32.498  39.178  1.00 72.24           C  
ATOM   2034  CG  TYR B  87     -28.099  32.775  40.196  1.00 71.94           C  
ATOM   2035  CD1 TYR B  87     -29.305  33.360  39.813  1.00 77.06           C  
ATOM   2036  CD2 TYR B  87     -27.931  32.430  41.533  1.00 69.11           C  
ATOM   2037  CE1 TYR B  87     -30.320  33.602  40.747  1.00 76.35           C  
ATOM   2038  CE2 TYR B  87     -28.932  32.665  42.479  1.00 70.04           C  
ATOM   2039  CZ  TYR B  87     -30.125  33.253  42.080  1.00 72.69           C  
ATOM   2040  OH  TYR B  87     -31.118  33.497  43.008  1.00 73.04           O  
ATOM   2041  N   ILE B  88     -25.718  29.832  37.150  1.00 71.52           N  
ATOM   2042  CA  ILE B  88     -24.833  29.488  36.042  1.00 71.58           C  
ATOM   2043  C   ILE B  88     -25.578  29.687  34.721  1.00 71.60           C  
ATOM   2044  O   ILE B  88     -25.002  30.163  33.735  1.00 71.71           O  
ATOM   2045  CB  ILE B  88     -24.318  28.032  36.146  1.00 71.56           C  
ATOM   2046  CG1 ILE B  88     -23.382  27.888  37.353  1.00 71.75           C  
ATOM   2047  CG2 ILE B  88     -23.591  27.624  34.866  1.00 71.42           C  
ATOM   2048  CD1 ILE B  88     -23.011  26.452  37.698  1.00 71.79           C  
ATOM   2049  N   ALA B  89     -26.863  29.336  34.718  1.00 71.52           N  
ATOM   2050  CA  ALA B  89     -27.701  29.450  33.530  1.00 71.35           C  
ATOM   2051  C   ALA B  89     -27.743  30.880  33.026  1.00 71.18           C  
ATOM   2052  O   ALA B  89     -27.755  31.110  31.816  1.00 71.00           O  
ATOM   2053  CB  ALA B  89     -29.104  28.957  33.826  1.00 71.47           C  
ATOM   2054  N   LYS B  90     -27.737  31.829  33.965  1.00 71.08           N  
ATOM   2055  CA  LYS B  90     -27.794  33.268  33.647  1.00 70.79           C  
ATOM   2056  C   LYS B  90     -26.463  33.840  33.135  1.00 70.40           C  
ATOM   2057  O   LYS B  90     -26.429  34.962  32.623  1.00 70.50           O  
ATOM   2058  CB  LYS B  90     -28.215  34.080  34.874  1.00 71.10           C  
ATOM   2059  CG  LYS B  90     -29.453  33.582  35.600  1.00 71.77           C  
ATOM   2060  CD  LYS B  90     -30.711  33.835  34.807  1.00 72.12           C  
ATOM   2061  CE  LYS B  90     -31.932  33.384  35.592  1.00 72.05           C  
ATOM   2062  NZ  LYS B  90     -33.155  33.477  34.759  1.00 72.32           N  
ATOM   2063  N   GLY B  91     -25.378  33.082  33.287  1.00 69.70           N  
ATOM   2064  CA  GLY B  91     -24.049  33.543  32.880  1.00 69.02           C  
ATOM   2065  C   GLY B  91     -23.494  34.605  33.816  1.00 68.31           C  
ATOM   2066  O   GLY B  91     -22.687  35.439  33.414  1.00 68.35           O  
ATOM   2067  N   TYR B  92     -23.930  34.572  35.071  1.00 67.27           N  
ATOM   2068  CA  TYR B  92     -23.518  35.567  36.042  1.00 66.55           C  
ATOM   2069  C   TYR B  92     -22.058  35.415  36.441  1.00 65.88           C  
ATOM   2070  O   TYR B  92     -21.421  36.398  36.817  1.00 65.93           O  
ATOM   2071  CB  TYR B  92     -24.428  35.532  37.272  1.00 66.08           C  
ATOM   2072  CG  TYR B  92     -25.823  36.090  37.040  1.00 65.70           C  
ATOM   2073  CD1 TYR B  92     -26.163  36.734  35.839  1.00 66.08           C  
ATOM   2074  CD2 TYR B  92     -26.799  36.005  38.041  1.00 66.46           C  
ATOM   2075  CE1 TYR B  92     -27.431  37.258  35.637  1.00 65.71           C  
ATOM   2076  CE2 TYR B  92     -28.077  36.523  37.851  1.00 66.30           C  
ATOM   2077  CZ  TYR B  92     -28.389  37.152  36.643  1.00 65.76           C  
ATOM   2078  OH  TYR B  92     -29.650  37.678  36.427  1.00 67.53           O  
ATOM   2079  N   GLY B  93     -21.532  34.196  36.354  1.00 65.04           N  
ATOM   2080  CA  GLY B  93     -20.095  33.965  36.497  1.00 64.24           C  
ATOM   2081  C   GLY B  93     -19.303  34.799  35.510  1.00 63.46           C  
ATOM   2082  O   GLY B  93     -18.298  35.396  35.868  1.00 63.13           O  
ATOM   2083  N   SER B  94     -19.771  34.851  34.267  1.00 62.83           N  
ATOM   2084  CA  SER B  94     -19.150  35.688  33.241  1.00 62.39           C  
ATOM   2085  C   SER B  94     -19.177  37.186  33.561  1.00 61.93           C  
ATOM   2086  O   SER B  94     -18.228  37.911  33.237  1.00 61.64           O  
ATOM   2087  CB  SER B  94     -19.796  35.455  31.878  1.00 62.29           C  
ATOM   2088  OG  SER B  94     -18.858  34.901  30.983  1.00 62.42           O  
ATOM   2089  N   LEU B  95     -20.259  37.652  34.177  1.00 61.45           N  
ATOM   2090  CA  LEU B  95     -20.345  39.055  34.577  1.00 61.08           C  
ATOM   2091  C   LEU B  95     -19.253  39.419  35.575  1.00 60.47           C  
ATOM   2092  O   LEU B  95     -18.539  40.404  35.389  1.00 60.24           O  
ATOM   2093  CB  LEU B  95     -21.713  39.370  35.189  1.00 61.39           C  
ATOM   2094  CG  LEU B  95     -22.930  39.292  34.260  1.00 61.93           C  
ATOM   2095  CD1 LEU B  95     -24.167  39.796  35.002  1.00 62.37           C  
ATOM   2096  CD2 LEU B  95     -22.706  40.081  32.976  1.00 61.83           C  
ATOM   2097  N   LEU B  96     -19.132  38.626  36.634  1.00 59.75           N  
ATOM   2098  CA  LEU B  96     -18.127  38.879  37.650  1.00 59.55           C  
ATOM   2099  C   LEU B  96     -16.726  38.845  37.045  1.00 59.27           C  
ATOM   2100  O   LEU B  96     -15.918  39.743  37.252  1.00 59.23           O  
ATOM   2101  CB  LEU B  96     -18.231  37.855  38.775  1.00 59.25           C  
ATOM   2102  CG  LEU B  96     -17.269  38.062  39.941  1.00 59.26           C  
ATOM   2103  CD1 LEU B  96     -17.272  39.507  40.377  1.00 59.32           C  
ATOM   2104  CD2 LEU B  96     -17.621  37.163  41.112  1.00 59.34           C  
ATOM   2105  N   PHE B  97     -16.450  37.807  36.278  1.00 59.01           N  
ATOM   2106  CA  PHE B  97     -15.153  37.673  35.660  1.00 58.90           C  
ATOM   2107  C   PHE B  97     -14.773  38.905  34.830  1.00 59.12           C  
ATOM   2108  O   PHE B  97     -13.713  39.478  35.034  1.00 59.06           O  
ATOM   2109  CB  PHE B  97     -15.096  36.424  34.795  1.00 58.02           C  
ATOM   2110  CG  PHE B  97     -13.910  36.384  33.926  1.00 57.54           C  
ATOM   2111  CD1 PHE B  97     -12.718  35.887  34.400  1.00 51.02           C  
ATOM   2112  CD2 PHE B  97     -13.966  36.900  32.647  1.00 60.47           C  
ATOM   2113  CE1 PHE B  97     -11.593  35.878  33.606  1.00 52.68           C  
ATOM   2114  CE2 PHE B  97     -12.854  36.892  31.843  1.00 61.29           C  
ATOM   2115  CZ  PHE B  97     -11.657  36.383  32.323  1.00 57.78           C  
ATOM   2116  N   HIS B  98     -15.628  39.305  33.893  1.00 59.61           N  
ATOM   2117  CA  HIS B  98     -15.314  40.435  33.004  1.00 59.97           C  
ATOM   2118  C   HIS B  98     -15.151  41.754  33.750  1.00 60.18           C  
ATOM   2119  O   HIS B  98     -14.482  42.661  33.272  1.00 59.92           O  
ATOM   2120  CB  HIS B  98     -16.363  40.587  31.899  1.00 59.99           C  
ATOM   2121  CG  HIS B  98     -16.172  39.628  30.773  1.00 60.42           C  
ATOM   2122  ND1 HIS B  98     -16.956  38.508  30.606  1.00 61.05           N  
ATOM   2123  CD2 HIS B  98     -15.257  39.599  29.773  1.00 61.34           C  
ATOM   2124  CE1 HIS B  98     -16.543  37.839  29.542  1.00 61.77           C  
ATOM   2125  NE2 HIS B  98     -15.511  38.478  29.019  1.00 61.64           N  
ATOM   2126  N   GLU B  99     -15.761  41.847  34.922  1.00 60.98           N  
ATOM   2127  CA  GLU B  99     -15.614  43.015  35.774  1.00 61.21           C  
ATOM   2128  C   GLU B  99     -14.225  43.055  36.397  1.00 61.52           C  
ATOM   2129  O   GLU B  99     -13.560  44.100  36.399  1.00 61.58           O  
ATOM   2130  CB  GLU B  99     -16.667  42.987  36.879  1.00 61.45           C  
ATOM   2131  CG  GLU B  99     -16.743  44.260  37.703  1.00 62.37           C  
ATOM   2132  CD  GLU B  99     -17.069  45.498  36.873  1.00 65.07           C  
ATOM   2133  OE1 GLU B  99     -17.623  45.364  35.752  1.00 65.96           O  
ATOM   2134  OE2 GLU B  99     -16.765  46.610  37.361  1.00 67.08           O  
ATOM   2135  N   LEU B 100     -13.795  41.908  36.920  1.00 61.61           N  
ATOM   2136  CA  LEU B 100     -12.476  41.786  37.530  1.00 61.76           C  
ATOM   2137  C   LEU B 100     -11.360  41.953  36.507  1.00 61.94           C  
ATOM   2138  O   LEU B 100     -10.316  42.478  36.828  1.00 61.94           O  
ATOM   2139  CB  LEU B 100     -12.343  40.450  38.254  1.00 61.22           C  
ATOM   2140  CG  LEU B 100     -13.327  40.241  39.406  1.00 60.60           C  
ATOM   2141  CD1 LEU B 100     -13.049  38.926  40.087  1.00 60.29           C  
ATOM   2142  CD2 LEU B 100     -13.261  41.376  40.411  1.00 60.46           C  
ATOM   2143  N   GLU B 101     -11.591  41.514  35.281  1.00 62.64           N  
ATOM   2144  CA  GLU B 101     -10.615  41.662  34.217  1.00 63.56           C  
ATOM   2145  C   GLU B 101     -10.513  43.116  33.795  1.00 64.37           C  
ATOM   2146  O   GLU B 101      -9.434  43.609  33.462  1.00 64.17           O  
ATOM   2147  CB  GLU B 101     -11.035  40.817  33.025  1.00 63.34           C  
ATOM   2148  CG  GLU B 101     -10.190  40.980  31.780  1.00 63.15           C  
ATOM   2149  CD  GLU B 101     -10.673  40.072  30.675  1.00 63.92           C  
ATOM   2150  OE1 GLU B 101     -11.850  40.208  30.268  1.00 65.28           O  
ATOM   2151  OE2 GLU B 101      -9.893  39.209  30.225  1.00 64.01           O  
ATOM   2152  N   LYS B 102     -11.657  43.786  33.790  1.00 65.47           N  
ATOM   2153  CA  LYS B 102     -11.719  45.194  33.473  1.00 66.52           C  
ATOM   2154  C   LYS B 102     -10.884  45.925  34.523  1.00 67.04           C  
ATOM   2155  O   LYS B 102     -10.037  46.751  34.187  1.00 67.07           O  
ATOM   2156  CB  LYS B 102     -13.180  45.684  33.480  1.00 66.82           C  
ATOM   2157  CG  LYS B 102     -13.588  46.523  32.259  1.00 67.68           C  
ATOM   2158  CD  LYS B 102     -15.133  46.547  32.029  1.00 68.03           C  
ATOM   2159  CE  LYS B 102     -15.615  45.698  30.803  1.00 69.12           C  
ATOM   2160  NZ  LYS B 102     -15.930  44.252  31.085  1.00 69.25           N  
ATOM   2161  N   ARG B 103     -11.112  45.588  35.788  1.00 67.67           N  
ATOM   2162  CA  ARG B 103     -10.337  46.135  36.892  1.00 68.14           C  
ATOM   2163  C   ARG B 103      -8.833  45.937  36.699  1.00 68.18           C  
ATOM   2164  O   ARG B 103      -8.074  46.894  36.716  1.00 68.42           O  
ATOM   2165  CB  ARG B 103     -10.783  45.498  38.209  1.00 68.18           C  
ATOM   2166  CG  ARG B 103     -10.070  46.035  39.441  1.00 68.68           C  
ATOM   2167  CD  ARG B 103     -10.665  45.490  40.727  1.00 70.71           C  
ATOM   2168  NE  ARG B 103     -11.635  46.391  41.360  1.00 72.28           N  
ATOM   2169  CZ  ARG B 103     -12.961  46.387  41.164  1.00 73.49           C  
ATOM   2170  NH1 ARG B 103     -13.714  47.256  41.827  1.00 74.18           N  
ATOM   2171  NH2 ARG B 103     -13.556  45.539  40.323  1.00 73.85           N  
ATOM   2172  N   ALA B 104      -8.408  44.698  36.504  1.00 68.33           N  
ATOM   2173  CA  ALA B 104      -6.994  44.384  36.327  1.00 68.52           C  
ATOM   2174  C   ALA B 104      -6.354  45.183  35.207  1.00 68.68           C  
ATOM   2175  O   ALA B 104      -5.241  45.672  35.351  1.00 68.61           O  
ATOM   2176  CB  ALA B 104      -6.816  42.906  36.054  1.00 68.40           C  
ATOM   2177  N   VAL B 105      -7.057  45.296  34.083  1.00 69.23           N  
ATOM   2178  CA  VAL B 105      -6.523  45.966  32.887  1.00 69.49           C  
ATOM   2179  C   VAL B 105      -6.244  47.444  33.136  1.00 69.67           C  
ATOM   2180  O   VAL B 105      -5.262  47.982  32.632  1.00 69.50           O  
ATOM   2181  CB  VAL B 105      -7.473  45.810  31.669  1.00 69.49           C  
ATOM   2182  CG1 VAL B 105      -7.169  46.832  30.588  1.00 69.89           C  
ATOM   2183  CG2 VAL B 105      -7.363  44.415  31.086  1.00 69.33           C  
ATOM   2184  N   TRP B 106      -7.101  48.081  33.923  1.00 70.04           N  
ATOM   2185  CA  TRP B 106      -6.959  49.499  34.233  1.00 70.40           C  
ATOM   2186  C   TRP B 106      -6.112  49.776  35.501  1.00 70.27           C  
ATOM   2187  O   TRP B 106      -6.070  50.905  35.998  1.00 70.58           O  
ATOM   2188  CB  TRP B 106      -8.350  50.142  34.342  1.00 72.11           C  
ATOM   2189  CG  TRP B 106      -9.079  50.286  33.010  1.00 73.62           C  
ATOM   2190  CD1 TRP B 106      -9.601  49.273  32.238  1.00 71.01           C  
ATOM   2191  CD2 TRP B 106      -9.379  51.510  32.314  1.00 74.15           C  
ATOM   2192  NE1 TRP B 106     -10.191  49.789  31.103  1.00 74.66           N  
ATOM   2193  CE2 TRP B 106     -10.072  51.155  31.119  1.00 73.46           C  
ATOM   2194  CE3 TRP B 106      -9.128  52.870  32.578  1.00 72.23           C  
ATOM   2195  CZ2 TRP B 106     -10.530  52.109  30.192  1.00 73.01           C  
ATOM   2196  CZ3 TRP B 106      -9.572  53.829  31.644  1.00 73.59           C  
ATOM   2197  CH2 TRP B 106     -10.263  53.434  30.460  1.00 73.70           C  
ATOM   2198  N   GLU B 107      -5.453  48.743  36.023  1.00 69.49           N  
ATOM   2199  CA  GLU B 107      -4.432  48.886  37.060  1.00 68.68           C  
ATOM   2200  C   GLU B 107      -3.076  48.553  36.428  1.00 67.89           C  
ATOM   2201  O   GLU B 107      -2.091  48.302  37.125  1.00 67.97           O  
ATOM   2202  CB  GLU B 107      -4.709  47.927  38.217  1.00 68.97           C  
ATOM   2203  CG  GLU B 107      -6.122  47.992  38.784  1.00 70.35           C  
ATOM   2204  CD  GLU B 107      -6.194  48.732  40.104  1.00 72.52           C  
ATOM   2205  OE1 GLU B 107      -5.533  49.785  40.217  1.00 74.15           O  
ATOM   2206  OE2 GLU B 107      -6.912  48.265  41.025  1.00 73.44           O  
ATOM   2207  N   GLY B 108      -3.040  48.524  35.097  1.00 66.74           N  
ATOM   2208  CA  GLY B 108      -1.808  48.297  34.355  1.00 65.87           C  
ATOM   2209  C   GLY B 108      -1.312  46.867  34.330  1.00 65.02           C  
ATOM   2210  O   GLY B 108      -0.174  46.622  33.940  1.00 64.90           O  
ATOM   2211  N   ARG B 109      -2.161  45.913  34.709  1.00 63.98           N  
ATOM   2212  CA  ARG B 109      -1.712  44.527  34.834  1.00 63.07           C  
ATOM   2213  C   ARG B 109      -1.679  43.858  33.468  1.00 61.83           C  
ATOM   2214  O   ARG B 109      -2.526  44.130  32.628  1.00 61.99           O  
ATOM   2215  CB  ARG B 109      -2.591  43.767  35.832  1.00 63.51           C  
ATOM   2216  CG  ARG B 109      -2.795  44.499  37.183  1.00 64.79           C  
ATOM   2217  CD  ARG B 109      -1.480  44.919  37.858  1.00 67.00           C  
ATOM   2218  NE  ARG B 109      -1.018  43.938  38.839  1.00 67.72           N  
ATOM   2219  CZ  ARG B 109      -0.616  44.214  40.082  1.00 68.35           C  
ATOM   2220  NH1 ARG B 109      -0.553  45.464  40.534  1.00 68.95           N  
ATOM   2221  NH2 ARG B 109      -0.227  43.230  40.878  1.00 68.36           N  
ATOM   2222  N   ARG B 110      -0.679  43.010  33.244  1.00 60.30           N  
ATOM   2223  CA  ARG B 110      -0.456  42.383  31.936  1.00 59.49           C  
ATOM   2224  C   ARG B 110      -0.942  40.937  31.818  1.00 57.44           C  
ATOM   2225  O   ARG B 110      -1.202  40.466  30.715  1.00 57.37           O  
ATOM   2226  CB  ARG B 110       1.037  42.361  31.618  1.00 59.93           C  
ATOM   2227  CG  ARG B 110       1.733  43.717  31.609  1.00 61.91           C  
ATOM   2228  CD  ARG B 110       3.183  43.595  31.103  1.00 63.60           C  
ATOM   2229  NE  ARG B 110       4.002  42.694  31.933  1.00 66.73           N  
ATOM   2230  CZ  ARG B 110       4.172  41.380  31.726  1.00 68.19           C  
ATOM   2231  NH1 ARG B 110       3.595  40.754  30.697  1.00 68.21           N  
ATOM   2232  NH2 ARG B 110       4.935  40.673  32.562  1.00 68.41           N  
ATOM   2233  N   LYS B 111      -0.982  40.218  32.937  1.00 55.18           N  
ATOM   2234  CA  LYS B 111      -1.331  38.802  32.946  1.00 53.23           C  
ATOM   2235  C   LYS B 111      -2.350  38.523  34.049  1.00 51.35           C  
ATOM   2236  O   LYS B 111      -2.414  39.248  35.046  1.00 50.99           O  
ATOM   2237  CB  LYS B 111      -0.090  37.923  33.146  1.00 52.92           C  
ATOM   2238  CG  LYS B 111       0.907  37.949  32.011  1.00 52.58           C  
ATOM   2239  CD  LYS B 111       2.106  37.030  32.276  1.00 52.97           C  
ATOM   2240  CE  LYS B 111       2.953  37.513  33.459  1.00 53.14           C  
ATOM   2241  NZ  LYS B 111       4.120  36.653  33.832  1.00 52.86           N  
ATOM   2242  N   MET B 112      -3.160  37.485  33.828  1.00 49.19           N  
ATOM   2243  CA  MET B 112      -4.102  36.958  34.823  1.00 47.62           C  
ATOM   2244  C   MET B 112      -3.937  35.454  34.851  1.00 45.67           C  
ATOM   2245  O   MET B 112      -4.005  34.812  33.819  1.00 44.94           O  
ATOM   2246  CB  MET B 112      -5.531  37.342  34.456  1.00 47.53           C  
ATOM   2247  CG  MET B 112      -6.632  36.616  35.219  1.00 48.06           C  
ATOM   2248  SD  MET B 112      -8.253  37.449  35.208  1.00 47.27           S  
ATOM   2249  CE  MET B 112      -8.157  38.423  33.723  1.00 47.12           C  
ATOM   2250  N   TYR B 113      -3.662  34.920  36.034  1.00 44.01           N  
ATOM   2251  CA  TYR B 113      -3.523  33.492  36.240  1.00 43.26           C  
ATOM   2252  C   TYR B 113      -4.785  32.926  36.884  1.00 42.42           C  
ATOM   2253  O   TYR B 113      -5.480  33.615  37.625  1.00 41.85           O  
ATOM   2254  CB  TYR B 113      -2.302  33.179  37.115  1.00 42.40           C  
ATOM   2255  CG  TYR B 113      -0.984  33.423  36.414  1.00 41.49           C  
ATOM   2256  CD1 TYR B 113      -0.477  32.494  35.521  1.00 45.28           C  
ATOM   2257  CD2 TYR B 113      -0.248  34.591  36.633  1.00 38.43           C  
ATOM   2258  CE1 TYR B 113       0.724  32.717  34.857  1.00 44.68           C  
ATOM   2259  CE2 TYR B 113       0.945  34.825  35.962  1.00 38.27           C  
ATOM   2260  CZ  TYR B 113       1.430  33.889  35.081  1.00 40.88           C  
ATOM   2261  OH  TYR B 113       2.623  34.086  34.408  1.00 42.02           O  
ATOM   2262  N   ALA B 114      -5.073  31.663  36.590  1.00 42.00           N  
ATOM   2263  CA  ALA B 114      -6.193  30.959  37.209  1.00 41.94           C  
ATOM   2264  C   ALA B 114      -5.926  29.470  37.186  1.00 41.77           C  
ATOM   2265  O   ALA B 114      -5.121  28.980  36.400  1.00 41.71           O  
ATOM   2266  CB  ALA B 114      -7.494  31.270  36.502  1.00 41.53           C  
ATOM   2267  N   GLN B 115      -6.603  28.754  38.070  1.00 41.80           N  
ATOM   2268  CA  GLN B 115      -6.420  27.323  38.190  1.00 41.96           C  
ATOM   2269  C   GLN B 115      -7.779  26.630  38.302  1.00 42.08           C  
ATOM   2270  O   GLN B 115      -8.751  27.218  38.777  1.00 42.10           O  
ATOM   2271  CB  GLN B 115      -5.538  27.012  39.404  1.00 41.72           C  
ATOM   2272  CG  GLN B 115      -5.070  25.566  39.443  1.00 41.98           C  
ATOM   2273  CD  GLN B 115      -4.071  25.270  40.549  1.00 42.12           C  
ATOM   2274  OE1 GLN B 115      -3.044  24.635  40.305  1.00 43.44           O  
ATOM   2275  NE2 GLN B 115      -4.374  25.701  41.764  1.00 41.68           N  
ATOM   2276  N   THR B 116      -7.847  25.391  37.831  1.00 42.37           N  
ATOM   2277  CA  THR B 116      -9.002  24.523  38.077  1.00 42.42           C  
ATOM   2278  C   THR B 116      -8.562  23.064  38.039  1.00 42.34           C  
ATOM   2279  O   THR B 116      -7.494  22.754  37.525  1.00 41.95           O  
ATOM   2280  CB  THR B 116     -10.112  24.770  37.048  1.00 42.55           C  
ATOM   2281  OG1 THR B 116     -11.342  24.200  37.516  1.00 43.51           O  
ATOM   2282  CG2 THR B 116      -9.752  24.183  35.689  1.00 42.20           C  
ATOM   2283  N   ASN B 117      -9.377  22.166  38.585  1.00 42.78           N  
ATOM   2284  CA  ASN B 117      -9.052  20.732  38.554  1.00 42.91           C  
ATOM   2285  C   ASN B 117      -9.323  20.125  37.174  1.00 42.89           C  
ATOM   2286  O   ASN B 117     -10.129  20.644  36.411  1.00 42.15           O  
ATOM   2287  CB  ASN B 117      -9.821  19.980  39.632  1.00 42.91           C  
ATOM   2288  CG  ASN B 117      -9.330  18.558  39.809  1.00 43.09           C  
ATOM   2289  OD1 ASN B 117      -9.913  17.621  39.269  1.00 43.96           O  
ATOM   2290  ND2 ASN B 117      -8.246  18.395  40.546  1.00 43.18           N  
ATOM   2291  N   HIS B 118      -8.624  19.041  36.845  1.00 43.64           N  
ATOM   2292  CA  HIS B 118      -8.839  18.348  35.560  1.00 44.09           C  
ATOM   2293  C   HIS B 118     -10.278  17.858  35.365  1.00 44.01           C  
ATOM   2294  O   HIS B 118     -10.744  17.749  34.244  1.00 44.09           O  
ATOM   2295  CB  HIS B 118      -7.838  17.213  35.369  1.00 44.49           C  
ATOM   2296  CG  HIS B 118      -8.016  16.066  36.314  1.00 46.13           C  
ATOM   2297  ND1 HIS B 118      -8.809  14.979  36.020  1.00 47.79           N  
ATOM   2298  CD2 HIS B 118      -7.468  15.812  37.524  1.00 47.07           C  
ATOM   2299  CE1 HIS B 118      -8.755  14.114  37.018  1.00 48.04           C  
ATOM   2300  NE2 HIS B 118      -7.948  14.598  37.942  1.00 47.87           N  
ATOM   2301  N   THR B 119     -10.993  17.639  36.461  1.00 44.24           N  
ATOM   2302  CA  THR B 119     -12.397  17.234  36.423  1.00 44.40           C  
ATOM   2303  C   THR B 119     -13.388  18.361  36.117  1.00 44.65           C  
ATOM   2304  O   THR B 119     -14.548  18.101  35.837  1.00 44.89           O  
ATOM   2305  CB  THR B 119     -12.803  16.606  37.766  1.00 44.42           C  
ATOM   2306  OG1 THR B 119     -12.675  17.576  38.809  1.00 44.55           O  
ATOM   2307  CG2 THR B 119     -11.913  15.394  38.092  1.00 44.26           C  
ATOM   2308  N   ASN B 120     -12.957  19.616  36.170  1.00 44.83           N  
ATOM   2309  CA  ASN B 120     -13.897  20.726  36.084  1.00 44.76           C  
ATOM   2310  C   ASN B 120     -14.011  21.273  34.676  1.00 45.30           C  
ATOM   2311  O   ASN B 120     -13.556  22.391  34.394  1.00 45.84           O  
ATOM   2312  CB  ASN B 120     -13.502  21.813  37.058  1.00 44.45           C  
ATOM   2313  CG  ASN B 120     -14.593  22.838  37.268  1.00 44.31           C  
ATOM   2314  OD1 ASN B 120     -15.462  23.045  36.416  1.00 42.44           O  
ATOM   2315  ND2 ASN B 120     -14.546  23.501  38.416  1.00 44.42           N  
ATOM   2316  N   HIS B 121     -14.673  20.498  33.809  1.00 45.53           N  
ATOM   2317  CA  HIS B 121     -14.789  20.831  32.386  1.00 45.54           C  
ATOM   2318  C   HIS B 121     -15.533  22.124  32.131  1.00 45.95           C  
ATOM   2319  O   HIS B 121     -15.237  22.834  31.168  1.00 46.15           O  
ATOM   2320  CB  HIS B 121     -15.434  19.690  31.608  1.00 45.33           C  
ATOM   2321  CG  HIS B 121     -14.559  18.489  31.492  1.00 44.52           C  
ATOM   2322  ND1 HIS B 121     -14.517  17.505  32.459  1.00 44.16           N  
ATOM   2323  CD2 HIS B 121     -13.653  18.137  30.550  1.00 43.89           C  
ATOM   2324  CE1 HIS B 121     -13.629  16.592  32.109  1.00 44.62           C  
ATOM   2325  NE2 HIS B 121     -13.096  16.950  30.952  1.00 44.35           N  
ATOM   2326  N   ARG B 122     -16.486  22.458  32.981  1.00 46.61           N  
ATOM   2327  CA  ARG B 122     -17.172  23.727  32.810  1.00 46.98           C  
ATOM   2328  C   ARG B 122     -16.153  24.878  32.872  1.00 46.77           C  
ATOM   2329  O   ARG B 122     -16.187  25.791  32.032  1.00 46.66           O  
ATOM   2330  CB  ARG B 122     -18.241  23.909  33.873  1.00 47.47           C  
ATOM   2331  CG  ARG B 122     -18.979  25.234  33.772  1.00 47.99           C  
ATOM   2332  CD  ARG B 122     -19.364  25.711  35.137  1.00 49.67           C  
ATOM   2333  NE  ARG B 122     -19.659  27.141  35.196  1.00 51.11           N  
ATOM   2334  CZ  ARG B 122     -19.436  27.894  36.277  1.00 53.82           C  
ATOM   2335  NH1 ARG B 122     -18.898  27.366  37.385  1.00 55.11           N  
ATOM   2336  NH2 ARG B 122     -19.746  29.190  36.265  1.00 54.16           N  
ATOM   2337  N   MET B 123     -15.245  24.812  33.850  1.00 46.19           N  
ATOM   2338  CA  MET B 123     -14.276  25.888  34.056  1.00 46.06           C  
ATOM   2339  C   MET B 123     -13.141  25.831  33.042  1.00 45.91           C  
ATOM   2340  O   MET B 123     -12.652  26.869  32.600  1.00 45.41           O  
ATOM   2341  CB  MET B 123     -13.719  25.892  35.489  1.00 45.68           C  
ATOM   2342  CG  MET B 123     -14.684  26.461  36.533  1.00 44.20           C  
ATOM   2343  SD  MET B 123     -15.499  28.013  36.086  1.00 41.77           S  
ATOM   2344  CE  MET B 123     -14.080  29.026  35.753  1.00 41.67           C  
ATOM   2345  N   ILE B 124     -12.734  24.625  32.662  1.00 46.02           N  
ATOM   2346  CA  ILE B 124     -11.759  24.487  31.592  1.00 46.17           C  
ATOM   2347  C   ILE B 124     -12.263  25.188  30.342  1.00 46.68           C  
ATOM   2348  O   ILE B 124     -11.532  25.939  29.704  1.00 47.01           O  
ATOM   2349  CB  ILE B 124     -11.486  23.029  31.254  1.00 45.97           C  
ATOM   2350  CG1 ILE B 124     -10.690  22.363  32.375  1.00 45.44           C  
ATOM   2351  CG2 ILE B 124     -10.725  22.931  29.926  1.00 46.14           C  
ATOM   2352  CD1 ILE B 124     -10.499  20.862  32.196  1.00 45.44           C  
ATOM   2353  N   ARG B 125     -13.516  24.931  29.989  1.00 47.30           N  
ATOM   2354  CA  ARG B 125     -14.125  25.579  28.843  1.00 47.68           C  
ATOM   2355  C   ARG B 125     -14.228  27.065  29.073  1.00 48.00           C  
ATOM   2356  O   ARG B 125     -13.907  27.856  28.203  1.00 47.72           O  
ATOM   2357  CB  ARG B 125     -15.520  25.030  28.605  1.00 47.71           C  
ATOM   2358  CG  ARG B 125     -15.542  23.654  28.024  1.00 47.74           C  
ATOM   2359  CD  ARG B 125     -16.961  23.239  27.684  1.00 48.20           C  
ATOM   2360  NE  ARG B 125     -16.987  21.799  27.496  1.00 48.72           N  
ATOM   2361  CZ  ARG B 125     -17.685  20.936  28.223  1.00 49.09           C  
ATOM   2362  NH1 ARG B 125     -18.510  21.346  29.182  1.00 48.66           N  
ATOM   2363  NH2 ARG B 125     -17.565  19.641  27.957  1.00 49.42           N  
ATOM   2364  N   PHE B 126     -14.714  27.434  30.250  1.00 48.98           N  
ATOM   2365  CA  PHE B 126     -14.795  28.832  30.631  1.00 49.30           C  
ATOM   2366  C   PHE B 126     -13.477  29.567  30.355  1.00 49.75           C  
ATOM   2367  O   PHE B 126     -13.478  30.603  29.684  1.00 50.00           O  
ATOM   2368  CB  PHE B 126     -15.170  28.965  32.103  1.00 49.95           C  
ATOM   2369  CG  PHE B 126     -15.402  30.383  32.536  1.00 49.71           C  
ATOM   2370  CD1 PHE B 126     -16.664  30.943  32.459  1.00 52.58           C  
ATOM   2371  CD2 PHE B 126     -14.354  31.161  33.002  1.00 48.93           C  
ATOM   2372  CE1 PHE B 126     -16.883  32.247  32.852  1.00 51.87           C  
ATOM   2373  CE2 PHE B 126     -14.561  32.461  33.393  1.00 49.57           C  
ATOM   2374  CZ  PHE B 126     -15.827  33.008  33.326  1.00 50.69           C  
ATOM   2375  N   PHE B 127     -12.362  29.015  30.839  1.00 49.86           N  
ATOM   2376  CA  PHE B 127     -11.056  29.658  30.686  1.00 50.25           C  
ATOM   2377  C   PHE B 127     -10.583  29.694  29.244  1.00 50.59           C  
ATOM   2378  O   PHE B 127     -10.173  30.738  28.745  1.00 50.25           O  
ATOM   2379  CB  PHE B 127      -9.995  29.006  31.597  1.00 49.58           C  
ATOM   2380  CG  PHE B 127     -10.211  29.277  33.077  1.00 49.52           C  
ATOM   2381  CD1 PHE B 127     -10.523  30.555  33.534  1.00 47.86           C  
ATOM   2382  CD2 PHE B 127     -10.088  28.255  34.011  1.00 49.75           C  
ATOM   2383  CE1 PHE B 127     -10.730  30.788  34.876  1.00 48.29           C  
ATOM   2384  CE2 PHE B 127     -10.283  28.491  35.356  1.00 49.33           C  
ATOM   2385  CZ  PHE B 127     -10.607  29.750  35.789  1.00 49.04           C  
ATOM   2386  N   GLU B 128     -10.659  28.564  28.560  1.00 51.61           N  
ATOM   2387  CA  GLU B 128     -10.351  28.552  27.132  1.00 52.57           C  
ATOM   2388  C   GLU B 128     -11.241  29.547  26.377  1.00 52.68           C  
ATOM   2389  O   GLU B 128     -10.805  30.179  25.411  1.00 52.99           O  
ATOM   2390  CB  GLU B 128     -10.501  27.154  26.555  1.00 52.79           C  
ATOM   2391  CG  GLU B 128      -9.471  26.149  27.082  1.00 53.95           C  
ATOM   2392  CD  GLU B 128      -9.582  24.784  26.392  1.00 54.83           C  
ATOM   2393  OE1 GLU B 128     -10.461  24.620  25.501  1.00 57.49           O  
ATOM   2394  OE2 GLU B 128      -8.791  23.870  26.739  1.00 57.44           O  
ATOM   2395  N   SER B 129     -12.472  29.703  26.846  1.00 52.78           N  
ATOM   2396  CA  SER B 129     -13.430  30.619  26.229  1.00 52.86           C  
ATOM   2397  C   SER B 129     -13.015  32.078  26.378  1.00 52.94           C  
ATOM   2398  O   SER B 129     -13.249  32.874  25.473  1.00 53.10           O  
ATOM   2399  CB  SER B 129     -14.826  30.415  26.826  1.00 52.96           C  
ATOM   2400  OG  SER B 129     -15.594  31.598  26.732  1.00 53.71           O  
ATOM   2401  N   LYS B 130     -12.409  32.420  27.514  1.00 52.73           N  
ATOM   2402  CA  LYS B 130     -12.052  33.801  27.822  1.00 52.25           C  
ATOM   2403  C   LYS B 130     -10.653  34.207  27.358  1.00 51.66           C  
ATOM   2404  O   LYS B 130     -10.224  35.327  27.614  1.00 51.49           O  
ATOM   2405  CB  LYS B 130     -12.177  34.042  29.319  1.00 52.82           C  
ATOM   2406  CG  LYS B 130     -13.563  33.799  29.863  1.00 53.89           C  
ATOM   2407  CD  LYS B 130     -14.588  34.716  29.223  1.00 55.10           C  
ATOM   2408  CE  LYS B 130     -15.955  34.515  29.845  1.00 55.44           C  
ATOM   2409  NZ  LYS B 130     -17.001  34.816  28.836  1.00 57.38           N  
ATOM   2410  N   GLY B 131      -9.953  33.309  26.677  1.00 50.84           N  
ATOM   2411  CA  GLY B 131      -8.652  33.621  26.107  1.00 50.34           C  
ATOM   2412  C   GLY B 131      -7.455  33.082  26.874  1.00 49.99           C  
ATOM   2413  O   GLY B 131      -6.310  33.392  26.524  1.00 50.29           O  
ATOM   2414  N   PHE B 132      -7.698  32.268  27.906  1.00 49.07           N  
ATOM   2415  CA  PHE B 132      -6.608  31.713  28.698  1.00 48.26           C  
ATOM   2416  C   PHE B 132      -5.981  30.583  27.928  1.00 47.61           C  
ATOM   2417  O   PHE B 132      -6.543  30.098  26.973  1.00 47.64           O  
ATOM   2418  CB  PHE B 132      -7.082  31.166  30.039  1.00 47.95           C  
ATOM   2419  CG  PHE B 132      -7.504  32.216  31.030  1.00 47.33           C  
ATOM   2420  CD1 PHE B 132      -8.701  32.890  30.882  1.00 48.70           C  
ATOM   2421  CD2 PHE B 132      -6.731  32.485  32.139  1.00 46.22           C  
ATOM   2422  CE1 PHE B 132      -9.095  33.834  31.805  1.00 48.24           C  
ATOM   2423  CE2 PHE B 132      -7.130  33.420  33.064  1.00 46.75           C  
ATOM   2424  CZ  PHE B 132      -8.308  34.097  32.900  1.00 47.04           C  
ATOM   2425  N   THR B 133      -4.819  30.155  28.391  1.00 47.34           N  
ATOM   2426  CA  THR B 133      -4.044  29.093  27.777  1.00 46.95           C  
ATOM   2427  C   THR B 133      -3.513  28.234  28.908  1.00 46.42           C  
ATOM   2428  O   THR B 133      -2.903  28.758  29.825  1.00 46.87           O  
ATOM   2429  CB  THR B 133      -2.849  29.698  27.043  1.00 47.17           C  
ATOM   2430  OG1 THR B 133      -3.263  30.897  26.368  1.00 48.36           O  
ATOM   2431  CG2 THR B 133      -2.257  28.725  26.070  1.00 46.95           C  
ATOM   2432  N   LYS B 134      -3.770  26.935  28.877  1.00 45.88           N  
ATOM   2433  CA  LYS B 134      -3.205  26.027  29.873  1.00 45.62           C  
ATOM   2434  C   LYS B 134      -1.692  26.080  29.719  1.00 45.24           C  
ATOM   2435  O   LYS B 134      -1.204  26.037  28.604  1.00 45.94           O  
ATOM   2436  CB  LYS B 134      -3.726  24.593  29.675  1.00 45.44           C  
ATOM   2437  CG  LYS B 134      -3.106  23.576  30.603  1.00 45.62           C  
ATOM   2438  CD  LYS B 134      -3.933  22.299  30.714  1.00 45.92           C  
ATOM   2439  CE  LYS B 134      -3.377  21.153  29.899  1.00 46.29           C  
ATOM   2440  NZ  LYS B 134      -1.951  20.862  30.251  1.00 47.20           N  
ATOM   2441  N   ILE B 135      -0.947  26.209  30.814  1.00 44.54           N  
ATOM   2442  CA  ILE B 135       0.518  26.256  30.722  1.00 43.84           C  
ATOM   2443  C   ILE B 135       1.212  25.234  31.585  1.00 43.46           C  
ATOM   2444  O   ILE B 135       2.404  25.054  31.450  1.00 43.53           O  
ATOM   2445  CB  ILE B 135       1.070  27.648  31.071  1.00 43.65           C  
ATOM   2446  CG1 ILE B 135       0.551  28.100  32.445  1.00 43.71           C  
ATOM   2447  CG2 ILE B 135       0.666  28.643  29.994  1.00 43.20           C  
ATOM   2448  CD1 ILE B 135       1.152  29.383  32.965  1.00 43.45           C  
ATOM   2449  N   HIS B 136       0.482  24.547  32.459  1.00 43.24           N  
ATOM   2450  CA  HIS B 136       1.107  23.638  33.420  1.00 43.31           C  
ATOM   2451  C   HIS B 136       0.082  22.727  34.100  1.00 43.25           C  
ATOM   2452  O   HIS B 136      -1.078  23.102  34.269  1.00 43.11           O  
ATOM   2453  CB  HIS B 136       1.828  24.470  34.487  1.00 42.99           C  
ATOM   2454  CG  HIS B 136       2.718  23.674  35.382  1.00 42.26           C  
ATOM   2455  ND1 HIS B 136       3.757  22.903  34.905  1.00 41.08           N  
ATOM   2456  CD2 HIS B 136       2.744  23.555  36.729  1.00 41.34           C  
ATOM   2457  CE1 HIS B 136       4.376  22.332  35.920  1.00 41.56           C  
ATOM   2458  NE2 HIS B 136       3.776  22.705  37.038  1.00 42.11           N  
ATOM   2459  N   GLU B 137       0.528  21.538  34.495  1.00 43.52           N  
ATOM   2460  CA  GLU B 137      -0.273  20.632  35.311  1.00 44.07           C  
ATOM   2461  C   GLU B 137       0.497  20.296  36.579  1.00 43.89           C  
ATOM   2462  O   GLU B 137       1.714  20.118  36.535  1.00 43.34           O  
ATOM   2463  CB  GLU B 137      -0.579  19.352  34.542  1.00 44.21           C  
ATOM   2464  CG  GLU B 137      -1.518  19.565  33.350  1.00 45.59           C  
ATOM   2465  CD  GLU B 137      -1.701  18.316  32.473  1.00 45.92           C  
ATOM   2466  OE1 GLU B 137      -2.254  18.465  31.349  1.00 47.85           O  
ATOM   2467  OE2 GLU B 137      -1.287  17.202  32.901  1.00 47.44           O  
ATOM   2468  N   SER B 138      -0.205  20.208  37.707  1.00 44.23           N  
ATOM   2469  CA  SER B 138       0.458  19.966  38.990  1.00 44.39           C  
ATOM   2470  C   SER B 138      -0.474  19.426  40.044  1.00 44.66           C  
ATOM   2471  O   SER B 138      -1.668  19.709  40.045  1.00 44.57           O  
ATOM   2472  CB  SER B 138       1.060  21.264  39.528  1.00 44.59           C  
ATOM   2473  OG  SER B 138       0.041  22.178  39.938  1.00 45.22           O  
ATOM   2474  N   LEU B 139       0.095  18.668  40.963  1.00 45.30           N  
ATOM   2475  CA  LEU B 139      -0.603  18.286  42.170  1.00 46.30           C  
ATOM   2476  C   LEU B 139      -0.621  19.470  43.117  1.00 46.57           C  
ATOM   2477  O   LEU B 139       0.279  20.293  43.078  1.00 46.70           O  
ATOM   2478  CB  LEU B 139       0.111  17.109  42.820  1.00 46.43           C  
ATOM   2479  CG  LEU B 139       0.251  15.882  41.908  1.00 46.91           C  
ATOM   2480  CD1 LEU B 139       1.044  14.789  42.597  1.00 46.83           C  
ATOM   2481  CD2 LEU B 139      -1.128  15.390  41.498  1.00 47.15           C  
ATOM   2482  N   GLN B 140      -1.653  19.558  43.949  1.00 47.32           N  
ATOM   2483  CA  GLN B 140      -1.818  20.666  44.889  1.00 48.15           C  
ATOM   2484  C   GLN B 140      -1.855  20.177  46.336  1.00 49.29           C  
ATOM   2485  O   GLN B 140      -2.451  19.140  46.642  1.00 49.51           O  
ATOM   2486  CB  GLN B 140      -3.110  21.433  44.602  1.00 47.62           C  
ATOM   2487  CG  GLN B 140      -3.080  22.222  43.323  1.00 46.64           C  
ATOM   2488  CD  GLN B 140      -2.098  23.376  43.367  1.00 45.03           C  
ATOM   2489  OE1 GLN B 140      -0.956  23.257  42.888  1.00 43.42           O  
ATOM   2490  NE2 GLN B 140      -2.533  24.499  43.945  1.00 42.35           N  
ATOM   2491  N   MET B 141      -1.240  20.948  47.227  1.00 50.52           N  
ATOM   2492  CA  MET B 141      -1.160  20.586  48.639  1.00 51.00           C  
ATOM   2493  C   MET B 141      -2.551  20.350  49.263  1.00 51.88           C  
ATOM   2494  O   MET B 141      -3.502  21.111  49.025  1.00 51.58           O  
ATOM   2495  CB  MET B 141      -0.398  21.665  49.406  1.00 50.91           C  
ATOM   2496  CG  MET B 141      -0.064  21.304  50.843  1.00 50.91           C  
ATOM   2497  SD  MET B 141       0.914  22.617  51.613  1.00 50.82           S  
ATOM   2498  CE  MET B 141       2.549  22.216  50.994  1.00 50.00           C  
ATOM   2499  N   ASN B 142      -2.635  19.274  50.052  1.00 52.85           N  
ATOM   2500  CA  ASN B 142      -3.861  18.858  50.756  1.00 53.43           C  
ATOM   2501  C   ASN B 142      -4.984  18.373  49.852  1.00 53.99           C  
ATOM   2502  O   ASN B 142      -6.120  18.238  50.300  1.00 54.56           O  
ATOM   2503  CB  ASN B 142      -4.385  19.979  51.665  1.00 53.83           C  
ATOM   2504  CG  ASN B 142      -3.386  20.369  52.727  1.00 54.67           C  
ATOM   2505  OD1 ASN B 142      -3.278  21.535  53.077  1.00 55.82           O  
ATOM   2506  ND2 ASN B 142      -2.644  19.386  53.248  1.00 56.14           N  
ATOM   2507  N   ARG B 143      -4.667  18.107  48.589  1.00 54.15           N  
ATOM   2508  CA  ARG B 143      -5.664  17.695  47.618  1.00 53.93           C  
ATOM   2509  C   ARG B 143      -5.050  16.820  46.550  1.00 54.11           C  
ATOM   2510  O   ARG B 143      -5.517  16.841  45.419  1.00 54.21           O  
ATOM   2511  CB  ARG B 143      -6.302  18.921  46.959  1.00 53.77           C  
ATOM   2512  CG  ARG B 143      -7.158  19.765  47.881  1.00 53.57           C  
ATOM   2513  CD  ARG B 143      -7.792  20.914  47.130  1.00 53.13           C  
ATOM   2514  NE  ARG B 143      -6.774  21.845  46.663  1.00 52.01           N  
ATOM   2515  CZ  ARG B 143      -6.997  22.904  45.890  1.00 51.81           C  
ATOM   2516  NH1 ARG B 143      -8.215  23.220  45.462  1.00 51.53           N  
ATOM   2517  NH2 ARG B 143      -5.979  23.663  45.542  1.00 52.53           N  
ATOM   2518  N   LEU B 144      -4.023  16.037  46.876  1.00 54.44           N  
ATOM   2519  CA  LEU B 144      -3.430  15.193  45.835  1.00 54.97           C  
ATOM   2520  C   LEU B 144      -4.360  14.045  45.467  1.00 54.83           C  
ATOM   2521  O   LEU B 144      -4.297  13.508  44.360  1.00 54.94           O  
ATOM   2522  CB  LEU B 144      -2.026  14.697  46.175  1.00 55.83           C  
ATOM   2523  CG  LEU B 144      -1.791  13.910  47.443  1.00 57.44           C  
ATOM   2524  CD1 LEU B 144      -0.948  12.645  47.100  1.00 58.26           C  
ATOM   2525  CD2 LEU B 144      -1.110  14.827  48.509  1.00 58.35           C  
ATOM   2526  N   ASP B 145      -5.215  13.690  46.420  1.00 54.43           N  
ATOM   2527  CA  ASP B 145      -6.495  13.014  46.174  1.00 53.70           C  
ATOM   2528  C   ASP B 145      -7.068  13.318  44.785  1.00 52.86           C  
ATOM   2529  O   ASP B 145      -7.418  12.421  44.036  1.00 52.70           O  
ATOM   2530  CB  ASP B 145      -7.538  13.472  47.225  1.00 54.43           C  
ATOM   2531  CG  ASP B 145      -6.906  14.191  48.482  1.00 55.80           C  
ATOM   2532  OD1 ASP B 145      -5.791  13.813  48.926  1.00 56.67           O  
ATOM   2533  OD2 ASP B 145      -7.551  15.132  49.038  1.00 57.09           O  
ATOM   2534  N   PHE B 146      -7.149  14.603  44.453  1.00 51.79           N  
ATOM   2535  CA  PHE B 146      -7.879  15.063  43.282  1.00 50.84           C  
ATOM   2536  C   PHE B 146      -7.047  15.167  41.997  1.00 49.83           C  
ATOM   2537  O   PHE B 146      -7.553  15.635  40.975  1.00 49.46           O  
ATOM   2538  CB  PHE B 146      -8.512  16.435  43.560  1.00 50.53           C  
ATOM   2539  CG  PHE B 146      -9.403  16.485  44.771  1.00 50.11           C  
ATOM   2540  CD1 PHE B 146      -9.878  15.327  45.387  1.00 54.94           C  
ATOM   2541  CD2 PHE B 146      -9.808  17.711  45.265  1.00 47.86           C  
ATOM   2542  CE1 PHE B 146     -10.711  15.412  46.497  1.00 53.01           C  
ATOM   2543  CE2 PHE B 146     -10.639  17.803  46.362  1.00 47.84           C  
ATOM   2544  CZ  PHE B 146     -11.090  16.661  46.982  1.00 50.11           C  
ATOM   2545  N   GLY B 147      -5.790  14.746  42.029  1.00 48.94           N  
ATOM   2546  CA  GLY B 147      -4.999  14.663  40.797  1.00 48.49           C  
ATOM   2547  C   GLY B 147      -4.627  16.004  40.172  1.00 48.04           C  
ATOM   2548  O   GLY B 147      -4.498  17.013  40.861  1.00 48.47           O  
ATOM   2549  N   SER B 148      -4.454  16.022  38.859  1.00 47.13           N  
ATOM   2550  CA  SER B 148      -3.896  17.187  38.191  1.00 46.58           C  
ATOM   2551  C   SER B 148      -4.794  18.423  38.228  1.00 45.99           C  
ATOM   2552  O   SER B 148      -6.002  18.351  37.951  1.00 45.97           O  
ATOM   2553  CB  SER B 148      -3.534  16.857  36.738  1.00 47.04           C  
ATOM   2554  OG  SER B 148      -2.204  16.352  36.664  1.00 48.30           O  
ATOM   2555  N   PHE B 149      -4.187  19.557  38.586  1.00 44.88           N  
ATOM   2556  CA  PHE B 149      -4.821  20.859  38.443  1.00 43.94           C  
ATOM   2557  C   PHE B 149      -4.171  21.568  37.258  1.00 43.27           C  
ATOM   2558  O   PHE B 149      -2.978  21.433  37.015  1.00 42.76           O  
ATOM   2559  CB  PHE B 149      -4.652  21.670  39.712  1.00 43.20           C  
ATOM   2560  CG  PHE B 149      -5.572  21.269  40.833  1.00 42.79           C  
ATOM   2561  CD1 PHE B 149      -6.696  22.036  41.136  1.00 42.16           C  
ATOM   2562  CD2 PHE B 149      -5.292  20.152  41.617  1.00 42.26           C  
ATOM   2563  CE1 PHE B 149      -7.525  21.689  42.189  1.00 42.41           C  
ATOM   2564  CE2 PHE B 149      -6.120  19.798  42.679  1.00 42.13           C  
ATOM   2565  CZ  PHE B 149      -7.237  20.563  42.963  1.00 42.29           C  
ATOM   2566  N   TYR B 150      -4.969  22.304  36.508  1.00 43.36           N  
ATOM   2567  CA  TYR B 150      -4.503  22.963  35.304  1.00 43.66           C  
ATOM   2568  C   TYR B 150      -4.323  24.440  35.570  1.00 43.42           C  
ATOM   2569  O   TYR B 150      -5.253  25.093  36.045  1.00 42.79           O  
ATOM   2570  CB  TYR B 150      -5.521  22.804  34.171  1.00 44.15           C  
ATOM   2571  CG  TYR B 150      -5.776  21.385  33.689  1.00 44.39           C  
ATOM   2572  CD1 TYR B 150      -5.011  20.311  34.132  1.00 44.48           C  
ATOM   2573  CD2 TYR B 150      -6.775  21.136  32.743  1.00 44.63           C  
ATOM   2574  CE1 TYR B 150      -5.252  19.031  33.672  1.00 44.90           C  
ATOM   2575  CE2 TYR B 150      -7.024  19.863  32.279  1.00 44.38           C  
ATOM   2576  CZ  TYR B 150      -6.262  18.816  32.747  1.00 44.89           C  
ATOM   2577  OH  TYR B 150      -6.504  17.555  32.279  1.00 45.36           O  
ATOM   2578  N   LEU B 151      -3.136  24.952  35.232  1.00 43.48           N  
ATOM   2579  CA  LEU B 151      -2.789  26.365  35.396  1.00 43.91           C  
ATOM   2580  C   LEU B 151      -2.984  27.107  34.086  1.00 43.84           C  
ATOM   2581  O   LEU B 151      -2.498  26.674  33.052  1.00 43.56           O  
ATOM   2582  CB  LEU B 151      -1.329  26.498  35.841  1.00 43.71           C  
ATOM   2583  CG  LEU B 151      -0.791  27.907  36.112  1.00 43.49           C  
ATOM   2584  CD1 LEU B 151      -1.522  28.594  37.255  1.00 42.96           C  
ATOM   2585  CD2 LEU B 151       0.694  27.853  36.390  1.00 43.96           C  
ATOM   2586  N   TYR B 152      -3.674  28.233  34.149  1.00 44.63           N  
ATOM   2587  CA  TYR B 152      -4.026  29.015  32.971  1.00 46.09           C  
ATOM   2588  C   TYR B 152      -3.496  30.431  33.074  1.00 46.90           C  
ATOM   2589  O   TYR B 152      -3.447  31.002  34.157  1.00 46.80           O  
ATOM   2590  CB  TYR B 152      -5.553  29.080  32.831  1.00 45.91           C  
ATOM   2591  CG  TYR B 152      -6.149  27.789  32.369  1.00 45.63           C  
ATOM   2592  CD1 TYR B 152      -6.220  27.490  31.015  1.00 48.47           C  
ATOM   2593  CD2 TYR B 152      -6.613  26.849  33.284  1.00 44.89           C  
ATOM   2594  CE1 TYR B 152      -6.749  26.290  30.583  1.00 47.70           C  
ATOM   2595  CE2 TYR B 152      -7.151  25.650  32.866  1.00 44.77           C  
ATOM   2596  CZ  TYR B 152      -7.217  25.373  31.518  1.00 46.16           C  
ATOM   2597  OH  TYR B 152      -7.732  24.181  31.088  1.00 47.72           O  
ATOM   2598  N   VAL B 153      -3.133  31.014  31.946  1.00 48.28           N  
ATOM   2599  CA  VAL B 153      -2.743  32.411  31.943  1.00 49.95           C  
ATOM   2600  C   VAL B 153      -3.419  33.125  30.801  1.00 51.49           C  
ATOM   2601  O   VAL B 153      -3.552  32.569  29.722  1.00 51.80           O  
ATOM   2602  CB  VAL B 153      -1.197  32.577  31.852  1.00 49.73           C  
ATOM   2603  CG1 VAL B 153      -0.654  32.071  30.510  1.00 49.63           C  
ATOM   2604  CG2 VAL B 153      -0.786  34.029  32.114  1.00 48.78           C  
ATOM   2605  N   LYS B 154      -3.868  34.345  31.052  1.00 53.77           N  
ATOM   2606  CA  LYS B 154      -4.343  35.222  29.994  1.00 55.51           C  
ATOM   2607  C   LYS B 154      -3.454  36.470  29.889  1.00 57.56           C  
ATOM   2608  O   LYS B 154      -3.139  37.096  30.908  1.00 57.21           O  
ATOM   2609  CB  LYS B 154      -5.779  35.649  30.265  1.00 55.07           C  
ATOM   2610  CG  LYS B 154      -6.413  36.269  29.049  1.00 54.58           C  
ATOM   2611  CD  LYS B 154      -7.721  36.945  29.344  1.00 54.90           C  
ATOM   2612  CE  LYS B 154      -8.244  37.617  28.092  1.00 54.16           C  
ATOM   2613  NZ  LYS B 154      -9.672  37.985  28.245  1.00 54.35           N  
ATOM   2614  N   GLU B 155      -3.074  36.833  28.661  1.00 60.30           N  
ATOM   2615  CA  GLU B 155      -2.404  38.116  28.387  1.00 62.63           C  
ATOM   2616  C   GLU B 155      -3.466  39.220  28.286  1.00 64.45           C  
ATOM   2617  O   GLU B 155      -4.499  39.011  27.682  1.00 64.44           O  
ATOM   2618  CB  GLU B 155      -1.611  38.046  27.088  1.00 62.97           C  
ATOM   2619  CG  GLU B 155      -0.704  36.807  26.919  1.00 65.36           C  
ATOM   2620  CD  GLU B 155       0.623  36.859  27.692  1.00 68.30           C  
ATOM   2621  OE1 GLU B 155       1.186  35.766  27.959  1.00 70.04           O  
ATOM   2622  OE2 GLU B 155       1.116  37.969  28.020  1.00 70.08           O  
ATOM   2623  N   LEU B 156      -3.213  40.394  28.854  1.00 67.01           N  
ATOM   2624  CA  LEU B 156      -4.277  41.378  29.073  1.00 69.29           C  
ATOM   2625  C   LEU B 156      -4.266  42.667  28.228  1.00 71.57           C  
ATOM   2626  O   LEU B 156      -4.933  43.638  28.597  1.00 71.88           O  
ATOM   2627  CB  LEU B 156      -4.302  41.776  30.558  1.00 69.06           C  
ATOM   2628  CG  LEU B 156      -4.899  40.787  31.549  1.00 68.83           C  
ATOM   2629  CD1 LEU B 156      -5.076  41.452  32.893  1.00 68.64           C  
ATOM   2630  CD2 LEU B 156      -6.231  40.269  31.053  1.00 69.13           C  
ATOM   2631  N   GLU B 157      -3.584  42.705  27.090  1.00 74.16           N  
ATOM   2632  CA  GLU B 157      -3.459  43.998  26.390  1.00 76.12           C  
ATOM   2633  C   GLU B 157      -3.503  43.955  24.850  1.00 77.79           C  
ATOM   2634  O   GLU B 157      -2.475  44.077  24.172  1.00 78.03           O  
ATOM   2635  CB  GLU B 157      -2.219  44.728  26.909  1.00 76.45           C  
ATOM   2636  CG  GLU B 157      -1.089  43.800  27.373  1.00 77.08           C  
ATOM   2637  CD  GLU B 157      -0.065  44.525  28.237  1.00 77.47           C  
ATOM   2638  OE1 GLU B 157       1.154  44.373  27.978  1.00 79.13           O  
ATOM   2639  OE2 GLU B 157      -0.479  45.254  29.175  1.00 78.50           O  
ATOM   2640  N   ASN B 158      -4.722  43.816  24.324  1.00 79.44           N  
ATOM   2641  CA  ASN B 158      -4.989  43.761  22.872  1.00 80.40           C  
ATOM   2642  C   ASN B 158      -6.480  44.077  22.579  1.00 81.37           C  
ATOM   2643  O   ASN B 158      -7.145  44.700  23.413  1.00 81.60           O  
ATOM   2644  CB  ASN B 158      -4.541  42.401  22.291  1.00 80.81           C  
ATOM   2645  CG  ASN B 158      -5.124  41.201  23.051  1.00 81.68           C  
ATOM   2646  OD1 ASN B 158      -6.326  41.147  23.344  1.00 82.77           O  
ATOM   2647  ND2 ASN B 158      -4.265  40.228  23.361  1.00 81.85           N  
ATOM   2648  N   GLN B 159      -7.005  43.679  21.415  1.00 82.17           N  
ATOM   2649  CA  GLN B 159      -8.417  43.951  21.077  1.00 82.30           C  
ATOM   2650  C   GLN B 159      -8.932  43.017  19.981  1.00 82.47           C  
ATOM   2651  O   GLN B 159      -9.791  42.174  20.228  1.00 82.47           O  
ATOM   2652  CB  GLN B 159      -8.585  45.425  20.656  1.00 82.66           C  
ATOM   2653  CG  GLN B 159     -10.015  45.984  20.750  1.00 82.57           C  
ATOM   2654  CD  GLN B 159     -10.095  47.502  20.528  1.00 82.63           C  
ATOM   2655  OE1 GLN B 159     -11.173  48.082  20.595  1.00 82.32           O  
ATOM   2656  NE2 GLN B 159      -8.957  48.139  20.262  1.00 82.69           N  
TER    2657      GLN B 159                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
