
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  151 ( 1202),  selected  151 , name 2cnm_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 2cnm_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      A       2          1.878
LGA    N     2_A      I       3          1.606
LGA    T     3_A      N       4          1.067
LGA    I     4_A      I       5          0.949
LGA    S     5_A      I       6          1.305
LGA    I     6_A      E       7          0.854
LGA    L     7_A      Y       8          0.844
LGA    S     8_A      N       9          1.670
LGA    T     9_A      R      10          1.013
LGA    T    10_A      S      11          1.118
LGA    D    11_A      Y      12          1.478
LGA    L    12_A      K      13          1.558
LGA    P    13_A      E      14          1.704
LGA    A    14_A      E      15          1.681
LGA    A    15_A      L      16          1.087
LGA    W    16_A      I      17          1.308
LGA    Q    17_A      E      18          1.926
LGA    I    18_A      F      19          0.928
LGA    E    19_A      I      20          0.720
LGA    Q    20_A      L      21          1.925
LGA    R    21_A      S      22          1.898
LGA    A    22_A      I      23          1.344
LGA    H    23_A      Q      24          1.154
LGA    A    24_A      K      25          2.813
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    -       -      N      29           -
LGA    F    25_A      I      30          2.558
LGA    P    26_A      K      31           #
LGA    W    27_A      I      32          4.935
LGA    S    28_A      D      33          3.343
LGA    E    29_A      R      34          2.985
LGA    K    30_A      D      35          4.473
LGA    -       -      D      36           -
LGA    -       -      Q      37           -
LGA    T    31_A      P      38          1.512
LGA    F    32_A      D      39          4.782
LGA    F    33_A      L      40          2.989
LGA    G    34_A      E      41          3.313
LGA    N    35_A      N      42           #
LGA    Q    36_A      I      43          1.822
LGA    G    37_A      E      44          2.941
LGA    -       -      H      45           -
LGA    -       -      N      46           -
LGA    -       -      Y      47           -
LGA    -       -      L      48           -
LGA    E    38_A      N      49          2.843
LGA    R    39_A      S      50          1.657
LGA    -       -      G      51           -
LGA    Y    40_A      G      52          3.404
LGA    L    41_A      Q      53          1.159
LGA    N    42_A      F      54          0.890
LGA    L    43_A      W      55          0.902
LGA    K    44_A      L      56          0.576
LGA    L    45_A      A      57          0.709
LGA    T    46_A      I      58          1.059
LGA    A    47_A      N      59          1.900
LGA    D    48_A      N      60          1.521
LGA    D    49_A      H      61          1.405
LGA    R    50_A      Q      62          3.674
LGA    M    51_A      N      63          2.840
LGA    -       -      I      64           -
LGA    A    52_A      V      65          0.653
LGA    A    53_A      G      66          0.969
LGA    F    54_A      T      67          1.097
LGA    A    55_A      I      68          1.370
LGA    I    56_A      G      69          2.045
LGA    T    57_A      L      70          1.461
LGA    Q    58_A      I      71          0.568
LGA    V    59_A      R      72          1.046
LGA    V    60_A      L      73          2.673
LGA    L    61_A      D      74          3.981
LGA    -       -      N      75           -
LGA    D    62_A      N      76          1.598
LGA    E    63_A      M      77          1.024
LGA    A    64_A      S      78          0.881
LGA    T    65_A      A      79          0.341
LGA    L    66_A      L      80          1.049
LGA    F    67_A      K      81          2.266
LGA    N    68_A      K      82          1.558
LGA    I    69_A      M      83          0.914
LGA    A    70_A      F      84          1.279
LGA    V    71_A      V      85          1.153
LGA    D    72_A      D      86          1.866
LGA    P    73_A      K      87          1.871
LGA    D    74_A      G      88          2.389
LGA    F    75_A      Y      89          1.922
LGA    Q    76_A      R      90          2.014
LGA    R    77_A      N      91          2.923
LGA    R    78_A      L      92          2.323
LGA    G    79_A      K      93          1.470
LGA    L    80_A      I      94          0.752
LGA    G    81_A      G      95          1.253
LGA    R    82_A      K      96          1.568
LGA    M    83_A      K      97          1.215
LGA    L    84_A      L      98          0.634
LGA    L    85_A      L      99          1.080
LGA    E    86_A      D     100          1.268
LGA    H    87_A      K     101          1.041
LGA    L    88_A      V     102          0.949
LGA    I    89_A      I     103          0.990
LGA    D    90_A      M     104          0.803
LGA    E    91_A      T     105          0.848
LGA    L    92_A      C     106          0.925
LGA    E    93_A      K     107          0.981
LGA    T    94_A      E     108          0.707
LGA    R    95_A      Q     109          0.740
LGA    G    96_A      N     110          0.721
LGA    V    97_A      I     111          0.760
LGA    V    98_A      D     112          1.046
LGA    T    99_A      G     113          0.531
LGA    L   100_A      I     114          0.600
LGA    W   101_A      Y     115          0.793
LGA    L   102_A      L     116          0.505
LGA    E   103_A      G     117          0.759
LGA    V   104_A      T     118          1.477
LGA    R   105_A      I     119          1.087
LGA    A   106_A      D     120          2.487
LGA    S   107_A      K     121          4.053
LGA    N   108_A      F     122          2.725
LGA    A   109_A      I     123          2.763
LGA    A   110_A      S     124          0.753
LGA    A   111_A      A     125          0.611
LGA    I   112_A      Q     126          1.207
LGA    A   113_A      Y     127          0.929
LGA    L   114_A      F     128          0.776
LGA    Y   115_A      Y     129          0.735
LGA    E   116_A      S     130          0.889
LGA    S   117_A      N     131          0.986
LGA    L   118_A      N     132          0.822
LGA    G   119_A      G     133          0.488
LGA    F   120_A      F     134          0.223
LGA    N   121_A      R     135          0.389
LGA    E   122_A      E     136          0.736
LGA    A   123_A      I     137          1.463
LGA    T   124_A      K     138          0.886
LGA    I   125_A      -       -           -
LGA    R   126_A      R     139          4.109
LGA    R   127_A      G     140           -
LGA    N   128_A      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    Y   129_A      L     149           #
LGA    Y   130_A      D     150          5.155
LGA    P   131_A      V     151          4.943
LGA    T   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    Q   134_A      -       -           -
LGA    G   135_A      -       -           -
LGA    H   136_A      -       -           -
LGA    E   137_A      -       -           -
LGA    D   138_A      D     152           #
LGA    A   139_A      N     153          1.150
LGA    I   140_A      R     154          1.452
LGA    I   141_A      F     155          1.189
LGA    M   142_A      Y     156          0.278
LGA    A   143_A      Y     157          0.285
LGA    L   144_A      R     158          0.405
LGA    P   145_A      N     159          0.615
LGA    I   146_A      L     160          0.991
LGA    S   147_A      K     161          3.417
LGA    M   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    L   150_A      -       -           -
LGA    H   151_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  151  160    5.0    134    1.90    11.19     73.629     6.691

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.430695 * X  +  -0.445214 * Y  +  -0.785039 * Z  +  12.438760
  Y_new =   0.815195 * X  +   0.565153 * Y  +   0.126728 * Z  +  43.099304
  Z_new =   0.387246 * X  +  -0.694541 * Y  +   0.606344 * Z  +  -9.763543 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.853092    2.288501  [ DEG:   -48.8786    131.1214 ]
  Theta =  -0.397643   -2.743950  [ DEG:   -22.7833   -157.2167 ]
  Phi   =   1.084740   -2.056853  [ DEG:    62.1510   -117.8490 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cnm_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cnm_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  151  160   5.0  134   1.90   11.19  73.629
REMARK  ---------------------------------------------------------- 
MOLECULE 2cnm_A
HEADER    TRANSFERASE                             22-MAY-06   2CNM              
TITLE     RIMI- RIBOSOMAL S18 N-ALPHA-PROTEIN ACETYLTRANSFERASE IN              
TITLE    2 COMPLEX WITH A BISUBSTRATE INHIBITOR (CTERM-ARG-ARG-PHE-             
TITLE    3 TYR-ARG-ALA-N-ALPHA-ACETYL-S-COA).                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MODIFICATION OF 30S RIBOSOMAL SUBUNIT PROTEIN              
COMPND   3 S18;                                                                 
COMPND   4 CHAIN: A, B, C;                                                      
COMPND   5 SYNONYM: RIBOSOMAL-N-ALPHA-ACETYLTRANSFERASE;                        
COMPND   6 EC: 2.3.1.128;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: CTERM-ARG-ARG-PHE-TYR-ARG-ALA-N-ALPHA-ACETYL;              
COMPND  10 CHAIN: D, E, F;                                                      
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SALMONELLA TYPHIMURIUM LT2;                     
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 MOL_ID: 2;                                                           
SOURCE   5 SYNTHETIC: YES                                                       
KEYWDS    N-ALPHA ACETYLATION, GCN5-N-ACETYLTRANSFERASE, RIBOSOMAL              
KEYWDS   2 PROTEIN, ACETYLTRANSFERASE, GNAT, TRANSFERASE,                       
KEYWDS   3 ACYLTRANSFERASE                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.W.VETTING,M.YU,D.C.BAREICH,J.S.BLANCHARD                            
REVDAT   1   22-MAY-07 2CNM    0                                                
JRNL        AUTH   M.W.VETTING,M.YU,D.C.BAREICH,J.S.BLANCHARD                   
JRNL        TITL   STRUCTURE OF RIMI FROM SALAMONELLA TYPHIMURIUM               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2CNM A    1   148  UNP    Q8ZJW4   Q8ZJW4_SALTY     1    148             
DBREF  2CNM A  149   160  PDB    2CNM     2CNM           149    160             
DBREF  2CNM B    1   148  UNP    Q8ZJW4   Q8ZJW4_SALTY     1    148             
DBREF  2CNM B  149   160  PDB    2CNM     2CNM           149    160             
DBREF  2CNM C    1   148  UNP    Q8ZJW4   Q8ZJW4_SALTY     1    148             
DBREF  2CNM C  149   160  PDB    2CNM     2CNM           149    160             
DBREF  2CNM D    1     7  PDB    2CNM     2CNM             1      7             
DBREF  2CNM E    1     7  PDB    2CNM     2CNM             1      7             
DBREF  2CNM F    1     7  PDB    2CNM     2CNM             1      7             
SEQRES   1 A  160  MET ASN THR ILE SER ILE LEU SER THR THR ASP LEU PRO          
SEQRES   2 A  160  ALA ALA TRP GLN ILE GLU GLN ARG ALA HIS ALA PHE PRO          
SEQRES   3 A  160  TRP SER GLU LYS THR PHE PHE GLY ASN GLN GLY GLU ARG          
SEQRES   4 A  160  TYR LEU ASN LEU LYS LEU THR ALA ASP ASP ARG MET ALA          
SEQRES   5 A  160  ALA PHE ALA ILE THR GLN VAL VAL LEU ASP GLU ALA THR          
SEQRES   6 A  160  LEU PHE ASN ILE ALA VAL ASP PRO ASP PHE GLN ARG ARG          
SEQRES   7 A  160  GLY LEU GLY ARG MET LEU LEU GLU HIS LEU ILE ASP GLU          
SEQRES   8 A  160  LEU GLU THR ARG GLY VAL VAL THR LEU TRP LEU GLU VAL          
SEQRES   9 A  160  ARG ALA SER ASN ALA ALA ALA ILE ALA LEU TYR GLU SER          
SEQRES  10 A  160  LEU GLY PHE ASN GLU ALA THR ILE ARG ARG ASN TYR TYR          
SEQRES  11 A  160  PRO THR ALA GLN GLY HIS GLU ASP ALA ILE ILE MET ALA          
SEQRES  12 A  160  LEU PRO ILE SER MET LYS LEU HIS HIS HIS HIS HIS HIS          
SEQRES  13 A  160  HIS HIS HIS HIS                                              
SEQRES   1 B  160  MET ASN THR ILE SER ILE LEU SER THR THR ASP LEU PRO          
SEQRES   2 B  160  ALA ALA TRP GLN ILE GLU GLN ARG ALA HIS ALA PHE PRO          
SEQRES   3 B  160  TRP SER GLU LYS THR PHE PHE GLY ASN GLN GLY GLU ARG          
SEQRES   4 B  160  TYR LEU ASN LEU LYS LEU THR ALA ASP ASP ARG MET ALA          
SEQRES   5 B  160  ALA PHE ALA ILE THR GLN VAL VAL LEU ASP GLU ALA THR          
SEQRES   6 B  160  LEU PHE ASN ILE ALA VAL ASP PRO ASP PHE GLN ARG ARG          
SEQRES   7 B  160  GLY LEU GLY ARG MET LEU LEU GLU HIS LEU ILE ASP GLU          
SEQRES   8 B  160  LEU GLU THR ARG GLY VAL VAL THR LEU TRP LEU GLU VAL          
SEQRES   9 B  160  ARG ALA SER ASN ALA ALA ALA ILE ALA LEU TYR GLU SER          
SEQRES  10 B  160  LEU GLY PHE ASN GLU ALA THR ILE ARG ARG ASN TYR TYR          
SEQRES  11 B  160  PRO THR ALA GLN GLY HIS GLU ASP ALA ILE ILE MET ALA          
SEQRES  12 B  160  LEU PRO ILE SER MET LYS LEU HIS HIS HIS HIS HIS HIS          
SEQRES  13 B  160  HIS HIS HIS HIS                                              
SEQRES   1 C  160  MET ASN THR ILE SER ILE LEU SER THR THR ASP LEU PRO          
SEQRES   2 C  160  ALA ALA TRP GLN ILE GLU GLN ARG ALA HIS ALA PHE PRO          
SEQRES   3 C  160  TRP SER GLU LYS THR PHE PHE GLY ASN GLN GLY GLU ARG          
SEQRES   4 C  160  TYR LEU ASN LEU LYS LEU THR ALA ASP ASP ARG MET ALA          
SEQRES   5 C  160  ALA PHE ALA ILE THR GLN VAL VAL LEU ASP GLU ALA THR          
SEQRES   6 C  160  LEU PHE ASN ILE ALA VAL ASP PRO ASP PHE GLN ARG ARG          
SEQRES   7 C  160  GLY LEU GLY ARG MET LEU LEU GLU HIS LEU ILE ASP GLU          
SEQRES   8 C  160  LEU GLU THR ARG GLY VAL VAL THR LEU TRP LEU GLU VAL          
SEQRES   9 C  160  ARG ALA SER ASN ALA ALA ALA ILE ALA LEU TYR GLU SER          
SEQRES  10 C  160  LEU GLY PHE ASN GLU ALA THR ILE ARG ARG ASN TYR TYR          
SEQRES  11 C  160  PRO THR ALA GLN GLY HIS GLU ASP ALA ILE ILE MET ALA          
SEQRES  12 C  160  LEU PRO ILE SER MET LYS LEU HIS HIS HIS HIS HIS HIS          
SEQRES  13 C  160  HIS HIS HIS HIS                                              
SEQRES   1 D    7  ACE ALA ARG TYR PHE ARG ARG                                  
SEQRES   1 E    7  ACE ALA ARG TYR PHE ARG ARG                                  
SEQRES   1 F    7  ACE ALA ARG TYR PHE ARG ARG                                  
HET    ACE  D   1       3                                                       
HET    ACE  E   1       3                                                       
HET    ACE  F   1       3                                                       
HET    COA  D   0      48                                                       
HET    COA  E   0      48                                                       
HET    COA  F   0      48                                                       
HETNAM     ACE ACETYL GROUP                                                     
HETNAM     COA COENZYME A                                                       
FORMUL   4  ACE    3(C2 H4 O)                                                   
FORMUL   7  COA    3(C21 H36 N7 O16 P3 S)                                       
FORMUL  10  HOH   *60(H2 O)                                                     
CRYST1  133.127  133.127  190.986  90.00  90.00 120.00 H 3 2        54          
ATOM      1  N   MET A   1     -31.834  42.870  38.356  1.00 33.22           N  
ATOM      2  CA  MET A   1     -30.565  43.602  38.077  1.00 34.44           C  
ATOM      3  C   MET A   1     -29.392  42.978  38.808  1.00 32.22           C  
ATOM      4  O   MET A   1     -29.540  42.378  39.875  1.00 31.88           O  
ATOM      5  CB  MET A   1     -30.684  45.060  38.481  1.00 34.59           C  
ATOM      6  CG  MET A   1     -31.543  45.208  39.705  1.00 36.69           C  
ATOM      7  SD  MET A   1     -30.741  46.176  40.995  1.00 39.20           S  
ATOM      8  CE  MET A   1     -32.005  46.014  42.306  1.00 38.48           C  
ATOM      9  N   ASN A   2     -28.218  43.128  38.224  1.00 30.63           N  
ATOM     10  CA  ASN A   2     -27.050  42.471  38.775  1.00 29.45           C  
ATOM     11  C   ASN A   2     -26.023  43.499  39.206  1.00 28.57           C  
ATOM     12  O   ASN A   2     -25.771  44.453  38.503  1.00 28.88           O  
ATOM     13  CB  ASN A   2     -26.492  41.479  37.759  1.00 29.24           C  
ATOM     14  CG  ASN A   2     -27.568  40.534  37.215  1.00 28.40           C  
ATOM     15  OD1 ASN A   2     -27.856  40.525  36.022  1.00 28.07           O  
ATOM     16  ND2 ASN A   2     -28.166  39.753  38.092  1.00 26.99           N  
ATOM     17  N   THR A   3     -25.448  43.332  40.380  1.00 27.56           N  
ATOM     18  CA  THR A   3     -24.602  44.385  40.910  1.00 27.06           C  
ATOM     19  C   THR A   3     -23.337  43.758  41.469  1.00 26.79           C  
ATOM     20  O   THR A   3     -23.386  42.916  42.397  1.00 26.77           O  
ATOM     21  CB  THR A   3     -25.350  45.234  41.975  1.00 26.93           C  
ATOM     22  OG1 THR A   3     -26.462  45.883  41.359  1.00 26.31           O  
ATOM     23  CG2 THR A   3     -24.459  46.293  42.525  1.00 27.42           C  
ATOM     24  N   ILE A   4     -22.216  44.142  40.865  1.00 25.48           N  
ATOM     25  CA  ILE A   4     -20.939  43.628  41.272  1.00 24.59           C  
ATOM     26  C   ILE A   4     -20.375  44.616  42.274  1.00 24.67           C  
ATOM     27  O   ILE A   4     -20.335  45.819  42.009  1.00 25.70           O  
ATOM     28  CB  ILE A   4     -20.002  43.416  40.065  1.00 24.59           C  
ATOM     29  CG1 ILE A   4     -20.387  42.132  39.326  1.00 23.40           C  
ATOM     30  CG2 ILE A   4     -18.578  43.254  40.532  1.00 22.40           C  
ATOM     31  CD1 ILE A   4     -20.764  42.355  37.957  1.00 24.26           C  
ATOM     32  N   SER A   5     -19.985  44.131  43.441  1.00 23.38           N  
ATOM     33  CA  SER A   5     -19.376  45.014  44.398  1.00 23.42           C  
ATOM     34  C   SER A   5     -18.248  44.301  45.102  1.00 23.63           C  
ATOM     35  O   SER A   5     -18.037  43.100  44.894  1.00 24.58           O  
ATOM     36  CB  SER A   5     -20.409  45.538  45.396  1.00 23.11           C  
ATOM     37  OG  SER A   5     -21.131  44.476  45.998  1.00 24.80           O  
ATOM     38  N   ILE A   6     -17.504  45.051  45.907  1.00 23.20           N  
ATOM     39  CA  ILE A   6     -16.535  44.479  46.816  1.00 22.63           C  
ATOM     40  C   ILE A   6     -17.200  43.532  47.820  1.00 22.66           C  
ATOM     41  O   ILE A   6     -18.329  43.787  48.273  1.00 22.60           O  
ATOM     42  CB  ILE A   6     -15.733  45.604  47.533  1.00 22.66           C  
ATOM     43  CG1 ILE A   6     -14.771  46.283  46.541  1.00 22.10           C  
ATOM     44  CG2 ILE A   6     -14.913  45.046  48.694  1.00 21.00           C  
ATOM     45  CD1 ILE A   6     -13.644  45.376  46.068  1.00 21.43           C  
ATOM     46  N   LEU A   7     -16.487  42.443  48.128  1.00 22.86           N  
ATOM     47  CA  LEU A   7     -16.854  41.448  49.149  1.00 23.20           C  
ATOM     48  C   LEU A   7     -16.224  41.825  50.476  1.00 23.55           C  
ATOM     49  O   LEU A   7     -15.001  41.795  50.651  1.00 24.04           O  
ATOM     50  CB  LEU A   7     -16.357  40.052  48.740  1.00 23.27           C  
ATOM     51  CG  LEU A   7     -16.872  38.869  49.577  1.00 24.07           C  
ATOM     52  CD1 LEU A   7     -18.268  38.388  49.112  1.00 22.31           C  
ATOM     53  CD2 LEU A   7     -15.888  37.706  49.557  1.00 24.35           C  
ATOM     54  N   SER A   8     -17.063  42.210  51.417  1.00 24.58           N  
ATOM     55  CA  SER A   8     -16.612  42.722  52.715  1.00 24.69           C  
ATOM     56  C   SER A   8     -17.098  41.818  53.829  1.00 24.25           C  
ATOM     57  O   SER A   8     -18.057  41.077  53.647  1.00 23.85           O  
ATOM     58  CB  SER A   8     -17.222  44.089  52.923  1.00 25.01           C  
ATOM     59  OG  SER A   8     -18.646  43.953  52.972  1.00 27.37           O  
ATOM     60  N   THR A   9     -16.446  41.920  54.982  1.00 24.10           N  
ATOM     61  CA  THR A   9     -16.774  41.188  56.218  1.00 23.79           C  
ATOM     62  C   THR A   9     -18.231  40.711  56.365  1.00 24.11           C  
ATOM     63  O   THR A   9     -18.502  39.514  56.566  1.00 23.85           O  
ATOM     64  CB  THR A   9     -16.410  42.076  57.423  1.00 24.13           C  
ATOM     65  OG1 THR A   9     -15.059  42.531  57.264  1.00 23.77           O  
ATOM     66  CG2 THR A   9     -16.577  41.329  58.763  1.00 22.58           C  
ATOM     67  N   THR A  10     -19.157  41.657  56.251  1.00 24.15           N  
ATOM     68  CA  THR A  10     -20.577  41.369  56.394  1.00 24.82           C  
ATOM     69  C   THR A  10     -21.093  40.353  55.383  1.00 24.69           C  
ATOM     70  O   THR A  10     -22.091  39.678  55.643  1.00 24.66           O  
ATOM     71  CB  THR A  10     -21.414  42.672  56.288  1.00 25.38           C  
ATOM     72  OG1 THR A  10     -21.252  43.450  57.485  1.00 26.05           O  
ATOM     73  CG2 THR A  10     -22.874  42.368  56.102  1.00 24.52           C  
ATOM     74  N   ASP A  11     -20.396  40.254  54.250  1.00 24.56           N  
ATOM     75  CA  ASP A  11     -20.797  39.433  53.107  1.00 24.80           C  
ATOM     76  C   ASP A  11     -20.342  38.002  53.248  1.00 24.56           C  
ATOM     77  O   ASP A  11     -20.752  37.149  52.447  1.00 24.86           O  
ATOM     78  CB  ASP A  11     -20.125  39.914  51.796  1.00 25.04           C  
ATOM     79  CG  ASP A  11     -20.627  41.251  51.311  1.00 26.22           C  
ATOM     80  OD1 ASP A  11     -21.853  41.534  51.490  1.00 28.73           O  
ATOM     81  OD2 ASP A  11     -19.791  42.003  50.733  1.00 23.70           O  
ATOM     82  N   LEU A  12     -19.453  37.726  54.199  1.00 23.95           N  
ATOM     83  CA  LEU A  12     -18.765  36.428  54.162  1.00 23.73           C  
ATOM     84  C   LEU A  12     -19.626  35.192  54.508  1.00 24.27           C  
ATOM     85  O   LEU A  12     -19.479  34.165  53.837  1.00 24.37           O  
ATOM     86  CB  LEU A  12     -17.423  36.458  54.888  1.00 22.99           C  
ATOM     87  CG  LEU A  12     -16.495  37.599  54.452  1.00 21.83           C  
ATOM     88  CD1 LEU A  12     -15.328  37.775  55.407  1.00 22.63           C  
ATOM     89  CD2 LEU A  12     -16.011  37.446  53.036  1.00 18.18           C  
ATOM     90  N   PRO A  13     -20.520  35.280  55.534  1.00 24.32           N  
ATOM     91  CA  PRO A  13     -21.450  34.152  55.747  1.00 24.59           C  
ATOM     92  C   PRO A  13     -22.273  33.750  54.504  1.00 25.48           C  
ATOM     93  O   PRO A  13     -22.332  32.551  54.171  1.00 26.02           O  
ATOM     94  CB  PRO A  13     -22.343  34.636  56.888  1.00 24.17           C  
ATOM     95  CG  PRO A  13     -21.482  35.616  57.635  1.00 23.98           C  
ATOM     96  CD  PRO A  13     -20.687  36.326  56.559  1.00 23.86           C  
ATOM     97  N   ALA A  14     -22.886  34.709  53.808  1.00 25.41           N  
ATOM     98  CA  ALA A  14     -23.587  34.363  52.569  1.00 25.71           C  
ATOM     99  C   ALA A  14     -22.659  33.639  51.547  1.00 26.20           C  
ATOM    100  O   ALA A  14     -23.045  32.629  50.937  1.00 26.59           O  
ATOM    101  CB  ALA A  14     -24.203  35.579  51.972  1.00 25.59           C  
ATOM    102  N   ALA A  15     -21.438  34.147  51.380  1.00 25.66           N  
ATOM    103  CA  ALA A  15     -20.474  33.587  50.439  1.00 25.46           C  
ATOM    104  C   ALA A  15     -19.991  32.211  50.882  1.00 25.80           C  
ATOM    105  O   ALA A  15     -19.754  31.313  50.046  1.00 25.94           O  
ATOM    106  CB  ALA A  15     -19.283  34.521  50.287  1.00 25.27           C  
ATOM    107  N   TRP A  16     -19.829  32.046  52.194  1.00 25.49           N  
ATOM    108  CA  TRP A  16     -19.427  30.757  52.744  1.00 25.14           C  
ATOM    109  C   TRP A  16     -20.466  29.707  52.404  1.00 25.18           C  
ATOM    110  O   TRP A  16     -20.103  28.587  52.044  1.00 25.38           O  
ATOM    111  CB  TRP A  16     -19.098  30.830  54.249  1.00 24.32           C  
ATOM    112  CG  TRP A  16     -18.875  29.484  54.929  1.00 23.92           C  
ATOM    113  CD1 TRP A  16     -19.630  28.942  55.949  1.00 23.09           C  
ATOM    114  CD2 TRP A  16     -17.849  28.529  54.646  1.00 22.66           C  
ATOM    115  NE1 TRP A  16     -19.139  27.715  56.305  1.00 23.17           N  
ATOM    116  CE2 TRP A  16     -18.050  27.426  55.522  1.00 22.96           C  
ATOM    117  CE3 TRP A  16     -16.797  28.479  53.728  1.00 23.49           C  
ATOM    118  CZ2 TRP A  16     -17.226  26.288  55.513  1.00 21.43           C  
ATOM    119  CZ3 TRP A  16     -15.968  27.333  53.716  1.00 23.89           C  
ATOM    120  CH2 TRP A  16     -16.199  26.257  54.608  1.00 23.34           C  
ATOM    121  N   GLN A  17     -21.743  30.085  52.456  1.00 25.84           N  
ATOM    122  CA  GLN A  17     -22.847  29.195  52.024  1.00 26.43           C  
ATOM    123  C   GLN A  17     -22.697  28.805  50.569  1.00 26.23           C  
ATOM    124  O   GLN A  17     -22.899  27.634  50.224  1.00 26.80           O  
ATOM    125  CB  GLN A  17     -24.221  29.849  52.214  1.00 26.56           C  
ATOM    126  CG  GLN A  17     -24.746  29.726  53.588  1.00 29.30           C  
ATOM    127  CD  GLN A  17     -24.908  28.266  53.966  1.00 34.23           C  
ATOM    128  OE1 GLN A  17     -25.933  27.631  53.641  1.00 36.27           O  
ATOM    129  NE2 GLN A  17     -23.888  27.710  54.641  1.00 32.57           N  
ATOM    130  N   ILE A  18     -22.352  29.792  49.730  1.00 25.40           N  
ATOM    131  CA  ILE A  18     -22.137  29.569  48.308  1.00 24.78           C  
ATOM    132  C   ILE A  18     -20.913  28.671  48.092  1.00 24.37           C  
ATOM    133  O   ILE A  18     -20.963  27.723  47.294  1.00 24.27           O  
ATOM    134  CB  ILE A  18     -22.028  30.906  47.506  1.00 25.32           C  
ATOM    135  CG1 ILE A  18     -23.377  31.664  47.549  1.00 25.10           C  
ATOM    136  CG2 ILE A  18     -21.568  30.648  46.040  1.00 24.83           C  
ATOM    137  CD1 ILE A  18     -23.459  32.875  46.637  1.00 24.79           C  
ATOM    138  N   GLU A  19     -19.839  28.936  48.828  1.00 23.43           N  
ATOM    139  CA  GLU A  19     -18.659  28.083  48.756  1.00 23.33           C  
ATOM    140  C   GLU A  19     -18.977  26.590  48.995  1.00 23.93           C  
ATOM    141  O   GLU A  19     -18.494  25.709  48.276  1.00 24.08           O  
ATOM    142  CB  GLU A  19     -17.625  28.571  49.752  1.00 22.78           C  
ATOM    143  CG  GLU A  19     -16.524  27.630  49.956  1.00 21.09           C  
ATOM    144  CD  GLU A  19     -15.561  27.546  48.787  1.00 22.33           C  
ATOM    145  OE1 GLU A  19     -15.685  28.272  47.778  1.00 23.02           O  
ATOM    146  OE2 GLU A  19     -14.634  26.732  48.890  1.00 23.29           O  
ATOM    147  N   GLN A  20     -19.819  26.318  49.987  1.00 23.96           N  
ATOM    148  CA  GLN A  20     -20.141  24.950  50.351  1.00 24.00           C  
ATOM    149  C   GLN A  20     -21.181  24.326  49.446  1.00 24.12           C  
ATOM    150  O   GLN A  20     -21.299  23.116  49.415  1.00 23.72           O  
ATOM    151  CB  GLN A  20     -20.645  24.883  51.775  1.00 23.82           C  
ATOM    152  CG  GLN A  20     -19.590  24.828  52.838  1.00 23.96           C  
ATOM    153  CD  GLN A  20     -20.211  25.112  54.197  1.00 25.73           C  
ATOM    154  OE1 GLN A  20     -20.754  26.200  54.412  1.00 25.29           O  
ATOM    155  NE2 GLN A  20     -20.157  24.129  55.117  1.00 23.78           N  
ATOM    156  N   ARG A  21     -21.934  25.147  48.716  1.00 24.53           N  
ATOM    157  CA  ARG A  21     -22.940  24.629  47.783  1.00 24.47           C  
ATOM    158  C   ARG A  21     -22.426  24.397  46.352  1.00 24.90           C  
ATOM    159  O   ARG A  21     -22.959  23.555  45.646  1.00 24.73           O  
ATOM    160  CB  ARG A  21     -24.151  25.556  47.744  1.00 24.33           C  
ATOM    161  CG  ARG A  21     -25.098  25.377  48.922  1.00 23.75           C  
ATOM    162  CD  ARG A  21     -25.932  26.620  49.197  1.00 22.85           C  
ATOM    163  NE  ARG A  21     -26.709  27.062  48.043  1.00 22.50           N  
ATOM    164  CZ  ARG A  21     -27.836  26.486  47.625  1.00 24.97           C  
ATOM    165  NH1 ARG A  21     -28.334  25.429  48.273  1.00 26.49           N  
ATOM    166  NH2 ARG A  21     -28.477  26.971  46.560  1.00 24.26           N  
ATOM    167  N   ALA A  22     -21.415  25.146  45.919  1.00 25.42           N  
ATOM    168  CA  ALA A  22     -21.013  25.144  44.516  1.00 26.11           C  
ATOM    169  C   ALA A  22     -19.775  24.282  44.236  1.00 27.27           C  
ATOM    170  O   ALA A  22     -19.570  23.818  43.101  1.00 27.61           O  
ATOM    171  CB  ALA A  22     -20.770  26.532  44.072  1.00 26.06           C  
ATOM    172  N   HIS A  23     -18.962  24.071  45.273  1.00 27.63           N  
ATOM    173  CA  HIS A  23     -17.776  23.213  45.198  1.00 27.62           C  
ATOM    174  C   HIS A  23     -18.016  21.839  45.818  1.00 27.54           C  
ATOM    175  O   HIS A  23     -18.428  21.730  46.972  1.00 27.33           O  
ATOM    176  CB  HIS A  23     -16.574  23.872  45.911  1.00 27.39           C  
ATOM    177  CG  HIS A  23     -15.997  25.047  45.183  1.00 26.25           C  
ATOM    178  ND1 HIS A  23     -15.530  24.966  43.888  1.00 25.26           N  
ATOM    179  CD2 HIS A  23     -15.786  26.327  45.580  1.00 26.45           C  
ATOM    180  CE1 HIS A  23     -15.075  26.151  43.511  1.00 26.57           C  
ATOM    181  NE2 HIS A  23     -15.224  26.996  44.517  1.00 26.85           N  
ATOM    182  N   ALA A  24     -17.716  20.787  45.069  1.00 27.86           N  
ATOM    183  CA  ALA A  24     -17.788  19.443  45.637  1.00 27.73           C  
ATOM    184  C   ALA A  24     -16.751  19.300  46.778  1.00 27.82           C  
ATOM    185  O   ALA A  24     -17.040  18.697  47.820  1.00 28.01           O  
ATOM    186  CB  ALA A  24     -17.584  18.405  44.561  1.00 27.52           C  
ATOM    187  N   PHE A  25     -15.569  19.900  46.600  1.00 27.50           N  
ATOM    188  CA  PHE A  25     -14.535  19.914  47.654  1.00 26.80           C  
ATOM    189  C   PHE A  25     -14.181  21.345  48.056  1.00 26.07           C  
ATOM    190  O   PHE A  25     -13.171  21.881  47.604  1.00 25.31           O  
ATOM    191  CB  PHE A  25     -13.299  19.124  47.205  1.00 26.91           C  
ATOM    192  CG  PHE A  25     -13.618  17.716  46.797  1.00 27.10           C  
ATOM    193  CD1 PHE A  25     -13.669  16.689  47.762  1.00 25.36           C  
ATOM    194  CD2 PHE A  25     -13.930  17.421  45.462  1.00 26.13           C  
ATOM    195  CE1 PHE A  25     -13.998  15.382  47.412  1.00 24.70           C  
ATOM    196  CE2 PHE A  25     -14.256  16.116  45.085  1.00 27.18           C  
ATOM    197  CZ  PHE A  25     -14.297  15.085  46.074  1.00 27.02           C  
ATOM    198  N   PRO A  26     -15.031  21.971  48.910  1.00 25.69           N  
ATOM    199  CA  PRO A  26     -14.876  23.402  49.244  1.00 24.79           C  
ATOM    200  C   PRO A  26     -13.609  23.604  50.052  1.00 24.53           C  
ATOM    201  O   PRO A  26     -13.039  22.631  50.488  1.00 24.22           O  
ATOM    202  CB  PRO A  26     -16.102  23.676  50.114  1.00 25.21           C  
ATOM    203  CG  PRO A  26     -16.473  22.290  50.710  1.00 23.94           C  
ATOM    204  CD  PRO A  26     -16.185  21.347  49.614  1.00 24.79           C  
ATOM    205  N   TRP A  27     -13.171  24.847  50.255  1.00 24.71           N  
ATOM    206  CA  TRP A  27     -12.080  25.153  51.199  1.00 24.51           C  
ATOM    207  C   TRP A  27     -12.546  24.819  52.613  1.00 24.58           C  
ATOM    208  O   TRP A  27     -13.720  24.524  52.829  1.00 25.55           O  
ATOM    209  CB  TRP A  27     -11.679  26.643  51.146  1.00 24.09           C  
ATOM    210  CG  TRP A  27     -10.986  27.087  49.891  1.00 23.86           C  
ATOM    211  CD1 TRP A  27     -10.382  26.288  48.975  1.00 23.25           C  
ATOM    212  CD2 TRP A  27     -10.798  28.440  49.422  1.00 24.42           C  
ATOM    213  NE1 TRP A  27      -9.854  27.039  47.963  1.00 22.66           N  
ATOM    214  CE2 TRP A  27     -10.083  28.364  48.213  1.00 22.84           C  
ATOM    215  CE3 TRP A  27     -11.170  29.708  49.904  1.00 25.10           C  
ATOM    216  CZ2 TRP A  27      -9.726  29.499  47.474  1.00 23.17           C  
ATOM    217  CZ3 TRP A  27     -10.825  30.843  49.157  1.00 22.70           C  
ATOM    218  CH2 TRP A  27     -10.119  30.724  47.961  1.00 23.72           C  
ATOM    219  N   SER A  28     -11.629  24.849  53.575  1.00 24.70           N  
ATOM    220  CA  SER A  28     -12.005  24.832  54.986  1.00 24.12           C  
ATOM    221  C   SER A  28     -12.459  26.241  55.384  1.00 24.29           C  
ATOM    222  O   SER A  28     -11.970  27.250  54.857  1.00 24.55           O  
ATOM    223  CB  SER A  28     -10.818  24.405  55.853  1.00 23.66           C  
ATOM    224  OG  SER A  28      -9.744  25.323  55.754  1.00 22.67           O  
ATOM    225  N   GLU A  29     -13.370  26.296  56.336  1.00 24.00           N  
ATOM    226  CA  GLU A  29     -13.831  27.546  56.903  1.00 24.25           C  
ATOM    227  C   GLU A  29     -12.680  28.505  57.209  1.00 24.58           C  
ATOM    228  O   GLU A  29     -12.733  29.658  56.813  1.00 24.77           O  
ATOM    229  CB  GLU A  29     -14.670  27.255  58.160  1.00 24.05           C  
ATOM    230  CG  GLU A  29     -15.792  28.246  58.429  1.00 23.63           C  
ATOM    231  CD  GLU A  29     -16.653  27.891  59.668  1.00 24.22           C  
ATOM    232  OE1 GLU A  29     -17.094  26.714  59.822  1.00 22.87           O  
ATOM    233  OE2 GLU A  29     -16.897  28.813  60.486  1.00 23.20           O  
ATOM    234  N   LYS A  30     -11.640  28.030  57.896  1.00 25.41           N  
ATOM    235  CA  LYS A  30     -10.520  28.890  58.315  1.00 26.08           C  
ATOM    236  C   LYS A  30      -9.819  29.454  57.098  1.00 25.76           C  
ATOM    237  O   LYS A  30      -9.611  30.669  56.997  1.00 26.00           O  
ATOM    238  CB  LYS A  30      -9.536  28.133  59.193  1.00 26.04           C  
ATOM    239  CG  LYS A  30     -10.247  27.231  60.176  1.00 29.95           C  
ATOM    240  CD  LYS A  30      -9.266  26.332  60.964  1.00 35.09           C  
ATOM    241  CE  LYS A  30      -8.931  26.939  62.331  1.00 35.88           C  
ATOM    242  NZ  LYS A  30      -8.839  25.885  63.348  1.00 35.43           N  
ATOM    243  N   THR A  31      -9.490  28.571  56.160  1.00 25.27           N  
ATOM    244  CA  THR A  31      -8.890  28.985  54.903  1.00 24.29           C  
ATOM    245  C   THR A  31      -9.808  29.966  54.208  1.00 24.11           C  
ATOM    246  O   THR A  31      -9.363  30.993  53.665  1.00 24.53           O  
ATOM    247  CB  THR A  31      -8.603  27.778  54.013  1.00 23.98           C  
ATOM    248  OG1 THR A  31      -7.459  27.103  54.537  1.00 25.26           O  
ATOM    249  CG2 THR A  31      -8.316  28.198  52.604  1.00 21.96           C  
ATOM    250  N   PHE A  32     -11.098  29.682  54.230  1.00 23.48           N  
ATOM    251  CA  PHE A  32     -11.999  30.573  53.531  1.00 23.70           C  
ATOM    252  C   PHE A  32     -12.051  31.955  54.175  1.00 23.35           C  
ATOM    253  O   PHE A  32     -11.906  32.952  53.494  1.00 23.34           O  
ATOM    254  CB  PHE A  32     -13.410  29.994  53.371  1.00 23.88           C  
ATOM    255  CG  PHE A  32     -14.334  30.920  52.634  1.00 24.39           C  
ATOM    256  CD1 PHE A  32     -15.052  31.903  53.322  1.00 24.47           C  
ATOM    257  CD2 PHE A  32     -14.447  30.844  51.249  1.00 22.48           C  
ATOM    258  CE1 PHE A  32     -15.868  32.786  52.635  1.00 24.70           C  
ATOM    259  CE2 PHE A  32     -15.274  31.711  50.564  1.00 23.79           C  
ATOM    260  CZ  PHE A  32     -15.974  32.694  51.256  1.00 24.09           C  
ATOM    261  N   PHE A  33     -12.237  32.003  55.487  1.00 23.54           N  
ATOM    262  CA  PHE A  33     -12.302  33.272  56.197  1.00 24.07           C  
ATOM    263  C   PHE A  33     -10.967  33.996  56.282  1.00 24.87           C  
ATOM    264  O   PHE A  33     -10.942  35.176  56.629  1.00 25.35           O  
ATOM    265  CB  PHE A  33     -12.900  33.085  57.590  1.00 23.26           C  
ATOM    266  CG  PHE A  33     -14.382  33.093  57.589  1.00 22.83           C  
ATOM    267  CD1 PHE A  33     -15.099  31.908  57.326  1.00 22.36           C  
ATOM    268  CD2 PHE A  33     -15.078  34.290  57.795  1.00 20.42           C  
ATOM    269  CE1 PHE A  33     -16.497  31.911  57.289  1.00 21.74           C  
ATOM    270  CE2 PHE A  33     -16.455  34.311  57.781  1.00 19.83           C  
ATOM    271  CZ  PHE A  33     -17.183  33.117  57.520  1.00 22.31           C  
ATOM    272  N   GLY A  34      -9.884  33.288  55.954  1.00 25.12           N  
ATOM    273  CA  GLY A  34      -8.542  33.833  55.968  1.00 25.80           C  
ATOM    274  C   GLY A  34      -8.147  34.487  54.662  1.00 26.79           C  
ATOM    275  O   GLY A  34      -7.203  35.288  54.626  1.00 26.53           O  
ATOM    276  N   ASN A  35      -8.857  34.175  53.577  1.00 27.21           N  
ATOM    277  CA  ASN A  35      -8.497  34.790  52.289  1.00 27.80           C  
ATOM    278  C   ASN A  35      -9.175  36.143  52.015  1.00 27.98           C  
ATOM    279  O   ASN A  35      -9.866  36.342  51.009  1.00 28.17           O  
ATOM    280  CB  ASN A  35      -8.657  33.804  51.122  1.00 27.78           C  
ATOM    281  CG  ASN A  35      -7.499  32.813  51.033  1.00 28.48           C  
ATOM    282  OD1 ASN A  35      -7.469  31.806  51.743  1.00 31.11           O  
ATOM    283  ND2 ASN A  35      -6.551  33.088  50.153  1.00 27.28           N  
ATOM    284  N   GLN A  36      -8.938  37.077  52.921  1.00 28.26           N  
ATOM    285  CA  GLN A  36      -9.490  38.420  52.846  1.00 28.71           C  
ATOM    286  C   GLN A  36      -8.368  39.310  53.345  1.00 28.88           C  
ATOM    287  O   GLN A  36      -7.388  38.806  53.909  1.00 28.58           O  
ATOM    288  CB  GLN A  36     -10.708  38.571  53.789  1.00 28.26           C  
ATOM    289  CG  GLN A  36     -11.753  37.421  53.780  1.00 30.06           C  
ATOM    290  CD  GLN A  36     -12.464  37.212  52.406  1.00 33.92           C  
ATOM    291  OE1 GLN A  36     -12.752  38.168  51.668  1.00 34.77           O  
ATOM    292  NE2 GLN A  36     -12.750  35.949  52.076  1.00 32.91           N  
ATOM    293  N   GLY A  37      -8.516  40.622  53.163  1.00 29.44           N  
ATOM    294  CA  GLY A  37      -7.578  41.604  53.688  1.00 29.18           C  
ATOM    295  C   GLY A  37      -6.563  42.045  52.645  1.00 29.73           C  
ATOM    296  O   GLY A  37      -6.865  42.076  51.462  1.00 29.39           O  
ATOM    297  N   GLU A  38      -5.345  42.337  53.099  1.00 30.33           N  
ATOM    298  CA  GLU A  38      -4.298  42.953  52.283  1.00 30.80           C  
ATOM    299  C   GLU A  38      -3.971  42.244  50.989  1.00 30.19           C  
ATOM    300  O   GLU A  38      -3.623  41.054  50.986  1.00 30.66           O  
ATOM    301  CB  GLU A  38      -3.024  43.171  53.086  1.00 31.00           C  
ATOM    302  CG  GLU A  38      -3.113  44.448  53.941  1.00 33.85           C  
ATOM    303  CD  GLU A  38      -1.901  44.625  54.841  1.00 36.87           C  
ATOM    304  OE1 GLU A  38      -0.874  43.886  54.663  1.00 36.36           O  
ATOM    305  OE2 GLU A  38      -1.992  45.510  55.717  1.00 36.47           O  
ATOM    306  N   ARG A  39      -4.079  43.003  49.907  1.00 28.50           N  
ATOM    307  CA  ARG A  39      -3.792  42.526  48.574  1.00 27.95           C  
ATOM    308  C   ARG A  39      -4.943  41.695  47.961  1.00 27.73           C  
ATOM    309  O   ARG A  39      -4.824  41.204  46.827  1.00 28.02           O  
ATOM    310  CB  ARG A  39      -2.393  41.841  48.475  1.00 27.67           C  
ATOM    311  CG  ARG A  39      -1.244  42.761  48.937  1.00 26.57           C  
ATOM    312  CD  ARG A  39       0.163  42.203  48.712  1.00 26.59           C  
ATOM    313  NE  ARG A  39       1.171  43.203  49.078  1.00 24.76           N  
ATOM    314  CZ  ARG A  39       1.692  43.343  50.307  1.00 22.92           C  
ATOM    315  NH1 ARG A  39       1.329  42.531  51.275  1.00 19.35           N  
ATOM    316  NH2 ARG A  39       2.581  44.293  50.569  1.00 17.61           N  
ATOM    317  N   TYR A  40      -6.053  41.553  48.680  1.00 26.51           N  
ATOM    318  CA  TYR A  40      -7.226  40.888  48.095  1.00 25.81           C  
ATOM    319  C   TYR A  40      -8.190  41.850  47.468  1.00 25.13           C  
ATOM    320  O   TYR A  40      -8.622  42.827  48.085  1.00 25.36           O  
ATOM    321  CB  TYR A  40      -7.990  40.060  49.111  1.00 25.87           C  
ATOM    322  CG  TYR A  40      -7.268  38.803  49.502  1.00 25.83           C  
ATOM    323  CD1 TYR A  40      -7.437  37.618  48.782  1.00 24.28           C  
ATOM    324  CD2 TYR A  40      -6.439  38.790  50.617  1.00 25.06           C  
ATOM    325  CE1 TYR A  40      -6.775  36.463  49.154  1.00 23.36           C  
ATOM    326  CE2 TYR A  40      -5.773  37.661  50.978  1.00 24.62           C  
ATOM    327  CZ  TYR A  40      -5.943  36.510  50.248  1.00 24.65           C  
ATOM    328  OH  TYR A  40      -5.263  35.414  50.650  1.00 25.84           O  
ATOM    329  N   LEU A  41      -8.541  41.556  46.234  1.00 24.14           N  
ATOM    330  CA  LEU A  41      -9.556  42.302  45.545  1.00 23.98           C  
ATOM    331  C   LEU A  41     -10.697  41.310  45.404  1.00 24.43           C  
ATOM    332  O   LEU A  41     -10.743  40.540  44.427  1.00 26.06           O  
ATOM    333  CB  LEU A  41      -9.042  42.751  44.183  1.00 23.50           C  
ATOM    334  CG  LEU A  41     -10.055  43.487  43.324  1.00 22.56           C  
ATOM    335  CD1 LEU A  41     -10.313  44.868  43.876  1.00 18.87           C  
ATOM    336  CD2 LEU A  41      -9.537  43.555  41.897  1.00 21.02           C  
ATOM    337  N   ASN A  42     -11.581  41.288  46.393  1.00 23.47           N  
ATOM    338  CA  ASN A  42     -12.624  40.312  46.424  1.00 23.47           C  
ATOM    339  C   ASN A  42     -13.952  40.932  46.059  1.00 23.53           C  
ATOM    340  O   ASN A  42     -14.324  42.007  46.568  1.00 23.80           O  
ATOM    341  CB  ASN A  42     -12.679  39.606  47.789  1.00 23.81           C  
ATOM    342  CG  ASN A  42     -11.496  38.669  48.006  1.00 24.50           C  
ATOM    343  OD1 ASN A  42     -10.801  38.306  47.055  1.00 25.77           O  
ATOM    344  ND2 ASN A  42     -11.268  38.264  49.261  1.00 23.13           N  
ATOM    345  N   LEU A  43     -14.668  40.227  45.186  1.00 22.93           N  
ATOM    346  CA  LEU A  43     -15.869  40.739  44.554  1.00 22.50           C  
ATOM    347  C   LEU A  43     -17.066  39.817  44.784  1.00 22.56           C  
ATOM    348  O   LEU A  43     -16.892  38.591  44.909  1.00 22.04           O  
ATOM    349  CB  LEU A  43     -15.638  40.912  43.042  1.00 22.47           C  
ATOM    350  CG  LEU A  43     -14.490  41.819  42.578  1.00 22.69           C  
ATOM    351  CD1 LEU A  43     -14.477  41.912  41.075  1.00 23.34           C  
ATOM    352  CD2 LEU A  43     -14.648  43.203  43.149  1.00 26.24           C  
ATOM    353  N   LYS A  44     -18.267  40.414  44.836  1.00 21.89           N  
ATOM    354  CA  LYS A  44     -19.516  39.668  44.821  1.00 21.92           C  
ATOM    355  C   LYS A  44     -20.455  40.156  43.713  1.00 22.59           C  
ATOM    356  O   LYS A  44     -20.371  41.316  43.252  1.00 22.13           O  
ATOM    357  CB  LYS A  44     -20.214  39.749  46.184  1.00 22.06           C  
ATOM    358  CG  LYS A  44     -20.895  41.105  46.537  1.00 21.95           C  
ATOM    359  CD  LYS A  44     -21.746  40.971  47.839  1.00 21.61           C  
ATOM    360  CE  LYS A  44     -22.304  42.299  48.334  1.00 20.94           C  
ATOM    361  NZ  LYS A  44     -21.164  43.219  48.649  1.00 23.42           N  
ATOM    362  N   LEU A  45     -21.342  39.264  43.269  1.00 23.26           N  
ATOM    363  CA  LEU A  45     -22.385  39.661  42.322  1.00 23.70           C  
ATOM    364  C   LEU A  45     -23.703  39.428  42.993  1.00 23.66           C  
ATOM    365  O   LEU A  45     -23.971  38.346  43.461  1.00 23.22           O  
ATOM    366  CB  LEU A  45     -22.304  38.919  40.981  1.00 23.47           C  
ATOM    367  CG  LEU A  45     -23.220  39.376  39.838  1.00 23.32           C  
ATOM    368  CD1 LEU A  45     -22.610  38.944  38.506  1.00 26.21           C  
ATOM    369  CD2 LEU A  45     -24.638  38.819  39.982  1.00 22.78           C  
ATOM    370  N   THR A  46     -24.502  40.478  43.028  1.00 24.83           N  
ATOM    371  CA  THR A  46     -25.771  40.463  43.709  1.00 26.99           C  
ATOM    372  C   THR A  46     -26.852  40.497  42.650  1.00 27.94           C  
ATOM    373  O   THR A  46     -26.874  41.387  41.797  1.00 28.50           O  
ATOM    374  CB  THR A  46     -25.890  41.674  44.688  1.00 27.08           C  
ATOM    375  OG1 THR A  46     -24.779  41.647  45.597  1.00 28.10           O  
ATOM    376  CG2 THR A  46     -27.193  41.633  45.492  1.00 25.82           C  
ATOM    377  N   ALA A  47     -27.726  39.509  42.688  1.00 28.86           N  
ATOM    378  CA  ALA A  47     -28.887  39.520  41.824  1.00 30.36           C  
ATOM    379  C   ALA A  47     -30.118  39.837  42.653  1.00 31.25           C  
ATOM    380  O   ALA A  47     -30.615  38.995  43.403  1.00 30.85           O  
ATOM    381  CB  ALA A  47     -29.027  38.188  41.120  1.00 30.25           C  
ATOM    382  N   ASP A  48     -30.590  41.071  42.527  1.00 32.97           N  
ATOM    383  CA  ASP A  48     -31.731  41.564  43.305  1.00 34.79           C  
ATOM    384  C   ASP A  48     -31.432  41.473  44.776  1.00 35.27           C  
ATOM    385  O   ASP A  48     -30.575  42.179  45.281  1.00 35.91           O  
ATOM    386  CB  ASP A  48     -32.994  40.756  43.015  1.00 35.16           C  
ATOM    387  CG  ASP A  48     -33.280  40.655  41.545  1.00 37.51           C  
ATOM    388  OD1 ASP A  48     -33.577  41.712  40.923  1.00 38.40           O  
ATOM    389  OD2 ASP A  48     -33.181  39.516  41.023  1.00 39.48           O  
ATOM    390  N   ASP A  49     -32.144  40.583  45.453  1.00 35.89           N  
ATOM    391  CA  ASP A  49     -31.920  40.332  46.863  1.00 36.54           C  
ATOM    392  C   ASP A  49     -30.645  39.600  47.115  1.00 36.26           C  
ATOM    393  O   ASP A  49     -29.846  40.021  47.933  1.00 37.37           O  
ATOM    394  CB  ASP A  49     -33.051  39.492  47.446  1.00 36.76           C  
ATOM    395  CG  ASP A  49     -34.274  40.289  47.641  1.00 38.00           C  
ATOM    396  OD1 ASP A  49     -34.239  41.466  47.213  1.00 39.08           O  
ATOM    397  OD2 ASP A  49     -35.260  39.761  48.205  1.00 41.54           O  
ATOM    398  N   ARG A  50     -30.456  38.495  46.418  1.00 35.41           N  
ATOM    399  CA  ARG A  50     -29.508  37.528  46.880  1.00 34.57           C  
ATOM    400  C   ARG A  50     -28.120  37.770  46.363  1.00 33.17           C  
ATOM    401  O   ARG A  50     -27.924  38.289  45.267  1.00 33.32           O  
ATOM    402  CB  ARG A  50     -29.997  36.123  46.553  1.00 34.91           C  
ATOM    403  CG  ARG A  50     -31.107  35.671  47.492  1.00 37.57           C  
ATOM    404  CD  ARG A  50     -31.497  34.209  47.259  1.00 41.34           C  
ATOM    405  NE  ARG A  50     -30.341  33.309  47.164  1.00 41.61           N  
ATOM    406  CZ  ARG A  50     -30.432  32.025  46.829  1.00 43.07           C  
ATOM    407  NH1 ARG A  50     -31.622  31.499  46.560  1.00 44.28           N  
ATOM    408  NH2 ARG A  50     -29.347  31.258  46.758  1.00 42.29           N  
ATOM    409  N   MET A  51     -27.145  37.409  47.178  1.00 31.58           N  
ATOM    410  CA  MET A  51     -25.818  37.250  46.653  1.00 30.27           C  
ATOM    411  C   MET A  51     -25.853  36.016  45.765  1.00 29.06           C  
ATOM    412  O   MET A  51     -26.326  34.987  46.172  1.00 28.04           O  
ATOM    413  CB  MET A  51     -24.792  37.082  47.759  1.00 29.79           C  
ATOM    414  CG  MET A  51     -23.405  36.847  47.164  1.00 31.26           C  
ATOM    415  SD  MET A  51     -22.259  36.100  48.317  1.00 30.57           S  
ATOM    416  CE  MET A  51     -22.030  37.538  49.393  1.00 30.55           C  
ATOM    417  N   ALA A  52     -25.365  36.140  44.541  1.00 28.60           N  
ATOM    418  CA  ALA A  52     -25.412  35.030  43.601  1.00 28.38           C  
ATOM    419  C   ALA A  52     -24.036  34.442  43.334  1.00 28.26           C  
ATOM    420  O   ALA A  52     -23.938  33.278  42.982  1.00 28.51           O  
ATOM    421  CB  ALA A  52     -26.063  35.459  42.307  1.00 28.31           C  
ATOM    422  N   ALA A  53     -22.980  35.234  43.511  1.00 27.94           N  
ATOM    423  CA  ALA A  53     -21.621  34.763  43.242  1.00 27.69           C  
ATOM    424  C   ALA A  53     -20.538  35.550  43.944  1.00 27.55           C  
ATOM    425  O   ALA A  53     -20.743  36.685  44.382  1.00 27.66           O  
ATOM    426  CB  ALA A  53     -21.336  34.763  41.731  1.00 27.98           C  
ATOM    427  N   PHE A  54     -19.352  34.965  43.994  1.00 26.74           N  
ATOM    428  CA  PHE A  54     -18.224  35.676  44.542  1.00 26.16           C  
ATOM    429  C   PHE A  54     -16.933  35.202  43.876  1.00 25.91           C  
ATOM    430  O   PHE A  54     -16.892  34.135  43.265  1.00 26.04           O  
ATOM    431  CB  PHE A  54     -18.178  35.475  46.055  1.00 25.93           C  
ATOM    432  CG  PHE A  54     -17.680  34.119  46.463  1.00 25.58           C  
ATOM    433  CD1 PHE A  54     -16.314  33.872  46.572  1.00 25.98           C  
ATOM    434  CD2 PHE A  54     -18.566  33.085  46.713  1.00 25.19           C  
ATOM    435  CE1 PHE A  54     -15.834  32.622  46.956  1.00 26.33           C  
ATOM    436  CE2 PHE A  54     -18.108  31.826  47.066  1.00 26.51           C  
ATOM    437  CZ  PHE A  54     -16.737  31.588  47.208  1.00 26.42           C  
ATOM    438  N   ALA A  55     -15.877  35.998  44.009  1.00 25.81           N  
ATOM    439  CA  ALA A  55     -14.578  35.688  43.431  1.00 25.45           C  
ATOM    440  C   ALA A  55     -13.560  36.240  44.376  1.00 26.16           C  
ATOM    441  O   ALA A  55     -13.700  37.402  44.830  1.00 26.15           O  
ATOM    442  CB  ALA A  55     -14.416  36.351  42.091  1.00 24.95           C  
ATOM    443  N   ILE A  56     -12.556  35.407  44.672  1.00 26.02           N  
ATOM    444  CA  ILE A  56     -11.425  35.773  45.511  1.00 26.80           C  
ATOM    445  C   ILE A  56     -10.160  35.933  44.660  1.00 27.60           C  
ATOM    446  O   ILE A  56      -9.685  34.950  44.036  1.00 27.50           O  
ATOM    447  CB  ILE A  56     -11.111  34.702  46.612  1.00 27.09           C  
ATOM    448  CG1 ILE A  56     -12.313  34.469  47.541  1.00 27.10           C  
ATOM    449  CG2 ILE A  56      -9.847  35.072  47.402  1.00 24.89           C  
ATOM    450  CD1 ILE A  56     -13.014  35.686  47.933  1.00 28.28           C  
ATOM    451  N   THR A  57      -9.593  37.145  44.674  1.00 27.12           N  
ATOM    452  CA  THR A  57      -8.384  37.411  43.904  1.00 26.68           C  
ATOM    453  C   THR A  57      -7.312  38.101  44.731  1.00 26.52           C  
ATOM    454  O   THR A  57      -7.584  39.013  45.501  1.00 25.52           O  
ATOM    455  CB  THR A  57      -8.696  38.255  42.642  1.00 26.72           C  
ATOM    456  OG1 THR A  57      -9.699  37.594  41.866  1.00 26.59           O  
ATOM    457  CG2 THR A  57      -7.462  38.488  41.790  1.00 24.09           C  
ATOM    458  N   GLN A  58      -6.075  37.679  44.512  1.00 26.67           N  
ATOM    459  CA  GLN A  58      -4.943  38.364  45.092  1.00 26.71           C  
ATOM    460  C   GLN A  58      -4.020  38.979  44.043  1.00 26.32           C  
ATOM    461  O   GLN A  58      -3.653  38.327  43.064  1.00 26.15           O  
ATOM    462  CB  GLN A  58      -4.160  37.423  45.978  1.00 26.79           C  
ATOM    463  CG  GLN A  58      -3.132  38.148  46.824  1.00 29.73           C  
ATOM    464  CD  GLN A  58      -2.395  37.211  47.750  1.00 31.94           C  
ATOM    465  OE1 GLN A  58      -1.510  36.454  47.320  1.00 29.66           O  
ATOM    466  NE2 GLN A  58      -2.775  37.238  49.038  1.00 32.26           N  
ATOM    467  N   VAL A  59      -3.634  40.234  44.291  1.00 26.16           N  
ATOM    468  CA  VAL A  59      -2.786  41.011  43.414  1.00 25.39           C  
ATOM    469  C   VAL A  59      -1.417  41.209  44.031  1.00 26.23           C  
ATOM    470  O   VAL A  59      -1.296  41.798  45.122  1.00 26.66           O  
ATOM    471  CB  VAL A  59      -3.412  42.373  43.170  1.00 25.62           C  
ATOM    472  CG1 VAL A  59      -2.491  43.275  42.330  1.00 23.25           C  
ATOM    473  CG2 VAL A  59      -4.820  42.203  42.535  1.00 25.71           C  
ATOM    474  N   VAL A  60      -0.393  40.707  43.331  1.00 26.40           N  
ATOM    475  CA  VAL A  60       0.997  40.933  43.680  1.00 26.70           C  
ATOM    476  C   VAL A  60       1.683  41.509  42.452  1.00 27.15           C  
ATOM    477  O   VAL A  60       1.665  40.910  41.385  1.00 28.39           O  
ATOM    478  CB  VAL A  60       1.757  39.620  44.152  1.00 26.89           C  
ATOM    479  CG1 VAL A  60       3.248  39.905  44.449  1.00 24.45           C  
ATOM    480  CG2 VAL A  60       1.128  39.009  45.391  1.00 26.82           C  
ATOM    481  N   LEU A  61       2.325  42.656  42.615  1.00 27.34           N  
ATOM    482  CA  LEU A  61       2.989  43.328  41.513  1.00 26.57           C  
ATOM    483  C   LEU A  61       1.985  43.603  40.393  1.00 26.98           C  
ATOM    484  O   LEU A  61       1.050  44.321  40.590  1.00 27.34           O  
ATOM    485  CB  LEU A  61       4.205  42.536  41.024  1.00 25.52           C  
ATOM    486  CG  LEU A  61       5.314  42.425  42.083  1.00 24.06           C  
ATOM    487  CD1 LEU A  61       6.448  41.441  41.583  1.00 16.03           C  
ATOM    488  CD2 LEU A  61       5.827  43.814  42.597  1.00 13.78           C  
ATOM    489  N   ASP A  62       2.172  43.019  39.226  1.00 27.46           N  
ATOM    490  CA  ASP A  62       1.312  43.324  38.107  1.00 27.63           C  
ATOM    491  C   ASP A  62       0.716  42.015  37.593  1.00 28.69           C  
ATOM    492  O   ASP A  62       0.317  41.918  36.426  1.00 28.95           O  
ATOM    493  CB  ASP A  62       2.093  44.045  36.998  1.00 26.82           C  
ATOM    494  CG  ASP A  62       3.324  43.258  36.530  1.00 25.88           C  
ATOM    495  OD1 ASP A  62       3.601  42.169  37.069  1.00 26.24           O  
ATOM    496  OD2 ASP A  62       4.025  43.735  35.633  1.00 23.19           O  
ATOM    497  N   GLU A  63       0.686  41.014  38.473  1.00 28.88           N  
ATOM    498  CA  GLU A  63      -0.017  39.774  38.203  1.00 29.35           C  
ATOM    499  C   GLU A  63      -1.073  39.521  39.282  1.00 28.77           C  
ATOM    500  O   GLU A  63      -0.992  40.066  40.372  1.00 28.15           O  
ATOM    501  CB  GLU A  63       0.981  38.617  38.096  1.00 29.34           C  
ATOM    502  CG  GLU A  63       1.912  38.822  36.920  1.00 31.53           C  
ATOM    503  CD  GLU A  63       2.857  37.665  36.675  1.00 33.69           C  
ATOM    504  OE1 GLU A  63       2.427  36.585  36.216  1.00 32.77           O  
ATOM    505  OE2 GLU A  63       4.056  37.851  36.930  1.00 36.15           O  
ATOM    506  N   ALA A  64      -2.061  38.693  38.967  1.00 28.29           N  
ATOM    507  CA  ALA A  64      -3.092  38.371  39.917  1.00 28.23           C  
ATOM    508  C   ALA A  64      -3.385  36.895  39.857  1.00 28.33           C  
ATOM    509  O   ALA A  64      -3.237  36.269  38.807  1.00 28.26           O  
ATOM    510  CB  ALA A  64      -4.354  39.170  39.626  1.00 28.09           C  
ATOM    511  N   THR A  65      -3.820  36.340  40.984  1.00 28.10           N  
ATOM    512  CA  THR A  65      -4.324  34.984  40.979  1.00 27.88           C  
ATOM    513  C   THR A  65      -5.761  34.941  41.463  1.00 27.49           C  
ATOM    514  O   THR A  65      -6.089  35.434  42.547  1.00 27.31           O  
ATOM    515  CB  THR A  65      -3.403  34.046  41.759  1.00 28.19           C  
ATOM    516  OG1 THR A  65      -2.054  34.183  41.247  1.00 29.65           O  
ATOM    517  CG2 THR A  65      -3.856  32.596  41.569  1.00 28.04           C  
ATOM    518  N   LEU A  66      -6.632  34.414  40.618  1.00 27.03           N  
ATOM    519  CA  LEU A  66      -7.998  34.149  41.031  1.00 26.84           C  
ATOM    520  C   LEU A  66      -7.979  32.831  41.766  1.00 26.40           C  
ATOM    521  O   LEU A  66      -7.993  31.787  41.146  1.00 26.82           O  
ATOM    522  CB  LEU A  66      -8.947  34.080  39.836  1.00 26.95           C  
ATOM    523  CG  LEU A  66     -10.393  33.624  40.100  1.00 28.38           C  
ATOM    524  CD1 LEU A  66     -11.292  34.742  40.659  1.00 27.13           C  
ATOM    525  CD2 LEU A  66     -11.006  33.051  38.822  1.00 27.07           C  
ATOM    526  N   PHE A  67      -7.918  32.898  43.093  1.00 26.10           N  
ATOM    527  CA  PHE A  67      -7.991  31.739  43.973  1.00 25.14           C  
ATOM    528  C   PHE A  67      -9.318  30.983  43.953  1.00 24.66           C  
ATOM    529  O   PHE A  67      -9.344  29.822  44.306  1.00 25.78           O  
ATOM    530  CB  PHE A  67      -7.759  32.162  45.423  1.00 25.05           C  
ATOM    531  CG  PHE A  67      -6.380  32.636  45.722  1.00 25.86           C  
ATOM    532  CD1 PHE A  67      -5.304  32.300  44.922  1.00 28.06           C  
ATOM    533  CD2 PHE A  67      -6.142  33.369  46.874  1.00 26.74           C  
ATOM    534  CE1 PHE A  67      -4.009  32.738  45.258  1.00 28.18           C  
ATOM    535  CE2 PHE A  67      -4.861  33.780  47.216  1.00 25.22           C  
ATOM    536  CZ  PHE A  67      -3.805  33.480  46.412  1.00 25.00           C  
ATOM    537  N   ASN A  68     -10.422  31.631  43.596  1.00 24.23           N  
ATOM    538  CA  ASN A  68     -11.741  31.020  43.727  1.00 23.62           C  
ATOM    539  C   ASN A  68     -12.792  31.833  43.002  1.00 23.53           C  
ATOM    540  O   ASN A  68     -12.885  33.041  43.202  1.00 24.03           O  
ATOM    541  CB  ASN A  68     -12.130  30.942  45.226  1.00 23.90           C  
ATOM    542  CG  ASN A  68     -13.306  29.965  45.527  1.00 23.21           C  
ATOM    543  OD1 ASN A  68     -13.983  29.452  44.631  1.00 25.20           O  
ATOM    544  ND2 ASN A  68     -13.519  29.699  46.809  1.00 21.51           N  
ATOM    545  N   ILE A  69     -13.605  31.176  42.182  1.00 23.39           N  
ATOM    546  CA  ILE A  69     -14.854  31.775  41.726  1.00 23.04           C  
ATOM    547  C   ILE A  69     -16.006  30.777  41.938  1.00 24.03           C  
ATOM    548  O   ILE A  69     -15.842  29.568  41.731  1.00 23.96           O  
ATOM    549  CB  ILE A  69     -14.757  32.327  40.265  1.00 23.34           C  
ATOM    550  CG1 ILE A  69     -16.003  33.166  39.919  1.00 21.89           C  
ATOM    551  CG2 ILE A  69     -14.437  31.209  39.218  1.00 21.46           C  
ATOM    552  CD1 ILE A  69     -15.951  33.802  38.554  1.00 21.55           C  
ATOM    553  N   ALA A  70     -17.165  31.286  42.351  1.00 24.31           N  
ATOM    554  CA  ALA A  70     -18.320  30.440  42.677  1.00 24.23           C  
ATOM    555  C   ALA A  70     -19.647  31.136  42.414  1.00 24.35           C  
ATOM    556  O   ALA A  70     -19.925  32.205  42.970  1.00 24.64           O  
ATOM    557  CB  ALA A  70     -18.264  29.998  44.132  1.00 24.18           C  
ATOM    558  N   VAL A  71     -20.462  30.517  41.574  1.00 24.11           N  
ATOM    559  CA  VAL A  71     -21.804  30.963  41.352  1.00 24.34           C  
ATOM    560  C   VAL A  71     -22.645  29.917  42.053  1.00 24.92           C  
ATOM    561  O   VAL A  71     -22.415  28.711  41.879  1.00 24.74           O  
ATOM    562  CB  VAL A  71     -22.130  30.993  39.844  1.00 24.88           C  
ATOM    563  CG1 VAL A  71     -23.597  31.388  39.606  1.00 23.55           C  
ATOM    564  CG2 VAL A  71     -21.149  31.910  39.096  1.00 23.84           C  
ATOM    565  N   ASP A  72     -23.598  30.367  42.859  1.00 24.65           N  
ATOM    566  CA  ASP A  72     -24.438  29.459  43.599  1.00 24.76           C  
ATOM    567  C   ASP A  72     -25.231  28.621  42.610  1.00 25.10           C  
ATOM    568  O   ASP A  72     -25.625  29.135  41.573  1.00 25.58           O  
ATOM    569  CB  ASP A  72     -25.367  30.246  44.518  1.00 24.64           C  
ATOM    570  CG  ASP A  72     -26.258  29.356  45.329  1.00 24.11           C  
ATOM    571  OD1 ASP A  72     -27.302  28.963  44.809  1.00 26.05           O  
ATOM    572  OD2 ASP A  72     -25.934  29.044  46.483  1.00 24.16           O  
ATOM    573  N   PRO A  73     -25.450  27.325  42.911  1.00 25.46           N  
ATOM    574  CA  PRO A  73     -26.215  26.489  41.980  1.00 26.03           C  
ATOM    575  C   PRO A  73     -27.526  27.112  41.473  1.00 26.38           C  
ATOM    576  O   PRO A  73     -27.822  27.019  40.276  1.00 26.75           O  
ATOM    577  CB  PRO A  73     -26.478  25.215  42.796  1.00 25.94           C  
ATOM    578  CG  PRO A  73     -25.261  25.112  43.644  1.00 25.03           C  
ATOM    579  CD  PRO A  73     -24.995  26.533  44.074  1.00 25.30           C  
ATOM    580  N   ASP A  74     -28.295  27.741  42.363  1.00 26.24           N  
ATOM    581  CA  ASP A  74     -29.521  28.447  41.976  1.00 25.84           C  
ATOM    582  C   ASP A  74     -29.313  29.483  40.867  1.00 25.91           C  
ATOM    583  O   ASP A  74     -30.244  29.798  40.137  1.00 25.64           O  
ATOM    584  CB  ASP A  74     -30.112  29.152  43.189  1.00 25.87           C  
ATOM    585  CG  ASP A  74     -30.892  28.216  44.102  1.00 26.82           C  
ATOM    586  OD1 ASP A  74     -30.799  26.965  43.969  1.00 25.08           O  
ATOM    587  OD2 ASP A  74     -31.623  28.761  44.960  1.00 27.49           O  
ATOM    588  N   PHE A  75     -28.091  30.003  40.749  1.00 25.93           N  
ATOM    589  CA  PHE A  75     -27.809  31.078  39.822  1.00 26.33           C  
ATOM    590  C   PHE A  75     -26.965  30.724  38.594  1.00 26.55           C  
ATOM    591  O   PHE A  75     -26.681  31.591  37.770  1.00 26.61           O  
ATOM    592  CB  PHE A  75     -27.230  32.273  40.576  1.00 26.45           C  
ATOM    593  CG  PHE A  75     -28.269  33.065  41.299  1.00 27.58           C  
ATOM    594  CD1 PHE A  75     -29.072  33.965  40.611  1.00 28.09           C  
ATOM    595  CD2 PHE A  75     -28.474  32.892  42.661  1.00 28.93           C  
ATOM    596  CE1 PHE A  75     -30.064  34.698  41.270  1.00 28.55           C  
ATOM    597  CE2 PHE A  75     -29.461  33.619  43.339  1.00 28.96           C  
ATOM    598  CZ  PHE A  75     -30.254  34.525  42.644  1.00 28.47           C  
ATOM    599  N   GLN A  76     -26.586  29.459  38.450  1.00 26.85           N  
ATOM    600  CA  GLN A  76     -25.683  29.057  37.364  1.00 27.24           C  
ATOM    601  C   GLN A  76     -26.262  29.063  35.950  1.00 28.01           C  
ATOM    602  O   GLN A  76     -27.462  29.175  35.738  1.00 27.77           O  
ATOM    603  CB  GLN A  76     -25.038  27.713  37.670  1.00 26.97           C  
ATOM    604  CG  GLN A  76     -23.861  27.812  38.645  1.00 26.57           C  
ATOM    605  CD  GLN A  76     -23.536  26.481  39.283  1.00 25.31           C  
ATOM    606  OE1 GLN A  76     -23.966  25.435  38.812  1.00 27.20           O  
ATOM    607  NE2 GLN A  76     -22.773  26.510  40.345  1.00 23.26           N  
ATOM    608  N   ARG A  77     -25.370  28.942  34.983  1.00 29.47           N  
ATOM    609  CA  ARG A  77     -25.707  28.974  33.567  1.00 31.70           C  
ATOM    610  C   ARG A  77     -26.676  30.089  33.221  1.00 31.77           C  
ATOM    611  O   ARG A  77     -27.517  29.924  32.350  1.00 31.99           O  
ATOM    612  CB  ARG A  77     -26.238  27.617  33.085  1.00 31.71           C  
ATOM    613  CG  ARG A  77     -25.140  26.555  32.864  1.00 33.80           C  
ATOM    614  CD  ARG A  77     -25.718  25.124  32.882  1.00 33.74           C  
ATOM    615  NE  ARG A  77     -26.780  25.053  33.888  1.00 37.96           N  
ATOM    616  CZ  ARG A  77     -27.796  24.200  33.877  1.00 39.19           C  
ATOM    617  NH1 ARG A  77     -27.910  23.292  32.904  1.00 40.10           N  
ATOM    618  NH2 ARG A  77     -28.702  24.266  34.851  1.00 39.49           N  
ATOM    619  N   ARG A  78     -26.551  31.227  33.894  1.00 32.32           N  
ATOM    620  CA  ARG A  78     -27.349  32.403  33.539  1.00 32.23           C  
ATOM    621  C   ARG A  78     -26.447  33.584  33.141  1.00 31.65           C  
ATOM    622  O   ARG A  78     -26.920  34.716  33.038  1.00 31.31           O  
ATOM    623  CB  ARG A  78     -28.309  32.798  34.678  1.00 32.95           C  
ATOM    624  CG  ARG A  78     -29.351  31.734  35.086  1.00 34.80           C  
ATOM    625  CD  ARG A  78     -30.663  32.405  35.461  1.00 40.14           C  
ATOM    626  NE  ARG A  78     -31.227  31.985  36.751  1.00 44.03           N  
ATOM    627  CZ  ARG A  78     -31.950  32.784  37.553  1.00 45.76           C  
ATOM    628  NH1 ARG A  78     -32.178  34.056  37.209  1.00 45.19           N  
ATOM    629  NH2 ARG A  78     -32.435  32.322  38.711  1.00 45.28           N  
ATOM    630  N   GLY A  79     -25.153  33.312  32.917  1.00 30.67           N  
ATOM    631  CA  GLY A  79     -24.197  34.334  32.474  1.00 29.67           C  
ATOM    632  C   GLY A  79     -23.601  35.226  33.557  1.00 29.47           C  
ATOM    633  O   GLY A  79     -22.957  36.240  33.251  1.00 29.73           O  
ATOM    634  N   LEU A  80     -23.814  34.864  34.820  1.00 28.71           N  
ATOM    635  CA  LEU A  80     -23.353  35.677  35.935  1.00 28.22           C  
ATOM    636  C   LEU A  80     -21.891  35.422  36.203  1.00 28.11           C  
ATOM    637  O   LEU A  80     -21.154  36.347  36.536  1.00 28.64           O  
ATOM    638  CB  LEU A  80     -24.203  35.437  37.181  1.00 27.79           C  
ATOM    639  CG  LEU A  80     -25.673  35.768  36.907  1.00 28.63           C  
ATOM    640  CD1 LEU A  80     -26.520  35.514  38.136  1.00 29.27           C  
ATOM    641  CD2 LEU A  80     -25.873  37.216  36.391  1.00 26.20           C  
ATOM    642  N   GLY A  81     -21.472  34.173  36.025  1.00 27.41           N  
ATOM    643  CA  GLY A  81     -20.079  33.816  36.147  1.00 27.21           C  
ATOM    644  C   GLY A  81     -19.205  34.650  35.252  1.00 27.32           C  
ATOM    645  O   GLY A  81     -18.285  35.289  35.725  1.00 26.97           O  
ATOM    646  N   ARG A  82     -19.523  34.657  33.958  1.00 27.97           N  
ATOM    647  CA  ARG A  82     -18.804  35.438  32.973  1.00 28.28           C  
ATOM    648  C   ARG A  82     -18.856  36.904  33.319  1.00 28.42           C  
ATOM    649  O   ARG A  82     -17.841  37.599  33.274  1.00 29.62           O  
ATOM    650  CB  ARG A  82     -19.415  35.246  31.601  1.00 28.05           C  
ATOM    651  CG  ARG A  82     -19.097  36.359  30.610  1.00 28.61           C  
ATOM    652  CD  ARG A  82     -19.691  36.075  29.220  1.00 29.70           C  
ATOM    653  NE  ARG A  82     -18.699  35.391  28.384  1.00 34.51           N  
ATOM    654  CZ  ARG A  82     -18.752  34.103  28.055  1.00 34.50           C  
ATOM    655  NH1 ARG A  82     -19.769  33.348  28.457  1.00 35.74           N  
ATOM    656  NH2 ARG A  82     -17.792  33.574  27.319  1.00 33.46           N  
ATOM    657  N   MET A  83     -20.029  37.382  33.678  1.00 27.73           N  
ATOM    658  CA  MET A  83     -20.162  38.787  33.951  1.00 28.13           C  
ATOM    659  C   MET A  83     -19.227  39.195  35.094  1.00 28.16           C  
ATOM    660  O   MET A  83     -18.546  40.212  34.999  1.00 28.51           O  
ATOM    661  CB  MET A  83     -21.615  39.130  34.270  1.00 27.59           C  
ATOM    662  CG  MET A  83     -21.822  40.577  34.581  1.00 27.59           C  
ATOM    663  SD  MET A  83     -23.435  40.946  35.290  1.00 29.14           S  
ATOM    664  CE  MET A  83     -24.574  40.437  33.990  1.00 26.58           C  
ATOM    665  N   LEU A  84     -19.207  38.411  36.168  1.00 27.82           N  
ATOM    666  CA  LEU A  84     -18.392  38.732  37.322  1.00 28.28           C  
ATOM    667  C   LEU A  84     -16.931  38.727  36.919  1.00 28.74           C  
ATOM    668  O   LEU A  84     -16.172  39.624  37.308  1.00 28.38           O  
ATOM    669  CB  LEU A  84     -18.628  37.732  38.470  1.00 28.47           C  
ATOM    670  CG  LEU A  84     -17.731  37.791  39.710  1.00 27.71           C  
ATOM    671  CD1 LEU A  84     -17.777  39.176  40.312  1.00 27.56           C  
ATOM    672  CD2 LEU A  84     -18.150  36.748  40.749  1.00 27.83           C  
ATOM    673  N   LEU A  85     -16.554  37.699  36.154  1.00 29.00           N  
ATOM    674  CA  LEU A  85     -15.204  37.559  35.653  1.00 29.59           C  
ATOM    675  C   LEU A  85     -14.818  38.745  34.819  1.00 29.87           C  
ATOM    676  O   LEU A  85     -13.713  39.255  34.976  1.00 30.25           O  
ATOM    677  CB  LEU A  85     -15.021  36.273  34.848  1.00 29.98           C  
ATOM    678  CG  LEU A  85     -14.151  35.243  35.578  1.00 31.09           C  
ATOM    679  CD1 LEU A  85     -14.284  33.880  35.004  1.00 30.86           C  
ATOM    680  CD2 LEU A  85     -12.706  35.687  35.512  1.00 33.70           C  
ATOM    681  N   GLU A  86     -15.730  39.200  33.954  1.00 29.70           N  
ATOM    682  CA  GLU A  86     -15.496  40.384  33.117  1.00 29.64           C  
ATOM    683  C   GLU A  86     -15.294  41.649  33.961  1.00 29.61           C  
ATOM    684  O   GLU A  86     -14.383  42.450  33.679  1.00 30.03           O  
ATOM    685  CB  GLU A  86     -16.593  40.564  32.055  1.00 29.26           C  
ATOM    686  CG  GLU A  86     -16.446  39.611  30.851  1.00 29.62           C  
ATOM    687  CD  GLU A  86     -17.677  39.564  29.911  1.00 31.00           C  
ATOM    688  OE1 GLU A  86     -18.737  40.160  30.224  1.00 32.25           O  
ATOM    689  OE2 GLU A  86     -17.588  38.900  28.846  1.00 31.90           O  
ATOM    690  N   HIS A  87     -16.094  41.823  35.012  1.00 28.40           N  
ATOM    691  CA  HIS A  87     -15.896  42.985  35.842  1.00 28.15           C  
ATOM    692  C   HIS A  87     -14.495  42.964  36.499  1.00 28.16           C  
ATOM    693  O   HIS A  87     -13.816  44.003  36.635  1.00 28.21           O  
ATOM    694  CB  HIS A  87     -17.042  43.142  36.831  1.00 28.11           C  
ATOM    695  CG  HIS A  87     -18.246  43.826  36.244  1.00 29.78           C  
ATOM    696  ND1 HIS A  87     -18.952  43.311  35.175  1.00 29.78           N  
ATOM    697  CD2 HIS A  87     -18.864  44.986  36.569  1.00 29.63           C  
ATOM    698  CE1 HIS A  87     -19.947  44.124  34.864  1.00 27.86           C  
ATOM    699  NE2 HIS A  87     -19.918  45.147  35.695  1.00 28.34           N  
ATOM    700  N   LEU A  88     -14.045  41.767  36.856  1.00 27.43           N  
ATOM    701  CA  LEU A  88     -12.799  41.618  37.570  1.00 26.72           C  
ATOM    702  C   LEU A  88     -11.650  41.989  36.623  1.00 27.19           C  
ATOM    703  O   LEU A  88     -10.714  42.741  36.989  1.00 26.39           O  
ATOM    704  CB  LEU A  88     -12.647  40.179  38.067  1.00 26.08           C  
ATOM    705  CG  LEU A  88     -11.261  39.764  38.556  1.00 23.29           C  
ATOM    706  CD1 LEU A  88     -10.762  40.643  39.720  1.00 19.39           C  
ATOM    707  CD2 LEU A  88     -11.299  38.332  38.954  1.00 19.45           C  
ATOM    708  N   ILE A  89     -11.740  41.465  35.404  1.00 26.90           N  
ATOM    709  CA  ILE A  89     -10.720  41.729  34.404  1.00 26.75           C  
ATOM    710  C   ILE A  89     -10.568  43.227  34.149  1.00 26.82           C  
ATOM    711  O   ILE A  89      -9.458  43.719  34.188  1.00 25.97           O  
ATOM    712  CB  ILE A  89     -10.933  40.883  33.133  1.00 26.59           C  
ATOM    713  CG1 ILE A  89     -10.699  39.413  33.461  1.00 24.97           C  
ATOM    714  CG2 ILE A  89      -9.987  41.306  32.053  1.00 26.38           C  
ATOM    715  CD1 ILE A  89     -11.482  38.476  32.588  1.00 23.87           C  
ATOM    716  N   ASP A  90     -11.681  43.948  33.961  1.00 28.36           N  
ATOM    717  CA  ASP A  90     -11.664  45.423  33.792  1.00 29.73           C  
ATOM    718  C   ASP A  90     -11.002  46.060  34.979  1.00 29.58           C  
ATOM    719  O   ASP A  90     -10.191  46.969  34.832  1.00 29.88           O  
ATOM    720  CB  ASP A  90     -13.073  46.045  33.709  1.00 30.74           C  
ATOM    721  CG  ASP A  90     -13.825  45.671  32.446  1.00 34.69           C  
ATOM    722  OD1 ASP A  90     -13.173  45.250  31.438  1.00 38.29           O  
ATOM    723  OD2 ASP A  90     -15.087  45.793  32.469  1.00 37.37           O  
ATOM    724  N   GLU A  91     -11.369  45.588  36.163  1.00 29.38           N  
ATOM    725  CA  GLU A  91     -10.831  46.157  37.378  1.00 29.89           C  
ATOM    726  C   GLU A  91      -9.308  45.915  37.495  1.00 29.79           C  
ATOM    727  O   GLU A  91      -8.551  46.841  37.814  1.00 30.38           O  
ATOM    728  CB  GLU A  91     -11.611  45.656  38.593  1.00 29.72           C  
ATOM    729  CG  GLU A  91     -11.010  46.080  39.906  1.00 32.54           C  
ATOM    730  CD  GLU A  91     -11.116  47.582  40.179  1.00 37.21           C  
ATOM    731  OE1 GLU A  91     -12.108  48.237  39.725  1.00 38.05           O  
ATOM    732  OE2 GLU A  91     -10.210  48.091  40.883  1.00 37.18           O  
ATOM    733  N   LEU A  92      -8.847  44.704  37.201  1.00 28.93           N  
ATOM    734  CA  LEU A  92      -7.403  44.439  37.183  1.00 28.15           C  
ATOM    735  C   LEU A  92      -6.634  45.285  36.154  1.00 28.37           C  
ATOM    736  O   LEU A  92      -5.495  45.671  36.422  1.00 28.44           O  
ATOM    737  CB  LEU A  92      -7.124  42.955  36.932  1.00 28.01           C  
ATOM    738  CG  LEU A  92      -7.599  41.981  38.017  1.00 26.50           C  
ATOM    739  CD1 LEU A  92      -7.624  40.590  37.485  1.00 23.55           C  
ATOM    740  CD2 LEU A  92      -6.757  42.094  39.249  1.00 24.93           C  
ATOM    741  N   GLU A  93      -7.233  45.574  34.995  1.00 27.62           N  
ATOM    742  CA  GLU A  93      -6.559  46.381  33.966  1.00 27.44           C  
ATOM    743  C   GLU A  93      -6.297  47.827  34.432  1.00 27.92           C  
ATOM    744  O   GLU A  93      -5.186  48.380  34.219  1.00 27.82           O  
ATOM    745  CB  GLU A  93      -7.339  46.388  32.633  1.00 27.40           C  
ATOM    746  CG  GLU A  93      -6.646  47.100  31.456  1.00 25.99           C  
ATOM    747  CD  GLU A  93      -6.620  48.598  31.579  1.00 27.68           C  
ATOM    748  OE1 GLU A  93      -7.550  49.143  32.194  1.00 30.31           O  
ATOM    749  OE2 GLU A  93      -5.679  49.250  31.061  1.00 29.46           O  
ATOM    750  N   THR A  94      -7.324  48.449  35.016  1.00 27.49           N  
ATOM    751  CA  THR A  94      -7.153  49.753  35.654  1.00 27.76           C  
ATOM    752  C   THR A  94      -6.073  49.691  36.760  1.00 26.55           C  
ATOM    753  O   THR A  94      -5.500  50.702  37.128  1.00 27.03           O  
ATOM    754  CB  THR A  94      -8.472  50.284  36.305  1.00 28.14           C  
ATOM    755  OG1 THR A  94      -8.892  49.345  37.300  1.00 31.64           O  
ATOM    756  CG2 THR A  94      -9.622  50.484  35.266  1.00 27.77           C  
ATOM    757  N   ARG A  95      -5.795  48.515  37.293  1.00 25.33           N  
ATOM    758  CA  ARG A  95      -4.819  48.399  38.378  1.00 24.70           C  
ATOM    759  C   ARG A  95      -3.422  48.028  37.875  1.00 24.64           C  
ATOM    760  O   ARG A  95      -2.495  47.887  38.674  1.00 24.23           O  
ATOM    761  CB  ARG A  95      -5.278  47.371  39.413  1.00 24.80           C  
ATOM    762  CG  ARG A  95      -6.310  47.904  40.355  1.00 24.09           C  
ATOM    763  CD  ARG A  95      -6.880  46.842  41.203  1.00 21.30           C  
ATOM    764  NE  ARG A  95      -7.777  47.458  42.181  1.00 25.68           N  
ATOM    765  CZ  ARG A  95      -7.405  48.020  43.335  1.00 25.41           C  
ATOM    766  NH1 ARG A  95      -6.132  48.048  43.691  1.00 25.10           N  
ATOM    767  NH2 ARG A  95      -8.326  48.559  44.136  1.00 26.44           N  
ATOM    768  N   GLY A  96      -3.279  47.870  36.557  1.00 23.58           N  
ATOM    769  CA  GLY A  96      -1.982  47.652  35.960  1.00 22.81           C  
ATOM    770  C   GLY A  96      -1.590  46.183  35.937  1.00 22.84           C  
ATOM    771  O   GLY A  96      -0.413  45.850  35.688  1.00 22.07           O  
ATOM    772  N   VAL A  97      -2.574  45.317  36.196  1.00 22.10           N  
ATOM    773  CA  VAL A  97      -2.357  43.895  36.232  1.00 22.29           C  
ATOM    774  C   VAL A  97      -2.356  43.407  34.776  1.00 22.61           C  
ATOM    775  O   VAL A  97      -3.268  43.754  34.012  1.00 22.56           O  
ATOM    776  CB  VAL A  97      -3.443  43.181  37.043  1.00 22.09           C  
ATOM    777  CG1 VAL A  97      -3.240  41.667  37.024  1.00 23.11           C  
ATOM    778  CG2 VAL A  97      -3.466  43.669  38.464  1.00 21.99           C  
ATOM    779  N   VAL A  98      -1.332  42.623  34.408  1.00 21.86           N  
ATOM    780  CA  VAL A  98      -1.138  42.198  33.024  1.00 21.95           C  
ATOM    781  C   VAL A  98      -1.401  40.724  32.796  1.00 22.60           C  
ATOM    782  O   VAL A  98      -1.530  40.277  31.635  1.00 23.45           O  
ATOM    783  CB  VAL A  98       0.256  42.544  32.483  1.00 21.49           C  
ATOM    784  CG1 VAL A  98       0.572  44.003  32.769  1.00 21.06           C  
ATOM    785  CG2 VAL A  98       1.339  41.591  33.052  1.00 20.70           C  
ATOM    786  N   THR A  99      -1.491  39.970  33.882  1.00 22.04           N  
ATOM    787  CA  THR A  99      -1.713  38.550  33.781  1.00 22.80           C  
ATOM    788  C   THR A  99      -2.589  38.100  34.926  1.00 23.77           C  
ATOM    789  O   THR A  99      -2.294  38.396  36.088  1.00 24.05           O  
ATOM    790  CB  THR A  99      -0.374  37.765  33.795  1.00 22.57           C  
ATOM    791  OG1 THR A  99       0.460  38.254  32.741  1.00 23.88           O  
ATOM    792  CG2 THR A  99      -0.597  36.274  33.567  1.00 20.70           C  
ATOM    793  N   LEU A 100      -3.687  37.421  34.594  1.00 24.49           N  
ATOM    794  CA  LEU A 100      -4.524  36.769  35.611  1.00 24.65           C  
ATOM    795  C   LEU A 100      -4.256  35.275  35.519  1.00 24.86           C  
ATOM    796  O   LEU A 100      -4.265  34.708  34.412  1.00 25.54           O  
ATOM    797  CB  LEU A 100      -6.010  37.076  35.383  1.00 24.42           C  
ATOM    798  CG  LEU A 100      -7.058  36.541  36.361  1.00 24.17           C  
ATOM    799  CD1 LEU A 100      -6.738  36.950  37.777  1.00 23.86           C  
ATOM    800  CD2 LEU A 100      -8.431  37.074  35.975  1.00 24.18           C  
ATOM    801  N   TRP A 101      -3.994  34.651  36.665  1.00 24.35           N  
ATOM    802  CA  TRP A 101      -3.742  33.227  36.736  1.00 24.34           C  
ATOM    803  C   TRP A 101      -4.856  32.517  37.505  1.00 25.39           C  
ATOM    804  O   TRP A 101      -5.554  33.148  38.347  1.00 25.23           O  
ATOM    805  CB  TRP A 101      -2.429  32.969  37.472  1.00 24.71           C  
ATOM    806  CG  TRP A 101      -1.135  33.452  36.787  1.00 23.91           C  
ATOM    807  CD1 TRP A 101      -0.566  34.688  36.893  1.00 22.37           C  
ATOM    808  CD2 TRP A 101      -0.254  32.671  35.981  1.00 21.86           C  
ATOM    809  NE1 TRP A 101       0.605  34.725  36.190  1.00 22.88           N  
ATOM    810  CE2 TRP A 101       0.825  33.507  35.615  1.00 22.87           C  
ATOM    811  CE3 TRP A 101      -0.263  31.341  35.539  1.00 23.16           C  
ATOM    812  CZ2 TRP A 101       1.885  33.068  34.807  1.00 23.52           C  
ATOM    813  CZ3 TRP A 101       0.808  30.890  34.725  1.00 23.03           C  
ATOM    814  CH2 TRP A 101       1.858  31.760  34.370  1.00 22.94           C  
ATOM    815  N   LEU A 102      -4.997  31.200  37.257  1.00 25.73           N  
ATOM    816  CA  LEU A 102      -5.971  30.354  37.989  1.00 25.83           C  
ATOM    817  C   LEU A 102      -5.648  28.875  37.827  1.00 26.32           C  
ATOM    818  O   LEU A 102      -4.898  28.506  36.929  1.00 27.52           O  
ATOM    819  CB  LEU A 102      -7.426  30.631  37.537  1.00 25.42           C  
ATOM    820  CG  LEU A 102      -7.977  30.290  36.143  1.00 25.04           C  
ATOM    821  CD1 LEU A 102      -8.318  28.824  35.952  1.00 26.24           C  
ATOM    822  CD2 LEU A 102      -9.206  31.079  35.898  1.00 25.53           C  
ATOM    823  N   GLU A 103      -6.234  28.046  38.695  1.00 26.36           N  
ATOM    824  CA  GLU A 103      -6.182  26.584  38.632  1.00 25.97           C  
ATOM    825  C   GLU A 103      -7.605  26.037  38.407  1.00 25.49           C  
ATOM    826  O   GLU A 103      -8.583  26.502  39.025  1.00 25.21           O  
ATOM    827  CB  GLU A 103      -5.654  25.988  39.952  1.00 25.95           C  
ATOM    828  CG  GLU A 103      -4.223  26.256  40.321  1.00 28.13           C  
ATOM    829  CD  GLU A 103      -4.016  27.598  41.030  1.00 34.32           C  
ATOM    830  OE1 GLU A 103      -4.942  28.090  41.750  1.00 35.36           O  
ATOM    831  OE2 GLU A 103      -2.906  28.166  40.876  1.00 34.92           O  
ATOM    832  N   VAL A 104      -7.735  25.022  37.563  1.00 24.56           N  
ATOM    833  CA  VAL A 104      -9.039  24.398  37.398  1.00 23.54           C  
ATOM    834  C   VAL A 104      -8.951  22.871  37.275  1.00 23.63           C  
ATOM    835  O   VAL A 104      -8.016  22.332  36.687  1.00 22.83           O  
ATOM    836  CB  VAL A 104      -9.865  25.084  36.254  1.00 23.54           C  
ATOM    837  CG1 VAL A 104      -9.125  25.067  34.925  1.00 21.76           C  
ATOM    838  CG2 VAL A 104     -11.238  24.474  36.139  1.00 23.33           C  
ATOM    839  N   ARG A 105      -9.906  22.175  37.895  1.00 24.03           N  
ATOM    840  CA  ARG A 105     -10.016  20.727  37.730  1.00 23.19           C  
ATOM    841  C   ARG A 105     -10.046  20.448  36.251  1.00 23.81           C  
ATOM    842  O   ARG A 105     -10.747  21.122  35.502  1.00 24.52           O  
ATOM    843  CB  ARG A 105     -11.267  20.184  38.406  1.00 22.86           C  
ATOM    844  CG  ARG A 105     -11.120  20.103  39.901  1.00 22.37           C  
ATOM    845  CD  ARG A 105     -12.360  19.576  40.656  1.00 21.76           C  
ATOM    846  NE  ARG A 105     -12.080  19.727  42.081  1.00 18.70           N  
ATOM    847  CZ  ARG A 105     -11.605  18.773  42.879  1.00 18.99           C  
ATOM    848  NH1 ARG A 105     -11.395  17.532  42.421  1.00 18.08           N  
ATOM    849  NH2 ARG A 105     -11.336  19.065  44.151  1.00 18.78           N  
ATOM    850  N   ALA A 106      -9.260  19.474  35.833  1.00 24.25           N  
ATOM    851  CA  ALA A 106      -9.087  19.176  34.431  1.00 24.59           C  
ATOM    852  C   ALA A 106     -10.397  18.755  33.812  1.00 24.86           C  
ATOM    853  O   ALA A 106     -10.575  18.962  32.625  1.00 25.77           O  
ATOM    854  CB  ALA A 106      -8.012  18.088  34.233  1.00 24.82           C  
ATOM    855  N   SER A 107     -11.309  18.191  34.610  1.00 24.68           N  
ATOM    856  CA  SER A 107     -12.628  17.735  34.112  1.00 24.67           C  
ATOM    857  C   SER A 107     -13.771  18.751  34.198  1.00 25.08           C  
ATOM    858  O   SER A 107     -14.922  18.433  33.899  1.00 24.36           O  
ATOM    859  CB  SER A 107     -13.084  16.467  34.846  1.00 24.46           C  
ATOM    860  OG  SER A 107     -13.350  16.773  36.204  1.00 21.62           O  
ATOM    861  N   ASN A 108     -13.478  19.958  34.645  1.00 25.87           N  
ATOM    862  CA  ASN A 108     -14.502  20.979  34.676  1.00 26.70           C  
ATOM    863  C   ASN A 108     -14.642  21.601  33.273  1.00 27.44           C  
ATOM    864  O   ASN A 108     -14.042  22.633  32.973  1.00 27.79           O  
ATOM    865  CB  ASN A 108     -14.136  22.004  35.726  1.00 26.53           C  
ATOM    866  CG  ASN A 108     -15.274  22.907  36.068  1.00 27.92           C  
ATOM    867  OD1 ASN A 108     -16.264  23.009  35.320  1.00 30.69           O  
ATOM    868  ND2 ASN A 108     -15.143  23.604  37.187  1.00 25.83           N  
ATOM    869  N   ALA A 109     -15.408  20.931  32.410  1.00 28.03           N  
ATOM    870  CA  ALA A 109     -15.577  21.324  30.998  1.00 28.34           C  
ATOM    871  C   ALA A 109     -16.236  22.698  30.874  1.00 28.29           C  
ATOM    872  O   ALA A 109     -15.861  23.515  30.017  1.00 27.66           O  
ATOM    873  CB  ALA A 109     -16.398  20.274  30.248  1.00 27.88           C  
ATOM    874  N   ALA A 110     -17.212  22.926  31.755  1.00 28.25           N  
ATOM    875  CA  ALA A 110     -17.830  24.233  31.942  1.00 28.18           C  
ATOM    876  C   ALA A 110     -16.801  25.340  32.197  1.00 27.86           C  
ATOM    877  O   ALA A 110     -16.711  26.293  31.417  1.00 28.37           O  
ATOM    878  CB  ALA A 110     -18.838  24.189  33.078  1.00 27.98           C  
ATOM    879  N   ALA A 111     -16.039  25.229  33.277  1.00 26.70           N  
ATOM    880  CA  ALA A 111     -15.226  26.357  33.703  1.00 25.92           C  
ATOM    881  C   ALA A 111     -14.184  26.640  32.644  1.00 25.80           C  
ATOM    882  O   ALA A 111     -13.987  27.801  32.271  1.00 25.70           O  
ATOM    883  CB  ALA A 111     -14.584  26.099  35.030  1.00 25.41           C  
ATOM    884  N   ILE A 112     -13.557  25.567  32.148  1.00 25.37           N  
ATOM    885  CA  ILE A 112     -12.507  25.641  31.152  1.00 24.69           C  
ATOM    886  C   ILE A 112     -12.999  26.401  29.929  1.00 25.71           C  
ATOM    887  O   ILE A 112     -12.323  27.341  29.456  1.00 25.86           O  
ATOM    888  CB  ILE A 112     -12.026  24.232  30.730  1.00 24.64           C  
ATOM    889  CG1 ILE A 112     -11.368  23.529  31.914  1.00 24.33           C  
ATOM    890  CG2 ILE A 112     -11.055  24.292  29.531  1.00 21.77           C  
ATOM    891  CD1 ILE A 112     -11.034  22.043  31.620  1.00 24.29           C  
ATOM    892  N   ALA A 113     -14.175  26.009  29.429  1.00 25.87           N  
ATOM    893  CA  ALA A 113     -14.752  26.648  28.242  1.00 26.16           C  
ATOM    894  C   ALA A 113     -15.029  28.118  28.499  1.00 26.63           C  
ATOM    895  O   ALA A 113     -14.823  28.953  27.600  1.00 27.22           O  
ATOM    896  CB  ALA A 113     -16.005  25.943  27.774  1.00 25.88           C  
ATOM    897  N   LEU A 114     -15.473  28.450  29.717  1.00 26.55           N  
ATOM    898  CA  LEU A 114     -15.692  29.856  30.063  1.00 26.46           C  
ATOM    899  C   LEU A 114     -14.351  30.604  29.970  1.00 26.60           C  
ATOM    900  O   LEU A 114     -14.228  31.589  29.221  1.00 25.71           O  
ATOM    901  CB  LEU A 114     -16.301  30.000  31.452  1.00 26.39           C  
ATOM    902  CG  LEU A 114     -16.217  31.403  32.067  1.00 27.95           C  
ATOM    903  CD1 LEU A 114     -17.165  32.374  31.374  1.00 30.38           C  
ATOM    904  CD2 LEU A 114     -16.492  31.372  33.546  1.00 29.89           C  
ATOM    905  N   TYR A 115     -13.355  30.097  30.697  1.00 26.33           N  
ATOM    906  CA  TYR A 115     -12.041  30.707  30.711  1.00 27.15           C  
ATOM    907  C   TYR A 115     -11.456  30.812  29.321  1.00 27.40           C  
ATOM    908  O   TYR A 115     -10.861  31.829  28.989  1.00 27.40           O  
ATOM    909  CB  TYR A 115     -11.082  29.959  31.624  1.00 26.89           C  
ATOM    910  CG  TYR A 115     -11.644  29.716  32.992  1.00 27.30           C  
ATOM    911  CD1 TYR A 115     -12.519  30.635  33.607  1.00 27.51           C  
ATOM    912  CD2 TYR A 115     -11.322  28.565  33.680  1.00 27.78           C  
ATOM    913  CE1 TYR A 115     -13.061  30.390  34.893  1.00 26.49           C  
ATOM    914  CE2 TYR A 115     -11.854  28.313  34.955  1.00 29.58           C  
ATOM    915  CZ  TYR A 115     -12.719  29.224  35.547  1.00 27.92           C  
ATOM    916  OH  TYR A 115     -13.208  28.917  36.794  1.00 28.89           O  
ATOM    917  N   GLU A 116     -11.637  29.776  28.511  1.00 27.93           N  
ATOM    918  CA  GLU A 116     -11.053  29.776  27.175  1.00 28.44           C  
ATOM    919  C   GLU A 116     -11.684  30.885  26.374  1.00 27.84           C  
ATOM    920  O   GLU A 116     -10.988  31.625  25.699  1.00 28.21           O  
ATOM    921  CB  GLU A 116     -11.212  28.417  26.472  1.00 29.12           C  
ATOM    922  CG  GLU A 116      -9.884  27.645  26.343  1.00 32.30           C  
ATOM    923  CD  GLU A 116     -10.057  26.116  26.311  1.00 36.78           C  
ATOM    924  OE1 GLU A 116     -11.034  25.620  25.687  1.00 38.06           O  
ATOM    925  OE2 GLU A 116      -9.195  25.409  26.907  1.00 37.85           O  
ATOM    926  N   SER A 117     -12.999  31.035  26.495  1.00 27.28           N  
ATOM    927  CA  SER A 117     -13.714  32.067  25.747  1.00 26.64           C  
ATOM    928  C   SER A 117     -13.412  33.489  26.236  1.00 26.42           C  
ATOM    929  O   SER A 117     -13.641  34.451  25.499  1.00 26.95           O  
ATOM    930  CB  SER A 117     -15.221  31.814  25.745  1.00 26.34           C  
ATOM    931  OG  SER A 117     -15.782  32.156  26.986  1.00 27.04           O  
ATOM    932  N   LEU A 118     -12.897  33.621  27.455  1.00 25.50           N  
ATOM    933  CA  LEU A 118     -12.446  34.902  27.974  1.00 24.63           C  
ATOM    934  C   LEU A 118     -11.011  35.229  27.584  1.00 24.72           C  
ATOM    935  O   LEU A 118     -10.548  36.347  27.819  1.00 24.45           O  
ATOM    936  CB  LEU A 118     -12.563  34.926  29.494  1.00 24.39           C  
ATOM    937  CG  LEU A 118     -14.000  35.087  29.966  1.00 23.64           C  
ATOM    938  CD1 LEU A 118     -14.088  34.889  31.444  1.00 17.76           C  
ATOM    939  CD2 LEU A 118     -14.564  36.450  29.509  1.00 24.47           C  
ATOM    940  N   GLY A 119     -10.302  34.261  27.008  1.00 24.87           N  
ATOM    941  CA  GLY A 119      -8.911  34.480  26.569  1.00 25.13           C  
ATOM    942  C   GLY A 119      -7.813  33.802  27.389  1.00 25.43           C  
ATOM    943  O   GLY A 119      -6.622  34.023  27.138  1.00 25.34           O  
ATOM    944  N   PHE A 120      -8.202  32.985  28.369  1.00 25.35           N  
ATOM    945  CA  PHE A 120      -7.245  32.189  29.138  1.00 25.78           C  
ATOM    946  C   PHE A 120      -6.571  31.141  28.271  1.00 26.57           C  
ATOM    947  O   PHE A 120      -7.218  30.579  27.382  1.00 27.67           O  
ATOM    948  CB  PHE A 120      -7.940  31.463  30.290  1.00 25.16           C  
ATOM    949  CG  PHE A 120      -8.187  32.323  31.502  1.00 24.85           C  
ATOM    950  CD1 PHE A 120      -9.368  33.072  31.620  1.00 24.71           C  
ATOM    951  CD2 PHE A 120      -7.270  32.345  32.546  1.00 24.11           C  
ATOM    952  CE1 PHE A 120      -9.609  33.858  32.731  1.00 24.18           C  
ATOM    953  CE2 PHE A 120      -7.494  33.111  33.675  1.00 24.68           C  
ATOM    954  CZ  PHE A 120      -8.671  33.873  33.776  1.00 25.67           C  
ATOM    955  N   ASN A 121      -5.288  30.861  28.537  1.00 26.79           N  
ATOM    956  CA  ASN A 121      -4.578  29.724  27.923  1.00 26.28           C  
ATOM    957  C   ASN A 121      -4.024  28.777  28.963  1.00 25.86           C  
ATOM    958  O   ASN A 121      -3.636  29.207  30.051  1.00 26.39           O  
ATOM    959  CB  ASN A 121      -3.389  30.208  27.102  1.00 26.82           C  
ATOM    960  CG  ASN A 121      -3.776  31.214  26.036  1.00 27.60           C  
ATOM    961  OD1 ASN A 121      -4.582  30.923  25.155  1.00 28.22           O  
ATOM    962  ND2 ASN A 121      -3.187  32.405  26.106  1.00 28.28           N  
ATOM    963  N   GLU A 122      -3.968  27.493  28.632  1.00 24.82           N  
ATOM    964  CA  GLU A 122      -3.254  26.554  29.458  1.00 23.88           C  
ATOM    965  C   GLU A 122      -1.775  26.913  29.490  1.00 24.08           C  
ATOM    966  O   GLU A 122      -1.162  27.054  28.443  1.00 23.68           O  
ATOM    967  CB  GLU A 122      -3.377  25.188  28.866  1.00 23.59           C  
ATOM    968  CG  GLU A 122      -2.413  24.171  29.428  1.00 22.90           C  
ATOM    969  CD  GLU A 122      -2.746  22.812  28.910  1.00 24.37           C  
ATOM    970  OE1 GLU A 122      -3.951  22.597  28.671  1.00 25.80           O  
ATOM    971  OE2 GLU A 122      -1.835  21.976  28.698  1.00 25.61           O  
ATOM    972  N   ALA A 123      -1.211  27.066  30.686  1.00 24.16           N  
ATOM    973  CA  ALA A 123       0.225  27.265  30.830  1.00 24.29           C  
ATOM    974  C   ALA A 123       0.881  25.928  31.135  1.00 24.74           C  
ATOM    975  O   ALA A 123       1.807  25.509  30.463  1.00 25.21           O  
ATOM    976  CB  ALA A 123       0.522  28.273  31.936  1.00 23.64           C  
ATOM    977  N   THR A 124       0.388  25.244  32.151  1.00 24.60           N  
ATOM    978  CA  THR A 124       1.070  24.085  32.604  1.00 25.03           C  
ATOM    979  C   THR A 124       0.030  23.214  33.270  1.00 24.91           C  
ATOM    980  O   THR A 124      -1.056  23.688  33.584  1.00 26.11           O  
ATOM    981  CB  THR A 124       2.257  24.509  33.528  1.00 25.44           C  
ATOM    982  OG1 THR A 124       3.271  23.500  33.490  1.00 28.36           O  
ATOM    983  CG2 THR A 124       1.834  24.756  34.970  1.00 24.61           C  
ATOM    984  N   ILE A 125       0.326  21.941  33.447  1.00 24.50           N  
ATOM    985  CA  ILE A 125      -0.570  21.036  34.163  1.00 24.28           C  
ATOM    986  C   ILE A 125       0.095  20.528  35.429  1.00 24.59           C  
ATOM    987  O   ILE A 125       1.283  20.221  35.412  1.00 25.38           O  
ATOM    988  CB  ILE A 125      -0.944  19.859  33.269  1.00 24.32           C  
ATOM    989  CG1 ILE A 125      -2.196  20.250  32.499  1.00 24.99           C  
ATOM    990  CG2 ILE A 125      -1.189  18.578  34.078  1.00 21.46           C  
ATOM    991  CD1 ILE A 125      -2.156  19.810  31.101  1.00 25.77           C  
ATOM    992  N   ARG A 126      -0.652  20.455  36.523  1.00 24.66           N  
ATOM    993  CA  ARG A 126      -0.161  19.853  37.765  1.00 24.99           C  
ATOM    994  C   ARG A 126      -0.869  18.546  37.978  1.00 24.53           C  
ATOM    995  O   ARG A 126      -2.062  18.547  38.270  1.00 25.29           O  
ATOM    996  CB  ARG A 126      -0.515  20.756  38.933  1.00 25.34           C  
ATOM    997  CG  ARG A 126       0.508  21.784  39.203  1.00 29.24           C  
ATOM    998  CD  ARG A 126       1.473  21.321  40.302  1.00 36.79           C  
ATOM    999  NE  ARG A 126       1.238  22.083  41.527  1.00 39.66           N  
ATOM   1000  CZ  ARG A 126       1.266  23.412  41.583  1.00 42.30           C  
ATOM   1001  NH1 ARG A 126       1.509  24.137  40.486  1.00 41.50           N  
ATOM   1002  NH2 ARG A 126       1.039  24.025  42.739  1.00 44.57           N  
ATOM   1003  N   ARG A 127      -0.183  17.425  37.847  1.00 24.36           N  
ATOM   1004  CA  ARG A 127      -0.867  16.140  38.041  1.00 24.49           C  
ATOM   1005  C   ARG A 127      -1.265  15.936  39.480  1.00 25.15           C  
ATOM   1006  O   ARG A 127      -0.546  16.361  40.383  1.00 24.82           O  
ATOM   1007  CB  ARG A 127      -0.023  14.964  37.580  1.00 24.25           C  
ATOM   1008  CG  ARG A 127      -0.108  14.723  36.112  1.00 23.00           C  
ATOM   1009  CD  ARG A 127       1.195  14.282  35.626  1.00 23.39           C  
ATOM   1010  NE  ARG A 127       1.394  12.866  35.859  1.00 25.78           N  
ATOM   1011  CZ  ARG A 127       2.444  12.174  35.440  1.00 26.30           C  
ATOM   1012  NH1 ARG A 127       3.426  12.760  34.785  1.00 25.68           N  
ATOM   1013  NH2 ARG A 127       2.509  10.877  35.683  1.00 29.29           N  
ATOM   1014  N   ASN A 128      -2.432  15.315  39.664  1.00 25.98           N  
ATOM   1015  CA  ASN A 128      -2.953  14.901  40.964  1.00 26.96           C  
ATOM   1016  C   ASN A 128      -3.012  15.975  42.020  1.00 28.20           C  
ATOM   1017  O   ASN A 128      -2.808  15.721  43.204  1.00 28.70           O  
ATOM   1018  CB  ASN A 128      -2.175  13.727  41.473  1.00 26.57           C  
ATOM   1019  CG  ASN A 128      -2.258  12.585  40.539  1.00 27.45           C  
ATOM   1020  OD1 ASN A 128      -3.343  12.224  40.103  1.00 27.37           O  
ATOM   1021  ND2 ASN A 128      -1.111  12.036  40.166  1.00 28.78           N  
ATOM   1022  N   TYR A 129      -3.335  17.173  41.569  1.00 28.96           N  
ATOM   1023  CA  TYR A 129      -3.351  18.328  42.405  1.00 29.97           C  
ATOM   1024  C   TYR A 129      -4.607  18.416  43.262  1.00 30.22           C  
ATOM   1025  O   TYR A 129      -4.538  18.903  44.385  1.00 30.87           O  
ATOM   1026  CB  TYR A 129      -3.254  19.508  41.479  1.00 30.51           C  
ATOM   1027  CG  TYR A 129      -3.329  20.864  42.102  1.00 31.67           C  
ATOM   1028  CD1 TYR A 129      -2.196  21.445  42.688  1.00 31.79           C  
ATOM   1029  CD2 TYR A 129      -4.516  21.604  42.041  1.00 30.96           C  
ATOM   1030  CE1 TYR A 129      -2.250  22.733  43.225  1.00 32.63           C  
ATOM   1031  CE2 TYR A 129      -4.583  22.888  42.566  1.00 33.21           C  
ATOM   1032  CZ  TYR A 129      -3.445  23.455  43.157  1.00 32.82           C  
ATOM   1033  OH  TYR A 129      -3.508  24.738  43.684  1.00 33.03           O  
ATOM   1034  N   TYR A 130      -5.745  17.977  42.718  1.00 30.47           N  
ATOM   1035  CA  TYR A 130      -7.043  17.969  43.417  1.00 30.35           C  
ATOM   1036  C   TYR A 130      -7.462  16.566  43.935  1.00 30.65           C  
ATOM   1037  O   TYR A 130      -7.275  15.558  43.235  1.00 30.28           O  
ATOM   1038  CB  TYR A 130      -8.138  18.405  42.453  1.00 30.53           C  
ATOM   1039  CG  TYR A 130      -8.109  19.832  41.954  1.00 30.74           C  
ATOM   1040  CD1 TYR A 130      -8.639  20.870  42.726  1.00 29.97           C  
ATOM   1041  CD2 TYR A 130      -7.607  20.138  40.687  1.00 29.40           C  
ATOM   1042  CE1 TYR A 130      -8.648  22.165  42.271  1.00 29.24           C  
ATOM   1043  CE2 TYR A 130      -7.614  21.430  40.219  1.00 28.93           C  
ATOM   1044  CZ  TYR A 130      -8.135  22.438  41.015  1.00 30.99           C  
ATOM   1045  OH  TYR A 130      -8.142  23.733  40.562  1.00 32.13           O  
ATOM   1046  N   PRO A 131      -8.110  16.497  45.116  1.00 30.83           N  
ATOM   1047  CA  PRO A 131      -8.667  15.201  45.511  1.00 30.94           C  
ATOM   1048  C   PRO A 131      -9.980  14.961  44.781  1.00 30.97           C  
ATOM   1049  O   PRO A 131     -10.630  15.920  44.352  1.00 30.85           O  
ATOM   1050  CB  PRO A 131      -8.929  15.376  47.007  1.00 30.66           C  
ATOM   1051  CG  PRO A 131      -9.262  16.832  47.142  1.00 31.19           C  
ATOM   1052  CD  PRO A 131      -8.408  17.548  46.107  1.00 31.25           C  
ATOM   1053  N   THR A 132     -10.348  13.698  44.617  1.00 31.03           N  
ATOM   1054  CA  THR A 132     -11.688  13.353  44.153  1.00 31.81           C  
ATOM   1055  C   THR A 132     -12.335  12.348  45.115  1.00 32.22           C  
ATOM   1056  O   THR A 132     -11.694  11.868  46.060  1.00 31.88           O  
ATOM   1057  CB  THR A 132     -11.722  12.823  42.683  1.00 31.77           C  
ATOM   1058  OG1 THR A 132     -10.970  11.604  42.573  1.00 32.08           O  
ATOM   1059  CG2 THR A 132     -11.188  13.865  41.698  1.00 31.26           C  
ATOM   1060  N   ALA A 133     -13.608  12.040  44.893  1.00 32.59           N  
ATOM   1061  CA  ALA A 133     -14.259  11.052  45.745  1.00 33.20           C  
ATOM   1062  C   ALA A 133     -13.625   9.694  45.533  1.00 33.49           C  
ATOM   1063  O   ALA A 133     -13.875   8.791  46.301  1.00 33.89           O  
ATOM   1064  CB  ALA A 133     -15.762  10.989  45.482  1.00 32.93           C  
ATOM   1065  N   GLN A 134     -12.814   9.537  44.487  1.00 34.14           N  
ATOM   1066  CA  GLN A 134     -12.099   8.260  44.285  1.00 34.71           C  
ATOM   1067  C   GLN A 134     -10.602   8.320  43.854  1.00 34.34           C  
ATOM   1068  O   GLN A 134     -10.093   7.416  43.169  1.00 34.64           O  
ATOM   1069  CB  GLN A 134     -12.936   7.232  43.467  1.00 35.17           C  
ATOM   1070  CG  GLN A 134     -13.051   7.411  41.954  1.00 36.80           C  
ATOM   1071  CD  GLN A 134     -14.274   8.219  41.564  1.00 39.02           C  
ATOM   1072  OE1 GLN A 134     -14.231   9.457  41.557  1.00 39.99           O  
ATOM   1073  NE2 GLN A 134     -15.375   7.524  41.233  1.00 37.80           N  
ATOM   1074  N   GLY A 135      -9.905   9.375  44.285  1.00 33.60           N  
ATOM   1075  CA  GLY A 135      -8.481   9.543  43.995  1.00 32.07           C  
ATOM   1076  C   GLY A 135      -8.127  11.006  43.832  1.00 31.31           C  
ATOM   1077  O   GLY A 135      -8.402  11.831  44.710  1.00 31.24           O  
ATOM   1078  N   HIS A 136      -7.520  11.333  42.694  1.00 30.44           N  
ATOM   1079  CA  HIS A 136      -7.002  12.678  42.455  1.00 29.48           C  
ATOM   1080  C   HIS A 136      -7.354  13.124  41.072  1.00 28.57           C  
ATOM   1081  O   HIS A 136      -7.670  12.292  40.236  1.00 28.99           O  
ATOM   1082  CB  HIS A 136      -5.496  12.715  42.645  1.00 29.42           C  
ATOM   1083  CG  HIS A 136      -5.079  12.544  44.070  1.00 31.38           C  
ATOM   1084  ND1 HIS A 136      -5.148  13.572  44.994  1.00 32.75           N  
ATOM   1085  CD2 HIS A 136      -4.628  11.457  44.743  1.00 30.61           C  
ATOM   1086  CE1 HIS A 136      -4.734  13.130  46.168  1.00 33.16           C  
ATOM   1087  NE2 HIS A 136      -4.409  11.853  46.041  1.00 32.63           N  
ATOM   1088  N   GLU A 137      -7.329  14.431  40.837  1.00 27.09           N  
ATOM   1089  CA  GLU A 137      -7.552  14.967  39.506  1.00 25.82           C  
ATOM   1090  C   GLU A 137      -6.402  15.885  39.169  1.00 24.70           C  
ATOM   1091  O   GLU A 137      -5.840  16.522  40.057  1.00 24.50           O  
ATOM   1092  CB  GLU A 137      -8.830  15.786  39.487  1.00 26.02           C  
ATOM   1093  CG  GLU A 137      -9.609  15.633  38.256  1.00 26.95           C  
ATOM   1094  CD  GLU A 137     -10.841  16.521  38.237  1.00 29.61           C  
ATOM   1095  OE1 GLU A 137     -11.559  16.628  39.275  1.00 27.32           O  
ATOM   1096  OE2 GLU A 137     -11.079  17.104  37.147  1.00 31.25           O  
ATOM   1097  N   ASP A 138      -6.070  15.975  37.889  1.00 23.31           N  
ATOM   1098  CA  ASP A 138      -5.142  16.991  37.401  1.00 22.17           C  
ATOM   1099  C   ASP A 138      -5.684  18.414  37.496  1.00 21.91           C  
ATOM   1100  O   ASP A 138      -6.883  18.642  37.331  1.00 21.74           O  
ATOM   1101  CB  ASP A 138      -4.855  16.734  35.940  1.00 21.85           C  
ATOM   1102  CG  ASP A 138      -3.973  15.568  35.731  1.00 20.46           C  
ATOM   1103  OD1 ASP A 138      -3.529  14.919  36.707  1.00 17.41           O  
ATOM   1104  OD2 ASP A 138      -3.705  15.320  34.555  1.00 21.94           O  
ATOM   1105  N   ALA A 139      -4.776  19.358  37.716  1.00 21.19           N  
ATOM   1106  CA  ALA A 139      -5.069  20.781  37.664  1.00 20.79           C  
ATOM   1107  C   ALA A 139      -4.495  21.373  36.374  1.00 21.66           C  
ATOM   1108  O   ALA A 139      -3.340  21.098  36.014  1.00 22.32           O  
ATOM   1109  CB  ALA A 139      -4.448  21.449  38.832  1.00 19.66           C  
ATOM   1110  N   ILE A 140      -5.295  22.176  35.680  1.00 21.83           N  
ATOM   1111  CA  ILE A 140      -4.810  22.961  34.566  1.00 22.13           C  
ATOM   1112  C   ILE A 140      -4.520  24.352  35.086  1.00 22.53           C  
ATOM   1113  O   ILE A 140      -5.416  25.003  35.677  1.00 22.93           O  
ATOM   1114  CB  ILE A 140      -5.836  23.012  33.411  1.00 22.01           C  
ATOM   1115  CG1 ILE A 140      -6.015  21.609  32.809  1.00 23.38           C  
ATOM   1116  CG2 ILE A 140      -5.373  23.948  32.315  1.00 21.00           C  
ATOM   1117  CD1 ILE A 140      -7.186  21.486  31.840  1.00 23.82           C  
ATOM   1118  N   ILE A 141      -3.283  24.808  34.888  1.00 22.24           N  
ATOM   1119  CA  ILE A 141      -2.897  26.169  35.273  1.00 22.52           C  
ATOM   1120  C   ILE A 141      -3.030  27.071  34.056  1.00 22.67           C  
ATOM   1121  O   ILE A 141      -2.362  26.843  33.049  1.00 23.18           O  
ATOM   1122  CB  ILE A 141      -1.432  26.193  35.766  1.00 23.04           C  
ATOM   1123  CG1 ILE A 141      -1.190  25.103  36.833  1.00 22.71           C  
ATOM   1124  CG2 ILE A 141      -1.027  27.585  36.269  1.00 22.71           C  
ATOM   1125  CD1 ILE A 141      -2.060  25.173  38.033  1.00 19.04           C  
ATOM   1126  N   MET A 142      -3.890  28.081  34.135  1.00 22.84           N  
ATOM   1127  CA  MET A 142      -4.257  28.879  32.961  1.00 23.69           C  
ATOM   1128  C   MET A 142      -3.918  30.333  33.149  1.00 23.75           C  
ATOM   1129  O   MET A 142      -4.107  30.872  34.216  1.00 24.42           O  
ATOM   1130  CB  MET A 142      -5.754  28.780  32.674  1.00 23.52           C  
ATOM   1131  CG  MET A 142      -6.285  27.367  32.578  1.00 24.47           C  
ATOM   1132  SD  MET A 142      -7.946  27.227  31.852  1.00 24.61           S  
ATOM   1133  CE  MET A 142      -7.514  27.671  30.162  1.00 21.92           C  
ATOM   1134  N   ALA A 143      -3.424  30.983  32.111  1.00 24.07           N  
ATOM   1135  CA  ALA A 143      -3.012  32.395  32.240  1.00 24.14           C  
ATOM   1136  C   ALA A 143      -3.818  33.211  31.251  1.00 24.12           C  
ATOM   1137  O   ALA A 143      -3.946  32.825  30.091  1.00 24.90           O  
ATOM   1138  CB  ALA A 143      -1.536  32.540  31.954  1.00 22.65           C  
ATOM   1139  N   LEU A 144      -4.387  34.305  31.717  1.00 24.12           N  
ATOM   1140  CA  LEU A 144      -5.049  35.263  30.840  1.00 24.42           C  
ATOM   1141  C   LEU A 144      -4.188  36.519  30.745  1.00 24.56           C  
ATOM   1142  O   LEU A 144      -3.961  37.164  31.780  1.00 25.64           O  
ATOM   1143  CB  LEU A 144      -6.423  35.658  31.392  1.00 24.22           C  
ATOM   1144  CG  LEU A 144      -7.082  36.859  30.687  1.00 24.48           C  
ATOM   1145  CD1 LEU A 144      -7.435  36.542  29.232  1.00 23.61           C  
ATOM   1146  CD2 LEU A 144      -8.315  37.413  31.415  1.00 23.72           C  
ATOM   1147  N   PRO A 145      -3.681  36.852  29.532  1.00 24.03           N  
ATOM   1148  CA  PRO A 145      -3.044  38.176  29.355  1.00 23.83           C  
ATOM   1149  C   PRO A 145      -4.101  39.280  29.267  1.00 23.89           C  
ATOM   1150  O   PRO A 145      -5.074  39.139  28.529  1.00 23.66           O  
ATOM   1151  CB  PRO A 145      -2.312  38.052  28.003  1.00 23.03           C  
ATOM   1152  CG  PRO A 145      -3.024  36.973  27.275  1.00 22.27           C  
ATOM   1153  CD  PRO A 145      -3.627  36.042  28.292  1.00 23.55           C  
ATOM   1154  N   ILE A 146      -3.913  40.348  30.034  1.00 24.06           N  
ATOM   1155  CA  ILE A 146      -4.795  41.498  29.978  1.00 24.08           C  
ATOM   1156  C   ILE A 146      -4.068  42.642  29.282  1.00 24.38           C  
ATOM   1157  O   ILE A 146      -3.067  43.138  29.786  1.00 24.87           O  
ATOM   1158  CB  ILE A 146      -5.242  41.934  31.394  1.00 24.80           C  
ATOM   1159  CG1 ILE A 146      -5.710  40.699  32.205  1.00 24.73           C  
ATOM   1160  CG2 ILE A 146      -6.315  43.055  31.297  1.00 22.38           C  
ATOM   1161  CD1 ILE A 146      -5.992  40.950  33.672  1.00 23.66           C  
ATOM   1162  N   SER A 147      -4.559  43.027  28.108  1.00 24.21           N  
ATOM   1163  CA  SER A 147      -4.073  44.208  27.395  1.00 23.67           C  
ATOM   1164  C   SER A 147      -4.298  45.476  28.147  1.00 23.78           C  
ATOM   1165  O   SER A 147      -5.348  45.669  28.772  1.00 24.07           O  
ATOM   1166  CB  SER A 147      -4.758  44.343  26.056  1.00 22.79           C  
ATOM   1167  OG  SER A 147      -4.230  43.350  25.223  1.00 24.39           O  
ATOM   1168  N   MET A 148      -3.299  46.341  28.067  1.00 23.90           N  
ATOM   1169  CA  MET A 148      -3.361  47.634  28.674  1.00 25.09           C  
ATOM   1170  C   MET A 148      -4.194  48.576  27.814  1.00 25.49           C  
ATOM   1171  O   MET A 148      -4.082  48.563  26.581  1.00 25.57           O  
ATOM   1172  CB  MET A 148      -1.947  48.180  28.825  1.00 25.19           C  
ATOM   1173  CG  MET A 148      -1.134  47.513  29.886  1.00 24.63           C  
ATOM   1174  SD  MET A 148       0.582  48.087  29.818  1.00 26.05           S  
ATOM   1175  CE  MET A 148       1.114  47.749  31.502  1.00 25.26           C  
ATOM   1176  N   LYS A 149      -5.020  49.396  28.466  1.00 26.12           N  
ATOM   1177  CA  LYS A 149      -5.901  50.353  27.765  1.00 26.70           C  
ATOM   1178  C   LYS A 149      -5.469  51.781  28.052  1.00 27.02           C  
ATOM   1179  O   LYS A 149      -4.647  52.006  28.952  1.00 27.17           O  
ATOM   1180  CB  LYS A 149      -7.344  50.150  28.230  1.00 26.55           C  
ATOM   1181  CG  LYS A 149      -7.960  48.849  27.705  1.00 28.36           C  
ATOM   1182  CD  LYS A 149      -9.157  48.341  28.504  1.00 32.36           C  
ATOM   1183  CE  LYS A 149     -10.067  47.490  27.591  1.00 36.79           C  
ATOM   1184  NZ  LYS A 149     -11.450  47.258  28.133  1.00 38.57           N  
ATOM   1185  N   LEU A 150      -5.999  52.744  27.293  1.00 27.74           N  
ATOM   1186  CA  LEU A 150      -5.871  54.159  27.645  1.00 28.12           C  
ATOM   1187  C   LEU A 150      -6.807  54.455  28.801  1.00 29.15           C  
ATOM   1188  O   LEU A 150      -7.874  53.846  28.888  1.00 29.68           O  
ATOM   1189  CB  LEU A 150      -6.217  55.047  26.467  1.00 27.96           C  
ATOM   1190  CG  LEU A 150      -5.157  55.146  25.371  1.00 27.76           C  
ATOM   1191  CD1 LEU A 150      -5.749  55.899  24.210  1.00 27.61           C  
ATOM   1192  CD2 LEU A 150      -3.903  55.835  25.838  1.00 26.47           C  
ATOM   1193  N   HIS A 151      -6.425  55.367  29.697  1.00 29.83           N  
ATOM   1194  CA  HIS A 151      -7.239  55.606  30.899  1.00 31.39           C  
ATOM   1195  C   HIS A 151      -7.896  56.992  31.017  1.00 31.25           C  
ATOM   1196  O   HIS A 151      -7.651  57.888  30.210  1.00 32.04           O  
ATOM   1197  CB  HIS A 151      -6.436  55.305  32.172  1.00 31.63           C  
ATOM   1198  CG  HIS A 151      -6.106  53.857  32.363  1.00 34.83           C  
ATOM   1199  ND1 HIS A 151      -5.030  53.435  33.116  1.00 36.69           N  
ATOM   1200  CD2 HIS A 151      -6.706  52.732  31.895  1.00 37.58           C  
ATOM   1201  CE1 HIS A 151      -4.989  52.112  33.115  1.00 37.76           C  
ATOM   1202  NE2 HIS A 151      -5.988  51.661  32.372  1.00 37.27           N  
TER    1203      HIS A 151                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
