
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  163 ( 1330),  selected  163 , name 1z4r_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1z4r_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S   496_A      -       -           -
LGA    G   497_A      -       -           -
LGA    I   498_A      A       2          3.108
LGA    I   499_A      I       3          2.053
LGA    E   500_A      N       4          1.875
LGA    F   501_A      I       5          1.472
LGA    H   502_A      I       6          1.790
LGA    V   503_A      E       7          2.403
LGA    I   504_A      Y       8          2.593
LGA    G   505_A      -       -           -
LGA    N   506_A      -       -           -
LGA    S   507_A      -       -           -
LGA    L   508_A      -       -           -
LGA    T   509_A      -       -           -
LGA    P   510_A      -       -           -
LGA    K   511_A      -       -           -
LGA    A   512_A      -       -           -
LGA    N   513_A      -       -           -
LGA    R   514_A      -       -           -
LGA    R   515_A      -       -           -
LGA    V   516_A      N       9          2.230
LGA    L   517_A      R      10          2.133
LGA    L   518_A      S      11          2.463
LGA    W   519_A      Y      12          1.861
LGA    L   520_A      K      13          2.738
LGA    V   521_A      E      14          2.208
LGA    G   522_A      E      15          1.944
LGA    L   523_A      L      16          1.728
LGA    Q   524_A      I      17          1.318
LGA    N   525_A      E      18          1.472
LGA    V   526_A      F      19          1.261
LGA    F   527_A      I      20          0.913
LGA    S   528_A      L      21          0.860
LGA    H   529_A      S      22          1.223
LGA    Q   530_A      I      23          1.295
LGA    L   531_A      Q      24          1.336
LGA    P   532_A      K      25          1.323
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    -       -      N      29           -
LGA    R   533_A      I      30          1.813
LGA    -       -      K      31           -
LGA    M   534_A      I      32          2.426
LGA    P   535_A      D      33          0.657
LGA    K   536_A      R      34          2.317
LGA    E   537_A      D      35          3.044
LGA    Y   538_A      D      36          2.961
LGA    I   539_A      Q      37          3.469
LGA    A   540_A      -       -           -
LGA    R   541_A      P      38          1.913
LGA    L   542_A      D      39          1.247
LGA    V   543_A      L      40          1.896
LGA    F   544_A      E      41          2.911
LGA    D   545_A      N      42          3.271
LGA    -       -      I      43           -
LGA    -       -      E      44           -
LGA    P   546_A      H      45          0.776
LGA    K   547_A      N      46          2.160
LGA    H   548_A      Y      47          1.854
LGA    K   549_A      L      48          4.069
LGA    -       -      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    -       -      Q      53           -
LGA    T   550_A      F      54          1.628
LGA    L   551_A      W      55          1.222
LGA    A   552_A      L      56          1.010
LGA    L   553_A      A      57          0.918
LGA    I   554_A      I      58          1.440
LGA    K   555_A      N      59          1.640
LGA    D   556_A      N      60          2.167
LGA    -       -      H      61           -
LGA    G   557_A      Q      62          1.453
LGA    R   558_A      N      63          1.186
LGA    V   559_A      I      64          1.076
LGA    I   560_A      V      65          0.897
LGA    G   561_A      G      66          0.741
LGA    G   562_A      T      67          0.603
LGA    I   563_A      I      68          0.846
LGA    C   564_A      G      69          2.260
LGA    F   565_A      L      70          2.318
LGA    R   566_A      I      71          1.108
LGA    M   567_A      R      72          1.490
LGA    F   568_A      L      73          2.374
LGA    P   569_A      -       -           -
LGA    T   570_A      D      74          3.799
LGA    Q   571_A      N      75          1.902
LGA    G   572_A      N      76          1.041
LGA    F   573_A      M      77          1.214
LGA    T   574_A      S      78          1.239
LGA    E   575_A      A      79          1.039
LGA    I   576_A      L      80          1.385
LGA    V   577_A      K      81          2.153
LGA    F   578_A      K      82          1.213
LGA    C   579_A      M      83          0.885
LGA    A   580_A      F      84          0.205
LGA    V   581_A      V      85          0.779
LGA    T   582_A      D      86          1.123
LGA    S   583_A      K      87          0.995
LGA    N   584_A      G      88          0.771
LGA    E   585_A      Y      89          0.845
LGA    Q   586_A      R      90          1.143
LGA    V   587_A      N      91          2.269
LGA    K   588_A      L      92          1.860
LGA    G   589_A      K      93          1.094
LGA    Y   590_A      I      94          0.652
LGA    G   591_A      G      95          1.020
LGA    T   592_A      K      96          1.444
LGA    H   593_A      K      97          1.312
LGA    L   594_A      L      98          0.787
LGA    M   595_A      L      99          0.717
LGA    N   596_A      D     100          1.183
LGA    H   597_A      K     101          1.189
LGA    L   598_A      V     102          0.875
LGA    K   599_A      I     103          0.543
LGA    E   600_A      M     104          0.583
LGA    Y   601_A      T     105          0.851
LGA    H   602_A      C     106          0.727
LGA    I   603_A      K     107          0.715
LGA    K   604_A      E     108          0.810
LGA    H   605_A      Q     109          0.774
LGA    N   606_A      N     110          0.819
LGA    I   607_A      I     111          0.627
LGA    L   608_A      D     112          2.444
LGA    Y   609_A      G     113          0.826
LGA    F   610_A      I     114          0.805
LGA    L   611_A      Y     115          0.844
LGA    T   612_A      L     116          0.995
LGA    Y   613_A      G     117          0.802
LGA    A   614_A      T     118          1.446
LGA    D   615_A      I     119          0.548
LGA    E   616_A      D     120          1.181
LGA    Y   617_A      K     121          3.542
LGA    A   618_A      F     122          3.395
LGA    -       -      I     123           -
LGA    -       -      S     124           -
LGA    -       -      A     125           -
LGA    I   619_A      Q     126          1.995
LGA    G   620_A      Y     127          1.736
LGA    Y   621_A      F     128          1.906
LGA    F   622_A      Y     129          1.271
LGA    K   623_A      S     130          0.898
LGA    K   624_A      N     131          1.513
LGA    Q   625_A      N     132          1.641
LGA    G   626_A      G     133          1.164
LGA    F   627_A      F     134          0.856
LGA    S   628_A      R     135          0.996
LGA    K   629_A      E     136          1.448
LGA    D   630_A      I     137          3.613
LGA    -       -      K     138           -
LGA    -       -      R     139           -
LGA    -       -      G     140           -
LGA    I   631_A      D     141          5.141
LGA    K   632_A      -       -           -
LGA    V   633_A      -       -           -
LGA    P   634_A      -       -           -
LGA    K   635_A      L     142          4.949
LGA    S   636_A      -       -           -
LGA    R   637_A      -       -           -
LGA    Y   638_A      P     143          1.967
LGA    L   639_A      S     144          1.051
LGA    G   640_A      -       -           -
LGA    Y   641_A      S     145          1.466
LGA    I   642_A      F     146          1.530
LGA    K   643_A      P     147          2.043
LGA    D   644_A      K     148          2.041
LGA    Y   645_A      L     149          2.797
LGA    E   646_A      D     150          3.117
LGA    G   647_A      V     151          5.234
LGA    -       -      D     152           -
LGA    A   648_A      N     153          1.247
LGA    T   649_A      R     154          1.606
LGA    L   650_A      F     155          1.940
LGA    M   651_A      Y     156          1.097
LGA    E   652_A      Y     157          0.737
LGA    C   653_A      R     158          0.978
LGA    E   654_A      N     159          0.948
LGA    L   655_A      L     160          1.862
LGA    N   656_A      K     161          5.082
LGA    P   657_A      -       -           -
LGA    R   658_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  163  160    5.0    140    1.92     9.29     78.010     6.919

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.115184 * X  +   0.993270 * Y  +  -0.012178 * Z  + -23.392025
  Y_new =  -0.748862 * X  +   0.094883 * Y  +   0.655899 * Z  +  31.079134
  Z_new =   0.652640 * X  +  -0.066430 * Y  +   0.754751 * Z  +  40.347172 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.087789    3.053803  [ DEG:    -5.0299    174.9700 ]
  Theta =  -0.711063   -2.430529  [ DEG:   -40.7409   -139.2591 ]
  Phi   =  -1.418180    1.723413  [ DEG:   -81.2557     98.7443 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z4r_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z4r_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  163  160   5.0  140   1.92    9.29  78.010
REMARK  ---------------------------------------------------------- 
MOLECULE 1z4r_A
HEADER    TRANSFERASE                             16-MAR-05   1Z4R              
TITLE     HUMAN GCN5 ACETYLTRANSFERASE                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GENERAL CONTROL OF AMINO ACID SYNTHESIS PROTEIN            
COMPND   3 5-LIKE 2;                                                            
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: RESIDUES 497-662;                                          
COMPND   6 SYNONYM: HISTONE ACETYLTRANSFERASE GCN5, HSGCN5, STAF97;             
COMPND   7 EC: 2.3.1.48;                                                        
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENUS: HOMO SAPIENS;                                                 
SOURCE   5 GENE: GCN5;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    GCN5, ACETYLTRANSFERASE, SGC, STRUCTURAL GENOMICS,                    
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.DONG,G.BERNSTEIN,A.SCHUETZ,T.ANTOSHENKO,H.WU,P.LOPPNAU,             
AUTHOR   2 M.SUNDSTROM,C.ARROWSMITH,A.EDWARDS,A.BOCHKAREV,A.PLOTNIKOV,          
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   3   20-MAY-08 1Z4R    1       JRNL   VERSN                             
REVDAT   2   05-APR-05 1Z4R    1       AUTHOR                                   
REVDAT   1   29-MAR-05 1Z4R    0                                                
JRNL        AUTH   A.SCHUETZ,G.BERNSTEIN,A.DONG,T.ANTOSHENKO,H.WU,              
JRNL        AUTH 2 P.LOPPNAU,A.BOCHKAREV,A.N.PLOTNIKOV                          
JRNL        TITL   CRYSTAL STRUCTURE OF A BINARY COMPLEX BETWEEN                
JRNL        TITL 2 HUMAN GCN5 HISTONE ACETYLTRANSFERASE DOMAIN AND              
JRNL        TITL 3 ACETYL COENZYME A                                            
JRNL        REF    PROTEINS                      V.  68   403 2007              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 1.74 ANGSTROMS.                                          
DBREF  1Z4R A  497   662  UNP    Q92830   GCNL2_HUMAN    497    662             
SEQRES   1 A  168  GLY SER GLY ILE ILE GLU PHE HIS VAL ILE GLY ASN SER          
SEQRES   2 A  168  LEU THR PRO LYS ALA ASN ARG ARG VAL LEU LEU TRP LEU          
SEQRES   3 A  168  VAL GLY LEU GLN ASN VAL PHE SER HIS GLN LEU PRO ARG          
SEQRES   4 A  168  MET PRO LYS GLU TYR ILE ALA ARG LEU VAL PHE ASP PRO          
SEQRES   5 A  168  LYS HIS LYS THR LEU ALA LEU ILE LYS ASP GLY ARG VAL          
SEQRES   6 A  168  ILE GLY GLY ILE CYS PHE ARG MET PHE PRO THR GLN GLY          
SEQRES   7 A  168  PHE THR GLU ILE VAL PHE CYS ALA VAL THR SER ASN GLU          
SEQRES   8 A  168  GLN VAL LYS GLY TYR GLY THR HIS LEU MET ASN HIS LEU          
SEQRES   9 A  168  LYS GLU TYR HIS ILE LYS HIS ASN ILE LEU TYR PHE LEU          
SEQRES  10 A  168  THR TYR ALA ASP GLU TYR ALA ILE GLY TYR PHE LYS LYS          
SEQRES  11 A  168  GLN GLY PHE SER LYS ASP ILE LYS VAL PRO LYS SER ARG          
SEQRES  12 A  168  TYR LEU GLY TYR ILE LYS ASP TYR GLU GLY ALA THR LEU          
SEQRES  13 A  168  MET GLU CYS GLU LEU ASN PRO ARG ILE PRO TYR THR              
HET    ACO  A 401      51                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   2  ACO    C23 H38 N7 O17 P3 S                                          
FORMUL   3  HOH   *131(H2 O)                                                    
CRYST1   38.090   38.090  186.340  90.00  90.00 120.00 P 61          6          
ATOM      1  N   SER A 496     -32.433  49.277  45.053  1.00 41.84           N  
ATOM      2  CA  SER A 496     -31.646  48.271  44.291  1.00 38.90           C  
ATOM      3  C   SER A 496     -32.529  47.546  43.278  1.00 37.07           C  
ATOM      4  O   SER A 496     -32.945  48.130  42.279  1.00 35.97           O  
ATOM      5  CB  SER A 496     -31.016  47.260  45.257  1.00 41.35           C  
ATOM      6  OG  SER A 496     -32.007  46.567  46.002  1.00 42.76           O  
ATOM      7  N   GLY A 497     -32.810  46.273  43.541  1.00 34.84           N  
ATOM      8  CA  GLY A 497     -33.640  45.493  42.641  1.00 32.41           C  
ATOM      9  C   GLY A 497     -32.868  44.968  41.445  1.00 31.17           C  
ATOM     10  O   GLY A 497     -33.421  44.262  40.599  1.00 31.22           O  
ATOM     11  N   ILE A 498     -31.587  45.316  41.374  1.00 28.18           N  
ATOM     12  CA  ILE A 498     -30.729  44.884  40.273  1.00 27.08           C  
ATOM     13  C   ILE A 498     -29.425  44.324  40.826  1.00 25.98           C  
ATOM     14  O   ILE A 498     -29.102  44.534  41.996  1.00 24.74           O  
ATOM     15  CB  ILE A 498     -30.386  46.061  39.345  1.00 27.55           C  
ATOM     16  CG1 ILE A 498     -29.564  47.097  40.113  1.00 30.31           C  
ATOM     17  CG2 ILE A 498     -31.666  46.697  38.814  1.00 28.21           C  
ATOM     18  CD1 ILE A 498     -29.018  48.218  39.251  1.00 32.46           C  
ATOM     19  N   ILE A 499     -28.675  43.615  39.986  1.00 23.76           N  
ATOM     20  CA  ILE A 499     -27.402  43.055  40.421  1.00 22.73           C  
ATOM     21  C   ILE A 499     -26.389  44.169  40.636  1.00 21.45           C  
ATOM     22  O   ILE A 499     -26.412  45.197  39.953  1.00 22.58           O  
ATOM     23  CB  ILE A 499     -26.817  42.075  39.386  1.00 22.46           C  
ATOM     24  CG1 ILE A 499     -26.608  42.798  38.050  1.00 23.46           C  
ATOM     25  CG2 ILE A 499     -27.741  40.871  39.238  1.00 21.61           C  
ATOM     26  CD1 ILE A 499     -25.746  42.041  37.061  1.00 23.86           C  
ATOM     27  N   GLU A 500     -25.497  43.959  41.594  1.00 19.52           N  
ATOM     28  CA  GLU A 500     -24.472  44.936  41.899  1.00 17.68           C  
ATOM     29  C   GLU A 500     -23.163  44.199  42.115  1.00 17.70           C  
ATOM     30  O   GLU A 500     -23.157  43.064  42.587  1.00 18.05           O  
ATOM     31  CB  GLU A 500     -24.822  45.707  43.174  1.00 19.14           C  
ATOM     32  CG  GLU A 500     -26.232  46.278  43.218  1.00 22.18           C  
ATOM     33  CD  GLU A 500     -26.475  47.104  44.470  1.00 24.59           C  
ATOM     34  OE1 GLU A 500     -25.851  46.801  45.511  1.00 23.69           O  
ATOM     35  OE2 GLU A 500     -27.300  48.045  44.420  1.00 24.93           O  
ATOM     36  N   PHE A 501     -22.066  44.854  41.758  1.00 17.36           N  
ATOM     37  CA  PHE A 501     -20.733  44.293  41.923  1.00 16.99           C  
ATOM     38  C   PHE A 501     -20.075  45.047  43.063  1.00 16.87           C  
ATOM     39  O   PHE A 501     -20.093  46.277  43.086  1.00 16.99           O  
ATOM     40  CB  PHE A 501     -19.904  44.482  40.649  1.00 15.97           C  
ATOM     41  CG  PHE A 501     -20.285  43.554  39.532  1.00 18.22           C  
ATOM     42  CD1 PHE A 501     -19.953  42.202  39.591  1.00 18.24           C  
ATOM     43  CD2 PHE A 501     -20.980  44.027  38.423  1.00 18.49           C  
ATOM     44  CE1 PHE A 501     -20.307  41.335  38.560  1.00 21.36           C  
ATOM     45  CE2 PHE A 501     -21.341  43.170  37.388  1.00 23.18           C  
ATOM     46  CZ  PHE A 501     -21.003  41.817  37.458  1.00 21.76           C  
ATOM     47  N   HIS A 502     -19.510  44.308  44.010  1.00 16.93           N  
ATOM     48  CA  HIS A 502     -18.830  44.910  45.149  1.00 16.37           C  
ATOM     49  C   HIS A 502     -17.534  44.172  45.410  1.00 16.87           C  
ATOM     50  O   HIS A 502     -17.530  42.948  45.503  1.00 17.77           O  
ATOM     51  CB  HIS A 502     -19.671  44.816  46.426  1.00 16.42           C  
ATOM     52  CG  HIS A 502     -20.918  45.643  46.406  1.00 19.94           C  
ATOM     53  ND1 HIS A 502     -22.086  45.217  45.811  1.00 21.66           N  
ATOM     54  CD2 HIS A 502     -21.191  46.852  46.947  1.00 19.52           C  
ATOM     55  CE1 HIS A 502     -23.026  46.127  45.993  1.00 18.54           C  
ATOM     56  NE2 HIS A 502     -22.510  47.129  46.679  1.00 23.57           N  
ATOM     57  N   VAL A 503     -16.434  44.910  45.504  1.00 18.11           N  
ATOM     58  CA  VAL A 503     -15.155  44.294  45.820  1.00 16.94           C  
ATOM     59  C   VAL A 503     -15.078  44.423  47.331  1.00 15.76           C  
ATOM     60  O   VAL A 503     -15.024  45.534  47.866  1.00 15.99           O  
ATOM     61  CB  VAL A 503     -13.975  45.041  45.162  1.00 18.14           C  
ATOM     62  CG1 VAL A 503     -12.662  44.493  45.689  1.00 18.57           C  
ATOM     63  CG2 VAL A 503     -14.033  44.859  43.646  1.00 17.96           C  
ATOM     64  N   ILE A 504     -15.118  43.289  48.023  1.00 16.11           N  
ATOM     65  CA  ILE A 504     -15.080  43.303  49.479  1.00 15.53           C  
ATOM     66  C   ILE A 504     -14.037  42.366  50.075  1.00 16.44           C  
ATOM     67  O   ILE A 504     -13.273  41.722  49.356  1.00 15.84           O  
ATOM     68  CB  ILE A 504     -16.469  42.951  50.064  1.00 15.44           C  
ATOM     69  CG1 ILE A 504     -16.932  41.582  49.549  1.00 16.22           C  
ATOM     70  CG2 ILE A 504     -17.478  44.014  49.658  1.00 16.42           C  
ATOM     71  CD1 ILE A 504     -18.252  41.104  50.157  1.00 15.15           C  
ATOM     72  N   GLY A 505     -14.004  42.314  51.403  1.00 16.13           N  
ATOM     73  CA  GLY A 505     -13.061  41.462  52.098  1.00 16.78           C  
ATOM     74  C   GLY A 505     -12.888  41.920  53.533  1.00 18.66           C  
ATOM     75  O   GLY A 505     -13.632  42.778  54.012  1.00 16.25           O  
ATOM     76  N   ASN A 506     -11.916  41.335  54.222  1.00 19.56           N  
ATOM     77  CA  ASN A 506     -11.618  41.693  55.605  1.00 21.23           C  
ATOM     78  C   ASN A 506     -10.310  42.480  55.611  1.00 22.98           C  
ATOM     79  O   ASN A 506      -9.259  41.932  55.295  1.00 23.89           O  
ATOM     80  CB  ASN A 506     -11.478  40.424  56.453  1.00 21.62           C  
ATOM     81  CG  ASN A 506     -10.804  40.685  57.787  1.00 23.23           C  
ATOM     82  OD1 ASN A 506     -11.029  41.718  58.416  1.00 25.47           O  
ATOM     83  ND2 ASN A 506      -9.983  39.740  58.231  1.00 25.73           N  
ATOM     84  N   SER A 507     -10.375  43.762  55.958  1.00 23.30           N  
ATOM     85  CA  SER A 507      -9.177  44.603  55.975  1.00 24.34           C  
ATOM     86  C   SER A 507      -8.324  44.396  57.224  1.00 24.58           C  
ATOM     87  O   SER A 507      -7.112  44.616  57.197  1.00 25.41           O  
ATOM     88  CB  SER A 507      -9.565  46.081  55.848  1.00 22.95           C  
ATOM     89  OG  SER A 507     -10.369  46.497  56.934  1.00 26.16           O  
ATOM     90  N   LEU A 508      -8.963  43.982  58.315  1.00 24.20           N  
ATOM     91  CA  LEU A 508      -8.267  43.726  59.578  1.00 24.62           C  
ATOM     92  C   LEU A 508      -9.115  42.775  60.414  1.00 24.43           C  
ATOM     93  O   LEU A 508      -8.662  41.695  60.812  1.00 23.21           O  
ATOM     94  CB  LEU A 508      -8.049  45.024  60.349  1.00 23.61           C  
ATOM     95  CG  LEU A 508      -7.300  44.847  61.673  1.00 24.59           C  
ATOM     96  CD1 LEU A 508      -5.928  44.236  61.408  1.00 25.49           C  
ATOM     97  CD2 LEU A 508      -7.163  46.187  62.363  1.00 25.40           C  
ATOM     98  N   THR A 509     -10.341  43.210  60.689  1.00 22.66           N  
ATOM     99  CA  THR A 509     -11.313  42.422  61.433  1.00 22.87           C  
ATOM    100  C   THR A 509     -12.644  42.562  60.704  1.00 23.61           C  
ATOM    101  O   THR A 509     -13.034  43.661  60.299  1.00 22.44           O  
ATOM    102  CB  THR A 509     -11.498  42.904  62.884  1.00 23.57           C  
ATOM    103  OG1 THR A 509     -12.647  42.253  63.442  1.00 22.04           O  
ATOM    104  CG2 THR A 509     -11.700  44.413  62.937  1.00 19.67           C  
ATOM    105  N   PRO A 510     -13.359  41.448  60.524  1.00 23.00           N  
ATOM    106  CA  PRO A 510     -14.643  41.494  59.826  1.00 24.12           C  
ATOM    107  C   PRO A 510     -15.832  41.986  60.651  1.00 23.08           C  
ATOM    108  O   PRO A 510     -16.942  42.070  60.136  1.00 24.48           O  
ATOM    109  CB  PRO A 510     -14.818  40.052  59.358  1.00 23.34           C  
ATOM    110  CG  PRO A 510     -14.242  39.281  60.501  1.00 24.39           C  
ATOM    111  CD  PRO A 510     -12.976  40.058  60.835  1.00 23.51           C  
ATOM    112  N   LYS A 511     -15.611  42.333  61.915  1.00 23.11           N  
ATOM    113  CA  LYS A 511     -16.722  42.781  62.750  1.00 23.89           C  
ATOM    114  C   LYS A 511     -17.135  44.238  62.552  1.00 23.49           C  
ATOM    115  O   LYS A 511     -18.245  44.622  62.916  1.00 26.34           O  
ATOM    116  CB  LYS A 511     -16.406  42.546  64.236  1.00 25.85           C  
ATOM    117  CG  LYS A 511     -15.394  43.511  64.839  1.00 27.03           C  
ATOM    118  CD  LYS A 511     -15.269  43.293  66.346  1.00 28.82           C  
ATOM    119  CE  LYS A 511     -14.434  44.382  67.004  1.00 28.80           C  
ATOM    120  NZ  LYS A 511     -14.378  44.231  68.491  1.00 29.99           N  
ATOM    121  N   ALA A 512     -16.256  45.040  61.959  1.00 20.58           N  
ATOM    122  CA  ALA A 512     -16.519  46.462  61.751  1.00 19.85           C  
ATOM    123  C   ALA A 512     -17.708  46.788  60.845  1.00 19.20           C  
ATOM    124  O   ALA A 512     -18.505  47.672  61.157  1.00 17.88           O  
ATOM    125  CB  ALA A 512     -15.270  47.137  61.222  1.00 21.82           C  
ATOM    126  N   ASN A 513     -17.824  46.080  59.727  1.00 17.37           N  
ATOM    127  CA  ASN A 513     -18.919  46.314  58.787  1.00 17.42           C  
ATOM    128  C   ASN A 513     -19.746  45.030  58.688  1.00 17.88           C  
ATOM    129  O   ASN A 513     -19.347  44.077  58.024  1.00 15.96           O  
ATOM    130  CB  ASN A 513     -18.354  46.691  57.413  1.00 18.82           C  
ATOM    131  CG  ASN A 513     -19.436  47.070  56.418  1.00 18.43           C  
ATOM    132  OD1 ASN A 513     -20.511  46.477  56.402  1.00 20.11           O  
ATOM    133  ND2 ASN A 513     -19.147  48.052  55.567  1.00 17.93           N  
ATOM    134  N   ARG A 514     -20.902  45.018  59.348  1.00 17.31           N  
ATOM    135  CA  ARG A 514     -21.759  43.836  59.377  1.00 19.51           C  
ATOM    136  C   ARG A 514     -22.362  43.469  58.026  1.00 17.32           C  
ATOM    137  O   ARG A 514     -22.586  42.292  57.743  1.00 17.76           O  
ATOM    138  CB  ARG A 514     -22.870  44.023  60.415  1.00 20.01           C  
ATOM    139  CG  ARG A 514     -22.370  44.540  61.758  1.00 24.70           C  
ATOM    140  CD  ARG A 514     -21.298  43.641  62.377  1.00 26.51           C  
ATOM    141  NE  ARG A 514     -21.818  42.327  62.745  1.00 29.86           N  
ATOM    142  CZ  ARG A 514     -21.162  41.447  63.496  1.00 30.77           C  
ATOM    143  NH1 ARG A 514     -19.957  41.740  63.967  1.00 29.62           N  
ATOM    144  NH2 ARG A 514     -21.710  40.272  63.776  1.00 29.18           N  
ATOM    145  N   ARG A 515     -22.632  44.471  57.197  1.00 18.18           N  
ATOM    146  CA  ARG A 515     -23.188  44.210  55.873  1.00 18.94           C  
ATOM    147  C   ARG A 515     -22.175  43.390  55.084  1.00 17.70           C  
ATOM    148  O   ARG A 515     -22.524  42.385  54.462  1.00 18.16           O  
ATOM    149  CB  ARG A 515     -23.475  45.523  55.146  1.00 18.59           C  
ATOM    150  CG  ARG A 515     -24.036  45.369  53.735  1.00 22.89           C  
ATOM    151  CD  ARG A 515     -25.384  44.653  53.712  1.00 24.96           C  
ATOM    152  NE  ARG A 515     -25.249  43.211  53.887  1.00 29.21           N  
ATOM    153  CZ  ARG A 515     -26.263  42.353  53.810  1.00 30.36           C  
ATOM    154  NH1 ARG A 515     -27.487  42.793  53.562  1.00 32.59           N  
ATOM    155  NH2 ARG A 515     -26.052  41.055  53.973  1.00 32.28           N  
ATOM    156  N   VAL A 516     -20.916  43.822  55.123  1.00 16.64           N  
ATOM    157  CA  VAL A 516     -19.843  43.131  54.424  1.00 15.42           C  
ATOM    158  C   VAL A 516     -19.592  41.755  55.042  1.00 16.47           C  
ATOM    159  O   VAL A 516     -19.326  40.788  54.328  1.00 15.12           O  
ATOM    160  CB  VAL A 516     -18.545  43.976  54.440  1.00 14.49           C  
ATOM    161  CG1 VAL A 516     -17.364  43.155  53.933  1.00 16.12           C  
ATOM    162  CG2 VAL A 516     -18.733  45.209  53.562  1.00 15.29           C  
ATOM    163  N   LEU A 517     -19.676  41.667  56.367  1.00 16.12           N  
ATOM    164  CA  LEU A 517     -19.484  40.394  57.048  1.00 17.36           C  
ATOM    165  C   LEU A 517     -20.543  39.404  56.558  1.00 16.45           C  
ATOM    166  O   LEU A 517     -20.235  38.250  56.256  1.00 17.37           O  
ATOM    167  CB  LEU A 517     -19.603  40.578  58.566  1.00 19.22           C  
ATOM    168  CG  LEU A 517     -19.560  39.320  59.445  1.00 22.36           C  
ATOM    169  CD1 LEU A 517     -18.308  38.508  59.163  1.00 24.20           C  
ATOM    170  CD2 LEU A 517     -19.601  39.739  60.912  1.00 22.86           C  
ATOM    171  N   LEU A 518     -21.787  39.862  56.465  1.00 15.93           N  
ATOM    172  CA  LEU A 518     -22.874  39.003  56.008  1.00 16.46           C  
ATOM    173  C   LEU A 518     -22.626  38.530  54.582  1.00 15.45           C  
ATOM    174  O   LEU A 518     -22.928  37.386  54.231  1.00 15.16           O  
ATOM    175  CB  LEU A 518     -24.209  39.744  56.085  1.00 18.62           C  
ATOM    176  CG  LEU A 518     -24.751  40.001  57.494  1.00 21.79           C  
ATOM    177  CD1 LEU A 518     -26.041  40.797  57.395  1.00 19.36           C  
ATOM    178  CD2 LEU A 518     -24.986  38.674  58.209  1.00 20.40           C  
ATOM    179  N   TRP A 519     -22.078  39.412  53.757  1.00 15.57           N  
ATOM    180  CA  TRP A 519     -21.782  39.051  52.377  1.00 15.70           C  
ATOM    181  C   TRP A 519     -20.613  38.068  52.316  1.00 16.47           C  
ATOM    182  O   TRP A 519     -20.610  37.152  51.491  1.00 15.00           O  
ATOM    183  CB  TRP A 519     -21.474  40.302  51.555  1.00 14.68           C  
ATOM    184  CG  TRP A 519     -22.695  41.114  51.218  1.00 17.56           C  
ATOM    185  CD1 TRP A 519     -23.983  40.663  51.139  1.00 16.63           C  
ATOM    186  CD2 TRP A 519     -22.731  42.495  50.835  1.00 18.18           C  
ATOM    187  NE1 TRP A 519     -24.818  41.676  50.727  1.00 18.93           N  
ATOM    188  CE2 TRP A 519     -24.076  42.811  50.533  1.00 18.58           C  
ATOM    189  CE3 TRP A 519     -21.759  43.497  50.714  1.00 18.97           C  
ATOM    190  CZ2 TRP A 519     -24.472  44.088  50.116  1.00 20.19           C  
ATOM    191  CZ3 TRP A 519     -22.152  44.768  50.300  1.00 20.67           C  
ATOM    192  CH2 TRP A 519     -23.500  45.049  50.007  1.00 20.01           C  
ATOM    193  N   LEU A 520     -19.626  38.247  53.193  1.00 15.87           N  
ATOM    194  CA  LEU A 520     -18.481  37.345  53.215  1.00 15.05           C  
ATOM    195  C   LEU A 520     -18.925  35.940  53.628  1.00 15.38           C  
ATOM    196  O   LEU A 520     -18.466  34.946  53.061  1.00 15.49           O  
ATOM    197  CB  LEU A 520     -17.392  37.886  54.158  1.00 15.97           C  
ATOM    198  CG  LEU A 520     -16.684  39.154  53.655  1.00 15.72           C  
ATOM    199  CD1 LEU A 520     -15.740  39.694  54.720  1.00 16.30           C  
ATOM    200  CD2 LEU A 520     -15.921  38.834  52.377  1.00 18.14           C  
ATOM    201  N   VAL A 521     -19.827  35.853  54.604  1.00 15.09           N  
ATOM    202  CA  VAL A 521     -20.332  34.557  55.033  1.00 16.78           C  
ATOM    203  C   VAL A 521     -21.138  33.962  53.879  1.00 15.98           C  
ATOM    204  O   VAL A 521     -21.075  32.757  53.617  1.00 15.51           O  
ATOM    205  CB  VAL A 521     -21.223  34.681  56.289  1.00 16.86           C  
ATOM    206  CG1 VAL A 521     -21.881  33.341  56.599  1.00 19.83           C  
ATOM    207  CG2 VAL A 521     -20.375  35.133  57.480  1.00 18.12           C  
ATOM    208  N   GLY A 522     -21.882  34.820  53.185  1.00 16.75           N  
ATOM    209  CA  GLY A 522     -22.671  34.363  52.050  1.00 16.90           C  
ATOM    210  C   GLY A 522     -21.774  33.808  50.956  1.00 18.77           C  
ATOM    211  O   GLY A 522     -22.096  32.794  50.333  1.00 17.94           O  
ATOM    212  N   LEU A 523     -20.646  34.475  50.722  1.00 17.65           N  
ATOM    213  CA  LEU A 523     -19.680  34.040  49.710  1.00 17.20           C  
ATOM    214  C   LEU A 523     -19.059  32.716  50.132  1.00 18.03           C  
ATOM    215  O   LEU A 523     -18.909  31.795  49.326  1.00 17.98           O  
ATOM    216  CB  LEU A 523     -18.577  35.089  49.539  1.00 18.76           C  
ATOM    217  CG  LEU A 523     -18.994  36.343  48.767  1.00 18.01           C  
ATOM    218  CD1 LEU A 523     -17.974  37.455  48.991  1.00 18.70           C  
ATOM    219  CD2 LEU A 523     -19.117  36.002  47.282  1.00 18.61           C  
ATOM    220  N   GLN A 524     -18.683  32.639  51.402  1.00 16.60           N  
ATOM    221  CA  GLN A 524     -18.098  31.427  51.954  1.00 19.27           C  
ATOM    222  C   GLN A 524     -19.048  30.252  51.705  1.00 18.52           C  
ATOM    223  O   GLN A 524     -18.627  29.173  51.274  1.00 17.43           O  
ATOM    224  CB  GLN A 524     -17.884  31.617  53.453  1.00 20.44           C  
ATOM    225  CG  GLN A 524     -17.524  30.368  54.213  1.00 26.08           C  
ATOM    226  CD  GLN A 524     -17.545  30.606  55.705  1.00 29.27           C  
ATOM    227  OE1 GLN A 524     -16.826  31.464  56.218  1.00 29.98           O  
ATOM    228  NE2 GLN A 524     -18.378  29.853  56.412  1.00 32.63           N  
ATOM    229  N   ASN A 525     -20.332  30.467  51.969  1.00 18.60           N  
ATOM    230  CA  ASN A 525     -21.316  29.407  51.770  1.00 18.90           C  
ATOM    231  C   ASN A 525     -21.500  29.042  50.301  1.00 18.61           C  
ATOM    232  O   ASN A 525     -21.562  27.861  49.953  1.00 17.14           O  
ATOM    233  CB  ASN A 525     -22.655  29.792  52.400  1.00 22.15           C  
ATOM    234  CG  ASN A 525     -22.601  29.784  53.917  1.00 22.52           C  
ATOM    235  OD1 ASN A 525     -21.807  29.053  54.515  1.00 28.08           O  
ATOM    236  ND2 ASN A 525     -23.449  30.585  54.549  1.00 24.90           N  
ATOM    237  N   VAL A 526     -21.582  30.044  49.436  1.00 18.07           N  
ATOM    238  CA  VAL A 526     -21.731  29.777  48.008  1.00 18.24           C  
ATOM    239  C   VAL A 526     -20.495  29.036  47.501  1.00 17.17           C  
ATOM    240  O   VAL A 526     -20.611  28.045  46.782  1.00 19.15           O  
ATOM    241  CB  VAL A 526     -21.917  31.084  47.206  1.00 18.32           C  
ATOM    242  CG1 VAL A 526     -21.808  30.804  45.712  1.00 18.47           C  
ATOM    243  CG2 VAL A 526     -23.273  31.694  47.527  1.00 20.73           C  
ATOM    244  N   PHE A 527     -19.312  29.508  47.884  1.00 16.98           N  
ATOM    245  CA  PHE A 527     -18.075  28.853  47.462  1.00 16.81           C  
ATOM    246  C   PHE A 527     -18.050  27.406  47.946  1.00 16.97           C  
ATOM    247  O   PHE A 527     -17.708  26.497  47.196  1.00 18.05           O  
ATOM    248  CB  PHE A 527     -16.847  29.588  48.012  1.00 16.52           C  
ATOM    249  CG  PHE A 527     -16.542  30.889  47.317  1.00 14.61           C  
ATOM    250  CD1 PHE A 527     -16.720  31.025  45.940  1.00 15.66           C  
ATOM    251  CD2 PHE A 527     -16.018  31.961  48.030  1.00 16.68           C  
ATOM    252  CE1 PHE A 527     -16.377  32.211  45.289  1.00 15.22           C  
ATOM    253  CE2 PHE A 527     -15.670  33.150  47.389  1.00 15.97           C  
ATOM    254  CZ  PHE A 527     -15.850  33.274  46.014  1.00 17.50           C  
ATOM    255  N   SER A 528     -18.417  27.190  49.205  1.00 18.86           N  
ATOM    256  CA  SER A 528     -18.424  25.840  49.762  1.00 19.39           C  
ATOM    257  C   SER A 528     -19.389  24.918  49.017  1.00 19.56           C  
ATOM    258  O   SER A 528     -19.059  23.768  48.717  1.00 20.49           O  
ATOM    259  CB  SER A 528     -18.803  25.882  51.244  1.00 21.53           C  
ATOM    260  OG  SER A 528     -18.797  24.575  51.791  1.00 28.29           O  
ATOM    261  N   HIS A 529     -20.576  25.434  48.714  1.00 19.32           N  
ATOM    262  CA  HIS A 529     -21.601  24.664  48.017  1.00 19.75           C  
ATOM    263  C   HIS A 529     -21.241  24.313  46.579  1.00 20.58           C  
ATOM    264  O   HIS A 529     -21.509  23.198  46.125  1.00 18.47           O  
ATOM    265  CB  HIS A 529     -22.928  25.429  48.039  1.00 24.86           C  
ATOM    266  CG  HIS A 529     -23.561  25.499  49.396  1.00 29.73           C  
ATOM    267  ND1 HIS A 529     -24.646  26.302  49.671  1.00 32.45           N  
ATOM    268  CD2 HIS A 529     -23.270  24.849  50.549  1.00 32.02           C  
ATOM    269  CE1 HIS A 529     -24.996  26.146  50.936  1.00 32.62           C  
ATOM    270  NE2 HIS A 529     -24.178  25.271  51.490  1.00 33.11           N  
ATOM    271  N   GLN A 530     -20.631  25.255  45.862  1.00 20.17           N  
ATOM    272  CA  GLN A 530     -20.254  25.023  44.470  1.00 21.08           C  
ATOM    273  C   GLN A 530     -18.851  24.417  44.335  1.00 21.79           C  
ATOM    274  O   GLN A 530     -18.437  24.023  43.245  1.00 20.62           O  
ATOM    275  CB  GLN A 530     -20.327  26.330  43.670  1.00 20.34           C  
ATOM    276  CG  GLN A 530     -21.626  27.136  43.825  1.00 20.45           C  
ATOM    277  CD  GLN A 530     -22.892  26.349  43.507  1.00 19.77           C  
ATOM    278  OE1 GLN A 530     -22.915  25.496  42.620  1.00 21.30           O  
ATOM    279  NE2 GLN A 530     -23.961  26.658  44.222  1.00 18.00           N  
ATOM    280  N   LEU A 531     -18.123  24.359  45.447  1.00 21.73           N  
ATOM    281  CA  LEU A 531     -16.778  23.782  45.481  1.00 22.35           C  
ATOM    282  C   LEU A 531     -16.773  22.746  46.613  1.00 22.16           C  
ATOM    283  O   LEU A 531     -16.027  22.868  47.585  1.00 22.30           O  
ATOM    284  CB  LEU A 531     -15.734  24.876  45.753  1.00 22.99           C  
ATOM    285  CG  LEU A 531     -15.603  25.992  44.705  1.00 24.94           C  
ATOM    286  CD1 LEU A 531     -14.694  27.106  45.218  1.00 23.83           C  
ATOM    287  CD2 LEU A 531     -15.056  25.411  43.418  1.00 23.63           C  
ATOM    288  N   PRO A 532     -17.606  21.700  46.488  1.00 24.35           N  
ATOM    289  CA  PRO A 532     -17.721  20.638  47.495  1.00 24.05           C  
ATOM    290  C   PRO A 532     -16.445  19.892  47.885  1.00 25.41           C  
ATOM    291  O   PRO A 532     -16.364  19.344  48.985  1.00 24.86           O  
ATOM    292  CB  PRO A 532     -18.785  19.714  46.900  1.00 23.65           C  
ATOM    293  CG  PRO A 532     -18.592  19.880  45.428  1.00 23.22           C  
ATOM    294  CD  PRO A 532     -18.398  21.369  45.289  1.00 21.45           C  
ATOM    295  N   ARG A 533     -15.450  19.866  47.003  1.00 25.97           N  
ATOM    296  CA  ARG A 533     -14.207  19.175  47.319  1.00 28.41           C  
ATOM    297  C   ARG A 533     -13.219  20.049  48.093  1.00 30.15           C  
ATOM    298  O   ARG A 533     -12.146  19.585  48.479  1.00 29.99           O  
ATOM    299  CB  ARG A 533     -13.538  18.655  46.046  1.00 30.00           C  
ATOM    300  CG  ARG A 533     -14.310  17.552  45.341  1.00 34.08           C  
ATOM    301  CD  ARG A 533     -13.426  16.846  44.324  1.00 37.28           C  
ATOM    302  NE  ARG A 533     -12.907  17.772  43.323  1.00 41.05           N  
ATOM    303  CZ  ARG A 533     -11.947  17.474  42.452  1.00 43.05           C  
ATOM    304  NH1 ARG A 533     -11.394  16.270  42.457  1.00 44.18           N  
ATOM    305  NH2 ARG A 533     -11.540  18.382  41.576  1.00 44.54           N  
ATOM    306  N   MET A 534     -13.585  21.308  48.315  1.00 30.00           N  
ATOM    307  CA  MET A 534     -12.734  22.242  49.053  1.00 30.38           C  
ATOM    308  C   MET A 534     -13.161  22.290  50.515  1.00 30.45           C  
ATOM    309  O   MET A 534     -14.336  22.496  50.816  1.00 31.59           O  
ATOM    310  CB  MET A 534     -12.843  23.652  48.454  1.00 30.54           C  
ATOM    311  CG  MET A 534     -12.125  23.843  47.127  1.00 32.72           C  
ATOM    312  SD  MET A 534     -10.383  24.295  47.309  1.00 31.21           S  
ATOM    313  CE  MET A 534     -10.137  25.268  45.823  1.00 33.67           C  
ATOM    314  N   PRO A 535     -12.212  22.097  51.447  1.00 30.72           N  
ATOM    315  CA  PRO A 535     -12.539  22.132  52.878  1.00 30.26           C  
ATOM    316  C   PRO A 535     -13.221  23.455  53.225  1.00 29.82           C  
ATOM    317  O   PRO A 535     -12.749  24.519  52.830  1.00 29.40           O  
ATOM    318  CB  PRO A 535     -11.172  21.998  53.544  1.00 29.92           C  
ATOM    319  CG  PRO A 535     -10.398  21.172  52.560  1.00 30.61           C  
ATOM    320  CD  PRO A 535     -10.783  21.798  51.241  1.00 29.55           C  
ATOM    321  N   LYS A 536     -14.326  23.396  53.960  1.00 30.36           N  
ATOM    322  CA  LYS A 536     -15.031  24.622  54.314  1.00 30.88           C  
ATOM    323  C   LYS A 536     -14.159  25.548  55.152  1.00 29.70           C  
ATOM    324  O   LYS A 536     -14.190  26.769  54.976  1.00 28.23           O  
ATOM    325  CB  LYS A 536     -16.327  24.306  55.063  1.00 33.39           C  
ATOM    326  CG  LYS A 536     -17.245  25.514  55.223  1.00 36.53           C  
ATOM    327  CD  LYS A 536     -18.571  25.129  55.867  1.00 39.98           C  
ATOM    328  CE  LYS A 536     -19.475  26.341  56.049  1.00 41.64           C  
ATOM    329  NZ  LYS A 536     -19.813  26.993  54.755  1.00 40.87           N  
ATOM    330  N   GLU A 537     -13.373  24.972  56.058  1.00 28.75           N  
ATOM    331  CA  GLU A 537     -12.498  25.773  56.906  1.00 28.70           C  
ATOM    332  C   GLU A 537     -11.470  26.488  56.031  1.00 25.84           C  
ATOM    333  O   GLU A 537     -11.097  27.629  56.299  1.00 24.88           O  
ATOM    334  CB  GLU A 537     -11.788  24.888  57.939  1.00 30.78           C  
ATOM    335  CG  GLU A 537     -11.135  25.674  59.076  1.00 37.67           C  
ATOM    336  CD  GLU A 537     -10.563  24.782  60.166  1.00 41.03           C  
ATOM    337  OE1 GLU A 537     -11.294  23.894  60.656  1.00 42.93           O  
ATOM    338  OE2 GLU A 537      -9.384  24.976  60.542  1.00 43.00           O  
ATOM    339  N   TYR A 538     -11.024  25.810  54.978  1.00 24.84           N  
ATOM    340  CA  TYR A 538     -10.048  26.375  54.050  1.00 22.93           C  
ATOM    341  C   TYR A 538     -10.632  27.579  53.307  1.00 22.80           C  
ATOM    342  O   TYR A 538      -9.982  28.615  53.169  1.00 21.72           O  
ATOM    343  CB  TYR A 538      -9.611  25.312  53.043  1.00 23.81           C  
ATOM    344  CG  TYR A 538      -8.559  25.793  52.074  1.00 25.81           C  
ATOM    345  CD1 TYR A 538      -7.275  26.119  52.515  1.00 26.42           C  
ATOM    346  CD2 TYR A 538      -8.849  25.945  50.719  1.00 25.47           C  
ATOM    347  CE1 TYR A 538      -6.306  26.586  51.631  1.00 25.88           C  
ATOM    348  CE2 TYR A 538      -7.888  26.414  49.823  1.00 26.52           C  
ATOM    349  CZ  TYR A 538      -6.618  26.731  50.287  1.00 28.15           C  
ATOM    350  OH  TYR A 538      -5.665  27.192  49.412  1.00 26.47           O  
ATOM    351  N   ILE A 539     -11.857  27.429  52.816  1.00 21.68           N  
ATOM    352  CA  ILE A 539     -12.528  28.509  52.105  1.00 20.74           C  
ATOM    353  C   ILE A 539     -12.707  29.702  53.040  1.00 20.16           C  
ATOM    354  O   ILE A 539     -12.437  30.840  52.664  1.00 17.51           O  
ATOM    355  CB  ILE A 539     -13.908  28.050  51.584  1.00 21.74           C  
ATOM    356  CG1 ILE A 539     -13.718  27.034  50.455  1.00 20.85           C  
ATOM    357  CG2 ILE A 539     -14.721  29.257  51.108  1.00 20.84           C  
ATOM    358  CD1 ILE A 539     -14.998  26.372  49.996  1.00 20.49           C  
ATOM    359  N   ALA A 540     -13.159  29.432  54.261  1.00 19.32           N  
ATOM    360  CA  ALA A 540     -13.361  30.487  55.250  1.00 20.36           C  
ATOM    361  C   ALA A 540     -12.053  31.231  55.531  1.00 20.30           C  
ATOM    362  O   ALA A 540     -12.026  32.459  55.591  1.00 20.94           O  
ATOM    363  CB  ALA A 540     -13.910  29.888  56.548  1.00 22.34           C  
ATOM    364  N   ARG A 541     -10.970  30.481  55.697  1.00 21.16           N  
ATOM    365  CA  ARG A 541      -9.666  31.072  55.983  1.00 21.93           C  
ATOM    366  C   ARG A 541      -9.216  32.058  54.907  1.00 21.80           C  
ATOM    367  O   ARG A 541      -8.726  33.148  55.211  1.00 20.54           O  
ATOM    368  CB  ARG A 541      -8.616  29.966  56.148  1.00 25.89           C  
ATOM    369  CG  ARG A 541      -7.198  30.473  56.348  1.00 31.48           C  
ATOM    370  CD  ARG A 541      -6.422  29.589  57.317  1.00 36.95           C  
ATOM    371  NE  ARG A 541      -6.413  28.183  56.919  1.00 41.58           N  
ATOM    372  CZ  ARG A 541      -5.807  27.711  55.834  1.00 42.58           C  
ATOM    373  NH1 ARG A 541      -5.152  28.534  55.024  1.00 44.23           N  
ATOM    374  NH2 ARG A 541      -5.854  26.413  55.562  1.00 43.79           N  
ATOM    375  N   LEU A 542      -9.388  31.678  53.648  1.00 20.11           N  
ATOM    376  CA  LEU A 542      -8.977  32.538  52.549  1.00 19.67           C  
ATOM    377  C   LEU A 542      -9.925  33.705  52.307  1.00 18.91           C  
ATOM    378  O   LEU A 542      -9.480  34.831  52.087  1.00 18.73           O  
ATOM    379  CB  LEU A 542      -8.821  31.715  51.268  1.00 20.68           C  
ATOM    380  CG  LEU A 542      -7.619  30.769  51.283  1.00 20.67           C  
ATOM    381  CD1 LEU A 542      -7.542  30.002  49.977  1.00 24.46           C  
ATOM    382  CD2 LEU A 542      -6.343  31.579  51.496  1.00 24.22           C  
ATOM    383  N   VAL A 543     -11.228  33.445  52.353  1.00 17.49           N  
ATOM    384  CA  VAL A 543     -12.209  34.504  52.124  1.00 16.34           C  
ATOM    385  C   VAL A 543     -12.061  35.627  53.139  1.00 16.32           C  
ATOM    386  O   VAL A 543     -12.274  36.796  52.819  1.00 16.18           O  
ATOM    387  CB  VAL A 543     -13.658  33.954  52.176  1.00 15.84           C  
ATOM    388  CG1 VAL A 543     -14.665  35.103  52.219  1.00 17.66           C  
ATOM    389  CG2 VAL A 543     -13.917  33.095  50.946  1.00 15.61           C  
ATOM    390  N   PHE A 544     -11.676  35.264  54.360  1.00 17.42           N  
ATOM    391  CA  PHE A 544     -11.503  36.242  55.428  1.00 16.60           C  
ATOM    392  C   PHE A 544     -10.066  36.706  55.642  1.00 16.38           C  
ATOM    393  O   PHE A 544      -9.788  37.440  56.586  1.00 16.16           O  
ATOM    394  CB  PHE A 544     -12.069  35.683  56.735  1.00 16.56           C  
ATOM    395  CG  PHE A 544     -13.567  35.735  56.804  1.00 17.25           C  
ATOM    396  CD1 PHE A 544     -14.218  36.909  57.173  1.00 17.62           C  
ATOM    397  CD2 PHE A 544     -14.333  34.629  56.446  1.00 17.83           C  
ATOM    398  CE1 PHE A 544     -15.609  36.981  57.180  1.00 20.82           C  
ATOM    399  CE2 PHE A 544     -15.727  34.694  56.450  1.00 20.28           C  
ATOM    400  CZ  PHE A 544     -16.365  35.876  56.819  1.00 17.84           C  
ATOM    401  N   ASP A 545      -9.157  36.282  54.771  1.00 16.68           N  
ATOM    402  CA  ASP A 545      -7.762  36.695  54.885  1.00 18.80           C  
ATOM    403  C   ASP A 545      -7.609  38.107  54.333  1.00 19.19           C  
ATOM    404  O   ASP A 545      -7.981  38.379  53.192  1.00 18.27           O  
ATOM    405  CB  ASP A 545      -6.843  35.755  54.105  1.00 18.99           C  
ATOM    406  CG  ASP A 545      -5.391  36.191  54.169  1.00 20.81           C  
ATOM    407  OD1 ASP A 545      -4.797  36.120  55.267  1.00 21.92           O  
ATOM    408  OD2 ASP A 545      -4.850  36.618  53.129  1.00 20.03           O  
ATOM    409  N   PRO A 546      -7.040  39.022  55.131  1.00 21.16           N  
ATOM    410  CA  PRO A 546      -6.842  40.413  54.716  1.00 22.62           C  
ATOM    411  C   PRO A 546      -6.123  40.630  53.382  1.00 22.38           C  
ATOM    412  O   PRO A 546      -6.310  41.664  52.746  1.00 22.10           O  
ATOM    413  CB  PRO A 546      -6.074  41.014  55.892  1.00 24.78           C  
ATOM    414  CG  PRO A 546      -6.607  40.245  57.051  1.00 23.13           C  
ATOM    415  CD  PRO A 546      -6.600  38.830  56.525  1.00 22.50           C  
ATOM    416  N   LYS A 547      -5.314  39.663  52.955  1.00 20.80           N  
ATOM    417  CA  LYS A 547      -4.582  39.797  51.696  1.00 20.22           C  
ATOM    418  C   LYS A 547      -5.395  39.341  50.497  1.00 18.68           C  
ATOM    419  O   LYS A 547      -4.957  39.476  49.354  1.00 19.57           O  
ATOM    420  CB  LYS A 547      -3.269  39.016  51.756  1.00 22.60           C  
ATOM    421  CG  LYS A 547      -2.272  39.585  52.752  1.00 25.20           C  
ATOM    422  CD  LYS A 547      -1.113  38.631  52.970  1.00 31.49           C  
ATOM    423  CE  LYS A 547      -0.069  39.236  53.896  1.00 34.04           C  
ATOM    424  NZ  LYS A 547       0.573  40.434  53.289  1.00 37.62           N  
ATOM    425  N   HIS A 548      -6.574  38.798  50.762  1.00 18.52           N  
ATOM    426  CA  HIS A 548      -7.462  38.342  49.702  1.00 18.35           C  
ATOM    427  C   HIS A 548      -8.684  39.248  49.610  1.00 18.61           C  
ATOM    428  O   HIS A 548      -9.183  39.742  50.622  1.00 19.96           O  
ATOM    429  CB  HIS A 548      -7.939  36.910  49.961  1.00 15.92           C  
ATOM    430  CG  HIS A 548      -6.876  35.870  49.780  1.00 18.56           C  
ATOM    431  ND1 HIS A 548      -5.823  35.721  50.657  1.00 17.31           N  
ATOM    432  CD2 HIS A 548      -6.703  34.930  48.821  1.00 17.33           C  
ATOM    433  CE1 HIS A 548      -5.049  34.732  50.246  1.00 19.53           C  
ATOM    434  NE2 HIS A 548      -5.561  34.236  49.135  1.00 18.55           N  
ATOM    435  N   LYS A 549      -9.156  39.472  48.390  1.00 16.97           N  
ATOM    436  CA  LYS A 549     -10.352  40.276  48.181  1.00 16.57           C  
ATOM    437  C   LYS A 549     -11.318  39.372  47.433  1.00 15.15           C  
ATOM    438  O   LYS A 549     -10.913  38.353  46.866  1.00 14.84           O  
ATOM    439  CB  LYS A 549     -10.071  41.494  47.296  1.00 17.22           C  
ATOM    440  CG  LYS A 549      -8.999  42.440  47.782  1.00 20.06           C  
ATOM    441  CD  LYS A 549      -8.915  43.644  46.848  1.00 19.68           C  
ATOM    442  CE  LYS A 549      -7.886  44.652  47.327  1.00 21.42           C  
ATOM    443  NZ  LYS A 549      -7.838  45.850  46.442  1.00 21.55           N  
ATOM    444  N   THR A 550     -12.594  39.731  47.433  1.00 15.67           N  
ATOM    445  CA  THR A 550     -13.564  38.949  46.685  1.00 13.70           C  
ATOM    446  C   THR A 550     -14.482  39.904  45.934  1.00 15.22           C  
ATOM    447  O   THR A 550     -15.022  40.848  46.518  1.00 16.38           O  
ATOM    448  CB  THR A 550     -14.440  38.040  47.590  1.00 14.48           C  
ATOM    449  OG1 THR A 550     -13.611  37.177  48.382  1.00 15.38           O  
ATOM    450  CG2 THR A 550     -15.349  37.177  46.727  1.00 17.62           C  
ATOM    451  N   LEU A 551     -14.634  39.670  44.635  1.00 13.37           N  
ATOM    452  CA  LEU A 551     -15.530  40.472  43.818  1.00 14.19           C  
ATOM    453  C   LEU A 551     -16.854  39.746  43.983  1.00 15.21           C  
ATOM    454  O   LEU A 551     -17.006  38.622  43.509  1.00 16.81           O  
ATOM    455  CB  LEU A 551     -15.100  40.442  42.352  1.00 12.36           C  
ATOM    456  CG  LEU A 551     -16.092  41.063  41.365  1.00 13.38           C  
ATOM    457  CD1 LEU A 551     -16.344  42.523  41.730  1.00 13.65           C  
ATOM    458  CD2 LEU A 551     -15.536  40.956  39.949  1.00 13.09           C  
ATOM    459  N   ALA A 552     -17.801  40.379  44.667  1.00 14.74           N  
ATOM    460  CA  ALA A 552     -19.095  39.759  44.918  1.00 14.83           C  
ATOM    461  C   ALA A 552     -20.192  40.235  43.982  1.00 16.34           C  
ATOM    462  O   ALA A 552     -20.281  41.422  43.661  1.00 14.89           O  
ATOM    463  CB  ALA A 552     -19.518  40.009  46.376  1.00 15.37           C  
ATOM    464  N   LEU A 553     -21.017  39.289  43.542  1.00 16.67           N  
ATOM    465  CA  LEU A 553     -22.156  39.579  42.679  1.00 17.62           C  
ATOM    466  C   LEU A 553     -23.359  39.453  43.602  1.00 17.40           C  
ATOM    467  O   LEU A 553     -23.676  38.362  44.073  1.00 16.28           O  
ATOM    468  CB  LEU A 553     -22.255  38.561  41.542  1.00 18.04           C  
ATOM    469  CG  LEU A 553     -23.476  38.727  40.629  1.00 16.49           C  
ATOM    470  CD1 LEU A 553     -23.431  40.095  39.949  1.00 20.32           C  
ATOM    471  CD2 LEU A 553     -23.491  37.617  39.590  1.00 19.61           C  
ATOM    472  N   ILE A 554     -24.010  40.584  43.860  1.00 18.80           N  
ATOM    473  CA  ILE A 554     -25.148  40.650  44.765  1.00 20.74           C  
ATOM    474  C   ILE A 554     -26.438  41.053  44.065  1.00 22.43           C  
ATOM    475  O   ILE A 554     -26.452  41.999  43.285  1.00 21.59           O  
ATOM    476  CB  ILE A 554     -24.900  41.704  45.869  1.00 22.13           C  
ATOM    477  CG1 ILE A 554     -23.497  41.542  46.455  1.00 22.55           C  
ATOM    478  CG2 ILE A 554     -25.966  41.588  46.950  1.00 23.39           C  
ATOM    479  CD1 ILE A 554     -23.274  40.241  47.171  1.00 25.19           C  
ATOM    480  N   LYS A 555     -27.519  40.342  44.358  1.00 25.35           N  
ATOM    481  CA  LYS A 555     -28.815  40.683  43.786  1.00 29.69           C  
ATOM    482  C   LYS A 555     -29.831  40.667  44.922  1.00 31.42           C  
ATOM    483  O   LYS A 555     -30.024  39.647  45.588  1.00 31.78           O  
ATOM    484  CB  LYS A 555     -29.217  39.700  42.682  1.00 31.66           C  
ATOM    485  CG  LYS A 555     -29.528  38.293  43.141  1.00 36.45           C  
ATOM    486  CD  LYS A 555     -30.131  37.470  42.006  1.00 38.44           C  
ATOM    487  CE  LYS A 555     -31.443  38.070  41.518  1.00 40.33           C  
ATOM    488  NZ  LYS A 555     -32.088  37.240  40.458  1.00 41.10           N  
ATOM    489  N   ASP A 556     -30.465  41.812  45.153  1.00 34.33           N  
ATOM    490  CA  ASP A 556     -31.441  41.939  46.227  1.00 36.19           C  
ATOM    491  C   ASP A 556     -30.785  41.643  47.569  1.00 35.01           C  
ATOM    492  O   ASP A 556     -31.310  40.875  48.374  1.00 35.57           O  
ATOM    493  CB  ASP A 556     -32.618  40.987  46.001  1.00 38.47           C  
ATOM    494  CG  ASP A 556     -33.518  41.436  44.871  1.00 41.76           C  
ATOM    495  OD1 ASP A 556     -34.030  42.576  44.943  1.00 43.21           O  
ATOM    496  OD2 ASP A 556     -33.715  40.654  43.917  1.00 43.43           O  
ATOM    497  N   GLY A 557     -29.624  42.252  47.793  1.00 34.84           N  
ATOM    498  CA  GLY A 557     -28.904  42.070  49.041  1.00 33.19           C  
ATOM    499  C   GLY A 557     -28.307  40.700  49.290  1.00 32.61           C  
ATOM    500  O   GLY A 557     -27.629  40.502  50.298  1.00 32.87           O  
ATOM    501  N   ARG A 558     -28.544  39.753  48.386  1.00 31.54           N  
ATOM    502  CA  ARG A 558     -28.019  38.401  48.553  1.00 29.73           C  
ATOM    503  C   ARG A 558     -26.880  38.062  47.595  1.00 26.33           C  
ATOM    504  O   ARG A 558     -26.905  38.428  46.426  1.00 24.98           O  
ATOM    505  CB  ARG A 558     -29.146  37.381  48.389  1.00 32.79           C  
ATOM    506  CG  ARG A 558     -28.707  35.940  48.561  1.00 37.33           C  
ATOM    507  CD  ARG A 558     -29.906  35.034  48.796  1.00 41.89           C  
ATOM    508  NE  ARG A 558     -30.535  35.298  50.088  1.00 46.18           N  
ATOM    509  CZ  ARG A 558     -29.974  35.028  51.263  1.00 48.32           C  
ATOM    510  NH1 ARG A 558     -28.766  34.481  51.316  1.00 49.95           N  
ATOM    511  NH2 ARG A 558     -30.617  35.308  52.390  1.00 49.55           N  
ATOM    512  N   VAL A 559     -25.876  37.361  48.109  1.00 23.33           N  
ATOM    513  CA  VAL A 559     -24.729  36.960  47.304  1.00 21.95           C  
ATOM    514  C   VAL A 559     -25.130  35.822  46.373  1.00 20.69           C  
ATOM    515  O   VAL A 559     -25.630  34.798  46.834  1.00 21.28           O  
ATOM    516  CB  VAL A 559     -23.566  36.464  48.200  1.00 21.41           C  
ATOM    517  CG1 VAL A 559     -22.461  35.856  47.342  1.00 22.30           C  
ATOM    518  CG2 VAL A 559     -23.023  37.615  49.036  1.00 23.78           C  
ATOM    519  N   ILE A 560     -24.928  35.997  45.070  1.00 19.21           N  
ATOM    520  CA  ILE A 560     -25.260  34.932  44.130  1.00 18.99           C  
ATOM    521  C   ILE A 560     -24.036  34.434  43.378  1.00 15.36           C  
ATOM    522  O   ILE A 560     -24.135  33.543  42.548  1.00 14.65           O  
ATOM    523  CB  ILE A 560     -26.334  35.355  43.105  1.00 20.35           C  
ATOM    524  CG1 ILE A 560     -25.855  36.550  42.283  1.00 20.25           C  
ATOM    525  CG2 ILE A 560     -27.635  35.662  43.831  1.00 21.03           C  
ATOM    526  CD1 ILE A 560     -26.776  36.884  41.121  1.00 23.52           C  
ATOM    527  N   GLY A 561     -22.879  35.006  43.683  1.00 15.08           N  
ATOM    528  CA  GLY A 561     -21.660  34.573  43.022  1.00 14.02           C  
ATOM    529  C   GLY A 561     -20.490  35.453  43.380  1.00 13.65           C  
ATOM    530  O   GLY A 561     -20.661  36.506  43.997  1.00 12.61           O  
ATOM    531  N   GLY A 562     -19.292  35.028  43.001  1.00 13.70           N  
ATOM    532  CA  GLY A 562     -18.127  35.835  43.295  1.00 13.66           C  
ATOM    533  C   GLY A 562     -16.827  35.193  42.875  1.00 14.72           C  
ATOM    534  O   GLY A 562     -16.782  34.016  42.511  1.00 14.09           O  
ATOM    535  N   ILE A 563     -15.772  35.996  42.890  1.00 13.83           N  
ATOM    536  CA  ILE A 563     -14.441  35.526  42.555  1.00 13.18           C  
ATOM    537  C   ILE A 563     -13.525  36.026  43.664  1.00 12.83           C  
ATOM    538  O   ILE A 563     -13.405  37.235  43.884  1.00 13.09           O  
ATOM    539  CB  ILE A 563     -13.935  36.090  41.207  1.00 12.99           C  
ATOM    540  CG1 ILE A 563     -14.819  35.599  40.059  1.00 11.54           C  
ATOM    541  CG2 ILE A 563     -12.491  35.630  40.966  1.00 14.69           C  
ATOM    542  CD1 ILE A 563     -14.442  36.174  38.708  1.00 13.94           C  
ATOM    543  N   CYS A 564     -12.911  35.089  44.376  1.00 11.93           N  
ATOM    544  CA  CYS A 564     -11.982  35.420  45.446  1.00 11.72           C  
ATOM    545  C   CYS A 564     -10.617  35.469  44.777  1.00 13.08           C  
ATOM    546  O   CYS A 564     -10.258  34.556  44.032  1.00 13.25           O  
ATOM    547  CB  CYS A 564     -12.005  34.339  46.532  1.00 13.96           C  
ATOM    548  SG  CYS A 564     -10.940  34.709  47.938  1.00 16.94           S  
ATOM    549  N   PHE A 565      -9.866  36.537  45.020  1.00 13.23           N  
ATOM    550  CA  PHE A 565      -8.561  36.678  44.393  1.00 15.61           C  
ATOM    551  C   PHE A 565      -7.532  37.354  45.282  1.00 15.86           C  
ATOM    552  O   PHE A 565      -7.856  37.918  46.324  1.00 16.53           O  
ATOM    553  CB  PHE A 565      -8.701  37.470  43.082  1.00 14.34           C  
ATOM    554  CG  PHE A 565      -9.207  38.878  43.265  1.00 14.18           C  
ATOM    555  CD1 PHE A 565      -8.322  39.957  43.288  1.00 13.78           C  
ATOM    556  CD2 PHE A 565     -10.568  39.128  43.403  1.00 14.26           C  
ATOM    557  CE1 PHE A 565      -8.785  41.260  43.444  1.00 14.03           C  
ATOM    558  CE2 PHE A 565     -11.049  40.429  43.561  1.00 14.35           C  
ATOM    559  CZ  PHE A 565     -10.158  41.498  43.582  1.00 14.20           C  
ATOM    560  N   ARG A 566      -6.277  37.276  44.862  1.00 16.89           N  
ATOM    561  CA  ARG A 566      -5.202  37.919  45.592  1.00 17.68           C  
ATOM    562  C   ARG A 566      -4.311  38.636  44.592  1.00 17.70           C  
ATOM    563  O   ARG A 566      -3.800  38.030  43.646  1.00 16.74           O  
ATOM    564  CB  ARG A 566      -4.383  36.913  46.395  1.00 17.84           C  
ATOM    565  CG  ARG A 566      -3.265  37.608  47.139  1.00 20.18           C  
ATOM    566  CD  ARG A 566      -2.520  36.712  48.078  1.00 23.35           C  
ATOM    567  NE  ARG A 566      -1.444  37.468  48.707  1.00 25.36           N  
ATOM    568  CZ  ARG A 566      -0.586  36.965  49.586  1.00 28.78           C  
ATOM    569  NH1 ARG A 566      -0.671  35.691  49.949  1.00 28.92           N  
ATOM    570  NH2 ARG A 566       0.352  37.743  50.105  1.00 26.74           N  
ATOM    571  N   MET A 567      -4.144  39.936  44.810  1.00 16.27           N  
ATOM    572  CA  MET A 567      -3.344  40.774  43.935  1.00 16.33           C  
ATOM    573  C   MET A 567      -1.868  40.733  44.316  1.00 16.92           C  
ATOM    574  O   MET A 567      -1.519  40.829  45.489  1.00 17.31           O  
ATOM    575  CB  MET A 567      -3.853  42.220  43.997  1.00 16.46           C  
ATOM    576  CG  MET A 567      -5.357  42.357  43.762  1.00 17.07           C  
ATOM    577  SD  MET A 567      -5.989  44.053  43.928  1.00 18.49           S  
ATOM    578  CE  MET A 567      -5.798  44.657  42.248  1.00 20.01           C  
ATOM    579  N   PHE A 568      -1.014  40.576  43.309  1.00 18.36           N  
ATOM    580  CA  PHE A 568       0.436  40.549  43.503  1.00 20.35           C  
ATOM    581  C   PHE A 568       1.007  41.609  42.561  1.00 20.95           C  
ATOM    582  O   PHE A 568       1.661  41.285  41.568  1.00 22.15           O  
ATOM    583  CB  PHE A 568       0.997  39.168  43.147  1.00 19.81           C  
ATOM    584  CG  PHE A 568       0.654  38.085  44.144  1.00 20.43           C  
ATOM    585  CD1 PHE A 568       1.335  37.993  45.358  1.00 20.08           C  
ATOM    586  CD2 PHE A 568      -0.324  37.138  43.857  1.00 18.78           C  
ATOM    587  CE1 PHE A 568       1.047  36.966  46.269  1.00 18.47           C  
ATOM    588  CE2 PHE A 568      -0.618  36.112  44.757  1.00 19.31           C  
ATOM    589  CZ  PHE A 568       0.069  36.025  45.966  1.00 17.88           C  
ATOM    590  N   PRO A 569       0.765  42.893  42.869  1.00 22.29           N  
ATOM    591  CA  PRO A 569       1.226  44.035  42.070  1.00 25.01           C  
ATOM    592  C   PRO A 569       2.687  44.017  41.636  1.00 26.74           C  
ATOM    593  O   PRO A 569       2.996  44.312  40.481  1.00 27.91           O  
ATOM    594  CB  PRO A 569       0.888  45.238  42.956  1.00 24.01           C  
ATOM    595  CG  PRO A 569       0.951  44.675  44.332  1.00 25.33           C  
ATOM    596  CD  PRO A 569       0.244  43.357  44.165  1.00 23.31           C  
ATOM    597  N   THR A 570       3.590  43.676  42.546  1.00 28.40           N  
ATOM    598  CA  THR A 570       5.000  43.651  42.181  1.00 29.18           C  
ATOM    599  C   THR A 570       5.301  42.504  41.224  1.00 28.55           C  
ATOM    600  O   THR A 570       6.086  42.664  40.289  1.00 29.70           O  
ATOM    601  CB  THR A 570       5.906  43.540  43.422  1.00 30.48           C  
ATOM    602  OG1 THR A 570       5.552  42.380  44.185  1.00 34.83           O  
ATOM    603  CG2 THR A 570       5.760  44.781  44.284  1.00 31.18           C  
ATOM    604  N   GLN A 571       4.664  41.359  41.448  1.00 25.23           N  
ATOM    605  CA  GLN A 571       4.867  40.192  40.595  1.00 24.41           C  
ATOM    606  C   GLN A 571       4.186  40.361  39.237  1.00 23.36           C  
ATOM    607  O   GLN A 571       4.471  39.617  38.296  1.00 22.19           O  
ATOM    608  CB  GLN A 571       4.341  38.925  41.270  1.00 24.54           C  
ATOM    609  CG  GLN A 571       5.028  38.560  42.578  1.00 25.77           C  
ATOM    610  CD  GLN A 571       6.539  38.607  42.479  1.00 27.74           C  
ATOM    611  OE1 GLN A 571       7.147  39.666  42.623  1.00 29.20           O  
ATOM    612  NE2 GLN A 571       7.154  37.457  42.222  1.00 26.70           N  
ATOM    613  N   GLY A 572       3.284  41.334  39.142  1.00 20.71           N  
ATOM    614  CA  GLY A 572       2.594  41.596  37.889  1.00 19.93           C  
ATOM    615  C   GLY A 572       1.410  40.697  37.579  1.00 17.88           C  
ATOM    616  O   GLY A 572       1.021  40.556  36.423  1.00 17.45           O  
ATOM    617  N   PHE A 573       0.829  40.076  38.598  1.00 17.27           N  
ATOM    618  CA  PHE A 573      -0.315  39.213  38.354  1.00 16.31           C  
ATOM    619  C   PHE A 573      -1.219  39.091  39.562  1.00 15.57           C  
ATOM    620  O   PHE A 573      -0.899  39.558  40.655  1.00 16.27           O  
ATOM    621  CB  PHE A 573       0.146  37.815  37.910  1.00 14.33           C  
ATOM    622  CG  PHE A 573       0.834  37.020  38.993  1.00 17.42           C  
ATOM    623  CD1 PHE A 573       0.097  36.381  39.990  1.00 19.49           C  
ATOM    624  CD2 PHE A 573       2.221  36.901  39.009  1.00 18.49           C  
ATOM    625  CE1 PHE A 573       0.733  35.637  40.987  1.00 20.25           C  
ATOM    626  CE2 PHE A 573       2.867  36.158  40.003  1.00 20.45           C  
ATOM    627  CZ  PHE A 573       2.121  35.527  40.991  1.00 19.38           C  
ATOM    628  N   THR A 574      -2.364  38.461  39.336  1.00 16.02           N  
ATOM    629  CA  THR A 574      -3.339  38.219  40.379  1.00 14.52           C  
ATOM    630  C   THR A 574      -3.704  36.752  40.342  1.00 14.77           C  
ATOM    631  O   THR A 574      -3.854  36.158  39.270  1.00 15.31           O  
ATOM    632  CB  THR A 574      -4.621  39.056  40.178  1.00 15.59           C  
ATOM    633  OG1 THR A 574      -4.412  40.368  40.710  1.00 16.05           O  
ATOM    634  CG2 THR A 574      -5.817  38.403  40.884  1.00 16.93           C  
ATOM    635  N   GLU A 575      -3.837  36.174  41.525  1.00 13.52           N  
ATOM    636  CA  GLU A 575      -4.198  34.776  41.667  1.00 13.31           C  
ATOM    637  C   GLU A 575      -5.704  34.647  41.848  1.00 14.64           C  
ATOM    638  O   GLU A 575      -6.280  35.299  42.717  1.00 14.33           O  
ATOM    639  CB  GLU A 575      -3.478  34.187  42.884  1.00 13.55           C  
ATOM    640  CG  GLU A 575      -4.005  32.850  43.345  1.00 17.38           C  
ATOM    641  CD  GLU A 575      -3.313  32.362  44.606  1.00 16.39           C  
ATOM    642  OE1 GLU A 575      -2.920  33.210  45.434  1.00 19.55           O  
ATOM    643  OE2 GLU A 575      -3.176  31.134  44.774  1.00 20.30           O  
ATOM    644  N   ILE A 576      -6.340  33.837  41.007  1.00 12.52           N  
ATOM    645  CA  ILE A 576      -7.775  33.596  41.123  1.00 13.61           C  
ATOM    646  C   ILE A 576      -7.869  32.372  42.023  1.00 14.69           C  
ATOM    647  O   ILE A 576      -7.464  31.278  41.636  1.00 15.84           O  
ATOM    648  CB  ILE A 576      -8.427  33.267  39.759  1.00 14.43           C  
ATOM    649  CG1 ILE A 576      -8.228  34.431  38.785  1.00 17.72           C  
ATOM    650  CG2 ILE A 576      -9.920  32.974  39.951  1.00 16.57           C  
ATOM    651  CD1 ILE A 576      -8.746  35.754  39.282  1.00 19.83           C  
ATOM    652  N   VAL A 577      -8.395  32.568  43.226  1.00 16.14           N  
ATOM    653  CA  VAL A 577      -8.506  31.499  44.214  1.00 15.56           C  
ATOM    654  C   VAL A 577      -9.805  30.695  44.145  1.00 16.49           C  
ATOM    655  O   VAL A 577      -9.775  29.466  44.071  1.00 17.07           O  
ATOM    656  CB  VAL A 577      -8.334  32.084  45.626  1.00 16.53           C  
ATOM    657  CG1 VAL A 577      -8.378  30.978  46.675  1.00 17.19           C  
ATOM    658  CG2 VAL A 577      -7.017  32.836  45.697  1.00 18.35           C  
ATOM    659  N   PHE A 578     -10.941  31.385  44.191  1.00 15.72           N  
ATOM    660  CA  PHE A 578     -12.240  30.721  44.109  1.00 16.80           C  
ATOM    661  C   PHE A 578     -13.092  31.459  43.097  1.00 16.33           C  
ATOM    662  O   PHE A 578     -13.045  32.683  43.017  1.00 15.80           O  
ATOM    663  CB  PHE A 578     -12.976  30.744  45.450  1.00 16.51           C  
ATOM    664  CG  PHE A 578     -12.201  30.149  46.586  1.00 16.52           C  
ATOM    665  CD1 PHE A 578     -11.657  28.873  46.483  1.00 17.41           C  
ATOM    666  CD2 PHE A 578     -12.030  30.861  47.770  1.00 17.16           C  
ATOM    667  CE1 PHE A 578     -10.955  28.312  47.542  1.00 17.47           C  
ATOM    668  CE2 PHE A 578     -11.330  30.308  48.836  1.00 17.91           C  
ATOM    669  CZ  PHE A 578     -10.793  29.030  48.721  1.00 19.05           C  
ATOM    670  N   CYS A 579     -13.875  30.708  42.336  1.00 16.66           N  
ATOM    671  CA  CYS A 579     -14.752  31.283  41.331  1.00 17.28           C  
ATOM    672  C   CYS A 579     -16.039  30.462  41.360  1.00 17.15           C  
ATOM    673  O   CYS A 579     -16.000  29.237  41.223  1.00 17.02           O  
ATOM    674  CB  CYS A 579     -14.081  31.199  39.956  1.00 21.80           C  
ATOM    675  SG  CYS A 579     -14.966  31.987  38.618  1.00 31.48           S  
ATOM    676  N   ALA A 580     -17.177  31.121  41.556  1.00 15.96           N  
ATOM    677  CA  ALA A 580     -18.434  30.380  41.599  1.00 16.00           C  
ATOM    678  C   ALA A 580     -19.684  31.239  41.525  1.00 14.88           C  
ATOM    679  O   ALA A 580     -19.686  32.407  41.908  1.00 14.55           O  
ATOM    680  CB  ALA A 580     -18.487  29.530  42.858  1.00 16.08           C  
ATOM    681  N   VAL A 581     -20.749  30.627  41.026  1.00 17.12           N  
ATOM    682  CA  VAL A 581     -22.048  31.269  40.919  1.00 16.83           C  
ATOM    683  C   VAL A 581     -23.001  30.246  41.530  1.00 17.49           C  
ATOM    684  O   VAL A 581     -22.864  29.045  41.288  1.00 18.91           O  
ATOM    685  CB  VAL A 581     -22.433  31.554  39.441  1.00 16.68           C  
ATOM    686  CG1 VAL A 581     -23.875  32.033  39.357  1.00 18.14           C  
ATOM    687  CG2 VAL A 581     -21.516  32.628  38.864  1.00 18.00           C  
ATOM    688  N   THR A 582     -23.938  30.706  42.351  1.00 17.46           N  
ATOM    689  CA  THR A 582     -24.872  29.779  42.973  1.00 17.77           C  
ATOM    690  C   THR A 582     -25.610  29.024  41.860  1.00 17.86           C  
ATOM    691  O   THR A 582     -25.920  29.590  40.813  1.00 16.88           O  
ATOM    692  CB  THR A 582     -25.856  30.524  43.899  1.00 18.06           C  
ATOM    693  OG1 THR A 582     -26.596  29.570  44.670  1.00 19.91           O  
ATOM    694  CG2 THR A 582     -26.814  31.386  43.090  1.00 18.01           C  
ATOM    695  N   SER A 583     -25.869  27.741  42.090  1.00 18.43           N  
ATOM    696  CA  SER A 583     -26.513  26.880  41.096  1.00 19.98           C  
ATOM    697  C   SER A 583     -27.731  27.404  40.343  1.00 21.85           C  
ATOM    698  O   SER A 583     -27.783  27.308  39.119  1.00 20.98           O  
ATOM    699  CB  SER A 583     -26.875  25.531  41.724  1.00 20.27           C  
ATOM    700  OG  SER A 583     -25.709  24.818  42.096  1.00 25.55           O  
ATOM    701  N   ASN A 584     -28.713  27.942  41.057  1.00 22.04           N  
ATOM    702  CA  ASN A 584     -29.924  28.420  40.394  1.00 23.26           C  
ATOM    703  C   ASN A 584     -29.723  29.652  39.516  1.00 23.00           C  
ATOM    704  O   ASN A 584     -30.618  30.020  38.757  1.00 24.37           O  
ATOM    705  CB  ASN A 584     -31.027  28.706  41.421  1.00 25.89           C  
ATOM    706  CG  ASN A 584     -30.807  30.000  42.174  1.00 28.86           C  
ATOM    707  OD1 ASN A 584     -29.990  30.071  43.090  1.00 31.21           O  
ATOM    708  ND2 ASN A 584     -31.539  31.042  41.782  1.00 31.51           N  
ATOM    709  N   GLU A 585     -28.557  30.287  39.613  1.00 19.26           N  
ATOM    710  CA  GLU A 585     -28.274  31.475  38.815  1.00 18.50           C  
ATOM    711  C   GLU A 585     -27.250  31.215  37.717  1.00 17.58           C  
ATOM    712  O   GLU A 585     -26.903  32.118  36.950  1.00 17.23           O  
ATOM    713  CB  GLU A 585     -27.794  32.612  39.722  1.00 20.95           C  
ATOM    714  CG  GLU A 585     -28.861  33.090  40.702  1.00 21.53           C  
ATOM    715  CD  GLU A 585     -29.960  33.899  40.036  1.00 24.79           C  
ATOM    716  OE1 GLU A 585     -30.079  33.854  38.795  1.00 23.16           O  
ATOM    717  OE2 GLU A 585     -30.713  34.583  40.763  1.00 26.27           O  
ATOM    718  N   GLN A 586     -26.773  29.978  37.635  1.00 16.61           N  
ATOM    719  CA  GLN A 586     -25.793  29.617  36.616  1.00 17.41           C  
ATOM    720  C   GLN A 586     -26.421  29.484  35.230  1.00 19.32           C  
ATOM    721  O   GLN A 586     -27.647  29.432  35.089  1.00 19.15           O  
ATOM    722  CB  GLN A 586     -25.109  28.299  36.982  1.00 17.33           C  
ATOM    723  CG  GLN A 586     -24.094  28.409  38.116  1.00 16.53           C  
ATOM    724  CD  GLN A 586     -23.402  27.088  38.382  1.00 16.18           C  
ATOM    725  OE1 GLN A 586     -23.233  26.276  37.475  1.00 18.37           O  
ATOM    726  NE2 GLN A 586     -22.987  26.869  39.623  1.00 15.40           N  
ATOM    727  N   VAL A 587     -25.558  29.427  34.218  1.00 18.45           N  
ATOM    728  CA  VAL A 587     -25.958  29.284  32.821  1.00 20.42           C  
ATOM    729  C   VAL A 587     -26.852  30.427  32.337  1.00 21.10           C  
ATOM    730  O   VAL A 587     -27.748  30.229  31.514  1.00 21.15           O  
ATOM    731  CB  VAL A 587     -26.670  27.927  32.592  1.00 23.35           C  
ATOM    732  CG1 VAL A 587     -26.762  27.621  31.102  1.00 25.71           C  
ATOM    733  CG2 VAL A 587     -25.904  26.818  33.309  1.00 26.09           C  
ATOM    734  N   LYS A 588     -26.591  31.625  32.855  1.00 18.18           N  
ATOM    735  CA  LYS A 588     -27.341  32.821  32.480  1.00 17.88           C  
ATOM    736  C   LYS A 588     -26.374  33.900  32.001  1.00 17.39           C  
ATOM    737  O   LYS A 588     -26.791  34.921  31.447  1.00 18.34           O  
ATOM    738  CB  LYS A 588     -28.138  33.352  33.674  1.00 17.60           C  
ATOM    739  CG  LYS A 588     -29.187  32.394  34.197  1.00 18.35           C  
ATOM    740  CD  LYS A 588     -29.937  33.000  35.373  1.00 18.49           C  
ATOM    741  CE  LYS A 588     -31.081  32.098  35.821  1.00 22.13           C  
ATOM    742  NZ  LYS A 588     -31.906  32.735  36.884  1.00 22.47           N  
ATOM    743  N   GLY A 589     -25.082  33.663  32.222  1.00 15.53           N  
ATOM    744  CA  GLY A 589     -24.059  34.607  31.813  1.00 15.60           C  
ATOM    745  C   GLY A 589     -23.330  35.315  32.947  1.00 14.60           C  
ATOM    746  O   GLY A 589     -22.387  36.068  32.697  1.00 14.46           O  
ATOM    747  N   TYR A 590     -23.736  35.065  34.190  1.00 15.50           N  
ATOM    748  CA  TYR A 590     -23.111  35.726  35.337  1.00 15.08           C  
ATOM    749  C   TYR A 590     -21.643  35.377  35.568  1.00 14.52           C  
ATOM    750  O   TYR A 590     -20.847  36.236  35.953  1.00 16.46           O  
ATOM    751  CB  TYR A 590     -23.904  35.440  36.616  1.00 14.74           C  
ATOM    752  CG  TYR A 590     -25.254  36.113  36.658  1.00 16.29           C  
ATOM    753  CD1 TYR A 590     -25.374  37.485  36.433  1.00 15.95           C  
ATOM    754  CD2 TYR A 590     -26.410  35.386  36.938  1.00 18.83           C  
ATOM    755  CE1 TYR A 590     -26.612  38.116  36.488  1.00 20.34           C  
ATOM    756  CE2 TYR A 590     -27.657  36.012  36.997  1.00 18.65           C  
ATOM    757  CZ  TYR A 590     -27.746  37.375  36.771  1.00 19.37           C  
ATOM    758  OH  TYR A 590     -28.967  37.999  36.830  1.00 22.57           O  
ATOM    759  N   GLY A 591     -21.282  34.120  35.338  1.00 15.87           N  
ATOM    760  CA  GLY A 591     -19.902  33.713  35.531  1.00 14.66           C  
ATOM    761  C   GLY A 591     -18.986  34.504  34.620  1.00 14.33           C  
ATOM    762  O   GLY A 591     -17.902  34.930  35.017  1.00 15.16           O  
ATOM    763  N   THR A 592     -19.422  34.700  33.382  1.00 14.07           N  
ATOM    764  CA  THR A 592     -18.640  35.458  32.418  1.00 14.05           C  
ATOM    765  C   THR A 592     -18.687  36.944  32.778  1.00 14.77           C  
ATOM    766  O   THR A 592     -17.694  37.662  32.650  1.00 14.47           O  
ATOM    767  CB  THR A 592     -19.190  35.259  30.993  1.00 15.20           C  
ATOM    768  OG1 THR A 592     -19.053  33.883  30.618  1.00 15.87           O  
ATOM    769  CG2 THR A 592     -18.437  36.137  30.003  1.00 18.10           C  
ATOM    770  N   HIS A 593     -19.848  37.396  33.241  1.00 15.12           N  
ATOM    771  CA  HIS A 593     -20.047  38.791  33.625  1.00 16.47           C  
ATOM    772  C   HIS A 593     -19.082  39.131  34.761  1.00 16.53           C  
ATOM    773  O   HIS A 593     -18.464  40.198  34.776  1.00 17.69           O  
ATOM    774  CB  HIS A 593     -21.501  38.983  34.073  1.00 17.76           C  
ATOM    775  CG  HIS A 593     -22.011  40.386  33.938  1.00 22.36           C  
ATOM    776  ND1 HIS A 593     -21.698  41.193  32.865  1.00 22.28           N  
ATOM    777  CD2 HIS A 593     -22.874  41.095  34.703  1.00 22.74           C  
ATOM    778  CE1 HIS A 593     -22.350  42.338  32.974  1.00 25.53           C  
ATOM    779  NE2 HIS A 593     -23.071  42.303  34.080  1.00 24.30           N  
ATOM    780  N   LEU A 594     -18.954  38.206  35.706  1.00 15.50           N  
ATOM    781  CA  LEU A 594     -18.060  38.386  36.846  1.00 15.74           C  
ATOM    782  C   LEU A 594     -16.604  38.490  36.408  1.00 15.38           C  
ATOM    783  O   LEU A 594     -15.863  39.356  36.878  1.00 14.52           O  
ATOM    784  CB  LEU A 594     -18.211  37.216  37.834  1.00 13.96           C  
ATOM    785  CG  LEU A 594     -19.186  37.404  39.001  1.00 14.98           C  
ATOM    786  CD1 LEU A 594     -19.538  36.053  39.609  1.00 16.97           C  
ATOM    787  CD2 LEU A 594     -18.564  38.335  40.052  1.00 12.84           C  
ATOM    788  N   MET A 595     -16.185  37.606  35.509  1.00 13.11           N  
ATOM    789  CA  MET A 595     -14.796  37.633  35.056  1.00 13.57           C  
ATOM    790  C   MET A 595     -14.508  38.905  34.265  1.00 14.43           C  
ATOM    791  O   MET A 595     -13.440  39.495  34.402  1.00 14.92           O  
ATOM    792  CB  MET A 595     -14.485  36.396  34.207  1.00 13.16           C  
ATOM    793  CG  MET A 595     -12.993  36.192  33.898  1.00 13.65           C  
ATOM    794  SD  MET A 595     -11.967  35.891  35.365  1.00 17.19           S  
ATOM    795  CE  MET A 595     -12.441  34.206  35.732  1.00 16.99           C  
ATOM    796  N   ASN A 596     -15.456  39.337  33.438  1.00 14.80           N  
ATOM    797  CA  ASN A 596     -15.240  40.555  32.668  1.00 16.38           C  
ATOM    798  C   ASN A 596     -15.072  41.741  33.609  1.00 14.49           C  
ATOM    799  O   ASN A 596     -14.217  42.599  33.391  1.00 16.62           O  
ATOM    800  CB  ASN A 596     -16.405  40.812  31.701  1.00 17.99           C  
ATOM    801  CG  ASN A 596     -16.422  39.841  30.540  1.00 19.29           C  
ATOM    802  OD1 ASN A 596     -15.383  39.315  30.141  1.00 19.86           O  
ATOM    803  ND2 ASN A 596     -17.604  39.618  29.970  1.00 21.53           N  
ATOM    804  N   HIS A 597     -15.879  41.786  34.665  1.00 16.99           N  
ATOM    805  CA  HIS A 597     -15.790  42.878  35.631  1.00 16.78           C  
ATOM    806  C   HIS A 597     -14.430  42.848  36.338  1.00 17.15           C  
ATOM    807  O   HIS A 597     -13.824  43.892  36.590  1.00 16.15           O  
ATOM    808  CB  HIS A 597     -16.901  42.755  36.676  1.00 19.88           C  
ATOM    809  CG  HIS A 597     -17.097  43.991  37.496  1.00 24.62           C  
ATOM    810  ND1 HIS A 597     -17.825  45.072  37.048  1.00 26.09           N  
ATOM    811  CD2 HIS A 597     -16.649  44.323  38.730  1.00 26.31           C  
ATOM    812  CE1 HIS A 597     -17.818  46.017  37.972  1.00 28.04           C  
ATOM    813  NE2 HIS A 597     -17.110  45.589  39.001  1.00 26.52           N  
ATOM    814  N   LEU A 598     -13.960  41.644  36.661  1.00 14.84           N  
ATOM    815  CA  LEU A 598     -12.677  41.481  37.338  1.00 14.73           C  
ATOM    816  C   LEU A 598     -11.543  41.952  36.429  1.00 15.14           C  
ATOM    817  O   LEU A 598     -10.559  42.527  36.894  1.00 16.25           O  
ATOM    818  CB  LEU A 598     -12.464  40.012  37.737  1.00 15.13           C  
ATOM    819  CG  LEU A 598     -11.296  39.740  38.697  1.00 14.55           C  
ATOM    820  CD1 LEU A 598     -11.537  40.443  40.025  1.00 17.10           C  
ATOM    821  CD2 LEU A 598     -11.150  38.246  38.919  1.00 16.56           C  
ATOM    822  N   LYS A 599     -11.687  41.712  35.130  1.00 15.41           N  
ATOM    823  CA  LYS A 599     -10.680  42.137  34.164  1.00 17.02           C  
ATOM    824  C   LYS A 599     -10.612  43.663  34.119  1.00 17.44           C  
ATOM    825  O   LYS A 599      -9.525  44.244  34.151  1.00 16.42           O  
ATOM    826  CB  LYS A 599     -11.015  41.582  32.776  1.00 14.65           C  
ATOM    827  CG  LYS A 599     -10.783  40.083  32.650  1.00 15.81           C  
ATOM    828  CD  LYS A 599     -11.174  39.558  31.285  1.00 17.48           C  
ATOM    829  CE  LYS A 599     -10.816  38.083  31.148  1.00 16.28           C  
ATOM    830  NZ  LYS A 599     -11.276  37.524  29.842  1.00 19.62           N  
ATOM    831  N   GLU A 600     -11.772  44.310  34.053  1.00 18.58           N  
ATOM    832  CA  GLU A 600     -11.823  45.769  34.010  1.00 18.93           C  
ATOM    833  C   GLU A 600     -11.163  46.373  35.247  1.00 17.70           C  
ATOM    834  O   GLU A 600     -10.431  47.359  35.158  1.00 16.14           O  
ATOM    835  CB  GLU A 600     -13.271  46.255  33.914  1.00 21.47           C  
ATOM    836  CG  GLU A 600     -13.973  45.854  32.625  1.00 28.78           C  
ATOM    837  CD  GLU A 600     -15.324  46.524  32.465  1.00 33.96           C  
ATOM    838  OE1 GLU A 600     -15.359  47.769  32.329  1.00 36.72           O  
ATOM    839  OE2 GLU A 600     -16.348  45.808  32.480  1.00 37.33           O  
ATOM    840  N   TYR A 601     -11.425  45.764  36.398  1.00 17.26           N  
ATOM    841  CA  TYR A 601     -10.871  46.208  37.677  1.00 16.89           C  
ATOM    842  C   TYR A 601      -9.342  46.137  37.661  1.00 18.27           C  
ATOM    843  O   TYR A 601      -8.651  47.068  38.090  1.00 19.18           O  
ATOM    844  CB  TYR A 601     -11.424  45.316  38.793  1.00 17.90           C  
ATOM    845  CG  TYR A 601     -10.914  45.617  40.182  1.00 17.26           C  
ATOM    846  CD1 TYR A 601     -11.455  46.661  40.944  1.00 20.50           C  
ATOM    847  CD2 TYR A 601      -9.917  44.831  40.758  1.00 16.60           C  
ATOM    848  CE1 TYR A 601     -11.013  46.901  42.249  1.00 18.08           C  
ATOM    849  CE2 TYR A 601      -9.471  45.063  42.052  1.00 17.81           C  
ATOM    850  CZ  TYR A 601     -10.021  46.095  42.793  1.00 19.53           C  
ATOM    851  OH  TYR A 601      -9.579  46.298  44.081  1.00 18.41           O  
ATOM    852  N   HIS A 602      -8.814  45.028  37.156  1.00 17.26           N  
ATOM    853  CA  HIS A 602      -7.373  44.844  37.097  1.00 18.84           C  
ATOM    854  C   HIS A 602      -6.701  45.708  36.045  1.00 18.25           C  
ATOM    855  O   HIS A 602      -5.584  46.170  36.253  1.00 19.01           O  
ATOM    856  CB  HIS A 602      -7.060  43.363  36.897  1.00 16.16           C  
ATOM    857  CG  HIS A 602      -7.289  42.555  38.136  1.00 17.89           C  
ATOM    858  ND1 HIS A 602      -6.289  42.294  39.048  1.00 17.62           N  
ATOM    859  CD2 HIS A 602      -8.431  42.066  38.678  1.00 12.91           C  
ATOM    860  CE1 HIS A 602      -6.806  41.682  40.101  1.00 16.04           C  
ATOM    861  NE2 HIS A 602      -8.103  41.534  39.902  1.00 18.01           N  
ATOM    862  N   ILE A 603      -7.382  45.941  34.928  1.00 19.83           N  
ATOM    863  CA  ILE A 603      -6.822  46.791  33.887  1.00 20.27           C  
ATOM    864  C   ILE A 603      -6.621  48.164  34.525  1.00 22.67           C  
ATOM    865  O   ILE A 603      -5.613  48.832  34.288  1.00 22.41           O  
ATOM    866  CB  ILE A 603      -7.777  46.896  32.663  1.00 21.94           C  
ATOM    867  CG1 ILE A 603      -7.800  45.559  31.915  1.00 19.90           C  
ATOM    868  CG2 ILE A 603      -7.330  48.026  31.738  1.00 22.30           C  
ATOM    869  CD1 ILE A 603      -8.746  45.508  30.733  1.00 20.28           C  
ATOM    870  N   LYS A 604      -7.577  48.564  35.361  1.00 22.26           N  
ATOM    871  CA  LYS A 604      -7.510  49.849  36.048  1.00 23.29           C  
ATOM    872  C   LYS A 604      -6.350  49.901  37.043  1.00 23.30           C  
ATOM    873  O   LYS A 604      -5.783  50.966  37.282  1.00 22.87           O  
ATOM    874  CB  LYS A 604      -8.825  50.125  36.787  1.00 24.75           C  
ATOM    875  CG  LYS A 604      -8.851  51.459  37.516  1.00 30.45           C  
ATOM    876  CD  LYS A 604     -10.173  51.684  38.234  1.00 33.80           C  
ATOM    877  CE  LYS A 604     -10.139  52.976  39.039  1.00 36.69           C  
ATOM    878  NZ  LYS A 604      -9.038  52.966  40.051  1.00 38.83           N  
ATOM    879  N   HIS A 605      -6.004  48.755  37.627  1.00 22.05           N  
ATOM    880  CA  HIS A 605      -4.905  48.687  38.588  1.00 23.84           C  
ATOM    881  C   HIS A 605      -3.600  48.272  37.915  1.00 23.67           C  
ATOM    882  O   HIS A 605      -2.598  48.015  38.578  1.00 24.77           O  
ATOM    883  CB  HIS A 605      -5.235  47.712  39.720  1.00 26.14           C  
ATOM    884  CG  HIS A 605      -6.261  48.228  40.678  1.00 29.93           C  
ATOM    885  ND1 HIS A 605      -7.603  48.291  40.371  1.00 31.99           N  
ATOM    886  CD2 HIS A 605      -6.135  48.746  41.923  1.00 32.29           C  
ATOM    887  CE1 HIS A 605      -8.260  48.827  41.384  1.00 32.38           C  
ATOM    888  NE2 HIS A 605      -7.393  49.112  42.338  1.00 34.66           N  
ATOM    889  N   ASN A 606      -3.638  48.214  36.589  1.00 22.60           N  
ATOM    890  CA  ASN A 606      -2.494  47.856  35.760  1.00 25.04           C  
ATOM    891  C   ASN A 606      -1.872  46.486  36.035  1.00 24.07           C  
ATOM    892  O   ASN A 606      -0.648  46.339  36.036  1.00 24.82           O  
ATOM    893  CB  ASN A 606      -1.418  48.946  35.838  1.00 29.46           C  
ATOM    894  CG  ASN A 606      -0.495  48.941  34.625  1.00 34.10           C  
ATOM    895  OD1 ASN A 606      -0.949  48.812  33.485  1.00 35.92           O  
ATOM    896  ND2 ASN A 606       0.804  49.091  34.864  1.00 37.32           N  
ATOM    897  N   ILE A 607      -2.723  45.491  36.277  1.00 20.11           N  
ATOM    898  CA  ILE A 607      -2.270  44.117  36.482  1.00 19.60           C  
ATOM    899  C   ILE A 607      -2.913  43.393  35.305  1.00 19.98           C  
ATOM    900  O   ILE A 607      -4.136  43.317  35.213  1.00 17.62           O  
ATOM    901  CB  ILE A 607      -2.761  43.536  37.831  1.00 18.36           C  
ATOM    902  CG1 ILE A 607      -2.027  44.238  38.978  1.00 17.95           C  
ATOM    903  CG2 ILE A 607      -2.522  42.025  37.880  1.00 19.15           C  
ATOM    904  CD1 ILE A 607      -2.475  43.819  40.359  1.00 19.09           C  
ATOM    905  N   LEU A 608      -2.085  42.881  34.399  1.00 19.40           N  
ATOM    906  CA  LEU A 608      -2.588  42.236  33.193  1.00 17.72           C  
ATOM    907  C   LEU A 608      -2.459  40.721  33.085  1.00 18.19           C  
ATOM    908  O   LEU A 608      -2.491  40.175  31.981  1.00 19.65           O  
ATOM    909  CB  LEU A 608      -1.931  42.893  31.974  1.00 18.74           C  
ATOM    910  CG  LEU A 608      -2.107  44.417  31.932  1.00 20.10           C  
ATOM    911  CD1 LEU A 608      -1.401  44.995  30.714  1.00 21.59           C  
ATOM    912  CD2 LEU A 608      -3.597  44.756  31.911  1.00 20.49           C  
ATOM    913  N   TYR A 609      -2.330  40.042  34.218  1.00 15.77           N  
ATOM    914  CA  TYR A 609      -2.208  38.589  34.213  1.00 16.28           C  
ATOM    915  C   TYR A 609      -2.941  37.929  35.367  1.00 16.18           C  
ATOM    916  O   TYR A 609      -2.829  38.368  36.511  1.00 15.10           O  
ATOM    917  CB  TYR A 609      -0.734  38.175  34.273  1.00 16.94           C  
ATOM    918  CG  TYR A 609      -0.003  38.376  32.975  1.00 17.98           C  
ATOM    919  CD1 TYR A 609      -0.080  37.427  31.956  1.00 18.01           C  
ATOM    920  CD2 TYR A 609       0.715  39.546  32.736  1.00 19.50           C  
ATOM    921  CE1 TYR A 609       0.541  37.640  30.728  1.00 19.91           C  
ATOM    922  CE2 TYR A 609       1.336  39.770  31.511  1.00 20.28           C  
ATOM    923  CZ  TYR A 609       1.242  38.812  30.516  1.00 18.63           C  
ATOM    924  OH  TYR A 609       1.840  39.032  29.301  1.00 21.90           O  
ATOM    925  N   PHE A 610      -3.691  36.875  35.049  1.00 15.42           N  
ATOM    926  CA  PHE A 610      -4.406  36.097  36.050  1.00 15.35           C  
ATOM    927  C   PHE A 610      -3.788  34.704  36.009  1.00 15.47           C  
ATOM    928  O   PHE A 610      -3.500  34.187  34.931  1.00 16.95           O  
ATOM    929  CB  PHE A 610      -5.901  35.931  35.715  1.00 15.69           C  
ATOM    930  CG  PHE A 610      -6.729  37.185  35.857  1.00 16.56           C  
ATOM    931  CD1 PHE A 610      -6.349  38.214  36.717  1.00 17.57           C  
ATOM    932  CD2 PHE A 610      -7.940  37.296  35.173  1.00 16.47           C  
ATOM    933  CE1 PHE A 610      -7.172  39.336  36.895  1.00 17.97           C  
ATOM    934  CE2 PHE A 610      -8.766  38.410  35.344  1.00 17.92           C  
ATOM    935  CZ  PHE A 610      -8.380  39.431  36.208  1.00 16.18           C  
ATOM    936  N   LEU A 611      -3.573  34.115  37.179  1.00 15.41           N  
ATOM    937  CA  LEU A 611      -3.053  32.756  37.281  1.00 15.48           C  
ATOM    938  C   LEU A 611      -4.041  32.002  38.158  1.00 14.66           C  
ATOM    939  O   LEU A 611      -4.566  32.558  39.115  1.00 14.92           O  
ATOM    940  CB  LEU A 611      -1.660  32.735  37.922  1.00 16.20           C  
ATOM    941  CG  LEU A 611      -0.509  33.193  37.023  1.00 14.49           C  
ATOM    942  CD1 LEU A 611       0.793  33.174  37.817  1.00 17.37           C  
ATOM    943  CD2 LEU A 611      -0.410  32.280  35.806  1.00 16.28           C  
ATOM    944  N   THR A 612      -4.304  30.745  37.831  1.00 15.26           N  
ATOM    945  CA  THR A 612      -5.250  29.965  38.616  1.00 15.36           C  
ATOM    946  C   THR A 612      -5.060  28.472  38.385  1.00 15.82           C  
ATOM    947  O   THR A 612      -4.523  28.060  37.358  1.00 15.74           O  
ATOM    948  CB  THR A 612      -6.723  30.357  38.255  1.00 16.44           C  
ATOM    949  OG1 THR A 612      -7.624  29.820  39.231  1.00 16.79           O  
ATOM    950  CG2 THR A 612      -7.111  29.813  36.885  1.00 16.43           C  
ATOM    951  N   TYR A 613      -5.474  27.674  39.364  1.00 16.26           N  
ATOM    952  CA  TYR A 613      -5.404  26.223  39.260  1.00 17.55           C  
ATOM    953  C   TYR A 613      -6.827  25.740  39.032  1.00 16.88           C  
ATOM    954  O   TYR A 613      -7.667  25.790  39.928  1.00 16.51           O  
ATOM    955  CB  TYR A 613      -4.823  25.616  40.539  1.00 18.00           C  
ATOM    956  CG  TYR A 613      -3.313  25.573  40.530  1.00 18.92           C  
ATOM    957  CD1 TYR A 613      -2.628  24.571  39.841  1.00 21.79           C  
ATOM    958  CD2 TYR A 613      -2.567  26.551  41.180  1.00 21.65           C  
ATOM    959  CE1 TYR A 613      -1.238  24.548  39.804  1.00 23.49           C  
ATOM    960  CE2 TYR A 613      -1.180  26.538  41.146  1.00 22.60           C  
ATOM    961  CZ  TYR A 613      -0.521  25.537  40.459  1.00 24.17           C  
ATOM    962  OH  TYR A 613       0.855  25.530  40.432  1.00 26.01           O  
ATOM    963  N   ALA A 614      -7.092  25.272  37.818  1.00 16.27           N  
ATOM    964  CA  ALA A 614      -8.426  24.817  37.463  1.00 18.67           C  
ATOM    965  C   ALA A 614      -8.651  23.321  37.607  1.00 19.14           C  
ATOM    966  O   ALA A 614      -7.801  22.513  37.233  1.00 17.70           O  
ATOM    967  CB  ALA A 614      -8.741  25.236  36.032  1.00 16.18           C  
ATOM    968  N   ASP A 615      -9.808  22.964  38.155  1.00 20.88           N  
ATOM    969  CA  ASP A 615     -10.178  21.563  38.281  1.00 22.94           C  
ATOM    970  C   ASP A 615     -10.356  21.170  36.819  1.00 21.19           C  
ATOM    971  O   ASP A 615     -10.684  22.019  35.992  1.00 20.74           O  
ATOM    972  CB  ASP A 615     -11.507  21.427  39.025  1.00 28.19           C  
ATOM    973  CG  ASP A 615     -11.424  21.919  40.457  1.00 34.47           C  
ATOM    974  OD1 ASP A 615     -10.660  21.319  41.246  1.00 36.96           O  
ATOM    975  OD2 ASP A 615     -12.117  22.904  40.792  1.00 38.09           O  
ATOM    976  N   GLU A 616     -10.153  19.902  36.486  1.00 19.41           N  
ATOM    977  CA  GLU A 616     -10.287  19.499  35.091  1.00 18.45           C  
ATOM    978  C   GLU A 616     -11.651  19.807  34.465  1.00 17.34           C  
ATOM    979  O   GLU A 616     -11.720  20.229  33.313  1.00 17.88           O  
ATOM    980  CB  GLU A 616      -9.976  18.007  34.935  1.00 19.09           C  
ATOM    981  CG  GLU A 616     -10.215  17.476  33.520  1.00 19.90           C  
ATOM    982  CD  GLU A 616      -9.695  16.062  33.312  1.00 21.34           C  
ATOM    983  OE1 GLU A 616      -9.864  15.222  34.218  1.00 20.37           O  
ATOM    984  OE2 GLU A 616      -9.131  15.787  32.230  1.00 20.69           O  
ATOM    985  N   TYR A 617     -12.731  19.614  35.216  1.00 17.42           N  
ATOM    986  CA  TYR A 617     -14.061  19.845  34.660  1.00 18.57           C  
ATOM    987  C   TYR A 617     -14.505  21.299  34.560  1.00 18.13           C  
ATOM    988  O   TYR A 617     -15.640  21.574  34.170  1.00 18.80           O  
ATOM    989  CB  TYR A 617     -15.103  19.042  35.438  1.00 17.68           C  
ATOM    990  CG  TYR A 617     -14.796  17.563  35.510  1.00 18.72           C  
ATOM    991  CD1 TYR A 617     -13.962  16.953  34.571  1.00 19.19           C  
ATOM    992  CD2 TYR A 617     -15.328  16.773  36.528  1.00 19.27           C  
ATOM    993  CE1 TYR A 617     -13.661  15.590  34.651  1.00 20.12           C  
ATOM    994  CE2 TYR A 617     -15.036  15.415  36.617  1.00 19.52           C  
ATOM    995  CZ  TYR A 617     -14.204  14.830  35.683  1.00 20.44           C  
ATOM    996  OH  TYR A 617     -13.900  13.491  35.798  1.00 21.18           O  
ATOM    997  N   ALA A 618     -13.612  22.222  34.903  1.00 18.57           N  
ATOM    998  CA  ALA A 618     -13.916  23.649  34.826  1.00 16.43           C  
ATOM    999  C   ALA A 618     -13.020  24.319  33.781  1.00 17.66           C  
ATOM   1000  O   ALA A 618     -13.211  25.485  33.445  1.00 15.94           O  
ATOM   1001  CB  ALA A 618     -13.707  24.308  36.192  1.00 17.62           C  
ATOM   1002  N   ILE A 619     -12.050  23.575  33.259  1.00 18.33           N  
ATOM   1003  CA  ILE A 619     -11.127  24.132  32.274  1.00 18.57           C  
ATOM   1004  C   ILE A 619     -11.823  24.907  31.154  1.00 18.61           C  
ATOM   1005  O   ILE A 619     -11.384  26.000  30.788  1.00 17.57           O  
ATOM   1006  CB  ILE A 619     -10.235  23.025  31.650  1.00 17.88           C  
ATOM   1007  CG1 ILE A 619      -9.281  22.472  32.712  1.00 17.44           C  
ATOM   1008  CG2 ILE A 619      -9.434  23.587  30.478  1.00 18.60           C  
ATOM   1009  CD1 ILE A 619      -8.369  21.354  32.198  1.00 17.23           C  
ATOM   1010  N   GLY A 620     -12.910  24.348  30.625  1.00 17.53           N  
ATOM   1011  CA  GLY A 620     -13.634  24.997  29.545  1.00 17.02           C  
ATOM   1012  C   GLY A 620     -14.153  26.385  29.880  1.00 18.34           C  
ATOM   1013  O   GLY A 620     -14.252  27.246  29.007  1.00 16.15           O  
ATOM   1014  N   TYR A 621     -14.513  26.601  31.138  1.00 16.96           N  
ATOM   1015  CA  TYR A 621     -14.999  27.910  31.551  1.00 17.48           C  
ATOM   1016  C   TYR A 621     -13.850  28.900  31.422  1.00 15.04           C  
ATOM   1017  O   TYR A 621     -13.998  29.975  30.846  1.00 16.32           O  
ATOM   1018  CB  TYR A 621     -15.490  27.875  33.004  1.00 17.48           C  
ATOM   1019  CG  TYR A 621     -15.609  29.250  33.630  1.00 17.24           C  
ATOM   1020  CD1 TYR A 621     -16.631  30.127  33.261  1.00 19.30           C  
ATOM   1021  CD2 TYR A 621     -14.671  29.690  34.563  1.00 18.63           C  
ATOM   1022  CE1 TYR A 621     -16.709  31.409  33.808  1.00 15.73           C  
ATOM   1023  CE2 TYR A 621     -14.738  30.965  35.113  1.00 17.91           C  
ATOM   1024  CZ  TYR A 621     -15.756  31.820  34.733  1.00 18.01           C  
ATOM   1025  OH  TYR A 621     -15.812  33.084  35.288  1.00 17.49           O  
ATOM   1026  N   PHE A 622     -12.691  28.534  31.952  1.00 15.93           N  
ATOM   1027  CA  PHE A 622     -11.554  29.429  31.880  1.00 15.19           C  
ATOM   1028  C   PHE A 622     -11.123  29.681  30.439  1.00 15.03           C  
ATOM   1029  O   PHE A 622     -10.749  30.800  30.088  1.00 15.29           O  
ATOM   1030  CB  PHE A 622     -10.417  28.885  32.738  1.00 15.80           C  
ATOM   1031  CG  PHE A 622     -10.708  28.958  34.212  1.00 13.71           C  
ATOM   1032  CD1 PHE A 622     -10.681  30.183  34.874  1.00 16.70           C  
ATOM   1033  CD2 PHE A 622     -11.069  27.818  34.921  1.00 17.55           C  
ATOM   1034  CE1 PHE A 622     -11.016  30.274  36.228  1.00 17.45           C  
ATOM   1035  CE2 PHE A 622     -11.406  27.895  36.275  1.00 17.75           C  
ATOM   1036  CZ  PHE A 622     -11.379  29.127  36.928  1.00 17.93           C  
ATOM   1037  N   LYS A 623     -11.195  28.655  29.598  1.00 14.78           N  
ATOM   1038  CA  LYS A 623     -10.821  28.833  28.200  1.00 16.38           C  
ATOM   1039  C   LYS A 623     -11.743  29.859  27.542  1.00 16.69           C  
ATOM   1040  O   LYS A 623     -11.296  30.693  26.758  1.00 15.94           O  
ATOM   1041  CB  LYS A 623     -10.887  27.504  27.440  1.00 19.16           C  
ATOM   1042  CG  LYS A 623      -9.785  26.521  27.828  1.00 24.28           C  
ATOM   1043  CD  LYS A 623      -9.761  25.303  26.912  1.00 29.22           C  
ATOM   1044  CE  LYS A 623      -9.397  25.687  25.486  1.00 31.31           C  
ATOM   1045  NZ  LYS A 623      -9.298  24.496  24.591  1.00 35.49           N  
ATOM   1046  N   LYS A 624     -13.031  29.813  27.859  1.00 17.85           N  
ATOM   1047  CA  LYS A 624     -13.935  30.780  27.260  1.00 20.85           C  
ATOM   1048  C   LYS A 624     -13.571  32.192  27.705  1.00 19.97           C  
ATOM   1049  O   LYS A 624     -13.756  33.150  26.957  1.00 21.02           O  
ATOM   1050  CB  LYS A 624     -15.389  30.489  27.624  1.00 20.82           C  
ATOM   1051  CG  LYS A 624     -16.333  31.556  27.084  1.00 25.32           C  
ATOM   1052  CD  LYS A 624     -17.762  31.081  27.006  1.00 30.09           C  
ATOM   1053  CE  LYS A 624     -18.691  32.202  26.535  1.00 32.19           C  
ATOM   1054  NZ  LYS A 624     -18.719  33.349  27.489  1.00 31.17           N  
ATOM   1055  N   GLN A 625     -13.043  32.318  28.920  1.00 19.47           N  
ATOM   1056  CA  GLN A 625     -12.659  33.624  29.445  1.00 19.21           C  
ATOM   1057  C   GLN A 625     -11.261  34.029  28.976  1.00 18.96           C  
ATOM   1058  O   GLN A 625     -10.691  34.998  29.467  1.00 20.49           O  
ATOM   1059  CB  GLN A 625     -12.711  33.623  30.978  1.00 17.93           C  
ATOM   1060  CG  GLN A 625     -13.962  32.972  31.553  1.00 17.80           C  
ATOM   1061  CD  GLN A 625     -15.261  33.554  31.003  1.00 18.87           C  
ATOM   1062  OE1 GLN A 625     -16.293  32.886  30.999  1.00 18.51           O  
ATOM   1063  NE2 GLN A 625     -15.217  34.802  30.552  1.00 17.54           N  
ATOM   1064  N   GLY A 626     -10.706  33.276  28.031  1.00 19.04           N  
ATOM   1065  CA  GLY A 626      -9.397  33.608  27.507  1.00 18.84           C  
ATOM   1066  C   GLY A 626      -8.192  33.050  28.243  1.00 18.92           C  
ATOM   1067  O   GLY A 626      -7.070  33.509  28.018  1.00 20.46           O  
ATOM   1068  N   PHE A 627      -8.406  32.078  29.125  1.00 17.36           N  
ATOM   1069  CA  PHE A 627      -7.303  31.470  29.861  1.00 17.00           C  
ATOM   1070  C   PHE A 627      -6.681  30.388  28.986  1.00 19.19           C  
ATOM   1071  O   PHE A 627      -7.325  29.873  28.070  1.00 17.80           O  
ATOM   1072  CB  PHE A 627      -7.792  30.829  31.166  1.00 17.20           C  
ATOM   1073  CG  PHE A 627      -8.070  31.811  32.275  1.00 15.34           C  
ATOM   1074  CD1 PHE A 627      -7.350  31.746  33.463  1.00 17.30           C  
ATOM   1075  CD2 PHE A 627      -9.084  32.758  32.159  1.00 16.84           C  
ATOM   1076  CE1 PHE A 627      -7.632  32.603  34.527  1.00 16.13           C  
ATOM   1077  CE2 PHE A 627      -9.374  33.620  33.221  1.00 15.83           C  
ATOM   1078  CZ  PHE A 627      -8.647  33.540  34.407  1.00 15.26           C  
ATOM   1079  N   SER A 628      -5.432  30.041  29.280  1.00 18.51           N  
ATOM   1080  CA  SER A 628      -4.713  29.024  28.523  1.00 20.15           C  
ATOM   1081  C   SER A 628      -3.803  28.215  29.435  1.00 19.70           C  
ATOM   1082  O   SER A 628      -3.448  28.669  30.524  1.00 19.91           O  
ATOM   1083  CB  SER A 628      -3.872  29.692  27.431  1.00 20.23           C  
ATOM   1084  OG  SER A 628      -3.035  28.755  26.782  1.00 26.65           O  
ATOM   1085  N   LYS A 629      -3.433  27.017  28.987  1.00 19.60           N  
ATOM   1086  CA  LYS A 629      -2.539  26.150  29.742  1.00 22.26           C  
ATOM   1087  C   LYS A 629      -1.097  26.611  29.511  1.00 21.78           C  
ATOM   1088  O   LYS A 629      -0.177  26.179  30.209  1.00 22.69           O  
ATOM   1089  CB  LYS A 629      -2.696  24.693  29.296  1.00 24.26           C  
ATOM   1090  CG  LYS A 629      -4.070  24.091  29.568  1.00 27.66           C  
ATOM   1091  CD  LYS A 629      -4.109  22.628  29.146  1.00 30.50           C  
ATOM   1092  CE  LYS A 629      -5.448  21.980  29.467  1.00 32.05           C  
ATOM   1093  NZ  LYS A 629      -6.580  22.657  28.768  1.00 35.71           N  
ATOM   1094  N   ASP A 630      -0.914  27.484  28.522  1.00 22.09           N  
ATOM   1095  CA  ASP A 630       0.399  28.043  28.194  1.00 23.27           C  
ATOM   1096  C   ASP A 630       0.656  29.212  29.143  1.00 23.15           C  
ATOM   1097  O   ASP A 630      -0.013  30.242  29.061  1.00 23.02           O  
ATOM   1098  CB  ASP A 630       0.411  28.547  26.747  1.00 24.01           C  
ATOM   1099  CG  ASP A 630       0.204  27.433  25.738  1.00 27.50           C  
ATOM   1100  OD1 ASP A 630      -0.138  27.743  24.577  1.00 29.40           O  
ATOM   1101  OD2 ASP A 630       0.392  26.252  26.102  1.00 27.97           O  
ATOM   1102  N   ILE A 631       1.629  29.049  30.034  1.00 23.49           N  
ATOM   1103  CA  ILE A 631       1.951  30.068  31.031  1.00 22.05           C  
ATOM   1104  C   ILE A 631       3.101  30.992  30.633  1.00 23.00           C  
ATOM   1105  O   ILE A 631       4.214  30.534  30.380  1.00 25.19           O  
ATOM   1106  CB  ILE A 631       2.303  29.400  32.384  1.00 20.27           C  
ATOM   1107  CG1 ILE A 631       1.302  28.278  32.689  1.00 19.67           C  
ATOM   1108  CG2 ILE A 631       2.304  30.442  33.502  1.00 20.90           C  
ATOM   1109  CD1 ILE A 631      -0.145  28.710  32.693  1.00 17.89           C  
ATOM   1110  N   LYS A 632       2.831  32.295  30.596  1.00 22.75           N  
ATOM   1111  CA  LYS A 632       3.846  33.282  30.233  1.00 23.75           C  
ATOM   1112  C   LYS A 632       4.550  33.887  31.453  1.00 22.13           C  
ATOM   1113  O   LYS A 632       5.695  34.316  31.357  1.00 22.25           O  
ATOM   1114  CB  LYS A 632       3.230  34.395  29.379  1.00 26.39           C  
ATOM   1115  CG  LYS A 632       2.790  33.943  27.990  1.00 30.26           C  
ATOM   1116  CD  LYS A 632       2.167  35.094  27.208  1.00 33.63           C  
ATOM   1117  CE  LYS A 632       1.693  34.644  25.833  1.00 34.66           C  
ATOM   1118  NZ  LYS A 632       0.644  33.587  25.921  1.00 35.63           N  
ATOM   1119  N   VAL A 633       3.869  33.953  32.593  1.00 20.04           N  
ATOM   1120  CA  VAL A 633       4.520  34.486  33.793  1.00 19.89           C  
ATOM   1121  C   VAL A 633       5.595  33.464  34.178  1.00 18.57           C  
ATOM   1122  O   VAL A 633       5.310  32.274  34.299  1.00 18.70           O  
ATOM   1123  CB  VAL A 633       3.517  34.652  34.962  1.00 20.84           C  
ATOM   1124  CG1 VAL A 633       4.260  34.979  36.253  1.00 18.21           C  
ATOM   1125  CG2 VAL A 633       2.529  35.769  34.637  1.00 20.53           C  
ATOM   1126  N   PRO A 634       6.850  33.911  34.355  1.00 17.57           N  
ATOM   1127  CA  PRO A 634       7.921  32.975  34.720  1.00 18.09           C  
ATOM   1128  C   PRO A 634       7.640  32.250  36.029  1.00 17.67           C  
ATOM   1129  O   PRO A 634       7.091  32.832  36.959  1.00 18.74           O  
ATOM   1130  CB  PRO A 634       9.154  33.880  34.809  1.00 17.05           C  
ATOM   1131  CG  PRO A 634       8.845  34.964  33.824  1.00 20.00           C  
ATOM   1132  CD  PRO A 634       7.392  35.261  34.129  1.00 17.89           C  
ATOM   1133  N   LYS A 635       8.023  30.977  36.094  1.00 17.77           N  
ATOM   1134  CA  LYS A 635       7.813  30.167  37.288  1.00 18.62           C  
ATOM   1135  C   LYS A 635       8.452  30.790  38.530  1.00 19.35           C  
ATOM   1136  O   LYS A 635       7.905  30.700  39.629  1.00 20.66           O  
ATOM   1137  CB  LYS A 635       8.378  28.758  37.069  1.00 19.11           C  
ATOM   1138  CG  LYS A 635       8.210  27.824  38.263  1.00 20.26           C  
ATOM   1139  CD  LYS A 635       8.714  26.433  37.930  1.00 20.18           C  
ATOM   1140  CE  LYS A 635       8.389  25.437  39.034  1.00 20.85           C  
ATOM   1141  NZ  LYS A 635       8.809  24.058  38.650  1.00 25.16           N  
ATOM   1142  N   SER A 636       9.607  31.424  38.359  1.00 19.72           N  
ATOM   1143  CA  SER A 636      10.295  32.046  39.492  1.00 21.32           C  
ATOM   1144  C   SER A 636       9.470  33.192  40.070  1.00 22.21           C  
ATOM   1145  O   SER A 636       9.674  33.601  41.214  1.00 22.51           O  
ATOM   1146  CB  SER A 636      11.657  32.582  39.056  1.00 22.79           C  
ATOM   1147  OG  SER A 636      11.502  33.649  38.139  1.00 27.12           O  
ATOM   1148  N   ARG A 637       8.538  33.703  39.274  1.00 20.05           N  
ATOM   1149  CA  ARG A 637       7.686  34.805  39.703  1.00 20.61           C  
ATOM   1150  C   ARG A 637       6.431  34.374  40.460  1.00 18.65           C  
ATOM   1151  O   ARG A 637       5.879  35.158  41.234  1.00 20.13           O  
ATOM   1152  CB  ARG A 637       7.294  35.656  38.495  1.00 23.20           C  
ATOM   1153  CG  ARG A 637       8.460  36.412  37.878  1.00 28.81           C  
ATOM   1154  CD  ARG A 637       8.363  37.910  38.148  1.00 33.69           C  
ATOM   1155  NE  ARG A 637       7.748  38.641  37.038  1.00 39.16           N  
ATOM   1156  CZ  ARG A 637       6.499  38.470  36.615  1.00 41.36           C  
ATOM   1157  NH1 ARG A 637       5.702  37.591  37.206  1.00 43.45           N  
ATOM   1158  NH2 ARG A 637       6.044  39.179  35.589  1.00 44.78           N  
ATOM   1159  N   TYR A 638       5.977  33.141  40.251  1.00 16.52           N  
ATOM   1160  CA  TYR A 638       4.775  32.683  40.946  1.00 15.97           C  
ATOM   1161  C   TYR A 638       4.982  31.543  41.939  1.00 14.95           C  
ATOM   1162  O   TYR A 638       4.150  31.335  42.820  1.00 17.11           O  
ATOM   1163  CB  TYR A 638       3.673  32.307  39.938  1.00 15.20           C  
ATOM   1164  CG  TYR A 638       3.955  31.109  39.055  1.00 16.48           C  
ATOM   1165  CD1 TYR A 638       3.971  29.814  39.576  1.00 16.65           C  
ATOM   1166  CD2 TYR A 638       4.184  31.269  37.691  1.00 17.07           C  
ATOM   1167  CE1 TYR A 638       4.209  28.708  38.754  1.00 19.05           C  
ATOM   1168  CE2 TYR A 638       4.421  30.178  36.865  1.00 17.62           C  
ATOM   1169  CZ  TYR A 638       4.435  28.902  37.399  1.00 16.38           C  
ATOM   1170  OH  TYR A 638       4.697  27.824  36.583  1.00 18.26           O  
ATOM   1171  N   LEU A 639       6.081  30.804  41.803  1.00 16.57           N  
ATOM   1172  CA  LEU A 639       6.344  29.699  42.719  1.00 17.16           C  
ATOM   1173  C   LEU A 639       6.438  30.227  44.146  1.00 16.96           C  
ATOM   1174  O   LEU A 639       7.223  31.127  44.433  1.00 18.28           O  
ATOM   1175  CB  LEU A 639       7.651  28.980  42.355  1.00 18.38           C  
ATOM   1176  CG  LEU A 639       8.031  27.824  43.297  1.00 18.85           C  
ATOM   1177  CD1 LEU A 639       6.933  26.778  43.278  1.00 20.26           C  
ATOM   1178  CD2 LEU A 639       9.356  27.207  42.880  1.00 19.84           C  
ATOM   1179  N   GLY A 640       5.633  29.667  45.039  1.00 16.16           N  
ATOM   1180  CA  GLY A 640       5.664  30.117  46.419  1.00 16.84           C  
ATOM   1181  C   GLY A 640       4.795  31.338  46.659  1.00 18.05           C  
ATOM   1182  O   GLY A 640       4.661  31.798  47.795  1.00 18.21           O  
ATOM   1183  N   TYR A 641       4.221  31.878  45.586  1.00 17.15           N  
ATOM   1184  CA  TYR A 641       3.329  33.034  45.693  1.00 18.84           C  
ATOM   1185  C   TYR A 641       1.906  32.505  45.599  1.00 19.15           C  
ATOM   1186  O   TYR A 641       1.097  32.704  46.504  1.00 20.17           O  
ATOM   1187  CB  TYR A 641       3.600  34.038  44.567  1.00 16.23           C  
ATOM   1188  CG  TYR A 641       4.822  34.891  44.810  1.00 20.70           C  
ATOM   1189  CD1 TYR A 641       4.713  36.142  45.419  1.00 19.91           C  
ATOM   1190  CD2 TYR A 641       6.094  34.427  44.480  1.00 20.13           C  
ATOM   1191  CE1 TYR A 641       5.840  36.908  45.693  1.00 21.09           C  
ATOM   1192  CE2 TYR A 641       7.230  35.187  44.751  1.00 23.77           C  
ATOM   1193  CZ  TYR A 641       7.095  36.426  45.358  1.00 24.18           C  
ATOM   1194  OH  TYR A 641       8.216  37.181  45.625  1.00 27.07           O  
ATOM   1195  N   ILE A 642       1.602  31.824  44.501  1.00 20.32           N  
ATOM   1196  CA  ILE A 642       0.277  31.251  44.328  1.00 21.25           C  
ATOM   1197  C   ILE A 642       0.248  29.891  45.010  1.00 22.52           C  
ATOM   1198  O   ILE A 642       1.284  29.244  45.168  1.00 21.98           O  
ATOM   1199  CB  ILE A 642      -0.079  31.080  42.836  1.00 20.51           C  
ATOM   1200  CG1 ILE A 642       0.920  30.143  42.151  1.00 21.64           C  
ATOM   1201  CG2 ILE A 642      -0.096  32.442  42.158  1.00 21.42           C  
ATOM   1202  CD1 ILE A 642       0.606  29.879  40.684  1.00 20.81           C  
ATOM   1203  N   LYS A 643      -0.937  29.468  45.430  1.00 23.02           N  
ATOM   1204  CA  LYS A 643      -1.092  28.177  46.079  1.00 25.33           C  
ATOM   1205  C   LYS A 643      -1.367  27.103  45.032  1.00 27.02           C  
ATOM   1206  O   LYS A 643      -2.230  27.272  44.174  1.00 27.77           O  
ATOM   1207  CB  LYS A 643      -2.236  28.236  47.093  1.00 25.26           C  
ATOM   1208  CG  LYS A 643      -1.993  29.240  48.209  1.00 26.77           C  
ATOM   1209  CD  LYS A 643      -3.194  29.369  49.128  1.00 29.61           C  
ATOM   1210  CE  LYS A 643      -2.882  30.267  50.322  1.00 31.74           C  
ATOM   1211  NZ  LYS A 643      -2.461  31.640  49.920  1.00 32.30           N  
ATOM   1212  N   ASP A 644      -0.620  26.007  45.089  1.00 28.86           N  
ATOM   1213  CA  ASP A 644      -0.821  24.920  44.142  1.00 30.57           C  
ATOM   1214  C   ASP A 644      -1.810  23.917  44.719  1.00 31.79           C  
ATOM   1215  O   ASP A 644      -1.859  23.710  45.933  1.00 31.20           O  
ATOM   1216  CB  ASP A 644       0.516  24.247  43.813  1.00 33.75           C  
ATOM   1217  CG  ASP A 644       1.357  23.981  45.043  1.00 34.99           C  
ATOM   1218  OD1 ASP A 644       0.969  23.120  45.858  1.00 37.64           O  
ATOM   1219  OD2 ASP A 644       2.406  24.644  45.196  1.00 39.98           O  
ATOM   1220  N   TYR A 645      -2.609  23.306  43.850  1.00 33.15           N  
ATOM   1221  CA  TYR A 645      -3.609  22.340  44.288  1.00 35.49           C  
ATOM   1222  C   TYR A 645      -3.436  20.960  43.669  1.00 37.83           C  
ATOM   1223  O   TYR A 645      -2.774  20.797  42.642  1.00 39.57           O  
ATOM   1224  CB  TYR A 645      -5.019  22.859  43.988  1.00 34.43           C  
ATOM   1225  CG  TYR A 645      -5.373  24.123  44.736  1.00 34.47           C  
ATOM   1226  CD1 TYR A 645      -4.856  25.358  44.344  1.00 34.52           C  
ATOM   1227  CD2 TYR A 645      -6.205  24.080  45.855  1.00 34.98           C  
ATOM   1228  CE1 TYR A 645      -5.158  26.522  45.050  1.00 34.45           C  
ATOM   1229  CE2 TYR A 645      -6.513  25.239  46.568  1.00 35.23           C  
ATOM   1230  CZ  TYR A 645      -5.986  26.454  46.160  1.00 35.62           C  
ATOM   1231  OH  TYR A 645      -6.281  27.596  46.867  1.00 35.49           O  
ATOM   1232  N   GLU A 646      -4.056  19.973  44.310  1.00 38.06           N  
ATOM   1233  CA  GLU A 646      -3.993  18.582  43.879  1.00 38.16           C  
ATOM   1234  C   GLU A 646      -4.844  18.296  42.641  1.00 37.16           C  
ATOM   1235  O   GLU A 646      -6.043  18.579  42.618  1.00 37.58           O  
ATOM   1236  CB  GLU A 646      -4.447  17.672  45.026  1.00 39.69           C  
ATOM   1237  CG  GLU A 646      -4.343  16.183  44.728  1.00 42.16           C  
ATOM   1238  CD  GLU A 646      -2.920  15.669  44.804  1.00 43.78           C  
ATOM   1239  OE1 GLU A 646      -2.685  14.509  44.408  1.00 45.11           O  
ATOM   1240  OE2 GLU A 646      -2.037  16.420  45.269  1.00 44.44           O  
ATOM   1241  N   GLY A 647      -4.211  17.726  41.619  1.00 36.09           N  
ATOM   1242  CA  GLY A 647      -4.913  17.380  40.394  1.00 34.11           C  
ATOM   1243  C   GLY A 647      -5.472  18.532  39.579  1.00 33.37           C  
ATOM   1244  O   GLY A 647      -6.295  18.318  38.689  1.00 33.78           O  
ATOM   1245  N   ALA A 648      -5.033  19.751  39.868  1.00 31.07           N  
ATOM   1246  CA  ALA A 648      -5.518  20.913  39.131  1.00 28.65           C  
ATOM   1247  C   ALA A 648      -4.535  21.312  38.038  1.00 27.25           C  
ATOM   1248  O   ALA A 648      -3.358  20.952  38.085  1.00 28.08           O  
ATOM   1249  CB  ALA A 648      -5.751  22.084  40.084  1.00 28.76           C  
ATOM   1250  N   THR A 649      -5.026  22.051  37.047  1.00 23.38           N  
ATOM   1251  CA  THR A 649      -4.194  22.508  35.942  1.00 21.28           C  
ATOM   1252  C   THR A 649      -3.952  24.012  36.033  1.00 20.04           C  
ATOM   1253  O   THR A 649      -4.901  24.801  36.065  1.00 19.60           O  
ATOM   1254  CB  THR A 649      -4.860  22.202  34.579  1.00 22.18           C  
ATOM   1255  OG1 THR A 649      -5.077  20.789  34.454  1.00 21.58           O  
ATOM   1256  CG2 THR A 649      -3.970  22.670  33.434  1.00 24.22           C  
ATOM   1257  N   LEU A 650      -2.684  24.407  36.084  1.00 19.32           N  
ATOM   1258  CA  LEU A 650      -2.339  25.822  36.152  1.00 18.00           C  
ATOM   1259  C   LEU A 650      -2.728  26.464  34.829  1.00 17.56           C  
ATOM   1260  O   LEU A 650      -2.386  25.957  33.757  1.00 17.14           O  
ATOM   1261  CB  LEU A 650      -0.834  26.003  36.388  1.00 17.96           C  
ATOM   1262  CG  LEU A 650      -0.287  27.434  36.374  1.00 17.86           C  
ATOM   1263  CD1 LEU A 650      -0.966  28.264  37.451  1.00 16.36           C  
ATOM   1264  CD2 LEU A 650       1.226  27.410  36.589  1.00 17.19           C  
ATOM   1265  N   MET A 651      -3.464  27.567  34.903  1.00 15.80           N  
ATOM   1266  CA  MET A 651      -3.886  28.274  33.702  1.00 17.58           C  
ATOM   1267  C   MET A 651      -3.643  29.759  33.878  1.00 18.91           C  
ATOM   1268  O   MET A 651      -3.628  30.267  35.003  1.00 16.93           O  
ATOM   1269  CB  MET A 651      -5.364  28.009  33.416  1.00 17.08           C  
ATOM   1270  CG  MET A 651      -5.656  26.561  33.074  1.00 16.31           C  
ATOM   1271  SD  MET A 651      -7.368  26.297  32.597  1.00 20.25           S  
ATOM   1272  CE  MET A 651      -7.343  26.952  30.909  1.00 16.33           C  
ATOM   1273  N   GLU A 652      -3.459  30.450  32.758  1.00 16.81           N  
ATOM   1274  CA  GLU A 652      -3.175  31.871  32.779  1.00 18.39           C  
ATOM   1275  C   GLU A 652      -4.006  32.674  31.789  1.00 19.14           C  
ATOM   1276  O   GLU A 652      -4.311  32.204  30.692  1.00 19.33           O  
ATOM   1277  CB  GLU A 652      -1.698  32.083  32.466  1.00 19.43           C  
ATOM   1278  CG  GLU A 652      -1.280  33.524  32.338  1.00 19.25           C  
ATOM   1279  CD  GLU A 652       0.155  33.650  31.889  1.00 23.23           C  
ATOM   1280  OE1 GLU A 652       0.398  33.741  30.665  1.00 19.11           O  
ATOM   1281  OE2 GLU A 652       1.041  33.644  32.768  1.00 22.36           O  
ATOM   1282  N   CYS A 653      -4.369  33.888  32.193  1.00 18.75           N  
ATOM   1283  CA  CYS A 653      -5.125  34.785  31.337  1.00 18.77           C  
ATOM   1284  C   CYS A 653      -4.310  36.054  31.144  1.00 19.42           C  
ATOM   1285  O   CYS A 653      -3.934  36.725  32.111  1.00 18.50           O  
ATOM   1286  CB  CYS A 653      -6.483  35.150  31.949  1.00 19.23           C  
ATOM   1287  SG  CYS A 653      -7.494  36.215  30.856  1.00 19.94           S  
ATOM   1288  N   GLU A 654      -4.011  36.356  29.888  1.00 20.28           N  
ATOM   1289  CA  GLU A 654      -3.265  37.551  29.536  1.00 21.62           C  
ATOM   1290  C   GLU A 654      -4.331  38.559  29.141  1.00 23.03           C  
ATOM   1291  O   GLU A 654      -5.055  38.358  28.163  1.00 22.56           O  
ATOM   1292  CB  GLU A 654      -2.335  37.256  28.355  1.00 21.38           C  
ATOM   1293  CG  GLU A 654      -1.437  38.406  27.951  1.00 22.62           C  
ATOM   1294  CD  GLU A 654      -0.406  37.984  26.916  1.00 24.81           C  
ATOM   1295  OE1 GLU A 654      -0.803  37.542  25.815  1.00 25.45           O  
ATOM   1296  OE2 GLU A 654       0.803  38.087  27.207  1.00 24.47           O  
ATOM   1297  N   LEU A 655      -4.445  39.632  29.915  1.00 23.57           N  
ATOM   1298  CA  LEU A 655      -5.449  40.646  29.647  1.00 26.34           C  
ATOM   1299  C   LEU A 655      -4.998  41.652  28.599  1.00 29.07           C  
ATOM   1300  O   LEU A 655      -3.853  42.099  28.612  1.00 28.84           O  
ATOM   1301  CB  LEU A 655      -5.811  41.385  30.939  1.00 24.12           C  
ATOM   1302  CG  LEU A 655      -6.557  40.620  32.041  1.00 22.70           C  
ATOM   1303  CD1 LEU A 655      -5.688  39.511  32.598  1.00 24.39           C  
ATOM   1304  CD2 LEU A 655      -6.941  41.592  33.148  1.00 20.70           C  
ATOM   1305  N   ASN A 656      -5.907  41.995  27.690  1.00 33.04           N  
ATOM   1306  CA  ASN A 656      -5.629  42.973  26.643  1.00 36.42           C  
ATOM   1307  C   ASN A 656      -6.313  44.270  27.063  1.00 38.02           C  
ATOM   1308  O   ASN A 656      -7.538  44.388  26.986  1.00 39.45           O  
ATOM   1309  CB  ASN A 656      -6.201  42.513  25.300  1.00 37.42           C  
ATOM   1310  CG  ASN A 656      -5.817  43.437  24.156  1.00 38.44           C  
ATOM   1311  OD1 ASN A 656      -5.880  44.660  24.282  1.00 37.99           O  
ATOM   1312  ND2 ASN A 656      -5.424  42.852  23.026  1.00 39.30           N  
ATOM   1313  N   PRO A 657      -5.530  45.261  27.516  1.00 39.22           N  
ATOM   1314  CA  PRO A 657      -6.038  46.564  27.960  1.00 40.21           C  
ATOM   1315  C   PRO A 657      -6.882  47.278  26.909  1.00 42.08           C  
ATOM   1316  O   PRO A 657      -7.572  48.253  27.216  1.00 40.61           O  
ATOM   1317  CB  PRO A 657      -4.762  47.337  28.287  1.00 40.90           C  
ATOM   1318  CG  PRO A 657      -3.811  46.264  28.690  1.00 41.48           C  
ATOM   1319  CD  PRO A 657      -4.066  45.202  27.657  1.00 39.19           C  
ATOM   1320  N   ARG A 658      -6.810  46.785  25.674  1.00 43.63           N  
ATOM   1321  CA  ARG A 658      -7.539  47.349  24.539  1.00 45.85           C  
ATOM   1322  C   ARG A 658      -6.842  48.601  24.016  1.00 46.89           C  
ATOM   1323  O   ARG A 658      -6.407  48.583  22.844  1.00 47.62           O  
ATOM   1324  CB  ARG A 658      -8.981  47.696  24.926  1.00 46.14           C  
ATOM   1325  CG  ARG A 658      -9.850  48.075  23.741  1.00 46.50           C  
ATOM   1326  CD  ARG A 658     -11.230  48.590  24.146  1.00 46.60           C  
ATOM   1327  NE  ARG A 658     -11.207  49.966  24.639  1.00 46.35           N  
ATOM   1328  CZ  ARG A 658     -10.890  50.320  25.881  1.00 46.52           C  
ATOM   1329  NH1 ARG A 658     -10.566  49.398  26.777  1.00 47.27           N  
ATOM   1330  NH2 ARG A 658     -10.899  51.599  26.227  1.00 47.08           N  
TER    1331      ARG A 658                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
