
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   70 (  528),  selected   70 , name 2d5d_A
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 2d5d_A.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    77_A      L      83          1.933
LGA    N    78_A      I      84          0.758
LGA    V    79_A      S      85          0.215
LGA    V    80_A      V      86          0.353
LGA    S    81_A      P      87          1.449
LGA    A    82_A      A      88          3.123
LGA    P    83_A      E      89          5.160
LGA    M    84_A      -       -           -
LGA    P    85_A      G      90          3.042
LGA    G    86_A      Y      91          1.981
LGA    K    87_A      K      92          1.705
LGA    V    88_A      V      93          1.922
LGA    L    89_A      Y      94          2.720
LGA    R    90_A      P      95          3.930
LGA    V    91_A      -       -           -
LGA    L    92_A      I      96          2.371
LGA    V    93_A      M      97          5.258
LGA    R    94_A      D      98          1.653
LGA    V    95_A      F      99          0.855
LGA    G    96_A      G     100          0.752
LGA    D    97_A      F     101          0.426
LGA    R    98_A      R     102          0.398
LGA    V    99_A      V     103          1.092
LGA    R   100_A      L     104          1.365
LGA    V   101_A      K     105          0.923
LGA    G   102_A      G     106          1.051
LGA    Q   103_A      Y     107          0.839
LGA    G   104_A      R     108          0.581
LGA    L   105_A      L     109          0.610
LGA    L   106_A      A     110          1.566
LGA    V   107_A      T     111          1.742
LGA    L   108_A      L     112          1.848
LGA    E   109_A      E     113          1.649
LGA    A   110_A      S     114          2.034
LGA    M   111_A      K     115          6.086
LGA    K   112_A      K     116          3.003
LGA    -       -      G     117           -
LGA    M   113_A      D     118          1.276
LGA    E   114_A      L     119          2.321
LGA    N   115_A      R     120          2.221
LGA    E   116_A      Y     121          2.164
LGA    I   117_A      V     122          1.098
LGA    P   118_A      N     123          0.599
LGA    S   119_A      S     124          0.720
LGA    P   120_A      P     125          0.714
LGA    R   121_A      V     126          0.781
LGA    D   122_A      S     127          0.685
LGA    G   123_A      G     128          1.015
LGA    V   124_A      T     129          0.286
LGA    V   125_A      V     130          0.583
LGA    K   126_A      I     131          0.855
LGA    R   127_A      F     132          0.814
LGA    I   128_A      M     133          0.597
LGA    L   129_A      N     134          1.635
LGA    V   130_A      E     135          2.174
LGA    K   131_A      I     136           -
LGA    E   132_A      P     137           -
LGA    G   133_A      S     138           -
LGA    -       -      E     139           -
LGA    E   134_A      R     140          4.636
LGA    A   135_A      A     141          1.319
LGA    V   136_A      N     142          2.418
LGA    D   137_A      -       -           -
LGA    T   138_A      -       -           -
LGA    G   139_A      -       -           -
LGA    Q   140_A      -       -           -
LGA    P   141_A      Y     143           #
LGA    L   142_A      V     144          0.980
LGA    I   143_A      F     145          0.567
LGA    E   144_A      Y     146          0.624
LGA    L   145_A      M     147          0.466
LGA    G   146_A      L     148          2.061
LGA    -       -      E     149           -
LGA    -       -      E     150           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   70   68    5.0     60    2.07    28.33     73.617     2.763

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.689481 * X  +  -0.435656 * Y  +   0.578636 * Z  +  27.477411
  Y_new =   0.676510 * X  +   0.101953 * Y  +  -0.729342 * Z  +  46.833748
  Z_new =   0.258749 * X  +   0.894321 * Y  +   0.365020 * Z  +  26.895370 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.183281   -1.958312  [ DEG:    67.7970   -112.2030 ]
  Theta =  -0.261726   -2.879866  [ DEG:   -14.9958   -165.0042 ]
  Phi   =   0.775903   -2.365690  [ DEG:    44.4559   -135.5441 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2d5d_A                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2d5d_A.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   70   68   5.0   60   2.07   28.33  73.617
REMARK  ---------------------------------------------------------- 
MOLECULE 2d5d_A
HEADER    LIPID BINDING PROTEIN,TRANSFERASE       01-NOV-05   2D5D              
TITLE     STRUCTURE OF BIOTIN CARBOXYL CARRIER PROTEIN (74VAL START)            
TITLE    2 FROM PYROCOCCUS HORIKOSHI OT3 LIGAND FREE FORM II                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METHYLMALONYL-COA DECARBOXYLASE GAMMA CHAIN;               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 73-146;                                           
COMPND   5 SYNONYM: BIOTIN CARBOXYL CARRIER PROTEIN;                            
COMPND   6 EC: 2.1.3.1;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 STRAIN: OT3;                                                         
SOURCE   4 GENE: BCCP;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET 11A                                   
KEYWDS    BIOTIN, DOMAIN, BCCP, X-RAY DIFFRACTION, STRUCTURAL                   
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, LIPID BINDING PROTEIN,         
KEYWDS   5 TRANSFERASE                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.BAGAUTDINOV,N.KUNISHIMA,RIKEN STRUCTURAL                            
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   27-MAY-08 2D5D    1       JRNL   VERSN                             
REVDAT   1   01-MAY-06 2D5D    0                                                
JRNL        AUTH   B.BAGAUTDINOV,Y.MATSUURA,S.BAGAUTDINOVA,N.KUNISHIMA          
JRNL        TITL   PROTEIN BIOTINYLATION VISUALIZED BY A COMPLEX                
JRNL        TITL 2 STRUCTURE OF BIOTIN PROTEIN LIGASE WITH A SUBSTRATE          
JRNL        REF    J.BIOL.CHEM.                  V. 283 14739 2008              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.55 ANGSTROMS.                                          
DBREF  2D5D A   74   146  UNP    O59021   O59021_PYRHO    77    149             
DBREF  2D5D B   74   146  UNP    O59021   O59021_PYRHO    77    149             
SEQRES   1 A   74  MET VAL VAL SER GLU ASN VAL VAL SER ALA PRO MET PRO          
SEQRES   2 A   74  GLY LYS VAL LEU ARG VAL LEU VAL ARG VAL GLY ASP ARG          
SEQRES   3 A   74  VAL ARG VAL GLY GLN GLY LEU LEU VAL LEU GLU ALA MET          
SEQRES   4 A   74  LYS MET GLU ASN GLU ILE PRO SER PRO ARG ASP GLY VAL          
SEQRES   5 A   74  VAL LYS ARG ILE LEU VAL LYS GLU GLY GLU ALA VAL ASP          
SEQRES   6 A   74  THR GLY GLN PRO LEU ILE GLU LEU GLY                          
SEQRES   1 B   74  MET VAL VAL SER GLU ASN VAL VAL SER ALA PRO MET PRO          
SEQRES   2 B   74  GLY LYS VAL LEU ARG VAL LEU VAL ARG VAL GLY ASP ARG          
SEQRES   3 B   74  VAL ARG VAL GLY GLN GLY LEU LEU VAL LEU GLU ALA MET          
SEQRES   4 B   74  LYS MET GLU ASN GLU ILE PRO SER PRO ARG ASP GLY VAL          
SEQRES   5 B   74  VAL LYS ARG ILE LEU VAL LYS GLU GLY GLU ALA VAL ASP          
SEQRES   6 B   74  THR GLY GLN PRO LEU ILE GLU LEU GLY                          
FORMUL   3  HOH   *196(H2 O)                                                    
CRYST1   39.689   39.765   88.418  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   GLU A  77      33.331  22.235  51.938  1.00 46.51           N  
ATOM      2  CA  GLU A  77      34.127  23.379  52.469  1.00 46.04           C  
ATOM      3  C   GLU A  77      35.588  23.288  52.039  1.00 44.31           C  
ATOM      4  O   GLU A  77      36.266  22.295  52.314  1.00 44.95           O  
ATOM      5  CB  GLU A  77      34.036  23.410  53.998  1.00 47.54           C  
ATOM      6  CG  GLU A  77      34.293  22.064  54.663  1.00 50.38           C  
ATOM      7  CD  GLU A  77      34.282  22.146  56.178  1.00 51.51           C  
ATOM      8  OE1 GLU A  77      35.163  22.829  56.744  1.00 52.72           O  
ATOM      9  OE2 GLU A  77      33.393  21.529  56.803  1.00 52.87           O  
ATOM     10  N   ASN A  78      36.070  24.328  51.361  1.00 42.04           N  
ATOM     11  CA  ASN A  78      37.450  24.361  50.894  1.00 39.27           C  
ATOM     12  C   ASN A  78      38.060  25.763  50.852  1.00 36.20           C  
ATOM     13  O   ASN A  78      37.382  26.766  51.097  1.00 34.31           O  
ATOM     14  CB  ASN A  78      37.567  23.674  49.520  1.00 41.01           C  
ATOM     15  CG  ASN A  78      36.503  24.130  48.537  1.00 42.83           C  
ATOM     16  OD1 ASN A  78      35.401  24.512  48.930  1.00 45.37           O  
ATOM     17  ND2 ASN A  78      36.825  24.080  47.250  1.00 44.56           N  
ATOM     18  N   VAL A  79      39.351  25.817  50.538  1.00 32.53           N  
ATOM     19  CA  VAL A  79      40.099  27.068  50.499  1.00 29.00           C  
ATOM     20  C   VAL A  79      40.493  27.514  49.097  1.00 27.82           C  
ATOM     21  O   VAL A  79      40.975  26.712  48.299  1.00 27.71           O  
ATOM     22  CB  VAL A  79      41.395  26.940  51.327  1.00 30.08           C  
ATOM     23  CG1 VAL A  79      42.124  28.268  51.380  1.00 28.85           C  
ATOM     24  CG2 VAL A  79      41.069  26.448  52.721  1.00 29.91           C  
ATOM     25  N   VAL A  80      40.282  28.797  48.809  1.00 24.92           N  
ATOM     26  CA  VAL A  80      40.654  29.384  47.525  1.00 25.58           C  
ATOM     27  C   VAL A  80      41.996  30.075  47.768  1.00 23.51           C  
ATOM     28  O   VAL A  80      42.109  30.920  48.658  1.00 23.30           O  
ATOM     29  CB  VAL A  80      39.627  30.442  47.066  1.00 24.54           C  
ATOM     30  CG1 VAL A  80      40.087  31.088  45.762  1.00 25.83           C  
ATOM     31  CG2 VAL A  80      38.262  29.799  46.883  1.00 27.13           C  
ATOM     32  N   SER A  81      43.013  29.706  46.994  1.00 24.27           N  
ATOM     33  CA  SER A  81      44.347  30.287  47.156  1.00 24.63           C  
ATOM     34  C   SER A  81      44.764  31.167  45.982  1.00 24.88           C  
ATOM     35  O   SER A  81      44.237  31.038  44.877  1.00 24.97           O  
ATOM     36  CB  SER A  81      45.390  29.179  47.349  1.00 27.55           C  
ATOM     37  OG  SER A  81      45.180  28.459  48.552  1.00 30.52           O  
ATOM     38  N   ALA A  82      45.715  32.063  46.227  1.00 22.62           N  
ATOM     39  CA  ALA A  82      46.195  32.967  45.184  1.00 21.86           C  
ATOM     40  C   ALA A  82      46.905  32.183  44.083  1.00 22.42           C  
ATOM     41  O   ALA A  82      47.766  31.360  44.366  1.00 21.96           O  
ATOM     42  CB  ALA A  82      47.149  33.985  45.785  1.00 20.73           C  
ATOM     43  N   PRO A  83      46.538  32.420  42.813  1.00 23.26           N  
ATOM     44  CA  PRO A  83      47.184  31.703  41.707  1.00 24.72           C  
ATOM     45  C   PRO A  83      48.570  32.268  41.373  1.00 25.93           C  
ATOM     46  O   PRO A  83      49.362  31.630  40.673  1.00 25.57           O  
ATOM     47  CB  PRO A  83      46.188  31.869  40.562  1.00 24.02           C  
ATOM     48  CG  PRO A  83      45.607  33.209  40.825  1.00 25.51           C  
ATOM     49  CD  PRO A  83      45.382  33.197  42.330  1.00 23.47           C  
ATOM     50  N   MET A  84      48.850  33.466  41.871  1.00 25.05           N  
ATOM     51  CA  MET A  84      50.141  34.118  41.662  1.00 25.77           C  
ATOM     52  C   MET A  84      50.289  35.255  42.667  1.00 25.23           C  
ATOM     53  O   MET A  84      49.334  35.610  43.361  1.00 23.80           O  
ATOM     54  CB  MET A  84      50.251  34.679  40.238  1.00 27.87           C  
ATOM     55  CG  MET A  84      49.375  35.883  39.973  1.00 32.12           C  
ATOM     56  SD  MET A  84      47.665  35.423  39.675  1.00 40.70           S  
ATOM     57  CE  MET A  84      47.168  36.704  38.572  1.00 37.51           C  
ATOM     58  N   PRO A  85      51.492  35.833  42.778  1.00 24.42           N  
ATOM     59  CA  PRO A  85      51.698  36.933  43.721  1.00 23.93           C  
ATOM     60  C   PRO A  85      51.009  38.195  43.219  1.00 25.18           C  
ATOM     61  O   PRO A  85      50.846  38.383  42.011  1.00 25.82           O  
ATOM     62  CB  PRO A  85      53.219  37.098  43.745  1.00 24.68           C  
ATOM     63  CG  PRO A  85      53.734  35.768  43.282  1.00 25.84           C  
ATOM     64  CD  PRO A  85      52.775  35.402  42.195  1.00 23.93           C  
ATOM     65  N   GLY A  86      50.614  39.061  44.143  1.00 24.71           N  
ATOM     66  CA  GLY A  86      49.963  40.293  43.751  1.00 24.92           C  
ATOM     67  C   GLY A  86      49.408  41.035  44.941  1.00 24.15           C  
ATOM     68  O   GLY A  86      49.616  40.635  46.085  1.00 24.73           O  
ATOM     69  N   LYS A  87      48.708  42.128  44.672  1.00 23.82           N  
ATOM     70  CA  LYS A  87      48.109  42.909  45.740  1.00 23.83           C  
ATOM     71  C   LYS A  87      46.599  42.857  45.612  1.00 22.26           C  
ATOM     72  O   LYS A  87      46.048  43.007  44.519  1.00 22.27           O  
ATOM     73  CB  LYS A  87      48.579  44.367  45.694  1.00 24.93           C  
ATOM     74  CG  LYS A  87      48.162  45.167  46.930  1.00 30.95           C  
ATOM     75  CD  LYS A  87      48.775  46.561  46.954  1.00 34.59           C  
ATOM     76  CE  LYS A  87      48.052  47.503  46.005  1.00 36.63           C  
ATOM     77  NZ  LYS A  87      46.645  47.761  46.436  1.00 39.40           N  
ATOM     78  N   VAL A  88      45.926  42.622  46.732  1.00 21.35           N  
ATOM     79  CA  VAL A  88      44.473  42.565  46.733  1.00 20.65           C  
ATOM     80  C   VAL A  88      43.932  43.978  46.558  1.00 22.07           C  
ATOM     81  O   VAL A  88      44.130  44.832  47.418  1.00 23.47           O  
ATOM     82  CB  VAL A  88      43.925  42.003  48.061  1.00 20.22           C  
ATOM     83  CG1 VAL A  88      42.405  42.004  48.034  1.00 18.83           C  
ATOM     84  CG2 VAL A  88      44.450  40.596  48.286  1.00 19.08           C  
ATOM     85  N   LEU A  89      43.251  44.223  45.447  1.00 20.99           N  
ATOM     86  CA  LEU A  89      42.686  45.546  45.186  1.00 22.07           C  
ATOM     87  C   LEU A  89      41.301  45.676  45.802  1.00 23.13           C  
ATOM     88  O   LEU A  89      40.915  46.744  46.288  1.00 23.71           O  
ATOM     89  CB  LEU A  89      42.589  45.799  43.681  1.00 23.13           C  
ATOM     90  CG  LEU A  89      43.917  45.802  42.924  1.00 24.38           C  
ATOM     91  CD1 LEU A  89      43.662  46.180  41.476  1.00 26.58           C  
ATOM     92  CD2 LEU A  89      44.892  46.785  43.572  1.00 24.39           C  
ATOM     93  N   ARG A  90      40.555  44.581  45.796  1.00 22.85           N  
ATOM     94  CA  ARG A  90      39.212  44.612  46.342  1.00 23.16           C  
ATOM     95  C   ARG A  90      38.648  43.228  46.605  1.00 20.78           C  
ATOM     96  O   ARG A  90      38.921  42.289  45.863  1.00 20.91           O  
ATOM     97  CB  ARG A  90      38.288  45.349  45.370  1.00 27.66           C  
ATOM     98  CG  ARG A  90      36.815  45.220  45.696  1.00 32.72           C  
ATOM     99  CD  ARG A  90      36.209  46.577  45.946  1.00 35.74           C  
ATOM    100  NE  ARG A  90      36.349  47.438  44.778  1.00 38.95           N  
ATOM    101  CZ  ARG A  90      35.932  48.698  44.731  1.00 40.65           C  
ATOM    102  NH1 ARG A  90      35.351  49.239  45.794  1.00 41.09           N  
ATOM    103  NH2 ARG A  90      36.095  49.411  43.625  1.00 40.45           N  
ATOM    104  N   VAL A  91      37.869  43.109  47.676  1.00 20.13           N  
ATOM    105  CA  VAL A  91      37.208  41.853  47.993  1.00 20.08           C  
ATOM    106  C   VAL A  91      35.759  42.083  47.575  1.00 20.13           C  
ATOM    107  O   VAL A  91      35.088  43.008  48.046  1.00 20.90           O  
ATOM    108  CB  VAL A  91      37.306  41.507  49.488  1.00 18.45           C  
ATOM    109  CG1 VAL A  91      36.529  40.231  49.779  1.00 21.17           C  
ATOM    110  CG2 VAL A  91      38.766  41.326  49.871  1.00 19.90           C  
ATOM    111  N   LEU A  92      35.289  41.236  46.671  1.00 20.37           N  
ATOM    112  CA  LEU A  92      33.959  41.352  46.101  1.00 22.13           C  
ATOM    113  C   LEU A  92      32.844  40.696  46.884  1.00 23.31           C  
ATOM    114  O   LEU A  92      31.675  40.817  46.521  1.00 24.93           O  
ATOM    115  CB  LEU A  92      33.988  40.783  44.683  1.00 21.02           C  
ATOM    116  CG  LEU A  92      35.026  41.449  43.779  1.00 24.04           C  
ATOM    117  CD1 LEU A  92      35.240  40.607  42.533  1.00 24.62           C  
ATOM    118  CD2 LEU A  92      34.564  42.848  43.422  1.00 23.85           C  
ATOM    119  N   VAL A  93      33.196  40.000  47.957  1.00 20.96           N  
ATOM    120  CA  VAL A  93      32.196  39.319  48.763  1.00 22.81           C  
ATOM    121  C   VAL A  93      32.339  39.665  50.233  1.00 21.54           C  
ATOM    122  O   VAL A  93      33.310  40.291  50.644  1.00 21.78           O  
ATOM    123  CB  VAL A  93      32.319  37.791  48.621  1.00 24.19           C  
ATOM    124  CG1 VAL A  93      32.018  37.376  47.193  1.00 24.84           C  
ATOM    125  CG2 VAL A  93      33.727  37.344  49.009  1.00 22.48           C  
ATOM    126  N   ARG A  94      31.342  39.256  51.006  1.00 22.66           N  
ATOM    127  CA  ARG A  94      31.327  39.462  52.448  1.00 22.93           C  
ATOM    128  C   ARG A  94      31.031  38.108  53.080  1.00 20.45           C  
ATOM    129  O   ARG A  94      30.472  37.223  52.435  1.00 20.22           O  
ATOM    130  CB  ARG A  94      30.238  40.465  52.840  1.00 26.47           C  
ATOM    131  CG  ARG A  94      30.594  41.913  52.562  1.00 30.91           C  
ATOM    132  CD  ARG A  94      29.426  42.826  52.908  1.00 36.71           C  
ATOM    133  NE  ARG A  94      28.928  42.593  54.263  1.00 41.72           N  
ATOM    134  CZ  ARG A  94      29.632  42.808  55.372  1.00 43.50           C  
ATOM    135  NH1 ARG A  94      30.874  43.264  55.297  1.00 44.79           N  
ATOM    136  NH2 ARG A  94      29.089  42.566  56.557  1.00 44.86           N  
ATOM    137  N   VAL A  95      31.411  37.936  54.342  1.00 18.79           N  
ATOM    138  CA  VAL A  95      31.159  36.677  55.020  1.00 18.60           C  
ATOM    139  C   VAL A  95      29.659  36.397  55.003  1.00 18.11           C  
ATOM    140  O   VAL A  95      28.848  37.277  55.313  1.00 20.28           O  
ATOM    141  CB  VAL A  95      31.658  36.725  56.482  1.00 17.95           C  
ATOM    142  CG1 VAL A  95      31.171  35.503  57.235  1.00 19.35           C  
ATOM    143  CG2 VAL A  95      33.184  36.789  56.506  1.00 19.83           C  
ATOM    144  N   GLY A  96      29.296  35.176  54.629  1.00 18.51           N  
ATOM    145  CA  GLY A  96      27.895  34.803  54.581  1.00 19.01           C  
ATOM    146  C   GLY A  96      27.284  34.856  53.196  1.00 21.24           C  
ATOM    147  O   GLY A  96      26.194  34.335  52.977  1.00 18.71           O  
ATOM    148  N   ASP A  97      27.983  35.490  52.258  1.00 20.59           N  
ATOM    149  CA  ASP A  97      27.492  35.600  50.886  1.00 22.74           C  
ATOM    150  C   ASP A  97      27.457  34.269  50.142  1.00 22.66           C  
ATOM    151  O   ASP A  97      28.341  33.418  50.296  1.00 20.82           O  
ATOM    152  CB  ASP A  97      28.368  36.558  50.070  1.00 23.79           C  
ATOM    153  CG  ASP A  97      28.043  38.012  50.309  1.00 25.60           C  
ATOM    154  OD1 ASP A  97      27.184  38.323  51.165  1.00 26.65           O  
ATOM    155  OD2 ASP A  97      28.663  38.851  49.622  1.00 26.15           O  
ATOM    156  N   ARG A  98      26.416  34.080  49.340  1.00 21.75           N  
ATOM    157  CA  ARG A  98      26.324  32.883  48.521  1.00 21.95           C  
ATOM    158  C   ARG A  98      27.137  33.233  47.285  1.00 21.58           C  
ATOM    159  O   ARG A  98      27.050  34.354  46.792  1.00 22.01           O  
ATOM    160  CB  ARG A  98      24.877  32.601  48.108  1.00 25.80           C  
ATOM    161  CG  ARG A  98      24.767  31.794  46.816  1.00 30.83           C  
ATOM    162  CD  ARG A  98      23.423  31.095  46.670  1.00 35.15           C  
ATOM    163  NE  ARG A  98      23.171  30.604  45.315  1.00 40.36           N  
ATOM    164  CZ  ARG A  98      24.044  29.931  44.571  1.00 42.10           C  
ATOM    165  NH1 ARG A  98      25.257  29.656  45.028  1.00 43.51           N  
ATOM    166  NH2 ARG A  98      23.693  29.508  43.364  1.00 44.55           N  
ATOM    167  N   VAL A  99      27.940  32.297  46.803  1.00 20.84           N  
ATOM    168  CA  VAL A  99      28.737  32.546  45.605  1.00 21.80           C  
ATOM    169  C   VAL A  99      28.466  31.464  44.572  1.00 22.59           C  
ATOM    170  O   VAL A  99      28.063  30.354  44.907  1.00 22.48           O  
ATOM    171  CB  VAL A  99      30.259  32.594  45.912  1.00 21.17           C  
ATOM    172  CG1 VAL A  99      30.571  33.794  46.783  1.00 20.72           C  
ATOM    173  CG2 VAL A  99      30.703  31.308  46.604  1.00 18.90           C  
ATOM    174  N   ARG A 100      28.696  31.799  43.307  1.00 22.93           N  
ATOM    175  CA  ARG A 100      28.467  30.873  42.212  1.00 25.16           C  
ATOM    176  C   ARG A 100      29.808  30.463  41.619  1.00 23.03           C  
ATOM    177  O   ARG A 100      30.764  31.229  41.667  1.00 23.48           O  
ATOM    178  CB  ARG A 100      27.614  31.555  41.138  1.00 25.33           C  
ATOM    179  CG  ARG A 100      26.356  32.246  41.684  1.00 28.48           C  
ATOM    180  CD  ARG A 100      25.516  32.869  40.572  1.00 28.24           C  
ATOM    181  NE  ARG A 100      26.165  34.029  39.964  1.00 31.17           N  
ATOM    182  CZ  ARG A 100      26.056  35.274  40.414  1.00 31.68           C  
ATOM    183  NH1 ARG A 100      25.313  35.537  41.481  1.00 34.01           N  
ATOM    184  NH2 ARG A 100      26.701  36.262  39.805  1.00 33.97           N  
ATOM    185  N   VAL A 101      29.884  29.253  41.078  1.00 22.72           N  
ATOM    186  CA  VAL A 101      31.127  28.789  40.471  1.00 22.26           C  
ATOM    187  C   VAL A 101      31.493  29.779  39.373  1.00 20.49           C  
ATOM    188  O   VAL A 101      30.650  30.156  38.561  1.00 21.20           O  
ATOM    189  CB  VAL A 101      30.972  27.393  39.843  1.00 22.47           C  
ATOM    190  CG1 VAL A 101      29.815  27.398  38.857  1.00 23.48           C  
ATOM    191  CG2 VAL A 101      32.269  26.993  39.145  1.00 23.70           C  
ATOM    192  N   GLY A 102      32.745  30.223  39.363  1.00 20.35           N  
ATOM    193  CA  GLY A 102      33.164  31.166  38.344  1.00 21.62           C  
ATOM    194  C   GLY A 102      32.928  32.618  38.710  1.00 20.99           C  
ATOM    195  O   GLY A 102      33.366  33.519  38.003  1.00 22.47           O  
ATOM    196  N   GLN A 103      32.222  32.859  39.811  1.00 20.65           N  
ATOM    197  CA  GLN A 103      31.951  34.222  40.251  1.00 22.45           C  
ATOM    198  C   GLN A 103      33.204  34.812  40.893  1.00 21.70           C  
ATOM    199  O   GLN A 103      33.960  34.104  41.559  1.00 20.98           O  
ATOM    200  CB  GLN A 103      30.808  34.233  41.269  1.00 22.41           C  
ATOM    201  CG  GLN A 103      30.354  35.618  41.705  1.00 27.02           C  
ATOM    202  CD  GLN A 103      29.371  35.568  42.866  1.00 26.80           C  
ATOM    203  OE1 GLN A 103      28.498  34.708  42.910  1.00 29.63           O  
ATOM    204  NE2 GLN A 103      29.509  36.502  43.804  1.00 29.64           N  
ATOM    205  N   GLY A 104      33.418  36.106  40.692  1.00 22.28           N  
ATOM    206  CA  GLY A 104      34.582  36.751  41.274  1.00 23.63           C  
ATOM    207  C   GLY A 104      34.509  36.858  42.789  1.00 23.38           C  
ATOM    208  O   GLY A 104      33.471  37.230  43.346  1.00 25.15           O  
ATOM    209  N   LEU A 105      35.608  36.523  43.461  1.00 20.64           N  
ATOM    210  CA  LEU A 105      35.683  36.597  44.923  1.00 18.94           C  
ATOM    211  C   LEU A 105      36.496  37.831  45.316  1.00 19.99           C  
ATOM    212  O   LEU A 105      36.208  38.493  46.313  1.00 17.28           O  
ATOM    213  CB  LEU A 105      36.343  35.332  45.493  1.00 20.06           C  
ATOM    214  CG  LEU A 105      35.544  34.021  45.439  1.00 18.56           C  
ATOM    215  CD1 LEU A 105      36.398  32.882  45.965  1.00 20.11           C  
ATOM    216  CD2 LEU A 105      34.279  34.158  46.275  1.00 23.31           C  
ATOM    217  N   LEU A 106      37.519  38.138  44.527  1.00 18.23           N  
ATOM    218  CA  LEU A 106      38.366  39.299  44.787  1.00 19.53           C  
ATOM    219  C   LEU A 106      39.162  39.623  43.537  1.00 20.05           C  
ATOM    220  O   LEU A 106      39.236  38.811  42.619  1.00 20.41           O  
ATOM    221  CB  LEU A 106      39.332  39.030  45.952  1.00 22.33           C  
ATOM    222  CG  LEU A 106      40.441  37.983  45.807  1.00 25.84           C  
ATOM    223  CD1 LEU A 106      41.329  38.013  47.054  1.00 29.07           C  
ATOM    224  CD2 LEU A 106      39.841  36.594  45.631  1.00 28.27           C  
ATOM    225  N   VAL A 107      39.746  40.816  43.506  1.00 20.51           N  
ATOM    226  CA  VAL A 107      40.548  41.253  42.370  1.00 22.98           C  
ATOM    227  C   VAL A 107      42.001  41.343  42.819  1.00 22.72           C  
ATOM    228  O   VAL A 107      42.308  41.990  43.820  1.00 22.03           O  
ATOM    229  CB  VAL A 107      40.092  42.639  41.861  1.00 24.15           C  
ATOM    230  CG1 VAL A 107      41.014  43.115  40.741  1.00 24.81           C  
ATOM    231  CG2 VAL A 107      38.662  42.563  41.350  1.00 25.27           C  
ATOM    232  N   LEU A 108      42.886  40.697  42.065  1.00 23.00           N  
ATOM    233  CA  LEU A 108      44.308  40.679  42.379  1.00 24.03           C  
ATOM    234  C   LEU A 108      45.139  41.363  41.298  1.00 26.62           C  
ATOM    235  O   LEU A 108      45.066  41.002  40.121  1.00 26.13           O  
ATOM    236  CB  LEU A 108      44.777  39.232  42.539  1.00 25.95           C  
ATOM    237  CG  LEU A 108      46.206  38.944  42.997  1.00 27.73           C  
ATOM    238  CD1 LEU A 108      46.426  39.480  44.404  1.00 28.06           C  
ATOM    239  CD2 LEU A 108      46.435  37.438  42.965  1.00 29.27           C  
ATOM    240  N   GLU A 109      45.931  42.345  41.710  1.00 29.31           N  
ATOM    241  CA  GLU A 109      46.840  43.040  40.805  1.00 32.51           C  
ATOM    242  C   GLU A 109      48.115  42.226  40.526  1.00 35.28           C  
ATOM    243  O   GLU A 109      48.988  42.048  41.365  1.00 35.15           O  
ATOM    244  CB  GLU A 109      47.178  44.406  41.425  1.00 33.38           C  
ATOM    245  CG  GLU A 109      47.999  45.311  40.499  1.00 36.49           C  
ATOM    246  CD  GLU A 109      48.268  46.633  41.188  1.00 38.18           C  
ATOM    247  OE1 GLU A 109      48.872  46.626  42.255  1.00 39.04           O  
ATOM    248  OE2 GLU A 109      47.936  47.668  40.600  1.00 38.45           O  
ATOM    249  N   ALA A 110      48.188  41.668  39.298  1.00 37.99           N  
ATOM    250  CA  ALA A 110      49.344  40.839  38.945  1.00 42.47           C  
ATOM    251  C   ALA A 110      49.418  40.519  37.442  1.00 45.08           C  
ATOM    252  O   ALA A 110      48.489  40.771  36.682  1.00 46.60           O  
ATOM    253  CB  ALA A 110      49.233  39.520  39.709  1.00 42.00           C  
ATOM    254  N   MET A 111      50.582  39.958  37.013  1.00 47.56           N  
ATOM    255  CA  MET A 111      50.959  39.917  35.587  1.00 49.30           C  
ATOM    256  C   MET A 111      50.615  41.207  34.829  1.00 50.04           C  
ATOM    257  O   MET A 111      50.057  41.187  33.738  1.00 51.05           O  
ATOM    258  CB  MET A 111      50.391  38.696  34.828  1.00 50.31           C  
ATOM    259  CG  MET A 111      49.780  37.596  35.710  1.00 52.70           C  
ATOM    260  SD  MET A 111      48.326  36.850  34.949  1.00 55.90           S  
ATOM    261  CE  MET A 111      48.684  35.120  35.313  1.00 54.54           C  
ATOM    262  N   LYS A 112      50.946  42.356  35.455  1.00 50.13           N  
ATOM    263  CA  LYS A 112      50.648  43.658  34.893  1.00 50.17           C  
ATOM    264  C   LYS A 112      49.173  43.728  34.517  1.00 50.08           C  
ATOM    265  O   LYS A 112      48.737  44.485  33.655  1.00 50.45           O  
ATOM    266  CB  LYS A 112      51.540  43.858  33.663  1.00 50.82           C  
ATOM    267  CG  LYS A 112      50.896  43.338  32.376  1.00 51.28           C  
ATOM    268  CD  LYS A 112      51.889  43.262  31.213  1.00 52.70           C  
ATOM    269  CE  LYS A 112      51.188  43.178  29.851  1.00 52.89           C  
ATOM    270  NZ  LYS A 112      51.408  44.416  29.107  1.00 53.97           N  
ATOM    271  N   MET A 113      48.405  42.859  35.198  1.00 49.29           N  
ATOM    272  CA  MET A 113      46.990  42.711  34.882  1.00 47.97           C  
ATOM    273  C   MET A 113      46.149  42.839  36.148  1.00 46.43           C  
ATOM    274  O   MET A 113      46.610  42.630  37.258  1.00 46.20           O  
ATOM    275  CB  MET A 113      46.805  41.294  34.341  1.00 49.29           C  
ATOM    276  CG  MET A 113      46.405  41.238  32.867  1.00 50.99           C  
ATOM    277  SD  MET A 113      46.214  39.545  32.287  1.00 54.08           S  
ATOM    278  CE  MET A 113      47.656  39.479  31.211  1.00 52.75           C  
ATOM    279  N   GLU A 114      44.879  43.219  35.952  1.00 44.14           N  
ATOM    280  CA  GLU A 114      43.951  43.112  37.065  1.00 41.83           C  
ATOM    281  C   GLU A 114      43.235  41.757  37.033  1.00 40.39           C  
ATOM    282  O   GLU A 114      42.441  41.463  36.149  1.00 41.42           O  
ATOM    283  CB  GLU A 114      42.956  44.274  36.981  1.00 42.16           C  
ATOM    284  CG  GLU A 114      43.544  45.564  37.559  1.00 43.31           C  
ATOM    285  CD  GLU A 114      42.443  46.446  38.118  1.00 43.99           C  
ATOM    286  OE1 GLU A 114      41.288  46.216  37.799  1.00 45.10           O  
ATOM    287  OE2 GLU A 114      42.761  47.369  38.864  1.00 44.61           O  
ATOM    288  N   ASN A 115      43.495  40.780  37.890  1.00 36.04           N  
ATOM    289  CA  ASN A 115      42.880  39.479  37.716  1.00 32.58           C  
ATOM    290  C   ASN A 115      41.767  39.188  38.698  1.00 30.71           C  
ATOM    291  O   ASN A 115      41.950  39.267  39.909  1.00 29.74           O  
ATOM    292  CB  ASN A 115      43.937  38.381  37.808  1.00 33.04           C  
ATOM    293  CG  ASN A 115      45.114  38.638  36.899  1.00 33.98           C  
ATOM    294  OD1 ASN A 115      45.213  38.056  35.820  1.00 32.41           O  
ATOM    295  ND2 ASN A 115      46.021  39.501  37.334  1.00 35.33           N  
ATOM    296  N   GLU A 116      40.603  38.857  38.159  1.00 27.24           N  
ATOM    297  CA  GLU A 116      39.460  38.513  38.986  1.00 25.19           C  
ATOM    298  C   GLU A 116      39.639  37.042  39.366  1.00 24.64           C  
ATOM    299  O   GLU A 116      39.738  36.176  38.498  1.00 23.70           O  
ATOM    300  CB  GLU A 116      38.175  38.731  38.187  1.00 27.55           C  
ATOM    301  CG  GLU A 116      36.894  38.462  38.938  1.00 31.47           C  
ATOM    302  CD  GLU A 116      35.707  39.134  38.273  1.00 35.41           C  
ATOM    303  OE1 GLU A 116      35.690  39.224  37.026  1.00 36.97           O  
ATOM    304  OE2 GLU A 116      34.791  39.569  39.000  1.00 38.44           O  
ATOM    305  N   ILE A 117      39.726  36.776  40.667  1.00 19.93           N  
ATOM    306  CA  ILE A 117      39.911  35.423  41.177  1.00 20.26           C  
ATOM    307  C   ILE A 117      38.522  34.843  41.409  1.00 19.16           C  
ATOM    308  O   ILE A 117      37.741  35.380  42.194  1.00 19.35           O  
ATOM    309  CB  ILE A 117      40.709  35.448  42.502  1.00 17.54           C  
ATOM    310  CG1 ILE A 117      41.991  36.269  42.317  1.00 20.23           C  
ATOM    311  CG2 ILE A 117      41.032  34.036  42.950  1.00 17.78           C  
ATOM    312  CD1 ILE A 117      42.898  35.779  41.184  1.00 21.78           C  
ATOM    313  N   PRO A 118      38.195  33.729  40.743  1.00 17.10           N  
ATOM    314  CA  PRO A 118      36.880  33.096  40.874  1.00 17.84           C  
ATOM    315  C   PRO A 118      36.677  32.099  42.005  1.00 19.04           C  
ATOM    316  O   PRO A 118      37.622  31.592  42.594  1.00 18.15           O  
ATOM    317  CB  PRO A 118      36.720  32.413  39.526  1.00 18.67           C  
ATOM    318  CG  PRO A 118      38.112  31.862  39.328  1.00 17.58           C  
ATOM    319  CD  PRO A 118      38.991  33.047  39.699  1.00 16.22           C  
ATOM    320  N   SER A 119      35.412  31.819  42.294  1.00 18.97           N  
ATOM    321  CA  SER A 119      35.086  30.822  43.290  1.00 20.75           C  
ATOM    322  C   SER A 119      35.115  29.524  42.487  1.00 21.17           C  
ATOM    323  O   SER A 119      34.558  29.461  41.388  1.00 20.89           O  
ATOM    324  CB  SER A 119      33.688  31.047  43.854  1.00 20.86           C  
ATOM    325  OG  SER A 119      33.376  30.021  44.776  1.00 24.17           O  
ATOM    326  N   PRO A 120      35.766  28.478  43.008  1.00 22.95           N  
ATOM    327  CA  PRO A 120      35.820  27.214  42.268  1.00 24.91           C  
ATOM    328  C   PRO A 120      34.515  26.431  42.294  1.00 25.10           C  
ATOM    329  O   PRO A 120      34.386  25.414  41.615  1.00 26.13           O  
ATOM    330  CB  PRO A 120      36.955  26.466  42.954  1.00 24.52           C  
ATOM    331  CG  PRO A 120      36.807  26.912  44.376  1.00 25.12           C  
ATOM    332  CD  PRO A 120      36.579  28.401  44.237  1.00 24.47           C  
ATOM    333  N   ARG A 121      33.544  26.902  43.068  1.00 25.01           N  
ATOM    334  CA  ARG A 121      32.269  26.198  43.160  1.00 25.30           C  
ATOM    335  C   ARG A 121      31.188  27.074  43.767  1.00 25.22           C  
ATOM    336  O   ARG A 121      31.475  28.163  44.263  1.00 23.58           O  
ATOM    337  CB  ARG A 121      32.429  24.947  44.025  1.00 26.84           C  
ATOM    338  CG  ARG A 121      32.735  25.234  45.503  1.00 25.61           C  
ATOM    339  CD  ARG A 121      32.583  23.966  46.336  1.00 27.59           C  
ATOM    340  NE  ARG A 121      32.995  24.121  47.731  1.00 27.33           N  
ATOM    341  CZ  ARG A 121      32.296  24.752  48.671  1.00 26.40           C  
ATOM    342  NH1 ARG A 121      31.120  25.298  48.391  1.00 27.07           N  
ATOM    343  NH2 ARG A 121      32.771  24.813  49.906  1.00 25.57           N  
ATOM    344  N   ASP A 122      29.940  26.611  43.705  1.00 24.69           N  
ATOM    345  CA  ASP A 122      28.851  27.353  44.322  1.00 24.79           C  
ATOM    346  C   ASP A 122      29.076  27.094  45.807  1.00 25.08           C  
ATOM    347  O   ASP A 122      29.640  26.066  46.180  1.00 23.35           O  
ATOM    348  CB  ASP A 122      27.475  26.795  43.927  1.00 26.11           C  
ATOM    349  CG  ASP A 122      27.118  27.053  42.473  1.00 30.62           C  
ATOM    350  OD1 ASP A 122      27.617  28.037  41.883  1.00 30.48           O  
ATOM    351  OD2 ASP A 122      26.306  26.276  41.928  1.00 32.81           O  
ATOM    352  N   GLY A 123      28.649  28.018  46.653  1.00 23.71           N  
ATOM    353  CA  GLY A 123      28.835  27.811  48.073  1.00 24.49           C  
ATOM    354  C   GLY A 123      28.580  29.074  48.855  1.00 21.84           C  
ATOM    355  O   GLY A 123      28.006  30.029  48.340  1.00 22.11           O  
ATOM    356  N   VAL A 124      29.000  29.071  50.115  1.00 20.10           N  
ATOM    357  CA  VAL A 124      28.821  30.227  50.972  1.00 18.69           C  
ATOM    358  C   VAL A 124      30.190  30.644  51.489  1.00 16.72           C  
ATOM    359  O   VAL A 124      31.009  29.798  51.841  1.00 19.70           O  
ATOM    360  CB  VAL A 124      27.905  29.892  52.176  1.00 19.00           C  
ATOM    361  CG1 VAL A 124      27.722  31.127  53.053  1.00 19.52           C  
ATOM    362  CG2 VAL A 124      26.562  29.381  51.682  1.00 22.12           C  
ATOM    363  N   VAL A 125      30.434  31.946  51.514  1.00 17.27           N  
ATOM    364  CA  VAL A 125      31.703  32.470  52.004  1.00 16.71           C  
ATOM    365  C   VAL A 125      31.722  32.344  53.522  1.00 18.26           C  
ATOM    366  O   VAL A 125      30.840  32.872  54.197  1.00 20.44           O  
ATOM    367  CB  VAL A 125      31.858  33.943  51.616  1.00 14.49           C  
ATOM    368  CG1 VAL A 125      33.092  34.541  52.265  1.00 15.54           C  
ATOM    369  CG2 VAL A 125      31.971  34.053  50.100  1.00 17.19           C  
ATOM    370  N   LYS A 126      32.712  31.640  54.059  1.00 16.46           N  
ATOM    371  CA  LYS A 126      32.784  31.473  55.509  1.00 17.10           C  
ATOM    372  C   LYS A 126      33.730  32.476  56.154  1.00 18.37           C  
ATOM    373  O   LYS A 126      33.385  33.120  57.146  1.00 18.56           O  
ATOM    374  CB  LYS A 126      33.224  30.054  55.855  1.00 18.38           C  
ATOM    375  CG  LYS A 126      33.157  29.757  57.341  1.00 19.48           C  
ATOM    376  CD  LYS A 126      33.436  28.298  57.632  1.00 23.93           C  
ATOM    377  CE  LYS A 126      33.043  27.962  59.063  1.00 26.01           C  
ATOM    378  NZ  LYS A 126      33.869  28.690  60.064  1.00 28.24           N  
ATOM    379  N   ARG A 127      34.922  32.614  55.585  1.00 15.29           N  
ATOM    380  CA  ARG A 127      35.916  33.544  56.105  1.00 15.45           C  
ATOM    381  C   ARG A 127      36.672  34.229  54.977  1.00 16.94           C  
ATOM    382  O   ARG A 127      36.918  33.622  53.929  1.00 16.73           O  
ATOM    383  CB  ARG A 127      36.949  32.814  56.971  1.00 16.20           C  
ATOM    384  CG  ARG A 127      36.393  32.022  58.137  1.00 18.47           C  
ATOM    385  CD  ARG A 127      37.517  31.652  59.124  1.00 17.78           C  
ATOM    386  NE  ARG A 127      38.573  30.832  58.525  1.00 19.99           N  
ATOM    387  CZ  ARG A 127      39.869  31.132  58.558  1.00 18.20           C  
ATOM    388  NH1 ARG A 127      40.287  32.243  59.159  1.00 20.73           N  
ATOM    389  NH2 ARG A 127      40.750  30.326  57.982  1.00 17.37           N  
ATOM    390  N   ILE A 128      37.039  35.483  55.200  1.00 16.52           N  
ATOM    391  CA  ILE A 128      37.817  36.256  54.239  1.00 16.46           C  
ATOM    392  C   ILE A 128      39.178  36.367  54.902  1.00 17.59           C  
ATOM    393  O   ILE A 128      39.306  36.917  55.998  1.00 18.34           O  
ATOM    394  CB  ILE A 128      37.192  37.627  54.011  1.00 18.18           C  
ATOM    395  CG1 ILE A 128      35.825  37.431  53.356  1.00 17.29           C  
ATOM    396  CG2 ILE A 128      38.100  38.482  53.127  1.00 19.19           C  
ATOM    397  CD1 ILE A 128      35.038  38.711  53.146  1.00 18.73           C  
ATOM    398  N   LEU A 129      40.198  35.855  54.224  1.00 16.03           N  
ATOM    399  CA  LEU A 129      41.538  35.784  54.792  1.00 16.59           C  
ATOM    400  C   LEU A 129      42.544  36.875  54.465  1.00 17.02           C  
ATOM    401  O   LEU A 129      43.670  36.842  54.955  1.00 18.59           O  
ATOM    402  CB  LEU A 129      42.133  34.414  54.446  1.00 14.64           C  
ATOM    403  CG  LEU A 129      41.089  33.290  54.508  1.00 16.43           C  
ATOM    404  CD1 LEU A 129      41.731  31.967  54.175  1.00 19.42           C  
ATOM    405  CD2 LEU A 129      40.461  33.248  55.900  1.00 14.88           C  
ATOM    406  N   VAL A 130      42.143  37.838  53.644  1.00 17.82           N  
ATOM    407  CA  VAL A 130      43.028  38.933  53.268  1.00 18.52           C  
ATOM    408  C   VAL A 130      42.259  40.239  53.278  1.00 19.83           C  
ATOM    409  O   VAL A 130      41.030  40.248  53.272  1.00 21.17           O  
ATOM    410  CB  VAL A 130      43.613  38.735  51.847  1.00 17.15           C  
ATOM    411  CG1 VAL A 130      44.593  37.585  51.845  1.00 17.61           C  
ATOM    412  CG2 VAL A 130      42.473  38.477  50.847  1.00 18.33           C  
ATOM    413  N   LYS A 131      42.990  41.345  53.304  1.00 22.43           N  
ATOM    414  CA  LYS A 131      42.360  42.653  53.289  1.00 25.30           C  
ATOM    415  C   LYS A 131      42.774  43.391  52.033  1.00 25.11           C  
ATOM    416  O   LYS A 131      43.812  43.097  51.446  1.00 24.45           O  
ATOM    417  CB  LYS A 131      42.758  43.458  54.528  1.00 28.70           C  
ATOM    418  CG  LYS A 131      42.248  42.847  55.816  1.00 33.09           C  
ATOM    419  CD  LYS A 131      42.195  43.862  56.939  1.00 35.42           C  
ATOM    420  CE  LYS A 131      41.281  43.379  58.052  1.00 37.09           C  
ATOM    421  NZ  LYS A 131      39.875  43.193  57.584  1.00 37.25           N  
ATOM    422  N   GLU A 132      41.956  44.344  51.615  1.00 27.19           N  
ATOM    423  CA  GLU A 132      42.262  45.110  50.422  1.00 27.66           C  
ATOM    424  C   GLU A 132      43.529  45.915  50.680  1.00 28.08           C  
ATOM    425  O   GLU A 132      43.669  46.546  51.726  1.00 28.83           O  
ATOM    426  CB  GLU A 132      41.080  46.017  50.081  1.00 29.59           C  
ATOM    427  CG  GLU A 132      39.753  45.258  50.079  1.00 31.25           C  
ATOM    428  CD  GLU A 132      38.570  46.123  49.702  1.00 32.35           C  
ATOM    429  OE1 GLU A 132      38.593  47.325  50.028  1.00 33.80           O  
ATOM    430  OE2 GLU A 132      37.610  45.599  49.096  1.00 31.21           O  
ATOM    431  N   GLY A 133      44.459  45.858  49.732  1.00 26.68           N  
ATOM    432  CA  GLY A 133      45.716  46.574  49.861  1.00 28.61           C  
ATOM    433  C   GLY A 133      46.860  45.669  50.282  1.00 28.48           C  
ATOM    434  O   GLY A 133      48.032  46.033  50.166  1.00 30.16           O  
ATOM    435  N   GLU A 134      46.512  44.478  50.762  1.00 28.02           N  
ATOM    436  CA  GLU A 134      47.485  43.496  51.230  1.00 27.12           C  
ATOM    437  C   GLU A 134      48.168  42.724  50.104  1.00 25.23           C  
ATOM    438  O   GLU A 134      47.542  42.361  49.110  1.00 26.03           O  
ATOM    439  CB  GLU A 134      46.786  42.522  52.190  1.00 28.53           C  
ATOM    440  CG  GLU A 134      47.568  41.276  52.575  1.00 28.88           C  
ATOM    441  CD  GLU A 134      46.918  40.535  53.743  1.00 32.05           C  
ATOM    442  OE1 GLU A 134      45.688  40.656  53.912  1.00 31.49           O  
ATOM    443  OE2 GLU A 134      47.631  39.831  54.490  1.00 34.53           O  
ATOM    444  N   ALA A 135      49.462  42.470  50.271  1.00 24.55           N  
ATOM    445  CA  ALA A 135      50.222  41.722  49.285  1.00 23.06           C  
ATOM    446  C   ALA A 135      50.103  40.240  49.635  1.00 23.34           C  
ATOM    447  O   ALA A 135      50.136  39.867  50.809  1.00 24.03           O  
ATOM    448  CB  ALA A 135      51.685  42.156  49.308  1.00 25.23           C  
ATOM    449  N   VAL A 136      49.952  39.397  48.619  1.00 22.18           N  
ATOM    450  CA  VAL A 136      49.824  37.961  48.834  1.00 21.56           C  
ATOM    451  C   VAL A 136      50.825  37.214  47.970  1.00 23.68           C  
ATOM    452  O   VAL A 136      51.315  37.742  46.966  1.00 23.83           O  
ATOM    453  CB  VAL A 136      48.404  37.463  48.472  1.00 20.51           C  
ATOM    454  CG1 VAL A 136      47.366  38.145  49.353  1.00 21.39           C  
ATOM    455  CG2 VAL A 136      48.122  37.749  46.999  1.00 20.55           C  
ATOM    456  N   ASP A 137      51.138  35.984  48.360  1.00 24.26           N  
ATOM    457  CA  ASP A 137      52.074  35.185  47.589  1.00 26.48           C  
ATOM    458  C   ASP A 137      51.342  34.012  46.953  1.00 25.88           C  
ATOM    459  O   ASP A 137      50.218  33.686  47.333  1.00 25.07           O  
ATOM    460  CB  ASP A 137      53.214  34.678  48.479  1.00 31.01           C  
ATOM    461  CG  ASP A 137      54.255  33.889  47.698  1.00 35.14           C  
ATOM    462  OD1 ASP A 137      54.743  34.388  46.657  1.00 36.86           O  
ATOM    463  OD2 ASP A 137      54.586  32.763  48.126  1.00 39.65           O  
ATOM    464  N   THR A 138      51.978  33.377  45.981  1.00 26.29           N  
ATOM    465  CA  THR A 138      51.370  32.242  45.311  1.00 25.98           C  
ATOM    466  C   THR A 138      50.967  31.164  46.316  1.00 25.80           C  
ATOM    467  O   THR A 138      51.733  30.826  47.219  1.00 26.97           O  
ATOM    468  CB  THR A 138      52.343  31.636  44.282  1.00 27.26           C  
ATOM    469  OG1 THR A 138      52.766  32.661  43.375  1.00 26.29           O  
ATOM    470  CG2 THR A 138      51.670  30.524  43.494  1.00 27.71           C  
ATOM    471  N   GLY A 139      49.757  30.638  46.160  1.00 26.09           N  
ATOM    472  CA  GLY A 139      49.281  29.590  47.042  1.00 24.04           C  
ATOM    473  C   GLY A 139      48.725  30.049  48.377  1.00 23.05           C  
ATOM    474  O   GLY A 139      48.255  29.228  49.164  1.00 25.35           O  
ATOM    475  N   GLN A 140      48.768  31.349  48.644  1.00 22.28           N  
ATOM    476  CA  GLN A 140      48.257  31.858  49.911  1.00 20.33           C  
ATOM    477  C   GLN A 140      46.740  31.783  49.994  1.00 20.16           C  
ATOM    478  O   GLN A 140      46.040  32.155  49.054  1.00 20.44           O  
ATOM    479  CB  GLN A 140      48.692  33.309  50.121  1.00 20.21           C  
ATOM    480  CG  GLN A 140      48.250  33.895  51.463  1.00 19.34           C  
ATOM    481  CD  GLN A 140      48.791  35.292  51.679  1.00 18.91           C  
ATOM    482  OE1 GLN A 140      49.877  35.624  51.200  1.00 21.00           O  
ATOM    483  NE2 GLN A 140      48.049  36.116  52.414  1.00 20.18           N  
ATOM    484  N   PRO A 141      46.213  31.277  51.122  1.00 18.93           N  
ATOM    485  CA  PRO A 141      44.765  31.163  51.331  1.00 19.59           C  
ATOM    486  C   PRO A 141      44.162  32.569  51.308  1.00 17.96           C  
ATOM    487  O   PRO A 141      44.669  33.478  51.969  1.00 17.22           O  
ATOM    488  CB  PRO A 141      44.669  30.513  52.708  1.00 20.67           C  
ATOM    489  CG  PRO A 141      45.915  29.651  52.751  1.00 20.76           C  
ATOM    490  CD  PRO A 141      46.959  30.592  52.194  1.00 19.38           C  
ATOM    491  N   LEU A 142      43.086  32.749  50.546  1.00 16.81           N  
ATOM    492  CA  LEU A 142      42.457  34.059  50.421  1.00 15.94           C  
ATOM    493  C   LEU A 142      41.031  34.074  50.943  1.00 16.10           C  
ATOM    494  O   LEU A 142      40.587  35.056  51.542  1.00 17.22           O  
ATOM    495  CB  LEU A 142      42.435  34.485  48.951  1.00 18.97           C  
ATOM    496  CG  LEU A 142      43.766  34.479  48.204  1.00 16.67           C  
ATOM    497  CD1 LEU A 142      43.515  34.799  46.731  1.00 19.37           C  
ATOM    498  CD2 LEU A 142      44.717  35.487  48.818  1.00 17.31           C  
ATOM    499  N   ILE A 143      40.317  32.985  50.688  1.00 15.76           N  
ATOM    500  CA  ILE A 143      38.924  32.855  51.100  1.00 15.77           C  
ATOM    501  C   ILE A 143      38.647  31.413  51.513  1.00 16.56           C  
ATOM    502  O   ILE A 143      39.175  30.478  50.913  1.00 17.51           O  
ATOM    503  CB  ILE A 143      37.952  33.164  49.922  1.00 17.43           C  
ATOM    504  CG1 ILE A 143      38.206  34.556  49.348  1.00 18.37           C  
ATOM    505  CG2 ILE A 143      36.501  33.032  50.394  1.00 19.47           C  
ATOM    506  CD1 ILE A 143      37.837  35.687  50.267  1.00 17.82           C  
ATOM    507  N   GLU A 144      37.837  31.228  52.552  1.00 16.05           N  
ATOM    508  CA  GLU A 144      37.453  29.878  52.940  1.00 16.69           C  
ATOM    509  C   GLU A 144      35.949  29.795  52.727  1.00 17.07           C  
ATOM    510  O   GLU A 144      35.217  30.700  53.138  1.00 18.14           O  
ATOM    511  CB  GLU A 144      37.780  29.573  54.411  1.00 17.19           C  
ATOM    512  CG  GLU A 144      37.322  28.172  54.822  1.00 20.20           C  
ATOM    513  CD  GLU A 144      37.769  27.760  56.219  1.00 23.91           C  
ATOM    514  OE1 GLU A 144      37.367  26.665  56.660  1.00 26.06           O  
ATOM    515  OE2 GLU A 144      38.520  28.513  56.868  1.00 26.74           O  
ATOM    516  N   LEU A 145      35.498  28.740  52.054  1.00 18.57           N  
ATOM    517  CA  LEU A 145      34.074  28.543  51.801  1.00 19.74           C  
ATOM    518  C   LEU A 145      33.512  27.583  52.842  1.00 20.88           C  
ATOM    519  O   LEU A 145      34.238  26.743  53.366  1.00 21.03           O  
ATOM    520  CB  LEU A 145      33.849  27.989  50.389  1.00 21.09           C  
ATOM    521  CG  LEU A 145      34.316  28.885  49.238  1.00 20.93           C  
ATOM    522  CD1 LEU A 145      33.955  28.214  47.917  1.00 21.57           C  
ATOM    523  CD2 LEU A 145      33.667  30.253  49.316  1.00 19.16           C  
ATOM    524  N   GLY A 146      32.222  27.717  53.139  1.00 20.02           N  
ATOM    525  CA  GLY A 146      31.592  26.869  54.136  1.00 22.88           C  
ATOM    526  C   GLY A 146      31.175  25.501  53.633  1.00 24.53           C  
ATOM    527  O   GLY A 146      31.320  25.235  52.424  1.00 26.07           O  
ATOM    528  OXT GLY A 146      30.695  24.686  54.450  1.00 26.07           O  
TER     529      GLY A 146                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
