
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   81 ( 1188),  selected   81 , name 1gjx_A
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 1gjx_A.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      -       -           -
LGA    L     2_A      L      83          1.839
LGA    V     3_A      I      84          0.594
LGA    E     4_A      S      85          0.877
LGA    L     5_A      V      86          0.893
LGA    K     6_A      P      87          0.444
LGA    V     7_A      A      88          1.590
LGA    P     8_A      E      89          4.367
LGA    D     9_A      G      90          5.574
LGA    I    10_A      -       -           -
LGA    G    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    H    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    N    15_A      -       -           -
LGA    V    16_A      Y      91          2.487
LGA    D    17_A      K      92          2.293
LGA    I    18_A      V      93          1.899
LGA    I    19_A      Y      94          3.274
LGA    A    20_A      -       -           -
LGA    V    21_A      P      95          3.022
LGA    E    22_A      I      96          2.227
LGA    V    23_A      M      97          4.046
LGA    N    24_A      D      98          1.209
LGA    V    25_A      F      99          1.296
LGA    G    26_A      G     100          0.570
LGA    D    27_A      F     101          0.459
LGA    T    28_A      R     102          0.312
LGA    I    29_A      V     103          1.613
LGA    A    30_A      L     104          1.571
LGA    V    31_A      K     105          1.075
LGA    D    32_A      G     106          0.697
LGA    D    33_A      Y     107          0.642
LGA    T    34_A      R     108          0.704
LGA    L    35_A      L     109          0.743
LGA    I    36_A      A     110          1.266
LGA    T    37_A      T     111          0.632
LGA    L    38_A      L     112          1.641
LGA    E    39_A      E     113          1.108
LGA    T    40_A      S     114          2.926
LGA    D    41_A      K     115          0.574
LGA    K    42_A      K     116          3.281
LGA    -       -      G     117           -
LGA    A    43_A      D     118          1.754
LGA    T    44_A      L     119          1.737
LGA    M    45_A      R     120          1.850
LGA    D    46_A      Y     121          1.589
LGA    V    47_A      V     122          0.856
LGA    P    48_A      N     123          1.667
LGA    A    49_A      S     124          1.281
LGA    E    50_A      P     125          1.014
LGA    V    51_A      V     126          1.750
LGA    A    52_A      S     127          1.562
LGA    G    53_A      G     128          1.160
LGA    V    54_A      T     129          0.916
LGA    V    55_A      V     130          1.354
LGA    K    56_A      I     131          1.646
LGA    E    57_A      F     132          1.436
LGA    V    58_A      M     133          0.777
LGA    K    59_A      N     134          1.477
LGA    V    60_A      E     135          5.034
LGA    K    61_A      I     136           -
LGA    V    62_A      P     137           -
LGA    G    63_A      S     138           -
LGA    D    64_A      -       -           -
LGA    K    65_A      E     139           #
LGA    -       -      R     140           -
LGA    I    66_A      A     141          2.161
LGA    S    67_A      N     142          3.959
LGA    E    68_A      -       -           -
LGA    G    69_A      -       -           -
LGA    G    70_A      -       -           -
LGA    L    71_A      Y     143          5.277
LGA    I    72_A      V     144          0.968
LGA    V    73_A      F     145          0.748
LGA    V    74_A      Y     146          0.245
LGA    V    75_A      M     147          0.518
LGA    E    76_A      L     148          0.438
LGA    A    77_A      E     149          0.937
LGA    E    78_A      E     150          1.935
LGA    G    79_A      -       -           -
LGA    T    80_A      -       -           -
LGA    A    81_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   81   68    5.0     62    2.08    19.35     75.205     2.848

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.851599 * X  +   0.072646 * Y  +  -0.519136 * Z  +  39.704433
  Y_new =   0.470874 * X  +  -0.541196 * Y  +   0.696695 * Z  +  35.753162
  Z_new =  -0.230342 * X  +  -0.837752 * Y  +  -0.495089 * Z  +  46.652508 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.104552    1.037040  [ DEG:  -120.5820     59.4180 ]
  Theta =   0.232429    2.909163  [ DEG:    13.3172    166.6828 ]
  Phi   =   0.505089   -2.636503  [ DEG:    28.9395   -151.0605 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gjx_A                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gjx_A.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   81   68   5.0   62   2.08   19.35  75.205
REMARK  ---------------------------------------------------------- 
MOLECULE 1gjx_A
HEADER    OXIDOREDUCTASE                          03-AUG-01   1GJX              
TITLE     SOLUTION STRUCTURE OF THE LIPOYL DOMAIN OF THE CHIMERIC               
TITLE    2 DIHYDROLIPOYL DEHYDROGENASE P64K FROM NEISSERIA                      
TITLE    3 MENINGITIDIS                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PYRUVATE DEHYDROGENASE;                                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: LIPOYL DOMAIN RESIDUES 2-82;                               
COMPND   5 SYNONYM: LIPOAMIDE DEHYDROGENASE, E3 COMPONENT;                      
COMPND   6 EC: 1.8.1.4;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS;                         
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: XL1-BLUE;                                  
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PM-143                                    
KEYWDS    LIPOYL DOMAIN, DIHYDROLIPOYL DEHYDROGENASE, MULTIENZYME               
KEYWDS   2 COMPLEX, NEISSERIA MENINGITIDIS, POST-TRANSLATIONAL                  
KEYWDS   3 MODIFICATION                                                         
EXPDTA    NMR, 18 STRUCTURES                                                    
AUTHOR    K.TOZAWA,R.W.BROADHURST,A.R.C.RAINE,C.FULLER,A.ALVAREZ,               
AUTHOR   2 G.GUILLEN,G.PADRON,R.N.PERHAM                                        
REVDAT   1   28-NOV-01 1GJX    0                                                
JRNL        AUTH   K.TOZAWA,R.W.BROADHURST,A.R.RAINE,C.FULLER,                  
JRNL        AUTH 2 A.ALVAREZ,G.GUILLEN,G.PADRON,R.N.PERHAM                      
JRNL        TITL   SOLUTION STRUCTURE OF THE LIPOYL DOMAIN OF THE               
JRNL        TITL 2 CHIMERIC DIHYDROLIPOYL DEHYDROGENASE P64K FROM               
JRNL        TITL 3 NEISSERIA MENINGITIDIS.                                      
JRNL        REF    EUR.J.BIOCHEM.                V. 268  4908 2001              
JRNL        REFN   ASTM EJBCAI  IX ISSN 0014-2956                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1GJX A    1    81  UNP    Q9JZ09   Q9JZ09_NEIMB     2     82             
SEQRES   1 A   81  ALA LEU VAL GLU LEU LYS VAL PRO ASP ILE GLY GLY HIS          
SEQRES   2 A   81  GLU ASN VAL ASP ILE ILE ALA VAL GLU VAL ASN VAL GLY          
SEQRES   3 A   81  ASP THR ILE ALA VAL ASP ASP THR LEU ILE THR LEU GLU          
SEQRES   4 A   81  THR ASP LYS ALA THR MET ASP VAL PRO ALA GLU VAL ALA          
SEQRES   5 A   81  GLY VAL VAL LYS GLU VAL LYS VAL LYS VAL GLY ASP LYS          
SEQRES   6 A   81  ILE SER GLU GLY GLY LEU ILE VAL VAL VAL GLU ALA GLU          
SEQRES   7 A   81  GLY THR ALA                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ALA A   1      35.083  18.643  52.790  1.00  0.00           N  
ATOM      2  CA  ALA A   1      34.007  19.668  52.741  1.00  0.00           C  
ATOM      3  C   ALA A   1      34.589  21.077  52.804  1.00  0.00           C  
ATOM      4  O   ALA A   1      35.775  21.256  53.080  1.00  0.00           O  
ATOM      5  CB  ALA A   1      33.021  19.452  53.879  1.00  0.00           C  
ATOM      6  H2  ALA A   1      35.260  18.420  53.791  1.00  0.00           H  
ATOM      7  HA  ALA A   1      33.472  19.554  51.810  1.00  0.00           H  
ATOM      8  HB1 ALA A   1      33.384  18.667  54.527  1.00  0.00           H  
ATOM      9  HB2 ALA A   1      32.060  19.170  53.475  1.00  0.00           H  
ATOM     10  HB3 ALA A   1      32.919  20.367  54.445  1.00  0.00           H  
ATOM     11  H1  ALA A   1      35.927  19.052  52.341  1.00  0.00           H  
ATOM     12  H3  ALA A   1      34.748  17.807  52.273  1.00  0.00           H  
ATOM     13  N   LEU A   2      33.746  22.072  52.547  1.00  0.00           N  
ATOM     14  CA  LEU A   2      34.177  23.466  52.576  1.00  0.00           C  
ATOM     15  C   LEU A   2      35.343  23.693  51.619  1.00  0.00           C  
ATOM     16  O   LEU A   2      35.884  22.746  51.049  1.00  0.00           O  
ATOM     17  CB  LEU A   2      34.580  23.868  53.995  1.00  0.00           C  
ATOM     18  CG  LEU A   2      33.452  23.818  55.028  1.00  0.00           C  
ATOM     19  CD1 LEU A   2      33.756  22.786  56.101  1.00  0.00           C  
ATOM     20  CD2 LEU A   2      33.236  25.189  55.649  1.00  0.00           C  
ATOM     21  H   LEU A   2      32.812  21.865  52.334  1.00  0.00           H  
ATOM     22  HA  LEU A   2      33.344  24.076  52.260  1.00  0.00           H  
ATOM     23  HB2 LEU A   2      35.370  23.209  54.324  1.00  0.00           H  
ATOM     24  HB3 LEU A   2      34.965  24.877  53.965  1.00  0.00           H  
ATOM     25  HG  LEU A   2      32.535  23.526  54.534  1.00  0.00           H  
ATOM     26 HD11 LEU A   2      34.820  22.598  56.130  1.00  0.00           H  
ATOM     27 HD12 LEU A   2      33.431  23.158  57.061  1.00  0.00           H  
ATOM     28 HD13 LEU A   2      33.234  21.867  55.876  1.00  0.00           H  
ATOM     29 HD21 LEU A   2      33.407  25.953  54.905  1.00  0.00           H  
ATOM     30 HD22 LEU A   2      32.222  25.263  56.015  1.00  0.00           H  
ATOM     31 HD23 LEU A   2      33.926  25.324  56.469  1.00  0.00           H  
ATOM     32  N   VAL A   3      35.721  24.955  51.443  1.00  0.00           N  
ATOM     33  CA  VAL A   3      36.820  25.306  50.551  1.00  0.00           C  
ATOM     34  C   VAL A   3      37.542  26.562  51.041  1.00  0.00           C  
ATOM     35  O   VAL A   3      37.009  27.328  51.837  1.00  0.00           O  
ATOM     36  CB  VAL A   3      36.304  25.512  49.100  1.00  0.00           C  
ATOM     37  CG1 VAL A   3      37.260  26.357  48.260  1.00  0.00           C  
ATOM     38  CG2 VAL A   3      36.060  24.167  48.437  1.00  0.00           C  
ATOM     39  H   VAL A   3      35.248  25.667  51.923  1.00  0.00           H  
ATOM     40  HA  VAL A   3      37.519  24.482  50.547  1.00  0.00           H  
ATOM     41  HB  VAL A   3      35.359  26.031  49.151  1.00  0.00           H  
ATOM     42 HG11 VAL A   3      37.408  27.317  48.739  1.00  0.00           H  
ATOM     43 HG12 VAL A   3      38.209  25.849  48.174  1.00  0.00           H  
ATOM     44 HG13 VAL A   3      36.841  26.506  47.276  1.00  0.00           H  
ATOM     45 HG21 VAL A   3      36.785  23.451  48.799  1.00  0.00           H  
ATOM     46 HG22 VAL A   3      35.066  23.821  48.673  1.00  0.00           H  
ATOM     47 HG23 VAL A   3      36.160  24.269  47.366  1.00  0.00           H  
ATOM     48  N   GLU A   4      38.758  26.759  50.538  1.00  0.00           N  
ATOM     49  CA  GLU A   4      39.570  27.917  50.895  1.00  0.00           C  
ATOM     50  C   GLU A   4      40.185  28.532  49.641  1.00  0.00           C  
ATOM     51  O   GLU A   4      41.104  27.966  49.049  1.00  0.00           O  
ATOM     52  CB  GLU A   4      40.675  27.533  51.891  1.00  0.00           C  
ATOM     53  CG  GLU A   4      40.937  26.037  51.991  1.00  0.00           C  
ATOM     54  CD  GLU A   4      41.804  25.675  53.179  1.00  0.00           C  
ATOM     55  OE1 GLU A   4      41.270  25.615  54.307  1.00  0.00           O  
ATOM     56  OE2 GLU A   4      43.018  25.454  52.984  1.00  0.00           O  
ATOM     57  H   GLU A   4      39.118  26.108  49.898  1.00  0.00           H  
ATOM     58  HA  GLU A   4      38.921  28.646  51.354  1.00  0.00           H  
ATOM     59  HB2 GLU A   4      41.593  28.014  51.589  1.00  0.00           H  
ATOM     60  HB3 GLU A   4      40.397  27.892  52.870  1.00  0.00           H  
ATOM     61  HG2 GLU A   4      39.990  25.525  52.085  1.00  0.00           H  
ATOM     62  HG3 GLU A   4      41.432  25.709  51.087  1.00  0.00           H  
ATOM     63  N   LEU A   5      39.666  29.687  49.233  1.00  0.00           N  
ATOM     64  CA  LEU A   5      40.159  30.366  48.039  1.00  0.00           C  
ATOM     65  C   LEU A   5      41.673  30.535  48.085  1.00  0.00           C  
ATOM     66  O   LEU A   5      42.336  30.058  49.006  1.00  0.00           O  
ATOM     67  CB  LEU A   5      39.486  31.732  47.874  1.00  0.00           C  
ATOM     68  CG  LEU A   5      38.597  31.865  46.637  1.00  0.00           C  
ATOM     69  CD1 LEU A   5      39.422  31.705  45.369  1.00  0.00           C  
ATOM     70  CD2 LEU A   5      37.473  30.843  46.677  1.00  0.00           C  
ATOM     71  H   LEU A   5      38.927  30.088  49.742  1.00  0.00           H  
ATOM     72  HA  LEU A   5      39.908  29.751  47.186  1.00  0.00           H  
ATOM     73  HB2 LEU A   5      38.882  31.921  48.747  1.00  0.00           H  
ATOM     74  HB3 LEU A   5      40.255  32.486  47.819  1.00  0.00           H  
ATOM     75  HG  LEU A   5      38.156  32.852  46.626  1.00  0.00           H  
ATOM     76 HD11 LEU A   5      40.041  30.824  45.451  1.00  0.00           H  
ATOM     77 HD12 LEU A   5      38.761  31.604  44.521  1.00  0.00           H  
ATOM     78 HD13 LEU A   5      40.050  32.575  45.235  1.00  0.00           H  
ATOM     79 HD21 LEU A   5      37.351  30.482  47.689  1.00  0.00           H  
ATOM     80 HD22 LEU A   5      36.555  31.304  46.346  1.00  0.00           H  
ATOM     81 HD23 LEU A   5      37.714  30.015  46.025  1.00  0.00           H  
ATOM     82  N   LYS A   6      42.210  31.216  47.079  1.00  0.00           N  
ATOM     83  CA  LYS A   6      43.645  31.452  46.993  1.00  0.00           C  
ATOM     84  C   LYS A   6      43.953  32.551  45.984  1.00  0.00           C  
ATOM     85  O   LYS A   6      43.299  32.655  44.945  1.00  0.00           O  
ATOM     86  CB  LYS A   6      44.367  30.161  46.603  1.00  0.00           C  
ATOM     87  CG  LYS A   6      44.577  29.210  47.769  1.00  0.00           C  
ATOM     88  CD  LYS A   6      45.938  28.537  47.701  1.00  0.00           C  
ATOM     89  CE  LYS A   6      45.830  27.039  47.929  1.00  0.00           C  
ATOM     90  NZ  LYS A   6      46.040  26.268  46.672  1.00  0.00           N  
ATOM     91  H   LYS A   6      41.627  31.567  46.376  1.00  0.00           H  
ATOM     92  HA  LYS A   6      43.989  31.767  47.966  1.00  0.00           H  
ATOM     93  HB2 LYS A   6      43.785  29.652  45.850  1.00  0.00           H  
ATOM     94  HB3 LYS A   6      45.332  30.413  46.192  1.00  0.00           H  
ATOM     95  HG2 LYS A   6      44.507  29.765  48.694  1.00  0.00           H  
ATOM     96  HG3 LYS A   6      43.809  28.450  47.744  1.00  0.00           H  
ATOM     97  HD2 LYS A   6      46.366  28.712  46.725  1.00  0.00           H  
ATOM     98  HD3 LYS A   6      46.577  28.964  48.458  1.00  0.00           H  
ATOM     99  HE2 LYS A   6      46.575  26.742  48.652  1.00  0.00           H  
ATOM    100  HE3 LYS A   6      44.846  26.817  48.317  1.00  0.00           H  
ATOM    101  HZ1 LYS A   6      46.568  26.842  45.985  1.00  0.00           H  
ATOM    102  HZ2 LYS A   6      46.578  25.402  46.870  1.00  0.00           H  
ATOM    103  HZ3 LYS A   6      45.122  26.005  46.256  1.00  0.00           H  
ATOM    104  N   VAL A   7      44.948  33.370  46.299  1.00  0.00           N  
ATOM    105  CA  VAL A   7      45.346  34.467  45.423  1.00  0.00           C  
ATOM    106  C   VAL A   7      45.527  33.982  43.985  1.00  0.00           C  
ATOM    107  O   VAL A   7      46.073  32.904  43.752  1.00  0.00           O  
ATOM    108  CB  VAL A   7      46.652  35.125  45.911  1.00  0.00           C  
ATOM    109  CG1 VAL A   7      47.060  36.259  44.981  1.00  0.00           C  
ATOM    110  CG2 VAL A   7      46.495  35.622  47.342  1.00  0.00           C  
ATOM    111  H   VAL A   7      45.427  33.233  47.141  1.00  0.00           H  
ATOM    112  HA  VAL A   7      44.564  35.210  45.447  1.00  0.00           H  
ATOM    113  HB  VAL A   7      47.437  34.386  45.898  1.00  0.00           H  
ATOM    114 HG11 VAL A   7      47.034  35.912  43.959  1.00  0.00           H  
ATOM    115 HG12 VAL A   7      46.374  37.083  45.098  1.00  0.00           H  
ATOM    116 HG13 VAL A   7      48.061  36.583  45.226  1.00  0.00           H  
ATOM    117 HG21 VAL A   7      46.153  34.810  47.968  1.00  0.00           H  
ATOM    118 HG22 VAL A   7      47.445  35.980  47.706  1.00  0.00           H  
ATOM    119 HG23 VAL A   7      45.773  36.423  47.368  1.00  0.00           H  
ATOM    120  N   PRO A   8      45.059  34.768  42.999  1.00  0.00           N  
ATOM    121  CA  PRO A   8      45.167  34.401  41.586  1.00  0.00           C  
ATOM    122  C   PRO A   8      46.587  34.514  41.051  1.00  0.00           C  
ATOM    123  O   PRO A   8      47.545  34.646  41.813  1.00  0.00           O  
ATOM    124  CB  PRO A   8      44.261  35.407  40.879  1.00  0.00           C  
ATOM    125  CG  PRO A   8      44.220  36.593  41.782  1.00  0.00           C  
ATOM    126  CD  PRO A   8      44.384  36.067  43.185  1.00  0.00           C  
ATOM    127  HA  PRO A   8      44.800  33.401  41.410  1.00  0.00           H  
ATOM    128  HB2 PRO A   8      44.682  35.655  39.915  1.00  0.00           H  
ATOM    129  HB3 PRO A   8      43.278  34.979  40.747  1.00  0.00           H  
ATOM    130  HG2 PRO A   8      45.026  37.269  41.537  1.00  0.00           H  
ATOM    131  HG3 PRO A   8      43.268  37.095  41.681  1.00  0.00           H  
ATOM    132  HD2 PRO A   8      44.999  36.740  43.766  1.00  0.00           H  
ATOM    133  HD3 PRO A   8      43.420  35.937  43.653  1.00  0.00           H  
ATOM    134  N   ASP A   9      46.708  34.457  39.732  1.00  0.00           N  
ATOM    135  CA  ASP A   9      48.001  34.545  39.071  1.00  0.00           C  
ATOM    136  C   ASP A   9      48.300  35.979  38.646  1.00  0.00           C  
ATOM    137  O   ASP A   9      48.316  36.291  37.455  1.00  0.00           O  
ATOM    138  CB  ASP A   9      48.014  33.630  37.850  1.00  0.00           C  
ATOM    139  CG  ASP A   9      48.791  32.350  38.092  1.00  0.00           C  
ATOM    140  OD1 ASP A   9      49.524  32.283  39.101  1.00  0.00           O  
ATOM    141  OD2 ASP A   9      48.668  31.417  37.272  1.00  0.00           O  
ATOM    142  H   ASP A   9      45.902  34.346  39.186  1.00  0.00           H  
ATOM    143  HA  ASP A   9      48.758  34.218  39.767  1.00  0.00           H  
ATOM    144  HB2 ASP A   9      46.995  33.369  37.600  1.00  0.00           H  
ATOM    145  HB3 ASP A   9      48.463  34.153  37.019  1.00  0.00           H  
ATOM    146  N   ILE A  10      48.532  36.847  39.622  1.00  0.00           N  
ATOM    147  CA  ILE A  10      48.826  38.247  39.335  1.00  0.00           C  
ATOM    148  C   ILE A  10      50.022  38.385  38.394  1.00  0.00           C  
ATOM    149  O   ILE A  10      50.201  39.420  37.754  1.00  0.00           O  
ATOM    150  CB  ILE A  10      49.092  39.068  40.617  1.00  0.00           C  
ATOM    151  CG1 ILE A  10      49.770  38.215  41.695  1.00  0.00           C  
ATOM    152  CG2 ILE A  10      47.791  39.655  41.142  1.00  0.00           C  
ATOM    153  CD1 ILE A  10      50.933  37.395  41.182  1.00  0.00           C  
ATOM    154  H   ILE A  10      48.502  36.540  40.551  1.00  0.00           H  
ATOM    155  HA  ILE A  10      47.959  38.668  38.846  1.00  0.00           H  
ATOM    156  HB  ILE A  10      49.743  39.888  40.359  1.00  0.00           H  
ATOM    157 HG12 ILE A  10      50.143  38.863  42.475  1.00  0.00           H  
ATOM    158 HG13 ILE A  10      49.044  37.535  42.118  1.00  0.00           H  
ATOM    159 HG21 ILE A  10      47.351  40.291  40.387  1.00  0.00           H  
ATOM    160 HG22 ILE A  10      47.107  38.855  41.385  1.00  0.00           H  
ATOM    161 HG23 ILE A  10      47.992  40.238  42.029  1.00  0.00           H  
ATOM    162 HD11 ILE A  10      51.456  37.951  40.418  1.00  0.00           H  
ATOM    163 HD12 ILE A  10      51.609  37.180  41.998  1.00  0.00           H  
ATOM    164 HD13 ILE A  10      50.565  36.468  40.768  1.00  0.00           H  
ATOM    165  N   GLY A  11      50.836  37.333  38.307  1.00  0.00           N  
ATOM    166  CA  GLY A  11      51.994  37.366  37.434  1.00  0.00           C  
ATOM    167  C   GLY A  11      53.303  37.377  38.198  1.00  0.00           C  
ATOM    168  O   GLY A  11      54.174  36.541  37.961  1.00  0.00           O  
ATOM    169  H   GLY A  11      50.646  36.531  38.835  1.00  0.00           H  
ATOM    170  HA2 GLY A  11      51.972  36.496  36.794  1.00  0.00           H  
ATOM    171  HA3 GLY A  11      51.941  38.253  36.819  1.00  0.00           H  
ATOM    172  N   GLY A  12      53.443  38.330  39.113  1.00  0.00           N  
ATOM    173  CA  GLY A  12      54.660  38.431  39.898  1.00  0.00           C  
ATOM    174  C   GLY A  12      54.885  37.221  40.780  1.00  0.00           C  
ATOM    175  O   GLY A  12      55.557  36.269  40.382  1.00  0.00           O  
ATOM    176  H   GLY A  12      52.716  38.970  39.256  1.00  0.00           H  
ATOM    177  HA2 GLY A  12      55.500  38.534  39.227  1.00  0.00           H  
ATOM    178  HA3 GLY A  12      54.600  39.312  40.520  1.00  0.00           H  
ATOM    179  N   HIS A  13      54.323  37.256  41.983  1.00  0.00           N  
ATOM    180  CA  HIS A  13      54.466  36.155  42.929  1.00  0.00           C  
ATOM    181  C   HIS A  13      53.828  36.503  44.270  1.00  0.00           C  
ATOM    182  O   HIS A  13      52.669  36.170  44.521  1.00  0.00           O  
ATOM    183  CB  HIS A  13      55.945  35.794  43.126  1.00  0.00           C  
ATOM    184  CG  HIS A  13      56.892  36.934  42.898  1.00  0.00           C  
ATOM    185  ND1 HIS A  13      56.528  38.259  43.030  1.00  0.00           N  
ATOM    186  CD2 HIS A  13      58.200  36.941  42.543  1.00  0.00           C  
ATOM    187  CE1 HIS A  13      57.569  39.029  42.764  1.00  0.00           C  
ATOM    188  NE2 HIS A  13      58.594  38.254  42.467  1.00  0.00           N  
ATOM    189  H   HIS A  13      53.799  38.044  42.243  1.00  0.00           H  
ATOM    190  HA  HIS A  13      53.951  35.301  42.516  1.00  0.00           H  
ATOM    191  HB2 HIS A  13      56.089  35.445  44.137  1.00  0.00           H  
ATOM    192  HB3 HIS A  13      56.207  35.001  42.440  1.00  0.00           H  
ATOM    193  HD1 HIS A  13      55.640  38.587  43.284  1.00  0.00           H  
ATOM    194  HD2 HIS A  13      58.816  36.073  42.355  1.00  0.00           H  
ATOM    195  HE1 HIS A  13      57.579  40.108  42.788  1.00  0.00           H  
ATOM    196  HE2 HIS A  13      59.505  38.565  42.282  1.00  0.00           H  
ATOM    197  N   GLU A  14      54.588  37.172  45.129  1.00  0.00           N  
ATOM    198  CA  GLU A  14      54.094  37.562  46.443  1.00  0.00           C  
ATOM    199  C   GLU A  14      53.974  39.078  46.551  1.00  0.00           C  
ATOM    200  O   GLU A  14      54.321  39.808  45.622  1.00  0.00           O  
ATOM    201  CB  GLU A  14      55.021  37.033  47.537  1.00  0.00           C  
ATOM    202  CG  GLU A  14      56.425  37.610  47.476  1.00  0.00           C  
ATOM    203  CD  GLU A  14      57.495  36.568  47.747  1.00  0.00           C  
ATOM    204  OE1 GLU A  14      57.597  36.109  48.903  1.00  0.00           O  
ATOM    205  OE2 GLU A  14      58.231  36.214  46.801  1.00  0.00           O  
ATOM    206  H   GLU A  14      55.502  37.408  44.874  1.00  0.00           H  
ATOM    207  HA  GLU A  14      53.115  37.128  46.572  1.00  0.00           H  
ATOM    208  HB2 GLU A  14      54.596  37.274  48.500  1.00  0.00           H  
ATOM    209  HB3 GLU A  14      55.092  35.959  47.443  1.00  0.00           H  
ATOM    210  HG2 GLU A  14      56.589  38.024  46.494  1.00  0.00           H  
ATOM    211  HG3 GLU A  14      56.512  38.392  48.216  1.00  0.00           H  
ATOM    212  N   ASN A  15      53.481  39.542  47.695  1.00  0.00           N  
ATOM    213  CA  ASN A  15      53.311  40.973  47.941  1.00  0.00           C  
ATOM    214  C   ASN A  15      52.690  41.678  46.737  1.00  0.00           C  
ATOM    215  O   ASN A  15      53.350  42.463  46.057  1.00  0.00           O  
ATOM    216  CB  ASN A  15      54.654  41.617  48.292  1.00  0.00           C  
ATOM    217  CG  ASN A  15      55.654  41.541  47.154  1.00  0.00           C  
ATOM    218  OD1 ASN A  15      56.258  40.495  46.912  1.00  0.00           O  
ATOM    219  ND2 ASN A  15      55.837  42.652  46.451  1.00  0.00           N  
ATOM    220  H   ASN A  15      53.223  38.905  48.393  1.00  0.00           H  
ATOM    221  HA  ASN A  15      52.644  41.081  48.784  1.00  0.00           H  
ATOM    222  HB2 ASN A  15      54.494  42.656  48.534  1.00  0.00           H  
ATOM    223  HB3 ASN A  15      55.074  41.113  49.151  1.00  0.00           H  
ATOM    224 HD21 ASN A  15      55.324  43.449  46.702  1.00  0.00           H  
ATOM    225 HD22 ASN A  15      56.478  42.631  45.710  1.00  0.00           H  
ATOM    226  N   VAL A  16      51.414  41.399  46.486  1.00  0.00           N  
ATOM    227  CA  VAL A  16      50.702  42.012  45.372  1.00  0.00           C  
ATOM    228  C   VAL A  16      49.424  42.682  45.860  1.00  0.00           C  
ATOM    229  O   VAL A  16      48.589  42.054  46.510  1.00  0.00           O  
ATOM    230  CB  VAL A  16      50.357  40.981  44.278  1.00  0.00           C  
ATOM    231  CG1 VAL A  16      51.616  40.282  43.789  1.00  0.00           C  
ATOM    232  CG2 VAL A  16      49.337  39.972  44.785  1.00  0.00           C  
ATOM    233  H   VAL A  16      50.940  40.769  47.070  1.00  0.00           H  
ATOM    234  HA  VAL A  16      51.348  42.763  44.940  1.00  0.00           H  
ATOM    235  HB  VAL A  16      49.922  41.511  43.441  1.00  0.00           H  
ATOM    236 HG11 VAL A  16      52.482  40.860  44.071  1.00  0.00           H  
ATOM    237 HG12 VAL A  16      51.677  39.300  44.236  1.00  0.00           H  
ATOM    238 HG13 VAL A  16      51.581  40.187  42.713  1.00  0.00           H  
ATOM    239 HG21 VAL A  16      49.227  40.078  45.853  1.00  0.00           H  
ATOM    240 HG22 VAL A  16      48.387  40.149  44.306  1.00  0.00           H  
ATOM    241 HG23 VAL A  16      49.677  38.972  44.556  1.00  0.00           H  
ATOM    242  N   ASP A  17      49.284  43.965  45.553  1.00  0.00           N  
ATOM    243  CA  ASP A  17      48.116  44.725  45.974  1.00  0.00           C  
ATOM    244  C   ASP A  17      46.861  44.293  45.223  1.00  0.00           C  
ATOM    245  O   ASP A  17      46.809  44.345  43.992  1.00  0.00           O  
ATOM    246  CB  ASP A  17      48.358  46.221  45.764  1.00  0.00           C  
ATOM    247  CG  ASP A  17      49.548  46.730  46.554  1.00  0.00           C  
ATOM    248  OD1 ASP A  17      50.010  46.008  47.461  1.00  0.00           O  
ATOM    249  OD2 ASP A  17      50.017  47.850  46.264  1.00  0.00           O  
ATOM    250  H   ASP A  17      49.987  44.413  45.041  1.00  0.00           H  
ATOM    251  HA  ASP A  17      47.968  44.541  47.026  1.00  0.00           H  
ATOM    252  HB2 ASP A  17      48.538  46.407  44.716  1.00  0.00           H  
ATOM    253  HB3 ASP A  17      47.480  46.768  46.078  1.00  0.00           H  
ATOM    254  N   ILE A  18      45.842  43.883  45.975  1.00  0.00           N  
ATOM    255  CA  ILE A  18      44.580  43.468  45.390  1.00  0.00           C  
ATOM    256  C   ILE A  18      43.954  44.639  44.644  1.00  0.00           C  
ATOM    257  O   ILE A  18      44.362  45.786  44.834  1.00  0.00           O  
ATOM    258  CB  ILE A  18      43.618  42.956  46.483  1.00  0.00           C  
ATOM    259  CG1 ILE A  18      44.140  41.642  47.055  1.00  0.00           C  
ATOM    260  CG2 ILE A  18      42.206  42.774  45.941  1.00  0.00           C  
ATOM    261  CD1 ILE A  18      44.241  41.636  48.566  1.00  0.00           C  
ATOM    262  H   ILE A  18      45.938  43.877  46.950  1.00  0.00           H  
ATOM    263  HA  ILE A  18      44.776  42.665  44.695  1.00  0.00           H  
ATOM    264  HB  ILE A  18      43.581  43.690  47.271  1.00  0.00           H  
ATOM    265 HG12 ILE A  18      43.476  40.844  46.762  1.00  0.00           H  
ATOM    266 HG13 ILE A  18      45.124  41.452  46.654  1.00  0.00           H  
ATOM    267 HG21 ILE A  18      42.235  42.147  45.063  1.00  0.00           H  
ATOM    268 HG22 ILE A  18      41.588  42.309  46.694  1.00  0.00           H  
ATOM    269 HG23 ILE A  18      41.796  43.738  45.684  1.00  0.00           H  
ATOM    270 HD11 ILE A  18      43.775  42.526  48.962  1.00  0.00           H  
ATOM    271 HD12 ILE A  18      43.741  40.763  48.956  1.00  0.00           H  
ATOM    272 HD13 ILE A  18      45.282  41.616  48.856  1.00  0.00           H  
ATOM    273  N   ILE A  19      42.977  44.362  43.793  1.00  0.00           N  
ATOM    274  CA  ILE A  19      42.337  45.440  43.035  1.00  0.00           C  
ATOM    275  C   ILE A  19      40.810  45.428  43.203  1.00  0.00           C  
ATOM    276  O   ILE A  19      40.138  46.395  42.843  1.00  0.00           O  
ATOM    277  CB  ILE A  19      42.750  45.439  41.512  1.00  0.00           C  
ATOM    278  CG1 ILE A  19      41.566  45.157  40.572  1.00  0.00           C  
ATOM    279  CG2 ILE A  19      43.878  44.447  41.231  1.00  0.00           C  
ATOM    280  CD1 ILE A  19      41.885  45.370  39.110  1.00  0.00           C  
ATOM    281  H   ILE A  19      42.688  43.425  43.669  1.00  0.00           H  
ATOM    282  HA  ILE A  19      42.699  46.365  43.462  1.00  0.00           H  
ATOM    283  HB  ILE A  19      43.134  46.424  41.287  1.00  0.00           H  
ATOM    284 HG12 ILE A  19      41.256  44.135  40.694  1.00  0.00           H  
ATOM    285 HG13 ILE A  19      40.746  45.812  40.827  1.00  0.00           H  
ATOM    286 HG21 ILE A  19      44.464  44.294  42.124  1.00  0.00           H  
ATOM    287 HG22 ILE A  19      43.459  43.506  40.910  1.00  0.00           H  
ATOM    288 HG23 ILE A  19      44.513  44.839  40.450  1.00  0.00           H  
ATOM    289 HD11 ILE A  19      42.391  46.315  38.987  1.00  0.00           H  
ATOM    290 HD12 ILE A  19      42.522  44.572  38.761  1.00  0.00           H  
ATOM    291 HD13 ILE A  19      40.968  45.375  38.541  1.00  0.00           H  
ATOM    292  N   ALA A  20      40.266  44.344  43.742  1.00  0.00           N  
ATOM    293  CA  ALA A  20      38.828  44.240  43.937  1.00  0.00           C  
ATOM    294  C   ALA A  20      38.490  43.305  45.093  1.00  0.00           C  
ATOM    295  O   ALA A  20      39.170  42.304  45.314  1.00  0.00           O  
ATOM    296  CB  ALA A  20      38.167  43.763  42.654  1.00  0.00           C  
ATOM    297  H   ALA A  20      40.839  43.598  44.009  1.00  0.00           H  
ATOM    298  HA  ALA A  20      38.451  45.226  44.161  1.00  0.00           H  
ATOM    299  HB1 ALA A  20      38.660  44.214  41.806  1.00  0.00           H  
ATOM    300  HB2 ALA A  20      38.248  42.689  42.587  1.00  0.00           H  
ATOM    301  HB3 ALA A  20      37.125  44.046  42.659  1.00  0.00           H  
ATOM    302  N   VAL A  21      37.432  43.639  45.827  1.00  0.00           N  
ATOM    303  CA  VAL A  21      37.004  42.828  46.959  1.00  0.00           C  
ATOM    304  C   VAL A  21      35.486  42.826  47.095  1.00  0.00           C  
ATOM    305  O   VAL A  21      34.862  43.879  47.223  1.00  0.00           O  
ATOM    306  CB  VAL A  21      37.624  43.327  48.278  1.00  0.00           C  
ATOM    307  CG1 VAL A  21      37.157  44.741  48.590  1.00  0.00           C  
ATOM    308  CG2 VAL A  21      37.276  42.380  49.419  1.00  0.00           C  
ATOM    309  H   VAL A  21      36.930  44.449  45.600  1.00  0.00           H  
ATOM    310  HA  VAL A  21      37.340  41.818  46.789  1.00  0.00           H  
ATOM    311  HB  VAL A  21      38.697  43.342  48.166  1.00  0.00           H  
ATOM    312 HG11 VAL A  21      37.096  45.309  47.673  1.00  0.00           H  
ATOM    313 HG12 VAL A  21      36.184  44.705  49.056  1.00  0.00           H  
ATOM    314 HG13 VAL A  21      37.860  45.212  49.259  1.00  0.00           H  
ATOM    315 HG21 VAL A  21      36.903  41.452  49.013  1.00  0.00           H  
ATOM    316 HG22 VAL A  21      38.160  42.187  50.009  1.00  0.00           H  
ATOM    317 HG23 VAL A  21      36.519  42.831  50.042  1.00  0.00           H  
ATOM    318  N   GLU A  22      34.894  41.635  47.070  1.00  0.00           N  
ATOM    319  CA  GLU A  22      33.446  41.500  47.193  1.00  0.00           C  
ATOM    320  C   GLU A  22      33.081  40.304  48.067  1.00  0.00           C  
ATOM    321  O   GLU A  22      32.228  39.495  47.701  1.00  0.00           O  
ATOM    322  CB  GLU A  22      32.797  41.352  45.814  1.00  0.00           C  
ATOM    323  CG  GLU A  22      33.679  40.657  44.791  1.00  0.00           C  
ATOM    324  CD  GLU A  22      33.152  40.799  43.376  1.00  0.00           C  
ATOM    325  OE1 GLU A  22      32.058  40.267  43.094  1.00  0.00           O  
ATOM    326  OE2 GLU A  22      33.832  41.443  42.552  1.00  0.00           O  
ATOM    327  H   GLU A  22      35.444  40.827  46.967  1.00  0.00           H  
ATOM    328  HA  GLU A  22      33.072  42.398  47.661  1.00  0.00           H  
ATOM    329  HB2 GLU A  22      31.888  40.780  45.920  1.00  0.00           H  
ATOM    330  HB3 GLU A  22      32.551  42.334  45.438  1.00  0.00           H  
ATOM    331  HG2 GLU A  22      34.668  41.084  44.834  1.00  0.00           H  
ATOM    332  HG3 GLU A  22      33.731  39.605  45.036  1.00  0.00           H  
ATOM    333  N   VAL A  23      33.732  40.199  49.220  1.00  0.00           N  
ATOM    334  CA  VAL A  23      33.473  39.101  50.143  1.00  0.00           C  
ATOM    335  C   VAL A  23      33.586  39.559  51.593  1.00  0.00           C  
ATOM    336  O   VAL A  23      34.619  40.083  52.013  1.00  0.00           O  
ATOM    337  CB  VAL A  23      34.447  37.932  49.907  1.00  0.00           C  
ATOM    338  CG1 VAL A  23      34.091  37.192  48.625  1.00  0.00           C  
ATOM    339  CG2 VAL A  23      35.881  38.431  49.860  1.00  0.00           C  
ATOM    340  H   VAL A  23      34.402  40.875  49.456  1.00  0.00           H  
ATOM    341  HA  VAL A  23      32.469  38.747  49.965  1.00  0.00           H  
ATOM    342  HB  VAL A  23      34.354  37.240  50.732  1.00  0.00           H  
ATOM    343 HG11 VAL A  23      33.698  37.894  47.904  1.00  0.00           H  
ATOM    344 HG12 VAL A  23      34.975  36.721  48.225  1.00  0.00           H  
ATOM    345 HG13 VAL A  23      33.345  36.439  48.839  1.00  0.00           H  
ATOM    346 HG21 VAL A  23      35.885  39.511  49.854  1.00  0.00           H  
ATOM    347 HG22 VAL A  23      36.415  38.075  50.728  1.00  0.00           H  
ATOM    348 HG23 VAL A  23      36.362  38.063  48.967  1.00  0.00           H  
ATOM    349  N   ASN A  24      32.515  39.357  52.353  1.00  0.00           N  
ATOM    350  CA  ASN A  24      32.486  39.747  53.758  1.00  0.00           C  
ATOM    351  C   ASN A  24      32.040  38.586  54.642  1.00  0.00           C  
ATOM    352  O   ASN A  24      31.622  38.788  55.783  1.00  0.00           O  
ATOM    353  CB  ASN A  24      31.538  40.925  53.952  1.00  0.00           C  
ATOM    354  CG  ASN A  24      32.077  41.950  54.928  1.00  0.00           C  
ATOM    355  OD1 ASN A  24      33.233  42.363  54.841  1.00  0.00           O  
ATOM    356  ND2 ASN A  24      31.238  42.366  55.870  1.00  0.00           N  
ATOM    357  H   ASN A  24      31.725  38.935  51.957  1.00  0.00           H  
ATOM    358  HA  ASN A  24      33.482  40.046  54.045  1.00  0.00           H  
ATOM    359  HB2 ASN A  24      31.379  41.408  52.999  1.00  0.00           H  
ATOM    360  HB3 ASN A  24      30.596  40.555  54.325  1.00  0.00           H  
ATOM    361 HD21 ASN A  24      30.332  41.995  55.881  1.00  0.00           H  
ATOM    362 HD22 ASN A  24      31.561  43.030  56.517  1.00  0.00           H  
ATOM    363  N   VAL A  25      32.127  37.374  54.108  1.00  0.00           N  
ATOM    364  CA  VAL A  25      31.731  36.182  54.844  1.00  0.00           C  
ATOM    365  C   VAL A  25      30.231  36.189  55.126  1.00  0.00           C  
ATOM    366  O   VAL A  25      29.737  37.010  55.899  1.00  0.00           O  
ATOM    367  CB  VAL A  25      32.506  36.067  56.171  1.00  0.00           C  
ATOM    368  CG1 VAL A  25      32.020  34.876  56.986  1.00  0.00           C  
ATOM    369  CG2 VAL A  25      34.000  35.963  55.906  1.00  0.00           C  
ATOM    370  H   VAL A  25      32.464  37.282  53.198  1.00  0.00           H  
ATOM    371  HA  VAL A  25      31.970  35.321  54.236  1.00  0.00           H  
ATOM    372  HB  VAL A  25      32.327  36.963  56.743  1.00  0.00           H  
ATOM    373 HG11 VAL A  25      30.951  34.944  57.121  1.00  0.00           H  
ATOM    374 HG12 VAL A  25      32.260  33.961  56.466  1.00  0.00           H  
ATOM    375 HG13 VAL A  25      32.505  34.879  57.952  1.00  0.00           H  
ATOM    376 HG21 VAL A  25      34.169  35.342  55.039  1.00  0.00           H  
ATOM    377 HG22 VAL A  25      34.403  36.948  55.727  1.00  0.00           H  
ATOM    378 HG23 VAL A  25      34.489  35.524  56.763  1.00  0.00           H  
ATOM    379  N   GLY A  26      29.512  35.267  54.493  1.00  0.00           N  
ATOM    380  CA  GLY A  26      28.076  35.184  54.685  1.00  0.00           C  
ATOM    381  C   GLY A  26      27.314  35.197  53.375  1.00  0.00           C  
ATOM    382  O   GLY A  26      26.167  34.755  53.311  1.00  0.00           O  
ATOM    383  H   GLY A  26      29.959  34.640  53.888  1.00  0.00           H  
ATOM    384  HA2 GLY A  26      27.848  34.269  55.212  1.00  0.00           H  
ATOM    385  HA3 GLY A  26      27.754  36.022  55.286  1.00  0.00           H  
ATOM    386  N   ASP A  27      27.953  35.707  52.327  1.00  0.00           N  
ATOM    387  CA  ASP A  27      27.331  35.778  51.010  1.00  0.00           C  
ATOM    388  C   ASP A  27      27.433  34.439  50.287  1.00  0.00           C  
ATOM    389  O   ASP A  27      28.403  33.700  50.461  1.00  0.00           O  
ATOM    390  CB  ASP A  27      27.990  36.874  50.172  1.00  0.00           C  
ATOM    391  CG  ASP A  27      27.014  37.541  49.222  1.00  0.00           C  
ATOM    392  OD1 ASP A  27      26.734  36.958  48.154  1.00  0.00           O  
ATOM    393  OD2 ASP A  27      26.532  38.646  49.545  1.00  0.00           O  
ATOM    394  H   ASP A  27      28.867  36.044  52.441  1.00  0.00           H  
ATOM    395  HA  ASP A  27      26.288  36.020  51.149  1.00  0.00           H  
ATOM    396  HB2 ASP A  27      28.394  37.629  50.831  1.00  0.00           H  
ATOM    397  HB3 ASP A  27      28.792  36.442  49.592  1.00  0.00           H  
ATOM    398  N   THR A  28      26.429  34.135  49.471  1.00  0.00           N  
ATOM    399  CA  THR A  28      26.407  32.885  48.719  1.00  0.00           C  
ATOM    400  C   THR A  28      27.438  32.914  47.596  1.00  0.00           C  
ATOM    401  O   THR A  28      27.831  33.984  47.128  1.00  0.00           O  
ATOM    402  CB  THR A  28      25.013  32.636  48.142  1.00  0.00           C  
ATOM    403  OG1 THR A  28      24.063  32.472  49.179  1.00  0.00           O  
ATOM    404  CG2 THR A  28      24.942  31.412  47.257  1.00  0.00           C  
ATOM    405  H   THR A  28      25.685  34.765  49.373  1.00  0.00           H  
ATOM    406  HA  THR A  28      26.656  32.085  49.399  1.00  0.00           H  
ATOM    407  HB  THR A  28      24.722  33.490  47.548  1.00  0.00           H  
ATOM    408  HG1 THR A  28      23.555  33.280  49.280  1.00  0.00           H  
ATOM    409 HG21 THR A  28      25.524  30.614  47.696  1.00  0.00           H  
ATOM    410 HG22 THR A  28      23.914  31.095  47.161  1.00  0.00           H  
ATOM    411 HG23 THR A  28      25.338  31.649  46.280  1.00  0.00           H  
ATOM    412  N   ILE A  29      27.873  31.736  47.168  1.00  0.00           N  
ATOM    413  CA  ILE A  29      28.860  31.629  46.100  1.00  0.00           C  
ATOM    414  C   ILE A  29      28.586  30.419  45.216  1.00  0.00           C  
ATOM    415  O   ILE A  29      28.149  29.373  45.695  1.00  0.00           O  
ATOM    416  CB  ILE A  29      30.289  31.525  46.663  1.00  0.00           C  
ATOM    417  CG1 ILE A  29      30.406  30.315  47.590  1.00  0.00           C  
ATOM    418  CG2 ILE A  29      30.667  32.804  47.396  1.00  0.00           C  
ATOM    419  CD1 ILE A  29      31.222  29.189  47.002  1.00  0.00           C  
ATOM    420  H   ILE A  29      27.525  30.917  47.579  1.00  0.00           H  
ATOM    421  HA  ILE A  29      28.797  32.523  45.499  1.00  0.00           H  
ATOM    422  HB  ILE A  29      30.969  31.401  45.835  1.00  0.00           H  
ATOM    423 HG12 ILE A  29      30.878  30.621  48.513  1.00  0.00           H  
ATOM    424 HG13 ILE A  29      29.418  29.935  47.804  1.00  0.00           H  
ATOM    425 HG21 ILE A  29      29.983  33.593  47.118  1.00  0.00           H  
ATOM    426 HG22 ILE A  29      30.614  32.639  48.461  1.00  0.00           H  
ATOM    427 HG23 ILE A  29      31.674  33.088  47.127  1.00  0.00           H  
ATOM    428 HD11 ILE A  29      31.970  29.596  46.339  1.00  0.00           H  
ATOM    429 HD12 ILE A  29      31.705  28.640  47.798  1.00  0.00           H  
ATOM    430 HD13 ILE A  29      30.576  28.525  46.448  1.00  0.00           H  
ATOM    431  N   ALA A  30      28.849  30.568  43.922  1.00  0.00           N  
ATOM    432  CA  ALA A  30      28.632  29.486  42.969  1.00  0.00           C  
ATOM    433  C   ALA A  30      29.932  29.095  42.277  1.00  0.00           C  
ATOM    434  O   ALA A  30      30.995  29.649  42.565  1.00  0.00           O  
ATOM    435  CB  ALA A  30      27.584  29.888  41.943  1.00  0.00           C  
ATOM    436  H   ALA A  30      29.198  31.425  43.599  1.00  0.00           H  
ATOM    437  HA  ALA A  30      28.259  28.632  43.517  1.00  0.00           H  
ATOM    438  HB1 ALA A  30      26.606  29.870  42.401  1.00  0.00           H  
ATOM    439  HB2 ALA A  30      27.605  29.193  41.117  1.00  0.00           H  
ATOM    440  HB3 ALA A  30      27.794  30.883  41.583  1.00  0.00           H  
ATOM    441  N   VAL A  31      29.846  28.128  41.371  1.00  0.00           N  
ATOM    442  CA  VAL A  31      31.020  27.657  40.643  1.00  0.00           C  
ATOM    443  C   VAL A  31      31.283  28.509  39.405  1.00  0.00           C  
ATOM    444  O   VAL A  31      31.491  27.983  38.312  1.00  0.00           O  
ATOM    445  CB  VAL A  31      30.860  26.187  40.217  1.00  0.00           C  
ATOM    446  CG1 VAL A  31      32.194  25.611  39.769  1.00  0.00           C  
ATOM    447  CG2 VAL A  31      30.269  25.365  41.354  1.00  0.00           C  
ATOM    448  H   VAL A  31      28.974  27.717  41.192  1.00  0.00           H  
ATOM    449  HA  VAL A  31      31.871  27.729  41.305  1.00  0.00           H  
ATOM    450  HB  VAL A  31      30.177  26.148  39.381  1.00  0.00           H  
ATOM    451 HG11 VAL A  31      32.909  26.412  39.645  1.00  0.00           H  
ATOM    452 HG12 VAL A  31      32.556  24.917  40.513  1.00  0.00           H  
ATOM    453 HG13 VAL A  31      32.066  25.096  38.828  1.00  0.00           H  
ATOM    454 HG21 VAL A  31      30.086  26.004  42.204  1.00  0.00           H  
ATOM    455 HG22 VAL A  31      29.341  24.918  41.029  1.00  0.00           H  
ATOM    456 HG23 VAL A  31      30.965  24.587  41.632  1.00  0.00           H  
ATOM    457  N   ASP A  32      31.275  29.831  39.585  1.00  0.00           N  
ATOM    458  CA  ASP A  32      31.515  30.767  38.487  1.00  0.00           C  
ATOM    459  C   ASP A  32      31.057  32.171  38.871  1.00  0.00           C  
ATOM    460  O   ASP A  32      30.029  32.649  38.394  1.00  0.00           O  
ATOM    461  CB  ASP A  32      30.785  30.319  37.217  1.00  0.00           C  
ATOM    462  CG  ASP A  32      29.414  29.740  37.508  1.00  0.00           C  
ATOM    463  OD1 ASP A  32      28.768  30.205  38.470  1.00  0.00           O  
ATOM    464  OD2 ASP A  32      28.988  28.823  36.776  1.00  0.00           O  
ATOM    465  H   ASP A  32      31.105  30.186  40.481  1.00  0.00           H  
ATOM    466  HA  ASP A  32      32.577  30.787  38.297  1.00  0.00           H  
ATOM    467  HB2 ASP A  32      30.665  31.166  36.560  1.00  0.00           H  
ATOM    468  HB3 ASP A  32      31.377  29.564  36.717  1.00  0.00           H  
ATOM    469  N   ASP A  33      31.826  32.829  39.736  1.00  0.00           N  
ATOM    470  CA  ASP A  33      31.491  34.177  40.178  1.00  0.00           C  
ATOM    471  C   ASP A  33      32.739  34.920  40.635  1.00  0.00           C  
ATOM    472  O   ASP A  33      33.379  34.535  41.613  1.00  0.00           O  
ATOM    473  CB  ASP A  33      30.469  34.128  41.315  1.00  0.00           C  
ATOM    474  CG  ASP A  33      30.960  33.320  42.500  1.00  0.00           C  
ATOM    475  OD1 ASP A  33      30.985  32.076  42.402  1.00  0.00           O  
ATOM    476  OD2 ASP A  33      31.317  33.933  43.528  1.00  0.00           O  
ATOM    477  H   ASP A  33      32.638  32.396  40.085  1.00  0.00           H  
ATOM    478  HA  ASP A  33      31.059  34.703  39.340  1.00  0.00           H  
ATOM    479  HB2 ASP A  33      30.261  35.132  41.649  1.00  0.00           H  
ATOM    480  HB3 ASP A  33      29.555  33.680  40.950  1.00  0.00           H  
ATOM    481  N   THR A  34      33.086  35.984  39.920  1.00  0.00           N  
ATOM    482  CA  THR A  34      34.264  36.768  40.260  1.00  0.00           C  
ATOM    483  C   THR A  34      34.270  37.155  41.732  1.00  0.00           C  
ATOM    484  O   THR A  34      33.396  37.883  42.202  1.00  0.00           O  
ATOM    485  CB  THR A  34      34.357  38.016  39.398  1.00  0.00           C  
ATOM    486  OG1 THR A  34      33.091  38.373  38.874  1.00  0.00           O  
ATOM    487  CG2 THR A  34      35.319  37.866  38.239  1.00  0.00           C  
ATOM    488  H   THR A  34      32.541  36.244  39.148  1.00  0.00           H  
ATOM    489  HA  THR A  34      35.126  36.162  40.066  1.00  0.00           H  
ATOM    490  HB  THR A  34      34.714  38.821  40.013  1.00  0.00           H  
ATOM    491  HG1 THR A  34      32.989  39.326  38.903  1.00  0.00           H  
ATOM    492 HG21 THR A  34      35.008  37.038  37.618  1.00  0.00           H  
ATOM    493 HG22 THR A  34      35.324  38.772  37.655  1.00  0.00           H  
ATOM    494 HG23 THR A  34      36.313  37.675  38.620  1.00  0.00           H  
ATOM    495  N   LEU A  35      35.276  36.670  42.447  1.00  0.00           N  
ATOM    496  CA  LEU A  35      35.427  36.965  43.862  1.00  0.00           C  
ATOM    497  C   LEU A  35      36.216  38.253  44.044  1.00  0.00           C  
ATOM    498  O   LEU A  35      35.853  39.106  44.853  1.00  0.00           O  
ATOM    499  CB  LEU A  35      36.132  35.809  44.577  1.00  0.00           C  
ATOM    500  CG  LEU A  35      35.221  34.654  44.994  1.00  0.00           C  
ATOM    501  CD1 LEU A  35      35.995  33.628  45.806  1.00  0.00           C  
ATOM    502  CD2 LEU A  35      34.030  35.175  45.787  1.00  0.00           C  
ATOM    503  H   LEU A  35      35.943  36.107  42.005  1.00  0.00           H  
ATOM    504  HA  LEU A  35      34.441  37.094  44.284  1.00  0.00           H  
ATOM    505  HB2 LEU A  35      36.896  35.419  43.920  1.00  0.00           H  
ATOM    506  HB3 LEU A  35      36.609  36.200  45.463  1.00  0.00           H  
ATOM    507  HG  LEU A  35      34.844  34.163  44.108  1.00  0.00           H  
ATOM    508 HD11 LEU A  35      36.701  34.135  46.448  1.00  0.00           H  
ATOM    509 HD12 LEU A  35      35.308  33.053  46.410  1.00  0.00           H  
ATOM    510 HD13 LEU A  35      36.526  32.966  45.137  1.00  0.00           H  
ATOM    511 HD21 LEU A  35      34.365  35.927  46.487  1.00  0.00           H  
ATOM    512 HD22 LEU A  35      33.310  35.608  45.110  1.00  0.00           H  
ATOM    513 HD23 LEU A  35      33.574  34.360  46.327  1.00  0.00           H  
ATOM    514  N   ILE A  36      37.290  38.395  43.267  1.00  0.00           N  
ATOM    515  CA  ILE A  36      38.119  39.595  43.329  1.00  0.00           C  
ATOM    516  C   ILE A  36      38.925  39.794  42.053  1.00  0.00           C  
ATOM    517  O   ILE A  36      38.867  38.985  41.127  1.00  0.00           O  
ATOM    518  CB  ILE A  36      39.098  39.580  44.531  1.00  0.00           C  
ATOM    519  CG1 ILE A  36      39.910  38.278  44.625  1.00  0.00           C  
ATOM    520  CG2 ILE A  36      38.337  39.805  45.820  1.00  0.00           C  
ATOM    521  CD1 ILE A  36      40.332  37.684  43.296  1.00  0.00           C  
ATOM    522  H   ILE A  36      37.519  37.683  42.629  1.00  0.00           H  
ATOM    523  HA  ILE A  36      37.456  40.442  43.454  1.00  0.00           H  
ATOM    524  HB  ILE A  36      39.781  40.407  44.412  1.00  0.00           H  
ATOM    525 HG12 ILE A  36      40.813  38.480  45.184  1.00  0.00           H  
ATOM    526 HG13 ILE A  36      39.327  37.538  45.150  1.00  0.00           H  
ATOM    527 HG21 ILE A  36      37.434  40.353  45.609  1.00  0.00           H  
ATOM    528 HG22 ILE A  36      38.087  38.852  46.260  1.00  0.00           H  
ATOM    529 HG23 ILE A  36      38.950  40.372  46.506  1.00  0.00           H  
ATOM    530 HD11 ILE A  36      40.927  38.404  42.751  1.00  0.00           H  
ATOM    531 HD12 ILE A  36      40.919  36.792  43.470  1.00  0.00           H  
ATOM    532 HD13 ILE A  36      39.455  37.431  42.719  1.00  0.00           H  
ATOM    533  N   THR A  37      39.700  40.865  42.041  1.00  0.00           N  
ATOM    534  CA  THR A  37      40.565  41.186  40.922  1.00  0.00           C  
ATOM    535  C   THR A  37      41.883  41.708  41.474  1.00  0.00           C  
ATOM    536  O   THR A  37      41.913  42.713  42.185  1.00  0.00           O  
ATOM    537  CB  THR A  37      39.905  42.215  40.003  1.00  0.00           C  
ATOM    538  OG1 THR A  37      38.702  41.703  39.461  1.00  0.00           O  
ATOM    539  CG2 THR A  37      40.785  42.634  38.845  1.00  0.00           C  
ATOM    540  H   THR A  37      39.712  41.449  42.826  1.00  0.00           H  
ATOM    541  HA  THR A  37      40.750  40.275  40.370  1.00  0.00           H  
ATOM    542  HB  THR A  37      39.668  43.099  40.577  1.00  0.00           H  
ATOM    543  HG1 THR A  37      37.953  42.154  39.857  1.00  0.00           H  
ATOM    544 HG21 THR A  37      41.786  42.825  39.204  1.00  0.00           H  
ATOM    545 HG22 THR A  37      40.813  41.844  38.109  1.00  0.00           H  
ATOM    546 HG23 THR A  37      40.386  43.531  38.395  1.00  0.00           H  
ATOM    547  N   LEU A  38      42.964  40.995  41.190  1.00  0.00           N  
ATOM    548  CA  LEU A  38      44.274  41.370  41.705  1.00  0.00           C  
ATOM    549  C   LEU A  38      45.211  41.846  40.602  1.00  0.00           C  
ATOM    550  O   LEU A  38      44.896  41.749  39.418  1.00  0.00           O  
ATOM    551  CB  LEU A  38      44.890  40.181  42.436  1.00  0.00           C  
ATOM    552  CG  LEU A  38      44.307  39.905  43.819  1.00  0.00           C  
ATOM    553  CD1 LEU A  38      43.066  39.035  43.705  1.00  0.00           C  
ATOM    554  CD2 LEU A  38      45.345  39.241  44.702  1.00  0.00           C  
ATOM    555  H   LEU A  38      42.874  40.180  40.653  1.00  0.00           H  
ATOM    556  HA  LEU A  38      44.133  42.172  42.411  1.00  0.00           H  
ATOM    557  HB2 LEU A  38      44.745  39.299  41.828  1.00  0.00           H  
ATOM    558  HB3 LEU A  38      45.947  40.357  42.545  1.00  0.00           H  
ATOM    559  HG  LEU A  38      44.021  40.840  44.277  1.00  0.00           H  
ATOM    560 HD11 LEU A  38      42.943  38.717  42.681  1.00  0.00           H  
ATOM    561 HD12 LEU A  38      43.172  38.170  44.343  1.00  0.00           H  
ATOM    562 HD13 LEU A  38      42.199  39.604  44.012  1.00  0.00           H  
ATOM    563 HD21 LEU A  38      46.146  38.855  44.090  1.00  0.00           H  
ATOM    564 HD22 LEU A  38      45.741  39.965  45.399  1.00  0.00           H  
ATOM    565 HD23 LEU A  38      44.887  38.429  45.249  1.00  0.00           H  
ATOM    566  N   GLU A  39      46.367  42.365  41.009  1.00  0.00           N  
ATOM    567  CA  GLU A  39      47.359  42.863  40.065  1.00  0.00           C  
ATOM    568  C   GLU A  39      48.657  43.218  40.785  1.00  0.00           C  
ATOM    569  O   GLU A  39      48.661  43.463  41.993  1.00  0.00           O  
ATOM    570  CB  GLU A  39      46.815  44.088  39.325  1.00  0.00           C  
ATOM    571  CG  GLU A  39      47.854  44.813  38.484  1.00  0.00           C  
ATOM    572  CD  GLU A  39      47.331  46.108  37.897  1.00  0.00           C  
ATOM    573  OE1 GLU A  39      46.456  46.735  38.529  1.00  0.00           O  
ATOM    574  OE2 GLU A  39      47.794  46.494  36.803  1.00  0.00           O  
ATOM    575  H   GLU A  39      46.556  42.417  41.972  1.00  0.00           H  
ATOM    576  HA  GLU A  39      47.560  42.080  39.349  1.00  0.00           H  
ATOM    577  HB2 GLU A  39      46.016  43.770  38.674  1.00  0.00           H  
ATOM    578  HB3 GLU A  39      46.421  44.784  40.051  1.00  0.00           H  
ATOM    579  HG2 GLU A  39      48.708  45.040  39.105  1.00  0.00           H  
ATOM    580  HG3 GLU A  39      48.161  44.165  37.677  1.00  0.00           H  
ATOM    581  N   THR A  40      49.755  43.243  40.040  1.00  0.00           N  
ATOM    582  CA  THR A  40      51.058  43.569  40.611  1.00  0.00           C  
ATOM    583  C   THR A  40      51.789  44.598  39.750  1.00  0.00           C  
ATOM    584  O   THR A  40      51.651  45.803  39.961  1.00  0.00           O  
ATOM    585  CB  THR A  40      51.913  42.304  40.783  1.00  0.00           C  
ATOM    586  OG1 THR A  40      53.292  42.624  40.734  1.00  0.00           O  
ATOM    587  CG2 THR A  40      51.659  41.230  39.742  1.00  0.00           C  
ATOM    588  H   THR A  40      49.689  43.039  39.082  1.00  0.00           H  
ATOM    589  HA  THR A  40      50.884  44.002  41.585  1.00  0.00           H  
ATOM    590  HB  THR A  40      51.704  41.877  41.752  1.00  0.00           H  
ATOM    591  HG1 THR A  40      53.621  42.767  41.624  1.00  0.00           H  
ATOM    592 HG21 THR A  40      50.709  41.399  39.260  1.00  0.00           H  
ATOM    593 HG22 THR A  40      52.446  41.251  39.001  1.00  0.00           H  
ATOM    594 HG23 THR A  40      51.647  40.262  40.222  1.00  0.00           H  
ATOM    595  N   ASP A  41      52.562  44.120  38.780  1.00  0.00           N  
ATOM    596  CA  ASP A  41      53.306  45.003  37.890  1.00  0.00           C  
ATOM    597  C   ASP A  41      53.489  44.359  36.520  1.00  0.00           C  
ATOM    598  O   ASP A  41      54.392  44.724  35.768  1.00  0.00           O  
ATOM    599  CB  ASP A  41      54.671  45.340  38.494  1.00  0.00           C  
ATOM    600  CG  ASP A  41      54.800  46.810  38.845  1.00  0.00           C  
ATOM    601  OD1 ASP A  41      53.788  47.411  39.263  1.00  0.00           O  
ATOM    602  OD2 ASP A  41      55.913  47.359  38.703  1.00  0.00           O  
ATOM    603  H   ASP A  41      52.633  43.154  38.655  1.00  0.00           H  
ATOM    604  HA  ASP A  41      52.737  45.913  37.774  1.00  0.00           H  
ATOM    605  HB2 ASP A  41      54.815  44.760  39.392  1.00  0.00           H  
ATOM    606  HB3 ASP A  41      55.444  45.090  37.780  1.00  0.00           H  
ATOM    607  N   LYS A  42      52.626  43.396  36.202  1.00  0.00           N  
ATOM    608  CA  LYS A  42      52.694  42.702  34.923  1.00  0.00           C  
ATOM    609  C   LYS A  42      51.309  42.575  34.296  1.00  0.00           C  
ATOM    610  O   LYS A  42      51.141  42.789  33.095  1.00  0.00           O  
ATOM    611  CB  LYS A  42      53.315  41.316  35.104  1.00  0.00           C  
ATOM    612  CG  LYS A  42      54.240  40.910  33.968  1.00  0.00           C  
ATOM    613  CD  LYS A  42      55.576  40.408  34.490  1.00  0.00           C  
ATOM    614  CE  LYS A  42      56.158  39.333  33.589  1.00  0.00           C  
ATOM    615  NZ  LYS A  42      56.796  38.238  34.371  1.00  0.00           N  
ATOM    616  H   LYS A  42      51.927  43.147  36.844  1.00  0.00           H  
ATOM    617  HA  LYS A  42      53.323  43.284  34.265  1.00  0.00           H  
ATOM    618  HB2 LYS A  42      53.882  41.306  36.023  1.00  0.00           H  
ATOM    619  HB3 LYS A  42      52.522  40.585  35.173  1.00  0.00           H  
ATOM    620  HG2 LYS A  42      53.769  40.124  33.397  1.00  0.00           H  
ATOM    621  HG3 LYS A  42      54.410  41.767  33.332  1.00  0.00           H  
ATOM    622  HD2 LYS A  42      56.267  41.236  34.538  1.00  0.00           H  
ATOM    623  HD3 LYS A  42      55.434  39.997  35.479  1.00  0.00           H  
ATOM    624  HE2 LYS A  42      55.365  38.916  32.986  1.00  0.00           H  
ATOM    625  HE3 LYS A  42      56.899  39.783  32.946  1.00  0.00           H  
ATOM    626  HZ1 LYS A  42      57.282  38.631  35.204  1.00  0.00           H  
ATOM    627  HZ2 LYS A  42      56.075  37.560  34.691  1.00  0.00           H  
ATOM    628  HZ3 LYS A  42      57.491  37.735  33.782  1.00  0.00           H  
ATOM    629  N   ALA A  43      50.323  42.223  35.114  1.00  0.00           N  
ATOM    630  CA  ALA A  43      48.955  42.067  34.634  1.00  0.00           C  
ATOM    631  C   ALA A  43      47.957  42.074  35.786  1.00  0.00           C  
ATOM    632  O   ALA A  43      48.339  42.000  36.954  1.00  0.00           O  
ATOM    633  CB  ALA A  43      48.825  40.778  33.837  1.00  0.00           C  
ATOM    634  H   ALA A  43      50.518  42.064  36.061  1.00  0.00           H  
ATOM    635  HA  ALA A  43      48.735  42.893  33.974  1.00  0.00           H  
ATOM    636  HB1 ALA A  43      48.214  40.954  32.964  1.00  0.00           H  
ATOM    637  HB2 ALA A  43      48.363  40.020  34.453  1.00  0.00           H  
ATOM    638  HB3 ALA A  43      49.805  40.444  33.529  1.00  0.00           H  
ATOM    639  N   THR A  44      46.674  42.154  35.445  1.00  0.00           N  
ATOM    640  CA  THR A  44      45.614  42.162  36.447  1.00  0.00           C  
ATOM    641  C   THR A  44      44.847  40.844  36.422  1.00  0.00           C  
ATOM    642  O   THR A  44      44.204  40.509  35.427  1.00  0.00           O  
ATOM    643  CB  THR A  44      44.655  43.326  36.201  1.00  0.00           C  
ATOM    644  OG1 THR A  44      44.095  43.250  34.900  1.00  0.00           O  
ATOM    645  CG2 THR A  44      45.309  44.681  36.341  1.00  0.00           C  
ATOM    646  H   THR A  44      46.434  42.204  34.497  1.00  0.00           H  
ATOM    647  HA  THR A  44      46.072  42.281  37.417  1.00  0.00           H  
ATOM    648  HB  THR A  44      43.851  43.271  36.920  1.00  0.00           H  
ATOM    649  HG1 THR A  44      43.187  43.558  34.925  1.00  0.00           H  
ATOM    650 HG21 THR A  44      46.351  44.610  36.061  1.00  0.00           H  
ATOM    651 HG22 THR A  44      44.811  45.390  35.695  1.00  0.00           H  
ATOM    652 HG23 THR A  44      45.233  45.012  37.365  1.00  0.00           H  
ATOM    653  N   MET A  45      44.923  40.099  37.518  1.00  0.00           N  
ATOM    654  CA  MET A  45      44.238  38.815  37.612  1.00  0.00           C  
ATOM    655  C   MET A  45      42.947  38.927  38.413  1.00  0.00           C  
ATOM    656  O   MET A  45      42.547  40.015  38.827  1.00  0.00           O  
ATOM    657  CB  MET A  45      45.154  37.771  38.252  1.00  0.00           C  
ATOM    658  CG  MET A  45      45.343  36.528  37.399  1.00  0.00           C  
ATOM    659  SD  MET A  45      46.076  36.897  35.792  1.00  0.00           S  
ATOM    660  CE  MET A  45      46.397  35.246  35.178  1.00  0.00           C  
ATOM    661  H   MET A  45      45.454  40.417  38.277  1.00  0.00           H  
ATOM    662  HA  MET A  45      43.997  38.495  36.610  1.00  0.00           H  
ATOM    663  HB2 MET A  45      46.123  38.215  38.424  1.00  0.00           H  
ATOM    664  HB3 MET A  45      44.732  37.471  39.203  1.00  0.00           H  
ATOM    665  HG2 MET A  45      45.989  35.841  37.924  1.00  0.00           H  
ATOM    666  HG3 MET A  45      44.379  36.066  37.242  1.00  0.00           H  
ATOM    667  HE1 MET A  45      45.871  34.526  35.787  1.00  0.00           H  
ATOM    668  HE2 MET A  45      46.057  35.170  34.156  1.00  0.00           H  
ATOM    669  HE3 MET A  45      47.459  35.046  35.220  1.00  0.00           H  
ATOM    670  N   ASP A  46      42.300  37.785  38.624  1.00  0.00           N  
ATOM    671  CA  ASP A  46      41.052  37.729  39.372  1.00  0.00           C  
ATOM    672  C   ASP A  46      40.640  36.280  39.600  1.00  0.00           C  
ATOM    673  O   ASP A  46      41.226  35.362  39.027  1.00  0.00           O  
ATOM    674  CB  ASP A  46      39.949  38.474  38.618  1.00  0.00           C  
ATOM    675  CG  ASP A  46      39.893  38.094  37.152  1.00  0.00           C  
ATOM    676  OD1 ASP A  46      39.274  37.059  36.830  1.00  0.00           O  
ATOM    677  OD2 ASP A  46      40.471  38.831  36.326  1.00  0.00           O  
ATOM    678  H   ASP A  46      42.677  36.955  38.264  1.00  0.00           H  
ATOM    679  HA  ASP A  46      41.213  38.204  40.327  1.00  0.00           H  
ATOM    680  HB2 ASP A  46      38.995  38.241  39.067  1.00  0.00           H  
ATOM    681  HB3 ASP A  46      40.125  39.537  38.690  1.00  0.00           H  
ATOM    682  N   VAL A  47      39.628  36.075  40.435  1.00  0.00           N  
ATOM    683  CA  VAL A  47      39.148  34.729  40.722  1.00  0.00           C  
ATOM    684  C   VAL A  47      37.648  34.625  40.473  1.00  0.00           C  
ATOM    685  O   VAL A  47      36.874  35.392  41.039  1.00  0.00           O  
ATOM    686  CB  VAL A  47      39.442  34.320  42.180  1.00  0.00           C  
ATOM    687  CG1 VAL A  47      38.850  32.948  42.488  1.00  0.00           C  
ATOM    688  CG2 VAL A  47      40.941  34.334  42.446  1.00  0.00           C  
ATOM    689  H   VAL A  47      39.190  36.844  40.864  1.00  0.00           H  
ATOM    690  HA  VAL A  47      39.666  34.046  40.067  1.00  0.00           H  
ATOM    691  HB  VAL A  47      38.975  35.041  42.836  1.00  0.00           H  
ATOM    692 HG11 VAL A  47      38.306  32.588  41.625  1.00  0.00           H  
ATOM    693 HG12 VAL A  47      39.645  32.257  42.726  1.00  0.00           H  
ATOM    694 HG13 VAL A  47      38.176  33.027  43.328  1.00  0.00           H  
ATOM    695 HG21 VAL A  47      41.348  35.296  42.164  1.00  0.00           H  
ATOM    696 HG22 VAL A  47      41.122  34.160  43.496  1.00  0.00           H  
ATOM    697 HG23 VAL A  47      41.417  33.557  41.864  1.00  0.00           H  
ATOM    698  N   PRO A  48      37.217  33.673  39.623  1.00  0.00           N  
ATOM    699  CA  PRO A  48      35.807  33.471  39.305  1.00  0.00           C  
ATOM    700  C   PRO A  48      35.117  32.508  40.269  1.00  0.00           C  
ATOM    701  O   PRO A  48      34.143  31.849  39.908  1.00  0.00           O  
ATOM    702  CB  PRO A  48      35.876  32.869  37.908  1.00  0.00           C  
ATOM    703  CG  PRO A  48      37.129  32.053  37.917  1.00  0.00           C  
ATOM    704  CD  PRO A  48      38.072  32.711  38.901  1.00  0.00           C  
ATOM    705  HA  PRO A  48      35.266  34.405  39.274  1.00  0.00           H  
ATOM    706  HB2 PRO A  48      35.005  32.255  37.732  1.00  0.00           H  
ATOM    707  HB3 PRO A  48      35.926  33.658  37.173  1.00  0.00           H  
ATOM    708  HG2 PRO A  48      36.906  31.046  38.232  1.00  0.00           H  
ATOM    709  HG3 PRO A  48      37.567  32.049  36.928  1.00  0.00           H  
ATOM    710  HD2 PRO A  48      38.480  31.975  39.578  1.00  0.00           H  
ATOM    711  HD3 PRO A  48      38.865  33.222  38.376  1.00  0.00           H  
ATOM    712  N   ALA A  49      35.629  32.429  41.494  1.00  0.00           N  
ATOM    713  CA  ALA A  49      35.061  31.546  42.506  1.00  0.00           C  
ATOM    714  C   ALA A  49      35.094  30.090  42.052  1.00  0.00           C  
ATOM    715  O   ALA A  49      35.017  29.797  40.858  1.00  0.00           O  
ATOM    716  CB  ALA A  49      33.635  31.965  42.832  1.00  0.00           C  
ATOM    717  H   ALA A  49      36.406  32.976  41.723  1.00  0.00           H  
ATOM    718  HA  ALA A  49      35.653  31.645  43.403  1.00  0.00           H  
ATOM    719  HB1 ALA A  49      33.072  31.102  43.156  1.00  0.00           H  
ATOM    720  HB2 ALA A  49      33.647  32.702  43.620  1.00  0.00           H  
ATOM    721  HB3 ALA A  49      33.173  32.386  41.952  1.00  0.00           H  
ATOM    722  N   GLU A  50      35.205  29.182  43.014  1.00  0.00           N  
ATOM    723  CA  GLU A  50      35.241  27.753  42.719  1.00  0.00           C  
ATOM    724  C   GLU A  50      34.632  26.957  43.864  1.00  0.00           C  
ATOM    725  O   GLU A  50      35.337  26.272  44.604  1.00  0.00           O  
ATOM    726  CB  GLU A  50      36.677  27.294  42.463  1.00  0.00           C  
ATOM    727  CG  GLU A  50      36.771  25.895  41.873  1.00  0.00           C  
ATOM    728  CD  GLU A  50      38.155  25.293  42.013  1.00  0.00           C  
ATOM    729  OE1 GLU A  50      39.092  26.038  42.373  1.00  0.00           O  
ATOM    730  OE2 GLU A  50      38.302  24.078  41.763  1.00  0.00           O  
ATOM    731  H   GLU A  50      35.259  29.477  43.946  1.00  0.00           H  
ATOM    732  HA  GLU A  50      34.654  27.586  41.833  1.00  0.00           H  
ATOM    733  HB2 GLU A  50      37.147  27.982  41.776  1.00  0.00           H  
ATOM    734  HB3 GLU A  50      37.219  27.303  43.397  1.00  0.00           H  
ATOM    735  HG2 GLU A  50      36.065  25.256  42.382  1.00  0.00           H  
ATOM    736  HG3 GLU A  50      36.518  25.943  40.824  1.00  0.00           H  
ATOM    737  N   VAL A  51      33.316  27.067  44.010  1.00  0.00           N  
ATOM    738  CA  VAL A  51      32.602  26.370  45.074  1.00  0.00           C  
ATOM    739  C   VAL A  51      31.108  26.640  44.979  1.00  0.00           C  
ATOM    740  O   VAL A  51      30.657  27.335  44.077  1.00  0.00           O  
ATOM    741  CB  VAL A  51      33.107  26.783  46.478  1.00  0.00           C  
ATOM    742  CG1 VAL A  51      33.974  25.683  47.070  1.00  0.00           C  
ATOM    743  CG2 VAL A  51      33.872  28.104  46.434  1.00  0.00           C  
ATOM    744  H   VAL A  51      32.812  27.640  43.392  1.00  0.00           H  
ATOM    745  HA  VAL A  51      32.770  25.310  44.952  1.00  0.00           H  
ATOM    746  HB  VAL A  51      32.247  26.910  47.120  1.00  0.00           H  
ATOM    747 HG11 VAL A  51      33.755  24.749  46.578  1.00  0.00           H  
ATOM    748 HG12 VAL A  51      35.015  25.931  46.926  1.00  0.00           H  
ATOM    749 HG13 VAL A  51      33.768  25.591  48.126  1.00  0.00           H  
ATOM    750 HG21 VAL A  51      33.563  28.673  45.568  1.00  0.00           H  
ATOM    751 HG22 VAL A  51      33.664  28.672  47.328  1.00  0.00           H  
ATOM    752 HG23 VAL A  51      34.932  27.904  46.372  1.00  0.00           H  
ATOM    753  N   ALA A  52      30.342  26.084  45.905  1.00  0.00           N  
ATOM    754  CA  ALA A  52      28.895  26.275  45.896  1.00  0.00           C  
ATOM    755  C   ALA A  52      28.316  26.269  47.302  1.00  0.00           C  
ATOM    756  O   ALA A  52      27.576  25.360  47.674  1.00  0.00           O  
ATOM    757  CB  ALA A  52      28.235  25.196  45.070  1.00  0.00           C  
ATOM    758  H   ALA A  52      30.753  25.530  46.599  1.00  0.00           H  
ATOM    759  HA  ALA A  52      28.687  27.226  45.433  1.00  0.00           H  
ATOM    760  HB1 ALA A  52      28.572  24.228  45.414  1.00  0.00           H  
ATOM    761  HB2 ALA A  52      27.165  25.267  45.186  1.00  0.00           H  
ATOM    762  HB3 ALA A  52      28.498  25.327  44.032  1.00  0.00           H  
ATOM    763  N   GLY A  53      28.644  27.286  48.074  1.00  0.00           N  
ATOM    764  CA  GLY A  53      28.137  27.369  49.429  1.00  0.00           C  
ATOM    765  C   GLY A  53      28.183  28.774  49.997  1.00  0.00           C  
ATOM    766  O   GLY A  53      27.798  29.735  49.331  1.00  0.00           O  
ATOM    767  H   GLY A  53      29.229  27.985  47.722  1.00  0.00           H  
ATOM    768  HA2 GLY A  53      27.114  27.024  49.435  1.00  0.00           H  
ATOM    769  HA3 GLY A  53      28.725  26.717  50.057  1.00  0.00           H  
ATOM    770  N   VAL A  54      28.647  28.890  51.236  1.00  0.00           N  
ATOM    771  CA  VAL A  54      28.735  30.182  51.910  1.00  0.00           C  
ATOM    772  C   VAL A  54      30.144  30.434  52.436  1.00  0.00           C  
ATOM    773  O   VAL A  54      30.822  29.510  52.881  1.00  0.00           O  
ATOM    774  CB  VAL A  54      27.741  30.254  53.085  1.00  0.00           C  
ATOM    775  CG1 VAL A  54      27.868  31.580  53.824  1.00  0.00           C  
ATOM    776  CG2 VAL A  54      26.317  30.047  52.592  1.00  0.00           C  
ATOM    777  H   VAL A  54      28.932  28.083  51.716  1.00  0.00           H  
ATOM    778  HA  VAL A  54      28.478  30.952  51.197  1.00  0.00           H  
ATOM    779  HB  VAL A  54      27.979  29.455  53.776  1.00  0.00           H  
ATOM    780 HG11 VAL A  54      28.462  32.264  53.236  1.00  0.00           H  
ATOM    781 HG12 VAL A  54      26.884  31.998  53.981  1.00  0.00           H  
ATOM    782 HG13 VAL A  54      28.346  31.415  54.778  1.00  0.00           H  
ATOM    783 HG21 VAL A  54      26.307  30.046  51.512  1.00  0.00           H  
ATOM    784 HG22 VAL A  54      25.943  29.102  52.957  1.00  0.00           H  
ATOM    785 HG23 VAL A  54      25.690  30.847  52.956  1.00  0.00           H  
ATOM    786  N   VAL A  55      30.580  31.693  52.390  1.00  0.00           N  
ATOM    787  CA  VAL A  55      31.907  32.052  52.872  1.00  0.00           C  
ATOM    788  C   VAL A  55      31.948  32.098  54.393  1.00  0.00           C  
ATOM    789  O   VAL A  55      30.977  32.483  55.045  1.00  0.00           O  
ATOM    790  CB  VAL A  55      32.382  33.413  52.322  1.00  0.00           C  
ATOM    791  CG1 VAL A  55      33.762  33.767  52.878  1.00  0.00           C  
ATOM    792  CG2 VAL A  55      32.404  33.392  50.801  1.00  0.00           C  
ATOM    793  H   VAL A  55      29.993  32.391  52.030  1.00  0.00           H  
ATOM    794  HA  VAL A  55      32.597  31.298  52.531  1.00  0.00           H  
ATOM    795  HB  VAL A  55      31.683  34.174  52.641  1.00  0.00           H  
ATOM    796 HG11 VAL A  55      33.752  33.677  53.957  1.00  0.00           H  
ATOM    797 HG12 VAL A  55      34.498  33.091  52.468  1.00  0.00           H  
ATOM    798 HG13 VAL A  55      34.012  34.780  52.604  1.00  0.00           H  
ATOM    799 HG21 VAL A  55      31.550  32.842  50.435  1.00  0.00           H  
ATOM    800 HG22 VAL A  55      32.369  34.404  50.425  1.00  0.00           H  
ATOM    801 HG23 VAL A  55      33.313  32.913  50.463  1.00  0.00           H  
ATOM    802  N   LYS A  56      33.090  31.719  54.942  1.00  0.00           N  
ATOM    803  CA  LYS A  56      33.293  31.725  56.384  1.00  0.00           C  
ATOM    804  C   LYS A  56      34.369  32.727  56.739  1.00  0.00           C  
ATOM    805  O   LYS A  56      34.219  33.524  57.666  1.00  0.00           O  
ATOM    806  CB  LYS A  56      33.720  30.345  56.901  1.00  0.00           C  
ATOM    807  CG  LYS A  56      33.745  29.250  55.842  1.00  0.00           C  
ATOM    808  CD  LYS A  56      32.342  28.775  55.497  1.00  0.00           C  
ATOM    809  CE  LYS A  56      31.714  28.009  56.649  1.00  0.00           C  
ATOM    810  NZ  LYS A  56      30.694  28.822  57.365  1.00  0.00           N  
ATOM    811  H   LYS A  56      33.827  31.437  54.360  1.00  0.00           H  
ATOM    812  HA  LYS A  56      32.366  32.013  56.855  1.00  0.00           H  
ATOM    813  HB2 LYS A  56      34.717  30.431  57.315  1.00  0.00           H  
ATOM    814  HB3 LYS A  56      33.041  30.043  57.685  1.00  0.00           H  
ATOM    815  HG2 LYS A  56      34.211  29.639  54.950  1.00  0.00           H  
ATOM    816  HG3 LYS A  56      34.318  28.415  56.215  1.00  0.00           H  
ATOM    817  HD2 LYS A  56      31.727  29.633  55.270  1.00  0.00           H  
ATOM    818  HD3 LYS A  56      32.394  28.128  54.633  1.00  0.00           H  
ATOM    819  HE2 LYS A  56      31.242  27.119  56.259  1.00  0.00           H  
ATOM    820  HE3 LYS A  56      32.492  27.728  57.344  1.00  0.00           H  
ATOM    821  HZ1 LYS A  56      30.934  29.833  57.307  1.00  0.00           H  
ATOM    822  HZ2 LYS A  56      29.756  28.676  56.939  1.00  0.00           H  
ATOM    823  HZ3 LYS A  56      30.653  28.544  58.367  1.00  0.00           H  
ATOM    824  N   GLU A  57      35.465  32.669  55.998  1.00  0.00           N  
ATOM    825  CA  GLU A  57      36.577  33.558  56.239  1.00  0.00           C  
ATOM    826  C   GLU A  57      36.766  34.541  55.089  1.00  0.00           C  
ATOM    827  O   GLU A  57      36.078  34.467  54.071  1.00  0.00           O  
ATOM    828  CB  GLU A  57      37.861  32.758  56.463  1.00  0.00           C  
ATOM    829  CG  GLU A  57      38.133  32.439  57.923  1.00  0.00           C  
ATOM    830  CD  GLU A  57      39.123  33.398  58.556  1.00  0.00           C  
ATOM    831  OE1 GLU A  57      39.115  34.590  58.184  1.00  0.00           O  
ATOM    832  OE2 GLU A  57      39.906  32.957  59.422  1.00  0.00           O  
ATOM    833  H   GLU A  57      35.527  32.005  55.282  1.00  0.00           H  
ATOM    834  HA  GLU A  57      36.347  34.105  57.131  1.00  0.00           H  
ATOM    835  HB2 GLU A  57      37.790  31.826  55.922  1.00  0.00           H  
ATOM    836  HB3 GLU A  57      38.697  33.324  56.079  1.00  0.00           H  
ATOM    837  HG2 GLU A  57      37.203  32.495  58.470  1.00  0.00           H  
ATOM    838  HG3 GLU A  57      38.531  31.436  57.991  1.00  0.00           H  
ATOM    839  N   VAL A  58      37.705  35.462  55.267  1.00  0.00           N  
ATOM    840  CA  VAL A  58      38.000  36.471  54.257  1.00  0.00           C  
ATOM    841  C   VAL A  58      39.329  37.152  54.554  1.00  0.00           C  
ATOM    842  O   VAL A  58      39.505  37.760  55.609  1.00  0.00           O  
ATOM    843  CB  VAL A  58      36.893  37.537  54.191  1.00  0.00           C  
ATOM    844  CG1 VAL A  58      36.753  38.236  55.532  1.00  0.00           C  
ATOM    845  CG2 VAL A  58      37.183  38.539  53.085  1.00  0.00           C  
ATOM    846  H   VAL A  58      38.214  35.464  56.103  1.00  0.00           H  
ATOM    847  HA  VAL A  58      38.062  35.980  53.293  1.00  0.00           H  
ATOM    848  HB  VAL A  58      35.959  37.044  53.968  1.00  0.00           H  
ATOM    849 HG11 VAL A  58      37.207  37.630  56.303  1.00  0.00           H  
ATOM    850 HG12 VAL A  58      37.251  39.195  55.491  1.00  0.00           H  
ATOM    851 HG13 VAL A  58      35.708  38.382  55.756  1.00  0.00           H  
ATOM    852 HG21 VAL A  58      37.916  38.124  52.407  1.00  0.00           H  
ATOM    853 HG22 VAL A  58      36.272  38.751  52.546  1.00  0.00           H  
ATOM    854 HG23 VAL A  58      37.567  39.451  53.517  1.00  0.00           H  
ATOM    855  N   LYS A  59      40.262  37.038  53.620  1.00  0.00           N  
ATOM    856  CA  LYS A  59      41.583  37.631  53.782  1.00  0.00           C  
ATOM    857  C   LYS A  59      41.983  38.397  52.528  1.00  0.00           C  
ATOM    858  O   LYS A  59      42.914  38.012  51.823  1.00  0.00           O  
ATOM    859  CB  LYS A  59      42.616  36.542  54.078  1.00  0.00           C  
ATOM    860  CG  LYS A  59      42.050  35.363  54.858  1.00  0.00           C  
ATOM    861  CD  LYS A  59      42.984  34.932  55.977  1.00  0.00           C  
ATOM    862  CE  LYS A  59      42.736  33.487  56.381  1.00  0.00           C  
ATOM    863  NZ  LYS A  59      42.698  33.323  57.861  1.00  0.00           N  
ATOM    864  H   LYS A  59      40.062  36.533  52.804  1.00  0.00           H  
ATOM    865  HA  LYS A  59      41.543  38.316  54.615  1.00  0.00           H  
ATOM    866  HB2 LYS A  59      43.006  36.171  53.141  1.00  0.00           H  
ATOM    867  HB3 LYS A  59      43.424  36.972  54.650  1.00  0.00           H  
ATOM    868  HG2 LYS A  59      41.101  35.652  55.286  1.00  0.00           H  
ATOM    869  HG3 LYS A  59      41.906  34.534  54.182  1.00  0.00           H  
ATOM    870  HD2 LYS A  59      44.004  35.032  55.640  1.00  0.00           H  
ATOM    871  HD3 LYS A  59      42.821  35.570  56.833  1.00  0.00           H  
ATOM    872  HE2 LYS A  59      41.792  33.166  55.966  1.00  0.00           H  
ATOM    873  HE3 LYS A  59      43.531  32.875  55.979  1.00  0.00           H  
ATOM    874  HZ1 LYS A  59      42.151  34.097  58.291  1.00  0.00           H  
ATOM    875  HZ2 LYS A  59      42.249  32.419  58.107  1.00  0.00           H  
ATOM    876  HZ3 LYS A  59      43.662  33.337  58.247  1.00  0.00           H  
ATOM    877  N   VAL A  60      41.265  39.479  52.253  1.00  0.00           N  
ATOM    878  CA  VAL A  60      41.536  40.293  51.078  1.00  0.00           C  
ATOM    879  C   VAL A  60      40.688  41.564  51.094  1.00  0.00           C  
ATOM    880  O   VAL A  60      39.641  41.621  51.739  1.00  0.00           O  
ATOM    881  CB  VAL A  60      41.288  39.482  49.775  1.00  0.00           C  
ATOM    882  CG1 VAL A  60      40.111  38.531  49.950  1.00  0.00           C  
ATOM    883  CG2 VAL A  60      41.073  40.387  48.564  1.00  0.00           C  
ATOM    884  H   VAL A  60      40.529  39.730  52.851  1.00  0.00           H  
ATOM    885  HA  VAL A  60      42.579  40.574  51.106  1.00  0.00           H  
ATOM    886  HB  VAL A  60      42.168  38.885  49.589  1.00  0.00           H  
ATOM    887 HG11 VAL A  60      39.230  39.094  50.217  1.00  0.00           H  
ATOM    888 HG12 VAL A  60      39.936  38.003  49.026  1.00  0.00           H  
ATOM    889 HG13 VAL A  60      40.338  37.821  50.735  1.00  0.00           H  
ATOM    890 HG21 VAL A  60      41.875  41.108  48.506  1.00  0.00           H  
ATOM    891 HG22 VAL A  60      41.062  39.789  47.665  1.00  0.00           H  
ATOM    892 HG23 VAL A  60      40.131  40.906  48.664  1.00  0.00           H  
ATOM    893  N   LYS A  61      41.156  42.580  50.379  1.00  0.00           N  
ATOM    894  CA  LYS A  61      40.452  43.856  50.304  1.00  0.00           C  
ATOM    895  C   LYS A  61      41.083  44.760  49.250  1.00  0.00           C  
ATOM    896  O   LYS A  61      41.788  44.289  48.357  1.00  0.00           O  
ATOM    897  CB  LYS A  61      40.470  44.551  51.668  1.00  0.00           C  
ATOM    898  CG  LYS A  61      39.177  45.282  51.992  1.00  0.00           C  
ATOM    899  CD  LYS A  61      38.256  44.430  52.848  1.00  0.00           C  
ATOM    900  CE  LYS A  61      38.784  44.289  54.266  1.00  0.00           C  
ATOM    901  NZ  LYS A  61      37.729  43.825  55.209  1.00  0.00           N  
ATOM    902  H   LYS A  61      41.998  42.468  49.890  1.00  0.00           H  
ATOM    903  HA  LYS A  61      39.430  43.656  50.024  1.00  0.00           H  
ATOM    904  HB2 LYS A  61      40.640  43.809  52.435  1.00  0.00           H  
ATOM    905  HB3 LYS A  61      41.279  45.266  51.684  1.00  0.00           H  
ATOM    906  HG2 LYS A  61      39.414  46.188  52.528  1.00  0.00           H  
ATOM    907  HG3 LYS A  61      38.674  45.528  51.069  1.00  0.00           H  
ATOM    908  HD2 LYS A  61      37.281  44.895  52.883  1.00  0.00           H  
ATOM    909  HD3 LYS A  61      38.172  43.449  52.403  1.00  0.00           H  
ATOM    910  HE2 LYS A  61      39.592  43.572  54.265  1.00  0.00           H  
ATOM    911  HE3 LYS A  61      39.155  45.248  54.595  1.00  0.00           H  
ATOM    912  HZ1 LYS A  61      37.068  43.188  54.722  1.00  0.00           H  
ATOM    913  HZ2 LYS A  61      38.162  43.314  56.005  1.00  0.00           H  
ATOM    914  HZ3 LYS A  61      37.199  44.639  55.580  1.00  0.00           H  
ATOM    915  N   VAL A  62      40.827  46.059  49.356  1.00  0.00           N  
ATOM    916  CA  VAL A  62      41.371  47.024  48.408  1.00  0.00           C  
ATOM    917  C   VAL A  62      42.399  47.932  49.075  1.00  0.00           C  
ATOM    918  O   VAL A  62      42.044  48.932  49.699  1.00  0.00           O  
ATOM    919  CB  VAL A  62      40.257  47.891  47.790  1.00  0.00           C  
ATOM    920  CG1 VAL A  62      40.840  48.886  46.799  1.00  0.00           C  
ATOM    921  CG2 VAL A  62      39.209  47.015  47.123  1.00  0.00           C  
ATOM    922  H   VAL A  62      40.258  46.377  50.087  1.00  0.00           H  
ATOM    923  HA  VAL A  62      41.853  46.474  47.613  1.00  0.00           H  
ATOM    924  HB  VAL A  62      39.779  48.445  48.584  1.00  0.00           H  
ATOM    925 HG11 VAL A  62      41.555  49.522  47.303  1.00  0.00           H  
ATOM    926 HG12 VAL A  62      41.333  48.354  46.001  1.00  0.00           H  
ATOM    927 HG13 VAL A  62      40.045  49.493  46.390  1.00  0.00           H  
ATOM    928 HG21 VAL A  62      39.240  46.025  47.553  1.00  0.00           H  
ATOM    929 HG22 VAL A  62      38.231  47.443  47.276  1.00  0.00           H  
ATOM    930 HG23 VAL A  62      39.413  46.953  46.063  1.00  0.00           H  
ATOM    931  N   GLY A  63      43.674  47.579  48.939  1.00  0.00           N  
ATOM    932  CA  GLY A  63      44.731  48.374  49.534  1.00  0.00           C  
ATOM    933  C   GLY A  63      45.806  47.528  50.191  1.00  0.00           C  
ATOM    934  O   GLY A  63      46.896  48.019  50.485  1.00  0.00           O  
ATOM    935  H   GLY A  63      43.896  46.770  48.430  1.00  0.00           H  
ATOM    936  HA2 GLY A  63      45.187  48.978  48.763  1.00  0.00           H  
ATOM    937  HA3 GLY A  63      44.298  49.026  50.277  1.00  0.00           H  
ATOM    938  N   ASP A  64      45.501  46.254  50.427  1.00  0.00           N  
ATOM    939  CA  ASP A  64      46.453  45.347  51.056  1.00  0.00           C  
ATOM    940  C   ASP A  64      47.205  44.529  50.010  1.00  0.00           C  
ATOM    941  O   ASP A  64      46.786  44.445  48.855  1.00  0.00           O  
ATOM    942  CB  ASP A  64      45.730  44.411  52.028  1.00  0.00           C  
ATOM    943  CG  ASP A  64      44.470  43.817  51.430  1.00  0.00           C  
ATOM    944  OD1 ASP A  64      43.539  44.588  51.119  1.00  0.00           O  
ATOM    945  OD2 ASP A  64      44.415  42.579  51.274  1.00  0.00           O  
ATOM    946  H   ASP A  64      44.617  45.919  50.173  1.00  0.00           H  
ATOM    947  HA  ASP A  64      47.165  45.942  51.607  1.00  0.00           H  
ATOM    948  HB2 ASP A  64      46.394  43.604  52.301  1.00  0.00           H  
ATOM    949  HB3 ASP A  64      45.461  44.965  52.915  1.00  0.00           H  
ATOM    950  N   LYS A  65      48.314  43.922  50.425  1.00  0.00           N  
ATOM    951  CA  LYS A  65      49.122  43.103  49.526  1.00  0.00           C  
ATOM    952  C   LYS A  65      48.845  41.621  49.753  1.00  0.00           C  
ATOM    953  O   LYS A  65      48.522  41.203  50.864  1.00  0.00           O  
ATOM    954  CB  LYS A  65      50.619  43.396  49.707  1.00  0.00           C  
ATOM    955  CG  LYS A  65      50.989  43.949  51.075  1.00  0.00           C  
ATOM    956  CD  LYS A  65      50.729  42.931  52.172  1.00  0.00           C  
ATOM    957  CE  LYS A  65      52.003  42.595  52.932  1.00  0.00           C  
ATOM    958  NZ  LYS A  65      52.024  43.219  54.284  1.00  0.00           N  
ATOM    959  H   LYS A  65      48.589  44.023  51.359  1.00  0.00           H  
ATOM    960  HA  LYS A  65      48.840  43.353  48.515  1.00  0.00           H  
ATOM    961  HB2 LYS A  65      51.171  42.479  49.556  1.00  0.00           H  
ATOM    962  HB3 LYS A  65      50.925  44.112  48.959  1.00  0.00           H  
ATOM    963  HG2 LYS A  65      52.037  44.207  51.077  1.00  0.00           H  
ATOM    964  HG3 LYS A  65      50.396  44.832  51.267  1.00  0.00           H  
ATOM    965  HD2 LYS A  65      50.006  43.338  52.862  1.00  0.00           H  
ATOM    966  HD3 LYS A  65      50.338  42.031  51.725  1.00  0.00           H  
ATOM    967  HE2 LYS A  65      52.069  41.523  53.039  1.00  0.00           H  
ATOM    968  HE3 LYS A  65      52.850  42.953  52.366  1.00  0.00           H  
ATOM    969  HZ1 LYS A  65      51.055  43.324  54.644  1.00  0.00           H  
ATOM    970  HZ2 LYS A  65      52.564  42.624  54.943  1.00  0.00           H  
ATOM    971  HZ3 LYS A  65      52.471  44.158  54.237  1.00  0.00           H  
ATOM    972  N   ILE A  66      48.958  40.833  48.689  1.00  0.00           N  
ATOM    973  CA  ILE A  66      48.702  39.404  48.770  1.00  0.00           C  
ATOM    974  C   ILE A  66      49.741  38.602  47.976  1.00  0.00           C  
ATOM    975  O   ILE A  66      50.591  39.172  47.294  1.00  0.00           O  
ATOM    976  CB  ILE A  66      47.251  39.095  48.302  1.00  0.00           C  
ATOM    977  CG1 ILE A  66      46.569  38.190  49.320  1.00  0.00           C  
ATOM    978  CG2 ILE A  66      47.177  38.493  46.898  1.00  0.00           C  
ATOM    979  CD1 ILE A  66      46.431  38.850  50.670  1.00  0.00           C  
ATOM    980  H   ILE A  66      49.203  41.224  47.829  1.00  0.00           H  
ATOM    981  HA  ILE A  66      48.782  39.121  49.811  1.00  0.00           H  
ATOM    982  HB  ILE A  66      46.716  40.031  48.275  1.00  0.00           H  
ATOM    983 HG12 ILE A  66      45.582  37.932  48.968  1.00  0.00           H  
ATOM    984 HG13 ILE A  66      47.153  37.289  49.446  1.00  0.00           H  
ATOM    985 HG21 ILE A  66      47.834  37.643  46.831  1.00  0.00           H  
ATOM    986 HG22 ILE A  66      46.165  38.181  46.698  1.00  0.00           H  
ATOM    987 HG23 ILE A  66      47.474  39.236  46.173  1.00  0.00           H  
ATOM    988 HD11 ILE A  66      46.824  39.858  50.612  1.00  0.00           H  
ATOM    989 HD12 ILE A  66      45.391  38.885  50.951  1.00  0.00           H  
ATOM    990 HD13 ILE A  66      46.987  38.288  51.405  1.00  0.00           H  
ATOM    991  N   SER A  67      49.665  37.276  48.070  1.00  0.00           N  
ATOM    992  CA  SER A  67      50.599  36.408  47.358  1.00  0.00           C  
ATOM    993  C   SER A  67      49.903  35.147  46.847  1.00  0.00           C  
ATOM    994  O   SER A  67      49.092  34.545  47.550  1.00  0.00           O  
ATOM    995  CB  SER A  67      51.765  36.024  48.272  1.00  0.00           C  
ATOM    996  OG  SER A  67      52.283  37.161  48.940  1.00  0.00           O  
ATOM    997  H   SER A  67      48.970  36.875  48.629  1.00  0.00           H  
ATOM    998  HA  SER A  67      50.984  36.959  46.514  1.00  0.00           H  
ATOM    999  HB2 SER A  67      51.424  35.313  49.009  1.00  0.00           H  
ATOM   1000  HB3 SER A  67      52.551  35.579  47.680  1.00  0.00           H  
ATOM   1001  HG  SER A  67      51.877  37.236  49.806  1.00  0.00           H  
ATOM   1002  N   GLU A  68      50.236  34.753  45.617  1.00  0.00           N  
ATOM   1003  CA  GLU A  68      49.661  33.560  44.991  1.00  0.00           C  
ATOM   1004  C   GLU A  68      49.516  32.419  45.997  1.00  0.00           C  
ATOM   1005  O   GLU A  68      50.509  31.916  46.524  1.00  0.00           O  
ATOM   1006  CB  GLU A  68      50.534  33.111  43.819  1.00  0.00           C  
ATOM   1007  CG  GLU A  68      50.703  34.173  42.746  1.00  0.00           C  
ATOM   1008  CD  GLU A  68      51.594  33.717  41.608  1.00  0.00           C  
ATOM   1009  OE1 GLU A  68      52.226  32.647  41.740  1.00  0.00           O  
ATOM   1010  OE2 GLU A  68      51.661  34.428  40.582  1.00  0.00           O  
ATOM   1011  H   GLU A  68      50.888  35.279  45.114  1.00  0.00           H  
ATOM   1012  HA  GLU A  68      48.683  33.820  44.615  1.00  0.00           H  
ATOM   1013  HB2 GLU A  68      51.512  32.850  44.193  1.00  0.00           H  
ATOM   1014  HB3 GLU A  68      50.087  32.239  43.364  1.00  0.00           H  
ATOM   1015  HG2 GLU A  68      49.731  34.419  42.345  1.00  0.00           H  
ATOM   1016  HG3 GLU A  68      51.139  35.054  43.194  1.00  0.00           H  
ATOM   1017  N   GLY A  69      48.277  32.023  46.265  1.00  0.00           N  
ATOM   1018  CA  GLY A  69      48.030  30.953  47.212  1.00  0.00           C  
ATOM   1019  C   GLY A  69      48.330  31.369  48.638  1.00  0.00           C  
ATOM   1020  O   GLY A  69      49.342  30.962  49.209  1.00  0.00           O  
ATOM   1021  H   GLY A  69      47.524  32.462  45.818  1.00  0.00           H  
ATOM   1022  HA2 GLY A  69      46.994  30.659  47.143  1.00  0.00           H  
ATOM   1023  HA3 GLY A  69      48.653  30.109  46.955  1.00  0.00           H  
ATOM   1024  N   GLY A  70      47.450  32.184  49.215  1.00  0.00           N  
ATOM   1025  CA  GLY A  70      47.649  32.639  50.578  1.00  0.00           C  
ATOM   1026  C   GLY A  70      46.370  32.618  51.388  1.00  0.00           C  
ATOM   1027  O   GLY A  70      46.179  33.442  52.282  1.00  0.00           O  
ATOM   1028  H   GLY A  70      46.659  32.478  48.712  1.00  0.00           H  
ATOM   1029  HA2 GLY A  70      48.377  32.000  51.058  1.00  0.00           H  
ATOM   1030  HA3 GLY A  70      48.033  33.648  50.557  1.00  0.00           H  
ATOM   1031  N   LEU A  71      45.490  31.674  51.073  1.00  0.00           N  
ATOM   1032  CA  LEU A  71      44.218  31.546  51.773  1.00  0.00           C  
ATOM   1033  C   LEU A  71      43.506  32.892  51.861  1.00  0.00           C  
ATOM   1034  O   LEU A  71      43.770  33.689  52.761  1.00  0.00           O  
ATOM   1035  CB  LEU A  71      44.436  30.982  53.177  1.00  0.00           C  
ATOM   1036  CG  LEU A  71      43.155  30.647  53.942  1.00  0.00           C  
ATOM   1037  CD1 LEU A  71      42.192  29.876  53.052  1.00  0.00           C  
ATOM   1038  CD2 LEU A  71      43.477  29.850  55.198  1.00  0.00           C  
ATOM   1039  H   LEU A  71      45.700  31.047  50.348  1.00  0.00           H  
ATOM   1040  HA  LEU A  71      43.600  30.862  51.213  1.00  0.00           H  
ATOM   1041  HB2 LEU A  71      45.029  30.082  53.094  1.00  0.00           H  
ATOM   1042  HB3 LEU A  71      44.992  31.707  53.752  1.00  0.00           H  
ATOM   1043  HG  LEU A  71      42.672  31.566  54.242  1.00  0.00           H  
ATOM   1044 HD11 LEU A  71      42.736  29.444  52.224  1.00  0.00           H  
ATOM   1045 HD12 LEU A  71      41.723  29.091  53.625  1.00  0.00           H  
ATOM   1046 HD13 LEU A  71      41.435  30.548  52.673  1.00  0.00           H  
ATOM   1047 HD21 LEU A  71      44.155  29.047  54.951  1.00  0.00           H  
ATOM   1048 HD22 LEU A  71      43.938  30.499  55.929  1.00  0.00           H  
ATOM   1049 HD23 LEU A  71      42.566  29.439  55.607  1.00  0.00           H  
ATOM   1050  N   ILE A  72      42.602  33.137  50.919  1.00  0.00           N  
ATOM   1051  CA  ILE A  72      41.855  34.382  50.887  1.00  0.00           C  
ATOM   1052  C   ILE A  72      40.501  34.218  51.587  1.00  0.00           C  
ATOM   1053  O   ILE A  72      40.310  34.697  52.703  1.00  0.00           O  
ATOM   1054  CB  ILE A  72      41.689  34.883  49.420  1.00  0.00           C  
ATOM   1055  CG1 ILE A  72      42.809  35.867  49.085  1.00  0.00           C  
ATOM   1056  CG2 ILE A  72      40.328  35.533  49.161  1.00  0.00           C  
ATOM   1057  CD1 ILE A  72      43.426  35.635  47.726  1.00  0.00           C  
ATOM   1058  H   ILE A  72      42.437  32.463  50.228  1.00  0.00           H  
ATOM   1059  HA  ILE A  72      42.431  35.121  51.428  1.00  0.00           H  
ATOM   1060  HB  ILE A  72      41.780  34.028  48.767  1.00  0.00           H  
ATOM   1061 HG12 ILE A  72      42.411  36.873  49.100  1.00  0.00           H  
ATOM   1062 HG13 ILE A  72      43.589  35.781  49.825  1.00  0.00           H  
ATOM   1063 HG21 ILE A  72      39.994  36.039  50.055  1.00  0.00           H  
ATOM   1064 HG22 ILE A  72      40.421  36.247  48.356  1.00  0.00           H  
ATOM   1065 HG23 ILE A  72      39.612  34.773  48.888  1.00  0.00           H  
ATOM   1066 HD11 ILE A  72      42.672  35.267  47.046  1.00  0.00           H  
ATOM   1067 HD12 ILE A  72      43.829  36.564  47.351  1.00  0.00           H  
ATOM   1068 HD13 ILE A  72      44.218  34.907  47.813  1.00  0.00           H  
ATOM   1069  N   VAL A  73      39.564  33.545  50.927  1.00  0.00           N  
ATOM   1070  CA  VAL A  73      38.240  33.337  51.499  1.00  0.00           C  
ATOM   1071  C   VAL A  73      37.869  31.859  51.542  1.00  0.00           C  
ATOM   1072  O   VAL A  73      38.091  31.120  50.586  1.00  0.00           O  
ATOM   1073  CB  VAL A  73      37.156  34.102  50.713  1.00  0.00           C  
ATOM   1074  CG1 VAL A  73      37.488  35.584  50.647  1.00  0.00           C  
ATOM   1075  CG2 VAL A  73      36.994  33.519  49.318  1.00  0.00           C  
ATOM   1076  H   VAL A  73      39.765  33.187  50.037  1.00  0.00           H  
ATOM   1077  HA  VAL A  73      38.254  33.721  52.509  1.00  0.00           H  
ATOM   1078  HB  VAL A  73      36.217  33.992  51.236  1.00  0.00           H  
ATOM   1079 HG11 VAL A  73      38.335  35.793  51.285  1.00  0.00           H  
ATOM   1080 HG12 VAL A  73      37.731  35.854  49.629  1.00  0.00           H  
ATOM   1081 HG13 VAL A  73      36.636  36.159  50.979  1.00  0.00           H  
ATOM   1082 HG21 VAL A  73      36.762  32.466  49.394  1.00  0.00           H  
ATOM   1083 HG22 VAL A  73      36.192  34.029  48.806  1.00  0.00           H  
ATOM   1084 HG23 VAL A  73      37.912  33.646  48.766  1.00  0.00           H  
ATOM   1085  N   VAL A  74      37.292  31.440  52.658  1.00  0.00           N  
ATOM   1086  CA  VAL A  74      36.873  30.057  52.834  1.00  0.00           C  
ATOM   1087  C   VAL A  74      35.359  29.949  52.711  1.00  0.00           C  
ATOM   1088  O   VAL A  74      34.632  30.830  53.167  1.00  0.00           O  
ATOM   1089  CB  VAL A  74      37.314  29.519  54.209  1.00  0.00           C  
ATOM   1090  CG1 VAL A  74      36.878  28.074  54.393  1.00  0.00           C  
ATOM   1091  CG2 VAL A  74      38.821  29.656  54.375  1.00  0.00           C  
ATOM   1092  H   VAL A  74      37.134  32.081  53.382  1.00  0.00           H  
ATOM   1093  HA  VAL A  74      37.336  29.459  52.059  1.00  0.00           H  
ATOM   1094  HB  VAL A  74      36.835  30.115  54.970  1.00  0.00           H  
ATOM   1095 HG11 VAL A  74      35.918  27.922  53.923  1.00  0.00           H  
ATOM   1096 HG12 VAL A  74      37.607  27.417  53.942  1.00  0.00           H  
ATOM   1097 HG13 VAL A  74      36.801  27.854  55.448  1.00  0.00           H  
ATOM   1098 HG21 VAL A  74      39.261  29.955  53.436  1.00  0.00           H  
ATOM   1099 HG22 VAL A  74      39.033  30.403  55.127  1.00  0.00           H  
ATOM   1100 HG23 VAL A  74      39.237  28.708  54.682  1.00  0.00           H  
ATOM   1101  N   VAL A  75      34.882  28.883  52.079  1.00  0.00           N  
ATOM   1102  CA  VAL A  75      33.455  28.699  51.894  1.00  0.00           C  
ATOM   1103  C   VAL A  75      32.980  27.337  52.376  1.00  0.00           C  
ATOM   1104  O   VAL A  75      33.780  26.463  52.709  1.00  0.00           O  
ATOM   1105  CB  VAL A  75      33.070  28.859  50.417  1.00  0.00           C  
ATOM   1106  CG1 VAL A  75      33.437  30.246  49.912  1.00  0.00           C  
ATOM   1107  CG2 VAL A  75      33.735  27.783  49.577  1.00  0.00           C  
ATOM   1108  H   VAL A  75      35.499  28.217  51.718  1.00  0.00           H  
ATOM   1109  HA  VAL A  75      32.948  29.462  52.457  1.00  0.00           H  
ATOM   1110  HB  VAL A  75      32.007  28.741  50.335  1.00  0.00           H  
ATOM   1111 HG11 VAL A  75      33.198  30.980  50.667  1.00  0.00           H  
ATOM   1112 HG12 VAL A  75      34.496  30.283  49.699  1.00  0.00           H  
ATOM   1113 HG13 VAL A  75      32.880  30.461  49.013  1.00  0.00           H  
ATOM   1114 HG21 VAL A  75      34.019  26.955  50.210  1.00  0.00           H  
ATOM   1115 HG22 VAL A  75      33.043  27.438  48.822  1.00  0.00           H  
ATOM   1116 HG23 VAL A  75      34.614  28.190  49.100  1.00  0.00           H  
ATOM   1117  N   GLU A  76      31.661  27.169  52.400  1.00  0.00           N  
ATOM   1118  CA  GLU A  76      31.050  25.919  52.828  1.00  0.00           C  
ATOM   1119  C   GLU A  76      30.989  24.936  51.665  1.00  0.00           C  
ATOM   1120  O   GLU A  76      31.227  23.741  51.836  1.00  0.00           O  
ATOM   1121  CB  GLU A  76      29.641  26.179  53.371  1.00  0.00           C  
ATOM   1122  CG  GLU A  76      29.364  25.495  54.698  1.00  0.00           C  
ATOM   1123  CD  GLU A  76      29.070  24.017  54.540  1.00  0.00           C  
ATOM   1124  OE1 GLU A  76      28.636  23.611  53.441  1.00  0.00           O  
ATOM   1125  OE2 GLU A  76      29.270  23.263  55.516  1.00  0.00           O  
ATOM   1126  H   GLU A  76      31.083  27.907  52.116  1.00  0.00           H  
ATOM   1127  HA  GLU A  76      31.660  25.499  53.613  1.00  0.00           H  
ATOM   1128  HB2 GLU A  76      29.507  27.245  53.503  1.00  0.00           H  
ATOM   1129  HB3 GLU A  76      28.920  25.822  52.650  1.00  0.00           H  
ATOM   1130  HG2 GLU A  76      30.231  25.607  55.335  1.00  0.00           H  
ATOM   1131  HG3 GLU A  76      28.514  25.970  55.163  1.00  0.00           H  
ATOM   1132  N   ALA A  77      30.682  25.461  50.480  1.00  0.00           N  
ATOM   1133  CA  ALA A  77      30.595  24.656  49.268  1.00  0.00           C  
ATOM   1134  C   ALA A  77      29.590  23.513  49.402  1.00  0.00           C  
ATOM   1135  O   ALA A  77      29.523  22.842  50.430  1.00  0.00           O  
ATOM   1136  CB  ALA A  77      31.964  24.122  48.902  1.00  0.00           C  
ATOM   1137  H   ALA A  77      30.523  26.422  50.418  1.00  0.00           H  
ATOM   1138  HA  ALA A  77      30.270  25.305  48.468  1.00  0.00           H  
ATOM   1139  HB1 ALA A  77      32.140  24.279  47.849  1.00  0.00           H  
ATOM   1140  HB2 ALA A  77      32.010  23.067  49.122  1.00  0.00           H  
ATOM   1141  HB3 ALA A  77      32.715  24.645  49.475  1.00  0.00           H  
ATOM   1142  N   GLU A  78      28.809  23.298  48.343  1.00  0.00           N  
ATOM   1143  CA  GLU A  78      27.801  22.239  48.314  1.00  0.00           C  
ATOM   1144  C   GLU A  78      27.085  22.104  49.658  1.00  0.00           C  
ATOM   1145  O   GLU A  78      26.801  20.998  50.116  1.00  0.00           O  
ATOM   1146  CB  GLU A  78      28.451  20.911  47.930  1.00  0.00           C  
ATOM   1147  CG  GLU A  78      27.685  20.148  46.864  1.00  0.00           C  
ATOM   1148  CD  GLU A  78      28.199  18.734  46.675  1.00  0.00           C  
ATOM   1149  OE1 GLU A  78      27.865  17.865  47.506  1.00  0.00           O  
ATOM   1150  OE2 GLU A  78      28.935  18.497  45.694  1.00  0.00           O  
ATOM   1151  H   GLU A  78      28.916  23.867  47.553  1.00  0.00           H  
ATOM   1152  HA  GLU A  78      27.073  22.500  47.561  1.00  0.00           H  
ATOM   1153  HB2 GLU A  78      29.444  21.109  47.554  1.00  0.00           H  
ATOM   1154  HB3 GLU A  78      28.523  20.288  48.809  1.00  0.00           H  
ATOM   1155  HG2 GLU A  78      26.644  20.102  47.151  1.00  0.00           H  
ATOM   1156  HG3 GLU A  78      27.774  20.679  45.927  1.00  0.00           H  
ATOM   1157  N   GLY A  79      26.794  23.242  50.283  1.00  0.00           N  
ATOM   1158  CA  GLY A  79      26.116  23.233  51.564  1.00  0.00           C  
ATOM   1159  C   GLY A  79      24.608  23.324  51.423  1.00  0.00           C  
ATOM   1160  O   GLY A  79      24.099  23.746  50.386  1.00  0.00           O  
ATOM   1161  H   GLY A  79      27.045  24.095  49.869  1.00  0.00           H  
ATOM   1162  HA2 GLY A  79      26.362  22.320  52.085  1.00  0.00           H  
ATOM   1163  HA3 GLY A  79      26.462  24.073  52.149  1.00  0.00           H  
ATOM   1164  N   THR A  80      23.893  22.927  52.471  1.00  0.00           N  
ATOM   1165  CA  THR A  80      22.435  22.966  52.462  1.00  0.00           C  
ATOM   1166  C   THR A  80      21.904  23.717  53.680  1.00  0.00           C  
ATOM   1167  O   THR A  80      22.649  24.002  54.617  1.00  0.00           O  
ATOM   1168  CB  THR A  80      21.867  21.546  52.435  1.00  0.00           C  
ATOM   1169  OG1 THR A  80      21.917  20.961  53.724  1.00  0.00           O  
ATOM   1170  CG2 THR A  80      22.602  20.625  51.485  1.00  0.00           C  
ATOM   1171  H   THR A  80      24.357  22.601  53.270  1.00  0.00           H  
ATOM   1172  HA  THR A  80      22.123  23.486  51.569  1.00  0.00           H  
ATOM   1173  HB  THR A  80      20.834  21.587  52.122  1.00  0.00           H  
ATOM   1174  HG1 THR A  80      21.415  20.143  53.724  1.00  0.00           H  
ATOM   1175 HG21 THR A  80      23.341  21.190  50.935  1.00  0.00           H  
ATOM   1176 HG22 THR A  80      23.091  19.843  52.047  1.00  0.00           H  
ATOM   1177 HG23 THR A  80      21.898  20.185  50.792  1.00  0.00           H  
ATOM   1178  N   ALA A  81      20.614  24.033  53.658  1.00  0.00           N  
ATOM   1179  CA  ALA A  81      19.986  24.752  54.760  1.00  0.00           C  
ATOM   1180  C   ALA A  81      18.842  23.943  55.364  1.00  0.00           C  
ATOM   1181  O   ALA A  81      18.353  23.016  54.686  1.00  0.00           O  
ATOM   1182  CB  ALA A  81      19.482  26.107  54.287  1.00  0.00           C  
ATOM   1183  OXT ALA A  81      18.446  24.246  56.509  1.00  0.00           O  
ATOM   1184  H   ALA A  81      20.071  23.779  52.883  1.00  0.00           H  
ATOM   1185  HA  ALA A  81      20.736  24.919  55.521  1.00  0.00           H  
ATOM   1186  HB1 ALA A  81      18.712  25.965  53.543  1.00  0.00           H  
ATOM   1187  HB2 ALA A  81      20.301  26.665  53.856  1.00  0.00           H  
ATOM   1188  HB3 ALA A  81      19.076  26.653  55.126  1.00  0.00           H  
TER    1189      ALA A  81                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
