
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  101 (  825),  selected  101 , name 2hj3_A
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 2hj3_A.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    K    11_A      M       3          1.491
LGA    E    12_A      L       4          1.848
LGA    D    13_A      H       5          1.553
LGA    L    14_A      W       6          1.450
LGA    G    15_A      G       7          0.992
LGA    R    16_A      P       8          0.420
LGA    A    17_A      K       9          0.355
LGA    T    18_A      Y      10          0.809
LGA    W    19_A      W      11          0.744
LGA    T    20_A      R      12          1.009
LGA    F    21_A      S      13          1.267
LGA    L    22_A      L      14          1.169
LGA    H    23_A      H      15          1.022
LGA    T    24_A      L      16          1.679
LGA    L    25_A      Y      17          1.866
LGA    A    26_A      A      18          1.609
LGA    A    27_A      I      19          1.764
LGA    Q    28_A      F      20          1.797
LGA    Y    29_A      F      21          1.681
LGA    P    30_A      S      22          1.613
LGA    E    31_A      D      23          1.163
LGA    K    32_A      A      24          0.903
LGA    P    33_A      P      25          1.245
LGA    T    34_A      S      26          1.997
LGA    R    35_A      W      27          2.016
LGA    Q    36_A      K      28          2.117
LGA    Q    37_A      E      29          1.800
LGA    K    38_A      K      30          1.225
LGA    K    39_A      Y      31          1.280
LGA    D    40_A      E      32          1.420
LGA    V    41_A      A      33          1.252
LGA    K    42_A      I      34          1.093
LGA    E    43_A      Q      35          1.024
LGA    L    44_A      W      36          1.227
LGA    M    45_A      I      37          1.276
LGA    T    46_A      L      38          1.717
LGA    I    47_A      N      39          2.143
LGA    L    48_A      F      40          2.687
LGA    S    49_A      I      41          3.056
LGA    R    50_A      E      42          3.239
LGA    M    51_A      S      43          3.476
LGA    Y    52_A      L      44          1.718
LGA    P    53_A      P      45          1.718
LGA    C    54_A      C      46          1.248
LGA    R    55_A      T      47          1.197
LGA    E    56_A      R      48          0.757
LGA    C    57_A      C      49          0.685
LGA    A    58_A      Q      50          0.750
LGA    D    59_A      H      51          0.793
LGA    H    60_A      H      52          0.545
LGA    F    61_A      A      53          0.363
LGA    K    62_A      F      54          0.620
LGA    E    63_A      S      55          0.688
LGA    I    64_A      Y      56          0.608
LGA    L    65_A      L      57          0.634
LGA    R    66_A      T      58          1.128
LGA    S    67_A      K      59          0.468
LGA    N    68_A      N      60          0.660
LGA    P    69_A      P      61          1.497
LGA    A    70_A      L      62          1.288
LGA    Q    71_A      T      63          0.958
LGA    A    72_A      L      64          1.244
LGA    G    73_A      N      65          1.201
LGA    S    74_A      N      66          0.509
LGA    Q    75_A      S      67          0.836
LGA    E    76_A      E      68          1.102
LGA    E    77_A      D      69          0.632
LGA    F    78_A      F      70          0.426
LGA    S    79_A      Q      71          0.574
LGA    Q    80_A      Y      72          0.449
LGA    W    81_A      W      73          0.552
LGA    L    82_A      T      74          0.311
LGA    C    83_A      F      75          0.324
LGA    H    84_A      A      76          0.286
LGA    V    85_A      F      77          0.216
LGA    H    86_A      H      78          0.303
LGA    N    87_A      N      79          0.515
LGA    T    88_A      N      80          0.543
LGA    V    89_A      V      81          0.263
LGA    N    90_A      N      82          0.179
LGA    R    91_A      N      83          0.137
LGA    S    92_A      R      84          0.301
LGA    L    93_A      L      85          0.176
LGA    G    94_A      N      86          0.605
LGA    K    95_A      K      87          0.246
LGA    L    96_A      K      88          0.215
LGA    V    97_A      I      89          0.426
LGA    F    98_A      I      90          1.420
LGA    P    99_A      S      91          1.072
LGA    C   100_A      W      92          2.219
LGA    E   101_A      S      93          3.801
LGA    R   102_A      E      94          3.798
LGA    V   103_A      Y      95          2.657
LGA    D   104_A      K      96          2.819
LGA    A   105_A      N      97          2.363
LGA    R   106_A      I      98          1.549
LGA    W   107_A      Y      99          1.183
LGA    G   108_A      E     100          3.298
LGA    -       -      Q     101           -
LGA    -       -      S     102           -
LGA    -       -      I     103           -
LGA    -       -      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  101  102    5.0     98    1.49    23.47     90.273     6.168

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.331432 * X  +  -0.299290 * Y  +  -0.894751 * Z  +  29.565363
  Y_new =   0.871211 * X  +   0.461093 * Y  +   0.168479 * Z  +  36.070122
  Z_new =   0.362140 * X  +  -0.835355 * Y  +   0.413565 * Z  + -25.488230 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.111095    2.030498  [ DEG:   -63.6610    116.3390 ]
  Theta =  -0.370562   -2.771030  [ DEG:   -21.2317   -158.7683 ]
  Phi   =   1.207277   -1.934316  [ DEG:    69.1719   -110.8281 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hj3_A                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hj3_A.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  101  102   5.0   98   1.49   23.47  90.273
REMARK  ---------------------------------------------------------- 
MOLECULE 2hj3_A
HEADER    OXIDOREDUCTASE                          30-JUN-06   2HJ3              
TITLE     STRUCTURE OF THE ARABIDOPSIS THALIANA ERV1 THIOL OXIDASE              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SULFHYDRYL OXIDASE ERV1P;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARABIDOPSIS THALIANA;                           
SOURCE   3 ORGANISM_COMMON: MOUSE-EAR CRESS;                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 PLYS S;                               
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15                                     
KEYWDS    FOUR-HELIX BUNDLE, FLAVIN ADENINE DINUCLEOTIDE                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.VITU,D.FASS                                                         
REVDAT   2   05-SEP-06 2HJ3    1       JRNL                                     
REVDAT   1   22-AUG-06 2HJ3    0                                                
JRNL        AUTH   E.VITU,M.BENTZUR,T.LISOWSKY,C.A.KAISER,D.FASS                
JRNL        TITL   GAIN OF FUNCTION IN AN ERV/ALR SULFHYDRYL OXIDASE            
JRNL        TITL 2 BY MOLECULAR ENGINEERING OF THE SHUTTLE DISULFIDE.           
JRNL        REF    J.MOL.BIOL.                   V. 362    89 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2HJ3 A    6   126  UNP    Q8LC15   Q8LC15_ARATH    70    190             
DBREF  2HJ3 B    6   126  UNP    Q8LC15   Q8LC15_ARATH    70    190             
SEQRES   1 A  125  GLY SER HIS MET THR GLY PRO VAL THR LYS GLU ASP LEU          
SEQRES   2 A  125  GLY ARG ALA THR TRP THR PHE LEU HIS THR LEU ALA ALA          
SEQRES   3 A  125  GLN TYR PRO GLU LYS PRO THR ARG GLN GLN LYS LYS ASP          
SEQRES   4 A  125  VAL LYS GLU LEU MET THR ILE LEU SER ARG MET TYR PRO          
SEQRES   5 A  125  CYS ARG GLU CYS ALA ASP HIS PHE LYS GLU ILE LEU ARG          
SEQRES   6 A  125  SER ASN PRO ALA GLN ALA GLY SER GLN GLU GLU PHE SER          
SEQRES   7 A  125  GLN TRP LEU CYS HIS VAL HIS ASN THR VAL ASN ARG SER          
SEQRES   8 A  125  LEU GLY LYS LEU VAL PHE PRO CYS GLU ARG VAL ASP ALA          
SEQRES   9 A  125  ARG TRP GLY LYS LEU GLU CYS GLU GLN LYS SER CYS ASP          
SEQRES  10 A  125  LEU HIS GLY THR SER MET ASP PHE                              
SEQRES   1 B  125  GLY SER HIS MET THR GLY PRO VAL THR LYS GLU ASP LEU          
SEQRES   2 B  125  GLY ARG ALA THR TRP THR PHE LEU HIS THR LEU ALA ALA          
SEQRES   3 B  125  GLN TYR PRO GLU LYS PRO THR ARG GLN GLN LYS LYS ASP          
SEQRES   4 B  125  VAL LYS GLU LEU MET THR ILE LEU SER ARG MET TYR PRO          
SEQRES   5 B  125  CYS ARG GLU CYS ALA ASP HIS PHE LYS GLU ILE LEU ARG          
SEQRES   6 B  125  SER ASN PRO ALA GLN ALA GLY SER GLN GLU GLU PHE SER          
SEQRES   7 B  125  GLN TRP LEU CYS HIS VAL HIS ASN THR VAL ASN ARG SER          
SEQRES   8 B  125  LEU GLY LYS LEU VAL PHE PRO CYS GLU ARG VAL ASP ALA          
SEQRES   9 B  125  ARG TRP GLY LYS LEU GLU CYS GLU GLN LYS SER CYS ASP          
SEQRES  10 B  125  LEU HIS GLY THR SER MET ASP PHE                              
HET    SO4    500       5                                                       
HET    SO4    501       5                                                       
HET    SO4    502       5                                                       
HET    SO4    503       5                                                       
HET    SO4    504       5                                                       
HET    SO4    505       5                                                       
HET    SO4    506       5                                                       
HET    SO4    507       5                                                       
HET    SO4    508       5                                                       
HET    SO4    509       5                                                       
HET    SO4    510       5                                                       
HET    SO4    511       5                                                       
HET    FAD   1001      53                                                       
HET    FAD   2001      53                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   3  SO4    12(O4 S 2-)                                                  
FORMUL  15  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL  17  HOH   *117(H2 O)                                                    
CRYST1   82.840   82.840  160.813  90.00  90.00 120.00 P 65 2 2     24          
ATOM      1  N   PRO A   8      56.556  31.378  10.641  1.00 83.05           N  
ATOM      2  CA  PRO A   8      55.393  32.089  11.226  1.00 82.73           C  
ATOM      3  C   PRO A   8      54.083  31.503  10.699  1.00 81.38           C  
ATOM      4  O   PRO A   8      54.040  30.956   9.594  1.00 81.39           O  
ATOM      5  CB  PRO A   8      55.529  33.550  10.825  1.00 82.85           C  
ATOM      6  CG  PRO A   8      56.288  33.419   9.498  1.00 83.16           C  
ATOM      7  CD  PRO A   8      57.306  32.291   9.756  1.00 83.81           C  
ATOM      8  N   VAL A   9      53.021  31.621  11.492  1.00 78.95           N  
ATOM      9  CA  VAL A   9      51.710  31.109  11.103  1.00 75.83           C  
ATOM     10  C   VAL A   9      51.751  29.644  10.669  1.00 73.49           C  
ATOM     11  O   VAL A   9      52.105  29.326   9.533  1.00 72.45           O  
ATOM     12  CB  VAL A   9      51.097  31.966   9.960  1.00 75.70           C  
ATOM     13  CG1 VAL A   9      49.861  31.285   9.391  1.00 75.47           C  
ATOM     14  CG2 VAL A   9      50.720  33.342  10.493  1.00 75.48           C  
ATOM     15  N   THR A  10      51.384  28.757  11.588  1.00 70.51           N  
ATOM     16  CA  THR A  10      51.360  27.328  11.312  1.00 67.18           C  
ATOM     17  C   THR A  10      49.980  26.937  10.796  1.00 64.93           C  
ATOM     18  O   THR A  10      49.068  27.760  10.744  1.00 63.54           O  
ATOM     19  CB  THR A  10      51.649  26.502  12.587  1.00 67.52           C  
ATOM     20  OG1 THR A  10      50.647  26.778  13.575  1.00 67.99           O  
ATOM     21  CG2 THR A  10      53.013  26.856  13.156  1.00 66.94           C  
ATOM     22  N   LYS A  11      49.841  25.676  10.411  1.00 63.72           N  
ATOM     23  CA  LYS A  11      48.577  25.153   9.921  1.00 62.37           C  
ATOM     24  C   LYS A  11      47.483  25.451  10.948  1.00 60.86           C  
ATOM     25  O   LYS A  11      46.342  25.753  10.591  1.00 59.66           O  
ATOM     26  CB  LYS A  11      48.699  23.643   9.717  1.00 64.37           C  
ATOM     27  CG  LYS A  11      47.395  22.939   9.411  1.00 67.74           C  
ATOM     28  CD  LYS A  11      47.504  21.433   9.657  1.00 70.09           C  
ATOM     29  CE  LYS A  11      48.527  20.773   8.740  1.00 71.98           C  
ATOM     30  NZ  LYS A  11      48.535  19.285   8.897  1.00 73.83           N  
ATOM     31  N   GLU A  12      47.844  25.373  12.226  1.00 58.51           N  
ATOM     32  CA  GLU A  12      46.893  25.623  13.301  1.00 57.75           C  
ATOM     33  C   GLU A  12      46.508  27.090  13.439  1.00 55.80           C  
ATOM     34  O   GLU A  12      45.342  27.397  13.676  1.00 56.88           O  
ATOM     35  CB  GLU A  12      47.438  25.111  14.639  1.00 58.73           C  
ATOM     36  CG  GLU A  12      47.636  23.597  14.724  1.00 61.23           C  
ATOM     37  CD  GLU A  12      48.853  23.112  13.946  1.00 64.67           C  
ATOM     38  OE1 GLU A  12      49.907  23.782  14.018  1.00 67.02           O  
ATOM     39  OE2 GLU A  12      48.767  22.058  13.278  1.00 65.25           O  
ATOM     40  N   ASP A  13      47.474  27.996  13.302  1.00 54.97           N  
ATOM     41  CA  ASP A  13      47.183  29.424  13.410  1.00 52.56           C  
ATOM     42  C   ASP A  13      46.245  29.848  12.283  1.00 49.98           C  
ATOM     43  O   ASP A  13      45.338  30.657  12.489  1.00 49.62           O  
ATOM     44  CB  ASP A  13      48.466  30.258  13.340  1.00 58.35           C  
ATOM     45  CG  ASP A  13      49.353  30.088  14.567  1.00 62.89           C  
ATOM     46  OD1 ASP A  13      48.884  30.362  15.693  1.00 64.82           O  
ATOM     47  OD2 ASP A  13      50.527  29.688  14.399  1.00 65.56           O  
ATOM     48  N   LEU A  14      46.473  29.301  11.091  1.00 46.01           N  
ATOM     49  CA  LEU A  14      45.651  29.616   9.929  1.00 43.64           C  
ATOM     50  C   LEU A  14      44.228  29.149  10.208  1.00 43.15           C  
ATOM     51  O   LEU A  14      43.273  29.913  10.067  1.00 41.74           O  
ATOM     52  CB  LEU A  14      46.198  28.911   8.682  1.00 43.51           C  
ATOM     53  CG  LEU A  14      45.497  29.231   7.356  1.00 44.03           C  
ATOM     54  CD1 LEU A  14      45.760  30.678   6.998  1.00 45.44           C  
ATOM     55  CD2 LEU A  14      45.989  28.314   6.248  1.00 42.71           C  
ATOM     56  N   GLY A  15      44.106  27.888  10.622  1.00 43.45           N  
ATOM     57  CA  GLY A  15      42.812  27.309  10.938  1.00 40.40           C  
ATOM     58  C   GLY A  15      42.024  28.120  11.942  1.00 39.90           C  
ATOM     59  O   GLY A  15      40.860  28.430  11.701  1.00 41.65           O  
ATOM     60  N   ARG A  16      42.650  28.482  13.058  1.00 40.34           N  
ATOM     61  CA  ARG A  16      41.968  29.260  14.099  1.00 41.02           C  
ATOM     62  C   ARG A  16      41.508  30.619  13.609  1.00 40.76           C  
ATOM     63  O   ARG A  16      40.423  31.082  13.966  1.00 41.44           O  
ATOM     64  CB  ARG A  16      42.870  29.460  15.323  1.00 42.57           C  
ATOM     65  CG  ARG A  16      42.940  28.266  16.264  1.00 46.31           C  
ATOM     66  CD  ARG A  16      43.710  28.614  17.535  1.00 50.12           C  
ATOM     67  NE  ARG A  16      45.160  28.606  17.341  1.00 52.74           N  
ATOM     68  CZ  ARG A  16      45.914  27.508  17.364  1.00 53.71           C  
ATOM     69  NH1 ARG A  16      45.354  26.319  17.583  1.00 52.36           N  
ATOM     70  NH2 ARG A  16      47.226  27.596  17.160  1.00 50.91           N  
ATOM     71  N   ALA A  17      42.349  31.266  12.806  1.00 39.93           N  
ATOM     72  CA  ALA A  17      42.027  32.571  12.266  1.00 37.61           C  
ATOM     73  C   ALA A  17      40.839  32.453  11.307  1.00 37.97           C  
ATOM     74  O   ALA A  17      39.862  33.195  11.407  1.00 38.98           O  
ATOM     75  CB  ALA A  17      43.244  33.137  11.539  1.00 39.34           C  
ATOM     76  N   THR A  18      40.919  31.505  10.386  1.00 35.98           N  
ATOM     77  CA  THR A  18      39.860  31.308   9.418  1.00 37.08           C  
ATOM     78  C   THR A  18      38.524  30.924  10.062  1.00 38.42           C  
ATOM     79  O   THR A  18      37.481  31.483   9.713  1.00 37.56           O  
ATOM     80  CB  THR A  18      40.267  30.245   8.384  1.00 39.26           C  
ATOM     81  OG1 THR A  18      41.496  30.642   7.751  1.00 39.64           O  
ATOM     82  CG2 THR A  18      39.183  30.102   7.320  1.00 37.74           C  
ATOM     83  N   TRP A  19      38.541  29.979  11.002  1.00 38.50           N  
ATOM     84  CA  TRP A  19      37.294  29.590  11.660  1.00 37.50           C  
ATOM     85  C   TRP A  19      36.657  30.819  12.320  1.00 36.22           C  
ATOM     86  O   TRP A  19      35.447  31.046  12.194  1.00 36.25           O  
ATOM     87  CB  TRP A  19      37.537  28.475  12.695  1.00 37.88           C  
ATOM     88  CG  TRP A  19      37.811  27.125  12.081  1.00 36.70           C  
ATOM     89  CD1 TRP A  19      38.889  26.318  12.324  1.00 37.33           C  
ATOM     90  CD2 TRP A  19      37.002  26.429  11.113  1.00 37.48           C  
ATOM     91  NE1 TRP A  19      38.806  25.168  11.566  1.00 38.22           N  
ATOM     92  CE2 TRP A  19      37.658  25.209  10.816  1.00 37.15           C  
ATOM     93  CE3 TRP A  19      35.788  26.717  10.468  1.00 38.50           C  
ATOM     94  CZ2 TRP A  19      37.141  24.277   9.895  1.00 36.60           C  
ATOM     95  CZ3 TRP A  19      35.270  25.784   9.548  1.00 36.87           C  
ATOM     96  CH2 TRP A  19      35.952  24.582   9.274  1.00 36.08           C  
ATOM     97  N   THR A  20      37.470  31.627  12.998  1.00 34.83           N  
ATOM     98  CA  THR A  20      36.967  32.842  13.646  1.00 35.59           C  
ATOM     99  C   THR A  20      36.264  33.730  12.620  1.00 36.60           C  
ATOM    100  O   THR A  20      35.167  34.243  12.857  1.00 37.80           O  
ATOM    101  CB  THR A  20      38.116  33.650  14.289  1.00 35.59           C  
ATOM    102  OG1 THR A  20      38.685  32.888  15.362  1.00 37.81           O  
ATOM    103  CG2 THR A  20      37.606  34.979  14.834  1.00 33.78           C  
ATOM    104  N   PHE A  21      36.911  33.903  11.476  1.00 35.91           N  
ATOM    105  CA  PHE A  21      36.360  34.706  10.399  1.00 35.16           C  
ATOM    106  C   PHE A  21      35.069  34.067   9.871  1.00 35.47           C  
ATOM    107  O   PHE A  21      34.032  34.725   9.766  1.00 33.45           O  
ATOM    108  CB  PHE A  21      37.412  34.830   9.285  1.00 35.35           C  
ATOM    109  CG  PHE A  21      36.864  35.324   7.993  1.00 37.88           C  
ATOM    110  CD1 PHE A  21      36.177  36.528   7.932  1.00 38.92           C  
ATOM    111  CD2 PHE A  21      36.999  34.567   6.837  1.00 40.81           C  
ATOM    112  CE1 PHE A  21      35.625  36.973   6.735  1.00 40.72           C  
ATOM    113  CE2 PHE A  21      36.447  35.002   5.628  1.00 41.95           C  
ATOM    114  CZ  PHE A  21      35.759  36.206   5.579  1.00 41.01           C  
ATOM    115  N   LEU A  22      35.129  32.780   9.542  1.00 34.63           N  
ATOM    116  CA  LEU A  22      33.948  32.089   9.031  1.00 35.18           C  
ATOM    117  C   LEU A  22      32.775  32.053  10.019  1.00 35.45           C  
ATOM    118  O   LEU A  22      31.666  32.462   9.680  1.00 34.35           O  
ATOM    119  CB  LEU A  22      34.322  30.672   8.582  1.00 34.18           C  
ATOM    120  CG  LEU A  22      35.215  30.678   7.325  1.00 37.03           C  
ATOM    121  CD1 LEU A  22      35.666  29.250   6.966  1.00 35.72           C  
ATOM    122  CD2 LEU A  22      34.444  31.304   6.170  1.00 33.94           C  
ATOM    123  N   HIS A  23      33.003  31.580  11.239  1.00 36.00           N  
ATOM    124  CA  HIS A  23      31.907  31.540  12.205  1.00 37.60           C  
ATOM    125  C   HIS A  23      31.405  32.936  12.560  1.00 37.85           C  
ATOM    126  O   HIS A  23      30.209  33.128  12.778  1.00 40.69           O  
ATOM    127  CB  HIS A  23      32.322  30.784  13.471  1.00 36.41           C  
ATOM    128  CG  HIS A  23      32.568  29.325  13.239  1.00 38.25           C  
ATOM    129  ND1 HIS A  23      31.599  28.477  12.747  1.00 37.38           N  
ATOM    130  CD2 HIS A  23      33.685  28.572  13.389  1.00 38.82           C  
ATOM    131  CE1 HIS A  23      32.108  27.267  12.598  1.00 39.15           C  
ATOM    132  NE2 HIS A  23      33.372  27.298  12.980  1.00 40.33           N  
ATOM    133  N   THR A  24      32.298  33.917  12.624  1.00 37.37           N  
ATOM    134  CA  THR A  24      31.839  35.265  12.940  1.00 38.87           C  
ATOM    135  C   THR A  24      30.978  35.738  11.788  1.00 38.38           C  
ATOM    136  O   THR A  24      29.979  36.418  11.979  1.00 41.66           O  
ATOM    137  CB  THR A  24      32.997  36.262  13.125  1.00 38.20           C  
ATOM    138  OG1 THR A  24      33.815  35.851  14.226  1.00 38.81           O  
ATOM    139  CG2 THR A  24      32.449  37.648  13.399  1.00 36.86           C  
ATOM    140  N   LEU A  25      31.377  35.365  10.582  1.00 38.81           N  
ATOM    141  CA  LEU A  25      30.635  35.736   9.395  1.00 39.34           C  
ATOM    142  C   LEU A  25      29.239  35.115   9.400  1.00 39.03           C  
ATOM    143  O   LEU A  25      28.256  35.778   9.065  1.00 38.91           O  
ATOM    144  CB  LEU A  25      31.400  35.291   8.156  1.00 42.16           C  
ATOM    145  CG  LEU A  25      30.701  35.534   6.824  1.00 46.08           C  
ATOM    146  CD1 LEU A  25      30.307  37.002   6.725  1.00 48.60           C  
ATOM    147  CD2 LEU A  25      31.627  35.136   5.676  1.00 47.18           C  
ATOM    148  N   ALA A  26      29.147  33.845   9.786  1.00 38.57           N  
ATOM    149  CA  ALA A  26      27.853  33.172   9.832  1.00 39.46           C  
ATOM    150  C   ALA A  26      26.991  33.715  10.970  1.00 41.12           C  
ATOM    151  O   ALA A  26      25.764  33.584  10.943  1.00 41.91           O  
ATOM    152  CB  ALA A  26      28.041  31.674   9.982  1.00 38.68           C  
ATOM    153  N   ALA A  27      27.625  34.325  11.968  1.00 41.48           N  
ATOM    154  CA  ALA A  27      26.887  34.896  13.092  1.00 43.45           C  
ATOM    155  C   ALA A  27      26.198  36.195  12.676  1.00 45.54           C  
ATOM    156  O   ALA A  27      25.178  36.575  13.258  1.00 46.47           O  
ATOM    157  CB  ALA A  27      27.824  35.149  14.269  1.00 40.62           C  
ATOM    158  N   GLN A  28      26.758  36.862  11.664  1.00 46.47           N  
ATOM    159  CA  GLN A  28      26.223  38.122  11.136  1.00 46.25           C  
ATOM    160  C   GLN A  28      25.315  37.912   9.918  1.00 45.24           C  
ATOM    161  O   GLN A  28      24.602  38.829   9.508  1.00 42.43           O  
ATOM    162  CB  GLN A  28      27.369  39.055  10.720  1.00 49.60           C  
ATOM    163  CG  GLN A  28      28.397  39.315  11.801  1.00 52.93           C  
ATOM    164  CD  GLN A  28      27.828  40.113  12.948  1.00 56.44           C  
ATOM    165  OE1 GLN A  28      27.496  41.290  12.795  1.00 57.59           O  
ATOM    166  NE2 GLN A  28      27.700  39.474  14.110  1.00 59.63           N  
ATOM    167  N   TYR A  29      25.358  36.722   9.324  1.00 44.88           N  
ATOM    168  CA  TYR A  29      24.533  36.431   8.153  1.00 44.81           C  
ATOM    169  C   TYR A  29      23.081  36.820   8.450  1.00 45.48           C  
ATOM    170  O   TYR A  29      22.560  36.536   9.525  1.00 45.68           O  
ATOM    171  CB  TYR A  29      24.620  34.944   7.800  1.00 43.95           C  
ATOM    172  CG  TYR A  29      24.176  34.616   6.387  1.00 44.89           C  
ATOM    173  CD1 TYR A  29      24.896  35.075   5.281  1.00 44.36           C  
ATOM    174  CD2 TYR A  29      23.038  33.841   6.154  1.00 43.38           C  
ATOM    175  CE1 TYR A  29      24.493  34.764   3.977  1.00 43.24           C  
ATOM    176  CE2 TYR A  29      22.630  33.528   4.861  1.00 42.78           C  
ATOM    177  CZ  TYR A  29      23.362  33.989   3.775  1.00 44.36           C  
ATOM    178  OH  TYR A  29      22.971  33.653   2.490  1.00 44.43           O  
ATOM    179  N   PRO A  30      22.409  37.483   7.502  1.00 45.99           N  
ATOM    180  CA  PRO A  30      21.020  37.880   7.748  1.00 48.20           C  
ATOM    181  C   PRO A  30      19.985  36.755   7.854  1.00 50.94           C  
ATOM    182  O   PRO A  30      20.140  35.666   7.285  1.00 48.70           O  
ATOM    183  CB  PRO A  30      20.730  38.845   6.599  1.00 48.27           C  
ATOM    184  CG  PRO A  30      21.591  38.329   5.500  1.00 49.29           C  
ATOM    185  CD  PRO A  30      22.883  37.988   6.203  1.00 46.26           C  
ATOM    186  N   GLU A  31      18.927  37.034   8.607  1.00 53.61           N  
ATOM    187  CA  GLU A  31      17.845  36.080   8.800  1.00 56.87           C  
ATOM    188  C   GLU A  31      17.219  35.818   7.437  1.00 56.61           C  
ATOM    189  O   GLU A  31      17.010  34.675   7.049  1.00 56.05           O  
ATOM    190  CB  GLU A  31      16.814  36.662   9.776  1.00 59.63           C  
ATOM    191  CG  GLU A  31      15.529  35.851   9.934  1.00 65.14           C  
ATOM    192  CD  GLU A  31      15.754  34.454  10.493  1.00 68.07           C  
ATOM    193  OE1 GLU A  31      16.907  34.135  10.883  1.00 69.30           O  
ATOM    194  OE2 GLU A  31      14.768  33.682  10.550  1.00 66.06           O  
ATOM    195  N   LYS A  32      16.937  36.900   6.719  1.00 58.02           N  
ATOM    196  CA  LYS A  32      16.362  36.834   5.381  1.00 57.93           C  
ATOM    197  C   LYS A  32      17.388  37.465   4.446  1.00 55.86           C  
ATOM    198  O   LYS A  32      17.318  38.657   4.148  1.00 56.05           O  
ATOM    199  CB  LYS A  32      15.048  37.624   5.326  1.00 60.42           C  
ATOM    200  CG  LYS A  32      13.986  37.136   6.309  1.00 64.89           C  
ATOM    201  CD  LYS A  32      12.729  38.006   6.269  1.00 68.23           C  
ATOM    202  CE  LYS A  32      11.720  37.558   7.324  1.00 71.69           C  
ATOM    203  NZ  LYS A  32      10.486  38.407   7.362  1.00 73.73           N  
ATOM    204  N   PRO A  33      18.362  36.672   3.979  1.00 53.90           N  
ATOM    205  CA  PRO A  33      19.405  37.167   3.079  1.00 53.05           C  
ATOM    206  C   PRO A  33      18.906  37.480   1.678  1.00 52.59           C  
ATOM    207  O   PRO A  33      17.936  36.882   1.213  1.00 52.86           O  
ATOM    208  CB  PRO A  33      20.417  36.032   3.075  1.00 51.30           C  
ATOM    209  CG  PRO A  33      19.528  34.832   3.159  1.00 52.92           C  
ATOM    210  CD  PRO A  33      18.544  35.233   4.243  1.00 52.67           C  
ATOM    211  N   THR A  34      19.575  38.422   1.013  1.00 51.50           N  
ATOM    212  CA  THR A  34      19.223  38.789  -0.349  1.00 52.41           C  
ATOM    213  C   THR A  34      19.796  37.723  -1.268  1.00 53.08           C  
ATOM    214  O   THR A  34      20.581  36.873  -0.846  1.00 53.30           O  
ATOM    215  CB  THR A  34      19.830  40.154  -0.772  1.00 53.91           C  
ATOM    216  OG1 THR A  34      21.260  40.063  -0.762  1.00 54.67           O  
ATOM    217  CG2 THR A  34      19.376  41.273   0.168  1.00 52.19           C  
ATOM    218  N   ARG A  35      19.411  37.777  -2.532  1.00 53.80           N  
ATOM    219  CA  ARG A  35      19.881  36.817  -3.518  1.00 54.55           C  
ATOM    220  C   ARG A  35      21.399  36.891  -3.674  1.00 52.99           C  
ATOM    221  O   ARG A  35      22.059  35.874  -3.895  1.00 52.25           O  
ATOM    222  CB  ARG A  35      19.188  37.099  -4.850  1.00 58.63           C  
ATOM    223  CG  ARG A  35      19.442  36.105  -5.961  1.00 64.17           C  
ATOM    224  CD  ARG A  35      18.425  36.347  -7.070  1.00 70.36           C  
ATOM    225  NE  ARG A  35      18.740  35.649  -8.314  1.00 74.84           N  
ATOM    226  CZ  ARG A  35      17.981  35.701  -9.406  1.00 77.11           C  
ATOM    227  NH1 ARG A  35      16.859  36.418  -9.410  1.00 76.28           N  
ATOM    228  NH2 ARG A  35      18.346  35.045 -10.501  1.00 78.13           N  
ATOM    229  N   GLN A  36      21.957  38.091  -3.543  1.00 51.41           N  
ATOM    230  CA  GLN A  36      23.397  38.249  -3.690  1.00 50.46           C  
ATOM    231  C   GLN A  36      24.163  37.733  -2.470  1.00 47.27           C  
ATOM    232  O   GLN A  36      25.195  37.077  -2.607  1.00 45.79           O  
ATOM    233  CB  GLN A  36      23.758  39.719  -3.946  1.00 53.40           C  
ATOM    234  CG  GLN A  36      25.193  39.899  -4.435  1.00 58.04           C  
ATOM    235  CD  GLN A  36      25.597  41.357  -4.576  1.00 62.94           C  
ATOM    236  OE1 GLN A  36      25.649  42.068  -3.544  1.00 62.25           O  
ATOM    237  NE2 GLN A  36      25.867  41.788  -5.722  1.00 64.91           N  
ATOM    238  N   GLN A  37      23.665  38.037  -1.279  1.00 44.38           N  
ATOM    239  CA  GLN A  37      24.325  37.575  -0.066  1.00 45.36           C  
ATOM    240  C   GLN A  37      24.394  36.050  -0.053  1.00 44.80           C  
ATOM    241  O   GLN A  37      25.378  35.466   0.390  1.00 43.48           O  
ATOM    242  CB  GLN A  37      23.579  38.085   1.164  1.00 45.15           C  
ATOM    243  CG  GLN A  37      23.552  39.589   1.254  1.00 46.02           C  
ATOM    244  CD  GLN A  37      22.688  40.087   2.387  1.00 48.66           C  
ATOM    245  OE1 GLN A  37      21.475  39.773   2.401  1.00 49.30           O  
ATOM    246  NE2 GLN A  37      23.220  40.800   3.262  1.00 48.80           N  
ATOM    247  N   LYS A  38      23.346  35.412  -0.563  1.00 46.54           N  
ATOM    248  CA  LYS A  38      23.292  33.959  -0.620  1.00 46.51           C  
ATOM    249  C   LYS A  38      24.356  33.481  -1.601  1.00 45.77           C  
ATOM    250  O   LYS A  38      25.111  32.548  -1.322  1.00 46.43           O  
ATOM    251  CB  LYS A  38      21.898  33.515  -1.069  1.00 48.70           C  
ATOM    252  CG  LYS A  38      21.659  32.014  -0.980  1.00 54.26           C  
ATOM    253  CD  LYS A  38      20.203  31.638  -1.263  1.00 55.57           C  
ATOM    254  CE  LYS A  38      20.001  30.118  -1.199  1.00 59.25           C  
ATOM    255  NZ  LYS A  38      18.587  29.681  -1.437  1.00 58.87           N  
ATOM    256  N   LYS A  39      24.422  34.149  -2.746  1.00 45.08           N  
ATOM    257  CA  LYS A  39      25.385  33.823  -3.793  1.00 44.45           C  
ATOM    258  C   LYS A  39      26.841  34.008  -3.350  1.00 43.18           C  
ATOM    259  O   LYS A  39      27.704  33.181  -3.652  1.00 41.56           O  
ATOM    260  CB  LYS A  39      25.103  34.695  -5.013  1.00 47.48           C  
ATOM    261  CG  LYS A  39      26.068  34.540  -6.162  1.00 51.67           C  
ATOM    262  CD  LYS A  39      25.707  35.535  -7.256  1.00 55.30           C  
ATOM    263  CE  LYS A  39      26.488  35.291  -8.537  1.00 58.73           C  
ATOM    264  NZ  LYS A  39      26.007  36.193  -9.634  1.00 60.05           N  
ATOM    265  N   ASP A  40      27.118  35.090  -2.632  1.00 42.41           N  
ATOM    266  CA  ASP A  40      28.485  35.341  -2.184  1.00 43.45           C  
ATOM    267  C   ASP A  40      28.951  34.303  -1.179  1.00 43.08           C  
ATOM    268  O   ASP A  40      30.084  33.828  -1.250  1.00 42.77           O  
ATOM    269  CB  ASP A  40      28.608  36.743  -1.582  1.00 43.56           C  
ATOM    270  CG  ASP A  40      28.343  37.831  -2.602  1.00 43.53           C  
ATOM    271  OD1 ASP A  40      28.472  37.542  -3.811  1.00 40.25           O  
ATOM    272  OD2 ASP A  40      28.022  38.969  -2.197  1.00 44.09           O  
ATOM    273  N   VAL A  41      28.074  33.953  -0.246  1.00 41.95           N  
ATOM    274  CA  VAL A  41      28.399  32.961   0.759  1.00 42.67           C  
ATOM    275  C   VAL A  41      28.778  31.642   0.101  1.00 41.51           C  
ATOM    276  O   VAL A  41      29.764  31.015   0.472  1.00 42.50           O  
ATOM    277  CB  VAL A  41      27.207  32.735   1.717  1.00 45.10           C  
ATOM    278  CG1 VAL A  41      27.310  31.367   2.376  1.00 48.29           C  
ATOM    279  CG2 VAL A  41      27.205  33.799   2.777  1.00 44.63           C  
ATOM    280  N   LYS A  42      27.995  31.219  -0.880  1.00 42.38           N  
ATOM    281  CA  LYS A  42      28.293  29.972  -1.565  1.00 43.00           C  
ATOM    282  C   LYS A  42      29.559  30.084  -2.384  1.00 42.18           C  
ATOM    283  O   LYS A  42      30.355  29.147  -2.431  1.00 44.27           O  
ATOM    284  CB  LYS A  42      27.132  29.569  -2.465  1.00 45.55           C  
ATOM    285  CG  LYS A  42      25.846  29.325  -1.705  1.00 50.17           C  
ATOM    286  CD  LYS A  42      24.741  28.843  -2.613  1.00 53.78           C  
ATOM    287  CE  LYS A  42      23.435  28.719  -1.842  1.00 58.84           C  
ATOM    288  NZ  LYS A  42      22.266  28.418  -2.729  1.00 62.42           N  
ATOM    289  N   GLU A  43      29.754  31.228  -3.030  1.00 42.17           N  
ATOM    290  CA  GLU A  43      30.949  31.428  -3.842  1.00 41.94           C  
ATOM    291  C   GLU A  43      32.187  31.448  -2.945  1.00 39.37           C  
ATOM    292  O   GLU A  43      33.246  30.930  -3.308  1.00 39.15           O  
ATOM    293  CB  GLU A  43      30.830  32.732  -4.637  1.00 45.78           C  
ATOM    294  CG  GLU A  43      32.008  33.036  -5.576  1.00 51.37           C  
ATOM    295  CD  GLU A  43      32.343  31.887  -6.535  1.00 54.54           C  
ATOM    296  OE1 GLU A  43      31.411  31.184  -6.983  1.00 56.27           O  
ATOM    297  OE2 GLU A  43      33.541  31.701  -6.857  1.00 54.75           O  
ATOM    298  N   LEU A  44      32.038  32.037  -1.765  1.00 37.78           N  
ATOM    299  CA  LEU A  44      33.129  32.114  -0.800  1.00 38.18           C  
ATOM    300  C   LEU A  44      33.598  30.715  -0.408  1.00 38.13           C  
ATOM    301  O   LEU A  44      34.797  30.450  -0.347  1.00 38.94           O  
ATOM    302  CB  LEU A  44      32.672  32.882   0.445  1.00 37.38           C  
ATOM    303  CG  LEU A  44      33.615  32.851   1.653  1.00 39.61           C  
ATOM    304  CD1 LEU A  44      34.954  33.473   1.289  1.00 39.71           C  
ATOM    305  CD2 LEU A  44      32.984  33.594   2.815  1.00 35.64           C  
ATOM    306  N   MET A  45      32.656  29.813  -0.153  1.00 38.87           N  
ATOM    307  CA  MET A  45      33.024  28.451   0.225  1.00 40.29           C  
ATOM    308  C   MET A  45      33.721  27.731  -0.927  1.00 40.12           C  
ATOM    309  O   MET A  45      34.683  26.994  -0.717  1.00 40.99           O  
ATOM    310  CB  MET A  45      31.793  27.648   0.659  1.00 40.85           C  
ATOM    311  CG  MET A  45      30.993  28.258   1.787  1.00 38.21           C  
ATOM    312  SD  MET A  45      31.997  28.956   3.112  1.00 39.73           S  
ATOM    313  CE  MET A  45      32.623  27.560   3.811  1.00 43.48           C  
ATOM    314  N   THR A  46      33.232  27.940  -2.144  1.00 42.24           N  
ATOM    315  CA  THR A  46      33.836  27.319  -3.324  1.00 43.12           C  
ATOM    316  C   THR A  46      35.259  27.822  -3.479  1.00 41.85           C  
ATOM    317  O   THR A  46      36.180  27.047  -3.717  1.00 41.05           O  
ATOM    318  CB  THR A  46      33.071  27.679  -4.603  1.00 46.08           C  
ATOM    319  OG1 THR A  46      31.726  27.199  -4.503  1.00 49.00           O  
ATOM    320  CG2 THR A  46      33.747  27.060  -5.822  1.00 47.49           C  
ATOM    321  N   ILE A  47      35.432  29.133  -3.352  1.00 41.38           N  
ATOM    322  CA  ILE A  47      36.757  29.722  -3.460  1.00 41.61           C  
ATOM    323  C   ILE A  47      37.675  29.099  -2.412  1.00 41.71           C  
ATOM    324  O   ILE A  47      38.788  28.688  -2.730  1.00 42.10           O  
ATOM    325  CB  ILE A  47      36.697  31.261  -3.300  1.00 42.89           C  
ATOM    326  CG1 ILE A  47      35.943  31.860  -4.498  1.00 41.10           C  
ATOM    327  CG2 ILE A  47      38.106  31.842  -3.198  1.00 39.76           C  
ATOM    328  CD1 ILE A  47      35.792  33.352  -4.455  1.00 39.62           C  
ATOM    329  N   LEU A  48      37.208  29.002  -1.172  1.00 41.86           N  
ATOM    330  CA  LEU A  48      38.016  28.385  -0.114  1.00 43.02           C  
ATOM    331  C   LEU A  48      38.378  26.938  -0.438  1.00 43.16           C  
ATOM    332  O   LEU A  48      39.481  26.486  -0.129  1.00 44.33           O  
ATOM    333  CB  LEU A  48      37.279  28.400   1.230  1.00 43.98           C  
ATOM    334  CG  LEU A  48      37.215  29.704   2.019  1.00 46.22           C  
ATOM    335  CD1 LEU A  48      36.354  29.498   3.248  1.00 48.82           C  
ATOM    336  CD2 LEU A  48      38.608  30.137   2.423  1.00 47.08           C  
ATOM    337  N   SER A  49      37.454  26.206  -1.053  1.00 44.19           N  
ATOM    338  CA  SER A  49      37.721  24.808  -1.388  1.00 45.29           C  
ATOM    339  C   SER A  49      38.909  24.668  -2.346  1.00 46.27           C  
ATOM    340  O   SER A  49      39.539  23.612  -2.408  1.00 46.63           O  
ATOM    341  CB  SER A  49      36.475  24.148  -1.994  1.00 45.34           C  
ATOM    342  OG  SER A  49      36.178  24.672  -3.278  1.00 46.08           O  
ATOM    343  N   ARG A  50      39.213  25.727  -3.094  1.00 46.76           N  
ATOM    344  CA  ARG A  50      40.349  25.695  -4.020  1.00 47.15           C  
ATOM    345  C   ARG A  50      41.560  26.444  -3.475  1.00 46.83           C  
ATOM    346  O   ARG A  50      42.693  26.000  -3.631  1.00 47.12           O  
ATOM    347  CB  ARG A  50      40.001  26.363  -5.347  1.00 46.94           C  
ATOM    348  CG  ARG A  50      38.906  25.735  -6.154  1.00 48.47           C  
ATOM    349  CD  ARG A  50      38.449  26.754  -7.169  1.00 47.73           C  
ATOM    350  NE  ARG A  50      37.273  26.316  -7.894  1.00 50.34           N  
ATOM    351  CZ  ARG A  50      36.370  27.140  -8.408  1.00 51.34           C  
ATOM    352  NH1 ARG A  50      36.512  28.452  -8.268  1.00 50.19           N  
ATOM    353  NH2 ARG A  50      35.325  26.650  -9.062  1.00 52.04           N  
ATOM    354  N   MET A  51      41.300  27.583  -2.837  1.00 47.42           N  
ATOM    355  CA  MET A  51      42.346  28.469  -2.336  1.00 49.64           C  
ATOM    356  C   MET A  51      42.875  28.362  -0.903  1.00 49.48           C  
ATOM    357  O   MET A  51      43.919  28.931  -0.611  1.00 50.73           O  
ATOM    358  CB  MET A  51      41.909  29.919  -2.566  1.00 51.83           C  
ATOM    359  CG  MET A  51      42.668  30.674  -3.648  1.00 58.28           C  
ATOM    360  SD  MET A  51      42.382  30.112  -5.331  1.00 62.09           S  
ATOM    361  CE  MET A  51      43.740  28.923  -5.530  1.00 61.56           C  
ATOM    362  N   TYR A  52      42.183  27.674  -0.003  1.00 48.37           N  
ATOM    363  CA  TYR A  52      42.678  27.588   1.368  1.00 46.88           C  
ATOM    364  C   TYR A  52      44.164  27.214   1.374  1.00 49.37           C  
ATOM    365  O   TYR A  52      44.552  26.174   0.846  1.00 48.65           O  
ATOM    366  CB  TYR A  52      41.868  26.575   2.173  1.00 44.17           C  
ATOM    367  CG  TYR A  52      42.151  26.647   3.654  1.00 40.15           C  
ATOM    368  CD1 TYR A  52      41.847  27.798   4.383  1.00 38.03           C  
ATOM    369  CD2 TYR A  52      42.748  25.583   4.321  1.00 36.34           C  
ATOM    370  CE1 TYR A  52      42.130  27.887   5.741  1.00 37.41           C  
ATOM    371  CE2 TYR A  52      43.044  25.663   5.681  1.00 37.58           C  
ATOM    372  CZ  TYR A  52      42.732  26.816   6.386  1.00 36.78           C  
ATOM    373  OH  TYR A  52      43.035  26.905   7.726  1.00 35.27           O  
ATOM    374  N   PRO A  53      45.014  28.075   1.972  1.00 52.97           N  
ATOM    375  CA  PRO A  53      46.476  27.959   2.102  1.00 54.72           C  
ATOM    376  C   PRO A  53      47.118  26.735   2.754  1.00 56.97           C  
ATOM    377  O   PRO A  53      48.277  26.801   3.144  1.00 59.04           O  
ATOM    378  CB  PRO A  53      46.864  29.243   2.832  1.00 54.83           C  
ATOM    379  CG  PRO A  53      45.817  30.199   2.411  1.00 54.94           C  
ATOM    380  CD  PRO A  53      44.563  29.373   2.506  1.00 53.15           C  
ATOM    381  N   CYS A  54      46.380  25.643   2.913  1.00 59.11           N  
ATOM    382  CA  CYS A  54      46.954  24.410   3.458  1.00 61.64           C  
ATOM    383  C   CYS A  54      46.460  23.320   2.516  1.00 62.94           C  
ATOM    384  O   CYS A  54      45.282  22.975   2.511  1.00 63.30           O  
ATOM    385  CB  CYS A  54      46.518  24.115   4.918  1.00 59.84           C  
ATOM    386  SG  CYS A  54      46.468  22.316   5.278  1.00 63.25           S  
ATOM    387  N   ARG A  55      47.378  22.810   1.702  1.00 65.80           N  
ATOM    388  CA  ARG A  55      47.100  21.776   0.705  1.00 68.30           C  
ATOM    389  C   ARG A  55      46.055  20.716   1.081  1.00 67.28           C  
ATOM    390  O   ARG A  55      44.950  20.713   0.542  1.00 66.75           O  
ATOM    391  CB  ARG A  55      48.416  21.091   0.324  1.00 73.36           C  
ATOM    392  CG  ARG A  55      49.476  22.059  -0.207  1.00 80.09           C  
ATOM    393  CD  ARG A  55      50.885  21.478  -0.099  1.00 84.30           C  
ATOM    394  NE  ARG A  55      51.907  22.424  -0.545  1.00 88.22           N  
ATOM    395  CZ  ARG A  55      53.214  22.268  -0.345  1.00 91.01           C  
ATOM    396  NH1 ARG A  55      53.673  21.201   0.301  1.00 91.09           N  
ATOM    397  NH2 ARG A  55      54.068  23.180  -0.796  1.00 92.23           N  
ATOM    398  N   GLU A  56      46.408  19.812   1.991  1.00 65.85           N  
ATOM    399  CA  GLU A  56      45.495  18.750   2.404  1.00 64.02           C  
ATOM    400  C   GLU A  56      44.173  19.295   2.944  1.00 61.93           C  
ATOM    401  O   GLU A  56      43.098  18.783   2.616  1.00 60.82           O  
ATOM    402  CB  GLU A  56      46.149  17.882   3.479  1.00 65.83           C  
ATOM    403  CG  GLU A  56      46.516  18.665   4.727  1.00 71.60           C  
ATOM    404  CD  GLU A  56      46.737  17.783   5.939  1.00 73.68           C  
ATOM    405  OE1 GLU A  56      47.616  16.895   5.876  1.00 76.03           O  
ATOM    406  OE2 GLU A  56      46.032  17.983   6.954  1.00 74.07           O  
ATOM    407  N   CYS A  57      44.258  20.324   3.780  1.00 59.17           N  
ATOM    408  CA  CYS A  57      43.070  20.928   4.370  1.00 56.57           C  
ATOM    409  C   CYS A  57      42.081  21.352   3.289  1.00 54.93           C  
ATOM    410  O   CYS A  57      40.868  21.193   3.442  1.00 53.90           O  
ATOM    411  CB  CYS A  57      43.439  22.165   5.180  1.00 56.60           C  
ATOM    412  SG  CYS A  57      44.791  22.051   6.399  1.00 59.70           S  
ATOM    413  N   ALA A  58      42.608  21.908   2.203  1.00 53.03           N  
ATOM    414  CA  ALA A  58      41.774  22.369   1.104  1.00 52.64           C  
ATOM    415  C   ALA A  58      41.109  21.206   0.371  1.00 52.18           C  
ATOM    416  O   ALA A  58      39.980  21.333  -0.102  1.00 52.48           O  
ATOM    417  CB  ALA A  58      42.604  23.209   0.133  1.00 52.05           C  
ATOM    418  N   ASP A  59      41.806  20.077   0.270  1.00 52.02           N  
ATOM    419  CA  ASP A  59      41.248  18.908  -0.398  1.00 51.84           C  
ATOM    420  C   ASP A  59      40.078  18.364   0.412  1.00 51.13           C  
ATOM    421  O   ASP A  59      39.026  18.045  -0.142  1.00 50.36           O  
ATOM    422  CB  ASP A  59      42.303  17.813  -0.561  1.00 54.07           C  
ATOM    423  CG  ASP A  59      43.406  18.204  -1.526  1.00 56.69           C  
ATOM    424  OD1 ASP A  59      43.106  18.873  -2.542  1.00 58.76           O  
ATOM    425  OD2 ASP A  59      44.571  17.832  -1.275  1.00 55.96           O  
ATOM    426  N   HIS A  60      40.266  18.270   1.726  1.00 49.93           N  
ATOM    427  CA  HIS A  60      39.221  17.768   2.614  1.00 49.79           C  
ATOM    428  C   HIS A  60      37.992  18.652   2.571  1.00 48.98           C  
ATOM    429  O   HIS A  60      36.863  18.157   2.513  1.00 48.03           O  
ATOM    430  CB  HIS A  60      39.735  17.682   4.048  1.00 49.27           C  
ATOM    431  CG  HIS A  60      40.719  16.576   4.267  1.00 49.80           C  
ATOM    432  ND1 HIS A  60      41.390  16.403   5.459  1.00 50.87           N  
ATOM    433  CD2 HIS A  60      41.142  15.586   3.448  1.00 49.19           C  
ATOM    434  CE1 HIS A  60      42.188  15.354   5.363  1.00 51.46           C  
ATOM    435  NE2 HIS A  60      42.056  14.841   4.152  1.00 51.04           N  
ATOM    436  N   PHE A  61      38.218  19.961   2.597  1.00 48.33           N  
ATOM    437  CA  PHE A  61      37.122  20.921   2.555  1.00 47.83           C  
ATOM    438  C   PHE A  61      36.366  20.745   1.248  1.00 47.61           C  
ATOM    439  O   PHE A  61      35.136  20.834   1.212  1.00 49.25           O  
ATOM    440  CB  PHE A  61      37.658  22.353   2.664  1.00 46.37           C  
ATOM    441  CG  PHE A  61      36.589  23.382   2.890  1.00 44.47           C  
ATOM    442  CD1 PHE A  61      35.883  23.419   4.091  1.00 46.72           C  
ATOM    443  CD2 PHE A  61      36.271  24.303   1.899  1.00 43.20           C  
ATOM    444  CE1 PHE A  61      34.871  24.364   4.298  1.00 45.11           C  
ATOM    445  CE2 PHE A  61      35.267  25.246   2.092  1.00 41.47           C  
ATOM    446  CZ  PHE A  61      34.568  25.276   3.291  1.00 43.85           C  
ATOM    447  N   LYS A  62      37.108  20.485   0.178  1.00 48.11           N  
ATOM    448  CA  LYS A  62      36.526  20.285  -1.146  1.00 49.70           C  
ATOM    449  C   LYS A  62      35.580  19.076  -1.097  1.00 49.50           C  
ATOM    450  O   LYS A  62      34.447  19.144  -1.571  1.00 49.70           O  
ATOM    451  CB  LYS A  62      37.651  20.052  -2.157  1.00 51.02           C  
ATOM    452  CG  LYS A  62      37.350  20.479  -3.578  1.00 53.70           C  
ATOM    453  CD  LYS A  62      38.661  20.637  -4.348  1.00 54.28           C  
ATOM    454  CE  LYS A  62      38.468  21.388  -5.652  1.00 55.95           C  
ATOM    455  NZ  LYS A  62      39.772  21.806  -6.253  1.00 57.35           N  
ATOM    456  N   GLU A  63      36.054  17.978  -0.512  1.00 49.09           N  
ATOM    457  CA  GLU A  63      35.258  16.758  -0.368  1.00 50.01           C  
ATOM    458  C   GLU A  63      34.008  17.062   0.446  1.00 50.22           C  
ATOM    459  O   GLU A  63      32.889  16.811   0.000  1.00 51.04           O  
ATOM    460  CB  GLU A  63      36.063  15.676   0.353  1.00 51.26           C  
ATOM    461  CG  GLU A  63      37.252  15.137  -0.421  1.00 54.70           C  
ATOM    462  CD  GLU A  63      38.239  14.405   0.475  1.00 58.27           C  
ATOM    463  OE1 GLU A  63      37.795  13.599   1.327  1.00 60.06           O  
ATOM    464  OE2 GLU A  63      39.460  14.631   0.319  1.00 58.21           O  
ATOM    465  N   ILE A  64      34.210  17.607   1.644  1.00 49.19           N  
ATOM    466  CA  ILE A  64      33.104  17.953   2.525  1.00 47.64           C  
ATOM    467  C   ILE A  64      32.091  18.833   1.809  1.00 49.23           C  
ATOM    468  O   ILE A  64      30.885  18.631   1.926  1.00 49.61           O  
ATOM    469  CB  ILE A  64      33.609  18.686   3.777  1.00 45.11           C  
ATOM    470  CG1 ILE A  64      34.482  17.744   4.601  1.00 41.83           C  
ATOM    471  CG2 ILE A  64      32.438  19.186   4.602  1.00 43.55           C  
ATOM    472  CD1 ILE A  64      35.232  18.424   5.698  1.00 39.19           C  
ATOM    473  N   LEU A  65      32.587  19.803   1.055  1.00 51.04           N  
ATOM    474  CA  LEU A  65      31.719  20.716   0.325  1.00 52.77           C  
ATOM    475  C   LEU A  65      30.927  19.970  -0.764  1.00 53.91           C  
ATOM    476  O   LEU A  65      29.748  20.246  -0.988  1.00 53.09           O  
ATOM    477  CB  LEU A  65      32.567  21.837  -0.284  1.00 52.10           C  
ATOM    478  CG  LEU A  65      31.848  23.105  -0.737  1.00 52.98           C  
ATOM    479  CD1 LEU A  65      31.061  23.689   0.431  1.00 54.18           C  
ATOM    480  CD2 LEU A  65      32.866  24.112  -1.255  1.00 50.13           C  
ATOM    481  N   ARG A  66      31.576  19.017  -1.430  1.00 56.45           N  
ATOM    482  CA  ARG A  66      30.921  18.232  -2.479  1.00 58.99           C  
ATOM    483  C   ARG A  66      29.688  17.518  -1.939  1.00 58.20           C  
ATOM    484  O   ARG A  66      28.584  17.684  -2.455  1.00 58.48           O  
ATOM    485  CB  ARG A  66      31.875  17.177  -3.043  1.00 62.77           C  
ATOM    486  CG  ARG A  66      33.091  17.725  -3.766  1.00 69.59           C  
ATOM    487  CD  ARG A  66      32.705  18.425  -5.052  1.00 74.57           C  
ATOM    488  NE  ARG A  66      33.869  18.787  -5.858  1.00 77.42           N  
ATOM    489  CZ  ARG A  66      33.799  19.446  -7.010  1.00 79.19           C  
ATOM    490  NH1 ARG A  66      32.621  19.819  -7.494  1.00 79.48           N  
ATOM    491  NH2 ARG A  66      34.907  19.728  -7.681  1.00 80.45           N  
ATOM    492  N   SER A  67      29.890  16.726  -0.891  1.00 57.08           N  
ATOM    493  CA  SER A  67      28.815  15.958  -0.274  1.00 56.08           C  
ATOM    494  C   SER A  67      27.888  16.740   0.655  1.00 54.04           C  
ATOM    495  O   SER A  67      26.797  16.270   0.954  1.00 53.96           O  
ATOM    496  CB  SER A  67      29.402  14.783   0.496  1.00 57.43           C  
ATOM    497  OG  SER A  67      30.266  15.258   1.509  1.00 63.97           O  
ATOM    498  N   ASN A  68      28.316  17.912   1.118  1.00 51.79           N  
ATOM    499  CA  ASN A  68      27.494  18.730   2.011  1.00 50.43           C  
ATOM    500  C   ASN A  68      27.482  20.194   1.552  1.00 49.05           C  
ATOM    501  O   ASN A  68      28.088  21.057   2.185  1.00 48.86           O  
ATOM    502  CB  ASN A  68      28.025  18.658   3.449  1.00 51.41           C  
ATOM    503  CG  ASN A  68      28.190  17.233   3.944  1.00 55.58           C  
ATOM    504  OD1 ASN A  68      27.212  16.542   4.233  1.00 58.91           O  
ATOM    505  ND2 ASN A  68      29.436  16.781   4.032  1.00 57.63           N  
ATOM    506  N   PRO A  69      26.775  20.491   0.454  1.00 47.67           N  
ATOM    507  CA  PRO A  69      26.733  21.873  -0.034  1.00 47.03           C  
ATOM    508  C   PRO A  69      26.283  22.883   1.020  1.00 46.51           C  
ATOM    509  O   PRO A  69      25.471  22.572   1.893  1.00 47.74           O  
ATOM    510  CB  PRO A  69      25.789  21.792  -1.241  1.00 46.52           C  
ATOM    511  CG  PRO A  69      24.911  20.621  -0.932  1.00 46.62           C  
ATOM    512  CD  PRO A  69      25.864  19.623  -0.317  1.00 47.07           C  
ATOM    513  N   ALA A  70      26.823  24.093   0.932  1.00 43.93           N  
ATOM    514  CA  ALA A  70      26.497  25.153   1.877  1.00 43.61           C  
ATOM    515  C   ALA A  70      25.004  25.458   1.955  1.00 41.91           C  
ATOM    516  O   ALA A  70      24.346  25.600   0.936  1.00 41.64           O  
ATOM    517  CB  ALA A  70      27.270  26.432   1.514  1.00 42.46           C  
ATOM    518  N   GLN A  71      24.483  25.561   3.177  1.00 41.94           N  
ATOM    519  CA  GLN A  71      23.070  25.882   3.398  1.00 40.82           C  
ATOM    520  C   GLN A  71      23.055  27.369   3.730  1.00 42.41           C  
ATOM    521  O   GLN A  71      23.301  27.757   4.874  1.00 41.02           O  
ATOM    522  CB  GLN A  71      22.506  25.105   4.593  1.00 39.42           C  
ATOM    523  CG  GLN A  71      22.573  23.586   4.506  1.00 37.09           C  
ATOM    524  CD  GLN A  71      21.347  22.983   3.855  1.00 35.98           C  
ATOM    525  OE1 GLN A  71      20.222  23.318   4.210  1.00 35.37           O  
ATOM    526  NE2 GLN A  71      21.560  22.079   2.908  1.00 33.42           N  
ATOM    527  N   ALA A  72      22.764  28.199   2.734  1.00 43.63           N  
ATOM    528  CA  ALA A  72      22.766  29.645   2.932  1.00 45.08           C  
ATOM    529  C   ALA A  72      21.388  30.281   2.934  1.00 44.36           C  
ATOM    530  O   ALA A  72      21.262  31.496   2.785  1.00 46.20           O  
ATOM    531  CB  ALA A  72      23.636  30.305   1.867  1.00 44.87           C  
ATOM    532  N   GLY A  73      20.362  29.466   3.130  1.00 44.39           N  
ATOM    533  CA  GLY A  73      19.005  29.981   3.129  1.00 42.17           C  
ATOM    534  C   GLY A  73      18.719  31.003   4.205  1.00 41.70           C  
ATOM    535  O   GLY A  73      17.818  31.825   4.047  1.00 43.15           O  
ATOM    536  N   SER A  74      19.472  30.953   5.299  1.00 40.28           N  
ATOM    537  CA  SER A  74      19.276  31.891   6.403  1.00 40.20           C  
ATOM    538  C   SER A  74      20.411  31.791   7.419  1.00 41.24           C  
ATOM    539  O   SER A  74      21.279  30.920   7.314  1.00 42.62           O  
ATOM    540  CB  SER A  74      17.944  31.618   7.107  1.00 38.94           C  
ATOM    541  OG  SER A  74      17.924  30.319   7.680  1.00 39.60           O  
ATOM    542  N   GLN A  75      20.391  32.682   8.402  1.00 41.69           N  
ATOM    543  CA  GLN A  75      21.418  32.717   9.436  1.00 44.04           C  
ATOM    544  C   GLN A  75      21.539  31.389  10.177  1.00 44.46           C  
ATOM    545  O   GLN A  75      22.647  30.912  10.432  1.00 45.50           O  
ATOM    546  CB  GLN A  75      21.116  33.848  10.430  1.00 43.59           C  
ATOM    547  CG  GLN A  75      22.246  34.204  11.405  1.00 43.11           C  
ATOM    548  CD  GLN A  75      22.406  33.213  12.550  1.00 43.51           C  
ATOM    549  OE1 GLN A  75      21.424  32.736  13.116  1.00 47.51           O  
ATOM    550  NE2 GLN A  75      23.644  32.922  12.909  1.00 42.22           N  
ATOM    551  N   GLU A  76      20.404  30.781  10.505  1.00 45.80           N  
ATOM    552  CA  GLU A  76      20.422  29.516  11.230  1.00 46.25           C  
ATOM    553  C   GLU A  76      21.001  28.372  10.412  1.00 45.55           C  
ATOM    554  O   GLU A  76      21.807  27.595  10.922  1.00 48.90           O  
ATOM    555  CB  GLU A  76      19.019  29.142  11.703  1.00 49.39           C  
ATOM    556  CG  GLU A  76      19.034  28.122  12.831  1.00 55.21           C  
ATOM    557  CD  GLU A  76      17.655  27.590  13.176  1.00 57.95           C  
ATOM    558  OE1 GLU A  76      16.719  28.407  13.328  1.00 58.64           O  
ATOM    559  OE2 GLU A  76      17.516  26.352  13.307  1.00 59.81           O  
ATOM    560  N   GLU A  77      20.611  28.264   9.147  1.00 43.86           N  
ATOM    561  CA  GLU A  77      21.117  27.181   8.303  1.00 42.69           C  
ATOM    562  C   GLU A  77      22.612  27.313   8.034  1.00 41.88           C  
ATOM    563  O   GLU A  77      23.331  26.318   7.997  1.00 43.59           O  
ATOM    564  CB  GLU A  77      20.371  27.138   6.960  1.00 42.26           C  
ATOM    565  CG  GLU A  77      18.855  27.091   7.069  1.00 42.50           C  
ATOM    566  CD  GLU A  77      18.176  26.989   5.714  1.00 41.39           C  
ATOM    567  OE1 GLU A  77      18.760  27.457   4.716  1.00 41.47           O  
ATOM    568  OE2 GLU A  77      17.053  26.454   5.647  1.00 42.31           O  
ATOM    569  N   PHE A  78      23.079  28.541   7.839  1.00 41.81           N  
ATOM    570  CA  PHE A  78      24.491  28.785   7.559  1.00 38.68           C  
ATOM    571  C   PHE A  78      25.343  28.546   8.809  1.00 37.54           C  
ATOM    572  O   PHE A  78      26.371  27.883   8.739  1.00 34.70           O  
ATOM    573  CB  PHE A  78      24.669  30.209   7.025  1.00 40.33           C  
ATOM    574  CG  PHE A  78      26.049  30.494   6.502  1.00 42.43           C  
ATOM    575  CD1 PHE A  78      26.756  29.519   5.798  1.00 43.36           C  
ATOM    576  CD2 PHE A  78      26.645  31.733   6.713  1.00 42.02           C  
ATOM    577  CE1 PHE A  78      28.039  29.778   5.315  1.00 43.76           C  
ATOM    578  CE2 PHE A  78      27.925  32.001   6.234  1.00 42.87           C  
ATOM    579  CZ  PHE A  78      28.624  31.023   5.535  1.00 42.14           C  
ATOM    580  N   SER A  79      24.903  29.072   9.950  1.00 38.28           N  
ATOM    581  CA  SER A  79      25.615  28.878  11.216  1.00 40.32           C  
ATOM    582  C   SER A  79      25.768  27.397  11.503  1.00 40.20           C  
ATOM    583  O   SER A  79      26.856  26.926  11.828  1.00 43.38           O  
ATOM    584  CB  SER A  79      24.837  29.476  12.384  1.00 40.98           C  
ATOM    585  OG  SER A  79      24.525  30.825  12.163  1.00 49.19           O  
ATOM    586  N   GLN A  80      24.659  26.669  11.401  1.00 40.26           N  
ATOM    587  CA  GLN A  80      24.655  25.233  11.667  1.00 41.14           C  
ATOM    588  C   GLN A  80      25.553  24.512  10.680  1.00 41.61           C  
ATOM    589  O   GLN A  80      26.464  23.780  11.073  1.00 42.93           O  
ATOM    590  CB  GLN A  80      23.233  24.679  11.564  1.00 42.39           C  
ATOM    591  CG  GLN A  80      22.259  25.262  12.577  1.00 42.88           C  
ATOM    592  CD  GLN A  80      22.609  24.876  13.997  1.00 47.15           C  
ATOM    593  OE1 GLN A  80      22.532  25.703  14.909  1.00 50.30           O  
ATOM    594  NE2 GLN A  80      22.987  23.612  14.200  1.00 47.02           N  
ATOM    595  N   TRP A  81      25.299  24.728   9.394  1.00 40.64           N  
ATOM    596  CA  TRP A  81      26.084  24.089   8.354  1.00 39.70           C  
ATOM    597  C   TRP A  81      27.583  24.264   8.598  1.00 39.88           C  
ATOM    598  O   TRP A  81      28.348  23.300   8.542  1.00 39.53           O  
ATOM    599  CB  TRP A  81      25.722  24.669   6.983  1.00 40.27           C  
ATOM    600  CG  TRP A  81      26.572  24.110   5.888  1.00 39.37           C  
ATOM    601  CD1 TRP A  81      26.435  22.900   5.281  1.00 38.59           C  
ATOM    602  CD2 TRP A  81      27.750  24.705   5.335  1.00 38.88           C  
ATOM    603  NE1 TRP A  81      27.460  22.695   4.382  1.00 37.28           N  
ATOM    604  CE2 TRP A  81      28.282  23.789   4.397  1.00 39.32           C  
ATOM    605  CE3 TRP A  81      28.409  25.922   5.542  1.00 39.25           C  
ATOM    606  CZ2 TRP A  81      29.443  24.052   3.667  1.00 40.13           C  
ATOM    607  CZ3 TRP A  81      29.564  26.185   4.818  1.00 40.94           C  
ATOM    608  CH2 TRP A  81      30.070  25.251   3.890  1.00 42.73           C  
ATOM    609  N   LEU A  82      27.999  25.495   8.876  1.00 40.39           N  
ATOM    610  CA  LEU A  82      29.414  25.782   9.110  1.00 40.43           C  
ATOM    611  C   LEU A  82      29.936  25.029  10.332  1.00 39.54           C  
ATOM    612  O   LEU A  82      31.099  24.640  10.380  1.00 38.33           O  
ATOM    613  CB  LEU A  82      29.617  27.289   9.288  1.00 41.91           C  
ATOM    614  CG  LEU A  82      31.037  27.829   9.109  1.00 43.21           C  
ATOM    615  CD1 LEU A  82      31.621  27.372   7.778  1.00 40.69           C  
ATOM    616  CD2 LEU A  82      30.993  29.342   9.175  1.00 42.32           C  
ATOM    617  N   CYS A  83      29.067  24.824  11.318  1.00 39.36           N  
ATOM    618  CA  CYS A  83      29.444  24.102  12.529  1.00 38.32           C  
ATOM    619  C   CYS A  83      29.602  22.617  12.227  1.00 37.63           C  
ATOM    620  O   CYS A  83      30.507  21.957  12.755  1.00 36.46           O  
ATOM    621  CB  CYS A  83      28.387  24.311  13.616  1.00 38.94           C  
ATOM    622  SG  CYS A  83      28.605  23.304  15.121  1.00 44.54           S  
ATOM    623  N   HIS A  84      28.734  22.090  11.362  1.00 37.91           N  
ATOM    624  CA  HIS A  84      28.805  20.671  11.000  1.00 37.65           C  
ATOM    625  C   HIS A  84      30.058  20.422  10.190  1.00 36.89           C  
ATOM    626  O   HIS A  84      30.725  19.397  10.342  1.00 37.67           O  
ATOM    627  CB  HIS A  84      27.574  20.242  10.191  1.00 36.83           C  
ATOM    628  CG  HIS A  84      26.296  20.304  10.965  1.00 34.15           C  
ATOM    629  ND1 HIS A  84      26.099  19.597  12.130  1.00 36.09           N  
ATOM    630  CD2 HIS A  84      25.181  21.050  10.785  1.00 34.06           C  
ATOM    631  CE1 HIS A  84      24.924  19.914  12.645  1.00 34.92           C  
ATOM    632  NE2 HIS A  84      24.348  20.795  11.848  1.00 36.39           N  
ATOM    633  N   VAL A  85      30.375  21.368   9.317  1.00 37.05           N  
ATOM    634  CA  VAL A  85      31.563  21.245   8.496  1.00 36.57           C  
ATOM    635  C   VAL A  85      32.774  21.244   9.413  1.00 36.43           C  
ATOM    636  O   VAL A  85      33.638  20.380   9.310  1.00 37.69           O  
ATOM    637  CB  VAL A  85      31.647  22.400   7.483  1.00 38.30           C  
ATOM    638  CG1 VAL A  85      33.077  22.555   6.966  1.00 38.07           C  
ATOM    639  CG2 VAL A  85      30.689  22.121   6.331  1.00 33.85           C  
ATOM    640  N   HIS A  86      32.822  22.199  10.333  1.00 36.53           N  
ATOM    641  CA  HIS A  86      33.937  22.279  11.267  1.00 37.13           C  
ATOM    642  C   HIS A  86      34.049  20.980  12.078  1.00 38.17           C  
ATOM    643  O   HIS A  86      35.153  20.525  12.381  1.00 40.88           O  
ATOM    644  CB  HIS A  86      33.754  23.478  12.196  1.00 35.57           C  
ATOM    645  CG  HIS A  86      34.984  23.849  12.964  1.00 34.75           C  
ATOM    646  ND1 HIS A  86      35.068  24.999  13.723  1.00 32.10           N  
ATOM    647  CD2 HIS A  86      36.185  23.236  13.079  1.00 34.51           C  
ATOM    648  CE1 HIS A  86      36.268  25.078  14.268  1.00 32.16           C  
ATOM    649  NE2 HIS A  86      36.967  24.021  13.892  1.00 32.56           N  
ATOM    650  N   ASN A  87      32.917  20.370  12.420  1.00 37.47           N  
ATOM    651  CA  ASN A  87      32.961  19.121  13.190  1.00 37.50           C  
ATOM    652  C   ASN A  87      33.550  17.946  12.413  1.00 37.11           C  
ATOM    653  O   ASN A  87      34.244  17.108  12.981  1.00 36.89           O  
ATOM    654  CB  ASN A  87      31.575  18.751  13.720  1.00 34.51           C  
ATOM    655  CG  ASN A  87      31.236  19.493  14.984  1.00 33.09           C  
ATOM    656  OD1 ASN A  87      32.117  19.782  15.784  1.00 33.95           O  
ATOM    657  ND2 ASN A  87      29.964  19.788  15.187  1.00 33.74           N  
ATOM    658  N   THR A  88      33.277  17.880  11.115  1.00 37.02           N  
ATOM    659  CA  THR A  88      33.828  16.804  10.308  1.00 37.12           C  
ATOM    660  C   THR A  88      35.352  16.886  10.372  1.00 40.12           C  
ATOM    661  O   THR A  88      36.037  15.866  10.426  1.00 40.86           O  
ATOM    662  CB  THR A  88      33.364  16.926   8.856  1.00 37.31           C  
ATOM    663  OG1 THR A  88      31.934  16.837   8.814  1.00 40.34           O  
ATOM    664  CG2 THR A  88      33.966  15.829   8.004  1.00 33.92           C  
ATOM    665  N   VAL A  89      35.885  18.108  10.371  1.00 42.07           N  
ATOM    666  CA  VAL A  89      37.323  18.286  10.459  1.00 42.57           C  
ATOM    667  C   VAL A  89      37.764  17.891  11.872  1.00 44.65           C  
ATOM    668  O   VAL A  89      38.725  17.139  12.033  1.00 44.88           O  
ATOM    669  CB  VAL A  89      37.733  19.746  10.160  1.00 43.68           C  
ATOM    670  CG1 VAL A  89      39.242  19.906  10.318  1.00 42.23           C  
ATOM    671  CG2 VAL A  89      37.318  20.121   8.736  1.00 41.78           C  
ATOM    672  N   ASN A  90      37.049  18.376  12.889  1.00 45.59           N  
ATOM    673  CA  ASN A  90      37.374  18.033  14.276  1.00 46.90           C  
ATOM    674  C   ASN A  90      37.447  16.516  14.461  1.00 49.39           C  
ATOM    675  O   ASN A  90      38.410  15.994  15.023  1.00 50.20           O  
ATOM    676  CB  ASN A  90      36.329  18.589  15.250  1.00 45.30           C  
ATOM    677  CG  ASN A  90      36.418  20.097  15.421  1.00 43.98           C  
ATOM    678  OD1 ASN A  90      37.481  20.692  15.268  1.00 42.67           O  
ATOM    679  ND2 ASN A  90      35.301  20.713  15.768  1.00 40.83           N  
ATOM    680  N   ARG A  91      36.422  15.817  13.986  1.00 51.18           N  
ATOM    681  CA  ARG A  91      36.363  14.365  14.100  1.00 53.41           C  
ATOM    682  C   ARG A  91      37.546  13.699  13.411  1.00 54.20           C  
ATOM    683  O   ARG A  91      38.179  12.809  13.976  1.00 56.31           O  
ATOM    684  CB  ARG A  91      35.066  13.834  13.487  1.00 55.41           C  
ATOM    685  CG  ARG A  91      34.708  12.420  13.920  1.00 59.14           C  
ATOM    686  CD  ARG A  91      33.566  11.863  13.084  1.00 61.79           C  
ATOM    687  NE  ARG A  91      32.541  12.870  12.833  1.00 64.26           N  
ATOM    688  CZ  ARG A  91      31.790  13.431  13.774  1.00 65.45           C  
ATOM    689  NH1 ARG A  91      31.937  13.081  15.048  1.00 66.27           N  
ATOM    690  NH2 ARG A  91      30.902  14.357  13.441  1.00 63.95           N  
ATOM    691  N   SER A  92      37.849  14.126  12.192  1.00 53.72           N  
ATOM    692  CA  SER A  92      38.957  13.527  11.460  1.00 54.56           C  
ATOM    693  C   SER A  92      40.289  13.697  12.178  1.00 53.11           C  
ATOM    694  O   SER A  92      41.204  12.894  12.004  1.00 52.96           O  
ATOM    695  CB  SER A  92      39.039  14.114  10.047  1.00 55.89           C  
ATOM    696  OG  SER A  92      37.878  13.766   9.301  1.00 59.45           O  
ATOM    697  N   LEU A  93      40.382  14.734  13.001  1.00 52.39           N  
ATOM    698  CA  LEU A  93      41.602  15.033  13.741  1.00 50.27           C  
ATOM    699  C   LEU A  93      41.584  14.557  15.188  1.00 50.74           C  
ATOM    700  O   LEU A  93      42.505  14.855  15.951  1.00 50.72           O  
ATOM    701  CB  LEU A  93      41.855  16.538  13.732  1.00 49.97           C  
ATOM    702  CG  LEU A  93      42.213  17.176  12.392  1.00 47.86           C  
ATOM    703  CD1 LEU A  93      42.406  18.679  12.582  1.00 43.87           C  
ATOM    704  CD2 LEU A  93      43.478  16.522  11.851  1.00 44.64           C  
ATOM    705  N   GLY A  94      40.536  13.834  15.574  1.00 50.56           N  
ATOM    706  CA  GLY A  94      40.450  13.349  16.941  1.00 49.20           C  
ATOM    707  C   GLY A  94      40.291  14.467  17.956  1.00 48.89           C  
ATOM    708  O   GLY A  94      40.860  14.420  19.048  1.00 49.26           O  
ATOM    709  N   LYS A  95      39.519  15.486  17.590  1.00 48.60           N  
ATOM    710  CA  LYS A  95      39.272  16.618  18.476  1.00 48.33           C  
ATOM    711  C   LYS A  95      37.819  16.579  18.934  1.00 48.50           C  
ATOM    712  O   LYS A  95      36.996  15.875  18.345  1.00 48.77           O  
ATOM    713  CB  LYS A  95      39.531  17.935  17.743  1.00 48.64           C  
ATOM    714  CG  LYS A  95      40.988  18.260  17.472  1.00 49.16           C  
ATOM    715  CD  LYS A  95      41.082  19.570  16.695  1.00 51.80           C  
ATOM    716  CE  LYS A  95      42.473  20.167  16.751  1.00 55.51           C  
ATOM    717  NZ  LYS A  95      42.867  20.546  18.145  1.00 55.18           N  
ATOM    718  N   LEU A  96      37.505  17.329  19.985  1.00 47.18           N  
ATOM    719  CA  LEU A  96      36.141  17.384  20.497  1.00 47.31           C  
ATOM    720  C   LEU A  96      35.193  17.864  19.394  1.00 48.81           C  
ATOM    721  O   LEU A  96      35.600  18.615  18.502  1.00 49.93           O  
ATOM    722  CB  LEU A  96      36.074  18.342  21.686  1.00 46.50           C  
ATOM    723  CG  LEU A  96      36.723  17.887  23.000  1.00 46.70           C  
ATOM    724  CD1 LEU A  96      36.980  19.087  23.896  1.00 44.92           C  
ATOM    725  CD2 LEU A  96      35.809  16.878  23.696  1.00 45.09           C  
ATOM    726  N   VAL A  97      33.942  17.411  19.451  1.00 48.39           N  
ATOM    727  CA  VAL A  97      32.915  17.797  18.483  1.00 46.89           C  
ATOM    728  C   VAL A  97      31.969  18.753  19.206  1.00 47.85           C  
ATOM    729  O   VAL A  97      31.406  18.421  20.249  1.00 48.23           O  
ATOM    730  CB  VAL A  97      32.150  16.556  17.955  1.00 47.84           C  
ATOM    731  CG1 VAL A  97      30.870  16.971  17.240  1.00 43.98           C  
ATOM    732  CG2 VAL A  97      33.050  15.779  16.997  1.00 45.80           C  
ATOM    733  N   PHE A  98      31.817  19.943  18.637  1.00 46.35           N  
ATOM    734  CA  PHE A  98      31.014  21.021  19.201  1.00 44.61           C  
ATOM    735  C   PHE A  98      29.519  20.845  18.971  1.00 43.25           C  
ATOM    736  O   PHE A  98      29.104  20.471  17.881  1.00 44.57           O  
ATOM    737  CB  PHE A  98      31.502  22.341  18.573  1.00 45.10           C  
ATOM    738  CG  PHE A  98      30.893  23.577  19.166  1.00 46.38           C  
ATOM    739  CD1 PHE A  98      31.531  24.258  20.198  1.00 48.21           C  
ATOM    740  CD2 PHE A  98      29.692  24.084  18.673  1.00 47.65           C  
ATOM    741  CE1 PHE A  98      30.982  25.430  20.727  1.00 48.80           C  
ATOM    742  CE2 PHE A  98      29.134  25.257  19.198  1.00 47.04           C  
ATOM    743  CZ  PHE A  98      29.779  25.927  20.221  1.00 48.09           C  
ATOM    744  N   PRO A  99      28.690  21.101  20.003  1.00 42.90           N  
ATOM    745  CA  PRO A  99      27.230  20.970  19.874  1.00 42.11           C  
ATOM    746  C   PRO A  99      26.708  22.175  19.103  1.00 44.69           C  
ATOM    747  O   PRO A  99      26.641  23.289  19.628  1.00 43.31           O  
ATOM    748  CB  PRO A  99      26.752  20.949  21.322  1.00 41.13           C  
ATOM    749  CG  PRO A  99      27.770  21.801  22.027  1.00 41.35           C  
ATOM    750  CD  PRO A  99      29.074  21.356  21.406  1.00 41.50           C  
ATOM    751  N   CYS A 100      26.329  21.942  17.852  1.00 46.45           N  
ATOM    752  CA  CYS A 100      25.875  23.020  16.988  1.00 48.61           C  
ATOM    753  C   CYS A 100      24.636  23.787  17.402  1.00 50.94           C  
ATOM    754  O   CYS A 100      24.157  24.632  16.649  1.00 51.53           O  
ATOM    755  CB  CYS A 100      25.705  22.502  15.567  1.00 44.97           C  
ATOM    756  SG  CYS A 100      27.239  21.812  14.882  1.00 42.06           S  
ATOM    757  N   GLU A 101      24.118  23.511  18.588  1.00 53.51           N  
ATOM    758  CA  GLU A 101      22.937  24.222  19.058  1.00 58.64           C  
ATOM    759  C   GLU A 101      23.416  25.417  19.846  1.00 59.71           C  
ATOM    760  O   GLU A 101      22.650  26.323  20.156  1.00 60.48           O  
ATOM    761  CB  GLU A 101      22.103  23.332  19.963  1.00 61.99           C  
ATOM    762  CG  GLU A 101      21.553  22.116  19.276  1.00 65.00           C  
ATOM    763  CD  GLU A 101      21.305  20.994  20.254  1.00 68.36           C  
ATOM    764  OE1 GLU A 101      20.550  21.202  21.235  1.00 68.18           O  
ATOM    765  OE2 GLU A 101      21.878  19.906  20.036  1.00 69.73           O  
ATOM    766  N   ARG A 102      24.703  25.399  20.162  1.00 61.87           N  
ATOM    767  CA  ARG A 102      25.331  26.462  20.923  1.00 62.56           C  
ATOM    768  C   ARG A 102      26.180  27.387  20.063  1.00 62.37           C  
ATOM    769  O   ARG A 102      26.809  28.294  20.609  1.00 64.93           O  
ATOM    770  CB  ARG A 102      26.236  25.880  22.017  1.00 65.94           C  
ATOM    771  CG  ARG A 102      25.551  25.098  23.138  1.00 68.59           C  
ATOM    772  CD  ARG A 102      26.621  24.480  24.046  1.00 72.25           C  
ATOM    773  NE  ARG A 102      26.078  23.774  25.206  1.00 75.73           N  
ATOM    774  CZ  ARG A 102      26.793  22.982  26.007  1.00 76.76           C  
ATOM    775  NH1 ARG A 102      28.088  22.784  25.776  1.00 75.76           N  
ATOM    776  NH2 ARG A 102      26.216  22.392  27.047  1.00 77.36           N  
ATOM    777  N   VAL A 103      26.226  27.181  18.743  1.00 59.60           N  
ATOM    778  CA  VAL A 103      27.059  28.064  17.915  1.00 56.96           C  
ATOM    779  C   VAL A 103      26.768  29.522  18.185  1.00 55.21           C  
ATOM    780  O   VAL A 103      27.690  30.312  18.345  1.00 55.19           O  
ATOM    781  CB  VAL A 103      26.897  27.842  16.384  1.00 56.31           C  
ATOM    782  CG1 VAL A 103      28.020  26.964  15.873  1.00 55.29           C  
ATOM    783  CG2 VAL A 103      25.547  27.253  16.069  1.00 56.73           C  
ATOM    784  N   ASP A 104      25.486  29.877  18.240  1.00 54.46           N  
ATOM    785  CA  ASP A 104      25.099  31.260  18.492  1.00 54.56           C  
ATOM    786  C   ASP A 104      25.552  31.749  19.864  1.00 55.29           C  
ATOM    787  O   ASP A 104      25.668  32.953  20.093  1.00 55.91           O  
ATOM    788  CB  ASP A 104      23.584  31.434  18.353  1.00 51.49           C  
ATOM    789  CG  ASP A 104      23.124  31.376  16.915  1.00 50.41           C  
ATOM    790  OD1 ASP A 104      23.979  31.420  16.010  1.00 52.22           O  
ATOM    791  OD2 ASP A 104      21.907  31.296  16.677  1.00 49.91           O  
ATOM    792  N   ALA A 105      25.811  30.819  20.773  1.00 55.27           N  
ATOM    793  CA  ALA A 105      26.269  31.191  22.105  1.00 56.90           C  
ATOM    794  C   ALA A 105      27.784  31.404  22.060  1.00 57.07           C  
ATOM    795  O   ALA A 105      28.328  32.223  22.799  1.00 57.84           O  
ATOM    796  CB  ALA A 105      25.912  30.093  23.114  1.00 57.84           C  
ATOM    797  N   ARG A 106      28.452  30.663  21.179  1.00 56.08           N  
ATOM    798  CA  ARG A 106      29.898  30.764  21.016  1.00 55.57           C  
ATOM    799  C   ARG A 106      30.293  31.908  20.065  1.00 55.11           C  
ATOM    800  O   ARG A 106      31.354  32.520  20.227  1.00 54.36           O  
ATOM    801  CB  ARG A 106      30.456  29.428  20.502  1.00 55.40           C  
ATOM    802  CG  ARG A 106      31.926  29.465  20.105  1.00 55.66           C  
ATOM    803  CD  ARG A 106      32.852  29.642  21.303  1.00 56.27           C  
ATOM    804  NE  ARG A 106      34.240  29.864  20.895  1.00 55.42           N  
ATOM    805  CZ  ARG A 106      34.720  31.035  20.477  1.00 56.02           C  
ATOM    806  NH1 ARG A 106      33.929  32.099  20.416  1.00 54.67           N  
ATOM    807  NH2 ARG A 106      35.993  31.143  20.112  1.00 55.93           N  
ATOM    808  N   TRP A 107      29.445  32.193  19.077  1.00 54.54           N  
ATOM    809  CA  TRP A 107      29.714  33.269  18.122  1.00 54.22           C  
ATOM    810  C   TRP A 107      28.515  34.213  18.022  1.00 56.49           C  
ATOM    811  O   TRP A 107      27.486  33.864  17.442  1.00 58.53           O  
ATOM    812  CB  TRP A 107      30.033  32.701  16.731  1.00 49.07           C  
ATOM    813  CG  TRP A 107      31.088  31.629  16.722  1.00 46.94           C  
ATOM    814  CD1 TRP A 107      30.882  30.277  16.715  1.00 45.30           C  
ATOM    815  CD2 TRP A 107      32.518  31.816  16.746  1.00 45.17           C  
ATOM    816  NE1 TRP A 107      32.089  29.615  16.735  1.00 43.16           N  
ATOM    817  CE2 TRP A 107      33.107  30.532  16.753  1.00 43.11           C  
ATOM    818  CE3 TRP A 107      33.356  32.943  16.764  1.00 43.84           C  
ATOM    819  CZ2 TRP A 107      34.494  30.341  16.773  1.00 42.05           C  
ATOM    820  CZ3 TRP A 107      34.737  32.749  16.785  1.00 40.66           C  
ATOM    821  CH2 TRP A 107      35.289  31.459  16.788  1.00 39.45           C  
ATOM    822  N   GLY A 108      28.646  35.409  18.585  1.00 58.96           N  
ATOM    823  CA  GLY A 108      27.551  36.362  18.539  1.00 61.63           C  
ATOM    824  C   GLY A 108      27.674  37.377  17.414  1.00 64.06           C  
ATOM    825  O   GLY A 108      28.722  37.379  16.722  1.00 65.18           O  
TER     826      GLY A 108                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
