
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  245 ( 1913),  selected  245 , name 1yjx_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 1yjx_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_A      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    -       -      S       6           -
LGA    -       -      A       7           -
LGA    A     3_A      R       8          4.176
LGA    Y     4_A      F       9          2.038
LGA    K     5_A      A      10          1.281
LGA    L     6_A      L      11          1.062
LGA    V     7_A      T      12          0.655
LGA    L     8_A      V      13          0.637
LGA    I     9_A      V      14          0.440
LGA    R    10_A      R      15          0.785
LGA    H    11_A      H      16          1.008
LGA    G    12_A      G      17          2.341
LGA    E    13_A      E      18          1.453
LGA    S    14_A      T      19          1.235
LGA    A    15_A      R      20          1.527
LGA    W    16_A      F      21          1.152
LGA    N    17_A      N      22          1.220
LGA    L    18_A      K      23          1.763
LGA    E    19_A      E      24          2.644
LGA    N    20_A      K      25          2.143
LGA    R    21_A      I      26          1.059
LGA    F    22_A      I      27          0.788
LGA    S    23_A      Q      28          1.013
LGA    G    24_A      G      29          0.911
LGA    W    25_A      Q      30          0.212
LGA    Y    26_A      G      31          1.948
LGA    -       -      V      32           -
LGA    D    27_A      D      33          0.858
LGA    A    28_A      E      34          1.363
LGA    D    29_A      P      35          1.251
LGA    L    30_A      L      36          1.301
LGA    S    31_A      S      37          1.488
LGA    P    32_A      E      38          1.368
LGA    A    33_A      T      39          1.218
LGA    G    34_A      G      40          1.726
LGA    H    35_A      F      41          1.791
LGA    E    36_A      K      42          1.407
LGA    E    37_A      Q      43          1.399
LGA    A    38_A      A      44          1.596
LGA    K    39_A      A      45          1.495
LGA    R    40_A      A      46          1.405
LGA    G    41_A      A      47          1.523
LGA    G    42_A      G      48          1.719
LGA    Q    43_A      I      49          1.529
LGA    A    44_A      F      50          1.417
LGA    L    45_A      L      51          1.341
LGA    R    46_A      N      52          1.705
LGA    D    47_A      -       -           -
LGA    A    48_A      -       -           -
LGA    G    49_A      N      53          2.405
LGA    Y    50_A      V      54          1.123
LGA    E    51_A      K      55          1.045
LGA    F    52_A      F      56          1.163
LGA    D    53_A      T      57          1.526
LGA    I    54_A      H      58          1.450
LGA    C    55_A      A      59          0.964
LGA    F    56_A      F      60          0.956
LGA    T    57_A      S      61          0.995
LGA    S    58_A      S      62          0.902
LGA    V    59_A      D      63          1.032
LGA    Q    60_A      L      64          0.604
LGA    K    61_A      M      65          0.668
LGA    R    62_A      R      66          0.671
LGA    A    63_A      T      67          0.721
LGA    I    64_A      K      68          0.926
LGA    R    65_A      Q      69          0.807
LGA    T    66_A      T      70          0.820
LGA    L    67_A      M      71          0.691
LGA    W    68_A      H      72          0.771
LGA    T    69_A      G      73          0.678
LGA    V    70_A      I      74          0.734
LGA    L    71_A      L      75          0.807
LGA    D    72_A      E      76          1.141
LGA    A    73_A      R      77          1.799
LGA    I    74_A      S      78          1.403
LGA    D    75_A      K      79          3.680
LGA    -       -      F      80           -
LGA    Q    76_A      C      81          1.734
LGA    M    77_A      K      82          2.791
LGA    W    78_A      D      83          1.364
LGA    L    79_A      M      84          0.995
LGA    P    80_A      T      85          1.720
LGA    V    81_A      V      86          1.352
LGA    V    82_A      K      87          1.072
LGA    R    83_A      Y      88          0.790
LGA    T    84_A      D      89          1.567
LGA    W    85_A      S      90          1.444
LGA    R    86_A      R      91          1.194
LGA    L    87_A      L      92          0.767
LGA    N    88_A      R      93          0.473
LGA    E    89_A      E      94          0.283
LGA    R    90_A      R      95          0.240
LGA    H    91_A      K      96          0.223
LGA    Y    92_A      Y      97          0.399
LGA    G    93_A      G      98          1.093
LGA    G    94_A      V      99          1.111
LGA    L    95_A      V     100          1.040
LGA    T    96_A      E     101          0.787
LGA    G    97_A      G     102          1.061
LGA    L    98_A      K     103          0.998
LGA    N    99_A      A     104          1.467
LGA    K   100_A      L     105          1.801
LGA    A   101_A      S     106          3.093
LGA    E   102_A      E     107          4.626
LGA    T   103_A      L     108          4.693
LGA    A   104_A      R     109          4.083
LGA    A   105_A      -       -           -
LGA    K   106_A      A     110          4.997
LGA    H   107_A      M     111          3.972
LGA    G   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    Q   111_A      A     112          2.104
LGA    V   112_A      K     113          5.220
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    K   113_A      E     117           #
LGA    I   114_A      E     118          1.967
LGA    W   115_A      C     119          3.872
LGA    R   116_A      P     120          3.077
LGA    R   117_A      -       -           -
LGA    S   118_A      V     121          1.591
LGA    Y   119_A      -       -           -
LGA    D   120_A      -       -           -
LGA    V   121_A      F     122          3.570
LGA    P   122_A      T     123          1.702
LGA    P   123_A      P     124          1.505
LGA    P   124_A      P     125          2.211
LGA    P   125_A      G     126          2.682
LGA    M   126_A      -       -           -
LGA    E   127_A      -       -           -
LGA    P   128_A      -       -           -
LGA    D   129_A      -       -           -
LGA    H   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    F   132_A      -       -           -
LGA    Y   133_A      -       -           -
LGA    S   134_A      -       -           -
LGA    N   135_A      -       -           -
LGA    I   136_A      -       -           -
LGA    S   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    D   139_A      -       -           -
LGA    R   140_A      -       -           -
LGA    R   141_A      -       -           -
LGA    Y   142_A      -       -           -
LGA    A   143_A      -       -           -
LGA    D   144_A      -       -           -
LGA    L   145_A      -       -           -
LGA    T   146_A      -       -           -
LGA    E   147_A      -       -           -
LGA    D   148_A      -       -           -
LGA    Q   149_A      -       -           -
LGA    L   150_A      -       -           -
LGA    P   151_A      -       -           -
LGA    S   152_A      -       -           -
LGA    C   153_A      G     127          1.521
LGA    E   154_A      E     128          0.497
LGA    S   155_A      T     129          1.467
LGA    L   156_A      L     130          1.741
LGA    K   157_A      D     131          1.420
LGA    D   158_A      Q     132          1.112
LGA    T   159_A      V     133          1.364
LGA    I   160_A      K     134          1.582
LGA    A   161_A      M     135          1.673
LGA    R   162_A      R     136          2.587
LGA    A   163_A      G     137          3.288
LGA    L   164_A      I     138          2.038
LGA    P   165_A      D     139          1.418
LGA    F   166_A      F     140          2.532
LGA    W   167_A      F     141          2.258
LGA    N   168_A      E     142          1.006
LGA    E   169_A      F     143          2.234
LGA    E   170_A      -       -           -
LGA    I   171_A      L     144          1.157
LGA    V   172_A      C     145          1.236
LGA    P   173_A      Q     146          2.133
LGA    Q   174_A      L     147          3.158
LGA    I   175_A      I     148          3.370
LGA    K   176_A      L     149          2.979
LGA    -       -      K     150           -
LGA    E   177_A      E     151          3.853
LGA    G   178_A      A     152          5.110
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    -       -      A     195           -
LGA    K   179_A      A     196          2.622
LGA    R   180_A      S     197          1.739
LGA    V   181_A      V     198          0.860
LGA    L   182_A      L     199          0.689
LGA    I   183_A      V     200          0.523
LGA    A   184_A      V     201          0.448
LGA    A   185_A      S     202          0.578
LGA    H   186_A      H     203          0.672
LGA    G   187_A      G     204          1.202
LGA    N   188_A      A     205          2.103
LGA    S   189_A      Y     206          2.043
LGA    L   190_A      M     207          1.905
LGA    R   191_A      R     208          2.500
LGA    G   192_A      S     209          3.361
LGA    I   193_A      L     210          2.728
LGA    V   194_A      F     211          1.764
LGA    K   195_A      D     212          2.290
LGA    H   196_A      Y     213          2.606
LGA    L   197_A      F     214          2.510
LGA    E   198_A      L     215          2.578
LGA    G   199_A      -       -           -
LGA    L   200_A      T     216          1.705
LGA    S   201_A      D     217           #
LGA    E   202_A      L     218           -
LGA    E   203_A      K     219           -
LGA    -       -      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    A   204_A      R     228           #
LGA    I   205_A      -       -           -
LGA    M   206_A      -       -           -
LGA    E   207_A      S     229          4.808
LGA    -       -      E     230           -
LGA    -       -      L     231           -
LGA    L   208_A      M     232          1.521
LGA    N   209_A      S     233          3.150
LGA    -       -      V     234           -
LGA    L   210_A      T     235          2.955
LGA    P   211_A      P     236          3.239
LGA    T   212_A      N     237          2.561
LGA    G   213_A      T     238          0.654
LGA    I   214_A      G     239          2.635
LGA    P   215_A      M     240          2.501
LGA    I   216_A      S     241          1.475
LGA    V   217_A      L     242          1.319
LGA    Y   218_A      F     243          1.266
LGA    E   219_A      I     244          1.928
LGA    L   220_A      I     245          2.409
LGA    D   221_A      N     246          2.124
LGA    K   222_A      F     247          2.404
LGA    -       -      E     248           -
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    N   223_A      K     254          5.542
LGA    L   224_A      P     255          3.822
LGA    K   225_A      T     256          1.940
LGA    P   226_A      V     257          2.138
LGA    I   227_A      Q     258          2.949
LGA    K   228_A      C     259          4.364
LGA    P   229_A      I     260          4.118
LGA    M   230_A      C     261          2.627
LGA    Q   231_A      M     262          4.955
LGA    F   232_A      N     263           #
LGA    L   233_A      L     264          5.030
LGA    -       -      Q     265           -
LGA    G   234_A      D     266          2.597
LGA    D   235_A      H     267           #
LGA    E   236_A      L     268           -
LGA    E   237_A      N     269           #
LGA    T   238_A      -       -           -
LGA    V   239_A      -       -           -
LGA    R   240_A      -       -           -
LGA    K   241_A      -       -           -
LGA    A   242_A      -       -           -
LGA    M   243_A      -       -           -
LGA    E   244_A      -       -           -
LGA    A   245_A      -       -           -
LGA    V   246_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  245  247    5.0    186    2.17    24.19     60.619     8.197

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.310333 * X  +  -0.811578 * Y  +  -0.495010 * Z  +  67.014938
  Y_new =  -0.183797 * X  +   0.459670 * Y  +  -0.868863 * Z  + 109.949257
  Z_new =   0.932691 * X  +   0.360619 * Y  +  -0.006515 * Z  +  -4.380311 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.588861   -1.552732  [ DEG:    91.0350    -88.9650 ]
  Theta =  -1.201802   -1.939790  [ DEG:   -68.8582   -111.1418 ]
  Phi   =  -0.534708    2.606885  [ DEG:   -30.6365    149.3635 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1yjx_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1yjx_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  245  247   5.0  186   2.17   24.19  60.619
REMARK  ---------------------------------------------------------- 
MOLECULE 1yjx_A
HEADER    ISOMERASE, HYDROLASE                    16-JAN-05   1YJX              
TITLE     CRYSTAL STRUCTURE OF HUMAN B TYPE PHOSPHOGLYCERATE MUTASE             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCERATE MUTASE 1;                                 
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PHOSPHOGLYCERATE MUTASE ISOZYME B, PGAM-B, BPG-             
COMPND   5 DEPENDENT PGAM 1;                                                    
COMPND   6 EC: 5.4.2.1, 5.4.2.4, 3.1.3.13;                                      
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET22B                                    
KEYWDS    ALPHA/BETA                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.WANG,Z.WEI,L.LIU,W.GONG                                             
REVDAT   1   17-MAY-05 1YJX    0                                                
JRNL        AUTH   Y.WANG,Z.WEI,L.LIU,Z.CHENG,Y.LIN,F.JI,W.GONG                 
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN B-TYPE PHOSPHOGLYCERATE           
JRNL        TITL 2 MUTASE BOUND WITH CITRATE.                                   
JRNL        REF    BIOCHEM.BIOPHYS.RES.COMMUN.   V. 331  1207 2005              
JRNL        REFN   ASTM BBRCA9  US ISSN 0006-291X                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  1YJX A    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX B    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX C    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX D    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX E    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX F    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX G    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX H    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX I    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX J    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX K    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
DBREF  1YJX L    1   254  UNP    P18669   PGAM1_HUMAN      0    253             
SEQRES   1 A  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 A  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 A  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 A  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 A  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 A  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 A  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 A  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 A  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 A  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 A  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 A  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 A  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 A  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 A  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 A  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 A  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 A  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 A  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 A  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 A  262  HIS HIS                                                      
SEQRES   1 B  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 B  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 B  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 B  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 B  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 B  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 B  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 B  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 B  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 B  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 B  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 B  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 B  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 B  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 B  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 B  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 B  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 B  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 B  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 B  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 B  262  HIS HIS                                                      
SEQRES   1 C  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 C  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 C  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 C  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 C  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 C  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 C  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 C  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 C  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 C  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 C  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 C  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 C  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 C  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 C  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 C  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 C  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 C  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 C  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 C  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 C  262  HIS HIS                                                      
SEQRES   1 D  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 D  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 D  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 D  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 D  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 D  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 D  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 D  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 D  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 D  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 D  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 D  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 D  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 D  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 D  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 D  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 D  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 D  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 D  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 D  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 D  262  HIS HIS                                                      
SEQRES   1 E  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 E  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 E  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 E  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 E  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 E  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 E  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 E  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 E  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 E  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 E  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 E  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 E  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 E  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 E  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 E  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 E  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 E  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 E  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 E  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 E  262  HIS HIS                                                      
SEQRES   1 F  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 F  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 F  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 F  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 F  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 F  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 F  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 F  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 F  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 F  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 F  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 F  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 F  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 F  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 F  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 F  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 F  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 F  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 F  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 F  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 F  262  HIS HIS                                                      
SEQRES   1 G  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 G  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 G  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 G  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 G  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 G  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 G  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 G  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 G  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 G  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 G  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 G  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 G  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 G  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 G  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 G  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 G  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 G  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 G  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 G  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 G  262  HIS HIS                                                      
SEQRES   1 H  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 H  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 H  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 H  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 H  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 H  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 H  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 H  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 H  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 H  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 H  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 H  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 H  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 H  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 H  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 H  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 H  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 H  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 H  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 H  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 H  262  HIS HIS                                                      
SEQRES   1 I  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 I  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 I  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 I  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 I  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 I  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 I  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 I  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 I  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 I  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 I  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 I  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 I  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 I  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 I  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 I  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 I  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 I  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 I  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 I  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 I  262  HIS HIS                                                      
SEQRES   1 J  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 J  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 J  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 J  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 J  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 J  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 J  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 J  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 J  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 J  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 J  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 J  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 J  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 J  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 J  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 J  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 J  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 J  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 J  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 J  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 J  262  HIS HIS                                                      
SEQRES   1 K  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 K  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 K  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 K  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 K  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 K  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 K  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 K  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 K  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 K  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 K  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 K  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 K  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 K  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 K  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 K  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 K  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 K  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 K  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 K  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 K  262  HIS HIS                                                      
SEQRES   1 L  262  MET ALA ALA TYR LYS LEU VAL LEU ILE ARG HIS GLY GLU          
SEQRES   2 L  262  SER ALA TRP ASN LEU GLU ASN ARG PHE SER GLY TRP TYR          
SEQRES   3 L  262  ASP ALA ASP LEU SER PRO ALA GLY HIS GLU GLU ALA LYS          
SEQRES   4 L  262  ARG GLY GLY GLN ALA LEU ARG ASP ALA GLY TYR GLU PHE          
SEQRES   5 L  262  ASP ILE CYS PHE THR SER VAL GLN LYS ARG ALA ILE ARG          
SEQRES   6 L  262  THR LEU TRP THR VAL LEU ASP ALA ILE ASP GLN MET TRP          
SEQRES   7 L  262  LEU PRO VAL VAL ARG THR TRP ARG LEU ASN GLU ARG HIS          
SEQRES   8 L  262  TYR GLY GLY LEU THR GLY LEU ASN LYS ALA GLU THR ALA          
SEQRES   9 L  262  ALA LYS HIS GLY GLU ALA GLN VAL LYS ILE TRP ARG ARG          
SEQRES  10 L  262  SER TYR ASP VAL PRO PRO PRO PRO MET GLU PRO ASP HIS          
SEQRES  11 L  262  PRO PHE TYR SER ASN ILE SER LYS ASP ARG ARG TYR ALA          
SEQRES  12 L  262  ASP LEU THR GLU ASP GLN LEU PRO SER CYS GLU SER LEU          
SEQRES  13 L  262  LYS ASP THR ILE ALA ARG ALA LEU PRO PHE TRP ASN GLU          
SEQRES  14 L  262  GLU ILE VAL PRO GLN ILE LYS GLU GLY LYS ARG VAL LEU          
SEQRES  15 L  262  ILE ALA ALA HIS GLY ASN SER LEU ARG GLY ILE VAL LYS          
SEQRES  16 L  262  HIS LEU GLU GLY LEU SER GLU GLU ALA ILE MET GLU LEU          
SEQRES  17 L  262  ASN LEU PRO THR GLY ILE PRO ILE VAL TYR GLU LEU ASP          
SEQRES  18 L  262  LYS ASN LEU LYS PRO ILE LYS PRO MET GLN PHE LEU GLY          
SEQRES  19 L  262  ASP GLU GLU THR VAL ARG LYS ALA MET GLU ALA VAL ALA          
SEQRES  20 L  262  ALA GLN GLY LYS ALA LYS LYS LEU GLU HIS HIS HIS HIS          
SEQRES  21 L  262  HIS HIS                                                      
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET     CL      3       1                                                       
HET     CL      4       1                                                       
HET     CL      5       1                                                       
HET     CL      6       1                                                       
HET    CIT    601      13                                                       
HET    CIT    602      13                                                       
HET    CIT    603      13                                                       
HET    CIT    604      13                                                       
HET    CIT    605      13                                                       
HET    CIT    606      13                                                       
HET    CIT    607      13                                                       
HET    CIT    608      13                                                       
HET    CIT    609      13                                                       
HET    CIT    610      13                                                       
HET    CIT    611      13                                                       
HET    CIT    612      13                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     CIT CITRIC ACID                                                      
FORMUL  13   CL    6(CL 1-)                                                     
FORMUL  19  CIT    12(C6 H8 O7)                                                 
FORMUL  31  HOH   *334(H2 O)                                                    
CRYST1  130.534   75.931  186.978  90.00  94.42  90.00 P 1 21 1     24          
ATOM      1  N   ALA A   2       7.511  50.163   8.353  1.00 54.94           N  
ATOM      2  CA  ALA A   2       8.913  50.275   8.866  1.00 55.54           C  
ATOM      3  C   ALA A   2       9.046  49.986  10.377  1.00 55.23           C  
ATOM      4  O   ALA A   2       9.062  50.923  11.187  1.00 56.38           O  
ATOM      5  CB  ALA A   2       9.467  51.678   8.551  1.00 54.38           C  
ATOM      6  N   ALA A   3       9.143  48.704  10.749  1.00 52.60           N  
ATOM      7  CA  ALA A   3       9.298  48.320  12.157  1.00 50.56           C  
ATOM      8  C   ALA A   3      10.755  47.914  12.404  1.00 49.30           C  
ATOM      9  O   ALA A   3      11.595  48.762  12.733  1.00 49.13           O  
ATOM     10  CB  ALA A   3       8.364  47.170  12.499  1.00 51.39           C  
ATOM     11  N   TYR A   4      11.050  46.620  12.252  1.00 46.60           N  
ATOM     12  CA  TYR A   4      12.414  46.096  12.414  1.00 42.77           C  
ATOM     13  C   TYR A   4      13.203  46.340  11.123  1.00 39.89           C  
ATOM     14  O   TYR A   4      12.630  46.434  10.038  1.00 38.76           O  
ATOM     15  CB  TYR A   4      12.393  44.589  12.652  1.00 43.23           C  
ATOM     16  CG  TYR A   4      11.818  44.129  13.966  1.00 43.91           C  
ATOM     17  CD1 TYR A   4      11.071  42.953  14.033  1.00 44.55           C  
ATOM     18  CD2 TYR A   4      12.068  44.816  15.151  1.00 43.66           C  
ATOM     19  CE1 TYR A   4      10.584  42.462  15.242  1.00 44.40           C  
ATOM     20  CE2 TYR A   4      11.586  44.328  16.376  1.00 44.65           C  
ATOM     21  CZ  TYR A   4      10.844  43.148  16.409  1.00 44.28           C  
ATOM     22  OH  TYR A   4      10.363  42.636  17.597  1.00 44.20           O  
ATOM     23  N   LYS A   5      14.518  46.434  11.230  1.00 37.10           N  
ATOM     24  CA  LYS A   5      15.322  46.628  10.040  1.00 35.58           C  
ATOM     25  C   LYS A   5      16.384  45.557   9.988  1.00 34.30           C  
ATOM     26  O   LYS A   5      17.168  45.429  10.922  1.00 35.21           O  
ATOM     27  CB  LYS A   5      15.995  47.993  10.057  1.00 37.68           C  
ATOM     28  CG  LYS A   5      15.135  49.138   9.572  1.00 40.26           C  
ATOM     29  CD  LYS A   5      15.394  49.419   8.108  1.00 41.98           C  
ATOM     30  CE  LYS A   5      14.681  50.693   7.676  1.00 43.77           C  
ATOM     31  NZ  LYS A   5      14.863  50.964   6.221  1.00 44.27           N  
ATOM     32  N   LEU A   6      16.401  44.777   8.910  1.00 32.77           N  
ATOM     33  CA  LEU A   6      17.411  43.734   8.740  1.00 30.58           C  
ATOM     34  C   LEU A   6      18.204  44.060   7.479  1.00 29.35           C  
ATOM     35  O   LEU A   6      17.634  44.366   6.432  1.00 27.97           O  
ATOM     36  CB  LEU A   6      16.759  42.357   8.568  1.00 30.29           C  
ATOM     37  CG  LEU A   6      17.557  41.101   8.934  1.00 29.90           C  
ATOM     38  CD1 LEU A   6      16.966  39.930   8.176  1.00 29.84           C  
ATOM     39  CD2 LEU A   6      19.014  41.246   8.590  1.00 30.04           C  
ATOM     40  N   VAL A   7      19.524  44.011   7.575  1.00 28.83           N  
ATOM     41  CA  VAL A   7      20.348  44.267   6.404  1.00 27.79           C  
ATOM     42  C   VAL A   7      21.234  43.064   6.109  1.00 27.06           C  
ATOM     43  O   VAL A   7      21.917  42.547   6.989  1.00 27.09           O  
ATOM     44  CB  VAL A   7      21.235  45.516   6.581  1.00 26.88           C  
ATOM     45  CG1 VAL A   7      22.089  45.718   5.351  1.00 25.78           C  
ATOM     46  CG2 VAL A   7      20.370  46.732   6.812  1.00 25.54           C  
ATOM     47  N   LEU A   8      21.190  42.610   4.862  1.00 26.45           N  
ATOM     48  CA  LEU A   8      21.989  41.487   4.416  1.00 25.46           C  
ATOM     49  C   LEU A   8      22.969  41.996   3.378  1.00 26.56           C  
ATOM     50  O   LEU A   8      22.690  42.966   2.668  1.00 26.86           O  
ATOM     51  CB  LEU A   8      21.117  40.438   3.752  1.00 24.22           C  
ATOM     52  CG  LEU A   8      19.943  39.894   4.543  1.00 25.09           C  
ATOM     53  CD1 LEU A   8      19.178  38.919   3.662  1.00 24.22           C  
ATOM     54  CD2 LEU A   8      20.446  39.221   5.815  1.00 25.69           C  
ATOM     55  N   ILE A   9      24.128  41.357   3.293  1.00 26.68           N  
ATOM     56  CA  ILE A   9      25.094  41.738   2.286  1.00 25.39           C  
ATOM     57  C   ILE A   9      25.906  40.530   1.859  1.00 25.42           C  
ATOM     58  O   ILE A   9      26.532  39.845   2.671  1.00 26.59           O  
ATOM     59  CB  ILE A   9      26.016  42.885   2.755  1.00 24.56           C  
ATOM     60  CG1 ILE A   9      26.870  43.336   1.574  1.00 25.06           C  
ATOM     61  CG2 ILE A   9      26.898  42.441   3.902  1.00 23.45           C  
ATOM     62  CD1 ILE A   9      27.604  44.617   1.822  1.00 28.22           C  
ATOM     63  N   ARG A  10      25.850  40.260   0.568  1.00 25.29           N  
ATOM     64  CA  ARG A  10      26.565  39.155  -0.038  1.00 26.14           C  
ATOM     65  C   ARG A  10      27.938  39.667  -0.474  1.00 26.49           C  
ATOM     66  O   ARG A  10      28.039  40.689  -1.153  1.00 27.01           O  
ATOM     67  CB  ARG A  10      25.778  38.662  -1.245  1.00 26.60           C  
ATOM     68  CG  ARG A  10      26.502  37.662  -2.088  1.00 27.16           C  
ATOM     69  CD  ARG A  10      25.639  37.195  -3.238  1.00 27.11           C  
ATOM     70  NE  ARG A  10      26.319  36.152  -3.989  1.00 28.81           N  
ATOM     71  CZ  ARG A  10      25.778  35.485  -4.992  1.00 28.11           C  
ATOM     72  NH1 ARG A  10      24.543  35.759  -5.366  1.00 32.06           N  
ATOM     73  NH2 ARG A  10      26.467  34.538  -5.607  1.00 28.50           N  
ATOM     74  N   HIS A  11      28.993  38.960  -0.086  1.00 26.09           N  
ATOM     75  CA  HIS A  11      30.342  39.390  -0.431  1.00 26.47           C  
ATOM     76  C   HIS A  11      30.513  39.483  -1.932  1.00 26.90           C  
ATOM     77  O   HIS A  11      29.840  38.792  -2.695  1.00 26.19           O  
ATOM     78  CB  HIS A  11      31.375  38.418   0.132  1.00 26.65           C  
ATOM     79  CG  HIS A  11      31.317  37.059  -0.493  1.00 27.35           C  
ATOM     80  ND1 HIS A  11      31.738  36.818  -1.782  1.00 26.60           N  
ATOM     81  CD2 HIS A  11      30.847  35.878  -0.023  1.00 26.78           C  
ATOM     82  CE1 HIS A  11      31.527  35.547  -2.080  1.00 25.93           C  
ATOM     83  NE2 HIS A  11      30.989  34.955  -1.032  1.00 25.38           N  
ATOM     84  N   GLY A  12      31.435  40.340  -2.349  1.00 28.07           N  
ATOM     85  CA  GLY A  12      31.696  40.511  -3.760  1.00 28.58           C  
ATOM     86  C   GLY A  12      32.671  39.487  -4.307  1.00 29.28           C  
ATOM     87  O   GLY A  12      32.965  38.470  -3.662  1.00 28.94           O  
ATOM     88  N   GLU A  13      33.176  39.775  -5.505  1.00 29.73           N  
ATOM     89  CA  GLU A  13      34.114  38.907  -6.214  1.00 30.29           C  
ATOM     90  C   GLU A  13      35.290  38.406  -5.382  1.00 29.77           C  
ATOM     91  O   GLU A  13      35.952  39.184  -4.691  1.00 28.02           O  
ATOM     92  CB  GLU A  13      34.639  39.646  -7.443  1.00 30.78           C  
ATOM     93  CG  GLU A  13      35.756  38.952  -8.172  1.00 32.12           C  
ATOM     94  CD  GLU A  13      36.174  39.704  -9.413  1.00 33.45           C  
ATOM     95  OE1 GLU A  13      35.384  39.740 -10.388  1.00 34.65           O  
ATOM     96  OE2 GLU A  13      37.288  40.265  -9.407  1.00 34.00           O  
ATOM     97  N   SER A  14      35.544  37.102  -5.462  1.00 29.57           N  
ATOM     98  CA  SER A  14      36.655  36.494  -4.731  1.00 29.60           C  
ATOM     99  C   SER A  14      37.773  36.152  -5.711  1.00 29.78           C  
ATOM    100  O   SER A  14      37.590  36.212  -6.924  1.00 29.84           O  
ATOM    101  CB  SER A  14      36.215  35.208  -4.028  1.00 28.36           C  
ATOM    102  OG  SER A  14      36.203  34.123  -4.944  1.00 26.13           O  
ATOM    103  N   ALA A  15      38.931  35.784  -5.176  1.00 30.11           N  
ATOM    104  CA  ALA A  15      40.070  35.419  -6.001  1.00 29.00           C  
ATOM    105  C   ALA A  15      39.685  34.264  -6.906  1.00 29.21           C  
ATOM    106  O   ALA A  15      40.060  34.224  -8.067  1.00 30.21           O  
ATOM    107  CB  ALA A  15      41.232  35.026  -5.127  1.00 28.92           C  
ATOM    108  N   TRP A  16      38.933  33.317  -6.374  1.00 29.94           N  
ATOM    109  CA  TRP A  16      38.518  32.188  -7.176  1.00 31.08           C  
ATOM    110  C   TRP A  16      37.406  32.556  -8.140  1.00 32.97           C  
ATOM    111  O   TRP A  16      37.197  31.880  -9.152  1.00 33.15           O  
ATOM    112  CB  TRP A  16      38.100  31.029  -6.280  1.00 29.63           C  
ATOM    113  CG  TRP A  16      39.264  30.180  -5.926  1.00 28.23           C  
ATOM    114  CD1 TRP A  16      40.576  30.554  -5.920  1.00 26.58           C  
ATOM    115  CD2 TRP A  16      39.232  28.820  -5.497  1.00 28.47           C  
ATOM    116  NE1 TRP A  16      41.361  29.514  -5.513  1.00 27.22           N  
ATOM    117  CE2 TRP A  16      40.562  28.432  -5.245  1.00 28.66           C  
ATOM    118  CE3 TRP A  16      38.206  27.886  -5.298  1.00 29.39           C  
ATOM    119  CZ2 TRP A  16      40.898  27.143  -4.801  1.00 27.96           C  
ATOM    120  CZ3 TRP A  16      38.543  26.604  -4.855  1.00 28.71           C  
ATOM    121  CH2 TRP A  16      39.877  26.249  -4.614  1.00 27.45           C  
ATOM    122  N   ASN A  17      36.692  33.632  -7.841  1.00 34.86           N  
ATOM    123  CA  ASN A  17      35.633  34.054  -8.739  1.00 36.19           C  
ATOM    124  C   ASN A  17      36.211  34.425 -10.090  1.00 37.00           C  
ATOM    125  O   ASN A  17      35.715  33.956 -11.115  1.00 37.52           O  
ATOM    126  CB  ASN A  17      34.866  35.233  -8.168  1.00 36.37           C  
ATOM    127  CG  ASN A  17      33.673  34.794  -7.386  1.00 37.26           C  
ATOM    128  OD1 ASN A  17      32.875  33.994  -7.883  1.00 38.06           O  
ATOM    129  ND2 ASN A  17      33.524  35.309  -6.158  1.00 36.15           N  
ATOM    130  N   LEU A  18      37.263  35.242 -10.113  1.00 36.99           N  
ATOM    131  CA  LEU A  18      37.822  35.606 -11.402  1.00 38.21           C  
ATOM    132  C   LEU A  18      38.729  34.535 -11.978  1.00 38.77           C  
ATOM    133  O   LEU A  18      39.219  34.673 -13.092  1.00 40.39           O  
ATOM    134  CB  LEU A  18      38.525  36.968 -11.359  1.00 38.93           C  
ATOM    135  CG  LEU A  18      39.797  37.251 -10.586  1.00 38.37           C  
ATOM    136  CD1 LEU A  18      40.105  38.717 -10.736  1.00 39.27           C  
ATOM    137  CD2 LEU A  18      39.620  36.903  -9.131  1.00 41.19           C  
ATOM    138  N   GLU A  19      38.948  33.462 -11.227  1.00 38.99           N  
ATOM    139  CA  GLU A  19      39.741  32.342 -11.729  1.00 38.22           C  
ATOM    140  C   GLU A  19      38.694  31.363 -12.278  1.00 36.69           C  
ATOM    141  O   GLU A  19      39.022  30.313 -12.831  1.00 35.87           O  
ATOM    142  CB  GLU A  19      40.520  31.667 -10.600  1.00 42.29           C  
ATOM    143  CG  GLU A  19      41.910  32.241 -10.305  1.00 47.50           C  
ATOM    144  CD  GLU A  19      42.629  31.503  -9.138  1.00 49.67           C  
ATOM    145  OE1 GLU A  19      42.813  30.256  -9.220  1.00 48.48           O  
ATOM    146  OE2 GLU A  19      43.010  32.179  -8.140  1.00 49.81           O  
ATOM    147  N   ASN A  20      37.427  31.733 -12.107  1.00 34.84           N  
ATOM    148  CA  ASN A  20      36.287  30.940 -12.551  1.00 33.80           C  
ATOM    149  C   ASN A  20      36.273  29.534 -11.942  1.00 32.98           C  
ATOM    150  O   ASN A  20      36.067  28.532 -12.631  1.00 32.63           O  
ATOM    151  CB  ASN A  20      36.278  30.838 -14.077  1.00 34.98           C  
ATOM    152  CG  ASN A  20      34.965  30.274 -14.618  1.00 34.62           C  
ATOM    153  OD1 ASN A  20      34.921  29.695 -15.709  1.00 34.57           O  
ATOM    154  ND2 ASN A  20      33.890  30.453 -13.862  1.00 32.57           N  
ATOM    155  N   ARG A  21      36.478  29.459 -10.638  1.00 31.67           N  
ATOM    156  CA  ARG A  21      36.494  28.176  -9.965  1.00 31.52           C  
ATOM    157  C   ARG A  21      35.391  28.042  -8.935  1.00 30.96           C  
ATOM    158  O   ARG A  21      34.889  29.036  -8.424  1.00 30.98           O  
ATOM    159  CB  ARG A  21      37.838  27.973  -9.278  1.00 31.39           C  
ATOM    160  CG  ARG A  21      39.007  28.035 -10.223  1.00 31.78           C  
ATOM    161  CD  ARG A  21      40.072  27.057  -9.799  1.00 31.14           C  
ATOM    162  NE  ARG A  21      41.060  27.649  -8.918  1.00 28.86           N  
ATOM    163  CZ  ARG A  21      41.859  26.941  -8.137  1.00 29.03           C  
ATOM    164  NH1 ARG A  21      41.771  25.618  -8.119  1.00 27.86           N  
ATOM    165  NH2 ARG A  21      42.765  27.561  -7.399  1.00 32.04           N  
ATOM    166  N   PHE A  22      35.007  26.804  -8.645  1.00 30.02           N  
ATOM    167  CA  PHE A  22      33.994  26.540  -7.634  1.00 29.21           C  
ATOM    168  C   PHE A  22      34.713  26.705  -6.298  1.00 27.87           C  
ATOM    169  O   PHE A  22      35.729  26.065  -6.062  1.00 28.54           O  
ATOM    170  CB  PHE A  22      33.466  25.106  -7.757  1.00 30.39           C  
ATOM    171  CG  PHE A  22      32.603  24.872  -8.963  1.00 30.54           C  
ATOM    172  CD1 PHE A  22      31.362  25.482  -9.073  1.00 31.26           C  
ATOM    173  CD2 PHE A  22      33.027  24.028  -9.984  1.00 31.13           C  
ATOM    174  CE1 PHE A  22      30.552  25.251 -10.182  1.00 31.62           C  
ATOM    175  CE2 PHE A  22      32.225  23.794 -11.094  1.00 31.79           C  
ATOM    176  CZ  PHE A  22      30.984  24.407 -11.193  1.00 31.22           C  
ATOM    177  N   SER A  23      34.199  27.561  -5.426  1.00 26.07           N  
ATOM    178  CA  SER A  23      34.844  27.788  -4.139  1.00 25.89           C  
ATOM    179  C   SER A  23      34.246  26.949  -3.019  1.00 25.86           C  
ATOM    180  O   SER A  23      34.954  26.211  -2.331  1.00 25.53           O  
ATOM    181  CB  SER A  23      34.752  29.264  -3.761  1.00 25.91           C  
ATOM    182  OG  SER A  23      35.243  30.081  -4.807  1.00 27.47           O  
ATOM    183  N   GLY A  24      32.939  27.071  -2.832  1.00 25.19           N  
ATOM    184  CA  GLY A  24      32.280  26.328  -1.781  1.00 25.20           C  
ATOM    185  C   GLY A  24      32.885  26.714  -0.452  1.00 25.30           C  
ATOM    186  O   GLY A  24      32.900  27.888  -0.090  1.00 26.71           O  
ATOM    187  N   TRP A  25      33.397  25.735   0.279  1.00 24.15           N  
ATOM    188  CA  TRP A  25      33.992  26.014   1.567  1.00 23.34           C  
ATOM    189  C   TRP A  25      35.444  26.428   1.476  1.00 23.75           C  
ATOM    190  O   TRP A  25      36.066  26.701   2.503  1.00 25.40           O  
ATOM    191  CB  TRP A  25      33.840  24.806   2.486  1.00 22.56           C  
ATOM    192  CG  TRP A  25      32.518  24.769   3.178  1.00 20.94           C  
ATOM    193  CD1 TRP A  25      31.344  25.272   2.718  1.00 20.43           C  
ATOM    194  CD2 TRP A  25      32.235  24.191   4.452  1.00 20.58           C  
ATOM    195  NE1 TRP A  25      30.346  25.050   3.623  1.00 19.72           N  
ATOM    196  CE2 TRP A  25      30.865  24.386   4.701  1.00 20.16           C  
ATOM    197  CE3 TRP A  25      33.010  23.526   5.411  1.00 21.12           C  
ATOM    198  CZ2 TRP A  25      30.245  23.944   5.872  1.00 19.88           C  
ATOM    199  CZ3 TRP A  25      32.397  23.085   6.572  1.00 21.16           C  
ATOM    200  CH2 TRP A  25      31.023  23.298   6.792  1.00 21.24           C  
ATOM    201  N   TYR A  26      36.001  26.470   0.268  1.00 23.89           N  
ATOM    202  CA  TYR A  26      37.390  26.891   0.141  1.00 23.97           C  
ATOM    203  C   TYR A  26      37.442  28.343   0.595  1.00 24.66           C  
ATOM    204  O   TYR A  26      36.625  29.166   0.171  1.00 25.29           O  
ATOM    205  CB  TYR A  26      37.893  26.789  -1.284  1.00 23.51           C  
ATOM    206  CG  TYR A  26      39.289  27.333  -1.388  1.00 26.13           C  
ATOM    207  CD1 TYR A  26      40.354  26.698  -0.740  1.00 26.66           C  
ATOM    208  CD2 TYR A  26      39.545  28.530  -2.063  1.00 26.39           C  
ATOM    209  CE1 TYR A  26      41.636  27.240  -0.750  1.00 26.29           C  
ATOM    210  CE2 TYR A  26      40.824  29.083  -2.083  1.00 27.13           C  
ATOM    211  CZ  TYR A  26      41.864  28.432  -1.419  1.00 27.16           C  
ATOM    212  OH  TYR A  26      43.126  28.978  -1.413  1.00 28.33           O  
ATOM    213  N   ASP A  27      38.399  28.660   1.457  1.00 23.95           N  
ATOM    214  CA  ASP A  27      38.498  30.008   2.000  1.00 23.42           C  
ATOM    215  C   ASP A  27      39.139  31.035   1.070  1.00 22.89           C  
ATOM    216  O   ASP A  27      40.109  31.687   1.423  1.00 22.89           O  
ATOM    217  CB  ASP A  27      39.241  29.953   3.336  1.00 22.48           C  
ATOM    218  CG  ASP A  27      38.943  31.135   4.219  1.00 21.71           C  
ATOM    219  OD1 ASP A  27      37.872  31.754   4.049  1.00 21.79           O  
ATOM    220  OD2 ASP A  27      39.776  31.426   5.102  1.00 21.36           O  
ATOM    221  N   ALA A  28      38.578  31.193  -0.118  1.00 23.49           N  
ATOM    222  CA  ALA A  28      39.103  32.163  -1.066  1.00 23.14           C  
ATOM    223  C   ALA A  28      38.882  33.558  -0.515  1.00 22.97           C  
ATOM    224  O   ALA A  28      37.866  33.837   0.122  1.00 21.95           O  
ATOM    225  CB  ALA A  28      38.406  32.022  -2.412  1.00 23.99           C  
ATOM    226  N   ASP A  29      39.837  34.438  -0.780  1.00 23.05           N  
ATOM    227  CA  ASP A  29      39.762  35.807  -0.312  1.00 23.87           C  
ATOM    228  C   ASP A  29      39.089  36.680  -1.354  1.00 23.66           C  
ATOM    229  O   ASP A  29      38.905  36.260  -2.487  1.00 23.27           O  
ATOM    230  CB  ASP A  29      41.164  36.334  -0.057  1.00 24.91           C  
ATOM    231  CG  ASP A  29      41.195  37.429   0.975  1.00 25.27           C  
ATOM    232  OD1 ASP A  29      40.210  38.198   1.060  1.00 26.59           O  
ATOM    233  OD2 ASP A  29      42.215  37.524   1.690  1.00 24.27           O  
ATOM    234  N   LEU A  30      38.716  37.894  -0.966  1.00 24.38           N  
ATOM    235  CA  LEU A  30      38.094  38.819  -1.902  1.00 25.52           C  
ATOM    236  C   LEU A  30      39.141  39.260  -2.911  1.00 26.14           C  
ATOM    237  O   LEU A  30      40.328  39.298  -2.607  1.00 25.14           O  
ATOM    238  CB  LEU A  30      37.567  40.065  -1.187  1.00 24.60           C  
ATOM    239  CG  LEU A  30      36.315  39.987  -0.315  1.00 24.08           C  
ATOM    240  CD1 LEU A  30      36.086  41.340   0.323  1.00 23.07           C  
ATOM    241  CD2 LEU A  30      35.113  39.583  -1.133  1.00 24.34           C  
ATOM    242  N   SER A  31      38.700  39.579  -4.119  1.00 27.80           N  
ATOM    243  CA  SER A  31      39.613  40.062  -5.140  1.00 28.80           C  
ATOM    244  C   SER A  31      39.627  41.563  -4.896  1.00 28.35           C  
ATOM    245  O   SER A  31      38.778  42.079  -4.190  1.00 27.28           O  
ATOM    246  CB  SER A  31      39.067  39.779  -6.544  1.00 29.21           C  
ATOM    247  OG  SER A  31      37.978  40.632  -6.849  1.00 29.68           O  
ATOM    248  N   PRO A  32      40.602  42.280  -5.455  1.00 29.13           N  
ATOM    249  CA  PRO A  32      40.608  43.724  -5.227  1.00 29.23           C  
ATOM    250  C   PRO A  32      39.230  44.313  -5.561  1.00 29.34           C  
ATOM    251  O   PRO A  32      38.694  45.141  -4.822  1.00 28.21           O  
ATOM    252  CB  PRO A  32      41.701  44.207  -6.171  1.00 28.42           C  
ATOM    253  CG  PRO A  32      42.661  43.082  -6.153  1.00 28.79           C  
ATOM    254  CD  PRO A  32      41.770  41.866  -6.251  1.00 29.29           C  
ATOM    255  N   ALA A  33      38.653  43.868  -6.670  1.00 28.94           N  
ATOM    256  CA  ALA A  33      37.344  44.354  -7.073  1.00 30.99           C  
ATOM    257  C   ALA A  33      36.295  44.051  -6.006  1.00 32.13           C  
ATOM    258  O   ALA A  33      35.489  44.908  -5.644  1.00 31.98           O  
ATOM    259  CB  ALA A  33      36.940  43.721  -8.386  1.00 30.60           C  
ATOM    260  N   GLY A  34      36.301  42.816  -5.515  1.00 33.85           N  
ATOM    261  CA  GLY A  34      35.353  42.414  -4.489  1.00 34.10           C  
ATOM    262  C   GLY A  34      35.500  43.254  -3.232  1.00 34.58           C  
ATOM    263  O   GLY A  34      34.519  43.572  -2.559  1.00 33.62           O  
ATOM    264  N   HIS A  35      36.738  43.611  -2.908  1.00 35.91           N  
ATOM    265  CA  HIS A  35      37.005  44.441  -1.746  1.00 37.55           C  
ATOM    266  C   HIS A  35      36.377  45.809  -2.005  1.00 37.83           C  
ATOM    267  O   HIS A  35      35.695  46.367  -1.151  1.00 37.30           O  
ATOM    268  CB  HIS A  35      38.513  44.599  -1.535  1.00 39.15           C  
ATOM    269  CG  HIS A  35      38.876  45.265  -0.243  1.00 41.57           C  
ATOM    270  ND1 HIS A  35      38.422  46.519   0.102  1.00 43.52           N  
ATOM    271  CD2 HIS A  35      39.636  44.843   0.795  1.00 42.51           C  
ATOM    272  CE1 HIS A  35      38.884  46.842   1.297  1.00 43.37           C  
ATOM    273  NE2 HIS A  35      39.623  45.842   1.739  1.00 42.79           N  
ATOM    274  N   GLU A  36      36.606  46.334  -3.203  1.00 38.45           N  
ATOM    275  CA  GLU A  36      36.068  47.632  -3.584  1.00 38.84           C  
ATOM    276  C   GLU A  36      34.549  47.615  -3.484  1.00 37.96           C  
ATOM    277  O   GLU A  36      33.933  48.601  -3.079  1.00 38.42           O  
ATOM    278  CB  GLU A  36      36.491  47.984  -5.012  1.00 40.79           C  
ATOM    279  CG  GLU A  36      36.518  49.477  -5.295  1.00 43.91           C  
ATOM    280  CD  GLU A  36      37.405  50.237  -4.305  1.00 48.60           C  
ATOM    281  OE1 GLU A  36      38.568  49.816  -4.065  1.00 50.04           O  
ATOM    282  OE2 GLU A  36      36.936  51.265  -3.767  1.00 50.70           O  
ATOM    283  N   GLU A  37      33.944  46.495  -3.858  1.00 36.84           N  
ATOM    284  CA  GLU A  37      32.493  46.366  -3.781  1.00 36.33           C  
ATOM    285  C   GLU A  37      32.025  46.575  -2.350  1.00 35.17           C  
ATOM    286  O   GLU A  37      31.105  47.342  -2.093  1.00 34.74           O  
ATOM    287  CB  GLU A  37      32.055  44.983  -4.247  1.00 36.84           C  
ATOM    288  CG  GLU A  37      31.547  44.938  -5.657  1.00 38.49           C  
ATOM    289  CD  GLU A  37      31.036  43.570  -6.036  1.00 39.62           C  
ATOM    290  OE1 GLU A  37      31.869  42.654  -6.258  1.00 39.73           O  
ATOM    291  OE2 GLU A  37      29.797  43.419  -6.100  1.00 40.01           O  
ATOM    292  N   ALA A  38      32.661  45.872  -1.423  1.00 33.74           N  
ATOM    293  CA  ALA A  38      32.312  45.990  -0.024  1.00 33.81           C  
ATOM    294  C   ALA A  38      32.439  47.449   0.401  1.00 33.92           C  
ATOM    295  O   ALA A  38      31.567  47.998   1.077  1.00 33.33           O  
ATOM    296  CB  ALA A  38      33.236  45.111   0.816  1.00 33.96           C  
ATOM    297  N   LYS A  39      33.538  48.070  -0.005  1.00 34.45           N  
ATOM    298  CA  LYS A  39      33.810  49.462   0.321  1.00 34.04           C  
ATOM    299  C   LYS A  39      32.667  50.344  -0.163  1.00 32.60           C  
ATOM    300  O   LYS A  39      32.177  51.187   0.575  1.00 33.74           O  
ATOM    301  CB  LYS A  39      35.120  49.892  -0.330  1.00 36.12           C  
ATOM    302  CG  LYS A  39      35.787  51.088   0.307  1.00 39.94           C  
ATOM    303  CD  LYS A  39      37.181  51.256  -0.274  1.00 45.95           C  
ATOM    304  CE  LYS A  39      37.883  52.517   0.226  1.00 48.21           C  
ATOM    305  NZ  LYS A  39      39.249  52.681  -0.411  1.00 49.46           N  
ATOM    306  N   ARG A  40      32.242  50.152  -1.408  1.00 30.07           N  
ATOM    307  CA  ARG A  40      31.144  50.945  -1.945  1.00 27.88           C  
ATOM    308  C   ARG A  40      29.896  50.613  -1.131  1.00 26.46           C  
ATOM    309  O   ARG A  40      29.185  51.505  -0.686  1.00 25.23           O  
ATOM    310  CB  ARG A  40      30.923  50.641  -3.449  1.00 24.96           C  
ATOM    311  N   GLY A  41      29.641  49.325  -0.925  1.00 27.04           N  
ATOM    312  CA  GLY A  41      28.484  48.917  -0.146  1.00 26.35           C  
ATOM    313  C   GLY A  41      28.504  49.598   1.209  1.00 26.74           C  
ATOM    314  O   GLY A  41      27.503  50.167   1.649  1.00 25.88           O  
ATOM    315  N   GLY A  42      29.654  49.540   1.875  1.00 27.08           N  
ATOM    316  CA  GLY A  42      29.778  50.178   3.171  1.00 28.01           C  
ATOM    317  C   GLY A  42      29.442  51.656   3.088  1.00 28.53           C  
ATOM    318  O   GLY A  42      28.727  52.188   3.940  1.00 28.45           O  
ATOM    319  N   GLN A  43      29.961  52.307   2.049  1.00 29.37           N  
ATOM    320  CA  GLN A  43      29.754  53.727   1.796  1.00 30.75           C  
ATOM    321  C   GLN A  43      28.274  54.083   1.626  1.00 31.74           C  
ATOM    322  O   GLN A  43      27.830  55.133   2.085  1.00 30.71           O  
ATOM    323  CB  GLN A  43      30.521  54.130   0.553  1.00 30.87           C  
ATOM    324  CG  GLN A  43      31.376  55.343   0.744  1.00 34.23           C  
ATOM    325  CD  GLN A  43      32.811  55.076   0.362  1.00 35.63           C  
ATOM    326  OE1 GLN A  43      33.085  54.554  -0.723  1.00 35.57           O  
ATOM    327  NE2 GLN A  43      33.741  55.433   1.246  1.00 36.52           N  
ATOM    328  N   ALA A  44      27.528  53.213   0.947  1.00 33.47           N  
ATOM    329  CA  ALA A  44      26.095  53.400   0.759  1.00 34.76           C  
ATOM    330  C   ALA A  44      25.429  53.422   2.143  1.00 36.07           C  
ATOM    331  O   ALA A  44      24.629  54.319   2.450  1.00 35.86           O  
ATOM    332  CB  ALA A  44      25.518  52.259  -0.083  1.00 35.17           C  
ATOM    333  N   LEU A  45      25.761  52.435   2.974  1.00 35.75           N  
ATOM    334  CA  LEU A  45      25.205  52.362   4.314  1.00 35.60           C  
ATOM    335  C   LEU A  45      25.577  53.613   5.102  1.00 36.06           C  
ATOM    336  O   LEU A  45      24.766  54.146   5.857  1.00 35.51           O  
ATOM    337  CB  LEU A  45      25.730  51.118   5.026  1.00 34.56           C  
ATOM    338  CG  LEU A  45      25.078  49.802   4.604  1.00 34.06           C  
ATOM    339  CD1 LEU A  45      25.921  48.627   5.071  1.00 32.28           C  
ATOM    340  CD2 LEU A  45      23.677  49.738   5.189  1.00 32.97           C  
ATOM    341  N   ARG A  46      26.808  54.078   4.908  1.00 36.40           N  
ATOM    342  CA  ARG A  46      27.309  55.258   5.596  1.00 37.21           C  
ATOM    343  C   ARG A  46      26.486  56.476   5.180  1.00 37.48           C  
ATOM    344  O   ARG A  46      26.051  57.263   6.025  1.00 38.43           O  
ATOM    345  CB  ARG A  46      28.792  55.452   5.261  1.00 38.73           C  
ATOM    346  CG  ARG A  46      29.564  56.421   6.149  1.00 40.91           C  
ATOM    347  CD  ARG A  46      29.510  57.839   5.612  1.00 46.16           C  
ATOM    348  NE  ARG A  46      29.889  57.937   4.196  1.00 48.87           N  
ATOM    349  CZ  ARG A  46      31.086  57.624   3.710  1.00 49.21           C  
ATOM    350  NH1 ARG A  46      32.040  57.184   4.524  1.00 50.05           N  
ATOM    351  NH2 ARG A  46      31.330  57.755   2.413  1.00 48.08           N  
ATOM    352  N   ASP A  47      26.255  56.625   3.882  1.00 36.55           N  
ATOM    353  CA  ASP A  47      25.478  57.754   3.394  1.00 35.42           C  
ATOM    354  C   ASP A  47      24.032  57.680   3.871  1.00 34.35           C  
ATOM    355  O   ASP A  47      23.426  58.695   4.182  1.00 33.43           O  
ATOM    356  CB  ASP A  47      25.513  57.806   1.869  1.00 36.42           C  
ATOM    357  CG  ASP A  47      26.907  58.039   1.327  1.00 37.23           C  
ATOM    358  OD1 ASP A  47      27.758  58.560   2.083  1.00 36.55           O  
ATOM    359  OD2 ASP A  47      27.147  57.711   0.141  1.00 37.62           O  
ATOM    360  N   ALA A  48      23.478  56.474   3.918  1.00 33.92           N  
ATOM    361  CA  ALA A  48      22.105  56.289   4.380  1.00 33.17           C  
ATOM    362  C   ALA A  48      22.048  56.385   5.902  1.00 32.90           C  
ATOM    363  O   ALA A  48      20.977  56.290   6.500  1.00 32.73           O  
ATOM    364  CB  ALA A  48      21.571  54.941   3.927  1.00 32.17           C  
ATOM    365  N   GLY A  49      23.210  56.566   6.520  1.00 32.00           N  
ATOM    366  CA  GLY A  49      23.281  56.673   7.963  1.00 31.51           C  
ATOM    367  C   GLY A  49      22.754  55.478   8.739  1.00 31.67           C  
ATOM    368  O   GLY A  49      22.131  55.653   9.778  1.00 31.58           O  
ATOM    369  N   TYR A  50      22.994  54.266   8.249  1.00 31.74           N  
ATOM    370  CA  TYR A  50      22.536  53.069   8.954  1.00 31.67           C  
ATOM    371  C   TYR A  50      23.352  52.785  10.213  1.00 31.16           C  
ATOM    372  O   TYR A  50      24.554  53.050  10.261  1.00 30.11           O  
ATOM    373  CB  TYR A  50      22.594  51.842   8.040  1.00 32.37           C  
ATOM    374  CG  TYR A  50      21.336  51.630   7.234  1.00 33.24           C  
ATOM    375  CD1 TYR A  50      20.997  52.486   6.185  1.00 33.28           C  
ATOM    376  CD2 TYR A  50      20.467  50.589   7.539  1.00 32.64           C  
ATOM    377  CE1 TYR A  50      19.823  52.304   5.465  1.00 32.91           C  
ATOM    378  CE2 TYR A  50      19.292  50.402   6.827  1.00 32.65           C  
ATOM    379  CZ  TYR A  50      18.977  51.261   5.792  1.00 33.26           C  
ATOM    380  OH  TYR A  50      17.813  51.078   5.080  1.00 34.23           O  
ATOM    381  N   GLU A  51      22.687  52.258  11.238  1.00 30.85           N  
ATOM    382  CA  GLU A  51      23.361  51.910  12.483  1.00 31.71           C  
ATOM    383  C   GLU A  51      22.993  50.482  12.822  1.00 31.60           C  
ATOM    384  O   GLU A  51      21.835  50.092  12.672  1.00 32.73           O  
ATOM    385  CB  GLU A  51      22.923  52.805  13.634  1.00 32.25           C  
ATOM    386  CG  GLU A  51      23.073  54.288  13.390  1.00 36.12           C  
ATOM    387  CD  GLU A  51      22.935  55.109  14.666  1.00 37.14           C  
ATOM    388  OE1 GLU A  51      22.046  54.791  15.488  1.00 37.40           O  
ATOM    389  OE2 GLU A  51      23.714  56.075  14.840  1.00 37.93           O  
ATOM    390  N   PHE A  52      23.968  49.699  13.270  1.00 30.23           N  
ATOM    391  CA  PHE A  52      23.699  48.316  13.624  1.00 29.10           C  
ATOM    392  C   PHE A  52      24.091  48.076  15.056  1.00 28.05           C  
ATOM    393  O   PHE A  52      24.783  48.880  15.644  1.00 28.22           O  
ATOM    394  CB  PHE A  52      24.465  47.365  12.706  1.00 28.36           C  
ATOM    395  CG  PHE A  52      24.101  47.501  11.256  1.00 27.20           C  
ATOM    396  CD1 PHE A  52      24.929  48.196  10.380  1.00 26.97           C  
ATOM    397  CD2 PHE A  52      22.932  46.932  10.767  1.00 26.92           C  
ATOM    398  CE1 PHE A  52      24.601  48.318   9.034  1.00 26.95           C  
ATOM    399  CE2 PHE A  52      22.592  47.049   9.421  1.00 27.36           C  
ATOM    400  CZ  PHE A  52      23.430  47.743   8.552  1.00 27.27           C  
ATOM    401  N   ASP A  53      23.643  46.965  15.618  1.00 28.96           N  
ATOM    402  CA  ASP A  53      23.967  46.652  17.002  1.00 29.57           C  
ATOM    403  C   ASP A  53      24.727  45.348  17.128  1.00 29.06           C  
ATOM    404  O   ASP A  53      25.424  45.127  18.124  1.00 30.01           O  
ATOM    405  CB  ASP A  53      22.694  46.585  17.833  1.00 31.50           C  
ATOM    406  CG  ASP A  53      21.893  47.857  17.748  1.00 33.40           C  
ATOM    407  OD1 ASP A  53      22.480  48.931  18.021  1.00 36.06           O  
ATOM    408  OD2 ASP A  53      20.690  47.786  17.407  1.00 33.98           O  
ATOM    409  N   ILE A  54      24.596  44.488  16.120  1.00 26.93           N  
ATOM    410  CA  ILE A  54      25.295  43.213  16.133  1.00 26.35           C  
ATOM    411  C   ILE A  54      25.468  42.711  14.709  1.00 25.99           C  
ATOM    412  O   ILE A  54      24.628  42.966  13.858  1.00 26.57           O  
ATOM    413  CB  ILE A  54      24.516  42.171  16.989  1.00 25.23           C  
ATOM    414  CG1 ILE A  54      25.336  40.895  17.138  1.00 23.82           C  
ATOM    415  CG2 ILE A  54      23.173  41.873  16.359  1.00 23.07           C  
ATOM    416  CD1 ILE A  54      24.733  39.921  18.092  1.00 23.59           C  
ATOM    417  N   CYS A  55      26.561  42.003  14.449  1.00 26.23           N  
ATOM    418  CA  CYS A  55      26.823  41.475  13.108  1.00 26.77           C  
ATOM    419  C   CYS A  55      27.025  39.963  13.100  1.00 26.15           C  
ATOM    420  O   CYS A  55      27.580  39.380  14.040  1.00 27.13           O  
ATOM    421  CB  CYS A  55      28.080  42.128  12.509  1.00 27.20           C  
ATOM    422  SG  CYS A  55      28.052  43.936  12.396  1.00 27.96           S  
ATOM    423  N   PHE A  56      26.578  39.326  12.029  1.00 24.73           N  
ATOM    424  CA  PHE A  56      26.757  37.887  11.893  1.00 23.89           C  
ATOM    425  C   PHE A  56      27.398  37.622  10.547  1.00 23.16           C  
ATOM    426  O   PHE A  56      27.013  38.209   9.536  1.00 22.47           O  
ATOM    427  CB  PHE A  56      25.426  37.127  11.958  1.00 23.30           C  
ATOM    428  CG  PHE A  56      24.715  37.255  13.262  1.00 24.36           C  
ATOM    429  CD1 PHE A  56      23.753  38.242  13.454  1.00 25.39           C  
ATOM    430  CD2 PHE A  56      24.990  36.380  14.300  1.00 25.67           C  
ATOM    431  CE1 PHE A  56      23.073  38.350  14.664  1.00 26.66           C  
ATOM    432  CE2 PHE A  56      24.316  36.476  15.518  1.00 25.71           C  
ATOM    433  CZ  PHE A  56      23.356  37.461  15.701  1.00 25.91           C  
ATOM    434  N   THR A  57      28.386  36.742  10.535  1.00 22.73           N  
ATOM    435  CA  THR A  57      29.039  36.403   9.290  1.00 22.90           C  
ATOM    436  C   THR A  57      29.487  34.946   9.362  1.00 22.51           C  
ATOM    437  O   THR A  57      29.311  34.280  10.386  1.00 20.95           O  
ATOM    438  CB  THR A  57      30.244  37.334   9.020  1.00 21.75           C  
ATOM    439  OG1 THR A  57      30.708  37.147   7.679  1.00 22.23           O  
ATOM    440  CG2 THR A  57      31.363  37.035   9.980  1.00 20.95           C  
ATOM    441  N   SER A  58      30.041  34.453   8.261  1.00 22.39           N  
ATOM    442  CA  SER A  58      30.503  33.079   8.192  1.00 23.18           C  
ATOM    443  C   SER A  58      31.898  33.005   8.777  1.00 22.38           C  
ATOM    444  O   SER A  58      32.343  33.934   9.445  1.00 21.61           O  
ATOM    445  CB  SER A  58      30.545  32.611   6.735  1.00 24.57           C  
ATOM    446  OG  SER A  58      31.594  33.258   6.027  1.00 24.09           O  
ATOM    447  N   VAL A  59      32.582  31.895   8.530  1.00 21.84           N  
ATOM    448  CA  VAL A  59      33.944  31.746   9.004  1.00 22.41           C  
ATOM    449  C   VAL A  59      34.839  31.767   7.775  1.00 22.97           C  
ATOM    450  O   VAL A  59      35.941  31.219   7.780  1.00 24.13           O  
ATOM    451  CB  VAL A  59      34.139  30.422   9.785  1.00 21.94           C  
ATOM    452  CG1 VAL A  59      33.396  30.488  11.081  1.00 19.50           C  
ATOM    453  CG2 VAL A  59      33.668  29.240   8.953  1.00 21.01           C  
ATOM    454  N   GLN A  60      34.351  32.415   6.722  1.00 23.18           N  
ATOM    455  CA  GLN A  60      35.090  32.505   5.470  1.00 23.81           C  
ATOM    456  C   GLN A  60      35.560  33.922   5.162  1.00 24.02           C  
ATOM    457  O   GLN A  60      34.769  34.864   5.194  1.00 25.11           O  
ATOM    458  CB  GLN A  60      34.220  31.966   4.336  1.00 23.43           C  
ATOM    459  CG  GLN A  60      33.945  30.475   4.468  1.00 22.81           C  
ATOM    460  CD  GLN A  60      33.133  29.916   3.317  1.00 23.00           C  
ATOM    461  OE1 GLN A  60      31.917  30.118   3.241  1.00 23.29           O  
ATOM    462  NE2 GLN A  60      33.802  29.213   2.406  1.00 21.19           N  
ATOM    463  N   LYS A  61      36.853  34.056   4.874  1.00 23.74           N  
ATOM    464  CA  LYS A  61      37.477  35.341   4.560  1.00 24.02           C  
ATOM    465  C   LYS A  61      36.614  36.317   3.776  1.00 23.74           C  
ATOM    466  O   LYS A  61      36.272  37.392   4.260  1.00 24.25           O  
ATOM    467  CB  LYS A  61      38.755  35.137   3.736  1.00 26.28           C  
ATOM    468  CG  LYS A  61      39.975  34.690   4.479  1.00 27.32           C  
ATOM    469  CD  LYS A  61      41.154  34.669   3.534  1.00 27.49           C  
ATOM    470  CE  LYS A  61      42.418  34.257   4.240  1.00 28.04           C  
ATOM    471  NZ  LYS A  61      43.605  34.430   3.368  1.00 32.11           N  
ATOM    472  N   ARG A  62      36.300  35.942   2.539  1.00 23.31           N  
ATOM    473  CA  ARG A  62      35.541  36.798   1.653  1.00 22.30           C  
ATOM    474  C   ARG A  62      34.344  37.468   2.325  1.00 23.18           C  
ATOM    475  O   ARG A  62      34.046  38.636   2.053  1.00 22.94           O  
ATOM    476  CB  ARG A  62      35.116  36.008   0.415  1.00 21.22           C  
ATOM    477  CG  ARG A  62      34.214  34.840   0.681  1.00 21.88           C  
ATOM    478  CD  ARG A  62      33.952  34.023  -0.582  1.00 22.04           C  
ATOM    479  NE  ARG A  62      34.369  32.637  -0.405  1.00 22.75           N  
ATOM    480  CZ  ARG A  62      33.624  31.585  -0.706  1.00 22.16           C  
ATOM    481  NH1 ARG A  62      32.417  31.743  -1.205  1.00 24.13           N  
ATOM    482  NH2 ARG A  62      34.084  30.370  -0.490  1.00 24.96           N  
ATOM    483  N   ALA A  63      33.664  36.746   3.213  1.00 21.96           N  
ATOM    484  CA  ALA A  63      32.512  37.316   3.889  1.00 21.07           C  
ATOM    485  C   ALA A  63      32.988  38.196   5.033  1.00 21.45           C  
ATOM    486  O   ALA A  63      32.591  39.361   5.155  1.00 21.71           O  
ATOM    487  CB  ALA A  63      31.618  36.210   4.410  1.00 22.24           C  
ATOM    488  N   ILE A  64      33.841  37.628   5.874  1.00 20.59           N  
ATOM    489  CA  ILE A  64      34.382  38.354   7.001  1.00 19.56           C  
ATOM    490  C   ILE A  64      35.006  39.660   6.545  1.00 18.89           C  
ATOM    491  O   ILE A  64      34.726  40.717   7.108  1.00 18.81           O  
ATOM    492  CB  ILE A  64      35.438  37.518   7.733  1.00 18.89           C  
ATOM    493  CG1 ILE A  64      34.782  36.235   8.252  1.00 20.15           C  
ATOM    494  CG2 ILE A  64      36.042  38.318   8.885  1.00 17.74           C  
ATOM    495  CD1 ILE A  64      35.710  35.319   9.040  1.00 20.83           C  
ATOM    496  N   ARG A  65      35.849  39.595   5.521  1.00 19.07           N  
ATOM    497  CA  ARG A  65      36.494  40.801   5.025  1.00 18.89           C  
ATOM    498  C   ARG A  65      35.471  41.801   4.505  1.00 19.17           C  
ATOM    499  O   ARG A  65      35.665  43.017   4.623  1.00 19.03           O  
ATOM    500  CB  ARG A  65      37.505  40.464   3.946  1.00 18.00           C  
ATOM    501  CG  ARG A  65      38.076  41.695   3.284  1.00 20.63           C  
ATOM    502  CD  ARG A  65      39.404  41.401   2.615  1.00 20.17           C  
ATOM    503  NE  ARG A  65      40.469  41.386   3.604  1.00 19.97           N  
ATOM    504  CZ  ARG A  65      41.314  40.378   3.764  1.00 19.05           C  
ATOM    505  NH1 ARG A  65      41.204  39.315   2.996  1.00 19.93           N  
ATOM    506  NH2 ARG A  65      42.266  40.438   4.679  1.00 17.27           N  
ATOM    507  N   THR A  66      34.382  41.299   3.936  1.00 18.78           N  
ATOM    508  CA  THR A  66      33.334  42.191   3.464  1.00 20.50           C  
ATOM    509  C   THR A  66      32.754  42.919   4.685  1.00 21.95           C  
ATOM    510  O   THR A  66      32.582  44.147   4.675  1.00 22.93           O  
ATOM    511  CB  THR A  66      32.206  41.425   2.759  1.00 19.84           C  
ATOM    512  OG1 THR A  66      32.696  40.879   1.528  1.00 21.61           O  
ATOM    513  CG2 THR A  66      31.043  42.353   2.465  1.00 18.94           C  
ATOM    514  N   LEU A  67      32.472  42.156   5.743  1.00 21.52           N  
ATOM    515  CA  LEU A  67      31.929  42.723   6.972  1.00 20.14           C  
ATOM    516  C   LEU A  67      32.864  43.802   7.496  1.00 20.68           C  
ATOM    517  O   LEU A  67      32.433  44.918   7.785  1.00 20.91           O  
ATOM    518  CB  LEU A  67      31.789  41.645   8.050  1.00 19.66           C  
ATOM    519  CG  LEU A  67      30.788  41.841   9.196  1.00 18.96           C  
ATOM    520  CD1 LEU A  67      31.394  41.314  10.467  1.00 15.84           C  
ATOM    521  CD2 LEU A  67      30.418  43.299   9.361  1.00 19.63           C  
ATOM    522  N   TRP A  68      34.140  43.455   7.630  1.00 20.66           N  
ATOM    523  CA  TRP A  68      35.129  44.387   8.140  1.00 21.42           C  
ATOM    524  C   TRP A  68      35.125  45.668   7.334  1.00 22.11           C  
ATOM    525  O   TRP A  68      35.080  46.768   7.890  1.00 22.55           O  
ATOM    526  CB  TRP A  68      36.525  43.769   8.106  1.00 21.57           C  
ATOM    527  CG  TRP A  68      36.788  42.769   9.187  1.00 22.61           C  
ATOM    528  CD1 TRP A  68      35.902  42.303  10.111  1.00 22.18           C  
ATOM    529  CD2 TRP A  68      38.026  42.088   9.441  1.00 22.87           C  
ATOM    530  NE1 TRP A  68      36.506  41.373  10.927  1.00 21.72           N  
ATOM    531  CE2 TRP A  68      37.808  41.220  10.537  1.00 21.96           C  
ATOM    532  CE3 TRP A  68      39.300  42.128   8.851  1.00 21.61           C  
ATOM    533  CZ2 TRP A  68      38.811  40.397  11.050  1.00 20.52           C  
ATOM    534  CZ3 TRP A  68      40.300  41.308   9.365  1.00 20.84           C  
ATOM    535  CH2 TRP A  68      40.047  40.455  10.453  1.00 20.88           C  
ATOM    536  N   THR A  69      35.164  45.534   6.019  1.00 21.82           N  
ATOM    537  CA  THR A  69      35.178  46.713   5.181  1.00 22.37           C  
ATOM    538  C   THR A  69      33.951  47.579   5.420  1.00 21.18           C  
ATOM    539  O   THR A  69      34.056  48.798   5.530  1.00 21.82           O  
ATOM    540  CB  THR A  69      35.270  46.327   3.705  1.00 24.15           C  
ATOM    541  OG1 THR A  69      36.529  45.681   3.475  1.00 25.37           O  
ATOM    542  CG2 THR A  69      35.164  47.566   2.811  1.00 24.18           C  
ATOM    543  N   VAL A  70      32.788  46.957   5.502  1.00 20.61           N  
ATOM    544  CA  VAL A  70      31.561  47.710   5.753  1.00 21.65           C  
ATOM    545  C   VAL A  70      31.596  48.411   7.125  1.00 22.48           C  
ATOM    546  O   VAL A  70      31.330  49.612   7.228  1.00 21.75           O  
ATOM    547  CB  VAL A  70      30.311  46.797   5.700  1.00 20.46           C  
ATOM    548  CG1 VAL A  70      29.100  47.559   6.224  1.00 19.88           C  
ATOM    549  CG2 VAL A  70      30.074  46.314   4.278  1.00 17.94           C  
ATOM    550  N   LEU A  71      31.911  47.654   8.175  1.00 22.28           N  
ATOM    551  CA  LEU A  71      31.980  48.221   9.507  1.00 22.63           C  
ATOM    552  C   LEU A  71      32.937  49.403   9.530  1.00 23.05           C  
ATOM    553  O   LEU A  71      32.671  50.422  10.176  1.00 23.76           O  
ATOM    554  CB  LEU A  71      32.433  47.164  10.520  1.00 22.04           C  
ATOM    555  CG  LEU A  71      31.417  46.041  10.767  1.00 22.80           C  
ATOM    556  CD1 LEU A  71      31.974  45.057  11.765  1.00 21.46           C  
ATOM    557  CD2 LEU A  71      30.101  46.618  11.281  1.00 21.35           C  
ATOM    558  N   ASP A  72      34.048  49.267   8.818  1.00 23.21           N  
ATOM    559  CA  ASP A  72      35.039  50.328   8.756  1.00 23.09           C  
ATOM    560  C   ASP A  72      34.427  51.549   8.088  1.00 23.51           C  
ATOM    561  O   ASP A  72      34.533  52.669   8.588  1.00 23.83           O  
ATOM    562  CB  ASP A  72      36.252  49.856   7.961  1.00 23.00           C  
ATOM    563  CG  ASP A  72      37.417  50.816   8.049  1.00 23.88           C  
ATOM    564  OD1 ASP A  72      38.457  50.522   7.425  1.00 25.43           O  
ATOM    565  OD2 ASP A  72      37.305  51.858   8.736  1.00 23.83           O  
ATOM    566  N   ALA A  73      33.769  51.316   6.960  1.00 23.47           N  
ATOM    567  CA  ALA A  73      33.148  52.382   6.202  1.00 23.24           C  
ATOM    568  C   ALA A  73      32.125  53.166   6.999  1.00 24.21           C  
ATOM    569  O   ALA A  73      32.073  54.390   6.902  1.00 26.13           O  
ATOM    570  CB  ALA A  73      32.508  51.813   4.972  1.00 22.98           C  
ATOM    571  N   ILE A  74      31.314  52.466   7.788  1.00 24.65           N  
ATOM    572  CA  ILE A  74      30.274  53.113   8.588  1.00 24.60           C  
ATOM    573  C   ILE A  74      30.689  53.436  10.022  1.00 25.39           C  
ATOM    574  O   ILE A  74      29.831  53.675  10.877  1.00 23.42           O  
ATOM    575  CB  ILE A  74      29.011  52.246   8.629  1.00 23.58           C  
ATOM    576  CG1 ILE A  74      29.258  50.991   9.467  1.00 23.18           C  
ATOM    577  CG2 ILE A  74      28.636  51.836   7.218  1.00 23.95           C  
ATOM    578  CD1 ILE A  74      28.074  50.056   9.519  1.00 21.84           C  
ATOM    579  N   ASP A  75      32.002  53.446  10.267  1.00 26.78           N  
ATOM    580  CA  ASP A  75      32.581  53.737  11.586  1.00 27.92           C  
ATOM    581  C   ASP A  75      31.893  52.974  12.727  1.00 28.64           C  
ATOM    582  O   ASP A  75      31.419  53.571  13.707  1.00 27.42           O  
ATOM    583  CB  ASP A  75      32.516  55.236  11.867  1.00 28.76           C  
ATOM    584  CG  ASP A  75      33.347  55.639  13.063  1.00 30.91           C  
ATOM    585  OD1 ASP A  75      33.237  56.812  13.482  1.00 31.77           O  
ATOM    586  OD2 ASP A  75      34.109  54.788  13.579  1.00 32.78           O  
ATOM    587  N   GLN A  76      31.845  51.651  12.601  1.00 27.67           N  
ATOM    588  CA  GLN A  76      31.203  50.825  13.608  1.00 26.52           C  
ATOM    589  C   GLN A  76      31.996  49.551  13.846  1.00 25.79           C  
ATOM    590  O   GLN A  76      31.436  48.476  14.053  1.00 26.55           O  
ATOM    591  CB  GLN A  76      29.767  50.510  13.177  1.00 25.39           C  
ATOM    592  CG  GLN A  76      28.789  51.617  13.517  1.00 26.23           C  
ATOM    593  CD  GLN A  76      27.469  51.518  12.769  1.00 27.04           C  
ATOM    594  OE1 GLN A  76      27.330  52.057  11.681  1.00 28.29           O  
ATOM    595  NE2 GLN A  76      26.498  50.824  13.349  1.00 27.24           N  
ATOM    596  N   MET A  77      33.313  49.690  13.826  1.00 24.63           N  
ATOM    597  CA  MET A  77      34.204  48.562  14.034  1.00 24.40           C  
ATOM    598  C   MET A  77      34.051  47.988  15.437  1.00 24.46           C  
ATOM    599  O   MET A  77      34.470  46.859  15.708  1.00 24.41           O  
ATOM    600  CB  MET A  77      35.655  48.997  13.814  1.00 22.07           C  
ATOM    601  CG  MET A  77      35.977  49.395  12.398  1.00 22.11           C  
ATOM    602  SD  MET A  77      37.749  49.691  12.156  1.00 21.52           S  
ATOM    603  CE  MET A  77      37.700  51.439  11.789  1.00 26.67           C  
ATOM    604  N   TRP A  78      33.439  48.769  16.320  1.00 24.34           N  
ATOM    605  CA  TRP A  78      33.257  48.357  17.705  1.00 24.37           C  
ATOM    606  C   TRP A  78      32.089  47.425  17.894  1.00 23.67           C  
ATOM    607  O   TRP A  78      31.926  46.847  18.962  1.00 24.16           O  
ATOM    608  CB  TRP A  78      33.066  49.576  18.601  1.00 25.40           C  
ATOM    609  CG  TRP A  78      31.936  50.447  18.164  1.00 26.10           C  
ATOM    610  CD1 TRP A  78      31.993  51.507  17.301  1.00 24.95           C  
ATOM    611  CD2 TRP A  78      30.573  50.323  18.561  1.00 26.78           C  
ATOM    612  NE1 TRP A  78      30.744  52.052  17.140  1.00 24.36           N  
ATOM    613  CE2 TRP A  78      29.852  51.345  17.900  1.00 25.73           C  
ATOM    614  CE3 TRP A  78      29.886  49.445  19.412  1.00 26.89           C  
ATOM    615  CZ2 TRP A  78      28.477  51.514  18.065  1.00 26.51           C  
ATOM    616  CZ3 TRP A  78      28.519  49.612  19.575  1.00 27.04           C  
ATOM    617  CH2 TRP A  78      27.828  50.640  18.905  1.00 27.75           C  
ATOM    618  N   LEU A  79      31.268  47.282  16.862  1.00 23.63           N  
ATOM    619  CA  LEU A  79      30.115  46.398  16.959  1.00 23.33           C  
ATOM    620  C   LEU A  79      30.517  44.955  17.239  1.00 22.95           C  
ATOM    621  O   LEU A  79      31.545  44.472  16.761  1.00 21.85           O  
ATOM    622  CB  LEU A  79      29.299  46.439  15.665  1.00 22.83           C  
ATOM    623  CG  LEU A  79      28.417  47.667  15.464  1.00 23.77           C  
ATOM    624  CD1 LEU A  79      27.702  47.587  14.129  1.00 22.17           C  
ATOM    625  CD2 LEU A  79      27.421  47.740  16.606  1.00 23.21           C  
ATOM    626  N   PRO A  80      29.725  44.252  18.051  1.00 22.35           N  
ATOM    627  CA  PRO A  80      30.085  42.860  18.317  1.00 21.72           C  
ATOM    628  C   PRO A  80      29.763  42.040  17.064  1.00 20.54           C  
ATOM    629  O   PRO A  80      28.743  42.270  16.415  1.00 19.16           O  
ATOM    630  CB  PRO A  80      29.189  42.495  19.502  1.00 22.38           C  
ATOM    631  CG  PRO A  80      27.975  43.333  19.275  1.00 22.39           C  
ATOM    632  CD  PRO A  80      28.583  44.670  18.880  1.00 22.57           C  
ATOM    633  N   VAL A  81      30.638  41.106  16.704  1.00 20.00           N  
ATOM    634  CA  VAL A  81      30.379  40.294  15.526  1.00 19.72           C  
ATOM    635  C   VAL A  81      30.478  38.840  15.906  1.00 20.58           C  
ATOM    636  O   VAL A  81      31.317  38.448  16.723  1.00 21.02           O  
ATOM    637  CB  VAL A  81      31.360  40.611  14.340  1.00 19.25           C  
ATOM    638  CG1 VAL A  81      31.998  41.975  14.532  1.00 17.91           C  
ATOM    639  CG2 VAL A  81      32.406  39.528  14.197  1.00 17.45           C  
ATOM    640  N   VAL A  82      29.599  38.043  15.318  1.00 21.11           N  
ATOM    641  CA  VAL A  82      29.550  36.618  15.597  1.00 21.21           C  
ATOM    642  C   VAL A  82      29.781  35.854  14.306  1.00 22.22           C  
ATOM    643  O   VAL A  82      29.085  36.074  13.312  1.00 24.21           O  
ATOM    644  CB  VAL A  82      28.173  36.230  16.201  1.00 19.38           C  
ATOM    645  CG1 VAL A  82      28.040  34.717  16.314  1.00 18.29           C  
ATOM    646  CG2 VAL A  82      28.020  36.876  17.549  1.00 15.76           C  
ATOM    647  N   ARG A  83      30.765  34.961  14.322  1.00 21.57           N  
ATOM    648  CA  ARG A  83      31.085  34.150  13.156  1.00 20.85           C  
ATOM    649  C   ARG A  83      30.490  32.745  13.327  1.00 21.77           C  
ATOM    650  O   ARG A  83      30.415  32.222  14.443  1.00 21.07           O  
ATOM    651  CB  ARG A  83      32.602  34.045  12.998  1.00 18.44           C  
ATOM    652  CG  ARG A  83      33.332  35.377  12.923  1.00 18.49           C  
ATOM    653  CD  ARG A  83      34.830  35.168  13.077  1.00 18.59           C  
ATOM    654  NE  ARG A  83      35.651  36.304  12.645  1.00 19.18           N  
ATOM    655  CZ  ARG A  83      35.683  37.494  13.240  1.00 18.90           C  
ATOM    656  NH1 ARG A  83      34.931  37.736  14.306  1.00 20.30           N  
ATOM    657  NH2 ARG A  83      36.491  38.438  12.784  1.00 17.52           N  
ATOM    658  N   THR A  84      30.052  32.144  12.229  1.00 21.61           N  
ATOM    659  CA  THR A  84      29.507  30.800  12.289  1.00 23.43           C  
ATOM    660  C   THR A  84      29.610  30.081  10.955  1.00 24.52           C  
ATOM    661  O   THR A  84      29.313  30.651   9.907  1.00 25.29           O  
ATOM    662  CB  THR A  84      28.032  30.784  12.713  1.00 23.71           C  
ATOM    663  OG1 THR A  84      27.555  29.429  12.676  1.00 23.62           O  
ATOM    664  CG2 THR A  84      27.189  31.624  11.772  1.00 24.45           C  
ATOM    665  N   TRP A  85      30.036  28.824  10.995  1.00 24.22           N  
ATOM    666  CA  TRP A  85      30.164  28.046   9.779  1.00 23.19           C  
ATOM    667  C   TRP A  85      28.790  27.846   9.179  1.00 22.80           C  
ATOM    668  O   TRP A  85      28.659  27.564   8.004  1.00 21.92           O  
ATOM    669  CB  TRP A  85      30.770  26.681  10.077  1.00 24.07           C  
ATOM    670  CG  TRP A  85      29.888  25.825  10.940  1.00 25.41           C  
ATOM    671  CD1 TRP A  85      29.822  25.829  12.298  1.00 25.54           C  
ATOM    672  CD2 TRP A  85      28.924  24.867  10.497  1.00 24.56           C  
ATOM    673  NE1 TRP A  85      28.880  24.935  12.732  1.00 24.78           N  
ATOM    674  CE2 TRP A  85      28.312  24.331  11.645  1.00 25.00           C  
ATOM    675  CE3 TRP A  85      28.518  24.409   9.238  1.00 25.51           C  
ATOM    676  CZ2 TRP A  85      27.320  23.360  11.578  1.00 26.56           C  
ATOM    677  CZ3 TRP A  85      27.529  23.441   9.167  1.00 25.50           C  
ATOM    678  CH2 TRP A  85      26.942  22.927  10.330  1.00 27.09           C  
ATOM    679  N   ARG A  86      27.759  27.986   9.994  1.00 24.03           N  
ATOM    680  CA  ARG A  86      26.402  27.799   9.500  1.00 25.48           C  
ATOM    681  C   ARG A  86      25.988  28.823   8.455  1.00 24.61           C  
ATOM    682  O   ARG A  86      24.991  28.633   7.767  1.00 24.53           O  
ATOM    683  CB  ARG A  86      25.407  27.792  10.666  1.00 27.28           C  
ATOM    684  CG  ARG A  86      25.528  26.537  11.505  1.00 27.69           C  
ATOM    685  CD  ARG A  86      24.635  26.536  12.716  1.00 28.12           C  
ATOM    686  NE  ARG A  86      24.776  25.277  13.444  1.00 30.18           N  
ATOM    687  CZ  ARG A  86      24.245  24.120  13.054  1.00 30.16           C  
ATOM    688  NH1 ARG A  86      23.521  24.053  11.941  1.00 29.03           N  
ATOM    689  NH2 ARG A  86      24.458  23.022  13.768  1.00 30.01           N  
ATOM    690  N   LEU A  87      26.749  29.903   8.333  1.00 24.26           N  
ATOM    691  CA  LEU A  87      26.449  30.925   7.340  1.00 23.97           C  
ATOM    692  C   LEU A  87      27.429  30.799   6.190  1.00 24.45           C  
ATOM    693  O   LEU A  87      27.479  31.647   5.300  1.00 24.54           O  
ATOM    694  CB  LEU A  87      26.537  32.325   7.947  1.00 22.71           C  
ATOM    695  CG  LEU A  87      25.341  32.723   8.805  1.00 20.34           C  
ATOM    696  CD1 LEU A  87      25.589  34.078   9.429  1.00 18.38           C  
ATOM    697  CD2 LEU A  87      24.082  32.708   7.944  1.00 17.10           C  
ATOM    698  N   ASN A  88      28.209  29.728   6.222  1.00 24.21           N  
ATOM    699  CA  ASN A  88      29.186  29.462   5.183  1.00 24.75           C  
ATOM    700  C   ASN A  88      28.512  29.308   3.839  1.00 24.49           C  
ATOM    701  O   ASN A  88      27.308  29.089   3.757  1.00 23.14           O  
ATOM    702  CB  ASN A  88      29.956  28.172   5.495  1.00 25.14           C  
ATOM    703  CG  ASN A  88      31.306  28.432   6.140  1.00 24.80           C  
ATOM    704  OD1 ASN A  88      31.505  29.450   6.812  1.00 26.24           O  
ATOM    705  ND2 ASN A  88      32.237  27.502   5.951  1.00 22.55           N  
ATOM    706  N   GLU A  89      29.308  29.434   2.786  1.00 25.38           N  
ATOM    707  CA  GLU A  89      28.815  29.264   1.431  1.00 26.60           C  
ATOM    708  C   GLU A  89      28.481  27.790   1.346  1.00 26.43           C  
ATOM    709  O   GLU A  89      28.986  26.991   2.129  1.00 26.66           O  
ATOM    710  CB  GLU A  89      29.910  29.610   0.417  1.00 26.22           C  
ATOM    711  CG  GLU A  89      29.558  29.330  -1.020  1.00 26.35           C  
ATOM    712  CD  GLU A  89      28.361  30.109  -1.484  1.00 27.99           C  
ATOM    713  OE1 GLU A  89      27.225  29.651  -1.241  1.00 29.16           O  
ATOM    714  OE2 GLU A  89      28.550  31.189  -2.084  1.00 29.49           O  
ATOM    715  N   ARG A  90      27.625  27.422   0.411  1.00 27.10           N  
ATOM    716  CA  ARG A  90      27.255  26.029   0.271  1.00 28.89           C  
ATOM    717  C   ARG A  90      28.481  25.220  -0.121  1.00 29.73           C  
ATOM    718  O   ARG A  90      29.254  25.646  -0.988  1.00 30.98           O  
ATOM    719  CB  ARG A  90      26.174  25.901  -0.785  1.00 29.49           C  
ATOM    720  CG  ARG A  90      26.084  24.547  -1.402  1.00 32.20           C  
ATOM    721  CD  ARG A  90      26.270  24.696  -2.881  1.00 36.70           C  
ATOM    722  NE  ARG A  90      25.496  23.692  -3.586  1.00 40.25           N  
ATOM    723  CZ  ARG A  90      25.087  23.814  -4.841  1.00 41.59           C  
ATOM    724  NH1 ARG A  90      25.381  24.911  -5.532  1.00 41.75           N  
ATOM    725  NH2 ARG A  90      24.378  22.838  -5.399  1.00 42.37           N  
ATOM    726  N   HIS A  91      28.662  24.061   0.515  1.00 29.52           N  
ATOM    727  CA  HIS A  91      29.808  23.193   0.225  1.00 29.40           C  
ATOM    728  C   HIS A  91      29.624  22.560  -1.144  1.00 29.61           C  
ATOM    729  O   HIS A  91      28.637  21.872  -1.382  1.00 30.45           O  
ATOM    730  CB  HIS A  91      29.924  22.113   1.297  1.00 29.99           C  
ATOM    731  CG  HIS A  91      31.184  21.312   1.217  1.00 29.23           C  
ATOM    732  ND1 HIS A  91      31.979  21.066   2.317  1.00 28.20           N  
ATOM    733  CD2 HIS A  91      31.796  20.716   0.168  1.00 28.08           C  
ATOM    734  CE1 HIS A  91      33.030  20.356   1.946  1.00 28.18           C  
ATOM    735  NE2 HIS A  91      32.942  20.132   0.648  1.00 28.20           N  
ATOM    736  N   TYR A  92      30.572  22.791  -2.044  1.00 30.00           N  
ATOM    737  CA  TYR A  92      30.470  22.276  -3.403  1.00 30.77           C  
ATOM    738  C   TYR A  92      31.089  20.913  -3.644  1.00 30.17           C  
ATOM    739  O   TYR A  92      31.321  20.529  -4.784  1.00 29.69           O  
ATOM    740  CB  TYR A  92      31.063  23.290  -4.379  1.00 34.00           C  
ATOM    741  CG  TYR A  92      30.036  23.947  -5.274  1.00 37.71           C  
ATOM    742  CD1 TYR A  92      29.516  23.277  -6.381  1.00 38.67           C  
ATOM    743  CD2 TYR A  92      29.568  25.226  -5.002  1.00 39.15           C  
ATOM    744  CE1 TYR A  92      28.560  23.866  -7.190  1.00 40.32           C  
ATOM    745  CE2 TYR A  92      28.613  25.823  -5.802  1.00 40.58           C  
ATOM    746  CZ  TYR A  92      28.110  25.143  -6.894  1.00 41.28           C  
ATOM    747  OH  TYR A  92      27.150  25.745  -7.689  1.00 44.01           O  
ATOM    748  N   GLY A  93      31.355  20.184  -2.570  1.00 30.13           N  
ATOM    749  CA  GLY A  93      31.923  18.854  -2.699  1.00 29.39           C  
ATOM    750  C   GLY A  93      33.070  18.724  -3.677  1.00 28.59           C  
ATOM    751  O   GLY A  93      33.911  19.606  -3.775  1.00 28.91           O  
ATOM    752  N   GLY A  94      33.094  17.613  -4.405  1.00 28.09           N  
ATOM    753  CA  GLY A  94      34.156  17.366  -5.359  1.00 28.15           C  
ATOM    754  C   GLY A  94      34.378  18.445  -6.401  1.00 28.71           C  
ATOM    755  O   GLY A  94      35.468  18.541  -6.964  1.00 27.81           O  
ATOM    756  N   LEU A  95      33.355  19.248  -6.678  1.00 29.66           N  
ATOM    757  CA  LEU A  95      33.476  20.316  -7.671  1.00 29.71           C  
ATOM    758  C   LEU A  95      34.396  21.423  -7.173  1.00 29.54           C  
ATOM    759  O   LEU A  95      34.890  22.237  -7.956  1.00 29.12           O  
ATOM    760  CB  LEU A  95      32.108  20.899  -7.994  1.00 29.92           C  
ATOM    761  CG  LEU A  95      31.139  19.915  -8.638  1.00 31.28           C  
ATOM    762  CD1 LEU A  95      29.782  20.576  -8.807  1.00 31.46           C  
ATOM    763  CD2 LEU A  95      31.693  19.476  -9.977  1.00 31.29           C  
ATOM    764  N   THR A  96      34.626  21.440  -5.868  1.00 28.22           N  
ATOM    765  CA  THR A  96      35.487  22.435  -5.267  1.00 28.51           C  
ATOM    766  C   THR A  96      36.835  22.529  -5.970  1.00 28.95           C  
ATOM    767  O   THR A  96      37.549  21.538  -6.131  1.00 28.79           O  
ATOM    768  CB  THR A  96      35.752  22.125  -3.784  1.00 28.49           C  
ATOM    769  OG1 THR A  96      34.508  22.015  -3.085  1.00 29.47           O  
ATOM    770  CG2 THR A  96      36.570  23.231  -3.157  1.00 27.60           C  
ATOM    771  N   GLY A  97      37.181  23.735  -6.389  1.00 29.32           N  
ATOM    772  CA  GLY A  97      38.456  23.949  -7.036  1.00 29.81           C  
ATOM    773  C   GLY A  97      38.452  23.751  -8.527  1.00 30.20           C  
ATOM    774  O   GLY A  97      39.316  24.280  -9.206  1.00 30.92           O  
ATOM    775  N   LEU A  98      37.493  22.988  -9.042  1.00 31.00           N  
ATOM    776  CA  LEU A  98      37.429  22.745 -10.479  1.00 31.03           C  
ATOM    777  C   LEU A  98      37.022  24.010 -11.215  1.00 31.28           C  
ATOM    778  O   LEU A  98      36.347  24.872 -10.666  1.00 31.70           O  
ATOM    779  CB  LEU A  98      36.423  21.635 -10.798  1.00 30.82           C  
ATOM    780  CG  LEU A  98      36.650  20.267 -10.158  1.00 30.37           C  
ATOM    781  CD1 LEU A  98      35.551  19.314 -10.588  1.00 29.15           C  
ATOM    782  CD2 LEU A  98      38.009  19.745 -10.554  1.00 28.41           C  
ATOM    783  N   ASN A  99      37.450  24.123 -12.462  1.00 31.92           N  
ATOM    784  CA  ASN A  99      37.098  25.271 -13.278  1.00 32.41           C  
ATOM    785  C   ASN A  99      35.687  25.027 -13.792  1.00 32.86           C  
ATOM    786  O   ASN A  99      35.386  23.967 -14.337  1.00 33.28           O  
ATOM    787  CB  ASN A  99      38.077  25.399 -14.440  1.00 33.65           C  
ATOM    788  CG  ASN A  99      37.680  26.479 -15.416  1.00 34.33           C  
ATOM    789  OD1 ASN A  99      36.749  26.312 -16.208  1.00 33.79           O  
ATOM    790  ND2 ASN A  99      38.380  27.606 -15.357  1.00 35.11           N  
ATOM    791  N   LYS A 100      34.812  26.004 -13.619  1.00 33.13           N  
ATOM    792  CA  LYS A 100      33.430  25.839 -14.049  1.00 33.66           C  
ATOM    793  C   LYS A 100      33.265  25.514 -15.522  1.00 33.85           C  
ATOM    794  O   LYS A 100      32.488  24.629 -15.881  1.00 33.39           O  
ATOM    795  CB  LYS A 100      32.625  27.087 -13.715  1.00 34.46           C  
ATOM    796  CG  LYS A 100      32.517  27.384 -12.238  1.00 34.47           C  
ATOM    797  CD  LYS A 100      31.692  28.623 -12.026  1.00 35.78           C  
ATOM    798  CE  LYS A 100      31.704  29.065 -10.582  1.00 38.76           C  
ATOM    799  NZ  LYS A 100      30.855  30.274 -10.413  1.00 38.51           N  
ATOM    800  N   ALA A 101      33.989  26.230 -16.374  1.00 34.94           N  
ATOM    801  CA  ALA A 101      33.911  25.999 -17.811  1.00 35.02           C  
ATOM    802  C   ALA A 101      34.316  24.564 -18.169  1.00 35.57           C  
ATOM    803  O   ALA A 101      33.631  23.890 -18.936  1.00 33.45           O  
ATOM    804  CB  ALA A 101      34.794  26.992 -18.545  1.00 34.58           C  
ATOM    805  N   GLU A 102      35.425  24.099 -17.599  1.00 36.40           N  
ATOM    806  CA  GLU A 102      35.903  22.759 -17.886  1.00 37.73           C  
ATOM    807  C   GLU A 102      34.932  21.726 -17.369  1.00 36.97           C  
ATOM    808  O   GLU A 102      34.674  20.733 -18.037  1.00 37.97           O  
ATOM    809  CB  GLU A 102      37.272  22.531 -17.261  1.00 40.38           C  
ATOM    810  CG  GLU A 102      38.261  23.646 -17.532  1.00 44.65           C  
ATOM    811  CD  GLU A 102      39.659  23.310 -17.044  1.00 47.79           C  
ATOM    812  OE1 GLU A 102      39.788  22.719 -15.945  1.00 50.14           O  
ATOM    813  OE2 GLU A 102      40.630  23.649 -17.757  1.00 50.03           O  
ATOM    814  N   THR A 103      34.391  21.960 -16.182  1.00 36.84           N  
ATOM    815  CA  THR A 103      33.440  21.024 -15.590  1.00 36.62           C  
ATOM    816  C   THR A 103      32.224  20.870 -16.498  1.00 37.56           C  
ATOM    817  O   THR A 103      31.708  19.764 -16.686  1.00 37.05           O  
ATOM    818  CB  THR A 103      32.988  21.498 -14.201  1.00 34.88           C  
ATOM    819  OG1 THR A 103      34.134  21.628 -13.360  1.00 34.50           O  
ATOM    820  CG2 THR A 103      32.037  20.502 -13.576  1.00 33.60           C  
ATOM    821  N   ALA A 104      31.774  21.983 -17.069  1.00 38.22           N  
ATOM    822  CA  ALA A 104      30.630  21.948 -17.965  1.00 37.89           C  
ATOM    823  C   ALA A 104      31.010  21.129 -19.194  1.00 38.88           C  
ATOM    824  O   ALA A 104      30.211  20.344 -19.701  1.00 40.13           O  
ATOM    825  CB  ALA A 104      30.238  23.355 -18.363  1.00 37.20           C  
ATOM    826  N   ALA A 105      32.245  21.300 -19.656  1.00 38.77           N  
ATOM    827  CA  ALA A 105      32.729  20.591 -20.827  1.00 37.72           C  
ATOM    828  C   ALA A 105      32.888  19.108 -20.574  1.00 37.70           C  
ATOM    829  O   ALA A 105      32.508  18.290 -21.410  1.00 40.22           O  
ATOM    830  CB  ALA A 105      34.057  21.167 -21.268  1.00 36.81           C  
ATOM    831  N   LYS A 106      33.466  18.778 -19.421  1.00 36.36           N  
ATOM    832  CA  LYS A 106      33.747  17.398 -19.036  1.00 35.58           C  
ATOM    833  C   LYS A 106      32.567  16.556 -18.537  1.00 35.49           C  
ATOM    834  O   LYS A 106      32.600  15.328 -18.625  1.00 35.44           O  
ATOM    835  CB  LYS A 106      34.880  17.376 -17.990  1.00 33.62           C  
ATOM    836  N   HIS A 107      31.528  17.194 -18.013  1.00 35.22           N  
ATOM    837  CA  HIS A 107      30.384  16.434 -17.521  1.00 34.48           C  
ATOM    838  C   HIS A 107      29.126  16.764 -18.285  1.00 34.05           C  
ATOM    839  O   HIS A 107      28.142  16.025 -18.219  1.00 33.50           O  
ATOM    840  CB  HIS A 107      30.170  16.704 -16.044  1.00 34.35           C  
ATOM    841  CG  HIS A 107      31.299  16.241 -15.187  1.00 34.62           C  
ATOM    842  ND1 HIS A 107      31.324  14.994 -14.603  1.00 33.90           N  
ATOM    843  CD2 HIS A 107      32.453  16.852 -14.826  1.00 35.97           C  
ATOM    844  CE1 HIS A 107      32.443  14.858 -13.913  1.00 34.95           C  
ATOM    845  NE2 HIS A 107      33.146  15.972 -14.032  1.00 36.18           N  
ATOM    846  N   GLY A 108      29.161  17.887 -18.998  1.00 33.55           N  
ATOM    847  CA  GLY A 108      28.019  18.281 -19.797  1.00 33.26           C  
ATOM    848  C   GLY A 108      27.087  19.287 -19.166  1.00 32.91           C  
ATOM    849  O   GLY A 108      26.657  19.117 -18.018  1.00 33.24           O  
ATOM    850  N   GLU A 109      26.768  20.324 -19.944  1.00 31.98           N  
ATOM    851  CA  GLU A 109      25.884  21.406 -19.520  1.00 30.58           C  
ATOM    852  C   GLU A 109      24.809  20.900 -18.562  1.00 29.60           C  
ATOM    853  O   GLU A 109      24.700  21.365 -17.425  1.00 29.03           O  
ATOM    854  CB  GLU A 109      25.233  22.054 -20.741  1.00 29.63           C  
ATOM    855  N   ALA A 110      24.032  19.930 -19.025  1.00 28.47           N  
ATOM    856  CA  ALA A 110      22.957  19.367 -18.227  1.00 27.06           C  
ATOM    857  C   ALA A 110      23.396  18.975 -16.819  1.00 27.37           C  
ATOM    858  O   ALA A 110      22.912  19.545 -15.825  1.00 27.79           O  
ATOM    859  CB  ALA A 110      22.359  18.166 -18.938  1.00 24.66           C  
ATOM    860  N   GLN A 111      24.317  18.018 -16.731  1.00 25.98           N  
ATOM    861  CA  GLN A 111      24.770  17.550 -15.437  1.00 24.41           C  
ATOM    862  C   GLN A 111      25.178  18.689 -14.527  1.00 24.86           C  
ATOM    863  O   GLN A 111      24.801  18.730 -13.353  1.00 25.77           O  
ATOM    864  CB  GLN A 111      25.935  16.579 -15.589  1.00 24.78           C  
ATOM    865  CG  GLN A 111      26.415  15.988 -14.254  1.00 24.52           C  
ATOM    866  CD  GLN A 111      25.297  15.312 -13.485  1.00 24.15           C  
ATOM    867  OE1 GLN A 111      24.710  14.341 -13.958  1.00 24.44           O  
ATOM    868  NE2 GLN A 111      24.990  15.829 -12.299  1.00 22.73           N  
ATOM    869  N   VAL A 112      25.947  19.627 -15.058  1.00 24.17           N  
ATOM    870  CA  VAL A 112      26.383  20.736 -14.229  1.00 24.27           C  
ATOM    871  C   VAL A 112      25.223  21.640 -13.796  1.00 23.34           C  
ATOM    872  O   VAL A 112      25.164  22.062 -12.636  1.00 22.52           O  
ATOM    873  CB  VAL A 112      27.522  21.539 -14.941  1.00 24.25           C  
ATOM    874  CG1 VAL A 112      27.484  23.020 -14.551  1.00 25.13           C  
ATOM    875  CG2 VAL A 112      28.872  20.940 -14.543  1.00 21.50           C  
ATOM    876  N   LYS A 113      24.297  21.931 -14.706  1.00 23.46           N  
ATOM    877  CA  LYS A 113      23.165  22.778 -14.344  1.00 23.16           C  
ATOM    878  C   LYS A 113      22.448  22.129 -13.158  1.00 23.08           C  
ATOM    879  O   LYS A 113      21.926  22.824 -12.297  1.00 23.46           O  
ATOM    880  CB  LYS A 113      22.206  22.957 -15.528  1.00 22.11           C  
ATOM    881  N   ILE A 114      22.420  20.802 -13.093  1.00 22.35           N  
ATOM    882  CA  ILE A 114      21.776  20.176 -11.948  1.00 23.42           C  
ATOM    883  C   ILE A 114      22.598  20.476 -10.688  1.00 24.62           C  
ATOM    884  O   ILE A 114      22.060  20.923  -9.677  1.00 24.52           O  
ATOM    885  CB  ILE A 114      21.634  18.644 -12.122  1.00 23.08           C  
ATOM    886  CG1 ILE A 114      20.643  18.346 -13.249  1.00 21.67           C  
ATOM    887  CG2 ILE A 114      21.166  18.004 -10.818  1.00 18.57           C  
ATOM    888  CD1 ILE A 114      20.380  16.875 -13.471  1.00 21.75           C  
ATOM    889  N   TRP A 115      23.903  20.246 -10.747  1.00 26.20           N  
ATOM    890  CA  TRP A 115      24.745  20.522  -9.590  1.00 29.45           C  
ATOM    891  C   TRP A 115      24.770  22.006  -9.214  1.00 31.78           C  
ATOM    892  O   TRP A 115      24.836  22.357  -8.032  1.00 31.81           O  
ATOM    893  CB  TRP A 115      26.183  20.070  -9.833  1.00 28.54           C  
ATOM    894  CG  TRP A 115      26.347  18.611  -9.966  1.00 27.74           C  
ATOM    895  CD1 TRP A 115      25.569  17.640  -9.410  1.00 27.12           C  
ATOM    896  CD2 TRP A 115      27.377  17.938 -10.690  1.00 28.21           C  
ATOM    897  NE1 TRP A 115      26.049  16.395  -9.746  1.00 27.94           N  
ATOM    898  CE2 TRP A 115      27.160  16.551 -10.533  1.00 27.84           C  
ATOM    899  CE3 TRP A 115      28.464  18.373 -11.460  1.00 27.60           C  
ATOM    900  CZ2 TRP A 115      27.989  15.595 -11.119  1.00 26.47           C  
ATOM    901  CZ3 TRP A 115      29.289  17.419 -12.042  1.00 26.98           C  
ATOM    902  CH2 TRP A 115      29.044  16.047 -11.868  1.00 26.59           C  
ATOM    903  N   ARG A 116      24.715  22.876 -10.216  1.00 33.46           N  
ATOM    904  CA  ARG A 116      24.767  24.301  -9.950  1.00 35.04           C  
ATOM    905  C   ARG A 116      23.446  24.952  -9.605  1.00 36.15           C  
ATOM    906  O   ARG A 116      23.424  25.908  -8.836  1.00 37.46           O  
ATOM    907  CB  ARG A 116      25.375  25.042 -11.142  1.00 34.98           C  
ATOM    908  CG  ARG A 116      26.798  24.662 -11.432  1.00 34.87           C  
ATOM    909  CD  ARG A 116      27.590  25.877 -11.738  1.00 33.94           C  
ATOM    910  NE  ARG A 116      27.047  26.575 -12.886  1.00 37.91           N  
ATOM    911  CZ  ARG A 116      27.247  27.869 -13.127  1.00 41.57           C  
ATOM    912  NH1 ARG A 116      27.980  28.592 -12.284  1.00 41.14           N  
ATOM    913  NH2 ARG A 116      26.715  28.448 -14.207  1.00 43.23           N  
ATOM    914  N   ARG A 117      22.344  24.444 -10.153  1.00 36.54           N  
ATOM    915  CA  ARG A 117      21.054  25.071  -9.904  1.00 37.94           C  
ATOM    916  C   ARG A 117      19.889  24.252  -9.330  1.00 37.72           C  
ATOM    917  O   ARG A 117      18.888  24.821  -8.905  1.00 38.54           O  
ATOM    918  CB  ARG A 117      20.616  25.793 -11.178  1.00 38.71           C  
ATOM    919  CG  ARG A 117      21.312  27.124 -11.353  1.00 43.20           C  
ATOM    920  CD  ARG A 117      21.254  27.590 -12.780  1.00 49.00           C  
ATOM    921  NE  ARG A 117      22.111  26.760 -13.624  1.00 54.57           N  
ATOM    922  CZ  ARG A 117      22.211  26.871 -14.949  1.00 56.64           C  
ATOM    923  NH1 ARG A 117      21.505  27.787 -15.606  1.00 55.72           N  
ATOM    924  NH2 ARG A 117      23.022  26.055 -15.619  1.00 58.50           N  
ATOM    925  N   SER A 118      20.006  22.934  -9.306  1.00 36.95           N  
ATOM    926  CA  SER A 118      18.952  22.097  -8.742  1.00 36.03           C  
ATOM    927  C   SER A 118      18.819  22.396  -7.251  1.00 35.85           C  
ATOM    928  O   SER A 118      19.772  22.816  -6.604  1.00 35.43           O  
ATOM    929  CB  SER A 118      19.284  20.620  -8.929  1.00 35.43           C  
ATOM    930  OG  SER A 118      20.028  20.132  -7.828  1.00 33.93           O  
ATOM    931  N   TYR A 119      17.640  22.166  -6.698  1.00 36.29           N  
ATOM    932  CA  TYR A 119      17.422  22.444  -5.289  1.00 36.34           C  
ATOM    933  C   TYR A 119      17.943  21.371  -4.344  1.00 37.06           C  
ATOM    934  O   TYR A 119      18.540  21.689  -3.316  1.00 37.31           O  
ATOM    935  CB  TYR A 119      15.938  22.638  -5.010  1.00 36.07           C  
ATOM    936  CG  TYR A 119      15.651  23.071  -3.589  1.00 36.78           C  
ATOM    937  CD1 TYR A 119      15.867  24.394  -3.185  1.00 36.75           C  
ATOM    938  CD2 TYR A 119      15.168  22.161  -2.645  1.00 35.75           C  
ATOM    939  CE1 TYR A 119      15.606  24.803  -1.881  1.00 35.69           C  
ATOM    940  CE2 TYR A 119      14.906  22.560  -1.338  1.00 36.06           C  
ATOM    941  CZ  TYR A 119      15.128  23.884  -0.964  1.00 36.25           C  
ATOM    942  OH  TYR A 119      14.873  24.290   0.327  1.00 36.71           O  
ATOM    943  N   ASP A 120      17.728  20.104  -4.683  1.00 36.87           N  
ATOM    944  CA  ASP A 120      18.145  19.035  -3.796  1.00 36.89           C  
ATOM    945  C   ASP A 120      19.123  17.993  -4.303  1.00 36.22           C  
ATOM    946  O   ASP A 120      19.265  16.943  -3.686  1.00 36.62           O  
ATOM    947  CB  ASP A 120      16.909  18.330  -3.247  1.00 38.98           C  
ATOM    948  CG  ASP A 120      15.874  18.044  -4.323  1.00 40.41           C  
ATOM    949  OD1 ASP A 120      16.273  17.844  -5.488  1.00 41.49           O  
ATOM    950  OD2 ASP A 120      14.664  18.004  -4.004  1.00 40.06           O  
ATOM    951  N   VAL A 121      19.793  18.255  -5.418  1.00 35.38           N  
ATOM    952  CA  VAL A 121      20.772  17.300  -5.918  1.00 33.41           C  
ATOM    953  C   VAL A 121      22.152  17.814  -5.544  1.00 33.69           C  
ATOM    954  O   VAL A 121      22.658  18.774  -6.134  1.00 33.88           O  
ATOM    955  CB  VAL A 121      20.701  17.146  -7.429  1.00 32.42           C  
ATOM    956  CG1 VAL A 121      21.735  16.138  -7.880  1.00 33.11           C  
ATOM    957  CG2 VAL A 121      19.314  16.707  -7.841  1.00 31.43           C  
ATOM    958  N   PRO A 122      22.783  17.188  -4.546  1.00 33.65           N  
ATOM    959  CA  PRO A 122      24.115  17.625  -4.126  1.00 34.12           C  
ATOM    960  C   PRO A 122      25.192  17.262  -5.139  1.00 33.27           C  
ATOM    961  O   PRO A 122      25.054  16.311  -5.891  1.00 33.84           O  
ATOM    962  CB  PRO A 122      24.305  16.891  -2.809  1.00 34.19           C  
ATOM    963  CG  PRO A 122      23.622  15.592  -3.081  1.00 32.26           C  
ATOM    964  CD  PRO A 122      22.344  16.021  -3.762  1.00 32.61           C  
ATOM    965  N   PRO A 123      26.273  18.031  -5.182  1.00 33.23           N  
ATOM    966  CA  PRO A 123      27.333  17.712  -6.134  1.00 34.11           C  
ATOM    967  C   PRO A 123      28.091  16.503  -5.610  1.00 34.23           C  
ATOM    968  O   PRO A 123      27.864  16.061  -4.488  1.00 34.84           O  
ATOM    969  CB  PRO A 123      28.181  18.979  -6.137  1.00 34.09           C  
ATOM    970  CG  PRO A 123      28.059  19.448  -4.729  1.00 34.06           C  
ATOM    971  CD  PRO A 123      26.575  19.273  -4.456  1.00 34.53           C  
ATOM    972  N   PRO A 124      29.002  15.950  -6.412  1.00 34.34           N  
ATOM    973  CA  PRO A 124      29.758  14.784  -5.954  1.00 34.86           C  
ATOM    974  C   PRO A 124      30.455  15.076  -4.631  1.00 35.40           C  
ATOM    975  O   PRO A 124      30.891  16.199  -4.381  1.00 35.12           O  
ATOM    976  CB  PRO A 124      30.746  14.547  -7.091  1.00 34.24           C  
ATOM    977  CG  PRO A 124      29.994  15.032  -8.289  1.00 35.21           C  
ATOM    978  CD  PRO A 124      29.378  16.313  -7.788  1.00 35.17           C  
ATOM    979  N   PRO A 125      30.567  14.064  -3.763  1.00 36.03           N  
ATOM    980  CA  PRO A 125      31.220  14.239  -2.462  1.00 36.16           C  
ATOM    981  C   PRO A 125      32.693  14.543  -2.621  1.00 36.03           C  
ATOM    982  O   PRO A 125      33.305  14.130  -3.602  1.00 36.68           O  
ATOM    983  CB  PRO A 125      31.004  12.891  -1.779  1.00 36.16           C  
ATOM    984  CG  PRO A 125      29.755  12.367  -2.425  1.00 36.79           C  
ATOM    985  CD  PRO A 125      29.969  12.723  -3.872  1.00 35.91           C  
ATOM    986  N   MET A 126      33.258  15.270  -1.666  1.00 36.83           N  
ATOM    987  CA  MET A 126      34.679  15.586  -1.706  1.00 38.34           C  
ATOM    988  C   MET A 126      35.407  14.431  -1.034  1.00 39.84           C  
ATOM    989  O   MET A 126      35.369  14.285   0.186  1.00 39.82           O  
ATOM    990  CB  MET A 126      34.967  16.885  -0.967  1.00 38.12           C  
ATOM    991  CG  MET A 126      36.438  17.287  -0.977  1.00 38.73           C  
ATOM    992  SD  MET A 126      36.676  19.000  -0.426  1.00 36.33           S  
ATOM    993  CE  MET A 126      36.309  18.789   1.364  1.00 38.85           C  
ATOM    994  N   GLU A 127      36.059  13.608  -1.852  1.00 41.83           N  
ATOM    995  CA  GLU A 127      36.783  12.429  -1.386  1.00 42.90           C  
ATOM    996  C   GLU A 127      38.102  12.780  -0.709  1.00 42.05           C  
ATOM    997  O   GLU A 127      38.710  13.810  -1.001  1.00 41.83           O  
ATOM    998  CB  GLU A 127      37.048  11.493  -2.568  1.00 45.78           C  
ATOM    999  CG  GLU A 127      35.797  11.080  -3.316  1.00 49.22           C  
ATOM   1000  CD  GLU A 127      34.913  10.163  -2.495  1.00 51.42           C  
ATOM   1001  OE1 GLU A 127      34.694  10.447  -1.295  1.00 50.74           O  
ATOM   1002  OE2 GLU A 127      34.431   9.157  -3.058  1.00 53.32           O  
ATOM   1003  N   PRO A 128      38.568  11.913   0.204  1.00 40.92           N  
ATOM   1004  CA  PRO A 128      39.816  12.111   0.939  1.00 39.80           C  
ATOM   1005  C   PRO A 128      41.024  12.382   0.059  1.00 39.24           C  
ATOM   1006  O   PRO A 128      42.026  12.920   0.524  1.00 38.71           O  
ATOM   1007  CB  PRO A 128      39.949  10.823   1.727  1.00 38.68           C  
ATOM   1008  CG  PRO A 128      38.540  10.511   2.041  1.00 40.46           C  
ATOM   1009  CD  PRO A 128      37.868  10.721   0.703  1.00 41.12           C  
ATOM   1010  N   ASP A 129      40.935  12.018  -1.214  1.00 38.75           N  
ATOM   1011  CA  ASP A 129      42.050  12.251  -2.120  1.00 38.60           C  
ATOM   1012  C   ASP A 129      41.871  13.532  -2.931  1.00 37.43           C  
ATOM   1013  O   ASP A 129      42.653  13.822  -3.826  1.00 37.04           O  
ATOM   1014  CB  ASP A 129      42.229  11.059  -3.057  1.00 40.22           C  
ATOM   1015  CG  ASP A 129      41.055  10.860  -3.975  1.00 41.80           C  
ATOM   1016  OD1 ASP A 129      39.911  10.874  -3.482  1.00 43.02           O  
ATOM   1017  OD2 ASP A 129      41.279  10.674  -5.190  1.00 43.65           O  
ATOM   1018  N   HIS A 130      40.836  14.296  -2.608  1.00 35.63           N  
ATOM   1019  CA  HIS A 130      40.574  15.539  -3.307  1.00 34.45           C  
ATOM   1020  C   HIS A 130      41.668  16.527  -2.933  1.00 33.45           C  
ATOM   1021  O   HIS A 130      42.117  16.552  -1.787  1.00 34.17           O  
ATOM   1022  CB  HIS A 130      39.200  16.084  -2.907  1.00 35.60           C  
ATOM   1023  CG  HIS A 130      38.779  17.298  -3.677  1.00 34.76           C  
ATOM   1024  ND1 HIS A 130      39.376  18.530  -3.516  1.00 34.83           N  
ATOM   1025  CD2 HIS A 130      37.825  17.464  -4.618  1.00 33.84           C  
ATOM   1026  CE1 HIS A 130      38.807  19.402  -4.324  1.00 33.73           C  
ATOM   1027  NE2 HIS A 130      37.862  18.781  -5.004  1.00 34.16           N  
ATOM   1028  N   PRO A 131      42.107  17.357  -3.892  1.00 31.82           N  
ATOM   1029  CA  PRO A 131      43.160  18.357  -3.677  1.00 31.38           C  
ATOM   1030  C   PRO A 131      42.938  19.277  -2.483  1.00 31.06           C  
ATOM   1031  O   PRO A 131      43.889  19.836  -1.937  1.00 30.54           O  
ATOM   1032  CB  PRO A 131      43.172  19.132  -4.990  1.00 30.33           C  
ATOM   1033  CG  PRO A 131      42.782  18.107  -5.976  1.00 30.86           C  
ATOM   1034  CD  PRO A 131      41.655  17.378  -5.291  1.00 30.48           C  
ATOM   1035  N   PHE A 132      41.684  19.433  -2.077  1.00 31.26           N  
ATOM   1036  CA  PHE A 132      41.372  20.313  -0.961  1.00 31.12           C  
ATOM   1037  C   PHE A 132      40.723  19.632   0.226  1.00 31.52           C  
ATOM   1038  O   PHE A 132      40.205  20.305   1.110  1.00 31.47           O  
ATOM   1039  CB  PHE A 132      40.493  21.455  -1.448  1.00 28.38           C  
ATOM   1040  CG  PHE A 132      41.174  22.340  -2.428  1.00 27.69           C  
ATOM   1041  CD1 PHE A 132      41.923  23.426  -1.998  1.00 28.26           C  
ATOM   1042  CD2 PHE A 132      41.116  22.063  -3.785  1.00 27.77           C  
ATOM   1043  CE1 PHE A 132      42.609  24.222  -2.906  1.00 27.24           C  
ATOM   1044  CE2 PHE A 132      41.794  22.846  -4.699  1.00 27.41           C  
ATOM   1045  CZ  PHE A 132      42.544  23.930  -4.260  1.00 27.67           C  
ATOM   1046  N   TYR A 133      40.770  18.304   0.261  1.00 32.67           N  
ATOM   1047  CA  TYR A 133      40.171  17.561   1.362  1.00 34.20           C  
ATOM   1048  C   TYR A 133      40.663  18.090   2.711  1.00 34.55           C  
ATOM   1049  O   TYR A 133      39.873  18.582   3.520  1.00 34.32           O  
ATOM   1050  CB  TYR A 133      40.501  16.076   1.246  1.00 35.17           C  
ATOM   1051  CG  TYR A 133      39.878  15.243   2.339  1.00 37.05           C  
ATOM   1052  CD1 TYR A 133      38.509  14.983   2.345  1.00 37.07           C  
ATOM   1053  CD2 TYR A 133      40.654  14.736   3.385  1.00 37.83           C  
ATOM   1054  CE1 TYR A 133      37.918  14.237   3.367  1.00 38.07           C  
ATOM   1055  CE2 TYR A 133      40.075  13.990   4.416  1.00 39.77           C  
ATOM   1056  CZ  TYR A 133      38.703  13.744   4.400  1.00 40.10           C  
ATOM   1057  OH  TYR A 133      38.116  13.013   5.410  1.00 40.30           O  
ATOM   1058  N   SER A 134      41.968  17.993   2.944  1.00 34.28           N  
ATOM   1059  CA  SER A 134      42.557  18.457   4.196  1.00 34.31           C  
ATOM   1060  C   SER A 134      42.362  19.950   4.401  1.00 33.42           C  
ATOM   1061  O   SER A 134      42.005  20.399   5.491  1.00 33.21           O  
ATOM   1062  CB  SER A 134      44.051  18.143   4.220  1.00 35.56           C  
ATOM   1063  OG  SER A 134      44.280  16.771   3.981  1.00 38.45           O  
ATOM   1064  N   ASN A 135      42.609  20.718   3.346  1.00 32.46           N  
ATOM   1065  CA  ASN A 135      42.467  22.162   3.412  1.00 31.89           C  
ATOM   1066  C   ASN A 135      41.113  22.584   3.981  1.00 31.20           C  
ATOM   1067  O   ASN A 135      41.028  23.524   4.765  1.00 29.28           O  
ATOM   1068  CB  ASN A 135      42.670  22.761   2.020  1.00 32.21           C  
ATOM   1069  CG  ASN A 135      42.446  24.261   1.992  1.00 30.75           C  
ATOM   1070  OD1 ASN A 135      41.331  24.742   1.771  1.00 28.28           O  
ATOM   1071  ND2 ASN A 135      43.509  25.005   2.229  1.00 30.26           N  
ATOM   1072  N   ILE A 136      40.057  21.881   3.588  1.00 31.15           N  
ATOM   1073  CA  ILE A 136      38.722  22.196   4.065  1.00 31.98           C  
ATOM   1074  C   ILE A 136      38.332  21.369   5.284  1.00 33.28           C  
ATOM   1075  O   ILE A 136      38.336  21.861   6.405  1.00 33.71           O  
ATOM   1076  CB  ILE A 136      37.640  21.941   2.981  1.00 32.42           C  
ATOM   1077  CG1 ILE A 136      37.975  22.678   1.678  1.00 32.73           C  
ATOM   1078  CG2 ILE A 136      36.285  22.389   3.495  1.00 31.15           C  
ATOM   1079  CD1 ILE A 136      37.874  24.157   1.767  1.00 34.23           C  
ATOM   1080  N   SER A 137      38.003  20.105   5.057  1.00 34.32           N  
ATOM   1081  CA  SER A 137      37.553  19.216   6.122  1.00 35.92           C  
ATOM   1082  C   SER A 137      38.451  19.027   7.347  1.00 36.09           C  
ATOM   1083  O   SER A 137      37.964  18.706   8.435  1.00 36.61           O  
ATOM   1084  CB  SER A 137      37.245  17.847   5.532  1.00 37.11           C  
ATOM   1085  OG  SER A 137      38.435  17.238   5.065  1.00 40.83           O  
ATOM   1086  N   LYS A 138      39.755  19.190   7.196  1.00 35.70           N  
ATOM   1087  CA  LYS A 138      40.611  18.986   8.353  1.00 35.58           C  
ATOM   1088  C   LYS A 138      41.056  20.286   8.984  1.00 35.50           C  
ATOM   1089  O   LYS A 138      41.954  20.286   9.828  1.00 35.94           O  
ATOM   1090  CB  LYS A 138      41.830  18.157   7.973  1.00 35.54           C  
ATOM   1091  CG  LYS A 138      41.488  16.819   7.371  1.00 35.79           C  
ATOM   1092  CD  LYS A 138      40.592  15.993   8.284  1.00 37.10           C  
ATOM   1093  CE  LYS A 138      40.585  14.545   7.807  1.00 39.25           C  
ATOM   1094  NZ  LYS A 138      39.800  13.647   8.682  1.00 42.14           N  
ATOM   1095  N   ASP A 139      40.410  21.383   8.586  1.00 34.79           N  
ATOM   1096  CA  ASP A 139      40.717  22.718   9.096  1.00 32.98           C  
ATOM   1097  C   ASP A 139      40.266  22.851  10.551  1.00 32.89           C  
ATOM   1098  O   ASP A 139      39.102  22.604  10.878  1.00 32.23           O  
ATOM   1099  CB  ASP A 139      40.019  23.772   8.232  1.00 33.46           C  
ATOM   1100  CG  ASP A 139      40.543  25.187   8.470  1.00 33.97           C  
ATOM   1101  OD1 ASP A 139      40.987  25.832   7.499  1.00 34.62           O  
ATOM   1102  OD2 ASP A 139      40.505  25.673   9.614  1.00 33.93           O  
ATOM   1103  N   ARG A 140      41.209  23.227  11.415  1.00 32.65           N  
ATOM   1104  CA  ARG A 140      40.971  23.431  12.848  1.00 32.04           C  
ATOM   1105  C   ARG A 140      39.609  24.095  13.061  1.00 31.59           C  
ATOM   1106  O   ARG A 140      38.868  23.765  13.975  1.00 31.20           O  
ATOM   1107  CB  ARG A 140      42.062  24.341  13.413  1.00 31.99           C  
ATOM   1108  CG  ARG A 140      42.257  24.232  14.905  1.00 35.37           C  
ATOM   1109  CD  ARG A 140      42.705  25.555  15.494  1.00 37.02           C  
ATOM   1110  NE  ARG A 140      43.530  26.327  14.568  1.00 34.48           N  
ATOM   1111  CZ  ARG A 140      43.914  27.577  14.798  1.00 34.54           C  
ATOM   1112  NH1 ARG A 140      43.548  28.183  15.916  1.00 33.92           N  
ATOM   1113  NH2 ARG A 140      44.654  28.226  13.911  1.00 35.08           N  
ATOM   1114  N   ARG A 141      39.322  25.046  12.184  1.00 31.50           N  
ATOM   1115  CA  ARG A 141      38.107  25.845  12.143  1.00 31.17           C  
ATOM   1116  C   ARG A 141      36.803  25.089  12.387  1.00 31.25           C  
ATOM   1117  O   ARG A 141      35.904  25.595  13.049  1.00 29.67           O  
ATOM   1118  CB  ARG A 141      38.069  26.506  10.773  1.00 31.33           C  
ATOM   1119  CG  ARG A 141      36.949  27.452  10.489  1.00 29.12           C  
ATOM   1120  CD  ARG A 141      37.176  27.994   9.097  1.00 27.62           C  
ATOM   1121  NE  ARG A 141      38.607  28.038   8.796  1.00 23.98           N  
ATOM   1122  CZ  ARG A 141      39.153  28.807   7.870  1.00 21.73           C  
ATOM   1123  NH1 ARG A 141      38.405  29.614   7.143  1.00 21.61           N  
ATOM   1124  NH2 ARG A 141      40.450  28.753   7.667  1.00 23.29           N  
ATOM   1125  N   TYR A 142      36.701  23.885  11.838  1.00 32.35           N  
ATOM   1126  CA  TYR A 142      35.488  23.081  11.969  1.00 33.79           C  
ATOM   1127  C   TYR A 142      35.636  21.930  12.958  1.00 34.60           C  
ATOM   1128  O   TYR A 142      34.852  20.988  12.942  1.00 34.83           O  
ATOM   1129  CB  TYR A 142      35.095  22.516  10.600  1.00 32.78           C  
ATOM   1130  CG  TYR A 142      35.055  23.544   9.496  1.00 32.44           C  
ATOM   1131  CD1 TYR A 142      34.086  24.545   9.478  1.00 33.40           C  
ATOM   1132  CD2 TYR A 142      36.001  23.534   8.481  1.00 32.94           C  
ATOM   1133  CE1 TYR A 142      34.067  25.514   8.474  1.00 32.72           C  
ATOM   1134  CE2 TYR A 142      35.991  24.492   7.476  1.00 33.13           C  
ATOM   1135  CZ  TYR A 142      35.023  25.474   7.480  1.00 33.26           C  
ATOM   1136  OH  TYR A 142      35.022  26.417   6.486  1.00 34.46           O  
ATOM   1137  N   ALA A 143      36.638  22.011  13.820  1.00 36.20           N  
ATOM   1138  CA  ALA A 143      36.892  20.962  14.796  1.00 37.71           C  
ATOM   1139  C   ALA A 143      35.692  20.558  15.664  1.00 40.13           C  
ATOM   1140  O   ALA A 143      35.529  19.371  15.984  1.00 40.94           O  
ATOM   1141  CB  ALA A 143      38.048  21.369  15.678  1.00 36.94           C  
ATOM   1142  N   ASP A 144      34.852  21.522  16.043  1.00 41.30           N  
ATOM   1143  CA  ASP A 144      33.702  21.211  16.897  1.00 42.00           C  
ATOM   1144  C   ASP A 144      32.467  20.687  16.168  1.00 42.10           C  
ATOM   1145  O   ASP A 144      31.410  20.518  16.779  1.00 42.56           O  
ATOM   1146  CB  ASP A 144      33.304  22.427  17.750  1.00 42.85           C  
ATOM   1147  CG  ASP A 144      34.426  22.901  18.665  1.00 43.87           C  
ATOM   1148  OD1 ASP A 144      35.164  22.051  19.216  1.00 43.56           O  
ATOM   1149  OD2 ASP A 144      34.557  24.132  18.839  1.00 44.19           O  
ATOM   1150  N   LEU A 145      32.587  20.431  14.868  1.00 41.33           N  
ATOM   1151  CA  LEU A 145      31.452  19.908  14.123  1.00 40.09           C  
ATOM   1152  C   LEU A 145      31.418  18.406  14.316  1.00 40.90           C  
ATOM   1153  O   LEU A 145      32.455  17.742  14.250  1.00 40.52           O  
ATOM   1154  CB  LEU A 145      31.563  20.240  12.633  1.00 38.60           C  
ATOM   1155  CG  LEU A 145      31.428  21.707  12.222  1.00 37.36           C  
ATOM   1156  CD1 LEU A 145      31.226  21.819  10.722  1.00 36.34           C  
ATOM   1157  CD2 LEU A 145      30.241  22.301  12.925  1.00 37.19           C  
ATOM   1158  N   THR A 146      30.225  17.878  14.575  1.00 42.72           N  
ATOM   1159  CA  THR A 146      30.038  16.444  14.773  1.00 43.15           C  
ATOM   1160  C   THR A 146      30.292  15.771  13.423  1.00 44.35           C  
ATOM   1161  O   THR A 146      30.167  16.411  12.374  1.00 44.68           O  
ATOM   1162  CB  THR A 146      28.591  16.119  15.254  1.00 43.24           C  
ATOM   1163  OG1 THR A 146      27.668  16.303  14.175  1.00 44.44           O  
ATOM   1164  CG2 THR A 146      28.173  17.045  16.392  1.00 41.78           C  
ATOM   1165  N   GLU A 147      30.654  14.492  13.444  1.00 45.15           N  
ATOM   1166  CA  GLU A 147      30.926  13.764  12.209  1.00 45.91           C  
ATOM   1167  C   GLU A 147      29.825  13.992  11.166  1.00 46.80           C  
ATOM   1168  O   GLU A 147      30.076  13.948   9.956  1.00 46.30           O  
ATOM   1169  CB  GLU A 147      31.080  12.272  12.507  1.00 44.92           C  
ATOM   1170  N   ASP A 148      28.616  14.267  11.640  1.00 47.64           N  
ATOM   1171  CA  ASP A 148      27.476  14.487  10.764  1.00 49.15           C  
ATOM   1172  C   ASP A 148      27.391  15.905  10.237  1.00 48.28           C  
ATOM   1173  O   ASP A 148      27.008  16.121   9.095  1.00 49.77           O  
ATOM   1174  CB  ASP A 148      26.187  14.170  11.504  1.00 52.38           C  
ATOM   1175  CG  ASP A 148      26.237  12.832  12.181  1.00 56.56           C  
ATOM   1176  OD1 ASP A 148      26.380  11.820  11.456  1.00 57.86           O  
ATOM   1177  OD2 ASP A 148      26.144  12.797  13.433  1.00 59.37           O  
ATOM   1178  N   GLN A 149      27.737  16.869  11.077  1.00 46.27           N  
ATOM   1179  CA  GLN A 149      27.673  18.271  10.696  1.00 44.30           C  
ATOM   1180  C   GLN A 149      28.637  18.656   9.578  1.00 43.43           C  
ATOM   1181  O   GLN A 149      28.246  19.340   8.630  1.00 43.31           O  
ATOM   1182  CB  GLN A 149      27.928  19.149  11.920  1.00 44.36           C  
ATOM   1183  CG  GLN A 149      26.981  18.870  13.067  1.00 42.87           C  
ATOM   1184  CD  GLN A 149      27.184  19.812  14.222  1.00 41.71           C  
ATOM   1185  OE1 GLN A 149      28.297  19.981  14.709  1.00 41.95           O  
ATOM   1186  NE2 GLN A 149      26.105  20.432  14.673  1.00 41.55           N  
ATOM   1187  N   LEU A 150      29.893  18.229   9.689  1.00 41.72           N  
ATOM   1188  CA  LEU A 150      30.888  18.548   8.676  1.00 39.33           C  
ATOM   1189  C   LEU A 150      30.442  17.879   7.397  1.00 37.98           C  
ATOM   1190  O   LEU A 150      30.456  16.656   7.298  1.00 40.10           O  
ATOM   1191  CB  LEU A 150      32.259  18.017   9.089  1.00 39.00           C  
ATOM   1192  CG  LEU A 150      33.501  18.563   8.374  1.00 39.20           C  
ATOM   1193  CD1 LEU A 150      33.458  18.223   6.910  1.00 39.41           C  
ATOM   1194  CD2 LEU A 150      33.584  20.066   8.563  1.00 39.72           C  
ATOM   1195  N   PRO A 151      30.029  18.667   6.400  1.00 36.09           N  
ATOM   1196  CA  PRO A 151      29.582  18.083   5.137  1.00 34.70           C  
ATOM   1197  C   PRO A 151      30.724  17.793   4.183  1.00 33.70           C  
ATOM   1198  O   PRO A 151      31.813  18.347   4.312  1.00 32.54           O  
ATOM   1199  CB  PRO A 151      28.646  19.148   4.593  1.00 35.74           C  
ATOM   1200  CG  PRO A 151      29.344  20.401   4.994  1.00 35.87           C  
ATOM   1201  CD  PRO A 151      29.791  20.120   6.416  1.00 35.63           C  
ATOM   1202  N   SER A 152      30.467  16.909   3.228  1.00 33.54           N  
ATOM   1203  CA  SER A 152      31.456  16.557   2.223  1.00 32.87           C  
ATOM   1204  C   SER A 152      30.931  17.131   0.919  1.00 32.21           C  
ATOM   1205  O   SER A 152      31.601  17.110  -0.110  1.00 31.26           O  
ATOM   1206  CB  SER A 152      31.602  15.037   2.115  1.00 32.49           C  
ATOM   1207  OG  SER A 152      30.390  14.445   1.703  1.00 33.89           O  
ATOM   1208  N   CYS A 153      29.707  17.642   0.990  1.00 33.20           N  
ATOM   1209  CA  CYS A 153      29.023  18.254  -0.145  1.00 33.37           C  
ATOM   1210  C   CYS A 153      27.634  18.681   0.315  1.00 32.66           C  
ATOM   1211  O   CYS A 153      27.097  18.128   1.268  1.00 33.60           O  
ATOM   1212  CB  CYS A 153      28.914  17.267  -1.307  1.00 33.80           C  
ATOM   1213  SG  CYS A 153      28.077  15.741  -0.897  1.00 32.85           S  
ATOM   1214  N   GLU A 154      27.060  19.672  -0.351  1.00 32.14           N  
ATOM   1215  CA  GLU A 154      25.744  20.168   0.016  1.00 31.15           C  
ATOM   1216  C   GLU A 154      24.916  20.582  -1.188  1.00 31.23           C  
ATOM   1217  O   GLU A 154      25.440  21.112  -2.168  1.00 30.80           O  
ATOM   1218  CB  GLU A 154      25.859  21.391   0.925  1.00 30.19           C  
ATOM   1219  CG  GLU A 154      26.449  21.154   2.282  1.00 31.02           C  
ATOM   1220  CD  GLU A 154      26.394  22.404   3.142  1.00 31.28           C  
ATOM   1221  OE1 GLU A 154      26.889  23.454   2.677  1.00 30.84           O  
ATOM   1222  OE2 GLU A 154      25.857  22.340   4.275  1.00 30.03           O  
ATOM   1223  N   SER A 155      23.616  20.335  -1.097  1.00 30.42           N  
ATOM   1224  CA  SER A 155      22.689  20.740  -2.134  1.00 29.87           C  
ATOM   1225  C   SER A 155      22.197  22.061  -1.574  1.00 28.78           C  
ATOM   1226  O   SER A 155      22.377  22.322  -0.384  1.00 28.84           O  
ATOM   1227  CB  SER A 155      21.534  19.741  -2.242  1.00 30.71           C  
ATOM   1228  OG  SER A 155      20.801  19.661  -1.030  1.00 29.52           O  
ATOM   1229  N   LEU A 156      21.608  22.917  -2.400  1.00 26.93           N  
ATOM   1230  CA  LEU A 156      21.125  24.179  -1.855  1.00 23.89           C  
ATOM   1231  C   LEU A 156      20.304  23.834  -0.611  1.00 22.73           C  
ATOM   1232  O   LEU A 156      20.475  24.428   0.455  1.00 22.46           O  
ATOM   1233  CB  LEU A 156      20.272  24.924  -2.877  1.00 20.93           C  
ATOM   1234  CG  LEU A 156      19.843  26.312  -2.408  1.00 22.52           C  
ATOM   1235  CD1 LEU A 156      21.047  27.092  -1.859  1.00 19.85           C  
ATOM   1236  CD2 LEU A 156      19.182  27.038  -3.571  1.00 22.92           C  
ATOM   1237  N   LYS A 157      19.450  22.828  -0.755  1.00 21.79           N  
ATOM   1238  CA  LYS A 157      18.593  22.363   0.326  1.00 21.06           C  
ATOM   1239  C   LYS A 157      19.358  22.058   1.616  1.00 20.06           C  
ATOM   1240  O   LYS A 157      18.889  22.400   2.705  1.00 18.44           O  
ATOM   1241  CB  LYS A 157      17.811  21.132  -0.131  1.00 21.30           C  
ATOM   1242  CG  LYS A 157      16.796  20.651   0.861  1.00 22.33           C  
ATOM   1243  CD  LYS A 157      16.137  19.372   0.402  1.00 24.64           C  
ATOM   1244  CE  LYS A 157      15.494  18.654   1.590  1.00 27.64           C  
ATOM   1245  NZ  LYS A 157      14.876  17.327   1.248  1.00 31.56           N  
ATOM   1246  N   ASP A 158      20.522  21.419   1.503  1.00 19.53           N  
ATOM   1247  CA  ASP A 158      21.315  21.116   2.697  1.00 20.74           C  
ATOM   1248  C   ASP A 158      21.785  22.414   3.342  1.00 21.69           C  
ATOM   1249  O   ASP A 158      21.595  22.624   4.548  1.00 22.61           O  
ATOM   1250  CB  ASP A 158      22.537  20.261   2.364  1.00 20.29           C  
ATOM   1251  CG  ASP A 158      22.170  18.883   1.866  1.00 20.75           C  
ATOM   1252  OD1 ASP A 158      21.292  18.234   2.480  1.00 20.22           O  
ATOM   1253  OD2 ASP A 158      22.773  18.446   0.864  1.00 21.60           O  
ATOM   1254  N   THR A 159      22.403  23.278   2.539  1.00 21.10           N  
ATOM   1255  CA  THR A 159      22.878  24.573   3.025  1.00 21.92           C  
ATOM   1256  C   THR A 159      21.800  25.252   3.881  1.00 22.18           C  
ATOM   1257  O   THR A 159      22.015  25.549   5.066  1.00 21.91           O  
ATOM   1258  CB  THR A 159      23.211  25.519   1.857  1.00 21.47           C  
ATOM   1259  OG1 THR A 159      23.943  24.797   0.868  1.00 24.66           O  
ATOM   1260  CG2 THR A 159      24.048  26.694   2.336  1.00 17.44           C  
ATOM   1261  N   ILE A 160      20.644  25.505   3.268  1.00 21.18           N  
ATOM   1262  CA  ILE A 160      19.542  26.133   3.973  1.00 21.04           C  
ATOM   1263  C   ILE A 160      19.273  25.396   5.282  1.00 21.42           C  
ATOM   1264  O   ILE A 160      19.094  26.024   6.322  1.00 21.62           O  
ATOM   1265  CB  ILE A 160      18.275  26.148   3.100  1.00 20.49           C  
ATOM   1266  CG1 ILE A 160      18.522  27.020   1.864  1.00 20.93           C  
ATOM   1267  CG2 ILE A 160      17.107  26.672   3.890  1.00 17.80           C  
ATOM   1268  CD1 ILE A 160      17.345  27.144   0.934  1.00 19.20           C  
ATOM   1269  N   ALA A 161      19.282  24.064   5.220  1.00 22.43           N  
ATOM   1270  CA  ALA A 161      19.047  23.197   6.380  1.00 22.02           C  
ATOM   1271  C   ALA A 161      19.941  23.497   7.582  1.00 23.38           C  
ATOM   1272  O   ALA A 161      19.476  23.435   8.724  1.00 22.86           O  
ATOM   1273  CB  ALA A 161      19.212  21.749   5.978  1.00 20.51           C  
ATOM   1274  N   ARG A 162      21.218  23.802   7.338  1.00 23.66           N  
ATOM   1275  CA  ARG A 162      22.129  24.112   8.441  1.00 24.80           C  
ATOM   1276  C   ARG A 162      22.332  25.602   8.709  1.00 25.85           C  
ATOM   1277  O   ARG A 162      23.102  25.974   9.605  1.00 27.15           O  
ATOM   1278  CB  ARG A 162      23.495  23.438   8.242  1.00 23.36           C  
ATOM   1279  CG  ARG A 162      24.158  23.607   6.869  1.00 23.91           C  
ATOM   1280  CD  ARG A 162      24.750  24.987   6.629  1.00 22.18           C  
ATOM   1281  NE  ARG A 162      25.680  24.958   5.501  1.00 22.40           N  
ATOM   1282  CZ  ARG A 162      26.298  26.024   4.989  1.00 22.21           C  
ATOM   1283  NH1 ARG A 162      26.092  27.233   5.493  1.00 23.93           N  
ATOM   1284  NH2 ARG A 162      27.133  25.880   3.974  1.00 21.11           N  
ATOM   1285  N   ALA A 163      21.651  26.454   7.944  1.00 26.01           N  
ATOM   1286  CA  ALA A 163      21.772  27.900   8.130  1.00 25.21           C  
ATOM   1287  C   ALA A 163      20.591  28.396   8.937  1.00 25.76           C  
ATOM   1288  O   ALA A 163      20.748  29.193   9.857  1.00 25.74           O  
ATOM   1289  CB  ALA A 163      21.820  28.608   6.789  1.00 24.87           C  
ATOM   1290  N   LEU A 164      19.401  27.904   8.609  1.00 26.76           N  
ATOM   1291  CA  LEU A 164      18.201  28.325   9.323  1.00 27.42           C  
ATOM   1292  C   LEU A 164      18.261  28.077  10.837  1.00 25.85           C  
ATOM   1293  O   LEU A 164      17.890  28.939  11.631  1.00 26.17           O  
ATOM   1294  CB  LEU A 164      16.960  27.673   8.700  1.00 29.07           C  
ATOM   1295  CG  LEU A 164      16.409  28.444   7.484  1.00 30.98           C  
ATOM   1296  CD1 LEU A 164      15.977  29.836   7.906  1.00 32.53           C  
ATOM   1297  CD2 LEU A 164      17.476  28.574   6.406  1.00 33.35           C  
ATOM   1298  N   PRO A 165      18.729  26.902  11.258  1.00 24.02           N  
ATOM   1299  CA  PRO A 165      18.782  26.703  12.705  1.00 22.81           C  
ATOM   1300  C   PRO A 165      19.571  27.830  13.387  1.00 22.47           C  
ATOM   1301  O   PRO A 165      19.277  28.221  14.510  1.00 22.41           O  
ATOM   1302  CB  PRO A 165      19.472  25.349  12.841  1.00 23.51           C  
ATOM   1303  CG  PRO A 165      19.047  24.625  11.601  1.00 24.49           C  
ATOM   1304  CD  PRO A 165      19.148  25.692  10.530  1.00 24.62           C  
ATOM   1305  N   PHE A 166      20.577  28.370  12.713  1.00 22.93           N  
ATOM   1306  CA  PHE A 166      21.351  29.440  13.334  1.00 23.20           C  
ATOM   1307  C   PHE A 166      20.467  30.670  13.337  1.00 23.77           C  
ATOM   1308  O   PHE A 166      20.315  31.354  14.344  1.00 23.47           O  
ATOM   1309  CB  PHE A 166      22.631  29.726  12.546  1.00 20.97           C  
ATOM   1310  CG  PHE A 166      23.516  30.764  13.186  1.00 19.11           C  
ATOM   1311  CD1 PHE A 166      24.420  30.411  14.173  1.00 17.31           C  
ATOM   1312  CD2 PHE A 166      23.454  32.098  12.784  1.00 19.28           C  
ATOM   1313  CE1 PHE A 166      25.251  31.366  14.748  1.00 17.31           C  
ATOM   1314  CE2 PHE A 166      24.285  33.061  13.355  1.00 17.26           C  
ATOM   1315  CZ  PHE A 166      25.184  32.696  14.334  1.00 17.10           C  
ATOM   1316  N   TRP A 167      19.883  30.934  12.182  1.00 24.39           N  
ATOM   1317  CA  TRP A 167      18.996  32.062  12.018  1.00 25.55           C  
ATOM   1318  C   TRP A 167      17.920  32.087  13.091  1.00 26.53           C  
ATOM   1319  O   TRP A 167      17.702  33.102  13.737  1.00 27.05           O  
ATOM   1320  CB  TRP A 167      18.349  31.992  10.640  1.00 24.52           C  
ATOM   1321  CG  TRP A 167      17.111  32.773  10.546  1.00 22.75           C  
ATOM   1322  CD1 TRP A 167      15.845  32.330  10.771  1.00 20.87           C  
ATOM   1323  CD2 TRP A 167      17.005  34.146  10.177  1.00 22.96           C  
ATOM   1324  NE1 TRP A 167      14.947  33.345  10.554  1.00 22.02           N  
ATOM   1325  CE2 TRP A 167      15.636  34.474  10.185  1.00 22.63           C  
ATOM   1326  CE3 TRP A 167      17.937  35.137   9.837  1.00 22.32           C  
ATOM   1327  CZ2 TRP A 167      15.170  35.757   9.860  1.00 22.40           C  
ATOM   1328  CZ3 TRP A 167      17.473  36.413   9.515  1.00 22.19           C  
ATOM   1329  CH2 TRP A 167      16.103  36.708   9.528  1.00 21.18           C  
ATOM   1330  N   ASN A 168      17.243  30.967  13.288  1.00 27.92           N  
ATOM   1331  CA  ASN A 168      16.188  30.941  14.282  1.00 30.45           C  
ATOM   1332  C   ASN A 168      16.676  31.014  15.715  1.00 31.62           C  
ATOM   1333  O   ASN A 168      16.171  31.817  16.496  1.00 32.74           O  
ATOM   1334  CB  ASN A 168      15.320  29.707  14.089  1.00 30.98           C  
ATOM   1335  CG  ASN A 168      14.626  29.705  12.749  1.00 33.78           C  
ATOM   1336  OD1 ASN A 168      13.901  30.645  12.409  1.00 35.73           O  
ATOM   1337  ND2 ASN A 168      14.848  28.653  11.968  1.00 36.15           N  
ATOM   1338  N   GLU A 169      17.664  30.195  16.061  1.00 32.32           N  
ATOM   1339  CA  GLU A 169      18.183  30.168  17.422  1.00 32.85           C  
ATOM   1340  C   GLU A 169      19.026  31.364  17.851  1.00 33.77           C  
ATOM   1341  O   GLU A 169      18.959  31.778  18.996  1.00 34.59           O  
ATOM   1342  CB  GLU A 169      18.979  28.880  17.646  1.00 32.03           C  
ATOM   1343  CG  GLU A 169      18.123  27.618  17.551  1.00 35.54           C  
ATOM   1344  CD  GLU A 169      18.897  26.325  17.839  1.00 39.04           C  
ATOM   1345  OE1 GLU A 169      19.779  25.946  17.035  1.00 40.17           O  
ATOM   1346  OE2 GLU A 169      18.623  25.680  18.880  1.00 41.57           O  
ATOM   1347  N   GLU A 170      19.789  31.947  16.938  1.00 35.81           N  
ATOM   1348  CA  GLU A 170      20.677  33.042  17.294  1.00 36.23           C  
ATOM   1349  C   GLU A 170      20.342  34.424  16.776  1.00 36.25           C  
ATOM   1350  O   GLU A 170      20.454  35.399  17.508  1.00 37.65           O  
ATOM   1351  CB  GLU A 170      22.089  32.710  16.839  1.00 38.50           C  
ATOM   1352  CG  GLU A 170      22.573  31.345  17.241  1.00 41.68           C  
ATOM   1353  CD  GLU A 170      22.583  31.161  18.743  1.00 43.95           C  
ATOM   1354  OE1 GLU A 170      23.193  31.994  19.443  1.00 44.53           O  
ATOM   1355  OE2 GLU A 170      21.979  30.180  19.227  1.00 46.12           O  
ATOM   1356  N   ILE A 171      19.963  34.518  15.510  1.00 35.36           N  
ATOM   1357  CA  ILE A 171      19.663  35.810  14.916  1.00 35.03           C  
ATOM   1358  C   ILE A 171      18.271  36.354  15.231  1.00 35.69           C  
ATOM   1359  O   ILE A 171      18.138  37.482  15.710  1.00 36.66           O  
ATOM   1360  CB  ILE A 171      19.860  35.755  13.395  1.00 34.63           C  
ATOM   1361  CG1 ILE A 171      21.267  35.239  13.088  1.00 34.59           C  
ATOM   1362  CG2 ILE A 171      19.662  37.136  12.793  1.00 34.31           C  
ATOM   1363  CD1 ILE A 171      21.565  35.078  11.611  1.00 34.56           C  
ATOM   1364  N   VAL A 172      17.235  35.563  14.970  1.00 35.40           N  
ATOM   1365  CA  VAL A 172      15.866  35.996  15.230  1.00 35.15           C  
ATOM   1366  C   VAL A 172      15.707  36.645  16.610  1.00 35.38           C  
ATOM   1367  O   VAL A 172      15.170  37.749  16.728  1.00 34.77           O  
ATOM   1368  CB  VAL A 172      14.882  34.815  15.097  1.00 35.06           C  
ATOM   1369  CG1 VAL A 172      13.495  35.231  15.559  1.00 33.98           C  
ATOM   1370  CG2 VAL A 172      14.825  34.358  13.650  1.00 35.06           C  
ATOM   1371  N   PRO A 173      16.175  35.970  17.672  1.00 34.93           N  
ATOM   1372  CA  PRO A 173      16.054  36.542  19.014  1.00 35.45           C  
ATOM   1373  C   PRO A 173      16.539  37.985  19.048  1.00 36.11           C  
ATOM   1374  O   PRO A 173      15.847  38.869  19.552  1.00 36.89           O  
ATOM   1375  CB  PRO A 173      16.929  35.626  19.856  1.00 35.02           C  
ATOM   1376  CG  PRO A 173      16.760  34.315  19.177  1.00 34.97           C  
ATOM   1377  CD  PRO A 173      16.870  34.674  17.720  1.00 34.44           C  
ATOM   1378  N   GLN A 174      17.730  38.214  18.502  1.00 36.09           N  
ATOM   1379  CA  GLN A 174      18.316  39.549  18.462  1.00 37.15           C  
ATOM   1380  C   GLN A 174      17.404  40.549  17.781  1.00 37.09           C  
ATOM   1381  O   GLN A 174      17.177  41.634  18.302  1.00 37.68           O  
ATOM   1382  CB  GLN A 174      19.648  39.530  17.715  1.00 38.28           C  
ATOM   1383  CG  GLN A 174      20.745  38.705  18.370  1.00 38.84           C  
ATOM   1384  CD  GLN A 174      21.131  39.225  19.729  1.00 37.92           C  
ATOM   1385  OE1 GLN A 174      21.310  40.428  19.919  1.00 37.76           O  
ATOM   1386  NE2 GLN A 174      21.274  38.319  20.682  1.00 37.70           N  
ATOM   1387  N   ILE A 175      16.901  40.187  16.606  1.00 37.37           N  
ATOM   1388  CA  ILE A 175      16.015  41.061  15.854  1.00 38.49           C  
ATOM   1389  C   ILE A 175      14.791  41.416  16.679  1.00 39.80           C  
ATOM   1390  O   ILE A 175      14.366  42.574  16.705  1.00 40.14           O  
ATOM   1391  CB  ILE A 175      15.539  40.397  14.553  1.00 38.16           C  
ATOM   1392  CG1 ILE A 175      16.743  40.036  13.684  1.00 38.66           C  
ATOM   1393  CG2 ILE A 175      14.604  41.334  13.811  1.00 38.15           C  
ATOM   1394  CD1 ILE A 175      16.380  39.391  12.355  1.00 37.71           C  
ATOM   1395  N   LYS A 176      14.232  40.415  17.353  1.00 41.32           N  
ATOM   1396  CA  LYS A 176      13.052  40.621  18.181  1.00 42.58           C  
ATOM   1397  C   LYS A 176      13.315  41.536  19.373  1.00 43.00           C  
ATOM   1398  O   LYS A 176      12.395  42.194  19.839  1.00 44.22           O  
ATOM   1399  CB  LYS A 176      12.489  39.280  18.661  1.00 43.57           C  
ATOM   1400  CG  LYS A 176      11.642  38.556  17.620  1.00 44.97           C  
ATOM   1401  CD  LYS A 176      11.153  37.203  18.129  1.00 46.50           C  
ATOM   1402  CE  LYS A 176      10.246  36.517  17.099  1.00 48.18           C  
ATOM   1403  NZ  LYS A 176       9.872  35.113  17.477  1.00 49.04           N  
ATOM   1404  N   GLU A 177      14.554  41.585  19.871  1.00 43.28           N  
ATOM   1405  CA  GLU A 177      14.913  42.455  21.008  1.00 42.95           C  
ATOM   1406  C   GLU A 177      15.198  43.874  20.517  1.00 42.13           C  
ATOM   1407  O   GLU A 177      15.709  44.705  21.257  1.00 42.12           O  
ATOM   1408  CB  GLU A 177      16.176  41.960  21.717  1.00 45.90           C  
ATOM   1409  CG  GLU A 177      16.124  40.558  22.307  1.00 51.31           C  
ATOM   1410  CD  GLU A 177      17.521  40.037  22.685  1.00 54.19           C  
ATOM   1411  OE1 GLU A 177      18.233  40.726  23.455  1.00 55.14           O  
ATOM   1412  OE2 GLU A 177      17.906  38.940  22.210  1.00 55.73           O  
ATOM   1413  N   GLY A 178      14.903  44.136  19.253  1.00 41.46           N  
ATOM   1414  CA  GLY A 178      15.124  45.460  18.694  1.00 39.91           C  
ATOM   1415  C   GLY A 178      16.519  45.753  18.186  1.00 38.52           C  
ATOM   1416  O   GLY A 178      16.790  46.866  17.746  1.00 39.54           O  
ATOM   1417  N   LYS A 179      17.410  44.773  18.245  1.00 36.68           N  
ATOM   1418  CA  LYS A 179      18.768  44.976  17.771  1.00 35.27           C  
ATOM   1419  C   LYS A 179      18.801  45.056  16.245  1.00 32.96           C  
ATOM   1420  O   LYS A 179      18.229  44.198  15.567  1.00 31.95           O  
ATOM   1421  CB  LYS A 179      19.650  43.831  18.254  1.00 36.83           C  
ATOM   1422  CG  LYS A 179      19.667  43.684  19.755  1.00 39.41           C  
ATOM   1423  CD  LYS A 179      20.286  44.903  20.416  1.00 42.52           C  
ATOM   1424  CE  LYS A 179      20.274  44.771  21.931  1.00 44.91           C  
ATOM   1425  NZ  LYS A 179      20.893  43.481  22.363  1.00 46.88           N  
ATOM   1426  N   ARG A 180      19.439  46.091  15.704  1.00 29.98           N  
ATOM   1427  CA  ARG A 180      19.535  46.224  14.255  1.00 28.90           C  
ATOM   1428  C   ARG A 180      20.673  45.332  13.779  1.00 27.69           C  
ATOM   1429  O   ARG A 180      21.849  45.618  14.013  1.00 26.83           O  
ATOM   1430  CB  ARG A 180      19.793  47.674  13.850  1.00 29.40           C  
ATOM   1431  CG  ARG A 180      18.688  48.612  14.257  1.00 27.61           C  
ATOM   1432  CD  ARG A 180      19.050  49.360  15.514  1.00 29.10           C  
ATOM   1433  NE  ARG A 180      19.606  50.675  15.215  1.00 28.95           N  
ATOM   1434  CZ  ARG A 180      20.419  51.348  16.024  1.00 30.82           C  
ATOM   1435  NH1 ARG A 180      20.790  50.837  17.190  1.00 30.13           N  
ATOM   1436  NH2 ARG A 180      20.855  52.545  15.667  1.00 31.92           N  
ATOM   1437  N   VAL A 181      20.299  44.249  13.106  1.00 25.78           N  
ATOM   1438  CA  VAL A 181      21.240  43.252  12.634  1.00 24.18           C  
ATOM   1439  C   VAL A 181      21.792  43.465  11.233  1.00 23.85           C  
ATOM   1440  O   VAL A 181      21.105  43.951  10.338  1.00 23.62           O  
ATOM   1441  CB  VAL A 181      20.591  41.842  12.688  1.00 23.96           C  
ATOM   1442  CG1 VAL A 181      21.548  40.787  12.141  1.00 24.17           C  
ATOM   1443  CG2 VAL A 181      20.206  41.509  14.107  1.00 23.67           C  
ATOM   1444  N   LEU A 182      23.053  43.086  11.070  1.00 22.48           N  
ATOM   1445  CA  LEU A 182      23.743  43.149   9.801  1.00 21.34           C  
ATOM   1446  C   LEU A 182      24.344  41.766   9.568  1.00 22.07           C  
ATOM   1447  O   LEU A 182      25.116  41.269  10.391  1.00 21.95           O  
ATOM   1448  CB  LEU A 182      24.859  44.184   9.838  1.00 19.43           C  
ATOM   1449  CG  LEU A 182      25.809  44.134   8.639  1.00 18.42           C  
ATOM   1450  CD1 LEU A 182      25.029  44.191   7.349  1.00 17.37           C  
ATOM   1451  CD2 LEU A 182      26.792  45.271   8.719  1.00 17.93           C  
ATOM   1452  N   ILE A 183      23.974  41.135   8.458  1.00 22.34           N  
ATOM   1453  CA  ILE A 183      24.499  39.814   8.132  1.00 22.06           C  
ATOM   1454  C   ILE A 183      25.328  39.857   6.845  1.00 21.67           C  
ATOM   1455  O   ILE A 183      24.817  40.152   5.774  1.00 21.32           O  
ATOM   1456  CB  ILE A 183      23.369  38.769   7.946  1.00 21.17           C  
ATOM   1457  CG1 ILE A 183      22.494  38.701   9.200  1.00 20.74           C  
ATOM   1458  CG2 ILE A 183      23.979  37.402   7.680  1.00 20.25           C  
ATOM   1459  CD1 ILE A 183      21.299  37.772   9.074  1.00 18.63           C  
ATOM   1460  N   ALA A 184      26.618  39.575   6.969  1.00 22.32           N  
ATOM   1461  CA  ALA A 184      27.521  39.554   5.824  1.00 22.18           C  
ATOM   1462  C   ALA A 184      27.818  38.081   5.564  1.00 23.25           C  
ATOM   1463  O   ALA A 184      28.529  37.430   6.352  1.00 21.84           O  
ATOM   1464  CB  ALA A 184      28.797  40.300   6.154  1.00 20.97           C  
ATOM   1465  N   ALA A 185      27.268  37.548   4.474  1.00 22.43           N  
ATOM   1466  CA  ALA A 185      27.470  36.143   4.179  1.00 23.98           C  
ATOM   1467  C   ALA A 185      27.666  35.818   2.703  1.00 25.03           C  
ATOM   1468  O   ALA A 185      28.204  36.629   1.944  1.00 25.01           O  
ATOM   1469  CB  ALA A 185      26.308  35.313   4.752  1.00 23.22           C  
ATOM   1470  N   HIS A 186      27.219  34.623   2.313  1.00 24.62           N  
ATOM   1471  CA  HIS A 186      27.378  34.135   0.959  1.00 25.25           C  
ATOM   1472  C   HIS A 186      26.067  33.962   0.225  1.00 26.95           C  
ATOM   1473  O   HIS A 186      24.995  33.944   0.832  1.00 26.82           O  
ATOM   1474  CB  HIS A 186      28.111  32.808   1.002  1.00 24.77           C  
ATOM   1475  CG  HIS A 186      29.301  32.824   1.901  1.00 26.22           C  
ATOM   1476  ND1 HIS A 186      30.565  33.144   1.457  1.00 27.20           N  
ATOM   1477  CD2 HIS A 186      29.408  32.632   3.238  1.00 26.66           C  
ATOM   1478  CE1 HIS A 186      31.401  33.151   2.480  1.00 27.98           C  
ATOM   1479  NE2 HIS A 186      30.722  32.844   3.573  1.00 28.45           N  
ATOM   1480  N   GLY A 187      26.168  33.820  -1.094  1.00 27.38           N  
ATOM   1481  CA  GLY A 187      24.987  33.644  -1.913  1.00 27.62           C  
ATOM   1482  C   GLY A 187      23.991  32.615  -1.404  1.00 28.07           C  
ATOM   1483  O   GLY A 187      22.843  32.944  -1.121  1.00 27.77           O  
ATOM   1484  N   ASN A 188      24.423  31.366  -1.264  1.00 29.37           N  
ATOM   1485  CA  ASN A 188      23.519  30.308  -0.826  1.00 29.51           C  
ATOM   1486  C   ASN A 188      23.047  30.371   0.625  1.00 28.53           C  
ATOM   1487  O   ASN A 188      21.893  30.062   0.918  1.00 27.75           O  
ATOM   1488  CB  ASN A 188      24.135  28.943  -1.138  1.00 30.98           C  
ATOM   1489  CG  ASN A 188      24.369  28.749  -2.628  1.00 33.59           C  
ATOM   1490  OD1 ASN A 188      23.467  28.972  -3.441  1.00 34.33           O  
ATOM   1491  ND2 ASN A 188      25.582  28.338  -2.996  1.00 34.17           N  
ATOM   1492  N   SER A 189      23.912  30.771   1.543  1.00 27.45           N  
ATOM   1493  CA  SER A 189      23.462  30.856   2.916  1.00 27.62           C  
ATOM   1494  C   SER A 189      22.444  31.982   2.994  1.00 27.86           C  
ATOM   1495  O   SER A 189      21.406  31.834   3.622  1.00 28.65           O  
ATOM   1496  CB  SER A 189      24.638  31.112   3.849  1.00 27.30           C  
ATOM   1497  OG  SER A 189      25.431  32.178   3.369  1.00 29.24           O  
ATOM   1498  N   LEU A 190      22.726  33.103   2.336  1.00 28.42           N  
ATOM   1499  CA  LEU A 190      21.803  34.235   2.346  1.00 28.18           C  
ATOM   1500  C   LEU A 190      20.476  33.838   1.722  1.00 29.24           C  
ATOM   1501  O   LEU A 190      19.416  34.298   2.148  1.00 29.08           O  
ATOM   1502  CB  LEU A 190      22.399  35.426   1.602  1.00 26.48           C  
ATOM   1503  CG  LEU A 190      23.460  36.151   2.420  1.00 25.34           C  
ATOM   1504  CD1 LEU A 190      24.061  37.281   1.609  1.00 27.14           C  
ATOM   1505  CD2 LEU A 190      22.832  36.684   3.685  1.00 24.97           C  
ATOM   1506  N   ARG A 191      20.537  32.983   0.706  1.00 29.89           N  
ATOM   1507  CA  ARG A 191      19.326  32.507   0.058  1.00 31.02           C  
ATOM   1508  C   ARG A 191      18.442  31.855   1.110  1.00 31.38           C  
ATOM   1509  O   ARG A 191      17.227  32.040   1.119  1.00 31.52           O  
ATOM   1510  CB  ARG A 191      19.661  31.475  -1.006  1.00 32.09           C  
ATOM   1511  CG  ARG A 191      19.868  32.027  -2.390  1.00 34.64           C  
ATOM   1512  CD  ARG A 191      20.152  30.886  -3.325  1.00 35.12           C  
ATOM   1513  NE  ARG A 191      20.175  31.289  -4.721  1.00 36.96           N  
ATOM   1514  CZ  ARG A 191      20.466  30.455  -5.711  1.00 39.39           C  
ATOM   1515  NH1 ARG A 191      20.757  29.190  -5.441  1.00 40.04           N  
ATOM   1516  NH2 ARG A 191      20.464  30.878  -6.968  1.00 39.98           N  
ATOM   1517  N   GLY A 192      19.067  31.078   1.990  1.00 31.58           N  
ATOM   1518  CA  GLY A 192      18.334  30.416   3.048  1.00 31.14           C  
ATOM   1519  C   GLY A 192      17.516  31.418   3.835  1.00 32.12           C  
ATOM   1520  O   GLY A 192      16.320  31.209   4.042  1.00 32.12           O  
ATOM   1521  N   ILE A 193      18.153  32.502   4.282  1.00 32.20           N  
ATOM   1522  CA  ILE A 193      17.442  33.534   5.033  1.00 32.18           C  
ATOM   1523  C   ILE A 193      16.316  34.108   4.170  1.00 32.54           C  
ATOM   1524  O   ILE A 193      15.160  34.131   4.592  1.00 32.77           O  
ATOM   1525  CB  ILE A 193      18.380  34.698   5.483  1.00 31.40           C  
ATOM   1526  CG1 ILE A 193      19.185  34.296   6.716  1.00 30.85           C  
ATOM   1527  CG2 ILE A 193      17.565  35.926   5.857  1.00 30.91           C  
ATOM   1528  CD1 ILE A 193      20.198  33.249   6.474  1.00 30.79           C  
ATOM   1529  N   VAL A 194      16.644  34.556   2.960  1.00 31.94           N  
ATOM   1530  CA  VAL A 194      15.629  35.123   2.083  1.00 31.67           C  
ATOM   1531  C   VAL A 194      14.447  34.180   1.867  1.00 32.45           C  
ATOM   1532  O   VAL A 194      13.298  34.585   2.026  1.00 33.30           O  
ATOM   1533  CB  VAL A 194      16.217  35.513   0.717  1.00 30.32           C  
ATOM   1534  CG1 VAL A 194      15.111  35.957  -0.219  1.00 29.77           C  
ATOM   1535  CG2 VAL A 194      17.214  36.617   0.889  1.00 27.93           C  
ATOM   1536  N   LYS A 195      14.715  32.929   1.505  1.00 32.73           N  
ATOM   1537  CA  LYS A 195      13.628  31.981   1.292  1.00 33.90           C  
ATOM   1538  C   LYS A 195      12.729  31.913   2.516  1.00 35.12           C  
ATOM   1539  O   LYS A 195      11.511  31.879   2.397  1.00 35.57           O  
ATOM   1540  CB  LYS A 195      14.168  30.582   0.996  1.00 32.90           C  
ATOM   1541  CG  LYS A 195      13.085  29.545   0.756  1.00 32.64           C  
ATOM   1542  CD  LYS A 195      13.656  28.204   0.324  1.00 33.19           C  
ATOM   1543  CE  LYS A 195      12.557  27.161   0.101  1.00 35.32           C  
ATOM   1544  NZ  LYS A 195      11.809  26.812   1.347  1.00 35.49           N  
ATOM   1545  N   HIS A 196      13.334  31.901   3.696  1.00 36.70           N  
ATOM   1546  CA  HIS A 196      12.578  31.822   4.934  1.00 37.61           C  
ATOM   1547  C   HIS A 196      11.732  33.064   5.185  1.00 36.96           C  
ATOM   1548  O   HIS A 196      10.552  32.964   5.497  1.00 36.19           O  
ATOM   1549  CB  HIS A 196      13.523  31.613   6.110  1.00 40.34           C  
ATOM   1550  CG  HIS A 196      12.819  31.490   7.422  1.00 43.22           C  
ATOM   1551  ND1 HIS A 196      12.068  30.384   7.760  1.00 43.66           N  
ATOM   1552  CD2 HIS A 196      12.732  32.342   8.472  1.00 45.18           C  
ATOM   1553  CE1 HIS A 196      11.552  30.560   8.963  1.00 45.82           C  
ATOM   1554  NE2 HIS A 196      11.937  31.740   9.417  1.00 46.79           N  
ATOM   1555  N   LEU A 197      12.352  34.232   5.063  1.00 37.22           N  
ATOM   1556  CA  LEU A 197      11.663  35.499   5.280  1.00 37.44           C  
ATOM   1557  C   LEU A 197      10.486  35.675   4.331  1.00 38.06           C  
ATOM   1558  O   LEU A 197       9.380  35.985   4.757  1.00 38.32           O  
ATOM   1559  CB  LEU A 197      12.620  36.676   5.080  1.00 35.89           C  
ATOM   1560  CG  LEU A 197      13.708  36.962   6.102  1.00 34.95           C  
ATOM   1561  CD1 LEU A 197      14.583  38.097   5.584  1.00 32.71           C  
ATOM   1562  CD2 LEU A 197      13.074  37.312   7.439  1.00 32.77           C  
ATOM   1563  N   GLU A 198      10.735  35.476   3.043  1.00 38.47           N  
ATOM   1564  CA  GLU A 198       9.709  35.649   2.029  1.00 39.02           C  
ATOM   1565  C   GLU A 198       8.863  34.426   1.743  1.00 39.00           C  
ATOM   1566  O   GLU A 198       7.948  34.486   0.929  1.00 39.51           O  
ATOM   1567  CB  GLU A 198      10.350  36.126   0.730  1.00 39.44           C  
ATOM   1568  CG  GLU A 198      10.991  37.492   0.834  1.00 38.24           C  
ATOM   1569  CD  GLU A 198      11.495  37.978  -0.499  1.00 39.02           C  
ATOM   1570  OE1 GLU A 198      11.054  37.434  -1.537  1.00 38.34           O  
ATOM   1571  OE2 GLU A 198      12.322  38.908  -0.507  1.00 40.29           O  
ATOM   1572  N   GLY A 199       9.165  33.323   2.411  1.00 39.38           N  
ATOM   1573  CA  GLY A 199       8.407  32.108   2.189  1.00 40.76           C  
ATOM   1574  C   GLY A 199       8.347  31.723   0.721  1.00 41.23           C  
ATOM   1575  O   GLY A 199       7.310  31.275   0.230  1.00 42.58           O  
ATOM   1576  N   LEU A 200       9.455  31.896   0.011  1.00 40.58           N  
ATOM   1577  CA  LEU A 200       9.501  31.557  -1.403  1.00 40.88           C  
ATOM   1578  C   LEU A 200       9.519  30.054  -1.620  1.00 41.02           C  
ATOM   1579  O   LEU A 200       9.941  29.295  -0.753  1.00 41.14           O  
ATOM   1580  CB  LEU A 200      10.743  32.161  -2.048  1.00 41.00           C  
ATOM   1581  CG  LEU A 200      10.917  33.670  -1.896  1.00 40.86           C  
ATOM   1582  CD1 LEU A 200      12.210  34.100  -2.569  1.00 40.33           C  
ATOM   1583  CD2 LEU A 200       9.732  34.386  -2.508  1.00 40.42           C  
ATOM   1584  N   SER A 201       9.061  29.637  -2.793  1.00 41.90           N  
ATOM   1585  CA  SER A 201       9.031  28.225  -3.146  1.00 42.98           C  
ATOM   1586  C   SER A 201      10.440  27.787  -3.513  1.00 43.75           C  
ATOM   1587  O   SER A 201      11.321  28.619  -3.720  1.00 43.92           O  
ATOM   1588  CB  SER A 201       8.121  28.003  -4.348  1.00 42.46           C  
ATOM   1589  OG  SER A 201       8.684  28.596  -5.501  1.00 41.12           O  
ATOM   1590  N   GLU A 202      10.653  26.481  -3.604  1.00 44.42           N  
ATOM   1591  CA  GLU A 202      11.965  25.980  -3.966  1.00 44.55           C  
ATOM   1592  C   GLU A 202      12.296  26.476  -5.360  1.00 44.62           C  
ATOM   1593  O   GLU A 202      13.398  26.969  -5.608  1.00 44.79           O  
ATOM   1594  CB  GLU A 202      11.973  24.460  -3.937  1.00 44.04           C  
ATOM   1595  CG  GLU A 202      11.409  23.912  -2.658  1.00 44.94           C  
ATOM   1596  CD  GLU A 202      11.514  22.418  -2.583  1.00 46.65           C  
ATOM   1597  OE1 GLU A 202      11.278  21.758  -3.617  1.00 48.18           O  
ATOM   1598  OE2 GLU A 202      11.823  21.903  -1.487  1.00 47.64           O  
ATOM   1599  N   GLU A 203      11.345  26.334  -6.277  1.00 44.44           N  
ATOM   1600  CA  GLU A 203      11.586  26.794  -7.633  1.00 44.63           C  
ATOM   1601  C   GLU A 203      11.944  28.283  -7.535  1.00 44.54           C  
ATOM   1602  O   GLU A 203      12.902  28.747  -8.145  1.00 44.51           O  
ATOM   1603  CB  GLU A 203      10.335  26.570  -8.512  1.00 42.79           C  
ATOM   1604  N   ALA A 204      11.199  29.013  -6.717  1.00 44.96           N  
ATOM   1605  CA  ALA A 204      11.430  30.442  -6.544  1.00 45.39           C  
ATOM   1606  C   ALA A 204      12.863  30.798  -6.192  1.00 45.38           C  
ATOM   1607  O   ALA A 204      13.569  31.431  -6.983  1.00 46.20           O  
ATOM   1608  CB  ALA A 204      10.490  31.002  -5.473  1.00 45.59           C  
ATOM   1609  N   ILE A 205      13.290  30.391  -5.002  1.00 44.65           N  
ATOM   1610  CA  ILE A 205      14.630  30.722  -4.540  1.00 44.41           C  
ATOM   1611  C   ILE A 205      15.760  30.196  -5.410  1.00 44.47           C  
ATOM   1612  O   ILE A 205      16.870  30.719  -5.374  1.00 42.71           O  
ATOM   1613  CB  ILE A 205      14.859  30.247  -3.106  1.00 43.22           C  
ATOM   1614  CG1 ILE A 205      16.040  31.011  -2.532  1.00 42.71           C  
ATOM   1615  CG2 ILE A 205      15.093  28.738  -3.066  1.00 41.36           C  
ATOM   1616  CD1 ILE A 205      16.427  30.569  -1.167  1.00 46.09           C  
ATOM   1617  N   MET A 206      15.477  29.161  -6.187  1.00 46.22           N  
ATOM   1618  CA  MET A 206      16.482  28.592  -7.070  1.00 48.19           C  
ATOM   1619  C   MET A 206      16.838  29.600  -8.153  1.00 47.49           C  
ATOM   1620  O   MET A 206      17.980  29.655  -8.602  1.00 47.69           O  
ATOM   1621  CB  MET A 206      15.959  27.321  -7.744  1.00 51.91           C  
ATOM   1622  CG  MET A 206      15.882  26.069  -6.875  1.00 55.33           C  
ATOM   1623  SD  MET A 206      15.592  24.603  -7.936  1.00 60.83           S  
ATOM   1624  CE  MET A 206      13.851  24.265  -7.646  1.00 60.38           C  
ATOM   1625  N   GLU A 207      15.848  30.393  -8.564  1.00 46.99           N  
ATOM   1626  CA  GLU A 207      16.020  31.401  -9.614  1.00 46.30           C  
ATOM   1627  C   GLU A 207      16.570  32.720  -9.077  1.00 45.83           C  
ATOM   1628  O   GLU A 207      17.290  33.444  -9.768  1.00 45.92           O  
ATOM   1629  CB  GLU A 207      14.689  31.639 -10.320  1.00 46.35           C  
ATOM   1630  N   LEU A 208      16.220  33.031  -7.841  1.00 45.65           N  
ATOM   1631  CA  LEU A 208      16.688  34.248  -7.204  1.00 45.17           C  
ATOM   1632  C   LEU A 208      18.208  34.301  -7.069  1.00 45.41           C  
ATOM   1633  O   LEU A 208      18.844  33.354  -6.604  1.00 46.04           O  
ATOM   1634  CB  LEU A 208      16.066  34.375  -5.815  1.00 44.51           C  
ATOM   1635  CG  LEU A 208      16.616  35.522  -4.962  1.00 44.71           C  
ATOM   1636  CD1 LEU A 208      16.314  36.854  -5.632  1.00 44.43           C  
ATOM   1637  CD2 LEU A 208      16.005  35.468  -3.578  1.00 44.23           C  
ATOM   1638  N   ASN A 209      18.789  35.420  -7.479  1.00 45.57           N  
ATOM   1639  CA  ASN A 209      20.228  35.615  -7.361  1.00 45.92           C  
ATOM   1640  C   ASN A 209      20.506  36.978  -6.752  1.00 44.12           C  
ATOM   1641  O   ASN A 209      20.423  38.001  -7.427  1.00 44.75           O  
ATOM   1642  CB  ASN A 209      20.911  35.507  -8.720  1.00 49.87           C  
ATOM   1643  CG  ASN A 209      21.443  34.116  -8.983  1.00 53.21           C  
ATOM   1644  OD1 ASN A 209      20.689  33.201  -9.337  1.00 54.37           O  
ATOM   1645  ND2 ASN A 209      22.752  33.940  -8.788  1.00 55.46           N  
ATOM   1646  N   LEU A 210      20.834  36.985  -5.468  1.00 41.17           N  
ATOM   1647  CA  LEU A 210      21.097  38.224  -4.772  1.00 38.04           C  
ATOM   1648  C   LEU A 210      22.308  38.931  -5.348  1.00 37.69           C  
ATOM   1649  O   LEU A 210      23.282  38.300  -5.755  1.00 38.23           O  
ATOM   1650  CB  LEU A 210      21.290  37.943  -3.290  1.00 37.88           C  
ATOM   1651  CG  LEU A 210      20.078  37.255  -2.657  1.00 38.34           C  
ATOM   1652  CD1 LEU A 210      20.387  36.804  -1.230  1.00 37.85           C  
ATOM   1653  CD2 LEU A 210      18.915  38.212  -2.680  1.00 37.43           C  
ATOM   1654  N   PRO A 211      22.259  40.263  -5.405  1.00 36.53           N  
ATOM   1655  CA  PRO A 211      23.350  41.080  -5.937  1.00 35.89           C  
ATOM   1656  C   PRO A 211      24.527  40.995  -4.998  1.00 35.36           C  
ATOM   1657  O   PRO A 211      24.347  40.771  -3.813  1.00 36.00           O  
ATOM   1658  CB  PRO A 211      22.760  42.489  -5.949  1.00 35.42           C  
ATOM   1659  CG  PRO A 211      21.293  42.262  -5.952  1.00 37.63           C  
ATOM   1660  CD  PRO A 211      21.130  41.110  -5.013  1.00 36.24           C  
ATOM   1661  N   THR A 212      25.734  41.182  -5.509  1.00 35.22           N  
ATOM   1662  CA  THR A 212      26.894  41.132  -4.641  1.00 34.83           C  
ATOM   1663  C   THR A 212      27.326  42.539  -4.234  1.00 36.04           C  
ATOM   1664  O   THR A 212      27.157  43.501  -4.987  1.00 36.63           O  
ATOM   1665  CB  THR A 212      28.060  40.417  -5.326  1.00 33.92           C  
ATOM   1666  OG1 THR A 212      28.358  41.063  -6.564  1.00 34.78           O  
ATOM   1667  CG2 THR A 212      27.700  38.970  -5.601  1.00 33.15           C  
ATOM   1668  N   GLY A 213      27.856  42.653  -3.020  1.00 36.17           N  
ATOM   1669  CA  GLY A 213      28.331  43.932  -2.525  1.00 35.71           C  
ATOM   1670  C   GLY A 213      27.273  44.979  -2.277  1.00 36.53           C  
ATOM   1671  O   GLY A 213      27.582  46.054  -1.765  1.00 37.98           O  
ATOM   1672  N   ILE A 214      26.024  44.684  -2.619  1.00 36.11           N  
ATOM   1673  CA  ILE A 214      24.955  45.651  -2.412  1.00 35.87           C  
ATOM   1674  C   ILE A 214      24.132  45.379  -1.158  1.00 35.45           C  
ATOM   1675  O   ILE A 214      23.629  44.274  -0.953  1.00 35.79           O  
ATOM   1676  CB  ILE A 214      24.020  45.690  -3.620  1.00 36.54           C  
ATOM   1677  CG1 ILE A 214      24.837  46.003  -4.872  1.00 40.34           C  
ATOM   1678  CG2 ILE A 214      22.961  46.750  -3.424  1.00 35.93           C  
ATOM   1679  CD1 ILE A 214      24.070  45.892  -6.176  1.00 42.21           C  
ATOM   1680  N   PRO A 215      23.998  46.392  -0.290  1.00 34.56           N  
ATOM   1681  CA  PRO A 215      23.224  46.235   0.942  1.00 33.50           C  
ATOM   1682  C   PRO A 215      21.775  45.903   0.607  1.00 32.71           C  
ATOM   1683  O   PRO A 215      21.116  46.641  -0.118  1.00 32.18           O  
ATOM   1684  CB  PRO A 215      23.353  47.602   1.612  1.00 32.95           C  
ATOM   1685  CG  PRO A 215      24.681  48.091   1.136  1.00 33.39           C  
ATOM   1686  CD  PRO A 215      24.670  47.702  -0.325  1.00 34.21           C  
ATOM   1687  N   ILE A 216      21.294  44.781   1.126  1.00 32.27           N  
ATOM   1688  CA  ILE A 216      19.920  44.366   0.903  1.00 30.85           C  
ATOM   1689  C   ILE A 216      19.158  44.708   2.168  1.00 31.34           C  
ATOM   1690  O   ILE A 216      19.463  44.184   3.240  1.00 31.61           O  
ATOM   1691  CB  ILE A 216      19.837  42.859   0.642  1.00 29.83           C  
ATOM   1692  CG1 ILE A 216      20.659  42.518  -0.599  1.00 30.05           C  
ATOM   1693  CG2 ILE A 216      18.396  42.442   0.446  1.00 29.04           C  
ATOM   1694  CD1 ILE A 216      20.632  41.054  -0.977  1.00 29.59           C  
ATOM   1695  N   VAL A 217      18.173  45.596   2.045  1.00 31.75           N  
ATOM   1696  CA  VAL A 217      17.389  46.021   3.200  1.00 31.88           C  
ATOM   1697  C   VAL A 217      16.006  45.400   3.286  1.00 32.47           C  
ATOM   1698  O   VAL A 217      15.249  45.413   2.324  1.00 33.18           O  
ATOM   1699  CB  VAL A 217      17.222  47.549   3.223  1.00 30.19           C  
ATOM   1700  CG1 VAL A 217      16.605  47.978   4.538  1.00 29.96           C  
ATOM   1701  CG2 VAL A 217      18.567  48.220   3.034  1.00 31.25           C  
ATOM   1702  N   TYR A 218      15.689  44.848   4.450  1.00 33.48           N  
ATOM   1703  CA  TYR A 218      14.385  44.251   4.695  1.00 35.05           C  
ATOM   1704  C   TYR A 218      13.713  45.021   5.816  1.00 36.87           C  
ATOM   1705  O   TYR A 218      14.374  45.455   6.754  1.00 37.25           O  
ATOM   1706  CB  TYR A 218      14.507  42.792   5.140  1.00 34.45           C  
ATOM   1707  CG  TYR A 218      14.478  41.776   4.029  1.00 35.06           C  
ATOM   1708  CD1 TYR A 218      15.654  41.241   3.507  1.00 35.25           C  
ATOM   1709  CD2 TYR A 218      13.271  41.346   3.494  1.00 35.42           C  
ATOM   1710  CE1 TYR A 218      15.625  40.297   2.480  1.00 35.63           C  
ATOM   1711  CE2 TYR A 218      13.231  40.409   2.465  1.00 36.18           C  
ATOM   1712  CZ  TYR A 218      14.408  39.889   1.964  1.00 35.83           C  
ATOM   1713  OH  TYR A 218      14.365  38.970   0.944  1.00 36.14           O  
ATOM   1714  N   GLU A 219      12.402  45.206   5.706  1.00 38.69           N  
ATOM   1715  CA  GLU A 219      11.639  45.878   6.742  1.00 39.35           C  
ATOM   1716  C   GLU A 219      10.659  44.825   7.209  1.00 40.02           C  
ATOM   1717  O   GLU A 219       9.766  44.419   6.470  1.00 39.60           O  
ATOM   1718  CB  GLU A 219      10.923  47.106   6.185  1.00 40.81           C  
ATOM   1719  CG  GLU A 219      11.835  48.314   6.084  1.00 44.75           C  
ATOM   1720  CD  GLU A 219      11.142  49.542   5.545  1.00 47.41           C  
ATOM   1721  OE1 GLU A 219      10.066  49.903   6.075  1.00 49.41           O  
ATOM   1722  OE2 GLU A 219      11.682  50.154   4.596  1.00 49.39           O  
ATOM   1723  N   LEU A 220      10.852  44.360   8.435  1.00 41.20           N  
ATOM   1724  CA  LEU A 220      10.007  43.319   8.991  1.00 42.78           C  
ATOM   1725  C   LEU A 220       9.000  43.825  10.025  1.00 44.23           C  
ATOM   1726  O   LEU A 220       9.259  44.792  10.745  1.00 44.62           O  
ATOM   1727  CB  LEU A 220      10.894  42.243   9.625  1.00 42.49           C  
ATOM   1728  CG  LEU A 220      12.138  41.812   8.847  1.00 40.63           C  
ATOM   1729  CD1 LEU A 220      12.866  40.750   9.636  1.00 40.42           C  
ATOM   1730  CD2 LEU A 220      11.754  41.283   7.485  1.00 40.77           C  
ATOM   1731  N   ASP A 221       7.850  43.159  10.094  1.00 45.62           N  
ATOM   1732  CA  ASP A 221       6.820  43.514  11.055  1.00 45.90           C  
ATOM   1733  C   ASP A 221       7.059  42.748  12.351  1.00 46.30           C  
ATOM   1734  O   ASP A 221       8.051  42.039  12.492  1.00 45.63           O  
ATOM   1735  CB  ASP A 221       5.431  43.175  10.507  1.00 46.58           C  
ATOM   1736  CG  ASP A 221       5.262  41.695  10.182  1.00 48.06           C  
ATOM   1737  OD1 ASP A 221       5.772  40.840  10.946  1.00 46.76           O  
ATOM   1738  OD2 ASP A 221       4.598  41.389   9.162  1.00 49.04           O  
ATOM   1739  N   LYS A 222       6.130  42.885  13.286  1.00 47.44           N  
ATOM   1740  CA  LYS A 222       6.216  42.219  14.576  1.00 47.97           C  
ATOM   1741  C   LYS A 222       6.569  40.740  14.467  1.00 48.95           C  
ATOM   1742  O   LYS A 222       7.073  40.159  15.431  1.00 50.07           O  
ATOM   1743  CB  LYS A 222       4.909  42.385  15.330  1.00 47.13           C  
ATOM   1744  N   ASN A 223       6.319  40.131  13.308  1.00 49.17           N  
ATOM   1745  CA  ASN A 223       6.627  38.707  13.121  1.00 49.77           C  
ATOM   1746  C   ASN A 223       7.627  38.408  12.004  1.00 49.23           C  
ATOM   1747  O   ASN A 223       7.416  37.524  11.166  1.00 48.72           O  
ATOM   1748  CB  ASN A 223       5.343  37.930  12.867  1.00 51.74           C  
ATOM   1749  CG  ASN A 223       4.423  37.951  14.054  1.00 52.32           C  
ATOM   1750  OD1 ASN A 223       4.743  37.409  15.120  1.00 52.98           O  
ATOM   1751  ND2 ASN A 223       3.272  38.589  13.888  1.00 52.60           N  
ATOM   1752  N   LEU A 224       8.724  39.151  12.018  1.00 47.82           N  
ATOM   1753  CA  LEU A 224       9.776  39.008  11.035  1.00 45.36           C  
ATOM   1754  C   LEU A 224       9.287  38.794   9.605  1.00 44.50           C  
ATOM   1755  O   LEU A 224       9.982  38.208   8.791  1.00 44.62           O  
ATOM   1756  CB  LEU A 224      10.717  37.889  11.458  1.00 44.58           C  
ATOM   1757  CG  LEU A 224      11.346  38.083  12.845  1.00 44.74           C  
ATOM   1758  CD1 LEU A 224      12.662  37.324  12.891  1.00 45.20           C  
ATOM   1759  CD2 LEU A 224      11.600  39.551  13.137  1.00 43.44           C  
ATOM   1760  N   LYS A 225       8.087  39.273   9.297  1.00 44.55           N  
ATOM   1761  CA  LYS A 225       7.566  39.156   7.945  1.00 44.65           C  
ATOM   1762  C   LYS A 225       7.874  40.451   7.183  1.00 44.11           C  
ATOM   1763  O   LYS A 225       7.491  41.539   7.607  1.00 43.36           O  
ATOM   1764  CB  LYS A 225       6.058  38.924   7.968  1.00 46.25           C  
ATOM   1765  CG  LYS A 225       5.430  39.069   6.589  1.00 48.53           C  
ATOM   1766  CD  LYS A 225       3.974  38.637   6.548  1.00 49.51           C  
ATOM   1767  CE  LYS A 225       3.483  38.616   5.104  1.00 50.35           C  
ATOM   1768  NZ  LYS A 225       2.184  37.910   4.940  1.00 52.10           N  
ATOM   1769  N   PRO A 226       8.576  40.350   6.045  1.00 43.58           N  
ATOM   1770  CA  PRO A 226       8.904  41.552   5.271  1.00 43.65           C  
ATOM   1771  C   PRO A 226       7.619  42.281   4.930  1.00 44.02           C  
ATOM   1772  O   PRO A 226       6.610  41.629   4.667  1.00 45.45           O  
ATOM   1773  CB  PRO A 226       9.568  40.986   4.016  1.00 42.87           C  
ATOM   1774  CG  PRO A 226      10.153  39.687   4.491  1.00 42.69           C  
ATOM   1775  CD  PRO A 226       9.051  39.140   5.359  1.00 43.53           C  
ATOM   1776  N   ILE A 227       7.635  43.613   4.937  1.00 43.04           N  
ATOM   1777  CA  ILE A 227       6.424  44.343   4.587  1.00 42.54           C  
ATOM   1778  C   ILE A 227       6.515  44.855   3.150  1.00 43.02           C  
ATOM   1779  O   ILE A 227       5.536  45.339   2.585  1.00 44.60           O  
ATOM   1780  CB  ILE A 227       6.150  45.527   5.547  1.00 42.05           C  
ATOM   1781  CG1 ILE A 227       7.033  46.722   5.194  1.00 42.51           C  
ATOM   1782  CG2 ILE A 227       6.402  45.100   6.985  1.00 42.29           C  
ATOM   1783  CD1 ILE A 227       6.619  48.015   5.891  1.00 41.84           C  
ATOM   1784  N   LYS A 228       7.695  44.742   2.556  1.00 43.06           N  
ATOM   1785  CA  LYS A 228       7.897  45.174   1.175  1.00 43.54           C  
ATOM   1786  C   LYS A 228       9.048  44.414   0.517  1.00 43.50           C  
ATOM   1787  O   LYS A 228       9.834  43.742   1.191  1.00 43.97           O  
ATOM   1788  CB  LYS A 228       8.158  46.686   1.111  1.00 43.67           C  
ATOM   1789  CG  LYS A 228       8.769  47.282   2.363  1.00 45.33           C  
ATOM   1790  CD  LYS A 228       9.586  48.544   2.073  1.00 45.99           C  
ATOM   1791  CE  LYS A 228       8.760  49.682   1.501  1.00 46.11           C  
ATOM   1792  NZ  LYS A 228       9.608  50.903   1.330  1.00 45.98           N  
ATOM   1793  N   PRO A 229       9.160  44.501  -0.815  1.00 43.34           N  
ATOM   1794  CA  PRO A 229      10.269  43.769  -1.427  1.00 43.09           C  
ATOM   1795  C   PRO A 229      11.616  44.301  -0.974  1.00 42.25           C  
ATOM   1796  O   PRO A 229      11.733  45.450  -0.562  1.00 42.71           O  
ATOM   1797  CB  PRO A 229      10.033  43.971  -2.927  1.00 43.41           C  
ATOM   1798  CG  PRO A 229       9.370  45.309  -2.987  1.00 43.33           C  
ATOM   1799  CD  PRO A 229       8.386  45.235  -1.834  1.00 43.28           C  
ATOM   1800  N   MET A 230      12.633  43.456  -1.048  1.00 42.42           N  
ATOM   1801  CA  MET A 230      13.972  43.860  -0.650  1.00 42.28           C  
ATOM   1802  C   MET A 230      14.432  45.067  -1.483  1.00 42.49           C  
ATOM   1803  O   MET A 230      14.248  45.093  -2.702  1.00 43.68           O  
ATOM   1804  CB  MET A 230      14.942  42.695  -0.847  1.00 42.07           C  
ATOM   1805  CG  MET A 230      15.092  42.259  -2.288  1.00 40.67           C  
ATOM   1806  SD  MET A 230      16.395  41.047  -2.518  1.00 41.58           S  
ATOM   1807  CE  MET A 230      15.530  39.540  -2.019  1.00 40.40           C  
ATOM   1808  N   GLN A 231      14.990  46.076  -0.813  1.00 40.94           N  
ATOM   1809  CA  GLN A 231      15.494  47.273  -1.479  1.00 38.92           C  
ATOM   1810  C   GLN A 231      17.021  47.193  -1.482  1.00 38.75           C  
ATOM   1811  O   GLN A 231      17.617  46.531  -0.634  1.00 38.65           O  
ATOM   1812  CB  GLN A 231      15.032  48.515  -0.744  1.00 37.72           C  
ATOM   1813  N   PHE A 232      17.653  47.863  -2.436  1.00 38.40           N  
ATOM   1814  CA  PHE A 232      19.108  47.846  -2.545  1.00 37.96           C  
ATOM   1815  C   PHE A 232      19.657  49.250  -2.315  1.00 38.88           C  
ATOM   1816  O   PHE A 232      19.037  50.230  -2.716  1.00 39.08           O  
ATOM   1817  CB  PHE A 232      19.504  47.347  -3.937  1.00 37.30           C  
ATOM   1818  CG  PHE A 232      18.985  45.963  -4.271  1.00 37.59           C  
ATOM   1819  CD1 PHE A 232      18.650  45.628  -5.581  1.00 37.36           C  
ATOM   1820  CD2 PHE A 232      18.841  44.991  -3.284  1.00 37.14           C  
ATOM   1821  CE1 PHE A 232      18.180  44.348  -5.902  1.00 36.38           C  
ATOM   1822  CE2 PHE A 232      18.375  43.716  -3.600  1.00 37.14           C  
ATOM   1823  CZ  PHE A 232      18.044  43.396  -4.912  1.00 35.66           C  
ATOM   1824  N   LEU A 233      20.815  49.358  -1.673  1.00 40.52           N  
ATOM   1825  CA  LEU A 233      21.398  50.673  -1.413  1.00 42.02           C  
ATOM   1826  C   LEU A 233      22.575  51.039  -2.301  1.00 44.67           C  
ATOM   1827  O   LEU A 233      23.412  50.204  -2.628  1.00 44.46           O  
ATOM   1828  CB  LEU A 233      21.819  50.792   0.045  1.00 39.78           C  
ATOM   1829  CG  LEU A 233      20.658  50.817   1.032  1.00 39.39           C  
ATOM   1830  CD1 LEU A 233      21.181  51.100   2.424  1.00 39.24           C  
ATOM   1831  CD2 LEU A 233      19.668  51.883   0.621  1.00 38.46           C  
ATOM   1832  N   GLY A 234      22.625  52.310  -2.681  1.00 48.93           N  
ATOM   1833  CA  GLY A 234      23.694  52.799  -3.535  1.00 54.07           C  
ATOM   1834  C   GLY A 234      23.188  53.730  -4.627  1.00 57.51           C  
ATOM   1835  O   GLY A 234      21.975  53.932  -4.781  1.00 57.79           O  
ATOM   1836  N   ASP A 235      24.124  54.303  -5.382  1.00 60.25           N  
ATOM   1837  CA  ASP A 235      23.802  55.213  -6.482  1.00 63.38           C  
ATOM   1838  C   ASP A 235      22.918  54.517  -7.520  1.00 64.71           C  
ATOM   1839  O   ASP A 235      22.995  53.297  -7.696  1.00 65.97           O  
ATOM   1840  CB  ASP A 235      25.094  55.688  -7.142  1.00 64.82           C  
ATOM   1841  CG  ASP A 235      26.047  54.543  -7.429  1.00 66.02           C  
ATOM   1842  OD1 ASP A 235      25.650  53.620  -8.173  1.00 66.56           O  
ATOM   1843  OD2 ASP A 235      27.185  54.561  -6.909  1.00 66.27           O  
ATOM   1844  N   GLU A 236      22.093  55.297  -8.214  1.00 65.24           N  
ATOM   1845  CA  GLU A 236      21.177  54.754  -9.214  1.00 65.40           C  
ATOM   1846  C   GLU A 236      21.800  53.699 -10.123  1.00 65.48           C  
ATOM   1847  O   GLU A 236      21.343  52.559 -10.154  1.00 65.33           O  
ATOM   1848  CB  GLU A 236      20.592  55.884 -10.055  1.00 65.58           C  
ATOM   1849  N   GLU A 237      22.846  54.074 -10.850  1.00 66.18           N  
ATOM   1850  CA  GLU A 237      23.497  53.148 -11.774  1.00 67.15           C  
ATOM   1851  C   GLU A 237      23.778  51.787 -11.140  1.00 66.49           C  
ATOM   1852  O   GLU A 237      23.718  50.753 -11.814  1.00 66.47           O  
ATOM   1853  CB  GLU A 237      24.804  53.749 -12.306  1.00 68.74           C  
ATOM   1854  CG  GLU A 237      25.910  53.847 -11.267  1.00 72.04           C  
ATOM   1855  CD  GLU A 237      27.236  54.303 -11.858  1.00 73.53           C  
ATOM   1856  OE1 GLU A 237      27.346  55.492 -12.228  1.00 74.74           O  
ATOM   1857  OE2 GLU A 237      28.166  53.467 -11.954  1.00 73.84           O  
ATOM   1858  N   THR A 238      24.085  51.783  -9.847  1.00 65.37           N  
ATOM   1859  CA  THR A 238      24.361  50.530  -9.154  1.00 64.10           C  
ATOM   1860  C   THR A 238      23.061  49.826  -8.798  1.00 63.32           C  
ATOM   1861  O   THR A 238      22.820  48.700  -9.226  1.00 63.31           O  
ATOM   1862  CB  THR A 238      25.165  50.752  -7.856  1.00 63.67           C  
ATOM   1863  OG1 THR A 238      26.437  51.324  -8.174  1.00 63.28           O  
ATOM   1864  CG2 THR A 238      25.384  49.427  -7.133  1.00 63.21           C  
ATOM   1865  N   VAL A 239      22.223  50.497  -8.017  1.00 62.40           N  
ATOM   1866  CA  VAL A 239      20.957  49.918  -7.608  1.00 61.95           C  
ATOM   1867  C   VAL A 239      20.108  49.542  -8.816  1.00 62.14           C  
ATOM   1868  O   VAL A 239      19.582  48.438  -8.879  1.00 61.76           O  
ATOM   1869  CB  VAL A 239      20.180  50.885  -6.663  1.00 61.93           C  
ATOM   1870  CG1 VAL A 239      20.289  52.307  -7.166  1.00 61.91           C  
ATOM   1871  CG2 VAL A 239      18.721  50.473  -6.565  1.00 60.92           C  
ATOM   1872  N   ARG A 240      19.996  50.447  -9.783  1.00 63.21           N  
ATOM   1873  CA  ARG A 240      19.202  50.191 -10.983  1.00 64.18           C  
ATOM   1874  C   ARG A 240      19.702  48.971 -11.751  1.00 65.41           C  
ATOM   1875  O   ARG A 240      18.907  48.137 -12.183  1.00 65.55           O  
ATOM   1876  CB  ARG A 240      19.214  51.412 -11.888  1.00 63.50           C  
ATOM   1877  N   LYS A 241      21.019  48.877 -11.923  1.00 66.74           N  
ATOM   1878  CA  LYS A 241      21.629  47.756 -12.635  1.00 68.06           C  
ATOM   1879  C   LYS A 241      21.231  46.426 -11.991  1.00 69.77           C  
ATOM   1880  O   LYS A 241      20.777  45.505 -12.678  1.00 70.41           O  
ATOM   1881  CB  LYS A 241      23.157  47.904 -12.646  1.00 66.55           C  
ATOM   1882  N   ALA A 242      21.402  46.335 -10.671  1.00 71.08           N  
ATOM   1883  CA  ALA A 242      21.069  45.126  -9.917  1.00 71.61           C  
ATOM   1884  C   ALA A 242      19.568  45.044  -9.665  1.00 72.23           C  
ATOM   1885  O   ALA A 242      19.040  43.975  -9.366  1.00 71.66           O  
ATOM   1886  CB  ALA A 242      21.822  45.111  -8.595  1.00 71.53           C  
ATOM   1887  N   MET A 243      18.892  46.184  -9.778  1.00 73.54           N  
ATOM   1888  CA  MET A 243      17.443  46.249  -9.597  1.00 75.26           C  
ATOM   1889  C   MET A 243      16.807  45.490 -10.754  1.00 76.69           C  
ATOM   1890  O   MET A 243      15.917  44.661 -10.556  1.00 76.55           O  
ATOM   1891  CB  MET A 243      16.959  47.705  -9.629  1.00 74.69           C  
ATOM   1892  CG  MET A 243      16.499  48.262  -8.288  1.00 74.27           C  
ATOM   1893  SD  MET A 243      14.947  47.540  -7.699  1.00 74.63           S  
ATOM   1894  CE  MET A 243      15.526  46.166  -6.690  1.00 73.59           C  
ATOM   1895  N   GLU A 244      17.289  45.786 -11.960  1.00 78.38           N  
ATOM   1896  CA  GLU A 244      16.801  45.165 -13.190  1.00 79.73           C  
ATOM   1897  C   GLU A 244      16.935  43.643 -13.235  1.00 80.31           C  
ATOM   1898  O   GLU A 244      16.242  42.978 -14.015  1.00 80.85           O  
ATOM   1899  CB  GLU A 244      17.513  45.782 -14.398  1.00 79.64           C  
ATOM   1900  CG  GLU A 244      17.085  47.207 -14.694  1.00 80.18           C  
ATOM   1901  CD  GLU A 244      17.820  47.793 -15.876  1.00 80.78           C  
ATOM   1902  OE1 GLU A 244      17.908  47.103 -16.913  1.00 81.68           O  
ATOM   1903  OE2 GLU A 244      18.305  48.942 -15.772  1.00 80.65           O  
ATOM   1904  N   ALA A 245      17.823  43.094 -12.408  1.00 80.35           N  
ATOM   1905  CA  ALA A 245      18.024  41.651 -12.354  1.00 80.01           C  
ATOM   1906  C   ALA A 245      16.680  40.961 -12.097  1.00 80.55           C  
ATOM   1907  O   ALA A 245      16.202  40.189 -12.934  1.00 80.64           O  
ATOM   1908  CB  ALA A 245      19.020  41.303 -11.255  1.00 79.27           C  
ATOM   1909  N   VAL A 246      16.069  41.254 -10.947  1.00 80.40           N  
ATOM   1910  CA  VAL A 246      14.778  40.668 -10.586  1.00 80.65           C  
ATOM   1911  C   VAL A 246      13.756  40.845 -11.709  1.00 80.89           C  
ATOM   1912  O   VAL A 246      13.698  40.045 -12.649  1.00 81.55           O  
ATOM   1913  CB  VAL A 246      14.255  41.303  -9.301  1.00 79.73           C  
TER    1914      VAL A 246                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
